       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02025.                                     
COB303 DATE-WRITTEN.      FEBRUARY 1, 1995                              
       DATE-COMPILED.                                                   
                                                                        
      ***************************************************************** 00015000
      *                                                               * 00016000
      *                SOUTH CAROLINA ELECTRIC & GAS                  * 00017000
      *                                                               * 00018000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).  * 00019000
      *                                                               * 00019100
      *  TRANID:        S025                                          * 00019200
      *  PROGRAM:       S025                                          * 00019300
      *  CALLING SP:    PA_S025                                       * 00019400
      *                                                               * 00019500
      ***************************************************************** 00019600
      *                 PROGRAM SUMMARY                               * 00019700
      *                                                               * 00019800
      * THIS PROGRAM CONTROLS THE SERVICE ORDER POSTING PROCESS.      * 00019900
      * ONCE THE SERVICE ORDER HAS BEEN POSTED SUCCESSFULLY ON DB2,   * 00020000
      * SERVICE ORDER TABLES ON SYBASE ARE UPDATED. THIS IS ACHIEVED  * 00030000
      * USING OPEN CLIENT/MAINFRAME SOFTWARE.                         * 00040000
      *                                                               * 00050000
      ******************************************************************00060000
      *                     PROGRAM MODIFICATION LOG                  * 00070000
      *                                                               * 00080000
      *    DATE    INITIALS   COMMENTS                                * 00090000
      *  --------  --------   -------------------------------------   * 00100000
      *  02/01/95    PRS      PROCEDURE ORIGINALLY CODED.             * 00110000
      *  08/03/95    TCB      ADDED CODE TO POST DELIVERY POINT INFO. * 00120000
      *  03/27/96    JHR      TPR #3656 - ADDED CALL TO PCSSO065 IF   * 00130000
      *                       ORDER TYPE IS OCCUPANT CHANGE (NC001).  * 00140000
      *  04/04/96    JHR      TPR #3764 - ADDED CHECK BEFORE CALLING  * 00150000
      *                       PCSSO062 TO INSURE ACCOUNT IS ACTIVE.   * 00151000
      *                       TPR #3742 - ADDED CHECK BEFORE CALLING  * 00152000
      *                       PCSSO066 TO SEE IF ORDER TYPE IS NC001. * 00153000
      *  04/16/96    WMG      TPR #3851 - PARSED OUT THE CMN-ORDER-   * 00153100
      *                       TYPE VARIABLE INTO ORDER-TYPE-CD-5 AND  * 00153200
      *                       -2 IN ORDER TO CORRECTLY CHECK FOR THE  * 00153300
      *                       ORDER TYPE.                             * 00153400
      *  08/29/96    WMG      TPR 5172 - MODIFY ERROR HANDLING AFTER  * 00153500
      *                       CALLS TO POSTING PROGRAMS TO WRITE THE  * 00153600
      *                       CORRECT ERROR INFORMATION TO PCSMC005   * 00153700
      *                       AND SEND THIS INFORMATION TO THE        * 00153800
      *                       DESKTOP.                                * 00153900
      *  10/16/96    WMG      TPR 5552 - EXECUTE PCSSO067 ONLY IF THE * 00154000
      *                       WS-CODE-APPLY-CHARGES BYTE OF CWS00059  * 00155000
      *                       IS EQUAL TO 'A'.                        * 00156000
      *  11/12/96    WMG      TPR 5491 - CHANGE WS-ORDER-REASON-BD    * 00157000
      *                       FROM PIC X(15) TO PIC X(01).            * 00158000
      *  03/11/97    DB       TPR 8829 - CALL PCSSO067 FOR ALL        * 00159000
      *                       RECONNECT ORDERS.                       * 00160000
      *  03/17/97    WMG      TPR 9617 - ONLY CALL PCSSO067 FOR ENDV  * 00170000
      *                       AND GAS APPLIANCE FIELD WORK ORDERS.    * 00180000
      *  03/18/97    WMG      TPR 9731 - CHECK FOR AR LOCKOUT AND AR  * 00190000
      *                       SERVICE ORDER POSTING SCENARIOS THAT    * 00200000
      *                       WILL EXECUTE PCSSO062, PCSSO066 OR      * 00210000
      *                       PCSSO067.                               * 00220000
      *  03/28/97    WMG      PCR 493 - ADD FUNCTIONALITY TO ACCEPT   * 00230000
      *                       THE ACCOUNT TYPE CODE FROM pd_D0000060. * 00240000
      *  04/07/97    WMG      TPR 10187 -  ADD FUNCTIONALITY TO ACCEPT* 00250000
      *                       THE CODE EDITED YES NO FLAG FROM        * 00260000
      *                       pd_D0000060.                            * 00270000
      *  07/15/97    MJG      FIXED RPC TO CALL PCSSO064 ANYTIME A    * 00271000
      *                       CC OR OC ORDER IS INITIATED             * 00272000
      *  01/23/97    SYBASE   CHANGED CTBBINDS TO WORK FOR CHAR AND   *         
      *                       VARCHAR INPUT (EYE CATCHER SYB)         *         
      *  04/21/98    cbsi     added code to open client programs for  * 00280000
      *                       the new release of sybase *                       
CBSI  *  07/16/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T17015*  08/04/98   rk        to add validation for unmetered rows also*        
T18037*  12/01/98   FB        ADDED CODE TO GENERATE AN ERROR WHEN THE*         
      *                       TO ACCOUNT HAS BEEN FINAL BILLED.       *         
T18578*  12/14/98   FB        DO NOT ALLOW SET ORDERS TO POST TO      *         
      *                       INACTIVE ACCOUNTS.                      *         
T18726*  12/28/98   FB        DO NOT ALLOW SET ORDERS TO POST TO      *         
      *                       FINAL BILLED ACCOUNTS.                  *         
T18921*  01/19/99   AMG       WHEN PARM-USER-ID = 'CSR*' GET THE      *         
T18921*                       USER-ID FROM COMPLETED-BY IN CSS_SO_DATA*         
T18932*  02/02/99   FB        OMIT TRANSFER CHECK IF OLD ACCOUNT IS   *         
      *                       FINAL BILLED, INACTIVE, OR WRITEOFF.    *         
      *  06/09/99   JVH       TPR 19715 - UPDATE THE BTU FACTOR FOR   *         
      *                       FINAL BILLS OF TOFF TRANSACTIONS.       *         
T19609*  09/21/99   FB        METER MUST BE IN INVENTORY FOR A SET OR *         
      *                       A METER CHANGE.                         *         
C28165*  10/28/03   SR        SEND A WQ WHEN THERE IS A MISMATCH IN   *         
C28165*                       THE RATES FOR THE SAME IC.              *         
C30352*  02/13/04   DD        ADDED MISSING END-IF TO PARA 5310.      *         
C30058*  03/02/04   lho       ADDED code to process new error message *         
C30058*                       returned from pcsso061.  The error msg  *         
C30058*                       is 3000 and is returned for PSNC accts  *         
C30058*                       that are being finaled and have an      *         
C30058*                       active merchandise contract.            *         
C30586*  05/06/04   MSR       ADDED CODE TO PROCESS NEW ERROR MESSAGES*         
C30586*                       RETURNED FROM PCSSO064.  THE ERROR MSGS *         
C30586*                       ARE 7700 AND 7800 RETURNED WHEN INSERT  *         
C30586*                       FAILED WITH -803 AND UPDATE WITH 100 ON *         
C30586*                       CSS_UTIL_ENVRNMT TABLE.                 *         
REARCH*  09/27/06   PA        ADDED CODE TO REMOVE SYBASE SP CALLS    *         
REARCH*                       CONVERT SYBASE GATEWAY TO DB2  CALLS    *         
C35927*  06/28/07   FMB       REMOVE ALL REFERENCES TO CSS_SO_ASYNC.  *         
C35927*                       ADD ROLLBACKS.                          *         
C34590*  05/08/08   FMB       CLEAR OUT INACTIVE AND REMOVED METER    *         
C34590*                       DATES IF METER STATUS IS ACTIVE.        *         
C37061*  08/18/08   FMB       INCLUDE COPYBOOK CPD00118 TO DETERMINE  *         
C37061*                       ACCOUNT TYPE.                           *         
A01114*  08/28/09   VV        REMOVED REFERENCES OF WS-CODE-SO-DLVPNT *         
A01114*                       OF SO_CODES_DATA_PRESENT AS IT IS NO    *         
A01114*                       LONGER USED                             *         
A01668*  09/11/09   FMB       PASS CORRECT ACCOUNT NUMBER TO CPD00118.*         
P00196*  11/16/09   MSR       ADD NEW ORDER TYPE FW026.               *         
A02480*  08/17/10   FMB       USE CORRECT USERID IN TRANSHIST ROW.    *         
ACT106*  05/19/15   RS7M249   Delete unused copybook(s)               *         
A05460*  05/02/16   MC95456   Removed references of MCSSO063.         *         
A05317*  06/21/16   FMB       CORRECT DUPLICATE C3 CURSOR NAME.       *         
A05317*  07/13/16   FMB       REPLACE CSS_ACCOUNT_TYPE WITH N9 TABLE. *         
A05317*  10/06/16   FMB       REMOVE ALL CURRENTLY COMMENTED OUT      *         
A05317*                       REFERENCES TO CSS_SO_ASYNC.             *         
      ***************************************************************** 00290000
      *                                                               * 00300000
      *                ---- BASIC SEQUENCE STRUCTURE ----             * 00310000
      *                                                               * 00320000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            * 00330000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   * 00340000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  * 00350000
      *  3000 - 4999  NOT USED                                        * 00360000
      *  5000 - 5999  COMMON PROGRAM MODULES                          * 00370000
      *  6000 - 6999  COMMON SYSTEM MODULES                           * 00380000
      *  7000 - 7999  INPUT MODULES                                   * 00390000
      *  8000 - 8999  OUTPUT MODULES                                  * 00400000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            * 00410000
      *                                                               * 00420000
      ***************************************************************** 00430000
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ002  01 MFA-CSR00092.
MSQ002    05 ARG-5 PIC X(26).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02025'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
REARCH     VALUE 'WORKING STORAGE FOR CSR02025 STARTS HERE'.            
      ***************************************************************** 00500000
      * DB2 INCLUDES                                                  * 00510000
      ***************************************************************** 00520000
                                                                        
           EXEC SQL                                                     00540000
              INCLUDE SQLCA                                             00550000
           END-EXEC.                                                    00560000
                                                                        
           EXEC SQL                                                     00580000
              INCLUDE TBMODEL                                           00590000
           END-EXEC.                                                    00600000
                                                                        
           EXEC SQL                                                     00620000
                INCLUDE TBACCT                                          00630000
           END-EXEC.                                                    00640000
                                                                        
           EXEC SQL                                                     00660000
                INCLUDE TBBLLHDR                                        00670000
           END-EXEC.                                                    00680000
                                                                        
           EXEC SQL                                                     00700000
                INCLUDE TBCUST                                          00710000
           END-EXEC.                                                    00720000
                                                                        
           EXEC SQL                                                     00740000
                INCLUDE TBPREM                                          00750000
           END-EXEC.                                                    00760000
                                                                        
           EXEC SQL                                                     00820000
                INCLUDE TBARLOCK                                        00830000
           END-EXEC.                                                    00840000
                                                                        
C34590     EXEC SQL                                                     00820000
C34590          INCLUDE TBMTRENV                                        00830000
C34590     END-EXEC.                                                    00840000
                                                                        
C37061     EXEC SQL                                                     00820000
C37061          INCLUDE TBUTLENV                                        00830000
C37061     END-EXEC.                                                    00840000
                                                                        
C37061     EXEC SQL                                                     00820000
C37061          INCLUDE TBMNHIST                                        00830000
C37061     END-EXEC.                                                    00840000
                                                                        
C37061     EXEC SQL                                                     00820000
C37061          INCLUDE TBMNHDT                                         00830000
C37061     END-EXEC.                                                    00840000
                                                                        
C37061     EXEC SQL                                                     00820000
C37061          INCLUDE TBUSRPRF                                        00830000
C37061     END-EXEC.                                                    00840000
                                                                        
      ***************************************************************** 00870000
      * COBOL WORKING STORAGE COPY BOOKS                              * 00880000
      ***************************************************************** 00890000
                                                                        
                                                                        
                                                                        
                                                                        
      * ERROR HANDLING                                                  01040000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
                                                                        
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                  01070000
           COPY CWS00027.                                               01080000
                                                                        
      * AT - CODES-DATA-PRESENT BREAKDOWN                               01090100
           COPY CWS00056.                                               01091000
                                                                        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                             01100000
           COPY CWS00303.                                               01110000
                                                                        
C37061     EXEC SQL                                                             
C37061        INCLUDE CWS00118                                                  
C37061     END-EXEC.                                                            
                                                                        
      ***************************************************************** 01130000
      * WORK AREAS                                                    * 01140000
      ***************************************************************** 01150000
                                                                        
REARCH 01  PROGRAM-NAME                 PIC X(08) VALUE 'CSR02025'.     
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-PROC                 POINTER.                        
           05  GWL-INIT-HANDLE          PIC S9(9) COMP VALUE +0.        
           05  GWL-RC                   PIC S9(9) COMP.                 
           05  GWL-STATUS-NR            PIC S9(9) COMP.                 
           05  GWL-STATUS-DONE          PIC S9(9) COMP.                 
           05  GWL-STATUS-COUNT         PIC S9(9) COMP.                 
           05  GWL-STATUS-COMM          PIC S9(9) COMP.                 
           05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                 
           05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 
                                                                        
       01  CS-LIB-MISC-FIELDS.                                          
           05  WS-CSL-CMD-HANDLE       PIC S9(9) COMP VALUE +0.         
           05  WS-CSL-CON-HANDLE       PIC S9(9) COMP VALUE +0.         
           05  WS-CSL-CTX-HANDLE       PIC S9(9) COMP VALUE +0.         
           05  WS-CSL-NULL             PIC S9(9) COMP VALUE +0.         
           05  WS-CSL-RC               PIC S9(9) COMP.                  
           05  WS-CSL-RESTYPE          PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-ITEM-NUM             PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-COPIED               PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-COPIED-NULL          PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-INDICATOR            PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-INDICATOR-NULL       PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-NUMROWS              PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-RPC-RC               PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-RPC-SUCCESS          PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-RETURN-CODE          PIC S9(9) COMP SYNC VALUE +0.    
                                                                        
       01  CS-PROPERTY-FIELDS.                                          
           05  WS-SO-UPDATE-RPC        PIC X(23)                        
                VALUE 'csrddat.dbo.pd_D0000092'.                        
           05  WS-SO-DATA-RPC          PIC X(23)                        
                VALUE 'csrddat.dbo.pd_D0000060'.                        
           05  WS-RPC-LEN              PIC S9(9) COMP VALUE +23.        
           05  WS-OUTLEN               PIC S9(9) COMP VALUE +0.         
           05  WS-STRLEN               PIC S9(9) COMP VALUE +0.         
           05  WS-MSGLIMIT             PIC S9(9) COMP VALUE +5.         
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ID1                PIC S9(9) COMP VALUE 1.          
           05  PARM-SERV-ORDER-NO      PIC X(13) VALUE SPACES.          
           05  PARM-USER-ID            PIC X(07) VALUE SPACES.          
           05  PARM-PASSWORD.                                           
               49  PARM-PASSWORD-LEN   PIC S9(4) COMP SYNC VALUE +0.    
               49  PARM-PASSWORD-TEXT  PIC X(15) VALUE SPACES.          
           05  PARM-SERVER.                                             
               49  PARM-SERVER-LEN     PIC S9(4) COMP SYNC VALUE +0.    
               49  PARM-SERVER-TEXT    PIC X(17) VALUE SPACES.          
                                                                        
       01  WS-DATAFMT.                                                  
           05 WS-NM-PARM               PIC X(132).                      
           05 WS-NMLEM-PARM            PIC S9(9) COMP SYNC.             
           05 WS-DATATYPE-PARM         PIC S9(9) COMP SYNC.             
           05 WS-FORMT-PARM            PIC S9(9) COMP SYNC.             
           05 WS-MAXLENGTH-PARM        PIC S9(9) COMP SYNC.             
           05 WS-SCALE-PARM            PIC S9(9) COMP SYNC.             
           05 WS-PRECISION-PARM        PIC S9(9) COMP SYNC.             
           05 WS-FNTSTATUS-PARM        PIC S9(9) COMP SYNC.             
           05 WS-FMTCOUNT-PARM         PIC S9(9) COMP SYNC.             
           05 WS-USERTYPE-PARM         PIC S9(9) COMP SYNC.             
           05 WS-LOCALE-PARM           PIC S9(9) COMP SYNC.             
                                                                        
       01  WS-DATAFMT-BIND.                                             
           05 WS-NM-BIND               PIC X(132).                      
           05 WS-NMLEM-BIND            PIC S9(9) COMP SYNC.             
           05 WS-DATATYPE-BIND         PIC S9(9) COMP SYNC.             
           05 WS-FORMT-BIND            PIC S9(9) COMP SYNC.             
           05 WS-MAXLENGTH-BIND        PIC S9(9) COMP SYNC.             
           05 WS-SCALE-BIND            PIC S9(9) COMP SYNC.             
           05 WS-PRECISION-BIND        PIC S9(9) COMP SYNC.             
           05 WS-FNTSTATUS-BIND        PIC S9(9) COMP SYNC.             
           05 WS-FMTCOUNT-BIND         PIC S9(9) COMP SYNC.             
           05 WS-USERTYPE-BIND         PIC S9(9) COMP SYNC.             
           05 WS-LOCALE-BIND           PIC S9(9) COMP SYNC.             
                                                                        
      ***************************************************************** 00015000
      *===> SYB 01 LEVELS ADD FOR CTBBIND VARCHAR CHAR ISSUE 01/23/98*          
      ***************************************************************** 00015000
      *WS-BIND-AREA.                                                            
       01  WS-PREMISE-NO-BD-01.                                         
           05  FILLER                      PIC S9(4) COMP.              
                                                                        
           05  WS-PREMISE-NO-BD            PIC X(10).                   
           05  WS-PREMISE-NO-I REDEFINES WS-PREMISE-NO-BD               
                                           PIC 9(10).                   
      *                                                                         
       01  WS-ACCOUNT-NO-BD-01.                                         
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-ACCOUNT-NO-BD            PIC X(13).                   
           05  WS-ACCOUNT-NO-I REDEFINES WS-ACCOUNT-NO-BD               
                                           PIC 9(13).                   
      *                                                                         
       01  WS-ACCOUNT-NO-NEW-BD-01.                                     
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-ACCOUNT-NO-NEW-BD        PIC X(13).                   
           05  WS-ACCOUNT-NO-NEW-I REDEFINES WS-ACCOUNT-NO-NEW-BD       
                                           PIC 9(13).                   
                                                                        
       01  WS-ORDER-TYPE-CD-BD-01.                                      
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-ORDER-TYPE-CD-BD         PIC X(05).                   
                                                                        
       01  WS-WANTED-DATE                  PIC X(01) VALUE SPACES.      
       01  WS-SERV-ORDER-STATUS            PIC X(02) VALUE '50'.        
       01  WS-REQUIREMENT-CD               PIC X(01) VALUE '1'.         
       01  WS-PANEL                        PIC X(03) VALUE '090'.       
       01  WS-UPDATE-STATUS                PIC X(01) VALUE 'Y'.         
                                                                        
       01  WS-HOLD-COMPLETED-DATE-BD-01.                                
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-HOLD-COMPLETED-DATE-BD   PIC X(10).                   
                                                                        
       01  WS-HOLD-COMPLETED-TIME-BD-01.                                
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-HOLD-COMPLETED-TIME-BD   PIC X(08).                   
                                                                        
       01  WS-CODES-DATA-PRESENT-BD-01.                                 
           05  FILLER                      PIC S9(4) COMP.              
                                                                        
           05  WS-CODES-DATA-PRESENT-BD    PIC X(35).                   
                                                                        
       01  WS-ORDER-REASON-BD-01.                                       
           05  FILLER                      PIC S9(4) COMP.              
                                                                        
T5491      05  WS-ORDER-REASON-BD          PIC X(01).                   
                                                                        
       01  WS-PENDING-DNP-FLAG-BD-01.                                   
           05  FILLER                      PIC S9(4) COMP.              
                                                                        
           05  WS-PENDING-DNP-FLAG-BD      PIC X(01).                   
                                                                        
       01  WS-ACCOUNT-TYPE-CODE-BD-01.                                  
           05  FILLER                      PIC S9(4) COMP.              
                                                                        
           05  WS-ACCOUNT-TYPE-CODE-BD     PIC X(01).                   
                                                                        
       01  WS-CODE-EDITED-YES-NO-BD-01.                                 
           05  FILLER                      PIC S9(4) COMP.              
                                                                        
           05  WS-CODE-EDITED-YES-NO-BD    PIC X(01).                   
                                                                        
       01  WS-SO-OFF-DATE-BD-01.                                        
           05  FILLER                      PIC S9(4) COMP.              
                                                                        
           05  WS-SO-OFF-DATE-BD           PIC X(10).                   
                                                                        
       01  WS-SO-CREW-ID-01.                                            
           05  FILLER                      PIC S9(4) COMP.              
                                                                        
           05  WS-SO-CREW-ID               PIC X(06).                   
                                                                        
       01  WS-SO-SET-CONDITION-EXISTS-01.                               
           05  FILLER                      PIC S9(4) COMP.              
                                                                        
           05  WS-SO-SET-CONDITION-EXISTS  PIC X(01).                   
                                                                        
T18921 01  WS-SO-COMPLETED-BY-01.                                       
T18921     05  FILLER                      PIC S9(4) COMP.              
T18921     05  WS-SO-COMPLETED-BY          PIC X(25).                   
                                                                        
T17951 01  WS-BTU-FACTOR-01.                                            
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-BTU-FACTOR               PIC X(5).                    
      ***************************************************************** 00015000
      *===> SYB END 01 LEVEL CHANGES                         01/23/98*          
      ***************************************************************** 00015000
                                                                        
       01  WS-SERVER-MSG.                                               
           05 WS-SM-MSGNO              PIC S9(9) COMP SYNC.             
           05 WS-SM-STATE              PIC S9(9) COMP SYNC.             
           05 WS-SM-SEVERITY           PIC S9(9) COMP SYNC.             
           05 WS-SM-TEXT               PIC X(256).                      
           05 WS-SM-TEXT-LEN           PIC S9(9) COMP SYNC.             
           05 WS-SM-SVRNAME            PIC X(256).                      
           05 WS-SM-SVRNAME-LEN        PIC S9(9) COMP SYNC.             
           05 WS-SM-PROC               PIC X(256).                      
           05 WS-SM-PROC-LEN           PIC S9(9) COMP SYNC.             
           05 WS-SM-LINE               PIC S9(9) COMP SYNC.             
           05 WS-SM-STATUS             PIC S9(9) COMP SYNC.             
                                                                        
       01  WS-CLIENT-MSG.                                               
           05 WS-CM-SEVERITY           PIC S9(9) COMP SYNC.             
           05 WS-CM-OC-MSGNO           PIC S9(9) COMP SYNC.             
           05 WS-CM-OC-MSGTEXT         PIC X(256).                      
           05 WS-SM-OC-MSGTEXT-LEN     PIC S9(9) COMP SYNC.             
           05 WS-CM-OS-MSGNO           PIC S9(9) COMP SYNC.             
           05 WS-CM-OS-MSGTEXT         PIC X(256).                      
           05 WS-CM-OS-MSGTEXT-LEN     PIC S9(9) COMP SYNC.             
           05 WS-CM-STATUS             PIC S9(9) COMP SYNC.             
                                                                        
       01  WS-MSGNO                    PIC S9(9) COMP VALUE +1.         
       01  WS-RETCODE                  PIC S9(9) COMP SYNC VALUE +0.    
       01  WS-DATALEN                  PIC S9(9) COMP SYNC VALUE +0.    
       01  WS-INDIC                    PIC S9(9) COMP SYNC VALUE +0.    
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE +0.         
           05  RS-AR-LOCKOUT-IND       PIC X(01).                       
           05  RS-ACCT-XFER-NO         PIC X(13).                       
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  WS-RETURN-CODE          PIC S9(9) COMP VALUE +0.         
REARCH     05   S-RETURN-CODE          PIC S9(9) COMP VALUE +0.         
                                                                        
       01  CN-COLUMN-NAMES.                                             
           05  CN-RETURN-CODE          PIC X(11) VALUE                  
                                                 'RETURN_CODE'.         
           05  CN-ACTIVE-PARAGRAPH     PIC X(16) VALUE                  
                                                 'ACTIVE_PARAGRAPH'.    
           05  CN-PROGRAM-NAME         PIC X(12) VALUE                  
                                                 'PROGRAM_NAME'.        
           05  CN-AR-LOCKOUT-IND       PIC X(14) VALUE                  
                                                 'AR_LOCKOUT_IND'.      
           05  CN-ACCT-XFER-NO         PIC X(12) VALUE                  
                                                 'ACCT_XFER_NO'.        
                                                                        
REARCH 01 WS-MISC.                                                      
REARCH    05 WS-IND-1      PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-2      PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-3      PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-4      PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-5      PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-6      PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-7      PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-8      PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-9      PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-10     PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-11     PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-12     PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-13     PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-14     PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-15     PIC S9(04) COMP VALUE 0.                     
REARCH    05 WS-IND-16     PIC S9(04) COMP VALUE 0.                     
C34590    05 WS-NULL1      PIC S9(04) COMP VALUE 0.                     
C34590    05 WS-NULL2      PIC S9(04) COMP VALUE 0.                     
REARCH****** DB2 COMMUNICATION REQUIREMENT ****************************         
REARCH*01  LOC1            USAGE IS SQL TYPE IS                         
REARCH*                    RESULT-SET-LOCATOR VARYING.                  
REARCH*01  LOC2            USAGE IS SQL TYPE IS                         
REARCH*                    RESULT-SET-LOCATOR VARYING.                  
                                                                        
       COPY CWS00004.                                                   02690000
       COPY CWS00026.                                                   02700000
       COPY CWS00059.                                                   02710000
       COPY CCA00001.                                                   02720000
       COPY CCA00004.                                                   02730000
                                                                        
       01  WS-WORK-AREA.                                                
           05  WS-SERV-ORDER-NO-C         PIC X(13).                    
           05  WS-SERV-ORDER-NO-I REDEFINES WS-SERV-ORDER-NO-C          
                                          PIC 9(13).                    
COB305     05 WS-SERV-ORDER-NO-D        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.     
           05  WS-TODAYS-DATE             PIC X(10).                    
C37061     05  WS-CURRENT-TIMESTAMP       PIC X(26).                    
C37061     05  WS-OLD-ACCT-TYPE           PIC X(01).                    
C37061     05  WS-NEW-ACCT-TYPE           PIC X(01).                    
           05  WS-USER-ID                 PIC X(07) VALUE SPACES.       
           05  WS-PASSWORD.                                             
               49  WS-PASSWORD-LEN        PIC S9(4) COMP SYNC VALUE +0. 
               49  WS-PASSWORD-TEXT       PIC X(15) VALUE SPACES.       
           05  WS-SERVER.                                               
               49  WS-SERVER-LEN          PIC S9(4) COMP SYNC VALUE +0. 
               49  WS-SERVER-TEXT         PIC X(17) VALUE SPACES.       
           05  WS-SO-EXISTS               PIC X(01) VALUE 'Y'.          
           05  ALL-DONE-SW                PIC X(01) VALUE 'N'.          
               88 NOT-ALL-DONE                      VALUE 'N'.          
               88 ALL-DONE                          VALUE 'Y'.          
           05  SEND-DONE-SW               PIC X(01) VALUE 'Y'.          
               88 SEND-DONE-ERROR                   VALUE 'N'.          
               88 SEND-DONE-OK                      VALUE 'Y'.          
           05  SW-PROCESSING              PIC X(01) VALUE SPACES.       
           05  SW-RESULTS                 PIC X(01) VALUE 'Y'.          
               88 NO-MORE-RESULTS                   VALUE 'N'.          
               88 MORE-RESULTS                      VALUE 'Y'.          
           05  SW-FETCH                   PIC X(01) VALUE 'Y'.          
               88 NO-MORE-ROWS                      VALUE 'N'.          
               88 MORE-ROWS                         VALUE 'Y'.          
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-NAC7                    PIC X(04) VALUE 'NAC7'.       
           05  WS-NA-SO                   PIC X(03) VALUE 'NA '.        
           05  WS-A                       PIC X(01) VALUE 'A'.          
           05  WS-D                       PIC X(01) VALUE 'D'.          
           05  WS-E                       PIC X(01) VALUE 'E'.          
           05  WS-F                       PIC X(01) VALUE 'F'.          
           05  WS-G                       PIC X(01) VALUE 'G'.          
           05  WS-H                       PIC X(01) VALUE 'H'.          
           05  WS-I                       PIC X(01) VALUE 'I'.          
           05  WS-J                       PIC X(01) VALUE 'J'.          
           05  WS-K                       PIC X(01) VALUE 'K'.          
           05  WS-O                       PIC X(01) VALUE 'O'.          
           05  WS-P                       PIC X(01) VALUE 'P'.          
           05  WS-S                       PIC X(01) VALUE 'S'.          
           05  WS-T                       PIC X(01) VALUE 'T'.          
           05  WS-W                       PIC X(01) VALUE 'W'.          
           05  WS-1                       PIC X(01) VALUE '1'.          
           05  WS-2                       PIC X(01) VALUE '2'.          
           05  WS-0006                    PIC X(04) VALUE '0006'.       
           05  WS-0034                    PIC X(04) VALUE '0034'.       
           05  WS-0043                    PIC X(04) VALUE '0043'.       
           05  WS-0046                    PIC X(04) VALUE '0046'.       
           05  WS-SO                      PIC X(02) VALUE 'SO'.         
           05  WS-BF                      PIC X(02) VALUE 'BF'.         
           05  WS-AM                      PIC X(02) VALUE 'AM'.         
           05  WS-PM                      PIC X(02) VALUE 'PM'.         
           05  WS-NO                      PIC X(03) VALUE 'NO '.        
           05  WS-A-R                     PIC X(03) VALUE 'A/R'.        
           05  WS-DEP                     PIC X(03) VALUE 'DEP'.        
                                                                        
REARCH 01  CALLED-PGMS.                                                 
REARCH     05  PCSSO061                   PIC X(08) VALUE 'MCSSO061'.   
REARCH     05  PCSSO062                   PIC X(08) VALUE 'MCSSO062'.   
REARCH     05  PCSSO064                   PIC X(08) VALUE 'MCSSO064'.   
REARCH     05  PCSSO065                   PIC X(08) VALUE 'MCSSO065'.   
REARCH     05  PCSSO066                   PIC X(08) VALUE 'MCSSO066'.   
REARCH     05  PCSSO067                   PIC X(08) VALUE 'MCSSO067'.   
REARCH     05  PCSSO068                   PIC X(08) VALUE 'MCSSO068'.   
                                                                        
       01  ORDER-TYPE-LITERALS.                                         
           05  WS-OFF                     PIC X(05) VALUE 'OF'.         
           05  WS-DNPFB                   PIC X(05) VALUE 'DNPFB'.      
           05  WS-DNP                     PIC X(05) VALUE 'DNP01'.      
           05  WS-MC                      PIC X(02) VALUE 'MC'.         
           05  WS-FM                      PIC X(02) VALUE 'FM'.         
           05  WS-ON                      PIC X(02) VALUE 'ON'.         
           05  WS-CC                      PIC X(02) VALUE 'CC'.         
           05  WS-NC                      PIC X(02) VALUE 'NC'.         
TP8829     05  WS-FM006                   PIC X(05) VALUE 'FM006'.      
TP8829     05  WS-FM008                   PIC X(05) VALUE 'FM008'.      
P00196     05  WS-FW026                   PIC X(05) VALUE 'FW026'.      
TP8829     05  WS-ENDV                    PIC X(04) VALUE 'ENDV'.       
                                                                        
       01  MISCELLANEOUS-VARIABLES.                                     
           05  WS-ORDER-TYPE-CD-2         PIC X(02).                    
           05  WS-ORDER-TYPE-CD-5         PIC X(05).                    
           05  WS-EXEC-PCSSO062           PIC X(01).                    
           05  WS-EXEC-PCSSO066           PIC X(01).                    
           05  WS-EXEC-PCSSO067           PIC X(01).                    
                                                                        
       01  WS-END                         PIC X(40)                     
REARCH     VALUE 'WORKING STORAGE FOR CSR02025 ENDS HERE  '.
MSQ001        EXEC SQL
MSQ001          DECLARE C3 CURSOR
MSQ001          FOR CALL CSR00060                                       
REARCH                 ( :WS-SERV-ORDER-NO-C
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C4 CURSOR
MSQ001          FOR CALL CSR00092                                       
REARCH                 ( :WS-SERV-ORDER-NO-C
                  , :WS-SERV-ORDER-STATUS
                  , :WS-REQUIREMENT-CD
                  , :WS-USER-ID
                  , :MFA-CSR00092.ARG-5
                  , :WS-PANEL
                  , :WS-UPDATE-STATUS
                  )
MSQ001        END-EXEC.
            
                                                                        
       LINKAGE SECTION.                                                 
REARCH 01  LINK-SERV-ORDER-NO              PIC X(13).                   
REARCH 01  LINK-USER-ID                    PIC X(07).                   
REARCH 01  LINK-PASSWORD                   PIC X(15).                   
REARCH 01  LINK-SERVER                     PIC X(17).                   
                                                                        
REARCH PROCEDURE DIVISION USING  LINK-SERV-ORDER-NO,                    
REARCH                           LINK-USER-ID,                          
REARCH                           LINK-PASSWORD,                         
REARCH                           LINK-SERVER.                           
                                                                        
      ******************************************************************03640000
      * 0000-MAINLINE                                                  *03650000
      *                                                                *03660000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03670000
      *                                                                *03680000
      ******************************************************************03690000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INIT-SERVER           THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03800000
      * 0100-INIT-SERVER                                               *03810000
      *     CALLS 9000-SEND-ERROR-RESULT                               *03820000
      *           9900-SQL-ERROR-ROUTINE                               *03830000
      *                                                                *03840000
      *     CALLED FROM 0000-MAINLINE                                  *03850000
      *                                                                *03860000
      *     1. RESET DB2 ERROR HANDLERS                                *03870000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03880000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03890000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03900000
      *                                                                *03910000
      ******************************************************************03920000
       0100-INIT-SERVER.                                                
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH     MOVE LINK-SERV-ORDER-NO      TO PARM-SERV-ORDER-NO,          
REARCH     MOVE LINK-USER-ID            TO PARM-USER-ID                 
REARCH     MOVE LINK-PASSWORD           TO PARM-PASSWORD                
REARCH     MOVE LINK-SERVER             TO PARM-SERVER.                 
                                                                        
REARCH     EXEC SQL                                                     
REARCH       DECLARE C1 CURSOR   FOR                
REARCH       SELECT                                                     
REARCH        :RS-RETURN-CODE             AS    RETURN_CODE             
REARCH       ,:ACTIVE-PARAGRAPH           AS    [ACTVE-PARAGRAPH]         
REARCH       ,:PROGRAM-NAME               AS    [PGM-NAME]                
REARCH       ,:RS-AR-LOCKOUT-IND          AS    AR_LOCKOUT_IND          
REARCH       ,:RS-ACCT-XFER-NO            AS    ACCT_XFER_NO            
REARCH          FROM CIS.SYSDUMMY1                                   
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR* MSQ034
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH HOLD WITH RETURN FOR                        
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE             AS    RETURN_CODE                     
MFA-TR*      ,:ACTIVE-PARAGRAPH           AS    ACTVE-PARAGRAPH                 
MFA-TR*      ,:PROGRAM-NAME               AS    PGM-NAME                        
MFA-TR*      ,:RS-AR-LOCKOUT-IND          AS    AR_LOCKOUT_IND                  
MFA-TR*      ,:RS-ACCT-XFER-NO            AS    ACCT_XFER_NO                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04200000
      * 0200-INIT-CLIENT                                               *04210000
      *     CALLS 9000-SEND-ERROR-RESULT                               *04220000
      *           9900-SQL-ERROR-ROUTINE                               *04230000
      *                                                                *04240000
      *     CALLED FROM 0000-MAINLINE                                  *04250000
      *                                                                *04260000
      ******************************************************************04270000
       0200-INIT-CLIENT.                                                
                                                                        
           MOVE '0200'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE ZEROES                        TO WS-DATAFMT-BIND.       
           MOVE LOW-VALUES                    TO WS-DATAFMT.            
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05840000
      * 1000-PROCESS-INPUT                                             *05850000
      *     CALLS 1100-RECEIVE-PARMS                                   *05860000
      *                                                                *05870000
      *     CALLED FROM 0000-MAINLINE                                  *05880000
      *                                                                *05890000
      *     RECEIVE PARMS AND THEN MOVE PARM WORKING STORAGE VARIABLES *05900000
      *     TO STANDARD WORKING STORAGE VARIABLES.                     *05910000
      ******************************************************************05920000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-C.    
           MOVE WS-SERV-ORDER-NO-I            TO WS-SERV-ORDER-NO-D.    
           MOVE PARM-USER-ID                  TO WS-USER-ID.            
           MOVE PARM-PASSWORD                 TO WS-PASSWORD.           
           MOVE PARM-SERVER                   TO WS-SERVER.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07170000
      * 2000-PROCESS-OUTPUT                                            *07180000
      *                                                                *07190000
      *                                                                *07200000
      ******************************************************************07210000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE                THRU 5000-EXIT.           
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08680000
      * 5000-UPDATE                                                    *08690000
      *                                                                *08700000
      *                                                                *08710000
      ******************************************************************08720000
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 0200-INIT-CLIENT           THRU 0200-EXIT.           
                                                                        
           MOVE PARM-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-C.    
                                                                        
REARCH     PERFORM 5290-GET-SO-DATA           THRU 5290-EXIT.           
                                                                        
           MOVE WS-ACCOUNT-NO-I               TO AT-ACCOUNT-NO.         
                                                                        
T18921     IF WS-USER-ID (1:3) EQUAL 'CSR' AND                          
T18921        WS-SO-COMPLETED-BY NOT EQUAL SPACES                       
T18921         MOVE WS-SO-COMPLETED-BY (1:7)  TO WS-USER-ID             
T18921     ELSE                                                         
T18921         MOVE PARM-USER-ID              TO WS-USER-ID             
T18921     END-IF.                                                      
                                                                        
           PERFORM 7200-SELECT-ACCOUNT        THRU 7200-EXIT.           
                                                                        
           MOVE PARM-SERV-ORDER-NO            TO CMN-SERV-ORDER-NO      
                                                 WS-ORDER-TYPE-CD-5     
                                                 WS-ORDER-TYPE-CD-2.    
                                                                        
           MOVE WS-PREMISE-NO-I               TO CMN-PREMISE-NO.        
           MOVE WS-ACCOUNT-NO-I               TO CMN-ACCOUNT-NO.        
           MOVE WS-ACCOUNT-NO-NEW-I           TO CMN-ACCOUNT-NO-NEW.    
           MOVE AT-CUSTOMER-NO                TO CMN-CUSTOMER-NO.       
                                                                        
T17015     IF WS-ORDER-TYPE-CD-BD  = 'UMRCC'                            
T17015          MOVE 'CC001'   TO WS-ORDER-TYPE-CD-BD                   
T17015     END-IF.                                                      
T17015     IF WS-ORDER-TYPE-CD-BD  = 'UMROC'                            
T17015          MOVE 'NC001'   TO WS-ORDER-TYPE-CD-BD                   
T17015     END-IF.                                                      
T17015     IF WS-ORDER-TYPE-CD-BD  = 'UMOFF'                            
T17015          MOVE 'OFF01'   TO WS-ORDER-TYPE-CD-BD                   
T17015     END-IF.                                                      
T17015                                                                  
                                                                        
T18578     IF WS-ORDER-TYPE-CD-BD = 'FM002' AND                         
T18726        (AT-CODE-ACCT-STAT = 'J' OR 'B' OR 'S')                   
T18578            MOVE 4075                   TO CMN-RETURN-CODE        
T18578            MOVE SPACES                 TO CMN-TABLE-ELEMENT-1    
T18578            PERFORM 9800-ABEND-TABLE-INFO     THRU 9800-EXIT      
T18578            PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT      
T18578            PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT      
T18578     END-IF.                                                      
                                                                        
           MOVE WS-ORDER-TYPE-CD-BD           TO CMN-SERV-ORDER-TYPE    
                                                 WS-ORDER-TYPE-CD-5     
                                                 WS-ORDER-TYPE-CD-2.    
                                                                        
           MOVE WS-CODES-DATA-PRESENT-BD    TO CMN-CODES-SO-DATA-PRESENT
                                               WS-CODES-SO-DATA-PRESENT.
           MOVE WS-HOLD-COMPLETED-DATE-BD   TO CMN-HOLD-COMPLETED-DATE. 
           MOVE WS-HOLD-COMPLETED-TIME-BD   TO CMN-HOLD-COMPLETED-TIME. 
           MOVE WS-USER-ID                  TO CMN-USER-ID.             
           MOVE WS-ORDER-REASON-BD          TO CMN-ORDER-REASON.        
           MOVE WS-PENDING-DNP-FLAG-BD      TO CMN-PENDING-DNP-FLAG.    
           MOVE WS-ACCOUNT-TYPE-CODE-BD     TO CMN-ACCOUNT-TYPE-CODE.   
           MOVE WS-CODE-EDITED-YES-NO-BD    TO CMN-CODE-EDITED-YES-NO.  
           MOVE WS-SO-OFF-DATE-BD           TO CMN-SO-OFF-DATE.         
           MOVE WS-SO-CREW-ID               TO CMN-SO-CREW-ID.          
           MOVE WS-SO-SET-CONDITION-EXISTS  TO                          
                                            CMN-SO-SET-CONDITION-EXISTS.
T19715     MOVE WS-BTU-FACTOR               TO CMN-BTU-FACTOR.          
                                                                        
           PERFORM 7000-GET-TODAYS-DATE     THRU 7000-EXIT.             
                                                                        
           MOVE WS-TODAYS-DATE              TO CMN-TODAYS-DATE.         
                                                                        
           PERFORM 7010-DETERMINE-CHECKS    THRU 7010-EXIT.             
                                                                        
      ****** CALL SERVICE ORDER POSTING PROGRAMS PCSSO061-67 ******     09230000
P00196     IF WS-ORDER-TYPE-CD-5 = WS-FM008 OR WS-ENDV OR WS-FW026      
T9617         PERFORM 5320-PROCESS-SO-CHARGES    THRU 5320-EXIT         
T9617      ELSE                                                         
              PERFORM 5310-PROCESS-SERVICE-ORDER THRU 5310-EXIT         
T9617      END-IF.                                                      
                                                                        
REARCH     PERFORM 5490-UPDATE-THRU-DB2SP     THRU 5490-EXIT.           
                                                                        
      ****** COMMIT CHANGES TO DB2 ******                               09300000
           PERFORM 9600-COMMIT-WORK           THRU 9600-EXIT.           
                                                                        
      ****** UPDATE THE SO ON SYBASE ******                             09330000
           MOVE PARM-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-C.    
                                                                        
      ****** AFTER UPDATING SYBASE, DELETE SO RECORD ON DB2 ******      09360000
           MOVE PARM-SERV-ORDER-NO            TO WS-SERV-ORDER-NO-C.    
           MOVE WS-SERV-ORDER-NO-I            TO WS-SERV-ORDER-NO-D.    
                                                                        
C34590     MOVE WS-ACCOUNT-NO-NEW-I TO MN-ACCOUNT-NO.                   
C34590     PERFORM 8400-UPDATE-METER-DATES THRU 8400-EXIT.              
                                                                        
A01668     IF WS-ORDER-TYPE-CD-2 = 'CC' OR                              
A01668        WS-ORDER-TYPE-CD-2 = 'NC' OR                              
A01668        WS-ORDER-TYPE-CD-BD = 'FM002' OR                          
A01668        WS-ORDER-TYPE-CD-BD = 'UMRCC' OR                          
A01668        WS-ORDER-TYPE-CD-BD = 'UMROC'                             
A01668            MOVE WS-ACCOUNT-NO-NEW-I TO UT-ACCOUNT-NO             
A01668     ELSE                                                         
A01668         MOVE WS-ACCOUNT-NO-I TO UT-ACCOUNT-NO
           END-IF.                   
C37061     PERFORM 6000-GET-ACCT-TYPE-CODE-CPD118 THRU 6000-CPD118-EXIT.
C37061     IF WS-CPD118-ACCT-TYPE-CODE > ' '                            
C37061         PERFORM 8500-UPDATE-ACCT-TYPE THRU 8500-EXIT             
C37061         IF WS-ORDER-TYPE-CD-BD = 'FM002' OR                      
C37061            WS-ORDER-TYPE-CD-BD = 'UMRCC' OR                      
C37061            WS-ORDER-TYPE-CD-BD = 'UMROC' OR                      
C37061            WS-ORDER-TYPE-CD-2 = 'CC' OR                          
C37061            WS-ORDER-TYPE-CD-2 = 'NC' OR                          
C37061            WS-OLD-ACCT-TYPE = WS-NEW-ACCT-TYPE                   
C37061                NEXT SENTENCE                                     
C37061         ELSE                                                     
C37061             PERFORM 5100-INSERT-TRANSHIST THRU 5100-EXIT
               END-IF
           END-IF.        
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
C37061 5100-INSERT-TRANSHIST.                                           
C37061                                                                  
C37061     MOVE WS-TODAYS-DATE        TO MH-DATE-TRANS.                 
C37061     MOVE WS-CURRENT-TIMESTAMP  TO MH-TRANS-HIST-SEQ-NO.          
C37061     MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
C37061     PERFORM 7300-RESPONSIBLE-AREA THRU 7300-EXIT.                
C37061     MOVE 'F'                   TO MH-CODE-TRAN-TYPE.             
C37061     MOVE PF-RESP-AREA-ID       TO MH-RESP-AREA-ID.               
C37061     MOVE CMN-ACCOUNT-NO        TO MH-ACCOUNT-NO.                 
C37061     MOVE ZEROS                 TO MH-CUSTOMER-NO.                
C37061     MOVE ZEROES                TO MH-PREMISE-NO.                 
A02480     MOVE WS-USER-ID            TO MH-USER-ID.                    
C37061     MOVE 'CSR02025'            TO MH-APPL-PROGRAM-ID.            
C37061     MOVE SPACES                TO MH-TRAN-COMMENT-TEXT.          
C37061     MOVE ZEROES                TO MH-TRAN-COMMENT-LEN.           
C37061                                                                  
C37061     MOVE +1                    TO MI-TRAN-APPL-NO.               
A05317     MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN.       
A05317     MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN.       
C37061     IF WS-OLD-ACCT-TYPE > SPACES                                 
A05317        MOVE WS-OLD-ACCT-TYPE TO MI-PRV-COLUMN-VALUE-TEXT         
C37061     ELSE                                                         
C37061        MOVE SPACES TO MI-PRV-COLUMN-VALUE-TEXT                   
C37061     END-IF                                                       
C37061     IF WS-NEW-ACCT-TYPE > SPACES                                 
A05317        MOVE WS-NEW-ACCT-TYPE TO MI-CHG-COLUMN-VALUE-TEXT         
C37061     ELSE                                                         
C37061        MOVE SPACES TO MI-CHG-COLUMN-VALUE-TEXT                   
C37061     END-IF                                                       
C37061     MOVE 'ACCOUNT TYPE'        TO MI-COLUMN-DESC.                
A05317     MOVE 'N9'                  TO MI-TABLE-ID                    
C37061     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
C37061                                                                  
C37061 5100-EXIT.                                                       
C37061     EXIT.                                                        
                                                                        
REARCH 5290-GET-SO-DATA.                                                
                                                                        
REARCH     MOVE '5290'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
REARCH*    EXEC SQL CALL CSR00060                                       
REARCH*                ( :WS-SERV-ORDER-NO-C                            
REARCH*                )                                                
REARCH*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C3
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C3
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C3 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
REARCH     IF SQLCODE = 466 THEN                                        
REARCH*       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
REARCH*         CSR00060                                                
REARCH*       END-EXEC                                                  
REARCH*       EXEC SQL ALLOCATE C3 CURSOR FOR RESULT SET :LOC1          
REARCH*       END-EXEC                                                  
REARCH        EXEC SQL                                                  
REARCH        FETCH C3 INTO                                             
REARCH                 :WS-PREMISE-NO-BD :WS-IND-1,                      
REARCH                 :WS-ACCOUNT-NO-BD :WS-IND-2,                      
REARCH                 :WS-ACCOUNT-NO-NEW-BD :WS-IND-3,                  
REARCH                 :WS-ORDER-TYPE-CD-BD :WS-IND-4,                   
REARCH                 :WS-CODES-DATA-PRESENT-BD :WS-IND-5,              
REARCH                 :WS-HOLD-COMPLETED-DATE-BD :WS-IND-6,             
REARCH                 :WS-HOLD-COMPLETED-TIME-BD :WS-IND-7,             
REARCH                 :WS-ORDER-REASON-BD :WS-IND-8,                    
REARCH                 :WS-PENDING-DNP-FLAG-BD :WS-IND-9,                
REARCH                 :WS-ACCOUNT-TYPE-CODE-BD :WS-IND-10,              
REARCH                 :WS-CODE-EDITED-YES-NO-BD :WS-IND-11,             
REARCH                 :WS-SO-OFF-DATE-BD :WS-IND-12,                    
REARCH                 :WS-SO-CREW-ID :WS-IND-13,                        
REARCH                 :WS-SO-SET-CONDITION-EXISTS :WS-IND-14,           
REARCH                 :WS-SO-COMPLETED-BY :WS-IND-15,                   
REARCH                 :WS-BTU-FACTOR :WS-IND-16                         
REARCH        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
REARCH     END-IF.                                                      
                                                                        
REARCH 5290-EXIT.                                                       
REARCH     EXIT.                                                        
                                                                        
REARCH 5490-UPDATE-THRU-DB2SP.                                          
                                                                        
REARCH     MOVE '5490'                   TO WS-ACTIVE-PARAGRAPH.        

MSQ002     EXEC SQL
MSQ002         SELECT CIS.CURRENT$TIMESTAMP()
MSQ002           INTO :MFA-CSR00092.ARG-5
MSQ002     END-EXEC
                                                                        
REARCH*    EXEC SQL CALL CSR00092                                       
REARCH*                ( :WS-SERV-ORDER-NO-C                            
REARCH*                 ,:WS-SERV-ORDER-STATUS                          
REARCH*                 ,:WS-REQUIREMENT-CD                             
REARCH*                 ,:WS-USER-ID                                    
REARCH*                 ,:WS-WANTED-DATE                                        
REARCH*                 ,CURRENT TIMESTAMP                              
REARCH*                 ,:WS-PANEL                                      
REARCH*                 ,:WS-UPDATE-STATUS                              
REARCH*                )                                                
REARCH*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C4
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C4
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C4 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
REARCH     IF SQLCODE = 466 THEN                                        
REARCH*       EXEC SQL ASSOCIATE LOCATORS(:LOC2) WITH PROCEDURE         
REARCH*         CSR00092                                                
REARCH*       END-EXEC                                                  
A05317*       EXEC SQL ALLOCATE C4 CURSOR FOR RESULT SET :LOC2          
REARCH*       END-EXEC                                                  
REARCH        EXEC SQL                                                  
A05317        FETCH C4 INTO :WS-CSL-RC                                  
REARCH        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
REARCH     END-IF.                                                      
                                                                        
REARCH 5490-EXIT.                                                       
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************14180000
      * 5310-PROCESS-SERVICE-ORDER                                     *14190000
      *                                                                *14200000
      *                                                                *14210000
      ******************************************************************14220000
       5310-PROCESS-SERVICE-ORDER.                                      
                                                                        
      ****** PCSSO061 UPDATES ACCOUNT INFORMATION ******                14250000
           PERFORM 9510-CALL-PCSSO061              THRU 9510-EXIT       
                                                                        
           IF CMN-ABEND-CHECK EQUAL 'Y'                                 
C30058        IF CMN-TABLE-ELEMENT-2 = 3000                             
C30058           MOVE 3000 TO CMN-RETURN-CODE                           
C30058           MOVE SPACES TO CMN-TABLE-ELEMENT-2                     
C30058        END-IF                                                    
T5172         PERFORM 9800-ABEND-TABLE-INFO        THRU 9800-EXIT       
              PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT       
              PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT       
T9617      END-IF.                                                      
                                                                        
      ****** PCSSO064 PROCESSES METER CHANGES ******                    14350000
           IF  WS-CODE-SO-REG-CHG     = WS-A                            
               OR WS-CODE-SO-MTR-CHG  = WS-A                            
               OR WS-CODE-SO-UMTR-CHG = WS-A                            
               OR WS-CODE-SO-UTL-CHG  = WS-A                            
A01114*        OR WS-CODE-SO-DLVPNT   = WS-A                            14400000
               OR  WS-ORDER-TYPE-CD-2 = WS-CC                           
               OR  WS-ORDER-TYPE-CD-2 = WS-NC                           
                                                                        
               PERFORM 9540-CALL-PCSSO064          THRU 9540-EXIT       
                                                                        
T5172          IF CMN-ABEND-CHECK EQUAL 'Y'                             
                  EVALUATE CMN-TABLE-ELEMENT-3                          
                     WHEN '6000'                                        
                        MOVE 6000                 TO CMN-RETURN-CODE    
                        MOVE SPACES               TO CMN-TABLE-ELEMENT-3
                     WHEN '7000'                                        
                        MOVE 7000                 TO CMN-RETURN-CODE    
                        MOVE SPACES               TO CMN-TABLE-ELEMENT-3
C28165               WHEN '7500'                                        
C28165                  MOVE 7500                 TO CMN-RETURN-CODE    
C28165                  MOVE SPACES               TO CMN-TABLE-ELEMENT-3
C28165               WHEN '7600'                                        
C28165                  MOVE 7600                 TO CMN-RETURN-CODE    
C28165                  MOVE SPACES               TO CMN-TABLE-ELEMENT-3
C30586               WHEN '7700'                                        
C30586                  MOVE 7700                 TO CMN-RETURN-CODE    
C30586                  MOVE SPACES               TO CMN-TABLE-ELEMENT-3
C30586               WHEN '7800'                                        
C30586                  MOVE 7800                 TO CMN-RETURN-CODE    
C30586                  MOVE SPACES               TO CMN-TABLE-ELEMENT-3
C30586            END-EVALUATE                                          
T5172             PERFORM 9800-ABEND-TABLE-INFO    THRU 9800-EXIT       
T5172             PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT       
T5172             PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT       
T5172          END-IF                                                   
           END-IF.                                                      
                                                                        
      ****** PCSSO065 PROCESSES METER INSTALLATIONS ******              14520000
           IF  WS-CODE-SO-UTILITY        = WS-A                         
               OR  WS-CODE-SO-METER      = WS-A                         
               OR  WS-CODE-SO-FACTORS    = WS-A                         
               OR  WS-CODE-SO-REGISTER   = WS-A                         
               OR  WS-CODE-SO-UNMETERED  = WS-A                         
               OR  WS-ORDER-TYPE-CD-2    = WS-CC                        
               OR  WS-ORDER-TYPE-CD-2    = WS-NC                        
                                                                        
               PERFORM 9550-CALL-PCSSO065          THRU 9550-EXIT       
                                                                        
T5172          IF CMN-ABEND-CHECK EQUAL 'Y'                             
                  IF CMN-TABLE-ELEMENT-3 = '7000'                       
                     MOVE 7000                    TO CMN-RETURN-CODE    
                     MOVE SPACES                  TO CMN-TABLE-ELEMENT-3
T19609            ELSE                                                  
T19609                IF CMN-TABLE-ELEMENT-3 = '5540'                   
T19609                   MOVE 5540                TO CMN-RETURN-CODE    
T19609                   MOVE SPACES              TO CMN-TABLE-ELEMENT-3
C28165                ELSE                                              
C28165                   IF CMN-TABLE-ELEMENT-3 = '7500'                
C28165                      MOVE 7500             TO CMN-RETURN-CODE    
C28165                      MOVE SPACES           TO CMN-TABLE-ELEMENT-3
C28165                   ELSE                                           
C28165                      IF CMN-TABLE-ELEMENT-3 = '7600'             
C28165                         MOVE 7600          TO CMN-RETURN-CODE    
C28165                         MOVE SPACES        TO CMN-TABLE-ELEMENT-3
C28165                      END-IF                                      
C28165                   END-IF                                         
T19609                END-IF                                            
                  END-IF                                                
T5172             PERFORM 9800-ABEND-TABLE-INFO    THRU 9800-EXIT       
T5172             PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT       
T5172             PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT       
T5172          END-IF                                                   
           END-IF.                                                      
                                                                        
      ****** PCSSO066 PROCESSES TRANSFERS ******                        14710000
           IF WS-CODE-SO-ACCT-XFER  = WS-A                              
              OR WS-ORDER-TYPE-CD-2 = WS-NC                             
                                                                        
              MOVE WS-CODE-SO-FINAL-BILL      TO CMN-CODE-SO-FINAL-BILL 
                                                                        
              PERFORM 9560-CALL-PCSSO066           THRU 9560-EXIT       
                                                                        
T5172         IF CMN-ABEND-CHECK EQUAL 'Y'                              
                 IF CMN-TABLE-ELEMENT-1 = 'X'                           
                    MOVE 4000                   TO CMN-RETURN-CODE      
                    MOVE SPACES                 TO CMN-TABLE-ELEMENT-1  
                 END-IF                                                 
T18037           IF CMN-TABLE-ELEMENT-1 = 'Y'                           
T18037              MOVE 4050                   TO CMN-RETURN-CODE      
T18037              MOVE SPACES                 TO CMN-TABLE-ELEMENT-1  
T18037           END-IF                                                 
T5172            PERFORM 9800-ABEND-TABLE-INFO     THRU 9800-EXIT       
T5172            PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT       
T5172            PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT       
T5172         END-IF                                                    
           END-IF.                                                      
                                                                        
      ****** PCSSO067 POST SERVICE ORDER CHARGES ******                 14850000
T9617      PERFORM 5320-PROCESS-SO-CHARGES         THRU 5320-EXIT.      
                                                                        
      ****** PCSSO062 PROCESSES FINAL BILLS ******                      14880000
           IF AT-CODE-ACCT-STAT = WS-A                                  
              IF WS-CODE-SO-FINAL-BILL  = WS-A                          
                 OR WS-ORDER-TYPE-CD-2  = WS-OFF                        
                 OR WS-ORDER-TYPE-CD-5  = WS-DNPFB                      
                 OR WS-ORDER-TYPE-CD-2  = WS-CC                         
                 OR WS-ORDER-TYPE-CD-2  = WS-NC                         
                                                                        
                 PERFORM 9520-CALL-PCSSO062        THRU 9520-EXIT       
                                                                        
T5172            IF CMN-ABEND-CHECK EQUAL 'Y'                           
T5172               PERFORM 9800-ABEND-TABLE-INFO  THRU 9800-EXIT       
T5172               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
T5172               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
T5172            END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5310-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
T9617 ******************************************************************15110000
T9617 * 5320-PROCESS-SO-CHARGES.                                       *15120000
T9617 *                                                                *15130000
T9617 *                                                                *15140000
T9617 ******************************************************************15150000
T9617  5320-PROCESS-SO-CHARGES.                                         
T9617                                                                   
T9617      IF WS-CODE-APPLY-CHARGES = WS-A                              
T9617         OR WS-ORDER-TYPE-CD-5 = WS-FM006                          
T9617         OR WS-ORDER-TYPE-CD-5 = WS-FM008                          
P00196        OR WS-ORDER-TYPE-CD-5 = WS-FW026                          
T9617         OR WS-ORDER-TYPE-CD-5 = WS-ENDV                           
T9617                                                                   
T9617         PERFORM 9570-CALL-PCSSO067        THRU 9570-EXIT          
T9617                                                                   
T9617         IF CMN-ABEND-CHECK EQUAL 'Y'                              
T9617            PERFORM 9800-ABEND-TABLE-INFO  THRU 9800-EXIT          
T9617            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
T9617            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
T9617         END-IF                                                    
T9617      END-IF.                                                      
T9617                                                                   
T9617  5320-EXIT.                                                       
T9617      EXIT.                                                        
                                                                        
C37061     EXEC SQL                                                             
C37061        INCLUDE CPD00067                                                  
C37061     END-EXEC.                                                            
                                                                        
C37061     EXEC SQL                                                             
C37061        INCLUDE CPD00118                                                  
C37061     END-EXEC.                                                            
                                                                        
C37061 6999-CPD118-ERROR-ROUTINE.                                       
C37061                                                                  
C37061     MOVE '6999'                     TO ACTIVE-PARAGRAPH.         
C37061     MOVE WS-CPD118-RETURN-CODE      TO RS-RETURN-CODE.           
C37061     MOVE PROGRAM-NAME               TO ABEND-PROGRAM.            
C37061     PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
C37061     PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
C37061                                                                  
C37061 6999-CPD118-EXIT.                                                
C37061     EXIT.                                                        
                                                                        
      ******************************************************************19300000
      * 7000-GET-TODAYS-DATE                                           *19310000
      *                                                                *19320000
      *                                                                *19330000
      ******************************************************************19340000
       7000-GET-TODAYS-DATE.                                            
                                                                        
           MOVE '7000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-TODAYS-DATE                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-TODAYS-DATE                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP                              
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TIMESTAMP                                      
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************19630000
      * 7010-DETERMINE-CHECKS.                                         *19640000
      *                                                                *19650000
      *    THIS MODULE DETERMINES IF PCSSO062, PCSSO066 OR PCSSO067    *19660000
      *    ARE GOING TO BE EXECUTED BY THE POSTING PROCESS.  IF SO,    *19670000
      *    THEN INDICATORS WILL BE SET THAT TELLS THE S025 TO PERFORM  *19680000
      *    AN AR LOCKOUT AND TRANSFER CHECK BEFORE CONTINUING ON WITH  *19690000
      *    THE PROGRAM.                                                *19700000
      *                                                                *19710000
      ******************************************************************19720000
       7010-DETERMINE-CHECKS.                                           
                                                                        
           IF AT-CODE-ACCT-STAT = WS-A                                  
              IF WS-CODE-SO-FINAL-BILL  = WS-A                          
                 OR WS-ORDER-TYPE-CD-2  = WS-OFF                        
                 OR WS-ORDER-TYPE-CD-5  = WS-DNPFB                      
                 OR WS-ORDER-TYPE-CD-2  = WS-CC                         
                 OR WS-ORDER-TYPE-CD-2  = WS-NC                         
                                                                        
                 MOVE 'Y'                     TO WS-EXEC-PCSSO062       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-CODE-SO-ACCT-XFER  = WS-A                              
              OR WS-ORDER-TYPE-CD-2 = WS-NC                             
                                                                        
              MOVE 'Y'                        TO WS-EXEC-PCSSO066       
           END-IF.                                                      
                                                                        
           IF WS-CODE-APPLY-CHARGES = WS-A                              
              OR WS-ORDER-TYPE-CD-5 = WS-FM006                          
              OR WS-ORDER-TYPE-CD-5 = WS-FM008                          
P00196        OR WS-ORDER-TYPE-CD-5 = WS-FW026                          
              OR WS-ORDER-TYPE-CD-5 = WS-ENDV                           
                                                                        
              MOVE 'Y'                        TO WS-EXEC-PCSSO067       
           END-IF.                                                      
                                                                        
           IF WS-EXEC-PCSSO062 = 'Y' OR WS-EXEC-PCSSO066 = 'Y'          
              OR WS-EXEC-PCSSO067 = 'Y'                                 
                                                                        
              PERFORM 7020-CHECK-AR-LOCKOUT     THRU 7020-EXIT          
                                                                        
              IF AL-AR-LOCKOUT-IND = 'Y'                                
                 MOVE 5000                      TO RS-RETURN-CODE       
                 MOVE 'Y'                       TO RS-AR-LOCKOUT-IND    
                 MOVE 'AR LOCKOUT'              TO TABLE-1              
                 PERFORM 8100-SEND-RESULT       THRU 8100-EXIT          
C35927           EXEC SQL                                               
C35927               ROLLBACK                                           
C35927           END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MAN010*          PERFORM 8900-SEND-DONE         THRU 8900-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
                                                                        
              IF AT-ACCT-XFER-TO > 0 AND AT-MST-SUB-ACCT-IND NOT = 'S'  
T18932            IF AT-CODE-ACCT-STAT = 'B' OR 'J' OR 'S'              
T18932                NEXT SENTENCE                                     
T18932            ELSE                                                  
                      MOVE 5000                 TO RS-RETURN-CODE       
                      MOVE AT-ACCT-XFER-TO      TO RS-ACCT-XFER-NO      
                      MOVE 'ACCT TRANSFERRED'   TO TABLE-1              
                      PERFORM 8100-SEND-RESULT  THRU 8100-EXIT          
C35927                EXEC SQL                                          
C35927                    ROLLBACK                                      
C35927                END-EXEC                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                      PERFORM 8900-SEND-DONE    THRU 8900-EXIT          
                      PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT     
T18932            END-IF                                                
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***************************************************************** 20320000
      * 7020-CHECK-AR-LOCKOUT                                         * 20330000
      *                                                               * 20340000
      *                                                               * 20350000
      *                                                               * 20360000
      ***************************************************************** 20370000
       7020-CHECK-AR-LOCKOUT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT AR_LOCKOUT_IND                                     
                INTO :AL-AR-LOCKOUT-IND                                 
                FROM CSS_AR_LOCKOUT                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     20400000
MFA-TR*       SELECT AR_LOCKOUT_IND                                     20410000
MFA-TR*         INTO :AL-AR-LOCKOUT-IND                                 20420000
MFA-TR*         FROM CSS_AR_LOCKOUT                                     20430000
MFA-TR*         QUERYNO 7020                                                    
MFA-TR*    END-EXEC.                                                    20440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7020'                     TO ACTIVE-PARAGRAPH       
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
CBSI          MOVE 'CSS_AR_LOCKOUT'           TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************21050000
      * 7200-SELECT-ACCOUNT                                            *21060000
      *                                                                *21070000
      * GET ACCOUNT DETAILS THAT WILL BE REQUIRED BY THE POSTING       *21080000
      * PROGRAMS                                                       *21090000
      *                                                                *21100000
      ******************************************************************21110000
       7200-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7200'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                SELECT CUSTOMER_NO    ,                                 
                       CODE_ACCT_STAT ,                                 
                       ACCT_XFER_TO   ,                                 
                       MST_SUB_ACCT_IND                                 
                  INTO :AT-CUSTOMER-NO   ,                              
                       :AT-CODE-ACCT-STAT,                              
                       :AT-ACCT-XFER-TO  ,                              
                       :AT-MST-SUB-ACCT-IND                             
                  FROM CSS_ACCOUNT                                      
                 WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     21160000
MFA-TR*         SELECT CUSTOMER_NO    ,                                 21170000
MFA-TR*                CODE_ACCT_STAT ,                                 21180000
MFA-TR*                ACCT_XFER_TO   ,                                 21190000
MFA-TR*                MST_SUB_ACCT_IND                                 21200000
MFA-TR*           INTO :AT-CUSTOMER-NO   ,                              21210000
MFA-TR*                :AT-CODE-ACCT-STAT,                              21220000
MFA-TR*                :AT-ACCT-XFER-TO  ,                              21230000
MFA-TR*                :AT-MST-SUB-ACCT-IND                             21240000
MFA-TR*           FROM CSS_ACCOUNT                                      21250000
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      21260000
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                    21270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
CBSI          MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-RESPONSIBLE-AREA.                                           
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE                                   
               WHERE USER_ID = :PARM-USER-ID                            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :PARM-USER-ID                                    
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO PF-RESP-AREA-ID                       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE SPACES                TO ABEND-SQL-PREDICATES   
                                                      ABEND-TABLES      
                   MOVE 'CSS_USER_PROFILE'    TO TABLE-1                
                   MOVE 'USER_ID'             TO TABLE-ELEMENT-1        
                   MOVE PARM-USER-ID          TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
C34590 8400-UPDATE-METER-DATES.                                         
C34590                                                                  
C34590     MOVE '8400' TO ACTIVE-PARAGRAPH.                             
C34590                                                                  
C34590     MOVE SPACES TO MN-METER-INACTIVE-DT                          
C34590                    MN-METER-REMOVED-DT.                          
C34590     MOVE -1 TO WS-NULL1 WS-NULL2.                                
C34590                                                                  
C34590     EXEC SQL                                                     
C34590       UPDATE CSS_MTRD_ENVRNMT                                    
C34590          SET METER_INACTIVE_DT = IIF(TRY_CONVERT(DATE, 
                                                 :MN-METER-INACTIVE-DT 
                                                              :WS-NULL1
              ) IS NULL OR (PATINDEX('%.%', :MN-METER-INACTIVE-DT 
                                                              :WS-NULL1
              ) <> 0) OR (LEN(:MN-METER-INACTIVE-DT :WS-NULL1
              ) <> 10), CIS.CHAR2DATE(:MN-METER-INACTIVE-DT :WS-NULL1
              ), CONVERT(DATE, :MN-METER-INACTIVE-DT :WS-NULL1) ),
C34590              METER_REMOVED_DT = IIF(TRY_CONVERT(DATE, 
                                                  :MN-METER-REMOVED-DT 
                                                             :WS-NULL2
              ) IS NULL OR (PATINDEX('%.%', :MN-METER-REMOVED-DT 
                                                              :WS-NULL2
              ) <> 0) OR (LEN(:MN-METER-REMOVED-DT :WS-NULL2
              ) <> 10), CIS.CHAR2DATE(:MN-METER-REMOVED-DT :WS-NULL2
              ), CONVERT(DATE, :MN-METER-REMOVED-DT :WS-NULL2) )   
C34590       WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                          
C34590         AND CODE_METER_STATUS IN ('A', 'B', 'I')                 
                                                            
C34590     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     22970000
MFA-TR*      UPDATE CSS_MTRD_ENVRNMT                                    22980000
MFA-TR*         SET METER_INACTIVE_DT = :MN-METER-INACTIVE-DT :WS-NULL1,        
MFA-TR*             METER_REMOVED_DT = :MN-METER-REMOVED-DT :WS-NULL2           
MFA-TR*      WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                          22990000
MFA-TR*        AND CODE_METER_STATUS IN ('A', 'B', 'I')                         
MFA-TR*         QUERYNO 8400                                                    
MFA-TR*    END-EXEC.                                                    23000000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34590                                                                  
C34590     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C34590                                                                  
C34590     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C34590         NEXT SENTENCE                                            
C34590     ELSE                                                         
C34590        MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
C34590        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C34590        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
C34590        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
C34590                                           ABEND-TABLES           
C34590        MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
C34590        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
C34590        MOVE MN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
C34590        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C34590        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C34590     END-IF.                                                      
C34590                                                                  
C34590 8400-EXIT.                                                       
C34590     EXIT.                                                        
                                                                        
C37061 8500-UPDATE-ACCT-TYPE.                                           
C37061                                                                  
C37061     MOVE '8500' TO ACTIVE-PARAGRAPH.                             
C37061                                                                  
C37061     EXEC SQL                                                     
C37061       SELECT ACCOUNT_TYPE_CODE                                   
C37061         INTO :AT-ACCOUNT-TYPE-CODE                               
C37061         FROM CSS_ACCOUNT                                         
C37061       WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                          
                                                           
C37061     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     22970000
MFA-TR*      SELECT ACCOUNT_TYPE_CODE                                   22980000
MFA-TR*        INTO :AT-ACCOUNT-TYPE-CODE                                       
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*      WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                          22990000
MFA-TR*         QUERYNO 85001                                                   
MFA-TR*    END-EXEC.                                                    23000000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37061                                                                  
C37061     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C37061                                                                  
C37061     EVALUATE WS-ACTIVE-RETURN-CODE                               
C37061         WHEN SUCCESSFUL-CALL                                     
C37061             MOVE AT-ACCOUNT-TYPE-CODE TO WS-OLD-ACCT-TYPE        
C37061         WHEN NOT-FOUND                                           
C37061             MOVE SPACES TO WS-OLD-ACCT-TYPE                      
C37061         WHEN OTHER                                               
C37061             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
C37061             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
C37061             MOVE 'SELECT'              TO ABEND-FUNCTION         
C37061             MOVE SPACES                TO ABEND-SQL-PREDICATES   
C37061                                                ABEND-TABLES      
C37061             MOVE 'CSS_ACCOUNT'         TO TABLE-1                
C37061             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
C37061             MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
C37061             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
C37061             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
C37061     END-EVALUATE.                                                
C37061                                                                  
C37061     MOVE WS-CPD118-ACCT-TYPE-CODE TO AT-ACCOUNT-TYPE-CODE        
C37061                                      WS-NEW-ACCT-TYPE.           
C37061                                                                  
C37061     EXEC SQL                                                     
C37061       UPDATE CSS_ACCOUNT                                         
C37061          SET ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE           
C37061       WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                          
                                                           
C37061     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     22970000
MFA-TR*      UPDATE CSS_ACCOUNT                                         22980000
MFA-TR*         SET ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE                   
MFA-TR*      WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                          22990000
MFA-TR*         QUERYNO 85002                                                   
MFA-TR*    END-EXEC.                                                    23000000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37061                                                                  
C37061     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C37061                                                                  
C37061     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C37061         NEXT SENTENCE                                            
C37061     ELSE                                                         
C37061        MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
C37061        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C37061        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
C37061        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
C37061                                           ABEND-TABLES           
C37061        MOVE 'CSS_ACCOUNT'              TO TABLE-1                
C37061        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
C37061        MOVE UT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
C37061        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C37061        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C37061     END-IF.                                                      
C37061                                                                  
C37061 8500-EXIT.                                                       
C37061     EXIT.                                                        
                                                                        
      ******************************************************************23900000
      * 9510-CALL-PCSSO061                                             *23910000
      *                                                                *23920000
      *                                                                *23930000
      ******************************************************************23940000
       9510-CALL-PCSSO061.                                              
                                                                        
           MOVE '9510'                        TO ACTIVE-PARAGRAPH.      
                                                                        
REARCH     CALL PCSSO061  USING  CMN-SO100-LINK-AREA.                   
                                                                        
           MOVE '9510'                        TO ACTIVE-PARAGRAPH.      
                                                                        
       9510-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************24190000
      * 9520-CALL-PCSSO062                                             *24200000
      *                                                                *24210000
      *                                                                *24220000
      ******************************************************************24230000
       9520-CALL-PCSSO062.                                              
                                                                        
REARCH     CALL PCSSO062  USING  CMN-SO100-LINK-AREA.                   
                                                                        
       9520-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************24680000
      * 9540-CALL-PCSSO064                                             *24690000
      *                                                                *24700000
      *                                                                *24710000
      ******************************************************************24720000
       9540-CALL-PCSSO064.                                              
                                                                        
REARCH     CALL PCSSO064  USING  CMN-SO100-LINK-AREA.                   
                                                                        
       9540-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************24930000
      * 9550-CALL-PCSSO065                                             *24940000
      *                                                                *24950000
      *                                                                *24960000
      ******************************************************************24970000
       9550-CALL-PCSSO065.                                              
                                                                        
REARCH     CALL PCSSO065  USING  CMN-SO100-LINK-AREA.                   
                                                                        
       9550-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************25180000
      * 9560-CALL-PCSSO066                                             *25190000
      *                                                                *25200000
      *                                                                *25210000
      ******************************************************************25220000
       9560-CALL-PCSSO066.                                              
                                                                        
REARCH     CALL PCSSO066  USING  CMN-SO100-LINK-AREA.                   
                                                                        
       9560-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************25430000
      * 9570-CALL-PCSSO067                                             *25440000
      *                                                                *25450000
      *                                                                *25460000
      ******************************************************************25470000
       9570-CALL-PCSSO067.                                              
                                                                        
REARCH     CALL PCSSO067  USING  CMN-SO100-LINK-AREA.                   
                                                                        
       9570-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************25680000
      * 9600-COMMIT-WORK                                               *25690000
      *                                                                *25700000
      *                                                                *25710000
      ******************************************************************25720000
       9600-COMMIT-WORK.                                                
REARCH*                                                                 25740000
REARCH*    EXEC CICS                                                    25750000
REARCH*         SYNCPOINT                                               25760000
REARCH*    END-EXEC.                                                    25770000
REARCH*                                                                 25780000
REARCH*    EXEC CICS HANDLE ABEND LABEL(9900-SQL-ERROR-ROUTINE)         25790000
REARCH*    END-EXEC.                                                    25800000
                                                                        
       9600-EXIT.                                                       
           EXIT.                                                        
                                                                        
T5172 ***************************************************************** 26360000
T5172 * 9800-ABEND-TABLE-INFO                                         * 26370000
T5172 *                                                               * 26380000
T5172 * MOVE THE ABEND TABLE AND VARIABLE INFORMATION FROM THE        * 26390000
T5172 * LINKAGE SECTION TO THE VARIABLES USED IN PCSMC005 AND IN THE  * 26400000
T5172 * RETURN TO THE DESKTOP.                                        * 26410000
T5172 *                                                               * 26420000
T5172 ***************************************************************** 26430000
T5172  9800-ABEND-TABLE-INFO.                                           
T5172                                                                   
T5172      MOVE CMN-RETURN-CODE               TO SQLCODE                
t5172                                            WS-ACTIVE-RETURN-CODE  
T5172                                            RS-RETURN-CODE.        
T5172      MOVE CMN-ACTIVE-PARAGRAPH          TO ACTIVE-PARAGRAPH.      
T5172      MOVE CMN-PROGRAM-NAME              TO ABEND-PROGRAM          
T5172                                            PROGRAM-NAME.          
T5172                                                                   
T5172      MOVE CMN-TABLE-1                   TO TABLE-1.               
T5172      MOVE CMN-TABLE-2                   TO TABLE-2.               
T5172      MOVE CMN-TABLE-3                   TO TABLE-3.               
T5172      MOVE CMN-TABLE-4                   TO TABLE-4.               
T5172                                                                   
T5172      MOVE CMN-TABLE-ELEMENT-1           TO TABLE-ELEMENT-1.       
T5172      MOVE CMN-TABLE-ELEMENT-2           TO TABLE-ELEMENT-2.       
T5172      MOVE CMN-TABLE-ELEMENT-3           TO TABLE-ELEMENT-3.       
T5172      MOVE CMN-TABLE-ELEMENT-4           TO TABLE-ELEMENT-4.       
T5172                                                                   
T5172      MOVE CMN-HOSTVAR-ELEMENT-1         TO HOSTVAR-ELEMENT-1.     
T5172      MOVE CMN-HOSTVAR-ELEMENT-2         TO HOSTVAR-ELEMENT-2.     
T5172      MOVE CMN-HOSTVAR-ELEMENT-3         TO HOSTVAR-ELEMENT-3.     
T5172      MOVE CMN-HOSTVAR-ELEMENT-4         TO HOSTVAR-ELEMENT-4.     
T5172                                                                   
T5172  9800-EXIT.                                                       
T5172      EXIT.                                                        
                                                                        
      ***************************************************************** 26720000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                     * 26730000
      ***************************************************************** 26740000
                                                                        
REARCH     EXEC SQL                                                     26750000
REARCH        INCLUDE CPDSP300                                          26760000
REARCH     END-EXEC.                                                    26770000
                                                                        
      ******************************************************************26810000
REARCH* CHANGED COPYBOOK FROM CPD00321 TO CPD00331. CPD00331 INCLUDES           
REARCH* COMMIT.                                                                 
      ******************************************************************26810000
                                                                        
REARCH     EXEC SQL                                                     00000100
REARCH         INCLUDE CPD00331                                         00000200
REARCH     END-EXEC.                                                    00000300
                                                                        
REARCH 8100-SEND-RESULT.                                                
REARCH       ADD 1 TO CTR-ROWS.                                         
REARCH 8100-EXIT.                                                       
REARCH        EXIT.                                                     
                                                                        
                                                                        
