000100 IDENTIFICATION DIVISION.                                         
000200 PROGRAM-ID.    CSR02024.                                         
COB303 DATE-WRITTEN.  MAY 4, 1995.                                      
000400 DATE-COMPILED.                                                   
000500                                                                  
000600******************************************************************00060000
000700*                                                                *00070000
000800*                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
001500*                                                                *00150000
001600******************************************************************00160000
001700*                 P R O G R A M  S U M M A R Y                   *00170000
001800*                                                                *00180000
001900*  THIS PROCEDURE INSERTS/UPDATES ROWS FOR CSS_CRED_COLL.        *00190000
002000*                                                                *00200000
002100******************************************************************00210000
002200*                                                                *00220000
002300*                     PROGRAM MODIFICATION LOG                   *00230000
002400*                                                                *00240000
002500*    DATE    INITIALS   COMMENTS                                 *00250000
002600*  --------  --------   ---------------------------------------  *00260000
002700*  05/04/95    SAG      PROCEDURE ORIGINALLY CODED.              *00270000
002710*  02/16/96    MB       TPR#2990 - COMPARISON OF ENTERED AMOUNTS *00271000
002720*                       WITH DELINQUENCY LIMITS, INCORPORATED    *00272000
      *  10/01/96    JEP      TPR 5309 - MAJOR MODIFICATIONS, MOSTLY   *00272100
      *                       CONCERNING WORK QS, DELETE FUNCTIONALITY *00272200
      *  03/18/97    MJG      TPR 5309 - ACTUALLY ADDED THE DELETE SQL *00272300
      *                       TO THIS RPC.                             *00272400
      *  04/17/97    MJG      PCR 404 CHANGED THE APPL PGM DESC BASED  *00272500
      *                       ON WHETHER AN INSERT, UPDATE OR DELETE   *00272600
      *                       IS OCCURING.                             *00272700
T15860*  04/20/98    EMS      REMOVED THE DATE EDITS FROM THIS RPC.    *00272801
      *                       PANEL132 HANDLES THE VALIDATIONS.        *00272901
T16078*    5/04/98   ZB17046  MAKE CORRECTION TO MC05 LOGIC WHERE IN   *00273000
T16078*                       SEVERAL CASES THE FIELDS OR FIELD NAMES  *00273100
T16078*                       WERE NOT BEING MOVED TO THE ABEND WORK   *00273200
T16078*                       AREA.                                    *00273300
CBSI  *  17/07/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    TABLE PARAMETERS                         *        
C23235*  03/13/01   LEF       ADDED FIELD DATE AS DATE ACTION F        *        
C23235*             PSNC CHANGE                                        *        
      *                                                                *        
REARCH*  07/10/03   MR90712    RPC CONVERTED TO COBOL SP               *        
002730******************************************************************00273000
002740******************************************************************00274000
002750*                                                                *00275000
002760*                ---- BASIC SEQUENCE STRUCTURE ----              *00276000
002770*                                                                *00277000
002780*  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00278000
002790*  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00279000
002800*  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00280000
002900*  3000 - 4999  NOT USED                                         *00290000
003000*  5000 - 5999  COMMON PROGRAM MODULES                           *00300000
003100*  6000 - 6999  COMMON SYSTEM MODULES                            *00310000
003200*  7000 - 7999  INPUT MODULES                                    *00320000
003300*  8000 - 8999  OUTPUT MODULES                                   *00330000
003400*  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00340000
003500*                                                                *00350000
003600******************************************************************00360000
003700                                                                  
003800 ENVIRONMENT DIVISION.                                            
003900 DATA DIVISION.                                                   
004000 WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02024'.
MSQ017     COPY MFASQLM.
004100                                                                  
004200******************************************************************00420000
004300*    DB2 INCLUDES                                                *00430000
004400******************************************************************00440000
004500                                                                  
004600     EXEC SQL                                                     00460000
004700        INCLUDE SQLCA                                             00470000
004800     END-EXEC.                                                    00480000
004900                                                                  
005000     EXEC SQL                                                     00500000
005100        INCLUDE TBMODEL                                           00510000
005200     END-EXEC.                                                    00520000
005300                                                                  
005400     EXEC SQL                                                     00540000
005500        INCLUDE TBMNHIST                                          00550000
005600     END-EXEC.                                                    00560000
005700                                                                  
005800     EXEC SQL                                                     00580000
005900        INCLUDE TBMNHDT                                           00590000
006000     END-EXEC.                                                    00600000
006100                                                                  
006200     EXEC SQL                                                     00620000
006300        INCLUDE TBUSRPRF                                          00630000
006400     END-EXEC.                                                    00640000
006500                                                                  
006600     EXEC SQL                                                     00660000
006700        INCLUDE TBCRCOLL                                          00670000
006800     END-EXEC.                                                    00680000
006900                                                                  
007000     EXEC SQL                                                     00700000
007100        INCLUDE TBHLDAY                                           00710000
007200     END-EXEC.                                                    00720000
007300                                                                  
007400     EXEC SQL                                                     00740000
007500        INCLUDE TBDELQ                                            00750000
007600     END-EXEC.                                                    00760000
007700                                                                  
007400     EXEC SQL                                                     00740000
007500        INCLUDE TBRSAREA                                          00750000
007600     END-EXEC.                                                    00760000
007700                                                                  
007800******************************************************************00780000
007900*    COBOL WORKING STORAGE COPY BOOKS                            *00790000
008000******************************************************************00800000
008100                                                                  
008400     COPY CCA00001.                                               00840000
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
008600     COPY CWS00027.                                               00860000
008700     COPY CWS00303.                                               00870000
008800                                                                  
008900******************************************************************00890000
009000*    WORK AREAS                                                  *00900000
009100******************************************************************00910000
009200                                                                  
009300 01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME              PIC X(8) VALUE 'CSR02024'.     
REARCH     05  WS-SQLSTATE               PIC X(5) VALUE SPACES.         
009500     05  ALL-DONE-SW               PIC X(1) VALUE 'N'.            
009600         88 NOT-ALL-DONE                    VALUE 'N'.            
009700         88 ALL-DONE                        VALUE 'Y'.            
009800     05  SEND-DONE-SW              PIC X(1) VALUE 'Y'.            
009900         88  SEND-DONE-ERROR       VALUE 'N'.                     
010000         88  SEND-DONE-OK          VALUE 'Y'.                     
010100     05  WS-BAD-WORKING-DAY        PIC X(1).                      
010200         88  BAD-WORKING-DAY       VALUE 'N'.                     
010300         88  GOOD-WORKING-DAY      VALUE 'Y'.                     
010400     05  WS-DAY                    PIC S9(04) COMP.               
010500     05  WS-BUS-DAYS               PIC S9(04) COMP.               
010600     05  WS-ROW-COUNT              PIC S9(09) COMP.               
010700     05  WS-WORK-DATE              PIC X(10).                     
010800     05  WS-DATE-TO                PIC X(10).                     
010900     05  WS-TRAN-APPL-NO           PIC S9(04) COMP.               
COB305     05 WS-ACCOUNT-NO        PIC S9(13) USAGE COMP-3 VALUE 0.       
011100     05  WS-CODE-NOTICE-TYPE       PIC X(1).                      
COB305     05 WS-AMT-NOTICE        PIC S9(9)V99 COMP-3 VALUE 0.           
011300     05  WS-AMT-DISPLAY            PIC -ZZZ,ZZZ,ZZ9.99.           
011400     05  WS-ROW-NAME               PIC X(20).                     
011500     05  WS-DATE-MAIL              PIC X(10).                     
011600     05  WS-DATE-DUE               PIC X(10).                     
011700     05  WS-DATE-CRED              PIC X(10).                     
011800     05  WS-NULL-MAIL              PIC S9(4) COMP.                
011900     05  WS-NULL-DUE               PIC S9(4) COMP.                
012000     05  WS-NULL-CRED              PIC S9(4) COMP.                
012100     05  WS-ROW-EXISTS             PIC X.                         
012200         88  ROW-EXISTS            VALUE 'Y'.                     
012300         88  ROW-NOT-EXIST         VALUE 'N'.                     
012400     05  WS-B                      PIC X VALUE 'B'.               
012500     05  WS-C                      PIC X VALUE 'C'.               
012600     05  WS-D                      PIC X VALUE 'D'.               
012700     05  WS-E                      PIC X VALUE 'E'.               
012800     05  WS-F                      PIC X VALUE 'F'.               
012900     05  WS-G                      PIC X VALUE 'G'.               
013000     05  WS-AMT-NOTICE-FLAG        PIC X.                         
013100         88  AMT-NOTICE-CHANGED    VALUE 'Y'.                     
013200         88  AMT-NOTICE-UNCHANGED  VALUE 'N'.                     
013300     05  WS-DATE-MAIL-FLAG         PIC X.                         
013400         88  DATE-MAIL-CHANGED     VALUE 'Y'.                     
013500         88  DATE-MAIL-UNCHANGED   VALUE 'N'.                     
013600     05  WS-DATE-DUE-FLAG          PIC X.                         
013700         88  DATE-DUE-CHANGED      VALUE 'Y'.                     
013800         88  DATE-DUE-UNCHANGED    VALUE 'N'.                     
013900     05  WS-DATE-CRED-FLAG         PIC X.                         
014000         88  DATE-CRED-CHANGED     VALUE 'Y'.                     
014100         88  DATE-CRED-UNCHANGED   VALUE 'N'.                     
COB305     05 SV-AMT-NOTICE        PIC S9(9)V99 COMP-3 VALUE 0.           
014300     05  SV-DATE-NOTICE-MAIL       PIC X(10).                     
014400     05  SV-DATE-NOTICE-DUE        PIC X(10).                     
014500     05  SV-DATE-CREDIT-ACTION     PIC X(10).                     
014600     05  WS-DN-SPEC-DNP-LIM        PIC X(20)                      
014700                                   VALUE 'AMT-SPECIALDNPLIM   '.  
014800     05  WS-AMT-SPECIAL-DNP-LIM    PIC S9(9)V99 COMP-3            
014900                                   VALUE 0.                       
           05  WS-SUPR-ID              PIC X(7)   VALUE SPACES.         
           05  WS-USER-ID              PIC X(7)   VALUE SPACES.         
015000     05  WS-RESP-AREA-ID         PIC X(03)  VALUE SPACES.         
015000     05  WS-DELETED              PIC X(01)  VALUE 'N'.            
PCR404     05  WS-ACTION               PIC X(01)  VALUE SPACE.          
PCR404     05  WS-EXISTS               PIC X(01)  VALUE SPACE.          
PCR404     05  WS-APPL-PROG            PIC X(09)  VALUE SPACE.          
                                                                        
016200 01  PARM-FIELDS.                                                 
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC X(13).                       
REARCH     05  PARM-ACCOUNT-NO-NUM     REDEFINES PARM-ACCOUNT-NO-TEMP   
REARCH                                 PIC 9(13).                       
REARCH     05  PARM-E-CHANGED-TEMP     PIC X.                           
017500         88  E-CHANGED           VALUE 'Y'.                       
017500         88  E-DELETED           VALUE 'D'.                       
REARCH     05  PARM-E-AMT-NOTICE-TEMP  PIC X(13).                       
REARCH     05  PARM-E-AMT-NOTICE-NUM   REDEFINES PARM-E-AMT-NOTICE-TEMP 
REARCH                                 PIC 9(13).                       
018200                                                                  
REARCH     05  PARM-F-CHANGED-TEMP     PIC X.                           
018400         88  F-CHANGED           VALUE 'Y'.                       
018400         88  F-DELETED           VALUE 'D'.                       
REARCH     05  PARM-F-AMT-NOTICE-TEMP  PIC X(13).                       
REARCH     05  PARM-F-AMT-NOTICE-NUM   REDEFINES PARM-F-AMT-NOTICE-TEMP 
REARCH                                 PIC 9(13).                       
REARCH     05  PARM-G-CHANGED-TEMP     PIC X.                           
019200         88  G-CHANGED           VALUE 'Y'.                       
019200         88  G-DELETED           VALUE 'D'.                       
REARCH     05  PARM-G-AMT-NOTICE-TEMP  PIC X(13).                       
REARCH     05  PARM-G-AMT-NOTICE-NUM   REDEFINES PARM-G-AMT-NOTICE-TEMP 
REARCH                                 PIC 9(13).                       
019700                                                                  
019800 01  SNA-FIELDS.                                                  
019900     05  SNA-SUBC                PIC S9(9) COMP.                  
020000     05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
020100                                                                  
020200 01  COUNTER-FIELDS.                                              
020300     05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
020400     05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
020500                                                                  
020600 01  WORK-FIELDS.                                                 
020700     05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
020800     05  WRKLEN1                 PIC S9(9) COMP.                  
020900     05  WRKLEN2                 PIC S9(9) COMP.                  
021000     05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
021100                                                                  
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                      VALUE 'SESSION.CSR02024_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
021200 01  TDS-RETURN-FIELDS.                                           
021300     05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
021400     05  RS-ERROR-COLUMN          PIC X(20).                      
           05  RS-RESP-AREA-ID          PIC X(03) VALUE SPACES.         
           05  RS-SUPR-ID               PIC X(07) VALUE SPACES.         
      *                                                                         
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
REARCH     05  S-ERROR-COLUMN           PIC X(20).                      
REARCH     05  S-RESP-AREA-ID           PIC X(03) VALUE SPACES.         
REARCH     05  S-SUPR-ID                PIC X(07) VALUE SPACES.         
REARCH*                                                                         
                                                                        
      *                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-ACCOUNT-NO              PIC X(13).                      
REARCH 01  PARM-ITEM-ID                 PIC S9(9) COMP.                 
REARCH 01  PARM-USER-ID                 PIC X(7).                       
REARCH 01  PARM-COMMENTS-LEN            PIC S9(4) COMP SYNC.            
REARCH 01  PARM-COMMENTS-TEXT           PIC X(254).                     
REARCH 01  PARM-E-CHANGED               PIC X.                          
REARCH 01  PARM-E-TYPE                  PIC X.                          
REARCH 01  PARM-E-AMT-NOTICE            PIC X(13).                      
REARCH 01  PARM-E-DATE-MAILED           PIC X(10).                      
REARCH 01  PARM-E-DATE-DUE              PIC X(10).                      
REARCH 01  PARM-F-CHANGED               PIC X.                          
REARCH 01  PARM-F-AMT-NOTICE            PIC X(13).                      
REARCH 01  PARM-F-DATE-ACTION           PIC X(10).                      
REARCH 01  PARM-F-DATE-MAILED           PIC X(10).                      
REARCH 01  PARM-F-DATE-DUE              PIC X(10).                      
REARCH 01  PARM-G-CHANGED               PIC X.                          
REARCH 01  PARM-G-AMT-NOTICE            PIC X(13).                      
REARCH 01  PARM-G-DATE-ACTION           PIC X(10).                      
REARCH 01  PARM-G-DATE-MAILED           PIC X(10).                      
REARCH*                                                                         
HPCCDM*EJECT                                                            02200000
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
REARCH                         ,PARM-ITEM-ID                            
REARCH                         ,PARM-USER-ID                            
REARCH                         ,PARM-COMMENTS-LEN                       
REARCH                         ,PARM-COMMENTS-TEXT                      
REARCH                         ,PARM-E-CHANGED                          
REARCH                         ,PARM-E-TYPE                             
REARCH                         ,PARM-E-AMT-NOTICE                       
REARCH                         ,PARM-E-DATE-MAILED                      
REARCH                         ,PARM-E-DATE-DUE                         
REARCH                         ,PARM-F-CHANGED                          
REARCH                         ,PARM-F-AMT-NOTICE                       
REARCH                         ,PARM-F-DATE-ACTION                      
REARCH                         ,PARM-F-DATE-MAILED                      
REARCH                         ,PARM-F-DATE-DUE                         
REARCH                         ,PARM-G-CHANGED                          
REARCH                         ,PARM-G-AMT-NOTICE                       
REARCH                         ,PARM-G-DATE-ACTION                      
REARCH                         ,PARM-G-DATE-MAILED.                     
022200                                                                  
022300******************************************************************02230000
022400* 0000-MAINLINE                                                  *02240000
022500*     CALLS 0100-INITIALIZE                                      *02250000
022600*           1000-PROCESS-INPUT                                   *02260000
022700*           2000-PROCESS-OUTPUT                                  *02270000
022800*           9999-END-PROGRAM                                     *02280000
022900*                                                                *02290000
023000*     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02300000
023100******************************************************************02310000
023200                                                                  
023300 0000-MAINLINE.                                                   
023400                                                                  
023500     PERFORM 0100-INITIALIZE                      THRU 0100-EXIT. 
023600     PERFORM 1000-PROCESS-INPUT                   THRU 1000-EXIT. 
023700     PERFORM 2000-PROCESS-OUTPUT                  THRU 2000-EXIT. 
023800     PERFORM 9999-END-PROGRAM                     THRU 9999-EXIT. 
023900                                                                  
024000 0000-EXIT.                                                       
024100     EXIT.                                                        
024200                                                                  
024300******************************************************************02430000
024400* 0100-INITIALIZE                                                *02440000
024500*     CALLS 9000-SEND-ERROR-RESULT                               *02450000
024600*           9900-SQL-ERROR-ROUTINE                               *02460000
024700*                                                                *02470000
024800*     CALLED FROM 0000-MAINLINE                                  *02480000
024900*                                                                *02490000
025000*     1. RESET DB2 ERROR HANDLERS                                *02500000
025100*     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02510000
025200*     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02520000
025300*     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02530000
025400*                                                                *02540000
025500******************************************************************02550000
025600                                                                  
025700 0100-INITIALIZE.                                                 
025800                                                                  
025900     EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
026000     EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
026100     EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
      *                                                                         
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH            :S-RETURN-CODE    AS RETURN_CODE                      
REARCH           ,:S-ERROR-COLUMN   AS ERROR_COLUMN                     
REARCH           ,:S-RESP-AREA-ID   AS RESP_AREA_ID                     
REARCH           ,:S-SUPR-ID        AS SUPR_ID                          
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*           :S-RETURN-CODE    AS RETURN_CODE                              
MFA-TR*          ,:S-ERROR-COLUMN   AS ERROR_COLUMN                             
MFA-TR*          ,:S-RESP-AREA-ID   AS RESP_AREA_ID                             
MFA-TR*          ,:S-SUPR-ID        AS SUPR_ID                                  
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC                                                             
REARCH*                                                                         
026200                                                                  
028120     INITIALIZE TDS-RETURN-FIELDS                                 
028130                DCLCSS-CRED-COLL.                                 
028140                                                                  
028150 0100-EXIT.                                                       
028160     EXIT.                                                        
028170                                                                  
REARCH*                                                                         
028180******************************************************************02818000
028190* 1000-PROCESS-INPUT                                             *02819000
028200*                                                                *02820000
028300*     CALLED FROM 0000-MAINLINE                                  *02830000
028400*                                                                *02840000
028500*     1. RECEIVE PARMS.                                          *02850000
028600******************************************************************02860000
028700                                                                  
028800 1000-PROCESS-INPUT.                                              
028900                                                                  
030100     MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO.             
REARCH     MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-TEMP.      
REARCH     MOVE PARM-E-CHANGED            TO PARM-E-CHANGED-TEMP.       
REARCH     MOVE PARM-E-AMT-NOTICE         TO PARM-E-AMT-NOTICE-TEMP.    
REARCH     MOVE PARM-F-CHANGED            TO PARM-F-CHANGED-TEMP.       
REARCH     MOVE PARM-F-AMT-NOTICE         TO PARM-F-AMT-NOTICE-TEMP.    
REARCH     MOVE PARM-G-CHANGED            TO PARM-G-CHANGED-TEMP.       
REARCH     MOVE PARM-G-AMT-NOTICE         TO PARM-G-AMT-NOTICE-TEMP.    
046700 1000-EXIT.                                                       
046800     EXIT.                                                        
046900                                                                  
047000******************************************************************04700000
047100* 2000-PROCESS-OUTPUT.                                           *04710000
047200*     CALLS 2100-DESCRIBE-RESULT                                 *04720000
047300*           5000-UPDATE                                          *04730000
047400*           8100-SEND-RESULT                                     *04740000
047500*                                                                *04750000
047600*      CALLED FROM 0000-MAINLINE                                 *04760000
047700*                                                                *04770000
047800*     1. DESCRIBE RESULT SET                                     *04780000
047900*     2. UPDATE DB2 DATA                                         *04790000
048000*     3. SEND RESULT SET                                         *04800000
048100******************************************************************04810000
048200                                                                  
048300 2000-PROCESS-OUTPUT.                                             
048400                                                                  
048600     PERFORM 5000-UPDATE                          THRU 5000-EXIT. 
           IF (WS-CODE-NOTICE-TYPE = WS-E) OR                           
              (WS-CODE-NOTICE-TYPE = WS-F) OR                           
              (WS-CODE-NOTICE-TYPE = WS-G)                              
              MOVE  PARM-USER-ID                      TO WS-USER-ID     
048700        PERFORM 5600-WQ-PARM                    THRU 5600-EXIT    
           END-IF.                                                      
REARCH     PERFORM 2000A-MOVE-RESULT                  THRU 2000A-EXIT.  
048800                                                                  
048900 2000-EXIT.                                                       
049000     EXIT.                                                        
049100                                                                  
REARCH*                                                                         
REARCH*****************************************************************         
REARCH*                                                               *         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*                                                               *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE           TO S-RETURN-CODE.             
REARCH     MOVE  RS-ERROR-COLUMN          TO S-ERROR-COLUMN.            
REARCH     MOVE  RS-RESP-AREA-ID          TO S-RESP-AREA-ID.            
REARCH     MOVE  RS-SUPR-ID               TO S-SUPR-ID.                 
REARCH     ADD   +1 TO CTR-ROWS.                                        
REARCH*                                                                         
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
054900******************************************************************05490000
055000* 5000-UPDATE                                                    *05500000
055100*     CALLS 5200-PROCESS-ROW                                     *05510000
055200*                                                                *05520000
055300*     CALLED FROM 2000-PROCESS-OUTPUT                            *05530000
055400*                                                                *05540000
055500******************************************************************05550000
055600                                                                  
055700 5000-UPDATE.                                                     
PCR404     PERFORM 7900-SPECIAL-DNP-EXISTS              THRU 7900-EXIT. 
PCR404     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PCR404        MOVE 'U'              TO WS-ACTION                        
PCR404     ELSE                                                         
PCR404        MOVE 'I'              TO WS-ACTION                        
PCR404     END-IF.                                                      
PCR404                                                                  
PCR404     IF E-DELETED OR F-DELETED OR G-DELETED                       
PCR404        MOVE 'PANEL132D'      TO WS-APPL-PROG                     
PCR404     ELSE                                                         
PCR404        IF WS-ACTION = 'U'                                        
PCR404           MOVE 'PANEL132M'   TO WS-APPL-PROG                     
PCR404        ELSE                                                      
PCR404           MOVE 'PANEL132S'   TO WS-APPL-PROG                     
PCR404        END-IF                                                    
PCR404     END-IF.                                                      
                                                                        
056400     PERFORM 5100-JRNL-TRAN-HEAD                  THRU 5100-EXIT. 
056600                                                                  
TP5309     IF E-CHANGED OR E-DELETED                                    
TP5309         IF E-DELETED                                             
TP5309            MOVE 'Y' TO WS-DELETED                                
TP5309         ELSE                                                     
TP5309            MOVE 'N' TO WS-DELETED                                
TP5309         END-IF                                                   
056800         MOVE WS-E                 TO WS-CODE-NOTICE-TYPE         
056900         PERFORM 7200-SELECT-CL                   THRU 7200-EXIT  
057000         COMPUTE WS-AMT-NOTICE = PARM-E-AMT-NOTICE-NUM / 100      
057100         MOVE PARM-E-DATE-MAILED   TO WS-DATE-MAIL                
057200         MOVE PARM-E-DATE-DUE      TO WS-DATE-DUE                 
I57300         MOVE SPACE                TO WS-DATE-CRED                
057400         MOVE PARM-E-TYPE          TO CL-CODE-SPECIAL-TYPE        
057500         MOVE 'EXCEP/1ST'          TO WS-ROW-NAME                 
0579I0         PERFORM 5200-PROCESS-ROW                 THRU 5200-EXIT  
           END-IF.                                                      
I57940                                                                  
057950     IF F-CHANGED OR F-DELETED                                    
TP5309         IF F-DELETED                                             
TP5309            MOVE 'Y' TO WS-DELETED                                
TP5309         ELSE                                                     
TP5309            MOVE 'N' TO WS-DELETED                                
TP5309         END-IF                                                   
057960         MOVE WS-F                 TO WS-CODE-NOTICE-TYPE         
057970         PERFORM 7200-SELECT-CL                   THRU 7200-EXIT  
057980         COMPUTE WS-AMT-NOTICE = PARM-F-AMT-NOTICE-NUM / 100      
057990         MOVE PARM-F-DATE-MAILED   TO WS-DATE-MAIL                
058000         MOVE PARM-F-DATE-DUE      TO WS-DATE-DUE                 
C23235         MOVE PARM-F-DATE-ACTION   TO WS-DATE-CRED                
C23235*        MOVE SPACE                TO WS-DATE-CRED                05810000
058200         MOVE PARM-E-TYPE          TO CL-CODE-SPECIAL-TYPE        
058300         MOVE 'EXCEP/2ND'          TO WS-ROW-NAME                 
059200         PERFORM 5200-PROCESS-ROW                 THRU 5200-EXIT  
           END-IF.                                                      
                                                                        
059300     IF G-CHANGED OR G-DELETED                                    
TP5309         IF G-DELETED                                             
TP5309            MOVE 'Y' TO WS-DELETED                                
TP5309         ELSE                                                     
TP5309            MOVE 'N' TO WS-DELETED                                
TP5309         END-IF                                                   
059400         MOVE WS-G                 TO WS-CODE-NOTICE-TYPE         
059500         PERFORM 7200-SELECT-CL                   THRU 7200-EXIT  
059600         COMPUTE WS-AMT-NOTICE = PARM-G-AMT-NOTICE-NUM / 100      
059700         MOVE PARM-G-DATE-MAILED   TO WS-DATE-MAIL                
059800         MOVE SPACE                TO WS-DATE-DUE                 
059900         MOVE PARM-G-DATE-ACTION   TO WS-DATE-CRED                
060000         MOVE PARM-E-TYPE          TO CL-CODE-SPECIAL-TYPE        
060100         MOVE 'EXCEP/DNP'          TO WS-ROW-NAME                 
060350         PERFORM 5200-PROCESS-ROW                 THRU 5200-EXIT  
060360     END-IF.                                                      
060370                                                                  
060380 5000-EXIT.                                                       
060390     EXIT.                                                        
HPCCDM*    EJECT                                                        06040000
      *                                                                 06050000
074100******************************************************************07410000
074200*   5100-JRNL-TRAN-HEAD.                                         *07420000
074300*   1.   MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.      *07430000
074400*        THE FIRST TIME THE TRANSACTION DETAILS ROW IS WRITTEN,  *07440000
074500*        THIS ROW WILL ALSO BE WRITTEN (SEE CPD00067).           *07450000
074600******************************************************************07460000
074700 5100-JRNL-TRAN-HEAD.                                             
074800                                                                  
074900     PERFORM 7000-SELECT-TIMESTAMP                THRU 7000-EXIT. 
075000     PERFORM 7100-SELECT-RESP-AREA                THRU 7100-EXIT. 
075100                                                                  
075200     MOVE 1                        TO WS-TRAN-APPL-NO             
075300                                      MI-TRAN-APPL-NO.            
075400     MOVE SPACES                   TO MI-TABLE-ID.                
075500                                                                  
075600     MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
075700     MOVE WS-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
075800     MOVE ZERO                     TO MH-CUSTOMER-NO.             
075900     MOVE ZERO                     TO MH-PREMISE-NO.              
076000     MOVE PARM-USER-ID             TO MH-USER-ID.                 
076100     MOVE WS-APPL-PROG             TO MH-APPL-PROGRAM-ID.         
076200     MOVE PARM-COMMENTS-LEN        TO MH-TRAN-COMMENT-LEN.        
076300     MOVE PARM-COMMENTS-TEXT       TO MH-TRAN-COMMENT-TEXT.       
076400                                                                  
076500 5100-EXIT.                                                       
076600     EXIT.                                                        
HPCCDM*    EJECT                                                        07670000
076800******************************************************************07680000
076900*   5200-PROCESS-ROW.                                            *07690000
077000*                                                                *07700000
077100*       UPDATE OR INSERT BASED ON THE CHANGED VALUES AND THE     *07710000
077200*       EXISTENCE/NON-EXISTNECE OF THE ROW.                      *07720000
077300******************************************************************07730000
077400 5200-PROCESS-ROW.                                                
077500                                                                  
077600     IF WS-AMT-NOTICE = CL-AMT-NOTICE                             
077700         SET AMT-NOTICE-UNCHANGED      TO TRUE                    
077800     ELSE                                                         
077900         SET AMT-NOTICE-CHANGED        TO TRUE                    
078000         MOVE CL-AMT-NOTICE            TO SV-AMT-NOTICE           
078100         MOVE WS-AMT-NOTICE            TO CL-AMT-NOTICE           
078200     END-IF.                                                      
078300                                                                  
078400     IF WS-DATE-MAIL = CL-DATE-NOTICE-MAIL                        
078500         SET DATE-MAIL-UNCHANGED       TO TRUE                    
078600     ELSE                                                         
078700         SET DATE-MAIL-CHANGED         TO TRUE                    
078800         MOVE CL-DATE-NOTICE-MAIL      TO SV-DATE-NOTICE-MAIL     
078900         MOVE WS-DATE-MAIL             TO CL-DATE-NOTICE-MAIL     
079000         IF CL-DATE-NOTICE-MAIL = SPACE                           
079100             MOVE -1                   TO WS-NULL-MAIL            
079200         ELSE                                                     
079300             MOVE 0                    TO WS-NULL-MAIL            
079400         END-IF                                                   
079500     END-IF.                                                      
079600                                                                  
079700     IF WS-DATE-DUE = CL-DATE-NOTICE-DUE                          
079800         SET DATE-DUE-UNCHANGED        TO TRUE                    
079900     ELSE                                                         
080000         SET DATE-DUE-CHANGED          TO TRUE                    
080100         MOVE CL-DATE-NOTICE-DUE       TO SV-DATE-NOTICE-DUE      
080200         MOVE WS-DATE-DUE              TO CL-DATE-NOTICE-DUE      
080300         IF CL-DATE-NOTICE-DUE = SPACE                            
080400             MOVE -1                   TO WS-NULL-DUE             
080500         ELSE                                                     
080600             MOVE 0                    TO WS-NULL-DUE             
080700         END-IF                                                   
080800     END-IF.                                                      
080900                                                                  
081000     IF WS-DATE-CRED = CL-DATE-CREDIT-ACTION                      
081100         SET DATE-CRED-UNCHANGED       TO TRUE                    
081200     ELSE                                                         
081300         SET DATE-CRED-CHANGED         TO TRUE                    
081400         MOVE CL-DATE-CREDIT-ACTION    TO SV-DATE-CREDIT-ACTION   
081500         MOVE WS-DATE-CRED             TO CL-DATE-CREDIT-ACTION   
081600         IF CL-DATE-CREDIT-ACTION = SPACE                         
081700             MOVE -1                   TO WS-NULL-CRED            
081800         ELSE                                                     
081900             MOVE 0                    TO WS-NULL-CRED            
082000         END-IF                                                   
082100     END-IF.                                                      
082200                                                                  
TP5309     IF WS-DELETED = 'Y'                                          
TP5309        PERFORM  8000-DELETE-CL        THRU 8000-EXIT             
082300     ELSE IF ROW-EXISTS                                           
082400         PERFORM 7300-UPDATE-CL        THRU 7300-EXIT             
082500     ELSE                                                         
082600         PERFORM 7400-INSERT-CL        THRU 7400-EXIT             
082700     END-IF
           END-IF.                                                      
082800                                                                  
082900     IF AMT-NOTICE-CHANGED                                        
083000         PERFORM 5510-JRNL-AMT-NOTICE             THRU 5510-EXIT  
083100     END-IF.                                                      
083200     IF DATE-MAIL-CHANGED                                         
083300         PERFORM 5520-JRNL-DATE-NOTICE-MAIL       THRU 5520-EXIT  
083400     END-IF.                                                      
083500     IF DATE-DUE-CHANGED                                          
083600         PERFORM 5530-JRNL-DATE-NOTICE-DUE        THRU 5530-EXIT  
083700     END-IF.                                                      
083800     IF DATE-CRED-CHANGED                                         
083900         PERFORM 5540-JRNL-DATE-CREDIT-ACTION     THRU 5540-EXIT  
084000     END-IF.                                                      
084100                                                                  
084200 5200-EXIT.                                                       
084300     EXIT.                                                        
HPCCDM*    EJECT                                                        08440000
084500****************************************************************  08450000
084600* 5510-JRNL-AMT-NOTICE.                                        *  08460000
084700*                                                              *  08470000
084800****************************************************************  08480000
084900 5510-JRNL-AMT-NOTICE.                                            
085000                                                                  
085100     MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
085200     MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
085300     MOVE SPACE                    TO MI-COLUMN-DESC.             
085400     STRING WS-ROW-NAME DELIMITED SPACE                           
085500            ' ' DELIMITED SIZE                                    
085600            'AMT' DELIMITED SIZE                                  
085700       INTO MI-COLUMN-DESC.                                       
           IF WS-DELETED = 'Y'                                          
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
085800     ELSE IF WS-AMT-NOTICE >= ZERO                                
085900         MOVE 16                   TO MI-CHG-COLUMN-VALUE-LEN     
086000         MOVE WS-AMT-NOTICE        TO WS-AMT-DISPLAY              
086100         MOVE WS-AMT-DISPLAY       TO MI-CHG-COLUMN-VALUE-TEXT    
086200     END-IF
           END-IF.                                                      
086300     IF SV-AMT-NOTICE >= ZERO                                     
086400         MOVE 16                   TO MI-PRV-COLUMN-VALUE-LEN     
086500         MOVE SV-AMT-NOTICE        TO WS-AMT-DISPLAY              
086600         MOVE WS-AMT-DISPLAY       TO MI-PRV-COLUMN-VALUE-TEXT    
086700     ELSE                                                         
086800         MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
086900         MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
087000     END-IF.                                                      
087100     PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
087200     ADD  1                        TO WS-TRAN-APPL-NO.            
087300                                                                  
087400 5510-EXIT.                                                       
087500     EXIT.                                                        
HPCCDM*    EJECT                                                        08760000
087700****************************************************************  08770000
087800* 5520-JRNL-DATE-NOTICE-MAIL.                                  *  08780000
087900*                                                              *  08790000
088000****************************************************************  08800000
088100 5520-JRNL-DATE-NOTICE-MAIL.                                      
088200                                                                  
088300     MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
088400     MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
088500     MOVE SPACE                    TO MI-COLUMN-DESC.             
088600     STRING WS-ROW-NAME DELIMITED SPACE                           
088700            ' ' DELIMITED SIZE                                    
088800            'MAIL' DELIMITED SIZE                                 
088900       INTO MI-COLUMN-DESC.                                       
           IF WS-DELETED = 'Y'                                          
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
089000     ELSE IF WS-DATE-MAIL > SPACE                                 
089100         MOVE 10                   TO MI-CHG-COLUMN-VALUE-LEN     
089200         MOVE WS-DATE-MAIL         TO MI-CHG-COLUMN-VALUE-TEXT    
089300     ELSE                                                         
089400         MOVE 6                    TO MI-CHG-COLUMN-VALUE-LEN     
089500         MOVE '*NULL*'             TO MI-CHG-COLUMN-VALUE-TEXT    
089600     END-IF
           END-IF.                                                      
089700     IF SV-DATE-NOTICE-MAIL > SPACE                               
089800         MOVE 10                   TO MI-PRV-COLUMN-VALUE-LEN     
089900         MOVE SV-DATE-NOTICE-MAIL  TO MI-PRV-COLUMN-VALUE-TEXT    
090000     ELSE                                                         
090100         MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
090200         MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
090300     END-IF.                                                      
090400     PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
090500     ADD  1                        TO WS-TRAN-APPL-NO.            
090600                                                                  
090700 5520-EXIT.                                                       
090800     EXIT.                                                        
HPCCDM*    EJECT                                                        09090000
091000****************************************************************  09100000
091100* 5530-JRNL-DATE-NOTICE-DUE.                                   *  09110000
091200*                                                              *  09120000
091300****************************************************************  09130000
091400 5530-JRNL-DATE-NOTICE-DUE.                                       
091500                                                                  
091600     MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
091700     MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
091800     MOVE SPACE                    TO MI-COLUMN-DESC.             
091900     STRING WS-ROW-NAME DELIMITED SPACE                           
092000            ' ' DELIMITED SIZE                                    
092100            'DUE' DELIMITED SIZE                                  
092200       INTO MI-COLUMN-DESC.                                       
           IF WS-DELETED = 'Y'                                          
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
092300     ELSE IF WS-DATE-DUE > SPACE                                  
092400         MOVE 10                   TO MI-CHG-COLUMN-VALUE-LEN     
092500         MOVE WS-DATE-DUE          TO MI-CHG-COLUMN-VALUE-TEXT    
092600     ELSE                                                         
092700         MOVE 6                    TO MI-CHG-COLUMN-VALUE-LEN     
092800         MOVE '*NULL*'             TO MI-CHG-COLUMN-VALUE-TEXT    
092900     END-IF
           END-IF.                                                      
093000     IF SV-DATE-NOTICE-DUE > SPACE                                
093100         MOVE 10                   TO MI-PRV-COLUMN-VALUE-LEN     
093200         MOVE SV-DATE-NOTICE-DUE   TO MI-PRV-COLUMN-VALUE-TEXT    
093300     ELSE                                                         
093400         MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
093500         MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
093600     END-IF.                                                      
093700     PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
093800     ADD  1                        TO WS-TRAN-APPL-NO.            
093900                                                                  
094000 5530-EXIT.                                                       
094100     EXIT.                                                        
HPCCDM*    EJECT                                                        09420000
094300****************************************************************  09430000
094400*                                                              *  09440000
094500* 5540-JRNL-DATE-CREDIT-ACTION.                                *  09450000
094600*                                                              *  09460000
094700****************************************************************  09470000
094800 5540-JRNL-DATE-CREDIT-ACTION.                                    
094900                                                                  
095000     MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
095100     MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
095200     MOVE SPACE                    TO MI-COLUMN-DESC.             
095300     STRING WS-ROW-NAME DELIMITED SPACE                           
095400            ' ' DELIMITED SIZE                                    
095500            'LPC' DELIMITED SIZE                                  
095600       INTO MI-COLUMN-DESC.                                       
           IF WS-DELETED = 'Y'                                          
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
095700     ELSE IF WS-DATE-CRED > SPACE                                 
095800         MOVE 10                   TO MI-CHG-COLUMN-VALUE-LEN     
095900         MOVE WS-DATE-CRED         TO MI-CHG-COLUMN-VALUE-TEXT    
096000     ELSE                                                         
096100         MOVE 6                    TO MI-CHG-COLUMN-VALUE-LEN     
096200         MOVE '*NULL*'             TO MI-CHG-COLUMN-VALUE-TEXT    
096300     END-IF
           END-IF.                                                      
096400     IF SV-DATE-CREDIT-ACTION > SPACE                             
096500         MOVE 10                   TO MI-PRV-COLUMN-VALUE-LEN     
096600         MOVE SV-DATE-CREDIT-ACTION                               
096700                                   TO MI-PRV-COLUMN-VALUE-TEXT    
096800     ELSE                                                         
096900         MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
097000         MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
097100     END-IF.                                                      
097200     PERFORM 6530-LOAD-MNT-TRANS-HIST             THRU 6530-EXIT. 
097300     ADD  1                        TO WS-TRAN-APPL-NO.            
097400                                                                  
097500 5540-EXIT.                                                       
097600     EXIT.                                                        
HPCCDM*    EJECT                                                        09770000
                                                                        
      ******************************************************************09772000
      *  SELECTING WQ PARAMETERS                                       *09773000
097800******************************************************************09780000
       5600-WQ-PARM.                                                    
      *                                                                 09780200
           MOVE '5600'               TO ACTIVE-PARAGRAPH.               
      *                                                                 09780400
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE                                   
               WHERE USER_ID = :WS-USER-ID                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09781100
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 09781300
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T16078        MOVE '5600'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
CBSI          MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE WS-USER-ID            TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              SELECT USER_ID                                            
                INTO :WS-SUPR-ID                                        
                FROM CSS_RESP_AREA                                      
               WHERE RESP_AREA_ID = :WS-RESP-AREA-ID                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09784500
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 09784700
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T16078        MOVE '5600'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
              MOVE 'CSS_RESP_AREA'       TO TABLE-1                     
CBSI          MOVE 'RESP_AREA_ID'        TO TABLE-ELEMENT-1             
              MOVE WS-RESP-AREA-ID       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 09786000
           MOVE WS-RESP-AREA-ID   TO  RS-RESP-AREA-ID.                  
           MOVE WS-SUPR-ID        TO  RS-SUPR-ID.                       
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09786600
REARCH*                                                                         
098000******************************************************************09787000
097900*  JOURNALING COPYBOOK.                                          *09790000
098000******************************************************************09800000
098100                                                                  
098200     EXEC SQL                                                     09820000
098300        INCLUDE CPD00067                                          09830000
098400     END-EXEC.                                                    09840000
HPCCDM*    EJECT                                                        09850000
098600******************************************************************09860000
098700*   7000-SELECT-TIMESTAMP.                                       *09870000
098800*                                                                *09880000
098900*       GET CURRENT DATE AND TIMESTAMP.                          *09890000
099000******************************************************************09900000
099100 7000-SELECT-TIMESTAMP.                                           
099200                                                                  
099300     EXEC SQL                                                     
099400        SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'),                
099500               CAST(SYSDATETIMEOFFSET() AS DATE)                          
099600          INTO :MH-TRANS-HIST-SEQ-NO,                             
099700               :MH-DATE-TRANS                                     
099800          FROM CSS_MODEL_SQL                                      
099900     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     09930000
MFA-TR*       SELECT CURRENT TIMESTAMP,                                 09940000
MFA-TR*              CURRENT DATE                                       09950000
MFA-TR*         INTO :MH-TRANS-HIST-SEQ-NO,                             09960000
MFA-TR*              :MH-DATE-TRANS                                     09970000
MFA-TR*         FROM CSS_MODEL_SQL                                      09980000
MFA-TR*    END-EXEC.                                                    09990000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

100000                                                                  
100100     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
100200                                                                  
100300     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
100400        NEXT SENTENCE                                             
100500     ELSE                                                         
100600        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
100700        MOVE '7000'                TO ACTIVE-PARAGRAPH            
100800        MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
100900        MOVE 'CSS_MODEL_SQL'       TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
101000        PERFORM 9000-SEND-ERROR-RESULT            THRU 9000-EXIT  
101100        PERFORM 9900-SQL-ERROR-ROUTINE            THRU 9900-EXIT  
101200     END-IF.                                                      
101300                                                                  
101400 7000-EXIT.                                                       
101500     EXIT.                                                        
HPCCDM*    EJECT                                                        10160000
101700******************************************************************10170000
101800*   7100-SELECT-RESP-AREA.                                       *10180000
101900*                                                                *10190000
102000*       GET RESPONSIBLE AREA FOR THE USER.                       *10200000
102100******************************************************************10210000
102200                                                                  
102300 7100-SELECT-RESP-AREA.                                           
102400                                                                  
102500     EXEC SQL                                                     
102600        SELECT RESP_AREA_ID                                       
102700          INTO :MH-RESP-AREA-ID                                   
102800          FROM CSS_USER_PROFILE                                   
102900         WHERE USER_ID = :PARM-USER-ID                            
103000     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

103100                                                                  
103200     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
103300                                                                  
103400     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
103500        NEXT SENTENCE                                             
103600     ELSE                                                         
103700        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
103800        MOVE '7100'                TO ACTIVE-PARAGRAPH            
103900        MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
104000        MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
CBSI          MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
104200        MOVE PARM-USER-ID          TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
104300        PERFORM 9000-SEND-ERROR-RESULT            THRU 9000-EXIT  
104400        PERFORM 9900-SQL-ERROR-ROUTINE            THRU 9900-EXIT  
104500     END-IF.                                                      
104600                                                                  
104700 7100-EXIT.                                                       
104800     EXIT.                                                        
HPCCDM*    EJECT                                                        10490000
105000***************************************************************** 10500000
105100* 7200-SELECT-CL                                                * 10510000
105200*     CALLS 9000-SEND-ERROR-RESULT                              * 10520000
105300*           9900-SQL-ERROR-ROUTINE                              * 10530000
105400*                                                               * 10540000
105500*     CALLED FROM 5000-UPDATE                                   * 10550000
105600*                                                               * 10560000
105700*     SELECTS CSS_CRED_COLL                                     * 10570000
105800***************************************************************** 10580000
105900 7200-SELECT-CL.                                                  
106000                                                                  
106100     EXEC SQL                                                     
106200        SELECT AMT_NOTICE,                                        
106300               DATE_NOTICE_MAIL,                                  
106400               DATE_NOTICE_DUE,                                   
106500               DATE_CREDIT_ACTION,                                
106600               CODE_SPECIAL_TYPE                                  
106700          INTO :CL-AMT-NOTICE,                                    
106800               :CL-DATE-NOTICE-MAIL :WS-NULL-MAIL,                 
106900               :CL-DATE-NOTICE-DUE :WS-NULL-DUE,                   
107000               :CL-DATE-CREDIT-ACTION :WS-NULL-CRED,               
107100               :CL-CODE-SPECIAL-TYPE                              
107200          FROM CSS_CRED_COLL                                      
107300         WHERE ACCOUNT_NO          =:WS-ACCOUNT-NO                
107400           AND ITEM_ID             =:PARM-ITEM-ID                 
107500           AND CODE_NOTICE_TYPE    =:WS-CODE-NOTICE-TYPE          
107600     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

107700                                                                  
107800     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
107900                                                                  
108000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
108100         SET ROW-EXISTS TO TRUE                                   
108200         IF WS-NULL-MAIL = -1                                     
108300             MOVE SPACE TO CL-DATE-NOTICE-MAIL                    
108400         END-IF                                                   
108500         IF WS-NULL-DUE = -1                                      
108600             MOVE SPACE TO CL-DATE-NOTICE-DUE                     
108700         END-IF                                                   
108800         IF WS-NULL-CRED = -1                                     
108900             MOVE SPACE TO CL-DATE-CREDIT-ACTION                  
109000         END-IF                                                   
109100     ELSE                                                         
109200         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
109300             SET ROW-NOT-EXIST TO TRUE                            
109400             MOVE -1 TO CL-AMT-NOTICE                             
109500             MOVE SPACE TO CL-DATE-NOTICE-MAIL                    
109600                           CL-DATE-NOTICE-DUE                     
109700                           CL-DATE-CREDIT-ACTION                  
109900             MOVE -1 TO WS-NULL-MAIL                              
110000                        WS-NULL-DUE                               
110100                        WS-NULL-CRED                              
110200         ELSE                                                     
110300             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
110400             MOVE '7200'                TO ACTIVE-PARAGRAPH       
110500             MOVE 'SELECT'              TO ABEND-FUNCTION         
T16078             MOVE SPACES                TO ABEND-SQL-PREDICATES   
T16078                                           ABEND-TABLES           
CBSI               MOVE 'CSS_CRED_COLL'       TO TABLE-1                
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
CBSI               MOVE 'ITEM_ID'             TO TABLE-ELEMENT-2        
CBSI               MOVE 'CODE_NOTICE_TYPE'    TO TABLE-ELEMENT-3        
T16078             MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
T16078             MOVE PARM-ITEM-ID          TO HOSTVAR-ELEMENT-2      
T16078             MOVE WS-CODE-NOTICE-TYPE   TO HOSTVAR-ELEMENT-3      
110700             PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
110800             PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
110900         END-IF                                                   
111000     END-IF.                                                      
111100                                                                  
111200 7200-EXIT.                                                       
111300     EXIT.                                                        
HPCCDM*    EJECT                                                        11140000
111500***************************************************************** 11150000
111600* 7300-UPDATE-CL                                                * 11160000
111700*     CALLS 9000-SEND-ERROR-RESULT                              * 11170000
111800*           9900-SQL-ERROR-ROUTINE                              * 11180000
111900*                                                               * 11190000
112000*     CALLED FROM 5000-UPDATE                                   * 11200000
112100*                                                               * 11210000
112200*     UPDATES CSS_CRED_COLL                                     * 11220000
112300***************************************************************** 11230000
112400 7300-UPDATE-CL.                                                  
112500                                                                  
112600     EXEC SQL                                                     
112700        UPDATE CSS_CRED_COLL                                      
112800           SET AMT_NOTICE          =:CL-AMT-NOTICE,               
112900               DATE_NOTICE_MAIL                                   
113000                            =IIF(TRY_CONVERT(DATE, 
                                                  :CL-DATE-NOTICE-MAIL 
                                                         :WS-NULL-MAIL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-MAIL 
                                                          :WS-NULL-MAIL
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-MAIL :WS-NULL-MAIL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-MAIL 
                                                          :WS-NULL-MAIL
              ), CONVERT(DATE, :CL-DATE-NOTICE-MAIL :WS-NULL-MAIL) ),   
113100               DATE_NOTICE_DUE                                    
113200                            =IIF(TRY_CONVERT(DATE, 
                                                   :CL-DATE-NOTICE-DUE 
                                                         :WS-NULL-DUE
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-DUE 
                                                           :WS-NULL-DUE
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-DUE :WS-NULL-DUE
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-DUE :WS-NULL-DUE
              ), CONVERT(DATE, :CL-DATE-NOTICE-DUE :WS-NULL-DUE) ),     
113300               DATE_CREDIT_ACTION                                 
113400                            =IIF(TRY_CONVERT(DATE, 
                                                :CL-DATE-CREDIT-ACTION 
                                                         :WS-NULL-CRED
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION 
                                                          :WS-NULL-CRED
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION :WS-NULL-CRED
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION 
                                                          :WS-NULL-CRED
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION :WS-NULL-CRED) ), 
113500               CODE_SPECIAL_TYPE   =:CL-CODE-SPECIAL-TYPE,        
113600               LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP()            
113700         WHERE ACCOUNT_NO          =:WS-ACCOUNT-NO                
113800           AND ITEM_ID             =:PARM-ITEM-ID                 
113900           AND CODE_NOTICE_TYPE    =:WS-CODE-NOTICE-TYPE          
114000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11260000
MFA-TR*       UPDATE CSS_CRED_COLL                                      11270000
MFA-TR*          SET AMT_NOTICE          =:CL-AMT-NOTICE,               11280000
MFA-TR*              DATE_NOTICE_MAIL                                   11290000
MFA-TR*                           =:CL-DATE-NOTICE-MAIL:WS-NULL-MAIL,   11300000
MFA-TR*              DATE_NOTICE_DUE                                    11310000
MFA-TR*                           =:CL-DATE-NOTICE-DUE:WS-NULL-DUE,     11320000
MFA-TR*              DATE_CREDIT_ACTION                                 11330000
MFA-TR*                           =:CL-DATE-CREDIT-ACTION:WS-NULL-CRED, 11340000
MFA-TR*              CODE_SPECIAL_TYPE   =:CL-CODE-SPECIAL-TYPE,        11350000
MFA-TR*              LAST_UPDATE_TS      = CURRENT TIMESTAMP            11360000
MFA-TR*        WHERE ACCOUNT_NO          =:WS-ACCOUNT-NO                11370000
MFA-TR*          AND ITEM_ID             =:PARM-ITEM-ID                 11380000
MFA-TR*          AND CODE_NOTICE_TYPE    =:WS-CODE-NOTICE-TYPE          11390000
MFA-TR*    END-EXEC.                                                    11400000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

114100                                                                  
114200     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
114300                                                                  
114400     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
114500         NEXT SENTENCE                                            
114600     ELSE                                                         
114700         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
114800         MOVE '7300'                     TO ACTIVE-PARAGRAPH      
114900         MOVE 'UPDATE'                   TO ABEND-FUNCTION        
CBSI           MOVE SPACES                     TO ABEND-SQL-PREDICATES  
CBSI                                              ABEND-TABLES          
115000         MOVE 'CSS_CRED_COLL'            TO TABLE-1               
CBSI           MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
CBSI           MOVE 'ITEM_ID'                  TO TABLE-ELEMENT-2       
CBSI           MOVE 'CODE_NOTICE_TYPE'         TO TABLE-ELEMENT-3       
115400         MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
115500         MOVE PARM-ITEM-ID               TO HOSTVAR-ELEMENT-2     
115600         MOVE WS-CODE-NOTICE-TYPE        TO HOSTVAR-ELEMENT-3     
115700                                                                  
115800         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
115900         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
116000     END-IF.                                                      
116100                                                                  
116200 7300-EXIT.                                                       
116300     EXIT.                                                        
HPCCDM*    EJECT                                                        11640000
116500***************************************************************** 11650000
116600* 7400-INSERT-CL                                                * 11660000
116700*     CALLS 9000-SEND-ERROR-RESULT                              * 11670000
116800*           9900-SQL-ERROR-ROUTINE                              * 11680000
116900*                                                               * 11690000
117000*     CALLED FROM 5000-UPDATE                                   * 11700000
117100*                                                               * 11710000
117200*     INSERTS CSS_CRED_COLL                                     * 11720002
117300***************************************************************** 11730000
117400                                                                  
117500 7400-INSERT-CL.                                                  
117600                                                                  
117700     EXEC SQL                                                     
117800         INSERT INTO CSS_CRED_COLL                                
117900                (ACCOUNT_NO,                                      
118000                 CODE_SPECIAL_TYPE,                               
118100                 DATE_NOTICE_MAIL,                                
118200                 CODE_FRCST_CR_GRP,                               
118300                 ITEM_ID,                                         
118400                 CODE_MESSAGE_TYPE,                               
118500                 DATE_CREDIT_ACTION,                              
118600                 DATE_NOTICE_DUE,                                 
118700                 AMT_NOTICE,                                      
118800                 CODE_NOTICE_TYPE,                                
118900                 LAST_UPDATE_TS)                                  
119000         VALUES                                                   
119100                (:WS-ACCOUNT-NO,                                  
119200                 :CL-CODE-SPECIAL-TYPE,                           
119300                 IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-MAIL 
                                             :WS-NULL-MAIL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-MAIL 
                                                          :WS-NULL-MAIL
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-MAIL :WS-NULL-MAIL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-MAIL 
                                                          :WS-NULL-MAIL
              ), CONVERT(DATE, :CL-DATE-NOTICE-MAIL :WS-NULL-MAIL) ),          
119400                 :CL-CODE-FRCST-CR-GRP,                           
119500                 :PARM-ITEM-ID,                                   
119600                 :CL-CODE-MESSAGE-TYPE,                           
119700                 IIF(TRY_CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                             :WS-NULL-CRED
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION 
                                                          :WS-NULL-CRED
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION :WS-NULL-CRED
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION 
                                                          :WS-NULL-CRED
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION :WS-NULL-CRED) ),        
119800                 IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-DUE 
                                             :WS-NULL-DUE
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-DUE 
                                                           :WS-NULL-DUE
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-DUE :WS-NULL-DUE
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-DUE :WS-NULL-DUE
              ), CONVERT(DATE, :CL-DATE-NOTICE-DUE :WS-NULL-DUE) ),            
119900                 :CL-AMT-NOTICE,                                  
120000                 :WS-CODE-NOTICE-TYPE,                            
120100                 CIS.CURRENT$TIMESTAMP())                               
120200     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11770000
MFA-TR*        INSERT INTO CSS_CRED_COLL                                11780000
MFA-TR*               (ACCOUNT_NO,                                      11790000
MFA-TR*                CODE_SPECIAL_TYPE,                               11800000
MFA-TR*                DATE_NOTICE_MAIL,                                11810000
MFA-TR*                CODE_FRCST_CR_GRP,                               11820000
MFA-TR*                ITEM_ID,                                         11830000
MFA-TR*                CODE_MESSAGE_TYPE,                               11840000
MFA-TR*                DATE_CREDIT_ACTION,                              11850000
MFA-TR*                DATE_NOTICE_DUE,                                 11860000
MFA-TR*                AMT_NOTICE,                                      11870000
MFA-TR*                CODE_NOTICE_TYPE,                                11880000
MFA-TR*                LAST_UPDATE_TS)                                  11890000
MFA-TR*        VALUES                                                   11900000
MFA-TR*               (:WS-ACCOUNT-NO,                                  11910000
MFA-TR*                :CL-CODE-SPECIAL-TYPE,                           11920000
MFA-TR*                :CL-DATE-NOTICE-MAIL:WS-NULL-MAIL,               11930000
MFA-TR*                :CL-CODE-FRCST-CR-GRP,                           11940000
MFA-TR*                :PARM-ITEM-ID,                                   11950000
MFA-TR*                :CL-CODE-MESSAGE-TYPE,                           11960000
MFA-TR*                :CL-DATE-CREDIT-ACTION:WS-NULL-CRED,             11970000
MFA-TR*                :CL-DATE-NOTICE-DUE:WS-NULL-DUE,                 11980000
MFA-TR*                :CL-AMT-NOTICE,                                  11990000
MFA-TR*                :WS-CODE-NOTICE-TYPE,                            12000000
MFA-TR*                CURRENT TIMESTAMP)                               12010000
MFA-TR*    END-EXEC.                                                    12020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

120300                                                                  
120400     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
120500                                                                  
120600     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
120700         NEXT SENTENCE                                            
120800     ELSE                                                         
120900         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
121000         MOVE '7400'                     TO ACTIVE-PARAGRAPH      
121100         MOVE 'INSERT'                   TO ABEND-FUNCTION        
CBSI           MOVE SPACES                     TO ABEND-SQL-PREDICATES  
CBSI                                              ABEND-TABLES          
121200         MOVE 'CSS_CRED_COLL'            TO TABLE-1               
CBSI           MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
CBSI           MOVE 'CODE_SPECIAL_TYPE'        TO TABLE-ELEMENT-2       
CBSI           MOVE 'DATE_NOTICE_MAIL'         TO TABLE-ELEMENT-3       
121400         MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
T16078         MOVE CL-CODE-SPECIAL-TYPE       TO HOSTVAR-ELEMENT-2     
T16078         MOVE CL-DATE-NOTICE-MAIL        TO HOSTVAR-ELEMENT-3     
121500                                                                  
121600         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
121700         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
121800     END-IF.                                                      
121900                                                                  
122000 7400-EXIT.                                                       
122100     EXIT.                                                        
HPCCDM*    EJECT                                                        12220000
122800                                                                  
101700******************************************************************13281000
101800*  7900-SPECIAL-DNP-EXISTS                                       *13281100
101900*                                                                *13281200
102000*       CHECK TO SEE IF YOU ARE DOING AN UPDATE OR AN INSERT     *13281300
102100******************************************************************13281400
102200                                                                  
102300 7900-SPECIAL-DNP-EXISTS.                                         
102400                                                                  
102500     EXEC SQL                                                     
102600        SELECT DISTINCT(CODE_SPECIAL_TYPE)                        
102700          INTO :WS-EXISTS                                         
102800          FROM CSS_CRED_COLL                                      
102900         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
102900           AND CODE_SPECIAL_TYPE = 'S'                            
103000     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

103100                                                                  
103200     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
103300                                                                  
103400     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
103500        NEXT SENTENCE                                             
103600     ELSE                                                         
103700        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
103800        MOVE '7900'                TO ACTIVE-PARAGRAPH            
103900        MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE SPACES                TO ABEND-SQL-PREDICATES        
CBSI                                        ABEND-TABLES                
104000        MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
104100        MOVE 'CODE_SPECIAL_TYPE'   TO TABLE-ELEMENT-2             
104200        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
104200        MOVE 'S'                   TO HOSTVAR-ELEMENT-2           
104300        PERFORM 9000-SEND-ERROR-RESULT            THRU 9000-EXIT  
104400        PERFORM 9900-SQL-ERROR-ROUTINE            THRU 9900-EXIT  
104500     END-IF.                                                      
104600                                                                  
104700 7900-EXIT.                                                       
104800     EXIT.                                                        
HPCCDM*    EJECT                                                        13284500
132810                                                                  
116500***************************************************************** 13284700
116600* 8000-DELETE-CL                                                * 13284800
116700*     CALLS 9000-SEND-ERROR-RESULT                              * 13284900
116800*           9900-SQL-ERROR-ROUTINE                              * 13285000
116900*                                                               * 13285100
117000*     CALLED FROM 5200-UPDATE                                   * 13285200
117100*                                                               * 13285300
117200*     DELETES CSS_CRED_COLL                                     * 13285402
117300***************************************************************** 13285500
117400                                                                  
117500 8000-DELETE-CL.                                                  
117600                                                                  
117700     EXEC SQL                                                     
117800         DELETE FROM CSS_CRED_COLL                                
120100          WHERE ACCOUNT_NO          =:WS-ACCOUNT-NO               
120100            AND ITEM_ID             =:PARM-ITEM-ID                
120100            AND CODE_NOTICE_TYPE    =:WS-CODE-NOTICE-TYPE         
120200     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

120300                                                                  
120400     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
120500                                                                  
120600     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
120700         NEXT SENTENCE                                            
120800     ELSE                                                         
120900         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
121000         MOVE '8000'                     TO ACTIVE-PARAGRAPH      
121100         MOVE 'DELETE'                   TO ABEND-FUNCTION        
CBSI           MOVE SPACES                     TO ABEND-SQL-PREDICATES  
CBSI                                              ABEND-TABLES          
121200         MOVE 'CSS_CRED_COLL'            TO TABLE-1               
CBSI           MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
CBSI           MOVE 'ITEM_ID'                  TO TABLE-ELEMENT-2       
CBSI           MOVE 'CODE_NOTICE_TYPE'         TO TABLE-ELEMENT-3       
121400         MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
T16078         MOVE PARM-ITEM-ID               TO HOSTVAR-ELEMENT-2     
T16078         MOVE WS-CODE-NOTICE-TYPE        TO HOSTVAR-ELEMENT-3     
121500                                                                  
121600         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
121700         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
121800     END-IF.                                                      
121900                                                                  
122000 8000-EXIT.                                                       
122100     EXIT.                                                        
REARCH*                                                                         
REARCH*                                                                         
132820******************************************************************13288400
132830* 9900- JOURNALING / ERROR HANDLING INCLUDE *                     13288500
132840******************************************************************13288600
132850     EXEC SQL                                                     13288700
REARCH        INCLUDE CPDSP300                                                  
132870     END-EXEC.                                                    13288900
132880                                                                  
132890******************************************************************13289100
132900*       END PROGRAM COPYLIB                                      *13290000
133000******************************************************************13300000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
REARCH*                                                                         
