       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02023.                                         
       DATE-WRITTEN.  04/19/95.                                         
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE IS USED TO RETRIEVE ALL ROWS IN CSS_CRED_COLL  *        
      *  FOR A PARTICULAR ACCOUNT_NO AND ITEM_ID.                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/19/95    SAG      PROCEDURE ORIGINALLY CODED.              *        
      *  05/10/96    ALI      ADDED CODES TO MOVE CODES DATA PRESENT   *        
      *                       TO CWS00056                              *        
      *  09/18/96    JEP      ADDED CODE TO RETRIEVE DAY-SPECIALDNP1,  *        
      *                       DAY-SPECIALDNP2, AND AMT-SPECIALDNPLIM   *        
      *                       FOR PANEL132, TPR 5309.                  *        
      *  09/19/96    MRB      PCR #361 - ADDED CODE TO SUPPORT THE     *        
      *                       REWRITE OF CPD00068 COPYBOOK.            *        
      *  10/08/96    MRB      PCR #263 - ADDED CODE TO SUPPORT NEW     *        
      *                       NOTICE TYPES ON CSS_CRED_COLL, 'N'       *        
      *                       RETURNED CHECK NOTICE AND '0' DEPOSIT    *        
      *                       NOTICE.                                  *        
      *  12/10/96    PD       TP6074 - REMOVED 7100- PARA AS IT IS     *        
      *                       NEVER USED.                              *        
      *  12/10/96    PD       TP8015 - COMMENTED CODE TO ABEND IF NO   *        
      *                       'A' ROW IS FOUND AFTER CALLING CPD68(    *        
      *                       3300- PARA) BECAUSE NEW ACCOUNT WILL NOT *        
      *                       HAVE 'A' ROW BUT MAY HAVE DEPOSIT ROWS.  *        
      *  01/29/97    SG       T8726 - ADDED NULL INDICATORS TO DATES.  *        
      *  01/29/97    SG       T8845 - ADDED NON-UTIL FOR USE BY PANEL. *        
      *  02/07/97    SG       T9197 - CORRECTED DETERMINATION OF NON-  *        
      *                       UTILITY ACCOUNT ADDING PENDING ACCOUNT   *        
      *                       CHECK ALSO.                              *        
      *  02/19/97    PD       T8404 - ADDED NOTICE TYPE 'K' AND 'L'    *        
      *                       FOR NON UTILITY ACCOUNTS.                *        
      *  03/18/97    MJG      INITIAL CLEANUP BEFORE SWAT TEAM SO      *        
      *                       ONLY ONE ROW WILL BE RETURNED FROM RPC   *        
      *  03/31/97    EMM      ADDED TABLE DCLGENS -- FOR CSS_CHRG_OFF  *        
      *                       AND CSS_FINAL_WO.                        *        
T10167*  04/07/97    MJG      FIXED PROGRAM TO USE COPYBOOK CPD00310   *        
T10167*                       TO CACLULATE THE NEXT READ DATE.         *        
NONUTL*  07/11/97    MJG      RETURNED ADDITIONAL WQ CREDIT ROW THAT   *        
NONUTL*                       IS USED FOR NON-UTILITY ACCOUNTS.        *        
T12460*  08/01/97    EMS      ADDED CSS_DNP FOR CPD00068 PROCESSING.   *        
T12596*  08/06/97    EMS      MOVED SPACES TO AT-CODE-DISC-OK WHEN     *        
      *                       EQUAL TO LOW-VALUES.                     *        
T13292*  10/08/97    MAD      ADDED SELECT OF AT.BILL_CYCLE FOR NEW    *        
      *                       LOGIC IN CPD00310.                       *        
T16853*  06/23/98    MDJ      ADDED INCLUDE TBARHDT FOR CPD00068.      *        
T17071*  11/19/98    MDJ      ADDED INCLUDE TBCSTALT FOR CUST_ALERT    *        
      *                       FOR CPD00068.                            *        
T12913*  12/02/98    SHF      ADDED CREDIT GROUP IDENTIFIER MED CERT.  *        
T19557*  01/27/00    CBSI     COPYBOOK CDP00068 CHANGED TO SUB PROGRAM *        
T19557*              MADRAS   SCSCO068.                                *        
T21919*  04/13/00    SFH      MADE CHANGES FOR UTIL/NON-UTIL PROJECT.  *        
      *                       ADDED AMOUNTS, MAIL DATES, AND DUE DATES *        
      *                       FOR ROWS P, Q, R, S, T, AND U FROM       *        
      *                       CSS_CRED_COLL.  ALSO ADDED AMOUNTS AND   *        
      *                       DATES FOR ROW M AND AMOUNTS FOR ROWS W   *        
      *                       AND V.  THESE ARE PASSED FROM CPD00068 TO*        
      *                       S023 AND THEN PASSED TO PANEL 131 & 132. *        
T22359*  06/23/00    SFH      MADE CHANGES TO KEEP IDENTITY OF PROGRAM *        
      *                       CALLING SCSCO068 OR SCSCB068.  THERE IS  *        
      *                       SPECIFIC LOGIC IN CPD00068 FOR CERTAIN   *        
      *                       PROGRAMS WHICH WAS NOT BEING EXECUTED    *        
      *                       PROPERLY BECAUSE THE PROGRAM NAME WAS    *        
      *                       ALWAYS SCSCO068 OR SCSCB068.             *        
C23235*  03/05/01    LEF      CHANGES FOR PSNC CONVERSION - ADDED FIELD*        
C23235*                       DATE FOR ROWS C,F,S, AND U.              *        
C23235*  04/17/01    LEF      CHANGES FOR PSNC CONVERSION - ADDED DISC *        
C23235*                       HIST FIELD FOR NEW PC BUTTON             *        
C28788*  07/03/03    MDJ      GET IVR-EXEMPT-CD FOR CPD00068.          *        
      *                                                                *        
REARCH*  07/09/03   MR90712    RPC CONVERTED TO COBOL SP               *        
T28824*  12/03/04   VD88125   FOR SEB, POPULATE THIRD-PTY-READ-DT FROM *        
T28824*                       CPD00310.                                *        
T32545*  07/15/05   JC91900   ADD LOGIC TO RETREIVE IVR DATES FOR RET  *        
T32545*                       CHECK AND DEPOSITS.                      *        
T32545*  09/12/05   DP19151   MOVE SPACES TO THE NEW IVR DATES FIELDS  *        
T32545*                       UNTIL UR CHANGES GO TO PROD ON OC 22ND.  *        
C36956*  10/08/08   CVNS      BBP CHANGES                              *        
C36956*             CHENNAI                                            *        
P00399*  11/04/10   VV94890   ADDED MEDICAL EXPIRE DT TO RESULT SET -  *        
P00399*                       POP UP NEW MSG ON PANEL132, WHEN ACTIVE  *        
P00399*                       MEDICAL CERTIFICATE EXPIRE DATE > NEXT   *        
P00399*                       BILL DATE FOR ACTIVE SCEG ACCOUNTS ONLY. *        
P00453*  11/25/10   AA97148   MOVE PAG TO THE CREDIT GROUP ID FOR      *        
P00453*                       PAY-AND-GO ACCOUNTS.                     *        
P00453*  05/18/11   AA97148   REPLACED 'PAG' with 'PRP and 'PAY-AND-GO'*        
P00453*                       WITH 'PRE-PAY-PLAN'.                     *        
P00599*  04/03/12   GV7A828   MODIFIED TO GET FORECAST CREDIT GROUP    *        
P00599*                       FROM CSS_ACCT_ATTRIBUTE TABLE            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02023'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORKING STORAGE FOR CPD00068                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
TP5309     EXEC SQL                                                             
TP5309        INCLUDE TBUTLENV                                                  
TP5309     END-EXEC.                                                            
TP5309                                                                  
TP5309     EXEC SQL                                                             
TP5309        INCLUDE TBRDWNDW                                                  
TP5309     END-EXEC.                                                            
TP5309                                                                  
      ******************************************************************        
      *    AT - CSS_ACCOUNT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CT - CSS_CONTRACT                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
      *                                                                         
P00399******************************************************************        
P00399*    CA - CSS_CUST_ALERT                                         *        
P00399******************************************************************        
P00399*                                                                         
P00399     EXEC SQL                                                             
P00399         INCLUDE TBCSTALT                                                 
P00399     END-EXEC.                                                            
P00399*                                                                         
P00599******************************************************************        
P00599*    YP - CSS_ACCT_ATTRIBUTE                                     *        
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBACTATT                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
      ******************************************************************        
      *    COMMON COPYLIBS                                             *        
      ******************************************************************        
                                                                        
REARCH*    COPY SYGWCOB.                                                        
REARCH*    COPY SYDBCOB.                                                        
REARCH*    COPY CWS00010.                                                       
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
           COPY CWS00056.                                                       
           COPY CWS00303.                                                       
           COPY CWS00021.                                                       
T19557     COPY CWS0068L.                                               01680000
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  GWL-PROC                     POINTER.                            
REARCH*    05  GWL-INIT-HANDLE              POINTER.                            
REARCH*    05  GWL-RC                       PIC S9(9) COMP.                     
REARCH*    05  GWL-STATUS-NR                PIC S9(9) COMP.                     
REARCH*    05  GWL-STATUS-DONE              PIC S9(9) COMP.                     
REARCH*    05  GWL-STATUS-COUNT             PIC S9(9) COMP.                     
REARCH*    05  GWL-STATUS-COMM              PIC S9(9) COMP.                     
REARCH*    05  GWL-STATUS-RETURN-CODE       PIC S9(9) COMP.                     
REARCH*    05  GWL-STATUS-SUBCODE           PIC S9(9) COMP.                     
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                     PIC S9(9) COMP.             
           05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
           05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
REARCH*    05  MSG-RPC                      PIC X(4) VALUE 'S023'.              
REARCH     05  MSG-RPC                      PIC X(8) VALUE 'CSR02023'.  
           05  MSG-RPC-L                    PIC S9(9) COMP.             
           05  MSG-TEXT                     PIC X(100).                 
           05  MSG-TEXT-L                   PIC S9(9) COMP.             
           05  MSG-SQL-ERROR.                                           
               10  FILLER                   PIC X(10)                   
                                            VALUE 'SQLCODE = '.         
               10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
               10  FILLER                   PIC X(16)                   
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K          PIC X(70).                  
               10  MSG-SQL-ERROR-K-CHARS                                
                                            REDEFINES MSG-SQL-ERROR-K   
                                            OCCURS 70 TIMES             
                                            PIC X.                      
           05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
                                                                        
      ******************************************************************        
      *    INPUT PARAMETERS                                            *        
      ******************************************************************        
                                                                        
       01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                       PIC S9(9) COMP.                     
REARCH*    05  PARM-ID1                     PIC S9(9) COMP VALUE 1.             
REARCH*    05  PARM-ACCT-NO                 PIC X(13).                          
REARCH*    05  PARM-ACCT-NO-NUM             REDEFINES PARM-ACCT-NO              
REARCH*                                     PIC 9(13).                          
REARCH     05  PARM-ACCT-NO-TEMP            PIC X(13).                  
REARCH     05  PARM-ACCT-NO-NUM             REDEFINES PARM-ACCT-NO-TEMP 
REARCH                                      PIC 9(13).                  
REARCH*    05  PARM-ITEM-ID                 PIC S9(9) COMP.                     
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
           05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
PCR361     05  WS-CONVERT-DELINQ            PIC 9(06) VALUE 0.          
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                      VALUE 'SESSION.CSR02023_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
      ******************************************************************        
      *    RESULT SET FIELDS                                           *        
      ******************************************************************        
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP VALUE +0.    
           05  RS-FRCST-CR-GRP              PIC X(1) VALUE SPACE.       
           05  RS-SPECIAL-TYPE              PIC X(1) VALUE SPACE.       
           05  RS-EXEMPT-CODE               PIC X VALUE SPACE.          
           05  RS-AMT-PAST-DUE              PIC S9(9)V99 USAGE COMP-3   
                                                      VALUE +0.         
           05  RS-CREDIT-GROUP              PIC X(1)  VALUE SPACE.      
           05  RS-CREDIT-GROUP-ID           PIC X(10) VALUE SPACE.      
TP5309     05  RS-DAY-SPECIALDNP1           PIC X(6)  VALUE SPACES.     
TP5309     05  RS-DAY-SPECIALDNP2           PIC X(6)  VALUE SPACES.     
TP5309     05  RS-AMT-SPECIALDNPLIM         PIC X(6)  VALUE SPACES.     
TP5309     05  RS-NEXT-READ-DATE            PIC X(10) VALUE SPACES.     
T8845      05  RS-NONUTIL                   PIC X(1)  VALUE SPACES.     
           05  RS-BILLED-AMT-A              PIC S9(9)V99 USAGE COMP-3   
                                                     VALUE +0.          
           05  RS-BILLED-MAIL-A             PIC X(10) VALUE SPACES.     
           05  RS-BILLED-DUE-A              PIC X(10) VALUE SPACES.     
           05  RS-BILLED-AVOIDLPC-A         PIC X(10) VALUE SPACES.     
           05  RS-FIRST-AMT-B               PIC S9(9)V99 USAGE COMP-3   
                                                     VALUE +0.          
           05  RS-FIRST-MAIL-B              PIC X(10) VALUE SPACES.     
           05  RS-FIRST-DUE-B               PIC X(10) VALUE SPACES.     
           05  RS-SECOND-AMT-C              PIC S9(9)V99 USAGE COMP-3   
                                                     VALUE +0.          
           05  RS-SECOND-MAIL-C             PIC X(10) VALUE SPACES.     
           05  RS-SECOND-DUE-C              PIC X(10) VALUE SPACES.     
C23235     05  RS-FIELD-DATE-C              PIC X(10) VALUE SPACES.     
           05  RS-DNP-AMT-D                 PIC S9(9)V99 USAGE COMP-3   
                                                     VALUE +0.          
           05  RS-DNP-DATE-D                PIC X(10) VALUE SPACES.     
           05  RS-FIRST-AMT-E               PIC S9(9)V99 USAGE COMP-3   
                                                     VALUE +0.          
           05  RS-FIRST-MAIL-E              PIC X(10) VALUE SPACES.     
           05  RS-FIRST-DUE-E               PIC X(10) VALUE SPACES.     
           05  RS-SECOND-AMT-F              PIC S9(9)V99 USAGE COMP-3   
                                                     VALUE +0.          
           05  RS-SECOND-MAIL-F             PIC X(10) VALUE SPACES.     
           05  RS-SECOND-DUE-F              PIC X(10) VALUE SPACES.     
C23235     05  RS-FIELD-DATE-F              PIC X(10) VALUE SPACES.     
           05  RS-DNP-AMT-G                 PIC S9(9)V99 USAGE COMP-3   
                                                     VALUE +0.          
           05  RS-DNP-DATE-G                PIC X(10) VALUE SPACES.     
           05  RS-AMT-NOTICE-H              PIC S9(9)V99 USAGE COMP-3   
                                                     VALUE +0.          
           05  RS-AVOIDLPC-DATE-H           PIC X(10) VALUE SPACES.     
           05  RS-AMT-NOTICE-I              PIC S9(9)V99 USAGE COMP-3   
                                                     VALUE +0.          
           05  RS-AVOIDLPC-DATE-I           PIC X(10) VALUE SPACES.     
           05  RS-FIRST-AMT-K               PIC S9(9)V99 USAGE COMP-3   
                                                     VALUE +0.          
           05  RS-FIRST-MAIL-K              PIC X(10) VALUE SPACES.     
           05  RS-FIRST-DUE-K               PIC X(10) VALUE SPACES.     
           05  RS-SECOND-AMT-L              PIC S9(9)V99 USAGE COMP-3   
                                                     VALUE +0.          
           05  RS-SECOND-MAIL-L             PIC X(10) VALUE SPACES.     
           05  RS-CRED-BUREA-DATE-L         PIC X(10) VALUE SPACES.     
NONUTL     05  RS-CRED-BUREA-DATE-M         PIC X(10) VALUE SPACES.     
           05  RS-AMT-NOTICE-N              PIC S9(9)V99 USAGE COMP-3   
                                                     VALUE +0.          
           05  RS-NOTICE-MAIL-N             PIC X(10) VALUE SPACES.     
           05  RS-NOTICE-DUE-N              PIC X(10) VALUE SPACES.     
           05  RS-AMT-NOTICE-O              PIC S9(9)V99 USAGE COMP-3   
                                                     VALUE +0.          
           05  RS-NOTICE-MAIL-O             PIC X(10) VALUE SPACES.     
           05  RS-NOTICE-DUE-O              PIC X(10) VALUE SPACES.     
T21919     05  RS-BILLED-AMT-P              PIC S9(9)V99 USAGE COMP-3   
T21919                                               VALUE +0.          
T21919     05  RS-BILLED-MAIL-P             PIC X(10) VALUE SPACES.     
T21919     05  RS-BILLED-DUE-P              PIC X(10) VALUE SPACES.     
T21919     05  RS-AMT-NOTICE-W              PIC S9(9)V99 USAGE COMP-3   
T21919                                               VALUE +0.          
T21919     05  RS-BILLED-AMT-Q              PIC S9(9)V99 USAGE COMP-3   
T21919                                               VALUE +0.          
T21919     05  RS-BILLED-MAIL-Q             PIC X(10) VALUE SPACES.     
T21919     05  RS-BILLED-DUE-Q              PIC X(10) VALUE SPACES.     
T21919     05  RS-FIRST-AMT-R               PIC S9(9)V99 USAGE COMP-3   
T21919                                               VALUE +0.          
T21919     05  RS-FIRST-MAIL-R              PIC X(10) VALUE SPACES.     
T21919     05  RS-FIRST-DUE-R               PIC X(10) VALUE SPACES.     
T21919     05  RS-SECOND-AMT-S              PIC S9(9)V99 USAGE COMP-3   
T21919                                               VALUE +0.          
T21919     05  RS-SECOND-MAIL-S             PIC X(10) VALUE SPACES.     
T21919     05  RS-SECOND-DUE-S              PIC X(10) VALUE SPACES.     
C23235     05  RS-FIELD-DATE-S              PIC X(10) VALUE SPACES.     
T21919     05  RS-NORMAL-AMT-M              PIC S9(9)V99 USAGE COMP-3   
T21919                                               VALUE +0.          
T21919     05  RS-NORMAL-DATE-M             PIC X(10) VALUE SPACES.     
T21919     05  RS-FIRST-AMT-T               PIC S9(9)V99 USAGE COMP-3   
T21919                                               VALUE +0.          
T21919     05  RS-FIRST-MAIL-T              PIC X(10) VALUE SPACES.     
T21919     05  RS-FIRST-DUE-T               PIC X(10) VALUE SPACES.     
T21919     05  RS-SECOND-AMT-U              PIC S9(9)V99 USAGE COMP-3   
T21919                                               VALUE +0.          
T21919     05  RS-SECOND-MAIL-U             PIC X(10) VALUE SPACES.     
T21919     05  RS-SECOND-DUE-U              PIC X(10) VALUE SPACES.     
C23235     05  RS-FIELD-DATE-U              PIC X(10) VALUE SPACES.     
T21919     05  RS-EXCEPT-AMT-X              PIC S9(9)V99 USAGE COMP-3   
T21919                                               VALUE +0.          
T21919     05  RS-EXCEPT-DATE-X             PIC X(10) VALUE SPACES.     
T21919     05  RS-AMT-NOTICE-V              PIC S9(9)V99 USAGE COMP-3   
T21919                                               VALUE +0.          
T32545     05  RS-IVR-DATE-N                PIC X(10) VALUE SPACES.     
T32545     05  RS-IVR-DATE-O                PIC X(10) VALUE SPACES.     
P00399     05  RS-MED-CERT-EXP-DT           PIC X(10) VALUE SPACES.     
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE                PIC S9(9) COMP VALUE +0.    
REARCH     05  S-FRCST-CR-GRP               PIC X(1) VALUE SPACE.       
REARCH     05  S-SPECIAL-TYPE               PIC X(1) VALUE SPACE.       
REARCH     05  S-EXEMPT-CODE                PIC X VALUE SPACE.          
REARCH     05  S-AMT-PAST-DUE               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-CREDIT-GROUP               PIC X(1)  VALUE SPACE.      
REARCH     05  S-CREDIT-GROUP-ID            PIC X(10) VALUE SPACE.      
REARCH     05  S-DAY-SPECIALDNP1            PIC X(6)  VALUE SPACES.     
REARCH     05  S-DAY-SPECIALDNP2            PIC X(6)  VALUE SPACES.     
REARCH     05  S-AMT-SPECIALDNPLIM          PIC X(6)  VALUE SPACES.     
REARCH     05  S-NEXT-READ-DATE             PIC X(10) VALUE SPACES.     
REARCH     05  S-NONUTIL                    PIC X(1)  VALUE SPACES.     
REARCH     05  S-BILLED-AMT-A               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-BILLED-MAIL-A              PIC X(10) VALUE SPACES.     
REARCH     05  S-BILLED-DUE-A               PIC X(10) VALUE SPACES.     
REARCH     05  S-BILLED-AVOIDLPC-A          PIC X(10) VALUE SPACES.     
REARCH     05  S-FIRST-AMT-B                PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-FIRST-MAIL-B               PIC X(10) VALUE SPACES.     
REARCH     05  S-FIRST-DUE-B                PIC X(10) VALUE SPACES.     
REARCH     05  S-SECOND-AMT-C               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-SECOND-MAIL-C              PIC X(10) VALUE SPACES.     
REARCH     05  S-SECOND-DUE-C               PIC X(10) VALUE SPACES.     
REARCH     05  S-FIELD-DATE-C               PIC X(10) VALUE SPACES.     
REARCH     05  S-DNP-AMT-D                  PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-DNP-DATE-D                 PIC X(10) VALUE SPACES.     
REARCH     05  S-FIRST-AMT-E                PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-FIRST-MAIL-E               PIC X(10) VALUE SPACES.     
REARCH     05  S-FIRST-DUE-E                PIC X(10) VALUE SPACES.     
REARCH     05  S-SECOND-AMT-F               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-SECOND-MAIL-F              PIC X(10) VALUE SPACES.     
REARCH     05  S-SECOND-DUE-F               PIC X(10) VALUE SPACES.     
REARCH     05  S-FIELD-DATE-F               PIC X(10) VALUE SPACES.     
REARCH     05  S-DNP-AMT-G                  PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-DNP-DATE-G                 PIC X(10) VALUE SPACES.     
REARCH     05  S-AMT-NOTICE-H               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-AVOIDLPC-DATE-H            PIC X(10) VALUE SPACES.     
REARCH     05  S-AMT-NOTICE-I               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-AVOIDLPC-DATE-I            PIC X(10) VALUE SPACES.     
REARCH     05  S-FIRST-AMT-K                PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-FIRST-MAIL-K               PIC X(10) VALUE SPACES.     
REARCH     05  S-FIRST-DUE-K                PIC X(10) VALUE SPACES.     
REARCH     05  S-SECOND-AMT-L               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-SECOND-MAIL-L              PIC X(10) VALUE SPACES.     
REARCH     05  S-CRED-BUREA-DATE-L          PIC X(10) VALUE SPACES.     
REARCH     05  S-CRED-BUREA-DATE-M          PIC X(10) VALUE SPACES.     
REARCH     05  S-AMT-NOTICE-N               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-NOTICE-MAIL-N              PIC X(10) VALUE SPACES.     
REARCH     05  S-NOTICE-DUE-N               PIC X(10) VALUE SPACES.     
REARCH     05  S-AMT-NOTICE-O               PIC S9(9)V99 USAGE COMP-3   
                                                         VALUE +0.      
REARCH                                                                  
REARCH     05  S-NOTICE-MAIL-O              PIC X(10) VALUE SPACES.     
REARCH     05  S-NOTICE-DUE-O               PIC X(10) VALUE SPACES.     
REARCH     05  S-BILLED-AMT-P               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-BILLED-MAIL-P              PIC X(10) VALUE SPACES.     
REARCH     05  S-BILLED-DUE-P               PIC X(10) VALUE SPACES.     
REARCH     05  S-AMT-NOTICE-W               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-BILLED-AMT-Q               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-BILLED-MAIL-Q              PIC X(10) VALUE SPACES.     
REARCH     05  S-BILLED-DUE-Q               PIC X(10) VALUE SPACES.     
REARCH     05  S-FIRST-AMT-R                PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-FIRST-MAIL-R               PIC X(10) VALUE SPACES.     
REARCH     05  S-FIRST-DUE-R                PIC X(10) VALUE SPACES.     
REARCH     05  S-SECOND-AMT-S               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-SECOND-MAIL-S              PIC X(10) VALUE SPACES.     
REARCH     05  S-SECOND-DUE-S               PIC X(10) VALUE SPACES.     
REARCH     05  S-FIELD-DATE-S               PIC X(10) VALUE SPACES.     
REARCH     05  S-NORMAL-AMT-M               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-NORMAL-DATE-M              PIC X(10) VALUE SPACES.     
REARCH     05  S-FIRST-AMT-T                PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-FIRST-MAIL-T               PIC X(10) VALUE SPACES.     
REARCH     05  S-FIRST-DUE-T                PIC X(10) VALUE SPACES.     
REARCH     05  S-SECOND-AMT-U               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-SECOND-MAIL-U              PIC X(10) VALUE SPACES.     
REARCH     05  S-SECOND-DUE-U               PIC X(10) VALUE SPACES.     
REARCH     05  S-FIELD-DATE-U               PIC X(10) VALUE SPACES.     
REARCH     05  S-EXCEPT-AMT-X               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-EXCEPT-DATE-X              PIC X(10) VALUE SPACES.     
REARCH     05  S-AMT-NOTICE-V               PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-TOT-BILLED-BAL             PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-NEXT-BILL-DATE             PIC X(10) VALUE SPACES.     
REARCH     05  S-BILL-CYCLE                 PIC X(02) VALUE SPACES.     
REARCH     05  S-ITEM-ID                    PIC S9(9) COMP              
REARCH                                          VALUE +0.               
REARCH     05  S-UTIL-PAST-DUE              PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-UTIL-BILLED-BAL            PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-NONUTIL-PAST-DUE           PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-NON-UTL-BLLD-BAL           PIC S9(9)V99 USAGE COMP-3   
REARCH                                                VALUE +0.         
REARCH     05  S-DISCONNECT-HIST            PIC X(24) VALUE SPACES.     
REARCH     05  S-DISC-EXCEPTN-HST           PIC X(24) VALUE SPACES.     
REARCH     05  S-NON-UTL-CR-HIST            PIC X(24) VALUE SPACES.     
REARCH     05  S-NON-UTL-CR-HSTEX           PIC X(24) VALUE SPACES.     
T32545     05  S-IVR-DATE-N                 PIC X(10) VALUE SPACES.     
T32545     05  S-IVR-DATE-O                 PIC X(10) VALUE SPACES.     
P00399     05  S-MED-CERT-EXP-DT            PIC X(10) VALUE SPACES.     
REARCH*                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
                                                                        
       01  WS-MISC-FIELDS.                                              
REARCH     05  PROGRAM-NAME                 PIC X(8)   VALUE 'CSR02023'.
REARCH     05  WS-SQLSTATE                  PIC X(5)   VALUE SPACES.    
COB305     05 WS-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.          
           05  WS-CURRENT-DATE              PIC X(10).                  
           05  WS-NULL-IND-CPD              PIC S9(4)  COMP.            
T28824     05  WS-CPD310-NULL-IND           PIC S9(4)  COMP.            
           05  WS-NULL-1                    PIC S9(4)  COMP.            
           05  WS-NULL-2                    PIC S9(4)  COMP.            
           05  WS-NULL-3                    PIC S9(4)  COMP.            
T8726      05  WS-NULL-4                    PIC S9(4)  COMP.            
TP5309     05  WS-SPACE                     PIC X(02) VALUE SPACES.     
TP5309     05  WS-DATE-CCYY-MM-DD.                                      
TP5309         10  WS-DATE-CCYY             PIC X(04) VALUE SPACES.     
TP5309         10  FILLER                   PIC X(01) VALUE SPACES.     
TP5309         10  WS-DATE-MM               PIC X(02) VALUE SPACES.     
TP5309         10  FILLER                   PIC X(01) VALUE SPACES.     
TP5309         10  WS-DATE-DD               PIC X(02) VALUE SPACES.     
TP5309     05  WS-DATE-MM-DD-YYYY.                                      
TP5309         10  WS-DATE2-MM              PIC X(02) VALUE SPACES.     
TP5309         10  FILLER                   PIC X(01) VALUE '/'.        
TP5309         10  WS-DATE2-DD              PIC X(02) VALUE SPACES.     
TP5309         10  FILLER                   PIC X(01) VALUE '/'.        
TP5309         10  WS-DATE2-CCYY            PIC X(04) VALUE SPACES.     
T19557     05 WS-EIBRESP                    PIC S9(8)                   
T19557                                         COMP SYNC VALUE ZERO.    
                                                                        
       01  LITERALS.                                                    
           05  WS-A                    PIC X(1)  VALUE 'A'.             
           05  WS-B                    PIC X(1)  VALUE 'B'.             
           05  WS-C                    PIC X(1)  VALUE 'C'.             
           05  WS-D                    PIC X(1)  VALUE 'D'.             
           05  WS-F                    PIC X(1)  VALUE 'F'.             
           05  WS-FOUR                 PIC X(1)  VALUE '4'.             
           05  WS-HOME                 PIC X(2)  VALUE 'H1'.            
           05  WS-WORK                 PIC X(2)  VALUE 'W1'.            
           05  WS-WAIVER-TEXT          PIC X(14) VALUE 'WAIVER        '.
           05  WS-SUB-ACCT             PIC X(10) VALUE 'SUB ACCT  '.    
T12913     05  WS-MEDICAL              PIC X(10) VALUE 'MED CERT  '.    
           05  WS-MASTER               PIC X(10) VALUE 'MASTER    '.    
           05  WS-MAJOR                PIC X(10) VALUE 'MAJOR     '.    
           05  WS-CT-RATED             PIC X(10) VALUE 'CT METER  '.    
C36956     05  WS-BBP                  PIC X(10) VALUE 'BBP       '.    
P00453     05  WS-PRP                  PIC X(10) VALUE 'PRP       '.    
           05  WS-DPP                  PIC X(10) VALUE 'DPP       '.    
           05  WS-NON-PAY              PIC X(1)  VALUE 'C'.             
           05  WS-FINAL-BILL           PIC X(1)  VALUE 'B'.             
REARCH     05  MCSCB068                PIC X(8)  VALUE 'MCSCB068'.      
HPCCDM*EJECT                                                                    
T19557 LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-ACCT-NO                 PIC X(13).                      
REARCH 01  PARM-ITEM-ID                 PIC S9(9) COMP.                 
      *                                                                         
                                                                        
REARCH PROCEDURE DIVISION USING PARM-ACCT-NO                            
REARCH                         ,PARM-ITEM-ID.                           
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2200-PROCESS-OUTPUT THRU 2200-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH           :S-RETURN-CODE       AS RETURN_CODE                    
REARCH          ,:S-FRCST-CR-GRP      AS FRCST_CR_GRP                   
REARCH          ,:S-SPECIAL-TYPE      AS SPECIAL_TYPE                   
REARCH          ,:S-EXEMPT-CODE       AS EXEMPT_CODE                    
REARCH          ,:S-AMT-PAST-DUE      AS AMT_PAST_DUE                   
REARCH          ,:S-CREDIT-GROUP      AS CREDIT_GROUP                   
REARCH          ,:S-CREDIT-GROUP-ID   AS CREDIT_GROUP_ID                
REARCH          ,:S-DAY-SPECIALDNP1   AS DAY_SPECIALDNP1                
REARCH          ,:S-DAY-SPECIALDNP2   AS DAY_SPECIALDNP2                
REARCH          ,:S-AMT-SPECIALDNPLIM AS AMT_SPECIALDNPLIM              
REARCH          ,:S-NEXT-READ-DATE    AS NEXT_READ_DATE                 
REARCH          ,:S-NONUTIL           AS NONUTIL                        
REARCH          ,:S-BILLED-AMT-A      AS BILLED_AMT_A                   
REARCH          ,:S-BILLED-MAIL-A     AS BILLED_MAIL_A                  
REARCH          ,:S-BILLED-DUE-A      AS BILLED_DUE_A                   
REARCH          ,:S-BILLED-AVOIDLPC-A AS BILLED_AVOIDLPC_A              
REARCH          ,:S-FIRST-AMT-B       AS FIRST_AMT_B                    
REARCH          ,:S-FIRST-MAIL-B      AS FIRST_MAIL_B                   
REARCH          ,:S-FIRST-DUE-B       AS FIRST_DUE_B                    
REARCH          ,:S-SECOND-AMT-C      AS SECOND_AMT_C                   
REARCH          ,:S-SECOND-MAIL-C     AS SECOND_MAIL_C                  
REARCH          ,:S-SECOND-DUE-C      AS SECOND_DUE_C                   
REARCH          ,:S-FIELD-DATE-C      AS FIELD_DATE_C                   
REARCH          ,:S-DNP-AMT-D         AS DNP_AMT_D                      
REARCH          ,:S-DNP-DATE-D        AS DNP_DATE_D                     
REARCH          ,:S-FIRST-AMT-E       AS FIRST_AMT_E                    
REARCH          ,:S-FIRST-MAIL-E      AS FIRST_MAIL_E                   
REARCH          ,:S-FIRST-DUE-E       AS FIRST_DUE_E                    
REARCH          ,:S-SECOND-AMT-F      AS SECOND_AMT_F                   
REARCH          ,:S-SECOND-MAIL-F     AS SECOND_MAIL_F                  
REARCH          ,:S-SECOND-DUE-F      AS SECOND_DUE_F                   
REARCH          ,:S-FIELD-DATE-F      AS FIELD_DATE_F                   
REARCH          ,:S-DNP-AMT-G         AS DNP_AMT_G                      
REARCH          ,:S-DNP-DATE-G        AS DNP_DATE_G                     
REARCH          ,:S-AMT-NOTICE-H      AS AMT_NOTICE_H                   
REARCH          ,:S-AVOIDLPC-DATE-H   AS AVOIDLPC_DATE_H                
REARCH          ,:S-AMT-NOTICE-I      AS AMT_NOTICE_I                   
REARCH          ,:S-AVOIDLPC-DATE-I   AS AVOIDLPC_DATE_I                
REARCH          ,:S-FIRST-AMT-K       AS FIRST_AMT_K                    
REARCH          ,:S-FIRST-MAIL-K      AS FIRST_MAIL_K                   
REARCH          ,:S-FIRST-DUE-K       AS FIRST_DUE_K                    
REARCH          ,:S-SECOND-AMT-L      AS SECOND_AMT_L                   
REARCH          ,:S-SECOND-MAIL-L     AS SECOND_MAIL_L                  
REARCH          ,:S-CRED-BUREA-DATE-L AS CRED_BUREA_DATE_L              
REARCH          ,:S-CRED-BUREA-DATE-M AS CRED_BUREA_DATE_M              
REARCH          ,:S-AMT-NOTICE-N      AS AMT_NOTICE_N                   
REARCH          ,:S-NOTICE-MAIL-N     AS NOTICE_MAIL_N                  
REARCH          ,:S-NOTICE-DUE-N      AS NOTICE_DUE_N                   
REARCH          ,:S-AMT-NOTICE-O      AS AMT_NOTICE_O                   
REARCH          ,:S-NOTICE-MAIL-O     AS NOTICE_MAIL_O                  
REARCH          ,:S-NOTICE-DUE-O      AS NOTICE_DUE_O                   
REARCH          ,:S-BILLED-AMT-P      AS BILLED_AMT_P                   
REARCH          ,:S-BILLED-MAIL-P     AS BILLED_MAIL_P                  
REARCH          ,:S-BILLED-DUE-P      AS BILLED_DUE_P                   
REARCH          ,:S-AMT-NOTICE-W      AS AMT_NOTICE_W                   
REARCH          ,:S-BILLED-AMT-Q      AS BILLED_AMT_Q                   
REARCH          ,:S-BILLED-MAIL-Q     AS BILLED_MAIL_Q                  
REARCH          ,:S-BILLED-DUE-Q      AS BILLED_DUE_Q                   
REARCH          ,:S-FIRST-AMT-R       AS FIRST_AMT_R                    
REARCH          ,:S-FIRST-MAIL-R      AS FIRST_MAIL_R                   
REARCH          ,:S-FIRST-DUE-R       AS FIRST_DUE_R                    
REARCH          ,:S-SECOND-AMT-S      AS SECOND_AMT_S                   
REARCH          ,:S-SECOND-MAIL-S     AS SECOND_MAIL_S                  
REARCH          ,:S-SECOND-DUE-S      AS SECOND_DUE_S                   
REARCH          ,:S-FIELD-DATE-S      AS FIELD_DATE_S                   
REARCH          ,:S-NORMAL-AMT-M      AS NORMAL_AMT_M                   
REARCH          ,:S-NORMAL-DATE-M     AS NORMAL_DATE_M                  
REARCH          ,:S-FIRST-AMT-T       AS FIRST_AMT_T                    
REARCH          ,:S-FIRST-MAIL-T      AS FIRST_MAIL_T                   
REARCH          ,:S-FIRST-DUE-T       AS FIRST_DUE_T                    
REARCH          ,:S-SECOND-AMT-U      AS SECOND_AMT_U                   
REARCH          ,:S-SECOND-MAIL-U     AS SECOND_MAIL_U                  
REARCH          ,:S-SECOND-DUE-U      AS SECOND_DUE_U                   
REARCH          ,:S-FIELD-DATE-U      AS FIELD_DATE_U                   
REARCH          ,:S-EXCEPT-AMT-X      AS EXCEPT_AMT_X                   
REARCH          ,:S-EXCEPT-DATE-X     AS EXCEPT_DATE_X                  
REARCH          ,:S-AMT-NOTICE-V      AS AMT_NOTICE_V                   
REARCH          ,:S-TOT-BILLED-BAL    AS TOT_BILLED_BAL                 
REARCH          ,:S-NEXT-BILL-DATE    AS NEXT_BILL_DATE                 
REARCH          ,:S-BILL-CYCLE        AS BILL_CYCLE                     
REARCH          ,:S-ITEM-ID           AS ITEM_ID                        
REARCH          ,:S-UTIL-PAST-DUE     AS UTIL_PAST_DUE                  
REARCH          ,:S-UTIL-BILLED-BAL   AS UTIL_BILLED_BAL                
REARCH          ,:S-NONUTIL-PAST-DUE  AS NONUTIL_PAST_DUE               
REARCH          ,:S-NON-UTL-BLLD-BAL  AS NON_UTL_BLLD_BAL               
REARCH          ,:S-DISCONNECT-HIST   AS DISCONNECT_HIST                
REARCH          ,:S-DISC-EXCEPTN-HST  AS DISC_EXCEPTN_HST               
REARCH          ,:S-NON-UTL-CR-HIST   AS NON_UTL_CR_HIST                
REARCH          ,:S-NON-UTL-CR-HSTEX  AS NON_UTL_CR_HSTEX               
T32545          ,:S-IVR-DATE-N        AS IVR_DATE_N                     
T32545          ,:S-IVR-DATE-O        AS IVR_DATE_O                     
P00399          ,:S-MED-CERT-EXP-DT   AS MED_CERT_EXP_DT                
REARCH         FROM                                                     
REARCH           CIS.SYSDUMMY1                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*          :S-RETURN-CODE       AS RETURN_CODE                            
MFA-TR*         ,:S-FRCST-CR-GRP      AS FRCST_CR_GRP                           
MFA-TR*         ,:S-SPECIAL-TYPE      AS SPECIAL_TYPE                           
MFA-TR*         ,:S-EXEMPT-CODE       AS EXEMPT_CODE                            
MFA-TR*         ,:S-AMT-PAST-DUE      AS AMT_PAST_DUE                           
MFA-TR*         ,:S-CREDIT-GROUP      AS CREDIT_GROUP                           
MFA-TR*         ,:S-CREDIT-GROUP-ID   AS CREDIT_GROUP_ID                        
MFA-TR*         ,:S-DAY-SPECIALDNP1   AS DAY_SPECIALDNP1                        
MFA-TR*         ,:S-DAY-SPECIALDNP2   AS DAY_SPECIALDNP2                        
MFA-TR*         ,:S-AMT-SPECIALDNPLIM AS AMT_SPECIALDNPLIM                      
MFA-TR*         ,:S-NEXT-READ-DATE    AS NEXT_READ_DATE                         
MFA-TR*         ,:S-NONUTIL           AS NONUTIL                                
MFA-TR*         ,:S-BILLED-AMT-A      AS BILLED_AMT_A                           
MFA-TR*         ,:S-BILLED-MAIL-A     AS BILLED_MAIL_A                          
MFA-TR*         ,:S-BILLED-DUE-A      AS BILLED_DUE_A                           
MFA-TR*         ,:S-BILLED-AVOIDLPC-A AS BILLED_AVOIDLPC_A                      
MFA-TR*         ,:S-FIRST-AMT-B       AS FIRST_AMT_B                            
MFA-TR*         ,:S-FIRST-MAIL-B      AS FIRST_MAIL_B                           
MFA-TR*         ,:S-FIRST-DUE-B       AS FIRST_DUE_B                            
MFA-TR*         ,:S-SECOND-AMT-C      AS SECOND_AMT_C                           
MFA-TR*         ,:S-SECOND-MAIL-C     AS SECOND_MAIL_C                          
MFA-TR*         ,:S-SECOND-DUE-C      AS SECOND_DUE_C                           
MFA-TR*         ,:S-FIELD-DATE-C      AS FIELD_DATE_C                           
MFA-TR*         ,:S-DNP-AMT-D         AS DNP_AMT_D                              
MFA-TR*         ,:S-DNP-DATE-D        AS DNP_DATE_D                             
MFA-TR*         ,:S-FIRST-AMT-E       AS FIRST_AMT_E                            
MFA-TR*         ,:S-FIRST-MAIL-E      AS FIRST_MAIL_E                           
MFA-TR*         ,:S-FIRST-DUE-E       AS FIRST_DUE_E                            
MFA-TR*         ,:S-SECOND-AMT-F      AS SECOND_AMT_F                           
MFA-TR*         ,:S-SECOND-MAIL-F     AS SECOND_MAIL_F                          
MFA-TR*         ,:S-SECOND-DUE-F      AS SECOND_DUE_F                           
MFA-TR*         ,:S-FIELD-DATE-F      AS FIELD_DATE_F                           
MFA-TR*         ,:S-DNP-AMT-G         AS DNP_AMT_G                              
MFA-TR*         ,:S-DNP-DATE-G        AS DNP_DATE_G                             
MFA-TR*         ,:S-AMT-NOTICE-H      AS AMT_NOTICE_H                           
MFA-TR*         ,:S-AVOIDLPC-DATE-H   AS AVOIDLPC_DATE_H                        
MFA-TR*         ,:S-AMT-NOTICE-I      AS AMT_NOTICE_I                           
MFA-TR*         ,:S-AVOIDLPC-DATE-I   AS AVOIDLPC_DATE_I                        
MFA-TR*         ,:S-FIRST-AMT-K       AS FIRST_AMT_K                            
MFA-TR*         ,:S-FIRST-MAIL-K      AS FIRST_MAIL_K                           
MFA-TR*         ,:S-FIRST-DUE-K       AS FIRST_DUE_K                            
MFA-TR*         ,:S-SECOND-AMT-L      AS SECOND_AMT_L                           
MFA-TR*         ,:S-SECOND-MAIL-L     AS SECOND_MAIL_L                          
MFA-TR*         ,:S-CRED-BUREA-DATE-L AS CRED_BUREA_DATE_L                      
MFA-TR*         ,:S-CRED-BUREA-DATE-M AS CRED_BUREA_DATE_M                      
MFA-TR*         ,:S-AMT-NOTICE-N      AS AMT_NOTICE_N                           
MFA-TR*         ,:S-NOTICE-MAIL-N     AS NOTICE_MAIL_N                          
MFA-TR*         ,:S-NOTICE-DUE-N      AS NOTICE_DUE_N                           
MFA-TR*         ,:S-AMT-NOTICE-O      AS AMT_NOTICE_O                           
MFA-TR*         ,:S-NOTICE-MAIL-O     AS NOTICE_MAIL_O                          
MFA-TR*         ,:S-NOTICE-DUE-O      AS NOTICE_DUE_O                           
MFA-TR*         ,:S-BILLED-AMT-P      AS BILLED_AMT_P                           
MFA-TR*         ,:S-BILLED-MAIL-P     AS BILLED_MAIL_P                          
MFA-TR*         ,:S-BILLED-DUE-P      AS BILLED_DUE_P                           
MFA-TR*         ,:S-AMT-NOTICE-W      AS AMT_NOTICE_W                           
MFA-TR*         ,:S-BILLED-AMT-Q      AS BILLED_AMT_Q                           
MFA-TR*         ,:S-BILLED-MAIL-Q     AS BILLED_MAIL_Q                          
MFA-TR*         ,:S-BILLED-DUE-Q      AS BILLED_DUE_Q                           
MFA-TR*         ,:S-FIRST-AMT-R       AS FIRST_AMT_R                            
MFA-TR*         ,:S-FIRST-MAIL-R      AS FIRST_MAIL_R                           
MFA-TR*         ,:S-FIRST-DUE-R       AS FIRST_DUE_R                            
MFA-TR*         ,:S-SECOND-AMT-S      AS SECOND_AMT_S                           
MFA-TR*         ,:S-SECOND-MAIL-S     AS SECOND_MAIL_S                          
MFA-TR*         ,:S-SECOND-DUE-S      AS SECOND_DUE_S                           
MFA-TR*         ,:S-FIELD-DATE-S      AS FIELD_DATE_S                           
MFA-TR*         ,:S-NORMAL-AMT-M      AS NORMAL_AMT_M                           
MFA-TR*         ,:S-NORMAL-DATE-M     AS NORMAL_DATE_M                          
MFA-TR*         ,:S-FIRST-AMT-T       AS FIRST_AMT_T                            
MFA-TR*         ,:S-FIRST-MAIL-T      AS FIRST_MAIL_T                           
MFA-TR*         ,:S-FIRST-DUE-T       AS FIRST_DUE_T                            
MFA-TR*         ,:S-SECOND-AMT-U      AS SECOND_AMT_U                           
MFA-TR*         ,:S-SECOND-MAIL-U     AS SECOND_MAIL_U                          
MFA-TR*         ,:S-SECOND-DUE-U      AS SECOND_DUE_U                           
MFA-TR*         ,:S-FIELD-DATE-U      AS FIELD_DATE_U                           
MFA-TR*         ,:S-EXCEPT-AMT-X      AS EXCEPT_AMT_X                           
MFA-TR*         ,:S-EXCEPT-DATE-X     AS EXCEPT_DATE_X                          
MFA-TR*         ,:S-AMT-NOTICE-V      AS AMT_NOTICE_V                           
MFA-TR*         ,:S-TOT-BILLED-BAL    AS TOT_BILLED_BAL                         
MFA-TR*         ,:S-NEXT-BILL-DATE    AS NEXT_BILL_DATE                         
MFA-TR*         ,:S-BILL-CYCLE        AS BILL_CYCLE                             
MFA-TR*         ,:S-ITEM-ID           AS ITEM_ID                                
MFA-TR*         ,:S-UTIL-PAST-DUE     AS UTIL_PAST_DUE                          
MFA-TR*         ,:S-UTIL-BILLED-BAL   AS UTIL_BILLED_BAL                        
MFA-TR*         ,:S-NONUTIL-PAST-DUE  AS NONUTIL_PAST_DUE                       
MFA-TR*         ,:S-NON-UTL-BLLD-BAL  AS NON_UTL_BLLD_BAL                       
MFA-TR*         ,:S-DISCONNECT-HIST   AS DISCONNECT_HIST                        
MFA-TR*         ,:S-DISC-EXCEPTN-HST  AS DISC_EXCEPTN_HST                       
MFA-TR*         ,:S-NON-UTL-CR-HIST   AS NON_UTL_CR_HIST                        
MFA-TR*         ,:S-NON-UTL-CR-HSTEX  AS NON_UTL_CR_HSTEX                       
MFA-TR*         ,:S-IVR-DATE-N        AS IVR_DATE_N                             
MFA-TR*         ,:S-IVR-DATE-O        AS IVR_DATE_O                             
MFA-TR*         ,:S-MED-CERT-EXP-DT   AS MED_CERT_EXP_DT                        
MFA-TR*        FROM                                                             
MFA-TR*          SYSIBM.SYSDUMMY1                                               
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE PARM-ACCT-NO     TO PARM-ACCT-NO-TEMP.                  
           MOVE PARM-ACCT-NO-NUM TO WS-ACCT-NO.                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
REARCH*****************************************************************         
REARCH*                                                               *         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*                                                               *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE          TO    S-RETURN-CODE.           
REARCH     MOVE  RS-FRCST-CR-GRP         TO    S-FRCST-CR-GRP.          
REARCH     MOVE  RS-SPECIAL-TYPE         TO    S-SPECIAL-TYPE.          
REARCH     MOVE  RS-EXEMPT-CODE          TO    S-EXEMPT-CODE.           
REARCH     MOVE  RS-AMT-PAST-DUE         TO    S-AMT-PAST-DUE.          
REARCH     MOVE  RS-CREDIT-GROUP         TO    S-CREDIT-GROUP.          
REARCH     MOVE  RS-CREDIT-GROUP-ID      TO    S-CREDIT-GROUP-ID.       
REARCH     MOVE  RS-DAY-SPECIALDNP1      TO    S-DAY-SPECIALDNP1.       
REARCH     MOVE  RS-DAY-SPECIALDNP2      TO    S-DAY-SPECIALDNP2.       
REARCH     MOVE  RS-AMT-SPECIALDNPLIM    TO    S-AMT-SPECIALDNPLIM.     
REARCH     MOVE  RS-NEXT-READ-DATE       TO    S-NEXT-READ-DATE.        
REARCH     MOVE  RS-NONUTIL              TO    S-NONUTIL.               
REARCH     MOVE  RS-BILLED-AMT-A         TO    S-BILLED-AMT-A.          
REARCH     MOVE  RS-BILLED-MAIL-A        TO    S-BILLED-MAIL-A.         
REARCH     MOVE  RS-BILLED-DUE-A         TO    S-BILLED-DUE-A.          
REARCH     MOVE  RS-BILLED-AVOIDLPC-A    TO    S-BILLED-AVOIDLPC-A.     
REARCH     MOVE  RS-FIRST-AMT-B          TO    S-FIRST-AMT-B.           
REARCH     MOVE  RS-FIRST-MAIL-B         TO    S-FIRST-MAIL-B.          
REARCH     MOVE  RS-FIRST-DUE-B          TO    S-FIRST-DUE-B.           
REARCH     MOVE  RS-SECOND-AMT-C         TO    S-SECOND-AMT-C.          
REARCH     MOVE  RS-SECOND-MAIL-C        TO    S-SECOND-MAIL-C.         
REARCH     MOVE  RS-SECOND-DUE-C         TO    S-SECOND-DUE-C.          
REARCH     MOVE  RS-FIELD-DATE-C         TO    S-FIELD-DATE-C.          
REARCH     MOVE  RS-DNP-AMT-D            TO    S-DNP-AMT-D.             
REARCH     MOVE  RS-DNP-DATE-D           TO    S-DNP-DATE-D.            
REARCH     MOVE  RS-FIRST-AMT-E          TO    S-FIRST-AMT-E.           
REARCH     MOVE  RS-FIRST-MAIL-E         TO    S-FIRST-MAIL-E.          
REARCH     MOVE  RS-FIRST-DUE-E          TO    S-FIRST-DUE-E.           
REARCH     MOVE  RS-SECOND-AMT-F         TO    S-SECOND-AMT-F.          
REARCH     MOVE  RS-SECOND-MAIL-F        TO    S-SECOND-MAIL-F.         
REARCH     MOVE  RS-SECOND-DUE-F         TO    S-SECOND-DUE-F.          
REARCH     MOVE  RS-FIELD-DATE-F         TO    S-FIELD-DATE-F.          
REARCH     MOVE  RS-DNP-AMT-G            TO    S-DNP-AMT-G.             
REARCH     MOVE  RS-DNP-DATE-G           TO    S-DNP-DATE-G.            
REARCH     MOVE  RS-AMT-NOTICE-H         TO    S-AMT-NOTICE-H.          
REARCH     MOVE  RS-AVOIDLPC-DATE-H      TO    S-AVOIDLPC-DATE-H.       
REARCH     MOVE  RS-AMT-NOTICE-I         TO    S-AMT-NOTICE-I.          
REARCH     MOVE  RS-AVOIDLPC-DATE-I      TO    S-AVOIDLPC-DATE-I.       
REARCH     MOVE  RS-FIRST-AMT-K          TO    S-FIRST-AMT-K.           
REARCH     MOVE  RS-FIRST-MAIL-K         TO    S-FIRST-MAIL-K.          
REARCH     MOVE  RS-FIRST-DUE-K          TO    S-FIRST-DUE-K.           
REARCH     MOVE  RS-SECOND-AMT-L         TO    S-SECOND-AMT-L.          
REARCH     MOVE  RS-SECOND-MAIL-L        TO    S-SECOND-MAIL-L.         
REARCH     MOVE  RS-CRED-BUREA-DATE-L    TO    S-CRED-BUREA-DATE-L.     
REARCH     MOVE  RS-CRED-BUREA-DATE-M    TO    S-CRED-BUREA-DATE-M.     
REARCH     MOVE  RS-AMT-NOTICE-N         TO    S-AMT-NOTICE-N.          
REARCH     MOVE  RS-NOTICE-MAIL-N        TO    S-NOTICE-MAIL-N.         
REARCH     MOVE  RS-NOTICE-DUE-N         TO    S-NOTICE-DUE-N.          
REARCH     MOVE  RS-AMT-NOTICE-O         TO    S-AMT-NOTICE-O.          
REARCH     MOVE  RS-NOTICE-MAIL-O        TO    S-NOTICE-MAIL-O.         
REARCH     MOVE  RS-NOTICE-DUE-O         TO    S-NOTICE-DUE-O.          
REARCH     MOVE  RS-BILLED-AMT-P         TO    S-BILLED-AMT-P.          
REARCH     MOVE  RS-BILLED-MAIL-P        TO    S-BILLED-MAIL-P.         
REARCH     MOVE  RS-BILLED-DUE-P         TO    S-BILLED-DUE-P.          
REARCH     MOVE  RS-AMT-NOTICE-W         TO    S-AMT-NOTICE-W.          
REARCH     MOVE  RS-BILLED-AMT-Q         TO    S-BILLED-AMT-Q.          
REARCH     MOVE  RS-BILLED-MAIL-Q        TO    S-BILLED-MAIL-Q.         
REARCH     MOVE  RS-BILLED-DUE-Q         TO    S-BILLED-DUE-Q.          
REARCH     MOVE  RS-FIRST-AMT-R          TO    S-FIRST-AMT-R.           
REARCH     MOVE  RS-FIRST-MAIL-R         TO    S-FIRST-MAIL-R.          
REARCH     MOVE  RS-FIRST-DUE-R          TO    S-FIRST-DUE-R.           
REARCH     MOVE  RS-SECOND-AMT-S         TO    S-SECOND-AMT-S.          
REARCH     MOVE  RS-SECOND-MAIL-S        TO    S-SECOND-MAIL-S.         
REARCH     MOVE  RS-SECOND-DUE-S         TO    S-SECOND-DUE-S.          
REARCH     MOVE  RS-FIELD-DATE-S         TO    S-FIELD-DATE-S.          
REARCH     MOVE  RS-NORMAL-AMT-M         TO    S-NORMAL-AMT-M.          
REARCH     MOVE  RS-NORMAL-DATE-M        TO    S-NORMAL-DATE-M.         
REARCH     MOVE  RS-FIRST-AMT-T          TO    S-FIRST-AMT-T.           
REARCH     MOVE  RS-FIRST-MAIL-T         TO    S-FIRST-MAIL-T.          
REARCH     MOVE  RS-FIRST-DUE-T          TO    S-FIRST-DUE-T.           
REARCH     MOVE  RS-SECOND-AMT-U         TO    S-SECOND-AMT-U.          
REARCH     MOVE  RS-SECOND-MAIL-U        TO    S-SECOND-MAIL-U.         
REARCH     MOVE  RS-SECOND-DUE-U         TO    S-SECOND-DUE-U.          
REARCH     MOVE  RS-FIELD-DATE-U         TO    S-FIELD-DATE-U.          
REARCH     MOVE  RS-EXCEPT-AMT-X         TO    S-EXCEPT-AMT-X.          
REARCH     MOVE  RS-EXCEPT-DATE-X        TO    S-EXCEPT-DATE-X.         
REARCH     MOVE  RS-AMT-NOTICE-V         TO    S-AMT-NOTICE-V.          
REARCH     MOVE  0                       TO    S-TOT-BILLED-BAL.        
REARCH     MOVE  SPACES                  TO    S-NEXT-BILL-DATE.        
REARCH     MOVE  SPACES                  TO    S-BILL-CYCLE.            
REARCH     MOVE  0                       TO    S-ITEM-ID.               
REARCH     MOVE  0                       TO    S-UTIL-PAST-DUE.         
REARCH     MOVE  0                       TO    S-UTIL-BILLED-BAL.       
REARCH     MOVE  0                       TO    S-NONUTIL-PAST-DUE.      
REARCH     MOVE  0                       TO    S-NON-UTL-BLLD-BAL.      
REARCH     MOVE  SPACES                  TO    S-DISCONNECT-HIST.       
REARCH     MOVE  SPACES                  TO    S-DISC-EXCEPTN-HST.      
REARCH     MOVE  SPACES                  TO    S-NON-UTL-CR-HIST.       
REARCH     MOVE  SPACES                  TO    S-NON-UTL-CR-HSTEX.      
T32545***  TEMP CHANGES UNTIL OCT 22ND.                                         
T32545     MOVE  RS-IVR-DATE-N           TO    S-IVR-DATE-N.            
T32545     MOVE  RS-IVR-DATE-O           TO    S-IVR-DATE-O.            
P00399     MOVE  RS-MED-CERT-EXP-DT      TO    S-MED-CERT-EXP-DT.       
T32545*    MOVE  SPACES                  TO    S-IVR-DATE-N.                    
T32545*    MOVE  SPACES                  TO    S-IVR-DATE-O.                    
REARCH*                                                                         
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-OUTPUT                                            *        
      *                                                                *        
      *     SET UP THE RESULT SET FROM THE RESULTS OF CPD00068         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-ACCT-NO TO AT-ACCOUNT-NO.                            
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
                                                                        
T9195      IF AT-CREDIT-GROUP = 'M' OR                                  
T9195         AT-CREDIT-GROUP = 'D'                                     
T9197           MOVE 'Y' TO RS-NONUTIL                                  
T9195      ELSE                                                         
T9197           MOVE 'N' TO RS-NONUTIL                                  
           END-IF.                                                      
                                                                        
PCR361* SET CPD00068 SWITCHES THAT ARE NEEDED.                                  
PCR361     MOVE 'Y' TO CALC-BALANCE-SW                                  
PCR361                 LOAD-WS-AMOUNTS-SW                               
PCR361                 CALC-PAST-DUE-SW                                 
PCR361                 CALC-ARREARS-SW.                                 
PCR361*                                                                         
T22359     MOVE PROGRAM-NAME               TO WS-CPD00068-CALLING-PGM.  
REARCH*    MOVE CWS00068-FIELDS            TO WS-CWS68-FIELDS-LK.               
REARCH*    MOVE WS-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT-LK.         
REARCH*    MOVE DCLCSS-ACCOUNT             TO WS-DCLCSS-ACCOUNT-LK.             
REARCH*    MOVE ABEND-FILE                 TO WS-ABEND-FILE-LK.                 
REARCH*    MOVE RS-RETURN-CODE             TO WS-RETURN-CODE-LK.                
T19557     MOVE SPACES                     TO ABEND-FUNCTION .          
T19557     PERFORM 9500-CALL-CPD00068      THRU 9500-EXIT.              
REARCH*    MOVE WS-CWS68-FIELDS-LK         TO CWS00068-FIELDS                   
REARCH*    MOVE WS-ABEND-FILE-LK           TO ABEND-FILE                        
REARCH*    MOVE WS-DCLCSS-ACCOUNT-LK       TO DCLCSS-ACCOUNT                    
REARCH*    MOVE WS-CODES-DATA-PRESENT-LK   TO WS-CODES-DATA-PRESENT             
REARCH*    MOVE WS-RETURN-CODE-LK          TO RS-RETURN-CODE                    
REARCH*AS THIS IS BEING DONE IN 9500-CALL PARA I HAVE COMMENTED THIS.           
T19557*    MOVE RS-RETURN-CODE             TO WS-ACTIVE-RETURN-CODE,            
T19557*                                       SQLCODE.                          
T19557*    IF ABEND-FUNCTION  > SPACES                                          
T19557*       PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT                       
T19557*    END-IF.                                                              
                                                                        
      ****************************************************************          
      *                                                                         
      *     SET CREDIT GROUP ID CODE.                                           
      *                                                                         
      ****************************************************************          
           EVALUATE TRUE                                                
T12913        WHEN WS-CODE-MEDICAL = 'A'                                
T12913             MOVE WS-MEDICAL TO RS-CREDIT-GROUP-ID                
P00399             PERFORM 7100-MEDICAL-CERT-EXP-DATE                   
P00399                                             THRU 7100-EXIT       
P00399             MOVE CA-DATE-EXPIRE TO RS-MED-CERT-EXP-DT            
              WHEN AT-CODE-MAJOR-ACCT = 'Y'                             
                   MOVE WS-MAJOR TO RS-CREDIT-GROUP-ID                  
P00453        WHEN WS-CODE-PRE-PAY-PLAN = 'A'                           
P00453             MOVE WS-PRP TO RS-CREDIT-GROUP-ID                    
              WHEN WS-CODE-BUDGET = 'A'                                 
C36956             MOVE WS-BBP TO RS-CREDIT-GROUP-ID                    
              WHEN AT-CT-METER-RATED-IND = 'Y'                          
                   MOVE WS-CT-RATED TO RS-CREDIT-GROUP-ID               
              WHEN WS-CODE-DPP-ACCT = 'A'                               
                   MOVE WS-DPP TO RS-CREDIT-GROUP-ID                    
           END-EVALUATE.                                                
                                                                        
P00599     MOVE SPACES                     TO YP-ATTRIBUTE-VALUE-CD.    
P00599     MOVE AT-ACCOUNT-NO              TO YP-ACCOUNT-NO.            
P00599     MOVE 'FCST CR GP BALANCE'       TO YP-ATTRIBUTE-DESC.        
P00599     PERFORM 7200-FORECAST-CREDIT-GROUP     THRU 7200-EXIT.       
P00599     MOVE YP-ATTRIBUTE-VALUE-CD      TO RS-FRCST-CR-GRP.          
                                                                        
TP5309     IF WS-CODE-SPECIAL-TYPE-E > SPACES                           
TP5309        MOVE WS-CODE-SPECIAL-TYPE-E  TO RS-SPECIAL-TYPE           
TP5309     ELSE                                                         
TP5309        IF WS-CODE-SPECIAL-TYPE-F > SPACES                        
TP5309           MOVE WS-CODE-SPECIAL-TYPE-F TO RS-SPECIAL-TYPE         
TP5309        ELSE                                                      
TP5309           MOVE WS-CODE-SPECIAL-TYPE-G TO RS-SPECIAL-TYPE         
TP5309        END-IF                                                    
TP5309     END-IF.                                                      
                                                                        
           MOVE WS-AMT-PAST-DUE            TO RS-AMT-PAST-DUE.          
           MOVE AT-CREDIT-GROUP            TO RS-CREDIT-GROUP.          
                                                                        
TP5309     MOVE WS-DAY-SPECIAL-DNP-1       TO WS-CONVERT-DELINQ.        
TP5309     MOVE WS-CONVERT-DELINQ          TO RS-DAY-SPECIALDNP1.       
TP5309     MOVE ZEROES                     TO WS-CONVERT-DELINQ.        
                                                                        
TP5309     MOVE WS-DAY-SPECIAL-DNP-2       TO WS-CONVERT-DELINQ.        
TP5309     MOVE WS-CONVERT-DELINQ          TO RS-DAY-SPECIALDNP2.       
TP5309     MOVE ZEROES                     TO WS-CONVERT-DELINQ.        
                                                                        
TP5309     MOVE WS-SPECIAL-DNP-LIMIT       TO WS-CONVERT-DELINQ.        
TP5309     MOVE WS-CONVERT-DELINQ          TO RS-AMT-SPECIALDNPLIM.     
                                                                        
TP5309* ONLY RETRIEVE NEXT BILL DATE FOR ACTIVE ACCOUNTS                        
                                                                        
TP5309     IF AT-CODE-ACCT-STAT = 'A'                                   
TP5309        MOVE AT-ACCOUNT-NO              TO UT-ACCOUNT-NO          
T10167        PERFORM 5901-NEXT-READ-DATE                               
T10167           THRU 5901-NEXT-READ-DATE-EXIT                          
TP5309        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
T28824           IF RW-THIRD-PTY-READ-DT > SPACES                       
T28824              MOVE RW-THIRD-PTY-READ-DT TO WS-DATE-CCYY-MM-DD     
T28824           ELSE                                                   
TP5309              MOVE RW-OPTIMUM-READ-DATE TO WS-DATE-CCYY-MM-DD     
T28824           END-IF                                                 
TP5309           MOVE WS-DATE-CCYY            TO WS-DATE2-CCYY          
TP5309           MOVE WS-DATE-MM              TO WS-DATE2-MM            
TP5309           MOVE WS-DATE-DD              TO WS-DATE2-DD            
TP5309           MOVE WS-DATE-MM-DD-YYYY      TO RS-NEXT-READ-DATE      
TP5309        ELSE                                                      
TP5309           MOVE SPACES                  TO RS-NEXT-READ-DATE      
TP5309        END-IF                                                    
TP5309     ELSE                                                         
TP5309        MOVE SPACES                     TO RS-NEXT-READ-DATE      
TP5309     END-IF.                                                      
                                                                        
           PERFORM 2500-PROCESS-CPD68 THRU 2500-EXIT.                   
                                                                        
           IF CTR-ROWS = ZERO                                           
               MOVE NOT-FOUND TO RS-RETURN-CODE                         
REARCH         PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
REARCH         ADD 1 TO CTR-ROWS                                        
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 2500-PROCESS-CPD68                                             *        
      *                                                                *        
      *     FORMAT & SEND RESULT SET. IF THE DATE IS GOING TO BE       *        
      *     DISPLAY ONLY ON THE SCREEN AND IT DOES NOT EQUAL SPACES    *        
      *     FORMAT IT IN DD/MM/CCYY FORMAT.  IF IT EQUALS SPACES JUST  *        
      *     RETURN SPACES.  IF IT IS UPDATEABLE SEND IT BACK IN        *        
      *     MMDDYYYY FORMAT AND LET PB FORMAT THE DATE.                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2500-PROCESS-CPD68.                                              
                                                                        
           IF WS-DATE-NOTICE-MAIL-A = SPACES                            
              MOVE SPACES                TO RS-BILLED-MAIL-A            
           ELSE                                                         
              MOVE WS-DATE-NOTICE-MAIL-A    TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-BILLED-MAIL-A         
           END-IF.                                                      
                                                                        
           IF WS-DATE-NOTICE-DUE-A = SPACES                             
              MOVE WS-DATE-NOTICE-DUE-A     TO RS-BILLED-DUE-A          
           ELSE                                                         
              MOVE WS-DATE-NOTICE-DUE-A     TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-BILLED-DUE-A          
           END-IF.                                                      
                                                                        
           IF WS-DATE-CREDIT-ACTION-A = SPACES                          
              MOVE WS-DATE-CREDIT-ACTION-A  TO RS-BILLED-AVOIDLPC-A     
           ELSE                                                         
              MOVE WS-DATE-CREDIT-ACTION-A  TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-BILLED-AVOIDLPC-A     
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-A             TO RS-BILLED-AMT-A.         
                                                                        
           IF WS-DATE-NOTICE-MAIL-B = SPACES                            
              MOVE WS-DATE-NOTICE-MAIL-B    TO RS-FIRST-MAIL-B          
           ELSE                                                         
              MOVE WS-DATE-NOTICE-MAIL-B    TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-FIRST-MAIL-B          
           END-IF.                                                      
                                                                        
           IF WS-DATE-NOTICE-DUE-B = SPACES                             
              MOVE WS-DATE-NOTICE-DUE-B     TO RS-FIRST-DUE-B           
           ELSE                                                         
              MOVE WS-DATE-NOTICE-DUE-B     TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-FIRST-DUE-B           
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-B          TO RS-FIRST-AMT-B              
                                                                        
           IF WS-DATE-NOTICE-MAIL-C = SPACES                            
              MOVE WS-DATE-NOTICE-MAIL-C TO RS-SECOND-MAIL-C            
           ELSE                                                         
              MOVE WS-DATE-NOTICE-MAIL-C    TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-SECOND-MAIL-C         
           END-IF.                                                      
                                                                        
           IF WS-DATE-NOTICE-DUE-C = SPACES                             
              MOVE WS-DATE-NOTICE-DUE-C     TO RS-SECOND-DUE-C          
           ELSE                                                         
              MOVE WS-DATE-NOTICE-DUE-C     TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-SECOND-DUE-C          
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-C             TO RS-SECOND-AMT-C.         
                                                                        
C23235     IF WS-DATE-CREDIT-ACTION-C = SPACES                          
C23235        MOVE WS-DATE-CREDIT-ACTION-C  TO RS-FIELD-DATE-C          
C23235     ELSE                                                         
C23235        MOVE WS-DATE-CREDIT-ACTION-C  TO WS-DATE-CCYY-MM-DD       
C23235        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
C23235        MOVE WS-DATE-MM               TO WS-DATE2-MM              
C23235        MOVE WS-DATE-DD               TO WS-DATE2-DD              
C23235        MOVE WS-DATE-MM-DD-YYYY       TO RS-FIELD-DATE-C          
C23235     END-IF.                                                      
                                                                        
           IF WS-DATE-CREDIT-ACTION-D = SPACES                          
              MOVE WS-DATE-CREDIT-ACTION-D  TO RS-DNP-DATE-D            
           ELSE                                                         
              MOVE WS-DATE-CREDIT-ACTION-D  TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-DNP-DATE-D            
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-D             TO RS-DNP-AMT-D.            
                                                                        
           IF WS-DATE-NOTICE-MAIL-E = SPACES OR LOW-VALUES              
              MOVE '00000000'               TO RS-FIRST-MAIL-E          
           ELSE                                                         
              MOVE WS-DATE-NOTICE-MAIL-E    TO WS-DATE-CCYY-MM-DD       
              STRING WS-DATE-MM    DELIMITED BY ' '                     
                     WS-DATE-DD    DELIMITED BY ' '                     
                     WS-DATE-CCYY  DELIMITED BY ' '                     
                     INTO RS-FIRST-MAIL-E                               
           END-IF.                                                      
                                                                        
           IF WS-DATE-NOTICE-DUE-E = SPACES OR LOW-VALUES               
              MOVE '00000000'               TO RS-FIRST-DUE-E           
           ELSE                                                         
              MOVE WS-DATE-NOTICE-DUE-E     TO WS-DATE-CCYY-MM-DD       
              STRING WS-DATE-MM    DELIMITED BY ' '                     
                     WS-DATE-DD    DELIMITED BY ' '                     
                     WS-DATE-CCYY  DELIMITED BY ' '                     
                     INTO RS-FIRST-DUE-E                                
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-E             TO RS-FIRST-AMT-E.          
                                                                        
           IF WS-DATE-NOTICE-MAIL-F = SPACES OR LOW-VALUES              
              MOVE '00000000'               TO RS-SECOND-MAIL-F         
           ELSE                                                         
              MOVE WS-DATE-NOTICE-MAIL-F    TO WS-DATE-CCYY-MM-DD       
              STRING WS-DATE-MM    DELIMITED BY ' '                     
                     WS-DATE-DD    DELIMITED BY ' '                     
                     WS-DATE-CCYY  DELIMITED BY ' '                     
                     INTO RS-SECOND-MAIL-F                              
           END-IF.                                                      
                                                                        
           IF WS-DATE-NOTICE-DUE-F = SPACES OR LOW-VALUES               
              MOVE '00000000'               TO RS-SECOND-DUE-F          
           ELSE                                                         
              MOVE WS-DATE-NOTICE-DUE-F     TO WS-DATE-CCYY-MM-DD       
              STRING WS-DATE-MM    DELIMITED BY ' '                     
                     WS-DATE-DD    DELIMITED BY ' '                     
                     WS-DATE-CCYY  DELIMITED BY ' '                     
                     INTO RS-SECOND-DUE-F                               
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-F             TO RS-SECOND-AMT-F.         
                                                                        
C23235     IF WS-DATE-CREDIT-ACTION-F = SPACES                          
C23235        MOVE '00000000'               TO RS-FIELD-DATE-F          
C23235     ELSE                                                         
C23235        MOVE WS-DATE-CREDIT-ACTION-F  TO WS-DATE-CCYY-MM-DD       
C23235        STRING WS-DATE-MM    DELIMITED BY ' '                     
C23235               WS-DATE-DD    DELIMITED BY ' '                     
C23235               WS-DATE-CCYY  DELIMITED BY ' '                     
C23235               INTO RS-FIELD-DATE-F                               
C23235     END-IF.                                                      
                                                                        
           IF WS-DATE-CREDIT-ACTION-G = SPACES OR LOW-VALUES            
              MOVE '00000000'               TO RS-DNP-DATE-G            
           ELSE                                                         
              MOVE WS-DATE-CREDIT-ACTION-G  TO WS-DATE-CCYY-MM-DD       
              STRING WS-DATE-MM    DELIMITED BY ' '                     
                     WS-DATE-DD    DELIMITED BY ' '                     
                     WS-DATE-CCYY  DELIMITED BY ' '                     
                     INTO RS-DNP-DATE-G                                 
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-G             TO RS-DNP-AMT-G.            
                                                                        
           IF WS-DATE-CREDIT-ACTION-H = SPACES                          
              MOVE WS-DATE-CREDIT-ACTION-H  TO RS-AVOIDLPC-DATE-H       
           ELSE                                                         
              MOVE WS-DATE-CREDIT-ACTION-H  TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-AVOIDLPC-DATE-H       
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-H             TO RS-AMT-NOTICE-H.         
                                                                        
           IF WS-DATE-CREDIT-ACTION-I = SPACES                          
              MOVE WS-DATE-CREDIT-ACTION-I  TO RS-AVOIDLPC-DATE-I       
           ELSE                                                         
              MOVE WS-DATE-CREDIT-ACTION-I  TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-AVOIDLPC-DATE-I       
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-NOTICE-I             TO RS-AMT-NOTICE-I.         
                                                                        
           IF WS-DATE-NOTICE-MAIL-K = SPACES                            
              MOVE WS-DATE-NOTICE-MAIL-K    TO RS-FIRST-MAIL-K          
           ELSE                                                         
TP8404        MOVE WS-DATE-NOTICE-MAIL-K    TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-FIRST-MAIL-K          
           END-IF.                                                      
                                                                        
           IF WS-DATE-NOTICE-DUE-K = SPACES                             
              MOVE WS-DATE-NOTICE-DUE-K     TO RS-FIRST-DUE-K           
           ELSE                                                         
TP8404        MOVE WS-DATE-NOTICE-DUE-K     TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-FIRST-DUE-K           
           END-IF.                                                      
                                                                        
TP8404     MOVE WS-AMT-NOTICE-K             TO RS-FIRST-AMT-K.          
TP8404                                                                  
TP8404     IF WS-DATE-NOTICE-MAIL-L = SPACES                            
              MOVE WS-DATE-NOTICE-MAIL-L    TO RS-SECOND-MAIL-L         
           ELSE                                                         
TP8404        MOVE WS-DATE-NOTICE-MAIL-L    TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-SECOND-MAIL-L         
           END-IF.                                                      
                                                                        
           IF WS-DATE-CREDIT-ACTION-L = SPACES                          
              MOVE WS-DATE-CREDIT-ACTION-L  TO RS-CRED-BUREA-DATE-L     
           ELSE                                                         
TP8404        MOVE WS-DATE-CREDIT-ACTION-L  TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-CRED-BUREA-DATE-L     
           END-IF.                                                      
                                                                        
TP8404     MOVE WS-AMT-NOTICE-L             TO RS-SECOND-AMT-L.         
                                                                        
NONUTL     IF WS-DATE-CREDIT-ACTION-M = SPACES                          
NONUTL        MOVE WS-DATE-CREDIT-ACTION-M  TO RS-CRED-BUREA-DATE-M     
NONUTL     ELSE                                                         
NONUTL        MOVE WS-DATE-CREDIT-ACTION-M  TO WS-DATE-CCYY-MM-DD       
NONUTL        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
NONUTL        MOVE WS-DATE-MM               TO WS-DATE2-MM              
NONUTL        MOVE WS-DATE-DD               TO WS-DATE2-DD              
NONUTL        MOVE WS-DATE-MM-DD-YYYY       TO RS-CRED-BUREA-DATE-M     
NONUTL     END-IF.                                                      
                                                                        
T32545     IF WS-DATE-CREDIT-ACTION-N = SPACES                          
T32545        MOVE WS-DATE-CREDIT-ACTION-N  TO RS-IVR-DATE-N            
T32545     ELSE                                                         
T32545        MOVE WS-DATE-CREDIT-ACTION-N  TO WS-DATE-CCYY-MM-DD       
T32545        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T32545        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T32545        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T32545        MOVE WS-DATE-MM-DD-YYYY       TO RS-IVR-DATE-N            
T32545     END-IF.                                                      
                                                                        
           IF WS-DATE-NOTICE-MAIL-N = SPACES OR                         
              WS-NUMBER-OF-CHECKS  > 1                                  
              MOVE SPACES                   TO RS-NOTICE-MAIL-N         
           ELSE                                                         
PCR263        MOVE WS-DATE-NOTICE-MAIL-N    TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-NOTICE-MAIL-N         
           END-IF.                                                      
                                                                        
           IF WS-DATE-NOTICE-DUE-N = SPACES                             
              MOVE WS-DATE-NOTICE-DUE-N     TO RS-NOTICE-DUE-N          
           ELSE                                                         
PCR263        MOVE WS-DATE-NOTICE-DUE-N     TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-NOTICE-DUE-N          
           END-IF.                                                      
                                                                        
PCR263     MOVE WS-AMT-NOTICE-N             TO RS-AMT-NOTICE-N.         
                                                                        
           IF WS-DATE-NOTICE-MAIL-O = SPACES                            
              MOVE WS-DATE-NOTICE-MAIL-O    TO RS-NOTICE-MAIL-O         
           ELSE                                                         
PCR263        MOVE WS-DATE-NOTICE-MAIL-O    TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-NOTICE-MAIL-O         
           END-IF.                                                      
                                                                        
           IF WS-DATE-NOTICE-DUE-O = SPACES                             
              MOVE WS-DATE-NOTICE-DUE-O     TO RS-NOTICE-DUE-O          
           ELSE                                                         
PCR263        MOVE WS-DATE-NOTICE-DUE-O     TO WS-DATE-CCYY-MM-DD       
              MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
              MOVE WS-DATE-MM               TO WS-DATE2-MM              
              MOVE WS-DATE-DD               TO WS-DATE2-DD              
              MOVE WS-DATE-MM-DD-YYYY       TO RS-NOTICE-DUE-O          
           END-IF.                                                      
                                                                        
PCR263     MOVE WS-AMT-NOTICE-O             TO RS-AMT-NOTICE-O.         
                                                                        
T32545     IF WS-DATE-CREDIT-ACTION-O = SPACES                          
T32545        MOVE WS-DATE-CREDIT-ACTION-O  TO RS-IVR-DATE-O            
T32545     ELSE                                                         
T32545        MOVE WS-DATE-CREDIT-ACTION-O  TO WS-DATE-CCYY-MM-DD       
T32545        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T32545        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T32545        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T32545        MOVE WS-DATE-MM-DD-YYYY       TO RS-IVR-DATE-O            
T32545     END-IF.                                                      
                                                                        
T21919     IF WS-DATE-NOTICE-MAIL-P = SPACES                            
T21919        MOVE SPACES                TO RS-BILLED-MAIL-P            
T21919     ELSE                                                         
T21919        MOVE WS-DATE-NOTICE-MAIL-P    TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-BILLED-MAIL-P         
T21919     END-IF.                                                      
T21919                                                                  
T21919     IF WS-DATE-NOTICE-DUE-P = SPACES                             
T21919        MOVE WS-DATE-NOTICE-DUE-P     TO RS-BILLED-DUE-P          
T21919     ELSE                                                         
T21919        MOVE WS-DATE-NOTICE-DUE-P     TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-BILLED-DUE-P          
T21919     END-IF.                                                      
T21919                                                                  
T21919     MOVE WS-AMT-NOTICE-P             TO RS-BILLED-AMT-P.         
T21919                                                                  
T21919     MOVE WS-AMT-NOTICE-W             TO RS-AMT-NOTICE-W.         
T21919                                                                  
T21919     IF WS-DATE-NOTICE-MAIL-Q = SPACES                            
T21919        MOVE SPACES                TO RS-BILLED-MAIL-Q            
T21919     ELSE                                                         
T21919        MOVE WS-DATE-NOTICE-MAIL-Q    TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-BILLED-MAIL-Q         
T21919     END-IF.                                                      
T21919                                                                  
T21919     IF WS-DATE-NOTICE-DUE-Q = SPACES                             
T21919        MOVE WS-DATE-NOTICE-DUE-Q     TO RS-BILLED-DUE-Q          
T21919     ELSE                                                         
T21919        MOVE WS-DATE-NOTICE-DUE-Q     TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-BILLED-DUE-Q          
T21919     END-IF.                                                      
T21919                                                                  
T21919     MOVE WS-AMT-NOTICE-Q             TO RS-BILLED-AMT-Q.         
T21919                                                                  
T21919     IF WS-DATE-NOTICE-MAIL-R = SPACES                            
T21919        MOVE SPACES                TO RS-FIRST-MAIL-R             
T21919     ELSE                                                         
T21919        MOVE WS-DATE-NOTICE-MAIL-R    TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-FIRST-MAIL-R          
T21919     END-IF.                                                      
T21919                                                                  
T21919     IF WS-DATE-NOTICE-DUE-R = SPACES                             
T21919        MOVE WS-DATE-NOTICE-DUE-R     TO RS-FIRST-DUE-R           
T21919     ELSE                                                         
T21919        MOVE WS-DATE-NOTICE-DUE-R     TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-FIRST-DUE-R           
T21919     END-IF.                                                      
T21919                                                                  
T21919     MOVE WS-AMT-NOTICE-R             TO RS-FIRST-AMT-R.          
T21919                                                                  
T21919     IF WS-DATE-NOTICE-MAIL-S = SPACES                            
T21919        MOVE SPACES                TO RS-SECOND-MAIL-S            
T21919     ELSE                                                         
T21919        MOVE WS-DATE-NOTICE-MAIL-S    TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-SECOND-MAIL-S         
T21919     END-IF.                                                      
T21919                                                                  
T21919     IF WS-DATE-NOTICE-DUE-S = SPACES                             
T21919        MOVE WS-DATE-NOTICE-DUE-S     TO RS-SECOND-DUE-S          
T21919     ELSE                                                         
T21919        MOVE WS-DATE-NOTICE-DUE-S     TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-SECOND-DUE-S          
T21919     END-IF.                                                      
T21919                                                                  
T21919     MOVE WS-AMT-NOTICE-S             TO RS-SECOND-AMT-S.         
                                                                        
C23235     IF WS-DATE-CREDIT-ACTION-S = SPACES                          
C23235        MOVE WS-DATE-CREDIT-ACTION-S  TO RS-FIELD-DATE-S          
C23235     ELSE                                                         
C23235        MOVE WS-DATE-CREDIT-ACTION-S  TO WS-DATE-CCYY-MM-DD       
C23235        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
C23235        MOVE WS-DATE-MM               TO WS-DATE2-MM              
C23235        MOVE WS-DATE-DD               TO WS-DATE2-DD              
C23235        MOVE WS-DATE-MM-DD-YYYY       TO RS-FIELD-DATE-S          
C23235     END-IF.                                                      
                                                                        
T21919     IF WS-DATE-CREDIT-ACTION-M = SPACES                          
T21919        MOVE WS-DATE-CREDIT-ACTION-M  TO RS-NORMAL-DATE-M         
T21919     ELSE                                                         
T21919        MOVE WS-DATE-CREDIT-ACTION-M  TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-NORMAL-DATE-M         
T21919     END-IF.                                                      
T21919                                                                  
T21919     MOVE WS-AMT-NOTICE-M             TO RS-NORMAL-AMT-M.         
T21919                                                                  
T21919     IF WS-DATE-NOTICE-MAIL-T = SPACES                            
T21919        MOVE SPACES                TO RS-FIRST-MAIL-T             
T21919     ELSE                                                         
T21919        MOVE WS-DATE-NOTICE-MAIL-T    TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-FIRST-MAIL-T          
T21919     END-IF.                                                      
T21919                                                                  
T21919     IF WS-DATE-NOTICE-DUE-T = SPACES                             
T21919        MOVE WS-DATE-NOTICE-DUE-T     TO RS-FIRST-DUE-T           
T21919     ELSE                                                         
T21919        MOVE WS-DATE-NOTICE-DUE-T     TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-FIRST-DUE-T           
T21919     END-IF.                                                      
T21919                                                                  
T21919     MOVE WS-AMT-NOTICE-T             TO RS-FIRST-AMT-T.          
T21919                                                                  
T21919     IF WS-DATE-NOTICE-MAIL-U = SPACES                            
T21919        MOVE SPACES                TO RS-SECOND-MAIL-U            
T21919     ELSE                                                         
T21919        MOVE WS-DATE-NOTICE-MAIL-U    TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-SECOND-MAIL-U         
T21919     END-IF.                                                      
T21919                                                                  
T21919     IF WS-DATE-NOTICE-DUE-U = SPACES                             
T21919        MOVE WS-DATE-NOTICE-DUE-U     TO RS-SECOND-DUE-U          
T21919     ELSE                                                         
T21919        MOVE WS-DATE-NOTICE-DUE-U     TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-SECOND-DUE-U          
T21919     END-IF.                                                      
T21919                                                                  
T21919     MOVE WS-AMT-NOTICE-U             TO RS-SECOND-AMT-U.         
                                                                        
C23235     IF WS-DATE-CREDIT-ACTION-U = SPACES                          
C23235        MOVE WS-DATE-CREDIT-ACTION-U  TO RS-FIELD-DATE-U          
C23235     ELSE                                                         
C23235        MOVE WS-DATE-CREDIT-ACTION-U  TO WS-DATE-CCYY-MM-DD       
C23235        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
C23235        MOVE WS-DATE-MM               TO WS-DATE2-MM              
C23235        MOVE WS-DATE-DD               TO WS-DATE2-DD              
C23235        MOVE WS-DATE-MM-DD-YYYY       TO RS-FIELD-DATE-U          
C23235     END-IF.                                                      
                                                                        
T21919     IF WS-DATE-CREDIT-ACTION-X = SPACES                          
T21919        MOVE WS-DATE-CREDIT-ACTION-X  TO RS-EXCEPT-DATE-X         
T21919     ELSE                                                         
T21919        MOVE WS-DATE-CREDIT-ACTION-X  TO WS-DATE-CCYY-MM-DD       
T21919        MOVE WS-DATE-CCYY             TO WS-DATE2-CCYY            
T21919        MOVE WS-DATE-MM               TO WS-DATE2-MM              
T21919        MOVE WS-DATE-DD               TO WS-DATE2-DD              
T21919        MOVE WS-DATE-MM-DD-YYYY       TO RS-EXCEPT-DATE-X         
T21919     END-IF.                                                      
T21919                                                                  
T21919     MOVE WS-AMT-NOTICE-X             TO RS-EXCEPT-AMT-X.         
T21919                                                                  
T21919     MOVE WS-AMT-NOTICE-V             TO RS-AMT-NOTICE-V.         
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                    
REARCH     ADD 1 TO CTR-ROWS.                                           
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
                                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00310                                                  
           END-EXEC.                                                            
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
      ******************************************************************        
      * 7000-SELECT-ACCOUNT                                            *        
      *                                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     SELECTS A ROW FROM THE TABLE CSS_ACCOUNT                   *        
      ******************************************************************        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7000'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT AT.CODES_DATA_PRESENT,                             
                     AT.CREDIT_GROUP,                                   
                     AT.TOTAL_AR_BALANCE,                               
                     AT.MST_SUB_ACCT_IND,                               
                     AT.CODE_MAJOR_ACCT,                                
                     AT.CT_METER_RATED_IND,                             
PCR361               AT.COMPANY_NO,                                     
PCR361               AT.LOCAL_OFFICE,                                   
PCR361               AT.BANKRUPTCY_IND,                                 
TP5309               AT.CODE_ACCT_STAT,                                 
PCR361               AT.DATE_BILL_DAY_00,                               
                     AT.DATE_BILL_DAY_30,                               
                     AT.DATE_BILL_DAY_60,                               
                     AT.DATE_BILL_DAY_90,                               
                     AT.CODE_DISC_OK,                                   
                     AT.NOTICE_EXEMPT_CD,                               
T13292               AT.BILL_CYCLE,                                     
C28788               AT.IVR_EXEMPT_CD                                   
              INTO  :AT-CODES-DATA-PRESENT,                             
                    :AT-CREDIT-GROUP,                                   
                    :AT-TOTAL-AR-BALANCE,                               
                    :AT-MST-SUB-ACCT-IND,                               
                    :AT-CODE-MAJOR-ACCT,                                
                    :AT-CT-METER-RATED-IND,                             
PCR361              :AT-COMPANY-NO,                                     
PCR361              :AT-LOCAL-OFFICE,                                   
PCR361              :AT-BANKRUPTCY-IND,                                 
TP5309              :AT-CODE-ACCT-STAT,                                 
T8726               :AT-DATE-BILL-DAY-00 :WS-NULL-1,                     
T8726               :AT-DATE-BILL-DAY-30 :WS-NULL-2,                     
T8726               :AT-DATE-BILL-DAY-60 :WS-NULL-3,                     
T8726               :AT-DATE-BILL-DAY-90 :WS-NULL-4,                     
                    :AT-CODE-DISC-OK,                                   
                    :AT-NOTICE-EXEMPT-CD,                               
T13292              :AT-BILL-CYCLE,                                     
C28788              :AT-IVR-EXEMPT-CD                                   
              FROM  CSS_ACCOUNT AT                                      
              WHERE  AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T8726         IF WS-NULL-1 = -1                                         
T8726             MOVE SPACES TO AT-DATE-BILL-DAY-00                    
T8726         END-IF                                                    
T8726         IF WS-NULL-2 = -1                                         
T8726             MOVE SPACES TO AT-DATE-BILL-DAY-30                    
T8726         END-IF                                                    
T8726         IF WS-NULL-3 = -1                                         
T8726             MOVE SPACES TO AT-DATE-BILL-DAY-60                    
T8726         END-IF                                                    
T8726         IF WS-NULL-4 = -1                                         
T8726             MOVE SPACES TO AT-DATE-BILL-DAY-90                    
T8726         END-IF                                                    
T12596        IF AT-CODE-DISC-OK = LOW-VALUES                           
                  MOVE SPACES      TO AT-CODE-DISC-OK                   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
                                                                        
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00399************************************************************      26586700
P00399* 7100-MEDICAL-CERT-EXP-DATE                               *      26586800
P00399*     SELECTS EXPIRATION DATE FOR THE MEDICAL CERTIFICATE  *      26586900
P00399*     FROM CSS_CUST_ALERT TABLE.                           *      26587000
P00399************************************************************      26587200
P00399*                                                                 26587300
P00399 7100-MEDICAL-CERT-EXP-DATE.                                      
P00399*                                                                 26587300
P00399     EXEC SQL                                                     
P00399        SELECT COALESCE(DATE_EXPIRE, IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))                  
P00399        INTO   :CA-DATE-EXPIRE                                    
P00399        FROM   CSS_CUST_ALERT WITH(READUNCOMMITTED)                       
P00399        WHERE  ACCOUNT_NO   = :AT-ACCOUNT-NO                      
P00399        AND    DATE_EXPIRE >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                    
P00399                                                           
P00399                                                      
P00399     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     26587500
MFA-TR*       SELECT IFNULL(DATE_EXPIRE, '1900-01-01')                  26587600
MFA-TR*       INTO   :CA-DATE-EXPIRE                                    26587700
MFA-TR*       FROM   CSS_CUST_ALERT                                     26587800
MFA-TR*       WHERE  ACCOUNT_NO   = :AT-ACCOUNT-NO                      26587900
MFA-TR*       AND    DATE_EXPIRE >= :WS-CURRENT-DATE                    26588000
MFA-TR*       WITH UR                                                   26588000
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                    26589000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00399*                                                                 26587300
P00399     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00399*                                                                         
P00399     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
P00399         IF CA-DATE-EXPIRE = '1900-01-01'                         
P00399            MOVE SPACES            TO CA-DATE-EXPIRE              
P00399         END-IF                                                   
P00399     ELSE                                                         
P00399         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00399         MOVE '7100'               TO ACTIVE-PARAGRAPH            
P00399         MOVE 'SELECT'             TO ABEND-FUNCTION              
P00399         MOVE SPACES               TO ABEND-SQL-PREDICATES        
P00399                                      ABEND-TABLES                
P00399         MOVE 'CSS_CUST_ALERT'     TO TABLE-1                     
P00399         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
P00399         MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
P00399         MOVE 'DATE_EXPIRE'        TO TABLE-ELEMENT-2             
P00399         MOVE WS-CURRENT-DATE      TO HOSTVAR-ELEMENT-2           
P00399         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P00399     END-IF.                                                      
P00399*                                                                 26590400
P00399 7100-EXIT.                                                       
P00399     EXIT.                                                        
P00399*                                                                 26590700
P00599************************************************************      26586700
P00599* 7200-FORECAST-CREDIT-GROUP                               *      26586800
P00599*     Selects forecasted credit group for the account      *      26586900
P00599*     FROM CSS_ACCT_ATTRIBUTE table.                       *      26587000
P00599************************************************************      26587200
P00599*                                                                 26587300
P00599 7200-FORECAST-CREDIT-GROUP.                                      
P00599*                                                                 26587300
P00599     EXEC SQL                                                     
P00599         SELECT  ATTRIBUTE_VALUE_CD                               
P00599           INTO  :YP-ATTRIBUTE-VALUE-CD                           
P00599           FROM  CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                 
P00599         WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                    
P00599           AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                
P00599           AND STATUS_CD      = 'A'                               
P00599                                                           
P00599                                                      
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  ATTRIBUTE_VALUE_CD                                       
MFA-TR*          INTO  :YP-ATTRIBUTE-VALUE-CD                                   
MFA-TR*          FROM  CSS_ACCT_ATTRIBUTE                                       
MFA-TR*        WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                            
MFA-TR*          AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                        
MFA-TR*          AND STATUS_CD      = 'A'                                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                 26587300
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599*                                                                         
P00599     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
P00599         NEXT SENTENCE                                            
P00599     ELSE                                                         
P00599         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00599         MOVE '7200'               TO ACTIVE-PARAGRAPH            
P00599         MOVE 'SELECT'             TO ABEND-FUNCTION              
P00599         MOVE SPACES               TO ABEND-SQL-PREDICATES        
P00599                                      ABEND-TABLES                
P00599         MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                     
P00599         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
P00599         MOVE YP-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
P00599         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
P00599     END-IF.                                                      
P00599*                                                                 26590400
P00599 7200-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                 26590700
      *                                                                         
T19557 9500-CALL-CPD00068.                                              
T19557                                                                  
REARCH     CALL MCSCB068  USING  CWS00068-FIELDS                        
REARCH                           WS-CODES-DATA-PRESENT                  
REARCH                           DCLCSS-ACCOUNT                         
REARCH                           ABEND-FILE                             
REARCH                           RS-RETURN-CODE.                        
REARCH     MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
REARCH                                       S-RETURN-CODE,             
REARCH                                       SQLCODE.                   
REARCH     IF ABEND-FUNCTION  > SPACES                                  
REARCH        IF ABEND-FUNCTION EQUAL 'BADDATA'                         
REARCH           MOVE -1                  TO S-RETURN-CODE,             
REARCH                                       WS-ACTIVE-RETURN-CODE      
REARCH        END-IF                                                    
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
REARCH        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
REARCH     END-IF.                                                      
REARCH                                                                  
T19557                                                                  
T19557 9500-EXIT.                                                       
T19557     EXIT.                                                        
PCR361******************************************************************        
PCR361* 9700-PROCESS-ABEND - COMBINED ERROR HANDLING INCLUDE           *        
PCR361******************************************************************        
PCR361     EXEC SQL                                                             
PCR361        INCLUDE CPD0023C                                                  
PCR361     END-EXEC.                                                            
PCR361                                                                  
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
      ******************************************************************        
      *       JULIAN DATE CONVERSION                                   *        
      ******************************************************************        
      *    COPY CPD00011.                                                       
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
