       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02022.                                     
COB303 DATE-WRITTEN.      MAY 16, 2005.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S022                                           *00120000
      *  PROGRAM:       S022                                           *00130000
      *  CALLING SP:    PA_S022                                        *00140000
      *  PANEL:         057 -- SECURITIES                              *00150000
      *                                                                *00160000
      ******************************************************************00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROCEDURE RETRIEVES SECURITIES SUMMARY INFORMATION. THIS *00200000
      *  INVOLVES RETRIEVING SUMMARY INFORMATION ON CASH DEPOSITS,     *00210000
      *  GUARANTORS, SURETY BONDS, IRREVOCABLE LETTERS OF CREDIT,      *00220000
      *  WAIVERS, AND CALCULATING THE MINIMUM AND MAXIMUM SUGGESSTED   *00230000
      *  DEPOSIT AMOUNTS.                                              *00240000
      *                                                                *00250000
      ******************************************************************00260000
      *                                                                *00270000
      *                     PROGRAM MODIFICATION LOG                   *00280000
      *                                                                *00290000
      *    DATE    INITIALS   COMMENTS                                 *00300000
      *  --------  --------   ---------------------------------------  *00310000
      *  02/03/95    WMG      PROCEDURE ORIGINALLY CODED.              *00311000
      *  06/27/95    PD       TO CHECK REVENUE MONTH < CURRENT DATE    *00312000
      *                       IN THE CURSOR                            *00313000
      *  03/19/96    CS       MODIFIED FOR PCR0195 TO SELECT ONLY      *00314000
      *                       ACTIVE GUANTEED AMOUNTS FOR SURETY BONDS *00315000
      *                       IRREVOCABLE LETTER OF CREDITS            *00316000
      *  03/20/96    SONALI   SELECT CHANGED FOR CSS_DEP_ON_HAND       *00317000
      *                       TPR#3568                                 *00318000
      *  12/11/96    RTO      MODIFIED FOR TPR 8013 TO ADJUST THE MIN  *00319000
      *                       DEPOSIT TO 150.00                        *00319100
TP8452*  01/21/97    JEP      TPR 8452 - CWS10014 AND CPD00308 WERE    *00319200
TP8452*                       ADDED TO HANDLE MAXIMUM DEPOSIT ESTIMATES*00319300
TP8452*                       REMOVED UNNECESSARY ESTIMATING CODE.     *00319400
TP8452*  02/06/97    KB       RENAMED COPYBOOK CWS10014 TO CWS00308.   *00319500
T10290*  04/10/97    MAD      ADDED CSS_CUST_PREM_HIST DCLGEN TO       *00319600
      *                       SUPPORT CPD00308 MODIFICATIONS.          *00319700
T15609*  04/20/98    SHF      MODIFIED TO CORRECTLY LOAD VARIABLES TO  *00319800
      *                       MC05 ERROR LOG.                          *00319900
T17856*  09/24/98    SHF      MOVED CWS00308 INCLUDE TO END OF WS.     *00320000
T22668*  08/21/00    SFH      SEB CREDIT PROJECT -- PART II.           *00321000
T23513*  01/25/01    CBSI     CHANGES MADE TO DISTINGUISH DATABASES SEB*00322000
T23513*              MDS      AND NON SEB TO INCORPORATE PSNC IN NON   *00323000
T23513*                       SEB                                      *00324000
T23501*  02/02/01    SFH      ADDED COMPANY_NO TO THE WHERE CLAUSE IN  *00325000
      *                       PARA 6500 TO SUPPORT MULTI-COMPANY.      *00326000
T23179*  05/03/01    SS82048  CHANGES FOR PSNC TO COMPUTE MAXIMUM      *00327000
T23179*                       DEPOSIT AMOUNT FOR SEASONAL /            *00328000
T23179*                       NON-SEASONAL RATES.                      *00329000
C25730*  01/27/02    MDJ      RETRIEVE FIELDS FROM NEW TABLE,          *00329100
      *                       CSS_MAX_DEP_REVIEW AND NEW FIELD,        *00329200
      *                       MAX-DEP-REF-XMT-CD FROM CSS_ACCOUNT.     *00329300
REARCH*  05/16/05    CVNS     RPC TO COBOL SP CONVERSION.              *00329400
REARCH*              CHENNAI                                           *00329500
C33201*  09/14/05    SS82048  INCLUDE DCLGEN FOR CSS_REG_PROFILE       *00329600
      *                       AND CSS_LOCAL_OFFICE                     *00329703
      *                       FOR MAX DEPOSIT CALCULATION CHANGES.     *00329800
A05091** 01/25/16   RB19957   ADDED TBATMISC WHICH IS NOW NEEDED       *00329900
A05091**                      IN CPD00308 FOR SEB SEASONAL FLAG.       *00330000
      ******************************************************************00630000
      *                                                                *00640000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00650000
      *                                                                *00660000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00670000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00680000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00690000
      *  3000 - 4999  NOT USED                                         *00700000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00710000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00720000
      *  7000 - 7999  INPUT MODULES                                    *00730000
      *  8000 - 8999  OUTPUT MODULES                                   *00740000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00750000
      *                                                                *00760000
      ******************************************************************00770000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02022'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02022 STARTS HERE'.                  
                                                                        
      ******************************************************************00860000
      *    DB2 INCLUDES                                                *00870000
      ******************************************************************00880000
      *                                                                 00890000
           EXEC SQL                                                     00900000
              INCLUDE SQLCA                                             00910000
           END-EXEC.                                                    00920000
      *                                                                 00930000
TP8644     EXEC SQL                                                     00940000
TP8644        INCLUDE TBACCT                                            00950000
TP8644     END-EXEC.                                                    00960000
      *                                                                 00970000
           EXEC SQL                                                     00980000
              INCLUDE TBMODEL                                           00990000
           END-EXEC.                                                    01000000
      *                                                                 01010000
           EXEC SQL                                                     01020000
              INCLUDE TBDEPHND                                          01030000
           END-EXEC.                                                    01040000
      *                                                                 01050000
           EXEC SQL                                                     01060000
              INCLUDE TBBLLDET                                          01070000
           END-EXEC.                                                    01080000
      *                                                                 01090000
           EXEC SQL                                                     01100000
              INCLUDE TBSTYBND                                          01110000
           END-EXEC.                                                    01120000
      *                                                                 01130000
           EXEC SQL                                                     01140000
              INCLUDE TBGTNTR                                           01150000
           END-EXEC.                                                    01160000
      *                                                                 01170000
T10290     EXEC SQL                                                     01180000
T10290        INCLUDE TBCSTPRM                                          01190000
T10290     END-EXEC.                                                    01200000
      *                                                                 01210000
T10290     EXEC SQL                                                     01220000
T10290        INCLUDE TBBILWDW                                          01230000
T10290     END-EXEC.                                                    01240000
      *                                                                 01250000
T11792     EXEC SQL                                                     01260000
T11792        INCLUDE TBBLLHDR                                          01270000
T11792     END-EXEC.                                                    01280000
      *                                                                 01290000
T22668     EXEC SQL                                                     01300000
T22668        INCLUDE TBDELQ                                            01310000
T22668     END-EXEC.                                                    01320000
      *                                                                 01330000
T23179     EXEC SQL                                                     01340000
T23179        INCLUDE TBUTLENV                                          01350000
T23179     END-EXEC.                                                    01360000
      *                                                                 01370000
T23179     EXEC SQL                                                     01380000
T23179        INCLUDE TBRTCRTR                                          01390000
T23179     END-EXEC.                                                    01400000
      *                                                                 01410000
C25730     EXEC SQL                                                     01412000
C25730        INCLUDE TBDEPREV                                          01413000
C25730     END-EXEC.                                                    01414000
      *                                                                 01415000
C33201************************************************************      01417000
C33201**   CSS_REG_PROFILE (LR)                                         01418000
C33201************************************************************      01419000
C33201     EXEC SQL                                                     01419100
C33201        INCLUDE TBREGPRF                                          01419200
C33201     END-EXEC.                                                    01419300
C33201*                                                                 01419400
C33201************************************************************      01419503
C33201**   CSS_LOCAL_OFFICE (B1)                                        01419603
C33201************************************************************      01419703
C33201     EXEC SQL                                                     01419803
C33201        INCLUDE TBLOCOFC                                          01419903
C33201     END-EXEC.                                                    01420003
C33201*                                                                 01420103
A05091************************************************************      01420104
A05091**   CSS_ACCT_MISC_INFO TA                                        01420105
A05091************************************************************      01420106
A05091     EXEC SQL                                                     01420107
A05091        INCLUDE TBATMISC                                          01420108
A05091     END-EXEC.                                                    01420109
      *                                                                 01420110
      ******************************************************************01421003
      *    COBOL WORKING STORAGE COPY BOOKS                            *01430000
      ******************************************************************01440000
                                                                        
REARCH*    COPY SYGWCOB.                                                01460000
REARCH*    COPY SYDBCOB.                                                01470000
           COPY CCA00001.                                               01480000
REARCH*    COPY CWS00010.                                               01490000
REARCH     EXEC SQL                                                     01491000
REARCH        INCLUDE CWSX0010                                          01492000
REARCH     END-EXEC.                                                    01493000
           COPY CWS00027.                                               01500000
           COPY CWS00303.                                               01510000
      *                                                                 01520000
      ******************************************************************01530000
      *    WORK AREAS                                                  *01540000
      ******************************************************************01550000
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                          01570000
REARCH*    05  GWL-PROC                POINTER.                         01580000
REARCH*    05  GWL-INIT-HANDLE         POINTER.                         01590000
REARCH*    05  GWL-RC                  PIC S9(9) COMP.                  01600000
REARCH*    05  GWL-STATUS-NR           PIC S9(9) COMP.                  01610000
REARCH*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                  01620000
REARCH*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                  01630000
REARCH*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                  01640000
REARCH*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                  01650000
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  01660000
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02022_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
REARCH      05  WS-SQLSTATE             PIC X(5).                       
REARCH      05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02022'.     
                                                                        
REARCH*01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   01680000
      *                                                                 01690000
REARCH*01  PARM-FIELDS.                                                 01700000
REARCH*    05  PARM-L                  PIC S9(9) COMP.                  01710000
REARCH*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.          01720000
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          01730000
      *                                                                 01740000
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
      *                                                                 01780000
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                 01820000
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                 01880000
       01  WS-TEMPORARY-VARS.                                           
           05  WS-SUMMARY-COLUMN-NAME  PIC X(30) VALUE SPACES.          
           05  WS-COLUMN-SUBTOTAL      PIC S9(09)V99 USAGE COMP-3       
                                                     VALUE 0.           
      *                                                                 01930000
       01  WS-HOST-VARIABLES.                                           
           05  WS-CASH-DEPOSITS-COUNT  PIC S9(09) COMP VALUE 0.         
           05  WS-GUARANTOR-COUNT      PIC S9(09) COMP VALUE 0.         
           05  WS-SURETY-BOND-COUNT    PIC S9(09) COMP VALUE 0.         
           05  WS-IRREVOCABLE-COUNT    PIC S9(09) COMP VALUE 0.         
           05  WS-WAIVER-COUNT         PIC S9(09) COMP VALUE 0.         
           05  WS-WAIVER-CHECK         PIC S9(09) COMP VALUE 0.         
      *                                                                 02010000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
T23513     05  WS-DATABASE             PIC 9(01) VALUE ZERO.            
T23513         88  CSR-DATABASE                  VALUE 1.               
T23513         88  SEB-DATABASE                  VALUE 2.               
      *                                                                 02130000
       01  SUMMARY-COLUMN-TITLES.                                       
           05  CASH-DEPOSIT            PIC X(18) VALUE                  
                                        'TOTAL CASH DEPOSIT'.           
           05  GUARANTORS-AMOUNT       PIC X(23) VALUE                  
                                        'TOTAL GUARANTEED AMOUNT'.      
           05  SURETY-BOND-AMOUNT      PIC X(25) VALUE                  
                                        'TOTAL SURETY BOND AMOUNTS'.    
           05  IRREVOCABLE-LETTER      PIC X(28) VALUE                  
                                        'IRREVOCABLE LETTER OF CREDIT'. 
           05  WAIVER                  PIC X(06) VALUE                  
                                        'WAIVER'.                       
      *                                                                 02250000
       01  BOND-WAIVER-LITERALS.                                        
           05  SURETY-BOND-TYPE        PIC X(01) VALUE 'A'.             
           05  IRREVOCABLE-LETTER-TYPE PIC X(01) VALUE 'B'.             
           05  WAIVER-TYPE             PIC X(01) VALUE 'C'.             
      *                                                                 02300000
       01  BILLING-DETAIL-LITERALS.                                     
           05  BILL-REFUNDED           PIC X(01) VALUE 'R'.             
           05  BILL-PART-REFUNDED      PIC X(01) VALUE 'P'.             
           05  BILL-PENDING            PIC X(01) VALUE 'P'.             
      *                                                                 02350000
       01  NULL-INDICATORS.                                             
           05  GUARANTOR-IND           PIC S9(04) COMP.                 
           05  AMT-DEPOSIT-IND         PIC S9(04) COMP.                 
           05  AMT-BOND-IND            PIC S9(04) COMP.                 
           05  NULL-VALUE              PIC S9(04) COMP VALUE -1.        
C25730     05  WS-NULL-IND-REV-DT      PIC S9(04) COMP.                 
      *                                                                 02410000
REARCH*01  WS-PROGRAM-NAME.                                             02420000
REARCH*    05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02022'.      02430000
      *                                                                 02440000
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                 02460000
       01  TDS-RETURN-FIELDS.                                           
           05  RS-SUMMARY-COLUMN-NAME  PIC X(30)      VALUE SPACES.     
COB305     05 RS-COLUMN-SUBTOTAL        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.     
           05  RS-RETURN-CODE          PIC S9(9)      COMP VALUE 0.     
TP8452     05  RS-NUMBER-OF-BILLS      PIC S9(04)V    USAGE COMP-3      
TP8452                                 VALUE 0.                         
TP8452     05  RS-MIN-DEPOSIT-AMT      PIC S9(09)V99  USAGE COMP-3      
TP8452                                 VALUE 0.                         
TP8452     05  RS-MAX-DEPOSIT-AMT      PIC S9(09)V99  USAGE COMP-3      
TP8452                                 VALUE 0.                         
TP8452     05  RS-USAGE-HISTORY-FLAG   PIC X(01)      VALUE SPACES.     
C25730     05  RS-MAX-DEP-REF-XMT-CD   PIC X(01)      VALUE SPACES.     
C25730     05  RS-LAST-MAX-AT-REV-DT   PIC X(10)      VALUE SPACES.     
C25730     05  RS-MAX-DEP-AT-REV-AM    PIC S9(9)V9(2) USAGE COMP-3      
                                       VALUE 0.                         
C25730     05  RS-PD-DEP-AT-REV-AM     PIC S9(9)V9(2) USAGE COMP-3      
                                       VALUE 0.                         
C25730     05  RS-MAX-DEP-REFUND-CD    PIC X(01)      VALUE SPACES.     
      *                                                                 02650000
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-SUMMARY-COLUMN-NAME  PIC X(30)      VALUE SPACES.      
COB305     05 S-COLUMN-SUBTOTAL        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
REARCH     05  S-RETURN-CODE          PIC S9(9)      COMP VALUE 0.      
REARCH     05  S-NUMBER-OF-BILLS      PIC S9(04)V    USAGE COMP-3       
REARCH                                 VALUE 0.                         
REARCH     05  S-MIN-DEPOSIT-AMT      PIC S9(09)V99  USAGE COMP-3       
REARCH                                 VALUE 0.                         
REARCH     05  S-MAX-DEPOSIT-AMT      PIC S9(09)V99  USAGE COMP-3       
REARCH                                 VALUE 0.                         
REARCH     05  S-USAGE-HISTORY-FLAG   PIC X(01)      VALUE SPACES.      
REARCH     05  S-MAX-DEP-REF-XMT-CD   PIC X(01)      VALUE SPACES.      
REARCH     05  S-LAST-MAX-AT-REV-DT   PIC X(10)      VALUE SPACES.      
REARCH     05  S-MAX-DEP-AT-REV-AM    PIC S9(9)V9(2) USAGE COMP-3       
REARCH                                 VALUE 0.                         
REARCH     05  S-PD-DEP-AT-REV-AM     PIC S9(9)V9(2) USAGE COMP-3       
REARCH                                 VALUE 0.                         
REARCH     05  S-MAX-DEP-REFUND-CD    PIC X(01)      VALUE SPACES.      
TP8452 01  RS-REDEFINITIONS.                                            
TP8452     05  WS-ACCOUNT-PARM          PIC X(13).                      
TP8452     05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-PARM                 
TP8452                                  PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
      *                                                                 02710000
C25730*01  CN-COLUMN-NAMES.                                             02720000
C25730*    05  CN-NUMBER-OF-BILLS       PIC X(10) VALUE                 02730000
C25730*                                        '# OF BILLS'.            02740000
C25730*    05  CN-MIN-DEPOSIT-AMT       PIC X(11) VALUE                 02750000
C25730*                                        'MIN DEPOSIT'.           02760000
C25730*    05  CN-MAX-DEPOSIT-AMT       PIC X(11) VALUE                 02770000
C25730*                                        'MAX DEPOSIT'.           02780000
C25730*    05  CN-USAGE-HISTORY-FLAG    PIC X(15) VALUE                 02790000
C25730*                                        'USAGE HIST FLAG'.       02800000
C25730*    05  CN-SUMMARY-COLUMN-NAME   PIC X(19) VALUE                 02810000
C25730*                                        'SUMMARY COLUMN NAME'.   02820000
C25730*    05  CN-COLUMN-SUBTOTAL       PIC X(15) VALUE                 02830000
C25730*                                        'COLUMN SUBTOTAL'.       02840000
C25730*    05  CN-RETURN-CODE           PIC X(11) VALUE                 02850000
C25730*                                        'RETURN CODE'.           02860000
C25730*    05  CN-MAX-DEP-REF-XMT-CD    PIC X(19) VALUE                 02870000
C25730*                                        'MAX DEP EXEMPT CODE'.   02880000
C25730*    05  CN-LAST-MAX-AT-REV-DT    PIC X(21) VALUE                 02890000
C25730*                                        'LAST MAX DEP REV DATE'. 02900000
C25730*    05  CN-MAX-DEP-AT-REV-AM     PIC X(20) VALUE                 02910000
C25730*                                        'LAST MAX DEP REV AMT'.  02920000
C25730*    05  CN-PD-DEP-AT-REV-AM      PIC X(16) VALUE                 02930000
C25730*                                        'PAID DEP REV AMT'.      02940000
C25730*    05  CN-MAX-DEP-REFUND-CD     PIC X(19) VALUE                 02950000
C25730*                                        'MAX DEP REFUND CODE'.   02960000
REARCH*01  CN-COLUMN-NAMES.                                             02960100
REARCH*    05  CN-NUMBER-OF-BILLS       PIC X(11) VALUE                 02961000
REARCH*                                        'NO_OF_BILLS'.           02962000
REARCH*    05  CN-MIN-DEPOSIT-AMT       PIC X(11) VALUE                 02963000
REARCH*                                        'MIN_DEPOSIT'.           02964000
REARCH*    05  CN-MAX-DEPOSIT-AMT       PIC X(11) VALUE                 02965000
REARCH*                                        'MAX_DEPOSIT'.           02966000
REARCH*    05  CN-USAGE-HISTORY-FLAG    PIC X(13) VALUE                 02967000
REARCH*                                        'USAGE_HIST_FL'.         02968000
REARCH*    05  CN-SUMMARY-COLUMN-NAME   PIC X(04) VALUE                 02969000
REARCH*                                        'TYPE'.                  02969100
REARCH*    05  CN-COLUMN-SUBTOTAL       PIC X(15) VALUE                 02969200
REARCH*                                        'COLUMN_SUBTOTAL'.       02969300
REARCH*    05  CN-RETURN-CODE           PIC X(11) VALUE                 02969400
REARCH*                                        'RETURN_CODE'.           02969500
REARCH*    05  CN-MAX-DEP-REF-XMT-CD    PIC X(18) VALUE                 02969600
REARCH*                                        'MAX_DEP_REF_XMT_CD'.    02969700
REARCH*    05  CN-LAST-MAX-AT-REV-DT    PIC X(19) VALUE                 02969800
REARCH*                                        'LAST_MAX_DEP_REV_DT'.   02969900
REARCH*    05  CN-MAX-DEP-AT-REV-AM     PIC X(19) VALUE                 02970000
REARCH*                                        'LAST_MAX_DEP_REV_AM'.   02970100
REARCH*    05  CN-PD-DEP-AT-REV-AM      PIC X(17) VALUE                 02970200
REARCH*                                        'PD_MAX_DEP_REV_AM'.     02970300
REARCH*    05  CN-MAX-DEP-REFUND-CD     PIC X(17) VALUE                 02970400
REARCH*                                        'MAX_DEP_REFUND_CD'.     02970500
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
TP8452     EXEC SQL                                                     02980000
TP8452         INCLUDE CWS00308                                         02990000
TP8452     END-EXEC.                                                    03000000
                                                                        
      *                                                                 03020000
      *                                                                 03030000
HPCCDM*EJECT                                                            03040000
      *                                                                 03050000
      *                                                                 03060000
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      *                                                                 03080000
      *                                                                 03090000
      ******************************************************************03100000
      * 0000-MAINLINE                                                  *03110000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03120000
      ******************************************************************03130000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03250000
      * 0100-INITIALIZE                                                *03260000
      *                                                                *03270000
      *     1. RESET DB2 ERROR HANDLERS                                *03280000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03290000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03300000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03310000
      *                                                                *03320000
      ******************************************************************03330000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     03410000
REARCH*                                                                 03420000
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     03430000
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.         03440000
REARCH*                                                                 03450000
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      03460000
REARCH*                                                                 03470000
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                             03480000
REARCH*        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    03490000
REARCH*        MOVE '0100'          TO ACTIVE-PARAGRAPH                 03500000
REARCH*        MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION     03510000
REARCH*        MOVE 'CICS TRANSACTION'   TO TABLE-1                     03520000
REARCH*        MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE       03530000
REARCH*        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           03540000
REARCH*        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           03550000
REARCH*    END-IF.                                                      03560000
      *                                                                 03570000
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH            NUMBER_OF_BILLS                                       
REARCH           ,MIN_DEPOSIT_AMT                                       
REARCH           ,MAX_DEPOSIT_AMT                                       
REARCH           ,USAGE_HISTORY_FLAG                                    
REARCH           ,LTRIM(RTRIM(SUMMARY_COLUMN_NAM))     AS 
           SUMMARY_COLUMN_NAM   
REARCH           ,COLUMN_SUBTOTAL                                       
REARCH           ,RETURN_CODE                                           
REARCH           ,MAX_DEP_REF_XMT_CD                                    
REARCH           ,LAST_MAX_AT_REV_DT                                    
REARCH           ,MAX_DEP_AT_REV_AM                                     
REARCH           ,PD_DEP_AT_REV_AM                                      
REARCH           ,MAX_DEP_REFUND_CD                                     
REARCH         FROM                                                     
REARCH             #CSR02022_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     03573000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        03574000
MFA-TR*        SELECT                                                   03575000
MFA-TR*           NUMBER_OF_BILLS                                       03576100
MFA-TR*          ,MIN_DEPOSIT_AMT                                       03576200
MFA-TR*          ,MAX_DEPOSIT_AMT                                       03576300
MFA-TR*          ,USAGE_HISTORY_FLAG                                    03576400
MFA-TR*          ,STRIP(SUMMARY_COLUMN_NAM)     AS SUMMARY_COLUMN_NAM   03576500
MFA-TR*          ,COLUMN_SUBTOTAL                                       03576600
MFA-TR*          ,RETURN_CODE                                           03576700
MFA-TR*          ,MAX_DEP_REF_XMT_CD                                    03576800
MFA-TR*          ,LAST_MAX_AT_REV_DT                                    03576900
MFA-TR*          ,MAX_DEP_AT_REV_AM                                     03577000
MFA-TR*          ,PD_DEP_AT_REV_AM                                      03577100
MFA-TR*          ,MAX_DEP_REFUND_CD                                     03577200
MFA-TR*        FROM                                                     03577300
MFA-TR*            SESSION.CSR02022_R1                                  03578000
MFA-TR*    END-EXEC.                                                    03579000
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************03600100
REARCH*0100A-DECLARE-GTT.                                               03600200
REARCH******************************************************************03600300
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                 03602000
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02022_R1'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR02022_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR02022_R1
               (                                                       
REARCH              NUMBER_OF_BILLS          DECIMAL(4,0)               
REARCH             ,MIN_DEPOSIT_AMT          DECIMAL(11,2)              
REARCH             ,MAX_DEPOSIT_AMT          DECIMAL(11,2)              
REARCH             ,USAGE_HISTORY_FLAG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,SUMMARY_COLUMN_NAM CHAR(30)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,COLUMN_SUBTOTAL          DECIMAL(11,2)              
REARCH             ,RETURN_CODE              INT                    
REARCH             ,MAX_DEP_REF_XMT_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,LAST_MAX_AT_REV_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH             ,MAX_DEP_AT_REV_AM        DECIMAL(11,2)              
REARCH             ,PD_DEP_AT_REV_AM         DECIMAL(11,2)              
REARCH             ,MAX_DEP_REFUND_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH          )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                 03610600
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                 03610900
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000A-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02022_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                 03613100
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
      ******************************************************************03614000
      * 1000-PROCESS-INPUT                                             *03620000
      *                                                                *03630000
      *     1. RECEIVE PARMS.                                          *03640000
      *                                                                *03650000
      ******************************************************************03660000
      *                                                                 03670000
       1000-PROCESS-INPUT.                                              
      *                                                                 03690000
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.               03700000
           PERFORM 1150-ASSIGN-WS-VARS    THRU 1150-EXIT.               
      *                                                                 03720000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03750000
      *                                                                 03760000
      ******************************************************************03770000
      * 1100-RECEIVE-PARMS                                             *03780000
      *                                                                *03790000
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *03800000
      *                                                                *03810000
      ******************************************************************03820000
REARCH*1100-RECEIVE-PARMS.                                              03830000
REARCH*                                                                 03840000
REARCH*                                                                 03850000
REARCH*    MOVE 1                          TO PARM-ID1.                 03860000
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO  TO MAX-LENGTH-PARM,          03870000
REARCH*                                                                 03880000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03890000
REARCH*                          GWL-RC,                                03900000
REARCH*                          PARM-ID1,                              03910000
REARCH*                          PARM-ACCOUNT-NO,                       03920000
REARCH*                          TDSCHAR,                               03930000
REARCH*                          MAX-LENGTH-PARM,                       03940000
REARCH*                          PARM-L.                                03950000
REARCH*                                                                 03960000
REARCH*                                                                 03970000
REARCH*1100-EXIT.                                                       03980000
REARCH*    EXIT.                                                        03990000
      *                                                                 04000000
      *                                                                 04010000
      ******************************************************************04020000
      * 1150 ASSIGN-WS-VARS                                            *04030000
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *04040000
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *04050000
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *04060000
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE SQL      *04070000
      *        SELECT STATEMENTS.                                      *04080000
      ******************************************************************04090000
       1150-ASSIGN-WS-VARS.                                             
      *                                                                 04110000
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-PARM.               
           MOVE WS-ACCOUNT-DEC        TO WS-ACCOUNT-NO.                 
      *                                                                 04140000
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04170000
      *                                                                 04180000
      ******************************************************************04190000
      * 2000-PROCESS-OUTPUT.                                           *04200000
      *                                                                *04210000
      *     1. DESCRIBE RESULT SET                                     *04220000
      *     2. DETERMINE MIN/MAX SUGGESTED DEPOSITS (IF NECESSARY)     *04230000
      *     3. GET CASH DEPOSIT SUMMARY                                *04240000
      *     4. GET GUARANTOR SUMMARY                                   *04250000
      *     5. GET SURETY BOND SUMMARY                                 *04260000
      *     6. GET IRREVOCABLE LETTERS OF CREDIT SUMMARY               *04270000
      *     7  GET WAIVERS SUMMARY                                     *04280000
      *     8. SEND RESULT SET                                         *04290000
      *                                                                *04300000
      ******************************************************************04310000
      *                                                                 04320000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 04340000
REARCH*    PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.        04350000
TP8644     PERFORM 7000-SELECT-BILL-CYCLE                               
TP8644        THRU 7000-SELECT-BILL-CYCLE-EXIT.                         
C25730     PERFORM 7160-SELECT-MAX-DEP-REVIEW                           
TP8644        THRU 7160-EXIT.                                           
T23513     MOVE ZEROS                            TO   WS-DATABASE.      
T23513     MOVE 'DATABASE'                       TO   C8-DELINQ-CD.     
T23513     PERFORM 6500-GET-DATABASE                                    
T23513        THRU 6500-EXIT.                                           
TP8452     PERFORM 5650-GET-MAX-DEPOSIT                                 
TP8452        THRU 5650-GET-MAX-DEPOSIT-EXIT.                           
           PERFORM 2400-GET-COLUMN-SUBTOTALS     THRU 2400-EXIT.        
      *                                                                 04470000
           IF CTR-ROWS < 1                                              
               PERFORM 8000-SET-RETURNS          THRU 8000-EXIT         
REARCH         PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT        
               PERFORM 8100-SEND-RESULT          THRU 8100-EXIT
           END-IF.        
      *                                                                 04510000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04540000
      *                                                                 04550000
      ******************************************************************04560000
      * 2100-DESCRIBE-RESULT                                           *04570000
      *                                                                *04580000
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *04590000
      *                                                                *04600000
      ******************************************************************04610000
REARCH*2100-DESCRIBE-RESULT.                                            04620000
REARCH*                                                                 04630000
REARCH*                                                                 04640000
REARCH*    MOVE 1                               TO CTR-COLUMN.          04650000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        04660000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      04670000
REARCH*    MOVE LENGTH OF RS-NUMBER-OF-BILLS    TO WRKLEN1.             04680000
REARCH*    MOVE LENGTH OF CN-NUMBER-OF-BILLS    TO WRKLEN2.             04690000
REARCH*                                                                 04700000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04710000
REARCH*                          GWL-RC,                                04720000
REARCH*                          CTR-COLUMN,                            04730000
REARCH*                          DB-HOST-TYPE,                          04740000
REARCH*                          WRKLEN1,                               04750000
REARCH*                          RS-NUMBER-OF-BILLS,                    04760000
REARCH*                          DB-NULL-INDICATOR,                     04770000
REARCH*                          TDS-FALSE,                             04780000
REARCH*                          DB-CLIENT-TYPE,                        04790000
REARCH*                          WRKLEN1,                               04800000
REARCH*                          CN-NUMBER-OF-BILLS,                    04810000
REARCH*                          WRKLEN2.                               04820000
REARCH*                                                                 04830000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     04840000
REARCH*                                                                 04850000
REARCH*    MOVE +0 TO WRKLEN2.                                          04860000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              04870000
REARCH*                          GWL-RC,                                04880000
REARCH*                          TDS-OBJECT-COL,                        04890000
REARCH*                          CTR-COLUMN,                            04900000
REARCH*                          WRKLEN1,                               04910000
REARCH*                          WRKLEN2.                               04920000
REARCH*                                                                 04930000
REARCH*                                                                 04940000
REARCH*    ADD 1                                TO CTR-COLUMN.          04950000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        04960000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      04970000
REARCH*    MOVE LENGTH OF RS-MIN-DEPOSIT-AMT    TO WRKLEN1.             04980000
REARCH*    MOVE LENGTH OF CN-MIN-DEPOSIT-AMT    TO WRKLEN2.             04990000
REARCH*                                                                 05000000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05010000
REARCH*                          GWL-RC,                                05020000
REARCH*                          CTR-COLUMN,                            05030000
REARCH*                          DB-HOST-TYPE,                          05040000
REARCH*                          WRKLEN1,                               05050000
REARCH*                          RS-MIN-DEPOSIT-AMT,                    05060000
REARCH*                          DB-NULL-INDICATOR,                     05070000
REARCH*                          TDS-FALSE,                             05080000
REARCH*                          DB-CLIENT-TYPE,                        05090000
REARCH*                          WRKLEN1,                               05100000
REARCH*                          CN-MIN-DEPOSIT-AMT,                    05110000
REARCH*                          WRKLEN2.                               05120000
REARCH*                                                                 05130000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05140000
REARCH*                                                                 05150000
REARCH*    MOVE +2 TO WRKLEN2.                                          05160000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              05170000
REARCH*                          GWL-RC,                                05180000
REARCH*                          TDS-OBJECT-COL,                        05190000
REARCH*                          CTR-COLUMN,                            05200000
REARCH*                          WRKLEN1,                               05210000
REARCH*                          WRKLEN2.                               05220000
REARCH*                                                                 05230000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05240000
REARCH*                                                                 05250000
REARCH*    ADD 1                                TO CTR-COLUMN.          05260000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        05270000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      05280000
REARCH*    MOVE LENGTH OF RS-MAX-DEPOSIT-AMT    TO WRKLEN1.             05290000
REARCH*    MOVE LENGTH OF CN-MAX-DEPOSIT-AMT    TO WRKLEN2.             05300000
REARCH*                                                                 05310000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05320000
REARCH*                          GWL-RC,                                05330000
REARCH*                          CTR-COLUMN,                            05340000
REARCH*                          DB-HOST-TYPE,                          05350000
REARCH*                          WRKLEN1,                               05360000
REARCH*                          RS-MAX-DEPOSIT-AMT,                    05370000
REARCH*                          DB-NULL-INDICATOR,                     05380000
REARCH*                          TDS-FALSE,                             05390000
REARCH*                          DB-CLIENT-TYPE,                        05400000
REARCH*                          WRKLEN1,                               05410000
REARCH*                          CN-MAX-DEPOSIT-AMT,                    05420000
REARCH*                          WRKLEN2.                               05430000
REARCH*                                                                 05440000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05450000
REARCH*                                                                 05460000
REARCH*    MOVE +2 TO WRKLEN2.                                          05470000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              05480000
REARCH*                          GWL-RC,                                05490000
REARCH*                          TDS-OBJECT-COL,                        05500000
REARCH*                          CTR-COLUMN,                            05510000
REARCH*                          WRKLEN1,                               05520000
REARCH*                          WRKLEN2.                               05530000
REARCH*                                                                 05540000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05550000
REARCH*                                                                 05560000
REARCH*    ADD 1                                TO CTR-COLUMN.          05570000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05580000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05590000
REARCH*    MOVE LENGTH OF RS-USAGE-HISTORY-FLAG TO WRKLEN1.             05600000
REARCH*    MOVE LENGTH OF CN-USAGE-HISTORY-FLAG TO WRKLEN2.             05610000
REARCH*                                                                 05620000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05630000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05650000
REARCH*                          DB-HOST-TYPE,                          05660000
REARCH*                          WRKLEN1,                               05670000
REARCH*                          RS-USAGE-HISTORY-FLAG,                 05680000
REARCH*                          DB-NULL-INDICATOR,                     05690000
REARCH*                          TDS-FALSE,                             05700000
REARCH*                          DB-CLIENT-TYPE,                        05710000
REARCH*                          WRKLEN1,                               05720000
REARCH*                          CN-USAGE-HISTORY-FLAG,                 05730000
REARCH*                          WRKLEN2.                               05740000
REARCH*                                                                 05750000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05760000
REARCH*                                                                 05770000
REARCH*    ADD 1                                 TO CTR-COLUMN.         05780000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       05790000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     05800000
REARCH*    MOVE LENGTH OF RS-SUMMARY-COLUMN-NAME TO WRKLEN1.            05810000
REARCH*    MOVE LENGTH OF CN-SUMMARY-COLUMN-NAME TO WRKLEN2.            05820000
REARCH*                                                                 05830000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05840000
REARCH*                          GWL-RC,                                05850000
REARCH*                          CTR-COLUMN,                            05860000
REARCH*                          DB-HOST-TYPE,                          05870000
REARCH*                          WRKLEN1,                               05880000
REARCH*                          RS-SUMMARY-COLUMN-NAME,                05890000
REARCH*                          DB-NULL-INDICATOR,                     05900000
REARCH*                          TDS-FALSE,                             05910000
REARCH*                          DB-CLIENT-TYPE,                        05920000
REARCH*                          WRKLEN1,                               05930000
REARCH*                          CN-SUMMARY-COLUMN-NAME,                05940000
REARCH*                          WRKLEN2.                               05950000
REARCH*                                                                 05960000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05970000
REARCH*                                                                 05980000
REARCH*    ADD 1                                TO CTR-COLUMN.          05990000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        06000000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      06010000
REARCH*    MOVE LENGTH OF RS-COLUMN-SUBTOTAL    TO WRKLEN1.             06020000
REARCH*    MOVE LENGTH OF CN-COLUMN-SUBTOTAL    TO WRKLEN2.             06030000
REARCH*                                                                 06040000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              06050000
REARCH*                          GWL-RC,                                06060000
REARCH*                          CTR-COLUMN,                            06070000
REARCH*                          DB-HOST-TYPE,                          06080000
REARCH*                          WRKLEN1,                               06090000
REARCH*                          RS-COLUMN-SUBTOTAL,                    06100000
REARCH*                          DB-NULL-INDICATOR,                     06110000
REARCH*                          TDS-FALSE,                             06120000
REARCH*                          DB-CLIENT-TYPE,                        06130000
REARCH*                          WRKLEN1,                               06140000
REARCH*                          CN-COLUMN-SUBTOTAL,                    06150000
REARCH*                          WRKLEN2.                               06160000
REARCH*                                                                 06170000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06180000
REARCH*                                                                 06190000
REARCH*    MOVE +2 TO WRKLEN2.                                          06200000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              06210000
REARCH*                          GWL-RC,                                06220000
REARCH*                          TDS-OBJECT-COL,                        06230000
REARCH*                          CTR-COLUMN,                            06240000
REARCH*                          WRKLEN1,                               06250000
REARCH*                          WRKLEN2.                               06260000
REARCH*                                                                 06270000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06280000
REARCH*                                                                 06290000
REARCH*    ADD 1                                TO CTR-COLUMN.          06300000
REARCH*    MOVE TDSINT4                         TO DB-HOST-TYPE.        06310000
REARCH*    MOVE TDSINT4                         TO DB-CLIENT-TYPE.      06320000
REARCH*    MOVE LENGTH OF RS-RETURN-CODE        TO WRKLEN1.             06330000
REARCH*    MOVE LENGTH OF CN-RETURN-CODE        TO WRKLEN2.             06340000
REARCH*                                                                 06350000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              06360000
REARCH*                          GWL-RC,                                06370000
REARCH*                          CTR-COLUMN,                            06380000
REARCH*                          DB-HOST-TYPE,                          06390000
REARCH*                          WRKLEN1,                               06400000
REARCH*                          RS-RETURN-CODE,                        06410000
REARCH*                          DB-NULL-INDICATOR,                     06420000
REARCH*                          TDS-FALSE,                             06430000
REARCH*                          DB-CLIENT-TYPE,                        06440000
REARCH*                          WRKLEN1,                               06450000
REARCH*                          CN-RETURN-CODE,                        06460000
REARCH*                          WRKLEN2.                               06470000
REARCH*                                                                 06480000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06490000
REARCH*                                                                 06500000
REARCH*    ADD 1                                TO CTR-COLUMN.          06510000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        06520000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      06530000
REARCH*    MOVE LENGTH OF RS-MAX-DEP-REF-XMT-CD TO WRKLEN1.             06540000
REARCH*    MOVE LENGTH OF CN-MAX-DEP-REF-XMT-CD TO WRKLEN2.             06550000
REARCH*                                                                 06560000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              06570000
REARCH*                          GWL-RC,                                06580000
REARCH*                          CTR-COLUMN,                            06590000
REARCH*                          DB-HOST-TYPE,                          06600000
REARCH*                          WRKLEN1,                               06610000
REARCH*                          RS-MAX-DEP-REF-XMT-CD,                 06620000
REARCH*                          DB-NULL-INDICATOR,                     06630000
REARCH*                          TDS-FALSE,                             06640000
REARCH*                          DB-CLIENT-TYPE,                        06650000
REARCH*                          WRKLEN1,                               06660000
REARCH*                          CN-MAX-DEP-REF-XMT-CD,                 06670000
REARCH*                          WRKLEN2.                               06680000
REARCH*                                                                 06690000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06700000
REARCH*                                                                 06710000
REARCH*    ADD 1                                TO CTR-COLUMN.          06720000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        06730000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      06740000
REARCH*    MOVE LENGTH OF RS-LAST-MAX-AT-REV-DT TO WRKLEN1.             06750000
REARCH*    MOVE LENGTH OF CN-LAST-MAX-AT-REV-DT TO WRKLEN2.             06760000
REARCH*                                                                 06770000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              06780000
REARCH*                          GWL-RC,                                06790000
REARCH*                          CTR-COLUMN,                            06800000
REARCH*                          DB-HOST-TYPE,                          06810000
REARCH*                          WRKLEN1,                               06820000
REARCH*                          RS-LAST-MAX-AT-REV-DT,                 06830000
REARCH*                          DB-NULL-INDICATOR,                     06840000
REARCH*                          TDS-FALSE,                             06850000
REARCH*                          DB-CLIENT-TYPE,                        06860000
REARCH*                          WRKLEN1,                               06870000
REARCH*                          CN-LAST-MAX-AT-REV-DT,                 06880000
REARCH*                          WRKLEN2.                               06890000
REARCH*                                                                 06900000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06910000
REARCH*                                                                 06920000
REARCH*    ADD 1                                TO CTR-COLUMN.          06930000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        06951000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      06952000
REARCH*    MOVE LENGTH OF RS-MAX-DEP-AT-REV-AM TO WRKLEN1.              06960000
REARCH*    MOVE LENGTH OF CN-MAX-DEP-AT-REV-AM  TO WRKLEN2.             06970000
REARCH*                                                                 06980000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              06990000
REARCH*                          GWL-RC,                                07000000
REARCH*                          CTR-COLUMN,                            07010000
REARCH*                          DB-HOST-TYPE,                          07020000
REARCH*                          WRKLEN1,                               07030000
REARCH*                          RS-MAX-DEP-AT-REV-AM,                  07040000
REARCH*                          DB-NULL-INDICATOR,                     07050000
REARCH*                          TDS-FALSE,                             07060000
REARCH*                          DB-CLIENT-TYPE,                        07070000
REARCH*                          WRKLEN1,                               07080000
REARCH*                          CN-MAX-DEP-AT-REV-AM,                  07090000
REARCH*                          WRKLEN2.                               07100000
REARCH*                                                                 07110000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07120000
REARCH*                                                                 07130000
REARCH*    MOVE +2 TO WRKLEN2.                                          07132000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              07133000
REARCH*                          GWL-RC,                                07134000
REARCH*                          TDS-OBJECT-COL,                        07135000
REARCH*                          CTR-COLUMN,                            07136000
REARCH*                          WRKLEN1,                               07137000
REARCH*                          WRKLEN2.                               07138000
REARCH*                                                                 07139000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07139100
REARCH*                                                                 07139200
REARCH*    ADD 1                                TO CTR-COLUMN.          07140000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        07161000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      07162000
REARCH*    MOVE LENGTH OF RS-PD-DEP-AT-REV-AM TO WRKLEN1.               07170000
REARCH*    MOVE LENGTH OF CN-PD-DEP-AT-REV-AM   TO WRKLEN2.             07180000
REARCH*                                                                 07190000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              07200000
REARCH*                          GWL-RC,                                07210000
REARCH*                          CTR-COLUMN,                            07220000
REARCH*                          DB-HOST-TYPE,                          07230000
REARCH*                          WRKLEN1,                               07240000
REARCH*                          RS-PD-DEP-AT-REV-AM,                   07250000
REARCH*                          DB-NULL-INDICATOR,                     07260000
REARCH*                          TDS-FALSE,                             07270000
REARCH*                          DB-CLIENT-TYPE,                        07280000
REARCH*                          WRKLEN1,                               07290000
REARCH*                          CN-PD-DEP-AT-REV-AM,                   07300000
REARCH*                          WRKLEN2.                               07310000
REARCH*                                                                 07320000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07330000
REARCH*                                                                 07341000
REARCH*    MOVE +2 TO WRKLEN2.                                          07342000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              07343000
REARCH*                          GWL-RC,                                07344000
REARCH*                          TDS-OBJECT-COL,                        07345000
REARCH*                          CTR-COLUMN,                            07346000
REARCH*                          WRKLEN1,                               07347000
REARCH*                          WRKLEN2.                               07348000
REARCH*                                                                 07349000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07349100
REARCH*                                                                 07349200
REARCH*    ADD 1                                TO CTR-COLUMN.          07350000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        07360000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      07370000
REARCH*    MOVE LENGTH OF RS-MAX-DEP-REFUND-CD TO WRKLEN1.              07380000
REARCH*    MOVE LENGTH OF CN-MAX-DEP-REFUND-CD  TO WRKLEN2.             07390000
REARCH*                                                                 07400000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              07410000
REARCH*                          GWL-RC,                                07420000
REARCH*                          CTR-COLUMN,                            07430000
REARCH*                          DB-HOST-TYPE,                          07440000
REARCH*                          WRKLEN1,                               07450000
REARCH*                          RS-MAX-DEP-REFUND-CD,                  07460000
REARCH*                          DB-NULL-INDICATOR,                     07470000
REARCH*                          TDS-FALSE,                             07480000
REARCH*                          DB-CLIENT-TYPE,                        07490000
REARCH*                          WRKLEN1,                               07500000
REARCH*                          CN-MAX-DEP-REFUND-CD,                  07510000
REARCH*                          WRKLEN2.                               07520000
REARCH*                                                                 07530000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07540000
REARCH*                                                                 07550000
REARCH*                                                                 07560000
REARCH*2100-EXIT.                                                       07570000
REARCH*    EXIT.                                                        07580000
      *                                                                 07590000
      *                                                                 07600000
REARCH*                                                                 07601000
REARCH******************************************************************07601100
REARCH*2000A-MOVE-RESULT.                                               07601200
REARCH******************************************************************07601300
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                 07603000
REARCH     MOVE RS-SUMMARY-COLUMN-NAME TO S-SUMMARY-COLUMN-NAME.        
REARCH     MOVE RS-COLUMN-SUBTOTAL     TO S-COLUMN-SUBTOTAL.            
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-NUMBER-OF-BILLS     TO S-NUMBER-OF-BILLS.            
REARCH     MOVE RS-MIN-DEPOSIT-AMT     TO S-MIN-DEPOSIT-AMT.            
REARCH     MOVE RS-MAX-DEPOSIT-AMT     TO S-MAX-DEPOSIT-AMT.            
REARCH     MOVE RS-USAGE-HISTORY-FLAG  TO S-USAGE-HISTORY-FLAG.         
REARCH     MOVE RS-MAX-DEP-REF-XMT-CD  TO S-MAX-DEP-REF-XMT-CD.         
REARCH     MOVE RS-LAST-MAX-AT-REV-DT  TO S-LAST-MAX-AT-REV-DT.         
REARCH     MOVE RS-MAX-DEP-AT-REV-AM   TO S-MAX-DEP-AT-REV-AM.          
REARCH     MOVE RS-PD-DEP-AT-REV-AM    TO S-PD-DEP-AT-REV-AM.           
REARCH     MOVE RS-MAX-DEP-REFUND-CD   TO S-MAX-DEP-REFUND-CD.          
REARCH*                                                                 07610100
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                 07615400
REARCH*                                                                 07623700
TP8452******************************************************************07623800
TP8452* INCLUDE COPYBOOK FOR DETERMINING MAX-DEPOSIT ESTIMATES         *07624000
TP8452******************************************************************07630000
TP8452*                                                                 07640000
TP8452*                                                                 07650000
TP8452     EXEC SQL                                                     07660000
TP8452        INCLUDE CPD00308                                          07670000
TP8452     END-EXEC.                                                    07680000
TP8452*                                                                 07690000
      *                                                                 07700000
TP8644     EXEC SQL                                                     07710000
TP8644        INCLUDE CPD0023C                                          07720000
TP8644     END-EXEC.                                                    07730000
TP8644*                                                                 07740000
      *                                                                 07750000
      ******************************************************************07760000
      * 2400-GET-COLUMN-SUBTOTALS                                      *07770000
      *       -- GETS THE NAME OF THE SUMMARY COLUMNS AS WELL AS THE   *07780000
      *          DOLLAR AMOUNT OF THEIR TOTALS                         *07790000
      ******************************************************************07800000
       2400-GET-COLUMN-SUBTOTALS.                                       
      *                                                                 07820000
           PERFORM 2401-CHECK-FOR-DETAILS            THRU 2401-EXIT.    
           PERFORM 2410-GET-CASH-SUBTOTAL            THRU 2410-EXIT.    
           PERFORM 2420-GET-GUARANTOR-SUBTOTAL       THRU 2420-EXIT.    
           PERFORM 2430-GET-SURETY-BOND-SUBTOTAL     THRU 2430-EXIT.    
           PERFORM 2440-GET-IRREVOCABLE-SUBTOTAL     THRU 2440-EXIT.    
           PERFORM 2450-GET-WAIVER                   THRU 2450-EXIT.    
      *                                                                 07890000
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07920000
      *                                                                 07930000
      ******************************************************************07940000
      * 2401-CHECK-FOR-DETAILS                                         *07950000
      *       -- COUNTS THE NUMBER OF DETAIL RECORDS EXISTING FOR EACH *07960000
      *          SECURITY TYPE.  THIS IS TO DISPLAY THE SECURITY TYPE  *07970000
      *          IN THE SUMMARY DATAWINDOW WHEN NO RECORDS THAT HAVE A *07980000
      *          STATUS OF "ACTIVE", THE OTHER DETAIL RECORDS WILL BE  *07990000
      *          DISPLAYED.                                            *08000000
      ******************************************************************08010000
       2401-CHECK-FOR-DETAILS.                                          
      *                                                                 08030000
           PERFORM 2402-COUNT-DEPOSITS               THRU 2402-EXIT.    
           PERFORM 2403-COUNT-GUARANTORS             THRU 2403-EXIT.    
           PERFORM 2404-COUNT-SURETY-BONDS           THRU 2404-EXIT.    
           PERFORM 2405-COUNT-IRREVOCABLES           THRU 2405-EXIT.    
           PERFORM 2406-COUNT-WAIVERS                THRU 2406-EXIT.    
      *                                                                 08090000
      *                                                                 08100000
       2401-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08130000
      *                                                                 08140000
      ******************************************************************08150000
      * 2402-COUNT-DEPOSITS                                            *08160000
      *       -- THIS MODULE COUNTS AS A CHECK TO SEE IF ANY CASH      *08170000
      *          DEPOSIT RECORDS EXIST IN THE CSS_DEP_ON_HAND TABLE    *08180000
      ******************************************************************08190000
       2402-COUNT-DEPOSITS.                                             
      *                                                                 08210000
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-CASH-DEPOSITS-COUNT                           
                 FROM CSS_DEP_ON_HAND                                   
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08280000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 08310000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2402'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                    
T15609         MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 08440000
      *                                                                 08450000
       2402-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08480000
      *                                                                 08490000
      ******************************************************************08500000
      * 2403-COUNT-GUARANTORS                                          *08510000
      *       -- THIS MODULE COUNTS AS A CHECK TO SEE IF ANY GUARANTOR *08520000
      *          RECORDS EXIST IN THE CSS_DEP_ON_HAND TABLE            *08530000
      ******************************************************************08540000
       2403-COUNT-GUARANTORS.                                           
      *                                                                 08560000
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-GUARANTOR-COUNT                               
                 FROM CSS_GUARANTOR                                     
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08630000
           MOVE SQLCODE TO RS-RETURN-CODE.                              
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 08660000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2403'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_GUARANTOR'       TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 08790000
      *                                                                 08800000
       2403-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08830000
      *                                                                 08840000
      ******************************************************************08850000
      * 2404-COUNT-SURETY-BONDS                                        *08860000
      *       -- THIS MODULE COUNTS AS A CHECK TO SEE IF ANY SURETY    *08870000
      *          BOND RECORDS EXIST IN THE CSS_SURETY_BOND TABLE       *08880000
      ******************************************************************08890000
       2404-COUNT-SURETY-BONDS.                                         
      *                                                                 08910000
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-SURETY-BOND-COUNT                             
                 FROM CSS_SURETY_BOND                                   
                WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                   
                  AND CODE_BOND_TYPE = :SURETY-BOND-TYPE                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08990000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 09020000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2404'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_SURETY_BOND'     TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T15609         MOVE SURETY-BOND-TYPE      TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 09170000
      *                                                                 09180000
       2404-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09210000
      *                                                                 09220000
      ******************************************************************09230000
      * 2405-COUNT-IRREVOCABLES                                        *09240000
      *       -- THIS MODULE COUNTS AS A CHECK TO SEE IF ANY           *09250000
      *          IRREVOCABLE LETTER RECORDS EXIST IN THE               *09260000
      *          CSS_SURETY_BOND TABLE                                 *09270000
      ******************************************************************09280000
       2405-COUNT-IRREVOCABLES.                                         
      *                                                                 09300000
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-IRREVOCABLE-COUNT                             
                 FROM CSS_SURETY_BOND                                   
                WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                   
                  AND CODE_BOND_TYPE = :IRREVOCABLE-LETTER-TYPE         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09380000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 09410000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2405'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_SURETY_BOND'     TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T15609         MOVE IRREVOCABLE-LETTER-TYPE TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 09560000
      *                                                                 09570000
       2405-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09600000
      *                                                                 09610000
      ******************************************************************09620000
      * 2406-COUNT-WAIVERS                                             *09630000
      *       -- THIS MODULE COUNTS AS A CHECK TO SEE IF ANY           *09640000
      *          WAIVER RECORDS EXIST IN THE CSS_SURETY_BOND TABLE     *09650000
      ******************************************************************09660000
       2406-COUNT-WAIVERS.                                              
      *                                                                 09680000
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-WAIVER-COUNT                                  
                 FROM CSS_SURETY_BOND                                   
                WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                   
                  AND CODE_BOND_TYPE = :WAIVER-TYPE                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09760000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 09790000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2406'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_SURETY_BOND'     TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T15609         MOVE WAIVER-TYPE           TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 09940000
      *                                                                 09950000
       2406-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09980000
      *                                                                 09990000
      ******************************************************************10000000
      * 2410-GET-CASH-SUBTOTAL                                         *10010000
      *       -- THIS MODULE GETS THE CASH COLUMN NAME, THE            *10020000
      *          TOTAL CASH AMOUNT AND RETURNS THE RESULT SET.         *10030000
      ******************************************************************10040000
      ******************************************************************10050000
      * CHNGD -SELECT SUM(AMT_DEPOSIT) - SUM(AMT_REFUNDED)             *10060000
      ******************************************************************10070000
       2410-GET-CASH-SUBTOTAL.                                          
      *                                                                 10090000
           EXEC SQL                                                     
               SELECT SUM(AMT_DEPOSIT)                                  
                 INTO :DO-AMT-DEPOSIT :AMT-DEPOSIT-IND                   
                 FROM CSS_DEP_ON_HAND                                   
                WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                
                  AND DEPOSIT_STATUS_CD IN ( 'A' , 'P' )                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10170000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 10200000
           IF ((WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL) AND            
                    ((AMT-DEPOSIT-IND = SUCCESSFUL-CALL) OR             
                          (WS-CASH-DEPOSITS-COUNT > 0)))                
               MOVE CASH-DEPOSIT          TO WS-SUMMARY-COLUMN-NAME     
               IF AMT-DEPOSIT-IND = NULL-VALUE                          
                   MOVE 0                 TO WS-COLUMN-SUBTOTAL         
               ELSE                                                     
                   MOVE DO-AMT-DEPOSIT    TO WS-COLUMN-SUBTOTAL         
               END-IF                                                   
               PERFORM 8000-SET-RETURNS   THRU 8000-EXIT                
REARCH         PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT               
               PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                
           ELSE IF ((WS-ACTIVE-RETURN-CODE = NOT-FOUND) OR              
                    (AMT-DEPOSIT-IND = NULL-VALUE))                     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2410'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 10450000
      *                                                                 10460000
       2410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10490000
      *                                                                 10500000
      ******************************************************************10510000
      * 2420-GET-GUARANTOR-SUBTOTAL                                    *10520000
      *       -- THIS MODULE GETS THE GUARANTOR COLUMN NAME, THE       *10530000
      *          TOTAL AMOUNT GUARANTEED AND RETURNS THE RESULT SET.   *10540000
      ******************************************************************10550000
       2420-GET-GUARANTOR-SUBTOTAL.                                     
      *                                                                 10570000
           EXEC SQL                                                     
               SELECT SUM(AMOUNT_GUARANTEED)                            
                 INTO :GU-AMOUNT-GUARANTEED :GUARANTOR-IND               
                 FROM CSS_GUARANTOR                                     
                WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                   
                  AND GUAR_STATUS_CD = :BILL-ACTIVE                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10650000
           MOVE SQLCODE                       TO RS-RETURN-CODE.        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 10680000
           IF ((WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL) AND            
               ((GUARANTOR-IND = SUCCESSFUL-CALL) OR                    
                (WS-GUARANTOR-COUNT > 0)))                              
               MOVE GUARANTORS-AMOUNT         TO WS-SUMMARY-COLUMN-NAME 
               IF GUARANTOR-IND = NULL-VALUE                            
                   MOVE 0                     TO WS-COLUMN-SUBTOTAL     
               ELSE                                                     
                   MOVE GU-AMOUNT-GUARANTEED  TO WS-COLUMN-SUBTOTAL     
               END-IF                                                   
               PERFORM 8000-SET-RETURNS   THRU 8000-EXIT                
REARCH         PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT               
               PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                
           ELSE IF ((WS-ACTIVE-RETURN-CODE = NOT-FOUND) OR              
                    (GUARANTOR-IND = NULL-VALUE))                       
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2420'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_GUARANTOR'       TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE 'GUAR_STATUS_CD'      TO TABLE-ELEMENT-2            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T15609         MOVE BILL-ACTIVE           TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 10950000
      *                                                                 10960000
       2420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10990000
      *                                                                 11000000
      ******************************************************************11010000
      * 2430-GET-SURETY-BOND-SUBTOTAL                                  *11020000
      *       -- THIS MODULE GETS THE SURETY BOND COLUMN NAME, THE     *11030000
      *          TOTAL SURETY BOND AMOUNT AND RETURNS THE RESULT SET.  *11040000
      ******************************************************************11050000
       2430-GET-SURETY-BOND-SUBTOTAL.                                   
      *                                                                 11070000
           EXEC SQL                                                     
               SELECT SUM(AMT_BOND)                                     
                 INTO :SB-AMT-BOND :AMT-BOND-IND                         
                 FROM CSS_SURETY_BOND                                   
                WHERE ACCOUNT_NO      = :WS-ACCOUNT-NO                  
                  AND CODE_BOND_TYPE  = :SURETY-BOND-TYPE               
                  AND CODE_STATUS     = :BILL-ACTIVE                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11160000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 11190000
           IF ((WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL) AND            
               ((AMT-BOND-IND = SUCCESSFUL-CALL) OR                     
                (WS-SURETY-BOND-COUNT > 0)))                            
               MOVE SURETY-BOND-AMOUNT    TO WS-SUMMARY-COLUMN-NAME     
               IF AMT-BOND-IND = NULL-VALUE                             
                   MOVE 0                 TO WS-COLUMN-SUBTOTAL         
               ELSE                                                     
                   MOVE SB-AMT-BOND       TO WS-COLUMN-SUBTOTAL         
               END-IF                                                   
               PERFORM 8000-SET-RETURNS   THRU 8000-EXIT                
REARCH         PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT               
               PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                
           ELSE IF ((WS-ACTIVE-RETURN-CODE = NOT-FOUND) OR              
                    (AMT-BOND-IND = NULL-VALUE))                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2430'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_SURETY_BOND'     TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2            
T15609         MOVE 'CODE_STATUS'         TO TABLE-ELEMENT-3            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T15609         MOVE SURETY-BOND-TYPE      TO HOSTVAR-ELEMENT-2          
T15609         MOVE BILL-ACTIVE           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 11480000
      *                                                                 11490000
       2430-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11520000
      *                                                                 11530000
      ******************************************************************11540000
      * 2440-GET-IRREVOCABLE-SUBTOTAL                                  *11550000
      *       -- THIS MODULE GETS THE IRREVOCABLE COLUMN NAME, THE     *11560000
      *          TOTAL IRREVOCABLE AMOUNT AND RETURNS THE RESULT SET.  *11570000
      ******************************************************************11580000
       2440-GET-IRREVOCABLE-SUBTOTAL.                                   
      *                                                                 11600000
           EXEC SQL                                                     
               SELECT SUM(AMT_BOND)                                     
                 INTO :SB-AMT-BOND :AMT-BOND-IND                         
                 FROM CSS_SURETY_BOND                                   
                WHERE ACCOUNT_NO      = :WS-ACCOUNT-NO                  
                  AND CODE_BOND_TYPE  = :IRREVOCABLE-LETTER-TYPE        
                  AND CODE_STATUS     = :BILL-ACTIVE                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11690000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 11720000
           IF ((WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL) AND            
               ((AMT-BOND-IND = SUCCESSFUL-CALL) OR                     
                (WS-IRREVOCABLE-COUNT > 0)))                            
               MOVE IRREVOCABLE-LETTER    TO WS-SUMMARY-COLUMN-NAME     
               IF AMT-BOND-IND = NULL-VALUE                             
                   MOVE 0                 TO WS-COLUMN-SUBTOTAL         
               ELSE                                                     
                   MOVE SB-AMT-BOND       TO WS-COLUMN-SUBTOTAL         
               END-IF                                                   
               PERFORM 8000-SET-RETURNS   THRU 8000-EXIT                
REARCH         PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT               
               PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                
           ELSE IF ((WS-ACTIVE-RETURN-CODE = NOT-FOUND) OR              
                    (AMT-BOND-IND = NULL-VALUE))                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2440'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_SURETY_BOND'     TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2            
T15609         MOVE 'CODE_STATUS'         TO TABLE-ELEMENT-3            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T15609         MOVE IRREVOCABLE-LETTER-TYPE TO HOSTVAR-ELEMENT-2        
T15609         MOVE BILL-ACTIVE           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 12010000
      *                                                                 12020000
       2440-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12050000
      *                                                                 12060000
      ******************************************************************12070000
      * 2450-GET-WAIVER                                                *12080000
      *       -- THIS MODULE GETS THE WAIVER COLUMN NAME.  IT IS NOT   *12090000
      *          ASSOCIATED WITH TOTAL AMOUNT.  IF THE WAIVER EXISTS,  *12100000
      *          THE COLUMN NAME IS RETURNED.                           12110000
      ******************************************************************12120000
       2450-GET-WAIVER.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-WAIVER-CHECK                                  
                 FROM CSS_SURETY_BOND                                   
                WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                   
                  AND CODE_BOND_TYPE = :WAIVER-TYPE                     
                  AND CODE_STATUS    = :BILL-ACTIVE                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12230000
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                 12260000
           IF ((WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL) AND            
               ((WS-WAIVER-CHECK > 0) OR (WS-WAIVER-COUNT > 0)))        
               MOVE WAIVER                TO WS-SUMMARY-COLUMN-NAME     
               MOVE 0                     TO WS-COLUMN-SUBTOTAL         
               PERFORM 8000-SET-RETURNS   THRU 8000-EXIT                
REARCH         PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT               
               PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                
           ELSE IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '2450'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_SURETY_BOND'     TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2            
T15609         MOVE 'CODE_STATUS'         TO TABLE-ELEMENT-3            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T15609         MOVE WAIVER-TYPE           TO HOSTVAR-ELEMENT-2          
T15609         MOVE BILL-ACTIVE           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 12490000
      *                                                                 12500000
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12530000
T22668***************************************************************** 12540000
T23513* 6500-GET-DATABASE.                                            * 12550000
T23513*     SELECTS   DATABASE     (SEB OR SCEG) FROM CSS_DELINQUENCY * 12560000
T22668***************************************************************** 12570000
T23513 6500-GET-DATABASE.                                               
T22668                                                                  
T22668     EXEC SQL                                                     
T22668        SELECT DELINQ_VALUE                                       
T22668          INTO :C8-DELINQ-VALUE                                   
T22668          FROM CSS_DELINQUENCY                                    
T23513         WHERE DELINQ_CD = :C8-DELINQ-CD                          
T23501           AND COMPANY_NO = :AT-COMPANY-NO                        
T22668     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22668                                                                  
T22668     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
T22668                                                                  
T22668     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T23513        MOVE C8-DELINQ-VALUE TO WS-DATABASE                       
T22668     ELSE                                                         
T22668        MOVE '6500'                     TO ACTIVE-PARAGRAPH       
T22668        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T22668        MOVE 'SELECT'                   TO ABEND-FUNCTION         
T22668        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
T22668        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T22668        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T22668        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T22668        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T22668     END-IF.                                                      
T22668                                                                  
T22668 6500-EXIT.                                                       
T22668     EXIT.                                                        
      *                                                                 12850000
TP8644******************************************************************12860000
TP8644* 7000-SELECT-BILL-CYCLE                                         *12870000
TP8644*       -- THIS MODULE GETS THE BILL CYCLE FROM THE CSS_ACCOUNT  *12880000
TP8644*          TABLE                                                 *12890000
C25730*          GETS THE MAX-DEP-REF-XMT-CD FROM CSS_ACCOUNT.         *12900000
TP8644******************************************************************12910000
TP8644 7000-SELECT-BILL-CYCLE.                                          
TP8644*                                                                 12930000
TP8644     EXEC SQL                                                     
TP8644         SELECT BILL_CYCLE,                                       
T23501                COMPANY_NO,                                       
C25730                MAX_DEP_REF_XMT_CD                                
TP8644           INTO :AT-BILL-CYCLE,                                   
T23501                :AT-COMPANY-NO,                                   
C25730                :AT-MAX-DEP-REF-XMT-CD                            
TP8644           FROM CSS_ACCOUNT                                       
TP8644          WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
TP8644     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP8644*                                                                 13040000
TP8644     MOVE SQLCODE                   TO RS-RETURN-CODE.            
TP8644     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
TP8644*                                                                 13070000
TP8644     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
TP8644         NEXT SENTENCE                                            
TP8644     ELSE                                                         
TP8644         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
TP8644         MOVE '7000'                TO ACTIVE-PARAGRAPH           
TP8644         MOVE 'SELECT'              TO ABEND-FUNCTION             
TP8644         MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
T15609         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T15609         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
TP8644         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
TP8644         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
TP8644     END-IF.                                                      
TP8644*                                                                 13200000
TP8644 7000-SELECT-BILL-CYCLE-EXIT.                                     
TP8644     EXIT.                                                        
      *                                                                 13230000
      ******************************************************************13240000
      * SELECT MAX-DEP-REVIEW                                           13250000
      ******************************************************************13260000
      *                                                                 13270000
C25730 7160-SELECT-MAX-DEP-REVIEW.                                      
      *                                                                 13290000
           EXEC SQL                                                     
              SELECT LAST_MAX_AT_REV_DT,                                
                     MAX_DEP_AT_REV_AM,                                 
                     PD_DEP_AT_REV_AM,                                  
                     MAX_DEP_REFUND_CD                                  
                INTO :MG-LAST-MAX-AT-REV-DT :WS-NULL-IND-REV-DT,         
                     :MG-MAX-DEP-AT-REV-AM,                             
                     :MG-PD-DEP-AT-REV-AM,                              
                     :MG-MAX-DEP-REFUND-CD                              
               FROM CSS_MAX_DEP_REVIEW                                  
              WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13420000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           MOVE SQLCODE                        TO RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF  WS-NULL-IND-REV-DT = NULL-VALUE                      
                   MOVE ZEROES                 TO MG-LAST-MAX-AT-REV-DT 
               END-IF                                                   
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE SPACES             TO   MG-LAST-MAX-AT-REV-DT    
                                               MG-MAX-DEP-REFUND-CD     
                  MOVE ZEROES             TO   MG-MAX-DEP-AT-REV-AM     
                                               MG-PD-DEP-AT-REV-AM      
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7160'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_MAX_DEP_REVIEW'  TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 13590000
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13620000
      ******************************************************************13630000
      * 8000 SET RETURNS                                               *13640000
      *    -- THIS MODULE SETS UP THE VALUES FOR THE VARIABLES THAT ARE*13650000
      *       TO BE RETURNED TO THE DESKTOP ENVIRONMENT.               *13660000
      ******************************************************************13670000
       8000-SET-RETURNS.                                                
      *                                                                 13690000
TP8452     MOVE WS-NUMBER-OF-BILLS        TO RS-NUMBER-OF-BILLS.        
TP8452     MOVE WS-MIN-DEPOSIT-AMT        TO RS-MIN-DEPOSIT-AMT.        
TP8452     MOVE WS-MAX-DEPOSIT-AMT        TO RS-MAX-DEPOSIT-AMT.        
TP8452     MOVE WS-USAGE-HISTORY-FLAG     TO RS-USAGE-HISTORY-FLAG.     
           MOVE WS-SUMMARY-COLUMN-NAME    TO RS-SUMMARY-COLUMN-NAME.    
           MOVE WS-COLUMN-SUBTOTAL        TO RS-COLUMN-SUBTOTAL.        
C25730     MOVE AT-MAX-DEP-REF-XMT-CD     TO RS-MAX-DEP-REF-XMT-CD.     
C25730     MOVE MG-LAST-MAX-AT-REV-DT     TO RS-LAST-MAX-AT-REV-DT.     
C25730     MOVE MG-MAX-DEP-AT-REV-AM      TO RS-MAX-DEP-AT-REV-AM.      
C25730     MOVE MG-PD-DEP-AT-REV-AM       TO RS-PD-DEP-AT-REV-AM.       
C25730     MOVE MG-MAX-DEP-REFUND-CD      TO RS-MAX-DEP-REFUND-CD.      
      *                                                                 13810000
           MOVE 0                         TO SB-AMT-BOND.               
      *                                                                 13830000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13860000
REARCH******************************************************************13860100
REARCH*8000A-DELETE-GTT-ROWS.                                           13860300
REARCH******************************************************************13860400
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                 13862000
REARCH      MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
REARCH*                                                                 13864000
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02022_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    13865000
MFA-TR*         DELETE FROM SESSION.CSR02022_R1                         13866000
MFA-TR*     END-EXEC.                                                   13867000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                 13868000
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                 13869100
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         NEXT SENTENCE                                            
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
REARCH         MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
REARCH         MOVE 'DELETE'              TO  ABEND-FUNCTION            
REARCH         MOVE SQLCODE               TO  ABEND-SQLCODE             
REARCH         MOVE SPACES                TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH         MOVE 'CSR02022_R1'         TO  TABLE-1                   
REARCH         MOVE SPACES                TO  TABLE-ELEMENT-1           
REARCH         MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH      END-IF.                                                     
REARCH*                                                                 13870900
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                 13871200
REARCH******************************************************************13871300
REARCH*8100-SEND-RESULT.                                                13871400
REARCH******************************************************************13871500
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH      EXEC SQL                                                    
REARCH           INSERT INTO #CSR02022_R1                        
REARCH           (                                                      
REARCH                NUMBER_OF_BILLS                                   
REARCH               ,MIN_DEPOSIT_AMT                                   
REARCH               ,MAX_DEPOSIT_AMT                                   
REARCH               ,USAGE_HISTORY_FLAG                                
REARCH               ,SUMMARY_COLUMN_NAM                                
REARCH               ,COLUMN_SUBTOTAL                                   
REARCH               ,RETURN_CODE                                       
REARCH               ,MAX_DEP_REF_XMT_CD                                
REARCH               ,LAST_MAX_AT_REV_DT                                
REARCH               ,MAX_DEP_AT_REV_AM                                 
REARCH               ,PD_DEP_AT_REV_AM                                  
REARCH               ,MAX_DEP_REFUND_CD                                 
REARCH           )                                                      
REARCH           VALUES                                                 
REARCH           (                                                      
REARCH                 :S-NUMBER-OF-BILLS                               
REARCH                ,:S-MIN-DEPOSIT-AMT                               
REARCH                ,:S-MAX-DEPOSIT-AMT                               
REARCH                ,:S-USAGE-HISTORY-FLAG                            
REARCH                ,:S-SUMMARY-COLUMN-NAME                           
REARCH                ,:S-COLUMN-SUBTOTAL                               
REARCH                ,:S-RETURN-CODE                                   
REARCH                ,:S-MAX-DEP-REF-XMT-CD                            
REARCH                ,:S-LAST-MAX-AT-REV-DT                            
REARCH                ,:S-MAX-DEP-AT-REV-AM                             
REARCH                ,:S-PD-DEP-AT-REV-AM                              
REARCH                ,:S-MAX-DEP-REFUND-CD                             
REARCH           )                                                      
REARCH       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    13871800
MFA-TR*          INSERT INTO SESSION.CSR02022_R1                        13871900
MFA-TR*          (                                                      13872000
MFA-TR*               NUMBER_OF_BILLS                                   13872200
MFA-TR*              ,MIN_DEPOSIT_AMT                                   13872300
MFA-TR*              ,MAX_DEPOSIT_AMT                                   13872400
MFA-TR*              ,USAGE_HISTORY_FLAG                                13872500
MFA-TR*              ,SUMMARY_COLUMN_NAM                                13872600
MFA-TR*              ,COLUMN_SUBTOTAL                                   13872700
MFA-TR*              ,RETURN_CODE                                       13872800
MFA-TR*              ,MAX_DEP_REF_XMT_CD                                13872900
MFA-TR*              ,LAST_MAX_AT_REV_DT                                13873000
MFA-TR*              ,MAX_DEP_AT_REV_AM                                 13873100
MFA-TR*              ,PD_DEP_AT_REV_AM                                  13873200
MFA-TR*              ,MAX_DEP_REFUND_CD                                 13873300
MFA-TR*          )                                                      13873400
MFA-TR*          VALUES                                                 13873500
MFA-TR*          (                                                      13873600
MFA-TR*                :S-NUMBER-OF-BILLS                               13873700
MFA-TR*               ,:S-MIN-DEPOSIT-AMT                               13873800
MFA-TR*               ,:S-MAX-DEPOSIT-AMT                               13873900
MFA-TR*               ,:S-USAGE-HISTORY-FLAG                            13874000
MFA-TR*               ,:S-SUMMARY-COLUMN-NAME                           13874100
MFA-TR*               ,:S-COLUMN-SUBTOTAL                               13874200
MFA-TR*               ,:S-RETURN-CODE                                   13874300
MFA-TR*               ,:S-MAX-DEP-REF-XMT-CD                            13874500
MFA-TR*               ,:S-LAST-MAX-AT-REV-DT                            13874600
MFA-TR*               ,:S-MAX-DEP-AT-REV-AM                             13874700
MFA-TR*               ,:S-PD-DEP-AT-REV-AM                              13874800
MFA-TR*               ,:S-MAX-DEP-REFUND-CD                             13874900
MFA-TR*          )                                                      13875000
MFA-TR*      END-EXEC.                                                  13875100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                 13875200
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
REARCH*                                                                 13875400
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02022_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
REARCH*                                                                 13876900
REARCH  8100-EXIT.                                                      
REARCH      EXIT.                                                       
      *                                                                 13878000
      ******************************************************************13880000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *13890000
      ******************************************************************13900000
REARCH*    EXEC SQL                                                     13910000
REARCH*       INCLUDE CPD00300                                          13920000
REARCH*    END-EXEC.                                                    13930000
                                                                        
REARCH     EXEC SQL                                                     13941000
REARCH        INCLUDE CPDSP300                                          13942000
REARCH     END-EXEC.                                                    13943000
      ******************************************************************13950000
      * 9999- END PROGRAM COPYLIB                                      *13960000
      ******************************************************************13970000
REARCH*    COPY CPD00302.                                               13980000
REARCH     EXEC SQL                                                     13981000
REARCH        INCLUDE CPD00320                                          13982000
REARCH     END-EXEC.                                                    13983000
                                                                        
