       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02021.                                     
COB303 DATE-WRITTEN.  MAY 25, 2005                                      
       DATE-COMPILED.                                                   
                                                                        
      *  THIS IS THE VERSION USED BY PANEL 113, 362, 80, AND 69.        00060000
                                                                        
      ******************************************************************00080000
      *                                                                *00090000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00100000
      *                                                                *00110000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00120000
      *                                                                *00130000
      *  TRANID:        S021                                           *00140000
      *  PROGRAM:       S021                                           *00150000
      *  CALLING SP:    PA_S021                                        *00160000
      *                                                                *00170000
      ******************************************************************00180000
      *                 P R O G R A M  S U M M A R Y                   *00190000
      *                                                                *00200000
      *  THIS PROGRAM RETRIEVES ALL A/R RELATED INFORMATION FROM       *00210000
      *  CSS_ACCOUNT AND CSS_AR_CNTL BASED ON ACCOUNT NUMBER.          *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *    0195      CIF      PROCEDURE ORIGINALLY CODED.              *00290000
      *    0395      CIF      USE A TO IDENTIFY CHARGED-OFF, UTILITY   *00300000
      *                       RELATED AND B FOR CHARGED-OFF, NON-      *00310000
      *                       UTILITY RELATED RECEIVABLE.              *00320000
      *    0495      CIF      TPR TO DISTINGUISH BETWEEN DFA AND DPP   *00330000
      *    0595      CIF      MODIFY PER DATABASE CHANGE:              *00340000
      *                       DL-AMT-RECONNECT, DL-AMT-RCC-CHARGE      *00350000
      *                       AND DL-RCC-CHARGE-IND ARE REMOVED FROM   *00360000
      *                       CSS_RECONNECT TABLE                      *00370000
      *  06/19/95    HC       FIX TPR 5709 - ADD NULL INDICATORS TO    *00380000
      *                       DATE FIELDS ON ACCOUNT TABLE - PARA 7000-*00390000
      *  06/30/95    TCB      FIX TPR 5307 - DO NOT DISPLAY SCHEDULED  *00400000
      *                       PAYMENTS FOR CONTRACT TYPE 'B'           *00410000
      *  06/30/95    TCB      FIX TPR 5660 - DISPLAY CONTRACT TYPE 'E'.*00420000
      *  07/22/95    WMG      FIX TPR 5924 - CHANGED LENGTH OF AR TYPE *00430000
      *                                      DESCRIPTION TO RETURN ALL *00440000
      *                                      25 CHARACTERS.            *00450000
      *  11/27/95    DMD      FIX TPR 2066 - CHANGED WS-EPP-OFFER TO   *00460000
      *                                      INDICATE WHETHER AN EPP   *00470000
      *                                      OFFER HAS BEEN MADE       *00480000
      *  12/12/95    TCB      FIX TPR 1681 - CHANGED PARAGRAPH 2336 TO *00490000
      *                       RETURN DFA AND DPP RECEIVABLES CORRECTLY.*00500000
      *  01/15/96    DMD      FIX TPR 2298 - LIHEAP START AND END      *00510000
      *                                      BOUNDARY DATES WERE HARD  *00520000
      *                                      CODED - NOW THEY ARE READ *00530000
      *                                      OFF THE CSS_DELINQUENCY   *00540000
      *                                      TABLE AND FORMATTED       *00550000
      *                       FIX TPR 2596 - RETRIEVE FROM CSS_CONTRACT*00560000
      *                                      IN 7240 SHOULD NOT ABEND  *00570000
      *                                      WHEN NOT FOUND            *00580000
      *  01/22/96   TCB       FIX TPR 2558 - ADDED CODE TO 2334 TO     *00590000
      *                                      RETURN A DESC FOR ADVANCE *00600000
      *                                      COLLECTION ROWS.          *00610000
      *                                                                *00620000
      *  01/23/96   MR        FIX TPR 2830 - CHANGED SELECT FOR        *00630000
      *                       CSS_ACCOUNT RE: CHANGES IN CPD00068      *00640000
      *  01/30/96   SD        FIX TPR 2905 - INCLUDED TBARHIST         *00650000
      *  01/30/96   SD        FIX TPR 2298 - LIHEAP START & END DATES  *00660000
      *                       PICKED UP FROM CSS_DELINQUENCY AND PASSED*00670000
      *                       INTO PANEL 113                           *00680000
      *  02/21/96   RTO       MODIFIED FOR DPP EARNEST PAYMENT DATE    *00690000
      *                       FORMAT CHANGE.                           *00700000
      *  02/21/96   RTO       FIX TPR 3222 ADDED NULL IND FOR PROJECT  *00710000
      *                       SHARE.                                   *00720000
      *  02/26/96   RTO       FIX TO SELECT EARNEST PAYMENTS FOR AN    *00730000
      *                       ACTIVE DPP ONLY.                         *00740000
      *  03/11/96   RTO       REMOVE REFERENCES TO RETURN CASHIER-CODE *00750000
      *                       LOCAL-OFFICE ENDORSEMENT AND RECIEPT IND *00760000
      *                       IN CONJUNCTION WITH FCS CHANGES          *00770000
      *  04/01/96   RTO       FIX TPR 3709 - FIX TO COUNT ONLY         *00780000
      *                       NSF-HIST ROWS WITH A NSF-STATUS-CD = 'C' *00790000
      *                       OR COMPLETED STATUS                      *00800000
      *  06/26/96   RTO       FIX TPR 4695 - FIX TO MOVE ZEROS TO      *00F ALL 
      *                       BILLED BALANCE FOR A WRITEOFF ACCOUNT    *00820000
      *                       AND CO-AMT-TRANS IS USED FOR FULL BALANCE*00830000
      *                                                                *00840000
PCR072*  09/23/96   PD        PCR 072. ADDED ANOTHER RECEIVABLE CIA.   *00850000
PCR361*  10/03/96   JRX       PCR 361. MODIFY ERROR ROUTINE CALLS      *00860000
PCR361*                       REMOVE CSS_DELINQUENCY TABLE RETRIEVE    *00870000
PCR361*                       SINCE THIS IS DONE IN CPD00068.          *00880000
PCR263*  10/03/96   JRX       PCR263.  MODIFY 7251- PARAGRAPH.         *00890000
*T3437*  10/10/96   AG        TPR 3437. MODIFY FOR RECONNECT.          *00900000
PCR238*  10/24/96   KOG       LIEN CODE ADDED TO RETURN VALUES -       *00910000
      *                       MATCHED SEND AND RECEIVE COLUMNS.        *00920000
      *  11/05/96   RTO       CHANGED DESC FOR DPP TO READ DEFERRED    *00930000
      *                       PAYMENT PLAN.                            *00940000
TP8019*  12/05/96   RTO       CHANGED SQL TO GET NEXT BILL DATE MORE   *00950000
TP8019*                       EFFICIENTLY ALSO CHANGED ALL CURSORS TO  *00960000
TP8019*                       FOR FETCH ONLY.                          *00970000
TP5266*   1/14/97   RTO       EXPANDED FULL-NAME TO RETURN PREFIX AND  *00980000
TP5266*                       SUFFIXES.                                *00990000
TP7920*   1/21/97   RPG       ADDED TO MODULE 2334. CHANGED THE IF STMT*01000000
TP7920*                       TO CHECK EACH CONDITION AND EITHER PRINT *01010000
TP7920*                       NOT FOUND OR ADVANCE COLLECTION          *01020000
TP8767*  02/03/97   JEP       TPR 8767 MODIFICATIONS FOR NEXT BILLING  *01030000
TP8767*                       DATE POPULATION.  ADDED REFERENCES TO    *01040000
TP8767*                       CPD00309 AND CWS00309.                   *01050000
TP9102*  02/13/97   SG        CHANGED CALCULATION OF BILLED BALANCE    *01060000
TP9102*                       FOR DFA.                                 *01070000
TP9416*  03/20/97   PP        ADDED CONTRACT TYPE TO ADVANCE COLLECTION*01080000
TP9416*                       DESCRIPTION.                             *01090000
TP9908*  03/26/97   PP        THE VALUE OF RS-MNTH-PYMT-AMT WILL BE    *01100000
TP9908*                       ZERO FOR CASH-IN-ADVANCE(CIA).           *01110000
TP9976*  03/28/97   PP        PREVENTED DUPLICATE ROWS FOR CIA.        *01120000
T9857 *  03/31/97   EMM       ADDED DCLGEN TBFINLWO FOR CPD68 CHANGES. *01130000
TP9272*  04/09/97   PD        ADDED CIA DEBIT DESC FOR PPL 70 ITEM-ID 3*01140000
T10066*  04/13/97   PP        MODIFIED SPECIAL DUE DATE FOR NSC AND NSA*01150000
T10604*  04/24/97   PD        DO NOT SEND NEXT BILL DATE IS ACCT STAT  *01160000
T10604*                       IS B OR J OR S.                          *01170000
T11063*  05/12/97   PP        REMOVED MONTHLY PAYMENT AMOUNT FOR EPP.  *01180000
T11117*  05/13/97   MJG       MOVE 0 TO ARREARS FOR FINALLED ACCOUNTS. *01190000
T11353*  05/30/97   CHANDRA   FULL NAME - ORDER CHANGED TO LAST/FIRST  *01200000
T11353*                       /MIDDLE NAMES.                           *01210000
T11466*  06/05/97   CHANDRA   COMPUTE THE PAY-OFF-AMOUNT FOR THE       *01220000
T11466*                       CONTRACTS AND SEND IT BACK.              *01230000
T11602*  06/24/97   CHANDRA   FORM A PRINT_NAME AND SEND IT BACK       *01240000
T11602*                       FOR PRINTING ON THE RECEIPT.             *01250000
PCR548*  07/08/97   PP        CANCELLED AND CLOSED CONTRACTS ARE NOT   *01260000
PCR548*                       TO BE DISPLAYED ON PANEL080.             *01270000
T12460*  08/01/97   EMS       ADD CSS_DNP DCLGEN FOR CPD68 PROCESSING  *01280000
T12607*  08/07/97   PP        TPR12607-FIXING THE PROBLEM OF DIVISION  *01290000
T12607*                       BY ZERO.                                 *01300000
T14029*  12/10/97   MKN       IF CONTRACT NOT FOUND THEN TAKE ERROR PROC01300101
T16853*  06/23/98   MDJ       ADDED INCLUDE TBARHDT FOR CPD00068.      *        
T17708*  09/15/98   SV        PROGRAM TO DISPLAY ERROR MESSAGE WHEN    *        
      *                       ABEND OCCURS WHEN ITEMID = 1 EXISTS FOR  *        
      *                       PPL'S < 50 ( eg. CONVERTED DATA)         *        
T17071*  11/18/98   MDJ       ADDED INCLUDE TBCSTALT FOR CUST_ALERT    *        
      *                       FOR CPD00068.                            *        
T17864*  12/16/98   SV        DONOT WRITE MC05 WHEN A/C NOT FOUND      *        
T17389*  08/03/99   KP        ADDED 2 FIELDS TO RESULT SET REQUIRED    *        
T17389*  PCR 652              FOR BUTTON CORR_BILL_BAL(PANEL098) ADDED *        
T17389*                       IN PANEL080.                             *        
T19557*  11/12/99   CBSI      COPYBOOK CDP00068 CHANGED TO SUB PROGRAM *        
T19557*             MADRAS    SCSCO068.                                *        
T22359*  06/23/00   ZB17046   MADE CHANGES TO KEEP IDENTITY OF PROGRAM *        
T22359*                       CALLING SCSCO068 OR SCSCB068.  THERE IS  *        
T22359*                       SPECIFIC LOGIC IN CPD00068 FOR CERTAIN   *        
T22359*                       PROGRAMS WHICH WAS NOT BEING EXECUTED    *        
T22359*                       PROPERLY BECAUSE THE PROGRAM NAME WAS    *        
T22359*                       ALWAYS SCSCO068 OR SCSCB068.             *        
C24880*  12/05/02   SRIDEVI   CHANGES RELATED TO CONNECTION CHARGES    *        
C28788*  07/03/03   mdj       get ivr-exempt-cd for cpd00068.          *        
REARCH*  05/25/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
REARCH*  09/09/05   CVNS      ADDED DUMMY FIELDS IN C1 CURSOR          *        
REARCH*             CHENNAI                                            *        
REARCH*  01/09/06   CVNS      ADDED STRIP FOR FULL_NAME IN C1 CURSOR   *        
REARCH*             CHENNAI                                            *        
C34338*  07/12/06   JAYANTHI  ADDED NEW ERROR MSG IF DPP ROW FOUND IN  *        
C34338*                       AR_CNTL BUT CORRESPONDING ACTIVE DPP NOT *        
C34338*                       FOUND IN CSS_DFA_ACCT AND PERFORMANCE    *        
C34338*                       TUNING                                   *        
C33998*  10/25/06   JG41113   ADDED WRITEOFF-FLAG FOR PANEL069         *        
C35671*  09/03/07   CVNS      NAME AND ADDRESS FORMAT CHANGES          *        
C35671*             CHENNAI                                            *        
C35187*  01/14/08   LG41184   FIX TO SEND DNP DATE TO PANEL 113.       *        
C35842*  06/11/08   LG41184   ADD ZIP_CODE TO THE RESULT SET FOR CREDIT*        
C35842*                       CARD PROJECT.                            *        
C37302*  06/30/08   LG41184   REMOVED DCLGEN TBCIAC.                   *        
A00755*  08/06/09   MJ13662   REMOVED SETTING OF CALC-DNP-BAL-SW       *        
A00755*                       BECAUSE DNP BALANCE WAS NOT BEING USED.  *        
A00755*                       THIS MEANS THAT THE AMT DNP BALANCE AKA  *        
A00755*                       S-DISC-BALANCE AKA DISC_BALANCE WILL     *        
A00755*                       ALWAYS BE A ZERO.                        *        
A00755*             RB19957   ALSO ADDED TO CHECK FOR NUMERIC ACCT #.  *        
P00453*  11/25/10   AA97148   MOVE RECV-TYPE AS 'PAY-AND-GO' FOR THE   *        
P00453*                       PAG ACCOUNTS.                            *        
P00453*  05/18/11   AA97148   REPLACED 'PAG' with 'PRP and 'PAY-AND-GO'*        
P00453*                       WITH 'PRE-PAY-PLAN'.                     *        
ACT160*  10/05/13   BD09555   correc initialization of calc-dnp-bal-sw *        
ACT160*  A04527                                                        *        
ACT278*  10/07/16   TP7R341   REMOVE UNWANTED COLUMNS FROM CONTRACT    *        
ACT278*   A05460              INFO TABLE                               *        
      ******************************************************************01310000
      ******************************************************************01320000
      *                                                                *01330000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *01340000
      *                                                                *01350000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *01360000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *01370000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *01380000
      *  3000 - 4999  NOT USED                                         *01390000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *01400000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *01410000
      *  7000 - 7999  INPUT MODULES                                    *01420000
      *  8000 - 8999  OUTPUT MODULES                                   *01430000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *01440000
      *                                                                *01450000
      ******************************************************************01460000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02021'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02021 STARTS HERE'.                  
                                                                        
      ******************************************************************01550000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01560000
      ******************************************************************01570000
                                                                        
           COPY CWS00011.                                               01660000
           COPY CWS00027.                                               01670000
           COPY CWS00056.                                               01680000
T19557     COPY CWS0068L.                                               01680000
           COPY CWS00223.                                               01690000
           COPY CWS00303.                                               01700000
                                                                        
TP8767     EXEC SQL                                                     01720000
TP8767        INCLUDE CWS00309                                          01730000
TP8767     END-EXEC.                                                    01740000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************01760000
      *    WORK AREAS                                                  *01770000
      ******************************************************************01780000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC  X(08) VALUE 'CSR02021'.    
REARCH     05  WS-SQLSTATE              PIC  X(05).                     
REARCH     05  MCSCB068                 PIC  X(08) VALUE 'MCSCB068'.    
           05  ALL-DONE-SW              PIC  X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW             PIC  X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
                                                                        
           05  WS-DATE-HOLD             PIC  X(10).                     
           05  WS-DATE-HOLD-USA         PIC  X(10).                     
           05  WS-DATE-HOLD-DB2         PIC  X(10).                     
C34338     05  WS-CURR-DT-LAST-YR       PIC  X(10).                     
C34338     05  WS-DATE-FORMAT-USA.                                      
C34338        10  WS-DATE-FMT-MM       PIC X(02).                       
C34338        10  FILLER               PIC X(01) VALUE '/'.             
C34338        10  WS-DATE-FMT-DD       PIC X(02).                       
C34338        10  FILLER               PIC X(01) VALUE '/'.             
C34338        10  WS-DATE-FMT-CCYY     PIC X(04).                       
           05  WS-NULL-INDICATOR        PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-INDICATOR1       PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-INDICATOR2       PIC S9(04) COMP VALUE +0.       
T11466     05  WS-NULL-INDICATOR4       PIC S9(04) COMP VALUE +0.       
           05  WS-FINAL-NULL-IND        PIC S9(04) COMP VALUE +0.       
           05  WS-SUB                   PIC S9(04) COMP VALUE +0.       
T34338     05  WS-ROW-COUNT             PIC S9(04) COMP VALUE +0.       
           05  WS-9999                  PIC S9(09) COMP VALUE +9999.    
           05  WS-ACCOUNT-NO            PIC  X(13).                     
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC  9(13).                     
           05  WS-ACCOUNT-NO-COMP3      PIC S9(13) COMP-3 VALUE +0.     
           05  WS-DEPOSIT-FLAG          PIC  X(01) VALUE 'N'.           
           05  WS-DATE-PYMT-START.                                      
               10  WS-DATE-PYMT-STRT-CCYY   PIC  9(04).                 
               10  FILLER REDEFINES WS-DATE-PYMT-STRT-CCYY.             
                   15  WS-DATE-PYMT-STRT-CC PIC  9(02).                 
                   15  WS-DATE-PYMT-STRT-YY PIC  9(02).                 
               10  FILLER               PIC  X(01).                     
               10  WS-DATE-PYMT-STRT-MM PIC  9(02).                     
               10  FILLER               PIC  X(01).                     
               10  WS-DATE-PYMT-STRT-DD PIC  9(02).                     
           05  WS-MO-PYMT               PIC S9(07)V99 COMP-3 VALUE +0.  
           05  WS-PYMTS-SCHED           PIC S9(04) COMP   VALUE +0.     
           05  WS-SAVE-SUB              PIC S9(04) COMP   VALUE +0.     
           05  WS-SAVE-NO-ITEMS         PIC S9(03) COMP-3 VALUE +0.     
           05  WS-NO-SCH-PMTS           PIC S9(03) COMP-3 VALUE +0.     
           05  WS-NO-SCH-PMTS2          PIC S9(03) COMP-3 VALUE +0.     
           05  WS-PMTS-REM              PIC S9(03) COMP-3 VALUE +0.     
           05  WS-AMT-BILLED-UNPAID     PIC S9(09)V99 COMP-3 VALUE +0.  
T11466     05  WS-AMT-UNBILLED-PRI      PIC S9(09)V99 COMP-3 VALUE +0.  
T11466     05  WS-NUM-OF-DAYS-FOR-INT   PIC S9(05) COMP-3    VALUE +0.  
T11466     05  WS-DAILY-INTREST       PIC S9(02)V99999 COMP-3 VALUE +0. 
T11466     05  WS-LAST-BILL-DATE        PIC X(10)   VALUE SPACES.       
T11466     05  WS-MAX-INTRST-DT         PIC X(10)   VALUE SPACES.       
T11466     05  WS-FOUND-MULT-BILLS      PIC S9(04)  COMP VALUE -840.    
           05  WS-FILLER                OCCURS 10 TIMES.                
               10  WS-ID-NO             PIC S9(09) COMP   VALUE +0.     
           05  WS-DATE-OF-CERT          PIC  X(10).                     
           05  WS-DATE-OF-CERT-RED REDEFINES WS-DATE-OF-CERT.           
               10  WS-CERT-CCYY         PIC  9(04).                     
               10  FILLER               PIC  X(01).                     
               10  WS-CERT-MM           PIC  9(02).                     
               10  FILLER               PIC  X(01).                     
               10  WS-CERT-DD           PIC  9(02).                     
           05  WS-CURRENT-DATE          PIC  X(10) VALUE SPACES.        
           05  WS-CURRENT-DATE-BREAKDOWN.                               
               10  WS-CURRENT-CCYY      PIC  9(04).                     
               10  FILLER REDEFINES WS-CURRENT-CCYY.                    
                   15  WS-CURRENT-CC    PIC  9(02).                     
                   15  WS-CURRENT-YY    PIC  9(02).                     
               10  FILLER               PIC  X(01).                     
               10  WS-CURRENT-MM        PIC  9(02).                     
               10  FILLER               PIC  X(01).                     
               10  WS-CURRENT-DD        PIC  9(02).                     
           05  WS-CURRENT-DATE-TEMP.                                    
               10  WS-CURRENT-CCYY-T    PIC  9(04).                     
               10  FILLER REDEFINES WS-CURRENT-CCYY-T.                  
                   15  WS-CURRENT-CC-T  PIC  9(02).                     
                   15  WS-CURRENT-YY-T  PIC  9(02).                     
               10  FILLER               PIC  X(01).                     
               10  WS-CURRENT-MM-T      PIC  9(02).                     
               10  FILLER               PIC  X(01).                     
               10  WS-CURRENT-DD-T      PIC  9(02).                     
                                                                        
TP5266*    05  WS-BUSINESS-NAME         PIC X(65).                      02570000
C35671     05  WS-BUSINESS-NAME         PIC X(85).                      
           05  WS-CUSTOMER-NAME REDEFINES WS-BUSINESS-NAME.             
TP5266         10  WS-CUST-PREFIX       PIC X(09).                      
T11353*        10  WS-CUST-LAST-NAME    PIC X(20).                      02600000
C35671         10  WS-CUST-LAST-NAME    PIC X(40).                      
               10  WS-CUST-FIRST-NAME   PIC X(15).                      
               10  WS-CUST-MIDDLE-NAME  PIC X(15).                      
TP5266         10  WS-CUST-SUFFIX-1     PIC X(03).                      
TP5266         10  WS-CUST-SUFFIX-2     PIC X(03).                      
           05  WS-RECORD-EXISTS         PIC X(01) VALUE 'N'.            
           05  WS-DATE-TEMP-NUM         PIC 9(09).                      
           05  WS-DATE-TEMP.                                            
               10  WS-DATE-TMP-FILLER   PIC X(03).                      
               10  WS-DATE-TMP-YY       PIC X(02).                      
               10  WS-DATE-TMP-MM       PIC X(02).                      
               10  WS-DATE-TMP-DD       PIC X(02).                      
           05  WS-DATE-REF.                                             
               10  WS-DATE-REF-CC       PIC X(02).                      
               10  WS-DATE-REF-YY       PIC X(02).                      
               10  FILLER               PIC X(01) VALUE '-'.            
               10  WS-DATE-REF-MM       PIC X(02).                      
               10  FILLER               PIC X(01) VALUE '-'.            
               10  WS-DATE-REF-DD       PIC X(02).                      
           05  WS-LIHEAP-STDT           PIC  9(4)V9(5).                 
           05  WS-RE-LIHEAP-STDT REDEFINES WS-LIHEAP-STDT.              
               10 WS-RE-LIHEAP-STMM     PIC  X(2).                      
               10 WS-RE-LIHEAP-STDD     PIC  X(2).                      
               10 FILLER                PIC  X(5).                      
            05  WS-LIHEAP-ENDT           PIC  9(4)V9(5).                
            05  WS-RE-LIHEAP-ENDT REDEFINES WS-LIHEAP-ENDT.             
                10 WS-RE-LIHEAP-ENMM     PIC  X(2).                     
                10 WS-RE-LIHEAP-ENDD     PIC  X(2).                     
                10 FILLER                PIC X(05).                     
           05  WS-YEAR-COMP              PIC S9(4) COMP.                
           05  WS-YEAR                   PIC 9(04).                     
           05  WS-RE-YEAR REDEFINES WS-YEAR PIC X(4).                   
           05  WS-HAS-UTIL               PIC X(01) VALUE SPACES.        
P00453     05  WS-PRP-IND                PIC X(01) VALUE SPACES.        
T19557     05 WS-EIBRESP                 PIC S9(8)                      
T19557                                   COMP SYNC VALUE ZERO.          
C33998     05 WS-WRITEOFF-DT             PIC X(10) VALUE SPACES.        
C33998     05 WS-WO-CUTOFF-DT            PIC 9(01)V9(5).                
C33998     05 WS-NULL-IND-CHG-AMT        PIC S9(04) COMP.               
                                                                        
       01  WS-SERVICE-ADDRESS-BREAKDOWN.                                
C35671*    05  WS-HOUSE-NO              PIC X(05).                      02940000
C35671     05  WS-HOUSE-NO              PIC X(15).                      
           05  FILLER                   PIC X(01) VALUE SPACES.         
           05  WS-PREFIX-1              PIC X(02).                      
           05  FILLER                   PIC X(01) VALUE SPACES.         
           05  WS-PREFIX-2              PIC X(03).                      
           05  FILLER                   PIC X(01) VALUE SPACES.         
C35671*    05  WS-STREET-NAME           PIC X(16).                      03000000
C35671     05  WS-STREET-NAME           PIC X(30).                      
           05  FILLER                   PIC X(01) VALUE SPACES.         
           05  WS-LOC1                  PIC X(04).                      
           05  FILLER                   PIC X(01) VALUE SPACES.         
C35671*    05  WS-LOC2                  PIC X(03).                      03040000
C35671     05  WS-LOC2                  PIC X(11).                      
           05  FILLER                   PIC X(01) VALUE SPACES.         
           05  WS-SUFFIX                PIC X(03).                      
                                                                        
       01  WS-LITERAL.                                                  
           05  DELIMITER-SPACE          PIC X(01) VALUE ' '.            
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-B                     PIC X(01) VALUE 'B'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-E                     PIC X(01) VALUE 'E'.            
           05  WS-G                     PIC X(01) VALUE 'G'.            
           05  WS-P                     PIC X(01) VALUE 'P'.            
           05  WS-S                     PIC X(01) VALUE 'S'.            
           05  WS-W                     PIC X(01) VALUE 'W'.            
           05  WS-AB                    PIC X(02) VALUE 'AB'.           
           05  WS-NSC                   PIC S9(04) VALUE +19.           
           05  WS-NSA                   PIC S9(04) VALUE +20.           
           05  WS-NSN                   PIC S9(04) VALUE +29.           
           05  WS-LPC                   PIC S9(04) VALUE +30.           
           05  WS-LPN                   PIC S9(04) VALUE +39.           
           05  WS-UTE                   PIC S9(04) VALUE +40.           
           05  WS-UTG                   PIC S9(04) VALUE +45.           
           05  WS-EPP                   PIC S9(04) VALUE +50.           
           05  WS-RCC                   PIC S9(04) VALUE +60.           
           05  WS-CIA                   PIC S9(04) VALUE +70.           
           05  WS-DEP                   PIC S9(04) VALUE +80.           
           05  WS-DFA                   PIC S9(04) VALUE +90.           
           05  WS-CNT                   PIC S9(04) VALUE +100.          
           05  WS-PJS                   PIC S9(04) VALUE +129.          
           05  WS-DPP                   PIC  X(03) VALUE 'DPP'.         
C24880     05  WS-CEC                   PIC  X(03) VALUE 'DFA'.         
           05  WS-DEF-PLAN              PIC  X(25) VALUE                
                                        'DEFERRED PAYMENT PLAN    '.    
           05  WS-NOT-FOUND             PIC  X(09) VALUE 'NOT FOUND'.   
           05  WS-LIHEAP-DATE-LIMIT     PIC  X(20) VALUE SPACES.        
           05  WS-ADV-COLL              PIC  X(11) VALUE                
                                        'ADV COLL - '.                  
           05  WS-MULTIPLE              PIC  X(10) VALUE 'MULTIPLE  '.  
                                                                        
       01  WS-NULL-IND-VARS.                                            
           05  WS-NULL-INDICATOR-1      PIC S9(04) COMP.                
           05  WS-NULL-INDICATOR-2      PIC S9(04) COMP.                
           05  WS-NULL-INDICATOR-3      PIC S9(04) COMP.                
           05  WS-NULL-INDICATOR-4      PIC S9(04) COMP.                
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                     VALUE 'SESSION.CSR02021_R1'. 
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
           05  RS-RECV-TYPE             PIC  X(03) VALUE SPACES.        
           05  RS-RECV-DESC             PIC  X(25) VALUE SPACES.        
           05  RS-PYMT-PRIORITY-LVL     PIC S9(04) COMP VALUE +0.       
           05  RS-ITEM-ID               PIC S9(09) COMP VALUE +0.       
           05  RS-SPECIAL-DUE-DATE      PIC  X(10) VALUE SPACES.        
           05  RS-UTIL-RELATED          PIC  X(01) VALUE SPACES.        
           05  RS-FULL-BALANCE          PIC S9(11)V99 COMP-3 VALUE +0.  
           05  RS-NBR-PYMTS-REMAIN      PIC S9(04) COMP VALUE +0.       
           05  RS-MNTH-PYMT-AMT         PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RS-BILLED-BALANCE        PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RS-AMT-AR-DAY-00         PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RS-AMT-AR-DAY-30         PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RS-AMT-AR-DAY-60         PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RS-AMT-AR-DAY-90         PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RS-DATE-BILL-DAY-00      PIC  X(10)      VALUE SPACES.   
           05  RS-DATE-BILL-DAY-30      PIC  X(10)      VALUE SPACES.   
           05  RS-DATE-BILL-DAY-60      PIC  X(10)      VALUE SPACES.   
           05  RS-DATE-BILL-DAY-90      PIC  X(10)      VALUE SPACES.   
           05  RS-ARREARS-DUE-DATE      PIC  X(10)      VALUE SPACES.   
           05  RS-PAST-DUE-AMOUNT       PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RS-CURRENT-DUE-DATE      PIC  X(10)      VALUE SPACES.   
           05  RS-ACCOUNT-ARREARS       PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RS-EPP-IND               PIC X(01)       VALUE SPACES.   
           05  RS-DPP-IND               PIC X(01)       VALUE SPACES.   
           05  RS-DFA-IND               PIC X(01)       VALUE SPACES.   
           05  RS-STA-IND               PIC X(01)       VALUE SPACES.   
           05  RS-CANREB-CODE-00        PIC X(01)       VALUE SPACES.   
           05  RS-CANREB-CODE-30        PIC X(01)       VALUE SPACES.   
           05  RS-CANREB-CODE-60        PIC X(01)       VALUE SPACES.   
           05  RS-CANREB-CODE-90        PIC X(01)       VALUE SPACES.   
           05  RS-AMT-DIRECT-PYMT       PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RS-CODE-PAY-AHEAD        PIC  X(01)      VALUE SPACES.   
           05  RS-ACCOUNT-NO            PIC  X(13)      VALUE SPACES.   
           05  RS-CODE-ACCT-STAT        PIC  X(01)      VALUE SPACES.   
           05  RS-ACCT-XFER-TO          PIC  X(13)      VALUE SPACES.   
           05  RS-CREDIT-GROUP          PIC  X(01)      VALUE SPACES.   
           05  RS-CASH-ONLY             PIC  X(01)      VALUE SPACES.   
           05  RS-NO-BAD-CHECKS         PIC S9(04) COMP VALUE +0.       
           05  RS-DNP-STATUS            PIC  X(02)      VALUE SPACES.   
           05  RS-CODE-BANKRUPT         PIC  X(01)      VALUE SPACES.   
           05  RS-CODE-PREPAID-MTR      PIC  X(01)      VALUE SPACES.   
           05  RS-DISC-BALANCE          PIC S9(11)V99 COMP-3 VALUE +0.  
           05  RS-DATE-DISC             PIC  X(10)      VALUE SPACES.   
           05  RS-TOTAL-AR-BALANCE      PIC S9(11)V99 COMP-3 VALUE +0.  
           05  RS-DATE-NEXT-BILL        PIC  X(10)      VALUE SPACES.   
           05  RS-CHRG-CARD-AUTH        PIC  X(01)      VALUE SPACES.   
           05  RS-DATE-LIHEAP-START.                                    
               10 RS-LIHEAP-STMM        PIC  X(2)       VALUE SPACES.   
               10 FILLER                PIC  X(1)       VALUE '/'.      
               10 RS-LIHEAP-STDD        PIC  X(2)       VALUE SPACES.   
               10 FILLER                PIC  X(1)       VALUE '/'.      
               10 RS-LIHEAP-STYY        PIC  X(4)       VALUE SPACES.   
           05  RS-DATE-LIHEAP-END.                                      
               10 RS-LIHEAP-ENMM        PIC  X(2)       VALUE SPACES.   
               10 FILLER                PIC  X(1)       VALUE '/'.      
               10 RS-LIHEAP-ENDD        PIC  X(2)       VALUE SPACES.   
               10 FILLER                PIC  X(1)       VALUE '/'.      
               10 RS-LIHEAP-ENYY        PIC  X(4)       VALUE SPACES.   
TP5266*    05  RS-FULL-NAME             PIC  X(50)      VALUE SPACES.   04410000
C35671     05  RS-FULL-NAME             PIC  X(96)      VALUE SPACES.   
C35671*    05  RS-ADDRESS               PIC  X(36)      VALUE SPACES.   04420000
C35671     05  RS-ADDRESS               PIC  X(96)      VALUE SPACES.   
           05  RS-AC-LAST-UPDATE-TS     PIC  X(26)      VALUE SPACES.   
           05  RS-AT-LAST-UPDATE-TS     PIC  X(26)      VALUE SPACES.   
           05  RS-CHRG-OFF-AR           PIC  X(01)      VALUE SPACES.   
           05  RS-AMT-TOT-RECONNECT     PIC S9(11)V99 COMP-3 VALUE +0.  
TP3437     05  RS-AMT-RCNCT-COLL        PIC S9(11)V99 COMP-3 VALUE +0.  
TP3437     05  RS-RECONNECT-IND         PIC X(01) VALUE SPACES.         
PCR238     05  RS-LIEN-CD               PIC X(01) VALUE 'N'.            
T11466     05  RS-AMT-PAYOFF            PIC S9(11)V99 COMP-3 VALUE +0.  
T11602*    05  RS-PRINT-NAME            PIC  X(65)      VALUE SPACES.   04510000
C35671     05  RS-PRINT-NAME            PIC  X(96)      VALUE SPACES.   
T12243     05  RS-CNT-LONG-DESC         PIC  X(30)      VALUE SPACES.   
T12477     05  RS-MEDICAL-FLAG          PIC  X(01)      VALUE SPACES.   
T17389     05  RS-AMT-UNUSED-CREDIT     PIC S9(09)V99 COMP-3 VALUE +0.  
T17389     05  RS-TOT-SUMM-UNBILLED     PIC S9(09)V99 COMP-3 VALUE +0.  
C33998     05  RS-WRITEOFF-FLAG         PIC  X(01)  VALUE SPACE.        
C35842     05  RS-ZIP-CODE              PIC  X(05)  VALUE SPACE.        
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(09) COMP VALUE +0.        
REARCH     05  S-RECV-TYPE             PIC  X(03) VALUE SPACES.         
REARCH     05  S-RECV-DESC             PIC  X(25) VALUE SPACES.         
REARCH     05  S-PYMT-PRIORITY-LVL     PIC S9(04) COMP VALUE +0.        
REARCH     05  S-ITEM-ID               PIC S9(09) COMP VALUE +0.        
REARCH     05  S-SPECIAL-DUE-DATE      PIC  X(10) VALUE SPACES.         
REARCH     05  S-UTIL-RELATED          PIC  X(01) VALUE SPACES.         
REARCH     05  S-FULL-BALANCE          PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-NBR-PYMTS-REMAIN      PIC S9(04) COMP VALUE +0.        
REARCH     05  S-MNTH-PYMT-AMT         PIC S9(09)V99 COMP-3 VALUE +0.   
REARCH     05  S-BILLED-BALANCE        PIC S9(09)V99 COMP-3 VALUE +0.   
REARCH     05  S-AMT-AR-DAY-00         PIC S9(09)V99 COMP-3 VALUE +0.   
REARCH     05  S-AMT-AR-DAY-30         PIC S9(09)V99 COMP-3 VALUE +0.   
REARCH     05  S-AMT-AR-DAY-60         PIC S9(09)V99 COMP-3 VALUE +0.   
REARCH     05  S-AMT-AR-DAY-90         PIC S9(09)V99 COMP-3 VALUE +0.   
REARCH     05  S-DATE-BILL-DAY-00      PIC  X(10)      VALUE SPACES.    
REARCH     05  S-DATE-BILL-DAY-30      PIC  X(10)      VALUE SPACES.    
REARCH     05  S-DATE-BILL-DAY-60      PIC  X(10)      VALUE SPACES.    
REARCH     05  S-DATE-BILL-DAY-90      PIC  X(10)      VALUE SPACES.    
REARCH     05  S-ARREARS-DUE-DATE      PIC  X(10)      VALUE SPACES.    
REARCH     05  S-PAST-DUE-AMOUNT       PIC S9(09)V99 COMP-3 VALUE +0.   
REARCH     05  S-CURRENT-DUE-DATE      PIC  X(10)      VALUE SPACES.    
REARCH     05  S-ACCOUNT-ARREARS       PIC S9(09)V99 COMP-3 VALUE +0.   
REARCH     05  S-EPP-IND               PIC X(01)       VALUE SPACES.    
REARCH     05  S-DPP-IND               PIC X(01)       VALUE SPACES.    
REARCH     05  S-DFA-IND               PIC X(01)       VALUE SPACES.    
REARCH     05  S-STA-IND               PIC X(01)       VALUE SPACES.    
REARCH     05  S-CANREB-CODE-00        PIC X(01)       VALUE SPACES.    
REARCH     05  S-CANREB-CODE-30        PIC X(01)       VALUE SPACES.    
REARCH     05  S-CANREB-CODE-60        PIC X(01)       VALUE SPACES.    
REARCH     05  S-CANREB-CODE-90        PIC X(01)       VALUE SPACES.    
REARCH     05  S-AMT-DIRECT-PYMT       PIC S9(09)V99 COMP-3 VALUE +0.   
REARCH     05  S-CODE-PAY-AHEAD        PIC  X(01)      VALUE SPACES.    
REARCH     05  S-ACCOUNT-NO            PIC  X(13)      VALUE SPACES.    
REARCH     05  S-CODE-ACCT-STAT        PIC  X(01)      VALUE SPACES.    
REARCH     05  S-ACCT-XFER-TO          PIC  X(13)      VALUE SPACES.    
REARCH     05  S-CREDIT-GROUP          PIC  X(01)      VALUE SPACES.    
REARCH     05  S-CASH-ONLY             PIC  X(01)      VALUE SPACES.    
REARCH     05  S-NO-BAD-CHECKS         PIC S9(04) COMP VALUE +0.        
REARCH     05  S-DNP-STATUS            PIC  X(02)      VALUE SPACES.    
REARCH     05  S-CODE-BANKRUPT         PIC  X(01)      VALUE SPACES.    
REARCH     05  S-CODE-PREPAID-MTR      PIC  X(01)      VALUE SPACES.    
REARCH     05  S-DISC-BALANCE          PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-DATE-DISC             PIC  X(10)      VALUE SPACES.    
REARCH     05  S-TOTAL-AR-BALANCE      PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-DATE-NEXT-BILL        PIC  X(10)      VALUE SPACES.    
REARCH     05  S-CHRG-CARD-AUTH        PIC  X(01)      VALUE SPACES.    
REARCH     05  S-DATE-LIHEAP-START     PIC  X(10)      VALUE SPACES.    
REARCH     05  S-DATE-LIHEAP-END       PIC  X(10)      VALUE SPACES.    
REARCH*    05  S-FULL-NAME             PIC  X(65)      VALUE SPACES.    04520000
C35671     05  S-FULL-NAME             PIC  X(96)      VALUE SPACES.    
REARCH*    05  S-ADDRESS               PIC  X(36)      VALUE SPACES.    04520000
C35671     05  S-ADDRESS               PIC  X(96)      VALUE SPACES.    
REARCH     05  S-AC-LAST-UPDATE-TS     PIC  X(26)      VALUE SPACES.    
REARCH     05  S-AT-LAST-UPDATE-TS     PIC  X(26)      VALUE SPACES.    
REARCH     05  S-CHRG-OFF-AR           PIC  X(01)      VALUE SPACES.    
REARCH     05  S-AMT-TOT-RECONNECT     PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-AMT-RCNCT-COLL        PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-RECONNECT-IND         PIC X(01)       VALUE SPACES.    
REARCH     05  S-LIEN-CD               PIC X(01)       VALUE 'N'.       
REARCH     05  S-AMT-PAYOFF            PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH*    05  S-PRINT-NAME            PIC  X(65)      VALUE SPACES.    04520000
C35671     05  S-PRINT-NAME            PIC  X(96)      VALUE SPACES.    
REARCH     05  S-CNT-LONG-DESC         PIC  X(30)      VALUE SPACES.    
REARCH     05  S-MEDICAL-FLAG          PIC  X(01)      VALUE SPACES.    
REARCH     05  S-AMT-UNUSED-CREDIT     PIC S9(09)V99 COMP-3 VALUE +0.   
REARCH     05  S-TOT-SUMM-UNBILLED     PIC S9(09)V99 COMP-3 VALUE +0.   
C33998     05  S-WRITEOFF-FLAG         PIC  X(01)      VALUE SPACES.    
C35842     05  S-ZIP-CODE              PIC  X(05)      VALUE SPACES.    
REARCH*                                                                 04520000
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
REARCH*                                                                         
           EXEC SQL                                                     05740000
              INCLUDE SQLCA                                             05750000
           END-EXEC.                                                    05760000
                                                                        
           EXEC SQL                                                     05780000
              INCLUDE TBACCT                                            05790000
           END-EXEC.                                                    05800000
      *                                                                         
           EXEC SQL                                                     05820000
              INCLUDE TBARCNTL                                          05830000
           END-EXEC.                                                    05840000
                                                                        
           EXEC SQL                                                     05860000
              INCLUDE TBCRCOLL                                          05870000
           END-EXEC.                                                    05880000
                                                                        
           EXEC SQL                                                     05940000
              INCLUDE TBPRJSHR                                          05990000
           END-EXEC.                                                    05960000
                                                                        
           EXEC SQL                                                     06020000
              INCLUDE TBCNTRCT                                          06030000
           END-EXEC.                                                    06040000
                                                                        
           EXEC SQL                                                     06060000
              INCLUDE TBCNTINF                                          06070000
           END-EXEC.                                                    06080000
                                                                        
           EXEC SQL                                                     06100000
              INCLUDE TBDFAACT                                          06110000
           END-EXEC.                                                    06120000
                                                                        
           EXEC SQL                                                     06140000
              INCLUDE TBDEPREQ                                          06150000
           END-EXEC.                                                    06160000
                                                                        
           EXEC SQL                                                     06220000
              INCLUDE TBCCCHRG                                          06230000
           END-EXEC.                                                    06240000
                                                                        
           EXEC SQL                                                     06300000
              INCLUDE TBARTYPE                                          06310000
           END-EXEC.                                                    06320000
                                                                        
           EXEC SQL                                                     06340000
              INCLUDE TBCUST                                            06350000
           END-EXEC.                                                    06360000
                                                                        
           EXEC SQL                                                     06380000
              INCLUDE TBPREM                                            06390000
           END-EXEC.                                                    06400000
                                                                        
           EXEC SQL                                                     06420000
              INCLUDE TBNSFHST                                          06430000
           END-EXEC.                                                    06440000
                                                                        
           EXEC SQL                                                     06460000
              INCLUDE TBBILWDW                                          06470000
           END-EXEC.                                                    06480000
                                                                        
           EXEC SQL                                                     06500000
              INCLUDE TBNAME                                            06510000
           END-EXEC.                                                    06520000
                                                                        
           EXEC SQL                                                     06540000
              INCLUDE TBADRFMT                                          06550000
           END-EXEC.                                                    06560000
                                                                        
           EXEC SQL                                                     06580000
              INCLUDE TBCRPROF                                          06590000
           END-EXEC.                                                    06600000
                                                                        
           EXEC SQL                                                     06620000
              INCLUDE TBCHGOFF                                          06630000
           END-EXEC.                                                    06640000
                                                                        
           EXEC SQL                                                     06660000
              INCLUDE TBRECNCT                                          06670000
           END-EXEC.                                                    06680000
                                                                        
C24880     EXEC SQL                                                     06660000
C24880        INCLUDE TBCHGTYP                                          06670000
C24880     END-EXEC.                                                    06680000
                                                                        
C33998     EXEC SQL                                                     06660000
C33998        INCLUDE TBDELQ                                            06670000
C33998     END-EXEC.                                                    06680000
                                                                        
           EXEC SQL                                                     06820000
              INCLUDE CWS00068                                          06830000
           END-EXEC.                                                    06890000
                                                                        
           EXEC SQL                                                     
               DECLARE MTH-CRE-CURSOR CURSOR FOR                        
                 SELECT AMT_MO_PYMT,                                    
                        CODE_BILL_TYPE,                                 
                        CNT_ITEM_ID,                                    
                        PYMT_PRIORITY_LVL,                              
                        CODE_CONTRACT_TYPE,                             
                        CNT_NAME_CD,                                    
                        DATE_PYMT_START,                                
                        CODE_INTRST_METH,                               
                        INTRST_PRIOR_YR,                                
                        NO_SCHED_PYMTS,                                 
                        AMT_ORIG_ENTERED                                
                 FROM   CSS_CONTRACT WITH(READUNCOMMITTED)                      
                 WHERE  ACCOUNT_NO     = :CT-ACCOUNT-NO                 
ECC                 AND CODE_BILL_TYPE = 'E'                            
PCR548*             AND CNT_STATUS_CD NOT IN ('D','E')                  07080000
C34338              AND CNT_STATUS_CD IN ('A','B','C','R','P','F')      
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06920000
MFA-TR*        DECLARE MTH-CRE-CURSOR CURSOR FOR                        06930000
MFA-TR*          SELECT AMT_MO_PYMT,                                    06940000
MFA-TR*                 CODE_BILL_TYPE,                                 06950000
MFA-TR*                 CNT_ITEM_ID,                                    06960000
MFA-TR*                 PYMT_PRIORITY_LVL,                              06970000
MFA-TR*                 CODE_CONTRACT_TYPE,                             06980000
MFA-TR*                 CNT_NAME_CD,                                    06990000
MFA-TR*                 DATE_PYMT_START,                                07000000
MFA-TR*                 CODE_INTRST_METH,                               07010000
MFA-TR*                 INTRST_PRIOR_YR,                                07020000
MFA-TR*                 NO_SCHED_PYMTS,                                 07030000
MFA-TR*                 AMT_ORIG_ENTERED                                07040000
MFA-TR*          FROM   CSS_CONTRACT                                    07050000
MFA-TR*          WHERE  ACCOUNT_NO     = :CT-ACCOUNT-NO                 07060000
MFA-TR*             AND CODE_BILL_TYPE = 'E'                            07070000
MFA-TR*             AND CNT_STATUS_CD NOT IN ('D','E')                  07080000
MFA-TR*             AND CNT_STATUS_CD IN ('A','B','C','R','P','F')      07080000
MFA-TR*          FOR FETCH ONLY WITH UR                                 07090000
MFA-TR*    END-EXEC.                                                    07100000
                                                                        
           EXEC SQL                                                     
               DECLARE AR_CNTRL_CURSOR CURSOR FOR                       
                 SELECT PYMT_PRIORITY_LVL,                              
                        ITEM_ID,                                        
                        AMT_AR_DAY_00,                                  
                        AMT_AR_DAY_30,                                  
                        AMT_AR_DAY_60,                                  
                        AMT_AR_DAY_90,                                  
                        AMT_TRAN_BALANCE,                               
                        AMT_UNUSED_CR,                                  
                        TOT_SUMM_UNBILLED,                              
                        REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                   FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                       
                  WHERE ACCOUNT_NO         = :AC-ACCOUNT-NO             
                  AND   PYMT_PRIORITY_LVL >= :AC-PYMT-PRIORITY-LVL      
                  AND   ITEM_ID           >= :AC-ITEM-ID                
               ORDER BY PYMT_PRIORITY_LVL ASC,                          
                        ITEM_ID ASC                                     
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     07120000
MFA-TR*        DECLARE AR_CNTRL_CURSOR CURSOR FOR                       07130000
MFA-TR*          SELECT PYMT_PRIORITY_LVL,                              07140000
MFA-TR*                 ITEM_ID,                                        07150000
MFA-TR*                 AMT_AR_DAY_00,                                  07160000
MFA-TR*                 AMT_AR_DAY_30,                                  07170000
MFA-TR*                 AMT_AR_DAY_60,                                  07180000
MFA-TR*                 AMT_AR_DAY_90,                                  07190000
MFA-TR*                 AMT_TRAN_BALANCE,                               07200000
MFA-TR*                 AMT_UNUSED_CR,                                  07210000
MFA-TR*                 TOT_SUMM_UNBILLED,                              07220000
MFA-TR*                 LAST_UPDATE_TS                                  07230000
MFA-TR*            FROM CSS_AR_CNTL                                     07240000
MFA-TR*           WHERE ACCOUNT_NO         = :AC-ACCOUNT-NO             07250000
MFA-TR*           AND   PYMT_PRIORITY_LVL >= :AC-PYMT-PRIORITY-LVL      07260000
MFA-TR*           AND   ITEM_ID           >= :AC-ITEM-ID                07270000
MFA-TR*        ORDER BY PYMT_PRIORITY_LVL ASC,                          07280000
MFA-TR*                 ITEM_ID ASC                                     07290000
MFA-TR*        FOR FETCH ONLY WITH UR                                   07300000
MFA-TR*    END-EXEC.                                                    07310000
                                                                        
           EXEC SQL                                                     
               DECLARE CHRG_OFF CURSOR FOR                              
                   SELECT PYMT_PRIORITY_LVL,                            
                          ITEM_ID,                                      
                          AMT_TRANS                                     
                   FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                      
                   WHERE  ACCOUNT_NO         =  :CO-ACCOUNT-NO          
                   AND    PYMT_PRIORITY_LVL >=  :CO-PYMT-PRIORITY-LVL   
                   AND    ITEM_ID           >=  :CO-ITEM-ID             
                   ORDER BY PYMT_PRIORITY_LVL ASC,                      
                            ITEM_ID ASC                                 
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07330000
MFA-TR*        DECLARE CHRG_OFF CURSOR FOR                              07340000
MFA-TR*            SELECT PYMT_PRIORITY_LVL,                            07350000
MFA-TR*                   ITEM_ID,                                      07360000
MFA-TR*                   AMT_TRANS                                     07370000
MFA-TR*            FROM CSS_CHRG_OFF                                    07380000
MFA-TR*            WHERE  ACCOUNT_NO         =  :CO-ACCOUNT-NO          07390000
MFA-TR*            AND    PYMT_PRIORITY_LVL >=  :CO-PYMT-PRIORITY-LVL   07400000
MFA-TR*            AND    ITEM_ID           >=  :CO-ITEM-ID             07410000
MFA-TR*            ORDER BY PYMT_PRIORITY_LVL ASC,                      07420000
MFA-TR*                     ITEM_ID ASC                                 07430000
MFA-TR*        FOR FETCH ONLY WITH UR                                   07440000
MFA-TR*    END-EXEC.                                                    07450000
                                                                        
T10066     EXEC SQL                                                     
T10066         DECLARE CRED_COLL CURSOR FOR                             
T10066          SELECT CIS.CHAR2$DATE(DATE_NOTICE_DUE,'USA')                    
T10066            FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                      
T10066          WHERE  ACCOUNT_NO        = :CL-ACCOUNT-NO               
T10066            AND  CODE_MESSAGE_TYPE = 90206                        
T10066            AND  ITEM_ID           = 0                            
T10066         FOR READ ONLY                                    
T10066     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     07470000
MFA-TR*        DECLARE CRED_COLL CURSOR FOR                             07480000
MFA-TR*         SELECT CHAR(DATE_NOTICE_DUE,USA)                        07490000
MFA-TR*           FROM CSS_CRED_COLL                                    07500000
MFA-TR*         WHERE  ACCOUNT_NO        = :CL-ACCOUNT-NO               07510000
MFA-TR*           AND  CODE_MESSAGE_TYPE = 90206                        07520000
MFA-TR*           AND  ITEM_ID           = 0                            07530000
MFA-TR*        FOR FETCH ONLY WITH UR                                   07540000
MFA-TR*    END-EXEC.                                                    07550000
REARCH*                                                                 07560000
t19557 LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO          PIC  X(13).                         
REARCH 01  PARM-DNP-TYPE            PIC  X(01).                         
C34338 01  PARM-NAME-REQ            PIC  X(01).                         
REARCH*                                                                         
HPCCDM*EJECT                                                                    
REARCH PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
REARCH                           PARM-DNP-TYPE                          
C34338                           PARM-NAME-REQ.                         
REARCH*                                                                 07590000
      ******************************************************************07600000
      * 0000-MAINLINE                                                  *07610000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *07620000
      ******************************************************************07630000
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07730000
      * 0100-INITIALIZE                                                *07740000
      *                                                                *07750000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *07760000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *07770000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*07780000
      *                                                                *07790000
      ******************************************************************07800000
                                                                        
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
REARCH*                                                                 07930000
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH        DECLARE C1 CURSOR  FOR                         
REARCH        SELECT  RETURN_CODE                                       
REARCH               ,RECV_TYPE                                         
REARCH               ,RECV_DESC                                         
REARCH               ,PYMT_PRIORITY_LVL                                 
REARCH               ,ITEM_ID                                           
REARCH               ,SPECIAL_DUE_DATE                                  
REARCH               ,UTIL_RELATED                                      
REARCH               ,FULL_BALANCE                                      
REARCH               ,NBR_PYMTS_REMAIN                                  
REARCH               ,MNTH_PYMT_AMT                                     
REARCH               ,BILLED_BALANCE                                    
REARCH               ,AMT_AR_DAY_00                                     
REARCH               ,AMT_AR_DAY_30                                     
REARCH               ,AMT_AR_DAY_60                                     
REARCH               ,AMT_AR_DAY_90                                     
REARCH               ,DATE_BILL_DAY_00                                  
REARCH               ,DATE_BILL_DAY_30                                  
REARCH               ,DATE_BILL_DAY_60                                  
REARCH               ,DATE_BILL_DAY_90                                  
REARCH               ,ARREARS_DUE_DATE                                  
REARCH               ,PAST_DUE_AMOUNT                                   
REARCH               ,CURRENT_DUE_DATE                                  
REARCH               ,ACCOUNT_ARREARS                                   
REARCH               ,EPP_IND                                           
REARCH               ,DPP_IND                                           
REARCH               ,DFA_IND                                           
REARCH               ,STA_IND                                           
REARCH               ,CANREB_CODE_00                                    
REARCH               ,CANREB_CODE_30                                    
REARCH               ,CANREB_CODE_60                                    
REARCH               ,CANREB_CODE_90                                    
REARCH               ,AMT_DIRECT_PYMT                                   
REARCH               ,CODE_PAY_AHEAD                                    
REARCH               ,ACCOUNT_NO                                        
REARCH               ,CODE_ACCT_STAT                                    
REARCH               ,ACCT_XFER_TO                                      
REARCH               ,CREDIT_GROUP                                      
REARCH               ,CASH_ONLY                                         
REARCH               ,NO_BAD_CHECKS                                     
REARCH               ,DNP_STATUS                                        
REARCH               ,CODE_BANKRUPT                                     
REARCH               ,CODE_PREPAID_MTR                                  
REARCH               ,DISC_BALANCE                                      
REARCH               ,DATE_DISC                                         
REARCH               ,TOTAL_AR_BALANCE                                  
REARCH               ,DATE_NEXT_BILL                                    
REARCH               ,CHRG_CARD_AUTH                                    
REARCH               ,DATE_LIHEAP_START                                 
REARCH               ,DATE_LIHEAP_END                                   
REARCH               ,LTRIM(RTRIM(FULL_NAME))           AS FULL_NAME           
REARCH               ,LTRIM(RTRIM(ADDRESS))             AS ADDRESS             
REARCH               ,AC_LAST_UPDATE_TS                                 
REARCH               ,AT_LAST_UPDATE_TS                                 
REARCH               ,CHRG_OFF_AR                                       
REARCH               ,AMT_TOT_RECONNECT                                 
REARCH               ,AMT_RCNCT_COLL                                    
REARCH               ,RECONNECT_IND                                     
REARCH               ,LIEN_CD                                           
REARCH               ,AMT_PAYOFF                                        
REARCH               ,PRINT_NAME                                        
REARCH               ,CNT_LONG_DESC                                     
REARCH               ,MEDICAL_FLAG                                      
REARCH               ,AMT_UNUSED_CREDIT                                 
REARCH               ,TOT_SUMM_UNBILLED                                 
C33998               ,WRITEOFF_FLAG                                     
REARCH               ,' '     AS DUMMY1                                 
REARCH               ,0       AS DUMMY2                                 
C35842               ,ZIP_CODE                                          
REARCH        FROM                                                      
REARCH            #CSR02021_R1                                   
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT  RETURN_CODE                                               
MFA-TR*              ,RECV_TYPE                                                 
MFA-TR*              ,RECV_DESC                                                 
MFA-TR*              ,PYMT_PRIORITY_LVL                                         
MFA-TR*              ,ITEM_ID                                                   
MFA-TR*              ,SPECIAL_DUE_DATE                                          
MFA-TR*              ,UTIL_RELATED                                              
MFA-TR*              ,FULL_BALANCE                                              
MFA-TR*              ,NBR_PYMTS_REMAIN                                          
MFA-TR*              ,MNTH_PYMT_AMT                                             
MFA-TR*              ,BILLED_BALANCE                                            
MFA-TR*              ,AMT_AR_DAY_00                                             
MFA-TR*              ,AMT_AR_DAY_30                                             
MFA-TR*              ,AMT_AR_DAY_60                                             
MFA-TR*              ,AMT_AR_DAY_90                                             
MFA-TR*              ,DATE_BILL_DAY_00                                          
MFA-TR*              ,DATE_BILL_DAY_30                                          
MFA-TR*              ,DATE_BILL_DAY_60                                          
MFA-TR*              ,DATE_BILL_DAY_90                                          
MFA-TR*              ,ARREARS_DUE_DATE                                          
MFA-TR*              ,PAST_DUE_AMOUNT                                           
MFA-TR*              ,CURRENT_DUE_DATE                                          
MFA-TR*              ,ACCOUNT_ARREARS                                           
MFA-TR*              ,EPP_IND                                                   
MFA-TR*              ,DPP_IND                                                   
MFA-TR*              ,DFA_IND                                                   
MFA-TR*              ,STA_IND                                                   
MFA-TR*              ,CANREB_CODE_00                                            
MFA-TR*              ,CANREB_CODE_30                                            
MFA-TR*              ,CANREB_CODE_60                                            
MFA-TR*              ,CANREB_CODE_90                                            
MFA-TR*              ,AMT_DIRECT_PYMT                                           
MFA-TR*              ,CODE_PAY_AHEAD                                            
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,CODE_ACCT_STAT                                            
MFA-TR*              ,ACCT_XFER_TO                                              
MFA-TR*              ,CREDIT_GROUP                                              
MFA-TR*              ,CASH_ONLY                                                 
MFA-TR*              ,NO_BAD_CHECKS                                             
MFA-TR*              ,DNP_STATUS                                                
MFA-TR*              ,CODE_BANKRUPT                                             
MFA-TR*              ,CODE_PREPAID_MTR                                          
MFA-TR*              ,DISC_BALANCE                                              
MFA-TR*              ,DATE_DISC                                                 
MFA-TR*              ,TOTAL_AR_BALANCE                                          
MFA-TR*              ,DATE_NEXT_BILL                                            
MFA-TR*              ,CHRG_CARD_AUTH                                            
MFA-TR*              ,DATE_LIHEAP_START                                         
MFA-TR*              ,DATE_LIHEAP_END                                           
MFA-TR*              ,STRIP(FULL_NAME)           AS FULL_NAME                   
MFA-TR*              ,STRIP(ADDRESS)             AS ADDRESS                     
MFA-TR*              ,AC_LAST_UPDATE_TS                                         
MFA-TR*              ,AT_LAST_UPDATE_TS                                         
MFA-TR*              ,CHRG_OFF_AR                                               
MFA-TR*              ,AMT_TOT_RECONNECT                                         
MFA-TR*              ,AMT_RCNCT_COLL                                            
MFA-TR*              ,RECONNECT_IND                                             
MFA-TR*              ,LIEN_CD                                                   
MFA-TR*              ,AMT_PAYOFF                                                
MFA-TR*              ,PRINT_NAME                                                
MFA-TR*              ,CNT_LONG_DESC                                             
MFA-TR*              ,MEDICAL_FLAG                                              
MFA-TR*              ,AMT_UNUSED_CREDIT                                         
MFA-TR*              ,TOT_SUMM_UNBILLED                                         
MFA-TR*              ,WRITEOFF_FLAG                                             
MFA-TR*              ,' '     AS DUMMY1                                         
MFA-TR*              ,0       AS DUMMY2                                         
MFA-TR*              ,ZIP_CODE                                                  
MFA-TR*       FROM                                                              
MFA-TR*           SESSION.CSR02021_R1                                           
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************07730000
REARCH* 0100A-DECLARE-GTT                                              *07740000
REARCH******************************************************************07800000
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02021_R1'            
REARCH                               TO S-SQL-STATEMENT-V.              
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02021_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02021_R1
              (                                                       
REARCH               RETURN_CODE            INT                     
REARCH              ,RECV_TYPE CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH              ,RECV_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH              ,PYMT_PRIORITY_LVL      SMALLINT                    
REARCH              ,ITEM_ID                INT                     
REARCH              ,SPECIAL_DUE_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,UTIL_RELATED CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,FULL_BALANCE           DECIMAL(13,2)               
REARCH              ,NBR_PYMTS_REMAIN       SMALLINT                    
REARCH              ,MNTH_PYMT_AMT          DECIMAL(11,2)               
REARCH              ,BILLED_BALANCE         DECIMAL(11,2)               
REARCH              ,AMT_AR_DAY_00          DECIMAL(11,2)               
REARCH              ,AMT_AR_DAY_30          DECIMAL(11,2)               
REARCH              ,AMT_AR_DAY_60          DECIMAL(11,2)               
REARCH              ,AMT_AR_DAY_90          DECIMAL(11,2)               
REARCH              ,DATE_BILL_DAY_00 CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,DATE_BILL_DAY_30 CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,DATE_BILL_DAY_60 CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,DATE_BILL_DAY_90 CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,ARREARS_DUE_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,PAST_DUE_AMOUNT        DECIMAL(11,2)               
REARCH              ,CURRENT_DUE_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,ACCOUNT_ARREARS        DECIMAL(11,2)               
REARCH              ,EPP_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH              ,DPP_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH              ,DFA_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH              ,STA_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH              ,CANREB_CODE_00 CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CANREB_CODE_30 CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CANREB_CODE_60 CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CANREB_CODE_90 CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,AMT_DIRECT_PYMT        DECIMAL(11,2)               
REARCH              ,CODE_PAY_AHEAD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,ACCOUNT_NO CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CODE_ACCT_STAT CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,ACCT_XFER_TO CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CREDIT_GROUP CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CASH_ONLY CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH              ,NO_BAD_CHECKS          SMALLINT                    
REARCH              ,DNP_STATUS CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CODE_BANKRUPT CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CODE_PREPAID_MTR CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,DISC_BALANCE           DECIMAL(13,2)               
REARCH              ,DATE_DISC CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH              ,TOTAL_AR_BALANCE       DECIMAL(13,2)               
REARCH              ,DATE_NEXT_BILL CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CHRG_CARD_AUTH CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,DATE_LIHEAP_START CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,DATE_LIHEAP_END CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH*             ,FULL_NAME              CHAR(65)                            
C35671              ,FULL_NAME CHAR(96)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH*             ,ADDRESS                CHAR(36)                            
C35671              ,ADDRESS CHAR(96)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH              ,AC_LAST_UPDATE_TS CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,AT_LAST_UPDATE_TS CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CHRG_OFF_AR CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,AMT_TOT_RECONNECT      DECIMAL(13,2)               
REARCH              ,AMT_RCNCT_COLL         DECIMAL(13,2)               
REARCH              ,RECONNECT_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,LIEN_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH              ,AMT_PAYOFF             DECIMAL(13,2)               
REARCH*             ,PRINT_NAME             CHAR(65)                            
C35671              ,PRINT_NAME CHAR(96)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CNT_LONG_DESC CHAR(30)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,MEDICAL_FLAG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,AMT_UNUSED_CREDIT      DECIMAL(11,2)               
REARCH              ,TOT_SUMM_UNBILLED      DECIMAL(11,2)               
C33998              ,WRITEOFF_FLAG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
C35842              ,ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH     MOVE SQLSTATE              TO WS-SQLSTATE.                   
REARCH     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
REARCH*                                                                         
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH*       PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT                     
JAYFIX        CONTINUE                                                  
REARCH     ELSE                                                         
REARCH        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH         MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
REARCH         MOVE SQLCODE            TO ABEND-SQLCODE                 
REARCH         MOVE SQLSTATE           TO ABEND-SQLSTATE                
REARCH         MOVE '0100A'            TO ACTIVE-PARAGRAPH              
REARCH         MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                
REARCH         MOVE SPACES             TO ABEND-SQL-PREDICATES          
REARCH                                     ABEND-TABLES                 
REARCH         MOVE 'CSR02021_R1'      TO TABLE-1                       
REARCH         MOVE SPACES             TO TABLE-ELEMENT-1               
REARCH         MOVE SPACES             TO HOSTVAR-ELEMENT-1             
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                 THRU  9900-EXIT                  
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
                                                                        
      ******************************************************************08470000
      * 2000-PROCESS-OUTPUT.                                           *08480000
      *                                                                *08490000
      *     1. DESCRIBE RESULT SET                                     *08500000
      *     2. UPDATE DB2 DATA                                         *08510000
      *     3. BUILD RESULT SET                                        *08520000
      *     4. SEND RESULT SET                                         *08530000
      *                                                                *08540000
      ******************************************************************08550000
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2200-PROCESS-DETAIL THRU 2200-EXIT.                  
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************07730000
REARCH* 2000A-MOVE-RESULT                                              *07740000
REARCH******************************************************************07800000
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE        TO  S-RETURN-CODE.                
REARCH     MOVE RS-RECV-TYPE          TO  S-RECV-TYPE.                  
REARCH     MOVE RS-RECV-DESC          TO  S-RECV-DESC.                  
REARCH     MOVE RS-PYMT-PRIORITY-LVL  TO  S-PYMT-PRIORITY-LVL.          
REARCH     MOVE RS-ITEM-ID            TO  S-ITEM-ID.                    
REARCH     MOVE RS-SPECIAL-DUE-DATE   TO  S-SPECIAL-DUE-DATE.           
REARCH     MOVE RS-UTIL-RELATED       TO  S-UTIL-RELATED.               
REARCH     MOVE RS-FULL-BALANCE       TO  S-FULL-BALANCE.               
REARCH     MOVE RS-NBR-PYMTS-REMAIN   TO  S-NBR-PYMTS-REMAIN.           
REARCH     MOVE RS-MNTH-PYMT-AMT      TO  S-MNTH-PYMT-AMT.              
REARCH     MOVE RS-BILLED-BALANCE     TO  S-BILLED-BALANCE.             
REARCH     MOVE RS-AMT-AR-DAY-00      TO  S-AMT-AR-DAY-00.              
REARCH     MOVE RS-AMT-AR-DAY-30      TO  S-AMT-AR-DAY-30.              
REARCH     MOVE RS-AMT-AR-DAY-60      TO  S-AMT-AR-DAY-60.              
REARCH     MOVE RS-AMT-AR-DAY-90      TO  S-AMT-AR-DAY-90.              
REARCH     MOVE RS-DATE-BILL-DAY-00   TO  S-DATE-BILL-DAY-00.           
REARCH     MOVE RS-DATE-BILL-DAY-30   TO  S-DATE-BILL-DAY-30.           
REARCH     MOVE RS-DATE-BILL-DAY-60   TO  S-DATE-BILL-DAY-60.           
REARCH     MOVE RS-DATE-BILL-DAY-90   TO  S-DATE-BILL-DAY-90.           
REARCH     MOVE RS-ARREARS-DUE-DATE   TO  S-ARREARS-DUE-DATE.           
REARCH     MOVE RS-PAST-DUE-AMOUNT    TO  S-PAST-DUE-AMOUNT.            
REARCH     MOVE RS-CURRENT-DUE-DATE   TO  S-CURRENT-DUE-DATE.           
REARCH     MOVE RS-ACCOUNT-ARREARS    TO  S-ACCOUNT-ARREARS.            
REARCH     MOVE RS-EPP-IND            TO  S-EPP-IND.                    
REARCH     MOVE RS-DPP-IND            TO  S-DPP-IND.                    
REARCH     MOVE RS-DFA-IND            TO  S-DFA-IND.                    
REARCH     MOVE RS-STA-IND            TO  S-STA-IND.                    
REARCH     MOVE RS-CANREB-CODE-00     TO  S-CANREB-CODE-00.             
REARCH     MOVE RS-CANREB-CODE-30     TO  S-CANREB-CODE-30.             
REARCH     MOVE RS-CANREB-CODE-60     TO  S-CANREB-CODE-60.             
REARCH     MOVE RS-CANREB-CODE-90     TO  S-CANREB-CODE-90.             
REARCH     MOVE RS-AMT-DIRECT-PYMT    TO  S-AMT-DIRECT-PYMT.            
REARCH     MOVE RS-CODE-PAY-AHEAD     TO  S-CODE-PAY-AHEAD.             
REARCH     MOVE RS-ACCOUNT-NO         TO  S-ACCOUNT-NO.                 
REARCH     MOVE RS-CODE-ACCT-STAT     TO  S-CODE-ACCT-STAT.             
REARCH     MOVE RS-ACCT-XFER-TO       TO  S-ACCT-XFER-TO.               
REARCH     MOVE RS-CREDIT-GROUP       TO  S-CREDIT-GROUP.               
REARCH     MOVE RS-CASH-ONLY          TO  S-CASH-ONLY.                  
REARCH     MOVE RS-NO-BAD-CHECKS      TO  S-NO-BAD-CHECKS.              
REARCH     MOVE RS-DNP-STATUS         TO  S-DNP-STATUS.                 
REARCH     MOVE RS-CODE-BANKRUPT      TO  S-CODE-BANKRUPT.              
REARCH     MOVE RS-CODE-PREPAID-MTR   TO  S-CODE-PREPAID-MTR.           
REARCH     MOVE RS-DISC-BALANCE       TO  S-DISC-BALANCE.               
REARCH     MOVE RS-DATE-DISC          TO  S-DATE-DISC.                  
REARCH     MOVE RS-TOTAL-AR-BALANCE   TO  S-TOTAL-AR-BALANCE.           
REARCH     MOVE RS-DATE-NEXT-BILL     TO  S-DATE-NEXT-BILL.             
REARCH     MOVE RS-CHRG-CARD-AUTH     TO  S-CHRG-CARD-AUTH.             
REARCH     MOVE RS-DATE-LIHEAP-START  TO  S-DATE-LIHEAP-START.          
REARCH     MOVE RS-DATE-LIHEAP-END    TO  S-DATE-LIHEAP-END.            
REARCH     MOVE RS-FULL-NAME          TO  S-FULL-NAME.                  
REARCH     MOVE RS-ADDRESS            TO  S-ADDRESS.                    
REARCH     MOVE RS-AC-LAST-UPDATE-TS  TO  S-AC-LAST-UPDATE-TS.          
REARCH     MOVE RS-AT-LAST-UPDATE-TS  TO  S-AT-LAST-UPDATE-TS.          
REARCH     MOVE RS-CHRG-OFF-AR        TO  S-CHRG-OFF-AR.                
REARCH     MOVE RS-AMT-TOT-RECONNECT  TO  S-AMT-TOT-RECONNECT.          
REARCH     MOVE RS-AMT-RCNCT-COLL     TO  S-AMT-RCNCT-COLL.             
REARCH     MOVE RS-RECONNECT-IND      TO  S-RECONNECT-IND.              
REARCH     MOVE RS-LIEN-CD            TO  S-LIEN-CD.                    
REARCH     MOVE RS-AMT-PAYOFF         TO  S-AMT-PAYOFF.                 
REARCH     MOVE RS-PRINT-NAME         TO  S-PRINT-NAME.                 
REARCH     MOVE RS-CNT-LONG-DESC      TO  S-CNT-LONG-DESC.              
REARCH     MOVE RS-MEDICAL-FLAG       TO  S-MEDICAL-FLAG.               
REARCH     MOVE RS-AMT-UNUSED-CREDIT  TO  S-AMT-UNUSED-CREDIT.          
REARCH     MOVE RS-TOT-SUMM-UNBILLED  TO  S-TOT-SUMM-UNBILLED.          
C33998     MOVE RS-WRITEOFF-FLAG      TO  S-WRITEOFF-FLAG.              
C35842     MOVE RS-ZIP-CODE           TO  S-ZIP-CODE.                   
REARCH*                                                                 08700000
REARCH 2000A-EXIT.                                                      
REARCH      EXIT.                                                       
                                                                        
       2200-PROCESS-DETAIL.                                             
           MOVE PARM-ACCOUNT-NO     TO WS-ACCOUNT-NO.                   
A00755     IF WS-ACCOUNT-NO NOT NUMERIC                                 
A00755        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A00755        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A00755        MOVE '2200'                TO ACTIVE-PARAGRAPH            
A00755        MOVE 'MOVE '               TO ABEND-FUNCTION              
A00755        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A00755                                      ABEND-TABLES                
A00755        MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
A00755        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A00755        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A00755        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A00755     END-IF.                                                      
           MOVE WS-ACCOUNT-NO-NUM   TO WS-ACCOUNT-NO-COMP3.             
           MOVE WS-ACCOUNT-NO-COMP3 TO AT-ACCOUNT-NO.                   
           MOVE PARM-ACCOUNT-NO     TO RS-ACCOUNT-NO.                   
      ***********                                                       22030000
      * GET INFORMATION FROM ACCOUNT TABLE                              22040000
      ***********                                                       22050000
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           MOVE AT-LAST-UPDATE-TS    TO RS-AT-LAST-UPDATE-TS.           
                                                                        
           IF AT-DATE-BILL-DAY-00 NOT EQUAL LOW-VALUES                  
C34338         IF AT-DATE-BILL-DAY-00 > SPACES                          
C34338            MOVE AT-DATE-BILL-DAY-00(1:4) TO WS-DATE-FMT-CCYY     
C34338            MOVE AT-DATE-BILL-DAY-00(6:2) TO WS-DATE-FMT-MM       
C34338            MOVE AT-DATE-BILL-DAY-00(9:2) TO WS-DATE-FMT-DD       
C34338            MOVE WS-DATE-FORMAT-USA       TO RS-DATE-BILL-DAY-00  
C34338         ELSE                                                     
C34338            MOVE SPACES                   TO RS-DATE-BILL-DAY-00  
C34338         END-IF                                                   
           END-IF.                                                      
                                                                        
           IF AT-DATE-BILL-DAY-30 NOT EQUAL LOW-VALUES                  
C34338         IF AT-DATE-BILL-DAY-30 > SPACES                          
C34338           MOVE AT-DATE-BILL-DAY-30(1:4)  TO WS-DATE-FMT-CCYY     
C34338           MOVE AT-DATE-BILL-DAY-30(6:2)  TO WS-DATE-FMT-MM       
C34338           MOVE AT-DATE-BILL-DAY-30(9:2)  TO WS-DATE-FMT-DD       
C34338           MOVE WS-DATE-FORMAT-USA        TO RS-DATE-BILL-DAY-30  
C34338         ELSE                                                     
C34338           MOVE SPACES                    TO RS-DATE-BILL-DAY-30  
C34338         END-IF                                                   
           END-IF.                                                      
                                                                        
           IF AT-DATE-BILL-DAY-60 NOT EQUAL LOW-VALUES                  
C34338         IF AT-DATE-BILL-DAY-60 > SPACES                          
C34338            MOVE AT-DATE-BILL-DAY-60(1:4) TO WS-DATE-FMT-CCYY     
C34338            MOVE AT-DATE-BILL-DAY-60(6:2) TO WS-DATE-FMT-MM       
C34338            MOVE AT-DATE-BILL-DAY-60(9:2) TO WS-DATE-FMT-DD       
C34338            MOVE WS-DATE-FORMAT-USA       TO RS-DATE-BILL-DAY-60  
C34338         ELSE                                                     
C34338            MOVE SPACES                   TO RS-DATE-BILL-DAY-60  
C34338         END-IF                                                   
           END-IF.                                                      
                                                                        
           IF AT-DATE-BILL-DAY-90 NOT EQUAL LOW-VALUES                  
C34338         IF AT-DATE-BILL-DAY-90 > SPACES                          
C34338            MOVE AT-DATE-BILL-DAY-90(1:4) TO WS-DATE-FMT-CCYY     
C34338            MOVE AT-DATE-BILL-DAY-90(6:2) TO WS-DATE-FMT-MM       
C34338            MOVE AT-DATE-BILL-DAY-90(9:2) TO WS-DATE-FMT-DD       
C34338            MOVE WS-DATE-FORMAT-USA       TO RS-DATE-BILL-DAY-90  
C34338         ELSE                                                     
C34338            MOVE SPACES                   TO RS-DATE-BILL-DAY-90  
C34338         END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
                                                                        
T12477     IF WS-CODE-MEDICAL EQUAL WS-A                                
T12477        MOVE WS-Y TO RS-MEDICAL-FLAG                              
T12477     ELSE                                                         
T12477        MOVE WS-N TO RS-MEDICAL-FLAG                              
T12477     END-IF                                                       
                                                                        
           IF WS-CODE-BUDGET EQUAL WS-A                                 
              MOVE WS-Y TO RS-EPP-IND                                   
           ELSE                                                         
              IF WS-CODE-EPP-OFFER EQUAL WS-A                           
                 MOVE WS-B TO RS-EPP-IND                                
              ELSE                                                      
                 MOVE WS-N TO RS-EPP-IND
              END-IF
           END-IF.                               
                                                                        
P00453     IF WS-CODE-PRE-PAY-PLAN = WS-A                               
P00453        MOVE WS-Y TO RS-EPP-IND                                   
P00453        MOVE WS-Y TO WS-PRP-IND                                   
P00453     END-IF.                                                      
                                                                        
           IF WS-CODE-STA-ACCT EQUAL WS-A                               
              MOVE WS-Y TO RS-STA-IND                                   
           ELSE                                                         
              MOVE WS-N TO RS-STA-IND
           END-IF.                                  
                                                                        
           IF WS-CODE-DPP-ACCT EQUAL WS-A                               
              MOVE WS-Y TO RS-DPP-IND                                   
           ELSE                                                         
              MOVE WS-N TO RS-DPP-IND
           END-IF.                                  
                                                                        
           IF WS-CODE-DFA-ACCT EQUAL WS-A                               
              MOVE WS-Y TO RS-DFA-IND                                   
           ELSE                                                         
              MOVE WS-N TO RS-DFA-IND
           END-IF.                                  
                                                                        
PCR072     IF WS-CODE-UTL = WS-A OR WS-CODE-BUDGET = WS-A               
PCR072        MOVE WS-Y  TO WS-HAS-UTIL                                 
PCR072     ELSE                                                         
PCR072        MOVE WS-N  TO WS-HAS-UTIL                                 
PCR072     END-IF.                                                      
                                                                        
           MOVE AT-CANREB-CODE-00-DAY TO RS-CANREB-CODE-00.             
           MOVE AT-CANREB-CODE-30-DAY TO RS-CANREB-CODE-30.             
           MOVE AT-CANREB-CODE-60-DAY TO RS-CANREB-CODE-60.             
           MOVE AT-CANREB-CODE-90-DAY TO RS-CANREB-CODE-90.             
                                                                        
           MOVE AT-TOTAL-AR-BALANCE    TO RS-TOTAL-AR-BALANCE.          
           MOVE AT-CODE-ACCT-STAT      TO RS-CODE-ACCT-STAT.            
           MOVE AT-CREDIT-GROUP        TO RS-CREDIT-GROUP.              
           MOVE AT-BANKRUPTCY-IND      TO RS-CODE-BANKRUPT.             
           IF AT-ACCT-XFER-TO GREATER THAN ZEROS                        
              MOVE AT-ACCT-XFER-TO     TO WS-ACCOUNT-NO-COMP3           
              MOVE WS-ACCOUNT-NO-COMP3 TO WS-ACCOUNT-NO-NUM             
              MOVE WS-ACCOUNT-NO       TO RS-ACCT-XFER-TO               
           ELSE                                                         
              MOVE SPACES              TO RS-ACCT-XFER-TO
           END-IF.              
                                                                        
      *******                                                           22790000
      * NUMBER OF BAD CHECKS WITHIN A YEAR                              22800000
      *******                                                           22810000
C34338     EXEC SQL                                                     
C34338          SELECT
              DATEADD( YEAR, -1, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CURR-DT-LAST-YR         
C34338     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURR-DT-LAST-YR = CURRENT DATE - 1 YEAR                 
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE AT-ACCOUNT-NO TO NH-ACCOUNT-NO.                         
           MOVE ZEROS         TO WS-ROW-COUNT.                          
           PERFORM 7160-SELECT-NSF-HIST THRU 7160-EXIT.                 
           IF WS-ROW-COUNT GREATER THAN ZEROS                           
              MOVE WS-ROW-COUNT TO RS-NO-BAD-CHECKS                     
           ELSE                                                         
              MOVE ZEROES TO RS-NO-BAD-CHECKS
           END-IF.                          
                                                                        
C34338****************************************************************  22900000
C34338* GET NAME AND ADDRESS ONLY WHEN CALLED FROM PAYMENT OBJECT AND*          
C34338* NOT CUSTOMER OBJECT TO IMPROVE PERFORMANCE *                            
C34338****************************************************************  22900000
C34338     IF PARM-NAME-REQ = 'Y'                                       
      *******                                                           22900000
      * GET COMPRESSED CUSTOMER NAME FOR HEADER                         22910000
      *******                                                           22920000
              PERFORM 7900-SELECT-NAME-ACCT-XREF THRU 7900-EXIT         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES         TO RS-FULL-NAME                    
                 MOVE SPACES         TO RS-PRINT-NAME                   
              ELSE                                                      
                 IF DQ-NAME-FORMAT EQUAL WS-B                           
                    MOVE DQ-FULL-NAME   TO WS-BUSINESS-NAME             
                    PERFORM 2510-FORMAT-NAME THRU 2510-EXIT             
T11602              MOVE WS-CMP-TABLE   TO RS-FULL-NAME                 
T11602              MOVE WS-CMP-TABLE   TO RS-PRINT-NAME                
                 ELSE                                                   
                    STRING DQ-LAST-NAME   DELIMITED DELIMITER-SPACE     
                           ', '           DELIMITED SIZE                
                           DQ-FIRST-NAME  DELIMITED DELIMITER-SPACE     
                           ' '            DELIMITED SIZE                
                           DQ-MIDDLE-NAME DELIMITED DELIMITER-SPACE     
                           ' '            DELIMITED SIZE                
T11602                     DQ-TITLE-SUFFIX-1 DELIMITED DELIMITER-SPACE  
T11602                     ' '            DELIMITED SIZE                
T11602*                    DQ-TITLE-SUFFIX-2 DELIMITED DELIMITER-SPACE  23200000
T11602*                    ' '            DELIMITED SIZE                23210000
                          INTO WS-BUSINESS-NAME                         
                    END-STRING                                          
                    PERFORM 2510-FORMAT-NAME THRU 2510-EXIT             
T11602              MOVE WS-CMP-TABLE     TO RS-FULL-NAME               
                                                                        
T11602              STRING DQ-FIRST-NAME  DELIMITED DELIMITER-SPACE     
T11602                  ' '            DELIMITED SIZE                   
T11602                  DQ-MIDDLE-NAME DELIMITED DELIMITER-SPACE        
T11602                  ' '            DELIMITED SIZE                   
T11602                  DQ-LAST-NAME   DELIMITED DELIMITER-SPACE        
T11602                  ' '            DELIMITED SIZE                   
T11602                  DQ-TITLE-SUFFIX-1 DELIMITED DELIMITER-SPACE     
T11602                  ' '            DELIMITED SIZE                   
T11602                 INTO WS-BUSINESS-NAME                            
T11602              END-STRING                                          
T11602              PERFORM 2510-FORMAT-NAME THRU 2510-EXIT             
T11602              MOVE WS-CMP-TABLE     TO RS-PRINT-NAME              
C35842           END-IF                                                 
              END-IF                                                    
                                                                        
      *******                                                           23410000
      * GET COMPRESSED SERVICE ADDRESS FOR HEADER                       23420000
      *******                                                           23430000
              MOVE AT-PREMISE-NO     TO PR-PREMISE-NO                   
              PERFORM 7350-SELECT-PREMISE THRU 7350-EXIT                
              MOVE PR-ADDRESS-ID     TO DY-ADDRESS-ID                   
              PERFORM 7500-SELECT-ADDR-FORMATTED THRU 7500-EXIT         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES TO RS-ADDRESS                              
C35842           MOVE SPACES TO RS-ZIP-CODE                             
              ELSE                                                      
                 PERFORM 2500-FORMAT-ADDRESS THRU 2500-EXIT             
C35842           MOVE DY-ZIP-CODE            TO RS-ZIP-CODE             
C34338        END-IF                                                    
C34338     ELSE                                                         
C34338        MOVE SPACES                    TO RS-FULL-NAME            
C34338        MOVE SPACES                    TO RS-PRINT-NAME           
C34338        MOVE SPACES                    TO RS-ADDRESS              
C35842        MOVE SPACES                    TO RS-ZIP-CODE             
C34338     END-IF                                                       
      *******                                                           23530000
      * GET NEXT BILL DATE.  CONVERT IT TO USA FORMAT                   23540000
      *******                                                           23550000
           PERFORM 7130-GET-CURRENT-DATE THRU 7130-EXIT                 
           MOVE AT-BILL-CYCLE TO BN-BILL-CYCLE                          
T10604     IF AT-CODE-ACCT-STAT = 'B' OR 'J' OR 'S'                     
T10604       MOVE SPACES    TO RS-DATE-NEXT-BILL                        
           ELSE                                                         
TP8767       PERFORM 5900-NEXT-BILL-DATE THRU 5900-NEXT-BILL-DATE-EXIT  
TP8767       IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                       
C34338          IF BN-DATE-EXTRACT > SPACES                             
C34338             MOVE BN-DATE-EXTRACT(1:4)   TO WS-DATE-FMT-CCYY      
C34338             MOVE BN-DATE-EXTRACT(6:2)   TO WS-DATE-FMT-MM        
C34338             MOVE BN-DATE-EXTRACT(9:2)   TO WS-DATE-FMT-DD        
C34338             MOVE WS-DATE-FORMAT-USA     TO RS-DATE-NEXT-BILL     
C34338          ELSE                                                    
C34338             MOVE SPACES                 TO RS-DATE-NEXT-BILL     
C34338          END-IF                                                  
TP8767       ELSE                                                       
TP8767          MOVE SPACES TO RS-DATE-NEXT-BILL                        
TP8767       END-IF                                                     
T10604     END-IF.                                                      
                                                                        
      *******                                                           23710000
      * GET CASH ONLY INDICATOR                                         23720000
      *******                                                           23730000
           MOVE AT-ACCOUNT-NO TO CZ-ACCOUNT-NO.                         
           PERFORM 7340-SELECT-CREDIT-PROFILE THRU 7340-EXIT.           
           MOVE CZ-CASH-ONLY-FL TO RS-CASH-ONLY.                        
                                                                        
      *******                                                           23780000
      * CALLING CPD00068 TO GET ARREARS, AND PAST DUE AMOUNT            23790000
      *******                                                           23800000
           MOVE PARM-DNP-TYPE       TO WS-HOLD-DNP-TYPE.                
           MOVE WS-CURRENT-DATE     TO WS-CL-DATE-NOTICE-MAIL           
                                       WS-CL-DATE-NOTICE-DUE            
                                       WS-HOLD-DATE.                    
PCR361     MOVE 'Y'                 TO CALC-ARREARS-SW                  
PCR361                                 CALC-PAST-DUE-SW                 
PCR361                                 CALC-BALANCE-SW                  
ACT160                                 CALC-DNP-BAL-SW                  
PCR361                                 LOAD-DUE-DATES-SW                
PCR361                                 LOAD-DNP-DATE-SW.                
T19557                                                                  
T22359     MOVE PROGRAM-NAME               TO WS-CPD00068-CALLING-PGM.  
REARCH*    MOVE CWS00068-FIELDS            TO WS-CWS68-FIELDS-LK.               
T19557*    MOVE WS-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT-LK.         
T19557*    MOVE DCLCSS-ACCOUNT             TO WS-DCLCSS-ACCOUNT-LK.             
T19557*    MOVE ABEND-FILE                 TO WS-ABEND-FILE-LK.                 
T19557*    MOVE RS-RETURN-CODE             TO WS-RETURN-CODE-LK.                
ACT160     MOVE SPACES                     TO ABEND-FUNCTION.           
T19557     PERFORM 9500-CALL-CPD00068      THRU 9500-EXIT.              
T19557*    MOVE WS-CWS68-FIELDS-LK         TO CWS00068-FIELDS                   
T19557*    MOVE WS-ABEND-FILE-LK           TO ABEND-FILE                        
T19557*    MOVE WS-DCLCSS-ACCOUNT-LK       TO DCLCSS-ACCOUNT                    
T19557*    MOVE WS-CODES-DATA-PRESENT-LK   TO WS-CODES-DATA-PRESENT             
REARCH*    MOVE WS-RETURN-CODE-LK          TO RS-RETURN-CODE                    
T19557     MOVE RS-RETURN-CODE             TO  WS-ACTIVE-RETURN-CODE,   
T19557                                        SQLCODE.                  
T19557     IF ABEND-FUNCTION  > SPACES                                  
T19557        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
T19557     END-IF.                                                      
      *                                                                         
           MOVE WS-AMT-ARREARS      TO RS-ACCOUNT-ARREARS.              
           MOVE WS-AMT-PAST-DUE     TO RS-PAST-DUE-AMOUNT.              
           MOVE WS-AMT-DNP-BAL      TO RS-DISC-BALANCE.                 
                                                                        
C35187*    IF WS-DATE-BILL-DUE EQUAL SPACES                             23960000
C35187*       MOVE SPACES TO RS-CURRENT-DUE-DATE                        23970000
C35187*    ELSE                                                         23980000
C35187*                                                                 23980000
C34338     IF WS-DATE-BILL-DUE > SPACES                                 
C34338        MOVE WS-DATE-BILL-DUE(1:4)  TO WS-DATE-FMT-CCYY           
C34338        MOVE WS-DATE-BILL-DUE(6:2)  TO WS-DATE-FMT-MM             
C34338        MOVE WS-DATE-BILL-DUE(9:2)  TO WS-DATE-FMT-DD             
C34338        MOVE WS-DATE-FORMAT-USA     TO RS-CURRENT-DUE-DATE        
C34338     ELSE                                                         
C34338        MOVE SPACES                 TO RS-CURRENT-DUE-DATE        
C35187     END-IF.                                                      
                                                                        
C35187*    IF WS-DATE-ARREARS-DUE EQUAL SPACES                          24030000
C35187*       MOVE SPACES TO RS-ARREARS-DUE-DATE                        24040000
C35187*    ELSE                                                         24050000
C35187*                                                                 24050000
C34338     IF WS-DATE-ARREARS-DUE > SPACES                              
C34338        MOVE WS-DATE-ARREARS-DUE(1:4) TO WS-DATE-FMT-CCYY         
C34338        MOVE WS-DATE-ARREARS-DUE(6:2) TO WS-DATE-FMT-MM           
C34338        MOVE WS-DATE-ARREARS-DUE(9:2) TO WS-DATE-FMT-DD           
C34338        MOVE WS-DATE-FORMAT-USA       TO RS-ARREARS-DUE-DATE      
C34338     ELSE                                                         
C34338        MOVE SPACES                   TO RS-ARREARS-DUE-DATE      
C35187     END-IF.                                                      
                                                                        
C35187*    IF WS-DATE-DISC EQUAL SPACES                                 24100000
C35187*       MOVE SPACES TO RS-DATE-DISC                               24110000
C35187*    ELSE                                                         24120000
C35187*                                                                 24120000
           IF WS-DATE-DISC EQUAL WS-MULTIPLE                            
              MOVE WS-DATE-DISC   TO RS-DATE-DISC                       
           ELSE                                                         
C34338        IF WS-DATE-DISC > SPACES                                  
C34338           MOVE WS-DATE-DISC(1:4)    TO WS-DATE-FMT-CCYY          
C34338           MOVE WS-DATE-DISC(6:2)    TO WS-DATE-FMT-MM            
C34338           MOVE WS-DATE-DISC(9:2)    TO WS-DATE-FMT-DD            
C34338           MOVE WS-DATE-FORMAT-USA   TO RS-DATE-DISC              
C34338        ELSE                                                      
C34338           MOVE SPACES               TO RS-DATE-DISC              
C34338        END-IF                                                    
           END-IF.                                                      
                                                                        
      *******                                                           24220000
      * THE FOLLOWING ARE DEFAULT VALUES.                               24230000
      *******                                                           24240000
           MOVE SPACES TO RS-DNP-STATUS                                 
                          RS-CODE-PREPAID-MTR                           
                          RS-CHRG-CARD-AUTH.                            
                                                                        
C34338     EXEC SQL                                                     
C34338          SELECT
              YEAR(CAST(SYSDATETIMEOFFSET() AS DATE))
            INTO
              :WS-YEAR-COMP                  
C34338     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     24290000
MFA-TR*         SET :WS-YEAR-COMP = YEAR(CURRENT DATE)                  24300000
MFA-TR*    END-EXEC.                                                    24330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-YEAR-COMP TO WS-YEAR.                                
                                                                        
PCR361     MOVE WS-LIHEAP-START-DATE        TO WS-LIHEAP-STDT.          
PCR361     MOVE WS-RE-LIHEAP-STDD           TO RS-LIHEAP-STDD.          
PCR361     MOVE WS-RE-LIHEAP-STMM           TO RS-LIHEAP-STMM.          
PCR361     MOVE WS-RE-YEAR                  TO RS-LIHEAP-STYY.          
                                                                        
PCR361     MOVE WS-LIHEAP-END-DATE          TO WS-LIHEAP-ENDT.          
PCR361     MOVE WS-RE-LIHEAP-ENDD           TO RS-LIHEAP-ENDD           
PCR361     MOVE WS-RE-LIHEAP-ENMM           TO RS-LIHEAP-ENMM           
PCR361     MOVE WS-RE-YEAR                  TO RS-LIHEAP-ENYY           
                                                                        
      *******                                                           24470000
      * IF A ROW EXIST IN CSS_RECONNECT TABLE, THE AGREED UPON          24480000
      * RECONNECT AMOUNT WILL BE USED AS DIRECTED AMOUNT.               24490000
      *******                                                           24500000
           MOVE AT-ACCOUNT-NO TO DL-ACCOUNT-NO.                         
           PERFORM 7170-SELECT-RECONNECT THRU 7170-EXIT.                
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE DL-AMT-TOT-RECONNECT  TO RS-AMT-TOT-RECONNECT        
TP3437        MOVE DL-RECNCT-COLLECT-AMT TO RS-AMT-RCNCT-COLL           
TP3437        MOVE 'Y'                   TO RS-RECONNECT-IND            
TP3437     ELSE                                                         
TP3437        MOVE ZEROES                TO RS-AMT-TOT-RECONNECT        
TP3437        MOVE ZEROES                TO RS-AMT-RCNCT-COLL           
TP3437        MOVE 'N'                   TO RS-RECONNECT-IND            
TP3437     END-IF.                                                      
                                                                        
           MOVE SPACES TO RS-CODE-PAY-AHEAD.                            
                                                                        
                                                                        
C33998********                                                                  
C33998*  GET CUTOFF DATE FROM DELINQUENCY TABLE AND SET                         
C33998*  WRITEOFF FLAG                                                          
C33998************                                                              
                                                                        
C33998     IF AT-CODE-ACCT-STAT = 'S' AND AT-COMPANY-NO = '01'          
C33998        MOVE 'WO-CUTOFF-DT'       TO C8-DELINQ-CD                 
C33998        MOVE AT-COMPANY-NO        TO C8-COMPANY-NO                
C33998        PERFORM 7190-SELECT-WO-DELINQ   THRU 7190-EXIT            
C33998     END-IF.                                                      
                                                                        
      *******                                                           24650000
      * GET DETAIL A/R INFORMATION                                      24660000
      *******                                                           24670000
                                                                        
           PERFORM 2300-LOAD-MAP-DETAIL THRU 2300-EXIT.                 
           IF CTR-ROWS = 0 THEN                                         
REARCH         PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
REARCH         PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                 
REARCH     END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-LOAD-MAP-DETAIL.                                            
           MOVE 2300   TO ACTIVE-PARAGRAPH.                             
           MOVE ZEROES TO WS-PMTS-REM.                                  
           MOVE ZEROES TO WS-AMT-BILLED-UNPAID.                         
                                                                        
           MOVE AT-ACCOUNT-NO TO AC-ACCOUNT-NO.                         
           MOVE ZEROES        TO AC-PYMT-PRIORITY-LVL                   
                                 AC-ITEM-ID.                            
           PERFORM 7100-OPEN-AR-CNTRL-CURSOR  THRU 7100-EXIT.           
           PERFORM 7110-FETCH-AR-CNTRL-CURSOR THRU 7110-EXIT.           
           PERFORM 2310-LOAD-MAP-LINE THRU 2310-EXIT                    
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
           PERFORM 7120-CLOSE-AR-CNTRL-CURSOR THRU 7120-EXIT.           
                                                                        
      *****************                                                 24880000
      * GET MONTHLY CREDIT RECORDS.                                     24890000
      *****************                                                 24900000
           MOVE AT-ACCOUNT-NO TO CT-ACCOUNT-NO.                         
           PERFORM 7700-OPEN-MTH-CRE-CURSOR  THRU 7700-EXIT.            
           PERFORM 7710-FETCH-MTH-CRE-CURSOR THRU 7710-EXIT.            
           PERFORM 2700-LOAD-MTH-CRE-LINE THRU 2700-EXIT                
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
           PERFORM 7720-CLOSE-MTH-CRE-CURSOR THRU 7720-EXIT.            
                                                                        
      *****************                                                 24980000
      * GET CHARGED OFF RECORD.  IT IS POSSIBLE TO HAVE AR_CNTL AND     24990000
      * CHARGE_OFF AT THE SAME TIME.                                    25000000
      *****************                                                 25010000
C33998     IF AT-CODE-ACCT-STAT = 'S'                                   
              MOVE AT-ACCOUNT-NO TO CO-ACCOUNT-NO                       
              MOVE ZEROES        TO CO-PYMT-PRIORITY-LVL                
                                    CO-ITEM-ID                          
              PERFORM 7600-OPEN-CHARGE-OFF-CURSOR  THRU 7600-EXIT       
              PERFORM 7610-FETCH-CHARGE-OFF-CURSOR THRU 7610-EXIT       
              PERFORM 2600-LOAD-CHARGE-OFF-LINE THRU 2600-EXIT          
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
              PERFORM 7620-CLOSE-CHARGE-OFF-CURSOR THRU 7620-EXIT       
                                                                        
C33998     END-IF.                                                      
      *****************                                                 25110000
      * THE FULL AMOUNT ON PANEL 113 IS NOT THE PAY OFF AMOUNT IN       25120000
      * BASE.  THEREFORE, NO NEED TO INCLUDE DEP ON HAND LOGIC.         25130000
      *****************                                                 25140000
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2310-LOAD-MAP-LINE.                                              
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              GO TO 2310-EXIT
           END-IF.                                          
                                                                        
           MOVE AC-LAST-UPDATE-TS TO RS-AC-LAST-UPDATE-TS.              
                                                                        
      *******************                                               25240000
      * GET A/R TYPE AND DESCRIPTION                                    25250000
      *******************                                               25260000
           MOVE AC-PYMT-PRIORITY-LVL TO L5-PYMT-PRIORITY-LVL            
                                        RS-PYMT-PRIORITY-LVL.           
           PERFORM 2320-GET-REC-DESC THRU 2320-EXIT.                    
                                                                        
      *******************                                               25310000
      * DETERMINE IF THIS A/R IS UTILITY RELATED OR NOT                 25320000
      *******************                                               25330000
           IF AC-PYMT-PRIORITY-LVL EQUAL WS-NSA                         
                                      OR WS-LPC                         
                                      OR WS-UTE                         
                                      OR WS-UTG                         
                                      OR WS-EPP                         
                                      OR WS-RCC                         
                                      OR WS-DEP                         
                                      OR WS-DFA                         
              MOVE WS-Y TO RS-UTIL-RELATED                              
           ELSE                                                         
              MOVE WS-N TO RS-UTIL-RELATED
           END-IF.                             
                                                                        
      *******************                                               25460000
      * LOADING DETAIL LINES                                            25470000
      *******************                                               25480000
      * BILL AMOUNT:  00 + 30 + 60 + 90 + UNUSED                        25490000
      * FULL BALANCE:                                                   25500000
      *      W/O TRD: 00 + 30 + 60 + 90 + UNUSED                        25510000
      *      W/TRD:   TRAN-BALANCE                                      25520000
      *******************                                               25530000
           IF (AC-ITEM-ID EQUAL ZEROES AND                              
              (AC-PYMT-PRIORITY-LVL EQUAL ZEROES OR                     
               AC-PYMT-PRIORITY-LVL EQUAL WS-NSC OR                     
               AC-PYMT-PRIORITY-LVL EQUAL WS-NSA OR                     
               AC-PYMT-PRIORITY-LVL EQUAL WS-NSN OR                     
               AC-PYMT-PRIORITY-LVL EQUAL WS-LPC OR                     
               AC-PYMT-PRIORITY-LVL EQUAL WS-LPN OR                     
               AC-PYMT-PRIORITY-LVL EQUAL WS-UTE OR                     
               AC-PYMT-PRIORITY-LVL EQUAL WS-UTG))                      
              MOVE SPACES TO RS-SPECIAL-DUE-DATE                        
              MOVE ZEROES TO RS-ITEM-ID                                 
              MOVE ZEROES TO RS-NBR-PYMTS-REMAIN                        
                             RS-MNTH-PYMT-AMT                           
              MOVE AC-AMT-AR-DAY-00     TO RS-AMT-AR-DAY-00             
              MOVE AC-AMT-AR-DAY-30     TO RS-AMT-AR-DAY-30             
              MOVE AC-AMT-AR-DAY-60     TO RS-AMT-AR-DAY-60             
              MOVE AC-AMT-AR-DAY-90     TO RS-AMT-AR-DAY-90             
T17389        MOVE AC-AMT-UNUSED-CR     TO RS-AMT-UNUSED-CREDIT         
T17389        MOVE AC-TOT-SUMM-UNBILLED TO RS-TOT-SUMM-UNBILLED         
              ADD AC-AMT-AR-DAY-00                                      
                  AC-AMT-AR-DAY-30                                      
                  AC-AMT-AR-DAY-60                                      
                  AC-AMT-AR-DAY-90                                      
                  AC-AMT-UNUSED-CR GIVING RS-BILLED-BALANCE             
                                          RS-FULL-BALANCE               
              IF AC-TOT-SUMM-UNBILLED GREATER THAN ZEROES               
                 ADD AC-TOT-SUMM-UNBILLED TO RS-FULL-BALANCE            
              ELSE                                                      
                 NEXT SENTENCE
              END-IF                                          
           ELSE                                                         
           IF AC-ITEM-ID GREATER THAN ZEROES                            
              MOVE SPACES TO RS-SPECIAL-DUE-DATE                        
              PERFORM 2330-LOAD-MAP-FROM-DETAIL THRU 2330-EXIT          
           ELSE                                                         
              PERFORM 7110-FETCH-AR-CNTRL-CURSOR THRU 7110-EXIT         
              GO TO 2310-EXIT
           END-IF
           END-IF.                                          
                                                                        
      *******************                                               25890000
      * SPECIAL DUE DATE FOR RETURNED CHECK                             25900000
      *******************                                               25910000
      *    IF AC-PYMT-PRIORITY-LVL EQUAL WS-NSC OR                      25920000
      *       AC-PYMT-PRIORITY-LVL EQUAL WS-NSA                         25930000
      *       IF WS-DATE-CREDIT-ACTION-H GREATER THAN SPACES            25940000
      *          MOVE AT-DATE-BILL-DAY-00  TO WS-DATE-HOLD              25950000
      *          PERFORM 7140-GET-USA-DATE THRU 7140-EXIT               25960000
      *          MOVE WS-DATE-HOLD-USA     TO RS-SPECIAL-DUE-DATE.      25970000
T10066     IF AC-PYMT-PRIORITY-LVL EQUAL WS-NSA                         
T10066        IF WS-DATE-CREDIT-ACTION-H GREATER THAN SPACES            
T10066           MOVE AC-ACCOUNT-NO        TO CL-ACCOUNT-NO             
T10066           PERFORM 7252-OPEN-CRED-COLL        THRU 7252-EXIT      
T10066           PERFORM 7253-FETCH-CRED-COLL       THRU 7253-EXIT      
T10066           MOVE CL-DATE-NOTICE-DUE   TO RS-SPECIAL-DUE-DATE       
T10066           PERFORM 7254-CLOSE-CRED-COLL       THRU 7254-EXIT
              END-IF
           END-IF.     
T11117                                                                  
T11117     IF AT-CODE-ACCT-STAT = 'S' OR 'B' OR 'I'                     
T11117         IF WS-FINAL-NULL-IND > -1                                
T11117            MOVE ZEROES              TO RS-ACCOUNT-ARREARS        
T11117         END-IF                                                   
T11117     END-IF.                                                      
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT  THRU 8100-EXIT.                    
                                                                        
           PERFORM 7110-FETCH-AR-CNTRL-CURSOR THRU 7110-EXIT.           
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00453******************************************************************        
P00453* 2320-GET-REC-DESC                                              *        
P00453******************************************************************        
P00453*                                                                         
       2320-GET-REC-DESC.                                               
P00453*                                                                         
P00453     INITIALIZE RS-RECV-DESC                                      
                      RS-RECV-TYPE.                                     
           PERFORM 7150-SELECT-AR-TYPE      THRU 7150-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00453        IF WS-PRP-IND = WS-Y AND L5-AR-TYPE-SHORT-DESC = 'BBP'    
P00453           MOVE 'PRP'                 TO RS-RECV-TYPE             
P00453           MOVE 'PRE-PAY-PLAN'        TO RS-RECV-DESC             
                                                                        
P00453        ELSE                                                      
                 MOVE L5-AR-TYPE-SHORT-DESC TO RS-RECV-TYPE             
                 MOVE L5-AR-TYPE-LONG-DESC  TO RS-RECV-DESC             
P00453        END-IF                                                    
           ELSE                                                         
              MOVE SPACES                   TO RS-RECV-TYPE             
                                               RS-RECV-DESC             
P00453     END-IF.                                                      
P00453*                                                                         
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2330-LOAD-MAP-FROM-DETAIL.                                       
           MOVE 2330 TO ACTIVE-PARAGRAPH.                               
                                                                        
           MOVE AC-ITEM-ID           TO RS-ITEM-ID.                     
           MOVE AC-AMT-AR-DAY-00     TO RS-AMT-AR-DAY-00.               
           MOVE AC-AMT-AR-DAY-30     TO RS-AMT-AR-DAY-30.               
           MOVE AC-AMT-AR-DAY-60     TO RS-AMT-AR-DAY-60.               
           MOVE AC-AMT-AR-DAY-90     TO RS-AMT-AR-DAY-90.               
T17389     MOVE AC-AMT-UNUSED-CR     TO RS-AMT-UNUSED-CREDIT            
T17389     MOVE AC-TOT-SUMM-UNBILLED TO RS-TOT-SUMM-UNBILLED            
T11466     MOVE ZERO                 TO RS-AMT-PAYOFF.                  
                                                                        
           IF AC-PYMT-PRIORITY-LVL EQUAL WS-EPP                         
              PERFORM 2331-LOAD-MAP-EPP THRU 2331-EXIT                  
           ELSE                                                         
           IF AC-PYMT-PRIORITY-LVL EQUAL WS-RCC                         
              PERFORM 2332-LOAD-MAP-CCC  THRU 2332-EXIT                 
           ELSE                                                         
           IF AC-PYMT-PRIORITY-LVL EQUAL WS-CIA                         
              PERFORM 2333-LOAD-MAP-CIA  THRU 2333-EXIT                 
           ELSE                                                         
           IF AC-PYMT-PRIORITY-LVL EQUAL WS-CNT                         
               PERFORM 2334-LOAD-MAP-CNT THRU 2334-EXIT                 
           ELSE                                                         
           IF AC-PYMT-PRIORITY-LVL EQUAL WS-DEP                         
              PERFORM 2335-LOAD-MAP-DEP  THRU 2335-EXIT                 
           ELSE                                                         
           IF AC-PYMT-PRIORITY-LVL EQUAL WS-DFA                         
              PERFORM 2336-LOAD-MAP-DFA  THRU 2336-EXIT                 
           ELSE                                                         
T17708     IF AC-PYMT-PRIORITY-LVL EQUAL WS-PJS                         
              PERFORM 2337-LOAD-MAP-PJS  THRU 2337-EXIT                 
           ELSE                                                         
T17708        MOVE +100   TO rs-return-code                             
REARCH        PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
T17708        PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
T17708        PERFORM 9999-END-PROGRAM   THRU 9999-EXIT
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.                
       2330-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2331-LOAD-MAP-EPP.                                               
      ********************************************                      26630000
      *  LOADS EQUAL PAYMENT PLAN RECEIVABLE     *                      26640000
      ********************************************                      26650000
T11063     MOVE ZEROES TO RS-MNTH-PYMT-AMT.                             
                                                                        
           MOVE ZEROES TO RS-NBR-PYMTS-REMAIN.                          
                                                                        
           ADD AC-AMT-AR-DAY-00                                         
               AC-AMT-AR-DAY-30                                         
               AC-AMT-AR-DAY-60                                         
               AC-AMT-AR-DAY-90                                         
               AC-AMT-UNUSED-CR GIVING RS-BILLED-BALANCE.               
                                                                        
           MOVE AC-AMT-TRAN-BALANCE TO RS-FULL-BALANCE.                 
       2331-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2332-LOAD-MAP-CCC.                                               
      *****************************************                         26900000
      * FORMAT CUSTOMER CONNECT INFORMATION   *                         26910000
      *****************************************                         26920000
           MOVE AC-ACCOUNT-NO        TO CC-ACCOUNT-NO.                  
           MOVE AC-PYMT-PRIORITY-LVL TO CC-PYMT-PRIORITY-LVL.           
           MOVE AC-ITEM-ID           TO CC-CCC-ITEM-ID.                 
           PERFORM 7220-SELECT-CCC    THRU 7220-EXIT.                   
                                                                        
           MOVE ZEROES TO RS-MNTH-PYMT-AMT.                             
           MOVE ZEROES TO RS-NBR-PYMTS-REMAIN.                          
                                                                        
           ADD AC-AMT-AR-DAY-00                                         
               AC-AMT-AR-DAY-30                                         
               AC-AMT-AR-DAY-60                                         
               AC-AMT-AR-DAY-90                                         
               AC-AMT-UNUSED-CR GIVING RS-BILLED-BALANCE.               
                                                                        
           MOVE AC-AMT-TRAN-BALANCE TO RS-FULL-BALANCE.                 
       2332-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2333-LOAD-MAP-CIA.                                               
PCR072***************************************                           27120000
PCR072*  FORMAT CONT-IN-AID INFORMATION     *                           27130000
PCR072***************************************                           27140000
PCR072*    MOVE AC-ACCOUNT-NO        TO CI-ACCOUNT-NO.                  27150000
PCR072*    MOVE AC-PYMT-PRIORITY-LVL TO CI-PYMT-PRIORITY-LVL.           27160000
PCR072*    MOVE AC-ITEM-ID           TO CI-CIAC-ITEM-ID.                27170000
PCR072*    PERFORM 7230-SELECT-CIA   THRU 7230-EXIT.                    27180000
PCR072*                                                                 27190000
PCR072*    MOVE CI-AMT-MO-PYMT TO RS-MNTH-PYMT-AMT.                     27200000
PCR072*                                                                 27210000
PCR072*    PERFORM 2400-CALC-NO-PYMTS THRU 2400-EXIT.                   27220000
PCR072     IF WS-HAS-UTIL = WS-Y                                        
PCR072        MOVE WS-Y TO RS-UTIL-RELATED                              
PCR072     ELSE                                                         
PCR072        MOVE WS-N TO RS-UTIL-RELATED                              
PCR072     END-IF.                                                      
PCR072     IF AC-ITEM-ID = 1                                            
PCR072        MOVE 'CREDIT IN ADVANCE' TO RS-RECV-DESC                  
PCR072     END-IF.                                                      
PCR072     IF AC-ITEM-ID = 2                                            
PCR072*       MOVE 71 TO RS-PYMT-PRIORITY-LVL                           27320000
PCR072        MOVE 'CREDIT IN ADVANCE-LIHEAP' TO RS-RECV-DESC           
PCR072     END-IF.                                                      
PCR072     IF AC-ITEM-ID = 3                                            
PCR072        MOVE 'CIA DEBIT'                TO RS-RECV-DESC           
PCR072     END-IF.                                                      
PCR072*    MOVE 0 TO RS-ITEM-ID.                                        27380000
TP9976     MOVE ZEROES TO RS-MNTH-PYMT-AMT                              
                                                                        
PCR072     ADD AC-AMT-AR-DAY-00                                         
PCR072         AC-AMT-AR-DAY-30                                         
PCR072         AC-AMT-AR-DAY-60                                         
PCR072         AC-AMT-AR-DAY-90                                         
PCR072         AC-AMT-UNUSED-CR GIVING RS-BILLED-BALANCE.               
                                                                        
PCR072     MOVE AC-AMT-TRAN-BALANCE TO RS-FULL-BALANCE.                 
                                                                        
      ***************                                                   27490000
      * FULL AMOUNT ON PANEL 113 IS THE SUM OF FULL BALANCE             27500000
      * THEREFORE, COMMENT OUT LOGIC PERFORMS PARA 2410                 27510000
      ***************                                                   27520000
       2333-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2334-LOAD-MAP-CNT.                                               
      ***************************************                           27570000
      *  FORMAT CONTRACT INFORMATION        *                           27580000
      ***************************************                           27590000
           MOVE AC-ACCOUNT-NO        TO CT-ACCOUNT-NO.                  
           MOVE AC-PYMT-PRIORITY-LVL TO CT-PYMT-PRIORITY-LVL.           
           MOVE AC-ITEM-ID           TO CT-CNT-ITEM-ID.                 
           PERFORM 7240-SELECT-CNT   THRU 7240-EXIT.                    
                                                                        
TP7920     IF (WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND)                   
TP7920        MOVE WS-NOT-FOUND TO RS-RECV-DESC                         
TP7920        MOVE ZEROES          TO RS-NBR-PYMTS-REMAIN               
TP7920                                RS-MNTH-PYMT-AMT                  
TP7920                                CT-AMT-DEF-INTEREST               
TP7920     ELSE                                                         
PCR072     IF (CT-CNT-STATUS-CD = 'A' AND AC-AMT-TRAN-BALANCE < 0)      
TP9716***************                                                   27720000
TP9716* GET CONTRACT INFO IF CONTRACTS EXIST                            27730000
TP9716***************                                                   27740000
TP9716         MOVE CT-CODE-CONTRACT-TYPE TO K6-CODE-CONTRACT-TYPE      
TP9716         MOVE CT-CNT-NAME-CD        TO K6-CNT-NAME-CD             
TP9716         PERFORM 7245-SELECT-CONTRACT-INFO THRU 7245-EXIT         
TP9716         IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
ACT278            STRING WS-ADV-COLL, K6-CNT-NAME-DESC DELIMITED        
TP9716                                 BY SIZE INTO RS-RECV-DESC        
TP9716         ELSE                                                     
TP9716            MOVE WS-ADV-COLL    TO RS-RECV-DESC                   
TP9716         END-IF                                                   
TP9716         MOVE ZEROES         TO RS-NBR-PYMTS-REMAIN               
TP9716                                RS-MNTH-PYMT-AMT                  
TP9716     ELSE                                                         
PCR238         MOVE CT-LIEN-CD TO RS-LIEN-CD                            
               IF CT-AMT-MO-PYMT EQUAL 99999.99                         
                  MOVE ZEROES TO RS-MNTH-PYMT-AMT                       
               ELSE                                                     
                  MOVE CT-AMT-MO-PYMT TO RS-MNTH-PYMT-AMT               
               END-IF                                                   
                                                                        
      ***************                                                   27940000
      * GET CONTRACT INFO IF CONTRACTS EXIST                            27950000
      ***************                                                   27960000
               MOVE CT-CODE-CONTRACT-TYPE TO K6-CODE-CONTRACT-TYPE      
               MOVE CT-CNT-NAME-CD        TO K6-CNT-NAME-CD             
               PERFORM 7245-SELECT-CONTRACT-INFO THRU 7245-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
T12243            MOVE K6-CNT-NAME-DESC      TO RS-CNT-LONG-DESC        
               ELSE                                                     
                  MOVE WS-NOT-FOUND          TO RS-RECV-DESC            
T12243            MOVE SPACES                TO RS-CNT-LONG-DESC        
               END-IF                                                   
               PERFORM 2400-CALC-NO-PYMTS THRU 2400-EXIT                
            END-IF                                                      
TP7920     END-IF.                                                      
           ADD AC-AMT-AR-DAY-00                                         
               AC-AMT-AR-DAY-30                                         
               AC-AMT-AR-DAY-60                                         
               AC-AMT-AR-DAY-90                                         
               AC-AMT-UNUSED-CR GIVING RS-BILLED-BALANCE.               
                                                                        
           MOVE AC-AMT-TRAN-BALANCE TO RS-FULL-BALANCE.                 
T11466                                                                  
T11466     COMPUTE WS-AMT-UNBILLED-PRI = AC-AMT-TRAN-BALANCE            
T11466                                   - CT-AMT-DEF-INTEREST          
T11466                                   - AC-AMT-AR-DAY-00             
T11466                                   - AC-AMT-AR-DAY-30             
T11466                                   - AC-AMT-AR-DAY-60             
T11466                                   - AC-AMT-AR-DAY-90             
T11466                                   - AC-AMT-UNUSED-CR             
T11466                                                                  
C35842*    PERFORM 7130-GET-CURRENT-DATE   THRU 7130-EXIT               28240000
C35842*    PERFORM 7950-GET-LAST-BILL-DATE THRU 7950-EXIT               28260000
T11466                                                                  
T11466     MOVE CT-DATE-CONTRACT           TO WS-MAX-INTRST-DT          
T11466     IF ( WS-NULL-INDICATOR4 NOT EQUAL -1 AND                     
T11466          CT-STATUS-CHANGE-DT >  WS-MAX-INTRST-DT )               
T11466          MOVE CT-STATUS-CHANGE-DT TO WS-MAX-INTRST-DT            
T11466     END-IF                                                       
C35842     IF AT-DATE-BILL-DAY-00 EQUAL LOW-VALUES                      
C35842        MOVE '1901-01-01'          TO WS-LAST-BILL-DATE           
C35842     ELSE                                                         
C35842        MOVE AT-DATE-BILL-DAY-00   TO WS-LAST-BILL-DATE           
C35842     END-IF                                                       
T11466     IF ( WS-LAST-BILL-DATE   >  WS-MAX-INTRST-DT )               
T11466          MOVE WS-LAST-BILL-DATE   TO WS-MAX-INTRST-DT            
T11466     END-IF                                                       
T11466                                                                  
T11466     PERFORM 7960-GET-DATE-DIFF THRU 7960-EXIT                    
T11466                                                                  
T11466*  TO TAKE CARE OF PRECISION, USE CORRECT()()                     28390000
T11466     COMPUTE RS-AMT-PAYOFF ROUNDED =                              
T11466      (   AC-AMT-TRAN-BALANCE  - CT-AMT-DEF-INTEREST              
T11466          + ( ( WS-AMT-UNBILLED-PRI * WS-NUM-OF-DAYS-FOR-INT      
T11466               * CT-INTRST-RATE ) / ( 100.0000 * 360.0000 )       
T11466             )                                                    
T11466      ).                                                          
       2334-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2335-LOAD-MAP-DEP.                                               
      ******************************************                        28510000
      *  FORMAT DEPOSIT INFORMATION            *                        28520000
      ******************************************                        28530000
           MOVE AC-ACCOUNT-NO        TO DR-ACCOUNT-NO.                  
           MOVE AC-ACCOUNT-NO        TO CL-ACCOUNT-NO.                  
           MOVE AC-PYMT-PRIORITY-LVL TO DR-PYMT-PRIORITY-LVL.           
           MOVE AC-ITEM-ID           TO DR-DEP-ITEM-ID.                 
           MOVE AC-ITEM-ID           TO CL-ITEM-ID.                     
           PERFORM 7250-SELECT-DEP       THRU 7250-EXIT.                
           PERFORM 7251-SELECT-CRED-COLL THRU 7251-EXIT.                
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CL-DATE-NOTICE-DUE TO RS-SPECIAL-DUE-DATE            
           ELSE                                                         
              MOVE SPACES             TO RS-SPECIAL-DUE-DATE            
           END-IF.                                                      
                                                                        
           IF DR-AMT-MO-PYMT EQUAL 99999.99                             
              MOVE ZEROES TO RS-MNTH-PYMT-AMT                           
           ELSE                                                         
              MOVE DR-AMT-MO-PYMT TO RS-MNTH-PYMT-AMT
           END-IF.                  
                                                                        
           PERFORM 2400-CALC-NO-PYMTS THRU 2400-EXIT.                   
                                                                        
           ADD AC-AMT-AR-DAY-00                                         
               AC-AMT-AR-DAY-30                                         
               AC-AMT-AR-DAY-60                                         
               AC-AMT-AR-DAY-90                                         
               AC-AMT-UNUSED-CR GIVING RS-BILLED-BALANCE.               
                                                                        
           MOVE AC-AMT-TRAN-BALANCE TO RS-FULL-BALANCE.                 
                                                                        
           MOVE 1 TO WS-SAVE-SUB.                                       
       2335-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2336-LOAD-MAP-DFA.                                               
      *******************************                                   28870000
      *  FORMAT DFA INFORMATION     *                                   28880000
      *******************************                                   28890000
           MOVE AC-ACCOUNT-NO        TO DA-ACCOUNT-NO.                  
           MOVE AC-PYMT-PRIORITY-LVL TO DA-PYMT-PRIORITY-LVL.           
           MOVE AC-ITEM-ID           TO DA-DFA-ITEM-ID.                 
           PERFORM 7260-SELECT-DFA   THRU 7260-EXIT.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             IF DA-AMT-MO-PYMT EQUAL 99999.99                           
                MOVE ZEROES TO RS-MNTH-PYMT-AMT                         
             ELSE                                                       
                MOVE DA-AMT-MO-PYMT TO RS-MNTH-PYMT-AMT                 
             END-IF                                                     
                                                                        
             MOVE SPACES TO RS-SPECIAL-DUE-DATE                         
                                                                        
             PERFORM 2400-CALC-NO-PYMTS    THRU 2400-EXIT               
                                                                        
             IF DA-CODE-DFA-TYPE EQUAL WS-B                             
                MOVE WS-DPP      TO RS-RECV-TYPE                        
                MOVE WS-DEF-PLAN TO RS-RECV-DESC                        
C24880       ELSE                                                       
C24880          IF DA-DFA-ITEM-ID > 45000000                            
C24880             MOVE DA-CODE-DFA-DESC        TO Z8-CODE-DFA-DESC     
C24880             MOVE AT-COMPANY-NO           TO Z8-COMPANY-NO        
C24880             PERFORM 7180-GET-CHARGE-DESC THRU 7180-EXIT          
C24880             MOVE WS-CEC                  TO RS-RECV-TYPE         
C24880             MOVE Z8-CHARGE-DESC-TX       TO RS-RECV-DESC         
C24880          END-IF                                                  
             END-IF                                                     
           ELSE                                                         
             MOVE AC-ITEM-ID           TO WS-DATE-TEMP-NUM              
             MOVE WS-DATE-TEMP-NUM     TO WS-DATE-TEMP                  
             MOVE WS-DATE-TMP-MM       TO WS-DATE-REF-MM                
             MOVE WS-DATE-TMP-DD       TO WS-DATE-REF-DD                
             MOVE WS-DATE-TMP-YY       TO WS-DATE-REF-YY                
             IF WS-DATE-REF-YY < '50'                                   
                MOVE '20'                 TO WS-DATE-REF-CC             
             ELSE                                                       
                MOVE '19'                 TO WS-DATE-REF-CC             
             END-IF                                                     
             MOVE WS-DATE-REF          TO DA-FRST-ERNST-PAY-DT          
             PERFORM 7265-SELECT-DFA-FRST-ERNST THRU 7265-EXIT          
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                MOVE WS-DPP               TO RS-RECV-TYPE               
                MOVE 'FIRST EARNEST AMOUNT' TO RS-RECV-DESC             
C34338          MOVE DA-FRST-ERNST-PAY-DT(1:4)  TO WS-DATE-FMT-CCYY     
C34338          MOVE DA-FRST-ERNST-PAY-DT(6:2)  TO WS-DATE-FMT-MM       
C34338          MOVE DA-FRST-ERNST-PAY-DT(9:2)  TO WS-DATE-FMT-DD       
C34338          MOVE WS-DATE-FORMAT-USA         TO RS-SPECIAL-DUE-DATE  
                MOVE +1                   TO RS-NBR-PYMTS-REMAIN        
                MOVE ZEROES               TO RS-MNTH-PYMT-AMT           
             ELSE                                                       
                MOVE WS-DATE-REF          TO DA-SCND-ERNST-PAY-DT       
                PERFORM 7267-SELECT-DFA-SCND-ERNST THRU 7267-EXIT       
                MOVE WS-DPP               TO RS-RECV-TYPE               
                MOVE 'SECOND EARNEST AMOUNT' TO RS-RECV-DESC            
C34338          MOVE DA-SCND-ERNST-PAY-DT(1:4)  TO WS-DATE-FMT-CCYY     
C34338          MOVE DA-SCND-ERNST-PAY-DT(6:2)  TO WS-DATE-FMT-MM       
C34338          MOVE DA-SCND-ERNST-PAY-DT(9:2)  TO WS-DATE-FMT-DD       
C34338          MOVE WS-DATE-FORMAT-USA         TO RS-SPECIAL-DUE-DATE  
                MOVE +1                   TO RS-NBR-PYMTS-REMAIN        
                MOVE ZEROES               TO RS-MNTH-PYMT-AMT           
             END-IF                                                     
           END-IF.                                                      
                                                                        
           ADD AC-AMT-AR-DAY-00                                         
               AC-AMT-AR-DAY-30                                         
               AC-AMT-AR-DAY-60                                         
               AC-AMT-AR-DAY-90                                         
               AC-AMT-UNUSED-CR GIVING RS-BILLED-BALANCE.               
                                                                        
           MOVE AC-AMT-TRAN-BALANCE    TO RS-FULL-BALANCE.              
                                                                        
       2336-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2337-LOAD-MAP-PJS.                                               
      ****************************************                          29570000
      *   FORMAT PROJECT SHARE INFORMATION   *                          29580000
      ****************************************                          29590000
           MOVE AC-ACCOUNT-NO        TO PJ-ACCOUNT-NO.                  
           MOVE AC-PYMT-PRIORITY-LVL TO PJ-PYMT-PRIORITY-LVL.           
           MOVE AC-ITEM-ID           TO PJ-ITEM-ID.                     
           PERFORM 7270-SELECT-PJS   THRU 7270-EXIT.                    
                                                                        
           MOVE PJ-MONTHLY-BILL-AM TO RS-MNTH-PYMT-AMT.                 
           MOVE ZEROES TO RS-NBR-PYMTS-REMAIN.                          
                                                                        
           ADD AC-AMT-AR-DAY-00                                         
               AC-AMT-AR-DAY-30                                         
               AC-AMT-AR-DAY-60                                         
               AC-AMT-AR-DAY-90                                         
               AC-AMT-UNUSED-CR GIVING RS-BILLED-BALANCE.               
           MOVE AC-AMT-TRAN-BALANCE TO RS-FULL-BALANCE.                 
       2337-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-CALC-NO-PYMTS.                                              
           MOVE 2400 TO ACTIVE-PARAGRAPH.                               
           MOVE WS-CURRENT-DATE TO WS-CURRENT-DATE-BREAKDOWN.           
           MOVE ZEROES TO WS-MO-PYMT.                                   
           MOVE SPACES TO WS-DATE-PYMT-START.                           
           MOVE ZEROES TO WS-PYMTS-SCHED.                               
                                                                        
PCR072*    IF AC-PYMT-PRIORITY-LVL EQUAL WS-CIA                         29840000
PCR072*       IF WS-NULL-INDICATOR EQUAL -1                             29850000
PCR072*          MOVE CI-NO-SCHED-PYMTS TO RS-NBR-PYMTS-REMAIN          29860000
PCR072*          GO TO 2400-EXIT                                        29870000
PCR072*       ELSE                                                      29880000
PCR072*          MOVE CI-AMT-MO-PYMT       TO WS-MO-PYMT                29890000
PCR072*          MOVE CI-DATE-CIAC-BILLED  TO WS-DATE-PYMT-START        29900000
PCR072*          MOVE CI-NO-SCHED-PYMTS    TO WS-PYMTS-SCHED            29910000
PCR072*          IF AC-AMT-TRAN-BALANCE EQUAL CI-AMT-ORIG-ENTERED       29920000
PCR072*             MOVE CI-NO-SCHED-PYMTS TO RS-NBR-PYMTS-REMAIN       29930000
PCR072*             GO TO 2400-EXIT.                                    29940000
                                                                        
           IF AC-PYMT-PRIORITY-LVL EQUAL WS-CNT                         
              IF CT-CODE-BILL-TYPE EQUAL WS-E                           
                 MOVE ZEROES               TO RS-NBR-PYMTS-REMAIN       
                 GO TO 2400-EXIT                                        
              ELSE                                                      
                 MOVE CT-AMT-MO-PYMT       TO WS-MO-PYMT                
                 MOVE CT-DATE-PYMT-START   TO WS-DATE-PYMT-START        
                 MOVE CT-NO-SCHED-PYMTS    TO WS-PYMTS-SCHED            
      ***********************                                           30040000
      * IF CONTRACT TYPE IS B DO NOT SHOW NO OF PYMTS                   30050000
      ***********************                                           30060000
                 IF CT-CODE-BILL-TYPE EQUAL WS-B                        
                   MOVE ZEROES             TO RS-NBR-PYMTS-REMAIN       
                   GO TO 2400-EXIT                                      
                 ELSE                                                   
                   IF AC-AMT-TRAN-BALANCE EQUAL CT-AMT-ORIG-ENTERED     
                      MOVE CT-NO-SCHED-PYMTS TO RS-NBR-PYMTS-REMAIN     
                      GO TO 2400-EXIT
                   END-IF
                 END-IF
              END-IF
           END-IF.                                  
                                                                        
           IF AC-PYMT-PRIORITY-LVL EQUAL WS-DEP                         
              MOVE DR-AMT-MO-PYMT       TO WS-MO-PYMT                   
              MOVE DR-DATE-PYMT-START   TO WS-DATE-PYMT-START           
              MOVE DR-NO-SCHED-PYMTS    TO WS-PYMTS-SCHED               
              IF AC-AMT-TRAN-BALANCE EQUAL DR-AMT-ORIG-ENTERED          
                 MOVE DR-NO-SCHED-PYMTS TO RS-NBR-PYMTS-REMAIN          
                 GO TO 2400-EXIT
              END-IF
           END-IF.                                       
                                                                        
           IF AC-PYMT-PRIORITY-LVL EQUAL WS-DFA                         
              MOVE DA-AMT-MO-PYMT       TO WS-MO-PYMT                   
              IF WS-NULL-INDICATOR2 EQUAL ZERO                          
                 MOVE DA-DATE-PYMT-START   TO WS-DATE-PYMT-START        
              ELSE                                                      
                 MOVE SPACES               TO WS-DATE-PYMT-START        
              END-IF                                                    
              MOVE DA-NO-SCHED-PYMTS    TO WS-PYMTS-SCHED               
              IF AC-AMT-TRAN-BALANCE EQUAL DA-AMT-ORIG-ENTERED          
                 MOVE DA-NO-SCHED-PYMTS TO RS-NBR-PYMTS-REMAIN          
                 GO TO 2400-EXIT
              END-IF
           END-IF.                                       
                                                                        
T12607     IF WS-MO-PYMT > 0                                            
              DIVIDE AC-AMT-TRAN-BALANCE BY WS-MO-PYMT                  
                  GIVING WS-NO-SCH-PMTS                                 
                  REMAINDER WS-PMTS-REM
           END-IF.                                
                                                                        
           IF WS-PMTS-REM GREATER THAN ZEROES                           
              ADD 1 TO WS-NO-SCH-PMTS
           END-IF.                                  
                                                                        
           MOVE WS-NO-SCH-PMTS TO RS-NBR-PYMTS-REMAIN.                  
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-FORMAT-ADDRESS.                                             
           MOVE SPACES               TO WS-EMB-INPUT                    
                                        WS-CMP-TABLE.                   
           MOVE DY-HOUSE-NO          TO WS-HOUSE-NO.                    
           MOVE DY-ADDR-PREFIX-1     TO WS-PREFIX-1.                    
           MOVE DY-ADDR-PREFIX-2     TO WS-PREFIX-2.                    
           MOVE DY-STREET-NAME       TO WS-STREET-NAME.                 
           MOVE DY-STREET-LOCATION-1 TO WS-LOC1.                        
           MOVE DY-STREET-LOCATION-2 TO WS-LOC2.                        
           MOVE DY-STREET-SUFFIX     TO WS-SUFFIX.                      
           MOVE WS-SERVICE-ADDRESS-BREAKDOWN TO WS-EMB-INPUT.           
C35671*    MOVE 50                           TO WS-EMB-LENG.            30580000
C35671     MOVE 74                           TO WS-EMB-LENG.            
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
           MOVE WS-CMP-TABLE                 TO RS-ADDRESS.             
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2510-FORMAT-NAME.                                                
           MOVE SPACES           TO WS-EMB-INPUT                        
                                    WS-CMP-TABLE.                       
           MOVE WS-BUSINESS-NAME TO WS-EMB-INPUT.                       
TP5266*    MOVE 65               TO WS-EMB-LENG.                        30680000
C35671     MOVE 85               TO WS-EMB-LENG.                        
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-LOAD-CHARGE-OFF-LINE.                                       
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              GO TO 2600-EXIT
           END-IF.                                          
                                                                        
      *******************                                               30770000
      * GET A/R TYPE AND DESCRIPTION                                    30780000
      *******************                                               30790000
           MOVE CO-PYMT-PRIORITY-LVL TO L5-PYMT-PRIORITY-LVL            
                                        RS-PYMT-PRIORITY-LVL.           
           PERFORM 2320-GET-REC-DESC THRU 2320-EXIT.                    
                                                                        
           MOVE CO-PYMT-PRIORITY-LVL TO RS-PYMT-PRIORITY-LVL.           
           MOVE CO-ITEM-ID           TO RS-ITEM-ID.                     
                                                                        
      *******************                                               30870000
      * DETERMINE IF THIS CHARGED OFF A/R IS UTILITY RELATED OR NOT     30880000
      *******************                                               30890000
           IF CO-PYMT-PRIORITY-LVL EQUAL WS-NSA                         
                                      OR WS-LPC                         
                                      OR WS-UTE                         
                                      OR WS-UTG                         
                                      OR WS-EPP                         
                                      OR WS-RCC                         
                                      OR WS-DEP                         
                                      OR WS-DFA                         
              MOVE WS-A TO RS-UTIL-RELATED                              
           ELSE                                                         
              MOVE WS-B TO RS-UTIL-RELATED
           END-IF.                             
                                                                        
TP4695*    MOVE CO-AMT-TRANS TO RS-BILLED-BALANCE                       31020000
TP4695*                         RS-FULL-BALANCE.                        31030000
TP4695     MOVE CO-AMT-TRANS TO RS-FULL-BALANCE.                        
TP4695     MOVE ZEROS        TO RS-BILLED-BALANCE.                      
           MOVE WS-Y         TO RS-CHRG-OFF-AR.                         
                                                                        
           MOVE SPACES TO RS-SPECIAL-DUE-DATE.                          
           MOVE ZEROES TO RS-NBR-PYMTS-REMAIN                           
                          RS-MNTH-PYMT-AMT                              
                          RS-AMT-AR-DAY-00                              
                          RS-AMT-AR-DAY-30                              
                          RS-AMT-AR-DAY-60                              
                          RS-AMT-AR-DAY-90                              
T17389                    RS-AMT-UNUSED-CREDIT                          
T17389                    RS-TOT-SUMM-UNBILLED                          
                          RS-AMT-DIRECT-PYMT.                           
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
REARCH     PERFORM 8100-SEND-RESULT  THRU 8100-EXIT.                    
                                                                        
           PERFORM 7610-FETCH-CHARGE-OFF-CURSOR THRU 7610-EXIT.         
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2700-LOAD-MTH-CRE-LINE.                                          
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              GO TO 2700-EXIT
           END-IF.                                          
                                                                        
           IF CT-AMT-MO-PYMT EQUAL 99999.99                             
              MOVE ZEROES TO RS-MNTH-PYMT-AMT                           
           ELSE                                                         
              MOVE CT-AMT-MO-PYMT TO RS-MNTH-PYMT-AMT
           END-IF.                  
      ******************                                                31310000
      * MULTIPLY BY -1 SINCE THIS IS A CREDIT                           31320000
      ******************                                                31330000
              MULTIPLY -1 BY RS-MNTH-PYMT-AMT.                          
                                                                        
           MOVE ZEROES              TO RS-BILLED-BALANCE.               
           MOVE ZEROES              TO RS-FULL-BALANCE.                 
      *******************                                               31380000
      * GET A/R TYPE AND DESCRIPTION                                    31390000
      *******************                                               31400000
           MOVE CT-PYMT-PRIORITY-LVL TO L5-PYMT-PRIORITY-LVL            
                                        RS-PYMT-PRIORITY-LVL.           
           PERFORM 2320-GET-REC-DESC THRU 2320-EXIT.                    
                                                                        
      ***************                                                   31450000
      * GET CONTRACT TYPE ABBREVIATION FROM CONTRACT INFO TABLE         31460000
      ***************                                                   31470000
           MOVE CT-CODE-CONTRACT-TYPE TO K6-CODE-CONTRACT-TYPE.         
           MOVE CT-CNT-NAME-CD        TO K6-CNT-NAME-CD.                
           PERFORM 7245-SELECT-CONTRACT-INFO THRU 7245-EXIT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T12243        MOVE K6-CNT-NAME-DESC      TO RS-CNT-LONG-DESC            
           ELSE                                                         
T12243        MOVE SPACES                TO RS-CNT-LONG-DESC            
              MOVE WS-NOT-FOUND          TO RS-RECV-DESC                
           END-IF.                                                      
                                                                        
           MOVE CT-CNT-ITEM-ID       TO RS-ITEM-ID.                     
                                                                        
           MOVE WS-N TO RS-UTIL-RELATED.                                
                                                                        
           MOVE SPACES TO RS-SPECIAL-DUE-DATE.                          
           MOVE ZEROES TO RS-NBR-PYMTS-REMAIN                           
                          RS-AMT-AR-DAY-00                              
                          RS-AMT-AR-DAY-30                              
                          RS-AMT-AR-DAY-60                              
                          RS-AMT-AR-DAY-90                              
T17389                    RS-AMT-UNUSED-CREDIT                          
T17389                    RS-TOT-SUMM-UNBILLED                          
                          RS-AMT-DIRECT-PYMT.                           
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
REARCH     PERFORM 8100-SEND-RESULT  THRU 8100-EXIT.                    
                                                                        
           PERFORM 7710-FETCH-MTH-CRE-CURSOR THRU 7710-EXIT.            
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     31740000
TP8767        INCLUDE CPD00309                                          31790000
TP8767     END-EXEC.                                                    31800000
                                                                        
      *COPY CPD00003.                                                   31820000
       COPY CPD00004.                                                   31830000
                                                                        
       7000-SELECT-ACCOUNT.                                             
           EXEC SQL                                                     
               SELECT ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      DATE_BILL_DAY_00,                                 
                      DATE_BILL_DAY_30,                                 
                      DATE_BILL_DAY_60,                                 
                      DATE_BILL_DAY_90,                                 
                      BILL_CYCLE,                                       
                      CODE_ACCT_STAT,                                   
                      TOTAL_AR_BALANCE,                                 
                      LOCAL_OFFICE,                                     
                      PREMISE_NO,                                       
                      ACCT_XFER_TO,                                     
                      BANKRUPTCY_IND,                                   
                      CODES_DATA_PRESENT,                               
                      COMPANY_NO,                                       
                      CREDIT_GROUP,                                     
                      CANREB_CODE_00_DAY,                               
                      CANREB_CODE_30_DAY,                               
                      CANREB_CODE_60_DAY,                               
                      CANREB_CODE_90_DAY,                               
                      REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                      CODE_DISC_OK,                                     
                      NOTICE_EXEMPT_CD,                                 
TP8767                CODE_BILL_FREQ,                                   
TP8767                REV_MTH_LST_NRML,                                 
T11117                REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,                       
c28788                IVR_EXEMPT_CD                                     
               INTO   :AT-ACCOUNT-NO,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1,        
                      :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2,        
                      :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3,        
                      :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4,        
                      :AT-BILL-CYCLE,                                   
                      :AT-CODE-ACCT-STAT,                               
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-LOCAL-OFFICE,                                 
                      :AT-PREMISE-NO,                                   
                      :AT-ACCT-XFER-TO,                                 
                      :AT-BANKRUPTCY-IND,                               
                      :AT-CODES-DATA-PRESENT,                           
                      :AT-COMPANY-NO,                                   
                      :AT-CREDIT-GROUP,                                 
                      :AT-CANREB-CODE-00-DAY,                           
                      :AT-CANREB-CODE-30-DAY,                           
                      :AT-CANREB-CODE-60-DAY,                           
                      :AT-CANREB-CODE-90-DAY,                           
                      :AT-LAST-UPDATE-TS,                               
                      :AT-CODE-DISC-OK,                                 
                      :AT-NOTICE-EXEMPT-CD,                             
TP8767                :AT-CODE-BILL-FREQ,                               
TP8767                :AT-REV-MTH-LST-NRML,                             
T11117                :AT-ACCT-FINALED-DT :WS-FINAL-NULL-IND,            
C28788                :AT-IVR-EXEMPT-CD                                 
              FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                            
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     31860000
MFA-TR*        SELECT ACCOUNT_NO,                                       31870000
MFA-TR*               CUSTOMER_NO,                                      31880000
MFA-TR*               DATE_BILL_DAY_00,                                 31890000
MFA-TR*               DATE_BILL_DAY_30,                                 31900000
MFA-TR*               DATE_BILL_DAY_60,                                 31910000
MFA-TR*               DATE_BILL_DAY_90,                                 31920000
MFA-TR*               BILL_CYCLE,                                       31930000
MFA-TR*               CODE_ACCT_STAT,                                   31940000
MFA-TR*               TOTAL_AR_BALANCE,                                 31950000
MFA-TR*               LOCAL_OFFICE,                                     31960000
MFA-TR*               PREMISE_NO,                                       31970000
MFA-TR*               ACCT_XFER_TO,                                     31980000
MFA-TR*               BANKRUPTCY_IND,                                   31990000
MFA-TR*               CODES_DATA_PRESENT,                               32000000
MFA-TR*               COMPANY_NO,                                       32010000
MFA-TR*               CREDIT_GROUP,                                     32020000
MFA-TR*               CANREB_CODE_00_DAY,                               32030000
MFA-TR*               CANREB_CODE_30_DAY,                               32040000
MFA-TR*               CANREB_CODE_60_DAY,                               32050000
MFA-TR*               CANREB_CODE_90_DAY,                               32060000
MFA-TR*               LAST_UPDATE_TS,                                   32070000
MFA-TR*               CODE_DISC_OK,                                     32080000
MFA-TR*               NOTICE_EXEMPT_CD,                                 32090000
MFA-TR*               CODE_BILL_FREQ,                                   32100000
MFA-TR*               REV_MTH_LST_NRML,                                 32110000
MFA-TR*               ACCT_FINALED_DT,                                  32120000
MFA-TR*               IVR_EXEMPT_CD                                             
MFA-TR*        INTO   :AT-ACCOUNT-NO,                                   32130000
MFA-TR*               :AT-CUSTOMER-NO,                                  32140000
MFA-TR*               :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1,        32150000
MFA-TR*               :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2,        32160000
MFA-TR*               :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3,        32170000
MFA-TR*               :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4,        32180000
MFA-TR*               :AT-BILL-CYCLE,                                   32190000
MFA-TR*               :AT-CODE-ACCT-STAT,                               32200000
MFA-TR*               :AT-TOTAL-AR-BALANCE,                             32210000
MFA-TR*               :AT-LOCAL-OFFICE,                                 32220000
MFA-TR*               :AT-PREMISE-NO,                                   32230000
MFA-TR*               :AT-ACCT-XFER-TO,                                 32240000
MFA-TR*               :AT-BANKRUPTCY-IND,                               32250000
MFA-TR*               :AT-CODES-DATA-PRESENT,                           32260000
MFA-TR*               :AT-COMPANY-NO,                                   32270000
MFA-TR*               :AT-CREDIT-GROUP,                                 32280000
MFA-TR*               :AT-CANREB-CODE-00-DAY,                           32290000
MFA-TR*               :AT-CANREB-CODE-30-DAY,                           32300000
MFA-TR*               :AT-CANREB-CODE-60-DAY,                           32310000
MFA-TR*               :AT-CANREB-CODE-90-DAY,                           32320000
MFA-TR*               :AT-LAST-UPDATE-TS,                               32330000
MFA-TR*               :AT-CODE-DISC-OK,                                 32340000
MFA-TR*               :AT-NOTICE-EXEMPT-CD,                             32350000
MFA-TR*               :AT-CODE-BILL-FREQ,                               32360000
MFA-TR*               :AT-REV-MTH-LST-NRML,                             32370000
MFA-TR*               :AT-ACCT-FINALED-DT:WS-FINAL-NULL-IND,            32380000
MFA-TR*               :AT-IVR-EXEMPT-CD                                         
MFA-TR*       FROM CSS_ACCOUNT                                          32390000
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         32400000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    32410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-INDICATOR-1 < ZERO                             
                  MOVE LOW-VALUES        TO AT-DATE-BILL-DAY-00         
              END-IF                                                    
              IF WS-NULL-INDICATOR-2 < ZERO                             
                  MOVE LOW-VALUES        TO AT-DATE-BILL-DAY-30         
              END-IF                                                    
              IF WS-NULL-INDICATOR-3 < ZERO                             
                  MOVE LOW-VALUES        TO AT-DATE-BILL-DAY-60         
              END-IF                                                    
              IF WS-NULL-INDICATOR-4 < ZERO                             
                  MOVE LOW-VALUES        TO AT-DATE-BILL-DAY-90         
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
REARCH        PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
T17864        PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
T17864        PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
PCR361     END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-OPEN-AR-CNTRL-CURSOR.                                       
           EXEC SQL                                                     
                OPEN AR_CNTRL_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
T15604        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-FETCH-AR-CNTRL-CURSOR.                                      
           EXEC SQL                                                     
               FETCH AR_CNTRL_CURSOR                                    
                INTO :AC-PYMT-PRIORITY-LVL,                             
                     :AC-ITEM-ID,                                       
                     :AC-AMT-AR-DAY-00,                                 
                     :AC-AMT-AR-DAY-30,                                 
                     :AC-AMT-AR-DAY-60,                                 
                     :AC-AMT-AR-DAY-90,                                 
                     :AC-AMT-TRAN-BALANCE,                              
                     :AC-AMT-UNUSED-CR,                                 
                     :AC-TOT-SUMM-UNBILLED,                             
                     :AC-LAST-UPDATE-TS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                 OR   NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7110'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
T15604        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-CLOSE-AR-CNTRL-CURSOR.                                      
           EXEC SQL                                                     
              CLOSE AR_CNTRL_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7120'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
T15604        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-GET-CURRENT-DATE.                                           
                                                                        
TP8019     EXEC SQL                                                     
TP8019        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
TP8019     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     33560000
MFA-TR*       SET  :WS-CURRENT-DATE = CURRENT DATE                      33570000
MFA-TR*    END-EXEC                                                     33580000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7130'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-SELECT-AR-TYPE.                                             
           EXEC SQL                                                     
              SELECT AR_TYPE_SHORT_DESC,                                
                     AR_TYPE_LONG_DESC                                  
              INTO   :L5-AR-TYPE-SHORT-DESC,                            
                     :L5-AR-TYPE-LONG-DESC                              
              FROM CSS_AR_TYPE WITH(READUNCOMMITTED)                            
              WHERE PYMT_PRIORITY_LVL = :L5-PYMT-PRIORITY-LVL           
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     34070000
MFA-TR*       SELECT AR_TYPE_SHORT_DESC,                                34080000
MFA-TR*              AR_TYPE_LONG_DESC                                  34090000
MFA-TR*       INTO   :L5-AR-TYPE-SHORT-DESC,                            34100000
MFA-TR*              :L5-AR-TYPE-LONG-DESC                              34110000
MFA-TR*       FROM CSS_AR_TYPE                                          34120000
MFA-TR*       WHERE PYMT_PRIORITY_LVL = :L5-PYMT-PRIORITY-LVL           34130000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    34140000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_TYPE'         TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15604        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE L5-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7160-SELECT-NSF-HIST.                                            
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-ROW-COUNT                                      
              FROM  CSS_NSF_HIST WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO        = :NH-ACCOUNT-NO                  
c34338*       AND   NSF_STATUS_CD     = :WS-C                           34390000
              AND   NSF_STATUS_CD     = 'C'                             
c34338*       AND   DATE_TRAN         > CURRENT DATE - 1 YEAR           34400000
c34338        AND   DATE_TRAN         > IIF(TRY_CONVERT(DATE, 
                                                    :WS-CURR-DT-LAST-YR
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DT-LAST-YR
              ) <> 0) OR (LEN(:WS-CURR-DT-LAST-YR
              ) <> 10), CIS.CHAR2DATE(:WS-CURR-DT-LAST-YR
              ), CONVERT(DATE, :WS-CURR-DT-LAST-YR) )             
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     34340000
MFA-TR*       SELECT COUNT(*)                                           34350000
MFA-TR*         INTO :WS-ROW-COUNT                                      34360000
MFA-TR*       FROM  CSS_NSF_HIST                                        34370000
MFA-TR*       WHERE ACCOUNT_NO        = :NH-ACCOUNT-NO                  34380000
MFA-TR*       AND   NSF_STATUS_CD     = :WS-C                           34390000
MFA-TR*       AND   NSF_STATUS_CD     = 'C'                             34390000
MFA-TR*       AND   DATE_TRAN         > CURRENT DATE - 1 YEAR           34400000
MFA-TR*       AND   DATE_TRAN         > :WS-CURR-DT-LAST-YR             34400000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    34410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7160'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_NSF_HIST'        TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE NH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'NSF_STATUS_CD'       TO TABLE-ELEMENT-2             
T15604        MOVE WS-C                  TO HOSTVAR-ELEMENT-2           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7170-SELECT-RECONNECT.                                           
           EXEC SQL                                                     
               SELECT                                                   
                  ACCOUNT_NO,         USER_ID,                          
                  RECNCT_NRML_HR_IND, DATETIME_SETUP,                   
                  AGREEMENT_COMMENTS, AMT_TOT_RECONNECT,                
*T3437            RECNCT_COLLECT_AMT                                    
                INTO                                                    
                  :DL-ACCOUNT-NO,         :DL-USER-ID,                  
                  :DL-RECNCT-NRML-HR-IND, :DL-DATETIME-SETUP,           
                  :DL-AGREEMENT-COMMENTS, :DL-AMT-TOT-RECONNECT,        
*T3437            :DL-RECNCT-COLLECT-AMT                                
              FROM CSS_RECONNECT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO        = :DL-ACCOUNT-NO                  
              AND   AMT_TOT_RECONNECT > 0                               
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     34610000
MFA-TR*        SELECT                                                   34620000
MFA-TR*           ACCOUNT_NO,         USER_ID,                          34630000
MFA-TR*           RECNCT_NRML_HR_IND, DATETIME_SETUP,                   34640000
MFA-TR*           AGREEMENT_COMMENTS, AMT_TOT_RECONNECT,                34650000
MFA-TR*           RECNCT_COLLECT_AMT                                    34660000
MFA-TR*         INTO                                                    34670000
MFA-TR*           :DL-ACCOUNT-NO,         :DL-USER-ID,                  34680000
MFA-TR*           :DL-RECNCT-NRML-HR-IND, :DL-DATETIME-SETUP,           34690000
MFA-TR*           :DL-AGREEMENT-COMMENTS, :DL-AMT-TOT-RECONNECT,        34700000
MFA-TR*           :DL-RECNCT-COLLECT-AMT                                34710000
MFA-TR*       FROM CSS_RECONNECT                                        34720000
MFA-TR*       WHERE ACCOUNT_NO        = :DL-ACCOUNT-NO                  34730000
MFA-TR*       AND   AMT_TOT_RECONNECT > 0                               34731003
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    34740000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7170'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_RECONNECT'       TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
C24880*                                                                         
C24880 7180-GET-CHARGE-DESC.                                            
C24880*                                                                         
C24880     EXEC SQL                                                     
C24880        SELECT  Z8.CHARGE_DESC_TX                                 
C24880          INTO  :Z8-CHARGE-DESC-TX                                
C24880          FROM  CSS_CHARGE_TYPE Z8 WITH(READUNCOMMITTED)                  
C24880         WHERE  Z8.COMPANY_NO         = :Z8-COMPANY-NO            
C24880           AND  Z8.CODE_DFA_DESC      = :Z8-CODE-DFA-DESC         
C24880           AND  Z8.CHARGE_STATUS_CD   = 'A'                       
C35842                                                           
C24880     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02338214
MFA-TR*       SELECT  Z8.CHARGE_DESC_TX                                 02338214
MFA-TR*         INTO  :Z8-CHARGE-DESC-TX                                        
MFA-TR*         FROM  CSS_CHARGE_TYPE Z8                                02338214
MFA-TR*        WHERE  Z8.COMPANY_NO         = :Z8-COMPANY-NO            02338214
MFA-TR*          AND  Z8.CODE_DFA_DESC      = :Z8-CODE-DFA-DESC         02338214
MFA-TR*          AND  Z8.CHARGE_STATUS_CD   = 'A'                       02338214
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                     02338214

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880*                                                                         
C24880     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C24880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -811           
C24880        NEXT SENTENCE                                             
C24880     ELSE                                                         
C24880        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C24880        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C24880        MOVE '7180'                TO ACTIVE-PARAGRAPH            
C24880        MOVE 'SELECT'              TO ABEND-FUNCTION              
C24880        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C24880                                      ABEND-TABLES                
C24880        MOVE 'CSS_CHARGE_TYPE'     TO TABLE-1                     
C24880        MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
C24880        MOVE Z8-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
C24880        MOVE 'CODE_DFA_DESC'       TO TABLE-ELEMENT-2             
C24880        MOVE Z8-CODE-DFA-DESC      TO HOSTVAR-ELEMENT-2           
C24880        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
C24880     END-IF.                                                      
C24880*                                                                         
C24880 7180-EXIT.                                                       
C24880     EXIT.                                                        
C24880*                                                                         
C33998***************************************************************           
C33998* 7185-SELECT-WRITEOFF-DT GETS THE WRITEOFF DATE FROM         *           
C33998* CSS_CHRG_OFF TABLE.                                         *           
C33998***************************************************************           
                                                                        
C33998 7185-SELECT-WRITEOFF-DT.                                         
C33998     EXEC SQL                                                     
C33998        SELECT SUM(AMT_TRANS)                                     
C33998          INTO :CO-AMT-TRANS :WS-NULL-IND-CHG-AMT                 
C33998          FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                         
C33998         WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                        
C33998           AND DATE_OF_CHG_OFF <                                  
C33998               (DATEADD( YEAR, -(:C8-DELINQ-VALUE), 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))   
C35842                                                           
C33998     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_TRANS)                                             
MFA-TR*         INTO :CO-AMT-TRANS :WS-NULL-IND-CHG-AMT                         
MFA-TR*         FROM CSS_CHRG_OFF                                               
MFA-TR*        WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                                
MFA-TR*          AND DATE_OF_CHG_OFF <                                          
MFA-TR*              (DATE (CURRENT DATE) - (:C8-DELINQ-VALUE) YEARS)           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C33998     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
C33998     EVALUATE WS-ACTIVE-RETURN-CODE                               
C33998         WHEN SUCCESSFUL-CALL                                     
C33998               CONTINUE                                           
C33998         WHEN NOT-FOUND                                           
C33998              MOVE ZEROS TO CO-AMT-TRANS                          
C33998         WHEN OTHER                                               
C33998         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
C33998         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
C33998         MOVE '7185'                TO ACTIVE-PARAGRAPH           
C33998         MOVE 'SELECT'              TO ABEND-FUNCTION             
C33998         MOVE SPACES                TO ABEND-SQL-PREDICATES       
C33998                                      ABEND-TABLES                
C33998         MOVE 'CSS_CHRG_OFF'        TO TABLE-1                    
C33998         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
C33998         MOVE CO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
C33998         MOVE SPACES                TO TABLE-ELEMENT-2            
C33998         MOVE SPACES                TO HOSTVAR-ELEMENT-2          
C33998         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
C33998     END-EVALUATE.                                                
C33998                                                                  
C33998     IF WS-NULL-IND-CHG-AMT < 0                                   
C33998        MOVE ZEROS TO CO-AMT-TRANS                                
C33998     END-IF.                                                      
                                                                        
C33998 7185-EXIT.                                                       
C33998     EXIT.                                                        
                                                                        
C33998*****************************************************************         
C33998*  7190-SELECT-WO-DELINQ. GETS THE DELINQUENCY VALUE FOR        *         
C33998*  WO-CUTOFF-DT                                                 *         
C33998*****************************************************************         
                                                                        
C33998 7190-SELECT-WO-DELINQ.                                           
C33998     EXEC SQL                                                     
C33998        SELECT DELINQ_VALUE                                       
C33998          INTO :C8-DELINQ-VALUE                                   
C33998          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
C33998         WHERE DELINQ_CD = :C8-DELINQ-CD                          
C33998           AND COMPANY_NO = :C8-COMPANY-NO                        
C35842                                                           
C33998     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C33998     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
C33998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C33998        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C33998           MOVE AT-ACCOUNT-NO              TO CO-ACCOUNT-NO       
C33998           PERFORM 7185-SELECT-WRITEOFF-DT THRU 7185-EXIT         
                                                                        
C33998           IF CO-AMT-TRANS > 0                                    
C33998              MOVE 'Y' TO RS-WRITEOFF-FLAG                        
C33998           ELSE                                                   
C33998              MOVE SPACES TO RS-WRITEOFF-FLAG                     
C33998           END-IF                                                 
C33998        ELSE                                                      
C33998           MOVE 'N' TO RS-WRITEOFF-FLAG                           
C33998        END-IF                                                    
C33998     ELSE                                                         
C33998        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C33998        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C33998        MOVE '7190'                TO ACTIVE-PARAGRAPH            
C33998        MOVE 'SELECT'              TO ABEND-FUNCTION              
C33998        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C33998                                      ABEND-TABLES                
C33998        MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
C33998        MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1             
C33998        MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1           
C33998        MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
C33998        MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
C33998        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
C33998     END-IF.                                                      
                                                                        
C33998 7190-EXIT.                                                       
                                                                        
       7220-SELECT-CCC.                                                 
           EXEC SQL                                                     
               SELECT AMT_TRANS                                         
               INTO   :CC-AMT-TRANS                                     
               FROM   CSS_CONNECT_CHRG WITH(READUNCOMMITTED)                    
               WHERE  ACCOUNT_NO        = :CC-ACCOUNT-NO                
               AND    PYMT_PRIORITY_LVL = :CC-PYMT-PRIORITY-LVL         
               AND    CCC_ITEM_ID       = :CC-CCC-ITEM-ID               
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     35260000
MFA-TR*        SELECT AMT_TRANS                                         35270000
MFA-TR*        INTO   :CC-AMT-TRANS                                     35280000
MFA-TR*        FROM   CSS_CONNECT_CHRG                                  35290000
MFA-TR*        WHERE  ACCOUNT_NO        = :CC-ACCOUNT-NO                35300000
MFA-TR*        AND    PYMT_PRIORITY_LVL = :CC-PYMT-PRIORITY-LVL         35310000
MFA-TR*        AND    CCC_ITEM_ID       = :CC-CCC-ITEM-ID               35320000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    35330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7220'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CONNECT_CHRG'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE CC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE 'CCC_ITEM_ID'         TO TABLE-ELEMENT-3             
              MOVE CC-CCC-ITEM-ID        TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7240-SELECT-CNT.                                                 
                                                                        
T11466     INITIALIZE WS-NULL-INDICATOR4                                
                                                                        
           EXEC SQL                                                     
                SELECT AMT_MO_PYMT,                                     
                       CODE_BILL_TYPE,                                  
                       CODE_CONTRACT_TYPE,                              
                       CNT_NAME_CD,                                     
PCR072                 CNT_STATUS_CD,                                   
                       DATE_PYMT_START,                                 
                       CODE_INTRST_METH,                                
                       INTRST_PRIOR_YR,                                 
                       NO_SCHED_PYMTS,                                  
                       AMT_ORIG_ENTERED,                                
T11466                 AMT_DEF_INTEREST,                                
T11466                 DATE_CONTRACT,                                   
T11466                 STATUS_CHANGE_DT,                                
T11466                 INTRST_RATE,                                     
PCR238                 LIEN_CD                                          
                  INTO :CT-AMT-MO-PYMT,                                 
                       :CT-CODE-BILL-TYPE,                              
                       :CT-CODE-CONTRACT-TYPE,                          
                       :CT-CNT-NAME-CD,                                 
PCR072                 :CT-CNT-STATUS-CD,                               
                       :CT-DATE-PYMT-START,                             
                       :CT-CODE-INTRST-METH,                            
                       :CT-INTRST-PRIOR-YR,                             
                       :CT-NO-SCHED-PYMTS,                              
                       :CT-AMT-ORIG-ENTERED,                            
T11466                 :CT-AMT-DEF-INTEREST,                            
T11466                 :CT-DATE-CONTRACT,                               
T11466                 :CT-STATUS-CHANGE-DT :WS-NULL-INDICATOR4,        
T11466                 :CT-INTRST-RATE,                                 
PCR238                 :CT-LIEN-CD                                      
                FROM   CSS_CONTRACT WITH(READUNCOMMITTED)                       
                WHERE  ACCOUNT_NO        = :CT-ACCOUNT-NO               
                  AND  PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL        
                  AND  CNT_ITEM_ID       = :CT-CNT-ITEM-ID              
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     35580000
MFA-TR*         SELECT AMT_MO_PYMT,                                     35590000
MFA-TR*                CODE_BILL_TYPE,                                  35600000
MFA-TR*                CODE_CONTRACT_TYPE,                              35610000
MFA-TR*                CNT_NAME_CD,                                     35620000
MFA-TR*                CNT_STATUS_CD,                                   35630000
MFA-TR*                DATE_PYMT_START,                                 35640000
MFA-TR*                CODE_INTRST_METH,                                35650000
MFA-TR*                INTRST_PRIOR_YR,                                 35660000
MFA-TR*                NO_SCHED_PYMTS,                                  35670000
MFA-TR*                AMT_ORIG_ENTERED,                                35680000
MFA-TR*                AMT_DEF_INTEREST,                                35690000
MFA-TR*                DATE_CONTRACT,                                   35700000
MFA-TR*                STATUS_CHANGE_DT,                                35710000
MFA-TR*                INTRST_RATE,                                     35720000
MFA-TR*                LIEN_CD                                          35730000
MFA-TR*           INTO :CT-AMT-MO-PYMT,                                 35740000
MFA-TR*                :CT-CODE-BILL-TYPE,                              35750000
MFA-TR*                :CT-CODE-CONTRACT-TYPE,                          35760000
MFA-TR*                :CT-CNT-NAME-CD,                                 35770000
MFA-TR*                :CT-CNT-STATUS-CD,                               35780000
MFA-TR*                :CT-DATE-PYMT-START,                             35790000
MFA-TR*                :CT-CODE-INTRST-METH,                            35800000
MFA-TR*                :CT-INTRST-PRIOR-YR,                             35810000
MFA-TR*                :CT-NO-SCHED-PYMTS,                              35820000
MFA-TR*                :CT-AMT-ORIG-ENTERED,                            35830000
MFA-TR*                :CT-AMT-DEF-INTEREST,                            35840000
MFA-TR*                :CT-DATE-CONTRACT,                               35850000
MFA-TR*                :CT-STATUS-CHANGE-DT :WS-NULL-INDICATOR4,        35860000
MFA-TR*                :CT-INTRST-RATE,                                 35870000
MFA-TR*                :CT-LIEN-CD                                      35880000
MFA-TR*         FROM   CSS_CONTRACT                                     35890000
MFA-TR*         WHERE  ACCOUNT_NO        = :CT-ACCOUNT-NO               35900000
MFA-TR*           AND  PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL        35910000
MFA-TR*           AND  CNT_ITEM_ID       = :CT-CNT-ITEM-ID              35920000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    35930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T14029*                               OR NOT-FOUND                      35961001
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7240'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CONTRACT'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE CT-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE 'CNT_ITEM_ID'         TO TABLE-ELEMENT-3             
              MOVE CT-CNT-ITEM-ID        TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7245-SELECT-CONTRACT-INFO.                                       
           EXEC SQL                                                     
ACT278          SELECT CNT_NAME_DESC                                    
ACT278            INTO :K6-CNT-NAME-DESC                                
                  FROM CSS_CONTRACT_INFO WITH(READUNCOMMITTED)                  
                WHERE  CODE_CONTRACT_TYPE = :K6-CODE-CONTRACT-TYPE      
                  AND  CNT_NAME_CD        = :K6-CNT-NAME-CD             
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     36150000
MFA-TR*         SELECT CNT_NAME_DESC                                    36160000
MFA-TR*           INTO :K6-CNT-NAME-DESC                                36170000
MFA-TR*           FROM CSS_CONTRACT_INFO                                36180000
MFA-TR*         WHERE  CODE_CONTRACT_TYPE = :K6-CODE-CONTRACT-TYPE      36190000
MFA-TR*           AND  CNT_NAME_CD        = :K6-CNT-NAME-CD             36200000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    36210000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7245'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CONTRACT_INFO'   TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15604        MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'CODE_CONTRACT_TYPE'  TO TABLE-ELEMENT-2             
              MOVE K6-CODE-CONTRACT-TYPE TO HOSTVAR-ELEMENT-2           
T15604        MOVE 'CNT_NAME_CD'         TO TABLE-ELEMENT-3             
              MOVE K6-CNT-NAME-CD        TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7245-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-SELECT-DEP.                                                 
           EXEC SQL                                                     
                SELECT AMT_MO_PYMT,                                     
                       DATE_PYMT_START,                                 
                       NO_SCHED_PYMTS,                                  
                       AMT_ORIG_ENTERED                                 
                  INTO :DR-AMT-MO-PYMT,                                 
                       :DR-DATE-PYMT-START,                             
                       :DR-NO-SCHED-PYMTS,                              
                       :DR-AMT-ORIG-ENTERED                             
                  FROM CSS_DEP_REQ WITH(READUNCOMMITTED)                        
                WHERE  ACCOUNT_NO        = :DR-ACCOUNT-NO               
                  AND  PYMT_PRIORITY_LVL = :DR-PYMT-PRIORITY-LVL        
                  AND  DEP_ITEM_ID       = :DR-DEP-ITEM-ID              
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     36420000
MFA-TR*         SELECT AMT_MO_PYMT,                                     36430000
MFA-TR*                DATE_PYMT_START,                                 36440000
MFA-TR*                NO_SCHED_PYMTS,                                  36450000
MFA-TR*                AMT_ORIG_ENTERED                                 36460000
MFA-TR*           INTO :DR-AMT-MO-PYMT,                                 36470000
MFA-TR*                :DR-DATE-PYMT-START,                             36480000
MFA-TR*                :DR-NO-SCHED-PYMTS,                              36490000
MFA-TR*                :DR-AMT-ORIG-ENTERED                             36500000
MFA-TR*           FROM CSS_DEP_REQ                                      36510000
MFA-TR*         WHERE  ACCOUNT_NO        = :DR-ACCOUNT-NO               36520000
MFA-TR*           AND  PYMT_PRIORITY_LVL = :DR-PYMT-PRIORITY-LVL        36530000
MFA-TR*           AND  DEP_ITEM_ID       = :DR-DEP-ITEM-ID              36540000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    36550000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7250'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DEP_REQ'         TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PYMT_PRIORITY-LVL'   TO TABLE-ELEMENT-2             
              MOVE DR-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
T15604        MOVE 'DEP_ITEM_ID'         TO TABLE-ELEMENT-3             
              MOVE DR-DEP-ITEM-ID        TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7251-SELECT-CRED-COLL.                                           
           EXEC SQL                                                     
                SELECT CIS.CHAR2$DATE(DATE_NOTICE_DUE,'USA')                    
                  INTO :CL-DATE-NOTICE-DUE :WS-DATE-NOTICE-DUE-NI        
                  FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                      
                WHERE  ACCOUNT_NO        = :CL-ACCOUNT-NO               
PCR263            AND  CODE_NOTICE_TYPE  = 'O'                          
                  AND  ITEM_ID           = :CL-ITEM-ID                  
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     36770000
MFA-TR*         SELECT CHAR(DATE_NOTICE_DUE,USA)                        36780000
MFA-TR*           INTO :CL-DATE-NOTICE-DUE:WS-DATE-NOTICE-DUE-NI        36790000
MFA-TR*           FROM CSS_CRED_COLL                                    36800000
MFA-TR*         WHERE  ACCOUNT_NO        = :CL-ACCOUNT-NO               36810000
MFA-TR*           AND  CODE_NOTICE_TYPE  = 'O'                          36820000
MFA-TR*           AND  ITEM_ID           = :CL-ITEM-ID                  36830000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    36840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7251'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-2             
              MOVE CL-ITEM-ID            TO HOSTVAR-ELEMENT-2           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7251-EXIT.                                                       
           EXIT.                                                        
                                                                        
T10066 7252-OPEN-CRED-COLL.                                             
T10066     EXEC SQL                                                     
T10066          OPEN CRED_COLL                                          
T10066     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T10066                                                                  
T10066     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T10066     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T10066                    OR NOT-FOUND                                  
T10066        NEXT SENTENCE                                             
T10066     ELSE                                                         
T10066        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T10066        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T10066        MOVE '7251'                TO ACTIVE-PARAGRAPH            
T10066        MOVE 'OPEN'                TO ABEND-FUNCTION              
T10066        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T10066                                      ABEND-TABLES                
T10066        MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T10066        MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
                                                                        
T10066 7252-EXIT.                                                       
T10066     EXIT.                                                        
                                                                        
T10066 7253-FETCH-CRED-COLL.                                            
                                                                        
T10066     EXEC SQL                                                     
T10066         FETCH CRED_COLL                                          
T10066          INTO :CL-DATE-NOTICE-DUE :WS-NULL-INDICATOR              
T10066     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T10066     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T10066     IF WS-NULL-INDICATOR < 0                                     
T10066        MOVE SPACES           TO CL-DATE-NOTICE-DUE               
T10066     END-IF.                                                      
                                                                        
T10066     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T10066                           OR   NOT-FOUND                         
T10066        NEXT SENTENCE                                             
T10066     ELSE                                                         
T10066        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T10066        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T10066        MOVE '7253'                TO ACTIVE-PARAGRAPH            
T10066        MOVE 'FETCH'               TO ABEND-FUNCTION              
T10066        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T10066                                      ABEND-TABLES                
              MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T10066        MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
                                                                        
T10066 7253-EXIT.                                                       
T10066     EXIT.                                                        
                                                                        
T10066 7254-CLOSE-CRED-COLL.                                            
                                                                        
T10066     EXEC SQL                                                     
T10066        CLOSE CRED_COLL                                           
T10066     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T10066     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T10066     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T10066                  OR NOT-FOUND                                    
T10066        NEXT SENTENCE                                             
T10066     ELSE                                                         
T10066        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T10066        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T10066        MOVE '7254'                TO ACTIVE-PARAGRAPH            
T10066        MOVE 'CLOSE'               TO ABEND-FUNCTION              
T10066        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T10066                                      ABEND-TABLES                
T10066        MOVE 'CSS_CRED_COLL'       TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T10066        MOVE CL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
                                                                        
T10066 7254-EXIT.                                                       
T10066     EXIT.                                                        
                                                                        
       7260-SELECT-DFA.                                                 
           EXEC SQL                                                     
                SELECT AMT_MO_PYMT,                                     
                       DATE_PYMT_START,                                 
                       NO_SCHED_PYMTS,                                  
                       AMT_ORIG_ENTERED,                                
                       CODE_DFA_TYPE,                                   
                       FRST_ERNST_PAY_DT,                               
C24880                 CODE_DFA_DESC                                    
                  INTO :DA-AMT-MO-PYMT,                                 
                       :DA-DATE-PYMT-START :WS-NULL-INDICATOR2,          
                       :DA-NO-SCHED-PYMTS,                              
                       :DA-AMT-ORIG-ENTERED,                            
                       :DA-CODE-DFA-TYPE,                               
                       :DA-FRST-ERNST-PAY-DT :WS-NULL-INDICATOR,         
C24880                 :DA-CODE-DFA-DESC                                
                FROM   CSS_DFA_ACCT WITH(READUNCOMMITTED)                       
                WHERE  ACCOUNT_NO        = :DA-ACCOUNT-NO               
                AND    PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL        
                AND    DFA_ITEM_ID       = :DA-DFA-ITEM-ID              
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     37860000
MFA-TR*         SELECT AMT_MO_PYMT,                                     37870000
MFA-TR*                DATE_PYMT_START,                                 37880000
MFA-TR*                NO_SCHED_PYMTS,                                  37890000
MFA-TR*                AMT_ORIG_ENTERED,                                37900000
MFA-TR*                CODE_DFA_TYPE,                                   37910000
MFA-TR*                FRST_ERNST_PAY_DT,                               37920000
MFA-TR*                CODE_DFA_DESC                                            
MFA-TR*           INTO :DA-AMT-MO-PYMT,                                 37930000
MFA-TR*                :DA-DATE-PYMT-START:WS-NULL-INDICATOR2,          37940000
MFA-TR*                :DA-NO-SCHED-PYMTS,                              37950000
MFA-TR*                :DA-AMT-ORIG-ENTERED,                            37960000
MFA-TR*                :DA-CODE-DFA-TYPE,                               37970000
MFA-TR*                :DA-FRST-ERNST-PAY-DT:WS-NULL-INDICATOR,         37980000
MFA-TR*                :DA-CODE-DFA-DESC                                        
MFA-TR*         FROM   CSS_DFA_ACCT                                     37990000
MFA-TR*         WHERE  ACCOUNT_NO        = :DA-ACCOUNT-NO               38000000
MFA-TR*         AND    PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL        38010000
MFA-TR*         AND    DFA_ITEM_ID       = :DA-DFA-ITEM-ID              38020000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    38030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7260'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DFA_ACCT'        TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DA-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE DA-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
T15604        MOVE 'DFA_ITEM_ID'          TO TABLE-ELEMENT-3            
              MOVE DA-DFA-ITEM-ID        TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7265-SELECT-DFA-FRST-ERNST.                                      
           EXEC SQL                                                     
                SELECT 'Y'                                              
                  INTO :WS-RECORD-EXISTS                                
                FROM   CSS_DFA_ACCT WITH(READUNCOMMITTED)                       
                WHERE  ACCOUNT_NO        = :DA-ACCOUNT-NO               
                AND    PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL        
                AND    FRST_ERNST_PAY_DT = IIF(TRY_CONVERT(DATE, 
                                                  :DA-FRST-ERNST-PAY-DT
              ) IS NULL OR (PATINDEX('%.%', :DA-FRST-ERNST-PAY-DT
              ) <> 0) OR (LEN(:DA-FRST-ERNST-PAY-DT
              ) <> 10), CIS.CHAR2DATE(:DA-FRST-ERNST-PAY-DT
              ), CONVERT(DATE, :DA-FRST-ERNST-PAY-DT) )        
c34338          AND    CODE_DFA_TYPE     = 'B'                          
c34338          AND    CODE_DFA_STATUS   = 'A'                          
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     38250000
MFA-TR*         SELECT 'Y'                                              38260000
MFA-TR*           INTO :WS-RECORD-EXISTS                                38270000
MFA-TR*         FROM   CSS_DFA_ACCT                                     38280000
MFA-TR*         WHERE  ACCOUNT_NO        = :DA-ACCOUNT-NO               38290000
MFA-TR*         AND    PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL        38300000
MFA-TR*         AND    FRST_ERNST_PAY_DT = :DA-FRST-ERNST-PAY-DT        38310000
MFA-TR*         AND    CODE_DFA_TYPE     = 'B'                          38320000
MFA-TR*         AND    CODE_DFA_STATUS   = 'A'                          38330000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    38340000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7265'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DFA_ACCT'        TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DA-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE DA-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
T15604        MOVE 'FRST_ERNST_PAY_DT'   TO TABLE-ELEMENT-3             
              MOVE DA-FRST-ERNST-PAY-DT  TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7265-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7267-SELECT-DFA-SCND-ERNST.                                      
           EXEC SQL                                                     
                SELECT 'Y'                                              
                  INTO :WS-RECORD-EXISTS                                
                FROM   CSS_DFA_ACCT WITH(READUNCOMMITTED)                       
                WHERE  ACCOUNT_NO        = :DA-ACCOUNT-NO               
                AND    PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL        
                AND    SCND_ERNST_PAY_DT = IIF(TRY_CONVERT(DATE, 
                                                  :DA-SCND-ERNST-PAY-DT
              ) IS NULL OR (PATINDEX('%.%', :DA-SCND-ERNST-PAY-DT
              ) <> 0) OR (LEN(:DA-SCND-ERNST-PAY-DT
              ) <> 10), CIS.CHAR2DATE(:DA-SCND-ERNST-PAY-DT
              ), CONVERT(DATE, :DA-SCND-ERNST-PAY-DT) )        
c34338          AND    CODE_DFA_TYPE     = 'B'                          
c34338          AND    CODE_DFA_STATUS   = 'A'                          
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     38560000
MFA-TR*         SELECT 'Y'                                              38570000
MFA-TR*           INTO :WS-RECORD-EXISTS                                38580000
MFA-TR*         FROM   CSS_DFA_ACCT                                     38590000
MFA-TR*         WHERE  ACCOUNT_NO        = :DA-ACCOUNT-NO               38600000
MFA-TR*         AND    PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL        38610000
MFA-TR*         AND    SCND_ERNST_PAY_DT = :DA-SCND-ERNST-PAY-DT        38620000
MFA-TR*         AND    CODE_DFA_TYPE     = 'B'                          38630000
MFA-TR*         AND    CODE_DFA_STATUS   = 'A'                          38640000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    38650000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
C34338        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C34338           MOVE +5000                 TO RS-RETURN-CODE           
C34338                                         WS-ACTIVE-RETURN-CODE    
C34338        ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
C34338        END-IF                                                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7267'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DFA_ACCT'        TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DA-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PYMT_PRIORITY_LVL' TO TABLE-ELEMENT-2               
              MOVE DA-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
T15604        MOVE 'SCND_ERNST_PAY_DT' TO TABLE-ELEMENT-3               
              MOVE DA-SCND-ERNST-PAY-DT TO HOSTVAR-ELEMENT-3            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7267-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7270-SELECT-PJS.                                                 
           EXEC SQL                                                     
                SELECT                                                  
                       ACCT_TERM_DT,                                    
                       MONTHLY_BILL_AM                                  
                  INTO                                                  
                       :PJ-ACCT-TERM-DT :WS-NULL-INDICATOR,              
                       :PJ-MONTHLY-BILL-AM                              
                FROM   CSS_PROJ_SHARE WITH(READUNCOMMITTED)                     
                WHERE  ACCOUNT_NO        = :PJ-ACCOUNT-NO               
                AND    PYMT_PRIORITY_LVL = :PJ-PYMT-PRIORITY-LVL        
                AND    ITEM_ID           = :PJ-ITEM-ID                  
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     38870000
MFA-TR*         SELECT                                                  38880000
MFA-TR*                ACCT_TERM_DT,                                    38890000
MFA-TR*                MONTHLY_BILL_AM                                  38900000
MFA-TR*           INTO                                                  38910000
MFA-TR*                :PJ-ACCT-TERM-DT:WS-NULL-INDICATOR,              38920000
MFA-TR*                :PJ-MONTHLY-BILL-AM                              38930000
MFA-TR*         FROM   CSS_PROJ_SHARE                                   38940000
MFA-TR*         WHERE  ACCOUNT_NO        = :PJ-ACCOUNT-NO               38950000
MFA-TR*         AND    PYMT_PRIORITY_LVL = :PJ-PYMT-PRIORITY-LVL        38960000
MFA-TR*         AND    ITEM_ID           = :PJ-ITEM-ID                  38970000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    38980000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-INDICATOR = -1                                 
                 MOVE SPACES TO PJ-ACCT-TERM-DT                         
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7270'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PROJ_SHARE'      TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PJ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE PJ-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
T15604        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE PJ-ITEM-ID            TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7340-SELECT-CREDIT-PROFILE.                                      
           EXEC SQL                                                     
                SELECT CASH_ONLY_FL                                     
                INTO   :CZ-CASH-ONLY-FL                                 
                FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                       
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     39220000
MFA-TR*         SELECT CASH_ONLY_FL                                     39230000
MFA-TR*         INTO   :CZ-CASH-ONLY-FL                                 39240000
MFA-TR*         FROM CSS_CREDIT_PROFILE                                 39250000
MFA-TR*         WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                       39260000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    39270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7340'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CREDIT_PROFILE'  TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CZ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7350-SELECT-PREMISE.                                             
           EXEC SQL                                                     
                SELECT ADDRESS_ID,                                      
                       REV_DISTRICT_CD                                  
                INTO   :PR-ADDRESS-ID,                                  
                       :PR-REV-DISTRICT-CD                              
                FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     39470000
MFA-TR*         SELECT ADDRESS_ID,                                      39480000
MFA-TR*                REV_DISTRICT_CD                                  39490000
MFA-TR*         INTO   :PR-ADDRESS-ID,                                  39500000
MFA-TR*                :PR-REV-DISTRICT-CD                              39510000
MFA-TR*         FROM CSS_PREMISE                                        39520000
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                       39530000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    39540000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7350'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
T15604        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-SELECT-AR-CNTL.                                             
           EXEC SQL                                                     
                SELECT AMT_TRAN_BALANCE                                 
                INTO   :AC-AMT-TRAN-BALANCE                             
                FROM   CSS_AR_CNTL WITH(READUNCOMMITTED)                        
                WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO               
                AND    PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL        
                AND    ITEM_ID           = :AC-ITEM-ID                  
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     39740000
MFA-TR*         SELECT AMT_TRAN_BALANCE                                 39750000
MFA-TR*         INTO   :AC-AMT-TRAN-BALANCE                             39760000
MFA-TR*         FROM   CSS_AR_CNTL                                      39770000
MFA-TR*         WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO               39780000
MFA-TR*         AND    PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL        39790000
MFA-TR*         AND    ITEM_ID           = :AC-ITEM-ID                  39800000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    39810000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
T15604        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7500-SELECT-ADDR-FORMATTED.                                      
           EXEC SQL                                                     
              SELECT HOUSE_NO,          ADDR_PREFIX_1,                  
                     ADDR_PREFIX_2,     STREET_NAME,                    
                     STREET_LOCATION_1, STREET_LOCATION_2,              
C35842               STREET_SUFFIX,     ZIP_CODE                        
              INTO   :DY-HOUSE-NO,          :DY-ADDR-PREFIX-1,          
                     :DY-ADDR-PREFIX-2,     :DY-STREET-NAME,            
                     :DY-STREET-LOCATION-1, :DY-STREET-LOCATION-2,      
C35842               :DY-STREET-SUFFIX,     :DY-ZIP-CODE                
              FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                     
              WHERE ADDRESS_ID = :DY-ADDRESS-ID                         
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     40040000
MFA-TR*       SELECT HOUSE_NO,          ADDR_PREFIX_1,                  40050000
MFA-TR*              ADDR_PREFIX_2,     STREET_NAME,                    40060000
MFA-TR*              STREET_LOCATION_1, STREET_LOCATION_2,              40070000
MFA-TR*              STREET_SUFFIX,     ZIP_CODE                        40080000
MFA-TR*       INTO   :DY-HOUSE-NO,          :DY-ADDR-PREFIX-1,          40090000
MFA-TR*              :DY-ADDR-PREFIX-2,     :DY-STREET-NAME,            40100000
MFA-TR*              :DY-STREET-LOCATION-1, :DY-STREET-LOCATION-2,      40110000
MFA-TR*              :DY-STREET-SUFFIX,     :DY-ZIP-CODE                40120000
MFA-TR*       FROM CSS_ADDR_FORMATTED                                   40130000
MFA-TR*       WHERE ADDRESS_ID = :DY-ADDRESS-ID                         40140000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    40150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                 OR   NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-1                     
T15604        MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1             
              MOVE DY-ADDRESS-ID         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
T15604        MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-2           
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
T15604        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-OPEN-CHARGE-OFF-CURSOR.                                     
           EXEC SQL                                                     
               OPEN CHRG_OFF                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CHRG_OFF'        TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE CO-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
T15604        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE CO-ITEM-ID            TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7610-FETCH-CHARGE-OFF-CURSOR.                                    
           EXEC SQL                                                     
               FETCH CHRG_OFF                                           
                INTO :CO-PYMT-PRIORITY-LVL,                             
                     :CO-ITEM-ID,                                       
                     :CO-AMT-TRANS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                 OR   NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7610'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CHRG_OFF'        TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE CO-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
T15604        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE CO-ITEM-ID            TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7620-CLOSE-CHARGE-OFF-CURSOR.                                    
           EXEC SQL                                                     
               CLOSE CHRG_OFF                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7620'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CHRG_OFF'        TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE CO-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
T15604        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE CO-ITEM-ID            TO HOSTVAR-ELEMENT-3           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-OPEN-MTH-CRE-CURSOR.                                        
           EXEC SQL                                                     
               OPEN MTH-CRE-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7700'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CONTRACT'        TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7710-FETCH-MTH-CRE-CURSOR.                                       
           EXEC SQL                                                     
               FETCH MTH-CRE-CURSOR                                     
                INTO :CT-AMT-MO-PYMT,                                   
                     :CT-CODE-BILL-TYPE,                                
                     :CT-CNT-ITEM-ID,                                   
                     :CT-PYMT-PRIORITY-LVL,                             
                     :CT-CODE-CONTRACT-TYPE,                            
                     :CT-CNT-NAME-CD,                                   
                     :CT-DATE-PYMT-START,                               
                     :CT-CODE-INTRST-METH,                              
                     :CT-INTRST-PRIOR-YR,                               
                     :CT-NO-SCHED-PYMTS,                                
                     :CT-AMT-ORIG-ENTERED                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                 OR   NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7710'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CONTRACT'        TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7720-CLOSE-MTH-CRE-CURSOR.                                       
           EXEC SQL                                                     
               CLOSE MTH-CRE-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7720'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CONTRACT'        TO TABLE-1                     
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7900-SELECT-NAME-ACCT-XREF.                                      
           EXEC SQL                                                     
              SELECT B.NAME_ID,       B.FULL_NAME,                      
                     B.NAME_FORMAT,   B.FIRST_NAME,                     
                     B.MIDDLE_NAME,   B.LAST_NAME,                      
                     B.TITLE_PREFIX,  B.TITLE_SUFFIX_1,                 
                     B.TITLE_SUFFIX_2                                   
              INTO   :DQ-NAME-ID,     :DQ-FULL-NAME,                    
                     :DQ-NAME-FORMAT, :DQ-FIRST-NAME,                   
                     :DQ-MIDDLE-NAME, :DQ-LAST-NAME,                    
                     :DQ-TITLE-PREFIX,:DQ-TITLE-SUFFIX-1,               
                     :DQ-TITLE-SUFFIX-2                                 
              FROM CSS_CUSTOMER A WITH(READUNCOMMITTED),                        
                   CSS_NAME B WITH(READUNCOMMITTED)                             
              WHERE A.CUSTOMER_NO = :AT-CUSTOMER-NO                     
                AND A.NAME_ID     = B.NAME_ID                           
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     41900000
MFA-TR*       SELECT B.NAME_ID,       B.FULL_NAME,                      41910000
MFA-TR*              B.NAME_FORMAT,   B.FIRST_NAME,                     41920000
MFA-TR*              B.MIDDLE_NAME,   B.LAST_NAME,                      41930000
MFA-TR*              B.TITLE_PREFIX,  B.TITLE_SUFFIX_1,                 41940000
MFA-TR*              B.TITLE_SUFFIX_2                                   41950000
MFA-TR*       INTO   :DQ-NAME-ID,     :DQ-FULL-NAME,                    41960000
MFA-TR*              :DQ-NAME-FORMAT, :DQ-FIRST-NAME,                   41970000
MFA-TR*              :DQ-MIDDLE-NAME, :DQ-LAST-NAME,                    41980000
MFA-TR*              :DQ-TITLE-PREFIX,:DQ-TITLE-SUFFIX-1,               41990000
MFA-TR*              :DQ-TITLE-SUFFIX-2                                 42000000
MFA-TR*       FROM CSS_CUSTOMER A,                                      42010000
MFA-TR*            CSS_NAME B                                           42020000
MFA-TR*       WHERE A.CUSTOMER_NO = :AT-CUSTOMER-NO                     42030000
MFA-TR*         AND A.NAME_ID     = B.NAME_ID                           42040000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    42050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                 OR   NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7900'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_NAME'            TO TABLE-1                     
T15604        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE AT-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
T15604        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR361     END-IF.                                                      
       7900-EXIT.                                                       
           EXIT.                                                        
T11466                                                                  
T11466 7960-GET-DATE-DIFF.                                              
T11466                                                                  
T11466     EXEC SQL                                                     
T34338          SELECT
              CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) -                     
T34338                   CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                      :WS-MAX-INTRST-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-INTRST-DT
              ) <> 0) OR (LEN(:WS-MAX-INTRST-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-MAX-INTRST-DT
              ), CONVERT(DATE, :WS-MAX-INTRST-DT) ))
            INTO
              :WS-NUM-OF-DAYS-FOR-INT                 
T11466     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     42530000
MFA-TR*         SET :WS-NUM-OF-DAYS-FOR-INT =                           42530000
MFA-TR*                ( DAYS(DATE(CURRENT DATE)) -                     42540000
MFA-TR*                  DAYS(DATE(:WS-MAX-INTRST-DT)))                 42550000
MFA-TR*    END-EXEC                                                     42580000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11466                                                                  
T11466     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T11466     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T11466        NEXT SENTENCE                                             
T11466     ELSE                                                         
T11466        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T11466        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T11466        MOVE '7960'                TO ACTIVE-PARAGRAPH            
T11466        MOVE 'SET'                 TO ABEND-FUNCTION              
T11466        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T11466                                      ABEND-TABLES                
T11466        MOVE SPACES                TO TABLE-1                     
T15604        MOVE SPACES                TO TABLE-ELEMENT-1             
T15604        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
T11466        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T11466     END-IF.                                                      
T11466 7960-EXIT.                                                       
T11466     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************07730000
REARCH* 8000A-DELETE-GTT-ROWS                                          *07740000
REARCH******************************************************************07800000
REARCH*8000A-DELETE-GTT-ROWS.                                                   
REARCH*                                                                         
REARCH*    MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.                  
REARCH*                                                                         
REARCH*    EXEC SQL                                                             
REARCH*        DELETE FROM SESSION.CSR02021_R1                                  
REARCH*    END-EXEC.                                                            
REARCH*                                                                         
REARCH*    MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.              
REARCH*                                                                         
REARCH*    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
REARCH*       NEXT SENTENCE                                                     
REARCH*    ELSE                                                                 
REARCH*       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
REARCH*       MOVE '8000A'               TO ACTIVE-PARAGRAPH                    
REARCH*       MOVE 'DELETE'              TO ABEND-FUNCTION                      
REARCH*       MOVE SQLCODE               TO ABEND-SQLCODE                       
REARCH*       MOVE SPACES                TO ABEND-SQL-PREDICATES                
REARCH*                                             ABEND-TABLES                
REARCH*       MOVE 'CSR02021_R1'         TO TABLE-1                             
REARCH*       MOVE SPACES                TO TABLE-ELEMENT-1                     
REARCH*       MOVE SPACES                TO HOSTVAR-ELEMENT-1                   
REARCH*       PERFORM 9000-SEND-ERROR-RESULT                                    
REARCH*                                  THRU 9000-EXIT                         
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE                                    
REARCH*                                  THRU 9900-EXIT                         
REARCH*    END-IF.                                                              
REARCH*                                                                         
REARCH*8000A-EXIT.                                                              
REARCH*    EXIT.                                                                
REARCH*                                                                         
REARCH******************************************************************07730000
REARCH* 8100-SEND-RESULT                                               *07740000
REARCH******************************************************************07800000
REARCH 8100-SEND-RESULT.                                                
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02021_R1                         
REARCH          (                                                       
REARCH               RETURN_CODE                                        
REARCH              ,RECV_TYPE                                          
REARCH              ,RECV_DESC                                          
REARCH              ,PYMT_PRIORITY_LVL                                  
REARCH              ,ITEM_ID                                            
REARCH              ,SPECIAL_DUE_DATE                                   
REARCH              ,UTIL_RELATED                                       
REARCH              ,FULL_BALANCE                                       
REARCH              ,NBR_PYMTS_REMAIN                                   
REARCH              ,MNTH_PYMT_AMT                                      
REARCH              ,BILLED_BALANCE                                     
REARCH              ,AMT_AR_DAY_00                                      
REARCH              ,AMT_AR_DAY_30                                      
REARCH              ,AMT_AR_DAY_60                                      
REARCH              ,AMT_AR_DAY_90                                      
REARCH              ,DATE_BILL_DAY_00                                   
REARCH              ,DATE_BILL_DAY_30                                   
REARCH              ,DATE_BILL_DAY_60                                   
REARCH              ,DATE_BILL_DAY_90                                   
REARCH              ,ARREARS_DUE_DATE                                   
REARCH              ,PAST_DUE_AMOUNT                                    
REARCH              ,CURRENT_DUE_DATE                                   
REARCH              ,ACCOUNT_ARREARS                                    
REARCH              ,EPP_IND                                            
REARCH              ,DPP_IND                                            
REARCH              ,DFA_IND                                            
REARCH              ,STA_IND                                            
REARCH              ,CANREB_CODE_00                                     
REARCH              ,CANREB_CODE_30                                     
REARCH              ,CANREB_CODE_60                                     
REARCH              ,CANREB_CODE_90                                     
REARCH              ,AMT_DIRECT_PYMT                                    
REARCH              ,CODE_PAY_AHEAD                                     
REARCH              ,ACCOUNT_NO                                         
REARCH              ,CODE_ACCT_STAT                                     
REARCH              ,ACCT_XFER_TO                                       
REARCH              ,CREDIT_GROUP                                       
REARCH              ,CASH_ONLY                                          
REARCH              ,NO_BAD_CHECKS                                      
REARCH              ,DNP_STATUS                                         
REARCH              ,CODE_BANKRUPT                                      
REARCH              ,CODE_PREPAID_MTR                                   
REARCH              ,DISC_BALANCE                                       
REARCH              ,DATE_DISC                                          
REARCH              ,TOTAL_AR_BALANCE                                   
REARCH              ,DATE_NEXT_BILL                                     
REARCH              ,CHRG_CARD_AUTH                                     
REARCH              ,DATE_LIHEAP_START                                  
REARCH              ,DATE_LIHEAP_END                                    
REARCH              ,FULL_NAME                                          
REARCH              ,ADDRESS                                            
REARCH              ,AC_LAST_UPDATE_TS                                  
REARCH              ,AT_LAST_UPDATE_TS                                  
REARCH              ,CHRG_OFF_AR                                        
REARCH              ,AMT_TOT_RECONNECT                                  
REARCH              ,AMT_RCNCT_COLL                                     
REARCH              ,RECONNECT_IND                                      
REARCH              ,LIEN_CD                                            
REARCH              ,AMT_PAYOFF                                         
REARCH              ,PRINT_NAME                                         
REARCH              ,CNT_LONG_DESC                                      
REARCH              ,MEDICAL_FLAG                                       
REARCH              ,AMT_UNUSED_CREDIT                                  
REARCH              ,TOT_SUMM_UNBILLED                                  
C33998              ,WRITEOFF_FLAG                                      
C35842              ,ZIP_CODE                                           
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH               :S-RETURN-CODE                                     
REARCH              ,:S-RECV-TYPE                                       
REARCH              ,:S-RECV-DESC                                       
REARCH              ,:S-PYMT-PRIORITY-LVL                               
REARCH              ,:S-ITEM-ID                                         
REARCH              ,:S-SPECIAL-DUE-DATE                                
REARCH              ,:S-UTIL-RELATED                                    
REARCH              ,:S-FULL-BALANCE                                    
REARCH              ,:S-NBR-PYMTS-REMAIN                                
REARCH              ,:S-MNTH-PYMT-AMT                                   
REARCH              ,:S-BILLED-BALANCE                                  
REARCH              ,:S-AMT-AR-DAY-00                                   
REARCH              ,:S-AMT-AR-DAY-30                                   
REARCH              ,:S-AMT-AR-DAY-60                                   
REARCH              ,:S-AMT-AR-DAY-90                                   
REARCH              ,:S-DATE-BILL-DAY-00                                
REARCH              ,:S-DATE-BILL-DAY-30                                
REARCH              ,:S-DATE-BILL-DAY-60                                
REARCH              ,:S-DATE-BILL-DAY-90                                
REARCH              ,:S-ARREARS-DUE-DATE                                
REARCH              ,:S-PAST-DUE-AMOUNT                                 
REARCH              ,:S-CURRENT-DUE-DATE                                
REARCH              ,:S-ACCOUNT-ARREARS                                 
REARCH              ,:S-EPP-IND                                         
REARCH              ,:S-DPP-IND                                         
REARCH              ,:S-DFA-IND                                         
REARCH              ,:S-STA-IND                                         
REARCH              ,:S-CANREB-CODE-00                                  
REARCH              ,:S-CANREB-CODE-30                                  
REARCH              ,:S-CANREB-CODE-60                                  
REARCH              ,:S-CANREB-CODE-90                                  
REARCH              ,:S-AMT-DIRECT-PYMT                                 
REARCH              ,:S-CODE-PAY-AHEAD                                  
REARCH              ,:S-ACCOUNT-NO                                      
REARCH              ,:S-CODE-ACCT-STAT                                  
REARCH              ,:S-ACCT-XFER-TO                                    
REARCH              ,:S-CREDIT-GROUP                                    
REARCH              ,:S-CASH-ONLY                                       
REARCH              ,:S-NO-BAD-CHECKS                                   
REARCH              ,:S-DNP-STATUS                                      
REARCH              ,:S-CODE-BANKRUPT                                   
REARCH              ,:S-CODE-PREPAID-MTR                                
REARCH              ,:S-DISC-BALANCE                                    
REARCH              ,:S-DATE-DISC                                       
REARCH              ,:S-TOTAL-AR-BALANCE                                
REARCH              ,:S-DATE-NEXT-BILL                                  
REARCH              ,:S-CHRG-CARD-AUTH                                  
REARCH              ,:S-DATE-LIHEAP-START                               
REARCH              ,:S-DATE-LIHEAP-END                                 
REARCH              ,:S-FULL-NAME                                       
REARCH              ,:S-ADDRESS                                         
REARCH              ,:S-AC-LAST-UPDATE-TS                               
REARCH              ,:S-AT-LAST-UPDATE-TS                               
REARCH              ,:S-CHRG-OFF-AR                                     
REARCH              ,:S-AMT-TOT-RECONNECT                               
REARCH              ,:S-AMT-RCNCT-COLL                                  
REARCH              ,:S-RECONNECT-IND                                   
REARCH              ,:S-LIEN-CD                                         
REARCH              ,:S-AMT-PAYOFF                                      
REARCH              ,:S-PRINT-NAME                                      
REARCH              ,:S-CNT-LONG-DESC                                   
REARCH              ,:S-MEDICAL-FLAG                                    
REARCH              ,:S-AMT-UNUSED-CREDIT                               
REARCH              ,:S-TOT-SUMM-UNBILLED                               
C33998              ,:S-WRITEOFF-FLAG                                   
C35842              ,:S-ZIP-CODE                                        
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     42750000
MFA-TR*         INSERT INTO SESSION.CSR02021_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,RECV_TYPE                                                  
MFA-TR*             ,RECV_DESC                                                  
MFA-TR*             ,PYMT_PRIORITY_LVL                                          
MFA-TR*             ,ITEM_ID                                                    
MFA-TR*             ,SPECIAL_DUE_DATE                                           
MFA-TR*             ,UTIL_RELATED                                               
MFA-TR*             ,FULL_BALANCE                                               
MFA-TR*             ,NBR_PYMTS_REMAIN                                           
MFA-TR*             ,MNTH_PYMT_AMT                                              
MFA-TR*             ,BILLED_BALANCE                                             
MFA-TR*             ,AMT_AR_DAY_00                                              
MFA-TR*             ,AMT_AR_DAY_30                                              
MFA-TR*             ,AMT_AR_DAY_60                                              
MFA-TR*             ,AMT_AR_DAY_90                                              
MFA-TR*             ,DATE_BILL_DAY_00                                           
MFA-TR*             ,DATE_BILL_DAY_30                                           
MFA-TR*             ,DATE_BILL_DAY_60                                           
MFA-TR*             ,DATE_BILL_DAY_90                                           
MFA-TR*             ,ARREARS_DUE_DATE                                           
MFA-TR*             ,PAST_DUE_AMOUNT                                            
MFA-TR*             ,CURRENT_DUE_DATE                                           
MFA-TR*             ,ACCOUNT_ARREARS                                            
MFA-TR*             ,EPP_IND                                                    
MFA-TR*             ,DPP_IND                                                    
MFA-TR*             ,DFA_IND                                                    
MFA-TR*             ,STA_IND                                                    
MFA-TR*             ,CANREB_CODE_00                                             
MFA-TR*             ,CANREB_CODE_30                                             
MFA-TR*             ,CANREB_CODE_60                                             
MFA-TR*             ,CANREB_CODE_90                                             
MFA-TR*             ,AMT_DIRECT_PYMT                                            
MFA-TR*             ,CODE_PAY_AHEAD                                             
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,ACCT_XFER_TO                                               
MFA-TR*             ,CREDIT_GROUP                                               
MFA-TR*             ,CASH_ONLY                                                  
MFA-TR*             ,NO_BAD_CHECKS                                              
MFA-TR*             ,DNP_STATUS                                                 
MFA-TR*             ,CODE_BANKRUPT                                              
MFA-TR*             ,CODE_PREPAID_MTR                                           
MFA-TR*             ,DISC_BALANCE                                               
MFA-TR*             ,DATE_DISC                                                  
MFA-TR*             ,TOTAL_AR_BALANCE                                           
MFA-TR*             ,DATE_NEXT_BILL                                             
MFA-TR*             ,CHRG_CARD_AUTH                                             
MFA-TR*             ,DATE_LIHEAP_START                                          
MFA-TR*             ,DATE_LIHEAP_END                                            
MFA-TR*             ,FULL_NAME                                                  
MFA-TR*             ,ADDRESS                                                    
MFA-TR*             ,AC_LAST_UPDATE_TS                                          
MFA-TR*             ,AT_LAST_UPDATE_TS                                          
MFA-TR*             ,CHRG_OFF_AR                                                
MFA-TR*             ,AMT_TOT_RECONNECT                                          
MFA-TR*             ,AMT_RCNCT_COLL                                             
MFA-TR*             ,RECONNECT_IND                                              
MFA-TR*             ,LIEN_CD                                                    
MFA-TR*             ,AMT_PAYOFF                                                 
MFA-TR*             ,PRINT_NAME                                                 
MFA-TR*             ,CNT_LONG_DESC                                              
MFA-TR*             ,MEDICAL_FLAG                                               
MFA-TR*             ,AMT_UNUSED_CREDIT                                          
MFA-TR*             ,TOT_SUMM_UNBILLED                                          
MFA-TR*             ,WRITEOFF_FLAG                                              
MFA-TR*             ,ZIP_CODE                                                   
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-RECV-TYPE                                               
MFA-TR*             ,:S-RECV-DESC                                               
MFA-TR*             ,:S-PYMT-PRIORITY-LVL                                       
MFA-TR*             ,:S-ITEM-ID                                                 
MFA-TR*             ,:S-SPECIAL-DUE-DATE                                        
MFA-TR*             ,:S-UTIL-RELATED                                            
MFA-TR*             ,:S-FULL-BALANCE                                            
MFA-TR*             ,:S-NBR-PYMTS-REMAIN                                        
MFA-TR*             ,:S-MNTH-PYMT-AMT                                           
MFA-TR*             ,:S-BILLED-BALANCE                                          
MFA-TR*             ,:S-AMT-AR-DAY-00                                           
MFA-TR*             ,:S-AMT-AR-DAY-30                                           
MFA-TR*             ,:S-AMT-AR-DAY-60                                           
MFA-TR*             ,:S-AMT-AR-DAY-90                                           
MFA-TR*             ,:S-DATE-BILL-DAY-00                                        
MFA-TR*             ,:S-DATE-BILL-DAY-30                                        
MFA-TR*             ,:S-DATE-BILL-DAY-60                                        
MFA-TR*             ,:S-DATE-BILL-DAY-90                                        
MFA-TR*             ,:S-ARREARS-DUE-DATE                                        
MFA-TR*             ,:S-PAST-DUE-AMOUNT                                         
MFA-TR*             ,:S-CURRENT-DUE-DATE                                        
MFA-TR*             ,:S-ACCOUNT-ARREARS                                         
MFA-TR*             ,:S-EPP-IND                                                 
MFA-TR*             ,:S-DPP-IND                                                 
MFA-TR*             ,:S-DFA-IND                                                 
MFA-TR*             ,:S-STA-IND                                                 
MFA-TR*             ,:S-CANREB-CODE-00                                          
MFA-TR*             ,:S-CANREB-CODE-30                                          
MFA-TR*             ,:S-CANREB-CODE-60                                          
MFA-TR*             ,:S-CANREB-CODE-90                                          
MFA-TR*             ,:S-AMT-DIRECT-PYMT                                         
MFA-TR*             ,:S-CODE-PAY-AHEAD                                          
MFA-TR*             ,:S-ACCOUNT-NO                                              
MFA-TR*             ,:S-CODE-ACCT-STAT                                          
MFA-TR*             ,:S-ACCT-XFER-TO                                            
MFA-TR*             ,:S-CREDIT-GROUP                                            
MFA-TR*             ,:S-CASH-ONLY                                               
MFA-TR*             ,:S-NO-BAD-CHECKS                                           
MFA-TR*             ,:S-DNP-STATUS                                              
MFA-TR*             ,:S-CODE-BANKRUPT                                           
MFA-TR*             ,:S-CODE-PREPAID-MTR                                        
MFA-TR*             ,:S-DISC-BALANCE                                            
MFA-TR*             ,:S-DATE-DISC                                               
MFA-TR*             ,:S-TOTAL-AR-BALANCE                                        
MFA-TR*             ,:S-DATE-NEXT-BILL                                          
MFA-TR*             ,:S-CHRG-CARD-AUTH                                          
MFA-TR*             ,:S-DATE-LIHEAP-START                                       
MFA-TR*             ,:S-DATE-LIHEAP-END                                         
MFA-TR*             ,:S-FULL-NAME                                               
MFA-TR*             ,:S-ADDRESS                                                 
MFA-TR*             ,:S-AC-LAST-UPDATE-TS                                       
MFA-TR*             ,:S-AT-LAST-UPDATE-TS                                       
MFA-TR*             ,:S-CHRG-OFF-AR                                             
MFA-TR*             ,:S-AMT-TOT-RECONNECT                                       
MFA-TR*             ,:S-AMT-RCNCT-COLL                                          
MFA-TR*             ,:S-RECONNECT-IND                                           
MFA-TR*             ,:S-LIEN-CD                                                 
MFA-TR*             ,:S-AMT-PAYOFF                                              
MFA-TR*             ,:S-PRINT-NAME                                              
MFA-TR*             ,:S-CNT-LONG-DESC                                           
MFA-TR*             ,:S-MEDICAL-FLAG                                            
MFA-TR*             ,:S-AMT-UNUSED-CREDIT                                       
MFA-TR*             ,:S-TOT-SUMM-UNBILLED                                       
MFA-TR*             ,:S-WRITEOFF-FLAG                                           
MFA-TR*             ,:S-ZIP-CODE                                                
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
REARCH         ADD +1                    TO CTR-ROWS                    
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
REARCH         MOVE SQLCODE              TO ABEND-SQLCODE               
REARCH         MOVE '8100'               TO ACTIVE-PARAGRAPH            
REARCH         MOVE 'INSERT'             TO ABEND-FUNCTION              
REARCH         MOVE SPACES               TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH         MOVE 'CSR02021_R1'        TO TABLE-1                     
REARCH         MOVE SPACES               TO TABLE-ELEMENT-1             
REARCH         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH*                                                                         
PCR361     EXEC SQL                                                     42760000
PCR361        INCLUDE CPD0023C                                          42770000
PCR361     END-EXEC.                                                    42780000
PCR361                                                                  
T19557 9500-CALL-CPD00068.                                              
T19557                                                                  
REARCH     CALL MCSCB068  USING  CWS00068-FIELDS                        
REARCH                           WS-CODES-DATA-PRESENT                  
REARCH                           DCLCSS-ACCOUNT                         
REARCH                           ABEND-FILE                             
REARCH                           RS-RETURN-CODE.                        
REARCH     MOVE RS-RETURN-CODE      TO WS-ACTIVE-RETURN-CODE,           
REARCH                                 S-RETURN-CODE.                   
REARCH     IF ABEND-FUNCTION  > SPACES                                  
REARCH         IF ABEND-FUNCTION EQUAL 'BADDATA'                        
REARCH            MOVE -1           TO S-RETURN-CODE,                   
REARCH                                 WS-ACTIVE-RETURN-CODE            
REARCH         END-IF                                                   
REARCH         PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT            
REARCH         PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
REARCH     END-IF.                                                      
T19557                                                                  
T19557 9500-EXIT.                                                       
T19557     EXIT.                                                        
                                                                        
      ******************************************************************42800000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *42810000
      ******************************************************************42820000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************42870000
      *       END PROGRAM COPYLIB                                      *42880000
      ******************************************************************42890000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
