       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR02016.                                          
       DATE-WRITTEN. JAN 11, 1995.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S016                                           *        
      *  PROGRAM:       S016                                           *        
      *  CALLING SP:    PN_S016                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES THE ALL TRANSACTION SUMMARY ROWS FROM  *        
      *  TABLES CSS_AR_TRANS_HIST AND CSS_MNT_TRANS_HIST.              *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  01/12/95    RKL      CREATED.                                 *        
      *  05/09/95    GC       ADDED 7116 DUE TO TPR 5150               *        
      *                       ADDED 2350-INIT-VARIABLES TO CLEAR DOWN  *        
      *                       REPEATED VALUES.                         *        
      *  05/17/95    GC       ADDED ALL NULL INDICATOR PROCESSING.     *        
      *  05/18/95    GC       COMMENTED OUT 7815, CHANGED 7810 TO DO   *        
      *                       ALL THE PROCESSING THAT 7810/7815 WERE   *        
      *                       SUPPOSED TO DO TOGETHER.                 *        
      *                       CHANGED CURSORS TO USE TIMESTAMP - THE   *        
      *                       DATAWINDOWS ARE DISPLAYING BY THE TIME   *        
      *                       PORTION OF THE TIMESTAMP AND THE DATE    *        
      *                       TRANS CAN BE NULL.                       *        
      *                       ADDED PARAGRAPH 7500 TO REFORMAT         *        
      *                       DATE-ORIG-PYMT.                          *        
      *                       CHANGED WS-ROWS-RETURNED TO START AT     *        
      *                       ZERO SO THAT 100 ROWS ARE RETURNED       *        
      *  08/14/95    WMG      MODIFIED TO FIX TPR #5779:               *        
      *                       THE 2350 PARAGRAPH WAS SPLIT INTO TWO    *        
      *                       SEPARATE PARAGRAPHS; ONE TO CLEAR THE    *        
      *                       AR VARS AND ANOTHER TO CLEAR THE MN-VARS.*        
      *                       BEFORE, WHEN BOTH AR AND MN ROWS EXISTED,*        
      *                       THE LOGIC WOULD CLEAR OUT THE FIRST MN   *        
      *                       ROW VALUES BEFORE THEY WERE RETURNED TO  *        
      *                       THE DESKTOP                              *        
      *                                                                *        
      * 12/07/95     MR      MODIFICATION FOR DCR 1817:                *        
      *                      INCLUDED CUSTOMER_ROLE_CD = SPACES IN     *        
      *                      WHERE CLAUSE OF STATEMENT BECAUSE OF      *        
      *                      CHANGE IN DATA STRUCTURE. 7320-SELECT.    *        
      *                                                                *        
      * 03/11/96     WMG     CHANGES MADE FOR FCS/GL ROLLOUT.          *        
      *                                                                *        
      * 05/30/96     RS      MODIFICATION FOR TPR 2503:                *        
      *                      REDESIGN OF TRANSACTION HISTORY SELECTION *        
      *                      TO IMPROVE PERFORMANCE.                   *        
      *                                                                *        
P0282 * 08/20/96     JRX     ADD FCS KEYS TO TRANSACTION HIST PANEL    *        
T5393 * 11/19/96     AS      SEND BACK SPACES FOR LOCAL OFFICE DESC    *        
T5393 *                      IF NOT FOUND IN CSS_LOCAL_OFFICE TABLE.   *        
      *                                                                *        
      *                                                                *        
T6035 * 12/05/96     EMM     INCLUDED CODE_TRAN_TYPE = WS-CODE-TRAN-   *        
T6035 *                      TYPE RECEIVED FROM PANEL154. THIS IS TO   *        
T6035 *                      ACCOMODATE FOR ADDED ABILITY TO SELECT    *        
T6035 *                      TRANSACTION TYPE ON PANEL154.             *        
PC451 * 02/10/97     PP      CSS_PAYMENT_OFFICE WILL BE READ FOR CASH- *        
PC451 *                      -ERING OFFICE, NOT CSS_LOCAL_OFFICE, AS   *        
PC451 *                      WAS BEING DONE PREVIOUSLY.                *        
PCR404* 03/24/97     PD      SELECT CSS_CSH_DRWR_CNTL FOR BATCH STATUS *        
PCR404*                      FOR ONLINE TRANSACTIONS.                  *        
T10422* 04/17/97     AS      SELECT CASH_DRAWER_ID INSTEAD OF          *        
T10422*                      CASH_REPORT_NO.                           *        
T10523* 04/23/97     AS      CHANGED RETRIEVAL CRITERIA TO TRAN HIST   *        
T10523*                      SEQ NO FROM TRAN DATE.                    *        
CBSI  *  07/20/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T18458* 11/12/98    PRA      REPLACED USE OF ACCT_CREATE_DT FOR DEFAULT*        
      *                      'FROM DATE' TO USE OF 1/1/1900            *        
      * 03/26/01    CHANELLE MCR310. CASH COMPANY ALWAYS '01' CHANGES. *        
T28706* 05/25/03    MJG      PROVIDE THE ABILITY TO LOOK UP PAYMENTS & *        
      *                      BILLS WITH THE SAME SEARCH.  TO DO THIS   *        
      *                      I CHANGED THE WHERE CLAUSE OF ALL THE CURS*        
      *                      TO LOOK FOR ONE OF TWO VALUES.  IF AN X   *        
      *                      IS SENT UP I SET ONE VALUE TO B FOR BILLS *        
      *                      AND ONE TO P FOR PAYMENTS.  IF A VALUE    *        
      *                      OTHER THAN X IS SENT, I SET BOTH OF THE   *        
      *                      VALUES TO BE THE SAME THINGS.             *        
C20723* 11/04/03    FMB      REPLACE CSS_PAYMENT_OFFICE WITH           *        
C20723*                      CSS_CASHIER_OFFICE.                       *        
REARCH* 12/08/05    CVNS     RPC TO COBOL SP CONVERSION                *        
REARCH*             CHENNAI                                            *        
C35842* 06/24/08    LG41184  CREDIT CARD CHANGES.                      *        
C35842*                      PERFORMANCE CHANGES.                      *        
C37538* 10/22/08    FMB      RETURN AN EMPTY TABLE WHEN NO NAVIGATION  *        
C37538*                      PATH TO AVOID S0C7.                       *        
A37342* 03/14/09    SJ97149  IMPROVE PERFORMANCE - ADDING ROWSET       *        
A37342*                      POSITIONING FOR GLOBAL TEMP TABLES &      *        
A37342*                      WITH UR CHANGES TO CURSORS*               *        
A2142 * 05/26/10    PK98692  WQ TRANSACTION HISTORY CHANGES FOR        *        
A2142 *                      A21422 - ADD LOC1 & LOC2 TO CU ADDRESS    *        
A2142 *                      A21426 - TO ENABLE FILTERING ON TIME      *        
A2142 *                      A21427 - ENABLE SORT ON SUMMARY WINDOW IN *        
A2142 *                               PANEL156                         *        
A2142 *                      A21429 - TO RETURN COMPANY NUMBER FOR THE *        
A2142 *                               TRANSACTION ROWS                 *        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02016'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02016 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_AR_TRANS_HIST >                                                
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
P0282 *---< CSS_BCH_JRNL_CNTL  >                                                
P0282      EXEC SQL                                                             
P0282         INCLUDE TBBJCNTL                                                  
P0282      END-EXEC.                                                            
                                                                        
      *---< CSS_CSH_DRWR_CNTL  >                                                
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_MNT_TRANS_HIST >                                                
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_APPL_PGM_DESC >                                                 
           EXEC SQL                                                             
              INCLUDE TBPGMDSC                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ACCOUNT >                                                       
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_NAME_ACCT_XREF >                                                
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_NAME >                                                          
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_ADDR_FORMATTED >                                                
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
C20723*---< CSS_CASHIER_OFFICE >                                                
C20723     EXEC SQL                                                             
C20723        INCLUDE TBCSHOFF                                                  
C20723     END-EXEC.                                                            
                                                                        
      *---< CSS_BUDGET_HIST    >                                                
           EXEC SQL                                                             
              INCLUDE TBBGTHST                                                  
           END-EXEC.                                                            
                                                                        
A2142 *---< CSS_PREMISE        >                                                
A2142      EXEC SQL                                                             
A2142         INCLUDE TBPREM                                                    
A2142      END-EXEC.                                                            
                                                                        
A2142 *---< CSS_CUSTOMER       >                                                
A2142      EXEC SQL                                                             
A2142         INCLUDE TBCUST                                                    
A2142      END-EXEC.                                                            
                                                                        
A2142 *---< CSS_RESP_AREA      >                                                
A2142      EXEC SQL                                                             
A2142         INCLUDE TBRSAREA                                                  
A2142      END-EXEC.                                                            
                                                                        
A2142 *---< CSS_USER_PROFILE   >                                                
A2142      EXEC SQL                                                             
A2142         INCLUDE TBUSRPRF                                                  
A2142      END-EXEC.                                                            
                                                                        
A2142 *---< CSS_TRAN_TYPE      >                                                
A2142      EXEC SQL                                                             
A2142         INCLUDE TBTRNTYP                                                  
A2142      END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *----<COMMON SYSTEM AREA >                                                
           COPY CCA00001.                                                       
      *----< ERROR HANDLING >                                                   
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >                   
           COPY CWS00027.                                                       
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                              
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                       'SESSION.CSR02016_R1'.     
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-EPP-FLAG             PIC X(01) VALUE 'N'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(9)   COMP VALUE 0.      
COB305     05 RS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  RS-TRANS-HIST-SEQ-NO      PIC X(26)   VALUE SPACE.       
           05  RS-DATE-TRANS             PIC X(10)   VALUE SPACE.       
           05  RS-CODE-TRAN-TYPE         PIC X(01)   VALUE SPACE.       
A21427     05  RS-TRAN-SHORT-DESC        PIC X(03)   VALUE SPACE.       
COB305     05 RS-AMT-ORIG-ENTERED        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.   
COB305     05 RS-AMT-BILLED-UNPAID        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.   
           05  RS-RESP-AREA-ID           PIC X(03)   VALUE SPACE.       
A21427     05  RS-RESP-AREA-DESC         PIC X(30)   VALUE SPACE.       
           05  RS-APPL-PROGRAM-ID        PIC X(09)   VALUE SPACE.       
           05  RS-APPL-PROGRAM-DESC      PIC X(20)   VALUE SPACE.       
           05  RS-PYMT-FACILITY-CD       PIC X(01)   VALUE SPACE.       
           05  RS-USER-ID                PIC X(07)   VALUE SPACE.       
A21427     05  RS-EMPLOYEE-NAME          PIC X(35)   VALUE SPACE.       
           05  RS-COMPANY-NO             PIC X(02)   VALUE SPACE.       
           05  RS-TRAN-COMMENT           PIC X(210)  VALUE SPACE.       
           05  RS-RECORD-ONLY-FL         PIC X(01)   VALUE SPACE.       
           05  RS-DATE-ORIG-PYMT         PIC X(10)   VALUE SPACE.       
P0282      05  RS-CASH-LOCAL-OFFICE      PIC X(22)   VALUE SPACE.       
T10422*    05  RS-CASH-REPORT-NO         PIC X(03)   VALUE SPACE.               
T10422     05  RS-CASH-DRAWER-ID         PIC S9(4) USAGE COMP VALUE 0.  
P0282      05  RS-DATE-CASH-REPORT       PIC X(10)   VALUE SPACE.       
P0282      05  RS-CODE-BATCH-STATUS      PIC X(08)   VALUE SPACE.       
P0282      05  RS-PYMT-RCPT-PRNTD-CD     PIC X(01)   VALUE SPACE.       
COB305     05 RS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 RS-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
           05  RS-FULL-NAME              PIC X(50)   VALUE SPACE.       
           05  RS-HOUSE-NO               PIC X(05)   VALUE SPACE.       
A21422*    05  RS-STREET-NAME            PIC X(16)   VALUE SPACE.               
A21422     05  RS-STREET-NAME            PIC X(30)   VALUE SPACE.       
A21422     05  RS-STREET-LOCATION-1      PIC X(04)   VALUE SPACE.       
A21422     05  RS-STREET-LOCATION-2      PIC X(11)   VALUE SPACE.       
COB305     05 RS-OLD-EPP-AMT        PIC S9(9)V9(2) USAGE COMP-3 VALUE 0.  
COB305     05 RS-NEW-EPP-AMT        PIC S9(9)V9(2) USAGE COMP-3 VALUE 0.  
           05  RS-ROWS-RETURNED          PIC S9(9)   USAGE COMP.        
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE             PIC S9(9)   COMP VALUE 0.      
COB305     05 S-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
REARCH     05  S-TRANS-HIST-SEQ-NO       PIC X(26)   VALUE SPACE.       
REARCH     05  S-DATE-TRANS              PIC X(10)   VALUE SPACE.       
REARCH     05  S-CODE-TRAN-TYPE          PIC X(01)   VALUE SPACE.       
A21427     05  S-TRAN-SHORT-DESC         PIC X(03)   VALUE SPACE.       
COB305     05 S-AMT-ORIG-ENTERED        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.   
COB305     05 S-AMT-BILLED-UNPAID        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.   
REARCH     05  S-RESP-AREA-ID            PIC X(03)   VALUE SPACE.       
A21427     05  S-RESP-AREA-DESC          PIC X(30)   VALUE SPACE.       
REARCH     05  S-APPL-PROGRAM-ID         PIC X(09)   VALUE SPACE.       
REARCH     05  S-APPL-PROGRAM-DESC       PIC X(20)   VALUE SPACE.       
REARCH     05  S-PYMT-FACILITY-CD        PIC X(01)   VALUE SPACE.       
REARCH     05  S-USER-ID                 PIC X(07)   VALUE SPACE.       
A21427     05  S-EMPLOYEE-NAME           PIC X(35)   VALUE SPACE.       
REARCH     05  S-COMPANY-NO              PIC X(02)   VALUE SPACE.       
REARCH     05  S-TRAN-COMMENT            PIC X(210)  VALUE SPACE.       
REARCH     05  S-RECORD-ONLY-FL          PIC X(01)   VALUE SPACE.       
REARCH     05  S-DATE-ORIG-PYMT          PIC X(10)   VALUE SPACE.       
REARCH     05  S-CASH-LOCAL-OFFICE       PIC X(22)   VALUE SPACE.       
REARCH     05  S-CASH-DRAWER-ID          PIC S9(4) USAGE COMP VALUE 0.  
REARCH     05  S-DATE-CASH-REPORT        PIC X(10)   VALUE SPACE.       
REARCH     05  S-CODE-BATCH-STATUS       PIC X(08)   VALUE SPACE.       
REARCH     05  S-PYMT-RCPT-PRNTD-CD      PIC X(01)   VALUE SPACE.       
COB305     05 S-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 S-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
REARCH     05  S-FULL-NAME               PIC X(50)   VALUE SPACE.       
REARCH     05  S-HOUSE-NO                PIC X(05)   VALUE SPACE.       
REARCH*    05  S-STREET-NAME             PIC X(16)   VALUE SPACE.               
A21422     05  S-STREET-NAME             PIC X(30)   VALUE SPACE.       
A21422     05  S-STREET-LOCATION-1       PIC X(04)   VALUE SPACE.       
A21422     05  S-STREET-LOCATION-2       PIC X(11)   VALUE SPACE.       
COB305     05 S-OLD-EPP-AMT        PIC S9(9)V9(2) USAGE COMP-3 VALUE 0.  
COB305     05 S-NEW-EPP-AMT        PIC S9(9)V9(2) USAGE COMP-3 VALUE 0.  
REARCH     05  S-ROWS-RETURNED           PIC S9(9)   USAGE COMP.        
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
       01  GENERAL-WORKING-STORAGE.                                     
REARCH     05  PROGRAM-NAME              PIC X(08)   VALUE 'CSR02016'.  
REARCH     05  WS-SQLSTATE               PIC X(05)   VALUE SPACES.      
           05  WS-NAVIG-PATH             PIC X(01)   VALUE SPACE.       
               88  ACCOUNT-SELECTION     VALUE 'A'.                     
               88  CUSTOMER-SELECTION    VALUE 'C'.                     
               88  PREMISE-SELECTION     VALUE 'P'.                     
               88  RESP-AREA-SELECTION   VALUE 'R'.                     
               88  USER-ID-SELECTION     VALUE 'U'.                     
           05  WS-ACCOUNT-NO.                                           
               10  WS-ACCOUNT-NO-NUM     PIC 9(13).                     
           05  WS-CUSTOMER-NO.                                          
               10  WS-CUSTOMER-NO-NUM    PIC 9(10).                     
           05  WS-PREMISE-NO.                                           
               10  WS-PREMISE-NO-NUM     PIC 9(10).                     
           05  WS-RESP-AREA-ID           PIC X(03)   VALUE SPACE.       
           05  WS-USER-ID                PIC X(07)   VALUE SPACE.       
           05  WS-EMPLOYEE-NAME          PIC X(35)   VALUE SPACE.       
           05  WS-CODE-TRAN-TYPE         PIC X(01)   VALUE SPACE.       
           05  WS-CODE-TRAN-TYPE1        PIC X(01)   VALUE SPACE.       
T10523*    05  WS-FROM-DATE              PIC X(10)   VALUE SPACE.               
T10523*    05  WS-TO-DATE                PIC X(10)   VALUE SPACE.               
T10523     05  WS-FROM-TS                PIC X(26).                     
T10523     05  WS-FROM-TS-R REDEFINES    WS-FROM-TS.                    
T10523         10  WS-FROM-DATE          PIC X(10).                     
A21422         10  WS-DASH-1             PIC X(01).                     
A21422         10  WS-FROM-TIME          PIC X(15).                     
T10523*        10  WS-FROM-TIME          PIC X(16).                             
T10523     05  WS-TO-TS                  PIC X(26).                     
T10523     05  WS-TO-TS-R   REDEFINES    WS-TO-TS.                      
T10523         10  WS-TO-DATE            PIC X(10).                     
A21422         10  WS-DASH-2             PIC X(01).                     
A21422         10  WS-TO-TIME            PIC X(15).                     
T10523*        10  WS-TO-TIME            PIC X(16).                             
           05  WS-ROWS-RETURNED          PIC S9(9)   VALUE 0.           
           05  WS-ACCT-CREATE-DT         PIC X(26)   VALUE SPACE.       
           05  WS-TODAY-DATE             PIC X(10)   VALUE SPACE.       
           05  WS-TODAY-DATE-25          PIC X(10)   VALUE SPACE.       
           05  WS-SEND-FLAG              PIC X(02)   VALUE SPACE.       
           05  WS-DATA-AR                PIC X(05)   VALUE SPACE.       
           05  WS-DATA-MN                PIC X(05)   VALUE SPACE.       
           05  WS-LOW-DATE               PIC X(10)                      
               VALUE '0001-01-01'.                                      
           05  WS-DATE-COMP-AR           PIC X(10)   VALUE SPACE.       
           05  WS-DATE-COMP-MH           PIC X(10)   VALUE SPACE.       
COB305     05 WS-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-NAME-TYPE              PIC X(02)   VALUE SPACE.       
           05  WS-NAME-FORMAT            PIC X(01)   VALUE SPACE.       
           05  WS-FULL-NAME              PIC X(50)   VALUE SPACE.       
           05  WS-FIRST-NAME             PIC X(15)   VALUE SPACE.       
           05  WS-MIDDLE-NAME            PIC X(15)   VALUE SPACE.       
           05  WS-LAST-NAME              PIC X(20)   VALUE SPACE.       
COB305     05 WS-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-HOUSE-NO               PIC X(05)   VALUE SPACE.       
A21422*    05  WS-STREET-NAME            PIC X(16)   VALUE SPACE.               
A21422     05  WS-STREET-NAME            PIC X(30)   VALUE SPACE.       
A21422     05  WS-STREET-LOCATION-1      PIC X(04)   VALUE SPACE.       
A21422     05  WS-STREET-LOCATION-2      PIC X(11)   VALUE SPACE.       
           05  WS-MH-DATE-TRANS-NI       PIC S9(4) COMP VALUE 0.        
           05  WS-AR-DATE-TRANS-NI       PIC S9(4) COMP VALUE 0.        
           05  WS-DOP-NI                 PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-HOLD              PIC X(10) VALUE SPACES.        
           05  WS-DATE-HOLD-USA          PIC X(10) VALUE SPACES.        
           05  WS-AR-APPL-PROGRAM-DESC   PIC X(20) VALUE SPACES.        
           05  WS-MH-APPL-PROGRAM-DESC   PIC X(20) VALUE SPACES.        
C35842     05  WS-BMX                    PIC X(04) VALUE 'BMX-'.        
C35842     05  WS-CASH-LOCAL-OFFICE      PIC X(22) VALUE SPACES.        
                                                                        
P0282  05  WS-DATE-CCYYMMDD.                                            
P0282      10  WS-CCYY              PIC X(04).                          
P0282      10  WS-MM                PIC X(02).                          
P0282      10  WS-DD                PIC X(02).                          
P0282  05  WS-DATE-MMDDCCYY.                                            
P0282      10  WS-MONTH             PIC X(02) VALUE SPACES.             
P0282      10  WS-DAY               PIC X(02) VALUE SPACES.             
P0282      10  WS-YEAR              PIC X(04) VALUE SPACES.             
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      *--- < CURSOR FOR AR ACCOUNT-SELECTION >                                  
      *--- < FILTERED BY ACCOUNT_NO >                                           
                                                                        
           EXEC SQL DECLARE AR-ACCOUNT-CURSOR CURSOR FOR                
             SELECT   ACCOUNT_NO,                                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                                
                      DATE_TRANS,                                       
                      CODE_TRAN_TYPE,                                   
                      AMT_ORIG_ENTERED,                                 
                      AMT_BILLED_UNPAID,                                
                      RESP_AREA_ID,                                     
                      APPL_PROGRAM_ID,                                  
                      PYMT_FACILITY_CD,                                 
                      USER_ID,                                          
                      COMPANY_NO,                                       
                      TRAN_COMMENT,                                     
                      RECORD_ONLY_FL,                                   
                      DATE_ORIG_PYMT,                                   
P0282                 CASH_COMPANY_NO,                                  
P0282                 CASH_LOCAL_OFFICE,                                
P0282                 CASH_REPORT_NO,                                   
P0282                 DATE_CASH_REPORT,                                 
P0282                 CASH_DRAWER_ID,                                   
P0282                 PYMT_RCPT_PRNTD_CD                                
             FROM     CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                   
             WHERE    ACCOUNT_NO       = :AR-ACCOUNT-NO                 
C35842       AND     (TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                  
C35842               AND TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ))                
T6035        AND     (CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE            
T28706               OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)        
             ORDER BY TRANS_HIST_SEQ_NO       DESC                      
C35842       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE AR-ACCOUNT-CURSOR CURSOR FOR                        
MFA-TR*      SELECT   ACCOUNT_NO,                                               
MFA-TR*               TRANS_HIST_SEQ_NO,                                        
MFA-TR*               DATE_TRANS,                                               
MFA-TR*               CODE_TRAN_TYPE,                                           
MFA-TR*               AMT_ORIG_ENTERED,                                         
MFA-TR*               AMT_BILLED_UNPAID,                                        
MFA-TR*               RESP_AREA_ID,                                             
MFA-TR*               APPL_PROGRAM_ID,                                          
MFA-TR*               PYMT_FACILITY_CD,                                         
MFA-TR*               USER_ID,                                                  
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               TRAN_COMMENT,                                             
MFA-TR*               RECORD_ONLY_FL,                                           
MFA-TR*               DATE_ORIG_PYMT,                                           
MFA-TR*               CASH_COMPANY_NO,                                          
MFA-TR*               CASH_LOCAL_OFFICE,                                        
MFA-TR*               CASH_REPORT_NO,                                           
MFA-TR*               DATE_CASH_REPORT,                                         
MFA-TR*               CASH_DRAWER_ID,                                           
MFA-TR*               PYMT_RCPT_PRNTD_CD                                        
MFA-TR*      FROM     CSS_AR_TRANS_HIST                                         
MFA-TR*      WHERE    ACCOUNT_NO       = :AR-ACCOUNT-NO                         
MFA-TR*      AND     (TRANS_HIST_SEQ_NO >= :WS-FROM-TS                          
MFA-TR*              AND TRANS_HIST_SEQ_NO <= :WS-TO-TS)                        
MFA-TR*      AND     (CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE                    
MFA-TR*              OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)                
MFA-TR*      ORDER BY TRANS_HIST_SEQ_NO       DESC                              
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR AR USER-ID-SELECTION >                                  
      *--- < FILTERED BY USER_ID >                                              
                                                                        
           EXEC SQL DECLARE AR-USER-ID-CURSOR CURSOR FOR                
             SELECT   ACCOUNT_NO,                                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                                
                      DATE_TRANS,                                       
                      CODE_TRAN_TYPE,                                   
                      AMT_ORIG_ENTERED,                                 
                      AMT_BILLED_UNPAID,                                
                      RESP_AREA_ID,                                     
                      APPL_PROGRAM_ID,                                  
                      PYMT_FACILITY_CD,                                 
                      USER_ID,                                          
                      COMPANY_NO,                                       
                      TRAN_COMMENT,                                     
                      RECORD_ONLY_FL,                                   
                      DATE_ORIG_PYMT,                                   
P0282                 CASH_COMPANY_NO,                                  
P0282                 CASH_LOCAL_OFFICE,                                
P0282                 CASH_REPORT_NO,                                   
P0282                 DATE_CASH_REPORT,                                 
P0282                 CASH_DRAWER_ID,                                   
P0282                 PYMT_RCPT_PRNTD_CD                                
             FROM     CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                   
             WHERE    USER_ID           = :AR-USER-ID                   
C35842       AND     (TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                  
C35842               AND TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ))                
T28706       AND     (CODE_TRAN_TYPE LIKE :AR-CODE-TRAN-TYPE            
T28706                OR  CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)      
             ORDER BY TRANS_HIST_SEQ_NO       DESC                      
C35842       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE AR-USER-ID-CURSOR CURSOR FOR                        
MFA-TR*      SELECT   ACCOUNT_NO,                                               
MFA-TR*               TRANS_HIST_SEQ_NO,                                        
MFA-TR*               DATE_TRANS,                                               
MFA-TR*               CODE_TRAN_TYPE,                                           
MFA-TR*               AMT_ORIG_ENTERED,                                         
MFA-TR*               AMT_BILLED_UNPAID,                                        
MFA-TR*               RESP_AREA_ID,                                             
MFA-TR*               APPL_PROGRAM_ID,                                          
MFA-TR*               PYMT_FACILITY_CD,                                         
MFA-TR*               USER_ID,                                                  
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               TRAN_COMMENT,                                             
MFA-TR*               RECORD_ONLY_FL,                                           
MFA-TR*               DATE_ORIG_PYMT,                                           
MFA-TR*               CASH_COMPANY_NO,                                          
MFA-TR*               CASH_LOCAL_OFFICE,                                        
MFA-TR*               CASH_REPORT_NO,                                           
MFA-TR*               DATE_CASH_REPORT,                                         
MFA-TR*               CASH_DRAWER_ID,                                           
MFA-TR*               PYMT_RCPT_PRNTD_CD                                        
MFA-TR*      FROM     CSS_AR_TRANS_HIST                                         
MFA-TR*      WHERE    USER_ID           = :AR-USER-ID                           
MFA-TR*      AND     (TRANS_HIST_SEQ_NO >= :WS-FROM-TS                          
MFA-TR*              AND TRANS_HIST_SEQ_NO <= :WS-TO-TS)                        
MFA-TR*      AND     (CODE_TRAN_TYPE LIKE :AR-CODE-TRAN-TYPE                    
MFA-TR*               OR  CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)              
MFA-TR*      ORDER BY TRANS_HIST_SEQ_NO       DESC                              
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR AR RESP-AREA-SELECTION >                                
      *--- < FILTERED BY RESP_AREA_ID >                                         
                                                                        
           EXEC SQL DECLARE AR-RESP-CURSOR CURSOR FOR                   
             SELECT   ACCOUNT_NO,                                       
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                                
                      DATE_TRANS,                                       
                      CODE_TRAN_TYPE,                                   
                      AMT_ORIG_ENTERED,                                 
                      AMT_BILLED_UNPAID,                                
                      RESP_AREA_ID,                                     
                      APPL_PROGRAM_ID,                                  
                      PYMT_FACILITY_CD,                                 
                      USER_ID,                                          
                      COMPANY_NO,                                       
                      TRAN_COMMENT,                                     
                      RECORD_ONLY_FL,                                   
                      DATE_ORIG_PYMT,                                   
P0282                 CASH_COMPANY_NO,                                  
P0282                 CASH_LOCAL_OFFICE,                                
P0282                 CASH_REPORT_NO,                                   
P0282                 DATE_CASH_REPORT,                                 
P0282                 CASH_DRAWER_ID,                                   
P0282                 PYMT_RCPT_PRNTD_CD                                
             FROM     CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                   
             WHERE    RESP_AREA_ID      = :AR-RESP-AREA-ID              
C35842       AND     (TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                  
C35842               AND TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ))                
T28706       AND      (CODE_TRAN_TYPE LIKE :AR-CODE-TRAN-TYPE           
T28706                OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)       
             ORDER BY TRANS_HIST_SEQ_NO       DESC                      
C35842       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE AR-RESP-CURSOR CURSOR FOR                           
MFA-TR*      SELECT   ACCOUNT_NO,                                               
MFA-TR*               TRANS_HIST_SEQ_NO,                                        
MFA-TR*               DATE_TRANS,                                               
MFA-TR*               CODE_TRAN_TYPE,                                           
MFA-TR*               AMT_ORIG_ENTERED,                                         
MFA-TR*               AMT_BILLED_UNPAID,                                        
MFA-TR*               RESP_AREA_ID,                                             
MFA-TR*               APPL_PROGRAM_ID,                                          
MFA-TR*               PYMT_FACILITY_CD,                                         
MFA-TR*               USER_ID,                                                  
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               TRAN_COMMENT,                                             
MFA-TR*               RECORD_ONLY_FL,                                           
MFA-TR*               DATE_ORIG_PYMT,                                           
MFA-TR*               CASH_COMPANY_NO,                                          
MFA-TR*               CASH_LOCAL_OFFICE,                                        
MFA-TR*               CASH_REPORT_NO,                                           
MFA-TR*               DATE_CASH_REPORT,                                         
MFA-TR*               CASH_DRAWER_ID,                                           
MFA-TR*               PYMT_RCPT_PRNTD_CD                                        
MFA-TR*      FROM     CSS_AR_TRANS_HIST                                         
MFA-TR*      WHERE    RESP_AREA_ID      = :AR-RESP-AREA-ID                      
MFA-TR*      AND     (TRANS_HIST_SEQ_NO >= :WS-FROM-TS                          
MFA-TR*              AND TRANS_HIST_SEQ_NO <= :WS-TO-TS)                        
MFA-TR*      AND      (CODE_TRAN_TYPE LIKE :AR-CODE-TRAN-TYPE                   
MFA-TR*               OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)               
MFA-TR*      ORDER BY TRANS_HIST_SEQ_NO       DESC                              
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR MH ACCOUNT-SELECTION >                                  
      *--- < FILTERED BY ACCOUNT_NO >                                           
                                                                        
           EXEC SQL DECLARE MH-ACCOUNT-CURSOR CURSOR FOR                
             SELECT   REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                                
                      DATE_TRANS,                                       
                      CODE_TRAN_TYPE,                                   
                      RESP_AREA_ID,                                     
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      USER_ID,                                          
                      APPL_PROGRAM_ID,                                  
                      TRAN_COMMENT                                      
             FROM     CSS_MNT_TRANS_HIST WITH(READUNCOMMITTED)                  
             WHERE    ACCOUNT_NO        = :MH-ACCOUNT-NO                
C35842       AND     (TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                  
C35842               AND TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ))                
T6035        AND     (CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE            
T28706               OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)        
             ORDER BY TRANS_HIST_SEQ_NO       DESC                      
C35842       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE MH-ACCOUNT-CURSOR CURSOR FOR                        
MFA-TR*      SELECT   TRANS_HIST_SEQ_NO,                                        
MFA-TR*               DATE_TRANS,                                               
MFA-TR*               CODE_TRAN_TYPE,                                           
MFA-TR*               RESP_AREA_ID,                                             
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               USER_ID,                                                  
MFA-TR*               APPL_PROGRAM_ID,                                          
MFA-TR*               TRAN_COMMENT                                              
MFA-TR*      FROM     CSS_MNT_TRANS_HIST                                        
MFA-TR*      WHERE    ACCOUNT_NO        = :MH-ACCOUNT-NO                        
MFA-TR*      AND     (TRANS_HIST_SEQ_NO >= :WS-FROM-TS                          
MFA-TR*              AND TRANS_HIST_SEQ_NO <= :WS-TO-TS)                        
MFA-TR*      AND     (CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE                    
MFA-TR*              OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)                
MFA-TR*      ORDER BY TRANS_HIST_SEQ_NO       DESC                              
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR MH CUSTOMER-SELECTION >                                 
      *--- < FILTERED BY CUSTOMER_NO >                                          
                                                                        
           EXEC SQL DECLARE MH-CUSTOMER-CURSOR CURSOR FOR               
             SELECT   REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                                
                      DATE_TRANS,                                       
                      CODE_TRAN_TYPE,                                   
                      RESP_AREA_ID,                                     
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      USER_ID,                                          
                      APPL_PROGRAM_ID,                                  
                      TRAN_COMMENT                                      
             FROM     CSS_MNT_TRANS_HIST WITH(READUNCOMMITTED)                  
             WHERE    CUSTOMER_NO       = :MH-CUSTOMER-NO               
C35842       AND     (TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                  
C35842               AND TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ))                
T6035        AND     (CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE            
T28706                OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)       
             ORDER BY TRANS_HIST_SEQ_NO       DESC                      
C35842       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE MH-CUSTOMER-CURSOR CURSOR FOR                       
MFA-TR*      SELECT   TRANS_HIST_SEQ_NO,                                        
MFA-TR*               DATE_TRANS,                                               
MFA-TR*               CODE_TRAN_TYPE,                                           
MFA-TR*               RESP_AREA_ID,                                             
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               USER_ID,                                                  
MFA-TR*               APPL_PROGRAM_ID,                                          
MFA-TR*               TRAN_COMMENT                                              
MFA-TR*      FROM     CSS_MNT_TRANS_HIST                                        
MFA-TR*      WHERE    CUSTOMER_NO       = :MH-CUSTOMER-NO                       
MFA-TR*      AND     (TRANS_HIST_SEQ_NO >= :WS-FROM-TS                          
MFA-TR*              AND TRANS_HIST_SEQ_NO <= :WS-TO-TS)                        
MFA-TR*      AND     (CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE                    
MFA-TR*               OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)               
MFA-TR*      ORDER BY TRANS_HIST_SEQ_NO       DESC                              
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR MH PREMISE-SELECTION >                                  
      *--- < FILTERED BY PREMISE_NO >                                           
                                                                        
           EXEC SQL DECLARE MH-PREMISE-CURSOR CURSOR FOR                
             SELECT   REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                                
                      DATE_TRANS,                                       
                      CODE_TRAN_TYPE,                                   
                      RESP_AREA_ID,                                     
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      USER_ID,                                          
                      APPL_PROGRAM_ID,                                  
                      TRAN_COMMENT                                      
             FROM     CSS_MNT_TRANS_HIST WITH(READUNCOMMITTED)                  
             WHERE    PREMISE_NO        = :MH-PREMISE-NO                
C35842       AND     (TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                  
C35842               AND TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ))                
T6035        AND     (CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE            
T28706               OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)        
             ORDER BY TRANS_HIST_SEQ_NO       DESC                      
C35842       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE MH-PREMISE-CURSOR CURSOR FOR                        
MFA-TR*      SELECT   TRANS_HIST_SEQ_NO,                                        
MFA-TR*               DATE_TRANS,                                               
MFA-TR*               CODE_TRAN_TYPE,                                           
MFA-TR*               RESP_AREA_ID,                                             
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               USER_ID,                                                  
MFA-TR*               APPL_PROGRAM_ID,                                          
MFA-TR*               TRAN_COMMENT                                              
MFA-TR*      FROM     CSS_MNT_TRANS_HIST                                        
MFA-TR*      WHERE    PREMISE_NO        = :MH-PREMISE-NO                        
MFA-TR*      AND     (TRANS_HIST_SEQ_NO >= :WS-FROM-TS                          
MFA-TR*              AND TRANS_HIST_SEQ_NO <= :WS-TO-TS)                        
MFA-TR*      AND     (CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE                    
MFA-TR*              OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)                
MFA-TR*      ORDER BY TRANS_HIST_SEQ_NO       DESC                              
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR MH USER-ID-SELECTION >                                  
      *--- < FILTERED BY USER_ID >                                              
                                                                        
           EXEC SQL DECLARE MH-USER-ID-CURSOR CURSOR FOR                
             SELECT   REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                                
                      DATE_TRANS,                                       
                      CODE_TRAN_TYPE,                                   
                      RESP_AREA_ID,                                     
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      USER_ID,                                          
                      APPL_PROGRAM_ID,                                  
                      TRAN_COMMENT                                      
             FROM     CSS_MNT_TRANS_HIST WITH(READUNCOMMITTED)                  
             WHERE    USER_ID           = :MH-USER-ID                   
C35842       AND     (TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                  
C35842               AND TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ))                
             AND     (CODE_TRAN_TYPE LIKE :MH-CODE-TRAN-TYPE            
                     OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)        
             ORDER BY TRANS_HIST_SEQ_NO       DESC                      
C35842       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE MH-USER-ID-CURSOR CURSOR FOR                        
MFA-TR*      SELECT   TRANS_HIST_SEQ_NO,                                        
MFA-TR*               DATE_TRANS,                                               
MFA-TR*               CODE_TRAN_TYPE,                                           
MFA-TR*               RESP_AREA_ID,                                             
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               USER_ID,                                                  
MFA-TR*               APPL_PROGRAM_ID,                                          
MFA-TR*               TRAN_COMMENT                                              
MFA-TR*      FROM     CSS_MNT_TRANS_HIST                                        
MFA-TR*      WHERE    USER_ID           = :MH-USER-ID                           
MFA-TR*      AND     (TRANS_HIST_SEQ_NO >= :WS-FROM-TS                          
MFA-TR*              AND TRANS_HIST_SEQ_NO <= :WS-TO-TS)                        
MFA-TR*      AND     (CODE_TRAN_TYPE LIKE :MH-CODE-TRAN-TYPE                    
MFA-TR*              OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)                
MFA-TR*      ORDER BY TRANS_HIST_SEQ_NO       DESC                              
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR MH RESP-AREA-SELECTION >                                
      *--- < FILTERED BY RESP_AREA_ID >                                         
                                                                        
           EXEC SQL DECLARE MH-RESP-CURSOR CURSOR FOR                   
             SELECT   REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                                
                      DATE_TRANS,                                       
                      CODE_TRAN_TYPE,                                   
                      RESP_AREA_ID,                                     
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      USER_ID,                                          
                      APPL_PROGRAM_ID,                                  
                      TRAN_COMMENT                                      
             FROM     CSS_MNT_TRANS_HIST WITH(READUNCOMMITTED)                  
             WHERE    RESP_AREA_ID      = :MH-RESP-AREA-ID              
C35842       AND     (TRANS_HIST_SEQ_NO >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                  
C35842               AND TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ))                
T28706       AND     (CODE_TRAN_TYPE LIKE :MH-CODE-TRAN-TYPE            
T28706                OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)       
             ORDER BY TRANS_HIST_SEQ_NO       DESC                      
C35842       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE MH-RESP-CURSOR CURSOR FOR                           
MFA-TR*      SELECT   TRANS_HIST_SEQ_NO,                                        
MFA-TR*               DATE_TRANS,                                               
MFA-TR*               CODE_TRAN_TYPE,                                           
MFA-TR*               RESP_AREA_ID,                                             
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               USER_ID,                                                  
MFA-TR*               APPL_PROGRAM_ID,                                          
MFA-TR*               TRAN_COMMENT                                              
MFA-TR*      FROM     CSS_MNT_TRANS_HIST                                        
MFA-TR*      WHERE    RESP_AREA_ID      = :MH-RESP-AREA-ID                      
MFA-TR*      AND     (TRANS_HIST_SEQ_NO >= :WS-FROM-TS                          
MFA-TR*              AND TRANS_HIST_SEQ_NO <= :WS-TO-TS)                        
MFA-TR*      AND     (CODE_TRAN_TYPE LIKE :MH-CODE-TRAN-TYPE                    
MFA-TR*               OR CODE_TRAN_TYPE LIKE :WS-CODE-TRAN-TYPE1)               
MFA-TR*      ORDER BY TRANS_HIST_SEQ_NO       DESC                              
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE CUST-NAME-CURSOR CURSOR FOR                 
              SELECT   DQ.NAME_ID,                                      
                       DQ.NAME_FORMAT,                                  
                       DQ.NAME_TYPE,                                    
                       DQ.FULL_NAME,                                    
                       DQ.FIRST_NAME,                                   
                       DQ.MIDDLE_NAME,                                  
                       DQ.LAST_NAME                                     
              FROM     CSS_NAME           DQ WITH(READUNCOMMITTED),             
                       CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
              WHERE    HT.CUSTOMER_NO   = :HT-CUSTOMER-NO               
              AND      HT.NAME_ID       = DQ.NAME_ID                    
              AND      DQ.NAME_TYPE     = 'CN'                          
              AND      HT.CUSTOMER_ROLE_CD = ' '                        
C35842        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE CUST-NAME-CURSOR CURSOR FOR                         
MFA-TR*       SELECT   DQ.NAME_ID,                                              
MFA-TR*                DQ.NAME_FORMAT,                                          
MFA-TR*                DQ.NAME_TYPE,                                            
MFA-TR*                DQ.FULL_NAME,                                            
MFA-TR*                DQ.FIRST_NAME,                                           
MFA-TR*                DQ.MIDDLE_NAME,                                          
MFA-TR*                DQ.LAST_NAME                                             
MFA-TR*       FROM     CSS_NAME           DQ,                                   
MFA-TR*                CSS_NAME_ACCT_XREF HT                                    
MFA-TR*       WHERE    HT.CUSTOMER_NO   = :HT-CUSTOMER-NO                       
MFA-TR*       AND      HT.NAME_ID       = DQ.NAME_ID                            
MFA-TR*       AND      DQ.NAME_TYPE     = 'CN'                                  
MFA-TR*       AND      HT.CUSTOMER_ROLE_CD = ' '                                
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE PREM-ADDR-CURSOR CURSOR FOR                 
              SELECT   DY.ADDRESS_ID,                                   
                       DY.HOUSE_NO,                                     
                       DY.STREET_NAME,                                  
A21422                 DY.STREET_LOCATION_1,                            
A21422                 DY.STREET_LOCATION_2                             
              FROM     CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),             
                       CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
              WHERE    HT.PREMISE_NO    = :HT-PREMISE-NO                
              AND      HT.ADDRESS_ID    = DY.ADDRESS_ID                 
              AND      HT.CUSTOMER_ROLE_CD = ' '                        
C35842        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE PREM-ADDR-CURSOR CURSOR FOR                         
MFA-TR*       SELECT   DY.ADDRESS_ID,                                           
MFA-TR*                DY.HOUSE_NO,                                             
MFA-TR*                DY.STREET_NAME,                                          
MFA-TR*                DY.STREET_LOCATION_1,                                    
MFA-TR*                DY.STREET_LOCATION_2                                     
MFA-TR*       FROM     CSS_ADDR_FORMATTED DY,                                   
MFA-TR*                CSS_NAME_ACCT_XREF HT                                    
MFA-TR*       WHERE    HT.PREMISE_NO    = :HT-PREMISE-NO                        
MFA-TR*       AND      HT.ADDRESS_ID    = DY.ADDRESS_ID                         
MFA-TR*       AND      HT.CUSTOMER_ROLE_CD = ' '                                
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE EPP-ACCOUNT-CURSOR CURSOR FOR               
             SELECT   AMT_MO_PYMT,                                      
                      CHANGE_REASON                                     
             FROM     CSS_BUDGET_HIST WITH(READUNCOMMITTED)                     
             WHERE    ACCOUNT_NO        = :MH-ACCOUNT-NO                
C35842       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE EPP-ACCOUNT-CURSOR CURSOR FOR                       
MFA-TR*      SELECT   AMT_MO_PYMT,                                              
MFA-TR*               CHANGE_REASON                                             
MFA-TR*      FROM     CSS_BUDGET_HIST                                           
MFA-TR*      WHERE    ACCOUNT_NO        = :MH-ACCOUNT-NO                        
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01 PARM-NAVIG-PATH         PIC X(01).                            
REARCH 01 PARM-ACCOUNT-NO         PIC X(13).                            
REARCH 01 PARM-CUSTOMER-NO        PIC X(10).                            
REARCH 01 PARM-PREMISE-NO         PIC X(10).                            
REARCH 01 PARM-RESP-AREA-ID       PIC X(03).                            
REARCH 01 PARM-USER-ID            PIC X(07).                            
REARCH 01 PARM-CODE-TRAN-TYPE     PIC X(01).                            
REARCH 01 PARM-FROM-DATE          PIC X(10).                            
REARCH 01 PARM-TO-DATE            PIC X(10).                            
A21422 01 PARM-COMPANY-NO         PIC X(02).                            
A21426 01 PARM-FROM-TIME          PIC X(15).                            
A21426 01 PARM-TO-TIME            PIC X(15).                            
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-NAVIG-PATH                         
REARCH                          PARM-ACCOUNT-NO                         
REARCH                          PARM-CUSTOMER-NO                        
REARCH                          PARM-PREMISE-NO                         
REARCH                          PARM-RESP-AREA-ID                       
REARCH                          PARM-USER-ID                            
REARCH                          PARM-CODE-TRAN-TYPE                     
REARCH                          PARM-FROM-DATE                          
REARCH                          PARM-TO-DATE                            
A21422                          PARM-COMPANY-NO                         
A21426                          PARM-FROM-TIME                          
A21426                          PARM-TO-TIME.                           
REARCH*                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
REARCH 0100-INITIALIZE.                                                 
REARCH*                                                                         
REARCH*    MOVE '0100'          TO ACTIVE-PARAGRAPH.                            
REARCH*                                                                         
REARCH     EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
REARCH     EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
REARCH     EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH*                                                                         
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR                            
A37342                            WITH ROWSET POSITIONING FOR           
REARCH          SELECT                                                  
REARCH               RETURN_CODE                                        
REARCH              ,ACCOUNT_NO                                         
REARCH              ,LTRIM(RTRIM(TRANS_HIST_SEQ_NO))  AS 
           TRANS_HIST_SEQ_NO     
REARCH              ,LTRIM(RTRIM(DATE_TRANS))         AS DATE_TRANS            
A2142               ,CASE (LTRIM(RTRIM(TRANS_HIST_SEQ_NO)))                    
A2142                  WHEN '' THEN IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )                  
A2142                  ELSE (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT 
           LTRIM(RTRIM(TRANS_HIST_SEQ_NO)) E) T) END          
A2142                                          AS DATE_TRANS_DISP       
A2142               ,CASE(LTRIM(RTRIM(TRANS_HIST_SEQ_NO)))                     
A2142                  WHEN '' THEN CIS.CHAR2TIME('00:00:00')                   
A2142                  ELSE CIS.CHAR2TIME(LTRIM(RTRIM(TRANS_HIST_SEQ_NO
           ))) END          
A2142                                          AS TIME_TRANS            
REARCH              ,CODE_TRAN_TYPE                                     
A21427              ,LTRIM(RTRIM(TRAN_SHORT_DESC))    AS TRAN_SHORT_DESC       
REARCH              ,AMT_ORIG_ENTERED                                   
REARCH              ,AMT_BILLED_UNPAID                                  
REARCH              ,RESP_AREA_ID                                       
A21427              ,LTRIM(RTRIM(RESP_AREA_DESC))     AS RESP_AREA_DESC        
REARCH              ,LTRIM(RTRIM(APPL_PROGRAM_ID))    AS APPL_PROGRAM_ID       
REARCH              ,LTRIM(RTRIM(APPL_PROGRAM_DESC))  AS 
           APPL_PROGRAM_DESC     
REARCH              ,LTRIM(RTRIM(PYMT_FACILITY_CD))   AS 
           PYMT_FACILITY_CD      
REARCH              ,LTRIM(RTRIM(USER_ID))            AS USER_ID               
A21427              ,LTRIM(RTRIM(EMPLOYEE_NAME))      AS EMPLOYEE_NAME         
REARCH              ,LTRIM(RTRIM(COMPANY_NO))         AS COMPANY_NO            
REARCH              ,LTRIM(RTRIM(TRAN_COMMENT_TEXT))  AS 
           TRAN_COMMENT_TEXT     
REARCH              ,LTRIM(RTRIM(RECORD_ONLY_FL))     AS RECORD_ONLY_FL        
REARCH              ,LTRIM(RTRIM(DATE_ORIG_PYMT))     AS DATE_ORIG_PYMT        
REARCH              ,LTRIM(RTRIM(CASH_LOCAL_OFFICE))  AS 
           CASH_LOCAL_OFFICE     
REARCH              ,CASH_DRAWER_ID                                     
REARCH              ,LTRIM(RTRIM(DATE_CASH_REPORT))   AS 
           DATE_CASH_REPORT      
REARCH              ,LTRIM(RTRIM(CODE_BATCH_STATUS))  AS 
           CODE_BATCH_STATUS     
REARCH              ,LTRIM(RTRIM(PYMT_RCPT_PRNTD_CD)) AS 
           PYMT_RCPT_PRNTD_CD    
REARCH              ,CUSTOMER_NO                                        
REARCH              ,PREMISE_NO                                         
REARCH              ,LTRIM(RTRIM(FULL_NAME))          AS FULL_NAME             
REARCH              ,LTRIM(RTRIM(HOUSE_NO))           AS HOUSE_NO              
REARCH              ,LTRIM(RTRIM(STREET_NAME))        AS STREET_NAME           
A21422              ,LTRIM(RTRIM(STREET_LOCATION_1))  AS 
           STREET_LOCATION_1     
A21422              ,LTRIM(RTRIM(STREET_LOCATION_2))  AS 
           STREET_LOCATION_2     
REARCH              ,OLD_EPP_AMT                                        
REARCH              ,NEW_EPP_AMT                                        
REARCH              ,ROWS_RETURNED                                      
REARCH          FROM                                                    
REARCH               #CSR02016_R1                                
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN                                   
MFA-TR*                           WITH ROWSET POSITIONING FOR                   
MFA-TR*         SELECT                                                          
MFA-TR*              RETURN_CODE                                        01670000
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,STRIP(TRANS_HIST_SEQ_NO)  AS TRANS_HIST_SEQ_NO             
MFA-TR*             ,STRIP(DATE_TRANS)         AS DATE_TRANS                    
MFA-TR*             ,CASE (STRIP(TRANS_HIST_SEQ_NO))                            
MFA-TR*                WHEN '' THEN DATE('1900-01-01')                          
MFA-TR*                ELSE DATE(STRIP(TRANS_HIST_SEQ_NO)) END                  
MFA-TR*                                        AS DATE_TRANS_DISP               
MFA-TR*             ,CASE(STRIP(TRANS_HIST_SEQ_NO))                             
MFA-TR*                WHEN '' THEN TIME('00:00:00')                            
MFA-TR*                ELSE TIME(STRIP(TRANS_HIST_SEQ_NO)) END                  
MFA-TR*                                        AS TIME_TRANS                    
MFA-TR*             ,CODE_TRAN_TYPE                                             
MFA-TR*             ,STRIP(TRAN_SHORT_DESC)    AS TRAN_SHORT_DESC               
MFA-TR*             ,AMT_ORIG_ENTERED                                           
MFA-TR*             ,AMT_BILLED_UNPAID                                          
MFA-TR*             ,RESP_AREA_ID                                               
MFA-TR*             ,STRIP(RESP_AREA_DESC)     AS RESP_AREA_DESC                
MFA-TR*             ,STRIP(APPL_PROGRAM_ID)    AS APPL_PROGRAM_ID               
MFA-TR*             ,STRIP(APPL_PROGRAM_DESC)  AS APPL_PROGRAM_DESC             
MFA-TR*             ,STRIP(PYMT_FACILITY_CD)   AS PYMT_FACILITY_CD              
MFA-TR*             ,STRIP(USER_ID)            AS USER_ID                       
MFA-TR*             ,STRIP(EMPLOYEE_NAME)      AS EMPLOYEE_NAME                 
MFA-TR*             ,STRIP(COMPANY_NO)         AS COMPANY_NO                    
MFA-TR*             ,STRIP(TRAN_COMMENT_TEXT)  AS TRAN_COMMENT_TEXT             
MFA-TR*             ,STRIP(RECORD_ONLY_FL)     AS RECORD_ONLY_FL                
MFA-TR*             ,STRIP(DATE_ORIG_PYMT)     AS DATE_ORIG_PYMT                
MFA-TR*             ,STRIP(CASH_LOCAL_OFFICE)  AS CASH_LOCAL_OFFICE             
MFA-TR*             ,CASH_DRAWER_ID                                             
MFA-TR*             ,STRIP(DATE_CASH_REPORT)   AS DATE_CASH_REPORT              
MFA-TR*             ,STRIP(CODE_BATCH_STATUS)  AS CODE_BATCH_STATUS             
MFA-TR*             ,STRIP(PYMT_RCPT_PRNTD_CD) AS PYMT_RCPT_PRNTD_CD            
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,STRIP(FULL_NAME)          AS FULL_NAME                     
MFA-TR*             ,STRIP(HOUSE_NO)           AS HOUSE_NO                      
MFA-TR*             ,STRIP(STREET_NAME)        AS STREET_NAME                   
MFA-TR*             ,STRIP(STREET_LOCATION_1)  AS STREET_LOCATION_1             
MFA-TR*             ,STRIP(STREET_LOCATION_2)  AS STREET_LOCATION_2             
MFA-TR*             ,OLD_EPP_AMT                                                
MFA-TR*             ,NEW_EPP_AMT                                                
MFA-TR*             ,ROWS_RETURNED                                              
MFA-TR*         FROM                                                            
MFA-TR*              SESSION.CSR02016_R1                                        
MFA-TR*    END-EXEC.                                                            
REARCH 0100-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 0100A-DECLARE-GTT                                              *        
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02016_R1'            
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02016_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02016_R1
              (                                                       
REARCH               RETURN_CODE            INT                     
REARCH              ,ACCOUNT_NO             DECIMAL(13,0)               
REARCH              ,TRANS_HIST_SEQ_NO CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,DATE_TRANS CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CODE_TRAN_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
A21427              ,TRAN_SHORT_DESC CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,AMT_ORIG_ENTERED       DECIMAL(11,2)               
REARCH              ,AMT_BILLED_UNPAID      DECIMAL(11,2)               
REARCH              ,RESP_AREA_ID CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
A21427              ,RESP_AREA_DESC CHAR(30)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,APPL_PROGRAM_ID CHAR(09)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,APPL_PROGRAM_DESC CHAR(20)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,PYMT_FACILITY_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,USER_ID CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2          
A21427              ,EMPLOYEE_NAME CHAR(50)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,COMPANY_NO CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,TRAN_COMMENT_TEXT CHAR(210)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                   
REARCH              ,RECORD_ONLY_FL CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,DATE_ORIG_PYMT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CASH_LOCAL_OFFICE CHAR(22)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CASH_DRAWER_ID         SMALLINT                    
REARCH              ,DATE_CASH_REPORT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CODE_BATCH_STATUS CHAR(08)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,PYMT_RCPT_PRNTD_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CUSTOMER_NO            DECIMAL(10,0)               
REARCH              ,PREMISE_NO             DECIMAL(10,0)               
REARCH              ,FULL_NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH              ,HOUSE_NO CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH*             ,STREET_NAME            CHAR(16)                            
A21422              ,STREET_NAME CHAR(30)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
A21422              ,STREET_LOCATION_1 CHAR(04)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
A21422              ,STREET_LOCATION_2 CHAR(11)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,OLD_EPP_AMT            DECIMAL(11,2)               
REARCH              ,NEW_EPP_AMT            DECIMAL(11,2)               
REARCH              ,ROWS_RETURNED          INT                     
REARCH          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH         PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT            
REARCH     ELSE                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH                NEXT SENTENCE                                     
REARCH         ELSE                                                     
REARCH            MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
REARCH            MOVE SQLCODE            TO ABEND-SQLCODE              
REARCH            MOVE SQLSTATE           TO ABEND-SQLSTATE             
REARCH            MOVE '0100A'            TO ACTIVE-PARAGRAPH           
REARCH            MOVE 'DECLARE GTT'      TO ABEND-FUNCTION             
REARCH            MOVE SPACES             TO ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH            MOVE 'CSR02016_R1'      TO TABLE-1                    
REARCH            MOVE SPACES             TO TABLE-ELEMENT-1            
REARCH            MOVE SPACES             TO HOSTVAR-ELEMENT-1          
REARCH            PERFORM 9900-SQL-ERROR-ROUTINE                        
REARCH                                    THRU  9900-EXIT               
REARCH         END-IF                                                   
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-NAVIG-PATH       TO WS-NAVIG-PATH.                 
           MOVE PARM-RESP-AREA-ID     TO WS-RESP-AREA-ID.               
           MOVE PARM-USER-ID          TO WS-USER-ID.                    
           MOVE PARM-FROM-DATE        TO WS-FROM-DATE.                  
           MOVE PARM-TO-DATE          TO WS-TO-DATE.                    
                                                                        
A21426     MOVE '-' TO WS-DASH-1 WS-DASH-2.                             
A21426     IF PARM-FROM-TIME = SPACES THEN                              
A21426        MOVE '00.00.00.000000' TO WS-FROM-TIME                    
A21426     ELSE                                                         
A21426        MOVE PARM-FROM-TIME TO WS-FROM-TIME                       
A21426     END-IF.                                                      
                                                                        
A21426     IF PARM-TO-TIME = SPACES THEN                                
A21426        MOVE '23.59.59.999999' TO WS-TO-TIME                      
A21426     ELSE                                                         
A21426        MOVE PARM-TO-TIME TO WS-TO-TIME                           
A21426     END-IF.                                                      
                                                                        
           IF PARM-ACCOUNT-NO = '*'                                     
              MOVE ZERO               TO WS-ACCOUNT-NO-NUM              
           ELSE                                                         
              MOVE PARM-ACCOUNT-NO    TO WS-ACCOUNT-NO                  
           END-IF.                                                      
                                                                        
           IF PARM-CUSTOMER-NO = '*'                                    
              MOVE ZERO               TO WS-CUSTOMER-NO-NUM             
           ELSE                                                         
              MOVE PARM-CUSTOMER-NO   TO WS-CUSTOMER-NO                 
           END-IF.                                                      
                                                                        
           IF PARM-PREMISE-NO = '*'                                     
              MOVE ZERO               TO WS-PREMISE-NO-NUM              
           ELSE                                                         
              MOVE PARM-PREMISE-NO    TO WS-PREMISE-NO                  
           END-IF.                                                      
A2145 * THE RESP_AREA_ID FOR BILLING IS SPACES.                                 
A2145 *    IF WS-RESP-AREA-ID = '*' OR WS-RESP-AREA-ID = SPACES                 
A2145      IF WS-RESP-AREA-ID = '*'                                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'R'                TO WS-NAVIG-PATH                  
           END-IF.                                                      
                                                                        
           IF WS-USER-ID = '*' OR WS-USER-ID = SPACES                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'U'                TO WS-NAVIG-PATH                  
           END-IF.                                                      
                                                                        
           IF PARM-CODE-TRAN-TYPE = '*'                                 
              MOVE '_'                   TO WS-CODE-TRAN-TYPE           
           ELSE                                                         
              MOVE PARM-CODE-TRAN-TYPE   TO WS-CODE-TRAN-TYPE           
           END-IF.                                                      
                                                                        
T28706     IF WS-CODE-TRAN-TYPE = 'X'                                   
T28706        MOVE 'B'                   TO WS-CODE-TRAN-TYPE           
T28706        MOVE 'P'                   TO WS-CODE-TRAN-TYPE1          
T28706     ELSE                                                         
T28706        MOVE WS-CODE-TRAN-TYPE     TO WS-CODE-TRAN-TYPE1          
T28706     END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2300-BUILD-RESULT                                    *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2300-BUILD-RESULT             THRU 2300-EXIT.        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT                                               *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE        TO S-RETURN-CODE.                
REARCH     MOVE  RS-ACCOUNT-NO         TO S-ACCOUNT-NO.                 
REARCH     MOVE  RS-TRANS-HIST-SEQ-NO  TO S-TRANS-HIST-SEQ-NO.          
REARCH     MOVE  RS-DATE-TRANS         TO S-DATE-TRANS.                 
REARCH     MOVE  RS-CODE-TRAN-TYPE     TO S-CODE-TRAN-TYPE.             
A21427     MOVE  RS-TRAN-SHORT-DESC    TO S-TRAN-SHORT-DESC.            
REARCH     MOVE  RS-AMT-ORIG-ENTERED   TO S-AMT-ORIG-ENTERED.           
REARCH     MOVE  RS-AMT-BILLED-UNPAID  TO S-AMT-BILLED-UNPAID.          
REARCH     MOVE  RS-RESP-AREA-ID       TO S-RESP-AREA-ID.               
A21427     MOVE  RS-RESP-AREA-DESC     TO S-RESP-AREA-DESC.             
REARCH     MOVE  RS-APPL-PROGRAM-ID    TO S-APPL-PROGRAM-ID.            
REARCH     MOVE  RS-APPL-PROGRAM-DESC  TO S-APPL-PROGRAM-DESC.          
REARCH     MOVE  RS-PYMT-FACILITY-CD   TO S-PYMT-FACILITY-CD.           
REARCH     MOVE  RS-USER-ID            TO S-USER-ID.                    
A21427     MOVE  RS-EMPLOYEE-NAME      TO S-EMPLOYEE-NAME.              
REARCH     MOVE  RS-COMPANY-NO         TO S-COMPANY-NO.                 
REARCH     MOVE  RS-TRAN-COMMENT       TO S-TRAN-COMMENT.               
REARCH     MOVE  RS-RECORD-ONLY-FL     TO S-RECORD-ONLY-FL.             
REARCH     MOVE  RS-DATE-ORIG-PYMT     TO S-DATE-ORIG-PYMT.             
REARCH     MOVE  RS-CASH-LOCAL-OFFICE  TO S-CASH-LOCAL-OFFICE.          
REARCH     MOVE  RS-CASH-DRAWER-ID     TO S-CASH-DRAWER-ID.             
REARCH     MOVE  RS-DATE-CASH-REPORT   TO S-DATE-CASH-REPORT.           
REARCH     MOVE  RS-CODE-BATCH-STATUS  TO S-CODE-BATCH-STATUS.          
REARCH     MOVE  RS-PYMT-RCPT-PRNTD-CD TO S-PYMT-RCPT-PRNTD-CD.         
REARCH     MOVE  RS-CUSTOMER-NO        TO S-CUSTOMER-NO.                
REARCH     MOVE  RS-PREMISE-NO         TO S-PREMISE-NO.                 
REARCH     MOVE  RS-FULL-NAME          TO S-FULL-NAME.                  
REARCH     MOVE  RS-HOUSE-NO           TO S-HOUSE-NO.                   
REARCH     MOVE  RS-STREET-NAME        TO S-STREET-NAME.                
A21422     MOVE  RS-STREET-LOCATION-1  TO S-STREET-LOCATION-1.          
A21422     MOVE  RS-STREET-LOCATION-2  TO S-STREET-LOCATION-2.          
REARCH     MOVE  RS-OLD-EPP-AMT        TO S-OLD-EPP-AMT.                
REARCH     MOVE  RS-NEW-EPP-AMT        TO S-NEW-EPP-AMT.                
REARCH     MOVE  RS-ROWS-RETURNED      TO S-ROWS-RETURNED.              
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2300-BUILD-RESULT.                                               
                                                                        
T10523*    MOVE '-00.00.00.000000' TO WS-FROM-TIME.                             
T10523*    MOVE '-23.59.59.999999' TO WS-TO-TIME.                               
                                                                        
           IF WS-FROM-DATE = 'LOCATE' AND                               
              ACCOUNT-SELECTION                                         
T18458*       MOVE WS-ACCOUNT-NO-NUM             TO AT-ACCOUNT-NO               
T18458*       PERFORM 7300-FETCH-ACCT-CREATE-DT  THRU 7300-EXIT                 
T18458*       MOVE WS-ACCT-CREATE-DT(1:10)       TO WS-FROM-DATE                
T18458        MOVE '1900-01-01'                  TO WS-FROM-DATE        
           END-IF.                                                      
                                                                        
           EVALUATE TRUE                                                
               WHEN ACCOUNT-SELECTION                                   
                    MOVE WS-ACCOUNT-NO-NUM  TO                          
                         AR-ACCOUNT-NO                                  
                         MH-ACCOUNT-NO                                  
                    PERFORM 7000-OPEN-AR-ACCOUNT    THRU 7000-EXIT      
                    PERFORM 7100-FETCH-AR-ACCOUNT   THRU 7100-EXIT      
                    PERFORM 7030-OPEN-MH-ACCOUNT    THRU 7030-EXIT      
                    PERFORM 7130-FETCH-MH-ACCOUNT   THRU 7130-EXIT      
               WHEN USER-ID-SELECTION                                   
                    MOVE WS-USER-ID  TO                                 
                         AR-USER-ID                                     
                         MH-USER-ID                                     
                    MOVE WS-CODE-TRAN-TYPE  TO                          
                         AR-CODE-TRAN-TYPE                              
                         MH-CODE-TRAN-TYPE                              
                    PERFORM 7010-OPEN-AR-USER-ID    THRU 7010-EXIT      
                    PERFORM 7110-FETCH-AR-USER-ID   THRU 7110-EXIT      
                    PERFORM 7060-OPEN-MH-USER-ID    THRU 7060-EXIT      
                    PERFORM 7160-FETCH-MH-USER-ID   THRU 7160-EXIT      
               WHEN RESP-AREA-SELECTION                                 
                    MOVE WS-RESP-AREA-ID  TO                            
                         AR-RESP-AREA-ID                                
                         MH-RESP-AREA-ID                                
                    MOVE WS-CODE-TRAN-TYPE  TO                          
                         AR-CODE-TRAN-TYPE                              
                         MH-CODE-TRAN-TYPE                              
                    PERFORM 7020-OPEN-AR-RESP-AREA  THRU 7020-EXIT      
                    PERFORM 7120-FETCH-AR-RESP-AREA THRU 7120-EXIT      
                    PERFORM 7070-OPEN-MH-RESP-AREA  THRU 7070-EXIT      
                    PERFORM 7170-FETCH-MH-RESP-AREA THRU 7170-EXIT      
               WHEN CUSTOMER-SELECTION                                  
                    MOVE WS-CUSTOMER-NO-NUM  TO                         
                         MH-CUSTOMER-NO                                 
                    PERFORM 7040-OPEN-MH-CUSTOMER   THRU 7040-EXIT      
                    PERFORM 7140-FETCH-MH-CUSTOMER  THRU 7140-EXIT      
                    MOVE WS-LOW-DATE  TO                                
                         WS-DATE-COMP-AR                                
               WHEN PREMISE-SELECTION                                   
                    MOVE WS-PREMISE-NO-NUM  TO                          
                         MH-PREMISE-NO                                  
                    PERFORM 7050-OPEN-MH-PREMISE    THRU 7050-EXIT      
                    PERFORM 7150-FETCH-MH-PREMISE   THRU 7150-EXIT      
                    MOVE WS-LOW-DATE  TO                                
                         WS-DATE-COMP-AR                                
C37538         WHEN OTHER                                               
C37538             PERFORM 2340-SEND-EMPTY-TBL   THRU 2340-EXIT         
C37538             PERFORM 9999-END-PROGRAM      THRU 9999-EXIT         
           END-EVALUATE.                                                
                                                                        
           MOVE 0                                TO WS-ROWS-RETURNED.   
           MOVE ZEROES                           TO HT-ACCOUNT-NO       
                                                    HT-CUSTOMER-NO      
                                                    HT-PREMISE-NO.      
           PERFORM 2310-PROCESS-AR-MH-DATA     THRU 2310-EXIT           
             UNTIL WS-ROWS-RETURNED >= 100       OR                     
                  (WS-DATE-COMP-AR            EQUAL WS-LOW-DATE AND     
                   WS-DATE-COMP-MH            EQUAL WS-LOW-DATE).       
                                                                        
           IF  WS-ROWS-RETURNED               EQUAL ZERO                
               PERFORM 2340-SEND-EMPTY-TBL     THRU 2340-EXIT           
           END-IF.                                                      
                                                                        
           EVALUATE TRUE                                                
               WHEN ACCOUNT-SELECTION                                   
                    PERFORM 7200-CLOSE-AR-ACCOUNT   THRU 7200-EXIT      
                    PERFORM 7230-CLOSE-MH-ACCOUNT   THRU 7230-EXIT      
               WHEN USER-ID-SELECTION                                   
                    PERFORM 7210-CLOSE-AR-USER-ID   THRU 7210-EXIT      
                    PERFORM 7260-CLOSE-MH-USER-ID   THRU 7260-EXIT      
               WHEN RESP-AREA-SELECTION                                 
                    PERFORM 7220-CLOSE-AR-RESP-AREA THRU 7220-EXIT      
                    PERFORM 7270-CLOSE-MH-RESP-AREA THRU 7270-EXIT      
               WHEN CUSTOMER-SELECTION                                  
                    PERFORM 7240-CLOSE-MH-CUSTOMER  THRU 7240-EXIT      
               WHEN PREMISE-SELECTION                                   
                    PERFORM 7250-CLOSE-MH-PREMISE   THRU 7250-EXIT      
           END-EVALUATE.                                                
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2310-PROCESS-AR-MH-DATA                                        *        
      *     CALLS       7110-FETCH-TH-ACCT                             *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      *     IF THE ROW EXISTS A NEW ROW IS FORMATTED AND INSERTED.     *        
      ******************************************************************        
                                                                        
       2310-PROCESS-AR-MH-DATA.                                         
           EVALUATE TRUE                                                
               WHEN WS-DATE-COMP-AR     EQUAL WS-LOW-DATE  AND          
                    WS-DATE-COMP-MH     EQUAL WS-LOW-DATE               
                    CONTINUE                                            
               WHEN WS-DATE-COMP-AR      LESS WS-DATE-COMP-MH           
                    PERFORM 2330-SEND-MH-DATA THRU 2330-EXIT            
               WHEN OTHER                                               
                    PERFORM 2320-SEND-AR-DATA THRU 2320-EXIT            
           END-EVALUATE.                                                
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2320-SEND-AR-DATA                                              *        
      *     CALLS       7120-FETCH-TH-CUST                             *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      *     IF THE ROW EXISTS A NEW ROW IS FORMATTED AND INSERTED.     *        
      ******************************************************************        
                                                                        
       2320-SEND-AR-DATA.                                               
                                                                        
           MOVE AR-ACCOUNT-NO            TO RS-ACCOUNT-NO.              
           MOVE AR-TRANS-HIST-SEQ-NO     TO RS-TRANS-HIST-SEQ-NO.       
           MOVE AR-DATE-TRANS            TO RS-DATE-TRANS.              
           MOVE AR-CODE-TRAN-TYPE        TO RS-CODE-TRAN-TYPE.          
A21427     MOVE AR-CODE-TRAN-TYPE        TO BY-CODE-TRAN-TYPE.          
A21427     PERFORM 7670-GET-TRAN-SHORT-DESC THRU 7670-EXIT.             
A21427     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A21427        MOVE BY-CODE-TRAN-TYPE     TO RS-TRAN-SHORT-DESC          
A21427     ELSE                                                         
A21427        MOVE BY-TRAN-SHORT-DESC    TO RS-TRAN-SHORT-DESC          
A21427     END-IF.                                                      
           MOVE AR-AMT-ORIG-ENTERED      TO RS-AMT-ORIG-ENTERED.        
           MOVE AR-AMT-BILLED-UNPAID     TO RS-AMT-BILLED-UNPAID.       
           MOVE AR-RESP-AREA-ID          TO RS-RESP-AREA-ID.            
A21427     MOVE AR-RESP-AREA-ID          TO C1-RESP-AREA-ID.            
A21427     PERFORM 7650-GET-RESP-AREA-DESC THRU 7650-EXIT.              
A21427     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A21427        MOVE RS-RESP-AREA-ID      TO RS-RESP-AREA-DESC            
A21427     ELSE                                                         
A21427        MOVE C1-RESP-AREA-DESC    TO RS-RESP-AREA-DESC            
A21427     END-IF.                                                      
           MOVE AR-APPL-PROGRAM-ID       TO RS-APPL-PROGRAM-ID.         
           MOVE AR-APPL-PROGRAM-ID       TO K9-APPL-PROGRAM-ID.         
           PERFORM 7600-GET-PROG-DESC    THRU 7600-EXIT.                
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE RS-APPL-PROGRAM-ID   TO RS-APPL-PROGRAM-DESC         
           ELSE                                                         
              MOVE K9-APPL-PROGRAM-DESC TO RS-APPL-PROGRAM-DESC         
           END-IF.                                                      
           MOVE AR-PYMT-FACILITY-CD      TO RS-PYMT-FACILITY-CD.        
           MOVE AR-USER-ID               TO RS-USER-ID.                 
A21427     MOVE AR-USER-ID               TO PF-USER-ID.                 
A21427     PERFORM 2430-FORMAT-EMPLOYEE-NAME THRU 2430-EXIT.            
A21427     MOVE WS-EMPLOYEE-NAME         TO RS-EMPLOYEE-NAME.           
           MOVE AR-COMPANY-NO            TO RS-COMPANY-NO.              
P0282      MOVE AR-CASH-COMPANY-NO       TO BC-CASH-COMPANY-NO.         
P0282      MOVE AR-CASH-LOCAL-OFFICE     TO BC-CASH-LOCAL-OFFICE.       
C20723     MOVE AR-CASH-LOCAL-OFFICE     TO Y2-CASH-LOCAL-OFFICE.       
P0451      PERFORM 7400-SELECT-PAY-OFC-DESC  THRU 7400-EXIT.            
*************** TPR 5393 ********************************************           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
C20723        MOVE Y2-CASH-LOCAL-OFFICE TO RS-CASH-LOCAL-OFFICE         
           ELSE                                                         
C20723        MOVE Y2-CASH-LOC-OFF-DESC TO RS-CASH-LOCAL-OFFICE         
           END-IF.                                                      
*********************************************************************           
C35842*                                                                         
C35842     IF (AR-CASH-LOCAL-OFFICE = '058' OR                          
C35842                 AR-CASH-LOCAL-OFFICE = '038') AND                
C35842                 AR-PYMT-FACILITY-CD = 'O'                        
C35842        MOVE AR-TRAN-COMMENT-TEXT(13:3)   TO Y2-CASH-LOCAL-OFFICE 
C35842        PERFORM 7400-SELECT-PAY-OFC-DESC  THRU 7400-EXIT          
C35842        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C35842           MOVE Y2-CASH-LOC-OFF-DESC  TO WS-CASH-LOCAL-OFFICE     
C35842           STRING WS-BMX, WS-CASH-LOCAL-OFFICE DELIMITED SIZE     
C35842                             INTO RS-CASH-LOCAL-OFFICE            
C35842        END-IF                                                    
C35842     END-IF.                                                      
C35842*                                                                         
T10422*    MOVE AR-CASH-REPORT-NO        TO RS-CASH-REPORT-NO.                  
P0282      MOVE AR-CASH-REPORT-NO        TO BC-CASH-REPORT-NO.          
P0282      UNSTRING AR-DATE-CASH-REPORT                                 
P0282           DELIMITED BY '-'                                        
P0282           INTO WS-CCYY                                            
P0282                WS-MM                                              
P0282                WS-DD.                                             
P0282      MOVE WS-CCYY                  TO WS-YEAR.                    
P0282      MOVE WS-MM                    TO WS-MONTH.                   
P0282      MOVE WS-DD                    TO WS-DAY.                     
P0282      MOVE WS-DATE-MMDDCCYY         TO RS-DATE-CASH-REPORT.        
P0282      MOVE AR-DATE-CASH-REPORT      TO BC-DATE-CASH-REPORT.        
P0282      MOVE AR-CASH-DRAWER-ID        TO BC-CASH-DRAWER-ID.          
T10422     MOVE AR-CASH-DRAWER-ID        TO RS-CASH-DRAWER-ID.          
P0282      PERFORM 7450-SELECT-BC            THRU 7450-EXIT.            
PCR404     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
PCR404        PERFORM 7460-SELECT-CSH-DRWR   THRU 7460-EXIT             
PCR404     END-IF.                                                      
PCR404     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
PCR404        MOVE SPACES              TO BC-CODE-BATCH-STATUS          
PCR404     END-IF                                                       
P0282      EVALUATE   BC-CODE-BATCH-STATUS                              
P0282           WHEN 'A'                                                
P0282                 MOVE 'ACTIVE'    TO RS-CODE-BATCH-STATUS          
P0282           WHEN 'B'                                                
P0282                 MOVE 'BALANCED'  TO RS-CODE-BATCH-STATUS          
P0282           WHEN 'C'                                                
P0282                 MOVE 'CLOSED'    TO RS-CODE-BATCH-STATUS          
P0282           WHEN 'P'                                                
P0282                 MOVE 'PENDING'   TO RS-CODE-BATCH-STATUS          
P0282           WHEN OTHER                                              
P0282                 MOVE SPACES      TO RS-CODE-BATCH-STATUS          
P0282      END-EVALUATE.                                                
                                                                        
P0282      MOVE AR-PYMT-RCPT-PRNTD-CD  TO RS-PYMT-RCPT-PRNTD-CD.        
           MOVE AR-TRAN-COMMENT-TEXT     TO RS-TRAN-COMMENT.            
           MOVE AR-RECORD-ONLY-FL        TO RS-RECORD-ONLY-FL.          
           IF WS-DOP-NI = -1                                            
              MOVE SPACE                 TO RS-DATE-ORIG-PYMT           
           ELSE                                                         
              MOVE AR-DATE-ORIG-PYMT     TO WS-DATE-HOLD                
              PERFORM 7500-GET-USA-DATE  THRU 7500-EXIT                 
              MOVE WS-DATE-HOLD-USA      TO RS-DATE-ORIG-PYMT           
           END-IF.                                                      
           MOVE ZERO                     TO RS-CUSTOMER-NO.             
           MOVE ZERO                     TO RS-PREMISE-NO.              
           IF USER-ID-SELECTION          OR                             
              RESP-AREA-SELECTION                                       
              IF  AR-ACCOUNT-NO       EQUAL HT-ACCOUNT-NO               
                  CONTINUE                                              
              ELSE                                                      
                  MOVE AR-ACCOUNT-NO     TO HT-ACCOUNT-NO               
                  PERFORM 2400-FORMAT-NAME-ADDR                         
                                       THRU 2400-EXIT                   
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                TO WS-FULL-NAME                
                                            WS-HOUSE-NO                 
                                            WS-STREET-NAME              
                                            WS-STREET-LOCATION-1        
                                            WS-STREET-LOCATION-2        
           END-IF.                                                      
           MOVE WS-FULL-NAME             TO RS-FULL-NAME.               
           MOVE WS-HOUSE-NO              TO RS-HOUSE-NO.                
           MOVE WS-STREET-NAME           TO RS-STREET-NAME.             
           MOVE WS-STREET-LOCATION-1     TO RS-STREET-LOCATION-1.       
           MOVE WS-STREET-LOCATION-2     TO RS-STREET-LOCATION-2.       
           MOVE WS-ROWS-RETURNED         TO RS-ROWS-RETURNED.           
           MOVE ZERO                     TO RS-OLD-EPP-AMT              
                                            RS-NEW-EPP-AMT.             
REARCH     PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.               
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
           PERFORM 2350-INIT-AR-VARS     THRU 2350-EXIT.                
                                                                        
           MOVE SPACE                    TO AR-TRAN-COMMENT-TEXT.       
           ADD 1                         TO WS-ROWS-RETURNED.           
           EVALUATE TRUE                                                
               WHEN ACCOUNT-SELECTION                                   
                    PERFORM 7100-FETCH-AR-ACCOUNT   THRU 7100-EXIT      
               WHEN USER-ID-SELECTION                                   
                    PERFORM 7110-FETCH-AR-USER-ID   THRU 7110-EXIT      
               WHEN RESP-AREA-SELECTION                                 
                    PERFORM 7120-FETCH-AR-RESP-AREA THRU 7120-EXIT      
           END-EVALUATE.                                                
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2330-SEND-MH-DATA                                              *        
      *     CALLS       7120-FETCH-TH-CUST                             *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      *     IF THE ROW EXISTS A NEW ROW IS FORMATTED AND INSERTED.     *        
      ******************************************************************        
                                                                        
       2330-SEND-MH-DATA.                                               
                                                                        
           MOVE MH-ACCOUNT-NO            TO RS-ACCOUNT-NO.              
           MOVE MH-TRANS-HIST-SEQ-NO     TO RS-TRANS-HIST-SEQ-NO.       
           MOVE MH-DATE-TRANS            TO RS-DATE-TRANS.              
           MOVE MH-CODE-TRAN-TYPE        TO RS-CODE-TRAN-TYPE.          
A21427     MOVE MH-CODE-TRAN-TYPE        TO BY-CODE-TRAN-TYPE.          
A21427     PERFORM 7670-GET-TRAN-SHORT-DESC THRU 7670-EXIT.             
A21427     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A21427        MOVE BY-CODE-TRAN-TYPE     TO RS-TRAN-SHORT-DESC          
A21427     ELSE                                                         
A21427        MOVE BY-TRAN-SHORT-DESC    TO RS-TRAN-SHORT-DESC          
A21427     END-IF.                                                      
           MOVE ZERO                     TO RS-AMT-ORIG-ENTERED.        
           MOVE ZERO                     TO RS-AMT-BILLED-UNPAID.       
           MOVE MH-RESP-AREA-ID          TO RS-RESP-AREA-ID.            
A21427     MOVE MH-RESP-AREA-ID          TO C1-RESP-AREA-ID.            
A21427     PERFORM 7650-GET-RESP-AREA-DESC THRU 7650-EXIT.              
A21427     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A21427        MOVE RS-RESP-AREA-ID      TO RS-RESP-AREA-DESC            
A21427     ELSE                                                         
A21427        MOVE C1-RESP-AREA-DESC    TO RS-RESP-AREA-DESC            
A21427     END-IF.                                                      
           MOVE MH-APPL-PROGRAM-ID       TO RS-APPL-PROGRAM-ID.         
           MOVE MH-APPL-PROGRAM-ID       TO K9-APPL-PROGRAM-ID.         
           PERFORM 7600-GET-PROG-DESC    THRU 7600-EXIT.                
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE RS-APPL-PROGRAM-ID   TO RS-APPL-PROGRAM-DESC         
           ELSE                                                         
              MOVE K9-APPL-PROGRAM-DESC TO RS-APPL-PROGRAM-DESC         
           END-IF.                                                      
           MOVE SPACE                    TO RS-PYMT-FACILITY-CD.        
           MOVE MH-USER-ID               TO RS-USER-ID.                 
A21427     MOVE MH-USER-ID               TO PF-USER-ID.                 
A21427     PERFORM 2430-FORMAT-EMPLOYEE-NAME THRU 2430-EXIT.            
A21427     MOVE WS-EMPLOYEE-NAME         TO RS-EMPLOYEE-NAME.           
           MOVE ZERO                     TO RS-COMPANY-NO.              
           MOVE MH-TRAN-COMMENT-TEXT     TO RS-TRAN-COMMENT.            
           IF RS-TRAN-COMMENT = 'EPP CHG AMT ANNIV' THEN                
              PERFORM 2331-SEL-EPP       THRU 2331-EXIT                 
           ELSE                                                         
              MOVE ZERO                  TO RS-OLD-EPP-AMT              
                                            RS-NEW-EPP-AMT              
           END-IF                                                       
           MOVE SPACE                    TO RS-RECORD-ONLY-FL.          
           MOVE SPACE                    TO RS-DATE-ORIG-PYMT.          
           MOVE MH-CUSTOMER-NO           TO RS-CUSTOMER-NO.             
           MOVE MH-PREMISE-NO            TO RS-PREMISE-NO.              
           IF USER-ID-SELECTION          OR                             
              RESP-AREA-SELECTION                                       
              IF  MH-ACCOUNT-NO     GREATER ZERO                        
                  IF  MH-ACCOUNT-NO   EQUAL HT-ACCOUNT-NO               
                      CONTINUE                                          
                  ELSE                                                  
                      MOVE MH-ACCOUNT-NO TO HT-ACCOUNT-NO               
                      PERFORM 2400-FORMAT-NAME-ADDR                     
                                       THRU 2400-EXIT                   
                  END-IF                                                
A21429            MOVE MH-ACCOUNT-NO TO AT-ACCOUNT-NO                   
A21429            PERFORM 7700-GET-COMPANY-NO-ACCT  THRU 7700-EXIT      
A21429            IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
A21429               MOVE ZERO           TO RS-COMPANY-NO               
A21429            ELSE                                                  
A21429               MOVE AT-COMPANY-NO  TO RS-COMPANY-NO               
A21429            END-IF                                                
              END-IF                                                    
              IF  MH-CUSTOMER-NO    GREATER ZERO                        
                  IF  MH-CUSTOMER-NO  EQUAL HT-CUSTOMER-NO              
                      CONTINUE                                          
                  ELSE                                                  
                      MOVE MH-CUSTOMER-NO TO HT-CUSTOMER-NO             
                      PERFORM 2410-FORMAT-NAME                          
                                       THRU 2410-EXIT                   
                  END-IF                                                
A21429            MOVE MH-CUSTOMER-NO TO CU-CUSTOMER-NO                 
A21429            PERFORM 7710-GET-COMPANY-NO-CUST  THRU 7710-EXIT      
A21429            IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
A21429               MOVE ZERO           TO RS-COMPANY-NO               
A21429            ELSE                                                  
A21429               MOVE CU-COMPANY-NO-ORIG  TO RS-COMPANY-NO          
A21429            END-IF                                                
              END-IF                                                    
              IF  MH-PREMISE-NO     GREATER ZERO                        
                  IF  MH-PREMISE-NO   EQUAL HT-PREMISE-NO               
                      CONTINUE                                          
                  ELSE                                                  
                      MOVE MH-PREMISE-NO TO HT-PREMISE-NO               
                      PERFORM 2420-FORMAT-ADDR                          
                                       THRU 2420-EXIT                   
                  END-IF                                                
A21429            MOVE MH-PREMISE-NO TO PR-PREMISE-NO                   
A21429            PERFORM 7720-GET-COMPANY-NO-PREM  THRU 7720-EXIT      
A21429            IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
A21429               MOVE ZERO           TO RS-COMPANY-NO               
A21429            ELSE                                                  
A21429               MOVE PR-COMPANY-NO  TO RS-COMPANY-NO               
A21429            END-IF                                                
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                TO WS-FULL-NAME                
                                            WS-HOUSE-NO                 
                                            WS-STREET-NAME              
A21422                                      WS-STREET-LOCATION-1        
A21422                                      WS-STREET-LOCATION-2        
           END-IF.                                                      
           MOVE WS-FULL-NAME             TO RS-FULL-NAME.               
           MOVE WS-HOUSE-NO              TO RS-HOUSE-NO.                
           MOVE WS-STREET-NAME           TO RS-STREET-NAME.             
A21422     MOVE WS-STREET-LOCATION-1     TO RS-STREET-LOCATION-1.       
A21422     MOVE WS-STREET-LOCATION-2     TO RS-STREET-LOCATION-2.       
           MOVE WS-ROWS-RETURNED         TO RS-ROWS-RETURNED.           
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.               
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
           PERFORM 2360-INIT-MN-VARS     THRU 2360-EXIT.                
                                                                        
           MOVE SPACE                    TO MH-TRAN-COMMENT-TEXT.       
           ADD 1                         TO WS-ROWS-RETURNED.           
                                                                        
           EVALUATE TRUE                                                
               WHEN ACCOUNT-SELECTION                                   
                    PERFORM 7130-FETCH-MH-ACCOUNT   THRU 7130-EXIT      
               WHEN USER-ID-SELECTION                                   
                    PERFORM 7160-FETCH-MH-USER-ID   THRU 7160-EXIT      
               WHEN RESP-AREA-SELECTION                                 
                    PERFORM 7170-FETCH-MH-RESP-AREA THRU 7170-EXIT      
               WHEN CUSTOMER-SELECTION                                  
                    PERFORM 7140-FETCH-MH-CUSTOMER  THRU 7140-EXIT      
               WHEN PREMISE-SELECTION                                   
                    PERFORM 7150-FETCH-MH-PREMISE   THRU 7150-EXIT      
           END-EVALUATE.                                                
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
                                                                        
T13716************************************************************              
T13716* 2331-SEL-EPP.                                                           
T13716*                                                          *              
T13716* TO GET OLD AND NEW EPP AMOUNT FOR DISPLAY                *              
T13716************************************************************              
T13716 2331-SEL-EPP.                                                    
T13716                                                                  
           PERFORM 2332-OPEN-EPP-ACCOUNT    THRU 2332-EXIT.             
           PERFORM 2333-FETCH-EPP-ACCOUNT   THRU 2333-EXIT.             
           PERFORM 2334-CLOSE-EPP-ACCOUNT   THRU 2334-EXIT.             
T13716                                                                  
T13716 2331-EXIT.                                                       
T13716     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2332-OPEN-EPP-ACCOUNT                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       2332-OPEN-EPP-ACCOUNT.                                           
                                                                        
           MOVE '2332'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN EPP-ACCOUNT-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_BUDGET_HIST'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2332-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2333-FETCH-EPP-ACCOUNT                                         *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       2333-FETCH-EPP-ACCOUNT.                                          
                                                                        
           MOVE '2333'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH EPP-ACCOUNT-CURSOR                                  
              INTO  :BH-AMT-MO-PYMT,                                    
                    :BH-CHANGE-REASON                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-EPP-FLAG = 'Y'                                
                       MOVE BH-AMT-MO-PYMT    TO RS-OLD-EPP-AMT         
                       GO TO 2333-EXIT                                  
                    END-IF                                              
                    IF BH-CHANGE-REASON = 'A'                           
                       MOVE BH-AMT-MO-PYMT    TO RS-NEW-EPP-AMT         
                       MOVE 'Y'               TO WS-EPP-FLAG            
                       GO TO 2333-FETCH-EPP-ACCOUNT                     
                    ELSE                                                
                       GO TO 2333-FETCH-EPP-ACCOUNT                     
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE ZERO                 TO RS-OLD-EPP-AMT         
                    MOVE ZERO                 TO RS-NEW-EPP-AMT         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
CBSI                MOVE SPACES               TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
                    MOVE 'CSS_BUDGET_HIST'    TO TABLE-1                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       2333-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2334-CLOSE-EPP-ACCOUNT                                         *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       2334-CLOSE-EPP-ACCOUNT.                                          
                                                                        
           MOVE '2334'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE EPP-ACCOUNT-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_BUDGET_HIST'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2334-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2340-SEND-EMPTY-TBL                                            *        
      *     CALLS  8100-SEND-RESULT                                    *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     SENDS AN EMPTY TABLE BACK.  THAT IS, THERE ARE NO          *        
      *     TRANSACTION HISTORY SUMMARY ROWS.                          *        
      ******************************************************************        
                                                                        
       2340-SEND-EMPTY-TBL.                                             
                                                                        
            MOVE '2340' TO ACTIVE-PARAGRAPH.                            
                                                                        
            MOVE ZERO                     TO RS-ACCOUNT-NO.             
            MOVE SPACE                    TO RS-TRANS-HIST-SEQ-NO.      
            MOVE SPACE                    TO RS-DATE-TRANS.             
            MOVE SPACE                    TO RS-CODE-TRAN-TYPE.         
A21427      MOVE SPACE                    TO RS-TRAN-SHORT-DESC.        
            MOVE ZERO                     TO RS-AMT-ORIG-ENTERED.       
            MOVE ZERO                     TO RS-AMT-BILLED-UNPAID.      
            MOVE SPACE                    TO RS-RESP-AREA-ID.           
A21427      MOVE SPACE                    TO RS-RESP-AREA-DESC.         
            MOVE SPACE                    TO RS-APPL-PROGRAM-ID.        
            MOVE SPACE                    TO RS-APPL-PROGRAM-DESC.      
            MOVE SPACE                    TO RS-PYMT-FACILITY-CD.       
            MOVE SPACE                    TO RS-USER-ID.                
A21427      MOVE SPACE                    TO RS-EMPLOYEE-NAME.          
            MOVE ZERO                     TO RS-COMPANY-NO.             
            MOVE SPACE                    TO RS-TRAN-COMMENT.           
            MOVE SPACE                    TO RS-RECORD-ONLY-FL.         
            MOVE SPACE                    TO RS-DATE-ORIG-PYMT.         
            MOVE ZERO                     TO RS-CUSTOMER-NO.            
            MOVE ZERO                     TO RS-PREMISE-NO.             
            MOVE SPACE                    TO RS-FULL-NAME.              
            MOVE SPACE                    TO RS-HOUSE-NO.               
            MOVE SPACE                    TO RS-STREET-NAME.            
A21422      MOVE SPACE                    TO RS-STREET-LOCATION-1.      
A21422      MOVE SPACE                    TO RS-STREET-LOCATION-2.      
            MOVE 999                      TO RS-ROWS-RETURNED.          
            MOVE ZERO                     TO RS-OLD-EPP-AMT             
                                             RS-NEW-EPP-AMT.            
REARCH      PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.              
            PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.               
            PERFORM 2350-INIT-AR-VARS     THRU 2350-EXIT.               
            PERFORM 2360-INIT-MN-VARS     THRU 2360-EXIT.               
                                                                        
       2340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2350-INIT-AR-VARS.                                             *        
      *     CALLS  NOTHING                                             *        
      *                                                                *        
      *     CALLED AFTER EVERY PERFORM 8100-SEND-RESULT                *        
      *                                                                *        
      *     INITIALIZES ALL RETRIEVABLE AR-VARIABLES.                  *        
      ******************************************************************        
       2350-INIT-AR-VARS.                                               
                                                                        
            MOVE ZERO                     TO AR-ACCOUNT-NO.             
            MOVE SPACE                    TO AR-TRANS-HIST-SEQ-NO.      
            MOVE SPACE                    TO AR-DATE-TRANS.             
            MOVE SPACE                    TO AR-CODE-TRAN-TYPE.         
            MOVE ZERO                     TO AR-AMT-ORIG-ENTERED.       
            MOVE ZERO                     TO AR-AMT-BILLED-UNPAID.      
            MOVE SPACE                    TO AR-RESP-AREA-ID.           
            MOVE SPACE                    TO AR-APPL-PROGRAM-ID.        
            MOVE SPACE                    TO AR-PYMT-FACILITY-CD.       
            MOVE SPACE                    TO AR-USER-ID.                
            MOVE ZERO                     TO AR-COMPANY-NO.             
            MOVE SPACE                    TO AR-TRAN-COMMENT.           
            MOVE SPACE                    TO AR-RECORD-ONLY-FL.         
            MOVE SPACE                    TO AR-DATE-ORIG-PYMT.         
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2360-INIT-MN-VARS.                                             *        
      *     CALLS  NOTHING                                             *        
      *                                                                *        
      *     CALLED AFTER EVERY PERFORM 8100-SEND-RESULT                *        
      *                                                                *        
      *     INITIALIZES ALL RETRIEVABLE MN-VARIABLES.                  *        
      ******************************************************************        
       2360-INIT-MN-VARS.                                               
                                                                        
            MOVE ZERO                     TO MH-ACCOUNT-NO.             
            MOVE SPACE                    TO MH-TRANS-HIST-SEQ-NO.      
            MOVE SPACE                    TO MH-DATE-TRANS.             
            MOVE SPACE                    TO MH-CODE-TRAN-TYPE.         
            MOVE SPACE                    TO MH-RESP-AREA-ID.           
            MOVE SPACE                    TO MH-APPL-PROGRAM-ID.        
            MOVE SPACE                    TO MH-USER-ID.                
            MOVE SPACE                    TO MH-TRAN-COMMENT.           
            MOVE ZERO                     TO MH-CUSTOMER-NO.            
            MOVE ZERO                     TO MH-PREMISE-NO.             
                                                                        
       2360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-FORMAT-NAME-ADDR.                                         *        
      *     CALLS  7320-SELECT-NAME-ADDR                               *        
      *                                                                *        
      *     CALLED FROM 2320-SEND-AR-DATA                              *        
      *                 2330-SEND-MH-DATA                              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2400-FORMAT-NAME-ADDR.                                           
           MOVE '2400' TO ACTIVE-PARAGRAPH.                             
           MOVE ZEROES                   TO HT-CUSTOMER-NO              
                                            HT-PREMISE-NO.              
           MOVE SPACES                   TO WS-FULL-NAME                
                                            WS-FIRST-NAME               
                                            WS-MIDDLE-NAME              
                                            WS-LAST-NAME                
                                            WS-HOUSE-NO                 
                                            WS-STREET-NAME              
                                            WS-STREET-LOCATION-1        
                                            WS-STREET-LOCATION-2.       
           PERFORM 7320-SELECT-NAME-ADDR    THRU 7320-EXIT.             
                                                                        
           IF WS-NAME-FORMAT = 'I'                                      
              MOVE SPACES TO WS-FULL-NAME                               
              STRING WS-FIRST-NAME  DELIMITED SPACE                     
                     ' '            DELIMITED SIZE                      
                     WS-MIDDLE-NAME DELIMITED SPACE                     
                     ' '            DELIMITED SIZE                      
                     WS-LAST-NAME   DELIMITED SPACE                     
                INTO WS-FULL-NAME                                       
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2410-FORMAT-NAME.                                              *        
      *     CALLS  7330-OPEN-CUST-NAME                                 *        
      *            7340-FETCH-CUST-NAME                                *        
      *            7350-CLOSE-CUST-NAME                                *        
      *                                                                *        
      *     CALLED FROM 2330-SEND-MH-DATA                              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2410-FORMAT-NAME.                                                
           MOVE '2410' TO ACTIVE-PARAGRAPH.                             
           MOVE ZEROES                   TO HT-ACCOUNT-NO               
                                            HT-PREMISE-NO.              
           MOVE SPACES                   TO WS-FULL-NAME                
                                            WS-FIRST-NAME               
                                            WS-MIDDLE-NAME              
                                            WS-LAST-NAME                
                                            WS-HOUSE-NO                 
                                            WS-STREET-NAME              
A21422*                                     WS-STREET-LOCATION-1                
A21422*                                     WS-STREET-LOCATION-2.               
           PERFORM 7330-OPEN-CUST-NAME      THRU 7330-EXIT.             
           PERFORM 7340-FETCH-CUST-NAME     THRU 7340-EXIT.             
                                                                        
           IF WS-NAME-FORMAT = 'I'                                      
              MOVE SPACES TO WS-FULL-NAME                               
              STRING WS-FIRST-NAME  DELIMITED SPACE                     
                     ' '            DELIMITED SIZE                      
                     WS-MIDDLE-NAME DELIMITED SPACE                     
                     ' '            DELIMITED SIZE                      
                     WS-LAST-NAME   DELIMITED SPACE                     
                INTO WS-FULL-NAME                                       
           END-IF.                                                      
                                                                        
           PERFORM 7350-CLOSE-CUST-NAME     THRU 7350-EXIT.             
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2420-FORMAT-ADDR.                                              *        
      *     CALLS  7360-OPEN-PREM-ADDR                                 *        
      *            7370-FETCH-PREM-ADDR                                *        
      *            7380-CLOSE-PREM-ADDR                                *        
      *                                                                *        
      *     CALLED FROM 2330-SEND-MH-DATA                              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2420-FORMAT-ADDR.                                                
           MOVE '2420' TO ACTIVE-PARAGRAPH.                             
           MOVE ZEROES                   TO HT-ACCOUNT-NO               
                                            HT-CUSTOMER-NO.             
           MOVE SPACES                   TO WS-FULL-NAME                
                                            WS-FIRST-NAME               
                                            WS-MIDDLE-NAME              
                                            WS-LAST-NAME                
                                            WS-HOUSE-NO                 
                                            WS-STREET-NAME              
A21422                                      WS-STREET-LOCATION-1        
A21422                                      WS-STREET-LOCATION-2.       
           PERFORM 7360-OPEN-PREM-ADDR      THRU 7360-EXIT.             
           PERFORM 7370-FETCH-PREM-ADDR     THRU 7370-EXIT.             
           PERFORM 7380-CLOSE-PREM-ADDR     THRU 7380-EXIT.             
                                                                        
       2420-EXIT.                                                       
           EXIT.                                                        
                                                                        
A21427******************************************************************        
A21427* 2430-FORMAT-EMPLOYEE-NAME.                                     *        
A21427*                                                                *        
A21427*     CALLED FROM                                                *        
A21427*                                                                *        
A21427******************************************************************        
A21427                                                                  
A21427 2430-FORMAT-EMPLOYEE-NAME.                                       
A21427     MOVE '2430' TO ACTIVE-PARAGRAPH.                             
A21427     MOVE SPACES                   TO PF-FIRST-NAME               
A21427                                      PF-MIDDLE-NAME              
A21427                                      PF-LAST-NAME.               
A21427     PERFORM 7660-GET-EMPLOYEE-NAME   THRU 7660-EXIT.             
A21427                                                                  
A21427     MOVE SPACES TO WS-EMPLOYEE-NAME                              
A21427     STRING PF-LAST-NAME   DELIMITED SPACE                        
A21427            ', '            DELIMITED SIZE                        
A21427            PF-FIRST-NAME  DELIMITED SPACE                        
A21427            ' '            DELIMITED SIZE                         
A21427            PF-MIDDLE-NAME DELIMITED SPACE                        
A21427          INTO WS-EMPLOYEE-NAME.                                  
A21427                                                                  
A21427 2430-EXIT.                                                       
A21427     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-AR-ACCOUNT                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7000-OPEN-AR-ACCOUNT.                                            
                                                                        
           MOVE '7000'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN AR-ACCOUNT-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST '       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-OPEN-AR-USER-ID                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7010-OPEN-AR-USER-ID.                                            
                                                                        
           MOVE '7010'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN AR-USER-ID-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST '       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-USER-ID                 TO HOSTVAR-ELEMENT-2      
              MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-OPEN-AR-RESP-AREA                                         *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7020-OPEN-AR-RESP-AREA.                                          
                                                                        
           MOVE '7020'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN AR-RESP-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST '       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-2        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-RESP-AREA-ID            TO HOSTVAR-ELEMENT-2      
              MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030-OPEN-MH-ACCOUNT                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7030-OPEN-MH-ACCOUNT.                                            
                                                                        
           MOVE '7030'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN MH-ACCOUNT-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7040-OPEN-MH-CUSTOMER                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7040-OPEN-MH-CUSTOMER.                                           
                                                                        
           MOVE '7040'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN MH-CUSTOMER-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
CBSI          MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-OPEN-MH-PREMISE                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7050-OPEN-MH-PREMISE.                                            
                                                                        
           MOVE '7050'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN MH-PREMISE-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7060-OPEN-MH-USER-ID                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7060-OPEN-MH-USER-ID.                                            
                                                                        
           MOVE '7060'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN MH-USER-ID-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-USER-ID                 TO HOSTVAR-ELEMENT-2      
              MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7070-OPEN-MH-USER-ID                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7070-OPEN-MH-RESP-AREA.                                          
                                                                        
           MOVE '7070'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN MH-RESP-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-2        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-RESP-AREA-ID            TO HOSTVAR-ELEMENT-2      
              MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-AR-ACCOUNT                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2310-PROCESS-AR-MH-DATA                        *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       7100-FETCH-AR-ACCOUNT.                                           
                                                                        
           MOVE '7100'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH AR-ACCOUNT-CURSOR                                   
              INTO  :AR-ACCOUNT-NO,                                     
                    :AR-TRANS-HIST-SEQ-NO,                              
                    :AR-DATE-TRANS,                                     
                    :AR-CODE-TRAN-TYPE,                                 
                    :AR-AMT-ORIG-ENTERED,                               
                    :AR-AMT-BILLED-UNPAID,                              
                    :AR-RESP-AREA-ID,                                   
                    :AR-APPL-PROGRAM-ID,                                
                    :AR-PYMT-FACILITY-CD,                               
                    :AR-USER-ID,                                        
                    :AR-COMPANY-NO,                                     
                    :AR-TRAN-COMMENT,                                   
                    :AR-RECORD-ONLY-FL,                                 
                    :AR-DATE-ORIG-PYMT :WS-DOP-NI,                       
P0282               :AR-CASH-COMPANY-NO,                                
P0282               :AR-CASH-LOCAL-OFFICE,                              
P0282               :AR-CASH-REPORT-NO,                                 
P0282               :AR-DATE-CASH-REPORT,                               
P0282               :AR-CASH-DRAWER-ID,                                 
P0282               :AR-PYMT-RCPT-PRNTD-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE AR-DATE-TRANS        TO WS-DATE-COMP-AR        
               WHEN NOT-FOUND                                           
                    MOVE WS-LOW-DATE          TO WS-DATE-COMP-AR        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
CBSI                MOVE SPACES               TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
                    MOVE 'CSS_AR_TRANS_HIST ' TO TABLE-1                
                    MOVE 'NAVIG_PATH'         TO TABLE-ELEMENT-1        
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2        
CBSI                MOVE 'CODE_TRAN_TYPE'     TO TABLE-ELEMENT-3        
                    MOVE WS-NAVIG-PATH        TO HOSTVAR-ELEMENT-1      
                    MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2      
CBSI                MOVE WS-CODE-TRAN-TYPE    TO HOSTVAR-ELEMENT-3      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-FETCH-AR-USER-ID                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2310-PROCESS-AR-MH-DATA                        *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       7110-FETCH-AR-USER-ID.                                           
                                                                        
           MOVE '7110'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH AR-USER-ID-CURSOR                                   
              INTO  :AR-ACCOUNT-NO,                                     
                    :AR-TRANS-HIST-SEQ-NO,                              
                    :AR-DATE-TRANS,                                     
                    :AR-CODE-TRAN-TYPE,                                 
                    :AR-AMT-ORIG-ENTERED,                               
                    :AR-AMT-BILLED-UNPAID,                              
                    :AR-RESP-AREA-ID,                                   
                    :AR-APPL-PROGRAM-ID,                                
                    :AR-PYMT-FACILITY-CD,                               
                    :AR-USER-ID,                                        
                    :AR-COMPANY-NO,                                     
                    :AR-TRAN-COMMENT,                                   
                    :AR-RECORD-ONLY-FL,                                 
                    :AR-DATE-ORIG-PYMT :WS-DOP-NI,                       
P0282               :AR-CASH-COMPANY-NO,                                
P0282               :AR-CASH-LOCAL-OFFICE,                              
P0282               :AR-CASH-REPORT-NO,                                 
P0282               :AR-DATE-CASH-REPORT,                               
P0282               :AR-CASH-DRAWER-ID,                                 
P0282               :AR-PYMT-RCPT-PRNTD-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE AR-DATE-TRANS        TO WS-DATE-COMP-AR        
               WHEN NOT-FOUND                                           
                    MOVE WS-LOW-DATE          TO WS-DATE-COMP-AR        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
CBSI                MOVE SPACES               TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
                    MOVE 'CSS_AR_TRANS_HIST ' TO TABLE-1                
                    MOVE 'NAVIG_PATH'         TO TABLE-ELEMENT-1        
                    MOVE 'USER_ID'            TO TABLE-ELEMENT-2        
                    MOVE 'CODE_TRAN_TYPE'     TO TABLE-ELEMENT-3        
                    MOVE WS-NAVIG-PATH        TO HOSTVAR-ELEMENT-1      
                    MOVE WS-USER-ID           TO HOSTVAR-ELEMENT-2      
                    MOVE WS-CODE-TRAN-TYPE    TO HOSTVAR-ELEMENT-3      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7120-FETCH-AR-RESP-AREA                                        *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2310-PROCESS-AR-MH-DATA                        *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       7120-FETCH-AR-RESP-AREA.                                         
                                                                        
           MOVE '7120'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH AR-RESP-CURSOR                                      
              INTO  :AR-ACCOUNT-NO,                                     
                    :AR-TRANS-HIST-SEQ-NO,                              
                    :AR-DATE-TRANS,                                     
                    :AR-CODE-TRAN-TYPE,                                 
                    :AR-AMT-ORIG-ENTERED,                               
                    :AR-AMT-BILLED-UNPAID,                              
                    :AR-RESP-AREA-ID,                                   
                    :AR-APPL-PROGRAM-ID,                                
                    :AR-PYMT-FACILITY-CD,                               
                    :AR-USER-ID,                                        
                    :AR-COMPANY-NO,                                     
                    :AR-TRAN-COMMENT,                                   
                    :AR-RECORD-ONLY-FL,                                 
                    :AR-DATE-ORIG-PYMT :WS-DOP-NI,                       
P0282               :AR-CASH-COMPANY-NO,                                
P0282               :AR-CASH-LOCAL-OFFICE,                              
P0282               :AR-CASH-REPORT-NO,                                 
P0282               :AR-DATE-CASH-REPORT,                               
P0282               :AR-CASH-DRAWER-ID,                                 
P0282               :AR-PYMT-RCPT-PRNTD-CD                              
P0282      END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE AR-DATE-TRANS        TO WS-DATE-COMP-AR        
               WHEN NOT-FOUND                                           
                    MOVE WS-LOW-DATE          TO WS-DATE-COMP-AR        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
CBSI                MOVE SPACES               TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
                    MOVE 'CSS_AR_TRANS_HIST ' TO TABLE-1                
                    MOVE 'NAVIG_PATH'         TO TABLE-ELEMENT-1        
                    MOVE 'RESP_AREA_ID'       TO TABLE-ELEMENT-2        
                    MOVE 'CODE_TRAN_TYPE'     TO TABLE-ELEMENT-3        
                    MOVE WS-NAVIG-PATH        TO HOSTVAR-ELEMENT-1      
                    MOVE WS-RESP-AREA-ID      TO HOSTVAR-ELEMENT-2      
                    MOVE WS-CODE-TRAN-TYPE    TO HOSTVAR-ELEMENT-3      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7130-FETCH-MH-ACCOUNT                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2310-PROCESS-AR-MH-DATA                        *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       7130-FETCH-MH-ACCOUNT.                                           
                                                                        
           MOVE '7130'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH MH-ACCOUNT-CURSOR                                   
              INTO  :MH-TRANS-HIST-SEQ-NO,                              
                    :MH-DATE-TRANS,                                     
                    :MH-CODE-TRAN-TYPE,                                 
                    :MH-RESP-AREA-ID,                                   
                    :MH-ACCOUNT-NO,                                     
                    :MH-CUSTOMER-NO,                                    
                    :MH-PREMISE-NO,                                     
                    :MH-USER-ID,                                        
                    :MH-APPL-PROGRAM-ID,                                
                    :MH-TRAN-COMMENT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE MH-DATE-TRANS        TO WS-DATE-COMP-MH        
               WHEN NOT-FOUND                                           
                    MOVE WS-LOW-DATE          TO WS-DATE-COMP-MH        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
CBSI                MOVE SPACES               TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
                    MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                
                    MOVE 'NAVIG_PATH'         TO TABLE-ELEMENT-1        
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2        
CBSI                MOVE 'CODE_TRAN_TYPE'     TO TABLE-ELEMENT-3        
                    MOVE WS-NAVIG-PATH        TO HOSTVAR-ELEMENT-1      
                    MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2      
CBSI                MOVE WS-CODE-TRAN-TYPE    TO HOSTVAR-ELEMENT-3      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7140-FETCH-MH-CUSTOMER                                         *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2310-PROCESS-AR-MH-DATA                        *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       7140-FETCH-MH-CUSTOMER.                                          
                                                                        
           MOVE '7140'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH MH-CUSTOMER-CURSOR                                  
              INTO  :MH-TRANS-HIST-SEQ-NO,                              
                    :MH-DATE-TRANS,                                     
                    :MH-CODE-TRAN-TYPE,                                 
                    :MH-RESP-AREA-ID,                                   
                    :MH-ACCOUNT-NO,                                     
                    :MH-CUSTOMER-NO,                                    
                    :MH-PREMISE-NO,                                     
                    :MH-USER-ID,                                        
                    :MH-APPL-PROGRAM-ID,                                
                    :MH-TRAN-COMMENT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE MH-DATE-TRANS        TO WS-DATE-COMP-MH        
               WHEN NOT-FOUND                                           
                    MOVE WS-LOW-DATE          TO WS-DATE-COMP-MH        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
CBSI                MOVE SPACES               TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
                    MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                
                    MOVE 'NAVIG_PATH'         TO TABLE-ELEMENT-1        
                    MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2        
CBSI                MOVE 'CODE_TRAN_TYPE'     TO TABLE-ELEMENT-3        
                    MOVE WS-NAVIG-PATH        TO HOSTVAR-ELEMENT-1      
                    MOVE WS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2      
CBSI                MOVE WS-CODE-TRAN-TYPE    TO HOSTVAR-ELEMENT-3      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-FETCH-MH-PREMISE                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2310-PROCESS-AR-MH-DATA                        *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       7150-FETCH-MH-PREMISE.                                           
                                                                        
           MOVE '7150'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH MH-PREMISE-CURSOR                                   
              INTO  :MH-TRANS-HIST-SEQ-NO,                              
                    :MH-DATE-TRANS,                                     
                    :MH-CODE-TRAN-TYPE,                                 
                    :MH-RESP-AREA-ID,                                   
                    :MH-ACCOUNT-NO,                                     
                    :MH-CUSTOMER-NO,                                    
                    :MH-PREMISE-NO,                                     
                    :MH-USER-ID,                                        
                    :MH-APPL-PROGRAM-ID,                                
                    :MH-TRAN-COMMENT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE MH-DATE-TRANS        TO WS-DATE-COMP-MH        
               WHEN NOT-FOUND                                           
                    MOVE WS-LOW-DATE          TO WS-DATE-COMP-MH        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
CBSI                MOVE SPACES               TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
                    MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                
                    MOVE 'NAVIG_PATH'         TO TABLE-ELEMENT-1        
                    MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-2        
CBSI                MOVE 'CODE_TRAN_TYPE'     TO TABLE-ELEMENT-3        
                    MOVE WS-NAVIG-PATH        TO HOSTVAR-ELEMENT-1      
                    MOVE WS-PREMISE-NO        TO HOSTVAR-ELEMENT-2      
CBSI                MOVE WS-CODE-TRAN-TYPE    TO HOSTVAR-ELEMENT-3      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7160-FETCH-MH-USER-ID                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2310-PROCESS-AR-MH-DATA                        *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       7160-FETCH-MH-USER-ID.                                           
                                                                        
           MOVE '7160'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH MH-USER-ID-CURSOR                                   
              INTO  :MH-TRANS-HIST-SEQ-NO,                              
                    :MH-DATE-TRANS,                                     
                    :MH-CODE-TRAN-TYPE,                                 
                    :MH-RESP-AREA-ID,                                   
                    :MH-ACCOUNT-NO,                                     
                    :MH-CUSTOMER-NO,                                    
                    :MH-PREMISE-NO,                                     
                    :MH-USER-ID,                                        
                    :MH-APPL-PROGRAM-ID,                                
                    :MH-TRAN-COMMENT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE MH-DATE-TRANS        TO WS-DATE-COMP-MH        
               WHEN NOT-FOUND                                           
                    MOVE WS-LOW-DATE          TO WS-DATE-COMP-MH        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
CBSI                MOVE SPACES               TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
                    MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                
                    MOVE 'NAVIG_PATH'         TO TABLE-ELEMENT-1        
                    MOVE 'USER_ID'            TO TABLE-ELEMENT-2        
                    MOVE 'CODE_TRAN_TYPE'     TO TABLE-ELEMENT-3        
                    MOVE WS-NAVIG-PATH        TO HOSTVAR-ELEMENT-1      
                    MOVE WS-USER-ID           TO HOSTVAR-ELEMENT-2      
                    MOVE WS-CODE-TRAN-TYPE    TO HOSTVAR-ELEMENT-3      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7170-FETCH-MH-RESP-AREA                                        *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2310-PROCESS-AR-MH-DATA                        *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       7170-FETCH-MH-RESP-AREA.                                         
                                                                        
           MOVE '7170'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH MH-RESP-CURSOR                                      
              INTO  :MH-TRANS-HIST-SEQ-NO,                              
                    :MH-DATE-TRANS,                                     
                    :MH-CODE-TRAN-TYPE,                                 
                    :MH-RESP-AREA-ID,                                   
                    :MH-ACCOUNT-NO,                                     
                    :MH-CUSTOMER-NO,                                    
                    :MH-PREMISE-NO,                                     
                    :MH-USER-ID,                                        
                    :MH-APPL-PROGRAM-ID,                                
                    :MH-TRAN-COMMENT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE MH-DATE-TRANS        TO WS-DATE-COMP-MH        
               WHEN NOT-FOUND                                           
                    MOVE WS-LOW-DATE          TO WS-DATE-COMP-MH        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
CBSI                MOVE SPACES               TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
                    MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                
                    MOVE 'NAVIG_PATH'         TO TABLE-ELEMENT-1        
                    MOVE 'RESP_AREA_ID'       TO TABLE-ELEMENT-2        
                    MOVE 'CODE_TRAN_TYPE'     TO TABLE-ELEMENT-3        
                    MOVE WS-NAVIG-PATH        TO HOSTVAR-ELEMENT-1      
                    MOVE WS-RESP-AREA-ID      TO HOSTVAR-ELEMENT-2      
                    MOVE WS-CODE-TRAN-TYPE    TO HOSTVAR-ELEMENT-3      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-CLOSE-AR-ACCOUNT                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       7200-CLOSE-AR-ACCOUNT.                                           
                                                                        
           MOVE '7200'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE AR-ACCOUNT-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST '       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7210-CLOSE-AR-USER-ID                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       7210-CLOSE-AR-USER-ID.                                           
                                                                        
           MOVE '7210'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE AR-USER-ID-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST '       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-USER-ID                 TO HOSTVAR-ELEMENT-2      
              MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7220-CLOSE-AR-RESP-AREA                                        *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       7220-CLOSE-AR-RESP-AREA.                                         
                                                                        
           MOVE '7220'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE AR-RESP-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_AR_TRANS_HIST '       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-2        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-RESP-AREA-ID            TO HOSTVAR-ELEMENT-2      
              MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7230-CLOSE-MH-ACCOUNT                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       7230-CLOSE-MH-ACCOUNT.                                           
                                                                        
           MOVE '7230'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE MH-ACCOUNT-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7240-CLOSE-MH-CUSTOMER                                         *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       7240-CLOSE-MH-CUSTOMER.                                          
                                                                        
           MOVE '7240'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE MH-CUSTOMER-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
CBSI          MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7250-CLOSE-MH-PREMISE                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       7250-CLOSE-MH-PREMISE.                                           
                                                                        
           MOVE '7250'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE MH-PREMISE-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7260-CLOSE-MH-USER-ID                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       7260-CLOSE-MH-USER-ID.                                           
                                                                        
           MOVE '7260'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE MH-USER-ID-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-2        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-USER-ID                 TO HOSTVAR-ELEMENT-2      
              MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7270-CLOSE-MH-RESP-AREA                                        *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       7270-CLOSE-MH-RESP-AREA.                                         
                                                                        
           MOVE '7270'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE MH-RESP-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_MNT_TRANS_HIST'       TO TABLE-1                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'RESP_AREA_ID'             TO TABLE-ELEMENT-2        
              MOVE 'CODE_TRAN_TYPE'           TO TABLE-ELEMENT-3        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-RESP-AREA-ID            TO HOSTVAR-ELEMENT-2      
              MOVE WS-CODE-TRAN-TYPE          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7320-SELECT-NAME-ADDR                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2400-FORMAT-NAME-ADDR                          *        
      *                                                                *        
      *     FETCHES THE CUSTOMER NAME OF THE TRANS. HIST. SUMMARY ROW  *        
      ******************************************************************        
                                                                        
       7320-SELECT-NAME-ADDR.                                           
                                                                        
           MOVE '7320' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT   DQ.NAME_ID,                                      
                       DQ.NAME_FORMAT,                                  
                       DQ.NAME_TYPE,                                    
                       DQ.FULL_NAME,                                    
                       DQ.FIRST_NAME,                                   
                       DQ.MIDDLE_NAME,                                  
                       DQ.LAST_NAME,                                    
                       DY.ADDRESS_ID,                                   
                       DY.HOUSE_NO,                                     
                       DY.STREET_NAME,                                  
                       DY.STREET_LOCATION_1,                            
                       DY.STREET_LOCATION_2                             
              INTO     :WS-NAME-ID,                                     
                       :WS-NAME-FORMAT,                                 
                       :WS-NAME-TYPE,                                   
                       :WS-FULL-NAME,                                   
                       :WS-FIRST-NAME,                                  
                       :WS-MIDDLE-NAME,                                 
                       :WS-LAST-NAME,                                   
                       :WS-ADDRESS-ID,                                  
                       :WS-HOUSE-NO,                                    
                       :WS-STREET-NAME,                                 
A21422                 :WS-STREET-LOCATION-1,                           
A21422                 :WS-STREET-LOCATION-2                            
              FROM     CSS_NAME           DQ WITH(READUNCOMMITTED),             
                       CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),             
                       CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
              WHERE    HT.ACCOUNT_NO    = :HT-ACCOUNT-NO                
              AND      HT.NAME_ID       = DQ.NAME_ID                    
              AND      DQ.NAME_TYPE     = 'CN'                          
              AND      HT.ADDRESS_ID    = DY.ADDRESS_ID                 
              AND      HT.CUSTOMER_ROLE_CD = ' '                        
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT   DQ.NAME_ID,                                              
MFA-TR*                DQ.NAME_FORMAT,                                          
MFA-TR*                DQ.NAME_TYPE,                                            
MFA-TR*                DQ.FULL_NAME,                                            
MFA-TR*                DQ.FIRST_NAME,                                           
MFA-TR*                DQ.MIDDLE_NAME,                                          
MFA-TR*                DQ.LAST_NAME,                                            
MFA-TR*                DY.ADDRESS_ID,                                           
MFA-TR*                DY.HOUSE_NO,                                             
MFA-TR*                DY.STREET_NAME,                                          
MFA-TR*                DY.STREET_LOCATION_1,                                    
MFA-TR*                DY.STREET_LOCATION_2                                     
MFA-TR*       INTO     :WS-NAME-ID,                                             
MFA-TR*                :WS-NAME-FORMAT,                                         
MFA-TR*                :WS-NAME-TYPE,                                           
MFA-TR*                :WS-FULL-NAME,                                           
MFA-TR*                :WS-FIRST-NAME,                                          
MFA-TR*                :WS-MIDDLE-NAME,                                         
MFA-TR*                :WS-LAST-NAME,                                           
MFA-TR*                :WS-ADDRESS-ID,                                          
MFA-TR*                :WS-HOUSE-NO,                                            
MFA-TR*                :WS-STREET-NAME,                                         
MFA-TR*                :WS-STREET-LOCATION-1,                                   
MFA-TR*                :WS-STREET-LOCATION-2                                    
MFA-TR*       FROM     CSS_NAME           DQ,                                   
MFA-TR*                CSS_ADDR_FORMATTED DY,                                   
MFA-TR*                CSS_NAME_ACCT_XREF HT                                    
MFA-TR*       WHERE    HT.ACCOUNT_NO    = :HT-ACCOUNT-NO                        
MFA-TR*       AND      HT.NAME_ID       = DQ.NAME_ID                            
MFA-TR*       AND      DQ.NAME_TYPE     = 'CN'                                  
MFA-TR*       AND      HT.ADDRESS_ID    = DY.ADDRESS_ID                         
MFA-TR*       AND      HT.CUSTOMER_ROLE_CD = ' '                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_NAME'                 TO TABLE-1                
              MOVE 'CSS_ADDR_FORMATTED'       TO TABLE-2                
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-3                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE HT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7330-OPEN-CUST-NAME                                            *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2410-FORMAT-NAME                               *        
      *                                                                *        
      *     FETCHES THE CUSTOMER NAME OF THE TRANS. HIST. SUMMARY ROW  *        
      ******************************************************************        
                                                                        
       7330-OPEN-CUST-NAME.                                             
                                                                        
           MOVE '7330'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN CUST-NAME-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_NAME'                 TO TABLE-1                
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-2                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7340-FETCH-CUST-NAME                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2410-FORMAT-NAME                               *        
      ******************************************************************        
                                                                        
       7340-FETCH-CUST-NAME.                                            
                                                                        
           MOVE '7340'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH CUST-NAME-CURSOR                                    
              INTO     :WS-NAME-ID,                                     
                       :WS-NAME-FORMAT,                                 
                       :WS-NAME-TYPE,                                   
                       :WS-FULL-NAME,                                   
                       :WS-FIRST-NAME,                                  
                       :WS-MIDDLE-NAME,                                 
                       :WS-LAST-NAME                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
CBSI                MOVE SPACES               TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
                    MOVE 'CSS_NAME'           TO TABLE-1                
                    MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                
                    MOVE 'NAVIG_PATH'         TO TABLE-ELEMENT-1        
                    MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2        
                    MOVE WS-NAVIG-PATH        TO HOSTVAR-ELEMENT-1      
                    MOVE WS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       7340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7350-CLOSE-CUST-NAME                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2410-FORMAT-NAME                               *        
      *                                                                *        
      *     FETCHES THE CUSTOMER NAME OF THE TRANS. HIST. SUMMARY ROW  *        
      ******************************************************************        
                                                                        
       7350-CLOSE-CUST-NAME.                                            
                                                                        
           MOVE '7350'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE CUST-NAME-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_NAME'                 TO TABLE-1                
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-2                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7360-OPEN-PREM-ADDR                                            *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2420-FORMAT-ADDR                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7360-OPEN-PREM-ADDR.                                             
                                                                        
           MOVE '7360'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN PREM-ADDR-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ADDR_FORMATTED'       TO TABLE-1                
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-2                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7370-FETCH-PREM-ADDR                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2420-FORMAT-ADDR                               *        
      ******************************************************************        
                                                                        
       7370-FETCH-PREM-ADDR.                                            
                                                                        
           MOVE '7370'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
              FETCH PREM-ADDR-CURSOR                                    
              INTO     :WS-ADDRESS-ID,                                  
                       :WS-HOUSE-NO,                                    
                       :WS-STREET-NAME,                                 
A21422                 :WS-STREET-LOCATION-1,                           
A21422                 :WS-STREET-LOCATION-2                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
CBSI                MOVE SPACES               TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
                    MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                
                    MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                
                    MOVE 'NAVIG_PATH'         TO TABLE-ELEMENT-1        
                    MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-2        
                    MOVE WS-NAVIG-PATH        TO HOSTVAR-ELEMENT-1      
                    MOVE WS-PREMISE-NO        TO HOSTVAR-ELEMENT-2      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       7370-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7380-CLOSE-PREM-ADDR                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2420-FORMAT-ADDR                               *        
      ******************************************************************        
                                                                        
       7380-CLOSE-PREM-ADDR.                                            
                                                                        
           MOVE '7380'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE PREM-ADDR-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_ADDR_FORMATTED'       TO TABLE-1                
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-2                
              MOVE 'NAVIG_PATH'               TO TABLE-ELEMENT-1        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2        
              MOVE WS-NAVIG-PATH              TO HOSTVAR-ELEMENT-1      
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7380-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      *                                                             *           
PC451 * 7400-SELECT-PAY-OFC-DESC                                    *           
      *                                                             *           
PC451 *    SELECT THE LOCAL OFFICE DESC FROM CSS_CASHIER_OFFICE     *           
      *                                                             *           
      ***************************************************************           
PC451  7400-SELECT-PAY-OFC-DESC.                                        
                                                                        
           MOVE '7400'                TO ACTIVE-PARAGRAPH.              
                                                                        
           EXEC SQL                                                     
PC451         SELECT  CASH_LOC_OFF_DESC                                 
C20723          INTO  :Y2-CASH-LOC-OFF-DESC                             
C02723        FROM    CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                  
C35842        WHERE   CASH_COMPANY_NO   = '01'                          
C20723          AND   CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE         
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  CASH_LOC_OFF_DESC                                         
MFA-TR*         INTO  :Y2-CASH-LOC-OFF-DESC                                     
MFA-TR*       FROM    CSS_CASHIER_OFFICE                                        
MFA-TR*       WHERE   CASH_COMPANY_NO   = '01'                                  
MFA-TR*         AND   CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T5393 *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
T5393      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
C20723        MOVE 'CSS_CASHIER_OFFICE'       TO TABLE-1                
PC451         MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
C20723        MOVE Y2-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-ACCOUNT-NO-NUM          TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      *                                                             *           
      * 7450-SELECT-BC                                              *           
      *                                                             *           
      *    SELECT CODE BATCH STATUS FROM CSS_BCH_JRNL_CNTL          *           
      *                                                             *           
      ***************************************************************           
P0282  7450-SELECT-BC.                                                  
P0282                                                                   
P0282      MOVE '7450'                 TO ACTIVE-PARAGRAPH.             
                                                                        
P0282      EXEC SQL                                                     
P0282         SELECT CODE_BATCH_STATUS                                  
P0282         INTO   :BC-CODE-BATCH-STATUS                              
P0282         FROM   CSS_BCH_JRNL_CNTL WITH(READUNCOMMITTED)                    
P0282         WHERE CASH_LOCAL_OFFICE = :BC-CASH-LOCAL-OFFICE           
MCR310         AND  CASH_COMPANY_NO = '01'                              
P0282          AND  LOCAL_OFFICE_ENTRY  = ' '                           
P0282          AND  CASH_REPORT_NO = :BC-CASH-REPORT-NO                 
P0282          AND  BATCH_NO  = ' '                                     
P0282          AND  DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )            
P0282          AND  CASH_DRAWER_ID   = :BC-CASH-DRAWER-ID               
C35842                                                           
P0282      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_BATCH_STATUS                                          
MFA-TR*       INTO   :BC-CODE-BATCH-STATUS                                      
MFA-TR*       FROM   CSS_BCH_JRNL_CNTL                                          
MFA-TR*       WHERE CASH_LOCAL_OFFICE = :BC-CASH-LOCAL-OFFICE                   
MFA-TR*        AND  CASH_COMPANY_NO = '01'                                      
MFA-TR*        AND  LOCAL_OFFICE_ENTRY  = ' '                                   
MFA-TR*        AND  CASH_REPORT_NO = :BC-CASH-REPORT-NO                         
MFA-TR*        AND  BATCH_NO  = ' '                                             
MFA-TR*        AND  DATE_CASH_REPORT  = :BC-DATE-CASH-REPORT                    
MFA-TR*        AND  CASH_DRAWER_ID   = :BC-CASH-DRAWER-ID                       
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0282      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
P0282      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0282         NEXT SENTENCE                                             
P0282      ELSE                                                         
P0282         MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P0282         MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
P0282         MOVE 'CSS_BCH_JRNL_CNTL'        TO TABLE-1                
P0282         MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1        
CBSI          MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-2        
CBSI          MOVE 'CASH_REPORT_NO'           TO TABLE-ELEMENT-3        
CBSI          MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4        
P0282         MOVE BC-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1      
CBSI          MOVE BC-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-2      
CBSI          MOVE BC-CASH-REPORT-NO          TO HOSTVAR-ELEMENT-3      
CBSI          MOVE BC-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4      
P0282         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P0282         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P0282      END-IF.                                                      
P0282  7450-EXIT.                                                       
P0282      EXIT.                                                        
      ***************************************************************           
      *                                                             *           
      * 7460-SELECT-CSH-DRWR                                        *           
      *                                                             *           
      *    SELECT CODE BATCH STATUS FROM CSS_CSH_DRWR_CNTL          *           
      *                                                             *           
      ***************************************************************           
PCR404 7460-SELECT-CSH-DRWR.                                            
PCR404                                                                  
PCR404     MOVE '7460'                 TO ACTIVE-PARAGRAPH.             
PCR404                                                                  
PCR404     EXEC SQL                                                     
PCR404        SELECT CODE_CSH_DRWR_STAT                                 
PCR404        INTO   :BC-CODE-BATCH-STATUS                              
PCR404        FROM   CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                    
PCR404        WHERE CASH_LOCAL_OFFICE = :BC-CASH-LOCAL-OFFICE           
MCR310         AND  CASH_COMPANY_NO   = '01'                            
PCR404         AND  CASH_REPORT_NO    = :BC-CASH-REPORT-NO              
PCR404         AND  DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )            
PCR404         AND  CASH_DRAWER_ID    = :BC-CASH-DRAWER-ID              
C35842                                                           
PCR404     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_CSH_DRWR_STAT                                         
MFA-TR*       INTO   :BC-CODE-BATCH-STATUS                                      
MFA-TR*       FROM   CSS_CSH_DRWR_CNTL                                          
MFA-TR*       WHERE CASH_LOCAL_OFFICE = :BC-CASH-LOCAL-OFFICE                   
MFA-TR*        AND  CASH_COMPANY_NO   = '01'                                    
MFA-TR*        AND  CASH_REPORT_NO    = :BC-CASH-REPORT-NO                      
MFA-TR*        AND  DATE_CASH_REPORT  = :BC-DATE-CASH-REPORT                    
MFA-TR*        AND  CASH_DRAWER_ID    = :BC-CASH-DRAWER-ID                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR404     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR404                                                                  
PCR404     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PCR404        NEXT SENTENCE                                             
PCR404     ELSE                                                         
PCR404        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
PCR404        MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
PCR404        MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1                
PCR404        MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1        
CBSI          MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-2        
CBSI          MOVE 'CASH_REPORT_NO'           TO TABLE-ELEMENT-3        
CBSI          MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4        
PCR404        MOVE BC-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1      
CBSI          MOVE BC-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-2      
CBSI          MOVE BC-CASH-REPORT-NO          TO HOSTVAR-ELEMENT-3      
CBSI          MOVE BC-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4      
PCR404        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
PCR404        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
PCR404     END-IF.                                                      
PCR404 7460-EXIT.                                                       
PCR404     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-GET-USA-DATE                                              *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     FORMATS THE DATE                                           *        
      ******************************************************************        
                                                                        
       7500-GET-USA-DATE.                                               
                                                                        
           MOVE '7500'              TO ACTIVE-PARAGRAPH.                
                                                                        
C35842     EXEC SQL                                                     
C35842        SELECT
              CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ),'USA')
            INTO
              :WS-DATE-HOLD-USA     
C35842     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-HOLD-USA = CHAR(DATE(:WS-DATE-HOLD),USA)             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
C35842        MOVE 'SET'               TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE 'WS-DATE-HOLD'      TO TABLE-ELEMENT-2               
CBSI          MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1             
CBSI          MOVE WS-DATE-HOLD        TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-GET-PROG-DESC.                                            *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     GETS THE PROGRAM DESCRIPTION                               *        
      ******************************************************************        
                                                                        
       7600-GET-PROG-DESC.                                              
                                                                        
           MOVE '7600'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              SELECT APPL_PROGRAM_DESC                                  
              INTO  :K9-APPL-PROGRAM-DESC                               
              FROM   CSS_APPL_PGM_DESC WITH(READUNCOMMITTED)                    
              WHERE APPL_PROGRAM_ID =  :K9-APPL-PROGRAM-ID              
C35842                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT APPL_PROGRAM_DESC                                          
MFA-TR*       INTO  :K9-APPL-PROGRAM-DESC                                       
MFA-TR*       FROM   CSS_APPL_PGM_DESC                                          
MFA-TR*       WHERE APPL_PROGRAM_ID =  :K9-APPL-PROGRAM-ID                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE 'SELECT'            TO ABEND-FUNCTION                
CBSI          MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI                                      ABEND-TABLES                  
              MOVE 'CSS_APPL_PGM_DESC' TO TABLE-1                       
CBSI          MOVE 'APPL_PROGRAM_ID'   TO TABLE-ELEMENT-1               
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2               
              MOVE K9-APPL-PROGRAM-ID  TO HOSTVAR-ELEMENT-1             
CBSI          MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
A21427******************************************************************        
A21427* 7650-GET-RESP-AREA-DESC.                                       *        
A21427*                                                                *        
A21427*     CALLS 9000-SEND-ERROR-RESULT                               *        
A21427*           9900-SQL-ERROR-ROUTINE                               *        
A21427*                                                                *        
A21427*     CALLED FROM 2200-BUILD-RESULT                              *        
A21427*                                                                *        
A21427*     GETS THE RESP AREA DESCRIPTION                             *        
A21427******************************************************************        
A21427                                                                  
A21427 7650-GET-RESP-AREA-DESC.                                         
A21427                                                                  
A21427     MOVE '7650'              TO ACTIVE-PARAGRAPH.                
A21427                                                                  
A21427     EXEC SQL                                                     
A21427        SELECT RESP_AREA_DESC                                     
A21427        INTO  :C1-RESP-AREA-DESC                                  
A21427        FROM   CSS_RESP_AREA WITH(READUNCOMMITTED)                        
A21427        WHERE RESP_AREA_ID = :C1-RESP-AREA-ID                     
A21427                                                           
A21427                                                      
A21427     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_DESC                                             
MFA-TR*       INTO  :C1-RESP-AREA-DESC                                          
MFA-TR*       FROM   CSS_RESP_AREA                                              
MFA-TR*       WHERE RESP_AREA_ID = :C1-RESP-AREA-ID                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7650                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A21427                                                                  
A21427     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A21427                                                                  
A21427     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A21427         NEXT SENTENCE                                            
A21427     ELSE                                                         
A21427        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A21427        MOVE 'SELECT'            TO ABEND-FUNCTION                
A21427        MOVE SPACES              TO ABEND-SQL-PREDICATES          
A21427                                    ABEND-TABLES                  
A21427        MOVE 'CSS_RESP_AREA'     TO TABLE-1                       
A21427        MOVE 'RESP_AREA_ID'      TO TABLE-ELEMENT-1               
A21427        MOVE C1-RESP-AREA-ID     TO HOSTVAR-ELEMENT-1             
A21427        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A21427        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A21427     END-IF.                                                      
A21427                                                                  
A21427 7650-EXIT.                                                       
A21427     EXIT.                                                        
                                                                        
A21427******************************************************************        
A21427* 7660-GET-EMPLOYEE-NAME.                                        *        
A21427*                                                                *        
A21427*     CALLS 9000-SEND-ERROR-RESULT                               *        
A21427*           9900-SQL-ERROR-ROUTINE                               *        
A21427*                                                                *        
A21427*     CALLED FROM 2200-BUILD-RESULT                              *        
A21427*                                                                *        
A21427*     GETS THE EMPLOYEE NAME                                     *        
A21427******************************************************************        
A21427                                                                  
A21427 7660-GET-EMPLOYEE-NAME.                                          
A21427                                                                  
A21427     MOVE '7660'              TO ACTIVE-PARAGRAPH.                
A21427                                                                  
A21427     EXEC SQL                                                     
A21427       SELECT LAST_NAME                                           
A21427             ,FIRST_NAME                                          
A21427             ,MIDDLE_NAME                                         
A21427       INTO   :PF-LAST-NAME                                       
A21427             ,:PF-FIRST-NAME                                      
A21427             ,:PF-MIDDLE-NAME                                     
A21427       FROM  CSS_USER_PROFILE WITH(READUNCOMMITTED)                       
A21427       WHERE USER_ID = :PF-USER-ID                                
A21427                                                           
A21427                                                      
A21427     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT LAST_NAME                                                   
MFA-TR*            ,FIRST_NAME                                                  
MFA-TR*            ,MIDDLE_NAME                                                 
MFA-TR*      INTO   :PF-LAST-NAME                                               
MFA-TR*            ,:PF-FIRST-NAME                                              
MFA-TR*            ,:PF-MIDDLE-NAME                                             
MFA-TR*      FROM  CSS_USER_PROFILE                                             
MFA-TR*      WHERE USER_ID = :PF-USER-ID                                        
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7660                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A21427                                                                  
A21427     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A21427                                                                  
A21427     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A21427         NEXT SENTENCE                                            
A21427     ELSE                                                         
A21427        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A21427        MOVE 'SELECT'            TO ABEND-FUNCTION                
A21427        MOVE SPACES              TO ABEND-SQL-PREDICATES          
A21427                                    ABEND-TABLES                  
A21427        MOVE 'CSS_USER_PROFILE'  TO TABLE-1                       
A21427        MOVE 'USER_ID'           TO TABLE-ELEMENT-1               
A21427        MOVE PF-USER-ID          TO HOSTVAR-ELEMENT-1             
A21427        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A21427        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A21427     END-IF.                                                      
A21427                                                                  
A21427 7660-EXIT.                                                       
A21427     EXIT.                                                        
                                                                        
A21427******************************************************************        
A21427* 7670-GET-TRAN-TYPE-DESC.                                       *        
A21427*                                                                *        
A21427*     CALLS 9000-SEND-ERROR-RESULT                               *        
A21427*           9900-SQL-ERROR-ROUTINE                               *        
A21427*                                                                *        
A21427*     CALLED FROM 2200-BUILD-RESULT                              *        
A21427*                                                                *        
A21427*     GETS THE TRANSACTION TYPE SHORT DESCRIPTION                *        
A21427******************************************************************        
A21427                                                                  
A21427 7670-GET-TRAN-SHORT-DESC.                                        
A21427                                                                  
A21427     MOVE '7670'              TO ACTIVE-PARAGRAPH.                
A21427                                                                  
A21427     EXEC SQL                                                     
A21427       SELECT TRAN_SHORT_DESC                                     
A21427       INTO   :BY-TRAN-SHORT-DESC                                 
A21427       FROM  CSS_TRAN_TYPE WITH(READUNCOMMITTED)                          
A21427       WHERE CODE_TRAN_TYPE = :BY-CODE-TRAN-TYPE                  
A21427                                                           
A21427                                                      
A21427     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT TRAN_SHORT_DESC                                             
MFA-TR*      INTO   :BY-TRAN-SHORT-DESC                                         
MFA-TR*      FROM  CSS_TRAN_TYPE                                                
MFA-TR*      WHERE CODE_TRAN_TYPE = :BY-CODE-TRAN-TYPE                          
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7670                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A21427                                                                  
A21427     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A21427                                                                  
A21427     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A21427         NEXT SENTENCE                                            
A21427     ELSE                                                         
A21427        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A21427        MOVE 'SELECT'            TO ABEND-FUNCTION                
A21427        MOVE SPACES              TO ABEND-SQL-PREDICATES          
A21427                                    ABEND-TABLES                  
A21427        MOVE 'CSS_TRAN_TYPE'     TO TABLE-1                       
A21427        MOVE 'CODE_TRAN_TYPE'    TO TABLE-ELEMENT-1               
A21427        MOVE BY-CODE-TRAN-TYPE   TO HOSTVAR-ELEMENT-1             
A21427        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A21427        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A21427     END-IF.                                                      
A21427                                                                  
A21427 7670-EXIT.                                                       
A21427     EXIT.                                                        
                                                                        
A21429******************************************************************        
A21429* 7700-GET-COMPANY-NO-ACCT.                                      *        
A21429*                                                                *        
A21429*     CALLS 9000-SEND-ERROR-RESULT                               *        
A21429*           9900-SQL-ERROR-ROUTINE                               *        
A21429*                                                                *        
A21429*     CALLED FROM 2200-BUILD-RESULT                              *        
A21429*                                                                *        
A21429*     GETS THE COMPANY NO FROM ACCOUNT TABLE                     *        
A21429******************************************************************        
A21429                                                                  
A21429 7700-GET-COMPANY-NO-ACCT.                                        
A21429                                                                  
A21429     MOVE '7700'              TO ACTIVE-PARAGRAPH.                
A21429                                                                  
A21429     EXEC SQL                                                     
A21429       SELECT COMPANY_NO                                          
A21429       INTO   :AT-COMPANY-NO                                      
A21429       FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                           
A21429       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                         
A21429                                                           
A21429                                                      
A21429     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NO                                                  
MFA-TR*      INTO   :AT-COMPANY-NO                                              
MFA-TR*      FROM   CSS_ACCOUNT                                                 
MFA-TR*      WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A21429                                                                  
A21429     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A21429                                                                  
A21429     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A21429         NEXT SENTENCE                                            
A21429     ELSE                                                         
A21429        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A21429        MOVE 'SELECT'            TO ABEND-FUNCTION                
A21429        MOVE SPACES              TO ABEND-SQL-PREDICATES          
A21429                                    ABEND-TABLES                  
A21429        MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
A21429        MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
A21429        MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
A21429        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A21429        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A21429     END-IF.                                                      
A21429                                                                  
A21429 7700-EXIT.                                                       
A21429     EXIT.                                                        
                                                                        
A21429******************************************************************        
A21429* 7710-GET-COMPANY-NO-CUST.                                      *        
A21429*                                                                *        
A21429*     CALLS 9000-SEND-ERROR-RESULT                               *        
A21429*           9900-SQL-ERROR-ROUTINE                               *        
A21429*                                                                *        
A21429*     CALLED FROM 2200-BUILD-RESULT                              *        
A21429*                                                                *        
A21429*     GETS THE COMPANY NO FROM CUSTOMER TABLE                    *        
A21429******************************************************************        
A21429                                                                  
A21429 7710-GET-COMPANY-NO-CUST.                                        
A21429                                                                  
A21429     MOVE '7710'              TO ACTIVE-PARAGRAPH.                
A21429                                                                  
A21429     EXEC SQL                                                     
A21429       SELECT COMPANY_NO_ORIG                                     
A21429       INTO   :CU-COMPANY-NO-ORIG                                 
A21429       FROM   CSS_CUSTOMER WITH(READUNCOMMITTED)                          
A21429       WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                       
A21429                                                           
A21429                                                      
A21429     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NO_ORIG                                             
MFA-TR*      INTO   :CU-COMPANY-NO-ORIG                                         
MFA-TR*      FROM   CSS_CUSTOMER                                                
MFA-TR*      WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                               
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7710                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A21429                                                                  
A21429     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A21429                                                                  
A21429     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A21429         NEXT SENTENCE                                            
A21429     ELSE                                                         
A21429        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A21429        MOVE 'SELECT'            TO ABEND-FUNCTION                
A21429        MOVE SPACES              TO ABEND-SQL-PREDICATES          
A21429                                    ABEND-TABLES                  
A21429        MOVE 'CSS_CUSTOMER'      TO TABLE-1                       
A21429        MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
A21429        MOVE CU-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1             
A21429        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A21429        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A21429     END-IF.                                                      
A21429                                                                  
A21429 7710-EXIT.                                                       
A21429     EXIT.                                                        
                                                                        
A21429******************************************************************        
A21429* 7720-GET-COMPANY-NO-ACCT.                                      *        
A21429*                                                                *        
A21429*     CALLS 9000-SEND-ERROR-RESULT                               *        
A21429*           9900-SQL-ERROR-ROUTINE                               *        
A21429*                                                                *        
A21429*     CALLED FROM 2200-BUILD-RESULT                              *        
A21429*                                                                *        
A21429*     GETS THE COMPANY NO FROM ACCOUNT TABLE                     *        
A21429******************************************************************        
A21429                                                                  
A21429 7720-GET-COMPANY-NO-PREM.                                        
A21429                                                                  
A21429     MOVE '7720'              TO ACTIVE-PARAGRAPH.                
A21429                                                                  
A21429     EXEC SQL                                                     
A21429       SELECT COMPANY_NO                                          
A21429       INTO   :PR-COMPANY-NO                                      
A21429       FROM   CSS_PREMISE WITH(READUNCOMMITTED)                           
A21429       WHERE  PREMISE_NO = :PR-PREMISE-NO                         
A21429                                                           
A21429                                                      
A21429     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NO                                                  
MFA-TR*      INTO   :PR-COMPANY-NO                                              
MFA-TR*      FROM   CSS_PREMISE                                                 
MFA-TR*      WHERE  PREMISE_NO = :PR-PREMISE-NO                                 
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7720                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A21429                                                                  
A21429     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A21429                                                                  
A21429     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A21429         NEXT SENTENCE                                            
A21429     ELSE                                                         
A21429        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A21429        MOVE 'SELECT'            TO ABEND-FUNCTION                
A21429        MOVE SPACES              TO ABEND-SQL-PREDICATES          
A21429                                    ABEND-TABLES                  
A21429        MOVE 'CSS_PREMISE'       TO TABLE-1                       
A21429        MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
A21429        MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1             
A21429        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A21429        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A21429     END-IF.                                                      
A21429                                                                  
A21429 7720-EXIT.                                                       
A21429     EXIT.                                                        
                                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS                                           *        
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          DELETE FROM #CSR02016_R1                         
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR02016_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH         NEXT SENTENCE                                            
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
REARCH        MOVE SQLCODE               TO ABEND-SQLCODE               
REARCH        MOVE '8000A'               TO ACTIVE-PARAGRAPH            
REARCH        MOVE 'DELETE'              TO ABEND-FUNCTION              
REARCH        MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH        MOVE 'CSR02016_R1'         TO TABLE-1                     
REARCH        MOVE SPACES                TO TABLE-ELEMENT-1             
REARCH        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
REARCH        PERFORM 9000-SEND-ERROR-RESULT                            
REARCH                                   THRU 9000-EXIT                 
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE                            
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*8100-SEND-RESULT                                                *        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02016_R1                         
REARCH          (                                                       
REARCH                                                                  
REARCH               RETURN_CODE                                        
REARCH              ,ACCOUNT_NO                                         
REARCH              ,TRANS_HIST_SEQ_NO                                  
REARCH              ,DATE_TRANS                                         
REARCH              ,CODE_TRAN_TYPE                                     
A21427              ,TRAN_SHORT_DESC                                    
REARCH              ,AMT_ORIG_ENTERED                                   
REARCH              ,AMT_BILLED_UNPAID                                  
REARCH              ,RESP_AREA_ID                                       
A21427              ,RESP_AREA_DESC                                     
REARCH              ,APPL_PROGRAM_ID                                    
REARCH              ,APPL_PROGRAM_DESC                                  
REARCH              ,PYMT_FACILITY_CD                                   
REARCH              ,USER_ID                                            
A21427              ,EMPLOYEE_NAME                                      
REARCH              ,COMPANY_NO                                         
REARCH              ,TRAN_COMMENT_TEXT                                  
REARCH              ,RECORD_ONLY_FL                                     
REARCH              ,DATE_ORIG_PYMT                                     
REARCH              ,CASH_LOCAL_OFFICE                                  
REARCH              ,CASH_DRAWER_ID                                     
REARCH              ,DATE_CASH_REPORT                                   
REARCH              ,CODE_BATCH_STATUS                                  
REARCH              ,PYMT_RCPT_PRNTD_CD                                 
REARCH              ,CUSTOMER_NO                                        
REARCH              ,PREMISE_NO                                         
REARCH              ,FULL_NAME                                          
REARCH              ,HOUSE_NO                                           
REARCH              ,STREET_NAME                                        
A21422              ,STREET_LOCATION_1                                  
A21422              ,STREET_LOCATION_2                                  
REARCH              ,OLD_EPP_AMT                                        
REARCH              ,NEW_EPP_AMT                                        
REARCH              ,ROWS_RETURNED                                      
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH               :S-RETURN-CODE                                     
REARCH              ,:S-ACCOUNT-NO                                      
REARCH              ,:S-TRANS-HIST-SEQ-NO                               
REARCH              ,:S-DATE-TRANS                                      
REARCH              ,:S-CODE-TRAN-TYPE                                  
A21427              ,:S-TRAN-SHORT-DESC                                 
REARCH              ,:S-AMT-ORIG-ENTERED                                
REARCH              ,:S-AMT-BILLED-UNPAID                               
REARCH              ,:S-RESP-AREA-ID                                    
A21427              ,:S-RESP-AREA-DESC                                  
REARCH              ,:S-APPL-PROGRAM-ID                                 
REARCH              ,:S-APPL-PROGRAM-DESC                               
REARCH              ,:S-PYMT-FACILITY-CD                                
REARCH              ,:S-USER-ID                                         
A21427              ,:S-EMPLOYEE-NAME                                   
REARCH              ,:S-COMPANY-NO                                      
REARCH              ,:S-TRAN-COMMENT                                    
REARCH              ,:S-RECORD-ONLY-FL                                  
REARCH              ,:S-DATE-ORIG-PYMT                                  
REARCH              ,:S-CASH-LOCAL-OFFICE                               
REARCH              ,:S-CASH-DRAWER-ID                                  
REARCH              ,:S-DATE-CASH-REPORT                                
REARCH              ,:S-CODE-BATCH-STATUS                               
REARCH              ,:S-PYMT-RCPT-PRNTD-CD                              
REARCH              ,:S-CUSTOMER-NO                                     
REARCH              ,:S-PREMISE-NO                                      
REARCH              ,:S-FULL-NAME                                       
REARCH              ,:S-HOUSE-NO                                        
REARCH              ,:S-STREET-NAME                                     
A21422              ,:S-STREET-LOCATION-1                               
A21422              ,:S-STREET-LOCATION-2                               
REARCH              ,:S-OLD-EPP-AMT                                     
REARCH              ,:S-NEW-EPP-AMT                                     
REARCH              ,:S-ROWS-RETURNED                                   
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02016_R1                                 
MFA-TR*         (                                                       01670000
MFA-TR*                                                                 01670000
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,TRANS_HIST_SEQ_NO                                          
MFA-TR*             ,DATE_TRANS                                                 
MFA-TR*             ,CODE_TRAN_TYPE                                             
MFA-TR*             ,TRAN_SHORT_DESC                                            
MFA-TR*             ,AMT_ORIG_ENTERED                                           
MFA-TR*             ,AMT_BILLED_UNPAID                                          
MFA-TR*             ,RESP_AREA_ID                                               
MFA-TR*             ,RESP_AREA_DESC                                             
MFA-TR*             ,APPL_PROGRAM_ID                                            
MFA-TR*             ,APPL_PROGRAM_DESC                                          
MFA-TR*             ,PYMT_FACILITY_CD                                           
MFA-TR*             ,USER_ID                                                    
MFA-TR*             ,EMPLOYEE_NAME                                              
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,TRAN_COMMENT_TEXT                                          
MFA-TR*             ,RECORD_ONLY_FL                                             
MFA-TR*             ,DATE_ORIG_PYMT                                             
MFA-TR*             ,CASH_LOCAL_OFFICE                                          
MFA-TR*             ,CASH_DRAWER_ID                                             
MFA-TR*             ,DATE_CASH_REPORT                                           
MFA-TR*             ,CODE_BATCH_STATUS                                          
MFA-TR*             ,PYMT_RCPT_PRNTD_CD                                         
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,FULL_NAME                                                  
MFA-TR*             ,HOUSE_NO                                                   
MFA-TR*             ,STREET_NAME                                                
MFA-TR*             ,STREET_LOCATION_1                                          
MFA-TR*             ,STREET_LOCATION_2                                          
MFA-TR*             ,OLD_EPP_AMT                                                
MFA-TR*             ,NEW_EPP_AMT                                                
MFA-TR*             ,ROWS_RETURNED                                              
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                       01670000
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-ACCOUNT-NO                                              
MFA-TR*             ,:S-TRANS-HIST-SEQ-NO                                       
MFA-TR*             ,:S-DATE-TRANS                                              
MFA-TR*             ,:S-CODE-TRAN-TYPE                                          
MFA-TR*             ,:S-TRAN-SHORT-DESC                                         
MFA-TR*             ,:S-AMT-ORIG-ENTERED                                        
MFA-TR*             ,:S-AMT-BILLED-UNPAID                                       
MFA-TR*             ,:S-RESP-AREA-ID                                            
MFA-TR*             ,:S-RESP-AREA-DESC                                          
MFA-TR*             ,:S-APPL-PROGRAM-ID                                         
MFA-TR*             ,:S-APPL-PROGRAM-DESC                                       
MFA-TR*             ,:S-PYMT-FACILITY-CD                                        
MFA-TR*             ,:S-USER-ID                                                 
MFA-TR*             ,:S-EMPLOYEE-NAME                                           
MFA-TR*             ,:S-COMPANY-NO                                              
MFA-TR*             ,:S-TRAN-COMMENT                                            
MFA-TR*             ,:S-RECORD-ONLY-FL                                          
MFA-TR*             ,:S-DATE-ORIG-PYMT                                          
MFA-TR*             ,:S-CASH-LOCAL-OFFICE                                       
MFA-TR*             ,:S-CASH-DRAWER-ID                                          
MFA-TR*             ,:S-DATE-CASH-REPORT                                        
MFA-TR*             ,:S-CODE-BATCH-STATUS                                       
MFA-TR*             ,:S-PYMT-RCPT-PRNTD-CD                                      
MFA-TR*             ,:S-CUSTOMER-NO                                             
MFA-TR*             ,:S-PREMISE-NO                                              
MFA-TR*             ,:S-FULL-NAME                                               
MFA-TR*             ,:S-HOUSE-NO                                                
MFA-TR*             ,:S-STREET-NAME                                             
MFA-TR*             ,:S-STREET-LOCATION-1                                       
MFA-TR*             ,:S-STREET-LOCATION-2                                       
MFA-TR*             ,:S-OLD-EPP-AMT                                             
MFA-TR*             ,:S-NEW-EPP-AMT                                             
MFA-TR*             ,:S-ROWS-RETURNED                                           
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH*                                                                         
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH          ADD +1                    TO CTR-ROWS                   
REARCH     ELSE                                                         
REARCH          MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
REARCH          MOVE SQLCODE              TO ABEND-SQLCODE              
REARCH          MOVE '8100'               TO ACTIVE-PARAGRAPH           
REARCH          MOVE 'INSERT'             TO ABEND-FUNCTION             
REARCH          MOVE SPACES               TO ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH          MOVE 'CSR02016_R1'        TO TABLE-1                    
REARCH          MOVE SPACES               TO TABLE-ELEMENT-1            
REARCH          MOVE SPACES               TO HOSTVAR-ELEMENT-1          
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPDSP300                                                
REARCH     END-EXEC.                                                            
REARCH*                                                                 12700000
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPD00320                                                
REARCH     END-EXEC.                                                            
