       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02012.                                         
COB303 DATE-WRITTEN.     JANUARY 9, 1995.                               
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S012 CONVERTED TO DB2 SP CSR02012 ON 05/23/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S012                                           *        
      *  PROGRAM:       S012                                           *        
      *  CALLING SP:    PA_S012                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM              *        
      * DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                        *        
      *                                                                *        
      * THIS PROGRAM RETRIEVES RETURNED CHECK HISTORY FOR AN ACCOUNT   *        
      * NUMBER.                                                        *        
P00935*  #  INVOKED FROM PAYMENT SOLUTION/RETURNED PAYMENT PROJECT     *        
P00935*                                                                *        
P00935*  #  BUSOP NAME: REQUGETACCTRETURNEDPYMTHISTBUSINESSOP          *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/09/95    DMS      CREATED.                                 *        
      *    0395      CIF      MODIFICATION MADE PER DATABASE CHANGE:   *        
      *                       CHANGE NSF_CD TO NSF_STATUS_CD.          *        
      *  08/02/95    TCB      REMOVED HARDCODED NSF_REASON_CD          *        
      *                       DESCRIPTIONS. REMOVED HARDCODED BANK     *        
      *                       DESCRIPTIONS AND NOW RETRIEVING THESE    *        
      *                       FROM CSS_BANK.                           *        
      *  08/31/95    AS       LOGIC TO POPULATE RS-CHARGE-FL CHANGED   *        
      *  01/20/95    SS       RETRIEVE NSF_TIMESTAMP FOR EACH ROW      *        
      *  05/14/95    SONALI   FOR REC_CNT = 0 THE CASH-ONLY FIELD      *        
      *                       WAS NOT DISPLAYED PROPERLY.  TPR#4159    *        
      *  06/19/96    RTO      MODIFIED FOR PCR 260 TO RETURN CASH      *        
      *                       ONLY EFFECTIVE DATE.                     *        
      *  07/16/96    SONALI   IF NSF-STATUS-CD = 'P' CREDIT-CHRG = 'Y' *        
      *                       ELSE 'N'(TPR#4557)                       *        
T10091*  04/07/97    EMM      MOVE 'N' TO RS-CHARGE-FL WHEN PENDING    *        
      *                       WAIVER.  ALSO TRANSLATED SEND NOTICE CODE*        
      *                       TO CORRESPOND WITH WAIVE NOTICE LABEL.   *        
T10050*  04/08/97    EMM      ADDED CODE OF 'C' TO RS-CHARGE-FL WHICH  *        
      *                       SIGNIFIES NSC CREDITED THRU PANEL310.    *        
      *                       RS-CHARGE-FL AND RS-NSC-REMOVE-FL ARE    *        
      *                       MANIPULATED TO DISPLAY CORECTLY ON THE   *        
T10477*  04/17/97    EMM      REMOVED A COMMENT.                       *        
      *                                                                *        
T11902*  07/01/97    EMM      MOVE SPACES TO BANK-NAME WHEN BANK-ID    *        
      *                       EQUAL 0.                                 *        
CBSI  *  07/15/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
C26296*  12/06/04    MDJ      SEND DEPOSIT-CERT-NO TO PANEL 182.       *        
REARCH*  07/08/05    CVNS     RPC TO COBOL SP CONVERSION                        
REARCH*              CHENNAI                                                    
C30881*  10/07/05   BASKAR V  INCREASE NSF_REASON_CD LENGTH            *        
P00935*  03/21/16   AARON     CIS MOD - RETURNED PAYMENT HIST CHANGES  *        
P00935*                       ADDED NAME OF THE BANK THAT THE CHECK WAS*        
P00935*                       DRAWN.                                   *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02012'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02012 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBANK                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      * CONTAINS THE COBOL EQUATES NEEDED FOR USING THE                         
      * SYBASE OPEN SERVER FOR CICS FACILITIES.                                 
CVT999*    COPY SYGWCOB.                                                        
      * ADDED TO SUPPORT CICS RPCS                                              
CVT999*    COPY SYDBCOB.                                                        
      * COMMON SYSTEM AREA                                                      
           COPY CCA00001.                                                       
      * ERROR HANDLING                                                          
CVT999*    COPY CWS00010.                                                       
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                          
           COPY CWS00027.                                                       
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  PROGRAM-NAME            PIC X(08) VALUE 'S012    '.              
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                          
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
CVT999*01  PARM-FIELDS.                                                         
CVT999*    05  PARM-L                  PIC S9(9) COMP.                          
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
CVT999*    05  PARM-ACCOUNT-NO         PIC X(13).                               
CVT999*                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-NULL-IND             PIC S9(4) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
P00935     05  WS-DRAWN-BANK-NAME      PIC X(50) VALUE SPACES.          
P00935     05  WS-BANK-ID              PIC X(06) VALUE SPACES.          
P00935     05  WS-BANK-ID-N REDEFINES WS-BANK-ID PIC 9(6).              
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
REARCH 01  TDS-RETURN-FIELDS.                                           
REARCH     05  RS-RETURN-CODE        PIC S9(9)      COMP VALUE 0.       
REARCH     05  RS-DATE-TRAN          PIC X(10)      VALUE SPACES.       
REARCH     05  RS-RETURN-CHECK-AMT   PIC S9(7)V99   COMP-3 VALUE +0.    
REARCH     05  RS-NSF-TYPE-CD        PIC X(01)      VALUE SPACES.       
C30881*    05  RS-NSF-REASON-CD      PIC X(01)      VALUE SPACES.               
C30881     05  RS-NSF-REASON-CD      PIC X(03)      VALUE SPACES.       
REARCH     05  RS-WAIVER-REASON-CD   PIC X(01)      VALUE SPACES.       
REARCH     05  RS-NSF-CD             PIC X(1)       VALUE SPACES.       
REARCH     05  RS-NBR-CHKS-COMPLETED PIC S9(04)     COMP VALUE +0.      
REARCH     05  RS-CHARGE-FL          PIC X(01)      VALUE SPACES.       
REARCH     05  RS-NSC-REMOVE-FL      PIC X(01)      VALUE SPACES.       
REARCH     05  RS-SEND-NOTICE-CD     PIC X(01)      VALUE SPACES.       
REARCH     05  RS-DRAWN-BY-NM        PIC X(50)      VALUE SPACES.       
REARCH     05  RS-BANK-NAME          PIC X(50)      VALUE SPACES.       
REARCH     05  RS-BANK-COMMENTS      PIC X(120)     VALUE SPACES.       
REARCH     05  RS-CASH-ONLY-FL       PIC X(01)      VALUE SPACES.       
REARCH     05  RS-CASH-ONLY-COMMENTS PIC X(72)      VALUE SPACES.       
REARCH     05  RS-NSF-TIMESTMP       PIC X(26)      VALUE SPACES.       
REARCH     05  RS-CSH-ONLY-EFFECT-DT PIC X(10)      VALUE SPACES.       
REARCH     05  RS-DEPOSIT-CERT-NO    PIC S9(09)     COMP VALUE 0.       
P00935     05  RS-DRAWN-BANK-NAME    PIC X(50)      VALUE SPACES.       
REARCH                                                                  
       01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE        PIC S9(9)      COMP VALUE 0.        
REARCH     05  S-DATE-TRAN          PIC X(10)      VALUE SPACES.        
REARCH     05  S-RETURN-CHECK-AMT   PIC S9(7)V99   COMP-3 VALUE +0.     
REARCH     05  S-NSF-TYPE-CD        PIC X(01)      VALUE SPACES.        
C30881*    05  S-NSF-REASON-CD      PIC X(01)      VALUE SPACES.                
C30881     05  S-NSF-REASON-CD      PIC X(03)      VALUE SPACES.        
REARCH     05  S-WAIVER-REASON-CD   PIC X(01)      VALUE SPACES.        
REARCH     05  S-NSF-CD             PIC X(1)       VALUE SPACES.        
REARCH     05  S-NBR-CHKS-COMPLETED PIC S9(04)     COMP VALUE +0.       
REARCH     05  S-CHARGE-FL          PIC X(01)      VALUE SPACES.        
REARCH     05  S-NSC-REMOVE-FL      PIC X(01)      VALUE SPACES.        
REARCH     05  S-SEND-NOTICE-CD     PIC X(01)      VALUE SPACES.        
REARCH     05  S-DRAWN-BY-NM        PIC X(50)      VALUE SPACES.        
REARCH     05  S-BANK-NAME          PIC X(50)      VALUE SPACES.        
REARCH     05  S-BANK-COMMENTS      PIC X(120)     VALUE SPACES.        
REARCH     05  S-CASH-ONLY-FL       PIC X(01)      VALUE SPACES.        
REARCH     05  S-CASH-ONLY-COMMENTS PIC X(72)      VALUE SPACES.        
REARCH     05  S-NSF-TIMESTMP       PIC X(26)      VALUE SPACES.        
REARCH     05  S-CSH-ONLY-EFFECT-DT PIC X(10)      VALUE SPACES.        
C26296     05  S-DEPOSIT-CERT-NO    PIC S9(09)     COMP VALUE 0.        
P00935     05  S-DRAWN-BANK-NAME    PIC X(50)      VALUE SPACES.        
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*    05  CNS-RETURN-CODE         PIC X(11) VALUE 'RETURN_CODE'.           
CVT999*    05  CNS-DATE-TRAN           PIC X(09) VALUE 'DATE_TRAN'.             
CVT999*    05  CNS-RETURN-CHECK-AMT PIC X(16) VALUE 'RETURN_CHECK_AMT'.         
CVT999*    05  CNS-NSF-TYPE-CD         PIC X(11) VALUE 'NSF_TYPE_CD'.           
CVT999*    05  CNS-NSF-REASON-CD       PIC X(13) VALUE 'NSF_REASON_CD'.         
CVT999*    05  CNS-WAIVER-REASON-CD    PIC X(16) VALUE                          
CVT999*                                          'WAIVER_REASON_CD'.            
CVT999*    05  CNS-NSF-CD              PIC X(06) VALUE 'NSF_CD'.                
CVT999*    05  CNS-NBR-CHKS-COMPLETED  PIC X(18)                                
CVT999*             VALUE 'NBR_CHKS_COMPLETED'.                                 
CVT999*    05  CNS-CHARGE-FL           PIC X(09) VALUE 'CHARGE_FL'.             
CVT999*    05  CNS-NSC-REMOVE-FL       PIC X(13) VALUE 'NSC_REMOVE_FL'.         
CVT999*    05  CNS-SEND-NOTICE-CD      PIC X(14) VALUE 'SEND_NOTICE_CD'.        
CVT999*    05  CNS-DRAWN-BY-NM         PIC X(11) VALUE 'DRAWN_BY_NM'.           
CVT999*    05  CNS-BANK-NAME           PIC X(09) VALUE 'BANK_NAME'.             
CVT999*    05  CNS-BANK-COMMENTS       PIC X(13) VALUE 'COMMENTS'.              
CVT999*    05  CNS-CASH-ONLY-FL        PIC X(12) VALUE 'CASH_ONLY_FL'.          
CVT999*    05  CNS-CASH-ONLY-COMMENTS  PIC X(18)                                
CVT999*             VALUE 'CASH_ONLY_COMMENTS'.                                 
CVT999*    05  CNS-NSF-TIMESTMP        PIC X(26) VALUE                          
CVT999*                                          'NSF_TIMESTMP'.                
CVT999*    05  CNS-CSH-ONLY-EFFECT-DT  PIC X(18) VALUE                          
CVT999*                                  'CSH_ONLY_EFFECT_DT'.                  
CVT999*    05  CNS-DEPOSIT-CERT-NO     PIC X(15) VALUE                          
CVT999*                                  'DEPOSIT_CERT_NO'.                     
CVT999*                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-ACCOUNT-NO.                                               
           05  WS-ACCOUNT                             PIC X(13).        
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT    PIC 9(13).        
COB305     05 WS-ACCOUNT-NUM        PIC S9(13)V USAGE COMP-3 VALUE 0.        
                                                                        
       01  WS-LITERALS.                                                 
           10  WS-ALL-ROWS-SELECTED     PIC X(01)  VALUE 'N'.           
           10  WS-NBR-CHKS-COMPLETED    PIC S9(04) COMP VALUE +0.       
                                                                        
REARCH 01  WS-MISC-FIELDS.                                              
REARCH     05 PROGRAM-NAME            PIC X(08) VALUE 'CSR02012'.       
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      * CURSOR FOR CSS_NSF_HIST                                                 
                                                                        
           EXEC SQL DECLARE NSF-HST-CURSOR CURSOR FOR                   
               SELECT CIS.CHAR2$DATE(A.DATE_TRAN,'USA'),                        
                      A.RETURN_CHECK_AMT,                               
                      A.NSF_TYPE_CD,                                    
                      A.NSF_REASON_CD,                                  
                      A.WAIVER_REASON_CD,                               
                      A.NSF_STATUS_CD,                                  
                      A.CHECK_UTIL_AMT,                                 
                      A.CHECK_NONUTIL_AMT,                              
                      A.NSC_REMOVE_FL,                                  
                      A.SEND_NOTICE_CD,                                 
                      A.DRAWN_BY_NM,                                    
T11902                A.BANK_ID,                                        
                      B.BANK_NAME,                                      
                      A.COMMENTS,                                       
                      A.NSF_CHARGE_AMT,                                 
C26296                REPLACE(REPLACE(CONVERT(CHAR(26), A.NSF_TIMESTMP
           , 121), ' ', '-'), ':', '.') NSF_TIMESTMP,                          
C26296                A.DEPOSIT_CERT_NO                                 
                 FROM CSS_NSF_HIST A,                                   
                      CSS_BANK B                                        
                WHERE A.ACCOUNT_NO = :WS-ACCOUNT-NUM                    
                  AND A.BANK_ID = B.BANK_ID                             
                ORDER BY NSF_TIMESTMP DESC                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE NSF-HST-CURSOR CURSOR FOR                           
MFA-TR*        SELECT CHAR(A.DATE_TRAN,USA),                                    
MFA-TR*               A.RETURN_CHECK_AMT,                                       
MFA-TR*               A.NSF_TYPE_CD,                                            
MFA-TR*               A.NSF_REASON_CD,                                          
MFA-TR*               A.WAIVER_REASON_CD,                                       
MFA-TR*               A.NSF_STATUS_CD,                                          
MFA-TR*               A.CHECK_UTIL_AMT,                                         
MFA-TR*               A.CHECK_NONUTIL_AMT,                                      
MFA-TR*               A.NSC_REMOVE_FL,                                          
MFA-TR*               A.SEND_NOTICE_CD,                                         
MFA-TR*               A.DRAWN_BY_NM,                                            
MFA-TR*               A.BANK_ID,                                                
MFA-TR*               B.BANK_NAME,                                              
MFA-TR*               A.COMMENTS,                                               
MFA-TR*               A.NSF_CHARGE_AMT,                                         
MFA-TR*               A.NSF_TIMESTMP,                                           
MFA-TR*               A.DEPOSIT_CERT_NO                                         
MFA-TR*          FROM CSS_NSF_HIST A,                                           
MFA-TR*               CSS_BANK B                                                
MFA-TR*         WHERE A.ACCOUNT_NO = :WS-ACCOUNT-NUM                            
MFA-TR*           AND A.BANK_ID = B.BANK_ID                                     
MFA-TR*         ORDER BY A.NSF_TIMESTMP DESC                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000*    10  WS-ABEND-SQLERRMC.                                       00001500
CVT000*        49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          00001600
CVT000*        49  WS-ABEND-SQLERRMC-V   PIC X(255).                    00001700
CVT000*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT                                                   
REARCH               RETURN_CODE                                        
REARCH              ,DATE_TRAN                                          
REARCH              ,RETURN_CHECK_AMT                                   
REARCH              ,NSF_TYPE_CD                                        
REARCH              ,NSF_REASON_CD                                      
REARCH              ,WAIVER_REASON_CD                                   
REARCH              ,NSF_CD                                             
REARCH              ,NBR_CHKS_COMPLETED                                 
REARCH              ,CHARGE_FL                                          
REARCH              ,NSC_REMOVE_FL                                      
REARCH              ,SEND_NOTICE_CD                                     
REARCH              ,LTRIM(RTRIM(DRAWN_BY_NM))        AS DRAWN_BY_NM           
REARCH              ,LTRIM(RTRIM(BANK_NAME))          AS BANK_NAME             
REARCH              ,LTRIM(RTRIM(BANK_COMMENTS))      AS BANK_COMMENTS         
REARCH              ,CASH_ONLY_FL                                       
REARCH              ,LTRIM(RTRIM(CASH_ONLY_COMMENTS)) AS 
           CASH_ONLY_COMMENTS    
REARCH              ,NSF_TIMESTMP                                       
REARCH              ,CSH_ONLY_EFFECT_DT                                 
REARCH              ,DEPOSIT_CERT_NO                                    
P00935              ,LTRIM(RTRIM(DRAWN_BANK_NAME)) AS DRAWN_BANK_NAME          
CVT000         FROM #CSR02012_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,DATE_TRAN                                                  
MFA-TR*             ,RETURN_CHECK_AMT                                           
MFA-TR*             ,NSF_TYPE_CD                                                
MFA-TR*             ,NSF_REASON_CD                                              
MFA-TR*             ,WAIVER_REASON_CD                                           
MFA-TR*             ,NSF_CD                                                     
MFA-TR*             ,NBR_CHKS_COMPLETED                                         
MFA-TR*             ,CHARGE_FL                                                  
MFA-TR*             ,NSC_REMOVE_FL                                              
MFA-TR*             ,SEND_NOTICE_CD                                             
MFA-TR*             ,STRIP(DRAWN_BY_NM)        AS DRAWN_BY_NM                   
MFA-TR*             ,STRIP(BANK_NAME)          AS BANK_NAME                     
MFA-TR*             ,STRIP(BANK_COMMENTS)      AS BANK_COMMENTS                 
MFA-TR*             ,CASH_ONLY_FL                                               
MFA-TR*             ,STRIP(CASH_ONLY_COMMENTS) AS CASH_ONLY_COMMENTS            
MFA-TR*             ,NSF_TIMESTMP                                               
MFA-TR*             ,CSH_ONLY_EFFECT_DT                                         
MFA-TR*             ,DEPOSIT_CERT_NO                                            
MFA-TR*             ,STRIP(DRAWN_BANK_NAME) AS DRAWN_BANK_NAME                  
MFA-TR*        FROM SESSION.CSR02012_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000*LINK EE SECTION.                                                         
CVT000*01  PARM-ACCOUNT-NO          PIC X(13)                .                  
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO          PIC X(13).                          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          PARM-ACCOUNT-NO.                                        
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM.                     *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      **    4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
      *    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
      *                                                                         
      *    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
      *       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
      *       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
      *       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
      *       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
      *    END-IF.                                                              
CVT000     PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02012_R1'            
REARCH                                          TO S-SQL-STATEMENT-V.   
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02012_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02012_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,DATE_TRAN CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,RETURN_CHECK_AMT         DECIMAL(09,2)                   
CVT000        ,NSF_TYPE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
C30881*       ,NSF_REASON_CD            CHAR(01)                                
C30881        ,NSF_REASON_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,WAIVER_REASON_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,NSF_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2                  
CVT000        ,NBR_CHKS_COMPLETED       SMALLINT                        
CVT000        ,CHARGE_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,NSC_REMOVE_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,SEND_NOTICE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,DRAWN_BY_NM CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,BANK_NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT004        ,BANK_COMMENTS CHAR(120)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,CASH_ONLY_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,CASH_ONLY_COMMENTS CHAR(72)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,NSF_TIMESTMP CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,CSH_ONLY_EFFECT_DT CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,DEPOSIT_CERT_NO          INT                         
P00935        ,DRAWN_BANK_NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03501_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *      RECEIVE PARMS.                                            *        
      *                                                                *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS            THRU 1100-EXIT.                
           PERFORM 1150-ASSIGN-WS-VARS           THRU 1150-EXIT.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE.          *        
      *                                                                *        
      *     CALLED BY:  1000-PROCESS-INPUT                             *        
      ******************************************************************        
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
REARCH*                                                                         
CVT999*    MOVE 1                           TO PARM-ID1.                        
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO   TO MAX-LENGTH-PARM,                 
CVT999*                                                                         
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
                                                                        
      ******************************************************************        
      * 1150-ASSIGN-WS-VARS                                            *        
      *     THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND       *        
      *     MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN, THESE    *        
      *     WORKING STORAGE VARIABLES ARE MOVED INTO THEIR RESPECTIVE  *        
      *     REDEFINED FIELDS FOR COMPLETING THE SQL SELECT STATEMENTS. *        
      *                                                                *        
      *     CALLED BY:  1000-PROCESS-INPUT                             *        
      ******************************************************************        
                                                                        
       1150-ASSIGN-WS-VARS.                                             
                                                                        
           MOVE PARM-ACCOUNT-NO         TO WS-ACCOUNT.                  
           MOVE WS-ACCOUNT-DEC          TO WS-ACCOUNT-NUM.              
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *                                                                *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.                
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT                                                        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH       MOVE RS-RETURN-CODE            TO S-RETURN-CODE.           
REARCH       MOVE RS-DATE-TRAN              TO S-DATE-TRAN.             
REARCH       MOVE RS-RETURN-CHECK-AMT       TO S-RETURN-CHECK-AMT.      
REARCH       MOVE RS-NSF-TYPE-CD            TO S-NSF-TYPE-CD.           
REARCH       MOVE RS-NSF-REASON-CD          TO S-NSF-REASON-CD.         
REARCH       MOVE RS-WAIVER-REASON-CD       TO S-WAIVER-REASON-CD.      
REARCH       MOVE RS-NSF-CD                 TO S-NSF-CD.                
REARCH       MOVE RS-NBR-CHKS-COMPLETED     TO S-NBR-CHKS-COMPLETED.    
REARCH       MOVE RS-CHARGE-FL              TO S-CHARGE-FL.             
REARCH       MOVE RS-NSC-REMOVE-FL          TO S-NSC-REMOVE-FL.         
REARCH       MOVE RS-SEND-NOTICE-CD         TO S-SEND-NOTICE-CD.        
REARCH       MOVE RS-DRAWN-BY-NM            TO S-DRAWN-BY-NM.           
REARCH       MOVE RS-BANK-NAME              TO S-BANK-NAME.             
REARCH       MOVE RS-BANK-COMMENTS          TO S-BANK-COMMENTS.         
REARCH       MOVE RS-CASH-ONLY-FL           TO S-CASH-ONLY-FL.          
REARCH       MOVE RS-CASH-ONLY-COMMENTS     TO S-CASH-ONLY-COMMENTS.    
REARCH       MOVE RS-NSF-TIMESTMP           TO S-NSF-TIMESTMP.          
REARCH       MOVE RS-CSH-ONLY-EFFECT-DT     TO S-CSH-ONLY-EFFECT-DT.    
REARCH       MOVE RS-DEPOSIT-CERT-NO        TO S-DEPOSIT-CERT-NO.       
P00935       MOVE RS-DRAWN-BANK-NAME        TO S-DRAWN-BANK-NAME.       
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *     DESCRIBE RESULT SET.                                       *        
      *                                                                *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*                                                                         
REARCH*    MOVE '2100'                       TO ACTIVE-PARAGRAPH.               
REARCH*                                                                         
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSINT4                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-RETURN-CODE         TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE        TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-DATE-TRAN           TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-DATE-TRAN          TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DATE-TRAN,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-DATE-TRAN,                                 
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDS-PACKED-DECIMAL TO DB-HOST-TYPE.                             
CVT999*    MOVE TDSMONEY           TO DB-CLIENT-TYPE.                           
CVT999*    MOVE LENGTH OF RS-RETURN-CHECK-AMT    TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-RETURN-CHECK-AMT   TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CHECK-AMT,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CHECK-AMT,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-NSF-TYPE-CD         TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-NSF-TYPE-CD        TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-NSF-TYPE-CD,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-NSF-TYPE-CD,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
      *                                                                         
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-NSF-REASON-CD       TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-NSF-REASON-CD      TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-NSF-REASON-CD,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-NSF-REASON-CD,                             
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
      *                                                                         
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-WAIVER-REASON-CD    TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-WAIVER-REASON-CD   TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-WAIVER-REASON-CD,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-WAIVER-REASON-CD,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
      *                                                                         
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-NSF-CD              TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-NSF-CD             TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-NSF-CD,                                     
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-NSF-CD,                                    
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSINT2            TO DB-HOST-TYPE.                             
CVT999*    MOVE TDSINT2            TO DB-CLIENT-TYPE.                           
CVT999*    MOVE LENGTH OF RS-NBR-CHKS-COMPLETED  TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-NBR-CHKS-COMPLETED TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-NBR-CHKS-COMPLETED,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-NBR-CHKS-COMPLETED,                        
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-CHARGE-FL           TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-CHARGE-FL          TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CHARGE-FL,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CHARGE-FL,                                 
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-NSC-REMOVE-FL       TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-NSC-REMOVE-FL      TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-NSC-REMOVE-FL,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-NSC-REMOVE-FL,                             
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
      *                                                                         
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-SEND-NOTICE-CD      TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-SEND-NOTICE-CD     TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SEND-NOTICE-CD,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SEND-NOTICE-CD,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
      *                                                                         
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-DRAWN-BY-NM         TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-DRAWN-BY-NM        TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DRAWN-BY-NM,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-DRAWN-BY-NM,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
      *                                                                         
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-BANK-NAME           TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-BANK-NAME          TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-BANK-NAME,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-BANK-NAME,                                 
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-BANK-COMMENTS       TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-BANK-COMMENTS      TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-BANK-COMMENTS,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-BANK-COMMENTS,                             
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-CASH-ONLY-FL        TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-CASH-ONLY-FL       TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CASH-ONLY-FL,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CASH-ONLY-FL,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
      *                                                                         
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-CASH-ONLY-COMMENTS  TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-CASH-ONLY-COMMENTS TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CASH-ONLY-COMMENTS,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CASH-ONLY-COMMENTS,                        
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
      *                                                                         
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-NSF-TIMESTMP        TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-NSF-TIMESTMP       TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-NSF-TIMESTMP,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-NSF-TIMESTMP,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
      *                                                                         
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-CSH-ONLY-EFFECT-DT  TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-CSH-ONLY-EFFECT-DT TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CSH-ONLY-EFFECT-DT,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CSH-ONLY-EFFECT-DT,                        
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
      *                                                                         
CVT999*    ADD  1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSINT4            TO DB-HOST-TYPE.                             
CVT999*    MOVE TDSINT4            TO DB-CLIENT-TYPE.                           
CVT999*    MOVE LENGTH OF RS-DEPOSIT-CERT-NO     TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-DEPOSIT-CERT-NO    TO WRKLEN2.                    
C26296                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DEPOSIT-CERT-NO,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-DEPOSIT-CERT-NO,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     BUILD RESULT SET.                                          *        
      *                                                                *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE WS-ACCOUNT-NUM TO CZ-ACCOUNT-NO.                        
           PERFORM 7050-GET-CREDIT-PROFILE        THRU 7050-EXIT.       
           MOVE CZ-CASH-ONLY-FL            TO RS-CASH-ONLY-FL.          
           MOVE CZ-CASH-ONLY-COMMENTS-TEXT TO RS-CASH-ONLY-COMMENTS.    
           MOVE CZ-CSH-ONLY-EFFECT-DT TO RS-CSH-ONLY-EFFECT-DT.         
           PERFORM 7100-SELECT-NBR-CHKS-COMPLETED   THRU 7100-EXIT.     
           MOVE WS-NBR-CHKS-COMPLETED      TO RS-NBR-CHKS-COMPLETED.    
                                                                        
           PERFORM 7700-OPEN-NSF-HST-CURSOR       THRU 7700-EXIT.       
           PERFORM 2210-PROCESS-FETCH-NSF         THRU 2210-EXIT        
               UNTIL WS-ALL-ROWS-SELECTED EQUAL 'Y'.                    
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT
           END-IF.             
                                                                        
           PERFORM 7800-CLOSE-NSF-HST-CURSOR      THRU 7800-EXIT.       
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-PROCESS-FETCH-NSF                                         *        
      *     READ CSS_NSF_HIST ROW, FORMAT RETURN VARIABLES,            *        
      *     SEND RESULT.                                               *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2210-PROCESS-FETCH-NSF.                                          
                                                                        
           PERFORM 7000-FETCH-RTN-CHK-AMT   THRU 7000-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              GO TO 2210-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE NH-DATE-TRAN             TO RS-DATE-TRAN.               
           MOVE NH-RETURN-CHECK-AMT      TO RS-RETURN-CHECK-AMT.        
           MOVE NH-NSF-TYPE-CD           TO RS-NSF-TYPE-CD.             
           MOVE NH-NSF-REASON-CD         TO RS-NSF-REASON-CD.           
           MOVE NH-NSF-STATUS-CD         TO RS-NSF-CD.                  
      *                                                                         
T10050     IF NH-NSC-REMOVE-FL = 'C'                                    
               MOVE 'Y'                  TO RS-CHARGE-FL                
               MOVE 'N'                  TO RS-NSC-REMOVE-FL            
           ELSE                                                         
               MOVE 'N'                  TO RS-CHARGE-FL                
               MOVE NH-NSC-REMOVE-FL     TO RS-NSC-REMOVE-FL            
T10050     END-IF.                                                      
      *                                                                         
T10091     IF NH-SEND-NOTICE-CD = 'Y'                                   
               MOVE 'N'                  TO RS-SEND-NOTICE-CD           
           ELSE                                                         
               MOVE 'Y'                  TO RS-SEND-NOTICE-CD           
           END-IF.                                                      
      *                                                                         
T10477     MOVE NH-WAIVER-REASON-CD      TO RS-WAIVER-REASON-CD.        
           MOVE NH-DRAWN-BY-NM-TEXT      TO RS-DRAWN-BY-NM.             
      *                                                                         
T11902     IF NH-BANK-ID > 0                                            
               MOVE D1-BANK-NAME         TO RS-BANK-NAME                
           ELSE                                                         
               MOVE SPACES               TO RS-BANK-NAME                
           END-IF.                                                      
      *                                                                         
           MOVE NH-COMMENTS-TEXT(1:114)  TO RS-BANK-COMMENTS.           
           MOVE NH-NSF-TIMESTMP          TO RS-NSF-TIMESTMP.            
                                                                        
P00935     MOVE SPACES                   TO RS-DRAWN-BANK-NAME          
P00935                                      WS-DRAWN-BANK-NAME.         
P00935     MOVE NH-COMMENTS-TEXT(115:6)  TO WS-BANK-ID.                 
P00935     MOVE WS-BANK-ID-N             TO D1-BANK-ID.                 
P00935                                                                  
P00935     IF D1-BANK-ID > 0                                            
P00935        PERFORM 7010-SELECT-DRAWN-BANK-NAME THRU 7010-EXIT        
P00935        MOVE WS-DRAWN-BANK-NAME    TO RS-DRAWN-BANK-NAME          
P00935     END-IF                                                       
P00935                                                                  
C26296     MOVE NH-DEPOSIT-CERT-NO       TO RS-DEPOSIT-CERT-NO.         
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT.           
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-FETCH-RTN-CHK-AMT                                         *        
      *     FETCHES CSS_NSF_HIST TABLE ROW.                            *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7000-FETCH-RTN-CHK-AMT.                                          
                                                                        
           MOVE '7000'               TO ACTIVE-PARAGRAPH.               
                                                                        
           MOVE SPACES               TO NH-DRAWN-BY-NM-TEXT,            
                                        NH-COMMENTS-TEXT.               
                                                                        
           EXEC SQL                                                     
              FETCH NSF-HST-CURSOR                                      
              INTO  :NH-DATE-TRAN,                                      
                    :NH-RETURN-CHECK-AMT,                               
                    :NH-NSF-TYPE-CD,                                    
                    :NH-NSF-REASON-CD,                                  
                    :NH-WAIVER-REASON-CD,                               
                    :NH-NSF-STATUS-CD,                                  
                    :NH-CHECK-UTIL-AMT,                                 
                    :NH-CHECK-NONUTIL-AMT,                              
                    :NH-NSC-REMOVE-FL,                                  
                    :NH-SEND-NOTICE-CD,                                 
                    :NH-DRAWN-BY-NM,                                    
T11902              :NH-BANK-ID,                                        
                    :D1-BANK-NAME,                                      
                    :NH-COMMENTS,                                       
                    :NH-NSF-CHARGE-AMT,                                 
C26296              :NH-NSF-TIMESTMP,                                   
C26296              :NH-DEPOSIT-CERT-NO                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                MOVE 'Y' TO WS-ALL-ROWS-SELECTED                        
                MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE            
              ELSE                                                      
                MOVE PROGRAM-NAME               TO ABEND-PROGRAM        
CBSI            MOVE 'FETCH'                    TO ABEND-FUNCTION       
CBSI            MOVE SPACES                     TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
                MOVE 'CSS_NSF_HIST'             TO TABLE-1              
CBSI            MOVE 'CSS_BANK'                 TO TABLE-2              
CBSI            MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1      
CBSI            MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
                PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
           END-IF
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00935******************************************************************        
P00935* 7010-SELECT-DRAWN-BANK-NAME                                    *        
P00935******************************************************************        
P00935                                                                  
P00935 7010-SELECT-DRAWN-BANK-NAME.                                     
P00935                                                                  
P00935     EXEC SQL                                                     
P00935        SELECT BANK_NAME                                          
P00935          INTO :WS-DRAWN-BANK-NAME                                
P00935          FROM CSS_BANK WITH(READUNCOMMITTED)                             
P00935         WHERE BANK_ID = :D1-BANK-ID                              
P00935                                                           
P00935                                                      
P00935     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BANK_NAME                                                  
MFA-TR*         INTO :WS-DRAWN-BANK-NAME                                        
MFA-TR*         FROM CSS_BANK                                                   
MFA-TR*        WHERE BANK_ID = :D1-BANK-ID                                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00935                                                                  
P00935     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00935                                                                  
P00935     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00935        CONTINUE                                                  
P00935      ELSE                                                        
P00935        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00935        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00935        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00935                                           ABEND-TABLES           
P00935        MOVE 'CSS_BANK'                 TO TABLE-1                
P00935        MOVE 'BANK_ID'                  TO TABLE-ELEMENT-1        
P00935        MOVE D1-BANK-ID                 TO HOSTVAR-ELEMENT-1      
P00935        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00935        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00935      END-IF.                                                     
P00935                                                                  
P00935 7010-EXIT.                                                       
P00935     EXIT.                                                        
P00935                                                                  
      ******************************************************************        
      * 7050-GET-CREDIT-PROFILE                                        *        
      *     READ CSS_CREDI_PROFILE ROW, FORMAT RETURN VARIABLES,       *        
      *     SEND RESULT.                                               *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7050-GET-CREDIT-PROFILE.                                         
           MOVE '7050'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
             SELECT                                                     
               CASH_ONLY_FL,                                            
               CASH_ONLY_COMMENTS,                                      
               CIS.CHAR2$DATE(CSH_ONLY_EFFECT_DT,'USA')                         
             INTO  :CZ-CASH-ONLY-FL,                                    
                   :CZ-CASH-ONLY-COMMENTS,                              
                   :CZ-CSH-ONLY-EFFECT-DT :WS-NULL-IND                   
              FROM CSS_CREDIT_PROFILE                                   
              WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT                                                             
MFA-TR*        CASH_ONLY_FL,                                                    
MFA-TR*        CASH_ONLY_COMMENTS,                                              
MFA-TR*        CHAR(CSH_ONLY_EFFECT_DT,USA)                                     
MFA-TR*      INTO  :CZ-CASH-ONLY-FL,                                            
MFA-TR*            :CZ-CASH-ONLY-COMMENTS,                                      
MFA-TR*            :CZ-CSH-ONLY-EFFECT-DT:WS-NULL-IND                           
MFA-TR*       FROM CSS_CREDIT_PROFILE                                           
MFA-TR*       WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-NULL-IND = -1                                      
                  MOVE SPACES TO CZ-CSH-ONLY-EFFECT-DT                  
               END-IF                                                   
            ELSE                                                        
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'CZ-ACCOUNT-NO'            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-NBR-CHKS-COMPLETED                                 *        
      *     SELECTS NUMBER OF CHECKS WITH A STATUS OF COMPLETED 'C'.   *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7100-SELECT-NBR-CHKS-COMPLETED.                                  
                                                                        
           MOVE '7100'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              SELECT COUNT (*)                                          
                INTO :WS-NBR-CHKS-COMPLETED                             
                FROM CSS_NSF_HIST                                       
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NUM                       
                 AND NSF_STATUS_CD     = 'C'                            
                 AND DATE_TRAN  > DATEADD( YEAR, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT (*)                                                  
MFA-TR*         INTO :WS-NBR-CHKS-COMPLETED                                     
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NUM                               
MFA-TR*          AND NSF_STATUS_CD     = 'C'                                    
MFA-TR*          AND DATE_TRAN  > CURRENT DATE - 1 YEAR                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
                MOVE PROGRAM-NAME               TO ABEND-PROGRAM        
CBSI            MOVE 'SELECT'                   TO ABEND-FUNCTION       
CBSI            MOVE SPACES                     TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
                MOVE 'CSS_NSF_HIST'             TO TABLE-1              
CBSI            MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1      
CBSI            MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1    
                PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7700-OPEN-NSF-HST-CURSOR.                                      *        
      *     OPEN CURSOR.                                               *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7700-OPEN-NSF-HST-CURSOR.                                        
                                                                        
           MOVE '7700'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
              OPEN NSF-HST-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_NSF_HIST'             TO TABLE-1                
CBSI          MOVE 'CSS_BANK'                 TO TABLE-2                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7800-CLOSE-NSF-HST-CURSOR                                      *        
      *     CLOSE CURSOR.                                              *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7800-CLOSE-NSF-HST-CURSOR.                                       
                                                                        
           MOVE '7800'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
              CLOSE  NSF-HST-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE SPACES                     TO ABEND-SQL-PREDICATES   
CBSI                                             ABEND-TABLES           
              MOVE 'CSS_NSF_HIST'             TO TABLE-1                
CBSI          MOVE 'CSS_BANK'                 TO TABLE-2                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02012_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,DATE_TRAN                                                 
CVT000       ,RETURN_CHECK_AMT                                          
CVT000       ,NSF_TYPE_CD                                               
CVT000       ,NSF_REASON_CD                                             
CVT000       ,WAIVER_REASON_CD                                          
CVT000       ,NSF_CD                                                    
CVT000       ,NBR_CHKS_COMPLETED                                        
CVT000       ,CHARGE_FL                                                 
CVT000       ,NSC_REMOVE_FL                                             
CVT000       ,SEND_NOTICE_CD                                            
CVT000       ,DRAWN_BY_NM                                               
CVT000       ,BANK_NAME                                                 
CVT004       ,BANK_COMMENTS                                             
CVT000       ,CASH_ONLY_FL                                              
CVT000       ,CASH_ONLY_COMMENTS                                        
CVT000       ,NSF_TIMESTMP                                              
CVT000       ,CSH_ONLY_EFFECT_DT                                        
CVT000       ,DEPOSIT_CERT_NO                                           
P00935       ,DRAWN_BANK_NAME                                           
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :S-RETURN-CODE                                            
CVT000       ,:S-DATE-TRAN                                              
CVT000       ,:S-RETURN-CHECK-AMT                                       
CVT000       ,:S-NSF-TYPE-CD                                            
CVT000       ,:S-NSF-REASON-CD                                          
CVT000       ,:S-WAIVER-REASON-CD                                       
CVT000       ,:S-NSF-CD                                                 
CVT000       ,:S-NBR-CHKS-COMPLETED                                     
CVT000       ,:S-CHARGE-FL                                              
CVT000       ,:S-NSC-REMOVE-FL                                          
CVT000       ,:S-SEND-NOTICE-CD                                         
CVT000       ,:S-DRAWN-BY-NM                                            
CVT000       ,:S-BANK-NAME                                              
CVT000       ,:S-BANK-COMMENTS                                          
CVT000       ,:S-CASH-ONLY-FL                                           
CVT000       ,:S-CASH-ONLY-COMMENTS                                     
CVT000       ,:S-NSF-TIMESTMP                                           
CVT000       ,:S-CSH-ONLY-EFFECT-DT                                     
CVT000       ,:S-DEPOSIT-CERT-NO                                        
P00935       ,:S-DRAWN-BANK-NAME                                        
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02012_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,DATE_TRAN                                                         
MFA-TR*      ,RETURN_CHECK_AMT                                                  
MFA-TR*      ,NSF_TYPE_CD                                                       
MFA-TR*      ,NSF_REASON_CD                                                     
MFA-TR*      ,WAIVER_REASON_CD                                                  
MFA-TR*      ,NSF_CD                                                            
MFA-TR*      ,NBR_CHKS_COMPLETED                                                
MFA-TR*      ,CHARGE_FL                                                         
MFA-TR*      ,NSC_REMOVE_FL                                                     
MFA-TR*      ,SEND_NOTICE_CD                                                    
MFA-TR*      ,DRAWN_BY_NM                                                       
MFA-TR*      ,BANK_NAME                                                         
MFA-TR*      ,BANK_COMMENTS                                                     
MFA-TR*      ,CASH_ONLY_FL                                                      
MFA-TR*      ,CASH_ONLY_COMMENTS                                                
MFA-TR*      ,NSF_TIMESTMP                                                      
MFA-TR*      ,CSH_ONLY_EFFECT_DT                                                
MFA-TR*      ,DEPOSIT_CERT_NO                                                   
MFA-TR*      ,DRAWN_BANK_NAME                                                   
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-DATE-TRAN                                                      
MFA-TR*      ,:S-RETURN-CHECK-AMT                                               
MFA-TR*      ,:S-NSF-TYPE-CD                                                    
MFA-TR*      ,:S-NSF-REASON-CD                                                  
MFA-TR*      ,:S-WAIVER-REASON-CD                                               
MFA-TR*      ,:S-NSF-CD                                                         
MFA-TR*      ,:S-NBR-CHKS-COMPLETED                                             
MFA-TR*      ,:S-CHARGE-FL                                                      
MFA-TR*      ,:S-NSC-REMOVE-FL                                                  
MFA-TR*      ,:S-SEND-NOTICE-CD                                                 
MFA-TR*      ,:S-DRAWN-BY-NM                                                    
MFA-TR*      ,:S-BANK-NAME                                                      
MFA-TR*      ,:S-BANK-COMMENTS                                                  
MFA-TR*      ,:S-CASH-ONLY-FL                                                   
MFA-TR*      ,:S-CASH-ONLY-COMMENTS                                             
MFA-TR*      ,:S-NSF-TIMESTMP                                                   
MFA-TR*      ,:S-CSH-ONLY-EFFECT-DT                                             
MFA-TR*      ,:S-DEPOSIT-CERT-NO                                                
MFA-TR*      ,:S-DRAWN-BANK-NAME                                                
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000        MOVE SQLCODE              TO ABEND-SQLCODE                
CVT000        MOVE SQLSTATE             TO ABEND-SQLSTATE               
CVT000        MOVE '8900'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR0TEST_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02012_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02012_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02012_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
