       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02001.                                         
COB303 DATE-WRITTEN. SEPTEMBER 15, 2005                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S001 CONVERTED TO DB2 SP CSR02001 ON 09/15/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S001                                           *00120000
      *  PROGRAM:       S001                                           *00130000
      *  CALLING SP:    PD_INTERRUPTCONTRCTUPD                         *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM INSERTS/UPDATES DELETES DATA IN                  *00190000
      *  CSS_INTERRUPT_ACCT TABLE.    MISCELLANEOUS JOURNALS           *00200000
      *  (CSS_MNT_TRANS_HIST AND CSS_MT_TRN_HST_DET) ARE WRITTEN WHEN  *00201000
      *  MODIFICATIONS WERE DONE.                                      *00201100
      *                                                                *00201200
      ******************************************************************00202000
      *                                                                *00203000
      *                     PROGRAM MODIFICATION LOG                   *00204000
      *                                                                *00205000
      *    DATE    INITIALS   COMMENTS                                 *00206000
      *  --------  --------   ---------------------------------------  *00207000
      *  01/03/95    AS       PROCEDURE ORIGINALLY CODED.              *00208000
      *  03/29/95    AS       TRANSACTION COMMENT LENGTH AND TEXT      *00209001
      *                       PARAMTERS ADDED.                         *00209102
CBSI  *  07/13/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *00209200
CBSI  *             MADRAS    ABEND PARAMETERS                         *00209300
PCR673*  02/01/99   MJL       CHANGED TYPICAL INTERRUPT DEMAND TO MAX  *        
REARCH*  09/15/05   CVNS      RPC TO COBOL DB2 SP CONVERSION           *        
REARCH*             CHENNAI                                            *        
T35434*  10/27/07   MK92804   REPLACED CSS_MODEL_SQL WITH SET STMTS    *        
T35434*                       AND ADDED 'WITH UR' FOR SINGLETON SELECTS*        
A00923*  06/29/09   GD97441   1.FIX TYP-INTRPT-DEMAND TRUNCATION ISSUE *        
A00923*                       2.FIX TYP-INTRPT-DEMAND TRNS HIST ISSUE  *        
A00923*                         FOR INSERT & UPDATE                    *        
A00923*                       3.FIX 8200-EXIT / 8400-EXIT ISSUE        *        
A03842*  12/20/11    SV95326  CHANGE TYP_INTRPT_DEMAND FIELD DATA TYPE *        
A03842*              ACT001   FROM NUMBER TO DECIMAL.                  *        
A04527*  06/07/13    AS7C117  REMOVE UNUSED COPYBOOK CWS00056.         *        
P00801*  05/08/14    MC95456  PARM UPDATE LOGIC FOR BILL CONTRACT      *        
      ******************************************************************00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00240000
      *                                                                *00250000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00260000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00270000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00280000
      *  3000 - 4999  NOT USED                                         *00290000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00300000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00310000
      *  7000 - 7999  INPUT MODULES                                    *00320000
      *  8000 - 8999  OUTPUT MODULES                                   *00330000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00340000
      *                                                                *00350000
      ******************************************************************00360000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02001'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02001 STARTS HERE'.                  
                                                                        
      ******************************************************************00450000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00460000
      ******************************************************************00470000
                                                                        
           COPY CCA00001.                                               00510000
           COPY CWS00027.                                               00530000
           COPY CWS00303.                                               00550000
                                                                        
      ******************************************************************00570000
      *    WORK AREAS                                                  *00580000
      ******************************************************************00590000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02001'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-IC-NO                PIC 9(5)  VALUE ZERO.            
      *    05  WS-IC-NO-NUM            PIC S9(4)  COMP VALUE ZERO.      00700003
                                                                        
           05  WS-FIRM-DEMAND-LEVEL    PIC 9(9).                        
           05  WS-FIRM-DEMAND-NUM      PIC S9(9)V COMP-3 VALUE ZERO.    
           05  WS-RECORD-EXISTS        PIC X(1) VALUE SPACE.            
A00923     05  WS-TYP-DEMAND-DISPLAY   PIC ++++++++9.                   
           05  WS-FIRM-DEMAND-DISPLAY  PIC ++++++++9.                   
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE +1.       
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-B                     PIC X(01) VALUE 'B'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-F                     PIC X(01) VALUE 'F'.            
           05  WS-G                     PIC X(01) VALUE 'G'.            
           05  WS-I                     PIC X(01) VALUE 'I'.            
           05  WS-M                     PIC X(01) VALUE 'M'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
           05  WS-Z                     PIC X(01) VALUE 'Z'.            
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-UPDATE-STATUS      PIC X(1) VALUE SPACE.            
           05  PARM-ACCOUNT-NO         PIC X(13)  VALUE SPACES.         
           05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        
                                       PIC 9(13).                       
           05  PARM-CODE-UTIL-TYPE     PIC X(1)   VALUE SPACE.          
      *    05  PARM-IC-NO              PIC X(5)   VALUE SPACE.          01001303
           05  PARM-IC-NO              PIC S9(4)  COMP VALUE 0.         
      *    05  PARM-IC-NO-RED          REDEFINES PARM-IC-NO             01001503
      *                                PIC 9(5).                        01001603
A03842     05  PARM-TYP-INTRPT-DEMAND  PIC S9(9)V USAGE COMP-3 VALUE 0. 
           05  PARM-USER-ID-ACCT-MGR   PIC X(7) VALUE SPACES.           
           05  PARM-CONTRACT-DATE      PIC X(10) VALUE SPACES.          
           05  PARM-CATEGORY           PIC X(1) VALUE SPACES.           
           05  PARM-FIRM-DEMAND-LEVEL  PIC X(9) VALUE SPACES.           
           05  PARM-FIRM-DEMAND-RED    REDEFINES PARM-FIRM-DEMAND-LEVEL 
                                       PIC 9(9).                        
           05  PARM-CURTAILMENT        PIC X(1) VALUE SPACE.            
           05  PARM-RESP-AREA-ID       PIC  X(03).                      
           05  PARM-USER-ID            PIC  X(07).                      
           05  PARM-TRANS-COMMENT-TEXT PIC  X(210).                     
           05  PARM-TRANS-COMMENT-LEN  PIC  S9(4) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
REARCH 01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
REARCH*                                                                 01160000
           EXEC SQL                                                     01197500
              INCLUDE SQLCA                                             01197600
           END-EXEC.                                                    01197700
                                                                        
           EXEC SQL                                                     01210000
             INCLUDE TBINTACT                                           01220000
           END-EXEC.                                                    01230000
                                                                        
           EXEC SQL                                                     01240900
              INCLUDE TBMNHIST                                          01241000
           END-EXEC.                                                    01241100
                                                                        
           EXEC SQL                                                     01241300
              INCLUDE TBMNHDT                                           01241400
           END-EXEC.                                                    01241500
                                                                        
HPCCDM*EJECT                                                            01242600
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-UPDATE-STATUS       PIC X(1)                 .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-ACCOUNT-NO-RED      PIC 9(13)                .          
CVT000 01  LINK-CODE-UTIL-TYPE      PIC X(1)                 .          
CVT000 01  LINK-IC-NO               PIC S9(4)  COMP          .          
COB305 01 LINK-TYP-INTRPT-DEMAND        PIC S9(9)V USAGE COMP-3 VALUE 0.        
CVT000 01  LINK-USER-ID-ACCT-MGR    PIC X(7)                 .          
CVT000 01  LINK-CONTRACT-DATE       PIC X(10)                .          
CVT000 01  LINK-CATEGORY            PIC X(1)                 .          
CVT000 01  LINK-FIRM-DEMAND-LEVEL   PIC X(9)                 .          
CVT000 01  LINK-FIRM-DEMAND-RED     PIC 9(9)                 .          
CVT000 01  LINK-CURTAILMENT         PIC X(1)                 .          
CVT000 01  LINK-RESP-AREA-ID        PIC  X(03)               .          
CVT000 01  LINK-USER-ID             PIC  X(07)               .          
CVT000 01  LINK-TRANS-COMMENT-TEXT  PIC  X(210)              .          
CVT000 01  LINK-TRANS-COMMENT-LEN   PIC  S9(4) COMP          .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-UPDATE-STATUS                                      
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         ,LINK-CODE-UTIL-TYPE                                     
CVT000         ,LINK-IC-NO                                              
CVT000         ,LINK-TYP-INTRPT-DEMAND                                  
CVT000         ,LINK-USER-ID-ACCT-MGR                                   
CVT000         ,LINK-CONTRACT-DATE                                      
CVT000         ,LINK-CATEGORY                                           
CVT000         ,LINK-FIRM-DEMAND-LEVEL                                  
CVT000         ,LINK-CURTAILMENT                                        
CVT000         ,LINK-RESP-AREA-ID                                       
CVT000         ,LINK-USER-ID                                            
CVT000         ,LINK-TRANS-COMMENT-TEXT                                 
CVT000         ,LINK-TRANS-COMMENT-LEN                                  
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************01244000
      * 0000-MAINLINE                                                  *01245000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01246000
      ******************************************************************01247000
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01330000
      * 0100-INITIALIZE                                                *01340000
      *     RECEIVE PARMS                                              *01360000
      ******************************************************************01400000
                                                                        
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
REARCH        :S-RETURN-CODE               AS    RETURN_CODE            
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE               AS    RETURN_CODE                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-UPDATE-STATUS        TO PARM-UPDATE-STATUS       . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE      . 
CVT000     MOVE LINK-IC-NO                TO PARM-IC-NO               . 
CVT000     MOVE LINK-TYP-INTRPT-DEMAND    TO PARM-TYP-INTRPT-DEMAND   . 
CVT000     MOVE LINK-USER-ID-ACCT-MGR     TO PARM-USER-ID-ACCT-MGR    . 
CVT000     MOVE LINK-CONTRACT-DATE        TO PARM-CONTRACT-DATE       . 
CVT000     MOVE LINK-CATEGORY             TO PARM-CATEGORY            . 
CVT000     MOVE LINK-FIRM-DEMAND-LEVEL    TO PARM-FIRM-DEMAND-LEVEL   . 
CVT000     MOVE LINK-CURTAILMENT          TO PARM-CURTAILMENT         . 
CVT000     MOVE LINK-RESP-AREA-ID         TO PARM-RESP-AREA-ID        . 
CVT000     MOVE LINK-USER-ID              TO PARM-USER-ID             . 
CVT000     MOVE LINK-TRANS-COMMENT-TEXT   TO PARM-TRANS-COMMENT-TEXT  . 
CVT000     MOVE LINK-TRANS-COMMENT-LEN    TO PARM-TRANS-COMMENT-LEN   . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01932500
      * 2000-PROCESS-OUTPUT.                                           *01932600
      *                                                                *01932700
      *     1. DESCRIBE RESULT SET                                     *01932800
      *     2. UPDATE DB2 DATA                                         *01932900
      *     3. BUILD RESULT SET                                        *01933000
      *     4. SEND RESULT SET                                         *01933100
      *                                                                *01933200
      ******************************************************************01933300
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2200-PROCESS-INTERRUPT-ACCT THRU 2200-EXIT.          
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************02272000
      *  2200-PROCESS-DATA                                             *02272100
      *                                                                *02272200
      *     SELECT A ROW FROM INTERRUPT_ACCT USING PARM.               *02272300
      *                                                                *02272400
      ******************************************************************02272500
       2200-PROCESS-INTERRUPT-ACCT.                                     
                                                                        
           MOVE PARM-ACCOUNT-NO         TO WS-ACCOUNT-NO.               
           MOVE WS-ACCOUNT-NO           TO WS-ACCOUNT-NO-NUM.           
      *    MOVE PARM-IC-NO-RED          TO WS-IC-NO.                    02273003
      *    MOVE WS-IC-NO                TO WS-IC-NO-NUM.                02273103
           MOVE PARM-IC-NO              TO WS-IC-NO.                    
           MOVE PARM-FIRM-DEMAND-LEVEL  TO WS-FIRM-DEMAND-LEVEL.        
           MOVE WS-FIRM-DEMAND-LEVEL    TO WS-FIRM-DEMAND-NUM.          
                                                                        
           PERFORM 7000-SELECT-INTERRUPT-ACCT THRU 7000-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'N' TO WS-RECORD-EXISTS                              
           ELSE                                                         
              MOVE 'Y' TO WS-RECORD-EXISTS                              
           END-IF.                                                      
                                                                        
           PERFORM 5100-JRNL THRU 5100-EXIT.                            
                                                                        
P00801     IF PARM-UPDATE-STATUS = 'U' OR 'I'                           
              IF WS-RECORD-EXISTS = 'N'                                 
                 PERFORM 8400-INSERT-RECORD THRU 8400-EXIT              
              ELSE                                                      
A00923           PERFORM 8200-UPDATE-RECORD THRU 8200-EXIT              
              END-IF                                                    
           ELSE                                                         
              PERFORM 8300-DELETE-RECORD THRU 8300-EXIT                 
           END-IF.                                                      
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02341400
      *   5100-JRNL                                                    *02341500
      *                                                                *02341600
      *     WRITE MISC. JOURNAL                                        *02341700
      *                                                                *02341800
      ******************************************************************02341900
       5100-JRNL.                                                       
           PERFORM 7100-GET-TIMESTAMP THRU 7100-EXIT.                   
                                                                        
           MOVE WS-F              TO MH-CODE-TRAN-TYPE.                 
           MOVE PARM-RESP-AREA-ID TO MH-RESP-AREA-ID.                   
           MOVE WS-ACCOUNT-NO-NUM TO MH-ACCOUNT-NO.                     
           MOVE ZERO              TO MH-CUSTOMER-NO.                    
           MOVE ZERO              TO MH-PREMISE-NO.                     
           MOVE PARM-USER-ID      TO MH-USER-ID.                        
           MOVE 'PANEL288'        TO MH-APPL-PROGRAM-ID.                
           MOVE +1 TO WS-TRAN-APPL-NO.                                  
                                                                        
           IF PARM-UPDATE-STATUS = 'U'                                  
              IF WS-RECORD-EXISTS = 'Y'                                 
                 PERFORM 5200-JRNL-UPDATE THRU 5200-EXIT                
              ELSE                                                      
                 PERFORM 5400-JRNL-INSERT THRU 5400-EXIT                
              END-IF                                                    
           ELSE                                                         
              PERFORM 5300-JRNL-DELETE THRU 5300-EXIT                   
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02345200
      *   5300-JRNL-DELETE                                             *02345300
      *                                                                *02345400
      *     JOURNAL FOR DELETING EXISTING INTERRUPT_ACCT.              *02345500
      *                                                                *02345600
      ******************************************************************02345700
       5300-JRNL-DELETE.                                                
           MOVE PARM-TRANS-COMMENT-LEN  TO MH-TRAN-COMMENT-LEN.         
           MOVE PARM-TRANS-COMMENT-TEXT                                 
                                TO MH-TRAN-COMMENT-TEXT.                
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE 'CSS_INTERRUPT_ACCT' TO MI-COLUMN-DESC.                 
           MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN.        
      *    MOVE PARM-IC-NO           TO MI-PRV-COLUMN-VALUE-TEXT.       02346603
           MOVE WS-IC-NO             TO MI-PRV-COLUMN-VALUE-TEXT.       
           MOVE +11                  TO MI-CHG-COLUMN-VALUE-LEN.        
           MOVE '**DELETED**'        TO MI-CHG-COLUMN-VALUE-TEXT.       
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02347600
      *   5200-JRNL-UPDATE                                             *02347700
      *                                                                *02347800
      *     JOURNAL FOR UPDATING EXISTING INTERRUPT_ACCT.              *02347900
      *                                                                *02348000
      ******************************************************************02348100
       5200-JRNL-UPDATE.                                                
           MOVE PARM-TRANS-COMMENT-LEN  TO MH-TRAN-COMMENT-LEN.         
           MOVE PARM-TRANS-COMMENT-TEXT                                 
                                TO MH-TRAN-COMMENT-TEXT.                
                                                                        
A00923     IF PARM-TYP-INTRPT-DEMAND EQUAL IP-TYP-INTRPT-DEMAND         
              NEXT SENTENCE                                             
           ELSE                                                         
A00923        MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO       
A00923        MOVE 'MAX_INTRPT_DEMAND'    TO MI-COLUMN-DESC             
A00923        MOVE IP-TYP-INTRPT-DEMAND   TO WS-TYP-DEMAND-DISPLAY      
A00923        MOVE WS-TYP-DEMAND-DISPLAY  TO MI-PRV-COLUMN-VALUE-TEXT   
A00923        MOVE PARM-TYP-INTRPT-DEMAND TO WS-TYP-DEMAND-DISPLAY      
A00923        MOVE WS-TYP-DEMAND-DISPLAY  TO MI-CHG-COLUMN-VALUE-TEXT   
A00923        MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                   
A00923                                    TO MI-PRV-COLUMN-VALUE-LEN    
A00923        MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                   
A00923                                    TO MI-CHG-COLUMN-VALUE-LEN    
A00923        MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
A00923        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
A00923        ADD 1                       TO WS-TRAN-APPL-NO            
A00923     END-IF.                                                      
                                                                        
           IF PARM-USER-ID-ACCT-MGR EQUAL IP-USER-ID-ACCT-MGR           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO       
              MOVE 'USER_ID_ACCT_MGR'     TO MI-COLUMN-DESC             
              MOVE +7                     TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE IP-USER-ID-ACCT-MGR    TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE PARM-USER-ID-ACCT-MGR  TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF PARM-CONTRACT-DATE   EQUAL IP-CONTRACT-DATE               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO         
              MOVE 'CONTRACT_DATE'      TO MI-COLUMN-DESC               
              MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE IP-CONTRACT-DATE     TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE PARM-CONTRACT-DATE   TO MI-CHG-COLUMN-VALUE-TEXT     
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF PARM-CATEGORY         EQUAL IP-CATEGORY                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO       
              MOVE 'CATEGORY'             TO MI-COLUMN-DESC             
              MOVE +2                     TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE IP-CATEGORY            TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE PARM-CATEGORY          TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF WS-FIRM-DEMAND-NUM   EQUAL IP-FIRM-DEMAND-LEVEL           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO       
              MOVE 'FIRM_DEMAND_LEVEL'    TO MI-COLUMN-DESC             
              MOVE +9                     TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE IP-FIRM-DEMAND-LEVEL   TO WS-FIRM-DEMAND-DISPLAY     
              MOVE WS-FIRM-DEMAND-DISPLAY TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE WS-FIRM-DEMAND-NUM     TO WS-FIRM-DEMAND-DISPLAY     
              MOVE WS-FIRM-DEMAND-DISPLAY TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
                                                                        
           IF PARM-CURTAILMENT EQUAL IP-CURTAILMENT-IND                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO         
              MOVE 'CURTAILMENT_IND'    TO MI-COLUMN-DESC               
              MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE IP-CURTAILMENT-IND   TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE PARM-CURTAILMENT     TO MI-CHG-COLUMN-VALUE-TEXT     
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.          
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02366000
      *   5400-JRNL-INSERT                                             *02367000
      *                                                                *02368000
      *     JOURNAL FOR INSERTING EXISTING INTERRUPT_ACCT.             *02369000
      *                                                                *02370000
      ******************************************************************02371000
       5400-JRNL-INSERT.                                                
                                                                        
              MOVE PARM-TRANS-COMMENT-LEN  TO MH-TRAN-COMMENT-LEN.      
              MOVE PARM-TRANS-COMMENT-TEXT                              
                                   TO MH-TRAN-COMMENT-TEXT.             
                                                                        
              MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO       
              MOVE 'CODE_UTIL_TYPE'       TO MI-COLUMN-DESC             
              MOVE +12                    TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE '**INSERTED**'         TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE PARM-CODE-UTIL-TYPE    TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO.                                 
                                                                        
              MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO        
              MOVE 'IC_NO'               TO MI-COLUMN-DESC              
              MOVE +12                   TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +5                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE '**INSERTED**'        TO MI-PRV-COLUMN-VALUE-TEXT    
      *       MOVE PARM-IC-NO            TO MI-CHG-COLUMN-VALUE-TEXT    02374103
              MOVE WS-IC-NO             TO MI-CHG-COLUMN-VALUE-TEXT     
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO.                                 
                                                                        
              MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO       
PCR673        MOVE 'MAX_INTRPT_DEMAND'    TO MI-COLUMN-DESC             
              MOVE '**INSERTED**'         TO MI-PRV-COLUMN-VALUE-TEXT   
A00923        MOVE PARM-TYP-INTRPT-DEMAND TO WS-TYP-DEMAND-DISPLAY      
A00923        MOVE WS-TYP-DEMAND-DISPLAY  TO MI-CHG-COLUMN-VALUE-TEXT   
A00923        MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                   
A00923                                    TO MI-PRV-COLUMN-VALUE-LEN    
A00923        MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                   
A00923                                    TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO.                                 
                                                                        
              MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO        
              MOVE 'USER_ID_ACCT_MGR'    TO MI-COLUMN-DESC              
              MOVE +12                   TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +7                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE '**INSERTED**'        TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE PARM-USER-ID-ACCT-MGR TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO.                                 
                                                                        
              MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO         
              MOVE 'CONTRACT_DATE'      TO MI-COLUMN-DESC               
              MOVE +12                  TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '**INSERTED**'       TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE PARM-CONTRACT-DATE   TO MI-CHG-COLUMN-VALUE-TEXT     
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO.                                 
                                                                        
              MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO       
              MOVE 'CATEGORY'             TO MI-COLUMN-DESC             
              MOVE +12                    TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +2                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE '**INSERTED**'         TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE PARM-CATEGORY          TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO.                                 
                                                                        
              MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO       
              MOVE 'FIRM_DEMAND_LEVEL'    TO MI-COLUMN-DESC             
              MOVE +12                    TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE '**INSERTED**'         TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE PARM-FIRM-DEMAND-LEVEL TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO.                                 
                                                                        
                                                                        
              MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO         
              MOVE 'CURTAILMENT_IND'    TO MI-COLUMN-DESC               
              MOVE +12                  TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE +1                   TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '**INSERTED**'       TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE PARM-CURTAILMENT TO MI-CHG-COLUMN-VALUE-TEXT         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.          
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     02382800
              INCLUDE CPD00067                                          02382900
           END-EXEC.                                                    02383000
                                                                        
       7000-SELECT-INTERRUPT-ACCT.                                      
                                                                        
           MOVE WS-ACCOUNT-NO-NUM   TO IP-ACCOUNT-NO.                   
           MOVE PARM-CODE-UTIL-TYPE TO IP-CODE-UTIL-TYPE.               
      *    MOVE WS-IC-NO-NUM        TO IP-IC-NO.                        02383603
           MOVE PARM-IC-NO          TO IP-IC-NO.                        
                                                                        
           EXEC SQL                                                     
           SELECT TYP_INTRPT_DEMAND,                                    
                  USER_ID_ACCT_MGR,   CONTRACT_DATE,                    
                  CATEGORY,           FIRM_DEMAND_LEVEL,                
                  CURTAILMENT_IND                                       
           INTO   :IP-TYP-INTRPT-DEMAND,                                
                  :IP-USER-ID-ACCT-MGR, :IP-CONTRACT-DATE,              
                  :IP-CATEGORY,         :IP-FIRM-DEMAND-LEVEL,          
                  :IP-CURTAILMENT-IND                                   
           FROM   CSS_INTERRUPT_ACCT WITH(READUNCOMMITTED)                      
           WHERE  ACCOUNT_NO      = :IP-ACCOUNT-NO                      
           AND    CODE_UTIL_TYPE  = :IP-CODE-UTIL-TYPE                  
           AND    IC_NO           = :IP-IC-NO                           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02383900
MFA-TR*    SELECT TYP_INTRPT_DEMAND,                                    02384000
MFA-TR*           USER_ID_ACCT_MGR,   CONTRACT_DATE,                    02384100
MFA-TR*           CATEGORY,           FIRM_DEMAND_LEVEL,                02384200
MFA-TR*           CURTAILMENT_IND                                       02384300
MFA-TR*    INTO   :IP-TYP-INTRPT-DEMAND,                                02384400
MFA-TR*           :IP-USER-ID-ACCT-MGR, :IP-CONTRACT-DATE,              02384500
MFA-TR*           :IP-CATEGORY,         :IP-FIRM-DEMAND-LEVEL,          02384600
MFA-TR*           :IP-CURTAILMENT-IND                                   02384700
MFA-TR*    FROM   CSS_INTERRUPT_ACCT                                    02384800
MFA-TR*    WHERE  ACCOUNT_NO      = :IP-ACCOUNT-NO                      02384900
MFA-TR*    AND    CODE_UTIL_TYPE  = :IP-CODE-UTIL-TYPE                  02385000
MFA-TR*    AND    IC_NO           = :IP-IC-NO                           02385100
MFA-TR*    WITH UR                                                              
MFA-TR*    END-EXEC.                                                    02385200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_INTERRUPT_ACCT' TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE PARM-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2            
      *       MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-3            02386803
              MOVE PARM-IC-NO           TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT
           END-IF.           
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-GET-TIMESTAMP.                                              
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02387600
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP             02387700
MFA-TR*          ,:MH-DATE-TRANS = CURRENT DATE                         02387800
MFA-TR*    END-EXEC.                                                    02388300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7100'              TO ACTIVE-PARAGRAPH              
T35434        MOVE 'SET'               TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
CBSI          MOVE 'CSS_MODEL_SQL'      TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       8200-UPDATE-RECORD.                                              
                                                                        
           MOVE WS-ACCOUNT-NO-NUM     TO IP-ACCOUNT-NO.                 
           MOVE PARM-CODE-UTIL-TYPE   TO IP-CODE-UTIL-TYPE.             
      *    MOVE WS-IC-NO-NUM          TO IP-IC-NO.                      02393503
           MOVE PARM-IC-NO            TO IP-IC-NO.                      
A00923     MOVE PARM-TYP-INTRPT-DEMAND TO IP-TYP-INTRPT-DEMAND.         
           MOVE PARM-USER-ID-ACCT-MGR TO IP-USER-ID-ACCT-MGR.           
           MOVE PARM-CONTRACT-DATE    TO IP-CONTRACT-DATE.              
           MOVE PARM-CATEGORY         TO IP-CATEGORY.                   
           MOVE WS-FIRM-DEMAND-NUM    TO IP-FIRM-DEMAND-LEVEL.          
           MOVE PARM-CURTAILMENT      TO IP-CURTAILMENT-IND.            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_INTERRUPT_ACCT                                 
              SET TYP_INTRPT_DEMAND   =  :IP-TYP-INTRPT-DEMAND,         
                  USER_ID_ACCT_MGR    =  :IP-USER-ID-ACCT-MGR,          
                  CONTRACT_DATE       =  IIF(TRY_CONVERT(DATE, 
                                                      :IP-CONTRACT-DATE
              ) IS NULL OR (PATINDEX('%.%', :IP-CONTRACT-DATE
              ) <> 0) OR (LEN(:IP-CONTRACT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :IP-CONTRACT-DATE
              ), CONVERT(DATE, :IP-CONTRACT-DATE) ),             
                  CATEGORY            =  :IP-CATEGORY,                  
                  FIRM_DEMAND_LEVEL   =  :IP-FIRM-DEMAND-LEVEL,         
                  CURTAILMENT_IND     =  :IP-CURTAILMENT-IND            
              WHERE ACCOUNT_NO        =  :IP-ACCOUNT-NO                 
              AND   CODE_UTIL_TYPE    =  :IP-CODE-UTIL-TYPE             
              AND   IC_NO             =  :IP-IC-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02394400
MFA-TR*       UPDATE CSS_INTERRUPT_ACCT                                 02394500
MFA-TR*       SET TYP_INTRPT_DEMAND   =  :IP-TYP-INTRPT-DEMAND,         02394600
MFA-TR*           USER_ID_ACCT_MGR    =  :IP-USER-ID-ACCT-MGR,          02394700
MFA-TR*           CONTRACT_DATE       =  :IP-CONTRACT-DATE,             02394800
MFA-TR*           CATEGORY            =  :IP-CATEGORY,                  02394900
MFA-TR*           FIRM_DEMAND_LEVEL   =  :IP-FIRM-DEMAND-LEVEL,         02395000
MFA-TR*           CURTAILMENT_IND     =  :IP-CURTAILMENT-IND            02395100
MFA-TR*       WHERE ACCOUNT_NO        =  :IP-ACCOUNT-NO                 02395200
MFA-TR*       AND   CODE_UTIL_TYPE    =  :IP-CODE-UTIL-TYPE             02395300
MFA-TR*       AND   IC_NO             =  :IP-IC-NO                      02395400
MFA-TR*    END-EXEC.                                                    02395500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_INTERRUPT_ACCT'  TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
CBSI          MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1           
              MOVE PARM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2           
      *       MOVE WS-IC-NO-NUM          TO HOSTVAR-ELEMENT-3           02397003
              MOVE  PARM-IC-NO           TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-DELETE-RECORD.                                              
           EXEC SQL                                                     
               DELETE FROM CSS_INTERRUPT_ACCT                           
               WHERE ACCOUNT_NO        =  :WS-ACCOUNT-NO-NUM            
               AND   CODE_UTIL_TYPE    =  :PARM-CODE-UTIL-TYPE          
      *        AND   IC_NO             =  :WS-IC-NO-NUM                 02398203
               AND   IC_NO             =  :PARM-IC-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '8300'                TO ACTIVE-PARAGRAPH           
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_INTERRUPT_ACCT'  TO TABLE-1                    
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
CBSI           MOVE 'IC_NO'               TO TABLE-ELEMENT-3            
               MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1          
               MOVE PARM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2          
      *        MOVE WS-IC-NO-NUM          TO HOSTVAR-ELEMENT-3          02399903
               MOVE  PARM-IC-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.         
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-INSERT-RECORD.                                              
                                                                        
           MOVE WS-ACCOUNT-NO-NUM     TO IP-ACCOUNT-NO,                 
           MOVE PARM-CODE-UTIL-TYPE   TO IP-CODE-UTIL-TYPE,             
      *    MOVE WS-IC-NO-NUM          TO IP-IC-NO.                      02401003
           MOVE PARM-IC-NO            TO IP-IC-NO.                      
A00923     MOVE PARM-TYP-INTRPT-DEMAND TO IP-TYP-INTRPT-DEMAND.         
           MOVE PARM-USER-ID-ACCT-MGR TO IP-USER-ID-ACCT-MGR.           
           MOVE PARM-CONTRACT-DATE    TO IP-CONTRACT-DATE.              
           MOVE PARM-CATEGORY         TO IP-CATEGORY.                   
           MOVE WS-FIRM-DEMAND-NUM    TO IP-FIRM-DEMAND-LEVEL.          
           MOVE PARM-CURTAILMENT      TO IP-CURTAILMENT-IND.            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_INTERRUPT_ACCT                            
              (ACCOUNT_NO,       CODE_UTIL_TYPE,                        
               IC_NO,            TYP_INTRPT_DEMAND,                     
               USER_ID_ACCT_MGR, CONTRACT_DATE,                         
               CATEGORY,         FIRM_DEMAND_LEVEL,                     
               CURTAILMENT_IND)                                         
                                                                        
               VALUES                                                   
               (:IP-ACCOUNT-NO,        :IP-CODE-UTIL-TYPE,              
                :IP-IC-NO,             :IP-TYP-INTRPT-DEMAND,           
                :IP-USER-ID-ACCT-MGR,  IIF(TRY_CONVERT(DATE, 
                                                      :IP-CONTRACT-DATE
              ) IS NULL OR (PATINDEX('%.%', :IP-CONTRACT-DATE
              ) <> 0) OR (LEN(:IP-CONTRACT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :IP-CONTRACT-DATE
              ), CONVERT(DATE, :IP-CONTRACT-DATE) ),               
                :IP-CATEGORY,          :IP-FIRM-DEMAND-LEVEL,           
                :IP-CURTAILMENT-IND)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02401900
MFA-TR*       INSERT INTO CSS_INTERRUPT_ACCT                            02402000
MFA-TR*       (ACCOUNT_NO,       CODE_UTIL_TYPE,                        02402100
MFA-TR*        IC_NO,            TYP_INTRPT_DEMAND,                     02402200
MFA-TR*        USER_ID_ACCT_MGR, CONTRACT_DATE,                         02402300
MFA-TR*        CATEGORY,         FIRM_DEMAND_LEVEL,                     02402400
MFA-TR*        CURTAILMENT_IND)                                         02402500
MFA-TR*                                                                 02402600
MFA-TR*        VALUES                                                   02402700
MFA-TR*        (:IP-ACCOUNT-NO,        :IP-CODE-UTIL-TYPE,              02402800
MFA-TR*         :IP-IC-NO,             :IP-TYP-INTRPT-DEMAND,           02402900
MFA-TR*         :IP-USER-ID-ACCT-MGR,  :IP-CONTRACT-DATE,               02403000
MFA-TR*         :IP-CATEGORY,          :IP-FIRM-DEMAND-LEVEL,           02403100
MFA-TR*         :IP-CURTAILMENT-IND)                                    02403200
MFA-TR*    END-EXEC.                                                    02403300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '8400'                TO ACTIVE-PARAGRAPH           
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_INTERRUPT_ACCT'  TO TABLE-1                    
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
CBSI           MOVE 'IC_NO'               TO TABLE-ELEMENT-3            
CBSI           MOVE 'CONTRACT_DATE'       TO TABLE-ELEMENT-4            
               MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1          
               MOVE PARM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2          
      *        MOVE WS-IC-NO-NUM          TO HOSTVAR-ELEMENT-3          02404803
               MOVE PARM-IC-NO            TO HOSTVAR-ELEMENT-3          
CBSI           MOVE PARM-CONTRACT-DATE    TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.         
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02405600
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *02405700
      ******************************************************************02405800
           EXEC SQL                                                     02405900
              INCLUDE CPDSP300                                          02406000
           END-EXEC.                                                    02406100
                                                                        
      ******************************************************************02406300
      *       END PROGRAM COPYLIB                                      *02406400
      ******************************************************************02407000
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
