       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR01700.                                          
       AUTHOR.       Covansys.                                          
       DATE-WRITTEN. May 2007.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *    - This Module Returns the WhiteCross or Priority Customers  *        
      *      details.                                                  *        
      *    - Execustes via CSR Desktop.                                *        
      *    - Panel # 940 and 948.                                      *        
      ******************************************************************        
      *                                                                *        
      *                     Program Modification Log                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------- *        
      *  05/18/2007  VP94820  Re-written as SPCB from SPDB.            *        
T32547*  09/13/2007  VV94890  ADDED WHITE CROSS PLUS(WP) &             *        
      *                       White Cross/Plus(WX) for CODE_CRIT_OUTAGE*        
T37261*  09MAY08     MK92804  Renaming DCLGEN's from STB to TB         *        
T37261*                       and added with ur to avoid -911 abends.  *        
      *  09/03/2008  DB18339  Fixed full name column to reflect new    *        
      *                       column lengths in CSS_NAME               *        
C33743*  08/29/2008  SC41135  POINTID PROJECT - REPLACE SNE_POINT TABLE*        
C33743*                       WITH CSS_PIM_POINT                       *        
A02103*  01/28/2010  DB18339  CHANGED NOT-FOUND CODE FOR WORK NUMBER   *        
P00436*  09/09/2010  SC41135  PRIORITY CUSTLIST PANEL ENHANCEMENTS     *        
      ******************************************************************        
      *                                                                *        
      *                ---- Basic Sequence Structure ----              *        
      *                                                                *        
      *         0000 - 0999     Main Control Path and Initialization   *        
      *         1000 - 1999     Input Processing Control Path          *        
      *         2000 - 2999     Output Processing Control Path         *        
      *         5000 - 5999     Common Modules                         *        
      *         7000 - 7999     Database Access / Input Modules        *        
      *         8000 - 8999     Output Modules                         *        
      *         9000 - 9799     Termination Modules                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR01700'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                        PIC X(40)  VALUE              
           'WORKING STORAGE FOR CSR01700 STARTS HERE'.                  
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE            PIC S9(9) COMP VALUE 0.          
           05 S-WORK-AREA-ID           PIC X(12).                       
           05 S-WORK-AREA-TX           PIC X(40).                       
           05 S-AREA-ID                PIC X(03).                       
           05 S-AREA-TX                PIC X(32).                       
           05 S-REGION-ID              PIC X(03).                       
           05 S-REGION-TX              PIC X(32).                       
           05 S-SUBSTATION-ID          PIC X(05).                       
           05 S-CIRCUIT-ID             PIC X(05).                       
           05 S-SECTION-NM             PIC X(06).                       
           05 S-TAP-FUSE-ID            PIC X(03).                       
           05 S-DEVICE-NM              PIC X(10).                       
COB305     05 S-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.              
COB305     05 S-CUSTOMER-NO        PIC S9(10)V COMP-3 VALUE 0.              
COB305     05 S-ADDRESS-ID        PIC S9(13)V COMP-3 VALUE 0.              
COB305     05 S-PREMISE-NO        PIC S9(10)V COMP-3 VALUE 0.              
COB305     05 S-NAME-ID        PIC S9(13)V COMP-3 VALUE 0.              
           05 S-FULL-NAME              PIC X(70).                       
           05 S-HOME-PHONE             PIC X(16).                       
           05 S-WORK-PHONE             PIC X(16).                       
           05 S-ADDRESS                PIC X(58).                       
           05 S-POINT-ID               PIC S9(9) COMP.                  
P00436*    05 S-CODE-UTIL-TYPE         PIC X(01).                               
           05 S-CODE-METER-STATUS      PIC X(01).                       
           05 S-TITLE                  PIC X(30).                       
P00436     05 S-CODE-CRIT-OUTAGE       PIC X(02).                       
      *                                                                         
       01 WS-MISC.                                                      
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR01700'.      
           05 WS-SQLSTATE              PIC X(05) VALUE SPACES.          
           05 WS-SELECT-FL             PIC X(02).                       
           05 WS-ADDRESS               PIC X(58).                       
           05 WS-TITLE                 PIC X(30).                       
           05 WS-SUBSTN-ID             PIC X(05).                       
           05 WS-CIRCT-ID              PIC X(05).                       
           05 WS-REG-ID                PIC X(03).                       
           05 WS-AREA                  PIC X(03).                       
P00436     05 WS-CODE-CRIT-OUTAGE      PIC X(02).                       
           05 WS-WK-AREA-ID            PIC X(12).                       
           05 WS-GIS-POINT-ID          PIC S9(9) COMP.                  
           05 WS-GIS-POINT-ID-PREV     PIC S9(9) COMP.                  
P00436     05 WS-ACCOUNT-NO-PREV       PIC S9(13) COMP.                 
C33743     05 WS-DEVICE-NM             PIC X(10).                       
           05 WS-PREV-CHAR             PIC X(01) VALUE SPACES.          
           05 WS-ACCT-NO               PIC X(13).                       
           05 WS-ACCT-NO-NM            REDEFINES WS-ACCT-NO             
                                       PIC 9(13).                       
COB305     05 WS-ACCT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.              
                                                                        
           05 WS-CUST-NUM              PIC X(10).                       
           05 WS-CUST-NUM-NM           REDEFINES WS-CUST-NUM            
                                       PIC 9(10).                       
           05 WS-CUST-NUM-COMP3        PIC S9(10) COMP-3 VALUE +0.      
      *                                                                         
       01 WS-NAME-TABLES.                                               
          05 WS-FIRST-NAME.                                             
             10 WS-FIRST-CHAR          PIC X(01)                        
                            OCCURS 15 TIMES INDEXED BY WS-IDX-F.        
          05 WS-MIDDLE-NAME.                                            
             10 WS-MIDDLE-CHAR         PIC X(01)                        
                            OCCURS 15 TIMES INDEXED BY WS-IDX-M.        
          05 WS-LAST-NAME.                                              
             10 WS-LAST-CHAR           PIC X(01)                        
                            OCCURS 40 TIMES INDEXED BY WS-IDX-L.        
          05 WS-FULL-NAME.                                              
             10 WS-FULL-CHAR           PIC X(01)                        
                            OCCURS 70 TIMES INDEXED BY WS-IDX-N.        
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05 WS-FORMAT                PIC X(01) VALUE 'N'.             
              88 FORMAT-DONE                     VALUE 'Y'.             
           05 WS-NO-MORE-RECS          PIC X(01) VALUE 'N'.             
              88 NO-MORE-ROWS                    VALUE 'Y'.             
              88 MORE-ROWS                       VALUE 'N'.             
      *                                                                         
      ******************************************************************        
      * Indicator Variables.                                           *        
      ******************************************************************        
      *                                                                         
       01 WS-IND-VARIABLES.                                             
           05 WS-NULL-IND-1            PIC S9(4) COMP.                  
           05 WS-NULL-IND-2            PIC S9(4) COMP.                  
           05 WS-NULL-IND-3            PIC S9(4) COMP.                  
           05 WS-NULL-IND-4            PIC S9(4) COMP.                  
                                                                        
      ******************************************************************        
      * SQL Error Checking Copy Books.                                 *        
      ******************************************************************        
                                                                        
      *01  WS-WARNING-DATA-ELEMENTS.                                            
           COPY CWS00303.                                                       
                                                                        
      *01  CSRERLOG-P.                                                          
           COPY CWSSP001.                                                       
                                                                        
      ******************************************************************        
      * Working Storage for Procedure Division Copy Books              *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      * DB2 Includes                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    AT - CSS_ACCOUNT                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    MN - CSS_MTRD_ENVRNMT                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    C8 - CSS_DELINQUENCY                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    HT - CSS_NAME_ACCT_XREF                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    QH - CSS_OP_REGION                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPREGN                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    QG - CSS_OP_AREA                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPAREA                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    AG - CSS_WORK_AREA_MATL                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBWKMATL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    I2 - CSS_WORK_AREA                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
T37261        INCLUDE  TBWKAR                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    UQ - CSS_CIRCUIT                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCIRCUT                                                  
           END-EXEC.                                                            
      *                                                                         
C33743******************************************************************        
C33743*    PP - CSS_PIM_POINT                                          *        
C33743******************************************************************        
      *                                                                         
C33743     EXEC SQL                                                             
C33743        INCLUDE TBPIMPNT                                                  
C33743     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DQ - CSS_NAME                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CB - CSS_CUST_PHONE                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DY - CSS_ADDR_FORMATTED                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    A4 - CSS_ZIP_CODE                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Error Handling Copy Book.                                      *        
      ******************************************************************        
      *                                                                         
      *01  ABEND-FILE.                                                          
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Cursor for selecting all the white cross customers.            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE ACCOUNT_NUM_WC CURSOR FOR                       
                SELECT                                                  
                        HT.ACCOUNT_NO                                   
                       ,HT.CUSTOMER_NO                                  
                       ,HT.PREMISE_NO                                   
                       ,MN.CODE_METER_STATUS                            
                       ,MN.GIS_POINT_ID                                 
                       ,HT.ADDRESS_ID                                   
                       ,HT.NAME_ID                                      
P00436                 ,AT.CODE_CRIT_OUTAGE                             
                  FROM                                                  
                        CSS_ACCOUNT        AT WITH(READUNCOMMITTED)             
                       ,CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)             
                       ,CSS_MTRD_ENVRNMT   MN WITH(READUNCOMMITTED)             
P00436                 ,CSS_NAME           DQ WITH(READUNCOMMITTED)             
                WHERE                                                   
                        MN.CODE_UTIL_TYPE       = 'E'                   
                  AND   MN.CODE_METER_STATUS    IN ('A','B','I')        
                  AND   MN.ACCOUNT_NO           = AT.ACCOUNT_NO         
T32547            AND   AT.CODE_CRIT_OUTAGE     IN ('WC','WX')          
                  AND   AT.CODE_ACCT_STAT       IN ('A','P')            
                  AND   AT.ACCOUNT_NO           = HT.ACCOUNT_NO         
                  AND   HT.CUSTOMER_ROLE_CD     = ' '                   
P00436            AND   HT.NAME_ID              = DQ.NAME_ID            
P00436            AND   DQ.NAME_TYPE            = 'CN'                  
                  ORDER BY MN.GIS_POINT_ID                              
                  FOR READ ONLY                                        
                                                                 
P00436                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE ACCOUNT_NUM_WC CURSOR FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*                 HT.ACCOUNT_NO                                           
MFA-TR*                ,HT.CUSTOMER_NO                                          
MFA-TR*                ,HT.PREMISE_NO                                           
MFA-TR*                ,MN.CODE_METER_STATUS                                    
MFA-TR*                ,MN.GIS_POINT_ID                                         
MFA-TR*                ,HT.ADDRESS_ID                                           
MFA-TR*                ,HT.NAME_ID                                              
MFA-TR*                ,AT.CODE_CRIT_OUTAGE                                     
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_ACCOUNT        AT                                   
MFA-TR*                ,CSS_NAME_ACCT_XREF HT                                   
MFA-TR*                ,CSS_MTRD_ENVRNMT   MN                                   
MFA-TR*                ,CSS_NAME           DQ                                   
MFA-TR*         WHERE                                                           
MFA-TR*                 MN.CODE_UTIL_TYPE       = 'E'                           
MFA-TR*           AND   MN.CODE_METER_STATUS    IN ('A','B','I')                
MFA-TR*           AND   MN.ACCOUNT_NO           = AT.ACCOUNT_NO                 
MFA-TR*           AND   AT.CODE_CRIT_OUTAGE     IN ('WC','WX')                  
MFA-TR*           AND   AT.CODE_ACCT_STAT       IN ('A','P')                    
MFA-TR*           AND   AT.ACCOUNT_NO           = HT.ACCOUNT_NO                 
MFA-TR*           AND   HT.CUSTOMER_ROLE_CD     = ' '                           
MFA-TR*           AND   HT.NAME_ID              = DQ.NAME_ID                    
MFA-TR*           AND   DQ.NAME_TYPE            = 'CN'                          
MFA-TR*           ORDER BY MN.GIS_POINT_ID                                      
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7110                                                  
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Cursor for selecting all the priority customers.               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                DECLARE ACCOUNT_NUM_PR CURSOR FOR                       
                SELECT                                                  
                        HT.ACCOUNT_NO                                   
                       ,HT.CUSTOMER_NO                                  
                       ,HT.PREMISE_NO                                   
                       ,MN.CODE_METER_STATUS                            
                       ,MN.GIS_POINT_ID                                 
                       ,HT.ADDRESS_ID                                   
                       ,HT.NAME_ID                                      
                       ,AT.CODE_CRIT_OUTAGE                             
                  FROM                                                  
                        CSS_ACCOUNT        AT WITH(READUNCOMMITTED)             
                       ,CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)             
                       ,CSS_MTRD_ENVRNMT   MN WITH(READUNCOMMITTED)             
P00436                 ,CSS_NAME           DQ WITH(READUNCOMMITTED)             
                WHERE                                                   
                        MN.CODE_UTIL_TYPE       = 'E'                   
                  AND   MN.CODE_METER_STATUS    IN ('A','B','I')        
                  AND   MN.ACCOUNT_NO           = AT.ACCOUNT_NO         
                  AND  (AT.CODE_CRIT_OUTAGE NOT IN ('WC','WX','WP',' ') 
P00436            AND   AT.CODE_CRIT_OUTAGE   LIKE :WS-CODE-CRIT-OUTAGE)
                  AND   AT.CODE_ACCT_STAT       IN ('A','P')            
                  AND   AT.ACCOUNT_NO           = HT.ACCOUNT_NO         
                  AND   HT.CUSTOMER_ROLE_CD     = ' '                   
P00436            AND   HT.NAME_ID              = DQ.NAME_ID            
P00436            AND   DQ.NAME_TYPE            = 'CN'                  
P00436*           ORDER BY MN.GIS_POINT_ID                                      
                  FOR READ ONLY                                        
                                                                 
P00436                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE ACCOUNT_NUM_PR CURSOR FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*                 HT.ACCOUNT_NO                                           
MFA-TR*                ,HT.CUSTOMER_NO                                          
MFA-TR*                ,HT.PREMISE_NO                                           
MFA-TR*                ,MN.CODE_METER_STATUS                                    
MFA-TR*                ,MN.GIS_POINT_ID                                         
MFA-TR*                ,HT.ADDRESS_ID                                           
MFA-TR*                ,HT.NAME_ID                                              
MFA-TR*                ,AT.CODE_CRIT_OUTAGE                                     
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_ACCOUNT        AT                                   
MFA-TR*                ,CSS_NAME_ACCT_XREF HT                                   
MFA-TR*                ,CSS_MTRD_ENVRNMT   MN                                   
MFA-TR*                ,CSS_NAME           DQ                                   
MFA-TR*         WHERE                                                           
MFA-TR*                 MN.CODE_UTIL_TYPE       = 'E'                           
MFA-TR*           AND   MN.CODE_METER_STATUS    IN ('A','B','I')                
MFA-TR*           AND   MN.ACCOUNT_NO           = AT.ACCOUNT_NO                 
MFA-TR*           AND  (AT.CODE_CRIT_OUTAGE NOT IN ('WC','WX','WP',' ')         
MFA-TR*           AND   AT.CODE_CRIT_OUTAGE   LIKE :WS-CODE-CRIT-OUTAGE)        
MFA-TR*           AND   AT.CODE_ACCT_STAT       IN ('A','P')                    
MFA-TR*           AND   AT.ACCOUNT_NO           = HT.ACCOUNT_NO                 
MFA-TR*           AND   HT.CUSTOMER_ROLE_CD     = ' '                           
MFA-TR*           AND   HT.NAME_ID              = DQ.NAME_ID                    
MFA-TR*           AND   DQ.NAME_TYPE            = 'CN'                          
MFA-TR*           ORDER BY MN.GIS_POINT_ID                                      
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7140                                                  
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  I-REGION-ID      PIC X(3).                                   
       01  I-AREA-ID        PIC X(3).                                   
       01  I-WORK-AREA-ID   PIC X(12).                                  
       01  I-SUBSTN-ID      PIC X(5).                                   
       01  I-CIRCUIT-ID     PIC X(5).                                   
       01  I-SELECT-FL      PIC X(2).                                   
P00436 01  I-CODE-CRIT-OUTAGE  PIC X(2).                                
      *                                                                         
       PROCEDURE DIVISION USING  I-REGION-ID                            
                                 I-AREA-ID                              
                                 I-WORK-AREA-ID                         
                                 I-SUBSTN-ID                            
                                 I-CIRCUIT-ID                           
                                 I-SELECT-FL                            
P00436                           I-CODE-CRIT-OUTAGE.                    
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      * Controls the Main Processing of the Program.                   *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           IF CTR-ROWS = 0                                              
              ADD +1  TO CTR-ROWS                                       
           END-IF.                                                      
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION.                                           *        
      * Initialize Return Fields, Declare GTT and Result Set Cursor.   *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
           PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
      *                                                                         
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                    WORK_AREA_ID                                        
                   ,WORK_AREA_TX                                        
                   ,AREA_ID                                             
                   ,AREA_TX                                             
                   ,REGION_ID                                           
                   ,REGION_TX                                           
                   ,SUBSTATION_ID                                       
                   ,CIRCUIT_ID                                          
                   ,SECTION_NM                                          
                   ,TAP_FUSE_ID                                         
                   ,DEVICE_NM                                           
                   ,ACCOUNT_NO                                          
                   ,CUSTOMER_NO                                         
                   ,ADDRESS_ID                                          
                   ,PREMISE_NO                                          
                   ,NAME_ID                                             
                   ,FULL_NAME                                           
                   ,HOME_PHONE                                          
                   ,WORK_PHONE                                          
                   ,ADDRESS                                             
                   ,POINT_ID                                            
P00436*            ,CODE_UTIL_TYPE                                              
                   ,CODE_METER_STATUS                                   
                   ,TITLE                                               
P00436             ,CODE_CRIT_OUTAGE                                    
              FROM                                                      
                   #CSR01700_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*             WORK_AREA_ID                                                
MFA-TR*            ,WORK_AREA_TX                                                
MFA-TR*            ,AREA_ID                                                     
MFA-TR*            ,AREA_TX                                                     
MFA-TR*            ,REGION_ID                                                   
MFA-TR*            ,REGION_TX                                                   
MFA-TR*            ,SUBSTATION_ID                                               
MFA-TR*            ,CIRCUIT_ID                                                  
MFA-TR*            ,SECTION_NM                                                  
MFA-TR*            ,TAP_FUSE_ID                                                 
MFA-TR*            ,DEVICE_NM                                                   
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,CUSTOMER_NO                                                 
MFA-TR*            ,ADDRESS_ID                                                  
MFA-TR*            ,PREMISE_NO                                                  
MFA-TR*            ,NAME_ID                                                     
MFA-TR*            ,FULL_NAME                                                   
MFA-TR*            ,HOME_PHONE                                                  
MFA-TR*            ,WORK_PHONE                                                  
MFA-TR*            ,ADDRESS                                                     
MFA-TR*            ,POINT_ID                                                    
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,CODE_METER_STATUS                                           
MFA-TR*            ,TITLE                                                       
MFA-TR*            ,CODE_CRIT_OUTAGE                                            
MFA-TR*       FROM                                                              
MFA-TR*            SESSION.CSR01700_R1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT.                                            *         
      * Declare Global Temporary Table for holding result set.         *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR01700_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR01700_R1
              (                                                      
                    WORK_AREA_ID CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,WORK_AREA_TX CHAR(40)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,AREA_ID CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2            
                   ,AREA_TX CHAR(32)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,REGION_ID CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,REGION_TX CHAR(32)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,SUBSTATION_ID CHAR(5)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CIRCUIT_ID CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,SECTION_NM CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,TAP_FUSE_ID CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,DEVICE_NM CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,ACCOUNT_NO         DECIMAL(13,0)                    
                   ,CUSTOMER_NO        DECIMAL(10,0)                    
                   ,ADDRESS_ID         DECIMAL(13,0)                    
                   ,PREMISE_NO         DECIMAL(10,0)                    
                   ,NAME_ID            DECIMAL(13,0)                    
                   ,FULL_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,HOME_PHONE CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,WORK_PHONE CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,ADDRESS CHAR(58)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,POINT_ID           INT                          
P00436*            ,CODE_UTIL_TYPE     CHAR(1)                                  
                   ,CODE_METER_STATUS CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,TITLE CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2             
P00436             ,CODE_CRIT_OUTAGE CHAR(2)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSR01700_R1'         TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      * Validates all the input parameters.                            *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE I-REGION-ID              TO WS-REG-ID.                  
           MOVE I-AREA-ID                TO WS-AREA.                    
           MOVE I-WORK-AREA-ID           TO WS-WK-AREA-ID.              
           MOVE I-SUBSTN-ID              TO WS-SUBSTN-ID.               
           MOVE I-CIRCUIT-ID             TO WS-CIRCT-ID.                
P00436     MOVE I-CODE-CRIT-OUTAGE       TO WS-CODE-CRIT-outage.        
           MOVE I-SELECT-FL              TO WS-SELECT-FL.               
      *                                                                         
           IF WS-REG-ID = SPACES OR WS-REG-ID = 'ALL'                   
              MOVE '%%%'                 TO WS-REG-ID                   
           END-IF.                                                      
      *                                                                         
           IF WS-AREA    = SPACES                                       
              MOVE '%%%'                 TO WS-AREA                     
           END-IF.                                                      
      *                                                                         
           IF WS-WK-AREA-ID = SPACES                                    
              MOVE '%%%%%%%%%%%%'        TO WS-WK-AREA-ID               
           END-IF.                                                      
      *                                                                         
           IF WS-SUBSTN-ID  = SPACES                                    
              MOVE '%%%%%'               TO WS-SUBSTN-ID                
           END-IF.                                                      
      *                                                                         
           IF WS-CIRCT-ID = SPACES                                      
              MOVE '%%%%%'               TO WS-CIRCT-ID                 
           END-IF.                                                      
                                                                        
P00436     IF WS-CODE-CRIT-outage = SPACES                              
P00436        MOVE '%%'                  TO WS-CODE-CRIT-OUTAGE         
P00436     END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      * Gets all the required info and formats result set.             *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           IF WS-SELECT-FL = 'WC'                                       
              MOVE 'WHITE CROSS CUSTOMERS LIST'   TO    WS-TITLE        
              PERFORM 7100-OPEN-ACCOUNT-NUM-WC    THRU  7100-EXIT       
              PERFORM 7110-FETCH-ACCOUNT-NUM-WC   THRU  7110-EXIT       
              PERFORM 2100-PROCESS-ACCOUNT-NUM    THRU  2100-EXIT       
                                                  UNTIL NO-MORE-ROWS    
              PERFORM 7120-CLOSE-ACCOUNT-NUM-WC   THRU  7120-EXIT       
           ELSE                                                         
              MOVE 'PRIORITY CUSTOMERS LIST'      TO    WS-TITLE        
              PERFORM 7130-OPEN-ACCOUNT-NUM-PR    THRU  7130-EXIT       
              PERFORM 7140-FETCH-ACCOUNT-NUM-PR   THRU  7140-EXIT       
              PERFORM 2100-PROCESS-ACCOUNT-NUM    THRU  2100-EXIT       
                                                  UNTIL NO-MORE-ROWS    
              PERFORM 7150-CLOSE-ACCOUNT-NUM-PR   THRU  7150-EXIT       
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      * Prepares Result Set Row.                                       *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE QH-REGION-ID                TO S-REGION-ID.             
           MOVE QH-REGION-TX                TO S-REGION-TX.             
           MOVE QG-AREA-ID                  TO S-AREA-ID.               
           MOVE QG-AREA-TX                  TO S-AREA-TX.               
           MOVE I2-WORK-AREA-ID             TO S-WORK-AREA-ID.          
           MOVE I2-WORK-AREA-TX             TO S-WORK-AREA-TX.          
           MOVE UQ-SUBSTATION-ID            TO S-SUBSTATION-ID.         
           MOVE UQ-CIRCUIT-ID               TO S-CIRCUIT-ID.            
           IF WS-NULL-IND-1 = -1                                        
              MOVE ' '                      TO S-DEVICE-NM              
           ELSE                                                         
C33743        MOVE WS-DEVICE-NM             TO S-DEVICE-NM              
           END-IF.                                                      
           IF WS-NULL-IND-2 = -1                                        
              MOVE ' '                      TO S-SECTION-NM             
           ELSE                                                         
C33743        MOVE PP-GRID-CELL-TX(1:6)        TO S-SECTION-NM          
           END-IF.                                                      
           IF WS-NULL-IND-3 = -1                                        
              MOVE ' '                      TO S-TAP-FUSE-ID            
           ELSE                                                         
C33743        MOVE PP-GRID-CELL-TX(7:3)        TO S-TAP-FUSE-ID         
           END-IF.                                                      
           MOVE MN-GIS-POINT-ID             TO S-POINT-ID.              
           MOVE HT-ACCOUNT-NO               TO S-ACCOUNT-NO.            
           MOVE HT-CUSTOMER-NO              TO S-CUSTOMER-NO.           
           MOVE HT-PREMISE-NO               TO S-PREMISE-NO.            
P00436*    MOVE 'E'                         TO S-CODE-UTIL-TYPE.                
           MOVE MN-CODE-METER-STATUS        TO S-CODE-METER-STATUS.     
           MOVE HT-ADDRESS-ID               TO S-ADDRESS-ID.            
           MOVE HT-NAME-ID                  TO S-NAME-ID.               
           MOVE WS-ADDRESS                  TO S-ADDRESS.               
           MOVE WS-TITLE                    TO S-TITLE.                 
P00436     MOVE AT-CODE-CRIT-OUTAGE         TO S-CODE-CRIT-OUTAGE.      
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * 2100-PROCESS-ACCOUNT-NUM.                                      *        
      * Process to get the account info related to those account_no    *        
      ******************************************************************03560000
      *                                                                         
       2100-PROCESS-ACCOUNT-NUM.                                        
      *                                                                         
           IF MN-GIS-POINT-ID = WS-GIS-POINT-ID-PREV                    
              CONTINUE                                                  
           ELSE                                                         
P00436        MOVE MN-GIS-POINT-ID     TO WS-GIS-POINT-ID               
              PERFORM 7160-GET-POINT-DETAILS   THRU  7160-EXIT          
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 GO TO NO-POINT                                         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE HT-NAME-ID                  TO    DQ-NAME-ID.           
                                                                        
P00436     IF HT-ACCOUNT-NO = WS-ACCOUNT-NO-PREV THEN                   
P00436        GO TO NO-POINT                                            
P00436     END-IF                                                       
                                                                        
           PERFORM 7170-GET-CUST-NAME       THRU  7170-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              GO TO NO-POINT                                            
           END-IF                                                       
           MOVE SPACES                      TO WS-FULL-NAME             
           IF DQ-FIRST-NAME <= SPACES                                   
              MOVE DQ-FULL-NAME             TO S-FULL-NAME              
           ELSE                                                         
              MOVE DQ-FIRST-NAME            TO WS-FIRST-NAME            
              MOVE SPACES                   TO WS-MIDDLE-NAME           
              MOVE DQ-LAST-NAME             TO WS-LAST-NAME             
              MOVE 'N'                      TO WS-FORMAT                
              PERFORM 5000-REFORMAT-NAME    THRU 5000-EXIT              
              MOVE WS-FULL-NAME             TO S-FULL-NAME              
           END-IF                                                       
           MOVE HT-ADDRESS-ID               TO    DY-ADDRESS-ID.        
           PERFORM 7180-GET-CUST-ADDR       THRU  7180-EXIT.            
           MOVE HT-CUSTOMER-NO              TO    CB-CUSTOMER-NO.       
           PERFORM 7190-GET-CUST-PRI-PH     THRU  7190-EXIT.            
           MOVE HT-CUSTOMER-NO              TO    CB-CUSTOMER-NO.       
           PERFORM 7200-GET-CUST-WORK-PH    THRU  7200-EXIT.            
      *                                                                         
           PERFORM 2000A-MOVE-RESULT        THRU  2000A-EXIT.           
           PERFORM 8100-SEND-RESULT         THRU  8100-EXIT.            
       NO-POINT.                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           IF WS-SELECT-FL = 'WC'                                       
              PERFORM 7110-FETCH-ACCOUNT-NUM-WC   THRU  7110-EXIT       
           ELSE                                                         
              PERFORM 7140-FETCH-ACCOUNT-NUM-PR   THRU  7140-EXIT       
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5000-REFORMAT-NAME.                                            *        
      * Formats the Name as follows (Last, First Middle)               *03500000
      ******************************************************************        
      *                                                                         
       5000-REFORMAT-NAME.                                              
      *                                                                         
           MOVE SPACES                                TO WS-PREV-CHAR.  
           SET WS-IDX-N, WS-IDX-F, WS-IDX-M, WS-IDX-L TO 1.             
      *                                                                         
           PERFORM UNTIL (WS-IDX-L > 40 OR FORMAT-DONE)                 
              IF (WS-LAST-CHAR(WS-IDX-L) = SPACE OR LOW-VALUES          
                                              OR HIGH-VALUES)           
                AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES) 
                IF WS-IDX-N > 1                                         
                   SET WS-IDX-N DOWN BY 1                               
                   MOVE ','                   TO WS-FULL-CHAR(WS-IDX-N) 
                   SET WS-IDX-N UP BY 1                                 
                END-IF                                                  
                MOVE 'Y'                      TO WS-FORMAT              
              ELSE                                                      
                MOVE WS-LAST-CHAR(WS-IDX-L)   TO WS-FULL-CHAR(WS-IDX-N) 
                                                 WS-PREV-CHAR           
                SET WS-IDX-L, WS-IDX-N UP BY 1                          
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           MOVE SPACES                        TO WS-PREV-CHAR.          
      *                                                                         
           PERFORM UNTIL WS-IDX-F > 15                                  
              IF (WS-FIRST-CHAR(WS-IDX-F) = SPACE OR LOW-VALUES OR      
                                                     HIGH-VALUES)       
                 AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES)
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE WS-FIRST-CHAR(WS-IDX-F) TO WS-FULL-CHAR(WS-IDX-N) 
                                                 WS-PREV-CHAR           
                 SET WS-IDX-F, WS-IDX-N UP BY 1                         
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           MOVE SPACES                        TO WS-PREV-CHAR.          
      *                                                                         
           PERFORM UNTIL WS-IDX-M > 15                                  
              IF (WS-MIDDLE-CHAR(WS-IDX-M) = SPACE OR LOW-VALUES OR     
                                                   HIGH-VALUES)         
                AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES) 
                NEXT SENTENCE                                           
              ELSE                                                      
                MOVE WS-MIDDLE-CHAR(WS-IDX-M) TO WS-FULL-CHAR(WS-IDX-N) 
                                                 WS-PREV-CHAR           
                SET WS-IDX-M, WS-IDX-N UP BY 1                          
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************03490000
      * 7100-OPEN-ACCOUNT-NUM-WC.                                      *        
      * Opens the ACCOUNT_NUM_WC CURSOR.                               *        
      ******************************************************************03560000
      *                                                                         
       7100-OPEN-ACCOUNT-NUM-WC.                                        
      *                                                                         
           EXEC SQL                                                     
                OPEN ACCOUNT_NUM_WC                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7100'                 TO ACTIVE-PARAGRAPH           
              MOVE 'OPEN'                 TO ABEND-FUNCTION             
              MOVE 'ACCOUNT_NUM_WC'       TO TABLE-1                    
              MOVE 'POINT_ID'             TO TABLE-ELEMENT-1            
              MOVE MN-GIS-POINT-ID        TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * 7110-FETCH-ACCOUNT-NUM-WC.                                     *        
      * Fetches the ACCOUNT_NUM_WC Cursor.                             *        
      ******************************************************************03560000
      *                                                                         
       7110-FETCH-ACCOUNT-NUM-WC.                                       
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                       ACCOUNT_NUM_WC                                   
                 INTO                                                   
                      :HT-ACCOUNT-NO                                    
                     ,:HT-CUSTOMER-NO                                   
                     ,:HT-PREMISE-NO                                    
                     ,:MN-CODE-METER-STATUS                             
                     ,:MN-GIS-POINT-ID                                  
                     ,:HT-ADDRESS-ID                                    
                     ,:HT-NAME-ID                                       
P00436               ,:AT-CODE-CRIT-OUTAGE                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   MOVE 'N'                   TO WS-NO-MORE-RECS        
              WHEN NOT-FOUND                                            
                   MOVE 'Y'                   TO WS-NO-MORE-RECS        
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7110'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'ACCOUNT_NUM_WC'      TO TABLE-1                
                   MOVE 'POINT_ID'            TO TABLE-ELEMENT-1        
                   MOVE MN-GIS-POINT-ID       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
                END-EVALUATE.                                           
      *                                                                         
       7110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * 7120-CLOSE-ACCOUNT-NUM-WC.                                     *        
      * Closes the ACCOUNT_NUM_WC Cursor.                              *        
      ******************************************************************03560000
      *                                                                         
       7120-CLOSE-ACCOUNT-NUM-WC.                                       
      *                                                                         
           EXEC SQL                                                     
                CLOSE ACCOUNT_NUM_WC                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7120'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE 'ACCOUNT_NUM_WC'       TO TABLE-1                    
              MOVE 'POINT_ID'             TO TABLE-ELEMENT-1            
              MOVE MN-GIS-POINT-ID        TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * 7130-OPEN-ACCOUNT-NUM-PR.                                      *        
      * Opens the ACCOUNT_NUM_PR CURSOR.                               *        
      ******************************************************************03560000
      *                                                                         
       7130-OPEN-ACCOUNT-NUM-PR.                                        
      *                                                                         
           EXEC SQL                                                     
                OPEN ACCOUNT_NUM_PR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7130'                 TO ACTIVE-PARAGRAPH           
              MOVE 'OPEN'                 TO ABEND-FUNCTION             
              MOVE 'ACCOUNT_NUM_PR'       TO TABLE-1                    
              MOVE 'POINT_ID'             TO TABLE-ELEMENT-1            
              MOVE MN-GIS-POINT-ID        TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * 7140-FETCH-ACCOUNT-NUM-PR.                                     *        
      * Fetches the ACCOUNT_NUM_PR Cursor.                             *        
      ******************************************************************03560000
      *                                                                         
       7140-FETCH-ACCOUNT-NUM-PR.                                       
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                       ACCOUNT_NUM_PR                                   
                 INTO                                                   
                      :HT-ACCOUNT-NO                                    
                     ,:HT-CUSTOMER-NO                                   
                     ,:HT-PREMISE-NO                                    
                     ,:MN-CODE-METER-STATUS                             
                     ,:MN-GIS-POINT-ID                                  
                     ,:HT-ADDRESS-ID                                    
                     ,:HT-NAME-ID                                       
P00436               ,:AT-CODE-CRIT-OUTAGE                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   MOVE 'N'                   TO WS-NO-MORE-RECS        
              WHEN NOT-FOUND                                            
                   MOVE 'Y'                   TO WS-NO-MORE-RECS        
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7140'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'ACCOUNT_NUM_PR'      TO TABLE-1                
                   MOVE 'POINT_ID'            TO TABLE-ELEMENT-1        
                   MOVE MN-GIS-POINT-ID       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7140-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * 7150-CLOSE-ACCOUNT-NUM-PR.                                     *        
      * Closes the ACCOUNT_NUM_PR Cursor.                              *        
      ******************************************************************03560000
      *                                                                         
       7150-CLOSE-ACCOUNT-NUM-PR.                                       
      *                                                                         
           EXEC SQL                                                     
                CLOSE ACCOUNT_NUM_PR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7150'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE 'ACCOUNT_NUM_PR'       TO TABLE-1                    
              MOVE 'POINT_ID'             TO TABLE-ELEMENT-1            
              MOVE MN-GIS-POINT-ID        TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * 7160-GET-POINT-DETAILS.                                        *        
      * Selects the Point Details.                                     *        
      ******************************************************************03560000
      *                                                                         
       7160-GET-POINT-DETAILS.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                        QH.REGION_ID                                    
                       ,QH.REGION_TX                                    
                       ,QG.AREA_ID                                      
                       ,QG.AREA_TX                                      
                       ,I2.WORK_AREA_ID                                 
                       ,I2.WORK_AREA_TX                                 
                       ,UQ.SUBSTATION_ID                                
                       ,UQ.CIRCUIT_ID                                   
C33743                 ,(PP.AREA_ID + PP.TAG_NM)                       
C33743                 ,PP.GRID_CELL_TX                                 
C33743                 ,PP.GRID_CELL_TX                                 
                  INTO                                                  
                        :QH-REGION-ID                                   
                       ,:QH-REGION-TX                                   
                       ,:QG-AREA-ID                                     
                       ,:QG-AREA-TX                                     
                       ,:I2-WORK-AREA-ID                                
                       ,:I2-WORK-AREA-TX                                
                       ,:UQ-SUBSTATION-ID                               
                       ,:UQ-CIRCUIT-ID                                  
C33743                 ,:WS-DEVICE-NM :WS-NULL-IND-1                    
C33743                 ,:PP-GRID-CELL-TX :WS-NULL-IND-2                 
C33743                 ,:PP-GRID-CELL-TX :WS-NULL-IND-3                 
                  FROM                                                  
                        CSS_OP_REGION      QH WITH(READUNCOMMITTED)             
                       ,CSS_OP_AREA        QG WITH(READUNCOMMITTED)             
                       ,CSS_WORK_AREA_MATL AG WITH(READUNCOMMITTED)             
                       ,CSS_WORK_AREA      I2 WITH(READUNCOMMITTED)             
                       ,CSS_CIRCUIT        UQ WITH(READUNCOMMITTED)             
C33743                 ,CSS_PIM_POINT      PP WITH(READUNCOMMITTED)             
                WHERE                                                   
                        PP.POINT_ID      =    :MN-GIS-POINT-ID          
                  AND   PP.SUBSTATION_ID LIKE :WS-SUBSTN-ID             
                  AND   PP.CIRCUIT_ID    LIKE :WS-CIRCT-ID              
                  AND   QH.REGION_ID     LIKE :WS-REG-ID                
                  AND   QG.AREA_ID       LIKE :WS-AREA                  
                  AND   AG.WORK_AREA_ID  LIKE :WS-WK-AREA-ID            
                  AND   QH.REGION_ID     =    QG.REGION_ID              
                  AND   QG.AREA_ID       =    AG.AREA_ID                
                  AND   AG.WORK_AREA_ID  =    I2.WORK_AREA_ID           
                  AND   I2.WORK_AREA_ID  =    UQ.WORK_AREA_ID           
                  AND   UQ.SUBSTATION_ID =    PP.SUBSTATION_ID          
                  AND   UQ.CIRCUIT_ID    =    PP.CIRCUIT_ID             
T37261                                                           
P00436                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 QH.REGION_ID                                            
MFA-TR*                ,QH.REGION_TX                                            
MFA-TR*                ,QG.AREA_ID                                              
MFA-TR*                ,QG.AREA_TX                                              
MFA-TR*                ,I2.WORK_AREA_ID                                         
MFA-TR*                ,I2.WORK_AREA_TX                                         
MFA-TR*                ,UQ.SUBSTATION_ID                                        
MFA-TR*                ,UQ.CIRCUIT_ID                                           
MFA-TR*                ,(PP.AREA_ID || PP.TAG_NM)                               
MFA-TR*                ,PP.GRID_CELL_TX                                         
MFA-TR*                ,PP.GRID_CELL_TX                                         
MFA-TR*           INTO                                                          
MFA-TR*                 :QH-REGION-ID                                           
MFA-TR*                ,:QH-REGION-TX                                           
MFA-TR*                ,:QG-AREA-ID                                             
MFA-TR*                ,:QG-AREA-TX                                             
MFA-TR*                ,:I2-WORK-AREA-ID                                        
MFA-TR*                ,:I2-WORK-AREA-TX                                        
MFA-TR*                ,:UQ-SUBSTATION-ID                                       
MFA-TR*                ,:UQ-CIRCUIT-ID                                          
MFA-TR*                ,:WS-DEVICE-NM :WS-NULL-IND-1                            
MFA-TR*                ,:PP-GRID-CELL-TX :WS-NULL-IND-2                         
MFA-TR*                ,:PP-GRID-CELL-TX :WS-NULL-IND-3                         
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_OP_REGION      QH                                   
MFA-TR*                ,CSS_OP_AREA        QG                                   
MFA-TR*                ,CSS_WORK_AREA_MATL AG                                   
MFA-TR*                ,CSS_WORK_AREA      I2                                   
MFA-TR*                ,CSS_CIRCUIT        UQ                                   
MFA-TR*                ,CSS_PIM_POINT      PP                                   
MFA-TR*         WHERE                                                           
MFA-TR*                 PP.POINT_ID      =    :MN-GIS-POINT-ID                  
MFA-TR*           AND   PP.SUBSTATION_ID LIKE :WS-SUBSTN-ID                     
MFA-TR*           AND   PP.CIRCUIT_ID    LIKE :WS-CIRCT-ID                      
MFA-TR*           AND   QH.REGION_ID     LIKE :WS-REG-ID                        
MFA-TR*           AND   QG.AREA_ID       LIKE :WS-AREA                          
MFA-TR*           AND   AG.WORK_AREA_ID  LIKE :WS-WK-AREA-ID                    
MFA-TR*           AND   QH.REGION_ID     =    QG.REGION_ID                      
MFA-TR*           AND   QG.AREA_ID       =    AG.AREA_ID                        
MFA-TR*           AND   AG.WORK_AREA_ID  =    I2.WORK_AREA_ID                   
MFA-TR*           AND   I2.WORK_AREA_ID  =    UQ.WORK_AREA_ID                   
MFA-TR*           AND   UQ.SUBSTATION_ID =    PP.SUBSTATION_ID                  
MFA-TR*           AND   UQ.CIRCUIT_ID    =    PP.CIRCUIT_ID                     
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7160                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN NOT-FOUND                                            
                   CONTINUE                                             
              WHEN SUCCESSFUL-CALL                                      
                   MOVE WS-GIS-POINT-ID       TO WS-GIS-POINT-ID-PREV   
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7160'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_PIM_POINT'           TO TABLE-1            
                   MOVE 'REGION_ID'           TO TABLE-ELEMENT-1        
                   MOVE 'AREA_ID'             TO TABLE-ELEMENT-2        
                   MOVE 'POINT_ID'            TO TABLE-ELEMENT-3        
                   MOVE WS-REG-ID             TO HOSTVAR-ELEMENT-1      
                   MOVE WS-AREA               TO HOSTVAR-ELEMENT-2      
                   MOVE MN-GIS-POINT-ID       TO HOSTVAR-ELEMENT-3      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************03490000
      * 7170-GET-CUST-NAME.                                            *        
      * Select Customer first and last names.                          *        
      ******************************************************************03560000
                                                                        
       7170-GET-CUST-NAME.                                              
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                        LTRIM(DQ.FIRST_NAME)                            
                       ,DQ.LAST_NAME                                    
                       ,DQ.FULL_NAME                                    
                  INTO                                                  
                        :DQ-FIRST-NAME :WS-NULL-IND-4                    
                       ,:DQ-LAST-NAME                                   
                       ,:DQ-FULL-NAME                                   
                  FROM                                                  
                        CSS_NAME DQ WITH(READUNCOMMITTED)                       
                 WHERE                                                  
                        DQ.NAME_ID   = :DQ-NAME-ID                      
                   AND  DQ.NAME_TYPE = 'CN'                             
T37261                                                           
P00436                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 LTRIM(DQ.FIRST_NAME)                                    
MFA-TR*                ,DQ.LAST_NAME                                            
MFA-TR*                ,DQ.FULL_NAME                                            
MFA-TR*           INTO                                                          
MFA-TR*                 :DQ-FIRST-NAME:WS-NULL-IND-4                            
MFA-TR*                ,:DQ-LAST-NAME                                           
MFA-TR*                ,:DQ-FULL-NAME                                           
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_NAME DQ                                             
MFA-TR*          WHERE                                                          
MFA-TR*                 DQ.NAME_ID   = :DQ-NAME-ID                              
MFA-TR*            AND  DQ.NAME_TYPE = 'CN'                                     
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7170                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00436*       NEXT SENTENCE                                                     
P00436        MOVE HT-ACCOUNT-NO         TO WS-ACCOUNT-NO-PREV          
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7170'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_NAME'            TO TABLE-1                     
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-1             
              MOVE DQ-NAME-ID            TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************03490000
      * 7180-GET-CUST-ADDR.                                            *        
      * Select Customer Address.                                       *        
      ******************************************************************03560000
      *                                                                         
       7180-GET-CUST-ADDR.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                        LTRIM(RTRIM(DY.HOUSE_NO)) + ' ' + LTRIM(RTRIM(
           DY.STREET_NAME)) + ' ' + LTRIM(RTRIM(ZP.TOWN)) + ' ' + 
           LTRIM(RTRIM(ZP.STATE)) + ' ' + LTRIM(RTRIM(ZP.ZIP_CODE))            
                  INTO                                                  
                        :WS-ADDRESS                                     
                  FROM                                                  
                        CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)             
                       ,CSS_ZIP_CODE ZP WITH(READUNCOMMITTED)                   
                 WHERE                                                  
                        DY.ADDRESS_ID     = :DY-ADDRESS-ID              
                   AND  DY.ZIP_CODE       = ZP.ZIP_CODE                 
                   AND  DY.ZIP_CODE_TOKEN = ZP.ZIP_CODE_TOKEN           
T37261                                                           
P00436                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                 STRIP(DY.HOUSE_NO)          || ' ' ||                   
MFA-TR*                 STRIP(DY.STREET_NAME)       || ' ' ||                   
MFA-TR*                 STRIP(ZP.TOWN)              || ' ' ||                   
MFA-TR*                 STRIP(ZP.STATE)             || ' ' ||                   
MFA-TR*                 STRIP(ZP.ZIP_CODE)                                      
MFA-TR*           INTO                                                          
MFA-TR*                 :WS-ADDRESS                                             
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_ADDR_FORMATTED DY                                   
MFA-TR*                ,CSS_ZIP_CODE ZP                                         
MFA-TR*          WHERE                                                          
MFA-TR*                 DY.ADDRESS_ID     = :DY-ADDRESS-ID                      
MFA-TR*            AND  DY.ZIP_CODE       = ZP.ZIP_CODE                         
MFA-TR*            AND  DY.ZIP_CODE_TOKEN = ZP.ZIP_CODE_TOKEN                   
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7180                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7180'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE SQLCODE               TO ABEND-SQLCODE              
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-1                    
               MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1            
               MOVE DY-ADDRESS-ID         TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7180-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * 7190-GET-CUST-PRI-PH.                                          *        
      * Select Customer Home Phone Number.                             *        
      ******************************************************************03560000
      *                                                                         
       7190-GET-CUST-PRI-PH.                                            
      *                                                                         
P00436        IF WS-SELECT-FL = 'WC' THEN                               
P00436           MOVE 'H1'   TO CB-PHONE-TYPE                           
P00436        ELSE                                                      
P00436           MOVE 'B1'   TO CB-PHONE-TYPE                           
P00436        END-IF                                                    
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                         CB.PHONE_NO                                    
                        ,CB.EXTENSION_NO                                
                  INTO                                                  
                         :CB-PHONE-NO                                   
                        ,:CB-EXTENSION-NO                               
                  FROM                                                  
                        CSS_CUST_PHONE CB WITH(READUNCOMMITTED)                 
                 WHERE                                                  
                        CB.CUSTOMER_NO   =  :CB-CUSTOMER-NO             
P00436             AND  CB.PHONE_TYPE    =  :CB-PHONE-TYPE              
                   AND  CB.CUSTOMER_TYPE =  'C'                         
T37261                                                           
P00436                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                  CB.PHONE_NO                                            
MFA-TR*                 ,CB.EXTENSION_NO                                        
MFA-TR*           INTO                                                          
MFA-TR*                  :CB-PHONE-NO                                           
MFA-TR*                 ,:CB-EXTENSION-NO                                       
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_CUST_PHONE CB                                       
MFA-TR*          WHERE                                                          
MFA-TR*                 CB.CUSTOMER_NO   =  :CB-CUSTOMER-NO                     
MFA-TR*            AND  CB.PHONE_TYPE    =  :CB-PHONE-TYPE                      
MFA-TR*            AND  CB.CUSTOMER_TYPE =  'C'                                 
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7190                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR                   
                 CB-PHONE-NO = SPACES                                   
                 MOVE '8039999999'       TO S-HOME-PHONE(1:10)          
                 MOVE '      '           TO S-HOME-PHONE(11:)           
              ELSE                                                      
                 MOVE CB-PHONE-NO        TO S-HOME-PHONE(1:10)          
                 MOVE CB-EXTENSION-NO    TO S-HOME-PHONE(11:)           
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7190'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE SQLCODE               TO ABEND-SQLCODE              
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_CUST_PHONE'      TO TABLE-1                    
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
               MOVE CB-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7190-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * 7200-GET-CUST-WORK-PH.                                         *        
      * Select Customer Work Phone Number.                             *        
      ******************************************************************03560000
      *                                                                         
       7200-GET-CUST-WORK-PH.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                         CB.PHONE_NO                                    
                        ,CB.EXTENSION_NO                                
                  INTO                                                  
                         :CB-PHONE-NO                                   
                        ,:CB-EXTENSION-NO                               
                  FROM                                                  
                        CSS_CUST_PHONE CB WITH(READUNCOMMITTED)                 
                 WHERE                                                  
                        CB.CUSTOMER_NO   =  :CB-CUSTOMER-NO             
                   AND  CB.PHONE_TYPE    =  'W1'                        
                   AND  CB.CUSTOMER_TYPE =  'C'                         
T37261                                                           
P00436                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                  CB.PHONE_NO                                            
MFA-TR*                 ,CB.EXTENSION_NO                                        
MFA-TR*           INTO                                                          
MFA-TR*                  :CB-PHONE-NO                                           
MFA-TR*                 ,:CB-EXTENSION-NO                                       
MFA-TR*           FROM                                                          
MFA-TR*                 CSS_CUST_PHONE CB                                       
MFA-TR*          WHERE                                                          
MFA-TR*                 CB.CUSTOMER_NO   =  :CB-CUSTOMER-NO                     
MFA-TR*            AND  CB.PHONE_TYPE    =  'W1'                                
MFA-TR*            AND  CB.CUSTOMER_TYPE =  'C'                                 
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7200                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02103        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A02103           MOVE '          '       TO S-WORK-PHONE(1:10)          
                 MOVE '      '           TO S-WORK-PHONE(11:)           
              ELSE                                                      
                 MOVE CB-PHONE-NO        TO S-WORK-PHONE(1:10)          
                 MOVE CB-EXTENSION-NO    TO S-WORK-PHONE(11:)           
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7200'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE SQLCODE               TO ABEND-SQLCODE              
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_CUST_PHONE'      TO TABLE-1                    
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
               MOVE CB-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03490000
      * 8000A-DELETE-GTT-ROWS.                                         *        
      * Deletes all the rows from GTT.                                 *        
      ******************************************************************03560000
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM #CSR01700_R1                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR01700_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '8100A'               TO ACTIVE-PARAGRAPH           
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE SQLCODE               TO ABEND-SQLCODE              
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSR01700_R1'         TO TABLE-1                    
               MOVE SPACES                TO TABLE-ELEMENT-1            
               MOVE SPACES                TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT.                                              *        
      * Inserts the result-set row into GTT.                           *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
           EXEC SQL                                                     
                INSERT INTO #CSR01700_R1                         
                (                                                       
                    WORK_AREA_ID                                        
                   ,WORK_AREA_TX                                        
                   ,AREA_ID                                             
                   ,AREA_TX                                             
                   ,REGION_ID                                           
                   ,REGION_TX                                           
                   ,SUBSTATION_ID                                       
                   ,CIRCUIT_ID                                          
                   ,SECTION_NM                                          
                   ,TAP_FUSE_ID                                         
                   ,DEVICE_NM                                           
                   ,ACCOUNT_NO                                          
                   ,CUSTOMER_NO                                         
                   ,ADDRESS_ID                                          
                   ,PREMISE_NO                                          
                   ,NAME_ID                                             
                   ,FULL_NAME                                           
                   ,HOME_PHONE                                          
                   ,WORK_PHONE                                          
                   ,ADDRESS                                             
                   ,POINT_ID                                            
P00436*            ,CODE_UTIL_TYPE                                              
                   ,CODE_METER_STATUS                                   
                   ,TITLE                                               
P00436             ,CODE_CRIT_OUTAGE                                    
                )                                                       
                VALUES                                                  
                (                                                       
                    :S-WORK-AREA-ID                                     
                   ,:S-WORK-AREA-TX                                     
                   ,:S-AREA-ID                                          
                   ,:S-AREA-TX                                          
                   ,:S-REGION-ID                                        
                   ,:S-REGION-TX                                        
                   ,:S-SUBSTATION-ID                                    
                   ,:S-CIRCUIT-ID                                       
                   ,:S-SECTION-NM                                       
                   ,:S-TAP-FUSE-ID                                      
                   ,:S-DEVICE-NM                                        
                   ,:S-ACCOUNT-NO                                       
                   ,:S-CUSTOMER-NO                                      
                   ,:S-ADDRESS-ID                                       
                   ,:S-PREMISE-NO                                       
                   ,:S-NAME-ID                                          
                   ,:S-FULL-NAME                                        
                   ,:S-HOME-PHONE                                       
                   ,:S-WORK-PHONE                                       
                   ,:S-ADDRESS                                          
                   ,:S-POINT-ID                                         
P00436*            ,:S-CODE-UTIL-TYPE                                           
                   ,:S-CODE-METER-STATUS                                
                   ,:S-TITLE                                            
P00436             ,:S-CODE-CRIT-OUTAGE                                 
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR01700_R1                                 
MFA-TR*         (                                                               
MFA-TR*             WORK_AREA_ID                                                
MFA-TR*            ,WORK_AREA_TX                                                
MFA-TR*            ,AREA_ID                                                     
MFA-TR*            ,AREA_TX                                                     
MFA-TR*            ,REGION_ID                                                   
MFA-TR*            ,REGION_TX                                                   
MFA-TR*            ,SUBSTATION_ID                                               
MFA-TR*            ,CIRCUIT_ID                                                  
MFA-TR*            ,SECTION_NM                                                  
MFA-TR*            ,TAP_FUSE_ID                                                 
MFA-TR*            ,DEVICE_NM                                                   
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,CUSTOMER_NO                                                 
MFA-TR*            ,ADDRESS_ID                                                  
MFA-TR*            ,PREMISE_NO                                                  
MFA-TR*            ,NAME_ID                                                     
MFA-TR*            ,FULL_NAME                                                   
MFA-TR*            ,HOME_PHONE                                                  
MFA-TR*            ,WORK_PHONE                                                  
MFA-TR*            ,ADDRESS                                                     
MFA-TR*            ,POINT_ID                                                    
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,CODE_METER_STATUS                                           
MFA-TR*            ,TITLE                                                       
MFA-TR*            ,CODE_CRIT_OUTAGE                                            
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-WORK-AREA-ID                                             
MFA-TR*            ,:S-WORK-AREA-TX                                             
MFA-TR*            ,:S-AREA-ID                                                  
MFA-TR*            ,:S-AREA-TX                                                  
MFA-TR*            ,:S-REGION-ID                                                
MFA-TR*            ,:S-REGION-TX                                                
MFA-TR*            ,:S-SUBSTATION-ID                                            
MFA-TR*            ,:S-CIRCUIT-ID                                               
MFA-TR*            ,:S-SECTION-NM                                               
MFA-TR*            ,:S-TAP-FUSE-ID                                              
MFA-TR*            ,:S-DEVICE-NM                                                
MFA-TR*            ,:S-ACCOUNT-NO                                               
MFA-TR*            ,:S-CUSTOMER-NO                                              
MFA-TR*            ,:S-ADDRESS-ID                                               
MFA-TR*            ,:S-PREMISE-NO                                               
MFA-TR*            ,:S-NAME-ID                                                  
MFA-TR*            ,:S-FULL-NAME                                                
MFA-TR*            ,:S-HOME-PHONE                                               
MFA-TR*            ,:S-WORK-PHONE                                               
MFA-TR*            ,:S-ADDRESS                                                  
MFA-TR*            ,:S-POINT-ID                                                 
MFA-TR*            ,:S-CODE-UTIL-TYPE                                           
MFA-TR*            ,:S-CODE-METER-STATUS                                        
MFA-TR*            ,:S-TITLE                                                    
MFA-TR*            ,:S-CODE-CRIT-OUTAGE                                         
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8100'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR01700_R1'         TO TABLE-1                     
              MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1             
              MOVE  S-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CUSTOMER-NO'         TO TABLE-ELEMENT-2             
              MOVE  S-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              MOVE 'PREMISE-NO'          TO TABLE-ELEMENT-3             
              MOVE  S-PREMISE-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *                  SQL Error Processing Copy Book                *        
      ******************************************************************        
      *                                                                         
      *****************************************************************         
      * 9700-PROCESS-ABEND - COMBINED ERROR HANDLING ROUTINE.         *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *9975-ABEND-CONTROL-TRANSFER / 9900-SQL-ERROR-ROUTINE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *8900-SEND-DONE / 9000-SEND-ERROR-RESULT / 9999-END-PROGRAM      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00321                                                
           END-EXEC.                                                            
      *                                                                         
      ************************ End of Program **************************        
