       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR01297.                                     
COB303 DATE-WRITTEN.                                                    
COB303            OCTOBER 03, 2006.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE CALLED FROM CSR      *        
      *  DESKTOP                                                       *        
      *                                                                *        
      *  THIS PROGRAM INSERTS/UPDATES/DELETES RECORDS IN CSS_APPLIANCE *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  10/03/06  SJ94244    INITIAL VERSION                          *        
PRDFIX*  02/19/07  MN90523    IGNORE WQ IF ACCT NO IS ZERO WHILE INSERT*        
C33453*  02/21/07  MN90523    WQ SEQENCE OBJECT CHANGES                *        
C35401*  07/05/07  FMB        CORRECT WQ GENERATION.  CORRECT TRANS    *        
C35401*                       HISTORY.                                 *        
C35978*  10/01/07  FMB        NO LONGER NEED TO FLIP RATE BASED ON     *        
C35978*                       APPLIANCES.  WQ CRITERIA NO LONGER NEEDS *        
C35978*                       BASE USE.                                *        
C36448*  11/12/07  FMB        BYPASS SPACES IN APPLIANCE CODE.         *        
P36189*  03/19/09  AW41078    LIMIT USER ACCESS TO DELETE MSE APPLIANCE*        
P36189*                       DO NOT ALLOW DELETION OF PSNC MSE APPL   *        
P36189*                       FROM CAD.  INSTEAD GENERATE WQ TO ADMIN  *        
A01350*  06/08/09  FMB        CHECK CIS_DISPLAY_FL PRIOR TO INSERT AND *        
A01350*                       DO NOT INSERT IF THE FLAG IS N.  TO FIX  *        
A01350*                       MSE ONLY ISSUE.                          *        
A04527*  06/07/13  AS7C117    REMOVE UNUSED COPYBOOK CWS00056.         *        
A04776*  08/29/13  AS7C117    REMOVED UNUSED COPYBOOKS CWS00068 AND    *        
A04776*                       CWS0068L                                 *        
A04776*                       REMOVED UNUSED DCLGENS                   *        
      *  03/31/14  HB42149    ADDED COLUMN NAMES TO RESULT SET         *        
ACT106*  05/18/15  RS7M249    DELETE UNUSED COPYBOOK(S)                *        
P00740*  09/14/15  FMB        DEFAULT FUEL CODE TO NA-GAS              *        
D09537*  11/09/15  FMB        HANDLE -803 ON INSERT. BUSOP CANNOT      *        
D09537*                       RELIABLY PROVIDE A UNIQUE TIMESTAMP.     *        
A05317*  08/02/16  FMB        REMOVE REFERENCES TO CSS_MSE_APPLIANCE   *        
ACT233*  08/16/16  TP7R341    REPLACE CSR00028 WITH CSR04675           *        
ACT233*   A05460                                                       *        
A05317*  10/21/16  FMB        REMOVE MSE APPLIANCE DELETE WQ.          *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR01297'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(45) VALUE   
           'WORKING STORAGE FOR SP CSR01297 STARTS HERE'.               
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBAPPLAN                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFCYL                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
A01350     EXEC SQL                                                             
A01350        INCLUDE TBMKTAPL                                                  
A01350     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY COOKS                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(8)  VALUE 'CSR01297'.      
           05  WS-CMNT-TXT-LEN         PIC 9(04) COMP.                  
           05  WS-CMNT-TXT             PIC X(255).                      
           05  WS-TRANS-COMMENTS-LEN   PIC 9(4) COMP.                   
           05  WS-TRANS-COMMENTS       PIC X(255).                      
           05  WS-CHG-APPLIANCE-DESC   PIC X(020).                      
           05  WS-CHG-CONDITION-DESC   PIC X(050).                      
           05  WS-CHG-LOCATION-DESC    PIC X(050).                      
           05  WS-PRV-APPLIANCE-DESC   PIC X(020).                      
           05  WS-PRV-CONDITION-DESC   PIC X(050).                      
           05  WS-PRV-LOCATION-DESC    PIC X(050).                      
C35401     05  WS-FIELDS-CHANGED           PIC X(01) VALUE 'Y'.         
D09537     05  WS-EQUIPMENT-TS             PIC X(20).                   
      *                                                                         
       01  WS-MNT-TRANS-HIST.                                           
           05  WS-CURRENT-DATE            PIC X(10)  VALUE SPACES.      
           05  WS-CURRENT-TIMESTAMP       PIC X(26)  VALUE SPACES.      
           05  WS-CURRENT-TIMESTAMP1      PIC X(26)  VALUE SPACES.      
           05  WS-PANEL-NO                PIC X(09)  VALUE 'PANEL238 '. 
           05  WS-COMMENT                 PIC X(210).                   
           05  WS-COMMENT-LEN             PIC S9(04)  VALUE 0 COMP.     
      *                                                                         
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE          PIC X(01)   VALUE 'F'.        
           05  WS-TRAN-APPL-NO            PIC S9(02)  VALUE 0.          
           05  WS-TABLE-ID                PIC X(02).                    
           05  WS-COLUMN-DESC             PIC X(15).                    
           05  WS-CHG-COLUMN-VALUE-TEXT   PIC X(255).                   
           05  WS-CHG-COLUMN-VALUE-LEN    PIC S9(4) USAGE COMP.         
           05  WS-PRV-COLUMN-VALUE-TEXT   PIC X(255).                   
           05  WS-PRV-COLUMN-VALUE-LEN    PIC S9(4) USAGE COMP.         
      *                                                                         
       01  WS-APPLIANCE-TABLE.                                          
           05  WS-PREMISE-NO                 PIC 9(10) VALUE ZERO.      
           05  WS-EQUIPMENT-NO               PIC X(20).                 
           05  WS-COMPANY-NO                 PIC X(2).                  
           05  WS-APPLIANCE-CD               PIC X(2).                  
           05  WS-CAUTION-TAG-IND            PIC X(1).                  
           05  WS-CUT-IND                    PIC X(1).                  
           05  WS-PRIMARY-FUEL-CD            PIC X(6).                  
           05  WS-UPDATE-DT                  PIC X(10).                 
           05  WS-UPDATE-ID                  PIC X(7).                  
           05  WS-TAG-NO                     PIC X(10).                 
           05  WS-CONDITION-CD               PIC X(3).                  
           05  WS-LOCATION-CD                PIC X(3).                  
           05  WS-APPLIANCE-COMMENTS.                                   
              10 WS-APPLIANCE-COMMENTS-LEN   PIC S9(4) USAGE COMP.      
              10 WS-APPLIANCE-COMMENTS-TEXT  PIC X(255).                
           05 WS-CAUTION-TAG-DT              PIC X(10).                 
           05 WS-CAUTION-TAG-DT-NULL-IND PIC S9(4) USAGE COMP VALUE +0. 
           05 WS-SOURCE-SYSTEM-CD            PIC X(03).                 
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-WQ-FLAG               PIC X(01) VALUE 'N'.             
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      *01  LOC-RESLTSET          USAGE IS SQL TYPE IS                   
      *                          RESULT-SET-LOCATOR VARYING.            
                                                                        
       01  WS-WQ-MISC.                                                  
           05 WS-WQ-ITEM-ID                PIC S9(10)V COMP-3 VALUE +0. 
           05 WS-WQ-ROUTE-CATEGORY         PIC X(01).                   
           05 WS-WQ-LOCAL-OFFICE           PIC X(03).                   
           05 WS-WQ-USER-ID-ASGN           PIC X(07).                   
           05 WS-WQ-USER-ID-ORIG           PIC X(07).                   
           05 WS-WQ-RESP-AREA-ID           PIC X(03).                   
           05 WS-WQ-CATEGORY-ID            PIC S9(04) USAGE COMP.       
COB305     05 WS-WQ-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.    
COB305     05 WS-WQ-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.    
COB305     05 WS-WQ-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.    
COB305     05 WS-WQ-SERV-ORDER-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-WQ-COMMENTS.                                           
              49 WS-WQ-COMMENTS-LEN        PIC S9(04) USAGE COMP.       
              49 WS-WQ-COMMENTS-TEXT       PIC X(250).                  
           05 WS-WQ-DATE-REQUIRED          PIC X(26).                   
           05 WS-WQ-DATE-CREATED           PIC X(26).                   
           05 WS-WQ-PRIORITY               PIC X(01).                   
           05 WS-WQ-FREE-FORM-AREA.                                     
              49 WS-WQ-FREEFORM-LEN        PIC S9(04) USAGE COMP.       
              49 WS-WQ-FREEFORM-TEXT       PIC X(255).                  
COB305     05 WS-DUP-WQ-CNT        PIC S9(03) USAGE COMP-3 VALUE 0.     
           05 WS-DUP-WQ-CNT-IND            PIC S9(04) COMP VALUE ZERO.  
ACT233     05 WS-WQ-CREATED-BY             PIC X(16).                   
                                                                        
ACT233 01  WS-CSR04675-OUTPUT.                                          
ACT233     05  WS-CSR04675-RET-CODE        PIC S9(09) COMP VALUE 0.     
                                                                        
COB305 77 WS-ACCOUNT-NO-NUM        PIC S9(13)V USAGE COMP-3 VALUE 0.    
       77  WS-CUSTOMER-NO-NUM              PIC S9(10)V USAGE COMP-3     
                                                      VALUE 0.          
       77  WS-APPLIANCE-CD-OLD             PIC X(02).                   
       77  WS-LOCAL-OFFICE                 PIC X(03).                   
       77  RS-RETURN-CODE                  PIC 9(03).                   
       77  WS-RATE-PLAN-NO                 PIC X(03).                   
       77  WS-CODE-REVENUE-CLASS           PIC X(03).                   
COB305 77 WS-GAS-BASE-USE        PIC S9(9)V USAGE COMP-3 VALUE 0.     
       77  WS-SEASNL-RATE-FLAG             PIC X(01).                   
       77  WS-CURRENT-DATE-MISC            PIC X(10).                   
       77  WS-CURRENT-MONTH                PIC 9(02).                   
       77  WS-ITEM-ID                      PIC S9(10)V COMP-3 VALUE +0. 
       77  WS-CODE-ACCOUNT-STATUS          PIC X(1) VALUE SPACES.       
MSQ001        EXEC SQL
MSQ001          DECLARE CSR04675_RS_CSR CURSOR
MSQ001          FOR CALL CSR04675 ( :WS-WQ-ITEM-ID
                  , :WS-WQ-ROUTE-CATEGORY
                  , :WS-WQ-LOCAL-OFFICE
                  , :WS-WQ-USER-ID-ORIG
                  , :WS-WQ-USER-ID-ASGN
                  , :WS-WQ-RESP-AREA-ID
                  , :WS-WQ-CATEGORY-ID
                  , :WS-WQ-ACCOUNT-NO
                  , :WS-WQ-PREMISE-NO
                  , :WS-WQ-CUSTOMER-NO
                  , :WS-WQ-SERV-ORDER-NO
                  , :WS-WQ-COMMENTS
                  , :WS-WQ-DATE-REQUIRED
                  , :WS-WQ-DATE-CREATED
                  , :WS-WQ-PRIORITY
                  , :WS-WQ-FREE-FORM-AREA
                  , :WS-WQ-CREATED-BY
                  )
MSQ001        END-EXEC.
                      
       77  WS-AUTO-RATE-MSG PIC X(70) VALUE "AUTOMATIC RATE CHANGE PERFO        
      -    "RMED DUE TO ADDITION OF WATER HEATER".                              
                                                                        
HPCCDM*EJECT                                                                    
       LINKAGE SECTION.                                                 
       01  PARM-UPDATE-TYPE        PIC X(01).                           
       01  PARM-PREMISE-NO         PIC X(10).                           
       01  PARM-EQUIPMENT-NO       PIC X(20).                           
       01  PARM-COMPANY-NO         PIC X(02).                           
       01  PARM-APPLIANCE-CD       PIC X(02).                           
       01  PARM-CAUTION-TAG-IND    PIC X(01).                           
       01  PARM-CUT-IND            PIC X(01).                           
       01  PARM-PRIMARY-FUEL-CD    PIC X(06).                           
       01  PARM-UPDATE-DT          PIC X(10).                           
       01  PARM-UPDATE-ID          PIC X(07).                           
       01  PARM-TAG-NO             PIC X(10).                           
       01  PARM-CONDITION-CD       PIC X(03).                           
       01  PARM-LOCATION-CD        PIC X(03).                           
       01  PARM-APPL-CMNT-LEN      PIC 9(04) COMP.                      
       01  PARM-APPL-CMNT-TXT      PIC X(255).                          
       01  PARM-CAUTION-TAG-DT     PIC X(10).                           
       01  PARM-SOURCE-SYSTEM-CD   PIC X(03).                           
       01  PARM-CMNT-TXT-LEN       PIC 9(04) COMP.                      
       01  PARM-CMNT-TXT           PIC X(255).                          
                                                                        
       PROCEDURE DIVISION USING PARM-UPDATE-TYPE                        
                                PARM-PREMISE-NO                         
                                PARM-EQUIPMENT-NO                       
                                PARM-COMPANY-NO                         
                                PARM-APPLIANCE-CD                       
                                PARM-CAUTION-TAG-IND                    
                                PARM-CUT-IND                            
                                PARM-PRIMARY-FUEL-CD                    
                                PARM-UPDATE-DT                          
                                PARM-UPDATE-ID                          
                                PARM-TAG-NO                             
                                PARM-CONDITION-CD                       
                                PARM-LOCATION-CD                        
                                PARM-APPL-CMNT-LEN                      
                                PARM-APPL-CMNT-TXT                      
                                PARM-CAUTION-TAG-DT                     
                                PARM-SOURCE-SYSTEM-CD                   
                                PARM-CMNT-TXT-LEN                       
                                PARM-CMNT-TXT.                          
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL                                                     
                WHENEVER SQLWARNING CONTINUE                            
           END-EXEC.                                                    
           EXEC SQL                                                     
                WHENEVER SQLERROR   CONTINUE                            
           END-EXEC.                                                    
           EXEC SQL                                                     
                WHENEVER NOT FOUND  CONTINUE                            
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE AS RETURN_CODE                        
                  ,:S-WQ-FLAG     AS WQ_FLAG                            
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE AS RETURN_CODE                                
MFA-TR*           ,:S-WQ-FLAG     AS WQ_FLAG                                    
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-PREMISE-NO           TO WS-PREMISE-NO.             
           MOVE PARM-EQUIPMENT-NO         TO WS-EQUIPMENT-NO.           
           MOVE PARM-COMPANY-NO           TO WS-COMPANY-NO.             
           MOVE PARM-APPLIANCE-CD         TO WS-APPLIANCE-CD.           
           MOVE PARM-CAUTION-TAG-IND      TO WS-CAUTION-TAG-IND.        
           MOVE PARM-CUT-IND              TO WS-CUT-IND.                
P00740     IF PARM-PRIMARY-FUEL-CD <= SPACES                            
P00740         MOVE 'NA-GAS' TO PARM-PRIMARY-FUEL-CD
           END-IF.                   
           MOVE PARM-PRIMARY-FUEL-CD      TO WS-PRIMARY-FUEL-CD.        
           MOVE PARM-UPDATE-DT            TO WS-UPDATE-DT.              
           MOVE PARM-UPDATE-ID            TO WS-UPDATE-ID.              
           MOVE PARM-TAG-NO               TO WS-TAG-NO.                 
           MOVE PARM-CONDITION-CD         TO WS-CONDITION-CD.           
           MOVE PARM-LOCATION-CD          TO WS-LOCATION-CD.            
           MOVE PARM-APPL-CMNT-LEN        TO WS-APPLIANCE-COMMENTS-LEN. 
           MOVE PARM-APPL-CMNT-TXT        TO WS-APPLIANCE-COMMENTS-TEXT.
           MOVE PARM-CAUTION-TAG-DT       TO WS-CAUTION-TAG-DT.         
           IF WS-CAUTION-TAG-DT = SPACES                                
               MOVE -1 TO WS-CAUTION-TAG-DT-NULL-IND                    
           END-IF.                                                      
           MOVE PARM-SOURCE-SYSTEM-CD     TO WS-SOURCE-SYSTEM-CD.       
           MOVE PARM-CMNT-TXT-LEN         TO WS-CMNT-TXT-LEN.           
           MOVE PARM-CMNT-TXT             TO WS-CMNT-TXT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE 0                         TO WS-TRAN-APPL-NO            
           MOVE SPACES                    TO WS-TABLE-ID                
           MOVE WS-CMNT-TXT-LEN           TO WS-TRANS-COMMENTS-LEN      
           MOVE WS-CMNT-TXT               TO WS-TRANS-COMMENTS          
                                                                        
           PERFORM 7000-GET-CURRENT-DATE  THRU 7000-EXIT                
           PERFORM 7010-ACCEPT-TIMESTAMP  THRU 7010-EXIT                
           PERFORM 7030-GET-RESP-AREA-ID  THRU 7030-EXIT                
                                                                        
A01350     IF PARM-UPDATE-TYPE = 'I' AND                                
A01350        PARM-SOURCE-SYSTEM-CD = 'MSE'                             
A01350            PERFORM 7900-GET-DISPLAY-FL THRU 7900-EXIT            
A01350            IF JA-CIS-DISPLAY-FL = 'N'                            
A01350                MOVE ' ' TO PARM-UPDATE-TYPE
                  END-IF
           END-IF.                     
                                                                        
D09537     IF PARM-UPDATE-TYPE = 'I' AND                                
D09537        PARM-SOURCE-SYSTEM-CD = 'CIS'                             
D09537            EXEC SQL                                              
D09537                  SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP1  
D09537            END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*           EXEC SQL                                                      
MFA-TR*                 SET :WS-CURRENT-TIMESTAMP1 = CURRENT TIMESTAMP          
MFA-TR*           END-EXEC                                                      

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

D09537            MOVE WS-CURRENT-TIMESTAMP1(1:4) TO                    
D09537                 WS-EQUIPMENT-TS(1:4)                             
D09537            MOVE WS-CURRENT-TIMESTAMP1(6:2) TO                    
D09537                 WS-EQUIPMENT-TS(5:2)                             
D09537            MOVE WS-CURRENT-TIMESTAMP1(9:2) TO                    
D09537                 WS-EQUIPMENT-TS(7:2)                             
D09537            MOVE WS-CURRENT-TIMESTAMP1(12:2) TO                   
D09537                 WS-EQUIPMENT-TS(9:2)                             
D09537            MOVE WS-CURRENT-TIMESTAMP1(15:2) TO                   
D09537                 WS-EQUIPMENT-TS(11:2)                            
D09537            MOVE WS-CURRENT-TIMESTAMP1(18:2) TO                   
D09537                 WS-EQUIPMENT-TS(13:2)                            
D09537            MOVE WS-CURRENT-TIMESTAMP1(21:6) TO                   
D09537                 WS-EQUIPMENT-TS(15:6)                            
D09537            MOVE WS-EQUIPMENT-TS TO WS-EQUIPMENT-NO
           END-IF.              
                                                                        
C36448     IF WS-APPLIANCE-CD <= '  '                                   
C36448         MOVE ' ' TO PARM-UPDATE-TYPE
           END-IF.                            
                                                                        
           EVALUATE TRUE                                                
                                                                        
              WHEN PARM-UPDATE-TYPE = 'I'                               
                 PERFORM 5000-GET-INSERT-ROW      THRU 5000-EXIT        
                 PERFORM 5010-INSERT-PREPROCESS   THRU 5010-EXIT        
                 PERFORM 8000-INSERT-APPLIANCE    THRU 8000-EXIT        
                 PERFORM 7400-WORKQUEUE-PROCESS   THRU 7400-EXIT        
              WHEN PARM-UPDATE-TYPE = 'U'                               
                 PERFORM 5020-UPDATE-PREPROCESS   THRU 5020-EXIT        
                 PERFORM 8100-UPDATE-APPLIANCE    THRU 8100-EXIT        
              WHEN PARM-UPDATE-TYPE = 'D'                               
                 PERFORM 5030-DELETE-PREPROCESS THRU 5030-EXIT          
                 PERFORM 8200-DELETE-APPLIANCE  THRU 8200-EXIT          
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE.             
           ADD  +1                        TO CTR-ROWS.                  
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 5000-GET-INSERT-ROW.                                           *        
      *                                                                *        
      ******************************************************************        
       5000-GET-INSERT-ROW.                                             
      *                                                                         
                                                                        
           MOVE WS-PREMISE-NO              TO LA-PREMISE-NO.            
           MOVE WS-EQUIPMENT-NO            TO LA-EQUIPMENT-NO.          
           MOVE WS-COMPANY-NO              TO LA-COMPANY-NO.            
C36448     IF WS-APPLIANCE-CD = 'DC'                                    
C36448         MOVE 'DR' TO WS-APPLIANCE-CD
           END-IF.                            
C36448     IF WS-APPLIANCE-CD = 'RA'                                    
C36448         MOVE 'RG' TO WS-APPLIANCE-CD
           END-IF.                            
           MOVE WS-APPLIANCE-CD            TO LA-APPLIANCE-CD.          
           MOVE WS-CAUTION-TAG-IND         TO LA-CAUTION-TAG-IND.       
           MOVE WS-CUT-IND                 TO LA-CUT-IND.               
           MOVE WS-PRIMARY-FUEL-CD         TO LA-PRIMARY-FUEL-CD.       
           MOVE WS-UPDATE-DT               TO LA-UPDATE-DT.             
           MOVE WS-UPDATE-ID               TO LA-UPDATE-ID.             
           MOVE WS-TAG-NO                  TO LA-TAG-NO.                
           MOVE WS-CONDITION-CD            TO LA-CONDITION-CD.          
           MOVE WS-LOCATION-CD             TO LA-LOCATION-CD.           
           MOVE WS-APPLIANCE-COMMENTS-LEN  TO LA-APPLIANCE-COMMENTS-LEN.
           MOVE WS-APPLIANCE-COMMENTS-TEXT TO                           
                                            LA-APPLIANCE-COMMENTS-TEXT. 
           MOVE WS-CAUTION-TAG-DT          TO LA-CAUTION-TAG-DT.        
           MOVE WS-SOURCE-SYSTEM-CD        TO LA-SOURCE-SYSTEM-CD.      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *5001-GET-CHG-CODE-DESC.                                         *        
      ******************************************************************        
       5001-GET-CHG-CODE-DESC.                                          
                                                                        
           PERFORM 5002-GET-CHG-APPLIANCE-DESC THRU 5002-EXIT.          
           PERFORM 5003-GET-CHG-CONDITION-DESC THRU 5003-EXIT.          
           PERFORM 5004-GET-CHG-LOCATION-DESC  THRU 5004-EXIT.          
                                                                        
       5001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *5002-GET-CHG-APPLIANCE-DESC.                                    *        
      ******************************************************************        
       5002-GET-CHG-APPLIANCE-DESC.                                     
                                                                        
           EXEC SQL                                                     
               SELECT APPLIANCE_DESC                                    
                 INTO :WS-CHG-APPLIANCE-DESC                            
                 FROM CSS_MKT_APPLIANCE                                 
                WHERE APPLIANCE_CD = :WS-APPLIANCE-CD                   
                  AND COMPANY_NO = :WS-COMPANY-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5002'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_MKT_APPLIANCE'   TO TABLE-1                     
              MOVE 'APPLIANCE_CD'        TO TABLE-ELEMENT-1             
              MOVE WS-APPLIANCE-CD       TO HOSTVAR-ELEMENT-1           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *5003-GET-CHG-CONDITION-DESC.                                    *        
      ******************************************************************        
       5003-GET-CHG-CONDITION-DESC.                                     
                                                                        
           EXEC SQL                                                     
               SELECT CONDITION_DESC                                    
               INTO :WS-CHG-CONDITION-DESC                              
               FROM CSS_APPLIANCE_COND                                  
               WHERE CONDITION_CD = :WS-CONDITION-CD AND                
                     COMPANY_NO = :WS-COMPANY-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5003'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_APPLIANCE_COND'  TO TABLE-1                     
              MOVE 'CONDITION_CD'        TO TABLE-ELEMENT-1             
              MOVE WS-CONDITION-CD       TO HOSTVAR-ELEMENT-1           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5003-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *5004-GET-CHG-LOCATION-DESC.                                     *        
      ******************************************************************        
       5004-GET-CHG-LOCATION-DESC.                                      
                                                                        
           EXEC SQL                                                     
               SELECT LOCATION_DESC                                     
               INTO :WS-CHG-LOCATION-DESC                               
               FROM CSS_APPLIANCE_LOC                                   
               WHERE LOCATION_CD = :WS-LOCATION-CD AND                  
                     COMPANY_NO = :WS-COMPANY-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5004'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_APPLIANCE_LOC'   TO TABLE-1                     
              MOVE 'LOCATION_CD'         TO TABLE-ELEMENT-1             
              MOVE WS-LOCATION-CD        TO HOSTVAR-ELEMENT-1           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5004-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *5005-GET-PRV-CODE-DESC.                                         *        
      ******************************************************************        
       5005-GET-PRV-CODE-DESC.                                          
                                                                        
           PERFORM 5006-GET-PRV-APPLIANCE-DESC THRU 5006-EXIT.          
           PERFORM 5007-GET-PRV-CONDITION-DESC THRU 5007-EXIT.          
           PERFORM 5008-GET-PRV-LOCATION-DESC  THRU 5008-EXIT.          
                                                                        
       5005-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *5006-GET-PRV-APPLIANCE-DESC.                                   *         
      *****************************************************************         
       5006-GET-PRV-APPLIANCE-DESC.                                     
                                                                        
           EXEC SQL                                                     
               SELECT APPLIANCE_DESC                                    
                 INTO :WS-PRV-APPLIANCE-DESC                            
                 FROM CSS_MKT_APPLIANCE                                 
                WHERE APPLIANCE_CD = :LA-APPLIANCE-CD                   
                  AND COMPANY_NO = :LA-COMPANY-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5006'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_MKT_APPLIANCE'   TO TABLE-1                     
              MOVE 'APPLIANCE_CD'        TO TABLE-ELEMENT-1             
              MOVE LA-APPLIANCE-CD       TO HOSTVAR-ELEMENT-1           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE LA-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5006-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *5007-GET-PRV-CONDITION-DESC.                                   *         
      *****************************************************************         
       5007-GET-PRV-CONDITION-DESC.                                     
                                                                        
           EXEC SQL                                                     
               SELECT CONDITION_DESC                                    
                 INTO :WS-PRV-CONDITION-DESC                            
                 FROM CSS_APPLIANCE_COND                                
                WHERE CONDITION_CD = :LA-CONDITION-CD                   
                  AND COMPANY_NO = :LA-COMPANY-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5007'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_APPLIANCE_COND'  TO TABLE-1                     
              MOVE 'CONDITION_CD'        TO TABLE-ELEMENT-1             
              MOVE LA-CONDITION-CD       TO HOSTVAR-ELEMENT-1           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE LA-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5007-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *5008-GET-PRV-LOCATION-DESC                                     *         
      *****************************************************************         
       5008-GET-PRV-LOCATION-DESC.                                      
                                                                        
           EXEC SQL                                                     
               SELECT LOCATION_DESC                                     
                 INTO :WS-PRV-LOCATION-DESC                             
                 FROM CSS_APPLIANCE_LOC                                 
                WHERE LOCATION_CD = :LA-LOCATION-CD                     
                  AND COMPANY_NO  = :LA-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5008'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_APPLIANCE_LOC'   TO TABLE-1                     
              MOVE 'LOCATION_CD'         TO TABLE-ELEMENT-1             
              MOVE LA-LOCATION-CD        TO HOSTVAR-ELEMENT-1           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE LA-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5008-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *5010-INSERT-PREPROCESS.                                         *        
      *                                                                *        
      ******************************************************************        
       5010-INSERT-PREPROCESS.                                          
      *                                                                         
      *                                                                         
           MOVE '*NEW*'                     TO WS-PRV-COLUMN-VALUE-TEXT.
           MOVE 5                           TO WS-PRV-COLUMN-VALUE-LEN. 
      *                                                                         
           PERFORM 5001-GET-CHG-CODE-DESC   THRU 5001-EXIT              
      *                                                                         
           ADD +1                           TO WS-TRAN-APPL-NO.         
           MOVE 'EQUIPMENT NO'              TO WS-COLUMN-DESC.          
           MOVE 20                          TO WS-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-EQUIPMENT-NO             TO WS-CHG-COLUMN-VALUE-TEXT.
           PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
      *                                                                         
           ADD +1                           TO WS-TRAN-APPL-NO.         
           MOVE 'APPLIANCE'                 TO WS-COLUMN-DESC.          
           MOVE 20                          TO WS-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-CHG-APPLIANCE-DESC       TO WS-CHG-COLUMN-VALUE-TEXT.
           PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
      *                                                                         
C35401     IF WS-CAUTION-TAG-IND = 'N'                                  
C35401         CONTINUE                                                 
C35401     ELSE                                                         
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'CAUTN TG'              TO WS-COLUMN-DESC           
               MOVE 1                       TO WS-CHG-COLUMN-VALUE-LEN  
               MOVE WS-CAUTION-TAG-IND      TO WS-CHG-COLUMN-VALUE-TEXT 
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.         
      *                                                                         
C35401     IF WS-CUT-IND = 'N'                                          
C35401         CONTINUE                                                 
C35401     ELSE                                                         
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'CUT OFF'               TO WS-COLUMN-DESC           
               MOVE 1                       TO WS-CHG-COLUMN-VALUE-LEN  
               MOVE WS-CUT-IND              TO WS-CHG-COLUMN-VALUE-TEXT 
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.         
      *                                                                         
           ADD +1                           TO WS-TRAN-APPL-NO.         
           MOVE 'FUEL CD'                   TO WS-COLUMN-DESC.          
           MOVE 6                           TO WS-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-PRIMARY-FUEL-CD          TO WS-CHG-COLUMN-VALUE-TEXT.
           PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                         
           IF WS-TAG-NO NOT = SPACES                                    
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'TAG #'                  TO WS-COLUMN-DESC           
              MOVE 10                       TO WS-CHG-COLUMN-VALUE-LEN  
              MOVE WS-TAG-NO                TO WS-CHG-COLUMN-VALUE-TEXT 
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-CONDITION-CD NOT = SPACES                              
              ADD +1                           TO WS-TRAN-APPL-NO       
              MOVE 'IMPROPER COND'             TO WS-COLUMN-DESC        
              MOVE 50                     TO WS-CHG-COLUMN-VALUE-LEN    
              MOVE WS-CHG-CONDITION-DESC  TO WS-CHG-COLUMN-VALUE-TEXT   
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-LOCATION-CD  NOT = SPACES                              
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'LOCATION'               TO WS-COLUMN-DESC           
              MOVE 50                       TO WS-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CHG-LOCATION-DESC    TO WS-CHG-COLUMN-VALUE-TEXT  
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-APPLIANCE-COMMENTS-TEXT NOT = SPACES                   
             ADD +1                          TO WS-TRAN-APPL-NO         
             MOVE 'COMMENTS'                 TO WS-COLUMN-DESC          
             MOVE WS-APPLIANCE-COMMENTS-LEN  TO WS-CHG-COLUMN-VALUE-LEN 
             MOVE WS-APPLIANCE-COMMENTS-TEXT                            
                                          TO WS-CHG-COLUMN-VALUE-TEXT   
             PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT            
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT            
           END-IF.                                                      
      *                                                                         
           IF WS-CAUTION-TAG-DT NOT = SPACES                            
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'TAG DATE'              TO WS-COLUMN-DESC           
               MOVE 10                      TO WS-CHG-COLUMN-VALUE-LEN  
               MOVE WS-CAUTION-TAG-DT       TO WS-CHG-COLUMN-VALUE-TEXT 
               PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT          
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
           END-IF.                                                      
      *                                                                         
C35401     ADD +1                           TO WS-TRAN-APPL-NO.         
C35401     MOVE 'SOURCE SYSTEM'             TO WS-COLUMN-DESC.          
C35401     MOVE 3                           TO WS-CHG-COLUMN-VALUE-LEN. 
C35401     MOVE WS-SOURCE-SYSTEM-CD         TO WS-CHG-COLUMN-VALUE-TEXT.
C35401     PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT.             
C35401     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                         
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5020-UPDATE-PREPROCESS.                                        *        
      *                                                                *        
      ******************************************************************        
       5020-UPDATE-PREPROCESS.                                          
           MOVE '5020'                       TO ACTIVE-PARAGRAPH.       
      *                                                                         
           PERFORM 7100-GET-APPLIANCE-DETAIL THRU 7100-EXIT.            
           PERFORM 5001-GET-CHG-CODE-DESC    THRU 5001-EXIT.            
           PERFORM 5005-GET-PRV-CODE-DESC    THRU 5005-EXIT.            
           MOVE WS-APPLIANCE-CD              TO WS-APPLIANCE-CD-OLD.    
      *                                                                         
C35401     IF WS-CAUTION-TAG-IND = LA-CAUTION-TAG-IND AND               
C35401        WS-CUT-IND  = LA-CUT-IND AND                              
C35401        WS-PRIMARY-FUEL-CD = LA-PRIMARY-FUEL-CD AND               
C35401        WS-TAG-NO = LA-TAG-NO AND                                 
C35401        WS-CONDITION-CD = LA-CONDITION-CD AND                     
C35401        WS-LOCATION-CD  = LA-LOCATION-CD AND                      
C35401        WS-APPLIANCE-COMMENTS-TEXT =                              
C35401            LA-APPLIANCE-COMMENTS-TEXT AND                        
C35401        WS-CAUTION-TAG-DT = LA-CAUTION-TAG-DT                     
C35401            MOVE 'N' TO WS-FIELDS-CHANGED
           END-IF.                        
      *                                                                         
C35401     IF WS-FIELDS-CHANGED = 'Y'                                   
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'EQUIPMENT NO'          TO WS-COLUMN-DESC           
               MOVE 20                      TO WS-PRV-COLUMN-VALUE-LEN  
               MOVE WS-EQUIPMENT-NO         TO WS-PRV-COLUMN-VALUE-TEXT 
               MOVE SPACES                  TO WS-CHG-COLUMN-VALUE-TEXT 
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.         
      *                                                                         
C35401     IF WS-FIELDS-CHANGED = 'Y'                                   
               ADD +1                       TO WS-TRAN-APPL-NO          
               MOVE 'APPLIANCE'             TO WS-COLUMN-DESC           
               MOVE 20                      TO WS-PRV-COLUMN-VALUE-LEN  
               MOVE WS-PRV-APPLIANCE-DESC   TO WS-PRV-COLUMN-VALUE-TEXT 
               MOVE SPACES                  TO WS-CHG-COLUMN-VALUE-TEXT 
               MOVE LA-APPLIANCE-CD         TO WS-APPLIANCE-CD-OLD      
               MOVE WS-APPLIANCE-CD         TO LA-APPLIANCE-CD          
               PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.         
      *                                                                         
           IF WS-CAUTION-TAG-IND NOT = LA-CAUTION-TAG-IND               
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'CAUTN TG'               TO WS-COLUMN-DESC           
              MOVE 1                        TO WS-PRV-COLUMN-VALUE-LEN  
                                               WS-CHG-COLUMN-VALUE-LEN  
              MOVE LA-CAUTION-TAG-IND       TO WS-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-CAUTION-TAG-IND       TO WS-CHG-COLUMN-VALUE-TEXT 
                                               LA-CAUTION-TAG-IND       
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-CUT-IND NOT = LA-CUT-IND                               
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'CUT OFF'                TO WS-COLUMN-DESC           
              MOVE 1                        TO WS-PRV-COLUMN-VALUE-LEN  
                                               WS-CHG-COLUMN-VALUE-LEN  
              MOVE LA-CUT-IND               TO WS-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-CUT-IND               TO WS-CHG-COLUMN-VALUE-TEXT 
                                               LA-CUT-IND               
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-PRIMARY-FUEL-CD NOT = LA-PRIMARY-FUEL-CD               
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'FUEL CD'                TO WS-COLUMN-DESC           
              MOVE 6                        TO WS-PRV-COLUMN-VALUE-LEN  
                                               WS-CHG-COLUMN-VALUE-LEN  
              MOVE LA-PRIMARY-FUEL-CD       TO WS-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-PRIMARY-FUEL-CD       TO WS-CHG-COLUMN-VALUE-TEXT 
                                               LA-PRIMARY-FUEL-CD       
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-TAG-NO NOT = LA-TAG-NO                                 
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'TAG #'                  TO WS-COLUMN-DESC           
              MOVE 10                       TO WS-PRV-COLUMN-VALUE-LEN  
                                               WS-CHG-COLUMN-VALUE-LEN  
              MOVE LA-TAG-NO                TO WS-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-TAG-NO                TO WS-CHG-COLUMN-VALUE-TEXT 
                                               LA-TAG-NO                
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-CONDITION-CD NOT = LA-CONDITION-CD                     
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'IMPROPER COND'          TO WS-COLUMN-DESC           
              MOVE 50                       TO WS-PRV-COLUMN-VALUE-LEN  
                                               WS-CHG-COLUMN-VALUE-LEN  
              MOVE WS-PRV-CONDITION-DESC    TO WS-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-CHG-CONDITION-DESC    TO WS-CHG-COLUMN-VALUE-TEXT 
              MOVE WS-CONDITION-CD          TO LA-CONDITION-CD          
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-LOCATION-CD NOT = LA-LOCATION-CD                       
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'LOCATION'               TO WS-COLUMN-DESC           
              MOVE 50                       TO WS-PRV-COLUMN-VALUE-LEN  
                                               WS-CHG-COLUMN-VALUE-LEN  
              MOVE WS-PRV-LOCATION-DESC     TO WS-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-CHG-LOCATION-DESC     TO WS-CHG-COLUMN-VALUE-TEXT 
              MOVE WS-LOCATION-CD           TO LA-LOCATION-CD           
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF (WS-APPLIANCE-COMMENTS-TEXT NOT                           
                                     = LA-APPLIANCE-COMMENTS-TEXT)      
              ADD +1                          TO WS-TRAN-APPL-NO        
              MOVE 'COMMENTS'                 TO WS-COLUMN-DESC         
              MOVE LA-APPLIANCE-COMMENTS-LEN  TO                        
                                             WS-PRV-COLUMN-VALUE-LEN    
              MOVE LA-APPLIANCE-COMMENTS-TEXT TO                        
                                             WS-PRV-COLUMN-VALUE-TEXT   
              MOVE WS-APPLIANCE-COMMENTS-LEN  TO                        
                                             WS-CHG-COLUMN-VALUE-LEN    
                                             LA-APPLIANCE-COMMENTS-LEN  
              MOVE WS-APPLIANCE-COMMENTS-TEXT TO                        
                                             WS-CHG-COLUMN-VALUE-TEXT   
                                             LA-APPLIANCE-COMMENTS-TEXT 
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
           IF WS-CAUTION-TAG-DT NOT = LA-CAUTION-TAG-DT                 
              ADD +1                        TO WS-TRAN-APPL-NO          
              MOVE 'TAG DATE'               TO WS-COLUMN-DESC           
              MOVE 10                       TO WS-PRV-COLUMN-VALUE-LEN  
                                               WS-CHG-COLUMN-VALUE-LEN  
              MOVE LA-CAUTION-TAG-DT        TO WS-PRV-COLUMN-VALUE-TEXT 
              MOVE WS-CAUTION-TAG-DT        TO WS-CHG-COLUMN-VALUE-TEXT 
                                               LA-CAUTION-TAG-DT        
              IF WS-CAUTION-TAG-DT = SPACES                             
                 MOVE -1 TO WS-CAUTION-TAG-DT-NULL-IND                  
              ELSE                                                      
                 MOVE 0 TO WS-CAUTION-TAG-DT-NULL-IND                   
              END-IF                                                    
              PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
      *                                                                         
C35401     IF WS-FIELDS-CHANGED = 'Y'                                   
C35401         ADD +1                       TO WS-TRAN-APPL-NO          
C35401         MOVE 'SOURCE SYSTEM'         TO WS-COLUMN-DESC           
C35401         MOVE 3                       TO WS-PRV-COLUMN-VALUE-LEN  
C35401         MOVE WS-SOURCE-SYSTEM-CD     TO WS-PRV-COLUMN-VALUE-TEXT 
C35401         MOVE SPACES                  TO WS-CHG-COLUMN-VALUE-TEXT 
C35401         PERFORM 5950-SET-MNT-TRANS-VARS THRU 5950-EXIT           
C35401         PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.         
      *                                                                         
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5030-DELETE-PREPROCESS.                                        *        
      *                                                                *        
      ******************************************************************        
       5030-DELETE-PREPROCESS.                                          
           MOVE '5030'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 7200-GET-DELETE-REC-DETAIL  THRU 7200-EXIT.          
           PERFORM 5006-GET-PRV-APPLIANCE-DESC THRU 5006-EXIT.          
      *                                                                         
           MOVE '*DELETED*'                 TO WS-CHG-COLUMN-VALUE-TEXT.
           MOVE 9                           TO WS-CHG-COLUMN-VALUE-LEN. 
      *                                                                         
           ADD +1                           TO WS-TRAN-APPL-NO.         
           MOVE 'EQUIPMENT NO'              TO WS-COLUMN-DESC.          
           MOVE 20                          TO WS-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-EQUIPMENT-NO             TO WS-PRV-COLUMN-VALUE-TEXT.
           PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                         
           ADD +1                           TO WS-TRAN-APPL-NO.         
           MOVE 'APPLIANCE'                 TO WS-COLUMN-DESC.          
           MOVE 20                          TO WS-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-PRV-APPLIANCE-DESC       TO WS-PRV-COLUMN-VALUE-TEXT.
           PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                         
C35401     ADD +1                           TO WS-TRAN-APPL-NO.         
C35401     MOVE 'SOURCE SYSTEM'             TO WS-COLUMN-DESC.          
C35401     MOVE 3                           TO WS-PRV-COLUMN-VALUE-LEN. 
C35401     MOVE WS-SOURCE-SYSTEM-CD         TO WS-PRV-COLUMN-VALUE-TEXT.
C35401     PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT.             
C35401     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                         
       5030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5950 SET MNT TRANS VARS                                        *        
      *      -- THIS MODULE SETS UP THE REMAINING HOST VARIABLES WITH  *        
      *         SYSTEM WORKING STORAGE OR HARD-CODED VALUES FOR        *        
      *         INSERTING INTO THE CSS_MNT_TRANS_HIST AND              *        
      *         CSS_MT_TRN_HST_DET TABLES IN ORDER TO COMPLETE THE     *        
      *         REQUIRED MAINTENANCE TRANSACTION RECORD.               *        
      ******************************************************************        
       5950-SET-MNT-TRANS-VARS.                                         
           MOVE '5950'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE WS-CODE-TRAN-TYPE           TO MH-CODE-TRAN-TYPE.       
           MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE 0                           TO MH-ACCOUNT-NO.           
           MOVE 0                           TO MH-CUSTOMER-NO.          
           MOVE WS-PREMISE-NO               TO MH-PREMISE-NO.           
           MOVE WS-UPDATE-ID                TO MH-USER-ID.              
           MOVE WS-PANEL-NO                 TO MH-APPL-PROGRAM-ID.      
           IF WS-TRANS-COMMENTS-LEN > 0                                 
              MOVE WS-TRANS-COMMENTS        TO MH-TRAN-COMMENT-TEXT     
              MOVE WS-TRANS-COMMENTS-LEN    TO MH-TRAN-COMMENT-LEN      
           ELSE                                                         
              MOVE SPACES                   TO MH-TRAN-COMMENT-TEXT     
              MOVE 0                        TO MH-TRAN-COMMENT-LEN      
           END-IF                                                       
      *                                                                         
           MOVE WS-TABLE-ID                 TO MI-TABLE-ID.             
           MOVE WS-COLUMN-DESC              TO MI-COLUMN-DESC.          
           MOVE WS-CURRENT-TIMESTAMP        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-PRV-COLUMN-VALUE-TEXT    TO MI-PRV-COLUMN-VALUE-TEXT.
           IF WS-PRV-COLUMN-VALUE-LEN > 75                              
              MOVE +75 TO WS-PRV-COLUMN-VALUE-LEN                       
           END-IF.                                                      
           MOVE WS-PRV-COLUMN-VALUE-LEN     TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-CHG-COLUMN-VALUE-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT.
           IF WS-CHG-COLUMN-VALUE-LEN > 75                              
              MOVE +75 TO WS-CHG-COLUMN-VALUE-LEN                       
           END-IF.                                                      
           MOVE WS-CHG-COLUMN-VALUE-LEN     TO MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
       5950-EXIT.                                                       
           EXIT.                                                        
            EXEC SQL                                                            
               INCLUDE CPD00067                                                 
            END-EXEC.                                                           
      *                                                                         
            EXEC SQL                                                            
               INCLUDE CPD00099                                                 
            END-EXEC.                                                           
      *                                                                         
      *****************************************************************         
      * 6995-CPD99-ERROR-ROUTINE.                                     *         
      *****************************************************************         
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
            MOVE PROGRAM-NAME               TO ABEND-PROGRAM.           
            PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.             
            PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.             
                                                                        
       6995-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 7000-GET-CURRENT-DATE                                          *        
      *      --THIS MODULE DETERMINES THE TIMESTAMP FOR THE            *        
      *        MAINTENANCE TRANSACTION RECORD.                         *        
      ******************************************************************        
      *                                                                         
       7000-GET-CURRENT-DATE.                                           
           MOVE '7000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE           
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7000'                   TO ACTIVE-PARAGRAPH        
               MOVE 'SET'                    TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'PREMISE-NO'             TO TABLE-ELEMENT-1         
               MOVE  PARM-PREMISE-NO         TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010 ACCEPT TIMESTAMP                                          *        
      *      --THIS MODULE DETERMINES THE TIMESTAMP FOR THE            *        
      *        MAINTENANCE TRANSACTION RECORD.                         *        
      ******************************************************************        
       7010-ACCEPT-TIMESTAMP.                                           
           MOVE '7010'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE 'PREMISE-NO'             TO TABLE-ELEMENT-1          
              MOVE PARM-PREMISE-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7030 GET RESP AREA ID                                          *        
      *      -- THIS MODULE FINDS THE RESPONSIBLE AREA IDENTIFICATION  *        
      *         ACCORDING TO A USERS ID.                               *        
      ******************************************************************        
       7030-GET-RESP-AREA-ID.                                           
           MOVE '7030'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE WS-UPDATE-ID                TO PF-USER-ID.              
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE                                  
                WHERE USER_ID = :PF-USER-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_USER_PROFILE  '     TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE 'PREMISE-NO'             TO TABLE-ELEMENT-2          
              MOVE WS-UPDATE-ID             TO HOSTVAR-ELEMENT-1        
              MOVE PARM-PREMISE-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-APPLIANCE-DETAIL.                                     *        
      *                                                                *        
      ******************************************************************        
       7100-GET-APPLIANCE-DETAIL.                                       
      *                                                                         
           MOVE '7100'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE  DCLCSS-APPLIANCE.                                
           MOVE WS-PREMISE-NO               TO LA-PREMISE-NO.           
           MOVE WS-EQUIPMENT-NO             TO LA-EQUIPMENT-NO.         
      *                                                                         
           EXEC SQL                                                     
              SELECT APPLIANCE_CD,                                      
                     COMPANY_NO,                                        
                     CAUTION_TAG_IND,                                   
                     CUT_IND,                                           
                     PRIMARY_FUEL_CD,                                   
                     UPDATE_DT,                                         
                     UPDATE_ID,                                         
                     TAG_NO,                                            
                     CONDITION_CD,                                      
                     LOCATION_CD,                                       
                     APPLIANCE_COMMENTS,                                
                     CAUTION_TAG_DT ,                                   
                     SOURCE_SYSTEM_CD                                   
                INTO :LA-APPLIANCE-CD,                                  
                     :LA-COMPANY-NO,                                    
                     :LA-CAUTION-TAG-IND,                               
                     :LA-CUT-IND,                                       
                     :LA-PRIMARY-FUEL-CD,                               
                     :LA-UPDATE-DT,                                     
                     :LA-UPDATE-ID,                                     
                     :LA-TAG-NO,                                        
                     :LA-CONDITION-CD,                                  
                     :LA-LOCATION-CD,                                   
                     :LA-APPLIANCE-COMMENTS,                            
                     :LA-CAUTION-TAG-DT :WS-CAUTION-TAG-DT-NULL-IND,    
                     :LA-SOURCE-SYSTEM-CD                               
                FROM CSS_APPLIANCE                                      
               WHERE                                                    
                  PREMISE_NO   = :LA-PREMISE-NO                         
              AND EQUIPMENT_NO = :LA-EQUIPMENT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_APPLIANCE'          TO TABLE-1                  
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1          
              MOVE 'EQUIPMENT_NO'           TO TABLE-ELEMENT-2          
              MOVE PARM-PREMISE-NO          TO HOSTVAR-ELEMENT-1        
              MOVE LA-EQUIPMENT-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-GET-DELETE-REC-DETAIL.                                    *        
      *                                                                *        
      ******************************************************************        
       7200-GET-DELETE-REC-DETAIL.                                      
      *                                                                         
           MOVE '7200'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE WS-PREMISE-NO               TO LA-PREMISE-NO.           
           MOVE WS-EQUIPMENT-NO             TO LA-EQUIPMENT-NO.         
      *                                                                         
           EXEC SQL                                                     
              SELECT APPLIANCE_CD,                                      
                     COMPANY_NO,                                        
                     CAUTION_TAG_IND,                                   
                     CUT_IND,                                           
                     PRIMARY_FUEL_CD,                                   
                     UPDATE_DT,                                         
                     UPDATE_ID,                                         
                     TAG_NO,                                            
                     CONDITION_CD,                                      
                     LOCATION_CD,                                       
                     APPLIANCE_COMMENTS,                                
                     CAUTION_TAG_DT ,                                   
                     SOURCE_SYSTEM_CD                                   
                INTO :LA-APPLIANCE-CD,                                  
                     :LA-COMPANY-NO,                                    
                     :LA-CAUTION-TAG-IND,                               
                     :LA-CUT-IND,                                       
                     :LA-PRIMARY-FUEL-CD,                               
                     :LA-UPDATE-DT,                                     
                     :LA-UPDATE-ID,                                     
                     :LA-TAG-NO,                                        
                     :LA-CONDITION-CD,                                  
                     :LA-LOCATION-CD,                                   
                     :LA-APPLIANCE-COMMENTS,                            
                     :LA-CAUTION-TAG-DT :WS-CAUTION-TAG-DT-NULL-IND,    
                     :LA-SOURCE-SYSTEM-CD                               
                FROM CSS_APPLIANCE                                      
               WHERE                                                    
                  PREMISE_NO   = :LA-PREMISE-NO                         
              AND EQUIPMENT_NO = :LA-EQUIPMENT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_APPLIANCE'          TO TABLE-1                  
              MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1          
              MOVE 'EQUIPMENT_NO'           TO TABLE-ELEMENT-2          
              MOVE PARM-PREMISE-NO          TO HOSTVAR-ELEMENT-1        
              MOVE LA-EQUIPMENT-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      *7400-WORKQUEUE-PROCESS                                         *         
      *****************************************************************         
       7400-WORKQUEUE-PROCESS.                                          
                                                                        
           PERFORM 7410-GET-ACCOUNT-NUMBER   THRU 7410-EXIT.            
PRDFIX     IF WS-ACCOUNT-NO-NUM > 0                                     
              PERFORM 7420-GET-CUSTOMER-NUMBER  THRU 7420-EXIT          
              PERFORM 7430-GET-WORKQUEUE-INPUT  THRU 7430-EXIT          
              PERFORM 7440-WORKQUEUE-CHECK      THRU 7440-EXIT          
PRDFIX     END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *7410-GET-ACCOUNT-NUMBER                                        *         
      *****************************************************************         
       7410-GET-ACCOUNT-NUMBER.                                         
                                                                        
           MOVE PARM-PREMISE-NO           TO WS-CPD99-PREMISE-NO.       
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
           MOVE WS-CPD99-ACCOUNT-NO       TO WS-ACCOUNT-NO-NUM.         
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *7420-GET-CUSTOMER-NO                                           *         
      *****************************************************************         
       7420-GET-CUSTOMER-NUMBER.                                        
                                                                        
           EXEC SQL                                                     
               SELECT CUSTOMER_NO,                                      
                      CODE_ACCT_STAT,                                   
C35401                ACCOUNT_TYPE_CODE,                                
C35401                COMPANY_NO                                        
                 INTO :WS-CUSTOMER-NO-NUM,                              
                      :WS-CODE-ACCOUNT-STATUS,                          
C35401                :AT-ACCOUNT-TYPE-CODE,                            
C35401                :AT-COMPANY-NO                                    
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :WS-CPD99-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7420'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE WS-CPD99-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *7430-GET-WORKQUEUE-INPUT                                       *         
      *****************************************************************         
       7430-GET-WORKQUEUE-INPUT.                                        
                                                                        
           PERFORM 7435-GET-RATE-PLAN-NO   THRU 7435-EXIT.              
           PERFORM 7436-GET-SEASONAL-RT-FL THRU 7436-EXIT.              
                                                                        
       7430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *7435-GET-RATE-PLAN-NO                                          *         
      *****************************************************************         
       7435-GET-RATE-PLAN-NO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RATE_PLAN_NO,
              CODE_REVENUE_CLASS,
              GAS_BASE_USE                                       
              INTO                                                      
                    :WS-RATE-PLAN-NO,                                   
                    :WS-CODE-REVENUE-CLASS,                             
                    :WS-GAS-BASE-USE                                    
              FROM                                                      
                    CSS_UTIL_ENVRNMT                                    
              WHERE                                                     
                    ACCOUNT_NO = :WS-ACCOUNT-NO-NUM AND                 
                    CODE_UTIL_TYPE = 'G'                                
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_PLAN_NO,                                              
MFA-TR*              CODE_REVENUE_CLASS,                                        
MFA-TR*              GAS_BASE_USE                                               
MFA-TR*       INTO                                                              
MFA-TR*             :WS-RATE-PLAN-NO,                                           
MFA-TR*             :WS-CODE-REVENUE-CLASS,                                     
MFA-TR*             :WS-GAS-BASE-USE                                            
MFA-TR*       FROM                                                              
MFA-TR*             CSS_UTIL_ENVRNMT                                            
MFA-TR*       WHERE                                                             
MFA-TR*             ACCOUNT_NO = :WS-ACCOUNT-NO-NUM AND                         
MFA-TR*             CODE_UTIL_TYPE = 'G'                                        
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7435'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_REVENUE_CLASS'  TO TABLE-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7435-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *7436-GET-SEASONAL-RT-FL.                                       *         
      *****************************************************************         
       7436-GET-SEASONAL-RT-FL.                                         
                                                                        
           EXEC SQL                                                     
              SELECT SEASONAL_RT_FL                                     
              INTO :WS-SEASNL-RATE-FLAG                                 
              FROM CSS_MKT_APPLIANCE                                    
              WHERE APPLIANCE_CD = :WS-APPLIANCE-CD                     
              AND COMPANY_NO = :WS-COMPANY-NO                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7436'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_MKT_APPLIANCE'   TO TABLE-1                     
              MOVE 'SEASONAL_RT_FL'      TO TABLE-ELEMENT-1             
              MOVE WS-APPLIANCE-CD       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7436-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *7440-WORKQUEUE-CHECK                                           *         
      *****************************************************************         
       7440-WORKQUEUE-CHECK.                                            
                                                                        
           IF WS-SEASNL-RATE-FLAG = 'N' AND PARM-COMPANY-NO = '26'      
                                  AND WS-CODE-ACCOUNT-STATUS = 'A'      
C35401                            AND AT-ACCOUNT-TYPE-CODE = 'R'        
               IF WS-RATE-PLAN-NO = '101' AND                           
                  WS-CODE-REVENUE-CLASS = '711'                         
C35978*           WS-GAS-BASE-USE >= 24                                         
                   CONTINUE                                             
               ELSE                                                     
                   PERFORM 7500-WORKQUEUE-GEN THRU 7500-EXIT            
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *7500-WORKQUEUE-GEN                                            *          
      ****************************************************************          
       7500-WORKQUEUE-GEN.                                              
                                                                        
ACT233     INITIALIZE WS-CSR04675-OUTPUT.                               
                                                                        
           MOVE '1'                          TO WS-WQ-ROUTE-CATEGORY.   
           IF WS-ACCOUNT-NO-NUM > 0                                     
               PERFORM 7800-GET-LOCAL-OFFICE THRU 7800-EXIT             
               MOVE WS-LOCAL-OFFICE          TO WS-WQ-LOCAL-OFFICE      
           ELSE                                                         
               MOVE SPACES                   TO WS-WQ-LOCAL-OFFICE
           END-IF.     
           MOVE PARM-UPDATE-ID               TO WS-WQ-USER-ID-ORIG.     
           MOVE SPACES                       TO WS-WQ-USER-ID-ASGN.     
           MOVE '001'                        TO WS-WQ-RESP-AREA-ID.     
           MOVE 212                          TO WS-WQ-CATEGORY-ID.      
           MOVE WS-CPD99-ACCOUNT-NO          TO WS-WQ-ACCOUNT-NO.       
           MOVE PARM-PREMISE-NO              TO WS-WQ-PREMISE-NO.       
           MOVE WS-CUSTOMER-NO-NUM           TO WS-WQ-CUSTOMER-NO.      
           MOVE ZERO                         TO WS-WQ-SERV-ORDER-NO.    
           STRING 'NON-SEASONAL APPLIANCE ADDED: ',                     
                   WS-CHG-APPLIANCE-DESC  DELIMITED BY SIZE INTO        
                                                WS-WQ-COMMENTS-TEXT.    
           MOVE +50                          TO WS-WQ-COMMENTS-LEN.     
                                                                        
           MOVE SPACES                       TO WS-WQ-DATE-REQUIRED.    
           MOVE SPACES                       TO WS-WQ-DATE-CREATED.     
           MOVE 'N'                          TO WS-WQ-PRIORITY.         
           MOVE ' '                          TO WS-WQ-FREEFORM-TEXT.    
           MOVE +0                           TO WS-WQ-FREEFORM-LEN.     
                                                                        
           PERFORM 8500-INSERT-WQ            THRU 8500-EXIT.            
                                                                        
       7500-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
      *7800-GET-LOCAL-OFFICE                                          *         
      *****************************************************************         
       7800-GET-LOCAL-OFFICE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE                                       
                INTO :WS-LOCAL-OFFICE                                   
                FROM CSS_ACCOUNT                                        
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7800'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
A01350*****************************************************************         
A01350*7900-GET-DISPLAY-FL.                                           *         
A01350*****************************************************************         
A01350 7900-GET-DISPLAY-FL.                                             
A01350                                                                  
A01350     EXEC SQL                                                     
A01350        SELECT TOP(1) CIS_DISPLAY_FL                                     
A01350        INTO :JA-CIS-DISPLAY-FL                                   
A01350        FROM CSS_MKT_APPLIANCE                                    
A01350        WHERE APPLIANCE_CD = :WS-APPLIANCE-CD                     
A01350        AND COMPANY_NO = :WS-COMPANY-NO                           
A01350                                           
A01350     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CIS_DISPLAY_FL                                             
MFA-TR*       INTO :JA-CIS-DISPLAY-FL                                           
MFA-TR*       FROM CSS_MKT_APPLIANCE                                            
MFA-TR*       WHERE APPLIANCE_CD = :WS-APPLIANCE-CD                             
MFA-TR*       AND COMPANY_NO = :WS-COMPANY-NO                                   
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01350                                                                  
A01350     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A01350                                                                  
A01350     EVALUATE WS-ACTIVE-RETURN-CODE                               
A01350         WHEN SUCCESSFUL-CALL                                     
A01350             CONTINUE                                             
A01350         WHEN NOT-FOUND                                           
A01350             MOVE 'N' TO JA-CIS-DISPLAY-FL                        
A01350         WHEN OTHER                                               
A01350             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A01350             MOVE '7436'           TO ACTIVE-PARAGRAPH            
A01350             MOVE 'SELECT'         TO ABEND-FUNCTION              
A01350             MOVE 'CSS_MKT_APPLIANCE' TO TABLE-1                  
A01350             MOVE 'SEASONAL_RT_FL' TO TABLE-ELEMENT-1             
A01350             MOVE WS-APPLIANCE-CD  TO HOSTVAR-ELEMENT-1           
A01350             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A01350             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A01350     END-EVALUATE.                                                
A01350                                                                  
A01350 7900-EXIT.                                                       
A01350     EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      *8000-INSERT-APPLIANCE.                                          *        
      ******************************************************************        
      *                                                                         
       8000-INSERT-APPLIANCE.                                           
           EXEC SQL                                                     
              INSERT INTO CSS_APPLIANCE                                 
              (                                                         
                   PREMISE_NO                                           
                  ,EQUIPMENT_NO                                         
                  ,COMPANY_NO                                           
                  ,APPLIANCE_CD                                         
                  ,CAUTION_TAG_IND                                      
                  ,CUT_IND                                              
                  ,PRIMARY_FUEL_CD                                      
                  ,UPDATE_DT                                            
                  ,UPDATE_ID                                            
                  ,TAG_NO                                               
                  ,CONDITION_CD                                         
                  ,LOCATION_CD                                          
                  ,APPLIANCE_COMMENTS                                   
                  ,CAUTION_TAG_DT                                       
                  ,SOURCE_SYSTEM_CD                                     
              )                                                         
              VALUES                                                    
              (                                                         
                   :LA-PREMISE-NO                                       
                  ,:LA-EQUIPMENT-NO                                     
                  ,:LA-COMPANY-NO                                       
                  ,:LA-APPLIANCE-CD                                     
                  ,:LA-CAUTION-TAG-IND                                  
                  ,:LA-CUT-IND                                          
                  ,:LA-PRIMARY-FUEL-CD                                  
                  ,IIF(TRY_CONVERT(DATE, :LA-UPDATE-DT
              ) IS NULL OR (PATINDEX('%.%', :LA-UPDATE-DT
              ) <> 0) OR (LEN(:LA-UPDATE-DT) <> 10), CIS.CHAR2DATE(
                                                          :LA-UPDATE-DT
              ), CONVERT(DATE, :LA-UPDATE-DT) )                                
                  ,:LA-UPDATE-ID                                        
                  ,:LA-TAG-NO                                           
                  ,:LA-CONDITION-CD                                     
                  ,:LA-LOCATION-CD                                      
                  ,:LA-APPLIANCE-COMMENTS                               
                  ,IIF(TRY_CONVERT(DATE, :LA-CAUTION-TAG-DT 
                                         :WS-CAUTION-TAG-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :LA-CAUTION-TAG-DT 
                                            :WS-CAUTION-TAG-DT-NULL-IND
              ) <> 0) OR (LEN(:LA-CAUTION-TAG-DT 
                                            :WS-CAUTION-TAG-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:LA-CAUTION-TAG-DT 
                                            :WS-CAUTION-TAG-DT-NULL-IND
              ), CONVERT(DATE, :LA-CAUTION-TAG-DT 
                                            :WS-CAUTION-TAG-DT-NULL-IND
              ) )       
                  ,:LA-SOURCE-SYSTEM-CD                                 
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_APPLIANCE                                         
MFA-TR*       (                                                                 
MFA-TR*            PREMISE_NO                                                   
MFA-TR*           ,EQUIPMENT_NO                                                 
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,APPLIANCE_CD                                                 
MFA-TR*           ,CAUTION_TAG_IND                                              
MFA-TR*           ,CUT_IND                                                      
MFA-TR*           ,PRIMARY_FUEL_CD                                              
MFA-TR*           ,UPDATE_DT                                                    
MFA-TR*           ,UPDATE_ID                                                    
MFA-TR*           ,TAG_NO                                                       
MFA-TR*           ,CONDITION_CD                                                 
MFA-TR*           ,LOCATION_CD                                                  
MFA-TR*           ,APPLIANCE_COMMENTS                                           
MFA-TR*           ,CAUTION_TAG_DT                                               
MFA-TR*           ,SOURCE_SYSTEM_CD                                             
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*            :LA-PREMISE-NO                                               
MFA-TR*           ,:LA-EQUIPMENT-NO                                             
MFA-TR*           ,:LA-COMPANY-NO                                               
MFA-TR*           ,:LA-APPLIANCE-CD                                             
MFA-TR*           ,:LA-CAUTION-TAG-IND                                          
MFA-TR*           ,:LA-CUT-IND                                                  
MFA-TR*           ,:LA-PRIMARY-FUEL-CD                                          
MFA-TR*           ,:LA-UPDATE-DT                                                
MFA-TR*           ,:LA-UPDATE-ID                                                
MFA-TR*           ,:LA-TAG-NO                                                   
MFA-TR*           ,:LA-CONDITION-CD                                             
MFA-TR*           ,:LA-LOCATION-CD                                              
MFA-TR*           ,:LA-APPLIANCE-COMMENTS                                       
MFA-TR*           ,:LA-CAUTION-TAG-DT :WS-CAUTION-TAG-DT-NULL-IND               
MFA-TR*           ,:LA-SOURCE-SYSTEM-CD                                         
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_APPLIANCE'       TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE LA-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'EQUIPMENT_NO'        TO TABLE-ELEMENT-2             
              MOVE LA-EQUIPMENT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-UPDATE-APPLIANCE.                                         *        
      ******************************************************************        
      *                                                                         
       8100-UPDATE-APPLIANCE.                                           
           EXEC SQL                                                     
              UPDATE CSS_APPLIANCE                                      
              SET                                                       
                   APPLIANCE_CD       = :LA-APPLIANCE-CD                
                  ,CAUTION_TAG_IND    = :LA-CAUTION-TAG-IND             
                  ,CUT_IND            = :LA-CUT-IND                     
                  ,PRIMARY_FUEL_CD    = :LA-PRIMARY-FUEL-CD             
                  ,UPDATE_DT          = IIF(TRY_CONVERT(DATE, 
                                                          :WS-UPDATE-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-UPDATE-DT
              ) <> 0) OR (LEN(:WS-UPDATE-DT) <> 10), CIS.CHAR2DATE(
                                                          :WS-UPDATE-DT
              ), CONVERT(DATE, :WS-UPDATE-DT) )                   
                  ,UPDATE_ID          = :WS-UPDATE-ID                   
                  ,TAG_NO             = :LA-TAG-NO                      
                  ,CONDITION_CD       = :LA-CONDITION-CD                
                  ,LOCATION_CD        = :LA-LOCATION-CD                 
                  ,APPLIANCE_COMMENTS = :LA-APPLIANCE-COMMENTS          
                  ,CAUTION_TAG_DT     = IIF(TRY_CONVERT(DATE, 
                                                    :LA-CAUTION-TAG-DT 
                                            :WS-CAUTION-TAG-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :LA-CAUTION-TAG-DT 
                                            :WS-CAUTION-TAG-DT-NULL-IND
              ) <> 0) OR (LEN(:LA-CAUTION-TAG-DT 
                                            :WS-CAUTION-TAG-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:LA-CAUTION-TAG-DT 
                                            :WS-CAUTION-TAG-DT-NULL-IND
              ), CONVERT(DATE, :LA-CAUTION-TAG-DT 
                                            :WS-CAUTION-TAG-DT-NULL-IND
              ) )     
                  ,SOURCE_SYSTEM_CD   = :LA-SOURCE-SYSTEM-CD            
              WHERE                                                     
                  PREMISE_NO   = :LA-PREMISE-NO                         
              AND EQUIPMENT_NO = :LA-EQUIPMENT-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_APPLIANCE                                              
MFA-TR*       SET                                                               
MFA-TR*            APPLIANCE_CD       = :LA-APPLIANCE-CD                        
MFA-TR*           ,CAUTION_TAG_IND    = :LA-CAUTION-TAG-IND                     
MFA-TR*           ,CUT_IND            = :LA-CUT-IND                             
MFA-TR*           ,PRIMARY_FUEL_CD    = :LA-PRIMARY-FUEL-CD                     
MFA-TR*           ,UPDATE_DT          = :WS-UPDATE-DT                           
MFA-TR*           ,UPDATE_ID          = :WS-UPDATE-ID                           
MFA-TR*           ,TAG_NO             = :LA-TAG-NO                              
MFA-TR*           ,CONDITION_CD       = :LA-CONDITION-CD                        
MFA-TR*           ,LOCATION_CD        = :LA-LOCATION-CD                         
MFA-TR*           ,APPLIANCE_COMMENTS = :LA-APPLIANCE-COMMENTS                  
MFA-TR*           ,CAUTION_TAG_DT     = :LA-CAUTION-TAG-DT                      
MFA-TR*                                 :WS-CAUTION-TAG-DT-NULL-IND             
MFA-TR*           ,SOURCE_SYSTEM_CD   = :LA-SOURCE-SYSTEM-CD                    
MFA-TR*       WHERE                                                             
MFA-TR*           PREMISE_NO   = :LA-PREMISE-NO                                 
MFA-TR*       AND EQUIPMENT_NO = :LA-EQUIPMENT-NO                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8100'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_APPLIANCE'       TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE LA-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'EQUIPMENT_NO'        TO TABLE-ELEMENT-2             
              MOVE LA-EQUIPMENT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-DELETE-APPLIANCE.                                         *        
      ******************************************************************        
       8200-DELETE-APPLIANCE.                                           
                                                                        
           MOVE WS-PREMISE-NO              TO LA-PREMISE-NO.            
           MOVE WS-EQUIPMENT-NO            TO LA-EQUIPMENT-NO.          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_APPLIANCE                                 
              WHERE                                                     
                  PREMISE_NO     =:LA-PREMISE-NO                        
              AND EQUIPMENT_NO   =:LA-EQUIPMENT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_APPLIANCE'       TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE LA-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'EQUIPMENT_NO'        TO TABLE-ELEMENT-2             
              MOVE LA-EQUIPMENT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *8500-INSERT-WQ                                                 *         
      *****************************************************************         
       8500-INSERT-WQ.                                                  
                                                                        
ACT233     INITIALIZE   WS-CSR04675-OUTPUT.                             
C33453     MOVE ZERO                         TO WS-WQ-ITEM-ID.          
ACT233     MOVE 'CSR01297'                   TO WS-WQ-CREATED-BY.       
                                                                        
      *    EXEC SQL                                                     
ACT233*       CALL CSR04675 (:WS-WQ-ITEM-ID,                            
      *                      :WS-WQ-ROUTE-CATEGORY,                     
      *                      :WS-WQ-LOCAL-OFFICE,                       
      *                      :WS-WQ-USER-ID-ORIG,                       
      *                      :WS-WQ-USER-ID-ASGN,                       
      *                      :WS-WQ-RESP-AREA-ID,                       
      *                      :WS-WQ-CATEGORY-ID,                        
      *                      :WS-WQ-ACCOUNT-NO,                         
      *                      :WS-WQ-PREMISE-NO,                         
      *                      :WS-WQ-CUSTOMER-NO,                        
      *                      :WS-WQ-SERV-ORDER-NO,                      
      *                      :WS-WQ-COMMENTS,                           
      *                      :WS-WQ-DATE-REQUIRED,                      
      *                      :WS-WQ-DATE-CREATED,                       
      *                      :WS-WQ-PRIORITY,                           
      *                      :WS-WQ-FREE-FORM-AREA,                     
ACT233*                      :WS-WQ-CREATED-BY)                         
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CSR04675_RS_CSR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CSR04675_RS_CSR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CSR04675_RS_CSR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE 200                       TO WS-ACTIVE-RETURN-CODE   
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DB2 SP CALL'             TO ABEND-FUNCTION          
ACT233        MOVE 'CSR04675'                TO TABLE-1                 
              MOVE 'WS-ACTIVE-RETURN-CODE'   TO TABLE-ELEMENT-1         
              MOVE WS-ACTIVE-RETURN-CODE     TO HOSTVAR-ELEMENT-1       
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC-RESLTSET)                                           
ACT233*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT233*       ALLOCATE CSR04675_RS_CSR CURSOR FOR RESULT SET            
      *       :LOC-RESLTSET                                             
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT233         FETCH CSR04675_RS_CSR                                    
ACT233          INTO :WS-CSR04675-RET-CODE, :WS-WQ-ITEM-ID              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 200                       TO WS-ACTIVE-RETURN-CODE   
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'RESULT_SET_CSR'          TO TABLE-1                 
              MOVE 'WS-ACTIVE-RETURN-CODE'   TO TABLE-ELEMENT-1         
              MOVE WS-ACTIVE-RETURN-CODE     TO HOSTVAR-ELEMENT-1       
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
ACT233         CLOSE CSR04675_RS_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 200                       TO WS-ACTIVE-RETURN-CODE   
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'RESULT_SET_CSR'          TO TABLE-1                 
              MOVE 'WS-ACTIVE-RETURN-CODE'   TO TABLE-ELEMENT-1         
              MOVE WS-ACTIVE-RETURN-CODE     TO HOSTVAR-ELEMENT-1       
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
ACT233     IF  WS-CSR04675-RET-CODE = ZEROS                             
               MOVE 'Y' TO  S-WQ-FLAG                                   
           ELSE                                                         
               MOVE 200                      TO WS-ACTIVE-RETURN-CODE   
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8500'                   TO ACTIVE-PARAGRAPH        
               MOVE 'DB2 SP CALL'            TO ABEND-FUNCTION          
ACT233         MOVE 'CSR04675'               TO TABLE-1                 
               MOVE 'RETURN-CODE'            TO TABLE-ELEMENT-1         
ACT233         MOVE WS-CSR04675-RET-CODE     TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ****************************************************************          
      * 9700-PROCESS-ABEND - COMBINED ON-LINE/BATCH ERROR HANDLING.  *          
      ****************************************************************          
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
