       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR01250.                                          
       DATE-WRITTEN. MAR 05, 2007.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED FROM CSR DESKTOP                     *        
      *                                                                *        
      *  CALLING DW:    D_WORKREQ_MONMAIN_DNP                          *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE MADE TO CALL FROM    *        
      *  CSR DESKTOP VIA NEON ODBC.                                    *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES THE SERVICE ORDER DETAILS IN DNP VIEW  *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  03/05/07  MN90523    SYBASE SP TO DB2 COBOL SP CONVERSION     *        
C35607*  05/07/08  FMB        CHANGE READ ROUTE LOGIC TO HANDLE 3      *        
C35607*                       BYTE READ ROUTES.  TRUNCATE NAME.        *        
C37261*  05/07/08  FMB        CORRECT DCLGEN NAMES.                    *        
T36933*  06/20/08  SV85244    INCREASE LENGTH OF FULL NAME AND         *        
T36933*                       LAST NAME FIELDS.               .        *        
P00152*  06/08/09  VV90387    ADDED NEW FIELDS - SERVICE ADDRESS,      *        
P00152*                       PRIORITY AND ACCOUNT TYPE TO THE DNP VIEW*        
A01529*  08/03/09  VV90387    INCREASED WORK CLASS FIELD LENGTH FROM   *        
A01529*                       CHAR(2) TO CHAR(4)                       *        
A04086*  04/04/12  FMB        CORRECT S0C7 ABEND.                      *        
A05317*  06/16/16  FMB        ADD ORDER_RECVED_BY.                     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR01250'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR01250 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *----< CSS_ADDR_FORMATTED >                                               
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_NAME_ACCT_XREF >                                                
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_NAME >                                                          
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_ORDER_TYPE >                                                    
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_SO_DATA >                                                       
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_SO_DNP >                                                        
           EXEC SQL                                                             
              INCLUDE TBSODNP                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_SO_ORDER_INST >                                                 
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_SO_UTL_CHG >                                                    
           EXEC SQL                                                             
              INCLUDE TBSOUTG                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_SO_CREW >                                                       
           EXEC SQL                                                             
              INCLUDE TBSOCREW                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_WK_CLASS_STAT >                                                 
           EXEC SQL                                                             
C37261        INCLUDE TBWKCST                                                   
           END-EXEC.                                                            
                                                                        
A05317*---< CSS_USER_PROFILE >                                                  
A05317     EXEC SQL                                                             
A05317        INCLUDE TBUSRPRF                                                  
A05317     END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *----<COMMON SYSTEM AREA >                                                
           COPY CCA00001.                                                       
      *----< ERROR HANDLING >                                                   
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                              
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                PIC X(26) VALUE                  
                                               'SESSION.CSR01250_R1'.   
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-IS-RSP-AREA-NULL     PIC X(01) VALUE 'Y'.             
           05  WS-IS-WRK-AREA-NULL     PIC X(01) VALUE 'Y'.             
           05  WS-IS-STATUS-NULL       PIC X(01) VALUE 'Y'.             
           05  WS-IS-STATE-NULL        PIC X(01) VALUE 'Y'.             
           05  WS-IS-ORD-RSN-NULL      PIC X(01) VALUE 'Y'.             
           05  WS-IS-RD-ROUTE-NULL     PIC X(01) VALUE 'Y'.             
           05  WS-IS-WRK-TYPE-NULL     PIC X(01) VALUE 'Y'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
T36933     05  RS-FULL-NAME              PIC X(70) VALUE SPACE.         
           05  RS-FIRST-NAME             PIC X(15) VALUE SPACE.         
           05  RS-MIDDLE-NAME            PIC X(15) VALUE SPACE.         
T36933     05  RS-LAST-NAME              PIC X(40) VALUE SPACE.         
           05  RS-NAME-FORMAT            PIC X(01) VALUE SPACE.         
           05  RS-ORDER-TYPE-DESC        PIC X(15) VALUE SPACE.         
           05  RS-ORDER-REASON           PIC X(15) VALUE SPACE.         
           05  RS-AMOUNT-DISC-BAL        PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  RS-SECURITIES-TOT-AMT     PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  RS-CUR-MTH-ARREARS-CD     PIC X(01) VALUE SPACE.         
           05  RS-CREDIT-GROUP           PIC X(01) VALUE SPACE.         
           05  RS-ASSIGNED-DATETIME      PIC X(26) VALUE SPACE.         
           05  RS-STATUS-TX              PIC X(25) VALUE SPACE.         
           05  RS-ORDER-STATE-CD         PIC X(01) VALUE SPACE.         
           05  RS-SERV-ORDER-NO          PIC S9(13)V COMP-3 VALUE 0.    
           05  RS-ACCOUNT-NO             PIC S9(13)V COMP-3 VALUE 0.    
           05  RS-TOTAL                  PIC S9(9) COMP VALUE 0.        
           05  RS-PREMISE-NO             PIC S9(10)V COMP-3 VALUE 0.    
           05  RS-ORDER-GROUP-CD         PIC X(01) VALUE SPACE.         
           05  RS-COMPANY-NO             PIC X(02) VALUE SPACE.         
           05  RS-LOCAL-OFFICE           PIC X(03) VALUE SPACE.         
           05  RS-ACCOUNT-NO-PRIOR       PIC S9(13)V COMP-3 VALUE 0.    
           05  RS-SERV-ORDER-STATUS      PIC X(02) VALUE SPACE.         
           05  RS-ORDER-TYPE-CD          PIC X(07) VALUE SPACE.         
           05  RS-CUSTOMER-NO            PIC S9(10)V COMP-3 VALUE 0.    
           05  RS-ZIP-CODE               PIC X(05) VALUE SPACE.         
           05  RS-READ-ROUTE             PIC X(04) VALUE SPACE.         
P00152     05  RS-ADDRESS                PIC X(74) VALUE SPACE.         
P00152     05  RS-ORDER-PRIORITY-CD      PIC S9(4) USAGE COMP           
P00152                                             VALUE ZERO.          
P00152     05  RS-ACCOUNT-TYPE-CD        PIC X(01) VALUE SPACE.         
A05317     05  RS-ORDER-RECVED-BY        PIC X(40) VALUE SPACE.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
T36933     05  S-FULL-NAME               PIC X(70) VALUE SPACE.         
           05  S-FIRST-NAME              PIC X(15) VALUE SPACE.         
           05  S-MIDDLE-NAME             PIC X(15) VALUE SPACE.         
T36933     05  S-LAST-NAME               PIC X(40) VALUE SPACE.         
           05  S-NAME-FORMAT             PIC X(01) VALUE SPACE.         
           05  S-ORDER-TYPE-DESC         PIC X(15) VALUE SPACE.         
           05  S-ORDER-REASON            PIC X(15) VALUE SPACE.         
           05  S-AMOUNT-DISC-BAL         PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  S-SECURITIES-TOT-AMT      PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  S-CUR-MTH-ARREARS-CD      PIC X(01) VALUE SPACE.         
           05  S-CREDIT-GROUP            PIC X(01) VALUE SPACE.         
           05  S-ASSIGNED-DATETIME       PIC X(26) VALUE SPACE.         
           05  S-STATUS-TX               PIC X(25) VALUE SPACE.         
           05  S-ORDER-STATE-CD          PIC X(01) VALUE SPACE.         
           05  S-SERV-ORDER-NO           PIC S9(13)V COMP-3 VALUE 0.    
           05  S-ACCOUNT-NO              PIC S9(13)V COMP-3 VALUE 0.    
           05  S-TOTAL                   PIC S9(9) COMP VALUE 0.        
           05  S-PREMISE-NO              PIC S9(10)V COMP-3 VALUE 0.    
           05  S-ORDER-GROUP-CD          PIC X(01) VALUE SPACE.         
           05  S-COMPANY-NO              PIC X(02) VALUE SPACE.         
           05  S-LOCAL-OFFICE            PIC X(03) VALUE SPACE.         
           05  S-ACCOUNT-NO-PRIOR        PIC S9(13)V COMP-3 VALUE 0.    
           05  S-SERV-ORDER-STATUS       PIC X(02) VALUE SPACE.         
           05  S-ORDER-TYPE-CD           PIC X(07) VALUE SPACE.         
           05  S-CUSTOMER-NO             PIC S9(10)V COMP-3 VALUE 0.    
           05  S-ZIP-CODE                PIC X(05) VALUE SPACE.         
           05  S-READ-ROUTE              PIC X(04) VALUE SPACE.         
P00152     05  S-ADDRESS                 PIC X(74) VALUE SPACE.         
P00152     05  S-ORDER-PRIORITY-CD       PIC S9(4) USAGE COMP           
P00152                                             VALUE ZERO.          
P00152     05  S-ACCOUNT-TYPE-CD         PIC X(01) VALUE SPACE.         
A05317     05  S-ORDER-RECVED-BY         PIC X(40) VALUE SPACE.         
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                         
       01  GENERAL-WORKING-STORAGE.                                     
           05  PROGRAM-NAME              PIC X(08)   VALUE 'CSR01250'.  
           05  WS-SQLSTATE               PIC X(05)   VALUE SPACES.      
           05  WS-TOTAL-RECORDS          PIC S9(9) USAGE COMP VALUE 0.  
           05  WS-COND-TYPE              PIC S9(9) USAGE COMP VALUE 0.  
           05  WS-COMPANY-NO             PIC X(02)   VALUE SPACE.       
           05  WS-LOCAL-OFFICE           PIC X(03)   VALUE SPACE.       
           05  WS-ORDER-TYPE-CD          PIC X(05)   VALUE SPACE.       
           05  WS-ASSIGNED-START-DT      PIC X(26)   VALUE SPACE.       
           05  WS-ASSIGNED-END-DT        PIC X(26)   VALUE SPACE.       
           05  WS-RESP-AREA-ID           PIC X(03)   VALUE SPACE.       
           05  WS-WORK-AREA-ID           PIC X(12)   VALUE SPACE.       
           05  WS-SO-STATUS              PIC X(02)   VALUE SPACE.       
           05  WS-SO-STATE-CD            PIC X(01)   VALUE SPACE.       
           05  WS-ORDER-REASON           PIC X(15)   VALUE SPACE.       
           05  WS-MIN-AMT-DISC-BAL       PIC S9(9)V9(2) USAGE COMP-3    
                                                     VALUE ZERO.        
           05  WS-MAX-AMT-DISC-BAL       PIC S9(9)V9(2) USAGE COMP-3    
                                                     VALUE ZERO.        
           05  WS-READ-ROUTE             PIC S9(4) USAGE COMP VALUE 0.  
           05  WS-READ-ROUTE-NUM         PIC 9(4) VALUE 0.              
           05  WS-CREW-ID                PIC X(6) VALUE SPACE.          
           05  WS-WORK-TYPE-CD           PIC X(3) VALUE SPACE.          
           05  WS-LOW-SERV-ORDER-NO      PIC S9(13)V COMP-3 VALUE 0.    
           05  WS-HIGH-SERV-ORDER-NO     PIC S9(13)V COMP-3 VALUE 0.    
           05  WS-CUSTOMER-NO.                                          
               10  WS-CUSTOMER-NO-NUM    PIC 9(10).                     
           05  WS-PREMISE-NO.                                           
               10  WS-PREMISE-NO-NUM     PIC 9(10).                     
           05  WS-USER-ID                PIC X(07)   VALUE SPACE.       
           05  WS-CODE-TRAN-TYPE         PIC X(01)   VALUE SPACE.       
           05  WS-CODE-TRAN-TYPE1        PIC X(01)   VALUE SPACE.       
T10523*    05  WS-FROM-DATE              PIC X(10)   VALUE SPACE.               
T10523*    05  WS-TO-DATE                PIC X(10)   VALUE SPACE.               
T10523     05  WS-FROM-TS                PIC X(26).                     
T10523     05  WS-FROM-TS-R REDEFINES    WS-FROM-TS.                    
T10523         10  WS-FROM-DATE          PIC X(10).                     
T10523         10  WS-FROM-TIME          PIC X(16).                     
T10523     05  WS-TO-TS                  PIC X(26).                     
T10523     05  WS-TO-TS-R   REDEFINES    WS-TO-TS.                      
T10523         10  WS-TO-DATE            PIC X(10).                     
T10523         10  WS-TO-TIME            PIC X(16).                     
           05  WS-ROWS-RETURNED          PIC S9(9)   VALUE 0.           
           05  WS-ACCT-CREATE-DT         PIC X(26)   VALUE SPACE.       
           05  WS-TODAY-DATE             PIC X(10)   VALUE SPACE.       
           05  WS-TODAY-DATE-25          PIC X(10)   VALUE SPACE.       
           05  WS-SEND-FLAG              PIC X(02)   VALUE SPACE.       
           05  WS-DATA-AR                PIC X(05)   VALUE SPACE.       
           05  WS-DATA-MN                PIC X(05)   VALUE SPACE.       
           05  WS-LOW-DATE               PIC X(10)                      
               VALUE '0001-01-01'.                                      
           05  WS-DATE-COMP-AR           PIC X(10)   VALUE SPACE.       
           05  WS-DATE-COMP-MH           PIC X(10)   VALUE SPACE.       
COB305     05 WS-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-NAME-TYPE              PIC X(02)   VALUE SPACE.       
           05  WS-NAME-FORMAT            PIC X(01)   VALUE SPACE.       
T36933     05  WS-FULL-NAME              PIC X(70)   VALUE SPACE.       
           05  WS-FIRST-NAME             PIC X(15)   VALUE SPACE.       
           05  WS-MIDDLE-NAME            PIC X(15)   VALUE SPACE.       
T36933     05  WS-LAST-NAME              PIC X(40)   VALUE SPACE.       
COB305     05 WS-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  WS-HOUSE-NO               PIC X(05)   VALUE SPACE.       
           05  WS-STREET-NAME            PIC X(16)   VALUE SPACE.       
           05  WS-MH-DATE-TRANS-NI       PIC S9(4) COMP VALUE 0.        
           05  WS-AR-DATE-TRANS-NI       PIC S9(4) COMP VALUE 0.        
           05  WS-DOP-NI                 PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-HOLD              PIC X(10) VALUE SPACES.        
           05  WS-DATE-HOLD-USA          PIC X(10) VALUE SPACES.        
           05  WS-AR-APPL-PROGRAM-DESC   PIC X(20) VALUE SPACES.        
           05  WS-MH-APPL-PROGRAM-DESC   PIC X(20) VALUE SPACES.        
A05317     05  WS-USER-NAME              PIC X(40) VALUE SPACES.        
                                                                        
P0282  05  WS-DATE-CCYYMMDD.                                            
P0282      10  WS-CCYY              PIC X(04).                          
P0282      10  WS-MM                PIC X(02).                          
P0282      10  WS-DD                PIC X(02).                          
P0282  05  WS-DATE-MMDDCCYY.                                            
P0282      10  WS-MONTH             PIC X(02) VALUE SPACES.             
P0282      10  WS-DAY               PIC X(02) VALUE SPACES.             
P0282      10  WS-YEAR              PIC X(04) VALUE SPACES.             
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS WITH CREW >                       
                                                                        
           EXEC SQL DECLARE CREW-CURSOR CURSOR FOR                      
           SELECT TOP(400) SO.ORDER_REASON,
              DN.AMOUNT_DISC_BAL,
              DN.SECURITIES_TOT_AMT,
              DN.CUR_MTH_ARREARS_CD,
              DN.CREDIT_GROUP,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              SO.ORDER_STATE_CD,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.PREMISE_NO,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.SERV_ORDER_STATUS,
              SO.ORDER_TYPE_CD,
              SC.READ_ROUTE,
              SO.ORDER_PRIORITY_CD,
              SO.ACCOUNT_TYPE_CODE,
              SO.ORDER_RECVED_BY                                      
           FROM                                                         
                CSS_SO_DATA        SO WITH(READUNCOMMITTED)                     
               ,CSS_SO_ORDER_INST  OI WITH(READUNCOMMITTED)                     
               ,CSS_SO_DNP         DN WITH(READUNCOMMITTED)                     
               ,CSS_SO_UTL_CHG     SC WITH(READUNCOMMITTED)                     
               ,CSS_SO_CREW        WM WITH(READUNCOMMITTED)                     
            WHERE                                                       
                SO.COMPANY_NO         = :WS-COMPANY-NO                  
            AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                
            AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD               
            AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )           
            AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )             
            AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID          
                  AND :WS-IS-RSP-AREA-NULL  = 'N' )                     
                  OR  :WS-IS-RSP-AREA-NULL  = 'Y'                       
                )                                                       
            AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID          
                  AND :WS-IS-WRK-AREA-NULL  = 'N' )                     
                  OR  :WS-IS-WRK-AREA-NULL  = 'Y'                       
                )                                                       
            AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS             
                  AND :WS-IS-STATUS-NULL    = 'N' )                     
                  OR  :WS-IS-STATUS-NULL    = 'Y'                       
                )                                                       
            AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD           
                  AND :WS-IS-STATE-NULL     = 'N' )                     
                  OR  :WS-IS-STATE-NULL     = 'Y'                       
                )                                                       
            AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON          
                  AND :WS-IS-ORD-RSN-NULL   = 'N' )                     
                  OR  :WS-IS-ORD-RSN-NULL   = 'Y'                       
                )                                                       
            AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL            
            AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL            
            AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE            
                  AND :WS-IS-RD-ROUTE-NULL  = 'N' )                     
                  OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                       
                )                                                       
            AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND WM.CREW_ID            = :WS-CREW-ID                     
            AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD              
                  AND :WS-IS-WRK-TYPE-NULL = 'N' )                      
                  OR  :WS-IS-WRK-TYPE-NULL = 'Y'                        
                )                                                       
            AND                                                         
            (     :WS-COND-TYPE = 1                                     
               OR (     :WS-COND-TYPE     = 2                           
                    AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )    
               OR (     :WS-COND-TYPE     = 3                           
                    AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO       
                    AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )    
            )                                                           
            ORDER BY                                                    
                SO.SERV_ORDER_NO                                        
            
            OPTION(FAST 1)
            FOR READ ONLY
                                                      
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ020
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE CREW-CURSOR CURSOR FOR                              
MFA-TR*    SELECT                                                               
MFA-TR*         SO.ORDER_REASON                                                 
MFA-TR*        ,DN.AMOUNT_DISC_BAL                                              
MFA-TR*        ,DN.SECURITIES_TOT_AMT                                           
MFA-TR*        ,DN.CUR_MTH_ARREARS_CD                                           
MFA-TR*        ,DN.CREDIT_GROUP                                                 
MFA-TR*        ,SO.ASSIGNED_DATETIME                                            
MFA-TR*        ,SO.ORDER_STATE_CD                                               
MFA-TR*        ,SO.SERV_ORDER_NO                                                
MFA-TR*        ,SO.ACCOUNT_NO                                                   
MFA-TR*        ,SO.PREMISE_NO                                                   
MFA-TR*        ,SO.COMPANY_NO                                                   
MFA-TR*        ,SO.LOCAL_OFFICE                                                 
MFA-TR*        ,SO.ACCOUNT_NO_PRIOR                                             
MFA-TR*        ,SO.SERV_ORDER_STATUS                                            
MFA-TR*        ,SO.ORDER_TYPE_CD                                                
MFA-TR*        ,SC.READ_ROUTE                                                   
MFA-TR*        ,SO.ORDER_PRIORITY_CD                                            
MFA-TR*        ,SO.ACCOUNT_TYPE_CODE                                            
MFA-TR*        ,SO.ORDER_RECVED_BY                                              
MFA-TR*    FROM                                                                 
MFA-TR*         CSS_SO_DATA        SO                                           
MFA-TR*        ,CSS_SO_ORDER_INST  OI                                           
MFA-TR*        ,CSS_SO_DNP         DN                                           
MFA-TR*        ,CSS_SO_UTL_CHG     SC                                           
MFA-TR*        ,CSS_SO_CREW        WM                                           
MFA-TR*     WHERE                                                               
MFA-TR*         SO.COMPANY_NO         = :WS-COMPANY-NO                          
MFA-TR*     AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                        
MFA-TR*     AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                       
MFA-TR*     AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT                   
MFA-TR*     AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT                     
MFA-TR*     AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID                  
MFA-TR*           AND :WS-IS-RSP-AREA-NULL  = 'N' )                             
MFA-TR*           OR  :WS-IS-RSP-AREA-NULL  = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID                  
MFA-TR*           AND :WS-IS-WRK-AREA-NULL  = 'N' )                             
MFA-TR*           OR  :WS-IS-WRK-AREA-NULL  = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS                     
MFA-TR*           AND :WS-IS-STATUS-NULL    = 'N' )                             
MFA-TR*           OR  :WS-IS-STATUS-NULL    = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                   
MFA-TR*           AND :WS-IS-STATE-NULL     = 'N' )                             
MFA-TR*           OR  :WS-IS-STATE-NULL     = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON                  
MFA-TR*           AND :WS-IS-ORD-RSN-NULL   = 'N' )                             
MFA-TR*           OR  :WS-IS-ORD-RSN-NULL   = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL                    
MFA-TR*     AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL                    
MFA-TR*     AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE                    
MFA-TR*           AND :WS-IS-RD-ROUTE-NULL  = 'N' )                             
MFA-TR*           OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND WM.CREW_ID            = :WS-CREW-ID                             
MFA-TR*     AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD                      
MFA-TR*           AND :WS-IS-WRK-TYPE-NULL = 'N' )                              
MFA-TR*           OR  :WS-IS-WRK-TYPE-NULL = 'Y'                                
MFA-TR*         )                                                               
MFA-TR*     AND                                                                 
MFA-TR*     (     :WS-COND-TYPE = 1                                             
MFA-TR*        OR (     :WS-COND-TYPE     = 2                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*        OR (     :WS-COND-TYPE     = 3                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO               
MFA-TR*             AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*     )                                                                   
MFA-TR*     ORDER BY                                                            
MFA-TR*         SO.SERV_ORDER_NO                                                
MFA-TR*     FETCH FIRST 400 ROWS ONLY                                           
MFA-TR*     FOR READ ONLY WITH UR                                               
MFA-TR*     OPTIMIZE FOR 1 ROW                                                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS WITHOUT CREW >                    
                                                                        
           EXEC SQL DECLARE NON-CREW-CURSOR CURSOR FOR                  
           SELECT TOP(400) SO.ORDER_REASON,
              DN.AMOUNT_DISC_BAL,
              DN.SECURITIES_TOT_AMT,
              DN.CUR_MTH_ARREARS_CD,
              DN.CREDIT_GROUP,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              SO.ORDER_STATE_CD,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.PREMISE_NO,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.SERV_ORDER_STATUS,
              SO.ORDER_TYPE_CD,
              SC.READ_ROUTE,
              SO.ORDER_PRIORITY_CD,
              SO.ACCOUNT_TYPE_CODE,
              SO.ORDER_RECVED_BY                                      
           FROM                                                         
                CSS_SO_DATA        SO WITH(READUNCOMMITTED)                     
               ,CSS_SO_ORDER_INST  OI WITH(READUNCOMMITTED)                     
               ,CSS_SO_DNP         DN WITH(READUNCOMMITTED)                     
               ,CSS_SO_UTL_CHG     SC WITH(READUNCOMMITTED)                     
            WHERE                                                       
                SO.COMPANY_NO         = :WS-COMPANY-NO                  
            AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                
            AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD               
            AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )           
            AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )             
            AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID          
                  AND :WS-IS-RSP-AREA-NULL  = 'N' )                     
                  OR  :WS-IS-RSP-AREA-NULL  = 'Y'                       
                )                                                       
            AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID          
                  AND :WS-IS-WRK-AREA-NULL  = 'N' )                     
                  OR  :WS-IS-WRK-AREA-NULL  = 'Y'                       
                )                                                       
            AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS             
                  AND :WS-IS-STATUS-NULL    = 'N' )                     
                  OR  :WS-IS-STATUS-NULL    = 'Y'                       
                )                                                       
            AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD           
                  AND :WS-IS-STATE-NULL     = 'N' )                     
                  OR  :WS-IS-STATE-NULL     = 'Y'                       
                )                                                       
            AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON          
                  AND :WS-IS-ORD-RSN-NULL   = 'N' )                     
                  OR  :WS-IS-ORD-RSN-NULL   = 'Y'                       
                )                                                       
            AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL            
            AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL            
            AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE            
                  AND :WS-IS-RD-ROUTE-NULL  = 'N' )                     
                  OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                       
                )                                                       
            AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD              
                  AND :WS-IS-WRK-TYPE-NULL = 'N' )                      
                  OR  :WS-IS-WRK-TYPE-NULL = 'Y'                        
                )                                                       
            AND                                                         
            (     :WS-COND-TYPE = 1                                     
               OR (     :WS-COND-TYPE     = 2                           
                    AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )    
               OR (     :WS-COND-TYPE     = 3                           
                    AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO       
                    AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )    
            )                                                           
            ORDER BY                                                    
                SO.SERV_ORDER_NO                                        
            
            OPTION(FAST 1)
            FOR READ ONLY
                                                      
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ020
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE NON-CREW-CURSOR CURSOR FOR                          
MFA-TR*    SELECT                                                               
MFA-TR*         SO.ORDER_REASON                                                 
MFA-TR*        ,DN.AMOUNT_DISC_BAL                                              
MFA-TR*        ,DN.SECURITIES_TOT_AMT                                           
MFA-TR*        ,DN.CUR_MTH_ARREARS_CD                                           
MFA-TR*        ,DN.CREDIT_GROUP                                                 
MFA-TR*        ,SO.ASSIGNED_DATETIME                                            
MFA-TR*        ,SO.ORDER_STATE_CD                                               
MFA-TR*        ,SO.SERV_ORDER_NO                                                
MFA-TR*        ,SO.ACCOUNT_NO                                                   
MFA-TR*        ,SO.PREMISE_NO                                                   
MFA-TR*        ,SO.COMPANY_NO                                                   
MFA-TR*        ,SO.LOCAL_OFFICE                                                 
MFA-TR*        ,SO.ACCOUNT_NO_PRIOR                                             
MFA-TR*        ,SO.SERV_ORDER_STATUS                                            
MFA-TR*        ,SO.ORDER_TYPE_CD                                                
MFA-TR*        ,SC.READ_ROUTE                                                   
MFA-TR*        ,SO.ORDER_PRIORITY_CD                                            
MFA-TR*        ,SO.ACCOUNT_TYPE_CODE                                            
MFA-TR*        ,SO.ORDER_RECVED_BY                                              
MFA-TR*    FROM                                                                 
MFA-TR*         CSS_SO_DATA        SO                                           
MFA-TR*        ,CSS_SO_ORDER_INST  OI                                           
MFA-TR*        ,CSS_SO_DNP         DN                                           
MFA-TR*        ,CSS_SO_UTL_CHG     SC                                           
MFA-TR*     WHERE                                                               
MFA-TR*         SO.COMPANY_NO         = :WS-COMPANY-NO                          
MFA-TR*     AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                        
MFA-TR*     AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                       
MFA-TR*     AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT                   
MFA-TR*     AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT                     
MFA-TR*     AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID                  
MFA-TR*           AND :WS-IS-RSP-AREA-NULL  = 'N' )                             
MFA-TR*           OR  :WS-IS-RSP-AREA-NULL  = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID                  
MFA-TR*           AND :WS-IS-WRK-AREA-NULL  = 'N' )                             
MFA-TR*           OR  :WS-IS-WRK-AREA-NULL  = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS                     
MFA-TR*           AND :WS-IS-STATUS-NULL    = 'N' )                             
MFA-TR*           OR  :WS-IS-STATUS-NULL    = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                   
MFA-TR*           AND :WS-IS-STATE-NULL     = 'N' )                             
MFA-TR*           OR  :WS-IS-STATE-NULL     = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON                  
MFA-TR*           AND :WS-IS-ORD-RSN-NULL   = 'N' )                             
MFA-TR*           OR  :WS-IS-ORD-RSN-NULL   = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL                    
MFA-TR*     AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL                    
MFA-TR*     AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE                    
MFA-TR*           AND :WS-IS-RD-ROUTE-NULL  = 'N' )                             
MFA-TR*           OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD                      
MFA-TR*           AND :WS-IS-WRK-TYPE-NULL = 'N' )                              
MFA-TR*           OR  :WS-IS-WRK-TYPE-NULL = 'Y'                                
MFA-TR*         )                                                               
MFA-TR*     AND                                                                 
MFA-TR*     (     :WS-COND-TYPE = 1                                             
MFA-TR*        OR (     :WS-COND-TYPE     = 2                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*        OR (     :WS-COND-TYPE     = 3                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO               
MFA-TR*             AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*     )                                                                   
MFA-TR*     ORDER BY                                                            
MFA-TR*         SO.SERV_ORDER_NO                                                
MFA-TR*     FETCH FIRST 400 ROWS ONLY                                           
MFA-TR*     FOR READ ONLY WITH UR                                               
MFA-TR*     OPTIMIZE FOR 1 ROW                                                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
      *--- < CURSOR FOR SERVICE ORDER DETAILS WITH CREW HAVING SPECFIC          
      *----< ARGUMENTS                                                          
           EXEC SQL DECLARE CREW-CURSOR-S1 CURSOR FOR                   
           SELECT TOP(400) SO.ORDER_REASON,
              DN.AMOUNT_DISC_BAL,
              DN.SECURITIES_TOT_AMT,
              DN.CUR_MTH_ARREARS_CD,
              DN.CREDIT_GROUP,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              SO.ORDER_STATE_CD,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.PREMISE_NO,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.SERV_ORDER_STATUS,
              SO.ORDER_TYPE_CD,
              SC.READ_ROUTE,
              SO.ORDER_PRIORITY_CD,
              SO.ACCOUNT_TYPE_CODE,
              SO.ORDER_RECVED_BY                                      
           FROM                                                         
                CSS_SO_DATA        SO WITH(READUNCOMMITTED)                     
               ,CSS_SO_DNP         DN WITH(READUNCOMMITTED)                     
               ,CSS_SO_UTL_CHG     SC WITH(READUNCOMMITTED)                     
               ,CSS_SO_CREW        WM WITH(READUNCOMMITTED)                     
            WHERE                                                       
                SO.COMPANY_NO         = :WS-COMPANY-NO                  
            AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                
            AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD               
            AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                 
            AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )           
            AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )             
            AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL            
            AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL            
            AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND WM.CREW_ID            = :WS-CREW-ID                     
            AND                                                         
            (     :WS-COND-TYPE = 1                                     
               OR (     :WS-COND-TYPE     = 2                           
                    AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )    
               OR (     :WS-COND-TYPE     = 3                           
                    AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO       
                    AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )    
            )                                                           
            ORDER BY                                                    
                SO.SERV_ORDER_NO                                        
            
            OPTION(FAST 1)
            FOR READ ONLY
                                                      
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ020
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE CREW-CURSOR-S1 CURSOR FOR                           
MFA-TR*    SELECT                                                               
MFA-TR*         SO.ORDER_REASON                                                 
MFA-TR*        ,DN.AMOUNT_DISC_BAL                                              
MFA-TR*        ,DN.SECURITIES_TOT_AMT                                           
MFA-TR*        ,DN.CUR_MTH_ARREARS_CD                                           
MFA-TR*        ,DN.CREDIT_GROUP                                                 
MFA-TR*        ,SO.ASSIGNED_DATETIME                                            
MFA-TR*        ,SO.ORDER_STATE_CD                                               
MFA-TR*        ,SO.SERV_ORDER_NO                                                
MFA-TR*        ,SO.ACCOUNT_NO                                                   
MFA-TR*        ,SO.PREMISE_NO                                                   
MFA-TR*        ,SO.COMPANY_NO                                                   
MFA-TR*        ,SO.LOCAL_OFFICE                                                 
MFA-TR*        ,SO.ACCOUNT_NO_PRIOR                                             
MFA-TR*        ,SO.SERV_ORDER_STATUS                                            
MFA-TR*        ,SO.ORDER_TYPE_CD                                                
MFA-TR*        ,SC.READ_ROUTE                                                   
MFA-TR*        ,SO.ORDER_PRIORITY_CD                                            
MFA-TR*        ,SO.ACCOUNT_TYPE_CODE                                            
MFA-TR*        ,SO.ORDER_RECVED_BY                                              
MFA-TR*    FROM                                                                 
MFA-TR*         CSS_SO_DATA        SO                                           
MFA-TR*        ,CSS_SO_DNP         DN                                           
MFA-TR*        ,CSS_SO_UTL_CHG     SC                                           
MFA-TR*        ,CSS_SO_CREW        WM                                           
MFA-TR*     WHERE                                                               
MFA-TR*         SO.COMPANY_NO         = :WS-COMPANY-NO                          
MFA-TR*     AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                        
MFA-TR*     AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                       
MFA-TR*     AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                         
MFA-TR*     AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT                   
MFA-TR*     AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT                     
MFA-TR*     AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL                    
MFA-TR*     AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL                    
MFA-TR*     AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND WM.CREW_ID            = :WS-CREW-ID                             
MFA-TR*     AND                                                                 
MFA-TR*     (     :WS-COND-TYPE = 1                                             
MFA-TR*        OR (     :WS-COND-TYPE     = 2                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*        OR (     :WS-COND-TYPE     = 3                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO               
MFA-TR*             AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*     )                                                                   
MFA-TR*     ORDER BY                                                            
MFA-TR*         SO.SERV_ORDER_NO                                                
MFA-TR*     FETCH FIRST 400 ROWS ONLY                                           
MFA-TR*     FOR READ ONLY WITH UR                                               
MFA-TR*     OPTIMIZE FOR 1 ROW                                                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS WITHOUT CREW >                    
                                                                        
           EXEC SQL DECLARE NON-CREW-CURSOR-S1 CURSOR FOR               
           SELECT TOP(400) SO.ORDER_REASON,
              DN.AMOUNT_DISC_BAL,
              DN.SECURITIES_TOT_AMT,
              DN.CUR_MTH_ARREARS_CD,
              DN.CREDIT_GROUP,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              SO.ORDER_STATE_CD,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.PREMISE_NO,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.SERV_ORDER_STATUS,
              SO.ORDER_TYPE_CD,
              SC.READ_ROUTE,
              SO.ORDER_PRIORITY_CD,
              SO.ACCOUNT_TYPE_CODE,
              SO.ORDER_RECVED_BY                                      
           FROM                                                         
                CSS_SO_DATA        SO WITH(READUNCOMMITTED)                     
               ,CSS_SO_DNP         DN WITH(READUNCOMMITTED)                     
               ,CSS_SO_UTL_CHG     SC WITH(READUNCOMMITTED)                     
            WHERE                                                       
                SO.COMPANY_NO         = :WS-COMPANY-NO                  
            AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                
            AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD               
            AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                 
            AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )           
            AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )             
            AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL            
            AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL            
            AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND                                                         
            (     :WS-COND-TYPE = 1                                     
               OR (     :WS-COND-TYPE     = 2                           
                    AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )    
               OR (     :WS-COND-TYPE     = 3                           
                    AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO       
                    AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )    
            )                                                           
            ORDER BY                                                    
                SO.SERV_ORDER_NO                                        
            
            OPTION(FAST 1)
            FOR READ ONLY
                                                      
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ020
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE NON-CREW-CURSOR-S1 CURSOR FOR                       
MFA-TR*    SELECT                                                               
MFA-TR*         SO.ORDER_REASON                                                 
MFA-TR*        ,DN.AMOUNT_DISC_BAL                                              
MFA-TR*        ,DN.SECURITIES_TOT_AMT                                           
MFA-TR*        ,DN.CUR_MTH_ARREARS_CD                                           
MFA-TR*        ,DN.CREDIT_GROUP                                                 
MFA-TR*        ,SO.ASSIGNED_DATETIME                                            
MFA-TR*        ,SO.ORDER_STATE_CD                                               
MFA-TR*        ,SO.SERV_ORDER_NO                                                
MFA-TR*        ,SO.ACCOUNT_NO                                                   
MFA-TR*        ,SO.PREMISE_NO                                                   
MFA-TR*        ,SO.COMPANY_NO                                                   
MFA-TR*        ,SO.LOCAL_OFFICE                                                 
MFA-TR*        ,SO.ACCOUNT_NO_PRIOR                                             
MFA-TR*        ,SO.SERV_ORDER_STATUS                                            
MFA-TR*        ,SO.ORDER_TYPE_CD                                                
MFA-TR*        ,SC.READ_ROUTE                                                   
MFA-TR*        ,SO.ORDER_PRIORITY_CD                                            
MFA-TR*        ,SO.ACCOUNT_TYPE_CODE                                            
MFA-TR*        ,SO.ORDER_RECVED_BY                                              
MFA-TR*    FROM                                                                 
MFA-TR*         CSS_SO_DATA        SO                                           
MFA-TR*        ,CSS_SO_DNP         DN                                           
MFA-TR*        ,CSS_SO_UTL_CHG     SC                                           
MFA-TR*     WHERE                                                               
MFA-TR*         SO.COMPANY_NO         = :WS-COMPANY-NO                          
MFA-TR*     AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                        
MFA-TR*     AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                       
MFA-TR*     AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                         
MFA-TR*     AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT                   
MFA-TR*     AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT                     
MFA-TR*     AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL                    
MFA-TR*     AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL                    
MFA-TR*     AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND                                                                 
MFA-TR*     (     :WS-COND-TYPE = 1                                             
MFA-TR*        OR (     :WS-COND-TYPE     = 2                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*        OR (     :WS-COND-TYPE     = 3                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO               
MFA-TR*             AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*     )                                                                   
MFA-TR*     ORDER BY                                                            
MFA-TR*         SO.SERV_ORDER_NO                                                
MFA-TR*     FETCH FIRST 400 ROWS ONLY                                           
MFA-TR*     FOR READ ONLY WITH UR                                               
MFA-TR*     OPTIMIZE FOR 1 ROW                                                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS WITH CREW FOR HISTORY >           
           EXEC SQL DECLARE HST-CREW-CURSOR CURSOR FOR                  
           SELECT TOP(400) SO.ORDER_REASON,
              DN.AMOUNT_DISC_BAL,
              DN.SECURITIES_TOT_AMT,
              DN.CUR_MTH_ARREARS_CD,
              DN.CREDIT_GROUP,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              SO.ORDER_STATE_CD,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.PREMISE_NO,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.SERV_ORDER_STATUS,
              SO.ORDER_TYPE_CD,
              SC.READ_ROUTE,
              SO.ORDER_PRIORITY_CD,
              SO.ACCOUNT_TYPE_CODE,
              SO.ORDER_RECVED_BY                                      
           FROM                                                         
                HST_SO_DATA       SO WITH(READUNCOMMITTED)                      
               ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                      
               ,HST_SO_DNP        DN WITH(READUNCOMMITTED)                      
               ,HST_SO_UTL_CHG    SC WITH(READUNCOMMITTED)                      
               ,HST_SO_CREW       WM WITH(READUNCOMMITTED)                      
            WHERE                                                       
                SO.COMPANY_NO         = :WS-COMPANY-NO                  
            AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                
            AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD               
            AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )           
            AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )             
            AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID          
                  AND :WS-IS-RSP-AREA-NULL  = 'N' )                     
                  OR  :WS-IS-RSP-AREA-NULL  = 'Y'                       
                )                                                       
            AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID          
                  AND :WS-IS-WRK-AREA-NULL  = 'N' )                     
                  OR  :WS-IS-WRK-AREA-NULL  = 'Y'                       
                )                                                       
            AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS             
                  AND :WS-IS-STATUS-NULL    = 'N' )                     
                  OR  :WS-IS-STATUS-NULL    = 'Y'                       
                )                                                       
            AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD           
                  AND :WS-IS-STATE-NULL     = 'N' )                     
                  OR  :WS-IS-STATE-NULL     = 'Y'                       
                )                                                       
            AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON          
                  AND :WS-IS-ORD-RSN-NULL   = 'N' )                     
                  OR  :WS-IS-ORD-RSN-NULL   = 'Y'                       
                )                                                       
            AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL            
            AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL            
            AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE            
                  AND :WS-IS-RD-ROUTE-NULL  = 'N' )                     
                  OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                       
                )                                                       
            AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND WM.CREW_ID            = :WS-CREW-ID                     
            AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD              
                  AND :WS-IS-WRK-TYPE-NULL = 'N' )                      
                  OR  :WS-IS-WRK-TYPE-NULL = 'Y'                        
                )                                                       
            AND                                                         
            (     :WS-COND-TYPE = 1                                     
               OR (     :WS-COND-TYPE     = 2                           
                    AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )    
               OR (     :WS-COND-TYPE     = 3                           
                    AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO       
                    AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )    
            )                                                           
            ORDER BY                                                    
                SO.SERV_ORDER_NO                                        
            
            OPTION(FAST 1)
            FOR READ ONLY
                                                      
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ020
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE HST-CREW-CURSOR CURSOR FOR                          
MFA-TR*    SELECT                                                               
MFA-TR*         SO.ORDER_REASON                                                 
MFA-TR*        ,DN.AMOUNT_DISC_BAL                                              
MFA-TR*        ,DN.SECURITIES_TOT_AMT                                           
MFA-TR*        ,DN.CUR_MTH_ARREARS_CD                                           
MFA-TR*        ,DN.CREDIT_GROUP                                                 
MFA-TR*        ,SO.ASSIGNED_DATETIME                                            
MFA-TR*        ,SO.ORDER_STATE_CD                                               
MFA-TR*        ,SO.SERV_ORDER_NO                                                
MFA-TR*        ,SO.ACCOUNT_NO                                                   
MFA-TR*        ,SO.PREMISE_NO                                                   
MFA-TR*        ,SO.COMPANY_NO                                                   
MFA-TR*        ,SO.LOCAL_OFFICE                                                 
MFA-TR*        ,SO.ACCOUNT_NO_PRIOR                                             
MFA-TR*        ,SO.SERV_ORDER_STATUS                                            
MFA-TR*        ,SO.ORDER_TYPE_CD                                                
MFA-TR*        ,SC.READ_ROUTE                                                   
MFA-TR*        ,SO.ORDER_PRIORITY_CD                                            
MFA-TR*        ,SO.ACCOUNT_TYPE_CODE                                            
MFA-TR*        ,SO.ORDER_RECVED_BY                                              
MFA-TR*    FROM                                                                 
MFA-TR*         HST_SO_DATA       SO                                            
MFA-TR*        ,HST_SO_ORDER_INST OI                                            
MFA-TR*        ,HST_SO_DNP        DN                                            
MFA-TR*        ,HST_SO_UTL_CHG    SC                                            
MFA-TR*        ,HST_SO_CREW       WM                                            
MFA-TR*     WHERE                                                               
MFA-TR*         SO.COMPANY_NO         = :WS-COMPANY-NO                          
MFA-TR*     AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                        
MFA-TR*     AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                       
MFA-TR*     AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT                   
MFA-TR*     AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT                     
MFA-TR*     AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID                  
MFA-TR*           AND :WS-IS-RSP-AREA-NULL  = 'N' )                             
MFA-TR*           OR  :WS-IS-RSP-AREA-NULL  = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID                  
MFA-TR*           AND :WS-IS-WRK-AREA-NULL  = 'N' )                             
MFA-TR*           OR  :WS-IS-WRK-AREA-NULL  = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS                     
MFA-TR*           AND :WS-IS-STATUS-NULL    = 'N' )                             
MFA-TR*           OR  :WS-IS-STATUS-NULL    = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                   
MFA-TR*           AND :WS-IS-STATE-NULL     = 'N' )                             
MFA-TR*           OR  :WS-IS-STATE-NULL     = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON                  
MFA-TR*           AND :WS-IS-ORD-RSN-NULL   = 'N' )                             
MFA-TR*           OR  :WS-IS-ORD-RSN-NULL   = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL                    
MFA-TR*     AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL                    
MFA-TR*     AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE                    
MFA-TR*           AND :WS-IS-RD-ROUTE-NULL  = 'N' )                             
MFA-TR*           OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND WM.CREW_ID            = :WS-CREW-ID                             
MFA-TR*     AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD                      
MFA-TR*           AND :WS-IS-WRK-TYPE-NULL = 'N' )                              
MFA-TR*           OR  :WS-IS-WRK-TYPE-NULL = 'Y'                                
MFA-TR*         )                                                               
MFA-TR*     AND                                                                 
MFA-TR*     (     :WS-COND-TYPE = 1                                             
MFA-TR*        OR (     :WS-COND-TYPE     = 2                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*        OR (     :WS-COND-TYPE     = 3                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO               
MFA-TR*             AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*     )                                                                   
MFA-TR*     ORDER BY                                                            
MFA-TR*         SO.SERV_ORDER_NO                                                
MFA-TR*     FETCH FIRST 400 ROWS ONLY                                           
MFA-TR*     FOR READ ONLY WITH UR                                               
MFA-TR*     OPTIMIZE FOR 1 ROW                                                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS WITHOUT CREW FOR HISTORY>         
                                                                        
           EXEC SQL DECLARE HST-NON-CREW-CURSOR CURSOR FOR              
           SELECT TOP(400) SO.ORDER_REASON,
              DN.AMOUNT_DISC_BAL,
              DN.SECURITIES_TOT_AMT,
              DN.CUR_MTH_ARREARS_CD,
              DN.CREDIT_GROUP,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              SO.ORDER_STATE_CD,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.PREMISE_NO,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.SERV_ORDER_STATUS,
              SO.ORDER_TYPE_CD,
              SC.READ_ROUTE,
              SO.ORDER_PRIORITY_CD,
              SO.ACCOUNT_TYPE_CODE,
              SO.ORDER_RECVED_BY                                      
           FROM                                                         
                HST_SO_DATA       SO WITH(READUNCOMMITTED)                      
               ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                      
               ,HST_SO_DNP        DN WITH(READUNCOMMITTED)                      
               ,HST_SO_UTL_CHG    SC WITH(READUNCOMMITTED)                      
            WHERE                                                       
                SO.COMPANY_NO         = :WS-COMPANY-NO                  
            AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                
            AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD               
            AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )           
            AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )             
            AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID          
                  AND :WS-IS-RSP-AREA-NULL  = 'N' )                     
                  OR  :WS-IS-RSP-AREA-NULL  = 'Y'                       
                )                                                       
            AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID          
                  AND :WS-IS-WRK-AREA-NULL  = 'N' )                     
                  OR  :WS-IS-WRK-AREA-NULL  = 'Y'                       
                )                                                       
            AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS             
                  AND :WS-IS-STATUS-NULL    = 'N' )                     
                  OR  :WS-IS-STATUS-NULL    = 'Y'                       
                )                                                       
            AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD           
                  AND :WS-IS-STATE-NULL     = 'N' )                     
                  OR  :WS-IS-STATE-NULL     = 'Y'                       
                )                                                       
            AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON          
                  AND :WS-IS-ORD-RSN-NULL   = 'N' )                     
                  OR  :WS-IS-ORD-RSN-NULL   = 'Y'                       
                )                                                       
            AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL            
            AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL            
            AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE            
                  AND :WS-IS-RD-ROUTE-NULL  = 'N' )                     
                  OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                       
                )                                                       
            AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD              
                  AND :WS-IS-WRK-TYPE-NULL = 'N' )                      
                  OR  :WS-IS-WRK-TYPE-NULL = 'Y'                        
                )                                                       
            AND                                                         
            (     :WS-COND-TYPE = 1                                     
               OR (     :WS-COND-TYPE     = 2                           
                    AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )    
               OR (     :WS-COND-TYPE     = 3                           
                    AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO       
                    AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )    
            )                                                           
            ORDER BY                                                    
                SO.SERV_ORDER_NO                                        
            
            OPTION(FAST 1)
            FOR READ ONLY
                                                      
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ020
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE HST-NON-CREW-CURSOR CURSOR FOR                      
MFA-TR*    SELECT                                                               
MFA-TR*         SO.ORDER_REASON                                                 
MFA-TR*        ,DN.AMOUNT_DISC_BAL                                              
MFA-TR*        ,DN.SECURITIES_TOT_AMT                                           
MFA-TR*        ,DN.CUR_MTH_ARREARS_CD                                           
MFA-TR*        ,DN.CREDIT_GROUP                                                 
MFA-TR*        ,SO.ASSIGNED_DATETIME                                            
MFA-TR*        ,SO.ORDER_STATE_CD                                               
MFA-TR*        ,SO.SERV_ORDER_NO                                                
MFA-TR*        ,SO.ACCOUNT_NO                                                   
MFA-TR*        ,SO.PREMISE_NO                                                   
MFA-TR*        ,SO.COMPANY_NO                                                   
MFA-TR*        ,SO.LOCAL_OFFICE                                                 
MFA-TR*        ,SO.ACCOUNT_NO_PRIOR                                             
MFA-TR*        ,SO.SERV_ORDER_STATUS                                            
MFA-TR*        ,SO.ORDER_TYPE_CD                                                
MFA-TR*        ,SC.READ_ROUTE                                                   
MFA-TR*        ,SO.ORDER_PRIORITY_CD                                            
MFA-TR*        ,SO.ACCOUNT_TYPE_CODE                                            
MFA-TR*        ,SO.ORDER_RECVED_BY                                              
MFA-TR*    FROM                                                                 
MFA-TR*         HST_SO_DATA       SO                                            
MFA-TR*        ,HST_SO_ORDER_INST OI                                            
MFA-TR*        ,HST_SO_DNP        DN                                            
MFA-TR*        ,HST_SO_UTL_CHG    SC                                            
MFA-TR*     WHERE                                                               
MFA-TR*         SO.COMPANY_NO         = :WS-COMPANY-NO                          
MFA-TR*     AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                        
MFA-TR*     AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                       
MFA-TR*     AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT                   
MFA-TR*     AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT                     
MFA-TR*     AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID                  
MFA-TR*           AND :WS-IS-RSP-AREA-NULL  = 'N' )                             
MFA-TR*           OR  :WS-IS-RSP-AREA-NULL  = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID                  
MFA-TR*           AND :WS-IS-WRK-AREA-NULL  = 'N' )                             
MFA-TR*           OR  :WS-IS-WRK-AREA-NULL  = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS                     
MFA-TR*           AND :WS-IS-STATUS-NULL    = 'N' )                             
MFA-TR*           OR  :WS-IS-STATUS-NULL    = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                   
MFA-TR*           AND :WS-IS-STATE-NULL     = 'N' )                             
MFA-TR*           OR  :WS-IS-STATE-NULL     = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON                  
MFA-TR*           AND :WS-IS-ORD-RSN-NULL   = 'N' )                             
MFA-TR*           OR  :WS-IS-ORD-RSN-NULL   = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL                    
MFA-TR*     AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL                    
MFA-TR*     AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE                    
MFA-TR*           AND :WS-IS-RD-ROUTE-NULL  = 'N' )                             
MFA-TR*           OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                               
MFA-TR*         )                                                               
MFA-TR*     AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD                      
MFA-TR*           AND :WS-IS-WRK-TYPE-NULL = 'N' )                              
MFA-TR*           OR  :WS-IS-WRK-TYPE-NULL = 'Y'                                
MFA-TR*         )                                                               
MFA-TR*     AND                                                                 
MFA-TR*     (     :WS-COND-TYPE = 1                                             
MFA-TR*        OR (     :WS-COND-TYPE     = 2                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*        OR (     :WS-COND-TYPE     = 3                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO               
MFA-TR*             AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*     )                                                                   
MFA-TR*     ORDER BY                                                            
MFA-TR*         SO.SERV_ORDER_NO                                                
MFA-TR*     FETCH FIRST 400 ROWS ONLY                                           
MFA-TR*     FOR READ ONLY WITH UR                                               
MFA-TR*     OPTIMIZE FOR 1 ROW                                                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
      *--- < CURSOR FOR SERVICE ORDER DETAILS WITH CREW HAVING SPECFIC          
      *----< ARGUMENTS FOR HISTORY                                              
           EXEC SQL DECLARE HST-CREW-CURSOR-S1 CURSOR FOR               
           SELECT TOP(400) SO.ORDER_REASON,
              DN.AMOUNT_DISC_BAL,
              DN.SECURITIES_TOT_AMT,
              DN.CUR_MTH_ARREARS_CD,
              DN.CREDIT_GROUP,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              SO.ORDER_STATE_CD,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.PREMISE_NO,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.SERV_ORDER_STATUS,
              SO.ORDER_TYPE_CD,
              SC.READ_ROUTE,
              SO.ORDER_PRIORITY_CD,
              SO.ACCOUNT_TYPE_CODE,
              SO.ORDER_RECVED_BY                                      
           FROM                                                         
                HST_SO_DATA        SO WITH(READUNCOMMITTED)                     
               ,HST_SO_DNP         DN WITH(READUNCOMMITTED)                     
               ,HST_SO_UTL_CHG     SC WITH(READUNCOMMITTED)                     
               ,HST_SO_CREW        WM WITH(READUNCOMMITTED)                     
            WHERE                                                       
                SO.COMPANY_NO         = :WS-COMPANY-NO                  
            AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                
            AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD               
            AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                 
            AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )           
            AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )             
            AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL            
            AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL            
            AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND WM.CREW_ID            = :WS-CREW-ID                     
            AND                                                         
            (     :WS-COND-TYPE = 1                                     
               OR (     :WS-COND-TYPE     = 2                           
                    AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )    
               OR (     :WS-COND-TYPE     = 3                           
                    AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO       
                    AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )    
            )                                                           
            ORDER BY                                                    
                SO.SERV_ORDER_NO                                        
            
            OPTION(FAST 1)
            FOR READ ONLY
                                                      
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ020
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE HST-CREW-CURSOR-S1 CURSOR FOR                       
MFA-TR*    SELECT                                                               
MFA-TR*         SO.ORDER_REASON                                                 
MFA-TR*        ,DN.AMOUNT_DISC_BAL                                              
MFA-TR*        ,DN.SECURITIES_TOT_AMT                                           
MFA-TR*        ,DN.CUR_MTH_ARREARS_CD                                           
MFA-TR*        ,DN.CREDIT_GROUP                                                 
MFA-TR*        ,SO.ASSIGNED_DATETIME                                            
MFA-TR*        ,SO.ORDER_STATE_CD                                               
MFA-TR*        ,SO.SERV_ORDER_NO                                                
MFA-TR*        ,SO.ACCOUNT_NO                                                   
MFA-TR*        ,SO.PREMISE_NO                                                   
MFA-TR*        ,SO.COMPANY_NO                                                   
MFA-TR*        ,SO.LOCAL_OFFICE                                                 
MFA-TR*        ,SO.ACCOUNT_NO_PRIOR                                             
MFA-TR*        ,SO.SERV_ORDER_STATUS                                            
MFA-TR*        ,SO.ORDER_TYPE_CD                                                
MFA-TR*        ,SC.READ_ROUTE                                                   
MFA-TR*        ,SO.ORDER_PRIORITY_CD                                            
MFA-TR*        ,SO.ACCOUNT_TYPE_CODE                                            
MFA-TR*        ,SO.ORDER_RECVED_BY                                              
MFA-TR*    FROM                                                                 
MFA-TR*         HST_SO_DATA        SO                                           
MFA-TR*        ,HST_SO_DNP         DN                                           
MFA-TR*        ,HST_SO_UTL_CHG     SC                                           
MFA-TR*        ,HST_SO_CREW        WM                                           
MFA-TR*     WHERE                                                               
MFA-TR*         SO.COMPANY_NO         = :WS-COMPANY-NO                          
MFA-TR*     AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                        
MFA-TR*     AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                       
MFA-TR*     AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                         
MFA-TR*     AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT                   
MFA-TR*     AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT                     
MFA-TR*     AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL                    
MFA-TR*     AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL                    
MFA-TR*     AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND WM.CREW_ID            = :WS-CREW-ID                             
MFA-TR*     AND                                                                 
MFA-TR*     (     :WS-COND-TYPE = 1                                             
MFA-TR*        OR (     :WS-COND-TYPE     = 2                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*        OR (     :WS-COND-TYPE     = 3                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO               
MFA-TR*             AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*     )                                                                   
MFA-TR*     ORDER BY                                                            
MFA-TR*         SO.SERV_ORDER_NO                                                
MFA-TR*     FETCH FIRST 400 ROWS ONLY                                           
MFA-TR*     FOR READ ONLY WITH UR                                               
MFA-TR*     OPTIMIZE FOR 1 ROW                                                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS WITHOUT CREW FOR                  
      *--- < SPECIFIC ARUGMENTS FOR HISTORY                                     
                                                                        
           EXEC SQL DECLARE HST-NON-CREW-CURSOR-S1 CURSOR FOR           
           SELECT TOP(400) SO.ORDER_REASON,
              DN.AMOUNT_DISC_BAL,
              DN.SECURITIES_TOT_AMT,
              DN.CUR_MTH_ARREARS_CD,
              DN.CREDIT_GROUP,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              SO.ORDER_STATE_CD,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.PREMISE_NO,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.SERV_ORDER_STATUS,
              SO.ORDER_TYPE_CD,
              SC.READ_ROUTE,
              SO.ORDER_PRIORITY_CD,
              SO.ACCOUNT_TYPE_CODE,
              SO.ORDER_RECVED_BY                                      
           FROM                                                         
                HST_SO_DATA        SO WITH(READUNCOMMITTED)                     
               ,HST_SO_DNP         DN WITH(READUNCOMMITTED)                     
               ,HST_SO_UTL_CHG     SC WITH(READUNCOMMITTED)                     
            WHERE                                                       
                SO.COMPANY_NO         = :WS-COMPANY-NO                  
            AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                
            AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD               
            AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                 
            AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )           
            AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )             
            AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL            
            AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL            
            AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                
            AND                                                         
            (     :WS-COND-TYPE = 1                                     
               OR (     :WS-COND-TYPE     = 2                           
                    AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )    
               OR (     :WS-COND-TYPE     = 3                           
                    AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO       
                    AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )    
            )                                                           
            ORDER BY                                                    
                SO.SERV_ORDER_NO                                        
            
            OPTION(FAST 1)
            FOR READ ONLY
                                                      
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ020
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE HST-NON-CREW-CURSOR-S1 CURSOR FOR                   
MFA-TR*    SELECT                                                               
MFA-TR*         SO.ORDER_REASON                                                 
MFA-TR*        ,DN.AMOUNT_DISC_BAL                                              
MFA-TR*        ,DN.SECURITIES_TOT_AMT                                           
MFA-TR*        ,DN.CUR_MTH_ARREARS_CD                                           
MFA-TR*        ,DN.CREDIT_GROUP                                                 
MFA-TR*        ,SO.ASSIGNED_DATETIME                                            
MFA-TR*        ,SO.ORDER_STATE_CD                                               
MFA-TR*        ,SO.SERV_ORDER_NO                                                
MFA-TR*        ,SO.ACCOUNT_NO                                                   
MFA-TR*        ,SO.PREMISE_NO                                                   
MFA-TR*        ,SO.COMPANY_NO                                                   
MFA-TR*        ,SO.LOCAL_OFFICE                                                 
MFA-TR*        ,SO.ACCOUNT_NO_PRIOR                                             
MFA-TR*        ,SO.SERV_ORDER_STATUS                                            
MFA-TR*        ,SO.ORDER_TYPE_CD                                                
MFA-TR*        ,SC.READ_ROUTE                                                   
MFA-TR*        ,SO.ORDER_PRIORITY_CD                                            
MFA-TR*        ,SO.ACCOUNT_TYPE_CODE                                            
MFA-TR*        ,SO.ORDER_RECVED_BY                                              
MFA-TR*    FROM                                                                 
MFA-TR*         HST_SO_DATA        SO                                           
MFA-TR*        ,HST_SO_DNP         DN                                           
MFA-TR*        ,HST_SO_UTL_CHG     SC                                           
MFA-TR*     WHERE                                                               
MFA-TR*         SO.COMPANY_NO         = :WS-COMPANY-NO                          
MFA-TR*     AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                        
MFA-TR*     AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                       
MFA-TR*     AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                         
MFA-TR*     AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT                   
MFA-TR*     AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT                     
MFA-TR*     AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL                    
MFA-TR*     AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL                    
MFA-TR*     AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                        
MFA-TR*     AND                                                                 
MFA-TR*     (     :WS-COND-TYPE = 1                                             
MFA-TR*        OR (     :WS-COND-TYPE     = 2                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*        OR (     :WS-COND-TYPE     = 3                                   
MFA-TR*             AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO               
MFA-TR*             AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )            
MFA-TR*     )                                                                   
MFA-TR*     ORDER BY                                                            
MFA-TR*         SO.SERV_ORDER_NO                                                
MFA-TR*     FETCH FIRST 400 ROWS ONLY                                           
MFA-TR*     FOR READ ONLY WITH UR                                               
MFA-TR*     OPTIMIZE FOR 1 ROW                                                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-PROCESS            PIC X(01).                            
       01 PARM-CUR-HIST           PIC X(01).                            
       01 PARM-COMPANY            PIC X(02).                            
       01 PARM-LOCAL-OFFICE       PIC X(03).                            
       01 PARM-RESP-AREA          PIC X(04).                            
       01 PARM-WORK-AREA          PIC X(12).                            
       01 PARM-ORDER-TYPE         PIC X(05).                            
       01 PARM-WORK-TYPE          PIC X(05).                            
A01529 01 PARM-CLASS              PIC X(04).                            
       01 PARM-STATUS             PIC X(02).                            
       01 PARM-STATE              PIC X(01).                            
       01 PARM-ORDER-REASON       PIC X(01).                            
COB305 01 PARM-MIN-AMT        PIC S9(9)V9(2) COMP-3 VALUE 0.                
COB305 01 PARM-MAX-AMT        PIC S9(9)V9(2) COMP-3 VALUE 0.                
       01 PARM-START-DATE         PIC X(26).                            
       01 PARM-END-DATE           PIC X(26).                            
COB305 01 PARM-LOW-SERV-ORDER-N        PIC S9(13)V COMP-3 VALUE 0.              
COB305 01 PARM-HIGH-SERV-ORDERZ        PIC S9(13)V COMP-3 VALUE 0.              
       01 PARM-CREW-ID            PIC X(06).                            
       01 PARM-READ-ROUTE         PIC X(04).                            
      *                                                                         
       PROCEDURE DIVISION USING PARM-PROCESS                            
                                PARM-CUR-HIST                           
                                PARM-COMPANY                            
                                PARM-LOCAL-OFFICE                       
                                PARM-RESP-AREA                          
                                PARM-WORK-AREA                          
                                PARM-ORDER-TYPE                         
                                PARM-WORK-TYPE                          
                                PARM-CLASS                              
                                PARM-STATUS                             
                                PARM-STATE                              
                                PARM-ORDER-REASON                       
                                PARM-MIN-AMT                            
                                PARM-MAX-AMT                            
                                PARM-START-DATE                         
                                PARM-END-DATE                           
                                PARM-LOW-SERV-ORDER-N                   
                                PARM-HIGH-SERV-ORDERZ                   
                                PARM-CREW-ID                            
                                PARM-READ-ROUTE.                        
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
      *                                                                         
           EXEC SQL                                                     
                DECLARE C1 CURSOR                            
                             WITH ROWSET POSITIONING FOR                
                SELECT DISTINCT TOP(100) LTRIM(RTRIM(FULL_NAME
           ))       AS FULL_NAME,
              LTRIM(RTRIM(FIRST_NAME))      AS FIRST_NAME,
              LTRIM(RTRIM(MIDDLE_NAME))     AS MIDDLE_NAME,
              LTRIM(RTRIM(LAST_NAME))       AS LAST_NAME,
              NAME_FORMAT,
              LTRIM(RTRIM(ORDER_TYPE_DESC)) AS ORDER_TYPE_DESC,
              LTRIM(RTRIM(ORDER_REASON))    AS ORDER_REASON,
              AMOUNT_DISC_BAL,
              SECURITIES_TOT_AMT,
              CUR_MTH_ARREARS_CD,
              CREDIT_GROUP,
              ASSIGNED_DATETIME,
              LTRIM(RTRIM(STATUS_TX))       AS STATUS_TX,
              ORDER_STATE_CD,
              SERV_ORDER_NO,
              ACCOUNT_NO,
              TOTAL,
              PREMISE_NO,
              ORDER_GROUP_CD,
              COMPANY_NO,
              LOCAL_OFFICE,
              ACCOUNT_NO_PRIOR,
              SERV_ORDER_STATUS,
              ORDER_TYPE_CD,
              CUSTOMER_NO,
              ZIP_CODE,
              READ_ROUTE,
              LTRIM(RTRIM(ADDRESS))         AS ADDRESS,
              ORDER_PRIORITY_CD,
              ACCOUNT_TYPE_CD,
              ORDER_RECVED_BY                                    
                FROM                                                    
                     #CSR01250_R1                                
                ORDER BY SERV_ORDER_NO                                  
                                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN                                   
MFA-TR*                      WITH ROWSET POSITIONING FOR                        
MFA-TR*         SELECT DISTINCT                                                 
MFA-TR*              STRIP(FULL_NAME)       AS FULL_NAME                        
MFA-TR*             ,STRIP(FIRST_NAME)      AS FIRST_NAME                       
MFA-TR*             ,STRIP(MIDDLE_NAME)     AS MIDDLE_NAME                      
MFA-TR*             ,STRIP(LAST_NAME)       AS LAST_NAME                        
MFA-TR*             ,NAME_FORMAT                                                
MFA-TR*             ,STRIP(ORDER_TYPE_DESC) AS ORDER_TYPE_DESC                  
MFA-TR*             ,STRIP(ORDER_REASON)    AS ORDER_REASON                     
MFA-TR*             ,AMOUNT_DISC_BAL                                            
MFA-TR*             ,SECURITIES_TOT_AMT                                         
MFA-TR*             ,CUR_MTH_ARREARS_CD                                         
MFA-TR*             ,CREDIT_GROUP                                               
MFA-TR*             ,ASSIGNED_DATETIME                                          
MFA-TR*             ,STRIP(STATUS_TX)       AS STATUS_TX                        
MFA-TR*             ,ORDER_STATE_CD                                             
MFA-TR*             ,SERV_ORDER_NO                                              
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,TOTAL                                                      
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,ORDER_GROUP_CD                                             
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,ACCOUNT_NO_PRIOR                                           
MFA-TR*             ,SERV_ORDER_STATUS                                          
MFA-TR*             ,ORDER_TYPE_CD                                              
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,ZIP_CODE                                                   
MFA-TR*             ,READ_ROUTE                                                 
MFA-TR*             ,STRIP(ADDRESS)         AS ADDRESS                          
MFA-TR*             ,ORDER_PRIORITY_CD                                          
MFA-TR*             ,ACCOUNT_TYPE_CD                                            
MFA-TR*             ,ORDER_RECVED_BY                                            
MFA-TR*         FROM                                                            
MFA-TR*              SESSION.CSR01250_R1                                        
MFA-TR*         ORDER BY SERV_ORDER_NO                                          
MFA-TR*         FETCH FIRST 100 ROWS ONLY                                       
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR01250_R1'            
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR01250_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR01250_R1
              (                                                       
T36933                FULL_NAME CHAR(70)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,FIRST_NAME CHAR(15)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,MIDDLE_NAME CHAR(15)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
T36933               ,LAST_NAME CHAR(40)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,NAME_FORMAT CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,ORDER_TYPE_DESC CHAR(15)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,ORDER_REASON CHAR(15)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,AMOUNT_DISC_BAL        DECIMAL(11,2)              
                     ,SECURITIES_TOT_AMT     DECIMAL(11,2)              
                     ,CUR_MTH_ARREARS_CD CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,CREDIT_GROUP CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,ASSIGNED_DATETIME CHAR(26)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,STATUS_TX CHAR(25)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,ORDER_STATE_CD CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,SERV_ORDER_NO          DECIMAL(13)                
                     ,ACCOUNT_NO             DECIMAL(13)                
                     ,TOTAL                  INT                    
                     ,PREMISE_NO             DECIMAL(10)                
                     ,ORDER_GROUP_CD CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,COMPANY_NO CHAR(02)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,LOCAL_OFFICE CHAR(03)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,ACCOUNT_NO_PRIOR       DECIMAL(13)                
                     ,SERV_ORDER_STATUS CHAR(02)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,ORDER_TYPE_CD CHAR(07)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,CUSTOMER_NO            DECIMAL(10)                
                     ,ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2        
                     ,READ_ROUTE CHAR(04)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
P00152               ,ADDRESS CHAR(74)  COLLATE LATIN1_GENERAL_100_BIN2         
P00152               ,ORDER_PRIORITY_CD      SMALLINT                   
P00152               ,ACCOUNT_TYPE_CD CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
A05317               ,ORDER_RECVED_BY CHAR(40)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                  NEXT SENTENCE                                         
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE SQLCODE            TO ABEND-SQLCODE                  
              MOVE SQLSTATE           TO ABEND-SQLSTATE                 
              MOVE '0100A'            TO ACTIVE-PARAGRAPH               
              MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                 
              MOVE SPACES             TO ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSR01250_R1'      TO TABLE-1                        
              MOVE SPACES             TO TABLE-ELEMENT-1                
              MOVE SPACES             TO HOSTVAR-ELEMENT-1              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                      THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-COMPANY          TO WS-COMPANY-NO                  
           MOVE PARM-LOCAL-OFFICE     TO WS-LOCAL-OFFICE                
           MOVE PARM-ORDER-TYPE       TO WS-ORDER-TYPE-CD               
           MOVE PARM-START-DATE       TO WS-ASSIGNED-START-DT           
           MOVE PARM-END-DATE         TO WS-ASSIGNED-END-DT             
                                                                        
           MOVE PARM-RESP-AREA        TO WS-RESP-AREA-ID                
           IF WS-RESP-AREA-ID NOT = SPACES                              
              MOVE 'N'                TO WS-IS-RSP-AREA-NULL            
           END-IF.                                                      
                                                                        
           MOVE PARM-WORK-AREA        TO WS-WORK-AREA-ID                
           IF WS-WORK-AREA-ID NOT = SPACES                              
              MOVE 'N'                TO WS-IS-WRK-AREA-NULL            
           END-IF.                                                      
                                                                        
           MOVE PARM-STATUS           TO WS-SO-STATUS                   
           IF WS-SO-STATUS    NOT = SPACES                              
              MOVE 'N'                TO WS-IS-STATUS-NULL              
           END-IF.                                                      
                                                                        
           MOVE PARM-STATE            TO WS-SO-STATE-CD                 
           IF WS-SO-STATE-CD  NOT = SPACES                              
              MOVE 'N'                TO WS-IS-STATE-NULL               
           END-IF.                                                      
                                                                        
           MOVE PARM-ORDER-REASON     TO WS-ORDER-REASON                
           IF WS-ORDER-REASON NOT = SPACES                              
              MOVE 'N'                TO WS-IS-ORD-RSN-NULL             
           END-IF.                                                      
                                                                        
           MOVE PARM-MIN-AMT          TO WS-MIN-AMT-DISC-BAL            
           MOVE PARM-MAX-AMT          TO WS-MAX-AMT-DISC-BAL            
                                                                        
           IF PARM-READ-ROUTE NOT = SPACES                              
              MOVE 'N'                TO WS-IS-RD-ROUTE-NULL            
              PERFORM UNTIL PARM-READ-ROUTE(4:1) NOT = SPACE            
                 MOVE PARM-READ-ROUTE(3:1)       TO PARM-READ-ROUTE(4:1)
                 MOVE PARM-READ-ROUTE(2:1)       TO PARM-READ-ROUTE(3:1)
                 MOVE PARM-READ-ROUTE(1:1)       TO PARM-READ-ROUTE(2:1)
                 MOVE ZERO                       TO PARM-READ-ROUTE(1:1)
              END-PERFORM                                               
           END-IF.                                                      
A04086     IF PARM-READ-ROUTE NOT NUMERIC                               
A04086         MOVE ZEROES TO PARM-READ-ROUTE
           END-IF.                          
           MOVE PARM-READ-ROUTE       TO WS-READ-ROUTE-NUM              
           MOVE WS-READ-ROUTE-NUM     TO WS-READ-ROUTE                  
                                                                        
           MOVE PARM-WORK-TYPE        TO WS-WORK-TYPE-CD.               
           IF WS-WORK-TYPE-CD NOT = SPACES                              
              MOVE 'N'                TO WS-IS-WRK-TYPE-NULL            
           END-IF.                                                      
                                                                        
           MOVE PARM-LOW-SERV-ORDER-N TO WS-LOW-SERV-ORDER-NO.          
           MOVE PARM-HIGH-SERV-ORDERZ TO WS-HIGH-SERV-ORDER-NO.         
                                                                        
           IF PARM-PROCESS = '-'                                        
              MOVE 1                  TO WS-COND-TYPE                   
           ELSE                                                         
              IF PARM-PROCESS = 'N'                                     
                 MOVE 2               TO WS-COND-TYPE                   
              ELSE                                                      
                 MOVE 3               TO WS-COND-TYPE                   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE PARM-CREW-ID          TO WS-CREW-ID.                    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2300-BUILD-RESULT                                    *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2300-BUILD-RESULT             THRU 2300-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      *2000A-MOVE-RESULT                                               *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE  RS-FULL-NAME          TO S-FULL-NAME.                  
           MOVE  RS-FIRST-NAME         TO S-FIRST-NAME.                 
           MOVE  RS-MIDDLE-NAME        TO S-MIDDLE-NAME.                
           MOVE  RS-LAST-NAME          TO S-LAST-NAME.                  
           MOVE  RS-NAME-FORMAT        TO S-NAME-FORMAT.                
           MOVE  RS-ORDER-TYPE-DESC    TO S-ORDER-TYPE-DESC.            
           MOVE  RS-ORDER-REASON       TO S-ORDER-REASON.               
           MOVE  RS-AMOUNT-DISC-BAL    TO S-AMOUNT-DISC-BAL.            
           MOVE  RS-SECURITIES-TOT-AMT TO S-SECURITIES-TOT-AMT.         
           MOVE  RS-CUR-MTH-ARREARS-CD TO S-CUR-MTH-ARREARS-CD.         
           MOVE  RS-CREDIT-GROUP       TO S-CREDIT-GROUP.               
           MOVE  RS-ASSIGNED-DATETIME  TO S-ASSIGNED-DATETIME.          
           MOVE  RS-STATUS-TX          TO S-STATUS-TX.                  
           MOVE  RS-ORDER-STATE-CD     TO S-ORDER-STATE-CD.             
           MOVE  RS-SERV-ORDER-NO      TO S-SERV-ORDER-NO.              
           MOVE  RS-ACCOUNT-NO         TO S-ACCOUNT-NO.                 
           MOVE  RS-TOTAL              TO S-TOTAL.                      
           MOVE  RS-PREMISE-NO         TO S-PREMISE-NO.                 
           MOVE  RS-ORDER-GROUP-CD     TO S-ORDER-GROUP-CD.             
           MOVE  RS-COMPANY-NO         TO S-COMPANY-NO.                 
           MOVE  RS-LOCAL-OFFICE       TO S-LOCAL-OFFICE.               
           MOVE  RS-ACCOUNT-NO-PRIOR   TO S-ACCOUNT-NO-PRIOR.           
           MOVE  RS-SERV-ORDER-STATUS  TO S-SERV-ORDER-STATUS.          
           MOVE  RS-ORDER-TYPE-CD      TO S-ORDER-TYPE-CD.              
           MOVE  RS-CUSTOMER-NO        TO S-CUSTOMER-NO.                
           MOVE  RS-ZIP-CODE           TO S-ZIP-CODE.                   
           MOVE  RS-READ-ROUTE         TO S-READ-ROUTE.                 
P00152     MOVE  RS-ADDRESS            TO S-ADDRESS.                    
P00152     MOVE  RS-ORDER-PRIORITY-CD  TO S-ORDER-PRIORITY-CD.          
P00152     MOVE  RS-ACCOUNT-TYPE-CD    TO S-ACCOUNT-TYPE-CD.            
A05317     MOVE  RS-ORDER-RECVED-BY    TO S-ORDER-RECVED-BY.            
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2200-MOVE-DB-VALUE                                              *        
      ******************************************************************        
       2200-MOVE-DB-VALUE.                                              
      *                                                                         
           MOVE SPACES                   TO RS-FULL-NAME.               
           MOVE SPACES                   TO RS-FIRST-NAME.              
           MOVE SPACES                   TO RS-MIDDLE-NAME.             
           MOVE SPACES                   TO RS-LAST-NAME.               
           MOVE SPACES                   TO RS-NAME-FORMAT.             
           MOVE SPACES                   TO RS-ORDER-TYPE-DESC.         
           MOVE VO-ORDER-REASON          TO RS-ORDER-REASON.            
           MOVE AI-AMOUNT-DISC-BAL       TO RS-AMOUNT-DISC-BAL.         
           MOVE AI-SECURITIES-TOT-AMT    TO RS-SECURITIES-TOT-AMT.      
           MOVE AI-CUR-MTH-ARREARS-CD    TO RS-CUR-MTH-ARREARS-CD.      
           MOVE AI-CREDIT-GROUP          TO RS-CREDIT-GROUP.            
           MOVE VO-ASSIGNED-DATETIME     TO RS-ASSIGNED-DATETIME.       
           MOVE SPACES                   TO RS-STATUS-TX.               
           MOVE VO-ORDER-STATE-CD        TO RS-ORDER-STATE-CD.          
           MOVE VO-SERV-ORDER-NO         TO RS-SERV-ORDER-NO.           
           MOVE VO-ACCOUNT-NO            TO RS-ACCOUNT-NO.              
           MOVE WS-TOTAL-RECORDS         TO RS-TOTAL.                   
           MOVE VO-PREMISE-NO            TO RS-PREMISE-NO.              
           MOVE C2-ORDER-GROUP-CD        TO RS-ORDER-GROUP-CD.          
           MOVE VO-COMPANY-NO            TO RS-COMPANY-NO.              
           MOVE VO-LOCAL-OFFICE          TO RS-LOCAL-OFFICE.            
           MOVE VO-ACCOUNT-NO-PRIOR      TO RS-ACCOUNT-NO-PRIOR.        
           MOVE VO-SERV-ORDER-STATUS     TO RS-SERV-ORDER-STATUS.       
           MOVE VO-ORDER-TYPE-CD         TO RS-ORDER-TYPE-CD.           
           MOVE ZERO                     TO RS-CUSTOMER-NO.             
           MOVE SPACES                   TO RS-ZIP-CODE.                
           MOVE VE-READ-ROUTE            TO RS-READ-ROUTE.              
P00152     MOVE VO-ORDER-PRIORITY-CD     TO RS-ORDER-PRIORITY-CD.       
P00152     MOVE VO-ACCOUNT-TYPE-CODE     TO RS-ACCOUNT-TYPE-CD.         
A05317     IF VO-ORDER-RECVED-BY > SPACES                               
A05317         MOVE VO-ORDER-RECVED-BY   TO PF-USER-ID                  
A05317         PERFORM 7800-USER-PROFILE THRU 7800-EXIT                 
A05317         MOVE WS-USER-NAME         TO RS-ORDER-RECVED-BY          
A05317     ELSE                                                         
A05317         MOVE SPACES               TO RS-ORDER-RECVED-BY
           END-IF.         
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03680000
      ******************************************************************        
      * 2300-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2300-BUILD-RESULT.                                               
                                                                        
           IF WS-COMPANY-NO        NOT = SPACES AND                     
              WS-LOCAL-OFFICE      NOT = SPACES AND                     
              WS-ORDER-TYPE-CD     NOT = SPACES AND                     
              WS-ASSIGNED-START-DT NOT = SPACES AND                     
              WS-ASSIGNED-END-DT   NOT = SPACES AND                     
              WS-SO-STATE-CD       NOT = SPACES AND                     
              WS-MIN-AMT-DISC-BAL      = 0      AND                     
              WS-MAX-AMT-DISC-BAL      > 0      AND                     
              WS-RESP-AREA-ID          = SPACES AND                     
              WS-WORK-AREA-ID          = SPACES AND                     
              WS-SO-STATUS             = SPACES AND                     
              WS-ORDER-REASON          = SPACES AND                     
              PARM-READ-ROUTE          = SPACES AND                     
              WS-WORK-TYPE-CD          = SPACES                         
              IF WS-CREW-ID > SPACES                                    
                 IF PARM-CUR-HIST NOT = 'H' THEN                        
                    PERFORM 7300-GET-ROW-COUNT-CREW-S1                  
                                                 THRU 7300-EXIT         
                 ELSE                                                   
                    PERFORM 7325-GET-ROW-COUNT-CREW-S1-HST              
                                                 THRU 7325-EXIT         
                 END-IF                                                 
                 MOVE WS-TOTAL-RECORDS           TO RS-TOTAL            
                 PERFORM 2600-PROCESS-CREW-S1                           
                                                 THRU 2600-EXIT         
              ELSE                                                      
                 IF PARM-CUR-HIST NOT = 'H' THEN                        
                    PERFORM 7350-GET-ROW-COUNT-NON-CREW-S1              
                                                 THRU 7350-EXIT         
                 ELSE                                                   
                    PERFORM 7375-GET-ROW-COUNT-NON-CREW-SH              
                                                 THRU 7375-EXIT         
                 END-IF                                                 
                 MOVE WS-TOTAL-RECORDS           TO RS-TOTAL            
                 PERFORM 2700-PROCESS-NON-CREW-S1                       
                                                 THRU 2700-EXIT         
              END-IF                                                    
                                                                        
           ELSE                                                         
                                                                        
              IF WS-CREW-ID > SPACES                                    
                 IF PARM-CUR-HIST NOT = 'H' THEN                        
                    PERFORM 7100-GET-ROW-COUNT-CREW THRU 7100-EXIT      
                 ELSE                                                   
                    PERFORM 7150-GET-ROW-COUNT-CREW-HST THRU 7150-EXIT  
                 END-IF                                                 
                 MOVE WS-TOTAL-RECORDS           TO RS-TOTAL            
                 PERFORM 2400-PROCESS-CREW       THRU 2400-EXIT         
              ELSE                                                      
                 IF PARM-CUR-HIST NOT = 'H' THEN                        
                    PERFORM 7200-GET-ROW-COUNT-NON-CREW                 
                                                    THRU 7200-EXIT      
                 ELSE                                                   
                    PERFORM 7250-GET-ROW-COUNT-NON-CREW-HS              
                                                    THRU 7250-EXIT      
                 END-IF                                                 
                 MOVE WS-TOTAL-RECORDS           TO RS-TOTAL            
                 PERFORM 2500-PROCESS-NON-CREW   THRU 2500-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF CTR-ROWS = 0                                              
              ADD +1                             TO CTR-ROWS            
           ELSE                                                         
              PERFORM 8200-UPDATE-RESULT         THRU 8200-EXIT         
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-PROCESS-CREW                                              *        
      *     CALLS       7400-, 7410- AND 7420-                        *         
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPEN, FETCHES AND CLOSE CREW-CURSOR                        *        
      ******************************************************************        
                                                                        
       2400-PROCESS-CREW.                                               
                                                                        
           IF PARM-CUR-HIST NOT = 'H' THEN                              
              PERFORM 7400-OPEN-CREW-CURSOR      THRU 7400-EXIT         
              PERFORM 7410-FETCH-CREW-CURSOR     THRU 7410-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2200-MOVE-DB-VALUE      THRU 2200-EXIT         
                 PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7410-FETCH-CREW-CURSOR  THRU 7410-EXIT         
              END-PERFORM                                               
              PERFORM 7420-CLOSE-CREW-CURSOR     THRU 7420-EXIT         
           ELSE                                                         
              PERFORM 7450-OPEN-CREW-CURSOR-HST  THRU 7450-EXIT         
              PERFORM 7460-FETCH-CREW-CURSOR-HST THRU 7460-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2200-MOVE-DB-VALUE      THRU 2200-EXIT         
                 PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7460-FETCH-CREW-CURSOR-HST  THRU 7460-EXIT     
              END-PERFORM                                               
              PERFORM 7470-CLOSE-CREW-CURSOR-HST THRU 7470-EXIT         
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-PROCESS-NON-CREW                                          *        
      *     CALLS       7500- 7510- AND 7520-                          *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPEN, FETCHES AND CLOSE NON-CREW CURSOR                    *        
      ******************************************************************        
                                                                        
       2500-PROCESS-NON-CREW.                                           
                                                                        
           IF PARM-CUR-HIST NOT = 'H' THEN                              
              PERFORM 7500-OPEN-NON-CREW-CURSOR  THRU 7500-EXIT         
              PERFORM 7510-FETCH-NON-CREW-CURSOR THRU 7510-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2200-MOVE-DB-VALUE      THRU 2200-EXIT         
                 PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7510-FETCH-NON-CREW-CURSOR                     
                                                 THRU 7510-EXIT         
              END-PERFORM                                               
              PERFORM 7520-CLOSE-NON-CREW-CURSOR THRU 7520-EXIT         
           ELSE                                                         
              PERFORM 7550-OPEN-NON-CREW-CURSOR-HST  THRU 7550-EXIT     
              PERFORM 7560-FETCH-NON-CREW-CURSOR-HST THRU 7560-EXIT     
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2200-MOVE-DB-VALUE      THRU 2200-EXIT         
                 PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7560-FETCH-NON-CREW-CURSOR-HST                 
                                                 THRU 7560-EXIT         
              END-PERFORM                                               
              PERFORM 7570-CLOSE-NON-CREW-CURSOR-HST THRU 7570-EXIT     
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2600-PROCESS-CREW-S1                                           *        
      *     CALLS       7600-, 7610- AND 7620-                         *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPEN, FETCHES AND CLOSE CREW-CURSOR                        *        
      ******************************************************************        
                                                                        
       2600-PROCESS-CREW-S1.                                            
                                                                        
           IF PARM-CUR-HIST NOT = 'H' THEN                              
              PERFORM 7600-OPEN-CREW-CURSOR-S1                          
                                                 THRU 7600-EXIT         
              PERFORM 7610-FETCH-CREW-CURSOR-S1  THRU 7610-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2200-MOVE-DB-VALUE      THRU 2200-EXIT         
                 PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7610-FETCH-CREW-CURSOR-S1                      
                                                 THRU 7610-EXIT         
              END-PERFORM                                               
              PERFORM 7620-CLOSE-CREW-CURSOR-S1                         
                                                 THRU 7620-EXIT         
           ELSE                                                         
              PERFORM 7650-OPEN-CREW-CURSOR-S1-HST                      
                                                 THRU 7650-EXIT         
              PERFORM 7660-FETCH-CREW-CURSOR-S1-HST  THRU 7660-EXIT     
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2200-MOVE-DB-VALUE      THRU 2200-EXIT         
                 PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7660-FETCH-CREW-CURSOR-S1-HST                  
                                                 THRU 7660-EXIT         
              END-PERFORM                                               
              PERFORM 7670-CLOSE-CREW-CURSOR-S1-HST                     
                                                 THRU 7670-EXIT         
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2700-PROCESS-NON-CREW-S1                                       *        
      *     CALLS       7700- 7710- AND 7720-                          *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPEN, FETCHES AND CLOSE NON-CREW CURSOR                    *        
      ******************************************************************        
                                                                        
       2700-PROCESS-NON-CREW-S1.                                        
                                                                        
           IF PARM-CUR-HIST NOT = 'H' THEN                              
              PERFORM 7700-OPEN-NON-CREW-CURSOR-S1                      
                                                 THRU 7700-EXIT         
              PERFORM 7710-FETCH-NON-CREW-CURSOR-S1                     
                                                 THRU 7710-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2200-MOVE-DB-VALUE      THRU 2200-EXIT         
                 PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7710-FETCH-NON-CREW-CURSOR-S1                  
                                                 THRU 7710-EXIT         
              END-PERFORM                                               
              PERFORM 7720-CLOSE-NON-CREW-CURSOR-S1                     
                                                 THRU 7720-EXIT         
           ELSE                                                         
              PERFORM 7750-OPEN-NON-CREW-CURSOR-SH                      
                                                 THRU 7750-EXIT         
              PERFORM 7760-FETCH-NON-CREW-CURSOR-SH                     
                                                 THRU 7760-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2200-MOVE-DB-VALUE      THRU 2200-EXIT         
                 PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7760-FETCH-NON-CREW-CURSOR-SH                  
                                                 THRU 7760-EXIT         
              END-PERFORM                                               
              PERFORM 7770-CLOSE-NON-CREW-CURSOR-SH                     
                                                 THRU 7770-EXIT         
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-ROW-COUNT-WITH-CREW                                   *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     GETS THE RECORD COUNT                                      *        
      ******************************************************************        
                                                                        
       7100-GET-ROW-COUNT-CREW.                                         
                                                                        
           MOVE '7100'        TO ACTIVE-PARAGRAPH.                      
                                                                        
              EXEC SQL                                                  
                  SELECT                                                
                       COUNT(DISTINCT SO.SERV_ORDER_NO)                 
                  INTO                                                  
                       :WS-TOTAL-RECORDS                                
                  FROM                                                  
                       CSS_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_SO_DNP        DN WITH(READUNCOMMITTED)               
                      ,CSS_SO_UTL_CHG    SC WITH(READUNCOMMITTED)               
                      ,CSS_SO_CREW       WM WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.COMPANY_NO         = :WS-COMPANY-NO            
                  AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE          
                  AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD         
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )     
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )       
                  AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID    
                        AND :WS-IS-RSP-AREA-NULL  = 'N' )               
                        OR  :WS-IS-RSP-AREA-NULL  = 'Y'                 
                      )                                                 
                  AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID    
                        AND :WS-IS-WRK-AREA-NULL  = 'N' )               
                        OR  :WS-IS-WRK-AREA-NULL  = 'Y'                 
                      )                                                 
                  AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS       
                        AND :WS-IS-STATUS-NULL    = 'N' )               
                        OR  :WS-IS-STATUS-NULL    = 'Y'                 
                      )                                                 
                  AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD     
                        AND :WS-IS-STATE-NULL     = 'N' )               
                        OR  :WS-IS-STATE-NULL     = 'Y'                 
                      )                                                 
                  AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON    
                        AND :WS-IS-ORD-RSN-NULL   = 'N' )               
                        OR  :WS-IS-ORD-RSN-NULL   = 'Y'                 
                      )                                                 
                  AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL      
                  AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL      
                  AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE      
                        AND :WS-IS-RD-ROUTE-NULL  = 'N' )               
                        OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                 
                      )                                                 
                  AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND WM.CREW_ID            = :WS-CREW-ID               
                  AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD        
                        AND :WS-IS-WRK-TYPE-NULL = 'N' )                
                        OR  :WS-IS-WRK-TYPE-NULL = 'Y'                  
                      )                                                 
                                                                 
                                                                        
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT                                                        
MFA-TR*                COUNT(DISTINCT SO.SERV_ORDER_NO)                         
MFA-TR*           INTO                                                          
MFA-TR*                :WS-TOTAL-RECORDS                                        
MFA-TR*           FROM                                                          
MFA-TR*                CSS_SO_DATA       SO                                     
MFA-TR*               ,CSS_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_SO_DNP        DN                                     
MFA-TR*               ,CSS_SO_UTL_CHG    SC                                     
MFA-TR*               ,CSS_SO_CREW       WM                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.COMPANY_NO         = :WS-COMPANY-NO                    
MFA-TR*           AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                  
MFA-TR*           AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                 
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT             
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT               
MFA-TR*           AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID            
MFA-TR*                 AND :WS-IS-RSP-AREA-NULL  = 'N' )                       
MFA-TR*                 OR  :WS-IS-RSP-AREA-NULL  = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID            
MFA-TR*                 AND :WS-IS-WRK-AREA-NULL  = 'N' )                       
MFA-TR*                 OR  :WS-IS-WRK-AREA-NULL  = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS               
MFA-TR*                 AND :WS-IS-STATUS-NULL    = 'N' )                       
MFA-TR*                 OR  :WS-IS-STATUS-NULL    = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD             
MFA-TR*                 AND :WS-IS-STATE-NULL     = 'N' )                       
MFA-TR*                 OR  :WS-IS-STATE-NULL     = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON            
MFA-TR*                 AND :WS-IS-ORD-RSN-NULL   = 'N' )                       
MFA-TR*                 OR  :WS-IS-ORD-RSN-NULL   = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL              
MFA-TR*           AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL              
MFA-TR*           AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE              
MFA-TR*                 AND :WS-IS-RD-ROUTE-NULL  = 'N' )                       
MFA-TR*                 OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND WM.CREW_ID            = :WS-CREW-ID                       
MFA-TR*           AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD                
MFA-TR*                 AND :WS-IS-WRK-TYPE-NULL = 'N' )                        
MFA-TR*                 OR  :WS-IS-WRK-TYPE-NULL = 'Y'                          
MFA-TR*               )                                                         
MFA-TR*           WITH UR                                                       
MFA-TR*                                                                         
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7150-GET-ROW-COUNT-WITH-CREW-HST                               *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     GETS THE RECORD COUNT FOR HISTORY                          *        
      ******************************************************************        
                                                                        
       7150-GET-ROW-COUNT-CREW-HST.                                     
                                                                        
           MOVE '7100'        TO ACTIVE-PARAGRAPH.                      
                                                                        
              EXEC SQL                                                  
                  SELECT                                                
                       COUNT(DISTINCT SO.SERV_ORDER_NO)                 
                  INTO                                                  
                       :WS-TOTAL-RECORDS                                
                  FROM                                                  
                       HST_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,HST_SO_DNP        DN WITH(READUNCOMMITTED)               
                      ,HST_SO_UTL_CHG    SC WITH(READUNCOMMITTED)               
                      ,HST_SO_CREW       WM WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.COMPANY_NO         = :WS-COMPANY-NO            
                  AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE          
                  AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD         
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )     
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )       
                  AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID    
                        AND :WS-IS-RSP-AREA-NULL  = 'N' )               
                        OR  :WS-IS-RSP-AREA-NULL  = 'Y'                 
                      )                                                 
                  AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID    
                        AND :WS-IS-WRK-AREA-NULL  = 'N' )               
                        OR  :WS-IS-WRK-AREA-NULL  = 'Y'                 
                      )                                                 
                  AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS       
                        AND :WS-IS-STATUS-NULL    = 'N' )               
                        OR  :WS-IS-STATUS-NULL    = 'Y'                 
                      )                                                 
                  AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD     
                        AND :WS-IS-STATE-NULL     = 'N' )               
                        OR  :WS-IS-STATE-NULL     = 'Y'                 
                      )                                                 
                  AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON    
                        AND :WS-IS-ORD-RSN-NULL   = 'N' )               
                        OR  :WS-IS-ORD-RSN-NULL   = 'Y'                 
                      )                                                 
                  AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL      
                  AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL      
                  AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE      
                        AND :WS-IS-RD-ROUTE-NULL  = 'N' )               
                        OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                 
                      )                                                 
                  AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND WM.CREW_ID            = :WS-CREW-ID               
                  AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD        
                     AND :WS-IS-WRK-TYPE-NULL = 'N' )                   
                     OR  :WS-IS-WRK-TYPE-NULL = 'Y'                     
                  )                                                     
                                                                 
                                                                        
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT                                                        
MFA-TR*                COUNT(DISTINCT SO.SERV_ORDER_NO)                         
MFA-TR*           INTO                                                          
MFA-TR*                :WS-TOTAL-RECORDS                                        
MFA-TR*           FROM                                                          
MFA-TR*                HST_SO_DATA       SO                                     
MFA-TR*               ,HST_SO_ORDER_INST OI                                     
MFA-TR*               ,HST_SO_DNP        DN                                     
MFA-TR*               ,HST_SO_UTL_CHG    SC                                     
MFA-TR*               ,HST_SO_CREW       WM                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.COMPANY_NO         = :WS-COMPANY-NO                    
MFA-TR*           AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                  
MFA-TR*           AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                 
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT             
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT               
MFA-TR*           AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID            
MFA-TR*                 AND :WS-IS-RSP-AREA-NULL  = 'N' )                       
MFA-TR*                 OR  :WS-IS-RSP-AREA-NULL  = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID            
MFA-TR*                 AND :WS-IS-WRK-AREA-NULL  = 'N' )                       
MFA-TR*                 OR  :WS-IS-WRK-AREA-NULL  = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS               
MFA-TR*                 AND :WS-IS-STATUS-NULL    = 'N' )                       
MFA-TR*                 OR  :WS-IS-STATUS-NULL    = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD             
MFA-TR*                 AND :WS-IS-STATE-NULL     = 'N' )                       
MFA-TR*                 OR  :WS-IS-STATE-NULL     = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON            
MFA-TR*                 AND :WS-IS-ORD-RSN-NULL   = 'N' )                       
MFA-TR*                 OR  :WS-IS-ORD-RSN-NULL   = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL              
MFA-TR*           AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL              
MFA-TR*           AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE              
MFA-TR*                 AND :WS-IS-RD-ROUTE-NULL  = 'N' )                       
MFA-TR*                 OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND WM.CREW_ID            = :WS-CREW-ID                       
MFA-TR*           AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD                
MFA-TR*              AND :WS-IS-WRK-TYPE-NULL = 'N' )                           
MFA-TR*              OR  :WS-IS-WRK-TYPE-NULL = 'Y'                             
MFA-TR*           )                                                             
MFA-TR*           WITH UR                                                       
MFA-TR*                                                                         
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-GET-ROW-COUNT-NON-CREW                                    *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     GETS THE RECORD COUNT                                      *        
      ******************************************************************        
                                                                        
       7200-GET-ROW-COUNT-NON-CREW.                                     
                                                                        
           MOVE '7200'        TO ACTIVE-PARAGRAPH.                      
                                                                        
              EXEC SQL                                                  
                  SELECT                                                
                       COUNT(DISTINCT SO.SERV_ORDER_NO)                 
                  INTO                                                  
                       :WS-TOTAL-RECORDS                                
                  FROM                                                  
                       CSS_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_SO_DNP        DN WITH(READUNCOMMITTED)               
                      ,CSS_SO_UTL_CHG    SC WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.COMPANY_NO         = :WS-COMPANY-NO            
                  AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE          
                  AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD         
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )     
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )       
                  AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID    
                        AND :WS-IS-RSP-AREA-NULL  = 'N' )               
                        OR  :WS-IS-RSP-AREA-NULL  = 'Y'                 
                      )                                                 
                  AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID    
                        AND :WS-IS-WRK-AREA-NULL  = 'N' )               
                        OR  :WS-IS-WRK-AREA-NULL  = 'Y'                 
                      )                                                 
                  AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS       
                        AND :WS-IS-STATUS-NULL    = 'N' )               
                        OR  :WS-IS-STATUS-NULL    = 'Y'                 
                      )                                                 
                  AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD     
                        AND :WS-IS-STATE-NULL     = 'N' )               
                        OR  :WS-IS-STATE-NULL     = 'Y'                 
                      )                                                 
                  AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON    
                        AND :WS-IS-ORD-RSN-NULL   = 'N' )               
                        OR  :WS-IS-ORD-RSN-NULL   = 'Y'                 
                      )                                                 
                  AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL      
                  AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL      
                  AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE      
                        AND :WS-IS-RD-ROUTE-NULL  = 'N' )               
                        OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                 
                      )                                                 
                  AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD        
                        AND :WS-IS-WRK-TYPE-NULL = 'N' )                
                        OR  :WS-IS-WRK-TYPE-NULL = 'Y'                  
                      )                                                 
                                                                 
                                                                        
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT                                                        
MFA-TR*                COUNT(DISTINCT SO.SERV_ORDER_NO)                         
MFA-TR*           INTO                                                          
MFA-TR*                :WS-TOTAL-RECORDS                                        
MFA-TR*           FROM                                                          
MFA-TR*                CSS_SO_DATA       SO                                     
MFA-TR*               ,CSS_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_SO_DNP        DN                                     
MFA-TR*               ,CSS_SO_UTL_CHG    SC                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.COMPANY_NO         = :WS-COMPANY-NO                    
MFA-TR*           AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                  
MFA-TR*           AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                 
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT             
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT               
MFA-TR*           AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID            
MFA-TR*                 AND :WS-IS-RSP-AREA-NULL  = 'N' )                       
MFA-TR*                 OR  :WS-IS-RSP-AREA-NULL  = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID            
MFA-TR*                 AND :WS-IS-WRK-AREA-NULL  = 'N' )                       
MFA-TR*                 OR  :WS-IS-WRK-AREA-NULL  = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS               
MFA-TR*                 AND :WS-IS-STATUS-NULL    = 'N' )                       
MFA-TR*                 OR  :WS-IS-STATUS-NULL    = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD             
MFA-TR*                 AND :WS-IS-STATE-NULL     = 'N' )                       
MFA-TR*                 OR  :WS-IS-STATE-NULL     = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON            
MFA-TR*                 AND :WS-IS-ORD-RSN-NULL   = 'N' )                       
MFA-TR*                 OR  :WS-IS-ORD-RSN-NULL   = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL              
MFA-TR*           AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL              
MFA-TR*           AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE              
MFA-TR*                 AND :WS-IS-RD-ROUTE-NULL  = 'N' )                       
MFA-TR*                 OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD                
MFA-TR*                 AND :WS-IS-WRK-TYPE-NULL = 'N' )                        
MFA-TR*                 OR  :WS-IS-WRK-TYPE-NULL = 'Y'                          
MFA-TR*               )                                                         
MFA-TR*           WITH UR                                                       
MFA-TR*                                                                         
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-2        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-3        
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-1      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7250-GET-ROW-COUNT-NON-CREW-HS                                 *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     GETS THE RECORD COUNT FOR HISTORY                          *        
      ******************************************************************        
                                                                        
       7250-GET-ROW-COUNT-NON-CREW-HS.                                  
                                                                        
           MOVE '7250'        TO ACTIVE-PARAGRAPH.                      
                                                                        
              EXEC SQL                                                  
                  SELECT                                                
                       COUNT(DISTINCT SO.SERV_ORDER_NO)                 
                  INTO                                                  
                       :WS-TOTAL-RECORDS                                
                  FROM                                                  
                       HST_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,HST_SO_DNP        DN WITH(READUNCOMMITTED)               
                      ,HST_SO_UTL_CHG    SC WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.COMPANY_NO         = :WS-COMPANY-NO            
                  AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE          
                  AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD         
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )     
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )       
                  AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID    
                        AND :WS-IS-RSP-AREA-NULL  = 'N' )               
                        OR  :WS-IS-RSP-AREA-NULL  = 'Y'                 
                      )                                                 
                  AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID    
                        AND :WS-IS-WRK-AREA-NULL  = 'N' )               
                        OR  :WS-IS-WRK-AREA-NULL  = 'Y'                 
                      )                                                 
                  AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS       
                        AND :WS-IS-STATUS-NULL    = 'N' )               
                        OR  :WS-IS-STATUS-NULL    = 'Y'                 
                      )                                                 
                  AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD     
                        AND :WS-IS-STATE-NULL     = 'N' )               
                        OR  :WS-IS-STATE-NULL     = 'Y'                 
                      )                                                 
                  AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON    
                        AND :WS-IS-ORD-RSN-NULL   = 'N' )               
                        OR  :WS-IS-ORD-RSN-NULL   = 'Y'                 
                      )                                                 
                  AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL      
                  AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL      
                  AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE      
                        AND :WS-IS-RD-ROUTE-NULL  = 'N' )               
                        OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                 
                      )                                                 
                  AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD        
                     AND :WS-IS-WRK-TYPE-NULL = 'N' )                   
                     OR  :WS-IS-WRK-TYPE-NULL = 'Y'                     
                  )                                                     
                                                                 
                                                                        
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT                                                        
MFA-TR*                COUNT(DISTINCT SO.SERV_ORDER_NO)                         
MFA-TR*           INTO                                                          
MFA-TR*                :WS-TOTAL-RECORDS                                        
MFA-TR*           FROM                                                          
MFA-TR*                HST_SO_DATA       SO                                     
MFA-TR*               ,HST_SO_ORDER_INST OI                                     
MFA-TR*               ,HST_SO_DNP        DN                                     
MFA-TR*               ,HST_SO_UTL_CHG    SC                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.COMPANY_NO         = :WS-COMPANY-NO                    
MFA-TR*           AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                  
MFA-TR*           AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                 
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT             
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT               
MFA-TR*           AND ( (   SO.RESP_AREA_ID       = :WS-RESP-AREA-ID            
MFA-TR*                 AND :WS-IS-RSP-AREA-NULL  = 'N' )                       
MFA-TR*                 OR  :WS-IS-RSP-AREA-NULL  = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.WORK_AREA_ID       = :WS-WORK-AREA-ID            
MFA-TR*                 AND :WS-IS-WRK-AREA-NULL  = 'N' )                       
MFA-TR*                 OR  :WS-IS-WRK-AREA-NULL  = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.SERV_ORDER_STATUS  = :WS-SO-STATUS               
MFA-TR*                 AND :WS-IS-STATUS-NULL    = 'N' )                       
MFA-TR*                 OR  :WS-IS-STATUS-NULL    = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.ORDER_STATE_CD     = :WS-SO-STATE-CD             
MFA-TR*                 AND :WS-IS-STATE-NULL     = 'N' )                       
MFA-TR*                 OR  :WS-IS-STATE-NULL     = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND ( (   SO.ORDER_REASON       = :WS-ORDER-REASON            
MFA-TR*                 AND :WS-IS-ORD-RSN-NULL   = 'N' )                       
MFA-TR*                 OR  :WS-IS-ORD-RSN-NULL   = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL              
MFA-TR*           AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL              
MFA-TR*           AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND ( (   SC.READ_ROUTE         = :WS-READ-ROUTE              
MFA-TR*                 AND :WS-IS-RD-ROUTE-NULL  = 'N' )                       
MFA-TR*                 OR  :WS-IS-RD-ROUTE-NULL  = 'Y'                         
MFA-TR*               )                                                         
MFA-TR*           AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND ( ( OI.WORK_TYPE_CD     = :WS-WORK-TYPE-CD                
MFA-TR*              AND :WS-IS-WRK-TYPE-NULL = 'N' )                           
MFA-TR*              OR  :WS-IS-WRK-TYPE-NULL = 'Y'                             
MFA-TR*           )                                                             
MFA-TR*           WITH UR                                                       
MFA-TR*                                                                         
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-2        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-3        
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-1      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-GET-ROW-COUNT-WITH-CREW-S1                                *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     GETS THE RECORD COUNT                                      *        
      ******************************************************************        
                                                                        
       7300-GET-ROW-COUNT-CREW-S1.                                      
                                                                        
           MOVE '7300'        TO ACTIVE-PARAGRAPH.                      
                                                                        
              EXEC SQL                                                  
                  SELECT                                                
                       COUNT(DISTINCT SO.SERV_ORDER_NO)                 
                  INTO                                                  
                       :WS-TOTAL-RECORDS                                
                  FROM                                                  
                       CSS_SO_DATA     SO WITH(READUNCOMMITTED)                 
                      ,CSS_SO_DNP      DN WITH(READUNCOMMITTED)                 
                      ,CSS_SO_UTL_CHG  SC WITH(READUNCOMMITTED)                 
                      ,CSS_SO_CREW     WM WITH(READUNCOMMITTED)                 
                  WHERE                                                 
                      SO.COMPANY_NO         = :WS-COMPANY-NO            
                  AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE          
                  AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD         
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )     
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )       
                  AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD           
                  AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL      
                  AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL      
                  AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND WM.CREW_ID            = :WS-CREW-ID               
                                                                 
                                                                        
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT                                                        
MFA-TR*                COUNT(DISTINCT SO.SERV_ORDER_NO)                         
MFA-TR*           INTO                                                          
MFA-TR*                :WS-TOTAL-RECORDS                                        
MFA-TR*           FROM                                                          
MFA-TR*                CSS_SO_DATA     SO                                       
MFA-TR*               ,CSS_SO_DNP      DN                                       
MFA-TR*               ,CSS_SO_UTL_CHG  SC                                       
MFA-TR*               ,CSS_SO_CREW     WM                                       
MFA-TR*           WHERE                                                         
MFA-TR*               SO.COMPANY_NO         = :WS-COMPANY-NO                    
MFA-TR*           AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                  
MFA-TR*           AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                 
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT             
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT               
MFA-TR*           AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                   
MFA-TR*           AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL              
MFA-TR*           AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL              
MFA-TR*           AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND WM.CREW_ID            = :WS-CREW-ID                       
MFA-TR*           WITH UR                                                       
MFA-TR*                                                                         
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 7325-GET-ROW-COUNT-WITH-CREW-S1-HST                            *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     GETS THE RECORD COUNT                                      *        
      ******************************************************************        
                                                                        
       7325-GET-ROW-COUNT-CREW-S1-HST.                                  
                                                                        
           MOVE '7325'        TO ACTIVE-PARAGRAPH.                      
                                                                        
              EXEC SQL                                                  
                  SELECT                                                
                       COUNT(DISTINCT SO.SERV_ORDER_NO)                 
                  INTO                                                  
                       :WS-TOTAL-RECORDS                                
                  FROM                                                  
                       HST_SO_DATA     SO WITH(READUNCOMMITTED)                 
                      ,HST_SO_DNP      DN WITH(READUNCOMMITTED)                 
                      ,HST_SO_UTL_CHG  SC WITH(READUNCOMMITTED)                 
                      ,HST_SO_CREW     WM WITH(READUNCOMMITTED)                 
                  WHERE                                                 
                      SO.COMPANY_NO         = :WS-COMPANY-NO            
                  AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE          
                  AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD         
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )     
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )       
                  AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD           
                  AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL      
                  AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL      
                  AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND WM.CREW_ID            = :WS-CREW-ID               
                                                                 
                                                                        
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT                                                        
MFA-TR*                COUNT(DISTINCT SO.SERV_ORDER_NO)                         
MFA-TR*           INTO                                                          
MFA-TR*                :WS-TOTAL-RECORDS                                        
MFA-TR*           FROM                                                          
MFA-TR*                HST_SO_DATA     SO                                       
MFA-TR*               ,HST_SO_DNP      DN                                       
MFA-TR*               ,HST_SO_UTL_CHG  SC                                       
MFA-TR*               ,HST_SO_CREW     WM                                       
MFA-TR*           WHERE                                                         
MFA-TR*               SO.COMPANY_NO         = :WS-COMPANY-NO                    
MFA-TR*           AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                  
MFA-TR*           AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                 
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT             
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT               
MFA-TR*           AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                   
MFA-TR*           AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL              
MFA-TR*           AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL              
MFA-TR*           AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND WM.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND WM.CREW_ID            = :WS-CREW-ID                       
MFA-TR*           WITH UR                                                       
MFA-TR*                                                                         
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7350-GET-ROW-COUNT-NON-CREW-S1                                 *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     GETS THE RECORD COUNT                                      *        
      ******************************************************************        
                                                                        
       7350-GET-ROW-COUNT-NON-CREW-S1.                                  
                                                                        
           MOVE '7350'        TO ACTIVE-PARAGRAPH.                      
                                                                        
              EXEC SQL                                                  
                  SELECT                                                
                       COUNT(DISTINCT SO.SERV_ORDER_NO)                 
                  INTO                                                  
                       :WS-TOTAL-RECORDS                                
                  FROM                                                  
                       CSS_SO_DATA     SO WITH(READUNCOMMITTED)                 
                      ,CSS_SO_DNP      DN WITH(READUNCOMMITTED)                 
                      ,CSS_SO_UTL_CHG  SC WITH(READUNCOMMITTED)                 
                  WHERE                                                 
                      SO.COMPANY_NO         = :WS-COMPANY-NO            
                  AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE          
                  AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD         
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )     
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )       
                  AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD           
                  AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL      
                  AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL      
                  AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                                                                 
                                                                        
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT                                                        
MFA-TR*                COUNT(DISTINCT SO.SERV_ORDER_NO)                         
MFA-TR*           INTO                                                          
MFA-TR*                :WS-TOTAL-RECORDS                                        
MFA-TR*           FROM                                                          
MFA-TR*                CSS_SO_DATA     SO                                       
MFA-TR*               ,CSS_SO_DNP      DN                                       
MFA-TR*               ,CSS_SO_UTL_CHG  SC                                       
MFA-TR*           WHERE                                                         
MFA-TR*               SO.COMPANY_NO         = :WS-COMPANY-NO                    
MFA-TR*           AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                  
MFA-TR*           AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                 
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT             
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT               
MFA-TR*           AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                   
MFA-TR*           AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL              
MFA-TR*           AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL              
MFA-TR*           AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           WITH UR                                                       
MFA-TR*                                                                         
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-2        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-3        
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-1      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7375-GET-ROW-COUNT-NON-CREW-SH                                 *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     GETS THE RECORD COUNT                                      *        
      ******************************************************************        
                                                                        
       7375-GET-ROW-COUNT-NON-CREW-SH.                                  
                                                                        
           MOVE '7375'        TO ACTIVE-PARAGRAPH.                      
                                                                        
              EXEC SQL                                                  
                  SELECT                                                
                       COUNT(DISTINCT SO.SERV_ORDER_NO)                 
                  INTO                                                  
                       :WS-TOTAL-RECORDS                                
                  FROM                                                  
                       HST_SO_DATA     SO WITH(READUNCOMMITTED)                 
                      ,HST_SO_DNP      DN WITH(READUNCOMMITTED)                 
                      ,HST_SO_UTL_CHG  SC WITH(READUNCOMMITTED)                 
                  WHERE                                                 
                      SO.COMPANY_NO         = :WS-COMPANY-NO            
                  AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE          
                  AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD         
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-START-DT
              )     
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                    :WS-ASSIGNED-END-DT
              )       
                  AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD           
                  AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                  AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL      
                  AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL      
                  AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO          
                                                                 
                                                                        
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT                                                        
MFA-TR*                COUNT(DISTINCT SO.SERV_ORDER_NO)                         
MFA-TR*           INTO                                                          
MFA-TR*                :WS-TOTAL-RECORDS                                        
MFA-TR*           FROM                                                          
MFA-TR*                HST_SO_DATA     SO                                       
MFA-TR*               ,HST_SO_DNP      DN                                       
MFA-TR*               ,HST_SO_UTL_CHG  SC                                       
MFA-TR*           WHERE                                                         
MFA-TR*               SO.COMPANY_NO         = :WS-COMPANY-NO                    
MFA-TR*           AND SO.LOCAL_OFFICE       = :WS-LOCAL-OFFICE                  
MFA-TR*           AND SO.ORDER_TYPE_CD      = :WS-ORDER-TYPE-CD                 
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-ASSIGNED-START-DT             
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-ASSIGNED-END-DT               
MFA-TR*           AND SO.ORDER_STATE_CD     = :WS-SO-STATE-CD                   
MFA-TR*           AND DN.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           AND DN.AMOUNT_DISC_BAL   >= :WS-MIN-AMT-DISC-BAL              
MFA-TR*           AND DN.AMOUNT_DISC_BAL   <= :WS-MAX-AMT-DISC-BAL              
MFA-TR*           AND SC.SERV_ORDER_NO      = SO.SERV_ORDER_NO                  
MFA-TR*           WITH UR                                                       
MFA-TR*                                                                         
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-2        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-3        
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-1      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7375-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-OPEN-CREW-CURSOR                                          *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7400-OPEN-CREW-CURSOR.                                           
                                                                        
           MOVE '7400'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN CREW-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7410-FETCH-CREW-CURSOR                                         *        
      *                                                                *        
      *     CALLED FROM 2400-PROCESS-CREW                              *        
      *                                                                *        
      *     FETCH THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7410-FETCH-CREW-CURSOR.                                          
                                                                        
           MOVE '7410'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH CREW-CURSOR                                         
              INTO  :VO-ORDER-REASON                                    
                   ,:AI-AMOUNT-DISC-BAL                                 
                   ,:AI-SECURITIES-TOT-AMT                              
                   ,:AI-CUR-MTH-ARREARS-CD                              
                   ,:AI-CREDIT-GROUP                                    
                   ,:VO-ASSIGNED-DATETIME                               
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-PREMISE-NO                                      
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VE-READ-ROUTE                                      
P00152             ,:VO-ORDER-PRIORITY-CD                               
P00152             ,:VO-ACCOUNT-TYPE-CODE                               
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7420-CLOSE-CREW-CURSOR                                         *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSE THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7420-CLOSE-CREW-CURSOR.                                          
                                                                        
           MOVE '7420'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE CREW-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7450-OPEN-CREW-CURSOR-HST                                      *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7450-OPEN-CREW-CURSOR-HST.                                       
                                                                        
           MOVE '7450'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN HST-CREW-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7460-FETCH-CREW-CURSOR-HST                                     *        
      *                                                                *        
      *     CALLED FROM 2400-PROCESS-CREW                              *        
      *                                                                *        
      *     FETCH THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7460-FETCH-CREW-CURSOR-HST.                                      
                                                                        
           MOVE '7460'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH HST-CREW-CURSOR                                     
              INTO  :VO-ORDER-REASON                                    
                   ,:AI-AMOUNT-DISC-BAL                                 
                   ,:AI-SECURITIES-TOT-AMT                              
                   ,:AI-CUR-MTH-ARREARS-CD                              
                   ,:AI-CREDIT-GROUP                                    
                   ,:VO-ASSIGNED-DATETIME                               
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-PREMISE-NO                                      
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VE-READ-ROUTE                                      
P00152             ,:VO-ORDER-PRIORITY-CD                               
P00152             ,:VO-ACCOUNT-TYPE-CODE                               
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7460-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7470-CLOSE-CREW-CURSOR-HST                                     *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSE THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7470-CLOSE-CREW-CURSOR-HST.                                      
                                                                        
           MOVE '7470'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE HST-CREW-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7470-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-OPEN-NON-CREW-CURSOR                                      *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7500-OPEN-NON-CREW-CURSOR.                                       
                                                                        
           MOVE '7500'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN NON-CREW-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-2        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-3        
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-1      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-FETCH-NON-CREW-CURSOR                                     *        
      *                                                                *        
      *     CALLED FROM 2400-PROCESS-CREW                              *        
      *                                                                *        
      *     FETCH THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7510-FETCH-NON-CREW-CURSOR.                                      
                                                                        
           MOVE '7510'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH NON-CREW-CURSOR                                     
              INTO  :VO-ORDER-REASON                                    
                   ,:AI-AMOUNT-DISC-BAL                                 
                   ,:AI-SECURITIES-TOT-AMT                              
                   ,:AI-CUR-MTH-ARREARS-CD                              
                   ,:AI-CREDIT-GROUP                                    
                   ,:VO-ASSIGNED-DATETIME                               
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-PREMISE-NO                                      
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VE-READ-ROUTE                                      
P00152             ,:VO-ORDER-PRIORITY-CD                               
P00152             ,:VO-ACCOUNT-TYPE-CODE                               
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-CLOSE-NON-CREW-CURSOR                                     *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSE THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7520-CLOSE-NON-CREW-CURSOR.                                      
                                                                        
           MOVE '7520'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE NON-CREW-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7550-OPEN-NON-CREW-CURSOR-HST                                  *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7550-OPEN-NON-CREW-CURSOR-HST.                                   
                                                                        
           MOVE '7550'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN HST-NON-CREW-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-2        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-3        
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-1      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7560-FETCH-NON-CREW-CURSOR-HST                                 *        
      *                                                                *        
      *     CALLED FROM 2400-PROCESS-CREW                              *        
      *                                                                *        
      *     FETCH THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7560-FETCH-NON-CREW-CURSOR-HST.                                  
                                                                        
           MOVE '7560'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH HST-NON-CREW-CURSOR                                 
              INTO  :VO-ORDER-REASON                                    
                   ,:AI-AMOUNT-DISC-BAL                                 
                   ,:AI-SECURITIES-TOT-AMT                              
                   ,:AI-CUR-MTH-ARREARS-CD                              
                   ,:AI-CREDIT-GROUP                                    
                   ,:VO-ASSIGNED-DATETIME                               
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-PREMISE-NO                                      
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VE-READ-ROUTE                                      
P00152             ,:VO-ORDER-PRIORITY-CD                               
P00152             ,:VO-ACCOUNT-TYPE-CODE                               
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7570-CLOSE-NON-CREW-CURSOR-HST                                 *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSE THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7570-CLOSE-NON-CREW-CURSOR-HST.                                  
                                                                        
           MOVE '7570'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE HST-NON-CREW-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7570-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7600-OPEN-CREW-CURSOR-S1                                       *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7600-OPEN-CREW-CURSOR-S1.                                        
                                                                        
           MOVE '7600'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN CREW-CURSOR-S1                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7610-FETCH-CREW-CURSOR                                         *        
      *                                                                *        
      *     CALLED FROM 2400-PROCESS-CREW                              *        
      *                                                                *        
      *     FETCH THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7610-FETCH-CREW-CURSOR-S1.                                       
                                                                        
           MOVE '7610'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH CREW-CURSOR-S1                                      
              INTO  :VO-ORDER-REASON                                    
                   ,:AI-AMOUNT-DISC-BAL                                 
                   ,:AI-SECURITIES-TOT-AMT                              
                   ,:AI-CUR-MTH-ARREARS-CD                              
                   ,:AI-CREDIT-GROUP                                    
                   ,:VO-ASSIGNED-DATETIME                               
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-PREMISE-NO                                      
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VE-READ-ROUTE                                      
P00152             ,:VO-ORDER-PRIORITY-CD                               
P00152             ,:VO-ACCOUNT-TYPE-CODE                               
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7620-CLOSE-CREW-CURSOR-S1                                      *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSE THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7620-CLOSE-CREW-CURSOR-S1.                                       
                                                                        
           MOVE '7620'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE CREW-CURSOR-S1                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7650-OPEN-CREW-CURSOR-S1-HST                                   *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7650-OPEN-CREW-CURSOR-S1-HST.                                    
                                                                        
           MOVE '7650'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN HST-CREW-CURSOR-S1                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7660-FETCH-CREW-CURSOR-HST                                     *        
      *                                                                *        
      *     CALLED FROM 2400-PROCESS-CREW                              *        
      *                                                                *        
      *     FETCH THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7660-FETCH-CREW-CURSOR-S1-HST.                                   
                                                                        
           MOVE '7660'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH HST-CREW-CURSOR-S1                                  
              INTO  :VO-ORDER-REASON                                    
                   ,:AI-AMOUNT-DISC-BAL                                 
                   ,:AI-SECURITIES-TOT-AMT                              
                   ,:AI-CUR-MTH-ARREARS-CD                              
                   ,:AI-CREDIT-GROUP                                    
                   ,:VO-ASSIGNED-DATETIME                               
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-PREMISE-NO                                      
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VE-READ-ROUTE                                      
P00152             ,:VO-ORDER-PRIORITY-CD                               
P00152             ,:VO-ACCOUNT-TYPE-CODE                               
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7660-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7670-CLOSE-CREW-CURSOR-S1-HST                                  *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSE THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7670-CLOSE-CREW-CURSOR-S1-HST.                                   
                                                                        
           MOVE '7670'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE HST-CREW-CURSOR-S1                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7670-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7700-OPEN-NON-CREW-CURSOR-S1                                   *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7700-OPEN-NON-CREW-CURSOR-S1.                                    
                                                                        
           MOVE '7700'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN NON-CREW-CURSOR-S1                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-2        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-3        
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-1      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7710-FETCH-NON-CREW-CURSOR-S1                                  *        
      *                                                                *        
      *     CALLED FROM 2400-PROCESS-CREW                              *        
      *                                                                *        
      *     FETCH THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7710-FETCH-NON-CREW-CURSOR-S1.                                   
                                                                        
           MOVE '7710'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH NON-CREW-CURSOR-S1                                  
              INTO  :VO-ORDER-REASON                                    
                   ,:AI-AMOUNT-DISC-BAL                                 
                   ,:AI-SECURITIES-TOT-AMT                              
                   ,:AI-CUR-MTH-ARREARS-CD                              
                   ,:AI-CREDIT-GROUP                                    
                   ,:VO-ASSIGNED-DATETIME                               
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-PREMISE-NO                                      
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VE-READ-ROUTE                                      
P00152             ,:VO-ORDER-PRIORITY-CD                               
P00152             ,:VO-ACCOUNT-TYPE-CODE                               
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7720-CLOSE-NON-CREW-CURSOR-S1                                  *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSE THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7720-CLOSE-NON-CREW-CURSOR-S1.                                   
                                                                        
           MOVE '7750'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE NON-CREW-CURSOR-S1                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7750-OPEN-NON-CREW-CURSOR-SH                                   *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7750-OPEN-NON-CREW-CURSOR-SH.                                    
                                                                        
           MOVE '7750'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN HST-NON-CREW-CURSOR-S1                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-2        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-3        
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-1      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7760-FETCH-NON-CREW-CURSOR-SH                                  *        
      *                                                                *        
      *     CALLED FROM 2400-PROCESS-CREW                              *        
      *                                                                *        
      *     FETCH THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7760-FETCH-NON-CREW-CURSOR-SH.                                   
                                                                        
           MOVE '7760'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH HST-NON-CREW-CURSOR-S1                              
              INTO  :VO-ORDER-REASON                                    
                   ,:AI-AMOUNT-DISC-BAL                                 
                   ,:AI-SECURITIES-TOT-AMT                              
                   ,:AI-CUR-MTH-ARREARS-CD                              
                   ,:AI-CREDIT-GROUP                                    
                   ,:VO-ASSIGNED-DATETIME                               
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-PREMISE-NO                                      
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VE-READ-ROUTE                                      
P00152             ,:VO-ORDER-PRIORITY-CD                               
P00152             ,:VO-ACCOUNT-TYPE-CODE                               
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7760-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7770-CLOSE-NON-CREW-CURSOR-SH                                  *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSE THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       7770-CLOSE-NON-CREW-CURSOR-SH.                                   
                                                                        
           MOVE '7770'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE HST-NON-CREW-CURSOR-S1                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'CREW_ID'                  TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-3        
              MOVE 'ORDER_TYPE_CD'            TO TABLE-ELEMENT-4        
              MOVE WS-CREW-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE WS-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
              MOVE WS-ORDER-TYPE-CD           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7770-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05317 7800-USER-PROFILE.                                               
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         SELECT TOP(1) RTRIM(LTRIM(RTRIM(LAST_NAME) + ', ' + 
           LTRIM(RTRIM(FIRST_NAME) + ' ' + LTRIM(RTRIM(MIDDLE_NAME)))))        
A05317           INTO :WS-USER-NAME                                     
A05317           FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
A05317          WHERE USER_ID = :PF-USER-ID                             
A05317                                           
A05317                                                           
A05317                                                      
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(LAST_NAME) || ', ' ||                   
MFA-TR*               LTRIM(RTRIM(FIRST_NAME) || ' ' ||                         
MFA-TR*               LTRIM(RTRIM(MIDDLE_NAME)))))                              
MFA-TR*          INTO :WS-USER-NAME                                             
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :PF-USER-ID                                     
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7800                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
A05317                                                                  
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             IF WS-USER-NAME = 'SYSTEM,'                          
A05317                 MOVE 'SYSTEM' TO WS-USER-NAME                    
A05317             END-IF                                               
A05317         WHEN NOT-FOUND                                           
A05317             MOVE PF-USER-ID TO WS-USER-NAME                      
A05317             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05317         WHEN OTHER                                               
A05317             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
A05317             MOVE 'SELECT'              TO ABEND-FUNCTION         
A05317             MOVE 'CSS_USER_PROFILE'    TO TABLE-1                
A05317             MOVE PF-USER-ID            TO HOSTVAR-ELEMENT-1      
A05317             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A05317             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317 7800-EXIT.                                                       
A05317     EXIT.                                                        
                                                                        
      ******************************************************************        
      *8100-SEND-RESULT                                                *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR01250_R1                         
                (                                                       
                                                                        
                     FULL_NAME                                          
                    ,FIRST_NAME                                         
                    ,MIDDLE_NAME                                        
                    ,LAST_NAME                                          
                    ,NAME_FORMAT                                        
                    ,ORDER_TYPE_DESC                                    
                    ,ORDER_REASON                                       
                    ,AMOUNT_DISC_BAL                                    
                    ,SECURITIES_TOT_AMT                                 
                    ,CUR_MTH_ARREARS_CD                                 
                    ,CREDIT_GROUP                                       
                    ,ASSIGNED_DATETIME                                  
                    ,STATUS_TX                                          
                    ,ORDER_STATE_CD                                     
                    ,SERV_ORDER_NO                                      
                    ,ACCOUNT_NO                                         
                    ,TOTAL                                              
                    ,PREMISE_NO                                         
                    ,ORDER_GROUP_CD                                     
                    ,COMPANY_NO                                         
                    ,LOCAL_OFFICE                                       
                    ,ACCOUNT_NO_PRIOR                                   
                    ,SERV_ORDER_STATUS                                  
                    ,ORDER_TYPE_CD                                      
                    ,CUSTOMER_NO                                        
                    ,ZIP_CODE                                           
                    ,READ_ROUTE                                         
P00152              ,ADDRESS                                            
P00152              ,ORDER_PRIORITY_CD                                  
P00152              ,ACCOUNT_TYPE_CD                                    
A05317              ,ORDER_RECVED_BY                                    
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-FULL-NAME                                       
                    ,:S-FIRST-NAME                                      
                    ,:S-MIDDLE-NAME                                     
                    ,:S-LAST-NAME                                       
                    ,:S-NAME-FORMAT                                     
                    ,:S-ORDER-TYPE-DESC                                 
                    ,:S-ORDER-REASON                                    
                    ,:S-AMOUNT-DISC-BAL                                 
                    ,:S-SECURITIES-TOT-AMT                              
                    ,:S-CUR-MTH-ARREARS-CD                              
                    ,:S-CREDIT-GROUP                                    
                    ,:S-ASSIGNED-DATETIME                               
                    ,:S-STATUS-TX                                       
                    ,:S-ORDER-STATE-CD                                  
                    ,:S-SERV-ORDER-NO                                   
                    ,:S-ACCOUNT-NO                                      
                    ,:S-TOTAL                                           
                    ,:S-PREMISE-NO                                      
                    ,:S-ORDER-GROUP-CD                                  
                    ,:S-COMPANY-NO                                      
                    ,:S-LOCAL-OFFICE                                    
                    ,:S-ACCOUNT-NO-PRIOR                                
                    ,:S-SERV-ORDER-STATUS                               
                    ,:S-ORDER-TYPE-CD                                   
                    ,:S-CUSTOMER-NO                                     
                    ,:S-ZIP-CODE                                        
                    ,:S-READ-ROUTE                                      
P00152              ,:S-ADDRESS                                         
P00152              ,:S-ORDER-PRIORITY-CD                               
P00152              ,:S-ACCOUNT-TYPE-CD                                 
A05317              ,:S-ORDER-RECVED-BY                                 
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR01250_R1                                 
MFA-TR*         (                                                       01670000
MFA-TR*                                                                 01670000
MFA-TR*              FULL_NAME                                                  
MFA-TR*             ,FIRST_NAME                                                 
MFA-TR*             ,MIDDLE_NAME                                                
MFA-TR*             ,LAST_NAME                                                  
MFA-TR*             ,NAME_FORMAT                                                
MFA-TR*             ,ORDER_TYPE_DESC                                            
MFA-TR*             ,ORDER_REASON                                               
MFA-TR*             ,AMOUNT_DISC_BAL                                            
MFA-TR*             ,SECURITIES_TOT_AMT                                         
MFA-TR*             ,CUR_MTH_ARREARS_CD                                         
MFA-TR*             ,CREDIT_GROUP                                               
MFA-TR*             ,ASSIGNED_DATETIME                                          
MFA-TR*             ,STATUS_TX                                                  
MFA-TR*             ,ORDER_STATE_CD                                             
MFA-TR*             ,SERV_ORDER_NO                                              
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,TOTAL                                                      
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,ORDER_GROUP_CD                                             
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,ACCOUNT_NO_PRIOR                                           
MFA-TR*             ,SERV_ORDER_STATUS                                          
MFA-TR*             ,ORDER_TYPE_CD                                              
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,ZIP_CODE                                                   
MFA-TR*             ,READ_ROUTE                                                 
MFA-TR*             ,ADDRESS                                                    
MFA-TR*             ,ORDER_PRIORITY_CD                                          
MFA-TR*             ,ACCOUNT_TYPE_CD                                            
MFA-TR*             ,ORDER_RECVED_BY                                            
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                       01670000
MFA-TR*              :S-FULL-NAME                                               
MFA-TR*             ,:S-FIRST-NAME                                              
MFA-TR*             ,:S-MIDDLE-NAME                                             
MFA-TR*             ,:S-LAST-NAME                                               
MFA-TR*             ,:S-NAME-FORMAT                                             
MFA-TR*             ,:S-ORDER-TYPE-DESC                                         
MFA-TR*             ,:S-ORDER-REASON                                            
MFA-TR*             ,:S-AMOUNT-DISC-BAL                                         
MFA-TR*             ,:S-SECURITIES-TOT-AMT                                      
MFA-TR*             ,:S-CUR-MTH-ARREARS-CD                                      
MFA-TR*             ,:S-CREDIT-GROUP                                            
MFA-TR*             ,:S-ASSIGNED-DATETIME                                       
MFA-TR*             ,:S-STATUS-TX                                               
MFA-TR*             ,:S-ORDER-STATE-CD                                          
MFA-TR*             ,:S-SERV-ORDER-NO                                           
MFA-TR*             ,:S-ACCOUNT-NO                                              
MFA-TR*             ,:S-TOTAL                                                   
MFA-TR*             ,:S-PREMISE-NO                                              
MFA-TR*             ,:S-ORDER-GROUP-CD                                          
MFA-TR*             ,:S-COMPANY-NO                                              
MFA-TR*             ,:S-LOCAL-OFFICE                                            
MFA-TR*             ,:S-ACCOUNT-NO-PRIOR                                        
MFA-TR*             ,:S-SERV-ORDER-STATUS                                       
MFA-TR*             ,:S-ORDER-TYPE-CD                                           
MFA-TR*             ,:S-CUSTOMER-NO                                             
MFA-TR*             ,:S-ZIP-CODE                                                
MFA-TR*             ,:S-READ-ROUTE                                              
MFA-TR*             ,:S-ADDRESS                                                 
MFA-TR*             ,:S-ORDER-PRIORITY-CD                                       
MFA-TR*             ,:S-ACCOUNT-TYPE-CD                                         
MFA-TR*             ,:S-ORDER-RECVED-BY                                         
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                ADD +1                    TO CTR-ROWS                   
           ELSE                                                         
                MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
                MOVE SQLCODE              TO ABEND-SQLCODE              
                MOVE '8100'               TO ACTIVE-PARAGRAPH           
                MOVE 'INSERT'             TO ABEND-FUNCTION             
                MOVE SPACES               TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                MOVE 'CSR01250_R1'        TO TABLE-1                    
                MOVE SPACES               TO TABLE-ELEMENT-1            
                MOVE SPACES               TO HOSTVAR-ELEMENT-1          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8200-UPDATE-RESULT                                              *        
      ******************************************************************        
       8200-UPDATE-RESULT.                                              
      *                                                                         
           EXEC SQL                                                     
                UPDATE FS                            
                SET                                                     
                FULL_NAME = (SELECT LEFT( RTRIM(DQ.FULL_NAME), 70 )
            FROM                                               
                          CSS_NAME_ACCT_XREF HT                         
                         ,CSS_NAME           DQ                         
                         ,CSS_ADDR_FORMATTED DY                         
                         ,CSS_ORDER_TYPE     OT                         
                         ,CSS_WK_CLASS_STAT  WC
            WHERE                                             
                          FS.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.CUSTOMER_ROLE_CD   = ' '                   
                      AND DQ.NAME_ID            = HT.NAME_ID            
                      AND DQ.NAME_TYPE          = 'CN'                  
                      AND DY.ADDRESS_ID         = HT.ADDRESS_ID         
                      AND OT.ORDER_TYPE_CD      = FS.ORDER_TYPE_CD      
                      AND OT.COMPANY_NO         = FS.COMPANY_NO         
                      AND WC.WORK_CLASS_ID      = OT.WORK_CLASS_ID      
                      AND WC.SERV_ORDER_STATUS  = FS.SERV_ORDER_STATUS),
               FIRST_NAME = (SELECT DQ.FIRST_NAME
            FROM                                               
                          CSS_NAME_ACCT_XREF HT                         
                         ,CSS_NAME           DQ                         
                         ,CSS_ADDR_FORMATTED DY                         
                         ,CSS_ORDER_TYPE     OT                         
                         ,CSS_WK_CLASS_STAT  WC
            WHERE                                             
                          FS.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.CUSTOMER_ROLE_CD   = ' '                   
                      AND DQ.NAME_ID            = HT.NAME_ID            
                      AND DQ.NAME_TYPE          = 'CN'                  
                      AND DY.ADDRESS_ID         = HT.ADDRESS_ID         
                      AND OT.ORDER_TYPE_CD      = FS.ORDER_TYPE_CD      
                      AND OT.COMPANY_NO         = FS.COMPANY_NO         
                      AND WC.WORK_CLASS_ID      = OT.WORK_CLASS_ID      
                      AND WC.SERV_ORDER_STATUS  = FS.SERV_ORDER_STATUS),
               MIDDLE_NAME = (SELECT DQ.MIDDLE_NAME
            FROM                                               
                          CSS_NAME_ACCT_XREF HT                         
                         ,CSS_NAME           DQ                         
                         ,CSS_ADDR_FORMATTED DY                         
                         ,CSS_ORDER_TYPE     OT                         
                         ,CSS_WK_CLASS_STAT  WC
            WHERE                                             
                          FS.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.CUSTOMER_ROLE_CD   = ' '                   
                      AND DQ.NAME_ID            = HT.NAME_ID            
                      AND DQ.NAME_TYPE          = 'CN'                  
                      AND DY.ADDRESS_ID         = HT.ADDRESS_ID         
                      AND OT.ORDER_TYPE_CD      = FS.ORDER_TYPE_CD      
                      AND OT.COMPANY_NO         = FS.COMPANY_NO         
                      AND WC.WORK_CLASS_ID      = OT.WORK_CLASS_ID      
                      AND WC.SERV_ORDER_STATUS  = FS.SERV_ORDER_STATUS),
               LAST_NAME = (SELECT LEFT( RTRIM(DQ.LAST_NAME), 40 )
            FROM                                               
                          CSS_NAME_ACCT_XREF HT                         
                         ,CSS_NAME           DQ                         
                         ,CSS_ADDR_FORMATTED DY                         
                         ,CSS_ORDER_TYPE     OT                         
                         ,CSS_WK_CLASS_STAT  WC
            WHERE                                             
                          FS.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.CUSTOMER_ROLE_CD   = ' '                   
                      AND DQ.NAME_ID            = HT.NAME_ID            
                      AND DQ.NAME_TYPE          = 'CN'                  
                      AND DY.ADDRESS_ID         = HT.ADDRESS_ID         
                      AND OT.ORDER_TYPE_CD      = FS.ORDER_TYPE_CD      
                      AND OT.COMPANY_NO         = FS.COMPANY_NO         
                      AND WC.WORK_CLASS_ID      = OT.WORK_CLASS_ID      
                      AND WC.SERV_ORDER_STATUS  = FS.SERV_ORDER_STATUS),
               NAME_FORMAT = (SELECT DQ.NAME_FORMAT
            FROM                                               
                          CSS_NAME_ACCT_XREF HT                         
                         ,CSS_NAME           DQ                         
                         ,CSS_ADDR_FORMATTED DY                         
                         ,CSS_ORDER_TYPE     OT                         
                         ,CSS_WK_CLASS_STAT  WC
            WHERE                                             
                          FS.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.CUSTOMER_ROLE_CD   = ' '                   
                      AND DQ.NAME_ID            = HT.NAME_ID            
                      AND DQ.NAME_TYPE          = 'CN'                  
                      AND DY.ADDRESS_ID         = HT.ADDRESS_ID         
                      AND OT.ORDER_TYPE_CD      = FS.ORDER_TYPE_CD      
                      AND OT.COMPANY_NO         = FS.COMPANY_NO         
                      AND WC.WORK_CLASS_ID      = OT.WORK_CLASS_ID      
                      AND WC.SERV_ORDER_STATUS  = FS.SERV_ORDER_STATUS),
               ORDER_TYPE_DESC = (SELECT OT.ORDER_TYPE_DESC
            FROM                                               
                          CSS_NAME_ACCT_XREF HT                         
                         ,CSS_NAME           DQ                         
                         ,CSS_ADDR_FORMATTED DY                         
                         ,CSS_ORDER_TYPE     OT                         
                         ,CSS_WK_CLASS_STAT  WC
            WHERE                                             
                          FS.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.CUSTOMER_ROLE_CD   = ' '                   
                      AND DQ.NAME_ID            = HT.NAME_ID            
                      AND DQ.NAME_TYPE          = 'CN'                  
                      AND DY.ADDRESS_ID         = HT.ADDRESS_ID         
                      AND OT.ORDER_TYPE_CD      = FS.ORDER_TYPE_CD      
                      AND OT.COMPANY_NO         = FS.COMPANY_NO         
                      AND WC.WORK_CLASS_ID      = OT.WORK_CLASS_ID      
                      AND WC.SERV_ORDER_STATUS  = FS.SERV_ORDER_STATUS),
               STATUS_TX = (SELECT WC.STATUS_TX
            FROM                                               
                          CSS_NAME_ACCT_XREF HT                         
                         ,CSS_NAME           DQ                         
                         ,CSS_ADDR_FORMATTED DY                         
                         ,CSS_ORDER_TYPE     OT                         
                         ,CSS_WK_CLASS_STAT  WC
            WHERE                                             
                          FS.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.CUSTOMER_ROLE_CD   = ' '                   
                      AND DQ.NAME_ID            = HT.NAME_ID            
                      AND DQ.NAME_TYPE          = 'CN'                  
                      AND DY.ADDRESS_ID         = HT.ADDRESS_ID         
                      AND OT.ORDER_TYPE_CD      = FS.ORDER_TYPE_CD      
                      AND OT.COMPANY_NO         = FS.COMPANY_NO         
                      AND WC.WORK_CLASS_ID      = OT.WORK_CLASS_ID      
                      AND WC.SERV_ORDER_STATUS  = FS.SERV_ORDER_STATUS),
               ORDER_GROUP_CD = (SELECT OT.ORDER_GROUP_CD
            FROM                                               
                          CSS_NAME_ACCT_XREF HT                         
                         ,CSS_NAME           DQ                         
                         ,CSS_ADDR_FORMATTED DY                         
                         ,CSS_ORDER_TYPE     OT                         
                         ,CSS_WK_CLASS_STAT  WC
            WHERE                                             
                          FS.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.CUSTOMER_ROLE_CD   = ' '                   
                      AND DQ.NAME_ID            = HT.NAME_ID            
                      AND DQ.NAME_TYPE          = 'CN'                  
                      AND DY.ADDRESS_ID         = HT.ADDRESS_ID         
                      AND OT.ORDER_TYPE_CD      = FS.ORDER_TYPE_CD      
                      AND OT.COMPANY_NO         = FS.COMPANY_NO         
                      AND WC.WORK_CLASS_ID      = OT.WORK_CLASS_ID      
                      AND WC.SERV_ORDER_STATUS  = FS.SERV_ORDER_STATUS),
               CUSTOMER_NO = (SELECT HT.CUSTOMER_NO
            FROM                                               
                          CSS_NAME_ACCT_XREF HT                         
                         ,CSS_NAME           DQ                         
                         ,CSS_ADDR_FORMATTED DY                         
                         ,CSS_ORDER_TYPE     OT                         
                         ,CSS_WK_CLASS_STAT  WC
            WHERE                                             
                          FS.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.CUSTOMER_ROLE_CD   = ' '                   
                      AND DQ.NAME_ID            = HT.NAME_ID            
                      AND DQ.NAME_TYPE          = 'CN'                  
                      AND DY.ADDRESS_ID         = HT.ADDRESS_ID         
                      AND OT.ORDER_TYPE_CD      = FS.ORDER_TYPE_CD      
                      AND OT.COMPANY_NO         = FS.COMPANY_NO         
                      AND WC.WORK_CLASS_ID      = OT.WORK_CLASS_ID      
                      AND WC.SERV_ORDER_STATUS  = FS.SERV_ORDER_STATUS),
               ZIP_CODE = (SELECT DY.ZIP_CODE
            FROM                                               
                          CSS_NAME_ACCT_XREF HT                         
                         ,CSS_NAME           DQ                         
                         ,CSS_ADDR_FORMATTED DY                         
                         ,CSS_ORDER_TYPE     OT                         
                         ,CSS_WK_CLASS_STAT  WC
            WHERE                                             
                          FS.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.CUSTOMER_ROLE_CD   = ' '                   
                      AND DQ.NAME_ID            = HT.NAME_ID            
                      AND DQ.NAME_TYPE          = 'CN'                  
                      AND DY.ADDRESS_ID         = HT.ADDRESS_ID         
                      AND OT.ORDER_TYPE_CD      = FS.ORDER_TYPE_CD      
                      AND OT.COMPANY_NO         = FS.COMPANY_NO         
                      AND WC.WORK_CLASS_ID      = OT.WORK_CLASS_ID      
                      AND WC.SERV_ORDER_STATUS  = FS.SERV_ORDER_STATUS),
               ADDRESS = (SELECT RTRIM(DY.HOUSE_NO) + RTRIM(
           DY.ADDR_PREFIX_1) + ' ' + RTRIM(DY.ADDR_PREFIX_2) + ' ' + 
           RTRIM(DY.STREET_NAME) + ' ' + RTRIM(DY.STREET_SUFFIX) + 
           ' ' + RTRIM(DY.STREET_LOCATION_1) + ' ' + RTRIM(
           DY.STREET_LOCATION_2)
            FROM                                               
                          CSS_NAME_ACCT_XREF HT                         
                         ,CSS_NAME           DQ                         
                         ,CSS_ADDR_FORMATTED DY                         
                         ,CSS_ORDER_TYPE     OT                         
                         ,CSS_WK_CLASS_STAT  WC
            WHERE                                             
                          FS.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.ACCOUNT_NO         = FS.ACCOUNT_NO         
                      AND HT.CUSTOMER_ROLE_CD   = ' '                   
                      AND DQ.NAME_ID            = HT.NAME_ID            
                      AND DQ.NAME_TYPE          = 'CN'                  
                      AND DY.ADDRESS_ID         = HT.ADDRESS_ID         
                      AND OT.ORDER_TYPE_CD      = FS.ORDER_TYPE_CD      
                      AND OT.COMPANY_NO         = FS.COMPANY_NO         
                      AND WC.WORK_CLASS_ID      = OT.WORK_CLASS_ID      
                      AND WC.SERV_ORDER_STATUS  = 
           FS.SERV_ORDER_STATUS)                FROM #CSR01250_R1 FS
                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR* MSQ055
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE SESSION.CSR01250_R1 FS                                   
MFA-TR*         SET                                                     01670000
MFA-TR*         (                                                       01670000
MFA-TR*              FULL_NAME                                                  
MFA-TR*             ,FIRST_NAME                                                 
MFA-TR*             ,MIDDLE_NAME                                                
MFA-TR*             ,LAST_NAME                                                  
MFA-TR*             ,NAME_FORMAT                                                
MFA-TR*             ,ORDER_TYPE_DESC                                            
MFA-TR*             ,STATUS_TX                                                  
MFA-TR*             ,ORDER_GROUP_CD                                             
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,ZIP_CODE                                                   
MFA-TR*             ,ADDRESS                                                    
MFA-TR*         )                                                               
MFA-TR*         =                                                               
MFA-TR*         (                                                       01670000
MFA-TR*              SELECT                                                     
MFA-TR*                   LEFT(RTRIM(DQ.FULL_NAME),70)                          
MFA-TR*                  ,DQ.FIRST_NAME                                         
MFA-TR*                  ,DQ.MIDDLE_NAME                                        
MFA-TR*                  ,LEFT(RTRIM(DQ.LAST_NAME),40)                          
MFA-TR*                  ,DQ.NAME_FORMAT                                        
MFA-TR*                  ,OT.ORDER_TYPE_DESC                                    
MFA-TR*                  ,WC.STATUS_TX                                          
MFA-TR*                  ,OT.ORDER_GROUP_CD                                     
MFA-TR*                  ,HT.CUSTOMER_NO                                        
MFA-TR*                  ,DY.ZIP_CODE                                           
MFA-TR*                  ,RTRIM(DY.HOUSE_NO)          ||                        
MFA-TR*                   RTRIM(DY.ADDR_PREFIX_1)     || ' ' ||                 
MFA-TR*                   RTRIM(DY.ADDR_PREFIX_2)     || ' ' ||                 
MFA-TR*                   RTRIM(DY.STREET_NAME)       || ' ' ||                 
MFA-TR*                   RTRIM(DY.STREET_SUFFIX)     || ' ' ||                 
MFA-TR*                   RTRIM(DY.STREET_LOCATION_1) || ' ' ||                 
MFA-TR*                   RTRIM(DY.STREET_LOCATION_2)                           
MFA-TR*              FROM                                                       
MFA-TR*                   CSS_NAME_ACCT_XREF HT                                 
MFA-TR*                  ,CSS_NAME           DQ                                 
MFA-TR*                  ,CSS_ADDR_FORMATTED DY                                 
MFA-TR*                  ,CSS_ORDER_TYPE     OT                                 
MFA-TR*                  ,CSS_WK_CLASS_STAT  WC                                 
MFA-TR*               WHERE                                                     
MFA-TR*                   FS.ACCOUNT_NO         = FS.ACCOUNT_NO                 
MFA-TR*               AND HT.ACCOUNT_NO         = FS.ACCOUNT_NO                 
MFA-TR*               AND HT.CUSTOMER_ROLE_CD   = ' '                           
MFA-TR*               AND DQ.NAME_ID            = HT.NAME_ID                    
MFA-TR*               AND DQ.NAME_TYPE          = 'CN'                          
MFA-TR*               AND DY.ADDRESS_ID         = HT.ADDRESS_ID                 
MFA-TR*               AND OT.ORDER_TYPE_CD      = FS.ORDER_TYPE_CD              
MFA-TR*               AND OT.COMPANY_NO         = FS.COMPANY_NO                 
MFA-TR*               AND WC.WORK_CLASS_ID      = OT.WORK_CLASS_ID              
MFA-TR*               AND WC.SERV_ORDER_STATUS  = FS.SERV_ORDER_STATUS          
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                ADD +1                    TO CTR-ROWS                   
           ELSE                                                         
                MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
                MOVE SQLCODE              TO ABEND-SQLCODE              
                MOVE '8200'               TO ACTIVE-PARAGRAPH           
                MOVE 'UPDATE'             TO ABEND-FUNCTION             
                MOVE SPACES               TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                MOVE 'CSR01250_R1'        TO TABLE-1                    
                MOVE SPACES               TO TABLE-ELEMENT-1            
                MOVE SPACES               TO HOSTVAR-ELEMENT-1          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
P00152     EXEC SQL                                                     
P00152        UPDATE                                                    
P00152             FS                                
P00152        SET                                                       
P00152        ADDRESS                                                         
P00152        =                                                         
P00152        (    SELECT                                               
P00152                 RTRIM(DY.HOUSE_NO) + RTRIM(DY.ADDR_PREFIX_1) + 
           ' ' + RTRIM(DY.ADDR_PREFIX_2) + ' ' + RTRIM(DY.STREET_NAME
           ) + ' ' + RTRIM(DY.STREET_SUFFIX) + ' ' + RTRIM(
           DY.STREET_LOCATION_1) + ' ' + RTRIM(DY.STREET_LOCATION_2)           
P00152             FROM                                                 
P00152                 CSS_ADDR_FORMATTED DY                            
P00152                ,CSS_PREMISE        PO                            
P00152             WHERE                                                
P00152                 FS.ACCOUNT_NO = 0                                
P00152             AND FS.PREMISE_NO = PO.PREMISE_NO                    
P00152             AND DY.ADDRESS_ID = PO.ADDRESS_ID                    
P00152        )                                                         
              FROM #CSR01250_R1 FS
P00152        WHERE                                                     
P00152            FS.ACCOUNT_NO = 0                                     
P00152     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR* MSQ055
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE                                                            
MFA-TR*            SESSION.CSR01250_R1 FS                                       
MFA-TR*       SET                                                               
MFA-TR*       (                                                                 
MFA-TR*            ADDRESS                                                      
MFA-TR*       )                                                                 
MFA-TR*       =                                                                 
MFA-TR*       (    SELECT                                                       
MFA-TR*                RTRIM(DY.HOUSE_NO)           ||                          
MFA-TR*                RTRIM(DY.ADDR_PREFIX_1)      || ' ' ||                   
MFA-TR*                RTRIM(DY.ADDR_PREFIX_2)      || ' ' ||                   
MFA-TR*                RTRIM(DY.STREET_NAME)        || ' ' ||                   
MFA-TR*                RTRIM(DY.STREET_SUFFIX)      || ' ' ||                   
MFA-TR*                RTRIM(DY.STREET_LOCATION_1)  || ' ' ||                   
MFA-TR*                RTRIM(DY.STREET_LOCATION_2)                              
MFA-TR*            FROM                                                         
MFA-TR*                CSS_ADDR_FORMATTED DY                                    
MFA-TR*               ,CSS_PREMISE        PO                                    
MFA-TR*            WHERE                                                        
MFA-TR*                FS.ACCOUNT_NO = 0                                        
MFA-TR*            AND FS.PREMISE_NO = PO.PREMISE_NO                            
MFA-TR*            AND DY.ADDRESS_ID = PO.ADDRESS_ID                            
MFA-TR*       )                                                                 
MFA-TR*       WHERE                                                             
MFA-TR*           FS.ACCOUNT_NO = 0                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00152                                                                  
P00152     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00152                                                                  
P00152     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00152        NEXT SENTENCE                                             
P00152     ELSE                                                         
P00152          MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
P00152          MOVE SQLCODE              TO ABEND-SQLCODE              
P00152          MOVE '8200'               TO ACTIVE-PARAGRAPH           
P00152          MOVE 'UPDATE'             TO ABEND-FUNCTION             
P00152          MOVE SPACES               TO ABEND-SQL-PREDICATES       
P00152                                       ABEND-TABLES               
P00152          MOVE 'CSR01250_R1'        TO TABLE-1                    
P00152          MOVE 'PREMISE'            TO TABLE-ELEMENT-1            
P00152          MOVE SPACES               TO HOSTVAR-ELEMENT-1          
P00152          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
P00152     END-IF.                                                      
P00152                                                                  
P00152     EXEC SQL                                                     
P00152        UPDATE                                                    
P00152             FS                                
P00152        SET                                                       
P00152        ADDRESS =                                                       
P00152        (                                                         
P00152             SELECT                                               
P00152                  RTRIM(DY.STREET_NAME) + '&' + RTRIM(
           DY.ADDRESS_OVERFLOW)                      
P00152             FROM                                                 
P00152                  CSS_ADDR_FORMATTED DY                           
P00152                 ,CSS_PREMISE        PO                           
P00152             WHERE                                                
P00152                 FS.PREMISE_NO    = PO.PREMISE_NO                 
P00152             AND DY.ADDRESS_ID    = PO.ADDRESS_ID                 
P00152             AND DY.ADDR_USAGE_CD = 'I'                           
P00152        )                                                         
              FROM #CSR01250_R1 FS
P00152        WHERE EXISTS                                              
P00152        (                                                         
P00152             SELECT                                               
P00152                  1                                               
P00152             FROM                                                 
P00152                  CSS_ADDR_FORMATTED DY                           
P00152                 ,CSS_PREMISE        PO                           
P00152             WHERE                                                
P00152                 PO.PREMISE_NO    = FS.PREMISE_NO                 
P00152             AND DY.ADDRESS_ID    = PO.ADDRESS_ID                 
P00152             AND DY.ADDR_USAGE_CD = 'I'                           
P00152        )                                                         
P00152     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR* MSQ055
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE                                                            
MFA-TR*            SESSION.CSR01250_R1 FS                                       
MFA-TR*       SET                                                               
MFA-TR*       (                                                                 
MFA-TR*            ADDRESS                                                      
MFA-TR*       ) =                                                               
MFA-TR*       (                                                                 
MFA-TR*            SELECT                                                       
MFA-TR*                 RTRIM(DY.STREET_NAME) || '&' ||                         
MFA-TR*                 RTRIM(DY.ADDRESS_OVERFLOW)                              
MFA-TR*            FROM                                                         
MFA-TR*                 CSS_ADDR_FORMATTED DY                                   
MFA-TR*                ,CSS_PREMISE        PO                                   
MFA-TR*            WHERE                                                        
MFA-TR*                FS.PREMISE_NO    = PO.PREMISE_NO                         
MFA-TR*            AND DY.ADDRESS_ID    = PO.ADDRESS_ID                         
MFA-TR*            AND DY.ADDR_USAGE_CD = 'I'                                   
MFA-TR*       )                                                                 
MFA-TR*       WHERE EXISTS                                                      
MFA-TR*       (                                                                 
MFA-TR*            SELECT                                                       
MFA-TR*                 1                                                       
MFA-TR*            FROM                                                         
MFA-TR*                 CSS_ADDR_FORMATTED DY                                   
MFA-TR*                ,CSS_PREMISE        PO                                   
MFA-TR*            WHERE                                                        
MFA-TR*                PO.PREMISE_NO    = FS.PREMISE_NO                         
MFA-TR*            AND DY.ADDRESS_ID    = PO.ADDRESS_ID                         
MFA-TR*            AND DY.ADDR_USAGE_CD = 'I'                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00152                                                                  
P00152     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00152                                                                  
P00152     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00152        NEXT SENTENCE                                             
P00152     ELSE                                                         
P00152          MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
P00152          MOVE SQLCODE              TO ABEND-SQLCODE              
P00152          MOVE '8200'               TO ACTIVE-PARAGRAPH           
P00152          MOVE 'UPDATE'             TO ABEND-FUNCTION             
P00152          MOVE SPACES               TO ABEND-SQL-PREDICATES       
P00152                                       ABEND-TABLES               
P00152          MOVE 'CSR01250_R1'        TO TABLE-1                    
P00152          MOVE 'UNFMTED'            TO TABLE-ELEMENT-1            
P00152          MOVE SPACES               TO HOSTVAR-ELEMENT-1          
P00152          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
P00152     END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      *                                                                 12700000
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00320                                                
           END-EXEC.                                                            
