       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR01153.                                          
       DATE-WRITTEN. MAY 24, 2007.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS CALLED BY THE CSR DESKTOP.                    *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL DB2 STORED PROCEDURE THAT RETRIVES    *        
      *  ORDER DETAILS BASED ON THE FILTER CRITERIA.                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  05/24/07  MN90523    SYBASE SP TO COBOL DB2 SP CONVERSION.    *        
      *  06/19/07  PA94870    FIX ISSUE: APPOINTMENT DATES ARE GETTING *        
      *                       SAME DATES-INDICATOR VAR USAGE IN INSERT *        
      *                       STATEMENT SHOULD SEND NULL VALUES BACK.  *        
C35297*  06/27/07  FMB        REPLACE CURRENT TIMESTAMP WITH DATE PLUS *        
C35297*                       ZEROS IN LATE ORDER LIST.                *        
C35434*  07/05/07  MN90523    INCLUDED WITH UR                         *        
C37261*  05/07/08  AW41078    RENAMING DCLGEN - CHANGING FROM STB TO TB*        
      *                                                                *        
C37005*  05/13/08  AW41078    ADD LOGIC FOR NEW PAYMENT REQUIRED ORDER *        
C37005*                       STATE CODE 'R'                           *        
T36933*  06/20/08  SV85244    INCREASE LENGTH OF ADDRESS, FULLNAME     *        
      *                       AND LAST NAME FIELDS.                    *        
APL495*  04/01/09  SC41135    CORRECT THE TOTAL ROW-COUNT              *        
A37342*  06/01/09  SC41135    ADDED ROWSET POSITIONING FOR PERFORMANCE *        
      *                       IMPROVEMENT                              *        
A01529*  08/03/09  VV90387    INCREASE WORK CLASS FIELD LENGTH FROM    *        
A01529*                       CHAR(2) TO CHAR(4)                       *        
A03263*  10/07/11  FMB        PREVENT S0C7 ABEND.                      *        
A05317*  06/16/16  FMB        ADD ORDER_RECVED_BY.                     *        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR01153'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR01153 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *----< CSS_ADDR_FORMATTED >                                               
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_NAME_ACCT_XREF >                                                
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_NAME >                                                          
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_ORDER_TYPE >                                                    
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_SO_DATA >                                                       
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_SO_ORDER_INST >                                                 
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_SO_UTL_CHG >                                                    
           EXEC SQL                                                             
              INCLUDE TBSOUTG                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_SO_CREW >                                                       
           EXEC SQL                                                             
              INCLUDE TBSOCREW                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_SO_UTILITY >                                                    
           EXEC SQL                                                             
              INCLUDE TBSOUTL                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_WORK_TYPE >                                                     
           EXEC SQL                                                             
              INCLUDE TBWKTYP                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_WK_CLASS_STAT >                                                 
           EXEC SQL                                                             
              INCLUDE TBWKCST                                                   
           END-EXEC.                                                            
                                                                        
A05317*---< CSS_USER_PROFILE >                                                  
A05317     EXEC SQL                                                             
A05317        INCLUDE TBUSRPRF                                                  
A05317     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *----<COMMON SYSTEM AREA >                                                
           COPY CCA00001.                                                       
                                                                        
      *----< ERROR HANDLING >                                                   
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >                   
           COPY CWS00027.                                                       
                                                                        
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                              
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                PIC X(26) VALUE                  
                                             'SESSION.CSR01153_R1'.     
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-IS-RSP-AREA-NULL     PIC X(01) VALUE 'Y'.             
           05  WS-IS-WRK-AREA-NULL     PIC X(01) VALUE 'Y'.             
           05  WS-IS-STATUS-NULL       PIC X(01) VALUE 'Y'.             
           05  WS-IS-STATE-NULL        PIC X(01) VALUE 'Y'.             
           05  WS-IS-ORD-RSN-NULL      PIC X(01) VALUE 'Y'.             
           05  WS-IS-RD-ROUTE-NULL     PIC X(01) VALUE 'Y'.             
           05  WS-IS-WRK-TYPE-NULL     PIC X(01) VALUE 'Y'.             
           05  WS-IS-CREW-ID-NULL      PIC X(01) VALUE 'Y'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
T36933     05  RS-ADDRESS                PIC X(74) VALUE SPACE.         
           05  RS-ORDER-TYPE-DESC        PIC X(15) VALUE SPACE.         
           05  RS-WORK-TYPE-DESC         PIC X(25) VALUE SPACE.         
           05  RS-CODE-UTIL-TYPE         PIC X(01) VALUE SPACE.         
           05  RS-ASSIGNED-DATETIME      PIC X(26) VALUE SPACE.         
           05  RS-STATUS-TX              PIC X(25) VALUE SPACE.         
           05  RS-ORDER-STATE-CD         PIC X(01) VALUE SPACE.         
           05  RS-BEGIN-APPT-DATE        PIC X(26) VALUE SPACE.         
           05  RS-END-APPT-DATE          PIC X(26) VALUE SPACE.         
           05  RS-DATE-PRINTED           PIC X(26) VALUE SPACE.         
           05  RS-COMPLETED-DATETIME     PIC X(26) VALUE SPACE.         
           05  RS-SERV-ORDER-NO          PIC S9(13)V COMP-3 VALUE 0.    
           05  RS-ACCOUNT-NO             PIC S9(13)V COMP-3 VALUE 0.    
T36933     05  RS-FULL-NAME              PIC X(70) VALUE SPACE.         
           05  RS-FIRST-NAME             PIC X(15) VALUE SPACE.         
           05  RS-MIDDLE-NAME            PIC X(15) VALUE SPACE.         
T36933     05  RS-LAST-NAME              PIC X(40) VALUE SPACE.         
           05  RS-NAME-FORMAT            PIC X(01) VALUE SPACE.         
           05  RS-TOTAL                  PIC S9(9) COMP VALUE 0.        
           05  RS-ORDER-TYPE-CD          PIC X(07) VALUE SPACE.         
           05  RS-COMPANY-NO             PIC X(02) VALUE SPACE.         
           05  RS-LOCAL-OFFICE           PIC X(03) VALUE SPACE.         
           05  RS-ACCOUNT-NO-PRIOR       PIC S9(13)V COMP-3 VALUE 0.    
           05  RS-PREMISE-NO             PIC S9(10)V COMP-3 VALUE 0.    
           05  RS-CUSTOMER-NO            PIC S9(10)V COMP-3 VALUE 0.    
           05  RS-ZIP-CODE               PIC X(05) VALUE SPACE.         
           05  RS-ORDER-GROUP-CD         PIC X(01) VALUE SPACE.         
           05  RS-SERV-ORDER-STATUS      PIC X(02) VALUE SPACE.         
           05  RS-DATE-RECVD             PIC X(26) VALUE SPACE.         
           05  RS-READ-ROUTE             PIC X(04) VALUE SPACE.         
A05317     05  RS-ORDER-RECVED-BY        PIC X(40) VALUE SPACE.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
T36933     05  S-ADDRESS                 PIC X(74) VALUE SPACE.         
           05  S-ORDER-TYPE-DESC         PIC X(15) VALUE SPACE.         
           05  S-WORK-TYPE-DESC          PIC X(25) VALUE SPACE.         
           05  S-CODE-UTIL-TYPE          PIC X(01) VALUE SPACE.         
           05  S-ASSIGNED-DATETIME       PIC X(26) VALUE SPACE.         
           05  S-STATUS-TX               PIC X(25) VALUE SPACE.         
           05  S-ORDER-STATE-CD          PIC X(01) VALUE SPACE.         
           05  S-BEGIN-APPT-DATE         PIC X(26) VALUE SPACE.         
           05  S-END-APPT-DATE           PIC X(26) VALUE SPACE.         
           05  S-DATE-PRINTED            PIC X(26) VALUE SPACE.         
           05  S-COMPLETED-DATETIME      PIC X(26) VALUE SPACE.         
           05  S-SERV-ORDER-NO           PIC S9(13)V COMP-3 VALUE 0.    
           05  S-ACCOUNT-NO              PIC S9(13)V COMP-3 VALUE 0.    
T36933     05  S-FULL-NAME               PIC X(70) VALUE SPACE.         
           05  S-FIRST-NAME              PIC X(15) VALUE SPACE.         
           05  S-MIDDLE-NAME             PIC X(15) VALUE SPACE.         
T36933     05  S-LAST-NAME               PIC X(40) VALUE SPACE.         
           05  S-NAME-FORMAT             PIC X(01) VALUE SPACE.         
           05  S-TOTAL                   PIC S9(9) COMP VALUE 0.        
           05  S-ORDER-TYPE-CD           PIC X(07) VALUE SPACE.         
           05  S-COMPANY-NO              PIC X(02) VALUE SPACE.         
           05  S-LOCAL-OFFICE            PIC X(03) VALUE SPACE.         
           05  S-ACCOUNT-NO-PRIOR        PIC S9(13)V COMP-3 VALUE 0.    
           05  S-PREMISE-NO              PIC S9(10)V COMP-3 VALUE 0.    
           05  S-CUSTOMER-NO             PIC S9(10)V COMP-3 VALUE 0.    
           05  S-ZIP-CODE                PIC X(05) VALUE SPACE.         
           05  S-ORDER-GROUP-CD          PIC X(01) VALUE SPACE.         
           05  S-SERV-ORDER-STATUS       PIC X(02) VALUE SPACE.         
           05  S-DATE-RECVD              PIC X(26) VALUE SPACE.         
           05  S-READ-ROUTE              PIC X(04) VALUE SPACE.         
A05317     05  S-ORDER-RECVED-BY         PIC X(40) VALUE SPACE.         
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                         
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
           05  PROGRAM-NAME              PIC X(08)   VALUE 'CSR01153'.  
           05  IV-BEGIN-APPT-DT          PIC S9(2)   USAGE BINARY.      
           05  IV-END-APPT-DT            PIC S9(2)   USAGE BINARY.      
           05  IV-COMP-DT                PIC S9(2)   USAGE BINARY.      
           05  IV-ASSGN-DT               PIC S9(2)   USAGE BINARY.      
           05  IV-PRNTD-DT               PIC S9(2)   USAGE BINARY.      
           05  IV-RECVD-DT               PIC S9(2)   USAGE BINARY.      
           05  WS-SQLSTATE               PIC X(05)   VALUE SPACES.      
           05  WS-TOTAL                  PIC S9(9)   USAGE COMP VALUE 1.
           05  WS-USER-ID                PIC X(07)   VALUE SPACE.       
           05  WS-COND-TYPE              PIC S9(9)   USAGE COMP VALUE 0.
           05  WS-VIEW-TYPE              PIC X(04)   VALUE SPACE.       
           05  WS-ORDER-TYPE             PIC S9(9)   USAGE COMP VALUE 0.
           05  WS-CODE-TRAN-TYPE         PIC X(01)   VALUE SPACE.       
           05  WS-PROCESS                PIC X(01)   VALUE SPACE.       
           05  WS-CUR-HIST               PIC X(01)   VALUE SPACE.       
           05  WS-COMPANY-NO             PIC X(02)   VALUE SPACE.       
           05  WS-LOCAL-OFFICE           PIC X(03)   VALUE SPACE.       
           05  WS-RESP-AREA-ID           PIC X(04)   VALUE SPACE.       
           05  WS-WORK-AREA-ID           PIC X(12)   VALUE SPACE.       
           05  WS-WORK-TYPE-CD           PIC X(3)    VALUE SPACE.       
           05  WS-VIEW                   PIC X(03)   VALUE SPACE.       
A01529     05  WS-CLASS                  PIC X(04)   VALUE SPACE.       
           05  WS-SO-STATUS              PIC X(02)   VALUE SPACE.       
           05  WS-STATE-TYPE             PIC S9(9)   USAGE COMP VALUE 0.
           05  WS-ORDER-TYPE-CD          PIC X(05)   VALUE SPACE.       
           05  WS-ORD-GRP-CD             PIC X(01)   VALUE SPACE.       
           05  WS-WORK-TYPE              PIC X(03)   VALUE SPACE.       
           05  WS-ASSIGNED-START-DT      PIC X(26)   VALUE SPACE.       
           05  WS-ASSIGNED-END-DT        PIC X(26)   VALUE SPACE.       
           05  WS-FROM-TS                PIC X(26).                     
           05  WS-FROM-TS-R REDEFINES    WS-FROM-TS.                    
               10  WS-FROM-DATE          PIC X(10).                     
               10  WS-FROM-TIME          PIC X(16).                     
           05  WS-TO-TS                  PIC X(26).                     
           05  WS-TO-TS-R   REDEFINES    WS-TO-TS.                      
               10  WS-TO-DATE            PIC X(10).                     
               10  WS-TO-TIME            PIC X(16).                     
           05  WS-SO-NUMBER              PIC S9(13)V COMP-3 VALUE 0.    
           05  WS-LOW-SERV-ORDER-NO      PIC S9(13)V COMP-3 VALUE 0.    
           05  WS-HIGH-SERV-ORDER-NO     PIC S9(13)V COMP-3 VALUE 0.    
           05  WS-CREW-ID                PIC X(6)    VALUE SPACES.      
           05  WS-READ-ROUTE             PIC S9(4)   USAGE COMP VALUE 0.
           05  WS-READ-ROUTE-NUM         PIC 9(4)    VALUE 0.           
           05  WS-SO-STATE-CD            PIC X(01)   VALUE SPACE.       
C35927     05  WS-CURRENT-DATE           PIC X(10) VALUE SPACES.        
C35927     05  WS-TODAYS-DATE            PIC X(26) VALUE SPACES.        
A05317     05  WS-USER-NAME              PIC X(40) VALUE SPACES.        
                                                                        
       05  WS-DATE-CCYYMMDD.                                            
           10  WS-CCYY              PIC X(04).                          
           10  WS-MM                PIC X(02).                          
           10  WS-DD                PIC X(02).                          
       05  WS-DATE-MMDDCCYY.                                            
           10  WS-MONTH             PIC X(02) VALUE SPACES.             
           10  WS-DAY               PIC X(02) VALUE SPACES.             
           10  WS-YEAR              PIC X(04) VALUE SPACES.             
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR ORDER NOS>                    
                                                                        
           EXEC SQL                                                     
              DECLARE ORD-CUR CURSOR FOR                                
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   CSS_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.SERV_ORDER_NO     = :WS-SO-NUMBER                  
              AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              ORDER BY SO.SERV_ORDER_NO                                 
                                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ORD-CUR CURSOR FOR                                        
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            CSS_SO_DATA       SO                                         
MFA-TR*           ,CSS_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.SERV_ORDER_NO     = :WS-SO-NUMBER                          
MFA-TR*       AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR LATE ORDERS>                  
                                                                        
           EXEC SQL                                                     
              DECLARE LAT-CUR CURSOR FOR                                
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   CSS_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )         
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )         
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'LAT1'                              
                AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))         
               OR ( :WS-VIEW-TYPE = 'LAT2'                              
                AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))              
               OR ( :WS-VIEW-TYPE = 'LAT3'                              
                AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )               
              )                                                         
C35927        AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )                
              AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )            
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND ( :WS-COND-TYPE = 1                                   
                  OR ( :WS-COND-TYPE     = 2                            
                   AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )     
                  OR ( :WS-COND-TYPE     = 3                            
                   AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO        
                   AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )     
              )                                                         
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE LAT-CUR CURSOR FOR                                        
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            CSS_SO_DATA       SO                                         
MFA-TR*           ,CSS_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )                 
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'LAT1'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))                 
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT2'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))                      
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT3'                                      
MFA-TR*         AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )                       
MFA-TR*       )                                                                 
MFA-TR*       AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                        
MFA-TR*       AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                    
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND ( :WS-COND-TYPE = 1                                           
MFA-TR*           OR ( :WS-COND-TYPE     = 2                                    
MFA-TR*            AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )             
MFA-TR*           OR ( :WS-COND-TYPE     = 3                                    
MFA-TR*            AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO                
MFA-TR*            AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )             
MFA-TR*       )                                                                 
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR LATE ORDERS>                  
      *--- < WITH READ ROUTE                                                    
                                                                        
           EXEC SQL                                                     
              DECLARE LAT-RR-CUR CURSOR FOR                             
              SELECT COALESCE(SU.READ_ROUTE,0)
                   , SO.ORDER_TYPE_DESC
                   , SO.WORK_TYPE_DESC
                   , SO.CODE_UTIL_TYPE
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME
                   , SO.STATUS_TX
                   , SO.ORDER_STATE_CD
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED
           , 121), ' ', '-'), ':', '.') DATE_PRINTED
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME
                   , SO.SERV_ORDER_NO
                   , SO.ACCOUNT_NO
                   , SO.ORDER_TYPE_CD
                   , SO.COMPANY_NO
                   , SO.LOCAL_OFFICE
                   , SO.ACCOUNT_NO_PRIOR
                   , SO.PREMISE_NO
                   , SO.ORDER_GROUP_CD
                   , SO.SERV_ORDER_STATUS
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED
                   , SO.MSQ057A21
                   , SO.MSQ057A22
                   , SO.ORDER_RECVED_BY FROM (               
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT                                                
                       OT.ORDER_TYPE_DESC                               
                      ,WT.WORK_TYPE_DESC                                
                      ,OI.CODE_UTIL_TYPE                                
                      ,SO.ASSIGNED_DATETIME                             
                      ,WS.STATUS_TX                                     
                      ,SO.ORDER_STATE_CD                                
                      ,SO.BEGIN_APPT_DT                                 
                      ,SO.END_APPT_DT                                   
                      ,SO.DATE_PRINTED                                  
                      ,SO.COMPLETED_DATETIME                            
                      ,SO.SERV_ORDER_NO                                 
                      ,SO.ACCOUNT_NO                                    
                      ,SO.ORDER_TYPE_CD                                 
                      ,SO.COMPANY_NO                                    
                      ,SO.LOCAL_OFFICE                                  
                      ,SO.ACCOUNT_NO_PRIOR                              
                      ,SO.PREMISE_NO                                    
                      ,OT.ORDER_GROUP_CD                                
                      ,SO.SERV_ORDER_STATUS                             
                      ,SO.DATE_RECVED                                   
                      ,0 MSQ057A21                                              
                      ,0 MSQ057A22                                              
A05317                ,SO.ORDER_RECVED_BY                               
                  FROM                                                  
                       CSS_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)               
                      ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)               
                      ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )     
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )     
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'LAT1'                          
                    AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))     
                   OR ( :WS-VIEW-TYPE = 'LAT2'                          
                    AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))          
                   OR ( :WS-VIEW-TYPE = 'LAT3'                          
                    AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )           
                  )                                                     
C35927            AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )            
                  AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )        
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND ( :WS-COND-TYPE = 1                               
                      OR ( :WS-COND-TYPE     = 2                        
                       AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO ) 
                      OR ( :WS-COND-TYPE     = 3                        
                       AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO    
                       AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO ) 
                  )                                                     
                ) SO                                                    
                LEFT OUTER JOIN                                         
                    CSS_SO_UTL_CHG SC WITH(READUNCOMMITTED)                     
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN                                           
                   CSS_SO_UTILITY SU WITH(READUNCOMMITTED)                      
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
              WHERE                                                     
                ( (    SO.READ_ROUTE         = :WS-READ-ROUTE           
                    OR SU.READ_ROUTE         = :WS-READ-ROUTE           
                    AND :WS-IS-RD-ROUTE-NULL = 'N' )                    
                    OR  :WS-IS-RD-ROUTE-NULL = 'Y'                      
                  )                                                     
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ057
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE LAT-RR-CUR CURSOR FOR                                     
MFA-TR*       SELECT SO.*, IFNULL(SU.READ_ROUTE,0) FROM (                       
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT                                                        
MFA-TR*                OT.ORDER_TYPE_DESC                                       
MFA-TR*               ,WT.WORK_TYPE_DESC                                        
MFA-TR*               ,OI.CODE_UTIL_TYPE                                        
MFA-TR*               ,SO.ASSIGNED_DATETIME                                     
MFA-TR*               ,WS.STATUS_TX                                             
MFA-TR*               ,SO.ORDER_STATE_CD                                        
MFA-TR*               ,SO.BEGIN_APPT_DT                                         
MFA-TR*               ,SO.END_APPT_DT                                           
MFA-TR*               ,SO.DATE_PRINTED                                          
MFA-TR*               ,SO.COMPLETED_DATETIME                                    
MFA-TR*               ,SO.SERV_ORDER_NO                                         
MFA-TR*               ,SO.ACCOUNT_NO                                            
MFA-TR*               ,SO.ORDER_TYPE_CD                                         
MFA-TR*               ,SO.COMPANY_NO                                            
MFA-TR*               ,SO.LOCAL_OFFICE                                          
MFA-TR*               ,SO.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,SO.PREMISE_NO                                            
MFA-TR*               ,OT.ORDER_GROUP_CD                                        
MFA-TR*               ,SO.SERV_ORDER_STATUS                                     
MFA-TR*               ,SO.DATE_RECVED                                           
MFA-TR*               ,0                                                        
MFA-TR*               ,0                                                        
MFA-TR*               ,SO.ORDER_RECVED_BY                                       
MFA-TR*           FROM                                                          
MFA-TR*                CSS_SO_DATA       SO                                     
MFA-TR*               ,CSS_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_ORDER_TYPE    OT                                     
MFA-TR*               ,CSS_WORK_TYPE     WT                                     
MFA-TR*               ,CSS_WK_CLASS_STAT WS                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )             
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'LAT1'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))             
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT2'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))                  
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT3'                                  
MFA-TR*             AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )                   
MFA-TR*           )                                                             
MFA-TR*           AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                    
MFA-TR*           AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND ( :WS-COND-TYPE = 1                                       
MFA-TR*               OR ( :WS-COND-TYPE     = 2                                
MFA-TR*                AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )         
MFA-TR*               OR ( :WS-COND-TYPE     = 3                                
MFA-TR*                AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO            
MFA-TR*                AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )         
MFA-TR*           )                                                             
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN                                                 
MFA-TR*             CSS_SO_UTL_CHG SC                                           
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN                                                   
MFA-TR*            CSS_SO_UTILITY SU                                            
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*       WHERE                                                             
MFA-TR*         ( (    SO.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             OR SU.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             AND :WS-IS-RD-ROUTE-NULL = 'N' )                            
MFA-TR*             OR  :WS-IS-RD-ROUTE-NULL = 'Y'                              
MFA-TR*           )                                                             
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR LATE ORDERS WITH CREW>        
                                                                        
           EXEC SQL                                                     
              DECLARE LAT-CW-CUR CURSOR FOR                             
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   CSS_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
                  ,CSS_SO_CREW       WM WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )         
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )         
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'LAT1'                              
                AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))         
               OR ( :WS-VIEW-TYPE = 'LAT2'                              
                AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))              
               OR ( :WS-VIEW-TYPE = 'LAT3'                              
                AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )               
              )                                                         
C35927        AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )                
              AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )            
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND WM.CREW_ID           = :WS-CREW-ID                    
              AND ( :WS-COND-TYPE = 1                                   
                  OR ( :WS-COND-TYPE     = 2                            
                   AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )     
                  OR ( :WS-COND-TYPE     = 3                            
                   AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO        
                   AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )     
              )                                                         
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE LAT-CW-CUR CURSOR FOR                                     
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            CSS_SO_DATA       SO                                         
MFA-TR*           ,CSS_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*           ,CSS_SO_CREW       WM                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )                 
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'LAT1'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))                 
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT2'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))                      
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT3'                                      
MFA-TR*         AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )                       
MFA-TR*       )                                                                 
MFA-TR*       AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                        
MFA-TR*       AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                    
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND WM.CREW_ID           = :WS-CREW-ID                            
MFA-TR*       AND ( :WS-COND-TYPE = 1                                           
MFA-TR*           OR ( :WS-COND-TYPE     = 2                                    
MFA-TR*            AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )             
MFA-TR*           OR ( :WS-COND-TYPE     = 3                                    
MFA-TR*            AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO                
MFA-TR*            AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )             
MFA-TR*       )                                                                 
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7140                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR LATE ORDERS WITH CREW>        
      *--- < AND READ ROUTE                                                     
           EXEC SQL                                                     
              DECLARE LAT-CW-RR-CUR CURSOR FOR                          
              SELECT COALESCE(SU.READ_ROUTE,0)
                   , SO.ORDER_TYPE_DESC
                   , SO.WORK_TYPE_DESC
                   , SO.CODE_UTIL_TYPE
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME
                   , SO.STATUS_TX
                   , SO.ORDER_STATE_CD
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED
           , 121), ' ', '-'), ':', '.') DATE_PRINTED
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME
                   , SO.SERV_ORDER_NO
                   , SO.ACCOUNT_NO
                   , SO.ORDER_TYPE_CD
                   , SO.COMPANY_NO
                   , SO.LOCAL_OFFICE
                   , SO.ACCOUNT_NO_PRIOR
                   , SO.PREMISE_NO
                   , SO.ORDER_GROUP_CD
                   , SO.SERV_ORDER_STATUS
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED
                   , SO.MSQ057A21
                   , SO.MSQ057A22
                   , SO.ORDER_RECVED_BY FROM (               
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT                                                
                       OT.ORDER_TYPE_DESC                               
                      ,WT.WORK_TYPE_DESC                                
                      ,OI.CODE_UTIL_TYPE                                
                      ,SO.ASSIGNED_DATETIME                             
                      ,WS.STATUS_TX                                     
                      ,SO.ORDER_STATE_CD                                
                      ,SO.BEGIN_APPT_DT                                 
                      ,SO.END_APPT_DT                                   
                      ,SO.DATE_PRINTED                                  
                      ,SO.COMPLETED_DATETIME                            
                      ,SO.SERV_ORDER_NO                                 
                      ,SO.ACCOUNT_NO                                    
                      ,SO.ORDER_TYPE_CD                                 
                      ,SO.COMPANY_NO                                    
                      ,SO.LOCAL_OFFICE                                  
                      ,SO.ACCOUNT_NO_PRIOR                              
                      ,SO.PREMISE_NO                                    
                      ,OT.ORDER_GROUP_CD                                
                      ,SO.SERV_ORDER_STATUS                             
                      ,SO.DATE_RECVED                                   
                      ,0 MSQ057A21                                              
                      ,0 MSQ057A22                                              
A05317                ,SO.ORDER_RECVED_BY                               
                  FROM                                                  
                       CSS_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)               
                      ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)               
                      ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)               
                      ,CSS_SO_CREW       WM WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )     
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )     
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'LAT1'                          
                    AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))     
                   OR ( :WS-VIEW-TYPE = 'LAT2'                          
                    AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))          
                   OR ( :WS-VIEW-TYPE = 'LAT3'                          
                    AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )           
                  )                                                     
C35927            AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )            
                  AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )        
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND WM.CREW_ID           = :WS-CREW-ID                
                  AND ( :WS-COND-TYPE = 1                               
                      OR ( :WS-COND-TYPE     = 2                        
                       AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO ) 
                      OR ( :WS-COND-TYPE     = 3                        
                       AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO    
                       AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO ) 
                  )                                                     
                ) SO                                                    
                LEFT OUTER JOIN                                         
                    CSS_SO_UTL_CHG SC WITH(READUNCOMMITTED)                     
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN                                           
                   CSS_SO_UTILITY SU WITH(READUNCOMMITTED)                      
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
              WHERE                                                     
                ( (    SO.READ_ROUTE         = :WS-READ-ROUTE           
                    OR SU.READ_ROUTE         = :WS-READ-ROUTE           
                    AND :WS-IS-RD-ROUTE-NULL = 'N' )                    
                    OR  :WS-IS-RD-ROUTE-NULL = 'Y'                      
                  )                                                     
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ057
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE LAT-CW-RR-CUR CURSOR FOR                                  
MFA-TR*       SELECT SO.*, IFNULL(SU.READ_ROUTE,0) FROM (                       
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT                                                        
MFA-TR*                OT.ORDER_TYPE_DESC                                       
MFA-TR*               ,WT.WORK_TYPE_DESC                                        
MFA-TR*               ,OI.CODE_UTIL_TYPE                                        
MFA-TR*               ,SO.ASSIGNED_DATETIME                                     
MFA-TR*               ,WS.STATUS_TX                                             
MFA-TR*               ,SO.ORDER_STATE_CD                                        
MFA-TR*               ,SO.BEGIN_APPT_DT                                         
MFA-TR*               ,SO.END_APPT_DT                                           
MFA-TR*               ,SO.DATE_PRINTED                                          
MFA-TR*               ,SO.COMPLETED_DATETIME                                    
MFA-TR*               ,SO.SERV_ORDER_NO                                         
MFA-TR*               ,SO.ACCOUNT_NO                                            
MFA-TR*               ,SO.ORDER_TYPE_CD                                         
MFA-TR*               ,SO.COMPANY_NO                                            
MFA-TR*               ,SO.LOCAL_OFFICE                                          
MFA-TR*               ,SO.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,SO.PREMISE_NO                                            
MFA-TR*               ,OT.ORDER_GROUP_CD                                        
MFA-TR*               ,SO.SERV_ORDER_STATUS                                     
MFA-TR*               ,SO.DATE_RECVED                                           
MFA-TR*               ,0                                                        
MFA-TR*               ,0                                                        
MFA-TR*               ,SO.ORDER_RECVED_BY                                       
MFA-TR*           FROM                                                          
MFA-TR*                CSS_SO_DATA       SO                                     
MFA-TR*               ,CSS_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_ORDER_TYPE    OT                                     
MFA-TR*               ,CSS_WORK_TYPE     WT                                     
MFA-TR*               ,CSS_WK_CLASS_STAT WS                                     
MFA-TR*               ,CSS_SO_CREW       WM                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )             
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'LAT1'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))             
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT2'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))                  
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT3'                                  
MFA-TR*             AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )                   
MFA-TR*           )                                                             
MFA-TR*           AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                    
MFA-TR*           AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND WM.CREW_ID           = :WS-CREW-ID                        
MFA-TR*           AND ( :WS-COND-TYPE = 1                                       
MFA-TR*               OR ( :WS-COND-TYPE     = 2                                
MFA-TR*                AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )         
MFA-TR*               OR ( :WS-COND-TYPE     = 3                                
MFA-TR*                AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO            
MFA-TR*                AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )         
MFA-TR*           )                                                             
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN                                                 
MFA-TR*             CSS_SO_UTL_CHG SC                                           
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN                                                   
MFA-TR*            CSS_SO_UTILITY SU                                            
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*       WHERE                                                             
MFA-TR*         ( (    SO.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             OR SU.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             AND :WS-IS-RD-ROUTE-NULL = 'N' )                            
MFA-TR*             OR  :WS-IS-RD-ROUTE-NULL = 'Y'                              
MFA-TR*           )                                                             
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7160                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS WITH TYP VIEW  >                  
                                                                        
           EXEC SQL                                                     
              DECLARE TYP-CUR CURSOR FOR                                
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   CSS_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'TYP1' AND                          
                    SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))      
                OR( :WS-VIEW-TYPE = 'TYP2' AND                          
                    SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))      
                OR (:WS-VIEW-TYPE = 'TYP3' AND                          
                    SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))            
              AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(:WS-FROM-TS
              )                   
              AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(:WS-TO-TS)         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))        
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))       
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))       
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))          
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))             
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND ( :WS-COND-TYPE = 1                                   
                 OR ( :WS-COND-TYPE  = 2                                
                  AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )      
                 OR ( :WS-COND-TYPE     = 3                             
                  AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO         
                  AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )      
              )                                                         
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TYP-CUR CURSOR FOR                                        
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            CSS_SO_DATA       SO                                         
MFA-TR*           ,CSS_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'TYP1' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))              
MFA-TR*         OR( :WS-VIEW-TYPE = 'TYP2' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))              
MFA-TR*         OR (:WS-VIEW-TYPE = 'TYP3' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                    
MFA-TR*       AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                           
MFA-TR*       AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                             
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))                
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))                  
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                     
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND ( :WS-COND-TYPE = 1                                           
MFA-TR*          OR ( :WS-COND-TYPE  = 2                                        
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*          OR ( :WS-COND-TYPE     = 3                                     
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO                 
MFA-TR*           AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*       )                                                                 
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR  TYP VIEW  >                  
      *--- < WITH READ ROUTE                                                    
                                                                        
           EXEC SQL                                                     
              DECLARE TYP-RR-CUR CURSOR FOR                             
              SELECT COALESCE(SU.READ_ROUTE,0)
                   , SO.ORDER_TYPE_DESC
                   , SO.WORK_TYPE_DESC
                   , SO.CODE_UTIL_TYPE
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME
                   , SO.STATUS_TX
                   , SO.ORDER_STATE_CD
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED
           , 121), ' ', '-'), ':', '.') DATE_PRINTED
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME
                   , SO.SERV_ORDER_NO
                   , SO.ACCOUNT_NO
                   , SO.ORDER_TYPE_CD
                   , SO.COMPANY_NO
                   , SO.LOCAL_OFFICE
                   , SO.ACCOUNT_NO_PRIOR
                   , SO.PREMISE_NO
                   , SO.ORDER_GROUP_CD
                   , SO.SERV_ORDER_STATUS
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED
                   , SO.MSQ057A21
                   , SO.MSQ057A22
                   , SO.ORDER_RECVED_BY FROM (               
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT                                                
                       OT.ORDER_TYPE_DESC                               
                      ,WT.WORK_TYPE_DESC                                
                      ,OI.CODE_UTIL_TYPE                                
                      ,SO.ASSIGNED_DATETIME                             
                      ,WS.STATUS_TX                                     
                      ,SO.ORDER_STATE_CD                                
                      ,SO.BEGIN_APPT_DT                                 
                      ,SO.END_APPT_DT                                   
                      ,SO.DATE_PRINTED                                  
                      ,SO.COMPLETED_DATETIME                            
                      ,SO.SERV_ORDER_NO                                 
                      ,SO.ACCOUNT_NO                                    
                      ,SO.ORDER_TYPE_CD                                 
                      ,SO.COMPANY_NO                                    
                      ,SO.LOCAL_OFFICE                                  
                      ,SO.ACCOUNT_NO_PRIOR                              
                      ,SO.PREMISE_NO                                    
                      ,OT.ORDER_GROUP_CD                                
                      ,SO.SERV_ORDER_STATUS                             
                      ,SO.DATE_RECVED                                   
                      ,0 MSQ057A21                                              
                      ,0 MSQ057A22                                              
A05317                ,SO.ORDER_RECVED_BY                               
                  FROM                                                  
                       CSS_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)               
                      ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)               
                      ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'TYP1' AND                      
                        SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))  
                    OR( :WS-VIEW-TYPE = 'TYP2' AND                      
                        SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))  
                    OR (:WS-VIEW-TYPE = 'TYP3' AND                      
                        SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))        
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )               
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              )                 
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))    
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))   
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))   
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))      
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))         
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND ( :WS-COND-TYPE = 1                               
                     OR ( :WS-COND-TYPE  = 2                            
                      AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )  
                     OR ( :WS-COND-TYPE     = 3                         
                      AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO     
                      AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )  
                  )                                                     
                ) SO                                                    
                LEFT OUTER JOIN                                         
                    CSS_SO_UTL_CHG SC WITH(READUNCOMMITTED)                     
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN                                           
                   CSS_SO_UTILITY SU WITH(READUNCOMMITTED)                      
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
              WHERE                                                     
                ( (    SO.READ_ROUTE         = :WS-READ-ROUTE           
                    OR SU.READ_ROUTE         = :WS-READ-ROUTE           
                    AND :WS-IS-RD-ROUTE-NULL = 'N' )                    
                    OR  :WS-IS-RD-ROUTE-NULL = 'Y'                      
                  )                                                     
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ057
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TYP-RR-CUR CURSOR FOR                                     
MFA-TR*       SELECT SO.*, IFNULL(SU.READ_ROUTE,0) FROM (                       
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT                                                        
MFA-TR*                OT.ORDER_TYPE_DESC                                       
MFA-TR*               ,WT.WORK_TYPE_DESC                                        
MFA-TR*               ,OI.CODE_UTIL_TYPE                                        
MFA-TR*               ,SO.ASSIGNED_DATETIME                                     
MFA-TR*               ,WS.STATUS_TX                                             
MFA-TR*               ,SO.ORDER_STATE_CD                                        
MFA-TR*               ,SO.BEGIN_APPT_DT                                         
MFA-TR*               ,SO.END_APPT_DT                                           
MFA-TR*               ,SO.DATE_PRINTED                                          
MFA-TR*               ,SO.COMPLETED_DATETIME                                    
MFA-TR*               ,SO.SERV_ORDER_NO                                         
MFA-TR*               ,SO.ACCOUNT_NO                                            
MFA-TR*               ,SO.ORDER_TYPE_CD                                         
MFA-TR*               ,SO.COMPANY_NO                                            
MFA-TR*               ,SO.LOCAL_OFFICE                                          
MFA-TR*               ,SO.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,SO.PREMISE_NO                                            
MFA-TR*               ,OT.ORDER_GROUP_CD                                        
MFA-TR*               ,SO.SERV_ORDER_STATUS                                     
MFA-TR*               ,SO.DATE_RECVED                                           
MFA-TR*               ,0                                                        
MFA-TR*               ,0                                                        
MFA-TR*               ,SO.ORDER_RECVED_BY                                       
MFA-TR*           FROM                                                          
MFA-TR*                CSS_SO_DATA       SO                                     
MFA-TR*               ,CSS_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_ORDER_TYPE    OT                                     
MFA-TR*               ,CSS_WORK_TYPE     WT                                     
MFA-TR*               ,CSS_WK_CLASS_STAT WS                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'TYP1' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))          
MFA-TR*             OR( :WS-VIEW-TYPE = 'TYP2' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))          
MFA-TR*             OR (:WS-VIEW-TYPE = 'TYP3' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                       
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                         
MFA-TR*           AND ( :WS-IS-STATE-NULL    = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATE-NULL    = 'N'                              
MFA-TR*             AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))            
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-STATUS-NULL   = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATUS-NULL   = 'N'                              
MFA-TR*             AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))              
MFA-TR*           AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                 
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                 
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND ( :WS-COND-TYPE = 1                                       
MFA-TR*              OR ( :WS-COND-TYPE  = 2                                    
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*              OR ( :WS-COND-TYPE     = 3                                 
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO             
MFA-TR*               AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*           )                                                             
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN                                                 
MFA-TR*             CSS_SO_UTL_CHG SC                                           
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN                                                   
MFA-TR*            CSS_SO_UTILITY SU                                            
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*       WHERE                                                             
MFA-TR*         ( (    SO.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             OR SU.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             AND :WS-IS-RD-ROUTE-NULL = 'N' )                            
MFA-TR*             OR  :WS-IS-RD-ROUTE-NULL = 'Y'                              
MFA-TR*           )                                                             
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7220                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR TYP VIEW                      
      *      WITH CREW                                                          
                                                                        
           EXEC SQL                                                     
              DECLARE TYP-CW-CUR CURSOR FOR                             
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   CSS_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
                  ,CSS_SO_CREW       WM WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'TYP1' AND                          
                    SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))      
                OR( :WS-VIEW-TYPE = 'TYP2' AND                          
                    SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))      
                OR (:WS-VIEW-TYPE = 'TYP3' AND                          
                    SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))            
              AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(:WS-FROM-TS
              )                   
              AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(:WS-TO-TS)         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))        
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))       
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))       
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))          
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))             
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND WM.CREW_ID           = :WS-CREW-ID                    
              AND ( :WS-COND-TYPE = 1                                   
                 OR ( :WS-COND-TYPE  = 2                                
                  AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )      
                 OR ( :WS-COND-TYPE     = 3                             
                  AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO         
                  AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )      
              )                                                         
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TYP-CW-CUR CURSOR FOR                                     
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            CSS_SO_DATA       SO                                         
MFA-TR*           ,CSS_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*           ,CSS_SO_CREW       WM                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'TYP1' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))              
MFA-TR*         OR( :WS-VIEW-TYPE = 'TYP2' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))              
MFA-TR*         OR (:WS-VIEW-TYPE = 'TYP3' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                    
MFA-TR*       AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                           
MFA-TR*       AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                             
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))                
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))                  
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                     
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND WM.CREW_ID           = :WS-CREW-ID                            
MFA-TR*       AND ( :WS-COND-TYPE = 1                                           
MFA-TR*          OR ( :WS-COND-TYPE  = 2                                        
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*          OR ( :WS-COND-TYPE     = 3                                     
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO                 
MFA-TR*           AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*       )                                                                 
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7240                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR TYP VIEW                      
      *      WITH CREW AND READ ROUTE                                           
                                                                        
           EXEC SQL                                                     
              DECLARE TYP-CW-RR-CUR CURSOR FOR                          
              SELECT COALESCE(SU.READ_ROUTE,0)
                   , SO.ORDER_TYPE_DESC
                   , SO.WORK_TYPE_DESC
                   , SO.CODE_UTIL_TYPE
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME
                   , SO.STATUS_TX
                   , SO.ORDER_STATE_CD
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED
           , 121), ' ', '-'), ':', '.') DATE_PRINTED
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME
                   , SO.SERV_ORDER_NO
                   , SO.ACCOUNT_NO
                   , SO.ORDER_TYPE_CD
                   , SO.COMPANY_NO
                   , SO.LOCAL_OFFICE
                   , SO.ACCOUNT_NO_PRIOR
                   , SO.PREMISE_NO
                   , SO.ORDER_GROUP_CD
                   , SO.SERV_ORDER_STATUS
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED
                   , SO.MSQ057A21
                   , SO.MSQ057A22
                   , SO.ORDER_RECVED_BY FROM (               
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT                                                
                       OT.ORDER_TYPE_DESC                               
                      ,WT.WORK_TYPE_DESC                                
                      ,OI.CODE_UTIL_TYPE                                
                      ,SO.ASSIGNED_DATETIME                             
                      ,WS.STATUS_TX                                     
                      ,SO.ORDER_STATE_CD                                
                      ,SO.BEGIN_APPT_DT                                 
                      ,SO.END_APPT_DT                                   
                      ,SO.DATE_PRINTED                                  
                      ,SO.COMPLETED_DATETIME                            
                      ,SO.SERV_ORDER_NO                                 
                      ,SO.ACCOUNT_NO                                    
                      ,SO.ORDER_TYPE_CD                                 
                      ,SO.COMPANY_NO                                    
                      ,SO.LOCAL_OFFICE                                  
                      ,SO.ACCOUNT_NO_PRIOR                              
                      ,SO.PREMISE_NO                                    
                      ,OT.ORDER_GROUP_CD                                
                      ,SO.SERV_ORDER_STATUS                             
                      ,SO.DATE_RECVED                                   
                      ,0 MSQ057A21                                              
                      ,0 MSQ057A22                                              
A05317                ,SO.ORDER_RECVED_BY                               
                  FROM                                                  
                       CSS_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)               
                      ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)               
                      ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)               
                      ,CSS_SO_CREW       WM WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'TYP1' AND                      
                        SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))  
                    OR( :WS-VIEW-TYPE = 'TYP2' AND                      
                        SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))  
                    OR (:WS-VIEW-TYPE = 'TYP3' AND                      
                        SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))        
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )               
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              )                 
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))    
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))   
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))   
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))      
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))         
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND WM.CREW_ID           = :WS-CREW-ID                
                  AND ( :WS-COND-TYPE = 1                               
                     OR ( :WS-COND-TYPE  = 2                            
                      AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )  
                     OR ( :WS-COND-TYPE     = 3                         
                      AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO     
                      AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )  
                  )                                                     
                ) SO                                                    
                LEFT OUTER JOIN                                         
                    CSS_SO_UTL_CHG SC WITH(READUNCOMMITTED)                     
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN                                           
                   CSS_SO_UTILITY SU WITH(READUNCOMMITTED)                      
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
              WHERE                                                     
                ( (    SO.READ_ROUTE         = :WS-READ-ROUTE           
                    OR SU.READ_ROUTE         = :WS-READ-ROUTE           
                    AND :WS-IS-RD-ROUTE-NULL = 'N' )                    
                    OR  :WS-IS-RD-ROUTE-NULL = 'Y'                      
                  )                                                     
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ057
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TYP-CW-RR-CUR CURSOR FOR                                  
MFA-TR*       SELECT SO.*, IFNULL(SU.READ_ROUTE,0) FROM (                       
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT                                                        
MFA-TR*                OT.ORDER_TYPE_DESC                                       
MFA-TR*               ,WT.WORK_TYPE_DESC                                        
MFA-TR*               ,OI.CODE_UTIL_TYPE                                        
MFA-TR*               ,SO.ASSIGNED_DATETIME                                     
MFA-TR*               ,WS.STATUS_TX                                             
MFA-TR*               ,SO.ORDER_STATE_CD                                        
MFA-TR*               ,SO.BEGIN_APPT_DT                                         
MFA-TR*               ,SO.END_APPT_DT                                           
MFA-TR*               ,SO.DATE_PRINTED                                          
MFA-TR*               ,SO.COMPLETED_DATETIME                                    
MFA-TR*               ,SO.SERV_ORDER_NO                                         
MFA-TR*               ,SO.ACCOUNT_NO                                            
MFA-TR*               ,SO.ORDER_TYPE_CD                                         
MFA-TR*               ,SO.COMPANY_NO                                            
MFA-TR*               ,SO.LOCAL_OFFICE                                          
MFA-TR*               ,SO.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,SO.PREMISE_NO                                            
MFA-TR*               ,OT.ORDER_GROUP_CD                                        
MFA-TR*               ,SO.SERV_ORDER_STATUS                                     
MFA-TR*               ,SO.DATE_RECVED                                           
MFA-TR*               ,0                                                        
MFA-TR*               ,0                                                        
MFA-TR*               ,SO.ORDER_RECVED_BY                                       
MFA-TR*           FROM                                                          
MFA-TR*                CSS_SO_DATA       SO                                     
MFA-TR*               ,CSS_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_ORDER_TYPE    OT                                     
MFA-TR*               ,CSS_WORK_TYPE     WT                                     
MFA-TR*               ,CSS_WK_CLASS_STAT WS                                     
MFA-TR*               ,CSS_SO_CREW       WM                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'TYP1' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))          
MFA-TR*             OR( :WS-VIEW-TYPE = 'TYP2' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))          
MFA-TR*             OR (:WS-VIEW-TYPE = 'TYP3' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                       
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                         
MFA-TR*           AND ( :WS-IS-STATE-NULL    = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATE-NULL    = 'N'                              
MFA-TR*             AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))            
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-STATUS-NULL   = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATUS-NULL   = 'N'                              
MFA-TR*             AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))              
MFA-TR*           AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                 
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                 
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND WM.CREW_ID           = :WS-CREW-ID                        
MFA-TR*           AND ( :WS-COND-TYPE = 1                                       
MFA-TR*              OR ( :WS-COND-TYPE  = 2                                    
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*              OR ( :WS-COND-TYPE     = 3                                 
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO             
MFA-TR*               AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*           )                                                             
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN                                                 
MFA-TR*             CSS_SO_UTL_CHG SC                                           
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN                                                   
MFA-TR*            CSS_SO_UTILITY SU                                            
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*       WHERE                                                             
MFA-TR*         ( (    SO.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             OR SU.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             AND :WS-IS-RD-ROUTE-NULL = 'N' )                            
MFA-TR*             OR  :WS-IS-RD-ROUTE-NULL = 'Y'                              
MFA-TR*           )                                                             
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7260                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR OTHER VIEWS>                  
                                                                        
           EXEC SQL                                                     
              DECLARE DTE-CUR CURSOR FOR                                
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   CSS_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'BEG'                               
                AND SO.BEGIN_APPT_DT      >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.BEGIN_APPT_DT      <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'COM'                               
                AND SO.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'PRT'                               
                AND SO.DATE_PRINTED       >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.DATE_PRINTED       <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'SCH'                               
                AND SO.ASSIGNED_DATETIME  >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.ASSIGNED_DATETIME  <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'REC'                               
                AND SO.DATE_RECVED        >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.DATE_RECVED        <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
              )                                                         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )          
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )         
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )         
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )            
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )            
            AND OT.COMPANY_NO        = SO.COMPANY_NO                    
            AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                 
            AND WT.COMPANY_NO        = SO.COMPANY_NO                    
            AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                  
            AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS             
            AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                 
              AND ( :WS-COND-TYPE = 1                                   
                 OR ( :WS-COND-TYPE = 2                                 
                  AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )      
                 OR ( :WS-COND-TYPE = 3                                 
                  AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO         
                  AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )      
              )                                                         
              ORDER BY SO.SERV_ORDER_NO                                 
                                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTE-CUR CURSOR FOR                                        
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            CSS_SO_DATA       SO                                         
MFA-TR*           ,CSS_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'BEG'                                       
MFA-TR*         AND SO.BEGIN_APPT_DT      >= :WS-FROM-TS                        
MFA-TR*         AND SO.BEGIN_APPT_DT      <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'COM'                                       
MFA-TR*         AND SO.COMPLETED_DATETIME >= :WS-FROM-TS                        
MFA-TR*         AND SO.COMPLETED_DATETIME <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'PRT'                                       
MFA-TR*         AND SO.DATE_PRINTED       >= :WS-FROM-TS                        
MFA-TR*         AND SO.DATE_PRINTED       <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'SCH'                                       
MFA-TR*         AND SO.ASSIGNED_DATETIME  >= :WS-FROM-TS                        
MFA-TR*         AND SO.ASSIGNED_DATETIME  <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'REC'                                       
MFA-TR*         AND SO.DATE_RECVED        >= :WS-FROM-TS                        
MFA-TR*         AND SO.DATE_RECVED        <= :WS-TO-TS )                        
MFA-TR*       )                                                                 
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )                  
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )                    
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                    
MFA-TR*     AND OT.COMPANY_NO        = SO.COMPANY_NO                            
MFA-TR*     AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                         
MFA-TR*     AND WT.COMPANY_NO        = SO.COMPANY_NO                            
MFA-TR*     AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                          
MFA-TR*     AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                     
MFA-TR*     AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                         
MFA-TR*       AND ( :WS-COND-TYPE = 1                                           
MFA-TR*          OR ( :WS-COND-TYPE = 2                                         
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*          OR ( :WS-COND-TYPE = 3                                         
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO                 
MFA-TR*           AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*       )                                                                 
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR OTHER VIEWS>                  
      *--- < WITH READ ROUTE                                                    
                                                                        
           EXEC SQL                                                     
              DECLARE DTE-RR-CUR CURSOR FOR                             
              SELECT COALESCE(SU.READ_ROUTE,0)
                   , SO.ORDER_TYPE_DESC
                   , SO.WORK_TYPE_DESC
                   , SO.CODE_UTIL_TYPE
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME
                   , SO.STATUS_TX
                   , SO.ORDER_STATE_CD
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED
           , 121), ' ', '-'), ':', '.') DATE_PRINTED
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME
                   , SO.SERV_ORDER_NO
                   , SO.ACCOUNT_NO
                   , SO.ORDER_TYPE_CD
                   , SO.COMPANY_NO
                   , SO.LOCAL_OFFICE
                   , SO.ACCOUNT_NO_PRIOR
                   , SO.PREMISE_NO
                   , SO.ORDER_GROUP_CD
                   , SO.SERV_ORDER_STATUS
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED
                   , SO.MSQ057A21
                   , SO.MSQ057A22
                   , SO.ORDER_RECVED_BY FROM (               
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT                                                
                       OT.ORDER_TYPE_DESC                               
                      ,WT.WORK_TYPE_DESC                                
                      ,OI.CODE_UTIL_TYPE                                
                      ,SO.ASSIGNED_DATETIME                             
                      ,WS.STATUS_TX                                     
                      ,SO.ORDER_STATE_CD                                
                      ,SO.BEGIN_APPT_DT                                 
                      ,SO.END_APPT_DT                                   
                      ,SO.DATE_PRINTED                                  
                      ,SO.COMPLETED_DATETIME                            
                      ,SO.SERV_ORDER_NO                                 
                      ,SO.ACCOUNT_NO                                    
                      ,SO.ORDER_TYPE_CD                                 
                      ,SO.COMPANY_NO                                    
                      ,SO.LOCAL_OFFICE                                  
                      ,SO.ACCOUNT_NO_PRIOR                              
                      ,SO.PREMISE_NO                                    
                      ,OT.ORDER_GROUP_CD                                
                      ,SO.SERV_ORDER_STATUS                             
                      ,SO.DATE_RECVED                                   
                      ,0 MSQ057A21                                              
                      ,0 MSQ057A22                                              
A05317                ,SO.ORDER_RECVED_BY                               
                  FROM                                                  
                       CSS_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)               
                      ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)               
                      ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'BEG'                           
                    AND SO.BEGIN_APPT_DT      >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.BEGIN_APPT_DT      <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'COM'                           
                    AND SO.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'PRT'                           
                    AND SO.DATE_PRINTED       >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.DATE_PRINTED       <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'SCH'                           
                    AND SO.ASSIGNED_DATETIME  >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.ASSIGNED_DATETIME  <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'REC'                           
                    AND SO.DATE_RECVED        >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.DATE_RECVED        <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                  )                                                     
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )      
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )     
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )     
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )        
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )        
                AND OT.COMPANY_NO        = SO.COMPANY_NO                
                AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD             
                AND WT.COMPANY_NO        = SO.COMPANY_NO                
                AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD              
                AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS         
                AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID             
                  AND ( :WS-COND-TYPE = 1                               
                     OR ( :WS-COND-TYPE = 2                             
                      AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )  
                     OR ( :WS-COND-TYPE = 3                             
                      AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO     
                      AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )  
                  )                                                     
                ) SO                                                    
                LEFT OUTER JOIN                                         
                    CSS_SO_UTL_CHG SC WITH(READUNCOMMITTED)                     
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN                                           
                   CSS_SO_UTILITY SU WITH(READUNCOMMITTED)                      
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
              WHERE                                                     
                ( (    SO.READ_ROUTE         = :WS-READ-ROUTE           
                    OR SU.READ_ROUTE         = :WS-READ-ROUTE           
                    AND :WS-IS-RD-ROUTE-NULL = 'N' )                    
                    OR  :WS-IS-RD-ROUTE-NULL = 'Y'                      
                  )                                                     
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ057
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTE-RR-CUR CURSOR FOR                                     
MFA-TR*       SELECT SO.*, IFNULL(SU.READ_ROUTE,0) FROM (                       
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT                                                        
MFA-TR*                OT.ORDER_TYPE_DESC                                       
MFA-TR*               ,WT.WORK_TYPE_DESC                                        
MFA-TR*               ,OI.CODE_UTIL_TYPE                                        
MFA-TR*               ,SO.ASSIGNED_DATETIME                                     
MFA-TR*               ,WS.STATUS_TX                                             
MFA-TR*               ,SO.ORDER_STATE_CD                                        
MFA-TR*               ,SO.BEGIN_APPT_DT                                         
MFA-TR*               ,SO.END_APPT_DT                                           
MFA-TR*               ,SO.DATE_PRINTED                                          
MFA-TR*               ,SO.COMPLETED_DATETIME                                    
MFA-TR*               ,SO.SERV_ORDER_NO                                         
MFA-TR*               ,SO.ACCOUNT_NO                                            
MFA-TR*               ,SO.ORDER_TYPE_CD                                         
MFA-TR*               ,SO.COMPANY_NO                                            
MFA-TR*               ,SO.LOCAL_OFFICE                                          
MFA-TR*               ,SO.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,SO.PREMISE_NO                                            
MFA-TR*               ,OT.ORDER_GROUP_CD                                        
MFA-TR*               ,SO.SERV_ORDER_STATUS                                     
MFA-TR*               ,SO.DATE_RECVED                                           
MFA-TR*               ,0                                                        
MFA-TR*               ,0                                                        
MFA-TR*               ,SO.ORDER_RECVED_BY                                       
MFA-TR*           FROM                                                          
MFA-TR*                CSS_SO_DATA       SO                                     
MFA-TR*               ,CSS_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_ORDER_TYPE    OT                                     
MFA-TR*               ,CSS_WORK_TYPE     WT                                     
MFA-TR*               ,CSS_WK_CLASS_STAT WS                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'BEG'                                   
MFA-TR*             AND SO.BEGIN_APPT_DT      >= :WS-FROM-TS                    
MFA-TR*             AND SO.BEGIN_APPT_DT      <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'COM'                                   
MFA-TR*             AND SO.COMPLETED_DATETIME >= :WS-FROM-TS                    
MFA-TR*             AND SO.COMPLETED_DATETIME <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'PRT'                                   
MFA-TR*             AND SO.DATE_PRINTED       >= :WS-FROM-TS                    
MFA-TR*             AND SO.DATE_PRINTED       <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'SCH'                                   
MFA-TR*             AND SO.ASSIGNED_DATETIME  >= :WS-FROM-TS                    
MFA-TR*             AND SO.ASSIGNED_DATETIME  <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'REC'                                   
MFA-TR*             AND SO.DATE_RECVED        >= :WS-FROM-TS                    
MFA-TR*             AND SO.DATE_RECVED        <= :WS-TO-TS )                    
MFA-TR*           )                                                             
MFA-TR*           AND ( :WS-IS-STATE-NULL    = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATE-NULL    = 'N'                              
MFA-TR*             AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )              
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-STATUS-NULL   = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATUS-NULL   = 'N'                              
MFA-TR*             AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )                
MFA-TR*           AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                 
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                
MFA-TR*         AND OT.COMPANY_NO        = SO.COMPANY_NO                        
MFA-TR*         AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                     
MFA-TR*         AND WT.COMPANY_NO        = SO.COMPANY_NO                        
MFA-TR*         AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                      
MFA-TR*         AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                 
MFA-TR*         AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                     
MFA-TR*           AND ( :WS-COND-TYPE = 1                                       
MFA-TR*              OR ( :WS-COND-TYPE = 2                                     
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*              OR ( :WS-COND-TYPE = 3                                     
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO             
MFA-TR*               AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*           )                                                             
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN                                                 
MFA-TR*             CSS_SO_UTL_CHG SC                                           
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN                                                   
MFA-TR*            CSS_SO_UTILITY SU                                            
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*       WHERE                                                             
MFA-TR*         ( (    SO.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             OR SU.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             AND :WS-IS-RD-ROUTE-NULL = 'N' )                            
MFA-TR*             OR  :WS-IS-RD-ROUTE-NULL = 'Y'                              
MFA-TR*           )                                                             
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7320                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR OTHER VIEWS                   
      *      WITH CREW >                                                        
                                                                        
           EXEC SQL                                                     
              DECLARE DTE-CW-CUR CURSOR FOR                             
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   CSS_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
                  ,CSS_SO_CREW       WM WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'BEG'                               
                AND SO.BEGIN_APPT_DT      >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.BEGIN_APPT_DT      <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'COM'                               
                AND SO.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'PRT'                               
                AND SO.DATE_PRINTED       >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.DATE_PRINTED       <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'SCH'                               
                AND SO.ASSIGNED_DATETIME  >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.ASSIGNED_DATETIME  <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'REC'                               
                AND SO.DATE_RECVED        >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.DATE_RECVED        <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
              )                                                         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )          
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )         
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )         
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )            
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )            
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND WM.CREW_ID           = :WS-CREW-ID                    
              AND ( :WS-COND-TYPE = 1                                   
                 OR ( :WS-COND-TYPE = 2                                 
                  AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )      
                 OR ( :WS-COND-TYPE = 3                                 
                  AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO         
                  AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )      
              )                                                         
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTE-CW-CUR CURSOR FOR                                     
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            CSS_SO_DATA       SO                                         
MFA-TR*           ,CSS_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*           ,CSS_SO_CREW       WM                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'BEG'                                       
MFA-TR*         AND SO.BEGIN_APPT_DT      >= :WS-FROM-TS                        
MFA-TR*         AND SO.BEGIN_APPT_DT      <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'COM'                                       
MFA-TR*         AND SO.COMPLETED_DATETIME >= :WS-FROM-TS                        
MFA-TR*         AND SO.COMPLETED_DATETIME <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'PRT'                                       
MFA-TR*         AND SO.DATE_PRINTED       >= :WS-FROM-TS                        
MFA-TR*         AND SO.DATE_PRINTED       <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'SCH'                                       
MFA-TR*         AND SO.ASSIGNED_DATETIME  >= :WS-FROM-TS                        
MFA-TR*         AND SO.ASSIGNED_DATETIME  <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'REC'                                       
MFA-TR*         AND SO.DATE_RECVED        >= :WS-FROM-TS                        
MFA-TR*         AND SO.DATE_RECVED        <= :WS-TO-TS )                        
MFA-TR*       )                                                                 
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )                  
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )                    
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                    
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND WM.CREW_ID           = :WS-CREW-ID                            
MFA-TR*       AND ( :WS-COND-TYPE = 1                                           
MFA-TR*          OR ( :WS-COND-TYPE = 2                                         
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*          OR ( :WS-COND-TYPE = 3                                         
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO                 
MFA-TR*           AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*       )                                                                 
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7340                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR OTHER VIEWS                   
      *      WITH CREW AND READ ROUTE>                                          
                                                                        
           EXEC SQL                                                     
              DECLARE DTE-CW-RR-CUR CURSOR FOR                          
              SELECT COALESCE(SU.READ_ROUTE,0)
                   , SO.ORDER_TYPE_DESC
                   , SO.WORK_TYPE_DESC
                   , SO.CODE_UTIL_TYPE
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME
                   , SO.STATUS_TX
                   , SO.ORDER_STATE_CD
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED
           , 121), ' ', '-'), ':', '.') DATE_PRINTED
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME
                   , SO.SERV_ORDER_NO
                   , SO.ACCOUNT_NO
                   , SO.ORDER_TYPE_CD
                   , SO.COMPANY_NO
                   , SO.LOCAL_OFFICE
                   , SO.ACCOUNT_NO_PRIOR
                   , SO.PREMISE_NO
                   , SO.ORDER_GROUP_CD
                   , SO.SERV_ORDER_STATUS
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED
                   , SO.MSQ057A21
                   , SO.MSQ057A22
                   , SO.ORDER_RECVED_BY FROM (               
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT                                                
                       OT.ORDER_TYPE_DESC                               
                      ,WT.WORK_TYPE_DESC                                
                      ,OI.CODE_UTIL_TYPE                                
                      ,SO.ASSIGNED_DATETIME                             
                      ,WS.STATUS_TX                                     
                      ,SO.ORDER_STATE_CD                                
                      ,SO.BEGIN_APPT_DT                                 
                      ,SO.END_APPT_DT                                   
                      ,SO.DATE_PRINTED                                  
                      ,SO.COMPLETED_DATETIME                            
                      ,SO.SERV_ORDER_NO                                 
                      ,SO.ACCOUNT_NO                                    
                      ,SO.ORDER_TYPE_CD                                 
                      ,SO.COMPANY_NO                                    
                      ,SO.LOCAL_OFFICE                                  
                      ,SO.ACCOUNT_NO_PRIOR                              
                      ,SO.PREMISE_NO                                    
                      ,OT.ORDER_GROUP_CD                                
                      ,SO.SERV_ORDER_STATUS                             
                      ,SO.DATE_RECVED                                   
                      ,0 MSQ057A21                                              
                      ,0 MSQ057A22                                              
A05317                ,SO.ORDER_RECVED_BY                               
                  FROM                                                  
                       CSS_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)               
                      ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)               
                      ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)               
                      ,CSS_SO_CREW       WM WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'BEG'                           
                    AND SO.BEGIN_APPT_DT      >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.BEGIN_APPT_DT      <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'COM'                           
                    AND SO.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'PRT'                           
                    AND SO.DATE_PRINTED       >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.DATE_PRINTED       <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'SCH'                           
                    AND SO.ASSIGNED_DATETIME  >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.ASSIGNED_DATETIME  <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'REC'                           
                    AND SO.DATE_RECVED        >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.DATE_RECVED        <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                  )                                                     
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )      
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )     
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )     
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )        
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )        
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND WM.CREW_ID           = :WS-CREW-ID                
                  AND ( :WS-COND-TYPE = 1                               
                     OR ( :WS-COND-TYPE = 2                             
                      AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )  
                     OR ( :WS-COND-TYPE = 3                             
                      AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO     
                      AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )  
                  )                                                     
                ) SO                                                    
                LEFT OUTER JOIN                                         
                    CSS_SO_UTL_CHG SC WITH(READUNCOMMITTED)                     
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN                                           
                   CSS_SO_UTILITY SU WITH(READUNCOMMITTED)                      
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
              WHERE                                                     
                ( (    SO.READ_ROUTE         = :WS-READ-ROUTE           
                    OR SU.READ_ROUTE         = :WS-READ-ROUTE           
                    AND :WS-IS-RD-ROUTE-NULL = 'N' )                    
                    OR  :WS-IS-RD-ROUTE-NULL = 'Y'                      
                  )                                                     
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ057
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTE-CW-RR-CUR CURSOR FOR                                  
MFA-TR*       SELECT SO.*, IFNULL(SU.READ_ROUTE,0) FROM (                       
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT                                                        
MFA-TR*                OT.ORDER_TYPE_DESC                                       
MFA-TR*               ,WT.WORK_TYPE_DESC                                        
MFA-TR*               ,OI.CODE_UTIL_TYPE                                        
MFA-TR*               ,SO.ASSIGNED_DATETIME                                     
MFA-TR*               ,WS.STATUS_TX                                             
MFA-TR*               ,SO.ORDER_STATE_CD                                        
MFA-TR*               ,SO.BEGIN_APPT_DT                                         
MFA-TR*               ,SO.END_APPT_DT                                           
MFA-TR*               ,SO.DATE_PRINTED                                          
MFA-TR*               ,SO.COMPLETED_DATETIME                                    
MFA-TR*               ,SO.SERV_ORDER_NO                                         
MFA-TR*               ,SO.ACCOUNT_NO                                            
MFA-TR*               ,SO.ORDER_TYPE_CD                                         
MFA-TR*               ,SO.COMPANY_NO                                            
MFA-TR*               ,SO.LOCAL_OFFICE                                          
MFA-TR*               ,SO.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,SO.PREMISE_NO                                            
MFA-TR*               ,OT.ORDER_GROUP_CD                                        
MFA-TR*               ,SO.SERV_ORDER_STATUS                                     
MFA-TR*               ,SO.DATE_RECVED                                           
MFA-TR*               ,0                                                        
MFA-TR*               ,0                                                        
MFA-TR*               ,SO.ORDER_RECVED_BY                                       
MFA-TR*           FROM                                                          
MFA-TR*                CSS_SO_DATA       SO                                     
MFA-TR*               ,CSS_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_ORDER_TYPE    OT                                     
MFA-TR*               ,CSS_WORK_TYPE     WT                                     
MFA-TR*               ,CSS_WK_CLASS_STAT WS                                     
MFA-TR*               ,CSS_SO_CREW       WM                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'BEG'                                   
MFA-TR*             AND SO.BEGIN_APPT_DT      >= :WS-FROM-TS                    
MFA-TR*             AND SO.BEGIN_APPT_DT      <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'COM'                                   
MFA-TR*             AND SO.COMPLETED_DATETIME >= :WS-FROM-TS                    
MFA-TR*             AND SO.COMPLETED_DATETIME <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'PRT'                                   
MFA-TR*             AND SO.DATE_PRINTED       >= :WS-FROM-TS                    
MFA-TR*             AND SO.DATE_PRINTED       <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'SCH'                                   
MFA-TR*             AND SO.ASSIGNED_DATETIME  >= :WS-FROM-TS                    
MFA-TR*             AND SO.ASSIGNED_DATETIME  <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'REC'                                   
MFA-TR*             AND SO.DATE_RECVED        >= :WS-FROM-TS                    
MFA-TR*             AND SO.DATE_RECVED        <= :WS-TO-TS )                    
MFA-TR*           )                                                             
MFA-TR*           AND ( :WS-IS-STATE-NULL    = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATE-NULL    = 'N'                              
MFA-TR*             AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )              
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-STATUS-NULL   = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATUS-NULL   = 'N'                              
MFA-TR*             AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )                
MFA-TR*           AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                 
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND WM.CREW_ID           = :WS-CREW-ID                        
MFA-TR*           AND ( :WS-COND-TYPE = 1                                       
MFA-TR*              OR ( :WS-COND-TYPE = 2                                     
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*              OR ( :WS-COND-TYPE = 3                                     
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO             
MFA-TR*               AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*           )                                                             
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN                                                 
MFA-TR*             CSS_SO_UTL_CHG SC                                           
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN                                                   
MFA-TR*            CSS_SO_UTILITY SU                                            
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*       WHERE                                                             
MFA-TR*         ( (    SO.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             OR SU.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             AND :WS-IS-RD-ROUTE-NULL = 'N' )                            
MFA-TR*             OR  :WS-IS-RD-ROUTE-NULL = 'Y'                              
MFA-TR*           )                                                             
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7360                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR ORDER NOS>                    
      *--- < FROM HISTORY                                                       
           EXEC SQL                                                     
              DECLARE ORD-HT-CUR CURSOR FOR                             
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   HST_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.SERV_ORDER_NO     = :WS-SO-NUMBER                  
              AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ORD-HT-CUR CURSOR FOR                                     
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            HST_SO_DATA       SO                                         
MFA-TR*           ,HST_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.SERV_ORDER_NO     = :WS-SO-NUMBER                          
MFA-TR*       AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7025                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR LATE ORDERS>                  
      *--- < FROM HISTORY                                                       
                                                                        
           EXEC SQL                                                     
              DECLARE LAT-HT-CUR CURSOR FOR                             
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   HST_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )         
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )         
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'LAT1'                              
                AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))         
               OR ( :WS-VIEW-TYPE = 'LAT2'                              
                AND SO.ORDER_STATE_CD IN ('A', 'H','R'))                
               OR ( :WS-VIEW-TYPE = 'LAT3'                              
                AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )               
              )                                                         
C35927        AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )                
              AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )            
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND ( :WS-COND-TYPE = 1                                   
                  OR ( :WS-COND-TYPE     = 2                            
                   AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )     
                  OR ( :WS-COND-TYPE     = 3                            
                   AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO        
                   AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )     
              )                                                         
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE LAT-HT-CUR CURSOR FOR                                     
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            HST_SO_DATA       SO                                         
MFA-TR*           ,HST_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )                 
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'LAT1'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))                 
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT2'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A', 'H','R'))                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT3'                                      
MFA-TR*         AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )                       
MFA-TR*       )                                                                 
MFA-TR*       AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                        
MFA-TR*       AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                    
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND ( :WS-COND-TYPE = 1                                           
MFA-TR*           OR ( :WS-COND-TYPE     = 2                                    
MFA-TR*            AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )             
MFA-TR*           OR ( :WS-COND-TYPE     = 3                                    
MFA-TR*            AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO                
MFA-TR*            AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )             
MFA-TR*       )                                                                 
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR LATE ORDERS>                  
      *--- < WITH READ ROUTE                                                    
      *--- < FROM HISTORY                                                       
                                                                        
           EXEC SQL                                                     
              DECLARE LAT-RR-HT-CUR CURSOR FOR                          
              SELECT COALESCE(SU.READ_ROUTE,0)
                   , SO.ORDER_TYPE_DESC
                   , SO.WORK_TYPE_DESC
                   , SO.CODE_UTIL_TYPE
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME
                   , SO.STATUS_TX
                   , SO.ORDER_STATE_CD
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED
           , 121), ' ', '-'), ':', '.') DATE_PRINTED
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME
                   , SO.SERV_ORDER_NO
                   , SO.ACCOUNT_NO
                   , SO.ORDER_TYPE_CD
                   , SO.COMPANY_NO
                   , SO.LOCAL_OFFICE
                   , SO.ACCOUNT_NO_PRIOR
                   , SO.PREMISE_NO
                   , SO.ORDER_GROUP_CD
                   , SO.SERV_ORDER_STATUS
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED
                   , SO.MSQ057A21
                   , SO.MSQ057A22
                   , SO.ORDER_RECVED_BY FROM (               
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT                                                
                       OT.ORDER_TYPE_DESC                               
                      ,WT.WORK_TYPE_DESC                                
                      ,OI.CODE_UTIL_TYPE                                
                      ,SO.ASSIGNED_DATETIME                             
                      ,WS.STATUS_TX                                     
                      ,SO.ORDER_STATE_CD                                
                      ,SO.BEGIN_APPT_DT                                 
                      ,SO.END_APPT_DT                                   
                      ,SO.DATE_PRINTED                                  
                      ,SO.COMPLETED_DATETIME                            
                      ,SO.SERV_ORDER_NO                                 
                      ,SO.ACCOUNT_NO                                    
                      ,SO.ORDER_TYPE_CD                                 
                      ,SO.COMPANY_NO                                    
                      ,SO.LOCAL_OFFICE                                  
                      ,SO.ACCOUNT_NO_PRIOR                              
                      ,SO.PREMISE_NO                                    
                      ,OT.ORDER_GROUP_CD                                
                      ,SO.SERV_ORDER_STATUS                             
                      ,SO.DATE_RECVED                                   
                      ,0 MSQ057A21                                              
                      ,0 MSQ057A22                                              
A05317                ,SO.ORDER_RECVED_BY                               
                  FROM                                                  
                       HST_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)               
                      ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)               
                      ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )     
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )     
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'LAT1'                          
                    AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))     
                   OR ( :WS-VIEW-TYPE = 'LAT2'                          
                    AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))          
                   OR ( :WS-VIEW-TYPE = 'LAT3'                          
                    AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )           
                  )                                                     
C35927            AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )            
                  AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )        
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND ( :WS-COND-TYPE = 1                               
                      OR ( :WS-COND-TYPE     = 2                        
                       AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO ) 
                      OR ( :WS-COND-TYPE     = 3                        
                       AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO    
                       AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO ) 
                  )                                                     
                ) SO                                                    
                LEFT OUTER JOIN                                         
                    HST_SO_UTL_CHG SC WITH(READUNCOMMITTED)                     
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN                                           
                   HST_SO_UTILITY SU WITH(READUNCOMMITTED)                      
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
              WHERE                                                     
                ( (    SO.READ_ROUTE         = :WS-READ-ROUTE           
                    OR SU.READ_ROUTE         = :WS-READ-ROUTE           
                    AND :WS-IS-RD-ROUTE-NULL = 'N' )                    
                    OR  :WS-IS-RD-ROUTE-NULL = 'Y'                      
                  )                                                     
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ057
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE LAT-RR-HT-CUR CURSOR FOR                                  
MFA-TR*       SELECT SO.*, IFNULL(SU.READ_ROUTE,0) FROM (                       
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT                                                        
MFA-TR*                OT.ORDER_TYPE_DESC                                       
MFA-TR*               ,WT.WORK_TYPE_DESC                                        
MFA-TR*               ,OI.CODE_UTIL_TYPE                                        
MFA-TR*               ,SO.ASSIGNED_DATETIME                                     
MFA-TR*               ,WS.STATUS_TX                                             
MFA-TR*               ,SO.ORDER_STATE_CD                                        
MFA-TR*               ,SO.BEGIN_APPT_DT                                         
MFA-TR*               ,SO.END_APPT_DT                                           
MFA-TR*               ,SO.DATE_PRINTED                                          
MFA-TR*               ,SO.COMPLETED_DATETIME                                    
MFA-TR*               ,SO.SERV_ORDER_NO                                         
MFA-TR*               ,SO.ACCOUNT_NO                                            
MFA-TR*               ,SO.ORDER_TYPE_CD                                         
MFA-TR*               ,SO.COMPANY_NO                                            
MFA-TR*               ,SO.LOCAL_OFFICE                                          
MFA-TR*               ,SO.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,SO.PREMISE_NO                                            
MFA-TR*               ,OT.ORDER_GROUP_CD                                        
MFA-TR*               ,SO.SERV_ORDER_STATUS                                     
MFA-TR*               ,SO.DATE_RECVED                                           
MFA-TR*               ,0                                                        
MFA-TR*               ,0                                                        
MFA-TR*               ,SO.ORDER_RECVED_BY                                       
MFA-TR*           FROM                                                          
MFA-TR*                HST_SO_DATA       SO                                     
MFA-TR*               ,HST_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_ORDER_TYPE    OT                                     
MFA-TR*               ,CSS_WORK_TYPE     WT                                     
MFA-TR*               ,CSS_WK_CLASS_STAT WS                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )             
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'LAT1'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))             
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT2'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))                  
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT3'                                  
MFA-TR*             AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )                   
MFA-TR*           )                                                             
MFA-TR*           AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                    
MFA-TR*           AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND ( :WS-COND-TYPE = 1                                       
MFA-TR*               OR ( :WS-COND-TYPE     = 2                                
MFA-TR*                AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )         
MFA-TR*               OR ( :WS-COND-TYPE     = 3                                
MFA-TR*                AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO            
MFA-TR*                AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )         
MFA-TR*           )                                                             
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN                                                 
MFA-TR*             HST_SO_UTL_CHG SC                                           
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN                                                   
MFA-TR*            HST_SO_UTILITY SU                                            
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*       WHERE                                                             
MFA-TR*         ( (    SO.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             OR SU.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             AND :WS-IS-RD-ROUTE-NULL = 'N' )                            
MFA-TR*             OR  :WS-IS-RD-ROUTE-NULL = 'Y'                              
MFA-TR*           )                                                             
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7130                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR LATE ORDERS WITH CREW>        
      *--- < FROM HISTORY                                                       
                                                                        
           EXEC SQL                                                     
              DECLARE LAT-CW-HT-CUR CURSOR FOR                          
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   HST_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
                  ,HST_SO_CREW       WM WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )         
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )         
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'LAT1'                              
                AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))         
               OR ( :WS-VIEW-TYPE = 'LAT2'                              
                AND SO.ORDER_STATE_CD IN ('A', 'H','R'))                
               OR ( :WS-VIEW-TYPE = 'LAT3'                              
                AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )               
              )                                                         
C35927        AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )                
              AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )            
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND WM.CREW_ID           = :WS-CREW-ID                    
              AND ( :WS-COND-TYPE = 1                                   
                  OR ( :WS-COND-TYPE     = 2                            
                   AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )     
                  OR ( :WS-COND-TYPE     = 3                            
                   AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO        
                   AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )     
              )                                                         
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE LAT-CW-HT-CUR CURSOR FOR                                  
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            HST_SO_DATA       SO                                         
MFA-TR*           ,HST_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*           ,HST_SO_CREW       WM                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )                 
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'LAT1'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))                 
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT2'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A', 'H','R'))                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT3'                                      
MFA-TR*         AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )                       
MFA-TR*       )                                                                 
MFA-TR*       AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                        
MFA-TR*       AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                    
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND WM.CREW_ID           = :WS-CREW-ID                            
MFA-TR*       AND ( :WS-COND-TYPE = 1                                           
MFA-TR*           OR ( :WS-COND-TYPE     = 2                                    
MFA-TR*            AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )             
MFA-TR*           OR ( :WS-COND-TYPE     = 3                                    
MFA-TR*            AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO                
MFA-TR*            AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )             
MFA-TR*       )                                                                 
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR LATE ORDERS WITH CREW>        
      *--- < AND READ ROUTE                                                     
      *--- < FROM HISTORY                                                       
           EXEC SQL                                                     
              DECLARE LAT-CW-RR-HT-CUR CURSOR FOR                       
              SELECT COALESCE(SU.READ_ROUTE,0)
                   , SO.ORDER_TYPE_DESC
                   , SO.WORK_TYPE_DESC
                   , SO.CODE_UTIL_TYPE
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME
                   , SO.STATUS_TX
                   , SO.ORDER_STATE_CD
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED
           , 121), ' ', '-'), ':', '.') DATE_PRINTED
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME
                   , SO.SERV_ORDER_NO
                   , SO.ACCOUNT_NO
                   , SO.ORDER_TYPE_CD
                   , SO.COMPANY_NO
                   , SO.LOCAL_OFFICE
                   , SO.ACCOUNT_NO_PRIOR
                   , SO.PREMISE_NO
                   , SO.ORDER_GROUP_CD
                   , SO.SERV_ORDER_STATUS
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED
                   , SO.MSQ057A21
                   , SO.MSQ057A22
                   , SO.ORDER_RECVED_BY FROM (               
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT                                                
                       OT.ORDER_TYPE_DESC                               
                      ,WT.WORK_TYPE_DESC                                
                      ,OI.CODE_UTIL_TYPE                                
                      ,SO.ASSIGNED_DATETIME                             
                      ,WS.STATUS_TX                                     
                      ,SO.ORDER_STATE_CD                                
                      ,SO.BEGIN_APPT_DT                                 
                      ,SO.END_APPT_DT                                   
                      ,SO.DATE_PRINTED                                  
                      ,SO.COMPLETED_DATETIME                            
                      ,SO.SERV_ORDER_NO                                 
                      ,SO.ACCOUNT_NO                                    
                      ,SO.ORDER_TYPE_CD                                 
                      ,SO.COMPANY_NO                                    
                      ,SO.LOCAL_OFFICE                                  
                      ,SO.ACCOUNT_NO_PRIOR                              
                      ,SO.PREMISE_NO                                    
                      ,OT.ORDER_GROUP_CD                                
                      ,SO.SERV_ORDER_STATUS                             
                      ,SO.DATE_RECVED                                   
                      ,0 MSQ057A21                                              
                      ,0 MSQ057A22                                              
A05317                ,SO.ORDER_RECVED_BY                               
                  FROM                                                  
                       HST_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)               
                      ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)               
                      ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)               
                      ,HST_SO_CREW       WM WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )     
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )     
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'LAT1'                          
                    AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))     
                   OR ( :WS-VIEW-TYPE = 'LAT2'                          
                    AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))          
                   OR ( :WS-VIEW-TYPE = 'LAT3'                          
                    AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )           
                  )                                                     
C35927            AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )            
                  AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )        
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND WM.CREW_ID           = :WS-CREW-ID                
                  AND ( :WS-COND-TYPE = 1                               
                      OR ( :WS-COND-TYPE     = 2                        
                       AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO ) 
                      OR ( :WS-COND-TYPE     = 3                        
                       AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO    
                       AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO ) 
                  )                                                     
                ) SO                                                    
                LEFT OUTER JOIN                                         
                    HST_SO_UTL_CHG SC WITH(READUNCOMMITTED)                     
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN                                           
                   HST_SO_UTILITY SU WITH(READUNCOMMITTED)                      
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
              WHERE                                                     
                ( (    SO.READ_ROUTE         = :WS-READ-ROUTE           
                    OR SU.READ_ROUTE         = :WS-READ-ROUTE           
                    AND :WS-IS-RD-ROUTE-NULL = 'N' )                    
                    OR  :WS-IS-RD-ROUTE-NULL = 'Y'                      
                  )                                                     
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ057
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE LAT-CW-RR-HT-CUR CURSOR FOR                               
MFA-TR*       SELECT SO.*, IFNULL(SU.READ_ROUTE,0) FROM (                       
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT                                                        
MFA-TR*                OT.ORDER_TYPE_DESC                                       
MFA-TR*               ,WT.WORK_TYPE_DESC                                        
MFA-TR*               ,OI.CODE_UTIL_TYPE                                        
MFA-TR*               ,SO.ASSIGNED_DATETIME                                     
MFA-TR*               ,WS.STATUS_TX                                             
MFA-TR*               ,SO.ORDER_STATE_CD                                        
MFA-TR*               ,SO.BEGIN_APPT_DT                                         
MFA-TR*               ,SO.END_APPT_DT                                           
MFA-TR*               ,SO.DATE_PRINTED                                          
MFA-TR*               ,SO.COMPLETED_DATETIME                                    
MFA-TR*               ,SO.SERV_ORDER_NO                                         
MFA-TR*               ,SO.ACCOUNT_NO                                            
MFA-TR*               ,SO.ORDER_TYPE_CD                                         
MFA-TR*               ,SO.COMPANY_NO                                            
MFA-TR*               ,SO.LOCAL_OFFICE                                          
MFA-TR*               ,SO.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,SO.PREMISE_NO                                            
MFA-TR*               ,OT.ORDER_GROUP_CD                                        
MFA-TR*               ,SO.SERV_ORDER_STATUS                                     
MFA-TR*               ,SO.DATE_RECVED                                           
MFA-TR*               ,0                                                        
MFA-TR*               ,0                                                        
MFA-TR*               ,SO.ORDER_RECVED_BY                                       
MFA-TR*           FROM                                                          
MFA-TR*                HST_SO_DATA       SO                                     
MFA-TR*               ,HST_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_ORDER_TYPE    OT                                     
MFA-TR*               ,CSS_WORK_TYPE     WT                                     
MFA-TR*               ,CSS_WK_CLASS_STAT WS                                     
MFA-TR*               ,HST_SO_CREW       WM                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )             
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'LAT1'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))             
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT2'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))                  
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT3'                                  
MFA-TR*             AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD )                   
MFA-TR*           )                                                             
MFA-TR*           AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                    
MFA-TR*           AND OI.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND WM.CREW_ID           = :WS-CREW-ID                        
MFA-TR*           AND ( :WS-COND-TYPE = 1                                       
MFA-TR*               OR ( :WS-COND-TYPE     = 2                                
MFA-TR*                AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )         
MFA-TR*               OR ( :WS-COND-TYPE     = 3                                
MFA-TR*                AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO            
MFA-TR*                AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )         
MFA-TR*           )                                                             
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN                                                 
MFA-TR*             HST_SO_UTL_CHG SC                                           
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN                                                   
MFA-TR*            HST_SO_UTILITY SU                                            
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*       WHERE                                                             
MFA-TR*         ( (    SO.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             OR SU.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             AND :WS-IS-RD-ROUTE-NULL = 'N' )                            
MFA-TR*             OR  :WS-IS-RD-ROUTE-NULL = 'Y'                              
MFA-TR*           )                                                             
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7170                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS WITH TYP VIEW  >                  
      *--- < FROM HISTORY                                                       
                                                                        
           EXEC SQL                                                     
              DECLARE TYP-HT-CUR CURSOR FOR                             
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   HST_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'TYP1' AND                          
                    SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))      
                OR( :WS-VIEW-TYPE = 'TYP2' AND                          
                    SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))      
                OR (:WS-VIEW-TYPE = 'TYP3' AND                          
                    SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))            
              AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(:WS-FROM-TS
              )                   
              AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(:WS-TO-TS)         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))        
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))       
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))       
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))          
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))             
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND ( :WS-COND-TYPE = 1                                   
                 OR ( :WS-COND-TYPE  = 2                                
                  AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )      
                 OR ( :WS-COND-TYPE     = 3                             
                  AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO         
                  AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )      
              )                                                         
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TYP-HT-CUR CURSOR FOR                                     
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            HST_SO_DATA       SO                                         
MFA-TR*           ,HST_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'TYP1' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))              
MFA-TR*         OR( :WS-VIEW-TYPE = 'TYP2' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))              
MFA-TR*         OR (:WS-VIEW-TYPE = 'TYP3' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                    
MFA-TR*       AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                           
MFA-TR*       AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                             
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))                
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))                  
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                     
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND ( :WS-COND-TYPE = 1                                           
MFA-TR*          OR ( :WS-COND-TYPE  = 2                                        
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*          OR ( :WS-COND-TYPE     = 3                                     
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO                 
MFA-TR*           AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*       )                                                                 
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7210                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR  TYP VIEW  >                  
      *--- < WITH READ ROUTE                                                    
      *--- < FROM HISTORY                                                       
                                                                        
           EXEC SQL                                                     
              DECLARE TYP-RR-HT-CUR CURSOR FOR                          
              SELECT COALESCE(SU.READ_ROUTE,0)
                   , SO.ORDER_TYPE_DESC
                   , SO.WORK_TYPE_DESC
                   , SO.CODE_UTIL_TYPE
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME
                   , SO.STATUS_TX
                   , SO.ORDER_STATE_CD
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED
           , 121), ' ', '-'), ':', '.') DATE_PRINTED
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME
                   , SO.SERV_ORDER_NO
                   , SO.ACCOUNT_NO
                   , SO.ORDER_TYPE_CD
                   , SO.COMPANY_NO
                   , SO.LOCAL_OFFICE
                   , SO.ACCOUNT_NO_PRIOR
                   , SO.PREMISE_NO
                   , SO.ORDER_GROUP_CD
                   , SO.SERV_ORDER_STATUS
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED
                   , SO.MSQ057A21
                   , SO.MSQ057A22
                   , SO.ORDER_RECVED_BY FROM (               
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT                                                
                       OT.ORDER_TYPE_DESC                               
                      ,WT.WORK_TYPE_DESC                                
                      ,OI.CODE_UTIL_TYPE                                
                      ,SO.ASSIGNED_DATETIME                             
                      ,WS.STATUS_TX                                     
                      ,SO.ORDER_STATE_CD                                
                      ,SO.BEGIN_APPT_DT                                 
                      ,SO.END_APPT_DT                                   
                      ,SO.DATE_PRINTED                                  
                      ,SO.COMPLETED_DATETIME                            
                      ,SO.SERV_ORDER_NO                                 
                      ,SO.ACCOUNT_NO                                    
                      ,SO.ORDER_TYPE_CD                                 
                      ,SO.COMPANY_NO                                    
                      ,SO.LOCAL_OFFICE                                  
                      ,SO.ACCOUNT_NO_PRIOR                              
                      ,SO.PREMISE_NO                                    
                      ,OT.ORDER_GROUP_CD                                
                      ,SO.SERV_ORDER_STATUS                             
                      ,SO.DATE_RECVED                                   
                      ,0 MSQ057A21                                              
                      ,0 MSQ057A22                                              
A05317                ,SO.ORDER_RECVED_BY                               
                  FROM                                                  
                       HST_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)               
                      ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)               
                      ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'TYP1' AND                      
                        SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))  
                    OR( :WS-VIEW-TYPE = 'TYP2' AND                      
                        SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))  
                    OR (:WS-VIEW-TYPE = 'TYP3' AND                      
                        SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))        
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )               
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              )                 
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))    
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))   
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))   
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))      
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))         
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND ( :WS-COND-TYPE = 1                               
                     OR ( :WS-COND-TYPE  = 2                            
                      AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )  
                     OR ( :WS-COND-TYPE     = 3                         
                      AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO     
                      AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )  
                  )                                                     
                ) SO                                                    
                LEFT OUTER JOIN                                         
                    HST_SO_UTL_CHG SC WITH(READUNCOMMITTED)                     
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN                                           
                   HST_SO_UTILITY SU WITH(READUNCOMMITTED)                      
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
              WHERE                                                     
                ( (    SO.READ_ROUTE         = :WS-READ-ROUTE           
                    OR SU.READ_ROUTE         = :WS-READ-ROUTE           
                    AND :WS-IS-RD-ROUTE-NULL = 'N' )                    
                    OR  :WS-IS-RD-ROUTE-NULL = 'Y'                      
                  )                                                     
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ057
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TYP-RR-HT-CUR CURSOR FOR                                  
MFA-TR*       SELECT SO.*, IFNULL(SU.READ_ROUTE,0) FROM (                       
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT                                                        
MFA-TR*                OT.ORDER_TYPE_DESC                                       
MFA-TR*               ,WT.WORK_TYPE_DESC                                        
MFA-TR*               ,OI.CODE_UTIL_TYPE                                        
MFA-TR*               ,SO.ASSIGNED_DATETIME                                     
MFA-TR*               ,WS.STATUS_TX                                             
MFA-TR*               ,SO.ORDER_STATE_CD                                        
MFA-TR*               ,SO.BEGIN_APPT_DT                                         
MFA-TR*               ,SO.END_APPT_DT                                           
MFA-TR*               ,SO.DATE_PRINTED                                          
MFA-TR*               ,SO.COMPLETED_DATETIME                                    
MFA-TR*               ,SO.SERV_ORDER_NO                                         
MFA-TR*               ,SO.ACCOUNT_NO                                            
MFA-TR*               ,SO.ORDER_TYPE_CD                                         
MFA-TR*               ,SO.COMPANY_NO                                            
MFA-TR*               ,SO.LOCAL_OFFICE                                          
MFA-TR*               ,SO.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,SO.PREMISE_NO                                            
MFA-TR*               ,OT.ORDER_GROUP_CD                                        
MFA-TR*               ,SO.SERV_ORDER_STATUS                                     
MFA-TR*               ,SO.DATE_RECVED                                           
MFA-TR*               ,0                                                        
MFA-TR*               ,0                                                        
MFA-TR*               ,SO.ORDER_RECVED_BY                                       
MFA-TR*           FROM                                                          
MFA-TR*                HST_SO_DATA       SO                                     
MFA-TR*               ,HST_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_ORDER_TYPE    OT                                     
MFA-TR*               ,CSS_WORK_TYPE     WT                                     
MFA-TR*               ,CSS_WK_CLASS_STAT WS                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'TYP1' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))          
MFA-TR*             OR( :WS-VIEW-TYPE = 'TYP2' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))          
MFA-TR*             OR (:WS-VIEW-TYPE = 'TYP3' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                       
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                         
MFA-TR*           AND ( :WS-IS-STATE-NULL    = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATE-NULL    = 'N'                              
MFA-TR*             AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))            
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-STATUS-NULL   = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATUS-NULL   = 'N'                              
MFA-TR*             AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))              
MFA-TR*           AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                 
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                 
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND ( :WS-COND-TYPE = 1                                       
MFA-TR*              OR ( :WS-COND-TYPE  = 2                                    
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*              OR ( :WS-COND-TYPE     = 3                                 
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO             
MFA-TR*               AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*           )                                                             
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN                                                 
MFA-TR*             HST_SO_UTL_CHG SC                                           
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN                                                   
MFA-TR*            HST_SO_UTILITY SU                                            
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*       WHERE                                                             
MFA-TR*         ( (    SO.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             OR SU.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             AND :WS-IS-RD-ROUTE-NULL = 'N' )                            
MFA-TR*             OR  :WS-IS-RD-ROUTE-NULL = 'Y'                              
MFA-TR*           )                                                             
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7230                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR TYP VIEW                      
      *      WITH CREW                                                          
      *--- < FROM HISTORY                                                       
                                                                        
           EXEC SQL                                                     
              DECLARE TYP-CW-HT-CUR CURSOR FOR                          
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   HST_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
                  ,HST_SO_CREW       WM WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'TYP1' AND                          
                    SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))      
                OR( :WS-VIEW-TYPE = 'TYP2' AND                          
                    SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))      
                OR (:WS-VIEW-TYPE = 'TYP3' AND                          
                    SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))            
              AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(:WS-FROM-TS
              )                   
              AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(:WS-TO-TS)         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))        
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))       
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))       
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))          
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))             
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND WM.CREW_ID           = :WS-CREW-ID                    
              AND ( :WS-COND-TYPE = 1                                   
                 OR ( :WS-COND-TYPE  = 2                                
                  AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )      
                 OR ( :WS-COND-TYPE     = 3                             
                  AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO         
                  AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )      
              )                                                         
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TYP-CW-HT-CUR CURSOR FOR                                  
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            HST_SO_DATA       SO                                         
MFA-TR*           ,HST_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*           ,HST_SO_CREW       WM                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'TYP1' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))              
MFA-TR*         OR( :WS-VIEW-TYPE = 'TYP2' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))              
MFA-TR*         OR (:WS-VIEW-TYPE = 'TYP3' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                    
MFA-TR*       AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                           
MFA-TR*       AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                             
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))                
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))                  
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                     
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND WM.CREW_ID           = :WS-CREW-ID                            
MFA-TR*       AND ( :WS-COND-TYPE = 1                                           
MFA-TR*          OR ( :WS-COND-TYPE  = 2                                        
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*          OR ( :WS-COND-TYPE     = 3                                     
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO                 
MFA-TR*           AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*       )                                                                 
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR TYP VIEW                      
      *      WITH CREW AND READ ROUTE                                           
      *--- < FROM HISTORY                                                       
                                                                        
           EXEC SQL                                                     
              DECLARE TYP-CW-RR-HT-CUR CURSOR FOR                       
              SELECT COALESCE(SU.READ_ROUTE,0)
                   , SO.ORDER_TYPE_DESC
                   , SO.WORK_TYPE_DESC
                   , SO.CODE_UTIL_TYPE
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME
                   , SO.STATUS_TX
                   , SO.ORDER_STATE_CD
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED
           , 121), ' ', '-'), ':', '.') DATE_PRINTED
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME
                   , SO.SERV_ORDER_NO
                   , SO.ACCOUNT_NO
                   , SO.ORDER_TYPE_CD
                   , SO.COMPANY_NO
                   , SO.LOCAL_OFFICE
                   , SO.ACCOUNT_NO_PRIOR
                   , SO.PREMISE_NO
                   , SO.ORDER_GROUP_CD
                   , SO.SERV_ORDER_STATUS
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED
                   , SO.MSQ057A21
                   , SO.MSQ057A22
                   , SO.ORDER_RECVED_BY FROM (               
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT                                                
                       OT.ORDER_TYPE_DESC                               
                      ,WT.WORK_TYPE_DESC                                
                      ,OI.CODE_UTIL_TYPE                                
                      ,SO.ASSIGNED_DATETIME                             
                      ,WS.STATUS_TX                                     
                      ,SO.ORDER_STATE_CD                                
                      ,SO.BEGIN_APPT_DT                                 
                      ,SO.END_APPT_DT                                   
                      ,SO.DATE_PRINTED                                  
                      ,SO.COMPLETED_DATETIME                            
                      ,SO.SERV_ORDER_NO                                 
                      ,SO.ACCOUNT_NO                                    
                      ,SO.ORDER_TYPE_CD                                 
                      ,SO.COMPANY_NO                                    
                      ,SO.LOCAL_OFFICE                                  
                      ,SO.ACCOUNT_NO_PRIOR                              
                      ,SO.PREMISE_NO                                    
                      ,OT.ORDER_GROUP_CD                                
                      ,SO.SERV_ORDER_STATUS                             
                      ,SO.DATE_RECVED                                   
                      ,0 MSQ057A21                                              
                      ,0 MSQ057A22                                              
A05317                ,SO.ORDER_RECVED_BY                               
                  FROM                                                  
                       HST_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)               
                      ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)               
                      ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)               
                      ,HST_SO_CREW       WM WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'TYP1' AND                      
                        SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))  
                    OR( :WS-VIEW-TYPE = 'TYP2' AND                      
                        SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))  
                    OR (:WS-VIEW-TYPE = 'TYP3' AND                      
                        SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))        
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )               
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              )                 
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))    
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))   
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))   
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))      
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))         
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND WM.CREW_ID           = :WS-CREW-ID                
                  AND ( :WS-COND-TYPE = 1                               
                     OR ( :WS-COND-TYPE  = 2                            
                      AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )  
                     OR ( :WS-COND-TYPE     = 3                         
                      AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO     
                      AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )  
                  )                                                     
                ) SO                                                    
                LEFT OUTER JOIN                                         
                    HST_SO_UTL_CHG SC WITH(READUNCOMMITTED)                     
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN                                           
                   HST_SO_UTILITY SU WITH(READUNCOMMITTED)                      
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
              WHERE                                                     
                ( (    SO.READ_ROUTE         = :WS-READ-ROUTE           
                    OR SU.READ_ROUTE         = :WS-READ-ROUTE           
                    AND :WS-IS-RD-ROUTE-NULL = 'N' )                    
                    OR  :WS-IS-RD-ROUTE-NULL = 'Y'                      
                  )                                                     
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ057
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TYP-CW-RR-HT-CUR CURSOR FOR                               
MFA-TR*       SELECT SO.*, IFNULL(SU.READ_ROUTE,0) FROM (                       
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT                                                        
MFA-TR*                OT.ORDER_TYPE_DESC                                       
MFA-TR*               ,WT.WORK_TYPE_DESC                                        
MFA-TR*               ,OI.CODE_UTIL_TYPE                                        
MFA-TR*               ,SO.ASSIGNED_DATETIME                                     
MFA-TR*               ,WS.STATUS_TX                                             
MFA-TR*               ,SO.ORDER_STATE_CD                                        
MFA-TR*               ,SO.BEGIN_APPT_DT                                         
MFA-TR*               ,SO.END_APPT_DT                                           
MFA-TR*               ,SO.DATE_PRINTED                                          
MFA-TR*               ,SO.COMPLETED_DATETIME                                    
MFA-TR*               ,SO.SERV_ORDER_NO                                         
MFA-TR*               ,SO.ACCOUNT_NO                                            
MFA-TR*               ,SO.ORDER_TYPE_CD                                         
MFA-TR*               ,SO.COMPANY_NO                                            
MFA-TR*               ,SO.LOCAL_OFFICE                                          
MFA-TR*               ,SO.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,SO.PREMISE_NO                                            
MFA-TR*               ,OT.ORDER_GROUP_CD                                        
MFA-TR*               ,SO.SERV_ORDER_STATUS                                     
MFA-TR*               ,SO.DATE_RECVED                                           
MFA-TR*               ,0                                                        
MFA-TR*               ,0                                                        
MFA-TR*               ,SO.ORDER_RECVED_BY                                       
MFA-TR*           FROM                                                          
MFA-TR*                HST_SO_DATA       SO                                     
MFA-TR*               ,HST_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_ORDER_TYPE    OT                                     
MFA-TR*               ,CSS_WORK_TYPE     WT                                     
MFA-TR*               ,CSS_WK_CLASS_STAT WS                                     
MFA-TR*               ,HST_SO_CREW       WM                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'TYP1' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))          
MFA-TR*             OR( :WS-VIEW-TYPE = 'TYP2' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))          
MFA-TR*             OR (:WS-VIEW-TYPE = 'TYP3' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                       
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                         
MFA-TR*           AND ( :WS-IS-STATE-NULL    = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATE-NULL    = 'N'                              
MFA-TR*             AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))            
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-STATUS-NULL   = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATUS-NULL   = 'N'                              
MFA-TR*             AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))              
MFA-TR*           AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                 
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                 
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND WM.CREW_ID           = :WS-CREW-ID                        
MFA-TR*           AND ( :WS-COND-TYPE = 1                                       
MFA-TR*              OR ( :WS-COND-TYPE  = 2                                    
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*              OR ( :WS-COND-TYPE     = 3                                 
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO             
MFA-TR*               AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*           )                                                             
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN                                                 
MFA-TR*             HST_SO_UTL_CHG SC                                           
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN                                                   
MFA-TR*            HST_SO_UTILITY SU                                            
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*       WHERE                                                             
MFA-TR*         ( (    SO.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             OR SU.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             AND :WS-IS-RD-ROUTE-NULL = 'N' )                            
MFA-TR*             OR  :WS-IS-RD-ROUTE-NULL = 'Y'                              
MFA-TR*           )                                                             
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7270                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR OTHER VIEWS>                  
      *--- < FROM HISTORY                                                       
                                                                        
           EXEC SQL                                                     
              DECLARE DTE-HT-CUR CURSOR FOR                             
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   HST_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'BEG'                               
                AND SO.BEGIN_APPT_DT      >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.BEGIN_APPT_DT      <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'COM'                               
                AND SO.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'PRT'                               
                AND SO.DATE_PRINTED       >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.DATE_PRINTED       <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'SCH'                               
                AND SO.ASSIGNED_DATETIME  >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.ASSIGNED_DATETIME  <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'REC'                               
                AND SO.DATE_RECVED        >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.DATE_RECVED        <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
              )                                                         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )          
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )         
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )         
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )            
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )            
            AND OT.COMPANY_NO        = SO.COMPANY_NO                    
            AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                 
            AND WT.COMPANY_NO        = SO.COMPANY_NO                    
            AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                  
            AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS             
            AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                 
              AND ( :WS-COND-TYPE = 1                                   
                 OR ( :WS-COND-TYPE = 2                                 
                  AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )      
                 OR ( :WS-COND-TYPE = 3                                 
                  AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO         
                  AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )      
              )                                                         
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTE-HT-CUR CURSOR FOR                                     
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            HST_SO_DATA       SO                                         
MFA-TR*           ,HST_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'BEG'                                       
MFA-TR*         AND SO.BEGIN_APPT_DT      >= :WS-FROM-TS                        
MFA-TR*         AND SO.BEGIN_APPT_DT      <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'COM'                                       
MFA-TR*         AND SO.COMPLETED_DATETIME >= :WS-FROM-TS                        
MFA-TR*         AND SO.COMPLETED_DATETIME <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'PRT'                                       
MFA-TR*         AND SO.DATE_PRINTED       >= :WS-FROM-TS                        
MFA-TR*         AND SO.DATE_PRINTED       <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'SCH'                                       
MFA-TR*         AND SO.ASSIGNED_DATETIME  >= :WS-FROM-TS                        
MFA-TR*         AND SO.ASSIGNED_DATETIME  <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'REC'                                       
MFA-TR*         AND SO.DATE_RECVED        >= :WS-FROM-TS                        
MFA-TR*         AND SO.DATE_RECVED        <= :WS-TO-TS )                        
MFA-TR*       )                                                                 
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )                  
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )                    
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                    
MFA-TR*     AND OT.COMPANY_NO        = SO.COMPANY_NO                            
MFA-TR*     AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                         
MFA-TR*     AND WT.COMPANY_NO        = SO.COMPANY_NO                            
MFA-TR*     AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                          
MFA-TR*     AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                     
MFA-TR*     AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                         
MFA-TR*       AND ( :WS-COND-TYPE = 1                                           
MFA-TR*          OR ( :WS-COND-TYPE = 2                                         
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*          OR ( :WS-COND-TYPE = 3                                         
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO                 
MFA-TR*           AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*       )                                                                 
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7310                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR OTHER VIEWS>                  
      *--- < WITH READ ROUTE                                                    
      *--- < FROM HISTORY                                                       
                                                                        
           EXEC SQL                                                     
              DECLARE DTE-RR-HT-CUR CURSOR FOR                          
              SELECT COALESCE(SU.READ_ROUTE,0)
                   , SO.ORDER_TYPE_DESC
                   , SO.WORK_TYPE_DESC
                   , SO.CODE_UTIL_TYPE
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME
                   , SO.STATUS_TX
                   , SO.ORDER_STATE_CD
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED
           , 121), ' ', '-'), ':', '.') DATE_PRINTED
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME
                   , SO.SERV_ORDER_NO
                   , SO.ACCOUNT_NO
                   , SO.ORDER_TYPE_CD
                   , SO.COMPANY_NO
                   , SO.LOCAL_OFFICE
                   , SO.ACCOUNT_NO_PRIOR
                   , SO.PREMISE_NO
                   , SO.ORDER_GROUP_CD
                   , SO.SERV_ORDER_STATUS
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED
                   , SO.MSQ057A21
                   , SO.MSQ057A22
                   , SO.ORDER_RECVED_BY FROM (               
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT                                                
                       OT.ORDER_TYPE_DESC                               
                      ,WT.WORK_TYPE_DESC                                
                      ,OI.CODE_UTIL_TYPE                                
                      ,SO.ASSIGNED_DATETIME                             
                      ,WS.STATUS_TX                                     
                      ,SO.ORDER_STATE_CD                                
                      ,SO.BEGIN_APPT_DT                                 
                      ,SO.END_APPT_DT                                   
                      ,SO.DATE_PRINTED                                  
                      ,SO.COMPLETED_DATETIME                            
                      ,SO.SERV_ORDER_NO                                 
                      ,SO.ACCOUNT_NO                                    
                      ,SO.ORDER_TYPE_CD                                 
                      ,SO.COMPANY_NO                                    
                      ,SO.LOCAL_OFFICE                                  
                      ,SO.ACCOUNT_NO_PRIOR                              
                      ,SO.PREMISE_NO                                    
                      ,OT.ORDER_GROUP_CD                                
                      ,SO.SERV_ORDER_STATUS                             
                      ,SO.DATE_RECVED                                   
                      ,0 MSQ057A21                                              
                      ,0 MSQ057A22                                              
A05317                ,SO.ORDER_RECVED_BY                               
                  FROM                                                  
                       HST_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)               
                      ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)               
                      ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'BEG'                           
                    AND SO.BEGIN_APPT_DT      >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.BEGIN_APPT_DT      <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'COM'                           
                    AND SO.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'PRT'                           
                    AND SO.DATE_PRINTED       >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.DATE_PRINTED       <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'SCH'                           
                    AND SO.ASSIGNED_DATETIME  >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.ASSIGNED_DATETIME  <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'REC'                           
                    AND SO.DATE_RECVED        >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.DATE_RECVED        <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                  )                                                     
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )      
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )     
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )     
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )        
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )        
                AND OT.COMPANY_NO        = SO.COMPANY_NO                
                AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD             
                AND WT.COMPANY_NO        = SO.COMPANY_NO                
                AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD              
                AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS         
                AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID             
                  AND ( :WS-COND-TYPE = 1                               
                     OR ( :WS-COND-TYPE = 2                             
                      AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )  
                     OR ( :WS-COND-TYPE = 3                             
                      AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO     
                      AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )  
                  )                                                     
                ) SO                                                    
                LEFT OUTER JOIN                                         
                    HST_SO_UTL_CHG SC WITH(READUNCOMMITTED)                     
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN                                           
                   HST_SO_UTILITY SU WITH(READUNCOMMITTED)                      
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
              WHERE                                                     
                ( (    SO.READ_ROUTE         = :WS-READ-ROUTE           
                    OR SU.READ_ROUTE         = :WS-READ-ROUTE           
                    AND :WS-IS-RD-ROUTE-NULL = 'N' )                    
                    OR  :WS-IS-RD-ROUTE-NULL = 'Y'                      
                  )                                                     
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ057
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTE-RR-HT-CUR CURSOR FOR                                  
MFA-TR*       SELECT SO.*, IFNULL(SU.READ_ROUTE,0) FROM (                       
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT                                                        
MFA-TR*                OT.ORDER_TYPE_DESC                                       
MFA-TR*               ,WT.WORK_TYPE_DESC                                        
MFA-TR*               ,OI.CODE_UTIL_TYPE                                        
MFA-TR*               ,SO.ASSIGNED_DATETIME                                     
MFA-TR*               ,WS.STATUS_TX                                             
MFA-TR*               ,SO.ORDER_STATE_CD                                        
MFA-TR*               ,SO.BEGIN_APPT_DT                                         
MFA-TR*               ,SO.END_APPT_DT                                           
MFA-TR*               ,SO.DATE_PRINTED                                          
MFA-TR*               ,SO.COMPLETED_DATETIME                                    
MFA-TR*               ,SO.SERV_ORDER_NO                                         
MFA-TR*               ,SO.ACCOUNT_NO                                            
MFA-TR*               ,SO.ORDER_TYPE_CD                                         
MFA-TR*               ,SO.COMPANY_NO                                            
MFA-TR*               ,SO.LOCAL_OFFICE                                          
MFA-TR*               ,SO.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,SO.PREMISE_NO                                            
MFA-TR*               ,OT.ORDER_GROUP_CD                                        
MFA-TR*               ,SO.SERV_ORDER_STATUS                                     
MFA-TR*               ,SO.DATE_RECVED                                           
MFA-TR*               ,0                                                        
MFA-TR*               ,0                                                        
MFA-TR*               ,SO.ORDER_RECVED_BY                                       
MFA-TR*           FROM                                                          
MFA-TR*                HST_SO_DATA       SO                                     
MFA-TR*               ,HST_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_ORDER_TYPE    OT                                     
MFA-TR*               ,CSS_WORK_TYPE     WT                                     
MFA-TR*               ,CSS_WK_CLASS_STAT WS                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'BEG'                                   
MFA-TR*             AND SO.BEGIN_APPT_DT      >= :WS-FROM-TS                    
MFA-TR*             AND SO.BEGIN_APPT_DT      <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'COM'                                   
MFA-TR*             AND SO.COMPLETED_DATETIME >= :WS-FROM-TS                    
MFA-TR*             AND SO.COMPLETED_DATETIME <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'PRT'                                   
MFA-TR*             AND SO.DATE_PRINTED       >= :WS-FROM-TS                    
MFA-TR*             AND SO.DATE_PRINTED       <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'SCH'                                   
MFA-TR*             AND SO.ASSIGNED_DATETIME  >= :WS-FROM-TS                    
MFA-TR*             AND SO.ASSIGNED_DATETIME  <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'REC'                                   
MFA-TR*             AND SO.DATE_RECVED        >= :WS-FROM-TS                    
MFA-TR*             AND SO.DATE_RECVED        <= :WS-TO-TS )                    
MFA-TR*           )                                                             
MFA-TR*           AND ( :WS-IS-STATE-NULL    = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATE-NULL    = 'N'                              
MFA-TR*             AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )              
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-STATUS-NULL   = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATUS-NULL   = 'N'                              
MFA-TR*             AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )                
MFA-TR*           AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                 
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                
MFA-TR*         AND OT.COMPANY_NO        = SO.COMPANY_NO                        
MFA-TR*         AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                     
MFA-TR*         AND WT.COMPANY_NO        = SO.COMPANY_NO                        
MFA-TR*         AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                      
MFA-TR*         AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                 
MFA-TR*         AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                     
MFA-TR*           AND ( :WS-COND-TYPE = 1                                       
MFA-TR*              OR ( :WS-COND-TYPE = 2                                     
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*              OR ( :WS-COND-TYPE = 3                                     
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO             
MFA-TR*               AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*           )                                                             
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN                                                 
MFA-TR*             HST_SO_UTL_CHG SC                                           
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN                                                   
MFA-TR*            HST_SO_UTILITY SU                                            
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*       WHERE                                                             
MFA-TR*         ( (    SO.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             OR SU.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             AND :WS-IS-RD-ROUTE-NULL = 'N' )                            
MFA-TR*             OR  :WS-IS-RD-ROUTE-NULL = 'Y'                              
MFA-TR*           )                                                             
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7330                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR OTHER VIEWS                   
      *      WITH CREW >                                                        
      *--- < FROM HISTORY                                                       
                                                                        
           EXEC SQL                                                     
              DECLARE DTE-CW-HT-CUR CURSOR FOR                          
              SELECT TOP(150) OT.ORDER_TYPE_DESC,
              WT.WORK_TYPE_DESC,
              OI.CODE_UTIL_TYPE,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              WS.STATUS_TX,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT, 121), 
           ' ', '-'), ':', '.') BEGIN_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT, 121), 
           ' ', '-'), ':', '.') END_APPT_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED, 121), 
           ' ', '-'), ':', '.') DATE_PRINTED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.SERV_ORDER_NO,
              SO.ACCOUNT_NO,
              SO.ORDER_TYPE_CD,
              SO.COMPANY_NO,
              SO.LOCAL_OFFICE,
              SO.ACCOUNT_NO_PRIOR,
              SO.PREMISE_NO,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              0,
              0,
              SO.ORDER_RECVED_BY                                   
              FROM                                                      
                   HST_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
                  ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                   
                  ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                   
                  ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                   
                  ,HST_SO_CREW       WM WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'BEG'                               
                AND SO.BEGIN_APPT_DT      >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.BEGIN_APPT_DT      <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'COM'                               
                AND SO.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'PRT'                               
                AND SO.DATE_PRINTED       >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.DATE_PRINTED       <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'SCH'                               
                AND SO.ASSIGNED_DATETIME  >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.ASSIGNED_DATETIME  <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'REC'                               
                AND SO.DATE_RECVED        >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.DATE_RECVED        <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
              )                                                         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )          
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )         
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )         
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )            
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )            
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND WM.CREW_ID           = :WS-CREW-ID                    
              AND ( :WS-COND-TYPE = 1                                   
                 OR ( :WS-COND-TYPE = 2                                 
                  AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )      
                 OR ( :WS-COND-TYPE = 3                                 
                  AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO         
                  AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )      
              )                                                         
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTE-CW-HT-CUR CURSOR FOR                                  
MFA-TR*       SELECT                                                            
MFA-TR*            OT.ORDER_TYPE_DESC                                           
MFA-TR*           ,WT.WORK_TYPE_DESC                                            
MFA-TR*           ,OI.CODE_UTIL_TYPE                                            
MFA-TR*           ,SO.ASSIGNED_DATETIME                                         
MFA-TR*           ,WS.STATUS_TX                                                 
MFA-TR*           ,SO.ORDER_STATE_CD                                            
MFA-TR*           ,SO.BEGIN_APPT_DT                                             
MFA-TR*           ,SO.END_APPT_DT                                               
MFA-TR*           ,SO.DATE_PRINTED                                              
MFA-TR*           ,SO.COMPLETED_DATETIME                                        
MFA-TR*           ,SO.SERV_ORDER_NO                                             
MFA-TR*           ,SO.ACCOUNT_NO                                                
MFA-TR*           ,SO.ORDER_TYPE_CD                                             
MFA-TR*           ,SO.COMPANY_NO                                                
MFA-TR*           ,SO.LOCAL_OFFICE                                              
MFA-TR*           ,SO.ACCOUNT_NO_PRIOR                                          
MFA-TR*           ,SO.PREMISE_NO                                                
MFA-TR*           ,OT.ORDER_GROUP_CD                                            
MFA-TR*           ,SO.SERV_ORDER_STATUS                                         
MFA-TR*           ,SO.DATE_RECVED                                               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,SO.ORDER_RECVED_BY                                           
MFA-TR*       FROM                                                              
MFA-TR*            HST_SO_DATA       SO                                         
MFA-TR*           ,HST_SO_ORDER_INST OI                                         
MFA-TR*           ,CSS_ORDER_TYPE    OT                                         
MFA-TR*           ,CSS_WORK_TYPE     WT                                         
MFA-TR*           ,CSS_WK_CLASS_STAT WS                                         
MFA-TR*           ,HST_SO_CREW       WM                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'BEG'                                       
MFA-TR*         AND SO.BEGIN_APPT_DT      >= :WS-FROM-TS                        
MFA-TR*         AND SO.BEGIN_APPT_DT      <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'COM'                                       
MFA-TR*         AND SO.COMPLETED_DATETIME >= :WS-FROM-TS                        
MFA-TR*         AND SO.COMPLETED_DATETIME <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'PRT'                                       
MFA-TR*         AND SO.DATE_PRINTED       >= :WS-FROM-TS                        
MFA-TR*         AND SO.DATE_PRINTED       <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'SCH'                                       
MFA-TR*         AND SO.ASSIGNED_DATETIME  >= :WS-FROM-TS                        
MFA-TR*         AND SO.ASSIGNED_DATETIME  <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'REC'                                       
MFA-TR*         AND SO.DATE_RECVED        >= :WS-FROM-TS                        
MFA-TR*         AND SO.DATE_RECVED        <= :WS-TO-TS )                        
MFA-TR*       )                                                                 
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )                  
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )                    
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                    
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND WM.CREW_ID           = :WS-CREW-ID                            
MFA-TR*       AND ( :WS-COND-TYPE = 1                                           
MFA-TR*          OR ( :WS-COND-TYPE = 2                                         
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*          OR ( :WS-COND-TYPE = 3                                         
MFA-TR*           AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO                 
MFA-TR*           AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )              
MFA-TR*       )                                                                 
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7350                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR SERVICE ORDER DETAILS FOR OTHER VIEWS                   
      *      WITH CREW AND READ ROUTE>                                          
      *--- < FROM HISTORY                                                       
                                                                        
           EXEC SQL                                                     
              DECLARE DTE-CW-RR-HT-CUR CURSOR FOR                       
              SELECT COALESCE(SU.READ_ROUTE,0)
                   , SO.ORDER_TYPE_DESC
                   , SO.WORK_TYPE_DESC
                   , SO.CODE_UTIL_TYPE
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME
                   , SO.STATUS_TX
                   , SO.ORDER_STATE_CD
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_PRINTED
           , 121), ' ', '-'), ':', '.') DATE_PRINTED
                   , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME
                   , SO.SERV_ORDER_NO
                   , SO.ACCOUNT_NO
                   , SO.ORDER_TYPE_CD
                   , SO.COMPANY_NO
                   , SO.LOCAL_OFFICE
                   , SO.ACCOUNT_NO_PRIOR
                   , SO.PREMISE_NO
                   , SO.ORDER_GROUP_CD
                   , SO.SERV_ORDER_STATUS
                   , REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED
                   , SO.MSQ057A21
                   , SO.MSQ057A22
                   , SO.ORDER_RECVED_BY FROM (               
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT                                                
                       OT.ORDER_TYPE_DESC                               
                      ,WT.WORK_TYPE_DESC                                
                      ,OI.CODE_UTIL_TYPE                                
                      ,SO.ASSIGNED_DATETIME                             
                      ,WS.STATUS_TX                                     
                      ,SO.ORDER_STATE_CD                                
                      ,SO.BEGIN_APPT_DT                                 
                      ,SO.END_APPT_DT                                   
                      ,SO.DATE_PRINTED                                  
                      ,SO.COMPLETED_DATETIME                            
                      ,SO.SERV_ORDER_NO                                 
                      ,SO.ACCOUNT_NO                                    
                      ,SO.ORDER_TYPE_CD                                 
                      ,SO.COMPANY_NO                                    
                      ,SO.LOCAL_OFFICE                                  
                      ,SO.ACCOUNT_NO_PRIOR                              
                      ,SO.PREMISE_NO                                    
                      ,OT.ORDER_GROUP_CD                                
                      ,SO.SERV_ORDER_STATUS                             
                      ,SO.DATE_RECVED                                   
                      ,0 MSQ057A21                                              
                      ,0 MSQ057A22                                              
A05317                ,SO.ORDER_RECVED_BY                               
                  FROM                                                  
                       HST_SO_DATA       SO WITH(READUNCOMMITTED)               
                      ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                      ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)               
                      ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)               
                      ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)               
                      ,HST_SO_CREW       WM WITH(READUNCOMMITTED)               
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'BEG'                           
                    AND SO.BEGIN_APPT_DT      >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.BEGIN_APPT_DT      <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'COM'                           
                    AND SO.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'PRT'                           
                    AND SO.DATE_PRINTED       >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.DATE_PRINTED       <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'SCH'                           
                    AND SO.ASSIGNED_DATETIME  >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.ASSIGNED_DATETIME  <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'REC'                           
                    AND SO.DATE_RECVED        >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.DATE_RECVED        <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                  )                                                     
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )      
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )     
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )     
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )        
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )        
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND WM.CREW_ID           = :WS-CREW-ID                
                  AND ( :WS-COND-TYPE = 1                               
                     OR ( :WS-COND-TYPE = 2                             
                      AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )  
                     OR ( :WS-COND-TYPE = 3                             
                      AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO     
                      AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )  
                  )                                                     
                ) SO                                                    
                LEFT OUTER JOIN                                         
                    HST_SO_UTL_CHG SC WITH(READUNCOMMITTED)                     
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN                                           
                   HST_SO_UTILITY SU WITH(READUNCOMMITTED)                      
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
              WHERE                                                     
                ( (    SO.READ_ROUTE         = :WS-READ-ROUTE           
                    OR SU.READ_ROUTE         = :WS-READ-ROUTE           
                    AND :WS-IS-RD-ROUTE-NULL = 'N' )                    
                    OR  :WS-IS-RD-ROUTE-NULL = 'Y'                      
                  )                                                     
              ORDER BY SO.SERV_ORDER_NO                                 
C35434                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ057
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTE-CW-RR-HT-CUR CURSOR FOR                               
MFA-TR*       SELECT SO.*, IFNULL(SU.READ_ROUTE,0) FROM (                       
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT                                                        
MFA-TR*                OT.ORDER_TYPE_DESC                                       
MFA-TR*               ,WT.WORK_TYPE_DESC                                        
MFA-TR*               ,OI.CODE_UTIL_TYPE                                        
MFA-TR*               ,SO.ASSIGNED_DATETIME                                     
MFA-TR*               ,WS.STATUS_TX                                             
MFA-TR*               ,SO.ORDER_STATE_CD                                        
MFA-TR*               ,SO.BEGIN_APPT_DT                                         
MFA-TR*               ,SO.END_APPT_DT                                           
MFA-TR*               ,SO.DATE_PRINTED                                          
MFA-TR*               ,SO.COMPLETED_DATETIME                                    
MFA-TR*               ,SO.SERV_ORDER_NO                                         
MFA-TR*               ,SO.ACCOUNT_NO                                            
MFA-TR*               ,SO.ORDER_TYPE_CD                                         
MFA-TR*               ,SO.COMPANY_NO                                            
MFA-TR*               ,SO.LOCAL_OFFICE                                          
MFA-TR*               ,SO.ACCOUNT_NO_PRIOR                                      
MFA-TR*               ,SO.PREMISE_NO                                            
MFA-TR*               ,OT.ORDER_GROUP_CD                                        
MFA-TR*               ,SO.SERV_ORDER_STATUS                                     
MFA-TR*               ,SO.DATE_RECVED                                           
MFA-TR*               ,0                                                        
MFA-TR*               ,0                                                        
MFA-TR*               ,SO.ORDER_RECVED_BY                                       
MFA-TR*           FROM                                                          
MFA-TR*                HST_SO_DATA       SO                                     
MFA-TR*               ,HST_SO_ORDER_INST OI                                     
MFA-TR*               ,CSS_ORDER_TYPE    OT                                     
MFA-TR*               ,CSS_WORK_TYPE     WT                                     
MFA-TR*               ,CSS_WK_CLASS_STAT WS                                     
MFA-TR*               ,HST_SO_CREW       WM                                     
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'BEG'                                   
MFA-TR*             AND SO.BEGIN_APPT_DT      >= :WS-FROM-TS                    
MFA-TR*             AND SO.BEGIN_APPT_DT      <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'COM'                                   
MFA-TR*             AND SO.COMPLETED_DATETIME >= :WS-FROM-TS                    
MFA-TR*             AND SO.COMPLETED_DATETIME <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'PRT'                                   
MFA-TR*             AND SO.DATE_PRINTED       >= :WS-FROM-TS                    
MFA-TR*             AND SO.DATE_PRINTED       <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'SCH'                                   
MFA-TR*             AND SO.ASSIGNED_DATETIME  >= :WS-FROM-TS                    
MFA-TR*             AND SO.ASSIGNED_DATETIME  <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'REC'                                   
MFA-TR*             AND SO.DATE_RECVED        >= :WS-FROM-TS                    
MFA-TR*             AND SO.DATE_RECVED        <= :WS-TO-TS )                    
MFA-TR*           )                                                             
MFA-TR*           AND ( :WS-IS-STATE-NULL    = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATE-NULL    = 'N'                              
MFA-TR*             AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )              
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-STATUS-NULL   = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATUS-NULL   = 'N'                              
MFA-TR*             AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )                
MFA-TR*           AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                 
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND WM.CREW_ID           = :WS-CREW-ID                        
MFA-TR*           AND ( :WS-COND-TYPE = 1                                       
MFA-TR*              OR ( :WS-COND-TYPE = 2                                     
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*              OR ( :WS-COND-TYPE = 3                                     
MFA-TR*               AND SO.SERV_ORDER_NO >= :WS-LOW-SERV-ORDER-NO             
MFA-TR*               AND SO.SERV_ORDER_NO <= :WS-HIGH-SERV-ORDER-NO )          
MFA-TR*           )                                                             
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN                                                 
MFA-TR*             HST_SO_UTL_CHG SC                                           
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN                                                   
MFA-TR*            HST_SO_UTILITY SU                                            
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*       WHERE                                                             
MFA-TR*         ( (    SO.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             OR SU.READ_ROUTE         = :WS-READ-ROUTE                   
MFA-TR*             AND :WS-IS-RD-ROUTE-NULL = 'N' )                            
MFA-TR*             OR  :WS-IS-RD-ROUTE-NULL = 'Y'                              
MFA-TR*           )                                                             
MFA-TR*       ORDER BY SO.SERV_ORDER_NO                                         
MFA-TR*       FETCH FIRST 150 ROWS ONLY WITH UR                                 
MFA-TR*       QUERYNO 7370                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-PROCESS            PIC X(01).                            
       01 PARM-CUR-HIST           PIC X(01).                            
       01 PARM-COMPANY            PIC X(02).                            
       01 PARM-LOCAL-OFFICE       PIC X(03).                            
       01 PARM-RESP-AREA          PIC X(04).                            
       01 PARM-WORK-AREA          PIC X(12).                            
       01 PARM-VIEW               PIC X(03).                            
A01529 01 PARM-CLASS              PIC X(04).                            
       01 PARM-STATUS             PIC X(02).                            
       01 PARM-STATE              PIC X(01).                            
       01 PARM-ORDER-TYPE         PIC X(05).                            
       01 PARM-WORK-TYPE          PIC X(05).                            
       01 PARM-START-DATE         PIC X(26).                            
       01 PARM-END-DATE           PIC X(26).                            
COB305 01 PARM-NUMBER        PIC  S9(13)V COMP-3 VALUE 0.               
COB305 01 PARM-LOW-SERV-ORDER-N        PIC S9(13)V COMP-3 VALUE 0.              
COB305 01 PARM-HIGH-SERV-ORDERZ        PIC S9(13)V COMP-3 VALUE 0.              
       01 PARM-CREW-ID             PIC X(06).                           
       01 PARM-READ-ROUTE          PIC X(04).                           
      *                                                                         
       PROCEDURE DIVISION USING PARM-PROCESS                            
                                PARM-CUR-HIST                           
                                PARM-COMPANY                            
                                PARM-LOCAL-OFFICE                       
                                PARM-RESP-AREA                          
                                PARM-WORK-AREA                          
                                PARM-VIEW                               
                                PARM-CLASS                              
                                PARM-STATUS                             
                                PARM-STATE                              
                                PARM-ORDER-TYPE                         
                                PARM-WORK-TYPE                          
                                PARM-START-DATE                         
                                PARM-END-DATE                           
                                PARM-NUMBER                             
                                PARM-LOW-SERV-ORDER-N                   
                                PARM-HIGH-SERV-ORDERZ                   
                                PARM-CREW-ID                            
                                PARM-READ-ROUTE.                        
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
      *                                                                         
           EXEC SQL                                                     
             DECLARE C1 CURSOR                      
                       WITH ROWSET POSITIONING                          
             FOR SELECT DISTINCT TOP(100) LTRIM(RTRIM(ADDRESS
           ))         AS ADDRESS,
              ORDER_TYPE_DESC,
              WORK_TYPE_DESC,
              CODE_UTIL_TYPE,
              ASSIGNED_DATETIME,
              STATUS_TX,
              ORDER_STATE_CD,
              BEGIN_APPT_DT,
              END_APPT_DT,
              DATE_PRINTED,
              COMPLETED_DATETIME,
              SERV_ORDER_NO,
              ACCOUNT_NO,
              LTRIM(RTRIM(FULL_NAME))      AS FULL_NAME,
              LTRIM(RTRIM(FIRST_NAME))     AS FIRST_NAME,
              LTRIM(RTRIM(MIDDLE_NAME))    AS MIDDLE_NAME,
              LTRIM(RTRIM(LAST_NAME))      AS LAST_NAME,
              NAME_FORMAT,
              :WS-TOTAL              AS TOTAL,
              ORDER_TYPE_CD,
              COMPANY_NO,
              LOCAL_OFFICE,
              ACCOUNT_NO_PRIOR,
              PREMISE_NO,
              CUSTOMER_NO,
              ZIP_CODE,
              ORDER_GROUP_CD,
              SERV_ORDER_STATUS,
              DATE_RECVED,
              IIF(TRY_CAST(READ_ROUTE AS INT) IS NULL, CIS.INTEGER(
           READ_ROUTE), CAST(READ_ROUTE AS INT))        AS READ_ROUTE,
              ORDER_RECVED_BY                                 
                 FROM                                                   
                    #CSR01153_R1                                 
                 ORDER BY SERV_ORDER_NO                                 
                                               
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ029
MFA-TR* MSQ034
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH HOLD WITH RETURN                            
MFA-TR*                WITH ROWSET POSITIONING                                  
MFA-TR*      FOR SELECT DISTINCT                                                
MFA-TR*                 STRIP(ADDRESS)         AS ADDRESS                       
MFA-TR*                ,ORDER_TYPE_DESC                                         
MFA-TR*                ,WORK_TYPE_DESC                                          
MFA-TR*                ,CODE_UTIL_TYPE                                          
MFA-TR*                ,ASSIGNED_DATETIME                                       
MFA-TR*                ,STATUS_TX                                               
MFA-TR*                ,ORDER_STATE_CD                                          
MFA-TR*                ,BEGIN_APPT_DT                                           
MFA-TR*                ,END_APPT_DT                                             
MFA-TR*                ,DATE_PRINTED                                            
MFA-TR*                ,COMPLETED_DATETIME                                      
MFA-TR*                ,SERV_ORDER_NO                                           
MFA-TR*                ,ACCOUNT_NO                                              
MFA-TR*                ,STRIP( FULL_NAME)      AS FULL_NAME                     
MFA-TR*                ,STRIP( FIRST_NAME)     AS FIRST_NAME                    
MFA-TR*                ,STRIP( MIDDLE_NAME)    AS MIDDLE_NAME                   
MFA-TR*                ,STRIP( LAST_NAME)      AS LAST_NAME                     
MFA-TR*                ,NAME_FORMAT                                             
MFA-TR*                ,:WS-TOTAL              AS TOTAL                         
MFA-TR*                ,ORDER_TYPE_CD                                           
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*                ,LOCAL_OFFICE                                            
MFA-TR*                ,ACCOUNT_NO_PRIOR                                        
MFA-TR*                ,PREMISE_NO                                              
MFA-TR*                ,CUSTOMER_NO                                             
MFA-TR*                ,ZIP_CODE                                                
MFA-TR*                ,ORDER_GROUP_CD                                          
MFA-TR*                ,SERV_ORDER_STATUS                                       
MFA-TR*                ,DATE_RECVED                                             
MFA-TR*                ,INT(READ_ROUTE)        AS READ_ROUTE                    
MFA-TR*                ,ORDER_RECVED_BY                                         
MFA-TR*          FROM                                                           
MFA-TR*             SESSION.CSR01153_R1                                         
MFA-TR*          ORDER BY SERV_ORDER_NO                                         
MFA-TR*          FETCH FIRST 100 ROWS ONLY                                      
MFA-TR*      END-EXEC.                                                          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR01153_R1'            
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR01153_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR01153_R1
              (                                                       
T36933                ADDRESS CHAR(74)  COLLATE LATIN1_GENERAL_100_BIN2         
                     ,ORDER_TYPE_DESC CHAR(15)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,WORK_TYPE_CD CHAR(03)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,WORK_TYPE_DESC CHAR(25)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,ASSIGNED_DATETIME      DATETIME2(6)                  
                     ,STATUS_TX CHAR(25)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,ORDER_STATE_CD CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,BEGIN_APPT_DT          DATETIME2(6)                  
                     ,END_APPT_DT            DATETIME2(6)                  
                     ,DATE_PRINTED           DATETIME2(6)                  
                     ,COMPLETED_DATETIME     DATETIME2(6)                  
                     ,SERV_ORDER_NO          DECIMAL(13)                
                     ,ACCOUNT_NO             DECIMAL(13)                
T36933               ,FULL_NAME CHAR(70)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,FIRST_NAME CHAR(15)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,MIDDLE_NAME CHAR(15)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
T36933               ,LAST_NAME CHAR(40)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,NAME_FORMAT CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,TOTAL                  INT                    
                     ,ORDER_TYPE_CD CHAR(05)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,COMPANY_NO CHAR(02)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,LOCAL_OFFICE CHAR(03)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,ACCOUNT_NO_PRIOR       DECIMAL(13)                
                     ,PREMISE_NO             DECIMAL(10)                
                     ,CUSTOMER_NO            DECIMAL(10)                
                     ,ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2        
                     ,ORDER_GROUP_CD CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,SERV_ORDER_STATUS CHAR(02)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                     ,DATE_RECVED            DATETIME2(6)                  
                     ,READ_ROUTE CHAR(04)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
A05317               ,ORDER_RECVED_BY CHAR(40)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                   
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
               PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                      NEXT SENTENCE                                     
               ELSE                                                     
                  MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
                  MOVE SQLCODE            TO ABEND-SQLCODE              
                  MOVE SQLSTATE           TO ABEND-SQLSTATE             
                  MOVE '0100A'            TO ACTIVE-PARAGRAPH           
                  MOVE 'DECLARE GTT'      TO ABEND-FUNCTION             
                  MOVE SPACES             TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                  MOVE 'CSR01153_R1'      TO TABLE-1                    
                  MOVE SPACES             TO TABLE-ELEMENT-1            
                  MOVE SPACES             TO HOSTVAR-ELEMENT-1          
                  PERFORM 9900-SQL-ERROR-ROUTINE                        
                                          THRU  9900-EXIT               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-PROCESS             TO WS-PROCESS                  
           MOVE PARM-CUR-HIST            TO WS-CUR-HIST                 
           MOVE PARM-COMPANY             TO WS-COMPANY-NO               
           MOVE PARM-LOCAL-OFFICE        TO WS-LOCAL-OFFICE             
           MOVE PARM-RESP-AREA           TO WS-RESP-AREA-ID             
           MOVE PARM-WORK-AREA           TO WS-WORK-AREA-ID             
           MOVE PARM-VIEW                TO WS-VIEW                     
           MOVE PARM-CLASS               TO WS-CLASS                    
           MOVE PARM-STATUS              TO WS-SO-STATUS                
           MOVE PARM-STATE               TO WS-SO-STATE-CD              
           MOVE PARM-ORDER-TYPE          TO WS-ORDER-TYPE-CD            
           MOVE PARM-WORK-TYPE           TO WS-WORK-TYPE                
           MOVE PARM-START-DATE          TO WS-FROM-TS                  
           MOVE PARM-END-DATE            TO WS-TO-TS                    
           MOVE PARM-NUMBER              TO WS-SO-NUMBER                
           MOVE PARM-LOW-SERV-ORDER-N    TO WS-LOW-SERV-ORDER-NO        
           MOVE PARM-HIGH-SERV-ORDERZ    TO WS-HIGH-SERV-ORDER-NO       
           MOVE PARM-CREW-ID             TO WS-CREW-ID                  
                                                                        
           IF PARM-READ-ROUTE NOT = SPACES                              
              MOVE 'N'                   TO WS-IS-RD-ROUTE-NULL         
              PERFORM UNTIL PARM-READ-ROUTE(4:1) NOT = SPACE            
                 MOVE PARM-READ-ROUTE(3:1)       TO PARM-READ-ROUTE(4:1)
                 MOVE PARM-READ-ROUTE(2:1)       TO PARM-READ-ROUTE(3:1)
                 MOVE PARM-READ-ROUTE(1:1)       TO PARM-READ-ROUTE(2:1)
                 MOVE ZERO                       TO PARM-READ-ROUTE(1:1)
              END-PERFORM                                               
           END-IF.                                                      
A03263     IF PARM-READ-ROUTE NOT NUMERIC                               
A03263         MOVE ZEROES TO WS-READ-ROUTE-NUM                         
A03263     ELSE                                                         
               MOVE PARM-READ-ROUTE      TO WS-READ-ROUTE-NUM           
A03263     END-IF.                                                      
           MOVE WS-READ-ROUTE-NUM        TO WS-READ-ROUTE.              
                                                                        
           IF WS-RESP-AREA-ID NOT = SPACES                              
              MOVE 'N'                TO WS-IS-RSP-AREA-NULL            
           END-IF.                                                      
                                                                        
           IF WS-WORK-AREA-ID NOT =  SPACES                             
              MOVE 'N'                TO WS-IS-WRK-AREA-NULL            
           END-IF.                                                      
                                                                        
           IF WS-SO-STATUS    NOT =  SPACES                             
              MOVE 'N'                TO WS-IS-STATUS-NULL              
           END-IF.                                                      
                                                                        
           IF WS-SO-STATE-CD  NOT = SPACES                              
              MOVE 'N'                TO WS-IS-STATE-NULL               
           END-IF.                                                      
                                                                        
           IF WS-WORK-TYPE    NOT = SPACES                              
              MOVE 'N'                TO WS-IS-WRK-TYPE-NULL            
           END-IF.                                                      
                                                                        
           IF WS-CREW-ID NOT =  SPACES                                  
              MOVE 'N'                TO WS-IS-CREW-ID-NULL             
           END-IF.                                                      
                                                                        
           MOVE PARM-LOW-SERV-ORDER-N TO WS-LOW-SERV-ORDER-NO           
           MOVE PARM-HIGH-SERV-ORDERZ TO WS-HIGH-SERV-ORDER-NO          
                                                                        
           IF PARM-PROCESS = '-'                                        
              MOVE 1                  TO WS-COND-TYPE                   
           ELSE                                                         
              IF PARM-PROCESS = 'N'                                     
                 MOVE 2               TO WS-COND-TYPE                   
              ELSE                                                      
                 MOVE 3               TO WS-COND-TYPE                   
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-VIEW = 'LAT'                                           
              IF WS-SO-STATE-CD = SPACES                                
                 MOVE 'LAT1'             TO WS-VIEW-TYPE                
              ELSE                                                      
                 IF WS-SO-STATE-CD = 'P'                                
                    MOVE 'LAT2'          TO WS-VIEW-TYPE                
                 ELSE                                                   
                    MOVE 'LAT3'          TO WS-VIEW-TYPE                
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-VIEW = 'TYP'                                           
              IF PARM-ORDER-TYPE(1:2) = 'CC'                            
                 MOVE 'TYP1'                TO WS-VIEW-TYPE             
              ELSE                                                      
                 IF PARM-ORDER-TYPE(1:3) = 'OFF'                        
                    MOVE 'TYP2'             TO WS-VIEW-TYPE             
                 ELSE                                                   
                    MOVE 'TYP3'             TO WS-VIEW-TYPE             
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
C35927     EXEC SQL                                                     
C35927        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
C35927     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35927     MOVE WS-CURRENT-DATE TO WS-TODAYS-DATE(1:10).                
C35927     MOVE '-00.00.00.000000' TO WS-TODAYS-DATE(11:16).            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2300-BUILD-RESULT                                    *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2300-BUILD-RESULT             THRU 2300-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      *2100-MOVE-RESULT                                               *         
      ******************************************************************        
       2100-MOVE-RESULT.                                                
                                                                        
           MOVE SPACES                    TO  S-ADDRESS.                
           MOVE C2-ORDER-TYPE-DESC        TO  S-ORDER-TYPE-DESC.        
           MOVE L4-WORK-TYPE-DESC         TO  S-WORK-TYPE-DESC.         
           MOVE VI-CODE-UTIL-TYPE         TO  S-CODE-UTIL-TYPE.         
           MOVE VI-WORK-TYPE-CD           TO  WS-WORK-TYPE-CD.          
           MOVE VO-ASSIGNED-DATETIME      TO  S-ASSIGNED-DATETIME.      
           MOVE R6-STATUS-TX              TO  S-STATUS-TX.              
           MOVE VO-ORDER-STATE-CD         TO  S-ORDER-STATE-CD.         
           MOVE VO-BEGIN-APPT-DT          TO  S-BEGIN-APPT-DATE.        
           MOVE VO-END-APPT-DT            TO  S-END-APPT-DATE.          
           MOVE VO-DATE-PRINTED           TO  S-DATE-PRINTED.           
           MOVE VO-COMPLETED-DATETIME     TO  S-COMPLETED-DATETIME.     
           MOVE VO-SERV-ORDER-NO          TO  S-SERV-ORDER-NO.          
           MOVE VO-ACCOUNT-NO             TO  S-ACCOUNT-NO.             
           MOVE SPACES                    TO  S-FULL-NAME.              
           MOVE SPACES                    TO  S-FIRST-NAME.             
           MOVE SPACES                    TO  S-MIDDLE-NAME.            
           MOVE SPACES                    TO  S-LAST-NAME.              
           MOVE SPACES                    TO  S-NAME-FORMAT.            
           MOVE WS-TOTAL                  TO  S-TOTAL.                  
           MOVE VO-ORDER-TYPE-CD          TO  S-ORDER-TYPE-CD.          
           MOVE VO-COMPANY-NO             TO  S-COMPANY-NO.             
           MOVE VO-LOCAL-OFFICE           TO  S-LOCAL-OFFICE.           
           MOVE VO-ACCOUNT-NO-PRIOR       TO  S-ACCOUNT-NO-PRIOR.       
           MOVE VO-PREMISE-NO             TO  S-PREMISE-NO.             
           MOVE 0                         TO  S-CUSTOMER-NO.            
           MOVE SPACES                    TO  S-ZIP-CODE.               
           MOVE C2-ORDER-GROUP-CD         TO  S-ORDER-GROUP-CD.         
           MOVE VO-SERV-ORDER-STATUS      TO  S-SERV-ORDER-STATUS.      
           MOVE VO-DATE-RECVED            TO  S-DATE-RECVD.             
           MOVE VE-READ-ROUTE             TO  S-READ-ROUTE.             
           IF VE-READ-ROUTE = 0 AND VT-READ-ROUTE > 0                   
              MOVE VT-READ-ROUTE          TO  S-READ-ROUTE              
           END-IF.                                                      
A05317     IF VO-ORDER-RECVED-BY > SPACES                               
A05317         MOVE VO-ORDER-RECVED-BY   TO PF-USER-ID                  
A05317         PERFORM 7800-USER-PROFILE THRU 7800-EXIT                 
A05317         MOVE WS-USER-NAME         TO S-ORDER-RECVED-BY           
A05317     ELSE                                                         
A05317         MOVE SPACES               TO S-ORDER-RECVED-BY
           END-IF.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2300-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2300-BUILD-RESULT.                                               
                                                                        
           EVALUATE TRUE                                                
           WHEN WS-VIEW = 'ORD'                                         
              PERFORM 2400-PROCESS-ORD        THRU 2400-EXIT            
           WHEN WS-VIEW = 'LAT'                                         
              EVALUATE TRUE                                             
                 WHEN WS-CREW-ID      = SPACES                          
                  AND PARM-READ-ROUTE = SPACES                          
                      PERFORM 2500-PROCESS-LAT        THRU 2500-EXIT    
                 WHEN WS-CREW-ID          = SPACES                      
                  AND PARM-READ-ROUTE NOT = SPACES                      
                      PERFORM 2525-PROCESS-LAT-RR     THRU 2525-EXIT    
                 WHEN WS-CREW-ID  NOT = SPACES                          
                  AND PARM-READ-ROUTE = SPACES                          
                      PERFORM 2550-PROCESS-LAT-CW     THRU 2550-EXIT    
                 WHEN WS-CREW-ID      NOT = SPACES                      
                  AND PARM-READ-ROUTE NOT = SPACES                      
                      PERFORM 2575-PROCESS-LAT-CW-RR  THRU 2575-EXIT    
              END-EVALUATE                                              
           WHEN WS-VIEW = 'TYP'                                         
              EVALUATE TRUE                                             
                 WHEN WS-CREW-ID      = SPACES                          
                  AND PARM-READ-ROUTE = SPACES                          
                      PERFORM 2600-PROCESS-TYP        THRU 2600-EXIT    
                 WHEN WS-CREW-ID          = SPACES                      
                  AND PARM-READ-ROUTE NOT = SPACES                      
                      PERFORM 2625-PROCESS-TYP-RR     THRU 2625-EXIT    
                 WHEN WS-CREW-ID  NOT = SPACES                          
                  AND PARM-READ-ROUTE = SPACES                          
                      PERFORM 2650-PROCESS-TYP-CW     THRU 2650-EXIT    
                 WHEN WS-CREW-ID      NOT = SPACES                      
                  AND PARM-READ-ROUTE NOT = SPACES                      
                      PERFORM 2675-PROCESS-TYP-CW-RR  THRU 2675-EXIT    
              END-EVALUATE                                              
           WHEN WS-VIEW = 'BEG' OR 'COM' OR 'PRT' OR 'SCH' OR 'REC'     
              MOVE WS-VIEW                            TO WS-VIEW-TYPE   
              EVALUATE TRUE                                             
                 WHEN WS-CREW-ID      = SPACES                          
                  AND PARM-READ-ROUTE = SPACES                          
                      PERFORM 2700-PROCESS-DTE        THRU 2700-EXIT    
                 WHEN WS-CREW-ID          = SPACES                      
                  AND PARM-READ-ROUTE NOT = SPACES                      
                      PERFORM 2725-PROCESS-DTE-RR     THRU 2725-EXIT    
                 WHEN WS-CREW-ID  NOT = SPACES                          
                  AND PARM-READ-ROUTE = SPACES                          
                      PERFORM 2750-PROCESS-DTE-CW     THRU 2750-EXIT    
                 WHEN WS-CREW-ID      NOT = SPACES                      
                  AND PARM-READ-ROUTE NOT = SPACES                      
                      PERFORM 2775-PROCESS-DTE-CW-RR  THRU 2775-EXIT    
              END-EVALUATE                                              
           END-EVALUATE.                                                
                                                                        
           IF CTR-ROWS = 0                                              
              ADD +1                       TO CTR-ROWS                  
           ELSE                                                         
              PERFORM 2800-UPDATE-RESULT   THRU 2800-EXIT               
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-PROCESS-ORD                                               *        
      *     PROCESS FOR SERV ORDER NUMBER                              *        
      ******************************************************************        
                                                                        
       2400-PROCESS-ORD.                                                
                                                                        
           MOVE '2400'              TO ACTIVE-PARAGRAPH.                
                                                                        
           IF PARM-CUR-HIST NOT = 'H'                                   
              PERFORM 7500-GET-COUNT-ORD         THRU 7500-EXIT         
              PERFORM 7000-OPEN-ORD-CUR          THRU 7000-EXIT         
              PERFORM 7010-FETCH-ORD-CUR         THRU 7010-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7010-FETCH-ORD-CUR      THRU 7010-EXIT         
              END-PERFORM                                               
              PERFORM 7020-CLOSE-ORD-CUR         THRU 7020-EXIT         
           ELSE                                                         
              PERFORM 7550-GET-COUNT-ORD-HT      THRU 7550-EXIT         
              PERFORM 7025-OPEN-ORD-HT-CUR       THRU 7025-EXIT         
              PERFORM 7035-FETCH-ORD-HT-CUR      THRU 7035-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7035-FETCH-ORD-HT-CUR   THRU 7035-EXIT         
              END-PERFORM                                               
              PERFORM 7045-CLOSE-ORD-HT-CUR      THRU 7045-EXIT         
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-PROCESS-LAT                                               *        
      *     PROCESS FOR LAT VIEW                                       *        
      ******************************************************************        
                                                                        
       2500-PROCESS-LAT.                                                
                                                                        
           MOVE '2500'              TO ACTIVE-PARAGRAPH.                
                                                                        
           IF PARM-CUR-HIST NOT = 'H'                                   
              PERFORM 7600-GET-COUNT-LAT         THRU 7600-EXIT         
              PERFORM 7100-OPEN-LAT-CUR          THRU 7100-EXIT         
              PERFORM 7104-FETCH-LAT-CUR         THRU 7104-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7104-FETCH-LAT-CUR      THRU 7104-EXIT         
              END-PERFORM                                               
              PERFORM 7108-CLOSE-LAT-CUR         THRU 7108-EXIT         
           ELSE                                                         
              PERFORM 7601-GET-COUNT-LAT-HT      THRU 7601-EXIT         
              PERFORM 7110-OPEN-LAT-HT-CUR       THRU 7110-EXIT         
              PERFORM 7114-FETCH-LAT-HT-CUR      THRU 7114-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7114-FETCH-LAT-HT-CUR THRU 7114-EXIT           
              END-PERFORM                                               
              PERFORM 7118-CLOSE-LAT-HT-CUR      THRU 7118-EXIT         
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2525-PROCESS-LAT-RR                                            *        
      *     PROCESS FOR LAT VIEW                                       *        
      ******************************************************************        
                                                                        
       2525-PROCESS-LAT-RR.                                             
                                                                        
           MOVE '2525'              TO ACTIVE-PARAGRAPH.                
                                                                        
           IF PARM-CUR-HIST NOT = 'H'                                   
              PERFORM 7602-GET-COUNT-LAT-RR      THRU 7602-EXIT         
              PERFORM 7120-OPEN-LAT-RR-CUR       THRU 7120-EXIT         
              PERFORM 7124-FETCH-LAT-RR-CUR      THRU 7124-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7124-FETCH-LAT-RR-CUR   THRU 7124-EXIT         
              END-PERFORM                                               
              PERFORM 7128-CLOSE-LAT-RR-CUR      THRU 7128-EXIT         
           ELSE                                                         
              PERFORM 7603-GET-COUNT-LAT-RR-HT   THRU 7603-EXIT         
              PERFORM 7130-OPEN-LAT-RR-HT-CUR    THRU 7130-EXIT         
              PERFORM 7134-FETCH-LAT-RR-HT-CUR   THRU 7134-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7134-FETCH-LAT-RR-HT-CUR THRU 7134-EXIT        
              END-PERFORM                                               
              PERFORM 7138-CLOSE-LAT-RR-HT-CUR   THRU 7138-EXIT         
           END-IF.                                                      
                                                                        
       2525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2550-PROCESS-LAT-CW                                            *        
      *     PROCESS FOR LAT VIEW WITH CREW                             *        
      ******************************************************************        
                                                                        
       2550-PROCESS-LAT-CW.                                             
                                                                        
           MOVE '2550'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           IF PARM-CUR-HIST NOT = 'H'                                   
              PERFORM 7604-GET-COUNT-LAT-CW      THRU 7604-EXIT         
              PERFORM 7140-OPEN-LAT-CW-CUR       THRU 7140-EXIT         
              PERFORM 7144-FETCH-LAT-CW-CUR      THRU 7144-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7144-FETCH-LAT-CW-CUR THRU 7144-EXIT           
              END-PERFORM                                               
              PERFORM 7148-CLOSE-LAT-CW-CUR      THRU 7148-EXIT         
           ELSE                                                         
              PERFORM 7605-GET-COUNT-LAT-CW-HT   THRU 7605-EXIT         
              PERFORM 7150-OPEN-LAT-CW-HT-CUR THRU 7150-EXIT            
              PERFORM 7154-FETCH-LAT-CW-HT-CUR THRU 7154-EXIT           
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7154-FETCH-LAT-CW-HT-CUR THRU 7154-EXIT        
              END-PERFORM                                               
              PERFORM 7158-CLOSE-LAT-CW-HT-CUR THRU 7158-EXIT           
           END-IF.                                                      
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2575-PROCESS-LAT-CW-RR                                         *        
      *     PROCESS FOR LAT VIEW WITH CREW                             *        
      ******************************************************************        
                                                                        
       2575-PROCESS-LAT-CW-RR.                                          
                                                                        
           MOVE '2575'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           IF PARM-CUR-HIST NOT = 'H'                                   
              PERFORM 7606-GET-COUNT-LAT-CW-RR   THRU 7606-EXIT         
              PERFORM 7160-OPEN-LAT-CW-RR-CUR    THRU 7160-EXIT         
              PERFORM 7164-FETCH-LAT-CW-RR-CUR   THRU 7164-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7164-FETCH-LAT-CW-RR-CUR THRU 7164-EXIT        
              END-PERFORM                                               
              PERFORM 7168-CLOSE-LAT-CW-RR-CUR   THRU 7168-EXIT         
           ELSE                                                         
              PERFORM 7607-GET-COUNT-LAT-CW-RR-HT THRU 7607-EXIT        
              PERFORM 7170-OPEN-LAT-CW-RR-HT-CUR THRU 7170-EXIT         
              PERFORM 7174-FETCH-LAT-CW-RR-HT-CUR THRU 7174-EXIT        
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7174-FETCH-LAT-CW-RR-HT-CUR THRU 7174-EXIT     
              END-PERFORM                                               
              PERFORM 7178-CLOSE-LAT-CW-RR-HT-CUR THRU 7178-EXIT        
           END-IF.                                                      
                                                                        
       2575-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2600-PROCESS-TYP                                               *        
      *     PROCESS FOR TYP VIEW                                       *        
      ******************************************************************        
                                                                        
       2600-PROCESS-TYP.                                                
                                                                        
           MOVE '2600'              TO ACTIVE-PARAGRAPH.                
                                                                        
           IF PARM-CUR-HIST NOT = 'H'                                   
              PERFORM 7610-GET-COUNT-TYP         THRU 7610-EXIT         
              PERFORM 7200-OPEN-TYP-CUR          THRU 7200-EXIT         
              PERFORM 7204-FETCH-TYP-CUR         THRU 7204-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7204-FETCH-TYP-CUR      THRU 7204-EXIT         
              END-PERFORM                                               
              PERFORM 7208-CLOSE-TYP-CUR         THRU 7208-EXIT         
           ELSE                                                         
              PERFORM 7611-GET-COUNT-TYP-HT      THRU 7611-EXIT         
              PERFORM 7210-OPEN-TYP-HT-CUR       THRU 7210-EXIT         
              PERFORM 7214-FETCH-TYP-HT-CUR      THRU 7214-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7214-FETCH-TYP-HT-CUR THRU 7214-EXIT           
              END-PERFORM                                               
              PERFORM 7218-CLOSE-TYP-HT-CUR      THRU 7218-EXIT         
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2625-PROCESS-TYP-RR                                            *        
      *     PROCESS FOR TYP VIEW                                       *        
      ******************************************************************        
                                                                        
       2625-PROCESS-TYP-RR.                                             
                                                                        
           MOVE '2625'              TO ACTIVE-PARAGRAPH.                
                                                                        
           IF PARM-CUR-HIST NOT = 'H'                                   
              PERFORM 7612-GET-COUNT-TYP-RR      THRU 7612-EXIT         
              PERFORM 7220-OPEN-TYP-RR-CUR       THRU 7220-EXIT         
              PERFORM 7224-FETCH-TYP-RR-CUR      THRU 7224-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7224-FETCH-TYP-RR-CUR   THRU 7224-EXIT         
              END-PERFORM                                               
              PERFORM 7228-CLOSE-TYP-RR-CUR      THRU 7228-EXIT         
           ELSE                                                         
              PERFORM 7613-GET-COUNT-TYP-RR-HT   THRU 7613-EXIT         
              PERFORM 7230-OPEN-TYP-RR-HT-CUR    THRU 7230-EXIT         
              PERFORM 7234-FETCH-TYP-RR-HT-CUR   THRU 7234-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7234-FETCH-TYP-RR-HT-CUR THRU 7234-EXIT        
              END-PERFORM                                               
              PERFORM 7238-CLOSE-TYP-RR-HT-CUR   THRU 7238-EXIT         
           END-IF.                                                      
                                                                        
       2625-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2650-PROCESS-TYP-CW                                            *        
      *     PROCESS FOR TYP VIEW WITH CREW                             *        
      ******************************************************************        
                                                                        
       2650-PROCESS-TYP-CW.                                             
                                                                        
           MOVE '2650'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           IF PARM-CUR-HIST NOT = 'H'                                   
              PERFORM 7614-GET-COUNT-TYP-CW      THRU 7614-EXIT         
              PERFORM 7240-OPEN-TYP-CW-CUR       THRU 7240-EXIT         
              PERFORM 7244-FETCH-TYP-CW-CUR      THRU 7244-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7244-FETCH-TYP-CW-CUR THRU 7244-EXIT           
              END-PERFORM                                               
              PERFORM 7248-CLOSE-TYP-CW-CUR      THRU 7248-EXIT         
           ELSE                                                         
              PERFORM 7615-GET-COUNT-TYP-CW-HT   THRU 7615-EXIT         
              PERFORM 7250-OPEN-TYP-CW-HT-CUR THRU 7250-EXIT            
              PERFORM 7254-FETCH-TYP-CW-HT-CUR THRU 7254-EXIT           
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7254-FETCH-TYP-CW-HT-CUR THRU 7254-EXIT        
              END-PERFORM                                               
              PERFORM 7258-CLOSE-TYP-CW-HT-CUR THRU 7258-EXIT           
           END-IF.                                                      
                                                                        
       2650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2675-PROCESS-TYP-CW-RR                                         *        
      *     PROCESS FOR TYP VIEW WITH CREW                             *        
      ******************************************************************        
                                                                        
       2675-PROCESS-TYP-CW-RR.                                          
                                                                        
           MOVE '2675'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           IF PARM-CUR-HIST NOT = 'H'                                   
              PERFORM 7616-GET-COUNT-TYP-CW-RR   THRU 7616-EXIT         
              PERFORM 7260-OPEN-TYP-CW-RR-CUR    THRU 7260-EXIT         
              PERFORM 7264-FETCH-TYP-CW-RR-CUR   THRU 7264-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7264-FETCH-TYP-CW-RR-CUR THRU 7264-EXIT        
              END-PERFORM                                               
              PERFORM 7268-CLOSE-TYP-CW-RR-CUR   THRU 7268-EXIT         
           ELSE                                                         
              PERFORM 7617-GET-COUNT-TYP-CW-RR-HT THRU 7617-EXIT        
              PERFORM 7270-OPEN-TYP-CW-RR-HT-CUR THRU 7270-EXIT         
              PERFORM 7274-FETCH-TYP-CW-RR-HT-CUR THRU 7274-EXIT        
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7274-FETCH-TYP-CW-RR-HT-CUR THRU 7274-EXIT     
              END-PERFORM                                               
              PERFORM 7278-CLOSE-TYP-CW-RR-HT-CUR THRU 7278-EXIT        
           END-IF.                                                      
                                                                        
       2675-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2700-PROCESS-DTE                                               *        
      *     PROCESS FOR DTE VIEW                                       *        
      ******************************************************************        
                                                                        
       2700-PROCESS-DTE.                                                
                                                                        
           MOVE '2700'              TO ACTIVE-PARAGRAPH.                
                                                                        
           IF PARM-CUR-HIST NOT = 'H'                                   
              PERFORM 7620-GET-COUNT-DTE         THRU 7620-EXIT         
              PERFORM 7300-OPEN-DTE-CUR          THRU 7300-EXIT         
              PERFORM 7304-FETCH-DTE-CUR         THRU 7304-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7304-FETCH-DTE-CUR      THRU 7304-EXIT         
              END-PERFORM                                               
              PERFORM 7308-CLOSE-DTE-CUR         THRU 7308-EXIT         
           ELSE                                                         
              PERFORM 7621-GET-COUNT-DTE-HT      THRU 7621-EXIT         
              PERFORM 7310-OPEN-DTE-HT-CUR       THRU 7310-EXIT         
              PERFORM 7314-FETCH-DTE-HT-CUR      THRU 7314-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7314-FETCH-DTE-HT-CUR THRU 7314-EXIT           
              END-PERFORM                                               
              PERFORM 7318-CLOSE-DTE-HT-CUR      THRU 7318-EXIT         
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2725-PROCESS-DTE-RR                                            *        
      *     PROCESS FOR DTE VIEW                                       *        
      ******************************************************************        
                                                                        
       2725-PROCESS-DTE-RR.                                             
                                                                        
           MOVE '2725'              TO ACTIVE-PARAGRAPH.                
                                                                        
           IF PARM-CUR-HIST NOT = 'H'                                   
              PERFORM 7622-GET-COUNT-DTE-RR      THRU 7622-EXIT         
              PERFORM 7320-OPEN-DTE-RR-CUR       THRU 7320-EXIT         
              PERFORM 7324-FETCH-DTE-RR-CUR      THRU 7324-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7324-FETCH-DTE-RR-CUR   THRU 7324-EXIT         
              END-PERFORM                                               
              PERFORM 7328-CLOSE-DTE-RR-CUR      THRU 7328-EXIT         
           ELSE                                                         
              PERFORM 7623-GET-COUNT-DTE-RR-HT   THRU 7623-EXIT         
              PERFORM 7330-OPEN-DTE-RR-HT-CUR    THRU 7330-EXIT         
              PERFORM 7334-FETCH-DTE-RR-HT-CUR   THRU 7334-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7334-FETCH-DTE-RR-HT-CUR THRU 7334-EXIT        
              END-PERFORM                                               
              PERFORM 7338-CLOSE-DTE-RR-HT-CUR   THRU 7338-EXIT         
           END-IF.                                                      
                                                                        
       2725-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2750-PROCESS-DTE-CW                                            *        
      *     PROCESS FOR DTE VIEW WITH CREW                             *        
      ******************************************************************        
                                                                        
       2750-PROCESS-DTE-CW.                                             
                                                                        
           MOVE '2750'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           IF PARM-CUR-HIST NOT = 'H'                                   
              PERFORM 7624-GET-COUNT-DTE-CW      THRU 7624-EXIT         
              PERFORM 7340-OPEN-DTE-CW-CUR       THRU 7340-EXIT         
              PERFORM 7344-FETCH-DTE-CW-CUR      THRU 7344-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7344-FETCH-DTE-CW-CUR THRU 7344-EXIT           
              END-PERFORM                                               
              PERFORM 7348-CLOSE-DTE-CW-CUR      THRU 7348-EXIT         
           ELSE                                                         
              PERFORM 7625-GET-COUNT-DTE-CW-HT   THRU 7625-EXIT         
              PERFORM 7350-OPEN-DTE-CW-HT-CUR THRU 7350-EXIT            
              PERFORM 7354-FETCH-DTE-CW-HT-CUR THRU 7354-EXIT           
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7354-FETCH-DTE-CW-HT-CUR THRU 7354-EXIT        
              END-PERFORM                                               
              PERFORM 7358-CLOSE-DTE-CW-HT-CUR THRU 7358-EXIT           
           END-IF.                                                      
                                                                        
       2750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2775-PROCESS-DTE-CW-RR                                         *        
      *     PROCESS FOR DTE VIEW WITH CREW                             *        
      ******************************************************************        
                                                                        
       2775-PROCESS-DTE-CW-RR.                                          
                                                                        
           MOVE '2775'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           IF PARM-CUR-HIST NOT = 'H'                                   
              PERFORM 7626-GET-COUNT-DTE-CW-RR   THRU 7626-EXIT         
              PERFORM 7360-OPEN-DTE-CW-RR-CUR    THRU 7360-EXIT         
              PERFORM 7364-FETCH-DTE-CW-RR-CUR   THRU 7364-EXIT         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7364-FETCH-DTE-CW-RR-CUR THRU 7364-EXIT        
              END-PERFORM                                               
              PERFORM 7368-CLOSE-DTE-CW-RR-CUR   THRU 7368-EXIT         
           ELSE                                                         
              PERFORM 7627-GET-COUNT-DTE-CW-RR-HT THRU 7627-EXIT        
              PERFORM 7370-OPEN-DTE-CW-RR-HT-CUR THRU 7370-EXIT         
              PERFORM 7374-FETCH-DTE-CW-RR-HT-CUR THRU 7374-EXIT        
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 PERFORM 2100-MOVE-RESULT        THRU 2100-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 7374-FETCH-DTE-CW-RR-HT-CUR THRU 7374-EXIT     
              END-PERFORM                                               
              PERFORM 7378-CLOSE-DTE-CW-RR-HT-CUR THRU 7378-EXIT        
           END-IF.                                                      
                                                                        
       2775-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2800-UPDATE-RESULT                                             *        
      *     PROCESS TO UPDATE THE RESULT SET TABLE                     *        
      ******************************************************************        
                                                                        
       2800-UPDATE-RESULT.                                              
                                                                        
           MOVE '2800'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           PERFORM 7400-UPDATE-ADDRESS           THRU 7400-EXIT.        
      *    PERFORM 7420-UPDATE-DESCRIPTION       THRU 7420-EXIT                 
           IF PARM-READ-ROUTE = SPACES                                  
              IF PARM-CUR-HIST NOT = 'H'                                
                 PERFORM 7440-UPDATE-READ-ROUTE     THRU 7440-EXIT      
              ELSE                                                      
                 PERFORM 7460-UPDATE-READ-ROUTE-HT  THRU 7460-EXIT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-ORD-CUR                                              *        
      *     OPEN ORD VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7000-OPEN-ORD-CUR.                                               
                                                                        
           MOVE '7000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN ORD-CUR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'ORD-CUR'                  TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-FETCH-ORD-CUR                                             *        
      *     FETCH ORD VIEW CURSOR                                      *        
      ******************************************************************        
                                                                        
       7010-FETCH-ORD-CUR.                                              
                                                                        
           MOVE '7010'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH ORD-CUR                                             
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'ORD-CUR'                  TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-CLOSE-ORD-CUR                                             *        
      *    CLOSE ORD VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7020-CLOSE-ORD-CUR.                                              
                                                                        
           MOVE '7020'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE ORD-CUR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'ORD-CUR'                  TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7025-OPEN-ORD-HT-CUR                                           *        
      *     OPEN ORD VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7025-OPEN-ORD-HT-CUR.                                            
                                                                        
           MOVE '7025'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN ORD-HT-CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'ORD-HT-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7035-FETCH-ORD-HT-CUR                                          *        
      *     FETCH ORD VIEW CURSOR                                      *        
      ******************************************************************        
                                                                        
       7035-FETCH-ORD-HT-CUR.                                           
                                                                        
           MOVE '7035'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH ORD-HT-CUR                                          
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'ORD-HT-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7035-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7045-CLOSE-ORD-HT-CUR                                          *        
      *    CLOSE ORD VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7045-CLOSE-ORD-HT-CUR.                                           
                                                                        
           MOVE '7045'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE ORD-HT-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'ORD-HT-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7045-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-OPEN-LAT-CUR                                              *        
      *     OPEN LAT VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7100-OPEN-LAT-CUR.                                               
                                                                        
           MOVE '7100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN LAT-CUR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CUR'                  TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7104-FETCH-LAT-CUR                                             *        
      *     FETCH LAT VIEW CURSOR                                      *        
      ******************************************************************        
                                                                        
       7104-FETCH-LAT-CUR.                                              
                                                                        
           MOVE '7104'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH LAT-CUR                                             
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CUR'                  TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7104-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7108-CLOSE-LAT-CUR                                             *        
      *    CLOSE LAT VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7108-CLOSE-LAT-CUR.                                              
                                                                        
           MOVE '7108'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE LAT-CUR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CUR'                  TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7108-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-OPEN-LAT-HT-CUR                                           *        
      *     OPEN LAT VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7110-OPEN-LAT-HT-CUR.                                            
                                                                        
           MOVE '7110'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN LAT-HT-CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-HT-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7114-FETCH-LAT-HT-CUR                                          *        
      *     FETCH LAT VIEW CURSOR                                      *        
      ******************************************************************        
                                                                        
       7114-FETCH-LAT-HT-CUR.                                           
                                                                        
           MOVE '7114'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH LAT-HT-CUR                                          
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-HT-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7114-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7118-CLOSE-LAT-HT-CUR                                          *        
      *    CLOSE LAT VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7118-CLOSE-LAT-HT-CUR.                                           
                                                                        
           MOVE '7118'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE LAT-HT-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-HT-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7118-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7120-OPEN-LAT-RR-CUR                                           *        
      *     OPEN LAT VIEW CURSOR WITH READ ROUTE                       *        
      ******************************************************************        
                                                                        
       7120-OPEN-LAT-RR-CUR.                                            
                                                                        
           MOVE '7120'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN LAT-RR-CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-RR-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7124-FETCH-LAT-RR-CUR                                          *        
      *     FETCH LAT VIEW CURSOR WITH READ ROUTE                      *        
      ******************************************************************        
                                                                        
       7124-FETCH-LAT-RR-CUR.                                           
                                                                        
           MOVE '7124'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH LAT-RR-CUR                                          
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-RR-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7124-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7128-CLOSE-LAT-RR-CUR                                          *        
      *    CLOSE LAT VIEW CURSOR WITH READ ROUTE                       *        
      ******************************************************************        
                                                                        
       7128-CLOSE-LAT-RR-CUR.                                           
                                                                        
           MOVE '7128'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE LAT-RR-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-RR-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7128-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7130-OPEN-LAT-RR-HT-CUR                                        *        
      *     OPEN LAT VIEW CURSOR WITH READ ROUTE                       *        
      ******************************************************************        
                                                                        
       7130-OPEN-LAT-RR-HT-CUR.                                         
                                                                        
           MOVE '7130'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN LAT-RR-HT-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-RR-HT-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7134-FETCH-LAT-RR-HT-CUR                                       *        
      *     FETCH LAT VIEW CURSOR WITH READ ROUTE                      *        
      ******************************************************************        
                                                                        
       7134-FETCH-LAT-RR-HT-CUR.                                        
                                                                        
           MOVE '7134'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH LAT-RR-HT-CUR                                       
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-RR-HT-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7134-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7138-CLOSE-LAT-RR-HT-CUR                                       *        
      *    CLOSE LAT VIEW CURSOR WITH READ ROUTE                       *        
      ******************************************************************        
                                                                        
       7138-CLOSE-LAT-RR-HT-CUR.                                        
                                                                        
           MOVE '7138'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE LAT-RR-HT-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-RR-HT-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7138-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7140-OPEN-LAT-CW-CUR                                           *        
      *     OPEN LAT VIEW CURSOR WITH CREW                             *        
      ******************************************************************        
                                                                        
       7140-OPEN-LAT-CW-CUR.                                            
                                                                        
           MOVE '7140'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN LAT-CW-CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CW-CUR'                  TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7144-FETCH-LAT-CW-CUR                                          *        
      *     FETCH LAT VIEW CURSOR WITH CREW                            *        
      ******************************************************************        
                                                                        
       7144-FETCH-LAT-CW-CUR.                                           
                                                                        
           MOVE '7144'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH LAT-CW-CUR                                          
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CW-CUR'                  TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7144-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7148-CLOSE-LAT-CW-CUR                                          *        
      *    CLOSE LAT VIEW CURSOR WITH CREW                             *        
      ******************************************************************        
                                                                        
       7148-CLOSE-LAT-CW-CUR.                                           
                                                                        
           MOVE '7148'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE LAT-CW-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CW-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7148-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-OPEN-LAT-CW-HT-CUR                                        *        
      *     OPEN LAT VIEW CURSOR WITH CREW                             *        
      ******************************************************************        
                                                                        
       7150-OPEN-LAT-CW-HT-CUR.                                         
                                                                        
           MOVE '7150'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN LAT-CW-HT-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CW-HT-CUR'               TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7154-FETCH-LAT-CW-HT-CUR                                       *        
      *     FETCH LAT VIEW CURSOR WITH CREW                            *        
      ******************************************************************        
                                                                        
       7154-FETCH-LAT-CW-HT-CUR.                                        
                                                                        
           MOVE '7154'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH LAT-CW-HT-CUR                                       
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CW-HT-CUR'               TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7154-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7158-CLOSE-LAT-CW-HT-CUR                                       *        
      *    CLOSE LAT VIEW CURSOR WITH CREW                             *        
      ******************************************************************        
                                                                        
       7158-CLOSE-LAT-CW-HT-CUR.                                        
                                                                        
           MOVE '7158'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE LAT-CW-HT-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CW-HT-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7158-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7160-OPEN-LAT-CW-RR-CUR                                        *        
      *     OPEN LAT VIEW CURSOR WITH CREW AND READ ROUTE              *        
      ******************************************************************        
                                                                        
       7160-OPEN-LAT-CW-RR-CUR.                                         
                                                                        
           MOVE '7160'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN LAT-CW-RR-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CW-RR-CUR'               TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7164-FETCH-LAT-CW-RR-CUR                                       *        
      *     FETCH LAT VIEW CURSOR WITH CREW AND READ ROUTE             *        
      ******************************************************************        
                                                                        
       7164-FETCH-LAT-CW-RR-CUR.                                        
                                                                        
           MOVE '7164'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH LAT-CW-RR-CUR                                       
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CW-RR-CUR'               TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7164-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7168-CLOSE-LAT-CW-RR-CUR                                       *        
      *    CLOSE LAT VIEW CURSOR WITH CREW AND READ ROUTE              *        
      ******************************************************************        
                                                                        
       7168-CLOSE-LAT-CW-RR-CUR.                                        
                                                                        
           MOVE '7168'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE LAT-CW-RR-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CW-RR-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7168-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7170-OPEN-LAT-CW-RR-HT-CUR                                     *        
      *     OPEN LAT VIEW CURSOR WITH CREW AND READ ROUTE              *        
      ******************************************************************        
                                                                        
       7170-OPEN-LAT-CW-RR-HT-CUR.                                      
                                                                        
           MOVE '7170'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN LAT-CW-RR-HT-CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CW-RR-HT-CUR'            TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7174-FETCH-LAT-CW-RR-HT-CUR                                    *        
      *     FETCH LAT VIEW CURSOR WITH CREW AND READ ROUTE             *        
      ******************************************************************        
                                                                        
       7174-FETCH-LAT-CW-RR-HT-CUR.                                     
                                                                        
           MOVE '7174'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH LAT-CW-RR-HT-CUR                                    
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CW-RR-HT-CUR'            TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7174-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7178-CLOSE-LAT-CW-RR-HT-CUR                                    *        
      *    CLOSE LAT VIEW CURSOR WITH CREW AND READ ROUTE              *        
      ******************************************************************        
                                                                        
       7178-CLOSE-LAT-CW-RR-HT-CUR.                                     
                                                                        
           MOVE '7178'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE LAT-CW-RR-HT-CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'LAT-CW-RR-HT-CUR'         TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7178-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-OPEN-TYP-CUR                                              *        
      *     OPEN TYP VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7200-OPEN-TYP-CUR.                                               
                                                                        
           MOVE '7200'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN TYP-CUR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CUR'                  TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7204-FETCH-TYP-CUR                                             *        
      *     FETCH TYP VIEW CURSOR                                      *        
      ******************************************************************        
                                                                        
       7204-FETCH-TYP-CUR.                                              
                                                                        
           MOVE '7204'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH TYP-CUR                                             
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CUR'                  TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7204-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7208-CLOSE-TYP-CUR                                             *        
      *    CLOSE TYP VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7208-CLOSE-TYP-CUR.                                              
                                                                        
           MOVE '7208'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE TYP-CUR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CUR'                  TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7208-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7210-OPEN-TYP-HT-CUR                                           *        
      *     OPEN TYP VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7210-OPEN-TYP-HT-CUR.                                            
                                                                        
           MOVE '7210'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN TYP-HT-CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-HT-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7214-FETCH-TYP-HT-CUR                                          *        
      *     FETCH TYP VIEW CURSOR                                      *        
      ******************************************************************        
                                                                        
       7214-FETCH-TYP-HT-CUR.                                           
                                                                        
           MOVE '7214'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH TYP-HT-CUR                                          
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-HT-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7214-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7218-CLOSE-TYP-HT-CUR                                          *        
      *    CLOSE TYP VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7218-CLOSE-TYP-HT-CUR.                                           
                                                                        
           MOVE '7218'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE TYP-HT-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-HT-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7218-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7220-OPEN-TYP-RR-CUR                                           *        
      *     OPEN TYP VIEW CURSOR WITH READ ROUTE                       *        
      ******************************************************************        
                                                                        
       7220-OPEN-TYP-RR-CUR.                                            
                                                                        
           MOVE '7220'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN TYP-RR-CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-RR-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7224-FETCH-TYP-RR-CUR                                          *        
      *     FETCH TYP VIEW CURSOR WITH READ ROUTE                      *        
      ******************************************************************        
                                                                        
       7224-FETCH-TYP-RR-CUR.                                           
                                                                        
           MOVE '7224'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH TYP-RR-CUR                                          
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-RR-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7224-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7228-CLOSE-TYP-RR-CUR                                          *        
      *    CLOSE TYP VIEW CURSOR WITH READ ROUTE                       *        
      ******************************************************************        
                                                                        
       7228-CLOSE-TYP-RR-CUR.                                           
                                                                        
           MOVE '7228'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE TYP-RR-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-RR-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7228-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7230-OPEN-TYP-RR-HT-CUR                                        *        
      *     OPEN TYP VIEW CURSOR WITH READ ROUTE                       *        
      ******************************************************************        
                                                                        
       7230-OPEN-TYP-RR-HT-CUR.                                         
                                                                        
           MOVE '7230'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN TYP-RR-HT-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-RR-HT-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7234-FETCH-TYP-RR-HT-CUR                                       *        
      *     FETCH TYP VIEW CURSOR WITH READ ROUTE                      *        
      ******************************************************************        
                                                                        
       7234-FETCH-TYP-RR-HT-CUR.                                        
                                                                        
           MOVE '7234'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH TYP-RR-HT-CUR                                       
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-RR-HT-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7234-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7238-CLOSE-TYP-RR-HT-CUR                                       *        
      *    CLOSE TYP VIEW CURSOR WITH READ ROUTE                       *        
      ******************************************************************        
                                                                        
       7238-CLOSE-TYP-RR-HT-CUR.                                        
                                                                        
           MOVE '7238'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE TYP-RR-HT-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-RR-HT-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7238-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7240-OPEN-TYP-CW-CUR                                           *        
      *     OPEN TYP VIEW CURSOR WITH CREW                             *        
      ******************************************************************        
                                                                        
       7240-OPEN-TYP-CW-CUR.                                            
                                                                        
           MOVE '7240'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN TYP-CW-CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CW-CUR'                  TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7244-FETCH-TYP-CW-CUR                                          *        
      *     FETCH TYP VIEW CURSOR WITH CREW                            *        
      ******************************************************************        
                                                                        
       7244-FETCH-TYP-CW-CUR.                                           
                                                                        
           MOVE '7244'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH TYP-CW-CUR                                          
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CW-CUR'                  TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7244-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7248-CLOSE-TYP-CW-CUR                                          *        
      *    CLOSE TYP VIEW CURSOR WITH CREW                             *        
      ******************************************************************        
                                                                        
       7248-CLOSE-TYP-CW-CUR.                                           
                                                                        
           MOVE '7248'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE TYP-CW-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CW-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7248-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7250-OPEN-TYP-CW-HT-CUR                                        *        
      *     OPEN TYP VIEW CURSOR WITH CREW                             *        
      ******************************************************************        
                                                                        
       7250-OPEN-TYP-CW-HT-CUR.                                         
                                                                        
           MOVE '7250'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN TYP-CW-HT-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CW-HT-CUR'               TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7254-FETCH-TYP-CW-HT-CUR                                       *        
      *     FETCH TYP VIEW CURSOR WITH CREW                            *        
      ******************************************************************        
                                                                        
       7254-FETCH-TYP-CW-HT-CUR.                                        
                                                                        
           MOVE '7254'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH TYP-CW-HT-CUR                                       
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CW-HT-CUR'               TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7254-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7258-CLOSE-TYP-CW-HT-CUR                                       *        
      *    CLOSE TYP VIEW CURSOR WITH CREW                             *        
      ******************************************************************        
                                                                        
       7258-CLOSE-TYP-CW-HT-CUR.                                        
                                                                        
           MOVE '7258'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE TYP-CW-HT-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CW-HT-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7258-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7260-OPEN-TYP-CW-RR-CUR                                        *        
      *     OPEN TYP VIEW CURSOR WITH CREW AND READ ROUTE              *        
      ******************************************************************        
                                                                        
       7260-OPEN-TYP-CW-RR-CUR.                                         
                                                                        
           MOVE '7260'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN TYP-CW-RR-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CW-RR-CUR'               TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7264-FETCH-TYP-CW-RR-CUR                                       *        
      *     FETCH TYP VIEW CURSOR WITH CREW AND READ ROUTE             *        
      ******************************************************************        
                                                                        
       7264-FETCH-TYP-CW-RR-CUR.                                        
                                                                        
           MOVE '7264'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH TYP-CW-RR-CUR                                       
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CW-RR-CUR'               TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7264-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7268-CLOSE-TYP-CW-RR-CUR                                       *        
      *    CLOSE TYP VIEW CURSOR WITH CREW AND READ ROUTE              *        
      ******************************************************************        
                                                                        
       7268-CLOSE-TYP-CW-RR-CUR.                                        
                                                                        
           MOVE '7268'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE TYP-CW-RR-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CW-RR-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7268-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7270-OPEN-TYP-CW-RR-HT-CUR                                     *        
      *     OPEN TYP VIEW CURSOR WITH CREW AND READ ROUTE              *        
      ******************************************************************        
                                                                        
       7270-OPEN-TYP-CW-RR-HT-CUR.                                      
                                                                        
           MOVE '7270'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN TYP-CW-RR-HT-CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CW-RR-HT-CUR'            TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7274-FETCH-TYP-CW-RR-HT-CUR                                    *        
      *     FETCH TYP VIEW CURSOR WITH CREW AND READ ROUTE             *        
      ******************************************************************        
                                                                        
       7274-FETCH-TYP-CW-RR-HT-CUR.                                     
                                                                        
           MOVE '7274'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH TYP-CW-RR-HT-CUR                                    
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CW-RR-HT-CUR'            TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7274-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7278-CLOSE-TYP-CW-RR-HT-CUR                                    *        
      *    CLOSE TYP VIEW CURSOR WITH CREW AND READ ROUTE              *        
      ******************************************************************        
                                                                        
       7278-CLOSE-TYP-CW-RR-HT-CUR.                                     
                                                                        
           MOVE '7278'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE TYP-CW-RR-HT-CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'TYP-CW-RR-HT-CUR'         TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7278-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-OPEN-DTE-CUR                                              *        
      *     OPEN DTE VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7300-OPEN-DTE-CUR.                                               
                                                                        
           MOVE '7300'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN DTE-CUR                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CUR'                  TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7304-FETCH-DTE-CUR                                             *        
      *     FETCH DTE VIEW CURSOR                                      *        
      ******************************************************************        
                                                                        
       7304-FETCH-DTE-CUR.                                              
                                                                        
           MOVE '7304'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH DTE-CUR                                             
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CUR'                  TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7304-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7308-CLOSE-DTE-CUR                                             *        
      *    CLOSE DTE VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7308-CLOSE-DTE-CUR.                                              
                                                                        
           MOVE '7308'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE DTE-CUR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CUR'                  TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7308-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7310-OPEN-DTE-HT-CUR                                           *        
      *     OPEN DTE VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7310-OPEN-DTE-HT-CUR.                                            
                                                                        
           MOVE '7310'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN DTE-HT-CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-HT-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7314-FETCH-DTE-HT-CUR                                          *        
      *     FETCH DTE VIEW CURSOR                                      *        
      ******************************************************************        
                                                                        
       7314-FETCH-DTE-HT-CUR.                                           
                                                                        
           MOVE '7314'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH DTE-HT-CUR                                          
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-HT-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7314-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7318-CLOSE-DTE-HT-CUR                                          *        
      *    CLOSE DTE VIEW CURSOR                                       *        
      ******************************************************************        
                                                                        
       7318-CLOSE-DTE-HT-CUR.                                           
                                                                        
           MOVE '7318'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE DTE-HT-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-HT-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7318-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7320-OPEN-DTE-RR-CUR                                           *        
      *     OPEN DTE VIEW CURSOR WITH READ ROUTE                       *        
      ******************************************************************        
                                                                        
       7320-OPEN-DTE-RR-CUR.                                            
                                                                        
           MOVE '7320'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN DTE-RR-CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-RR-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7324-FETCH-DTE-RR-CUR                                          *        
      *     FETCH DTE VIEW CURSOR WITH READ ROUTE                      *        
      ******************************************************************        
                                                                        
       7324-FETCH-DTE-RR-CUR.                                           
                                                                        
           MOVE '7324'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH DTE-RR-CUR                                          
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317*            ,:VO-ORDER-RECVED-BY                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-RR-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7324-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7328-CLOSE-DTE-RR-CUR                                          *        
      *    CLOSE DTE VIEW CURSOR WITH READ ROUTE                       *        
      ******************************************************************        
                                                                        
       7328-CLOSE-DTE-RR-CUR.                                           
                                                                        
           MOVE '7328'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE DTE-RR-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-RR-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7328-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7330-OPEN-DTE-RR-HT-CUR                                        *        
      *     OPEN DTE VIEW CURSOR WITH READ ROUTE                       *        
      ******************************************************************        
                                                                        
       7330-OPEN-DTE-RR-HT-CUR.                                         
                                                                        
           MOVE '7330'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN DTE-RR-HT-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-RR-HT-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7334-FETCH-DTE-RR-HT-CUR                                       *        
      *     FETCH DTE VIEW CURSOR WITH READ ROUTE                      *        
      ******************************************************************        
                                                                        
       7334-FETCH-DTE-RR-HT-CUR.                                        
                                                                        
           MOVE '7334'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH DTE-RR-HT-CUR                                       
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-RR-HT-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7334-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7338-CLOSE-DTE-RR-HT-CUR                                       *        
      *    CLOSE DTE VIEW CURSOR WITH READ ROUTE                       *        
      ******************************************************************        
                                                                        
       7338-CLOSE-DTE-RR-HT-CUR.                                        
                                                                        
           MOVE '7338'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE DTE-RR-HT-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-RR-HT-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7338-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7340-OPEN-DTE-CW-CUR                                           *        
      *     OPEN DTE VIEW CURSOR WITH CREW                             *        
      ******************************************************************        
                                                                        
       7340-OPEN-DTE-CW-CUR.                                            
                                                                        
           MOVE '7340'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN DTE-CW-CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CW-CUR'                  TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7344-FETCH-DTE-CW-CUR                                          *        
      *     FETCH DTE VIEW CURSOR WITH CREW                            *        
      ******************************************************************        
                                                                        
       7344-FETCH-DTE-CW-CUR.                                           
                                                                        
           MOVE '7344'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH DTE-CW-CUR                                          
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CW-CUR'                  TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7344-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7348-CLOSE-DTE-CW-CUR                                          *        
      *    CLOSE DTE VIEW CURSOR WITH CREW                             *        
      ******************************************************************        
                                                                        
       7348-CLOSE-DTE-CW-CUR.                                           
                                                                        
           MOVE '7348'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE DTE-CW-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CW-CUR'               TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7348-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7350-OPEN-DTE-CW-HT-CUR                                        *        
      *     OPEN DTE VIEW CURSOR WITH CREW                             *        
      ******************************************************************        
                                                                        
       7350-OPEN-DTE-CW-HT-CUR.                                         
                                                                        
           MOVE '7350'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN DTE-CW-HT-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CW-HT-CUR'               TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7354-FETCH-DTE-CW-HT-CUR                                       *        
      *     FETCH DTE VIEW CURSOR WITH CREW                            *        
      ******************************************************************        
                                                                        
       7354-FETCH-DTE-CW-HT-CUR.                                        
                                                                        
           MOVE '7354'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH DTE-CW-HT-CUR                                       
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CW-HT-CUR'               TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7354-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7358-CLOSE-DTE-CW-HT-CUR                                       *        
      *    CLOSE DTE VIEW CURSOR WITH CREW                             *        
      ******************************************************************        
                                                                        
       7358-CLOSE-DTE-CW-HT-CUR.                                        
                                                                        
           MOVE '7358'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE DTE-CW-HT-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CW-HT-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7358-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7360-OPEN-DTE-CW-RR-CUR                                        *        
      *     OPEN DTE VIEW CURSOR WITH CREW AND READ ROUTE              *        
      ******************************************************************        
                                                                        
       7360-OPEN-DTE-CW-RR-CUR.                                         
                                                                        
           MOVE '7360'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN DTE-CW-RR-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CW-RR-CUR'               TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7364-FETCH-DTE-CW-RR-CUR                                       *        
      *     FETCH DTE VIEW CURSOR WITH CREW AND READ ROUTE             *        
      ******************************************************************        
                                                                        
       7364-FETCH-DTE-CW-RR-CUR.                                        
                                                                        
           MOVE '7364'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH DTE-CW-RR-CUR                                       
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CW-RR-CUR'               TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7364-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7368-CLOSE-DTE-CW-RR-CUR                                       *        
      *    CLOSE DTE VIEW CURSOR WITH CREW AND READ ROUTE              *        
      ******************************************************************        
                                                                        
       7368-CLOSE-DTE-CW-RR-CUR.                                        
                                                                        
           MOVE '7368'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE DTE-CW-RR-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CW-RR-CUR'            TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7368-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7370-OPEN-DTE-CW-RR-HT-CUR                                     *        
      *     OPEN DTE VIEW CURSOR WITH CREW AND READ ROUTE              *        
      ******************************************************************        
                                                                        
       7370-OPEN-DTE-CW-RR-HT-CUR.                                      
                                                                        
           MOVE '7370'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN DTE-CW-RR-HT-CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CW-RR-HT-CUR'            TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7370-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7374-FETCH-DTE-CW-RR-HT-CUR                                    *        
      *     FETCH DTE VIEW CURSOR WITH CREW AND READ ROUTE             *        
      ******************************************************************        
                                                                        
       7374-FETCH-DTE-CW-RR-HT-CUR.                                     
                                                                        
           MOVE '7374'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH DTE-CW-RR-HT-CUR                                    
              INTO  :C2-ORDER-TYPE-DESC                                 
                   ,:L4-WORK-TYPE-DESC                                  
                   ,:VI-CODE-UTIL-TYPE                                  
                   ,:VO-ASSIGNED-DATETIME :IV-ASSGN-DT                 
                   ,:R6-STATUS-TX                                       
                   ,:VO-ORDER-STATE-CD                                  
                   ,:VO-BEGIN-APPT-DT :IV-BEGIN-APPT-DT            
                   ,:VO-END-APPT-DT :IV-END-APPT-DT              
                   ,:VO-DATE-PRINTED :IV-PRNTD-DT                 
                   ,:VO-COMPLETED-DATETIME :IV-COMP-DT                  
                   ,:VO-SERV-ORDER-NO                                   
                   ,:VO-ACCOUNT-NO                                      
                   ,:VO-ORDER-TYPE-CD                                   
                   ,:VO-COMPANY-NO                                      
                   ,:VO-LOCAL-OFFICE                                    
                   ,:VO-ACCOUNT-NO-PRIOR                                
                   ,:VO-PREMISE-NO                                      
                   ,:C2-ORDER-GROUP-CD                                  
                   ,:VO-SERV-ORDER-STATUS                               
                   ,:VO-DATE-RECVED :IV-RECVD-DT                 
                   ,:VE-READ-ROUTE                                      
                   ,:VT-READ-ROUTE                                      
A05317             ,:VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CW-RR-HT-CUR'            TO TABLE-1             
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7374-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7378-CLOSE-DTE-CW-RR-HT-CUR                                    *        
      *    CLOSE DTE VIEW CURSOR WITH CREW AND READ ROUTE              *        
      ******************************************************************        
                                                                        
       7378-CLOSE-DTE-CW-RR-HT-CUR.                                     
                                                                        
           MOVE '7378'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE DTE-CW-RR-HT-CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'DTE-CW-RR-HT-CUR'         TO TABLE-1                
              MOVE 'SERV NUMBR'               TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7378-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-UPDATE-ADDRESS                                            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7400-UPDATE-ADDRESS.                                             
                                                                        
           MOVE '7400'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               UPDATE                                                   
                    FS                               
               SET                                                      
               ADDRESS = (SELECT RTRIM(DY.HOUSE_NO) + RTRIM(
           DY.ADDR_PREFIX_1) + ' ' + RTRIM(DY.ADDR_PREFIX_2) + ' ' + 
           RTRIM(DY.STREET_NAME) + ' ' + RTRIM(DY.STREET_SUFFIX) + 
           ' ' + RTRIM(DY.STREET_LOCATION_1) + ' ' + RTRIM(
           DY.STREET_LOCATION_2)
            FROM                                                
                         CSS_NAME            DQ                         
                        ,CSS_NAME_ACCT_XREF  HT                         
                        ,CSS_ADDR_FORMATTED  DY
            WHERE                                               
                        HT.ACCOUNT_NO       = FS.ACCOUNT_NO             
                    AND HT.ACCOUNT_NO       > 0                         
                    AND HT.NAME_ID          = DQ.NAME_ID                
                    AND DQ.NAME_TYPE        = 'CN'                      
                    AND HT.CUSTOMER_ROLE_CD = ' '                       
                    AND HT.ADDRESS_ID       = DY.ADDRESS_ID),
               FULL_NAME = (SELECT LEFT( RTRIM(DQ.FULL_NAME), 70 )
            FROM                                                
                         CSS_NAME            DQ                         
                        ,CSS_NAME_ACCT_XREF  HT                         
                        ,CSS_ADDR_FORMATTED  DY
            WHERE                                               
                        HT.ACCOUNT_NO       = FS.ACCOUNT_NO             
                    AND HT.ACCOUNT_NO       > 0                         
                    AND HT.NAME_ID          = DQ.NAME_ID                
                    AND DQ.NAME_TYPE        = 'CN'                      
                    AND HT.CUSTOMER_ROLE_CD = ' '                       
                    AND HT.ADDRESS_ID       = DY.ADDRESS_ID),
               FIRST_NAME = (SELECT DQ.FIRST_NAME
            FROM                                                
                         CSS_NAME            DQ                         
                        ,CSS_NAME_ACCT_XREF  HT                         
                        ,CSS_ADDR_FORMATTED  DY
            WHERE                                               
                        HT.ACCOUNT_NO       = FS.ACCOUNT_NO             
                    AND HT.ACCOUNT_NO       > 0                         
                    AND HT.NAME_ID          = DQ.NAME_ID                
                    AND DQ.NAME_TYPE        = 'CN'                      
                    AND HT.CUSTOMER_ROLE_CD = ' '                       
                    AND HT.ADDRESS_ID       = DY.ADDRESS_ID),
               MIDDLE_NAME = (SELECT DQ.MIDDLE_NAME
            FROM                                                
                         CSS_NAME            DQ                         
                        ,CSS_NAME_ACCT_XREF  HT                         
                        ,CSS_ADDR_FORMATTED  DY
            WHERE                                               
                        HT.ACCOUNT_NO       = FS.ACCOUNT_NO             
                    AND HT.ACCOUNT_NO       > 0                         
                    AND HT.NAME_ID          = DQ.NAME_ID                
                    AND DQ.NAME_TYPE        = 'CN'                      
                    AND HT.CUSTOMER_ROLE_CD = ' '                       
                    AND HT.ADDRESS_ID       = DY.ADDRESS_ID),
               LAST_NAME = (SELECT LEFT( RTRIM(DQ.LAST_NAME), 40 )
            FROM                                                
                         CSS_NAME            DQ                         
                        ,CSS_NAME_ACCT_XREF  HT                         
                        ,CSS_ADDR_FORMATTED  DY
            WHERE                                               
                        HT.ACCOUNT_NO       = FS.ACCOUNT_NO             
                    AND HT.ACCOUNT_NO       > 0                         
                    AND HT.NAME_ID          = DQ.NAME_ID                
                    AND DQ.NAME_TYPE        = 'CN'                      
                    AND HT.CUSTOMER_ROLE_CD = ' '                       
                    AND HT.ADDRESS_ID       = DY.ADDRESS_ID),
               NAME_FORMAT = (SELECT DQ.NAME_FORMAT
            FROM                                                
                         CSS_NAME            DQ                         
                        ,CSS_NAME_ACCT_XREF  HT                         
                        ,CSS_ADDR_FORMATTED  DY
            WHERE                                               
                        HT.ACCOUNT_NO       = FS.ACCOUNT_NO             
                    AND HT.ACCOUNT_NO       > 0                         
                    AND HT.NAME_ID          = DQ.NAME_ID                
                    AND DQ.NAME_TYPE        = 'CN'                      
                    AND HT.CUSTOMER_ROLE_CD = ' '                       
                    AND HT.ADDRESS_ID       = DY.ADDRESS_ID),
               CUSTOMER_NO = (SELECT HT.CUSTOMER_NO
            FROM                                                
                         CSS_NAME            DQ                         
                        ,CSS_NAME_ACCT_XREF  HT                         
                        ,CSS_ADDR_FORMATTED  DY
            WHERE                                               
                        HT.ACCOUNT_NO       = FS.ACCOUNT_NO             
                    AND HT.ACCOUNT_NO       > 0                         
                    AND HT.NAME_ID          = DQ.NAME_ID                
                    AND DQ.NAME_TYPE        = 'CN'                      
                    AND HT.CUSTOMER_ROLE_CD = ' '                       
                    AND HT.ADDRESS_ID       = DY.ADDRESS_ID),
               ZIP_CODE = (SELECT DY.ZIP_CODE
            FROM                                                
                         CSS_NAME            DQ                         
                        ,CSS_NAME_ACCT_XREF  HT                         
                        ,CSS_ADDR_FORMATTED  DY
            WHERE                                               
                        HT.ACCOUNT_NO       = FS.ACCOUNT_NO             
                    AND HT.ACCOUNT_NO       > 0                         
                    AND HT.NAME_ID          = DQ.NAME_ID                
                    AND DQ.NAME_TYPE        = 'CN'                      
                    AND HT.CUSTOMER_ROLE_CD = ' '                       
                    AND HT.ADDRESS_ID       = DY.ADDRESS_ID)                    
               FROM #CSR01153_R1 FS
                WHERE                                                   
                    FS.ACCOUNT_NO > 0                                   
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR* MSQ055
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE                                                           
MFA-TR*             SESSION.CSR01153_R1 FS                                      
MFA-TR*        SET                                                              
MFA-TR*        (    ADDRESS                                                     
MFA-TR*            ,FULL_NAME                                                   
MFA-TR*            ,FIRST_NAME                                                  
MFA-TR*            ,MIDDLE_NAME                                                 
MFA-TR*            ,LAST_NAME                                                   
MFA-TR*            ,NAME_FORMAT                                                 
MFA-TR*            ,CUSTOMER_NO                                                 
MFA-TR*            ,ZIP_CODE                                                    
MFA-TR*         ) =                                                             
MFA-TR*         (                                                               
MFA-TR*             SELECT                                                      
MFA-TR*                  RTRIM(DY.HOUSE_NO)          ||                         
MFA-TR*                  RTRIM(DY.ADDR_PREFIX_1)     || ' ' ||                  
MFA-TR*                  RTRIM(DY.ADDR_PREFIX_2)     || ' ' ||                  
MFA-TR*                  RTRIM(DY.STREET_NAME)       || ' ' ||                  
MFA-TR*                  RTRIM(DY.STREET_SUFFIX)     || ' ' ||                  
MFA-TR*                  RTRIM(DY.STREET_LOCATION_1) || ' ' ||                  
MFA-TR*                  RTRIM(DY.STREET_LOCATION_2)                            
MFA-TR*                 ,LEFT(RTRIM(DQ.FULL_NAME),70)                           
MFA-TR*                 ,DQ.FIRST_NAME                                          
MFA-TR*                 ,DQ.MIDDLE_NAME                                         
MFA-TR*                 ,LEFT(RTRIM(DQ.LAST_NAME),40)                           
MFA-TR*                 ,DQ.NAME_FORMAT                                         
MFA-TR*                 ,HT.CUSTOMER_NO                                         
MFA-TR*                 ,DY.ZIP_CODE                                            
MFA-TR*             FROM                                                        
MFA-TR*                  CSS_NAME            DQ                                 
MFA-TR*                 ,CSS_NAME_ACCT_XREF  HT                                 
MFA-TR*                 ,CSS_ADDR_FORMATTED  DY                                 
MFA-TR*             WHERE                                                       
MFA-TR*                 HT.ACCOUNT_NO       = FS.ACCOUNT_NO                     
MFA-TR*             AND HT.ACCOUNT_NO       > 0                                 
MFA-TR*             AND HT.NAME_ID          = DQ.NAME_ID                        
MFA-TR*             AND DQ.NAME_TYPE        = 'CN'                              
MFA-TR*             AND HT.CUSTOMER_ROLE_CD = ' '                               
MFA-TR*             AND HT.ADDRESS_ID       = DY.ADDRESS_ID                     
MFA-TR*         )                                                               
MFA-TR*         WHERE                                                           
MFA-TR*             FS.ACCOUNT_NO > 0                                           
MFA-TR*         QUERYNO 74001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'R1 ADD FRMT'              TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR01153_R1'              TO TABLE-1                
              MOVE 'FULL_NAME'                TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              UPDATE                                                    
                   FS                                
              SET                                                       
              ADDRESS = (SELECT RTRIM(DY.HOUSE_NO) + RTRIM(
           DY.ADDR_PREFIX_1) + ' ' + RTRIM(DY.ADDR_PREFIX_2) + ' ' + 
           RTRIM(DY.STREET_NAME) + ' ' + RTRIM(DY.STREET_SUFFIX) + 
           ' ' + RTRIM(DY.STREET_LOCATION_1) + ' ' + RTRIM(
           DY.STREET_LOCATION_2)
            FROM                                                 
                       CSS_ADDR_FORMATTED DY                            
                      ,CSS_PREMISE        PO
            WHERE                                                
                       FS.ACCOUNT_NO = 0                                
                   AND FS.PREMISE_NO = PO.PREMISE_NO                    
                   AND DY.ADDRESS_ID = PO.ADDRESS_ID),
               ZIP_CODE = (SELECT DY.ZIP_CODE
            FROM                                                 
                       CSS_ADDR_FORMATTED DY                            
                      ,CSS_PREMISE        PO
            WHERE                                                
                       FS.ACCOUNT_NO = 0                                
                   AND FS.PREMISE_NO = PO.PREMISE_NO                    
                   AND DY.ADDRESS_ID = PO.ADDRESS_ID)                           
              FROM #CSR01153_R1 FS
              WHERE                                                     
                  FS.ACCOUNT_NO = 0                                     
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR* MSQ055
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE                                                            
MFA-TR*            SESSION.CSR01153_R1 FS                                       
MFA-TR*       SET                                                               
MFA-TR*       (                                                                 
MFA-TR*            ADDRESS                                                      
MFA-TR*           ,ZIP_CODE                                                     
MFA-TR*       )                                                                 
MFA-TR*       =                                                                 
MFA-TR*       (    SELECT                                                       
MFA-TR*                RTRIM(DY.HOUSE_NO)           ||                          
MFA-TR*                RTRIM(DY.ADDR_PREFIX_1)      || ' ' ||                   
MFA-TR*                RTRIM(DY.ADDR_PREFIX_2)      || ' ' ||                   
MFA-TR*                RTRIM(DY.STREET_NAME)        || ' ' ||                   
MFA-TR*                RTRIM(DY.STREET_SUFFIX)      || ' ' ||                   
MFA-TR*                RTRIM(DY.STREET_LOCATION_1)  || ' ' ||                   
MFA-TR*                RTRIM(DY.STREET_LOCATION_2)                              
MFA-TR*               ,DY.ZIP_CODE                                              
MFA-TR*            FROM                                                         
MFA-TR*                CSS_ADDR_FORMATTED DY                                    
MFA-TR*               ,CSS_PREMISE        PO                                    
MFA-TR*            WHERE                                                        
MFA-TR*                FS.ACCOUNT_NO = 0                                        
MFA-TR*            AND FS.PREMISE_NO = PO.PREMISE_NO                            
MFA-TR*            AND DY.ADDRESS_ID = PO.ADDRESS_ID                            
MFA-TR*       )                                                                 
MFA-TR*       WHERE                                                             
MFA-TR*           FS.ACCOUNT_NO = 0                                             
MFA-TR*         QUERYNO 74002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'R1 ADD FRMT2'             TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR01153_R1'              TO TABLE-1                
              MOVE 'FULL_NAME'                TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              UPDATE                                                    
                   FS                                
              SET                                                       
              ADDRESS = (SELECT RTRIM(DY.STREET_NAME) + '&' + RTRIM(
           DY.ADDRESS_OVERFLOW)
            FROM                                                 
                        CSS_ADDR_FORMATTED DY                           
                       ,CSS_PREMISE        PO
            WHERE                                                
                       FS.PREMISE_NO    = PO.PREMISE_NO                 
                   AND DY.ADDRESS_ID    = PO.ADDRESS_ID                 
                   AND DY.ADDR_USAGE_CD = 'I'),
               ZIP_CODE = (SELECT DY.ZIP_CODE
            FROM                                                 
                        CSS_ADDR_FORMATTED DY                           
                       ,CSS_PREMISE        PO
            WHERE                                                
                       FS.PREMISE_NO    = PO.PREMISE_NO                 
                   AND DY.ADDRESS_ID    = PO.ADDRESS_ID                 
                   AND DY.ADDR_USAGE_CD = 'I')                                  
              FROM #CSR01153_R1 FS
              WHERE EXISTS                                              
              (                                                         
                   SELECT                                               
                        1                                               
                   FROM                                                 
                        CSS_ADDR_FORMATTED DY                           
                       ,CSS_PREMISE        PO                           
                   WHERE                                                
                       PO.PREMISE_NO    = FS.PREMISE_NO                 
                   AND DY.ADDRESS_ID    = PO.ADDRESS_ID                 
                   AND DY.ADDR_USAGE_CD = 'I'                           
              )                                                         
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR* MSQ055
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE                                                            
MFA-TR*            SESSION.CSR01153_R1 FS                                       
MFA-TR*       SET                                                               
MFA-TR*       (                                                                 
MFA-TR*            ADDRESS                                                      
MFA-TR*           ,ZIP_CODE                                                     
MFA-TR*       ) =                                                               
MFA-TR*       (                                                                 
MFA-TR*            SELECT                                                       
MFA-TR*                 RTRIM(DY.STREET_NAME) || '&' ||                         
MFA-TR*                 RTRIM(DY.ADDRESS_OVERFLOW)                              
MFA-TR*                ,DY.ZIP_CODE                                             
MFA-TR*            FROM                                                         
MFA-TR*                 CSS_ADDR_FORMATTED DY                                   
MFA-TR*                ,CSS_PREMISE        PO                                   
MFA-TR*            WHERE                                                        
MFA-TR*                FS.PREMISE_NO    = PO.PREMISE_NO                         
MFA-TR*            AND DY.ADDRESS_ID    = PO.ADDRESS_ID                         
MFA-TR*            AND DY.ADDR_USAGE_CD = 'I'                                   
MFA-TR*       )                                                                 
MFA-TR*       WHERE EXISTS                                                      
MFA-TR*       (                                                                 
MFA-TR*            SELECT                                                       
MFA-TR*                 1                                                       
MFA-TR*            FROM                                                         
MFA-TR*                 CSS_ADDR_FORMATTED DY                                   
MFA-TR*                ,CSS_PREMISE        PO                                   
MFA-TR*            WHERE                                                        
MFA-TR*                PO.PREMISE_NO    = FS.PREMISE_NO                         
MFA-TR*            AND DY.ADDRESS_ID    = PO.ADDRESS_ID                         
MFA-TR*            AND DY.ADDR_USAGE_CD = 'I'                                   
MFA-TR*       )                                                                 
MFA-TR*         QUERYNO 74003                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'R1 ADD FRMT2'             TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR01153_R1'              TO TABLE-1                
              MOVE 'FULL_NAME'                TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7420-UPDATE-DESCRIPTION.                                       *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7420-UPDATE-DESCRIPTION.                                         
                                                                        
           MOVE '7420'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               UPDATE                                                   
                    FS                               
               SET                                                      
               ORDER_TYPE_DESC = (SELECT OT.ORDER_TYPE_DESC
            FROM                                                 
                        CSS_ORDER_TYPE      OT                          
                       ,CSS_WK_CLASS_STAT   WS
            WHERE                                                
                       OT.ORDER_TYPE_CD     = FS.ORDER_TYPE_CD          
                   AND OT.COMPANY_NO        = FS.COMPANY_NO             
                   AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID          
                   AND WS.SERV_ORDER_STATUS = FS.SERV_ORDER_STATUS),
               ORDER_GROUP_CD = (SELECT OT.ORDER_GROUP_CD
            FROM                                                 
                        CSS_ORDER_TYPE      OT                          
                       ,CSS_WK_CLASS_STAT   WS
            WHERE                                                
                       OT.ORDER_TYPE_CD     = FS.ORDER_TYPE_CD          
                   AND OT.COMPANY_NO        = FS.COMPANY_NO             
                   AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID          
                   AND WS.SERV_ORDER_STATUS = FS.SERV_ORDER_STATUS),
               STATUS_TX = (SELECT WS.STATUS_TX
            FROM                                                 
                        CSS_ORDER_TYPE      OT                          
                       ,CSS_WK_CLASS_STAT   WS
            WHERE                                                
                       OT.ORDER_TYPE_CD     = FS.ORDER_TYPE_CD          
                   AND OT.COMPANY_NO        = FS.COMPANY_NO             
                   AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID          
                   AND WS.SERV_ORDER_STATUS = FS.SERV_ORDER_STATUS)             
               FROM #CSR01153_R1 FS
               WHERE EXISTS                                             
               (                                                        
                   SELECT                                               
                        1                                               
                   FROM                                                 
                        CSS_ORDER_TYPE      OT                          
                       ,CSS_WK_CLASS_STAT   WS                          
                   WHERE                                                
                       OT.ORDER_TYPE_CD     = FS.ORDER_TYPE_CD          
                   AND OT.COMPANY_NO        = FS.COMPANY_NO             
                   AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID          
                   AND WS.SERV_ORDER_STATUS = FS.SERV_ORDER_STATUS      
               )                                                        
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ049
MFA-TR* MSQ055
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE                                                           
MFA-TR*             SESSION.CSR01153_R1 FS                                      
MFA-TR*        SET                                                              
MFA-TR*        (    ORDER_TYPE_DESC                                             
MFA-TR*            ,ORDER_GROUP_CD                                              
MFA-TR*            ,STATUS_TX                                                   
MFA-TR*        )                                                                
MFA-TR*        =                                                                
MFA-TR*        (                                                                
MFA-TR*            SELECT                                                       
MFA-TR*                 OT.ORDER_TYPE_DESC                                      
MFA-TR*                ,OT.ORDER_GROUP_CD                                       
MFA-TR*                ,WS.STATUS_TX                                            
MFA-TR*            FROM                                                         
MFA-TR*                 CSS_ORDER_TYPE      OT                                  
MFA-TR*                ,CSS_WK_CLASS_STAT   WS                                  
MFA-TR*            WHERE                                                        
MFA-TR*                OT.ORDER_TYPE_CD     = FS.ORDER_TYPE_CD                  
MFA-TR*            AND OT.COMPANY_NO        = FS.COMPANY_NO                     
MFA-TR*            AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                  
MFA-TR*            AND WS.SERV_ORDER_STATUS = FS.SERV_ORDER_STATUS              
MFA-TR*        )                                                                
MFA-TR*        WHERE EXISTS                                                     
MFA-TR*        (                                                                
MFA-TR*            SELECT                                                       
MFA-TR*                 1                                                       
MFA-TR*            FROM                                                         
MFA-TR*                 CSS_ORDER_TYPE      OT                                  
MFA-TR*                ,CSS_WK_CLASS_STAT   WS                                  
MFA-TR*            WHERE                                                        
MFA-TR*                OT.ORDER_TYPE_CD     = FS.ORDER_TYPE_CD                  
MFA-TR*            AND OT.COMPANY_NO        = FS.COMPANY_NO                     
MFA-TR*            AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                  
MFA-TR*            AND WS.SERV_ORDER_STATUS = FS.SERV_ORDER_STATUS              
MFA-TR*        )                                                                
MFA-TR*         QUERYNO 74201                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'R1 ADD DESC'              TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR01153_R1'              TO TABLE-1                
              MOVE 'DESC & GRP'               TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               UPDATE                                                   
                    FS                               
               SET                                                      
               WORK_TYPE_DESC                                                   
               =                                                        
               (                                                        
                   SELECT                                               
                        WT.WORK_TYPE_DESC                               
                   FROM                                                 
                        CSS_WORK_TYPE       WT                          
                   WHERE                                                
                       WT.WORK_TYPE_CD = FS.WORK_TYPE_CD                
                   AND WT.COMPANY_NO   = FS.COMPANY_NO                  
               )                                                        
               FROM #CSR01153_R1 FS
               WHERE EXISTS                                             
               (                                                        
                   SELECT                                               
                        1                                               
                   FROM                                                 
                        CSS_WORK_TYPE       WT                          
                   WHERE                                                
                       WT.WORK_TYPE_CD = FS.WORK_TYPE_CD                
                   AND WT.COMPANY_NO   = FS.COMPANY_NO                  
               )                                                        
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ049
MFA-TR* MSQ055
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE                                                           
MFA-TR*             SESSION.CSR01153_R1 FS                                      
MFA-TR*        SET                                                              
MFA-TR*        (    WORK_TYPE_DESC                                              
MFA-TR*        )                                                                
MFA-TR*        =                                                                
MFA-TR*        (                                                                
MFA-TR*            SELECT                                                       
MFA-TR*                 WT.WORK_TYPE_DESC                                       
MFA-TR*            FROM                                                         
MFA-TR*                 CSS_WORK_TYPE       WT                                  
MFA-TR*            WHERE                                                        
MFA-TR*                WT.WORK_TYPE_CD = FS.WORK_TYPE_CD                        
MFA-TR*            AND WT.COMPANY_NO   = FS.COMPANY_NO                          
MFA-TR*        )                                                                
MFA-TR*        WHERE EXISTS                                                     
MFA-TR*        (                                                                
MFA-TR*            SELECT                                                       
MFA-TR*                 1                                                       
MFA-TR*            FROM                                                         
MFA-TR*                 CSS_WORK_TYPE       WT                                  
MFA-TR*            WHERE                                                        
MFA-TR*                WT.WORK_TYPE_CD = FS.WORK_TYPE_CD                        
MFA-TR*            AND WT.COMPANY_NO   = FS.COMPANY_NO                          
MFA-TR*        )                                                                
MFA-TR*         QUERYNO 74202                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'R1 ADD DESC'              TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR01153_R1'              TO TABLE-1                
              MOVE 'WRK TYP DESC'             TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7440-UPDATE-READ-ROUTE.                                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7440-UPDATE-READ-ROUTE.                                          
                                                                        
           MOVE '7440'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
                UPDATE                                                  
                     FS                              
                SET                                                     
                     READ_ROUTE = LEFT(CAST((                                   
                          SELECT                                        
                               MAX(SU.READ_ROUTE)                       
                          FROM                                          
                               CSS_SO_UTL_CHG SU                        
                          WHERE                                         
                               SU.SERV_ORDER_NO = FS.SERV_ORDER_NO      
                     ) AS VARCHAR(6)) + '      ', 6)                            
                FROM #CSR01153_R1 FS
                 WHERE EXISTS                                           
                 (                                                      
                     SELECT                                             
                          1                                             
                     FROM                                               
                          CSS_SO_UTL_CHG SU                             
                     WHERE                                              
                          SU.SERV_ORDER_NO = FS.SERV_ORDER_NO           
                 )                                                      
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE                                                          
MFA-TR*              SESSION.CSR01153_R1 FS                                     
MFA-TR*         SET                                                             
MFA-TR*              READ_ROUTE = CHAR(                                         
MFA-TR*              (                                                          
MFA-TR*                   SELECT                                                
MFA-TR*                        MAX(SU.READ_ROUTE)                               
MFA-TR*                   FROM                                                  
MFA-TR*                        CSS_SO_UTL_CHG SU                                
MFA-TR*                   WHERE                                                 
MFA-TR*                        SU.SERV_ORDER_NO = FS.SERV_ORDER_NO              
MFA-TR*              ))                                                         
MFA-TR*          WHERE EXISTS                                                   
MFA-TR*          (                                                              
MFA-TR*              SELECT                                                     
MFA-TR*                   1                                                     
MFA-TR*              FROM                                                       
MFA-TR*                   CSS_SO_UTL_CHG SU                                     
MFA-TR*              WHERE                                                      
MFA-TR*                   SU.SERV_ORDER_NO = FS.SERV_ORDER_NO                   
MFA-TR*          )                                                              
MFA-TR*         QUERYNO 74401                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INS R1'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_UTL_CHG'           TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                UPDATE                                                  
                     FS                              
                SET                                                     
                     READ_ROUTE = LEFT(CAST((                                   
                         SELECT                                         
                             MAX(SU.READ_ROUTE)                         
                         FROM                                           
                             CSS_SO_UTILITY      SU                     
                         WHERE                                          
                             SU.SERV_ORDER_NO = FS.SERV_ORDER_NO        
                     ) AS VARCHAR(6)) + '      ', 6)                            
                FROM #CSR01153_R1 FS
                WHERE EXISTS (                                          
                         SELECT                                         
                             1                                          
                         FROM                                           
                             CSS_SO_UTILITY      SU                     
                         WHERE                                          
                             SU.SERV_ORDER_NO = FS.SERV_ORDER_NO        
                         AND FS.READ_ROUTE = '0000'                     
                )                                                       
                                                           
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE                                                          
MFA-TR*              SESSION.CSR01153_R1 FS                                     
MFA-TR*         SET                                                             
MFA-TR*              READ_ROUTE = CHAR(                                         
MFA-TR*              (                                                          
MFA-TR*                  SELECT                                                 
MFA-TR*                      MAX(SU.READ_ROUTE)                                 
MFA-TR*                  FROM                                                   
MFA-TR*                      CSS_SO_UTILITY      SU                             
MFA-TR*                  WHERE                                                  
MFA-TR*                      SU.SERV_ORDER_NO = FS.SERV_ORDER_NO                
MFA-TR*              ))                                                         
MFA-TR*         WHERE EXISTS (                                                  
MFA-TR*                  SELECT                                                 
MFA-TR*                      1                                                  
MFA-TR*                  FROM                                                   
MFA-TR*                      CSS_SO_UTILITY      SU                             
MFA-TR*                  WHERE                                                  
MFA-TR*                      SU.SERV_ORDER_NO = FS.SERV_ORDER_NO                
MFA-TR*                  AND FS.READ_ROUTE = '0000'                             
MFA-TR*         )                                                               
MFA-TR*         QUERYNO 74402                                                   
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INS R1'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_UTILITY'           TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7460-UPDATE-READ-ROUTE-HT.                                     *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7460-UPDATE-READ-ROUTE-HT.                                       
                                                                        
           MOVE '7460'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
                UPDATE                                                  
                     FS                              
                SET                                                     
                     READ_ROUTE = LEFT(CAST((                                   
                          SELECT                                        
                               MAX(SU.READ_ROUTE)                       
                          FROM                                          
                               HST_SO_UTL_CHG SU                        
                          WHERE                                         
                               SU.SERV_ORDER_NO = FS.SERV_ORDER_NO      
                     ) AS VARCHAR(6)) + '      ', 6)                            
                FROM #CSR01153_R1 FS
                 WHERE EXISTS                                           
                 (                                                      
                     SELECT                                             
                          1                                             
                     FROM                                               
                          HST_SO_UTL_CHG SU                             
                     WHERE                                              
                          SU.SERV_ORDER_NO = FS.SERV_ORDER_NO           
                 )                                                      
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE                                                          
MFA-TR*              SESSION.CSR01153_R1 FS                                     
MFA-TR*         SET                                                             
MFA-TR*              READ_ROUTE = CHAR(                                         
MFA-TR*              (                                                          
MFA-TR*                   SELECT                                                
MFA-TR*                        MAX(SU.READ_ROUTE)                               
MFA-TR*                   FROM                                                  
MFA-TR*                        HST_SO_UTL_CHG SU                                
MFA-TR*                   WHERE                                                 
MFA-TR*                        SU.SERV_ORDER_NO = FS.SERV_ORDER_NO              
MFA-TR*              ))                                                         
MFA-TR*          WHERE EXISTS                                                   
MFA-TR*          (                                                              
MFA-TR*              SELECT                                                     
MFA-TR*                   1                                                     
MFA-TR*              FROM                                                       
MFA-TR*                   HST_SO_UTL_CHG SU                                     
MFA-TR*              WHERE                                                      
MFA-TR*                   SU.SERV_ORDER_NO = FS.SERV_ORDER_NO                   
MFA-TR*          )                                                              
MFA-TR*         QUERYNO 74601                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INS R1'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_UTL_CHG'           TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                UPDATE                                                  
                     FS                              
                SET                                                     
                     READ_ROUTE = LEFT(CAST((                                   
                         SELECT                                         
                             MAX(SU.READ_ROUTE)                         
                         FROM                                           
                             HST_SO_UTILITY      SU                     
                         WHERE                                          
                             SU.SERV_ORDER_NO = FS.SERV_ORDER_NO        
                     ) AS VARCHAR(6)) + '      ', 6)                            
                FROM #CSR01153_R1 FS
                WHERE EXISTS (                                          
                         SELECT                                         
                             1                                          
                         FROM                                           
                             HST_SO_UTILITY      SU                     
                         WHERE                                          
                             SU.SERV_ORDER_NO = FS.SERV_ORDER_NO        
                         AND FS.READ_ROUTE = '0000'                     
                )                                                       
                                                                        
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE                                                          
MFA-TR*              SESSION.CSR01153_R1 FS                                     
MFA-TR*         SET                                                             
MFA-TR*              READ_ROUTE = CHAR(                                         
MFA-TR*              (                                                          
MFA-TR*                  SELECT                                                 
MFA-TR*                      MAX(SU.READ_ROUTE)                                 
MFA-TR*                  FROM                                                   
MFA-TR*                      HST_SO_UTILITY      SU                             
MFA-TR*                  WHERE                                                  
MFA-TR*                      SU.SERV_ORDER_NO = FS.SERV_ORDER_NO                
MFA-TR*              ))                                                         
MFA-TR*         WHERE EXISTS (                                                  
MFA-TR*                  SELECT                                                 
MFA-TR*                      1                                                  
MFA-TR*                  FROM                                                   
MFA-TR*                      HST_SO_UTILITY      SU                             
MFA-TR*                  WHERE                                                  
MFA-TR*                      SU.SERV_ORDER_NO = FS.SERV_ORDER_NO                
MFA-TR*                  AND FS.READ_ROUTE = '0000'                             
MFA-TR*         )                                                               
MFA-TR*                                                                         
MFA-TR*         QUERYNO 74602                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INS R1'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_UTILITY'           TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              MOVE WS-SO-NUMBER               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7460-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-GET-COUNT-ORD                                             *        
      *                                                                *        
      *     GETS THE COUNT FOR ORD                                     *        
      ******************************************************************        
                                                                        
       7500-GET-COUNT-ORD.                                              
                                                                        
           MOVE '7500'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(                                             
                   DISTINCT CIS.DECIMAL2CHAR(SO.SERV_ORDER_NO) + 
           OI.CODE_UTIL_TYPE 
                   )                                                    
              INTO                                                      
                   :WS-TOTAL                                            
              FROM                                                      
                   CSS_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.SERV_ORDER_NO      = :WS-SO-NUMBER                 
              AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO              
APL495        AND OI.WORK_TYPE_CD       <> ''                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(                                                     
MFA-TR*            DISTINCT CHAR(SO.SERV_ORDER_NO) || OI.CODE_UTIL_TYPE         
MFA-TR*            )                                                            
MFA-TR*       INTO                                                              
MFA-TR*            :WS-TOTAL                                                    
MFA-TR*       FROM                                                              
MFA-TR*            CSS_SO_DATA       SO                                         
MFA-TR*           ,CSS_SO_ORDER_INST OI                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.SERV_ORDER_NO      = :WS-SO-NUMBER                         
MFA-TR*       AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                      
MFA-TR*       AND OI.WORK_TYPE_CD       <> ''                                   
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT ORD'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7550-GET-COUNT-ORD-HT                                          *        
      *                                                                *        
      *     GETS THE COUNT FOR ORD FROM HISTORY                        *        
      ******************************************************************        
                                                                        
       7550-GET-COUNT-ORD-HT.                                           
                                                                        
           MOVE '7550'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(                                             
                   DISTINCT CIS.DECIMAL2CHAR(SO.SERV_ORDER_NO) + 
           OI.CODE_UTIL_TYPE 
                   )                                                    
              INTO                                                      
                   :WS-TOTAL                                            
              FROM                                                      
                   HST_SO_DATA       SO WITH(READUNCOMMITTED)                   
                  ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  SO.SERV_ORDER_NO      = :WS-SO-NUMBER                 
              AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO              
APL495        AND OI.WORK_TYPE_CD       <> ''                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(                                                     
MFA-TR*            DISTINCT CHAR(SO.SERV_ORDER_NO) || OI.CODE_UTIL_TYPE         
MFA-TR*            )                                                            
MFA-TR*       INTO                                                              
MFA-TR*            :WS-TOTAL                                                    
MFA-TR*       FROM                                                              
MFA-TR*            HST_SO_DATA       SO                                         
MFA-TR*           ,HST_SO_ORDER_INST OI                                         
MFA-TR*       WHERE                                                             
MFA-TR*           SO.SERV_ORDER_NO      = :WS-SO-NUMBER                         
MFA-TR*       AND OI.SERV_ORDER_NO      = SO.SERV_ORDER_NO                      
MFA-TR*       AND OI.WORK_TYPE_CD       <> ''                                   
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7550                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT ORD'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-GET-COUNT-LAT                                             *        
      *                                                                *        
      *     GETS THE COUNT FOR LAT VIEW NON CREW                       *        
      ******************************************************************        
                                                                        
       7600-GET-COUNT-LAT.                                              
                                                                        
           MOVE '7600'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(DISTINCT                                     
               CIS.DECIMAL2CHAR(SO.SERV_ORDER_NO) + OI.CODE_UTIL_TYPE + 
           OT.ORDER_GROUP_CD) INTO :WS-TOTAL                      
              FROM                                                      
                CSS_SO_DATA       SO WITH(READUNCOMMITTED)                      
               ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                      
               ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                      
               ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                      
               ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                      
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                       
                   SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )         
                OR :WS-IS-RSP-AREA-NULL = 'Y' )                         
              AND                                                       
              (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                       
                   SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )         
                OR :WS-IS-WRK-AREA-NULL = 'Y' )                         
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'LAT1'                              
                AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))         
               OR ( :WS-VIEW-TYPE = 'LAT2'                              
                AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))              
               OR ( :WS-VIEW-TYPE = 'LAT3'                              
                AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))              
C35927        AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )                
              AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                   
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
              AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )              
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(DISTINCT                                             
MFA-TR*        CHAR(SO.SERV_ORDER_NO)                                           
MFA-TR*        ||OI.CODE_UTIL_TYPE                                              
MFA-TR*        ||OT.ORDER_GROUP_CD) INTO :WS-TOTAL                              
MFA-TR*       FROM                                                              
MFA-TR*         CSS_SO_DATA       SO                                            
MFA-TR*        ,CSS_SO_ORDER_INST OI                                            
MFA-TR*        ,CSS_ORDER_TYPE    OT                                            
MFA-TR*        ,CSS_WORK_TYPE     WT                                            
MFA-TR*        ,CSS_WK_CLASS_STAT WS                                            
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                               
MFA-TR*            SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )                 
MFA-TR*         OR :WS-IS-RSP-AREA-NULL = 'Y' )                                 
MFA-TR*       AND                                                               
MFA-TR*       (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                               
MFA-TR*            SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )                 
MFA-TR*         OR :WS-IS-WRK-AREA-NULL = 'Y' )                                 
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'LAT1'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))                 
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT2'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))                      
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT3'                                      
MFA-TR*         AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))                      
MFA-TR*       AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                        
MFA-TR*       AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                           
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*       AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                      
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT LAT'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7601-GET-COUNT-LAT-HT                                          *        
      *                                                                *        
      *     GETS THE COUNT FOR LAT VIEW NON CREW                       *        
      ******************************************************************        
                                                                        
       7601-GET-COUNT-LAT-HT.                                           
                                                                        
           MOVE '7601'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(DISTINCT                                     
               CIS.DECIMAL2CHAR(SO.SERV_ORDER_NO) + OI.CODE_UTIL_TYPE + 
           OT.ORDER_GROUP_CD) INTO :WS-TOTAL                      
              FROM                                                      
                HST_SO_DATA       SO WITH(READUNCOMMITTED)                      
               ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                      
               ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                      
               ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                      
               ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                      
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                       
                   SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )         
                OR :WS-IS-RSP-AREA-NULL = 'Y' )                         
              AND                                                       
              (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                       
                   SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )         
                OR :WS-IS-WRK-AREA-NULL = 'Y' )                         
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'LAT1'                              
                AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))         
               OR ( :WS-VIEW-TYPE = 'LAT2'                              
                AND SO.ORDER_STATE_CD IN ('A', 'H', 'R'))               
               OR ( :WS-VIEW-TYPE = 'LAT3'                              
                AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))              
C35927        AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )                
              AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                   
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
              AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )              
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(DISTINCT                                             
MFA-TR*        CHAR(SO.SERV_ORDER_NO)                                           
MFA-TR*        ||OI.CODE_UTIL_TYPE                                              
MFA-TR*        ||OT.ORDER_GROUP_CD) INTO :WS-TOTAL                              
MFA-TR*       FROM                                                              
MFA-TR*         HST_SO_DATA       SO                                            
MFA-TR*        ,HST_SO_ORDER_INST OI                                            
MFA-TR*        ,CSS_ORDER_TYPE    OT                                            
MFA-TR*        ,CSS_WORK_TYPE     WT                                            
MFA-TR*        ,CSS_WK_CLASS_STAT WS                                            
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                               
MFA-TR*            SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )                 
MFA-TR*         OR :WS-IS-RSP-AREA-NULL = 'Y' )                                 
MFA-TR*       AND                                                               
MFA-TR*       (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                               
MFA-TR*            SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )                 
MFA-TR*         OR :WS-IS-WRK-AREA-NULL = 'Y' )                                 
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'LAT1'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))                 
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT2'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A', 'H', 'R'))                       
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT3'                                      
MFA-TR*         AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))                      
MFA-TR*       AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                        
MFA-TR*       AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                           
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*       AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                      
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7601                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT LAT'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7601-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7602-GET-COUNT-LAT-RR                                          *        
      *                                                                *        
      *     GETS THE COUNT FOR LAT VIEW NON CREW WITH READ ROUTE       *        
      ******************************************************************        
                                                                        
       7602-GET-COUNT-LAT-RR.                                           
                                                                        
           MOVE '7602'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            SELECT COUNT(*) INTO :WS-TOTAL FROM (                       
              SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (   
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT DISTINCT                                       
                    SO.SERV_ORDER_NO                                    
                   ,OI.CODE_UTIL_TYPE                                   
                   ,OT.ORDER_GROUP_CD                                   
                  FROM                                                  
                    CSS_SO_DATA       SO WITH(READUNCOMMITTED)                  
                   ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                  
                   ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                  
                   ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                  
                   ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                  
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                   
                       SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )     
                    OR :WS-IS-RSP-AREA-NULL = 'Y' )                     
                  AND                                                   
                  (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                   
                       SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )     
                    OR :WS-IS-WRK-AREA-NULL = 'Y' )                     
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'LAT1'                          
                    AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))     
                   OR ( :WS-VIEW-TYPE = 'LAT2'                          
                    AND SO.ORDER_STATE_CD IN ('A', 'H','R' ))           
                   OR ( :WS-VIEW-TYPE = 'LAT3'                          
                    AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))          
C35927            AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )            
                  AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO               
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                  AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )          
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                ) SO                                                    
                LEFT OUTER JOIN CSS_SO_UTL_CHG SC WITH(READUNCOMMITTED)         
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN CSS_SO_UTILITY SU WITH(READUNCOMMITTED)           
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
            ) SO                                                        
            WHERE                                                       
                 :WS-IS-RD-ROUTE-NULL = 'Y'                             
            OR ( :WS-IS-RD-ROUTE-NULL = 'N'                             
             AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                     
                OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT COUNT(*) INTO :WS-TOTAL FROM (                               
MFA-TR*       SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (           
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT DISTINCT                                               
MFA-TR*             SO.SERV_ORDER_NO                                            
MFA-TR*            ,OI.CODE_UTIL_TYPE                                           
MFA-TR*            ,OT.ORDER_GROUP_CD                                           
MFA-TR*           FROM                                                          
MFA-TR*             CSS_SO_DATA       SO                                        
MFA-TR*            ,CSS_SO_ORDER_INST OI                                        
MFA-TR*            ,CSS_ORDER_TYPE    OT                                        
MFA-TR*            ,CSS_WORK_TYPE     WT                                        
MFA-TR*            ,CSS_WK_CLASS_STAT WS                                        
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                           
MFA-TR*                SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )             
MFA-TR*             OR :WS-IS-RSP-AREA-NULL = 'Y' )                             
MFA-TR*           AND                                                           
MFA-TR*           (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                           
MFA-TR*                SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )             
MFA-TR*             OR :WS-IS-WRK-AREA-NULL = 'Y' )                             
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'LAT1'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))             
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT2'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A', 'H','R' ))                   
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT3'                                  
MFA-TR*             AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))                  
MFA-TR*           AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                    
MFA-TR*           AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                       
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*           AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                  
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN CSS_SO_UTL_CHG SC                               
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN CSS_SO_UTILITY SU                                 
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*     ) SO                                                                
MFA-TR*     WHERE                                                               
MFA-TR*          :WS-IS-RD-ROUTE-NULL = 'Y'                                     
MFA-TR*     OR ( :WS-IS-RD-ROUTE-NULL = 'N'                                     
MFA-TR*      AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                             
MFA-TR*         OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                         
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7602                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT LAT'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7602-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7603-GET-COUNT-LAT-RR-HT                                       *        
      *                                                                *        
      *     GETS THE COUNT FOR LAT VIEW NON CREW WITH READ ROUTE       *        
      ******************************************************************        
                                                                        
       7603-GET-COUNT-LAT-RR-HT.                                        
                                                                        
           MOVE '7603'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            SELECT COUNT(*) INTO :WS-TOTAL FROM (                       
              SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (   
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT DISTINCT                                       
                    SO.SERV_ORDER_NO                                    
                   ,OI.CODE_UTIL_TYPE                                   
                   ,OT.ORDER_GROUP_CD                                   
                  FROM                                                  
                    HST_SO_DATA       SO WITH(READUNCOMMITTED)                  
                   ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                  
                   ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                  
                   ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                  
                   ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                  
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                   
                       SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )     
                    OR :WS-IS-RSP-AREA-NULL = 'Y' )                     
                  AND                                                   
                  (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                   
                       SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )     
                    OR :WS-IS-WRK-AREA-NULL = 'Y' )                     
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'LAT1'                          
                    AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))     
                   OR ( :WS-VIEW-TYPE = 'LAT2'                          
                    AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))          
                   OR ( :WS-VIEW-TYPE = 'LAT3'                          
                    AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))          
C35927            AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )            
                  AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO               
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                  AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )          
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                ) SO                                                    
                LEFT OUTER JOIN HST_SO_UTL_CHG SC WITH(READUNCOMMITTED)         
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN HST_SO_UTILITY SU WITH(READUNCOMMITTED)           
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
            ) SO                                                        
            WHERE                                                       
                 :WS-IS-RD-ROUTE-NULL = 'Y'                             
            OR ( :WS-IS-RD-ROUTE-NULL = 'N'                             
             AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                     
                OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT COUNT(*) INTO :WS-TOTAL FROM (                               
MFA-TR*       SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (           
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT DISTINCT                                               
MFA-TR*             SO.SERV_ORDER_NO                                            
MFA-TR*            ,OI.CODE_UTIL_TYPE                                           
MFA-TR*            ,OT.ORDER_GROUP_CD                                           
MFA-TR*           FROM                                                          
MFA-TR*             HST_SO_DATA       SO                                        
MFA-TR*            ,HST_SO_ORDER_INST OI                                        
MFA-TR*            ,CSS_ORDER_TYPE    OT                                        
MFA-TR*            ,CSS_WORK_TYPE     WT                                        
MFA-TR*            ,CSS_WK_CLASS_STAT WS                                        
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                           
MFA-TR*                SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )             
MFA-TR*             OR :WS-IS-RSP-AREA-NULL = 'Y' )                             
MFA-TR*           AND                                                           
MFA-TR*           (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                           
MFA-TR*                SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )             
MFA-TR*             OR :WS-IS-WRK-AREA-NULL = 'Y' )                             
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'LAT1'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))             
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT2'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))                  
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT3'                                  
MFA-TR*             AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))                  
MFA-TR*           AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                    
MFA-TR*           AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                       
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*           AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                  
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN HST_SO_UTL_CHG SC                               
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN HST_SO_UTILITY SU                                 
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*     ) SO                                                                
MFA-TR*     WHERE                                                               
MFA-TR*          :WS-IS-RD-ROUTE-NULL = 'Y'                                     
MFA-TR*     OR ( :WS-IS-RD-ROUTE-NULL = 'N'                                     
MFA-TR*      AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                             
MFA-TR*         OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                         
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7603                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT LAT'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7603-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7604-GET-COUNT-LAT-CW                                          *        
      *                                                                *        
      *     GETS THE COUNT FOR LAT VIEW CREW                           *        
      ******************************************************************        
                                                                        
       7604-GET-COUNT-LAT-CW.                                           
                                                                        
           MOVE '7605'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(DISTINCT                                     
               CIS.DECIMAL2CHAR(SO.SERV_ORDER_NO) + OI.CODE_UTIL_TYPE + 
           OT.ORDER_GROUP_CD) INTO :WS-TOTAL                      
              FROM                                                      
                CSS_SO_DATA       SO WITH(READUNCOMMITTED)                      
               ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                      
               ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                      
               ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                      
               ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                      
               ,CSS_SO_CREW       WM WITH(READUNCOMMITTED)                      
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                       
                   SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )         
                OR :WS-IS-RSP-AREA-NULL = 'Y' )                         
              AND                                                       
              (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                       
                   SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )         
                OR :WS-IS-WRK-AREA-NULL = 'Y' )                         
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'LAT1'                              
                AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))         
               OR ( :WS-VIEW-TYPE = 'LAT2'                              
                AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))              
               OR ( :WS-VIEW-TYPE = 'LAT3'                              
                AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))              
C35927        AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )                
              AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                   
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
              AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )              
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND WM.CREW_ID           = :WS-CREW-ID                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(DISTINCT                                             
MFA-TR*        CHAR(SO.SERV_ORDER_NO)                                           
MFA-TR*        ||OI.CODE_UTIL_TYPE                                              
MFA-TR*        ||OT.ORDER_GROUP_CD) INTO :WS-TOTAL                              
MFA-TR*       FROM                                                              
MFA-TR*         CSS_SO_DATA       SO                                            
MFA-TR*        ,CSS_SO_ORDER_INST OI                                            
MFA-TR*        ,CSS_ORDER_TYPE    OT                                            
MFA-TR*        ,CSS_WORK_TYPE     WT                                            
MFA-TR*        ,CSS_WK_CLASS_STAT WS                                            
MFA-TR*        ,CSS_SO_CREW       WM                                            
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                               
MFA-TR*            SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )                 
MFA-TR*         OR :WS-IS-RSP-AREA-NULL = 'Y' )                                 
MFA-TR*       AND                                                               
MFA-TR*       (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                               
MFA-TR*            SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )                 
MFA-TR*         OR :WS-IS-WRK-AREA-NULL = 'Y' )                                 
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'LAT1'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))                 
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT2'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))                      
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT3'                                      
MFA-TR*         AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))                      
MFA-TR*       AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                        
MFA-TR*       AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                           
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*       AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                      
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND WM.CREW_ID           = :WS-CREW-ID                            
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7604                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT LAT'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7604-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7605-GET-COUNT-LAT-CW-HT                                       *        
      *                                                                *        
      *     GETS THE COUNT FOR LAT VIEW CREW                           *        
      ******************************************************************        
                                                                        
       7605-GET-COUNT-LAT-CW-HT.                                        
                                                                        
           MOVE '7605'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(DISTINCT                                     
               CIS.DECIMAL2CHAR(SO.SERV_ORDER_NO) + OI.CODE_UTIL_TYPE + 
           OT.ORDER_GROUP_CD) INTO :WS-TOTAL                      
              FROM                                                      
                HST_SO_DATA       SO WITH(READUNCOMMITTED)                      
               ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                      
               ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                      
               ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                      
               ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                      
               ,HST_SO_CREW       WM WITH(READUNCOMMITTED)                      
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                       
                   SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )         
                OR :WS-IS-RSP-AREA-NULL = 'Y' )                         
              AND                                                       
              (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                       
                   SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )         
                OR :WS-IS-WRK-AREA-NULL = 'Y' )                         
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'LAT1'                              
                AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))         
               OR ( :WS-VIEW-TYPE = 'LAT2'                              
                AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))              
               OR ( :WS-VIEW-TYPE = 'LAT3'                              
                AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))              
C35927        AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )                
              AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                   
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
              AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )              
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND WM.CREW_ID           = :WS-CREW-ID                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(DISTINCT                                             
MFA-TR*        CHAR(SO.SERV_ORDER_NO)                                           
MFA-TR*        ||OI.CODE_UTIL_TYPE                                              
MFA-TR*        ||OT.ORDER_GROUP_CD) INTO :WS-TOTAL                              
MFA-TR*       FROM                                                              
MFA-TR*         HST_SO_DATA       SO                                            
MFA-TR*        ,HST_SO_ORDER_INST OI                                            
MFA-TR*        ,CSS_ORDER_TYPE    OT                                            
MFA-TR*        ,CSS_WORK_TYPE     WT                                            
MFA-TR*        ,CSS_WK_CLASS_STAT WS                                            
MFA-TR*        ,HST_SO_CREW       WM                                            
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                               
MFA-TR*            SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )                 
MFA-TR*         OR :WS-IS-RSP-AREA-NULL = 'Y' )                                 
MFA-TR*       AND                                                               
MFA-TR*       (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                               
MFA-TR*            SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )                 
MFA-TR*         OR :WS-IS-WRK-AREA-NULL = 'Y' )                                 
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'LAT1'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))                 
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT2'                                      
MFA-TR*         AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))                      
MFA-TR*        OR ( :WS-VIEW-TYPE = 'LAT3'                                      
MFA-TR*         AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))                      
MFA-TR*       AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                        
MFA-TR*       AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                           
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*       AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                      
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND WM.CREW_ID           = :WS-CREW-ID                            
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7605                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT LAT'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7605-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7606-GET-COUNT-LAT-CW-RR                                       *        
      *                                                                *        
      *     GETS THE COUNT FOR LAT VIEW CREW WITH READ ROUTE           *        
      ******************************************************************        
                                                                        
       7606-GET-COUNT-LAT-CW-RR.                                        
                                                                        
           MOVE '7606'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            SELECT COUNT(*) INTO :WS-TOTAL FROM (                       
              SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (   
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT DISTINCT                                       
                    SO.SERV_ORDER_NO                                    
                   ,OI.CODE_UTIL_TYPE                                   
                   ,OT.ORDER_GROUP_CD                                   
                  FROM                                                  
                    CSS_SO_DATA       SO WITH(READUNCOMMITTED)                  
                   ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                  
                   ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                  
                   ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                  
                   ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                  
                   ,CSS_SO_CREW       WM WITH(READUNCOMMITTED)                  
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                   
                       SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )     
                    OR :WS-IS-RSP-AREA-NULL = 'Y' )                     
                  AND                                                   
                  (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                   
                       SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )     
                    OR :WS-IS-WRK-AREA-NULL = 'Y' )                     
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'LAT1'                          
                    AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))     
                   OR ( :WS-VIEW-TYPE = 'LAT2'                          
                    AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))          
                   OR ( :WS-VIEW-TYPE = 'LAT3'                          
                    AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))          
C35927            AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )            
                  AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO               
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                  AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )          
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND WM.CREW_ID           = :WS-CREW-ID                
                ) SO                                                    
                LEFT OUTER JOIN CSS_SO_UTL_CHG SC WITH(READUNCOMMITTED)         
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN CSS_SO_UTILITY SU WITH(READUNCOMMITTED)           
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
            ) SO                                                        
            WHERE                                                       
                 :WS-IS-RD-ROUTE-NULL = 'Y'                             
            OR ( :WS-IS-RD-ROUTE-NULL = 'N'                             
             AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                     
                OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT COUNT(*) INTO :WS-TOTAL FROM (                               
MFA-TR*       SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (           
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT DISTINCT                                               
MFA-TR*             SO.SERV_ORDER_NO                                            
MFA-TR*            ,OI.CODE_UTIL_TYPE                                           
MFA-TR*            ,OT.ORDER_GROUP_CD                                           
MFA-TR*           FROM                                                          
MFA-TR*             CSS_SO_DATA       SO                                        
MFA-TR*            ,CSS_SO_ORDER_INST OI                                        
MFA-TR*            ,CSS_ORDER_TYPE    OT                                        
MFA-TR*            ,CSS_WORK_TYPE     WT                                        
MFA-TR*            ,CSS_WK_CLASS_STAT WS                                        
MFA-TR*            ,CSS_SO_CREW       WM                                        
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                           
MFA-TR*                SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )             
MFA-TR*             OR :WS-IS-RSP-AREA-NULL = 'Y' )                             
MFA-TR*           AND                                                           
MFA-TR*           (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                           
MFA-TR*                SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )             
MFA-TR*             OR :WS-IS-WRK-AREA-NULL = 'Y' )                             
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'LAT1'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))             
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT2'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))                  
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT3'                                  
MFA-TR*             AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))                  
MFA-TR*           AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                    
MFA-TR*           AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                       
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*           AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                  
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND WM.CREW_ID           = :WS-CREW-ID                        
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN CSS_SO_UTL_CHG SC                               
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN CSS_SO_UTILITY SU                                 
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*     ) SO                                                                
MFA-TR*     WHERE                                                               
MFA-TR*          :WS-IS-RD-ROUTE-NULL = 'Y'                                     
MFA-TR*     OR ( :WS-IS-RD-ROUTE-NULL = 'N'                                     
MFA-TR*      AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                             
MFA-TR*         OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                         
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7606                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT LAT'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7606-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7607-GET-COUNT-LAT-CW-RR-HT                                    *        
      *                                                                *        
      *     GETS THE COUNT FOR LAT VIEW CREW WITH READ ROUTE           *        
      ******************************************************************        
                                                                        
       7607-GET-COUNT-LAT-CW-RR-HT.                                     
                                                                        
           MOVE '7607'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            SELECT COUNT(*) INTO :WS-TOTAL FROM (                       
              SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (   
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT DISTINCT                                       
                    SO.SERV_ORDER_NO                                    
                   ,OI.CODE_UTIL_TYPE                                   
                   ,OT.ORDER_GROUP_CD                                   
                  FROM                                                  
                    HST_SO_DATA       SO WITH(READUNCOMMITTED)                  
                   ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                  
                   ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                  
                   ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                  
                   ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                  
                   ,HST_SO_CREW       WM WITH(READUNCOMMITTED)                  
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                   
                       SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )     
                    OR :WS-IS-RSP-AREA-NULL = 'Y' )                     
                  AND                                                   
                  (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                   
                       SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )     
                    OR :WS-IS-WRK-AREA-NULL = 'Y' )                     
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'LAT1'                          
                    AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))     
                   OR ( :WS-VIEW-TYPE = 'LAT2'                          
                    AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))          
                   OR ( :WS-VIEW-TYPE = 'LAT3'                          
                    AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))          
C35927            AND SO.ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                        :WS-TODAYS-DATE
              )            
                  AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO               
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                  AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )          
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND WM.CREW_ID           = :WS-CREW-ID                
                ) SO                                                    
                LEFT OUTER JOIN HST_SO_UTL_CHG SC WITH(READUNCOMMITTED)         
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN HST_SO_UTILITY SU WITH(READUNCOMMITTED)           
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
            ) SO                                                        
            WHERE                                                       
                 :WS-IS-RD-ROUTE-NULL = 'Y'                             
            OR ( :WS-IS-RD-ROUTE-NULL = 'N'                             
             AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                     
                OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT COUNT(*) INTO :WS-TOTAL FROM (                               
MFA-TR*       SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (           
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT DISTINCT                                               
MFA-TR*             SO.SERV_ORDER_NO                                            
MFA-TR*            ,OI.CODE_UTIL_TYPE                                           
MFA-TR*            ,OT.ORDER_GROUP_CD                                           
MFA-TR*           FROM                                                          
MFA-TR*             HST_SO_DATA       SO                                        
MFA-TR*            ,HST_SO_ORDER_INST OI                                        
MFA-TR*            ,CSS_ORDER_TYPE    OT                                        
MFA-TR*            ,CSS_WORK_TYPE     WT                                        
MFA-TR*            ,CSS_WK_CLASS_STAT WS                                        
MFA-TR*            ,HST_SO_CREW       WM                                        
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (  ( :WS-IS-RSP-AREA-NULL = 'N' AND                           
MFA-TR*                SO.RESP_AREA_ID         = :WS-RESP-AREA-ID )             
MFA-TR*             OR :WS-IS-RSP-AREA-NULL = 'Y' )                             
MFA-TR*           AND                                                           
MFA-TR*           (  ( :WS-IS-WRK-AREA-NULL = 'N' AND                           
MFA-TR*                SO.WORK_AREA_ID         = :WS-WORK-AREA-ID )             
MFA-TR*             OR :WS-IS-WRK-AREA-NULL = 'Y' )                             
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'LAT1'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A','B','D','H','R'))             
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT2'                                  
MFA-TR*             AND SO.ORDER_STATE_CD IN ('A', 'H', 'R' ))                  
MFA-TR*            OR ( :WS-VIEW-TYPE = 'LAT3'                                  
MFA-TR*             AND SO.ORDER_STATE_CD = :WS-SO-STATE-CD ))                  
MFA-TR*           AND SO.ASSIGNED_DATETIME < :WS-TODAYS-DATE                    
MFA-TR*           AND OI.SERV_ORDER_NO = SO.SERV_ORDER_NO                       
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*           AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                  
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND WM.CREW_ID           = :WS-CREW-ID                        
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN HST_SO_UTL_CHG SC                               
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN HST_SO_UTILITY SU                                 
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*     ) SO                                                                
MFA-TR*     WHERE                                                               
MFA-TR*          :WS-IS-RD-ROUTE-NULL = 'Y'                                     
MFA-TR*     OR ( :WS-IS-RD-ROUTE-NULL = 'N'                                     
MFA-TR*      AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                             
MFA-TR*         OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                         
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7607                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT LAT'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7607-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7610-GET-COUNT-TYP                                             *        
      *                                                                *        
      *     GETS THE COUNT FOR TYP VIEW NON CREW                       *        
      ******************************************************************        
                                                                        
       7610-GET-COUNT-TYP.                                              
                                                                        
           MOVE '7610'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(DISTINCT                                     
               CIS.DECIMAL2CHAR(SO.SERV_ORDER_NO) + OI.CODE_UTIL_TYPE + 
           OT.ORDER_GROUP_CD) INTO :WS-TOTAL                      
              FROM                                                      
                CSS_SO_DATA       SO WITH(READUNCOMMITTED)                      
               ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                      
               ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                      
               ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                      
               ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                      
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'TYP1' AND                          
                    SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))      
                OR( :WS-VIEW-TYPE = 'TYP2' AND                          
                    SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))      
                OR (:WS-VIEW-TYPE = 'TYP3' AND                          
                    SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))            
              AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(:WS-FROM-TS
              )                   
              AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(:WS-TO-TS)         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))        
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))       
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))       
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))          
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))             
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(DISTINCT                                             
MFA-TR*        CHAR(SO.SERV_ORDER_NO)                                           
MFA-TR*        ||OI.CODE_UTIL_TYPE                                              
MFA-TR*        ||OT.ORDER_GROUP_CD) INTO :WS-TOTAL                              
MFA-TR*       FROM                                                              
MFA-TR*         CSS_SO_DATA       SO                                            
MFA-TR*        ,CSS_SO_ORDER_INST OI                                            
MFA-TR*        ,CSS_ORDER_TYPE    OT                                            
MFA-TR*        ,CSS_WORK_TYPE     WT                                            
MFA-TR*        ,CSS_WK_CLASS_STAT WS                                            
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'TYP1' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))              
MFA-TR*         OR( :WS-VIEW-TYPE = 'TYP2' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))              
MFA-TR*         OR (:WS-VIEW-TYPE = 'TYP3' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                    
MFA-TR*       AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                           
MFA-TR*       AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                             
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))                
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))                  
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                     
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7610                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT TYP'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7611-GET-COUNT-TYP-HT                                          *        
      *                                                                *        
      *     GETS THE COUNT FOR TYP VIEW NON CREW                       *        
      ******************************************************************        
                                                                        
       7611-GET-COUNT-TYP-HT.                                           
                                                                        
           MOVE '7611'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(DISTINCT                                     
               CIS.DECIMAL2CHAR(SO.SERV_ORDER_NO) + OI.CODE_UTIL_TYPE + 
           OT.ORDER_GROUP_CD) INTO :WS-TOTAL                      
              FROM                                                      
                HST_SO_DATA       SO WITH(READUNCOMMITTED)                      
               ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                      
               ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                      
               ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                      
               ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                      
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'TYP1' AND                          
                    SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))      
                OR( :WS-VIEW-TYPE = 'TYP2' AND                          
                    SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))      
                OR (:WS-VIEW-TYPE = 'TYP3' AND                          
                    SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))            
              AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(:WS-FROM-TS
              )                   
              AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(:WS-TO-TS)         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))        
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))       
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))       
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))          
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))             
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(DISTINCT                                             
MFA-TR*        CHAR(SO.SERV_ORDER_NO)                                           
MFA-TR*        ||OI.CODE_UTIL_TYPE                                              
MFA-TR*        ||OT.ORDER_GROUP_CD) INTO :WS-TOTAL                              
MFA-TR*       FROM                                                              
MFA-TR*         HST_SO_DATA       SO                                            
MFA-TR*        ,HST_SO_ORDER_INST OI                                            
MFA-TR*        ,CSS_ORDER_TYPE    OT                                            
MFA-TR*        ,CSS_WORK_TYPE     WT                                            
MFA-TR*        ,CSS_WK_CLASS_STAT WS                                            
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'TYP1' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))              
MFA-TR*         OR( :WS-VIEW-TYPE = 'TYP2' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))              
MFA-TR*         OR (:WS-VIEW-TYPE = 'TYP3' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                    
MFA-TR*       AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                           
MFA-TR*       AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                             
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))                
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))                  
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                     
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7611                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT TYP'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7611-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7612-GET-COUNT-TYP-RR                                          *        
      *                                                                *        
      *     GETS THE COUNT FOR TYP VIEW NON CREW WITH READ ROUTE       *        
      ******************************************************************        
                                                                        
       7612-GET-COUNT-TYP-RR.                                           
                                                                        
           MOVE '7612'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            SELECT COUNT(*) INTO :WS-TOTAL FROM (                       
              SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (   
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT DISTINCT                                       
                    SO.SERV_ORDER_NO                                    
                   ,OI.CODE_UTIL_TYPE                                   
                   ,OT.ORDER_GROUP_CD                                   
                  FROM                                                  
                    CSS_SO_DATA       SO WITH(READUNCOMMITTED)                  
                   ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                  
                   ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                  
                   ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                  
                   ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                  
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'TYP1' AND                      
                        SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))  
                    OR( :WS-VIEW-TYPE = 'TYP2' AND                      
                        SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))  
                    OR (:WS-VIEW-TYPE = 'TYP3' AND                      
                        SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))        
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )               
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              )                 
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))    
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))   
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))   
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))      
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))         
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                ) SO                                                    
                LEFT OUTER JOIN CSS_SO_UTL_CHG SC WITH(READUNCOMMITTED)         
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN CSS_SO_UTILITY SU WITH(READUNCOMMITTED)           
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
            ) SO                                                        
            WHERE                                                       
                 :WS-IS-RD-ROUTE-NULL = 'Y'                             
            OR ( :WS-IS-RD-ROUTE-NULL = 'N'                             
             AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                     
                OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT COUNT(*) INTO :WS-TOTAL FROM (                               
MFA-TR*       SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (           
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT DISTINCT                                               
MFA-TR*             SO.SERV_ORDER_NO                                            
MFA-TR*            ,OI.CODE_UTIL_TYPE                                           
MFA-TR*            ,OT.ORDER_GROUP_CD                                           
MFA-TR*           FROM                                                          
MFA-TR*             CSS_SO_DATA       SO                                        
MFA-TR*            ,CSS_SO_ORDER_INST OI                                        
MFA-TR*            ,CSS_ORDER_TYPE    OT                                        
MFA-TR*            ,CSS_WORK_TYPE     WT                                        
MFA-TR*            ,CSS_WK_CLASS_STAT WS                                        
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'TYP1' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))          
MFA-TR*             OR( :WS-VIEW-TYPE = 'TYP2' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))          
MFA-TR*             OR (:WS-VIEW-TYPE = 'TYP3' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                       
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                         
MFA-TR*           AND ( :WS-IS-STATE-NULL    = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATE-NULL    = 'N'                              
MFA-TR*             AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))            
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-STATUS-NULL   = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATUS-NULL   = 'N'                              
MFA-TR*             AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))              
MFA-TR*           AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                 
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                 
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN CSS_SO_UTL_CHG SC                               
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN CSS_SO_UTILITY SU                                 
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*     ) SO                                                                
MFA-TR*     WHERE                                                               
MFA-TR*          :WS-IS-RD-ROUTE-NULL = 'Y'                                     
MFA-TR*     OR ( :WS-IS-RD-ROUTE-NULL = 'N'                                     
MFA-TR*      AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                             
MFA-TR*         OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                         
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7612                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT TYP'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7612-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7613-GET-COUNT-TYP-RR-HT                                       *        
      *                                                                *        
      *     GETS THE COUNT FOR TYP VIEW NON CREW WITH READ ROUTE       *        
      ******************************************************************        
                                                                        
       7613-GET-COUNT-TYP-RR-HT.                                        
                                                                        
           MOVE '7613'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            SELECT COUNT(*) INTO :WS-TOTAL FROM (                       
              SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (   
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT DISTINCT                                       
                    SO.SERV_ORDER_NO                                    
                   ,OI.CODE_UTIL_TYPE                                   
                   ,OT.ORDER_GROUP_CD                                   
                  FROM                                                  
                    HST_SO_DATA       SO WITH(READUNCOMMITTED)                  
                   ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                  
                   ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                  
                   ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                  
                   ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                  
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'TYP1' AND                      
                        SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))  
                    OR( :WS-VIEW-TYPE = 'TYP2' AND                      
                        SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))  
                    OR (:WS-VIEW-TYPE = 'TYP3' AND                      
                        SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))        
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )               
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              )                 
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))    
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))   
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))   
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))      
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))         
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                ) SO                                                    
                LEFT OUTER JOIN HST_SO_UTL_CHG SC WITH(READUNCOMMITTED)         
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN HST_SO_UTILITY SU WITH(READUNCOMMITTED)           
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
            ) SO                                                        
            WHERE                                                       
                 :WS-IS-RD-ROUTE-NULL = 'Y'                             
            OR ( :WS-IS-RD-ROUTE-NULL = 'N'                             
             AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                     
                OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT COUNT(*) INTO :WS-TOTAL FROM (                               
MFA-TR*       SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (           
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT DISTINCT                                               
MFA-TR*             SO.SERV_ORDER_NO                                            
MFA-TR*            ,OI.CODE_UTIL_TYPE                                           
MFA-TR*            ,OT.ORDER_GROUP_CD                                           
MFA-TR*           FROM                                                          
MFA-TR*             HST_SO_DATA       SO                                        
MFA-TR*            ,HST_SO_ORDER_INST OI                                        
MFA-TR*            ,CSS_ORDER_TYPE    OT                                        
MFA-TR*            ,CSS_WORK_TYPE     WT                                        
MFA-TR*            ,CSS_WK_CLASS_STAT WS                                        
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'TYP1' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))          
MFA-TR*             OR( :WS-VIEW-TYPE = 'TYP2' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))          
MFA-TR*             OR (:WS-VIEW-TYPE = 'TYP3' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                       
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                         
MFA-TR*           AND ( :WS-IS-STATE-NULL    = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATE-NULL    = 'N'                              
MFA-TR*             AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))            
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-STATUS-NULL   = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATUS-NULL   = 'N'                              
MFA-TR*             AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))              
MFA-TR*           AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                 
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                 
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN HST_SO_UTL_CHG SC                               
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN HST_SO_UTILITY SU                                 
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*     ) SO                                                                
MFA-TR*     WHERE                                                               
MFA-TR*          :WS-IS-RD-ROUTE-NULL = 'Y'                                     
MFA-TR*     OR ( :WS-IS-RD-ROUTE-NULL = 'N'                                     
MFA-TR*      AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                             
MFA-TR*         OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                         
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7613                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT TYP'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7613-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7614-GET-COUNT-TYP-CW                                          *        
      *                                                                *        
      *     GETS THE COUNT FOR TYP VIEW CREW                           *        
      ******************************************************************        
                                                                        
       7614-GET-COUNT-TYP-CW.                                           
                                                                        
           MOVE '7615'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(DISTINCT                                     
               CIS.DECIMAL2CHAR(SO.SERV_ORDER_NO) + OI.CODE_UTIL_TYPE + 
           OT.ORDER_GROUP_CD) INTO :WS-TOTAL                      
              FROM                                                      
                CSS_SO_DATA       SO WITH(READUNCOMMITTED)                      
               ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                      
               ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                      
               ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                      
               ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                      
               ,CSS_SO_CREW       WM WITH(READUNCOMMITTED)                      
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'TYP1' AND                          
                    SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))      
                OR( :WS-VIEW-TYPE = 'TYP2' AND                          
                    SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))      
                OR (:WS-VIEW-TYPE = 'TYP3' AND                          
                    SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))            
              AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(:WS-FROM-TS
              )                   
              AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(:WS-TO-TS)         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))        
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))       
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))       
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))          
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))             
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND WM.CREW_ID           = :WS-CREW-ID                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(DISTINCT                                             
MFA-TR*        CHAR(SO.SERV_ORDER_NO)                                           
MFA-TR*        ||OI.CODE_UTIL_TYPE                                              
MFA-TR*        ||OT.ORDER_GROUP_CD) INTO :WS-TOTAL                              
MFA-TR*       FROM                                                              
MFA-TR*         CSS_SO_DATA       SO                                            
MFA-TR*        ,CSS_SO_ORDER_INST OI                                            
MFA-TR*        ,CSS_ORDER_TYPE    OT                                            
MFA-TR*        ,CSS_WORK_TYPE     WT                                            
MFA-TR*        ,CSS_WK_CLASS_STAT WS                                            
MFA-TR*        ,CSS_SO_CREW       WM                                            
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'TYP1' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))              
MFA-TR*         OR( :WS-VIEW-TYPE = 'TYP2' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))              
MFA-TR*         OR (:WS-VIEW-TYPE = 'TYP3' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                    
MFA-TR*       AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                           
MFA-TR*       AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                             
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))                
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))                  
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                     
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND WM.CREW_ID           = :WS-CREW-ID                            
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7614                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT TYP'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7614-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7615-GET-COUNT-TYP-CW-HT                                       *        
      *                                                                *        
      *     GETS THE COUNT FOR TYP VIEW CREW                           *        
      ******************************************************************        
                                                                        
       7615-GET-COUNT-TYP-CW-HT.                                        
                                                                        
           MOVE '7615'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(DISTINCT                                     
               CIS.DECIMAL2CHAR(SO.SERV_ORDER_NO) + OI.CODE_UTIL_TYPE + 
           OT.ORDER_GROUP_CD) INTO :WS-TOTAL                      
              FROM                                                      
                HST_SO_DATA       SO WITH(READUNCOMMITTED)                      
               ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                      
               ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                      
               ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                      
               ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                      
               ,HST_SO_CREW       WM WITH(READUNCOMMITTED)                      
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'TYP1' AND                          
                    SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))      
                OR( :WS-VIEW-TYPE = 'TYP2' AND                          
                    SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))      
                OR (:WS-VIEW-TYPE = 'TYP3' AND                          
                    SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))            
              AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(:WS-FROM-TS
              )                   
              AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(:WS-TO-TS)         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))        
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))       
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))       
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))          
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))             
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
              AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO               
              AND WM.CREW_ID           = :WS-CREW-ID                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(DISTINCT                                             
MFA-TR*        CHAR(SO.SERV_ORDER_NO)                                           
MFA-TR*        ||OI.CODE_UTIL_TYPE                                              
MFA-TR*        ||OT.ORDER_GROUP_CD) INTO :WS-TOTAL                              
MFA-TR*       FROM                                                              
MFA-TR*         HST_SO_DATA       SO                                            
MFA-TR*        ,HST_SO_ORDER_INST OI                                            
MFA-TR*        ,CSS_ORDER_TYPE    OT                                            
MFA-TR*        ,CSS_WORK_TYPE     WT                                            
MFA-TR*        ,CSS_WK_CLASS_STAT WS                                            
MFA-TR*        ,HST_SO_CREW       WM                                            
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'TYP1' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))              
MFA-TR*         OR( :WS-VIEW-TYPE = 'TYP2' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))              
MFA-TR*         OR (:WS-VIEW-TYPE = 'TYP3' AND                                  
MFA-TR*             SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                    
MFA-TR*       AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                           
MFA-TR*       AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                             
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))                
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))               
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))                  
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                     
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*       AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                       
MFA-TR*       AND WM.CREW_ID           = :WS-CREW-ID                            
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7615                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT TYP'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7615-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7616-GET-COUNT-TYP-CW-RR                                       *        
      *                                                                *        
      *     GETS THE COUNT FOR TYP VIEW CREW WITH READ ROUTE           *        
      ******************************************************************        
                                                                        
       7616-GET-COUNT-TYP-CW-RR.                                        
                                                                        
           MOVE '7616'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            SELECT COUNT(*) INTO :WS-TOTAL FROM (                       
              SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (   
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT DISTINCT                                       
                    SO.SERV_ORDER_NO                                    
                   ,OI.CODE_UTIL_TYPE                                   
                   ,OT.ORDER_GROUP_CD                                   
                  FROM                                                  
                    CSS_SO_DATA       SO WITH(READUNCOMMITTED)                  
                   ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                  
                   ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                  
                   ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                  
                   ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                  
                   ,CSS_SO_CREW       WM WITH(READUNCOMMITTED)                  
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'TYP1' AND                      
                        SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))  
                    OR( :WS-VIEW-TYPE = 'TYP2' AND                      
                        SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))  
                    OR (:WS-VIEW-TYPE = 'TYP3' AND                      
                        SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))        
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )               
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              )                 
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))    
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))   
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))   
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))      
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))         
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND WM.CREW_ID           = :WS-CREW-ID                
                ) SO                                                    
                LEFT OUTER JOIN CSS_SO_UTL_CHG SC WITH(READUNCOMMITTED)         
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN CSS_SO_UTILITY SU WITH(READUNCOMMITTED)           
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
            ) SO                                                        
            WHERE                                                       
                 :WS-IS-RD-ROUTE-NULL = 'Y'                             
            OR ( :WS-IS-RD-ROUTE-NULL = 'N'                             
             AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                     
                OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT COUNT(*) INTO :WS-TOTAL FROM (                               
MFA-TR*       SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (           
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT DISTINCT                                               
MFA-TR*             SO.SERV_ORDER_NO                                            
MFA-TR*            ,OI.CODE_UTIL_TYPE                                           
MFA-TR*            ,OT.ORDER_GROUP_CD                                           
MFA-TR*           FROM                                                          
MFA-TR*             CSS_SO_DATA       SO                                        
MFA-TR*            ,CSS_SO_ORDER_INST OI                                        
MFA-TR*            ,CSS_ORDER_TYPE    OT                                        
MFA-TR*            ,CSS_WORK_TYPE     WT                                        
MFA-TR*            ,CSS_WK_CLASS_STAT WS                                        
MFA-TR*            ,CSS_SO_CREW       WM                                        
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'TYP1' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))          
MFA-TR*             OR( :WS-VIEW-TYPE = 'TYP2' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))          
MFA-TR*             OR (:WS-VIEW-TYPE = 'TYP3' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                       
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                         
MFA-TR*           AND ( :WS-IS-STATE-NULL    = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATE-NULL    = 'N'                              
MFA-TR*             AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))            
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-STATUS-NULL   = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATUS-NULL   = 'N'                              
MFA-TR*             AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))              
MFA-TR*           AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                 
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                 
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND WM.CREW_ID           = :WS-CREW-ID                        
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN CSS_SO_UTL_CHG SC                               
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN CSS_SO_UTILITY SU                                 
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*     ) SO                                                                
MFA-TR*     WHERE                                                               
MFA-TR*          :WS-IS-RD-ROUTE-NULL = 'Y'                                     
MFA-TR*     OR ( :WS-IS-RD-ROUTE-NULL = 'N'                                     
MFA-TR*      AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                             
MFA-TR*         OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                         
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7616                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT TYP'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7616-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7617-GET-COUNT-TYP-CW-RR-HT                                    *        
      *                                                                *        
      *     GETS THE COUNT FOR TYP VIEW CREW WITH READ ROUTE           *        
      ******************************************************************        
                                                                        
       7617-GET-COUNT-TYP-CW-RR-HT.                                     
                                                                        
           MOVE '7617'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            SELECT COUNT(*) INTO :WS-TOTAL FROM (                       
              SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (   
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT DISTINCT                                       
                    SO.SERV_ORDER_NO                                    
                   ,OI.CODE_UTIL_TYPE                                   
                   ,OT.ORDER_GROUP_CD                                   
                  FROM                                                  
                    HST_SO_DATA       SO WITH(READUNCOMMITTED)                  
                   ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                  
                   ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                  
                   ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                  
                   ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                  
                   ,HST_SO_CREW       WM WITH(READUNCOMMITTED)                  
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'TYP1' AND                      
                        SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))  
                    OR( :WS-VIEW-TYPE = 'TYP2' AND                      
                        SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))  
                    OR (:WS-VIEW-TYPE = 'TYP3' AND                      
                        SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))        
                  AND SO.ASSIGNED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )               
                  AND SO.ASSIGNED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              )                 
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))    
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))   
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))   
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))      
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))         
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                  AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO           
                  AND WM.CREW_ID           = :WS-CREW-ID                
                ) SO                                                    
                LEFT OUTER JOIN HST_SO_UTL_CHG SC WITH(READUNCOMMITTED)         
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN HST_SO_UTILITY SU WITH(READUNCOMMITTED)           
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
            ) SO                                                        
            WHERE                                                       
                 :WS-IS-RD-ROUTE-NULL = 'Y'                             
            OR ( :WS-IS-RD-ROUTE-NULL = 'N'                             
             AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                     
                OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT COUNT(*) INTO :WS-TOTAL FROM (                               
MFA-TR*       SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (           
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT DISTINCT                                               
MFA-TR*             SO.SERV_ORDER_NO                                            
MFA-TR*            ,OI.CODE_UTIL_TYPE                                           
MFA-TR*            ,OT.ORDER_GROUP_CD                                           
MFA-TR*           FROM                                                          
MFA-TR*             HST_SO_DATA       SO                                        
MFA-TR*            ,HST_SO_ORDER_INST OI                                        
MFA-TR*            ,CSS_ORDER_TYPE    OT                                        
MFA-TR*            ,CSS_WORK_TYPE     WT                                        
MFA-TR*            ,CSS_WK_CLASS_STAT WS                                        
MFA-TR*            ,HST_SO_CREW       WM                                        
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'TYP1' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('CC001','CC002','CC003'))          
MFA-TR*             OR( :WS-VIEW-TYPE = 'TYP2' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD IN ('OFF01','OFF02','OFF03'))          
MFA-TR*             OR (:WS-VIEW-TYPE = 'TYP3' AND                              
MFA-TR*                 SO.ORDER_TYPE_CD =  :WS-ORDER-TYPE-CD ))                
MFA-TR*           AND SO.ASSIGNED_DATETIME >= :WS-FROM-TS                       
MFA-TR*           AND SO.ASSIGNED_DATETIME <= :WS-TO-TS                         
MFA-TR*           AND ( :WS-IS-STATE-NULL    = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATE-NULL    = 'N'                              
MFA-TR*             AND SO.ORDER_STATE_CD       = :WS-SO-STATE-CD ))            
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID         = :WS-RESP-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID         = :WS-WORK-AREA-ID ))           
MFA-TR*           AND ( :WS-IS-STATUS-NULL   = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATUS-NULL   = 'N'                              
MFA-TR*             AND SO.SERV_ORDER_STATUS    = :WS-SO-STATUS ))              
MFA-TR*           AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                 
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ))                 
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*           AND WM.SERV_ORDER_NO     = SO.SERV_ORDER_NO                   
MFA-TR*           AND WM.CREW_ID           = :WS-CREW-ID                        
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN HST_SO_UTL_CHG SC                               
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN HST_SO_UTILITY SU                                 
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*     ) SO                                                                
MFA-TR*     WHERE                                                               
MFA-TR*          :WS-IS-RD-ROUTE-NULL = 'Y'                                     
MFA-TR*     OR ( :WS-IS-RD-ROUTE-NULL = 'N'                                     
MFA-TR*      AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                             
MFA-TR*         OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                         
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7617                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT TYP'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7617-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7620-GET-COUNT-DTE                                             *        
      *                                                                *        
      *     GETS THE COUNT FOR DTE VIEW NON CREW                       *        
      ******************************************************************        
                                                                        
       7620-GET-COUNT-DTE.                                              
                                                                        
           MOVE '7620'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(DISTINCT                                     
               CIS.DECIMAL2CHAR(SO.SERV_ORDER_NO) + OI.CODE_UTIL_TYPE + 
           OT.ORDER_GROUP_CD) INTO :WS-TOTAL                      
              FROM                                                      
                CSS_SO_DATA       SO WITH(READUNCOMMITTED)                      
               ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                      
               ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                      
               ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                      
               ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                      
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'BEG'                               
                AND SO.BEGIN_APPT_DT      >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.BEGIN_APPT_DT      <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'COM'                               
                AND SO.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'PRT'                               
                AND SO.DATE_PRINTED       >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.DATE_PRINTED       <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'SCH'                               
                AND SO.ASSIGNED_DATETIME  >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.ASSIGNED_DATETIME  <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'REC'                               
                AND SO.DATE_RECVED        >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.DATE_RECVED        <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
              )                                                         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )          
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )         
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )         
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )            
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )            
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(DISTINCT                                             
MFA-TR*        CHAR(SO.SERV_ORDER_NO)                                           
MFA-TR*        ||OI.CODE_UTIL_TYPE                                              
MFA-TR*        ||OT.ORDER_GROUP_CD) INTO :WS-TOTAL                              
MFA-TR*       FROM                                                              
MFA-TR*         CSS_SO_DATA       SO                                            
MFA-TR*        ,CSS_SO_ORDER_INST OI                                            
MFA-TR*        ,CSS_ORDER_TYPE    OT                                            
MFA-TR*        ,CSS_WORK_TYPE     WT                                            
MFA-TR*        ,CSS_WK_CLASS_STAT WS                                            
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'BEG'                                       
MFA-TR*         AND SO.BEGIN_APPT_DT      >= :WS-FROM-TS                        
MFA-TR*         AND SO.BEGIN_APPT_DT      <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'COM'                                       
MFA-TR*         AND SO.COMPLETED_DATETIME >= :WS-FROM-TS                        
MFA-TR*         AND SO.COMPLETED_DATETIME <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'PRT'                                       
MFA-TR*         AND SO.DATE_PRINTED       >= :WS-FROM-TS                        
MFA-TR*         AND SO.DATE_PRINTED       <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'SCH'                                       
MFA-TR*         AND SO.ASSIGNED_DATETIME  >= :WS-FROM-TS                        
MFA-TR*         AND SO.ASSIGNED_DATETIME  <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'REC'                                       
MFA-TR*         AND SO.DATE_RECVED        >= :WS-FROM-TS                        
MFA-TR*         AND SO.DATE_RECVED        <= :WS-TO-TS )                        
MFA-TR*       )                                                                 
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )                  
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )                    
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                    
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7620                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT DTE'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7621-GET-COUNT-DTE-HT                                          *        
      *                                                                *        
      *     GETS THE COUNT FOR DTE VIEW NON CREW                       *        
      ******************************************************************        
                                                                        
       7621-GET-COUNT-DTE-HT.                                           
                                                                        
           MOVE '7621'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(DISTINCT                                     
               CIS.DECIMAL2CHAR(SO.SERV_ORDER_NO) + OI.CODE_UTIL_TYPE + 
           OT.ORDER_GROUP_CD) INTO :WS-TOTAL                      
              FROM                                                      
                HST_SO_DATA       SO WITH(READUNCOMMITTED)                      
               ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                      
               ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                      
               ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                      
               ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                      
              WHERE                                                     
                  SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE               
              AND                                                       
              (   ( :WS-VIEW-TYPE = 'BEG'                               
                AND SO.BEGIN_APPT_DT      >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.BEGIN_APPT_DT      <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'COM'                               
                AND SO.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'PRT'                               
                AND SO.DATE_PRINTED       >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.DATE_PRINTED       <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'SCH'                               
                AND SO.ASSIGNED_DATETIME  >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.ASSIGNED_DATETIME  <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
               OR ( :WS-VIEW-TYPE = 'REC'                               
                AND SO.DATE_RECVED        >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )                
                AND SO.DATE_RECVED        <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )                
              )                                                         
              AND ( :WS-IS-STATE-NULL    = 'Y'                          
               OR ( :WS-IS-STATE-NULL    = 'N'                          
                AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )          
              AND ( :WS-IS-RSP-AREA-NULL = 'Y'                          
               OR ( :WS-IS-RSP-AREA-NULL = 'N'                          
                AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )         
              AND ( :WS-IS-WRK-AREA-NULL = 'Y'                          
               OR ( :WS-IS-WRK-AREA-NULL = 'N'                          
                AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )         
              AND ( :WS-IS-STATUS-NULL   = 'Y'                          
               OR ( :WS-IS-STATUS-NULL   = 'N'                          
                AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )            
              AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO             
              AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                          
               OR ( :WS-IS-WRK-TYPE-NULL = 'N'                          
                AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )            
              AND OT.COMPANY_NO        = SO.COMPANY_NO                  
              AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD               
              AND WT.COMPANY_NO        = SO.COMPANY_NO                  
              AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                
              AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS           
              AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(DISTINCT                                             
MFA-TR*        CHAR(SO.SERV_ORDER_NO)                                           
MFA-TR*        ||OI.CODE_UTIL_TYPE                                              
MFA-TR*        ||OT.ORDER_GROUP_CD) INTO :WS-TOTAL                              
MFA-TR*       FROM                                                              
MFA-TR*         HST_SO_DATA       SO                                            
MFA-TR*        ,HST_SO_ORDER_INST OI                                            
MFA-TR*        ,CSS_ORDER_TYPE    OT                                            
MFA-TR*        ,CSS_WORK_TYPE     WT                                            
MFA-TR*        ,CSS_WK_CLASS_STAT WS                                            
MFA-TR*       WHERE                                                             
MFA-TR*           SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                       
MFA-TR*       AND                                                               
MFA-TR*       (   ( :WS-VIEW-TYPE = 'BEG'                                       
MFA-TR*         AND SO.BEGIN_APPT_DT      >= :WS-FROM-TS                        
MFA-TR*         AND SO.BEGIN_APPT_DT      <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'COM'                                       
MFA-TR*         AND SO.COMPLETED_DATETIME >= :WS-FROM-TS                        
MFA-TR*         AND SO.COMPLETED_DATETIME <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'PRT'                                       
MFA-TR*         AND SO.DATE_PRINTED       >= :WS-FROM-TS                        
MFA-TR*         AND SO.DATE_PRINTED       <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'SCH'                                       
MFA-TR*         AND SO.ASSIGNED_DATETIME  >= :WS-FROM-TS                        
MFA-TR*         AND SO.ASSIGNED_DATETIME  <= :WS-TO-TS )                        
MFA-TR*        OR ( :WS-VIEW-TYPE = 'REC'                                       
MFA-TR*         AND SO.DATE_RECVED        >= :WS-FROM-TS                        
MFA-TR*         AND SO.DATE_RECVED        <= :WS-TO-TS )                        
MFA-TR*       )                                                                 
MFA-TR*       AND ( :WS-IS-STATE-NULL    = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATE-NULL    = 'N'                                  
MFA-TR*         AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )                  
MFA-TR*       AND ( :WS-IS-RSP-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-RSP-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-WRK-AREA-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-AREA-NULL = 'N'                                  
MFA-TR*         AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )                 
MFA-TR*       AND ( :WS-IS-STATUS-NULL   = 'Y'                                  
MFA-TR*        OR ( :WS-IS-STATUS-NULL   = 'N'                                  
MFA-TR*         AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )                    
MFA-TR*       AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                     
MFA-TR*       AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                                  
MFA-TR*        OR ( :WS-IS-WRK-TYPE-NULL = 'N'                                  
MFA-TR*         AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                    
MFA-TR*       AND OT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                       
MFA-TR*       AND WT.COMPANY_NO        = SO.COMPANY_NO                          
MFA-TR*       AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                        
MFA-TR*       AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS                   
MFA-TR*       AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                       
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7621                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT DTE'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7621-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7622-GET-COUNT-DTE-RR                                          *        
      *                                                                *        
      *     GETS THE COUNT FOR DTE VIEW NON CREW WITH READ ROUTE       *        
      ******************************************************************        
                                                                        
       7622-GET-COUNT-DTE-RR.                                           
                                                                        
           MOVE '7622'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            SELECT COUNT(*) INTO :WS-TOTAL FROM (                       
              SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (   
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT DISTINCT                                       
                    SO.SERV_ORDER_NO                                    
                   ,OI.CODE_UTIL_TYPE                                   
                   ,OT.ORDER_GROUP_CD                                   
                  FROM                                                  
                    CSS_SO_DATA       SO WITH(READUNCOMMITTED)                  
                   ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                  
                   ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                  
                   ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                  
                   ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                  
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'BEG'                           
                    AND SO.BEGIN_APPT_DT      >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.BEGIN_APPT_DT      <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'COM'                           
                    AND SO.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'PRT'                           
                    AND SO.DATE_PRINTED       >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.DATE_PRINTED       <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'SCH'                           
                    AND SO.ASSIGNED_DATETIME  >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.ASSIGNED_DATETIME  <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'REC'                           
                    AND SO.DATE_RECVED        >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.DATE_RECVED        <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                  )                                                     
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )      
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )     
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )     
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )        
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )        
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                ) SO                                                    
                LEFT OUTER JOIN CSS_SO_UTL_CHG SC WITH(READUNCOMMITTED)         
                ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                
                AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE               
              ) SO                                                      
              LEFT OUTER JOIN CSS_SO_UTILITY SU WITH(READUNCOMMITTED)           
              ON  SO.READ_ROUTE     = 0                                 
              AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                  
              AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                 
            ) SO                                                        
            WHERE                                                       
                 :WS-IS-RD-ROUTE-NULL = 'Y'                             
            OR ( :WS-IS-RD-ROUTE-NULL = 'N'                             
             AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                     
                OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT COUNT(*) INTO :WS-TOTAL FROM (                               
MFA-TR*       SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (           
MFA-TR*         SELECT SO.*,IFNULL(SC.READ_ROUTE,0) READ_ROUTE FROM (           
MFA-TR*           SELECT DISTINCT                                               
MFA-TR*             SO.SERV_ORDER_NO                                            
MFA-TR*            ,OI.CODE_UTIL_TYPE                                           
MFA-TR*            ,OT.ORDER_GROUP_CD                                           
MFA-TR*           FROM                                                          
MFA-TR*             CSS_SO_DATA       SO                                        
MFA-TR*            ,CSS_SO_ORDER_INST OI                                        
MFA-TR*            ,CSS_ORDER_TYPE    OT                                        
MFA-TR*            ,CSS_WORK_TYPE     WT                                        
MFA-TR*            ,CSS_WK_CLASS_STAT WS                                        
MFA-TR*           WHERE                                                         
MFA-TR*               SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE                   
MFA-TR*           AND                                                           
MFA-TR*           (   ( :WS-VIEW-TYPE = 'BEG'                                   
MFA-TR*             AND SO.BEGIN_APPT_DT      >= :WS-FROM-TS                    
MFA-TR*             AND SO.BEGIN_APPT_DT      <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'COM'                                   
MFA-TR*             AND SO.COMPLETED_DATETIME >= :WS-FROM-TS                    
MFA-TR*             AND SO.COMPLETED_DATETIME <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'PRT'                                   
MFA-TR*             AND SO.DATE_PRINTED       >= :WS-FROM-TS                    
MFA-TR*             AND SO.DATE_PRINTED       <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'SCH'                                   
MFA-TR*             AND SO.ASSIGNED_DATETIME  >= :WS-FROM-TS                    
MFA-TR*             AND SO.ASSIGNED_DATETIME  <= :WS-TO-TS )                    
MFA-TR*            OR ( :WS-VIEW-TYPE = 'REC'                                   
MFA-TR*             AND SO.DATE_RECVED        >= :WS-FROM-TS                    
MFA-TR*             AND SO.DATE_RECVED        <= :WS-TO-TS )                    
MFA-TR*           )                                                             
MFA-TR*           AND ( :WS-IS-STATE-NULL    = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATE-NULL    = 'N'                              
MFA-TR*             AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )              
MFA-TR*           AND ( :WS-IS-RSP-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-RSP-AREA-NULL = 'N'                              
MFA-TR*             AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-WRK-AREA-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-AREA-NULL = 'N'                              
MFA-TR*             AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )             
MFA-TR*           AND ( :WS-IS-STATUS-NULL   = 'Y'                              
MFA-TR*            OR ( :WS-IS-STATUS-NULL   = 'N'                              
MFA-TR*             AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )                
MFA-TR*           AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO                 
MFA-TR*           AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                              
MFA-TR*            OR ( :WS-IS-WRK-TYPE-NULL = 'N'                              
MFA-TR*             AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )                
MFA-TR*           AND OT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD                   
MFA-TR*           AND WT.COMPANY_NO        = SO.COMPANY_NO                      
MFA-TR*           AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD                    
MFA-TR*           AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS               
MFA-TR*           AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID                   
MFA-TR*         ) SO                                                            
MFA-TR*         LEFT OUTER JOIN CSS_SO_UTL_CHG SC                               
MFA-TR*         ON  SO.SERV_ORDER_NO  = SC.SERV_ORDER_NO                        
MFA-TR*         AND SO.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                       
MFA-TR*       ) SO                                                              
MFA-TR*       LEFT OUTER JOIN CSS_SO_UTILITY SU                                 
MFA-TR*       ON  SO.READ_ROUTE     = 0                                         
MFA-TR*       AND SO.SERV_ORDER_NO  = SU.SERV_ORDER_NO                          
MFA-TR*       AND SO.CODE_UTIL_TYPE = SU.CODE_UTIL_TYPE                         
MFA-TR*     ) SO                                                                
MFA-TR*     WHERE                                                               
MFA-TR*          :WS-IS-RD-ROUTE-NULL = 'Y'                                     
MFA-TR*     OR ( :WS-IS-RD-ROUTE-NULL = 'N'                                     
MFA-TR*      AND ( SO.READ_ROUTE   = :WS-READ-ROUTE                             
MFA-TR*         OR SO.READ_ROUTE_U = :WS-READ-ROUTE ) )                         
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7622                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'COUNT DTE'                TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7622-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7623-GET-COUNT-DTE-RR-HT                                       *        
      *                                                                *        
      *     GETS THE COUNT FOR DTE VIEW NON CREW WITH READ ROUTE       *        
      ******************************************************************        
                                                                        
       7623-GET-COUNT-DTE-RR-HT.                                        
                                                                        
           MOVE '7623'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
            SELECT COUNT(*) INTO :WS-TOTAL FROM (                       
              SELECT DISTINCT SO.*, SU.READ_ROUTE READ_ROUTE_U FROM (   
                SELECT SO.*,COALESCE(SC.READ_ROUTE,0) READ_ROUTE FROM (   
                  SELECT DISTINCT                                       
                    SO.SERV_ORDER_NO                                    
                   ,OI.CODE_UTIL_TYPE                                   
                   ,OT.ORDER_GROUP_CD                                   
                  FROM                                                  
                    HST_SO_DATA       SO WITH(READUNCOMMITTED)                  
                   ,HST_SO_ORDER_INST OI WITH(READUNCOMMITTED)                  
                   ,CSS_ORDER_TYPE    OT WITH(READUNCOMMITTED)                  
                   ,CSS_WORK_TYPE     WT WITH(READUNCOMMITTED)                  
                   ,CSS_WK_CLASS_STAT WS WITH(READUNCOMMITTED)                  
                  WHERE                                                 
                      SO.LOCAL_OFFICE      = :WS-LOCAL-OFFICE           
                  AND                                                   
                  (   ( :WS-VIEW-TYPE = 'BEG'                           
                    AND SO.BEGIN_APPT_DT      >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.BEGIN_APPT_DT      <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'COM'                           
                    AND SO.COMPLETED_DATETIME >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.COMPLETED_DATETIME <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'PRT'                           
                    AND SO.DATE_PRINTED       >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.DATE_PRINTED       <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'SCH'                           
                    AND SO.ASSIGNED_DATETIME  >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.ASSIGNED_DATETIME  <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                   OR ( :WS-VIEW-TYPE = 'REC'                           
                    AND SO.DATE_RECVED        >= CIS.CHAR2TIMESTAMP(
                                                            :WS-FROM-TS
              )            
                    AND SO.DATE_RECVED        <= CIS.CHAR2TIMESTAMP(
                                                              :WS-TO-TS
              ) )            
                  )                                                     
                  AND ( :WS-IS-STATE-NULL    = 'Y'                      
                   OR ( :WS-IS-STATE-NULL    = 'N'                      
                    AND SO.ORDER_STATE_CD    = :WS-SO-STATE-CD ) )      
                  AND ( :WS-IS-RSP-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-RSP-AREA-NULL = 'N'                      
                    AND SO.RESP_AREA_ID      = :WS-RESP-AREA-ID ) )     
                  AND ( :WS-IS-WRK-AREA-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-AREA-NULL = 'N'                      
                    AND SO.WORK_AREA_ID      = :WS-WORK-AREA-ID ) )     
                  AND ( :WS-IS-STATUS-NULL   = 'Y'                      
                   OR ( :WS-IS-STATUS-NULL   = 'N'                      
                    AND SO.SERV_ORDER_STATUS = :WS-SO-STATUS ) )        
                  AND OI.SERV_ORDER_NO       = SO.SERV_ORDER_NO         
                  AND ( :WS-IS-WRK-TYPE-NULL = 'Y'                      
                   OR ( :WS-IS-WRK-TYPE-NULL = 'N'                      
                    AND OI.WORK_TYPE_CD      = :WS-WORK-TYPE ) )        
                  AND OT.COMPANY_NO        = SO.COMPANY_NO              
                  AND OT.ORDER_TYPE_CD     = SO.ORDER_TYPE_CD           
                  AND WT.COMPANY_NO        = SO.COMPANY_NO              
                  AND WT.WORK_TYPE_CD      = OI.WORK_TYPE_CD            
                  AND WS.SERV_ORDER_STATUS = SO.SERV_ORDER_STATUS       
                  AND WS.WORK_CLASS_ID     = OT.WORK_CLASS_ID           
                ) SO                                                    
                LEFT OUTER JOIN HST_SO_UTL_CHG SC WITH(READUNCOMMITTED)         
          