       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR00109.                                          
       DATE-WRITTEN.  MAY 28, 2007.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS USED  TO VALIDATE SO BEFORE POSTING           *        
      *                                                                *        
      *  PROGRAM:       CSR00109                                       *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  05/28/95    AS       SP ORIGINALLY WRITTEN.                   *        
      *                                                                *        
      *  09/18/95    MJG      MODIFIED TO ONLY DO EDITS ON METERS      *        
      *                       THAT HAVE CHANGED                        *        
      *  10/13/95    AS       SP MODIFIED TO DISPLAY CORRECT VALUES    *        
      *                       FOR METER DIALS/CONSTANTS                *        
      *  10/18/95    AS       SP MODIFIED TO CHECK WHETHER NO          *        
      *                       METERS IN SO EQUALS NO. OF INSTALLED     *        
      *                       METERS.                                  *        
      *  12/05/95    AS       EDIT ADDED TO CHECK FOR CITY GATE IDS    *        
      *                       FOR GAS METERS                           *        
      *  12/12/95    AS       SP MODIFIED TO CHECK CHARGE AMOUNTS      *        
      *                       FOR CC AND NC ORDERS.                    *        
      *                                                                *        
      *  12/19/95    AS       SP MODIFIED TO CHECK CHARGE AMOUNTS      *        
      *                       FOR SET ORDERS.                          *        
      *  01/29/96    DMD      TPR 2914 & 2915: ADDED CHECK TO NOT      *        
      *                       ALLOW SEASONAL OFF SERVICE ORDERS FOR    *        
      *                       METERS THAT ARE INACTIVE/REMOVED,        *        
      *                       ACTIVE/LIMITED OR INACTIVE-TURNED OFF    *        
      *  02/23/96    WMG      TPR 3093: ADDED CHECK TO NOT ALLOW AN    *        
      *                       OFF ORDER TO HAVE INACTIVE OR REMOVED    *        
      *  02/26/96    WMG      TPR 3273: ADDED CHECK TO NOT ALLOW A     *        
      *                       SEASONAL ON ORDER TO POST WHEN THE       *        
      *                       METER STATUS REASON IS NOT 'SEASONAL'.   *        
      *  03/11/96    WMG      ADDED LOGIC TO DO A HIGH/LOW METER READ  *        
      *                       CHECK WHEN POSTING A METER FOR AN        *        
      *                       INACTIVE, WRITE-OFF OR FINALED ACCOUNT   *        
      *  03/19/96    WMG      ADDED LOGIC TO DISALLOW METER STATUSES   *        
      *                       OF 'MONITOR ONLY' FOR SEASONAL OFF       *        
      *                       ORDERS.                                  *        
      *  03/25/96    WMG      BYPASS ERROR MESSAGE IF THE              *        
      *                       POST_MTR_CHG_IND INDICATOR ON            *        
      *                       CSS_SO_MTR_CHG IS SET TO 'N'.            *        
      *  03/26/96    JHR      TPR 3647: CHANGED FINAL BILL CHECK ON    *        
      *                       OCCUPANT CHANGE ORDERS TO LOOK FOR A     *        
      *                       CODES_DATA_PRESENT VALUE NOT = "A".      *        
      *  04/01/96    WMG      TPR 3689: ADDED CHECK TO DISALLOW THE    *        
      *                       POST OF AN OCCUPANT CHANGE ORDER WHEN    *        
      *                       AN OFF ORDER EXISTS FOR A SCHEDULE DATE  *        
      *                       THAT IS BEFORE THE SCHEDULE DATE FOR     *        
      *                       THE OCCUPANT CHANGE ORDER.  METER        *        
      *                       STATUSES OF 'INACTIVE' AND 'REMOVED'     *        
      *                       WERE MODIFIED TO BE VALID FOR FM003      *        
      *                       (METER ORDER WORK) ORDERS.               *        
      *  03/29/96    BB       CHANGED HEADER TO CONFORM TO NEW         *        
      *                       STANDARDS.                               *        
      *  04/30/96    WMG      MODIFIED CHECK FOR SERVICE CHARGES ON    *        
      *                       NON-ACTIVE ACCOUNTS TO INCLUDE ALL       *        
      *                       CHARGES TABLES - ALSO SIMPLIFIED THE     *        
      *                       CHECK.                                   *        
      *  05/21/96    WMG      TPR 4218 - ADDED LOW METER READ CHECK    *        
      *                       FOR BACK-DATED SERVICE ORDERS.           *        
      *  06/04/96    WMG      TPR 4444 - REMOVED FINAL BILL CHECK FOR  *        
      *                       OCCUPANT CHANGE ORDERS.                  *        
      *  06/14/96    WMG      TPR 4553 - REMOVED REFERENCES TO ERROR   *        
      *                       MESSAGE SO250.                           *        
      *  09/11/96    WMG      TPR 5269 - BYPASS SO058 AND SO252 ERROR  *        
      *                       MESSAGING FOR MV90 METERS SINCE THEY DO  *        
      *                       NOT REQUIRE A READING.                   *        
      *  09/20/96    WMG      CAD DEVELOPMENT CHANGES - ADDED THE      *        
      *                       CALLING PARAMETER @CAD_EDIT_FLAG TO THE  *        
      *                       CALLING PARAMETER LIST.  WHEN THIS       *        
      *                       SP IS CALLED WITH THE @CAD_EDIT_FLAG     *        
      *                       SET TO 'Y', THE CAD EDIT SP              *        
      *                       (PD_D0000318) WILL BE INVOKED.           *        
      *  11/06/96    WMG      TPR 3004 - ADD CHECK FOR ASSIGNED OR IN  *        
      *                       PROCESS BILL EXCEPTION WORK QUEUES FOR   *        
      *                       THE PREMISE OR PRIOR ACCOUNT WHEN        *        
      *                       POSTING A CC, NC OR OFF ORDER.           *        
      *  11/21/96    AS       TPR 5269 - PASS MTR_READ_SOURCE_CD       *        
      *                       TO PD_D0000037 SO THAT HI/LO CHECKS      *        
      *                       ARE NOT PERFORMED FOR MV90 METERS.       *        
      *                       FOR OFF ORDERS.                          *        
      *  01/18/97    MJG      TPR 8680 - SET ORDERS WERE GETTING A     *        
      *                       MISMATCH ON THE NUMBER OF INSTALLED      *        
      *                       METERS.  BY CHANGING THE NO_METERS       *        
      *                       COUNTER TO ONLY LOOK AT INSTALLED WE     *        
      *                       WERE ABLE TO FIX THIS PROBLEM            *        
      *  03/05/97    WMG      TPR 9518 - JOIN TO THE ORDER             *        
      *                       INSTRUCTION TABLE TO CHECK FOR WORK      *        
      *                       TYPES WHEN VALIDATING THE METER STATUS   *        
      *                       REASON FOR SEASONAL ON ORDERS.           *        
      *  03/26/97    WMG      TPR 9867 - ADDED ADDITIONAL CHECK FOR    *        
      *                       NUMBER OF METERS INSTALLED TO ACCOUNT    *        
      *                       FOR THE SITUATION WHEN AN ORDER MAY      *        
      *                       HAVE BEEN POSTED AND ANOTHER EXISTING    *        
      *                       ORDER HAS NOT BEEN REFRESHED WITH THE    *        
      *                       UP-TO-DATE METER INFORMATION (I.E.       *        
      *                       POST A SET TO ADD A METER WHEN ANOTHER   *        
      *                       SET ORDER ALREADY EXISTS AND THEN        *        
      *                       ATTEMPT TO POST THE 2ND SET ORDER).      *        
      *  04/15/97    WMG      REMOVE THE PREDICATES OF                 *        
      *                       CODE_MTR_STATUS_IS != 'K' AND            *        
      *                       CODE_REG_STATUS_IS != 'K' WHEN           *        
      *                       INSERTING METER ROWS INTO #HOLD_TABLE.   *        
      *                       SINCE THE METER RELOAD FUNCTIONALITY IS  *        
      *                       NOW AVAILABLE ON PANEL026, THIS CHECK    *        
      *                       IS NO LONGER NECESSARY.                  *        
      *  04/24/97    WMG      TPR 10563 - CANNOT COMPLETE CERTAIN      *        
      *                       ORDER TYPES AS NON-PRODUCTIVE.           *        
      *  05/06/97    WMG      TPR 10908 - CANNOT POST A SET ORDER      *        
      *                       WHEN THE NEW METER HAS NO POINT ID.     -*        
      *  03/10/98    TQT      TPR 14728 - CHANGE FUNCTIONALITY TO     .*        
      *                       CHECK HIGH/LOW VALUES                    *        
      *  09/02/98    FB       PCR 631 - HI-LOW CHECKS.                 *        
      *  09/24/98    AMB      TPR 17915 - Y2K COMPLIANCE CHANGES.      *        
      *  11/07/98    PRA      TPR 18409 - DON'T LET SET ORDER POST     *        
      *                       IF ACCT IS PENDING AND EARLIER PENDING   *        
      *                       SET EXISTS                               *        
      *  01/28/99    FB       TPR 17638 - DON'T PERFORM HIGH/LOW       *        
      *                       CHECKS FOR ENDV ORDERS.                  *        
      *  02/22/99    FB       TPR 19208 - DON'T PERFORM HIGH/LOW       *        
      *                       CHECKS FOR RECONNECT ORDERS.  IF THE     *        
      *                       COMPUTED DATEDIFF = 0, USE THE MAX AND   *        
      *                       MIN UNITS FROM THE HIGH/LOW ROUTINE.     *        
      *                       IF THE ACCOUNT STATUS IS NOT ACTIVE,     *        
      *                       BYPASS HIGH/LOW CHECKS                   *        
      *  03/25/99    FB       TPR 19713 - GENERATE SO058 IF           *         
      *                       DIFFERENCE 4 OR GREATER (NOT 3).                  
      *                       TPR 19902 - MODIFY HI-LO CRITERIA.  DO   *        
      *                       NOT CALL IF STATUS-WAS = J OR K AND      *        
      *                       CURRENT AND PREVIOUS READINGS MATCH.     *        
      *                       REMOVE RECONNECT ORDER CRITERIA.         *        
      *                       TPR 19285 - DO NOT ALLOW UNBLOCK WORK    *        
      *                       TYPE FOR REMOVED METERS.                 *        
      *                       TPR 19216 - DO NOT ALLOW A SOL, SOS,     *        
      *                       OR SOR TO POST UNLESS THE METER STATUS   *        
      *                       IS NOT K (REMOVED).                      *        
      *                       TPR 19405 - DO NOT GENERATE SO252 FOR    *        
      *                       SET OLD LOCATION WORK TYPES.             *        
      *                       TPR 20105 - DO NOT PERFORM 'ACCOUNT      *        
      *                       READY TO BILL' CHECK FOR CC ORDERS.      *        
      *                       TPR 19847 - DO NOT GENERATE SO252 FOR    *        
      *                       METER CHANGE ORDERS.                     *        
      *              LHO      TPR 20116 - CHANGED SELECT TO COMPARE    *        
      *                       MTR_REF_NO INSTEAD OF METER_NO TO        *        
      *                       DETERMINE WHEN TO DISPLAY MESSAGE SO081  *        
      *              MJG      TPR 21703 - KEEP CODES_DATA_PRESENT      *        
      *                       IN SYNC WITH CSS_MTR_CHG                 *        
      *  05/03/00    FB       TPR 22165 - DO NOT PERFORM 'ACCOUNT      *        
      *                       READY TO BILL' CHECK FOR UMRCC ORDERS.   *        
      *                       TPR 20906 - ADD NEW MESSAGE FOR SET      *        
      *                       ORDERS.                                  *        
      *  06/12/00    MJG      TPR 22275.  ADDED MESSAGE TO REQUIRE     *        
      *                       COMPLETION DATE                          *        
      *  08/09/00    LHO      TPR 22644 - CORRECT PROBLEM WITH BEING   *        
      *                       ABLE TO POST CHANGES TO ACCOUNTS THAT    *        
      *                       ARE NOT ACTIVE.                          *        
      *  04/17/01    LHO      TPR 19550.  CHANGED SELECT FOR ERROR    *         
      *                       TO COMPARE METER_STATUS_CODE FROM        *        
      *                       TABLE CSS_MTRD_ENV_PARTL INSTEAD OF      *        
      *                       MTR_STATUS_IS OF CSS_SO_MTR_CHG          *        
      *  04/25/2001  LHO      CHANGE CHECK FOR ERROR SO016 AND SO018   *        
      *                       TO USER METER VALUE FROM MAINFRAME       *        
      *                       INSTEAD OF THE METER_VALUE_WS FROM       *        
      *                       CSS_SO_MTR_CHG.  CML23884                *        
      *  10/29/2001  LHO      CML 25537 - ADD CHECK TO PREVENT         *        
      *                       CHANGING AN ACCOUNT WITH A STATUS        *        
      *                       OTHER THAN PENDING TO ACTIVE.            *        
      *  11/02/2001  FMB      CML 22881 - SET WS-SO-FINAL-BILL TO      *        
      *                       N FOR SEASONAL OFF ORDERS.               *        
      *  02/19/2002  FMB      CML 24337 - ORDER REASON 8 IS VALID      *        
      *                       ONLY FOR SEB DNP01 ORDERS.               *        
      *  02/25/2002  FMB      CML 26018 - PERFORM CHECK ON NUMBER OF   *        
      *                       DIALS FOR METER CHANGE ORDERS.           *        
      *  04/18/2002  SK88120  CML 26003 - PERFORM CHECK FOR MATERIAL   *        
      *                       LABOR CHRG AMOUNTS IF THE AMOUNTS ARE    *        
      *                       ZEROS GENERATE AN OVERRIDABLE ERROR MSG  *        
      *  09/03/2002  FMB      CML 27235 - HANDLE GAS INDUSTRIAL        *        
      *                       METERS (SOURCE = S) LIKE MV90.           *        
      *  09/06/2002  PRA      CML 26298-7 -- PERFORM CHECK FOR PSNC    *        
      *                       MARKETING ORDERS -- VERIFYING THAT       *        
      *                       LABOR, MATL, AND EQUIP ARE > 0 -- OR     *        
      *                       GENERATE OVERRIDEABLE MESSAGE            *        
      *                       ALSO GENERATE OVERRIDEABLE MESSAGE IF    *        
      *                       CUST_CNT_ID IS NOT LOADED                *        
      *  09/25/2002  FMB      CML 27348 - PSNC SEASONAL ON ORDER       *        
      *                       PROCESSING.  IF PREMISE HAS ONLY         *        
      *                       SEASONAL APPLIANCES AND RATE IS 105,     *        
      *                       CHANGE RATE TO 110 AND SET               *        
      *                       WS-SO-UTIL-CHG TO PROCESS RATE CHANGE.   *        
      *  09/26/02    RR       CML 27041 - CHANGE @CODE_ACCOUNT_STAT             
      *                       TO CODE_ACCOUNT_STATUS_NEW TO AVOID      *        
      *                       SERVICE ORDER ERROR SO054 ON CHAINED SO           
      *  02/03/03    FB       CML 24056 - VALIDATE POINT ID AGAINST    *        
      *                       SNE_POINT.                               *        
      *  04/09/03    LHO      CML 28749 -  CORRECT POINT ID NOT BEING  *        
      *                       UPDATED FROM CAD                         *        
      *  04/29/03    MSR      CML 27880 - CHANGED TO ALLOW MARKETING   *        
      *                       ORDER TO BE POSTED WITH CHARGES ON       *        
      *                       PENDING ACCOUNT.                         *        
      *  05/19/03    MSR      CML28469 - CHANGED TO VALIDATE PROGRAM   *        
      *                       ID AND RATE COMBINATION                  *        
      *  10/17/03    FMB      CML 29609 - DON'T PERFORM HIGH/LOW       *        
      *                       CHECKS FOR FM008 ORDERS.                 *        
      *  10/13/04    LHO      CML 31688 - PREVENT CC2 OR CC3 FROM      *        
      *                       POSTING.  THIS IS AN INDICATION THAT     *        
      *                       CHAINING FAILED.                         *        
      *  08/22/05    FMB      CML 32676 - FOR SCE&G SETS, CHECK FOR    *        
      *                       A GAS WATER HEATER.  IF PRESENT,         *        
      *                       DEFAULT RATE TO 32V.  IF NOT, 32S.       *        
      *                       CHECK RATE DATES AGAINST POSTING DATE    *        
      *  11/01/05    FMB      CML 32676 - REMOVE CHECK OF RATES        *        
      *                       AGAINST POSTING DATE.                    *        
      *  01/04/06    AKW      CML 33654- CHANGED CODE SO THAT CODE     *        
      *                       STATUS REASON 8 WILL BE VALID NOT ONLY   *        
      *                       FOR DNP01 ORDERS BUT FOR DNPFB ORDERS    *        
      *                       AS WELL.                                 *        
      *  02/09/06    FMB      CML 33640 - WORK TYPE MUST BE UNB OR     *        
      *                       SOL/SOS/SOR FOR GAS MOW ORDER WITH       *        
      *                       $25 SERVICE CHARGE (CUST REPAIRS).       *        
      *  07/18/06    FMB      CML 34593 - REMOVE CALL TO PD_D0000318   *        
      *                       WHICH WAS LEFT OVER FROM OLD CAD.        *        
      *  08/18/06    FMB      CML 33924 - PSNC GAS RATE CASE.  CHECK   *        
      *                       FOR GAS WATER HEATER.  IF PRESENT,       *        
      *                       DEFAULT RATE TO 105.  IF NOT, 110.       *        
      *  11/06/06    SC       CML 35004 - TO FIX THE ERROR DUE TO      *        
      *                       INCORRECT SETTING OF THE SO_UTL_CHG FL   *        
      *  12/11/06    FMB      CML 30771 - MOVE APPLIANCE LOGIC TO      *        
      *                       MAINFRAME POSTING PROGRAMS.              *        
      *                                                                *        
      *  06/15/07    CVNS     ADDED THE CODE FOR SERV_ORDER_NO COLUMN  *        
      *                       IN CSS_SO_MTR_VAL TABLE & INCLUDED THE   *        
      *                       LOGIC FOR CSR00583 & COMMENTED THE CALL  *        
C35434*  07/05/07  SJ94244    INCLUDED WITH UR                                  
REARCH*  07/27/07  PA94870    INCORPORATE CSR00584 LOGIC INTO CSR00109 *        
C35978*  09/20/07    FMB      PSNC GAS RATES NO LONGER DEPEND ON       *        
C35978*                       APPLIANCES.                              *        
C33886*  10/04/07  SD93603    ADDED CODE FOR HANDLING ERT ATTACHMENTS  *        
C33886*                       ON AMR METERS.                           *        
C33886*  10/15/07  PD80186    ADDED CODE INDEX CHANGE (IXC).           *        
C33886*  10/18/07  KW94869    CHANGED WS-AMR-READ-VALUE-IS >= 2        *        
T36624*  12/13/07  SD93603    FIX FOR MTR FLD WORK ORDERS - AMR        *        
T37106*  03/19/08    AHF      CML 37106 - ADDED VALIDATION FOR METER   *        
      *                       PRESSURE                                 *        
C33743*  08/11/08  SC41135    POINT-ID PROJECT- REPLACE SNE_POINT WITH *        
C33743*                       CSS_PIM_POINT TABLE                      *        
C37209*  08/20/08  SC41135    POINT ID UPDATE INCORRECT DURING REARCH  *        
A00586*  04/08/09    FMB      DO NOT GENERATE SO052 ERROR FOR PSNC     *        
A00586*                       JOBBING ORDERS.                          *        
A00501*  05/06/09    MSR      ELIMINATE OVERFLOW WARNING ERROR WHEN    *        
A00501*                       COMPILING THE STORED PROCEDURE.          *        
A01400*  06/23/09  DB18339    CORRECT REFERENCE TO 'SO259' IN 7340 PARA*        
P00196*  10/26/09    MSR      ADD NEW GROUP B ORDER TYPE FW026.        *        
A01360*  07/26/10  SC41135    PREVENT HI/LO WQ FOR 0 DAYS 0 USAGE      *        
P00447*  09/07/10  SJ97149    ADD CHECK FOR CONSTANT = 0 AND           *        
P00447*                       SEND A HARD ERROR TO PANEL090.           *        
A03206*  03/22/11  DB18339    ADDED SO407 ERROR TO REQUIRE MATERIALS   *        
A03206*                       ON PSNC JOBBING AND MARKETING.           *        
A04307*  08/14/12  SC41135    PREVENT ERROR FROM CSS_PIM_POINT TABLE   *        
      *  03/27/13  HB42149    changed the check for calling error msg  *        
      *                       SO401 from 2 to 5.                       *        
A04558*  08/28/13    FMB      RESET HOLD MAX AND MIN AFTER EACH        *        
A04558*                       FETCH OF THE METER CURSOR                *        
A05020*  05/10/16    VV       VALIDATE ORDER WORK TYPE COMBINATION     *        
A05020*  06/16/16    VV       ALLOW DNPFB/INV TO BE A VALID ORDER WORK *        
A05020*                       TYPE COMBO FOR PSNC                      *        
P01176*  09/15/16    FMB      GAS SAMPLE TEST.                        *         
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  5100 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR00109'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR00109 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *----< CSS_ACCOUNT >                                                      
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *----< CSS_DMT_PGM_ID >                                                   
           EXEC SQL                                                             
              INCLUDE TBDMTPI                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_MTRD_ENVRNMT >                                                 
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_OBJ_VIEW_PAGE >                                                
           EXEC SQL                                                             
              INCLUDE TBOBJVW                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_ORDER_TYPE >                                                   
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_REG_PROFILE >                                                  
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_CHARGES >                                                   
           EXEC SQL                                                             
              INCLUDE TBSOCHR                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_DATA >                                                      
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_LABOR_CHRGS >                                               
           EXEC SQL                                                             
              INCLUDE TBSOCHG                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_MATERIALS >                                                 
           EXEC SQL                                                             
              INCLUDE TBSOMAT                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_METER >                                                     
           EXEC SQL                                                             
              INCLUDE TBSOMTR                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_MTR_CHG >                                                   
           EXEC SQL                                                             
              INCLUDE TBSOMCG                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_MTR_VAL >                                                   
           EXEC SQL                                                             
              INCLUDE TBMVDAT                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_ORDER_INST >                                                
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_REG_CHG >                                                   
           EXEC SQL                                                             
              INCLUDE TBSORCG                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_REGISTER >                                                  
           EXEC SQL                                                             
              INCLUDE TBSOREG                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_STD_LABOR >                                                 
           EXEC SQL                                                             
              INCLUDE TBSOSLB                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_UTILITY >                                                   
           EXEC SQL                                                             
              INCLUDE TBSOUTL                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_UTL_CHG >                                                   
           EXEC SQL                                                             
              INCLUDE TBSOUTG                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_UTIL_ENVRNMT >                                                 
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_WQ_ITEMS >                                                     
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_METER_PGM>                                                     
           EXEC SQL                                                             
              INCLUDE TBMTRPGM                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_SO_ERROR_MSG >                                                 
           EXEC SQL                                                             
              INCLUDE TBSERMSG                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_DELINQUENCY >                                                  
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
C33743*----< CSS_PIM_POINT >                                                    
C33743     EXEC SQL                                                             
C33743        INCLUDE TBPIMPNT                                                  
C33743     END-EXEC.                                                            
                                                                        
                                                                        
C33886*----< CSS_SO_MTR_ATT >                                                   
C33886     EXEC SQL                                                             
C33886        INCLUDE TBSOMA                                                    
C33886     END-EXEC.                                                            
                                                                        
C33886*----< CSS_SO_MTR_ATT_CHG >                                               
C33886     EXEC SQL                                                             
C33886        INCLUDE TBSOMAC                                                   
C33886     END-EXEC.                                                            
                                                                        
C33886*----< CSS_WKTYP_REQMTS >                                                 
C33886     EXEC SQL                                                             
C33886        INCLUDE TBWKTPRQ                                                  
C33886     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *  CODES DATA PRESENT                                                     
           EXEC SQL                                                             
              INCLUDE CWS00059                                                  
           END-EXEC.                                                            
                                                                        
      *  SQL ERRORS                                                             
           COPY CWS00303.                                                       
                                                                        
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
           05  PARM-SERV-ORDER-NO      PIC X(13) VALUE SPACES.          
           05  PARM-SERV-ORDER-NO-RED  PIC  9(13).                      
           05  PARM-SERV-ORDER-NO-NUM  PIC S9(13)V COMP-3 VALUE 0.      
           05  PARM-CAD-EDIT-FLAG      PIC X(01) VALUE SPACES.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
      *    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9)  COMP VALUE 0.        
           05  RS-SO-ERROR-MSG-NO       PIC X(05)  VALUE SPACES.        
           05  RS-SO-ERROR-MSG-TEXT     PIC X(210) VALUE SPACES.        
           05  RS-SO-OVRD-MSG-IND       PIC X(01)  VALUE SPACES.        
           05  RS-SO-FIX-PANEL-NO       PIC X(04)  VALUE SPACES.        
           05  RS-METER-NO              PIC X(09)  VALUE SPACES.        
           05  RS-REG-ID-NO             PIC X(05)  VALUE SPACES.        
           05  RS-NO-DIALS              PIC X(05)  VALUE SPACES.        
           05  RS-CONSTANT              PIC X(10)  VALUE SPACES.        
COB305     05 RS-ERT-READ        PIC S9(12)V9(3) USAGE COMP-3 VALUE 0.   
COB305     05 RS-IDX-READ        PIC S9(12)V9(3) USAGE COMP-3 VALUE 0.   
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9)  COMP VALUE 0.        
           05  S-SO-ERROR-MSG-NO        PIC X(05)  VALUE SPACES.        
           05  S-SO-ERROR-MSG-TEXT      PIC X(210) VALUE SPACES.        
           05  S-SO-OVRD-MSG-IND        PIC X(01)  VALUE SPACES.        
           05  S-SO-FIX-PANEL-NO        PIC X(04)  VALUE SPACES.        
           05  S-METER-NO               PIC X(09)  VALUE SPACES.        
           05  S-REG-ID-NO              PIC X(05)  VALUE SPACES.        
           05  S-NO-DIALS               PIC X(05)  VALUE SPACES.        
           05  S-CONSTANT               PIC X(10)  VALUE SPACES.        
COB305     05 S-ERT-READ        PIC S9(12)V9(3) USAGE COMP-3 VALUE 0.   
COB305     05 S-IDX-READ        PIC S9(12)V9(3) USAGE COMP-3 VALUE 0.   
                                                                        
       01  FLAGS.                                                       
           05  WS-EXISTS-DATA-FG1       PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG1             VALUE 'N'.            
               88 EXISTS-DATA-FG1                 VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG2       PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG2             VALUE 'N'.            
               88 EXISTS-DATA-FG2                 VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG3       PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG3             VALUE 'N'.            
               88 EXISTS-DATA-FG3                 VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG4       PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG4             VALUE 'N'.            
               88 EXISTS-DATA-FG4                 VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG5       PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG5             VALUE 'N'.            
               88 EXISTS-DATA-FG5                 VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG6       PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG6             VALUE 'N'.            
               88 EXISTS-DATA-FG6                 VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG7       PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG7             VALUE 'N'.            
               88 EXISTS-DATA-FG7                 VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG8       PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG8             VALUE 'N'.            
               88 EXISTS-DATA-FG8                 VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG9       PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG9             VALUE 'N'.            
               88 EXISTS-DATA-FG9                 VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG10      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG10            VALUE 'N'.            
               88 EXISTS-DATA-FG10                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG11      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG11            VALUE 'N'.            
               88 EXISTS-DATA-FG11                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG12      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG12            VALUE 'N'.            
               88 EXISTS-DATA-FG12                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG13      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG13            VALUE 'N'.            
               88 EXISTS-DATA-FG13                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG14      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG14            VALUE 'N'.            
               88 EXISTS-DATA-FG14                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG15      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG15            VALUE 'N'.            
               88 EXISTS-DATA-FG15                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG16      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG16            VALUE 'N'.            
               88 EXISTS-DATA-FG16                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG17      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG17            VALUE 'N'.            
               88 EXISTS-DATA-FG17                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG18      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG18            VALUE 'N'.            
               88 EXISTS-DATA-FG18                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG19      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG19            VALUE 'N'.            
               88 EXISTS-DATA-FG19                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG20      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG20            VALUE 'N'.            
               88 EXISTS-DATA-FG20                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG21      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG21            VALUE 'N'.            
               88 EXISTS-DATA-FG21                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG22      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG22            VALUE 'N'.            
               88 EXISTS-DATA-FG22                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG23      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG23            VALUE 'N'.            
               88 EXISTS-DATA-FG23                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG24      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG24            VALUE 'N'.            
               88 EXISTS-DATA-FG24                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG25      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG25            VALUE 'N'.            
               88 EXISTS-DATA-FG25                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG26      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG26            VALUE 'N'.            
               88 EXISTS-DATA-FG26                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG27      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG27            VALUE 'N'.            
               88 EXISTS-DATA-FG27                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG28      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG28            VALUE 'N'.            
               88 EXISTS-DATA-FG28                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG29      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG29            VALUE 'N'.            
               88 EXISTS-DATA-FG29                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG30      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG30            VALUE 'N'.            
               88 EXISTS-DATA-FG30                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG31      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG31            VALUE 'N'.            
               88 EXISTS-DATA-FG31                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG32      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG32            VALUE 'N'.            
               88 EXISTS-DATA-FG32                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG33      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG33            VALUE 'N'.            
               88 EXISTS-DATA-FG33                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG34      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG34            VALUE 'N'.            
               88 EXISTS-DATA-FG34                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG35      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG35            VALUE 'N'.            
               88 EXISTS-DATA-FG35                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG36      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG36            VALUE 'N'.            
               88 EXISTS-DATA-FG36                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG37      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG37            VALUE 'N'.            
               88 EXISTS-DATA-FG37                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG38      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG38            VALUE 'N'.            
               88 EXISTS-DATA-FG38                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG39      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG39            VALUE 'N'.            
               88 EXISTS-DATA-FG39                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG40      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG40            VALUE 'N'.            
               88 EXISTS-DATA-FG40                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG41      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG41            VALUE 'N'.            
               88 EXISTS-DATA-FG41                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG42      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG42            VALUE 'N'.            
               88 EXISTS-DATA-FG42                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG43      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG43            VALUE 'N'.            
               88 EXISTS-DATA-FG43                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG44      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG44            VALUE 'N'.            
               88 EXISTS-DATA-FG44                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG45      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG45            VALUE 'N'.            
               88 EXISTS-DATA-FG45                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG46      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG46            VALUE 'N'.            
               88 EXISTS-DATA-FG46                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG47      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG47            VALUE 'N'.            
               88 EXISTS-DATA-FG47                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG48      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG48            VALUE 'N'.            
               88 EXISTS-DATA-FG48                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG49      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG49            VALUE 'N'.            
               88 EXISTS-DATA-FG49                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG50      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG50            VALUE 'N'.            
               88 EXISTS-DATA-FG50                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG51      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG51            VALUE 'N'.            
               88 EXISTS-DATA-FG51                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG52      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG52            VALUE 'N'.            
               88 EXISTS-DATA-FG52                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG53      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG53            VALUE 'N'.            
               88 EXISTS-DATA-FG53                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG54      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG54            VALUE 'N'.            
               88 EXISTS-DATA-FG54                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG55      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG55            VALUE 'N'.            
               88 EXISTS-DATA-FG55                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG56      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG56            VALUE 'N'.            
               88 EXISTS-DATA-FG56                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG57      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG57            VALUE 'N'.            
               88 EXISTS-DATA-FG57                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG58      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG58            VALUE 'N'.            
               88 EXISTS-DATA-FG58                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG59      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG59            VALUE 'N'.            
               88 EXISTS-DATA-FG59                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG60      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG60            VALUE 'N'.            
               88 EXISTS-DATA-FG60                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG61      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG61            VALUE 'N'.            
               88 EXISTS-DATA-FG61                VALUE 'Y'.            
           05  WS-EXISTS-DATA-FG62      PIC X(01) VALUE 'N'.            
               88 NOT-EXISTS-DATA-FG62            VALUE 'N'.            
               88 EXISTS-DATA-FG62                VALUE 'Y'.            
A03206     05  WS-EXISTS-SO-MATL        PIC X(01) VALUE 'N'.            
           05  WS-MTR-ROWS              PIC X(01) VALUE 'N'.            
               88 NO-MTR-ROWS                     VALUE 'Y'.            
           05  WS-REG-ROWS              PIC X(01) VALUE 'N'.            
               88 NO-REG-ROWS                     VALUE 'Y'.            
           05  WS-NEW-MTR-ROWS          PIC X(01) VALUE 'N'.            
               88 NO-NEW-MTR-ROWS                 VALUE 'Y'.            
           05  WS-NEW-REG-ROWS          PIC X(01) VALUE 'N'.            
               88 NO-NEW-REG-ROWS                 VALUE 'Y'.            
C33886     05  WS-AMR-MTR-ROWS          PIC X(01) VALUE 'N'.            
C33886         88 NO-AMR-MTR-ROWS                 VALUE 'Y'.            
C33886     05  WS-AMR-ATT-ROWS          PIC X(01) VALUE 'N'.            
C33886         88 NO-AMR-ATT-ROWS                 VALUE 'Y'.            
           05  WS-DATABASE              PIC 9(01) VALUE ZERO.           
               88  CSR-DATABASE                  VALUE 1.               
               88  SEB-DATABASE                  VALUE 2.               
                                                                        
       01  WS-GENERAL-WORKING-STORAGE.                                  
           05  PROGRAM-NAME                    PIC X(08)                
                                                     VALUE 'CSR00109'.  
           05  WS-RET-STATUS                   PIC S9(4) USAGE COMP.    
           05  WS-811                        PIC S9(9) VALUE -811 COMP. 
           05  WS-MESSAGE-NO                   PIC X(05) VALUE SPACES.  
           05  WS-SERV-ORDER-NO              PIC X(13) JUSTIFIED RIGHT. 
           05  WS-TODAY                        PIC X(10) VALUE SPACES.  
COB305     05 WS-ORDER-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.
COB305     05 WS-POSTED-SET-ORDER-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.
COB305     05 WS-M-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.
COB305     05 WS-M-ACCOUNT-NO-PRIOR        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.
COB305     05 WS-M-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.
           05  WS-ORDER-TYPE-CD                PIC  X(05) VALUE SPACES. 
           05  WS-CODE-UTIL-TYPE               PIC  X(01) VALUE SPACES. 
           05  WS-ORDER-STATUS                 PIC  X(02) VALUE SPACES. 
           05  WS-ORDER-STATE-CD               PIC  X(01) VALUE SPACES. 
           05  WS-COMPLETED-DATETIME           PIC  X(26) VALUE SPACES. 
           05  WS-CODE-BILL-STATUS             PIC  X(01) VALUE SPACES. 
           05  WS-CODE-ACCOUNT-STATUS          PIC  X(01) VALUE SPACES. 
           05  WS-METER-NO                     PIC  X(09) VALUE SPACES. 
           05  WS-REG-ID                       PIC S9(4) USAGE COMP.    
           05  WS-REG-ID-NUM                   PIC  9(5).               
           05  WS-REG-ID-CHAR REDEFINES WS-REG-ID-NUM                   
                                           PIC  X(05).                  
COB305     05 WS-MTRREG-LAST-REG-READ        PIC S9(12)V9(3) 
COB305       USAGE COMP-3 VALUE 0.
COB305     05 WS-LAST-READ-VALUE        PIC S9(12)V9(3) USAGE COMP-3 
COB305       VALUE 0.
COB305     05 WS-SO-MTRREG-LAST-READ-VALUE        PIC S9(12)V9(3) 
COB305       USAGE COMP-3 VALUE 0.
COB305     05 WS-SO-MTRREG-READ-VALUE-IS        PIC S9(12)V9(3) 
COB305       USAGE COMP-3 VALUE 0.
COB305     05 WS-MIN-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.     
COB305     05 WS-MAX-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.     
A01360     05  WS-NO-OF-DAYS               PIC S9(9) COMP-3 VALUE ZERO. 
COB305     05 WS-MTRREG-CONSTANT        PIC S9(6)V9(3) USAGE COMP-3 
COB305       VALUE 0. 
           05  WS-MTRREG-CONSTANT-NUM      PIC  9(10).                  
           05  WS-MTRREG-DIALS             PIC S9(4) USAGE COMP.        
           05  WS-MTRREG-DIALS-NUM         PIC  9(5).                   
           05  WS-MTRREG-DIALS-POWER       PIC S9(9) USAGE COMP.        
COB305     05 WS-SO-MTRREG-CONSTANT        PIC S9(6)V9(3) USAGE COMP-3 
COB305       VALUE 0. 
           05  WS-SO-MTRREG-DIALS          PIC S9(4) USAGE COMP.        
           05  WS-CODE-USAGE-TYPE          PIC  X(1) VALUE SPACES.      
           05  WS-NO-METER                 PIC S9(4) USAGE COMP.        
           05  WS-NO-METER-TEMP            PIC S9(4) USAGE COMP.        
           05  WS-NO-SO-METER              PIC S9(4) USAGE COMP.        
           05  WS-SNEPOINT-ROWCOUNT        PIC S9(4) USAGE COMP.        
           05  WS-NEW-METER-FLAG               PIC  X(01) VALUE SPACES. 
           05  WS-CUSTCHG-ORD-TYPE-FL          PIC  X(01) VALUE SPACES. 
           05  WS-SERV-ORDER-UTIL-TYPE         PIC  X(01) VALUE SPACES. 
           05  WS-ASSIGNED-DATETIME            PIC  X(26) VALUE SPACES. 
           05  WS-CHARGES-INDICATOR            PIC  X(01) VALUE SPACES. 
           05  WS-BACK-DATED-IND               PIC  X(01) VALUE SPACES. 
           05  WS-BILL-EXCEPTION-WQ-CATEGORY   PIC S9(4) USAGE COMP.    
           05  WS-WQ-ASSIGNED                  PIC  X(01) VALUE SPACES. 
           05  WS-WQ-IN-PROGRESS               PIC  X(01) VALUE SPACES. 
           05  WS-FINAL-BILL-INVESTIGATE-WQ    PIC S9(4) USAGE COMP.    
           05  WS-FINAL-BILL-INV-WQ-EXISTS     PIC  X(01) VALUE SPACES. 
           05  WS-MTR-READ-SOURCE-CD           PIC  X(01) VALUE SPACES. 
           05  WS-NON-PRODUCTIVE-IND           PIC  X(01) VALUE SPACES. 
           05  WS-ORDER-GROUP-CD               PIC  X(01) VALUE SPACES. 
           05  WS-RATE-PLAN-NO                 PIC  X(03) VALUE SPACES. 
           05  WS-LAST-REG-READ-DATE           PIC  X(26) VALUE SPACES. 
           05  WS-DATE-RECVED                  PIC  X(26) VALUE SPACES. 
COB305     05 WS-HOLD-MIN-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0. 
COB305     05 WS-HOLD-MAX-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0. 
           05  WS-POINT-ID                     PIC  X(10) VALUE SPACES. 
           05  WS-TAG-NM                       PIC  X(10) VALUE SPACES. 
           05  WS-GIS-LOC-OFFICE               PIC  X(03) VALUE SPACES. 
           05  WS-CODE-ACCT-STATUS-NEW         PIC  X(01) VALUE SPACES. 
           05  WS-SONP-REASON                  PIC  X(01) VALUE SPACES. 
           05  WS-MTR-CHG-EXISTS               PIC  X(01) VALUE SPACES. 
           05  WS-REG-CHG-EXISTS               PIC  X(01) VALUE SPACES. 
           05  WS-METER-EXISTS                 PIC  X(01) VALUE SPACES. 
           05  WS-REGISTER-EXISTS              PIC  X(01) VALUE SPACES. 
           05  WS-NO-MKTG-CNT-ID-WQ-CATEGORY   PIC S9(4) USAGE COMP.    
           05  WS-NO-MKTG-CNT-ID-WQ-EXISTS     PIC  X(01) VALUE SPACES. 
           05  WS-COMPANY-NO                   PIC  X(02) VALUE SPACES. 
           05  WS-GIS-POINT-ID                 PIC S9(9) USAGE COMP.    
           05  WS-GIS-POINT-ID-SNEPOINT        PIC S9(9) USAGE COMP.    
           05  WS-PROGRAM-ID                   PIC  X(02) VALUE SPACES. 
           05  WS-DIGTL-MTR-TYPE               PIC  X(03) VALUE SPACES. 
           05  WS-WH-FLAG                      PIC  X(01) VALUE SPACES. 
           05  WS-CODE-ACCOUNT-STATUS-NEW      PIC  X(01) VALUE SPACES. 
COB305     05 WS-DELINQ-VALUE        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.     
           05  WS-PARM-CONSTANT                PIC  X(09) VALUE SPACES. 
COB305     05 WS-CONSTANT        PIC S9(6)V9(3) USAGE COMP-3 VALUE 0. 
           05  WS-NO-DIALS                 PIC S9(4) USAGE COMP.        
           05  WS-CODE-MTR-STATUS-WS           PIC  X(01) VALUE SPACES. 
           05  WS-PARM-NO-DIALS                PIC  X(05) VALUE SPACES. 
           05  WS-PARM-CONSTANTS               PIC  X(10) VALUE SPACES. 
           05  WS-POINT-ID-CHECK               PIC  S9(9) USAGE COMP.   
                                                                        
C33886     05  WS-AMR-ORDER-TYPE-CD        PIC  X(05) VALUE SPACES.     
C33886     05  WS-AMR-COMPANY-NO           PIC  X(02) VALUE SPACES.     
C33886     05  WS-AMR-WORK-TYPE-CD         PIC  X(03) VALUE SPACES.     
C33886     05  WS-AMR-CODE-UTIL-TYPE       PIC  X(01) VALUE SPACES.     
C33886     05  WS-AMR-METER-NO             PIC  X(09) VALUE SPACES.     
C33886     05  WS-AMR-READ-RULE            PIC  X(01) VALUE SPACES.     
C33886     05  WS-AMR-INSTALL-RULE         PIC  X(01) VALUE SPACES.     
C33886     05  WS-AMR-REMOVE-RULE          PIC  X(01) VALUE SPACES.     
C33886     05  WS-AMR-IC-NO                PIC S9(4) USAGE COMP.        
C33886     05  WS-AMR-MTR-REF-NO           PIC S9(4) USAGE COMP.        
C33886     05  WS-AMR-REG-ID               PIC S9(4) USAGE COMP.        
C33886     05  WS-AMR-REG-ID-NUM           PIC 9(5).                    
C33886     05  WS-AMR-REG-ID-CHAR REDEFINES WS-AMR-REG-ID-NUM           
C33886                                     PIC  X(05).                  
C33886     05  WS-AMR-DEVICE-NO            PIC  X(12) VALUE SPACES.     
C33886     05  WS-AMR-CODE-ATT-TYPE        PIC  X(02) VALUE SPACES.     
C33886     05  WS-AMR-ACTION-CODE          PIC  X(01) VALUE SPACES.     
C33886     05  WS-AMR-CODE-ACTION-REAS     PIC  X(01) VALUE SPACES.     
COB305     05 WS-AMR-READ-VALUE-IS        PIC S9(12)V9(3) USAGE COMP-3 
COB305       VALUE 0.
C33886     05  WS-AMR-HOW-ATTACHED-CD      PIC  X(01) VALUE SPACES.     
C33886     05  WS-AMR-NEW-OR-CHG           PIC  X(01) VALUE SPACES.     
C33886     05  WS-AMR-ERR                  PIC  X(05) VALUE SPACES.     
C33886     05  WS-IS-AMR                   PIC  X(01) VALUE SPACES.     
C33886     05  WS-IS-AVAILABLE             PIC  X(01) VALUE SPACES.     
C33886     05  WS-IS-ATTCH-MTRSHOP         PIC  X(01) VALUE SPACES.     
C33886     05  WS-HOW-ATTACHED             PIC  X(01) VALUE SPACES.     
C33886     05  WS-AMR-INSTALL-OK           PIC  X(02) VALUE SPACES.     
C33886     05  WS-AMR-REMOVE-OK            PIC  X(02) VALUE SPACES.     
C33886     05  WS-AMR-READ-OK              PIC  X(02) VALUE SPACES.     
COB305     05 WS-AMR-IDX-READ        PIC S9(12)V9(3) USAGE COMP-3 
COB305       VALUE 0.
C33886     05  WS-MTR-TABL-FL              PIC  X(01) VALUE SPACES.     
                                                                        
T37106     05  WS-INVALID-MTR-PRESSURE     PIC  X(01) VALUE SPACES.     
T37106     05  WS-INVALID-WKTYPE           PIC  X(01) VALUE 'N'.        
                                                                        
       01  WS-MISC.                                                     
           05  WS-NULL-IND              PIC S9(4) COMP VALUE -1.        
           05  WS-NULL-IND-1            PIC S9(4) COMP VALUE 0.         
           05  WS-NULL-IND-2            PIC S9(4) COMP VALUE 0.         
           05  WS-NULL-IND-3            PIC S9(4) COMP VALUE 0.         
           05  WS-NULL-IND-4            PIC S9(4) COMP VALUE 0.         
C33886     05  WS-NULL-IND-AMR          PIC S9(4) COMP VALUE 0.         
           05  WS-OPEN-CURSOR-C2        PIC  X(1) VALUE 'N'.            
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
      *    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.                
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
      *                                                                         
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  ROWS FOR METER CHANGE.                                      **        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE METER_DATA CURSOR FOR                           
                SELECT A.METER_NO                                       
                      ,A.REG_ID_NO                                      
                      ,B.LAST_READ_VALUE                                
                      ,A.LAST_READ_VALUE                                
                      ,A.READ_VALUE_IS                                  
                      ,B.MIN_UNITS                                      
                      ,B.MAX_UNITS                                      
                      ,B.CONSTANT                                       
                      ,B.NO_DIALS                                       
                      ,A.CONSTANT                                       
                      ,A.NO_DIALS                                       
                      ,A.CODE_USAGE_TYPE                                
                      ,A.CODE_UTIL_TYPE                                 
                      ,A.MTR_READ_SOURCE_CD                             
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           B.LAST_REG_READ_DATE, 121), ' ', '-'), ':', '.') 
           LAST_REG_READ_DATE                             
                      ,A.CODE_MTR_STATUS_WS                             
                 FROM  CSS_SO_MTR_CHG A WITH(READUNCOMMITTED),                  
                       CSS_SO_MTR_VAL B WITH(READUNCOMMITTED)                   
                 WHERE A.SERV_ORDER_NO    = :WS-ORDER-NO                
                   AND B.SERV_ORDER_NO    = :WS-ORDER-NO                
                   AND A.CODE_UTIL_TYPE   = B.CODE_UTIL_TYPE            
                   AND A.IC_NO            = B.IC_NO                     
                   AND A.METER_NO         = B.METER_NO                  
                   AND A.MTR_REF_NO       = B.MTR_REF_NO                
                   AND A.CODE_TIME_PERIOD = B.CODE_TIME_PERIOD          
                   AND A.REG_ID_NO        = B.REG_ID_NO                 
                   AND A.POST_MTR_CHG_IND = 'Y'                         
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE METER_DATA CURSOR FOR                                   
MFA-TR*         SELECT A.METER_NO                                               
MFA-TR*               ,A.REG_ID_NO                                              
MFA-TR*               ,B.LAST_READ_VALUE                                        
MFA-TR*               ,A.LAST_READ_VALUE                                        
MFA-TR*               ,A.READ_VALUE_IS                                          
MFA-TR*               ,B.MIN_UNITS                                              
MFA-TR*               ,B.MAX_UNITS                                              
MFA-TR*               ,B.CONSTANT                                               
MFA-TR*               ,B.NO_DIALS                                               
MFA-TR*               ,A.CONSTANT                                               
MFA-TR*               ,A.NO_DIALS                                               
MFA-TR*               ,A.CODE_USAGE_TYPE                                        
MFA-TR*               ,A.CODE_UTIL_TYPE                                         
MFA-TR*               ,A.MTR_READ_SOURCE_CD                                     
MFA-TR*               ,B.LAST_REG_READ_DATE                                     
MFA-TR*               ,A.CODE_MTR_STATUS_WS                                     
MFA-TR*          FROM  CSS_SO_MTR_CHG A,                                        
MFA-TR*                CSS_SO_MTR_VAL B                                         
MFA-TR*          WHERE A.SERV_ORDER_NO    = :WS-ORDER-NO                        
MFA-TR*            AND B.SERV_ORDER_NO    = :WS-ORDER-NO                        
MFA-TR*            AND A.CODE_UTIL_TYPE   = B.CODE_UTIL_TYPE                    
MFA-TR*            AND A.IC_NO            = B.IC_NO                             
MFA-TR*            AND A.METER_NO         = B.METER_NO                          
MFA-TR*            AND A.MTR_REF_NO       = B.MTR_REF_NO                        
MFA-TR*            AND A.CODE_TIME_PERIOD = B.CODE_TIME_PERIOD                  
MFA-TR*            AND A.REG_ID_NO        = B.REG_ID_NO                         
MFA-TR*            AND A.POST_MTR_CHG_IND = 'Y'                                 
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*          QUERYNO 7110                                                   
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  ROWS FOR REGISTER CHANGE.                                   **        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE REGISTER_DATA CURSOR FOR                        
                SELECT A.METER_NO                                       
                      ,A.REG_ID_NO                                      
                      ,B.LAST_READ_VALUE                                
                      ,A.LAST_READ_VALUE                                
                      ,A.READ_VALUE_IS                                  
                      ,B.MIN_UNITS                                      
                      ,B.MAX_UNITS                                      
                      ,B.CONSTANT                                       
                      ,B.NO_DIALS                                       
                      ,A.CONSTANT                                       
                      ,A.NO_DIALS                                       
                      ,A.CODE_USAGE_TYPE                                
                      ,A.CODE_UTIL_TYPE                                 
                      ,C.MTR_READ_SOURCE_CD                             
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           B.LAST_REG_READ_DATE, 121), ' ', '-'), ':', '.') 
           LAST_REG_READ_DATE                             
                 FROM  CSS_SO_REG_CHG A WITH(READUNCOMMITTED),                  
                       CSS_SO_MTR_VAL B WITH(READUNCOMMITTED),                  
                       CSS_SO_MTR_CHG C WITH(READUNCOMMITTED)                   
                 WHERE A.SERV_ORDER_NO    = :WS-ORDER-NO                
                   AND B.SERV_ORDER_NO    = :WS-ORDER-NO                
                   AND A.SERV_ORDER_NO    = C.SERV_ORDER_NO             
                   AND A.CODE_UTIL_TYPE   = B.CODE_UTIL_TYPE            
                   AND A.CODE_UTIL_TYPE   = C.CODE_UTIL_TYPE            
                   AND A.IC_NO            = B.IC_NO                     
                   AND A.IC_NO            = C.IC_NO                     
                   AND A.METER_NO         = B.METER_NO                  
                   AND A.METER_NO         = C.METER_NO                  
                   AND A.MTR_REF_NO       = B.MTR_REF_NO                
                   AND A.MTR_REF_NO       = C.MTR_REF_NO                
                   AND A.CODE_TIME_PERIOD = B.CODE_TIME_PERIOD          
                   AND A.CODE_TIME_PERIOD = C.CODE_TIME_PERIOD          
                   AND A.REG_ID_NO        = B.REG_ID_NO                 
                   AND C.POST_MTR_CHG_IND = 'Y'                         
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE REGISTER_DATA CURSOR FOR                                
MFA-TR*         SELECT A.METER_NO                                               
MFA-TR*               ,A.REG_ID_NO                                              
MFA-TR*               ,B.LAST_READ_VALUE                                        
MFA-TR*               ,A.LAST_READ_VALUE                                        
MFA-TR*               ,A.READ_VALUE_IS                                          
MFA-TR*               ,B.MIN_UNITS                                              
MFA-TR*               ,B.MAX_UNITS                                              
MFA-TR*               ,B.CONSTANT                                               
MFA-TR*               ,B.NO_DIALS                                               
MFA-TR*               ,A.CONSTANT                                               
MFA-TR*               ,A.NO_DIALS                                               
MFA-TR*               ,A.CODE_USAGE_TYPE                                        
MFA-TR*               ,A.CODE_UTIL_TYPE                                         
MFA-TR*               ,C.MTR_READ_SOURCE_CD                                     
MFA-TR*               ,B.LAST_REG_READ_DATE                                     
MFA-TR*          FROM  CSS_SO_REG_CHG A,                                        
MFA-TR*                CSS_SO_MTR_VAL B,                                        
MFA-TR*                CSS_SO_MTR_CHG C                                         
MFA-TR*          WHERE A.SERV_ORDER_NO    = :WS-ORDER-NO                        
MFA-TR*            AND B.SERV_ORDER_NO    = :WS-ORDER-NO                        
MFA-TR*            AND A.SERV_ORDER_NO    = C.SERV_ORDER_NO                     
MFA-TR*            AND A.CODE_UTIL_TYPE   = B.CODE_UTIL_TYPE                    
MFA-TR*            AND A.CODE_UTIL_TYPE   = C.CODE_UTIL_TYPE                    
MFA-TR*            AND A.IC_NO            = B.IC_NO                             
MFA-TR*            AND A.IC_NO            = C.IC_NO                             
MFA-TR*            AND A.METER_NO         = B.METER_NO                          
MFA-TR*            AND A.METER_NO         = C.METER_NO                          
MFA-TR*            AND A.MTR_REF_NO       = B.MTR_REF_NO                        
MFA-TR*            AND A.MTR_REF_NO       = C.MTR_REF_NO                        
MFA-TR*            AND A.CODE_TIME_PERIOD = B.CODE_TIME_PERIOD                  
MFA-TR*            AND A.CODE_TIME_PERIOD = C.CODE_TIME_PERIOD                  
MFA-TR*            AND A.REG_ID_NO        = B.REG_ID_NO                         
MFA-TR*            AND C.POST_MTR_CHG_IND = 'Y'                                 
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*          QUERYNO 7210                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  ROWS FOR NEW METERS.                                        **        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE NEW_METER_DATA CURSOR FOR                       
                SELECT A.METER_NO                                       
                      ,A.REG_ID_NO                                      
                      ,B.CONSTANT                                       
                      ,B.NO_DIALS                                       
                      ,A.CONSTANT                                       
                      ,A.NO_DIALS                                       
                      ,A.CODE_UTIL_TYPE                                 
                  FROM CSS_SO_METER   A WITH(READUNCOMMITTED),                  
                       CSS_SO_MTR_VAL B WITH(READUNCOMMITTED)                   
                 WHERE A.SERV_ORDER_NO   = :WS-ORDER-NO                 
                   AND B.SERV_ORDER_NO   = :WS-ORDER-NO                 
                   AND A.CODE_UTIL_TYPE  = B.CODE_UTIL_TYPE             
                   AND A.METER_NO        = B.METER_NO                   
                   AND A.REG_ID_NO       = B.REG_ID_NO                  
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE NEW_METER_DATA CURSOR FOR                               
MFA-TR*         SELECT A.METER_NO                                               
MFA-TR*               ,A.REG_ID_NO                                              
MFA-TR*               ,B.CONSTANT                                               
MFA-TR*               ,B.NO_DIALS                                               
MFA-TR*               ,A.CONSTANT                                               
MFA-TR*               ,A.NO_DIALS                                               
MFA-TR*               ,A.CODE_UTIL_TYPE                                         
MFA-TR*           FROM CSS_SO_METER   A,                                        
MFA-TR*                CSS_SO_MTR_VAL B                                         
MFA-TR*          WHERE A.SERV_ORDER_NO   = :WS-ORDER-NO                         
MFA-TR*            AND B.SERV_ORDER_NO   = :WS-ORDER-NO                         
MFA-TR*            AND A.CODE_UTIL_TYPE  = B.CODE_UTIL_TYPE                     
MFA-TR*            AND A.METER_NO        = B.METER_NO                           
MFA-TR*            AND A.REG_ID_NO       = B.REG_ID_NO                          
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*          QUERYNO 7310                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  ROWS FOR NEW REGISTERS.                                     **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE NEW_REGISTER_DATA CURSOR FOR                      
              SELECT A.METER_NO                                         
                    ,A.REG_ID_NO                                        
                    ,B.CONSTANT                                         
                    ,B.NO_DIALS                                         
                    ,A.CONSTANT                                         
                    ,A.NO_DIALS                                         
                    ,A.CODE_UTIL_TYPE                                   
               FROM  CSS_SO_REGISTER A WITH(READUNCOMMITTED),                   
                     CSS_SO_MTR_VAL  B WITH(READUNCOMMITTED)                    
              WHERE A.SERV_ORDER_NO    = :WS-ORDER-NO                   
                AND B.SERV_ORDER_NO    = :WS-ORDER-NO                   
                AND A.CODE_UTIL_TYPE   = B.CODE_UTIL_TYPE               
                AND A.METER_NO         = B.METER_NO                     
                AND A.REG_ID_NO        = B.REG_ID_NO                    
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE NEW_REGISTER_DATA CURSOR FOR                              
MFA-TR*       SELECT A.METER_NO                                                 
MFA-TR*             ,A.REG_ID_NO                                                
MFA-TR*             ,B.CONSTANT                                                 
MFA-TR*             ,B.NO_DIALS                                                 
MFA-TR*             ,A.CONSTANT                                                 
MFA-TR*             ,A.NO_DIALS                                                 
MFA-TR*             ,A.CODE_UTIL_TYPE                                           
MFA-TR*        FROM  CSS_SO_REGISTER A,                                         
MFA-TR*              CSS_SO_MTR_VAL  B                                          
MFA-TR*       WHERE A.SERV_ORDER_NO    = :WS-ORDER-NO                           
MFA-TR*         AND B.SERV_ORDER_NO    = :WS-ORDER-NO                           
MFA-TR*         AND A.CODE_UTIL_TYPE   = B.CODE_UTIL_TYPE                       
MFA-TR*         AND A.METER_NO         = B.METER_NO                             
MFA-TR*         AND A.REG_ID_NO        = B.REG_ID_NO                            
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*       QUERYNO 7410                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE RESULTENT CURSOR                 **        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT DISTINCT RETURN_CODE                             
                      ,LTRIM(RTRIM(SO_ERROR_MSG_NO))   AS 
           SO_ERROR_MSG_NO      
                      ,LTRIM(RTRIM(SO_ERROR_MSG_TEXT)) AS 
           SO_ERROR_MSG_TEXT    
                      ,LTRIM(RTRIM(SO_OVRD_MSG_IND))   AS 
           SO_OVRD_MSG_IND      
                      ,LTRIM(RTRIM(SO_FIX_PANEL_NO))   AS 
           SO_FIX_PANEL_NO      
                      ,COALESCE(PAGE_NAME,' ')                          
                      ,'N'                                              
                  FROM #CSR00109_R1                              
                  LEFT OUTER JOIN CSS_OBJ_VIEW_PAGE                     
                    ON PANEL_NO = SO_FIX_PANEL_NO                       
              ORDER BY SO_OVRD_MSG_IND                                  
                      ,SO_ERROR_MSG_NO                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,STRIP(SO_ERROR_MSG_NO)   AS SO_ERROR_MSG_NO              
MFA-TR*               ,STRIP(SO_ERROR_MSG_TEXT) AS SO_ERROR_MSG_TEXT            
MFA-TR*               ,STRIP(SO_OVRD_MSG_IND)   AS SO_OVRD_MSG_IND              
MFA-TR*               ,STRIP(SO_FIX_PANEL_NO)   AS SO_FIX_PANEL_NO              
MFA-TR*               ,COALESCE(PAGE_NAME,' ')                                  
MFA-TR*               ,'N'                                                      
MFA-TR*           FROM SESSION.CSR00109_R1                                      
MFA-TR*           LEFT OUTER JOIN CSS_OBJ_VIEW_PAGE                             
MFA-TR*             ON PANEL_NO = SO_FIX_PANEL_NO                               
MFA-TR*       ORDER BY SO_OVRD_MSG_IND                                          
MFA-TR*               ,SO_ERROR_MSG_NO                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
C33886*****************************************************************         
C33886*  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **         
C33886*  ROWS FOR AMR REQUIREMENTS ON METERED ORDERS                 **         
C33886*****************************************************************         
C33886     EXEC SQL                                                     
C33886         DECLARE AMR_MTR_CUR CURSOR FOR                           
C33886         SELECT SO.ORDER_TYPE_CD                                  
C33886               ,SO.COMPANY_NO                                     
C33886               ,SI.WORK_TYPE_CD                                   
C33886               ,SI.CODE_UTIL_TYPE                                 
C33886               ,SI.METER_NO                                       
C33886               ,AR.ATT_AMR_READ_REQMT                             
C33886               ,AR.ATT_INSTALL_ALLOW                              
C33886               ,AR.ATT_REMOVE_ALLOW                               
C33886         FROM  CSS_SO_ORDER_INST     SI WITH(READUNCOMMITTED),            
C33886               CSS_SO_DATA           SO WITH(READUNCOMMITTED),            
C33886               CSS_WKTYP_REQMTS      AR WITH(READUNCOMMITTED)             
C33886         WHERE SI.SERV_ORDER_NO      = :WS-ORDER-NO               
C33886           AND SO.SERV_ORDER_NO      = :WS-ORDER-NO               
C33886           AND SI.WORK_TYPE_CD       > '   '                      
C33886           AND AR.COMPANY_NO         = SO.COMPANY_NO              
C33886           AND AR.CODE_UTIL_TYPE     = SI.CODE_UTIL_TYPE          
C33886           AND AR.ORDER_TYPE_CD      = SO.ORDER_TYPE_CD           
C33886           AND AR.WORK_TYPE_CD       = SI.WORK_TYPE_CD            
C33886           FOR READ ONLY                                  
                                                            
C33886     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE AMR_MTR_CUR CURSOR FOR                                   
MFA-TR*        SELECT SO.ORDER_TYPE_CD                                          
MFA-TR*              ,SO.COMPANY_NO                                             
MFA-TR*              ,SI.WORK_TYPE_CD                                           
MFA-TR*              ,SI.CODE_UTIL_TYPE                                         
MFA-TR*              ,SI.METER_NO                                               
MFA-TR*              ,AR.ATT_AMR_READ_REQMT                                     
MFA-TR*              ,AR.ATT_INSTALL_ALLOW                                      
MFA-TR*              ,AR.ATT_REMOVE_ALLOW                                       
MFA-TR*        FROM  CSS_SO_ORDER_INST     SI,                                  
MFA-TR*              CSS_SO_DATA           SO,                                  
MFA-TR*              CSS_WKTYP_REQMTS      AR                                   
MFA-TR*        WHERE SI.SERV_ORDER_NO      = :WS-ORDER-NO                       
MFA-TR*          AND SO.SERV_ORDER_NO      = :WS-ORDER-NO                       
MFA-TR*          AND SI.WORK_TYPE_CD       > '   '                              
MFA-TR*          AND AR.COMPANY_NO         = SO.COMPANY_NO                      
MFA-TR*          AND AR.CODE_UTIL_TYPE     = SI.CODE_UTIL_TYPE                  
MFA-TR*          AND AR.ORDER_TYPE_CD      = SO.ORDER_TYPE_CD                   
MFA-TR*          AND AR.WORK_TYPE_CD       = SI.WORK_TYPE_CD                    
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*        QUERYNO 7610                                                     
MFA-TR*    END-EXEC.                                                            
C33886                                                                  
C33886*****************************************************************         
C33886*  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING ALL        **         
C33886*  ATTACHMENT ROWS ON A METERED ORDER                          **         
C33886*****************************************************************         
C33886     EXEC SQL                                                     
C33886         DECLARE AMR_ATT_CUR CURSOR FOR                           
C33886         SELECT SA.IC_NO                                          
C33886               ,SA.MTR_REF_NO                                     
C33886               ,SA.REG_ID_NO                                      
C33886               ,SA.DEVICE_NO                                      
C33886               ,SA.CODE_ATT_TYPE                                  
C33886               ,SA.STATUS_CD                                      
C33886               ,SA.CODE_STATUS_REASON                             
C33886               ,SA.READ_VALUE_IS                                  
C33886               ,SA.HOW_ATTACHED_CD                                
C33886               ,'N'                                               
C33886         FROM  CSS_SO_MTR_ATT        SA WITH(READUNCOMMITTED)             
C33886         WHERE SA.SERV_ORDER_NO      = :WS-ORDER-NO               
C33886           AND SA.COMPANY_NO         = :WS-AMR-COMPANY-NO         
C33886           AND SA.CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE     
C33886           AND SA.METER_NO           = :WS-AMR-METER-NO           
C33886         UNION                                                    
C33886         SELECT SB.IC_NO                                          
C33886               ,SB.MTR_REF_NO                                     
C33886               ,SB.REG_ID_NO                                      
C33886               ,SB.DEVICE_NO                                      
C33886               ,SB.CODE_ATT_TYPE                                  
C33886               ,SB.STATUS_CD                                      
C33886               ,SB.CODE_STATUS_REASON                             
C33886               ,SB.READ_VALUE_IS                                  
C33886               ,SB.HOW_ATTACHED_CD                                
C33886               ,'C'                                               
C33886         FROM  CSS_SO_MTR_ATT_CHG    SB WITH(READUNCOMMITTED)             
C33886         WHERE SB.SERV_ORDER_NO      = :WS-ORDER-NO               
C33886           AND SB.COMPANY_NO         = :WS-AMR-COMPANY-NO         
C33886           AND SB.CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE     
C33886           AND SB.METER_NO           = :WS-AMR-METER-NO           
C33886           FOR READ ONLY                                  
                                                            
C33886     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE AMR_ATT_CUR CURSOR FOR                                   
MFA-TR*        SELECT SA.IC_NO                                                  
MFA-TR*              ,SA.MTR_REF_NO                                             
MFA-TR*              ,SA.REG_ID_NO                                              
MFA-TR*              ,SA.DEVICE_NO                                              
MFA-TR*              ,SA.CODE_ATT_TYPE                                          
MFA-TR*              ,SA.STATUS_CD                                              
MFA-TR*              ,SA.CODE_STATUS_REASON                                     
MFA-TR*              ,SA.READ_VALUE_IS                                          
MFA-TR*              ,SA.HOW_ATTACHED_CD                                        
MFA-TR*              ,'N'                                                       
MFA-TR*        FROM  CSS_SO_MTR_ATT        SA                                   
MFA-TR*        WHERE SA.SERV_ORDER_NO      = :WS-ORDER-NO                       
MFA-TR*          AND SA.COMPANY_NO         = :WS-AMR-COMPANY-NO                 
MFA-TR*          AND SA.CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE             
MFA-TR*          AND SA.METER_NO           = :WS-AMR-METER-NO                   
MFA-TR*        UNION                                                            
MFA-TR*        SELECT SB.IC_NO                                                  
MFA-TR*              ,SB.MTR_REF_NO                                             
MFA-TR*              ,SB.REG_ID_NO                                              
MFA-TR*              ,SB.DEVICE_NO                                              
MFA-TR*              ,SB.CODE_ATT_TYPE                                          
MFA-TR*              ,SB.STATUS_CD                                              
MFA-TR*              ,SB.CODE_STATUS_REASON                                     
MFA-TR*              ,SB.READ_VALUE_IS                                          
MFA-TR*              ,SB.HOW_ATTACHED_CD                                        
MFA-TR*              ,'C'                                                       
MFA-TR*        FROM  CSS_SO_MTR_ATT_CHG    SB                                   
MFA-TR*        WHERE SB.SERV_ORDER_NO      = :WS-ORDER-NO                       
MFA-TR*          AND SB.COMPANY_NO         = :WS-AMR-COMPANY-NO                 
MFA-TR*          AND SB.CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE             
MFA-TR*          AND SB.METER_NO           = :WS-AMR-METER-NO                   
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*        QUERYNO 7710                                                     
MFA-TR*    END-EXEC.                                                            
C33886                                                                  
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE RETURN CODE CURSOR               **        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE C2 CURSOR  FOR                        
               SELECT                                                   
                  :S-RETURN-CODE       AS RETURN_CODE                   
               FROM                                                     
                  CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*           :S-RETURN-CODE       AS RETURN_CODE                           
MFA-TR*        FROM                                                             
MFA-TR*           SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-SERV-ORDER-NO                PIC X(13).                 
       01  LINK-CAD-EDIT-FLAG                PIC X(01).                 
                                                                        
       PROCEDURE DIVISION USING LINK-SERV-ORDER-NO                      
                                LINK-CAD-EDIT-FLAG.                     
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
      ******************************************************************        
      **                                                              **        
      **    0000-MAINLINE                                             **        
      **                                                              **        
      **    CONTROLS THE MAIN PATH OF THE PROGRAM                     **        
      **                                                              **        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INIT-SERVER    THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INIT-SERVER.                                                
                                                                        
           MOVE LINK-SERV-ORDER-NO        TO PARM-SERV-ORDER-NO.        
           MOVE LINK-CAD-EDIT-FLAG        TO PARM-CAD-EDIT-FLAG.        
                                                                        
                                                                        
           MOVE 33              TO WS-BILL-EXCEPTION-WQ-CATEGORY.       
           MOVE 9               TO WS-FINAL-BILL-INVESTIGATE-WQ.        
           MOVE 'A'             TO WS-WQ-ASSIGNED.                      
           MOVE 'I'             TO WS-WQ-IN-PROGRESS.                   
           MOVE 244             TO WS-NO-MKTG-CNT-ID-WQ-CATEGORY.       
                                                                        
           PERFORM 0100A-DECLARE-GTT      THRU 0100A-EXIT               
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 0110-GET-DELINQ-DATA   THRU 0110-EXIT.               
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           PERFORM 0120-GET-TODAY-DATE    THRU 0120-EXIT                
                                                                        
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR00109_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR00109_R1
              (                                                      
                   RETURN_CODE       INT                            
                  ,SO_ERROR_MSG_NO CHAR(05)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,SO_ERROR_MSG_TEXT CHAR(210)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,SO_OVRD_MSG_IND CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,SO_FIX_PANEL_NO CHAR(04)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,REG_ID_NO CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,NO_DIALS CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,CONSTANT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
C33886            ,ERT_READ          DECIMAL(12,3)                      
C33886            ,IDX_READ          DECIMAL(12,3)                      
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE              TO WS-SQLSTATE.                   
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSR00109_R1'         TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR00109_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR00109_R2
              (                                                      
                   SERV_ORDER_NO    DECIMAL(13,0)                       
                  ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,IC_NO            INT                             
                  ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,MTR_REF_NO       INT                             
                  ,REG_ID_NO        INT                             
                  ,CODE_TIME_PERIOD INT                             
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE              TO WS-SQLSTATE.                   
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DELETE-GTT-ROWS THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSR00109_R2'         TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
            .                                                           
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       0110-GET-DELINQ-DATA.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                                           
A03206                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 0110                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '0110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1         
              MOVE 'DATABASE'                TO HOSTVAR-ELEMENT-1       
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE '01'                      TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
           .                                                            
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0120-GET-TODAY-DATE.                                             
           EXEC SQL                                                     
               SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                         
                 INTO :WS-TODAY                                         
                 FROM CIS.SYSDUMMY1                                  
A03206                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ027
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE(CURRENT DATE)                                        
MFA-TR*          INTO :WS-TODAY                                                 
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*          QUERYNO 0120                                                   
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '0120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'SYSIBM.SYSDUMMY1'        TO TABLE-1                 
              MOVE 'CURRENT DATE'            TO TABLE-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
       0120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *     1. RECEIVE PARMS FROM THE CLIENT.                          *        
      *     2. MOVE NUMERIC PARMS FROM PIC9()'S TO PICS9() COMP'S.     *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           UNSTRING PARM-SERV-ORDER-NO DELIMITED BY ' '                 
                                         INTO WS-SERV-ORDER-NO.         
                                                                        
           MOVE WS-SERV-ORDER-NO          TO  PARM-SERV-ORDER-NO-RED.   
           MOVE PARM-SERV-ORDER-NO-RED    TO  PARM-SERV-ORDER-NO-NUM.   
           MOVE PARM-SERV-ORDER-NO-NUM    TO  WS-ORDER-NO.              
                                                                        
           PERFORM 5100-GET-SO-DATA THRU 5100-EXIT.                     
                                                                        
           IF WS-NULL-IND-1 = -1                                        
              MOVE SPACES                TO VO-COMPLETED-DATETIME       
           END-IF                                                       
                                                                        
           IF WS-NULL-IND-2 = -1                                        
              MOVE SPACES                TO VO-DATE-RECVED              
           END-IF                                                       
                                                                        
           IF WS-NULL-IND-3 = -1                                        
              MOVE SPACES                TO VO-ASSIGNED-DATETIME        
           END-IF                                                       
                                                                        
           PERFORM 5110-MOVE-SO-DATA THRU 5110-EXIT.                    
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                          *         
      *                                                               *         
      *     1. DESCRIBE RESULT SET                                    *         
      *     2. UPDATE DB2 DATA                                        *         
      *     3. BUILD RESULT SET                                       *         
      *     4. SEND RESULT SET                                        *         
      *                                                               *         
      *****************************************************************         
       2000-PROCESS-OUTPUT.                                             
                                                                        
T36624     IF WS-ORDER-TYPE-CD NOT = 'FW004'                            
                PERFORM 2100-TRAP-ERRORS             THRU 2100-EXIT     
                PERFORM 2700-CHK-MTR-REG-CHANGES     THRU 2700-EXIT     
T36624     END-IF.                                                      
C33886     PERFORM 2950-CHK-MTR-ATT-REQMTS        THRU 2950-EXIT.       
T37106     PERFORM 5775-VALIDATE-METER-PRESSURE   THRU 5775-EXIT.       
A05020     PERFORM 2620-VALIDATE-SO408            THRU 2620-EXIT.       
           PERFORM 8200-UPDATE-RESULT-TABLE       THRU 8200-EXIT.       
           PERFORM 8110-DELETE-SO-MTR-VAL         THRU 8110-EXIT.       
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2010 MOVE RESULTS                                              *        
      *     -- THIS MODULE MOVES THE DATA TO THE RS- FIELDS            *        
      ******************************************************************        
       2010-MOVE-RESULTS.                                               
                                                                        
           MOVE WS-MESSAGE-NO          TO RS-SO-ERROR-MSG-NO.           
           MOVE SPACES                 TO RS-SO-ERROR-MSG-TEXT.         
           MOVE SPACES                 TO RS-SO-OVRD-MSG-IND.           
           MOVE SPACES                 TO RS-SO-FIX-PANEL-NO.           
           MOVE WS-METER-NO            TO RS-METER-NO.                  
           MOVE WS-REG-ID-CHAR         TO RS-REG-ID-NO.                 
           MOVE SPACES                 TO RS-NO-DIALS.                  
           MOVE SPACES                 TO RS-CONSTANT.                  
C33886     MOVE WS-AMR-READ-VALUE-IS   TO RS-ERT-READ.                  
C33886     MOVE WS-AMR-IDX-READ        TO RS-IDX-READ.                  
           .                                                            
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000A-MOVE-RESULT.                                                       
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
           MOVE RS-SO-ERROR-MSG-NO     TO S-SO-ERROR-MSG-NO.            
           MOVE RS-SO-ERROR-MSG-TEXT   TO S-SO-ERROR-MSG-TEXT.          
           MOVE RS-SO-OVRD-MSG-IND     TO S-SO-OVRD-MSG-IND.            
           MOVE RS-SO-FIX-PANEL-NO     TO S-SO-FIX-PANEL-NO.            
           MOVE RS-METER-NO            TO S-METER-NO.                   
           MOVE RS-REG-ID-NO           TO S-REG-ID-NO.                  
           MOVE RS-NO-DIALS            TO S-NO-DIALS.                   
           MOVE RS-CONSTANT            TO S-CONSTANT.                   
C33886     MOVE RS-ERT-READ            TO S-ERT-READ.                   
C33886     MOVE RS-IDX-READ            TO S-IDX-READ.                   
            .                                                           
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       2100-TRAP-ERRORS.                                                
                                                                        
FIX                                                                     
21703      PERFORM 2110-CHECK-SYNC-CD-PRESENT   THRU 2110-EXIT.         
           PERFORM 2120-SET-SO-FINAL-BILL       THRU 2120-EXIT.         
           PERFORM 2130-VALIDATE-SO091          THRU 2130-EXIT.         
NR******   PERFORM 2140-CHECK-CODE-ACT-STATUS   THRU 2140-EXIT.                 
           PERFORM 2150-VALIDATE-SO254          THRU 2150-EXIT.         
           PERFORM 2160-VALIDATE-SO255          THRU 2160-EXIT.         
           PERFORM 2170-VALIDATE-SO256          THRU 2170-EXIT.         
           PERFORM 2180-VALIDATE-SO257          THRU 2180-EXIT.         
           PERFORM 2190-VALIDATE-SO258          THRU 2190-EXIT.         
CML   * COMMENT OUT DEFAULT RATES FOR SEASONAL ON ORDERS.                       
33924 *    PERFORM 2200-CHECK-SEASONAL-ORDER    THRU 2200-EXIT.                 
CML   * COMMENT OUT FOR CML 32676                                               
32676 *    PERFORM 2210-SEASONAL-GAS-SERV-CHG   THRU 2210-EXIT.                 
32676 *    PERFORM 2215-DATE-CHECK              THRU 2215-EXIT.                 
C35978*    PERFORM 2220-WH-RATE-FLIP            THRU 2220-EXIT.                 
           PERFORM 2230-VALIDATE-SO262          THRU 2230-EXIT.         
           PERFORM 2240-VALIDATE-SO081          THRU 2240-EXIT.         
           PERFORM 2250-VALIDATE-SO082          THRU 2250-EXIT.         
           PERFORM 2260-VALIDATE-SO253          THRU 2260-EXIT.         
           PERFORM 2270-VALIDATE-SO083          THRU 2270-EXIT.         
           PERFORM 2280-VALIDATE-SO079          THRU 2280-EXIT.         
           PERFORM 2290-VALIDATE-SO080          THRU 2290-EXIT.         
           PERFORM 2300-ADD-POINT-ID-TO-CADSO   THRU 2300-EXIT.         
           PERFORM 2310-VALIDATE-SO068          THRU 2310-EXIT.         
           PERFORM 2315-VALIDATE-SO078          THRU 2315-EXIT.         
           PERFORM 2320-VALIDATE-SO040          THRU 2320-EXIT.         
           PERFORM 2330-VALIDATE-SO057          THRU 2330-EXIT.         
           PERFORM 2340-VALIDATE-SO003          THRU 2340-EXIT.         
           PERFORM 2350-VALIDATE-SO019          THRU 2350-EXIT.         
           PERFORM 2360-VALIDATE-SO251          THRU 2360-EXIT.         
           PERFORM 2370-VALIDATE-SO054          THRU 2370-EXIT.         
           PERFORM 2390-VALIDATE-SO058          THRU 2390-EXIT.         
           PERFORM 2400-VALIDATE-SO252          THRU 2400-EXIT.         
           PERFORM 2410-VALIDATE-SO092          THRU 2410-EXIT.         
           PERFORM 2420-VALIDATE-SO039          THRU 2420-EXIT.         
           PERFORM 2430-VALIDATE-SO040          THRU 2430-EXIT.         
           PERFORM 2440-VALIDATE-SO056          THRU 2440-EXIT.         
           PERFORM 2450-VALIDATE-SO041          THRU 2450-EXIT.         
           PERFORM 2460-VALIDATE-SO087          THRU 2460-EXIT.         
           PERFORM 2470-VALIDATE-SO042          THRU 2470-EXIT.         
           PERFORM 2480-VALIDATE-SO084          THRU 2480-EXIT.         
           PERFORM 2490-VALIDATE-SO085          THRU 2490-EXIT.         
           PERFORM 2500-VALIDATE-SO088          THRU 2500-EXIT.         
           PERFORM 2510-VALIDATE-SO043          THRU 2510-EXIT.         
           PERFORM 2520-VALIDATE-SO044          THRU 2520-EXIT.         
           PERFORM 2530-VALIDATE-SO053          THRU 2530-EXIT.         
A03206     PERFORM 2540-VALIDATE-SO407          THRU 2540-EXIT.         
           PERFORM 2600-TALLY-MTR-REG           THRU 2600-EXIT.         
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * FIX FOR TPR 21703                                              *        
      * CHECK TO MAKE SURE THE METER CHANGE FLAG OF CODES_DATA_PRESENT *        
      * IS IN SYNC WITH THE VALUES IN POST_MTR_CHG_IND ON THE          *        
      * CSS_MTR_CHG TABLE IF THE VALUES OUR OUT OF SYNC UPDATE         *        
      * CODES_DATA_PRESENT                                             *        
      ******************************************************************        
       2110-CHECK-SYNC-CD-PRESENT.                                      
                                                                        
           IF WS-CODE-SO-MTR-CHG = 'A'                                  
              PERFORM 5300-CHECK-SO-MTR-CHG    THRU 5300-EXIT           
              IF NOT-EXISTS-DATA-FG1                                    
                 PERFORM 8300-UPDATE-MTR-CHG     THRU 8300-EXIT         
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2110-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CML 22881 - SET WS-SO-FINAL-BILL TO N FOR SEASONAL OFF ORDERS  *        
      ******************************************************************        
       2120-SET-SO-FINAL-BILL.                                          
                                                                        
           IF WS-ORDER-TYPE-CD = 'FM001' AND WS-CODE-SO-FINAL-BILL = 'A'
              PERFORM  8310-UPDATE-FINAL-BILL  THRU 8310-EXIT           
           END-IF                                                       
           .                                                            
       2120-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CML 26359-29  ADDED CODE FOR SEB REGULATED TO CHECK TO MAKE    *        
      * SURE THE RATES HAVE BEEN ALREADY SET UP                        *        
      ******************************************************************        
       2130-VALIDATE-SO091.                                             
                                                                        
           IF SEB-DATABASE                                              
              PERFORM 5305-CHECK-REG-PROFILE   THRU 5305-EXIT           
                                                                        
              IF EXISTS-DATA-FG2                                        
                 PERFORM 5310-CHECK-UTIL-ENVIRONMENT                    
                                               THRU 5310-EXIT           
                 IF NOT-EXISTS-DATA-FG3                                 
                                                                        
                    MOVE 'SO091'           TO WS-MESSAGE-NO             
                    MOVE WS-REG-ID         TO WS-REG-ID-NUM             
                                                                        
                    PERFORM 8140-ADD-INTO-RESULT-TABLE                  
                       THRU 8140-EXIT                                   
                                                                        
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CHECK ACCOUNT STATUS FOR ACCOUNT_NO FOR CC, OC AND DO NOT POST *        
      * IF ACCOUNT STATUS IS NOT 'P' LHO                               *        
      * CML 25537   LHO 10/29/2001                                     *        
      ******************************************************************        
                                                                        
       2150-VALIDATE-SO254.                                             
           PERFORM 5200-SET-CD-ACT-STATUS-NEW  THRU 5200-EXIT           
                                                                        
           IF (WS-ORDER-TYPE-CD(1:2) = 'CC' OR                          
               WS-ORDER-TYPE-CD(1:2) = 'NC' OR                          
               WS-ORDER-TYPE-CD = 'UMRCC' OR WS-ORDER-TYPE-CD = 'UMROC')
               AND WS-CODE-ACCOUNT-STATUS-NEW NOT = 'P'                 
                                                                        
               MOVE 'SO254'            TO WS-MESSAGE-NO                 
               MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
                                                                        
           END-IF                                                       
           .                                                            
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2160-VALIDATE-SO255.                                             
                                                                        
           PERFORM 5315-CHECK-SO-MTR-CHG       THRU 5315-EXIT           
           PERFORM 5320-CHECK-SO-METER         THRU 5320-EXIT           
                                                                        
           IF EXISTS-DATA-FG4 OR EXISTS-DATA-FG5                        
                                                                        
      ******************************************************************        
      * CML 24337 - ORDER REASON CODE OF 8 IS VALID ONLY FOR SEB DNP01 *        
      * AND SEB OFF ORDERS                                             *        
      ******************************************************************        
                                                                        
             IF (WS-ORDER-TYPE-CD(1:3) = 'DNP' OR                       
                 WS-ORDER-TYPE-CD(1:3) = 'OFF') AND SEB-DATABASE        
                                                                        
                                                                        
                MOVE 'Y'               TO  WS-SONP-REASON               
                                                                        
             ELSE                                                       
                                                                        
               MOVE 'SO255'            TO WS-MESSAGE-NO                 
               MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
                                                                        
             END-IF
           END-IF                                                     
           .                                                            
       2160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CML 26003 CHANGES START                                        *        
      * IF ATTEMPTING TO POST AN ORDER FOR JOBBING ORDERS FOR PSNC MAKE*        
      * SURE THAT THE ACCOUNT HAS MATERIAL/LABOR AMOUNTS ENTERED FROM  *        
      * JOBCHARGES PANEL067                                            *        
      ******************************************************************        
                                                                        
       2170-VALIDATE-SO256.                                             
                                                                        
           IF WS-ORDER-TYPE-CD = 'FW022'                                
              PERFORM 5325-CHECK-SO-CHARGES    THRU 5325-EXIT           
              IF NOT-EXISTS-DATA-FG6                                    
                                                                        
                  MOVE 'SO256'            TO WS-MESSAGE-NO              
                  MOVE WS-REG-ID          TO WS-REG-ID-NUM              
                                                                        
                  PERFORM 8140-ADD-INTO-RESULT-TABLE                    
                     THRU 8140-EXIT                                     
                                                                        
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CML 26298 CHANGES START                                        *        
      * IF ATTEMPTING TO POST AN ORDER FOR PSNC MARKETING ORDERS MAKE  *        
      * SURE THAT THE ACCOUNT HAS MATERIAL/LABOR AMOUNTS ENTERED FROM  *        
      * JOBCHARGES PANEL067                                            *        
      * IF NOT GENERATE AN OVERRIDABLE ERROR MESSAGE                   *        
      ******************************************************************        
                                                                        
       2180-VALIDATE-SO257.                                             
                                                                        
           IF WS-ORDER-TYPE-CD = 'FM007'                                
              PERFORM 5330-CHECK-SO-CHARGES       THRU 5330-EXIT        
              IF NOT-EXISTS-DATA-FG7                                    
                                                                        
                  MOVE 'SO257'            TO WS-MESSAGE-NO              
                  MOVE WS-REG-ID          TO WS-REG-ID-NUM              
                                                                        
                  PERFORM 8140-ADD-INTO-RESULT-TABLE                    
                     THRU 8140-EXIT                                     
                                                                        
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2180-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2190-VALIDATE-SO258.                                             
           IF WS-ORDER-TYPE-CD = 'FM007'                                
               PERFORM 5335-CHECK-SO-DATA          THRU 5335-EXIT       
                                                                        
               IF NOT-EXISTS-DATA-FG8                                   
                                                                        
                   MOVE 'SO258'            TO WS-MESSAGE-NO             
                   MOVE WS-REG-ID          TO WS-REG-ID-NUM             
                                                                        
                  PERFORM 8140-ADD-INTO-RESULT-TABLE                    
                     THRU 8140-EXIT                                     
                                                                        
                  PERFORM 5340-CHECK-WQ-ITEMS      THRU 5340-EXIT       
                  IF EXISTS-DATA-FG9                                    
                     MOVE 'Y'        TO WS-NO-MKTG-CNT-ID-WQ-EXISTS     
                  END-IF                                                
               END-IF                                                   
           END-IF                                                       
           .                                                            
       2190-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CML 33924 - COMMENT OUT DEFAULT RATES FOR SEASONAL ON ORDERS.  *        
      ******************************************************************        
                                                                        
      *2200-CHECK-SEASONAL-ORDER.                                               
      *                                                                         
      *    PERFORM 5345-CHECK-EQUIPMENT        THRU 5345-EXIT                   
      *    IF EXISTS-DATA-FG10                                                  
      *       PERFORM 5350-CHECK-EQUIPMENT     THRU 5350-EXIT                   
      *       IF NOT-EXISTS-DATA-FG11                                           
      *          PERFORM 5355-CHECK-SO-UTL-CHG THRU 5355-EXIT                   
      *          IF EXISTS-DATA-FG12                                            
      *             PERFORM 8400-UPDATE-RATE-PLAN-NO                            
      *                                        THRU 8400-EXIT                   
      *             PERFORM 8320-UPDATE-CODE-NFS-CHK-AMT                        
      *                                        THRU 8320-EXIT                   
      *          END-IF                                                         
      *       END-IF                                                            
      *    END-IF                                                               
      *    .                                                                    
      *2200-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      * CML 30771 - COMMENT OUT ALL APPLIANCE PROCESSING                        
                                                                        
      *2210-SEASONAL-GAS-SERV-CHG.                                              
      *    IF WS-ORDER-TYPE-CD = 'FM002' AND WS-COMPANY-NO = '01'               
      *       AND NOT SEB-DATABASE                                              
      *       PERFORM 5360-CHECK-EQUIPMENT     THRU 5360-EXIT                   
      *       IF EXISTS-DATA-FG13                                               
      *          PERFORM 5365-CHECK-SO-UTILITY THRU 5365-EXIT                   
      *          IF EXISTS-DATA-FG14                                            
      *             PERFORM 8410-UPDATE-RATE-PLAN-NO                            
      *                THRU 8410-EXIT                                           
      *             PERFORM 8330-UPDATE-CODE-LPC                                
      *                THRU 8330-EXIT                                           
      *          END-IF                                                         
      *       END-IF                                                            
      *       PERFORM 5370-CHECK-SO-ORDER-INST THRU 5370-EXIT                   
      *       IF EXISTS-DATA-FG15                                               
      *          PERFORM 5375-CHECK-SO-UTL-CHG THRU 5375-EXIT                   
      *          IF EXISTS-DATA-FG16                                            
      *             PERFORM 8410-UPDATE-RATE-PLAN-NO                            
      *                THRU 8410-EXIT                                           
      *             PERFORM 8320-UPDATE-CODE-NFS-CHK-AMT                        
      *                THRU 8320-EXIT                                           
      *          END-IF                                                         
      *       END-IF                                                            
      *    ELSE                                                                 
      *       PERFORM 5380-CHECK-SO-UTILITY    THRU 5380-EXIT                   
      *       IF EXISTS-DATA-FG17                                               
      *          PERFORM 8420-UPDATE-RATE-PLAN-NO                               
      *             THRU 8420-EXIT                                              
      *          PERFORM 8330-UPDATE-CODE-LPC                                   
      *             THRU 8330-EXIT                                              
      *       END-IF                                                            
      *       PERFORM 5385-CHECK-SO-ORDER-INST THRU 5385-EXIT                   
      *       IF EXISTS-DATA-FG18                                               
      *          PERFORM 5390-CHECK-SO-UTL-CHG THRU 5390-EXIT                   
      *          IF EXISTS-DATA-FG19                                            
      *             PERFORM 8420-UPDATE-RATE-PLAN-NO                            
      *                THRU 8420-EXIT                                           
      *             PERFORM 8320-UPDATE-CODE-NFS-CHK-AMT                        
      *                THRU 8320-EXIT                                           
      *          END-IF                                                         
      *       END-IF                                                            
      *    END-IF                                                               
      *    .                                                                    
      *2210-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      * CML 32676 - Comment out date check.                                     
                                                                        
      *2215-DATE-CHECK.                                                         
      *    IF WS-ORDER-TYPE-CD(1:2) = 'CC' OR WS-ORDER-TYPE-CD = 'NC'           
      *       PERFORM 5395-CHECK-SO-MTR-CHG    THRU 5395-EXIT                   
      *       IF EXISTS-DATA-FG20                                               
      *          MOVE 'SO261'            TO WS-MESSAGE-NO                       
      *          MOVE WS-REG-ID          TO WS-REG-ID-NUM                       
      *                                                                         
      *          PERFORM 2010-MOVE-RESULTS                                      
      *             THRU 2010-EXIT                                              
      *                                                                         
      *          PERFORM 2000A-MOVE-RESULT                                      
      *             THRU 2000A-EXIT                                             
      *          PERFORM 8100-SEND-RESULT                                       
      *             THRU 8100-EXIT                                              
      *       END-IF                                                            
      *    END-IF                                                               
      *                                                                         
      *    .                                                                    
      *2215-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
C35978* PSNC RATE PROCESSING DOES NOT USE APPLIANCES                            
      *2220-WH-RATE-FLIP.                                                       
      *    MOVE 'N'                    TO WS-WH-FLAG.                           
      *                                                                         
      *    PERFORM 5400-CHECK-SO-DATA          THRU 5400-EXIT                   
      *    IF WS-ORDER-TYPE-CD = 'ON001' OR                                     
      *       WS-ORDER-TYPE-CD(1:2) = 'CC' OR                                   
      *       WS-ORDER-TYPE-CD(1:2) = 'NC' OR                                   
      *       EXISTS-DATA-FG21 AND WS-COMPANY-NO = '26'                         
      *                                                                         
      *       MOVE 'Y'                 TO WS-WH-FLAG                            
      *                                                                         
      *    END-IF                                                               
                                                                        
      ******************************************************************        
      * AN A IN THE 19TH POSITION OF CODES_DATA_PRESENT INDICATES THAT *        
      * PCSSO064.SHOULD CHECK FOR A WATER HEATER AND FLIP RATES        *        
      * ACCORDINGLY.                                                   *        
      ******************************************************************        
                                                                        
C35978* PSNC RATE PROCESSING DOES NOT USE APPLIANCES                            
      *    IF WS-WH-FLAG = 'Y'                                                  
      *       PERFORM 8340-UPDATE-WATER-HEATER THRU 8340-EXIT                   
      *    END-IF                                                               
                                                                        
30771 * CML 30771 - COMMENT OUT APPLIANCE PROCESS                               
30771 *    PERFORM 2225-WH-APPLIANCE-PROCESS                                    
      *    .                                                                    
      *2220-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      ******************************************************************        
      * AN A IN THE 19TH POSITION OF CODES_DATA_PRESENT INDICATES A WAT*        
      * WATER HEATER HAS CAUSED A RATE FLIP TO 105.                    *        
      * HANDLE CODES_DATA_PRESENT BECAUSE 1ST UPDATE WAS LOST WHEN 2ND *        
      * DONE IF STUFF IN SQL STATEMENTS.                               *        
      ******************************************************************        
                                                                        
      *2225-WH-APPLIANCE-PROCESS.                                               
      *    IF WS-WH-FLAG = 'Y'                                                  
      *       PERFORM 5405-CHECK-EQUIPMENT     THRU 5405-EXIT                   
      *       IF EXISTS-DATA-FG22                                               
      *          PERFORM 5410-CHECK-SO-UTILITY THRU 5410-EXIT                   
      *          IF EXISTS-DATA-FG23                                            
      *             PERFORM 8430-UPDATE-RATE-PLAN-NO                            
      *                THRU 8430-EXIT                                           
      *             PERFORM 8330-UPDATE-CODE-LPC                                
      *                THRU 8330-EXIT                                           
      *             PERFORM 8340-UPDATE-CODE-CORR                               
      *                THRU 8340-EXIT                                           
      *          END-IF                                                         
      *          PERFORM 5415-CHECK-SO-UTL-CHG THRU 5415-EXIT                   
      *          IF EXISTS-DATA-FG24                                            
      *             PERFORM 8430-UPDATE-RATE-PLAN-NO                            
      *                THRU 8430-EXIT                                           
      *             PERFORM 8320-UPDATE-CODE-NFS-CHK-AMT                        
      *                THRU 8320-EXIT                                           
      *             PERFORM 8340-UPDATE-CODE-CORR                               
      *                THRU 8340-EXIT                                           
      *          END-IF                                                         
      *       END-IF                                                            
      *    ELSE                                                                 
      *       PERFORM 5420-CHECK-SO-UTL-CHG    THRU 5420-EXIT                   
      *       IF (WS-ORDER-TYPE-CD = 'FM003' OR                                 
      *           WS-ORDER-TYPE-CD = 'ON001') AND EXISTS-DATA-FG25              
      *           PERFORM 8320-UPDATE-CODE-NFS-CHK-AMT                          
      *              THRU 8320-EXIT                                             
      *       END-IF                                                            
      *                                                                         
      *       PERFORM 5425-CHECK-SO-UTILITY    THRU 5425-EXIT                   
      *       IF EXISTS-DATA-FG26                                               
      *          PERFORM 8400-UPDATE-RATE-PLAN-NO                               
      *             THRU 8400-EXIT                                              
      *          PERFORM 8330-UPDATE-CODE-LPC                                   
      *             THRU 8330-EXIT                                              
      *       END-IF                                                            
      *                                                                         
      *       PERFORM 5430-CHECK-SO-UTL-CHG    THRU 5430-EXIT                   
      *       IF EXISTS-DATA-FG27                                               
      *          PERFORM 8400-UPDATE-RATE-PLAN-NO                               
      *             THRU 8400-EXIT                                              
      *          PERFORM 8320-UPDATE-CODE-NFS-CHK-AMT                           
      *             THRU 8320-EXIT                                              
      *       END-IF                                                            
      *    END-IF                                                               
      *    .                                                                    
      *2225-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      * CML 33640 - WORK TYPE MUST BE UNL OR SOL IF CUSTOMER REPAIRS            
      * CHARGE EXISTS.                                                          
                                                                        
       2230-VALIDATE-SO262.                                             
           IF WS-ORDER-TYPE-CD = 'FM003' AND                            
              NOT SEB-DATABASE                                          
              AND WS-COMPANY-NO = '01'                                  
                                                                        
              PERFORM 5435-CHECK-SO-MTR-CHG    THRU 5435-EXIT           
                                                                        
              IF EXISTS-DATA-FG28                                       
                                                                        
                 MOVE 'SO262'            TO WS-MESSAGE-NO               
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
                                                                        
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * IF ATTEMPTING TO POST A CUSTOMER CHANGE ORDER AND A SET WAS PRE*        
      * PREVIOUSLY POSTED, MAKE SURE THAT A METER REFRESH HAS BEEN     *        
      * COMPLETED ON THE CUSTOMER CHANGE ORDER BEFORE IT IS POSTED.    *        
      ******************************************************************        
                                                                        
       2240-VALIDATE-SO081.                                             
           PERFORM 5205-GET-CD-ACT-STATUS      THRU 5205-EXIT           
           IF WS-ORDER-TYPE-CD(1:2) = 'CC' AND                          
              WS-CODE-ACCOUNT-STATUS NOT = 'A'                          
              PERFORM 5440-CHECK-SO-DATA       THRU 5440-EXIT           
              IF EXISTS-DATA-FG29                                       
                 PERFORM 5210-GET-SERVICE-ORDER THRU 5210-EXIT          
                 PERFORM 5445-CHECK-SO-METER    THRU 5445-EXIT          
                 IF NOT-EXISTS-DATA-FG30                                
                                                                        
                    MOVE 'SO081'            TO WS-MESSAGE-NO            
                    MOVE WS-REG-ID          TO WS-REG-ID-NUM            
                                                                        
                    PERFORM 8140-ADD-INTO-RESULT-TABLE                  
                       THRU 8140-EXIT                                   
                                                                        
                 END-IF                                                 
              END-IF
           END-IF                                                    
           .                                                            
       2240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * IF A SET ORDER IS BEING POSTED AND THE MOST CURRENT ACCOUNT AT *        
      * THE PREMISE IS INACTIVE, THEN DO NOT LET THE ORDER POST.       *        
      ******************************************************************        
                                                                        
       2250-VALIDATE-SO082.                                             
           IF WS-ORDER-TYPE-CD = 'FM002' AND                            
              WS-CODE-ACCOUNT-STATUS = 'J'                              
                                                                        
               MOVE 'SO082'            TO WS-MESSAGE-NO                 
               MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
                                                                        
           END-IF                                                       
           .                                                            
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * IF A SET ORDER IS BEING POSTED AND THE MOST CURRENT ACCOUNT AT *        
      * THE PREMISE IS PENDING, THEN DO NOT LET THE ORDER POST IF      *        
      * ANOTHER PENDING SET EXISTS THAT WAS CREATED EARLIER.           *        
      * TPR 18409   - PRA/MJG                                          *        
      ******************************************************************        
                                                                        
       2260-VALIDATE-SO253.                                             
           IF WS-ORDER-TYPE-CD = 'FM002' AND                            
              WS-CODE-ACCOUNT-STATUS = 'P'                              
              PERFORM 5450-CHECK-SO-DATA        THRU 5450-EXIT          
              IF EXISTS-DATA-FG31                                       
                                                                        
                 MOVE 'SO253'            TO WS-MESSAGE-NO               
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
                                                                        
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * DO NOT ALLOW AN ORDER TO POST IF IT IS AN OFF AND IT'S FINAL            
      * BILLED                                                                  
                                                                        
       2270-VALIDATE-SO083.                                             
           IF WS-ORDER-TYPE-CD(1:2) = 'OF' AND                          
              WS-CODE-ACCOUNT-STATUS = 'B'                              
                                                                        
               MOVE 'SO083'            TO WS-MESSAGE-NO                 
               MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
                                                                        
           END-IF                                                       
           .                                                            
       2270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * ORDER TYPES WITH A ORDER GROUP CODE OF B (EXCEPT FM008 - GAS   *        
      * APPLIANCE FIELD WORK), C, D AND E CANNOT BE POSTED AS          *        
      * NON-PRODUCTIVE.                                                *        
      ******************************************************************        
                                                                        
       2280-VALIDATE-SO079.                                             
                                                                        
           IF ((WS-ORDER-GROUP-CD = 'B' AND                             
                WS-ORDER-TYPE-CD NOT = 'FM008' AND                      
P00196          WS-ORDER-TYPE-CD NOT = 'FW026') OR                      
                WS-ORDER-GROUP-CD = 'C' OR                              
                WS-ORDER-GROUP-CD = 'D' OR                              
                WS-ORDER-GROUP-CD = 'E') AND                            
                WS-NON-PRODUCTIVE-IND = 'Y'                             
                                                                        
               MOVE 'SO079'            TO WS-MESSAGE-NO                 
               MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
                                                                        
           END-IF                                                       
           .                                                            
       2280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * A RECONNECT ORDER CANNOT BE POSTED IF AN ACTIVE DNP ORDER               
      * EXISTS.                                                                 
                                                                        
       2290-VALIDATE-SO080.                                             
           IF WS-ORDER-TYPE-CD = 'FM006'                                
              PERFORM 5455-CHECK-SO-DATA       THRU 5455-EXIT           
              IF EXISTS-DATA-FG32                                       
                                                                        
                 MOVE 'SO080'            TO WS-MESSAGE-NO               
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
                                                                        
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2290-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * ADDED THE FOLLOWING CODE TO FOR CAD ORDERS OF SOL & MTC.  POINT*        
      * ID IS NOT RE-ENTER IN CAD SO NEED                              *        
      * TO UPDATE POINT ID FROM CSS_SO_MTR_CHG.   LHO 04/09/03         *        
      * CML 29749                                                      *        
      ******************************************************************        
                                                                        
       2300-ADD-POINT-ID-TO-CADSO.                                      
           PERFORM 5460-CHECK-SO-METER         THRU 5460-EXIT           
           IF EXISTS-DATA-FG33                                          
              PERFORM 5215-UPDATE-POINT-ID     THRU 5215-EXIT           
           END-IF                                                       
           .                                                            
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * NEW SET ORDERS MUST HAVE A POINT ID ASSIGNED TO EACH NEW       *        
      * ELECTRIC METER.                                                *        
      * ADDED POINT ID VALIDATION FOR CAD.  LHO 08-10-00               *        
      *                                                                *        
      * CHANGE THIS TO VALIDATE ALL ORDERS WITH SO_METER NOT JUST SETS.*        
      * SOL & MTC ORDERS WERE BEING BYPASSED                           *        
      * LHO 04/09/03  CML 28749                                        *        
      ******************************************************************        
                                                                        
       2310-VALIDATE-SO068.                                             
           PERFORM 5465-CHECK-SO-METER         THRU 5465-EXIT           
           IF EXISTS-DATA-FG34                                          
               MOVE 'SO068'            TO WS-MESSAGE-NO                 
               MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
           ELSE                                                         
              PERFORM 5470-CHECK-SO-METER      THRU 5470-EXIT           
              IF EXISTS-DATA-FG35                                       
                 PERFORM 5220-GET-GIS-POINT-ID  THRU 5220-EXIT          
                 PERFORM 2800-VALIDATE-GIS-POINT-ID THRU 2800-EXIT      
              ELSE                                                      
                 PERFORM 5475-CHECK-SO-METER   THRU 5475-EXIT           
                 IF EXISTS-DATA-FG36                                    
                    PERFORM 5222-GET-POINT-ID  THRU 5222-EXIT           
                    PERFORM 2810-VALIDATE-POINT-ID THRU 2810-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * IF THE ORDER IS A CC, NC OR AN OFF,CHECK IF THERE IS A ASSIGNED*        
      * OR IN PROCESS BILL EXCEPTION WORK QUEUE FOR THE PREMISE OR     *        
      * PRIOR ACCOUNT.IF A WORK QUEUE HAS ALREADY BEEN INSERTED TO     *        
      * INVESTIGATE THE FINAL BILL AND THIS WORK QUEUE IS IN A         *        
      * ASSIGNED OR IN PROGRESS STATUS, THEN AN INDICATOR IS SET THAT  *        
      * WILL APPEND TO THE STANDARD SO078 ERROR MESSAGE IN ORDER TO    *        
      * INSTRUCT PANEL090 NOT TO INSERT ANOTHER WORK QUEUE FOR THIS    *        
      * SERVICE ORDER.                                                 *        
      * INDICATOR IS SET THAT WILL APPEND TO THE STANDARD SO078 ERROR  *        
      * MESSAGE IN ORDER TO INSTRUCT PANEL090 NOT TO INSERT ANOTHER    *        
      * WORK QUEUE FOR THIS SERVICE ORDER                              *        
      ******************************************************************        
                                                                        
       2315-VALIDATE-SO078.                                             
           IF WS-ORDER-TYPE-CD(1:2) = 'CC' OR                           
              WS-ORDER-TYPE-CD(1:2) = 'NC' OR                           
              WS-ORDER-TYPE-CD(1:2) = 'OF'                              
                                                                        
              PERFORM 5480-CHECK-WQ-ITEMS      THRU 5480-EXIT           
              IF EXISTS-DATA-FG37                                       
                 MOVE 'SO078'            TO WS-MESSAGE-NO               
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
              END-IF                                                    
              PERFORM 5485-CHECK-WQ-ITEMS      THRU 5485-EXIT           
              IF EXISTS-DATA-FG38                                       
                 MOVE 'Y'              TO WS-FINAL-BILL-INV-WQ-EXISTS   
              END-IF                                                    
                                                                        
           END-IF                                                       
           .                                                            
       2315-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * THERE CANNOT BE A PENDING OFF ORDER WITH A SCHEDULE DATE PRIOR*         
      * TO AN OCCUPANT CHANGE ORDER FOR THE SAME PREMISE.             *         
      *****************************************************************         
                                                                        
       2320-VALIDATE-SO040.                                             
           IF WS-ORDER-TYPE-CD = 'NC001'                                
      * GET THE ASSIGNED DATETIME OF THE NC ORDER                               
              PERFORM 5225-GET-DATE-TIME       THRU 5225-EXIT           
              IF WS-ASSIGNED-DATETIME > SPACES                          
                 PERFORM 5490-CHECK-SO-DATA       THRU 5490-EXIT        
              END-IF                                                    
              IF EXISTS-DATA-FG39                                       
                                                                        
                 MOVE 'SO040'            TO WS-MESSAGE-NO               
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
                                                                        
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * FOR SEASONAL ON SERVICE ORDERS, THE METER STATUS REASON MUST BE*        
      * 'SEASONAL' AND THE CORRESPONDING ORDER INSTRUCTION MUST HAVE A *        
      * WORK TYPE.                                                     *        
      ******************************************************************        
                                                                        
       2330-VALIDATE-SO057.                                             
           IF WS-ORDER-TYPE-CD = 'ON001'                                
              PERFORM 5495-CHECK-SO-MTR-CHG    THRU 5495-EXIT           
              IF EXISTS-DATA-FG40                                       
                  MOVE 'SO057'            TO WS-MESSAGE-NO              
                  MOVE WS-REG-ID          TO WS-REG-ID-NUM              
                                                                        
                  PERFORM 8140-ADD-INTO-RESULT-TABLE                    
                     THRU 8140-EXIT                                     
                                                                        
              ELSE                                                      
                  PERFORM 5500-CHECK-SO-REG-CHG    THRU 5500-EXIT       
                  IF EXISTS-DATA-FG41                                   
                                                                        
                     MOVE 'SO057'            TO WS-MESSAGE-NO           
                     MOVE WS-REG-ID          TO WS-REG-ID-NUM           
                                                                        
                     PERFORM 8140-ADD-INTO-RESULT-TABLE                 
                     THRU 8140-EXIT                                     
                                                                        
                  END-IF                                                
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************                                      
      * ACCOUNT CURRENTLY READY TO BILL  *                                      
      * TPR 20105 - OMIT CC AND NC.      *                                      
      * TPR 22165 - OMIT UMRCC AND UMROC.*                                      
      ************************************                                      
                                                                        
       2340-VALIDATE-SO003.                                             
                                                                        
           PERFORM 5230-GET-ACT-BILL-STATUS    THRU 5230-EXIT           
           IF WS-CODE-BILL-STATUS = 'B' AND                             
              NOT (WS-ORDER-TYPE-CD(1:2) = 'CC' OR                      
                   WS-ORDER-TYPE-CD(1:2) = 'NC' OR                      
                   WS-ORDER-TYPE-CD = 'UMRCC' OR                        
                   WS-ORDER-TYPE-CD = 'UMROC')                          
                                                                        
                   MOVE 'SO003'            TO WS-MESSAGE-NO             
                   MOVE WS-REG-ID          TO WS-REG-ID-NUM             
                                                                        
                   PERFORM 8140-ADD-INTO-RESULT-TABLE                   
                      THRU 8140-EXIT                                    
           END-IF                                                       
           .                                                            
       2340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************                                                
      * BILLING IS IN PROGRESS *                                                
      **************************                                                
                                                                        
       2350-VALIDATE-SO019.                                             
           IF WS-CODE-BILL-STATUS = 'F'                                 
                                                                        
              MOVE 'SO019'            TO WS-MESSAGE-NO                  
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
                                                                        
           END-IF                                                       
           .                                                            
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CANNOT POST A SEASONAL OFF ORDER WHEN THE ACCOUNT STATUS IS    *        
      * 'PENDING'.                                                     *        
      ******************************************************************        
                                                                        
       2360-VALIDATE-SO251.                                             
           IF WS-ORDER-TYPE-CD = 'FM001' AND                            
              WS-CODE-ACCOUNT-STATUS = 'P'                              
                                                                        
              MOVE 'SO251'            TO WS-MESSAGE-NO                  
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
                                                                        
           END-IF                                                       
           .                                                            
       2360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * IF THE ORDER IS A CC OR OC, THERE CANNOT BE ANY CHARGE AMOUNT  *        
      * FOR PENDING, INACTIVE, WRITE-OFF OR FINAL BILLED ACCOUNTS. ALSO*        
      * IF THE ORDER IS NOT A SET, AND THE ACCOUNT IS PENDING, THERE   *        
      * CANNOT BE ANY SERVICE CHARGES.                                 *        
      ******************************************************************        
                                                                        
       2370-VALIDATE-SO054.                                             
           IF WS-ORDER-TYPE-CD(1:2) NOT = 'CC' AND                      
              WS-ORDER-TYPE-CD(1:2) NOT = 'NC' AND                      
              WS-ORDER-TYPE-CD(1:2) NOT = 'UM'                          
              IF WS-CODE-ACCOUNT-STATUS = 'J' OR                        
                 WS-CODE-ACCOUNT-STATUS = 'B' OR                        
                 WS-CODE-ACCOUNT-STATUS = 'P' OR                        
                 WS-CODE-ACCOUNT-STATUS = 'S'                           
                                                                        
                 MOVE 'N'               TO  WS-CHARGES-INDICATOR        
                 PERFORM 5235-CHECK-DEFAULT-CHARGES THRU 5235-EXIT      
                 IF WS-CHARGES-INDICATOR = 'N'                          
                    PERFORM 5240-CHECK-STANDARD-CHARGES                 
                                                    THRU 5240-EXIT      
                 END-IF                                                 
                 IF WS-CHARGES-INDICATOR = 'N'                          
                    PERFORM 5245-CHECK-MATERIAL-CHARGES                 
                                                    THRU 5245-EXIT      
                 END-IF                                                 
                 IF WS-ORDER-TYPE-CD = 'FW022'                          
                    MOVE  'Y'          TO WS-CHARGES-INDICATOR          
                 END-IF                                                 
                 IF WS-CHARGES-INDICATOR = 'Y' AND                      
                    WS-CODE-ACCOUNT-STATUS-NEW NOT = 'P'                
                                                                        
                    MOVE 'SO054'            TO WS-MESSAGE-NO            
                    MOVE WS-REG-ID          TO WS-REG-ID-NUM            
                                                                        
                    PERFORM 8140-ADD-INTO-RESULT-TABLE                  
                       THRU 8140-EXIT                                   
                 ELSE                                                   
                                                                        
      * CML27880 - CHANGED TO ALLOW MARKETING ORDER TO POST ON PENDING          
      * ACCOUNTS  MSR - 04/29/2003                                              
                                                                        
                   IF WS-CHARGES-INDICATOR = 'Y' AND                    
                      WS-CODE-ACCOUNT-STATUS = 'P' AND                  
                      WS-ORDER-TYPE-CD NOT = 'FM002' AND                
                      WS-ORDER-TYPE-CD NOT = 'FW022' AND                
                      WS-ORDER-TYPE-CD NOT = 'FM007'                    
                                                                        
                      MOVE 'SO055'            TO WS-MESSAGE-NO          
                      MOVE WS-REG-ID          TO WS-REG-ID-NUM          
                                                                        
                      PERFORM 8140-ADD-INTO-RESULT-TABLE                
                         THRU 8140-EXIT                                 
                                                                        
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2370-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * HIGH/LOW CHECK FOR REMOVED METERS FOR AN INACTIVE, FINALED OR *         
      * WRITE-OFF ACCOUNT -- LAST METER READ CANNOT VARY +/- 3 UNITS  *         
      * FROM THE CURRENT READ ENTERED.  TPR 19713 CHANGED FROM 3 TO 4.*         
      * MV90 METERS ARE NOT INCLUDED IN THIS CHECK SINCE THEY DO NOT  *         
      * REQUIRE A READING.  DITTO INDUSTRIAL GAS METERS.              *         
      *****************************************************************         
                                                                        
       2390-VALIDATE-SO058.                                             
           IF WS-CODE-ACCOUNT-STATUS = 'S' OR                           
              WS-CODE-ACCOUNT-STATUS = 'J' OR                           
              WS-CODE-ACCOUNT-STATUS = 'B'                              
              PERFORM 5505-CHECK-SO-MTR-CHG    THRU 5505-EXIT           
              IF EXISTS-DATA-FG42                                       
                 PERFORM 5250-GET-MTRNO-REGID  THRU 5250-EXIT           
                                                                        
                 MOVE 'SO058'            TO WS-MESSAGE-NO               
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
                                                                        
                 MOVE SPACES           TO WS-METER-NO                   
                                                                        
              ELSE                                                      
                  PERFORM 5510-CHECK-SO-MTR-CHG THRU 5510-EXIT          
                  IF EXISTS-DATA-FG43                                   
                     PERFORM 5255-GET-MTRNO-REGID THRU 5255-EXIT        
                                                                        
                     MOVE 'SO058'        TO WS-MESSAGE-NO               
                     MOVE WS-REG-ID      TO WS-REG-ID-NUM               
                                                                        
                     PERFORM 8140-ADD-INTO-RESULT-TABLE                 
                        THRU 8140-EXIT                                  
                                                                        
                     MOVE SPACES       TO WS-METER-NO                   
                  END-IF                                                
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2390-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * ENSURE THAT THE CURRENT METER READING IS NOT LESS THAN THE LAS*         
      * READ VALUE FOR A BACK-DATED SERVICE ORDER.                    *         
      * MV90 METERS ARE NOT INCLUDED IN THIS CHECK SINCE THEY DO NOT  *         
      * REQUIRE A READING.  DITTO GAS INDUSTRIAL.                     *         
      * TPR 19405 - BYPASS SET OLD LOCATION WORK TYPES.               *         
      * TPR 19847 - OMIT CHECK FOR METER CHANGE ORDERS.               *         
      *****************************************************************         
                                                                        
       2400-VALIDATE-SO252.                                             
           IF WS-BACK-DATED-IND = 'Y' AND                               
              WS-ORDER-TYPE-CD NOT = 'MC001'                            
                                                                        
              PERFORM 5515-CHECK-SO-MTR-CHG    THRU 5515-EXIT           
              IF EXISTS-DATA-FG44                                       
                 PERFORM 5260-GET-MTRNO-REGID  THRU 5260-EXIT           
                                                                        
                 MOVE 'SO252'            TO WS-MESSAGE-NO               
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
                                                                        
                 MOVE SPACES           TO WS-METER-NO                   
                                                                        
              ELSE                                                      
                  PERFORM 5520-CHECK-SO-MTR-CHG THRU 5520-EXIT          
                  IF EXISTS-DATA-FG45                                   
                     PERFORM 5265-GET-MTRNO-REGID THRU 5265-EXIT        
                                                                        
                     MOVE 'SO252'        TO WS-MESSAGE-NO               
                     MOVE WS-REG-ID      TO WS-REG-ID-NUM               
                                                                        
                     PERFORM 8140-ADD-INTO-RESULT-TABLE                 
                        THRU 8140-EXIT                                  
                                                                        
                                                                        
                     MOVE SPACES       TO WS-METER-NO                   
                  END-IF                                                
               END-IF                                                   
           END-IF                                                       
           .                                                            
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * DO NOT ALLOW POSTING OF CC2 OR CC3.  THIS ONLY HAPPENS WHEN   *         
      * CHAINING DOES NOT WORK.                                       *         
      * LHO 10/12/2004       CML 31688                                *         
      *****************************************************************         
                                                                        
       2410-VALIDATE-SO092.                                             
           PERFORM 5525-CHECK-SO-DATA          THRU 5525-EXIT           
           IF (WS-ORDER-TYPE-CD = 'CC002' OR                            
               WS-ORDER-TYPE-CD = 'CC003') AND NOT-EXISTS-DATA-FG46     
                                                                        
               MOVE 'SO092'            TO WS-MESSAGE-NO                 
               MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
                                                                        
           END-IF                                                       
           .                                                            
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************                                  
      * FOR CC2, CC1 MUST BE COMPLETED FIRST *                                  
      ****************************************                                  
                                                                        
       2420-VALIDATE-SO039.                                             
           MOVE 'N'                    TO WS-EXISTS-DATA-FG46           
           IF WS-ORDER-TYPE-CD = 'CC002'                                
              PERFORM 5525-CHECK-SO-DATA       THRU 5525-EXIT           
              IF EXISTS-DATA-FG46                                       
                                                                        
               MOVE 'SO039'            TO WS-MESSAGE-NO                 
               MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************                                
      * FOR OFF2, OFF1 MUST BE COMPLETED FIRST *                                
      ******************************************                                
                                                                        
       2430-VALIDATE-SO040.                                             
           IF WS-ORDER-TYPE-CD = 'OFF02'                                
              PERFORM 5530-CHECK-SO-DATA          THRU 5530-EXIT        
              IF EXISTS-DATA-FG47                                       
                 MOVE 'SO040'            TO WS-MESSAGE-NO               
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *********************************************************                 
      * IF THE ORDER IS AN OFF ORDER, THEN DO NOT ALLOW IT TO *                 
      * POST IF THE METER STATUS IS INACTIVE OR REMOVED AND IF*                 
      * THE POST_MTR_CHG_IND ON CSS_SO_MTR_CHG IS = 'Y'.      *                 
      *********************************************************                 
                                                                        
       2440-VALIDATE-SO056.                                             
           IF WS-ORDER-TYPE-CD(1:2) = 'OF'                              
              PERFORM 5535-CHECK-SO-MTR-CHG    THRU 5535-EXIT           
              IF EXISTS-DATA-FG48                                       
                 MOVE 'SO056'            TO WS-MESSAGE-NO               
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
              ELSE                                                      
                 PERFORM 5540-CHECK-SO-REG-CHG THRU 5540-EXIT           
                 IF EXISTS-DATA-FG49                                    
                    MOVE 'SO056'            TO WS-MESSAGE-NO            
                    MOVE WS-REG-ID          TO WS-REG-ID-NUM            
                                                                        
                    PERFORM 8140-ADD-INTO-RESULT-TABLE                  
                       THRU 8140-EXIT                                   
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2440-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2450-VALIDATE-SO041.                                             
           PERFORM 5545-CHECK-SO-DATA          THRU 5545-EXIT           
           IF EXISTS-DATA-FG50                                          
              MOVE 'SO041'            TO WS-MESSAGE-NO                  
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
           END-IF                                                       
           .                                                            
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * VERIFY THAT THE SERVICE ORDER IS NOT BEING POSTED WITH AN      *        
      * INVALID DATE. TPR 22275 COMPLETED BY MJG 6/12/2000             *        
      ******************************************************************        
                                                                        
       2460-VALIDATE-SO087.                                             
           IF WS-COMPLETED-DATETIME(1:10) = '1900-01-01'                
              MOVE 'SO087'            TO WS-MESSAGE-NO                  
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
           END-IF                                                       
           .                                                            
       2460-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************                                 
      * SERVICE ORDER EXISTS FOR EARLIER DATE *                                 
      *****************************************                                 
                                                                        
       2470-VALIDATE-SO042.                                             
           IF WS-ASSIGNED-DATETIME > SPACES                             
              PERFORM 5550-CHECK-SO-DATA          THRU 5550-EXIT        
           END-IF                                                       
           IF EXISTS-DATA-FG51                                          
              MOVE 'SO042'            TO WS-MESSAGE-NO                  
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
           END-IF                                                       
           .                                                            
       2470-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************                                
      * CANNOT POST UNBLOCK FOR REMOVED METERS *                                
      * TPR 19285                              *                                
      ******************************************                                
                                                                        
       2480-VALIDATE-SO084.                                             
           PERFORM 5555-CHECK-SO-ORDER-INST    THRU 5555-EXIT           
           IF EXISTS-DATA-FG52                                          
              MOVE 'SO084'            TO WS-MESSAGE-NO                  
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
           END-IF                                                       
           .                                                            
       2480-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ********************************************************                  
      * CANNOT POST SET OLD LOCATION UNLESS METER IS REMOVED *                  
      * TPR 19216                                            *                  
      ********************************************************                  
                                                                        
       2490-VALIDATE-SO085.                                             
           PERFORM 5560-CHECK-SO-ORDER-INST    THRU 5560-EXIT           
           IF EXISTS-DATA-FG53                                          
              MOVE 'SO085'            TO WS-MESSAGE-NO                  
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
           END-IF                                                       
           .                                                            
       2490-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * CANNOT POST ORDER THAT CHANGES STATUS OF A REMOVED METER     *          
      * CAD CHANGES LHO   08/10/00                                   *          
      * MODIFIED SELECT FOR CML19550          LHO  04/17/01          *          
      ****************************************************************          
                                                                        
       2500-VALIDATE-SO088.                                             
           PERFORM 5565-CHECK-SO-ORDER-INST    THRU 5565-EXIT           
           IF EXISTS-DATA-FG54                                          
              MOVE 'SO088'            TO WS-MESSAGE-NO                  
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
           END-IF                                                       
           .                                                            
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************                          
      * FOR CC3, CC1 AND CC2 MUST BE COMPLETED FIRST *                          
      ************************************************                          
                                                                        
       2510-VALIDATE-SO043.                                             
           IF WS-ORDER-TYPE-CD = 'CC003'                                
              PERFORM 5570-CHECK-SO-DATA       THRU 5570-EXIT           
              IF EXISTS-DATA-FG55                                       
                 MOVE 'SO043'            TO WS-MESSAGE-NO               
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************                       
      * FOR OFF3, OFF1 AND OFF2 MUST BE COMPLETED FIRST *                       
      ***************************************************                       
                                                                        
       2520-VALIDATE-SO044.                                             
           IF WS-ORDER-TYPE-CD = 'OFF03'                                
              PERFORM 5575-CHECK-SO-DATA       THRU 5575-EXIT           
              IF EXISTS-DATA-FG56                                       
                                                                        
                 MOVE 'SO044'            TO WS-MESSAGE-NO               
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
                                                                        
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      * CAN'T  POST ORDERS WITH GAS METERS WITHOUT A CITY GATE ID *             
      *************************************************************             
                                                                        
       2530-VALIDATE-SO053.                                             
           PERFORM 5580-CHECK-SO-MTR-VAL       THRU 5580-EXIT           
           IF EXISTS-DATA-FG57                                          
              MOVE 'SO053'            TO WS-MESSAGE-NO                  
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
           END-IF                                                       
           .                                                            
       2530-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03206******************************************************************        
A03206* A03206 - IF ATTEMPTING TO POST AN ORDER FOR PSNC JOBBING OR    *        
A03206* MARKETING, REQUIRE MATERIALS TO BE POSTED, NOT JUST SAVED.     *        
A03206******************************************************************        
A03206                                                                  
A03206 2540-VALIDATE-SO407.                                             
A03206                                                                  
A03206     IF WS-COMPANY-NO = '26'                                      
A03206       IF WS-ORDER-TYPE-CD = 'FW022' OR 'FM007'                   
A03206          PERFORM 5780-CHECK-SO-MATL  THRU 5780-EXIT              
A03206          IF WS-EXISTS-SO-MATL = 'Y'                              
A03206                                                                  
A03206            MOVE 'SO407'            TO WS-MESSAGE-NO              
A03206            MOVE WS-REG-ID          TO WS-REG-ID-NUM              
A03206                                                                  
A03206            PERFORM 8140-ADD-INTO-RESULT-TABLE                    
A03206               THRU 8140-EXIT                                     
A03206                                                                  
A03206          END-IF                                                  
A03206       END-IF                                                     
A03206     END-IF.                                                      
A03206                                                                  
A03206 2540-EXIT.                                                       
A03206     EXIT.                                                        
                                                                        
      ******************************************************************        
      *CHECK WHETHER METERS/REGISTERS FOR SO TALLY WITH THOSE INSTALLED*        
      *---- SAVE NUMBER OF EXISTING METERS ----*                       *        
      * IF THE ORDER WAS SET UP AS A SPLIT ORDER, THEN ONLY COUNT THE  *        
      * METERS THAT ARE OF THE UTILITY TYPE OF THE SERVICE ORDER       *        
      ******************************************************************        
                                                                        
       2600-TALLY-MTR-REG.                                              
           IF WS-CUSTCHG-ORD-TYPE-FL = 'S'                              
              PERFORM 5270-GET-UTIL-TYPE       THRU 5270-EXIT           
              PERFORM 5272-COUNT-UTIL-METER    THRU 5272-EXIT           
           ELSE                                                         
              PERFORM 5274-COUNT-METER         THRU 5274-EXIT           
           END-IF                                                       
           PERFORM 8120-INSERT-HOLD-MTR        THRU 8120-EXIT           
           PERFORM 8130-INSERT-HOLD-REG        THRU 8130-EXIT           
                                                                        
A00586     IF WS-ORDER-TYPE-CD = 'FW022' OR 'FM007'                     
A00586         CONTINUE                                                 
A00586     ELSE                                                         
               PERFORM 2610-COMPARE-SO-METERS  THRU 2610-EXIT           
A00586     END-IF                                                       
           .                                                            
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2610-COMPARE-SO-METERS.                                          
                                                                        
           EXEC SQL                                                     
                SELECT COUNT(*)                                         
                  INTO :WS-NO-SO-METER                                  
                  FROM #CSR00109_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*           INTO :WS-NO-SO-METER                                          
MFA-TR*           FROM SESSION.CSR00109_R2                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-NO-SO-METER > 0                                        
              IF WS-NO-SO-METER NOT = WS-NO-METER                       
                 IF WS-ORDER-TYPE-CD = 'FM002'                          
                    MOVE  'SO086'      TO WS-MESSAGE-NO                 
                 ELSE                                                   
                    MOVE  'SO052'      TO WS-MESSAGE-NO                 
                 END-IF                                                 
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
              ELSE                                                      
      *           ----See if the meters are the same---                *        
                 PERFORM 5276-COUNT-COND-METER THRU 5276-EXIT           
                 IF WS-NO-METER-TEMP NOT = WS-NO-METER                  
                    IF WS-ORDER-TYPE-CD = 'FM002'                       
                       MOVE  'SO086'      TO WS-MESSAGE-NO              
                    ELSE                                                
                       MOVE  'SO052'      TO WS-MESSAGE-NO              
                    END-IF                                              
                    MOVE WS-REG-ID          TO WS-REG-ID-NUM            
                                                                        
                    PERFORM 8140-ADD-INTO-RESULT-TABLE                  
                       THRU 8140-EXIT                                   
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-NO-SO-METER = 0 AND WS-NO-METER > 0                    
              IF WS-ORDER-TYPE-CD = 'FM002'                             
                 MOVE  'SO086'      TO WS-MESSAGE-NO                    
              ELSE                                                      
                 MOVE  'SO052'      TO WS-MESSAGE-NO                    
              END-IF                                                    
                                                                        
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
                                                                        
           END-IF                                                       
           .                                                            
       2610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CHECK ACCOUNT STATUS FOR ACCOUNT_NO FOR CC, OC AND DO NOT POST *        
      * IF ACCOUNT STATUS IS NOT 'P' LHO                               *        
      * CML 25537   LHO 10/29/2001                                     *        
      ******************************************************************        
A05020                                                                  
A05020 2620-VALIDATE-SO408.                                             
A05020     PERFORM 5275-VALIDATE-WORK-TYPE THRU 5275-EXIT               
A05020                                                                  
A05020     IF  WS-INVALID-WKTYPE  = 'Y'                                 
A05020                                                                  
A05020         MOVE 'SO408'            TO WS-MESSAGE-NO                 
A05020         MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
A05020                                                                  
A05020         PERFORM 8140-ADD-INTO-RESULT-TABLE                       
A05020            THRU 8140-EXIT                                        
A05020                                                                  
A05020     END-IF                                                       
A05020     .                                                            
A05020 2620-EXIT.                                                       
A05020     EXIT.                                                        
A05020                                                                  
      *************************************************                         
      * CHECK FOR METER READINGS, DIALS AND CONSTANTS *                         
      *************************************************                         
                                                                        
       2700-CHK-MTR-REG-CHANGES.                                        
                                                                        
           PERFORM 7100-PROCESS-MTR-DATA       THRU 7100-EXIT           
           PERFORM 7200-PROCESS-REG-DATA       THRU 7200-EXIT           
           PERFORM 7300-PROCESS-NEW-MTR-DATA   THRU 7300-EXIT           
           PERFORM 7400-PROCESS-NEW-REG-DATA   THRU 7400-EXIT           
                                                                        
           .                                                            
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2800-VALIDATE-GIS-POINT-ID.                                      
                                                                        
      *    EXEC SQL                                                             
      *        CALL CSR00583(:WS-GIS-POINT-ID)                                  
      *    END-EXEC                                                             
      *                                                                         
      *    EXEC SQL                                                             
      *        GET DIAGNOSTICS  :WS-RET-STATUS  = RETURN_STATUS                 
      *    END-EXEC                                                             
                                                                        
           PERFORM 2805-CHECK-GIS-POINT-ID THRU 2805-EXIT.              
                                                                        
           IF WS-RET-STATUS  NOT  = 0                                   
              MOVE 'SO068'            TO WS-MESSAGE-NO                  
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
           END-IF                                                       
           .                                                            
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2805-CHECK-GIS-POINT-ID.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) POINT_ID                                          
               INTO :WS-POINT-ID-CHECK                                  
C33743         FROM CSS_PIM_POINT WITH(READUNCOMMITTED)                         
               WHERE POINT_ID = :WS-GIS-POINT-ID                        
                                           
A03206                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT POINT_ID                                                  
MFA-TR*        INTO :WS-POINT-ID-CHECK                                          
MFA-TR*        FROM CSS_PIM_POINT                                               
MFA-TR*        WHERE POINT_ID = :WS-GIS-POINT-ID                                
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 2805                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 0  TO WS-RET-STATUS                                  
           ELSE                                                         
              MOVE -1 TO WS-RET-STATUS                                  
           END-IF.                                                      
                                                                        
       2805-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2810-VALIDATE-POINT-ID.                                          
REARCH*****************************************************************         
REARCH*       MERGE CSR00584 LOGIC INTO CSR00109                      *         
REARCH*****************************************************************         
REARCH*    EXEC SQL                                                             
REARCH*        CALL CSR00584(:WS-POINT-ID, :WS-ORDER-NO)                        
REARCH*    END-EXEC                                                             
                                                                        
REARCH*    EXEC SQL                                                             
REARCH*        GET DIAGNOSTICS  :WS-RET-STATUS  = RETURN_STATUS                 
REARCH*    END-EXEC                                                             
                                                                        
REARCH     MOVE WS-POINT-ID(1:3) TO WS-GIS-LOC-OFFICE.                  
REARCH     MOVE WS-POINT-ID(4:7) TO WS-TAG-NM.                          
REARCH     MOVE 0 TO WS-GIS-POINT-ID-SNEPOINT                           
REARCH               WS-SNEPOINT-ROWCOUNT                               
                                                                        
           EXEC SQL                                                     
REARCH          SELECT COUNT(*)                                         
REARCH            INTO :WS-SNEPOINT-ROWCOUNT                            
REARCH            FROM (SELECT POINT_ID                                 
C33743            FROM CSS_PIM_POINT                                    
REARCH           WHERE TAG_NM = :WS-TAG-NM                              
C33743             AND AREA_ID = :WS-GIS-LOC-OFFICE                     
A04307             AND INACTIVE_TS IS NULL                              
REARCH                 )TEMP_TABLE                                      
                                                            
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*           INTO :WS-SNEPOINT-ROWCOUNT                                    
MFA-TR*           FROM (SELECT POINT_ID                                         
MFA-TR*           FROM CSS_PIM_POINT                                            
MFA-TR*          WHERE TAG_NM = :WS-TAG-NM                                      
MFA-TR*            AND AREA_ID = :WS-GIS-LOC-OFFICE                             
MFA-TR*            AND INACTIVE_TS IS NULL                                      
MFA-TR*                )TEMP_TABLE                                              
MFA-TR*          QUERYNO 2810                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
REARCH     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
REARCH     EVALUATE WS-SNEPOINT-ROWCOUNT                                
REARCH        WHEN 0                                                    
REARCH             MOVE 100           TO WS-RET-STATUS                  
REARCH        WHEN 1                                                    
REARCH             MOVE 0             TO WS-RET-STATUS                  
REARCH        WHEN OTHER                                                
REARCH             MOVE -2            TO WS-RET-STATUS                  
REARCH     END-EVALUATE.                                                
                                                                        
REARCH     EVALUATE WS-ACTIVE-RETURN-CODE                               
REARCH        WHEN SUCCESSFUL-CALL                                      
REARCH             CONTINUE                                             
REARCH        WHEN NOT-FOUND                                            
REARCH             CONTINUE                                             
REARCH        WHEN OTHER                                                
REARCH             MOVE 100           TO WS-RET-STATUS                  
REARCH     END-EVALUATE.                                                
                                                                        
REARCH     IF WS-SNEPOINT-ROWCOUNT = 1 THEN                             
REARCH        PERFORM 2910-UPDATE-POINT-ID THRU 2910-EXIT               
REARCH     END-IF                                                       
                                                                        
           IF WS-RET-STATUS NOT = 0                                     
              IF WS-RET-STATUS = -1                                     
                 MOVE 'SO090'         TO WS-MESSAGE-NO                  
              ELSE IF WS-RET-STATUS = -2                                
                      MOVE 'SO089'    TO WS-MESSAGE-NO                  
                   ELSE                                                 
                      MOVE 'SO068'    TO WS-MESSAGE-NO                  
                   END-IF                                               
              END-IF                                                    
                                                                        
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
                                                                        
           END-IF                                                       
           .                                                            
       2810-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH 2910-UPDATE-POINT-ID.                                            
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH          SELECT POINT_ID                                         
REARCH            INTO :WS-GIS-POINT-ID-SNEPOINT                        
C33743            FROM CSS_PIM_POINT                                    
REARCH           WHERE TAG_NM = :WS-TAG-NM                              
C33743             AND AREA_ID =  :WS-GIS-LOC-OFFICE                    
A04307             AND INACTIVE_TS IS NULL                              
A03206                                                     
REARCH     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT POINT_ID                                                 
MFA-TR*           INTO :WS-GIS-POINT-ID-SNEPOINT                                
MFA-TR*           FROM CSS_PIM_POINT                                            
MFA-TR*          WHERE TAG_NM = :WS-TAG-NM                                      
MFA-TR*            AND AREA_ID =  :WS-GIS-LOC-OFFICE                            
MFA-TR*            AND INACTIVE_TS IS NULL                                      
MFA-TR*          QUERYNO 29101                                                  
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
REARCH     EVALUATE WS-ACTIVE-RETURN-CODE                               
REARCH        WHEN SUCCESSFUL-CALL                                      
REARCH             CONTINUE                                             
REARCH        WHEN OTHER                                                
REARCH             MOVE 100           TO WS-RET-STATUS                  
REARCH     END-EVALUATE.                                                
                                                                        
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL THEN             
REARCH         EXEC SQL                                                 
REARCH          UPDATE CSS_SO_METER                                     
REARCH             SET GIS_POINT_ID  = :WS-GIS-POINT-ID-SNEPOINT        
REARCH           WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
REARCH             AND POINT_ID      = :WS-POINT-ID                     
                                                           
REARCH         END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*        EXEC SQL                                                         
MFA-TR*         UPDATE CSS_SO_METER                                             
MFA-TR*            SET GIS_POINT_ID  = :WS-GIS-POINT-ID-SNEPOINT                
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*            AND POINT_ID      = :WS-POINT-ID                             
MFA-TR*          QUERYNO 29102                                                  
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
REARCH         MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE      
                                                                        
REARCH         EVALUATE WS-ACTIVE-RETURN-CODE                           
REARCH          WHEN SUCCESSFUL-CALL                                    
REARCH             CONTINUE                                             
REARCH          WHEN OTHER                                              
REARCH             MOVE -1 TO WS-RET-STATUS                             
REARCH         END-EVALUATE                                             
                                                                        
REARCH      END-IF.                                                     
REARCH 2910-EXIT.                                                       
REARCH     EXIT.                                                        
                                                                        
C33886******************************************************************        
C33886* 2950-CHK-MTR-ATT-REQMTS.                                                
C33886******************************************************************        
C33886*                                                                         
C33886 2950-CHK-MTR-ATT-REQMTS.                                         
C33886*                                                                         
C33886     PERFORM 7600-PROCESS-AMR-MTR   THRU  7600-EXIT               
C33886     .                                                            
C33886 2950-EXIT.                                                       
C33886     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5100-GET-SO-DATA.                                              *        
      ******************************************************************        
      *                                                                         
       5100-GET-SO-DATA.                                                
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) SO.ACCOUNT_NO_PRIOR,
              SO.ACCOUNT_NO,
              SO.PREMISE_NO,
              SO.ORDER_TYPE_CD,
              OT.ORDER_GROUP_CD,
              SO.SERV_ORDER_STATUS,
              SO.CODES_DATA_PRESENT,
              SO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              SO.CUSTCHG_ORD_TYP_FL,
              SO.BACK_DATED_IND,
              SO.WORK_COMPLETED_IND,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              REPLACE(REPLACE(CONVERT(CHAR(26), SO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              SO.COMPANY_NO                                    
                  INTO :VO-ACCOUNT-NO-PRIOR,                            
                       :VO-ACCOUNT-NO,                                  
                       :VO-PREMISE-NO,                                  
                       :VO-ORDER-TYPE-CD,                               
                       :C2-ORDER-GROUP-CD,                              
                       :VO-SERV-ORDER-STATUS,                           
                       :VO-CODES-DATA-PRESENT,                          
                       :VO-ORDER-STATE-CD,                              
                       :VO-COMPLETED-DATETIME :WS-NULL-IND-1,            
                       :VO-CUSTCHG-ORD-TYP-FL,                          
                       :VO-BACK-DATED-IND,                              
                       :VO-WORK-COMPLETED-IND,                          
                       :VO-DATE-RECVED :WS-NULL-IND-2,                   
                       :VO-ASSIGNED-DATETIME :WS-NULL-IND-3,             
                       :VO-COMPANY-NO                                   
                  FROM CSS_SO_DATA     SO WITH(READUNCOMMITTED),                
                       CSS_ORDER_TYPE  OT WITH(READUNCOMMITTED)                 
                 WHERE SO.SERV_ORDER_NO = :WS-ORDER-NO                  
                   AND SO.ORDER_TYPE_CD = OT.ORDER_TYPE_CD              
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SO.ACCOUNT_NO_PRIOR,                                     
MFA-TR*                SO.ACCOUNT_NO,                                           
MFA-TR*                SO.PREMISE_NO,                                           
MFA-TR*                SO.ORDER_TYPE_CD,                                        
MFA-TR*                OT.ORDER_GROUP_CD,                                       
MFA-TR*                SO.SERV_ORDER_STATUS ,                                   
MFA-TR*                SO.CODES_DATA_PRESENT,                                   
MFA-TR*                SO.ORDER_STATE_CD,                                       
MFA-TR*                SO.COMPLETED_DATETIME,                                   
MFA-TR*                SO.CUSTCHG_ORD_TYP_FL,                                   
MFA-TR*                SO.BACK_DATED_IND,                                       
MFA-TR*                SO.WORK_COMPLETED_IND,                                   
MFA-TR*                SO.DATE_RECVED,                                          
MFA-TR*                SO.ASSIGNED_DATETIME,                                    
MFA-TR*                SO.COMPANY_NO                                            
MFA-TR*           INTO :VO-ACCOUNT-NO-PRIOR,                                    
MFA-TR*                :VO-ACCOUNT-NO,                                          
MFA-TR*                :VO-PREMISE-NO,                                          
MFA-TR*                :VO-ORDER-TYPE-CD,                                       
MFA-TR*                :C2-ORDER-GROUP-CD,                                      
MFA-TR*                :VO-SERV-ORDER-STATUS,                                   
MFA-TR*                :VO-CODES-DATA-PRESENT,                                  
MFA-TR*                :VO-ORDER-STATE-CD,                                      
MFA-TR*                :VO-COMPLETED-DATETIME:WS-NULL-IND-1,                    
MFA-TR*                :VO-CUSTCHG-ORD-TYP-FL,                                  
MFA-TR*                :VO-BACK-DATED-IND,                                      
MFA-TR*                :VO-WORK-COMPLETED-IND,                                  
MFA-TR*                :VO-DATE-RECVED:WS-NULL-IND-2,                           
MFA-TR*                :VO-ASSIGNED-DATETIME:WS-NULL-IND-3,                     
MFA-TR*                :VO-COMPANY-NO                                           
MFA-TR*           FROM CSS_SO_DATA     SO,                                      
MFA-TR*                CSS_ORDER_TYPE  OT                                       
MFA-TR*          WHERE SO.SERV_ORDER_NO = :WS-ORDER-NO                          
MFA-TR*            AND SO.ORDER_TYPE_CD = OT.ORDER_TYPE_CD                      
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5100                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'CSS_ORDER_TYPE'          TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 8110-DELETE-SO-MTR-VAL THRU 8110-EXIT             
              MOVE 100                 TO WS-ACTIVE-RETURN-CODE         
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5110-MOVE-SO-DATA.                                               
           MOVE VO-ACCOUNT-NO-PRIOR     TO WS-M-ACCOUNT-NO-PRIOR        
           MOVE VO-ACCOUNT-NO           TO WS-M-ACCOUNT-NO              
           MOVE VO-PREMISE-NO           TO WS-M-PREMISE-NO              
           MOVE VO-ORDER-TYPE-CD        TO WS-ORDER-TYPE-CD             
           MOVE C2-ORDER-GROUP-CD       TO WS-ORDER-GROUP-CD            
           MOVE VO-SERV-ORDER-STATUS    TO WS-ORDER-STATUS              
           MOVE VO-CODES-DATA-PRESENT   TO WS-CODES-SO-DATA-PRESENT     
           MOVE VO-ORDER-STATE-CD       TO WS-ORDER-STATE-CD            
           MOVE VO-COMPLETED-DATETIME   TO WS-COMPLETED-DATETIME        
           MOVE VO-CUSTCHG-ORD-TYP-FL   TO WS-CUSTCHG-ORD-TYPE-FL       
           MOVE VO-BACK-DATED-IND       TO WS-BACK-DATED-IND            
           MOVE VO-WORK-COMPLETED-IND   TO WS-NON-PRODUCTIVE-IND        
           MOVE VO-DATE-RECVED          TO WS-DATE-RECVED               
           MOVE VO-ASSIGNED-DATETIME    TO WS-ASSIGNED-DATETIME         
           MOVE VO-COMPANY-NO           TO WS-COMPANY-NO                
C33886     MOVE ZERO                    TO WS-AMR-READ-VALUE-IS         
C33886     MOVE ZERO                    TO WS-AMR-IDX-READ              
      *                                                                         
           .                                                            
       5110-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5200-SET-CD-ACT-STATUS-NEW.                                    *        
      ******************************************************************        
      *                                                                         
       5200-SET-CD-ACT-STATUS-NEW.                                      
      *                                                                         
           EXEC SQL                                                     
                SELECT CODE_ACCT_STAT                                   
                  INTO :WS-CODE-ACCOUNT-STATUS-NEW                      
                  FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                        
                 WHERE ACCOUNT_NO = :WS-M-ACCOUNT-NO                    
                                                                 
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CODE_ACCT_STAT                                           
MFA-TR*           INTO :WS-CODE-ACCOUNT-STATUS-NEW                              
MFA-TR*           FROM CSS_ACCOUNT                                              
MFA-TR*          WHERE ACCOUNT_NO = :WS-M-ACCOUNT-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 5200                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE 'A'           TO WS-CODE-ACCOUNT-STATUS-NEW     
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE '5200'                    TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_ACCOUNT'             TO TABLE-1            
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1    
                   MOVE WS-M-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1  
                   PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       5200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5205-GET-CD-ACT-STATUS.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) CODE_ACCT_STAT                                   
                  INTO :WS-CODE-ACCOUNT-STATUS                          
                  FROM CSS_SO_MTR_VAL WITH(READUNCOMMITTED)                     
                  WHERE SERV_ORDER_NO   = :WS-ORDER-NO                  
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CODE_ACCT_STAT                                           
MFA-TR*           INTO :WS-CODE-ACCOUNT-STATUS                                  
MFA-TR*           FROM CSS_SO_MTR_VAL                                           
MFA-TR*           WHERE SERV_ORDER_NO   = :WS-ORDER-NO                          
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5205                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5205'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_VAL'          TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
           .                                                            
       5205-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5210-GET-SERVICE-ORDER.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) SERV_ORDER_NO                                    
                  INTO :WS-POSTED-SET-ORDER-NO                          
                  FROM CSS_SO_DATA WITH(READUNCOMMITTED)                        
                 WHERE PREMISE_NO     = :WS-M-PREMISE-NO                
                   AND ORDER_TYPE_CD  = 'FM002'                         
                   AND ORDER_STATE_CD = 'Z'                             
                  ORDER BY COMPLETED_DATETIME                           
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SERV_ORDER_NO                                            
MFA-TR*           INTO :WS-POSTED-SET-ORDER-NO                                  
MFA-TR*           FROM CSS_SO_DATA                                              
MFA-TR*          WHERE PREMISE_NO     = :WS-M-PREMISE-NO                        
MFA-TR*            AND ORDER_TYPE_CD  = 'FM002'                                 
MFA-TR*            AND ORDER_STATE_CD = 'Z'                                     
MFA-TR*           ORDER BY COMPLETED_DATETIME                                   
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 5210                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5210'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-M-PREMISE-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5210-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5215-UPDATE-POINT-ID.                                            
      *                                                                         
           EXEC SQL                                                     
                UPDATE MT                                   
                   SET MT.GIS_POINT_ID =                                
                       (SELECT DISTINCT MC.GIS_POINT_ID                 
                          FROM CSS_SO_MTR_CHG MC                        
                        WHERE MT.SERV_ORDER_NO = :WS-ORDER-NO           
                          AND MC.SERV_ORDER_NO = :WS-ORDER-NO           
                          AND MT.CODE_UTIL_TYPE = 'E'                   
                          AND MC.CODE_UTIL_TYPE = 'E'                   
                          AND MC.SERV_ORDER_NO = MT.SERV_ORDER_NO       
                          AND MC.CODE_UTIL_TYPE = MT.CODE_UTIL_TYPE     
                          AND MC.IC_NO = MT.IC_NO                       
                          AND MC.MTR_REF_NO = MT.MTR_REF_NO)            
                FROM CSS_SO_METER MT
C37209                WHERE MT.SERV_ORDER_NO = :WS-ORDER-NO             
C37209                      AND MT.CODE_UTIL_TYPE = 'E'                 
C37209                      AND EXISTS                                  
                     (SELECT 1                                          
                         FROM CSS_SO_MTR_CHG MC                         
                       WHERE MT.SERV_ORDER_NO = :WS-ORDER-NO            
                         AND MC.SERV_ORDER_NO = :WS-ORDER-NO            
                         AND MT.CODE_UTIL_TYPE = 'E'                    
                         AND MC.CODE_UTIL_TYPE = 'E'                    
                         AND MC.SERV_ORDER_NO = MT.SERV_ORDER_NO        
                         AND MC.CODE_UTIL_TYPE = MT.CODE_UTIL_TYPE      
                         AND MC.IC_NO = MT.IC_NO                        
                         AND MC.MTR_REF_NO = MT.MTR_REF_NO)             
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_SO_METER MT                                          
MFA-TR*            SET MT.GIS_POINT_ID =                                        
MFA-TR*                (SELECT DISTINCT MC.GIS_POINT_ID                         
MFA-TR*                   FROM CSS_SO_MTR_CHG MC                                
MFA-TR*                 WHERE MT.SERV_ORDER_NO = :WS-ORDER-NO                   
MFA-TR*                   AND MC.SERV_ORDER_NO = :WS-ORDER-NO                   
MFA-TR*                   AND MT.CODE_UTIL_TYPE = 'E'                           
MFA-TR*                   AND MC.CODE_UTIL_TYPE = 'E'                           
MFA-TR*                   AND MC.SERV_ORDER_NO = MT.SERV_ORDER_NO               
MFA-TR*                   AND MC.CODE_UTIL_TYPE = MT.CODE_UTIL_TYPE             
MFA-TR*                   AND MC.IC_NO = MT.IC_NO                               
MFA-TR*                   AND MC.MTR_REF_NO = MT.MTR_REF_NO)                    
MFA-TR*               WHERE MT.SERV_ORDER_NO = :WS-ORDER-NO                     
MFA-TR*                     AND MT.CODE_UTIL_TYPE = 'E'                         
MFA-TR*                     AND EXISTS                                          
MFA-TR*              (SELECT 1                                                  
MFA-TR*                  FROM CSS_SO_MTR_CHG MC                                 
MFA-TR*                WHERE MT.SERV_ORDER_NO = :WS-ORDER-NO                    
MFA-TR*                  AND MC.SERV_ORDER_NO = :WS-ORDER-NO                    
MFA-TR*                  AND MT.CODE_UTIL_TYPE = 'E'                            
MFA-TR*                  AND MC.CODE_UTIL_TYPE = 'E'                            
MFA-TR*                  AND MC.SERV_ORDER_NO = MT.SERV_ORDER_NO                
MFA-TR*                  AND MC.CODE_UTIL_TYPE = MT.CODE_UTIL_TYPE              
MFA-TR*                  AND MC.IC_NO = MT.IC_NO                                
MFA-TR*                  AND MC.MTR_REF_NO = MT.MTR_REF_NO)                     
MFA-TR*                QUERYNO 5215                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR               
                                      NOT-FOUND OR WS-811               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5215'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5215-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5220-GET-GIS-POINT-ID.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) MT.GIS_POINT_ID                                 
                  INTO :WS-GIS-POINT-ID                                 
                  FROM CSS_SO_METER      MT WITH(READUNCOMMITTED),              
                       CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                 WHERE MT.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND MT.SERV_ORDER_NO  = OI.SERV_ORDER_NO             
                   AND MT.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE            
                   AND MT.CODE_UTIL_TYPE = 'E'                          
                   AND OI.CODE_UTIL_TYPE = 'E'                          
                   AND MT.IC_NO          = OI.IC_NO                     
                   AND MT.MTR_REF_NO     = OI.MTR_REF_NO                
                   AND OI.WORK_TYPE_CD > ''                             
                   AND MT.GIS_POINT_ID > 0                              
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  MT.GIS_POINT_ID                                         
MFA-TR*           INTO :WS-GIS-POINT-ID                                         
MFA-TR*           FROM CSS_SO_METER      MT,                                    
MFA-TR*                CSS_SO_ORDER_INST OI                                     
MFA-TR*          WHERE MT.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND MT.SERV_ORDER_NO  = OI.SERV_ORDER_NO                     
MFA-TR*            AND MT.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE                    
MFA-TR*            AND MT.CODE_UTIL_TYPE = 'E'                                  
MFA-TR*            AND OI.CODE_UTIL_TYPE = 'E'                                  
MFA-TR*            AND MT.IC_NO          = OI.IC_NO                             
MFA-TR*            AND MT.MTR_REF_NO     = OI.MTR_REF_NO                        
MFA-TR*            AND OI.WORK_TYPE_CD > ''                                     
MFA-TR*            AND MT.GIS_POINT_ID > 0                                      
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5220                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5220'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'CSS_SO_ORDER_INST'       TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5220-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5222-GET-POINT-ID.                                               
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) MT.POINT_ID                                     
                  INTO :WS-POINT-ID                                     
                  FROM CSS_SO_METER      MT WITH(READUNCOMMITTED),              
                       CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                 WHERE MT.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND MT.SERV_ORDER_NO  = OI.SERV_ORDER_NO             
                   AND MT.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE            
                   AND MT.CODE_UTIL_TYPE = 'E'                          
                   AND OI.CODE_UTIL_TYPE = 'E'                          
                   AND MT.IC_NO          = OI.IC_NO                     
                   AND MT.MTR_REF_NO     = OI.MTR_REF_NO                
                   AND OI.WORK_TYPE_CD > ''                             
                   AND MT.POINT_ID > ''                                 
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  MT.POINT_ID                                             
MFA-TR*           INTO :WS-POINT-ID                                             
MFA-TR*           FROM CSS_SO_METER      MT,                                    
MFA-TR*                CSS_SO_ORDER_INST OI                                     
MFA-TR*          WHERE MT.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND MT.SERV_ORDER_NO  = OI.SERV_ORDER_NO                     
MFA-TR*            AND MT.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE                    
MFA-TR*            AND MT.CODE_UTIL_TYPE = 'E'                                  
MFA-TR*            AND OI.CODE_UTIL_TYPE = 'E'                                  
MFA-TR*            AND MT.IC_NO          = OI.IC_NO                             
MFA-TR*            AND MT.MTR_REF_NO     = OI.MTR_REF_NO                        
MFA-TR*            AND OI.WORK_TYPE_CD > ''                                     
MFA-TR*            AND MT.POINT_ID > ''                                         
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5222                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5222'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'CSS_SO_ORDER_INST'       TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5222-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5225-GET-DATE-TIME.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME                                
                  INTO :VO-ASSIGNED-DATETIME :WS-NULL-IND-4              
                  FROM CSS_SO_DATA WITH(READUNCOMMITTED)                        
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
C35434                                     
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ASSIGNED_DATETIME                                        
MFA-TR*           INTO :VO-ASSIGNED-DATETIME:WS-NULL-IND-4                      
MFA-TR*           FROM CSS_SO_DATA                                              
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5225                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-NULL-IND-4 = -1                                        
              MOVE SPACES                TO WS-ASSIGNED-DATETIME        
           ELSE                                                         
              MOVE VO-ASSIGNED-DATETIME  TO WS-ASSIGNED-DATETIME        
           END-IF                                                       
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5225'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 8110-DELETE-SO-MTR-VAL THRU 8110-EXIT             
              MOVE 100                       TO WS-ACTIVE-RETURN-CODE   
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5225-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5230-GET-ACT-BILL-STATUS.                                        
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) CODE_BILL_STATUS,
              CODE_ACCT_STAT                                   
                  INTO :WS-CODE-BILL-STATUS                             
                      ,:WS-CODE-ACCOUNT-STATUS                          
                  FROM CSS_SO_MTR_VAL WITH(READUNCOMMITTED)                     
                 WHERE SERV_ORDER_NO   = :WS-ORDER-NO                   
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CODE_BILL_STATUS                                         
MFA-TR*               ,CODE_ACCT_STAT                                           
MFA-TR*           INTO :WS-CODE-BILL-STATUS                                     
MFA-TR*               ,:WS-CODE-ACCOUNT-STATUS                                  
MFA-TR*           FROM CSS_SO_MTR_VAL                                           
MFA-TR*          WHERE SERV_ORDER_NO   = :WS-ORDER-NO                           
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5230                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5230'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_VAL'          TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5230-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5235-CHECK-DEFAULT-CHARGES.                                      
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-CHARGES-INDICATOR                            
                  FROM CSS_SO_CHARGES WITH(READUNCOMMITTED)                     
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
                   AND (MATERIAL_CHRG   > 0                             
                    OR  OTHER_CHRG      > 0                             
                    OR  CALC_LABOR_CHRG > 0                             
                    OR  STD_LABOR_CHRG  > 0)                            
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-CHARGES-INDICATOR                                    
MFA-TR*           FROM CSS_SO_CHARGES                                           
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*            AND (MATERIAL_CHRG   > 0                                     
MFA-TR*             OR  OTHER_CHRG      > 0                                     
MFA-TR*             OR  CALC_LABOR_CHRG > 0                                     
MFA-TR*             OR  STD_LABOR_CHRG  > 0)                                    
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5235                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5235'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_CHARGES'          TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5235-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5240-CHECK-STANDARD-CHARGES.                                     
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-CHARGES-INDICATOR                            
                  FROM CSS_SO_STD_LABOR WITH(READUNCOMMITTED)                   
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-CHARGES-INDICATOR                                    
MFA-TR*           FROM CSS_SO_STD_LABOR                                         
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5240                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR  NOT-FOUND    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5240'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_STD_LABOR'        TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5240-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5245-CHECK-MATERIAL-CHARGES.                                     
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-CHARGES-INDICATOR                            
                  FROM CSS_SO_MATERIALS WITH(READUNCOMMITTED)                   
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-CHARGES-INDICATOR                                    
MFA-TR*           FROM CSS_SO_MATERIALS                                         
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5245                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5245'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MATERIALS'        TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5245-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5250-GET-MTRNO-REGID.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) METER_NO,
              REG_ID_NO                                        
                  INTO :WS-METER-NO,                                    
                       :WS-REG-ID                                       
                  FROM CSS_SO_MTR_CHG WITH(READUNCOMMITTED)                     
                  WHERE SERV_ORDER_NO = :WS-ORDER-NO                    
                    AND CODE_MTR_STATUS_IS = 'K'                        
                    AND ABS(READ_VALUE_IS - LAST_READ_VALUE) > 4        
                    AND MTR_READ_SOURCE_CD <> 'M'                       
                    AND MTR_READ_SOURCE_CD <> 'S'                       
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT METER_NO,                                                
MFA-TR*                REG_ID_NO                                                
MFA-TR*           INTO :WS-METER-NO,                                            
MFA-TR*                :WS-REG-ID                                               
MFA-TR*           FROM CSS_SO_MTR_CHG                                           
MFA-TR*           WHERE SERV_ORDER_NO = :WS-ORDER-NO                            
MFA-TR*             AND CODE_MTR_STATUS_IS = 'K'                                
MFA-TR*             AND ABS(READ_VALUE_IS - LAST_READ_VALUE) > 4                
MFA-TR*             AND MTR_READ_SOURCE_CD <> 'M'                               
MFA-TR*             AND MTR_READ_SOURCE_CD <> 'S'                               
MFA-TR*           FETCH FIRST 1 ROW ONLY WITH UR                                
MFA-TR*           QUERYNO 5250                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5250-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5255-GET-MTRNO-REGID.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) METER_NO,
              REG_ID_NO                                        
                  INTO :WS-METER-NO,                                    
                       :WS-REG-ID                                       
                  FROM CSS_SO_REG_CHG WITH(READUNCOMMITTED)                     
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
                   AND CODE_REG_STATUS_IS = 'K'                         
                   AND ABS(READ_VALUE_IS - LAST_READ_VALUE) > 4         
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT METER_NO,                                                
MFA-TR*                REG_ID_NO                                                
MFA-TR*           INTO :WS-METER-NO,                                            
MFA-TR*                :WS-REG-ID                                               
MFA-TR*           FROM CSS_SO_REG_CHG                                           
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*            AND CODE_REG_STATUS_IS = 'K'                                 
MFA-TR*            AND ABS(READ_VALUE_IS - LAST_READ_VALUE) > 4                 
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5255                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5255'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_REG_CHG'          TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5255-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5260-GET-MTRNO-REGID.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) MC.METER_NO,
              MC.REG_ID_NO                                     
                  INTO :WS-METER-NO,                                    
                       :WS-REG-ID                                       
                  FROM CSS_SO_MTR_CHG    MC WITH(READUNCOMMITTED),              
                       CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                 WHERE MC.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND MC.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE            
                   AND MC.IC_NO          = OI.IC_NO                     
                   AND MC.MTR_REF_NO     = OI.MTR_REF_NO                
                   AND OI.WORK_TYPE_CD   > ''                           
                   AND MC.READ_VALUE_IS - MC.LAST_READ_VALUE < 0        
                   AND MC.MTR_READ_SOURCE_CD <> 'M'                     
                   AND MC.MTR_READ_SOURCE_CD <> 'S'                     
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MC.METER_NO,                                             
MFA-TR*                MC.REG_ID_NO                                             
MFA-TR*           INTO :WS-METER-NO,                                            
MFA-TR*                :WS-REG-ID                                               
MFA-TR*           FROM CSS_SO_MTR_CHG    MC,                                    
MFA-TR*                CSS_SO_ORDER_INST OI                                     
MFA-TR*          WHERE MC.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND MC.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE                    
MFA-TR*            AND MC.IC_NO          = OI.IC_NO                             
MFA-TR*            AND MC.MTR_REF_NO     = OI.MTR_REF_NO                        
MFA-TR*            AND OI.WORK_TYPE_CD   > ''                                   
MFA-TR*            AND MC.READ_VALUE_IS - MC.LAST_READ_VALUE < 0                
MFA-TR*            AND MC.MTR_READ_SOURCE_CD <> 'M'                             
MFA-TR*            AND MC.MTR_READ_SOURCE_CD <> 'S'                             
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5260                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5260'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'CSS_SO_ORDER_INST'       TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5260-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5265-GET-MTRNO-REGID.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) RC.METER_NO,
              RC.REG_ID_NO                                     
                  INTO :WS-METER-NO,                                    
                       :WS-REG-ID                                       
                  FROM CSS_SO_REG_CHG    RC WITH(READUNCOMMITTED),              
                       CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                  WHERE RC.SERV_ORDER_NO  = :WS-ORDER-NO                
                    AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                
                    AND RC.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE           
                    AND RC.IC_NO          = OI.IC_NO                    
                    AND RC.MTR_REF_NO     = OI.MTR_REF_NO               
                    AND OI.WORK_TYPE_CD   > ''                          
                    AND (RC.READ_VALUE_IS - RC.LAST_READ_VALUE) < 0     
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT RC.METER_NO,                                             
MFA-TR*                RC.REG_ID_NO                                             
MFA-TR*           INTO :WS-METER-NO,                                            
MFA-TR*                :WS-REG-ID                                               
MFA-TR*           FROM CSS_SO_REG_CHG    RC,                                    
MFA-TR*                CSS_SO_ORDER_INST OI                                     
MFA-TR*           WHERE RC.SERV_ORDER_NO  = :WS-ORDER-NO                        
MFA-TR*             AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                        
MFA-TR*             AND RC.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE                   
MFA-TR*             AND RC.IC_NO          = OI.IC_NO                            
MFA-TR*             AND RC.MTR_REF_NO     = OI.MTR_REF_NO                       
MFA-TR*             AND OI.WORK_TYPE_CD   > ''                                  
MFA-TR*             AND (RC.READ_VALUE_IS - RC.LAST_READ_VALUE) < 0             
MFA-TR*           FETCH FIRST 1 ROW ONLY WITH UR                                
MFA-TR*           QUERYNO 5265                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5265'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_REG_CHG'          TO TABLE-1                 
              MOVE 'CSS_SO_ORDER_INST'       TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5265-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5270-GET-UTIL-TYPE.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) CODE_UTIL_TYPE                                   
                  INTO :WS-SERV-ORDER-UTIL-TYPE                         
                  FROM CSS_SO_MTR_CHG WITH(READUNCOMMITTED)                     
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CODE_UTIL_TYPE                                           
MFA-TR*           INTO :WS-SERV-ORDER-UTIL-TYPE                                 
MFA-TR*           FROM CSS_SO_MTR_CHG                                           
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5270                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES TO WS-SERV-ORDER-UTIL-TYPE                 
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5270'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 8110-DELETE-SO-MTR-VAL THRU 8110-EXIT             
              MOVE  -1                       TO WS-ACTIVE-RETURN-CODE   
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5270-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5272-COUNT-UTIL-METER.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT COUNT(*)                                         
                  INTO :WS-NO-METER                                     
                  FROM CSS_SO_MTR_VAL                                   
                 WHERE LTRIM(METER_NO) IS NOT NULL                      
                   AND CODE_UTIL_TYPE = :WS-SERV-ORDER-UTIL-TYPE        
                   AND SERV_ORDER_NO  = :WS-ORDER-NO                    
                   AND IC_NO <> 0                                       
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*           INTO :WS-NO-METER                                             
MFA-TR*           FROM CSS_SO_MTR_VAL                                           
MFA-TR*          WHERE LTRIM(METER_NO) IS NOT NULL                              
MFA-TR*            AND CODE_UTIL_TYPE = :WS-SERV-ORDER-UTIL-TYPE                
MFA-TR*            AND SERV_ORDER_NO  = :WS-ORDER-NO                            
MFA-TR*            AND IC_NO <> 0                                               
MFA-TR*          QUERYNO 5272                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5272'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_VAL'          TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE WS-SERV-ORDER-UTIL-TYPE   TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5272-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5274-COUNT-METER.                                                
      *                                                                         
           EXEC SQL                                                     
                SELECT COUNT(*)                                         
                  INTO :WS-NO-METER                                     
                  FROM CSS_SO_MTR_VAL                                   
                 WHERE LTRIM(METER_NO) IS NOT NULL                      
                   AND SERV_ORDER_NO   = :WS-ORDER-NO                   
                   AND IC_NO <> 0                                       
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*           INTO :WS-NO-METER                                             
MFA-TR*           FROM CSS_SO_MTR_VAL                                           
MFA-TR*          WHERE LTRIM(METER_NO) IS NOT NULL                              
MFA-TR*            AND SERV_ORDER_NO   = :WS-ORDER-NO                           
MFA-TR*            AND IC_NO <> 0                                               
MFA-TR*          QUERYNO 5274                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5274'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_VAL'          TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5274-EXIT.                                                       
            EXIT.                                                       
A05020                                                                  
A05020 5275-VALIDATE-WORK-TYPE.                                         
A05020*                                                                         
A05020     EXEC SQL                                                     
A05020          SELECT TOP(1) 'Y'                                              
A05020            INTO :WS-INVALID-WKTYPE                               
A05020            FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)               
A05020           WHERE SERV_ORDER_NO     = :WS-ORDER-NO                 
A05020             AND VI.WORK_TYPE_CD   > ''                           
A05020             AND NOT EXISTS                                       
A05020                 (SELECT L3.WORK_TYPE_CD                          
A05020                    FROM CSS_ORDER_WK_TYPE L3
                           WITH(READUNCOMMITTED)                     
A05020                   WHERE L3.WORK_TYPE_CD = VI.WORK_TYPE_CD        
A05020                     AND COMPANY_NO      = :VO-COMPANY-NO         
A05020                     AND ORDER_TYPE_CD   = :VO-ORDER-TYPE-CD      
A05020                     AND (STATUS_CHANGE_DT >= 
           CIS.CURRENT$TIMESTAMP()   
A05020                      OR STATUS_CHANGE_DT IS NULL))               
A05020             AND NOT EXISTS                                       
A05020                 (SELECT DISTINCT VI1.SERV_ORDER_NO               
A05020                    FROM CSS_SO_ORDER_INST VI1
                           WITH(READUNCOMMITTED),                   
A05020                         CSS_SO_DATA VO1 WITH(READUNCOMMITTED)            
A05020                   WHERE VI1.SERV_ORDER_NO = VI.SERV_ORDER_NO     
A05020                     AND VI1.SERV_ORDER_NO = VO1.SERV_ORDER_NO    
A05020                     AND VI1.SERV_ORDER_NO = :WS-ORDER-NO         
A05020                     AND VI1.WORK_TYPE_CD  = 'INV'                
A05020                     AND VO1.COMPANY_NO    = '26')                
A05020                                     
A05020                                                      
A05020     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-INVALID-WKTYPE                                       
MFA-TR*           FROM CSS_SO_ORDER_INST VI                                     
MFA-TR*          WHERE SERV_ORDER_NO     = :WS-ORDER-NO                         
MFA-TR*            AND VI.WORK_TYPE_CD   > ''                                   
MFA-TR*            AND NOT EXISTS                                               
MFA-TR*                (SELECT L3.WORK_TYPE_CD                                  
MFA-TR*                   FROM CSS_ORDER_WK_TYPE L3                             
MFA-TR*                  WHERE L3.WORK_TYPE_CD = VI.WORK_TYPE_CD                
MFA-TR*                    AND COMPANY_NO      = :VO-COMPANY-NO                 
MFA-TR*                    AND ORDER_TYPE_CD   = :VO-ORDER-TYPE-CD              
MFA-TR*                    AND (STATUS_CHANGE_DT >= CURRENT TIMESTAMP           
MFA-TR*                     OR STATUS_CHANGE_DT IS NULL))                       
MFA-TR*            AND NOT EXISTS                                               
MFA-TR*                (SELECT DISTINCT VI1.SERV_ORDER_NO                       
MFA-TR*                   FROM CSS_SO_ORDER_INST VI1,                           
MFA-TR*                        CSS_SO_DATA VO1                                  
MFA-TR*                  WHERE VI1.SERV_ORDER_NO = VI.SERV_ORDER_NO             
MFA-TR*                    AND VI1.SERV_ORDER_NO = VO1.SERV_ORDER_NO            
MFA-TR*                    AND VI1.SERV_ORDER_NO = :WS-ORDER-NO                 
MFA-TR*                    AND VI1.WORK_TYPE_CD  = 'INV'                        
MFA-TR*                    AND VO1.COMPANY_NO    = '26')                        
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5275                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05020*                                                                         
A05020     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
A05020*                                                                         
A05020     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
A05020        NEXT SENTENCE                                             
A05020     ELSE                                                         
A05020        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
A05020        MOVE '5275'                    TO ACTIVE-PARAGRAPH        
A05020        MOVE 'SELECT'                  TO ABEND-FUNCTION          
A05020        MOVE 'CSS_SO_ORDER_INST'       TO TABLE-1                 
A05020        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
A05020     END-IF.                                                      
A05020*                                                                         
A05020 5275-EXIT.                                                       
A05020      EXIT.                                                       
A05020                                                                  
       5276-COUNT-COND-METER.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT COUNT(*)                                         
                  INTO :WS-NO-METER-TEMP                                
                  FROM #CSR00109_R2 A                            
                      ,CSS_SO_MTR_VAL B                                 
                 WHERE A.SERV_ORDER_NO    = B.SERV_ORDER_NO             
                   AND A.CODE_UTIL_TYPE   = B.CODE_UTIL_TYPE            
                   AND A.IC_NO            = B.IC_NO                     
                   AND A.METER_NO         = B.METER_NO                  
                   AND A.MTR_REF_NO       = B.MTR_REF_NO                
                   AND A.CODE_TIME_PERIOD = B.CODE_TIME_PERIOD          
                   AND A.REG_ID_NO        = B.REG_ID_NO                 
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*           INTO :WS-NO-METER-TEMP                                        
MFA-TR*           FROM SESSION.CSR00109_R2 A                                    
MFA-TR*               ,CSS_SO_MTR_VAL B                                         
MFA-TR*          WHERE A.SERV_ORDER_NO    = B.SERV_ORDER_NO                     
MFA-TR*            AND A.CODE_UTIL_TYPE   = B.CODE_UTIL_TYPE                    
MFA-TR*            AND A.IC_NO            = B.IC_NO                             
MFA-TR*            AND A.METER_NO         = B.METER_NO                          
MFA-TR*            AND A.MTR_REF_NO       = B.MTR_REF_NO                        
MFA-TR*            AND A.CODE_TIME_PERIOD = B.CODE_TIME_PERIOD                  
MFA-TR*            AND A.REG_ID_NO        = B.REG_ID_NO                         
MFA-TR*          QUERYNO 5276                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5276'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_VAL'          TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5276-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5278-GET-RATE-PLAN-NO.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) RATE_PLAN_NO                                     
                  INTO :WS-RATE-PLAN-NO                                 
                FROM CSS_SO_UTILITY WITH(READUNCOMMITTED)                       
               WHERE SERV_ORDER_NO =                                    
                         CAST(CIS.DECIMAL2DECIMAL3( :WS-ORDER-NO, 13, 
           0 ) AS DECIMAL(13,0))          
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ051
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT RATE_PLAN_NO                                             
MFA-TR*           INTO :WS-RATE-PLAN-NO                                         
MFA-TR*         FROM CSS_SO_UTILITY                                             
MFA-TR*        WHERE SERV_ORDER_NO =                                            
MFA-TR*                  CAST((:WS-ORDER-NO) AS DECIMAL(13,0))                  
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 5278                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5278'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_UTILITY'          TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 8110-DELETE-SO-MTR-VAL THRU 8110-EXIT             
              MOVE 100                 TO WS-ACTIVE-RETURN-CODE         
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5278-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5280-GET-PGM-ID.                                                 
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) RATE_PLAN_NO,
              PROGRAM_ID,
              DIGTL_MTR_TYPE                                   
                  INTO :WS-RATE-PLAN-NO,                                
                       :WS-PROGRAM-ID,                                  
                       :WS-DIGTL-MTR-TYPE                               
                  FROM CSS_SO_METER A WITH(READUNCOMMITTED),                    
                       CSS_SO_UTL_CHG B WITH(READUNCOMMITTED)                   
                 WHERE A.SERV_ORDER_NO  = B.SERV_ORDER_NO               
                   AND A.SERV_ORDER_NO  = :WS-ORDER-NO                  
                   AND A.CODE_UTIL_TYPE = B.CODE_UTIL_TYPE              
                   AND A.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE            
                   AND A.IC_NO          = B.IC_NO                       
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT RATE_PLAN_NO,                                            
MFA-TR*                PROGRAM_ID,                                              
MFA-TR*                DIGTL_MTR_TYPE                                           
MFA-TR*           INTO :WS-RATE-PLAN-NO,                                        
MFA-TR*                :WS-PROGRAM-ID,                                          
MFA-TR*                :WS-DIGTL-MTR-TYPE                                       
MFA-TR*           FROM CSS_SO_METER A,                                          
MFA-TR*                CSS_SO_UTL_CHG B                                         
MFA-TR*          WHERE A.SERV_ORDER_NO  = B.SERV_ORDER_NO                       
MFA-TR*            AND A.SERV_ORDER_NO  = :WS-ORDER-NO                          
MFA-TR*            AND A.CODE_UTIL_TYPE = B.CODE_UTIL_TYPE                      
MFA-TR*            AND A.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                    
MFA-TR*            AND A.IC_NO          = B.IC_NO                               
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5280                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5280'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'CSS_SO_UTL_CHG'          TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 8110-DELETE-SO-MTR-VAL THRU 8110-EXIT             
              MOVE 100                 TO WS-ACTIVE-RETURN-CODE         
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5280-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5285-GET-PGM-ID.                                                 
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) RATE_PLAN_NO,
              PROGRAM_ID,
              DIGTL_MTR_TYPE                                   
                  INTO :WS-RATE-PLAN-NO,                                
                       :WS-PROGRAM-ID,                                  
                       :WS-DIGTL-MTR-TYPE                               
                  FROM CSS_SO_METER A WITH(READUNCOMMITTED) ,                   
                       CSS_SO_UTILITY B WITH(READUNCOMMITTED)                   
                 WHERE A.SERV_ORDER_NO = B.SERV_ORDER_NO                
                   AND A.SERV_ORDER_NO = :WS-ORDER-NO                   
                   AND A.CODE_UTIL_TYPE = B.CODE_UTIL_TYPE              
                   AND A.IC_NO = B.IC_NO                                
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT RATE_PLAN_NO,                                            
MFA-TR*                PROGRAM_ID,                                              
MFA-TR*                DIGTL_MTR_TYPE                                           
MFA-TR*           INTO :WS-RATE-PLAN-NO,                                        
MFA-TR*                :WS-PROGRAM-ID,                                          
MFA-TR*                :WS-DIGTL-MTR-TYPE                                       
MFA-TR*           FROM CSS_SO_METER A ,                                         
MFA-TR*                CSS_SO_UTILITY B                                         
MFA-TR*          WHERE A.SERV_ORDER_NO = B.SERV_ORDER_NO                        
MFA-TR*            AND A.SERV_ORDER_NO = :WS-ORDER-NO                           
MFA-TR*            AND A.CODE_UTIL_TYPE = B.CODE_UTIL_TYPE                      
MFA-TR*            AND A.IC_NO = B.IC_NO                                        
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5285                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5285'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'CSS_SO_UTILITY'          TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 8110-DELETE-SO-MTR-VAL THRU 8110-EXIT             
              MOVE 100                 TO WS-ACTIVE-RETURN-CODE         
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5285-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *                                                                         
       5300-CHECK-SO-MTR-CHG.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG1                              
                  FROM CSS_SO_MTR_CHG WITH(READUNCOMMITTED)                     
                 WHERE SERV_ORDER_NO     = :WS-ORDER-NO                 
                   AND POST_MTR_CHG_IND  = 'Y'                          
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG1                                      
MFA-TR*           FROM CSS_SO_MTR_CHG                                           
MFA-TR*          WHERE SERV_ORDER_NO     = :WS-ORDER-NO                         
MFA-TR*            AND POST_MTR_CHG_IND  = 'Y'                                  
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5300                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5305-CHECK-REG-PROFILE.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG2                              
                  FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                    
                 WHERE ACCOUNT_NO  = :WS-M-ACCOUNT-NO-PRIOR             
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG2                                      
MFA-TR*           FROM CSS_REG_PROFILE                                          
MFA-TR*          WHERE ACCOUNT_NO  = :WS-M-ACCOUNT-NO-PRIOR                     
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5305                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5305'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_REG_PROFILE'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-M-ACCOUNT-NO-PRIOR     TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5305-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5310-CHECK-UTIL-ENVIRONMENT.                                     
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG3                              
                  FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                   
                 WHERE ACCOUNT_NO = :WS-M-ACCOUNT-NO-PRIOR              
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG3                                      
MFA-TR*           FROM CSS_UTIL_ENVRNMT                                         
MFA-TR*          WHERE ACCOUNT_NO = :WS-M-ACCOUNT-NO-PRIOR                      
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5310                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-M-ACCOUNT-NO-PRIOR     TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5310-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5315-CHECK-SO-MTR-CHG.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG4                              
                  FROM CSS_SO_MTR_CHG WITH(READUNCOMMITTED)                     
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
                   AND CODE_STATUS_REA_IS = '8'                         
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG4                                      
MFA-TR*           FROM CSS_SO_MTR_CHG                                           
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*            AND CODE_STATUS_REA_IS = '8'                                 
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5315                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5315'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5315-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5320-CHECK-SO-METER.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-EXISTS-DATA-FG5                               
                 FROM CSS_SO_METER WITH(READUNCOMMITTED)                        
                WHERE SERV_ORDER_NO = :WS-ORDER-NO                      
                  AND CODE_STATUS_REAS = '8'                            
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-EXISTS-DATA-FG5                                       
MFA-TR*          FROM CSS_SO_METER                                              
MFA-TR*         WHERE SERV_ORDER_NO = :WS-ORDER-NO                              
MFA-TR*           AND CODE_STATUS_REAS = '8'                                    
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*         QUERYNO 5320                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5320'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5320-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5325-CHECK-SO-CHARGES.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG6                              
                  FROM CSS_SO_LABOR_CHRGS A WITH(READUNCOMMITTED)               
                      ,CSS_SO_CHARGES B WITH(READUNCOMMITTED)                   
                 WHERE A.SERV_ORDER_NO = :WS-ORDER-NO                   
                   AND A.SERV_ORDER_NO = B.SERV_ORDER_NO                
                   AND B.MATERIAL_CHRG > 0                              
                   AND B.CALC_LABOR_CHRG > 0                            
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG6                                      
MFA-TR*           FROM CSS_SO_LABOR_CHRGS A                                     
MFA-TR*               ,CSS_SO_CHARGES B                                         
MFA-TR*          WHERE A.SERV_ORDER_NO = :WS-ORDER-NO                           
MFA-TR*            AND A.SERV_ORDER_NO = B.SERV_ORDER_NO                        
MFA-TR*            AND B.MATERIAL_CHRG > 0                                      
MFA-TR*            AND B.CALC_LABOR_CHRG > 0                                    
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5325                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5325'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_LABOR_CHRGS'      TO TABLE-1                 
              MOVE 'CSS_SO_CHARGES'          TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5325-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5330-CHECK-SO-CHARGES.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG7                              
                  FROM CSS_SO_LABOR_CHRGS A WITH(READUNCOMMITTED)               
                      ,CSS_SO_CHARGES B WITH(READUNCOMMITTED)                   
                 WHERE A.SERV_ORDER_NO = :WS-ORDER-NO                   
                   AND A.SERV_ORDER_NO = B.SERV_ORDER_NO                
                   AND B.MATERIAL_CHRG > 0                              
                   AND B.CALC_LABOR_CHRG > 0                            
                   AND B.EQUIP_CHARG_AM > 0                             
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG7                                      
MFA-TR*           FROM CSS_SO_LABOR_CHRGS A                                     
MFA-TR*               ,CSS_SO_CHARGES B                                         
MFA-TR*          WHERE A.SERV_ORDER_NO = :WS-ORDER-NO                           
MFA-TR*            AND A.SERV_ORDER_NO = B.SERV_ORDER_NO                        
MFA-TR*            AND B.MATERIAL_CHRG > 0                                      
MFA-TR*            AND B.CALC_LABOR_CHRG > 0                                    
MFA-TR*            AND B.EQUIP_CHARG_AM > 0                                     
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5330                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5330'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_LABOR_CHRGS'      TO TABLE-1                 
              MOVE 'CSS_SO_CHARGES'          TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5330-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5335-CHECK-SO-DATA.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG8                              
                  FROM  CSS_SO_DATA WITH(READUNCOMMITTED)                       
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
                   AND CUST_CNT_ID > ''                                 
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG8                                      
MFA-TR*           FROM  CSS_SO_DATA                                             
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*            AND CUST_CNT_ID > ''                                         
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5335                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5335'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5335-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5340-CHECK-WQ-ITEMS.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG9                              
                  FROM CSS_WQ_ITEMS WITH(READUNCOMMITTED)                       
                 WHERE ACCOUNT_NO    = :WS-M-ACCOUNT-NO-PRIOR           
                   AND PREMISE_NO    = :WS-M-PREMISE-NO                 
                   AND CATEGORY_ID   = :WS-NO-MKTG-CNT-ID-WQ-CATEGORY   
                   AND (STATUS       = :WS-WQ-ASSIGNED                  
                   OR  STATUS        = :WS-WQ-IN-PROGRESS)              
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG9                                      
MFA-TR*           FROM CSS_WQ_ITEMS                                             
MFA-TR*          WHERE ACCOUNT_NO    = :WS-M-ACCOUNT-NO-PRIOR                   
MFA-TR*            AND PREMISE_NO    = :WS-M-PREMISE-NO                         
MFA-TR*            AND CATEGORY_ID   = :WS-NO-MKTG-CNT-ID-WQ-CATEGORY           
MFA-TR*            AND (STATUS       = :WS-WQ-ASSIGNED                          
MFA-TR*            OR  STATUS        = :WS-WQ-IN-PROGRESS)                      
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5340                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5340'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_WQ_ITEMS'            TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-2         
              MOVE 'CATEGORY_ID'             TO TABLE-ELEMENT-3         
              MOVE 'STATUS'                  TO TABLE-ELEMENT-4         
              MOVE WS-M-ACCOUNT-NO-PRIOR     TO HOSTVAR-ELEMENT-1       
              MOVE WS-M-PREMISE-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-NO-MKTG-CNT-ID-WQ-CATEGORY                        
                                             TO HOSTVAR-ELEMENT-3       
              MOVE WS-WQ-ASSIGNED            TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5340-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *5345-CHECK-EQUIPMENT.                                                    
      *                                                                         
      *    EXEC SQL                                                             
      *         SELECT 'Y'                                                      
      *           INTO :WS-EXISTS-DATA-FG10                                     
      *           FROM GSEDDAT.DBO.GSE_EQUIPMENT EQ,                            
      *                GSEDDAT.DBO.GSE_PST PS                                   
      *          WHERE EQ.PREMISE_NO_UFK = :WS-M-PREMISE-NO                     
      *            AND EQ.PRD_SRV_TYPE_CD = PS.PST_CD                           
      *            AND PS.SEASONAL_RT_FL = 'Y'                                  
      *            AND PS.COMPANY_NO = '26'                                     
      *          FETCH FIRST 1 ROW ONLY WITH UR                                 
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND             
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '5345'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'SELECT'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_METER'            TO TABLE-1                         
      *       MOVE 'PREMISE_NO_UFK'          TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *5345-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5350-CHECK-EQUIPMENT.                                                    
      *                                                                         
      *    EXEC SQL                                                             
      *         SELECT 'Y'                                                      
      *           INTO :WS-EXISTS-DATA-FG11                                     
      *           FROM GSEDDAT.DBO.GSE_EQUIPMENT EQ,                            
      *                GSEDDAT.DBO.GSE_PST PS                                   
      *          WHERE EQ.PREMISE_NO_UFK = :WS-M-PREMISE-NO                     
      *            AND EQ.PRD_SRV_TYPE_CD = PS.PST_CD                           
      *            AND PS.SEASONAL_RT_FL = 'N'                                  
      *            AND PS.COMPANY_NO = '26'                                     
      *          FETCH FIRST 1 ROW ONLY WITH UR                                 
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND             
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '5350'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'SELECT'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_METER'            TO TABLE-1                         
      *       MOVE 'PREMISE_NO_UFK'          TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *5350-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5355-CHECK-SO-UTL-CHG.                                                   
      *                                                                         
      *    EXEC SQL                                                             
      *         SELECT 'Y'                                                      
      *           INTO :WS-EXISTS-DATA-FG12                                     
      *           FROM CSS_SO_UTL_CHG                                           
      *          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
      *            AND RATE_PLAN_NO = '105'                                     
      *          FETCH FIRST 1 ROW ONLY WITH UR                                 
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND             
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '5355'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'SELECT'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_UTL_CHG'          TO TABLE-1                         
      *       MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *5355-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5360-CHECK-EQUIPMENT.                                                    
      *                                                                         
      *    EXEC SQL                                                             
      *         SELECT 'Y'                                                      
      *           INTO :WS-EXISTS-DATA-FG13                                     
      *           FROM GSEDDAT.DBO.GSE_EQUIPMENT                                
      *           WHERE PREMISE_NO_UFK = @M_PREMISE_NO                          
      *            AND PRD_SRV_TYPE_CD IN ('CWH', 'WH', 'WC', 'WD')             
      *          FETCH FIRST 1 ROW ONLY WITH UR                                 
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND             
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '5360'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'SELECT'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_UTL_CHG'          TO TABLE-1                         
      *       MOVE 'PREMISE_NO_UFK'          TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *5360-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5365-CHECK-SO-UTILITY.                                                   
      *                                                                         
      *    EXEC SQL                                                             
      *     SELECT  'Y'                                                         
      *       INTO  :WS-EXISTS-DATA-FG14                                        
      *       FROM  CSS_SO_UTILITY                                              
      *      WHERE  SERV_ORDER_NO  = :WS-ORDER-NO                               
      *        AND  RATE_PLAN_NOPE = '32S'                                      
      *      FETCH FIRST 1 ROW ONLY WITH UR                                     
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
      *       MOVE '5365'                TO ACTIVE-PARAGRAPH                    
      *       MOVE 'SELECT'              TO ABEND-FUNCTION                      
      *       MOVE 'CSS_SO_UTILITY'      TO TABLE-1                             
      *       MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1                     
      *       MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1                   
      *       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                         
      *    END-IF.                                                              
      *5365-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5370-CHECK-SO-ORDER-INST.                                                
      *                                                                         
      *    EXEC SQL                                                             
      *     SELECT  'Y'                                                         
      *       INTO  :WS-EXISTS-DATA-FG15                                        
      *       FROM  CSS_SO_ORDER_INST                                           
      *      WHERE  SERV_ORDER_NO  = :WS-ORDER-NO                               
      *        AND  WORK_TYPE_C    > ''                                         
      *        AND  CODE_UTIL_TYPE = 'G'                                        
      *      FETCH FIRST 1 ROW ONLY WITH UR                                     
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
      *       MOVE '5370'                TO ACTIVE-PARAGRAPH                    
      *       MOVE 'SELECT'              TO ABEND-FUNCTION                      
      *       MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                             
      *       MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1                     
      *       MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1                   
      *       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                         
      *    END-IF.                                                              
      *5370-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5375-CHECK-SO-UTL-CHG.                                                   
      *                                                                         
      *    EXEC SQL                                                             
      *     SELECT  'Y'                                                         
      *       INTO  :WS-EXISTS-DATA-FG16                                        
      *       FROM  CSS_SO_UTL_CHG                                              
      *      WHERE  SERV_ORDER_NO  = :WS-ORDER-NO                               
      *        AND  RATE_PLAN_NO   = '32S'                                      
      *      FETCH FIRST 1 ROW ONLY WITH UR                                     
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
      *       MOVE '5375'                TO ACTIVE-PARAGRAPH                    
      *       MOVE 'SELECT'              TO ABEND-FUNCTION                      
      *       MOVE 'CSS_SO_UTL_CHG'      TO TABLE-1                             
      *       MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1                     
      *       MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1                   
      *       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                         
      *    END-IF.                                                              
      *5375-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5380-CHECK-SO-UTILITY.                                                   
      *                                                                         
      *    EXEC SQL                                                             
      *     SELECT  'Y'                                                         
      *       INTO  :WS-EXISTS-DATA-FG17                                        
      *       FROM  CSS_SO_UTILITY                                              
      *      WHERE  SERV_ORDER_NO  = :WS-ORDER-NO                               
      *        AND  RATE_PLAN_NO   = '32V'                                      
      *      FETCH FIRST 1 ROW ONLY WITH UR                                     
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
      *       MOVE '5380'                TO ACTIVE-PARAGRAPH                    
      *       MOVE 'SELECT'              TO ABEND-FUNCTION                      
      *       MOVE 'CSS_SO_UTILITY'      TO TABLE-1                             
      *       MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1                     
      *       MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1                   
      *       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                         
      *    END-IF.                                                              
      *5380-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5385-CHECK-SO-ORDER-INST.                                                
      *                                                                         
      *    EXEC SQL                                                             
      *     SELECT  'Y'                                                         
      *       INTO  :WS-EXISTS-DATA-FG18                                        
      *       FROM  CSS_SO_ORDER_INST                                           
      *      WHERE  SERV_ORDER_NO  = :WS-ORDER-NO                               
      *        AND  WORK_TYPE_C    > ''                                         
      *        AND  CODE_UTIL_TYPE = 'G'                                        
      *        FETCH FIRST 1 ROW ONLY WITH UR                                   
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
      *       MOVE '5385'                TO ACTIVE-PARAGRAPH                    
      *       MOVE 'SELECT'              TO ABEND-FUNCTION                      
      *       MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                             
      *       MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1                     
      *       MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1                   
      *       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                         
      *    END-IF.                                                              
      *5385-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5390-CHECK-SO-UTL-CHG.                                                   
      *                                                                         
      *    EXEC SQL                                                             
      *     SELECT  'Y'                                                         
      *       INTO  :WS-EXISTS-DATA-FG19                                        
      *       FROM  CSS_SO_UTL_CHG                                              
      *      WHERE  SERV_ORDER_NO  = :WS-ORDER-NO                               
      *        AND  RATE_PLAN_NO   = '32V'                                      
      *      FETCH FIRST 1 ROW ONLY WITH UR                                     
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
      *       MOVE '5390'                TO ACTIVE-PARAGRAPH                    
      *       MOVE 'SELECT'              TO ABEND-FUNCTION                      
      *       MOVE 'CSS_SO_UTL_CHG'      TO TABLE-1                             
      *       MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1                     
      *       MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1                   
      *       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                         
      *    END-IF.                                                              
      *5390-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5395-CHECK-SO-MTR-CHG.                                                   
      *                                                                         
      *    EXEC SQL                                                             
      *     SELECT  'Y'                                                         
      *       INTO  :WS-EXISTS-DATA-FG20                                        
      *       FROM  CSS_SO_MTR_CHG MC,                                          
      *             CSS_SO_UTL_CHG UC                                           
      *      WHERE  MC.SERV_ORDER_NO  = :WS-ORDER-NO                            
      *        AND  UC.SERV_ORDER_NO  = :WS-ORDER-NO                            
      *        AND  MC.CODE_UTIL_TYPE = 'G'                                     
      *        AND  UC.CODE_UTIL_TYPE = 'G'                                     
      *        AND  MC.IC_NO          = UC.IC_NO                                
      *        AND  UC.RATE_PLAN_NO     NOT IN                                  
      *             (SELECT  RP.RATE_PLAN_NO                                    
      *                FROM  CSRDUSR.DBO.CSS_RATE_PLAN_DESC RP                  
      *               WHERE  RP.CODE_UTIL_TYPE    = 'G'                         
      *              AND  RP.DISPLAY_START_TS <= :WS-COMPLETED_DATETIME         
      *              AND  RP.DISPLAY_END_TS   >= :WS-COMPLETED_DATETIME)        
      *            FETCH FIRST 1 ROW ONLY WITH UR                               
      *                                                                         
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
      *       MOVE '5395'                TO ACTIVE-PARAGRAPH                    
      *       MOVE 'SELECT'              TO ABEND-FUNCTION                      
      *       MOVE 'SS_SO_MTR_CHG'       TO TABLE-1                             
      *       MOVE 'CSS_SO_UTL_CHG'      TO TABLE-2                             
      *       MOVE 'CSS_RATE_PLAN_DESC'  TO TABLE-3                             
      *       MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1                     
      *       MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-2                     
      *       MOVE 'DISPLAY_START_TS'    TO TABLE-ELEMENT-3                     
      *       MOVE 'DISPLAY_END_TS'      TO TABLE-ELEMENT-4                     
      *       MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1                   
      *       MOVE WS-COMPLETED_DATE     TO HOSTVAR-ELEMENT-2                   
      *       MOVE WS-COMPLETED_DATE     TO HOSTVAR-ELEMENT-3                   
      *       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                         
      *     END-IF.                                                             
      *5395-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
C35978* PSNC RATE PROCESSING DOES NOT USE APPLIANCES                            
      *5400-CHECK-SO-DATA.                                                      
                                                                        
      *    EXEC SQL                                                             
      *     SELECT  'Y'                                                         
      *       INTO  :WS-EXISTS-DATA-FG21                                        
      *       FROM  CSS_SO_DATA SO,                                             
      *             CSS_SO_ORDER_INST OI                                        
      *      WHERE  OI.WORK_TYPE_CD   = 'UNB'                                   
      *        AND  OI.CODE_UTIL_TYPE = 'G'                                     
      *        AND  SO.SERV_ORDER_NO  = :WS-ORDER-NO                            
      *        AND  OI.SERV_ORDER_NO  = SO.SERV_ORDER_NO                        
      *        AND  SO.ORDER_TYPE_CD  = 'FM003'                                 
      *      FETCH FIRST 1 ROW ONLY WITH UR                                     
      *    END-EXEC.                                                            
                                                                        
      *    MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.               
                                                                        
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
      *       MOVE '5400'                TO ACTIVE-PARAGRAPH                    
      *       MOVE 'SELECT'              TO ABEND-FUNCTION                      
      *       MOVE 'CSS_SO_DATA'         TO TABLE-1                             
      *       MOVE 'CSS_SO_ORDER_INST'   TO TABLE-2                             
      *       MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1                     
      *       MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1                   
      *       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                         
      *    END-IF.                                                              
      *5400-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5405-CHECK-EQUIPMENT.                                                    
      *                                                                         
      *    EXEC SQL                                                             
      *     SELECT  'Y'                                                         
      *       INTO  :WS-EXISTS-DATA-FG22                                        
      *       FROM  GSEDDAT.DBO.GSE_EQUIPMENT                                   
      *      WHERE  PREMISE_NO_UF     = :WS-M-PREMISE-NO                        
      *        AND  PRD_SRV_TYPE_CD   IN ('WCG', 'WCO', 'WCC',                  
      *            'WDG', 'WDC', 'WDF', 'WZ', 'WH','WC', 'WD',                  
      *                                  '739', 'CWH', 'WDO')                   
      *      FETCH FIRST 1 ROW ONLY WITH UR                                     
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
      *       MOVE '5405'                TO ACTIVE-PARAGRAPH                    
      *       MOVE 'SELECT'              TO ABEND-FUNCTION                      
      *       MOVE 'GSE_EQUIPMENT'       TO TABLE-1                             
      *       MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1                     
      *       MOVE WS-M-PREMISE-NO       TO HOSTVAR-ELEMENT-1                   
      *       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                         
      *    END-IF.                                                              
      *5405-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5410-CHECK-SO-UTILITY.                                                   
      *                                                                         
      *    EXEC SQL                                                             
      *     SELECT  'Y'                                                         
      *       INTO  :WS-EXISTS-DATA-FG23                                        
      *       FROM  CSS_SO_UTILITY                                              
      *      WHERE  SERV_ORDER_NO  = :WS-ORDER-NO                               
      *        AND  RATE_PLAN_NO = '110'                                        
      *      FETCH FIRST 1 ROW ONLY WITH UR                                     
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
      *       MOVE '5410'                TO ACTIVE-PARAGRAPH                    
      *       MOVE 'SELECT'              TO ABEND-FUNCTION                      
      *       MOVE 'CSS_SO_UTILITY'      TO TABLE-1                             
      *       MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1                     
      *       MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1                   
      *       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                         
      *    END-IF.                                                              
      *5410-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5415-CHECK-SO-UTL-CHG.                                                   
      *                                                                         
      *    EXEC SQL                                                             
      *         SELECT 'Y'                                                      
      *           INTO :WS-EXISTS-DATA-FG24                                     
      *           FROM CSS_SO_UTL_CHG                                           
      *          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
      *            AND RATE_PLAN_NO = '110'                                     
      *          FETCH FIRST 1 ROW ONLY WITH UR                                 
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND             
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '5415'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'SELECT'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_UTL_CHG'          TO TABLE-1                         
      *       MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *5415-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5420-CHECK-SO-UTL-CHG.                                                   
      *                                                                         
      *    EXEC SQL                                                             
      *         SELECT 'Y'                                                      
      *           INTO :WS-EXISTS-DATA-FG25                                     
      *           FROM CSS_SO_UTL_CHG                                           
      *          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
      *            AND RATE_PLAN_NO = '110'                                     
      *          FETCH FIRST 1 ROW ONLY WITH UR                                 
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND             
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '5420'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'SELECT'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_UTL_CHG'          TO TABLE-1                         
      *       MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *5420-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5425-CHECK-SO-UTILITY.                                                   
      *                                                                         
      *    EXEC SQL                                                             
      *         SELECT 'Y'                                                      
      *           INTO :WS-EXISTS-DATA-FG26                                     
      *           FROM CSS_SO_UTILITY                                           
      *          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
      *            AND RATE_PLAN_NO = '105'                                     
      *          FETCH FIRST 1 ROW ONLY WITH UR                                 
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '5425'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'SELECT'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_UTILITY'          TO TABLE-1                         
      *       MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *5425-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *5430-CHECK-SO-UTL-CHG.                                                   
      *                                                                         
      *    EXEC SQL                                                             
      *         SELECT 'Y'                                                      
      *           INTO :WS-EXISTS-DATA-FG27                                     
      *           FROM CSS_SO_UTL_CHG                                           
      *          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
      *            AND RATE_PLAN_NO = '105'                                     
      *          FETCH FIRST 1 ROW ONLY WITH UR                                 
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '5430'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'SELECT'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_UTL_CHG'          TO TABLE-1                         
      *       MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *5430-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
       5435-CHECK-SO-MTR-CHG.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG28                             
                  FROM CSS_SO_MTR_CHG    MC WITH(READUNCOMMITTED),              
                       CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED),              
                       CSS_SO_CHARGES SC WITH(READUNCOMMITTED)                  
                 WHERE MC.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND SC.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND MC.SERV_ORDER_NO  = OI.SERV_ORDER_NO             
                   AND MC.SERV_ORDER_NO  = SC.SERV_ORDER_NO             
                   AND MC.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE            
                   AND MC.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE            
                   AND MC.IC_NO          = OI.IC_NO                     
                   AND MC.MTR_REF_NO     = OI.MTR_REF_NO                
                   AND OI.CODE_UTIL_TYPE = 'G'                          
                   AND MC.CODE_UTIL_TYPE = 'G'                          
                   AND OI.WORK_TYPE_CD   NOT IN                         
                                         ('UNB', 'SOL', 'SOS', 'SOR',   
P01176                                    'MCU')                        
                   AND OI.WORK_TYPE_CD > ''                             
                   AND MC.CODE_STATUS_REA_WS = 'K'                      
                   AND MC.CODE_MTR_STATUS_WS IN ( 'J', 'K')             
                   AND SC.STD_LABOR_CHRG = 25.00                        
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG28                                     
MFA-TR*           FROM CSS_SO_MTR_CHG    MC,                                    
MFA-TR*                CSS_SO_ORDER_INST OI,                                    
MFA-TR*                CSS_SO_CHARGES SC                                        
MFA-TR*          WHERE MC.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND SC.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND MC.SERV_ORDER_NO  = OI.SERV_ORDER_NO                     
MFA-TR*            AND MC.SERV_ORDER_NO  = SC.SERV_ORDER_NO                     
MFA-TR*            AND MC.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE                    
MFA-TR*            AND MC.CODE_UTIL_TYPE = SC.CODE_UTIL_TYPE                    
MFA-TR*            AND MC.IC_NO          = OI.IC_NO                             
MFA-TR*            AND MC.MTR_REF_NO     = OI.MTR_REF_NO                        
MFA-TR*            AND OI.CODE_UTIL_TYPE = 'G'                                  
MFA-TR*            AND MC.CODE_UTIL_TYPE = 'G'                                  
MFA-TR*            AND OI.WORK_TYPE_CD   NOT IN                                 
MFA-TR*                                  ('UNB', 'SOL', 'SOS', 'SOR',           
MFA-TR*                                   'MCU')                                
MFA-TR*            AND OI.WORK_TYPE_CD > ''                                     
MFA-TR*            AND MC.CODE_STATUS_REA_WS = 'K'                              
MFA-TR*            AND MC.CODE_MTR_STATUS_WS IN ( 'J', 'K')                     
MFA-TR*            AND SC.STD_LABOR_CHRG = 25.00                                
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5435                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5435'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'CSS_SO_ORDER_INST'       TO TABLE-2                 
              MOVE 'CSS_SO_CHARGES'          TO TABLE-3                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5435-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5440-CHECK-SO-DATA.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG29                             
                  FROM CSS_SO_DATA WITH(READUNCOMMITTED)                        
                 WHERE PREMISE_NO     = :WS-M-PREMISE-NO                
                   AND ORDER_TYPE_CD  = 'FM002'                         
                   AND ORDER_STATE_CD = 'Z'                             
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG29                                     
MFA-TR*           FROM CSS_SO_DATA                                              
MFA-TR*          WHERE PREMISE_NO     = :WS-M-PREMISE-NO                        
MFA-TR*            AND ORDER_TYPE_CD  = 'FM002'                                 
MFA-TR*            AND ORDER_STATE_CD = 'Z'                                     
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5440                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5440'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-M-PREMISE-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       5440-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5445-CHECK-SO-METER.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG30                             
                  FROM CSS_SO_METER   MR WITH(READUNCOMMITTED),                 
                       CSS_SO_MTR_CHG MC WITH(READUNCOMMITTED)                  
                 WHERE MR.SERV_ORDER_NO = :WS-POSTED-SET-ORDER-NO       
                   AND MC.SERV_ORDER_NO = :WS-ORDER-NO                  
                   AND MR.MTR_REF_NO    = MC.MTR_REF_NO                 
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG30                                     
MFA-TR*           FROM CSS_SO_METER   MR,                                       
MFA-TR*                CSS_SO_MTR_CHG MC                                        
MFA-TR*          WHERE MR.SERV_ORDER_NO = :WS-POSTED-SET-ORDER-NO               
MFA-TR*            AND MC.SERV_ORDER_NO = :WS-ORDER-NO                          
MFA-TR*            AND MR.MTR_REF_NO    = MC.MTR_REF_NO                         
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5445                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5445'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-2                 
              MOVE 'MR.SERV_ORDER_NO'        TO TABLE-ELEMENT-1         
              MOVE 'MC.SERV_ORDER_NO'        TO TABLE-ELEMENT-2         
              MOVE WS-POSTED-SET-ORDER-NO    TO HOSTVAR-ELEMENT-1       
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       5445-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5450-CHECK-SO-DATA.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG31                             
                  FROM CSS_SO_DATA WITH(READUNCOMMITTED)                        
                 WHERE PREMISE_NO = :WS-M-PREMISE-NO                    
                   AND ORDER_TYPE_CD = 'FM002'                          
                   AND DATE_RECVED   < CIS.CHAR2TIMESTAMP(
                                                        :WS-DATE-RECVED
              )                  
                   AND ACCOUNT_NO_PRIOR <> :WS-M-ACCOUNT-NO-PRIOR       
                   AND ORDER_STATE_CD NOT IN ('Z', 'C')                 
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG31                                     
MFA-TR*           FROM CSS_SO_DATA                                              
MFA-TR*          WHERE PREMISE_NO = :WS-M-PREMISE-NO                            
MFA-TR*            AND ORDER_TYPE_CD = 'FM002'                                  
MFA-TR*            AND DATE_RECVED   < :WS-DATE-RECVED                          
MFA-TR*            AND ACCOUNT_NO_PRIOR <> :WS-M-ACCOUNT-NO-PRIOR               
MFA-TR*            AND ORDER_STATE_CD NOT IN ('Z', 'C')                         
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5450                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5450'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE 'DATE_RECVED'             TO TABLE-ELEMENT-2         
              MOVE 'ACCOUNT_NO_PRIOR'        TO TABLE-ELEMENT-3         
              MOVE WS-M-PREMISE-NO           TO HOSTVAR-ELEMENT-1       
              MOVE WS-DATE-RECVED            TO HOSTVAR-ELEMENT-1       
              MOVE WS-M-ACCOUNT-NO-PRIOR     TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       5450-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5455-CHECK-SO-DATA.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG32                             
                  FROM CSS_SO_DATA WITH(READUNCOMMITTED)                        
                 WHERE PREMISE_NO       = :WS-M-PREMISE-NO              
                   AND ACCOUNT_NO_PRIOR = :WS-M-ACCOUNT-NO-PRIOR        
                   AND ORDER_TYPE_CD    = 'DNP01'                       
                   AND ORDER_STATE_CD NOT IN ('Z','C')                  
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG32                                     
MFA-TR*           FROM CSS_SO_DATA                                              
MFA-TR*          WHERE PREMISE_NO       = :WS-M-PREMISE-NO                      
MFA-TR*            AND ACCOUNT_NO_PRIOR = :WS-M-ACCOUNT-NO-PRIOR                
MFA-TR*            AND ORDER_TYPE_CD    = 'DNP01'                               
MFA-TR*            AND ORDER_STATE_CD NOT IN ('Z','C')                          
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5455                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5455'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO_PRIOR'        TO TABLE-ELEMENT-2         
              MOVE WS-M-PREMISE-NO           TO HOSTVAR-ELEMENT-1       
              MOVE WS-M-ACCOUNT-NO-PRIOR     TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5455-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5460-CHECK-SO-METER.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG33                             
                  FROM CSS_SO_METER          MT WITH(READUNCOMMITTED),          
                       CSS_SO_ORDER_INST     OI WITH(READUNCOMMITTED),          
                       CSS_SO_MTR_CHG        MC WITH(READUNCOMMITTED),          
C33743                 CSS_PIM_POINT         SP WITH(READUNCOMMITTED)           
                 WHERE MT.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND MC.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND MT.SERV_ORDER_NO  = OI.SERV_ORDER_NO             
                   AND MT.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE            
                   AND MT.CODE_UTIL_TYPE = 'E'                          
                   AND OI.CODE_UTIL_TYPE = 'E'                          
                   AND MC.CODE_UTIL_TYPE = 'E'                          
                   AND MT.IC_NO          = OI.IC_NO                     
                   AND MT.MTR_REF_NO     = OI.MTR_REF_NO                
                   AND MC.SERV_ORDER_NO  = MT.SERV_ORDER_NO             
                   AND MC.CODE_UTIL_TYPE = MT.CODE_UTIL_TYPE            
                   AND MC.IC_NO          = MT.IC_NO                     
                   AND MC.MTR_REF_NO     = MT.MTR_REF_NO                
                   AND OI.WORK_TYPE_CD > ''                             
                   AND MT.GIS_POINT_ID = 0                              
                   AND SP.POINT_ID = MC.GIS_POINT_ID   
C33743             AND SP.AREA_ID + SP.TAG_NM = MT.POINT_ID            
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ031
MFA-TR* MSQ051
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG33                                     
MFA-TR*           FROM CSS_SO_METER          MT,                                
MFA-TR*                CSS_SO_ORDER_INST     OI,                                
MFA-TR*                CSS_SO_MTR_CHG        MC,                                
MFA-TR*                CSS_PIM_POINT         SP                                 
MFA-TR*          WHERE MT.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND MC.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND MT.SERV_ORDER_NO  = OI.SERV_ORDER_NO                     
MFA-TR*            AND MT.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE                    
MFA-TR*            AND MT.CODE_UTIL_TYPE = 'E'                                  
MFA-TR*            AND OI.CODE_UTIL_TYPE = 'E'                                  
MFA-TR*            AND MC.CODE_UTIL_TYPE = 'E'                                  
MFA-TR*            AND MT.IC_NO          = OI.IC_NO                             
MFA-TR*            AND MT.MTR_REF_NO     = OI.MTR_REF_NO                        
MFA-TR*            AND MC.SERV_ORDER_NO  = MT.SERV_ORDER_NO                     
MFA-TR*            AND MC.CODE_UTIL_TYPE = MT.CODE_UTIL_TYPE                    
MFA-TR*            AND MC.IC_NO          = MT.IC_NO                             
MFA-TR*            AND MC.MTR_REF_NO     = MT.MTR_REF_NO                        
MFA-TR*            AND OI.WORK_TYPE_CD > ''                                     
MFA-TR*            AND MT.GIS_POINT_ID = 0                                      
MFA-TR*            AND SP.POINT_ID = CAST(MC.GIS_POINT_ID AS INTEGER)           
MFA-TR*            AND SP.AREA_ID || SP.TAG_NM = MT.POINT_ID                    
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5460                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5460'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'CSS_SO_ORDER_INST'       TO TABLE-2                 
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-3                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5460-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5465-CHECK-SO-METER.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG34                             
                  FROM CSS_SO_METER      MT WITH(READUNCOMMITTED),              
                       CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                 WHERE MT.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND MT.SERV_ORDER_NO  = OI.SERV_ORDER_NO             
                   AND MT.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE            
                   AND MT.CODE_UTIL_TYPE = 'E'                          
                   AND OI.CODE_UTIL_TYPE = 'E'                          
                   AND MT.IC_NO          = OI.IC_NO                     
                   AND MT.MTR_REF_NO     = OI.MTR_REF_NO                
                   AND OI.WORK_TYPE_CD > ''                             
                   AND MT.POINT_ID = ''                                 
                   AND MT.GIS_POINT_ID = 0                              
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG34                                     
MFA-TR*           FROM CSS_SO_METER      MT,                                    
MFA-TR*                CSS_SO_ORDER_INST OI                                     
MFA-TR*          WHERE MT.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND MT.SERV_ORDER_NO  = OI.SERV_ORDER_NO                     
MFA-TR*            AND MT.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE                    
MFA-TR*            AND MT.CODE_UTIL_TYPE = 'E'                                  
MFA-TR*            AND OI.CODE_UTIL_TYPE = 'E'                                  
MFA-TR*            AND MT.IC_NO          = OI.IC_NO                             
MFA-TR*            AND MT.MTR_REF_NO     = OI.MTR_REF_NO                        
MFA-TR*            AND OI.WORK_TYPE_CD > ''                                     
MFA-TR*            AND MT.POINT_ID = ''                                         
MFA-TR*            AND MT.GIS_POINT_ID = 0                                      
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5465                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5465'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'CSS_SO_ORDER_INST'       TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5465-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5470-CHECK-SO-METER.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG35                             
                  FROM CSS_SO_METER      MT WITH(READUNCOMMITTED),              
                       CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                 WHERE MT.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND MT.SERV_ORDER_NO  = OI.SERV_ORDER_NO             
                   AND MT.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE            
                   AND MT.CODE_UTIL_TYPE = 'E'                          
                   AND OI.CODE_UTIL_TYPE = 'E'                          
                   AND MT.IC_NO          = OI.IC_NO                     
                   AND MT.MTR_REF_NO     = OI.MTR_REF_NO                
                   AND OI.WORK_TYPE_CD > ''                             
                   AND MT.GIS_POINT_ID > 0                              
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG35                                     
MFA-TR*           FROM CSS_SO_METER      MT,                                    
MFA-TR*                CSS_SO_ORDER_INST OI                                     
MFA-TR*          WHERE MT.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND MT.SERV_ORDER_NO  = OI.SERV_ORDER_NO                     
MFA-TR*            AND MT.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE                    
MFA-TR*            AND MT.CODE_UTIL_TYPE = 'E'                                  
MFA-TR*            AND OI.CODE_UTIL_TYPE = 'E'                                  
MFA-TR*            AND MT.IC_NO          = OI.IC_NO                             
MFA-TR*            AND MT.MTR_REF_NO     = OI.MTR_REF_NO                        
MFA-TR*            AND OI.WORK_TYPE_CD > ''                                     
MFA-TR*            AND MT.GIS_POINT_ID > 0                                      
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5470                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5470'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'CSS_SO_ORDER_INST'       TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5470-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5475-CHECK-SO-METER.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG36                             
                  FROM CSS_SO_METER      MT WITH(READUNCOMMITTED),              
                       CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                  WHERE MT.SERV_ORDER_NO  = :WS-ORDER-NO                
                    AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                
                    AND MT.SERV_ORDER_NO  = OI.SERV_ORDER_NO            
                    AND MT.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE           
                    AND MT.CODE_UTIL_TYPE = 'E'                         
                    AND OI.CODE_UTIL_TYPE = 'E'                         
                    AND MT.IC_NO          = OI.IC_NO                    
                    AND MT.MTR_REF_NO     = OI.MTR_REF_NO               
                    AND OI.WORK_TYPE_CD > ''                            
                    AND MT.POINT_ID > ''                                
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG36                                     
MFA-TR*           FROM CSS_SO_METER      MT,                                    
MFA-TR*                CSS_SO_ORDER_INST OI                                     
MFA-TR*           WHERE MT.SERV_ORDER_NO  = :WS-ORDER-NO                        
MFA-TR*             AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                        
MFA-TR*             AND MT.SERV_ORDER_NO  = OI.SERV_ORDER_NO                    
MFA-TR*             AND MT.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE                   
MFA-TR*             AND MT.CODE_UTIL_TYPE = 'E'                                 
MFA-TR*             AND OI.CODE_UTIL_TYPE = 'E'                                 
MFA-TR*             AND MT.IC_NO          = OI.IC_NO                            
MFA-TR*             AND MT.MTR_REF_NO     = OI.MTR_REF_NO                       
MFA-TR*             AND OI.WORK_TYPE_CD > ''                                    
MFA-TR*             AND MT.POINT_ID > ''                                        
MFA-TR*           FETCH FIRST 1 ROW ONLY WITH UR                                
MFA-TR*           QUERYNO 5475                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5475'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'CSS_SO_ORDER_INST'       TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5475-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5480-CHECK-WQ-ITEMS.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG37                             
                  FROM CSS_WQ_ITEMS WITH(READUNCOMMITTED)                       
                 WHERE ACCOUNT_NO  = :WS-M-ACCOUNT-NO-PRIOR             
                   AND PREMISE_NO  = :WS-M-PREMISE-NO                   
                   AND CATEGORY_ID = :WS-BILL-EXCEPTION-WQ-CATEGORY     
                   AND (STATUS     = :WS-WQ-ASSIGNED                    
                    OR  STATUS     = :WS-WQ-IN-PROGRESS)                
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG37                                     
MFA-TR*           FROM CSS_WQ_ITEMS                                             
MFA-TR*          WHERE ACCOUNT_NO  = :WS-M-ACCOUNT-NO-PRIOR                     
MFA-TR*            AND PREMISE_NO  = :WS-M-PREMISE-NO                           
MFA-TR*            AND CATEGORY_ID = :WS-BILL-EXCEPTION-WQ-CATEGORY             
MFA-TR*            AND (STATUS     = :WS-WQ-ASSIGNED                            
MFA-TR*             OR  STATUS     = :WS-WQ-IN-PROGRESS)                        
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5480                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5480'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_WQ_ITEMS'            TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-2         
              MOVE 'CATEGORY_ID'             TO TABLE-ELEMENT-3         
              MOVE 'STATUS'                  TO TABLE-ELEMENT-4         
              MOVE WS-M-ACCOUNT-NO-PRIOR     TO HOSTVAR-ELEMENT-1       
              MOVE WS-M-PREMISE-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-BILL-EXCEPTION-WQ-CATEGORY                        
                                             TO HOSTVAR-ELEMENT-3       
              MOVE WS-WQ-ASSIGNED            TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5480-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5485-CHECK-WQ-ITEMS.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG38                             
                  FROM CSS_WQ_ITEMS WITH(READUNCOMMITTED)                       
                 WHERE ACCOUNT_NO  = :WS-M-ACCOUNT-NO-PRIOR             
                   AND PREMISE_NO  = :WS-M-PREMISE-NO                   
                   AND CATEGORY_ID = :WS-FINAL-BILL-INVESTIGATE-WQ      
                   AND (STATUS     = :WS-WQ-ASSIGNED                    
                    OR  STATUS     = :WS-WQ-IN-PROGRESS)                
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG38                                     
MFA-TR*           FROM CSS_WQ_ITEMS                                             
MFA-TR*          WHERE ACCOUNT_NO  = :WS-M-ACCOUNT-NO-PRIOR                     
MFA-TR*            AND PREMISE_NO  = :WS-M-PREMISE-NO                           
MFA-TR*            AND CATEGORY_ID = :WS-FINAL-BILL-INVESTIGATE-WQ              
MFA-TR*            AND (STATUS     = :WS-WQ-ASSIGNED                            
MFA-TR*             OR  STATUS     = :WS-WQ-IN-PROGRESS)                        
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5485                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5485'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_WQ_ITEMS'            TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-2         
              MOVE 'CATEGORY_ID'             TO TABLE-ELEMENT-3         
              MOVE 'STATUS'                  TO TABLE-ELEMENT-4         
              MOVE WS-M-ACCOUNT-NO-PRIOR     TO HOSTVAR-ELEMENT-1       
              MOVE WS-M-PREMISE-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-FINAL-BILL-INVESTIGATE-WQ                         
                                             TO HOSTVAR-ELEMENT-3       
              MOVE WS-WQ-ASSIGNED            TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5485-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5490-CHECK-SO-DATA.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG39                             
                  FROM CSS_SO_DATA WITH(READUNCOMMITTED)                        
                 WHERE PREMISE_NO    = :WS-M-PREMISE-NO                 
                   AND ORDER_TYPE_CD = 'OFF01'                          
                   AND ORDER_STATE_CD NOT IN ('Z', 'C')                 
                   AND ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-DATETIME
              )        
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG39                                     
MFA-TR*           FROM CSS_SO_DATA                                              
MFA-TR*          WHERE PREMISE_NO    = :WS-M-PREMISE-NO                         
MFA-TR*            AND ORDER_TYPE_CD = 'OFF01'                                  
MFA-TR*            AND ORDER_STATE_CD NOT IN ('Z', 'C')                         
MFA-TR*            AND ASSIGNED_DATETIME < :WS-ASSIGNED-DATETIME                
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5490                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5490'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ASSIGNED_DATETIME'       TO TABLE-ELEMENT-2         
              MOVE WS-M-PREMISE-NO           TO HOSTVAR-ELEMENT-1       
              MOVE WS-ASSIGNED-DATETIME      TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5490-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5495-CHECK-SO-MTR-CHG.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG40                             
                  FROM CSS_SO_MTR_CHG    MC WITH(READUNCOMMITTED),              
                       CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                 WHERE MC.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND MC.SERV_ORDER_NO  = OI.SERV_ORDER_NO             
                   AND MC.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE            
                   AND MC.IC_NO          = OI.IC_NO                     
                   AND MC.MTR_REF_NO     = OI.MTR_REF_NO                
                   AND OI.WORK_TYPE_CD   > ''                           
                   AND MC.CODE_STATUS_REA_WS <> 'C'                     
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG40                                     
MFA-TR*           FROM CSS_SO_MTR_CHG    MC,                                    
MFA-TR*                CSS_SO_ORDER_INST OI                                     
MFA-TR*          WHERE MC.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND MC.SERV_ORDER_NO  = OI.SERV_ORDER_NO                     
MFA-TR*            AND MC.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE                    
MFA-TR*            AND MC.IC_NO          = OI.IC_NO                             
MFA-TR*            AND MC.MTR_REF_NO     = OI.MTR_REF_NO                        
MFA-TR*            AND OI.WORK_TYPE_CD   > ''                                   
MFA-TR*            AND MC.CODE_STATUS_REA_WS <> 'C'                             
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5495                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5495'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'CSS_SO_ORDER_INST'       TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5495-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5500-CHECK-SO-REG-CHG.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG41                             
                  FROM CSS_SO_REG_CHG    RC WITH(READUNCOMMITTED),              
                       CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)               
                 WHERE RC.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                 
                   AND RC.SERV_ORDER_NO  = OI.SERV_ORDER_NO             
                   AND RC.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE            
                   AND RC.IC_NO          = OI.IC_NO                     
                   AND RC.MTR_REF_NO     = OI.MTR_REF_NO                
                   AND OI.WORK_TYPE_CD   > ''                           
                   AND RC.CODE_STATUS_REA_WS <> 'C'                     
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG41                                     
MFA-TR*           FROM CSS_SO_REG_CHG    RC,                                    
MFA-TR*                CSS_SO_ORDER_INST OI                                     
MFA-TR*          WHERE RC.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND OI.SERV_ORDER_NO  = :WS-ORDER-NO                         
MFA-TR*            AND RC.SERV_ORDER_NO  = OI.SERV_ORDER_NO                     
MFA-TR*            AND RC.CODE_UTIL_TYPE = OI.CODE_UTIL_TYPE                    
MFA-TR*            AND RC.IC_NO          = OI.IC_NO                             
MFA-TR*            AND RC.MTR_REF_NO     = OI.MTR_REF_NO                        
MFA-TR*            AND OI.WORK_TYPE_CD   > ''                                   
MFA-TR*            AND RC.CODE_STATUS_REA_WS <> 'C'                             
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5500                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_REG_CHG'          TO TABLE-1                 
              MOVE 'CSS_SO_ORDER_INST'       TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5505-CHECK-SO-MTR-CHG.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG42                             
                  FROM CSS_SO_MTR_CHG WITH(READUNCOMMITTED)                     
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
                   AND CODE_MTR_STATUS_IS = 'K'                         
                   AND ABS(READ_VALUE_IS - LAST_READ_VALUE) > 4         
                   AND MTR_READ_SOURCE_CD <> 'M'                        
                   AND MTR_READ_SOURCE_CD <> 'S'                        
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG42                                     
MFA-TR*           FROM CSS_SO_MTR_CHG                                           
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*            AND CODE_MTR_STATUS_IS = 'K'                                 
MFA-TR*            AND ABS(READ_VALUE_IS - LAST_READ_VALUE) > 4                 
MFA-TR*            AND MTR_READ_SOURCE_CD <> 'M'                                
MFA-TR*            AND MTR_READ_SOURCE_CD <> 'S'                                
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5505                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5505'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5505-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5510-CHECK-SO-MTR-CHG.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG43                             
                  FROM CSS_SO_MTR_CHG MC WITH(READUNCOMMITTED),                 
                       CSS_SO_REG_CHG RC WITH(READUNCOMMITTED)                  
                 WHERE MC.SERV_ORDER_NO      = :WS-ORDER-NO             
                   AND RC.SERV_ORDER_NO      = :WS-ORDER-NO             
                   AND MC.SERV_ORDER_NO      = RC.SERV_ORDER_NO         
                   AND MC.CODE_UTIL_TYPE     = RC.CODE_UTIL_TYPE        
                   AND MC.IC_NO              = RC.IC_NO                 
                   AND MC.MTR_REF_NO         = RC.MTR_REF_NO            
                   AND RC.CODE_REG_STATUS_IS = 'K'                      
                   AND ABS(RC.READ_VALUE_IS - RC.LAST_READ_VALUE) > 4   
                   AND MC.MTR_READ_SOURCE_CD <> 'M'                     
                   AND MC.MTR_READ_SOURCE_CD <> 'S'                     
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG43                                     
MFA-TR*           FROM CSS_SO_MTR_CHG MC,                                       
MFA-TR*                CSS_SO_REG_CHG RC                                        
MFA-TR*          WHERE MC.SERV_ORDER_NO      = :WS-ORDER-NO                     
MFA-TR*            AND RC.SERV_ORDER_NO      = :WS-ORDER-NO                     
MFA-TR*            AND MC.SERV_ORDER_NO      = RC.SERV_ORDER_NO                 
MFA-TR*            AND MC.CODE_UTIL_TYPE     = RC.CODE_UTIL_TYPE                
MFA-TR*            AND MC.IC_NO              = RC.IC_NO                         
MFA-TR*            AND MC.MTR_REF_NO         = RC.MTR_REF_NO                    
MFA-TR*            AND RC.CODE_REG_STATUS_IS = 'K'                              
MFA-TR*            AND ABS(RC.READ_VALUE_IS - RC.LAST_READ_VALUE) > 4           
MFA-TR*            AND MC.MTR_READ_SOURCE_CD <> 'M'                             
MFA-TR*            AND MC.MTR_READ_SOURCE_CD <> 'S'                             
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5510                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5510'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'CSS_SO_REG_CHG'          TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5510-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5515-CHECK-SO-MTR-CHG.                                           
                                                                        
           EXEC SQL                                                     
            SELECT TOP(1) 'Y'                                                 
              INTO  :WS-EXISTS-DATA-FG44                                
              FROM  CSS_SO_MTR_CHG MC WITH(READUNCOMMITTED),                    
                    CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                  
             WHERE  MC.SERV_ORDER_NO      = :WS-ORDER-NO                
               AND  OI.SERV_ORDER_NO      = :WS-ORDER-NO                
               AND  MC.CODE_UTIL_TYPE     = OI.CODE_UTIL_TYPE           
               AND  MC.IC_NO              = OI.IC_NO                    
               AND  MC.MTR_REF_NO         = OI.MTR_REF_NO               
               AND  OI.WORK_TYPE_CD       > ''                          
               AND  OI.WORK_TYPE_CD NOT IN ('SOL', 'SOS', 'SOR')        
               AND  MC.READ_VALUE_IS - MC.LAST_READ_VALUE < 0           
               AND  MC.MTR_READ_SOURCE_CD <> 'M'                        
               AND  MC.MTR_READ_SOURCE_CD <> 'S'                        
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  'Y'                                                         
MFA-TR*       INTO  :WS-EXISTS-DATA-FG44                                        
MFA-TR*       FROM  CSS_SO_MTR_CHG MC,                                          
MFA-TR*             CSS_SO_ORDER_INST OI                                        
MFA-TR*      WHERE  MC.SERV_ORDER_NO      = :WS-ORDER-NO                        
MFA-TR*        AND  OI.SERV_ORDER_NO      = :WS-ORDER-NO                        
MFA-TR*        AND  MC.CODE_UTIL_TYPE     = OI.CODE_UTIL_TYPE                   
MFA-TR*        AND  MC.IC_NO              = OI.IC_NO                            
MFA-TR*        AND  MC.MTR_REF_NO         = OI.MTR_REF_NO                       
MFA-TR*        AND  OI.WORK_TYPE_CD       > ''                                  
MFA-TR*        AND  OI.WORK_TYPE_CD NOT IN ('SOL', 'SOS', 'SOR')                
MFA-TR*        AND  MC.READ_VALUE_IS - MC.LAST_READ_VALUE < 0                   
MFA-TR*        AND  MC.MTR_READ_SOURCE_CD <> 'M'                                
MFA-TR*        AND  MC.MTR_READ_SOURCE_CD <> 'S'                                
MFA-TR*      FETCH FIRST 1 ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 5515                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5515'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_MTR_CHG'      TO TABLE-1                     
              MOVE 'CSS_SO_ORDER_INST'   TO TABLE-2                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
            END-IF.                                                     
       5515-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5520-CHECK-SO-MTR-CHG.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO  :WS-EXISTS-DATA-FG45                              
                FROM  CSS_SO_MTR_CHG MC WITH(READUNCOMMITTED)                   
                     ,CSS_SO_REG_CHG RC WITH(READUNCOMMITTED)                   
                     ,CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                
               WHERE  MC.SERV_ORDER_NO      = :WS-ORDER-NO              
                 AND  RC.SERV_ORDER_NO      = :WS-ORDER-NO              
                 AND  OI.SERV_ORDER_NO      = :WS-ORDER-NO              
                 AND  MC.CODE_UTIL_TYPE     = RC.CODE_UTIL_TYPE         
                 AND  MC.IC_NO              = RC.IC_NO                  
                 AND  MC.MTR_REF_NO         = RC.MTR_REF_NO             
                 AND  OI.IC_NO              = MC.IC_NO                  
                 AND  OI.MTR_REF_NO         = MC.MTR_REF_NO             
                 AND  OI.WORK_TYPE_CD       > ''                        
                 AND  RC.CODE_REG_STATUS_IS = 'K'                       
                 AND  ABS(RC.READ_VALUE_IS - RC.LAST_READ_VALUE) > 3    
                 AND  MC.MTR_READ_SOURCE_CD <> 'M'                      
                 AND  MC.MTR_READ_SOURCE_CD <> 'S'                      
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO  :WS-EXISTS-DATA-FG45                                      
MFA-TR*         FROM  CSS_SO_MTR_CHG MC                                         
MFA-TR*              ,CSS_SO_REG_CHG RC                                         
MFA-TR*              ,CSS_SO_ORDER_INST OI                                      
MFA-TR*        WHERE  MC.SERV_ORDER_NO      = :WS-ORDER-NO                      
MFA-TR*          AND  RC.SERV_ORDER_NO      = :WS-ORDER-NO                      
MFA-TR*          AND  OI.SERV_ORDER_NO      = :WS-ORDER-NO                      
MFA-TR*          AND  MC.CODE_UTIL_TYPE     = RC.CODE_UTIL_TYPE                 
MFA-TR*          AND  MC.IC_NO              = RC.IC_NO                          
MFA-TR*          AND  MC.MTR_REF_NO         = RC.MTR_REF_NO                     
MFA-TR*          AND  OI.IC_NO              = MC.IC_NO                          
MFA-TR*          AND  OI.MTR_REF_NO         = MC.MTR_REF_NO                     
MFA-TR*          AND  OI.WORK_TYPE_CD       > ''                                
MFA-TR*          AND  RC.CODE_REG_STATUS_IS = 'K'                               
MFA-TR*          AND  ABS(RC.READ_VALUE_IS - RC.LAST_READ_VALUE) > 3            
MFA-TR*          AND  MC.MTR_READ_SOURCE_CD <> 'M'                              
MFA-TR*          AND  MC.MTR_READ_SOURCE_CD <> 'S'                              
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 5520                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5520'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_MTR_CHG'      TO TABLE-1                     
              MOVE 'CSS_SO_REG_CHG'      TO TABLE-2                     
              MOVE 'CSS_SO_ORDER_INST'   TO TABLE-3                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
            END-IF.                                                     
       5520-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5525-CHECK-SO-DATA.                                              
                                                                        
           EXEC SQL                                                     
            SELECT TOP(1) 'Y'                                                 
              INTO  :WS-EXISTS-DATA-FG46                                
              FROM  CSS_SO_DATA WITH(READUNCOMMITTED)                           
             WHERE  PREMISE_NO     = :WS-M-PREMISE-NO                   
               AND  ORDER_TYPE_CD  = 'CC001'                            
               AND  ORDER_STATE_CD NOT IN ('Z', 'C')                    
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  'Y'                                                         
MFA-TR*       INTO  :WS-EXISTS-DATA-FG46                                        
MFA-TR*       FROM  CSS_SO_DATA                                                 
MFA-TR*      WHERE  PREMISE_NO     = :WS-M-PREMISE-NO                           
MFA-TR*        AND  ORDER_TYPE_CD  = 'CC001'                                    
MFA-TR*        AND  ORDER_STATE_CD NOT IN ('Z', 'C')                            
MFA-TR*      FETCH FIRST 1 ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 5525                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5525'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-M-PREMISE-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       5525-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5530-CHECK-SO-DATA.                                              
                                                                        
           EXEC SQL                                                     
            SELECT TOP(1) 'Y'                                                 
              INTO  :WS-EXISTS-DATA-FG47                                
              FROM  CSS_SO_DATA WITH(READUNCOMMITTED)                           
             WHERE  PREMISE_NO     = :WS-M-PREMISE-NO                   
               AND  ORDER_TYPE_CD  = 'OFF01'                            
               AND  ORDER_STATE_CD NOT IN ('Z', 'C')                    
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  'Y'                                                         
MFA-TR*       INTO  :WS-EXISTS-DATA-FG47                                        
MFA-TR*       FROM  CSS_SO_DATA                                                 
MFA-TR*      WHERE  PREMISE_NO     = :WS-M-PREMISE-NO                           
MFA-TR*        AND  ORDER_TYPE_CD  = 'OFF01'                                    
MFA-TR*        AND  ORDER_STATE_CD NOT IN ('Z', 'C')                            
MFA-TR*      FETCH FIRST 1 ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 5530                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5530'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-M-PREMISE-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
            END-IF.                                                     
       5530-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5535-CHECK-SO-MTR-CHG.                                           
                                                                        
           EXEC SQL                                                     
            SELECT TOP(1) 'Y'                                                 
              INTO  :WS-EXISTS-DATA-FG48                                
              FROM  CSS_SO_MTR_CHG WITH(READUNCOMMITTED)                        
             WHERE  SERV_ORDER_NO       = :WS-ORDER-NO                  
               AND  POST_MTR_CHG_IND    = 'Y'                           
               AND  (CODE_MTR_STATUS_WS = 'K' OR                        
                     CODE_MTR_STATUS_WS = 'J' )                         
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  'Y'                                                         
MFA-TR*       INTO  :WS-EXISTS-DATA-FG48                                        
MFA-TR*       FROM  CSS_SO_MTR_CHG                                              
MFA-TR*      WHERE  SERV_ORDER_NO       = :WS-ORDER-NO                          
MFA-TR*        AND  POST_MTR_CHG_IND    = 'Y'                                   
MFA-TR*        AND  (CODE_MTR_STATUS_WS = 'K' OR                                
MFA-TR*              CODE_MTR_STATUS_WS = 'J' )                                 
MFA-TR*      FETCH FIRST 1 ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 5535                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5535'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_MTR_CHG'      TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
            END-IF.                                                     
       5535-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5540-CHECK-SO-REG-CHG.                                           
                                                                        
           EXEC SQL                                                     
            SELECT TOP(1) 'Y'                                                 
              INTO  :WS-EXISTS-DATA-FG49                                
              FROM  CSS_SO_REG_CHG A WITH(READUNCOMMITTED),                     
                    CSS_SO_MTR_CHG B WITH(READUNCOMMITTED)                      
             WHERE  A.SERV_ORDER_NO       = :WS-ORDER-NO                
               AND  A.SERV_ORDER_NO       = B.SERV_ORDER_NO             
               AND  B.POST_MTR_CHG_IND    = 'Y'                         
               AND  (A.CODE_REG_STATUS_WS = 'K' OR                      
                     A.CODE_REG_STATUS_WS = 'J' )                       
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  'Y'                                                         
MFA-TR*       INTO  :WS-EXISTS-DATA-FG49                                        
MFA-TR*       FROM  CSS_SO_REG_CHG A,                                           
MFA-TR*             CSS_SO_MTR_CHG B                                            
MFA-TR*      WHERE  A.SERV_ORDER_NO       = :WS-ORDER-NO                        
MFA-TR*        AND  A.SERV_ORDER_NO       = B.SERV_ORDER_NO                     
MFA-TR*        AND  B.POST_MTR_CHG_IND    = 'Y'                                 
MFA-TR*        AND  (A.CODE_REG_STATUS_WS = 'K' OR                              
MFA-TR*              A.CODE_REG_STATUS_WS = 'J' )                               
MFA-TR*      FETCH FIRST 1 ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 5540                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5540'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_REG_CHG'      TO TABLE-1                     
              MOVE 'CSS_SO_MTR_CHG'      TO TABLE-2                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       5540-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5545-CHECK-SO-DATA.                                              
                                                                        
           EXEC SQL                                                     
            SELECT TOP(1) 'Y'                                                 
              INTO  :WS-EXISTS-DATA-FG50                                
              FROM  CSS_SO_DATA WITH(READUNCOMMITTED)                           
             WHERE  PREMISE_NO      = :WS-M-PREMISE-NO                  
               AND  SERV_ORDER_NO  <> :WS-ORDER-NO                      
               AND  ORDER_STATE_CD  = 'Z'                               
               AND   CAST(COMPLETED_DATETIME AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-TODAY
              ) IS NULL OR (PATINDEX('%.%', :WS-TODAY) <> 0) OR (LEN(
                                                              :WS-TODAY
              ) <> 10), CIS.CHAR2DATE(:WS-TODAY), CONVERT(DATE, 
                                                              :WS-TODAY
              ) )               
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  'Y'                                                         
MFA-TR*       INTO  :WS-EXISTS-DATA-FG50                                        
MFA-TR*       FROM  CSS_SO_DATA                                                 
MFA-TR*      WHERE  PREMISE_NO      = :WS-M-PREMISE-NO                          
MFA-TR*        AND  SERV_ORDER_NO  <> :WS-ORDER-NO                              
MFA-TR*        AND  ORDER_STATE_CD  = 'Z'                                       
MFA-TR*        AND   DATE(COMPLETED_DATETIME) = :WS-TODAY                       
MFA-TR*      FETCH FIRST 1 ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 5545                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5545'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-2             
              MOVE 'COMPLETED_DATETIME'  TO TABLE-ELEMENT-3             
              MOVE WS-M-PREMISE-NO       TO HOSTVAR-ELEMENT-1           
              MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1           
              MOVE WS-TODAY              TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       5545-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5550-CHECK-SO-DATA.                                              
                                                                        
           EXEC SQL                                                     
            SELECT TOP(1) 'Y'                                                 
              INTO  :WS-EXISTS-DATA-FG51                                
              FROM  CSS_SO_DATA WITH(READUNCOMMITTED)                           
             WHERE  PREMISE_NO      = :WS-M-PREMISE-NO                  
               AND  SERV_ORDER_NO  <> :WS-ORDER-NO                      
               AND  ORDER_STATE_CD NOT IN ('Z','C')                     
               AND  (ASSIGNED_DATETIME < CIS.CHAR2TIMESTAMP(
                                                  :WS-ASSIGNED-DATETIME
              ))         
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  'Y'                                                         
MFA-TR*       INTO  :WS-EXISTS-DATA-FG51                                        
MFA-TR*       FROM  CSS_SO_DATA                                                 
MFA-TR*      WHERE  PREMISE_NO      = :WS-M-PREMISE-NO                          
MFA-TR*        AND  SERV_ORDER_NO  <> :WS-ORDER-NO                              
MFA-TR*        AND  ORDER_STATE_CD NOT IN ('Z','C')                             
MFA-TR*        AND  (ASSIGNED_DATETIME < :WS-ASSIGNED-DATETIME)                 
MFA-TR*      FETCH FIRST 1 ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 5550                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5550'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-2             
              MOVE 'ASSIGNED_DATETIME'   TO TABLE-ELEMENT-3             
              MOVE WS-M-PREMISE-NO       TO HOSTVAR-ELEMENT-1           
              MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-2           
              MOVE WS-ASSIGNED-DATETIME  TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       5550-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5555-CHECK-SO-ORDER-INST.                                        
                                                                        
           EXEC SQL                                                     
            SELECT TOP(1) 'Y'                                                 
              INTO  :WS-EXISTS-DATA-FG52                                
              FROM  CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED),                 
                    CSS_SO_MTR_CHG MC WITH(READUNCOMMITTED)                     
P01176       WHERE  OI.WORK_TYPE_CD       IN ('UNB', 'MCU')             
               AND  MC.CODE_MTR_STATUS_WS = 'K'                         
               AND  OI.SERV_ORDER_NO      = :WS-ORDER-NO                
               AND  OI.SERV_ORDER_NO      = MC.SERV_ORDER_NO            
               AND  OI.CODE_UTIL_TYPE     = MC.CODE_UTIL_TYPE           
               AND  OI.IC_NO              = MC.IC_NO                    
               AND  OI.MTR_REF_NO         = MC.MTR_REF_NO               
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  'Y'                                                         
MFA-TR*       INTO  :WS-EXISTS-DATA-FG52                                        
MFA-TR*       FROM  CSS_SO_ORDER_INST OI,                                       
MFA-TR*             CSS_SO_MTR_CHG MC                                           
MFA-TR*      WHERE  OI.WORK_TYPE_CD       IN ('UNB', 'MCU')                     
MFA-TR*        AND  MC.CODE_MTR_STATUS_WS = 'K'                                 
MFA-TR*        AND  OI.SERV_ORDER_NO      = :WS-ORDER-NO                        
MFA-TR*        AND  OI.SERV_ORDER_NO      = MC.SERV_ORDER_NO                    
MFA-TR*        AND  OI.CODE_UTIL_TYPE     = MC.CODE_UTIL_TYPE                   
MFA-TR*        AND  OI.IC_NO              = MC.IC_NO                            
MFA-TR*        AND  OI.MTR_REF_NO         = MC.MTR_REF_NO                       
MFA-TR*      FETCH FIRST 1 ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 5555                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5555'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                     
              MOVE 'CSS_SO_MTR_CHG'      TO TABLE-2                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
            END-IF.                                                     
                                                                        
       5555-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5560-CHECK-SO-ORDER-INST.                                        
                                                                        
           EXEC SQL                                                     
            SELECT TOP(1) 'Y'                                                 
              INTO  :WS-EXISTS-DATA-FG53                                
              FROM  CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                  
                   ,CSS_MTRD_ENVRNMT MP WITH(READUNCOMMITTED)                   
             WHERE  OI.WORK_TYPE_CD      IN ('SOL', 'SOS', 'SOR')       
               AND  MP.CODE_METER_STATUS <> 'K'                         
               AND  OI.SERV_ORDER_NO     = :WS-ORDER-NO                 
               AND  MP.ACCOUNT_NO        = :WS-M-ACCOUNT-NO-PRIOR       
               AND  MP.CODE_UTIL_TYPE    = OI.CODE_UTIL_TYPE            
               AND  MP.IC_NO             = OI.IC_NO                     
               AND  MP.MTR_REF_NO        = OI.MTR_REF_NO                
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  'Y'                                                         
MFA-TR*       INTO  :WS-EXISTS-DATA-FG53                                        
MFA-TR*       FROM  CSS_SO_ORDER_INST OI                                        
MFA-TR*            ,CSS_MTRD_ENVRNMT MP                                         
MFA-TR*      WHERE  OI.WORK_TYPE_CD      IN ('SOL', 'SOS', 'SOR')               
MFA-TR*        AND  MP.CODE_METER_STATUS <> 'K'                                 
MFA-TR*        AND  OI.SERV_ORDER_NO     = :WS-ORDER-NO                         
MFA-TR*        AND  MP.ACCOUNT_NO        = :WS-M-ACCOUNT-NO-PRIOR               
MFA-TR*        AND  MP.CODE_UTIL_TYPE    = OI.CODE_UTIL_TYPE                    
MFA-TR*        AND  MP.IC_NO             = OI.IC_NO                             
MFA-TR*        AND  MP.MTR_REF_NO        = OI.MTR_REF_NO                        
MFA-TR*      FETCH FIRST 1 ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 5560                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5560'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                     
              MOVE 'CSS_MTRD_ENV_PARTL'  TO TABLE-2                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE WS-ORDER-NO           TO HOSTVAR-ELEMENT-1           
              MOVE WS-M-ACCOUNT-NO-PRIOR TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       5560-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5565-CHECK-SO-ORDER-INST.                                        
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG54                             
                  FROM CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED),              
                       CSS_SO_MTR_CHG MC WITH(READUNCOMMITTED),                 
                       CSS_MTRD_ENVRNMT MP WITH(READUNCOMMITTED)                
                 WHERE OI.WORK_TYPE_CD NOT IN ('SOL', 'SOS',            
C33887            'SOR', 'MTC', 'FIN', 'IXC',' ')                       
                   AND MC.CODE_MTR_STATUS_IS  <> 'K'                    
                   AND MP.CODE_METER_STATUS    = 'K'                    
                   AND OI.SERV_ORDER_NO        = :WS-ORDER-NO           
                   AND OI.SERV_ORDER_NO        = MC.SERV_ORDER_NO       
                   AND OI.CODE_UTIL_TYPE       = MC.CODE_UTIL_TYPE      
                   AND OI.IC_NO                = MC.IC_NO               
                   AND OI.MTR_REF_NO           = MC.MTR_REF_NO          
                   AND MP.ACCOUNT_NO           = :WS-M-ACCOUNT-NO-PRIOR 
                   AND MP.CODE_UTIL_TYPE       = OI.CODE_UTIL_TYPE      
                   AND MP.IC_NO                = OI.IC_NO               
                   AND MP.MTR_REF_NO           = OI.MTR_REF_NO          
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG54                                     
MFA-TR*           FROM CSS_SO_ORDER_INST OI,                                    
MFA-TR*                CSS_SO_MTR_CHG MC,                                       
MFA-TR*                CSS_MTRD_ENVRNMT MP                                      
MFA-TR*          WHERE OI.WORK_TYPE_CD NOT IN ('SOL', 'SOS',                    
MFA-TR*           'SOR', 'MTC', 'FIN', 'IXC',' ')                               
MFA-TR*            AND MC.CODE_MTR_STATUS_IS  <> 'K'                            
MFA-TR*            AND MP.CODE_METER_STATUS    = 'K'                            
MFA-TR*            AND OI.SERV_ORDER_NO        = :WS-ORDER-NO                   
MFA-TR*            AND OI.SERV_ORDER_NO        = MC.SERV_ORDER_NO               
MFA-TR*            AND OI.CODE_UTIL_TYPE       = MC.CODE_UTIL_TYPE              
MFA-TR*            AND OI.IC_NO                = MC.IC_NO                       
MFA-TR*            AND OI.MTR_REF_NO           = MC.MTR_REF_NO                  
MFA-TR*            AND MP.ACCOUNT_NO           = :WS-M-ACCOUNT-NO-PRIOR         
MFA-TR*            AND MP.CODE_UTIL_TYPE       = OI.CODE_UTIL_TYPE              
MFA-TR*            AND MP.IC_NO                = OI.IC_NO                       
MFA-TR*            AND MP.MTR_REF_NO           = OI.MTR_REF_NO                  
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5565                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5565'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_ORDER_INST'       TO TABLE-1                 
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-2                 
              MOVE 'CSS_MTRD_ENV_PARTL'      TO TABLE-3                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              MOVE WS-M-ACCOUNT-NO-PRIOR     TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5565-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5570-CHECK-SO-DATA.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG55                             
                  FROM CSS_SO_DATA WITH(READUNCOMMITTED)                        
                 WHERE PREMISE_NO = :WS-M-PREMISE-NO                    
                   AND ORDER_TYPE_CD = 'CC002'                          
                   AND ORDER_STATE_CD NOT IN ('Z', 'C')                 
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG55                                     
MFA-TR*           FROM CSS_SO_DATA                                              
MFA-TR*          WHERE PREMISE_NO = :WS-M-PREMISE-NO                            
MFA-TR*            AND ORDER_TYPE_CD = 'CC002'                                  
MFA-TR*            AND ORDER_STATE_CD NOT IN ('Z', 'C')                         
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5570                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5570'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-M-PREMISE-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5570-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5575-CHECK-SO-DATA.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG56                             
                  FROM CSS_SO_DATA WITH(READUNCOMMITTED)                        
                 WHERE PREMISE_NO = :WS-M-PREMISE-NO                    
                   AND ORDER_TYPE_CD = 'OFF02'                          
                   AND ORDER_STATE_CD NOT IN ('Z', 'C')                 
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG56                                     
MFA-TR*           FROM CSS_SO_DATA                                              
MFA-TR*          WHERE PREMISE_NO = :WS-M-PREMISE-NO                            
MFA-TR*            AND ORDER_TYPE_CD = 'OFF02'                                  
MFA-TR*            AND ORDER_STATE_CD NOT IN ('Z', 'C')                         
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5575                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5575'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-M-PREMISE-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5575-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5580-CHECK-SO-MTR-VAL.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG57                             
                  FROM CSS_SO_MTR_VAL WITH(READUNCOMMITTED)                     
                 WHERE CODE_UTIL_TYPE = 'G'                             
                   AND SERV_ORDER_NO = :WS-ORDER-NO                     
                   AND CITY_GATE_ID   = '       '                       
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG57                                     
MFA-TR*           FROM CSS_SO_MTR_VAL                                           
MFA-TR*          WHERE CODE_UTIL_TYPE = 'G'                                     
MFA-TR*            AND SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*            AND CITY_GATE_ID   = '       '                               
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5580                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5580'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_VAL'          TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'G'                       TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5580-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5585-CHECK-SO-METER.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG58                             
                  FROM CSS_SO_METER WITH(READUNCOMMITTED)                       
                 WHERE SERV_ORDER_NO   = :WS-ORDER-NO                   
                   AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE              
                   AND METER_NO       = :WS-METER-NO                    
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG58                                     
MFA-TR*           FROM CSS_SO_METER                                             
MFA-TR*          WHERE SERV_ORDER_NO   = :WS-ORDER-NO                           
MFA-TR*            AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                      
MFA-TR*            AND METER_NO       = :WS-METER-NO                            
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5585                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5585'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'METER_NO'                TO TABLE-ELEMENT-3         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE WS-METER-NO               TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5585-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       5590-CHECK-SO-REGISTER.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG59                             
                  FROM  CSS_SO_REGISTER WITH(READUNCOMMITTED)                   
                 WHERE SERV_ORDER_NO   = :WS-ORDER-NO                   
                    AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE             
                    AND METER_NO       = :WS-METER-NO                   
                    AND REG_ID_NO     = :WS-REG-ID                      
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG59                                     
MFA-TR*           FROM  CSS_SO_REGISTER                                         
MFA-TR*          WHERE SERV_ORDER_NO   = :WS-ORDER-NO                           
MFA-TR*             AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                     
MFA-TR*             AND METER_NO       = :WS-METER-NO                           
MFA-TR*             AND REG_ID_NO     = :WS-REG-ID                              
MFA-TR*           FETCH FIRST 1 ROW ONLY WITH UR                                
MFA-TR*           QUERYNO 5590                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5590'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_REGISTER'         TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'METER_NO'                TO TABLE-ELEMENT-3         
              MOVE 'REG_ID_NO'               TO TABLE-ELEMENT-4         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE WS-METER-NO               TO HOSTVAR-ELEMENT-3       
              MOVE WS-REG-ID                 TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5590-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5595-CHECK-SO-MTR-CHG.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG60                             
                  FROM CSS_SO_MTR_CHG WITH(READUNCOMMITTED)                     
                 WHERE SERV_ORDER_NO   = :WS-ORDER-NO                   
                   AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE              
                   AND METER_NO       = :WS-METER-NO                    
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG60                                     
MFA-TR*           FROM CSS_SO_MTR_CHG                                           
MFA-TR*          WHERE SERV_ORDER_NO   = :WS-ORDER-NO                           
MFA-TR*            AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                      
MFA-TR*            AND METER_NO       = :WS-METER-NO                            
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5595                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5595'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'METER_NO'                TO TABLE-ELEMENT-3         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE WS-METER-NO               TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5595-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5600-CHECK-SO-METER-PGM.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG61                             
                  FROM CSS_METER_PGM A WITH(READUNCOMMITTED),                   
                       CSS_DMT_PGM_ID B WITH(READUNCOMMITTED)                   
                 WHERE A.CODE_UTIL_TYPE  = B.CODE_UTIL_TYPE             
                    AND A.DIGTL_MTR_TYPE = B.DIGTL_MTR_TYPE             
                    AND A.PROGRAM_ID     = B.PROGRAM_ID                 
                    AND A.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE           
                    AND A.DIGTL_MTR_TYPE = :WS-DIGTL-MTR-TYPE           
                    AND B.RATE_PLAN_NO   = :WS-RATE-PLAN-NO             
                    AND A.PROGRAM_ID     = :WS-PROGRAM-ID               
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG61                                     
MFA-TR*           FROM CSS_METER_PGM A,                                         
MFA-TR*                CSS_DMT_PGM_ID B                                         
MFA-TR*          WHERE A.CODE_UTIL_TYPE  = B.CODE_UTIL_TYPE                     
MFA-TR*             AND A.DIGTL_MTR_TYPE = B.DIGTL_MTR_TYPE                     
MFA-TR*             AND A.PROGRAM_ID     = B.PROGRAM_ID                         
MFA-TR*             AND A.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                   
MFA-TR*             AND A.DIGTL_MTR_TYPE = :WS-DIGTL-MTR-TYPE                   
MFA-TR*             AND B.RATE_PLAN_NO   = :WS-RATE-PLAN-NO                     
MFA-TR*             AND A.PROGRAM_ID     = :WS-PROGRAM-ID                       
MFA-TR*           FETCH FIRST 1 ROW ONLY WITH UR                                
MFA-TR*           QUERYNO 5600                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_METER_PGM'           TO TABLE-1                 
              MOVE 'CSS_DMT_PGM_ID'          TO TABLE-2                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'DIGTL_MTR_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-3         
              MOVE 'PROGRAM_ID'              TO TABLE-ELEMENT-4         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-DIGTL-MTR-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-3       
              MOVE WS-PROGRAM-ID             TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5600-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5605-CHECK-SO-REG-CHG.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-EXISTS-DATA-FG62                             
                  FROM CSS_SO_REG_CHG WITH(READUNCOMMITTED)                     
                 WHERE SERV_ORDER_NO  = :WS-ORDER-NO                    
                   AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE              
                   AND METER_NO       = :WS-METER-NO                    
                   AND REG_ID_NO      = :WS-REG-ID                      
                                           
A03206                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-DATA-FG62                                     
MFA-TR*           FROM CSS_SO_REG_CHG                                           
MFA-TR*          WHERE SERV_ORDER_NO  = :WS-ORDER-NO                            
MFA-TR*            AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                      
MFA-TR*            AND METER_NO       = :WS-METER-NO                            
MFA-TR*            AND REG_ID_NO      = :WS-REG-ID                              
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 5605                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5605'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_REG_CHG'          TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'METER_NO'                TO TABLE-ELEMENT-3         
              MOVE 'REG_ID_NO'               TO TABLE-ELEMENT-4         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE WS-METER-NO               TO HOSTVAR-ELEMENT-3       
              MOVE WS-REG-ID                 TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5605-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
C33886 5700-CHECK-IF-AMR-GAS.                                           
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          SELECT TOP(1) 'Y'                                              
C33886            INTO :WS-IS-AMR                                       
C33886            FROM CSS_GAS_METER  GM WITH(READUNCOMMITTED),                 
C33886                 CSS_METER_PGM  DT WITH(READUNCOMMITTED)                  
C33886           WHERE GM.CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE   
C33886             AND GM.COMPANY_NO         = :WS-AMR-COMPANY-NO       
C33886             AND GM.METER_NO           = :WS-AMR-METER-NO         
C33886             AND DT.CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE   
C33886             AND DT.DIGTL_MTR_TYPE     = GM.DIGTL_MTR_TYPE        
C33886             AND DT.PROGRAM_ID         = GM.PROGRAM_ID            
C33886             AND DT.DFLT_REMOTE_RD_IND = 'A'                      
C33886                                     
A03206                                                      
C33886     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-IS-AMR                                               
MFA-TR*           FROM CSS_GAS_METER  GM,                                       
MFA-TR*                CSS_METER_PGM  DT                                        
MFA-TR*          WHERE GM.CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE           
MFA-TR*            AND GM.COMPANY_NO         = :WS-AMR-COMPANY-NO               
MFA-TR*            AND GM.METER_NO           = :WS-AMR-METER-NO                 
MFA-TR*            AND DT.CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE           
MFA-TR*            AND DT.DIGTL_MTR_TYPE     = GM.DIGTL_MTR_TYPE                
MFA-TR*            AND DT.PROGRAM_ID         = GM.PROGRAM_ID                    
MFA-TR*            AND DT.DFLT_REMOTE_RD_IND = 'A'                              
MFA-TR*           FETCH FIRST 1 ROW ONLY WITH UR                                
MFA-TR*           QUERYNO 5700                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
C33886*                                                                         
C33886     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C33886        NEXT SENTENCE                                             
C33886     ELSE                                                         
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE '5700'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C33886        MOVE 'CSS_GAS_METER'           TO TABLE-1                 
C33886        MOVE 'CSS_METER_PGM'           TO TABLE-2                 
C33886        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
C33886        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
C33886        MOVE 'METER_NO'                TO TABLE-ELEMENT-3         
C33886        MOVE WS-AMR-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1       
C33886        MOVE WS-AMR-COMPANY-NO         TO HOSTVAR-ELEMENT-2       
C33886        MOVE WS-AMR-METER-NO           TO HOSTVAR-ELEMENT-3       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-IF.                                                      
C33886 5700-EXIT.                                                       
C33886     EXIT.                                                        
C33886*                                                                         
C33886                                                                  
C33886 5701-CHECK-IF-AMR-ELEC.                                          
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          SELECT TOP(1) 'Y'                                              
C33886            INTO :WS-IS-AMR                                       
C33886            FROM CSS_ELEC_METER     EM WITH(READUNCOMMITTED),             
C33886                 CSS_ELEC_MTR_SPEC  MS WITH(READUNCOMMITTED)              
C33886           WHERE EM.CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE   
C33886             AND EM.COMPANY_NO         = :WS-AMR-COMPANY-NO       
C33886             AND EM.METER_NO           = :WS-AMR-METER-NO         
C33886             AND MS.ELEC_MTR_SPEC_CD   = EM.ELEC_MTR_SPEC_CD      
C33886             AND MS.REMOTE_READ_CODE   IN ('A','M')               
C33886                                     
A03206                                                      
C33886     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-IS-AMR                                               
MFA-TR*           FROM CSS_ELEC_METER     EM,                                   
MFA-TR*                CSS_ELEC_MTR_SPEC  MS                                    
MFA-TR*          WHERE EM.CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE           
MFA-TR*            AND EM.COMPANY_NO         = :WS-AMR-COMPANY-NO               
MFA-TR*            AND EM.METER_NO           = :WS-AMR-METER-NO                 
MFA-TR*            AND MS.ELEC_MTR_SPEC_CD   = EM.ELEC_MTR_SPEC_CD              
MFA-TR*            AND MS.REMOTE_READ_CODE   IN ('A','M')                       
MFA-TR*           FETCH FIRST 1 ROW ONLY WITH UR                                
MFA-TR*           QUERYNO 5701                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
C33886*                                                                         
C33886     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C33886        NEXT SENTENCE                                             
C33886     ELSE                                                         
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE '5701'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C33886        MOVE 'CSS_ELEC_METER'          TO TABLE-1                 
C33886        MOVE 'CSS_ELEC_MTR_SPEC'       TO TABLE-2                 
C33886        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
C33886        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
C33886        MOVE 'METER_NO'                TO TABLE-ELEMENT-3         
C33886        MOVE WS-AMR-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1       
C33886        MOVE WS-AMR-COMPANY-NO         TO HOSTVAR-ELEMENT-2       
C33886        MOVE WS-AMR-METER-NO           TO HOSTVAR-ELEMENT-3       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-IF.                                                      
C33886 5701-EXIT.                                                       
C33886     EXIT.                                                        
C33886                                                                  
C33886 5710-CHECK-ATT-INSTALL.                                          
C33886*                                                                         
C33886     IF WS-AMR-ACTION-CODE NOT = 'R'                              
C33886          MOVE ' '                   TO WS-IS-AVAILABLE           
C33886          MOVE SPACES                TO WS-AMR-ERR                
C33886          PERFORM 5715-CHK-ATT-AVAILABLE THRU 5715-EXIT           
C33886          IF WS-AMR-ERR = 'SO386'                                 
C33886              MOVE 'SO386'            TO WS-MESSAGE-NO            
C33886              MOVE WS-AMR-REG-ID      TO WS-AMR-REG-ID-NUM        
C33886              PERFORM 8140-ADD-INTO-RESULT-TABLE                  
C33886                   THRU 8140-EXIT                                 
C33886          ELSE                                                    
C33886              MOVE 'N'               TO WS-IS-ATTCH-MTRSHOP       
C33886              PERFORM 5716-CHK-ATT-MTRSHOP THRU 5716-EXIT         
C33886              IF    WS-IS-AVAILABLE      NOT = 'A' AND            
C33886                    WS-IS-ATTCH-MTRSHOP  NOT = 'Y'                
C33886                 MOVE 'SO387'            TO WS-MESSAGE-NO         
C33886                 MOVE 0                  TO RS-RETURN-CODE        
C33886                 MOVE WS-AMR-REG-ID      TO WS-AMR-REG-ID-NUM     
C33886                 PERFORM 8140-ADD-INTO-RESULT-TABLE               
C33886                      THRU 8140-EXIT                              
C33886              ELSE                                                
C33886                 MOVE 'OK'               TO WS-AMR-INSTALL-OK     
C33886              END-IF                                              
C33886          END-IF                                                  
C33886     END-IF.                                                      
C33886                                                                  
C33886 5710-EXIT.                                                       
C33886     EXIT.                                                        
C33886                                                                  
C33886 5715-CHK-ATT-AVAILABLE.                                          
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          SELECT TOP(1) EQUIP_LOC_ID                                     
C33886            INTO :WS-IS-AVAILABLE                                 
C33886            FROM CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                 
C33886           WHERE CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE      
C33886             AND COMPANY_NO         = :WS-AMR-COMPANY-NO          
C33886             AND DEVICE_NO          = :WS-AMR-DEVICE-NO           
C33886             AND CODE_ATT_TYPE      = :WS-AMR-CODE-ATT-TYPE       
C33886                                     
A03206                                                      
C33886     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT EQUIP_LOC_ID                                             
MFA-TR*           INTO :WS-IS-AVAILABLE                                         
MFA-TR*           FROM CSS_EQUIP_ATTCHMTS                                       
MFA-TR*          WHERE CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE              
MFA-TR*            AND COMPANY_NO         = :WS-AMR-COMPANY-NO                  
MFA-TR*            AND DEVICE_NO          = :WS-AMR-DEVICE-NO                   
MFA-TR*            AND CODE_ATT_TYPE      = :WS-AMR-CODE-ATT-TYPE               
MFA-TR*           FETCH FIRST 1 ROW ONLY WITH UR                                
MFA-TR*           QUERYNO 5715                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE,         
C33886                                   RS-RETURN-CODE.                
C33886     EVALUATE  WS-ACTIVE-RETURN-CODE                              
C33886     WHEN  SUCCESSFUL-CALL                                        
C33886        CONTINUE                                                  
C33886     WHEN  NOT-FOUND                                              
C33886        MOVE 0                         TO RS-RETURN-CODE          
C33886        MOVE 'SO386'                   TO WS-AMR-ERR              
C33886     WHEN OTHER                                                   
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE '5715'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C33886        MOVE 'CSS_EQUIP_ATTCHMTS'      TO TABLE-1                 
C33886        MOVE 'CSS_METER_PGM'           TO TABLE-2                 
C33886        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
C33886        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
C33886        MOVE 'DEVICE_NO'               TO TABLE-ELEMENT-3         
C33886        MOVE WS-AMR-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1       
C33886        MOVE WS-AMR-COMPANY-NO         TO HOSTVAR-ELEMENT-2       
C33886        MOVE WS-AMR-DEVICE-NO          TO HOSTVAR-ELEMENT-3       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-EVALUATE.                                                
C33886 5715-EXIT.                                                       
C33886     EXIT.                                                        
C33886                                                                  
C33886 5716-CHK-ATT-MTRSHOP.                                            
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          SELECT TOP(1) 'Y'                                              
C33886            INTO :WS-IS-ATTCH-MTRSHOP                             
C33886            FROM CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                 
C33886           WHERE CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE      
C33886             AND COMPANY_NO         = :WS-AMR-COMPANY-NO          
C33886             AND DEVICE_NO          = :WS-AMR-DEVICE-NO           
C33886             AND CODE_ATT_TYPE      = :WS-AMR-CODE-ATT-TYPE       
C33886             AND METER_NO           = :WS-AMR-METER-NO            
C33886                                     
A03206                                                      
C33886     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-IS-ATTCH-MTRSHOP                                     
MFA-TR*           FROM CSS_METER_ATTCHMTS                                       
MFA-TR*          WHERE CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE              
MFA-TR*            AND COMPANY_NO         = :WS-AMR-COMPANY-NO                  
MFA-TR*            AND DEVICE_NO          = :WS-AMR-DEVICE-NO                   
MFA-TR*            AND CODE_ATT_TYPE      = :WS-AMR-CODE-ATT-TYPE               
MFA-TR*            AND METER_NO           = :WS-AMR-METER-NO                    
MFA-TR*           FETCH FIRST 1 ROW ONLY WITH UR                                
MFA-TR*           QUERYNO 5716                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE,         
C33886                                   RS-RETURN-CODE.                
C33886     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C33886        NEXT SENTENCE                                             
C33886     ELSE                                                         
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE '5716'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C33886        MOVE 'CSS_METER_ATTCHMTS'      TO TABLE-1                 
C33886        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
C33886        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
C33886        MOVE 'DEVICE_NO'               TO TABLE-ELEMENT-3         
C33886        MOVE 'METER_NO'                TO TABLE-ELEMENT-4         
C33886        MOVE WS-AMR-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1       
C33886        MOVE WS-AMR-COMPANY-NO         TO HOSTVAR-ELEMENT-2       
C33886        MOVE WS-AMR-DEVICE-NO          TO HOSTVAR-ELEMENT-3       
C33886        MOVE WS-AMR-METER-NO           TO HOSTVAR-ELEMENT-4       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-IF.                                                      
C33886 5716-EXIT.                                                       
C33886     EXIT.                                                        
C33886                                                                  
C33886                                                                  
C33886 5720-CHECK-ATT-REMOVE.                                           
C33886*                                                                         
C33886     IF WS-AMR-ACTION-CODE NOT = 'I'                              
C33886          MOVE ' '                   TO WS-HOW-ATTACHED           
C33886          MOVE SPACES                TO WS-AMR-ERR                
C33886          PERFORM 5715-CHK-ATT-AVAILABLE THRU 5715-EXIT           
C33886          IF WS-AMR-ERR = 'SO386'                                 
C33886              MOVE 'SO386'            TO WS-MESSAGE-NO            
C33886              MOVE WS-AMR-REG-ID      TO WS-AMR-REG-ID-NUM        
C33886              PERFORM 8140-ADD-INTO-RESULT-TABLE                  
C33886                   THRU 8140-EXIT                                 
C33886          ELSE                                                    
C33886              MOVE SPACES             TO WS-AMR-ERR               
C33886              PERFORM 5725-CHK-HOW-ATTACHED THRU 5725-EXIT        
C33886              IF WS-AMR-ERR = 'SO388'                             
C33886                  MOVE 'SO388'            TO WS-MESSAGE-NO        
C33886                  MOVE WS-AMR-REG-ID      TO WS-AMR-REG-ID-NUM    
C33886                  PERFORM 8140-ADD-INTO-RESULT-TABLE              
C33886                       THRU 8140-EXIT                             
C33886              ELSE                                                
C33886                 IF    WS-HOW-ATTACHED       = 'I' AND            
C33886                       WS-AMR-ACTION-CODE    = 'R'                
C33886                    MOVE 'SO390'         TO WS-MESSAGE-NO         
C33886                    MOVE WS-AMR-REG-ID   TO WS-AMR-REG-ID-NUM     
C33886                    PERFORM 8140-ADD-INTO-RESULT-TABLE            
C33886                         THRU 8140-EXIT                           
C33886                 ELSE                                             
C33886                    MOVE 'OK'               TO WS-AMR-REMOVE-OK   
C33886                 END-IF                                           
C33886              END-IF                                              
C33886          END-IF                                                  
C33886     END-IF.                                                      
C33886                                                                  
C33886 5720-EXIT.                                                       
C33886     EXIT.                                                        
C33886                                                                  
C33886 5725-CHK-HOW-ATTACHED.                                           
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          SELECT TOP(1) HOW_ATTACHED_CD                                  
C33886            INTO :WS-HOW-ATTACHED                                 
C33886            FROM CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                 
C33886           WHERE CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE      
C33886             AND COMPANY_NO         = :WS-AMR-COMPANY-NO          
C33886             AND DEVICE_NO          = :WS-AMR-DEVICE-NO           
C33886             AND CODE_ATT_TYPE      = :WS-AMR-CODE-ATT-TYPE       
C33886             AND METER_NO           = :WS-AMR-METER-NO            
C33886                                     
A03206                                                      
C33886     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT HOW_ATTACHED_CD                                          
MFA-TR*           INTO :WS-HOW-ATTACHED                                         
MFA-TR*           FROM CSS_METER_ATTCHMTS                                       
MFA-TR*          WHERE CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE              
MFA-TR*            AND COMPANY_NO         = :WS-AMR-COMPANY-NO                  
MFA-TR*            AND DEVICE_NO          = :WS-AMR-DEVICE-NO                   
MFA-TR*            AND CODE_ATT_TYPE      = :WS-AMR-CODE-ATT-TYPE               
MFA-TR*            AND METER_NO           = :WS-AMR-METER-NO                    
MFA-TR*           FETCH FIRST 1 ROW ONLY WITH UR                                
MFA-TR*           QUERYNO 5725                                                  
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE,         
C33886                                   RS-RETURN-CODE.                
C33886     EVALUATE WS-ACTIVE-RETURN-CODE                               
C33886     WHEN     SUCCESSFUL-CALL                                     
C33886        CONTINUE                                                  
C33886     WHEN     NOT-FOUND                                           
C33886        MOVE 0                         TO RS-RETURN-CODE          
C33886        MOVE 'SO388'                   TO WS-AMR-ERR              
C33886     WHEN     OTHER                                               
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE '5725'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C33886        MOVE 'CSS_METER_ATTCHMTS'      TO TABLE-1                 
C33886        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
C33886        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
C33886        MOVE 'DEVICE_NO'               TO TABLE-ELEMENT-3         
C33886        MOVE 'METER_NO'                TO TABLE-ELEMENT-4         
C33886        MOVE WS-AMR-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1       
C33886        MOVE WS-AMR-COMPANY-NO         TO HOSTVAR-ELEMENT-2       
C33886        MOVE WS-AMR-DEVICE-NO          TO HOSTVAR-ELEMENT-3       
C33886        MOVE WS-AMR-METER-NO           TO HOSTVAR-ELEMENT-4       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-EVALUATE.                                                
C33886 5725-EXIT.                                                       
C33886     EXIT.                                                        
C33886                                                                  
C33886 5730-CHECK-ATT-READ.                                             
C33886     IF (WS-AMR-READ-VALUE-IS=-1) AND (WS-AMR-READ-RULE='R')      
C33886         MOVE 'SO400'            TO WS-MESSAGE-NO                 
C33886         MOVE WS-AMR-REG-ID      TO WS-AMR-REG-ID-NUM             
C33886         PERFORM 8140-ADD-INTO-RESULT-TABLE                       
C33886              THRU 8140-EXIT                                      
C33886     ELSE                                                         
C33886         MOVE '  '                   TO WS-AMR-READ-OK            
C33886         MOVE '     '                TO WS-AMR-ERR                
C33886         MOVE 0                      TO WS-AMR-IDX-READ           
               MOVE 'C'                    TO WS-MTR-TABL-FL            
PALPAL         IF WS-AMR-ACTION-CODE= 'I'                               
PALPAL            PERFORM 5734-WHICH-MTR-TABLE THRU 5734-EXIT           
PALPAL         END-IF                                                   
C33886         IF WS-AMR-NEW-OR-CHG = 'C'                               
C33886           IF (WS-AMR-WORK-TYPE-CD = 'IXC' AND                    
C33886               WS-AMR-ACTION-CODE= 'I')    OR                     
                     WS-MTR-TABL-FL = 'N'                               
C33886             PERFORM 5732-IDX-READ-REG-NEW THRU 5732-EXIT         
C33886             IF  WS-AMR-ERR = 'NF100'                             
C33886                  PERFORM 5733-IDX-READ-MTR-NEW THRU 5733-EXIT    
C33886             END-IF                                               
C33886           ELSE                                                   
C33886             PERFORM 5735-IDX-READ-REG THRU 5735-EXIT             
C33886             IF  WS-AMR-ERR = 'NF100'                             
C33886                  PERFORM 5736-IDX-READ-MTR THRU 5736-EXIT        
C33886             END-IF                                               
C33886           END-IF                                                 
C33886                                                                  
C33886           IF (WS-AMR-READ-VALUE-IS>=0)                           
C33886*KW94869   IF (WS-AMR-READ-VALUE-IS>=0) AND                               
C33886*11/19/07                    WS-AMR-WORK-TYPE-CD NOT = 'IXC'              
C33886               MOVE '     '                TO WS-AMR-ERR          
C33886               PERFORM 5739-DIFF-READ    THRU 5739-EXIT           
C33886               IF  WS-AMR-ERR = 'SO401'                           
C33886                   MOVE 'SO401'            TO WS-MESSAGE-NO       
C33886                   MOVE WS-AMR-REG-ID      TO WS-AMR-REG-ID-NUM   
C33886                   PERFORM 8140-ADD-INTO-RESULT-TABLE             
C33886                       THRU 8140-EXIT                             
C33886               END-IF                                             
C33886           END-IF                                                 
C33886           MOVE 'OK'                   TO WS-AMR-READ-OK          
C33886         END-IF                                                   
C33886     END-IF.                                                      
C33886                                                                  
C33886 5730-EXIT.                                                       
C33886     EXIT.                                                        
C33886                                                                  
C33886 5732-IDX-READ-REG-NEW.                                           
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          SELECT TOP(1) LAST_READ_VALUE                                  
C33886            INTO :WS-AMR-IDX-READ                                 
C33886          FROM   CSS_SO_REGISTER WITH(READUNCOMMITTED)                    
C33886          WHERE  SERV_ORDER_NO      = :WS-ORDER-NO                
C33886            AND  CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE      
C33886            AND  IC_NO              = :WS-AMR-IC-NO               
C33886            AND  MTR_REF_NO         = :WS-AMR-MTR-REF-NO          
C33886            AND  REG_ID_NO          = :WS-AMR-REG-ID              
C33886                                    
                                                            
C33886     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT LAST_READ_VALUE                                          
MFA-TR*           INTO :WS-AMR-IDX-READ                                         
MFA-TR*         FROM   CSS_SO_REGISTER                                          
MFA-TR*         WHERE  SERV_ORDER_NO      = :WS-ORDER-NO                        
MFA-TR*           AND  CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE              
MFA-TR*           AND  IC_NO              = :WS-AMR-IC-NO                       
MFA-TR*           AND  MTR_REF_NO         = :WS-AMR-MTR-REF-NO                  
MFA-TR*           AND  REG_ID_NO          = :WS-AMR-REG-ID                      
MFA-TR*         FETCH  FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*         QUERYNO 5732                                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE,         
C33886                                   RS-RETURN-CODE.                
C33886     EVALUATE WS-ACTIVE-RETURN-CODE                               
C33886     WHEN     SUCCESSFUL-CALL                                     
C33886        CONTINUE                                                  
C33886     WHEN     NOT-FOUND                                           
C33886        MOVE 0                         TO RS-RETURN-CODE          
C33886        MOVE 'NF100'                   TO WS-AMR-ERR              
C33886     WHEN     OTHER                                               
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE '5732'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C33886        MOVE 'CSS_SO_REGISTER'         TO TABLE-1                 
C33886        MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
C33886        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
C33886        MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
C33886        MOVE WS-AMR-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-EVALUATE.                                                
C33886 5732-EXIT.                                                       
C33886     EXIT.                                                        
C33886                                                                  
C33886 5733-IDX-READ-MTR-NEW.                                           
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          SELECT TOP(1) LAST_READ_VALUE                                  
C33886            INTO :WS-AMR-IDX-READ                                 
C33886          FROM   CSS_SO_METER WITH(READUNCOMMITTED)                       
C33886          WHERE  SERV_ORDER_NO      = :WS-ORDER-NO                
C33886            AND  CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE      
C33886            AND  IC_NO              = :WS-AMR-IC-NO               
C33886            AND  MTR_REF_NO         = :WS-AMR-MTR-REF-NO          
C33886                                     
A03206                                                      
C33886     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT LAST_READ_VALUE                                          
MFA-TR*           INTO :WS-AMR-IDX-READ                                         
MFA-TR*         FROM   CSS_SO_METER                                             
MFA-TR*         WHERE  SERV_ORDER_NO      = :WS-ORDER-NO                        
MFA-TR*           AND  CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE              
MFA-TR*           AND  IC_NO              = :WS-AMR-IC-NO                       
MFA-TR*           AND  MTR_REF_NO         = :WS-AMR-MTR-REF-NO                  
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*         QUERYNO 5733                                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE,         
C33886                                   RS-RETURN-CODE.                
C33886     EVALUATE WS-ACTIVE-RETURN-CODE                               
C33886     WHEN     SUCCESSFUL-CALL                                     
C33886        CONTINUE                                                  
C33886     WHEN     NOT-FOUND                                           
C33886        MOVE 0                         TO RS-RETURN-CODE          
C33886        MOVE 'NF100'                   TO WS-AMR-ERR              
C33886     WHEN     OTHER                                               
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE '5733'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C33886        MOVE 'CSS_SO_METER'            TO TABLE-1                 
C33886        MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
C33886        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
C33886        MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
C33886        MOVE WS-AMR-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-EVALUATE.                                                
C33886 5733-EXIT.                                                       
C33886     EXIT.                                                        
C33886                                                                  
C33886 5734-WHICH-MTR-TABLE.                                            
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          SELECT TOP(1) 'N'                                              
C33886            INTO :WS-MTR-TABL-FL                                  
C33886          FROM   CSS_SO_METER WITH(READUNCOMMITTED)                       
C33886          WHERE  SERV_ORDER_NO      = :WS-ORDER-NO                
C33886            AND  CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE      
C33886            AND  IC_NO              = :WS-AMR-IC-NO               
C33886            AND  MTR_REF_NO         = :WS-AMR-MTR-REF-NO          
                  AND  METER_NO           = :WS-AMR-METER-NO            
C33886                                     
A03206                                                      
C33886     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'N'                                                      
MFA-TR*           INTO :WS-MTR-TABL-FL                                          
MFA-TR*         FROM   CSS_SO_METER                                             
MFA-TR*         WHERE  SERV_ORDER_NO      = :WS-ORDER-NO                        
MFA-TR*           AND  CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE              
MFA-TR*           AND  IC_NO              = :WS-AMR-IC-NO                       
MFA-TR*           AND  MTR_REF_NO         = :WS-AMR-MTR-REF-NO                  
MFA-TR*           AND  METER_NO           = :WS-AMR-METER-NO                    
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*         QUERYNO 5734                                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE,         
C33886                                   RS-RETURN-CODE.                
C33886     EVALUATE WS-ACTIVE-RETURN-CODE                               
C33886     WHEN     SUCCESSFUL-CALL                                     
C33886        CONTINUE                                                  
C33886     WHEN     NOT-FOUND                                           
C33886        MOVE 0                         TO RS-RETURN-CODE          
C33886        MOVE 'C'                       TO WS-MTR-TABL-FL          
C33886     WHEN     OTHER                                               
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE '5734'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C33886        MOVE 'CSS_SO_METER'            TO TABLE-1                 
C33886        MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
C33886        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
C33886        MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
C33886        MOVE WS-AMR-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-EVALUATE.                                                
C33886 5734-EXIT.                                                       
C33886     EXIT.                                                        
C33886                                                                  
C33886 5735-IDX-READ-REG.                                               
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          SELECT TOP(1) READ_VALUE_IS                                    
C33886            INTO :WS-AMR-IDX-READ                                 
C33886          FROM   CSS_SO_REG_CHG WITH(READUNCOMMITTED)                     
C33886          WHERE  SERV_ORDER_NO      = :WS-ORDER-NO                
C33886            AND  CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE      
C33886            AND  IC_NO              = :WS-AMR-IC-NO               
C33886            AND  MTR_REF_NO         = :WS-AMR-MTR-REF-NO          
C33886            AND  REG_ID_NO          = :WS-AMR-REG-ID              
C33886                                    
                                                            
C33886     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT READ_VALUE_IS                                            
MFA-TR*           INTO :WS-AMR-IDX-READ                                         
MFA-TR*         FROM   CSS_SO_REG_CHG                                           
MFA-TR*         WHERE  SERV_ORDER_NO      = :WS-ORDER-NO                        
MFA-TR*           AND  CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE              
MFA-TR*           AND  IC_NO              = :WS-AMR-IC-NO                       
MFA-TR*           AND  MTR_REF_NO         = :WS-AMR-MTR-REF-NO                  
MFA-TR*           AND  REG_ID_NO          = :WS-AMR-REG-ID                      
MFA-TR*         FETCH  FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*         QUERYNO 5735                                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE,         
C33886                                   RS-RETURN-CODE.                
C33886     EVALUATE WS-ACTIVE-RETURN-CODE                               
C33886     WHEN     SUCCESSFUL-CALL                                     
C33886        CONTINUE                                                  
C33886     WHEN     NOT-FOUND                                           
C33886        MOVE 0                         TO RS-RETURN-CODE          
C33886        MOVE 'NF100'                   TO WS-AMR-ERR              
C33886     WHEN     OTHER                                               
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE '5735'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C33886        MOVE 'CSS_SO_REG_CHG'          TO TABLE-1                 
C33886        MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
C33886        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
C33886        MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
C33886        MOVE WS-AMR-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-EVALUATE.                                                
C33886 5735-EXIT.                                                       
C33886     EXIT.                                                        
C33886                                                                  
C33886 5736-IDX-READ-MTR.                                               
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          SELECT TOP(1) READ_VALUE_IS                                    
C33886            INTO :WS-AMR-IDX-READ                                 
C33886          FROM   CSS_SO_MTR_CHG WITH(READUNCOMMITTED)                     
C33886          WHERE  SERV_ORDER_NO      = :WS-ORDER-NO                
C33886            AND  CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE      
C33886            AND  IC_NO              = :WS-AMR-IC-NO               
C33886            AND  MTR_REF_NO         = :WS-AMR-MTR-REF-NO          
C33886                                     
A03206                                                      
C33886     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT READ_VALUE_IS                                            
MFA-TR*           INTO :WS-AMR-IDX-READ                                         
MFA-TR*         FROM   CSS_SO_MTR_CHG                                           
MFA-TR*         WHERE  SERV_ORDER_NO      = :WS-ORDER-NO                        
MFA-TR*           AND  CODE_UTIL_TYPE     = :WS-AMR-CODE-UTIL-TYPE              
MFA-TR*           AND  IC_NO              = :WS-AMR-IC-NO                       
MFA-TR*           AND  MTR_REF_NO         = :WS-AMR-MTR-REF-NO                  
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*         QUERYNO 5736                                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE,         
C33886                                   RS-RETURN-CODE.                
C33886     EVALUATE WS-ACTIVE-RETURN-CODE                               
C33886     WHEN     SUCCESSFUL-CALL                                     
C33886        CONTINUE                                                  
C33886     WHEN     NOT-FOUND                                           
C33886        MOVE 0                         TO RS-RETURN-CODE          
C33886        MOVE 'NF100'                   TO WS-AMR-ERR              
C33886     WHEN     OTHER                                               
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE '5736'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C33886        MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
C33886        MOVE 'CSS_SO_METER'            TO TABLE-2                 
C33886        MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
C33886        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
C33886        MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
C33886        MOVE WS-AMR-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-EVALUATE.                                                
C33886 5736-EXIT.                                                       
C33886     EXIT.                                                        
C33886                                                                  
C33886 5739-DIFF-READ.                                                  
C33886     EXEC SQL                                                     
C33886          SELECT 'SO401'                                          
C33886          INTO   :WS-AMR-ERR                                      
C33886          FROM   CIS.SYSDUMMY1                                 
C33886          WHERE  ABS(:WS-AMR-IDX-READ -                           
C33886                     :WS-AMR-READ-VALUE-IS) > 5                   
C33886     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'SO401'                                                  
MFA-TR*         INTO   :WS-AMR-ERR                                              
MFA-TR*         FROM   SYSIBM.SYSDUMMY1                                         
MFA-TR*         WHERE  ABS(:WS-AMR-IDX-READ -                                   
MFA-TR*                    :WS-AMR-READ-VALUE-IS) > 5                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
C33886                                   RS-RETURN-CODE.                
C33886     EVALUATE WS-ACTIVE-RETURN-CODE                               
C33886        WHEN  SUCCESSFUL-CALL                                     
C33886              CONTINUE                                            
C33886        WHEN  NOT-FOUND                                           
C33886              MOVE 0                     TO RS-RETURN-CODE        
C33886              MOVE 'NF100'               TO WS-AMR-ERR            
C33886        WHEN  OTHER                                               
C33886              MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
C33886              MOVE '5739'                TO ACTIVE-PARAGRAPH      
C33886              MOVE 'SELECT'              TO ABEND-FUNCTION        
C33886              MOVE 'SYSDUMMY1'           TO TABLE-1               
C33886              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
C33886     END-EVALUATE.                                                
C33886                                                                  
C33886 5739-EXIT.                                                       
C33886     EXIT.                                                        
      *                                                                         
      *                                                                         
                                                                        
T37106 5775-VALIDATE-METER-PRESSURE.                                    
                                                                        
T37106     MOVE 'N'     TO WS-INVALID-MTR-PRESSURE.                     
                                                                        
T37106     EXEC SQL                                                     
T37106         SELECT TOP(1) 'Y'                                               
T37106           INTO :WS-INVALID-MTR-PRESSURE                          
T37106           FROM CSS_SO_METER WITH(READUNCOMMITTED)                        
T37106          WHERE SERV_ORDER_NO = :WS-ORDER-NO                      
T37106            AND CODE_UTIL_TYPE = 'G'                              
T37106            AND METER_PRESSURE NOT IN (0, 2, 5, 10, 15, 20, 30)   
T37106                                     
A03206                                                      
T37106     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-INVALID-MTR-PRESSURE                                  
MFA-TR*          FROM CSS_SO_METER                                              
MFA-TR*         WHERE SERV_ORDER_NO = :WS-ORDER-NO                              
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*           AND METER_PRESSURE NOT IN (0, 2, 5, 10, 15, 20, 30)           
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*         QUERYNO 5775                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T37106     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE,         
T37106                                   RS-RETURN-CODE.                
T37106                                                                  
T37106     EVALUATE WS-ACTIVE-RETURN-CODE                               
T37106     WHEN     SUCCESSFUL-CALL                                     
T37106        CONTINUE                                                  
T37106     WHEN     NOT-FOUND                                           
T37106        MOVE 0                         TO RS-RETURN-CODE          
T37106     WHEN     OTHER                                               
T37106        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
T37106        MOVE '5775'                    TO ACTIVE-PARAGRAPH        
T37106        MOVE 'SELECT'                  TO ABEND-FUNCTION          
T37106        MOVE 'CSS_SO_METER'            TO TABLE-1                 
T37106        MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
T37106        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
T37106        MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
T37106        MOVE 'G'                       TO HOSTVAR-ELEMENT-2       
T37106        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
T37106     END-EVALUATE.                                                
                                                                        
T37106     IF WS-INVALID-MTR-PRESSURE = 'Y'                             
T37106           MOVE 'SO406'       TO WS-MESSAGE-NO                    
T37106           MOVE WS-REG-ID     TO WS-REG-ID-NUM                    
                                                                        
T37106           PERFORM 8140-ADD-INTO-RESULT-TABLE   THRU 8140-EXIT    
T37106     END-IF.                                                      
T37106                                                                  
T37106 5775-EXIT.                                                       
T37106     EXIT.                                                        
                                                                        
A03206 5780-CHECK-SO-MATL.                                              
A03206                                                                  
A03206     EXEC SQL                                                     
A03206          SELECT TOP(1) 'Y'                                              
A03206            INTO :WS-EXISTS-SO-MATL                               
A03206            FROM CSS_SO_MATL_TRAN    WE WITH(READUNCOMMITTED)             
A03206           WHERE WE.SERV_ORDER_NO      = :WS-ORDER-NO             
A03206             AND WE.MATL_POSTED_FL     = 'N'                      
A03206                                     
A03206                                                      
A03206     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-EXISTS-SO-MATL                                       
MFA-TR*           FROM CSS_SO_MATL_TRAN    WE                                   
MFA-TR*          WHERE WE.SERV_ORDER_NO      = :WS-ORDER-NO                     
MFA-TR*            AND WE.MATL_POSTED_FL     = 'N'                              
MFA-TR*           FETCH FIRST 1 ROW ONLY WITH UR                                
MFA-TR*          QUERYNO 5780                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03206                                                                  
A03206     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
A03206                                                                  
A03206     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A03206        NEXT SENTENCE                                             
A03206     ELSE                                                         
A03206        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
A03206        MOVE '5780'                    TO ACTIVE-PARAGRAPH        
A03206        MOVE 'SELECT'                  TO ABEND-FUNCTION          
A03206        MOVE 'CSS_SO_MATL_TRAN'        TO TABLE-1                 
A03206        MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
A03206        MOVE WS-SERV-ORDER-NO          TO HOSTVAR-ELEMENT-1       
A03206        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
A03206     END-IF.                                                      
A03206 5780-EXIT.                                                       
A03206     EXIT.                                                        
                                                                        
       7100-PROCESS-MTR-DATA.                                           
                                                                        
           MOVE 0                      TO WS-MIN-UNITS                  
           MOVE 0                      TO WS-MAX-UNITS                  
                                                                        
           PERFORM 7110-OPEN-MTR-DATA-CURSOR   THRU 7110-EXIT           
           PERFORM 7120-FETCH-MTR-DATA-CURSOR  THRU 7120-EXIT           
                                                                        
           MOVE 'N'                    TO WS-NEW-METER-FLAG             
           MOVE WS-MIN-UNITS           TO WS-HOLD-MIN-UNITS             
           MOVE WS-MAX-UNITS           TO WS-HOLD-MAX-UNITS             
                                                                        
           PERFORM 7140-CHECK-MTR-DATA         THRU 7140-EXIT           
             UNTIL NO-MTR-ROWS                                          
                                                                        
           PERFORM 7130-CLOSE-MTR-DATA-CURSOR  THRU 7130-EXIT           
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-OPEN-MTR-DATA-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
                OPEN METER_DATA                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'CSS_SO_MTR_VAL'          TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7120-FETCH-MTR-DATA-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                       METER_DATA                                       
                 INTO                                                   
                      :WS-METER-NO                                      
                     ,:WS-REG-ID                                        
                     ,:WS-SO-MTRREG-LAST-READ-VALUE                     
                     ,:WS-MTRREG-LAST-REG-READ                          
                     ,:WS-SO-MTRREG-READ-VALUE-IS                       
                     ,:WS-MIN-UNITS                                     
                     ,:WS-MAX-UNITS                                     
                     ,:WS-MTRREG-CONSTANT                               
                     ,:WS-MTRREG-DIALS                                  
                     ,:WS-SO-MTRREG-CONSTANT                            
                     ,:WS-SO-MTRREG-DIALS                               
                     ,:WS-CODE-USAGE-TYPE                               
                     ,:WS-CODE-UTIL-TYPE                                
                     ,:WS-MTR-READ-SOURCE-CD                            
                     ,:WS-LAST-REG-READ-DATE                            
                     ,:WS-CODE-MTR-STATUS-WS                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                         RS-RETURN-CODE.                
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE 'Y'                    TO WS-MTR-ROWS           
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7120'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'FETCH'                TO ABEND-FUNCTION        
                   MOVE 'CSS_SO_MTR_CHG'       TO TABLE-1               
                   MOVE 'CSS_SO_MTR_VAL'       TO TABLE-2               
                   MOVE 'SERV_ORDER_NO'        TO TABLE-ELEMENT-1       
                   MOVE WS-ORDER-NO            TO HOSTVAR-ELEMENT-1     
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7120-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       7130-CLOSE-MTR-DATA-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
                CLOSE METER_DATA                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'CSS_SO_MTR_VAL'          TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
       7140-CHECK-MTR-DATA.                                             
           MOVE  SPACES                TO WS-PARM-NO-DIALS              
           MOVE  SPACES                TO WS-PARM-CONSTANTS             
                                                                        
           PERFORM 7142-COMPUTE-MIN-MAX-UNITS  THRU 7142-EXIT           
A01360     PERFORM 7143-GET-NUMBER-OF-DAYS     THRU 7143-EXIT           
                                                                        
           IF WS-MAX-UNITS = 0 AND WS-HOLD-MAX-UNITS > 0                
              MOVE WS-HOLD-MAX-UNITS   TO WS-MAX-UNITS                  
           END-IF                                                       
                                                                        
           IF WS-MIN-UNITS = 0 AND WS-HOLD-MIN-UNITS > 0                
A01360        AND (WS-NO-OF-DAYS > 0) THEN                              
              MOVE WS-HOLD-MIN-UNITS   TO WS-MIN-UNITS                  
           END-IF                                                       
                                                                        
           MOVE 'N'                    TO WS-METER-EXISTS               
                                                                        
      *****************************************************************         
      * CML 26018                                                     *         
      * ARE #DIALS BEING CHANGED BY MC001?                            *         
      *****************************************************************         
           IF WS-ORDER-TYPE-CD = 'MC001'                                
              PERFORM 5585-CHECK-SO-METER      THRU 5585-EXIT           
              IF EXISTS-DATA-FG58                                       
                 MOVE 'Y'              TO WS-METER-EXISTS               
              END-IF                                                    
           END-IF                                                       
                                                                        
      *****************************************************************         
      * MN READ HAS CHANGED SINCE PANEL 15                            *         
      *****************************************************************         
                                                                        
           IF (WS-MTRREG-LAST-REG-READ NOT =                            
                       WS-SO-MTRREG-LAST-READ-VALUE)                    
               MOVE 'SO021'            TO WS-MESSAGE-NO                 
               MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
           END-IF                                                       
                                                                        
           PERFORM 5278-GET-RATE-PLAN-NO       THRU 5278-EXIT           
                                                                        
           PERFORM 7500-CHECK-HI-LOW-EXIST-MTR THRU 7500-EXIT           
                                                                        
      ******************************************************************        
      * NUMBER OF DIALS IS INCORRECT                                   *        
      ******************************************************************        
           IF WS-MTRREG-DIALS NOT = WS-SO-MTRREG-DIALS AND              
              WS-METER-EXISTS = 'N'                                     
                                                                        
              MOVE 'SO046'             TO WS-MESSAGE-NO                 
              MOVE WS-REG-ID           TO WS-REG-ID-NUM                 
                                                                        
              PERFORM 2010-MOVE-RESULTS                                 
                 THRU 2010-EXIT                                         
                                                                        
              MOVE WS-MTRREG-DIALS        TO WS-MTRREG-DIALS-NUM        
              MOVE WS-MTRREG-DIALS-NUM    TO RS-NO-DIALS                
              MOVE WS-MTRREG-CONSTANT     TO WS-MTRREG-CONSTANT-NUM     
              MOVE WS-MTRREG-CONSTANT-NUM TO RS-CONSTANT                
                                                                        
              PERFORM 2000A-MOVE-RESULT                                 
                 THRU 2000A-EXIT                                        
              PERFORM 8100-SEND-RESULT                                  
                 THRU 8100-EXIT                                         
           END-IF                                                       
                                                                        
           PERFORM 7120-FETCH-MTR-DATA-CURSOR  THRU 7120-EXIT           
A04558     MOVE WS-MIN-UNITS           TO WS-HOLD-MIN-UNITS             
A04558     MOVE WS-MAX-UNITS           TO WS-HOLD-MAX-UNITS             
           .                                                            
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7142-COMPUTE-MIN-MAX-UNITS.                                      
                                                                        
           EXEC SQL                                                     
A00501       SELECT
              ((:WS-MAX-UNITS)*((CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                 :WS-COMPLETED-DATETIME
              ) IS NULL OR (PATINDEX('%.%', :WS-COMPLETED-DATETIME
              ) <> 0) OR (LEN(:WS-COMPLETED-DATETIME
              ) <> 10), CIS.CHAR2DATE(:WS-COMPLETED-DATETIME
              ), CONVERT(DATE, :WS-COMPLETED-DATETIME) ) )        
                                    - CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                 :WS-LAST-REG-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-REG-READ-DATE
              ) <> 0) OR (LEN(:WS-LAST-REG-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-REG-READ-DATE
              ), CONVERT(DATE, :WS-LAST-REG-READ-DATE) ) )))),
              ((:WS-MIN-UNITS)*((CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                 :WS-COMPLETED-DATETIME
              ) IS NULL OR (PATINDEX('%.%', :WS-COMPLETED-DATETIME
              ) <> 0) OR (LEN(:WS-COMPLETED-DATETIME
              ) <> 10), CIS.CHAR2DATE(:WS-COMPLETED-DATETIME
              ), CONVERT(DATE, :WS-COMPLETED-DATETIME) ) )        
                                    - CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                 :WS-LAST-REG-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-REG-READ-DATE
              ) <> 0) OR (LEN(:WS-LAST-REG-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-REG-READ-DATE
              ), CONVERT(DATE, :WS-LAST-REG-READ-DATE) ) ))))
            INTO
              :WS-MAX-UNITS,
              :WS-MIN-UNITS    
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET  :WS-MAX-UNITS =  MULTIPLY_ALT(:WS-MAX-UNITS ,                 
MFA-TR*                            (DAYS(:WS-COMPLETED-DATETIME)                
MFA-TR*                             - DAYS(:WS-LAST-REG-READ-DATE)))            
MFA-TR*          ,:WS-MIN-UNITS =  MULTIPLY_ALT(:WS-MIN-UNITS ,                 
MFA-TR*                            (DAYS(:WS-COMPLETED-DATETIME)                
MFA-TR*                             - DAYS(:WS-LAST-REG-READ-DATE)))            
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                                        
           .                                                            
       7142-EXIT.                                                       
            EXIT.                                                       
                                                                        
A01360 7143-GET-NUMBER-OF-DAYS.                                         
                                                                        
A01360     EXEC SQL                                                     
A01360       SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-COMPLETED-DATETIME
              ) IS NULL OR (PATINDEX('%.%', :WS-COMPLETED-DATETIME
              ) <> 0) OR (LEN(:WS-COMPLETED-DATETIME
              ) <> 10), CIS.CHAR2DATE(:WS-COMPLETED-DATETIME
              ), CONVERT(DATE, :WS-COMPLETED-DATETIME) ))-             
A01360                         CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                 :WS-LAST-REG-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-REG-READ-DATE
              ) <> 0) OR (LEN(:WS-LAST-REG-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-REG-READ-DATE
              ), CONVERT(DATE, :WS-LAST-REG-READ-DATE) ))
            INTO
              :WS-NO-OF-DAYS       
A01360      END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET  :WS-NO-OF-DAYS =                                              
MFA-TR*                 DAYS(DATE(:WS-COMPLETED-DATETIME))-                     
MFA-TR*                        DAYS(DATE(:WS-LAST-REG-READ-DATE))               
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                                        
           .                                                            
A01360 7143-EXIT.                                                       
A01360      EXIT.                                                       
                                                                        
       7145-HIGH-CHK-FOR-DEMAND.                                        
           IF WS-SO-MTRREG-READ-VALUE-IS > WS-MAX-UNITS                 
               MOVE 'SO015'            TO WS-MESSAGE-NO                 
               MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
           END-IF                                                       
           .                                                            
       7145-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7150-LOW-CHK-FOR-DEMAND.                                         
           IF WS-SO-MTRREG-READ-VALUE-IS < WS-MIN-UNITS                 
               MOVE 'SO017'            TO WS-MESSAGE-NO                 
               MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
           END-IF                                                       
           .                                                            
       7150-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7155-HIGH-CHK-FOR-USAGE-RO.                                      
                                                                        
           INITIALIZE  WS-MTRREG-DIALS-POWER.                           
           PERFORM  7175-POWER-OF-MTRREG-DIALS THRU 7175-EXIT.          
           IF ((WS-SO-MTRREG-READ-VALUE-IS + WS-MTRREG-DIALS-POWER)     
                   - WS-MTRREG-LAST-REG-READ) > WS-MAX-UNITS            
                                                                        
                 MOVE 'SO016'            TO WS-MESSAGE-NO               
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
              END-IF                                                    
                                                                        
           .                                                            
       7155-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7160-LOW-CHK-FOR-USAGE-RO.                                       
              INITIALIZE WS-MTRREG-DIALS-POWER.                         
              PERFORM  7175-POWER-OF-MTRREG-DIALS THRU 7175-EXIT.       
              IF ((WS-SO-MTRREG-READ-VALUE-IS + WS-MTRREG-DIALS-POWER)  
                   - WS-MTRREG-LAST-REG-READ) < WS-MIN-UNITS            
                                                                        
                 MOVE 'SO018'            TO WS-MESSAGE-NO               
                 MOVE WS-REG-ID          TO WS-REG-ID-NUM               
                                                                        
                 PERFORM 8140-ADD-INTO-RESULT-TABLE                     
                    THRU 8140-EXIT                                      
              END-IF                                                    
           .                                                            
       7160-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7165-HIGH-CHK-FOR-USAGE-NRO.                                     
           IF (WS-SO-MTRREG-READ-VALUE-IS                               
                   - WS-MTRREG-LAST-REG-READ) > WS-MAX-UNITS            
                                                                        
               MOVE 'SO016'            TO WS-MESSAGE-NO                 
               MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
           END-IF                                                       
           .                                                            
       7165-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7170-LOW-CHK-FOR-USAGE-NRO.                                      
           IF (WS-SO-MTRREG-READ-VALUE-IS                               
                   - WS-MTRREG-LAST-REG-READ) < WS-MIN-UNITS            
                                                                        
               MOVE 'SO018'            TO WS-MESSAGE-NO                 
               MOVE WS-REG-ID          TO WS-REG-ID-NUM                 
                                                                        
               PERFORM 8140-ADD-INTO-RESULT-TABLE                       
                  THRU 8140-EXIT                                        
                                                                        
           END-IF                                                       
           .                                                            
       7170-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7175-POWER-OF-MTRREG-DIALS.                                      
                                                                        
               EXEC SQL                                                 
                   SELECT POWER(10,:WS-MTRREG-DIALS) INTO               
                   :WS-MTRREG-DIALS-POWER                               
                   FROM CIS.SYSDUMMY1                                
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*        EXEC SQL                                                         
MFA-TR*            SELECT POWER(10,:WS-MTRREG-DIALS) INTO                       
MFA-TR*            :WS-MTRREG-DIALS-POWER                                       
MFA-TR*            FROM SYSIBM.SYSDUMMY1                                        
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.  
               IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL         
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '7175'                TO ACTIVE-PARAGRAPH        
                  MOVE 'SYSIBM.SYSDUMMY1'    TO TABLE-1                 
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
               END-IF                                                   
               .                                                        
       7175-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7200-PROCESS-REG-DATA.                                           
                                                                        
           MOVE  0                     TO WS-MIN-UNITS                  
           MOVE  0                     TO WS-MAX-UNITS                  
                                                                        
           PERFORM 7210-OPEN-REG-DATA-CURSOR   THRU 7210-EXIT           
           PERFORM 7220-FETCH-REG-DATA-CURSOR  THRU 7220-EXIT           
                                                                        
           MOVE WS-MIN-UNITS           TO WS-HOLD-MIN-UNITS             
           MOVE WS-MAX-UNITS           TO WS-HOLD-MAX-UNITS             
                                                                        
           PERFORM 7240-CHECK-REG-DATA         THRU 7240-EXIT           
             UNTIL NO-REG-ROWS                                          
                                                                        
           PERFORM 7230-CLOSE-REG-DATA-CURSOR  THRU 7230-EXIT           
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-OPEN-REG-DATA-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
                OPEN REGISTER_DATA                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7210'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_SO_REG_CHG'          TO TABLE-1                 
              MOVE 'CSS_SO_MTR_VAL'          TO TABLE-2                 
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-3                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7220-FETCH-REG-DATA-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                       REGISTER_DATA                                    
                 INTO                                                   
                      :WS-METER-NO                                      
                     ,:WS-REG-ID                                        
                     ,:WS-MTRREG-LAST-REG-READ                          
                     ,:WS-SO-MTRREG-LAST-READ-VALUE                     
                     ,:WS-SO-MTRREG-READ-VALUE-IS                       
                     ,:WS-MIN-UNITS                                     
                     ,:WS-MAX-UNITS                                     
                     ,:WS-MTRREG-CONSTANT                               
                     ,:WS-MTRREG-DIALS                                  
                     ,:WS-SO-MTRREG-CONSTANT                            
                     ,:WS-SO-MTRREG-DIALS                               
                     ,:WS-CODE-USAGE-TYPE                               
                     ,:WS-CODE-UTIL-TYPE                                
                     ,:WS-MTR-READ-SOURCE-CD                            
                     ,:WS-LAST-REG-READ-DATE                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                         RS-RETURN-CODE.                
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE 'Y'                    TO WS-REG-ROWS           
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7220'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'FETCH'                TO ABEND-FUNCTION        
                   MOVE 'CSS_SO_REG_CHG'       TO TABLE-1               
                   MOVE 'CSS_SO_MTR_VAL'       TO TABLE-2               
                   MOVE 'CSS_SO_MTR_CHG'       TO TABLE-3               
                   MOVE 'SERV_ORDER_NO'        TO TABLE-ELEMENT-1       
                   MOVE WS-ORDER-NO            TO HOSTVAR-ELEMENT-1     
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7220-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7230-CLOSE-REG-DATA-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
                CLOSE REGISTER_DATA                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7230'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'CSS_SO_MTR_VAL'          TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7240-CHECK-REG-DATA.                                             
           MOVE  SPACES                TO WS-PARM-NO-DIALS              
           MOVE  SPACES                TO WS-PARM-CONSTANTS             
                                                                        
           PERFORM 7142-COMPUTE-MIN-MAX-UNITS  THRU 7142-EXIT           
A01360     PERFORM 7143-GET-NUMBER-OF-DAYS     THRU 7143-EXIT           
                                                                        
           IF WS-MAX-UNITS = 0 AND WS-HOLD-MAX-UNITS > 0                
              MOVE WS-HOLD-MAX-UNITS   TO WS-MAX-UNITS                  
           END-IF                                                       
                                                                        
           IF WS-MIN-UNITS = 0 AND WS-HOLD-MIN-UNITS > 0                
A01360        AND (WS-NO-OF-DAYS > 0) THEN                              
              MOVE WS-HOLD-MIN-UNITS   TO WS-MIN-UNITS                  
           END-IF                                                       
                                                                        
           MOVE 'N'                    TO WS-REGISTER-EXISTS            
                                                                        
      ******************************************************************        
      * CML 26018                                                      *        
      * ARE #DIALS BEING CHANGED BY MC001?                             *        
      ******************************************************************        
                                                                        
           IF WS-ORDER-TYPE-CD = 'MC001'                                
              PERFORM 5590-CHECK-SO-REGISTER   THRU 5590-EXIT           
              IF EXISTS-DATA-FG59                                       
                 MOVE 'Y'              TO WS-REGISTER-EXISTS            
              END-IF                                                    
           END-IF                                                       
                                                                        
      ******************************************************************        
      * MN READ HAS CHANGED SINCE PANEL 15                             *        
      ******************************************************************        
                                                                        
           IF (WS-MTRREG-LAST-REG-READ NOT =                            
                       WS-SO-MTRREG-LAST-READ-VALUE)                    
              MOVE 'SO021'             TO WS-MESSAGE-NO                 
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
           END-IF                                                       
                                                                        
           PERFORM 5278-GET-RATE-PLAN-NO       THRU 5278-EXIT           
                                                                        
           PERFORM 7500-CHECK-HI-LOW-EXIST-MTR THRU 7500-EXIT           
                                                                        
           IF WS-MTRREG-DIALS NOT = WS-SO-MTRREG-DIALS AND              
              WS-REGISTER-EXISTS = 'N'                                  
              MOVE 'SO046'             TO WS-MESSAGE-NO                 
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
           END-IF                                                       
                                                                        
           PERFORM 7220-FETCH-REG-DATA-CURSOR  THRU 7220-EXIT           
           .                                                            
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************                           
      * PERFORM HIGH/LOW CHECKS FOR EXISTING METERS *                           
      ***********************************************                           
                                                                        
       7500-CHECK-HI-LOW-EXIST-MTR.                                     
                                                                        
           IF WS-NEW-METER-FLAG NOT = 'Y' AND                           
              NOT (WS-MTR-READ-SOURCE-CD = 'M' OR                       
                   WS-MTR-READ-SOURCE-CD = 'S' AND                      
                   (WS-ORDER-TYPE-CD(1:3) = 'OFF' OR                    
                    WS-ORDER-TYPE-CD(1:2) = 'CC'  OR                    
                    WS-ORDER-TYPE-CD(1:2) = 'NC') ) AND                 
              WS-ORDER-TYPE-CD(1:4) NOT = 'ENDV' AND                    
              WS-ORDER-TYPE-CD NOT = 'FM008' AND                        
P00196        WS-ORDER-TYPE-CD NOT = 'FW026' AND                        
              (WS-CODE-ACCOUNT-STATUS = 'A' OR                          
                      WS-CODE-ACCOUNT-STATUS = 'P') AND                 
              NOT ( ( WS-CODE-MTR-STATUS-WS = 'J' OR                    
                      WS-CODE-MTR-STATUS-WS = 'K') AND                  
                      WS-MTRREG-LAST-REG-READ =                         
                         WS-SO-MTRREG-READ-VALUE-IS )                   
                                                                        
              MOVE SPACES              TO WS-MESSAGE-NO                 
                                                                        
              IF WS-CODE-USAGE-TYPE = 'E' OR WS-CODE-USAGE-TYPE = 'J'   
                                                                        
                 PERFORM 7145-HIGH-CHK-FOR-DEMAND                       
                    THRU 7145-EXIT                                      
                                                                        
                 MOVE SPACES           TO WS-MESSAGE-NO                 
                                                                        
                 PERFORM 7150-LOW-CHK-FOR-DEMAND                        
                    THRU 7150-EXIT                                      
                                                                        
              END-IF                                                    
                                                                        
              IF WS-CODE-USAGE-TYPE = 'B' OR WS-CODE-USAGE-TYPE = 'C'   
                 IF WS-SO-MTRREG-READ-VALUE-IS < WS-MTRREG-LAST-REG-READ
                                                                        
                    PERFORM 7155-HIGH-CHK-FOR-USAGE-RO                  
                       THRU 7155-EXIT                                   
                                                                        
                    MOVE SPACES           TO WS-MESSAGE-NO              
                                                                        
                    PERFORM 7160-LOW-CHK-FOR-USAGE-RO                   
                       THRU 7160-EXIT                                   
                                                                        
                 ELSE                                                   
                                                                        
                    PERFORM 7165-HIGH-CHK-FOR-USAGE-NRO                 
                       THRU 7165-EXIT                                   
                                                                        
                    MOVE SPACES           TO WS-MESSAGE-NO              
                                                                        
                    PERFORM 7170-LOW-CHK-FOR-USAGE-NRO                  
                       THRU 7170-EXIT                                   
                                                                        
                 END-IF                                                 
              END-IF                                                    
                                                                        
           IF WS-MAX-UNITS = 0                                          
              MOVE 'SO048'             TO WS-MESSAGE-NO                 
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
           END-IF                                                       
                                                                        
      *    IF WS-MIN-UNITS = 0                                                  
      *       MOVE 'SO049'             TO WS-MESSAGE-NO                         
      *       MOVE WS-REG-ID          TO WS-REG-ID-NUM                          
      *                                                                         
      *       PERFORM 2010-MOVE-RESULTS                                         
      *          THRU 2010-EXIT                                                 
      *                                                                         
      *       PERFORM 2000A-MOVE-RESULT                                         
      *          THRU 2000A-EXIT                                                
      *       PERFORM 8100-SEND-RESULT                                          
      *          THRU 8100-EXIT                                                 
      *    END-IF                                                               
                                                                        
      *****************************************************************         
      * METER CONSTANT IS INCORRECT                                   *         
      *****************************************************************         
                                                                        
           IF WS-MTRREG-CONSTANT NOT = WS-SO-MTRREG-CONSTANT AND        
              WS-ORDER-TYPE-CD NOT = 'MC001'                            
                                                                        
              MOVE 'SO045'             TO WS-MESSAGE-NO                 
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 2010-MOVE-RESULTS                                 
                 THRU 2010-EXIT                                         
                                                                        
              MOVE WS-MTRREG-CONSTANT     TO WS-MTRREG-CONSTANT-NUM     
              MOVE WS-MTRREG-CONSTANT-NUM TO RS-CONSTANT                
                                                                        
              PERFORM 2000A-MOVE-RESULT                                 
                 THRU 2000A-EXIT                                        
              PERFORM 8100-SEND-RESULT                                  
                 THRU 8100-EXIT                                         
           END-IF
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *      CHECK DIALS AND CONSTANTS FOR NEW METER DATA              *        
      ******************************************************************        
                                                                        
       7300-PROCESS-NEW-MTR-DATA.                                       
                                                                        
           MOVE  0                     TO WS-MIN-UNITS                  
           MOVE  0                     TO WS-MAX-UNITS                  
                                                                        
           PERFORM 7310-OPEN-NEW-MTR-DATA-CURSOR THRU 7310-EXIT         
           PERFORM 7320-FETCH-NEW-MTR-DATA-CURSOR THRU 7320-EXIT        
                                                                        
           MOVE 'Y'                    TO WS-new-meter-flag             
           MOVE 0                      TO WS-MTRREG-LAST-REG-READ       
           MOVE 0                      TO WS-SO-MTRREG-LAST-READ-VALUE  
           MOVE 0                      TO WS-SO-MTRREG-READ-VALUE-IS    
           MOVE 0                      TO WS-MIN-UNITS                  
           MOVE 0                      TO WS-MAX-UNITS                  
           MOVE SPACES                 TO WS-CODE-USAGE-TYPE            
           MOVE SPACES                 TO WS-PARM-NO-DIALS              
           MOVE SPACES                 TO WS-PARM-CONSTANT              
           MOVE 'N'                    TO WS-MTR-CHG-EXISTS             
                                                                        
           PERFORM 7340-CHECK-NEW-MTR-DATA     THRU 7340-EXIT           
             UNTIL NO-NEW-MTR-ROWS                                      
                                                                        
           PERFORM 7330-CLOSE-MTR-DATA-CURSOR  THRU 7330-EXIT           
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
       7310-OPEN-NEW-MTR-DATA-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
                OPEN NEW_METER_DATA                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'CSS_SO_MTR_VAL'          TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7320-FETCH-NEW-MTR-DATA-CURSOR.                                  
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                       NEW_METER_DATA                                   
                 INTO                                                   
                      :WS-METER-NO,                                     
                      :WS-REG-ID,                                       
                      :WS-MTRREG-CONSTANT,                              
                      :WS-MTRREG-DIALS,                                 
                      :WS-SO-MTRREG-CONSTANT,                           
                      :WS-SO-MTRREG-DIALS,                              
                      :WS-CODE-UTIL-TYPE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                         RS-RETURN-CODE.                
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE 'Y'                    TO WS-NEW-MTR-ROWS       
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7320'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'FETCH'                TO ABEND-FUNCTION        
                   MOVE 'CSS_SO_METER'         TO TABLE-1               
                   MOVE 'CSS_SO_MTR_VAL'       TO TABLE-2               
                   MOVE 'SERV_ORDER_NO'        TO TABLE-ELEMENT-1       
                   MOVE WS-ORDER-NO            TO HOSTVAR-ELEMENT-1     
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7320-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7330-CLOSE-MTR-DATA-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
                CLOSE NEW_METER_DATA                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7330'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SO_METER'            TO TABLE-1                 
              MOVE 'CSS_SO_MTR_VAL'          TO TABLE-2                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7330-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7340-CHECK-NEW-MTR-DATA.                                         
                                                                        
      ******************************************************************        
      * CML 26018                                                      *        
      * ARE #DIALS BEING CHANGED BY MC001?                             *        
      ******************************************************************        
                                                                        
           IF WS-ORDER-TYPE-CD = 'MC001'                                
                                                                        
              PERFORM 5595-CHECK-SO-MTR-CHG    THRU 5595-EXIT           
                                                                        
              IF EXISTS-DATA-FG60                                       
                 MOVE 'Y'              TO WS-MTR-CHG-EXISTS             
              END-IF                                                    
           END-IF                                                       
 MJG  ******************************************************************        
      * MN READ HAS CHANGED SINCE PANEL 15                             *        
      ******************************************************************        
      *    IF (WS-MTRREG-LAST-REG-READ NOT =                                    
      *                WS-SO-MTRREG-LAST-READ-VALUE)                            
      *       MOVE 'SO021'             TO WS-MESSAGE-NO                         
      *       MOVE WS-REG-ID          TO WS-REG-ID-NUM                          
      *                                                                         
      *       PERFORM 2010-MOVE-RESULTS                                         
      *          THRU 2010-EXIT                                                 
      *                                                                         
      *       PERFORM 2000A-MOVE-RESULT                                         
      *          THRU 2000A-EXIT                                                
      *       PERFORM 8100-SEND-RESULT                                          
      *          THRU 8100-EXIT                                                 
 MJG  *    END-IF                                                               
                                                                        
           PERFORM 5278-GET-RATE-PLAN-NO  THRU 5278-EXIT                
                                                                        
      *****************************************************************         
      * METER CONSTANT IS INCORRECT                                   *         
      *****************************************************************         
                                                                        
           IF WS-MTRREG-CONSTANT NOT = WS-SO-MTRREG-CONSTANT AND        
              WS-ORDER-TYPE-CD NOT = 'MC001'                            
              MOVE 'SO045'             TO WS-MESSAGE-NO                 
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
           END-IF.                                                      
                                                                        
p00447*****************************************************************         
p00447* METER CONSTANT EQUAL TO ZERO                                  *         
p00447*****************************************************************         
p00447                                                                  
P00447     IF WS-SO-MTRREG-CONSTANT = ZERO                              
p00447        MOVE 'SO045'             TO WS-MESSAGE-NO                 
p00447        MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
p00447        PERFORM 2010-MOVE-RESULTS                                 
p00447           THRU 2010-EXIT                                         
p00447                                                                  
p00447        MOVE WS-MTRREG-CONSTANT     TO WS-MTRREG-CONSTANT-NUM     
p00447        MOVE WS-MTRREG-CONSTANT-NUM TO RS-CONSTANT                
p00447                                                                  
p00447        PERFORM 2000A-MOVE-RESULT                                 
p00447           THRU 2000A-EXIT                                        
p00447        PERFORM 8100-SEND-RESULT                                  
p00447           THRU 8100-EXIT                                         
p00447                                                                  
p00447     END-IF.                                                      
                                                                        
      *****************************************************************         
      * Number of Dials is incorrect                                  *         
      *****************************************************************         
                                                                        
           IF WS-MTRREG-DIALS NOT = WS-SO-MTRREG-DIALS AND              
              WS-MTR-CHG-EXISTS = 'N'                                   
              MOVE 'SO046'             TO WS-MESSAGE-NO                 
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
           END-IF                                                       
                                                                        
      ******************************************************************        
      * CML28469 - CHANGES TO RESTRICT SO FROM POSTING WHEN            *        
      * RATE/PROGRAM ID COMBINATION IS INVALID.                        *        
      * MSR - 05/19/2003                                               *        
      ******************************************************************        
                                                                        
           PERFORM 5280-GET-PGM-ID             THRU 5280-EXIT           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 5285-GET-PGM-ID          THRU 5285-EXIT           
           END-IF                                                       
                                                                        
           PERFORM 5600-CHECK-SO-METER-PGM     THRU 5600-EXIT           
                                                                        
           IF NOT-EXISTS-DATA-FG61                                      
A01400        MOVE 'SO259'             TO WS-MESSAGE-NO                 
              MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
                                                                        
              PERFORM 8140-ADD-INTO-RESULT-TABLE                        
                 THRU 8140-EXIT                                         
                                                                        
           END-IF                                                       
                                                                        
           PERFORM 7320-FETCH-NEW-MTR-DATA-CURSOR THRU 7320-EXIT        
           .                                                            
       7340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-PROCESS-NEW-REG-DATA.                                       
                                                                        
           MOVE  0                     TO WS-MIN-UNITS                  
           MOVE  0                     TO WS-MAX-UNITS                  
                                                                        
           PERFORM 7410-OPEN-NEW-REG-DATA-CURSOR THRU 7410-EXIT         
           PERFORM 7420-FETCH-NEW-REG-DATA-CURSOR THRU 7420-EXIT        
                                                                        
           MOVE 0                      TO WS-MTRREG-LAST-REG-READ       
           MOVE 0                      TO WS-SO-MTRREG-LAST-READ-VALUE  
           MOVE 0                      TO WS-SO-MTRREG-READ-VALUE-IS    
           MOVE 0                      TO WS-MIN-UNITS                  
           MOVE 0                      TO WS-MAX-UNITS                  
           MOVE SPACES                 TO WS-CODE-USAGE-TYPE            
           MOVE SPACES                 TO WS-PARM-NO-DIALS              
           MOVE SPACES                 TO WS-PARM-CONSTANT              
           MOVE 'N'                    TO WS-REG-CHG-EXISTS             
                                                                        
           PERFORM 7440-CHECK-NEW-REG-DATA     THRU 7440-EXIT           
             UNTIL NO-NEW-REG-ROWS                                      
                                                                        
           PERFORM 7430-CLOSE-REG-DATA-CURSOR  THRU 7430-EXIT           
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7410-OPEN-NEW-REG-DATA-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
               OPEN NEW_REGISTER_DATA                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7410'                 TO ACTIVE-PARAGRAPH           
              MOVE 'OPEN'                 TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_SO_REGISTER'      TO TABLE-1                    
              MOVE 'CSS_SO_MTR_VAL'       TO TABLE-2                    
              MOVE 'SERV_ORDER_NO'        TO TABLE-ELEMENT-1            
              MOVE WS-ORDER-NO            TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7420-FETCH-NEW-REG-DATA-CURSOR.                                  
      *                                                                         
           EXEC SQL                                                     
             FETCH   NEW_REGISTER_DATA                                  
             INTO    :WS-METER-NO                                       
                    ,:WS-REG-ID                                         
                    ,:WS-MTRREG-CONSTANT                                
                    ,:WS-MTRREG-DIALS                                   
                    ,:WS-SO-MTRREG-CONSTANT                             
                    ,:WS-SO-MTRREG-DIALS                                
                    ,:WS-CODE-UTIL-TYPE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                    TO WS-NEW-REG-ROWS      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7420'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'FETCH'                TO ABEND-FUNCTION       
                    MOVE 'CSS_SO_REGISTER'      TO TABLE-1              
                    MOVE 'CSS_SO_MTR_VAL'       TO TABLE-2              
                    MOVE 'SERV_ORDER_NO'        TO TABLE-ELEMENT-1      
                    MOVE WS-ORDER-NO            TO HOSTVAR-ELEMENT-1    
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7420-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7430-CLOSE-REG-DATA-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
                CLOSE NEW_REGISTER_DATA                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7430'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_SO_REGISTER'      TO TABLE-1                    
              MOVE 'CSS_SO_MTR_VAL'       TO TABLE-2                    
              MOVE 'SERV_ORDER_NO'        TO TABLE-ELEMENT-1            
              MOVE WS-ORDER-NO            TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
       7430-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7440-CHECK-NEW-REG-DATA.                                         
                                                                        
           IF WS-ORDER-TYPE-CD = 'MC001'                                
                                                                        
              PERFORM 5605-CHECK-SO-REG-CHG    THRU 5605-EXIT           
                                                                        
              IF EXISTS-DATA-FG62                                       
                 MOVE 'Y'              TO WS-REG-CHG-EXISTS             
              END-IF                                                    
           END-IF                                                       
                                                                        
      * ---   MN READ HAS CHANGED SINCE PANEL 15 ---                            
      *    IF (WS-MTRREG-LAST-REG-READ NOT =                                    
      *                WS-SO-MTRREG-LAST-READ-VALUE)                            
      *       MOVE 'SO021'             TO WS-MESSAGE-NO                         
      *       MOVE WS-REG-ID          TO WS-REG-ID-NUM                          
      *                                                                         
      *       PERFORM 2010-MOVE-RESULTS                                         
      *          THRU 2010-EXIT                                                 
      *                                                                         
      *       PERFORM 2000A-MOVE-RESULT                                         
      *          THRU 2000A-EXIT                                                
      *       PERFORM 8100-SEND-RESULT                                          
      *          THRU 8100-EXIT                                                 
      *    END-IF                                                               
                                                                        
           PERFORM 5278-GET-RATE-PLAN-NO  THRU 5278-EXIT                
                                                                        
           IF WS-MTRREG-CONSTANT NOT = WS-SO-MTRREG-CONSTANT AND        
              WS-ORDER-TYPE-CD NOT = 'MC001'                            
              MOVE 'SO045'             TO WS-MESSAGE-NO                 
              MOVE WS-REG-ID           TO WS-REG-ID-NUM                 
                                                                        
              PERFORM 2010-MOVE-RESULTS                                 
                 THRU 2010-EXIT                                         
                                                                        
              MOVE WS-MTRREG-CONSTANT     TO WS-MTRREG-CONSTANT-NUM     
              MOVE WS-MTRREG-CONSTANT-NUM TO RS-CONSTANT                
                                                                        
              PERFORM 2000A-MOVE-RESULT                                 
                 THRU 2000A-EXIT                                        
              PERFORM 8100-SEND-RESULT                                  
                 THRU 8100-EXIT                                         
           END-IF                                                       
p00447*****************************************************************         
p00447* METER CONSTANT EQUAL TO ZERO                                  *         
p00447*****************************************************************         
p00447                                                                  
p00447     IF WS-SO-MTRREG-CONSTANT = ZERO                              
p00447        MOVE 'SO045'             TO WS-MESSAGE-NO                 
p00447        MOVE WS-REG-ID          TO WS-REG-ID-NUM                  
p00447        PERFORM 2010-MOVE-RESULTS                                 
p00447           THRU 2010-EXIT                                         
p00447                                                                  
p00447        MOVE WS-MTRREG-CONSTANT     TO WS-MTRREG-CONSTANT-NUM     
p00447        MOVE WS-MTRREG-CONSTANT-NUM TO RS-CONSTANT                
p00447                                                                  
p00447        PERFORM 2000A-MOVE-RESULT                                 
p00447           THRU 2000A-EXIT                                        
p00447        PERFORM 8100-SEND-RESULT                                  
p00447           THRU 8100-EXIT                                         
p00447                                                                  
p00447     END-IF                                                       
                                                                        
           IF WS-MTRREG-DIALS NOT = WS-SO-MTRREG-DIALS AND              
              WS-REG-CHG-EXISTS = 'N'                                   
              MOVE 'SO046'             TO WS-MESSAGE-NO                 
              MOVE WS-REG-ID           TO WS-REG-ID-NUM                 
                                                                        
              PERFORM 2010-MOVE-RESULTS                                 
                 THRU 2010-EXIT                                         
                                                                        
              MOVE WS-MTRREG-DIALS     TO WS-MTRREG-DIALS-NUM           
              MOVE WS-MTRREG-DIALS-NUM TO RS-NO-DIALS                   
                                                                        
              PERFORM 2000A-MOVE-RESULT                                 
                 THRU 2000A-EXIT                                        
              PERFORM 8100-SEND-RESULT                                  
                 THRU 8100-EXIT                                         
           END-IF                                                       
                                                                        
           PERFORM 7420-FETCH-NEW-REG-DATA-CURSOR THRU 7420-EXIT        
           .                                                            
       7440-EXIT.                                                       
           EXIT.                                                        
                                                                        
C33886*                                                                         
C33886 7600-PROCESS-AMR-MTR.                                            
C33886*                                                                         
C33886     PERFORM 7610-OPEN-AMR-MTR-CURSOR  THRU  7610-EXIT            
C33886     PERFORM 7620-FETCH-AMR-MTR-CURSOR THRU  7620-EXIT            
C33886                                                                  
C33886     PERFORM 7640-CHECK-AMR-MTR        THRU  7640-EXIT            
C33886        UNTIL NO-AMR-MTR-ROWS                                     
C33886                                                                  
C33886     PERFORM 7630-CLOSE-AMR-MTR-CURSOR THRU  7630-EXIT            
C33886     .                                                            
C33886 7600-EXIT.                                                       
C33886     EXIT.                                                        
C33886                                                                  
C33886 7610-OPEN-AMR-MTR-CURSOR.                                        
C33886                                                                  
C33886     EXEC SQL                                                     
C33886          OPEN AMR_MTR_CUR                                        
C33886     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886                                                                  
C33886     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
C33886     IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
C33886        NEXT SENTENCE                                             
C33886     ELSE                                                         
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE SQLCODE                   TO ABEND-SQLCODE           
C33886        MOVE SQLSTATE                  TO ABEND-SQLSTATE          
C33886        MOVE '7610'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'OPEN'                    TO ABEND-FUNCTION          
C33886        MOVE 'CSS_SO_ORDER_INST'       TO TABLE-1                 
C33886        MOVE 'CSS_WKTYP_REQMTS'        TO TABLE-2                 
C33886        MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
C33886        MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-IF.                                                      
C33886                                                                  
C33886 7610-EXIT.                                                       
C33886      EXIT.                                                       
C33886                                                                  
C33886 7620-FETCH-AMR-MTR-CURSOR.                                       
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          FETCH                                                   
C33886                 AMR_MTR_CUR                                      
C33886           INTO                                                   
C33886                :WS-AMR-ORDER-TYPE-CD                             
C33886               ,:WS-AMR-COMPANY-NO                                
C33886               ,:WS-AMR-WORK-TYPE-CD                              
C33886               ,:WS-AMR-CODE-UTIL-TYPE                            
C33886               ,:WS-AMR-METER-NO                                  
C33886               ,:WS-AMR-READ-RULE                                 
C33886               ,:WS-AMR-INSTALL-RULE                              
C33886               ,:WS-AMR-REMOVE-RULE                               
C33886     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
C33886                                   RS-RETURN-CODE.                
C33886*                                                                         
C33886     EVALUATE WS-ACTIVE-RETURN-CODE                               
C33886        WHEN SUCCESSFUL-CALL                                      
C33886             CONTINUE                                             
C33886        WHEN NOT-FOUND                                            
C33886             MOVE 'Y'                    TO WS-AMR-MTR-ROWS       
C33886        WHEN OTHER                                                
C33886             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
C33886             MOVE '7620'                 TO ACTIVE-PARAGRAPH      
C33886             MOVE 'FETCH'                TO ABEND-FUNCTION        
C33886             MOVE 'CSS_SO_ORDER_INST'    TO TABLE-1               
C33886             MOVE 'CSS_WKTYP_REQMTS'     TO TABLE-2               
C33886             MOVE 'SERV_ORDER_NO'        TO TABLE-ELEMENT-1       
C33886             MOVE WS-ORDER-NO            TO HOSTVAR-ELEMENT-1     
C33886             PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
C33886     END-EVALUATE.                                                
C33886*                                                                         
C33886 7620-EXIT.                                                       
C33886      EXIT.                                                       
C33886*                                                                         
C33886 7630-CLOSE-AMR-MTR-CURSOR.                                       
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          CLOSE AMR_MTR_CUR                                       
C33886     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
C33886*                                                                         
C33886     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C33886        NEXT SENTENCE                                             
C33886     ELSE                                                         
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE '7630'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'CLOSE'                   TO ABEND-FUNCTION          
C33886        MOVE 'CSS_SO_ORDER_INST'       TO TABLE-1                 
C33886        MOVE 'CSS_WKTYP_REQMTS'        TO TABLE-2                 
C33886        MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
C33886        MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-IF.                                                      
C33886*                                                                         
C33886 7630-EXIT.                                                       
C33886      EXIT.                                                       
C33886                                                                  
C33886                                                                  
C33886 7640-CHECK-AMR-MTR.                                              
C33886     MOVE 'N'                    TO WS-IS-AMR                     
C33886                                                                  
C33886     IF WS-AMR-CODE-UTIL-TYPE = 'G'                               
C33886        IF WS-AMR-WORK-TYPE-CD = 'RAM' THEN                       
C33886            MOVE 'Y'         TO WS-IS-AMR                         
C33886        ELSE                                                      
C33886            PERFORM  5700-CHECK-IF-AMR-GAS THRU  5700-EXIT        
C33886        END-IF                                                    
C33886     END-IF                                                       
C33886                                                                  
C33886     IF WS-AMR-CODE-UTIL-TYPE = 'E'                               
C33886        IF WS-AMR-WORK-TYPE-CD = 'RAM' THEN                       
C33886            MOVE 'Y'         TO WS-IS-AMR                         
C33886        ELSE                                                      
C33886            PERFORM 5701-CHECK-IF-AMR-ELEC THRU  5701-EXIT        
C33886        END-IF                                                    
C33886     END-IF                                                       
C33886                                                                  
C33886     IF WS-IS-AMR = 'Y'                                           
C33886        MOVE '  '    TO  WS-AMR-INSTALL-OK                        
C33886        MOVE '  '    TO  WS-AMR-REMOVE-OK                         
C33886        MOVE '  '    TO  WS-AMR-READ-OK                           
PALPAL        MOVE 'N'     TO  WS-AMR-ATT-ROWS                          
C33886        PERFORM 7710-OPEN-AMR-ATT-CURSOR  THRU 7710-EXIT          
C33886        PERFORM 7720-FETCH-AMR-ATT-CURSOR THRU 7720-EXIT          
C33886        IF WS-NULL-IND-AMR = -1                                   
C33886            MOVE -1   TO WS-AMR-READ-VALUE-IS                     
C33886        END-IF                                                    
C33886        PERFORM 7740-CHECK-AMR-ATT-REQMT  THRU 7740-EXIT          
C33886            UNTIL NO-AMR-ATT-ROWS                                 
C33886        PERFORM 7730-CLOSE-AMR-ATT-CURSOR THRU 7730-EXIT          
C33886        IF WS-AMR-INSTALL-RULE = 'Y' AND WS-AMR-INSTALL-OK = '  ' 
C33886            MOVE 0              TO RS-RETURN-CODE                 
C33886            MOVE 'SO398'        TO WS-MESSAGE-NO                  
C33886            PERFORM 8140-ADD-INTO-RESULT-TABLE                    
C33886               THRU 8140-EXIT                                     
C33886        END-IF                                                    
C33886        IF WS-AMR-REMOVE-RULE  = 'Y' AND WS-AMR-REMOVE-OK  = '  ' 
C33886            MOVE 0              TO RS-RETURN-CODE                 
C33886            MOVE 'SO399'        TO WS-MESSAGE-NO                  
C33886            PERFORM 8140-ADD-INTO-RESULT-TABLE                    
C33886               THRU 8140-EXIT                                     
C33886        END-IF                                                    
C33886        IF WS-AMR-READ-RULE    = 'R' AND WS-AMR-READ-OK   = '  '  
C33886            MOVE 0              TO RS-RETURN-CODE                 
C33886            MOVE 'SO400'        TO WS-MESSAGE-NO                  
C33886            PERFORM 8140-ADD-INTO-RESULT-TABLE                    
C33886               THRU 8140-EXIT                                     
C33886        END-IF                                                    
C33886     END-IF                                                       
C33886     PERFORM 7620-FETCH-AMR-MTR-CURSOR      THRU  7620-EXIT       
C33886     .                                                            
C33886 7640-EXIT.                                                       
C33886      EXIT.                                                       
C33886                                                                  
C33886 7710-OPEN-AMR-ATT-CURSOR.                                        
C33886                                                                  
C33886     EXEC SQL                                                     
C33886          OPEN AMR_ATT_CUR                                        
C33886     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886                                                                  
C33886     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
C33886     IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
C33886        NEXT SENTENCE                                             
C33886     ELSE                                                         
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE SQLCODE                   TO ABEND-SQLCODE           
C33886        MOVE SQLSTATE                  TO ABEND-SQLSTATE          
C33886        MOVE '7710'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'OPEN'                    TO ABEND-FUNCTION          
C33886        MOVE 'CSS_SO_MTR_ATT'          TO TABLE-1                 
C33886        MOVE 'CSS_SO_MTR_ATT_CHG'      TO TABLE-2                 
C33886        MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
C33886        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
C33886        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
C33886        MOVE 'METER-NO'                TO TABLE-ELEMENT-4         
C33886        MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
C33386        MOVE WS-AMR-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2       
C33886        MOVE WS-AMR-COMPANY-NO         TO HOSTVAR-ELEMENT-3       
C33886        MOVE WS-AMR-METER-NO           TO HOSTVAR-ELEMENT-4       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-IF.                                                      
C33886                                                                  
C33886 7710-EXIT.                                                       
C33886      EXIT.                                                       
C33886                                                                  
C33886 7720-FETCH-AMR-ATT-CURSOR.                                       
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          FETCH                                                   
C33886                 AMR_ATT_CUR                                      
C33886           INTO                                                   
C33886                :WS-AMR-IC-NO                                     
C33886               ,:WS-AMR-MTR-REF-NO                                
C33886               ,:WS-AMR-REG-ID                                    
C33886               ,:WS-AMR-DEVICE-NO                                 
C33886               ,:WS-AMR-CODE-ATT-TYPE                             
C33886               ,:WS-AMR-ACTION-CODE                               
C33886               ,:WS-AMR-CODE-ACTION-REAS                          
C33886               ,:WS-AMR-READ-VALUE-IS :WS-NULL-IND-AMR             
C33886               ,:WS-AMR-HOW-ATTACHED-CD                           
C33886               ,:WS-AMR-NEW-OR-CHG                                
C33886     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
C33886                                   RS-RETURN-CODE.                
C33886*                                                                         
C33886     EVALUATE WS-ACTIVE-RETURN-CODE                               
C33886        WHEN SUCCESSFUL-CALL                                      
C33886             CONTINUE                                             
C33886        WHEN NOT-FOUND                                            
C33886             MOVE 'Y'                    TO WS-AMR-ATT-ROWS       
C33886        WHEN OTHER                                                
C33886             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
C33886             MOVE '7720'                 TO ACTIVE-PARAGRAPH      
C33886             MOVE 'FETCH'                TO ABEND-FUNCTION        
C33886             MOVE 'CSS_SO_MTR_ATT'       TO TABLE-1               
C33886             MOVE 'CSS_SO_MTR_ATT_CHG'   TO TABLE-2               
C33886             MOVE 'SERV_ORDER_NO'        TO TABLE-ELEMENT-1       
C33886             MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2       
C33886             MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-3       
C33886             MOVE 'METER-NO'             TO TABLE-ELEMENT-4       
C33886             MOVE WS-ORDER-NO            TO HOSTVAR-ELEMENT-1     
C33886             MOVE WS-AMR-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2     
C33886             MOVE WS-AMR-COMPANY-NO      TO HOSTVAR-ELEMENT-3     
C33886             MOVE WS-AMR-METER-NO        TO HOSTVAR-ELEMENT-4     
C33886             PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
C33886     END-EVALUATE.                                                
C33886*                                                                         
C33886 7720-EXIT.                                                       
C33886      EXIT.                                                       
C33886*                                                                         
C33886 7730-CLOSE-AMR-ATT-CURSOR.                                       
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          CLOSE AMR_ATT_CUR                                       
C33886     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886                                                                  
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
C33886*                                                                         
C33886     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C33886        NEXT SENTENCE                                             
C33886     ELSE                                                         
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE '7730'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'CLOSE'                   TO ABEND-FUNCTION          
C33886        MOVE 'CSS_SO_MTR_ATT'          TO TABLE-1                 
C33886        MOVE 'CSS_SO_MTR_ATT_CHG'      TO TABLE-2                 
C33886        MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
C33886        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
C33886        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
C33886        MOVE 'METER-NO'                TO TABLE-ELEMENT-4         
C33886        MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
C33886        MOVE WS-AMR-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2       
C33886        MOVE WS-AMR-COMPANY-NO         TO HOSTVAR-ELEMENT-3       
C33886        MOVE WS-AMR-METER-NO           TO HOSTVAR-ELEMENT-4       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-IF.                                                      
C33886*                                                                         
C33886 7730-EXIT.                                                       
C33886      EXIT.                                                       
C33886                                                                  
C33886                                                                  
C33886 7740-CHECK-AMR-ATT-REQMT.                                        
C33886                                                                  
C33886     IF WS-AMR-INSTALL-RULE = 'Y'                                 
C33886        PERFORM  5710-CHECK-ATT-INSTALL   THRU  5710-EXIT         
C33886     END-IF                                                       
C33886                                                                  
C33886     IF WS-AMR-REMOVE-RULE = 'Y' AND WS-AMR-ACTION-CODE  = 'R'    
C33886        PERFORM  5720-CHECK-ATT-REMOVE    THRU  5720-EXIT         
C33886     END-IF                                                       
C33886                                                                  
C33886     IF WS-AMR-READ-RULE = 'R' OR                                 
C33886        WS-AMR-READ-RULE = 'O'                                    
C33886        PERFORM  5730-CHECK-ATT-READ      THRU  5730-EXIT         
C33886     END-IF.                                                      
C33886                                                                  
C33886     PERFORM 7720-FETCH-AMR-ATT-CURSOR THRU 7720-EXIT.            
C33886     IF WS-NULL-IND-AMR = -1                                      
C33886         MOVE -1   TO WS-AMR-READ-VALUE-IS                        
C33886     END-IF.                                                      
C33886                                                                  
C33886 7740-EXIT.                                                       
C33886      EXIT.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      * Inserts the Result Set Row Into GTT.                           *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR00109_R1                         
                (                                                       
                  RETURN_CODE                                           
                 ,SO_ERROR_MSG_NO                                       
                 ,SO_ERROR_MSG_TEXT                                     
                 ,SO_OVRD_MSG_IND                                       
                 ,SO_FIX_PANEL_NO                                       
                 ,METER_NO                                              
                 ,REG_ID_NO                                             
                 ,NO_DIALS                                              
                 ,CONSTANT                                              
                 ,ERT_READ                                              
                 ,IDX_READ                                              
                )                                                       
                VALUES                                                  
                (                                                       
                  :S-RETURN-CODE                                        
                 ,:S-SO-ERROR-MSG-NO                                    
                 ,:S-SO-ERROR-MSG-TEXT                                  
                 ,:S-SO-OVRD-MSG-IND                                    
                 ,:S-SO-FIX-PANEL-NO                                    
                 ,:S-METER-NO                                           
                 ,:S-REG-ID-NO                                          
                 ,:S-NO-DIALS                                           
                 ,:S-CONSTANT                                           
                 ,:S-ERT-READ                                           
                 ,:S-IDX-READ                                           
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR00109_R1                                 
MFA-TR*         (                                                               
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,SO_ERROR_MSG_NO                                               
MFA-TR*          ,SO_ERROR_MSG_TEXT                                             
MFA-TR*          ,SO_OVRD_MSG_IND                                               
MFA-TR*          ,SO_FIX_PANEL_NO                                               
MFA-TR*          ,METER_NO                                                      
MFA-TR*          ,REG_ID_NO                                                     
MFA-TR*          ,NO_DIALS                                                      
MFA-TR*          ,CONSTANT                                                      
MFA-TR*          ,ERT_READ                                                      
MFA-TR*          ,IDX_READ                                                      
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*           :S-RETURN-CODE                                                
MFA-TR*          ,:S-SO-ERROR-MSG-NO                                            
MFA-TR*          ,:S-SO-ERROR-MSG-TEXT                                          
MFA-TR*          ,:S-SO-OVRD-MSG-IND                                            
MFA-TR*          ,:S-SO-FIX-PANEL-NO                                            
MFA-TR*          ,:S-METER-NO                                                   
MFA-TR*          ,:S-REG-ID-NO                                                  
MFA-TR*          ,:S-NO-DIALS                                                   
MFA-TR*          ,:S-CONSTANT                                                   
MFA-TR*          ,:S-ERT-READ                                                   
MFA-TR*          ,:S-IDX-READ                                                   
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8100'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR00109_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 8110-DELETE-SO-MTR-VAL THRU 8110-EXIT             
              MOVE 100                   TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Inserts the Result Set Row Into GTT.                           *        
      ******************************************************************        
      *                                                                         
       8110-DELETE-SO-MTR-VAL.                                          
           EXEC SQL                                                     
                DELETE  FROM CSS_SO_MTR_VAL                             
                WHERE SERV_ORDER_NO = :WS-ORDER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE  FROM CSS_SO_MTR_VAL                                     
MFA-TR*         WHERE SERV_ORDER_NO = :WS-ORDER-NO                              
MFA-TR*         QUERYNO 8110                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_VAL'          TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       8110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       8120-INSERT-HOLD-MTR.                                            
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR00109_R2                         
                SELECT SERV_ORDER_NO                                    
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,METER_NO                                         
                      ,MTR_REF_NO                                       
                      ,REG_ID_NO                                        
                      ,CODE_TIME_PERIOD                                 
                  FROM CSS_SO_MTR_CHG                                   
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR00109_R2                                 
MFA-TR*         SELECT SERV_ORDER_NO                                            
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,METER_NO                                                 
MFA-TR*               ,MTR_REF_NO                                               
MFA-TR*               ,REG_ID_NO                                                
MFA-TR*               ,CODE_TIME_PERIOD                                         
MFA-TR*           FROM CSS_SO_MTR_CHG                                           
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_MTR_CHG'          TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF                                                       
           .                                                            
       8120-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       8130-INSERT-HOLD-REG.                                            
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR00109_R2                         
                SELECT SERV_ORDER_NO,                                   
                       CODE_UTIL_TYPE,                                  
                       IC_NO     ,                                      
                       METER_NO  ,                                      
                       MTR_REF_NO,                                      
                       REG_ID_NO ,                                      
                       CODE_TIME_PERIOD                                 
                  FROM CSS_SO_REG_CHG                                   
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR00109_R2                                 
MFA-TR*         SELECT SERV_ORDER_NO,                                           
MFA-TR*                CODE_UTIL_TYPE,                                          
MFA-TR*                IC_NO     ,                                              
MFA-TR*                METER_NO  ,                                              
MFA-TR*                MTR_REF_NO,                                              
MFA-TR*                REG_ID_NO ,                                              
MFA-TR*                CODE_TIME_PERIOD                                         
MFA-TR*           FROM CSS_SO_REG_CHG                                           
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_REG_CHG'          TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8130-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       8140-ADD-INTO-RESULT-TABLE.                                      
                                                                        
           PERFORM 2010-MOVE-RESULTS                                    
              THRU 2010-EXIT                                            
           PERFORM 2000A-MOVE-RESULT                                    
              THRU 2000A-EXIT                                           
           PERFORM 8100-SEND-RESULT                                     
              THRU 8100-EXIT                                            
           .                                                            
       8140-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       8200-UPDATE-RESULT-TABLE.                                        
           PERFORM 8210-UPDATE-RESULT-TABLE    THRU 8210-EXIT           
           PERFORM 8220-UPDATE-RESULT-TABLE    THRU 8220-EXIT           
           PERFORM 8230-UPDATE-RESULT-TABLE    THRU 8230-EXIT           
           PERFORM 8240-UPDATE-RESULT-TABLE    THRU 8240-EXIT           
           PERFORM 8245-UPDATE-RESULT-TABLE    THRU 8245-EXIT           
                                                                        
           IF WS-FINAL-BILL-INV-WQ-EXISTS = 'Y'                         
              PERFORM 8250-UPDATE-RESULT-TABLE THRU 8250-EXIT           
           END-IF                                                       
                                                                        
           IF WS-NO-MKTG-CNT-ID-WQ-EXISTS = 'Y'                         
              PERFORM 8260-UPDATE-RESULT-TABLE THRU 8260-EXIT           
           END-IF                                                       
           .                                                            
       8200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       8210-UPDATE-RESULT-TABLE.                                        
      *                                                                         
           EXEC SQL                                                     
               UPDATE A                              
                  SET SO_ERROR_MSG_TEXT = (SELECT (RTRIM(
           B.SO_ERROR_MSG_TEXT))
            FROM CSS_SO_ERROR_MSG B
            WHERE A.SO_ERROR_MSG_NO = B.SO_ERROR_MSG_NO),
               SO_OVRD_MSG_IND = (SELECT (B.SO_OVRD_MSG_IND)
            FROM CSS_SO_ERROR_MSG B
            WHERE A.SO_ERROR_MSG_NO = B.SO_ERROR_MSG_NO),
               SO_FIX_PANEL_NO = (SELECT (B.SO_FIX_PANEL_NO)
            FROM CSS_SO_ERROR_MSG B
            WHERE A.SO_ERROR_MSG_NO = B.SO_ERROR_MSG_NO)      
               FROM #CSR00109_R1 A
              WHERE EXISTS(SELECT 1                                     
                             FROM CSS_SO_ERROR_MSG B                    
                            WHERE                                       
                             A.SO_ERROR_MSG_NO = B.SO_ERROR_MSG_NO)     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ049
MFA-TR* MSQ055
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE SESSION.CSR00109_R1    A                                  
MFA-TR*           SET (SO_ERROR_MSG_TEXT,                                       
MFA-TR*                SO_OVRD_MSG_IND,                                         
MFA-TR*                SO_FIX_PANEL_NO)                                         
MFA-TR*           = (SELECT DISTINCT (RTRIM(B.SO_ERROR_MSG_TEXT)),              
MFA-TR*                                (B.SO_OVRD_MSG_IND),                     
MFA-TR*                                (B.SO_FIX_PANEL_NO)                      
MFA-TR*                FROM CSS_SO_ERROR_MSG B                                  
MFA-TR*               WHERE A.SO_ERROR_MSG_NO = B.SO_ERROR_MSG_NO)              
MFA-TR*       WHERE EXISTS(SELECT 1                                             
MFA-TR*                      FROM CSS_SO_ERROR_MSG B                            
MFA-TR*                     WHERE                                               
MFA-TR*                      A.SO_ERROR_MSG_NO = B.SO_ERROR_MSG_NO)             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR               
                                      NOT-FOUND OR WS-811               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8210'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'SESSION.CSR00109_R1'     TO TABLE-1                 
              MOVE 'SO_ERROR_MSG_NO'         TO TABLE-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8210-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       8220-UPDATE-RESULT-TABLE.                                        
      *                                                                         
           EXEC SQL                                                     
                UPDATE #CSR00109_R1                              
                   SET SO_ERROR_MSG_TEXT = RTRIM(SO_ERROR_MSG_TEXT) + 
           ' ' + METER_NO + '.REG= ' + CAST(REG_ID_NO AS CHAR(05))             
                 WHERE METER_NO <> ' '                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE SESSION.CSR00109_R1                                      
MFA-TR*            SET SO_ERROR_MSG_TEXT = RTRIM(SO_ERROR_MSG_TEXT) ||          
MFA-TR*                ' ' || METER_NO || '.REG= ' ||                           
MFA-TR*                CAST(REG_ID_NO AS CHAR(05))                              
MFA-TR*          WHERE METER_NO <> ' '                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR               
                                      NOT-FOUND OR WS-811               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8220'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'SESSION.CSR00109_R1'     TO TABLE-1                 
              MOVE 'METER_NO'                TO TABLE-ELEMENT-1         
              MOVE WS-METER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8220-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       8230-UPDATE-RESULT-TABLE.                                        
      *                                                                         
           EXEC SQL                                                     
                UPDATE #CSR00109_R1                              
                   SET SO_ERROR_MSG_TEXT = RTRIM(SO_ERROR_MSG_TEXT) + 
           ' .CORRECT DIALS= ' + NO_DIALS                 
                 WHERE NO_DIALS <> ' '                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE SESSION.CSR00109_R1                                      
MFA-TR*            SET SO_ERROR_MSG_TEXT = RTRIM(SO_ERROR_MSG_TEXT) ||          
MFA-TR*                 ' .CORRECT DIALS= ' || NO_DIALS                         
MFA-TR*          WHERE NO_DIALS <> ' '                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR               
                                      NOT-FOUND OR WS-811               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8230'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'SESSION.CSR00109_R1'     TO TABLE-1                 
              MOVE 'NO_DIALS'                TO TABLE-ELEMENT-1         
              MOVE WS-NO-DIALS               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8230-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8240-UPDATE-RESULT-TABLE.                                        
      *                                                                         
           EXEC SQL                                                     
                UPDATE #CSR00109_R1                              
                   SET SO_ERROR_MSG_TEXT = RTRIM(SO_ERROR_MSG_TEXT) + 
           ' .CORRECT CONST= ' + CONSTANT                 
                 WHERE CONSTANT <> ' '                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE SESSION.CSR00109_R1                                      
MFA-TR*            SET SO_ERROR_MSG_TEXT = RTRIM(SO_ERROR_MSG_TEXT) ||          
MFA-TR*                 ' .CORRECT CONST= ' || CONSTANT                         
MFA-TR*          WHERE CONSTANT <> ' '                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR               
                                      NOT-FOUND OR WS-811               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8240'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'SESSION.CSR00109_R1'     TO TABLE-1                 
              MOVE 'CONSTANT'                TO TABLE-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8240-EXIT.                                                       
            EXIT.                                                       
C33886*                                                                         
C33886 8245-UPDATE-RESULT-TABLE.                                        
C33886*                                                                         
C33886     EXEC SQL                                                     
C33886          UPDATE #CSR00109_R1                              
C33886             SET SO_ERROR_MSG_TEXT = RTRIM(SO_ERROR_MSG_TEXT) + 
           ' ERT READ=' + CAST(CIS.DECIMAL2CHARCAST( ERT_READ ) AS 
               CHAR(16)) + ' IDX READ=' + CAST(CIS.DECIMAL2CHARCAST( 
           IDX_READ ) AS CHAR(16))                       
C33886           WHERE SO_ERROR_MSG_NO = 'SO401'                        
C33886     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR* MSQ051
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE SESSION.CSR00109_R1                                      
MFA-TR*            SET SO_ERROR_MSG_TEXT = RTRIM(SO_ERROR_MSG_TEXT) ||          
MFA-TR*                ' ERT READ=' ||                                          
MFA-TR*                CAST(ERT_READ AS CHAR(16)) ||                            
MFA-TR*                ' IDX READ=' ||                                          
MFA-TR*                CAST(IDX_READ AS CHAR(16))                               
MFA-TR*          WHERE SO_ERROR_MSG_NO = 'SO401'                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33886*                                                                         
C33886     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
C33886*                                                                         
C33886     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR               
C33886                                NOT-FOUND OR WS-811               
C33886        NEXT SENTENCE                                             
C33886     ELSE                                                         
C33886        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C33886        MOVE '8245'                    TO ACTIVE-PARAGRAPH        
C33886        MOVE 'UPDATE'                  TO ABEND-FUNCTION          
C33886        MOVE 'SESSION.CSR00109_R1'     TO TABLE-1                 
C33886        MOVE 'ERROR_NO'                TO TABLE-ELEMENT-1         
C33886        MOVE WS-MESSAGE-NO             TO HOSTVAR-ELEMENT-1       
C33886        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C33886     END-IF.                                                      
C33886     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
C33886        MOVE 0                         TO WS-ACTIVE-RETURN-CODE   
C33886     END-IF.                                                      
C33886*                                                                         
C33886 8245-EXIT.                                                       
C33886      EXIT.                                                       
C33886*                                                                         
                                                                        
       8250-UPDATE-RESULT-TABLE.                                        
      *                                                                         
           EXEC SQL                                                     
                UPDATE #CSR00109_R1                              
                   SET SO_ERROR_MSG_TEXT = RTRIM(SO_ERROR_MSG_TEXT) + 
           ' - WORK QUEUE SENT TO CUSTOMER ACCOUNTING'      
                 WHERE SO_ERROR_MSG_NO = 'SO078'                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE SESSION.CSR00109_R1                                      
MFA-TR*            SET SO_ERROR_MSG_TEXT = RTRIM(SO_ERROR_MSG_TEXT) ||          
MFA-TR*                ' - WORK QUEUE SENT TO CUSTOMER ACCOUNTING'              
MFA-TR*          WHERE SO_ERROR_MSG_NO = 'SO078'                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR               
                                      NOT-FOUND OR WS-811               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'SESSION.CSR00109_R1'     TO TABLE-1                 
              MOVE 'SO_ERROR_MSG_NO'         TO TABLE-ELEMENT-1         
              MOVE 'SO078'                   TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8250-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8260-UPDATE-RESULT-TABLE.                                        
      *                                                                         
           EXEC SQL                                                     
                UPDATE #CSR00109_R1                              
                   SET SO_ERROR_MSG_TEXT = RTRIM(SO_ERROR_MSG_TEXT) + 
           ' - WQ ALREADY SENT'                             
                 WHERE SO_ERROR_MSG_NO = 'SO258'                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE SESSION.CSR00109_R1                                      
MFA-TR*            SET SO_ERROR_MSG_TEXT = RTRIM(SO_ERROR_MSG_TEXT) ||          
MFA-TR*                ' - WQ ALREADY SENT'                                     
MFA-TR*          WHERE SO_ERROR_MSG_NO = 'SO258'                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR               
                                      NOT-FOUND OR WS-811               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8260'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'SESSION.CSR00109_R1'     TO TABLE-1                 
              MOVE 'SO_ERROR_MSG_NO'         TO TABLE-ELEMENT-1         
              MOVE 'SO258'                   TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8260-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8300-UPDATE-MTR-CHG.                                           *        
      ******************************************************************        
      *                                                                         
       8300-UPDATE-MTR-CHG.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) CODES_DATA_PRESENT                               
                  INTO :VO-CODES-DATA-PRESENT                           
                  FROM CSS_SO_DATA WITH(READUNCOMMITTED)                        
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
C35434                                     
A03206                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CODES_DATA_PRESENT                                       
MFA-TR*           INTO :VO-CODES-DATA-PRESENT                                   
MFA-TR*           FROM CSS_SO_DATA                                              
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 83001                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE VO-CODES-DATA-PRESENT TO WS-CODES-SO-DATA-PRESENT.      
           MOVE 'N' TO WS-CODE-SO-MTR-CHG.                              
           MOVE WS-CODES-SO-DATA-PRESENT TO VO-CODES-DATA-PRESENT.      
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_SO_DATA                                      
                   SET CODES_DATA_PRESENT = :VO-CODES-DATA-PRESENT      
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_SO_DATA                                              
MFA-TR*            SET CODES_DATA_PRESENT = :VO-CODES-DATA-PRESENT              
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*          QUERYNO 83002                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 8110-DELETE-SO-MTR-VAL THRU 8110-EXIT             
              MOVE 100                       TO WS-ACTIVE-RETURN-CODE   
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8310-UPDATE-FINAL-BILL.                                        *        
      ******************************************************************        
      *                                                                         
       8310-UPDATE-FINAL-BILL.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) CODES_DATA_PRESENT                               
                  INTO :VO-CODES-DATA-PRESENT                           
                  FROM CSS_SO_DATA WITH(READUNCOMMITTED)                        
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
C35434                                     
A03206                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CODES_DATA_PRESENT                                       
MFA-TR*           INTO :VO-CODES-DATA-PRESENT                                   
MFA-TR*           FROM CSS_SO_DATA                                              
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*          FETCH FIRST 1 ROW ONLY WITH UR                                 
MFA-TR*          QUERYNO 83101                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE VO-CODES-DATA-PRESENT TO WS-CODES-SO-DATA-PRESENT.      
           MOVE 'N' TO WS-CODE-SO-FINAL-BILL.                           
           MOVE WS-CODES-SO-DATA-PRESENT TO VO-CODES-DATA-PRESENT.      
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_SO_DATA                                      
                   SET CODES_DATA_PRESENT = :VO-CODES-DATA-PRESENT      
                 WHERE SERV_ORDER_NO = :WS-ORDER-NO                     
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_SO_DATA                                              
MFA-TR*            SET CODES_DATA_PRESENT = :VO-CODES-DATA-PRESENT              
MFA-TR*          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
MFA-TR*         QUERYNO 83102                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1         
              MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1       
              PERFORM 8110-DELETE-SO-MTR-VAL THRU 8110-EXIT             
              MOVE 100                 TO WS-ACTIVE-RETURN-CODE         
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8310-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *8320-UPDATE-CODE-NFS-CHK-AMT.                                            
      *                                                                         
      *   EXEC SQL                                                              
      *        SELECT CODES_DATA_PRESENT                                        
      *          INTO :AT-CODES-DATA-PRESENT                                    
      *          FROM CSS_ACCOUNT                                               
      *         WHERE ACCOUNT_NO = :WS-M-ACCOUNT-NO                             
      *   END-EXEC.                                                             
      *                                                                         
      *   MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.                  
      *   MOVE 'A' TO WS-CODE-NSF-CHK-AMT.                                      
      *   MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT.                  
      *                                                                         
      *   EXEC SQL                                                              
      *        UPDATE CSS_SO_DATA                                               
      *            SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT              
      *          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                        
      *                               NOT-FOUND OR WS-811                       
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '8320'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'UPDATE'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_DATA'             TO TABLE-1                         
      *       MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1                 
      *       MOVE HV-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *8320-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *8330-UPDATE-CODE-LPC.                                                    
      *    EXEC SQL                                                             
      *         SELECT CODES_DATA_PRESENT                                       
      *           INTO :AT-CODES-DATA-PRESENT                                   
      *           FROM CSS_ACCOUNT                                              
      *          WHERE ACCOUNT_NO = :WS-M-ACCOUNT-NO                            
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.                 
      *    MOVE 'A' TO WS-CODE-LPC.                                             
      *    MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT.                 
      *                                                                         
      *    EXEC SQL                                                             
      *         UPDATE CSS_SO_DATA                                              
      *            SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT              
      *          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                        
      *                               NOT-FOUND OR WS-811                       
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '8330'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'UPDATE'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_DATA'             TO TABLE-1                         
      *       MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *8330-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *8340-UPDATE-CODE-CORR.                                                   
      *                                                                         
      *    EXEC SQL                                                             
      *         SELECT CODES_DATA_PRESENT                                       
      *           INTO :AT-CODES-DATA-PRESENT                                   
      *           FROM CSS_ACCOUNT                                              
      *          WHERE ACCOUNT_NO = :WS-M-ACCOUNT-NO                            
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.                 
      *    MOVE 'A' TO WS-CODE-CORR.                                            
      *    MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT.                 
      *                                                                         
      *    EXEC SQL                                                             
      *         UPDATE CSS_SO_DATA                                              
      *            SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT              
      *          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                        
      *                               NOT-FOUND OR WS-811                       
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '8340'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'UPDATE'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_DATA'             TO TABLE-1                         
      *       MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *8340-EXIT.                                                               
      *     EXIT.                                                               
C35978* PSNC RATE PROCESSING DOES NOT USE APPLIANCES                            
      *8340-UPDATE-WATER-HEATER.                                                
      *                                                                         
      *    EXEC SQL                                                             
      *         SELECT CODES_DATA_PRESENT                                       
      *           INTO :VO-CODES-DATA-PRESENT                                   
      *           FROM CSS_SO_DATA                                              
      *          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
C35434*          FETCH FIRST 1 ROW ONLY WITH UR                                 
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE VO-CODES-DATA-PRESENT TO WS-CODES-SO-DATA-PRESENT.              
      *    MOVE 'A' TO WS-CODE-WATER-HEATER.                                    
      *    MOVE WS-CODES-SO-DATA-PRESENT TO VO-CODES-DATA-PRESENT.              
      *                                                                         
      *    EXEC SQL                                                             
      *         UPDATE CSS_SO_DATA                                              
      *            SET CODES_DATA_PRESENT = :VO-CODES-DATA-PRESENT              
      *          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '8340'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'UPDATE'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_DATA'             TO TABLE-1                         
      *       MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 8110-DELETE-SO-MTR-VAL THRU 8110-EXIT                     
      *       MOVE 100                       TO WS-ACTIVE-RETURN-CODE           
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *8340-EXIT.                                                               
      *     EXIT.                                                               
                                                                        
      *                                                                         
      *8400-UPDATE-RATE-PLAN-NO.                                                
      *                                                                         
      *    EXEC SQL                                                             
      *         UPDATE CSS_SO_UTL_CHG                                           
      *            SET RATE_PLAN_NO = '110'                                     
      *          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
      *            AND RATE_PLAN_NO = '105'                                     
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '8400'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'UPDATE'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_UTL_CHG'          TO TABLE-1                         
      *       MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *8400-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *8410-UPDATE-RATE-PLAN-NO.                                                
      *                                                                         
      *    EXEC SQL                                                             
      *        UPDATE CSS_SO_UTILITY                                            
      *           SET RATE_PLAN_NO = '32V'                                      
      *         WHERE SERV_ORDER_NO = :WS-ORDER-NO                              
      *           AND RATE_PLAN_NO = '32S'                                      
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '8410'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'UPDATE'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_UTILITY'          TO TABLE-1                         
      *       MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *8410-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *8420-UPDATE-RATE-PLAN-NO.                                                
      *                                                                         
      *    EXEC SQL                                                             
      *         UPDATE CSS_SO_UTILITY                                           
      *            SET RATE_PLAN_NO = '32S'                                     
      *          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
      *            AND RATE_PLAN_NO = '32V'                                     
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '8420'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'UPDATE'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_UTILITY'          TO TABLE-1                         
      *       MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *8420-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      *8430-UPDATE-RATE-PLAN-NO.                                                
      *                                                                         
      *    EXEC SQL                                                             
      *         UPDATE CSS_SO_UTILITY                                           
      *            SET RATE_PLAN_NO = '105'                                     
      *          WHERE SERV_ORDER_NO = :WS-ORDER-NO                             
      *            AND RATE_PLAN_NO = '110'                                     
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.                 
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME              TO ABEND-PROGRAM                   
      *       MOVE '8430'                    TO ACTIVE-PARAGRAPH                
      *       MOVE 'UPDATE'                  TO ABEND-FUNCTION                  
      *       MOVE 'CSS_SO_UTILITY'          TO TABLE-1                         
      *       MOVE 'SERV_ORDER_NO'           TO TABLE-ELEMENT-1                 
      *       MOVE WS-ORDER-NO               TO HOSTVAR-ELEMENT-1               
      *       PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *8430-EXIT.                                                               
      *     EXIT.                                                               
      *                                                                         
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR00109_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR00109_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR00109_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000B-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000B-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR00109_R2                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR00109_R2                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000B'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR00109_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000B-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 9900- JOURNAL INCLUDE                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
      *                                                                         
             IF WS-OPEN-CURSOR-C2 = 'Y'                                 
                 EXEC SQL                                               
                     OPEN C2                                            
                 END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                               
             ELSE                                                       
                 EXEC SQL                                               
                     OPEN C1                                            
                 END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                               
             END-IF.                                                    
      *                                                                         
       8900-EXIT.                                                       
               EXIT.                                                    
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
             MOVE 'N'                 TO SEND-DONE-SW.                  
             INITIALIZE GTT-RETURN-FIELDS.                              
             MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                
                                           ABEND-SQLCODE.               
             MOVE SQLERRMC            TO ABEND-SQLERRMC.                
             MOVE 'Y'                 TO WS-OPEN-CURSOR-C2.             
      *                                                                         
             EXEC SQL                                                   
                 ROLLBACK                                               
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             IF SQLCODE = 0                                             
                CONTINUE                                                
             ELSE                                                       
                MOVE 'ROLLBACK'       TO ABEND-FUNCTION                 
             END-IF.                                                    
      *                                                                         
       9000-EXIT.                                                       
               EXIT.                                                    
      *                                                                         
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8900-SEND-DONE  THRU 8900-EXIT                       
                                                                        
             
MSQ016        GOBACK.                                                  
                                                                        
        9999-EXIT.                                                      
               EXIT.                                                    
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD0023C                                                
           END-EXEC.                                                            
      ************************ End of Program **************************        
