       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSKR115.                                        
       DATE-WRITTEN.   FEB 2012.                                        
      ******************************************************************00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00000501
      **                                                              **00000601
      *********           CUSTOMER SERVICE SYSTEM              *********00000701
      *********                     DB2                        *********00000801
      **                                                              **00000601
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      **   1. INSERT/UPDATE CREDIT COLL ROWS BASED ON CSS_CRED_FORECAST*        
      **      TABLE.                                                  **        
      **   2. UPDATE CREDIT HISTORY TABLE BASED ON NOTICING RULES.    **        
      **   3. FORECASTED DETAILS ARE INSERTED INTO CSS_BILL_CRED_DET  **        
      **      TABLE.                                                  **        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      SCSKR115   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   03/02/2012  AA97148   INITIAL PROGRAM VERSION.             **        
P00599**   08/07/2012  AA97148   ADDED CURR OPEN BILL CYLE CHECK      **        
PRODIS**   11/02/2012  MJ13662   PRODUCTION ISSUE - WHEN UPDATE IS    **        
PRODIS**                         MADE TO CSS_CRED_COLL, INITIALIZE    **        
PRODIS**                         PROCESSED-CD.                        **        
I01687**   03/27/2014  VIJAY     FIX AVOID-LPC FOR BALANCE CUSTOMERS  **        
I01687**                         IN SEB (CODE IS DELETED).            **        
P00726**   07/24/2014  AA97148   CREDIT ARRANGEMENTS RELEASE 3 CHANGES**        
P00726**                         BUILD EXCEPTIONAL ROWS FOR SHORT TERM**        
P00726**                         AFTER PLAN.                          **        
ACT002**   12/18/2014  MJ13662   WHEN KEEPING 'O' (DEPOSIT NOTICE) ROW**        
ACT002**                         TO ALLOW FUTURE MERGE, SET           **        
ACT002**                         WS-MERGE-RTC-DNP TO 'Y' SO THAT      **        
ACT002**                         CODE-SPECIAL-TYPE IS UPDATED PROPERLY**        
ACT002**                         APPL 5136/ACT 002                    **        
ACT308**   01/13/2015  SS7F226   ADD CREATED-BY FIELD IN WF AREA      **        
      **   A04880                                                     **        
A05323**   09/25/2015  MJ13662   REMOVE RET CHECK AND BILL IMMED DEP  **        
A05323**                         MERGE LOGIC.                         **        
P00948**   07/08/2016  AA97148   LEAST AMOUNT DUE PROJECT CHANGES:    **        
P00948**                         ADDED NEW PAYMENT ARRANGEMENT PLAN   **        
P00948**                         SHORT TERM FLEX AFTER (STFA).        **        
ACT392**   12/20/2016  AD7F921   JOIN TABLE CSS_CRED_ARNGMENT ALONG   **        
ACT392**                         WITH CSS_CRED_ARNG_ACTN IN QUERY     **        
ACT392**                         7630 TO GET ACTIVE ARRANGEMENTS.     **        
      ******************************************************************        
      **----------------- BASIC SEQUENCE STRUCTURE -------------------**        
      *************************************************************** **        
      **         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION **        
      **         1000 - 1999     INPUT PROCESSING CONTROL PATH        **        
      **         2000 - 2999     OUTPUT PROCESSING CONTROL PATH       **        
      **         3000 - 4999     BATCH PROCESSING MODULES - NOT USED  **        
      **         5000 - 5999     COMMON PROGRAM MODULES               **        
      **         6000 - 6999     COMMON SYSTEM MODULES                **        
      **         7000 - 7999     INPUT MODULES                        **        
      **         8000 - 8999     OUTPUT MODULES                       **        
      **         9000 - 9799     TERMINATION MODULES                  **        
      **         9900 - 9999     ABEND/ABORT MODULES                  **        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSKR115'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR SCSKR115 STARTS HERE'.            
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(09)    VALUE 'SCSKR115B'.
           05  WS-PGRMNAME               PIC X(09)    VALUE 'SCSKR115'. 
           05  WS-WARNING                PIC X(01)    VALUE 'W'.        
           05  WS-MASTER                 PIC X(01)    VALUE 'M'.        
           05  WS-SCEG                   PIC X(02)    VALUE '01'.       
           05  WS-TEMP-CODE-SPECIAL-TYPE PIC X(01)    VALUE SPACES.     
           05  WS-LOW-INCOME             PIC X(03)    VALUE '100'.      
           05  WS-REGULATED              PIC X(02)    VALUE '02'.       
           05  WS-YES                    PIC X(01)    VALUE 'Y'.        
           05  WS-CL2-INDX               PIC 9(02)    VALUE 1.          
           05  WS-ROW-FOUND              PIC X(01)    VALUE 'N'.        
           05  WS-SLASHES-6              PIC X(06)    VALUE '//////'.   
           05  WS-FORECAST-ROW-FOUND     PIC X(01)    VALUE 'N'.        
           05  WS-OFF-CYCLE-BILL-FLAG    PIC X(01)    VALUE 'N'.        
           05  WS-HOLD-MED-CERT-DUE-E    PIC X(10)    VALUE SPACES.     
           05  WS-HOLD-MED-CERT-MAIL-F   PIC X(10)    VALUE SPACES.     
           05  WS-HOLD-MED-CERT-DUE-F    PIC X(10)    VALUE SPACES.     
           05  WS-HOLD-MED-CERT-ACTION-F PIC X(10)    VALUE SPACES.     
           05  WS-HOLD-MED-CERT-ACTION-G PIC X(10)    VALUE SPACES.     
           05  WS-THIRD-PARTY            PIC X(25)    VALUE             
               'THIRD PARTY BILL COPY    '.                             
           05  WS-MSG-TEXT-BUILD.                                       
               10 WS-MSG-TEXT1           PIC X(43)    VALUE             
                  'ACCT WITH NO RECV AT BILLING. THE METER IS '.        
               10 WS-MSG-TEXT2           PIC X(44)    VALUE             
                  'OFF OR REMOVED.RESEARCH & FB ACCT IF NEEDED.'.       
           05  WS-TRAN-COMMENT-TEXT      PIC X(55)    VALUE             
              'CREDIT HISTORY UPDATED BY BILLING - MASTER ACCOUNT'.     
                                                                        
       01  WS-MISC.                                                     
           05  WS-DISPLAY-SQLCODE        PIC -Z(8)9.                    
           05  RS-RETURN-CODE-DISP       PIC S9(04)   COMP VALUE 0.     
           05  WS-START-POS              PIC S9(04)   COMP VALUE 0.     
           05  WS-MI-TRAN-APPL-NO        PIC S9(04)   COMP VALUE 0.     
           05  WS-CODE-NOTICE-TYPE       PIC X(01)    VALUE SPACES.     
           05  WS-UPDATE-ACTION-IND-TB   PIC X(01)    VALUE SPACES.     
           05  WS-BILL-SUB               PIC S9(04)   COMP VALUE 0.     
           05  WS-CREDIT-GROUP-ID        PIC X(03)    VALUE SPACES.     
           05  WS-KR100-BE00-CUR-DT      PIC X(10)    VALUE SPACES.     
           05  WS-BILL-CYCLE-CLOSE-DT    PIC X(10)    VALUE SPACES.     
           05  WS-DATE-CURRENT-MAIL      PIC X(10)    VALUE SPACES.     
           05  WS-HOLD-CODE-MED-SPEC-TYPE                               
                                         PIC X(01)    VALUE SPACE.      
           05  WS-TEMP-CODE-MESSAGE-CHAR PIC X(05)    VALUE SPACES.     
           05  WS-TEMP-CODE-MESSAGE-TYPE PIC S9(05)V  COMP-3 VALUE 0.   
           05  WS-NEW-BUSINESS-DAY       PIC X(10)    VALUE SPACES.     
           05  WS-CURRENT-TIMESTAMP      PIC X(26)    VALUE SPACES.     
           05  WS-CURRENT-DATE           PIC X(10)    VALUE SPACES.     
           05  WS-HOLD-NU-ARREARS        PIC 9(09)V99.                  
           05  WS-HOLD-AMOUNT            PIC 9(09)V99.                  
           05  WS-HOLD-AMOUNT-K  REDEFINES WS-HOLD-AMOUNT.              
               10  WS-DOL-AMOUNT         PIC 9(09).                     
               10  WS-DEC-AMOUNT         PIC 9(02).                     
P00726     05  WS-HOLD-CRED-ACTN-IVR-DT  PIC X(10)    VALUE SPACES.     
P00726     05  WS-CRED-ACTN-COUNTER      PIC S9(09)  USAGE COMP VALUE 0.
                                                                        
       01  WS-WORK-FIELDS.                                              
           05  WS-CURR-WQ-ITEM           PIC S9(04)   COMP VALUE 0.     
           05  WS-BN-COUNT               PIC S9(04)   COMP VALUE 0.     
           05  WS-OFF-CYCLE-BILL-DT      PIC X(10)    VALUE SPACES.     
           05  WS-OFF-CYCLE-BILL         PIC X(02)    VALUE SPACES.     
           05  WS-CURRENT-COMPANY        PIC X(02)    VALUE SPACES.     
           05  WS-DELINQ-COUNT           PIC S9(04)   COMP VALUE +0.    
P00599     05  WS-CURR-OPEN-CYCLE-BILL-DT                               
P00599                                   PIC X(10)    VALUE SPACES.     
P00599     05  WS-CURR-OPEN-CYCLE        PIC X(02)    VALUE SPACES.     
P00599     05  WS-CURR-REV-MNTH          PIC S9(06)   VALUE 0.          
                                                                        
       01  WS-DELINQUENCY-AMT-CONSTANTS.                                
           05  WS-FIRST-NOTICE-LIMIT     PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-EPP-DELINQ-LIMIT       PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-ARREARS-LIMIT          PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-AMT-NONUTIL-ARREARS    PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-AMT-NONUTIL-WQ-MIN     PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-AMT-NU-COMBO-NOT-MIN   PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-AMT-NU-NOTICE-MIN      PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-AMT-NU-WQDELQ          PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-AMT-CBILL-NOTICE       PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-AMT-CBILL-ARR-WQ       PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-AMT-CBILL-DELQ-WQ      PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-AMT-NU-ACT-CBUR        PIC S9(4)V9(5) COMP-3 VALUE 0. 
           05  WS-AUTO-CARD-PAY-DAYS     PIC S9(4)V9(5) COMP-3 VALUE 0. 
                                                                        
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER                PIC S9(4)    COMP VALUE +137.  
               10  FILLER                PIC X(1)     VALUE 'N'.        
               10  FILLER                PIC X(1)     VALUE '4'.        
               10  FILLER                PIC S9(4)    COMP VALUE +29.   
               10  FILLER                PIC X(30)    VALUE             
                   'A DATABASE EXCEPTION OCCURRED'.                     
                                                                        
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  WS-MISC-CATEGORY-ID   PIC S9(4)    COMP.             
               10  FILLER                PIC X(01)    VALUE 'N'.        
               10  WS-ROUTING            PIC X(01)    VALUE '4'.        
               10  WS-MISC-MSG-LEN       PIC S9(04)   COMP VALUE +95.   
               10  WS-MISC-MSG-TEXT      PIC X(95).                     
                                                                        
       01  WS-NOTICE-WORK-FIELDS.                                       
           05  WS-AMT-CURRENT-BAL        PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-AMT-FIRST-BAL          PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-AMT-SECOND-BAL         PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-AMT-DNP-BAL            PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-AMT-CURRENT-BAL-NU     PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-AMT-FIRST-BAL-NU       PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-AMT-SECOND-BAL-NU      PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-AMT-WQ-NU              PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-ACTION-CR-GRP          PIC X(01)    VALUE SPACES.     
           05  WS-FORECAST-CR-GRP        PIC X(01)    VALUE SPACES.     
           05  WS-TEMP-AMT-FIRST-BAL     PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TEMP-AMT-SECOND-BAL    PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TEMP-AMT-DNP-BAL       PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TEMP-AMT-FIRST-BAL-NU  PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TEMP-AMT-SECOND-BAL-NU PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TEMP-AMT-WQ-NU         PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TEMP-DATE-FIRST-DUE    PIC X(10)    VALUE SPACES.     
           05  WS-TEMP-AMT-SPCL-FIRST-BAL                               
                                         PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TEMP-AMT-SPCL-SECOND-BAL                              
                                         PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TEMP-AMT-SPCL-DNP-BAL  PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TEMP-AMT-SPCL-FIRST-BAL-NU                            
                                         PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TEMP-AMT-SPCL-SECOND-BAL-NU                           
                                         PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TEMP-AMT-SPCL-WQ-NU    PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TOTAL-NONUTIL-ARREARS  PIC S9(9)V99 VALUE ZERO.       
           05  WS-TOTAL-DUE-AMT          PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TOTAL-ARREARS          PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TOT-NON-UTIL-CRED-BUR  PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TOTAL-UTILITY-CHARGES  PIC S9(9)V99 COMP-3 VALUE 0.   
           05  WS-TOTAL-NONUTIL-CHARGES  PIC S9(9)V99 COMP-3 VALUE 0.   
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-ARREARS-DUE-DT-NULL    PIC S9(04)   COMP VALUE 0.     
           05  WS-CURR-CHG-DUE-DT-NULL   PIC S9(04)   COMP VALUE 0.     
           05  WS-DNP-NOTICE-MAIL-DT-NULL                               
                                         PIC S9(04)   COMP VALUE 0.     
           05  WS-DNP-NOTICE-DUE-DT-NULL PIC S9(04)   COMP VALUE 0.     
           05  WS-DNP-REVIEW-DT-NULL     PIC S9(04)   COMP VALUE 0.     
           05  WS-DNP-DT-NULL            PIC S9(04)   COMP VALUE 0.     
           05  WS-IVR-CALL-DT-NULL       PIC S9(04)   COMP VALUE 0.     
           05  WS-AVOID-LPC-DT-NULL      PIC S9(04)   COMP VALUE 0.     
           05  WS-NONUTIL-WQ-DT-NULL     PIC S9(04)   COMP VALUE 0.     
           05  WS-DATE-NOTICE-MAIL-NULL  PIC S9(04)   COMP VALUE 0.     
           05  WS-DATE-CREDIT-ACTION-NULL                               
                                         PIC S9(04)   COMP VALUE 0.     
           05  WS-DATE-NOTICE-DUE-NULL   PIC S9(04)   COMP VALUE 0.     
           05  WS-DATE-BILL-NULL         PIC S9(04)   COMP VALUE 0.     
           05  WS-TOT-DUE-DT-NULL        PIC S9(04)   COMP VALUE 0.     
           05  WS-UTL-NORM-DUE-DT-NULL   PIC S9(04)   COMP VALUE 0.     
           05  WS-UTL-EXCP-DUE-DT-NULL   PIC S9(04)   COMP VALUE 0.     
           05  WS-AVOID-LPC-DT-INT-NULL  PIC S9(04)   COMP VALUE 0.     
           05  WS-ADDITIONAL-DUE-DT-NULL PIC S9(04)   COMP VALUE 0.     
           05  WS-CR-GRP-EFFECT-DT-NULL  PIC S9(04)   COMP VALUE 0.     
           05  WS-AUTO-PAYMENT-DT-NULL   PIC S9(04)   COMP VALUE 0.     
           05  WS-NONUTL-NORM-DUE-DT-NULL                               
                                         PIC S9(04)   COMP VALUE 0.     
           05  WS-NONUTL-EXCP-DUE-DT-NULL                               
                                         PIC S9(04)   COMP VALUE 0.     
P00726     05  WS-CRED-ACTN-DUE-DT-NULL  PIC S9(04)   COMP VALUE 0.     
P00726     05  WS-BILL-NO-NULL           PIC S9(04)   COMP VALUE 0.     
                                                                        
       01  WS-WORK-QUEUE-DIRECTION.                                     
           05  WS-CATEGORY-ID-276        PIC S9(04)   COMP VALUE 276.   
           05  WS-CATEGORY-ID-277        PIC S9(04)   COMP VALUE 277.   
           05  WS-CATEGORY-ID-278        PIC S9(04)   COMP VALUE 278.   
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-ON-OFF-CYCLE-IND-SW    PIC X(01)    VALUE SPACES.     
               88  WS-OFF-CYCLE-REBILL                VALUE 'O'.        
           05  WS-CREDIT-GROUP-SW        PIC X(01)    VALUE SPACE.      
               88  NON-UTIL-CRED-GRP                  VALUE 'D'.        
               88  MASTER-CRED-GRP                    VALUE 'M'.        
           05  WS-NOTICE-EXEMPT-SW       PIC X(01)    VALUE 'N'.        
               88  NOT-NOTICE-EXEMPT                  VALUE 'Y'.        
           05  WS-CREDIT-EXEMPT-SW       PIC X(01)    VALUE 'N'.        
               88  CREDIT-BUR-EXEMPT                  VALUE 'N'.        
               88  NOT-CREDIT-BUR-EXEMPT              VALUE 'Y'.        
           05  WS-ARR-EXITS-ROW-SW       PIC X(01)    VALUE 'Y'.        
               88  ARREAR-EXISTS                      VALUE 'Y'.        
               88  NOT-ARREAR-EXISTS                  VALUE 'N'.        
           05  WS-PRP-SPCL-NOTICE-SW     PIC X(01)    VALUE 'N'.        
               88  PRP-SPCL-NOTICE                    VALUE 'Y'.        
           05  WS-MASTER-WQ-SW           PIC X(01)    VALUE 'N'.        
               88  MASTER-ARREARS-WQ                  VALUE 'Y'.        
           05  WS-FIRST-TIME-SW          PIC X(01)    VALUE 'Y'.        
               88  FIRST-TIME                         VALUE 'Y'.        
               88  NOT-FIRST-TIME                     VALUE 'N'.        
           05  WS-WRITE-MNT-ROW-SW       PIC X(01)    VALUE 'Y'.        
               88  WRITE-MNT-ROW                      VALUE 'Y'.        
               88  DO-NOT-WRITE-MNT-ROW               VALUE 'N'.        
                                                                        
       01  WS-CRED-COLL-TABLE.                                          
           05  WS-CRED-COLL-TB                                          
               OCCURS 100 TIMES                                         
               INDEXED BY WS-CL-INDEX.                                  
               10  WS-ACCOUNT-NO-TB      PIC S9(13)V  COMP-3 VALUE 0.   
               10  WS-ITEM-ID-TB         PIC S9(9)    COMP VALUE 0.     
               10  WS-DATE-BILL-TB       PIC X(10)    VALUE SPACES.     
               10  WS-CODE-SPECIAL-TYPE-TB                              
                                         PIC X(01)    VALUE SPACES.     
               10  WS-CODE-FRCST-CR-GRP-TB                              
                                         PIC X(01)    VALUE SPACES.     
               10  WS-CODE-MESSAGE-TYPE-TB                              
                                         PIC S9(05)V  COMP-3 VALUE 0.   
               10  WS-DATE-CREDIT-ACTION-TB                             
                                         PIC X(10)    VALUE SPACES.     
               10  WS-DATE-NOTICE-MAIL-TB                               
                                         PIC X(10)    VALUE SPACES.     
               10  WS-DATE-NOTICE-DUE-TB PIC X(10)    VALUE SPACES.     
               10  WS-AMT-NOTICE-TB      PIC S9(09)V99 COMP-3 VALUE 0.  
               10  WS-CODE-NOTICE-TYPE-TB                               
                                         PIC X(01)    VALUE SPACES.     
               10  WS-LAST-UPDATE-TS-TB  PIC X(26)    VALUE SPACES.     
               10  WS-PROCESSED-FLAG     PIC X(01)    VALUE SPACES.     
                                                                        
       01  WS-FORECAST-VALUES-TABLE.                                    
           05  WS-FORECAST-ENTRY-TB                                     
               OCCURS 1500 TIMES                                        
               INDEXED BY TB-FORECAST-INDEX.                            
               10  WS-COMPANY-NO-CM-TB   PIC X(02)    VALUE SPACES.     
               10  WS-REVENUE-MONTH-TB   PIC S9(06)   VALUE 0.          
               10  WS-BILL-DT-TB         PIC X(10)    VALUE SPACES.     
               10  WS-BILL-CYCLE-TB      PIC X(02)    VALUE SPACES.     
               10  WS-CRED-FORECAST-CD-TB                               
                                         PIC X(02)    VALUE SPACES.     
               10  WS-ARREARS-DUE-DT-TB  PIC X(10)    VALUE SPACES.     
               10  WS-CURR-CHG-DUE-DT-TB PIC X(10)    VALUE SPACES.     
               10  WS-DNP-NOTTCE-MAIL-DT-TB                             
                                         PIC X(10)    VALUE SPACES.     
               10  WS-DNP-NOTICE-DUE-DT-TB                              
                                         PIC X(10)    VALUE SPACES.     
               10  WS-DNP-REVIEW-DT-TB   PIC X(10)    VALUE SPACES.     
               10  WS-DNP-DT-TB          PIC X(10)    VALUE SPACES.     
               10  WS-IVR-CALL-TB        PIC X(10)    VALUE SPACES.     
               10  WS-AVOID-LPC-DT-TB    PIC X(10)    VALUE SPACES.     
               10  WS-NONUTIL-WQ-DT-TB   PIC X(10)    VALUE SPACES.     
               10  WS-REG-GROUP-CD-TB    PIC X(03)    VALUE SPACES.     
               10  WS-CREDIT-GROUP-TB    PIC X(01)    VALUE SPACES.     
               10  WS-CREDIT-GROUP-ID-TB PIC X(03)    VALUE SPACES.     
               10  WS-CRED-ACCT-TYPE-CD-TB                              
                                         PIC X(01)    VALUE SPACES.     
                                                                        
       01  WS-BILL-WINDOW-TBL.                                          
           05  WS-BILL-WINDOW-ENTRY OCCURS 20 TIMES.                    
               10  WS-DATE-EXTRACT-TB    PIC X(10)    VALUE SPACES.     
               10  WS-BILL-CYCLE-BN-TB   PIC X(02)    VALUE SPACES.     
               10  WS-REVENUE-MTH-BN-TB  PIC S9(06)   VALUE 0.          
                                                                        
       01  WS-DELINQUENCY-VALUES-TABLE.                                 
           05  WS-DELINQ-VALUE-ENTRY-TB                                 
               OCCURS 30 TIMES                                          
               INDEXED BY DELQ-INDX.                                    
               15  WS-COMPANY-NO-TB      PIC X(02).                     
               15  WS-DELINQ-CD-TB       PIC X(20).                     
COB305         15 WS-DELINQ-VALUE-TB        PIC S9(4)V9(5) COMP-3 
COB305           VALUE 0.         
                                                                        
P00726 01  WS-CRED-ACTN-TABLE.                                          
P00726     05  WS-CRED-ACTN-TB                                          
P00726         OCCURS 100 TIMES                                         
P00726         INDEXED BY WS-4W-INDEX.                                  
P00726         10  WS-4W-ACCOUNT-NO-TB   PIC S9(13)V  COMP-3 VALUE 0.   
P00726         10  WS-4W-ARNG-ID-TB      PIC X(05)    VALUE SPACES.     
P00726         10  WS-4W-CRED-ARNG-SEQ-TB                               
P00726                                   PIC S9(04)   COMP VALUE 0.     
P00726         10  WS-4W-CRED-ACTN-TYPE-CD-TB                           
P00726                                   PIC X(03)    VALUE SPACES.     
P00726         10  WS-4W-CRED-ACTN-SEQ-TB                               
P00726                                   PIC S9(04)   COMP VALUE 0.     
P00726         10  WS-4W-CRED-ACTN-FCST-DT-TB                           
P00726                                   PIC X(10)    VALUE SPACES.     
P00726         10  WS-4W-CRED-ACTN-DUE-DT-TB                            
P00726                                   PIC X(10)    VALUE SPACES.     
P00726         10  WS-4W-CRED-ACTN-AM-TB PIC S9(09)V9(2)                
P00726                                                COMP-3 VALUE 0.   
P00726                                                                  
       01  WS-FORECAST-DATES.                                           
           05  WS-CURR-CHG-DUE-DT        PIC X(10)    VALUE SPACES.     
           05  WS-AVOID-LPC-DT           PIC X(10)    VALUE SPACES.     
           05  WS-ARREARS-DUE-DT         PIC X(10)    VALUE SPACES.     
           05  WS-DNP-NOTICE-MAIL-DT     PIC X(10)    VALUE SPACES.     
           05  WS-DNP-NOTICE-DUE-DT      PIC X(10)    VALUE SPACES.     
           05  WS-IVR-CALL-DT            PIC X(10)    VALUE SPACES.     
           05  WS-NONUTIL-WQ-DT          PIC X(10)    VALUE SPACES.     
           05  WS-DNP-REVIEW-DT          PIC X(10)    VALUE SPACES.     
           05  WS-DNP-DT                 PIC X(10)    VALUE SPACES.     
                                                                        
       01  WS-HOLD-CRED-COLL.                                           
           10 WS-HOLD-ACCOUNT-NO         PIC S9(13)V  COMP-3 VALUE 0.   
           10 WS-HOLD-CODE-SPECIAL-TYPE  PIC X(01)    VALUE SPACES.     
           10 WS-HOLD-DATE-NOTICE-MAIL   PIC X(10)    VALUE SPACES.     
           10 WS-HOLD-CODE-FRCST-CR-GRP  PIC X(01)    VALUE SPACES.     
           10 WS-HOLD-ITEM-ID            PIC S9(09)   COMP VALUE 0.     
           10 WS-HOLD-CODE-MESSAGE-TYPE  PIC S9(05)V  COMP-3 VALUE 0.   
           10 WS-FIRST-NOTICE-MESSAGE-TYPE                              
                                         PIC S9(05)V  COMP-3 VALUE 0.   
           10 WS-HOLD-DATE-CREDIT-ACTION PIC X(10)    VALUE SPACES.     
           10 WS-HOLD-DATE-NOTICE-DUE    PIC X(10)    VALUE SPACES.     
COB305     10 WS-HOLD-AMT-NOTICE        PIC S9(9)V9(2) COMP-3 VALUE 0.         
           10 WS-HOLD-CODE-NOTICE-TYPE   PIC X(01)    VALUE SPACES.     
           10 WS-HOLD-DATE-BILL          PIC X(10)    VALUE SPACES.     
                                                                        
      ******************************************************************        
      * CWS00010 CONTAINS DB2 ABEND VARIABLES                          *        
      ******************************************************************        
                                                                        
       COPY CWS00010.                                                           
                                                                        
      ******************************************************************        
      * WS-ABEND-SWITCH                                                *        
      ******************************************************************        
                                                                        
       COPY CWS09900.                                                           
                                                                        
      ******************************************************************        
      * CWS00038 WORKING STORAGE FOR AUTO PAYMENT DATE(CPD00338)       *        
      ******************************************************************        
                                                                        
       COPY CWS00038.                                                           
                                                                        
      ******************************************************************        
      * CWS00338 CONTAINS WS STORAGE OF AUTO CARD PAYMENT DATE CPYC    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00338                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR CODES-DATA-PRESENT                         *        
      ******************************************************************        
                                                                        
       COPY CWS00056.                                                           
                                                                        
      ******************************************************************        
      * ERROR MESSAGE COPYBOOK.                                        *        
      ******************************************************************        
                                                                        
       COPY CWS00303.                                                           
                                                                        
      ******************************************************************        
      * WORKING STORAGE SUPPLEMENTAL WQ TEXT                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0070B                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * THIS COPYBOOK CONTAINS THE FIELDS FOR THE COMMENT IN THE       *        
      * AR_TRANS_HIST TABLE.                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00136                                                  
           END-EXEC.                                                            
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR SCSKR115 ENDS HERE  '.            
                                                                        
      ******************************************************************        
      * DB2 COMMUNICATION REQUIREMENT                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_ACCOUNT       - AT                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************06810000
      *  CSS_BILL_WINDOW   - BN                                        *06811000
      ******************************************************************06812000
                                                                        
           EXEC SQL                                                     06814000
              INCLUDE TBBILWDW                                          06815000
           END-EXEC.                                                    06816000
                                                                        
      ******************************************************************        
      * CSS_BILL_CRED_DET  - 1H                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCRBLDL                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BUSINESS_DAYS  - 1G                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBUSDAY                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************06330000
      * CSS_CREDIT_PROFILE - CZ                                        *06340000
      ******************************************************************06350000
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************06330000
      * CSS_CRED_COLL      - CL                                        *06340000
      ******************************************************************06350000
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCRCOLL                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************06330000
      * CSS_CRED_FORECAST  - CM                                        *06340000
      ******************************************************************06350000
                                                                        
           EXEC SQL                                                     01763000
               INCLUDE TBCRFCST                                         01764000
           END-EXEC.                                                    01765000
                                                                        
P00726******************************************************************06330000
P00726* CSS_CRED_ARNG_ACTN - 4W                                        *06340000
P00726******************************************************************06350000
P00726                                                                  
P00726     EXEC SQL                                                             
P00726         INCLUDE TBCRDACT                                                 
P00726     END-EXEC.                                                            
P00726                                                                  
P00726******************************************************************        
P00726*    CSS_CRED_ARNGMENT   - X1                                    *        
P00726******************************************************************        
P00726                                                                  
P00726     EXEC SQL                                                             
P00726         INCLUDE TBCRARNG                                                 
P00726     END-EXEC.                                                            
P00726                                                                  
      ******************************************************************        
      * CSS_DELINQUENCY    - C8                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * Declare cursor to all get credit forecast details.             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE CRED-FORECAST-CSR CURSOR FOR                      
               SELECT CM.COMPANY_NO                                     
                     ,CM.REVENUE_MONTH                                  
                     ,CM.BILL_DT                                        
                     ,CM.BILL_CYCLE                                     
                     ,CM.CRED_FORECAST_CD                               
                     ,CM.COMPANY_NO MSQ056A6                                    
                     ,CM.ARREARS_DUE_DT                                 
                     ,CM.CURR_CHG_DUE_DT                                
                     ,CM.DNP_NOTICE_MAIL_DT                             
                     ,CM.DNP_NOTICE_DUE_DT                              
                     ,CM.DNP_REVIEW_DT                                  
                     ,CM.DNP_DT                                         
                     ,CM.IVR_CALL_DT                                    
                     ,CM.AVOID_LPC_DT                                   
                     ,CM.NONUTIL_WQ_DT                                  
                     ,CM.REG_GROUP_CD                                   
                     ,CM.CREDIT_GROUP                                   
                     ,CM.CREDIT_GROUP_ID                                
                     ,CM.CRED_ACCT_TYPE_CD                              
                 FROM CSS_CRED_FORECAST CM WITH(READUNCOMMITTED)
                  INNER JOIN (
                   SELECT BN.BILL_CYCLE MFAAUXI_0                           
                               ,BN.REVENUE_MONTH MFAAUXI_1
            FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)
            WHERE BN.DATE_EXTRACT= IIF(TRY_CONVERT(DATE, 
                                                  :WS-KR100-BE00-CUR-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-KR100-BE00-CUR-DT
              ) <> 0) OR (LEN(:WS-KR100-BE00-CUR-DT
              ) <> 10), CIS.CHAR2DATE(:WS-KR100-BE00-CUR-DT
              ), CONVERT(DATE, :WS-KR100-BE00-CUR-DT) )
                 ) MFAAUXI
                   ON MFAAUXI_0 = CM.BILL_CYCLE AND MFAAUXI_1 = 
           CM.REVENUE_MONTH
                              
                 
                ORDER BY CM.COMPANY_NO        ASC                       
                        ,CM.REVENUE_MONTH     ASC                       
                        ,CM.BILL_DT           ASC                       
                        ,CM.BILL_CYCLE        ASC                       
                        ,CM.REG_GROUP_CD      ASC                       
                        ,CM.CREDIT_GROUP      ASC                       
                        ,CM.CREDIT_GROUP_ID   ASC                       
                        ,CM.CRED_ACCT_TYPE_CD ASC                       
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ056
MFA-TR* MSQ059
MFA-TR*    EXEC SQL                                                     01882000
MFA-TR*       DECLARE CRED-FORECAST-CSR CURSOR FOR                      01883000
MFA-TR*        SELECT CM.COMPANY_NO                                             
MFA-TR*              ,CM.REVENUE_MONTH                                          
MFA-TR*              ,CM.BILL_DT                                                
MFA-TR*              ,CM.BILL_CYCLE                                             
MFA-TR*              ,CM.CRED_FORECAST_CD                                       
MFA-TR*              ,CM.COMPANY_NO                                             
MFA-TR*              ,CM.ARREARS_DUE_DT                                 01891000
MFA-TR*              ,CM.CURR_CHG_DUE_DT                                01889000
MFA-TR*              ,CM.DNP_NOTICE_MAIL_DT                             01892000
MFA-TR*              ,CM.DNP_NOTICE_DUE_DT                              01893000
MFA-TR*              ,CM.DNP_REVIEW_DT                                  01896000
MFA-TR*              ,CM.DNP_DT                                         01897000
MFA-TR*              ,CM.IVR_CALL_DT                                    01894000
MFA-TR*              ,CM.AVOID_LPC_DT                                   01890000
MFA-TR*              ,CM.NONUTIL_WQ_DT                                  01895000
MFA-TR*              ,CM.REG_GROUP_CD                                           
MFA-TR*              ,CM.CREDIT_GROUP                                           
MFA-TR*              ,CM.CREDIT_GROUP_ID                                        
MFA-TR*              ,CM.CRED_ACCT_TYPE_CD                                      
MFA-TR*          FROM CSS_CRED_FORECAST CM                              01898000
MFA-TR*         WHERE (CM.BILL_CYCLE, CM.REVENUE_MONTH) IN (            01899000
MFA-TR*                  SELECT BN.BILL_CYCLE                                   
MFA-TR*                        ,BN.REVENUE_MONTH                                
MFA-TR*                    FROM CSS_BILL_WINDOW BN                              
MFA-TR*                   WHERE BN.DATE_EXTRACT= :WS-KR100-BE00-CUR-DT)         
MFA-TR*         ORDER BY CM.COMPANY_NO        ASC                               
MFA-TR*                 ,CM.REVENUE_MONTH     ASC                               
MFA-TR*                 ,CM.BILL_DT           ASC                               
MFA-TR*                 ,CM.BILL_CYCLE        ASC                               
MFA-TR*                 ,CM.REG_GROUP_CD      ASC                               
MFA-TR*                 ,CM.CREDIT_GROUP      ASC                               
MFA-TR*                 ,CM.CREDIT_GROUP_ID   ASC                               
MFA-TR*                 ,CM.CRED_ACCT_TYPE_CD ASC                               
MFA-TR*           FOR FETCH ONLY WITH UR                                01900000
MFA-TR*       QUERYNO 7570                                                      
MFA-TR*    END-EXEC.                                                    01901000
                                                                        
      ******************************************************************        
      * Declare cursor to get deliquency values                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE DELINQUENCY-CSR CURSOR WITH ROWSET POSITIONING FOR 
              SELECT C8.DELINQ_CD                                       
                    ,C8.DELINQ_VALUE                                    
                    ,C8.COMPANY_NO                                      
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD  IN ( 'AMT-ARREARS'                   
                                       ,'AMT-FIRSTNLIMIT'               
                                       ,'AMT-EPPDELINQ'                 
                                       ,'AMT-CBILL-NOTICE'              
                                       ,'AMT-CBILL-DELQ-WQ'             
                                       ,'AMT-NONUTIL-WQ-MIN'            
                                       ,'AMT-NU-ACT-CBUR'               
                                       ,'AMT-CBILL-ARR-WQ'              
                                       ,'AMT-NU-COMBO-NOT-MIN'          
                                       ,'AMT-NONUTIL-ARREARS'           
                                       ,'AMT-NU-NOTICE-MIN'             
                                       ,'AMT-NU-WQDELQ'                 
                                       ,'AUTO-CARD-PAY-DAYS' )          
               ORDER BY C8.COMPANY_NO                                   
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01872000
MFA-TR*      DECLARE DELINQUENCY-CSR CURSOR WITH ROWSET POSITIONING FOR 01873000
MFA-TR*       SELECT C8.DELINQ_CD                                       01874000
MFA-TR*             ,C8.DELINQ_VALUE                                    01875000
MFA-TR*             ,C8.COMPANY_NO                                      01876000
MFA-TR*         FROM CSS_DELINQUENCY C8                                 01877000
MFA-TR*        WHERE C8.DELINQ_CD  IN ( 'AMT-ARREARS'                           
MFA-TR*                                ,'AMT-FIRSTNLIMIT'                       
MFA-TR*                                ,'AMT-EPPDELINQ'                         
MFA-TR*                                ,'AMT-CBILL-NOTICE'                      
MFA-TR*                                ,'AMT-CBILL-DELQ-WQ'                     
MFA-TR*                                ,'AMT-NONUTIL-WQ-MIN'                    
MFA-TR*                                ,'AMT-NU-ACT-CBUR'                       
MFA-TR*                                ,'AMT-CBILL-ARR-WQ'                      
MFA-TR*                                ,'AMT-NU-COMBO-NOT-MIN'                  
MFA-TR*                                ,'AMT-NONUTIL-ARREARS'                   
MFA-TR*                                ,'AMT-NU-NOTICE-MIN'                     
MFA-TR*                                ,'AMT-NU-WQDELQ'                         
MFA-TR*                                ,'AUTO-CARD-PAY-DAYS' )                  
MFA-TR*        ORDER BY C8.COMPANY_NO                                   01878000
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*      QUERYNO 7540                                                       
MFA-TR*    END-EXEC.                                                    01880000
                                                                        
      ******************************************************************        
      * Declare cursor to get all the closed bill date.                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE BILL-WINDOW CURSOR FOR                            
               SELECT BN.DATE_EXTRACT                                   
                     ,BN.BILL_CYCLE                                     
                     ,BN.REVENUE_MONTH                                  
                 FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)
                  INNER JOIN (
                   SELECT A.BILL_CYCLE MFAAUXI_0                            
                               ,A.REVENUE_MONTH MFAAUXI_1
            FROM CSS_BILL_WINDOW A WITH(READUNCOMMITTED)
            WHERE A.DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                  :WS-KR100-BE00-CUR-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-KR100-BE00-CUR-DT
              ) <> 0) OR (LEN(:WS-KR100-BE00-CUR-DT
              ) <> 10), CIS.CHAR2DATE(:WS-KR100-BE00-CUR-DT
              ), CONVERT(DATE, :WS-KR100-BE00-CUR-DT) )
                 ) MFAAUXI
                   ON MFAAUXI_0 = BN.BILL_CYCLE AND MFAAUXI_1 = 
           BN.REVENUE_MONTH
                                
                WHERE BN.CODE_BILL_COND = 'C'                           
                ORDER BY BN.DATE_EXTRACT ASC                            
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ059
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BILL-WINDOW CURSOR FOR                                    
MFA-TR*        SELECT BN.DATE_EXTRACT                                           
MFA-TR*              ,BN.BILL_CYCLE                                             
MFA-TR*              ,BN.REVENUE_MONTH                                          
MFA-TR*          FROM CSS_BILL_WINDOW BN                                        
MFA-TR*         WHERE (BN.BILL_CYCLE, BN.REVENUE_MONTH) IN (                    
MFA-TR*                  SELECT A.BILL_CYCLE                                    
MFA-TR*                        ,A.REVENUE_MONTH                                 
MFA-TR*                    FROM CSS_BILL_WINDOW A                               
MFA-TR*                   WHERE A.DATE_EXTRACT = :WS-KR100-BE00-CUR-DT)         
MFA-TR*           AND BN.CODE_BILL_COND = 'C'                                   
MFA-TR*         ORDER BY BN.DATE_EXTRACT ASC                                    
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * Declare cursor to get all the cred coll details.               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE CRED-COLL-CSR CURSOR FOR                          
               SELECT CL.ACCOUNT_NO                                     
                     ,CL.CODE_SPECIAL_TYPE                              
                     ,CL.DATE_NOTICE_MAIL                               
                     ,CL.CODE_FRCST_CR_GRP                              
                     ,CL.ITEM_ID                                        
                     ,CL.CODE_MESSAGE_TYPE                              
                     ,CL.DATE_CREDIT_ACTION                             
                     ,CL.DATE_NOTICE_DUE                                
                     ,CL.AMT_NOTICE                                     
                     ,CL.CODE_NOTICE_TYPE                               
                     ,CL.DATE_BILL                                      
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CL.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                 FROM CSS_CRED_COLL CL WITH(READUNCOMMITTED)                    
                WHERE CL.ACCOUNT_NO = :CL-ACCOUNT-NO                    
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01662000
MFA-TR*       DECLARE CRED-COLL-CSR CURSOR FOR                          01663000
MFA-TR*        SELECT CL.ACCOUNT_NO                                     01664000
MFA-TR*              ,CL.CODE_SPECIAL_TYPE                              01665000
MFA-TR*              ,CL.DATE_NOTICE_MAIL                               01666000
MFA-TR*              ,CL.CODE_FRCST_CR_GRP                              01667000
MFA-TR*              ,CL.ITEM_ID                                        01668000
MFA-TR*              ,CL.CODE_MESSAGE_TYPE                              01669000
MFA-TR*              ,CL.DATE_CREDIT_ACTION                             01670000
MFA-TR*              ,CL.DATE_NOTICE_DUE                                01671000
MFA-TR*              ,CL.AMT_NOTICE                                     01672000
MFA-TR*              ,CL.CODE_NOTICE_TYPE                               01673000
MFA-TR*              ,CL.DATE_BILL                                      01674000
MFA-TR*              ,CL.LAST_UPDATE_TS                                 01675000
MFA-TR*          FROM CSS_CRED_COLL CL                                  01676000
MFA-TR*         WHERE CL.ACCOUNT_NO = :CL-ACCOUNT-NO                    01677000
MFA-TR*           FOR FETCH ONLY WITH UR                                01678000
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                    01679000
P00726                                                                  
P00726******************************************************************        
P00726* Declare cursor to get all the execeptional rows.               *        
P00726******************************************************************        
P00726                                                                  
P00726     EXEC SQL                                                     
P00726        DECLARE CRED-ACTN CURSOR FOR                              
P00726         SELECT [4W].ARNG_ID                                        
P00726               ,[4W].CRED_ARNG_SEQ                                  
P00726               ,[4W].CRED_ACTN_TYPE_CD                              
P00726               ,[4W].CRED_ACTN_SEQ                                  
P00726               ,[4W].CRED_ACTN_FCST_DT                              
P00726               ,[4W].CRED_ACTN_DUE_DT                               
P00726               ,[4W].CRED_ACTN_AM                                   
P00726           FROM CSS_CRED_ARNG_ACTN [4W] WITH(READUNCOMMITTED),            
ACT392                CSS_CRED_ARNGMENT  X1 WITH(READUNCOMMITTED)               
P00726          WHERE [4W].ACCOUNT_NO     = :4W-ACCOUNT-NO                
ACT392            AND [4W].ACCOUNT_NO     = X1.ACCOUNT_NO                 
ACT392            AND [4W].CRED_ARNG_SEQ  = X1.CRED_ARNG_SEQ              
ACT392            AND [4W].ARNG_ID        = X1.ARNG_ID                    
ACT392            AND X1.ARNG_STATUS_CD = 'A'                           
P00726            AND 
           [4W].CRED_ACTN_TYPE_CD IN ('UFN','ULN','IVR','DNP', 
P00726                                         'NFN','NLN','NWQ')       
P00726            AND PROCESSED_FL      = ''                            
P00726          ORDER BY [4W].CRED_ACTN_FCST_DT ASC                       
P00726            FOR READ ONLY                                 
P00726                                                      
P00726     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CRED-ACTN CURSOR FOR                                      
MFA-TR*        SELECT 4W.ARNG_ID                                                
MFA-TR*              ,4W.CRED_ARNG_SEQ                                          
MFA-TR*              ,4W.CRED_ACTN_TYPE_CD                                      
MFA-TR*              ,4W.CRED_ACTN_SEQ                                          
MFA-TR*              ,4W.CRED_ACTN_FCST_DT                                      
MFA-TR*              ,4W.CRED_ACTN_DUE_DT                                       
MFA-TR*              ,4W.CRED_ACTN_AM                                           
MFA-TR*          FROM CSS_CRED_ARNG_ACTN 4W,                                    
MFA-TR*               CSS_CRED_ARNGMENT  X1                                     
MFA-TR*         WHERE 4W.ACCOUNT_NO     = :4W-ACCOUNT-NO                        
MFA-TR*           AND 4W.ACCOUNT_NO     = X1.ACCOUNT_NO                         
MFA-TR*           AND 4W.CRED_ARNG_SEQ  = X1.CRED_ARNG_SEQ                      
MFA-TR*           AND 4W.ARNG_ID        = X1.ARNG_ID                            
MFA-TR*           AND X1.ARNG_STATUS_CD = 'A'                                   
MFA-TR*           AND 4W.CRED_ACTN_TYPE_CD IN ('UFN','ULN','IVR','DNP',         
MFA-TR*                                        'NFN','NLN','NWQ')               
MFA-TR*           AND PROCESSED_FL      = ''                                    
MFA-TR*         ORDER BY 4W.CRED_ACTN_FCST_DT ASC                               
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7630                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       COPY CWS1000B.                                                           
       COPY CWS1000K.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS10008                                                  
           END-EXEC.                                                            
       01  RS-RETURN-CODE       PIC S9(04)   COMP VALUE 0.              
                                                                        
       PROCEDURE DIVISION USING WS-KR100-CUST-DATA                      
                                WS-ACCOUNT-AT                           
                                WS-AR-CNTRL-AC                          
                                WS-CREDIT-PROFILE-CZ                    
                                WS-ACCT-ATTRIBUTE-YP                    
                                WS-TRANS-HIST-MH                        
                                WS-TRN-HST-DET-MI                       
                                WS-WQ-ITEMS-MF                          
                                WS-BILL-CRED-DET-1H                     
                                WS-CWS1000B-MAX-TBL-LIMITS              
                                RS-RETURN-CODE.                         
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS MAIN PROCESSING OF PROGRAM                            *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION                   THRU 0100-EXIT.
                                                                        
           PERFORM 2000-UPDATE-PROCESS                   THRU 2000-EXIT.
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      ******************************************************************        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE DCLCSS-BILL-CRED-DET                              
                      WS-ON-OFF-CYCLE-IND-SW                            
                      WS-NOTICE-WORK-FIELDS                             
                      WS-MISC                                           
                      WS-HOLD-NU-ARREARS                                
                      WS-AUTO-CARD-PYMT-DT                              
                      WS-MISC-MSG-TEXT                                  
                      WS-CRED-COLL-TABLE                                
                      WS-FORECAST-DATES                                 
                      WS-HOLD-CRED-COLL                                 
P00726                WS-CRED-ACTN-TABLE.                               
                                                                        
           MOVE WS-KR100-BE00-DT          TO CM-BILL-DT                 
                                             WS-KR100-BE00-CUR-DT.      
                                                                        
           IF FIRST-TIME                                                
              PERFORM 0110-LOAD-DELINQUENCY-TABLE        THRU 0110-EXIT 
              PERFORM 0130-LOAD-FORECAST-TABLE           THRU 0130-EXIT 
              PERFORM 0150-LOAD-BILL-WINDOW              THRU 0150-EXIT 
              SET NOT-FIRST-TIME          TO TRUE                       
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0110-LOAD-DELINQUENCY-TABLE                                    *        
      ******************************************************************        
                                                                        
       0110-LOAD-DELINQUENCY-TABLE.                                     
                                                                        
           SET DELQ-INDX  TO 1.                                         
           PERFORM 7530-OPEN-DELINQUENCY-CSR             THRU 7530-EXIT.
           PERFORM 7540-FETCH-DELINQUENCY-CSR            THRU 7540-EXIT.
           PERFORM 0120-LOAD-DELINQ-VARIABLE             THRU 0120-EXIT 
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7550-CLOSE-DELINQUENCY-CSR            THRU 7550-EXIT.
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0120-LOAD-DELINQ-VARIABLE.                                     *        
      ******************************************************************        
                                                                        
       0120-LOAD-DELINQ-VARIABLE.                                       
                                                                        
           ADD +1                TO WS-DELINQ-COUNT                     
           MOVE C8-COMPANY-NO    TO WS-COMPANY-NO-TB(DELQ-INDX).        
           MOVE C8-DELINQ-CD     TO WS-DELINQ-CD-TB(DELQ-INDX).         
           MOVE C8-DELINQ-VALUE  TO WS-DELINQ-VALUE-TB(DELQ-INDX).      
           SET DELQ-INDX UP BY 1.                                       
           PERFORM 7540-FETCH-DELINQUENCY-CSR            THRU 7540-EXIT.
                                                                        
       0120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0130-LOAD-FORECAST-TABLE.                                     *         
      ******************************************************************        
                                                                        
       0130-LOAD-FORECAST-TABLE.                                        
                                                                        
                                                                        
           PERFORM 7560-OPEN-CRED-FORECAST-CSR           THRU 7560-EXIT.
           PERFORM 7570-FETCH-CRED-FORECAST-CSR          THRU 7570-EXIT.
           SET TB-FORECAST-INDEX       TO 1.                            
           PERFORM 0140-LOAD-CM-VARIABLE                 THRU 0140-EXIT 
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7580-CLOSE-CRED-FORECAST-CSR          THRU 7580-EXIT.
                                                                        
       0130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0140-LOAD-CM-VARIABLE.                                         *        
      ******************************************************************        
                                                                        
       0140-LOAD-CM-VARIABLE.                                           
                                                                        
           MOVE CM-COMPANY-NO          TO                               
                WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX).                
           MOVE CM-REVENUE-MONTH       TO                               
                WS-REVENUE-MONTH-TB (TB-FORECAST-INDEX).                
           MOVE CM-BILL-DT             TO                               
                WS-BILL-DT-TB (TB-FORECAST-INDEX).                      
           MOVE CM-BILL-CYCLE          TO                               
                WS-BILL-CYCLE-TB (TB-FORECAST-INDEX).                   
           MOVE CM-CRED-FORECAST-CD    TO                               
                WS-CRED-FORECAST-CD-TB (TB-FORECAST-INDEX).             
           MOVE CM-ARREARS-DUE-DT      TO                               
                WS-ARREARS-DUE-DT-TB (TB-FORECAST-INDEX).               
           MOVE CM-CURR-CHG-DUE-DT     TO                               
                WS-CURR-CHG-DUE-DT-TB (TB-FORECAST-INDEX).              
           MOVE CM-DNP-NOTICE-MAIL-DT  TO                               
                WS-DNP-NOTTCE-MAIL-DT-TB (TB-FORECAST-INDEX).           
           MOVE CM-DNP-NOTICE-DUE-DT   TO                               
                WS-DNP-NOTICE-DUE-DT-TB (TB-FORECAST-INDEX).            
           MOVE CM-DNP-REVIEW-DT       TO                               
                WS-DNP-REVIEW-DT-TB (TB-FORECAST-INDEX).                
           MOVE CM-DNP-DT              TO                               
                WS-DNP-DT-TB (TB-FORECAST-INDEX).                       
           MOVE CM-IVR-CALL-DT         TO                               
                WS-IVR-CALL-TB (TB-FORECAST-INDEX).                     
           MOVE CM-AVOID-LPC-DT        TO                               
                WS-AVOID-LPC-DT-TB (TB-FORECAST-INDEX).                 
           MOVE CM-NONUTIL-WQ-DT       TO                               
                WS-NONUTIL-WQ-DT-TB (TB-FORECAST-INDEX).                
           MOVE CM-REG-GROUP-CD        TO                               
                WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX).                 
           MOVE CM-CREDIT-GROUP        TO                               
                WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX).                 
           MOVE CM-CREDIT-GROUP-ID     TO                               
                WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX).              
           MOVE CM-CRED-ACCT-TYPE-CD   TO                               
                WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX).            
                                                                        
           SET TB-FORECAST-INDEX UP BY 1.                               
                                                                        
           PERFORM 7570-FETCH-CRED-FORECAST-CSR          THRU 7570-EXIT.
                                                                        
       0140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0150-LOAD-BILL-WINDOW                                         *         
      ******************************************************************        
                                                                        
       0150-LOAD-BILL-WINDOW.                                           
                                                                        
           PERFORM 7500-OPEN-BILL-WINDOW-CSR             THRU 7500-EXIT.
           PERFORM 7510-FETCH-BILL-WINDOW-CSR            THRU 7510-EXIT.
           PERFORM VARYING WS-BILL-SUB FROM 1 BY 1                      
             UNTIL SQLCODE = NOT-FOUND                                  
              ADD 1                 TO WS-BN-COUNT                      
              MOVE BN-DATE-EXTRACT  TO WS-DATE-EXTRACT-TB(WS-BILL-SUB)  
              MOVE BN-BILL-CYCLE    TO WS-BILL-CYCLE-BN-TB(WS-BILL-SUB) 
              MOVE BN-REVENUE-MONTH TO WS-REVENUE-MTH-BN-TB(WS-BILL-SUB)
              PERFORM 7510-FETCH-BILL-WINDOW-CSR         THRU 7510-EXIT 
           END-PERFORM.                                                 
           PERFORM 7520-CLOSE-BILL-WINDOW-CSR            THRU 7520-EXIT.
                                                                        
       0150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0160-LOAD-CRED-COLL                                           *         
      ******************************************************************        
                                                                        
       0160-LOAD-CRED-COLL.                                             
                                                                        
           SET WS-CL-INDEX TO 1.                                        
           PERFORM 7590-OPEN-CRED-COLL                   THRU 7590-EXIT.
           PERFORM 7600-FETCH-CRED-COLL                  THRU 7600-EXIT.
           PERFORM 0220-LOAD-CRED-COLL-VARIABLES         THRU 0220-EXIT 
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7610-CLOSE-CRED-COLL                  THRU 7610-EXIT.
                                                                        
       0160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0170-LOAD-SEL-CM-VARIABLE                                      *        
      ******************************************************************        
                                                                        
       0170-LOAD-SEL-CM-VARIABLE.                                       
                                                                        
           MOVE WS-CURR-CHG-DUE-DT-TB (TB-FORECAST-INDEX)               
                                          TO WS-CURR-CHG-DUE-DT.        
           MOVE WS-AVOID-LPC-DT-TB (TB-FORECAST-INDEX)                  
                                          TO WS-AVOID-LPC-DT.           
           MOVE WS-ARREARS-DUE-DT-TB (TB-FORECAST-INDEX)                
                                          TO WS-ARREARS-DUE-DT.         
           MOVE WS-DNP-NOTTCE-MAIL-DT-TB (TB-FORECAST-INDEX)            
                                          TO WS-DNP-NOTICE-MAIL-DT.     
           MOVE WS-DNP-NOTICE-DUE-DT-TB (TB-FORECAST-INDEX)             
                                          TO WS-DNP-NOTICE-DUE-DT.      
           MOVE WS-IVR-CALL-TB (TB-FORECAST-INDEX)                      
                                          TO WS-IVR-CALL-DT.            
           MOVE WS-NONUTIL-WQ-DT-TB (TB-FORECAST-INDEX)                 
                                          TO WS-NONUTIL-WQ-DT.          
           MOVE WS-DNP-REVIEW-DT-TB (TB-FORECAST-INDEX)                 
                                          TO WS-DNP-REVIEW-DT.          
           MOVE WS-DNP-DT-TB (TB-FORECAST-INDEX)                        
                                          TO WS-DNP-DT.                 
                                                                        
       0170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0180-LOAD-DELINQ-TABLE                                         *        
      ******************************************************************        
                                                                        
       0180-LOAD-DELINQ-TABLE.                                          
                                                                        
           IF WS-COMPANY-NO-TB(DELQ-INDX) = WS-COMPANY-NO-AT            
              EVALUATE WS-DELINQ-CD-TB(DELQ-INDX)                       
                  WHEN 'AMT-FIRSTNLIMIT'                                
                       MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO            
                            WS-FIRST-NOTICE-LIMIT                       
                  WHEN 'AMT-EPPDELINQ'                                  
                       MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO            
                            WS-EPP-DELINQ-LIMIT                         
                  WHEN 'AMT-ARREARS'                                    
                       MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO            
                            WS-ARREARS-LIMIT                            
                  WHEN 'AMT-CBILL-NOTICE'                               
                       MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO            
                            WS-AMT-CBILL-NOTICE                         
                  WHEN 'AMT-CBILL-DELQ-WQ'                              
                       MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO            
                            WS-AMT-CBILL-DELQ-WQ                        
                  WHEN 'AMT-NONUTIL-WQ-MIN'                             
                       MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO            
                            WS-AMT-NONUTIL-WQ-MIN                       
                  WHEN 'AMT-NU-ACT-CBUR'                                
                       MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO            
                            WS-AMT-NU-ACT-CBUR                          
                  WHEN 'AMT-CBILL-ARR-WQ'                               
                       MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO            
                            WS-AMT-CBILL-ARR-WQ                         
                  WHEN 'AMT-NU-COMBO-NOT-MIN'                           
                       MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO            
                            WS-AMT-NU-COMBO-NOT-MIN                     
                  WHEN 'AMT-NONUTIL-ARREARS'                            
                       MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO            
                            WS-AMT-NONUTIL-ARREARS                      
                  WHEN 'AMT-NU-NOTICE-MIN'                              
                       MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO            
                            WS-AMT-NU-NOTICE-MIN                        
                  WHEN 'AMT-NU-WQDELQ'                                  
                       MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO            
                            WS-AMT-NU-WQDELQ                            
                  WHEN 'AUTO-CARD-PAY-DAYS'                             
                       MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO            
                            WS-AUTO-CARD-PAY-DAYS                       
              END-EVALUATE                                              
           END-IF.                                                      
           SET DELQ-INDX UP BY 1.                                       
                                                                        
       0180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0190-LOAD-DELINQ                                              *         
      ******************************************************************        
                                                                        
       0190-LOAD-DELINQ.                                                
                                                                        
           IF WS-COMPANY-NO-AT NOT EQUAL WS-CURRENT-COMPANY             
              IF CSR-DATABASE                                           
                 SET DELQ-INDX      TO 1                                
                 PERFORM 0180-LOAD-DELINQ-TABLE          THRU 0180-EXIT 
                   UNTIL DELQ-INDX > WS-DELINQ-COUNT                    
              ELSE                                                      
                 SET DELQ-INDX               TO 1                       
                 PERFORM 0180-LOAD-DELINQ-TABLE          THRU 0180-EXIT 
                   UNTIL DELQ-INDX > WS-DELINQ-COUNT                    
           END-IF
           END-IF.                                                      
                                                                        
       0190-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0200-VERIFY-SEL-DELINQ-VAL                                     *        
      ******************************************************************        
                                                                        
       0200-VERIFY-SEL-DELINQ-VAL.                                      
                                                                        
           IF WS-FIRST-NOTICE-LIMIT   > 0 AND                           
              WS-EPP-DELINQ-LIMIT     > 0 AND                           
              WS-ARREARS-LIMIT        > 0 AND                           
              WS-AMT-CBILL-NOTICE     > 0 AND                           
              WS-AMT-NU-WQDELQ        > 0 AND                           
              WS-AMT-CBILL-DELQ-WQ    > 0 AND                           
              WS-AMT-NONUTIL-WQ-MIN   > 0 AND                           
              WS-AMT-NU-ACT-CBUR      > 0 AND                           
              WS-AMT-CBILL-ARR-WQ     > 0 AND                           
              WS-AMT-NU-COMBO-NOT-MIN > 0 AND                           
              WS-AMT-NONUTIL-ARREARS  > 0 AND                           
              WS-AMT-NU-NOTICE-MIN    > 0                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'DELINQ CONSTANTS NOT CORRECT' TO WS-MISC-MSG-TEXT   
              MOVE +28                    TO WS-MISC-MSG-LEN            
              MOVE +17                    TO WS-MISC-CATEGORY-ID        
              MOVE 12                     TO RS-RETURN-CODE             
              PERFORM 9920-MISC-ERROR                    THRU 9920-EXIT 
           END-IF.                                                      
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0210-SEARCH-FORECAST-VALUES                                    *        
      ******************************************************************        
                                                                        
       0210-SEARCH-FORECAST-VALUES.                                     
                                                                        
           SET TB-FORECAST-INDEX TO 1.                                  
                                                                        
           SEARCH WS-FORECAST-ENTRY-TB                                  
               AT END                                                   
                  MOVE 'N' TO WS-FORECAST-ROW-FOUND                     
      * find a row in cred_forecast by matching the account's                   
      * 1. credit_group                                                         
      * 2. credit_group_id                                                      
      * 3. bill_date                                                            
      * 4. cred_acct_type                                                       
      * 5. bill_cycle                                                           
      * 6. company_no                                                           
      * 7. reg_group_cd                                                         
             WHEN WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX)      =         
                  WS-CREDIT-GROUP-AT                                AND 
                  WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX)   =         
                  WS-CREDIT-GROUP-ID                                AND 
                  WS-BILL-DT-TB (TB-FORECAST-INDEX)           =         
                  WS-KR100-BE00-DT                                  AND 
                  WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX) =         
                  WS-ACCOUNT-TYPE-CODE-AT                           AND 
                  WS-BILL-CYCLE-TB (TB-FORECAST-INDEX)        =         
                  WS-BILL-CYCLE-AT                                  AND 
                  WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX)     =         
                  WS-COMPANY-NO-AT                                  AND 
                  WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX)      =         
                  WS-REG-GROUP-CD-AT                                    
                  MOVE 'Y' TO WS-FORECAST-ROW-FOUND                     
      * find a row in cred_forecast by matching the account's                   
      * 1. credit_group                                                         
      * 2. credit_group_id                                                      
      * 3. bill_cycle_close_dt                                                  
      * 4. cred_acct_type                                                       
      * 5. bill_cycle                                                           
      * 6. company_no                                                           
      * 7. reg_group_cd                                                         
             WHEN WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX)      =         
                  WS-CREDIT-GROUP-AT                                AND 
                  WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX)   =         
                  WS-CREDIT-GROUP-ID                                AND 
                  WS-BILL-DT-TB (TB-FORECAST-INDEX)           =         
                  WS-BILL-CYCLE-CLOSE-DT                            AND 
                  WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX) =         
                  WS-ACCOUNT-TYPE-CODE-AT                           AND 
                  WS-BILL-CYCLE-TB (TB-FORECAST-INDEX)        =         
                  WS-BILL-CYCLE-AT                                  AND 
                  WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX)     =         
                  WS-COMPANY-NO-AT                                  AND 
                  WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX)      =         
                  WS-REG-GROUP-CD-AT                                    
                  MOVE 'Y' TO WS-FORECAST-ROW-FOUND                     
      * find a row in cred_forecast by matching the account's                   
      * 1. credit_group                                                         
      * 2. credit_group_id                                                      
      * 3. bill_date                                                            
      * 4. cred_acct_type = 'O' (default row for non-residentials)              
      * 5. bill_cycle                                                           
      * 6. company_no                                                           
      * 7. reg_group_cd                                                         
             WHEN WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX)      =         
                  WS-CREDIT-GROUP-AT                                AND 
                  WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX)   =         
                  WS-CREDIT-GROUP-ID                                AND 
                  WS-BILL-DT-TB (TB-FORECAST-INDEX)           =         
                  WS-KR100-BE00-DT                                  AND 
                  ( WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX) = 'O'   
                    AND WS-ACCOUNT-TYPE-CODE-AT NOT = 'R' )         AND 
                  WS-BILL-CYCLE-TB (TB-FORECAST-INDEX)        =         
                  WS-BILL-CYCLE-AT                                  AND 
                  WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX)     =         
                  WS-COMPANY-NO-AT                                  AND 
                  WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX)      =         
                  WS-REG-GROUP-CD-AT                                    
                  MOVE 'Y' TO WS-FORECAST-ROW-FOUND                     
      * find a row in cred_forecast by matching the account's                   
      * 1. credit_group                                                         
      * 2. credit_group_id                                                      
      * 3. bill_cycle_close_date                                                
      * 4. cred_acct_type = 'O' (default row for non-residentials)              
      * 5. bill_cycle                                                           
      * 6. company_no                                                           
      * 7. reg_group_cd                                                         
             WHEN WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX)      =         
                  WS-CREDIT-GROUP-AT                                AND 
                  WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX)   =         
                  WS-CREDIT-GROUP-ID                                AND 
                  WS-BILL-DT-TB (TB-FORECAST-INDEX)           =         
                  WS-BILL-CYCLE-CLOSE-DT                            AND 
                  ( WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX) = 'O'   
                    AND WS-ACCOUNT-TYPE-CODE-AT NOT = 'R' )         AND 
                  WS-BILL-CYCLE-TB (TB-FORECAST-INDEX)        =         
                  WS-BILL-CYCLE-AT                                  AND 
                  WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX)     =         
                  WS-COMPANY-NO-AT                                  AND 
                  WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX)      =         
                  WS-REG-GROUP-CD-AT                                    
                  MOVE 'Y' TO WS-FORECAST-ROW-FOUND                     
      * find a row in cred_forecast by matching the account's                   
      * 1. credit_group                                                         
      * 2. credit_group_id                                                      
      * 3. bill_cycle_close_date                                                
      * 4. cred_acct_type = ' ' (default row if no match is found)              
      * 5. bill_cycle                                                           
      * 6. company_no                                                           
      * 7. reg_group_cd                                                         
             WHEN WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX)      =         
                  WS-CREDIT-GROUP-AT                                AND 
                  WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX)   =         
                  WS-CREDIT-GROUP-ID                                AND 
                  WS-BILL-DT-TB (TB-FORECAST-INDEX)           =         
                  WS-BILL-CYCLE-CLOSE-DT                            AND 
                  WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX)           
                                                     = SPACES       AND 
                  WS-BILL-CYCLE-TB (TB-FORECAST-INDEX)        =         
                  WS-BILL-CYCLE-AT                                  AND 
                  WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX)     =         
                  WS-COMPANY-NO-AT                                  AND 
                  WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX)      =         
                  WS-REG-GROUP-CD-AT                                    
                  MOVE 'Y' TO WS-FORECAST-ROW-FOUND                     
      * find a row in cred_forecast by matching the account's                   
      * 1. credit_group                                                         
      * 2. credit_group_id                                                      
      * 3. bill_date                                                            
      * 4. cred_acct_type                                                       
      * 5. current day's opening bill_cycle                                     
      * 6. company_no                                                           
      * 7. reg_group_cd                                                         
             WHEN WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX)      =         
                  WS-CREDIT-GROUP-AT                                AND 
                  WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX)   =         
                  WS-CREDIT-GROUP-ID                                AND 
                  WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX) =         
                  WS-ACCOUNT-TYPE-CODE-AT                           AND 
                  WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX)     =         
                  WS-COMPANY-NO-AT                                  AND 
                  WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX)      =         
                  WS-REG-GROUP-CD-AT                                AND 
                  WS-BILL-DT-TB (TB-FORECAST-INDEX)           =         
                  WS-KR100-BE00-DT                                  AND 
                  WS-BILL-CYCLE-TB (TB-FORECAST-INDEX)        =         
                  WS-OFF-CYCLE-BILL                                 AND 
                  WS-OFF-CYCLE-BILL-FLAG                      = 'Y'     
                  MOVE 'Y' TO WS-FORECAST-ROW-FOUND                     
      * find a row in cred_forecast by matching the account's                   
      * 1. credit_group                                                         
      * 2. credit_group_id                                                      
      * 3. bill_date                                                            
      * 4. cred_acct_type = 'O' (default row for non-residentials)              
      * 5. current day's opening bill_cycle                                     
      * 6. company_no                                                           
      * 7. reg_group_cd                                                         
             WHEN WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX)      =         
                  WS-CREDIT-GROUP-AT                                AND 
                  WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX)   =         
                  WS-CREDIT-GROUP-ID                                AND 
                  ( WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX) = 'O'   
                    AND WS-ACCOUNT-TYPE-CODE-AT NOT = 'R' )         AND 
                  WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX)     =         
                  WS-COMPANY-NO-AT                                  AND 
                  WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX)      =         
                  WS-REG-GROUP-CD-AT                                AND 
                  WS-BILL-DT-TB (TB-FORECAST-INDEX)           =         
                  WS-KR100-BE00-DT                                  AND 
                  WS-BILL-CYCLE-TB (TB-FORECAST-INDEX)        =         
                  WS-OFF-CYCLE-BILL                                 AND 
                  WS-OFF-CYCLE-BILL-FLAG                      = 'Y'     
                  MOVE 'Y' TO WS-FORECAST-ROW-FOUND                     
      * find a row in cred_forecast by matching the account's                   
      * 1. credit_group                                                         
      * 2. credit_group_id                                                      
      * 3. bill_date                                                            
      * 4. cred_acct_type                                                       
      * 5. closing date of current day's opening bill_cycle                     
      * 6. company_no                                                           
      * 7. reg_group_cd                                                         
             WHEN WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX)      =         
                  WS-CREDIT-GROUP-AT                                AND 
                  WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX)   =         
                  WS-CREDIT-GROUP-ID                                AND 
                  WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX) =         
                  WS-ACCOUNT-TYPE-CODE-AT                           AND 
                  WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX)     =         
                  WS-COMPANY-NO-AT                                  AND 
                  WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX)      =         
                  WS-REG-GROUP-CD-AT                                AND 
                  WS-BILL-DT-TB (TB-FORECAST-INDEX)           =         
                  WS-OFF-CYCLE-BILL-DT                              AND 
                  WS-BILL-CYCLE-TB (TB-FORECAST-INDEX)        =         
                  WS-OFF-CYCLE-BILL                                 AND 
                  WS-OFF-CYCLE-BILL-FLAG                      = 'Y'     
                  MOVE 'Y' TO WS-FORECAST-ROW-FOUND                     
      * find a row in cred_forecast by matching the account's                   
      * 1. credit_group                                                         
      * 2. credit_group_id                                                      
      * 3. bill_date                                                            
      * 4. cred_acct_type = 'O' (default row for non-residentials)              
      * 5. closing date of current day's opening bill_cycle                     
      * 6. company_no                                                           
      * 7. reg_group_cd                                                         
             WHEN WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX)      =         
                  WS-CREDIT-GROUP-AT                                AND 
                  WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX)   =         
                  WS-CREDIT-GROUP-ID                                AND 
                  ( WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX) = 'O'   
                    AND WS-ACCOUNT-TYPE-CODE-AT NOT = 'R' )         AND 
                  WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX)     =         
                  WS-COMPANY-NO-AT                                  AND 
                  WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX)      =         
                  WS-REG-GROUP-CD-AT                                AND 
                  WS-BILL-DT-TB (TB-FORECAST-INDEX)           =         
                  WS-OFF-CYCLE-BILL-DT                              AND 
                  WS-BILL-CYCLE-TB (TB-FORECAST-INDEX)        =         
                  WS-OFF-CYCLE-BILL                                 AND 
                  WS-OFF-CYCLE-BILL-FLAG                      = 'Y'     
                  MOVE 'Y' TO WS-FORECAST-ROW-FOUND                     
      * find a row in cred_forecast by matching the account's                   
      * 1. credit_group                                                         
      * 2. credit_group_id                                                      
      * 3. bill_date                                                            
      * 4. cred_acct_type = ' ' (default row if no match is found)              
      * 5. closing date of current day's opening bill_cycle                     
      * 6. company_no                                                           
      * 7. reg_group_cd                                                         
             WHEN WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX)      =         
                  WS-CREDIT-GROUP-AT                                AND 
                  WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX)   =         
                  WS-CREDIT-GROUP-ID                                AND 
                  WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX) =         
                  SPACES                                            AND 
                  WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX)     =         
                  WS-COMPANY-NO-AT                                  AND 
                  WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX)      =         
                  WS-REG-GROUP-CD-AT                                AND 
                  WS-BILL-DT-TB (TB-FORECAST-INDEX)           =         
                  WS-OFF-CYCLE-BILL-DT                              AND 
                  WS-BILL-CYCLE-TB (TB-FORECAST-INDEX)        =         
                  WS-OFF-CYCLE-BILL                                 AND 
                  WS-OFF-CYCLE-BILL-FLAG                      = 'Y'     
                  MOVE 'Y' TO WS-FORECAST-ROW-FOUND                     
P00599* find a row in cred_forecast by matching the account's                   
P00599* 1. credit_group                                                         
P00599* 2. credit_group_id                                                      
P00599* 3. curr_open_cycle_bill_dt                                              
P00599* 4. cred_acct_type                                                       
P00599* 5. current open bill cycle                                              
P00599* 6. company_no                                                           
P00599* 7. reg_group_cd                                                         
P00599       WHEN WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX)      =         
P00599            WS-CREDIT-GROUP-AT                                AND 
P00599            WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX)   =         
P00599            WS-CREDIT-GROUP-ID                                AND 
P00599            WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX) = 'R' AND 
P00599            WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX)     =         
P00599            WS-COMPANY-NO-AT                                  AND 
P00599            WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX)      =         
P00599            WS-REG-GROUP-CD-AT                                AND 
P00599            WS-BILL-DT-TB (TB-FORECAST-INDEX)           =         
P00599            WS-CURR-OPEN-CYCLE-BILL-DT                        AND 
P00599            WS-BILL-CYCLE-TB (TB-FORECAST-INDEX)        =         
P00599            WS-CURR-OPEN-CYCLE                                AND 
P00599            WS-OFF-CYCLE-BILL-FLAG                      = 'Y'     
P00599            MOVE 'Y' TO WS-FORECAST-ROW-FOUND                     
P00599* find a row in cred_forecast by matching the account's                   
P00599* 1. credit_group                                                         
P00599* 2. credit_group_id                                                      
P00599* 3. curr_open_cycle_bill_dt                                              
P00599* 4. cred_acct_type = 'O' (default row for non-residentials)              
P00599* 5. current open bill cycle                                              
P00599* 6. company_no                                                           
P00599* 7. reg_group_cd                                                         
P00599       WHEN WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX)      =         
P00599            WS-CREDIT-GROUP-AT                                AND 
P00599            WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX)   =         
P00599            WS-CREDIT-GROUP-ID                                AND 
P00599            ( WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX) = 'O'   
P00599              AND WS-ACCOUNT-TYPE-CODE-AT NOT = 'R' )         AND 
P00599            WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX)     =         
P00599            WS-COMPANY-NO-AT                                  AND 
P00599            WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX)      =         
P00599            WS-REG-GROUP-CD-AT                                AND 
P00599            WS-BILL-DT-TB (TB-FORECAST-INDEX)           =         
P00599            WS-CURR-OPEN-CYCLE-BILL-DT                        AND 
P00599            WS-BILL-CYCLE-TB (TB-FORECAST-INDEX)        =         
P00599            WS-CURR-OPEN-CYCLE                                AND 
P00599            WS-OFF-CYCLE-BILL-FLAG                      = 'Y'     
P00599            MOVE 'Y' TO WS-FORECAST-ROW-FOUND                     
P00599* find a row in cred_forecast by matching the account's                   
P00599* 1. credit_group                                                         
P00599* 2. credit_group_id                                                      
P00599* 3. curr_open_cycle_bill_dt                                              
P00599* 4. cred_acct_type = ' ' (default row if no match is found)              
P00599* 5. current open bill cycle                                              
P00599* 6. company_no                                                           
P00599* 7. reg_group_cd                                                         
P00599       WHEN WS-CREDIT-GROUP-TB (TB-FORECAST-INDEX)      =         
P00599            WS-CREDIT-GROUP-AT                                AND 
P00599            WS-CREDIT-GROUP-ID-TB (TB-FORECAST-INDEX)   =         
P00599            WS-CREDIT-GROUP-ID                                AND 
P00599            WS-CRED-ACCT-TYPE-CD-TB (TB-FORECAST-INDEX) =         
P00599            SPACES                                            AND 
P00599            WS-COMPANY-NO-CM-TB (TB-FORECAST-INDEX)     =         
P00599            WS-COMPANY-NO-AT                                  AND 
P00599            WS-REG-GROUP-CD-TB (TB-FORECAST-INDEX)      =         
P00599            WS-REG-GROUP-CD-AT                                AND 
P00599            WS-BILL-DT-TB (TB-FORECAST-INDEX)           =         
P00599            WS-CURR-OPEN-CYCLE-BILL-DT                        AND 
P00599            WS-BILL-CYCLE-TB (TB-FORECAST-INDEX)        =         
P00599            WS-CURR-OPEN-CYCLE                                AND 
P00599            WS-OFF-CYCLE-BILL-FLAG                      = 'Y'     
P00599            MOVE 'Y' TO WS-FORECAST-ROW-FOUND                     
           END-SEARCH.                                                  
                                                                        
       0210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0220-LOAD-CRED-COLL-VARIABLES                                  *        
      ******************************************************************        
                                                                        
       0220-LOAD-CRED-COLL-VARIABLES.                                   
                                                                        
           MOVE CL-ACCOUNT-NO             TO                            
                WS-ACCOUNT-NO-TB (WS-CL-INDEX).                         
           MOVE CL-CODE-SPECIAL-TYPE      TO                            
                WS-CODE-SPECIAL-TYPE-TB (WS-CL-INDEX).                  
           MOVE CL-DATE-NOTICE-MAIL       TO                            
                WS-DATE-NOTICE-MAIL-TB (WS-CL-INDEX).                   
           MOVE CL-CODE-FRCST-CR-GRP      TO                            
                WS-CODE-FRCST-CR-GRP-TB (WS-CL-INDEX).                  
           MOVE CL-ITEM-ID                TO                            
                WS-ITEM-ID-TB (WS-CL-INDEX).                            
           MOVE CL-CODE-MESSAGE-TYPE      TO                            
                WS-CODE-MESSAGE-TYPE-TB (WS-CL-INDEX).                  
           MOVE CL-DATE-CREDIT-ACTION     TO                            
                WS-DATE-CREDIT-ACTION-TB (WS-CL-INDEX).                 
           MOVE CL-DATE-NOTICE-DUE        TO                            
                WS-DATE-NOTICE-DUE-TB (WS-CL-INDEX).                    
           MOVE CL-AMT-NOTICE             TO                            
                WS-AMT-NOTICE-TB (WS-CL-INDEX).                         
           MOVE CL-CODE-NOTICE-TYPE       TO                            
                WS-CODE-NOTICE-TYPE-TB (WS-CL-INDEX).                   
           MOVE CL-DATE-BILL              TO                            
                WS-DATE-BILL-TB (WS-CL-INDEX).                          
           MOVE CL-LAST-UPDATE-TS         TO                            
                WS-LAST-UPDATE-TS-TB (WS-CL-INDEX).                     
           MOVE 'N'                       TO                            
                WS-PROCESSED-FLAG (WS-CL-INDEX).                        
                                                                        
           SET  WS-CL-INDEX UP BY 1.                                    
                                                                        
           PERFORM 7600-FETCH-CRED-COLL                  THRU 7600-EXIT.
                                                                        
       0220-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00726***************************************************************** 03309000
P00726* 0230-LOAD-CRED-ACTN                                           * 03310000
P00726***************************************************************** 03311000
P00726                                                                  
P00726 0230-LOAD-CRED-ACTN.                                             
P00726                                                                  
P00726     SET WS-4W-INDEX TO 1.                                        
P00726     PERFORM 7620-OPEN-CRED-ACTN                   THRU 7620-EXIT.
P00726     PERFORM 7630-FETCH-CRED-ACTN                  THRU 7630-EXIT.
P00726     PERFORM 0240-LOAD-CRED-ACTN-VARIABLES         THRU 0240-EXIT 
P00726       UNTIL SQLCODE = NOT-FOUND.                                 
P00726     PERFORM 7640-CLOSE-CRED-ACTN                  THRU 7640-EXIT.
P00726                                                                  
P00726 0230-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
P00726******************************************************************        
P00726* 0240-LOAD-CRED-ACTN-VARIABLES                                  *        
P00726******************************************************************        
P00726                                                                  
P00726 0240-LOAD-CRED-ACTN-VARIABLES.                                   
P00726                                                                  
P00726     ADD 1                          TO WS-CRED-ACTN-COUNTER.      
P00726                                                                  
P00726     MOVE 4W-ACCOUNT-NO             TO                            
P00726          WS-4W-ACCOUNT-NO-TB (WS-4W-INDEX).                      
P00726     MOVE 4W-ARNG-ID                TO                            
P00726          WS-4W-ARNG-ID-TB (WS-4W-INDEX).                         
P00726     MOVE 4W-CRED-ARNG-SEQ          TO                            
P00726          WS-4W-CRED-ARNG-SEQ-TB (WS-4W-INDEX).                   
P00726     MOVE 4W-CRED-ACTN-TYPE-CD      TO                            
P00726          WS-4W-CRED-ACTN-TYPE-CD-TB (WS-4W-INDEX).               
P00726     MOVE 4W-CRED-ACTN-SEQ          TO                            
P00726          WS-4W-CRED-ACTN-SEQ-TB (WS-4W-INDEX)                    
P00726     MOVE 4W-CRED-ACTN-FCST-DT      TO                            
P00726          WS-4W-CRED-ACTN-FCST-DT-TB (WS-4W-INDEX).               
P00726     MOVE 4W-CRED-ACTN-DUE-DT       TO                            
P00726          WS-4W-CRED-ACTN-DUE-DT-TB (WS-4W-INDEX).                
P00726     MOVE 4W-CRED-ACTN-AM           TO                            
P00726          WS-4W-CRED-ACTN-AM-TB (WS-4W-INDEX).                    
P00726                                                                  
P00726     SET  WS-4W-INDEX UP BY 1.                                    
P00726                                                                  
P00726     PERFORM 7630-FETCH-CRED-ACTN                  THRU 7630-EXIT.
P00726                                                                  
P00726 0240-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
      ******************************************************************        
      * 2000-UPDATE-PROCESS                                            *        
      ******************************************************************        
                                                                        
       2000-UPDATE-PROCESS.                                             
                                                                        
           MOVE WS-ACCOUNT-NO-AT          TO CL-ACCOUNT-NO              
                                             CZ-ACCOUNT-NO              
P00726                                       X1-ACCOUNT-NO              
P00726                                       4W-ACCOUNT-NO.             
           MOVE WS-CREDIT-GROUP-AT        TO WS-CREDIT-GROUP-SW         
           MOVE WS-KR100-NEXT-BUS-DAY     TO WS-DATE-CURRENT-MAIL.      
           MOVE WS-CODES-DATA-PRESENT-AT  TO WS-CODES-DATA-PRESENT.     
                                                                        
           IF WS-CODE-OFF-CYCLE-CALC = 'O'                              
              SET WS-OFF-CYCLE-REBILL     TO TRUE                       
           END-IF.                                                      
                                                                        
      * Compute Total Util/Non Util Charges & Arrears                           
           PERFORM 2900-CALC-UTL-NONUTL-ARR-CHRG         THRU 2900-EXIT 
           IF WS-CREDIT-GROUP-AT = 'S'                                  
              PERFORM 2600-SUB-ACCOUNT-PROCESS           THRU 2600-EXIT 
              PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
      * Set PrePay Special Notice Flag                                          
           MOVE 'N' TO        WS-PRP-SPCL-NOTICE-SW                     
           IF PRP-FIRST-BILL                                            
              IF WS-NOTICE-EXEMPT-CD-AT > SPACES OR                     
                 WS-CODE-DISC-OK-AT     > SPACES                        
                 SET PRP-SPCL-NOTICE      TO TRUE                       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 0190-LOAD-DELINQ                      THRU 0190-EXIT.
           PERFORM 0200-VERIFY-SEL-DELINQ-VAL            THRU 0200-EXIT.
           MOVE WS-COMPANY-NO-AT          TO WS-CURRENT-COMPANY.        
           PERFORM 0160-LOAD-CRED-COLL                   THRU 0160-EXIT.
P00726     PERFORM 0230-LOAD-CRED-ACTN                   THRU 0230-EXIT.
P00726     PERFORM 7010-SELECT-ACTIVE-ARNG-TYPE          THRU 7010-EXIT.
P00726     PERFORM 5020-GET-IVR-DATE                     THRU 5020-EXIT.
                                                                        
      * Get Bill cycle closed date.                                             
           PERFORM 2050-GET-BILL-CYCLE-DATA              THRU 2050-EXIT.
                                                                        
           PERFORM 2200-PROCESS-CRED-FORECAST            THRU 2200-EXIT.
                                                                        
      * Off cycle rebill & outside bill window then move low values.            
           IF WS-OFF-CYCLE-REBILL AND OUTSIDE-BILL-WINDOW               
              MOVE LOW-VALUES             TO WS-IVR-CALL-DT             
           END-IF.                                                      
                                                                        
      * MASTER/NON-UTIL/CURRENT-TENANTS Process                                 
           EVALUATE TRUE                                                
               WHEN NON-UTILITY-ONLY-ACCT OR MASTER-CRED-GRP OR         
                                             NON-UTIL-CRED-GRP          
                    PERFORM 2300-PROCESS-NON-UTIL-CUST   THRU 2300-EXIT 
               WHEN OTHER                                               
                    PERFORM 2400-PROCESS-CURRENT-TENANTS THRU 2400-EXIT 
           END-EVALUATE.                                                
                                                                        
           IF 1H-BILL-CRED-NOT-ID > SPACES AND WS-CODE-THIRD-PTY = 'A'  
              PERFORM 2500-THIRD-PTY-HIST                THRU 2500-EXIT 
           END-IF.                                                      
                                                                        
           PERFORM 2510-DEL-NOT-PROCESSED-ROW            THRU 2510-EXIT.
           IF WS-TOT-DUE-DT-1H > SPACES                                 
              PERFORM 5050-GET-AUTO-CARD-PYMT-DATA THRU 5050-CPD338-EXIT
           END-IF.                                                      
           PERFORM 2950-CREDIT-PROFILE-PROCESS           THRU 2950-EXIT.
           PERFORM 5940-LOAD-BILL-CRED-DET               THRU 5940-EXIT.
           PERFORM 8110-INSERT-BILL-CRED-DET             THRU 8110-EXIT.
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2050-GET-BILL-CYCLE-DATA.                                      *        
      ******************************************************************        
      *                                                                         
       2050-GET-BILL-CYCLE-DATA.                                        
                                                                        
      * Get current timestamp for transaction history                           
           MOVE SPACES                    TO WS-OFF-CYCLE-BILL          
                                             WS-OFF-CYCLE-BILL-DT       
P00599                                       WS-CURR-OPEN-CYCLE         
P00599                                       WS-CURR-OPEN-CYCLE-BILL-DT.
P00599     MOVE ZEROS                     TO WS-CURR-REV-MNTH.          
           MOVE 'N'                       TO WS-ROW-FOUND.              
           PERFORM VARYING WS-BILL-SUB FROM 1 BY 1                      
             UNTIL WS-BILL-SUB > WS-BN-COUNT OR                         
                   WS-BILL-CYCLE-BN-TB(WS-BILL-SUB) = SPACES            
                IF WS-BILL-CYCLE-BN-TB(WS-BILL-SUB) = WS-BILL-CYCLE-AT  
                   AND WS-REVENUE-MTH-BN-TB(WS-BILL-SUB) =              
                       WS-REV-MTH-LST-NRML-AT                           
                   AND WS-ROW-FOUND NOT = 'Y'                           
                       MOVE WS-DATE-EXTRACT-TB(WS-BILL-SUB)             
                                          TO WS-BILL-CYCLE-CLOSE-DT     
                       MOVE 'Y'           TO WS-ROW-FOUND               
                END-IF                                                  
                IF WS-REVENUE-MTH-BN-TB(WS-BILL-SUB) =                  
                       WS-REV-MTH-LST-NRML-AT                           
                  IF WS-BILL-CYCLE-BN-TB(WS-BILL-SUB) >                 
                       WS-OFF-CYCLE-BILL                                
                       MOVE WS-BILL-CYCLE-BN-TB(WS-BILL-SUB)            
                                          TO WS-OFF-CYCLE-BILL          
                       MOVE WS-DATE-EXTRACT-TB(WS-BILL-SUB)             
                                          TO WS-OFF-CYCLE-BILL-DT       
                  END-IF                                                
                END-IF                                                  
P00599          IF WS-REVENUE-MTH-BN-TB(WS-BILL-SUB) >=                 
P00599                 WS-CURR-REV-MNTH                                 
P00599            IF WS-BILL-CYCLE-BN-TB(WS-BILL-SUB) >                 
P00599               WS-CURR-OPEN-CYCLE                                 
P00599                 MOVE WS-BILL-CYCLE-BN-TB(WS-BILL-SUB)            
P00599                                    TO WS-CURR-OPEN-CYCLE         
P00599                 MOVE WS-DATE-EXTRACT-TB(WS-BILL-SUB)             
P00599                                    TO WS-CURR-OPEN-CYCLE-BILL-DT 
P00599                 MOVE WS-REVENUE-MTH-BN-TB(WS-BILL-SUB)           
P00599                                    TO WS-CURR-REV-MNTH           
P00599            END-IF                                                
P00599          END-IF                                                  
           END-PERFORM.                                                 
                                                                        
                                                                        
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-FORMAT-TRANS-HIST-HDR-DTL                                 *        
      ******************************************************************        
      *                                                                         
       2100-FORMAT-TRANS-HIST-HDR-DTL.                                  
                                                                        
      * Get current timestamp for transaction history                           
           PERFORM 7000-GET-TIMESTAMP                    THRU 7000-EXIT.
                                                                        
                                                                        
      * Populate Working-Storage variables of MH table                          
           MOVE WS-CURRENT-TIMESTAMP       TO                           
                            WS-TRANS-HIST-KEY-MH(WS-MH-TRN-INDX).       
           MOVE WS-CURRENT-DATE            TO                           
                            WS-DATE-TRANS-MH(WS-MH-TRN-INDX).           
           MOVE 'F'                        TO                           
                            WS-CODE-TRAN-TYPE-MH(WS-MH-TRN-INDX).       
           MOVE SPACES                     TO                           
                            WS-RESP-AREA-ID-MH(WS-MH-TRN-INDX).         
           MOVE WS-ACCOUNT-NO-AT           TO                           
                            WS-ACCOUNT-NO-MH(WS-MH-TRN-INDX).           
           MOVE ZERO                       TO                           
                            WS-PREMISE-NO-MH(WS-MH-TRN-INDX).           
           MOVE WS-CUSTOMER-NO-AT          TO                           
                            WS-CUSTOMER-NO-MH(WS-MH-TRN-INDX).          
           MOVE 'SYSTEM'                   TO                           
                            WS-USER-ID-MH(WS-MH-TRN-INDX).              
           MOVE 'SCSKR115A'                TO                           
                            WS-APPL-PROGRAM-ID-MH(WS-MH-TRN-INDX).      
           MOVE +55                        TO                           
                            WS-TRAN-COMMENT-LEN-MH(WS-MH-TRN-INDX).     
           MOVE WS-TRAN-COMMENT-TEXT       TO                           
                            WS-TRAN-COMMENT-TEXT-MH(WS-MH-TRN-INDX).    
           ADD +1                          TO WS-MH-TRN-INDX.           
                                                                        
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-CRED-FORECAST.                                    *        
      ******************************************************************        
                                                                        
       2200-PROCESS-CRED-FORECAST.                                      
                                                                        
           EVALUATE TRUE                                                
               WHEN DPP-ACCOUNT                                         
                    MOVE 'DPP'             TO WS-CREDIT-GROUP-ID        
               WHEN OTHER                                               
                    MOVE SPACES            TO WS-CREDIT-GROUP-ID        
           END-EVALUATE.                                                
                                                                        
           MOVE 'N'                        TO WS-FORECAST-ROW-FOUND     
           MOVE 'N'                        TO WS-OFF-CYCLE-BILL-FLAG    
           PERFORM 0210-SEARCH-FORECAST-VALUES           THRU 0210-EXIT.
           IF WS-FORECAST-ROW-FOUND    = 'N'                            
              MOVE SPACES                  TO WS-CREDIT-GROUP-ID        
              PERFORM 0210-SEARCH-FORECAST-VALUES        THRU 0210-EXIT 
              IF WS-FORECAST-ROW-FOUND = 'N'                            
                 MOVE 'Y'                  TO WS-OFF-CYCLE-BILL-FLAG    
                 PERFORM 0210-SEARCH-FORECAST-VALUES     THRU 0210-EXIT 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-FORECAST-ROW-FOUND = 'Y'                               
              PERFORM 0170-LOAD-SEL-CM-VARIABLE          THRU 0170-EXIT 
           ELSE                                                         
              MOVE 'NO MATCHES CREDIT FORECAST ROWS FOUND'              
                                           TO WS-MISC-MSG-TEXT          
              MOVE +37                     TO WS-MISC-MSG-LEN           
              MOVE +137                    TO WS-MISC-CATEGORY-ID       
              MOVE 12                      TO RS-RETURN-CODE            
              PERFORM 9920-MISC-ERROR                    THRU 9920-EXIT 
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-PROCESS-NON-UTIL-CUST                                     *        
      ******************************************************************        
                                                                        
       2300-PROCESS-NON-UTIL-CUST.                                      
      * Set ws-credit-exempt-sw flag                                            
           IF NON-UTIL-CRED-GRP OR MASTER-CRED-GRP                      
              IF WS-CODE-DISC-OK-AT = SPACES                            
                 MOVE 'Y'                 TO WS-CREDIT-EXEMPT-SW        
              ELSE                                                      
                 MOVE 'N'                 TO WS-CREDIT-EXEMPT-SW        
              END-IF                                                    
                                                                        
              IF WS-NOTICE-EXEMPT-CD-AT = SPACES OR 'B'                 
                 MOVE 'Y'                 TO WS-NOTICE-EXEMPT-SW        
              ELSE                                                      
                 MOVE 'N'                 TO WS-NOTICE-EXEMPT-SW        
              END-IF                                                    
           END-IF.                                                      
                                                                        
      * Process Non-Utility & Inactive services                                 
           EVALUATE TRUE                                                
               WHEN NON-UTIL-CRED-GRP OR MASTER-CRED-GRP                
                    PERFORM 2310-PROCESS-NON-UTILITY     THRU 2310-EXIT 
               WHEN NOT (NON-UTIL-CRED-GRP OR MASTER-CRED-GRP)          
                    PERFORM 2320-INACTIVE-SERVICES       THRU 2320-EXIT 
           END-EVALUATE.                                                
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07582000
      * 2310-PROCESS-NON-UTILITY.                                      *06136000
      ******************************************************************07582000
                                                                        
       2310-PROCESS-NON-UTILITY.                                        
                                                                        
           INITIALIZE WS-FIRST-NOTICE-MESSAGE-TYPE.                     
                                                                        
           PERFORM 5710-BUILD-ROW-A-NONUTIL              THRU 5710-EXIT.
           IF WS-TOTAL-UTILITY-CHARGES > 0                              
              PERFORM 5740-BUILD-ROW-P-NONUTIL           THRU 5740-EXIT 
           END-IF.                                                      
           IF WS-TOTAL-NONUTIL-CHARGES > 0                              
              PERFORM 5730-BUILD-ROW-Q-NONUTIL           THRU 5730-EXIT 
           END-IF.                                                      
                                                                        
           EVALUATE TRUE                                                
               WHEN NON-UTIL-CRED-GRP                                   
                    IF WS-TOTAL-ARREARS > WS-AMT-NU-NOTICE-MIN AND      
                       NOT-NOTICE-EXEMPT                                
                       PERFORM 5640-BUILD-ROW-K          THRU 5640-EXIT 
                       IF WS-PAST-UTIL-CHARGES-CALC > 0                 
                          PERFORM 5720-BUILD-ROW-B-NON-UTIL             
                                                         THRU 5720-EXIT 
                       END-IF                                           
                       IF WS-TOTAL-NONUTIL-ARREARS  > 0                 
                          PERFORM 5750-BUILD-ROW-R-NON-UTIL             
                                                         THRU 5750-EXIT 
                       END-IF                                           
                    END-IF                                              
                    IF WS-TOT-NON-UTIL-CRED-BUR > WS-AMT-NU-ACT-CBUR AND
                       NOT-CREDIT-BUR-EXEMPT                            
                       PERFORM 5650-BUILD-ROW-L          THRU 5650-EXIT 
                    END-IF                                              
                    IF WS-KR100-TOTAL-90-DELINQ > WS-AMT-NU-WQDELQ      
                       PERFORM 5660-BUILD-ROW-M          THRU 5660-EXIT 
                    END-IF                                              
               WHEN MASTER-CRED-GRP                                     
                    IF WS-TOTAL-ARREARS > WS-AMT-CBILL-NOTICE AND       
                       NOT-NOTICE-EXEMPT                                
                       PERFORM 5640-BUILD-ROW-K          THRU 5640-EXIT 
                       IF WS-PAST-UTIL-CHARGES-CALC > ZERO              
                          PERFORM 5720-BUILD-ROW-B-NON-UTIL             
                                                         THRU 5720-EXIT 
                       END-IF                                           
                       IF WS-TOTAL-NONUTIL-ARREARS  > ZERO              
                          PERFORM 5750-BUILD-ROW-R-NON-UTIL             
                                                         THRU 5750-EXIT 
                       END-IF                                           
                    END-IF                                              
                    IF WS-KR100-TOTAL-90-DELINQ > WS-AMT-CBILL-DELQ-WQ  
                       PERFORM 5660-BUILD-ROW-M          THRU 5660-EXIT 
                    ELSE                                                
                       IF WS-TOTAL-NONUTIL-ARREARS > WS-AMT-CBILL-ARR-WQ
                          MOVE 'Y' TO WS-MASTER-WQ-SW                   
                          PERFORM 5660-BUILD-ROW-M       THRU 5660-EXIT 
                          MOVE 'N' TO WS-MASTER-WQ-SW                   
                       END-IF                                           
                    END-IF                                              
           END-EVALUATE.                                                
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03787000
      * 2320-INACTIVE-SERVICES.                                        *03788000
      * ACTIVE ACCOUNTS, INACTIVE SERVICES.  'A' ROW IS WRITTEN        *03789000
      * WORK QUEUE IS PRODUCED.                                        *03790000
      * IF TOTAL UTILITY CHARGES  > 0,'P' ROW IS WRITTEN.              *03791000
      * IF TOTAL NON UTIL CHARGES > 0 'Q' ROW IS WRITTEN.              *03792000
      ******************************************************************03793000
                                                                        
       2320-INACTIVE-SERVICES.                                          
                                                                        
           PERFORM 2450-PROCESS-GROUP-C                  THRU 2450-EXIT.
                                                                        
           IF WS-TOTAL-UTILITY-CHARGES > 0 OR                           
              WS-TOTAL-NONUTIL-CHARGES > 0                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE LOW-VALUES             TO WS-AVOID-LPC-DT            
           END-IF.                                                      
           PERFORM 5600-BUILD-ROW-A                      THRU 5600-EXIT.
           IF WS-AMT-CURRENT-BAL > ZERO                                 
              PERFORM 5670-BUILD-ROW-P                   THRU 5670-EXIT 
           END-IF.                                                      
           IF WS-TOTAL-NONUTIL-CHARGES > ZERO                           
              PERFORM 5680-BUILD-ROW-Q                   THRU 5680-EXIT 
           END-IF.                                                      
           PERFORM 2431-BUILD-ROWS-B-R-M                 THRU 2431-EXIT.
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-PROCESS-CURRENT-TENANTS                                   *        
      ******************************************************************        
                                                                        
       2400-PROCESS-CURRENT-TENANTS.                                    
                                                                        
           INITIALIZE WS-TEMP-CODE-MESSAGE-TYPE                         
                      WS-HOLD-CODE-MESSAGE-TYPE                         
                      WS-FIRST-NOTICE-MESSAGE-TYPE.                     
                                                                        
           IF WS-TOTAL-UTILITY-CHARGES > 0 OR                           
              WS-TOTAL-NONUTIL-CHARGES > 0                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE LOW-VALUES                    TO WS-AVOID-LPC-DT     
           END-IF.                                                      
                                                                        
           MOVE WS-CREDIT-GROUP-AT               TO WS-ACTION-CR-GRP.   
                                                                        
           EVALUATE TRUE                                                
               WHEN WS-TOTAL-AR-BALANCE-AT <= ZEROS                     
                    MOVE 'X'                     TO WS-ACTION-CR-GRP    
               WHEN WS-CODE-MEDICAL = 'A'                               
                    MOVE 'T'                     TO WS-ACTION-CR-GRP    
           END-EVALUATE.                                                
                                                                        
           IF BBP-ACCOUNT                                               
              IF WS-KR100-BUDGET-DELINQ > WS-EPP-DELINQ-LIMIT           
                 MOVE 'E' TO WS-ACTION-CR-GRP                           
              ELSE                                                      
                 MOVE 'X' TO WS-ACTION-CR-GRP                           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE SPACES TO WS-UPDATE-ACTION-IND-TB                       
           EVALUATE WS-ACTION-CR-GRP                                    
               WHEN 'A'                                                 
               WHEN 'N'                                                 
P00948              IF X1-ARNG-TYPE = 'STAA' OR 'STFA'                  
                       PERFORM 2435-PROCESS-EXCPTNL-A-N  THRU 2435-EXIT 
P00726                 PERFORM 5010-BUILD-EXCPTNL-NOTICES               
P00726                                                   THRU 5010-EXIT 
P00726              ELSE                                                
                       PERFORM 2430-PROCESS-GROUP-A-N    THRU 2430-EXIT 
                       PERFORM 5000-BUILD-NOTICES        THRU 5000-EXIT 
P00726              END-IF                                              
               WHEN 'B'                                                 
                    IF SEB-DATABASE                                     
                       PERFORM 2440-PROCESS-GROUP-B      THRU 2440-EXIT 
                       PERFORM 5000-BUILD-NOTICES        THRU 5000-EXIT 
                    END-IF                                              
               WHEN 'C'                                                 
                    PERFORM 2450-PROCESS-GROUP-C         THRU 2450-EXIT 
                    PERFORM 5600-BUILD-ROW-A             THRU 5600-EXIT 
                    IF WS-AMT-CURRENT-BAL > ZERO                        
                       PERFORM 5670-BUILD-ROW-P          THRU 5670-EXIT 
                    END-IF                                              
                    IF WS-TOTAL-NONUTIL-CHARGES > ZERO                  
                       PERFORM 5680-BUILD-ROW-Q          THRU 5680-EXIT 
                    END-IF                                              
                    PERFORM 2431-BUILD-ROWS-B-R-M        THRU 2431-EXIT 
               WHEN 'E'                                                 
                    PERFORM 2460-PROCESS-BUDGET          THRU 2460-EXIT 
                    PERFORM 5000-BUILD-NOTICES           THRU 5000-EXIT 
               WHEN 'T'                                                 
      * ACCOUNTS WITH ACTIVE MEDICAL CERTIFICATES GO THROUGH SPECIAL    03061000
      * PROCESSING - THE MEDICAL CERTIFICATE FORECAST IS KEPT, AND      03062000
      * NO CURRENT MONTH CREDIT ACTION IS FORECAST EXCEPT FOR CREDIT    03063000
      * GROUP B CUSTOMERS, WHICH WILL BE FORECAST FOR CREDIT ACTION     03064000
      * ON THEIR CURRENT CHARGES.                                       03065000
                    PERFORM 2480-PROCESS-MED-CERT        THRU 2480-EXIT 
                                                                        
                    PERFORM 5600-BUILD-ROW-A             THRU 5600-EXIT 
                                                                        
                    IF WS-AMT-CURRENT-BAL    > ZERO                     
                       PERFORM 5670-BUILD-ROW-P          THRU 5670-EXIT 
                    END-IF                                              
                    IF WS-AMT-CURRENT-BAL-NU > ZERO                     
                       PERFORM 5680-BUILD-ROW-Q          THRU 5680-EXIT 
                    END-IF                                              
                                                                        
                    MOVE WS-TEMP-AMT-FIRST-BAL    TO WS-AMT-FIRST-BAL   
                    MOVE WS-TEMP-AMT-FIRST-BAL-NU TO WS-AMT-FIRST-BAL-NU
                    MOVE WS-TEMP-DATE-FIRST-DUE   TO WS-ARREARS-DUE-DT  
                                                                        
                    IF WS-CREDIT-GROUP-AT EQUAL 'B' AND SEB-DATABASE    
                       IF WS-KR100-CUST-ALRT-EXP-DT NOT >               
                                                WS-DNP-NOTICE-MAIL-DT   
                          MOVE WS-TEMP-AMT-SECOND-BAL                   
                                                 TO WS-AMT-SECOND-BAL   
                          MOVE WS-TEMP-AMT-DNP-BAL                      
                                                 TO WS-AMT-DNP-BAL      
                          MOVE WS-TEMP-AMT-SECOND-BAL-NU TO             
                               WS-AMT-SECOND-BAL-NU                     
                          MOVE WS-TEMP-AMT-WQ-NU TO WS-AMT-WQ-NU        
                       ELSE                                             
                          MOVE ZEROES            TO WS-AMT-SECOND-BAL   
                                                    WS-AMT-DNP-BAL      
                                                    WS-AMT-SECOND-BAL-NU
                                                    WS-AMT-WQ-NU        
                       END-IF                                           
                    ELSE                                                
                       MOVE ZEROES               TO WS-AMT-SECOND-BAL   
                                                    WS-AMT-DNP-BAL      
                                                    WS-AMT-SECOND-BAL-NU
                                                    WS-AMT-WQ-NU        
                    END-IF                                              
                                                                        
                    PERFORM 2433-BUILD-UTIL-ROWS-B-C-D   THRU 2433-EXIT 
                    PERFORM 2434-BUILD-NONUTL-ROWS-R-S-M THRU 2434-EXIT 
                    PERFORM 2481-CHECK-SPCL-MED-CERT     THRU 2481-EXIT 
               WHEN 'X'                                                 
                    PERFORM 2450-PROCESS-GROUP-C         THRU 2450-EXIT 
                    PERFORM 5600-BUILD-ROW-A             THRU 5600-EXIT 
                    IF WS-AMT-CURRENT-BAL <= 0 AND BBP-ANNIVERSARY AND  
                       WS-HOLD-DATE-NOTICE-DUE = LOW-VALUES             
                       MOVE WS-CURR-CHG-DUE-DT TO                       
                                                 1H-ADDITIONAL-DUE-DT   
                                                 WS-ADDITIONAL-DUE-DT-1H
                    END-IF                                              
                    IF WS-AMT-CURRENT-BAL > ZERO                        
                       PERFORM 5670-BUILD-ROW-P          THRU 5670-EXIT 
                    END-IF                                              
                    IF WS-TOTAL-NONUTIL-CHARGES > ZERO                  
                       PERFORM 5680-BUILD-ROW-Q          THRU 5680-EXIT 
                    END-IF                                              
                    PERFORM 2431-BUILD-ROWS-B-R-M        THRU 2431-EXIT 
           END-EVALUATE.                                                
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07704000
      * 2430-PROCESS-GROUP-A-N.                                         07708000
      ******************************************************************07704000
                                                                        
       2430-PROCESS-GROUP-A-N.                                          
                                                                        
           MOVE WS-TOTAL-UTILITY-CHARGES     TO WS-AMT-CURRENT-BAL.     
           MOVE WS-TOTAL-NONUTIL-CHARGES     TO WS-AMT-CURRENT-BAL-NU.  
           IF WS-TOTAL-UTILITY-CHARGES > 0 OR                           
              WS-TOTAL-NONUTIL-CHARGES > 0                              
              CONTINUE                                                  
           ELSE                                                         
              GO TO 2430-EXIT                                           
           END-IF.                                                      
                                                                        
           IF WS-TOTAL-UTILITY-CHARGES > ZERO                           
              MOVE WS-PAST-UTIL-CHARGES-CALC TO WS-TEMP-AMT-FIRST-BAL   
                                                WS-TEMP-AMT-SECOND-BAL  
                                                WS-TEMP-AMT-DNP-BAL     
              MOVE WS-TOTAL-NONUTIL-ARREARS                             
                                          TO WS-TEMP-AMT-FIRST-BAL-NU   
                                             WS-TEMP-AMT-SECOND-BAL-NU  
                                             WS-TEMP-AMT-WQ-NU          
              IF (WS-PAST-UTIL-CHARGES-CALC > WS-FIRST-NOTICE-LIMIT OR  
                  WS-TOTAL-NONUTIL-ARREARS > WS-AMT-NU-COMBO-NOT-MIN)   
I01687          AND CSR-DATABASE                                        
                  MOVE LOW-VALUES             TO WS-AVOID-LPC-DT        
              END-IF                                                    
           ELSE                                                         
              MOVE WS-TOTAL-NONUTIL-ARREARS  TO WS-TEMP-AMT-FIRST-BAL   
                                                WS-TEMP-AMT-SECOND-BAL  
                                                WS-TEMP-AMT-DNP-BAL     
              MOVE LOW-VALUES                TO WS-AVOID-LPC-DT         
           END-IF.                                                      
                                                                        
           EVALUATE TRUE                                                
               WHEN WS-TEMP-AMT-FIRST-BAL > WS-FIRST-NOTICE-LIMIT AND   
                    WS-TEMP-AMT-FIRST-BAL-NU = 0                        
                    PERFORM 5110-LOAD-FIRST-BAL-AMT      THRU 5110-EXIT 
                    IF WS-OFF-CYCLE-REBILL AND OUTSIDE-BILL-WINDOW      
                       CONTINUE                                         
                    ELSE                                                
                       MOVE 'U' TO WS-NON-UTL-CR-HST-CZ (1:1)           
                                   WS-NON-UTL-CR-HST-EX-CZ (1:1)        
                    END-IF                                              
      * WHEN PROCESSING ACCOUNTS WITH MULTIPLE DUE DATES, NOTICES       05272000
      * 80104 AND 90104 WILL BE USED. IF THERE IS ONLY ONE DUE DATE     05273000
      * 80101 AND 90101 WILL BE USED.                                   05274000
                    IF WS-CURR-CHG-DUE-DT  = WS-ARREARS-DUE-DT          
                       MOVE 90101         TO WS-TEMP-CODE-MESSAGE-TYPE  
                    ELSE                                                
                       MOVE 90104         TO WS-TEMP-CODE-MESSAGE-TYPE  
                    END-IF                                              
               WHEN WS-TEMP-AMT-FIRST-BAL > WS-FIRST-NOTICE-LIMIT AND   
                    WS-TEMP-AMT-FIRST-BAL-NU > 0                        
                    PERFORM 5110-LOAD-FIRST-BAL-AMT      THRU 5110-EXIT 
                    PERFORM 5120-LOAD-FIRST-BAL-AMT-NU   THRU 5120-EXIT 
                    IF WS-CURR-CHG-DUE-DT = WS-ARREARS-DUE-DT           
                       MOVE 80101         TO WS-TEMP-CODE-MESSAGE-TYPE  
                    ELSE                                                
                       MOVE 80104         TO WS-TEMP-CODE-MESSAGE-TYPE  
                    END-IF                                              
               WHEN (WS-TEMP-AMT-FIRST-BAL > 0 AND                      
                     <= WS-FIRST-NOTICE-LIMIT) AND                      
                    WS-TEMP-AMT-FIRST-BAL-NU > WS-AMT-NU-COMBO-NOT-MIN  
                    PERFORM 5110-LOAD-FIRST-BAL-AMT      THRU 5110-EXIT 
                    PERFORM 5120-LOAD-FIRST-BAL-AMT-NU   THRU 5120-EXIT 
                    MOVE 80409            TO WS-TEMP-CODE-MESSAGE-TYPE  
               WHEN WS-TEMP-AMT-FIRST-BAL = 0 AND                       
                    WS-TEMP-AMT-FIRST-BAL-NU > WS-AMT-NU-COMBO-NOT-MIN  
                    PERFORM 5120-LOAD-FIRST-BAL-AMT-NU   THRU 5120-EXIT 
                    MOVE 90409            TO WS-TEMP-CODE-MESSAGE-TYPE  
               WHEN (WS-TEMP-AMT-FIRST-BAL > WS-ARREARS-LIMIT AND       
                    <= WS-FIRST-NOTICE-LIMIT) OR                        
                    (WS-TEMP-AMT-FIRST-BAL-NU > WS-AMT-NONUTIL-ARREARS  
                    AND <= WS-AMT-NU-COMBO-NOT-MIN)                     
                    IF SEB-DATABASE AND WS-REGULATED-CD-AT =            
                                        WS-REGULATED                    
                       MOVE 91070         TO WS-TEMP-CODE-MESSAGE-TYPE  
                    ELSE                                                
                       MOVE 91002         TO WS-TEMP-CODE-MESSAGE-TYPE  
                    END-IF                                              
           END-EVALUATE.                                                
                                                                        
           IF WS-TEMP-AMT-SECOND-BAL > WS-FIRST-NOTICE-LIMIT            
              PERFORM 5130-LOAD-SECOND-BAL-DNP-AMT       THRU 5130-EXIT 
              IF WS-TEMP-AMT-SECOND-BAL-NU > 0                          
                 PERFORM 5140-LOAD-SECOND-BAL-AMT-NU     THRU 5140-EXIT 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-TEMP-AMT-WQ-NU  > WS-AMT-NONUTIL-WQ-MIN                
              PERFORM 5150-WQ-NU                         THRU 5150-EXIT 
           END-IF.                                                      
                                                                        
       2430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03460000
      * 2431-BUILD-ROWS-B-R-M.                                         *03464000
      * DETERMINES WHAT ROWS NEED TO BE WRITTEN FOR GROUP C            *03461000
      ******************************************************************03462000
                                                                        
       2431-BUILD-ROWS-B-R-M.                                           
                                                                        
           IF WS-AMT-FIRST-BAL    > ZERO                                
              PERFORM 5610-BUILD-ROW-B                   THRU 5610-EXIT 
           END-IF.                                                      
                                                                        
           IF WS-AMT-FIRST-BAL-NU > ZERO                                
              PERFORM 5690-BUILD-ROW-R                   THRU 5690-EXIT 
           END-IF.                                                      
                                                                        
           IF WS-AMT-WQ-NU        > WS-AMT-NONUTIL-WQ-MIN               
              PERFORM 5660-BUILD-ROW-M                   THRU 5660-EXIT 
           END-IF.                                                      
                                                                        
       2431-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03328000
      * 2433-BUILD-UTIL-ROWS-B-C-D                                     *03329000
      * FORECAST UTILITY CREDIT ACTION BASED ON BALANCES               *03329000
      ******************************************************************03330000
                                                                        
       2433-BUILD-UTIL-ROWS-B-C-D.                                      
                                                                        
           IF WS-AMT-FIRST-BAL  > ZERO                                  
              PERFORM 5610-BUILD-ROW-B                   THRU 5610-EXIT 
           END-IF.                                                      
                                                                        
           IF WS-AMT-SECOND-BAL > ZERO                                  
              PERFORM 5620-BUILD-ROW-C                   THRU 5620-EXIT 
              PERFORM 5630-BUILD-ROW-D                   THRU 5630-EXIT 
           END-IF.                                                      
                                                                        
       2433-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03353000
      * 2434-BUILD-NONUTL-ROWS-R-S-M                                   *03354000
      * FORECAST NON UTILITY CREDIT ACTION BASED ON BALANCES           *03354000
      ******************************************************************03355000
                                                                        
       2434-BUILD-NONUTL-ROWS-R-S-M.                                    
                                                                        
           IF WS-AMT-FIRST-BAL-NU  > ZERO                               
              PERFORM 5690-BUILD-ROW-R                   THRU 5690-EXIT 
           END-IF.                                                      
           IF WS-AMT-SECOND-BAL-NU > ZERO                               
              PERFORM 5700-BUILD-ROW-S                   THRU 5700-EXIT 
           END-IF.                                                      
                                                                        
           IF WS-AMT-WQ-NU > WS-AMT-NONUTIL-WQ-MIN                      
              PERFORM 5660-BUILD-ROW-M                   THRU 5660-EXIT 
           END-IF.                                                      
                                                                        
       2434-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00726******************************************************************07704000
P00726* 2435-PROCESS-EXCPTNL-A-N                                        07708000
P00726******************************************************************07704000
P00726                                                                  
P00726 2435-PROCESS-EXCPTNL-A-N.                                        
P00726                                                                  
P00726     MOVE WS-TOTAL-UTILITY-CHARGES     TO WS-AMT-CURRENT-BAL.     
P00726     MOVE WS-TOTAL-NONUTIL-ARREARS     TO WS-AMT-CURRENT-BAL-NU.  
P00726     IF WS-PAST-UTIL-CHARGES-CALC > 0 OR                          
P00726        WS-TOTAL-NONUTIL-ARREARS  > 0                             
P00726        CONTINUE                                                  
P00726     ELSE                                                         
P00726        GO TO 2435-EXIT                                           
P00726     END-IF.                                                      
P00726                                                                  
P00726     IF WS-PAST-UTIL-CHARGES-CALC > ZERO                          
P00726        MOVE WS-PAST-UTIL-CHARGES-CALC TO WS-TEMP-AMT-FIRST-BAL   
P00726                                          WS-TEMP-AMT-SECOND-BAL  
P00726                                          WS-TEMP-AMT-DNP-BAL     
P00726        MOVE WS-TOTAL-NONUTIL-ARREARS  TO                         
P00726                                         WS-TEMP-AMT-FIRST-BAL-NU 
P00726                                         WS-TEMP-AMT-SECOND-BAL-NU
P00726                                         WS-TEMP-AMT-WQ-NU        
P00726        IF (WS-PAST-UTIL-CHARGES-CALC > WS-FIRST-NOTICE-LIMIT OR  
P00726            WS-TOTAL-NONUTIL-ARREARS > WS-AMT-NU-COMBO-NOT-MIN)   
P00726          AND CSR-DATABASE                                        
P00726            MOVE LOW-VALUES            TO WS-AVOID-LPC-DT         
P00726        END-IF                                                    
P00726     ELSE                                                         
P00726        MOVE WS-TOTAL-NONUTIL-ARREARS  TO WS-TEMP-AMT-FIRST-BAL   
P00726                                          WS-TEMP-AMT-SECOND-BAL  
P00726                                          WS-TEMP-AMT-DNP-BAL     
P00726        MOVE LOW-VALUES                TO WS-AVOID-LPC-DT         
P00726     END-IF.                                                      
P00726                                                                  
P00726     EVALUATE TRUE                                                
P00726         WHEN WS-TEMP-AMT-FIRST-BAL > WS-FIRST-NOTICE-LIMIT AND   
P00726              WS-TEMP-AMT-FIRST-BAL-NU = 0                        
P00726              PERFORM 5110-LOAD-FIRST-BAL-AMT      THRU 5110-EXIT 
P00726         WHEN WS-TEMP-AMT-FIRST-BAL > WS-FIRST-NOTICE-LIMIT AND   
P00726              WS-TEMP-AMT-FIRST-BAL-NU > 0                        
P00726              PERFORM 5110-LOAD-FIRST-BAL-AMT      THRU 5110-EXIT 
P00726              PERFORM 5120-LOAD-FIRST-BAL-AMT-NU   THRU 5120-EXIT 
P00726         WHEN (WS-TEMP-AMT-FIRST-BAL > 0 AND                      
P00726               <= WS-FIRST-NOTICE-LIMIT) AND                      
P00726              WS-TEMP-AMT-FIRST-BAL-NU > WS-AMT-NU-COMBO-NOT-MIN  
P00726              PERFORM 5110-LOAD-FIRST-BAL-AMT      THRU 5110-EXIT 
P00726              PERFORM 5120-LOAD-FIRST-BAL-AMT-NU   THRU 5120-EXIT 
P00726         WHEN WS-TEMP-AMT-FIRST-BAL = 0 AND                       
P00726              WS-TEMP-AMT-FIRST-BAL-NU > WS-AMT-NU-COMBO-NOT-MIN  
P00726              PERFORM 5120-LOAD-FIRST-BAL-AMT-NU   THRU 5120-EXIT 
P00726     END-EVALUATE.                                                
P00726                                                                  
P00726     IF WS-TEMP-AMT-SECOND-BAL > WS-FIRST-NOTICE-LIMIT            
P00726        PERFORM 5130-LOAD-SECOND-BAL-DNP-AMT       THRU 5130-EXIT 
P00726        IF WS-TEMP-AMT-SECOND-BAL-NU > 0                          
P00726           PERFORM 5140-LOAD-SECOND-BAL-AMT-NU     THRU 5140-EXIT 
P00726        END-IF                                                    
P00726     END-IF.                                                      
P00726                                                                  
P00726     IF WS-TEMP-AMT-WQ-NU  > WS-AMT-NONUTIL-WQ-MIN                
P00726        PERFORM 5150-WQ-NU                         THRU 5150-EXIT 
P00726     END-IF.                                                      
P00726                                                                  
P00726 2435-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
      ******************************************************************05254000
      * 2440-PROCESS-GROUP-B                                           *05255000
      ******************************************************************05256000
                                                                        
       2440-PROCESS-GROUP-B.                                            
                                                                        
           MOVE WS-TOTAL-NONUTIL-CHARGES    TO WS-AMT-CURRENT-BAL-NU.   
           MOVE WS-TOTAL-UTILITY-CHARGES    TO WS-AMT-CURRENT-BAL.      
                                                                        
           IF WS-TOTAL-UTILITY-CHARGES > 0 OR                           
              WS-TOTAL-NONUTIL-CHARGES > 0                              
              CONTINUE                                                  
           ELSE                                                         
              GO TO 2440-EXIT                                           
           END-IF.                                                      
                                                                        
           IF WS-TOTAL-UTILITY-CHARGES > ZERO                           
              MOVE WS-TOTAL-UTILITY-CHARGES TO WS-TEMP-AMT-FIRST-BAL    
                                               WS-TEMP-AMT-SECOND-BAL   
                                               WS-TEMP-AMT-DNP-BAL      
              MOVE WS-TOTAL-NONUTIL-CHARGES TO WS-TEMP-AMT-FIRST-BAL-NU 
                                               WS-TEMP-AMT-SECOND-BAL-NU
                                               WS-TEMP-AMT-WQ-NU        
           ELSE                                                         
              MOVE WS-TOTAL-NONUTIL-CHARGES TO WS-TEMP-AMT-FIRST-BAL-NU 
                                               WS-TEMP-AMT-SECOND-BAL-NU
                                               WS-TEMP-AMT-WQ-NU        
           END-IF                                                       
                                                                        
           EVALUATE TRUE                                                
               WHEN WS-TOTAL-UTILITY-CHARGES > WS-FIRST-NOTICE-LIMIT AND
                    WS-TOTAL-NONUTIL-CHARGES > 0                        
                    PERFORM 5110-LOAD-FIRST-BAL-AMT      THRU 5110-EXIT 
                    PERFORM 5130-LOAD-SECOND-BAL-DNP-AMT THRU 5130-EXIT 
                    PERFORM 5120-LOAD-FIRST-BAL-AMT-NU   THRU 5120-EXIT 
                    PERFORM 5140-LOAD-SECOND-BAL-AMT-NU  THRU 5140-EXIT 
                    MOVE 80102 TO WS-TEMP-CODE-MESSAGE-TYPE             
                    IF WS-TEMP-AMT-WQ-NU > WS-AMT-NONUTIL-WQ-MIN        
                       PERFORM 5150-WQ-NU                THRU 5150-EXIT 
                    END-IF                                              
               WHEN WS-TOTAL-UTILITY-CHARGES > WS-FIRST-NOTICE-LIMIT    
                AND WS-TOTAL-NONUTIL-CHARGES = 0                        
                    PERFORM 5110-LOAD-FIRST-BAL-AMT      THRU 5110-EXIT 
                    PERFORM 5130-LOAD-SECOND-BAL-DNP-AMT THRU 5130-EXIT 
                    MOVE 90102 TO WS-TEMP-CODE-MESSAGE-TYPE             
                    IF WS-OFF-CYCLE-REBILL AND OUTSIDE-BILL-WINDOW      
                       CONTINUE                                         
                    ELSE                                                
                       MOVE 'U' TO WS-NON-UTL-CR-HST-CZ (1:1)           
                                   WS-NON-UTL-CR-HST-EX-CZ (1:1)        
                    END-IF                                              
               WHEN (WS-TOTAL-UTILITY-CHARGES > WS-ARREARS-LIMIT AND    
                                       <= WS-FIRST-NOTICE-LIMIT) OR     
                    (WS-TOTAL-NONUTIL-CHARGES > WS-AMT-NONUTIL-ARREARS  
                    AND <= WS-AMT-NU-COMBO-NOT-MIN)                     
                    IF INITIAL-BILL                                     
                       MOVE 91072         TO WS-TEMP-CODE-MESSAGE-TYPE  
                    ELSE                                                
                       MOVE 91071         TO WS-TEMP-CODE-MESSAGE-TYPE  
                    END-IF                                              
           END-EVALUATE.                                                
                                                                        
       2440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07582000
      * 2450-PROCESS-GROUP-C.                                          *05857000
      ******************************************************************07582000
                                                                        
       2450-PROCESS-GROUP-C.                                            
                                                                        
           MOVE WS-TOTAL-UTILITY-CHARGES  TO WS-AMT-CURRENT-BAL.        
           MOVE WS-TOTAL-NONUTIL-CHARGES  TO WS-AMT-CURRENT-BAL-NU.     
                                                                        
           IF WS-TOTAL-UTILITY-CHARGES  > 0 OR                          
              WS-TOTAL-NONUTIL-CHARGES  > 0                             
              CONTINUE                                                  
           ELSE                                                         
              GO TO 2450-EXIT                                           
           END-IF.                                                      
                                                                        
           IF WS-PAST-UTIL-CHARGES-CALC > 0                             
              MOVE WS-PAST-UTIL-CHARGES-CALC TO WS-TEMP-AMT-FIRST-BAL   
           END-IF.                                                      
           IF WS-TOTAL-NONUTIL-ARREARS  > 0                             
              MOVE WS-TOTAL-NONUTIL-ARREARS  TO WS-TEMP-AMT-FIRST-BAL-NU
                                                WS-TEMP-AMT-WQ-NU       
           END-IF.                                                      
                                                                        
           EVALUATE TRUE                                                
               WHEN WS-TEMP-AMT-FIRST-BAL = 0 AND                       
                    WS-TEMP-AMT-FIRST-BAL-NU > WS-AMT-NU-COMBO-NOT-MIN  
                    PERFORM 5120-LOAD-FIRST-BAL-AMT-NU   THRU 5120-EXIT 
                    IF WS-TEMP-AMT-WQ-NU  > WS-AMT-NONUTIL-WQ-MIN       
                       PERFORM 5150-WQ-NU                THRU 5150-EXIT 
                    END-IF                                              
                    IF (SEB-DATABASE  AND WS-REGULATED-CD-AT            
                       = WS-REGULATED AND WS-CREDIT-GROUP-AT = 'B')     
                       MOVE 80102         TO WS-TEMP-CODE-MESSAGE-TYPE  
                    ELSE                                                
                       MOVE 90407         TO WS-TEMP-CODE-MESSAGE-TYPE  
                    END-IF                                              
               WHEN WS-TEMP-AMT-FIRST-BAL     > WS-ARREARS-LIMIT OR     
                    WS-TEMP-AMT-FIRST-BAL-NU  > WS-AMT-NONUTIL-ARREARS  
                    IF SEB-DATABASE AND WS-REGULATED-CD-AT =            
                                              WS-REGULATED              
                       IF WS-CREDIT-GROUP-AT = 'B'                      
                          IF INITIAL-BILL                               
                             MOVE 91072   TO WS-TEMP-CODE-MESSAGE-TYPE  
                          ELSE                                          
                             MOVE 91071   TO WS-TEMP-CODE-MESSAGE-TYPE  
                          END-IF                                        
                       ELSE                                             
                          MOVE 91070      TO WS-TEMP-CODE-MESSAGE-TYPE  
                       END-IF                                           
                    ELSE                                                
                       MOVE 91001         TO WS-TEMP-CODE-MESSAGE-TYPE  
                    END-IF                                              
           END-EVALUATE.                                                
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05471000
      * 2460-PROCESS-BUDGET.                                           *05336000
      * EPP CUSTOMERS WITH ARREARS WILL GET A NOTICE WARNING THEM OF   *05332000
      * EPP DROP IF THEY DO NOT STAY CURRENT                           *05333000
      ******************************************************************05471000
                                                                        
       2460-PROCESS-BUDGET.                                             
                                                                        
           IF (SEB-DATABASE AND WS-REGULATED-CD-AT = WS-REGULATED)      
              CONTINUE                                                  
           ELSE                                                         
              IF WS-PAST-UTIL-CHARGES-CALC > WS-EPP-DELINQ-LIMIT        
                 MOVE 91001  TO WS-TEMP-CODE-MESSAGE-TYPE               
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-CREDIT-GROUP-AT = 'C'                                  
              PERFORM 2450-PROCESS-GROUP-C               THRU 2450-EXIT 
           ELSE                                                         
              PERFORM 2470-PROCESS-BBP                   THRU 2470-EXIT 
           END-IF.                                                      
                                                                        
       2460-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05355000
      * 2470-PROCESS-BBP.                                              *05362000
      * ACCOUNT IS IN ARREARS AND WILL DROP OFF EPP NEXT MONTH IF      *05356000
      * THE EPP AMOUNT IS NOT MADE CURRENT.                            *05357000
      * CREATE A 1ST NOTICE SO THAT A WARNING OF THE EPP DROP WILL     *05358000
      * PRINT ON THE CUSTOMERS BILL.                                   *05359000
      ******************************************************************05360000
                                                                        
       2470-PROCESS-BBP.                                                
                                                                        
           MOVE ZEROS                     TO WS-AMT-WQ-NU               
                                             WS-AMT-DNP-BAL             
                                             WS-AMT-SECOND-BAL          
                                             WS-AMT-SECOND-BAL-NU.      
           MOVE WS-TOTAL-UTILITY-CHARGES  TO WS-AMT-CURRENT-BAL         
                                             WS-TEMP-AMT-FIRST-BAL.     
           MOVE WS-TOTAL-NONUTIL-CHARGES  TO WS-AMT-CURRENT-BAL-NU      
                                             WS-TEMP-AMT-FIRST-BAL-NU.  
           PERFORM 5110-LOAD-FIRST-BAL-AMT               THRU 5110-EXIT 
           PERFORM 5120-LOAD-FIRST-BAL-AMT-NU            THRU 5120-EXIT 
           MOVE SPACES                    TO WS-FORECAST-CR-GRP.        
           IF WS-PAST-UTIL-CHARGES-CALC > WS-EPP-DELINQ-LIMIT           
              MOVE 90105                  TO WS-TEMP-CODE-MESSAGE-TYPE  
           END-IF.                                                      
                                                                        
       2470-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06031000
      * 2480-PROCESS-MED-CERT.                                         *06029000
      *  ROW B   WS-TEMP-AMT-FIRST-BAL                                 *06032000
      *  ROW C   WS-TEMP-AMT-SECOND-BAL                                *06033000
      *  ROW D   WS-TEMP-AMT-DNP-BAL                                   *06034000
      *  ROW E   WS-TEMP-AMT-SPCL-FIRST-BAL                            *06035000
      *  ROW F   WS-TEMP-AMT-SPCL-SECOND-BAL                           *06036000
      *  ROW G   WS-TEMP-AMT-SPCL-DNP-BAL                              *06037000
      *                                                                *06038000
      *  ROW R   WS-TEMP-AMT-FIRST-BAL-NU                              *06039000
      *  ROW S   WS-TEMP-AMT-SECOND-BAL-NU                             *06040000
      *  ROW M   WS-TEMP-AMT-WQ-NU                                     *06041000
      *  ROW T   WS-TEMP-AMT-SPCL-FIRST-BAL-NU                         *06042000
      *  ROW U   WS-TEMP-AMT-SPCL-SECOND-BAL-NU                        *06043000
      *  ROW X   WS-TEMP-AMT-SPCL-WQ-NU                                *06044000
      *  FOR SCEG, NOT FORECASTING UTILITY NORMAL 1ST NOTICE(B-ROW) &  *06044000
      *            NON-UTILITY NORMAL 1ST NOTICE(R-ROW)                *06044000
      ******************************************************************06045000
                                                                        
       2480-PROCESS-MED-CERT.                                           
                                                                        
           MOVE WS-ARREARS-DUE-DT         TO WS-TEMP-DATE-FIRST-DUE.    
                                                                        
           MOVE WS-TOTAL-UTILITY-CHARGES  TO WS-AMT-CURRENT-BAL.        
           MOVE WS-TOTAL-NONUTIL-CHARGES  TO WS-AMT-CURRENT-BAL-NU.     
           IF ( CSR-DATABASE AND WS-COMPANY-NO-AT = WS-SCEG )           
              MOVE ZEROES TO WS-TEMP-AMT-FIRST-BAL                      
              MOVE ZEROES TO WS-TEMP-AMT-FIRST-BAL-NU                   
           ELSE                                                         
              MOVE WS-CURR-UTIL-CHARGES-CALC TO WS-TEMP-AMT-FIRST-BAL   
              MOVE WS-CURR-NONUTIL-CHARGES-CALC                         
                                             TO WS-TEMP-AMT-FIRST-BAL-NU
           END-IF.                                                      
           MOVE WS-PAST-UTIL-CHARGES-CALC TO WS-TEMP-AMT-SPCL-FIRST-BAL.
           MOVE WS-TOTAL-NONUTIL-ARREARS  TO                            
                WS-TEMP-AMT-SPCL-FIRST-BAL-NU.                          
                                                                        
           IF (CSR-DATABASE AND WS-COMPANY-NO-AT = WS-SCEG)             
              MOVE WS-PAST-UTIL-CHARGES-CALC TO                         
                   WS-TEMP-AMT-SPCL-SECOND-BAL                          
                   WS-TEMP-AMT-SPCL-DNP-BAL                             
              MOVE WS-TOTAL-NONUTIL-ARREARS  TO                         
                   WS-TEMP-AMT-SPCL-SECOND-BAL-NU                       
                   WS-TEMP-AMT-SPCL-WQ-NU                               
           END-IF.                                                      
           IF (CSR-DATABASE AND WS-COMPANY-NO-AT = WS-SCEG) OR          
              (SEB-DATABASE AND WS-CREDIT-GROUP-AT = 'B')               
              MOVE WS-CURR-UTIL-CHARGES-CALC TO WS-TEMP-AMT-SECOND-BAL  
                                                WS-TEMP-AMT-DNP-BAL     
              MOVE WS-CURR-NONUTIL-CHARGES-CALC                         
                                          TO WS-TEMP-AMT-SECOND-BAL-NU  
                                             WS-TEMP-AMT-WQ-NU          
           END-IF.                                                      
                                                                        
           IF WS-CURR-CHG-DUE-DT < WS-KR100-CUST-ALRT-EXP-DT            
              MOVE WS-KR100-CUST-ALRT-EXP-DT TO WS-CURR-CHG-DUE-DT      
           END-IF.                                                      
           IF WS-TEMP-DATE-FIRST-DUE < WS-KR100-CUST-ALRT-EXP-DT        
              MOVE WS-KR100-CUST-ALRT-EXP-DT TO WS-TEMP-DATE-FIRST-DUE  
           END-IF.                                                      
                                                                        
           PERFORM 5100-DETERMINE-NOTICES                THRU 5100-EXIT.
                                                                        
       2480-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03543000
      * 2481-CHECK-SPCL-MED-CERT.                                      *03550000
      ******************************************************************03548000
                                                                        
       2481-CHECK-SPCL-MED-CERT.                                        
                                                                        
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZERO                      TO WS-HOLD-ITEM-ID.           
           MOVE WS-TEMP-CODE-MESSAGE-TYPE TO WS-HOLD-CODE-MESSAGE-TYPE  
                                             WS-BILL-CRED-NOT-ID-1H     
                                             1H-BILL-CRED-NOT-ID.       
                                                                        
           MOVE 'E'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-DATE-CURRENT-MAIL      TO WS-HOLD-DATE-NOTICE-MAIL.  
           MOVE WS-TEMP-AMT-SPCL-FIRST-BAL        TO WS-HOLD-AMT-NOTICE.
           PERFORM 5920-LOAD-WS-CREDCOLL-MEDCERT         THRU 5920-EXIT.
                                                                        
           MOVE 'T'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-DATE-CURRENT-MAIL      TO WS-HOLD-DATE-NOTICE-MAIL.  
           MOVE WS-TEMP-AMT-SPCL-FIRST-BAL-NU     TO WS-HOLD-AMT-NOTICE.
           PERFORM 5920-LOAD-WS-CREDCOLL-MEDCERT         THRU 5920-EXIT.
                                                                        
           IF (CSR-DATABASE AND WS-COMPANY-NO-AT = WS-SCEG)             
              MOVE 'F'                    TO WS-HOLD-CODE-NOTICE-TYPE   
              MOVE WS-TEMP-AMT-SPCL-SECOND-BAL    TO WS-HOLD-AMT-NOTICE 
              PERFORM 5920-LOAD-WS-CREDCOLL-MEDCERT      THRU 5920-EXIT 
                                                                        
              MOVE 'G'                    TO WS-HOLD-CODE-NOTICE-TYPE   
              MOVE LOW-VALUES             TO WS-HOLD-DATE-NOTICE-MAIL   
              MOVE WS-TEMP-AMT-SPCL-DNP-BAL       TO WS-HOLD-AMT-NOTICE 
              PERFORM 5920-LOAD-WS-CREDCOLL-MEDCERT      THRU 5920-EXIT 
                                                                        
              MOVE 'U'                    TO WS-HOLD-CODE-NOTICE-TYPE   
              MOVE WS-TEMP-AMT-SPCL-SECOND-BAL-NU TO WS-HOLD-AMT-NOTICE 
              PERFORM 5920-LOAD-WS-CREDCOLL-MEDCERT      THRU 5920-EXIT 
                                                                        
              MOVE 'X'                    TO WS-HOLD-CODE-NOTICE-TYPE   
              MOVE LOW-VALUES             TO WS-HOLD-DATE-NOTICE-MAIL   
              MOVE WS-TEMP-AMT-SPCL-WQ-NU TO WS-HOLD-AMT-NOTICE         
              PERFORM 5920-LOAD-WS-CREDCOLL-MEDCERT      THRU 5920-EXIT 
           END-IF.                                                      
                                                                        
       2481-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03328000
      * 2500-THIRD-PTY-HIST.                                           *02798000
      ******************************************************************03328000
                                                                        
       2500-THIRD-PTY-HIST.                                             
                                                                        
           PERFORM 7000-GET-TIMESTAMP                    THRU 7000-EXIT.
           MOVE WS-CURRENT-TIMESTAMP   TO                               
                             WS-TRANS-HIST-SEQ-NO-MH (WS-MH-TRN-INDX).  
           MOVE WS-CURRENT-DATE        TO                               
                             WS-DATE-TRANS-MH (WS-MH-TRN-INDX).         
           MOVE 'H'                    TO                               
                             WS-CODE-TRAN-TYPE-MH (WS-MH-TRN-INDX).     
           MOVE SPACES                 TO                               
                             WS-RESP-AREA-ID-MH (WS-MH-TRN-INDX).       
           MOVE WS-ACCOUNT-NO-AT       TO                               
                             WS-ACCOUNT-NO-MH (WS-MH-TRN-INDX).         
           MOVE WS-CUSTOMER-NO-AT      TO                               
                             WS-CUSTOMER-NO-MH (WS-MH-TRN-INDX).        
           MOVE WS-PREMISE-NO-AT       TO                               
                             WS-PREMISE-NO-MH (WS-MH-TRN-INDX).         
           MOVE 'SYSTEM'               TO                               
                             WS-USER-ID-MH (WS-MH-TRN-INDX).            
           MOVE PROGRAM-NAME           TO                               
                             WS-APPL-PROGRAM-ID-MH (WS-MH-TRN-INDX).    
           MOVE +25                    TO                               
                             WS-TRAN-COMMENT-LEN-MH(WS-MH-TRN-INDX).    
           MOVE WS-THIRD-PARTY         TO                               
                             WS-TRAN-COMMENT-TEXT-MH(WS-MH-TRN-INDX).   
                                                                        
           ADD +1                      TO WS-MH-TRN-INDX.               
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05442000
      * 2510-DEL-NOT-PROCESSED-ROW                                     *05443000
      ******************************************************************05444000
                                                                        
       2510-DEL-NOT-PROCESSED-ROW.                                      
                                                                        
           PERFORM VARYING WS-CL-INDEX FROM 1 BY 1                      
             UNTIL WS-CL-INDEX > WS-CL-MAX-ENTRY OR                     
                   WS-ACCOUNT-NO-TB (WS-CL-INDEX) = ZERO                
                   IF WS-PROCESSED-FLAG(WS-CL-INDEX) = 'N'              
                      MOVE WS-ACCOUNT-NO-TB(WS-CL-INDEX)                
                                                 TO CL-ACCOUNT-NO       
                      MOVE WS-ITEM-ID-TB(WS-CL-INDEX)                   
                                                 TO CL-ITEM-ID          
                      MOVE WS-CODE-NOTICE-TYPE-TB(WS-CL-INDEX)          
                                                 TO CL-CODE-NOTICE-TYPE 
                      PERFORM 8500-DELETE-CRED-COLL      THRU 8500-EXIT 
                   END-IF                                               
           END-PERFORM.                                                 
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05442000
      * 2600-SUB-ACCOUNT-PROCESS                                       *05443000
      ******************************************************************05444000
                                                                        
       2600-SUB-ACCOUNT-PROCESS.                                        
                                                                        
           PERFORM 7000-GET-TIMESTAMP                    THRU 7000-EXIT.
                                                                        
           MOVE WS-ACCOUNT-NO-AT       TO 1H-ACCOUNT-NO                 
                                          WS-ACCOUNT-NO-1H.             
           MOVE WS-COMPANY-NO-AT       TO 1H-COMPANY-NO                 
                                          WS-COMPANY-NO-1H.             
           MOVE WS-KR100-BILL-NO       TO 1H-BILL-NO                    
                                          WS-BILL-NO-1H.                
           MOVE WS-REG-GROUP-CD-AT     TO 1H-REG-GROUP-CD               
                                          WS-REG-GROUP-CD-1H.           
           MOVE WS-CURRENT-TIMESTAMP   TO 1H-CREATED-TS                 
                                          WS-CREATED-TS-1H.             
           MOVE WS-PAST-UTIL-CHARGES-CALC                               
                                       TO 1H-UTL-ARREARS-AM             
                                          WS-UTL-ARREARS-AM-1H.         
           MOVE WS-CURR-UTIL-CHARGES-CALC                               
                                       TO 1H-UTL-CURR-AM                
                                          WS-UTL-CURR-AM-1H.            
           MOVE WS-PASTDUE-CHARGES-CALC                                 
                                       TO 1H-TOT-ARREARS-AM             
                                          WS-TOT-ARREARS-AM-1H.         
           MOVE WS-CURRENT-CHARGES-CALC                                 
                                       TO 1H-TOT-CURR-AM                
                                          WS-TOT-CURR-AM-1H.            
           MOVE WS-CURR-NONUTIL-CHARGES-CALC                            
                                       TO 1H-NONUTL-CURR-AM             
                                          WS-NONUTL-CURR-AM-1H.         
           MOVE WS-PAST-NONUTIL-CHARGES-CALC                            
                                       TO 1H-NONUTL-ARREARS-AM          
                                          WS-NONUTL-ARREARS-AM-1H.      
           MOVE WS-LPC-AMT-1H          TO 1H-LPC-AM.                    
           MOVE WS-LPN-AMT-1H          TO 1H-LPN-AM.                    
           MOVE SPACES                 TO 1H-TOT-DUE-DT                 
                                          WS-TOT-DUE-DT-1H              
                                          1H-AVOID-LPC-DT               
                                          WS-AVOID-LPC-DT-1H            
                                          1H-AUTO-PAYMENT-DT            
                                          WS-AUTO-PAYMENT-DT-1H         
                                          1H-UTL-EXCP-DUE-DT            
                                          WS-UTL-EXCP-DUE-DT-1H         
                                          1H-UTL-NORM-DUE-DT            
                                          WS-UTL-NORM-DUE-DT-1H         
                                          1H-NONUTL-EXCP-DUE-DT         
                                          WS-NONUTL-EXCP-DUE-DT-1H      
                                          1H-NONUTL-NORM-DUE-DT         
                                          WS-NONUTL-NORM-DUE-DT-1H      
                                          1H-ADDITIONAL-DUE-DT          
                                          WS-ADDITIONAL-DUE-DT-1H       
                                          WS-BILL-CRED-MSG-ID-1H        
                                          1H-BILL-CRED-MSG-ID           
                                          1H-BILL-CRED-NOT-ID           
                                          WS-BILL-CRED-NOT-ID-1H.       
           MOVE ZEROS                  TO 1H-UTL-NORM-NOT-AM            
                                          WS-UTL-NORM-NOT-AM-1H         
                                          1H-TOT-DUE-AM                 
                                          WS-TOT-DUE-AM-1H              
                                          1H-UTL-EXCP-NOT-AM            
                                          WS-UTL-EXCP-NOT-AM-1H         
                                          1H-UTL-TOT-DUE-AM             
                                          WS-UTL-TOT-DUE-AM-1H          
                                          1H-NONUTL-TOT-DUE-AM          
                                          WS-NONUTL-TOT-DUE-AM-1H       
                                          1H-NONUTL-EXCP-NOT-AM         
                                          WS-NONUTL-EXCP-NOT-AM-1H      
                                          1H-NONUTL-NORM-NOT-AM         
                                          WS-NONUTL-NORM-NOT-AM-1H.     
           PERFORM 8110-INSERT-BILL-CRED-DET             THRU 8110-EXIT.
           PERFORM 2950-CREDIT-PROFILE-PROCESS           THRU 2950-EXIT.
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03912200
      * 2700-GET-DNP-TYPE.                                             *03912300
      * SET THE CORRECT DNP TYPE.                                      *03912400
      *                                                                *03912400
      * THE DNP TYPES SET HERE ARE:                                    *03912400
      * N - NORMAL                                                     *03912400
      * J - NORMAL DPP                                                 *03912400
      * U - DROPPED DPP                                                *03912400
      ******************************************************************03912600
                                                                        
       2700-GET-DNP-TYPE.                                               
                                                                        
           MOVE SPACES            TO WS-TEMP-CODE-SPECIAL-TYPE.         
           EVALUATE TRUE                                                
A05323       WHEN DPP-ACCOUNT                                           
                  MOVE 'J'        TO WS-TEMP-CODE-SPECIAL-TYPE          
A05323       WHEN FIRST-BILL-AFT-DPP-DROP                               
                  MOVE 'U'        TO WS-TEMP-CODE-SPECIAL-TYPE          
             WHEN OTHER                                                 
A05323            MOVE 'N'     TO WS-TEMP-CODE-SPECIAL-TYPE             
           END-EVALUATE.                                                
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2800-SET-TRANS-HIST                                            *        
      ******************************************************************        
                                                                        
       2800-SET-TRANS-HIST.                                             
                                                                        
           SET DO-NOT-WRITE-MNT-ROW          TO TRUE.                   
                                                                        
           IF WS-MST-SUB-ACCT-IND-AT = WS-MASTER                        
              SET WRITE-MNT-ROW              TO TRUE                    
           END-IF.                                                      
                                                                        
      * Write transaction history only on Master accounts                       
           IF WRITE-MNT-ROW                                             
              PERFORM 2100-FORMAT-TRANS-HIST-HDR-DTL     THRU 2100-EXIT 
                                                                        
              MOVE WS-CURRENT-TIMESTAMP      TO                         
                                 WS-TRN-HST-DET-KEY-MI(WS-MI-DET-INDX)  
              MOVE SPACES                    TO                         
                                 WS-TABLE-ID-MI(WS-MI-DET-INDX)         
              MOVE 'ARREARS_HIST   '         TO                         
                                 WS-COLUMN-DESC-MI(WS-MI-DET-INDX)      
              MOVE +24                       TO                         
                                 WS-PRV-COLUMN-LEN-MI(WS-MI-DET-INDX)   
              MOVE WS-KR100-PREV-ARR-HIST    TO                         
                                 WS-PRV-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              MOVE +24                       TO                         
                                 WS-CHG-COLUMN-LEN-MI(WS-MI-DET-INDX)   
              MOVE WS-ARREARS-HIST-CZ        TO                         
                                 WS-CHG-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              ADD 1                          TO WS-MI-TRAN-APPL-NO      
              MOVE WS-MI-TRAN-APPL-NO        TO                         
                                 WS-TRAN-APPL-NO-MI(WS-MI-DET-INDX)     
                                                                        
      *                                                                         
              ADD +1                         TO WS-MI-DET-INDX          
              MOVE WS-CURRENT-TIMESTAMP      TO                         
                                 WS-TRN-HST-DET-KEY-MI(WS-MI-DET-INDX)  
              MOVE SPACES                    TO                         
                                 WS-TABLE-ID-MI(WS-MI-DET-INDX)         
              MOVE 'DISCONNECT_HIST'         TO                         
                                 WS-COLUMN-DESC-MI(WS-MI-DET-INDX)      
              MOVE +24                       TO                         
                                 WS-PRV-COLUMN-LEN-MI(WS-MI-DET-INDX)   
              MOVE WS-KR100-PREV-DISC-HIST   TO                         
                                 WS-PRV-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              MOVE +24                       TO                         
                                 WS-CHG-COLUMN-LEN-MI(WS-MI-DET-INDX)   
              MOVE WS-DISCONNECT-HIST-CZ     TO                         
                                 WS-CHG-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              ADD 1                          TO WS-MI-TRAN-APPL-NO      
              MOVE WS-MI-TRAN-APPL-NO        TO                         
                                 WS-TRAN-APPL-NO-MI(WS-MI-DET-INDX)     
      *                                                                         
              ADD +1                         TO WS-MI-DET-INDX          
              MOVE WS-CURRENT-TIMESTAMP      TO                         
                                 WS-TRN-HST-DET-KEY-MI(WS-MI-DET-INDX)  
              MOVE SPACES                    TO                         
                                 WS-TABLE-ID-MI(WS-MI-DET-INDX)         
              MOVE 'DISC_EXCEP_HIST'         TO                         
                                 WS-COLUMN-DESC-MI(WS-MI-DET-INDX)      
              MOVE +24                       TO                         
                                 WS-PRV-COLUMN-LEN-MI(WS-MI-DET-INDX)   
              MOVE WS-KR100-PREV-DISC-EX-HIST TO                        
                                 WS-PRV-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              MOVE +24                       TO                         
                                 WS-CHG-COLUMN-LEN-MI(WS-MI-DET-INDX)   
              MOVE WS-DISC-EXCEPTN-HIST-CZ   TO                         
                                 WS-CHG-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              ADD 1                          TO WS-MI-TRAN-APPL-NO      
              MOVE WS-MI-TRAN-APPL-NO        TO                         
                                 WS-TRAN-APPL-NO-MI(WS-MI-DET-INDX)     
      *                                                                         
              ADD +1                         TO WS-MI-DET-INDX          
              MOVE WS-CURRENT-TIMESTAMP      TO                         
                                 WS-TRN-HST-DET-KEY-MI(WS-MI-DET-INDX)  
              MOVE SPACES                    TO                         
                                 WS-TABLE-ID-MI(WS-MI-DET-INDX)         
              MOVE 'NUTL_ARRER_HIST'         TO                         
                                 WS-COLUMN-DESC-MI(WS-MI-DET-INDX)      
              MOVE +24                       TO                         
                                 WS-PRV-COLUMN-LEN-MI(WS-MI-DET-INDX)   
              MOVE WS-KR100-PREV-NU-ARR-HIST TO                         
                                 WS-PRV-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              MOVE +24                       TO                         
                                 WS-CHG-COLUMN-LEN-MI(WS-MI-DET-INDX)   
              MOVE WS-NON-UTL-ARRER-HIST-CZ  TO                         
                                 WS-CHG-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              ADD 1                          TO WS-MI-TRAN-APPL-NO      
              MOVE WS-MI-TRAN-APPL-NO        TO                         
                                 WS-TRAN-APPL-NO-MI(WS-MI-DET-INDX)     
      *                                                                         
              ADD +1                         TO WS-MI-DET-INDX          
              MOVE WS-CURRENT-TIMESTAMP      TO                         
                                 WS-TRN-HST-DET-KEY-MI(WS-MI-DET-INDX)  
              MOVE SPACES                    TO                         
                                 WS-TABLE-ID-MI(WS-MI-DET-INDX)         
              MOVE 'NON_UTL_CR_HST '         TO                         
                                 WS-COLUMN-DESC-MI(WS-MI-DET-INDX)      
              MOVE +24                       TO                         
                                 WS-PRV-COLUMN-LEN-MI(WS-MI-DET-INDX)   
              MOVE WS-KR100-PREV-NU-CR-HIST  TO                         
                                 WS-PRV-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              MOVE +24                       TO                         
                                 WS-CHG-COLUMN-LEN-MI(WS-MI-DET-INDX)   
              MOVE WS-NON-UTL-CR-HST-CZ      TO                         
                                 WS-CHG-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              ADD 1                          TO WS-MI-TRAN-APPL-NO      
              MOVE WS-MI-TRAN-APPL-NO        TO                         
                                 WS-TRAN-APPL-NO-MI(WS-MI-DET-INDX)     
      *                                                                         
              ADD +1                         TO WS-MI-DET-INDX          
              MOVE WS-CURRENT-TIMESTAMP      TO                         
                                 WS-TRN-HST-DET-KEY-MI(WS-MI-DET-INDX)  
              MOVE SPACES                    TO                         
                                 WS-TABLE-ID-MI(WS-MI-DET-INDX)         
              MOVE 'NUTL_CR_HST_EX '         TO                         
                                 WS-COLUMN-DESC-MI(WS-MI-DET-INDX)      
              MOVE +24                       TO                         
                                 WS-PRV-COLUMN-LEN-MI(WS-MI-DET-INDX)   
              MOVE WS-KR100-PREV-NU-CR-EX-HIST TO                       
                                 WS-PRV-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              MOVE +24                       TO                         
                                 WS-CHG-COLUMN-LEN-MI(WS-MI-DET-INDX)   
              MOVE WS-NON-UTL-CR-HST-EX-CZ   TO                         
                                 WS-CHG-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              ADD 1                          TO WS-MI-TRAN-APPL-NO      
              MOVE WS-MI-TRAN-APPL-NO        TO                         
                                 WS-TRAN-APPL-NO-MI(WS-MI-DET-INDX)     
              ADD +1                         TO WS-MI-DET-INDX          
                                                                        
           END-IF.                                                      
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 03309000
      * 2900-CALC-UTL-NONUTL-ARR-CHRG                                 * 03310000
      ***************************************************************** 03311000
                                                                        
       2900-CALC-UTL-NONUTL-ARR-CHRG.                                   
                                                                        
           MOVE WS-PAST-NONUTIL-CHARGES-CALC TO WS-TOTAL-NONUTIL-ARREARS
           COMPUTE WS-TOTAL-UTILITY-CHARGES     =                       
                   WS-CURR-UTIL-CHARGES-CALC    +                       
                   WS-PAST-UTIL-CHARGES-CALC.                           
           COMPUTE WS-TOTAL-NONUTIL-CHARGES     =                       
                   WS-CURR-NONUTIL-CHARGES-CALC +                       
                   WS-PAST-NONUTIL-CHARGES-CALC.                        
           COMPUTE WS-TOTAL-DUE-AMT             =                       
                   WS-TOTAL-UTILITY-CHARGES     +                       
                   WS-TOTAL-NONUTIL-CHARGES.                            
           COMPUTE WS-TOT-NON-UTIL-CRED-BUR     =                       
                   WS-KR100-UTL-60-DELINQ       +                       
                   WS-KR100-UTL-90-DELINQ       +                       
                   WS-KR100-NON-UTL-60-DELINQ   +                       
                   WS-KR100-NON-UTL-90-DELINQ.                          
           COMPUTE WS-TOTAL-ARREARS             =                       
                   WS-PAST-UTIL-CHARGES-CALC    +                       
                   WS-TOTAL-NONUTIL-ARREARS.                            
                                                                        
       2900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 03309000
      * 2950-CREDIT-PROFILE-PROCESS                                   * 03310000
      ***************************************************************** 03311000
                                                                        
       2950-CREDIT-PROFILE-PROCESS.                                     
                                                                        
           MOVE WS-ARREARS-HIST-CZ       TO CZ-ARREARS-HIST.            
           MOVE WS-DISCONNECT-HIST-CZ    TO CZ-DISCONNECT-HIST.         
           MOVE WS-DISC-EXCEPTN-HIST-CZ  TO CZ-DISC-EXCEPTN-HIST.       
           MOVE WS-NON-UTL-ARRER-HIST-CZ TO CZ-NON-UTL-ARRER-HIST.      
           MOVE WS-NON-UTL-CR-HST-CZ     TO CZ-NON-UTL-CR-HST.          
           MOVE WS-NON-UTL-CR-HST-EX-CZ  TO CZ-NON-UTL-CR-HST-EX.       
           MOVE ZEROS                    TO CZ-AUTO-DEP-AM.             
           MOVE WS-CR-GRP-EFFECT-DT-CZ   TO CZ-CR-GRP-EFFECT-DT.        
           PERFORM 8310-UPDATE-UTL-NUTL-HIST             THRU 8310-EXIT.
      * Process of transaction history                                          
           PERFORM 2800-SET-TRANS-HIST                   THRU 2800-EXIT.
                                                                        
       2950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 03309000
      * 5000-BUILD-NOTICES.                                           * 03310000
      ***************************************************************** 03311000
                                                                        
       5000-BUILD-NOTICES.                                              
                                                                        
           PERFORM 5600-BUILD-ROW-A                      THRU 5600-EXIT.
           IF WS-AMT-CURRENT-BAL       > ZERO                           
              PERFORM 5670-BUILD-ROW-P                   THRU 5670-EXIT 
           END-IF.                                                      
                                                                        
           IF WS-TOTAL-NONUTIL-CHARGES > ZERO                           
              PERFORM 5680-BUILD-ROW-Q                   THRU 5680-EXIT 
           END-IF.                                                      
                                                                        
           PERFORM 2433-BUILD-UTIL-ROWS-B-C-D            THRU 2433-EXIT.
           PERFORM 2434-BUILD-NONUTL-ROWS-R-S-M          THRU 2434-EXIT.
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00726***************************************************************** 03309000
P00726* 5010-BUILD-EXCPTNL-NOTICES                                    * 03310000
P00726***************************************************************** 03311000
P00726                                                                  
P00726 5010-BUILD-EXCPTNL-NOTICES.                                      
P00726                                                                  
P00726     MOVE 0                         TO WS-TEMP-CODE-MESSAGE-TYPE. 
P00726                                                                  
P00726     PERFORM 5600-BUILD-ROW-A                      THRU 5600-EXIT.
P00726                                                                  
P00726     IF WS-AMT-CURRENT-BAL       > ZERO                           
P00726        PERFORM 5670-BUILD-ROW-P                   THRU 5670-EXIT 
P00726     END-IF.                                                      
P00726                                                                  
P00726     IF WS-TOTAL-NONUTIL-CHARGES > ZERO                           
P00726        PERFORM 5680-BUILD-ROW-Q                   THRU 5680-EXIT 
P00726     END-IF.                                                      
P00726                                                                  
P00726     PERFORM VARYING WS-4W-INDEX FROM 1 BY 1                      
P00726       UNTIL WS-4W-INDEX > WS-CRED-ACTN-COUNTER OR                
P00726       WS-4W-ACCOUNT-NO-TB (WS-4W-INDEX) = ZERO                   
P00726       EVALUATE WS-4W-CRED-ACTN-TYPE-CD-TB (WS-4W-INDEX)          
P00726          WHEN 'UFN'                                              
P00726               MOVE 'E'             TO WS-HOLD-CODE-NOTICE-TYPE   
P00726               MOVE WS-4W-CRED-ACTN-FCST-DT-TB(WS-4W-INDEX)       
P00726                                    TO WS-HOLD-DATE-NOTICE-MAIL   
P00726               IF WS-4W-CRED-ACTN-DUE-DT-TB(WS-4W-INDEX) > SPACES 
P00726                  MOVE WS-4W-CRED-ACTN-DUE-DT-TB(WS-4W-INDEX)     
P00726                                    TO WS-HOLD-DATE-NOTICE-DUE    
P00726                                       1H-UTL-NORM-DUE-DT         
P00726                                       WS-UTL-NORM-DUE-DT-1H      
P00726               ELSE                                               
P00726                  MOVE LOW-VALUES   TO WS-HOLD-DATE-NOTICE-DUE    
P00726                                       1H-UTL-NORM-DUE-DT         
P00726                                       WS-UTL-NORM-DUE-DT-1H      
P00726               END-IF                                             
P00726               MOVE LOW-VALUE       TO WS-HOLD-DATE-CREDIT-ACTION 
P00726               MOVE WS-AMT-FIRST-BAL    TO WS-HOLD-AMT-NOTICE     
P00726               PERFORM 5030-POPULATE-MSG-TYPE-STAA THRU 5030-EXIT 
P00726               IF WS-AMT-FIRST-BAL  > ZERO                        
P00726                  PERFORM 5760-BUILD-EXCPTNL-ROWS  THRU 5760-EXIT 
P00726               END-IF                                             
P00726          WHEN 'ULN'                                              
P00726               MOVE 'F'             TO WS-HOLD-CODE-NOTICE-TYPE   
P00726               MOVE WS-4W-CRED-ACTN-FCST-DT-TB(WS-4W-INDEX)       
P00726                                    TO WS-HOLD-DATE-NOTICE-MAIL   
P00726               IF WS-4W-CRED-ACTN-DUE-DT-TB(WS-4W-INDEX) > SPACES 
P00726                  MOVE WS-4W-CRED-ACTN-DUE-DT-TB(WS-4W-INDEX)     
P00726                                    TO WS-HOLD-DATE-NOTICE-DUE    
P00726               ELSE                                               
P00726                  MOVE LOW-VALUES   TO WS-HOLD-DATE-NOTICE-DUE    
P00726               END-IF                                             
P00726               MOVE 0               TO WS-TEMP-CODE-MESSAGE-TYPE  
P00726               MOVE WS-HOLD-CRED-ACTN-IVR-DT                      
P00726                                    TO WS-HOLD-DATE-CREDIT-ACTION 
P00726               MOVE WS-AMT-SECOND-BAL  TO WS-HOLD-AMT-NOTICE      
P00726               IF WS-AMT-SECOND-BAL > ZERO                        
P00726                  PERFORM 5760-BUILD-EXCPTNL-ROWS  THRU 5760-EXIT 
P00726               END-IF                                             
P00726          WHEN 'DNP'                                              
P00726               MOVE 'G'             TO WS-HOLD-CODE-NOTICE-TYPE   
P00726               MOVE LOW-VALUE       TO WS-HOLD-DATE-NOTICE-MAIL   
P00726                                       WS-HOLD-DATE-NOTICE-DUE    
P00726               MOVE WS-4W-CRED-ACTN-FCST-DT-TB(WS-4W-INDEX)       
P00726                                    TO WS-HOLD-DATE-CREDIT-ACTION 
P00726               MOVE WS-AMT-DNP-BAL  TO WS-HOLD-AMT-NOTICE         
P00726               MOVE 0               TO WS-TEMP-CODE-MESSAGE-TYPE  
P00726               IF WS-AMT-SECOND-BAL > ZERO                        
P00726                  PERFORM 5760-BUILD-EXCPTNL-ROWS  THRU 5760-EXIT 
P00726               END-IF                                             
P00726          WHEN 'NFN'                                              
P00726               MOVE 'T'             TO WS-HOLD-CODE-NOTICE-TYPE   
P00726               MOVE WS-4W-CRED-ACTN-FCST-DT-TB(WS-4W-INDEX)       
P00726                                    TO WS-HOLD-DATE-NOTICE-MAIL   
P00726               IF WS-4W-CRED-ACTN-DUE-DT-TB(WS-4W-INDEX) > SPACES 
P00726                  MOVE WS-4W-CRED-ACTN-DUE-DT-TB(WS-4W-INDEX)     
P00726                                    TO WS-HOLD-DATE-NOTICE-DUE    
P00726                                       1H-NONUTL-NORM-DUE-DT      
P00726                                       WS-NONUTL-NORM-DUE-DT-1H   
P00726               ELSE                                               
P00726                  MOVE LOW-VALUES   TO WS-HOLD-DATE-NOTICE-DUE    
P00726                                       1H-NONUTL-NORM-DUE-DT      
P00726                                       WS-NONUTL-NORM-DUE-DT-1H   
P00726               END-IF                                             
P00726               MOVE LOW-VALUE       TO WS-HOLD-DATE-CREDIT-ACTION 
P00726               MOVE WS-AMT-FIRST-BAL-NU                           
P00726                                    TO WS-HOLD-AMT-NOTICE         
P00726                                       WS-HOLD-NU-ARREARS         
P00726               PERFORM 5030-POPULATE-MSG-TYPE-STAA THRU 5030-EXIT 
P00726               IF WS-AMT-FIRST-BAL-NU  > ZERO                     
P00726                  PERFORM 5760-BUILD-EXCPTNL-ROWS  THRU 5760-EXIT 
P00726               END-IF                                             
P00726          WHEN 'NLN'                                              
P00726               MOVE 'U'             TO WS-HOLD-CODE-NOTICE-TYPE   
P00726               MOVE WS-4W-CRED-ACTN-FCST-DT-TB(WS-4W-INDEX)       
P00726                                    TO WS-HOLD-DATE-NOTICE-MAIL   
P00726               IF WS-4W-CRED-ACTN-DUE-DT-TB(WS-4W-INDEX) > SPACES 
P00726                  MOVE WS-4W-CRED-ACTN-DUE-DT-TB(WS-4W-INDEX)     
P00726                                    TO WS-HOLD-DATE-NOTICE-DUE    
P00726               ELSE                                               
P00726                  MOVE LOW-VALUES   TO WS-HOLD-DATE-NOTICE-DUE    
P00726               END-IF                                             
P00726               MOVE WS-HOLD-CRED-ACTN-IVR-DT                      
P00726                                    TO WS-HOLD-DATE-CREDIT-ACTION 
P00726               MOVE 0               TO WS-TEMP-CODE-MESSAGE-TYPE  
P00726               MOVE WS-AMT-SECOND-BAL-NU                          
P00726                                    TO WS-HOLD-AMT-NOTICE         
P00726               IF WS-AMT-SECOND-BAL-NU > ZERO                     
P00726                  PERFORM 5760-BUILD-EXCPTNL-ROWS  THRU 5760-EXIT 
P00726               END-IF                                             
P00726          WHEN 'NWQ'                                              
P00726               MOVE 'X'             TO WS-HOLD-CODE-NOTICE-TYPE   
P00726               MOVE LOW-VALUE       TO WS-HOLD-DATE-NOTICE-DUE    
P00726                                       WS-HOLD-DATE-NOTICE-MAIL   
P00726               MOVE WS-4W-CRED-ACTN-FCST-DT-TB(WS-4W-INDEX)       
P00726                                    TO WS-HOLD-DATE-CREDIT-ACTION 
P00726               MOVE 0               TO WS-TEMP-CODE-MESSAGE-TYPE  
P00726               MOVE WS-AMT-WQ-NU    TO WS-HOLD-AMT-NOTICE         
P00726               IF WS-AMT-WQ-NU > WS-AMT-NONUTIL-WQ-MIN            
P00726                  PERFORM 5760-BUILD-EXCPTNL-ROWS  THRU 5760-EXIT 
P00726               END-IF                                             
P00726       END-EVALUATE                                               
P00726                                                                  
P00726* Populate cred actn table values                                         
P00726       MOVE WS-4W-ARNG-ID-TB(WS-4W-INDEX)                         
P00726                                    TO 4W-ARNG-ID                 
P00726       MOVE WS-4W-CRED-ARNG-SEQ-TB(WS-4W-INDEX)                   
P00726                                    TO 4W-CRED-ARNG-SEQ           
P00726       MOVE WS-4W-CRED-ACTN-TYPE-CD-TB(WS-4W-INDEX)               
P00726                                    TO 4W-CRED-ACTN-TYPE-CD       
P00726       MOVE WS-4W-CRED-ACTN-SEQ-TB(WS-4W-INDEX)                   
P00726                                    TO 4W-CRED-ACTN-SEQ           
P00726       MOVE WS-KR100-BILL-NO        TO 4W-BILL-NO                 
P00726       PERFORM 8320-UPDATE-BILL-NO-ACTN-FL         THRU 8320-EXIT 
P00726                                                                  
P00726     END-PERFORM.                                                 
P00726                                                                  
P00726 5010-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
P00726***************************************************************** 03309000
P00726* 5020-GET-IVR-DATE                                             * 03310000
P00726***************************************************************** 03311000
P00726                                                                  
P00726 5020-GET-IVR-DATE.                                               
P00726                                                                  
P00726     SET WS-4W-INDEX TO 1                                         
P00726     SEARCH WS-CRED-ACTN-TB                                       
P00726         AT END                                                   
P00726            MOVE SPACES             TO WS-HOLD-CRED-ACTN-IVR-DT   
P00726                                       WS-HOLD-CRED-ACTN-IVR-DT   
P00726       WHEN WS-4W-CRED-ACTN-TYPE-CD-TB (WS-4W-INDEX) = 'IVR'      
P00726            MOVE WS-4W-CRED-ACTN-FCST-DT-TB (WS-4W-INDEX)         
P00726                                    TO WS-HOLD-CRED-ACTN-IVR-DT   
P00726     END-SEARCH.                                                  
P00726                                                                  
P00726 5020-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
P00726***************************************************************** 03309000
P00726* 5030-POPULATE-MSG-TYPE-STAA                                   * 03310000
P00726***************************************************************** 03311000
P00726                                                                  
P00726 5030-POPULATE-MSG-TYPE-STAA.                                     
P00726                                                                  
P00726     MOVE 0                         TO WS-BILL-CRED-NOT-ID-1H     
P00726                                       1H-BILL-CRED-NOT-ID.       
P00726     EVALUATE TRUE                                                
P00726         WHEN WS-TEMP-AMT-FIRST-BAL > WS-FIRST-NOTICE-LIMIT AND   
P00726              WS-TEMP-AMT-FIRST-BAL-NU = 0                        
P00726              MOVE '90104'          TO WS-TEMP-CODE-MESSAGE-TYPE  
P00726                                       WS-BILL-CRED-NOT-ID-1H     
P00726                                       1H-BILL-CRED-NOT-ID        
P00726         WHEN WS-TEMP-AMT-FIRST-BAL > WS-FIRST-NOTICE-LIMIT AND   
P00726              WS-TEMP-AMT-FIRST-BAL-NU > 0                        
P00726              MOVE '80104'          TO WS-TEMP-CODE-MESSAGE-TYPE  
P00726                                       WS-BILL-CRED-NOT-ID-1H     
P00726                                       1H-BILL-CRED-NOT-ID        
p00726     END-EVALUATE.                                                
P00726                                                                  
P00726 5030-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
      ******************************************************************05254000
      *  5050-GET-AUTO-CARD-PYMT-DATA                                  *05255000
      ******************************************************************05256000
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00338                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************07582000
      * 5100-DETERMINE-NOTICES.                                        *05630000
      ******************************************************************07582000
                                                                        
       5100-DETERMINE-NOTICES.                                          
                                                                        
           EVALUATE TRUE                                                
               WHEN (WS-PAST-UTIL-CHARGES-CALC  > WS-FIRST-NOTICE-LIMIT 
                    AND WS-TOTAL-NONUTIL-ARREARS > 0) OR                
                    (WS-PAST-UTIL-CHARGES-CALC   > 0 AND                
                    WS-TOTAL-NONUTIL-ARREARS > WS-AMT-NU-COMBO-NOT-MIN) 
                    IF ( CSR-DATABASE AND WS-COMPANY-NO-AT = WS-SCEG )  
                       MOVE 80111 TO WS-TEMP-CODE-MESSAGE-TYPE          
                    ELSE                                                
                       MOVE 80110 TO WS-TEMP-CODE-MESSAGE-TYPE          
                    END-IF                                              
               WHEN (WS-PAST-UTIL-CHARGES-CALC > WS-FIRST-NOTICE-LIMIT  
                    AND WS-TOTAL-NONUTIL-ARREARS  = 0) OR               
                    (WS-TOTAL-NONUTIL-ARREARS > WS-AMT-NU-COMBO-NOT-MIN 
                    AND WS-PAST-UTIL-CHARGES-CALC = 0)                  
                    IF ( CSR-DATABASE AND WS-COMPANY-NO-AT = WS-SCEG )  
                       MOVE 90111 TO WS-TEMP-CODE-MESSAGE-TYPE          
                    ELSE                                                
                       MOVE 90110 TO WS-TEMP-CODE-MESSAGE-TYPE          
                    END-IF                                              
               WHEN (CSR-DATABASE AND WS-COMPANY-NO-AT = WS-SCEG)       
               WHEN (SEB-DATABASE AND WS-CREDIT-GROUP-AT = 'B')         
                    MOVE WS-TOTAL-UTILITY-CHARGES TO                    
                                         WS-TEMP-AMT-FIRST-BAL          
                                         WS-TEMP-AMT-SECOND-BAL         
                    MOVE WS-TOTAL-NONUTIL-CHARGES TO                    
                                         WS-TEMP-AMT-FIRST-BAL-NU       
                                         WS-TEMP-AMT-SECOND-BAL-NU      
                                         WS-TEMP-AMT-WQ-NU              
                    MOVE ZEROES TO WS-TEMP-AMT-SPCL-FIRST-BAL           
                                         WS-TEMP-AMT-SPCL-SECOND-BAL    
                                         WS-TEMP-AMT-SPCL-DNP-BAL       
                                         WS-TEMP-AMT-SPCL-FIRST-BAL-NU  
                                         WS-TEMP-AMT-SPCL-SECOND-BAL-NU 
                                         WS-TEMP-AMT-SPCL-WQ-NU         
                    IF WS-PAST-UTIL-CHARGES-CALC   > 0                  
                       IF WS-TOTAL-UTILITY-CHARGES > 0 AND              
                          WS-TOTAL-NONUTIL-CHARGES > 0                  
                          MOVE 80102     TO WS-TEMP-CODE-MESSAGE-TYPE   
                       ELSE                                             
                          MOVE 90102     TO WS-TEMP-CODE-MESSAGE-TYPE   
                       END-IF                                           
                    END-IF                                              
           END-EVALUATE.                                                
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05429000
      * 5110-LOAD-FIRST-BAL-AMT                                        *05430000
      ******************************************************************05431000
                                                                        
       5110-LOAD-FIRST-BAL-AMT.                                         
                                                                        
           MOVE WS-TEMP-AMT-FIRST-BAL    TO WS-AMT-FIRST-BAL.           
                                                                        
       5110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05442000
      *  5120-LOAD-FIRST-BAL-AMT-NU                                    *05443000
      ******************************************************************05444000
                                                                        
       5120-LOAD-FIRST-BAL-AMT-NU.                                      
                                                                        
           MOVE WS-TEMP-AMT-FIRST-BAL-NU TO WS-AMT-FIRST-BAL-NU.        
                                                                        
       5120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05455000
      * 5130-LOAD-SECOND-BAL-DNP-AMT                                   *05456000
      ******************************************************************05457000
                                                                        
       5130-LOAD-SECOND-BAL-DNP-AMT.                                    
                                                                        
           MOVE WS-TEMP-AMT-SECOND-BAL   TO WS-AMT-SECOND-BAL.          
           MOVE WS-TEMP-AMT-DNP-BAL      TO WS-AMT-DNP-BAL.             
                                                                        
       5130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05471000
      * 5140-LOAD-SECOND-BAL-AMT-NU                                    *05472000
      ******************************************************************05473000
                                                                        
       5140-LOAD-SECOND-BAL-AMT-NU.                                     
                                                                        
           MOVE WS-TEMP-AMT-SECOND-BAL-NU TO WS-AMT-SECOND-BAL-NU.      
                                                                        
       5140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05512000
      * 5150-WQ-NU                                                     *05513000
      ******************************************************************05514000
                                                                        
       5150-WQ-NU.                                                      
                                                                        
           MOVE WS-TEMP-AMT-WQ-NU         TO WS-AMT-WQ-NU.              
                                                                        
       5150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07582000
      * 5500-BUILD-MSG-MAINTENANCE.                                    *06313000
      ******************************************************************07582000
                                                                        
       5500-BUILD-MSG-MAINTENANCE.                                      
                                                                        
           INITIALIZE   WS-CWS00136-NOTICE-TYPE                         
                        WS-CWS00136-DATE-MAIL                           
                        WS-CWS00136-DATE-NOTICE-DUE                     
                        WS-CWS00136-AMT-NOTICE-DOL                      
                        WS-CWS00136-AMT-NOTICE-DEC                      
                        WS-CWS00136-MESSAGE-NUMBER                      
                        WS-HOLD-AMOUNT.                                 
                                                                        
           EVALUATE WS-HOLD-CODE-MESSAGE-TYPE                           
               WHEN 90401                                               
                    MOVE 'NON-UTILITY 1ST NOTICE        '               
                                            TO WS-CWS00136-NOTICE-TYPE  
               WHEN 90402                                               
                    MOVE 'NON-UTILITY 2ND NOTICE(CR BUR)'               
                                            TO WS-CWS00136-NOTICE-TYPE  
               WHEN 90403                                               
                    MOVE 'NON-UTILITY 2ND NOTICE        '               
                                            TO WS-CWS00136-NOTICE-TYPE  
               WHEN 90404                                               
                    MOVE 'NON-UTILITY 3RD NOTICE(CR BUR)'               
                                            TO WS-CWS00136-NOTICE-TYPE  
               WHEN 90405                                               
                    MOVE 'NON-UTILITY 3RD NOTICE        '               
                                            TO WS-CWS00136-NOTICE-TYPE  
           END-EVALUATE.                                                
                                                                        
           MOVE WS-HOLD-CODE-MESSAGE-TYPE      TO                       
                WS-CWS00136-MESSAGE-NUMBER.                             
           MOVE SPACES TO WS-CWS00136-DATE-MAIL.                        
           MOVE WS-SLASHES-6             TO WS-CWS00136-DATE-MAIL.      
           MOVE WS-HOLD-DATE-NOTICE-MAIL (6:2) TO                       
                WS-CWS00136-DATE-MAIL (1:2).                            
           MOVE WS-HOLD-DATE-NOTICE-MAIL (9:2) TO                       
                WS-CWS00136-DATE-MAIL (4:2).                            
           MOVE WS-HOLD-DATE-NOTICE-MAIL (1:4) TO                       
                WS-CWS00136-DATE-MAIL (7:4).                            
           MOVE SPACES TO WS-CWS00136-DATE-NOTICE-DUE.                  
           MOVE WS-SLASHES-6             TO WS-CWS00136-DATE-NOTICE-DUE.
           MOVE WS-HOLD-DATE-NOTICE-DUE (6:2)  TO                       
                WS-CWS00136-DATE-NOTICE-DUE (1:2).                      
           MOVE WS-HOLD-DATE-NOTICE-DUE (9:2)  TO                       
                WS-CWS00136-DATE-NOTICE-DUE (4:2).                      
           MOVE WS-HOLD-DATE-NOTICE-DUE (1:4)  TO                       
                WS-CWS00136-DATE-NOTICE-DUE (7:4).                      
           MOVE WS-HOLD-AMT-NOTICE       TO WS-HOLD-AMOUNT.             
           MOVE WS-DOL-AMOUNT            TO WS-CWS00136-AMT-NOTICE-DOL. 
           MOVE WS-DEC-AMOUNT            TO WS-CWS00136-AMT-NOTICE-DEC. 
                                                                        
           PERFORM 7000-GET-TIMESTAMP                    THRU 7000-EXIT.
           MOVE WS-CURRENT-TIMESTAMP   TO                               
                             WS-TRANS-HIST-SEQ-NO-MH (WS-MH-TRN-INDX).  
           MOVE WS-CURRENT-DATE        TO                               
                             WS-DATE-TRANS-MH (WS-MH-TRN-INDX).         
           MOVE 'H'                    TO                               
                             WS-CODE-TRAN-TYPE-MH (WS-MH-TRN-INDX).     
           MOVE SPACES                 TO                               
                             WS-RESP-AREA-ID-MH (WS-MH-TRN-INDX).       
           MOVE WS-ACCOUNT-NO-AT       TO                               
                             WS-ACCOUNT-NO-MH (WS-MH-TRN-INDX).         
           MOVE WS-CUSTOMER-NO-AT      TO                               
                             WS-CUSTOMER-NO-MH (WS-MH-TRN-INDX).        
           MOVE WS-PREMISE-NO-AT       TO                               
                             WS-PREMISE-NO-MH (WS-MH-TRN-INDX).         
           MOVE 'SYSTEM'               TO                               
                             WS-USER-ID-MH (WS-MH-TRN-INDX).            
           MOVE PROGRAM-NAME           TO                               
                             WS-APPL-PROGRAM-ID-MH (WS-MH-TRN-INDX).    
           MOVE +107                   TO                               
                             WS-TRAN-COMMENT-LEN-MH(WS-MH-TRN-INDX).    
           MOVE WS-CWS00136-FORMATTED-COMMENT TO                        
                             WS-TRAN-COMMENT-TEXT-MH(WS-MH-TRN-INDX).   
                                                                        
           ADD +1                             TO WS-MH-TRN-INDX.        
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05442000
      * 5600-BUILD-ROW-A                                               *05443000
      * CREATES BILLED ROW ON CSS_CRED_COLL                            *06866000
      ******************************************************************05444000
                                                                        
       5600-BUILD-ROW-A.                                                
                                                                        
           MOVE 'A'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZERO                      TO WS-HOLD-ITEM-ID.           
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           MOVE WS-DATE-CURRENT-MAIL      TO WS-HOLD-DATE-NOTICE-MAIL   
           MOVE SPACES                    TO WS-HOLD-CODE-SPECIAL-TYPE. 
           MOVE WS-FORECAST-CR-GRP        TO WS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE WS-AVOID-LPC-DT           TO WS-HOLD-DATE-CREDIT-ACTION.
           MOVE WS-CURR-CHG-DUE-DT        TO WS-HOLD-DATE-NOTICE-DUE    
                                             1H-TOT-DUE-DT              
                                             WS-TOT-DUE-DT-1H.          
           MOVE WS-TEMP-CODE-MESSAGE-TYPE TO WS-TEMP-CODE-MESSAGE-CHAR  
           IF WS-TEMP-CODE-MESSAGE-CHAR (1:2) = '91'                    
              MOVE WS-TEMP-CODE-MESSAGE-TYPE                            
                                          TO WS-HOLD-CODE-MESSAGE-TYPE  
                                             WS-BILL-CRED-MSG-ID-1H     
                                             1H-BILL-CRED-MSG-ID        
           ELSE                                                         
              MOVE ZEROS                  TO WS-HOLD-CODE-MESSAGE-TYPE  
           END-IF.                                                      
           IF PRP-SPCL-NOTICE                                           
              MOVE 90115                  TO WS-HOLD-CODE-MESSAGE-TYPE  
                                             WS-BILL-CRED-NOT-ID-1H     
                                             1H-BILL-CRED-NOT-ID        
           END-IF.                                                      
                                                                        
           COMPUTE WS-HOLD-AMT-NOTICE       =                           
                   WS-TOTAL-UTILITY-CHARGES +                           
                   WS-TOTAL-NONUTIL-CHARGES.                            
           IF WS-HOLD-AMT-NOTICE <= 0                                   
              MOVE LOW-VALUES             TO WS-HOLD-DATE-NOTICE-DUE    
                                             1H-TOT-DUE-DT              
              MOVE SPACES                 TO WS-TOT-DUE-DT-1H           
           END-IF.                                                      
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL                THRU 5900-EXIT.
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06968000
      * 5610-BUILD-ROW-B.                                              *06967000
      * CREATES UTILITY 1ST NOTICE ROW ON CSS_CRED_COLL                *06964000
      ******************************************************************06972000
                                                                        
       5610-BUILD-ROW-B.                                                
                                                                        
           IF (WS-OFF-CYCLE-REBILL AND OUTSIDE-BILL-WINDOW)             
              GO TO 5610-EXIT                                           
           ELSE                                                         
              IF (WS-NOTICE-EXEMPT-CD-AT > SPACES AND NOT = 'B')        
                 MOVE 'E'                 TO WS-DISCONNECT-HIST-CZ(1:1) 
                 GO TO 5610-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE 'B'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZEROS                     TO WS-HOLD-ITEM-ID.           
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           MOVE SPACES                    TO WS-HOLD-CODE-SPECIAL-TYPE  
                                             WS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE WS-TEMP-CODE-MESSAGE-TYPE TO                            
                                     WS-HOLD-CODE-MESSAGE-TYPE          
                                     WS-FIRST-NOTICE-MESSAGE-TYPE       
                                     WS-BILL-CRED-NOT-ID-1H             
                                     1H-BILL-CRED-NOT-ID.               
           MOVE WS-DATE-CURRENT-MAIL      TO WS-HOLD-DATE-NOTICE-MAIL.  
           MOVE LOW-VALUES                TO WS-HOLD-DATE-CREDIT-ACTION.
           MOVE WS-ARREARS-DUE-DT         TO WS-HOLD-DATE-NOTICE-DUE    
                                             1H-UTL-NORM-DUE-DT         
                                             WS-UTL-NORM-DUE-DT-1H.     
           MOVE WS-AMT-FIRST-BAL          TO WS-HOLD-AMT-NOTICE.        
           PERFORM 5810-SET-DISCONN-HIST                 THRU 5810-EXIT.
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL                THRU 5900-EXIT.
                                                                        
       5610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07049000
      * 5620-BUILD-ROW-C.                                              *07053000
      * CREATES UTILITY 2ND NOTICE ROW ON CSS_CRED_COLL                *07050000
      ******************************************************************07058000
                                                                        
       5620-BUILD-ROW-C.                                                
                                                                        
           IF (WS-NOTICE-EXEMPT-CD-AT > SPACES AND NOT = 'B') OR        
              (WS-OFF-CYCLE-REBILL AND OUTSIDE-BILL-WINDOW)             
              GO TO 5620-EXIT                                           
           END-IF.                                                      
           IF (WS-IVR-EXEMPT-CD-AT > SPACES AND NOT = 'B')              
              MOVE LOW-VALUES TO WS-IVR-CALL-DT                         
           END-IF.                                                      
           IF (SEB-DATABASE AND WS-REGULATED-CD-AT = WS-REGULATED       
               AND WS-REG-GROUP-CD-AT = WS-LOW-INCOME AND               
               WS-SENIOR-FL-AT = 'Y')                                   
               PERFORM 5800-CHECK-ARREARS                THRU 5800-EXIT 
               IF NOT-ARREAR-EXISTS                                     
                  GO TO 5620-EXIT                                       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE 'C'                 TO WS-HOLD-CODE-NOTICE-TYPE.        
           MOVE WS-ACCOUNT-NO-AT    TO WS-HOLD-ACCOUNT-NO.              
           MOVE ZEROS               TO WS-HOLD-ITEM-ID                  
                                       WS-HOLD-CODE-MESSAGE-TYPE.       
           MOVE WS-KR100-BE00-DT    TO WS-HOLD-DATE-BILL.               
           MOVE SPACES              TO WS-HOLD-CODE-SPECIAL-TYPE        
                                       WS-HOLD-CODE-FRCST-CR-GRP.       
           PERFORM 2700-GET-DNP-TYPE                     THRU 2700-EXIT 
           MOVE WS-TEMP-CODE-SPECIAL-TYPE                               
                                    TO WS-HOLD-CODE-SPECIAL-TYPE        
           MOVE WS-DNP-NOTICE-MAIL-DT  TO WS-HOLD-DATE-NOTICE-MAIL.     
           MOVE WS-IVR-CALL-DT      TO WS-HOLD-DATE-CREDIT-ACTION.      
           MOVE WS-DNP-NOTICE-DUE-DT   TO WS-HOLD-DATE-NOTICE-DUE.      
           MOVE WS-AMT-SECOND-BAL   TO WS-HOLD-AMT-NOTICE.              
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL                THRU 5900-EXIT.
                                                                        
       5620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07153000
      * 5630-BUILD-ROW-D.                                              *07152000
      * CREATES DNP ROW ON CSS_CRED_COLL                               *07149000
      ******************************************************************07157000
                                                                        
       5630-BUILD-ROW-D.                                                
                                                                        
           IF (WS-NOTICE-EXEMPT-CD-AT > SPACES AND NOT = 'B') OR        
              (WS-OFF-CYCLE-REBILL AND OUTSIDE-BILL-WINDOW)             
              GO TO 5630-EXIT                                           
           END-IF.                                                      
                                                                        
           IF (SEB-DATABASE AND WS-REGULATED-CD-AT = WS-REGULATED AND   
              WS-REG-GROUP-CD-AT = WS-LOW-INCOME AND                    
              WS-SENIOR-FL-AT = 'Y')                                    
              PERFORM 5800-CHECK-ARREARS                 THRU 5800-EXIT 
              IF NOT-ARREAR-EXISTS                                      
                 GO TO 5630-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE 'D'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZEROS                     TO WS-HOLD-ITEM-ID            
                                             WS-HOLD-CODE-MESSAGE-TYPE. 
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           PERFORM 2700-GET-DNP-TYPE      THRU 2700-EXIT                
           MOVE WS-TEMP-CODE-SPECIAL-TYPE                               
                                          TO WS-HOLD-CODE-SPECIAL-TYPE  
           MOVE SPACE                     TO WS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE LOW-VALUES                TO WS-HOLD-DATE-NOTICE-MAIL   
                                             WS-HOLD-DATE-NOTICE-DUE.   
           MOVE WS-DNP-DT                 TO WS-HOLD-DATE-CREDIT-ACTION.
           MOVE WS-AMT-DNP-BAL            TO WS-HOLD-AMT-NOTICE.        
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL                THRU 5900-EXIT.
                                                                        
       5630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07861000
      * 5640-BUILD-ROW-K.                                              *07865000
      * CREATES NOTICE ROW (FOR NON-UTIL ACCOUNT) ON CSS_CRED_COLL     *07862000
      ******************************************************************07863000
                                                                        
       5640-BUILD-ROW-K.                                                
                                                                        
           MOVE ZEROES TO WS-HOLD-CODE-MESSAGE-TYPE                     
                          WS-HOLD-NU-ARREARS.                           
                                                                        
           EVALUATE TRUE                                                
               WHEN (WS-NON-UTL-ARRER-HIST-CZ (1:1) = '3' AND           
                    WS-KR100-TOTAL-90-DELINQ <= WS-AMT-NU-ACT-CBUR AND  
                    NOT-CREDIT-BUR-EXEMPT) OR                           
                    (WS-NON-UTL-ARRER-HIST-CZ (1:1) = '3' AND           
                    CREDIT-BUR-EXEMPT)                                  
                    MOVE 90405            TO WS-HOLD-CODE-MESSAGE-TYPE  
               WHEN (WS-NON-UTL-ARRER-HIST-CZ (1:1) = '3' AND           
                    WS-KR100-TOTAL-90-DELINQ > WS-AMT-NU-ACT-CBUR  AND  
                    NOT-CREDIT-BUR-EXEMPT)                              
                    MOVE 90404            TO WS-HOLD-CODE-MESSAGE-TYPE  
               WHEN (WS-NON-UTL-ARRER-HIST-CZ (1:1) = '2' AND           
                    WS-KR100-TOTAL-60-DELINQ <= WS-AMT-NU-ACT-CBUR AND  
                    NOT-CREDIT-BUR-EXEMPT) OR                           
                    (WS-NON-UTL-ARRER-HIST-CZ (1:1) = '2' AND           
                    CREDIT-BUR-EXEMPT)                                  
                    MOVE 90403            TO WS-HOLD-CODE-MESSAGE-TYPE  
               WHEN (WS-NON-UTL-ARRER-HIST-CZ (1:1) = '2' AND           
                    WS-KR100-TOTAL-60-DELINQ > WS-AMT-NU-ACT-CBUR  AND  
                    NOT-CREDIT-BUR-EXEMPT)                              
                    MOVE 90402            TO WS-HOLD-CODE-MESSAGE-TYPE  
               WHEN WS-NON-UTL-ARRER-HIST-CZ (1:1) = '1'                
                    MOVE 90401            TO WS-HOLD-CODE-MESSAGE-TYPE  
           END-EVALUATE.                                                
                                                                        
           MOVE 'K'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZERO                      TO WS-HOLD-ITEM-ID.           
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           MOVE SPACES                    TO WS-HOLD-CODE-SPECIAL-TYPE  
                                             WS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE WS-CURR-CHG-DUE-DT        TO 1H-NONUTL-NORM-DUE-DT      
                                             WS-NONUTL-NORM-DUE-DT-1H   
                                             WS-HOLD-DATE-NOTICE-DUE.   
                                                                        
           MOVE WS-DATE-CURRENT-MAIL      TO WS-HOLD-DATE-NOTICE-MAIL.  
           MOVE LOW-VALUES                TO WS-HOLD-DATE-CREDIT-ACTION.
           MOVE WS-TOTAL-ARREARS          TO WS-HOLD-AMT-NOTICE         
                                             WS-HOLD-NU-ARREARS.        
                                                                        
           IF WS-HOLD-CODE-MESSAGE-TYPE > ZEROES                        
              MOVE WS-HOLD-CODE-MESSAGE-TYPE TO WS-BILL-CRED-NOT-ID-1H  
                                                1H-BILL-CRED-NOT-ID     
              PERFORM 5500-BUILD-MSG-MAINTENANCE         THRU 5500-EXIT 
           END-IF.                                                      
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL                THRU 5900-EXIT.
                                                                        
       5640-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07942000
      * 5650-BUILD-ROW-L.                                              *07946000
      * CREATES CREDIT BUREAU ROW(FOR NON-UTIL ACC) ON CSS_CRED_COLL   *07943000
      ******************************************************************07944000
                                                                        
       5650-BUILD-ROW-L.                                                
                                                                        
           MOVE 'L'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZEROS                     TO WS-HOLD-CODE-MESSAGE-TYPE  
                                             WS-HOLD-ITEM-ID.           
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL          
                                             WS-HOLD-DATE-CREDIT-ACTION.
           MOVE SPACES                    TO WS-HOLD-CODE-SPECIAL-TYPE  
                                             WS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE LOW-VALUES                TO WS-HOLD-DATE-NOTICE-MAIL   
                                             WS-HOLD-DATE-NOTICE-DUE.   
           MOVE WS-TOT-NON-UTIL-CRED-BUR  TO WS-HOLD-AMT-NOTICE.        
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL                THRU 5900-EXIT.
                                                                        
       5650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06232000
      * 5660-BUILD-ROW-M.                                              *06237000
      * CREATES NON UTILITY 1ST NOTICE ROW ON CSS_CRED_COLL            *07106000
      ******************************************************************06236000
                                                                        
       5660-BUILD-ROW-M.                                                
                                                                        
           IF (WS-OFF-CYCLE-REBILL AND OUTSIDE-BILL-WINDOW)             
              GO TO 5660-EXIT                                           
           END-IF.                                                      
           IF (SEB-DATABASE AND WS-REGULATED-CD-AT = WS-REGULATED       
               AND WS-REG-GROUP-CD-AT = WS-LOW-INCOME AND               
               WS-SENIOR-FL-AT = 'Y')                                   
               PERFORM 5800-CHECK-ARREARS                THRU 5800-EXIT 
               IF NOT-ARREAR-EXISTS                                     
                  GO TO 5660-EXIT                                       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE 'M'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZEROS                     TO WS-HOLD-ITEM-ID            
                                             WS-HOLD-CODE-MESSAGE-TYPE. 
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           MOVE SPACE                     TO WS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE WS-NONUTIL-WQ-DT          TO WS-HOLD-DATE-CREDIT-ACTION.
                                                                        
           EVALUATE TRUE                                                
               WHEN MASTER-ARREARS-WQ                                   
                    MOVE 'C'              TO WS-HOLD-CODE-SPECIAL-TYPE  
                    MOVE WS-TOTAL-NONUTIL-ARREARS                       
                                          TO WS-HOLD-AMT-NOTICE         
               WHEN NON-UTIL-CRED-GRP                                   
                    MOVE 'E'              TO WS-HOLD-CODE-SPECIAL-TYPE  
                    MOVE WS-KR100-TOTAL-90-DELINQ                       
                                          TO WS-HOLD-AMT-NOTICE         
               WHEN OTHER                                               
                    MOVE 'N'              TO WS-HOLD-CODE-SPECIAL-TYPE  
                    IF DPP-ACCOUNT                                      
                       MOVE 'J'           TO WS-HOLD-CODE-SPECIAL-TYPE  
                    ELSE                                                
                       IF FIRST-BILL-AFT-DPP-DROP                       
                          MOVE 'U'        TO WS-HOLD-CODE-SPECIAL-TYPE  
                       END-IF                                           
                    END-IF                                              
                    MOVE WS-AMT-WQ-NU     TO WS-HOLD-AMT-NOTICE         
           END-EVALUATE.                                                
                                                                        
           MOVE LOW-VALUES                TO WS-HOLD-DATE-NOTICE-MAIL   
                                             WS-HOLD-DATE-NOTICE-DUE.   
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL               THRU 5900-EXIT. 
                                                                        
       5660-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06914000
      * 5670-BUILD-ROW-P                                               *06920000
      * CREATES UTILITY BILLED ROW ON CSS_CRED_COLL.                   *06915000
      ******************************************************************06918000
                                                                        
       5670-BUILD-ROW-P.                                                
                                                                        
           MOVE 'P'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZERO                      TO WS-HOLD-ITEM-ID.           
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           MOVE SPACES                    TO WS-HOLD-CODE-SPECIAL-TYPE  
                                             WS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE LOW-VALUES                TO WS-HOLD-DATE-CREDIT-ACTION.
           MOVE WS-DATE-CURRENT-MAIL      TO WS-HOLD-DATE-NOTICE-MAIL   
           MOVE WS-CURR-CHG-DUE-DT        TO WS-HOLD-DATE-NOTICE-DUE    
           MOVE WS-AMT-CURRENT-BAL        TO WS-HOLD-AMT-NOTICE         
                                             1H-UTL-TOT-DUE-AM          
                                             WS-UTL-TOT-DUE-AM-1H.      
           MOVE WS-TEMP-CODE-MESSAGE-TYPE TO WS-TEMP-CODE-MESSAGE-CHAR. 
           IF WS-TEMP-CODE-MESSAGE-CHAR (1:2) = '91'                    
              MOVE WS-TEMP-CODE-MESSAGE-TYPE                            
                                          TO WS-HOLD-CODE-MESSAGE-TYPE  
                                             WS-BILL-CRED-MSG-ID-1H     
                                             1H-BILL-CRED-MSG-ID        
                                                                        
           ELSE                                                         
              MOVE ZEROS                  TO WS-HOLD-CODE-MESSAGE-TYPE  
           END-IF.                                                      
           IF PRP-SPCL-NOTICE                                           
              MOVE 90115                  TO WS-HOLD-CODE-MESSAGE-TYPE  
                                             WS-BILL-CRED-NOT-ID-1H     
                                             1H-BILL-CRED-NOT-ID        
           END-IF.                                                      
                                                                        
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL                THRU 5900-EXIT.
                                                                        
       5670-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07012000
      * 5680-BUILD-ROW-Q                                               *07016000
      * CREATES NON UTIL BILLED ROW ON CSS_CRED_COLL                   *07013000
      ******************************************************************07014000
                                                                        
       5680-BUILD-ROW-Q.                                                
                                                                        
           MOVE 'Q'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZERO                      TO WS-HOLD-ITEM-ID.           
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           MOVE LOW-VALUES                TO WS-HOLD-DATE-CREDIT-ACTION.
           MOVE WS-TOTAL-NONUTIL-CHARGES  TO WS-HOLD-AMT-NOTICE         
                                             1H-NONUTL-TOT-DUE-AM       
                                             WS-NONUTL-TOT-DUE-AM-1H.   
           MOVE SPACES                    TO WS-HOLD-CODE-SPECIAL-TYPE  
                                             WS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE WS-TEMP-CODE-MESSAGE-TYPE TO WS-TEMP-CODE-MESSAGE-CHAR. 
           IF WS-TEMP-CODE-MESSAGE-CHAR (1:2) = '91'                    
              MOVE WS-TEMP-CODE-MESSAGE-TYPE                            
                                          TO WS-HOLD-CODE-MESSAGE-TYPE  
                                             WS-BILL-CRED-MSG-ID-1H     
                                             1H-BILL-CRED-MSG-ID        
           ELSE                                                         
              MOVE ZEROS                  TO WS-HOLD-CODE-MESSAGE-TYPE  
           END-IF.                                                      
           IF PRP-SPCL-NOTICE                                           
              MOVE 90115                  TO WS-HOLD-CODE-MESSAGE-TYPE  
                                             WS-BILL-CRED-NOT-ID-1H     
                                             1H-BILL-CRED-NOT-ID        
           END-IF.                                                      
                                                                        
           IF WS-HOLD-AMT-NOTICE <= 0                                   
              MOVE LOW-VALUES             TO WS-HOLD-DATE-NOTICE-MAIL   
                                             WS-HOLD-DATE-NOTICE-DUE    
           ELSE                                                         
              MOVE WS-DATE-CURRENT-MAIL   TO WS-HOLD-DATE-NOTICE-MAIL   
              MOVE WS-CURR-CHG-DUE-DT     TO WS-HOLD-DATE-NOTICE-DUE    
           END-IF.                                                      
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL                THRU 5900-EXIT.
                                                                        
       5680-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07110000
      * 5690-BUILD-ROW-R.                                              *07109000
      * CREATES NON UTILITY 1ST NOTICE ROW ON CSS_CRED_COLL            *07106000
      ******************************************************************07114000
                                                                        
       5690-BUILD-ROW-R.                                                
                                                                        
           IF (WS-OFF-CYCLE-REBILL AND OUTSIDE-BILL-WINDOW)             
              GO TO 5690-EXIT                                           
           ELSE                                                         
              IF (WS-NOTICE-EXEMPT-CD-AT > SPACES AND NOT = 'B')        
                 MOVE 'E'                 TO WS-NON-UTL-CR-HST-CZ(1:1)  
                 GO TO 5690-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
           MOVE 'R'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZERO                      TO WS-HOLD-ITEM-ID.           
           MOVE ZEROES                    TO WS-HOLD-NU-ARREARS.        
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           MOVE SPACES                    TO WS-HOLD-CODE-SPECIAL-TYPE  
                                             WS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE WS-TEMP-CODE-MESSAGE-TYPE TO                            
                                    WS-HOLD-CODE-MESSAGE-TYPE           
                                    WS-FIRST-NOTICE-MESSAGE-TYPE        
                                    WS-BILL-CRED-NOT-ID-1H              
                                    1H-BILL-CRED-NOT-ID.                
           MOVE WS-DATE-CURRENT-MAIL      TO WS-HOLD-DATE-NOTICE-MAIL.  
           MOVE LOW-VALUES                TO WS-HOLD-DATE-CREDIT-ACTION.
           MOVE WS-ARREARS-DUE-DT         TO WS-HOLD-DATE-NOTICE-DUE    
                                             1H-NONUTL-NORM-DUE-DT      
                                             WS-NONUTL-NORM-DUE-DT-1H.  
           MOVE WS-AMT-FIRST-BAL-NU       TO WS-HOLD-AMT-NOTICE         
                                             WS-HOLD-NU-ARREARS.        
                                                                        
           PERFORM 5820-SET-NON-UTIL-CR-HST              THRU 5820-EXIT.
           PERFORM 5900-LOAD-WS-CRED-COLL                THRU 5900-EXIT.
                                                                        
       5690-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07197000
      * 5700-BUILD-ROW-S.                                              *07203000
      * CREATES NON UTILITY 2ND NOTICE ROW ON CSS_CRED_COLL.           *07198000
      ******************************************************************07202000
                                                                        
       5700-BUILD-ROW-S.                                                
                                                                        
           IF (WS-NOTICE-EXEMPT-CD-AT > SPACES AND NOT = 'B') OR        
              (WS-OFF-CYCLE-REBILL AND OUTSIDE-BILL-WINDOW)             
              GO TO 5700-EXIT                                           
           END-IF.                                                      
                                                                        
           IF (WS-IVR-EXEMPT-CD-AT > SPACES AND NOT = 'B')              
              MOVE LOW-VALUES TO WS-IVR-CALL-DT                         
           END-IF.                                                      
           IF (SEB-DATABASE AND WS-REGULATED-CD-AT = WS-REGULATED AND   
              WS-REG-GROUP-CD-AT = WS-LOW-INCOME AND                    
              WS-SENIOR-FL-AT = 'Y')                                    
              PERFORM 5800-CHECK-ARREARS THRU 5800-EXIT                 
              IF NOT-ARREAR-EXISTS                                      
                 GO TO 5700-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE 'S'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZEROS                     TO WS-HOLD-ITEM-ID            
                                             WS-HOLD-CODE-MESSAGE-TYPE. 
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           MOVE SPACE                     TO WS-HOLD-CODE-SPECIAL-TYPE  
                                             WS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE WS-DNP-NOTICE-MAIL-DT     TO WS-HOLD-DATE-NOTICE-MAIL.  
           MOVE WS-IVR-CALL-DT            TO WS-HOLD-DATE-CREDIT-ACTION.
           MOVE WS-DNP-NOTICE-DUE-DT      TO WS-HOLD-DATE-NOTICE-DUE.   
           MOVE WS-AMT-SECOND-BAL-NU      TO WS-HOLD-AMT-NOTICE.        
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL THRU 5900-EXIT.               
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07750000
      * 5710-BUILD-ROW-A-NONUTIL.                                      *07754000
      * CREATES BILLED ROW (FOR NON-UTIL ACCOUNT) ON CSS_CRED_COLL     *07751000
      ******************************************************************07752000
                                                                        
       5710-BUILD-ROW-A-NONUTIL.                                        
                                                                        
           MOVE 'A'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZEROS                     TO WS-HOLD-ITEM-ID            
                                             WS-HOLD-CODE-MESSAGE-TYPE. 
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           MOVE WS-DATE-CURRENT-MAIL      TO WS-HOLD-DATE-NOTICE-MAIL.  
           MOVE SPACES                    TO WS-HOLD-CODE-SPECIAL-TYPE  
                                             WS-HOLD-CODE-FRCST-CR-GRP. 
                                                                        
           COMPUTE WS-HOLD-AMT-NOTICE = WS-TOTAL-UTILITY-CHARGES +      
                   WS-TOTAL-NONUTIL-CHARGES.                            
           MOVE WS-CURR-CHG-DUE-DT        TO WS-HOLD-DATE-NOTICE-DUE    
                                             1H-TOT-DUE-DT              
                                             WS-TOT-DUE-DT-1H.          
           MOVE WS-AVOID-LPC-DT           TO WS-HOLD-DATE-CREDIT-ACTION.
           IF WS-TOTAL-NONUTIL-ARREARS > WS-AMT-NU-NOTICE-MIN           
              MOVE LOW-VALUES             TO WS-HOLD-DATE-CREDIT-ACTION 
           END-IF.                                                      
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL                THRU 5900-EXIT.
                                                                        
       5710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08100000
      * 5720-BUILD-ROW-B-NON-UTIL.                                     *08104000
      * CREATES UTIL NOTICE ROW FOR NON UTIL ACCOUNT                   *08101000
      ******************************************************************08102000
                                                                        
       5720-BUILD-ROW-B-NON-UTIL.                                       
                                                                        
           MOVE 'B'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZERO                      TO WS-HOLD-ITEM-ID.           
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           MOVE SPACES                    TO WS-HOLD-CODE-SPECIAL-TYPE  
                                             WS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE WS-DATE-CURRENT-MAIL      TO WS-HOLD-DATE-NOTICE-MAIL.  
                                                                        
           MOVE WS-PAST-UTIL-CHARGES-CALC TO WS-HOLD-AMT-NOTICE.        
           MOVE WS-HOLD-CODE-MESSAGE-TYPE TO                            
                                     WS-FIRST-NOTICE-MESSAGE-TYPE       
                                     WS-BILL-CRED-NOT-ID-1H             
                                     1H-BILL-CRED-NOT-ID.               
           MOVE WS-CURR-CHG-DUE-DT        TO WS-HOLD-DATE-NOTICE-DUE.   
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL                THRU 5900-EXIT.
                                                                        
       5720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07919000
      * 5730-BUILD-ROW-Q-NONUTIL.                                      *07923000
      * CREATES NON UTIL BILLED ROW (FOR NON UTIL ACC) ON CSS_CRED_COLL*07920000
      ******************************************************************07921000
                                                                        
       5730-BUILD-ROW-Q-NONUTIL.                                        
                                                                        
           MOVE 'Q'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZEROs                     TO WS-HOLD-ITEM-ID            
                                             WS-HOLD-CODE-MESSAGE-TYPE  
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           MOVE SPACES                    TO WS-HOLD-CODE-SPECIAL-TYPE  
                                             WS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE WS-DATE-CURRENT-MAIL      TO WS-HOLD-DATE-NOTICE-MAIL.  
           MOVE WS-CURR-CHG-DUE-DT        TO WS-HOLD-DATE-NOTICE-DUE.   
           MOVE WS-TOTAL-NONUTIL-CHARGES  TO WS-HOLD-AMT-NOTICE.        
           MOVE LOW-VALUES                TO WS-HOLD-DATE-CREDIT-ACTION.
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL                THRU 5900-EXIT.
                                                                        
       5730-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07838000
      * 5740-BUILD-ROW-P-NONUTIL.                                      *07842000
      * CREATES UTIL BILLED ROW (FOR NON-UTIL ACC) ON CSS_CRED_COLL    *07839000
      ******************************************************************07840000
                                                                        
       5740-BUILD-ROW-P-NONUTIL.                                        
                                                                        
           MOVE 'P'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZEROS                     TO WS-HOLD-ITEM-ID            
                                             WS-HOLD-CODE-MESSAGE-TYPE. 
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           MOVE SPACES                    TO WS-HOLD-CODE-SPECIAL-TYPE  
                                             WS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE WS-TOTAL-UTILITY-CHARGES  TO WS-HOLD-AMT-NOTICE.        
           MOVE LOW-VALUES TO WS-HOLD-DATE-CREDIT-ACTION.               
                                                                        
           PERFORM 5900-LOAD-WS-CRED-COLL THRU 5900-EXIT.               
                                                                        
       5740-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08123000
      * 5750-BUILD-ROW-R-NON-UTIL.                                     *08127000
      * CREATES NON UTIL NOTICE ROW FOR NON UTIL ACCOUNT               *08124000
      ******************************************************************08125000
                                                                        
       5750-BUILD-ROW-R-NON-UTIL.                                       
                                                                        
           MOVE 'R'                       TO WS-HOLD-CODE-NOTICE-TYPE.  
           MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
           MOVE ZERO                      TO WS-HOLD-ITEM-ID.           
           MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
           MOVE SPACES                    TO WS-HOLD-CODE-SPECIAL-TYPE  
                                             wS-HOLD-CODE-FRCST-CR-GRP. 
           MOVE WS-TOTAL-NONUTIL-ARREARS  TO WS-HOLD-AMT-NOTICE.        
           MOVE WS-HOLD-CODE-MESSAGE-TYPE TO                            
                                     WS-FIRST-NOTICE-MESSAGE-TYPE       
                                     WS-BILL-CRED-NOT-ID-1H             
                                     1H-BILL-CRED-NOT-ID.               
           MOVE WS-CURR-CHG-DUE-DT        TO WS-HOLD-DATE-NOTICE-DUE.   
           MOVE WS-DATE-CURRENT-MAIL      TO WS-HOLD-DATE-NOTICE-MAIL   
           MOVE LOW-VALUE                 TO WS-HOLD-DATE-CREDIT-ACTION.
           PERFORM 5900-LOAD-WS-CRED-COLL THRU 5900-EXIT.               
                                                                        
       5750-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00726******************************************************************08123000
P00726* 5760-BUILD-EXCPTNL-ROWS                                        *08127000
P00726******************************************************************08125000
P00726                                                                  
P00726 5760-BUILD-EXCPTNL-ROWS.                                         
P00726                                                                  
P00726     MOVE WS-ACCOUNT-NO-AT          TO WS-HOLD-ACCOUNT-NO.        
P00726     MOVE ZEROs                     TO WS-HOLD-ITEM-ID            
P00726     MOVE SPACES                    TO WS-HOLD-CODE-FRCST-CR-GRP. 
P00726     MOVE WS-KR100-BE00-DT          TO WS-HOLD-DATE-BILL.         
P00726     MOVE 'Q'                       TO WS-HOLD-CODE-SPECIAL-TYPE. 
P00726     MOVE WS-TEMP-CODE-MESSAGE-TYPE TO WS-HOLD-CODE-MESSAGE-TYPE. 
P00726                                                                  
P00726     PERFORM 5900-LOAD-WS-CRED-COLL                THRU 5900-EXIT.
P00726                                                                  
P00726 5760-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
      ******************************************************************07435000
      * 5800-CHECK-ARREARS.                                            *07693000
      ******************************************************************07440000
                                                                        
       5800-CHECK-ARREARS.                                              
                                                                        
           MOVE 'Y'                       TO WS-ARR-EXITS-ROW-SW.       
           IF WS-KR100-UTL-60-DELINQ  > 0 OR                            
              WS-KR100-UTL-90-DELINQ  > 0                               
              CONTINUE                                                  
           ELSE                                                         
               MOVE 'N'                   TO WS-ARR-EXITS-ROW-SW        
           END-IF.                                                      
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07435000
      * 5810-SET-DISCONN-HIST.                                         *07360000
      ******************************************************************07440000
                                                                        
       5810-SET-DISCONN-HIST.                                           
                                                                        
           IF WS-CREDIT-GROUP-AT = 'C'                                  
              MOVE 'N'                    TO WS-DISCONNECT-HIST-CZ (1:1)
           ELSE                                                         
              IF WS-CREDIT-GROUP-AT = 'B' OR 'T'                        
                 MOVE '1'    TO WS-DISCONNECT-HIST-CZ (1:1)             
              ELSE                                                      
                 IF WS-AMT-FIRST-BAL <= WS-FIRST-NOTICE-LIMIT           
                    MOVE 'N'              TO WS-DISCONNECT-HIST-CZ (1:1)
                 ELSE                                                   
                    MOVE '1'              TO WS-DISCONNECT-HIST-CZ (1:1)
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07435000
      * 5820-SET-NON-UTIL-CR-HST.                                      *07360000
      ******************************************************************07440000
                                                                        
       5820-SET-NON-UTIL-CR-HST.                                        
                                                                        
           IF WS-CREDIT-GROUP-AT = 'C'                                  
              MOVE 'N'                    TO WS-NON-UTL-CR-HST-CZ (1:1) 
           ELSE                                                         
              IF WS-CREDIT-GROUP-AT = 'B'                               
                 MOVE '1' TO WS-NON-UTL-CR-HST-CZ (1:1)                 
              ELSE                                                      
                 IF WS-AMT-FIRST-BAL <= WS-FIRST-NOTICE-LIMIT           
                    MOVE 'N'              TO WS-NON-UTL-CR-HST-CZ (1:1) 
                 ELSE                                                   
                    MOVE '1'              TO WS-NON-UTL-CR-HST-CZ (1:1) 
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05442000
      * 5900-LOAD-WS-CRED-COLL                                         *05443000
      ******************************************************************05444000
                                                                        
       5900-LOAD-WS-CRED-COLL.                                          
                                                                        
           SET WS-CL-INDEX   TO 1.                                      
           SEARCH WS-CRED-COLL-TB                                       
               AT END                                                   
                  MOVE 'AT END OF WS-CRED COLL TABLE' TO                
                        WS-MISC-MSG-TEXT                                
                  MOVE +29  TO WS-MISC-MSG-LEN                          
                  MOVE +137 TO WS-MISC-CATEGORY-ID                      
                  MOVE 12   TO RS-RETURN-CODE                           
                  PERFORM 9920-MISC-ERROR               THRU 9920-EXIT  
             WHEN (WS-CODE-NOTICE-TYPE-TB (WS-CL-INDEX) =               
                  WS-HOLD-CODE-NOTICE-TYPE AND                          
                  WS-ITEM-ID-TB(WS-CL-INDEX) = WS-HOLD-ITEM-ID)         
                  MOVE WS-ACCOUNT-NO-TB(WS-CL-INDEX) TO CL-ACCOUNT-NO   
                                                        1H-ACCOUNT-NO   
                  MOVE WS-ITEM-ID-TB(WS-CL-INDEX)    TO CL-ITEM-ID      
                  MOVE WS-CODE-NOTICE-TYPE-TB(WS-CL-INDEX)              
                                                 TO CL-CODE-NOTICE-TYPE 
                  MOVE WS-LAST-UPDATE-TS-TB (WS-CL-INDEX)               
                                                 TO CL-LAST-UPDATE-TS   
                  PERFORM 5910-LOAD-COMMON-WS-CRED-COLL THRU 5910-EXIT  
             WHEN WS-CODE-NOTICE-TYPE-TB (WS-CL-INDEX) = SPACES         
                  MOVE WS-HOLD-ACCOUNT-NO        TO CL-ACCOUNT-NO       
                                                    1H-ACCOUNT-NO       
                  MOVE WS-HOLD-ITEM-ID           TO CL-ITEM-ID          
                  MOVE WS-HOLD-CODE-NOTICE-TYPE  TO CL-CODE-NOTICE-TYPE 
                  PERFORM 5910-LOAD-COMMON-WS-CRED-COLL THRU 5910-EXIT  
           END-SEARCH.                                                  
                                                                        
       5900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05442000
      * 5910-LOAD-COMMON-WS-CRED-COLL                                  *05443000
      ******************************************************************05444000
                                                                        
       5910-LOAD-COMMON-WS-CRED-COLL.                                   
                                                                        
           MOVE WS-HOLD-CODE-SPECIAL-TYPE TO CL-CODE-SPECIAL-TYPE.      
           MOVE WS-HOLD-CODE-FRCST-CR-GRP TO CL-CODE-FRCST-CR-GRP.      
           MOVE WS-HOLD-CODE-MESSAGE-TYPE TO CL-CODE-MESSAGE-TYPE.      
           MOVE WS-HOLD-DATE-BILL         TO CL-DATE-BILL.              
           IF (WS-OFF-CYCLE-REBILL AND OUTSIDE-BILL-WINDOW AND          
              (WS-HOLD-CODE-NOTICE-TYPE NOT = 'A' AND                   
               WS-HOLD-CODE-NOTICE-TYPE NOT = 'P' AND                   
               WS-HOLD-CODE-NOTICE-TYPE NOT = 'Q'))                     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-HOLD-DATE-NOTICE-MAIL   TO CL-DATE-NOTICE-MAIL    
              MOVE WS-HOLD-DATE-CREDIT-ACTION TO CL-DATE-CREDIT-ACTION  
              MOVE WS-HOLD-AMT-NOTICE         TO CL-AMT-NOTICE          
              MOVE WS-HOLD-DATE-NOTICE-DUE    TO CL-DATE-NOTICE-DUE     
           END-IF.                                                      
                                                                        
           IF WS-UPDATE-ACTION-IND-TB = 'U' OR                          
              WS-LAST-UPDATE-TS-TB (WS-CL-INDEX) > SPACES               
              PERFORM 8300-UPDATE-CRED-COLL           THRU 8300-EXIT    
           ELSE                                                         
              PERFORM 8100-INSERT-CRED-COLL           THRU 8100-EXIT    
           END-IF.                                                      
           MOVE 'Y'           TO WS-PROCESSED-FLAG(WS-CL-INDEX).        
                                                                        
       5910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07582000
      * 5920-LOAD-WS-CREDCOLL-MEDCERT.                                 *07587000
      * IF NON UTIL ARREARS NOW EXIST, INSERT EXCEPTIONAL NON UTIL     *07583000
      * ROWS. ONLY ROW T FOR SEB AND PSNC AND ROWS T, U AND X FOR SCEG.*07584000
      ******************************************************************07586000
                                                                        
       5920-LOAD-WS-CREDCOLL-MEDCERT.                                   
                                                                        
           SET WS-CL-INDEX TO 1.                                        
           SEARCH WS-CRED-COLL-TB                                       
               AT END                                                   
                  MOVE 'AT END OF WS-CRED COLL TABLE' TO                
                       WS-MISC-MSG-TEXT                                 
                  MOVE +29  TO WS-MISC-MSG-LEN                          
                  MOVE +137 TO WS-MISC-CATEGORY-ID                      
                  MOVE 12   TO RS-RETURN-CODE                           
                  PERFORM 9920-MISC-ERROR                THRU 9920-EXIT 
             WHEN (WS-CODE-NOTICE-TYPE-TB (WS-CL-INDEX) =               
                  WS-HOLD-CODE-NOTICE-TYPE AND                          
                  WS-ITEM-ID-TB (WS-CL-INDEX) = WS-HOLD-ITEM-ID)        
                  PERFORM 5930-LOAD-CRED-COLL-MEDCERT    THRU 5930-EXIT 
             WHEN ((WS-CODE-NOTICE-TYPE-TB (WS-CL-INDEX) = SPACES) AND  
                  (WS-HOLD-CODE-NOTICE-TYPE = 'T' OR 'U' OR 'X')   AND  
                  (WS-HOLD-AMT-NOTICE > 0))                             
                  MOVE WS-HOLD-CODE-NOTICE-TYPE TO CL-CODE-NOTICE-TYPE  
                  MOVE WS-KR100-BE00-DT         TO CL-DATE-BILL         
                  EVALUATE WS-HOLD-CODE-NOTICE-TYPE                     
                      WHEN 'T'                                          
                           MOVE WS-HOLD-MED-CERT-DUE-E     TO           
                                CL-DATE-NOTICE-DUE                      
                           MOVE LOW-VALUES TO CL-DATE-CREDIT-ACTION     
                           MOVE WS-HOLD-CODE-MED-SPEC-TYPE TO           
                                CL-CODE-SPECIAL-TYPE                    
                      WHEN 'U'                                          
                           MOVE WS-HOLD-MED-CERT-MAIL-F    TO           
                                CL-DATE-NOTICE-MAIL                     
                           MOVE WS-HOLD-MED-CERT-DUE-F     TO           
                                CL-DATE-NOTICE-DUE                      
                           MOVE WS-HOLD-MED-CERT-ACTION-F  TO           
                                CL-DATE-CREDIT-ACTION                   
                           MOVE WS-HOLD-CODE-MED-SPEC-TYPE TO           
                                CL-CODE-SPECIAL-TYPE                    
                      WHEN 'X'                                          
                           MOVE LOW-VALUES TO CL-DATE-NOTICE-DUE        
                           MOVE WS-HOLD-MED-CERT-ACTION-G  TO           
                                CL-DATE-CREDIT-ACTION                   
                           MOVE WS-HOLD-CODE-MED-SPEC-TYPE TO           
                                CL-CODE-SPECIAL-TYPE                    
                  END-EVALUATE                                          
                  MOVE WS-HOLD-ACCOUNT-NO TO CL-ACCOUNT-NO              
                  MOVE WS-HOLD-ITEM-ID    TO CL-ITEM-ID                 
                  PERFORM 5930-LOAD-CRED-COLL-MEDCERT     THRU 5930-EXIT
             WHEN WS-CODE-NOTICE-TYPE-TB (WS-CL-INDEX) = SPACES         
                  CONTINUE                                              
           END-SEARCH.                                                  
                                                                        
       5920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07644000
      * 5930-LOAD-CRED-COLL-MEDCERT                                    *07647000
      ******************************************************************07646000
                                                                        
       5930-LOAD-CRED-COLL-MEDCERT.                                     
                                                                        
           IF NOT WS-OFF-CYCLE-REBILL                                   
              MOVE WS-LAST-UPDATE-TS-TB (WS-CL-INDEX)                   
                                               TO CL-LAST-UPDATE-TS     
              MOVE WS-CODE-SPECIAL-TYPE-TB(WS-CL-INDEX)  TO             
                   CL-CODE-SPECIAL-TYPE                                 
              MOVE WS-DATE-BILL-TB(WS-CL-INDEX) TO CL-DATE-BILL         
              MOVE WS-CODE-FRCST-CR-GRP-TB(WS-CL-INDEX)  TO             
                   CL-CODE-FRCST-CR-GRP                                 
              MOVE WS-DATE-CREDIT-ACTION-TB(WS-CL-INDEX) TO             
                   CL-DATE-CREDIT-ACTION                                
              MOVE WS-DATE-NOTICE-MAIL-TB(WS-CL-INDEX)   TO             
                   CL-DATE-NOTICE-MAIL                                  
              MOVE WS-DATE-NOTICE-DUE-TB(WS-CL-INDEX)    TO             
                   CL-DATE-NOTICE-DUE                                   
              MOVE WS-CODE-MESSAGE-TYPE-TB(WS-CL-INDEX)  TO             
                                                  CL-CODE-MESSAGE-TYPE  
              MOVE WS-HOLD-AMT-NOTICE          TO CL-AMT-NOTICE         
              MOVE WS-HOLD-CODE-NOTICE-TYPE    TO CL-CODE-NOTICE-TYPE   
      *                                                                         
              IF WS-CODE-NOTICE-TYPE-TB (WS-CL-INDEX) = 'E'             
                 MOVE CL-DATE-NOTICE-DUE       TO 1H-UTL-EXCP-DUE-DT    
                                                  WS-UTL-EXCP-DUE-DT-1H 
                 IF 1H-UTL-EXCP-DUE-DT > SPACES                         
                    MOVE CL-AMT-NOTICE         TO 1H-UTL-EXCP-NOT-AM    
                                                  WS-UTL-EXCP-NOT-AM-1H 
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              EVALUATE TRUE                                             
                  WHEN WS-CODE-NOTICE-TYPE-TB (WS-CL-INDEX) = 'E'       
                  WHEN WS-CODE-NOTICE-TYPE-TB (WS-CL-INDEX) = 'T'       
                       MOVE CL-DATE-NOTICE-DUE TO WS-HOLD-MED-CERT-DUE-E
                       MOVE CL-CODE-SPECIAL-TYPE       TO               
                            WS-HOLD-CODE-MED-SPEC-TYPE                  
                       MOVE WS-HOLD-DATE-NOTICE-MAIL   TO               
                            CL-DATE-NOTICE-MAIL                         
                       MOVE WS-HOLD-CODE-MESSAGE-TYPE  TO               
                            CL-CODE-MESSAGE-TYPE                        
                  WHEN WS-CODE-NOTICE-TYPE-TB (WS-CL-INDEX) = 'F'       
                       MOVE CL-DATE-NOTICE-MAIL        TO               
                            WS-HOLD-MED-CERT-MAIL-F                     
                       MOVE CL-DATE-NOTICE-DUE         TO               
                            WS-HOLD-MED-CERT-DUE-F                      
                       MOVE CL-DATE-CREDIT-ACTION      TO               
                            WS-HOLD-MED-CERT-ACTION-F                   
                       MOVE CL-CODE-SPECIAL-TYPE       TO               
                            WS-HOLD-CODE-MED-SPEC-TYPE                  
                  WHEN WS-CODE-NOTICE-TYPE-TB (WS-CL-INDEX) = 'G'       
                       MOVE CL-DATE-CREDIT-ACTION      TO               
                            WS-HOLD-MED-CERT-ACTION-G                   
                       MOVE CL-CODE-SPECIAL-TYPE       TO               
                            WS-HOLD-CODE-MED-SPEC-TYPE                  
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
           IF WS-UPDATE-ACTION-IND-TB = 'U' OR                          
              WS-LAST-UPDATE-TS-TB (WS-CL-INDEX) > SPACES               
              PERFORM 8300-UPDATE-CRED-COLL              THRU 8300-EXIT 
           ELSE                                                         
              PERFORM 8100-INSERT-CRED-COLL              THRU 8100-EXIT 
           END-IF.                                                      
           MOVE 'Y'           TO WS-PROCESSED-FLAG(WS-CL-INDEX).        
                                                                        
       5930-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5940-LOAD-BILL-CRED-DET                                        *        
      ******************************************************************        
                                                                        
       5940-LOAD-BILL-CRED-DET.                                         
                                                                        
           PERFORM 7000-GET-TIMESTAMP                    THRU 7000-EXIT.
                                                                        
           MOVE WS-ACCOUNT-NO-AT          TO 1H-ACCOUNT-NO              
                                             WS-ACCOUNT-NO-1H.          
           MOVE WS-COMPANY-NO-AT          TO 1H-COMPANY-NO              
                                             WS-COMPANY-NO-1H.          
           MOVE WS-KR100-BILL-NO          TO 1H-BILL-NO                 
                                             WS-BILL-NO-1H.             
           MOVE WS-REG-GROUP-CD-AT        TO 1H-REG-GROUP-CD            
                                             WS-REG-GROUP-CD-1H.        
           MOVE WS-CURRENT-TIMESTAMP      TO 1H-CREATED-TS              
                                             WS-CREATED-TS-1H.          
           MOVE WS-PAST-UTIL-CHARGES-CALC TO 1H-UTL-ARREARS-AM          
                                             WS-UTL-ARREARS-AM-1H.      
           MOVE WS-CURR-UTIL-CHARGES-CALC TO 1H-UTL-CURR-AM             
                                             WS-UTL-CURR-AM-1H.         
           MOVE WS-PASTDUE-CHARGES-CALC   TO 1H-TOT-ARREARS-AM          
                                             WS-TOT-ARREARS-AM-1H.      
           MOVE WS-CURRENT-CHARGES-CALC   TO 1H-TOT-CURR-AM             
                                             WS-TOT-CURR-AM-1H.         
           MOVE WS-CURR-NONUTIL-CHARGES-CALC                            
                                          TO 1H-NONUTL-CURR-AM          
                                             WS-NONUTL-CURR-AM-1H.      
           MOVE WS-PAST-NONUTIL-CHARGES-CALC                            
                                          TO 1H-NONUTL-ARREARS-AM       
                                             WS-NONUTL-ARREARS-AM-1H.   
           MOVE 0                         TO 1H-NONUTL-EXCP-NOT-AM      
                                             WS-NONUTL-EXCP-NOT-AM-1H.  
           MOVE SPACES                    TO 1H-NONUTL-EXCP-DUE-DT      
                                             WS-NONUTL-EXCP-DUE-DT-1H.  
           MOVE WS-LPC-AMT-1H             TO 1H-LPC-AM.                 
           MOVE WS-LPN-AMT-1H             TO 1H-LPN-AM                  
           MOVE WS-AUTO-CARD-PYMT-DT      TO 1H-AUTO-PAYMENT-DT         
                                             WS-AUTO-PAYMENT-DT-1H.     
           MOVE WS-AVOID-LPC-DT           TO 1H-AVOID-LPC-DT            
                                             WS-AVOID-LPC-DT-1H.        
                                                                        
           IF 1H-UTL-NORM-DUE-DT > SPACES                               
              MOVE WS-AMT-FIRST-BAL       TO 1H-UTL-NORM-NOT-AM         
                                             WS-UTL-NORM-NOT-AM-1H      
           END-IF.                                                      
                                                                        
           IF 1H-NONUTL-NORM-DUE-DT > SPACES                            
              MOVE WS-HOLD-NU-ARREARS     TO 1H-NONUTL-NORM-NOT-AM      
                                             WS-NONUTL-NORM-NOT-AM-1H   
           END-IF.                                                      
                                                                        
           IF 1H-TOT-DUE-DT > SPACES                                    
              MOVE WS-TOTAL-DUE-AMT       TO 1H-TOT-DUE-AM              
                                             WS-TOT-DUE-AM-1H           
           END-IF.                                                      
                                                                        
           IF WS-BILL-CRED-NOT-ID-1H = '00000'                          
              MOVE SPACES                 TO WS-BILL-CRED-NOT-ID-1H     
                                             1H-BILL-CRED-NOT-ID        
           END-IF.                                                      
                                                                        
       5940-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04850000
      * 7000-GET-TIMESTAMP.                                            *        
      * GET TIMESTAMP FOR MNT_TRANS_HIST FILE                          *04880000
      ******************************************************************04900000
                                                                        
       7000-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*           ,:WS-CURRENT-DATE      = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'SET'                TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '7000'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00726******************************************************************15170000
P00726* 7010-SELECT-ACTIVE-ARNG-TYPE                                   *15180000
P00726******************************************************************15190000
P00726                                                                  
P00726 7010-SELECT-ACTIVE-ARNG-TYPE.                                    
P00726                                                                  
P00726     EXEC SQL                                                     
P00726        SELECT ARNG_TYPE                                          
P00726          INTO :X1-ARNG-TYPE                                      
P00726          FROM CSS_CRED_ARNGMENT X1 WITH(READUNCOMMITTED)                 
P00726         WHERE X1.ACCOUNT_NO     = :X1-ACCOUNT-NO                 
P00726           AND X1.ARNG_STATUS_CD = 'A'                            
P00726                                                           
P00726                                                      
P00726     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ARNG_TYPE                                                  
MFA-TR*         INTO :X1-ARNG-TYPE                                              
MFA-TR*         FROM CSS_CRED_ARNGMENT X1                                       
MFA-TR*        WHERE X1.ACCOUNT_NO     = :X1-ACCOUNT-NO                         
MFA-TR*          AND X1.ARNG_STATUS_CD = 'A'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726                                                                  
P00726     EVALUATE SQLCODE                                             
P00726         WHEN SUCCESSFUL-CALL                                     
P00726              CONTINUE                                            
P00726         WHEN NOT-FOUND                                           
P00726              MOVE SPACES         TO X1-ARNG-TYPE                 
P00726         WHEN OTHER                                               
P00726              MOVE 'X1'           TO WS-DB2-TABLE-ID              
P00726              MOVE 'SELECT'       TO WS-DB2-FUNCTION              
P00726              MOVE SQLCODE        TO WS-DB2-RETURN-CODE           
P00726              MOVE '115'          TO WS-DB2-MODULE-ID             
P00726              MOVE '7010'         TO WS-DB2-PARAGRAPH             
P00726              MOVE X1-ACCOUNT-NO  TO WS-DB2-KEY-1                 
P00726              MOVE 12             TO RS-RETURN-CODE               
P00726              PERFORM 9910-SQL-ERROR          THRU 9910-EXIT      
P00726     END-EVALUATE.                                                
P00726                                                                  
P00726 7010-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
      ******************************************************************        
      * 7500-OPEN-BILL-WINDOW-CSR                                      *        
      ******************************************************************        
                                                                        
       7500-OPEN-BILL-WINDOW-CSR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN BILL-WINDOW                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'BN'                 TO WS-DB2-TABLE-ID              
              MOVE 'OPEN'               TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '7500'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-FETCH-BILL-WINDOW-CSR                                     *        
      ******************************************************************        
                                                                        
       7510-FETCH-BILL-WINDOW-CSR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH BILL-WINDOW                                         
               INTO :BN-DATE-EXTRACT                                    
                   ,:BN-BILL-CYCLE                                      
                   ,:BN-REVENUE-MONTH                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'BN'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH'              TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '7510'               TO WS-DB2-PARAGRAPH             
              MOVE WS-KR100-BE00-CUR-DT TO WS-DB2-KEY-1                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-CLOSE-BILL-WINDOW-CSR                                     *        
      ******************************************************************        
                                                                        
       7520-CLOSE-BILL-WINDOW-CSR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE BILL-WINDOW                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'BN'                 TO WS-DB2-TABLE-ID              
              MOVE 'CLOSE'              TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '7520'               TO WS-DB2-PARAGRAPH             
              MOVE WS-KR100-BE00-DT     TO WS-DB2-KEY-1                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7530-OPEN-DELINQUENCY-CSR                                      *        
      ******************************************************************        
                                                                        
       7530-OPEN-DELINQUENCY-CSR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN DELINQUENCY-CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'C8'                 TO WS-DB2-TABLE-ID              
              MOVE 'OPEN'               TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '7530'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7540-FETCH-DELINQUENCY-CSR                                     *        
      ******************************************************************        
                                                                        
       7540-FETCH-DELINQUENCY-CSR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH DELINQUENCY-CSR                                     
               INTO :C8-DELINQ-CD                                       
                   ,:C8-DELINQ-VALUE                                    
                   ,:C8-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'C8'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH'              TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '7540'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7550-CLOSE-DELINQUENCY-CSR                                     *        
      ******************************************************************        
                                                                        
       7550-CLOSE-DELINQUENCY-CSR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE DELINQUENCY-CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'C8'                 TO WS-DB2-TABLE-ID              
              MOVE 'CLOSE'              TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '7550'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7560-OPEN-CRED-FORECAST-CSR                                    *        
      ******************************************************************        
                                                                        
       7560-OPEN-CRED-FORECAST-CSR.                                     
                                                                        
           EXEC SQL                                                     
              OPEN CRED-FORECAST-CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CM'                 TO WS-DB2-TABLE-ID              
              MOVE 'OPEN'               TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '7560'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7570-FETCH-CRED-FORECAST-CSR                                   *        
      ******************************************************************        
                                                                        
       7570-FETCH-CRED-FORECAST-CSR.                                    
                                                                        
           EXEC SQL                                                     
              FETCH CRED-FORECAST-CSR                                   
               INTO :CM-COMPANY-NO                                      
                   ,:CM-REVENUE-MONTH                                   
                   ,:CM-BILL-DT                                         
                   ,:CM-BILL-CYCLE                                      
                   ,:CM-CRED-FORECAST-CD                                
                   ,:CM-COMPANY-NO                                      
                   ,:CM-ARREARS-DUE-DT :WS-ARREARS-DUE-DT-NULL      
                   ,:CM-CURR-CHG-DUE-DT :WS-CURR-CHG-DUE-DT-NULL     
                   ,:CM-DNP-NOTICE-MAIL-DT :WS-DNP-NOTICE-MAIL-DT-NULL  
                   ,:CM-DNP-NOTICE-DUE-DT :WS-DNP-NOTICE-DUE-DT-NULL   
                   ,:CM-DNP-REVIEW-DT :WS-DNP-REVIEW-DT-NULL       
                   ,:CM-DNP-DT :WS-DNP-DT-NULL              
                   ,:CM-IVR-CALL-DT :WS-IVR-CALL-DT-NULL         
                   ,:CM-AVOID-LPC-DT :WS-AVOID-LPC-DT-NULL        
                   ,:CM-NONUTIL-WQ-DT :WS-NONUTIL-WQ-DT-NULL       
                   ,:CM-REG-GROUP-CD                                    
                   ,:CM-CREDIT-GROUP                                    
                   ,:CM-CREDIT-GROUP-ID                                 
                   ,:CM-CRED-ACCT-TYPE-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ARREARS-DUE-DT-NULL < 0                                
              MOVE SPACES                 TO CM-ARREARS-DUE-DT          
              MOVE ZEROS                  TO WS-ARREARS-DUE-DT-NULL     
           END-IF.                                                      
           IF WS-CURR-CHG-DUE-DT-NULL < 0                               
              MOVE SPACES                 TO CM-CURR-CHG-DUE-DT         
              MOVE ZEROS                  TO WS-CURR-CHG-DUE-DT-NULL    
           END-IF.                                                      
           IF WS-DNP-NOTICE-MAIL-DT-NULL < 0                            
              MOVE SPACES                 TO CM-DNP-NOTICE-MAIL-DT      
              MOVE ZEROS                  TO WS-DNP-NOTICE-MAIL-DT-NULL 
           END-IF.                                                      
           IF WS-DNP-NOTICE-DUE-DT-NULL < 0                             
              MOVE SPACES                 TO CM-DNP-NOTICE-DUE-DT       
              MOVE ZEROS                  TO WS-DNP-NOTICE-DUE-DT-NULL  
           END-IF.                                                      
           IF WS-DNP-REVIEW-DT-NULL < 0                                 
              MOVE SPACES                 TO CM-DNP-REVIEW-DT           
              MOVE ZEROS                  TO WS-DNP-REVIEW-DT-NULL      
           END-IF.                                                      
           IF WS-DNP-DT-NULL < 0                                        
              MOVE SPACES                 TO CM-DNP-DT                  
              MOVE ZEROS                  TO WS-DNP-DT-NULL             
           END-IF.                                                      
           IF WS-IVR-CALL-DT-NULL < 0                                   
              MOVE SPACES                 TO CM-IVR-CALL-DT             
              MOVE ZEROS                  TO WS-IVR-CALL-DT-NULL        
           END-IF.                                                      
           IF WS-AVOID-LPC-DT-NULL < 0                                  
              MOVE SPACES                 TO CM-AVOID-LPC-DT            
              MOVE ZEROS                  TO WS-AVOID-LPC-DT-NULL       
           END-IF.                                                      
           IF WS-NONUTIL-WQ-DT-NULL < 0                                 
              MOVE SPACES                 TO CM-NONUTIL-WQ-DT           
              MOVE ZEROS                  TO WS-NONUTIL-WQ-DT-NULL      
           END-IF.                                                      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CM'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH'              TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '7570'               TO WS-DB2-PARAGRAPH             
              MOVE CM-BILL-DT           TO WS-DB2-KEY-1                 
              MOVE WS-KR100-BE00-CUR-DT TO WS-DB2-KEY-2                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7580-CLOSE-CRED-FORECAST-CSR                                   *        
      ******************************************************************        
                                                                        
       7580-CLOSE-CRED-FORECAST-CSR.                                    
                                                                        
           EXEC SQL                                                     
              CLOSE CRED-FORECAST-CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CM'                 TO WS-DB2-TABLE-ID              
              MOVE 'CLOSE'              TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '7580'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7580-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7590-OPEN-CRED-COLL                                            *        
      ******************************************************************        
                                                                        
       7590-OPEN-CRED-COLL.                                             
                                                                        
           EXEC SQL                                                     
              OPEN CRED-COLL-CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CL'                 TO WS-DB2-TABLE-ID              
              MOVE 'OPEN'               TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '7590'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7590-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-FETCH-CRED-COLL                                           *        
      ******************************************************************        
                                                                        
       7600-FETCH-CRED-COLL.                                            
                                                                        
           EXEC SQL                                                     
              FETCH CRED-COLL-CSR                                       
               INTO                                                     
                    :CL-ACCOUNT-NO                                      
                   ,:CL-CODE-SPECIAL-TYPE                               
                   ,:CL-DATE-NOTICE-MAIL :WS-DATE-NOTICE-MAIL-NULL    
                   ,:CL-CODE-FRCST-CR-GRP                               
                   ,:CL-ITEM-ID                                         
                   ,:CL-CODE-MESSAGE-TYPE                               
                   ,:CL-DATE-CREDIT-ACTION :WS-DATE-CREDIT-ACTION-NULL  
                   ,:CL-DATE-NOTICE-DUE :WS-DATE-NOTICE-DUE-NULL     
                   ,:CL-AMT-NOTICE                                      
                   ,:CL-CODE-NOTICE-TYPE                                
                   ,:CL-DATE-BILL :WS-DATE-BILL-NULL           
                   ,:CL-LAST-UPDATE-TS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              IF WS-DATE-NOTICE-MAIL-NULL   < ZERO                      
                 MOVE LOW-VALUES        TO CL-DATE-NOTICE-MAIL          
                 MOVE ZEROS             TO WS-DATE-NOTICE-MAIL-NULL     
              END-IF                                                    
              IF WS-DATE-CREDIT-ACTION-NULL < ZERO                      
                 MOVE LOW-VALUES        TO CL-DATE-CREDIT-ACTION        
                 MOVE ZEROS             TO WS-DATE-CREDIT-ACTION-NULL   
              END-IF                                                    
              IF WS-DATE-NOTICE-DUE-NULL    < ZERO                      
                 MOVE LOW-VALUES        TO CL-DATE-NOTICE-DUE           
                 MOVE ZEROS             TO WS-DATE-NOTICE-DUE-NULL      
              END-IF                                                    
              IF WS-DATE-BILL-NULL    < ZERO                            
                 MOVE LOW-VALUES        TO CL-DATE-BILL                 
                 MOVE ZEROS             TO WS-DATE-BILL-NULL            
              END-IF                                                    
           ELSE                                                         
              MOVE 'CL'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH'              TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '7600'               TO WS-DB2-PARAGRAPH             
              MOVE CL-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7610-CLOSE-CRED-COLL                                           *        
      ******************************************************************        
                                                                        
       7610-CLOSE-CRED-COLL.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE CRED-COLL-CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CL'                 TO WS-DB2-TABLE-ID              
              MOVE 'CLOSE'              TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '7610'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00726******************************************************************        
P00726* 7620-OPEN-CRED-ACTN                                            *        
P00726******************************************************************        
P00726                                                                  
P00726 7620-OPEN-CRED-ACTN.                                             
P00726                                                                  
P00726     EXEC SQL                                                     
P00726        OPEN CRED-ACTN                                            
P00726     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726                                                                  
P00726                                                                  
P00726     IF SQLCODE = SUCCESSFUL-CALL                                 
P00726        CONTINUE                                                  
P00726     ELSE                                                         
P00726        MOVE '4W'                 TO WS-DB2-TABLE-ID              
P00726        MOVE 'OPEN'               TO WS-DB2-FUNCTION              
P00726        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00726        MOVE '115'                TO WS-DB2-MODULE-ID             
P00726        MOVE '7620'               TO WS-DB2-PARAGRAPH             
P00726        MOVE 12                   TO RS-RETURN-CODE               
P00726        PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
P00726     END-IF.                                                      
P00726                                                                  
P00726 7620-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
P00726******************************************************************        
P00726* 7630-FETCH-CRED-ACTN                                           *        
P00726******************************************************************        
P00726                                                                  
P00726 7630-FETCH-CRED-ACTN.                                            
P00726                                                                  
P00726     EXEC SQL                                                     
P00726        FETCH CRED-ACTN                                           
P00726         INTO                                                     
P00726              :4W-ARNG-ID                                         
P00726             ,:4W-CRED-ARNG-SEQ                                   
P00726             ,:4W-CRED-ACTN-TYPE-CD                               
P00726             ,:4W-CRED-ACTN-SEQ                                   
P00726             ,:4W-CRED-ACTN-FCST-DT                               
P00726             ,:4W-CRED-ACTN-DUE-DT :WS-CRED-ACTN-DUE-DT-NULL      
P00726             ,:4W-CRED-ACTN-AM                                    
P00726     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726                                                                  
P00726     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
P00726        IF WS-CRED-ACTN-DUE-DT-NULL   < ZERO                      
P00726           MOVE LOW-VALUES        TO 4W-CRED-ACTN-DUE-DT          
P00726           MOVE ZEROS             TO WS-CRED-ACTN-DUE-DT-NULL     
P00726        END-IF                                                    
P00726     ELSE                                                         
P00726        MOVE '4W'                 TO WS-DB2-TABLE-ID              
P00726        MOVE 'FETCH'              TO WS-DB2-FUNCTION              
P00726        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00726        MOVE '115'                TO WS-DB2-MODULE-ID             
P00726        MOVE '7630'               TO WS-DB2-PARAGRAPH             
P00726        MOVE 4W-ACCOUNT-NO        TO WS-DB2-KEY-1                 
P00726        MOVE 12                   TO RS-RETURN-CODE               
P00726        PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
P00726     END-IF.                                                      
P00726                                                                  
P00726 7630-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
P00726******************************************************************        
P00726* 7640-CLOSE-CRED-COLL                                           *        
P00726******************************************************************        
P00726                                                                  
P00726 7640-CLOSE-CRED-ACTN.                                            
P00726                                                                  
P00726     EXEC SQL                                                     
P00726        CLOSE CRED-ACTN                                           
P00726     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726                                                                  
P00726     IF SQLCODE = SUCCESSFUL-CALL                                 
P00726        CONTINUE                                                  
P00726     ELSE                                                         
P00726        MOVE '4W'                 TO WS-DB2-TABLE-ID              
P00726        MOVE 'CLOSE'              TO WS-DB2-FUNCTION              
P00726        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00726        MOVE '115'                TO WS-DB2-MODULE-ID             
P00726        MOVE '7640'               TO WS-DB2-PARAGRAPH             
P00726        MOVE 12                   TO RS-RETURN-CODE               
P00726        PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
P00726     END-IF.                                                      
P00726                                                                  
P00726 7640-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
      ******************************************************************15170000
      * 8100-INSERT-CRED-COLL.                                         *15180000
      ******************************************************************15190000
                                                                        
       8100-INSERT-CRED-COLL.                                           
                                                                        
           IF CL-DATE-NOTICE-MAIL   = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-DATE-NOTICE-MAIL-NULL   
           ELSE                                                         
              MOVE ZERO                   TO WS-DATE-NOTICE-MAIL-NULL   
           END-IF                                                       
           IF CL-DATE-CREDIT-ACTION = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-DATE-CREDIT-ACTION-NULL 
           ELSE                                                         
              MOVE ZERO                   TO WS-DATE-CREDIT-ACTION-NULL 
           END-IF                                                       
           IF CL-DATE-NOTICE-DUE    = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-DATE-NOTICE-DUE-NULL    
           ELSE                                                         
              MOVE ZERO                   TO WS-DATE-NOTICE-DUE-NULL    
           END-IF                                                       
           IF CL-DATE-BILL          = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-DATE-BILL-NULL          
           ELSE                                                         
              MOVE ZERO                   TO WS-DATE-BILL-NULL          
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CRED_COLL                                 
                  (ACCOUNT_NO                                           
                 ,ITEM_ID                                               
                 ,DATE_BILL                                             
                 ,CODE_SPECIAL_TYPE                                     
                 ,DATE_NOTICE_MAIL                                      
                 ,CODE_FRCST_CR_GRP                                     
                 ,CODE_MESSAGE_TYPE                                     
                 ,DATE_CREDIT_ACTION                                    
                 ,DATE_NOTICE_DUE                                       
                 ,AMT_NOTICE                                            
                 ,CODE_NOTICE_TYPE                                      
                 ,LAST_UPDATE_TS)                                       
              VALUES                                                    
                  (:CL-ACCOUNT-NO                                       
                 ,:CL-ITEM-ID                                           
                 ,IIF(TRY_CONVERT(DATE, :CL-DATE-BILL :WS-DATE-BILL-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-BILL 
                                                     :WS-DATE-BILL-NULL
              ) <> 0) OR (LEN(:CL-DATE-BILL :WS-DATE-BILL-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-BILL :WS-DATE-BILL-NULL
              ), CONVERT(DATE, :CL-DATE-BILL :WS-DATE-BILL-NULL) )             
                 ,:CL-CODE-SPECIAL-TYPE                                 
                 ,IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-MAIL 
                                        :WS-DATE-NOTICE-MAIL-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ), CONVERT(DATE, :CL-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ) )      
                 ,:CL-CODE-FRCST-CR-GRP                                 
                 ,:CL-CODE-MESSAGE-TYPE                                 
                 ,IIF(TRY_CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                        :WS-DATE-CREDIT-ACTION-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION 
                                            :WS-DATE-CREDIT-ACTION-NULL
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION 
                                            :WS-DATE-CREDIT-ACTION-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION 
                                            :WS-DATE-CREDIT-ACTION-NULL
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                            :WS-DATE-CREDIT-ACTION-NULL
              ) )    
                 ,IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-DUE 
                                        :WS-DATE-NOTICE-DUE-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-DUE 
                                               :WS-DATE-NOTICE-DUE-NULL
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-DUE 
                                               :WS-DATE-NOTICE-DUE-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-DUE 
                                               :WS-DATE-NOTICE-DUE-NULL
              ), CONVERT(DATE, :CL-DATE-NOTICE-DUE 
                                               :WS-DATE-NOTICE-DUE-NULL
              ) )       
                 ,:CL-AMT-NOTICE                                        
                 ,:CL-CODE-NOTICE-TYPE                                  
                 ,CIS.CURRENT$TIMESTAMP())                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CRED_COLL                                         
MFA-TR*           (ACCOUNT_NO                                                   
MFA-TR*          ,ITEM_ID                                                       
MFA-TR*          ,DATE_BILL                                                     
MFA-TR*          ,CODE_SPECIAL_TYPE                                             
MFA-TR*          ,DATE_NOTICE_MAIL                                              
MFA-TR*          ,CODE_FRCST_CR_GRP                                             
MFA-TR*          ,CODE_MESSAGE_TYPE                                             
MFA-TR*          ,DATE_CREDIT_ACTION                                            
MFA-TR*          ,DATE_NOTICE_DUE                                               
MFA-TR*          ,AMT_NOTICE                                                    
MFA-TR*          ,CODE_NOTICE_TYPE                                              
MFA-TR*          ,LAST_UPDATE_TS)                                               
MFA-TR*       VALUES                                                            
MFA-TR*           (:CL-ACCOUNT-NO                                               
MFA-TR*          ,:CL-ITEM-ID                                                   
MFA-TR*          ,:CL-DATE-BILL          :WS-DATE-BILL-NULL                     
MFA-TR*          ,:CL-CODE-SPECIAL-TYPE                                         
MFA-TR*          ,:CL-DATE-NOTICE-MAIL   :WS-DATE-NOTICE-MAIL-NULL              
MFA-TR*          ,:CL-CODE-FRCST-CR-GRP                                         
MFA-TR*          ,:CL-CODE-MESSAGE-TYPE                                         
MFA-TR*          ,:CL-DATE-CREDIT-ACTION :WS-DATE-CREDIT-ACTION-NULL            
MFA-TR*          ,:CL-DATE-NOTICE-DUE    :WS-DATE-NOTICE-DUE-NULL               
MFA-TR*          ,:CL-AMT-NOTICE                                                
MFA-TR*          ,:CL-CODE-NOTICE-TYPE                                          
MFA-TR*          ,CURRENT TIMESTAMP)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CL'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '8100'               TO WS-DB2-PARAGRAPH             
              MOVE CL-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE CL-ITEM-ID           TO WS-DB2-KEY-2                 
              MOVE CL-CODE-NOTICE-TYPE  TO WS-DB2-KEY-3                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15170000
      * 8110-INSERT-BILL-CRED-DET                                      *        
      ******************************************************************15170000
                                                                        
       8110-INSERT-BILL-CRED-DET.                                       
                                                                        
           IF 1H-TOT-DUE-DT         = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-TOT-DUE-DT-NULL         
           ELSE                                                         
              MOVE ZERO                   TO WS-TOT-DUE-DT-NULL         
           END-IF                                                       
           IF 1H-UTL-NORM-DUE-DT    = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-UTL-NORM-DUE-DT-NULL    
           ELSE                                                         
              MOVE ZERO                   TO WS-UTL-NORM-DUE-DT-NULL    
           END-IF                                                       
           IF 1H-UTL-EXCP-DUE-DT    = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-UTL-EXCP-DUE-DT-NULL    
           ELSE                                                         
              MOVE ZERO                   TO WS-UTL-EXCP-DUE-DT-NULL    
           END-IF                                                       
           IF 1H-NONUTL-NORM-DUE-DT = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-NONUTL-NORM-DUE-DT-NULL 
           ELSE                                                         
              MOVE ZERO                   TO WS-NONUTL-NORM-DUE-DT-NULL 
           END-IF                                                       
           IF 1H-NONUTL-EXCP-DUE-DT = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-NONUTL-EXCP-DUE-DT-NULL 
           ELSE                                                         
              MOVE ZERO                   TO WS-NONUTL-EXCP-DUE-DT-NULL 
           END-IF                                                       
           IF 1H-ADDITIONAL-DUE-DT  = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-ADDITIONAL-DUE-DT-NULL  
           ELSE                                                         
              MOVE ZERO                   TO WS-ADDITIONAL-DUE-DT-NULL  
           END-IF                                                       
           IF 1H-AUTO-PAYMENT-DT    = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-AUTO-PAYMENT-DT-NULL    
           ELSE                                                         
              MOVE ZERO                   TO WS-AUTO-PAYMENT-DT-NULL    
           END-IF                                                       
           IF 1H-AVOID-LPC-DT       = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-AVOID-LPC-DT-INT-NULL   
           ELSE                                                         
              MOVE ZERO                   TO WS-AVOID-LPC-DT-INT-NULL   
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_BILL_CRED_DET                             
                  (ACCOUNT_NO                                           
                 ,BILL_NO                                               
                 ,COMPANY_NO                                            
                 ,REG_GROUP_CD                                          
                 ,UTL_EXCP_DUE_DT                                       
                 ,UTL_EXCP_NOT_AM                                       
                 ,NONUTL_EXCP_DUE_DT                                    
                 ,NONUTL_EXCP_NOT_AM                                    
                 ,UTL_NORM_DUE_DT                                       
                 ,UTL_NORM_NOT_AM                                       
                 ,NONUTL_NORM_DUE_DT                                    
                 ,NONUTL_NORM_NOT_AM                                    
                 ,TOT_ARREARS_AM                                        
                 ,UTL_ARREARS_AM                                        
                 ,NONUTL_ARREARS_AM                                     
                 ,TOT_CURR_AM                                           
                 ,UTL_CURR_AM                                           
                 ,NONUTL_CURR_AM                                        
                 ,TOT_DUE_DT                                            
                 ,TOT_DUE_AM                                            
                 ,UTL_TOT_DUE_AM                                        
                 ,NONUTL_TOT_DUE_AM                                     
                 ,AVOID_LPC_DT                                          
                 ,LPC_AM                                                
                 ,LPN_AM                                                
                 ,ADDITIONAL_DUE_DT                                     
                 ,AUTO_PAYMENT_DT                                       
                 ,BILL_CRED_MSG_ID                                      
                 ,BILL_CRED_NOT_ID                                      
                 ,CREATED_TS)                                           
              VALUES                                                    
                  (:1H-ACCOUNT-NO                                       
                 ,:1H-BILL-NO                                           
                 ,:1H-COMPANY-NO                                        
                 ,:1H-REG-GROUP-CD                                      
                 ,IIF(TRY_CONVERT(DATE, :1H-UTL-EXCP-DUE-DT 
                                        :WS-UTL-EXCP-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1H-UTL-EXCP-DUE-DT 
                                               :WS-UTL-EXCP-DUE-DT-NULL
              ) <> 0) OR (LEN(:1H-UTL-EXCP-DUE-DT 
                                               :WS-UTL-EXCP-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1H-UTL-EXCP-DUE-DT 
                                               :WS-UTL-EXCP-DUE-DT-NULL
              ), CONVERT(DATE, :1H-UTL-EXCP-DUE-DT 
                                               :WS-UTL-EXCP-DUE-DT-NULL
              ) )       
                 ,:1H-UTL-EXCP-NOT-AM                                   
                 ,IIF(TRY_CONVERT(DATE, :1H-NONUTL-EXCP-DUE-DT 
                                        :WS-NONUTL-EXCP-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1H-NONUTL-EXCP-DUE-DT 
                                            :WS-NONUTL-EXCP-DUE-DT-NULL
              ) <> 0) OR (LEN(:1H-NONUTL-EXCP-DUE-DT 
                                            :WS-NONUTL-EXCP-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1H-NONUTL-EXCP-DUE-DT 
                                            :WS-NONUTL-EXCP-DUE-DT-NULL
              ), CONVERT(DATE, :1H-NONUTL-EXCP-DUE-DT 
                                            :WS-NONUTL-EXCP-DUE-DT-NULL
              ) )    
                 ,:1H-NONUTL-EXCP-NOT-AM                                
                 ,IIF(TRY_CONVERT(DATE, :1H-UTL-NORM-DUE-DT 
                                        :WS-UTL-NORM-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1H-UTL-NORM-DUE-DT 
                                               :WS-UTL-NORM-DUE-DT-NULL
              ) <> 0) OR (LEN(:1H-UTL-NORM-DUE-DT 
                                               :WS-UTL-NORM-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1H-UTL-NORM-DUE-DT 
                                               :WS-UTL-NORM-DUE-DT-NULL
              ), CONVERT(DATE, :1H-UTL-NORM-DUE-DT 
                                               :WS-UTL-NORM-DUE-DT-NULL
              ) )       
                 ,:1H-UTL-NORM-NOT-AM                                   
                 ,IIF(TRY_CONVERT(DATE, :1H-NONUTL-NORM-DUE-DT 
                                        :WS-NONUTL-NORM-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1H-NONUTL-NORM-DUE-DT 
                                            :WS-NONUTL-NORM-DUE-DT-NULL
              ) <> 0) OR (LEN(:1H-NONUTL-NORM-DUE-DT 
                                            :WS-NONUTL-NORM-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1H-NONUTL-NORM-DUE-DT 
                                            :WS-NONUTL-NORM-DUE-DT-NULL
              ), CONVERT(DATE, :1H-NONUTL-NORM-DUE-DT 
                                            :WS-NONUTL-NORM-DUE-DT-NULL
              ) )    
                 ,:1H-NONUTL-NORM-NOT-AM                                
                 ,:1H-TOT-ARREARS-AM                                    
                 ,:1H-UTL-ARREARS-AM                                    
                 ,:1H-NONUTL-ARREARS-AM                                 
                 ,:1H-TOT-CURR-AM                                       
                 ,:1H-UTL-CURR-AM                                       
                 ,:1H-NONUTL-CURR-AM                                    
                 ,IIF(TRY_CONVERT(DATE, :1H-TOT-DUE-DT 
                                        :WS-TOT-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1H-TOT-DUE-DT 
                                                    :WS-TOT-DUE-DT-NULL
              ) <> 0) OR (LEN(:1H-TOT-DUE-DT :WS-TOT-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1H-TOT-DUE-DT 
                                                    :WS-TOT-DUE-DT-NULL
              ), CONVERT(DATE, :1H-TOT-DUE-DT :WS-TOT-DUE-DT-NULL) )           
                 ,:1H-TOT-DUE-AM                                        
                 ,:1H-UTL-TOT-DUE-AM                                    
                 ,:1H-NONUTL-TOT-DUE-AM                                 
                 ,IIF(TRY_CONVERT(DATE, :1H-AVOID-LPC-DT 
                                        :WS-AVOID-LPC-DT-INT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1H-AVOID-LPC-DT 
                                              :WS-AVOID-LPC-DT-INT-NULL
              ) <> 0) OR (LEN(:1H-AVOID-LPC-DT 
                                              :WS-AVOID-LPC-DT-INT-NULL
              ) <> 10), CIS.CHAR2DATE(:1H-AVOID-LPC-DT 
                                              :WS-AVOID-LPC-DT-INT-NULL
              ), CONVERT(DATE, :1H-AVOID-LPC-DT 
                                              :WS-AVOID-LPC-DT-INT-NULL
              ) )      
                 ,:1H-LPC-AM                                            
                 ,:1H-LPN-AM                                            
                 ,IIF(TRY_CONVERT(DATE, :1H-ADDITIONAL-DUE-DT 
                                        :WS-ADDITIONAL-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1H-ADDITIONAL-DUE-DT 
                                             :WS-ADDITIONAL-DUE-DT-NULL
              ) <> 0) OR (LEN(:1H-ADDITIONAL-DUE-DT 
                                             :WS-ADDITIONAL-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1H-ADDITIONAL-DUE-DT 
                                             :WS-ADDITIONAL-DUE-DT-NULL
              ), CONVERT(DATE, :1H-ADDITIONAL-DUE-DT 
                                             :WS-ADDITIONAL-DUE-DT-NULL
              ) )     
                 ,IIF(TRY_CONVERT(DATE, :1H-AUTO-PAYMENT-DT 
                                        :WS-AUTO-PAYMENT-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1H-AUTO-PAYMENT-DT 
                                               :WS-AUTO-PAYMENT-DT-NULL
              ) <> 0) OR (LEN(:1H-AUTO-PAYMENT-DT 
                                               :WS-AUTO-PAYMENT-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1H-AUTO-PAYMENT-DT 
                                               :WS-AUTO-PAYMENT-DT-NULL
              ), CONVERT(DATE, :1H-AUTO-PAYMENT-DT 
                                               :WS-AUTO-PAYMENT-DT-NULL
              ) )       
                 ,:1H-BILL-CRED-MSG-ID                                  
                 ,:1H-BILL-CRED-NOT-ID                                  
                 ,CIS.CHAR2TIMESTAMP(:1H-CREATED-TS))                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_BILL_CRED_DET                                     
MFA-TR*           (ACCOUNT_NO                                                   
MFA-TR*          ,BILL_NO                                                       
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,REG_GROUP_CD                                                  
MFA-TR*          ,UTL_EXCP_DUE_DT                                               
MFA-TR*          ,UTL_EXCP_NOT_AM                                               
MFA-TR*          ,NONUTL_EXCP_DUE_DT                                            
MFA-TR*          ,NONUTL_EXCP_NOT_AM                                            
MFA-TR*          ,UTL_NORM_DUE_DT                                               
MFA-TR*          ,UTL_NORM_NOT_AM                                               
MFA-TR*          ,NONUTL_NORM_DUE_DT                                            
MFA-TR*          ,NONUTL_NORM_NOT_AM                                            
MFA-TR*          ,TOT_ARREARS_AM                                                
MFA-TR*          ,UTL_ARREARS_AM                                                
MFA-TR*          ,NONUTL_ARREARS_AM                                             
MFA-TR*          ,TOT_CURR_AM                                                   
MFA-TR*          ,UTL_CURR_AM                                                   
MFA-TR*          ,NONUTL_CURR_AM                                                
MFA-TR*          ,TOT_DUE_DT                                                    
MFA-TR*          ,TOT_DUE_AM                                                    
MFA-TR*          ,UTL_TOT_DUE_AM                                                
MFA-TR*          ,NONUTL_TOT_DUE_AM                                             
MFA-TR*          ,AVOID_LPC_DT                                                  
MFA-TR*          ,LPC_AM                                                        
MFA-TR*          ,LPN_AM                                                        
MFA-TR*          ,ADDITIONAL_DUE_DT                                             
MFA-TR*          ,AUTO_PAYMENT_DT                                               
MFA-TR*          ,BILL_CRED_MSG_ID                                              
MFA-TR*          ,BILL_CRED_NOT_ID                                              
MFA-TR*          ,CREATED_TS)                                                   
MFA-TR*       VALUES                                                            
MFA-TR*           (:1H-ACCOUNT-NO                                               
MFA-TR*          ,:1H-BILL-NO                                                   
MFA-TR*          ,:1H-COMPANY-NO                                                
MFA-TR*          ,:1H-REG-GROUP-CD                                              
MFA-TR*          ,:1H-UTL-EXCP-DUE-DT    :WS-UTL-EXCP-DUE-DT-NULL               
MFA-TR*          ,:1H-UTL-EXCP-NOT-AM                                           
MFA-TR*          ,:1H-NONUTL-EXCP-DUE-DT :WS-NONUTL-EXCP-DUE-DT-NULL            
MFA-TR*          ,:1H-NONUTL-EXCP-NOT-AM                                        
MFA-TR*          ,:1H-UTL-NORM-DUE-DT    :WS-UTL-NORM-DUE-DT-NULL               
MFA-TR*          ,:1H-UTL-NORM-NOT-AM                                           
MFA-TR*          ,:1H-NONUTL-NORM-DUE-DT :WS-NONUTL-NORM-DUE-DT-NULL            
MFA-TR*          ,:1H-NONUTL-NORM-NOT-AM                                        
MFA-TR*          ,:1H-TOT-ARREARS-AM                                            
MFA-TR*          ,:1H-UTL-ARREARS-AM                                            
MFA-TR*          ,:1H-NONUTL-ARREARS-AM                                         
MFA-TR*          ,:1H-TOT-CURR-AM                                               
MFA-TR*          ,:1H-UTL-CURR-AM                                               
MFA-TR*          ,:1H-NONUTL-CURR-AM                                            
MFA-TR*          ,:1H-TOT-DUE-DT         :WS-TOT-DUE-DT-NULL                    
MFA-TR*          ,:1H-TOT-DUE-AM                                                
MFA-TR*          ,:1H-UTL-TOT-DUE-AM                                            
MFA-TR*          ,:1H-NONUTL-TOT-DUE-AM                                         
MFA-TR*          ,:1H-AVOID-LPC-DT       :WS-AVOID-LPC-DT-INT-NULL              
MFA-TR*          ,:1H-LPC-AM                                                    
MFA-TR*          ,:1H-LPN-AM                                                    
MFA-TR*          ,:1H-ADDITIONAL-DUE-DT  :WS-ADDITIONAL-DUE-DT-NULL             
MFA-TR*          ,:1H-AUTO-PAYMENT-DT    :WS-AUTO-PAYMENT-DT-NULL               
MFA-TR*          ,:1H-BILL-CRED-MSG-ID                                          
MFA-TR*          ,:1H-BILL-CRED-NOT-ID                                          
MFA-TR*          ,:1H-CREATED-TS)                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE '1H'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '8110'               TO WS-DB2-PARAGRAPH             
              MOVE 1H-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE 1H-BILL-NO           TO WS-DB2-KEY-2                 
              MOVE 1H-COMPANY-NO        TO WS-DB2-KEY-3                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15170000
      * 8300-UPDATE-CRED-COLL                                          *15180000
      ******************************************************************15190000
                                                                        
       8300-UPDATE-CRED-COLL.                                           
                                                                        
           IF CL-DATE-NOTICE-MAIL   = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-DATE-NOTICE-MAIL-NULL   
           ELSE                                                         
              MOVE ZERO                   TO WS-DATE-NOTICE-MAIL-NULL   
           END-IF                                                       
           IF CL-DATE-CREDIT-ACTION = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-DATE-CREDIT-ACTION-NULL 
           ELSE                                                         
              MOVE ZERO                   TO WS-DATE-CREDIT-ACTION-NULL 
           END-IF                                                       
           IF CL-DATE-NOTICE-DUE    = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-DATE-NOTICE-DUE-NULL    
           ELSE                                                         
              MOVE ZERO                   TO WS-DATE-NOTICE-DUE-NULL    
           END-IF                                                       
           IF CL-DATE-BILL          = LOW-VALUES OR SPACES              
              MOVE -1                     TO WS-DATE-BILL-NULL          
           ELSE                                                         
              MOVE ZERO                   TO WS-DATE-BILL-NULL          
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CRED_COLL                                      
                 SET CODE_SPECIAL_TYPE   = :CL-CODE-SPECIAL-TYPE,       
                     DATE_NOTICE_MAIL    = IIF(TRY_CONVERT(DATE, 
                                                  :CL-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ), CONVERT(DATE, :CL-DATE-NOTICE-MAIL 
                                              :WS-DATE-NOTICE-MAIL-NULL
              ) ),   
                     CODE_FRCST_CR_GRP   = :CL-CODE-FRCST-CR-GRP,       
                     CODE_MESSAGE_TYPE   = :CL-CODE-MESSAGE-TYPE,       
                     DATE_CREDIT_ACTION  = IIF(TRY_CONVERT(DATE, 
                                                :CL-DATE-CREDIT-ACTION 
                                            :WS-DATE-CREDIT-ACTION-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION 
                                            :WS-DATE-CREDIT-ACTION-NULL
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION 
                                            :WS-DATE-CREDIT-ACTION-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION 
                                            :WS-DATE-CREDIT-ACTION-NULL
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                            :WS-DATE-CREDIT-ACTION-NULL
              ) ), 
                     DATE_NOTICE_DUE     = IIF(TRY_CONVERT(DATE, 
                                                   :CL-DATE-NOTICE-DUE 
                                               :WS-DATE-NOTICE-DUE-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-DUE 
                                               :WS-DATE-NOTICE-DUE-NULL
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-DUE 
                                               :WS-DATE-NOTICE-DUE-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-DUE 
                                               :WS-DATE-NOTICE-DUE-NULL
              ), CONVERT(DATE, :CL-DATE-NOTICE-DUE 
                                               :WS-DATE-NOTICE-DUE-NULL
              ) ),    
                     AMT_NOTICE          = :CL-AMT-NOTICE,              
                     DATE_BILL           = IIF(TRY_CONVERT(DATE, 
                                                         :CL-DATE-BILL 
                                                     :WS-DATE-BILL-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-BILL 
                                                     :WS-DATE-BILL-NULL
              ) <> 0) OR (LEN(:CL-DATE-BILL :WS-DATE-BILL-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-BILL :WS-DATE-BILL-NULL
              ), CONVERT(DATE, :CL-DATE-BILL :WS-DATE-BILL-NULL) ),          
PRODIS               PROCESSED_CD        = ' ',                         
                     LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP()            
               WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO               
                 AND ITEM_ID             = :CL-ITEM-ID                  
                 AND CODE_NOTICE_TYPE    = :CL-CODE-NOTICE-TYPE         
                 AND LAST_UPDATE_TS      = CIS.CHAR2TIMESTAMP(
                                                     :CL-LAST-UPDATE-TS
              )           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CRED_COLL                                              
MFA-TR*          SET CODE_SPECIAL_TYPE   = :CL-CODE-SPECIAL-TYPE,               
MFA-TR*              DATE_NOTICE_MAIL    = :CL-DATE-NOTICE-MAIL                 
MFA-TR*                                    :WS-DATE-NOTICE-MAIL-NULL,           
MFA-TR*              CODE_FRCST_CR_GRP   = :CL-CODE-FRCST-CR-GRP,               
MFA-TR*              CODE_MESSAGE_TYPE   = :CL-CODE-MESSAGE-TYPE,               
MFA-TR*              DATE_CREDIT_ACTION  = :CL-DATE-CREDIT-ACTION               
MFA-TR*                                    :WS-DATE-CREDIT-ACTION-NULL,         
MFA-TR*              DATE_NOTICE_DUE     = :CL-DATE-NOTICE-DUE                  
MFA-TR*                                    :WS-DATE-NOTICE-DUE-NULL,            
MFA-TR*              AMT_NOTICE          = :CL-AMT-NOTICE,                      
MFA-TR*              DATE_BILL           = :CL-DATE-BILL                        
MFA-TR*                                    :WS-DATE-BILL-NULL,                  
MFA-TR*              PROCESSED_CD        = ' ',                                 
MFA-TR*              LAST_UPDATE_TS      = CURRENT TIMESTAMP                    
MFA-TR*        WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO                       
MFA-TR*          AND ITEM_ID             = :CL-ITEM-ID                          
MFA-TR*          AND CODE_NOTICE_TYPE    = :CL-CODE-NOTICE-TYPE                 
MFA-TR*          AND LAST_UPDATE_TS      = :CL-LAST-UPDATE-TS                   
MFA-TR*      QUERYNO 8300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE 12 TO RS-RETURN-CODE                            
                   PERFORM 9999-BAIL-OUT                 THRU 9999-EXIT 
              WHEN OTHER                                                
                   MOVE 'CL'                 TO WS-DB2-TABLE-ID         
                   MOVE 'UPDATE'             TO WS-DB2-FUNCTION         
                   MOVE SQLCODE              TO WS-DB2-RETURN-CODE      
                   MOVE '115'                TO WS-DB2-MODULE-ID        
                   MOVE '8300'               TO WS-DB2-PARAGRAPH        
                   MOVE CL-ACCOUNT-NO        TO WS-DB2-KEY-1            
                   MOVE CL-ITEM-ID           TO WS-DB2-KEY-2            
                   MOVE CL-CODE-NOTICE-TYPE  TO WS-DB2-KEY-3            
                   MOVE 12                   TO RS-RETURN-CODE          
                   PERFORM 9910-SQL-ERROR                THRU 9910-EXIT 
           END-EVALUATE.                                                
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15170000
      * 8310-UPDATE-UTL-NUTL-HIST                                      *15180000
      ******************************************************************15190000
                                                                        
       8310-UPDATE-UTL-NUTL-HIST.                                       
                                                                        
           IF CZ-CR-GRP-EFFECT-DT = LOW-VALUES OR SPACES                
              MOVE -1                    TO WS-CR-GRP-EFFECT-DT-NULL    
           ELSE                                                         
              MOVE ZERO                  TO WS-CR-GRP-EFFECT-DT-NULL    
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CREDIT_PROFILE                                 
                 SET ARREARS_HIST        = :CZ-ARREARS-HIST             
                    ,DISCONNECT_HIST     = :CZ-DISCONNECT-HIST          
                    ,DISC_EXCEPTN_HIST   = :CZ-DISC-EXCEPTN-HIST        
                    ,NON_UTL_ARRER_HIST  = :CZ-NON-UTL-ARRER-HIST       
                    ,NON_UTL_CR_HST      = :CZ-NON-UTL-CR-HST           
                    ,NON_UTL_CR_HST_EX   = :CZ-NON-UTL-CR-HST-EX        
                    ,CR_GRP_EFFECT_DT    = IIF(TRY_CONVERT(DATE, 
                                                  :CZ-CR-GRP-EFFECT-DT 
                                              :WS-CR-GRP-EFFECT-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :CZ-CR-GRP-EFFECT-DT 
                                              :WS-CR-GRP-EFFECT-DT-NULL
              ) <> 0) OR (LEN(:CZ-CR-GRP-EFFECT-DT 
                                              :WS-CR-GRP-EFFECT-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:CZ-CR-GRP-EFFECT-DT 
                                              :WS-CR-GRP-EFFECT-DT-NULL
              ), CONVERT(DATE, :CZ-CR-GRP-EFFECT-DT 
                                              :WS-CR-GRP-EFFECT-DT-NULL
              ) )    
                    ,LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP()            
               WHERE ACCOUNT_NO          = :CZ-ACCOUNT-NO               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CREDIT_PROFILE                                         
MFA-TR*          SET ARREARS_HIST        = :CZ-ARREARS-HIST                     
MFA-TR*             ,DISCONNECT_HIST     = :CZ-DISCONNECT-HIST                  
MFA-TR*             ,DISC_EXCEPTN_HIST   = :CZ-DISC-EXCEPTN-HIST                
MFA-TR*             ,NON_UTL_ARRER_HIST  = :CZ-NON-UTL-ARRER-HIST               
MFA-TR*             ,NON_UTL_CR_HST      = :CZ-NON-UTL-CR-HST                   
MFA-TR*             ,NON_UTL_CR_HST_EX   = :CZ-NON-UTL-CR-HST-EX                
MFA-TR*             ,CR_GRP_EFFECT_DT    = :CZ-CR-GRP-EFFECT-DT                 
MFA-TR*                                    :WS-CR-GRP-EFFECT-DT-NULL            
MFA-TR*             ,LAST_UPDATE_TS      = CURRENT TIMESTAMP                    
MFA-TR*        WHERE ACCOUNT_NO          = :CZ-ACCOUNT-NO                       
MFA-TR*      QUERYNO 8310                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CZ'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '8310'               TO WS-DB2-PARAGRAPH             
              MOVE CZ-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       8310-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00726*****************************************************************         
P00726* 8320-UPDATE-BILL-NO-ACTN-FL                                   *         
P00726*****************************************************************         
P00726                                                                  
P00726 8320-UPDATE-BILL-NO-ACTN-FL.                                     
P00726                                                                  
P00726     MOVE '8320'                TO ACTIVE-PARAGRAPH.              
P00726                                                                  
P00726     IF 4W-BILL-NO <= 0                                           
P00726        MOVE -1                     TO WS-BILL-NO-NULL            
P00726     ELSE                                                         
P00726        MOVE ZERO                   TO WS-BILL-NO-NULL            
P00726     END-IF                                                       
P00726                                                                  
P00726     EXEC SQL                                                     
P00726        UPDATE CSS_CRED_ARNG_ACTN                                 
P00726           SET PROCESSED_FL       = 'Y'                           
P00726              ,BILL_NO            = :4W-BILL-NO :WS-BILL-NO-NULL  
P00726         WHERE ACCOUNT_NO         = :4W-ACCOUNT-NO                
P00726           AND ARNG_ID            = :4W-ARNG-ID                   
P00726           AND CRED_ARNG_SEQ      = :4W-CRED-ARNG-SEQ             
P00726           AND CRED_ACTN_TYPE_CD  = :4W-CRED-ACTN-TYPE-CD         
P00726           AND CRED_ACTN_SEQ      = :4W-CRED-ACTN-SEQ             
P00726     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726                                                                  
P00726     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00726                                                                  
P00726     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00726        CONTINUE                                                  
P00726     ELSE                                                         
P00726        MOVE '4W'                 TO WS-DB2-TABLE-ID              
P00726        MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
P00726        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00726        MOVE '115'                TO WS-DB2-MODULE-ID             
P00726        MOVE '8320'               TO WS-DB2-PARAGRAPH             
P00726        MOVE 4W-ACCOUNT-NO        TO WS-DB2-KEY-1                 
P00726        MOVE 4W-ARNG-ID           TO WS-DB2-KEY-2                 
P00726        MOVE 4W-CRED-ARNG-SEQ     TO WS-DB2-KEY-3                 
P00726        MOVE 12                   TO RS-RETURN-CODE               
P00726        PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
P00726     END-IF.                                                      
P00726                                                                  
P00726 8320-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
      ******************************************************************15170000
      * 8500-DELETE-CRED-COLL.                                         *15180000
      ******************************************************************15190000
                                                                        
       8500-DELETE-CRED-COLL.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
               WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                 
                 AND ITEM_ID           = :CL-ITEM-ID                    
                 AND CODE_NOTICE_TYPE  = :CL-CODE-NOTICE-TYPE           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CL'                 TO WS-DB2-TABLE-ID              
              MOVE 'DELETE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '8500'               TO WS-DB2-PARAGRAPH             
              MOVE CL-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE CL-ITEM-ID           TO WS-DB2-KEY-2                 
              MOVE CL-CODE-NOTICE-TYPE  TO WS-DB2-KEY-3                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-TERMINATE                                                 *        
      ******************************************************************        
                                                                        
       9000-TERMINATE.                                                  
                                                                        
       9000-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 9900-ABEND                                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0023B                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************11440000
      * 9910-SQL-ERROR.                                                *11450000
      ******************************************************************11460000
                                                                        
       9910-SQL-ERROR.                                                  
                                                                        
           IF WS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-WQ-INDX GREATER THAN 50'                      
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 12 TO RS-RETURN-CODE                                 
           ELSE                                                         
              ADD 1 TO WS-CURR-WQ-ITEM                                  
           END-IF.                                                      
                                                                        
           MOVE WS-DATABASE-EXCEPTION   TO                              
                WS-WQ-ITEMS-DATA-WF(WS-WQ-INDX).                        
ACT308      MOVE WS-PGRMNAME            TO                              
ACT308          WS-WQ-CREATED-BY-WF (WS-WQ-INDX).                       
           COMPUTE WS-START-POS = WS-WQ-COMMENTS-LEN-WF(WS-WQ-INDX) + 1 
           MOVE WS-SQL-ERROR-TXT-WQ     TO                              
                WS-WQ-COMMENTS-TEXT-WF (WS-WQ-INDX)(WS-START-POS:)      
           ADD  WS-SQL-ERROR-TXT-LEN-WQ TO                              
                WS-WQ-COMMENTS-LEN-WF(WS-WQ-INDX).                      
           ADD  1 TO WS-WQ-INDX                                         
                                                                        
           PERFORM 9999-BAIL-OUT                         THRU 9999-EXIT.
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11440000
      * 9920-MISC-ERROR                                                *11450000
      ******************************************************************11460000
                                                                        
       9920-MISC-ERROR.                                                 
                                                                        
           IF WS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-WQ-INDX GREATER THAN 50'                      
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 12 TO RS-RETURN-CODE                                 
           ELSE                                                         
              ADD 1                          TO WS-CURR-WQ-ITEM         
              MOVE WS-MISCELLANEOUS-MESSAGE  TO                         
                   WS-WQ-ITEMS-DATA-WF (WS-WQ-INDX)                     
ACT308        MOVE WS-PGRMNAME            TO                            
ACT308             WS-WQ-CREATED-BY-WF (WS-WQ-INDX)                     
              COMPUTE WS-START-POS =                                    
                      WS-WQ-COMMENTS-LEN-WF (WS-WQ-INDX) + 1            
              MOVE WS-SUPPLEMENTAL-TXT-WQ    TO                         
                   WS-WQ-COMMENTS-TEXT-WF (WS-WQ-INDX) (WS-START-POS:)  
              ADD WS-SUPPLEMENTAL-TXT-LEN-WQ TO                         
                  WS-WQ-COMMENTS-LEN-WF (WS-WQ-INDX)                    
              ADD 1 TO WS-WQ-INDX                                       
           END-IF.                                                      
                                                                        
           PERFORM 9999-BAIL-OUT                         THRU 9999-EXIT.
                                                                        
       9920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11440000
      * 9999-BAIL-OUT                                                  *11740000
      ******************************************************************11460000
                                                                        
       9999-BAIL-OUT.                                                   
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
