       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSKR111.                                        
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      **              CUSTOMER INFORMATION SYSTEM                    **         
      *****************************************************************         
      **              P R O G R A M  S U M M A R Y                   **         
      **                                                             **         
      ** THIS PROGRAM WAS DERIVED FROM PORTIONS OF SCSCA110 AND      **         
      ** SCSCA113.                                                   **         
      **                                                             **         
      ** THIS PROGRAM WILL DO THE FOLLOWING.                         **         
      ** 1) CREDIT GROUP UPDATE                                      **         
      ** 2) CREDIT STATUS UPDATE                                     **         
      ** 3) GUARANTOR RELEASE                                        **         
      ** 4) FORECASTED CREDIT GROUP UPDATE                           **         
      *****************************************************************         
      **              PROGRAM  MODIFICATION  LOG                      *         
      **                                                              *         
      **    DATE    INITIALS     REASON                               *         
      **  -------   --------     ------                               *         
P00599**  12/21/11  RB19957      DATE WRITTEN.                        *         
ACT111**  10/15/12  SV95326      FIX CREDIT MOVEMNET ISSUE.(APPL3967) *         
ACT308**  01/17/15  SS7F226      ADD CREATED-BY FIELD IN WF AREA      *         
      **   A04880                                                     *         
ACT159**  08/21/15  MJ13662      FOR SEB, USE SECOND-NOTICE-DNP LIMIT *         
ACT159**                         INSTEAD OF FIRST-NOTICE LIMIT WHEN   *         
ACT159**                         REVIEWING FORECASTED CREDIT GROUP    *         
ACT159**                         CHANGE.                              *         
      *****************************************************************         
      **           ---- BASIC SEQUENCE STRUCTURE ----                **         
      **            0000 - 0000     MAIN CONTROL PATH                **         
      **            0100 - 0100     INITIALIZATION                   **         
      **            1000 - 1000     MAJOR PROCESSING LOOP            **         
      **            1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR    **         
      **                            PROCESSING LOOPS                 **         
      **            5000 - 5999     COMMON PROGRAM MODULES           **         
      **            6000 - 6999     COMMON SYSTEM MODULES            **         
      **            7000 - 7999     INPUT MODULES                    **         
      **            8000 - 8999     OUTPUT MODULES                   **         
      **            9000 - 9799     TERMINATION MODULES              **         
      **            9900 - 9999     ABEND/ABORT MODULES              **         
      **                  ---- PARAGRAPH STRUCTURE ----              **         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSKR111'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(40)     VALUE              
           'WORKING STORAGE FOR SCSKR111 STARTS HERE'.                  
      *                                                                         
       01  PROGRAM-WORK-VARIABLES.                                      
           05  WS-MAX-MONTH                  PIC S9(02) COMP VALUE 0.   
COB305     05 WS-CUR-ACCUM        PIC S9(09)V99 COMP-3 VALUE 0.      
           05  WS-TOTAL-NONUTIL-ARREARS      PIC S9(9)V99 VALUE ZERO.   
           05  WS-VARIABLE-ID                PIC X(20).                 
COB305     05 WS-VARIABLE-VALUE        PIC S9(4)V9(5) COMP-3 VALUE 0.     
           05  WS-DELINQ-COMPANY             PIC X(02).                 
           05  WS-CURRENT-COMPANY            PIC X(02) VALUE SPACES.    
           05  WS-START-POS                  PIC S9(4) COMP.            
           05  WS-CURRENT-DATE               PIC X(10).                 
           05  WS-DATE-1                     PIC X(10).                 
           05  WS-DATE-2                     PIC X(10).                 
           05  WS-RELOAD-HIST-SW             PIC X(01).                 
           05  WS-MONTHS-TO-EVALUATE         PIC S9(9) COMP.            
           05  CURRENT-DATE                  PIC X(10) VALUE SPACES.    
           05  CURRENT-TIMESTAMP             PIC X(26) VALUE SPACES.    
COB305     05 WS-CURRENT-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.         
           05  WS-UTIL-HISTORY.                                         
               10 WS-UTILITY-ARREARS         PIC X(24) VALUE SPACES.    
               10 WS-UTIL-LAST-MTH-HST       PIC X(01) VALUE SPACES.    
           05  WS-NON-UTIL-HISTORY.                                     
               10 WS-NON-UTILITY-ARREARS     PIC X(24) VALUE SPACES.    
               10 WS-NON-UTIL-LAST-MTH-HST   PIC X(01) VALUE SPACES.    
           05  WS-HAS-MORE-GUARANTEES        PIC X(01).                 
           05  WS-HOLD-GUAR-STATUS           PIC X(01).                 
           05  WS-CODES-DATA-PRES-HOLD       PIC X(32).                 
           05  WS-EPP-OFFER-DATE             PIC X(10).                 
           05  WS-RETAIN-COMMER-DEP          PIC S9(04) COMP VALUE 0.   
           05  WS-RETAIN-INDUST-DEP          PIC S9(04) COMP VALUE 0.   
           05  WS-RETAIN-RESIDENT-DEP        PIC S9(04) COMP VALUE 0.   
           05  WS-RETAIN-DEL-MTHS            PIC S9(04) COMP VALUE 0.   
           05  WS-MAX-MONTHXX                PIC S9(02) COMP VALUE 0.   
           05  WS-GRAND-FATHER-DEPOSIT       PIC X(01) VALUE SPACE.     
           05  WS-DELINQ-VALUE9              PIC 9999V9999.             
           05  WS-DELINQ-VALUEX REDEFINES WS-DELINQ-VALUE9 PIC X(09).   
           05  WS-START-DATE-TIME-STAMP.                                
               10  WS-DEP-DATE-TRAN.                                    
                   15  WS-DEP-DATE-TRAN-CCYY PIC X(4) VALUE SPACES.     
                   15  WS-FILLER1            PIC X(1) VALUE '-'.        
                   15  WS-DEP-DATE-TRAN-MM   PIC X(2) VALUE SPACES.     
                   15  WS-FILLER2            PIC X(1) VALUE '-'.        
                   15  WS-DEP-DATE-TRAN-DD   PIC X(2) VALUE SPACES.     
               10  WS-TIME-STAMP             PIC X(16)                  
                                 VALUE '-01.01.01.000001'.              
           05  WS-RELEASE-GUARANTOR          PIC X(01) VALUE SPACES.    
           05  WS-RECENT-DEPOSIT-SW          PIC X(01) VALUE SPACES.    
           05  WS-RES-SECUR-START-DATE.                                 
               10  WS-RES-SECUR-DATE.                                   
                   15  WS-RES-DATE-CCYY      PIC X(4) VALUE SPACES.     
                   15  WS-FILLER1-RES        PIC X(1) VALUE '-'.        
                   15  WS-RES-DATE-MM        PIC X(2) VALUE SPACES.     
                   15  WS-FILLER2-RES        PIC X(1) VALUE '-'.        
                   15  WS-RES-DATE-DD        PIC X(2) VALUE SPACES.     
COB305     05 WS-UTILITY-ARREARS-LS        PIC S9(9)V99 COMP-3 VALUE 0.      
COB305     05 WS-NONUTIL-ARREARS        PIC S9(9)V99 COMP-3 VALUE 0.      
COB305     05 WS-CONTRACT-ARREARS        PIC S9(9)V99 COMP-3 VALUE 0.      
COB305     05 WS-DAY-60-UTL-RELATED-DELINQ        PIC S9(9)V99 COMP-3 
COB305       VALUE 0.      
COB305     05 WS-DAY-90-UTL-RELATED-DELINQ        PIC S9(9)V99 COMP-3 
COB305       VALUE 0.      
           05  WS-ARREARS-HIST-MONTHS-LS      PIC S9(4) COMP.           
           05  WS-CURR-WQ-ITEM                PIC S9(4) COMP.           
      *                                                                         
       01  WS-DELINQUENCY-VALUES-TABLE.                                 
           05  WS-DELINQ-COMPANY-ENTRY-TB                               
               OCCURS 5 TIMES                                           
               INDEXED BY TB-CO-INDEX.                                  
               10  WS-DELINQ-VALUE-ENTRY-TB                             
                   OCCURS 10 TIMES                                      
                   INDEXED BY TB-VAL-INDEX.                             
                   15  WS-DELINQ-COMPANY-TB   PIC X(02).                
                   15  WS-DELINQ-CODE-TB      PIC X(20).                
COB305             15 WS-DELINQ-VALUE-TB        PIC S9(4)V9(5) COMP-3 
COB305               VALUE 0.    
      *                                                                         
       01  WS-DELINQUENCY-AMT-CONSTANTS USAGE COMP-3.                   
COB305     05 WS-SECOND-DNP-LIMIT        PIC S9(5)V99 VALUE 0.             
      *                                                                         
       01  WS-NOTICE-WORK-FIELDS.                                       
           05  WS-FORECAST-CR-GRP            PIC X(1).                  
           05  WS-TEMP-ARREARS-HIST          PIC X(24).                 
           05  WS-TEMP-DISCONNECT-HIST       PIC X(24).                 
           05  WS-TEMP-DISC-EXCEPTN-HIST     PIC X(24).                 
COB305     05 WS-TOTAL-ARREARS        PIC S9(9)V99 COMP-3 VALUE 0.       
      *                                                                         
       01 WS-FRCST-CRED-GROUPS.                                         
           05  WS-MONTH                      PIC S9(04) COMP.           
           05  WS-ARREARS-COUNT              PIC S9(04) COMP.           
           05  WS-ARREARS-HIST-MONTHS        PIC S9(04) COMP.           
           05  WS-DISCONN-ENTRIES            PIC S9(04) COMP.           
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-GUARANTORS-SW        PIC X(01)     VALUE 'N'.         
               88  END-OF-GUARANTORS                 VALUE 'Y'.         
           05  FILLER                      PIC X(20) VALUE              
               'ACTIVE PARAGRAPH IS:'.                                  
           05  WS-DELINQ-WORK-AREA-LOAD-CNTRL     PIC X(1) VALUE '0'.   
               88  DW-NOT-LOADED                  VALUE '0'.            
               88  DW-LOADED                      VALUE '1'.            
           05  WS-DISCONNECT-ACTION               PIC X(1).             
               88  NO-DISCONNECT-OCCURRED         VALUE '0'.            
               88  DISCONNECT-OCCURRED            VALUE '1'.            
           05  WS-HAS-GUARANTOR-SW                PIC X(1) VALUE '0'.   
               88  WS-HAS-GUARANTOR               VALUE '1'.            
           05  WS-ON-OFF-CYCLE-IND               PIC X(1).              
               88  WS-OFF-CYCLE-FINAL            VALUE 'B'.             
               88  WS-OFF-CYCLE-REBILL           VALUE 'O'.             
               88  WS-ON-CYCLE-BILL              VALUE 'A'.             
               88  WS-OFF-CYCLE-ACCT-TRANS       VALUE 'T'.             
               88  WS-PRP-FIRST-EST              VALUE 'P'.             
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-CODE-APPLIES         PIC X(01) VALUE 'A'.             
           05  WS-OVER-30-DAYS         PIC X(01) VALUE '1'.             
           05  WS-OVER-60-DAYS         PIC X(01) VALUE '2'.             
           05  WS-OVER-90-DAYS         PIC X(01) VALUE '3'.             
           05  WS-NO-BILL              PIC X(01) VALUE 'X'.             
           05  WS-REJECT               PIC X(01) VALUE 'R'.             
           05  WS-WARNING              PIC X(01) VALUE 'W'.             
           05  WS-GOOD                 PIC X(01) VALUE 'G'.             
           05  WS-BAD                  PIC X(01) VALUE 'B'.             
           05  WS-UNKNOWN              PIC X(01) VALUE 'U'.             
           05  WS-EXEMPT               PIC X(01) VALUE 'C'.             
           05  WS-NRML-HIST-IN-LAST-XX-MNTHS                            
                                       PIC X(1)      VALUE 'N'.         
           05  WS-XCPTN-HIST-IN-LAST-XX-MNTHS                           
                                       PIC X(1)      VALUE 'N'.         
           05  WS-3                    PIC X(01)     VALUE '3'.         
           05  WS-4                    PIC X(01)     VALUE '4'.         
           05  WS-I                    PIC X(01)     VALUE 'I'.         
           05  WS-R                    PIC X(01)     VALUE 'R'.         
           05  WS-REL-GOOD-CREDIT      PIC X(01) VALUE 'G'.             
           05  WS-GUARANTOR-DESC       PIC X(15) VALUE                  
               'GUAR-STATUS-REA'.                                       
           05  WS-MAINTENANCE-DESC     PIC X(25) VALUE                  
               'CHANGE GUARANTOR STATUS  '.                             
           05  WS-SYSTEM               PIC X(07) VALUE 'SYSTEM '.       
           05  WS-PGRMNAME             PIC X(08) VALUE 'SCSKR111'.      
           05  WS-PSNC                 PIC X(02) VALUE '26'.            
           05  WS-SCEG                 PIC X(02) VALUE '01'.            
           05  WS-REGULATED            PIC X(02) VALUE '02'.            
           05  WS-LOW-INCOME           PIC X(03) VALUE '100'.           
           05  WS-WQ-CREATED-FLAG      PIC X(01)  VALUE 'N'.            
           05  WS-CRED-GRP-MAINT-DESC-SEB.                              
               10  FILLER                   PIC X(40)                   
                   VALUE 'CREDIT GROUP CHANGED BY SYSTEM BASED ON '.    
               10  FILLER                   PIC X(11)                   
                   VALUE 'HISTORIES: '.                                 
               10  FILLER                   PIC X(12)                   
                   VALUE '            '.                                
               10  FILLER                   PIC X(09)                   
                   VALUE 'ARREARS: '.                                   
               10  WS-ARREARS-HIST-SEB      PIC X(12).                  
               10  FILLER                   PIC X(09)                   
                   VALUE ' NORMAL: '.                                   
               10  WS-DISCONNECT-HIST       PIC X(12).                  
               10  FILLER                   PIC X(21)                   
                   VALUE '                     '.                       
               10  FILLER                   PIC X(13)                   
                   VALUE 'EXCEPTIONAL: '.                               
               10  WS-DISC-EXCEPTN-HIST     PIC X(12).                  
           05  WS-CRED-GRP-MAINT-DESC.                                  
               10  FILLER                   PIC X(40)                   
                   VALUE 'CREDIT GROUP CHANGED BY SYSTEM BASED ON '.    
               10  FILLER                   PIC X(09)                   
                   VALUE 'HISTORY: '.                                   
               10  FILLER                   PIC X(14)                   
                   VALUE '              '.                              
               10  FILLER                   PIC X(09)                   
                   VALUE 'ARREARS: '.                                   
               10  WS-ARREARS-HIST          PIC X(24).                  
           05  WS-CRED-GROUP-DESC           PIC X(15)  VALUE            
                'CREDIT GROUP   '.                                      
           05  WS-EFFECT-DT-DESC            PIC X(15)  VALUE            
               'EFFECTIVE DT   '.                                       
      *                                                                         
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER                PIC S9(4)    COMP VALUE +137.  
               10  FILLER                PIC X(1)     VALUE 'N'.        
               10  FILLER                PIC X(1)     VALUE '4'.        
               10  FILLER                PIC S9(4)    COMP VALUE +29.   
               10  FILLER                PIC X(30)    VALUE             
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  WS-MISC-CATEGORY-ID     PIC S9(4) COMP.              
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  WS-ROUTING              PIC X(1)  VALUE '4'.         
               10  WS-MISC-MSG-LEN         PIC S9(4) COMP VALUE +95.    
               10  WS-MISC-MSG-TEXT        PIC X(95).                   
      *                                                                         
      ********************************************************                  
      *   WORKING STORAGE SUPPLEMENTAL WQ TEXT                                  
      ********************************************************                  
       COPY CWS0070B.                                                           
      *                                                                         
      ******************************************************************        
      *      WORKING STORAGE LAYOUT FOR CODES_DATA_PRESENT ON TABLE    *        
      *      CSS_ACCOUNT                                               *        
      ******************************************************************        
       COPY CWS00056.                                                           
      *                                                                         
      *************************************************************             
      * THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.                
      *************************************************************             
       COPY CWS00303.                                                           
      *                                                                         
      ****************************************************************          
      **        CWS00010            WS ABEND WORK AREA                          
      ****************************************************************          
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      **        SUPPORT RESTART-REQ PARAMETER                                   
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE CWS00038                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **            WS FOR CPD00334 - GOOD CREDIT RULE LOGIC        ****        
      ******************************************************************        
       COPY CWS00334.                                                           
      *                                                                         
      ****************************************************************          
      **************WS FOR CPD09900 - ABEND PROCESSING ***************          
      ****************************************************************          
       COPY CWS09900.                                                           
      *                                                                         
      *****************************************************************         
      *****************************************************************         
      *  WORKING STORAGE FOR BASIC DB2 DCLGENS                        *         
      *****************************************************************         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  AT - CSS_ACCOUNT                                                       
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  YP - CSS_ACCT_ATTRIBUTE                                                
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
      *                                                                         
RICK*******************************************************************         
RICK***  BH - CSS_BUDGET_HIST                                                   
RICK*******************************************************************         
RICK***    EXEC SQL                                                             
RICK***       INCLUDE TBBGTHST                                                  
RICK***    END-EXEC.                                                            
RICK***                                                                         
      *****************************************************************         
      *  C8 - CSS_DELINQUENCY                                                   
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  DO - CSS_DEP_ON_HAND                                                   
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  GU - CSS_GUARANTOR                                                     
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBGTNTR                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  RN - CSS_REFUND                                                        
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBREFUND                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  SB - CSS_SURETY_BOND                                                   
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR SCSKR111 ENDS HERE  '.            
      *                                                                         
      *****************************************************************         
      *  CURSOR SELECT STATEMENTS                                               
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE DELINQUENCY-CSR CURSOR FOR                        
                 SELECT DELINQ_CD,                                      
                        DELINQ_VALUE,                                   
                        COMPANY_NO                                      
                   FROM CSS_DELINQUENCY                                 
ACT159           WHERE DELINQ_CD IN ('AMT-SECONDDNPL',                  
                       'RETAIN-COMMER-DEP', 'RETAIN-INDUST-DEP',        
                       'RETAIN-RESIDENT-DEP', 'COM-IND-START-DATE',     
                       'RES-SECUR-START-DATE')                          
                 ORDER BY COMPANY_NO                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DELINQUENCY-CSR CURSOR FOR                                
MFA-TR*          SELECT DELINQ_CD,                                              
MFA-TR*                 DELINQ_VALUE,                                           
MFA-TR*                 COMPANY_NO                                              
MFA-TR*            FROM CSS_DELINQUENCY                                         
MFA-TR*          WHERE DELINQ_CD IN ('AMT-SECONDDNPL',                          
MFA-TR*                'RETAIN-COMMER-DEP', 'RETAIN-INDUST-DEP',                
MFA-TR*                'RETAIN-RESIDENT-DEP', 'COM-IND-START-DATE',             
MFA-TR*                'RES-SECUR-START-DATE')                                  
MFA-TR*          ORDER BY COMPANY_NO                                            
MFA-TR*          QUERYNO 7012                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
              DECLARE GUARANTOR_CURSOR CURSOR FOR                       
              SELECT AMOUNT_GUARANTEED,                                 
                     CNT_ITEM_ID,                                       
                     GUARNTR_ACCT_NO,                                   
                     GUAR_STATUS_CD,                                    
                     GUAR_STATUS_REASON,                                
                     REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                     ADDRESS_ID,                                        
                     SERVICE_TYPE_CD                                    
              FROM CSS_GUARANTOR                                        
              WHERE ACCOUNT_NO     = :GU-ACCOUNT-NO                     
                AND GUAR_STATUS_CD = 'A'                                
              FOR UPDATE OF GUAR_STATUS_CD,                             
                            GUAR_STATUS_REASON,                         
                            LAST_UPDATE_TS                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GUARANTOR_CURSOR CURSOR FOR                               
MFA-TR*       SELECT AMOUNT_GUARANTEED,                                         
MFA-TR*              CNT_ITEM_ID,                                               
MFA-TR*              GUARNTR_ACCT_NO,                                           
MFA-TR*              GUAR_STATUS_CD,                                            
MFA-TR*              GUAR_STATUS_REASON,                                        
MFA-TR*              LAST_UPDATE_TS,                                            
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              SERVICE_TYPE_CD                                            
MFA-TR*       FROM CSS_GUARANTOR                                                
MFA-TR*       WHERE ACCOUNT_NO     = :GU-ACCOUNT-NO                             
MFA-TR*         AND GUAR_STATUS_CD = 'A'                                        
MFA-TR*       FOR UPDATE OF GUAR_STATUS_CD,                                     
MFA-TR*                     GUAR_STATUS_REASON,                                 
MFA-TR*                     LAST_UPDATE_TS                                      
MFA-TR*       QUERYNO 7130                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
      *****************************************************************         
      *   THIS COPY STATEMENT CONTAINS THE WORKING STORAGE TABLE      *         
      *   LAYOUT FOR CUSTOMER BILL EXTRACT INFORMATION                *         
      *   QSAM FILE FCSBE00                                           *         
      *****************************************************************         
       COPY  CWS1000B.                                                          
      *                                                                         
      *****************************************************************         
      *   THIS COPY STATEMENT CONTAINS THE WORKING STORAGE TABLE      *         
      *   LAYOUT TO PROCESS / INSERT DATA FOR                         *         
      *           1. PCSKR100 ACCOUNT SPECIFIC PROCESSING DATA        *         
      *           2. CSS_MNT_TRANS_HIST                               *         
      *           3. CSS_MN_TRN_HST_DET                               *         
      *           4. CSS_WQ_ITEMS_MF                                  *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CWS10008                                                  
           END-EXEC.                                                            
      *                                                                         
       01  RS-RETURN-CODE                  PIC S9(04)   COMP VALUE 0.   
      *                                                                         
      ***************************************************                       
      ***************************************************                       
       PROCEDURE DIVISION USING WS-KR100-CUST-DATA                      
                                WS-ACCOUNT-AT                           
                                WS-CREDIT-PROFILE-CZ                    
                                WS-TRANS-HIST-MH                        
                                WS-TRN-HST-DET-MI                       
                                WS-WQ-ITEMS-MF                          
                                WS-CWS1000B-MAX-TBL-LIMITS              
                                RS-RETURN-CODE.                         
      *****************************************************************         
      **    0000-MAINLINE                                            **         
      **      MAIN PROCESSING MODULE - CONTROLS PROGRAM FLOW         **         
      *****************************************************************         
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           IF DW-NOT-LOADED                                             
              PERFORM 0110-LOAD-DELINQUENCY-TABLE   THRU 0110-EXIT      
              SET DW-LOADED TO TRUE                                     
           END-IF.                                                      
      *                                                                         
           PERFORM 0500-LOAD-LINKAGE-DATA THRU 0500-EXIT.               
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
      *                                                                         
           IF WS-OLD-CREDIT-GROUP > SPACES                              
              MOVE WS-CREDIT-STATUS-CODE-AT TO AT-CREDIT-STATUS-CODE    
              MOVE WS-CREDIT-GROUP-AT       TO AT-CREDIT-GROUP          
              PERFORM 6510-MOVE-TRANS-HST-HEADER  THRU 6510-EXIT        
              PERFORM 6550-MOVE-TRANS-HST-DETAILS THRU 6550-EXIT        
              ADD +1 TO WS-MH-TRN-INDX                                  
           END-IF.                                                      
      *                                                                         
           EXIT PROGRAM.                                                
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    0100-INITIALIZATION                                      **         
      **      INITIALIZES VARIOUS WORKING STOREAGE FIELDS.           **         
      *****************************************************************         
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE RS-RETURN-CODE                                    
                      PROGRAM-WORK-VARIABLES                            
                      WS-NOTICE-WORK-FIELDS.                            
      *                                                                         
           MOVE WS-KR100-BE00-DT          TO WS-INPUT-DATE.             
           MOVE WS-ACCOUNT-NO-AT          TO AT-ACCOUNT-NO.             
           MOVE WS-CUSTOMER-NO-AT         TO AT-CUSTOMER-NO.            
      *                                                                         
           MOVE 'N'  TO WS-WQ-CREATED-FLAG.                             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    0110-LOAD-DELINQUENCY-TABLE                              **         
      **      GETS AND LOADS ALL THE DELIQUENCY VALUES USED.         **         
      *****************************************************************         
       0110-LOAD-DELINQUENCY-TABLE.                                     
      *                                                                         
           PERFORM 7010-OPEN-DW THRU 7010-EXIT.                         
           PERFORM 7012-FETCH-DW THRU 7012-EXIT.                        
           SET TB-CO-INDEX TO 1.                                        
           SET TB-VAL-INDEX TO 1.                                       
           PERFORM 0111-LOAD-DELINQ-VALUES THRU 0111-EXIT               
                   UNTIL SQLCODE = NOT-FOUND.                           
           PERFORM 7014-CLOSE-DW THRU 7014-EXIT.                        
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    0111-LOAD-DELINQ-VALUES                                  **         
      **      MOVES ALL THE DELIQUENCY VALUES TO WS FIELDS.          **         
      *****************************************************************         
       0111-LOAD-DELINQ-VALUES.                                         
      *                                                                         
           MOVE C8-DELINQ-CD TO WS-VARIABLE-ID.                         
           MOVE C8-DELINQ-VALUE TO WS-VARIABLE-VALUE.                   
           MOVE C8-COMPANY-NO TO WS-DELINQ-COMPANY.                     
      *                                                                         
           EVALUATE WS-VARIABLE-ID                                      
ACT159        WHEN 'AMT-SECONDDNPL'                                     
                 PERFORM 0112-LOAD-TABLE-ENTRY THRU 0112-EXIT           
              WHEN 'RETAIN-COMMER-DEP'                                  
                 PERFORM 0112-LOAD-TABLE-ENTRY THRU 0112-EXIT           
              WHEN 'RETAIN-INDUST-DEP'                                  
                 PERFORM 0112-LOAD-TABLE-ENTRY THRU 0112-EXIT           
              WHEN 'RETAIN-RESIDENT-DEP'                                
                 PERFORM 0112-LOAD-TABLE-ENTRY THRU 0112-EXIT           
              WHEN 'COM-IND-START-DATE'                                 
                 PERFORM 0112-LOAD-TABLE-ENTRY THRU 0112-EXIT           
              WHEN 'RES-SECUR-START-DATE'                               
                 PERFORM 0112-LOAD-TABLE-ENTRY THRU 0112-EXIT           
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 7012-FETCH-DW THRU 7012-EXIT.                        
      *                                                                         
           IF C8-COMPANY-NO NOT EQUAL WS-DELINQ-COMPANY                 
               SET TB-CO-INDEX UP BY 1                                  
               SET TB-VAL-INDEX TO 1                                    
           END-IF.                                                      
      *                                                                         
       0111-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    0112-LOAD-TABLE-ENTRY                                    **         
      **      LOADS ALL THE DELIQUENCY VALUES TO A TABLE ENTRY       **         
      *****************************************************************         
       0112-LOAD-TABLE-ENTRY.                                           
      *                                                                         
           MOVE WS-DELINQ-COMPANY TO                                    
               WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX).        
           MOVE WS-VARIABLE-ID TO                                       
               WS-DELINQ-CODE-TB (TB-CO-INDEX, TB-VAL-INDEX).           
           MOVE WS-VARIABLE-VALUE TO                                    
               WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX).          
           SET TB-VAL-INDEX UP BY 1.                                    
      *                                                                         
       0112-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  0150-LOAD-ACC-DELINQ-VARIABLES                               *         
      *****************************************************************         
       0150-LOAD-ACC-DELINQ-VARIABLES.                                  
      *                                                                         
           SET TB-CO-INDEX TO 1.                                        
           SET TB-VAL-INDEX TO 1.                                       
      *                                                                         
           PERFORM UNTIL                                                
             WS-COMPANY-NO-AT EQUAL                                     
             WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX)           
             OR TB-CO-INDEX > 5                                         
               IF WS-COMPANY-NO-AT EQUAL                                
                  WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX)      
                   NEXT SENTENCE                                        
               ELSE                                                     
                   SET TB-CO-INDEX UP BY 1                              
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 0180-LOAD-DELINQ-VARIABLES THRU 0180-EXIT            
               UNTIL TB-VAL-INDEX > 10.                                 
           IF SEB-DATABASE                                              
               PERFORM 0200-VERIFY-DW-VARIABLES THRU 0200-EXIT          
           END-IF.                                                      
      *                                                                         
           MOVE WS-COMPANY-NO-AT TO WS-CURRENT-COMPANY.                 
      *                                                                         
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  0180-LOAD-DELINQ-VARIABLES                                   *         
      *****************************************************************         
       0180-LOAD-DELINQ-VARIABLES.                                      
      *                                                                         
           EVALUATE WS-DELINQ-CODE-TB (TB-CO-INDEX, TB-VAL-INDEX)       
ACT159        WHEN 'AMT-SECONDDNPL'                                     
                 MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)    
ACT159               TO WS-SECOND-DNP-LIMIT                             
                 SET TB-VAL-INDEX UP BY 1                               
              WHEN 'RETAIN-COMMER-DEP'                                  
                 MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)    
                     TO WS-RETAIN-COMMER-DEP                            
                 SET TB-VAL-INDEX UP BY 1                               
              WHEN 'RETAIN-INDUST-DEP'                                  
                 MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)    
                     TO WS-RETAIN-INDUST-DEP                            
                 SET TB-VAL-INDEX UP BY 1                               
              WHEN 'RETAIN-RESIDENT-DEP'                                
                 MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)    
                     TO WS-RETAIN-RESIDENT-DEP                          
                 SET TB-VAL-INDEX UP BY 1                               
              WHEN 'COM-IND-START-DATE'                                 
                 MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)    
                     TO WS-DELINQ-VALUE9                                
                 MOVE WS-DELINQ-VALUEX(1:4) TO WS-DEP-DATE-TRAN-CCYY    
                 MOVE WS-DELINQ-VALUEX(5:2) TO WS-DEP-DATE-TRAN-MM      
                 MOVE WS-DELINQ-VALUEX(7:2) TO WS-DEP-DATE-TRAN-DD      
                 MOVE '-'                   TO WS-FILLER1               
                                               WS-FILLER2               
                 SET TB-VAL-INDEX UP BY 1                               
              WHEN 'RES-SECUR-START-DATE'                               
                 MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)    
                     TO WS-DELINQ-VALUE9                                
                 MOVE WS-DELINQ-VALUEX(1:4) TO WS-RES-DATE-CCYY         
                 MOVE WS-DELINQ-VALUEX(5:2) TO WS-RES-DATE-MM           
                 MOVE WS-DELINQ-VALUEX(7:2) TO WS-RES-DATE-DD           
                 MOVE '-'                   TO WS-FILLER1-RES           
                                               WS-FILLER2-RES           
                 SET TB-VAL-INDEX UP BY 1                               
              WHEN OTHER                                                
                 SET TB-VAL-INDEX UP BY 1                               
           END-EVALUATE.                                                
      *                                                                         
       0180-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   0200-VERIFY-DW-VARIABLES   CHECK FOR DELINQUENCY VALUES =< 0          
      *****************************************************************         
       0200-VERIFY-DW-VARIABLES.                                        
      *                                                                         
ACT159     IF WS-SECOND-DNP-LIMIT > 0                                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'DELINQ CONSTANTS NOT CORRECT' TO WS-MISC-MSG-TEXT   
              MOVE +28 TO WS-MISC-MSG-LEN                               
              MOVE +17 TO WS-MISC-CATEGORY-ID                           
              MOVE 16 TO RS-RETURN-CODE                                 
              PERFORM 9920-MISC-ERROR THRU 9920-EXIT                    
           END-IF.                                                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    0500-LOAD-LINKAGE-DATA                                   **         
      **      MOVES ALL THE DELIQUENCY VALUES TO WS FIELDS.          **         
      *****************************************************************         
       0500-LOAD-LINKAGE-DATA.                                          
      *                                                                         
           MOVE WS-CODES-DATA-PRESENT-AT   TO WS-CODES-DATA-PRESENT.    
           MOVE WS-CURRENT-CHARGES-CALC    TO WS-CUR-ACCUM.             
           MOVE WS-CODE-OFF-CYCLE-CALC     TO WS-ON-OFF-CYCLE-IND.      
           MOVE WS-PAST-UTIL-CHARGES-CALC  TO WS-UTILITY-ARREARS-LS.    
           MOVE WS-KR100-PREV-DISC-HIST    TO WS-ACCT-DISCONNECT-HST.   
           MOVE WS-KR100-PREV-DISC-EX-HIST TO WS-ACCT-DISC-EXCEPTN-HST. 
           MOVE WS-KR100-BE00-DT           TO WS-CURRENT-DATE.          
           MOVE WS-KR100-UTL-60-DELINQ TO WS-DAY-60-UTL-RELATED-DELINQ. 
           MOVE WS-KR100-UTL-90-DELINQ TO WS-DAY-90-UTL-RELATED-DELINQ. 
           MOVE WS-KR100-ACCOUNT-NO    TO WS-CURRENT-ACCT-NO.           
           MOVE WS-CODE-OFF-CYCLE-CALC TO WS-ON-OFF-CYCLE-IND.          
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    2000-PROCESS-OUTPUT                                      **         
      **      THIS PARAGRAPH DOES THE INITIAL PROCESSING OF CREDIT   **         
      **      GROUP MOVEMENT.                                        **         
      *****************************************************************         
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           IF WS-COMPANY-NO-AT NOT EQUAL WS-CURRENT-COMPANY             
               PERFORM 0150-LOAD-ACC-DELINQ-VARIABLES THRU 0150-EXIT    
           END-IF.                                                      
      *                                                                         
      ***  FOR SEB REG ACCTS MOVE THE SBR FIELDS TO THE LIMIT FIELDS,           
      *        OTHERWISE MOVE THE ORG FIELDS TO THE LIMIT FIELDS.               
      *                                                                         
      *****************************************************************         
      *  ONLY SEND ACTIVE ACCOUNTS THROUGH CREDIT GROUP CHANGE LOGIC            
      *  IF OFF-CYCLE-REBILL (INSIDE OR OUTSIDE THE BILL WINDOW), SKIP          
      *  CREDIT GROUP MOVEMENT LOGIC.                                           
      *  SKIP THE CREDIT GROUP LOGIC IF CREDIT GROUP IS 'M'/'S'/'D'             
      *****************************************************************         
           IF WS-ON-CYCLE-BILL                                          
               IF (WS-CREDIT-GROUP-AT = 'M' OR 'S' OR 'D') OR           
                  (SEB-DATABASE AND (WS-REGULATED-CD-AT = WS-REGULATED  
                   OR WS-CREDIT-GROUP-AT = 'B'))                        
                    PERFORM 3250-DETERMINE-NEW-STATUS THRU 3250-EXIT    
               ELSE                                                     
                    PERFORM 3100-NEW-CRED-GRP-SETUP     THRU 3100-EXIT  
                    PERFORM 3200-DETERMINE-NEW-CRED-GRP THRU 3200-EXIT  
               END-IF                                                   
      *                                                                         
               IF SEB-DATABASE AND WS-REGULATED-CD-AT = WS-REGULATED    
                   PERFORM 2300-PROCESS-FCST-CR-GRP THRU 2300-EXIT      
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  2300-PROCESS-FCST-CR-GRP                                     *         
      *  DO NOT FORECAST CREDIT GROUP IF CANCEL-REBILL (INSIDE OR     *         
      *  OUTSIDE THE BILL WINDOW).                                    *         
      *****************************************************************         
       2300-PROCESS-FCST-CR-GRP.                                        
      *                                                                         
           MOVE WS-CURRENT-ACCT-NO TO YP-ACCOUNT-NO.                    
           PERFORM 8300-DELETE-ACCT-ATTRBT  THRU 8300-EXIT.             
           MOVE SPACES TO WS-FORECAST-CR-GRP.                           
           PERFORM 5100-FORECAST-SEB-CR-GRP THRU 5100-EXIT.             
      *                                                                         
           IF WS-FORECAST-CR-GRP > SPACES                               
               MOVE WS-CURRENT-ACCT-NO   TO YP-ACCOUNT-NO               
               MOVE 'FCST CR GP BALANCE' TO YP-ATTRIBUTE-DESC           
               MOVE WS-FORECAST-CR-GRP   TO YP-ATTRIBUTE-VALUE-CD       
               MOVE WS-INPUT-DATE        TO YP-ATTRIBUTE-VALUE-DT       
               MOVE SPACES               TO YP-ATTRIBUTE-VALUE-TX-TEXT  
               MOVE LENGTH OF YP-ATTRIBUTE-VALUE-TX-TEXT TO             
                                            YP-ATTRIBUTE-VALUE-TX-LEN   
               MOVE 'A'                  TO YP-STATUS-CD                
               PERFORM 7690-GET-CURR-DATE-STAMP THRU 7690-EXIT          
               MOVE CURRENT-TIMESTAMP    TO YP-CREATED-TS               
               PERFORM 8320-INSERT-ACCT-ATTRBT THRU 8320-EXIT           
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  3100-NEW-CRED-GRP-SETUP.                                               
      *  THE PARAGRAPH DOES PRE-PRECESSING FOR                                  
      *  3200--DETERMINE-NEW-CRED-GRP.                                          
      *****************************************************************         
       3100-NEW-CRED-GRP-SETUP.                                         
      *                                                                         
           MOVE ZERO TO WS-MONTHS-TO-EVALUATE                           
                        WS-ARREARS-COUNT                                
                        WS-ARREARS-HIST-MONTHS                          
                        WS-DISCONN-ENTRIES.                             
           MOVE SPACES              TO WS-OLD-CREDIT-GROUP              
                                       WS-OLD-CR-GRP-EFFECT-DT.         
                                                                        
           MOVE 'N'  TO WS-RELOAD-HIST-SW.                              
      *                                                                         
           IF WS-CR-GRP-EFFECT-DT-CZ > SPACES                           
              MOVE WS-CR-GRP-EFFECT-DT-CZ TO WS-DATE-1                  
              MOVE WS-INPUT-DATE          TO WS-DATE-2                  
              PERFORM 7060-GET-NUMBER-OF-MONTHS THRU 7060-EXIT          
              DIVIDE WS-MONTHS-TO-EVALUATE BY 30                        
                 GIVING WS-MONTHS-TO-EVALUATE                           
              IF WS-MONTHS-TO-EVALUATE > ZERO                           
                 IF CSR-DATABASE                                        
                    PERFORM 3245-PROCESS-CSR-HIST  THRU 3245-EXIT       
                 ELSE                                                   
                    PERFORM 3240-PROCESS-SEB-HIST  THRU 3240-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE ZERO                     TO WS-RETAIN-DEL-MTHS.         
           MOVE WS-PGRMNAME              TO WS-PROGRAM-CPD334.          
           MOVE WS-COMPANY-NO-AT         TO WS-COMPANY-CPD334.          
      *                                                                         
           EVALUATE WS-ACCOUNT-TYPE-CODE-AT                             
              WHEN 'C'                                                  
                 MOVE WS-ACCOUNT-NO-AT TO DO-ACCOUNT-NO                 
                                          SB-ACCOUNT-NO                 
                                          GU-ACCOUNT-NO                 
                 MOVE WS-DEP-DATE-TRAN TO DO-DATE-TRAN                  
                                          SB-DATE-BOND-ISSUED           
                                          GU-GUAR-ESTBLSH-DT            
                 MOVE WS-RETAIN-COMMER-DEP   TO WS-RETAIN-DEL-MTHS      
                 MOVE 'N' TO WS-GRAND-FATHER-DEPOSIT                    
                 PERFORM 7770-CK-GRAND-FATHER-DEPOSIT THRU 7770-EXIT    
                 IF WS-GRAND-FATHER-DEPOSIT = 'N'                       
                    MOVE WS-RETAIN-COMMER-DEP TO WS-MAX-MONTHXX         
                 ELSE                                                   
                    MOVE 12 TO WS-MAX-MONTHXX                           
                 END-IF                                                 
              WHEN 'I'                                                  
                 MOVE WS-ACCOUNT-NO-AT TO DO-ACCOUNT-NO                 
                                          SB-ACCOUNT-NO                 
                                          GU-ACCOUNT-NO                 
                 MOVE WS-DEP-DATE-TRAN TO DO-DATE-TRAN                  
                                          SB-DATE-BOND-ISSUED           
                                          GU-GUAR-ESTBLSH-DT            
                 MOVE WS-RETAIN-INDUST-DEP   TO WS-RETAIN-DEL-MTHS      
                 MOVE 'N' TO WS-GRAND-FATHER-DEPOSIT                    
                 PERFORM 7770-CK-GRAND-FATHER-DEPOSIT THRU 7770-EXIT    
                 IF WS-GRAND-FATHER-DEPOSIT = 'N'                       
                    MOVE WS-RETAIN-INDUST-DEP TO WS-MAX-MONTHXX         
                 ELSE                                                   
                    MOVE 12 TO WS-MAX-MONTHXX                           
                 END-IF                                                 
              WHEN OTHER                                                
                 IF CSR-DATABASE                                        
                    MOVE WS-RETAIN-RESIDENT-DEP TO WS-RETAIN-DEL-MTHS   
                 ELSE                                                   
                    MOVE 12                     TO WS-MAX-MONTHXX       
                 END-IF                                                 
           END-EVALUATE.                                                
      *                                                                         
              IF WS-MAX-MONTHXX > 23                                    
                 COMPUTE WS-MAX-MONTHXX = 23                            
              END-IF.                                                   
              IF WS-RETAIN-DEL-MTHS > 24                                
                 COMPUTE WS-RETAIN-DEL-MTHS = 24                        
              END-IF.                                                   
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  3200-DETERMINE-NEW-CRED-GRP                                            
      *  THE PARAGRAPH DETERMINES CREDIT GROUP MOVEMENT.                        
      *  DO NOT CONSIDER REMAINDER WHEN DETERMINING # MONTHS TO                 
      *  EVALUATE.                                                              
      *****************************************************************         
       3200-DETERMINE-NEW-CRED-GRP.                                     
      *****************************************************************         
      *  FOR CSR, PROCESS ARREARS HISTORY ONLY.                       *         
      *****************************************************************         
              IF SEB-DATABASE                                           
                 PERFORM 3210-PROCESS-CREDIT-HISTORY THRU 3210-EXIT     
                 PERFORM 3220-PROCESS-DISC-HISTORY   THRU 3220-EXIT     
              ELSE                                                      
                 MOVE +0      TO WS-ELIG-NO-MTHS                        
                                 WS-DELINQ-MTH                          
                                 WS-ARRS-CNT                            
                 MOVE 'N'     TO WS-NOT-USE-CR-HIST-FL                  
                 MOVE SPACES  TO WS-ACCT-HST                            
                 COMPUTE WS-ELIG-NO-MTHS = WS-RETAIN-DEL-MTHS + 1       
                 MOVE WS-RETAIN-DEL-MTHS       TO WS-DELINQ-MTH         
                 MOVE WS-ARREARS-HIST-CZ       TO WS-UTILITY-ARREARS    
                 MOVE WS-KR100-PREV-ARR-HIST(24:1)                      
                                               TO WS-UTIL-LAST-MTH-HST  
                 MOVE WS-UTIL-HISTORY          TO WS-ACCT-HST           
                 IF WS-CREDIT-GROUP-AT = WS-EXEMPT AND                  
                    WS-CR-GRP-EFFECT-DT-CZ > SPACES                     
                    MOVE 'Y'     TO WS-NOT-USE-CR-HIST-FL               
                 END-IF                                                 
                 PERFORM 6565-PROCESS-CREDIT-RULE    THRU 6565-EXIT     
              END-IF.                                                   
      *                                                                         
             IF (WS-CR-GRP-EFFECT-DT-CZ > SPACES AND                    
                 WS-MONTHS-TO-EVALUATE > 0) OR                          
                 (WS-CR-GRP-EFFECT-DT-CZ NOT > SPACES)                  
                 IF SEB-DATABASE                                        
                     PERFORM 3230-DECIDE-SEB-NEW-CR-GRP                 
                                                   THRU 3230-EXIT       
                 ELSE                                                   
                     IF WS-COMPANY-NO-AT = WS-SCEG                      
                         PERFORM 3231-DECIDE-SCEG-NEW-CR-GRP            
                                                   THRU 3231-EXIT       
                     ELSE                                               
                         PERFORM 3232-DECIDE-PSNC-NEW-CR-GRP            
                                                   THRU 3232-EXIT       
                     END-IF                                             
                 END-IF                                                 
              END-IF.                                                   
      *                                                                         
      *****************************************************************         
      *  IF HISTORIES WERE MOVED OUT DUE TO CREDIT GROUP CHANGE                 
      *  RELOAD ORIGINAL HISTORIES.                                             
      *****************************************************************         
      *                                                                         
            IF WS-RELOAD-HIST-SW = 'Y'                                  
             IF SEB-DATABASE                                            
              MOVE WS-TEMP-ARREARS-HIST      TO WS-ARREARS-HIST-CZ      
              MOVE WS-TEMP-DISCONNECT-HIST   TO WS-DISCONNECT-HIST-CZ   
              MOVE WS-TEMP-DISC-EXCEPTN-HIST TO WS-DISC-EXCEPTN-HIST-CZ 
              MOVE 0          TO WS-ARREARS-HIST-MONTHS-LS              
                                 WS-ARREARS-COUNT                       
              PERFORM 3210-PROCESS-CREDIT-HISTORY THRU 3210-EXIT        
             ELSE                                                       
              MOVE WS-TEMP-ARREARS-HIST      TO WS-ARREARS-HIST-CZ      
              MOVE +0      TO WS-ELIG-NO-MTHS                           
                              WS-DELINQ-MTH                             
                              WS-ARRS-CNT                               
              MOVE 'N'     TO WS-NOT-USE-CR-HIST-FL                     
              MOVE SPACES  TO WS-ACCT-HST                               
              COMPUTE WS-ELIG-NO-MTHS = WS-RETAIN-DEL-MTHS + 1          
              MOVE WS-RETAIN-DEL-MTHS       TO WS-DELINQ-MTH            
              MOVE WS-ARREARS-HIST-CZ       TO WS-UTILITY-ARREARS       
              MOVE WS-KR100-PREV-ARR-HIST(24:1)                         
                                            TO WS-UTIL-LAST-MTH-HST     
              MOVE WS-UTIL-HISTORY          TO WS-ACCT-HST              
             PERFORM 6565-PROCESS-CREDIT-RULE    THRU 6565-EXIT         
             END-IF                                                     
            END-IF.                                                     
      *                                                                         
            PERFORM 3250-DETERMINE-NEW-STATUS   THRU 3250-EXIT.         
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  3210-PROCESS-CREDIT-HISTORY                                            
      *****************************************************************         
       3210-PROCESS-CREDIT-HISTORY.                                     
           PERFORM VARYING WS-MONTH FROM 1 BY 1                         
                     UNTIL WS-MONTH > 6                                 
              EVALUATE TRUE                                             
                 WHEN (WS-ARREARS-HIST-CZ (WS-MONTH:1)                  
                           = WS-OVER-60-DAYS OR WS-OVER-90-DAYS)        
                    ADD 3 TO WS-ARREARS-COUNT                           
                    ADD 1 TO WS-ARREARS-HIST-MONTHS-LS                  
                 WHEN (WS-ARREARS-HIST-CZ (WS-MONTH:1)                  
                           = WS-OVER-30-DAYS)                           
                    ADD 1 TO WS-ARREARS-COUNT                           
                    ADD 1 TO WS-ARREARS-HIST-MONTHS-LS                  
                 WHEN OTHER                                             
                    IF WS-ARREARS-HIST-CZ (WS-MONTH:1)                  
                         NOT = SPACE                                    
                       ADD 1 TO WS-ARREARS-HIST-MONTHS-LS               
                    END-IF                                              
              END-EVALUATE                                              
           END-PERFORM                                                  
      *                                                                         
           PERFORM VARYING WS-MONTH FROM 7 BY 1                         
                     UNTIL WS-MONTH > WS-MAX-MONTHXX                    
              EVALUATE TRUE                                             
                 WHEN (WS-ARREARS-HIST-CZ (WS-MONTH:1)                  
                           = WS-OVER-60-DAYS OR WS-OVER-90-DAYS)        
                    ADD 3 TO WS-ARREARS-COUNT                           
                    ADD 1 TO WS-ARREARS-HIST-MONTHS-LS                  
                 WHEN (WS-ARREARS-HIST-CZ (WS-MONTH:1)                  
                           = WS-OVER-30-DAYS)                           
                    ADD 1 TO WS-ARREARS-COUNT                           
                    ADD 1 TO WS-ARREARS-HIST-MONTHS-LS                  
                 WHEN OTHER                                             
                    IF WS-ARREARS-HIST-CZ (WS-MONTH:1)                  
                         NOT = SPACE                                    
                       ADD 1 TO WS-ARREARS-HIST-MONTHS-LS               
                    END-IF                                              
              END-EVALUATE                                              
           END-PERFORM.                                                 
      *                                                                         
       3210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  3220-PROCESS-DISC-HISTORY                                              
      *****************************************************************         
       3220-PROCESS-DISC-HISTORY.                                       
           SET NO-DISCONNECT-OCCURRED TO TRUE                           
           MOVE WS-NO TO WS-NRML-HIST-IN-LAST-XX-MNTHS.                 
           MOVE WS-NO TO WS-XCPTN-HIST-IN-LAST-XX-MNTHS.                
           PERFORM VARYING WS-MONTH FROM 2 BY 1                         
                   UNTIL WS-MONTH > 7                                   
              IF WS-DISCONNECT-HIST-CZ (WS-MONTH:1)                     
                    = '2' OR '3' OR '4' OR 'R' OR 'I'                   
                 IF WS-DISCONNECT-HIST-CZ (WS-MONTH:1) = '4'            
                    SET DISCONNECT-OCCURRED TO TRUE                     
                 END-IF                                                 
              END-IF                                                    
              IF WS-DISC-EXCEPTN-HIST-CZ (WS-MONTH:1)                   
                    = '2' OR '3' OR '4' OR 'R' OR 'I'                   
                 IF WS-DISC-EXCEPTN-HIST-CZ (WS-MONTH:1) = '4'          
                    SET DISCONNECT-OCCURRED TO TRUE                     
                 END-IF                                                 
              END-IF                                                    
              IF WS-DISCONNECT-HIST-CZ (WS-MONTH:1) NOT = SPACE         
                    OR WS-DISC-EXCEPTN-HIST-CZ (WS-MONTH:1) NOT = SPACE 
                 ADD 1 TO WS-DISCONN-ENTRIES                            
              END-IF                                                    
           END-PERFORM.                                                 
           PERFORM VARYING WS-MONTH FROM 2 BY 1                         
                UNTIL WS-MONTH > WS-MAX-MONTHXX                         
              IF WS-DISCONNECT-HIST-CZ (WS-MONTH:1)                     
                    = WS-3 OR WS-4 OR WS-R OR WS-I                      
                 MOVE WS-YES TO WS-NRML-HIST-IN-LAST-XX-MNTHS           
                 COMPUTE WS-MONTH = WS-MAX-MONTHXX + 1                  
              END-IF                                                    
              IF WS-DISC-EXCEPTN-HIST-CZ (WS-MONTH:1)                   
                    = WS-3 OR WS-4 OR WS-R OR WS-I                      
                 MOVE WS-YES TO WS-XCPTN-HIST-IN-LAST-XX-MNTHS          
                 COMPUTE WS-MONTH = WS-MAX-MONTHXX + 1                  
              END-IF                                                    
ACT111        IF WS-DISCONNECT-HIST-CZ (WS-MONTH:1) NOT = SPACE OR      
ACT111           WS-DISC-EXCEPTN-HIST-CZ (WS-MONTH:1) NOT = SPACE       
ACT111           ADD 1 TO WS-DISCONN-ENTRIES                            
ACT111        END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       3220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **  3230-DECIDE-SEB-NEW-CR-GRP                               **           
      **    SEB TO DETERMINE NEW CREDIT GROUP RULES                **           
      ***************************************************************           
       3230-DECIDE-SEB-NEW-CR-GRP.                                      
      *                                                                         
           MOVE SPACES                      TO WS-OLD-CREDIT-GROUP      
                                               WS-OLD-CR-GRP-EFFECT-DT  
           EVALUATE WS-CREDIT-GROUP-AT                                  
                       ALSO TRUE                                        
      **A--->C******************************************************            
              WHEN 'A' ALSO (WS-ARREARS-COUNT <= 2                      
                       AND WS-ARREARS-HIST-MONTHS-LS >= WS-MAX-MONTHXX) 
                 IF ( WS-CODE-MEDICAL = 'A' OR WS-CODE-DPP-ACCT = 'A'   
                      OR WS-CODE-DEP-ON-HAND = 'A' )                    
                    CONTINUE                                            
                 ELSE                                                   
                   IF WS-NRML-HIST-IN-LAST-XX-MNTHS = WS-NO             
                       AND WS-XCPTN-HIST-IN-LAST-XX-MNTHS = WS-NO       
                     MOVE WS-CREDIT-GROUP-AT TO WS-OLD-CREDIT-GROUP     
                     MOVE 'C' TO WS-CREDIT-GROUP-AT                     
                     IF WS-CR-GRP-EFFECT-DT-CZ = LOW-VALUES OR SPACES   
                        NEXT SENTENCE                                   
                     ELSE                                               
                        MOVE WS-CR-GRP-EFFECT-DT-CZ TO                  
                             WS-OLD-CR-GRP-EFFECT-DT                    
                        MOVE LOW-VALUES TO WS-CR-GRP-EFFECT-DT-CZ       
                     END-IF                                             
                   END-IF                                               
                 END-IF                                                 
      **C--->A******************************************************            
              WHEN 'C' ALSO WS-ARREARS-COUNT >= 3                       
                 MOVE WS-CREDIT-GROUP-AT TO    WS-OLD-CREDIT-GROUP      
                 MOVE 'A' TO WS-CREDIT-GROUP-AT                         
                 IF WS-CR-GRP-EFFECT-DT-CZ = LOW-VALUES OR SPACES       
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE WS-CR-GRP-EFFECT-DT-CZ TO                      
                         WS-OLD-CR-GRP-EFFECT-DT                        
                    MOVE LOW-VALUES TO WS-CR-GRP-EFFECT-DT-CZ           
                 END-IF                                                 
      **N--->A/C****************************************************            
              WHEN 'N' ALSO WS-DISCONN-ENTRIES >= 12                    
                 IF WS-ARREARS-COUNT <= 2                               
                  IF ( WS-CODE-MEDICAL = 'A' OR WS-CODE-DPP-ACCT = 'A'  
                      OR WS-CODE-DEP-ON-HAND = 'A' )                    
                     MOVE WS-CREDIT-GROUP-AT TO    WS-OLD-CREDIT-GROUP  
                     MOVE 'A' TO WS-CREDIT-GROUP-AT                     
                  ELSE                                                  
                     IF WS-NRML-HIST-IN-LAST-XX-MNTHS = WS-NO           
                        AND WS-XCPTN-HIST-IN-LAST-XX-MNTHS = WS-NO      
                       MOVE WS-CREDIT-GROUP-AT TO WS-OLD-CREDIT-GROUP   
                       MOVE 'C'                TO WS-CREDIT-GROUP-AT    
                     END-IF                                             
                  END-IF                                                
                 ELSE                                                   
                    MOVE WS-CREDIT-GROUP-AT    TO WS-OLD-CREDIT-GROUP   
                    MOVE 'A'                   TO WS-CREDIT-GROUP-AT    
                 END-IF                                                 
                 IF WS-CR-GRP-EFFECT-DT-CZ = LOW-VALUES OR SPACES       
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE WS-CR-GRP-EFFECT-DT-CZ TO                      
                         WS-OLD-CR-GRP-EFFECT-DT                        
                    MOVE LOW-VALUES TO WS-CR-GRP-EFFECT-DT-CZ           
                 END-IF                                                 
           END-EVALUATE.                                                
      *                                                                         
       3230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **  3231-DECIDE-SCEG-NEW-CR-GRP                               *           
      **    SCEG TO DETERMINE NEW CREDIT GROUP RULES                *           
      ***************************************************************           
       3231-DECIDE-SCEG-NEW-CR-GRP.                                     
      *                                                                         
           EVALUATE WS-CREDIT-GROUP-AT                                  
                       ALSO TRUE                                        
      **A--->C******************************************************            
              WHEN 'A' ALSO ( ( WS-CONSEC-CNT = 0                       
                       AND WS-NON-CONSEC-CNT <= 2 )                     
                       AND ( WS-ENOUGH-CREDIT-HIST = 'Y' ) )            
                    IF ( WS-CODE-MEDICAL     = 'A' OR                   
                         WS-CODE-DPP-ACCT    = 'A' OR                   
                         WS-CODE-DEP-ON-HAND = 'A' )                    
                       CONTINUE                                         
                    ELSE                                                
                       MOVE WS-CREDIT-GROUP-AT TO WS-OLD-CREDIT-GROUP   
                       MOVE 'C'                TO WS-CREDIT-GROUP-AT    
                       IF WS-CR-GRP-EFFECT-DT-CZ = LOW-VALUES OR SPACES 
                          NEXT SENTENCE                                 
                       ELSE                                             
                          MOVE WS-CR-GRP-EFFECT-DT-CZ TO                
                               WS-OLD-CR-GRP-EFFECT-DT                  
                          MOVE LOW-VALUES    TO WS-CR-GRP-EFFECT-DT-CZ  
                       END-IF                                           
                    END-IF                                              
      **C--->A******************************************************            
              WHEN 'C' ALSO ( ( WS-CONSEC-CNT >= 1                      
                        OR      WS-NON-CONSEC-CNT > 2 )                 
                       AND    ( WS-ENOUGH-CREDIT-HIST = 'Y' ) )         
                 MOVE WS-CREDIT-GROUP-AT    TO    WS-OLD-CREDIT-GROUP   
                 MOVE 'A' TO WS-CREDIT-GROUP-AT                         
                 IF WS-CR-GRP-EFFECT-DT-CZ = LOW-VALUES OR SPACES       
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE WS-CR-GRP-EFFECT-DT-CZ TO                      
                         WS-OLD-CR-GRP-EFFECT-DT                        
                    MOVE LOW-VALUES         TO WS-CR-GRP-EFFECT-DT-CZ   
                 END-IF                                                 
RICK****B--->C******************************************************            
RICK***       WHEN 'B' ALSO ( ( WS-CONSEC-CNT = 0                               
RICK***                 AND     WS-NON-CONSEC-CNT <= 2 )                        
RICK***                 AND   ( WS-ENOUGH-CREDIT-HIST = 'Y' ) )                 
RICK***             IF ( WS-CODE-MEDICAL     = 'A' OR                           
RICK***                  WS-CODE-DPP-ACCT    = 'A' OR                           
RICK***                  WS-CODE-DEP-ON-HAND = 'A' )                            
RICK***                CONTINUE                                                 
RICK***             ELSE                                                        
RICK***                MOVE WS-CREDIT-GROUP-AT TO WS-OLD-CREDIT-GROUP           
RICK***                MOVE 'C'                TO WS-CREDIT-GROUP-AT            
RICK***             END-IF                                                      
RICK****B--->A******************************************************            
RICK***       WHEN 'B' ALSO ( ( WS-CONSEC-CNT >= 1                              
RICK***                 OR      WS-NON-CONSEC-CNT > 2 )                         
RICK***                 AND   ( WS-ENOUGH-CREDIT-HIST = 'Y' ) )                 
RICK***          MOVE WS-CREDIT-GROUP-AT TO    WS-OLD-CREDIT-GROUP              
RICK***          MOVE 'A' TO WS-CREDIT-GROUP-AT                                 
RICK****B--->N******************************************************            
RICK***       WHEN 'B' ALSO ( WS-ENOUGH-CREDIT-HIST = 'N' )                     
RICK***          MOVE WS-CREDIT-GROUP-AT TO    WS-OLD-CREDIT-GROUP              
RICK***          MOVE 'N' TO WS-CREDIT-GROUP-AT                                 
      **N--->A******************************************************            
              WHEN 'N' ALSO ( ( WS-CONSEC-CNT >= 1                      
                        OR      WS-NON-CONSEC-CNT > 2 )                 
                        AND   ( WS-ENOUGH-CREDIT-HIST = 'Y' ) )         
                 MOVE WS-CREDIT-GROUP-AT TO    WS-OLD-CREDIT-GROUP      
                 MOVE 'A' TO WS-CREDIT-GROUP-AT                         
                 IF WS-CR-GRP-EFFECT-DT-CZ = LOW-VALUES OR SPACES       
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE WS-CR-GRP-EFFECT-DT-CZ TO                      
                         WS-OLD-CR-GRP-EFFECT-DT                        
                    MOVE LOW-VALUES TO WS-CR-GRP-EFFECT-DT-CZ           
                 END-IF                                                 
      **N--->C******************************************************            
              WHEN 'N' ALSO ( ( WS-CONSEC-CNT = 0                       
                        AND     WS-NON-CONSEC-CNT <= 2 )                
                        AND   ( WS-ENOUGH-CREDIT-HIST = 'Y' ) )         
                 IF ( WS-CODE-MEDICAL     = 'A' OR                      
                      WS-CODE-DPP-ACCT    = 'A' OR                      
                      WS-CODE-DEP-ON-HAND = 'A' )                       
                    MOVE WS-CREDIT-GROUP-AT TO    WS-OLD-CREDIT-GROUP   
                    MOVE 'A' TO WS-CREDIT-GROUP-AT                      
                 ELSE                                                   
                    MOVE WS-CREDIT-GROUP-AT TO    WS-OLD-CREDIT-GROUP   
                    MOVE 'C' TO WS-CREDIT-GROUP-AT                      
                 END-IF                                                 
                 IF WS-CR-GRP-EFFECT-DT-CZ = LOW-VALUES OR SPACES       
                       NEXT SENTENCE                                    
                 ELSE                                                   
                       MOVE WS-CR-GRP-EFFECT-DT-CZ TO                   
                            WS-OLD-CR-GRP-EFFECT-DT                     
                       MOVE LOW-VALUES TO WS-CR-GRP-EFFECT-DT-CZ        
                 END-IF                                                 
           END-EVALUATE.                                                
      *                                                                         
       3231-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 3232-DECIDE-PSNC-NEW-CR-GRP                                 *           
      *     PSNC TO DETERMINE NEW CREDIT GROUP RULES                *           
      ***************************************************************           
       3232-DECIDE-PSNC-NEW-CR-GRP.                                     
           EVALUATE WS-CREDIT-GROUP-AT                                  
                       ALSO TRUE                                        
      *A--->C******************************************************             
              WHEN 'A' ALSO WS-ARRS-CNT <= 2                            
                       AND  WS-ENOUGH-CREDIT-HIST = 'Y'                 
                 IF ( WS-CODE-MEDICAL = 'A' OR WS-CODE-DPP-ACCT = 'A'   
                      OR WS-CODE-DEP-ON-HAND = 'A' )                    
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE WS-CREDIT-GROUP-AT TO WS-OLD-CREDIT-GROUP      
                    MOVE 'C'                TO WS-CREDIT-GROUP-AT       
                    IF WS-CR-GRP-EFFECT-DT-CZ = LOW-VALUES OR SPACES    
                       NEXT SENTENCE                                    
                    ELSE                                                
                       MOVE WS-CR-GRP-EFFECT-DT-CZ TO                   
                            WS-OLD-CR-GRP-EFFECT-DT                     
                       MOVE LOW-VALUES      TO WS-CR-GRP-EFFECT-DT-CZ   
                    END-IF                                              
                 END-IF                                                 
      *C--->A******************************************************             
              WHEN 'C' ALSO WS-ARRS-CNT > 2                             
                       AND  WS-ENOUGH-CREDIT-HIST = 'Y'                 
                 MOVE WS-CREDIT-GROUP-AT    TO    WS-OLD-CREDIT-GROUP   
                 MOVE 'A' TO WS-CREDIT-GROUP-AT                         
                 IF WS-CR-GRP-EFFECT-DT-CZ = LOW-VALUES OR SPACES       
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE WS-CR-GRP-EFFECT-DT-CZ TO                      
                         WS-OLD-CR-GRP-EFFECT-DT                        
                    MOVE LOW-VALUES         TO WS-CR-GRP-EFFECT-DT-CZ   
                 END-IF                                                 
      *N--->A******************************************************             
              WHEN 'N' ALSO WS-ARRS-CNT > 2                             
                        AND WS-ENOUGH-CREDIT-HIST = 'Y'                 
                 MOVE WS-CREDIT-GROUP-AT TO    WS-OLD-CREDIT-GROUP      
                 MOVE 'A' TO WS-CREDIT-GROUP-AT                         
                 IF WS-CR-GRP-EFFECT-DT-CZ = LOW-VALUES OR SPACES       
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE WS-CR-GRP-EFFECT-DT-CZ TO                      
                         WS-OLD-CR-GRP-EFFECT-DT                        
                    MOVE LOW-VALUES TO WS-CR-GRP-EFFECT-DT-CZ           
                 END-IF                                                 
      *N--->C******************************************************             
              WHEN 'N' ALSO WS-ARRS-CNT <= 2                            
                        AND WS-ENOUGH-CREDIT-HIST = 'Y'                 
                 IF ( WS-CODE-MEDICAL = 'A' OR WS-CODE-DPP-ACCT = 'A'   
                      OR WS-CODE-DEP-ON-HAND = 'A' )                    
                    MOVE WS-CREDIT-GROUP-AT TO    WS-OLD-CREDIT-GROUP   
                    MOVE 'A' TO WS-CREDIT-GROUP-AT                      
                 ELSE                                                   
                    MOVE WS-CREDIT-GROUP-AT TO    WS-OLD-CREDIT-GROUP   
                    MOVE 'C' TO WS-CREDIT-GROUP-AT                      
                 END-IF                                                 
                 IF WS-CR-GRP-EFFECT-DT-CZ = LOW-VALUES OR SPACES       
                       NEXT SENTENCE                                    
                    ELSE                                                
                       MOVE WS-CR-GRP-EFFECT-DT-CZ TO                   
                            WS-OLD-CR-GRP-EFFECT-DT                     
                       MOVE LOW-VALUES TO WS-CR-GRP-EFFECT-DT-CZ        
                 END-IF                                                 
           END-EVALUATE.                                                
      *                                                                         
       3232-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      *  3240-PROCESS-SEB-HIST                                        *         
      *  THIS PARAGRAPH IS ONLY PERFORMED IF THERE WAS A MANUAL CREDIT*         
      *  GROUP CHANGE. ONLY THE ARREARS AND DISCONNECT HISTORIES SINCE*         
      *  THE CREDIT GROUP CHANGE SHOULD BE USED.  TO DO THIS, ALL 3   *         
      *  3 HISTORIES ARE MOVED TO A TEMP AREA AND THEN ONLY THE MONTHS*         
      *  SHOULD BE CONSIDERED ARE LOADED BACK IN.  THIS WILL ALLOW THE*         
      *  NORMAL CREDIT GROUP CHANGE LOGIC TO BE EXECUTED.  AFTER THE  *         
      *  CREDIT GROUP PROCESSING IS COMPLETE, THE ORIGINAL HISTORIES  *         
      *  WILL BE MOVED BACK IN.                                       *         
      *****************************************************************         
       3240-PROCESS-SEB-HIST.                                           
           MOVE SPACES                  TO WS-TEMP-ARREARS-HIST         
                                           WS-TEMP-DISCONNECT-HIST      
                                           WS-TEMP-DISC-EXCEPTN-HIST.   
           MOVE 'Y'                     TO WS-RELOAD-HIST-SW.           
           MOVE WS-ARREARS-HIST-CZ      TO WS-TEMP-ARREARS-HIST.        
           MOVE WS-DISCONNECT-HIST-CZ   TO WS-TEMP-DISCONNECT-HIST.     
           MOVE WS-DISC-EXCEPTN-HIST-CZ TO WS-TEMP-DISC-EXCEPTN-HIST.   
           MOVE SPACES                  TO WS-ARREARS-HIST-CZ           
                                           WS-DISCONNECT-HIST-CZ        
                                           WS-DISC-EXCEPTN-HIST-CZ.     
      *                                                                         
           IF WS-MONTHS-TO-EVALUATE > 24                                
              MOVE 24 TO WS-MONTHS-TO-EVALUATE                          
           END-IF.                                                      
      *                                                                         
           MOVE WS-TEMP-ARREARS-HIST(1:WS-MONTHS-TO-EVALUATE) TO        
                  WS-ARREARS-HIST-CZ.                                   
      *                                                                         
RICK***    PERFORM VARYING WS-MONTH FROM 1 BY 1                                 
RICK***              UNTIL WS-MONTH > WS-MONTHS-TO-EVALUATE                     
RICK***       MOVE WS-TEMP-ARREARS-HIST (WS-MONTH:1) TO                         
RICK***            WS-ARREARS-HIST-CZ (WS-MONTH:1)                              
RICK***    END-PERFORM.                                                         
      *                                                                         
RICK***    PERFORM VARYING WS-MONTH FROM 24 BY -1                               
RICK***              UNTIL WS-MONTH = WS-MONTHS-TO-EVALUATE                     
RICK***       MOVE SPACES           TO WS-ARREARS-HIST-CZ (WS-MONTH:1)          
RICK***    END-PERFORM.                                                         
      *                                                                         
           MOVE WS-TEMP-DISCONNECT-HIST(1:WS-MONTHS-TO-EVALUATE) TO     
                  WS-DISCONNECT-HIST-CZ.                                
      *                                                                         
RICK***    PERFORM VARYING WS-MONTH FROM 1 BY 1                                 
RICK***              UNTIL WS-MONTH > WS-MONTHS-TO-EVALUATE                     
RICK***       MOVE WS-TEMP-DISCONNECT-HIST (WS-MONTH:1) TO                      
RICK***            WS-DISCONNECT-HIST-CZ (WS-MONTH:1)                           
RICK***    END-PERFORM.                                                         
      *                                                                         
RICK***    PERFORM VARYING WS-MONTH FROM 24 BY -1                               
RICK***              UNTIL WS-MONTH = WS-MONTHS-TO-EVALUATE                     
RICK***       MOVE SPACES          TO WS-DISCONNECT-HIST-CZ (WS-MONTH:1)        
RICK***    END-PERFORM.                                                         
      *                                                                         
           MOVE WS-TEMP-DISC-EXCEPTN-HIST(1:WS-MONTHS-TO-EVALUATE) TO   
                  WS-DISC-EXCEPTN-HIST-CZ.                              
      *                                                                         
RICK***    PERFORM VARYING WS-MONTH FROM 1 BY 1                                 
RICK***              UNTIL WS-MONTH > WS-MONTHS-TO-EVALUATE                     
RICK***       MOVE WS-TEMP-DISC-EXCEPTN-HIST (WS-MONTH:1) TO                    
RICK***            WS-DISC-EXCEPTN-HIST-CZ   (WS-MONTH:1)                       
RICK***    END-PERFORM.                                                         
      *                                                                         
RICK***    PERFORM VARYING WS-MONTH FROM 24 BY -1                               
RICK***              UNTIL WS-MONTH = WS-MONTHS-TO-EVALUATE                     
RICK***       MOVE SPACES        TO WS-DISC-EXCEPTN-HIST-CZ (WS-MONTH:1)        
RICK***    END-PERFORM.                                                         
      *                                                                         
       3240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  3245-PROCESS-CSR-HIST                                                  
      *****************************************************************         
       3245-PROCESS-CSR-HIST.                                           
           MOVE SPACES                  TO WS-TEMP-ARREARS-HIST.        
           MOVE 'Y'                     TO WS-RELOAD-HIST-SW.           
           MOVE WS-ARREARS-HIST-CZ      TO WS-TEMP-ARREARS-HIST.        
           MOVE SPACES                  TO WS-ARREARS-HIST-CZ.          
      *                                                                         
           IF WS-MONTHS-TO-EVALUATE > 24                                
              MOVE 24 TO WS-MONTHS-TO-EVALUATE                          
           END-IF.                                                      
      *                                                                         
           MOVE WS-TEMP-ARREARS-HIST(1:WS-MONTHS-TO-EVALUATE) TO        
                  WS-ARREARS-HIST-CZ.                                   
      *                                                                         
RICK***    PERFORM VARYING WS-MONTH FROM 1 BY 1                                 
RICK***              UNTIL WS-MONTH > WS-MONTHS-TO-EVALUATE                     
RICK***       MOVE WS-TEMP-ARREARS-HIST (WS-MONTH:1) TO                         
RICK***            WS-ARREARS-HIST-CZ (WS-MONTH:1)                              
RICK***    END-PERFORM.                                                         
      *                                                                         
RICK***    PERFORM VARYING WS-MONTH FROM 24 BY -1                               
RICK***              UNTIL WS-MONTH = WS-MONTHS-TO-EVALUATE                     
RICK***       MOVE SPACES           TO WS-ARREARS-HIST-CZ (WS-MONTH:1)          
RICK***    END-PERFORM.                                                         
      *                                                                         
       3245-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  3250-DETERMINE-NEW-STATUS                                              
      *****************************************************************         
       3250-DETERMINE-NEW-STATUS.                                       
           IF WS-CREDIT-GROUP-AT = 'M' OR 'S' OR 'D'                    
              MOVE +0            TO WS-ELIG-NO-MTHS                     
                                    WS-DELINQ-MTH                       
                                    WS-ARRS-CNT                         
              MOVE 'N'           TO WS-NOT-USE-CR-HIST-FL               
              MOVE SPACES        TO WS-ACCT-HST                         
              IF CSR-DATABASE                                           
                 COMPUTE WS-ELIG-NO-MTHS =  WS-RETAIN-DEL-MTHS + 1      
                 MOVE WS-RETAIN-DEL-MTHS       TO WS-DELINQ-MTH         
              ELSE                                                      
                 MOVE +13                      TO WS-ELIG-NO-MTHS       
                 MOVE +12                      TO WS-DELINQ-MTH         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EVALUATE TRUE                                                
              WHEN WS-CREDIT-GROUP-AT = 'C'                             
                 MOVE WS-GOOD      TO WS-CREDIT-STATUS-CODE-AT          
              WHEN WS-CREDIT-GROUP-AT = 'A' OR 'B'                      
                 MOVE WS-BAD       TO WS-CREDIT-STATUS-CODE-AT          
              WHEN WS-CREDIT-GROUP-AT = 'N'                             
                 MOVE WS-UNKNOWN   TO  WS-CREDIT-STATUS-CODE-AT         
              WHEN WS-CREDIT-GROUP-AT = 'M' OR 'S' OR 'D'               
                 IF WS-CREDIT-GROUP-AT = 'M' OR 'S'                     
                    MOVE WS-ARREARS-HIST-CZ     TO WS-UTILITY-ARREARS   
                    MOVE WS-KR100-PREV-ARR-HIST(24:1)                   
                                                TO WS-UTIL-LAST-MTH-HST 
                    MOVE WS-UTIL-HISTORY        TO WS-ACCT-HST          
                 ELSE                                                   
                    IF WS-CREDIT-GROUP-AT = 'D'                         
                       MOVE WS-NON-UTL-ARRER-HIST-CZ TO                 
                                         WS-NON-UTILITY-ARREARS         
                       MOVE WS-KR100-PREV-NU-ARR-HIST(24:1) TO          
                                         WS-NON-UTIL-LAST-MTH-HST       
                       MOVE WS-NON-UTIL-HISTORY      TO WS-ACCT-HST     
                    END-IF                                              
                 END-IF                                                 
                 PERFORM 6565-PROCESS-CREDIT-RULE    THRU 6565-EXIT     
                 IF WS-COMPANY-NO-AT = WS-PSNC                          
                    IF WS-ENOUGH-CREDIT-HIST = 'Y'                      
                       IF WS-ARRS-CNT <= 2                              
                          MOVE WS-GOOD TO WS-CREDIT-STATUS-CODE-AT      
                       ELSE                                             
                          MOVE WS-BAD  TO WS-CREDIT-STATUS-CODE-AT      
                       END-IF                                           
                    ELSE                                                
                       MOVE WS-UNKNOWN TO  WS-CREDIT-STATUS-CODE-AT     
                    END-IF                                              
                 ELSE                                                   
                    IF WS-ENOUGH-CREDIT-HIST = 'Y'                      
                       IF WS-CONSEC-CNT = 0 AND WS-NON-CONSEC-CNT <= 2  
                          MOVE WS-GOOD TO WS-CREDIT-STATUS-CODE-AT      
                       ELSE                                             
                          MOVE WS-BAD  TO WS-CREDIT-STATUS-CODE-AT      
                       END-IF                                           
                    ELSE                                                
                       MOVE WS-UNKNOWN TO  WS-CREDIT-STATUS-CODE-AT     
                    END-IF                                              
                 END-IF                                                 
           END-EVALUATE.                                                
      *                                                                         
      *****************************************************************         
      *  FOR ALL SECURED ACCOUNTS, IF THE CREDIT STATUS IS GOOD,      *         
      *  RELEASE THE GUARANTOR (IF ONE ON THE ACCOUNT)                *         
      *  DO NOT CHECK WS-CODE-SEC-ACCT PRIOR TO RELEASING GTOR.       *         
      *  ADDED GRAND FATHER LOGIC FOR SCEG RESIDENTIAL AND TO RELEASE *         
      *  GUARANTOR ONLY IF THERE IS NOT AN ACTIVE DEPOSIT             *         
      *****************************************************************         
           IF CSR-DATABASE AND WS-COMPANY-NO-AT = '01'                  
              AND WS-ACCOUNT-TYPE-CODE-AT = 'R'                         
              PERFORM 3255-GUARANTOR-CHECK THRU 3255-EXIT               
              IF WS-RELEASE-GUARANTOR = 'Y'                             
                 PERFORM 3350-REMOVE-SECURITY THRU 3350-EXIT            
              END-IF                                                    
           ELSE                                                         
              IF WS-CREDIT-STATUS-CODE-AT = WS-GOOD                     
                 PERFORM 3350-REMOVE-SECURITY THRU 3350-EXIT            
              END-IF                                                    
           END-IF.                                                      
           MOVE SPACES TO WS-RELEASE-GUARANTOR                          
                          WS-RECENT-DEPOSIT-SW.                         
       3250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  3255-GUARANTOR-CHECK                                         *         
      *  CHECK TO SEE IF GUARANTOR SHOULD BE RELEASED                 *         
      *  USING 12 MONTH RULE                                          *         
      *****************************************************************         
       3255-GUARANTOR-CHECK.                                            
      *                                                                         
           IF ( WS-CODE-MEDICAL     = 'A' OR                            
                WS-CODE-DPP-ACCT    = 'A' OR                            
                WS-CODE-DEP-ON-HAND = 'A' )                             
              NEXT SENTENCE                                             
           ELSE                                                         
             MOVE WS-ACCOUNT-NO-AT TO GU-ACCOUNT-NO                     
                                      RN-ACCOUNT-NO                     
             PERFORM 7155-CHECK-4-RECENT-DEP  THRU 7155-EXIT            
             IF WS-RECENT-DEPOSIT-SW = 'Y'                              
               MOVE 'Y' TO WS-RELEASE-GUARANTOR                         
             ELSE                                                       
               PERFORM 7775-CHECK-FOR-GUARANTOR THRU 7775-EXIT          
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   NEXT SENTENCE                                        
               ELSE                                                     
                   IF GU-GUAR-ESTBLSH-DT <= WS-RES-SECUR-DATE           
                      MOVE +13                      TO WS-ELIG-NO-MTHS  
                      MOVE +12                      TO WS-DELINQ-MTH    
                      PERFORM 6565-PROCESS-CREDIT-RULE  THRU 6565-EXIT  
                      IF WS-ENOUGH-CREDIT-HIST = 'Y' AND                
                         WS-CONSEC-CNT = 0 AND WS-NON-CONSEC-CNT <= 2   
                           MOVE 'Y' TO WS-RELEASE-GUARANTOR             
                      END-IF                                            
                   ELSE                                                 
                     IF WS-CREDIT-STATUS-CODE-AT = WS-GOOD              
                       MOVE 'Y' TO WS-RELEASE-GUARANTOR                 
                     END-IF                                             
                   END-IF                                               
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
       3255-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  3350-REMOVE-SECURITY.                                        *         
      *  THIS PARAGRAPH WILL PROCESS FOR EACH GUARANTOR:              *         
      *  INSTEAD OF WRITING THE 9000 RECORD TO THE PENDING XFER TABLE,*         
      *  THE PROCESSING WILL BE DONE HERE.                            *         
      *****************************************************************         
       3350-REMOVE-SECURITY.                                            
      *                                                                         
           MOVE WS-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRES-HOLD.      
           MOVE '0' TO WS-HAS-GUARANTOR-SW.                             
      *                                                                         
           MOVE WS-ACCOUNT-NO-AT TO GU-ACCOUNT-NO.                      
           PERFORM 7120-OPEN-GUARANTOR          THRU 7120-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 PERFORM 7130-FETCH-GUARANTOR    THRU 7130-EXIT         
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE GU-GUAR-STATUS-CD TO WS-HOLD-GUAR-STATUS       
                    PERFORM 8000-UPDATE-GUARANTOR   THRU 8000-EXIT      
                    PERFORM 3355-PROCESS-GUARANTOR  THRU 3355-EXIT      
                    SET WS-HAS-GUARANTOR TO TRUE                        
                 END-IF                                                 
              END-PERFORM                                               
              PERFORM 7140-CLOSE-GUARANTOR    THRU 7140-EXIT            
           END-IF.                                                      
      *                                                                         
           IF WS-HAS-GUARANTOR                                          
      *****************************************************************         
      *  WRITE THE MNT HIST FOR THE GUARANTEED ACCOUNT                          
      *****************************************************************         
             PERFORM 3360-SET-MNT-HISTORY THRU 3360-EXIT                
             MOVE WS-HOLD-GUAR-STATUS TO GU-GUAR-STATUS-CD              
             MOVE WS-TRANS-HIST-SEQ-NO-MH(WS-MH-TRN-INDX) TO            
                              WS-TRANS-HIST-SEQ-NO-MI(WS-MI-DET-INDX)   
             MOVE +1 TO WS-TRAN-APPL-NO-MI(WS-MI-DET-INDX)              
             MOVE WS-GUARANTOR-DESC   TO                                
                              WS-COLUMN-DESC-MI(WS-MI-DET-INDX)         
             MOVE GU-GUAR-STATUS-CD   TO                                
                              WS-PRV-COLUMN-TEXT-MI(WS-MI-DET-INDX)     
             MOVE +15                 TO                                
                              WS-PRV-COLUMN-LEN-MI(WS-MI-DET-INDX)      
             MOVE 'G'                 TO                                
                              WS-CHG-COLUMN-TEXT-MI(WS-MI-DET-INDX)     
             MOVE +15                 TO                                
                              WS-CHG-COLUMN-LEN-MI(WS-MI-DET-INDX)      
             MOVE SPACES              TO                                
                              WS-TABLE-ID-MI(WS-MI-DET-INDX)            
             ADD +1 TO WS-MH-TRN-INDX                                   
             ADD +1 TO WS-MI-DET-INDX                                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-CODES-DATA-PRES-HOLD TO WS-CODES-DATA-PRESENT.       
      *                                                                         
       3350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  3355-PROCESS-GUARANTOR                                                 
      *****************************************************************         
       3355-PROCESS-GUARANTOR.                                          
      *                                                                         
           MOVE GU-GUARNTR-ACCT-NO TO AT-ACCOUNT-NO.                    
           PERFORM 7900-SELECT-ACCOUNT THRU 7900-EXIT.                  
           IF WS-CODE-GUARANTOR = 'A'                                   
              PERFORM 7997-SELECT-GUARANTOR  THRU 7997-EXIT             
              IF WS-HAS-MORE-GUARANTEES = 'N'                           
                 MOVE SPACE TO WS-CODE-GUARANTOR                        
                 MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT    
                 PERFORM 7690-GET-CURR-DATE-STAMP THRU 7690-EXIT        
                 MOVE CURRENT-TIMESTAMP TO AT-LAST-UPDATE-TS            
                 PERFORM 8020-UPDATE-ACCOUNT THRU 8020-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-ACCOUNT-NO-AT TO AT-ACCOUNT-NO.                      
           MOVE WS-CUSTOMER-NO-AT TO AT-CUSTOMER-NO.                    
      *                                                                         
       3355-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  3360-SET-MNT-HISTORY                                                   
      *****************************************************************         
       3360-SET-MNT-HISTORY.                                            
      *                                                                         
           PERFORM 7690-GET-CURR-DATE-STAMP THRU 7690-EXIT.             
      *                                                                         
           MOVE CURRENT-TIMESTAMP    TO                                 
                             WS-TRANS-HIST-SEQ-NO-MH(WS-MH-TRN-INDX).   
           MOVE WS-INPUT-DATE        TO                                 
                             WS-DATE-TRANS-MH(WS-MH-TRN-INDX).          
           MOVE 'F'                  TO                                 
                             WS-CODE-TRAN-TYPE-MH(WS-MH-TRN-INDX).      
           MOVE SPACES               TO                                 
                             WS-RESP-AREA-ID-MH(WS-MH-TRN-INDX).        
           MOVE AT-ACCOUNT-NO        TO                                 
                             WS-ACCOUNT-NO-MH(WS-MH-TRN-INDX).          
           MOVE AT-CUSTOMER-NO       TO                                 
                             WS-CUSTOMER-NO-MH(WS-MH-TRN-INDX).         
           MOVE ZERO                 TO                                 
                             WS-PREMISE-NO-MH(WS-MH-TRN-INDX).          
           MOVE 'SYSTEM'             TO                                 
                             WS-USER-ID-MH(WS-MH-TRN-INDX).             
           MOVE 'SCSKR111B'          TO                                 
                             WS-APPL-PROGRAM-ID-MH(WS-MH-TRN-INDX).     
           MOVE +25                 TO                                  
                             WS-TRAN-COMMENT-LEN-MH(WS-MH-TRN-INDX).    
           MOVE WS-MAINTENANCE-DESC TO                                  
                             WS-TRAN-COMMENT-TEXT-MH(WS-MH-TRN-INDX).   
      *                                                                         
       3360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  5100-FORECAST-SEB-CR-GRP                                     *         
      *   **SEB FORECAST CREDIT GROUP RULES**                         *         
      *  LOGIC TO USE THE FORECASTED CREDIT GROUP FOR CURRENT MONTH   *         
      *  CREDIT ACTION HAS BEEN TEMPORARILY COMMENTED OUT.  IF IT     *         
      *  IS DETERMINED THAT IT IS NOT NEEDED AT A LATE DATE IT WILL   *         
      *  BE REMOVED.                                                  *         
      *****************************************************************         
       5100-FORECAST-SEB-CR-GRP.                                        
      *                                                                         
           INITIALIZE WS-FRCST-CRED-GROUPS.                             
      *                                                                         
           COMPUTE WS-TOTAL-NONUTIL-ARREARS                             
               = WS-NONUTIL-ARREARS                                     
               + WS-CONTRACT-ARREARS.                                   
           COMPUTE WS-TOTAL-ARREARS                                     
               = WS-UTILITY-ARREARS-LS                                  
               + WS-TOTAL-NONUTIL-ARREARS.                              
           IF WS-CREDIT-GROUP-AT = 'A' AND                              
              WS-REG-GROUP-CD-AT = WS-LOW-INCOME AND                    
              WS-SENIOR-FL-AT = 'Y' AND                                 
ACT159        WS-TOTAL-ARREARS > WS-SECOND-DNP-LIMIT AND                
              (WS-DAY-60-UTL-RELATED-DELINQ  > 0 OR                     
              WS-DAY-90-UTL-RELATED-DELINQ  > 0)                        
                 MOVE 'B' TO WS-FORECAST-CR-GRP                         
           ELSE                                                         
                 MOVE ' ' TO WS-FORECAST-CR-GRP                         
           END-IF.                                                      
      *                                                                         
           IF BBP-ACCOUNT                                               
              MOVE SPACES TO WS-FORECAST-CR-GRP                         
           END-IF.                                                      
      *                                                                         
      *****************************************************************         
      *  IF HISTORIES WERE MOVED OUT DUE TO CREDIT GROUP CHANGE                 
      *  RELOAD ORIGINAL HISTORIES.                                             
      *****************************************************************         
      *                                                                         
RICK***    IF WS-RELOAD-HIST-SW = 'Y'                                           
RICK***       MOVE WS-TEMP-ARREARS-HIST      TO WS-ARREARS-HIST-CZ              
RICK***    END-IF.                                                              
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 6510-MOVE-TRANS-HST-HEADER.                                   *         
      *****************************************************************         
       6510-MOVE-TRANS-HST-HEADER.                                      
      *                                                                         
           PERFORM 7690-GET-CURR-DATE-STAMP   THRU 7690-EXIT.           
           MOVE CURRENT-TIMESTAMP    TO                                 
                             WS-TRANS-HIST-SEQ-NO-MH(WS-MH-TRN-INDX).   
           MOVE WS-INPUT-DATE        TO                                 
                             WS-DATE-TRANS-MH(WS-MH-TRN-INDX).          
           MOVE 'F'                  TO                                 
                             WS-CODE-TRAN-TYPE-MH(WS-MH-TRN-INDX).      
           MOVE SPACES               TO                                 
                             WS-RESP-AREA-ID-MH(WS-MH-TRN-INDX).        
           MOVE AT-ACCOUNT-NO        TO                                 
                             WS-ACCOUNT-NO-MH(WS-MH-TRN-INDX).          
           MOVE ZERO                 TO                                 
                             WS-CUSTOMER-NO-MH(WS-MH-TRN-INDX).         
           MOVE ZERO                 TO                                 
                             WS-PREMISE-NO-MH(WS-MH-TRN-INDX).          
           MOVE 'SYSTEM'             TO                                 
                             WS-USER-ID-MH(WS-MH-TRN-INDX).             
           MOVE 'SCSKR111A'          TO                                 
                             WS-APPL-PROGRAM-ID-MH(WS-MH-TRN-INDX).     
      ***********TRANS HEADER COMMENTS *************************                
           IF SEB-DATABASE                                              
              MOVE WS-ARREARS-HIST-CZ(1:12)      TO WS-ARREARS-HIST-SEB 
              MOVE WS-DISCONNECT-HIST-CZ(1:12)   TO WS-DISCONNECT-HIST  
              MOVE WS-DISC-EXCEPTN-HIST-CZ(1:12) TO WS-DISC-EXCEPTN-HIST
              MOVE WS-CRED-GRP-MAINT-DESC-SEB    TO                     
                                WS-TRAN-COMMENT-TEXT-MH(WS-MH-TRN-INDX) 
           ELSE                                                         
              EVALUATE WS-ACCOUNT-TYPE-CODE-AT                          
                 WHEN 'C'                                               
                      MOVE WS-RETAIN-COMMER-DEP   TO WS-MAX-MONTH       
                 WHEN 'I'                                               
                      MOVE WS-RETAIN-INDUST-DEP   TO WS-MAX-MONTH       
                 WHEN OTHER                                             
                      MOVE WS-RETAIN-RESIDENT-DEP TO WS-MAX-MONTH       
              END-EVALUATE                                              
              MOVE WS-ARREARS-HIST-CZ(1:WS-MAX-MONTH)                   
                                                 TO WS-ARREARS-HIST     
              MOVE WS-CRED-GRP-MAINT-DESC        TO                     
                                WS-TRAN-COMMENT-TEXT-MH(WS-MH-TRN-INDX) 
           END-IF.                                                      
           MOVE LENGTH OF WS-TRAN-COMMENT-TEXT-MH(WS-MH-TRN-INDX) TO    
                                WS-TRAN-COMMENT-LEN-MH(WS-MH-TRN-INDX). 
      *                                                                         
       6510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  6550-MOVE-TRANS-HST-DETAILS                                   *        
      ******************************************************************        
       6550-MOVE-TRANS-HST-DETAILS.                                     
      *                                                                         
      **************FIRST TRANSACTION HISTORY DETAIL ROW**************          
      **************FOR CREDIT GROUP CHANGE****************************         
           MOVE WS-TRANS-HIST-SEQ-NO-MH(WS-MH-TRN-INDX) TO              
                                WS-TRANS-HIST-SEQ-NO-MI(WS-MI-DET-INDX).
           MOVE 1                                TO                     
                                WS-TRAN-APPL-NO-MI(WS-MI-DET-INDX).     
           MOVE WS-CRED-GROUP-DESC               TO                     
                                WS-COLUMN-DESC-MI(WS-MI-DET-INDX).      
           MOVE '33'                             TO                     
                                WS-TABLE-ID-MI(WS-MI-DET-INDX).         
           MOVE WS-OLD-CREDIT-GROUP              TO                     
                                WS-PRV-COLUMN-TEXT-MI(WS-MI-DET-INDX).  
           MOVE LENGTH OF WS-PRV-COLUMN-TEXT-MI(WS-MI-DET-INDX) TO      
                                WS-PRV-COLUMN-LEN-MI(WS-MI-DET-INDX).   
           MOVE WS-CREDIT-GROUP-AT               TO                     
                                WS-CHG-COLUMN-TEXT-MI(WS-MI-DET-INDX).  
           MOVE LENGTH OF WS-CHG-COLUMN-TEXT-MI(WS-MI-DET-INDX) TO      
                                WS-CHG-COLUMN-LEN-MI(WS-MI-DET-INDX).   
           ADD +1 TO WS-MI-DET-INDX.                                    
      **************SECOND TRANSACTION HISTORY DETAIL ROW**************         
      **************FOR CREDIT GROUP EFFECTIVE DATE CHG****************         
           IF WS-OLD-CR-GRP-EFFECT-DT > SPACES                          
              MOVE WS-TRANS-HIST-SEQ-NO-MH(WS-MH-TRN-INDX) TO           
                                WS-TRANS-HIST-SEQ-NO-MI(WS-MI-DET-INDX) 
              COMPUTE WS-TRAN-APPL-NO-MI(WS-MI-DET-INDX) =              
                  WS-TRAN-APPL-NO-MI(WS-MI-DET-INDX - 1) + 1            
              MOVE WS-EFFECT-DT-DESC             TO                     
                                WS-COLUMN-DESC-MI(WS-MI-DET-INDX)       
              MOVE SPACES                        TO                     
                                WS-TABLE-ID-MI(WS-MI-DET-INDX)          
              MOVE WS-OLD-CR-GRP-EFFECT-DT       TO                     
                                WS-PRV-COLUMN-TEXT-MI(WS-MI-DET-INDX)   
              MOVE LENGTH OF WS-PRV-COLUMN-TEXT-MI(WS-MI-DET-INDX) TO   
                                WS-PRV-COLUMN-LEN-MI(WS-MI-DET-INDX)    
              IF WS-CR-GRP-EFFECT-DT-CZ > SPACES                        
                 MOVE WS-CR-GRP-EFFECT-DT-CZ     TO                     
                                 WS-CHG-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              ELSE                                                      
                 MOVE '*DELETED*'                TO                     
                                 WS-CHG-COLUMN-TEXT-MI(WS-MI-DET-INDX)  
              END-IF                                                    
              MOVE LENGTH OF WS-CHG-COLUMN-TEXT-MI(WS-MI-DET-INDX) TO   
                                 WS-CHG-COLUMN-LEN-MI(WS-MI-DET-INDX)   
              ADD +1 TO WS-MI-DET-INDX                                  
           END-IF.                                                      
                                                                        
       6550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *6565-PROCESS-CREDIT-RULE                                        *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00334                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7005-SELECT-DELINQ-VALUE                                       *        
      ******************************************************************        
       7005-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD    = :C8-DELINQ-CD                       
                 AND COMPANY_NO   = :C8-COMPANY-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD    = :C8-DELINQ-CD                               
MFA-TR*          AND COMPANY_NO   = :C8-COMPANY-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7005                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               MOVE 'C8'                 TO WS-DB2-TABLE-ID             
               MOVE 'SELECT'             TO WS-DB2-FUNCTION             
               MOVE SQLCODE              TO WS-DB2-RETURN-CODE          
               MOVE '111'                TO WS-DB2-MODULE-ID            
               MOVE '7005'               TO WS-DB2-PARAGRAPH            
               MOVE C8-DELINQ-CD         TO WS-DB2-KEY-1                
               MOVE C8-COMPANY-NO        TO WS-DB2-KEY-2                
               MOVE 12                   TO RS-RETURN-CODE              
               PERFORM 9910-SQL-ERROR                THRU 9910-EXIT     
           END-IF.                                                      
      *                                                                         
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-OPEN-DW                                                   *        
      * OPENS THE DELINQUENCY-CSR CURSOR                               *        
      ******************************************************************        
       7010-OPEN-DW.                                                    
      *                                                                         
           EXEC SQL                                                     
              OPEN DELINQUENCY-CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'C8'                 TO WS-DB2-TABLE-ID              
              MOVE 'OPEN  '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7010'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   7012-FETCH-DW.                                           **          
      * FETCH FOR THE DELINQUENCY-CSR CURSOR                        **          
      ******************************************************************        
       7012-FETCH-DW.                                                   
      *                                                                         
           EXEC SQL                                                     
              FETCH DELINQUENCY-CSR                                     
                 INTO :C8-DELINQ-CD,                                    
                      :C8-DELINQ-VALUE,                                 
                      :C8-COMPANY-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL AND NOT-FOUND 
              MOVE 'C8'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7012'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
                                                                        
       7012-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   7014-CLOSE-DW.                                           **          
      * CLOSES THE DELINQUENCY-CSR CURSOR                           **          
      ****************************************************************          
       7014-CLOSE-DW.                                                   
      *                                                                         
           EXEC SQL                                                     
              CLOSE DELINQUENCY-CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'C8'                 TO WS-DB2-TABLE-ID              
              MOVE 'CLOSE '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7014'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
       7014-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  7060-GET-NUMBER-OF-MONTHS                                    *         
      *****************************************************************         
       7060-GET-NUMBER-OF-MONTHS.                                       
           EXEC SQL                                                     
              SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-2) <> 0) OR (LEN(
                                                             :WS-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-2), CONVERT(DATE, 
                                                             :WS-DATE-2
              ) )) - CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-1) <> 0) OR (LEN(
                                                             :WS-DATE-1
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-1), CONVERT(DATE, 
                                                             :WS-DATE-1
              ) ))
            INTO
              :WS-MONTHS-TO-EVALUATE      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-MONTHS-TO-EVALUATE =                                      
MFA-TR*          (DAYS(DATE(:WS-DATE-2)) - DAYS(DATE(:WS-DATE-1)))              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '  '                 TO WS-DB2-TABLE-ID              
              MOVE 'SET   '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7060'               TO WS-DB2-PARAGRAPH             
              MOVE WS-INPUT-DATE        TO WS-DB2-KEY-1                 
              MOVE WS-CR-GRP-EFFECT-DT-CZ TO WS-DB2-KEY-2               
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  7120-OPEN-GUARANTOR                                          *         
      *****************************************************************         
       7120-OPEN-GUARANTOR.                                             
      *                                                                         
           EXEC SQL                                                     
              OPEN GUARANTOR_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'GU'                 TO WS-DB2-TABLE-ID              
              MOVE 'OPEN  '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7120'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  7130-FETCH-GUARANTOR                                         *         
      *****************************************************************         
       7130-FETCH-GUARANTOR.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH GUARANTOR_CURSOR INTO                               
                :GU-AMOUNT-GUARANTEED,                                  
                :GU-CNT-ITEM-ID,                                        
                :GU-GUARNTR-ACCT-NO,                                    
                :GU-GUAR-STATUS-CD,                                     
                :GU-GUAR-STATUS-REASON,                                 
                :GU-LAST-UPDATE-TS,                                     
                :GU-ADDRESS-ID,                                         
                :GU-SERVICE-TYPE-CD                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                   OR NOT-FOUND                         
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 'GU'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7130'               TO WS-DB2-PARAGRAPH             
              MOVE GU-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  7140-CLOSE-GUARANTOR                                         *         
      *****************************************************************         
       7140-CLOSE-GUARANTOR.                                            
      *                                                                         
           EXEC SQL                                                     
              CLOSE GUARANTOR_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'GU'                 TO WS-DB2-TABLE-ID              
              MOVE 'CLOSE '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7140'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  7155-CHECK-4-RECENT-DEP.                                     *         
      *  THIS PARAGRAPH WILL CHECK TO SEE IF A DEPOSIT WAS REFUNDED   *         
      *  PRIOR TO BILLING                                             *         
      *****************************************************************         
       7155-CHECK-4-RECENT-DEP.                                         
      *                                                                         
           MOVE 'N' TO WS-RECENT-DEPOSIT-SW.                            
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-RECENT-DEPOSIT-SW                             
                 FROM  CSS_REFUND WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO        = :RN-ACCOUNT-NO                
                  AND DATE_REFUNDED     = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )              
                  AND USER_ID_RQSTED_BY = 'SYSTEM'                      
                  AND CHECK_ISS_REAS_CD = 'G'                           
                  AND DEPOSIT_CERT_NO   > 0                             
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-RECENT-DEPOSIT-SW                                     
MFA-TR*          FROM  CSS_REFUND                                               
MFA-TR*         WHERE ACCOUNT_NO        = :RN-ACCOUNT-NO                        
MFA-TR*           AND DATE_REFUNDED     = :WS-CURRENT-DATE                      
MFA-TR*           AND USER_ID_RQSTED_BY = 'SYSTEM'                              
MFA-TR*           AND CHECK_ISS_REAS_CD = 'G'                                   
MFA-TR*           AND DEPOSIT_CERT_NO   > 0                                     
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*         QUERYNO 7155                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                   OR NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'RN'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7155'               TO WS-DB2-PARAGRAPH             
              MOVE RN-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE WS-CURRENT-DATE      TO WS-DB2-KEY-2                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
       7155-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-GET-NUMBER-OF-MONTHS                                      *        
      ******************************************************************        
       7300-GET-NUMBER-OF-MONTHS.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT
              (CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-2) <> 0) OR (LEN(
                                                             :WS-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-2), CONVERT(DATE, 
                                                             :WS-DATE-2
              ) )) - CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-1) <> 0) OR (LEN(
                                                             :WS-DATE-1
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-1), CONVERT(DATE, 
                                                             :WS-DATE-1
              ) )))    
                       / 30
            INTO
              :WS-MONTHS-TO-EVALUATE                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-MONTHS-TO-EVALUATE =                                      
MFA-TR*            (DAYS(DATE(:WS-DATE-2)) - DAYS(DATE(:WS-DATE-1)))            
MFA-TR*                / 30                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '  '                 TO WS-DB2-TABLE-ID              
              MOVE 'SET   '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7300'               TO WS-DB2-PARAGRAPH             
              MOVE WS-INPUT-DATE        TO WS-DB2-KEY-1                 
              MOVE WS-CR-GRP-EFFECT-DT-CZ TO WS-DB2-KEY-2               
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7690-GET-CURR-DATE-STAMP                                 **         
      **      SET TIMESTAMP AND DATE                                 **         
      *****************************************************************         
       7690-GET-CURR-DATE-STAMP.                                        
      *                                                                         
           EXEC SQL                                                     
                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :CURRENT-TIMESTAMP,
              :CURRENT-DATE                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET  :CURRENT-TIMESTAMP =                                      
MFA-TR*                CURRENT TIMESTAMP                                        
MFA-TR*              ,:CURRENT-DATE      =                                      
MFA-TR*                CURRENT DATE                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE '  '                 TO WS-DB2-TABLE-ID              
              MOVE 'SET   '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7690'               TO WS-DB2-PARAGRAPH             
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
       7690-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    7770-CK-GRAND-FATHER-DEPOSIT                               *         
      *    -- THIS MODULE CHECKS TO SEE IF A PAID OR BILLED           *         
      *       SECURITY EXISTED BEFORE THE START DATE.                 *         
      *****************************************************************         
       7770-CK-GRAND-FATHER-DEPOSIT.                                    
           MOVE '7770'              TO ACTIVE-PARAGRAPH.                
      *                                                                         
           EXEC SQL                                                     
              SELECT ('Y')                                              
                INTO :WS-GRAND-FATHER-DEPOSIT                           
                FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                        
                 AND DEPOSIT_STATUS_CD IN ('A','P')                     
                 AND DATE_TRAN < IIF(TRY_CONVERT(DATE, :DO-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :DO-DATE-TRAN
              ) <> 0) OR (LEN(:DO-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :DO-DATE-TRAN
              ), CONVERT(DATE, :DO-DATE-TRAN) )                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ('Y')                                                      
MFA-TR*         INTO :WS-GRAND-FATHER-DEPOSIT                                   
MFA-TR*         FROM CSS_DEP_ON_HAND                                            
MFA-TR*        WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                                
MFA-TR*          AND DEPOSIT_STATUS_CD IN ('A','P')                             
MFA-TR*          AND DATE_TRAN < :DO-DATE-TRAN                                  
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7771                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               OR WS-ACTIVE-RETURN-CODE EQUAL -811                      
                IF WS-ACTIVE-RETURN-CODE EQUAL -811                     
                    MOVE 'Y' TO WS-GRAND-FATHER-DEPOSIT                 
                END-IF                                                  
           ELSE                                                         
              MOVE 'DO'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7771'               TO WS-DB2-PARAGRAPH             
              MOVE DO-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE DO-DATE-TRAN         TO WS-DB2-KEY-2                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
           IF WS-GRAND-FATHER-DEPOSIT = 'Y'                             
              GO TO 7770-EXIT                                           
           END-IF.                                                      
           EXEC SQL                                                     
              SELECT ('Y')                                              
                INTO :WS-GRAND-FATHER-DEPOSIT                           
                FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :SB-ACCOUNT-NO                        
                 AND CODE_STATUS IN ('A','P')                           
                 AND DATE_BOND_ISSUED < IIF(TRY_CONVERT(DATE, 
                                                   :SB-DATE-BOND-ISSUED
              ) IS NULL OR (PATINDEX('%.%', :SB-DATE-BOND-ISSUED
              ) <> 0) OR (LEN(:SB-DATE-BOND-ISSUED
              ) <> 10), CIS.CHAR2DATE(:SB-DATE-BOND-ISSUED
              ), CONVERT(DATE, :SB-DATE-BOND-ISSUED) )            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ('Y')                                                      
MFA-TR*         INTO :WS-GRAND-FATHER-DEPOSIT                                   
MFA-TR*         FROM CSS_SURETY_BOND                                            
MFA-TR*        WHERE ACCOUNT_NO = :SB-ACCOUNT-NO                                
MFA-TR*          AND CODE_STATUS IN ('A','P')                                   
MFA-TR*          AND DATE_BOND_ISSUED < :SB-DATE-BOND-ISSUED                    
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7772                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               OR WS-ACTIVE-RETURN-CODE EQUAL -811                      
                IF WS-ACTIVE-RETURN-CODE EQUAL -811                     
                    MOVE 'Y' TO WS-GRAND-FATHER-DEPOSIT                 
                END-IF                                                  
           ELSE                                                         
              MOVE 'SB'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7772'               TO WS-DB2-PARAGRAPH             
              MOVE SB-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE SB-DATE-BOND-ISSUED  TO WS-DB2-KEY-2                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
           IF WS-GRAND-FATHER-DEPOSIT = 'Y'                             
              GO TO 7770-EXIT                                           
           END-IF.                                                      
           EXEC SQL                                                     
              SELECT ('Y')                                              
                INTO :WS-GRAND-FATHER-DEPOSIT                           
                FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO = :GU-ACCOUNT-NO                        
                 AND GUAR_STATUS_CD IN ('A','P')                        
                 AND GUAR_ESTBLSH_DT < IIF(TRY_CONVERT(DATE, 
                                                    :GU-GUAR-ESTBLSH-DT
              ) IS NULL OR (PATINDEX('%.%', :GU-GUAR-ESTBLSH-DT
              ) <> 0) OR (LEN(:GU-GUAR-ESTBLSH-DT
              ) <> 10), CIS.CHAR2DATE(:GU-GUAR-ESTBLSH-DT
              ), CONVERT(DATE, :GU-GUAR-ESTBLSH-DT) )              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ('Y')                                                      
MFA-TR*         INTO :WS-GRAND-FATHER-DEPOSIT                                   
MFA-TR*         FROM CSS_GUARANTOR                                              
MFA-TR*        WHERE ACCOUNT_NO = :GU-ACCOUNT-NO                                
MFA-TR*          AND GUAR_STATUS_CD IN ('A','P')                                
MFA-TR*          AND GUAR_ESTBLSH_DT < :GU-GUAR-ESTBLSH-DT                      
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7773                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               OR WS-ACTIVE-RETURN-CODE EQUAL -811                      
                IF WS-ACTIVE-RETURN-CODE EQUAL -811                     
                    MOVE 'Y' TO WS-GRAND-FATHER-DEPOSIT                 
                END-IF                                                  
           ELSE                                                         
              MOVE 'GU'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7773'               TO WS-DB2-PARAGRAPH             
              MOVE GU-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE GU-GUAR-ESTBLSH-DT   TO WS-DB2-KEY-2                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
           IF WS-GRAND-FATHER-DEPOSIT NOT = 'Y' AND                     
              WS-ACCT-CREATE-DT-AT < WS-START-DATE-TIME-STAMP           
                MOVE 'Y' TO WS-GRAND-FATHER-DEPOSIT                     
           END-IF.                                                      
      *                                                                         
       7770-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  7775-CHECK-FOR-GUARANTOR                                    *          
      *  CHECK TO SEE IF GUARANTOR EXISTS                            *          
      ****************************************************************          
       7775-CHECK-FOR-GUARANTOR.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) GUAR_ESTBLSH_DT                                    
                INTO :GU-GUAR-ESTBLSH-DT                                
                FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO = :GU-ACCOUNT-NO                        
                 AND GUAR_STATUS_CD = 'A'                               
               ORDER BY GUAR_ESTBLSH_DT                                 
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GUAR_ESTBLSH_DT                                            
MFA-TR*         INTO :GU-GUAR-ESTBLSH-DT                                        
MFA-TR*         FROM CSS_GUARANTOR                                              
MFA-TR*        WHERE ACCOUNT_NO = :GU-ACCOUNT-NO                                
MFA-TR*          AND GUAR_STATUS_CD = 'A'                                       
MFA-TR*        ORDER BY GUAR_ESTBLSH_DT                                         
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7775                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 'GU'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7775'               TO WS-DB2-PARAGRAPH             
              MOVE GU-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
       7775-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 09327000
      *  7900-SELECT-ACCOUNT.                                         * 09328000
      *  PULL BACK THE GUARANTOR INFORMATION.                         * 09328000
      ***************************************************************** 09329000
       7900-SELECT-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                    CUSTOMER_NO,                                        
                    CODES_DATA_PRESENT                                  
                INTO                                                    
                    :AT-CUSTOMER-NO,                                    
                    :AT-CODES-DATA-PRESENT                              
                FROM CSS_ACCOUNT                                        
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              MOVE AT-CODES-DATA-PRESENT  TO  WS-CODES-DATA-PRESENT     
           ELSE                                                         
              MOVE 'AT'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '7900'               TO WS-DB2-PARAGRAPH             
              MOVE AT-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR THRU 9910-EXIT                     
           END-IF.                                                      
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  7997-SELECT-GUARANTOR.                                       *         
      *****************************************************************         
       7997-SELECT-GUARANTOR.                                           
           EXEC SQL                                                     
                SELECT 'Y'                                              
                  INTO :WS-HAS-MORE-GUARANTEES                          
                  FROM CSS_GUARANTOR                                    
                 WHERE GUARNTR_ACCT_NO = :GU-GUARNTR-ACCT-NO            
                   AND GUAR_STATUS_CD = 'A'                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN -811                                                 
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N' TO WS-HAS-MORE-GUARANTEES                     
              WHEN OTHER                                                
                 MOVE 'GU'                 TO WS-DB2-TABLE-ID           
                 MOVE 'SELECT'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '111'                TO WS-DB2-MODULE-ID          
                 MOVE '7997'               TO WS-DB2-PARAGRAPH          
                 MOVE GU-GUARNTR-ACCT-NO   TO WS-DB2-KEY-1              
                 MOVE 12                   TO RS-RETURN-CODE            
                 PERFORM 9910-SQL-ERROR THRU 9910-EXIT                  
           END-EVALUATE.                                                
       7997-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  8000-UPDATE-GUARANTOR.                                       *         
      *****************************************************************         
       8000-UPDATE-GUARANTOR.                                           
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_GUARANTOR                                       
                SET GUAR_STATUS_CD = :WS-REL-GOOD-CREDIT,               
                    GUAR_STATUS_REASON = :WS-SYSTEM,                    
                    LAST_UPDATE_TS = CIS.CURRENT$TIMESTAMP()                  
             WHERE CURRENT OF GUARANTOR_CURSOR                          
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_GUARANTOR                                               
MFA-TR*         SET GUAR_STATUS_CD = :WS-REL-GOOD-CREDIT,                       
MFA-TR*             GUAR_STATUS_REASON = :WS-SYSTEM,                            
MFA-TR*             LAST_UPDATE_TS = CURRENT TIMESTAMP                          
MFA-TR*      WHERE CURRENT OF GUARANTOR_CURSOR                                  
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'GU'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '8000'               TO WS-DB2-PARAGRAPH             
              MOVE GU-GUARNTR-ACCT-NO   TO WS-DB2-KEY-1                 
              MOVE GU-CNT-ITEM-ID       TO WS-DB2-KEY-2                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR THRU 9910-EXIT                     
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 09444000
      *  8020-UPDATE-ACCOUNT.                                         * 09445000
      *  UPDATE THE CODES DATA PRESENT FOR THE GUARANTOR.             * 09445000
      ***************************************************************** 09446000
       8020-UPDATE-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_ACCOUNT                                         
                SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT         
                   ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )             
             WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09449000
MFA-TR*      UPDATE CSS_ACCOUNT                                         09450000
MFA-TR*         SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT         09451000
MFA-TR*            ,LAST_UPDATE_TS     = :AT-LAST-UPDATE-TS             09451000
MFA-TR*      WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                          09452000
MFA-TR*    END-EXEC.                                                    09453000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'AT'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '8020'               TO WS-DB2-PARAGRAPH             
              MOVE AT-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR THRU 9910-EXIT                     
           END-IF.                                                      
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  8300-DELETE-ACCT-ATTRBT                                      *         
      *  DO A DELETE ON CSS_ACCT_ATTRIBUTE TABLE                      *         
      *****************************************************************         
       8300-DELETE-ACCT-ATTRBT.                                         
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_ACCT_ATTRIBUTE                          
                WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                   
                  AND ATTRIBUTE_DESC = 'FCST CR GP BALANCE'             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                   OR NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'YP'                 TO WS-DB2-TABLE-ID              
              MOVE 'DELETE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '8300'               TO WS-DB2-PARAGRAPH             
              MOVE YP-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR THRU 9910-EXIT                     
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  8320-DELETE-ACCT-ATTRBT                                      *         
      *  DO A INSERT ON CSS_ACCT_ATTRIBUTE TABLE                      *         
      *****************************************************************         
       8320-INSERT-ACCT-ATTRBT.                                         
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_ACCT_ATTRIBUTE                           
                 ( ACCOUNT_NO                                           
                  ,ATTRIBUTE_DESC                                       
                  ,ATTRIBUTE_VALUE_CD                                   
                  ,ATTRIBUTE_VALUE_DT                                   
                  ,ATTRIBUTE_VALUE_TX                                   
                  ,CREATED_TS                                           
                  ,STATUS_CD)                                           
               VALUES                                                   
                 ( :YP-ACCOUNT-NO                                       
                  ,:YP-ATTRIBUTE-DESC                                   
                  ,:YP-ATTRIBUTE-VALUE-CD                               
                  ,IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )                       
                  ,:YP-ATTRIBUTE-VALUE-TX                               
                  ,CIS.CHAR2TIMESTAMP(:YP-CREATED-TS)                           
                  ,:YP-STATUS-CD)                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_ATTRIBUTE                                   
MFA-TR*          ( ACCOUNT_NO                                                   
MFA-TR*           ,ATTRIBUTE_DESC                                               
MFA-TR*           ,ATTRIBUTE_VALUE_CD                                           
MFA-TR*           ,ATTRIBUTE_VALUE_DT                                           
MFA-TR*           ,ATTRIBUTE_VALUE_TX                                           
MFA-TR*           ,CREATED_TS                                                   
MFA-TR*           ,STATUS_CD)                                                   
MFA-TR*        VALUES                                                           
MFA-TR*          ( :YP-ACCOUNT-NO                                               
MFA-TR*           ,:YP-ATTRIBUTE-DESC                                           
MFA-TR*           ,:YP-ATTRIBUTE-VALUE-CD                                       
MFA-TR*           ,:YP-ATTRIBUTE-VALUE-DT                                       
MFA-TR*           ,:YP-ATTRIBUTE-VALUE-TX                                       
MFA-TR*           ,:YP-CREATED-TS                                               
MFA-TR*           ,:YP-STATUS-CD)                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'YP'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '111'                TO WS-DB2-MODULE-ID             
              MOVE '8320'               TO WS-DB2-PARAGRAPH             
              MOVE YP-ACCOUNT-NO        TO WS-DB2-KEY-1                 
              MOVE 12                   TO RS-RETURN-CODE               
              PERFORM 9910-SQL-ERROR THRU 9910-EXIT                     
           END-IF.                                                      
      *                                                                         
       8320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    9910-SQL-ERROR                                           **         
      ** STORES WQS IN CWS1000A & CALLED IN 0200-VERIFY-DW-VARIABLES.**         
      *****************************************************************         
       9910-SQL-ERROR.                                                  
           IF WS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-WQ-INDX GREATER THAN 50'                      
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RS-RETURN-CODE                                 
           ELSE                                                         
              ADD 1 TO WS-CURR-WQ-ITEM                                  
           END-IF.                                                      
      *                                                                         
           MOVE WS-DATABASE-EXCEPTION        TO                         
                WS-WQ-ITEMS-DATA-WF(WS-WQ-INDX).                        
ACT308                                                                  
ACT308     MOVE WS-PGRMNAME                  TO                         
ACT308          WS-WQ-CREATED-BY-WF (WS-WQ-INDX).                       
ACT308                                                                  
           COMPUTE WS-START-POS = WS-WQ-COMMENTS-LEN-WF(WS-WQ-INDX) + 1 
           MOVE WS-SQL-ERROR-TXT-WQ          TO                         
                WS-WQ-COMMENTS-TEXT-WF (WS-WQ-INDX)(WS-START-POS:)      
           ADD  WS-SQL-ERROR-TXT-LEN-WQ      TO                         
                WS-WQ-COMMENTS-LEN-WF(WS-WQ-INDX).                      
           ADD 1 TO WS-WQ-INDX.                                         
      *                                                                         
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
      *                                                                         
       9910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    9920-MISC-ERROR       SEND MISC ERROR TO WQ              **         
      *****************************************************************         
       9920-MISC-ERROR.                                                 
      *                                                                         
           IF WS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-WQ-INDX GREATER THAN 50'                      
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RS-RETURN-CODE                                 
           ELSE                                                         
              ADD 1 TO WS-CURR-WQ-ITEM                                  
              MOVE WS-MISCELLANEOUS-MESSAGE  TO                         
                   WS-WQ-ITEMS-DATA-WF (WS-WQ-INDX)                     
ACT308                                                                  
ACT308        MOVE WS-PGRMNAME                TO                        
ACT308             WS-WQ-CREATED-BY-WF (WS-WQ-INDX)                     
ACT308                                                                  
              MOVE  WS-WARNING               TO WS-EXCEPTION-CODE-WQ    
                                                                        
              COMPUTE WS-START-POS =                                    
                      WS-WQ-COMMENTS-LEN-WF (WS-WQ-INDX) + 1            
              MOVE WS-SUPPLEMENTAL-TXT-WQ    TO                         
                   WS-WQ-COMMENTS-TEXT-WF (WS-WQ-INDX) (WS-START-POS:)  
              ADD WS-SUPPLEMENTAL-TXT-LEN-WQ TO                         
                  WS-WQ-COMMENTS-LEN-WF (WS-WQ-INDX)                    
              ADD 1 TO WS-WQ-INDX                                       
           END-IF.                                                      
      *                                                                         
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
      *                                                                         
       9920-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9999-BAIL-OUT                                                  *        
      ******************************************************************        
       9999-BAIL-OUT.                                                   
      *                                                                         
           EXIT PROGRAM.                                                
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
