       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSKR110.                                        
       DATE-WRITTEN.   FEB 2012.                                        
      ******************************************************************00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00000501
      **                                                              **00000601
      *********           CUSTOMER SERVICE SYSTEM              *********00000701
      *********                     DB2                        *********00000801
      **                                                              **00000601
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      **   THIS PROGRAM UPDATES HISTORY DETAILS                       **00330000
      **   1. UTILITY HISTORY UPDATION.                               **        
      **         UTILITY ARREARS HISTORY                              **        
      **         NORMAL DISCONNECT HISTORY                            **        
      **         EXCEPTIONAL DISCONNECT HISTORY                       **        
      **   2. NON-UTILITY HISTORY UPDATION.                           **        
      **         NON-UTILITY ARREARS HISTORY                          **        
      **         NON-UTILITY CREDIT HISTORY                           **        
      **         NON-UTILITY CREDIT HISTORY EXCEPTION                 **        
      **   3. DFA COMPLIANCE HISTORY UPDATION.                        **        
      **   4. DPP COMPLIANCE HISTORY UPDATION.                        **        
      **   5. CONTRACT COMPLIANCE HISTORY UPDATION.                   **        
      **   6. UPDATE ACCT-ATTRIBUTE BASE ON DNP DEP EXEMPT IND.       **        
      **   7. UPDATE ACCT-ATTRIBUTE BASE ON RET CHK EXEMPT IND.       **        
      **   8. UPDATE ACCT-ATTRIBUTE BASE ON DPP DRP EXEMPT IND.       **        
      **   9. CANCEL REBILLS OUTSIDE OF THE BILL WINDOW:              **        
      **         FIND THE ORIGINAL MONTH BEING CORRECTED AND UPDATE   **        
      **         HISTORY DETAILS.                                     **        
      **  10. CANCEL REBILLS INSIDE THE BILL WINDOW:                  **        
      **         UPDATE CURRENT MONTH HISTORY DO NOT SHIFT.           **        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      SCSKR110   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   02/29/2012  GV7A828   INITIAL PROGRAM VERSION.             **        
P00599**   08/08/2012  GV7A828   SET CODE_COMPLY_HIST TO 'N' IF THERE **        
P00599**                         IS 60 OR 90 DAY ARREAR FOR DFA       **        
P00599**                         RECEIVABLE                           **        
I01687**   02/26/2014  VIJAY     DELETE 'LPCASSESSED' ATTRIBUTE       **        
ACT308**   01/13/2015  SS7F226   ADD CREATED-BY FIELD IN WF AREA      **        
      **   A04880                                                     **        
A05136**   04/07/2015  MJ13662   FIXED DPP DROP EXEMPTION LOGIC       **        
A05136**                         ACT084                               **        
ACT278**   09/20/2016  TP7R341   REMOVE UNUSED COLUMN OF CONTRACT     **        
ACT278**    A05460               TABLE                                **        
      ******************************************************************        
      **----------------- BASIC SEQUENCE STRUCTURE -------------------**        
      *************************************************************** **        
      **         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION **        
      **         1000 - 1999     INPUT PROCESSING CONTROL PATH        **        
      **         2000 - 2999     OUTPUT PROCESSING CONTROL PATH       **        
      **         3000 - 4999     BATCH PROCESSING MODULES - NOT USED  **        
      **         5000 - 5999     COMMON PROGRAM MODULES               **        
      **         6000 - 6999     COMMON SYSTEM MODULES                **        
      **         7000 - 7999     INPUT MODULES                        **        
      **         8000 - 8999     OUTPUT MODULES                       **        
      **         9000 - 9799     TERMINATION MODULES                  **        
      **         9900 - 9999     ABEND/ABORT MODULES                  **        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSKR110'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR SCSKR110 STARTS HERE'.            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08)    VALUE 'SCSKR110'. 
           05  WS-PGRMNAME               PIC X(10)    VALUE 'SCSKR110'. 
           05  WS-WARNING                PIC X(01)    VALUE 'W'.        
           05  WS-FINAL-AT               PIC X(01)    VALUE 'B'.        
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-CURR-WQ-ITEM           PIC S9(04)   COMP VALUE 0.     
           05  WS-START-POS              PIC S9(04)   COMP VALUE 0.     
           05  WS-POSITION               PIC S9(4)    COMP VALUE 0.     
           05  WS-WORK-HIST-DATA         PIC X(24)    VALUE SPACES.     
           05  WS-SAVE-CODE-DISC-OKAY    PIC 9(01)    VALUE 0.          
           05  WS-SAVE-CODE-LPC-XMT      PIC 9(01)    VALUE 0.          
           05  WS-CURRENT-COMPANY        PIC X(02)    VALUE SPACES.     
           05  WS-WORK-DISC-DATA         PIC X(24)    VALUE SPACES.     
           05  WS-DELINQ-COUNT           PIC S9(04)   COMP VALUE +0.    
           05  WS-WORK-EXCEPTION-DATA    PIC X(24)    VALUE SPACES.     
           05  WS-AMT-NONUTIL-ARREARS    PIC S9(5)V99 VALUE 0.          
           05  WS-ARREARS-LIMIT          PIC S9(5)V99 VALUE 0.          
           05  WS-CALC-NO-MTHS           PIC S9(9)    COMP VALUE 0.     
           05  WS-OVER-30-DAYS           PIC X(01)    VALUE '1'.        
           05  WS-OVER-60-DAYS           PIC X(01)    VALUE '2'.        
           05  WS-OVER-90-DAYS           PIC X(01)    VALUE '3'.        
           05  WS-START-REV-MONTH-N      PIC 9(06)    VALUE 0.          
           05  WS-START-REV-MONTH.                                      
               10 WS-START-YR-N          PIC 9(04)    VALUE 0.          
               10 WS-START-MTH-N         PIC 9(02)    VALUE 0.          
           05  WS-CURRENT-DATE           PIC X(10)    VALUE SPACES.     
           05  WS-WORK-DATE              PIC X(10)    VALUE SPACES.     
           05  WS-CURR-ACCOUNT-NO        PIC 9(13)    VALUE 0.          
           05  WS-EXEMPT-IND             PIC X(01)    VALUE SPACES.     
           05  WS-ATTRIBUTE-VALUE-TX     PIC X(22)    VALUE SPACES.     
           05  WS-ATTRIBUTE-VALUE-CD.                                   
               10  WS-ATTRIBUTE-CD-1     PIC X(01)    VALUE SPACES.     
               10  FILLER                PIC X(04)    VALUE SPACES.     
           05  WS-ATTRIBUTE-CD-R         PIC 9(01)    VALUE 0.          
           05  WS-SAVE-ATTRIBUTE-CD.                                    
               10  WS-SAVE-ATTRIBUTE-CD-1                               
                                         PIC X(01)    VALUE SPACES.     
               10  FILLER                PIC X(04)    VALUE SPACES.    
MAN008     05 WS-SAVE-ATTRIBUTE-CD-MAN008 REDEFINES
MAN008           WS-SAVE-ATTRIBUTE-CD PIC X(5).
           05  WS-SAVE-ATTRIBUTE-CD-R    PIC 9(01)    VALUE 0.          
           05  WS-REVENUE-MONTH          PIC 9(06)    VALUE 0.          
           05  WS-YYYY-MM REDEFINES WS-REVENUE-MONTH.                   
               10  WS-YYYY               PIC X(04).                     
               10  WS-MM                 PIC X(02).                     
           05  WS-LST-REV-DATE           PIC X(10).                     
           05  WS-YYYY-MM-DD-LST REDEFINES WS-LST-REV-DATE.             
               10  WS-YYYY-LST           PIC X(04).                     
               10  WS-DASH-LST1          PIC X(01).                     
               10  WS-MM-LST             PIC X(02).                     
               10  WS-DASH-LST2          PIC X(01).                     
               10  WS-DD-LST             PIC X(02).                     
           05  WS-ORIG-DATE              PIC X(10)    VALUE SPACES.     
           05  WS-YYYY-MM-DD-ORIG REDEFINES WS-ORIG-DATE.               
               10  WS-YYYY-ORIG          PIC X(04).                     
               10  WS-DASH-ORIG1         PIC X(01).                     
               10  WS-MM-ORIG            PIC X(02).                     
               10  WS-DASH-ORIG2         PIC X(01).                     
               10  WS-DD-ORIG            PIC X(02).                     
           05  WS-TIMESTAMP              PIC X(26)    VALUE SPACES.     
           05  WS-TRAN-APPL-NO           PIC S9(04)   COMP VALUE 0.     
      *                                                                         
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER                PIC S9(4)    COMP VALUE +137.  
               10  FILLER                PIC X(1)     VALUE 'N'.        
               10  FILLER                PIC X(1)     VALUE '4'.        
               10  FILLER                PIC S9(4)    COMP VALUE +29.   
               10  FILLER                PIC X(30)    VALUE             
                   'A DATABASE EXCEPTION OCCURRED'.                     
                                                                        
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  WS-MISC-CATEGORY-ID   PIC S9(4)    COMP.             
               10  FILLER                PIC X(01)    VALUE 'N'.        
               10  WS-ROUTING            PIC X(01)    VALUE '4'.        
               10  WS-MISC-MSG-LEN       PIC S9(04)   COMP VALUE +95.   
               10  WS-MISC-MSG-TEXT      PIC X(95).                     
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-ON-OFF-CYCLE-IND       PIC X(01)    VALUE SPACES.     
               88  WS-OFF-CYCLE-REBILL                VALUE 'O'.        
               88  WS-ON-CYCLE-BILL                   VALUE 'A'.        
           05  WS-MASTER-ACCOUNT-IND     PIC X(01)    VALUE SPACES.     
               88  WS-CONS-BILL-MAST                  VALUE 'M'.        
           05  WS-DELINQ-LOAD-SW         PIC X(1)     VALUE '0'.        
               88  DELINQ-NOT-LOADED                  VALUE '0'.        
               88  DELINQ-LOADED                      VALUE '1'.        
           05  WS-EXEMPT-IND-SW          PIC X(1)     VALUE 'Y'.        
               88  EXEMPT-IND-NOT-FOUND               VALUE 'N'.        
               88  EXEMPT-IND-FOUND                   VALUE 'Y'.        
           05  WS-ROW-FOUND-SW           PIC X(1)     VALUE 'Y'.        
               88  ROW-NOT-FOUND                      VALUE 'N'.        
               88  ROW-FOUND                          VALUE 'Y'.        
                                                                        
       01  WS-DELINQUENCY-VALUES-TABLE.                                 
           05  WS-DELINQ-VALUE-ENTRY-TB                                 
               OCCURS 6 TIMES                                           
               INDEXED BY DELQ-INDX.                                    
               15  WS-COMPANY-NO-TB      PIC X(02).                     
               15  WS-DELINQ-CD-TB       PIC X(20).                     
COB305         15 WS-DELINQ-VALUE-TB        PIC S9(4)V9(5) COMP-3 
COB305           VALUE 0.         
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR CODES-DATA-PRESENT                         *        
      ******************************************************************        
      *                                                                         
       COPY CWS00056.                                                           
      *                                                                         
      ******************************************************************        
      * CWS00038 JOB PARM ROUTINE CONTAINS WS-WARNING-DATA-ELEMENTS    *        
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
                                                                        
      ******************************************************************        
      * WORKING STORAGE SUPPLEMENTAL WQ TEXT                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0070B                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * THIS COPYBOOK CONTAINS THE FIELDS FOR THE COMMENT IN THE       *        
      * AR_TRANS_HIST TABLE.                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00136                                                  
           END-EXEC.                                                            
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR SCSKR110 ENDS HERE  '.            
      *                                                                         
      ******************************************************************        
      * DB2 COMMUNICATION REQUIREMENT                                  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT        - AT                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCT_ATTRIBUTE - YP                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACTATT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      * CSS_DFA_ACCT       - DA                                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_DELINQUENCY    - C8                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * Declare Cursor to get deliquency values                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE DELINQUENCY-CSR CURSOR WITH ROWSET POSITIONING FOR 
              SELECT C8.DELINQ_CD                                       
                    ,C8.DELINQ_VALUE                                    
                    ,C8.COMPANY_NO                                      
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD  IN ( 'AMT-ARREARS'                   
                                       ,'AMT-NONUTIL-ARREARS' )         
               ORDER BY C8.COMPANY_NO                                   
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01872000
MFA-TR*      DECLARE DELINQUENCY-CSR CURSOR WITH ROWSET POSITIONING FOR 01873000
MFA-TR*       SELECT C8.DELINQ_CD                                       01872000
MFA-TR*             ,C8.DELINQ_VALUE                                    01873000
MFA-TR*             ,C8.COMPANY_NO                                      01874000
MFA-TR*         FROM CSS_DELINQUENCY C8                                 01877000
MFA-TR*        WHERE C8.DELINQ_CD  IN ( 'AMT-ARREARS'                           
MFA-TR*                                ,'AMT-NONUTIL-ARREARS' )                 
MFA-TR*        ORDER BY C8.COMPANY_NO                                   01878000
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                    01880000
                                                                        
       LINKAGE SECTION.                                                 
       COPY CWS1000B.                                                   01968000
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS10008                                                  
           END-EXEC.                                                            
       01  RS-RETURN-CODE       PIC S9(04)   COMP VALUE 0.              
                                                                        
                                                                        
       PROCEDURE DIVISION USING WS-KR100-CUST-DATA                      
                                WS-ACCOUNT-AT                           
                                WS-CREDIT-PROFILE-CZ                    
                                WS-ACCT-ATTRIBUTE-YP                    
                                WS-CONTRACT-CT                          
                                WS-AR-CNTRL-AC                          
                                WS-DFA-ACCT-DA                          
                                WS-TRANS-HIST-MH                        
                                WS-TRN-HST-DET-MI                       
                                WS-WQ-ITEMS-MF                          
                                WS-CWS1000B-MAX-TBL-LIMITS              
                                RS-RETURN-CODE.                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS MAIN PROCESSING OF PROGRAM                            *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION                THRU 0100-EXIT.   
           PERFORM 2000-UPDATE-PROCESS                THRU 2000-EXIT.   
           EXIT PROGRAM.                                                
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION.                                           *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
      * Initialize WS variables                                                 
           INITIALIZE  WS-ON-OFF-CYCLE-IND                              
                       WS-MASTER-ACCOUNT-IND.                           
           MOVE SPACE                          TO WS-DPP-DRP-EXEMPT-IND.
           MOVE WS-CODES-DATA-PRESENT-AT       TO WS-CODES-DATA-PRESENT.
                                                                        
           IF DELINQ-NOT-LOADED                                         
              PERFORM 0110-LOAD-DELINQUENCY-TABLE     THRU 0110-EXIT    
              SET DELINQ-LOADED                TO TRUE                  
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0110-LOAD-DELINQUENCY-TABLE                                    *        
      ******************************************************************        
                                                                        
       0110-LOAD-DELINQUENCY-TABLE.                                     
                                                                        
           SET DELQ-INDX                       TO 1.                    
           PERFORM 7200-OPEN-DELINQUENCY-CSR           THRU 7200-EXIT.  
           PERFORM 7300-FETCH-DELINQUENCY-CSR          THRU 7300-EXIT.  
           PERFORM 0120-LOAD-DELINQ-VARIABLE           THRU 0120-EXIT   
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7400-CLOSE-DELINQUENCY-CSR          THRU 7400-EXIT.  
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0120-LOAD-DELINQ-VARIABLE.                                     *        
      ******************************************************************        
                                                                        
       0120-LOAD-DELINQ-VARIABLE.                                       
                                                                        
           ADD +1                      TO WS-DELINQ-COUNT.              
           MOVE C8-COMPANY-NO          TO WS-COMPANY-NO-TB(DELQ-INDX).  
           MOVE C8-DELINQ-CD           TO WS-DELINQ-CD-TB(DELQ-INDX).   
           MOVE C8-DELINQ-VALUE        TO WS-DELINQ-VALUE-TB(DELQ-INDX).
           SET DELQ-INDX UP BY 1                                        
           PERFORM 7300-FETCH-DELINQUENCY-CSR          THRU 7300-EXIT.  
                                                                        
       0120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0130-LOAD-DELINQ-CONSTANTS                                     *        
      ******************************************************************        
                                                                        
       0130-LOAD-DELINQ-CONSTANTS.                                      
                                                                        
           EVALUATE TRUE                                                
               WHEN WS-COMPANY-NO-TB(DELQ-INDX) = WS-COMPANY-NO-AT      
                AND WS-DELINQ-CD-TB(DELQ-INDX)  = 'AMT-ARREARS'         
                    MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO               
                         WS-ARREARS-LIMIT                               
               WHEN WS-COMPANY-NO-TB(DELQ-INDX) = WS-COMPANY-NO-AT      
                AND WS-DELINQ-CD-TB(DELQ-INDX)  = 'AMT-NONUTIL-ARREARS' 
                    MOVE WS-DELINQ-VALUE-TB(DELQ-INDX) TO               
                         WS-AMT-NONUTIL-ARREARS                         
           END-EVALUATE.                                                
           SET DELQ-INDX UP BY 1.                                       
      *                                                                         
       0130-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 0200-VERIFY-SEL-DELINQ-VAL                                     *        
      ******************************************************************        
                                                                        
       0200-VERIFY-SEL-DELINQ-VAL.                                      
                                                                        
           IF WS-ARREARS-LIMIT        > 0 AND                           
              WS-AMT-NONUTIL-ARREARS  > 0                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'DELINQ CONSTANTS NOT CORRECT' TO WS-MISC-MSG-TEXT   
              MOVE +28                         TO WS-MISC-MSG-LEN       
              MOVE +17                         TO WS-MISC-CATEGORY-ID   
              MOVE 12                          TO RS-RETURN-CODE        
              PERFORM 9920-MISC-ERROR                 THRU 9920-EXIT    
           END-IF.                                                      
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1100-PROCESS-ACCT-ATTRIBUTE                                    *        
      ******************************************************************        
       1100-PROCESS-ACCT-ATTRIBUTE.                                     
      *                                                                         
      * SET DPP DRP EXEMPT IND                                                  
           INITIALIZE WS-DPP-DRP-EXEMPT-IND                             
                      WS-DNP-DEP-EXEMPT-IND                             
                      WS-RET-CHK-EXEMPT-IND.                            
           SET EXEMPT-IND-FOUND                TO TRUE.                 
           MOVE WS-ACCOUNT-NO-AT               TO YP-ACCOUNT-NO.        
           MOVE 'AUTODNPDEPEXEMPIND'           TO YP-ATTRIBUTE-DESC.    
           PERFORM 7100-CHECK-ACCT-ATTRIBUTE          THRU 7100-EXIT.   
      *                                                                         
           IF EXEMPT-IND-FOUND                                          
               IF WS-SAVE-ATTRIBUTE-CD-1 = '0' OR SPACE                 
                   MOVE SPACES           TO WS-DNP-DEP-EXEMPT-IND       
               ELSE                                                     
                   MOVE WS-SAVE-ATTRIBUTE-CD-1 TO WS-SAVE-ATTRIBUTE-CD-R
                   SUBTRACT 1 FROM WS-SAVE-ATTRIBUTE-CD-R               
                   MOVE WS-SAVE-ATTRIBUTE-CD-R TO WS-DNP-DEP-EXEMPT-IND 
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           SET EXEMPT-IND-FOUND                TO TRUE.                 
           MOVE 'AUTORETDEPEXEMPIND'           TO YP-ATTRIBUTE-DESC.    
           PERFORM 7100-CHECK-ACCT-ATTRIBUTE          THRU 7100-EXIT.   
      *                                                                         
           IF EXEMPT-IND-FOUND                                          
               IF WS-SAVE-ATTRIBUTE-CD-1 = '0' OR SPACE                 
                   MOVE SPACES           TO WS-RET-CHK-EXEMPT-IND       
               ELSE                                                     
                   MOVE WS-SAVE-ATTRIBUTE-CD-1 TO WS-SAVE-ATTRIBUTE-CD-R
                   SUBTRACT 1 FROM WS-SAVE-ATTRIBUTE-CD-R               
                   MOVE WS-SAVE-ATTRIBUTE-CD-R TO WS-RET-CHK-EXEMPT-IND 
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 1300-PROCESS-DPP-DROP-EXEMPT       THRU 1300-EXIT.   
      *                                                                         
           EVALUATE WS-DNP-DEP-EXEMPT-IND                               
              WHEN 'X'                                                  
                   CONTINUE                                             
              WHEN SPACES                                               
                   MOVE 'AUTODNPDEPEXEMPIND'   TO  YP-ATTRIBUTE-DESC    
                   PERFORM 8300-DELETE-ACCT-ATTRIBUTE THRU 8300-EXIT    
              WHEN OTHER                                                
                   MOVE WS-DNP-DEP-EXEMPT-IND  TO WS-EXEMPT-IND         
                                                  YP-ATTRIBUTE-VALUE-CD 
                   MOVE 'AUTODNPDEPEXEMPIND'   TO YP-ATTRIBUTE-DESC     
                   PERFORM 1200-PROCESS-ALL-EXEMPTION THRU 1200-EXIT    
           END-EVALUATE.                                                
           EVALUATE WS-RET-CHK-EXEMPT-IND                               
              WHEN 'X'                                                  
                   CONTINUE                                             
              WHEN SPACES                                               
                   MOVE 'AUTORETDEPEXEMPIND'   TO  YP-ATTRIBUTE-DESC    
                   PERFORM 8300-DELETE-ACCT-ATTRIBUTE THRU 8300-EXIT    
              WHEN OTHER                                                
                   MOVE WS-RET-CHK-EXEMPT-IND  TO WS-EXEMPT-IND         
                                                  YP-ATTRIBUTE-VALUE-CD 
                   MOVE 'AUTORETDEPEXEMPIND'   TO YP-ATTRIBUTE-DESC     
                   PERFORM 1200-PROCESS-ALL-EXEMPTION THRU 1200-EXIT    
           END-EVALUATE.                                                
           EVALUATE WS-DPP-DRP-EXEMPT-IND                               
              WHEN 'L'                                                  
                   CONTINUE                                             
              WHEN SPACES                                               
                   MOVE 'AUTODPPDRPEXEMPIND'   TO  YP-ATTRIBUTE-DESC    
                   PERFORM 8300-DELETE-ACCT-ATTRIBUTE THRU 8300-EXIT    
              WHEN OTHER                                                
                   MOVE WS-DPP-DRP-EXEMPT-IND  TO WS-EXEMPT-IND         
                                                  YP-ATTRIBUTE-VALUE-CD 
                   MOVE 'AUTODPPDRPEXEMPIND'   TO YP-ATTRIBUTE-DESC     
                   PERFORM 1200-PROCESS-ALL-EXEMPTION THRU 1200-EXIT    
           END-EVALUATE.                                                
      *                                                                         
I01687     MOVE WS-ACCOUNT-NO-AT               TO YP-ACCOUNT-NO.        
I01687     MOVE 'LPCASSESSED'                  TO YP-ATTRIBUTE-DESC.    
I01687     PERFORM 8300-DELETE-ACCT-ATTRIBUTE THRU 8300-EXIT.           
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1200-PROCESS-ALL-EXEMPTION                                     *        
      ******************************************************************        
      *                                                                         
       1200-PROCESS-ALL-EXEMPTION.                                      
      *                                                                         
           MOVE SPACES TO WS-ATTRIBUTE-VALUE-TX.                        
           EVALUATE WS-EXEMPT-IND                                       
             WHEN '0'                                                   
               MOVE 'CURRENT MONTH' TO WS-ATTRIBUTE-VALUE-TX            
             WHEN '1'                                                   
               MOVE 'CURRENT MONTH +1 MONTH' TO WS-ATTRIBUTE-VALUE-TX   
             WHEN '2'                                                   
               MOVE 'CURRENT MONTH +2 MONTH' TO WS-ATTRIBUTE-VALUE-TX   
             WHEN '3'                                                   
               MOVE 'CURRENT MONTH +3 MONTH' TO WS-ATTRIBUTE-VALUE-TX   
             WHEN '4'                                                   
               MOVE 'CURRENT MONTH +4 MONTH' TO WS-ATTRIBUTE-VALUE-TX   
             WHEN '5'                                                   
               MOVE 'CURRENT MONTH +5 MONTH' TO WS-ATTRIBUTE-VALUE-TX   
             WHEN '6'                                                   
               MOVE 'CURRENT MONTH +6 MONTH' TO WS-ATTRIBUTE-VALUE-TX   
             WHEN '7'                                                   
               MOVE 'CURRENT MONTH +7 MONTH' TO WS-ATTRIBUTE-VALUE-TX   
             WHEN '8'                                                   
               MOVE 'CURRENT MONTH +8 MONTH' TO WS-ATTRIBUTE-VALUE-TX   
             WHEN '9'                                                   
               MOVE 'CURRENT MONTH +9 MONTH' TO WS-ATTRIBUTE-VALUE-TX   
           END-EVALUATE.                                                
           MOVE WS-ATTRIBUTE-VALUE-TX        TO                         
                                              YP-ATTRIBUTE-VALUE-TX-TEXT
           MOVE LENGTH OF YP-ATTRIBUTE-VALUE-TX-TEXT TO                 
                                              YP-ATTRIBUTE-VALUE-TX-LEN 
           PERFORM 8200-UPDATE-ACCT-ATTRIBUTE         THRU 8200-EXIT.   
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1300-PROCESS-DPP-DROP-EXEMPT      *                                     
      ******************************************************************        
      *                                                                         
       1300-PROCESS-DPP-DROP-EXEMPT.                                    
      *                                                                         
           SET WS-ATTR-INDX                    TO 1.                    
           SEARCH WS-ACCT-ATTR-DATA                                     
            WHEN WS-ACCOUNT-NO-YP (WS-ATTR-INDX) = WS-ACCOUNT-NO-AT AND 
                 WS-ATTRIBUTE-DESC-YP (WS-ATTR-INDX)                    
                                                = 'AUTODPPDRPEXEMPIND'  
                  IF WS-ATTRIBUTE-VALUE-CD-YP (WS-ATTR-INDX) > '0'      
                     MOVE WS-ATTRIBUTE-VALUE-CD-YP (WS-ATTR-INDX)       
                                               TO WS-ATTRIBUTE-VALUE-CD 
                     MOVE WS-ATTRIBUTE-CD-1    TO WS-ATTRIBUTE-CD-R     
                     SUBTRACT 1 FROM WS-ATTRIBUTE-CD-R                  
                     MOVE WS-ATTRIBUTE-CD-R    TO WS-DPP-DRP-EXEMPT-IND 
                  ELSE                                                  
ACT084               MOVE WS-ATTRIBUTE-VALUE-CD-YP (WS-ATTR-INDX)       
ACT084                                         TO WS-ATTRIBUTE-VALUE-CD 
ACT084               IF WS-ATTRIBUTE-CD-1      IS NOT NUMERIC           
                        MOVE WS-ATTRIBUTE-CD-1 TO WS-DPP-DRP-EXEMPT-IND 
                     ELSE                                               
                        MOVE SPACES            TO WS-DPP-DRP-EXEMPT-IND 
                     END-IF                                             
                  END-IF                                                
           END-SEARCH.                                                  
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-UPDATE-PROCESS.                                           *        
      ******************************************************************        
      *                                                                         
       2000-UPDATE-PROCESS.                                             
      *                                                                         
      * Set cycle control based on WS-CODE-OFF-CYCLE-CALC                       
           EVALUATE TRUE                                                
               WHEN WS-CODE-OFF-CYCLE-CALC = 'O'                        
                    SET WS-OFF-CYCLE-REBILL    TO TRUE                  
               WHEN WS-CODE-OFF-CYCLE-CALC = 'M'                        
                    SET WS-CONS-BILL-MAST      TO TRUE                  
               WHEN WS-CODE-OFF-CYCLE-CALC = 'A'                        
                    SET WS-ON-CYCLE-BILL       TO TRUE                  
           END-EVALUATE.                                                
                                                                        
      * Load Delinq values                                                      
           IF WS-COMPANY-NO-AT NOT EQUAL WS-CURRENT-COMPANY             
               SET DELQ-INDX                   TO 1                     
               PERFORM 0130-LOAD-DELINQ-CONSTANTS      THRU 0130-EXIT   
                            UNTIL DELQ-INDX > WS-DELINQ-COUNT           
               PERFORM 0200-VERIFY-SEL-DELINQ-VAL      THRU 0200-EXIT   
           END-IF.                                                      
           MOVE WS-COMPANY-NO-AT               TO WS-CURRENT-COMPANY.   
                                                                        
                                                                        
      * Calculate corrected month position for Off Cycle & CANCEL/REBILL        
           IF (WS-OFF-CYCLE-REBILL AND OUTSIDE-BILL-WINDOW)             
              IF (WS-OFF-CYCLE-REBILL AND OUTSIDE-BILL-WINDOW AND       
                 (WS-KR100-REVENUE-MONTH-ORIG > 0 ))                    
                 PERFORM 5000-CALC-OFFCYCLE-HIST         THRU 5000-EXIT 
              END-IF                                                    
      * Process accounts based on the below conditions                          
           ELSE                                                         
                 PERFORM 2100-PROCESS-ACCOUNT            THRU 2100-EXIT 
           END-IF.                                                      
      *                                                                         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-PROCESS-ACCOUNT.                                          *        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-ACCOUNT.                                            
      *                                                                         
      * Save the credit profile attributes before change                        
           MOVE WS-ARREARS-HIST-CZ             TO                       
                                            WS-KR100-PREV-ARR-HIST.     
           MOVE WS-DISCONNECT-HIST-CZ          TO                       
                                            WS-KR100-PREV-DISC-HIST.    
           MOVE WS-DISC-EXCEPTN-HIST-CZ        TO                       
                                            WS-KR100-PREV-DISC-EX-HIST. 
           MOVE WS-NON-UTL-ARRER-HIST-CZ       TO                       
                                            WS-KR100-PREV-NU-ARR-HIST.  
           MOVE WS-NON-UTL-CR-HST-CZ           TO                       
                                            WS-KR100-PREV-NU-CR-HIST.   
           MOVE WS-NON-UTL-CR-HST-EX-CZ        TO                       
                                            WS-KR100-PREV-NU-CR-EX-HIST.
      *                                                                         
      * Process of account attribute details                                    
           PERFORM 1100-PROCESS-ACCT-ATTRIBUTE           THRU 1100-EXIT.
      *                                                                         
      * process of Utility & Non-utility history details                        
           MOVE SPACES                         TO WS-WORK-HIST-DATA.    
           PERFORM 2200-SET-CURRENT-UTIL-HIST            THRU 2200-EXIT.
           PERFORM 2300-SET-CURRENT-NONUTIL-HIST         THRU 2300-EXIT.
      *                                                                         
           PERFORM VARYING WS-DFA-INDX FROM 1 BY 1                      
             UNTIL WS-DFA-INDX > WS-DA-MAX-ENTRY OR                     
                   WS-ACCOUNT-NO-DA (WS-DFA-INDX) = ZERO                
                SET ROW-NOT-FOUND              TO TRUE                  
                MOVE SPACES                    TO WS-WORK-HIST-DATA     
                IF WS-CODE-DFA-TYPE-DA(WS-DFA-INDX) = 'A'               
      * process of DFA history details                                          
                   PERFORM 2400-DFA                     THRU 2400-EXIT  
                ELSE                                                    
      * process of DPP history details                                          
                   PERFORM 2500-DPP                     THRU 2500-EXIT  
                END-IF                                                  
                IF (WS-CODE-DFA-STATUS-DA(WS-DFA-INDX) = 'C'            
                   AND ROW-NOT-FOUND)                                   
                   MOVE 'Y'                    TO WS-WORK-HIST-DATA(1:1)
                   MOVE WS-ACCOUNT-NO-DA (WS-DFA-INDX)                  
                                               TO DA-ACCOUNT-NO         
                   MOVE WS-DFA-ITEM-ID-DA (WS-DFA-INDX)                 
                                               TO DA-DFA-ITEM-ID        
                   MOVE WS-WORK-HIST-DATA      TO DA-CODE-COMPLY-HIST   
                   SET ROW-FOUND               TO TRUE                  
                END-IF                                                  
                IF ROW-FOUND                                            
                   PERFORM 8000-UPDATE-DFA-HIST         THRU 8000-EXIT  
                END-IF                                                  
           END-PERFORM.                                                 
      *                                                                         
      * Validate account details                                                
           PERFORM 2700-VALIDATE-ACCOUNT-DTLS          THRU 2700-EXIT.  
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-SET-CURRENT-UTIL-HIST.                                    *04110000
      ******************************************************************        
      *                                                                         
       2200-SET-CURRENT-UTIL-HIST.                                      
      *                                                                         
           INITIALIZE WS-WORK-HIST-DATA                                 
                      WS-WORK-DISC-DATA                                 
                      WS-WORK-EXCEPTION-DATA.                           
      *                                                                         
           IF WS-OFF-CYCLE-REBILL AND INSIDE-BILL-WINDOW                
              MOVE WS-ARREARS-HIST-CZ         TO WS-WORK-HIST-DATA      
              MOVE WS-DISCONNECT-HIST-CZ      TO WS-WORK-DISC-DATA      
              MOVE WS-DISC-EXCEPTN-HIST-CZ    TO WS-WORK-EXCEPTION-DATA 
           ELSE                                                         
              MOVE WS-ARREARS-HIST-CZ         TO WS-WORK-HIST-DATA(2:23)
              MOVE WS-DISCONNECT-HIST-CZ      TO WS-WORK-DISC-DATA(2:23)
              MOVE WS-DISC-EXCEPTN-HIST-CZ    TO                        
                   WS-WORK-EXCEPTION-DATA(2:23)                         
           END-IF                                                       
      *                                                                         
           PERFORM 2210-SET-UTIL-CURRENT-MONTH          THRU 2210-EXIT. 
      *                                                                         
           MOVE WS-WORK-HIST-DATA             TO WS-ARREARS-HIST-CZ.    
           MOVE '0'  TO WS-WORK-DISC-DATA(1:1)                          
                        WS-WORK-EXCEPTION-DATA(1:1).                    
           MOVE WS-WORK-DISC-DATA             TO WS-DISCONNECT-HIST-CZ. 
           MOVE WS-WORK-EXCEPTION-DATA       TO WS-DISC-EXCEPTN-HIST-CZ.
      *                                                                 04149000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04149000
      ******************************************************************        
      * 2210-SET-UTIL-CURRENT-MONTH.                                   *04202000
      ******************************************************************        
      *                                                                         
       2210-SET-UTIL-CURRENT-MONTH.                                     
      *                                                                         
           EVALUATE TRUE                                                
              WHEN WS-KR100-UTL-90-DELINQ       > WS-ARREARS-LIMIT      
                   MOVE WS-OVER-90-DAYS       TO WS-WORK-HIST-DATA (1:1)
              WHEN WS-KR100-UTL-60-DELINQ       > WS-ARREARS-LIMIT      
                   MOVE WS-OVER-60-DAYS       TO WS-WORK-HIST-DATA (1:1)
              WHEN WS-KR100-UTL-30-DELINQ       > WS-ARREARS-LIMIT      
                   MOVE WS-OVER-30-DAYS       TO WS-WORK-HIST-DATA (1:1)
              WHEN OTHER                                                
                   MOVE '0'                   TO WS-WORK-HIST-DATA (1:1)
           END-EVALUATE.                                                
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04215000
      ******************************************************************        
      * 2300-SET-CURRENT-NONUTIL-HIST.                                 *04153000
      ******************************************************************        
      *                                                                 04149000
       2300-SET-CURRENT-NONUTIL-HIST.                                   
      *                                                                 04154000
           INITIALIZE WS-WORK-HIST-DATA                                 
                      WS-WORK-DISC-DATA                                 
                      WS-WORK-EXCEPTION-DATA.                           
      *                                                                         
           IF WS-NON-UTL-CR-HST-CZ = LOW-VALUES                         
               MOVE SPACES                  TO WS-NON-UTL-CR-HST-CZ     
           END-IF                                                       
           IF WS-NON-UTL-CR-HST-EX-CZ = LOW-VALUES                      
                MOVE SPACES                 TO WS-NON-UTL-CR-HST-EX-CZ  
           END-IF.                                                      
      *                                                                         
           IF WS-OFF-CYCLE-REBILL AND INSIDE-BILL-WINDOW                
              MOVE WS-NON-UTL-ARRER-HIST-CZ TO WS-WORK-HIST-DATA        
              MOVE WS-NON-UTL-CR-HST-CZ     TO WS-WORK-DISC-DATA        
              MOVE WS-NON-UTL-CR-HST-EX-CZ  TO WS-WORK-EXCEPTION-DATA   
           ELSE                                                         
              MOVE WS-NON-UTL-ARRER-HIST-CZ TO WS-WORK-HIST-DATA(2:23)  
              MOVE WS-NON-UTL-CR-HST-CZ     TO WS-WORK-DISC-DATA(2:23)  
              MOVE WS-NON-UTL-CR-HST-EX-CZ  TO                          
                   WS-WORK-EXCEPTION-DATA(2:23)                         
           END-IF.                                                      
      *                                                                         
           PERFORM 2310-SET-NONUTL-CURRENT-MONTH       THRU 2310-EXIT.  
      *                                                                         
           MOVE WS-WORK-HIST-DATA           TO WS-NON-UTL-ARRER-HIST-CZ.
           MOVE '0'   TO WS-WORK-DISC-DATA (1:1)                        
                         WS-WORK-EXCEPTION-DATA (1:1).                  
           MOVE WS-WORK-DISC-DATA           TO WS-NON-UTL-CR-HST-CZ.    
           MOVE WS-WORK-EXCEPTION-DATA      TO WS-NON-UTL-CR-HST-EX-CZ. 
                                                                        
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2310-SET-NONUTL-CURRENT-MONTH.                                 *04216000
      ******************************************************************        
      *                                                                         
       2310-SET-NONUTL-CURRENT-MONTH.                                   
      *                                                                         
           EVALUATE TRUE                                                
              WHEN WS-KR100-NON-UTL-90-DELINQ   > WS-AMT-NONUTIL-ARREARS
                   MOVE WS-OVER-90-DAYS       TO WS-WORK-HIST-DATA (1:1)
              WHEN WS-KR100-NON-UTL-60-DELINQ   > WS-AMT-NONUTIL-ARREARS
                   MOVE WS-OVER-60-DAYS       TO WS-WORK-HIST-DATA (1:1)
              WHEN WS-KR100-NON-UTL-30-DELINQ   > WS-AMT-NONUTIL-ARREARS
                   MOVE WS-OVER-30-DAYS       TO WS-WORK-HIST-DATA (1:1)
              WHEN OTHER                                                
                   MOVE '0'                   TO WS-WORK-HIST-DATA (1:1)
           END-EVALUATE.                                                
      *                                                                         
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-DFA.                                                      *        
      ******************************************************************        
      *                                                                         
       2400-DFA.                                                        
      *                                                                         
           PERFORM 2410-SHIFT-OR-NOSHIFT                THRU 2410-EXIT. 
           PERFORM 2420-SET-CURRENT-MONTH-DFA           THRU 2420-EXIT. 
           MOVE WS-WORK-HIST-DATA             TO DA-CODE-COMPLY-HIST.   
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2410-SHIFT-OR-NOSHIFT                                          *        
      ******************************************************************        
      *                                                                         
       2410-SHIFT-OR-NOSHIFT.                                           
      *                                                                         
           IF WS-OFF-CYCLE-REBILL AND INSIDE-BILL-WINDOW                
              MOVE WS-CODE-COMPLY-HIST-DA (WS-DFA-INDX) TO              
                   WS-WORK-HIST-DATA                                    
           ELSE                                                         
              MOVE WS-CODE-COMPLY-HIST-DA (WS-DFA-INDX) TO              
                   WS-WORK-HIST-DATA (2:23)                             
           END-IF.                                                      
      *                                                                         
       2410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2420-SET-CURRENT-MONTH-DFA                                     *        
      ******************************************************************        
      *                                                                         
       2420-SET-CURRENT-MONTH-DFA.                                      
      *                                                                         
           SET WS-AR-DATA-INDX              TO 1.                       
           SEARCH WS-AR-DATA                                            
             WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) =                  
                  WS-ACCOUNT-NO-DA (WS-DFA-INDX)       AND              
                  WS-ITEM-ID-AC (WS-AR-DATA-INDX)    =                  
                  WS-DFA-ITEM-ID-DA (WS-DFA-INDX)      AND              
                  WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 90        
      * If this is the first month billing, don't update the compliance 04291000
      * history.                                                        04292000
                  IF WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) =         
                     WS-AMT-ORIG-ENTERED-DA (WS-DFA-INDX)      AND      
                     WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX) = 0 AND      
                     WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX) = 0 AND      
                     WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX) = 0          
                     CONTINUE                                           
                  ELSE                                                  
                     IF WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)    > ZERO 
P00599               OR WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)    > ZERO 
P00599               OR WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)    > ZERO 
                        MOVE 'N'            TO WS-WORK-HIST-DATA (1:1)  
                     ELSE                                               
                        IF WS-AMT-AR-DAY-00-AC(WS-AR-DATA-INDX) >= ZERO 
                          MOVE 'Y'          TO WS-WORK-HIST-DATA (1:1)  
                        END-IF                                          
                     END-IF                                             
                  END-IF                                                
                  SET ROW-FOUND                        TO TRUE          
                  MOVE WS-ACCOUNT-NO-DA (WS-DFA-INDX)  TO DA-ACCOUNT-NO 
                  MOVE WS-DFA-ITEM-ID-DA (WS-DFA-INDX) TO DA-DFA-ITEM-ID
           END-SEARCH.                                                  
      *                                                                         
       2420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500-DPP.                                                      *        
      ******************************************************************        
      *                                                                         
       2500-DPP.                                                        
      *                                                                         
           PERFORM 2410-SHIFT-OR-NOSHIFT               THRU 2410-EXIT.  
           PERFORM 2510-SET-CURRENT-MONTH-DPP          THRU 2510-EXIT.  
           MOVE WS-WORK-HIST-DATA            TO DA-CODE-COMPLY-HIST.    
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2510-SET-CURRENT-MONTH-DPP                                     *        
      ******************************************************************        
      *                                                                         
       2510-SET-CURRENT-MONTH-DPP.                                      
      *                                                                         
           SET WS-AR-DATA-INDX               TO 1                       
           SEARCH WS-AR-DATA                                            
             WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) =                  
                  WS-ACCOUNT-NO-DA (WS-DFA-INDX)      AND               
                  WS-ITEM-ID-AC (WS-AR-DATA-INDX)    =                  
                  WS-DFA-ITEM-ID-DA (WS-DFA-INDX)     AND               
                  WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 90        
      * If this is the first month billing, don't update the compliance 04254000
      * history.                                                        04255000
                  IF WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) =         
                     WS-AMT-ORIG-ENTERED-DA (WS-DFA-INDX)      AND      
                     WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX) = 0 AND      
                     WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX) = 0 AND      
                     WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX) = 0          
                     CONTINUE                                           
                  ELSE                                                  
      * Set DPP compliance                                              04267000
                     EVALUATE TRUE                                      
                        WHEN WS-DPP-DRP-EXEMPT-IND > SPACES             
                             MOVE 'E' TO WS-WORK-HIST-DATA (1:1)        
                        WHEN WS-PAST-UTIL-CHARGES-CALC <=               
                             WS-ARREARS-LIMIT                           
                             MOVE 'Y' TO WS-WORK-HIST-DATA (1:1)        
                        WHEN WS-PAST-UTIL-CHARGES-CALC >                
                             WS-ARREARS-LIMIT                           
                             MOVE 'N' TO WS-WORK-HIST-DATA (1:1)        
                     END-EVALUATE                                       
                  END-IF                                                
                  SET ROW-FOUND                        TO TRUE          
                  MOVE WS-ACCOUNT-NO-DA (WS-DFA-INDX)  TO DA-ACCOUNT-NO 
                  MOVE WS-DFA-ITEM-ID-DA (WS-DFA-INDX) TO DA-DFA-ITEM-ID
           END-SEARCH.                                                  
      *                                                                         
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2700-VALIDATE-ACCOUNT-DTLS.                                    *        
      ******************************************************************        
      *                                                                         
       2700-VALIDATE-ACCOUNT-DTLS.                                      
                                                                        
           IF ((WS-CODE-ACCT-STAT-AT = WS-FINAL-AT)   OR                
               WS-CONS-BILL-MAST AND NOT WS-ON-CYCLE-BILL)              
              CONTINUE                                                  
           ELSE                                                         
              IF WS-CODE-LPC-XMT-AT IS NUMERIC                          
                  MOVE WS-CODE-LPC-XMT-AT      TO WS-SAVE-CODE-LPC-XMT  
                  SUBTRACT 1 FROM WS-SAVE-CODE-LPC-XMT                  
                  IF WS-SAVE-CODE-LPC-XMT EQUAL ZERO                    
                     MOVE SPACE                TO WS-CODE-LPC-XMT-AT    
                  ELSE                                                  
                     MOVE WS-SAVE-CODE-LPC-XMT TO WS-CODE-LPC-XMT-AT    
                  END-IF                                                
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-CODE-DISC-OK-AT = '0' OR                               
              WS-CODE-DISC-OK-AT = 'A' OR                               
              WS-CODE-DISC-OK-AT = 'B'                                  
              MOVE SPACES                      TO WS-CODE-DISC-OK-AT    
           END-IF.                                                      
           IF WS-CODE-DISC-OK-AT NUMERIC                                
              MOVE WS-CODE-DISC-OK-AT          TO WS-SAVE-CODE-DISC-OKAY
              SUBTRACT 1 FROM WS-SAVE-CODE-DISC-OKAY                    
              MOVE WS-SAVE-CODE-DISC-OKAY      TO WS-CODE-DISC-OK-AT    
           END-IF.                                                      
           IF WS-NOTICE-EXEMPT-CD-AT = '0' OR                           
              WS-NOTICE-EXEMPT-CD-AT = 'A' OR                           
              WS-NOTICE-EXEMPT-CD-AT = 'B'                              
              MOVE SPACES                      TO WS-NOTICE-EXEMPT-CD-AT
           END-IF.                                                      
           IF WS-NOTICE-EXEMPT-CD-AT NUMERIC                            
              MOVE WS-NOTICE-EXEMPT-CD-AT      TO WS-SAVE-CODE-DISC-OKAY
              SUBTRACT 1 FROM WS-SAVE-CODE-DISC-OKAY                    
              MOVE WS-SAVE-CODE-DISC-OKAY      TO WS-NOTICE-EXEMPT-CD-AT
           END-IF.                                                      
           IF WS-IVR-EXEMPT-CD-AT = '0' OR                              
              WS-IVR-EXEMPT-CD-AT = 'A' OR                              
              WS-IVR-EXEMPT-CD-AT = 'B'                                 
              MOVE SPACES                      TO WS-IVR-EXEMPT-CD-AT   
           END-IF.                                                      
           IF WS-IVR-EXEMPT-CD-AT NUMERIC                               
              MOVE WS-IVR-EXEMPT-CD-AT         TO WS-SAVE-CODE-DISC-OKAY
              SUBTRACT 1 FROM WS-SAVE-CODE-DISC-OKAY                    
              MOVE WS-SAVE-CODE-DISC-OKAY      TO WS-IVR-EXEMPT-CD-AT   
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************07704000
      * 5000-CALC-OFFCYCLE-HIST.                                       *07708000
      * IF CANCEL-REBILL AND OUTSIDE THE BILL WINDOW, CALCULATE THE    *07705000
      * CORRECTED MONTH POSITION AND UPDATE DISCONNECT HISTORY WITH 'E'*07706000
      ******************************************************************07707000
      *                                                                         
       5000-CALC-OFFCYCLE-HIST.                                         
      *                                                                 07709000
           MOVE WS-REV-MTH-LST-NRML-AT       TO WS-REVENUE-MONTH.       
           MOVE WS-YYYY                      TO WS-YYYY-LST.            
           MOVE WS-MM                        TO WS-MM-LST.              
           MOVE WS-KR100-REVENUE-MONTH-ORIG                             
                                             TO WS-REVENUE-MONTH.       
           MOVE WS-YYYY                      TO WS-YYYY-ORIG.           
           MOVE WS-MM                        TO WS-MM-ORIG.             
           IF WS-YYYY-LST = WS-YYYY-ORIG                                
              COMPUTE WS-POSITION = (WS-REV-MTH-LST-NRML-AT -           
                      WS-KR100-REVENUE-MONTH-ORIG) + 1                  
           ELSE                                                         
              MOVE '01'                      TO WS-DD-LST               
                                                WS-DD-ORIG              
              MOVE '-'                       TO WS-DASH-LST1            
                                                WS-DASH-LST2            
                                                WS-DASH-ORIG1           
                                                WS-DASH-ORIG2           
              PERFORM 7000-GET-NO-MONTHS               THRU 7000-EXIT   
              COMPUTE WS-POSITION = WS-CALC-NO-MTHS + 1                 
           END-IF.                                                      
                                                                        
           IF WS-POSITION > 24 OR <= 0                                  
              CONTINUE                                                  
           ELSE                                                         
              IF WS-DISCONNECT-HIST-CZ (WS-POSITION:1) NOT = '0'        
                 MOVE 'E'  TO WS-DISCONNECT-HIST-CZ  (WS-POSITION:1)    
              END-IF                                                    
           END-IF.                                                      
      *                                                                 07749000
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07749000
      *                                                                         
      ******************************************************************        
      * 7000-GET-NO-MONTHS.                                            *08853000
      ******************************************************************        
      *                                                                         
       7000-GET-NO-MONTHS.                                              
      *                                                                         
           MOVE 0                            TO WS-CALC-NO-MTHS.        
           EXEC SQL                                                     
              SELECT
              12 * CIS.DECIMAL2YEAR(CIS.DIFFDATE( IIF(TRY_CONVERT(DATE, 
                                                       :WS-LST-REV-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LST-REV-DATE
              ) <> 0) OR (LEN(:WS-LST-REV-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-LST-REV-DATE
              ), CONVERT(DATE, :WS-LST-REV-DATE) ), 
              IIF(TRY_CONVERT(DATE, :WS-ORIG-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ORIG-DATE
              ) <> 0) OR (LEN(:WS-ORIG-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-ORIG-DATE
              ), CONVERT(DATE, :WS-ORIG-DATE) ) )) + 
           CIS.DECIMAL2MONTH(CIS.DIFFDATE( IIF(TRY_CONVERT(DATE, 
                                                       :WS-LST-REV-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LST-REV-DATE
              ) <> 0) OR (LEN(:WS-LST-REV-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-LST-REV-DATE
              ), CONVERT(DATE, :WS-LST-REV-DATE) ), 
              IIF(TRY_CONVERT(DATE, :WS-ORIG-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ORIG-DATE
              ) <> 0) OR (LEN(:WS-ORIG-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-ORIG-DATE
              ), CONVERT(DATE, :WS-ORIG-DATE) ) ))
            INTO
              :WS-CALC-NO-MTHS                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                     08856000
MFA-TR*       SET :WS-CALC-NO-MTHS = 12 * YEAR(DATE(:WS-LST-REV-DATE) - 08857000
MFA-TR*           DATE(:WS-ORIG-DATE)) + MONTH(DATE(:WS-LST-REV-DATE) - 08859000
MFA-TR*           DATE(:WS-ORIG-DATE))                                  08861000
MFA-TR*    END-EXEC.                                                    08862000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08883000
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'FETCH'                   TO WS-DB2-FUNCTION         
              MOVE SQLCODE                   TO WS-DB2-RETURN-CODE      
              MOVE '110'                     TO WS-DB2-MODULE-ID        
              MOVE '7000'                    TO WS-DB2-PARAGRAPH        
              MOVE WS-LST-REV-DATE           TO WS-DB2-KEY-1            
              MOVE 12                        TO RS-RETURN-CODE          
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08885100
      *************************************************************     08364000
      **  THIS CODE CHECKS THE CSS_ACCT_ATTRIBUTE TABLE TO SEE IF**     08365000
      **  THE ACCOUNT IS EXEMPT FROM DNP DEPOSIT & RETURN CHECK  **     08366000
      **  DEPOSIT                                                **     08366000
      *************************************************************     08367000
       7100-CHECK-ACCT-ATTRIBUTE.                                       
                                                                        
           EXEC SQL                                                     
             SELECT  ATTRIBUTE_VALUE_CD                                 
MAN008*        INTO  :WS-SAVE-ATTRIBUTE-CD                              
MAN008         INTO  :WS-SAVE-ATTRIBUTE-CD-MAN008
               FROM  CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                   
             WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                      
               AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08371000
MFA-TR*      SELECT  ATTRIBUTE_VALUE_CD                                 08372000
MFA-TR*        INTO  :WS-SAVE-ATTRIBUTE-CD                              08373000
MFA-TR*        FROM  CSS_ACCT_ATTRIBUTE                                 08372000
MFA-TR*      WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                      08373000
MFA-TR*        AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                      4000
MFA-TR*      WITH UR                                                    08377000
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                    08378000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   SET EXEMPT-IND-NOT-FOUND  TO TRUE                    
              WHEN OTHER                                                
                   MOVE 'YP'                 TO WS-DB2-TABLE-ID         
                   MOVE 'SELECT'             TO WS-DB2-FUNCTION         
                   MOVE SQLCODE              TO WS-DB2-RETURN-CODE      
                   MOVE '110'                TO WS-DB2-MODULE-ID        
                   MOVE '7100'               TO WS-DB2-PARAGRAPH        
                   MOVE YP-ACCOUNT-NO        TO WS-DB2-KEY-1            
                   MOVE 12                   TO RS-RETURN-CODE          
                   PERFORM 9910-SQL-ERROR              THRU 9910-EXIT   
            END-EVALUATE.                                               
                                                                        
      *                                                                 08449000
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7200-OPEN-DELINQUENCY-CSR                                      *        
      ******************************************************************        
                                                                        
       7200-OPEN-DELINQUENCY-CSR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN DELINQUENCY-CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'C8'                      TO WS-DB2-TABLE-ID         
              MOVE 'OPEN'                    TO WS-DB2-FUNCTION         
              MOVE SQLCODE                   TO WS-DB2-RETURN-CODE      
              MOVE '110'                     TO WS-DB2-MODULE-ID        
              MOVE '7200'                    TO WS-DB2-PARAGRAPH        
              MOVE 12                        TO RS-RETURN-CODE          
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-FETCH-DELINQUENCY-CSR                                     *        
      ******************************************************************        
                                                                        
       7300-FETCH-DELINQUENCY-CSR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH DELINQUENCY-CSR                                     
               INTO :C8-DELINQ-CD                                       
                   ,:C8-DELINQ-VALUE                                    
                   ,:C8-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'C8'                      TO WS-DB2-TABLE-ID         
              MOVE 'FETCH'                   TO WS-DB2-FUNCTION         
              MOVE SQLCODE                   TO WS-DB2-RETURN-CODE      
              MOVE '110'                     TO WS-DB2-MODULE-ID        
              MOVE '7300'                    TO WS-DB2-PARAGRAPH        
              MOVE 12                        TO RS-RETURN-CODE          
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-CLOSE-DELINQUENCY-CSR                                     *        
      ******************************************************************        
                                                                        
       7400-CLOSE-DELINQUENCY-CSR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE DELINQUENCY-CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'C8'                      TO WS-DB2-TABLE-ID         
              MOVE 'CLOSE'                   TO WS-DB2-FUNCTION         
              MOVE SQLCODE                   TO WS-DB2-RETURN-CODE      
              MOVE '110'                     TO WS-DB2-MODULE-ID        
              MOVE '7400'                    TO WS-DB2-PARAGRAPH        
              MOVE 12                        TO RS-RETURN-CODE          
              PERFORM 9910-SQL-ERROR                     THRU 9910-EXIT 
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15170000
      * 8000-UPDATE-DFA-HIST                                           *15180000
      ******************************************************************15190000
      *                                                                 15200000
       8000-UPDATE-DFA-HIST.                                            
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_DFA_ACCT                                       
                 SET CODE_COMPLY_HIST  = :DA-CODE-COMPLY-HIST           
                    ,LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()              
               WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = 90                             
                 AND DFA_ITEM_ID       = :DA-DFA-ITEM-ID                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_DFA_ACCT                                               
MFA-TR*          SET CODE_COMPLY_HIST  = :DA-CODE-COMPLY-HIST                   
MFA-TR*             ,LAST_UPDATE_TS    = CURRENT TIMESTAMP                      
MFA-TR*        WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = 90                                     
MFA-TR*          AND DFA_ITEM_ID       = :DA-DFA-ITEM-ID                        
MFA-TR*      QUERYNO 8000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE 12                   TO RS-RETURN-CODE          
                   PERFORM 9999-BAIL-OUT                 THRU 9999-EXIT 
              WHEN OTHER                                                
                   MOVE 'DA'                 TO WS-DB2-TABLE-ID         
                   MOVE 'UPDATE'             TO WS-DB2-FUNCTION         
                   MOVE SQLCODE              TO WS-DB2-RETURN-CODE      
                   MOVE '110'                TO WS-DB2-MODULE-ID        
                   MOVE '8000'               TO WS-DB2-PARAGRAPH        
                   MOVE DA-ACCOUNT-NO        TO WS-DB2-KEY-1            
                   MOVE DA-DFA-ITEM-ID       TO WS-DB2-KEY-2            
                   MOVE 12                   TO RS-RETURN-CODE          
                   PERFORM 9910-SQL-ERROR                THRU 9910-EXIT 
           END-EVALUATE.                                                
      *                                                                         
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15160000
      ******************************************************************15170000
      * 8200-UPDATE-ACCT-ATTRIBUTE                                     *15180000
      ******************************************************************15190000
      *                                                                 15200000
       8200-UPDATE-ACCT-ATTRIBUTE.                                      
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_ACCT_ATTRIBUTE                                 
                 SET ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD        
                    ,ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX        
               WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                
                 AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCT_ATTRIBUTE                                         
MFA-TR*          SET ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD                
MFA-TR*             ,ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX                
MFA-TR*        WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                        
MFA-TR*          AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC                    
MFA-TR*      QUERYNO 8200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'YP'                     TO WS-DB2-TABLE-ID         
               MOVE 'UPDATE'                 TO WS-DB2-FUNCTION         
               MOVE SQLCODE                  TO WS-DB2-RETURN-CODE      
               MOVE '110'                    TO WS-DB2-MODULE-ID        
               MOVE '8200'                   TO WS-DB2-PARAGRAPH        
               MOVE YP-ACCOUNT-NO            TO WS-DB2-KEY-1            
               MOVE YP-ATTRIBUTE-DESC        TO WS-DB2-KEY-2            
               MOVE 12                       TO RS-RETURN-CODE          
               PERFORM 9910-SQL-ERROR                THRU 9910-EXIT     
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15160000
      ******************************************************************15170000
      * 8300-DELETE-ACCT-ATTRIBUTE.                                    *15180000
      ******************************************************************15190000
      *                                                                 15200000
       8300-DELETE-ACCT-ATTRIBUTE.                                      
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM CSS_ACCT_ATTRIBUTE                           
                WHERE ACCOUNT_NO      = :YP-ACCOUNT-NO                  
                  AND ATTRIBUTE_DESC  = :YP-ATTRIBUTE-DESC              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_ACCT_ATTRIBUTE                                   
MFA-TR*         WHERE ACCOUNT_NO      = :YP-ACCOUNT-NO                          
MFA-TR*           AND ATTRIBUTE_DESC  = :YP-ATTRIBUTE-DESC                      
MFA-TR*       QUERYNO 8300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'YP'                      TO WS-DB2-TABLE-ID         
              MOVE 'DELETE'                  TO WS-DB2-FUNCTION         
              MOVE SQLCODE                   TO WS-DB2-RETURN-CODE      
              MOVE '110'                     TO WS-DB2-MODULE-ID        
              MOVE '8300'                    TO WS-DB2-PARAGRAPH        
              MOVE YP-ACCOUNT-NO             TO WS-DB2-KEY-1            
              MOVE YP-ATTRIBUTE-DESC         TO WS-DB2-KEY-2            
              MOVE 12                        TO RS-RETURN-CODE          
              PERFORM 9910-SQL-ERROR                THRU 9910-EXIT      
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************11440000
      * 9910-SQL-ERROR.                                                *11450000
      ******************************************************************11460000
                                                                        
       9910-SQL-ERROR.                                                  
                                                                        
           IF WS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-WQ-INDX GREATER THAN 50'                      
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 12                        TO RS-RETURN-CODE          
           ELSE                                                         
              ADD 1                          TO WS-CURR-WQ-ITEM         
           END-IF.                                                      
                                                                        
           MOVE WS-DATABASE-EXCEPTION        TO                         
                WS-WQ-ITEMS-DATA-WF(WS-WQ-INDX).                        
                                                                        
ACT308     MOVE WS-PGRMNAME                  TO                         
ACT308          WS-WQ-CREATED-BY-WF (WS-WQ-INDX).                       
ACT308                                                                  
           COMPUTE WS-START-POS = WS-WQ-COMMENTS-LEN-WF(WS-WQ-INDX) + 1 
           MOVE WS-SQL-ERROR-TXT-WQ          TO                         
                WS-WQ-COMMENTS-TEXT-WF (WS-WQ-INDX)(WS-START-POS:).     
           ADD  WS-SQL-ERROR-TXT-LEN-WQ      TO                         
                WS-WQ-COMMENTS-LEN-WF(WS-WQ-INDX).                      
                                                                        
           ADD 1                             TO WS-WQ-INDX.             
           PERFORM 9999-BAIL-OUT                       THRU 9999-EXIT.  
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************11440000
      * 9920-MISC-ERROR                                                *11450000
      ******************************************************************11460000
                                                                        
       9920-MISC-ERROR.                                                 
                                                                        
           IF WS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-WQ-INDX GREATER THAN 50'                      
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 12                        TO RS-RETURN-CODE          
           ELSE                                                         
              ADD 1                          TO WS-CURR-WQ-ITEM         
              MOVE WS-MISCELLANEOUS-MESSAGE  TO                         
                   WS-WQ-ITEMS-DATA-WF (WS-WQ-INDX)                     
                                                                        
ACT308        MOVE WS-PGRMNAME               TO                         
ACT308             WS-WQ-CREATED-BY-WF (WS-WQ-INDX)                     
ACT308                                                                  
              COMPUTE WS-START-POS =                                    
                      WS-WQ-COMMENTS-LEN-WF (WS-WQ-INDX) + 1            
              MOVE WS-SUPPLEMENTAL-TXT-WQ    TO                         
                   WS-WQ-COMMENTS-TEXT-WF (WS-WQ-INDX) (WS-START-POS:)  
              ADD WS-SUPPLEMENTAL-TXT-LEN-WQ TO                         
                  WS-WQ-COMMENTS-LEN-WF (WS-WQ-INDX)                    
              ADD 1                          TO WS-WQ-INDX              
           END-IF.                                                      
                                                                        
           PERFORM 9999-BAIL-OUT                       THRU 9999-EXIT.  
                                                                        
       9920-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************11440000
      * 9930-MISC-WARNING                                              *11450000
      ******************************************************************11460000
                                                                        
       9930-MISC-WARNING.                                               
                                                                        
           IF WS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-WQ-INDX GREATER THAN 50'                      
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 12                        TO RS-RETURN-CODE          
           ELSE                                                         
              ADD 1                          TO WS-CURR-WQ-ITEM         
              MOVE WS-MISCELLANEOUS-MESSAGE  TO                         
                   WS-WQ-ITEMS-DATA-WF (WS-WQ-INDX)                     
              MOVE  WS-WARNING               TO WS-EXCEPTION-CODE-WQ    
                                                                        
ACT308        MOVE WS-PGRMNAME               TO                         
ACT308             WS-WQ-CREATED-BY-WF (WS-WQ-INDX)                     
ACT308                                                                  
              COMPUTE WS-START-POS =                                    
                      WS-WQ-COMMENTS-LEN-WF (WS-WQ-INDX) + 1            
              MOVE WS-SUPPLEMENTAL-TXT-WQ    TO                         
                   WS-WQ-COMMENTS-TEXT-WF (WS-WQ-INDX) (WS-START-POS:)  
              ADD WS-SUPPLEMENTAL-TXT-LEN-WQ TO                         
                  WS-WQ-COMMENTS-LEN-WF (WS-WQ-INDX)                    
              ADD 1                          TO WS-WQ-INDX              
           END-IF.                                                      
                                                                        
       9930-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************11440000
      * 9999-BAIL-OUT                                                  *11720000
      ******************************************************************11460000
                                                                        
       9999-BAIL-OUT.                                                   
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
