       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   SCSCB224.                                          
       AUTHOR.       JAYANTHI SANTHAPPAN.                               
       DATE-WRITTEN. FEBRUARY 2006.                                     
                                                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **                                                             **         
      **  DATE    INITIALS             REASON                        **         
      **________  ________           ______________                  **         
      **                                                             **         
      ** 02/2006  JAYANTHI        INITIAL VERSION OF  PROGRAM FOR    **         
      **                          INSERTING COST OF GAS PORTION OF   **         
      **                          GAS AMOUNT FOR WO RECOVERY         **         
C36929** 02/2008  VP94820        -SCE&G COG CHANGES                  **         
C36929**                         -REPLACED CSS_MODEL_SQL.            **         
P00131** 05/2008  VP94820     A) PSNC STEP RATE CHANGES.             **         
P00131**          SK42147     B) CHANGES TO POPUATE CSS_COST_GAS_DET.**         
A04070** 03/2012  VIJAY          APPLY SEASON FOR PSNC COG FACTOR    **         
      *****************************************************************         
      * PROGRAM NARRATIVE                                             *         
      *       NEW PROGRAM TO GET THE COST OF GAS PERCENTAGE FOR       *         
      *  WRITE-OFF ACCOUNTS IN PSNC. BATCH VERSION IS SCSCB224        *         
      *                                                               *         
      *  THIS PROGRAM USES THE PARM VALUES SENT BY THE CALLING        *         
      *  PROGRAM TO RETRIEVE THE COST OF GAS PORTION OF THE WRITE     *         
      *  OFF AMOUNT BY EXHAUSTING THE WRITE OFF GAS AMOUNT TOWARDS    *         
      *  THE BILLS. IT THEN ARRIVES AT A PERCENTAGE OF THE COST OF    *         
      *  GAS AMOUNT TO THE TOTAL BILLED GAS AMOUNT. THIS PERCENTAGE   *         
      *  IS THEN PASSED TO THE CALLING PROGRAM                        *         
      *                                                               *         
      *****************************************************************         
                                                                        
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
       ENVIRONMENT DIVISION.                                            
                                                                        
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCB224'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-SWITCHES.                                                 
           05  PROGRAM-NAME              PIC X(08) VALUE 'SCSCB224'.    
                                                                        
       01  WS-WORK-AREA.                                                
           05  WS-CURRENT-TIMESTAMP      PIC X(26) VALUE SPACES.        
           05  WS-GAS-ALLOC-PCT          PIC S9(3)V99.                  
           05  WS-COG-DEFERRED-AM        PIC S9(9)V99.                  
           05  WS-COMMON-DATE            PIC X(10) VALUE SPACES.        
           05  WS-WO-FLAG                PIC X(01) VALUE SPACES.        
               88 WRITE-OFF                        VALUE 'N'.           
               88 SUBS-WRITE-OFF                   VALUE 'Y'.           
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME               PIC X(08) VALUE 'SCSCB224'.    
           05  WS-Y                      PIC X(01) VALUE 'Y'.           
           05  WS-N                      PIC X(01) VALUE 'N'.           
                                                                        
       COPY CWS00303.                                                           
      *****************************************************************         
      *  THIS COPYBOOK IS USED WITH THE CPD09900 INCLUDE MEMBER       *         
      *  WHICH INVOKES THE ABEND ROUTINE                              *         
      *****************************************************************         
       COPY CWS09900.                                                           
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLLDET                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLCLDT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCNSMP                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBUMCNSM                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBRTDESC                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSPLAPL                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBGASDEF                                                
           END-EXEC.                                                            
                                                                        
C36929     EXEC SQL                                                             
C36929          INCLUDE TBCSTPLN                                                
C36929     END-EXEC.                                                            
C36929                                                                  
P00131     EXEC SQL                                                             
P00131          INCLUDE TBPRCSCH                                                
P00131     END-EXEC.                                                            
P00131                                                                  
P00131     EXEC SQL                                                             
P00131          INCLUDE TBRTCRTR                                                
P00131     END-EXEC.                                                            
P00131                                                                  
P00131     EXEC SQL                                                             
P00131          INCLUDE TBCOSTGA                                                
P00131     END-EXEC.                                                            
P00131                                                                  
      **-------------------------                                               
      **- CSS_RATE_USE_SEASN RS                                                 
      **-------------------------                                               
A04070     EXEC SQL                                                             
A04070          INCLUDE TBRTUSES                                                
A04070     END-EXEC.                                                            
A04070                                                                  
    *** COPYBOOK FOR CPDCA224 WORK VARIABLES                                    
           EXEC SQL                                                             
                INCLUDE CWS00224                                                
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       COPY CWSCA224.                                                           
       COPY CWS00010.                                                           
                                                                        
       01  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.        
                                                                        
       PROCEDURE DIVISION USING CWSCA224-PARMS,                         
                                ABEND-FILE,                             
                                RS-RETURN-CODE.                         
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
P00131     INITIALIZE DCLCSS-COST-GAS-DEFER                             
P00131     INITIALIZE WS-COST-GAS-DETAILS                               
P00131     SET WS-DET-INDX TO 1                                         
      *                                                                         
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT             
      *                                                                         
           GOBACK.                                                      
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * MOVES VALUES RECEIVED FROM WO SP AND CALLS THE BILLIGN COPYBOOK*        
      * TO FETCH THE COG %                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                            TO ACTIVE-PARAGRAPH   
      *                                                                         
           MOVE WS-C224-ACCOUNT-NO               TO CF-ACCOUNT-NO       
           MOVE WS-C224-COMPANY-NO               TO CF-COMPANY-NO       
           MOVE WS-C224-PYMT-PRIORITY-LVL        TO CF-PYMT-PRIORITY-LVL
                                                                        
           PERFORM 1100-CHECK-WO-STATUS          THRU 1100-EXIT         
                                                                        
           PERFORM 2000-PROCESS-OUTPUT            THRU 2000-EXIT        
           .                                                            
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CHECK IF ACCOUNT HAS ALREADY BEEN WRITTEN OFF WHICH CASE       *        
      * THIS IS A SUBSEQUENT WRITE OFF OR IF THIS IS THE FIRST TIME    *        
      * ACCOUNT IS GETTING WRITTEN OFF                                 *        
      ******************************************************************        
      *                                                                         
       1100-CHECK-WO-STATUS.                                            
      *                                                                         
           MOVE '1100'                       TO ACTIVE-PARAGRAPH        
      *                                                                         
           MOVE 'N'                          TO WS-WO-FLAG              
           MOVE 'W'                          TO CF-COG-TRAN-TYPE-CD     
           PERFORM 7000-CHECK-FOR-WRITE-OFF  THRU 7000-EXIT             
           .                                                            
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * GETS THE CG PCT FROM COPYBOOK AND INSERTS A WO TRANSACTION     *        
      * RECORD TO TABLE CSS_DEFERRED_COG                               *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                             TO ACTIVE-PARAGRAPH  
      *                                                                         
           PERFORM 7999-SELECT-TIMESTAMP           THRU 7999-EXIT       
           EVALUATE TRUE                                                
               WHEN WRITE-OFF                                           
                    PERFORM 2100-GET-COG-PCT       THRU 2100-EXIT       
               WHEN SUBS-WRITE-OFF                                      
                    PERFORM 2200-CALC-USING-PCT    THRU 2200-EXIT       
           END-EVALUATE                                                 
C36929     IF CF-COG-DEFERRED-PCT EQUAL 0.00                            
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 7100-INSERT-DEFERRED-COG     THRU 7100-EXIT       
P00131        PERFORM 2300-MOVE-COST-GAS-DET       THRU 2300-EXIT       
P00131                VARYING WS-DET-INDX FROM 1 BY 1                   
P00131                UNTIL WS-DET-INDX > 100                           
P00131                 OR WS-ACCOUNT-NO-GB (WS-DET-INDX) = ZERO         
           END-IF                                                       
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CALL COPYBOOK CPDCA224 TO GET THE PERCENTAGE COST OF GAS FROM  *        
      * THE THERMS, COST PER THERM AND COG FACTOR                      *        
      ******************************************************************        
      *                                                                         
       2100-GET-COG-PCT.                                                
      *                                                                         
           MOVE '2100'                       TO ACTIVE-PARAGRAPH.       
      *                                                                         
C36929     IF (((WS-C224-COMPANY-NO = '01') AND                         
C36929          (WS-C224-PYMT-PRIORITY-LVL = 45)) OR                    
P00131          (WS-C224-COMPANY-NO = '26'))                            
C36929        MOVE 100                  TO WS-GAS-ALLOC-PCT             
C36929     ELSE                                                         
C36929        MOVE WS-C224-ACCOUNT-NO       TO CF-ACCOUNT-NO            
C36929        PERFORM 7300-GET-ACCOUNT-INFO THRU 7300-EXIT              
C36929        COMPUTE WS-GAS-ALLOC-PCT = 100.00 - AT-ELEC-REV-ALLOC-PCT 
C36929     END-IF                                                       
      *                                                                         
C36929     IF WS-C224-COMPANY-NO = '01' AND                             
C36929        WS-C224-PYMT-PRIORITY-LVL = 20                            
C36929        COMPUTE WS-C224-UTILITY-AMOUNT ROUNDED =                  
C36929                WS-C224-UTILITY-AMOUNT * WS-GAS-ALLOC-PCT / 100   
C36929     END-IF                                                       
      *                                                                         
           PERFORM 2110-GET-COG-PCT          THRU 2110-EXIT             
      *                                                                         
      * WHEN THE UTG AMOUNT IS LESS THAN THE BILLED AMOUNT, CALCULATE           
      * THE ADJUSTED COG AMOUNT AS COG AMOUNT/BILLED UTG. APPLY THIS            
      * PERCENTAGE AGAINST THE WO GAS AMOUNT                                    
                                                                        
P00131*    COMPUTE WS-COG-DEFERRED-AM ROUNDED =                                 
P00131*            (WS-C224-UTILITY-AMOUNT * WS-C224-COG-PERCENT) / 100         
                                                                        
           MOVE WS-C224-ACCOUNT-NO           TO CF-ACCOUNT-NO           
           MOVE WS-C224-COMPANY-NO           TO CF-COMPANY-NO           
           MOVE WS-C224-COG-PERCENT          TO CF-COG-DEFERRED-PCT     
           MOVE 'W'                          TO CF-COG-TRAN-TYPE-CD     
P00131     MOVE WS-COG-AMOUNT-TOT            TO CF-COG-DEFERRED-AM      
                                                CF-COG-BALANCE-AM       
           MOVE WS-C224-UTILITY-AMOUNT       TO CF-WO-ADJUSTED-AM       
           MOVE WS-C224-PYMT-PRIORITY-LVL    TO CF-PYMT-PRIORITY-LVL    
           MOVE WS-GAS-ALLOC-PCT             TO CF-GAS-ALLOC-PCT        
           MOVE WS-CURRENT-TIMESTAMP         TO CF-CREATED-TS           
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * CALL COPYBOOK CPDCA224 TO GET THE PERCENTAGE COST OF GAS FROM  *        
      * THE BILLING DETAILS                                            *        
      ******************************************************************        
      *                                                                         
       2110-GET-COG-PCT.                                                
      *                                                                         
           MOVE '2110'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           PERFORM 5500-PROCESS              THRU 5500-EXIT             
           .                                                            
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CALCULATE THE COG AMOUNT USING THE PERCENTAGE ALREADY IN THE   *        
      * CSS_DEFERRED_COG TABLE AND INSERT A ROW                        *        
      ******************************************************************        
      *                                                                         
       2200-CALC-USING-PCT.                                             
      *                                                                         
           MOVE '2200'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE WS-C224-ACCOUNT-NO           TO CF-ACCOUNT-NO           
           PERFORM 7200-SELECT-COG-PCT       THRU 7200-EXIT             
      *                                                                         
C36929     PERFORM 7300-GET-ACCOUNT-INFO     THRU 7300-EXIT             
C36929     COMPUTE WS-GAS-ALLOC-PCT    = 100.00 - AT-ELEC-REV-ALLOC-PCT 
      *                                                                         
C36929     IF WS-C224-COMPANY-NO = '01' AND                             
C36929        WS-C224-PYMT-PRIORITY-LVL = 20                            
C36929        COMPUTE WS-C224-UTILITY-AMOUNT ROUNDED =                  
C36929                WS-C224-UTILITY-AMOUNT * WS-GAS-ALLOC-PCT / 100   
C36929     END-IF                                                       
      *                                                                         
           COMPUTE WS-COG-DEFERRED-AM ROUNDED =                         
                (WS-C224-UTILITY-AMOUNT * CF-COG-DEFERRED-PCT) / 100    
      ***                                                                       
      *** CANNOT RECOVER MORE THAN THE BALANCE AMOUNT                           
      ***                                                                       
           COMPUTE CF-COG-BALANCE-AM ROUNDED = CF-COG-BALANCE-AM +      
                                        WS-COG-DEFERRED-AM              
                                                                        
      ***  IF ANOTHER RECEIVABLE WAS ALREADY WRITTEN OFF IN THE SAME            
      ***  TRANSACTION THEN IT IS STILL NOT A SUBSEQUENT WRITE-OFF              
                                                                        
           MOVE 'W'                          TO CF-COG-TRAN-TYPE-CD     
           MOVE WS-COG-DEFERRED-AM           TO CF-COG-DEFERRED-AM      
      **                                        CF-COG-BALANCE-AM               
           MOVE WS-C224-PYMT-PRIORITY-LVL    TO CF-PYMT-PRIORITY-LVL    
                                                                        
           MOVE WS-GAS-ALLOC-PCT             TO CF-GAS-ALLOC-PCT        
           MOVE WS-C224-UTILITY-AMOUNT       TO CF-WO-ADJUSTED-AM       
           MOVE WS-CURRENT-TIMESTAMP         TO CF-CREATED-TS           
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00131******************************************************************        
P00131* MOVE COST OF GAS DET FROM WORKING STORAGE AS INSERT IN TABLE   *        
P00131******************************************************************        
P00131 2300-MOVE-COST-GAS-DET.                                          
P00131*                                                                         
P00131     MOVE WS-ACCOUNT-NO-GB (WS-DET-INDX)  TO     GB-ACCOUNT-NO.   
P00131     MOVE WS-COMPANY-NO-GB (WS-DET-INDX)  TO     GB-COMPANY-NO.   
P00131     MOVE WS-CREATED-TS-GB (WS-DET-INDX)  TO     GB-CREATED-TS.   
P00131     MOVE WS-ENTRY-NO-GB (WS-DET-INDX)    TO     GB-ENTRY-NO.     
P00131     MOVE WS-RATE-PLAN-NO-GB (WS-DET-INDX)                        
P00131                                          TO     GB-RATE-PLAN-NO. 
P00131     MOVE WS-VERSION-NO-GB (WS-DET-INDX)  TO     GB-VERSION-NO.   
P00131     MOVE WS-BLOCK-NO-GB (WS-DET-INDX)    TO     GB-BLOCK-NO.     
P00131     MOVE WS-BILL-NO-GB (WS-DET-INDX)     TO     GB-BILL-NO.      
P00131     MOVE WS-COG-FACTOR-GB (WS-DET-INDX)  TO     GB-COG-FACTOR.   
P00131     MOVE WS-FACTOR-PRORATE-PCT-GB (WS-DET-INDX)                  
P00131                                         TO GB-FACTOR-PRORATE-PCT.
P00131     MOVE WS-RATE-PRORATE-PCT-GB (WS-DET-INDX)                    
P00131                                         TO GB-RATE-PRORATE-PCT.  
P00131     MOVE WS-BILLED-UNITS-GB (WS-DET-INDX)                        
P00131                                          TO GB-BILLED-UNITS.     
P00131     MOVE WS-ADJUSTED-COG-PCT-GB (WS-DET-INDX)                    
P00131                                          TO GB-ADJUSTED-COG-PCT. 
P00131*                                                                         
P00131     PERFORM 7400-INSERT-COST-GAS-DET     THRU 7400-INSERT-EXIT.  
P00131*                                                                         
P00131 2300-EXIT.                                                       
P00131     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CHECK IF ACCOUNT IS ALREADY IN WRITE OFF STATUS                *        
      ******************************************************************        
       7000-CHECK-FOR-WRITE-OFF.                                        
      *                                                                         
           MOVE '7000'                       TO ACTIVE-PARAGRAPH.       
      *                                                                         
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-WO-FLAG                                       
                 FROM CSS_COST_GAS_DEFER CF                             
                WHERE ACCOUNT_NO          = :CF-ACCOUNT-NO              
                  AND COMPANY_NO          = :CF-COMPANY-NO              
                  AND COG_TRAN_TYPE_CD    = :CF-COG-TRAN-TYPE-CD        
                  AND NOT EXISTS (SELECT 1                              
                                    FROM CSS_COST_GAS_DEFER CD          
                                   WHERE ACCOUNT_NO = :CF-ACCOUNT-NO    
                                     AND COG_TRAN_TYPE_CD = 'V'         
                                     AND CD.COMPANY_NO = CF.COMPANY_NO  
                                     AND CD.CREATED_TS > CF.CREATED_TS) 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND OR -811            
              CONTINUE                                                  
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7000'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_COST_GAS_DEFER'      TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE CF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * INSERT ROW IN CSS_DEFERRED_COG FOR THE COG PERCENTAGE AND COST *        
      * OF GAS AMOUNT CALCULATED IN THE COPYBOOK CPDCA224              *        
      ******************************************************************        
       7100-INSERT-DEFERRED-COG.                                        
      *                                                                         
           MOVE '7100'          TO ACTIVE-PARAGRAPH.                    
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_COST_GAS_DEFER                           
                      (ACCOUNT_NO                                       
                      ,CREATED_TS                                       
                      ,COMPANY_NO                                       
                      ,COG_TRAN_TYPE_CD                                 
                      ,PYMT_PRIORITY_LVL                                
                      ,WO_ADJUSTED_AM                                   
                      ,COG_DEFERRED_AM                                  
                      ,COG_DEFERRED_PCT                                 
                      ,GAS_ALLOC_PCT                                    
                      ,COG_BALANCE_AM)                                  
               VALUES                                                   
                     (:CF-ACCOUNT-NO                                    
                     ,CIS.CHAR2TIMESTAMP(:CF-CREATED-TS)                        
                     ,:CF-COMPANY-NO                                    
                     ,:CF-COG-TRAN-TYPE-CD                              
                     ,:CF-PYMT-PRIORITY-LVL                             
                     ,:CF-WO-ADJUSTED-AM                                
                     ,:CF-COG-DEFERRED-AM                               
                     ,:CF-COG-DEFERRED-PCT                              
                     ,:CF-GAS-ALLOC-PCT                                 
                     ,:CF-COG-BALANCE-AM)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_COST_GAS_DEFER                                   
MFA-TR*               (ACCOUNT_NO                                               
MFA-TR*               ,CREATED_TS                                               
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,COG_TRAN_TYPE_CD                                         
MFA-TR*               ,PYMT_PRIORITY_LVL                                        
MFA-TR*               ,WO_ADJUSTED_AM                                           
MFA-TR*               ,COG_DEFERRED_AM                                          
MFA-TR*               ,COG_DEFERRED_PCT                                         
MFA-TR*               ,GAS_ALLOC_PCT                                            
MFA-TR*               ,COG_BALANCE_AM)                                          
MFA-TR*        VALUES                                                           
MFA-TR*              (:CF-ACCOUNT-NO                                            
MFA-TR*              ,:CF-CREATED-TS                                            
MFA-TR*              ,:CF-COMPANY-NO                                            
MFA-TR*              ,:CF-COG-TRAN-TYPE-CD                                      
MFA-TR*              ,:CF-PYMT-PRIORITY-LVL                                     
MFA-TR*              ,:CF-WO-ADJUSTED-AM                                        
MFA-TR*              ,:CF-COG-DEFERRED-AM                                       
MFA-TR*              ,:CF-COG-DEFERRED-PCT                                      
MFA-TR*              ,:CF-GAS-ALLOC-PCT                                         
MFA-TR*              ,:CF-COG-BALANCE-AM)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
      *                                                                         
           IF  SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7100'                    TO ACTIVE-PARAGRAPH       
               MOVE 'INSERT'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_COST_GAS_DEFER'      TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE CF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECT THE COG PERCENTAGE FOR THE ACCOUNT FROM THE TABLE       *        
      ******************************************************************        
       7200-SELECT-COG-PCT.                                             
      *                                                                         
           MOVE '7200'          TO ACTIVE-PARAGRAPH.                    
      *                                                                         
           EXEC SQL                                                     
               SELECT COG_DEFERRED_PCT                                  
                     ,COG_BALANCE_AM                                    
                 INTO :CF-COG-DEFERRED-PCT                              
                     ,:CF-COG-BALANCE-AM                                
                FROM CSS_COST_GAS_DEFER CF                              
                WHERE ACCOUNT_NO           = :CF-ACCOUNT-NO             
                  AND COMPANY_NO           = :CF-COMPANY-NO             
                  AND CREATED_TS       =                                
                   (SELECT MAX(CREATED_TS)                              
                      FROM CSS_COST_GAS_DEFER CF1                       
                     WHERE CF1.ACCOUNT_NO        = CF.ACCOUNT_NO        
                       AND CF1.COMPANY_NO        = CF.COMPANY_NO)       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
      *                                                                         
           IF  SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7200'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_COST_GAS_DEFER'      TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE CF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **   7300-GET-ACCOUNT-INFO                                      **        
      **        GET THE GAS PERCENT TO INSERT INTO CSS_COST_GAS_DEFER **        
      ******************************************************************        
       7300-GET-ACCOUNT-INFO.                                           
                                                                        
           MOVE '7300'                      TO ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
               SELECT ELEC_REV_ALLOC_PCT                                
                 INTO :AT-ELEC-REV-ALLOC-PCT                            
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :CF-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7300'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
P00131******************************************************************        
P00131* FOR ALL SUMMARY ROWS IN CSS_COST_GAS_DEFER INSERT NECESSARY    *        
P00131* DETAIL ROWS IN CSS_COST_GAS_DET CALCULATED IN COPYBOOK CPDCA224*        
P00131******************************************************************        
P00131 7400-INSERT-COST-GAS-DET.                                        
P00131*                                                                         
P00131     MOVE '7400'          TO ACTIVE-PARAGRAPH.                    
P00131*                                                                         
P00131     EXEC SQL                                                     
P00131         INSERT INTO CSS_COST_GAS_DET                             
P00131                (ACCOUNT_NO                                       
P00131                ,COMPANY_NO                                       
P00131                ,CREATED_TS                                       
P00131                ,ENTRY_NO                                         
P00131                ,RATE_PLAN_NO                                     
P00131                ,VERSION_NO                                       
P00131                ,BLOCK_NO                                         
P00131                ,BILL_NO                                          
P00131                ,COG_FACTOR                                       
P00131                ,FACTOR_PRORATE_PCT                               
P00131                ,RATE_PRORATE_PCT                                 
P00131                ,BILLED_UNITS                                     
P00131                ,ADJUSTED_COG_PCT)                                
P00131         VALUES                                                   
P00131               (:GB-ACCOUNT-NO                                    
P00131               ,:GB-COMPANY-NO                                    
P00131               ,CIS.CHAR2TIMESTAMP(:GB-CREATED-TS)                        
P00131               ,:GB-ENTRY-NO                                      
P00131               ,:GB-RATE-PLAN-NO                                  
P00131               ,:GB-VERSION-NO                                    
P00131               ,:GB-BLOCK-NO                                      
P00131               ,:GB-BILL-NO                                       
P00131               ,:GB-COG-FACTOR                                    
P00131               ,:GB-FACTOR-PRORATE-PCT                            
P00131               ,:GB-RATE-PRORATE-PCT                              
P00131               ,:GB-BILLED-UNITS                                  
P00131               ,:GB-ADJUSTED-COG-PCT)                             
P00131     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_COST_GAS_DET                                     
MFA-TR*               (ACCOUNT_NO                                               
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,CREATED_TS                                               
MFA-TR*               ,ENTRY_NO                                                 
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,VERSION_NO                                               
MFA-TR*               ,BLOCK_NO                                                 
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,COG_FACTOR                                               
MFA-TR*               ,FACTOR_PRORATE_PCT                                       
MFA-TR*               ,RATE_PRORATE_PCT                                         
MFA-TR*               ,BILLED_UNITS                                             
MFA-TR*               ,ADJUSTED_COG_PCT)                                        
MFA-TR*        VALUES                                                           
MFA-TR*              (:GB-ACCOUNT-NO                                            
MFA-TR*              ,:GB-COMPANY-NO                                            
MFA-TR*              ,:GB-CREATED-TS                                            
MFA-TR*              ,:GB-ENTRY-NO                                              
MFA-TR*              ,:GB-RATE-PLAN-NO                                          
MFA-TR*              ,:GB-VERSION-NO                                            
MFA-TR*              ,:GB-BLOCK-NO                                              
MFA-TR*              ,:GB-BILL-NO                                               
MFA-TR*              ,:GB-COG-FACTOR                                            
MFA-TR*              ,:GB-FACTOR-PRORATE-PCT                                    
MFA-TR*              ,:GB-RATE-PRORATE-PCT                                      
MFA-TR*              ,:GB-BILLED-UNITS                                          
MFA-TR*              ,:GB-ADJUSTED-COG-PCT)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00131*                                                                         
P00131     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00131*                                                                         
P00131     IF  SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                   
P00131         NEXT SENTENCE                                            
P00131     ELSE                                                         
P00131         MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
P00131         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
P00131         MOVE '7400'                    TO ACTIVE-PARAGRAPH       
P00131         MOVE 'INSERT'                  TO ABEND-FUNCTION         
P00131         MOVE SPACES                    TO ABEND-SQL-PREDICATES   
P00131                                           ABEND-TABLES           
P00131         MOVE 'CSS_COST_GAS_DET'        TO TABLE-1                
P00131         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
P00131         MOVE GB-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
P00131         MOVE 'CREATED_TS'              TO TABLE-ELEMENT-2        
P00131         MOVE GB-CREATED-TS             TO HOSTVAR-ELEMENT-2      
P00131         PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
P00131     END-IF.                                                      
P00131*                                                                         
P00131 7400-INSERT-EXIT.                                                
P00131     EXIT.                                                        
P00131*                                                                         
      *                                                                         
      *                                                                         
      ******************************************************************        
      * GET CURRENT TIMESTAMP                                          *        
      ******************************************************************        
       7999-SELECT-TIMESTAMP.                                           
      *                                                                         
           MOVE '7999'          TO ACTIVE-PARAGRAPH.                    
      *                                                                         
           EXEC SQL                                                     
C36929       SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7999'                    TO ACTIVE-PARAGRAPH       
C36929         MOVE 'SET'                     TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
C36929                                           TABLE-1                
               MOVE SPACES                    TO TABLE-ELEMENT-1        
               MOVE ZEROES                    TO HOSTVAR-ELEMENT-1      
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF                                                       
           .                                                            
       7999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * COPYBOOK TO CALCULATE THE COG PERCENTAGE FOR BILLING           *        
      ******************************************************************        
           EXEC SQL                                                     55521101
              INCLUDE CPDCA224                                          55521201
           END-EXEC.                                                    55521301
      *                                                                         
      ******************************************************************        
      * RETURNS TO CALLING PROGRAM UNDER ABNORMAL CONDITIONS WITH A    *        
      * APPROPRIATE MESG AND RETURN-CODE 9                             *        
      ******************************************************************        
       9900-ABEND.                                                      
                                                                        
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           GOBACK.                                                      
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9999-SCSCB224-EXIT  THRU 9999-EXIT.                  
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-SCSCB224-EXIT.                                              
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
