       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    SCSCB061.                                         
       DATE-WRITTEN.  08/07/2001.                                       
       AUTHOR      .  COVANSYS.                                         
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                                                             **         
      *********         CUSTOMER SERVICE SYSTEM           *************         
      *********                DB2                        *************         
      *****************************************************************         
      **               !!! WARNING  !!!!                             **         
      **               -----------------                             **         
      ** CPD00061 HAS BEEN CONVERTED INTO A PROGRAM.  THE NAME OF    **         
      ** THIS PROGRAM IS:                                            **         
      **                 SCSCO061 - FOR ON-LINE COMPONENTS           **         
      **                 SCSCB061 - FOR BATCH COMPONENTS             **         
      **                                                             **         
      ** THESE PROGRAMS INCLUDE COPYBOOKS:                           **         
      ** 1.  CWS00061 (WORKING STORAGE),                             **         
      ** 2.  CPD00061 (PROCEDURE DIVISION LOGIC)                     **         
      ** 3.  CWS0061L (LINKAGE SECTION)                              **         
      **                                                             **         
      ** PROGRAMS THAT INCLUDED CPD00061/CWS00061 NOW LINK TO        **         
      ** SCSCO061/SCSCB061 AND INCLUDE COPYBOOK CWS0061L TO PASS     **         
      ** INFORMATION BACK AND FORTH BETWEEN THE CALLING AND CALLED   **         
      ** PROGRAMS.                                                   **         
      *****************************************************************         
      **                                                             **         
      **                  PROGRAM MODIFICATION LOG                   **         
      **    DATE    INITIALS   REASON                                **         
      **    ____    ________   ______                                **         
      **                                                             **         
      **  08/07/01  COVANSYS COPY BOOK CPD00061 CHANGED TO SUB       **         
      **            CHENNAI  PROGRAM.                                **         
      *****************************************************************         
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCB061'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR SCSCB061 STARTS HERE'.            
                                                                        
       01  WS-CALL-ENVIRONMENT         PIC X(01) VALUE 'B'.             
           88 ONLINE-CALL              VALUE 'O'.                       
           88 BATCH-CALL               VALUE 'B'.                       
                                                                        
       01  PROGRAM-NAME                PIC X(08) VALUE 'SCSCB061'.      
      *                                                                         
      ******************************************************************        
      *  COPYBOOK THAT CONTAINS WS-ACTIVE-RETURN-CODE, SUCCESSFUL-CALL *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ***********************  SQL DECLARATIONS  ***********************00003200
      *                                                                 00005000
           EXEC SQL                                                     00003300
               INCLUDE SQLCA                                            00003400
           END-EXEC.                                                    00004000
      *                                                                 00005000
           EXEC SQL                                                     00006000
               INCLUDE TBGLATNO                                         00007000
           END-EXEC.                                                    00008000
      *                                                                         
      ************************ SQL DECLARATIONS END ********************00003200
      *                                                                         
      ******************************************************************        
      *  CURSOR DECLARATION FOR RETRIEVING GL VALUES FOR THE GIVEN     *        
      *  COMPANY NO.                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE GL-CPD61-CSR CURSOR FOR                          
               SELECT GL_ACCT_NO,                                       
                      GL_ACCT_NAME                                      
                 FROM CSS_GL_ACCT_NO                                    
                WHERE COMPANY_NO =:GO-COMPANY-NO                        
                ORDER BY GL_ACCT_NO                                     
            END-EXEC.                                                   
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
           COPY CWS00010.                                                       
                                                                        
           EXEC SQL                                                     00006000
              INCLUDE CWS00061                                                  
           END-EXEC.                                                    00008000
                                                                        
       01  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.         
      *                                                                         
       PROCEDURE DIVISION USING  WS-GL-ACCT-NAME,                       
                                 WS-GL-ACCT-MAJOR-FIELDS,               
                                 WS-VALID-COMPANY-NOS,                  
                                 WS-GL-NAME-INFO,                       
                                 WS-GL-ACCT-NO-TABLE,                   
                                 WS-CPD00061-CALLING-PGM,               
                                 ABEND-FILE,                            
                                 RS-RETURN-CODE.                        
      *                                                                         
      ******************************************************************        
      **  0000-MAINLINE                                               **        
      **      CONTROLS MAIN PROCESSING OF PROGRAM                     **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           IF WS-CPD00061-CALLING-PGM > LOW-VALUES AND                  
              WS-CPD00061-CALLING-PGM > SPACES                          
              MOVE WS-CPD00061-CALLING-PGM     TO PROGRAM-NAME          
           END-IF.                                                      
      *                                                                         
           PERFORM 0700-LOAD-GL-NO-VALUES                               
              VARYING WS-VALID-CO-SUB FROM 1 BY 1                       
                 UNTIL WS-VALID-CO-SUB GREATER THAN WS-MAX-CO           
                   OR WS-VALID-CO-NO (WS-VALID-CO-SUB) EQUAL WS-GL-99.  
      *                                                                         
           PERFORM 9999-SCSCB061-EXIT          THRU 9999-EXIT.          
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0700-LOAD-GL-NO-VALUES                                         *        
      *     LOAD GL VALUES IN WS TABLES FOR ALL THE ACCOUNT NUMBERS.   *00006000
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00061                                         00007000
           END-EXEC.                                                    00008000
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * THE FOLLOWING PARAS ARE BEING PERFORMED BY                     *        
      * 0700-LOAD-GL-NO-VALUES. SEE CWS00061 FOR GENERAL COMMENTS.     *        
      *                                                                *        
      ******************************************************************        
      * 7000-OPEN-CPD61-GL-CSR                                         *        
      *     OPENS CURSOR FOR CSS_GL_ACCT_NO TABLE                      *        
      ******************************************************************        
      *                                                                         
       7000-OPEN-CPD61-GL-CSR.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN GL-CPD61-CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7000'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_GL_ACCT_NO'           TO TABLE-1               
               MOVE 'GO-COMPANY-NO'            TO TABLE-ELEMENT-1       
               MOVE GO-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7000C-EXIT.                                                      
      *                                                                         
      ******************************************************************        
      * 7010-FETCH-CPD61-GL-CSR                                        *        
      *     PERFORMS FETCH OF GL ACCOUNT NUMBERS & NAMES FROM          *        
      *     CSS_GL_ACCT_NO TABLE                                       *        
      ******************************************************************        
      *                                                                         
       7010-FETCH-CPD61-GL-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
                FETCH GL-CPD61-CSR                                      
                INTO :GO-GL-ACCT-NO,                                    
                     :GO-GL-ACCT-NAME                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7010'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_GL_ACCT_NO'           TO TABLE-1               
               MOVE 'GO-COMPANY-NO'            TO TABLE-ELEMENT-1       
               MOVE GO-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7010C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-CLOSE-CPD61-GL-CSR                                        *        
      *     CLOSING OF CURSOR FOR CSS_GL_ACCT_NO TABLE                 *        
      ******************************************************************        
       7020-CLOSE-CPD61-GL-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
               CLOSE GL-CPD61-CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7020'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_GL_ACCT_NO'           TO TABLE-1               
               MOVE 'GO-COMPANY-NO'            TO TABLE-ELEMENT-1       
               MOVE GO-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7020C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND.                                            *        
      *     RETURNS THE CONTROL TO CALLING PROGRAM                     *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9999-SCSCB061-EXIT          THRU  9999-EXIT.         
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9999-SCSCB061-EXIT.                                            *        
      *     EXITS & RETURNS THE CONTROL TO CALLING PROGRAM             *        
      ******************************************************************        
      *                                                                         
       9999-SCSCB061-EXIT.                                              
                                                                        
           EXIT PROGRAM.                                                
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
