       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. SCSCA666.                                            
       AUTHOR. ROGER F. FAULK                                           
       DATE-WRITTEN. DECEMBER 2008                                      
      ****************************************************************          
      *               SOUTH CAROLINA ELECTRIC & GAS                  *          
      ****************************************************************          
      *               CUSTOMER INFORMATION SYSTEM                    *          
      ****************************************************************          
      *               PROGRAM SUMMARY                                *          
      *                                                              *          
      *   PURPOSE: THIS PROGRAM CALCULATES THE MAXIMUM DEPOSIT       *          
      *            AMOUNT.   IT IS TO BE CALLED FROM OTHER PROGRAMS. *          
      *                                                              *          
      ****************************************************************          
      *                                                              *          
      *               PROGRAM  MODIFICATION  LOG                     *          
      *                                                              *          
      *      DATE       INITIALS  REASON                             *          
      *    ----------   --------  -----------------------------------*          
      * 15 DEC 2008     RF10596   NEW PROGRAM                        *          
      *                                                              *          
      ****************************************************************          
      *                                                              *          
A04388** 08/30/12   DB41297      FIX PROBLEM WITH SEB COMPANY-NO.    *          
A05091** 01/23/2016 RB19957      ADDED TBATMISC WHICH IS NOW NEEDED  *          
A05091**                         IN CPD00308 FOR SEB SEASONAL FLAG.  *          
      *                                                              *          
      ****************************************************************          
      **         ---- BASIC SEQUENCE STRUCTURE ----                 **          
      **                                                            **          
      ** 0000         MODULE CONTROL                                **          
      ** 0100 - 0999  INITIALIZATION (OPTIONAL)                     **          
      ** 1000 - 1999  FUNCTIONAL CONTROL                            **          
      ** 2000 - 4999  DETAIL LOGIC                                  **          
      ** 5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            **          
      ** 6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  **          
      ** 7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)**          
      ** 8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)*          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA666'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-GENERAL-WORKING-STORAGE.                                   
          05  WS-NULL                    PIC S9(4)   COMP   VALUE 0.    
          05  WS-ACCOUNT-NO-HOLD         PIC S9(13)  COMP-3 VALUE 0.    
          05  WS-ACCOUNT-NO              PIC S9(13)V COMP-3 VALUE 0.    
          05  WS-DO-AMT-DEPOSIT-NULL     PIC S9(4)   COMP VALUE 0.      
          05  WS-CUR-COMPANY-NO          PIC XX      VALUE SPACES.      
          05  WS-CUR-RESP-AREA-ID        PIC X(3)    VALUE SPACES.      
          05  WS-COMMON-DATE             PIC X(10).                     
          05  WS-CURRENT-DEPOSIT         PIC 9(4)V99 VALUE 0.           
          05  RS-RETURN-CODE             PIC S9(4)   COMP VALUE 0.      
          05  RS-RETURN-CODE-DISP        PIC +Z(4).                     
          05  WS-PERCENT-AMT             PIC 99.                        
      *                                                                         
          05 WS-RESP-DATA-LOADED         PIC X    VALUE 'N'.            
          05 WS-RESP-AREA-SUB            PIC 9(3) VALUE 0.              
          05 WS-RESP-AREA-DETAIL-TABLE.                                 
             10  WS-RESP-AREA-DET OCCURS 350.                           
                 15  WS-RESP-AREA-ID     PIC X(3).                      
                 15  WS-RESP-AREA-DESC   PIC X(30).                     
COB305           15 WS-RESP-AREA-AMT        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305           15 WS-RESP-EARNST-AMT        PIC S9(7)V99 COMP-3 
COB305             VALUE 0.           
COB305           15 WS-RESP-ADDTL-DEP        PIC S9(7)V99 COMP-3 
COB305             VALUE 0.           
COB305           15 WS-RESP-CURR-DEP        PIC S9(7)V99 COMP-3 VALUE 0.        
      *                                                                         
       01  RS-MIN-DEPOSIT-AMT          PIC S9(9)V99  COMP-3 VALUE 0.    
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-Y                      PIC X     VALUE 'Y'.             
          05 WS-N                      PIC X     VALUE 'N'.             
          05 WS-PGRMNAME               PIC X(8)  VALUE 'SCSCA666'.      
          05 PROGRAM-NAME              PIC X(8)  VALUE 'SCSCA666'.      
      *                                                                         
      ****************************************************************          
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                      *          
      ****************************************************************          
      *                                                                         
             COPY CWS00010.                                                     
      *                                                                         
             COPY CWS00011.                                                     
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOR CPD09900                                 *          
      ****************************************************************          
      *                                                                         
             COPY CWS09900.                                                     
      *                                                                         
      ****************************************************************          
      *  COPYBOOK WITH COMMON SQL VARIABLES                          *          
      ****************************************************************          
      *                                                                         
             COPY CWS00303.                                                     
      *                                                                         
      ****************************************************************          
      * SQL COMMUNICATION AREA                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_ACCOUNT, AT                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_JOB_PARM                                                 *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_BILL_WINDOW,BN                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBBILWDW                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_UTIL_ENVRNMT,UT                                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_RATE_CREATOR,RT                                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBRTCRTR                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_CUST_PREM_HIST,CH                                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCSTPRM                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_DELINQUENCY,C8                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_REG_PROFILE,LR                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBREGPRF                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_LOCAL_OFFICE,B1                                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBLOCOFC                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_BILLING_HDR                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_BILLING_DET                                              *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                         
A05091****************************************************************  02628100
A05091* CSS_ACCT_MISC_INFO TA                                        *          
A05091****************************************************************  02628100
A05091*                                                                         
A05091     EXEC SQL                                                             
A05091        INCLUDE TBATMISC                                                  
A05091     END-EXEC.                                                            
A05091*                                                                         
      ****************************************************************          
      * WORKING STORAGE USED IN CPD00308                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00308                                                 
           END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 WS-LINKAGE-AREA.                                              
          05 WS-LINK-ACCOUNT-NO      PIC S9(13)V  COMP-3 VALUE 0.       
          05 WS-LINK-PREMISE-NO      PIC S9(10)V  COMP-3 VALUE 0.       
          05 WS-LINK-BILL-CYCLE      PIC 99              VALUE 0.       
          05 WS-LINK-INPUT-DATE      PIC X(10).                         
          05 WS-LINK-MAX-DEPOSIT     PIC S9(9)V99 COMP-3 VALUE 0.       
          05 WS-LINK-RETURN-CODE     PIC S9(9)    COMP   VALUE +000.    
          05 WS-DATABASE             PIC 9               VALUE 0.       
             88 CSR-DATABASE         VALUE 1.                           
             88 SEB-DATABASE         VALUE 2.                           
      *                                                                         
       PROCEDURE DIVISION USING WS-LINKAGE-AREA.                        
      *                                                                         
      ****************************************************************          
      * 0000-MAINLINE                                                *          
      ****************************************************************          
      *                                                                         
           PERFORM 1000-MAIN THRU 1000-EXIT.                            
      *                                                                         
           GOBACK.                                                      
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  MAIN PARAGRAPH - RETRIEVES THE MAXIMUM ALLOWABLE DEPOSIT    *          
      *  FOR AN ACCOUNT.  THE CALCULATION IS DONE IN CPD00308.       *          
      ****************************************************************          
      *                                                                         
       1000-MAIN.                                                       
      *                                                                         
           MOVE WS-LINK-ACCOUNT-NO TO WS-ACCOUNT-NO.                    
           MOVE WS-LINK-PREMISE-NO TO WS-PREMISE-NO.                    
           MOVE WS-LINK-BILL-CYCLE TO AT-BILL-CYCLE.                    
           MOVE WS-Y               TO WS-CALLING-BATCH-SW.              
           MOVE WS-LINK-INPUT-DATE TO WS-TEMP-BATCH-DATE.               
A04388     IF SEB-DATABASE                                              
A04388        MOVE '01' TO AT-COMPANY-NO                                
A04388     END-IF.                                                      
      *                                                                         
           PERFORM 5650-GET-MAX-DEPOSIT                                 
                THRU 5650-GET-MAX-DEPOSIT-EXIT.                         
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE TO WS-LINK-RETURN-CODE.           
           MOVE WS-MAX-DEPOSIT-AMT    TO WS-LINK-MAX-DEPOSIT.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           DISPLAY '9000-TERMINATE HONK '.                              
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      *   5650-GET-MAX-DEPOSIT                                      *           
      *   USED TO CALCULATE MAX DEPOSIT.                            *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00308                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  9700-PROCESS-ABEND                                          *          
      * THIS PARAGRAPH DOES BATCH ABEND PROCESSING USING THE CICS    *          
      * WORKING STORAGE ABEND FIELDS.                                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * 9900-ABEND                                                   *          
      * COPYBOOK FOR ABEND ROUTINE                                   *          
      * PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
