       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    SCSCA658.                                         
       DATE-WRITTEN.  AUG 2003.                                         
           DATE-COMPILED.                                               
      *                                                                         
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INTIALS      REASON                              **         
      **    ____    _______      ______                              **         
C28373**   08/03    VD88125      CLONED SCSCA657 FOR ITRON-AMR PILOT **         
C28373**                         MADE CHANGES TO CREATE METER CHANGE **         
C28373**                         ELEC ORDERS AND METER FIELD WORK GAS**         
C28373**                         ORDERS.                             **         
      **                                                             **         
30989 **  7-16-2004 RF10596      ADDED CSS_CODE_VALUE TABLE TO       **         
      **                         LOAD XE-ORDER-PLACED-BY FOR THE     **         
      **                         SERVICE ORDER TABLE ENTRY.  ALSO,   **         
      **                         IF THE WS-SO-TEST-TYPE IS NOT ON    **         
      **                         THE TABLE IT DISPLAYS A MESSAGE AND **         
      **                         ABENDS THE PROGRAM.                 **         
      **                                                             **         
A03407**   05/26/11  RF10596     ADDED FIELDS COMING FROM PCSCA658   **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
                    ------ BASIC BATCH SEQUENCE STRUCTURE ---------     
      *                                                                         
                    0000 - 0000  MAIN CONTROL                           
                    2000 - 2999  CALCULATE DAY                          
                    3000 - 3999  MOVE WORKING STORAGE TO HOST VARS      
                    7000 - 7999  INQUIRY CALLS TO DATABASES AND         
                    8000 - 8870  INSERT CALLS TO DATABASES.             
                    9000 - 9000  TERMINATION                            
                    9900 - 9900  ABEND/ABORT MODULES                    
      *                                                                         
           REMARKS.                                                     
               SCSCA658 IS A SUBPROGRAM CALLED BY PROGRAMS PCSCA658     
               TO POST METER CHANGE AND METER FIELD WORK SERVICE ORDERS.
               (METERS ARE REPLACED SO THE ORIGINAL METER CAN BE TESTED)
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.  IBM-370.                                       
       OBJECT-COMPUTER.  IBM-370.                                       
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ****************************************************************          
      *    WORKING STORAGE FOR SCSCA658                              *          
      ****************************************************************          
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA658'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-INITIATED                 PIC X(2) VALUE '10'.        
           05  WS-CODE-VALUE-NOT-FOUND      PIC X(25)                   
               VALUE 'AMR PROJECT TEAM'.                                
           05  WS-SYSTEM                    PIC X(06) VALUE 'SYSTEM'.   
           05  WS-PRIORITY                  PIC X(1) VALUE '7'.         
           05  WS-WORK-DATE                 PIC X(10).                  
           05  FILLER REDEFINES WS-WORK-DATE.                           
               10  WS-WORK-YEAR             PIC X(04).                  
               10  FILLER                   PIC X(06).                  
           05  WS-WANTED-DATE-R.                                        
               10  WS-WANTED-YEAR           PIC X(04).                  
               10  FILLER                   PIC X(06) VALUE '-09-01'.   
           05  FILLER REDEFINES WS-WANTED-DATE-R.                       
               10  WS-WANTED-DATE           PIC X(10).                  
           05  WS-WORK-AMPM                 PIC X(1) VALUE 'P'.         
           05  WS-ROW-COUNT                 PIC S9(9) COMP VALUE ZERO.  
           05  WS-DAY                       PIC S9(4) COMP VALUE ZERO.  
           05  WS-MAX-SO-INST-SEQ-NO        PIC S9(4) USAGE COMP.       
           05  WS-NULL-IND                  PIC S9(04) COMP VALUE ZEROS.
           05  WS-CURRENT-TS                PIC X(26).                  
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-BAD-WORKING-DAY           PIC X(1).                   
               88  BAD-WORKING-DAY                    VALUE 'N'.        
               88  GOOD-WORKING-DAY                   VALUE 'Y'.        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                  PIC X(08) VALUE 'SCSCA658'. 
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE               PIC X(02) VALUE SPACE.      
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC         PIC 99.                     
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBMTRENV                                                
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBSODTMF                                                
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBSOOIMF                                                
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBMODEL                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBHLDAY                                                 
           END-EXEC.                                                            
      *                                                                         
30989 ******************************************************************        
30989 *   CSS_CODE_VALUE                                                        
30989 ******************************************************************        
      *                                                                         
30989      EXEC SQL                                                             
30989           INCLUDE TBCDVALU                                                
30989      END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *                                                              *          
      *    LINKAGE SECTION FOR SCSCA658.  SCSCA658 IS A SUBPROGRAM   *          
      *    CALLED BY PROGRAM PCSCA658.                               *          
      *                                                              *          
      ****************************************************************          
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  WS-LINKAGE-AREA.                                             
COB305     05 WS-SO-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.              
           05  WS-SO-METER-NO           PIC X(9).                       
           05  WS-SO-UTIL-TYPE          PIC X(01).                      
           05  WS-SO-ORDER-TYPE         PIC X(05).                      
           05  WS-SO-TEST-TYPE          PIC X(01).                      
           05  WS-SO-WANTED-DATE        PIC X(10).                      
           05  WS-SO-DB2-DATE           PIC X(10).                      
A03407     05  WS-SO-PREMISE            PIC X(10).                      
A03407     05  WS-SO-MTR-STATUS         PIC X.                          
A03407     05  WS-SO-WORK-TYPE          PIC X(3).                       
       01  WS-PREMISE-NO               PIC S9(10)V  COMP-3 VALUE 0.     
HPCCDM*    EJECT                                                                
       PROCEDURE DIVISION USING WS-LINKAGE-AREA                         
                                WS-PREMISE-NO.                          
      *                                                                         
      ****************************************************************          
      *                                                              *          
      *    MAINLINE CONTROL LOGIC                                    *          
      *                                                              *          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
           MOVE WS-SO-ACCT-NO            TO AT-ACCOUNT-NO               
                                            MN-ACCOUNT-NO.              
           MOVE WS-SO-METER-NO           TO MN-METER-NO.                
           MOVE WS-SO-UTIL-TYPE          TO MN-CODE-UTIL-TYPE.          
A03407     MOVE WS-SO-MTR-STATUS         TO MN-CODE-METER-STATUS.       
           PERFORM 1000-PROCESS-LINKAGE-INPUT THRU 1000-EXIT.           
           GOBACK.                                                      
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *                                                              *          
      *    POST METER EXCHANGE ORDERS USING INFORMATION PASSED FROM  *          
      *    CALLING PROGRAM                                           *          
      *                                                              *          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-LINKAGE-INPUT.                                      
           PERFORM 2900-CALC-WANTED-BY-DATE THRU 2900-EXIT.             
           PERFORM 7000-SELECT-TIMESTAMP    THRU 7000-EXIT.             
           PERFORM 7300-GET-ACCOUNT         THRU 7300-EXIT.             
           IF SQLCODE EQUAL NOT-FOUND                                   
              DISPLAY 'RECORD NOT FOUND IN CSS_ACCOUNT'                 
              DISPLAY 'ACCOUNT NO ' AT-ACCOUNT-NO                       
              DISPLAY '7300-GET'  WS-ACTIVE-RETURN-CODE                 
              GO TO 1000-EXIT                                           
           END-IF.                                                      
           MOVE AT-PREMISE-NO         TO WS-PREMISE-NO.                 
           PERFORM 7400-GET-MTRD-ENVRNMT    THRU 7400-EXIT.             
           IF SQLCODE EQUAL NOT-FOUND                                   
              DISPLAY 'RECORD NOT FOUND IN CSS_MTRD_ENVRNMT'            
              DISPLAY 'ACCOUNT NO ' MN-ACCOUNT-NO                       
              DISPLAY 'METER NO   ' MN-METER-NO                         
              DISPLAY '7400-ABEND'  WS-ACTIVE-RETURN-CODE               
              GO TO 1000-EXIT                                           
           END-IF.                                                      
           PERFORM 3000-BUILD-SERVICE-ORDER THRU 3000-EXIT.             
           PERFORM 3100-BUILD-INSTRUCTIONS-REC THRU 3100-EXIT.          
           PERFORM 8000-INSERT-SO-REC       THRU 8000-EXIT.             
           PERFORM 8100-INSERT-SO-INSTRUC-REC THRU 8100-EXIT.           
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *                                                              *          
      *    DETERMINE THE WANTED BY DATE, EXCLUDING WEEK-ENDS AND     *          
      *    HOLIDAYS.                                                 *          
      *                                                              *          
      ****************************************************************          
      *                                                                         
       2900-CALC-WANTED-BY-DATE.                                        
           MOVE WS-SO-DB2-DATE TO WS-WORK-DATE.                         
           SET BAD-WORKING-DAY TO TRUE.                                 
           PERFORM UNTIL GOOD-WORKING-DAY                               
               PERFORM 7010-GET-NEXT-DAY THRU 7010-EXIT                 
               IF  WS-DAY > 0                                           
                 AND WS-DAY < 6                                         
                   PERFORM 7020-SELECT-HOLIDAY THRU 7020-EXIT           
                   IF  WS-ROW-COUNT = 0                                 
                       SET GOOD-WORKING-DAY TO TRUE                     
                   END-IF                                               
               END-IF                                                   
           END-PERFORM.                                                 
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *                                                              *          
      *    BUILD SERVICE ORDER RECORD                                *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                                
       3000-BUILD-SERVICE-ORDER.                                        
           MOVE WS-SO-ACCT-NO            TO XE-ACCOUNT-NO.              
           MOVE ZEROES                   TO XE-AMT-DNP-AT-BILLING.      
           MOVE 'N'                      TO XE-BACK-DATED.              
           MOVE AT-COMPANY-NO            TO XE-COMPANY-NO.              
           MOVE ZEROES                   TO XE-DEPOSIT-AMT.             
           MOVE SPACES                   TO XE-INIT-BY-CONTRACT.        
           MOVE AT-LOCAL-OFFICE          TO XE-LOCAL-OFFICE.            
           MOVE SPACES                   TO XE-MAKE-ARRANGEMENTS.       
           MOVE SPACES                   TO XE-NOTIFY-CSR-IND.          
           MOVE SPACES                   TO XE-NOTIFY-CUST-IND.         
      *                                                                         
30989      PERFORM 7030-SELECT-CODE-VALUE THRU 7030-EXIT.               
      *                                                                         
           MOVE WS-SYSTEM                TO XE-ORDER-RECVED-BY.         
           MOVE SPACES                   TO XE-ORDER-REASON.            
           MOVE ZEROES                   TO XE-ORDER-STAT-REASON-LEN.   
           MOVE SPACES                   TO XE-ORDER-STAT-REASON-TEXT.  
           MOVE AT-PREMISE-NO            TO XE-PREMISE-NO.              
           MOVE WS-PRIORITY              TO XE-ORDER-PRIORITY-CD.       
           MOVE SPACES                   TO XE-RESP-AREA-ID.            
           MOVE WS-INITIATED             TO XE-SERV-ORDER-STATUS.       
           MOVE WS-CURRENT-TS            TO XE-SO-DATA-SEQ-NO.          
           IF WS-SO-WANTED-DATE > SPACES                                
              MOVE WS-SO-WANTED-DATE     TO XE-WANTED-BY-DATE           
                                            XE-DATE-RECVED              
           ELSE                                                         
              MOVE WS-WORK-DATE          TO XE-WANTED-BY-DATE           
                                            XE-DATE-RECVED              
           END-IF.                                                      
           MOVE WS-SO-ORDER-TYPE         TO XE-ORDER-TYPE-CD            
           MOVE WS-WORK-AMPM             TO XE-WANTED-BY-AM-PM.         
           MOVE SPACES                   TO XE-WORK-INDICATOR.          
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *                                                              *          
      *    BUILD SERVICE ORDER INSTRUCTIONS RECORD                   *          
      *                                                              *          
      ****************************************************************          
      *                                                                         
       3100-BUILD-INSTRUCTIONS-REC.                                     
           MOVE MN-ACCOUNT-NO         TO WB-ACCOUNT-NO.                 
           MOVE MN-CODE-UTIL-TYPE     TO WB-CODE-UTIL-TYPE.             
           MOVE MN-CODE-METER-LOC     TO WB-CODE-METER-LOC.             
           MOVE WS-CURRENT-TS         TO WB-SO-DATA-SEQ-NO.             
           MOVE +1                    TO WB-SO-INST-SEQ-NO              
           MOVE MN-METER-NO           TO WB-METER-NO.                   
           MOVE MN-METER-SUPPLYING    TO WB-METER-SUPPLYING.            
      *                                                                         
A03407     MOVE WS-SO-WORK-TYPE TO WB-WORK-TYPE-CD.                     
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *                                                              *          
      *    RETRIEVE THE CURRENT TIMESTAMP                            *          
      *                                                              *          
      ****************************************************************          
      *                                                                         
       7000-SELECT-TIMESTAMP.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                 INTO :WS-CURRENT-TS                                    
                 FROM  CSS_MODEL_SQL                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CURRENT TIMESTAMP                                        
MFA-TR*          INTO :WS-CURRENT-TS                                            
MFA-TR*          FROM  CSS_MODEL_SQL                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7000-ABEND ' WS-ACTIVE-RETURN-CODE              
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      *    SELECT THE NEXT CURRENT DAY FROM CSS_MODEL_SQL            *          
      *                                                              *          
      ****************************************************************          
       7010-GET-NEXT-DAY.                                               
      *                                                                         
           EXEC SQL                                                     
               SELECT  DATEADD( DAY, 2, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ),                    
                       CIS.DAYS (DATEADD( DAY, 2, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))              
                           - (CIS.DAYS(DATEADD( DAY, 2, 
              IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))/7 * 7)                      
                INTO  :WS-WORK-DATE,                                    
                      :WS-DAY                                           
                FROM   CSS_MODEL_SQL                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DATE(:WS-WORK-DATE) + 2 DAYS,                            
MFA-TR*                DAYS (DATE(:WS-WORK-DATE) + 2 DAYS)                      
MFA-TR*                    - (INTEGER(DAYS(DATE(:WS-WORK-DATE)                  
MFA-TR*                    + 2 DAYS)/7) * 7)                                    
MFA-TR*         INTO  :WS-WORK-DATE,                                            
MFA-TR*               :WS-DAY                                                   
MFA-TR*         FROM   CSS_MODEL_SQL                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7010-ABEND ' WS-ACTIVE-RETURN-CODE              
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      *    DETERMINE IF THE DATE SPECIFIED IS A HOLIDAY              *          
      *                                                              *          
      ****************************************************************          
       7020-SELECT-HOLIDAY.                                             
      *                                                                         
           MOVE ZEROS TO WS-ROW-COUNT.                                  
           EXEC SQL                                                     
                SELECT  COUNT (*)                                       
                  INTO :WS-ROW-COUNT                                    
                  FROM  CSS_HOLIDAY                                     
                 WHERE  HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) )                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  COUNT (*)                                               
MFA-TR*           INTO :WS-ROW-COUNT                                            
MFA-TR*           FROM  CSS_HOLIDAY                                             
MFA-TR*          WHERE  HOLIDAY_DT = :WS-WORK-DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7020-ABEND ' WS-ACTIVE-RETURN-CODE              
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
30989 ******************************************************************        
30989 **  7030-SELECT-CODE-VALUE                                      **        
30989 ******************************************************************        
      *                                                                         
30989  7030-SELECT-CODE-VALUE.                                          
30989      MOVE '7030' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
30989      EXEC SQL                                                     
30989       SELECT CODE_SHORT_DESC                                      
30989        INTO  :XE-ORDER-PLACED-BY                                  
30989        FROM  CSS_CODE_VALUE                                       
30989        WHERE COMPANY_NO = '01'                                    
30989        AND   COLUMN_NA  = 'ORDER_PLACED_BY'                       
30989        AND   TABLE_NA   = 'CSS_SO_DATA_MF'                        
30989        AND   CODE_VALUE = :WS-SO-TEST-TYPE                        
30989        AND   PROGRAM_ID = 'PCSCA620'                              
30989      END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
30989      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
30989      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
30989         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
30989             DISPLAY '                                     '       
30989             DISPLAY '*************************************'       
30989             DISPLAY '   INFORMATIONAL MESSAGE ONLY        '       
30989             DISPLAY '    CALLED PROGRAM - SCSCA658        '       
30989             DISPLAY 'PARAGRAPH  -  7030-SELECT-CODE-VALUE '       
30989             DISPLAY '        WS-SO-TEST-TYPE              '       
30989             DISPLAY '         NOT FOUND ON                '       
30989             DISPLAY '       CODE VALUE TABLE              '       
30989             DISPLAY 'WS-SO-ACCT-NO = ' WS-SO-ACCT-NO              
30989             DISPLAY 'WS-SO-TEST-TYPE = ' WS-SO-TEST-TYPE          
30989             DISPLAY 'RETURN-CODE = ' WS-ACTIVE-RETURN-CODE        
30989             DISPLAY '*************************************'       
30989             DISPLAY '                                     '       
30989            MOVE WS-CODE-VALUE-NOT-FOUND TO XE-ORDER-PLACED-BY     
30989         END-IF                                                    
30989      ELSE                                                         
30989          DISPLAY '                                     '          
30989          DISPLAY '*************************************'          
30989          DISPLAY 'CALLED PROGRAM - SCSCA658 TERMINATED '          
30989          DISPLAY 'PARAGRAPH     7030-SELECT-CODE-VALUE '          
30989          DISPLAY 'RETURN-CODE = ' WS-ACTIVE-RETURN-CODE           
30989          DISPLAY '*************************************'          
30989          DISPLAY '                                     '          
30989          PERFORM 9900-ABEND THRU 9900-EXIT                        
30989       END-IF.                                                     
      *                                                                         
30989  7030-EXIT.                                                       
30989       EXIT.                                                       
      *                                                                         
      ****************************************************************          
      *                                                              *          
      *    GET DATA FROM CSS_ACCOUNT RECORD                          *          
      *                                                              *          
      ****************************************************************          
      *                                                                         
       7300-GET-ACCOUNT.                                                
      *                                                                         
           EXEC SQL                                                     
                SELECT  ACCOUNT_NO,                                     
                        LOCAL_OFFICE,                                   
                        PREMISE_NO,                                     
                        COMPANY_NO                                      
                  INTO :AT-ACCOUNT-NO,                                  
                       :AT-LOCAL-OFFICE,                                
                       :AT-PREMISE-NO,                                  
                       :AT-COMPANY-NO                                   
                  FROM  CSS_ACCOUNT                                     
                 WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL OR        
               NOT-FOUND                                                
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7300-ABEND ' WS-ACTIVE-RETURN-CODE              
               DISPLAY 'ACCOUNT NO ' AT-ACCOUNT-NO                      
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      *    GET DATA FROM CSS_MTRD_ENVRNMT RECORD                     *          
      *                                                              *          
      ****************************************************************          
       7400-GET-MTRD-ENVRNMT.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT  ACCOUNT_NO,                                     
                        CODE_UTIL_TYPE,                                 
                        CODE_METER_LOC,                                 
                        METER_NO,                                       
                        METER_SUPPLYING                                 
                  INTO :MN-ACCOUNT-NO,                                  
                       :MN-CODE-UTIL-TYPE,                              
                       :MN-CODE-METER-LOC,                              
                       :MN-METER-NO,                                    
                       :MN-METER-SUPPLYING                              
                  FROM  CSS_MTRD_ENVRNMT                                
                 WHERE  ACCOUNT_NO = :MN-ACCOUNT-NO                     
                   AND  CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE             
                   AND  METER_NO = :MN-METER-NO                         
A03407             AND  CODE_METER_STATUS = :MN-CODE-METER-STATUS       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL OR        
               NOT-FOUND                                                
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7400-ABEND ' WS-ACTIVE-RETURN-CODE              
               DISPLAY 'ACCOUNT NO ' MN-ACCOUNT-NO                      
               DISPLAY 'METER NO   ' MN-METER-NO                        
A03407         DISPLAY 'CODE METER STATUS ' MN-CODE-METER-STATUS        
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      *    SELECTS MAX SEQ NO FROM CSS_SO_ORD_INST_MF                *          
      *                                                              *          
      ****************************************************************          
       7700-SELECT-MAX-ORD-INST.                                        
      *                                                                         
           EXEC SQL                                                     
                SELECT  MAX(SO_INST_SEQ_NO)                             
                  INTO :WS-MAX-SO-INST-SEQ-NO :WS-NULL-IND              
                  FROM  CSS_SO_ORD_INST_MF                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
               IF WS-NULL-IND = -1                                      
                  MOVE 0  TO WS-MAX-SO-INST-SEQ-NO                      
               END-IF                                                   
           ELSE                                                         
               DISPLAY '7700-SELECT-MAX-ORD-INST'                       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      *    INSERT SERVICE ORDER RECORD                               *          
      *                                                              *          
      ****************************************************************          
       8000-INSERT-SO-REC.                                              
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO  CSS_SO_DATA_MF                             
                            (ACCOUNT_NO,                                
                             AMT_DNP_AT_BILLING,                        
                             BACK_DATED,                                
                             COMPANY_NO,                                
                             DATE_RECVED,                               
                             DEPOSIT_AMT,                               
                             INIT_BY_CONTRACT,                          
                             LOCAL_OFFICE,                              
                             MAKE_ARRANGEMENTS,                         
                             NOTIFY_CSR_IND,                            
                             NOTIFY_CUST_IND,                           
                             ORDER_PLACED_BY,                           
                             ORDER_REASON,                              
                             ORDER_RECVED_BY,                           
                             ORDER_STAT_REASON,                         
                             ORDER_TYPE_CD,                             
                             PREMISE_NO,                                
                             ORDER_PRIORITY_CD,                         
                             RESP_AREA_ID,                              
                             SERV_ORDER_STATUS,                         
                             SO_DATA_SEQ_NO,                            
                             WANTED_BY_AM_PM,                           
                             WANTED_BY_DATE,                            
                             WORK_INDICATOR)                            
                      VALUES                                            
                           (:XE-ACCOUNT-NO,                             
                            :XE-AMT-DNP-AT-BILLING,                     
                            :XE-BACK-DATED,                             
                            :XE-COMPANY-NO,                             
                            IIF(TRY_CONVERT(DATE, :XE-DATE-RECVED
              ) IS NULL OR (PATINDEX('%.%', :XE-DATE-RECVED
              ) <> 0) OR (LEN(:XE-DATE-RECVED) <> 10), CIS.CHAR2DATE(
                                                        :XE-DATE-RECVED
              ), CONVERT(DATE, :XE-DATE-RECVED) ),                            
                            :XE-DEPOSIT-AMT,                            
                            :XE-INIT-BY-CONTRACT,                       
                            :XE-LOCAL-OFFICE,                           
                            :XE-MAKE-ARRANGEMENTS,                      
                            :XE-NOTIFY-CSR-IND,                         
                            :XE-NOTIFY-CUST-IND,                        
                            :XE-ORDER-PLACED-BY,                        
                            :XE-ORDER-REASON,                           
                            :XE-ORDER-RECVED-BY,                        
                            :XE-ORDER-STAT-REASON,                      
                            :XE-ORDER-TYPE-CD,                          
                            :XE-PREMISE-NO,                             
                            :XE-ORDER-PRIORITY-CD,                      
                            :XE-RESP-AREA-ID,                           
                            :XE-SERV-ORDER-STATUS,                      
                            CIS.CHAR2TIMESTAMP(:XE-SO-DATA-SEQ-NO),             
                            :XE-WANTED-BY-AM-PM,                        
                            IIF(TRY_CONVERT(DATE, :XE-WANTED-BY-DATE
              ) IS NULL OR (PATINDEX('%.%', :XE-WANTED-BY-DATE
              ) <> 0) OR (LEN(:XE-WANTED-BY-DATE
              ) <> 10), CIS.CHAR2DATE(:XE-WANTED-BY-DATE
              ), CONVERT(DATE, :XE-WANTED-BY-DATE) ),                         
                            :XE-WORK-INDICATOR)                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO  CSS_SO_DATA_MF                                     
MFA-TR*                     (ACCOUNT_NO,                                        
MFA-TR*                      AMT_DNP_AT_BILLING,                                
MFA-TR*                      BACK_DATED,                                        
MFA-TR*                      COMPANY_NO,                                        
MFA-TR*                      DATE_RECVED,                                       
MFA-TR*                      DEPOSIT_AMT,                                       
MFA-TR*                      INIT_BY_CONTRACT,                                  
MFA-TR*                      LOCAL_OFFICE,                                      
MFA-TR*                      MAKE_ARRANGEMENTS,                                 
MFA-TR*                      NOTIFY_CSR_IND,                                    
MFA-TR*                      NOTIFY_CUST_IND,                                   
MFA-TR*                      ORDER_PLACED_BY,                                   
MFA-TR*                      ORDER_REASON,                                      
MFA-TR*                      ORDER_RECVED_BY,                                   
MFA-TR*                      ORDER_STAT_REASON,                                 
MFA-TR*                      ORDER_TYPE_CD,                                     
MFA-TR*                      PREMISE_NO,                                        
MFA-TR*                      ORDER_PRIORITY_CD,                                 
MFA-TR*                      RESP_AREA_ID,                                      
MFA-TR*                      SERV_ORDER_STATUS,                                 
MFA-TR*                      SO_DATA_SEQ_NO,                                    
MFA-TR*                      WANTED_BY_AM_PM,                                   
MFA-TR*                      WANTED_BY_DATE,                                    
MFA-TR*                      WORK_INDICATOR)                                    
MFA-TR*               VALUES                                                    
MFA-TR*                    (:XE-ACCOUNT-NO,                                     
MFA-TR*                     :XE-AMT-DNP-AT-BILLING,                             
MFA-TR*                     :XE-BACK-DATED,                                     
MFA-TR*                     :XE-COMPANY-NO,                                     
MFA-TR*                     :XE-DATE-RECVED,                                    
MFA-TR*                     :XE-DEPOSIT-AMT,                                    
MFA-TR*                     :XE-INIT-BY-CONTRACT,                               
MFA-TR*                     :XE-LOCAL-OFFICE,                                   
MFA-TR*                     :XE-MAKE-ARRANGEMENTS,                              
MFA-TR*                     :XE-NOTIFY-CSR-IND,                                 
MFA-TR*                     :XE-NOTIFY-CUST-IND,                                
MFA-TR*                     :XE-ORDER-PLACED-BY,                                
MFA-TR*                     :XE-ORDER-REASON,                                   
MFA-TR*                     :XE-ORDER-RECVED-BY,                                
MFA-TR*                     :XE-ORDER-STAT-REASON,                              
MFA-TR*                     :XE-ORDER-TYPE-CD,                                  
MFA-TR*                     :XE-PREMISE-NO,                                     
MFA-TR*                     :XE-ORDER-PRIORITY-CD,                              
MFA-TR*                     :XE-RESP-AREA-ID,                                   
MFA-TR*                     :XE-SERV-ORDER-STATUS,                              
MFA-TR*                     :XE-SO-DATA-SEQ-NO,                                 
MFA-TR*                     :XE-WANTED-BY-AM-PM,                                
MFA-TR*                     :XE-WANTED-BY-DATE,                                 
MFA-TR*                     :XE-WORK-INDICATOR)                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8000-ABEND ' WS-ACTIVE-RETURN-CODE              
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      *    INSERT SERVICE ORDER INSTRUCTIONS RECORD                  *          
      *                                                              *          
      ****************************************************************          
       8100-INSERT-SO-INSTRUC-REC.                                      
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_SO_ORD_INST_MF                           
                   (ACCOUNT_NO,                                         
                    CODE_UTIL_TYPE,                                     
                    CODE_METER_LOC,                                     
                    METER_NO,                                           
                    METER_SUPPLYING,                                    
                    SO_DATA_SEQ_NO,                                     
                    SO_INST_SEQ_NO,                                     
                    WORK_TYPE_CD)                                       
               VALUES                                                   
                   (:WB-ACCOUNT-NO,                                     
                    :WB-CODE-UTIL-TYPE,                                 
                    :WB-CODE-METER-LOC,                                 
                    :WB-METER-NO,                                       
                    :WB-METER-SUPPLYING,                                
                    CIS.CHAR2TIMESTAMP(:WB-SO-DATA-SEQ-NO),                     
                    :WB-SO-INST-SEQ-NO,                                 
                    :WB-WORK-TYPE-CD)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_ORD_INST_MF                                   
MFA-TR*            (ACCOUNT_NO,                                                 
MFA-TR*             CODE_UTIL_TYPE,                                             
MFA-TR*             CODE_METER_LOC,                                             
MFA-TR*             METER_NO,                                                   
MFA-TR*             METER_SUPPLYING,                                            
MFA-TR*             SO_DATA_SEQ_NO,                                             
MFA-TR*             SO_INST_SEQ_NO,                                             
MFA-TR*             WORK_TYPE_CD)                                               
MFA-TR*        VALUES                                                           
MFA-TR*            (:WB-ACCOUNT-NO,                                             
MFA-TR*             :WB-CODE-UTIL-TYPE,                                         
MFA-TR*             :WB-CODE-METER-LOC,                                         
MFA-TR*             :WB-METER-NO,                                               
MFA-TR*             :WB-METER-SUPPLYING,                                        
MFA-TR*             :WB-SO-DATA-SEQ-NO,                                         
MFA-TR*             :WB-SO-INST-SEQ-NO,                                         
MFA-TR*             :WB-WORK-TYPE-CD)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
               NEXT SENTENCE                                            
           ELSE                                                         
                 DISPLAY '8100-ABEND ' WS-ACTIVE-RETURN-CODE            
                 PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                     
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    TERMINATE PROCESSING - CLOSE FILES                          *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
