       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    SCSCA657.                                         
       DATE-WRITTEN.  MAR 1995.                                         
           DATE-COMPILED.                                               
HPCCDM*    SKIP1                                                        00035000
      ***************************************************************** PCS00050
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** PCS00060
      **                     PRICE WATERHOUSE                        ** PCS00070
      **                1410 NORTH WESTSHORE BLVD                    ** PCS00080
      **                   TAMPA, FLORIDA  33607                     ** PCS00090
      **                      (813) 287-9200                         ** PCS00100
      **                                                             ** PCS00110
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INTIALS      REASON                              **         
      **    ____    _______      ______                              **         
TP6190**    1/97    MD80170      DELETED THE SELECTION CRITERIA FROM **         
      **                         THE LINAKGAE AREA.  IT WAS BEING    **         
      **                         USED TO POPULATE ORDER_REASON WHICH **         
      **                         IS NOW POPULATED WITH SPACES ALONG  **         
      **                         WITH THE WORK_INDICATOR.            **         
      **                         ADDED COMPANY NUMBER TO THE SO.     **         
PCR566**    1/98    CBSI         CHANGES MADE SO THAT PROGRAM DOES   **         
      **                         NOT ABEND FOR SQLCODE OF -100.      **         
      **                                                             **         
T16229**    5/98    CBSI         CODE CHANGED TO GET  CODE-UTIL-TYPE **         
T16229**                         ALSO ALONG WITH ACCOUNT NO & METER  **         
T16229**                         NO'S FROM THE CALLING PROGRAM.      **         
      **                                                             **         
T19653**    4/99    CBSI         POPULATE BACK_DATED COLUMN ON TABLE **         
T19653**                         CSS_SO_DATA_MF WITH 'N'.            **         
      **                                                             **         
T19683**    4/99    CBSI         POPULATE XE-WANTED-BY-DATE WITH NEXT**         
T19683**           MADRAS        NEXT BUSINESS DAY INSTEAD OF NEXT   **         
T19683**                         BUSINESS DAY                        **         
ACT018** A04527-ACT018 DB41297 INCREASE TABLE LIMIT.                 **         
      *****************************************************************         
HPCCDM*    SKIP1                                                        00035000
                    ------ BASIC BATCH SEQUENCE STRUCTURE ---------     
HPCCDM*    SKIP1                                                        00035000
                    0000 - 0000  MAIN CONTROL                           
                    2000 - 2999  CALCULATE DAY                          
                    3000 - 3999  MOVE WORKING STORAGE TO HOST VARS      
                    7000 - 7999  INQUIRY CALLS TO DATABASES AND         
                    8000 - 8870  INSERT CALLS TO DATABASES.             
                    9000 - 9000  TERMINATION                            
                    9900 - 9900  ABEND/ABORT MODULES                    
HPCCDM*    SKIP1                                                        00035000
           REMARKS.                                                     
               SCSCA657 IS A SUBPROGRAM CALLED BY PROGRAMS PCSCA650 &   
               PCSCA656 TO POST METER CHANGE SERVICE ORDERS.  (METERS   
               ARE REPLACED SO THE ORIGINAL METER CAN BE TESTED.)       
HPCCDM*    EJECT                                                        00028000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.  IBM-370.                                       
       OBJECT-COMPUTER.  IBM-370.                                       
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
HPCCDM*    EJECT                                                        00028000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
HPCCDM*    EJECT                                                        00035000
      ****************************************************************          
      *                                                              *          
      *    WORKING STORAGE FOR SCSCA657                              *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA657'.
MSQ017     COPY MFASQLM.
HPCCDM*    SKIP1                                                        00035000
       01  WS-MISC.                                                     
           05  WS-START                     PIC X(40)                   
               VALUE 'WORKING STORAGE FOR SCSCA657 STARTS HERE'.        
           05  WS-SO-IDX                    PIC S9(4) COMP VALUE 0.     
           05  WS-ORDER-TYPE-CD             PIC X(5) VALUE 'MC001'.     
           05  WS-SCHEDULE                  PIC X(2) VALUE 'S'.         
           05  WS-SYSTEM-P                  PIC X(25)                   
               VALUE 'SYSTEM - PERIODIC TESTING'.                       
           05  WS-SYSTEM-R                  PIC X(25)                   
               VALUE 'SYSTEM - RANDOM TESTING'.                         
T16229     05  WS-SYSTEM                    PIC X(06) VALUE 'SYSTEM'.   
           05  WS-PRIORITY                  PIC X(1) VALUE '7'.         
           05  WS-WORK-TYPE-CD              PIC X(3) VALUE 'MTC'.       
           05  WS-WORK-DATE                 PIC X(10).                  
           05  FILLER REDEFINES WS-WORK-DATE.                           
               10  WS-WORK-YEAR             PIC X(04).                  
               10  FILLER                   PIC X(06).                  
           05  WS-WANTED-DATE-R.                                        
               10  WS-WANTED-YEAR           PIC X(04).                  
               10  FILLER                   PIC X(06) VALUE '-09-28'.   
           05  FILLER REDEFINES WS-WANTED-DATE-R.                       
               10  WS-WANTED-DATE           PIC X(10).                  
           05  WS-WORK-AMPM                 PIC X(1) VALUE 'P'.         
           05  WS-ROW-COUNT                 PIC S9(9) COMP VALUE ZERO.  
           05  WS-DAY                       PIC S9(4) COMP VALUE ZERO.  
T15090     05  WS-MAX-SO-INST-SEQ-NO        PIC S9(4) USAGE COMP.       
T15090     05  WS-NULL-IND                  PIC S9(04) COMP VALUE ZEROS.
           05  WS-CURRENT-TS                PIC X(26).                  
           05  WS-FOUND-BY                  PIC X(28)                   
               VALUE 'SYSTEM - RANDOM TEST'.                            
       01  WS-SWITCHES.                                                 
           05  WS-BAD-WORKING-DAY           PIC X(1).                   
               88  BAD-WORKING-DAY                    VALUE 'N'.        
               88  GOOD-WORKING-DAY                   VALUE 'Y'.        
HPCCDM*    EJECT                                                        00224500
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
HPCCDM*    EJECT                                                        00225500
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                  PIC X(08) VALUE 'SCSCA657'. 
HPCCDM*    EJECT                                                        00443000
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE               PIC X(02) VALUE SPACE.      
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC         PIC 99.                     
HPCCDM*    SKIP1                                                        00519000
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
HPCCDM*    SKIP1                                                        00035000
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
HPCCDM*    SKIP1                                                        00035000
           EXEC SQL                                                             
                INCLUDE TBMTRENV                                                
           END-EXEC.                                                            
HPCCDM*    SKIP1                                                        00035000
           EXEC SQL                                                             
                INCLUDE TBSODTMF                                                
           END-EXEC.                                                            
HPCCDM*    SKIP1                                                        00035000
           EXEC SQL                                                             
                INCLUDE TBSOOIMF                                                
           END-EXEC.                                                            
HPCCDM*    SKIP1                                                        00035000
           EXEC SQL                                                             
                INCLUDE TBMODEL                                                 
           END-EXEC.                                                            
HPCCDM*    SKIP1                                                        00035000
           EXEC SQL                                                             
                INCLUDE TBHLDAY                                                 
           END-EXEC.                                                            
HPCCDM*    SKIP1                                                        00035000
       01  WS-END                           PIC X(40)                   
           VALUE 'WORKING STORAGE FOR SCSCA657 ENDS HERE  '.            
HPCCDM*    EJECT                                                        00520500
      ****************************************************************          
      *                                                              *          
      *    LINKAGE SECTION FOR SCSCA657.  SCSCA657 IS A SUBPROGRAM   *          
      *    CALLED BY PROGRAM PCSCA650 & PCSCA656.                    *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       LINKAGE SECTION.                                                 
HPCCDM*    SKIP1                                                        00035000
       01  WS-LINKAGE-AREA.                                             
T16229     05  WS-SO-UTIL-TYPE              PIC X(01).                  
COB305     05 WS-NBR-METERS        PIC S9(3) COMP-3 VALUE 0.           
           05  WS-SO-DATE                   PIC X(10).                  
ACT018     05  WS-ARRAY OCCURS 110 TIMES.                               
COB305         10 WS-SO-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.          
               10  WS-SO-METER-NO           PIC X(9).                   
               10  WS-SO-TEST-TYPE          PIC X(01).                  
HPCCDM*    EJECT                                                                
       PROCEDURE DIVISION USING WS-LINKAGE-AREA.                        
HPCCDM*    SKIP1                                                        00035000
      ****************************************************************  00528000
      *                                                              *  00528500
      *    MAINLINE CONTROL LOGIC                                    *  00529000
      *                                                              *  00529500
      ****************************************************************  00530000
HPCCDM*    SKIP1                                                        00035000
       0000-MAINLINE.                                                   
           COMPUTE WS-SO-IDX = 1.                                       
           MOVE WS-SO-ACCT-NO(WS-SO-IDX) TO AT-ACCOUNT-NO.              
           MOVE WS-SO-ACCT-NO(WS-SO-IDX) TO MN-ACCOUNT-NO.              
           MOVE WS-SO-METER-NO(WS-SO-IDX) TO MN-METER-NO.               
           PERFORM 1000-PROCESS-LINKAGE-INPUT THRU 1000-EXIT            
               UNTIL WS-SO-IDX > WS-NBR-METERS.                         
           GOBACK.                                                      
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ****************************************************************          
      *                                                              *          
      *    POST METER EXCHANGE ORDERS USING INFORMATION PASSED FROM  *          
      *    CALLING PROGRAM                                           *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       1000-PROCESS-LINKAGE-INPUT.                                      
           PERFORM 2900-CALC-WANTED-BY-DATE THRU 2900-EXIT.             
           PERFORM 7000-SELECT-TIMESTAMP THRU 7000-EXIT.                
           MOVE WS-SO-ACCT-NO(WS-SO-IDX) TO AT-ACCOUNT-NO.              
           PERFORM 7300-GET-ACCOUNT THRU 7300-EXIT.                     
PCR566     IF SQLCODE       EQUAL NOT-FOUND                             
PCR566        DISPLAY 'RECORD NOT FOUND IN CSS_ACCOUNT'                 
PCR566        DISPLAY 'ACCOUNT NO ' AT-ACCOUNT-NO                       
PCR566        DISPLAY '7300-ABEND'  WS-ACTIVE-RETURN-CODE               
PCR566        ADD 1 TO WS-SO-IDX                                        
PCR566        GO TO 1000-EXIT                                           
PCR566     END-IF.                                                      
           MOVE WS-SO-ACCT-NO(WS-SO-IDX) TO MN-ACCOUNT-NO.              
           MOVE WS-SO-METER-NO(WS-SO-IDX) TO MN-METER-NO.               
T16229     MOVE WS-SO-UTIL-TYPE           TO MN-CODE-UTIL-TYPE.         
           PERFORM 7400-GET-MTRD-ENVRNMT THRU 7400-EXIT.                
PCR566     IF SQLCODE       EQUAL NOT-FOUND                             
PCR566        DISPLAY 'RECORD NOT FOUND IN CSS_MTRD_ENVRNMT'            
PCR566        DISPLAY 'ACCOUNT NO ' MN-ACCOUNT-NO                       
PCR566        DISPLAY 'METER NO   ' MN-METER-NO                         
PCR566        DISPLAY '7400-ABEND'  WS-ACTIVE-RETURN-CODE               
PCR566        ADD 1 TO WS-SO-IDX                                        
PCR566        GO TO 1000-EXIT                                           
PCR566     END-IF.                                                      
           PERFORM 3000-BUILD-SERVICE-ORDER THRU 3000-EXIT.             
           PERFORM 3100-BUILD-INSTRUCTIONS-REC THRU 3100-EXIT.          
           PERFORM 8000-INSERT-SO-REC THRU 8000-EXIT.                   
           PERFORM 8100-INSERT-SO-INSTRUC-REC THRU 8100-EXIT.           
           ADD 1 TO WS-SO-IDX.                                          
       1000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ****************************************************************          
      *                                                              *          
      *    DETERMINE THE WANTED BY DATE, EXCLUDING WEEK-ENDS AND     *          
      *    HOLIDAYS.                                                 *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       2900-CALC-WANTED-BY-DATE.                                        
           MOVE WS-SO-DATE TO WS-WORK-DATE.                             
           SET BAD-WORKING-DAY TO TRUE.                                 
           PERFORM UNTIL GOOD-WORKING-DAY                               
               PERFORM 7010-GET-NEXT-DAY THRU 7010-EXIT                 
               IF  WS-DAY > 0                                           
                 AND WS-DAY < 6                                         
                   PERFORM 7020-SELECT-HOLIDAY THRU 7020-EXIT           
                   IF  WS-ROW-COUNT = 0                                 
                       SET GOOD-WORKING-DAY TO TRUE                     
                   END-IF                                               
               END-IF                                                   
           END-PERFORM.                                                 
       2900-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ****************************************************************          
      *                                                              *          
      *    BUILD SERVICE ORDER RECORD                                *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       3000-BUILD-SERVICE-ORDER.                                        
           MOVE WS-SO-ACCT-NO(WS-SO-IDX) TO XE-ACCOUNT-NO.              
           MOVE ZEROES TO XE-AMT-DNP-AT-BILLING.                        
T19653     MOVE 'N'    TO XE-BACK-DATED.                                
TP6190     MOVE AT-COMPANY-NO TO XE-COMPANY-NO.                         
           MOVE WS-SO-DATE TO XE-DATE-RECVED.                           
           MOVE ZEROES TO XE-DEPOSIT-AMT.                               
           MOVE SPACES TO XE-INIT-BY-CONTRACT.                          
           MOVE AT-LOCAL-OFFICE TO XE-LOCAL-OFFICE.                     
           MOVE SPACES TO XE-MAKE-ARRANGEMENTS.                         
           MOVE SPACES TO XE-NOTIFY-CSR-IND.                            
           MOVE SPACES TO XE-NOTIFY-CUST-IND.                           
           IF  WS-SO-TEST-TYPE (WS-SO-IDX) EQUAL 'P'                    
               MOVE WS-SYSTEM-P TO XE-ORDER-PLACED-BY
           END-IF.                  
           IF  WS-SO-TEST-TYPE (WS-SO-IDX) EQUAL 'R'                    
               MOVE WS-SYSTEM-R TO XE-ORDER-PLACED-BY
           END-IF.                  
T16229     MOVE WS-SYSTEM TO XE-ORDER-RECVED-BY.                        
TP6190     MOVE SPACES TO XE-ORDER-REASON.                              
           MOVE ZEROES TO XE-ORDER-STAT-REASON-LEN.                     
           MOVE SPACES TO XE-ORDER-STAT-REASON-TEXT.                    
           MOVE WS-ORDER-TYPE-CD TO XE-ORDER-TYPE-CD.                   
           MOVE AT-PREMISE-NO TO XE-PREMISE-NO.                         
           MOVE WS-PRIORITY TO XE-ORDER-PRIORITY-CD.                    
           MOVE SPACES TO XE-RESP-AREA-ID.                              
           MOVE WS-SCHEDULE TO XE-SERV-ORDER-STATUS.                    
           MOVE WS-CURRENT-TS TO XE-SO-DATA-SEQ-NO.                     
           IF WS-SO-UTIL-TYPE = 'G'                                     
               MOVE WS-WORK-YEAR TO WS-WANTED-YEAR                      
               MOVE WS-WANTED-DATE TO XE-WANTED-BY-DATE                 
               MOVE WS-WANTED-DATE TO XE-DATE-RECVED                    
           ELSE                                                         
               MOVE WS-WORK-DATE TO XE-WANTED-BY-DATE                   
           END-IF.                                                      
           MOVE WS-WORK-AMPM TO XE-WANTED-BY-AM-PM.                     
TP6190     MOVE SPACES TO XE-WORK-INDICATOR.                            
       3000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ****************************************************************          
      *                                                              *          
      *    BUILD SERVICE ORDER INSTRUCTIONS RECORD                   *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       3100-BUILD-INSTRUCTIONS-REC.                                     
           MOVE MN-ACCOUNT-NO TO WB-ACCOUNT-NO.                         
           MOVE MN-CODE-UTIL-TYPE TO WB-CODE-UTIL-TYPE.                 
           MOVE MN-CODE-METER-LOC TO WB-CODE-METER-LOC.                 
T15090     MOVE WS-CURRENT-TS TO WB-SO-DATA-SEQ-NO.                     
T15090*COMMENTED PER PAULA AKEY. ALWAYS USE 1 FOR INST-SEQ-NO                   
T15090     MOVE +1                            TO WB-SO-INST-SEQ-NO      
           MOVE MN-METER-NO TO WB-METER-NO.                             
           MOVE MN-METER-SUPPLYING TO WB-METER-SUPPLYING.               
           MOVE WS-WORK-TYPE-CD TO WB-WORK-TYPE-CD.                     
       3100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ****************************************************************          
      *                                                              *          
      *    RETRIEVE THE CURRENT TIMESTAMP                            *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       7000-SELECT-TIMESTAMP.                                           
           EXEC SQL                                                     
               SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                 INTO :WS-CURRENT-TS                                    
                 FROM  CSS_MODEL_SQL                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CURRENT TIMESTAMP                                        
MFA-TR*          INTO :WS-CURRENT-TS                                            
MFA-TR*          FROM  CSS_MODEL_SQL                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7000-ABEND ' WS-ACTIVE-RETURN-CODE              
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        00035000
      ****************************************************************          
      *                                                              *          
      *    SELECT THE NEXT CURRENT DAY FROM CSS_MODEL_SQL            *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       7010-GET-NEXT-DAY.                                               
           EXEC SQL                                                     
T19683         SELECT  DATEADD( DAY, 2, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ),                    
T19683                 CIS.DAYS (DATEADD( DAY, 2, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))              
                           - (CIS.DAYS(DATEADD( DAY, 2, 
              IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))/7 * 7)                      
                INTO  :WS-WORK-DATE,                                    
                      :WS-DAY                                           
                FROM   CSS_MODEL_SQL                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DATE(:WS-WORK-DATE) + 2 DAYS,                            
MFA-TR*                DAYS (DATE(:WS-WORK-DATE) + 2 DAYS)                      
MFA-TR*                    - (INTEGER(DAYS(DATE(:WS-WORK-DATE)                  
MFA-TR*                    + 2 DAYS)/7) * 7)                                    
MFA-TR*         INTO  :WS-WORK-DATE,                                            
MFA-TR*               :WS-DAY                                                   
MFA-TR*         FROM   CSS_MODEL_SQL                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7010-ABEND ' WS-ACTIVE-RETURN-CODE              
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7010-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        00035000
      ****************************************************************          
      *                                                              *          
      *    DETERMINE IF THE DATE SPECIFIED IS A HOLIDAY              *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       7020-SELECT-HOLIDAY.                                             
           MOVE ZEROS TO WS-ROW-COUNT.                                  
           EXEC SQL                                                     
                SELECT  COUNT (*)                                       
                  INTO :WS-ROW-COUNT                                    
                  FROM  CSS_HOLIDAY                                     
                 WHERE  HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) )                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  COUNT (*)                                               
MFA-TR*           INTO :WS-ROW-COUNT                                            
MFA-TR*           FROM  CSS_HOLIDAY                                             
MFA-TR*          WHERE  HOLIDAY_DT = :WS-WORK-DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7020-ABEND ' WS-ACTIVE-RETURN-CODE              
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7020-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        00035000
      ****************************************************************          
      *                                                              *          
      *    GET DATA FROM CSS_ACCOUNT RECORD                          *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       7300-GET-ACCOUNT.                                                
           EXEC SQL                                                     
                SELECT  ACCOUNT_NO,                                     
                        LOCAL_OFFICE,                                   
                        PREMISE_NO,                                     
TP6190                  COMPANY_NO                                      
                  INTO :AT-ACCOUNT-NO,                                  
                       :AT-LOCAL-OFFICE,                                
                       :AT-PREMISE-NO,                                  
TP6190                 :AT-COMPANY-NO                                   
                  FROM  CSS_ACCOUNT                                     
                 WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR566     IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL OR        
PCR566         NOT-FOUND                                                
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7300-ABEND ' WS-ACTIVE-RETURN-CODE              
PCR566         DISPLAY 'ACCOUNT NO ' AT-ACCOUNT-NO                      
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7300-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        00035000
      ****************************************************************          
      *                                                              *          
      *    GET DATA FROM CSS_MTRD_ENVRNMT RECORD                     *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       7400-GET-MTRD-ENVRNMT.                                           
           EXEC SQL                                                     
                SELECT  ACCOUNT_NO,                                     
                        CODE_UTIL_TYPE,                                 
                        CODE_METER_LOC,                                 
                        METER_NO,                                       
                        METER_SUPPLYING                                 
                  INTO :MN-ACCOUNT-NO,                                  
T16229                 :MN-CODE-UTIL-TYPE,                              
                       :MN-CODE-METER-LOC,                              
                       :MN-METER-NO,                                    
                       :MN-METER-SUPPLYING                              
                  FROM  CSS_MTRD_ENVRNMT                                
                 WHERE  ACCOUNT_NO = :MN-ACCOUNT-NO                     
T16229             AND  CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE             
                   AND  METER_NO = :MN-METER-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR566     IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL OR        
PCR566         NOT-FOUND                                                
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7400-ABEND ' WS-ACTIVE-RETURN-CODE              
PCR566         DISPLAY 'ACCOUNT NO ' MN-ACCOUNT-NO                      
PCR566         DISPLAY 'METER NO   ' MN-METER-NO                        
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7400-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        00035000
      ****************************************************************          
      *                                                              *          
T15090*    SELECTS MAX SEQ NO FROM CSS_SO_ORD_INST_MF                *  00035000
T15090*                                                              *  00035000
T15090****************************************************************  00035000
HPCCDM*    SKIP1                                                        00035000
T15090 7700-SELECT-MAX-ORD-INST.                                        
T15090     EXEC SQL                                                     
T15090          SELECT  MAX(SO_INST_SEQ_NO)                             
T15090            INTO :WS-MAX-SO-INST-SEQ-NO :WS-NULL-IND              
T15090            FROM  CSS_SO_ORD_INST_MF                              
T15090     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T15090     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T15090     IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
T15090         IF WS-NULL-IND = -1                                      
T15090            MOVE 0  TO WS-MAX-SO-INST-SEQ-NO                      
T15090         END-IF                                                   
T15090     ELSE                                                         
T15090         DISPLAY '7700-SELECT-MAX-ORD-INST'                       
T15090         PERFORM 9900-ABEND THRU 9900-EXIT                        
T15090     END-IF.                                                      
T15090 7700-EXIT.                                                       
T15090     EXIT.                                                        
HPCCDM*    EJECT                                                        00035000
      ****************************************************************          
      *                                                              *          
      *    INSERT SERVICE ORDER RECORD                               *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       8000-INSERT-SO-REC.                                              
           EXEC SQL                                                     
                INSERT INTO  CSS_SO_DATA_MF                             
                            (ACCOUNT_NO,                                
                             AMT_DNP_AT_BILLING,                        
                             BACK_DATED,                                
TP6190                       COMPANY_NO,                                
                             DATE_RECVED,                               
                             DEPOSIT_AMT,                               
                             INIT_BY_CONTRACT,                          
                             LOCAL_OFFICE,                              
                             MAKE_ARRANGEMENTS,                         
                             NOTIFY_CSR_IND,                            
                             NOTIFY_CUST_IND,                           
                             ORDER_PLACED_BY,                           
                             ORDER_REASON,                              
                             ORDER_RECVED_BY,                           
                             ORDER_STAT_REASON,                         
                             ORDER_TYPE_CD,                             
                             PREMISE_NO,                                
                             ORDER_PRIORITY_CD,                         
                             RESP_AREA_ID,                              
                             SERV_ORDER_STATUS,                         
                             SO_DATA_SEQ_NO,                            
                             WANTED_BY_AM_PM,                           
                             WANTED_BY_DATE,                            
                             WORK_INDICATOR)                            
                      VALUES                                            
                           (:XE-ACCOUNT-NO,                             
                            :XE-AMT-DNP-AT-BILLING,                     
                            :XE-BACK-DATED,                             
TP6190                      :XE-COMPANY-NO,                             
                            IIF(TRY_CONVERT(DATE, :XE-DATE-RECVED
              ) IS NULL OR (PATINDEX('%.%', :XE-DATE-RECVED
              ) <> 0) OR (LEN(:XE-DATE-RECVED) <> 10), CIS.CHAR2DATE(
                                                        :XE-DATE-RECVED
              ), CONVERT(DATE, :XE-DATE-RECVED) ),                            
                            :XE-DEPOSIT-AMT,                            
                            :XE-INIT-BY-CONTRACT,                       
                            :XE-LOCAL-OFFICE,                           
                            :XE-MAKE-ARRANGEMENTS,                      
                            :XE-NOTIFY-CSR-IND,                         
                            :XE-NOTIFY-CUST-IND,                        
                            :XE-ORDER-PLACED-BY,                        
                            :XE-ORDER-REASON,                           
                            :XE-ORDER-RECVED-BY,                        
                            :XE-ORDER-STAT-REASON,                      
                            :XE-ORDER-TYPE-CD,                          
                            :XE-PREMISE-NO,                             
                            :XE-ORDER-PRIORITY-CD,                      
                            :XE-RESP-AREA-ID,                           
                            :XE-SERV-ORDER-STATUS,                      
                            CIS.CHAR2TIMESTAMP(:XE-SO-DATA-SEQ-NO),             
                            :XE-WANTED-BY-AM-PM,                        
                            IIF(TRY_CONVERT(DATE, :XE-WANTED-BY-DATE
              ) IS NULL OR (PATINDEX('%.%', :XE-WANTED-BY-DATE
              ) <> 0) OR (LEN(:XE-WANTED-BY-DATE
              ) <> 10), CIS.CHAR2DATE(:XE-WANTED-BY-DATE
              ), CONVERT(DATE, :XE-WANTED-BY-DATE) ),                         
                            :XE-WORK-INDICATOR)                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03467500
MFA-TR*         INSERT INTO  CSS_SO_DATA_MF                                     
MFA-TR*                     (ACCOUNT_NO,                                03467500
MFA-TR*                      AMT_DNP_AT_BILLING,                        03467500
MFA-TR*                      BACK_DATED,                                03467500
MFA-TR*                      COMPANY_NO,                                03467500
MFA-TR*                      DATE_RECVED,                                       
MFA-TR*                      DEPOSIT_AMT,                                       
MFA-TR*                      INIT_BY_CONTRACT,                                  
MFA-TR*                      LOCAL_OFFICE,                                      
MFA-TR*                      MAKE_ARRANGEMENTS,                                 
MFA-TR*                      NOTIFY_CSR_IND,                                    
MFA-TR*                      NOTIFY_CUST_IND,                                   
MFA-TR*                      ORDER_PLACED_BY,                                   
MFA-TR*                      ORDER_REASON,                                      
MFA-TR*                      ORDER_RECVED_BY,                                   
MFA-TR*                      ORDER_STAT_REASON,                                 
MFA-TR*                      ORDER_TYPE_CD,                                     
MFA-TR*                      PREMISE_NO,                                        
MFA-TR*                      ORDER_PRIORITY_CD,                                 
MFA-TR*                      RESP_AREA_ID,                                      
MFA-TR*                      SERV_ORDER_STATUS,                                 
MFA-TR*                      SO_DATA_SEQ_NO,                                    
MFA-TR*                      WANTED_BY_AM_PM,                                   
MFA-TR*                      WANTED_BY_DATE,                                    
MFA-TR*                      WORK_INDICATOR)                                    
MFA-TR*               VALUES                                                    
MFA-TR*                    (:XE-ACCOUNT-NO,                             03467500
MFA-TR*                     :XE-AMT-DNP-AT-BILLING,                     03467500
MFA-TR*                     :XE-BACK-DATED,                                     
MFA-TR*                     :XE-COMPANY-NO,                             03467500
MFA-TR*                     :XE-DATE-RECVED,                                    
MFA-TR*                     :XE-DEPOSIT-AMT,                                    
MFA-TR*                     :XE-INIT-BY-CONTRACT,                               
MFA-TR*                     :XE-LOCAL-OFFICE,                                   
MFA-TR*                     :XE-MAKE-ARRANGEMENTS,                              
MFA-TR*                     :XE-NOTIFY-CSR-IND,                                 
MFA-TR*                     :XE-NOTIFY-CUST-IND,                                
MFA-TR*                     :XE-ORDER-PLACED-BY,                                
MFA-TR*                     :XE-ORDER-REASON,                                   
MFA-TR*                     :XE-ORDER-RECVED-BY,                                
MFA-TR*                     :XE-ORDER-STAT-REASON,                              
MFA-TR*                     :XE-ORDER-TYPE-CD,                                  
MFA-TR*                     :XE-PREMISE-NO,                                     
MFA-TR*                     :XE-ORDER-PRIORITY-CD,                              
MFA-TR*                     :XE-RESP-AREA-ID,                                   
MFA-TR*                     :XE-SERV-ORDER-STATUS,                              
MFA-TR*                     :XE-SO-DATA-SEQ-NO,                                 
MFA-TR*                     :XE-WANTED-BY-AM-PM,                                
MFA-TR*                     :XE-WANTED-BY-DATE,                                 
MFA-TR*                     :XE-WORK-INDICATOR)                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8000-ABEND ' WS-ACTIVE-RETURN-CODE              
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       8000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        00035000
      ****************************************************************          
      *                                                              *          
      *    INSERT SERVICE ORDER INSTRUCTIONS RECORD                  *          
      *                                                              *          
      ****************************************************************          
HPCCDM*    SKIP1                                                        00035000
       8100-INSERT-SO-INSTRUC-REC.                                      
           EXEC SQL                                                     
               INSERT INTO CSS_SO_ORD_INST_MF                           
                   (ACCOUNT_NO,                                         
                    CODE_UTIL_TYPE,                                     
                    CODE_METER_LOC,                                     
                    METER_NO,                                           
                    METER_SUPPLYING,                                    
                    SO_DATA_SEQ_NO,                                     
                    SO_INST_SEQ_NO,                                     
                    WORK_TYPE_CD)                                       
               VALUES                                                   
                   (:WB-ACCOUNT-NO,                                     
                    :WB-CODE-UTIL-TYPE,                                 
                    :WB-CODE-METER-LOC,                                 
                    :WB-METER-NO,                                       
                    :WB-METER-SUPPLYING,                                
                    CIS.CHAR2TIMESTAMP(:WB-SO-DATA-SEQ-NO),                     
                    :WB-SO-INST-SEQ-NO,                                 
                    :WB-WORK-TYPE-CD)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03467500
MFA-TR*        INSERT INTO CSS_SO_ORD_INST_MF                                   
MFA-TR*            (ACCOUNT_NO,                                                 
MFA-TR*             CODE_UTIL_TYPE,                                             
MFA-TR*             CODE_METER_LOC,                                             
MFA-TR*             METER_NO,                                                   
MFA-TR*             METER_SUPPLYING,                                            
MFA-TR*             SO_DATA_SEQ_NO,                                             
MFA-TR*             SO_INST_SEQ_NO,                                             
MFA-TR*             WORK_TYPE_CD)                                               
MFA-TR*        VALUES                                                           
MFA-TR*            (:WB-ACCOUNT-NO,                                             
MFA-TR*             :WB-CODE-UTIL-TYPE,                                         
MFA-TR*             :WB-CODE-METER-LOC,                                         
MFA-TR*             :WB-METER-NO,                                               
MFA-TR*             :WB-METER-SUPPLYING,                                        
MFA-TR*             :WB-SO-DATA-SEQ-NO,                                         
MFA-TR*             :WB-SO-INST-SEQ-NO,                                         
MFA-TR*             :WB-WORK-TYPE-CD)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
               NEXT SENTENCE                                            
           ELSE                                                         
                 DISPLAY '8100-ABEND ' WS-ACTIVE-RETURN-CODE            
                 PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                     
       8100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        00035000
      ******************************************************************03629000
      *                                                                *03629500
      *    TERMINATE PROCESSING - CLOSE FILES                          *03630000
      *                                                                *03631500
      ******************************************************************03632000
HPCCDM*    SKIP1                                                        00035000
       9000-TERMINATE.                                                  
HPCCDM*    SKIP1                                                        00035000
       9000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        03635500
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
