       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. SCSCA202.                                            
       DATE-WRITTEN.   DECEMBER, 2009.                                  
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **              --------------------------                     **         
      **    DATE    INITIALS   REASON                                **         
      **  --------  --------   ------                                **         
      **  12/14/09  SATISH S   PROGRAM ORIGINALLY WRITTEN            **         
A04359**  11/29/12  HA7A338    SALES TAX EXEMPTION CHANGES FOR SEB   **         
A04359**                       GEORGIA MANUFACTURE ACCOUNTS-APPL04359**         
CRISPC**  12/22/12  HA7A338    CRISP COUNTY CHANGES                  **         
      ******************************************************************        
           REMARKS.                                                     
      *     TAX SPLITTER FOR REVENU REPORTING.                                  
      *     ALL TAX PERTAINING TO THE REVENUE DISTRIC CODE IS                   
      *     RETRIEVED BASED ON THE REVENUE MONTH AND ENERGY FLAG.               
      *     IF STATE TAX EXEMPTION CODE IS PASSED THEN THE TAX CONTROL          
      *     NUMBER IS FOUND FROM CSS_TAX_EXMPT_CODE TABLE. TAX IS               
      *     THEN RETRIEVED FROM FROM TAX CONTROL TABLE.                         
      *                                                                         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA202'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR SCSCA202 STARTS HERE'.            
                                                                        
       01  WS-MISC.                                                     
           05  WS-DATE-FROM            PIC X(10) VALUE SPACES.          
           05  WS-DATE-FROM-FMT.                                        
               10  WS-FROM-CCYY        PIC X(04) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-FROM-MM          PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  FILLER              PIC X(02) VALUE '01'.            
           05  WS-DATE-TO              PIC X(10) VALUE SPACES.          
           05  WS-DATE-TO-FMT.                                          
               10  WS-TO-CCYY          PIC X(04) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-TO-MM            PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-TO-DD            PIC X(02) VALUE SPACES.          
           05  WS-REV-MTH-NUM          PIC 9(06) VALUE 0.               
           05  WS-REV-MTH-X REDEFINES                                   
                   WS-REV-MTH-NUM      PIC X(06).                       
           05  WS-REV-MTH-CCYY-MM.                                      
               10  WS-REV-MTH-CCYY     PIC X(04) VALUE SPACES.          
               10  WS-REV-MTH-MM       PIC X(02) VALUE SPACES.          
           05  WS-REV-MTH-CCYY-NUM     PIC 9(04) VALUE 0.               
           05  WS-QUOTIENT             PIC 9(04) VALUE 0.               
           05  WS-REMAINDER            PIC 9(02) VALUE 0.               
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
           05  WS-S                    PIC S9(04) COMP VALUE 0.         
           05  WS-I                    PIC S9(04) COMP VALUE 0.         
           05  WS-SUB                  PIC S9(04) COMP VALUE 0.         
           05  WS-SPCL-FCTR-ID         PIC X(09) VALUE SPACES.          
           05  WS-SPCL-TAX-CNTRL-NO    PIC S9(4) COMP VALUE 0.          
           05  WS-ELEC-FLAG            PIC X(01) VALUE SPACE.           
           05  WS-GAS-FLAG             PIC X(01) VALUE SPACE.           
                                                                        
       01  WS-END                      PIC X(40)                        
           VALUE 'WORKING STORAGE FOR SCSCA202 STARTS HERE'.            
                                                                        
       01 WS-TAX-EXMPT-CODE-TABLE.                                      
          05  WS-TAX-EXMPT-RECORDS OCCURS 50 TIMES.                     
              10  WS-TAX-EXEMPT-CODE  PIC X(01).                        
              10  WS-TAX-CNTRL-NO     PIC S9(4) USAGE COMP.             
              10  WS-FACTOR-ID        PIC X(09).                        
                                                                        
       01 WS-LITERALS.                                                  
          05  WS-PROGRAM-NAME          PIC X(08) VALUE 'SCSCA202'.      
          05  WS-E                     PIC X(01) VALUE 'E'.             
          05  WS-G                     PIC X(01) VALUE 'G'.             
          05  WS-Y                     PIC X(01) VALUE 'Y'.             
          05  WS-N                     PIC X(01) VALUE 'N'.             
          05  WS-A                     PIC X(01) VALUE 'A'.             
A04359    05  WS-COUNTY-TAX-TYPE       PIC X(01) VALUE 'C'.             
A04359    05  WS-GA-MFG-SALES-TAX-XMT  PIC X(01) VALUE 'X'.             
          05  WS-50                    PIC 9(02) VALUE 50.              
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-TAX-CSR              PIC X(01).                       
               88  WS-TAX-CSR-EXISTS             VALUE 'Y'.             
               88  WS-TAX-CSR-NOT-EXISTS         VALUE 'N'.             
           05  WS-PSNC-TAX-XMPT-CSR    PIC X(01).                       
               88  WS-PSNC-TAX-XMPT-EXISTS       VALUE 'Y'.             
               88  WS-PSNC-TAX-XMPT-NOT-EXISTS   VALUE 'N'.             
           05  WS-TAX-EXMPT-CODE-CSR   PIC X(01).                       
               88  WS-TAX-EXMPT-CODE-EXISTS      VALUE 'Y'.             
               88  WS-TAX-EXMPT-CODE-NOT-EXISTS  VALUE 'N'.             
           05  WS-TAX-EXMPT-LOAD       PIC X(01) VALUE 'N'.             
               88  WS-TAX-EXMPT-LOADED           VALUE 'Y'.             
               88  WS-TAX-EXMPT-NOT-LOADED       VALUE 'N'.             
           05  WS-TAX-EXMPT            PIC X(01).                       
               88  WS-TAX-EXMPT-FOUND            VALUE 'Y'.             
               88  WS-TAX-EXMPT-NOT-FOUND        VALUE 'N'.             
                                                                        
      *** ERROR PROCESSING COPYBOOK FOR DB2                                     
       COPY CWS00303.                                                           
                                                                        
      *** SQL COMMUNICATION AREA                                                
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *** CSS_TAX_CNTL TC                                                       
           EXEC SQL                                                             
              INCLUDE TBTXCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_TAX_RATE TR                                                       
           EXEC SQL                                                             
              INCLUDE TBTXRATE                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_TAX_USE_CNTL TU                                                   
           EXEC SQL                                                             
              INCLUDE TBTXUSE                                                   
           END-EXEC.                                                            
                                                                        
      *** CSS_TAX_EXMPT_CODE F1                                                 
           EXEC SQL                                                             
              INCLUDE TBTXMPCD                                                  
           END-EXEC.                                                            
                                                                        
      *** CSS_SPCL_FCTR SF                                                      
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
A04359*** CSS_TAX_EXCISE_AMT X6                                                 
A04359     EXEC SQL                                                             
A04359        INCLUDE TBEXCISE                                                  
A04359     END-EXEC.                                                            
A04359                                                                  
     *******************************************************************        
     ***                   CURSOR DEFINITION                         ***        
     *******************************************************************        
      *** CURSOR TO RETREIEVE ALL TAXES (EXCLUDES SERVICE TAX #)                
                                                                        
           EXEC SQL                                                     
              DECLARE TAX_CSR CURSOR FOR                                
                 SELECT TC.TAX_TYPE                                     
                       ,TC.TAX_CNTRL_NO                                 
                       ,TR.DATE_FROM                                    
                       ,TC.FACTOR_ID                                    
                       ,TR.TAX_RATE                                     
                       ,TU.TAX_ELEC                                     
                       ,TU.TAX_GAS                                      
CRISPC                 ,TC.CODE_APPL_COND                               
                 FROM   CSS_TAX_CNTL TC WITH(READUNCOMMITTED)                   
                       ,CSS_TAX_RATE TR WITH(READUNCOMMITTED)                   
                       ,CSS_TAX_USE_CNTL TU WITH(READUNCOMMITTED)               
                 WHERE  TR.OPER_MODE        = 'A'                       
                 AND    TR.DATE_FROM       <= IIF(TRY_CONVERT(DATE, 
                                                          :TR-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-FROM
              ) <> 0) OR (LEN(:TR-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :TR-DATE-FROM
              ), CONVERT(DATE, :TR-DATE-FROM) )             
                 AND    TR.DATE_TO         >= IIF(TRY_CONVERT(DATE, 
                                                            :TR-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-TO) <> 0) OR (LEN(
                                                            :TR-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:TR-DATE-TO), CONVERT(DATE, 
                                                            :TR-DATE-TO
              ) )               
                 AND    TR.DETAIL_ID        = :TR-DETAIL-ID             
                 AND    TC.ENERGY_TAX_FL   <> '#'                       
                 AND    TR.OPER_MODE        = TC.OPER_MODE              
                 AND    TC.OPER_MODE        = TU.OPER_MODE              
                 AND    TR.TAX_CNTRL_NO     = TC.TAX_CNTRL_NO           
                 AND    TC.TAX_CNTRL_NO     = TU.TAX_CNTRL_NO           
                 AND    TR.TAX_ENTRY_SEQ_NO = TU.TAX_ENTRY_SEQ_NO       
                 AND    TU.DETAIL_ID        = TR.DETAIL_ID              
                 ORDER  BY TC.TAX_TYPE DESC                             
                          ,TR.DETAIL_ID                                 
                          ,TC.TAX_CNTRL_NO                              
                          ,TR.DATE_FROM DESC                            
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TAX_CSR CURSOR FOR                                        
MFA-TR*          SELECT TC.TAX_TYPE                                             
MFA-TR*                ,TC.TAX_CNTRL_NO                                         
MFA-TR*                ,TR.DATE_FROM                                            
MFA-TR*                ,TC.FACTOR_ID                                            
MFA-TR*                ,TR.TAX_RATE                                             
MFA-TR*                ,TU.TAX_ELEC                                             
MFA-TR*                ,TU.TAX_GAS                                              
MFA-TR*                ,TC.CODE_APPL_COND                                       
MFA-TR*          FROM   CSS_TAX_CNTL TC                                         
MFA-TR*                ,CSS_TAX_RATE TR                                         
MFA-TR*                ,CSS_TAX_USE_CNTL TU                                     
MFA-TR*          WHERE  TR.OPER_MODE        = 'A'                               
MFA-TR*          AND    TR.DATE_FROM       <= :TR-DATE-FROM                     
MFA-TR*          AND    TR.DATE_TO         >= :TR-DATE-TO                       
MFA-TR*          AND    TR.DETAIL_ID        = :TR-DETAIL-ID                     
MFA-TR*          AND    TC.ENERGY_TAX_FL   = '#'                               
MFA-TR*          AND    TR.OPER_MODE        = TC.OPER_MODE                      
MFA-TR*          AND    TC.OPER_MODE        = TU.OPER_MODE                      
MFA-TR*          AND    TR.TAX_CNTRL_NO     = TC.TAX_CNTRL_NO                   
MFA-TR*          AND    TC.TAX_CNTRL_NO     = TU.TAX_CNTRL_NO                   
MFA-TR*          AND    TR.TAX_ENTRY_SEQ_NO = TU.TAX_ENTRY_SEQ_NO               
MFA-TR*          AND    TU.DETAIL_ID        = TR.DETAIL_ID                      
MFA-TR*          ORDER  BY TC.TAX_TYPE DESC                                     
MFA-TR*                   ,TR.DETAIL_ID                                         
MFA-TR*                   ,TC.TAX_CNTRL_NO                                      
MFA-TR*                   ,TR.DATE_FROM DESC                                    
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      *** CURSOR TO LOAD CSS_TAX_EXMPT_CODE TABLE FOR SPECIAL SCENARIOS         
           EXEC SQL                                                     
              DECLARE TAX_EXMPT_CODE_CSR CURSOR FOR                     
                 SELECT TAX_EXEMPT_CODE                                 
                       ,TAX_CNTRL_NO                                    
                       ,FACTOR_ID                                       
                 FROM CSS_TAX_EXMPT_CODE F1 WITH(READUNCOMMITTED)               
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TAX_EXMPT_CODE_CSR CURSOR FOR                             
MFA-TR*          SELECT TAX_EXEMPT_CODE                                         
MFA-TR*                ,TAX_CNTRL_NO                                            
MFA-TR*                ,FACTOR_ID                                               
MFA-TR*          FROM CSS_TAX_EXMPT_CODE F1                                     
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
      *** WS ABEND WORK AREA                                                    
       COPY CWS00010.                                                           
                                                                        
      *** WS FOR COPYBOOK                                                       
       COPY CWS00202.                                                           
                                                                        
       01  RS-RETURN-CODE               PIC S9(04) COMP VALUE 0.        
                                                                        
       PROCEDURE DIVISION USING                                         
                          WS-CWS00202,                                  
                          ABEND-FILE,                                   
                          RS-RETURN-CODE.                               
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-MAIN-PROCESS         THRU 0100-CPD202-EXIT.     
           PERFORM 9999-SCSCA202-EXIT        THRU 9999-EXIT.            
                                                                        
       0000-SCSCA202-EXIT.                                              
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00202                                                  
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      **  9700-PROCESS-ABEND.                                       **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      *                                                                         
       9900-ABEND.                                                      
                                                                        
           PERFORM 9999-SCSCA202-EXIT  THRU 9999-EXIT.                  
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-SCSCA202-EXIT.                                              
                                                                        
           GOBACK.                                                      
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
