       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA195.                                        
       AUTHOR.         DANIE BOOTHA                                     
       DATE-WRITTEN.   JANUARY 2008.                                    
      ***************************************************************** 00050000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00060000
      ***************************************************************** 00070000
      **                                                             ** 00080000
      **              PROGRAM  MODIFICATION  LOG                     ** 00090000
      **                                                             ** 00100000
      **    DATE    INITIALS     REASON                              ** 00110000
      **  --------  --------     ----------------------------------  ** 00120000
      **  01/2008   DB41297      INITIAL VERSION OF PROGRAM          ** 00130000
      **  02/2008   PA94870      CHECK FIXED RATES, SET FLAGS, RETURN** 00140000
      **                         NECESSARY VARIABLES, DUMP TABLES AND** 00150000
      **                         RETURN THEM TO CALLING PGM          ** 00160000
      **  07/2008   DB41297      FIX ISSUE WITH CANCEL REBILLS       ** 00170000
      **  01/2009   GOKUL        PROCESS DISP CREDIT MESSAGE         ** 00180000
I00177**  02/2009   RV97439      REMOVE INDEX HARDCODING FOR TABLE   ** 00190000
I00177**                         WS-BILLING-COMPONENT                ** 00200000
A00093**  03/2009   EM19682      PRODUCE THE CORRECT 30-DAY LETTER   ** 00210000
A00307**  04/2009   EM19682      DISPLAY CURRENT OPTION DESCRIPTION  ** 00211000
A01404**  04/2009   RAJ          JULY CYCLE 1 CHANGES.               ** 00212000
PRJ172**  07/2009   RAJ          REGULATED PROVIDER TRANSISTION.     ** 00213000
PRJ211**  10/2009   ALEX         PRE-RENEWAL PROJECT                 ** 00214000
P00269**  02/2010   DMS          ADDED NEW COLUMNS TO CURSORS        ** 00215000
A03019**  03/2011   RAJ          FATAL DATABASE ERROR HANDLING.      ** 00216000
P00453**  08/2011   RAJ          SCANA ENERGY PRE-PAY                ** 00216100
A03303**  09/2011   SV95326      FIXED FACTOR PRECISION CHANGES.     ** 00216200
P00473**  08/2011   SV           RATE ENTRY - BUSINESS PROCESS ADVISOR* 00216300
A03819**  12/2011   SV           CORRECT ORDER OF BT RECORDS FOR     ** 00216400
A03819**                  IDENTIFICATION OF FIXED VS VARIABLE RATES  ** 00216500
A03019**  03/2012   SV           INITIALIZE SCSCA195 VARIABLES.      ** 00216600
A05460**  01/22/16  MS7M727      REMOVED USUSED COPYBOOK AND LOC1    ** 00216702
A05460**            ACT015                                           ** 00216802
      ***************************************************************** 00216901
                                                                        
      ***************************************************************** 00217101
      **  SCSCA195 DETERMINES THE GROUP2 VALUES FOR SEB RATE         ** 00217201
      **  REENGINEERING.                                             ** 00218000
      ***************************************************************** 00219000
      *                                                                 00220000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
      *                                                                 00250000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00280000
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-OPT-DESC  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-MKT-TIER-ADJ  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA195'.
MSQ017     COPY MFASQLM.
      *                                                                 00300000
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                PIC X(08) VALUE 'SCSCA195'.  
           05  WS-PROG-NM                  PIC X(08).                   
           05  WS-SUB                      PIC 9(2)     VALUE ZEROS.    
COB305     05 WS-SUB1        PIC S9(5) COMP-3 VALUE 0.            
COB305     05 WS-SUB2        PIC S9(5) COMP-3 VALUE 0.            
COB305     05 WS-SUB3        PIC S9(5) COMP-3 VALUE 0.            
COB305     05 WS-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.           
COB305     05 WS-REMAIN-NO        PIC S9(3) COMP-3 VALUE 0.            
           05  WS-START-DATE               PIC X(10).                   
           05  WS-HOLD-DATE-ORIG-BILL-BG   PIC X(10).                   
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
           05  WS-ABEND-SWITCH             PIC X(3).                    
               88  WS-ABEND-YES                         VALUE 'YES'.    
           05  WS-FIRST-TIME-SW            PIC X(3) VALUE 'YES'.        
               88  FIRST-TIME-SW                        VALUE 'YES'.    
           05  WS-SCSCB063                 PIC X(8) VALUE 'SCSCB063'.   
           05  WS-SCSCA328                 PIC X(8) VALUE 'SCSCA328'.   
           05  OPT-CNT                     PIC S9(5) COMP-3 VALUE +0.   
           05  MKT-CNT                     PIC S9(5) COMP-3 VALUE +0.   
           05  WS-REBILL-IMMEDIATE-FLAG PIC X(01) VALUE 'N'.            
           05  WS-REBILL-FLAG           PIC X(01) VALUE 'N'.            
           05  WS-ONCYCLE-FLAG          PIC X(01) VALUE 'N'.            
                                                                        
       01  WS-BILL-PRT-MSG-CD          PIC X(3).                        
           88  FIXED-PRICE                          VALUE               
              'FPN' 'FPL' 'FPM' 'FPH'.                                  
           88  FIXED-PRICE-AND-CSC                  VALUE               
              'FPN' 'FPL' 'FPM' 'FPH' 'CSC'.                            
           88  FIXED-PRICE-NORMAL                   VALUE 'FPN'.        
           88  FIXED-PRICE-GRP2-LOW-CSC             VALUE 'FPL'.        
           88  FIXED-PRICE-GRP2-MED-CSC             VALUE 'FPM'.        
           88  FIXED-PRICE-GRP2-HI-CSC              VALUE 'FPH'.        
           88  FREE-CSC                             VALUE 'CSC'.        
I00121     88  CUST-CRED-EXP                        VALUE 'CCE'.        
           88  FREE-BILL-CREDIT                     VALUE 'BCR'.        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08) VALUE 'SCSCA195'.  
      *                                                                 00690000
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
      *                                                                 00730000
       01  OPT-DESC-TABLE.                                              
           05  OPT-DESC-TBL OCCURS 0 TO 9999                            
               DEPENDING ON OPT-CNT                                     
               ASCENDING KEY OPT-KEY                                    
               INDEXED BY OPT-IND.                                      
               10  OPT-KEY.                                             
                   15 OPTION-CD            PIC X(12).                   
               10 OPTION-RATE              PIC X(3).                    
               10 OPTION-DESC              PIC X(100).                  
A00307         10 CURR-OPTION-DESC         PIC X(100).                  
      *                                                                 00840000
       01 WS-MKT-TIER-ADJ-TABLE.                                        
           05  WS-MKT-TIER-ADJ-TBL  OCCURS 0 TO 9999                    
               DEPENDING ON MKT-CNT                                     
               ASCENDING KEY WS-MKT-TIER-ADJ-KEY                        
               INDEXED BY MKT-IND.                                      
               10  WS-MKT-TIER-ADJ-KEY           PIC S9(04) COMP.       
               10  WS-MIN-GOOD-PAY-QTY-T     PIC S9(04) COMP.           
                                                                        
       01 WS-VARIABLES.                                                 
          05 WS-MISC-IDX                  PIC 9(09) COMP-3 VALUE 0.     
          05 WS-IND-IDX                   PIC 9(09) COMP-3 VALUE 0.     
          05 WS-ADJ-SUB                   PIC 9(04) COMP-3 VALUE 0.     
          05 WS-ROW-COUNT-TIER-ADJ     PIC S9(09) USAGE COMP VALUE 0.   
          05 WS-ROW-COUNT-OPT-CD       PIC S9(09) USAGE COMP VALUE 0.   
          05 WS-ERR-TEXT                  PIC X(255) VALUE SPACES.      
COB305    05 WS-BG-CNT        PIC S9(3) COMP-3 VALUE 0.             
COB305    05 WS-FH-CNT        PIC S9(3) COMP-3 VALUE 0.             
COB305    05 WS-BA-CNT        PIC S9(3) COMP-3 VALUE 0.             
COB305    05 WS-BT-CNT        PIC S9(3) COMP-3 VALUE 0.             
COB305    05 WS-BC-CNT        PIC S9(3) COMP-3 VALUE 0.             
COB305    05 WS-DD-CNT        PIC S9(3) COMP-3 VALUE 0.             
COB305    05 WS-DF-CNT        PIC S9(3) COMP-3 VALUE 0.             
          05 WS-REG-GROUP-CD              PIC X(3).                     
          05 WS-MKT-PROGRAM-CD            PIC X(2).                     
          05 WS-RT-CALC-TYP-CD            PIC X(2) VALUE SPACES.        
          05 WS-RATE-DEFINITION-CD        PIC X(1).                     
          05 WS-STATUS-EFF-REV-MTH        PIC S9(09) COMP.              
          05 WS-STATUS-EFF-REV-DF         PIC S9(09) COMP.              
                                                                        
      *   THE FOLLOWING HOST VARIABLES ARE FOR CRM_MKT_TIER_ADJ         01140000
       01 WS-MKT-TIER-ADJ-HV.                                           
          05 WS-ADJ-TIER-SEQ-NO-HV   PIC S9(04) COMP OCCURS 100 TIMES.  
          05 WS-MIN-GOOD-PAY-QTY-HV  PIC S9(04) COMP OCCURS 100 TIMES.  
      *   END HOST VARIABLES FOR CRM_MKT_TIER_ADJ                       01180000
      *   THE FOLLOWING HOST VARIABLES ARE FOR CRM_RT_PKG_OPTION        01190000
       01 WS-OPT-DESC-HV.                                               
          05 WS-OPTION-CD-HV         PIC X(12) OCCURS 100 TIMES.        
          05 WS-REN-DESC-LONG-HV     PIC X(100) OCCURS 100 TIMES.       
          05 WS-INT-DESC-LONG-HV     PIC X(100) OCCURS 100 TIMES.       
          05 WS-CURR-EXT-DESC-LONG-HV PIC X(100) OCCURS 100 TIMES.      
          05 WS-RATE-PLAN-NO-HV      PIC X(3) OCCURS 100 TIMES.         
      *   END HOST VARIABLES FOR CRM_MKT_TIER_ADJ                       01260000
                                                                        
      *                                                                 01280000
           COPY CWS00010.                                               01290000
           COPY CWS00303.                                               01300000
      *                                                                 01310000
      ***************************************************************   01320000
      *    DB2 COMMUNICATION REQUIREMENT *                              01330000
      ***************************************************************   01340000
       01  ERROR-MESSAGE.                                               
           02  ERROR-LEN           PIC S9(4)  COMP VALUE +1320.         
           02  ERROR-TEXT          PIC X(132) OCCURS 10 TIMES           
                                 INDEXED BY ERROR-INDEX.                
       77   ERROR-TEXT-LEN       PIC S9(9)  COMP VALUE +132.            
       77  TRACE-MESSAGE-AREA    PIC X(256).                            
       77  OPENFN                PIC X(12).                             
       77  SSID                  PIC X(4).                              
       77  PLANNAME              PIC X(8).                              
       77  RETCODE               PIC S9(5).                             
       77  REASCODE              PIC S9(5).                             
       77  CLOSFN                PIC X(12).                             
       77  TERMOP                PIC X(4).                              
      /                                                                 01500000
           EXEC SQL                                                     01510000
             INCLUDE CWS00063                                           01520000
           END-EXEC.                                                    01530000
      /                                                                 01540000
           EXEC SQL                                                     01550000
               INCLUDE SQLCA                                            01560000
           END-EXEC.                                                    01570000
      /                                                                 01580000
           EXEC SQL                                                     01590000
             INCLUDE TBJBPARM                                           01600000
           END-EXEC.                                                    01610000
      /                                                                 01620000
           EXEC SQL                                                     01630000
             INCLUDE TBOFFOPT                                           01640000
           END-EXEC.                                                    01650000
      /                                                                 01660000
      * COBOL DECLARATION FOR TABLE CSS_FIXED_FCTR                      01670000
                                                                        
           EXEC SQL                                                     01690000
                INCLUDE TBFXDFCT                                        01700000
           END-EXEC.                                                    01710000
      /                                                                 01780000
           EXEC SQL                                                     01790000
                INCLUDE TBMKTTAD                                        01800000
           END-EXEC.                                                    01810000
      /                                                                 01820000
           EXEC SQL                                                     01830000
                INCLUDE TBOFFMKT                                        01840000
           END-EXEC.                                                    01850000
      /                                                                 01860000
           EXEC SQL                                                     
              DECLARE OPT_DESC      CURSOR WITH ROWSET POSITIONING FOR  
              SELECT OPTION_CD                                          
                    ,COALESCE(RENEWAL_DESC_LONG,'  ')                      
                    ,COALESCE(OPT_DESC_INT_LONG,'  ')                      
                    ,COALESCE(CURR_EXT_DESC_LONG,'  ')                     
                    ,COALESCE(RATE_PLAN_NO,'  ')                           
                FROM CRM_RT_PKG_OPTION WITH(READUNCOMMITTED)                    
              WHERE STATUS_CD = 'A'                                     
P00473          AND OPT_VSTART_TS   <= CIS.CURRENT$TIMESTAMP()                
P00473          AND OPT_VEND_TS     >= CIS.CURRENT$TIMESTAMP()                
P00473          AND PROC_STATUS_CD  = 'AC'                              
              ORDER BY OPTION_CD                                        
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     01870000
MFA-TR*       DECLARE OPT_DESC      CURSOR WITH ROWSET POSITIONING FOR  01880000
MFA-TR*       SELECT OPTION_CD                                          01890000
MFA-TR*             ,VALUE(RENEWAL_DESC_LONG,'  ')                      01900000
MFA-TR*             ,VALUE(OPT_DESC_INT_LONG,'  ')                      01910000
MFA-TR*             ,VALUE(CURR_EXT_DESC_LONG,'  ')                     01920000
MFA-TR*             ,VALUE(RATE_PLAN_NO,'  ')                           01930000
MFA-TR*         FROM CRM_RT_PKG_OPTION                                  01940000
MFA-TR*       WHERE STATUS_CD = 'A'                                     01950000
MFA-TR*         AND OPT_VSTART_TS   <= CURRENT TIMESTAMP                01960000
MFA-TR*         AND OPT_VEND_TS     >= CURRENT TIMESTAMP                01970000
MFA-TR*         AND PROC_STATUS_CD  = 'AC'                              01980000
MFA-TR*       ORDER BY OPTION_CD                                        01990000
MFA-TR*       FOR FETCH ONLY WITH UR                                    02000000
MFA-TR*    END-EXEC.                                                    02010000
      /                                                                 02020000
           EXEC SQL                                                     
               DECLARE MKT_TIER_ADJ CURSOR WITH ROWSET POSITIONING FOR  
               SELECT                                                   
                      ADJ_TIER_SEQ_NO,                                  
                      MIN_GOOD_PAY_QTY                                  
                 FROM CRM_MKT_TIER_ADJ WITH(READUNCOMMITTED)                    
                 WHERE MIN_GOOD_PAY_QTY IS NOT NULL                     
                 ORDER BY ADJ_TIER_SEQ_NO                               
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02030000
MFA-TR*        DECLARE MKT_TIER_ADJ CURSOR WITH ROWSET POSITIONING FOR  02040000
MFA-TR*        SELECT                                                   02050000
MFA-TR*               ADJ_TIER_SEQ_NO,                                  02060000
MFA-TR*               MIN_GOOD_PAY_QTY                                  02070000
MFA-TR*          FROM CRM_MKT_TIER_ADJ                                  02080000
MFA-TR*          WHERE MIN_GOOD_PAY_QTY IS NOT NULL                     02090000
MFA-TR*          ORDER BY ADJ_TIER_SEQ_NO                               02100000
MFA-TR*          FOR FETCH ONLY WITH UR                                 02110000
MFA-TR*    END-EXEC.                                                    02120000
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       COPY CWS1000B.                                                   02160000
                                                                        
       COPY CWS00328.                                                   02180000
                                                                        
           EXEC SQL                                                     02200000
                INCLUDE CWS00195                                        02210000
           END-EXEC.                                                    02220000
      *                                                                 02230000
       01  WS-SCSCA-RETURN-CODE         PIC S9(4) COMP.                 
      *                                                                 02250000
       PROCEDURE DIVISION USING WS-CA195-GRP2-FIELDS                    
                                WS-BILLING-BG                           
                                WS-BILL-DET-BT                          
                                WS-FIXED-FCTR-HIST-FH                   
                                WS-ACCOUNT-AT                           
                                WS-BILL-CALC-DETAIL                     
                                WS-ACCT-RTPK-AGR-DF                     
                                WS-BILL-ADJUST-DETAIL                   
                                WS-ACCT-ATTRIBUTE-YP                    
                                WS-ACCT-MKT-TIER-DD                     
                                CWS00328-FIELDS                         
I00177                          WS-SCSCA-RETURN-CODE                    
I00177                          WS-CWS1000B-MAX-TBL-LIMITS.             

SCA006        SET MKT-IND TO 1.
SCA006        SET OPT-IND TO 1.
                                                                        
      ***************************************************************   02400000
      *  MAIN DRIVER FOR SUBMODULE.                                  *  02410000
      ***************************************************************   02420000
       0000-MAINLINE.                                                   
                                                                        
           DISPLAY 'CALLING SCSCA195 WITH ACCOUNT # '                   
              WS-CA195-HOLD-ACCOUNT-NO.                                 
           MOVE ZEROS TO WS-SCSCA-RETURN-CODE.                          
                                                                        
           PERFORM 0100-PROCESS-OPTIONS THRU 0100-EXIT.                 
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   02560000
      *  PROCESS OPTION CODES AND GRP2 FIELDS.                       *  02570000
      ***************************************************************   02580000
       0100-PROCESS-OPTIONS.                                            
                                                                        
A03019     PERFORM 0150-INIT-CA195-VARS          THRU 0150-EXIT.        
A03019*                                                                 02620000
           IF WS-CA195-OPTION-CODE > SPACES AND NOT FIRST-TIME-SW       
              PERFORM 2300-GET-MSG-DESC THRU 2300-EXIT                  
              GO TO 0100-EXIT                                           
           END-IF.                                                      
                                                                        
           IF FIRST-TIME-SW THEN                                        
              PERFORM 7000-LOAD-MKT-TIER-ADJ     THRU 7000-EXIT         
              PERFORM 8800-LOAD-OPT-TBL          THRU 8800-EXIT         
              PERFORM 0185-GET-JOB-PARM          THRU 0185-EXIT         
              MOVE 'NO ' TO WS-FIRST-TIME-SW                            
              GO TO 0100-EXIT                                           
           END-IF.                                                      
                                                                        
           IF WS-CA195-HOLD-ACCOUNT-NO = 0                              
              GO TO 0100-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE '00' TO WS-CA195-SET-30-60-90-FLAG.                     
           MOVE '00' TO WS-CA195-SET-55-75-FLAG.                        
           MOVE WS-CA195-HOLD-ACCOUNT-NO TO WS-IN-ACCOUNT-NO.           
           PERFORM 2000-CHECK-ATTRIB THRU 2000-EXIT.                    
           IF WS-CA195-PROG-NAME = 'PCSCA905'                           
              GO TO 0100-EXIT                                           
           ELSE                                                         
           IF WS-BG-CNT = 0                                             
              GO TO 0100-EXIT                                           
           END-IF
           END-IF.                                                      
                                                                        
           PERFORM 2100-GET-CSC-AMOUNT THRU 2100-EXIT.                  
           PERFORM 2200-CALC-THERM-PRICE THRU 2200-EXIT.                
           IF WS-CA195-OPTION-CD > SPACES                               
              MOVE WS-CA195-OPTION-CD TO WS-CA195-OPTION-CODE           
              PERFORM 2300-GET-MSG-DESC THRU 2300-EXIT                  
           END-IF.                                                      
           PERFORM 2400-CALC-MIN-GOOD-PYMTS THRU 2400-EXIT.             
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03019******************************************************************03011000
A03019* INITIALIZE CA195 VARIABLES                                     *03012000
A03019******************************************************************03013000
A03019 0150-INIT-CA195-VARS.                                            
A03019                                                                  
A03019     INITIALIZE WS-CA195-BILL-CR-AMT                              
A03019                WS-CA195-LONG-BILL-CR-AMT                         
A03019                WS-CA195-DUR-REM-MONTHS                           
A03019                WS-CA195-OPTION-1                                 
A03019                WS-CA195-OPTION-2                                 
A03019                WS-CA195-LONG-FIXED-PRICE                         
A03019                WS-CA195-DURATION-TYPES                           
A03019                WS-CA195-ADJ-TIER-SEQ-NO                          
A03019                WS-CA195-OPTION-CD                                
A03019                WS-CA195-REG-GROUP                                
A03019                WS-CA195-MKT-PROGRAM-CD                           
A03019                WS-CA195-RATE-DEFINITION                          
A03019                WS-CA195-DURATION-REMAIN-NO                       
A03019                WS-CA195-FACTOR-ID                                
A03019                WS-CA195-FACTOR-FH                                
A03019                WS-CA195-LONG-FACTOR-FH                           
A03019                WS-CA195-BILL-PRT-MSG-PL-CD                       
A03019                WS-CA195-REG-SW                                   
A03019                WS-CA195-FREE-CSC-SW                              
A03019                WS-CA195-FREE-CSC-REMAIN-NO                       
A03019                WS-CA195-CSC-CREDIT-SW                            
A03019                WS-CA195-CUST-CRED-EXP-MSG                        
A03019                WS-CA195-CURRENT-TIER.                            
A03019                                                                  
A03019 0150-EXIT.                                                       
A03019     EXIT.                                                        
                                                                        
      ***************************************************************   03021400
      *  CALCULATE DEFAULT FIXED AND VARIABLE PRICE AMOUNTS.         *  03021500
      ***************************************************************   03021600
       0185-GET-JOB-PARM.                                               
                                                                        
           EXEC SQL                                                     
               SELECT (CIS.SUBSTR3(PARM_DATA,23,12))                         
                 INTO :WS-CA195-OPTION-1                                
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME = :WS-CA195-PROG-NAME                
                  AND CMND_CODE    = 'PARM'                             
                  AND COMPANY_NO   = '01'                               
                  AND SEQ_NO       = 01                                 
                  AND STATUS       = 'A'                                
                                                                 
A03019                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     03021900
MFA-TR*        SELECT (SUBSTR(PARM_DATA,23,12))                         03022000
MFA-TR*          INTO :WS-CA195-OPTION-1                                03023000
MFA-TR*          FROM CSS_JOB_PARM                                      03024000
MFA-TR*         WHERE PROGRAM_NAME = :WS-CA195-PROG-NAME                03025000
MFA-TR*           AND CMND_CODE    = 'PARM'                             03026000
MFA-TR*           AND COMPANY_NO   = '01'                               03027000
MFA-TR*           AND SEQ_NO       = 01                                 03028000
MFA-TR*           AND STATUS       = 'A'                                03029000
MFA-TR*         WITH UR                                                 03030000
MFA-TR*         QUERYNO 01851                                           03040000
MFA-TR*    END-EXEC.                                                    03050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 8 TO WS-SCSCA-RETURN-CODE                            
              DISPLAY '**  ERROR ON 0185-GET-JOB-PARM1       **'        
              DISPLAY '**  COULD NOT GET OPTION CODE         **'        
              DISPLAY '**  RETURN CODE    = ' SQLCODE                   
              GO TO 0185-EXIT                                           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               SELECT (CIS.SUBSTR3(PARM_DATA,21,12))                         
                 INTO :WS-CA195-OPTION-2                                
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME = :WS-CA195-PROG-NAME                
                  AND CMND_CODE    = 'PARM'                             
                  AND COMPANY_NO   = '01'                               
                  AND SEQ_NO       = 02                                 
                  AND STATUS       = 'A'                                
                                                                 
A03019                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     03170000
MFA-TR*        SELECT (SUBSTR(PARM_DATA,21,12))                         03180000
MFA-TR*          INTO :WS-CA195-OPTION-2                                03190000
MFA-TR*          FROM CSS_JOB_PARM                                      03200000
MFA-TR*         WHERE PROGRAM_NAME = :WS-CA195-PROG-NAME                03210000
MFA-TR*           AND CMND_CODE    = 'PARM'                             03220000
MFA-TR*           AND COMPANY_NO   = '01'                               03230000
MFA-TR*           AND SEQ_NO       = 02                                 03240000
MFA-TR*           AND STATUS       = 'A'                                03250000
MFA-TR*         WITH UR                                                 03260000
MFA-TR*         QUERYNO 01852                                           03270000
MFA-TR*    END-EXEC.                                                    03280000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 8 TO WS-SCSCA-RETURN-CODE                            
              DISPLAY '**  ERROR ON 0185-GET-JOB-PARM2       **'        
              DISPLAY '**  COULD NOT GET OPTION CODE         **'        
              DISPLAY '**  RETURN CODE    = ' SQLCODE                   
              GO TO 0185-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE 0 TO WS-ACCOUNT-NO.                                     
           MOVE WS-CA195-OPTION-1 TO WS-CA195-OPTION-CD                 
                                     WS-CA195-OPTION-CODE               
                                     WS-OPTION-CD.                      
           MOVE WS-ACCOUNT-NO TO WS-ACCOUNT-NO-063.                     
           MOVE WS-IN-CODE-UTIL-TYPE TO WS-CODE-UTIL-TYPE-063.          
           MOVE WS-IN-IC-NO TO WS-IC-NO-063.                            
           MOVE PROGRAM-NAME TO WS-CPD063-CALLING-PGM.                  
           MOVE 'N'          TO WS-THERM-CSC-ACCT-FL.                   
           PERFORM 3285-CALL-GET-OPTION THRU 3285-EXIT.                 
           MOVE WS-THERM-PRICE TO                                       
                WS-CA195-GRP2-PUB-FIX-PRC.                              
           PERFORM 2300-GET-MSG-DESC    THRU 2300-EXIT.                 
           MOVE WS-CA195-OPTION-DESC TO                                 
                WS-CA195-GRP2-PUB-FIX-DESC.                             
                                                                        
           MOVE WS-CA195-OPTION-2 TO WS-CA195-OPTION-CD                 
                                     WS-CA195-OPTION-CODE               
                                     WS-OPTION-CD.                      
           MOVE WS-ACCOUNT-NO TO WS-ACCOUNT-NO-063.                     
           MOVE WS-IN-CODE-UTIL-TYPE TO WS-CODE-UTIL-TYPE-063.          
           MOVE WS-IN-IC-NO TO WS-IC-NO-063.                            
           MOVE PROGRAM-NAME TO WS-CPD063-CALLING-PGM.                  
           MOVE 'N'          TO WS-THERM-CSC-ACCT-FL.                   
           PERFORM 3285-CALL-GET-OPTION THRU 3285-EXIT.                 
           MOVE WS-THERM-PRICE TO                                       
                WS-CA195-GRP2-PUB-VAR-PRC.                              
           PERFORM 2300-GET-MSG-DESC    THRU 2300-EXIT.                 
           MOVE WS-CA195-OPTION-DESC TO                                 
                WS-CA195-GRP2-PUB-VAR-DESC.                             
                                                                        
PRJ172     MOVE ZERO                 TO WS-CA195-GRP2-MED-CSC-VAR-DSC   
PRJ172                                  WS-CA195-GRP2-MED-CSC-AMT       
PRJ172                                  WS-CA195-GRP2-MED-CSC-FIX-DSC   
PRJ172                                  WS-CA195-GRP2-MED-CSC-GOOD.     
PRJ172                                                                  
           PERFORM 7400-GET-GRP2-HIGH-CSC   THRU 7400-EXIT.             
           PERFORM 7420-GET-GRP2-LOWEST-CSC THRU 7420-EXIT.             
PRJ172     PERFORM 7430-GET-GRP1-SENIOR     THRU 7430-EXIT.             
                                                                        
       0185-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   03830000
      *  DETERMINE IF IT'S A FIXED PRICE LETTER, WITH OR WITHOUT    *   03840000
      *  CSC, OR CSC LETTER ONLY.                                   *   03850000
      ***************************************************************   03860000
       2000-CHECK-ATTRIB.                                               
                                                                        
           MOVE SPACES               TO WS-CA195-STATUS-CD              
                                        WS-CA195-OPTION-CD              
                                        WS-CA195-FACTOR-ID              
                                        WS-CA195-REG-SW                 
PRJ172                                  WS-CA195-CSC-REVERT-SW          
PRJ172                                  WS-CA195-CURRENT-TIER           
                                        WS-CA195-BILL-PRT-MSG-PL-CD.    
           MOVE 0                    TO WS-CA195-RT-PKG-OPT-SEQ-NO      
                                        WS-CA195-FACTOR-FH.             
                                                                        
           MOVE 0 TO         FF-DURATION-REMAIN-NO                      
                             WS-REMAIN-NO.                              
           MOVE 'N' TO WS-CA195-FREE-CSC-SW.                            
           MOVE 'N' TO WS-CA195-CSC-CREDIT-SW.                          
I00121     MOVE 'N' TO WS-CA195-CUST-CRED-EXP-MSG.                      
           MOVE 'N' TO WS-CA195-SENIOR-RATE-SW.                         
PRJ172     MOVE 'N' TO WS-CA195-GRP1-SENIOR-SW.                         
           MOVE 'N'       TO WS-REBILL-FLAG                             
                             WS-ONCYCLE-FLAG                            
                             WS-REBILL-IMMEDIATE-FLAG.                  
           MOVE SPACES TO WS-HOLD-DATE-ORIG-BILL-BG.                    
                                                                        
           PERFORM VARYING WS-SUB1 FROM 1 BY 1                          
              UNTIL WS-SUB1 > 25                                        
              OR WS-ACCOUNT-NO-YP(WS-SUB1) = ZEROS                      
              IF WS-CA195-HOLD-ACCOUNT-NO = WS-ACCOUNT-NO-YP(WS-SUB1)   
                 AND WS-ATTRIBUTE-DESC-YP(WS-SUB1) =                    
                 'AGL DISCOUNT SR'                                      
                 AND WS-ATTRIBUTE-VALUE-CD-YP(WS-SUB1) = 'YES'          
                     MOVE 'Y' TO WS-CA195-SENIOR-RATE-SW                
                     MOVE 26 TO WS-SUB1                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
      ***************************************************************   04230000
      *  CODE_BILL_ITM_TYPE      CSS_BILLING_DET                    *   04240000
      *      CODE   TRANSLATION  DESCRIPTION                        *   04250000
      *      C      CURRENT      CURRENT                            *   04260000
      *  CODE_BILL_ITM_IND       CSS_BILLING_DET                    *   04270000
      *      CODE   TRANSLATION  DESCRIPTION                        *   04280000
      *      A      ACTIVE       ACTIVE                             *   04290000
      *  CODE_BILL_CALC     CSS_BILLING_DET                         *   04300000
      *      CODE   TRANSLATION  DESCRIPTION                        *   04310000
      *      A      NORM         CALCULATES BILL AMT INCLUDING TAX  *   04320000
      ***************************************************************   04330000
                                                                        
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL            
              WS-BILLING-INDX > 30 OR                                   
              WS-ACCOUNT-NO-BG(WS-BILLING-INDX) = 0                     
             IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'C' AND     
                WS-CODE-BILL-ITM-IND-BG(WS-BILLING-INDX)  = 'A' AND     
                WS-CODE-BILL-CALC-BG (WS-BILLING-INDX)    = 'A'         
                IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) > SPACES      
                   MOVE 'Y' TO WS-REBILL-FLAG                           
                   IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) >          
                      WS-HOLD-DATE-ORIG-BILL-BG                         
                      MOVE WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) TO    
                        WS-HOLD-DATE-ORIG-BILL-BG                       
                   END-IF                                               
                ELSE                                                    
                   MOVE 'Y' TO WS-ONCYCLE-FLAG                          
                END-IF                                                  
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
           IF WS-REBILL-FLAG = 'Y' AND WS-ONCYCLE-FLAG NOT = 'Y'        
               MOVE 'Y' TO WS-REBILL-IMMEDIATE-FLAG                     
           END-IF.                                                      
                                                                        
A03819******************************************************************04580000
A03819* SEARCH ALL BG RECORDS TO IDENTIFY THE LATEST OCCURANCE OF BG.   04590000
A03819* THIS IS NEEDED TO IDENTIFY THE VARIABLE VS FIXED RATES WHEN THE 04600000
A03819* CUSTOMER HAS A RATE CHANGE FROM VARIABLE TO FIXED OR VISE VERSA.04601000
A03819******************************************************************04602000
           MOVE 0 TO WS-BG-CNT.                                         
           PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                    
              WS-SUB1 > 30 OR WS-ACCOUNT-NO-BG(WS-SUB1) = 0             
             IF WS-CODE-BILL-ITM-TYPE-BG(WS-SUB1)   = 'C' AND           
                WS-CODE-BILL-ITM-IND-BG(WS-SUB1)    = 'A' AND           
                WS-CODE-BILL-CALC-BG (WS-SUB1)      = 'A' AND           
              ((WS-DATE-ORIG-BILL-BG (WS-SUB1) = SPACES OR LOW-VALUES)  
                OR (WS-REBILL-IMMEDIATE-FLAG = 'Y'        AND           
                WS-DATE-ORIG-BILL-BG (WS-SUB1) =                        
                WS-HOLD-DATE-ORIG-BILL-BG))                             
                MOVE WS-SUB1 TO WS-BG-CNT                               
                MOVE WS-IC-NO-BG(WS-BG-CNT)      TO WS-IN-IC-NO         
                MOVE WS-CODE-UTIL-TYPE-BG(WS-BG-CNT) TO                 
                     WS-IN-CODE-UTIL-TYPE                               
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
           IF WS-BG-CNT = 0                                             
              DISPLAY '*** SCSCA195 - NO BG RECORD FOUND FOR ACCOUNT '  
                 WS-CA195-HOLD-ACCOUNT-NO ' ***'                        
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
P00453     MOVE SPACES TO WS-RT-CALC-TYP-CD.                            
           MOVE 1 TO WS-BT-CNT.                                         
           PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                    
             WS-SUB1 > 30 OR WS-ACCOUNT-NO-BT(WS-SUB1) = 0              
             IF WS-BILL-DET-KEY-BT(WS-SUB1) =                           
                WS-BILLING-KEY(WS-BG-CNT)                               
                MOVE WS-SUB1 TO WS-BT-CNT                               
               MOVE WS-REG-GROUP-CD-BT(WS-BT-CNT) TO                    
                    WS-REG-GROUP-CD                                     
                    WS-CA195-REG-GROUP                                  
               MOVE WS-MKT-PROGRAM-CD-BT(WS-BT-CNT) TO                  
                    WS-MKT-PROGRAM-CD                                   
                    WS-CA195-MKT-PROGRAM-CD                             
               MOVE WS-RATE-CALC-TYPE-CD-BT(WS-BT-CNT) TO               
                    WS-RT-CALC-TYP-CD                                   
               MOVE WS-RATE-DEFINITION-CD-BT(WS-BT-CNT) TO              
                    WS-RATE-DEFINITION-CD                               
                    WS-CA195-RATE-DEFINITION                            
               MOVE WS-OPTION-CD-BT(WS-BT-CNT)  TO WS-IN-OPTION-CD      
                    WS-CA195-OPTION-CD                                  
               MOVE WS-FIXED-DURATION-NO-BT(WS-BT-CNT) TO               
                    WS-CA195-DURATION-TYPES                             
                MOVE 31 TO WS-SUB1                                      
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
           EVALUATE WS-RT-CALC-TYP-CD                                   
           WHEN '02'                                                    
               SET FIXED-RATE TO TRUE                                   
           WHEN OTHER                                                   
               SET VARIABLE-RATE TO TRUE                                
           END-EVALUATE.                                                
                                                                        
           MOVE 1 TO WS-DD-CNT.                                         
           MOVE SPACES TO WS-START-DATE.                                
           PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                    
             WS-SUB1 > 25 OR WS-ACCOUNT-NO-DD(WS-SUB1) = 0              
             IF WS-EFF-START-DT-DD(WS-SUB1) NOT >                       
                WS-CA195-BILL-DATE                                      
                IF WS-EFF-START-DT-DD(WS-SUB1) >                        
                   WS-START-DATE                                        
                   MOVE WS-EFF-START-DT-DD(WS-SUB1) TO                  
                     WS-START-DATE                                      
                    MOVE WS-SUB1 TO WS-DD-CNT                           
                END-IF                                                  
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
           MOVE 1 TO WS-DF-CNT.                                         
           PERFORM VARYING WS-SUB1 FROM 1 BY 1                          
              UNTIL WS-SUB1 > 25                                        
             IF WS-RT-PKG-OPT-SEQ-NO-DF(WS-SUB1) =                      
                WS-RT-PKG-OPT-SEQ-NO-BG(WS-BG-CNT)                      
                MOVE WS-SUB1 TO WS-DF-CNT                               
                MOVE WS-RT-PKG-OPT-SEQ-NO-DF(WS-DF-CNT) TO              
                     WS-CA195-RT-PKG-OPT-SEQ-NO                         
                MOVE WS-ADJ-TIER-SEQ-NO-DF(WS-DF-CNT) TO                
                     WS-CA195-ADJ-TIER-SEQ-NO                           
                IF WS-OPTION-CD-DF(WS-DF-CNT) > SPACES                  
                   MOVE WS-STATUS-CD-DF(WS-DF-CNT) TO                   
                        WS-CA195-STATUS-CD                              
                END-IF                                                  
                MOVE 26 TO WS-SUB1                                      
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
PRJ172     IF (WS-ADJ-TIER-SEQ-NO-DF(WS-DF-CNT) =                       
PRJ172         WS-ADJ-TIER-SEQ-NO-DD(WS-DD-CNT)) AND                    
PRJ172         WS-MKT-TIER-RANKING-DD(WS-DD-CNT) = 90 AND               
PRJ172         WS-TIER-ACCT-TYPE-CD-DD(WS-DD-CNT) = '1'                 
PRJ172         MOVE 'Y' TO WS-CA195-GRP1-SENIOR-SW                      
PRJ172     END-IF                                                       
      ***************************************************************   05490000
      *  DETERMINE IF IT'S A FIXED PRICE OR FREE BILL CREDIT LETTER *   05500000
      *  WITH DURATION 1 OR 2. FOR PRERENEWAL IS DURATION 3.        *   05510000
      ***************************************************************   05520000
           PERFORM VARYING WS-SUB1 FROM 1 BY 1                          
             UNTIL WS-SUB1 > 200         OR                             
             WS-ACCOUNT-NO-FH(WS-SUB1) = ZEROS                          
RAJ   *      WS-CA195-BILL-PRT-MSG-PL-CD > SPACES                       05560000
             IF WS-BILLING-KEY-FH(WS-SUB1) =                            
                WS-BILLING-KEY(WS-BG-CNT)                               
              MOVE WS-BILL-PRT-MSG-PL-CD-FH(WS-SUB1) TO                 
                   WS-BILL-PRT-MSG-CD                                   
A01404        IF FIXED-PRICE                                            
A01404           MOVE WS-DURATION-REMAIN-NO-FH(WS-SUB1) TO              
A01404                FF-DURATION-REMAIN-NO                             
PRJ172              MOVE WS-BILL-PRT-MSG-PL-CD-FH(WS-SUB1) TO           
PRJ172                   WS-CA195-CURRENT-TIER                          
A01404        END-IF                                                    
PRJ211*****   30DAYS MOVED TO 60DAYS AND OBSELETE.                      05613300
PRJ211        IF FIXED-PRICE AND FIXED-RATE                             
PRJ211           IF WS-DURATION-REMAIN-NO-FH(WS-SUB1) = 1               
PRJ211              SET PENDING-REMINDER-MSGS TO TRUE                   
PRJ211           ELSE                                                   
PRJ211             IF  WS-DURATION-REMAIN-NO-FH(WS-SUB1) = 2            
PRJ211                 SET RENEWAL-MSGS TO TRUE                         
                       MOVE WS-ADJ-TIER-SEQ-NO-DD(WS-DD-CNT) TO         
                            WS-CA195-ADJ-TIER-SEQ-NO                    
                       MOVE WS-BILL-PRT-MSG-PL-CD-FH(WS-SUB1) TO        
                            WS-CA195-BILL-PRT-MSG-PL-CD                 
                       MOVE WS-FACTOR-ID-FH(WS-SUB1) TO                 
                            WS-CA195-FACTOR-ID                          
A03303                 IF WS-FCTR-POWER-10-FH(WS-SUB1) = 0              
A03303                    MOVE WS-FACTOR-FH (WS-SUB1)                   
A03303                         TO WS-CA195-FACTOR-FH                    
A03303                 ELSE                                             
A03303                    MOVE WS-LONG-FACTOR-FH (WS-SUB1)              
A03303                         TO WS-CA195-LONG-FACTOR-FH               
A03303                 END-IF                                           
P00677                 IF (WS-ADJ-TIER-SEQ-NO-DF(WS-DF-CNT) =           
P00677                     WS-ADJ-TIER-SEQ-NO-DD(WS-DD-CNT))            
P00677                     MOVE 'EQ' TO WS-CA195-REG-SW                 
P00677                 ELSE                                             
P00677                     MOVE 'NE' TO WS-CA195-REG-SW                 
P00677                 END-IF                                           
PRJ211             END-IF                                               
PRJ211           END-IF                                                 
PRJ211        END-IF                                                    
PRJ211        EVALUATE TRUE                                             
I00121        WHEN WS-DURATION-REMAIN-NO-FH(WS-SUB1) = 1 AND            
I00121           CUST-CRED-EXP                                          
I00121             MOVE 'Y'       TO WS-CA195-CUST-CRED-EXP-MSG         
PRJ211        WHEN WS-DURATION-REMAIN-NO-FH(WS-SUB1) = 3 AND            
PRJ211           FIXED-PRICE                                            
PRJ211        SET PRERENEWAL TO TRUE                                    
PRJ211           MOVE  WS-BILL-PRT-MSG-PL-CD-FH(WS-SUB1) TO             
PRJ211                 WS-CA195-BILL-PRT-MSG-PL-CD                      
PRJ211            MOVE WS-FACTOR-ID-FH(WS-SUB1) TO                      
PRJ211                 WS-CA195-FACTOR-ID                               
A03303            IF WS-FCTR-POWER-10-FH(WS-SUB1) = 0                   
A03303               MOVE WS-FACTOR-FH (WS-SUB1) TO WS-CA195-FACTOR-FH  
A03303            ELSE                                                  
A03303               MOVE WS-LONG-FACTOR-FH (WS-SUB1)                   
A03303                         TO WS-CA195-LONG-FACTOR-FH               
A03303            END-IF                                                
PRJ211        WHEN WS-DURATION-REMAIN-NO-FH(WS-SUB1) = 3 AND            
PRJ211           FREE-BILL-CREDIT                                       
PRJ211           SET PRERENEWAL TO TRUE                                 
PRJ211           SET FREE-BCR-EXP-MSG TO TRUE                           
PRJ211           MOVE WS-DURATION-REMAIN-NO-FH(WS-SUB1) TO              
PRJ211                FF-DURATION-REMAIN-NO                             
PRJ211           MOVE WS-BILL-PRT-MSG-PL-CD-FH(WS-SUB1) TO              
PRJ211                WS-CA195-BILL-PRT-MSG-PL-CD                       
A03303           IF WS-FCTR-POWER-10-FH(WS-SUB1) = 0                    
A03303              MOVE WS-FACTOR-FH (WS-SUB1) TO WS-CA195-FACTOR-FH   
A03303                                             WS-CA195-BILL-CR-AMT 
A03303           ELSE                                                   
A03303              MOVE WS-LONG-FACTOR-FH (WS-SUB1)                    
A03303                           TO WS-CA195-LONG-FACTOR-FH             
A03303                              WS-CA195-LONG-BILL-CR-AMT           
A03303           END-IF                                                 
PRJ211           MOVE WS-FACTOR-ID-FH(WS-SUB1) TO                       
PRJ211                WS-CA195-FACTOR-ID                                
PRJ211        END-EVALUATE                                              
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
      ***************************************************************   06150000
      *  DETERMINE IF IT'S A CSC LETTER, OR A FIXED PRICE DURATION 2*   06160000
      *  WITH CSC LETTER, OR A CSC LETTER WITH DURATION 2 AND FIXED *   06170000
      *  PRICE NOT WITH SAME DURATION.                              *   06180000
      ***************************************************************   06190000
           PERFORM VARYING WS-SUB1 FROM 1 BY 1                          
SCA006        UNTIL WS-CA195-FREE-CSC-SW      = 'Y' OR 
SCA006              FREE-CSC-EXP-MSG OR 
                    WS-SUB1 > 200 OR 
                    WS-ACCOUNT-NO-FH(WS-SUB1) = ZEROS                           
               IF WS-BILLING-KEY-FH(WS-SUB1) =                          
                  WS-BILLING-KEY(WS-BG-CNT)           AND               
                  WS-BILL-PRT-MSG-PL-CD-FH(WS-SUB1) = 'CSC'             
                  MOVE WS-FACTOR-ID-FH(WS-SUB1) TO                      
                       WS-CA195-FACTOR-ID                               
A03303            IF WS-FCTR-POWER-10-FH(WS-SUB1) = 0                   
A03303               MOVE WS-FACTOR-FH (WS-SUB1)                        
A03303                         TO WS-CA195-FACTOR-FH                    
A03303                            WS-CA195-BILL-CR-AMT                  
A03303            ELSE                                                  
A03303               MOVE WS-LONG-FACTOR-FH (WS-SUB1)                   
A03303                         TO WS-CA195-LONG-FACTOR-FH               
A03303                            WS-CA195-LONG-BILL-CR-AMT             
A03303            END-IF                                                
                  MOVE WS-DURATION-REMAIN-NO-FH(WS-SUB1) TO             
                       WS-REMAIN-NO                                     
                  MOVE 'Y'                      TO                      
                       WS-CA195-CSC-CREDIT-SW                           
RAJ   *           IF NOT RENEWAL-MSGS AND                               06340000
                  IF WS-DURATION-REMAIN-NO-FH(WS-SUB1) = 2              
                        MOVE 'N' TO WS-CA195-FREE-CSC-SW                
                        SET FREE-CSC-EXP-MSG TO TRUE                    
                  ELSE                                                  
RAJ   *           IF (RENEWAL-MSGS AND                                  06390000
RAJ   *               WS-DURATION-REMAIN-NO-FH(WS-SUB1) = 2) OR         06400000
                     IF (PENDING-REMINDER-MSGS AND                      
                         WS-DURATION-REMAIN-NO-FH(WS-SUB1) = 1)         
                         MOVE 'Y' TO WS-CA195-FREE-CSC-SW               
                     END-IF                                             
                  END-IF                                                
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
           IF WS-TIER-ACCT-TYPE-CD-DD(WS-DD-CNT) =                      
                    'B' OR '1' OR '2'                                   
              MOVE 'N'    TO WS-CA195-TIER-SW                           
           ELSE                                                         
              MOVE 'Y'    TO WS-CA195-TIER-SW                           
           END-IF.                                                      
                                                                        
           MOVE FF-DURATION-REMAIN-NO TO WS-CA195-DURATION-REMAIN-NO    
                                         WS-CA195-DUR-REM-MONTHS.       
           MOVE WS-REMAIN-NO          TO WS-CA195-FREE-CSC-REMAIN-NO.   
A03303     MOVE WS-CA195-FACTOR-FH    TO WS-CA195-LONG-FIXED-PRICE.     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************   06630000
      *  GET CSC AMOUNT FOR PCSCA910.                               *   06640000
      ***************************************************************   06650000
       2100-GET-CSC-AMOUNT.                                             
                                                                        
           MOVE 1 TO WS-BA-CNT.                                         
           MOVE 0 TO WS-CA195-CURRENT-CSC-AMT.                          
           PERFORM VARYING WS-BA-CNT FROM 1 BY 1 UNTIL                  
                WS-BA-CNT > 30 OR                                       
                WS-ACCOUNT-NO-BA(WS-BA-CNT) = 0                         
              IF WS-BILLING-KEY-BA(WS-BA-CNT) =                         
                 WS-BILLING-KEY(WS-BG-CNT)                              
                 IF WS-FACTOR-ID-BA(WS-BA-CNT) = 'BFACCHRG'             
                    MOVE WS-FACTOR-BA(WS-BA-CNT) TO                     
                         WS-CA195-CURRENT-CSC-AMT                       
                    MOVE 31 TO WS-BA-CNT                                
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   06860000
      *  CALCULATE THERM PRICE.                                     *   06870000
      ***************************************************************   06880000
       2200-CALC-THERM-PRICE.                                           
                                                                        
           MOVE 1 TO WS-BC-CNT.                                         
           MOVE 0 TO WS-CA195-BASE-THERM-RATE.                          
           MOVE WS-CA195-HOLD-ACCOUNT-NO TO WS-ACCOUNT-NO-063.          
                                                                        
           PERFORM VARYING WS-BC-CNT FROM 1 BY 1 UNTIL                  
I00177          WS-BC-CNT > WS-BZ-MAX-ENTRY OR                          
                WS-ACCOUNT-NO-BC(WS-BC-CNT) = 0                         
              IF WS-BILLING-KEY-BC(WS-BC-CNT) =                         
                 WS-BILLING-KEY(WS-BG-CNT)                              
                 MOVE WS-AMT-NET-RATE-BC(WS-BC-CNT 1) TO                
                      WS-CA195-BASE-THERM-RATE                          
                 MOVE WS-CODE-UTIL-TYPE-BG(WS-BG-CNT) TO                
                      WS-CODE-UTIL-TYPE-063                             
                 MOVE WS-IC-NO-BG(WS-BG-CNT) TO WS-IC-NO-063            
I00177           COMPUTE WS-BC-CNT = WS-BZ-MAX-ENTRY + 1                
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
      *   CALL STORED PROCEDURE SCSCB063 TO GET THE THERM PRICE         07090000
           IF WS-CA195-BASE-THERM-RATE = 0                              
              MOVE PROGRAM-NAME TO WS-CPD063-CALLING-PGM                
              MOVE 'Y'          TO WS-THERM-CSC-ACCT-FL                 
              IF WS-CA195-OPTION-CD > SPACES                            
                 MOVE WS-CA195-OPTION-CD TO WS-OPTION-CD                
                 PERFORM 3285-CALL-GET-OPTION THRU 3285-EXIT            
                 MOVE WS-THERM-PRICE TO WS-CA195-BASE-THERM-RATE        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   07230000
      *  GET OPTION DESCRIPTION AND RATE.                           *   07240000
      ***************************************************************   07250000
       2300-GET-MSG-DESC.                                               
                                                                        
           SEARCH ALL OPT-DESC-TBL                                      
           AT END                                                       
              DISPLAY '** SCSCA195 - OPTION CODE ' WS-CA195-OPTION-CODE 
                      ' NOT FOUND **'                                   
              MOVE SPACES               TO WS-CA195-OPTION-DESC         
                                           WS-CA195-OPTION-RATE         
           WHEN                                                         
              OPT-KEY(OPT-IND) = WS-CA195-OPTION-CODE                   
              MOVE OPTION-DESC(OPT-IND) TO WS-CA195-OPTION-DESC         
              MOVE CURR-OPTION-DESC(OPT-IND)                            
                                        TO WS-CA195-CURR-OPTION-DESC    
              MOVE OPTION-RATE(OPT-IND) TO WS-CA195-OPTION-RATE         
           END-SEARCH.                                                  
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   07450000
      *  CALCULATE MINIMUM GOOD PAYMENTS.                           *   07460000
      ***************************************************************   07470000
       2400-CALC-MIN-GOOD-PYMTS.                                        
                                                                        
           MOVE 0 TO          WS-CA195-MIN-GOOD-PAY-QTY.                
           IF WS-CA195-ADJ-TIER-SEQ-NO NOT = 0                          
              SEARCH ALL WS-MKT-TIER-ADJ-TBL                            
              AT END                                                    
                 DISPLAY '** SCSCA195 - ADJ-TIER-SQ '                   
                         WS-CA195-ADJ-TIER-SEQ-NO                       
                         ' NOT FOUND **'                                
              WHEN                                                      
                 WS-MKT-TIER-ADJ-KEY(MKT-IND) =                         
                              WS-CA195-ADJ-TIER-SEQ-NO                  
                 MOVE WS-MIN-GOOD-PAY-QTY-T(MKT-IND) TO                 
                              WS-CA195-MIN-GOOD-PAY-QTY                 
              END-SEARCH                                                
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      ********************************************************          07670000
      *  CALL OPTION SUBMODULE                               *          07680000
      ********************************************************          07690000
       3285-CALL-GET-OPTION.                                            
                                                                        
           CALL WS-SCSCB063 USING CWS00063-FIELDS,                      
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
                                                                        
           MOVE RS-RETURN-CODE            TO  WS-ACTIVE-RETURN-CODE.    
                                                                        
           EVALUATE RS-RETURN-CODE                                      
           WHEN 0                                                       
               DISPLAY   'WS-CA195-OPTION-CD  :' WS-CA195-OPTION-CD     
               DISPLAY   'WS-THERM-PRICE      :' WS-THERM-PRICE         
               DISPLAY   'WS-RATE-CALC-TYPE-CD:' WS-RATE-CALC-TYPE-CD   
               DISPLAY   'WS-OPTN-VALID-MNTHS :' WS-OPTN-VALID-MNTHS    
               DISPLAY   'WS-CSC-AMT          :' WS-CSC-AMT             
               DISPLAY   'WS-CSC-REFND-FL     :' WS-CSC-REFND-FL        
               DISPLAY   'WS-CSC-MNTHS        :' WS-CSC-MNTHS           
               DISPLAY   'WS-PRIM-FACTOR      :' WS-PRIM-FACTOR-ID      
           WHEN +100                                                    
              MOVE 4 TO WS-SCSCA-RETURN-CODE                            
              DISPLAY 'SCSCA195 - ACCOUNT NUMBER ' WS-ACCOUNT-NO        
              DISPLAY 'OPTION CODE NOT FOUND ' WS-CA195-OPTION-CD       
              GO TO 3285-EXIT                                           
           WHEN -811                                                    
              MOVE 4 TO WS-SCSCA-RETURN-CODE                            
              DISPLAY '**  WARNING ON 3285-CALL-GET-OPTION     **'      
              DISPLAY '**  RETURN CODE    = ' RS-RETURN-CODE            
              DISPLAY 'ACCOUNT NUMBER ' WS-ACCOUNT-NO                   
              DISPLAY 'OPTION CODE    ' WS-CA195-OPTION-CD              
              GO TO 3285-EXIT                                           
           WHEN OTHER                                                   
              MOVE 8 TO WS-SCSCA-RETURN-CODE                            
              DISPLAY '**  ERROR ON 3285-CALL-GET-OPTION     **'        
              DISPLAY '**  RETURN CODE    = ' RS-RETURN-CODE            
              DISPLAY 'ACCOUNT NUMBER ' WS-ACCOUNT-NO                   
              DISPLAY 'OPTION CODE    ' WS-CA195-OPTION-CD              
           END-EVALUATE.                                                
                                                                        
       3285-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ********************************************************          08110000
      *  LOAD THE MARKETING TIER TABLE FOR SEARCH LATER.     *          08120000
      ********************************************************          08130000
       7000-LOAD-MKT-TIER-ADJ.                                          
                                                                        
           PERFORM 7100-OPEN-MKT-TIER-ADJ THRU 7100-EXIT.               
           PERFORM 7200-FETCH-MKT-TIER-ADJ THRU 7200-EXIT               
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 7300-CLOSE-MKT-TIER-ADJ THRU 7300-EXIT.              
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-OPEN-MKT-TIER-ADJ.                                          
                                                                        
           EXEC SQL                                                     
               OPEN MKT_TIER_ADJ                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A03019     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03019        NEXT SENTENCE                                             
A03019     ELSE                                                         
A03019        MOVE 8 TO WS-SCSCA-RETURN-CODE                            
A03019        DISPLAY '**  ERROR ON 7100-OPEN-MKT-TIER-ADJ  **'         
A03019        DISPLAY '**  RETURN CODE    = ' SQLCODE                   
A03019        PERFORM 9900-SQL-ERROR   THRU 9900-SQL-EXIT               
           END-IF.                                                      
                                                                        
           MOVE 1 TO WS-ADJ-SUB                                         
                     WS-MISC-IDX.                                       
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-FETCH-MKT-TIER-ADJ.                                         
                                                                        
           MOVE 0 TO WS-ROW-COUNT-TIER-ADJ                              

MSQ008     MOVE 100 TO MSQ008-MKT-TIER-ADJ
           EXEC SQL                                                     
               FOR :MSQ008-MKT-TIER-ADJ
              FETCH 
              FROM MKT_TIER_ADJ          
                INTO                                                    
                     :WS-ADJ-TIER-SEQ-NO-HV                             
                    ,:WS-MIN-GOOD-PAY-QTY-HV                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     08490000
MFA-TR*        FETCH NEXT ROWSET FROM MKT_TIER_ADJ FOR 100 ROWS         08500000
MFA-TR*         INTO                                                    08510000
MFA-TR*              :WS-ADJ-TIER-SEQ-NO-HV                             08520000
MFA-TR*             ,:WS-MIN-GOOD-PAY-QTY-HV                            08530000
MFA-TR*    END-EXEC.                                                    08540000

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-MKT-TIER-ADJ
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           MOVE 1 TO WS-MISC-IDX                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT             
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                             08610000
MFA-TR*                  :WS-ROW-COUNT-TIER-ADJ = ROW_COUNT             08620000
MFA-TR*            END-EXEC                                             08630000
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-ROW-COUNT-TIER-ADJ
                   MOVE 1 TO WS-MISC-IDX                                
                   PERFORM UNTIL WS-MISC-IDX > 100                      
                              OR WS-MISC-IDX > WS-ROW-COUNT-TIER-ADJ    
                       ADD 1                      TO MKT-CNT            
                       MOVE WS-ADJ-TIER-SEQ-NO-HV(WS-MISC-IDX)          
                                             TO                         
                            WS-MKT-TIER-ADJ-KEY(MKT-CNT)                
                       MOVE WS-MIN-GOOD-PAY-QTY-HV(WS-MISC-IDX)         
                                             TO                         
                            WS-MIN-GOOD-PAY-QTY-T(MKT-CNT)              
                       ADD 1                      TO WS-MISC-IDX        
                   END-PERFORM                                          
                   IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                      GO TO 7200-EXIT                                   
                   END-IF                                               
               WHEN OTHER                                               
A03019              MOVE 8 TO WS-SCSCA-RETURN-CODE                      
A03019              DISPLAY '**  ERROR ON 7200-FETCH-MKT-TIER-ADJ **'   
A03019              DISPLAY '**  RETURN CODE    = ' SQLCODE             
A03019              PERFORM 9900-SQL-ERROR   THRU 9900-SQL-EXIT         
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-CLOSE-MKT-TIER-ADJ.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE MKT_TIER_ADJ                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A03019        MOVE 8 TO WS-SCSCA-RETURN-CODE                            
A03019        DISPLAY '**  ERROR ON 7300-CLOSE-MKT-TIER-ADJ **'         
A03019        DISPLAY '**  RETURN CODE    = ' SQLCODE                   
A03019        PERFORM 9900-SQL-ERROR   THRU 9900-SQL-EXIT               
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   09060000
      *  CALCULATE GROUP 2 HIGHEST CSC AND NUMBER OF MISSED PAYMENTS *  09070000
      ***************************************************************   09080000
       7400-GET-GRP2-HIGH-CSC.                                          
                                                                        
           EXEC SQL                                                     
PRJ172       SELECT TOP(1) MISSED_PYMT_QTY,
              ADJ_TIER_RANKING                                   
PRJ172       INTO   :1B-MISSED-PYMT-QTY                                 
PRJ172             ,:1B-ADJ-TIER-RANKING                                
PRJ172       FROM CRM_MKT_TIER_ADJ WITH(READUNCOMMITTED)                        
PRJ172       WHERE ADJ_SOURCE_CD = 'H' AND ADJ_TIER_ACCT_TYPE = '2'     
PRJ172       AND ADJ_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CA195-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CA195-BILL-DATE
              ) <> 0) OR (LEN(:WS-CA195-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CA195-BILL-DATE
              ), CONVERT(DATE, :WS-CA195-BILL-DATE) )                    
PRJ172       AND ADJ_END_DT >= IIF(TRY_CONVERT(DATE, :WS-CA195-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CA195-BILL-DATE
              ) <> 0) OR (LEN(:WS-CA195-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CA195-BILL-DATE
              ), CONVERT(DATE, :WS-CA195-BILL-DATE) )                      
P00677       ORDER BY ADJ_TIER_RANKING DESC                             
P00677                                              
PRJ172                                                           
A03019                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09110000
MFA-TR*      SELECT MISSED_PYMT_QTY                                     09120000
MFA-TR*             ,ADJ_TIER_RANKING                                   09130000
MFA-TR*      INTO   :1B-MISSED-PYMT-QTY                                 09140000
MFA-TR*            ,:1B-ADJ-TIER-RANKING                                09150000
MFA-TR*      FROM CRM_MKT_TIER_ADJ                                      09160000
MFA-TR*      WHERE ADJ_SOURCE_CD = 'H' AND ADJ_TIER_ACCT_TYPE = '2'     09170000
MFA-TR*      AND ADJ_START_DT <= :WS-CA195-BILL-DATE                    09180000
MFA-TR*      AND ADJ_END_DT >= :WS-CA195-BILL-DATE                      09190000
MFA-TR*      ORDER BY ADJ_TIER_RANKING DESC                             09200000
MFA-TR*      FETCH FIRST ROW ONLY                                       09210000
MFA-TR*      WITH UR                                                    09220000
MFA-TR*      QUERYNO 74001                                              09230000
MFA-TR*    END-EXEC.                                                    09240000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
           WHEN 0                                                       
               MOVE 1B-MISSED-PYMT-QTY TO WS-CA195-NBR-MISSED-PAYMENT   
           WHEN OTHER                                                   
               MOVE 8 TO WS-SCSCA-RETURN-CODE                           
               DISPLAY '**  ERROR ON 7400-GET-GRP2-HIGH-CSC   **'       
               DISPLAY '**  COULD NOT GET VERSION NO CNTRL    **'       
               DISPLAY '**  RETURN CODE    = ' SQLCODE                  
               GO TO 7400-EXIT                                          
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) E9.OPTION_CD,
              E9.OFFER_CD                                       
               INTO  :E9-OPTION-CD                                      
                    ,:DU-OFFER-CD                                       
               FROM CRM_OFF_MKT_TIER DU WITH(READUNCOMMITTED)                   
                   ,CRM_OFFER_OPTION E9 WITH(READUNCOMMITTED)                   
               WHERE DU.TIER_CUST_STAT_CD = 'E'                         
               AND DU.COMPANY_NO = '01'                                 
P00269         AND E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CA195-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CA195-BILL-DATE
              ) <> 0) OR (LEN(:WS-CA195-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CA195-BILL-DATE
              ), CONVERT(DATE, :WS-CA195-BILL-DATE) )         
P00269         AND E9.OFFER_OPT_END_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CA195-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CA195-BILL-DATE
              ) <> 0) OR (LEN(:WS-CA195-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CA195-BILL-DATE
              ), CONVERT(DATE, :WS-CA195-BILL-DATE) )           
               AND DU.TIER_ACCT_TYPE_CD = '2'                           
               AND DU.MKT_TIER_RANKING = :1B-ADJ-TIER-RANKING           
               AND DU.TIER_DEFLT_OFFR_CD = 'Y'                          
               AND DU.OFFER_CD = E9.OFFER_CD                            
               AND E9.OPTION_SORT_SEQ_NO = 1                            
P00473         AND DU.OFF_TIER_VSTART_TS <= CIS.CURRENT$TIMESTAMP()           
P00473         AND DU.OFF_TIER_VEND_TS   >= CIS.CURRENT$TIMESTAMP()           
P00473         AND DU.PROC_STATUS_CD      = 'AC'                        
P00473         AND E9.OFF_OPT_VSTART_TS  <= CIS.CURRENT$TIMESTAMP()           
P00473         AND E9.OFF_OPT_VEND_TS    >= CIS.CURRENT$TIMESTAMP()           
P00473         AND E9.PROC_STATUS_CD      = 'AC'                        
               AND CAST(SYSDATETIMEOFFSET() AS DATE) >= (SELECT MAX(
           DX.MKT_TIER_START_DT)    
               FROM CRM_OFF_MKT_TIER DX WITH(READUNCOMMITTED)                   
               WHERE DX.TIER_CUST_STAT_CD =                             
                     DU.TIER_CUST_STAT_CD                               
               AND DX.TIER_ACCT_TYPE_CD =                               
                   DU.TIER_ACCT_TYPE_CD                                 
               AND DX.MKT_TIER_RANKING =                                
                   DU.MKT_TIER_RANKING                                  
               AND DX.COMPANY_NO =                                      
                   DU.COMPANY_NO                                        
P00473         AND DX.TIER_DEFLT_OFFR_CD = 'Y'                          
P00473         AND DX.OFF_TIER_VSTART_TS <= CIS.CURRENT$TIMESTAMP()           
P00473         AND DX.OFF_TIER_VEND_TS   >= CIS.CURRENT$TIMESTAMP()           
P00473         AND DX.PROC_STATUS_CD      = 'AC')                       
                                             
A03019                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09370000
MFA-TR*        SELECT E9.OPTION_CD                                      09380000
MFA-TR*              ,E9.OFFER_CD                                       09390000
MFA-TR*        INTO  :E9-OPTION-CD                                      09400000
MFA-TR*             ,:DU-OFFER-CD                                       09410000
MFA-TR*        FROM CRM_OFF_MKT_TIER DU                                 09420000
MFA-TR*            ,CRM_OFFER_OPTION E9                                 09430000
MFA-TR*        WHERE DU.TIER_CUST_STAT_CD = 'E'                         09440000
MFA-TR*        AND DU.COMPANY_NO = '01'                                 09450000
MFA-TR*        AND E9.OFFER_OPT_START_DT <= :WS-CA195-BILL-DATE         09460000
MFA-TR*        AND E9.OFFER_OPT_END_DT >= :WS-CA195-BILL-DATE           09470000
MFA-TR*        AND DU.TIER_ACCT_TYPE_CD = '2'                           09480000
MFA-TR*        AND DU.MKT_TIER_RANKING = :1B-ADJ-TIER-RANKING           09490000
MFA-TR*        AND DU.TIER_DEFLT_OFFR_CD = 'Y'                          09500000
MFA-TR*        AND DU.OFFER_CD = E9.OFFER_CD                            09510000
MFA-TR*        AND E9.OPTION_SORT_SEQ_NO = 1                            09520000
MFA-TR*        AND DU.OFF_TIER_VSTART_TS <= CURRENT TIMESTAMP           09530000
MFA-TR*        AND DU.OFF_TIER_VEND_TS   >= CURRENT TIMESTAMP           09540000
MFA-TR*        AND DU.PROC_STATUS_CD      = 'AC'                        09550000
MFA-TR*        AND E9.OFF_OPT_VSTART_TS  <= CURRENT TIMESTAMP           09560000
MFA-TR*        AND E9.OFF_OPT_VEND_TS    >= CURRENT TIMESTAMP           09570000
MFA-TR*        AND E9.PROC_STATUS_CD      = 'AC'                        09580000
MFA-TR*        AND CURRENT DATE >= (SELECT MAX(DX.MKT_TIER_START_DT)    09590000
MFA-TR*        FROM CRM_OFF_MKT_TIER DX                                 09600000
MFA-TR*        WHERE DX.TIER_CUST_STAT_CD =                             09610000
MFA-TR*              DU.TIER_CUST_STAT_CD                               09620000
MFA-TR*        AND DX.TIER_ACCT_TYPE_CD =                               09630000
MFA-TR*            DU.TIER_ACCT_TYPE_CD                                 09640000
MFA-TR*        AND DX.MKT_TIER_RANKING =                                09650000
MFA-TR*            DU.MKT_TIER_RANKING                                  09660000
MFA-TR*        AND DX.COMPANY_NO =                                      09670000
MFA-TR*            DU.COMPANY_NO                                        09680000
MFA-TR*        AND DX.TIER_DEFLT_OFFR_CD = 'Y'                          09690000
MFA-TR*        AND DX.OFF_TIER_VSTART_TS <= CURRENT TIMESTAMP           09700000
MFA-TR*        AND DX.OFF_TIER_VEND_TS   >= CURRENT TIMESTAMP           09710000
MFA-TR*        AND DX.PROC_STATUS_CD      = 'AC')                       09720000
MFA-TR*            FETCH FIRST ROW ONLY WITH UR                         09730000
MFA-TR*        QUERYNO 74002                                            09740000
MFA-TR*    END-EXEC.                                                    09750000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
           WHEN 0                                                       
              MOVE E9-OPTION-CD TO WS-CA195-OPTION-CD                   
                                   WS-OPTION-CD                         
              MOVE 'G'         TO WS-CODE-UTIL-TYPE-063                 
              MOVE 1           TO WS-IC-NO-063                          
              MOVE PROGRAM-NAME TO WS-CPD063-CALLING-PGM                
              MOVE 'N'          TO WS-THERM-CSC-ACCT-FL                 
              PERFORM 3285-CALL-GET-OPTION THRU 3285-EXIT               
              MOVE WS-CSC-AMT TO WS-CA195-GRP2-HIGH-CSC-AMT             
           WHEN OTHER                                                   
               MOVE 8 TO WS-SCSCA-RETURN-CODE                           
               DISPLAY '**  ERROR ON 7400-GET-GRP2-HIGH-CSC   **'       
               DISPLAY '**  COULD NOT GET VERSION NO CNTRL    **'       
               DISPLAY '**  RETURN CODE    = ' SQLCODE                  
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   09970000
      *  CALCULATE GROUP 2 LOWEST CSC AMOUNT AND                        09980000
      *  NUMBER OF CONSECUTIVE GOOD PAYMENTS.                           09990000
      ***************************************************************   10000000
       7420-GET-GRP2-LOWEST-CSC.                                        
                                                                        
           EXEC SQL                                                     
PRJ172       SELECT TOP(1) MIN_GOOD_PAY_QTY,
              ADJ_TIER_RANKING                                   
PRJ172          INTO :1B-MIN-GOOD-PAY-QTY                               
PRJ172              ,:1B-ADJ-TIER-RANKING                               
PRJ172       FROM CRM_MKT_TIER_ADJ [1B] WITH(READUNCOMMITTED)                   
PRJ172       WHERE ADJ_SOURCE_CD = 'L' AND ADJ_TIER_ACCT_TYPE = '2'     
PRJ172         AND [1B].ADJ_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CA195-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CA195-BILL-DATE
              ) <> 0) OR (LEN(:WS-CA195-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CA195-BILL-DATE
              ), CONVERT(DATE, :WS-CA195-BILL-DATE) )               
PRJ172         AND [1B].ADJ_END_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CA195-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CA195-BILL-DATE
              ) <> 0) OR (LEN(:WS-CA195-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CA195-BILL-DATE
              ), CONVERT(DATE, :WS-CA195-BILL-DATE) )                 
PRJ172         AND [1B].MIN_GOOD_PAY_QTY > 0                              
PRJ172         AND [1B].APPLICATION_CD NOT IN ('IG','RT')                 
P00677       ORDER BY ADJ_TIER_RANKING DESC                             
P00677                                              
PRJ172                                                           
A03019                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10030000
MFA-TR*      SELECT  MIN_GOOD_PAY_QTY                                   10040000
MFA-TR*             ,ADJ_TIER_RANKING                                   10050000
MFA-TR*         INTO :1B-MIN-GOOD-PAY-QTY                               10060000
MFA-TR*             ,:1B-ADJ-TIER-RANKING                               10070000
MFA-TR*      FROM CRM_MKT_TIER_ADJ 1B                                   10080000
MFA-TR*      WHERE ADJ_SOURCE_CD = 'L' AND ADJ_TIER_ACCT_TYPE = '2'     10090000
MFA-TR*        AND 1B.ADJ_START_DT <= :WS-CA195-BILL-DATE               10100000
MFA-TR*        AND 1B.ADJ_END_DT >= :WS-CA195-BILL-DATE                 10110000
MFA-TR*        AND 1B.MIN_GOOD_PAY_QTY > 0                              10120000
MFA-TR*        AND 1B.APPLICATION_CD NOT IN ('IG','RT')                 10130000
MFA-TR*      ORDER BY ADJ_TIER_RANKING DESC                             10140000
MFA-TR*      FETCH FIRST ROW ONLY                                       10150000
MFA-TR*      WITH UR                                                    10160000
MFA-TR*      QUERYNO 74201                                              10170000
MFA-TR*    END-EXEC.                                                    10180000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
           WHEN 0                                                       
               MOVE 1B-MIN-GOOD-PAY-QTY TO WS-CA195-NBR-GOOD-PYMTS      
                    WS-CA195-GRP2-LOW-CSC-GOOD                          
           WHEN OTHER                                                   
               MOVE 8 TO WS-SCSCA-RETURN-CODE                           
               DISPLAY '**  ERROR ON 7420-GET-GRP2-LOW-CSC    **'       
               DISPLAY '**  COULD NOT GET VERSION NO CNTRL    **'       
               DISPLAY '**  RETURN CODE    = ' SQLCODE                  
               GO TO 7420-EXIT                                          
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) E9.OPTION_CD,
              E9.OFFER_CD                                       
               INTO  :E9-OPTION-CD                                      
                    ,:DU-OFFER-CD                                       
               FROM CRM_OFF_MKT_TIER DU WITH(READUNCOMMITTED)                   
                   ,CRM_OFFER_OPTION E9 WITH(READUNCOMMITTED)                   
               WHERE DU.TIER_CUST_STAT_CD = 'E'                         
               AND DU.COMPANY_NO = '01'                                 
P00269         AND E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CA195-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CA195-BILL-DATE
              ) <> 0) OR (LEN(:WS-CA195-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CA195-BILL-DATE
              ), CONVERT(DATE, :WS-CA195-BILL-DATE) )         
P00269         AND E9.OFFER_OPT_END_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CA195-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CA195-BILL-DATE
              ) <> 0) OR (LEN(:WS-CA195-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CA195-BILL-DATE
              ), CONVERT(DATE, :WS-CA195-BILL-DATE) )           
               AND DU.TIER_ACCT_TYPE_CD = '2'                           
               AND DU.MKT_TIER_RANKING = :1B-ADJ-TIER-RANKING           
               AND DU.TIER_DEFLT_OFFR_CD = 'Y'                          
               AND DU.OFFER_CD = E9.OFFER_CD                            
P00473         AND DU.OFF_TIER_VSTART_TS <= CIS.CURRENT$TIMESTAMP()           
P00473         AND DU.OFF_TIER_VEND_TS   >= CIS.CURRENT$TIMESTAMP()           
P00473         AND DU.PROC_STATUS_CD      = 'AC'                        
P00473         AND E9.OFF_OPT_VSTART_TS  <= CIS.CURRENT$TIMESTAMP()           
P00473         AND E9.OFF_OPT_VEND_TS    >= CIS.CURRENT$TIMESTAMP()           
P00473         AND E9.PROC_STATUS_CD      = 'AC'                        
               AND CAST(SYSDATETIMEOFFSET() AS DATE) >= (SELECT MAX(
           DX.MKT_TIER_START_DT)    
               FROM CRM_OFF_MKT_TIER DX WITH(READUNCOMMITTED)                   
               WHERE DX.TIER_CUST_STAT_CD =                             
                     DU.TIER_CUST_STAT_CD                               
               AND DX.TIER_ACCT_TYPE_CD =                               
                   DU.TIER_ACCT_TYPE_CD                                 
               AND DX.MKT_TIER_RANKING =                                
                   DU.MKT_TIER_RANKING                                  
               AND DX.COMPANY_NO =                                      
                   DU.COMPANY_NO                                        
P00473         AND DX.TIER_DEFLT_OFFR_CD = 'Y'                          
P00473         AND DX.OFF_TIER_VSTART_TS <= CIS.CURRENT$TIMESTAMP()           
P00473         AND DX.OFF_TIER_VEND_TS   >= CIS.CURRENT$TIMESTAMP()           
P00473         AND DX.PROC_STATUS_CD      = 'AC')                       
                   ORDER BY E9.OPTION_SORT_SEQ_NO DESC                  
                                             
A03019                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10320000
MFA-TR*        SELECT E9.OPTION_CD                                      10330000
MFA-TR*              ,E9.OFFER_CD                                       10340000
MFA-TR*        INTO  :E9-OPTION-CD                                      10350000
MFA-TR*             ,:DU-OFFER-CD                                       10360000
MFA-TR*        FROM CRM_OFF_MKT_TIER DU                                 10370000
MFA-TR*            ,CRM_OFFER_OPTION E9                                 10380000
MFA-TR*        WHERE DU.TIER_CUST_STAT_CD = 'E'                         10390000
MFA-TR*        AND DU.COMPANY_NO = '01'                                 10400000
MFA-TR*        AND E9.OFFER_OPT_START_DT <= :WS-CA195-BILL-DATE         10410000
MFA-TR*        AND E9.OFFER_OPT_END_DT >= :WS-CA195-BILL-DATE           10420000
MFA-TR*        AND DU.TIER_ACCT_TYPE_CD = '2'                           10430000
MFA-TR*        AND DU.MKT_TIER_RANKING = :1B-ADJ-TIER-RANKING           10440000
MFA-TR*        AND DU.TIER_DEFLT_OFFR_CD = 'Y'                          10450000
MFA-TR*        AND DU.OFFER_CD = E9.OFFER_CD                            10460000
MFA-TR*        AND DU.OFF_TIER_VSTART_TS <= CURRENT TIMESTAMP           10470000
MFA-TR*        AND DU.OFF_TIER_VEND_TS   >= CURRENT TIMESTAMP           10480000
MFA-TR*        AND DU.PROC_STATUS_CD      = 'AC'                        10490000
MFA-TR*        AND E9.OFF_OPT_VSTART_TS  <= CURRENT TIMESTAMP           10500000
MFA-TR*        AND E9.OFF_OPT_VEND_TS    >= CURRENT TIMESTAMP           10510000
MFA-TR*        AND E9.PROC_STATUS_CD      = 'AC'                        10520000
MFA-TR*        AND CURRENT DATE >= (SELECT MAX(DX.MKT_TIER_START_DT)    10530000
MFA-TR*        FROM CRM_OFF_MKT_TIER DX                                 10540000
MFA-TR*        WHERE DX.TIER_CUST_STAT_CD =                             10550000
MFA-TR*              DU.TIER_CUST_STAT_CD                               10560000
MFA-TR*        AND DX.TIER_ACCT_TYPE_CD =                               10570000
MFA-TR*            DU.TIER_ACCT_TYPE_CD                                 10580000
MFA-TR*        AND DX.MKT_TIER_RANKING =                                10590000
MFA-TR*            DU.MKT_TIER_RANKING                                  10600000
MFA-TR*        AND DX.COMPANY_NO =                                      10610000
MFA-TR*            DU.COMPANY_NO                                        10620000
MFA-TR*        AND DX.TIER_DEFLT_OFFR_CD = 'Y'                          10630000
MFA-TR*        AND DX.OFF_TIER_VSTART_TS <= CURRENT TIMESTAMP           10640000
MFA-TR*        AND DX.OFF_TIER_VEND_TS   >= CURRENT TIMESTAMP           10650000
MFA-TR*        AND DX.PROC_STATUS_CD      = 'AC')                       10660000
MFA-TR*            ORDER BY E9.OPTION_SORT_SEQ_NO DESC                  10670000
MFA-TR*            FETCH FIRST ROW ONLY WITH UR                         10680000
MFA-TR*            QUERYNO 74202                                        10690000
MFA-TR*    END-EXEC.                                                    10700000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
           WHEN 0                                                       
              MOVE E9-OPTION-CD TO WS-CA195-OPTION-CD                   
                                  WS-OPTION-CD                          
              MOVE 'G'           TO WS-CODE-UTIL-TYPE-063               
              MOVE 1             TO WS-IC-NO-063                        
              MOVE PROGRAM-NAME TO WS-CPD063-CALLING-PGM                
              MOVE 'N'          TO WS-THERM-CSC-ACCT-FL                 
              PERFORM 3285-CALL-GET-OPTION THRU 3285-EXIT               
              COMPUTE WS-CA195-GRP2-LOW-CSC-VAR-DSC =                   
                      WS-CA195-GRP2-PUB-VAR-PRC -                       
                      WS-THERM-PRICE                                    
              DISPLAY '*** GRP2-LOW-CSC-VAR-DSC = '                     
                      WS-CA195-GRP2-LOW-CSC-VAR-DSC ' ***'              
              MOVE WS-CSC-AMT TO WS-CA195-GRP2-LOW-CSC-AMT              
           WHEN OTHER                                                   
               MOVE 8 TO WS-SCSCA-RETURN-CODE                           
               DISPLAY '**  ERROR ON 7420-GET-GRP2-LOW-CSC    **'       
               DISPLAY '**  COULD NOT GET VERSION NO CNTRL    **'       
               DISPLAY '**  RETURN CODE    = ' SQLCODE                  
               GO TO 7420-EXIT                                          
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) E9.OPTION_CD,
              E9.OFFER_CD                                       
               INTO  :E9-OPTION-CD                                      
                    ,:DU-OFFER-CD                                       
               FROM CRM_OFF_MKT_TIER DU WITH(READUNCOMMITTED)                   
                   ,CRM_OFFER_OPTION E9 WITH(READUNCOMMITTED)                   
               WHERE DU.TIER_CUST_STAT_CD = 'E'                         
               AND DU.COMPANY_NO = '01'                                 
P00269         AND E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CA195-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CA195-BILL-DATE
              ) <> 0) OR (LEN(:WS-CA195-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CA195-BILL-DATE
              ), CONVERT(DATE, :WS-CA195-BILL-DATE) )         
P00269         AND E9.OFFER_OPT_END_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CA195-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CA195-BILL-DATE
              ) <> 0) OR (LEN(:WS-CA195-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CA195-BILL-DATE
              ), CONVERT(DATE, :WS-CA195-BILL-DATE) )           
               AND DU.TIER_ACCT_TYPE_CD = '2'                           
               AND DU.MKT_TIER_RANKING = :1B-ADJ-TIER-RANKING           
               AND DU.TIER_DEFLT_OFFR_CD = 'Y'                          
               AND DU.OFFER_CD = E9.OFFER_CD                            
               AND E9.OPTION_SORT_SEQ_NO = 1                            
P00473         AND DU.OFF_TIER_VSTART_TS <= CIS.CURRENT$TIMESTAMP()           
P00473         AND DU.OFF_TIER_VEND_TS   >= CIS.CURRENT$TIMESTAMP()           
P00473         AND DU.PROC_STATUS_CD      = 'AC'                        
P00473         AND E9.OFF_OPT_VSTART_TS  <= CIS.CURRENT$TIMESTAMP()           
P00473         AND E9.OFF_OPT_VEND_TS    >= CIS.CURRENT$TIMESTAMP()           
P00473         AND E9.PROC_STATUS_CD      = 'AC'                        
               AND CAST(SYSDATETIMEOFFSET() AS DATE) >= (SELECT MAX(
           DX.MKT_TIER_START_DT)    
               FROM CRM_OFF_MKT_TIER DX WITH(READUNCOMMITTED)                   
               WHERE DX.TIER_CUST_STAT_CD =                             
                     DU.TIER_CUST_STAT_CD                               
               AND DX.TIER_ACCT_TYPE_CD =                               
                   DU.TIER_ACCT_TYPE_CD                                 
               AND DX.MKT_TIER_RANKING =                                
                   DU.MKT_TIER_RANKING                                  
               AND DX.COMPANY_NO =                                      
                   DU.COMPANY_NO                                        
P00473         AND DX.TIER_DEFLT_OFFR_CD = 'Y'                          
P00473         AND DX.OFF_TIER_VSTART_TS <= CIS.CURRENT$TIMESTAMP()           
P00473         AND DX.OFF_TIER_VEND_TS   >= CIS.CURRENT$TIMESTAMP()           
P00473         AND DX.PROC_STATUS_CD      = 'AC')                       
                                             
A03019                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10950000
MFA-TR*        SELECT E9.OPTION_CD                                      10960000
MFA-TR*              ,E9.OFFER_CD                                       10970000
MFA-TR*        INTO  :E9-OPTION-CD                                      10980000
MFA-TR*             ,:DU-OFFER-CD                                       10990000
MFA-TR*        FROM CRM_OFF_MKT_TIER DU                                 11000000
MFA-TR*            ,CRM_OFFER_OPTION E9                                 11010000
MFA-TR*        WHERE DU.TIER_CUST_STAT_CD = 'E'                         11020000
MFA-TR*        AND DU.COMPANY_NO = '01'                                 11030000
MFA-TR*        AND E9.OFFER_OPT_START_DT <= :WS-CA195-BILL-DATE         11040000
MFA-TR*        AND E9.OFFER_OPT_END_DT >= :WS-CA195-BILL-DATE           11050000
MFA-TR*        AND DU.TIER_ACCT_TYPE_CD = '2'                           11060000
MFA-TR*        AND DU.MKT_TIER_RANKING = :1B-ADJ-TIER-RANKING           11070000
MFA-TR*        AND DU.TIER_DEFLT_OFFR_CD = 'Y'                          11080000
MFA-TR*        AND DU.OFFER_CD = E9.OFFER_CD                            11090000
MFA-TR*        AND E9.OPTION_SORT_SEQ_NO = 1                            11100000
MFA-TR*        AND DU.OFF_TIER_VSTART_TS <= CURRENT TIMESTAMP           11110000
MFA-TR*        AND DU.OFF_TIER_VEND_TS   >= CURRENT TIMESTAMP           11120000
MFA-TR*        AND DU.PROC_STATUS_CD      = 'AC'                        11130000
MFA-TR*        AND E9.OFF_OPT_VSTART_TS  <= CURRENT TIMESTAMP           11140000
MFA-TR*        AND E9.OFF_OPT_VEND_TS    >= CURRENT TIMESTAMP           11150000
MFA-TR*        AND E9.PROC_STATUS_CD      = 'AC'                        11160000
MFA-TR*        AND CURRENT DATE >= (SELECT MAX(DX.MKT_TIER_START_DT)    11170000
MFA-TR*        FROM CRM_OFF_MKT_TIER DX                                 11180000
MFA-TR*        WHERE DX.TIER_CUST_STAT_CD =                             11190000
MFA-TR*              DU.TIER_CUST_STAT_CD                               11200000
MFA-TR*        AND DX.TIER_ACCT_TYPE_CD =                               11210000
MFA-TR*            DU.TIER_ACCT_TYPE_CD                                 11220000
MFA-TR*        AND DX.MKT_TIER_RANKING =                                11230000
MFA-TR*            DU.MKT_TIER_RANKING                                  11240000
MFA-TR*        AND DX.COMPANY_NO =                                      11250000
MFA-TR*            DU.COMPANY_NO                                        11260000
MFA-TR*        AND DX.TIER_DEFLT_OFFR_CD = 'Y'                          11270000
MFA-TR*        AND DX.OFF_TIER_VSTART_TS <= CURRENT TIMESTAMP           11280000
MFA-TR*        AND DX.OFF_TIER_VEND_TS   >= CURRENT TIMESTAMP           11290000
MFA-TR*        AND DX.PROC_STATUS_CD      = 'AC')                       11300000
MFA-TR*            FETCH FIRST ROW ONLY WITH UR                         11310000
MFA-TR*            QUERYNO 74203                                        11320000
MFA-TR*    END-EXEC.                                                    11330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
           WHEN 0                                                       
              MOVE E9-OPTION-CD TO WS-CA195-OPTION-CD                   
                                  WS-OPTION-CD                          
              MOVE 'G'           TO WS-CODE-UTIL-TYPE-063               
              MOVE 1             TO WS-IC-NO-063                        
              MOVE PROGRAM-NAME TO WS-CPD063-CALLING-PGM                
              MOVE 'N'          TO WS-THERM-CSC-ACCT-FL                 
              PERFORM 3285-CALL-GET-OPTION THRU 3285-EXIT               
              COMPUTE WS-CA195-GRP2-LOW-CSC-FIX-DSC =                   
                      WS-CA195-GRP2-PUB-FIX-PRC -                       
                      WS-THERM-PRICE                                    
              DISPLAY '*** GRP2-LOW-CSC-FIX-DSC = '                     
                      WS-CA195-GRP2-LOW-CSC-FIX-DSC ' ***'              
              MOVE WS-CSC-AMT TO WS-CA195-GRP2-LOW-CSC-AMT              
           WHEN OTHER                                                   
               MOVE 8 TO WS-SCSCA-RETURN-CODE                           
               DISPLAY '**  ERROR ON 7420-GET-GRP2-LOW-CSC    **'       
               DISPLAY '**  COULD NOT GET VERSION NO CNTRL    **'       
               DISPLAY '**  RETURN CODE    = ' SQLCODE                  
               GO TO 7420-EXIT                                          
           END-EVALUATE.                                                
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ172***************************************************************   11610000
PRJ172*  GET GROUP 1 SENIOR NUMBER OF CONSECUTIVE GOOD PAYMENTS.    *   11620000
PRJ172***************************************************************   11630000
PRJ172 7430-GET-GRP1-SENIOR.                                            
PRJ172                                                                  
PRJ172     EXEC SQL                                                     
PRJ172       SELECT  MIN_GOOD_PAY_QTY                                   
PRJ172          INTO :1B-MIN-GOOD-PAY-QTY                               
PRJ172       FROM CRM_MKT_TIER_ADJ WITH(READUNCOMMITTED)                        
PRJ172       WHERE ADJ_SOURCE_CD = '1' AND ADJ_TIER_ACCT_TYPE = '1'     
PRJ172         AND AGL_LOW_INCM_SR_FL = 'Y'                             
PRJ172         AND ADJ_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CA195-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CA195-BILL-DATE
              ) <> 0) OR (LEN(:WS-CA195-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CA195-BILL-DATE
              ), CONVERT(DATE, :WS-CA195-BILL-DATE) )                  
PRJ172         AND ADJ_END_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CA195-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CA195-BILL-DATE
              ) <> 0) OR (LEN(:WS-CA195-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CA195-BILL-DATE
              ), CONVERT(DATE, :WS-CA195-BILL-DATE) )                    
PRJ172                                                           
A03019                                                      
PRJ172     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11660000
MFA-TR*      SELECT  MIN_GOOD_PAY_QTY                                   11670000
MFA-TR*         INTO :1B-MIN-GOOD-PAY-QTY                               11680000
MFA-TR*      FROM CRM_MKT_TIER_ADJ                                      11690000
MFA-TR*      WHERE ADJ_SOURCE_CD = '1' AND ADJ_TIER_ACCT_TYPE = '1'     11700000
MFA-TR*        AND AGL_LOW_INCM_SR_FL = 'Y'                             11710000
MFA-TR*        AND ADJ_START_DT <= :WS-CA195-BILL-DATE                  11720000
MFA-TR*        AND ADJ_END_DT >= :WS-CA195-BILL-DATE                    11730000
MFA-TR*      WITH UR                                                    11740000
MFA-TR*      QUERYNO 7430                                               11750000
MFA-TR*    END-EXEC.                                                    11760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ172                                                                  
PRJ172     EVALUATE SQLCODE                                             
PRJ172     WHEN 0                                                       
PRJ172     WHEN -811                                                    
PRJ172         MOVE 1B-MIN-GOOD-PAY-QTY TO                              
PRJ172                                  WS-CA195-GRP1-SENIOR-GOOD       
PRJ172     WHEN OTHER                                                   
PRJ172         MOVE 8 TO WS-SCSCA-RETURN-CODE                           
PRJ172         DISPLAY '**  ERROR ON 7430-GET-GRP1-SENIOR     **'       
PRJ172         DISPLAY '**  COULD NOT GET VERSION NO CNTRL    **'       
PRJ172         DISPLAY '**  RETURN CODE    = ' SQLCODE                  
PRJ172     END-EVALUATE.                                                
PRJ172                                                                  
PRJ172 7430-EXIT.                                                       
PRJ172     EXIT.                                                        
PRJ172                                                                  
      ********************************************************          11930000
      *  LOAD THE OPTION DESCRIPTION AND RATES TABLE.        *          11940000
      ********************************************************          11950000
       8800-LOAD-OPT-TBL.                                               
                                                                        
           PERFORM 8810-OPEN-OPT-DESC     THRU 8810-EXIT.               
           PERFORM 8820-FETCH-OPT-DESC     THRU 8820-EXIT               
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 8830-CLOSE-OPT-DESC     THRU 8830-EXIT.              
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8810-OPEN-OPT-DESC.                                              
                                                                        
           EXEC SQL                                                     
               OPEN OPT_DESC                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A03019        MOVE 8 TO WS-SCSCA-RETURN-CODE                            
A03019        DISPLAY '**  ERROR ON 8810-OPEN-OPT-DESC **'              
A03019        DISPLAY '**  RETURN CODE    = ' SQLCODE                   
A03019        PERFORM 9900-SQL-ERROR   THRU 9900-SQL-EXIT               
           END-IF.                                                      
           MOVE 1                          TO WS-MISC-IDX.              
                                                                        
       8810-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8820-FETCH-OPT-DESC.                                             
                                                                        
           MOVE 0 TO WS-ROW-COUNT-OPT-CD                                

MSQ008     MOVE 100 TO MSQ008-OPT-DESC
           EXEC SQL                                                     
               FOR :MSQ008-OPT-DESC
              FETCH 
              FROM OPT_DESC              
                INTO                                                    
                     :WS-OPTION-CD-HV                                   
                    ,:WS-REN-DESC-LONG-HV                               
                    ,:WS-INT-DESC-LONG-HV                               
                    ,:WS-CURR-EXT-DESC-LONG-HV                          
                    ,:WS-RATE-PLAN-NO-HV                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     12270000
MFA-TR*        FETCH NEXT ROWSET FROM OPT_DESC     FOR 100 ROWS         12280000
MFA-TR*         INTO                                                    12290000
MFA-TR*              :WS-OPTION-CD-HV                                   12300000
MFA-TR*             ,:WS-REN-DESC-LONG-HV                               12310000
MFA-TR*             ,:WS-INT-DESC-LONG-HV                               12320000
MFA-TR*             ,:WS-CURR-EXT-DESC-LONG-HV                          12330000
MFA-TR*             ,:WS-RATE-PLAN-NO-HV                                12340000
MFA-TR*    END-EXEC.                                                    12350000

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-OPT-DESC
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
               WHEN 354                                                 
                   EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT               
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                             12420000
MFA-TR*                  :WS-ROW-COUNT-OPT-CD = ROW_COUNT               12430000
MFA-TR*            END-EXEC                                             12440000
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-ROW-COUNT-OPT-CD
                   MOVE 1 TO WS-MISC-IDX                                
                   PERFORM UNTIL WS-MISC-IDX > 100                      
                              OR WS-MISC-IDX > WS-ROW-COUNT-OPT-CD      
                       ADD 1                      TO OPT-CNT            
                       MOVE WS-OPTION-CD-HV(WS-MISC-IDX)                
                             TO OPTION-CD(OPT-CNT)                      
                       IF WS-REN-DESC-LONG-HV(WS-MISC-IDX) > SPACES     
                          MOVE WS-REN-DESC-LONG-HV(WS-MISC-IDX)         
                                TO OPTION-DESC(OPT-CNT)                 
                       ELSE                                             
                          MOVE WS-INT-DESC-LONG-HV(WS-MISC-IDX)         
                                TO OPTION-DESC(OPT-CNT)                 
                       END-IF                                           
                       IF WS-CURR-EXT-DESC-LONG-HV(WS-MISC-IDX) > ' '   
                          MOVE WS-CURR-EXT-DESC-LONG-HV(WS-MISC-IDX)    
                                TO CURR-OPTION-DESC(OPT-CNT)            
                       ELSE                                             
                          MOVE WS-INT-DESC-LONG-HV(WS-MISC-IDX)         
                                TO CURR-OPTION-DESC(OPT-CNT)            
                       END-IF                                           
                       MOVE WS-RATE-PLAN-NO-HV(WS-MISC-IDX)             
                             TO OPTION-RATE(OPT-CNT)                    
                       ADD 1                      TO WS-MISC-IDX        
                   END-PERFORM                                          
                   IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                      GO TO 8820-EXIT                                   
                   END-IF                                               
               WHEN OTHER                                               
A03019              DISPLAY '**  ERROR ON 8820-FETCH-OPT-DESC**'        
A03019              DISPLAY '**  RETURN CODE    = ' SQLCODE             
                    MOVE 12 TO WS-SCSCA-RETURN-CODE                     
                    MOVE 'FETCH'   TO ABEND-FUNCTION                    
                    MOVE SQLCODE   TO RS-RETURN-CODE                    
                    MOVE '8810'    TO ACTIVE-PARAGRAPH                  
           END-EVALUATE.                                                
                                                                        
       8820-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8830-CLOSE-OPT-DESC.                                             
                                                                        
           EXEC SQL                                                     
               CLOSE OPT_DESC                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A03019        MOVE 8 TO WS-SCSCA-RETURN-CODE                            
A03019        DISPLAY '**  ERROR ON 8830-CLOSE-OPT-DESC **'             
A03019        DISPLAY '**  RETURN CODE    = ' SQLCODE                   
A03019        PERFORM 9900-SQL-ERROR   THRU 9900-SQL-EXIT               
           END-IF.                                                      
                                                                        
       8830-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-TERMINATE.                                                  
           DISPLAY 'END OF SCSCA195'.                                   
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03019************************************************************      13060000
A03019*  9900-SQL-ERROR                                          *      13070000
A03019*  EXIT PROGRAM WHEN DB2 FATAL ERROR.                      *      13080000
A03019************************************************************      13090000
A03019 9900-SQL-ERROR.                                                  
A03019                                                                  
A03019     EXIT PROGRAM.                                                
A03019                                                                  
A03019 9900-SQL-EXIT.                                                   
A03019     EXIT.                                                        
