       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA187.                                        
      ***************************************************************** 00030000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00040000
      **                     PRICE WATERHOUSE                        ** 00050000
      **                                                             ** 00060000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00070000
      **                                                             ** 00080000
      ***************************************************************** 00090000
      **               P R O G R A M  S U M M A R Y                  ** 00100000
      **                                                             ** 00110000
      **  THIS PROGRAM IS A SUB-ROUTINE CALLED FROM THE BILL PRINT   ** 00120000
      **  EXTRACT DRIVER.  IT SELECTS ACCOUNTS FOR REVIEW OR AUDIT   ** 00130000
      **  BASED ON CERTAIN CONDITIONS.  ACCOUNTS MAY BE SELECTED     ** 00140000
      **  SPECIFICALLY, VIA THE CSS_AUDIT_BLL_ACCT TABLE.  IN        ** 00150000
      **  ADDITION, SPECIAL AUDIT CRITERIA EXISTS IN COPYBOOK        ** 00160000
      **  CWS00090.  ACCOUNTS MEETING THE CRITERIA ARE FLAGGED FOR   ** 00170000
      **  AUDIT.  THE DRIVER PROGRAM (PCSCA105) WRITES EACH ACCOUNT  ** 00180000
      **  SELECTED FOR AUDIT TO TWO FILES:  THE NORMAL BILL PRINT    ** 00190000
      **  FILE AND AN AUDIT BILL FILE.  THE AUDIT BILL FILE BYPASSES ** 00200000
      **  THE MAIL SORT.  IT IS FLAGGED FOR CUSTOMER ACCOUNTING AND  ** 00210000
      **  PRINTS THE REASON FOR AUDIT IN THE MAILING NAME AND ADDRESS** 00220000
      **  FIELDS.                                                    ** 00230000
      ***************************************************************** 00240000
      *                                                              ** 00250000
      *              PROGRAM  MODIFICATION  LOG                      ** 00260000
      *                                                              ** 00270000
      *    DATE     INITIALS  REASON                                 ** 00280000
      *    ----     --------  ------                                 ** 00290000
T35152** 12/17/07   RV97439   AUDIT PROCESS CHANGE - BILL REDESIGN   **         
I00177** 02/02/09   RV97439   REPLACE INDEX HARD CODING FOR CT, DA   **         
I00177**                      AND AC TABLES.                         **         
A00811** 04/08/09   SV82012   CHANGE EPP TO BPP IN AUDIT RUN         **         
A00811**                      CHANGED - CWS00091 TO FIX THIS ISSUE.  **         
P00411** 07/12/10   SV82012   Implement WNA for Electric             **         
A02003** 09/03/10   DMS       Clean up subscript processing          **         
P00430** 10/27/10   DMS       Add audit condition for DSM Credit     **         
A02879** 11/05/10   DMS       Correct BBP Debit Arrears condition.   **         
A02879**                      Only do rate step selection for CSR.   **         
A02003** 11/10/10   DMS       Changed some logic to use evaluates    **         
A02003**                      and cleaned up unused code.            **         
A03019** 02/04/11   DMS       Add audit condition for AGL SR Discount**         
P00453** 09/07/11   Raj       Scana Energy Pre-Pay.                  **         
P00453** 11/07/11   EH        Pre-pay conditions.                    **         
P00565** 12/05/11   SDHAL     Audit cleanup and grouping.                       
A03019*  01/2012    RAJ       Add WNA group 19.                       *         
A03810*  02/2012    bd09555   Change logic for deposit selection      *         
A04067*  03/2012    em19682   Removed BBP Account with Annual         *         
A04067*                       Adjustment Notice condition             *         
A03876*  03/2012    sv        Billing BG can have only a max of 30    *         
A03876*                       occurrence, program checks for 100      *         
P00599*  05/2012    DMS       Credit Simplification                   *         
A04429*  10/2012   SDHAL      Added unmetered rates for audit         *         
A04494*  01/2013   SV         Msg 91001 , 91002 audit cond needs to be*         
A04494*                       based on WS-BILL-CRED-MSG-ID-1H         *         
P00680*  06/03/13  SV95326    TO ADD A PRICE NEGOTIATED ACCOUNT TO    *         
P00680**                      AUDIT FOR SCANA ENERGY.                 *         
A04494*  11/2013   DMS        ADD PCOMP GAS FOR SCEG                  *         
A04494*  12/2013   DMS        ADD PSNC SERVICECARE NON-TAX            *         
P00805*  05/2014   DMS        ADD EXIT FEE AND EXIT FEE CREDIT        *         
ACT003*  07/2014   DMS        A04897-REMOVE WS-CURRENT-CHGS-DUE-DATE  *         
P0805B*  07/2014   DMS        Change 'EXIT CRED' factor to 'EXTCREDTX'*         
ACT029*  07/2014   DMS        A04897 - Add BBP auto enroll for PSNC   *         
ACT230*  11/2014   MR7E794    OMIT THE AUDIT CONDITIONS FOR SEBR AND  *         
ACT230*            A04880     PSNC.                                   *         
ACT074*  03/04/15  SS7F226    ADD CREATED BY CHANGES AND -310 FIX.    *         
ACT074*             A04860                                            *         
A05290*  10/02/15  SV95326    DOUBLE AGL PASS-THROUGH CHARGES (0021). *         
P805CS*  05/24/16  DMS        ADD FACTORS FOR CSC DISCOUNTS           *         
ACT055*  08/08/16  SV95326    ADD AUDIT CONDITION FOR SEB INITIAL     *         
ACT055*            A05462     BILLS.                                  *         
ACT056*  09/06/16  SV95326    ADD AUDIT CONDITION FOR SEB 30 AND      *         
ACT056*            A05462     60 DAY VARIABLE MESSAGE.                *         
      ***************************************************************** 00790000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
      ***************************************************************** 00830000
      **    WORKING STORAGE SECTION                                   * 00840000
      ***************************************************************** 00850000
      *                                                                 00860000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA187'.
MSQ017     COPY MFASQLM.
       01  WS-START                 PIC X(40)                           
           VALUE 'WORKING STORAGE FOR SCSCA187 STARTS HERE'.            
       01  WS-MISC.                                                     
           05  WS-VALID-REC                PIC X(01) VALUE 'N'.         
           05  WS-DAYS-LO             PIC S9(03) VALUE ZEROS COMP-3.    
           05  WS-DAYS-HI             PIC S9(03) VALUE ZEROS COMP-3.    
           05  WS-ACCOUNT-NUM         PIC S9(13) VALUE ZEROS COMP-3.    
           05  WS-ZERODAY-FLAG        PIC X(01)  VALUE 'N'.             
           05  WS-STATE-TAX-EXEMPT-EXISTS                               
                                      PIC X(01)  VALUE 'N'.             
           05  WS-RATE-PLAN-NO         PIC X(03).                       
           05  WS-DISPLAY-ACCOUNT      PIC Z(13).                       
           05  WS-DAYS-BETWEEN         PIC S9(9) COMP.                  
           05  WS-TODAYS-CCYY          PIC 9(4).                        
           05  WS-TODAYS-MM            PIC 99.                          
           05  WS-UNFORMAT-DATE.                                        
               10  WS-UNFMT-CCYY       PIC 9(4).                        
               10  FILLER              PIC X.                           
               10  WS-UNFMT-MM         PIC 99.                          
               10  FILLER              PIC X.                           
               10  WS-UNFMT-DD         PIC 99.                          
           05  WS-START-DATE-CCYYMM.                                    
               10  WS-START-DT-CCYY    PIC 9(4).                        
               10  WS-START-DT-MM      PIC 99.                          
           05  WS-BILLING-CCYYMM       PIC 9(6).                        
           05  FILLER REDEFINES WS-BILLING-CCYYMM.                      
               10  WS-BILLING-CCYY     PIC 9(4).                        
               10  WS-BILLING-MM       PIC 99.                          
           05  WS-ANNIVERSARY-CCYYMM.                                   
               10  WS-ANNIV-CCYY       PIC 9(4).                        
               10  WS-ANNIV-MM         PIC 99.                          
           05  WS-DFA-CCYYMM.                                           
               10  WS-DFA-CCYY         PIC 9(4).                        
               10  WS-DFA-MM           PIC 99.                          
           05  WS-REFUND-CCYYMM.                                        
               10  WS-REFUND-CCYY      PIC 9(4).                        
               10  WS-REFUND-MM        PIC 99.                          
           05  SUB1                    PIC S9(5) COMP-3 VALUE +0.       
           05  SUB2                    PIC S9(5) COMP-3 VALUE +0.       
           05  SUB3                    PIC S9(5) COMP-3 VALUE +0.       
           05  SUB4                    PIC S9(5) COMP-3 VALUE +0.       
           05  SUB5                    PIC S9(5) COMP-3 VALUE +0.       
           05  SUB6                    PIC S9(5) COMP-3 VALUE +0.       
           05  ZERO-SUB                PIC S9(5) COMP-3 VALUE +0.       
A00811     05  WS-AC-SUB               PIC S9(5) COMP-3 VALUE +0.       
           05  WS-CNT-SUB              PIC S9(5) COMP-3 VALUE +0.       
           05  WS-RATE-SUB             PIC S9(5) COMP-3 VALUE +0.       
           05  WS-STEP-SUB             PIC S9(5) COMP-3 VALUE +0.       
           05  WS-MSG-SUB              PIC S9(5) COMP-3 VALUE +0.       
ACT056     05  WS-30DAY-SUB            PIC S9(5) COMP-3 VALUE +0.       
ACT056     05  WS-60DAY-SUB            PIC S9(5) COMP-3 VALUE +0.       
P00411     05  WS-AUD-SUB              PIC S9(5) COMP-3 VALUE +0.       
           05  WS-HOLD-UTIL-TYPE       PIC X VALUE SPACES.              
           05  WS-HOLD-CONTRACT-TYPE   PIC X VALUE SPACES.              
           05  WS-HOLD-RATE-PLAN-NO    PIC XXX VALUE SPACES.            
           05  WS-HOLD-DFA-TYPE        PIC X VALUE SPACES.              
           05  WS-MATCH-RATE-PLAN      PIC XXX VALUE SPACES.            
           05  WS-HOLD-RECON           PIC X(01) VALUE SPACES.          
           05  WS-REG-PROV-AUDIT       PIC X(01) VALUE SPACES.          
           05  WS-AUTO-EPP-SW              PIC X VALUE SPACE.           
               88  AUTO-EPP-OFFER                VALUE 'O'.             
               88  AUTO-EPP-WELCOME              VALUE 'W'.             
           05  WS-JOBBING-FOUND-SW         PIC X VALUE SPACE.           
               88 JOBBING-FOUND                  VALUE 'Y'.             
A00811     05  WS-OTHER-ARREARS-SW         PIC X VALUE 'N'.             
           05  WS-BUDGET-TRAN-DATE         PIC X(10) VALUE SPACE.       
           05  WS-S-DATE-PYMT-STRT         PIC X(10).                   
           05  WS-O-DATE-PYMT-STRT         PIC X(10).                   
           05  WS-HOLD-DATE-PYMT-STRT      PIC X(10).                   
COB305     05 WS-BUDG-ACCT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.    
COB305     05 WS-HOLD-EPP-ESTIMATE        PIC S9(7)V9(2) USAGE COMP-3 
COB305       VALUE 0. 
           05  WS-CHECK-RETURN-CODE        PIC S9(9) VALUE +000 COMP.   
           05  WS-BUDGET-RETURN-CODE       PIC S9(9) VALUE +000 COMP.   
           05  WS-THIS-BILL-DATE           PIC X(10).                   
           05  WS-LAST-BILL-DATE           PIC X(10).                   
           05  WS-HOLD-CHG-REASON          PIC X.                       
           05  WS-EPP-PYMT-MADE            PIC X(01) VALUE 'N'.         
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
           05  WS-TAX-PERCENT          PIC 9(4)V99 VALUE 0.00.          
           05  WS-START-DATE           PIC X(10).                       
           05  WS-END-DATE             PIC X(10).                       
           05  WS-CALC-NO-DAYS         PIC S9(9) COMP.                  
           05  WS-START-POS            PIC S9(4) COMP.                  
           05  WS-ACCOUNT-FLAGS.                                        
               10  WS-RESIDENTIAL-SW       PIC X(01) VALUE 'N'.         
                   88  RESIDENTIAL                   VALUE 'Y'.         
               10  WS-COMMERCIAL-SW        PIC X(01) VALUE 'N'.         
                   88  COMMERCIAL                    VALUE 'Y'.         
               10  WS-PRORATED-SW          PIC X(01) VALUE 'N'.         
                   88  PRORATED                      VALUE 'Y'.         
               10  WS-ELECTRIC-SERVICE     PIC X(01) VALUE 'N'.         
                   88  ELECTRIC                      VALUE 'Y'.         
               10  WS-GAS-SERVICE          PIC X(01) VALUE 'N'.         
                   88  GAS                           VALUE 'Y'.         
               10  WS-HOLD-PRORATE-CD      PIC X(01) VALUE SPACES.      
                   88  PRORATE-FINAL                 VALUE 'F'.         
                   88  PRORATE-INIT                  VALUE 'I'.         
               10  WS-EBILL-SW             PIC X(01) VALUE 'N'.         
                   88  EBILL                         VALUE 'Y'.         
           05  WS-PLAN-ANNIV-SW            PIC X.                       
               88  MONTH-BEFORE-ANNIVERSARY       VALUE 'E'.            
               88  MONTH-AFTER-ANNIVERSARY        VALUE 'T'.            
               88  ANNIVERSARY-MONTH              VALUE 'A'.            
               88  NO-SPECIAL-MONTH               VALUE SPACES.         
COB305     05 WS-TEMP-ORIG-MO        PIC S9(6)V USAGE COMP-3 VALUE 0.     
           05  WS-CHECK-ORIG-MO            PIC 9(6).                    
           05  WS-HOLD-CODE-UTIL-TYPE      PIC X  VALUE SPACES.         
           05  WS-HOLD-IC-NO               PIC S9(4)  COMP.             
           05  WS-HOLD-ACCOUNT-NO          PIC S9(13) COMP-3 VALUE 0.   
COB305     05 WS-HOLD-ANNIV-MO        PIC S9(6)V USAGE COMP-3 VALUE 0.     
           05  WS-HOLD-ANNIV-MO-UNPACK     PIC S9(6).                   
           05  WS-HOLD-ANNIV-MO-CHAR REDEFINES WS-HOLD-ANNIV-MO-UNPACK  
                                           PIC X(6).                    
           05  WS-SPECIAL-RATE-FOUND-FL    PIC X.                       
           05  WS-CURRENT-REV-MO           PIC 9(6).                    
           05  WS-CURRENT-REV-MO-CHAR REDEFINES WS-CURRENT-REV-MO       
                                           PIC X(6).                    
           05  WS-PREV-REVENUE-MONTH       PIC 9(6).                    
           05  WS-PREV-REV-MTH        REDEFINES WS-PREV-REVENUE-MONTH.  
               10  WS-PREV-REV-MTH-YY      PIC 9(4).                    
               10  WS-PREV-REV-MTH-MM      PIC 9(2).                    
           05  WS-PLAN-MONTHS-RMNG         PIC S9(3).                   
COB305     05 WS-BG-SUB        PIC S9(3) COMP-3 VALUE 0.            
           05  WS-BILL-CYCLE-NUM           PIC 9(2) VALUE 0.            
P805CS     05  WS-PAPERLESS-FLAG           PIC X(1) VALUE 'N'.          
P805CS     05  WS-AUTO-RENEW-FLAG          PIC X(1) VALUE 'N'.          
ACT055     05  WS-CSC-FLAG                 PIC X(1) VALUE 'N'.          
ACT055     05  WS-AGL-FLAG                 PIC X(1) VALUE 'N'.          
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER                  PIC S9(4) COMP VALUE +121.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +29.    
               10  FILLER                  PIC X(30) VALUE              
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  FILLER                  PIC S9(4) COMP VALUE +121.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  WS-MISC-MSG-LEN         PIC S9(4) COMP VALUE +250.   
               10  WS-MISC-MSG-TEXT        PIC X(60).                   
ACT074     05  PROGRAM-NAME                PIC X(08) VALUE 'SCSCA187'.  
                                                                        
      *   SUPPLEMENTAL WQ TEXT                                          02040000
                                                                        
       COPY CWS0070B.                                                   02060000
                                                                        
      *   PAYMENT PRIORITY LEVELS                                       02080000
                                                                        
       COPY CWS00041.                                                   02100000
                                                                        
      *   DB2/SQL ERROR CHECKING                                        02120000
                                                                        
       COPY CWS00303.                                                   02140000
                                                                        
      *   ABEND SWITCH                                                  02160000
                                                                        
       COPY CWS09900.                                                   02180000
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR SCSCA187 ENDS HERE  '.            
                                                                        
      ***************************************************************** 02230000
      *     INCLUDE DCLGEN TABLES                                     * 02240000
      ***************************************************************** 02250000
            EXEC SQL                                                    02270000
                 INCLUDE SQLCA                                          02280000
            END-EXEC.                                                   02290000
      ***************************************************************** 02230000
      *  AUDIT BILL ACCOUNTS                                          * 02310000
      ***************************************************************** 02250000
            EXEC SQL                                                    02330000
                 INCLUDE TBADTAT                                        02340000
            END-EXEC.                                                   02350000
      ***************************************************************** 02230000
      *  RATE COMPONENT DEFINITIONS                                   * 02370000
      ***************************************************************** 02250000
            EXEC SQL                                                    02390000
                 INCLUDE TBRTCDEF                                       02400000
            END-EXEC.                                                   02410000
A04429***************************************************************** 02230000
A04429*  UNMETERED PLANS                                              * 02370000
A04429***************************************************************** 02250000
A04429      EXEC SQL                                                    02390000
A04429           INCLUDE TBUMPLAN                                       02400000
A04429      END-EXEC.                                                   02410000
      ***************************************************************** 02250000
      *  UTIL ENVRNMT                                                 * 02430000
      ***************************************************************** 02250000
            EXEC SQL                                                    02450000
                 INCLUDE TBUTLENV                                       02460000
            END-EXEC.                                                   02470000
      ***************************************************************** 02490000
      *   CSS_MNT_TRANS_HIST                                          * 02500000
      ***************************************************************** 02510000
           EXEC SQL                                                     02520000
                INCLUDE TBMNHIST                                        02530000
           END-EXEC.                                                    02540000
      ***************************************************************** 02560000
      *   CSS_BUDGET_HIST                                             * 02570000
      ***************************************************************** 02580000
           EXEC SQL                                                     02590000
               INCLUDE TBBGTHST                                         02600000
           END-EXEC.                                                    02610000
      ***************************************************************** 02560000
      *  RATE PLAN DESCRIPTION                                        * 02630000
      ***************************************************************** 02560000
            EXEC SQL                                                    02650000
                 INCLUDE TBRTDESC                                       02660000
            END-EXEC.                                                   02670000
      ***************************************************************** 02560000
      *  CONTRACT TYPE                                                * 02690000
      ***************************************************************** 02560000
            EXEC SQL                                                    02710000
                 INCLUDE TBCNTYPE                                       02720000
            END-EXEC.                                                   02730000
      ***************************************************************** 02560000
      *  SQL MODEL                                                    * 02750000
      ***************************************************************** 02560000
            EXEC SQL                                                    02770000
                 INCLUDE TBMODEL                                        02780000
            END-EXEC.                                                   02790000
      ***************************************************************** 02560000
      *  SQL MODEL                                                    *         
      ***************************************************************** 02560000
            EXEC SQL                                                            
                 INCLUDE TBCNTINF                                               
            END-EXEC.                                                           
      *                                                                         
      ***************************************************************** 02560000
      *  CURSOR DECLARATIONS                                          *         
      ***************************************************************** 02560000
            EXEC SQL                                                    
                DECLARE RATE_COMP_DEF CURSOR FOR                        
                   (SELECT DISTINCT J1.CODE_UTIL_TYPE,                  
                           J1.RATE_PLAN_NO,                             
                           J1.VERSION_NO_CNTRL,                         
                           J1.LAST_ENERGY_BLOCK,                        
                           J1.LAST_DEM_BLOCK                            
                      FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED),          
                           CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)          
                     WHERE J1.RATE_PLAN_NO = RD.RATE_PLAN_NO AND        
                           RD.COMPANY_NO = :RD-COMPANY-NO AND           
                           RD.CODE_UTIL_TYPE = J1.CODE_UTIL_TYPE        
                   )                                                    
                    UNION                                               
                   (SELECT DISTINCT UP.CODE_UTIL_TYPE,                  
                           UP.RATE_PLAN_NO,                             
                           UP.VERSION_NO_CNTRL,                         
                           0 AS LAST_ENERGY_BLOCK,                      
                           0 AS LAST_DEM_BLOCK                          
                    FROM CSS_UNMTR_PLAN UP WITH(READUNCOMMITTED),               
                         CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)            
                    WHERE UP.RATE_PLAN_NO = RD.RATE_PLAN_NO AND         
                          RD.COMPANY_NO = :RD-COMPANY-NO AND            
                          RD.CODE_UTIL_TYPE = UP.CODE_UTIL_TYPE AND     
                          UP.CODE_UTIL_TYPE='U'                         
                   )                                                    
                    ORDER BY CODE_UTIL_TYPE,                            
                             RATE_PLAN_NO,                              
                             VERSION_NO_CNTRL DESC,                     
                             LAST_ENERGY_BLOCK DESC,                    
                             LAST_DEM_BLOCK DESC                        
                    FOR READ ONLY                               
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    02810000
MFA-TR*         DECLARE RATE_COMP_DEF CURSOR FOR                        02820000
MFA-TR*            (SELECT DISTINCT J1.CODE_UTIL_TYPE,                  02830000
MFA-TR*                    J1.RATE_PLAN_NO,                             02840000
MFA-TR*                    J1.VERSION_NO_CNTRL,                         02850000
MFA-TR*                    J1.LAST_ENERGY_BLOCK,                        02860000
MFA-TR*                    J1.LAST_DEM_BLOCK                            02870000
MFA-TR*               FROM CSS_RATE_COMP_DEF J1,                        02880000
MFA-TR*                    CSS_RATE_PLAN_DESC RD                        02890000
MFA-TR*              WHERE J1.RATE_PLAN_NO = RD.RATE_PLAN_NO AND        02900000
MFA-TR*                    RD.COMPANY_NO = :RD-COMPANY-NO AND           02910000
MFA-TR*                    RD.CODE_UTIL_TYPE = J1.CODE_UTIL_TYPE                
MFA-TR*            )                                                            
MFA-TR*             UNION                                                       
MFA-TR*            (SELECT DISTINCT UP.CODE_UTIL_TYPE,                          
MFA-TR*                    UP.RATE_PLAN_NO,                                     
MFA-TR*                    UP.VERSION_NO_CNTRL,                                 
MFA-TR*                    0 AS LAST_ENERGY_BLOCK,                              
MFA-TR*                    0 AS LAST_DEM_BLOCK                                  
MFA-TR*             FROM CSS_UNMTR_PLAN UP,                                     
MFA-TR*                  CSS_RATE_PLAN_DESC RD                                  
MFA-TR*             WHERE UP.RATE_PLAN_NO = RD.RATE_PLAN_NO AND                 
MFA-TR*                   RD.COMPANY_NO = :RD-COMPANY-NO AND                    
MFA-TR*                   RD.CODE_UTIL_TYPE = UP.CODE_UTIL_TYPE AND             
MFA-TR*                   UP.CODE_UTIL_TYPE='U'                                 
MFA-TR*            )                                                            
MFA-TR*             ORDER BY CODE_UTIL_TYPE,                                    
MFA-TR*                      RATE_PLAN_NO,                                      
MFA-TR*                      VERSION_NO_CNTRL DESC,                             
MFA-TR*                      LAST_ENERGY_BLOCK DESC,                            
MFA-TR*                      LAST_DEM_BLOCK DESC                                
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*     END-EXEC.                                                   02950000
                                                                        
            EXEC SQL                                                    
                DECLARE CNT_TYPE CURSOR FOR                             
                    SELECT CODE_CONTRACT_TYPE,                          
                           CONTRACT_TYPE_TX                             
                      FROM CSS_CNT_TYPE                                 
                   ORDER BY CODE_CONTRACT_TYPE                          
            END-EXEC.                                                   
                                                                        
            EXEC SQL                                                    
                DECLARE BUDGET_HIST_CR CURSOR FOR                       
                   SELECT DATE_PYMT_STRT,                               
                          EPP_MTHS_RMNG_QT,                             
                          EPP_ESTIMATE                                  
                     FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                 
                    WHERE ACCOUNT_NO = :WS-BUDG-ACCT-NO                 
                      AND PYMT_PRIORITY_LVL = 50                        
                      AND CHANGE_REASON = :WS-HOLD-CHG-REASON           
                 ORDER BY BUD_HIST_SEQ_NO DESC                          
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    03040000
MFA-TR*         DECLARE BUDGET_HIST_CR CURSOR FOR                       03050000
MFA-TR*            SELECT DATE_PYMT_STRT,                               03060000
MFA-TR*                   EPP_MTHS_RMNG_QT,                             03060000
MFA-TR*                   EPP_ESTIMATE                                  03070000
MFA-TR*              FROM CSS_BUDGET_HIST                               03080000
MFA-TR*             WHERE ACCOUNT_NO = :WS-BUDG-ACCT-NO                 03090000
MFA-TR*               AND PYMT_PRIORITY_LVL = 50                        03100000
MFA-TR*               AND CHANGE_REASON = :WS-HOLD-CHG-REASON           03110000
MFA-TR*          ORDER BY BUD_HIST_SEQ_NO DESC                          03120000
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                    03130000
                                                                        
           EXEC SQL                                                     
               DECLARE EPP_ANNIV_DET_CR CURSOR FOR                      
                   SELECT DATE_PYMT_STRT                                
                         ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUD_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') BUD_HIST_SEQ_NO         
                     FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                 
                    WHERE ACCOUNT_NO = :WS-BUDG-ACCT-NO                 
                      AND PYMT_PRIORITY_LVL = 50                        
                      AND CHANGE_REASON = :WS-HOLD-CHG-REASON           
                 ORDER BY BUD_HIST_SEQ_NO DESC                          
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03131000
MFA-TR*        DECLARE EPP_ANNIV_DET_CR CURSOR FOR                      03132000
MFA-TR*            SELECT DATE_PYMT_STRT                                03133000
MFA-TR*                  ,BUD_HIST_SEQ_NO                                       
MFA-TR*              FROM CSS_BUDGET_HIST                               03139500
MFA-TR*             WHERE ACCOUNT_NO = :WS-BUDG-ACCT-NO                 03139600
MFA-TR*               AND PYMT_PRIORITY_LVL = 50                        03139700
MFA-TR*               AND CHANGE_REASON = :WS-HOLD-CHG-REASON           03139800
MFA-TR*          ORDER BY BUD_HIST_SEQ_NO DESC                          03139900
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                    03140000
                                                                        
           EXEC SQL                                                     
               DECLARE EPP_DET_CR CURSOR FOR                            
                   SELECT EPP_MTHS_RMNG_QT                              
                         ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUD_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') BUD_HIST_SEQ_NO         
                         ,REMARKS                                       
                     FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                 
                    WHERE ACCOUNT_NO = :WS-BUDG-ACCT-NO                 
                      AND PYMT_PRIORITY_LVL = 50                        
                      AND CHANGE_REASON = :WS-HOLD-CHG-REASON           
                 ORDER BY BUD_HIST_SEQ_NO DESC                          
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE EPP_DET_CR CURSOR FOR                                    
MFA-TR*            SELECT EPP_MTHS_RMNG_QT                                      
MFA-TR*                  ,BUD_HIST_SEQ_NO                                       
MFA-TR*                  ,REMARKS                                               
MFA-TR*              FROM CSS_BUDGET_HIST                                       
MFA-TR*             WHERE ACCOUNT_NO = :WS-BUDG-ACCT-NO                         
MFA-TR*               AND PYMT_PRIORITY_LVL = 50                                
MFA-TR*               AND CHANGE_REASON = :WS-HOLD-CHG-REASON                   
MFA-TR*          ORDER BY BUD_HIST_SEQ_NO DESC                                  
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE MAINT_TRN_HST CURSOR FOR                         
                   SELECT DISTINCT ('Y')                                
                     FROM CSS_MNT_TRANS_HIST WITH(READUNCOMMITTED)              
                WHERE ACCOUNT_NO = :MH-ACCOUNT-NO                       
                  AND CODE_TRAN_TYPE = 'F'                              
                  AND APPL_PROGRAM_ID = 'PANEL113A'                     
                  AND DATE_TRANS BETWEEN IIF(TRY_CONVERT(DATE, 
                                                     :WS-LAST-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-BILL-DATE
              ) <> 0) OR (LEN(:WS-LAST-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-BILL-DATE
              ), CONVERT(DATE, :WS-LAST-BILL-DATE) )             
                                     AND IIF(TRY_CONVERT(DATE, 
                                                     :WS-THIS-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-THIS-BILL-DATE
              ) <> 0) OR (LEN(:WS-THIS-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-THIS-BILL-DATE
              ), CONVERT(DATE, :WS-THIS-BILL-DATE) )             
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03141000
MFA-TR*        DECLARE MAINT_TRN_HST CURSOR FOR                         03150000
MFA-TR*            SELECT DISTINCT ('Y')                                03160000
MFA-TR*              FROM CSS_MNT_TRANS_HIST                            03170000
MFA-TR*         WHERE ACCOUNT_NO = :MH-ACCOUNT-NO                       03180000
MFA-TR*           AND CODE_TRAN_TYPE = 'F'                              03190000
MFA-TR*           AND APPL_PROGRAM_ID = 'PANEL113A'                     03200000
MFA-TR*           AND DATE_TRANS BETWEEN :WS-LAST-BILL-DATE             03210000
MFA-TR*                              AND :WS-THIS-BILL-DATE             03220000
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                    03230000
                                                                        
      *                                                                 03240000
       LINKAGE SECTION.                                                 
      *                                                                 03240000
       COPY CWS1000A.                                                   03280000
       COPY CWS1000B.                                                   03290000
P00599 COPY CWS1000K.                                                           
       COPY CWS1001A.                                                   03300000
       COPY CWS1001B.                                                   03310000
       COPY CWS10009.                                                   03320000
       COPY CWS00090.                                                   03330000
       COPY CWS00091.                                                   03340000
       COPY CWS0024B.                                                   03360000
       COPY CWS10017.                                                   03370000
       01  WS-SCSCA-RETURN-CODE           PIC S9(4) COMP.               
       01  WS-WQ-CREATED-SW               PIC X(01).                    
       01  WS-INSERT-BILL-CYCLE           PIC X(2).                     
           88 BILL-CYCLE-LT8              VALUE '01' '02' '03' '04'     
                                                '05' '06' '07'.         
COB305 01 WS-INSERT-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.     
      *                                                                 03400000
       COPY CWS00195.                                                           
      *                                                                         
       PROCEDURE DIVISION USING WS-ACCOUNT-AT                           
                                WS-BILLING-BI                           
                                WS-BILLING-BG                           
                                WS-BILL-CALC-DETAIL                     
                                WS-BILL-ADJUST-DETAIL                   
                                WS-AR-CNTRL-AC                          
                                WS-CUST-STATS-CE                        
                                WS-TRANS-HIST-AR                        
                                WS-TRN-HST-DET-AU                       
                                WS-TRANS-HIST-MH                        
                                WS-CONTRACT-CT                          
                                WS-BUDGET-PLAN-BU                       
                                WS-12-MONTH-DATA-EPP                    
                                WS-DFA-ACCT-DA                          
                                WS-DEP-ON-HAND-DO                       
                                WS-MISC-BILL-INFO                       
                                WS-BILLING-WQ-ITEMS-WF                  
                                LS-PCSCA100-COMM-AREA                   
                                WS-SCSCA-RETURN-CODE                    
                                WS-WQ-CREATED-SW                        
                                WS-CNSMPTN-HIST-CX                      
                                WS-AUDIT-BILL-PRINT-CRITERIA            
                                WS-AUDIT-CONDITIONS                     
                                WS-INSERT-BILL-CYCLE                    
                                WS-INSERT-REVENUE-MONTH                 
T35152                          WS-NAME-ADDRESS                         
I00177                          WS-CA195-GRP2-FIELDS                    
I00177                          WS-CWS1000B-MAX-TBL-LIMITS              
P00599                          WS-PREPAY-HIST-PK                       
P00599                          WS-BILL-CRED-DET-1H                     
P00680                          WS-ACCT-RTPK-AGR-DF                     
P00680                          WS-UTILITY-TABLE-UT                     
ACT055                          WS-ACCT-MKT-TIER-DD                     
ACT055                          WS-FIXED-FCTR-HIST-FH.                  
                                                                        
      ************************************************************      03660000
      *  PERFORM THE INITIALIZATION ROUTINE THE FIRST TIME THIS  *      03670000
      *  PROGRAM IS CALLED FROM PCSCA105.  CHECK THE USER TABLE  *      03680000
      *  AND ALL CONDITIONS.  IF THE ACCOUNT SHOULD BE AUDITED,  *      03690000
      *  SET THE AUDIT FLAG, PASS THE AUDIT REASON, AND EXIT.    *      03700000
      ************************************************************      03710000
       0000-MAINLINE.                                                   
      *                                                                 03740000
           MOVE SPACES TO WS-AUD-COND-CODE.                             
           MOVE SPACES TO WS-AUD-COND-RATE.                             
           MOVE SPACES TO WS-BUDGET-TRAN-DATE.                          
           MOVE 'N' TO WS-EBILL-SW.                                     
P00411     INITIALIZE WS-AUD-SUB.                                       
      *                                                                 03770000
           IF CSR-DATABASE                                              
               MOVE +27 TO WS-DAYS-LO                                   
                   MOVE +34 TO WS-DAYS-HI                               
           END-IF.                                                      
           IF SEB-DATABASE                                              
               MOVE +25 TO WS-DAYS-LO                                   
                   MOVE +35 TO WS-DAYS-HI                               
           END-IF.                                                      
           IF (WS-EBILL-REGISTER-IND-CE = 'Y' AND                       
               WS-NO-BILL-COPIES-AT > 0)                                
               MOVE 'Y' TO WS-EBILL-SW                                  
           END-IF.                                                      
      *                                                                 03900000
           IF WS-AUDIT-TABLES-BUILT <= SPACES                           
               PERFORM 0100-INITIALIZATION THRU 0100-EXIT
           END-IF.              
                                                                        
           MOVE SPACES TO WS-REG-PROV-AUDIT                             
                          WS-PLAN-ANNIV-SW                              
                          WS-SPECIAL-RATE-FOUND-FL.                     
                                                                        
           MOVE 1      TO WS-BG-SUB.                                    
           IF SEB-DATABASE                                              
              IF WS-REGULATED-CD-AT NOT = '02'                          
ACT056            PERFORM 2901-30DAY-VAR-MSG    THRU 2901-EXIT          
ACT056            PERFORM 2902-60DAY-VAR-MSG    THRU 2902-EXIT          
                  PERFORM 2900-AUTO-EPP-OFFER   THRU 2900-EXIT          
                  PERFORM 3000-AUTO-EPP-WELCOME THRU 3000-EXIT          
              END-IF                                                    
              IF WS-REGULATED-CD-AT = '02'                              
                 PERFORM 2400-CHK-GROUP-TRAN THRU 2400-EXIT             
                 PERFORM 2500-CHK-RECONNECT  THRU 2500-EXIT             
                 PERFORM 2700-REGULATED-MESG THRU 2700-EXIT             
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF CSR-DATABASE                                              
               IF WS-COMPANY-NO-AT = '01'                               
P00411             PERFORM 1060-SELECT-WNA   THRU 1060-EXIT             
               END-IF                                                   
ACT029         PERFORM 2900-AUTO-EPP-OFFER   THRU 2900-EXIT             
ACT029         PERFORM 3000-AUTO-EPP-WELCOME THRU 3000-EXIT             
A02879         PERFORM 1100-SELECT-RATE-STEP THRU 1100-EXIT             
           END-IF                                                       
           PERFORM 1000-CHECK-AUDIT-BILL-TABLE THRU 1000-EXIT.          
A05290     IF SEB-DATABASE                                              
A05290        PERFORM 1220-DOUBLE-AGL-PASS-CHARGES THRU 1220-EXIT       
ACT055        IF WS-REGULATED-CD-AT = '02'                              
ACT055           PERFORM 1225-REG-INITIAL-BILL-AUDIT  THRU 1225-EXIT    
ACT055        ELSE                                                      
ACT055           PERFORM 1226-DEREG-INITIAL-BILL-AUDIT  THRU 1226-EXIT  
ACT055           PERFORM 1227-DEREG-INIT-BILL-WTOUT-CSC THRU 1227-EXIT  
ACT055        END-IF                                                    
A05290     END-IF.                                                      
ACT230     IF ((SEB-DATABASE AND WS-REGULATED-CD-AT = '02') OR          
ACT230         (CSR-DATABASE AND WS-COMPANY-NO-AT   = '26'))            
ACT230        CONTINUE                                                  
ACT230     ELSE                                                         
ACT230        PERFORM 1050-SELECT-FINAL THRU 1050-EXIT                  
ACT230        PERFORM 1055-SELECT-DRAFT THRU 1055-EXIT                  
ACT230     END-IF.                                                      
                                                                        
           MOVE 1 TO SUB1.                                              
           MOVE SPACES TO WS-HOLD-PRORATE-CD.                           
           MOVE 'N' TO WS-RESIDENTIAL-SW                                
                       WS-COMMERCIAL-SW                                 
                       WS-ELECTRIC-SERVICE                              
                       WS-GAS-SERVICE                                   
                       WS-PRORATED-SW.                                  
           PERFORM UNTIL SUB1 > 30 OR WS-ACCOUNT-NO-BG (SUB1) = ZEROES  
            IF WS-ACCOUNT-NO-BI =                                       
                WS-ACCOUNT-NO-BG (SUB1) AND                             
                WS-BILL-NO-BI = WS-BILL-NO-BG (SUB1) AND                
                WS-REVENUE-MONTH-BG (SUB1) NOT = ZEROS                  
ACT230          IF ((SEB-DATABASE AND WS-REGULATED-CD-AT = '02') OR     
ACT230              (CSR-DATABASE AND WS-COMPANY-NO-AT   = '26'))       
ACT230             CONTINUE                                             
ACT230          ELSE                                                    
                   PERFORM 1200-SELECT-LOST-ACCOUNTS THRU 1200-EXIT     
ACT230          END-IF                                                  
               MOVE 1 TO SUB2                                           
               PERFORM 1210-SELECT-BILL-TYPES THRU 1210-EXIT            
               IF WS-RATE-PLAN-NO-BG (SUB1) = '009'                     
                   MOVE 1 TO SUB2                                       
                   PERFORM 1230-RATE-009-ONPEAK-KVA THRU 1230-EXIT      
               END-IF                                                   
               EVALUATE WS-CODE-REVENUE-CLASS-BG (SUB1) (2:1)           
                 WHEN '1'                                               
                    MOVE 'Y' TO WS-RESIDENTIAL-SW                       
                 WHEN '2'                                               
                    MOVE 'Y' TO WS-COMMERCIAL-SW                        
               END-EVALUATE                                             
P00565         IF CSR-DATABASE                                          
                  PERFORM 1250-PRORATE-SETUP THRU 1250-EXIT             
               END-IF                                                   
            END-IF                                                      
               ADD 1 TO SUB1                                            
           END-PERFORM.                                                 
                                                                        
P00565     IF CSR-DATABASE                                              
              PERFORM 1260-PRORATE-ACCOUNTS THRU 1260-EXIT              
           END-IF.                                                      
           IF EBILL                                                     
              PERFORM 1270-EBILL-ACCOUNTS THRU 1270-EXIT                
           END-IF.                                                      
                                                                        
           PERFORM 1300-SELECT-FIXED-INCOME THRU 1300-EXIT.             
ACT230     IF (SEB-DATABASE AND WS-REGULATED-CD-AT = '02')              
ACT230        CONTINUE                                                  
ACT230     ELSE                                                         
ACT230        PERFORM 1400-EPP-FIRST-MONTH THRU 1400-EXIT               
ACT230     END-IF.                                                      
                                                                        
           MOVE 1 TO SUB1.                                              
I00177     PERFORM UNTIL SUB1 > WS-AC-MAX-ENTRY                         
I00177                OR WS-ACCOUNT-NO-AC (SUB1) = ZEROES               
               MOVE WS-PYMT-PRIORITY-LVL-AC (SUB1) TO WS-PYMT-PRTY-LVL  
P00453******************************************************************        
P00453*As payment priority 50 is used for Scana Energy Prepay as well  *        
P00453*have to include ACOOUNT-NO-BU check to make sure the account is *        
P00453*budget billing.                                                 *        
P00453******************************************************************        
ACT230     IF (SEB-DATABASE AND WS-REGULATED-CD-AT = '02')              
ACT230        CONTINUE                                                  
ACT230     ELSE                                                         
P00453         IF WS-ACCOUNT-NO-BU > ZEROES AND                         
P00453            WS-BUD-PYMT-PRTY AND                                  
                  WS-ITEM-ID-AC (SUB1) = 1                              
                      PERFORM 1500-EPP-CREDIT-DEBIT-ARREARS THRU        
                              1500-EXIT                                 
               END-IF                                                   
ACT230     END-IF                                                       
P00453         IF WS-ACCOUNT-NO-BU = ZEROES AND                         
P00453            WS-ACCOUNT-NO-PK (1) > ZEROES AND                     
P00453            WS-BUD-PYMT-PRTY                                      
P00453                PERFORM 3800-PREPAY THRU 3800-EXIT                
P00453         END-IF                                                   
               IF WS-DFA-PYMT-PRTY                                      
                   PERFORM 1510-DPP-DEBIT-AND-NO-ARREARS THRU 1510-EXIT 
               END-IF                                                   
               IF NOT WS-UTL-PYMT-PRTY AND                              
                  NOT WS-CNT-PYMT-PRTY AND                              
                  NOT WS-BUD-PYMT-PRTY AND                              
                  NOT WS-DFA-PYMT-PRTY AND                              
                  NOT WS-LPC-PYMT-PRTY                                  
                      PERFORM 1560-NON-UTILITY-CHARGES THRU 1560-EXIT   
               END-IF                                                   
               ADD 1 TO SUB1                                            
           END-PERFORM.                                                 
                                                                        
ACT230     IF (SEB-DATABASE AND WS-REGULATED-CD-AT = '02')              
ACT230        CONTINUE                                                  
ACT230     ELSE                                                         
ACT230        PERFORM 1600-LATE-PAYMENT-CHARGE THRU 1600-EXIT           
ACT230     END-IF.                                                      
           PERFORM 1700-SELECT-ADD-SUB-METERS THRU 1700-EXIT.           
           PERFORM 1800-PROCESS-BA THRU 1800-EXIT.                      
           PERFORM 1900-MULTIPLE-DUE-DATES THRU 1900-EXIT.              
           PERFORM 2000-INSTALLMENT-CONTRACT THRU 2000-EXIT.            
           PERFORM 2005-SERVICECARE-TAX      THRU 2005-EXIT.            
ACT230     IF (SEB-DATABASE AND WS-REGULATED-CD-AT = '02')              
ACT230        CONTINUE                                                  
ACT230     ELSE                                                         
ACT230        PERFORM 2100-DEPOSIT-REFUND THRU 2100-EXIT                
ACT230     END-IF.                                                      
           PERFORM 2200-CREDIT-MESSAGES THRU 2200-EXIT.                 
           IF WS-COMPANY-NO-AT = '26'                                   
              PERFORM 2300-EXCISE-TAX-EXEMPT THRU 2300-EXIT             
           END-IF.                                                      
           PERFORM 1075-PCOMP-AUDIT          THRU 1075-EXIT.            
ACT230     IF (CSR-DATABASE AND WS-COMPANY-NO-AT   = '26')              
ACT230        CONTINUE                                                  
ACT230     ELSE                                                         
ACT230        PERFORM 1730-DFA-ACCOUNT       THRU 1730-EXIT             
ACT230     END-IF.                                                      
           PERFORM 1740-TAX-EXEMPT           THRU 1740-EXIT.            
      * THE FOLLOWING CPOMMENTED PARAGRAPHS WILL BE WORKED LATER - SV           
      *    PERFORM 1760-WNA-HILO-CHECK-FAIL  THRU 1760-EXIT.                    
      * END                                                                     
      * EPP AUDITS                                                              
           PERFORM 3150-EPP-INITIAL-SETUP    THRU 3150-EXIT.            
           PERFORM 3200-EPP-DROPS            THRU 3200-EXIT.            
           PERFORM 3300-EPP-ANNIV            THRU 3300-EXIT.            
           PERFORM 3400-EPP-CHANGE           THRU 3400-EXIT.            
      * EPP CREDITS AND DEBITS CAN'T BE WORKED ON AS THE BALANCE BROUGHT        
      * CAN BE CALCULATED ONLY AT PCSCA166 OR PCSCA167.                         
      * MARKETING CONTRACTS.                                                    
      *                                                                         
           PERFORM 3500-INITIAL-SETUP        THRU 3500-EXIT.            
           PERFORM 3525-DOWN-PAYMENT         THRU 3525-EXIT.            
           PERFORM 3550-PAYOFF               THRU 3550-EXIT.            
           PERFORM 3575-CANCEL-CONTRACT      THRU 3575-EXIT.            
           PERFORM 3600-ONE-TIME-CONTRACT    THRU 3600-EXIT.            
           PERFORM 3610-INSTALLMENTS         THRU 3610-EXIT.            
           PERFORM 3625-CONTRACT-FOR-JOBBING THRU 3625-EXIT.            
           PERFORM 3650-TRANSFER-CONTRACT    THRU 3650-EXIT.            
           IF SEB-DATABASE                                              
              PERFORM 3680-SEB-RATE-DROP     THRU 3680-EXIT             
A03019        PERFORM 3700-AGL-SR-DISCOUNT   THRU 3700-EXIT             
P00680        PERFORM 2800-PROCESS-PRICE-NEGOTIATED THRU 2800-EXIT      
P805CS        PERFORM 3725-CSC-DISCOUNTS     THRU 3725-EXIT             
           END-IF.                                                      
                                                                        
           EXIT PROGRAM.                                                
      *                                                                 05200000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05230000
      ************************************************************      05240000
      *  BUILD THE RATE STEP TABLE.  THERE IS AN OCCURRENCE ON   *      05250000
      *  THIS TABLE FOR EACH STEP WITHIN EACH RATE.  IF A RATE   *      05260000
      *  CAN HAVE 2 ENERGY BLOCKS, THERE WILL BE TWO LINES IN    *      05270000
      *  THE TABLE FOR THIS RATE (ENERGY).  DITTO DEMAND BLOCKS. *      05280000
      *  BUILD THE CONTRACT TYPE TABLE.  NOTE THAT ONLY ONE OF   *      05290000
      *  EACH CONTRACT TYPE WILL BE SELECTED.  CHANGE THE MAX    *      05300000
      *  VALUE TO INCREASE THIS.                                 *      05310000
      ************************************************************      05320000
       0100-INITIALIZATION.                                             
      *                                                                 05350000
           MOVE 'N' TO WS-WQ-CREATED-SW.                                
           MOVE WS-COMPANY-NO-AT TO RD-COMPANY-NO.                      
           EXEC SQL                                                     
               OPEN RATE_COMP_DEF                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
               MOVE 'J1' TO WS-DB2-TABLE-ID                             
               MOVE 'OPEN  ' TO WS-DB2-FUNCTION                         
               MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
               MOVE '168' TO WS-DB2-MODULE-ID                           
               MOVE '0100' TO WS-DB2-PARAGRAPH                          
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT
           END-IF.               
           MOVE 1 TO WS-RATE-SUB.                                       
           PERFORM 0110-BUILD-RATE-STEP-TABLE THRU 0110-EXIT.           
                                                                        
           EXEC SQL                                                     
               CLOSE RATE_COMP_DEF                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
               MOVE 'J1' TO WS-DB2-TABLE-ID                             
               MOVE 'CLOSE ' TO WS-DB2-FUNCTION                         
               MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
               MOVE '168' TO WS-DB2-MODULE-ID                           
               MOVE '0100' TO WS-DB2-PARAGRAPH                          
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT
           END-IF.               
                                                                        
           EXEC SQL                                                     
               OPEN CNT_TYPE                                            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
               display 'Open CNT_TYPE not successful'                   
               MOVE 'K7' TO WS-DB2-TABLE-ID                             
               MOVE 'OPEN  ' TO WS-DB2-FUNCTION                         
               MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
               MOVE '168' TO WS-DB2-MODULE-ID                           
               MOVE '0100' TO WS-DB2-PARAGRAPH                          
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT
           END-IF.               
           MOVE 1 TO WS-CNT-SUB.                                        
           PERFORM 0120-BUILD-CONTRACT-TABLE THRU 0120-EXIT             
           EXEC SQL                                                     
               CLOSE CNT_TYPE                                           
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
           display 'close CNT_TYPE not successful'                      
               MOVE 'K7' TO WS-DB2-TABLE-ID                             
               MOVE 'CLOSE ' TO WS-DB2-FUNCTION                         
               MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
               MOVE '168' TO WS-DB2-MODULE-ID                           
               MOVE '0100' TO WS-DB2-PARAGRAPH                          
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT
           END-IF.               
           MOVE 'Y' TO WS-AUDIT-TABLES-BUILT.                           
           MOVE WS-INSERT-REVENUE-MONTH   TO WS-PREV-REVENUE-MONTH.     
           IF WS-PREV-REV-MTH-MM = 12                                   
              MOVE 01                     TO WS-PREV-REV-MTH-MM         
              COMPUTE WS-PREV-REV-MTH-YY    =                           
                      WS-PREV-REV-MTH-YY    - 1                         
           ELSE                                                         
              COMPUTE WS-PREV-REVENUE-MONTH =                           
                      WS-INSERT-REVENUE-MONTH - 1                       
           END-IF.                                                      
      *                                                                 05940000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05970000
      ************************************************************      05980000
      *  FETCH RATE COMPONENT DEFINITIONS.  ONLY THE MOST RECENT *      05990000
      *  VERSION WILL BE PROCESSED.                              *      06000000
      ************************************************************      06010000
       0110-BUILD-RATE-STEP-TABLE.                                      
      *                                                                 06040000
           EXEC SQL                                                     
               FETCH RATE_COMP_DEF                                      
                INTO :J1-CODE-UTIL-TYPE,                                
                     :J1-RATE-PLAN-NO,                                  
                     :J1-VERSION-NO-CNTRL,                              
                     :J1-LAST-ENERGY-BLOCK,                             
                     :J1-LAST-DEM-BLOCK                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 0110-EXIT                                      
               WHEN OTHER                                               
                   MOVE 'J1' TO WS-DB2-TABLE-ID                         
                   MOVE 'FETCH ' TO WS-DB2-FUNCTION                     
                   MOVE SQLCODE TO WS-DB2-RETURN-CODE                   
                   MOVE '168' TO WS-DB2-MODULE-ID                       
                   MOVE '0110' TO WS-DB2-PARAGRAPH                      
                   MOVE 12 TO RETURN-CODE                               
                   PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT            
           END-EVALUATE.                                                
                                                                        
           IF J1-CODE-UTIL-TYPE = WS-HOLD-UTIL-TYPE AND                 
              J1-RATE-PLAN-NO = WS-HOLD-RATE-PLAN-NO                    
                  GO TO 0110-BUILD-RATE-STEP-TABLE                      
           ELSE                                                         
               MOVE J1-CODE-UTIL-TYPE TO WS-HOLD-UTIL-TYPE              
               MOVE J1-RATE-PLAN-NO TO WS-HOLD-RATE-PLAN-NO
           END-IF.            
                                                                        
           MOVE 1 TO WS-STEP-SUB                                        
           PERFORM UNTIL WS-STEP-SUB > 9 OR                             
                         WS-STEP-SUB > J1-LAST-ENERGY-BLOCK             
               MOVE J1-CODE-UTIL-TYPE TO                                
                    WS-RATE-STEP-UTIL-TYPE (WS-RATE-SUB)                
               MOVE J1-RATE-PLAN-NO TO                                  
                    WS-RATE-STEP-PLAN-NO (WS-RATE-SUB)                  
               MOVE 'N' TO WS-RATE-STEP-SELECTED (WS-RATE-SUB)          
               MOVE 0 TO WS-RATE-STEP-DEMAND-BLOCKS (WS-RATE-SUB)       
               MOVE WS-STEP-SUB TO                                      
                    WS-RATE-STEP-ENERGY-BLOCKS (WS-RATE-SUB)            
               ADD 1 TO WS-STEP-SUB WS-RATE-SUB                         
               IF WS-RATE-SUB > 1500                                    
                   MOVE 'RATE STEP TABLE SUBSCRIPT EXCEEDED' TO         
                        WS-MISC-MSG-TEXT                                
                   MOVE +34 TO WS-MISC-MSG-LEN                          
                   PERFORM 9910-MISC-ERROR THRU 9910-EXIT               
                   PERFORM 9999-BAIL-OUT THRU 9999-EXIT                 
               END-IF                                                   
           END-PERFORM.                                                 
           MOVE 1 TO WS-STEP-SUB                                        
           PERFORM UNTIL WS-STEP-SUB > 5 OR                             
                         WS-STEP-SUB > J1-LAST-DEM-BLOCK                
               MOVE J1-CODE-UTIL-TYPE TO                                
                    WS-RATE-STEP-UTIL-TYPE (WS-RATE-SUB)                
               MOVE J1-RATE-PLAN-NO TO                                  
                    WS-RATE-STEP-PLAN-NO (WS-RATE-SUB)                  
               MOVE 'N' TO WS-RATE-STEP-SELECTED (WS-RATE-SUB)          
               MOVE 0 TO WS-RATE-STEP-ENERGY-BLOCKS (WS-RATE-SUB)       
               MOVE WS-STEP-SUB TO                                      
                    WS-RATE-STEP-DEMAND-BLOCKS (WS-RATE-SUB)            
               ADD 1 TO WS-STEP-SUB WS-RATE-SUB                         
               IF WS-RATE-SUB > 1500                                    
                   MOVE 'RATE STEP TABLE SUBSCRIPT EXCEEDED' TO         
                        WS-MISC-MSG-TEXT                                
                   MOVE +34 TO WS-MISC-MSG-LEN                          
                   PERFORM 9910-MISC-ERROR THRU 9910-EXIT               
                   PERFORM 9999-BAIL-OUT THRU 9999-EXIT                 
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
A04429*Unmetered rate plans                                                     
A04429     IF (WS-HOLD-UTIL-TYPE = 'U')                                 
A04429         MOVE J1-CODE-UTIL-TYPE TO                                
A04429              WS-RATE-STEP-UTIL-TYPE (WS-RATE-SUB)                
A04429         MOVE J1-RATE-PLAN-NO TO                                  
A04429              WS-RATE-STEP-PLAN-NO (WS-RATE-SUB)                  
A04429         MOVE 'N' TO WS-RATE-STEP-SELECTED (WS-RATE-SUB)          
A04429         MOVE 0 TO WS-RATE-STEP-ENERGY-BLOCKS (WS-RATE-SUB)       
A04429         MOVE 0 TO WS-RATE-STEP-DEMAND-BLOCKS (WS-RATE-SUB)       
A04429         ADD 1 TO WS-RATE-SUB                                     
A04429                                                                  
A04429         IF WS-RATE-SUB > 1500                                    
A04429             MOVE 'RATE STEP TABLE SUBSCRIPT EXCEEDED' TO         
A04429                  WS-MISC-MSG-TEXT                                
A04429             MOVE +34 TO WS-MISC-MSG-LEN                          
A04429             PERFORM 9910-MISC-ERROR THRU 9910-EXIT               
A04429             PERFORM 9999-BAIL-OUT THRU 9999-EXIT                 
A04429         END-IF                                                   
A04429     END-IF.                                                      
                                                                        
           GO TO 0110-BUILD-RATE-STEP-TABLE.                            
      *                                                                 06800000
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06830000
      ************************************************************      06840000
      *  FETCH CONTRACT TYPES.                                   *      06850000
      ************************************************************      06860000
       0120-BUILD-CONTRACT-TABLE.                                       
      *                                                                 06890000
           EXEC SQL                                                     
               FETCH CNT_TYPE                                           
                INTO :K7-CODE-CONTRACT-TYPE,                            
                     :K7-CONTRACT-TYPE-TX                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 0120-EXIT                                      
               WHEN OTHER                                               
                   display '0120 Fetch Other'                           
                   display 'return code= ' WS-ACTIVE-RETURN-CODE        
                   MOVE 'K7' TO WS-DB2-TABLE-ID                         
                   MOVE 'FETCH ' TO WS-DB2-FUNCTION                     
                   MOVE SQLCODE TO WS-DB2-RETURN-CODE                   
                   MOVE '168' TO WS-DB2-MODULE-ID                       
                   MOVE '0120' TO WS-DB2-PARAGRAPH                      
                   MOVE 12 TO RETURN-CODE                               
                   PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT            
           END-EVALUATE.                                                
                                                                        
           MOVE K7-CODE-CONTRACT-TYPE TO WS-CONTRACT-TYPE (WS-CNT-SUB). 
           MOVE K7-CONTRACT-TYPE-TX TO WS-CONTRACT-DESC (WS-CNT-SUB).   
           MOVE 'N' TO WS-CONTRACT-SELECTED (WS-CNT-SUB).               
           MOVE 0 TO WS-CONTRACT-COUNTER (WS-CNT-SUB).                  
           MOVE 1 TO WS-CONTRACT-MAX (WS-CNT-SUB).                      
           ADD 1 TO WS-CNT-SUB.                                         
           IF WS-CNT-SUB > 100                                          
               MOVE 'CONTRACT TYPE TABLE SUBSCRIPT EXCEEDED' TO         
                    WS-MISC-MSG-TEXT                                    
               MOVE +38 TO WS-MISC-MSG-LEN                              
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
               PERFORM 9999-BAIL-OUT THRU 9999-EXIT
           END-IF.                    
           GO TO 0120-BUILD-CONTRACT-TABLE.                             
      *                                                                 07290000
       0120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07290000
      ************************************************************      07330000
      *  SET THE AUDIT FLAG IN THE ACCOUNT SEGMENT OF CWS10000   *      07340000
      *  AND EXIT THE PROGRAM.                                   *      07350000
      ************************************************************      07360000
       0200-SELECT-AND-GO.                                              
      *                                                                 07390000
           MOVE 'Y' TO WS-AUDIT-FLAG-CALC.                              
           EXIT PROGRAM.                                                
      *                                                                 07420000
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07450000
      ************************************************************      07460000
      *  CHECK THE USER TABLE TO SEE IF THE ACCOUNT SHOULD BE    *      07470000
      *  AUDITED REGARDLESS OF CONDITION MATCH.                  *      07480000
      ************************************************************      07490000
       1000-CHECK-AUDIT-BILL-TABLE.                                     
      *                                                                 07520000
           MOVE WS-ACCOUNT-NO-AT TO K8-ACCOUNT-NO.                      
           MOVE WS-REV-MTH-LST-NRML-AT   TO K8-REVENUE-MONTH.           
           EXEC SQL                                                     
               SELECT ACCOUNT_NO                                        
                 INTO :K8-ACCOUNT-NO                                    
                 FROM CSS_AUDIT_BLL_ACCT WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO = :K8-ACCOUNT-NO                       
                  AND REVENUE_MONTH = :K8-REVENUE-MONTH                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07540000
MFA-TR*        SELECT ACCOUNT_NO                                        07550000
MFA-TR*          INTO :K8-ACCOUNT-NO                                    07560000
MFA-TR*          FROM CSS_AUDIT_BLL_ACCT                                07570000
MFA-TR*         WHERE ACCOUNT_NO = :K8-ACCOUNT-NO                       07580000
MFA-TR*           AND REVENUE_MONTH = :K8-REVENUE-MONTH                 07581000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    07590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
T35152             MOVE 'TBLE' TO                     WS-AUD-COND-CODE  
                   PERFORM 0200-SELECT-AND-GO THRU 0200-EXIT            
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'K8' TO WS-DB2-TABLE-ID                         
                   MOVE 'SELECT' TO WS-DB2-FUNCTION                     
                   MOVE SQLCODE TO WS-DB2-RETURN-CODE                   
                   MOVE '168' TO WS-DB2-MODULE-ID                       
                   MOVE '1000' TO WS-DB2-PARAGRAPH                      
                   MOVE K8-ACCOUNT-NO TO WS-DB2-KEY-1N                  
                   MOVE 12 TO RETURN-CODE                               
                   PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT            
           END-EVALUATE.                                                
      *                                                                 07780000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07810000
      ************************************************************      07820000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      07830000
      *  0058 = FINAL ACCOUNT                                    *      07840000
      ************************************************************      07850000
       1050-SELECT-FINAL.                                               
      *                                                                 07870000
A02003     IF WS-CODE-ACCT-STAT-AT = 'B'                                
A02003       MOVE 58 TO WS-AUD-SUB                                      
A02003       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
A02003     END-IF.                                                      
      *                                                                 07960000
       1050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07990000
      ************************************************************      08000000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      08010000
      *  0059 = DRAFT ACCOUNT                                    *      08020000
      ************************************************************      08030000
       1055-SELECT-DRAFT.                                               
      *                                                                 08050000
A02003     IF WS-CODES-DATA-PRESENT-AT (14:1) = 'A'                     
A02003       MOVE 59 TO WS-AUD-SUB                                      
A02003       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
A02003     END-IF.                                                      
      *                                                                 08140000
       1055-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08170000
P00411************************************************************      08000000
P00411*  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      08010000
P00411*  0173 TO 190 TO SELECT 18 WNA GROUPS                     *      08020000
P00411************************************************************      08030000
P00411 1060-SELECT-WNA.                                                 
P00411*                                                                 08050000
P00411     INITIALIZE WS-AUD-SUB.                                       
P00411     PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL            
P00411       WS-BILLING-INDX > 30 OR                                    
P00411       WS-ACCOUNT-NO-BG(WS-BILLING-INDX) = 0                      
P00411       IF WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'C' AND     
P00411          WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) = 'E'             
P00411          EVALUATE WS-RT-PKG-OPT-SEQ-NO-BG(WS-BILLING-INDX)       
P00411              WHEN 1                                              
                         MOVE 173            TO WS-AUD-SUB              
                    WHEN 2                                              
                         MOVE 174            TO WS-AUD-SUB              
                    WHEN 3                                              
                         MOVE 175            TO WS-AUD-SUB              
                    WHEN 4                                              
                         MOVE 176            TO WS-AUD-SUB              
                    WHEN 5                                              
                         MOVE 177            TO WS-AUD-SUB              
                    WHEN 6                                              
                         MOVE 178            TO WS-AUD-SUB              
                    WHEN 7                                              
                         MOVE 179            TO WS-AUD-SUB              
                    WHEN 8                                              
                         MOVE 180            TO WS-AUD-SUB              
                    WHEN 9                                              
                         MOVE 181            TO WS-AUD-SUB              
                    WHEN 10                                             
                         MOVE 182            TO WS-AUD-SUB              
                    WHEN 11                                             
                         MOVE 183            TO WS-AUD-SUB              
                    WHEN 12                                             
                         MOVE 184            TO WS-AUD-SUB              
                    WHEN 13                                             
                         MOVE 185            TO WS-AUD-SUB              
                    WHEN 14                                             
                         MOVE 186            TO WS-AUD-SUB              
                    WHEN 15                                             
                         MOVE 187            TO WS-AUD-SUB              
                    WHEN 16                                             
                         MOVE 188            TO WS-AUD-SUB              
                    WHEN 17                                             
                         MOVE 189            TO WS-AUD-SUB              
                    WHEN 18                                             
                         MOVE 190            TO WS-AUD-SUB              
A03019              WHEN 19                                             
A03019                   MOVE 1              TO WS-AUD-SUB              
                END-EVALUATE                                            
P00411          PERFORM 1065-CHECK-AUDIT-COND    THRU 1065-EXIT         
P00411       END-IF                                                     
P00411     END-PERFORM.                                                 
P00411*                                                                 08140000
P00411 1060-EXIT.                                                       
P00411     EXIT.                                                        
P00411*                                                                 08170000
P00411 1065-CHECK-AUDIT-COND.                                           
P00411                                                                  
P00411     IF WS-AUD-SUB > 0 AND                                        
P00411       (WS-AUDIT-SELECTED (WS-AUD-SUB) = 'N' OR                   
P00411       (WS-AUDIT-SELECTED (WS-AUD-SUB) = 'Y' AND                  
P00411        WS-AUDIT-COUNTER (WS-AUD-SUB) <                           
P00411        WS-AUDIT-MAX (WS-AUD-SUB)))                               
P00411          MOVE WS-AUDIT-CONDITION (WS-AUD-SUB) TO                 
P00411                                   WS-AUD-COND-CODE               
P00411          MOVE 'Y'              TO WS-AUDIT-SELECTED(WS-AUD-SUB)  
P00411          ADD 1                 TO WS-AUDIT-COUNTER (WS-AUD-SUB)  
P00411          PERFORM 0200-SELECT-AND-GO THRU 0200-EXIT               
P00411     END-IF.                                                      
A02003     MOVE 0 TO WS-AUD-SUB.                                        
P00411*                                                                 08220000
P00411 1065-EXIT.                                                       
P00411     EXIT.                                                        
P00411*                                                                 08220000
      ****************************************************************  08180000
      **  P-COMP BILLS IN AUDITS FOR SCEG, PSNC, SEB AND SEBR       **  08190000
      ** GAS ONLY ACCOUNTS AND COMBO WITH GAS SERVICE HAVING PCOMP  **  08200000
      ****************************************************************  08210000
      *                                                                 08220000
       1075-PCOMP-AUDIT.                                                
A04494     IF CSR-DATABASE AND WS-COMPANY-NO-AT = '01'                  
A04494        IF (ELECTRIC AND GAS)                                     
A04494           PERFORM 1080-GET-PCOMP-COMBO    THRU 1080-EXIT         
A04494        ELSE                                                      
A04494           IF GAS                                                 
A04494              PERFORM 1085-GET-PCOMP-GAS-ONLY THRU 1085-EXIT      
A04494           END-IF                                                 
A04494        END-IF                                                    
           END-IF.                                                      
      *                                                                 08300000
       1075-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08330000
       1080-GET-PCOMP-COMBO.                                            
           PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1 UNTIL            
                   WS-CNSMPTN-INDX > 200 OR                             
                   WS-ACCOUNT-NO-CX(WS-CNSMPTN-INDX) = ZERO             
                   IF WS-CODE-UTIL-TYPE-CX(WS-CNSMPTN-INDX) = 'G' AND   
                      WS-PCOMP-FCT-CX(WS-CNSMPTN-INDX) > 1              
A02003                MOVE 119 TO WS-AUD-SUB                            
A02003                PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT      
                   END-IF                                               
           END-PERFORM.                                                 
      *                                                                 08500000
       1080-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08500000
A04494 1085-GET-PCOMP-GAS-ONLY.                                         
A04494     PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1 UNTIL            
A04494             WS-CNSMPTN-INDX > 200 OR                             
A04494             WS-ACCOUNT-NO-CX(WS-CNSMPTN-INDX) = ZERO             
A04494             IF WS-CODE-UTIL-TYPE-CX(WS-CNSMPTN-INDX) = 'G' AND   
A04494                WS-PCOMP-FCT-CX(WS-CNSMPTN-INDX) > 1              
A04494                MOVE 118 TO WS-AUD-SUB                            
A04494                PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT      
A04494             END-IF                                               
A04494     END-PERFORM.                                                 
      *                                                                 08500000
       1085-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08530000
      ************************************************************      08740000
      *  PROCESS ALL BC RECORDS FOR THE ACCOUNT.  GET THE RATE   *      08750000
      *  PLAN FROM THE CORRESPONDING BG FOR EACH BC.  CHECK THE  *      08760000
      *  ENERGY AND DEMAND COMPONENTS.  CHECK SELECTIONS REASONS *      08770000
      *  FROM THE BC RECORDS.                                    *      08780000
      ************************************************************      08790000
       1100-SELECT-RATE-STEP.                                           
      *                                                                 08820000
           MOVE 1 TO SUB1.                                              
                                                                        
I00177     PERFORM UNTIL SUB1 > WS-BZ-MAX-ENTRY                         
I00177                OR WS-ACCOUNT-NO-BC (SUB1) = ZEROES               
                                                                        
               MOVE SPACES TO WS-MATCH-RATE-PLAN                        
               PERFORM 1105-SEARCH-BG THRU 1105-EXIT                    
A04429         MOVE 1 TO WS-RATE-SUB                                    
A04429                                                                  
A04429         IF WS-CODE-UTIL-TYPE-BC (SUB1) = 'U'                     
A04429             PERFORM 1125-UNMETERED-PLAN THRU 1125-EXIT           
A04429         ELSE                                                     
                   IF WS-CONSUMPTION-TYPE-BC (SUB1) = 'B' OR 'C'        
                       PERFORM 1110-ENERGY-COMPONENT THRU 1110-EXIT     
                   END-IF                                               
                   IF WS-CONSUMPTION-TYPE-BC (SUB1) = 'E' OR 'J'        
                       PERFORM 1120-DEMAND-COMPONENT THRU 1120-EXIT     
                   END-IF                                               
                   PERFORM 1130-SELECTION-REASONS THRU 1130-EXIT        
A04429         END-IF                                                   
               ADD 1 TO SUB1                                            
           END-PERFORM.                                                 
      *                                                                 09000000
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09030000
      ************************************************************      09040000
      *  GET THE RATE PLAN FROM THE CORRESPONDING BG.            *      09050000
      ************************************************************      09060000
       1105-SEARCH-BG.                                                  
      *                                                                 09090000
           SET WS-BILLING-INDX TO 1.                                    
           SEARCH WS-BILLING-DATA                                       
             AT END                                                     
                 MOVE SPACES TO WS-MATCH-RATE-PLAN                      
             WHEN (WS-ACCOUNT-NO-BC (SUB1) =                            
                   WS-ACCOUNT-NO-BG (WS-BILLING-INDX) AND               
                   WS-BILL-NO-BC (SUB1) =                               
                   WS-BILL-NO-BG (WS-BILLING-INDX) AND                  
                   WS-CODE-UTIL-TYPE-BC (SUB1) =                        
                   WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) AND           
                   WS-IC-NO-BC (SUB1) =                                 
                   WS-IC-NO-BG (WS-BILLING-INDX) AND                    
                   WS-BILL-ITEM-TIMESTMP-BC (SUB1) =                    
                   WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX))          
                      MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX) TO      
                           WS-MATCH-RATE-PLAN                           
             WHEN  WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = ZEROES          
                       MOVE SPACES TO WS-MATCH-RATE-PLAN.               
      *                                                                 09280000
       1105-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09310000
      ************************************************************      09320000
      *  CHECK VALUES AGAINST THE RATE STEP TABLE.  IF THE LINE  *      09330000
      *  MATCHING THIS ACCOUNT'S RATE AND STEP DATA HAS NOT BEEN *      09340000
      *  SELECTED, FLAG THIS ACCOUNT FOR AUDIT AND EXIT.         *      09350000
      ************************************************************      09360000
       1110-ENERGY-COMPONENT.                                           
      *                                                                 09390000
           IF WS-RATE-STEP-UTIL-TYPE (WS-RATE-SUB) =                    
              WS-CODE-UTIL-TYPE-BC (SUB1) AND                           
              WS-RATE-STEP-PLAN-NO (WS-RATE-SUB) =                      
              WS-MATCH-RATE-PLAN AND                                    
              WS-RATE-STEP-ENERGY-BLOCKS (WS-RATE-SUB) =                
              WS-BLOCKS-USED-BC (SUB1) AND                              
              WS-RATE-STEP-SELECTED (WS-RATE-SUB) = 'N'                 
                  MOVE 'Y' TO WS-RATE-STEP-SELECTED (WS-RATE-SUB)       
T35152            MOVE 'RATE' TO                     WS-AUD-COND-CODE   
T35152            MOVE WS-RATE-STEP-PLAN-NO (WS-RATE-SUB) TO            
T35152                                               WS-AUD-COND-RATE   
                  PERFORM 0200-SELECT-AND-GO THRU 0200-EXIT             
A02003     END-IF.                                                      
           ADD 1 TO WS-RATE-SUB.                                        
           IF WS-RATE-SUB > 1500 OR                                     
              WS-RATE-STEP-UTIL-TYPE (WS-RATE-SUB) <= SPACES            
                  GO TO 1110-EXIT
           END-IF.                                      
           GO TO 1110-ENERGY-COMPONENT.                                 
      *                                                                 09610000
       1110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09640000
      ************************************************************      09650000
      *  CHECK VALUES AGAINST THE RATE STEP TABLE.  IF THE LINE  *      09660000
      *  MATCHING THIS ACCOUNT'S RATE AND STEP DATA HAS NOT BEEN *      09670000
      *  SELECTED, FLAG THIS ACCOUNT FOR AUDIT AND EXIT.         *      09680000
      ************************************************************      09690000
       1120-DEMAND-COMPONENT.                                           
      *                                                                 09720000
           IF WS-RATE-STEP-UTIL-TYPE (WS-RATE-SUB) =                    
              WS-CODE-UTIL-TYPE-BC (SUB1) AND                           
              WS-RATE-STEP-PLAN-NO (WS-RATE-SUB) =                      
              WS-MATCH-RATE-PLAN AND                                    
              WS-RATE-STEP-DEMAND-BLOCKS (WS-RATE-SUB) =                
              WS-BLOCKS-USED-BC (SUB1) AND                              
              WS-RATE-STEP-SELECTED (WS-RATE-SUB) = 'N'                 
                  MOVE 'Y' TO WS-RATE-STEP-SELECTED (WS-RATE-SUB)       
T35152            MOVE 'DMND' TO                     WS-AUD-COND-CODE   
T35152            MOVE WS-RATE-STEP-PLAN-NO (WS-RATE-SUB) TO            
T35152                                               WS-AUD-COND-RATE   
                  PERFORM 0200-SELECT-AND-GO THRU 0200-EXIT             
A02003     END-IF.                                                      
           ADD 1 TO WS-RATE-SUB.                                        
           IF WS-RATE-SUB > 1500 OR                                     
              WS-RATE-STEP-UTIL-TYPE (WS-RATE-SUB) <= SPACES            
                  GO TO 1120-EXIT
           END-IF.                                      
           GO TO 1120-DEMAND-COMPONENT.                                 
      *                                                                 09940000
       1120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09970000
A04429************************************************************      09650000
A04429*  CHECK VALUES AGAINST THE RATE STEP TABLE.  IF THE LINE  *      09660000
A04429*  MATCHING THIS ACCOUNT'S UNMETERED RATE HAS NOT BEEN     *      09670000
A04429*  SELECTED, FLAG THIS ACCOUNT FOR AUDIT AND EXIT.         *      09680000
A04429************************************************************      09690000
A04429 1125-UNMETERED-PLAN.                                             
A04429*                                                                 09720000
A04429     IF WS-RATE-STEP-UTIL-TYPE (WS-RATE-SUB) =                    
A04429        WS-CODE-UTIL-TYPE-BC(SUB1) AND                            
A04429        WS-RATE-STEP-PLAN-NO(WS-RATE-SUB) = WS-MATCH-RATE-PLAN AND
A04429        WS-RATE-STEP-DEMAND-BLOCKS (WS-RATE-SUB) = 0 AND          
A04429        WS-RATE-STEP-ENERGY-BLOCKS (WS-RATE-SUB) = 0 AND          
A04429        WS-RATE-STEP-SELECTED (WS-RATE-SUB) = 'N'                 
A04429            MOVE 'Y' TO WS-RATE-STEP-SELECTED (WS-RATE-SUB)       
A04429            MOVE 'UMTR' TO                     WS-AUD-COND-CODE   
A04429            MOVE WS-RATE-STEP-PLAN-NO (WS-RATE-SUB) TO            
A04429                                               WS-AUD-COND-RATE   
A04429            PERFORM 0200-SELECT-AND-GO THRU 0200-EXIT             
A04429     END-IF.                                                      
A04429     ADD 1 TO WS-RATE-SUB.                                        
A04429     IF WS-RATE-SUB > 1500 OR                                     
A04429        WS-RATE-STEP-UTIL-TYPE (WS-RATE-SUB) <= SPACES            
A04429            GO TO 1125-EXIT
           END-IF.                                      
A04429     GO TO 1125-UNMETERED-PLAN.                                   
A04429*                                                                 09940000
A04429 1125-EXIT.                                                       
A04429     EXIT.                                                        
A04429*                                                                 09970000
      ************************************************************      09980000
      *  CHECK UNIT SELECTION REASONS AGAINST THE HARDCODED      *      09990000
      *  CONDITIONS TABLE FROM CWS00091.                         *      10000000
      *  0012 = RATCHET APPLIED                                  *      10010000
      *  0013 = POWER FACTOR APPLIED                             *      10020000
      *  0014 = CONTRACT DEMAND IS BILLING DEMAND                *      10030000
      *  0015 = RATE MINIMUM IS BILLING DEMAND                   *      10040000
      *  0028 = REAL TIME PRICING OVER MARGIN                    *      10050000
      *  0029 = REAL TIME PRICING UNDER MARGIN                   *      10060000
      ************************************************************      10070000
       1130-SELECTION-REASONS.                                          
      *                                                                 10100000
A02003     EVALUATE WS-NET-UNIT-SEL-RSN-BC (SUB1)                       
A02003        WHEN 'D'                                                  
A02003             MOVE 12             TO WS-AUD-SUB                    
A02003        WHEN 'E'                                                  
A02003             MOVE 13             TO WS-AUD-SUB                    
A02003        WHEN 'C'                                                  
A02003             MOVE 14             TO WS-AUD-SUB                    
A02003        WHEN 'B'                                                  
A02003             MOVE 15             TO WS-AUD-SUB                    
A02003     END-EVALUATE.                                                
A02003     PERFORM 1065-CHECK-AUDIT-COND    THRU 1065-EXIT.             
                                                                        
A02003     EVALUATE WS-COMPONENT-ID-BC (SUB1)                           
A02003        WHEN '80'                                                 
A02003             MOVE 28             TO WS-AUD-SUB                    
A02003        WHEN '81'                                                 
A02003             MOVE 29             TO WS-AUD-SUB                    
A02003     END-EVALUATE.                                                
A02003     PERFORM 1065-CHECK-AUDIT-COND    THRU 1065-EXIT.             
                                                                        
      *                                                                 10590000
       1130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10620000
      ************************************************************      10630000
      *  THE 1200 SERIES OF PARAGRAPHS PROCESS ALL BG RECORDS    *      10640000
      *  FOR THE ACCOUNT.                                        *      10650000
      ************************************************************      10660000
      ************************************************************      10680000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      10690000
      *  0002 = GAS WITH LOCAL OFFICE SALES TAX                  *      10710000
      ************************************************************      10720000
       1200-SELECT-LOST-ACCOUNTS.                                       
      *                                                                 10750000
           IF WS-CODE-UTIL-TYPE-BG (SUB1) = 'G' AND                     
A02003        WS-AMT-BILL-ITEM-BG (SUB1) > 0.00                         
                 COMPUTE WS-TAX-PERCENT =                               
                         WS-AMT-STATE-TAX-BG (SUB1) /                   
                         WS-AMT-BILL-ITEM-BG (SUB1)                     
                 IF WS-TAX-PERCENT > .05                                
A02003               MOVE 2 TO WS-AUD-SUB                               
A02003               PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT       
A02003           END-IF                                                 
A02003     END-IF.                                                      
      *                                                                 11030000
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11060000
      ************************************************************      11070000
      *  BUILD A BILL TYPE TABLE IN CWS00090.  NOTE THAT ONLY    *      11080000
      *  ONE ACCOUNT FOR EACH BILL TYPE IS SELECTED.  TO CHANGE  *      11090000
      *  THIS, INCREASE THE MAX VALUE.  BILL TYPE HERE IS        *      11100000
      *  CONSIDERED TO BE THE BILL FORMAT CODE.  VALUES ARE:     *      11110000
      *  1 = ELECTRIC NON-DEMAND                                 *      11120000
      *  2 = GAS                                                 *      11130000
      *  3 = ELECTRIC DEMAND                                     *      11140000
      *  4 = MUNICIPAL LIGHTS                                    *      11150000
      *  5 = NON-MUNICIPAL LIGHTS                                *      11160000
      *  6 = WHOLESALE                                           *      11170000
      *  7 = TOU NON-DEMAND                                      *      11180000
      *  8 = TOU DEMAND                                          *      11190000
      ************************************************************      11200000
       1210-SELECT-BILL-TYPES.                                          
      *                                                                 11230000
           IF WS-BILL-FORMAT-CODE-RT (SUB1) <= SPACES                   
               GO TO 1210-EXIT
           END-IF.                                         
           IF WS-BILL-TYPE (SUB2) = SPACES                              
               MOVE WS-BILL-FORMAT-CODE-RT (SUB1) TO                    
                    WS-BILL-TYPE (SUB2)                                 
               MOVE 1 TO WS-BILL-TYPE-COUNTER (SUB2)                    
                         WS-BILL-TYPE-MAX (SUB2)                        
T35152         STRING 'BF'                                              
T35152                 WS-BILL-TYPE (SUB2)                              
T35152                 DELIMITED BY SIZE                                
T35152                 INTO WS-AUD-COND-CODE                            
T35152         END-STRING                                               
               PERFORM 0200-SELECT-AND-GO THRU 0200-EXIT
           END-IF.               
           IF WS-BILL-FORMAT-CODE-RT (SUB1) = WS-BILL-TYPE (SUB2)       
               IF WS-BILL-TYPE-COUNTER (SUB2) < WS-BILL-TYPE-MAX (SUB2) 
T35152             STRING 'BF'                                          
T35152                     WS-BILL-TYPE (SUB2)                          
T35152                     DELIMITED BY SIZE                            
T35152                     INTO WS-AUD-COND-CODE                        
T35152             END-STRING                                           
                   ADD 1 TO WS-BILL-TYPE-COUNTER (SUB2)                 
                   PERFORM 0200-SELECT-AND-GO THRU 0200-EXIT            
               ELSE                                                     
                   GO TO 1210-EXIT
               END-IF
           END-IF.                                     
           ADD 1 TO SUB2.                                               
           IF SUB2 > 50                                                 
               MOVE 'BILL TYPE TABLE SUBSCRIPT EXCEEDED' TO             
                    WS-MISC-MSG-TEXT                                    
               MOVE +34 TO WS-MISC-MSG-LEN                              
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
               PERFORM 9999-BAIL-OUT THRU 9999-EXIT
           END-IF.                    
           GO TO 1210-SELECT-BILL-TYPES.                                
      *                                                                 11560000
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11590000
A05290************************************************************      11860000
A05290* CHECK DOUBLE AGL PASS THRU CHARGES FOR FINAL BILL ACCOUNT*      11890000
A05290************************************************************      11900000
A05290 1220-DOUBLE-AGL-PASS-CHARGES.                                    
A05290*                                                                 11930000
A05290     PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL            
A05290             WS-BILLING-INDX > WS-BG-MAX-ENTRY OR                 
A05290             WS-ACCOUNT-NO-BG(WS-BILLING-INDX) = ZERO             
A05290             IF (WS-CODE-ACCT-STAT-AT = 'B' AND                   
A05290                   WS-REV-RPT-CD-BG (WS-BILLING-INDX) = 'P')      
A05290                 MOVE 21 TO WS-AUD-SUB                            
A05290                 PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT     
A05290              END-IF                                              
A05290     END-PERFORM.                                                 
A05290*                                                                 12260000
A05290 1220-EXIT.                                                       
A05290     EXIT.                                                        
      *                                                                 12290000
ACT055************************************************************      11860000
ACT055* REG SEB INITIAL BILL AUDIT CONDITIONS.                   *      11890000
ACT055************************************************************      11900000
ACT055 1225-REG-INITIAL-BILL-AUDIT.                                     
ACT055*                                                                 11930000
ACT055     MOVE 1 TO SUB3.                                              
ACT055     PERFORM VARYING SUB3 FROM 1 BY 1 UNTIL SUB3 > 30 OR          
ACT055                                 WS-ACCOUNT-NO-BG (SUB3) = ZEROES 
ACT055        IF (WS-PRORATE-CD-BG(SUB3)  = 'I' AND                     
ACT055            WS-NO-OF-CONS-DAYS-BG (SUB3)  < 25)                   
ACT055            MOVE 1 TO SUB4                                        
ACT055            PERFORM VARYING SUB4 FROM 1 BY 1 UNTIL SUB4 > 400 OR  
ACT055                    WS-ACCOUNT-NO-FH (SUB4) = ZEROES              
ACT055* CHECK CSC CHARGE                                                        
ACT055               IF WS-FACTOR-ID-FH (SUB4) = 'BFACCHRG'             
ACT055                  MOVE 1 TO SUB5                                  
ACT055                  PERFORM VARYING SUB5 FROM 1 BY 1 UNTIL          
ACT055                          SUB5 > 1 OR WS-ACCOUNT-NO-DD(SUB5) = 0  
ACT055* CHECK GROUP 1 & 2 REGULATED ACCOUNT                                     
ACT055                     IF WS-TIER-ACCT-TYPE-CD-DD (SUB5) = '1' OR   
ACT055                        WS-TIER-ACCT-TYPE-CD-DD (SUB5) = '2'      
ACT055                        MOVE 92 TO WS-AUD-SUB                     
ACT055                        PERFORM 1065-CHECK-AUDIT-COND THRU        
ACT055                                                         1065-EXIT
ACT055                     END-IF                                       
ACT055                  END-PERFORM                                     
ACT055               END-IF                                             
ACT055            END-PERFORM                                           
ACT055        END-IF                                                    
ACT055     END-PERFORM.                                                 
ACT055*                                                                 12260000
ACT055 1225-EXIT.                                                       
ACT055     EXIT.                                                        
ACT055*                                                                 12290000
ACT055************************************************************      11860000
ACT055* DEREG SEB INITIAL BILL AUDIT CONDITIONS.                 *      11890000
ACT055************************************************************      11900000
ACT055 1226-DEREG-INITIAL-BILL-AUDIT.                                   
ACT055*                                                                 11930000
ACT055     MOVE 1 TO SUB3.                                              
ACT055     PERFORM VARYING SUB3 FROM 1 BY 1 UNTIL SUB3 > 30 OR          
ACT055                                 WS-ACCOUNT-NO-BG (SUB3) = ZEROES 
ACT055        IF (WS-PRORATE-CD-BG(SUB3)  = 'I' AND                     
ACT055            WS-NO-OF-CONS-DAYS-BG (SUB3)  < 25)                   
ACT055            MOVE 1 TO SUB4                                        
ACT055            PERFORM VARYING SUB4 FROM 1 BY 1 UNTIL SUB4 > 400 OR  
ACT055                    WS-ACCOUNT-NO-FH (SUB4) = ZEROES              
ACT055* CHECK CSC CHARGE                                                        
ACT055               IF WS-FACTOR-ID-FH (SUB4) = 'BFACCHRG'             
ACT055                  MOVE 1 TO SUB5                                  
ACT055                  PERFORM VARYING SUB5 FROM 1 BY 1 UNTIL          
ACT055                          SUB5 > 1 OR WS-ACCOUNT-NO-DD(SUB5) = 0  
ACT055* CHECK COMMERCIAL CONTRACT ACCOUNT - L                                   
ACT055                     IF WS-TIER-ACCT-TYPE-CD-DD (SUB5) = 'L'      
ACT055                         MOVE 1 TO SUB6                           
ACT055                         PERFORM VARYING SUB6 FROM 1 BY 1         
ACT055                                 UNTIL SUB6 > 400 OR              
ACT055                                 WS-ACCOUNT-NO-FH (SUB6) = ZEROES 
ACT055* CHECK AGL CHARGE                                                        
ACT055                            IF WS-FACTOR-ID-FH (SUB6) (1:3) ='AGL'
ACT055                               MOVE 93 TO WS-AUD-SUB              
ACT055                               PERFORM 1065-CHECK-AUDIT-COND      
ACT055                                                THRU 1065-EXIT    
ACT055                            END-IF                                
ACT055                         END-PERFORM                              
ACT055                     ELSE                                         
ACT055                         MOVE 92 TO WS-AUD-SUB                    
ACT055                         PERFORM 1065-CHECK-AUDIT-COND THRU       
ACT055                                                      1065-EXIT   
ACT055                     END-IF                                       
ACT055                  END-PERFORM                                     
ACT055               END-IF                                             
ACT055            END-PERFORM                                           
ACT055        END-IF                                                    
ACT055     END-PERFORM.                                                 
ACT055*                                                                 12260000
ACT055 1226-EXIT.                                                       
ACT055     EXIT.                                                        
ACT055*                                                                 12290000
ACT055************************************************************      11860000
ACT055* DEREG SEB INITIAL BILL WITH OUT AGL AND CSC CHARGES      *      11890000
ACT055************************************************************      11900000
ACT055 1227-DEREG-INIT-BILL-WTOUT-CSC.                                  
ACT055*                                                                 11930000
ACT055     MOVE 1 TO SUB3.                                              
ACT055     PERFORM VARYING SUB3 FROM 1 BY 1 UNTIL SUB3 > 30 OR          
ACT055                                 WS-ACCOUNT-NO-BG (SUB3) = ZEROES 
ACT055        MOVE 'Y'        TO WS-CSC-FLAG                            
ACT055                           WS-AGL-FLAG                            
ACT055        IF (WS-PRORATE-CD-BG(SUB3)  = 'I' AND                     
ACT055            WS-NO-OF-CONS-DAYS-BG (SUB3)  < 25)                   
ACT055            MOVE 1 TO SUB4                                        
ACT055            PERFORM VARYING SUB4 FROM 1 BY 1 UNTIL SUB4 > 400 OR  
ACT055                    WS-ACCOUNT-NO-FH (SUB4) = ZEROES              
ACT055* CHECK CSC CHARGE                                                        
ACT055               IF WS-FACTOR-ID-FH (SUB4) = 'BFACCHRG'             
ACT055                  MOVE 'Y'        TO WS-CSC-FLAG                  
ACT055                  GO TO 1227-EXIT                                 
ACT055               ELSE                                               
ACT055                  MOVE 'N'        TO WS-CSC-FLAG                  
ACT055               END-IF                                             
ACT055            END-PERFORM                                           
ACT055            IF WS-CSC-FLAG = 'N'                                  
ACT055                MOVE 1 TO SUB5                                    
ACT055                PERFORM VARYING SUB5 FROM 1 BY 1 UNTIL            
ACT055                          SUB5 > 1 OR WS-ACCOUNT-NO-DD(SUB5) = 0  
ACT055* CHECK COMMERCIAL CONTRACT ACCOUNT - L                                   
ACT055                   IF WS-TIER-ACCT-TYPE-CD-DD (SUB5) = 'L'        
ACT055                       PERFORM VARYING SUB6 FROM 1 BY 1           
ACT055                                  UNTIL SUB6 > 400 OR             
ACT055                                  WS-ACCOUNT-NO-FH (SUB6) = ZEROES
ACT055* CHECK AGL CHARGE                                                        
ACT055                          IF WS-FACTOR-ID-FH (SUB6) (1:3) = 'AGL' 
ACT055                            MOVE 'Y'      TO WS-AGL-FLAG          
ACT055                            GO TO 1227-EXIT                       
ACT055                          ELSE                                    
ACT055                            MOVE 'N'      TO WS-AGL-FLAG          
ACT055                          END-IF                                  
ACT055                       END-PERFORM                                
ACT055                   END-IF                                         
ACT055                END-PERFORM                                       
ACT055            END-IF                                                
ACT055            IF WS-AGL-FLAG = 'N' AND  WS-CSC-FLAG = 'N'           
ACT055                MOVE 96 TO WS-AUD-SUB                             
ACT055                PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT      
ACT055            END-IF                                                
ACT055        END-IF                                                    
ACT055     END-PERFORM.                                                 
ACT055*                                                                 12260000
ACT055 1227-EXIT.                                                       
ACT055     EXIT.                                                        
ACT055*                                                                 12290000
      ************************************************************      11860000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      11870000
      *  0010 = RATE 009 ON PEAK DEMAND > 250 KVA                *      11880000
      *  0011 = RATE 009 ON PEAK DEMAND < 250 KVA                *      11890000
      ************************************************************      11900000
       1230-RATE-009-ONPEAK-KVA.                                        
      *                                                                 11930000
           IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BC (SUB2) AND     
              WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BC (SUB2) AND           
              WS-CODE-UTIL-TYPE-BG (SUB1) =                             
                  WS-CODE-UTIL-TYPE-BC (SUB2) AND                       
              WS-IC-NO-BG (SUB1) = WS-IC-NO-BC (SUB2) AND               
              WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                         
                  WS-BILL-ITEM-TIMESTMP-BC (SUB2) AND                   
              WS-CONSUMPTION-TYPE-BC (SUB2) = 'E' AND                   
              WS-CODE-TOU-BC (SUB2) = '1'                               
A02003            IF WS-NET-UNITS-BC (SUB2) > 250                       
A02003               MOVE 10 TO WS-AUD-SUB                              
A02003               PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT       
A02003            END-IF                                                
A02003            IF WS-NET-UNITS-BC (SUB2) < 250 AND                   
                     WS-NET-UNITS-BC (SUB2) > 0                         
A02003               MOVE 11 TO WS-AUD-SUB                              
A02003               PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT       
A02003            END-IF                                                
A02003     END-IF.                                                      
           ADD 1 TO SUB2.                                               
I00177     IF SUB2 > WS-BZ-MAX-ENTRY  OR                                
I00177               WS-ACCOUNT-NO-BC (SUB2) = ZEROES                   
               GO TO 1230-EXIT                                          
           ELSE                                                         
               GO TO 1230-RATE-009-ONPEAK-KVA                           
A02003     END-IF.                                                      
      *                                                                 12260000
       1230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12290000
      ************************************************************      12480000
      *  SET SWITCHES FOR PRORATE ACCOUNTS                       *      12490000
      ************************************************************      12500000
       1250-PRORATE-SETUP.                                              
      *                                                                 12530000
           MOVE WS-PRORATE-CD-BG (SUB1) TO WS-HOLD-PRORATE-CD.          
      *                                                                 12550000
           IF WS-CODE-UTIL-TYPE-BG (SUB1) = 'E'                         
              MOVE 'Y' TO WS-ELECTRIC-SERVICE                           
           END-IF.                                                      
           IF WS-CODE-UTIL-TYPE-BG (SUB1) = 'G'                         
              MOVE 'Y' TO WS-GAS-SERVICE                                
           END-IF.                                                      
      *                                                                 12620000
           IF WS-PRORATE-CD-BG (SUB1) > ' '                             
           AND (WS-NO-OF-CONS-DAYS-BG (SUB1) >                          
                     WS-DAYS-HI OR < WS-DAYS-LO)                        
              MOVE 'Y' TO WS-PRORATED-SW                                
           END-IF.                                                      
      *                                                                 12680000
       1250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12710000
      ************************************************************      12720000
      *  PULL ACCOUNTS FOR PRORATED AUDIT                        *      12730000
      ************************************************************      12740000
       1260-PRORATE-ACCOUNTS.                                           
      *                                                                 12770000
A02003     IF (ELECTRIC                                                 
P00565     AND GAS                                                      
A02003     AND PRORATED                                                 
A02003     AND PRORATE-INIT)                                            
P00565       MOVE 88 TO WS-AUD-SUB                                      
A02003       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
           END-IF.                                                      
                                                                        
P00565     IF (WS-COMPANY-NO-AT = '26'                                  
P00565     AND PRORATED                                                 
P00565     AND PRORATE-INIT)                                            
P00565       MOVE 89 TO WS-AUD-SUB                                      
P00565       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
           END-IF.                                                      
                                                                        
A02003     IF (ELECTRIC                                                 
A02003     AND GAS                                                      
A02003     AND PRORATED                                                 
A02003     AND PRORATE-FINAL)                                           
P00565       MOVE 90 TO WS-AUD-SUB                                      
A02003       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
           END-IF.                                                      
                                                                        
P00565     IF (WS-COMPANY-NO-AT = '26'                                  
P00565     AND PRORATED                                                 
P00565     AND PRORATE-FINAL)                                           
P00565       MOVE 91 TO WS-AUD-SUB                                      
P00565       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
           END-IF.                                                      
      *                                                                 14010000
       1260-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14040000
      ************************************************************      14050000
      *  PULL ACCOUNTS FOR E-BILL AUDIT                          *      14060000
      ************************************************************      14070000
       1270-EBILL-ACCOUNTS.                                             
      *                                                                 14100000
           IF (CSR-DATABASE AND WS-COMPANY-NO-AT = '01')                
               PERFORM 1271-SCEG-EBILL-ACCTS THRU 1271-EXIT             
           ELSE                                                         
               PERFORM 1272-OTHER-EBILL-ACCTS THRU 1272-EXIT            
           END-IF.                                                      
      *                                                                 14160000
       1270-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14190000
       1271-SCEG-EBILL-ACCTS.                                           
      *                                                                 14210000
A02003     IF (ELECTRIC                                                 
A02003     AND GAS                                                      
A02003     AND RESIDENTIAL)                                             
A02003       MOVE 98 TO WS-AUD-SUB                                      
A02003       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
           END-IF.                                                      
                                                                        
A02003     IF (ELECTRIC                                                 
A02003     AND GAS                                                      
A02003     AND COMMERCIAL)                                              
A02003       MOVE 99 TO WS-AUD-SUB                                      
A02003       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
           END-IF.                                                      
      *                                                                 14750000
       1271-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14780000
       1272-OTHER-EBILL-ACCTS.                                          
      *                                                                 14800000
A02003     IF RESIDENTIAL                                               
A02003       MOVE 106 TO WS-AUD-SUB                                     
A02003       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
           END-IF.                                                      
                                                                        
A02003     IF COMMERCIAL                                                
A02003       MOVE 107 TO WS-AUD-SUB                                     
A02003       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
           END-IF.                                                      
      *                                                                 15040000
       1272-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15070000
      ************************************************************      15080000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      15090000
      *  0004 = FIXED INCOME ASSISTANCE                          *      15100000
      ************************************************************      15110000
       1300-SELECT-FIXED-INCOME.                                        
      *                                                                 15120000
A02003     IF WS-CODES-DATA-PRESENT-AT (16:1) > ' '                     
A02003       MOVE 4 TO WS-AUD-SUB                                       
A02003       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
A02003     END-IF.                                                      
      *                                                                 15230000
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15260000
      ************************************************************      15270000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      15280000
      *  0005 = EPP ACCOUNT WITH 1ST MONTH ADJUSTMENT            *      15290000
      *  0008 = EPP ACCOUNT WITH ANNUAL ADJUSTMENT NOTICE        *      15300000
      ************************************************************      15310000
       1400-EPP-FIRST-MONTH.                                            
      *                                                                 15340000
           IF WS-ACCOUNT-NO-BU > ZEROES                                 
               INITIALIZE WS-START-DATE-CCYYMM                          
               MOVE WS-REV-MTH-LST-NRML-AT    TO WS-BILLING-CCYYMM      
               MOVE WS-ACCOUNT-NO-AT          TO WS-BUDG-ACCT-NO        
               MOVE 'A'                       TO WS-HOLD-CHG-REASON     
               PERFORM 1410-GET-BUDGET-DATA THRU 1410-EXIT              
               IF WS-BUDGET-RETURN-CODE = SUCCESSFUL-CALL               
                  MOVE BH-DATE-PYMT-STRT      TO WS-UNFORMAT-DATE       
                  MOVE WS-UNFMT-CCYY          TO WS-START-DT-CCYY       
                  MOVE WS-UNFMT-MM            TO WS-START-DT-MM         
                  IF WS-START-DATE-CCYYMM NOT NUMERIC                   
                     MOVE 'SCSCA187:1400 NON-NUMERIC START DATE ' TO    
                           WS-MISC-MSG-TEXT                             
                     MOVE +37                 TO WS-MISC-MSG-LEN        
                     PERFORM 9910-MISC-ERROR THRU 9910-EXIT             
                     GO TO 1400-EXIT                                    
                  END-IF                                                
               END-IF                                                   
                                                                        
A02003         IF WS-START-DATE-CCYYMM = WS-BILLING-CCYYMM              
A02003            MOVE 5 TO WS-AUD-SUB                                  
A02003            PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT          
               END-IF                                                   
           END-IF.                                                      
      *                                                                 15780000
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15811000
       1410-GET-BUDGET-DATA.                                            
      *                                                                 15811000
           EXEC SQL                                                     
                OPEN EPP_ANNIV_DET_CR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY ' 1410-GET-BUDGET-DATA      '                     
              DISPLAY ' ** SCSCA187 PROCESSING ERROR'                   
              DISPLAY ' ** ERROR ON OPEN   '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE CSS_BUDGET_HIST '                      
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** ACCOUNT_NO     '  WS-BUDG-ACCT-NO            
              DISPLAY ' ** CHANGE_REASON  '  WS-HOLD-CHG-REASON         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
           EXEC SQL                                                     
                FETCH EPP_ANNIV_DET_CR                                  
                 INTO :BH-DATE-PYMT-STRT                                
                     ,:BH-BUD-HIST-SEQ-NO                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-BUDGET-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
              WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO WS-DB2-RETURN-CODE                        
                              WS-DISPLAY-SQLCODE                        
              DISPLAY 'SCSCA187:3010 '                                  
              DISPLAY ' 1410-GET-BUDGET-DATA      '                     
              DISPLAY ' ** SCSCA187 PROCESSING ERROR'                   
              DISPLAY ' ** ERROR ON FETCH   '                           
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE CSS_BUDGET_HIST  '                     
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** ACCOUNT_NO     '  WS-BUDG-ACCT-NO            
              DISPLAY ' ** CHANGE_REASON  '  WS-HOLD-CHG-REASON         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
           EXEC SQL                                                     
               CLOSE EPP_ANNIV_DET_CR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-DISPLAY-SQLCODE                           
                           WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY ' 1410-GET-BUDGET-DATA      '                     
              DISPLAY ' ** SCSCA187 PROCESSING ERROR'                   
              DISPLAY ' ** ERROR ON CLOSE  '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE CSS_BUDGET_HIST '                      
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** ACCOUNT_NO     '  WS-BUDG-ACCT-NO            
              DISPLAY ' ** CHANGE_REASON  '  WS-HOLD-CHG-REASON         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 15824000
       1410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15824300
      ************************************************************      15825000
      *  THE 1500 SERIES OF PARAGRAPHS PROCESS ALL AC RECORDS    *      15830000
      *  FOR THE ACCOUNT.                                        *      15840000
      ************************************************************      15850000
      ************************************************************      15870000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      15880000
      *  0006 = EPP ACCOUNT WITH CREDIT ARREARS                  *      15890000
      *  0007 = EPP ACCOUNT WITH DEBIT ARREARS                   *      15900000
      *  0033 = EPP ACCOUNT WITH $0 ARREARS                      *      15910000
      ************************************************************      15920000
       1500-EPP-CREDIT-DEBIT-ARREARS.                                   
      *                                                                 15930000
A02003     IF WS-AMT-UNUSED-CR-AC (SUB1) > 0.00                         
A02003       MOVE 6 TO WS-AUD-SUB                                       
A02003       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
A02003     END-IF.                                                      
                                                                        
A02879     IF WS-TOTAL-ARREARS-BI > 0.00                                
A02003       MOVE 7 TO WS-AUD-SUB                                       
A02003       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
A02003     END-IF.                                                      
                                                                        
A00811     MOVE  1                       TO WS-AC-SUB.                  
A00811     MOVE 'N'                      TO WS-OTHER-ARREARS-SW.        
A00811     PERFORM 1505-CHECK-OTHER-ARREARS   THRU 1505-EXIT.           
A02003     IF  WS-AMT-AR-DAY-30-AC (SUB1) = 0.00 AND                    
               WS-AMT-AR-DAY-60-AC (SUB1) = 0.00 AND                    
A00811         WS-AMT-AR-DAY-90-AC (SUB1) = 0.00 AND                    
A00811         WS-OTHER-ARREARS-SW = 'N'                                
A02003       MOVE 33 TO WS-AUD-SUB                                      
A02003       PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT               
A02003     END-IF.                                                      
      *                                                                 16240000
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16270000
      ************************************************************      16280000
      *  SEARCH ALL AC RECORDS TO DETERMINE IF THE ACCOUNT HAVE  *      16290000
      *  ANY ARREARS IN 30, 60 & 90 DAY BUCKETS IF SO PLEASE DO  *      16300000
      *  NOT PROCESS THIS AS $0 ARREARS FOR BPP.                 *              
      ************************************************************      16310000
A00811*                                                                         
A00811 1505-CHECK-OTHER-ARREARS.                                        
A00811*                                                                         
A00811     PERFORM VARYING WS-AC-SUB FROM 1 BY 1                        
SCA006             UNTIL WS-OTHER-ARREARS-SW = 'Y' OR 
                         WS-AC-SUB > WS-AC-MAX-ENTRY OR 
                         WS-ACCOUNT-NO-AC (WS-AC-SUB) = ZEROES                  
A00811         MOVE WS-PYMT-PRIORITY-LVL-AC (WS-AC-SUB) TO              
A00811         WS-PYMT-PRTY-LVL                                         
A00811         IF WS-BUD-PYMT-PRTY AND                                  
A00811            WS-ITEM-ID-AC (WS-AC-SUB) = 1                         
A00811               CONTINUE                                           
A00811         ELSE                                                     
A00811            IF WS-AMT-AR-DAY-30-AC (WS-AC-SUB) NOT = 0.00 OR      
A00811               WS-AMT-AR-DAY-60-AC (WS-AC-SUB) NOT = 0.00 OR      
A00811               WS-AMT-AR-DAY-90-AC (WS-AC-SUB) NOT = 0.00         
A00811               MOVE 'Y'               TO WS-OTHER-ARREARS-SW      
A00811            END-IF                                                
A00811         END-IF                                                   
A00811     END-PERFORM.                                                 
A00811*                                                                         
A00811 1505-EXIT.                                                       
A00811     EXIT.                                                        
      ************************************************************      16280000
      *  SEARCH ALL DFAS FOR THE ACCOUNT.  IF A CODE-DFA-TYPE    *      16290000
      *  IS B, THE DFA IS A DPP.                                 *      16300000
      ************************************************************      16310000
       1510-DPP-DEBIT-AND-NO-ARREARS.                                   
      *                                                                 16270000
           MOVE SPACES TO WS-HOLD-DFA-TYPE.                             
           SET WS-DFA-INDX TO 1.                                        
           SEARCH WS-DFA-ACCT-DATA                                      
             AT END                                                     
                 MOVE SPACES TO WS-HOLD-DFA-TYPE                        
             WHEN (WS-ACCOUNT-NO-AC (SUB1) =                            
                   WS-ACCOUNT-NO-DA (WS-DFA-INDX) AND                   
                   WS-PYMT-PRIORITY-LVL-DA (WS-DFA-INDX) = 090 AND      
                   WS-CODE-DFA-TYPE-DA (WS-DFA-INDX) = 'B')             
                      MOVE 'B' TO WS-HOLD-DFA-TYPE                      
             WHEN  WS-ACCOUNT-NO-DA (WS-DFA-INDX) = ZEROES              
                       MOVE SPACES TO WS-HOLD-DFA-TYPE.                 
      *                                                                 16510000
A04494     IF WS-HOLD-DFA-TYPE = 'B'                                    
ACT230        IF ((SEB-DATABASE AND WS-REGULATED-CD-AT = '02') OR       
ACT230            (CSR-DATABASE AND WS-COMPANY-NO-AT   = '26'))         
ACT230           CONTINUE                                               
ACT230        ELSE                                                      
A04494           PERFORM 1520-CHECK-AGING-BUCKETS THRU 1520-EXIT        
ACT230        END-IF                                                    
A04494        PERFORM 1550-FIRST-TIME-DPP      THRU 1550-EXIT           
A04494     END-IF.                                                      
      *                                                                 16510000
       1510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16540000
A04494************************************************************      16550000
A04494*  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      16560000
A04494*  0018 = DPP ACCOUNT WITH DEBIT ARREARS                   *      16570000
A04494*  0019 = DPP ACCOUNT WITH $0 ARREARS                      *      16580000
A04494************************************************************      16590000
A04494 1520-CHECK-AGING-BUCKETS.                                        
      *                                                                 16620000
A04494     IF (WS-AMT-AR-DAY-30-AC (SUB1) = 0.00 AND                    
A04494         WS-AMT-AR-DAY-60-AC (SUB1) = 0.00 AND                    
A04494         WS-AMT-AR-DAY-90-AC (SUB1) = 0.00)                       
A04494         MOVE 19                       TO WS-AUD-SUB              
A04494         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
A04494     END-IF.                                                      
A04494                                                                  
A04494 1520-EXIT.                                                       
A04494     EXIT.                                                        
      *                                                                 16620000
      ************************************************************      17630000
      *  COMPUTE THE DAYS BETWEEN THE ARREARS DATE AND THE       *      17640000
      *  BILL DATE.                                              *      17650000
      ************************************************************      17660000
       1530-COMPUTE-DAYS.                                               
      *                                                                 17690000
           EXEC SQL                                                     
                SELECT
              CIS.DAYS( IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) ) - CIS.DAYS( 
              IIF(TRY_CONVERT(DATE, :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ) )
            INTO
              :WS-CALC-NO-DAYS          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     17700000
MFA-TR*         SET :WS-CALC-NO-DAYS =                                          
MFA-TR*              DAYS(:WS-END-DATE) - DAYS(:WS-START-DATE)                  
MFA-TR*    END-EXEC.                                                    17750000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
               MOVE ZEROES TO WS-CALC-NO-DAYS
           END-IF.                          
      *                                                                 17790000
       1530-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17820000
      ************************************************************      17830000
      *  FOR EACH CONTRACT AC RECORD, GET THE CONTRACT TYPE FROM *      17840000
      *  THE CONTRACT SEGMENT.  PROCESS THE CONTRACT TYPE        *      17850000
      *  SELECTION CRITERIA TABLE.  IF A CONTRACT OF THIS TYPE   *      17860000
      *  SHOULD BE SELECTED, SET THE AUDIT FLAG, PASS THE AUDIT  *      17870000
      *  REASON, AND EXIT.                                       *      17880000
      ************************************************************      17890000
       1540-PROCESS-CONTRACTS.                                          
      *                                                                 17920000
           MOVE ' ' TO WS-HOLD-CONTRACT-TYPE.                           
           SET WS-CNT-INDX TO 1.                                        
           SEARCH WS-CONTRACT-DATA                                      
             AT END                                                     
                 MOVE SPACES TO WS-HOLD-CONTRACT-TYPE                   
             WHEN (WS-ACCOUNT-NO-AC (SUB1) =                            
                   WS-ACCOUNT-NO-CT (WS-CNT-INDX) AND                   
                   WS-PYMT-PRIORITY-LVL-AC (SUB1) =                     
                   WS-PYMT-PRIORITY-LVL-CT (WS-CNT-INDX) AND            
                   WS-ITEM-ID-AC (SUB1) =                               
                   WS-CNT-ITEM-ID-CT (WS-CNT-INDX))                     
                       MOVE WS-CODE-CONTRACT-TYPE-CT (WS-CNT-INDX) TO   
                            WS-HOLD-CONTRACT-TYPE                       
             WHEN  WS-ACCOUNT-NO-CT (WS-CNT-INDX) = ZEROES              
                       MOVE SPACES TO WS-HOLD-CONTRACT-TYPE.            
           IF WS-HOLD-CONTRACT-TYPE > SPACES                            
               MOVE 1 TO SUB2                                           
               PERFORM UNTIL SUB2 > 50 OR                               
                             WS-CONTRACT-TYPE (SUB2) = ' '              
                   IF WS-HOLD-CONTRACT-TYPE =                           
                      WS-CONTRACT-TYPE (SUB2) AND                       
                     (WS-CONTRACT-SELECTED (SUB2) = 'N' OR              
                     (WS-CONTRACT-SELECTED (SUB2) = 'Y' AND             
                      WS-CONTRACT-COUNTER (SUB2) <                      
                      WS-CONTRACT-MAX (SUB2)))                          
                          MOVE 'Y' TO WS-CONTRACT-SELECTED (SUB2)       
                          ADD 1 TO WS-CONTRACT-COUNTER (SUB2)           
T35152                    STRING '000'                                  
T35152                           WS-CONTRACT-TYPE (SUB2)                
                                 DELIMITED BY SIZE                      
                                 INTO WS-AUD-COND-CODE                  
                          PERFORM 0200-SELECT-AND-GO THRU 0200-EXIT     
                   END-IF                                               
                   ADD 1 TO SUB2                                        
               END-PERFORM
           END-IF.                                             
      *                                                                 18280000
       1540-EXIT.                                                       
           EXIT.                                                        
A04494                                                                  
A04494************************************************************      18590000
A04494*  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      18600000
A04494*  0020 = FIRST TIME DPP                                   *      18340000
A04494************************************************************      18350000
A04494 1550-FIRST-TIME-DPP.                                             
A04494*                                                                 18380000
A04494     MOVE WS-DATE-BILLED-BI TO WS-UNFORMAT-DATE.                  
A04494     MOVE WS-UNFMT-CCYY TO WS-BILLING-CCYY.                       
A04494     MOVE WS-UNFMT-MM TO WS-BILLING-MM.                           
A04494     MOVE WS-DATE-PYMT-START-DA (WS-DFA-INDX) TO                  
A04494          WS-UNFORMAT-DATE.                                       
A04494     MOVE WS-UNFMT-CCYY TO WS-DFA-CCYY.                           
A04494     MOVE WS-UNFMT-MM TO WS-DFA-MM.                               
A04494     IF WS-BILLING-CCYYMM = WS-DFA-CCYYMM                         
A04494         MOVE 20                       TO WS-AUD-SUB              
A04494         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
A04494     END-IF.                                                      
A04494 1550-EXIT.                                                       
A04494     EXIT.                                                        
      ************************************************************      18590000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      18600000
      *  0036 = NON-UTILITY CHARGES                              *      18610000
      ************************************************************      18620000
       1560-NON-UTILITY-CHARGES.                                        
      *                                                                 18650000
           IF SUB1 > 50                                                 
               GO 1560-EXIT                                             
           END-IF.                                                      
      *                                                                 18810000
ACT230     IF (SEB-DATABASE AND WS-REGULATED-CD-AT = '02')              
ACT230        CONTINUE                                                  
ACT230     ELSE                                                         
P00565         IF SEB-DATABASE                                          
A02003         AND WS-PYMT-PRIORITY-LVL-AC (SUB1) = 19                  
A02003         AND WS-ITEM-ID-AC (SUB1) = ZERO                          
A02003         AND WS-AMT-AR-DAY-30-AC (SUB1) > ZERO                    
A02003             MOVE 50 TO WS-AUD-SUB                                
A02003             PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT         
ACT230         END-IF                                                   
ACT230     END-IF.                                                      
      *                                                                 18930000
ACT230     IF (CSR-DATABASE AND WS-COMPANY-NO-AT   = '26')              
ACT230        CONTINUE                                                  
ACT230     ELSE                                                         
               IF WS-PYMT-PRIORITY-LVL-AC (SUB1) = 20                   
A02003         AND WS-ITEM-ID-AC (SUB1) = ZERO                          
A02003         AND WS-AMT-AR-DAY-30-AC (SUB1) > ZERO                    
A02003             MOVE 51 TO WS-AUD-SUB                                
A02003             PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT         
ACT230         END-IF                                                   
ACT230     END-IF.                                                      
      *                                                                     1905
ACT230     IF (SEB-DATABASE AND WS-REGULATED-CD-AT = '02')              
ACT230        CONTINUE                                                  
ACT230     ELSE                                                         
P00565         IF SEB-DATABASE                                          
A02003         AND WS-PYMT-PRIORITY-LVL-AC (SUB1) = 29                  
A02003         AND WS-ITEM-ID-AC (SUB1) = ZERO                          
A02003         AND WS-AMT-AR-DAY-30-AC (SUB1) > ZERO                    
A02003             MOVE 52 TO WS-AUD-SUB                                
A02003             PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT         
ACT230         END-IF                                                   
      *                                                                     1917
A02003         IF WS-PYMT-PRIORITY-LVL-AC (SUB1) = 39                   
A02003         AND WS-ITEM-ID-AC (SUB1) = ZERO                          
A02003         AND WS-AMT-AR-DAY-00-AC (SUB1) > ZERO                    
A02003             MOVE 53 TO WS-AUD-SUB                                
A02003             PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT         
ACT230         END-IF                                                   
ACT230     END-IF.                                                      
      *                                                                 19290000
A02003     IF WS-PYMT-PRIORITY-LVL-AC (SUB1) = 60                       
A02003     AND WS-ITEM-ID-AC (SUB1) = 1                                 
A02003     AND WS-AMT-AR-DAY-00-AC (SUB1) > ZERO                        
A02003         MOVE 54 TO WS-AUD-SUB                                    
A02003         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
           END-IF.                                                      
      *                                                                 19410000
A02003     IF WS-PYMT-PRIORITY-LVL-AC (SUB1) = 70                       
A02003     AND WS-ITEM-ID-AC (SUB1) = 1                                 
A02003     AND WS-AMT-UNUSED-CR-AC (SUB1) NOT = ZERO                    
A02003     AND WS-CODES-DATA-PRESENT-AT (3:1) NOT = 'A'                 
P00453         IF WS-ACCOUNT-NO-PK(SUB1) > ZERO                         
P00453            MOVE 196 TO WS-AUD-SUB                                
ACT230            PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT          
P00453         ELSE                                                     
ACT230            IF ((SEB-DATABASE AND WS-REGULATED-CD-AT = '02') OR   
ACT230                (CSR-DATABASE AND WS-COMPANY-NO-AT   = '26'))     
ACT230               CONTINUE                                           
ACT230            ELSE                                                  
A02003               MOVE 55 TO WS-AUD-SUB                              
ACT230               PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT       
ACT230            END-IF                                                
P00453         END-IF                                                   
           END-IF.                                                      
      *                                                                 19540000
ACT230     IF (CSR-DATABASE AND WS-COMPANY-NO-AT   = '26')              
ACT230        CONTINUE                                                  
ACT230     ELSE                                                         
A02003        IF WS-PYMT-PRIORITY-LVL-AC (SUB1) = 80                    
A02003        AND WS-AMT-AR-DAY-00-AC (SUB1) > ZERO                     
A02003            MOVE 56 TO WS-AUD-SUB                                 
A02003            PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT          
ACT230        END-IF                                                    
ACT230     END-IF.                                                      
      *                                                                 19650000
A02003     IF WS-PYMT-PRIORITY-LVL-AC (SUB1) = 129                      
A02003     AND WS-ITEM-ID-AC (SUB1) = 1                                 
A02003     AND WS-AMT-AR-DAY-00-AC (SUB1) > ZERO                        
A02003         MOVE 57 TO WS-AUD-SUB                                    
A02003         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
           END-IF.                                                      
      *                                                                 19770000
       1560-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19800000
      ************************************************************      19810000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      19820000
      *  0009 = LATE PAYMENT CHARGE                              *      19830000
      ************************************************************      19840000
       1600-LATE-PAYMENT-CHARGE.                                        
      *                                                                 19870000
           IF (WS-LPC-UTIL-ASSESSED-CALC > 0.00 OR                      
A02003         WS-LPC-NONUT-ASSESSED-CALC > 0.00)                       
A02003         MOVE 9 TO WS-AUD-SUB                                     
A02003         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
A02003     END-IF.                                                      
      *                                                                 19970000
       1600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20000000
      ************************************************************      20010000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      20020000
      *  0016 = SUB METER                                        *      20030000
      *  0017 = ADD METER                                        *      20040000
      ************************************************************      20050000
       1700-SELECT-ADD-SUB-METERS.                                      
      *                                                                 20080000
A02003     IF WS-CODE-ACCT-USAGE-AT = 'D'                               
A02003         MOVE 16 TO WS-AUD-SUB                                    
A02003         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
A02003     END-IF.                                                      
                                                                        
A02003     IF WS-CODE-ACCT-USAGE-AT = 'B'                               
A02003         MOVE 17 TO WS-AUD-SUB                                    
A02003         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
A02003     END-IF.                                                      
      *                                                                 20250000
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20250000
      ******************************************************************        
      * DFA ACCOUNTS.                                                  *        
      ******************************************************************        
       1730-DFA-ACCOUNT.                                                
      *                                                                         
           PERFORM VARYING WS-DFA-INDX FROM 1 BY 1 UNTIL                
I00177       WS-DFA-INDX > WS-DA-MAX-ENTRY OR                           
             WS-ACCOUNT-NO-DA(WS-DFA-INDX) = ZERO                       
             IF  WS-ACCOUNT-NO-DA(WS-DFA-INDX) = WS-ACCOUNT-NO-AT AND   
A02003           WS-CODE-DFA-TYPE-DA(WS-DFA-INDX) = 'A'                 
A02003           MOVE 128 TO WS-AUD-SUB                                 
A02003           PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT           
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
       1730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * TAX EXEMPT ACCOUNT.                                                     
      ******************************************************************        
       1740-TAX-EXEMPT.                                                 
      *                                                                         
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL            
A03876             WS-BILLING-INDX > WS-BG-MAX-ENTRY OR                 
                   WS-ACCOUNT-NO-BG(WS-BILLING-INDX) = ZERO             
A02003             IF (WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX) = 'Y'  
                     OR WS-CODE-CITY-TAX-XMT-BG (WS-BILLING-INDX) = 'Y' 
                     OR WS-CODE-OTHR-TAX-XMT-BG (WS-BILLING-INDX) = 'Y')
A02003                 MOVE 129 TO WS-AUD-SUB                           
A02003                 PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT     
                    END-IF                                              
           END-PERFORM.                                                 
      *                                                                         
       1740-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * WNA HI/LO CHECK.                                              *         
      *****************************************************************         
       1760-WNA-HILO-CHECK-FAIL.                                        
      *                                                                         
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL            
A03876             WS-BILLING-INDX > WS-BG-MAX-ENTRY OR                 
                   WS-ACCOUNT-NO-BG(WS-BILLING-INDX) = ZERO             
      **CHECK THE DOC TPR32768 FOR THIS CHANGE!!!                               
A02003                 MOVE 131 TO WS-AUD-SUB                           
A02003                 PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT     
           END-PERFORM.                                                 
      *                                                                         
       1760-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      20296000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      20300000
      *  0022 = INTERRUPTIBLE CREDIT                             *      20310000
      *  0023 = STANDBY CREDIT                                   *      20320000
      *  0024 = ANNUAL MINIMUM ADJUSTMENT                        *      20330000
      *  0025 = MONTHLY MINIMUM                                  *      20340000
      *  0026 = VOLTAGE DISCOUNT (LOSS)                          *      20350000
      *  0027 = TRANSFORMER DISCOUNT (LOSS)                      *      20360000
P00430*  0191 = OPT-OUT WITH DSM CREDIT                          *      20380000
      ************************************************************      20390000
       1800-PROCESS-BA.                                                 
      *                                                                 20420000
           MOVE 1 TO SUB1.                                              
           PERFORM UNTIL SUB1 > 100 OR WS-ACCOUNT-NO-BA (SUB1) = ZEROES 
A02003         EVALUATE WS-FACTOR-ID-BA (SUB1)                          
A02003           WHEN 'INTRCRED '                                       
A02003             MOVE 22 TO WS-AUD-SUB                                
A02003           WHEN 'STDBY    '                                       
A02003             MOVE 23 TO WS-AUD-SUB                                
A02003           WHEN 'SPANMIN  '                                       
A02003             MOVE 24 TO WS-AUD-SUB                                
A02003           WHEN 'SPMNTMIN '                                       
A02003             MOVE 25 TO WS-AUD-SUB                                
A02003           WHEN 'VOLTDISC '                                       
A02003             MOVE 26 TO WS-AUD-SUB                                
A02003           WHEN 'XFMRDISC '                                       
A02003             MOVE 27 TO WS-AUD-SUB                                
A02003           WHEN 'DSMCREDIT'                                       
P00430             MOVE 191 TO WS-AUD-SUB                               
P0805B           WHEN 'EXTCREDTX'                                       
P00805             MOVE 67 TO WS-AUD-SUB                                
P00805           WHEN 'EXIT FEE'                                        
P00805             MOVE 68 TO WS-AUD-SUB                                
A02003         END-EVALUATE                                             
A02003         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
               ADD 1 TO SUB1                                            
           END-PERFORM.                                                 
      *                                                                 21210000
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21240000
      ************************************************************      21250000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      21260000
      *  0032 = MULTIPLE DUE DATES                               *      21270000
      ************************************************************      21280000
       1900-MULTIPLE-DUE-DATES.                                         
      *                                                                 21240000
ACT003     IF  WS-BALANCE-FWD-DUE-DATE > SPACES AND                     
ACT003         (WS-TOTAL-DUE-DATE NOT =                                 
A02003         WS-BALANCE-FWD-DUE-DATE)                                 
A02003           MOVE 32 TO WS-AUD-SUB                                  
A02003           PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT           
A02003     END-IF.                                                      
      *                                                                 21430000
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21460000
      ************************************************************      21470000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      21480000
A02003*  0060 = ELECTRIC MARKETING PGMS CONTRACT                 *      21490000
A02003*  0061 = GAS MARKETING PGMS CONTRACT                      *      21490000
A02003*  0062 = SERVICE CHARGES CONTRACT                         *      21490000
A02003*  0063 = ENDV CHARGES CONTRACT                            *      21490000
A02003*  0064 = MISC CHARGES CONTRACT                            *      21490000
A02003*  0065 = SERVICE CARE CONTRACT                            *      21490000
A02003*  0066 = MISC CREDITS CONTRACT                            *      21490000
A02003*  0067 = ARM CONTRACT                                     *      21490000
A02003*  0068 = SCANA SECURITY CONTRACT                          *      21490000
      ************************************************************      21500000
       2000-INSTALLMENT-CONTRACT.                                       
      *                                                                 21530000
           MOVE 'N' TO WS-ZERODAY-FLAG.                                 
           MOVE +0 TO SUB1.                                             
I00177     PERFORM UNTIL SUB1 > WS-CT-MAX-ENTRY                         
A02003       ADD 1 TO SUB1                                              
A02003       IF SUB1 <= WS-CT-MAX-ENTRY AND                             
                WS-ACCOUNT-NO-CT (SUB1) NOT = ZEROS                     
A02003          IF WS-CNT-STATUS-CD-CT (SUB1) = 'B'                     
A02003            EVALUATE WS-CODE-CONTRACT-TYPE-CT (SUB1)              
A02003              WHEN 'B'                                            
A02003               MOVE 61 TO WS-AUD-SUB                              
A02003              WHEN 'C'                                            
A02003               MOVE 62 TO WS-AUD-SUB                              
P00565*             WHEN 'D'                                                    
P00565*              MOVE 63 TO WS-AUD-SUB                                      
A02003              WHEN 'E'                                            
A02003               MOVE 64 TO WS-AUD-SUB                              
A02003              WHEN 'F'                                            
A02003               MOVE 65 TO WS-AUD-SUB                              
A02003              WHEN 'G'                                            
A02003               MOVE 66 TO WS-AUD-SUB                              
P00565*             WHEN 'H'                                                    
P00565*              MOVE 67 TO WS-AUD-SUB                                      
P00565*             WHEN 'I'                                                    
P00565*              MOVE 68 TO WS-AUD-SUB                                      
A02003            END-EVALUATE                                          
A02003            PERFORM 2010-CHK-ZERODAY THRU 2010-EXIT               
A02003            IF WS-ZERODAY-FLAG = 'Y'                              
A02003              MOVE 'N' TO WS-ZERODAY-FLAG                         
A02003              PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT        
A02003            END-IF                                                
A02003            MOVE 0 TO WS-AUD-SUB                                  
A02003          END-IF                                                  
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 23260000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23290000
       2005-SERVICECARE-TAX.                                            
      *                                                                 23290000
           MOVE +0 TO SUB1.                                             
           PERFORM UNTIL SUB1 > 20                                      
                ADD 1 TO SUB1                                           
I00177           IF SUB1 <= WS-CT-MAX-ENTRY                             
                 AND WS-ACCOUNT-NO-CT (SUB1) NOT = ZEROS                
                 AND WS-CODE-CONTRACT-TYPE-CT (SUB1) = 'F'              
                 AND WS-CNT-STATUS-CD-CT (SUB1) = 'B'                   
                     IF WS-TOTAL-TAX-AMOUNT (SUB1) > ZERO               
A02003                  MOVE 120 TO WS-AUD-SUB                          
A02003                  PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT    
                     END-IF                                             
A04494**PSNC Service Care Non-Tax                                               
A04494               IF WS-COMPANY-NO-AT = '26'                         
A04494               AND WS-CNT-NAME-CD-CT (SUB1) = 645                 
A04494                  MOVE 121 TO WS-AUD-SUB                          
A04494                  PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT    
A04494               END-IF                                             
                END-IF                                                  
           END-PERFORM.                                                 
                                                                        
      *                                                                 23500000
       2005-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23530000
      ************************************************************      23540000
      *  CHECK FOR ZERO DAY MONEY IN AR_CNTL FOR CONTRACTED      *      23550000
      *  SELECTED BY 2000-INSTALLMENT CONTRACT                   *      23560000
      ************************************************************      23570000
       2010-CHK-ZERODAY.                                                
      *                                                                 23530000
           MOVE 0 TO ZERO-SUB.                                          
I00177     PERFORM UNTIL ZERO-SUB > WS-AC-MAX-ENTRY                     
I00177                OR WS-ZERODAY-FLAG = 'Y'                          
             ADD 1 TO ZERO-SUB                                          
I00177        IF ZERO-SUB <= WS-AC-MAX-ENTRY                            
              AND WS-ACCOUNT-NO-AC (ZERO-SUB) NOT = ZERO                
               AND WS-PYMT-PRIORITY-LVL-AC (ZERO-SUB) = 100             
                AND WS-ITEM-ID-AC (ZERO-SUB) = WS-CNT-ITEM-ID-CT (SUB1) 
                 AND WS-AMT-AR-DAY-00-AC (ZERO-SUB) > ZERO              
                  MOVE 'Y' TO WS-ZERODAY-FLAG                           
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                 23700000
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23730000
      ************************************************************      23740000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      23750000
      *  0035 = DEPOSIT AND INTEREST REFUNDED                    *      23760000
      ************************************************************      23770000
       2100-DEPOSIT-REFUND.                                             
                                                                        
A03810     SET WS-AR-TRN-INDX TO 1.                                     
A03810     SEARCH WS-TRANS-HIST-DATA-AR                                 
A03810       WHEN (WS-ACCOUNT-NO-AT =  WS-ACCOUNT-NO-AR (WS-AR-TRN-INDX)
A03810             AND                                                  
A03810             WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX) = 'PCSCA097B')
A03810                 MOVE 35 TO WS-AUD-SUB                            
A03810                 PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT.    
                                                                        
      *                                                                 24040000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24070000
      ************************************************************      24080000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      24090000
      *  0037 - 0049 CREDIT MESSAGES.  UNCOMMENT AND MODIFY      *      24100000
      *  AFTER BILLING TPRS TO SET MESSAGE NUMBERS ARE DONE.     *      24110000
      ************************************************************      24130000
       2200-CREDIT-MESSAGES.                                            
      *                                                                 24070000
A04494     IF WS-BILL-CRED-MSG-ID-1H > SPACES                           
A04494         EVALUATE WS-BILL-CRED-MSG-ID-1H                          
A04494             WHEN 91001                                           
A04494                 MOVE 37 TO WS-AUD-SUB                            
A04494             WHEN 91002                                           
A04494                 MOVE 38 TO WS-AUD-SUB                            
A04494         END-EVALUATE                                             
A04494         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
A04494     END-IF.                                                      
P00599     IF WS-BILL-CRED-NOT-ID-1H > SPACES                           
P00599         EVALUATE WS-BILL-CRED-NOT-ID-1H                          
                   WHEN 90105                                           
A02003                 MOVE 39 TO WS-AUD-SUB                            
                   WHEN 90101                                           
A02003                 MOVE 41 TO WS-AUD-SUB                            
                   WHEN 90102                                           
A02003                 MOVE 42 TO WS-AUD-SUB                            
                   WHEN 90103                                           
A02003                 MOVE 43 TO WS-AUD-SUB                            
                   WHEN 90104                                           
A02003                 MOVE 44 TO WS-AUD-SUB                            
                   WHEN 90401                                           
A02003                 MOVE 45 TO WS-AUD-SUB                            
                   WHEN 90402                                           
A02003                 MOVE 46 TO WS-AUD-SUB                            
                   WHEN 90403                                           
A02003                 MOVE 47 TO WS-AUD-SUB                            
                   WHEN 90404                                           
A02003                 MOVE 48 TO WS-AUD-SUB                            
                   WHEN 90405                                           
A02003                 MOVE 49 TO WS-AUD-SUB                            
               END-EVALUATE                                             
A02003         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
P00599     END-IF.                                                      
      *                                                                 26480000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26510000
      ************************************************************      26520000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      26530000
      *  0069  EXCISE TAX EXEMPT ACCOUNT.                        *      26540000
      ************************************************************      26550000
       2300-EXCISE-TAX-EXEMPT.                                          
      *                                                                 26580000
           MOVE 'N'                     TO WS-STATE-TAX-EXEMPT-EXISTS   
           MOVE WS-ACCOUNT-NO-BI        TO UT-ACCOUNT-NO                
           MOVE 'G'                     TO UT-CODE-UTIL-TYPE            
           MOVE 'FEDERAL GOVT'          TO UT-STATE-TAX-EXMPT-NO        
      *                                                                 26630000
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-STATE-TAX-EXEMPT-EXISTS                       
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO            
                  AND UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE        
                  AND UT.STATE_TAX_EXMPT_NO = :UT-STATE-TAX-EXMPT-NO    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26640000
MFA-TR*        SELECT 'Y'                                               26650000
MFA-TR*          INTO :WS-STATE-TAX-EXEMPT-EXISTS                       26660000
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                               26670000
MFA-TR*         WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO            26680000
MFA-TR*           AND UT.CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE        26690000
MFA-TR*           AND UT.STATE_TAX_EXMPT_NO = :UT-STATE-TAX-EXMPT-NO    26700000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    26710000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN -811                                                
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 2300-EXIT                                      
               WHEN OTHER                                               
                   MOVE 'UT'              TO WS-DB2-TABLE-ID            
                   MOVE 'SELECT'          TO WS-DB2-FUNCTION            
                   MOVE SQLCODE           TO WS-DB2-RETURN-CODE         
                   MOVE '168'             TO WS-DB2-MODULE-ID           
                   MOVE '2300'            TO WS-DB2-PARAGRAPH           
                   MOVE 12                TO RETURN-CODE                
                   PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT            
           END-EVALUATE.                                                
                                                                        
           IF WS-STATE-TAX-EXEMPT-EXISTS = 'Y'                          
A02003        MOVE 69 TO WS-AUD-SUB                                     
A02003        PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT              
           END-IF.                                                      
      *                                                                 27000000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27030000
      ************************************************************      27040000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      27050000
      *  0070 - 0071 TRANSFER BETWEEN GROUPS                     *      27060000
      ************************************************************      27070000
       2400-CHK-GROUP-TRAN.                                             
      *                                                                 27030000
           SET WS-MH-TRN-INDX TO 1.                                     
           SEARCH WS-TRANS-HIST-DATA-MH                                 
             AT END                                                     
                 MOVE SPACES TO WS-PREV-GRP-CD-AT                       
             WHEN (WS-ACCOUNT-NO-AT =                                   
                   WS-ACCOUNT-NO-MH (WS-MH-TRN-INDX) AND                
                    (WS-APPL-PROGRAM-ID-MH (WS-MH-TRN-INDX) = 'CSR039CR'
                     OR WS-APPL-PROGRAM-ID-MH (WS-MH-TRN-INDX) =        
                                                            'CSR039SR'))
                      PERFORM 2410-SET-GROUP-TRAN THRU 2410-EXIT.       
      *                                                                 27170000
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27200000
       2410-SET-GROUP-TRAN.                                             
      *                                                                 27200000
           IF WS-REG-GROUP-CD-AT = '200'                                
A02003        MOVE 70 TO WS-AUD-SUB                                     
A02003        PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT              
           ELSE                                                         
              IF WS-REG-GROUP-CD-AT = '100'                             
A02003           MOVE 71 TO WS-AUD-SUB                                  
A02003           PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                 27430000
       2410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27460000
      ************************************************************      27470000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      27480000
      *  0072 - 0073 RECONNECT ON GROUPS                         *      27490000
      ************************************************************      27500000
       2500-CHK-RECONNECT.                                              
      *                                                                 27460000
           SET WS-AR-TRN-INDX TO 1.                                     
           SEARCH WS-TRANS-HIST-DATA-AR                                 
             AT END                                                     
                 MOVE SPACES TO WS-HOLD-RECON                           
             WHEN (WS-ACCOUNT-NO-AT =                                   
                   WS-ACCOUNT-NO-AR (WS-AR-TRN-INDX) AND                
                   WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX) = 'PCSSO67B') 
                      PERFORM 2510-SET-RECONNECT THRU 2510-EXIT.        
      *                                                                 27600000
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27630000
       2510-SET-RECONNECT.                                              
      *                                                                 27630000
           IF WS-REG-GROUP-CD-AT = '100'                                
A02003        MOVE 72 TO WS-AUD-SUB                                     
A02003        PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT              
           ELSE                                                         
              IF WS-REG-GROUP-CD-AT = '200'                             
A02003           MOVE 73 TO WS-AUD-SUB                                  
A02003           PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                 27860000
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27890000
      ************************************************************      28080000
      *  CHECK HARDCODED CONDITIONS TABLE FROM CWS00091.         *      28090000
      *  0075 - 0082 REGULATED BILL MESSAGES                     *      28100000
      ************************************************************      28110000
       2700-REGULATED-MESG.                                             
      *                                                                 28070000
           MOVE 1 TO SUB1.                                              
           PERFORM UNTIL SUB1 > 10 OR                                   
                         WS-BILL-MESSAGE-NO-CALC (SUB1) = ZEROES        
               EVALUATE WS-BILL-MESSAGE-NO-CALC (SUB1)                  
                   WHEN 91070                                           
A02003                 MOVE 75 TO WS-AUD-SUB                            
                   WHEN 91071                                           
A02003                 MOVE 76 TO WS-AUD-SUB                            
                   WHEN 93002                                           
A02003                 MOVE 77 TO WS-AUD-SUB                            
                   WHEN 93003                                           
A02003                 MOVE 78 TO WS-AUD-SUB                            
                   WHEN 93157                                           
A02003                 MOVE 161 TO WS-AUD-SUB                           
                   WHEN 93158                                           
A02003                 MOVE 162 TO WS-AUD-SUB                           
                   WHEN 93161                                           
A02003                 MOVE 163 TO WS-AUD-SUB                           
                   WHEN 93162                                           
A02003                 MOVE 165 TO WS-AUD-SUB                           
                   WHEN 93163                                           
A02003                 MOVE 159 TO WS-AUD-SUB                           
                   WHEN 93164                                           
A02003                 MOVE 160 TO WS-AUD-SUB                           
                   WHEN 93165                                           
A02003                 MOVE 157 TO WS-AUD-SUB                           
                   WHEN 93166                                           
A02003                 MOVE 164 TO WS-AUD-SUB                           
                   WHEN 93167                                           
A02003                 MOVE 167 TO WS-AUD-SUB                           
                   WHEN 93168                                           
A02003                 MOVE 168 TO WS-AUD-SUB                           
               END-EVALUATE                                             
A02003         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
               ADD 1 TO SUB1                                            
           END-PERFORM.                                                 
      ******************************************************************30990000
      **  PROCESS AUDIT BILLS FOR GROUP 2 FIXED RATE PLANS.           **31000000
      ******************************************************************31010000
      *                                                                         
T06000     EVALUATE TRUE                                                
           WHEN FIXED-RATE                                              
             IF WS-CA195-DURATION-REMAIN-NO = 1                         
                IF WS-INSERT-MARK(4) = '1'                              
A02003             MOVE 169 TO WS-AUD-SUB                               
A02003             PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT         
                END-IF                                                  
             END-IF                                                     
           WHEN VARIABLE-RATE                                           
                  IF WS-INSERT-MARK(5) = '1'                            
A02003               MOVE 170 TO WS-AUD-SUB                             
A02003               PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT       
                  END-IF                                                
           END-EVALUATE.                                                
      *                                                                 28560000
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28590000
P00680 2800-PROCESS-PRICE-NEGOTIATED.                                   
P00680*                                                                 20080000
P00680     PERFORM VARYING WS-RTPK-INDX FROM 1 BY 1 UNTIL               
P00680       WS-RTPK-INDX > WS-DF-MAX-ENTRY OR                          
P00680       WS-ACCOUNT-NO-DF(WS-RTPK-INDX) = ZERO                      
P00680       PERFORM VARYING WS-UTIL-INDX FROM 1 BY 1 UNTIL             
P00680         WS-UTIL-INDX > 40 OR                                     
P00680         WS-ACCOUNT-NO-UT(WS-UTIL-INDX) = ZERO                    
P00680         IF WS-ACCOUNT-NO-DF(WS-RTPK-INDX) =                      
P00680            WS-ACCOUNT-NO-UT(WS-UTIL-INDX) AND                    
P00680            WS-CODE-UTIL-TYPE-DF(WS-RTPK-INDX) =                  
P00680            WS-CODE-UTIL-TYPE-UT(WS-UTIL-INDX) AND                
P00680            WS-IC-NO-DF(WS-RTPK-INDX) = WS-IC-NO-UT(WS-UTIL-INDX) 
P00680           IF WS-RT-PKG-OPT-SEQ-NO-DF(WS-RTPK-INDX) =             
P00680                       WS-RT-PKG-OPT-SEQ-NO-UT(WS-UTIL-INDX) AND  
P00680              WS-PRCE-NEGOTIATED-CD-DF(WS-RTPK-INDX) = 'Y'        
P00680              MOVE 3 TO WS-AUD-SUB                                
P00680              PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT        
P00680           END-IF                                                 
P00680         END-IF                                                   
P00680       END-PERFORM                                                
P00680     END-PERFORM.                                                 
P00680*                                                                 20250000
P00680 2800-EXIT.                                                       
P00680     EXIT.                                                        
P00680*                                                                 20250000
       2900-AUTO-EPP-OFFER.                                             
      *                                                                 28590000
           MOVE SPACE TO WS-AUTO-EPP-SW.                                
           MOVE 1 TO WS-MSG-SUB.                                        
           PERFORM UNTIL WS-MSG-SUB > 10                                
               IF WS-BILL-MESSAGE-NO-CALC (WS-MSG-SUB) = 95002 OR       
                  WS-BILL-MESSAGE-NO-CALC (WS-MSG-SUB) = 95003          
                   SET AUTO-EPP-OFFER TO TRUE                           
               END-IF                                                   
               ADD 1 TO WS-MSG-SUB                                      
           END-PERFORM                                                  
           IF AUTO-EPP-OFFER                                            
               IF WS-TOT-OTHER-CHARGES-BI > 0                           
A02003             MOVE 85 TO WS-AUD-SUB                                
A02003             PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT         
               END-IF                                                   
               IF WS-TOT-OTHER-CHARGES-BI <= 0                          
A02003             MOVE 86 TO WS-AUD-SUB                                
A02003             PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                 28940000
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28940000
ACT056 2901-30DAY-VAR-MSG.                                              
ACT056*                                                                 28590000
ACT056     MOVE 1 TO WS-30DAY-SUB.                                      
ACT056     PERFORM UNTIL WS-30DAY-SUB  > 10                             
ACT056         IF WS-BILL-MESSAGE-NO-CALC (WS-30DAY-SUB) = 50527        
ACT056            MOVE 94 TO WS-AUD-SUB                                 
ACT056            PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT          
ACT056         END-IF                                                   
ACT056         ADD 1 TO WS-30DAY-SUB                                    
ACT056     END-PERFORM.                                                 
ACT056*                                                                 28940000
ACT056 2901-EXIT.                                                       
ACT056     EXIT.                                                        
      *                                                                 28940000
ACT056 2902-60DAY-VAR-MSG.                                              
ACT056*                                                                 28590000
ACT056     MOVE 1 TO WS-60DAY-SUB.                                      
ACT056     PERFORM UNTIL WS-60DAY-SUB > 10                              
ACT056         IF WS-BILL-MESSAGE-NO-CALC (WS-60DAY-SUB) = 50629        
ACT056            MOVE 95 TO WS-AUD-SUB                                 
ACT056            PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT          
ACT056         END-IF                                                   
ACT056         ADD 1 TO WS-60DAY-SUB                                    
ACT056     END-PERFORM.                                                 
ACT056*                                                                 28940000
ACT056 2902-EXIT.                                                       
ACT056     EXIT.                                                        
      *                                                                 28940000
       3000-AUTO-EPP-WELCOME.                                           
      *                                                                 28940000
           MOVE SPACES TO WS-S-DATE-PYMT-STRT                           
                          WS-O-DATE-PYMT-STRT                           
                          WS-AUTO-EPP-SW                                
                          WS-HOLD-DATE-PYMT-STRT.                       
      ************************************************************      29000000
      **  SELECT THE DATE-PYMT-STRT FOR THE OFFER ROW, AND THE  **      29010000
      **  ESTIMATE AMOUNT TO PRINT ON THE BILL MESSAGE.         **      29020000
      ************************************************************      29030000
           MOVE WS-ACCOUNT-NO-AT TO WS-BUDG-ACCT-NO.                    
           MOVE 'O' TO WS-HOLD-CHG-REASON                               
           PERFORM 3010-SELECT-DATE-PYMT-STRT THRU 3010-EXIT.           
           IF WS-CHECK-RETURN-CODE = SUCCESSFUL-CALL                    
               MOVE WS-HOLD-DATE-PYMT-STRT TO WS-O-DATE-PYMT-STRT       
               MOVE BH-EPP-ESTIMATE TO WS-HOLD-EPP-ESTIMATE             
           END-IF.                                                      
      ************************************************************      29110000
      **  SELECT THE DATE-PYMT-STRT FOR THE SETUP ROW.          **      29120000
      ************************************************************      29130000
           MOVE 'S' TO WS-HOLD-CHG-REASON.                              
           PERFORM 3010-SELECT-DATE-PYMT-STRT THRU 3010-EXIT.           
           IF WS-CHECK-RETURN-CODE = SUCCESSFUL-CALL                    
               MOVE WS-HOLD-DATE-PYMT-STRT TO WS-S-DATE-PYMT-STRT       
           END-IF.                                                      
      ************************************************************      29190000
      **  IF THE DATE-PYMT-STRT FOR THE OFFER AND SETUP ROWS    **      29200000
      **  ARE THE SAME, THEN THE ACCOUNT WAS SET UP ON EPP BY   **      29210000
      **  THE AUTOMATIC EPP OFFER PROMOTION.                    **      29220000
      ************************************************************      29230000
           IF WS-O-DATE-PYMT-STRT > SPACES AND                          
              WS-S-DATE-PYMT-STRT > SPACES                              
               IF WS-O-DATE-PYMT-STRT = WS-S-DATE-PYMT-STRT             
                  MOVE 'N' TO WS-EPP-PYMT-MADE                          
                  MOVE WS-ACCOUNT-NO-AT TO MH-ACCOUNT-NO                
                  MOVE WS-DATE-BILL-DAY-00-AT TO WS-THIS-BILL-DATE      
                  IF WS-DATE-BILL-DAY-30-AT <= SPACES                   
                     MOVE '1990-01-01' TO WS-LAST-BILL-DATE             
                  ELSE                                                  
                     MOVE WS-DATE-BILL-DAY-30-AT TO WS-LAST-BILL-DATE   
                  END-IF                                                
                  PERFORM 3020-CHK-FOR-EPP-PYMT THRU 3020-EXIT          
                  IF WS-EPP-PYMT-MADE = 'Y' AND                         
                     WS-O-DATE-PYMT-STRT < WS-THIS-BILL-DATE AND        
                     WS-S-DATE-PYMT-STRT > WS-LAST-BILL-DATE            
                     SET AUTO-EPP-WELCOME TO TRUE                       
                  END-IF                                                
               END-IF                                                   
           END-IF.                                                      
           IF AUTO-EPP-WELCOME                                          
A02003         MOVE 87 TO WS-AUD-SUB                                    
A02003         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
           END-IF.                                                      
      *                                                                 29530000
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29530000
       3010-SELECT-DATE-PYMT-STRT.                                      
      *                                                                 29530000
           EXEC SQL                                                     
               OPEN BUDGET_HIST_CR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               DISPLAY ' 3010-SELECT-DATE-PYMT-STRT'                    
               DISPLAY ' ** SCSCA187 PROCESSING ERROR'                  
               DISPLAY ' ** ERROR ON OPEN   '                           
               DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE            
               DISPLAY ' ** TABLE CSS_BUDGET_HIST '                     
               DISPLAY ' ** KEY IS  '                                   
               DISPLAY ' ** ACCOUNT_NO     '  WS-BUDG-ACCT-NO           
               DISPLAY ' ** CHANGE_REASON  '  WS-HOLD-CHG-REASON        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           EXEC SQL                                                     
               FETCH BUDGET_HIST_CR                                     
                INTO :WS-HOLD-DATE-PYMT-STRT,                           
                     :BH-EPP-MTHS-RMNG-QT,                              
                     :BH-EPP-ESTIMATE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-CHECK-RETURN-CODE.                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
              WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
                               WS-DISPLAY-SQLCODE                       
               DISPLAY 'SCSCA187:3010 '                                 
               DISPLAY ' 3010-SELECT-DATE-PYMT-STRT'                    
               DISPLAY ' ** SCSCA187 PROCESSING ERROR'                  
               DISPLAY ' ** ERROR ON FETCH   '                          
               DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE            
               DISPLAY ' ** TABLE CSS_BUDGET_HIST  '                    
               DISPLAY ' ** KEY IS  '                                   
               DISPLAY ' ** ACCOUNT_NO     '  WS-BUDG-ACCT-NO           
               DISPLAY ' ** CHANGE_REASON  '  WS-HOLD-CHG-REASON        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
           EXEC SQL                                                     
               CLOSE BUDGET_HIST_CR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-DISPLAY-SQLCODE                           
                           WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               DISPLAY ' 3010-SELECT-DATE-PYMT-STRT'                    
               DISPLAY ' ** SCSCA187 PROCESSING ERROR'                  
               DISPLAY ' ** ERROR ON CLOSE  '                           
               DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE            
               DISPLAY ' ** TABLE CSS_BUDGET_HIST '                     
               DISPLAY ' ** KEY IS  '                                   
               DISPLAY ' ** ACCOUNT_NO     '  WS-BUDG-ACCT-NO           
               DISPLAY ' ** CHANGE_REASON  '  WS-HOLD-CHG-REASON        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       3010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      30150000
      **  THIS PARAGRAPH WILL CHECK THE SEE IF THE ACCOUNT      **      30160000
      **  WAS SET UP ON EPP DUE TO THE PAYMENT.                 **      30170000
      ************************************************************      30180000
       3020-CHK-FOR-EPP-PYMT.                                           
      *                                                                         
           EXEC SQL                                                     
               OPEN MAINT_TRN_HST                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               DISPLAY ' 3020-CHK-FOR-EPP-PYMT     '                    
               DISPLAY ' ** SCSCA187 PROCESSING ERROR'                  
               DISPLAY ' ** ERROR ON OPEN   '                           
               DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE            
               DISPLAY ' ** TABLE CSS_MNT_TRANS_HIST  '                 
               DISPLAY ' ** KEY IS  '                                   
               DISPLAY ' ** ACCOUNT_NO     '  MH-ACCOUNT-NO             
               DISPLAY ' ** DATE_TRANS >=  '  WS-LAST-BILL-DATE         
               DISPLAY ' ** DATE_TRANS <=  '  WS-THIS-BILL-DATE         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           EXEC SQL                                                     
               FETCH MAINT_TRN_HST                                      
                INTO :WS-EPP-PYMT-MADE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
              WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
                               WS-DISPLAY-SQLCODE                       
               DISPLAY 'SCSCA187:3020 '                                 
               DISPLAY ' 3020-CHK-FOR-EPP-PYMT     '                    
               DISPLAY ' ** SCSCA187 PROCESSING ERROR'                  
               DISPLAY ' ** ERROR ON FETCH  '                           
               DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE            
               DISPLAY ' ** TABLE CSS_MNT_TRANS_HIST '                  
               DISPLAY ' ** KEY IS  '                                   
               DISPLAY ' ** ACCOUNT_NO     '  MH-ACCOUNT-NO             
               DISPLAY ' ** DATE_TRANS >=  '  WS-LAST-BILL-DATE         
               DISPLAY ' ** DATE_TRANS <=  '  WS-THIS-BILL-DATE         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           EXEC SQL                                                     
               CLOSE MAINT_TRN_HST                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DISPLAY-SQLCODE.                          
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               DISPLAY ' 3020-CHK-FOR-EPP-PYMT     '                    
               DISPLAY ' ** SCSCA187 PROCESSING ERROR'                  
               DISPLAY ' ** ERROR ON CLOSE  '                           
               DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE            
               DISPLAY ' ** TABLE CSS_MNT_TRANS_HIST  '                 
               DISPLAY ' ** KEY IS  '                                   
               DISPLAY ' ** ACCOUNT_NO     '  MH-ACCOUNT-NO             
               DISPLAY ' ** DATE_TRANS >=  '  WS-LAST-BILL-DATE         
               DISPLAY ' ** DATE_TRANS <=  '  WS-THIS-BILL-DATE         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 30780000
       3020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 30810010
      ***************************************************************** 30810411
      * EPP INITIAL SETUP FOR AUDITS                                  *         
      ***************************************************************** 30810411
       3150-EPP-INITIAL-SETUP.                                          
      *                                                                 30810411
           IF WS-ACCOUNT-NO-BU > 0                                      
ACT074        MOVE WS-ACCOUNT-NO-AT           TO WS-BUDG-ACCT-NO        
ACT074        MOVE 'A'                        TO WS-HOLD-CHG-REASON     
              MOVE WS-ACCOUNT-NO-BU           TO BH-ACCOUNT-NO          
              MOVE 'S'                        TO BH-CHANGE-REASON       
              PERFORM 8000-BUDGET-HIST       THRU 8000-EXIT             
              MOVE BH-BUD-HIST-SEQ-NO (1:10)   TO WS-BUDGET-TRAN-DATE   
              IF WS-DATE-BILL-DAY-30-AT <= SPACES                       
                 MOVE '1990-01-01'        TO WS-LAST-BILL-DATE          
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = 0                              
A02003           IF  BH-EPP-MTHS-RMNG-QT = 11 AND                       
                     WS-BUDGET-TRAN-DATE >= WS-LAST-BILL-DATE  AND      
                     WS-BUDGET-TRAN-DATE <= WS-DATE-BILL-DAY-00-AT      
A02003                 MOVE 132 TO WS-AUD-SUB                           
A02003                 PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT     
                 END-IF                                                 
A02003           IF  BH-EPP-MTHS-RMNG-QT = 12  AND                      
                     WS-BUDGET-TRAN-DATE >= WS-LAST-BILL-DATE  AND      
                     WS-BUDGET-TRAN-DATE <= WS-DATE-BILL-DAY-00-AT      
A02003                 MOVE 133 TO WS-AUD-SUB                           
A02003                 PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       3150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * EPP DROP.                                                     *         
      *****************************************************************         
       3200-EPP-DROPS.                                                  
      *                                                                         
           IF WS-ACCOUNT-NO-BU > 0                                      
ACT074        MOVE WS-ACCOUNT-NO-AT          TO WS-BUDG-ACCT-NO         
ACT074        MOVE 'A'                       TO WS-HOLD-CHG-REASON      
              MOVE WS-ACCOUNT-NO-BU          TO BH-ACCOUNT-NO           
              MOVE 'D'                       TO BH-CHANGE-REASON        
              PERFORM 8000-BUDGET-HIST       THRU 8000-EXIT             
              IF WS-ACTIVE-RETURN-CODE = 0                              
A02003             IF (BH-REMARKS(1:30) =                               
                         'AUTOMATICALLY DROPPED FROM EPP' OR            
                       BH-REMARKS(1:18) =                               
                         'BUFFER FACTOR ELEC')                          
A02003                   MOVE 134 TO WS-AUD-SUB                         
A02003                   PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT   
                   END-IF                                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * EPP Anniversary -Credit Balance                                         
      *****************************************************************         
       3300-EPP-ANNIV.                                                  
      *                                                                         
           IF WS-ACCOUNT-NO-BU > 0                                      
A02003        IF  WS-ACCOUNT-EPP(1)       = WS-ACCOUNT-NO-BU AND        
                  WS-TOTAL-AR-BALANCE-AT  < 0                           
A02003              MOVE 135 TO WS-AUD-SUB                              
A02003              PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT        
              END-IF                                                    
           END-IF.                                                      
      * EPP Anniversary -Debit Balance                                          
           IF WS-ACCOUNT-NO-BU > 0                                      
A02003        IF  WS-ACCOUNT-EPP(1)       = WS-ACCOUNT-NO-BU AND        
                  WS-TOTAL-AR-BALANCE-AT  > 0                           
A02003              MOVE 136 TO WS-AUD-SUB                              
A02003              PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       3300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * EPP Change.                                                   *         
      *****************************************************************         
       3400-EPP-CHANGE.                                                 
      *                                                                         
           MOVE WS-REV-MTH-LST-NRML-AT        TO WS-BILLING-CCYYMM.     
           MOVE WS-ACCOUNT-NO-AT              TO WS-BUDG-ACCT-NO.       
           MOVE 'C'                           TO WS-HOLD-CHG-REASON.    
           PERFORM 1410-GET-BUDGET-DATA THRU 1410-EXIT.                 
           IF WS-BUDGET-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE BH-BUD-HIST-SEQ-NO(1:10) TO WS-BUDGET-TRAN-DATE      
              IF (WS-BUDGET-TRAN-DATE >= WS-DATE-BILL-DAY-30-AT AND     
A02003            WS-BUDGET-TRAN-DATE <= WS-DATE-BILL-DAY-00-AT)        
A02003              MOVE 137 TO WS-AUD-SUB                              
A02003              PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       3400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *Marketing contract Initial setup.                                        
      *****************************************************************         
       3500-INITIAL-SETUP.                                              
      *                                                                         
           PERFORM VARYING WS-AR-TRN-INDX FROM 1 BY 1 UNTIL             
             WS-AR-TRN-INDX > 2000 OR                                   
             WS-ACCOUNT-NO-AR (WS-AR-TRN-INDX) = 0                      
             IF WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX) = 'S' AND         
                WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX) = 'PANEL102A'    
A02003            MOVE 138 TO WS-AUD-SUB                                
A02003            PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT          
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
       3500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *Marketing contract Down Payments.                                        
      *****************************************************************         
       3525-DOWN-PAYMENT.                                               
      *                                                                         
           PERFORM VARYING WS-AR-TRN-INDX FROM 1 BY 1 UNTIL             
             WS-AR-TRN-INDX > 2000 OR                                   
             WS-ACCOUNT-NO-AR (WS-AR-TRN-INDX) = 0                      
             IF WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX) = 'S' AND         
                WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX) = 'PANEL404P'    
A02003            MOVE 139 TO WS-AUD-SUB                                
A02003            PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT          
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
       3525-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * Directed Pay off.                                                       
      *****************************************************************         
       3550-PAYOFF.                                                     
      *                                                                         
            PERFORM VARYING WS-CNT-INDX FROM 1 BY 1 UNTIL               
I00177       WS-CNT-INDX > WS-CT-MAX-ENTRY OR                           
             WS-ACCOUNT-NO-CT(WS-CNT-INDX) = 0                          
             IF WS-CNT-STATUS-CD-CT (WS-CNT-INDX) = 'C'                 
               PERFORM VARYING WS-AR-TRN-INDX FROM 1 BY 1 UNTIL         
                WS-AR-TRN-INDX > 2000 OR                                
                WS-ACCOUNT-NO-AR (WS-AR-TRN-INDX) = 0                   
                IF WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX) = 'P' AND      
                   WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX) = 'PANEL113D' 
                    PERFORM VARYING WS-AU-DET-INDX FROM 1 BY 1 UNTIL    
                    WS-AU-DET-INDX > 1500 OR                            
                    WS-ACCOUNT-NO-AU (WS-AU-DET-INDX) = 0               
                     IF WS-ACCOUNT-NO-AR (WS-AR-TRN-INDX) =             
                        WS-ACCOUNT-NO-AU (WS-AU-DET-INDX) AND           
                        WS-TRANS-HIST-SEQ-NO-AR (WS-AR-TRN-INDX) =      
                        WS-TRANS-HIST-SEQ-NO-AU (WS-AU-DET-INDX) AND    
                        WS-CNT-ITEM-ID-CT (WS-CNT-INDX) =               
                        WS-ITEM-ID-AU(WS-AU-DET-INDX) AND               
                        WS-CODE-CONTRACT-TYPE-CT(WS-CNT-INDX)=          
                        WS-CODE-CONTRACT-TYPE-AU(WS-AU-DET-INDX) AND    
                        WS-CODE-AR-AGE-AU(WS-AU-DET-INDX) = 'P' AND     
                     WS-GL-ACCT-CREDIT-AU(WS-AU-DET-INDX) = 142.0900 AND
                     WS-GL-ACCT-DEBIT-AU(WS-AU-DET-INDX)  = 184.2201    
A02003                    MOVE 140 TO WS-AUD-SUB                        
A02003                    PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT  
                     END-IF                                             
                    END-PERFORM                                         
                  END-IF                                                
                END-PERFORM                                             
             END-IF                                                     
           END-PERFORM.                                                 
      * Misc Debit/Credit.                                                      
            PERFORM VARYING WS-CNT-INDX FROM 1 BY 1 UNTIL               
I00177       WS-CNT-INDX > WS-CT-MAX-ENTRY OR                           
             WS-ACCOUNT-NO-CT(WS-CNT-INDX) = 0                          
             IF WS-CNT-STATUS-CD-CT (WS-CNT-INDX) = 'C'                 
               PERFORM VARYING WS-AR-TRN-INDX FROM 1 BY 1 UNTIL         
                WS-AR-TRN-INDX > 2000 OR                                
                WS-ACCOUNT-NO-AR (WS-AR-TRN-INDX) = 0                   
                IF WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX) = 'S' AND      
                   WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX) = 'PANEL487A' 
A02003               MOVE 140 TO WS-AUD-SUB                             
A02003               PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT       
                END-IF                                                  
               END-PERFORM                                              
             END-IF                                                     
            END-PERFORM.                                                
      *                                                                         
      * Normal Bill Payoff cannot be identified as the contract details         
      * will not be available to Bill Print after its paid off.                 
      *                                                                         
       3550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * Cancel Contract                                                         
      *****************************************************************         
       3575-CANCEL-CONTRACT.                                            
      *                                                                         
           PERFORM VARYING WS-CNT-INDX FROM 1 BY 1 UNTIL                
I00177       WS-CNT-INDX > WS-CT-MAX-ENTRY OR                           
             WS-ACCOUNT-NO-CT(WS-CNT-INDX) = 0                          
             IF WS-CNT-STATUS-CD-CT (WS-CNT-INDX) = 'D'                 
               PERFORM VARYING WS-AR-TRN-INDX FROM 1 BY 1 UNTIL         
                WS-AR-TRN-INDX > 2000 OR                                
                WS-ACCOUNT-NO-AR (WS-AR-TRN-INDX) = 0                   
                IF WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX) = 'S' AND      
                   WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX) = 'PANEL403B' 
A02003               MOVE 141 TO WS-AUD-SUB                             
A02003               PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT       
                END-IF                                                  
               END-PERFORM                                              
             END-IF                                                     
            END-PERFORM.                                                
      *                                                                         
       3575-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * ONE TIME CONTRACT                                             *         
      *****************************************************************         
       3600-ONE-TIME-CONTRACT.                                          
      *                                                                         
           PERFORM VARYING WS-CNT-INDX FROM 1 BY 1 UNTIL                
I00177       WS-CNT-INDX > WS-CT-MAX-ENTRY OR                           
             WS-ACCOUNT-NO-CT(WS-CNT-INDX) = 0                          
             IF WS-NO-SCHED-PYMTS-CT (WS-CNT-INDX) = 1                  
               PERFORM VARYING WS-AR-TRN-INDX FROM 1 BY 1 UNTIL         
                WS-AR-TRN-INDX > 2000 OR                                
                WS-ACCOUNT-NO-AR (WS-AR-TRN-INDX) = 0                   
                IF WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX) = 'S' AND      
                   WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX) = 'PANEL404'  
A02003               MOVE 142 TO WS-AUD-SUB                             
A02003               PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT       
                END-IF                                                  
               END-PERFORM                                              
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
       3600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * INSTALLMENTS.                                                           
      *****************************************************************         
       3610-INSTALLMENTS.                                               
      *                                                                         
           PERFORM VARYING WS-CNT-INDX FROM 1 BY 1 UNTIL                
I00177       WS-CNT-INDX > WS-CT-MAX-ENTRY OR                           
             WS-ACCOUNT-NO-CT(WS-CNT-INDX) = 0                          
             IF WS-NO-SCHED-PYMTS-CT (WS-CNT-INDX) > 1 AND              
                WS-CNT-STATUS-CD-CT(WS-CNT-INDX) = 'B'                  
A02003            MOVE 143 TO WS-AUD-SUB                                
A02003            PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT          
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
       3610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * Jobbing Contract.                                                       
      *****************************************************************         
       3625-CONTRACT-FOR-JOBBING.                                       
      *                                                                         
           PERFORM VARYING WS-CNT-INDX FROM 1 BY 1 UNTIL                
I00177       WS-CNT-INDX > WS-CT-MAX-ENTRY OR                           
             WS-ACCOUNT-NO-CT(WS-CNT-INDX) = 0                          
             IF WS-CNT-STATUS-CD-CT (WS-CNT-INDX) = 'B'                 
                MOVE WS-CNT-NAME-CD-CT (WS-CNT-INDX) TO K6-CNT-NAME-CD  
                PERFORM 3627-CHECK-JOBBING-CONTRACT  THRU 3627-EXIT     
                IF JOBBING-FOUND                                        
A02003             MOVE 144 TO WS-AUD-SUB                               
A02003             PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT         
                END-IF                                                  
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
       3625-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * TO CHECK IF THE CONTRACT IS A JOBBING CONTRACT.                         
      *****************************************************************         
       3627-CHECK-JOBBING-CONTRACT.                                     
      *                                                                         
           EXEC SQL                                                     
              SELECT GL_ACCT_NO                                         
                INTO :K6-GL-ACCT-NO                                     
                FROM CSS_CONTRACT_INFO WITH(READUNCOMMITTED)                    
               WHERE CNT_NAME_CD = :K6-CNT-NAME-CD                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GL_ACCT_NO                                                 
MFA-TR*         INTO :K6-GL-ACCT-NO                                             
MFA-TR*         FROM CSS_CONTRACT_INFO                                          
MFA-TR*        WHERE CNT_NAME_CD = :K6-CNT-NAME-CD                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF K6-GL-ACCT-NO = 415.1790                          
                      MOVE 'Y'              TO WS-JOBBING-FOUND-SW      
                   ELSE                                                 
                      MOVE SPACES           TO WS-JOBBING-FOUND-SW      
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES              TO WS-JOBBING-FOUND-SW      
               WHEN OTHER                                               
                   MOVE 'K6'                TO WS-DB2-TABLE-ID          
                   MOVE 'SELECT'            TO WS-DB2-FUNCTION          
                   MOVE SQLCODE             TO WS-DB2-RETURN-CODE       
                   MOVE '168'               TO WS-DB2-MODULE-ID         
                   MOVE '4000'              TO WS-DB2-PARAGRAPH         
                   MOVE 12                  TO RETURN-CODE              
                   PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       3627-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       3650-TRANSFER-CONTRACT.                                          
      *                                                                         
            PERFORM VARYING WS-CNT-INDX FROM 1 BY 1 UNTIL               
I00177       WS-CNT-INDX > WS-CT-MAX-ENTRY OR                           
             WS-ACCOUNT-NO-CT(WS-CNT-INDX) = 0                          
             IF WS-CNT-STATUS-CD-CT (WS-CNT-INDX) = 'C'                 
               PERFORM VARYING WS-AR-TRN-INDX FROM 1 BY 1 UNTIL         
                WS-AR-TRN-INDX > 2000 OR                                
                WS-ACCOUNT-NO-AR (WS-AR-TRN-INDX) = 0                   
                IF WS-CODE-TRAN-TYPE-AR (WS-AR-TRN-INDX) = 'T' AND      
                   WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX) = 'PANEL069'  
                    PERFORM VARYING WS-AU-DET-INDX FROM 1 BY 1 UNTIL    
                    WS-AU-DET-INDX > 1500 OR                            
                    WS-ACCOUNT-NO-AU (WS-AU-DET-INDX) = 0               
                     IF WS-ACCOUNT-NO-AR (WS-AR-TRN-INDX) =             
                        WS-ACCOUNT-NO-AU (WS-AU-DET-INDX) AND           
                        WS-TRANS-HIST-SEQ-NO-AR (WS-AR-TRN-INDX) =      
                        WS-TRANS-HIST-SEQ-NO-AU (WS-AU-DET-INDX) AND    
                        WS-CNT-ITEM-ID-CT (WS-CNT-INDX) =               
                        WS-ITEM-ID-AU(WS-AU-DET-INDX) AND               
                        WS-CODE-CONTRACT-TYPE-CT(WS-CNT-INDX)=          
                        WS-CODE-CONTRACT-TYPE-AU(WS-AU-DET-INDX) AND    
                   ((WS-GL-ACCT-CREDIT-AU(WS-AU-DET-INDX) = 142.0900 AND
                     WS-GL-ACCT-DEBIT-AU(WS-AU-DET-INDX)  = 184.2201) OR
                    (WS-GL-ACCT-CREDIT-AU(WS-AU-DET-INDX) = 184.2201 AND
                     WS-GL-ACCT-DEBIT-AU(WS-AU-DET-INDX)  = 142.0900))  
A02003                 MOVE 145 TO WS-AUD-SUB                           
A02003                 PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT     
                     END-IF                                             
                    END-PERFORM                                         
                  END-IF                                                
                END-PERFORM                                             
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
       3650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** Audit accounts that have dropped from a fixed rate to a    **          
      ** variable rate                                              **          
      ****************************************************************          
       3680-SEB-RATE-DROP.                                              
      *                                                                         
           SET WS-AR-TRN-INDX TO 1.                                     
           SEARCH WS-TRANS-HIST-DATA-AR                                 
               AT END                                                   
                  GO TO 3680-EXIT                                       
              WHEN (WS-ACCOUNT-NO-AT =                                  
                    WS-ACCOUNT-NO-AR (WS-AR-TRN-INDX) AND               
                    WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX) =            
                       'PCSCA099E' OR 'PCSCA099L' OR 'PCSCA099M' OR     
                       'PCSCA099F' OR 'PCSCA099P' OR 'PCSCA099Q' OR     
                       'PCSCA99A1' OR 'PCSCA99D1' OR 'PCSCA99B1' OR     
                       'PCSCA099U' OR 'PCSCA099V' OR 'PCSCA099W' OR     
                       'PCSCA99C1' OR 'PCSCA099T' OR 'PCSCA099Y' OR     
                       'PCSCA099Z')                                     
                       PERFORM 3685-SET-RATE-DROP THRU 3685-EXIT        
           END-SEARCH.                                                  
      *                                                                         
       3680-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       3685-SET-RATE-DROP.                                              
      *                                                                         
           EVALUATE WS-APPL-PROGRAM-ID-AR (WS-AR-TRN-INDX)              
               WHEN 'PCSCA099E'                                         
A02003           MOVE 147 TO WS-AUD-SUB                                 
               WHEN 'PCSCA099L'                                         
A02003           MOVE 149 TO WS-AUD-SUB                                 
               WHEN 'PCSCA099P'                                         
A02003           MOVE 151 TO WS-AUD-SUB                                 
               WHEN 'PCSCA099Q'                                         
A02003           MOVE 152 TO WS-AUD-SUB                                 
               WHEN 'PCSCA099T'                                         
A02003           MOVE 161 TO WS-AUD-SUB                                 
               WHEN 'PCSCA099W'                                         
A02003           MOVE 157 TO WS-AUD-SUB                                 
               WHEN 'PCSCA099V'                                         
A02003           MOVE 159 TO WS-AUD-SUB                                 
               WHEN 'PCSCA099Y'                                         
A02003           MOVE 162 TO WS-AUD-SUB                                 
               WHEN 'PCSCA99A1'                                         
A02003           MOVE 163 TO WS-AUD-SUB                                 
               WHEN 'PCSCA99B1'                                         
A02003           MOVE 165 TO WS-AUD-SUB                                 
               WHEN 'PCSCA99C1'                                         
A02003           MOVE 160 TO WS-AUD-SUB                                 
               WHEN 'PCSCA99D1'                                         
A02003           MOVE 164 TO WS-AUD-SUB                                 
           END-EVALUATE.                                                
A02003     PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT.                
      *                                                                         
       3685-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A03019 3700-AGL-SR-DISCOUNT.                                            
A03019*                                                                         
A03019     IF WS-CA195-SENIOR-RATE-SW = 'Y'                             
A03019         MOVE 30 TO WS-AUD-SUB                                    
A03019         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
A03019     END-IF.                                                      
A03019*                                                                         
A03019 3700-EXIT.                                                       
A03019     EXIT.                                                        
A03019*                                                                         
P805CS 3725-CSC-DISCOUNTS.                                              
P805CS*                                                                         
P805CS     MOVE 'N' TO WS-PAPERLESS-FLAG                                
P805CS                 WS-AUTO-RENEW-FLAG.                              
P805CS     MOVE 1 TO SUB1.                                              
P805CS     PERFORM UNTIL SUB1 > 100 OR WS-ACCOUNT-NO-BA (SUB1) = ZEROES 
P805CS         EVALUATE WS-FACTOR-ID-BA (SUB1)                          
P805CS           WHEN 'CSCPLDSC'                                        
P805CS             MOVE 'Y' TO WS-PAPERLESS-FLAG                        
P805CS           WHEN 'CSCARDSC'                                        
P805CS             MOVE 'Y' TO WS-AUTO-RENEW-FLAG                       
P805CS         END-EVALUATE                                             
P805CS         ADD 1 TO SUB1                                            
P805CS     END-PERFORM.                                                 
P805CS     IF WS-AUTO-RENEW-FLAG = 'Y'                                  
P805CS        IF WS-PAPERLESS-FLAG = 'Y'                                
P805CS           MOVE 84 TO WS-AUD-SUB                                  
P805CS        ELSE                                                      
P805CS           MOVE 82 TO WS-AUD-SUB                                  
P805CS        END-IF                                                    
P805CS     ELSE                                                         
P805CS        IF WS-PAPERLESS-FLAG = 'Y'                                
P805CS           MOVE 81 TO WS-AUD-SUB                                  
P805CS        END-IF                                                    
P805CS     END-IF.                                                      
P805CS     PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT.                
P805CS*                                                                         
P805CS 3725-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
      *                                                                 32080000
P00453****************************************************************          
P00453** Prepay audit criteria:                                     **          
P00453** 1st bill                WS-AUD-SUB = 192                   **          
P00453** 2nd bill                             193                   **          
P00453** Arrears                              195                   **          
P00453** No arrears                           194                   **          
P00453** CIA                                  196                   **          
P00453** Negative Trans Balance               197                   **          
P00453****************************************************************          
P00453 3800-PREPAY.                                                     
P00453     IF WS-LAST-NRML-BILL-NO-AT = 1                               
P00453        MOVE 192 TO WS-AUD-SUB                                    
P00453        PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT              
P00453     END-IF.                                                      
P00453                                                                  
P00453     IF WS-LAST-NRML-BILL-NO-AT = 2                               
P00453        MOVE 193 TO WS-AUD-SUB                                    
P00453        PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT              
P00453     END-IF.                                                      
P00453                                                                  
P00453     IF WS-TOTAL-ARREARS-BI > 0.00                                
P00453        MOVE 195 TO WS-AUD-SUB                                    
P00453        PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT              
P00453     END-IF.                                                      
P00453                                                                  
P00453     MOVE  1                       TO WS-AC-SUB.                  
P00453     MOVE 'N'                      TO WS-OTHER-ARREARS-SW.        
P00453     PERFORM 1505-CHECK-OTHER-ARREARS   THRU 1505-EXIT.           
P00453                                                                  
P00453     IF WS-AMT-AR-DAY-30-AC (SUB1) = 0.00 AND                     
P00453        WS-AMT-AR-DAY-60-AC (SUB1) = 0.00 AND                     
P00453        WS-AMT-AR-DAY-90-AC (SUB1) = 0.00 AND                     
P00453        WS-OTHER-ARREARS-SW = 'N'                                 
P00453            MOVE 194 TO WS-AUD-SUB                                
P00453            PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT          
P00453     END-IF.                                                      
P00453                                                                  
P00453     IF WS-AMT-TRAN-BALANCE-AC (SUB1) < ZERO                      
P00453         MOVE 197 TO WS-AUD-SUB                                   
P00453         PERFORM 1065-CHECK-AUDIT-COND THRU 1065-EXIT             
P00453     END-IF.                                                      
P00453 3800-EXIT.                                                       
P00453      EXIT.                                                       
                                                                        
       8000-BUDGET-HIST.                                                
      *                                                                         
           EXEC SQL                                                     
               OPEN EPP_DET_CR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
               MOVE 'BH'                       TO WS-DB2-TABLE-ID       
               MOVE 'OPEN  '                   TO WS-DB2-FUNCTION       
               MOVE SQLCODE                    TO WS-DB2-RETURN-CODE    
               MOVE '168'                      TO WS-DB2-MODULE-ID      
               MOVE '0100'                     TO WS-DB2-PARAGRAPH      
               MOVE 12                         TO RETURN-CODE           
               PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT                
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               FETCH EPP_DET_CR                                         
                INTO :BH-EPP-MTHS-RMNG-QT                               
                    ,:BH-BUD-HIST-SEQ-NO                                
                    ,:BH-REMARKS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE 'BH'                       TO WS-DB2-TABLE-ID       
               MOVE 'FETCH '                   TO WS-DB2-FUNCTION       
               MOVE SQLCODE                    TO WS-DB2-RETURN-CODE    
               MOVE '168'                      TO WS-DB2-MODULE-ID      
               MOVE '0100'                     TO WS-DB2-PARAGRAPH      
               MOVE 12                         TO RETURN-CODE           
               PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT                
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               CLOSE EPP_DET_CR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
               MOVE 'BH'                       TO WS-DB2-TABLE-ID       
               MOVE 'CLOSE '                   TO WS-DB2-FUNCTION       
               MOVE SQLCODE                    TO WS-DB2-RETURN-CODE    
               MOVE '168'                      TO WS-DB2-MODULE-ID      
               MOVE '0100'                     TO WS-DB2-PARAGRAPH      
               MOVE 12                         TO RETURN-CODE           
               PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT                
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9900-ABEND.                                                      
      *                                                                         
           PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT.                   
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9900-SQL-ERROR.                                                  
      *                                                                         
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              MOVE 'Y' TO WS-WQ-CREATED-SW                              
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM
           END-IF.                   
                                                                        
           MOVE WS-DATABASE-EXCEPTION                                   
             TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)           
                                                                        
           COMPUTE WS-START-POS                                         
             = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1                 
           MOVE WS-SQL-ERROR-TXT-WQ                                     
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)   
           ADD WS-SQL-ERROR-TXT-LEN-WQ                                  
             TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                   
ACT074     MOVE PROGRAM-NAME                                            
ACT074       TO WS-CREATED-BY-WF(WS-BILL-WQ-INDX).                      
                                                                        
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
      *                                                                         
       9900-SQL-EXIT.                                                   
           EXIT.                                                        
      *                                                                         
       9910-MISC-ERROR.                                                 
      *                                                                         
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              MOVE 'Y' TO WS-WQ-CREATED-SW                              
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
ACT074        MOVE PROGRAM-NAME                                         
ACT074          TO WS-CREATED-BY-WF(WS-BILL-WQ-INDX)                    
           END-IF.                                                      
      *                                                                         
       9910-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9999-BAIL-OUT.                                                   
      *                                                                         
           MOVE RETURN-CODE TO WS-SCSCA-RETURN-CODE.                    
           EXIT PROGRAM.                                                
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
