       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA186.                                        
      ***************************************************************** 00030000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00040000
      **                     PRICE WATERHOUSE                        ** 00050000
      **                                                             ** 00060000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00070000
      **                                                             ** 00080000
      ***************************************************************** 00090000
      **               P R O G R A M  S U M M A R Y                  ** 00100000
      **                                                             ** 00110000
      **  THIS PROGRAM IS A SUB-ROUTINE CALLED FROM THE BILL PRINT   ** 00120000
      **  EXTRACT DRIVER.  IT OBTAINS MISCELLANEOUS DATA WHICH WILL  ** 00130000
      **  PRINT ON THE BILLS.                                        ** 00140000
      ***************************************************************** 00250000
      *                                                              ** 00260000
      *              PROGRAM  MODIFICATION  LOG                      ** 00270000
      *                                                              ** 00280000
      *    DATE     INITIALS  REASON                                 ** 00290000
      *    ----     --------  ------                                 ** 00300000
      **04/24/08    PA94870   INITIAL VERSION                        **         
T35152**10/02/08    RV97439   ADDED NEW TABLE TO LINKAGE SECTION     **         
I00177**01/28/09    RV97439   REPLACE INDEX HARD CODING FOR          **         
I00177**                      CREDIT COLLECTIONS, CONTRACT DATA AND  **         
I00177**                      AR CONTROL TABLES.                     **         
A00984**07/20/09    RAJ       POPULATE BUDGET BILLING OPTION2 DUE    **         
A00984**                      DATE WHEN TOTAL BILL DUE DATE IS NOT   **         
A00984**                      AVAILBALE FOR THE CUSTOMER             **         
A02240**04/01/10    LG41184   FIX FOR DRAFT-DATE CALCULATION DURING  **         
A02240**                      CANCEL/REBILL IMMEDIATE.               **         
P00399**11/18/10    DMS       REMOVE BALANCE CRED GRP FOR SCEG       **         
A03019**01/10/11    SV ACT-3  REMOVE OBSOLETE PROCESSING FROM SCSCA186*         
A03019**01/11/11    SV ACT-5  DUMP RATE CREATOR                      **         
A03166**07/12/11    RB19957 1)ADD FB DRAFT DATE REQUIREMENT - IF FB  **         
A03166**          RICK BLACK  DRAFT DATE BASED ON NACHA RULE OF 5    **         
A03166**                      BUSINESS DAYS IS LESS THAN THE PENDING **         
A03166**                      DRAFT DATE USE THE EXISTING PENDING    **         
A03166**                      DRAFT DATE.                            **         
A03166**                    2)ADD FEW PERFORMANCE CHANGES            **         
A03166**10/11/11    RB19957 1)CHANGED THE PENDING BANK DRAFT SELECTS **         
A03166**          RICK BLACK  TO SELECT CODE SOURCE ID OF ONLY 'I'   **         
A03166**                      AND 'S'.                               **         
A03166**                    2)ADDED FETCH FIRST ROW ONLY TO PREVENT  **         
A03166**                      SQL CODE FROM GETTING A -811.          **         
A03733**02/28/12    SV        FINAL BILL,BANK DREAFT PROCESS CLEANUP **         
P00599**04/24/12    DMS       CREDIT SIMPLIFICATION PRJ              **         
ACT003**06/16/14    DMS       A04897-REMOVE WS-CURRENT-CHGS-DUE-DATE **         
ACT071**05/07/15    SS7F226   ADD CREATED-BY FIELD IN WF AREA.       **         
ACT071*             A04860                                           **         
I01959**  08/31/15  SV95326   RATE PLAN AND DESCRIPTION GETS FROM    **         
I01959**                      BILL_LITERAL_TX FROM CSS_RATE_PLAN_DESC**         
I01959**                      TABLE.                                 **         
P01175**  08/18/16  SV95326   SOLAR RENEWABLE CHANGES.               **         
      ****END********************************************************** 02030000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
      ***************************************************************** 02070000
      **    WORKING STORAGE SECTION                                   * 02080000
      ***************************************************************** 02090000
      *                                                                 02100000
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-RATE-DESC  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-RATE-CREATOR  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA186'.
MSQ017     COPY MFASQLM.
       01  WS-START                 PIC X(40)                           
           VALUE 'WORKING STORAGE FOR SCSCA186 STARTS HERE'.            
       01  WS-MISC.                                                     
           05  WS-NULL-INDICATORS.                                      
               10  WS-NULL-IND-2       PIC S9(4) COMP.                  
               10  WS-NULL-IND-4       PIC S9(4) COMP.                  
               10  WS-NULL-IND-5       PIC S9(4) COMP.                  
               10  WS-NULL-IND-8       PIC S9(4) COMP.                  
           05  WS-COUNTERS.                                             
               10  WS-SLIDE-CTR-1      PIC 9.                           
               10  WS-SLIDE-CTR-2      PIC 9.                           
           05  WS-DISPLAY-ACCOUNT      PIC Z(13).                       
           05  WS-TABLE-SUB            PIC S9(3).                       
           05  WS-COMPANY-NO-E8        PIC X(02).                       
           05  WS-BG-SUB               PIC 9(2) VALUE 0.                
           05  WS-HOLD-RATE-PLAN       PIC X(3) VALUE SPACES.           
               88  PPP-RATE            VALUE '190' '191' '289' '290'.   
           05  WS-PREFERRED-SW         PIC X(1) VALUE SPACES.           
               88  PREFERRED-RATE      VALUE 'P'.                       
COB305     05 WS-ACCOUNT-NO-SEARCH        PIC S9(13) COMP-3 VALUE 0.            
           05  WS-SEARCH-DATE          PIC  X(10).                      
           05  WS-BILL-NO-SEARCH       PIC S9(09) COMP.                 
           05  WS-HOLD-CYCLE           PIC XX.                          
           05  WS-HOLD-CYCLE-NUM REDEFINES WS-HOLD-CYCLE PIC 99.        
           05  WS-NO-PRIOR-DRAFT       PIC X VALUE 'N'.                 
           05  WS-DRAFT-OPEN           PIC X(10).                       
           05  WS-NEXT-BILL-OPEN       PIC X(10).                       
           05  WS-HOLD-BILL-CYCLE      PIC 99.                          
           05  WS-HOLD-DRAFT-CYCLE     PIC XX.                          
           05  WS-HOLD-DRAFT-CYCLE-NUM                                  
                             REDEFINES WS-HOLD-DRAFT-CYCLE PIC 99.      
           05  WS-DRAFT-CYCLE          PIC XX.                          
           05  WS-DRAFT-CYCLE-NUM REDEFINES WS-DRAFT-CYCLE PIC 99.      
           05  WS-DRAFT-AMOUNT         PIC S9(09)V99 COMP-3 VALUE 0.    
A03166     05  WS-DRAFT-EXST-DT        PIC X(10).                       
A03166     05  WS-DRAFT-FB-DT          PIC X(10).                       
A02240     05  WS-FB-DRAFT-FIELDS.                                      
               10  WS-FB-HOLD-DATE      PIC X(10).                      
               10  WS-FB-NO-DAYS        PIC 9.                          
               10  WS-FB-DAY-COUNT      PIC 9 COMP.                     
               10  WS-FB-DAY            PIC S9(4) COMP.                 
               10  WS-FB-HOLIDAY-EXISTS PIC X.                          
           05  WS-REVENUE-MONTH        PIC 9(6).                        
           05  WS-REVENUE-MONTH-R REDEFINES WS-REVENUE-MONTH.           
               10  WS-REVENUE-CCYY     PIC 9(4).                        
               10  WS-REVENUE-MM       PIC 99.                          
           05  WS-LAST-REV-MO-THIS-YR  PIC 9(6).                        
           05  WS-THIS-REV-MO-LAST-YR  PIC 9(6).                        
           05  WS-LAST-REV-MO-LAST-YR  PIC 9(6).                        
           05  WS-NEXT-REV-MO          PIC 9(6).                        
           05  WS-ARREARS-FOUND        PIC X.                           
           05  WS-BBF-DATE-FOUND       PIC X.                           
           05  WS-B-FOUND              PIC X.                           
           05  WS-RATE-PLAN-NO         PIC X(3).                        
               88  ITRON-OR-MV90-PLAN  VALUES '009', '020'.             
           05  WS-MTR-READ-SOURCE-CD   PIC X.                           
               88  MV90-METER          VALUE 'M'.                       
           05  WS-START-POS                PIC S9(4) COMP.              
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  FILLER                  PIC S9(4) COMP VALUE +121.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  WS-MISC-MSG-LEN         PIC S9(4) COMP VALUE +250.   
               10  WS-MISC-MSG-TEXT        PIC X(100).                  
           05  RS-RETURN-CODE              PIC S9(04)  COMP.            
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
           05  PROGRAM-NAME                PIC X(08) VALUE 'SCSCA165'.  
ACT071     05  WS-PGRMNAME                 PIC X(08) VALUE 'SCSCA186'.  
           05  WS-CANCEL-ONLY              PIC X(01) VALUE SPACES.      
           05  WS-REBILL-FLAG              PIC X(01) VALUE SPACES.      
           05  WS-ONCYCLE-FLAG             PIC X(01) VALUE SPACES.      
           05  WS-FUTURE-FLAG              PIC X(01) VALUE SPACES.      
           05  WS-REBILL-MULTI-FLAG        PIC X(01) VALUE SPACES.      
               88 REBILL-MULTI             VALUE 'Y'.                   
           05 WS-PREV-DATE-ORIG            PIC X(10) VALUE SPACES.      
           05 WS-MAX-DATE-ORIG             PIC X(10) VALUE SPACES.      
A00984     05 WS-YEAR-DIFF-EPP             PIC S9(7) VALUE 0.           
A00984     05 WS-EPP-ANNIV-DATE.                                        
A00984         10  WS-EPP-ANNIV-YEAR        PIC 9(4)    VALUE ZERO.     
A00984         10  WS-EPP-ANNIV-MO          PIC 9(2)    VALUE ZERO.     
I01959     05 WS-RD-BILL-LITERAL.                                       
I01959         10 WS-RD-BILL-LITERAL-LEN    PIC S9(4) USAGE COMP.       
I01959         10 WS-RD-BILL-LITERAL-TXT    PIC X(50).                  
       01  WS-BKDFT-SUB                    PIC S9(3) VALUE ZERO.        
                                                                        
       01 WS-MISC-IDX                   PIC 9(09) COMP-3 VALUE 0.       
       01 WS-ADJ-SUB                    PIC 9(04) COMP-3 VALUE 0.       
       01 WS-ROW-COUNT                  PIC S9(09) USAGE COMP VALUE 0.  
       01 WS-RD-RATE-DESCHV.                                            
          05 WS-RD-RATE-DESC-HV            PIC X(50) OCCURS 100 TIMES.  
          05 WS-RD-BILL-LITERAL-TX-HV      PIC X(50) OCCURS 100 TIMES.  
       01 WS-RD-SECURED-RATE-FLHV.                                      
          05 WS-RD-SECURED-RATE-FL-HV      PIC X(01) OCCURS 100 TIMES.  
       01 WS-RD-RATE-PLAN-NOHV.                                         
          05 WS-RD-RATE-PLAN-NO-HV         PIC X(03) OCCURS 100 TIMES.  
       01 WS-RD-CODE-UTIL-TYPEHV.                                       
          05 WS-RD-CODE-UTIL-TYPE-HV       PIC X(01) OCCURS 100 TIMES.  
       01 WS-RD-COMPANY-NOHV.                                           
          05 WS-RD-COMPANY-NO-HV           PIC X(02) OCCURS 100 TIMES.  
A03019 01 WS-RD-BILL-FORMAT-RT.                                         
A03019    05 WS-RD-BILL-FORMAT-CD-RT       PIC X(02) OCCURS 100 TIMES.  
A03019 01 WS-RD-CODE-UTIL-TYPERT.                                       
A03019    05 WS-RD-CODE-UTIL-TYPE-RT       PIC X(01) OCCURS 100 TIMES.  
A03019 01 WS-RD-RATE-PLAN-NORT.                                         
A03019    05 WS-RD-RATE-PLAN-NO-RT         PIC X(03) OCCURS 100 TIMES.  
P01175 01 WS-RD-RATE-SUB-GRP-TYPE-RT.                                   
P01175    05 WS-RD-RATE-SUB-GRP-TYPE-HV    PIC X(01) OCCURS 100 TIMES.  
                                                                        
      *   REDUCE EMBEDDED BLANKS                                        03720000
                                                                        
       COPY CWS00011.                                                   03740000
                                                                        
      *   SUPPLEMENTAL WQ TEXT                                          03760000
                                                                        
       COPY CWS0070B.                                                   03780000
                                                                        
      *   COUNT INSTSCEG-HIGHMENTS                                      03800000
                                                                        
       COPY CWS00311.                                                   03820000
                                                                        
      *   MAILING NAME/ADDRESS COPYBOOK                                 03840000
                                                                        
           EXEC SQL                                                     03860000
               INCLUDE CWS00074                                         03870000
           END-EXEC.                                                    03880000
                                                                        
      *   DB2/SQL ERROR CHECKING                                        03900000
                                                                        
       COPY CWS00303.                                                   03920000
                                                                        
      *   ABEND SWITCH                                                  03940000
                                                                        
       COPY CWS09900.                                                   03960000
                                                                        
      *   DB2 ABEND VARIABLES                                           03980000
                                                                        
       COPY CWS00010.                                                   04000000
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR SCSCA186 ENDS HERE  '.            
                                                                        
      ***************************************************************** 04050000
      *     INCLUDE DCLGEN TABLES                                       04060000
      ***************************************************************** 04070000
                                                                        
            EXEC SQL                                                    04090000
                 INCLUDE SQLCA                                          04100000
            END-EXEC.                                                   04110000
                                                                        
      *  RATE DESCRIPTION TABLE - RD                                    04310000
                                                                        
            EXEC SQL                                                    04330000
                 INCLUDE TBRTDESC                                       04340000
            END-EXEC.                                                   04350000
                                                                        
      *  CONTRACT INFO TABLE - K6                                       04370000
                                                                        
            EXEC SQL                                                    04390000
                 INCLUDE TBCNTINF                                       04400000
            END-EXEC.                                                   04410000
                                                                        
      *  READ WINDOW TABLE - RW                                         04430000
                                                                        
            EXEC SQL                                                    04450000
                 INCLUDE TBRDWNDW                                       04460000
            END-EXEC.                                                   04470000
                                                                        
      *  BILL WINDOW TABLE - BN                                         04490000
                                                                        
            EXEC SQL                                                    04510000
                 INCLUDE TBBILWDW                                       04520000
            END-EXEC.                                                   04530000
                                                                        
      *  PENDING BANK DRAFT TABLE - PB                                  04550000
                                                                        
            EXEC SQL                                                    04570000
                 INCLUDE TBPDBKDF                                       04580000
            END-EXEC.                                                   04590000
                                                                        
      *  BANK EFT TABLE - BE                                            04610000
                                                                        
            EXEC SQL                                                    04630000
                 INCLUDE TBBNKEFT                                       04640000
            END-EXEC.                                                   04650000
                                                                        
      *  BANK TABLE - D1                                                04730000
                                                                        
            EXEC SQL                                                    04750000
                 INCLUDE TBBANK                                         04760000
            END-EXEC.                                                   04770000
                                                                        
      *  MISC. ACCOUNT TABLE - TA                                       04970000
                                                                        
            EXEC SQL                                                    04990000
                 INCLUDE TBATMISC                                       05000000
            END-EXEC.                                                   05010000
                                                                        
      *  RATE CREATOR TABLE - RT                                        05250000
                                                                        
            EXEC SQL                                                    05270000
                 INCLUDE TBRTCRTR                                       05280000
            END-EXEC.                                                   05290000
                                                                        
      *  HOLIDAY TABLE - J8                                             05610000
                                                                        
            EXEC SQL                                                    05630000
                 INCLUDE TBHLDAY                                        05640000
            END-EXEC.                                                   05650000
                                                                        
      *  CSS_DELINQUENCY TABLE - C8                                     05610000
                                                                        
            EXEC SQL                                                    05630000
                 INCLUDE TBDELQ                                         05640000
            END-EXEC.                                                   05650000
                                                                        
      ***************************************************************** 05670000
      *         CURSOR DECLARATIONS                                   * 05680000
      ***************************************************************** 05690000
                                                                        
           EXEC SQL                                                     
                DECLARE CALC_SLIDE_CSR CURSOR FOR                       
                 SELECT DATE_EXTRACT                                    
                   FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                   
                  WHERE BILL_CYCLE    = :WS-HOLD-CYCLE                  
                    AND REVENUE_MONTH = :BN-REVENUE-MONTH               
                  ORDER BY DATE_EXTRACT                                 
A03166             FOR READ ONLY                                
A03166                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05710000
MFA-TR*         DECLARE CALC_SLIDE_CSR CURSOR FOR                       05720000
MFA-TR*          SELECT DATE_EXTRACT                                    05730000
MFA-TR*            FROM CSS_BILL_WINDOW                                 05740000
MFA-TR*           WHERE BILL_CYCLE    = :WS-HOLD-CYCLE                  05750000
MFA-TR*             AND REVENUE_MONTH = :BN-REVENUE-MONTH               05760000
MFA-TR*           ORDER BY DATE_EXTRACT                                 05770000
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 0752                                                 
MFA-TR*    END-EXEC.                                                    05780000
                                                                        
           EXEC SQL                                                     
A03019          DECLARE RATE_CREATOR CURSOR WITH ROWSET POSITIONING FOR 
                SELECT RT.BILL_FORMAT_CD,                               
A03019                 RT.CODE_UTIL_TYPE,                               
A03019                 RT.RATE_PLAN_NO                                  
A03019            FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                
A03019           WHERE RT.CODE_STATUS      = 'A'                        
A03019             AND RT.VERSION_NO_CNTRL =                            
A03019                (SELECT MAX(R1.VERSION_NO_CNTRL)                  
A03019                   FROM CSS_RATE_CREATOR R1 WITH(READUNCOMMITTED)         
A03019                  WHERE RT.CODE_UTIL_TYPE  = R1.CODE_UTIL_TYPE    
A03019                    AND RT.RATE_PLAN_NO    = R1.RATE_PLAN_NO      
A03019                    AND RT.CODE_STATUS     = R1.CODE_STATUS)      
A03019             ORDER BY RATE_PLAN_NO                                
A03166             FOR READ ONLY                                
A03166                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06750000
MFA-TR*         DECLARE RATE_CREATOR CURSOR WITH ROWSET POSITIONING FOR 06760000
MFA-TR*         SELECT RT.BILL_FORMAT_CD,                               06770000
MFA-TR*                RT.CODE_UTIL_TYPE,                                       
MFA-TR*                RT.RATE_PLAN_NO                                          
MFA-TR*           FROM CSS_RATE_CREATOR RT                                      
MFA-TR*          WHERE RT.CODE_STATUS      = 'A'                                
MFA-TR*            AND RT.VERSION_NO_CNTRL =                                    
MFA-TR*               (SELECT MAX(R1.VERSION_NO_CNTRL)                          
MFA-TR*                  FROM CSS_RATE_CREATOR R1                               
MFA-TR*                 WHERE RT.CODE_UTIL_TYPE  = R1.CODE_UTIL_TYPE            
MFA-TR*                   AND RT.RATE_PLAN_NO    = R1.RATE_PLAN_NO              
MFA-TR*                   AND RT.CODE_STATUS     = R1.CODE_STATUS)              
MFA-TR*            ORDER BY RATE_PLAN_NO                                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 0410                                                 
MFA-TR*    END-EXEC.                                                    06830000
                                                                        
           EXEC SQL                                                     
                DECLARE PNDNG_DFT CURSOR FOR                            
                SELECT ACCOUNT_NO                                       
                      ,DRAFT_DATE                                       
                      ,DRAFT_AMT                                        
                      ,TRANSACTION_CD                                   
                      ,CODE_SOURCE_ID                                   
                      ,CUST_BANK_SEQ_NO                                 
                FROM CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                       
      * CODE SOURCE ID CHECK IS COMMENTED FOR E-DRAFTS                  07060000
      *           AND CODE_SOURCE_ID = 'S'                              07070000
A03166             FOR READ ONLY                                
A03166                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06960000
MFA-TR*         DECLARE PNDNG_DFT CURSOR FOR                            06970000
MFA-TR*         SELECT ACCOUNT_NO                                       06980000
MFA-TR*               ,DRAFT_DATE                                       06990000
MFA-TR*               ,DRAFT_AMT                                        07000000
MFA-TR*               ,TRANSACTION_CD                                   07010000
MFA-TR*               ,CODE_SOURCE_ID                                   07020000
MFA-TR*               ,CUST_BANK_SEQ_NO                                 07030000
MFA-TR*         FROM CSS_PNDNG_BNK_DRFT                                 07040000
MFA-TR*         WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                       07050000
MFA-TR* CODE SOURCE ID CHECK IS COMMENTED FOR E-DRAFTS                  07060000
MFA-TR*           AND CODE_SOURCE_ID = 'S'                              07070000
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 0790                                                 
MFA-TR*    END-EXEC.                                                    07080000
                                                                        
           EXEC SQL                                                     
               DECLARE RATE_DESC CURSOR WITH ROWSET POSITIONING FOR     
               SELECT RATE_DESC,                                        
                      SECURED_RATE_FL,                                  
                      RATE_PLAN_NO,                                     
                      CODE_UTIL_TYPE,                                   
                      COMPANY_NO,                                       
I01959                BILL_LITERAL_TX,                                  
P01175                RATE_SUB_GRP_TYPE                                 
                 FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                  
A03166             FOR READ ONLY                                
A03166                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00062700
MFA-TR*        DECLARE RATE_DESC CURSOR WITH ROWSET POSITIONING FOR     00062800
MFA-TR*        SELECT RATE_DESC,                                        00062900
MFA-TR*               SECURED_RATE_FL,                                  00063000
MFA-TR*               RATE_PLAN_NO,                                     00063000
MFA-TR*               CODE_UTIL_TYPE,                                   00063000
MFA-TR*               COMPANY_NO,                                       00063000
MFA-TR*               BILL_LITERAL_TX,                                          
MFA-TR*               RATE_SUB_GRP_TYPE                                         
MFA-TR*          FROM CSS_RATE_PLAN_DESC                                00063100
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 0575                                                 
MFA-TR*    END-EXEC.                                                    00063300
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       COPY CWS1000B.                                                   07130000
       COPY CWS1001A.                                                   07140000
       COPY CWS1001B.                                                   07150000
       COPY CWS10009.                                                   07160000
P00599 COPY CWS1000K.                                                           
       COPY CWS0024B.                                                   07170000
       01  WS-INPUT-DATE        PIC X(10).                              
       01  WS-SCSCA-RETURN-CODE PIC S9(4) COMP.                         
       01  WS-PNDNG-BANK-DRAFT.                                         
         02  WS-PNDNG-BANK-DRAFT-DATA OCCURS 30 TIMES.                  
COB305     05 WS-PNDNG-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.      
           05 WS-PNDNG-DRAFT-DATE          PIC  X(10).                  
COB305     05 WS-PNDNG-DRAFT-AMT        PIC S9(09)V9(2) COMP-3 VALUE 0.      
COB305     05 WS-PNDNG-TRANSACTION-CD        PIC S9(04) COMP-3 VALUE 0.      
COB305     05 WS-PNDNG-BANK-SEQ-NO        PIC S9(09) COMP-3 VALUE 0.      
           05 WS-PNDNG-CODE-SOURCE-ID      PIC  X(01).                  
           05 WS-PNDNG-INS-DEL-FLAG        PIC  X(01).                  
       01  WS-PNDNG-BANK-DRAFT-FLAG PIC  X(01).                         
       01 WS-RATE-DESCRIPTION-TABLE.                                    
           05  WS-RD-RATE-LINE   OCCURS 2000 TIMES                      
                              INDEXED BY WS-RATE-DESC-INDX.             
               10  WS-RD-RATE-DESC           PIC X(50).                 
               10  WS-RD-SECURED-RATE-FL     PIC X(01).                 
               10  WS-RD-RATE-PLAN-NO        PIC X(03).                 
               10  WS-RD-CODE-UTIL-TYPE      PIC X(01).                 
               10  WS-RD-COMPANY-NO          PIC X(02).                 
I01959         10  WS-RD-BILL-LITERAL-TX     PIC X(50).                 
P01175         10  WS-RD-RATE-SUB-GRP-TYPE   PIC X(01).                 
       01  WS-RATE-DESC-FLAG    PIC X(01).                              
                                                                        
A03019 01 WS-BILL-FORMAT-TABLE.                                         
A03019     05  WS-RT-BILL-FORMAT-LINE OCCURS 1500 TIMES                 
A03019                        INDEXED BY WS-BILL-FRMT-INDX.             
A03019         10  WS-RT-BILL-FORMAT-CD      PIC X(02).                 
A03019         10  WS-RT-CODE-UTIL-TYPE      PIC X(01).                 
A03019         10  WS-RT-RATE-PLAN-NO        PIC X(03).                 
A03019 01  WS-BILL-FRMT-FLAG                 PIC X(01).                 
                                                                        
       01  WS-BILLING-WQ-ITEMS-WF.                                      
           05  WS-BILLING-WQ-ITEMS-DATA-WF                              
                   OCCURS 50 TIMES INDEXED BY WS-BILL-WQ-INDX.          
               10  WS-CATEGORY-ID-WF               PIC S9(04)  COMP.    
               10  WS-PRIORITY-WF                  PIC X(1).            
               10  WS-ROUTE-CATEGORY-WF            PIC X(01).           
               10  WS-COMMENTS-WF.                                      
                   15  WS-COMMENTS-LEN-WF          PIC S9(04)  COMP.    
                   15  WS-COMMENTS-TEXT-WF         PIC X(250).          
ACT071         10  WS-CREATED-BY-WF                PIC X(16).           
ACT071         10  FILLER                          PIC X(228).          
      *                                                                         
       PROCEDURE DIVISION USING                                         
                                WS-CUSTOMER-CU                          
                                WS-ACCOUNT-AT                           
                                WS-BANK-EFT-BE                          
                                WS-CRED-COLL-CL                         
                                WS-BILLING-BI                           
                                WS-BILLING-BG                           
                                WS-AR-CNTRL-AC                          
                                WS-CONTRACT-CT                          
                                WS-MTRD-ENVRNMT-TABLE-MN                
                                WS-BILLING-WQ-ITEMS-WF                  
                                WS-MISC-BILL-INFO                       
                                WS-PREV-BILL-INFO                       
                                LS-PCSCA100-COMM-AREA                   
                                WS-SCSCA-RETURN-CODE                    
                                WS-PNDNG-BANK-DRAFT                     
                                WS-PNDNG-BANK-DRAFT-FLAG                
                                WS-BUDGET-PLAN-BU                       
                                WS-RATE-DESCRIPTION-TABLE               
                                WS-RATE-DESC-FLAG                       
A03019                          WS-BILL-FORMAT-TABLE                    
A03019                          WS-BILL-FRMT-FLAG                       
T35152                          WS-CNSMPTN-HIST-CX                      
I00177                          WS-UTILITY-TABLE-UT                     
P00599                          WS-CWS1000B-MAX-TBL-LIMITS              
P00599                          WS-BILL-CRED-DET-1H.                    
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           DISPLAY 'SCSCA186 - MISCELLANEOUS DATA'.                     
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
A02240     INITIALIZE WS-FB-DRAFT-FIELDS.                               
                                                                        
           PERFORM 0110-CHECK-FUTURE   THRU 0110-EXIT.                  
           INITIALIZE WS-HOLD-RATE-PLAN                                 
                      WS-PREFERRED-SW.                                  
           MOVE +1 TO SUB1                                              
                      WS-BG-SUB.                                        
           IF SEB-DATABASE                                              
               PERFORM UNTIL WS-BG-SUB > 30 OR                          
                             WS-ACCOUNT-NO-BG (WS-BG-SUB) = ZEROES      
                   MOVE WS-RATE-PLAN-NO-BG (WS-BG-SUB) TO               
                        WS-HOLD-RATE-PLAN                               
                   IF PPP-RATE                                          
                       SET PREFERRED-RATE TO TRUE                       
                       MOVE 30 TO WS-BG-SUB                             
                   END-IF                                               
                   ADD 1 TO WS-BG-SUB                                   
               END-PERFORM                                              
           END-IF.                                                      
           MOVE 'Y' TO WS-WRITE-PREV-DATA.                              
A03019     IF WS-BILL-FRMT-FLAG NOT = 'Y'                               
A03019        PERFORM 0400-LOAD-BILL-FORMAT      THRU 0400-EXIT         
A03019        MOVE 'Y' TO WS-BILL-FRMT-FLAG                             
A03019     END-IF.                                                      
           IF WS-RATE-DESC-FLAG NOT = 'Y'                               
              IF SEB-DATABASE                                           
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 0550-LOAD-RATE-DESCRIPTION THRU 0550-EXIT      
                 MOVE 'Y' TO WS-RATE-DESC-FLAG                          
              END-IF                                                    
           END-IF.                                                      
           MOVE +1 TO SUB1.                                             
           PERFORM UNTIL SUB1 > 30 OR WS-ACCOUNT-NO-BG (SUB1) = ZEROES  
               PERFORM 0500-GET-RATE-DESCRIPTION THRU 0500-EXIT         
               ADD +1 TO SUB1                                           
           END-PERFORM.                                                 
                                                                        
           PERFORM 0600-DETERMINE-DUE-DATES THRU 0600-EXIT.             
                                                                        
           IF WS-ACCOUNT-NO-BE > ZEROES AND                             
              WS-STATUS-CODE-BE = 'A'                                   
               IF WS-ACCT-FINALED-DT-AT > SPACES AND                    
                  WS-DATE-BILLED-BI > WS-ACCT-FINALED-DT-AT(1:10)       
                  PERFORM 0710-DRAFT-FINAL-BILL THRU 0710-EXIT          
               ELSE                                                     
                  PERFORM 0700-BANK-DRAFT THRU 0700-EXIT                
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE +1 TO SUB1.                                             
I00177     PERFORM UNTIL SUB1 > WS-CT-MAX-ENTRY                         
I00177                OR WS-ACCOUNT-NO-CT (SUB1) = ZEROES               
               IF WS-ACCOUNT-NO-CT (SUB1) > ZEROES                      
                   PERFORM 0800-CONTRACT-DATA THRU 0800-EXIT            
               END-IF                                                   
               ADD +1 TO SUB1                                           
           END-PERFORM.                                                 
                                                                        
           PERFORM 1000-NEXT-METER-READ-DATE THRU 1000-EXIT.            
      *                                                                 10180000
           PERFORM 1700-GET-BILL-STMNT-ID THRU 1700-EXIT.               
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * CHECK IF THE ACCOUNT IS A REBILL ACCOUNT. IF SO IT IS A REBILL          
      * IMMEDIATE OR REBILL MULTI AND IF REBILL MULTI DOES IT COME WITH         
      * AND ONCYLE FLAG.                                                        
      *                                                                         
       0110-CHECK-FUTURE.                                               
           MOVE 'Y' TO WS-CANCEL-ONLY.                                  
           MOVE 'N' TO WS-REBILL-FLAG                                   
                       WS-ONCYCLE-FLAG                                  
                       WS-FUTURE-FLAG.                                  
           MOVE SPACES TO WS-MAX-DATE-ORIG.                             
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL            
              WS-BILLING-INDX  > 30 OR                                  
                   WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = +0              
             IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) > SPACES         
                IF WS-CODE-BILL-ITM-TYPE-BG (WS-BILLING-INDX) = 'C'     
                   MOVE 'N' TO WS-CANCEL-ONLY                           
                END-IF                                                  
                IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) >             
                   WS-MAX-DATE-ORIG                                     
                   MOVE WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) TO       
                       WS-MAX-DATE-ORIG                                 
                END-IF                                                  
                MOVE 'Y' TO WS-REBILL-FLAG                              
             ELSE                                                       
                MOVE 'Y' TO WS-ONCYCLE-FLAG                             
             END-IF                                                     
           END-PERFORM.                                                 
           IF WS-REBILL-FLAG = 'Y' AND WS-ONCYCLE-FLAG = 'Y'            
               MOVE 'Y' TO WS-FUTURE-FLAG                               
           END-IF.                                                      
                                                                        
           MOVE WS-DATE-ORIG-BILL-BG (1) TO WS-PREV-DATE-ORIG.          
           PERFORM VARYING WS-BILLING-INDX FROM 2 BY 1 UNTIL            
                   WS-BILLING-INDX  > 30 OR REBILL-MULTI                
              IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) NOT = SPACES AND
                 WS-PREV-DATE-ORIG NOT =                                
                 WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX)                 
                     MOVE 'Y' TO WS-REBILL-MULTI-FLAG                   
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************   10360000
      * USE REVENUE MONTH TO DERIVE REVENUE MONTHS FOR LAST MONTH,      10370000
      * LAST YEAR THIS MONTH, LAST YEAR LAST MONTH, AND NEXT MONTH.     10380000
      ***************************************************************   10390000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE 'N' TO WS-PNDNG-BANK-DRAFT-FLAG.                        
           MOVE WS-REV-MTH-LST-NRML-AT TO WS-REVENUE-MONTH.             
           SUBTRACT 1 FROM WS-REVENUE-MM.                               
           IF WS-REVENUE-MM = 0                                         
               SUBTRACT 1 FROM WS-REVENUE-CCYY                          
               MOVE 12 TO WS-REVENUE-MM                                 
           END-IF.                                                      
           MOVE WS-REVENUE-MONTH TO WS-LAST-REV-MO-THIS-YR.             
                                                                        
           MOVE WS-REV-MTH-LST-NRML-AT TO WS-REVENUE-MONTH.             
           SUBTRACT 1 FROM WS-REVENUE-CCYY.                             
           MOVE WS-REVENUE-MONTH TO WS-THIS-REV-MO-LAST-YR.             
                                                                        
           MOVE WS-REV-MTH-LST-NRML-AT TO WS-REVENUE-MONTH.             
           SUBTRACT 1 FROM WS-REVENUE-CCYY.                             
           SUBTRACT 1 FROM WS-REVENUE-MM.                               
           IF WS-REVENUE-MM = 0                                         
               SUBTRACT 1 FROM WS-REVENUE-CCYY                          
               MOVE 12 TO WS-REVENUE-MM                                 
           END-IF.                                                      
           MOVE WS-REVENUE-MONTH TO WS-LAST-REV-MO-LAST-YR.             
                                                                        
           MOVE WS-REV-MTH-LST-NRML-AT TO WS-REVENUE-MONTH.             
           ADD 1 TO WS-REVENUE-MM.                                      
           IF WS-REVENUE-MM > 12                                        
               ADD 1 TO WS-REVENUE-CCYY                                 
               MOVE 1 TO WS-REVENUE-MM                                  
           END-IF.                                                      
           MOVE WS-REVENUE-MONTH TO WS-NEXT-REV-MO.                     
                                                                        
      *                                                                 10870000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12360000
A03019 0400-LOAD-BILL-FORMAT.                                           
A03019                                                                  
A03019     EXEC SQL                                                     
A03019         OPEN RATE_CREATOR                                        
A03019     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03019     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03019     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03019         NEXT SENTENCE                                            
A03019     ELSE                                                         
A03019         MOVE 12 TO RETURN-CODE                                   
A03019         MOVE 'OPEN'         TO ABEND-FUNCTION                    
A03019         MOVE SQLCODE        TO RS-RETURN-CODE                    
A03019         MOVE '0400'         TO ACTIVE-PARAGRAPH                  
A03019         PERFORM 9900-ABEND THRU 9900-EXIT                        
A03019     END-IF.                                                      
A03019     MOVE 1                          TO WS-ADJ-SUB.               
A03019     MOVE 1                          TO WS-MISC-IDX.              
A03019     PERFORM 0410-FETCH-BILL-FORMAT     THRU 0410-EXIT.           
A03019     EXEC SQL                                                     
A03019         CLOSE RATE_CREATOR                                       
A03019     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03019     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03019     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03019         NEXT SENTENCE                                            
A03019     ELSE                                                         
A03019         MOVE 12 TO RETURN-CODE                                   
A03019         MOVE 'CLOSE'        TO ABEND-FUNCTION                    
A03019         MOVE SQLCODE        TO RS-RETURN-CODE                    
A03019         MOVE '0400'         TO ACTIVE-PARAGRAPH                  
A03019         PERFORM 9900-ABEND THRU 9900-EXIT                        
A03019     END-IF.                                                      
A03019*                                                                 24070000
A03019 0400-EXIT.                                                       
A03019     EXIT.                                                        
A03019*                                                                 24070000
A03019 0410-FETCH-BILL-FORMAT.                                          

MSQ008     MOVE 100 TO MSQ008-RATE-CREATOR
A03019*                                                                 24070000
A03019     EXEC SQL                                                     
A03019         FOR :MSQ008-RATE-CREATOR
              FETCH 
              FROM RATE_CREATOR          
A03019          INTO :WS-RD-BILL-FORMAT-CD-RT                           
A03019              ,:WS-RD-CODE-UTIL-TYPE-RT                           
A03019              ,:WS-RD-RATE-PLAN-NO-RT                             
A03019     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     23700000
MFA-TR*        FETCH NEXT ROWSET FROM RATE_CREATOR FOR 100 ROWS         23710000
MFA-TR*         INTO :WS-RD-BILL-FORMAT-CD-RT                           23720000
MFA-TR*             ,:WS-RD-CODE-UTIL-TYPE-RT                           23730000
MFA-TR*             ,:WS-RD-RATE-PLAN-NO-RT                             23730000
MFA-TR*    END-EXEC.                                                    23740000

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-RATE-CREATOR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03019     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03019     EVALUATE WS-ACTIVE-RETURN-CODE                               
A03019         WHEN SUCCESSFUL-CALL                                     
A03019         WHEN NOT-FOUND                                           
A03019             EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT                      
A03019             END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                             00093100
MFA-TR*                  :WS-ROW-COUNT = ROW_COUNT                      00093200
MFA-TR*            END-EXEC                                             00093300
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-ROW-COUNT
A03019             MOVE 1 TO WS-MISC-IDX                                
A03019             PERFORM UNTIL WS-MISC-IDX > 100                      
A03019                        OR WS-MISC-IDX > WS-ROW-COUNT             
A03019                 MOVE WS-RD-RATE-PLAN-NO-RT(WS-MISC-IDX)          
A03019                                       TO                         
A03019                      WS-RT-RATE-PLAN-NO (WS-ADJ-SUB)             
A03019                 MOVE WS-RD-CODE-UTIL-TYPE-RT(WS-MISC-IDX)        
A03019                                       TO                         
A03019                      WS-RT-CODE-UTIL-TYPE(WS-ADJ-SUB)            
A03019                 MOVE WS-RD-BILL-FORMAT-CD-RT(WS-MISC-IDX)        
A03019                                       TO                         
A03019                      WS-RT-BILL-FORMAT-CD(WS-ADJ-SUB)            
A03019                 ADD 1                      TO WS-ADJ-SUB         
A03019                 ADD 1                      TO WS-MISC-IDX        
A03019             END-PERFORM                                          
A03019             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
A03019                GO TO 0410-EXIT                                   
A03019             END-IF                                               
A03019         WHEN OTHER                                               
A03019             MOVE 12 TO RETURN-CODE                               
A03019             MOVE 'FETCH'        TO ABEND-FUNCTION                
A03019             MOVE SQLCODE        TO RS-RETURN-CODE                
A03019             MOVE '0410'         TO ACTIVE-PARAGRAPH              
A03019             PERFORM 9900-ABEND THRU 9900-EXIT                    
A03019     END-EVALUATE.                                                
A03019     PERFORM 0410-FETCH-BILL-FORMAT.                              
A03019*                                                                 24070000
A03019 0410-EXIT.                                                       
A03019     EXIT.                                                        
      *                                                                 24070000
      ***************************************************************   22960000
      * RATE DESCRIPTION FOR EACH RATE PLAN ON BG                       22970000
      ***************************************************************   22980000
                                                                        
       0500-GET-RATE-DESCRIPTION.                                       
                                                                        
           MOVE WS-RATE-PLAN-NO-BG (SUB1) TO RD-RATE-PLAN-NO            
                                             WS-RATE-PLAN-NO.           
           MOVE WS-CODE-UTIL-TYPE-BG (SUB1) TO RD-CODE-UTIL-TYPE.       
           IF WS-CODE-UTIL-TYPE-BG (SUB1) = 'E'                         
               PERFORM 1800-CHECK-FOR-MV90 THRU 1800-EXIT               
           ELSE                                                         
               MOVE SPACES TO WS-MTR-READ-SOURCE-CD                     
           END-IF.                                                      
           MOVE WS-COMPANY-NO-AT TO RD-COMPANY-NO.                      
                                                                        
           SET WS-RATE-DESC-INDX TO 1                                   
           SEARCH WS-RD-RATE-LINE                                       
                AT END                                                  
                   MOVE SPACES TO WS-RATE-DESCRIPTION-CALC (SUB1)       
                                  WS-BILL-FORMAT-CODE-RT (SUB1)         
                WHEN WS-RD-RATE-PLAN-NO (WS-RATE-DESC-INDX)             
                     = RD-RATE-PLAN-NO                                  
                 AND WS-RD-CODE-UTIL-TYPE (WS-RATE-DESC-INDX)           
                     = RD-CODE-UTIL-TYPE                                
                  AND WS-RD-COMPANY-NO (WS-RATE-DESC-INDX)              
                     = RD-COMPANY-NO                                    
                   MOVE WS-RD-RATE-DESC (WS-RATE-DESC-INDX)             
                        TO WS-RATE-DESCRIPTION-CALC (SUB1)              
I01959             MOVE WS-RD-BILL-LITERAL-TX (WS-RATE-DESC-INDX)       
I01959                  TO WS-BILL-LITTERAL-TX-CALC (SUB1)              
P01175             MOVE WS-RD-RATE-SUB-GRP-TYPE (WS-RATE-DESC-INDX)     
P01175                  TO WS-RATE-SUB-GRP-TYPE (SUB1)                  
                   MOVE WS-RATE-PLAN-NO-BG (SUB1) TO                    
                        RT-RATE-PLAN-NO                                 
                   MOVE WS-CODE-UTIL-TYPE-BG (SUB1) TO                  
                        RT-CODE-UTIL-TYPE                               
                   IF WS-RD-SECURED-RATE-FL (WS-RATE-DESC-INDX)         
                                 = 'Y'                                  
                       MOVE 'S' TO WS-ACCOUNT-TYPE-CODE-AT              
                   END-IF                                               
                   IF ITRON-OR-MV90-PLAN AND MV90-METER                 
                       MOVE '06' TO WS-BILL-FORMAT-CODE-RT (SUB1)       
                   ELSE                                                 
                       PERFORM 0510-GET-BILL-FORMAT THRU 0510-EXIT      
                   END-IF                                               
                END-SEARCH.                                             
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0510-GET-BILL-FORMAT.                                            
      *                                                                 23540000
A03019     SET WS-BILL-FRMT-INDX TO 1                                   
A03019     SEARCH WS-RT-BILL-FORMAT-LINE                                
A03019          AT END                                                  
A03019              MOVE SPACES TO WS-BILL-FORMAT-CODE-RT (SUB1)        
A03019          WHEN WS-RT-RATE-PLAN-NO (WS-BILL-FRMT-INDX)             
A03019               = RT-RATE-PLAN-NO                                  
A03019           AND WS-RT-CODE-UTIL-TYPE (WS-BILL-FRMT-INDX)           
A03019               = RT-CODE-UTIL-TYPE                                
A03019               MOVE WS-RT-BILL-FORMAT-CD (WS-BILL-FRMT-INDX)      
A03019                          TO WS-BILL-FORMAT-CODE-RT (SUB1)        
A03019     END-SEARCH.                                                  
      *                                                                 24070000
       0510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24100000
       0550-LOAD-RATE-DESCRIPTION.                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN RATE_DESC                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 12 TO RETURN-CODE                                    
              MOVE 'OPEN'    TO ABEND-FUNCTION                          
              MOVE SQLCODE   TO RS-RETURN-CODE                          
              MOVE '0550'    TO ACTIVE-PARAGRAPH                        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
           MOVE 1                          TO WS-ADJ-SUB.               
           MOVE 1                          TO WS-MISC-IDX.              
           PERFORM 0575-FETCH-RATE         THRU 0575-EXIT.              
           EXEC SQL                                                     
               CLOSE RATE_DESC                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 12 TO RETURN-CODE                                    
              MOVE 'CLOSE'   TO ABEND-FUNCTION                          
              MOVE SQLCODE   TO RS-RETURN-CODE                          
              MOVE '0550'    TO ACTIVE-PARAGRAPH                        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 00081200
       0550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0575-FETCH-RATE.                                                 

MSQ008     MOVE 100 TO MSQ008-RATE-DESC
      *                                                                 00090700
           EXEC SQL                                                     
               FOR :MSQ008-RATE-DESC
              FETCH 
              FROM RATE_DESC             
                INTO :WS-RD-RATE-DESC-HV,                               
                     :WS-RD-SECURED-RATE-FL-HV,                         
                     :WS-RD-RATE-PLAN-NO-HV,                            
                     :WS-RD-CODE-UTIL-TYPE-HV,                          
                     :WS-RD-COMPANY-NO-HV,                              
I01959               :WS-RD-BILL-LITERAL-TX-HV,                         
P01175               :WS-RD-RATE-SUB-GRP-TYPE-HV                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     00090800
MFA-TR*        FETCH NEXT ROWSET FROM RATE_DESC  FOR 100 ROWS           00090900
MFA-TR*         INTO :WS-RD-RATE-DESC-HV,                               00091000
MFA-TR*              :WS-RD-SECURED-RATE-FL-HV,                                 
MFA-TR*              :WS-RD-RATE-PLAN-NO-HV,                                    
MFA-TR*              :WS-RD-CODE-UTIL-TYPE-HV,                                  
MFA-TR*              :WS-RD-COMPANY-NO-HV,                                      
MFA-TR*              :WS-RD-BILL-LITERAL-TX-HV,                                 
MFA-TR*              :WS-RD-RATE-SUB-GRP-TYPE-HV                                
MFA-TR*    END-EXEC.                                                    00091200

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-RATE-DESC
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT                      
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                             00093100
MFA-TR*                  :WS-ROW-COUNT = ROW_COUNT                      00093200
MFA-TR*            END-EXEC                                             00093300
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-ROW-COUNT
                   MOVE 1 TO WS-MISC-IDX                                
                   PERFORM UNTIL WS-MISC-IDX > 100                      
                              OR WS-MISC-IDX > WS-ROW-COUNT             
                       MOVE WS-RD-RATE-DESC-HV(WS-MISC-IDX)             
                                             TO                         
                            WS-RD-RATE-DESC (WS-ADJ-SUB)                
                       MOVE WS-RD-SECURED-RATE-FL-HV(WS-MISC-IDX)       
                                             TO                         
                            WS-RD-SECURED-RATE-FL (WS-ADJ-SUB)          
                       MOVE WS-RD-RATE-PLAN-NO-HV(WS-MISC-IDX)          
                                             TO                         
                            WS-RD-RATE-PLAN-NO (WS-ADJ-SUB)             
                       MOVE WS-RD-CODE-UTIL-TYPE-HV(WS-MISC-IDX)        
                                             TO                         
                            WS-RD-CODE-UTIL-TYPE(WS-ADJ-SUB)            
                       MOVE WS-RD-COMPANY-NO-HV(WS-MISC-IDX)            
                                             TO                         
                            WS-RD-COMPANY-NO(WS-ADJ-SUB)                
I01959                 MOVE WS-RD-BILL-LITERAL-TX-HV(WS-MISC-IDX)  TO   
I01959                            WS-RD-BILL-LITERAL-TX(WS-ADJ-SUB)     
P01175                 MOVE WS-RD-RATE-SUB-GRP-TYPE-HV(WS-MISC-IDX) TO  
P01175                            WS-RD-RATE-SUB-GRP-TYPE(WS-ADJ-SUB)   
                       ADD 1                      TO WS-ADJ-SUB         
                       ADD 1                      TO WS-MISC-IDX        
                   END-PERFORM                                          
                   IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                      GO TO 0575-EXIT                                   
                   END-IF                                               
               WHEN OTHER                                               
                    MOVE 12 TO RETURN-CODE                              
                    MOVE 'FETCH'   TO ABEND-FUNCTION                    
                    MOVE SQLCODE   TO RS-RETURN-CODE                    
                    MOVE '0575'    TO ACTIVE-PARAGRAPH                  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
           GO TO 0575-FETCH-RATE.                                       
      *                                                                 00096100
       0575-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00096100
      ***************************************************************   24110000
      * DUE DATES ARE BASED ON CREDIT GROUP, ARREARS, AND NOTICE        24120000
      * TYPE.  ONLY CREDIT GROUPS 'B' AND 'N' SET MORE THAN ONE         24130000
      * DUE DATE.                                                       24140000
      ***************************************************************   24150000
                                                                        
       0600-DETERMINE-DUE-DATES.                                        
                                                                        
           INITIALIZE WS-DUE-DATES.                                     
           MOVE 0 TO WS-DRAFT-AMOUNT.                                   
           MOVE +1 TO SUB1.                                             
I00177     PERFORM UNTIL SUB1 > WS-AC-MAX-ENTRY                         
I00177                OR WS-ACCOUNT-NO-AC (SUB1) = ZEROES               
               ADD WS-AMT-AR-DAY-00-AC (SUB1)                           
                   WS-AMT-AR-DAY-30-AC (SUB1)                           
                   WS-AMT-AR-DAY-60-AC (SUB1)                           
                   WS-AMT-AR-DAY-90-AC (SUB1) TO WS-DRAFT-AMOUNT        
               ADD +1 TO SUB1                                           
           END-PERFORM.                                                 
           IF WS-TOTAL-ARREARS-BI > 0.00                                
               MOVE 'Y' TO WS-ARREARS-FOUND                             
           END-IF.                                                      
                                                                        
P00599** IF THERE ARE ARREARS THEN LOAD THE BALANCE BROUGHT FWD DUE DATE        
P00599     IF WS-UTL-NORM-DUE-DT-1H > ' '                               
P00599         MOVE WS-UTL-NORM-DUE-DT-1H TO WS-BALANCE-FWD-DUE-DATE    
P00599     END-IF.                                                      
ACT003     MOVE WS-TOT-DUE-DT-1H TO WS-TOTAL-DUE-DATE.                  
P00599                                                                  
P00599** FOR SCANA ENERGY IF CREDIT GROUP IS BALANCE AND THERE ARE              
P00599** NO ARREARS ONLY LOAD TOTAL DUE DATE.                                   
P00599     IF SEB-DATABASE                                              
P00599        IF WS-CREDIT-GROUP-AT = 'B' AND WS-TOT-ARREARS-AM-1H = 0  
P00599           MOVE SPACES TO WS-BALANCE-FWD-DUE-DATE                 
P00599        END-IF                                                    
P00599     END-IF.                                                      
                                                                        
P00599** POPULATE BUDGET BILLING OPTION2 DUE DATE                               
A00984     IF (WS-ACCOUNT-NO-BU  = WS-ACCOUNT-NO-AT)                    
A00984         MOVE WS-REV-MTH-LST-NRML-AT TO WS-REVENUE-MONTH          
A00984         MOVE WS-ANNIVERSARY-DATE-BU (6:2) TO WS-EPP-ANNIV-MO     
A00984         MOVE WS-ANNIVERSARY-DATE-BU (1:4) TO WS-EPP-ANNIV-YEAR   
A00984         COMPUTE WS-YEAR-DIFF-EPP =  WS-EPP-ANNIV-YEAR -          
A00984                                     WS-REVENUE-CCYY              
A00984         IF WS-YEAR-DIFF-EPP   = 1 AND                            
A00984            WS-REVENUE-MM = WS-EPP-ANNIV-MO AND                   
A00984            WS-AMT-MO-PYMT-NEW-BU > ZERO                          
P00599            IF WS-TOT-DUE-DT-1H > ' '                             
P00599               MOVE WS-TOT-DUE-DT-1H TO                           
P00599                    WS-BB-OPTION2-DUE-DATE                        
P00599            ELSE                                                  
P00599               MOVE WS-ADDITIONAL-DUE-DT-1H TO                    
P00599                    WS-BB-OPTION2-DUE-DATE                        
P00599            END-IF                                                
A00984         END-IF                                                   
A00984     END-IF.                                                      
A00984                                                                  
A00984 0600-EXIT.                                                       
A00984     EXIT.                                                        
A00984                                                                  
                                                                        
      ***************************************************************   25930000
      * DETERMINE DRAFT DATE, DELETE ALL PENDING DRAFTS FROM THE PB     25940000
      * TABLE, INSERT A PB ROW AND GET THE BANK NAME.                   25950000
      ***************************************************************   25960000
                                                                        
       0700-BANK-DRAFT.                                                 
                                                                        
           MOVE 'N' TO WS-NO-PRIOR-DRAFT.                               
           MOVE WS-ACCOUNT-NO-BE TO PB-ACCOUNT-NO.                      
           INITIALIZE WS-PNDNG-BANK-DRAFT.                              
           INITIALIZE WS-BKDFT-SUB.                                     
                                                                        
A03733     PERFORM 0780-GET-DEL-DATA         THRU 0780-EXIT.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND                     
                 (WS-DATE-ORIG-BILL-BG (1) > SPACES)                    
               PERFORM 0760-CHECK-LAST-DRAFT-DAY THRU 0760-EXIT         
               IF WS-NO-PRIOR-DRAFT = 'N'                               
                 GO TO 0700-EXIT                                        
               END-IF                                                   
           END-IF.                                                      
                                                                        
           IF WS-DRAFT-AMOUNT > 0                                       
               CONTINUE                                                 
           ELSE                                                         
               GO TO 0700-EXIT                                          
           END-IF.                                                      
                                                                        
           IF WS-CODE-BILL-TYPE-BI = 'B'                                
               PERFORM 0710-DRAFT-FINAL-BILL THRU 0710-EXIT             
           ELSE                                                         
               PERFORM 0720-DETERMINE-DRAFT-DATE THRU 0720-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 0730-GET-BANK-NAME THRU 0730-EXIT.                   
                                                                        
           INITIALIZE DCLCSS-PNDNG-BNK-DRFT.                            
           MOVE WS-ACCOUNT-NO-BE TO PB-ACCOUNT-NO.                      
           MOVE WS-DRAFT-DATE-CALC TO PB-DRAFT-DATE.                    
           IF WS-DRAFT-DATE-CALC = SPACES OR LOW-VALUES                 
               MOVE -1 TO WS-NULL-IND-4                                 
           END-IF.                                                      
           EVALUATE WS-ACCT-TYPE-CD-BE                                  
               WHEN 'C'                                                 
                   MOVE 27 TO PB-TRANSACTION-CD                         
               WHEN 'S'                                                 
                   MOVE 37 TO PB-TRANSACTION-CD                         
           END-EVALUATE.                                                
           MOVE WS-DRAFT-AMOUNT TO PB-DRAFT-AMT.                        
           MOVE 'S' TO PB-CODE-SOURCE-ID.                               
           PERFORM 0705-GET-SOURCE-ID THRU 0705-EXIT.                   
           ADD 1                   TO WS-BKDFT-SUB.                     
           MOVE PB-ACCOUNT-NO      TO WS-PNDNG-ACCOUNT-NO(WS-BKDFT-SUB).
           MOVE PB-DRAFT-DATE      TO WS-PNDNG-DRAFT-DATE(WS-BKDFT-SUB).
           MOVE PB-DRAFT-AMT       TO                                   
                                       WS-PNDNG-DRAFT-AMT(WS-BKDFT-SUB).
           MOVE PB-TRANSACTION-CD  TO                                   
                                 WS-PNDNG-TRANSACTION-CD(WS-BKDFT-SUB). 
           MOVE PB-CODE-SOURCE-ID  TO                                   
                                  WS-PNDNG-CODE-SOURCE-ID(WS-BKDFT-SUB).
           MOVE BE-CUST-BANK-SEQ-NO TO                                  
                                    WS-PNDNG-BANK-SEQ-NO (WS-BKDFT-SUB).
           MOVE 'I'                TO                                   
                                    WS-PNDNG-INS-DEL-FLAG(WS-BKDFT-SUB).
           MOVE 'Y'               TO WS-PNDNG-BANK-DRAFT-FLAG.          
                                                                        
       0700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0705-GET-SOURCE-ID.                                              
                                                                        
           MOVE PB-ACCOUNT-NO          TO BE-ACCOUNT-NO.                
                                                                        
           EXEC SQL                                                     
             SELECT STATUS_CODE                                         
                    ,INIT_TYPE_CD                                       
                    ,CUST_BANK_SEQ_NO                                   
               INTO :BE-STATUS-CODE                                     
                    ,:BE-INIT-TYPE-CD                                   
                    ,:BE-CUST-BANK-SEQ-NO                               
               FROM CSS_BANK_EFT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                         
A03166                                                           
A03166                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27350000
MFA-TR*      SELECT STATUS_CODE                                         27360000
MFA-TR*             ,INIT_TYPE_CD                                       27370000
MFA-TR*             ,CUST_BANK_SEQ_NO                                   27380000
MFA-TR*        INTO :BE-STATUS-CODE                                     27390000
MFA-TR*             ,:BE-INIT-TYPE-CD                                   27400000
MFA-TR*             ,:BE-CUST-BANK-SEQ-NO                               27410000
MFA-TR*        FROM CSS_BANK_EFT                                        27420000
MFA-TR*       WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                         27430000
MFA-TR*         WITH UR                                                 26090000
MFA-TR*         QUERYNO 0705                                            26090000
MFA-TR*    END-EXEC.                                                    27440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF BE-STATUS-CODE = 'A' AND BE-INIT-TYPE-CD = '02'   
                      MOVE 'I'         TO PB-CODE-SOURCE-ID             
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE 12 TO RETURN-CODE                               
                   MOVE 'SELECT'       TO ABEND-FUNCTION                
                   MOVE SQLCODE        TO RS-RETURN-CODE                
                   MOVE '0705'         TO ACTIVE-PARAGRAPH              
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       0705-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   27670000
      * A FINAL BILL IS DRAFTED 5 BUSINESS DAYS FROM THE BILL DATE. *   27680000
A03166* ADD FB DRAFT DATE REQUIREMENT - IF FB DRAFT DATE BASED ON   *   27680000
A03166* NACHA RULE OF 5 BUSINESS DAYS IS LESS THAN THE PENDING      *   27680000
A03166* DRAFT DATE USE THE EXISTING PENDING DRAFT DATE.             *   27680000
      ***************************************************************   27690000
                                                                        
       0710-DRAFT-FINAL-BILL.                                           
                                                                        
           IF WS-ACCT-FINALED-DT-AT > SPACES AND                        
              WS-DATE-BILLED-BI > WS-ACCT-FINALED-DT-AT(1:10)           
              MOVE WS-ACCT-FINALED-DT-AT(1:10) TO WS-FB-HOLD-DATE       
           ELSE                                                         
              MOVE WS-DATE-BILLED-BI TO WS-FB-HOLD-DATE                 
           END-IF.                                                      
A03166     MOVE WS-FB-HOLD-DATE TO WS-DRAFT-FB-DT.                      
           MOVE 5 TO WS-FB-NO-DAYS.                                     
           PERFORM 0715-GET-FUTURE-BUSINESS-DAYS THRU 0715-EXIT         
               UNTIL WS-FB-DAY-COUNT = WS-FB-NO-DAYS.                   
A03166     PERFORM 0795-GET-CURR-DRAFT-DT THRU 0795-EXIT.               
A03166     IF WS-DRAFT-EXST-DT > WS-FB-HOLD-DATE                        
A03166         MOVE WS-DRAFT-EXST-DT TO WS-DRAFT-DATE-CALC              
A03166     ELSE                                                         
A03166         MOVE WS-FB-HOLD-DATE TO WS-DRAFT-DATE-CALC               
A03166     END-IF.                                                      
                                                                        
       0710-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0715-GET-FUTURE-BUSINESS-DAYS.                                   
                                                                        
           EXEC SQL                                                     
                SELECT
              CIS.DAYS (DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                       :WS-FB-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-FB-HOLD-DATE
              ) <> 0) OR (LEN(:WS-FB-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-FB-HOLD-DATE
              ), CONVERT(DATE, :WS-FB-HOLD-DATE) ) )) 
                    - (CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                       :WS-FB-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-FB-HOLD-DATE
              ) <> 0) OR (LEN(:WS-FB-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-FB-HOLD-DATE
              ), CONVERT(DATE, :WS-FB-HOLD-DATE) ) ))/7 * 7)
            INTO
              :WS-FB-DAY      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     27900000
MFA-TR*         SET :WS-FB-DAY = DAYS (DATE(:WS-FB-HOLD-DATE) + 1 DAYS)         
MFA-TR*             - (INTEGER(DAYS(DATE(:WS-FB-HOLD-DATE)                      
MFA-TR*                                          + 1 DAYS)/7) * 7)              
MFA-TR*    END-EXEC.                                                    27970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               MOVE 'SELECT'       TO ABEND-FUNCTION                    
               MOVE SQLCODE        TO RS-RETURN-CODE                    
               MOVE '0715'         TO ACTIVE-PARAGRAPH                  
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           PERFORM 0715A-GET-FUTURE-BUSINESS-DAYS THRU 0715A-EXIT.      
           EVALUATE TRUE                                                
               WHEN WS-FB-DAY = 6 OR WS-FB-DAY = 0                      
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-FB-HOLD-DATE TO J8-HOLIDAY-DT                
                   PERFORM 0716-SELECT-HOLIDAY THRU 0716-EXIT           
                   IF WS-FB-HOLIDAY-EXISTS = 'Y'                        
                       CONTINUE                                         
                   ELSE                                                 
                       ADD 1 TO WS-FB-DAY-COUNT                         
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
       0715-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0715A-GET-FUTURE-BUSINESS-DAYS.                                  
           EXEC SQL                                                     
                SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-FB-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-FB-HOLD-DATE
              ) <> 0) OR (LEN(:WS-FB-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-FB-HOLD-DATE
              ), CONVERT(DATE, :WS-FB-HOLD-DATE) ) )
            INTO
              :WS-FB-HOLD-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     27900000
MFA-TR*         SET :WS-FB-HOLD-DATE =                                          
MFA-TR*             DATE(:WS-FB-HOLD-DATE) + 1 DAYS                             
MFA-TR*    END-EXEC.                                                    27970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               MOVE 'SELECT'       TO ABEND-FUNCTION                    
               MOVE SQLCODE        TO RS-RETURN-CODE                    
               MOVE '0715A'        TO ACTIVE-PARAGRAPH                  
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       0715A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       0716-SELECT-HOLIDAY.                                             
                                                                        
           MOVE 'N' TO WS-FB-HOLIDAY-EXISTS.                            
           EXEC SQL                                                     
               SELECT DISTINCT ('Y')                                    
                 INTO :WS-FB-HOLIDAY-EXISTS                             
                 FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                         
                WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                       
A03166                                                           
A03166                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     28290000
MFA-TR*        SELECT DISTINCT ('Y')                                    28300000
MFA-TR*          INTO :WS-FB-HOLIDAY-EXISTS                             28310000
MFA-TR*          FROM CSS_HOLIDAY                                       28320000
MFA-TR*         WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                       28330000
MFA-TR*         WITH UR                                                 26090000
MFA-TR*         QUERYNO 0716                                            26090000
MFA-TR*    END-EXEC.                                                    28340000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               MOVE 'SELECT'       TO ABEND-FUNCTION                    
               MOVE SQLCODE        TO RS-RETURN-CODE                    
               MOVE '0716'         TO ACTIVE-PARAGRAPH                  
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       0716-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************            28510000
      ** IF DRAFT CYCLE < BILL CYCLE GET DRAFT DAY FOR NEXT             28520000
      ** REV MONTH.                                                     28530000
      ** DRAFT ACCOUNT ON OPEN DAY OF DRAFT CYCLE OR 5 BUSINESS         28540000
      ** DAYS FROM BILL DAY, WHICHEVER IS GREATER.                      28550000
      ********************************************************          28560000
       0720-DETERMINE-DRAFT-DATE.                                       
                                                                        
           MOVE WS-DRAFT-CYCLE-BE TO BN-BILL-CYCLE.                     
           IF WS-DRAFT-CYCLE-BE < WS-BILL-CYCLE-AT                      
              MOVE WS-NEXT-REV-MO TO BN-REVENUE-MONTH                   
           ELSE                                                         
              MOVE WS-REV-MTH-LST-NRML-AT TO BN-REVENUE-MONTH           
           END-IF.                                                      
           MOVE WS-DRAFT-CYCLE-BE TO WS-DRAFT-CYCLE.                    
           PERFORM 0751-GET-OPEN-OF-CYCLE THRU 0751-EXIT.               
           MOVE BN-DATE-EXTRACT   TO WS-DRAFT-OPEN.                     
           MOVE WS-BILL-CYCLE-AT  TO WS-DRAFT-CYCLE.                    
           MOVE WS-NEXT-REV-MO    TO BN-REVENUE-MONTH.                  
           PERFORM 0751-GET-OPEN-OF-CYCLE THRU 0751-EXIT.               
           MOVE BN-DATE-EXTRACT   TO WS-NEXT-BILL-OPEN.                 
           MOVE WS-DATE-BILLED-BI TO WS-FB-HOLD-DATE.                   
           MOVE 5 TO WS-FB-NO-DAYS.                                     
           PERFORM 0715-GET-FUTURE-BUSINESS-DAYS THRU 0715-EXIT         
              UNTIL WS-FB-DAY-COUNT = WS-FB-NO-DAYS.                    
      *********************************************************         28760000
      ***  IF BILL-DATE + 5 MAKES DRAFT PAST NEXT BILL DATE             28770000
      ***  IGNORE 5 DAY BUFFER AND DRAFT ON OPEN OF DRAFT CYCLE         28780000
      ***  ELSE DRAFT ON OPEN OF DRAFT CYCLE OR BILL DAY + 5            28790000
      ***  WITCHEVER IS GREATER.                                        28800000
      *********************************************************         28810000
           IF WS-FB-HOLD-DATE > WS-NEXT-BILL-OPEN                       
             OR WS-FB-HOLD-DATE < WS-DRAFT-OPEN                         
              MOVE WS-DRAFT-OPEN   TO WS-DRAFT-DATE-CALC                
           ELSE                                                         
              MOVE WS-FB-HOLD-DATE TO WS-DRAFT-DATE-CALC                
           END-IF.                                                      
                                                                        
       0720-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0730-GET-BANK-NAME.                                              
                                                                        
           MOVE WS-BANK-ID-BE TO D1-BANK-ID.                            
           EXEC SQL                                                     
               SELECT BANK_NAME                                         
                 INTO :D1-BANK-NAME                                     
                 FROM CSS_BANK WITH(READUNCOMMITTED)                            
                WHERE BANK_ID = :D1-BANK-ID                             
A03166                                                           
A03166                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     29220000
MFA-TR*        SELECT BANK_NAME                                         29230000
MFA-TR*          INTO :D1-BANK-NAME                                     29240000
MFA-TR*          FROM CSS_BANK                                          29250000
MFA-TR*         WHERE BANK_ID = :D1-BANK-ID                             29260000
MFA-TR*         WITH UR                                                 26090000
MFA-TR*         QUERYNO 0730                                            26090000
MFA-TR*    END-EXEC.                                                    29270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE D1-BANK-NAME TO WS-BANK-NAME-CALC               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-BANK-NAME-CALC                     
               WHEN OTHER                                               
                   MOVE 12 TO RETURN-CODE                               
                   MOVE 'SELECT'       TO ABEND-FUNCTION                
                   MOVE SQLCODE        TO RS-RETURN-CODE                
                   MOVE '0730'         TO ACTIVE-PARAGRAPH              
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
       0730-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************              29490000
       0750-SELECT-BILL-WINDOW.                                         
      *****************************                                     29510000
                                                                        
           MOVE WS-BILL-CYCLE-AT TO WS-HOLD-BILL-CYCLE.                 
           IF WS-HOLD-BILL-CYCLE < WS-DRAFT-CYCLE-BE                    
              ADD 20 TO WS-HOLD-BILL-CYCLE                              
           END-IF.                                                      
           MOVE WS-DRAFT-CYCLE-BE TO WS-DRAFT-CYCLE-NUM.                
           IF WS-DRAFT-CYCLE-NUM + 3 >= WS-HOLD-BILL-CYCLE              
              MOVE WS-DRAFT-CYCLE-BE TO WS-DRAFT-CYCLE                  
              PERFORM 0751-GET-OPEN-OF-CYCLE                            
           ELSE                                                         
              MOVE WS-BILL-CYCLE-AT TO WS-HOLD-CYCLE                    
              PERFORM 0752-GET-DAYS-TO-SLIDE                            
              MOVE WS-DRAFT-CYCLE-BE TO WS-HOLD-CYCLE                   
              PERFORM 0753-SLIDE-DRAFT-DAY                              
           END-IF.                                                      
                                                                        
       0750-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0751-GET-OPEN-OF-CYCLE.                                          
      **************************                                        29720000
                                                                        
           EXEC SQL                                                     
              SELECT MIN(DATE_EXTRACT)                                  
                INTO :BN-DATE-EXTRACT                                   
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE BILL_CYCLE    = :WS-DRAFT-CYCLE                    
                 AND REVENUE_MONTH = :BN-REVENUE-MONTH                  
A03166                                                           
A03166                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     29740000
MFA-TR*       SELECT MIN(DATE_EXTRACT)                                  29750000
MFA-TR*         INTO :BN-DATE-EXTRACT                                   29760000
MFA-TR*         FROM CSS_BILL_WINDOW                                    29770000
MFA-TR*        WHERE BILL_CYCLE    = :WS-DRAFT-CYCLE                    29780000
MFA-TR*          AND REVENUE_MONTH = :BN-REVENUE-MONTH                  29790000
MFA-TR*         WITH UR                                                 26090000
MFA-TR*         QUERYNO 0751                                            26090000
MFA-TR*    END-EXEC.                                                    29800000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               MOVE 'SELECT'       TO ABEND-FUNCTION                    
               MOVE SQLCODE        TO RS-RETURN-CODE                    
               MOVE '0751'         TO ACTIVE-PARAGRAPH                  
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       0751-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0752-GET-DAYS-TO-SLIDE.                                          
      ***************************                                       29990000
                                                                        
           EXEC SQL                                                     
               OPEN CALC_SLIDE_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 12 TO RETURN-CODE                                    
              MOVE 'CALC_SLIDE  CURSOR'           TO TABLE-1            
              MOVE 'OPEN'                         TO ABEND-FUNCTION     
              MOVE SQLCODE                        TO RS-RETURN-CODE     
              MOVE '0752'                         TO ACTIVE-PARAGRAPH   
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
           PERFORM VARYING WS-SLIDE-CTR-1 FROM 1 BY 1                   
               UNTIL BN-DATE-EXTRACT =                                  
                     WS-DATE-BILLED-BI OR                               
                     SQLCODE NOT = 0                                    
               EXEC SQL                                                 
                  FETCH CALC_SLIDE_CSR                                  
                   INTO :BN-DATE-EXTRACT :WS-NULL-IND-5                 
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           END-PERFORM.                                                 
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 12 TO RETURN-CODE                                    
              MOVE 'SELECT'                       TO ABEND-FUNCTION     
              MOVE SQLCODE                        TO RS-RETURN-CODE     
              MOVE '0752'                         TO ACTIVE-PARAGRAPH   
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
           EXEC SQL                                                     
               CLOSE CALC_SLIDE_CSR                                     
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0753-SLIDE-DRAFT-DAY.                                            
      **************************                                        30440000
                                                                        
           EXEC SQL                                                     
               OPEN CALC_SLIDE_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 12 TO RETURN-CODE                                    
              MOVE 'CALC_SLIDE  CURSOR'           TO TABLE-1            
              MOVE 'OPEN'                         TO ABEND-FUNCTION     
              MOVE SQLCODE                        TO RS-RETURN-CODE     
              MOVE '0753'                         TO ACTIVE-PARAGRAPH   
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
           PERFORM VARYING WS-SLIDE-CTR-2 FROM 1 BY 1                   
               UNTIL WS-SLIDE-CTR-2 = WS-SLIDE-CTR-1                    
               EXEC SQL                                                 
                  FETCH CALC_SLIDE_CSR                                  
                   INTO :BN-DATE-EXTRACT :WS-NULL-IND-5                
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           END-PERFORM.                                                 
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 12 TO RETURN-CODE                                    
              MOVE 'CALC_SLIDE  CURSOR'           TO TABLE-1            
              MOVE 'FETCH'                        TO ABEND-FUNCTION     
              MOVE SQLCODE                        TO RS-RETURN-CODE     
              MOVE '0753'                         TO ACTIVE-PARAGRAPH   
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
           EXEC SQL                                                     
               CLOSE CALC_SLIDE_CSR                                     
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
      *****************************************************             30860000
                                                                        
       0760-CHECK-LAST-DRAFT-DAY.                                       
                                                                        
           MOVE WS-ACCOUNT-NO-AT TO BE-ACCOUNT-NO.                      
           EXEC SQL                                                     
               SELECT LAST_DRAFT_DATE                                   
A03733           INTO :BE-LAST-DRAFT-DATE :WS-NULL-IND-2                
                 FROM CSS_BANK_EFT WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                       
A03166                                                           
A03166                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     30910000
MFA-TR*        SELECT LAST_DRAFT_DATE                                   30920000
MFA-TR*          INTO :BE-LAST-DRAFT-DATE :WS-NULL-IND-2                30930000
MFA-TR*          FROM CSS_BANK_EFT                                      30940000
MFA-TR*         WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                       30950000
MFA-TR*         WITH UR                                                 26090000
MFA-TR*         QUERYNO 0760                                            26090000
MFA-TR*    END-EXEC.                                                    30960000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND-2 < 0                                 
                       MOVE 'N' TO WS-NO-PRIOR-DRAFT                    
                   ELSE                                                 
                       MOVE 'Y' TO WS-NO-PRIOR-DRAFT                    
                   END-IF                                               
               WHEN OTHER                                               
                    MOVE 12 TO RETURN-CODE                              
                    MOVE 'SELECT'  TO ABEND-FUNCTION                    
                    MOVE SQLCODE   TO RS-RETURN-CODE                    
                    MOVE '0760'    TO ACTIVE-PARAGRAPH                  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
                                                                        
       0760-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       0780-GET-DEL-DATA.                                               
           EXEC SQL                                                     
               OPEN PNDNG_DFT                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
                    MOVE 12 TO RETURN-CODE                              
                    MOVE 'OPEN'    TO ABEND-FUNCTION                    
                    MOVE SQLCODE   TO RS-RETURN-CODE                    
                    MOVE '0780'    TO ACTIVE-PARAGRAPH                  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-IF.                                                      
           PERFORM 0790-FETCH-PNDNG-DFT  THRU 0790-EXIT UNTIL           
            WS-ACTIVE-RETURN-CODE = NOT-FOUND.                          
           EXEC SQL                                                     
               CLOSE PNDNG_DFT                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
                    MOVE 12 TO RETURN-CODE                              
                    MOVE 'CLOSE'   TO ABEND-FUNCTION                    
                    MOVE SQLCODE   TO RS-RETURN-CODE                    
                    MOVE '0780'    TO ACTIVE-PARAGRAPH                  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       0780-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31600000
      * THE ACCOUNTS TO BE DELETED FROM CSS_PNDNG_BNK_DFT ARE FOUND HERE31610000
      ******************************************************************31620000
       0790-FETCH-PNDNG-DFT.                                            
           EXEC SQL                                                     
                FETCH PNDNG_DFT                                         
                  INTO :PB-ACCOUNT-NO                                   
                      ,:PB-DRAFT-DATE                                   
                      ,:PB-DRAFT-AMT                                    
                      ,:PB-TRANSACTION-CD                               
                      ,:PB-CODE-SOURCE-ID                               
                      ,:PB-CUST-BANK-SEQ-NO                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                 ADD 1                       TO WS-BKDFT-SUB            
                 MOVE PB-ACCOUNT-NO          TO                         
                                       WS-PNDNG-ACCOUNT-NO(WS-BKDFT-SUB)
                 MOVE PB-DRAFT-DATE          TO                         
                                       WS-PNDNG-DRAFT-DATE(WS-BKDFT-SUB)
                 MOVE PB-DRAFT-AMT           TO                         
                                       WS-PNDNG-DRAFT-AMT(WS-BKDFT-SUB) 
                 MOVE PB-TRANSACTION-CD      TO                         
                                   WS-PNDNG-TRANSACTION-CD(WS-BKDFT-SUB)
                 MOVE PB-CODE-SOURCE-ID      TO                         
                                   WS-PNDNG-CODE-SOURCE-ID(WS-BKDFT-SUB)
                 MOVE 'D'                    TO                         
                                     WS-PNDNG-INS-DEL-FLAG(WS-BKDFT-SUB)
                 MOVE 'Y'                    TO WS-PNDNG-BANK-DRAFT-FLAG
               WHEN NOT-FOUND                                           
                   GO TO 0790-EXIT                                      
               WHEN OTHER                                               
                    MOVE 12 TO RETURN-CODE                              
                    MOVE 'FETCH'   TO ABEND-FUNCTION                    
                    MOVE SQLCODE   TO RS-RETURN-CODE                    
                    MOVE '0790'    TO ACTIVE-PARAGRAPH                  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
               END-EVALUATE.                                            
                                                                        
       0790-EXIT.                                                       
           EXIT.                                                        
                                                                        
A03166******************************************************************31600000
A03166* GETS THE CURRENT/EXISTING DRAFT DATE FROM CSS_PNDNG_BNK_DRFT    31610000
A03166******************************************************************31620000
A03166 0795-GET-CURR-DRAFT-DT.                                          
A03166                                                                  
A03166     MOVE WS-ACCOUNT-NO-BE TO PB-ACCOUNT-NO.                      
A03166                                                                  
A03166     EXEC SQL                                                     
A03166       SELECT DRAFT_DATE                                          
A03166         INTO :PB-DRAFT-DATE                                      
A03166         FROM CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                    
A03166        WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                         
A03166          AND DRAFT_DATE > IIF(TRY_CONVERT(DATE, :WS-DRAFT-FB-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-DRAFT-FB-DT
              ) <> 0) OR (LEN(:WS-DRAFT-FB-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-DRAFT-FB-DT
              ), CONVERT(DATE, :WS-DRAFT-FB-DT) )                  
A03166          AND CODE_SOURCE_ID IN ('I','S')                         
A03166                                                           
A03166                                                      
A03166     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     27350000
MFA-TR*      SELECT DRAFT_DATE                                          27360000
MFA-TR*        INTO :PB-DRAFT-DATE                                      27390000
MFA-TR*        FROM CSS_PNDNG_BNK_DRFT                                  27420000
MFA-TR*       WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                         27430000
MFA-TR*         AND DRAFT_DATE > DATE(:WS-DRAFT-FB-DT)                  27430000
MFA-TR*         AND CODE_SOURCE_ID IN ('I','S')                         27430000
MFA-TR*         WITH UR                                                 26090000
MFA-TR*         QUERYNO 0795                                            26090000
MFA-TR*    END-EXEC.                                                    27440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03166                                                                  
A03166     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A03166                                                                  
A03166     EVALUATE WS-ACTIVE-RETURN-CODE                               
A03166         WHEN SUCCESSFUL-CALL                                     
A03166             MOVE PB-DRAFT-DATE TO WS-DRAFT-EXST-DT               
A03166         WHEN NOT-FOUND                                           
A03166             MOVE WS-DRAFT-FB-DT TO WS-DRAFT-EXST-DT              
A03166         WHEN OTHER                                               
A03166             MOVE 12 TO RETURN-CODE                               
A03166             MOVE 'SELECT'       TO ABEND-FUNCTION                
A03166             MOVE SQLCODE        TO RS-RETURN-CODE                
A03166             MOVE '0795'         TO ACTIVE-PARAGRAPH              
A03166             PERFORM 9900-ABEND THRU 9900-EXIT                    
A03166     END-EVALUATE.                                                
A03166                                                                  
A03166 0795-EXIT.                                                       
A03166     EXIT.                                                        
                                                                        
      ***************************************************************   32050000
      * GET THE CONTRACT NAME DESCRIPTION FOR EACH CONTRACT AND         32060000
      * COUNT INSTALLMENTS USING TODAY'S DATE AND THE CONTRACT START    32070000
      * DATE.                                                           32080000
      ***************************************************************   32090000
                                                                        
       0800-CONTRACT-DATA.                                              
                                                                        
           MOVE WS-CNT-NAME-CD-CT (SUB1) TO K6-CNT-NAME-CD.             
           EXEC SQL                                                     
               SELECT CNT_NAME_DESC                                     
                 INTO :K6-CNT-NAME-DESC                                 
                 FROM CSS_CONTRACT_INFO WITH(READUNCOMMITTED)                   
                WHERE CNT_NAME_CD = :K6-CNT-NAME-CD                     
A03166                                                           
A03166                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     32140000
MFA-TR*        SELECT CNT_NAME_DESC                                     32150000
MFA-TR*          INTO :K6-CNT-NAME-DESC                                 32160000
MFA-TR*          FROM CSS_CONTRACT_INFO                                 32170000
MFA-TR*         WHERE CNT_NAME_CD = :K6-CNT-NAME-CD                     32180000
MFA-TR*         WITH UR                                                 26090000
MFA-TR*         QUERYNO 0800                                            26090000
MFA-TR*    END-EXEC.                                                    32190000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE K6-CNT-NAME-DESC TO                             
                        WS-CONTRACT-NAME-DESC-CALC (SUB1)               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-CONTRACT-NAME-DESC-CALC (SUB1)     
               WHEN OTHER                                               
                    MOVE 12 TO RETURN-CODE                              
                    MOVE 'SELECT'  TO ABEND-FUNCTION                    
                    MOVE SQLCODE   TO RS-RETURN-CODE                    
                    MOVE '0800'    TO ACTIVE-PARAGRAPH                  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
                                                                        
           INITIALIZE WS-INSTALLMENT-DATA.                              
           SET WS-AR-DATA-INDX TO +1.                                   
           SEARCH WS-AR-DATA                                            
               AT END                                                   
                   MOVE 0.00 TO WS-ID-TRAN-BALANCE                      
               WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZEROES         
                   MOVE 0.00 TO WS-ID-TRAN-BALANCE                      
               WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) =                
                    WS-ACCOUNT-NO-AT AND                                
                    WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = +100 AND
                    WS-ITEM-ID-AC (WS-AR-DATA-INDX) =                   
                    WS-CNT-ITEM-ID-CT (SUB1)                            
                        MOVE WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) TO
                             WS-ID-TRAN-BALANCE                         
           END-SEARCH.                                                  
                                                                        
       0800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   33900000
      * GET THE OPTIMUM READ DATE FOR THE NEXT REVENUE MONTH.           33910000
      ***************************************************************   33920000
                                                                        
       1000-NEXT-METER-READ-DATE.                                       
                                                                        
           MOVE WS-READ-CYCLE-UT (1) TO RW-READ-CYCLE.                  
           MOVE WS-NEXT-REV-MO TO RW-REVENUE-MONTH.                     
           EXEC SQL                                                     
               SELECT OPTIMUM_READ_DATE                                 
                 INTO :RW-OPTIMUM-READ-DATE :WS-NULL-IND-2              
                 FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                     
                WHERE READ_CYCLE = :RW-READ-CYCLE                       
                  AND REVENUE_MONTH = :RW-REVENUE-MONTH                 
A03166                                                           
A03166                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     33980000
MFA-TR*        SELECT OPTIMUM_READ_DATE                                 33990000
MFA-TR*          INTO :RW-OPTIMUM-READ-DATE :WS-NULL-IND-2              34000000
MFA-TR*          FROM CSS_READ_WINDOW                                   34010000
MFA-TR*         WHERE READ_CYCLE = :RW-READ-CYCLE                       34020000
MFA-TR*           AND REVENUE_MONTH = :RW-REVENUE-MONTH                 34030000
MFA-TR*         WITH UR                                                 26090000
MFA-TR*         QUERYNO 1000                                            26090000
MFA-TR*    END-EXEC.                                                    34040000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND-2 < 0                                 
                       MOVE SPACES TO WS-DATE-NEXT-METER-READ           
                   ELSE                                                 
                       MOVE RW-OPTIMUM-READ-DATE TO                     
                            WS-DATE-NEXT-METER-READ                     
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-DATE-NEXT-METER-READ               
               WHEN OTHER                                               
                    MOVE 12 TO RETURN-CODE                              
                    MOVE 'SELECT'  TO ABEND-FUNCTION                    
                    MOVE SQLCODE   TO RS-RETURN-CODE                    
                    MOVE '1000'    TO ACTIVE-PARAGRAPH                  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1700-GET-BILL-STMNT-ID.                                          
                                                                        
           MOVE WS-ACCOUNT-NO-AT TO  TA-ACCOUNT-NO.                     
                                                                        
           EXEC SQL                                                     
              SELECT SPCL_BILL_STMNT_TX                                 
                 INTO :TA-SPCL-BILL-STMNT-TX                            
                 FROM CSS_ACCT_MISC_INFO WITH(READUNCOMMITTED)                  
              WHERE ACCOUNT_NO = :TA-ACCOUNT-NO                         
A03166                                                           
A03166                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     38700000
MFA-TR*       SELECT SPCL_BILL_STMNT_TX                                 38710000
MFA-TR*          INTO :TA-SPCL-BILL-STMNT-TX                            38720000
MFA-TR*          FROM CSS_ACCT_MISC_INFO                                38730000
MFA-TR*       WHERE ACCOUNT_NO = :TA-ACCOUNT-NO                         38740000
MFA-TR*         WITH UR                                                 26090000
MFA-TR*         QUERYNO 1700                                            26090000
MFA-TR*    END-EXEC.                                                    38750000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE TA-SPCL-BILL-STMNT-TX TO                        
                        WS-SPCL-BILL-STMNT-TX-TA                        
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-SPCL-BILL-STMNT-TX-TA              
               WHEN OTHER                                               
                    MOVE 12 TO RETURN-CODE                              
                    MOVE 'SELECT'  TO ABEND-FUNCTION                    
                    MOVE SQLCODE   TO RS-RETURN-CODE                    
                    MOVE '1700'    TO ACTIVE-PARAGRAPH                  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
                                                                        
       1700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1800-CHECK-FOR-MV90.                                             
                                                                        
           SET WS-MTRD-INDX TO +1.                                      
           SEARCH WS-MTRD-ENVRNMT-DATA                                  
               WHEN WS-ACCOUNT-NO-MN (WS-MTRD-INDX) = ZEROES            
                   NEXT SENTENCE                                        
               WHEN WS-ACCOUNT-NO-MN (WS-MTRD-INDX) =                   
                    WS-ACCOUNT-NO-AT AND                                
                    WS-IC-NO-MN (WS-MTRD-INDX)=                         
                    WS-IC-NO-BG (SUB1) AND                              
                    WS-CODE-UTIL-TYPE-MN (WS-MTRD-INDX) =               
                    WS-CODE-UTIL-TYPE-BG (SUB1) AND                     
                    WS-CODE-METER-STATUS-MN (WS-MTRD-INDX) = 'A'        
                  MOVE WS-MTR-READ-SOURCE-CD-MN (WS-MTRD-INDX) TO       
                                            WS-MTR-READ-SOURCE-CD       
           END-SEARCH.                                                  
                                                                        
       1800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 40060000
      *  9700-PROCESS-ABEND.                                            40170000
                                                                        
       COPY CPD0023B.                                                   40190000
                                                                        
      *  REDUCE EMBEDDED BLANKS                                         40210000
                                                                        
       COPY CPD00004.                                                   40230000
                                                                        
       9900-ABEND.                                                      
           MOVE TABLE-1 TO WS-DB2-TABLE-ID.                             
           MOVE ABEND-FUNCTION TO WS-DB2-FUNCTION.                      
           MOVE RS-RETURN-CODE TO WS-DB2-RETURN-CODE.                   
           MOVE '186' TO WS-DB2-MODULE-ID.                              
           MOVE ACTIVE-PARAGRAPH TO WS-DB2-PARAGRAPH.                   
           MOVE HOSTVAR-ELEMENT-1 TO WS-DB2-KEY-1.                      
           MOVE HOSTVAR-ELEMENT-2 TO WS-DB2-KEY-2.                      
           MOVE 12 TO RETURN-CODE.                                      
           PERFORM 9999-BAIL-OUT                     THRU 9999-EXIT.    
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9910-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
                                                                        
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
                                                                        
ACT071        MOVE WS-PGRMNAME                                          
ACT071          TO WS-CREATED-BY-WF (WS-BILL-WQ-INDX)                   
ACT071                                                                  
              MOVE ZEROES        TO WS-BILL-NO-WQ                       
              MOVE SPACES TO WS-CODE-UTIL-TYPE-WQ                       
                             WS-RATE-PLAN-NO-WQ                         
              MOVE ZEROES TO WS-IC-NO-WQ                                
                                                                        
              COMPUTE WS-START-POS                                      
                = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1              
              MOVE WS-SUPPLEMENTAL-TXT-WQ                               
                TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)
              ADD WS-SUPPLEMENTAL-TXT-LEN-WQ                            
                TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX)                 
           END-IF.                                                      
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-BAIL-OUT.                                                   
                                                                        
           MOVE RETURN-CODE TO WS-SCSCA-RETURN-CODE.                    
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
