       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   SCSCA185.                                          
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                       PRICE WATERHOUSE                        *         
      *                                                               *         
      *                 CUSTOMER INFORMATION SYSTEM                   *         
      *                                                               *         
      *****************************************************************         
      *                 P R O G R A M   S U M M A R Y                 *         
      *                                                               *         
      **  THIS PROGRAM IS A SUB-ROUTINE THAT OBTAINS THE HISTORICAL  **         
      **  DATA FOR 13 MONTHS WHICH WILL INCLUDE THE NUMBER OF DAYS   **         
      **  DURING A BILLING CYCLE, KWH/THERMS CONSUMED DURING THE     **         
      **  CYCLE, AND THE AMOUNT BILLED FOR THE CYCLE GETTING THE     **         
      **  IC_NO, PREMISE_NO, CODE_UTIL_TYPE_ACCOUNT_NO, DEGREE_FLAG, **         
      **  CURRENT_DATE_READ, DATE_COMP AND METER_NO AS PARAMETER FROM**         
      **  THE CALLING PROGRAM.                                       **         
      *   THIS PROGRAM USES SOME OF CODE FROM CSR02101                *         
      *****************************************************************         
      *                                                               *         
      *               PROGRAM MODIFICATION LOG                        *         
      *  DATE        INITIALS     REASON                              *         
      *  --------    ---------    ----------------------------------- *         
      *  04/01/09    NC94746      PROGRAM TO FETCH 13 MONTHS          *         
      *                           HISTORICAL DATA                     *         
A00734*  03/04/10    MC95456      PROGRAM TO SKIP TEMPERATURE        *          
A00734*                           PROCESSING FOR SEB                  *         
PRJ251*  04/28/10    RAJ          NET METERING.                       *         
ACT015*  09/08/14    SIVA         FIX FOR PREVIOUS YEAR DATA BELOW    * 00110000
ACT015*              APPL4897     HISTORICAL DATA. TO DISPLAY NEGATIVE*         
ACT015*                           VALUES.                             *         
ACT071*  16/03/15    SS7F226      ADD CREATED-BY FIELD IN WF AREA.    *         
ACT071*               A04860                                          *         
      *****************************************************************         
      *                                                               *         
      *         -----    BASIC SEQUENCE STRUCTURE   -----             *         
      * 0000         MODULE CONTROL                                   *         
      * 0100 - 0999  INITIALIZATION                                   *         
      * 1000 - 1999  FUNCTIONAL CONTROL                               *         
      * 2000 - 4999  DETAIL LOGIC                                     *         
      * 5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES               *         
      * 6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)     *         
      * 7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.    *         
      * 8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC    *         
      * 9000 - 9999  ABEND / ERROR ROUTINES.                          *         
      *                                                               *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-SERV-DIV  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-TEMPERATURE  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA185'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-TAB-HISTORY.                                              
           05 WS-TAB-HIST-ROW            OCCURS 100 TIMES.              
              15 WS-TAB-REV-MONTH        PIC  9(6).                     
              15 WS-TAB-BILL-NO          PIC S9(4) COMP.                
COB305        15 WS-TAB-BILL-AMT        PIC S9(9)V9(2) COMP-3 VALUE 0.         
              15 WS-TAB-NO-DAYS          PIC S9(4) COMP.                
COB305        15 WS-TAB-NO-UNITS        PIC S9(9)V COMP-3 VALUE 0.             
              15 WS-TAB-DATE-READ        PIC  X(10).                    
COB305        15 WS-TAB-ACTUAL-NO-UNITS        PIC S9(9)V COMP-3 
COB305           VALUE 0.             
       01  WS-13MONTH-HIST.                                             
           05 WS-XOF13-ROW               OCCURS 13 TIMES.               
              15 WS-ARR-MONTH-INI        PIC  X(1).                     
              15 WS-ARR-REV-MONTH        PIC  9(6).                     
              15 WS-ARR-BILL-NO          PIC S9(4) COMP.                
COB305        15 WS-ARR-BILL-AMT        PIC S9(9)V9(2) COMP-3 VALUE 0.         
              15 WS-ARR-NO-DAYS          PIC S9(4) COMP.                
COB305        15 WS-ARR-NO-UNITS        PIC S9(9)V COMP-3 VALUE 0.             
              15 WS-ARR-DATE-READ        PIC  X(10).                    
COB305        15 WS-ARR-ACTUAL-NO-UNITS        PIC S9(9)V COMP-3 
COB305           VALUE 0.             
       01  WS-MISC-VAR.                                                 
           05  WS-PREMISE-NO               PIC X(10).                   
           05  WS-ACCOUNT-NO               PIC 9(13).                   
           05  WS-IC-NO                    PIC S9(4) COMP.              
           05  WS-CODE-UTIL-TYPE           PIC X(01).                   
           05  WS-TEMP-REV-MONTH           PIC 9(06).                   
           05  FILLER REDEFINES WS-TEMP-REV-MONTH.                      
              10 WS-TEMP-REV-CCYY         PIC 9(04).                    
              10 WS-TEMP-REV-MM           PIC 9(02).                    
           05 WS-REV-MM-SIGN              PIC S9(02).                   
COB305     05 WS-CURR-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-1ST-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-13TH-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-14TH-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.      
           05 WS-THIS-REV-MONTH           PIC  9(6).                    
           05 WS-NEXT-REV-MONTH           PIC  9(6).                    
           05 WS-THIS-MONTH-CNT           PIC S9(4) COMP.               
           05 WS-NEXT-MONTH-CNT           PIC S9(4) COMP.               
           05 THIS-LAST-SUB               PIC  9(3).                    
           05 NEXT-1ST-SUB                PIC  9(3).                    
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
            05 RS-RETURN-CODE        PIC S9(9) COMP VALUE 0.            
       01  WS-LOCAL-OFFICE-TBL.                                         
           05 WS-LOCAL-OFFICE-DATA.                                     
              10 WS-COMPANY             PIC X(02) OCCURS 200 TIMES.     
              10 WS-LOCAL-OFF           PIC X(03) OCCURS 200 TIMES.     
              10 WS-SERV-DIV            PIC X(01) OCCURS 200 TIMES.     
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08) VALUE 'SCSCA185'.    
      *                                                                         
       01  WS-MISC-VARIABLES.                                           
           05  SUB-IDX                     PIC 9(09) COMP-3 VALUE 0.    
           05  SUB1                        PIC 9(3) VALUE 0.            
           05  SUB2                        PIC 9(3) VALUE 0.            
           05  SUB-I                       PIC 9(3) VALUE 0.            
           05  SUB-J                       PIC 9(3) VALUE 0.            
           05  SUB13                       PIC 9(3) VALUE 0.            
           05  SUB100                      PIC 9(4) VALUE 0.            
           05  WS-DIVX                     PIC S9(4) VALUE 0.           
           05  WS-YEAR-FLAG                PIC X(01) VALUE SPACES.      
               88 CURRENT-YR                         VALUE 'Y'.         
               88 PREVOUS-YR                         VALUE 'N'.         
           05  WS-START-DATE               PIC X(10).                   
           05  WS-END-DATE                 PIC X(10).                   
           05  WS-90-DAYS-PRIOR            PIC X(10).                   
           05  WS-1-YR-PRIOR               PIC X(10).                   
           05  WS-90-DAYS-1-PRIOR          PIC X(10).                   
           05  WS-HIT-TABLE-SW             PIC X(01).                   
               88 HIT-TEMP-TABLE           VALUE 'Y'.                   
           05  WS-ENDING-DATE              PIC X(10).                   
           05  WS-STARTING-DATE            PIC X(10).                   
           05  WS-CURR-ENDING-DATE         PIC X(10).                   
           05  WS-CURR-STARTING-DATE       PIC X(10).                   
           05  WS-PREV-ENDING-DATE         PIC X(10).                   
           05  WS-PREV-STARTING-DATE       PIC X(10).                   
           05  WS-TEMPA-HIGH               PIC S9(3)V COMP-3 VALUE 0.   
           05  WS-TEMPA-LOW                PIC S9(3)V COMP-3 VALUE 0.   
           05  WS-SUM-TEMP                 PIC S9(9) COMP-3 VALUE 0.    
           05  WS-AVERAGE-TEMP             PIC S9(9) COMP-3 VALUE 0.    
           05  WS-COMPUTE-TEMP             PIC S9(9)V99 COMP-3 VALUE 0. 
           05  WS-COUNT-TEMPS              PIC S9(4) COMP VALUE 0.      
           05  WS-WTHER-SERV-DIV           PIC X(01).                   
           05  WS-DIVISION-FLAG            PIC X(01).                   
           05  WS-END-FLAG                 PIC X(01) VALUE 'Y'.         
           05  WS-START-FLAG               PIC X(01) VALUE 'Y'.         
           05  WS-NULL-IND                 PIC S9(04) COMP.             
           05  WS-NULL-IND-1               PIC S9(04) COMP.             
           05  WS-NULL-IND-2               PIC S9(04) COMP.             
           05  WS-NULL-IND-3               PIC S9(04) COMP.             
           05  WS-NULL-IND-4               PIC S9(04) COMP.             
           05  WS-NO-UNITS                 PIC S9(9)V COMP-3 VALUE 0.   
ACT015     05  WS-ACTUAL-NO-UNITS          PIC S9(9)V COMP-3 VALUE 0.   
           05  WS-ANY-NO-DAYS              PIC S9(4)  COMP.             
A00734     05  WS-CURR-TEMPERATURE         PIC S9(3)  COMP VALUE 0.     
A00734     05  WS-PREV-TEMPERATURE         PIC S9(3)  COMP VALUE 0.     
           05  WS-ROW-COUNT                PIC S9(09) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  FILLER                  PIC S9(4) COMP VALUE +121.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  WS-MISC-MSG-LEN         PIC S9(4) COMP VALUE +250.   
               10  WS-MISC-MSG-TEXT        PIC X(100).                  
           05  WS-START-POS                PIC S9(4) COMP.              
           05  WS-LOCAL-OFFICE             PIC X(03).                   
      *                                                                         
       01  WS-MISC-HOST-VARIABLES.                                      
           05  WS-TEMP-DT                  PIC X(10) OCCURS 90 TIMES.   
COB305     05 WS-COLA-LOW        PIC S9(3)V USAGE COMP-3 
COB305       OCCURS 90 TIMES VALUE 0.   
COB305     05 WS-COLA-HIGH        PIC S9(3)V USAGE COMP-3 
COB305       OCCURS 90 TIMES VALUE 0.   
COB305     05 WS-CHAS-LOW        PIC S9(3)V USAGE COMP-3 
COB305       OCCURS 90 TIMES VALUE 0.   
COB305     05 WS-CHAS-HIGH        PIC S9(3)V USAGE COMP-3 
COB305       OCCURS 90 TIMES VALUE 0.   
COB305     05 WS-AIKEN-LOW        PIC S9(3)V USAGE COMP-3 
COB305       OCCURS 90 TIMES VALUE 0.   
COB305     05 WS-AIKEN-HIGH        PIC S9(3)V USAGE COMP-3 
COB305       OCCURS 90 TIMES VALUE 0.   
           05  WS-B1-NULL-IND              PIC S9(4) COMP               
                                                     OCCURS 100 TIMES.  
           05  WS-B1-COMPANY-NO            PIC X(2) OCCURS 100 TIMES.   
           05  WS-B1-LOCAL-OFFICE          PIC X(3) OCCURS 100 TIMES.   
           05  WS-B1-WEATHER-SERV-DIV      PIC X(1) OCCURS 100 TIMES.   
      *                                                                         
      *01  LOC1                  USAGE IS SQL TYPE IS                           
      *                          RESULT-SET-LOCATOR VARYING.                    
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *  DCLGEN FOR CSS_BILLING_DET                                             
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *  DCLGEN FOR CSS_CNSMPTN_HIST                                            
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
      *  DCLGEN FOR CSS_TEMPERATURE                                             
           EXEC SQL                                                             
                INCLUDE TBTEMPIN                                                
           END-EXEC.                                                            
      *  DCLGEN FOR CSS_BILL_CALC_DET                                           
           EXEC SQL                                                             
               INCLUDE TBBLCLDT                                                 
           END-EXEC.                                                            
      *  DCLGEN FOR CSS_LOCAL_OFFICE                                            
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *  DCLGEN FOR CSS_RATE_PLAN_DESC                                          
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
      *                                                                         
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
      *                                                                         
      *****************************************************************         
      *  THIS COPYBOOK IS USED WITH THE CPD09900 INCLUDE MEMBER       *         
      *  WHICH INVOKES THE ABEND ROUTINE                              *         
      *****************************************************************         
       COPY CWS09900.                                                           
      *****************************************************************         
      *   SUPPLEMENTAL WQ TEXT                                        * 03760000
      ***************************************************************** 03770000
       COPY CWS0070B.                                                   03780000
      *                                                                 03770000
       COPY CWS00010.                                                           
      *                                                                         
       COPY CWS00185.                                                           
      *****************************************************************         
      *  CURSOR TO GET TEMPERATURE FROM CSS_TEMPERATURE TABLE         *         
      *****************************************************************         
           EXEC SQL                                                     
                DECLARE TEMPERATURE CURSOR WITH ROWSET POSITIONING FOR  
                SELECT TEMP_DT,                                         
                       COLA_LOW,                                        
                       COLA_HIGH,                                       
                       CHAS_LOW,                                        
                       CHAS_HIGH,                                       
                       AIKEN_LOW,                                       
                       AIKEN_HIGH                                       
                FROM CSS_TEMPERATURE WITH(READUNCOMMITTED)                      
                WHERE TEMP_DT BETWEEN IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ) AND                
                                      IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )                      
                  AND COMPANY_NO =    :E8-COMPANY-NO                    
                ORDER BY TEMP_DT DESC                                   
           FOR READ ONLY                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE TEMPERATURE CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*         SELECT TEMP_DT,                                                 
MFA-TR*                COLA_LOW,                                                
MFA-TR*                COLA_HIGH,                                               
MFA-TR*                CHAS_LOW,                                                
MFA-TR*                CHAS_HIGH,                                               
MFA-TR*                AIKEN_LOW,                                               
MFA-TR*                AIKEN_HIGH                                               
MFA-TR*         FROM CSS_TEMPERATURE                                            
MFA-TR*         WHERE TEMP_DT BETWEEN :WS-START-DATE AND                        
MFA-TR*                               :WS-END-DATE                              
MFA-TR*           AND COMPANY_NO =    :E8-COMPANY-NO                            
MFA-TR*         ORDER BY TEMP_DT DESC                                           
MFA-TR*    FOR FETCH ONLY WITH UR                                               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CURSOR TO GET SERVICE DIVISION AND LOCAL OFFICE ID FROM      *         
      *  CSS_LOCAL_OFFICE TABLE.                                      *         
      *****************************************************************         
           EXEC SQL                                                     
      *         DECLARE SERV_DIV CURSOR FOR                                     
               DECLARE SERV_DIV CURSOR WITH ROWSET POSITIONING FOR      
                SELECT COMPANY_NO,                                      
                       LOCAL_OFFICE,                                    
                       COALESCE(WEATHER_SERV_DIV, ' ')                    
                FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                     
           FOR READ ONLY                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE SERV_DIV CURSOR FOR                                     
MFA-TR*        DECLARE SERV_DIV CURSOR WITH ROWSET POSITIONING FOR      02010034
MFA-TR*         SELECT COMPANY_NO,                                              
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                IFNULL(WEATHER_SERV_DIV, ' ')                            
MFA-TR*         FROM CSS_LOCAL_OFFICE                                           
MFA-TR*    FOR FETCH ONLY WITH UR                                               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
             DECLARE BG-CURSOR CURSOR FOR                               
             SELECT BG.BILL_NO                                          
                ,REPLACE(REPLACE(CONVERT(CHAR(26), BG.BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP                     
                ,BG.AMT_BILL_ITEM                                       
                ,BG.CODE_DR_CR_CNSMPTN                                  
                ,BG.AMT_STATE_TAX                                       
                ,CASE                                                   
                   WHEN BG.REV_MTH_ORIG_BILL > 0                        
                      THEN BG.REV_MTH_ORIG_BILL                         
                      ELSE BG.REVENUE_MONTH                             
                      END                                               
                ,BG.NO_OF_CONS_DAYS                                     
              FROM CSS_BILLING_DET  BG WITH(READUNCOMMITTED)                    
              WHERE  BG.ACCOUNT_NO         = :BG-ACCOUNT-NO             
                AND  BG.PREMISE_NO         = :BG-PREMISE-NO             
                AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE         
                AND  BG.IC_NO              = :BG-IC-NO                  
                AND  BG.CODE_BILL_CALC     = 'A'                        
                AND  BG.CODE_BILL_ITM_TYPE = 'C'                        
                AND  BG.CODE_BILL_ITM_IND  = 'A'                        
                AND (BG.REV_MTH_ORIG_BILL BETWEEN :WS-14TH-REV-MONTH    
                                              AND :WS-1ST-REV-MONTH     
                    OR                                                  
                    (BG.REVENUE_MONTH     BETWEEN :WS-14TH-REV-MONTH    
                                              AND :WS-1ST-REV-MONTH     
                     AND BG.REV_MTH_ORIG_BILL = 0 ))                    
A00734           ORDER BY 1 DESC                                        
A00734                   ,6 DESC                                        
           FOR READ ONLY                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE BG-CURSOR CURSOR FOR                                       
MFA-TR*      SELECT BG.BILL_NO                                                  
MFA-TR*         ,BG.BILL_ITEM_TIMESTMP                                          
MFA-TR*         ,BG.AMT_BILL_ITEM                                               
MFA-TR*         ,BG.CODE_DR_CR_CNSMPTN                                          
MFA-TR*         ,BG.AMT_STATE_TAX                                               
MFA-TR*         ,CASE                                                           
MFA-TR*            WHEN BG.REV_MTH_ORIG_BILL > 0                                
MFA-TR*               THEN BG.REV_MTH_ORIG_BILL                                 
MFA-TR*               ELSE BG.REVENUE_MONTH                                     
MFA-TR*               END                                                       
MFA-TR*         ,BG.NO_OF_CONS_DAYS                                             
MFA-TR*       FROM CSS_BILLING_DET  BG                                          
MFA-TR*       WHERE  BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                     
MFA-TR*         AND  BG.PREMISE_NO         = :BG-PREMISE-NO                     
MFA-TR*         AND  BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                 
MFA-TR*         AND  BG.IC_NO              = :BG-IC-NO                          
MFA-TR*         AND  BG.CODE_BILL_CALC     = 'A'                                
MFA-TR*         AND  BG.CODE_BILL_ITM_TYPE = 'C'                                
MFA-TR*         AND  BG.CODE_BILL_ITM_IND  = 'A'                                
MFA-TR*         AND (BG.REV_MTH_ORIG_BILL BETWEEN :WS-14TH-REV-MONTH            
MFA-TR*                                       AND :WS-1ST-REV-MONTH             
MFA-TR*             OR                                                          
MFA-TR*             (BG.REVENUE_MONTH     BETWEEN :WS-14TH-REV-MONTH            
MFA-TR*                                       AND :WS-1ST-REV-MONTH             
MFA-TR*              AND BG.REV_MTH_ORIG_BILL = 0 ))                            
MFA-TR*          ORDER BY 1 DESC                                                
MFA-TR*                  ,6 DESC                                                
MFA-TR*    FOR FETCH ONLY WITH UR                                               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                         PIC X(40)                     
           VALUE 'WORKING STORAGE FOR SCSCA185 ENDS HERE  '.            
HPCCDM*    EJECT                                                                
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       COPY CWS1000B.                                                   07120000
      *                                                                         
PRJ251 COPY CWSCA185.                                                   07120000
      *                                                                         
       01  WS-CURRENT-DATE                 PIC X(10).                   
      *                                                                         
       01  WS-TEMP-CALC-FLAG               PIC X(01).                   
A00734 01  WS-READ-TEMPR-TBL               PIC X(01).                   
      *                                                                         
      *                                                                         
       01  WS-SCSCA-RETURN-CODE            PIC S9(4) COMP.              
      *                                                                         
       01 LS-CURR-WQ-ITEM                  PIC S9(4) COMP.              
      *                                                                         
       01  WS-BILLING-WQ-ITEMS-WF.                                      
           05  WS-BILLING-WQ-ITEMS-DATA-WF                              
                   OCCURS 50 TIMES INDEXED BY WS-BILL-WQ-INDX.          
               10  WS-CATEGORY-ID-WF               PIC S9(04)  COMP.    
               10  WS-PRIORITY-WF                  PIC X(1).            
               10  WS-ROUTE-CATEGORY-WF            PIC X(01).           
               10  WS-COMMENTS-WF.                                      
                   15  WS-COMMENTS-LEN-WF          PIC S9(04)  COMP.    
                   15  WS-COMMENTS-TEXT-WF         PIC X(250).          
ACT071         10  WS-CREATED-BY-WF                PIC X(16).           
ACT071         10  FILLER                          PIC X(228).          
      *                                                                         
       PROCEDURE DIVISION USING WS-ACCOUNT-AT                           
                                WS-BILLING-BG                           
                                WS-SCSCA-RETURN-CODE                    
                                WS-HISTORICAL-TBL                       
                                WS-CURRENT-DATE                         
                                WS-TEMP-CALC-FLAG                       
A00734                          WS-READ-TEMPR-TBL                       
                                LS-CURR-WQ-ITEM                         
                                WS-CWS1000B-MAX-TBL-LIMITS              
                                WS-BILLING-WQ-ITEMS-WF.                 
      *                                                                         
      *================================================================*        
       0000-MAINLINE.                                                   
      *================================================================*        
      *                                                                         
           DISPLAY 'SCSCA185 - HISTORICAL DATA'.                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
      *                                                                         
      *** CHECKS FOR FIRST TIME CALL AND POPULATE TWO WORKING STORAGE           
      *** TEMPERATURE TABLES & SERVICE DIVISION WORKINGSTORAGE TABLE            
           IF WS-TEMP-CALC-FLAG  = 'Y'                                  
              PERFORM 0200-LOAD-TEMPERATURE          THRU  0200-EXIT    
              PERFORM 0300-LOAD-SERVICE-DIV          THRU  0300-EXIT    
              MOVE 'N'                     TO WS-TEMP-CALC-FLAG         
           END-IF.                                                      
      ***    OBTAIN HISTORICAL DATA FOR BG ROWS                   ****          
           PERFORM 1000-PROCESS-BE00-BG-ROWS  THRU 1000-EXIT            
              VARYING SUB1 FROM 1 BY 1 UNTIL SUB1 > WS-BG-MAX-ENTRY     
                              OR WS-ACCOUNT-NO-BG (SUB1) <= ZEROES.     
           EXIT PROGRAM.                                                
      *                                                                         
       0000-EXIT.                                                       
            GOBACK.                                                     
HPCCDM*     EJECT                                                               
      *                                                                         
       0100-INITIALIZE.                                                 
      ******************************************************************        
      * INITIALIZATION                                                 *        
      ******************************************************************        
      *                                                                         
           INITIALIZE                        WS-AVERAGE-TEMP            
                                             WS-COMPUTE-TEMP            
                                             WS-SUM-TEMP                
                                             WS-COUNT-TEMPS             
                                             WS-HISTORICAL-TBL.         
           MOVE SPACES                       TO WS-WTHER-SERV-DIV.      
           MOVE 'N'                          TO WS-DIVISION-FLAG.       
           MOVE ZEROS                                TO SUB1            
                                                        SUB-I.          
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
HPCCDM*    EJECT                                                                
      *                                                                         
      ******************************************************************        
      * GATHER THE 90 DAYS TEMPERATURE ENDING TODAY AND FOR THE SAME   *        
      * RANGE PREVIOUS YEAR AND HOLD IT IN TEMPORARY TABLE             *        
      ******************************************************************        
      *                                                                         
       0200-LOAD-TEMPERATURE.                                           
      *                                                                         
           PERFORM 7150-90-DAYS-PRIOR-DATE       THRU 7150-EXIT.        
           PERFORM 7160-1-YEAR-PRIOR-DATE        THRU 7160-EXIT.        
           PERFORM 7170-90-DAYS-PRIOR-LAST-YEAR  THRU 7170-EXIT.        
      *                                                                         
           MOVE WS-COMPANY-NO-AT              TO E8-COMPANY-NO.         
           MOVE WS-90-DAYS-PRIOR              TO WS-START-DATE.         
           MOVE WS-CURRENT-DATE               TO WS-END-DATE.           
           SET CURR-IDX                       TO 1.                     
           SET CURRENT-YR                     TO TRUE.                  
           MOVE 1                             TO SUB-IDX.               
           PERFORM 0250-TEMP-DATA             THRU 0250-EXIT.           
      *                                                                         
           MOVE WS-90-DAYS-1-PRIOR            TO WS-START-DATE.         
           MOVE WS-1-YR-PRIOR                 TO WS-END-DATE.           
           SET ONEYR-IDX                      TO 1.                     
           SET PREVOUS-YR                     TO TRUE.                  
           MOVE 1                             TO SUB-IDX.               
           PERFORM 0250-TEMP-DATA             THRU 0250-EXIT.           
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * TEMPERATURE DATA IS OBTAINED USING THE TEMPERATURE CURSOR.     *        
      * DATA IS THEN LOADED TO WORKING STORAGE TABLE.                  *        
      ******************************************************************        
      *                                                                         
       0250-TEMP-DATA.                                                  
      *                                                                         
           PERFORM 7225-OPEN-TEMP-CURSOR      THRU 7225-EXIT.           
           PERFORM 7250-FETCH-TEMP-CURSOR     THRU 7250-EXIT.           
           IF CURRENT-YR                                                
              PERFORM 0430-LOAD-CURR-TEMP-TBL THRU 0430-EXIT            
              UNTIL CURR-IDX > WS-ROW-COUNT                             
           ELSE                                                         
              PERFORM 0440-LOAD-1YR-TEMP-TBL THRU 0440-EXIT             
              UNTIL ONEYR-IDX > WS-ROW-COUNT                            
           END-IF.                                                      
           PERFORM 7275-CLOSE-TEMP-CURSOR     THRU 7275-EXIT.           
      *                                                                         
       0250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DUMP SERVICE DIVISION AND LOCAL OFFICE ID FROM                 *        
      * CSS_LOCAL_OFFICE TABLE TO AVOID HITTING THE DATABASE FOR       *        
      * EVERY ACCOUNT.                                                 *        
      ******************************************************************        
      *                                                                         
       0300-LOAD-SERVICE-DIV.                                           
      *                                                                         
           PERFORM 7600-OPEN-SER-DIV-CURSOR   THRU 7600-EXIT.           
      *                                                                         
           MOVE 0                            TO WS-ROW-COUNT            
           INITIALIZE  WS-LOCAL-OFFICE-DATA                             
           PERFORM 7610-FETCH-SER-DIV-CURSOR  THRU 7610-EXIT            
      *                                                                         
           PERFORM 7620-CLOSE-SER-DIV-CURSOR  THRU 7620-EXIT.           
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  LOAD CURRENT TEMPERATURE TABLE                         *               
      ************************************************************              
      *                                                                         
       0430-LOAD-CURR-TEMP-TBL.                                         
      *                                                                         
           MOVE WS-TEMP-DT(SUB-IDX)         TO WS-CURR-READ-DT(CURR-IDX)
           MOVE WS-COLA-LOW(SUB-IDX)        TO                          
                                            WS-CURR-COLA-LOW(CURR-IDX)  
           MOVE WS-COLA-HIGH(SUB-IDX)       TO                          
                                            WS-CURR-COLA-HIGH(CURR-IDX) 
           MOVE WS-CHAS-LOW(SUB-IDX)        TO                          
                                            WS-CURR-CHAS-LOW(CURR-IDX)  
           MOVE WS-CHAS-HIGH(SUB-IDX)       TO                          
                                            WS-CURR-CHAS-HIGH(CURR-IDX) 
           MOVE WS-AIKEN-LOW(SUB-IDX)       TO WS-CURR-AIK-LOW(CURR-IDX)
           MOVE WS-AIKEN-HIGH(SUB-IDX)      TO                          
                                            WS-CURR-AIK-HIGH(CURR-IDX)  
           MOVE E8-COMPANY-NO               TO                          
                                            WS-CURR-COMPANY-NO(CURR-IDX)
                                                                        
           SET CURR-IDX UP BY 1.                                        
           ADD 1           TO SUB-IDX.                                  
      *                                                                         
       0430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  LOAD PREVIOUS TEMPERATURE TABLE                         *              
      ************************************************************              
      *                                                                         
       0440-LOAD-1YR-TEMP-TBL.                                          
      *                                                                         
           MOVE WS-TEMP-DT(SUB-IDX)         TO                          
                                            WS-ONE-YR-READ-DT(ONEYR-IDX)
           MOVE WS-COLA-LOW(SUB-IDX)        TO                          
                                           WS-ONE-YR-COLA-LOW(ONEYR-IDX)
           MOVE WS-COLA-HIGH(SUB-IDX)       TO                          
                                          WS-ONE-YR-COLA-HIGH(ONEYR-IDX)
           MOVE WS-CHAS-LOW(SUB-IDX)        TO                          
                                           WS-ONE-YR-CHAS-LOW(ONEYR-IDX)
           MOVE WS-CHAS-HIGH(SUB-IDX)       TO                          
                                          WS-ONE-YR-CHAS-HIGH(ONEYR-IDX)
           MOVE WS-AIKEN-LOW(SUB-IDX)       TO                          
                                            WS-ONE-YR-AIK-LOW(ONEYR-IDX)
           MOVE WS-AIKEN-HIGH(SUB-IDX)      TO                          
                                           WS-ONE-YR-AIK-HIGH(ONEYR-IDX)
           MOVE E8-COMPANY-NO               TO                          
                                         WS-ONE-YR-COMPANY-NO(ONEYR-IDX)
                                                                        
           SET ONEYR-IDX  UP BY        1                                
           ADD 1          TO SUB-IDX.                                   
      *                                                                         
       0440-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       1000-PROCESS-BE00-BG-ROWS.                                       
      *===============================================================*         
      *                                                                         
           IF WS-CODE-UTIL-TYPE-BG(SUB1) NOT EQUAL TO 'U' AND           
              WS-CODE-BILL-CALC-BG(SUB1) NOT EQUAL TO 'S'               
              MOVE WS-RATE-PLAN-NO-BG(SUB1)    TO RD-RATE-PLAN-NO       
              MOVE WS-CODE-UTIL-TYPE-BG(SUB1)  TO RD-CODE-UTIL-TYPE     
              PERFORM  7200-CHECK-RATE-PLAN    THRU 7200-EXIT           
              IF RD-UNMTR-PROV-FL  = 'Y'                                
                 GO TO 1000-EXIT                                        
              END-IF                                                    
              INITIALIZE                     WS-13MONTH-HIST            
                                             TDS-RETURN-FIELDS          
                                             WS-AVERAGE-TEMP            
                                             WS-COMPUTE-TEMP            
                                             WS-SUM-TEMP                
                                             WS-COUNT-TEMPS             
              MOVE WS-LOCAL-OFFICE-AT              TO WS-LOCAL-OFFICE   
              MOVE WS-PREMISE-NO-BG(SUB1)          TO WS-PREMISE-NO     
              MOVE WS-ACCOUNT-NO-BG(SUB1)          TO WS-ACCOUNT-NO     
              MOVE WS-IC-NO-BG(SUB1)               TO WS-IC-NO          
              MOVE WS-CODE-UTIL-TYPE-BG(SUB1)      TO                   
                                                      WS-CODE-UTIL-TYPE 
      *                                                                         
A00734        IF WS-DIVISION-FLAG = 'N' AND WS-READ-TEMPR-TBL = 'Y'     
                 PERFORM 2500-GET-SERV-DIV          THRU 2500-EXIT      
              END-IF                                                    
              PERFORM 2025-GET-REV-MONTH-BG      THRU 2025-EXIT         
              IF WS-1ST-REV-MONTH > 0                                   
                 PERFORM 2000-PROCESS-14BILLS       THRU 2000-EXIT      
                 PERFORM 2100-LINK-HIST-TABLE       THRU 2100-EXIT      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
       2000-PROCESS-14BILLS.                                            
      *===============================================================*         
      *                                                                         
           INITIALIZE    WS-TAB-HISTORY                                 
           MOVE ZERO                TO SUB100                           
           MOVE WS-IC-NO            TO BG-IC-NO.                        
           MOVE WS-PREMISE-NO       TO BG-PREMISE-NO.                   
           MOVE WS-CODE-UTIL-TYPE   TO BG-CODE-UTIL-TYPE.               
           MOVE WS-ACCOUNT-NO       TO BG-ACCOUNT-NO.                   
           PERFORM 7100-OPEN-BG-CURSOR  THRU  7100-EXIT.                
           PERFORM 7110-FETCH-BG-ROW    THRU  7110-EXIT.                
           PERFORM 2200-PROCESS-EACH-BG     THRU 2200-EXIT              
                       UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
           PERFORM 7120-CLOSE-BG-CURSOR THRU 7120-EXIT.                 
           PERFORM 2300-XTRACT13-FROM-ARR THRU 2300-EXIT.               
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
      *                                                                         
      *===============================================================*         
       2025-GET-REV-MONTH-BG.                                           
      *                                                                         
           MOVE ZEROS                  TO WS-1ST-REV-MONTH              
                                          WS-CURR-REV-MONTH             
           PERFORM VARYING SUB2 FROM 1 BY 1 UNTIL SUB2 > 30             
                  OR WS-ACCOUNT-NO-BG (SUB2) <= ZEROES                  
           IF WS-CODE-BILL-CALC-BG(SUB2) NOT EQUAL TO 'S'               
              AND WS-ACCOUNT-NO-BG(SUB2)     = WS-ACCOUNT-NO            
              AND WS-IC-NO-BG(SUB2)          = WS-IC-NO                 
              AND WS-CODE-UTIL-TYPE-BG(SUB2) = WS-CODE-UTIL-TYPE        
                                                                        
              IF WS-REV-MTH-ORIG-BILL-BG (SUB2)IS NUMERIC               
                 AND WS-REV-MTH-ORIG-BILL-BG (SUB2) > ZERO              
                 MOVE WS-REV-MTH-ORIG-BILL-BG (SUB2)                    
                                       TO WS-CURR-REV-MONTH             
              ELSE                                                      
                 MOVE WS-REVENUE-MONTH-BG (SUB2)                        
                                       TO WS-CURR-REV-MONTH             
              END-IF                                                    
              IF WS-CURR-REV-MONTH > WS-1ST-REV-MONTH                   
                 MOVE WS-CURR-REV-MONTH  TO WS-1ST-REV-MONTH            
              END-IF                                                    
           END-IF                                                       
           END-PERFORM.                                                 
           IF WS-1ST-REV-MONTH IS NUMERIC                               
              AND WS-1ST-REV-MONTH > 0                                  
              MOVE WS-1ST-REV-MONTH    TO WS-TEMP-REV-MONTH             
              COMPUTE WS-TEMP-REV-CCYY = WS-TEMP-REV-CCYY - 1           
              MOVE WS-TEMP-REV-MONTH   TO WS-13TH-REV-MONTH             
              COMPUTE WS-TEMP-REV-MM   = WS-TEMP-REV-MM - 1             
              IF WS-TEMP-REV-MM = ZEROS                                 
                 MOVE 12               TO WS-TEMP-REV-MM                
                 COMPUTE WS-TEMP-REV-CCYY = WS-TEMP-REV-CCYY - 1        
              END-IF                                                    
              MOVE WS-TEMP-REV-MONTH   TO WS-14TH-REV-MONTH             
           ELSE                                                         
              MOVE ZEROS               TO WS-1ST-REV-MONTH              
                                          WS-13TH-REV-MONTH             
                                          WS-14TH-REV-MONTH             
           END-IF.                                                      
      *                                                                         
       2025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2100-LINK-HIST-TABLE.                                            
      *                                                                         
           COMPUTE SUB-I            = SUB-I + 1                         
           MOVE WS-ACCOUNT-NO       TO WS-HIST-ACCOUNT-NO(SUB-I)        
           MOVE WS-CODE-UTIL-TYPE   TO WS-HIST-UTILITY-TYPE(SUB-I)      
           MOVE WS-IC-NO            TO WS-HIST-IC-NO(SUB-I)             
           PERFORM 2350-GET-CURR-PREV-DTL   THRU 2350-EXIT              
           MOVE 13                  TO SUB-J                            
           PERFORM VARYING SUB13 FROM 1 BY 1 UNTIL SUB13 > 13           
               MOVE WS-ARR-DATE-READ(SUB13)                             
                               TO WS-HIST-READ-DATE(SUB-I SUB-J)        
               MOVE WS-ARR-NO-UNITS(SUB13)                              
                               TO WS-HIST-UNITS-CONSUMED(SUB-I SUB-J)   
               MOVE WS-ARR-MONTH-INI (SUB13)                            
                               TO WS-HIST-CONSUMED-MONTH(SUB-I SUB-J)   
               COMPUTE SUB-J = SUB-J - 1                                
           END-PERFORM.                                                 
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================*         
      *                                                                         
      *===============================================================*         
      *                                                                         
       2200-PROCESS-EACH-BG.                                            
                                                                        
           IF BG-CODE-DR-CR-CNSMPTN = 'C'                               
              COMPUTE BG-AMT-BILL-ITEM = BG-AMT-BILL-ITEM * -1          
           END-IF.                                                      
           COMPUTE BG-AMT-BILL-ITEM = BG-AMT-BILL-ITEM                  
                                         - BG-AMT-STATE-TAX.            
                                                                        
           MOVE BG-ACCOUNT-NO          TO CX-ACCOUNT-NO.                
           MOVE BG-CODE-UTIL-TYPE      TO CX-CODE-UTIL-TYPE.            
           MOVE BG-IC-NO               TO CX-IC-NO.                     
           MOVE BG-BILL-NO             TO CX-BILL-NO.                   
           MOVE BG-BILL-ITEM-TIMESTMP  TO CX-BILL-ITEM-TIMESTMP.        
                                                                        
           MOVE SPACES                 TO CX-DATE-READ.                 
           INITIALIZE CX-NO-DAYS.                                       
           PERFORM 7625-GET-CX-DAYS        THRU 7625-EXIT.              
           PERFORM 7650-GET-READ-DATE-CX THRU 7650-EXIT.                
                                                                        
           MOVE BG-ACCOUNT-NO          TO BZ-ACCOUNT-NO.                
           MOVE BG-CODE-UTIL-TYPE      TO BZ-CODE-UTIL-TYPE.            
           MOVE BG-IC-NO               TO BZ-IC-NO.                     
           MOVE BG-BILL-NO             TO BZ-BILL-NO.                   
           MOVE BG-BILL-ITEM-TIMESTMP  TO BZ-BILL-ITEM-TIMESTMP.        
                                                                        
           MOVE ZEROS                  TO WS-NO-UNITS                   
ACT015                                    WS-ACTUAL-NO-UNITS.           
           INITIALIZE BZ-BILL-UNITS.                                    
           PERFORM 7500-GET-BZ-DATA     THRU  7500-EXIT.                
ACT015     MOVE BZ-BILL-UNITS          TO WS-ACTUAL-NO-UNITS.           
PRJ251     IF BZ-BILL-UNITS < 0                                         
PRJ251        COMPUTE BZ-BILL-UNITS = BZ-BILL-UNITS * -1                
PRJ251     END-IF                                                       
           MOVE BZ-BILL-UNITS          TO WS-NO-UNITS.                  
                                                                        
           PERFORM 2250-LOAD-WORK-TABLE THRU 2250-EXIT.                 
           PERFORM 7110-FETCH-BG-ROW    THRU 7110-EXIT.                 
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      *================================================================*        
      *                                                                         
       2250-LOAD-WORK-TABLE.                                            
      *                                                                         
           COMPUTE SUB100     =  SUB100 + 1                             
           IF SUB100 <= 100                                             
              MOVE BG-REVENUE-MONTH    TO WS-TAB-REV-MONTH(SUB100)      
              MOVE BG-BILL-NO          TO WS-TAB-BILL-NO  (SUB100)      
              MOVE BG-AMT-BILL-ITEM    TO WS-TAB-BILL-AMT (SUB100)      
              MOVE CX-NO-DAYS          TO WS-TAB-NO-DAYS  (SUB100)      
              MOVE WS-NO-UNITS         TO WS-TAB-NO-UNITS (SUB100)      
ACT015        MOVE WS-ACTUAL-NO-UNITS  TO WS-TAB-ACTUAL-NO-UNITS(SUB100)
              MOVE CX-DATE-READ        TO WS-TAB-DATE-READ(SUB100)      
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '  BILL/CONS HISTORY WORKIG STORAGE '             
              DISPLAY '       TABLE EXCEEDS THE SIZE      '             
              DISPLAY 'ERROR PARA: 2250-LOAD-WORK-TABLE   '             
              DISPLAY 'TABLE: WS-TAB-HIST-ROW             '             
              DISPLAY 'ACCOUNT-NO: '   BG-ACCOUNT-NO                    
              DISPLAY 'UTIL-TYPE:  '   BG-CODE-UTIL-TYPE                
              DISPLAY 'IC-NO:      '   BG-IC-NO                         
              DISPLAY '***********************************'             
              MOVE +16                TO RETURN-CODE                    
              PERFORM 9999-BAIL-OUT   THRU 9999-EXIT                    
           END-IF.                                                      
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*22950000
      ***  POPULATE 13 CONTIGUOUS REV MONTHS & ITS INITIALS STATING             
      ***  BACK FROM CURRENT BILLING MONTH                                      
      *================================================================*22950000
      *                                                                         
       2300-XTRACT13-FROM-ARR.                                          
      *                                                                 20470000
           MOVE WS-1ST-REV-MONTH       TO WS-TEMP-REV-MONTH             
           PERFORM VARYING SUB13 FROM 1 BY 1 UNTIL SUB13 > 13           
             MOVE WS-TEMP-REV-MONTH TO WS-ARR-REV-MONTH(SUB13)          
             EVALUATE WS-TEMP-REV-MM                                    
               WHEN 1 WHEN 6 WHEN 7                                     
                 MOVE 'J' TO WS-ARR-MONTH-INI (SUB13)                   
               WHEN 2                                                   
                 MOVE 'F' TO WS-ARR-MONTH-INI (SUB13)                   
               WHEN 3 WHEN 5                                            
                 MOVE 'M' TO WS-ARR-MONTH-INI (SUB13)                   
               WHEN 4 WHEN 8                                            
                 MOVE 'A' TO WS-ARR-MONTH-INI (SUB13)                   
               WHEN 9                                                   
                 MOVE 'S' TO WS-ARR-MONTH-INI (SUB13)                   
               WHEN 10                                                  
                 MOVE 'O' TO WS-ARR-MONTH-INI (SUB13)                   
               WHEN 11                                                  
                 MOVE 'N' TO WS-ARR-MONTH-INI (SUB13)                   
               WHEN 12                                                  
                 MOVE 'D' TO WS-ARR-MONTH-INI (SUB13)                   
             END-EVALUATE                                               
             COMPUTE WS-TEMP-REV-MM = WS-TEMP-REV-MM - 1                
             IF WS-TEMP-REV-MM = ZEROS                                  
                MOVE 12               TO WS-TEMP-REV-MM                 
                COMPUTE WS-TEMP-REV-CCYY = WS-TEMP-REV-CCYY - 1         
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 20760000
           PERFORM VARYING SUB13 FROM 1 BY 1 UNTIL SUB13 > 13           
             MOVE WS-ARR-REV-MONTH(SUB13) TO WS-THIS-REV-MONTH          
             IF SUB13 < 13                                              
                MOVE WS-ARR-REV-MONTH(SUB13 + 1) TO WS-NEXT-REV-MONTH   
             ELSE                                                       
                MOVE WS-14TH-REV-MONTH           TO WS-NEXT-REV-MONTH   
             END-IF                                                     
             MOVE ZEROS       TO WS-THIS-MONTH-CNT                      
                                 WS-NEXT-MONTH-CNT                      
                                 THIS-LAST-SUB                          
                                 NEXT-1ST-SUB                           
             PERFORM VARYING SUB100 FROM 1 BY 1 UNTIL SUB100 > 100      
                                 OR WS-TAB-REV-MONTH(SUB100) = 0        
               IF WS-THIS-REV-MONTH = WS-TAB-REV-MONTH(SUB100)          
                  COMPUTE WS-THIS-MONTH-CNT = WS-THIS-MONTH-CNT + 1     
                  MOVE SUB100          TO THIS-LAST-SUB                 
               END-IF                                                   
               IF WS-NEXT-REV-MONTH = WS-TAB-REV-MONTH(SUB100)          
                  COMPUTE WS-NEXT-MONTH-CNT = WS-NEXT-MONTH-CNT + 1     
                  IF NEXT-1ST-SUB = ZEROS                               
                     MOVE SUB100       TO NEXT-1ST-SUB                  
                  END-IF                                                
               END-IF                                                   
             END-PERFORM                                                
                                                                        
             EVALUATE TRUE                                              
               WHEN WS-THIS-MONTH-CNT = 1                               
                 MOVE WS-TAB-BILL-NO(THIS-LAST-SUB)                     
                                       TO WS-ARR-BILL-NO(SUB13)         
                 MOVE WS-TAB-BILL-AMT(THIS-LAST-SUB)                    
                                      TO WS-ARR-BILL-AMT(SUB13)         
                 MOVE WS-TAB-NO-DAYS(THIS-LAST-SUB)                     
                                      TO WS-ARR-NO-DAYS(SUB13)          
                 MOVE WS-TAB-NO-UNITS(THIS-LAST-SUB)                    
                                       TO WS-ARR-NO-UNITS(SUB13)        
ACT015           MOVE WS-TAB-ACTUAL-NO-UNITS(THIS-LAST-SUB)             
ACT015                                 TO WS-ARR-ACTUAL-NO-UNITS(SUB13) 
                 MOVE WS-TAB-DATE-READ(THIS-LAST-SUB)                   
                                       TO WS-ARR-DATE-READ(SUB13)       
               WHEN WS-THIS-MONTH-CNT = 0                               
                 IF WS-NEXT-MONTH-CNT > 1                               
                    MOVE WS-TAB-BILL-NO(NEXT-1ST-SUB)                   
                                       TO WS-ARR-BILL-NO(SUB13)         
                    MOVE WS-TAB-BILL-AMT(NEXT-1ST-SUB)                  
                                       TO WS-ARR-BILL-AMT(SUB13)        
                    MOVE WS-TAB-NO-DAYS(NEXT-1ST-SUB)                   
                                       TO WS-ARR-NO-DAYS(SUB13)         
                    MOVE WS-TAB-NO-UNITS(NEXT-1ST-SUB)                  
                                       TO WS-ARR-NO-UNITS(SUB13)        
ACT015              MOVE WS-TAB-ACTUAL-NO-UNITS(NEXT-1ST-SUB)           
ACT015                                 TO WS-ARR-ACTUAL-NO-UNITS(SUB13) 
                    MOVE WS-TAB-DATE-READ(NEXT-1ST-SUB)                 
                                       TO WS-ARR-DATE-READ(SUB13)       
                    MOVE WS-THIS-REV-MONTH                              
                                       TO WS-TAB-REV-MONTH(NEXT-1ST-SUB)
                 ELSE                                                   
                    MOVE ZEROS       TO WS-ARR-BILL-NO(SUB13)           
                                        WS-ARR-BILL-AMT(SUB13)          
                                        WS-ARR-NO-DAYS(SUB13)           
                                        WS-ARR-NO-UNITS(SUB13)          
ACT015                                  WS-ARR-ACTUAL-NO-UNITS(SUB13)   
                    MOVE SPACES      TO WS-ARR-DATE-READ(SUB13)         
                 END-IF                                                 
               WHEN WS-THIS-MONTH-CNT > 1                               
                 IF WS-NEXT-MONTH-CNT = 0                               
                    MOVE WS-NEXT-REV-MONTH                              
                                    TO WS-TAB-REV-MONTH(THIS-LAST-SUB)  
                 END-IF                                                 
                 PERFORM VARYING SUB100 FROM 1 BY 1                     
                                 UNTIL SUB100 > 100                     
                                 OR WS-TAB-REV-MONTH(SUB100) = 0        
                   IF WS-THIS-REV-MONTH = WS-TAB-REV-MONTH(SUB100)      
                      IF WS-TAB-DATE-READ(SUB100)                       
                                     > WS-ARR-DATE-READ(SUB13)          
                         MOVE WS-TAB-BILL-AMT(SUB100)                   
                           TO WS-ARR-BILL-AMT(SUB13)                    
                         MOVE WS-TAB-NO-DAYS(SUB100)                    
                           TO WS-ARR-NO-DAYS(SUB13)                     
                         MOVE WS-TAB-NO-UNITS(SUB100)                   
                           TO WS-ARR-NO-UNITS(SUB13)                    
ACT015                   MOVE WS-TAB-ACTUAL-NO-UNITS(SUB100)            
ACT015                     TO WS-ARR-ACTUAL-NO-UNITS(SUB13)             
                         MOVE WS-TAB-DATE-READ(SUB100)                  
                                       TO WS-ARR-DATE-READ(SUB13)       
                         MOVE WS-TAB-BILL-NO(SUB100)                    
                                       TO WS-ARR-BILL-NO(SUB13)         
                      END-IF                                            
                   END-IF                                               
                 END-PERFORM                                            
             END-EVALUATE                                               
           END-PERFORM.                                                 
      *                                                                 20760000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2350-GET-CURR-PREV-DTL.                                          
      *================================================================*        
      *                                                                         
           MOVE WS-ARR-BILL-AMT(1)       TO WS-HIST-CURR-AMOUNT(SUB-I)  
           MOVE WS-ARR-NO-DAYS(1)        TO WS-HIST-CURR-NO-DAYS(SUB-I) 
           MOVE WS-ARR-NO-UNITS(1)       TO WS-HIST-CURR-USAGE(SUB-I)   
      *                                                                         
           MOVE WS-ARR-BILL-AMT(13)      TO WS-HIST-PREV-AMOUNT(SUB-I)  
           MOVE WS-ARR-NO-DAYS(13)       TO WS-HIST-PREV-NO-DAYS(SUB-I) 
           MOVE WS-ARR-NO-UNITS(13)      TO WS-HIST-PREV-USAGE(SUB-I)   
ACT015     MOVE WS-ARR-ACTUAL-NO-UNITS(13) TO                           
ACT015                                 WS-HIST-ACTUAL-PREV-USAGE(SUB-I) 
                                                                        
A00734     IF WS-READ-TEMPR-TBL = 'Y'                                   
A00734        PERFORM 2400-GET-TEMPERATURE THRU 2400-EXIT               
A00734        MOVE WS-CURR-TEMPERATURE     TO                           
A00734                                 WS-HIST-CURR-TEMPERATURE(SUB-I)  
A00734        MOVE WS-PREV-TEMPERATURE     TO                           
A00734                                 WS-HIST-PREV-TEMPERATURE(SUB-I)  
A00734     END-IF.                                                      
                                                                        
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * CALCULATE THE CURRENT MONTH AND PREVIOUS MONTH AVERAGE         *        
      * TEMPERATURE.                                                   *        
      *================================================================*        
      *                                                                         
       2400-GET-TEMPERATURE.                                            
      *                                                                         
      ***********SETTING THE START AND END DATES TO CALCULATE                   
      ***********THE AVERAGE TEMPERATURE                                        
           MOVE SPACES                   TO WS-CURR-ENDING-DATE         
                                            WS-CURR-STARTING-DATE       
                                            WS-PREV-ENDING-DATE         
                                            WS-PREV-STARTING-DATE       
           IF WS-ARR-DATE-READ(1) > SPACES                              
              MOVE WS-ARR-DATE-READ(1)       TO WS-CURR-ENDING-DATE     
           END-IF.                                                      
           IF WS-ARR-DATE-READ(2) > SPACES                              
              MOVE WS-ARR-DATE-READ(2)    TO WS-CURR-STARTING-DATE      
           ELSE                                                         
              MOVE WS-CURR-ENDING-DATE    TO WS-ENDING-DATE             
              IF WS-ARR-NO-DAYS(1) > 0                                  
                 MOVE WS-ARR-NO-DAYS(1) TO WS-ANY-NO-DAYS               
                 PERFORM 7000-GET-START-DATE   THRU 7000-EXIT           
                 MOVE WS-STARTING-DATE    TO WS-CURR-STARTING-DATE      
              ELSE                                                      
                 MOVE WS-CURR-ENDING-DATE TO WS-CURR-STARTING-DATE      
              END-IF                                                    
           END-IF.                                                      
      ********SEARCH THE DATE RANGES AGAINST THE WORKING STORAGE                
      ********TEMPERATURE TABLE IF AVAILABE THE AVERAGE TEMPERATURE             
      ********WILL BE CALCULATED WITHOUT HITTING DB2                            
           IF WS-CURR-ENDING-DATE > SPACES                              
             AND WS-CURR-STARTING-DATE > SPACES                         
              INITIALIZE                    WS-AVERAGE-TEMP             
                                            WS-COMPUTE-TEMP             
                                            WS-SUM-TEMP                 
                                            WS-COUNT-TEMPS              
              MOVE 'N'     TO WS-HIT-TABLE-SW                           
              MOVE 'N'     TO WS-END-FLAG                               
              MOVE 'N'     TO WS-START-FLAG                             
              PERFORM VARYING CURR-IDX FROM 1 BY 1 UNTIL CURR-IDX > 90  
                                             OR WS-HIT-TABLE-SW = 'Y'   
                IF WS-CURR-COMPANY-NO(CURR-IDX) = WS-COMPANY-NO-AT      
                  IF WS-CURR-READ-DT(CURR-IDX) = WS-CURR-STARTING-DATE  
                     MOVE 'Y'                   TO WS-START-FLAG        
                  END-IF                                                
                  IF WS-CURR-READ-DT(CURR-IDX) = WS-CURR-ENDING-DATE    
                     MOVE 'Y'                   TO WS-END-FLAG          
                  END-IF                                                
                  IF WS-START-FLAG = 'Y' AND WS-END-FLAG = 'Y'          
                     MOVE 'Y'                   TO WS-HIT-TABLE-SW      
                  END-IF                                                
                 IF (WS-CURR-READ-DT(CURR-IDX) <= WS-CURR-ENDING-DATE   
                 AND WS-CURR-READ-DT(CURR-IDX) >= WS-CURR-STARTING-DATE)
                   EVALUATE WS-WTHER-SERV-DIV                           
                     WHEN '1'                                           
                      MOVE WS-CURR-COLA-HIGH(CURR-IDX) TO WS-TEMPA-HIGH 
                      MOVE WS-CURR-COLA-LOW(CURR-IDX)  TO WS-TEMPA-LOW  
                     WHEN '2'                                           
                      MOVE WS-CURR-CHAS-HIGH(CURR-IDX) TO WS-TEMPA-HIGH 
                      MOVE WS-CURR-CHAS-LOW(CURR-IDX)  TO WS-TEMPA-LOW  
                     WHEN '3'                                           
                      MOVE WS-CURR-AIK-HIGH(CURR-IDX)  TO WS-TEMPA-HIGH 
                      MOVE WS-CURR-AIK-LOW(CURR-IDX)   TO WS-TEMPA-LOW  
                   END-EVALUATE                                         
                   IF WS-TEMPA-LOW > 0                                  
                      ADD WS-TEMPA-LOW             TO WS-SUM-TEMP       
                      ADD 1                        TO WS-COUNT-TEMPS    
                   END-IF                                               
                   IF WS-TEMPA-HIGH > 0                                 
                      ADD WS-TEMPA-HIGH            TO WS-SUM-TEMP       
                      ADD 1                        TO WS-COUNT-TEMPS    
                   END-IF                                               
                   IF WS-COUNT-TEMPS = 0                                
                      MOVE 0 TO WS-AVERAGE-TEMP                         
                   ELSE                                                 
                      COMPUTE WS-COMPUTE-TEMP =                         
                                                WS-SUM-TEMP /           
                                                WS-COUNT-TEMPS          
                      COMPUTE WS-AVERAGE-TEMP ROUNDED =                 
                                                WS-COMPUTE-TEMP * 1     
                   END-IF                                               
                END-IF                                                  
                END-IF                                                  
              END-PERFORM                                               
              IF NOT HIT-TEMP-TABLE                                     
                 MOVE ZEROS                       TO WS-AVERAGE-TEMP    
                 MOVE WS-CURR-STARTING-DATE       TO WS-START-DATE      
                 MOVE WS-CURR-ENDING-DATE         TO WS-END-DATE        
                 MOVE WS-COMPANY-NO-AT            TO E8-COMPANY-NO      
A00734           MOVE ZEROS                       TO E8-COLA-HIGH       
A00734                                               E8-CHAS-HIGH       
A00734                                               E8-AIKEN-HIGH      
A00734                                               WS-NULL-IND-2      
A00734                                               WS-NULL-IND-3      
A00734                                               WS-NULL-IND-4      
                 PERFORM 7175-SELECT-TEMPERATURE  THRU 7175-EXIT        
                 EVALUATE WS-WTHER-SERV-DIV                             
                     WHEN '1'                                           
                         MOVE E8-COLA-HIGH TO WS-AVERAGE-TEMP           
                     WHEN '2'                                           
                         MOVE E8-CHAS-HIGH TO WS-AVERAGE-TEMP           
                     WHEN '3'                                           
                         MOVE E8-AIKEN-HIGH TO WS-AVERAGE-TEMP          
                 END-EVALUATE                                           
              END-IF                                                    
              MOVE WS-AVERAGE-TEMP       TO WS-CURR-TEMPERATURE         
           END-IF.                                                      
      ***********************************************************               
      *************PREV TEMPERATURE CALCULATION******************               
      ***********************************************************               
           IF WS-ARR-DATE-READ(13) > SPACES                             
              MOVE WS-ARR-DATE-READ(13)      TO WS-PREV-ENDING-DATE     
                                                WS-ENDING-DATE          
              IF WS-ARR-NO-DAYS(13) > 0                                 
                 MOVE WS-ARR-NO-DAYS(13) TO WS-ANY-NO-DAYS              
                 PERFORM 7000-GET-START-DATE   THRU 7000-EXIT           
                 MOVE WS-STARTING-DATE    TO WS-PREV-STARTING-DATE      
              ELSE                                                      
                 MOVE WS-PREV-ENDING-DATE TO WS-PREV-STARTING-DATE      
              END-IF                                                    
           END-IF.                                                      
           IF WS-PREV-ENDING-DATE > SPACES                              
             AND WS-PREV-STARTING-DATE > SPACES                         
              INITIALIZE                    WS-AVERAGE-TEMP             
                                            WS-COMPUTE-TEMP             
                                            WS-SUM-TEMP                 
                                            WS-COUNT-TEMPS              
              MOVE 'N'                   TO WS-HIT-TABLE-SW             
              MOVE 'N'                   TO WS-END-FLAG                 
              MOVE 'N'                   TO WS-START-FLAG               
      ********SEARCH THE DATE RANGES AGAINST THE WORKING STORAGE                
      ********TEMPERATURE TABLE IF AVAILABE THE AVERAGE TEMPERATURE             
      ********WILL BE CALCULATED WITHOUT HITTING DB2                            
            PERFORM VARYING ONEYR-IDX FROM 1 BY 1 UNTIL ONEYR-IDX > 90  
                                             OR WS-HIT-TABLE-SW = 'Y'   
               IF WS-ONE-YR-COMPANY-NO(ONEYR-IDX) = WS-COMPANY-NO-AT    
                IF WS-ONE-YR-READ-DT(ONEYR-IDX) = WS-PREV-STARTING-DATE 
                     MOVE 'Y'                   TO WS-START-FLAG        
                END-IF                                                  
                IF WS-ONE-YR-READ-DT(ONEYR-IDX) = WS-PREV-ENDING-DATE   
                     MOVE 'Y'                   TO WS-END-FLAG          
                END-IF                                                  
                IF WS-START-FLAG = 'Y' AND WS-END-FLAG = 'Y'            
                     MOVE 'Y'                   TO WS-HIT-TABLE-SW      
                END-IF                                                  
              IF (WS-ONE-YR-READ-DT(ONEYR-IDX) <= WS-PREV-ENDING-DATE   
              AND WS-ONE-YR-READ-DT(ONEYR-IDX) >= WS-PREV-STARTING-DATE)
              EVALUATE WS-WTHER-SERV-DIV                                
                WHEN '1'                                                
                   MOVE WS-ONE-YR-COLA-HIGH(ONEYR-IDX) TO WS-TEMPA-HIGH 
                   MOVE WS-ONE-YR-COLA-LOW(ONEYR-IDX)  TO WS-TEMPA-LOW  
                WHEN '2'                                                
                   MOVE WS-ONE-YR-CHAS-HIGH(ONEYR-IDX) TO WS-TEMPA-HIGH 
                   MOVE WS-ONE-YR-CHAS-LOW(ONEYR-IDX)  TO WS-TEMPA-LOW  
                WHEN '3'                                                
                   MOVE WS-ONE-YR-AIK-HIGH(ONEYR-IDX)  TO WS-TEMPA-HIGH 
                   MOVE WS-ONE-YR-AIK-LOW(ONEYR-IDX)   TO WS-TEMPA-LOW  
              END-EVALUATE                                              
              IF WS-TEMPA-LOW > 0                                       
                 ADD WS-TEMPA-LOW                   TO WS-SUM-TEMP      
                 ADD 1                              TO WS-COUNT-TEMPS   
              END-IF                                                    
              IF WS-TEMPA-HIGH > 0                                      
                 ADD WS-TEMPA-HIGH                  TO WS-SUM-TEMP      
                 ADD 1                              TO WS-COUNT-TEMPS   
              END-IF                                                    
              END-IF                                                    
              END-IF                                                    
              IF WS-COUNT-TEMPS = 0                                     
                 MOVE 0 TO WS-AVERAGE-TEMP                              
              ELSE                                                      
                 COMPUTE WS-COMPUTE-TEMP =                              
                                           WS-SUM-TEMP /                
                                           WS-COUNT-TEMPS               
                 COMPUTE WS-AVERAGE-TEMP ROUNDED =                      
                                           WS-COMPUTE-TEMP * 1          
              END-IF                                                    
              END-PERFORM                                               
              IF NOT HIT-TEMP-TABLE                                     
                 MOVE ZEROS                        TO WS-AVERAGE-TEMP   
                 MOVE WS-PREV-STARTING-DATE        TO WS-START-DATE     
                 MOVE WS-PREV-ENDING-DATE          TO WS-END-DATE       
                 MOVE WS-COMPANY-NO-AT             TO E8-COMPANY-NO     
A00734           MOVE ZEROS                        TO E8-COLA-HIGH      
A00734                                                E8-CHAS-HIGH      
A00734                                                E8-AIKEN-HIGH     
A00734                                                WS-NULL-IND-2     
A00734                                                WS-NULL-IND-3     
A00734                                                WS-NULL-IND-4     
                 PERFORM 7175-SELECT-TEMPERATURE  THRU 7175-EXIT        
                 EVALUATE WS-WTHER-SERV-DIV                             
                     WHEN '1'                                           
                        MOVE E8-COLA-HIGH TO WS-AVERAGE-TEMP            
                     WHEN '2'                                           
                        MOVE E8-CHAS-HIGH TO WS-AVERAGE-TEMP            
                     WHEN '3'                                           
                        MOVE E8-AIKEN-HIGH TO WS-AVERAGE-TEMP           
                 END-EVALUATE                                           
              END-IF                                                    
              MOVE WS-AVERAGE-TEMP       TO WS-PREV-TEMPERATURE         
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      *================================================================*22950000
      *          GET SERVICE DIVISION BASED ON LO & COMPANY                     
      *================================================================*22950000
      *                                                                 20470000
       2500-GET-SERV-DIV.                                               
           MOVE SPACES                 TO WS-WTHER-SERV-DIV             
SCA006     PERFORM VARYING WS-DIVX FROM 1 BY 1 UNTIL 
                   WS-DIVISION-FLAG = 'Y' OR 
                                                     WS-DIVX > 200 OR 
                                                     
                   WS-COMPANY(WS-DIVX) = SPACES             
              IF WS-COMPANY(WS-DIVX)   = WS-COMPANY-NO-AT AND           
                 WS-LOCAL-OFF(WS-DIVX) = WS-LOCAL-OFFICE                
                 MOVE WS-SERV-DIV(WS-DIVX)       TO WS-WTHER-SERV-DIV   
                 MOVE 'Y'                        TO WS-DIVISION-FLAG    
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                 20760000
           IF WS-DIVISION-FLAG = 'N'                                    
               STRING 'DIVISION NOT FOUND ON TABLE FOR'                 
                      WS-LOCAL-OFFICE                                   
                      DELIMITED BY SIZE                                 
                      INTO WS-MISC-MSG-TEXT                             
               MOVE +35 TO WS-MISC-MSG-LEN                              
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
           END-IF.                                                      
      *                                                                 20760000
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20760000
      *================================================================*        
      *                                                                         
      *================================================================*        
      *                                                                 20760000
       7000-GET-START-DATE.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -:WS-ANY-NO-DAYS, IIF(TRY_CONVERT(DATE, 
                                                        :WS-ENDING-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ENDING-DATE
              ) <> 0) OR (LEN(:WS-ENDING-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-ENDING-DATE
              ), CONVERT(DATE, :WS-ENDING-DATE) ) )
            INTO
              :WS-STARTING-DATE      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-STARTING-DATE  = DATE(:WS-ENDING-DATE)                    
MFA-TR*                                     - :WS-ANY-NO-DAYS DAYS              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    SCSCA185 - PARA: 7000    **'               
              DISPLAY '** SELECTING CURRENT END  DATE **'               
              DISPLAY '**    SQL CODE = ' SQLCODE                       
              DISPLAY '**    END DATE ' WS-ENDING-DATE                  
              DISPLAY '**    ANY NO DAYS ' WS-ANY-NO-DAYS               
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE 'CURRENT STARTING DATE'        TO TABLE-1            
              MOVE 'SET'                          TO ABEND-FUNCTION     
              MOVE SQLCODE                        TO RS-RETURN-CODE     
              MOVE '7000'                         TO ACTIVE-PARAGRAPH   
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **        
      **  ROWS FROM THE CSS_BILLING_DET TABLE.                        **        
      ******************************************************************        
      *                                                                         
       7100-OPEN-BG-CURSOR.                                             
      *                                                                         
           MOVE '7100'               TO ACTIVE-PARAGRAPH.               
      *                                                                         
           EXEC SQL                                                     
               OPEN BG-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '**    SCSCA185 - PROCESSING ERROR **** '         
              DISPLAY '**    7100-OPEN-BG-CURSOR      **'               
              DISPLAY '**    ERROR ON OPEN   '                          
              DISPLAY '**    RETURN CODE ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**    TABLE CSS_BILLING_DET'                     
              DISPLAY '**    KEY IS  '                                  
              DISPLAY '**    BG.PREMISE_NO      '  BG-PREMISE-NO        
              DISPLAY '**    BG.ACCOUNT_NO      '  BG-ACCOUNT-NO        
              DISPLAY '**    BG.CODE_UTIL_TYPE  '  BG-CODE-UTIL-TYPE    
              DISPLAY '**    BG.IC_NO           '  BG-IC-NO             
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN '                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET  '        TO TABLE-1                
              MOVE 'PREMISE_NO    '           TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE '          TO TABLE-ELEMENT-3        
              MOVE 'IC_NO          '          TO TABLE-ELEMENT-4        
              MOVE BG-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BG-IC-NO                   TO HOSTVAR-ELEMENT-4      
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **        
      **  CSS_BILLING_DET TABLE WHERE THE PREMISE NUMBER IS EQUAL TO  **        
      **  THE PREMISE NUMBER PASSED TO THIS PROGRAM VIA THE           **        
      **  COMMUNICATION AREA PREMISE NUMBER AND THE BILL NUMBER IS    **        
      **  EQUAL THE CURRENT CSS_BILLING_HDR ROW BILL NUMBER.          **        
      ******************************************************************        
       7110-FETCH-BG-ROW.                                               
      *                                                                         
           MOVE '7110'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
               FETCH BG-CURSOR                                          
               INTO :BG-BILL-NO                                         
                   ,:BG-BILL-ITEM-TIMESTMP                              
                   ,:BG-AMT-BILL-ITEM                                   
                   ,:BG-CODE-DR-CR-CNSMPTN                              
                   ,:BG-AMT-STATE-TAX                                   
                   ,:BG-REVENUE-MONTH                                   
                   ,:BG-NO-OF-CONS-DAYS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '**    SCSCA185 - PROCESSING ERROR **** '         
              DISPLAY '**    7110-FETCH-BG-ROW         **'              
              DISPLAY '**    ERROR ON FETCH  '                          
              DISPLAY '**    RETURN CODE ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**    TABLE CSS_BILLING_DET'                     
              DISPLAY '**    KEY IS  '                                  
              DISPLAY '**    BG.ACCOUNT_NO      '  BG-ACCOUNT-NO        
              DISPLAY '**    BG.PREMISE_NO      '  BG-PREMISE-NO        
              DISPLAY '**    BG.CODE_UTIL_TYPE  '  BG-CODE-UTIL-TYPE    
              DISPLAY '**    BG.IC_NO           '  BG-IC-NO             
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET  '        TO TABLE-1                
              MOVE 'PREMISE_NO    '           TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO          '          TO TABLE-ELEMENT-4        
              MOVE BG-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BG-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_BILLING_DET TABLE.                        **        
      ******************************************************************        
      *                                                                         
       7120-CLOSE-BG-CURSOR.                                            
      *                                                                         
           MOVE '7120'               TO ACTIVE-PARAGRAPH.               
      *                                                                         
           EXEC SQL                                                     
               CLOSE BG-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              DISPLAY '**    SCSCA185 - PROCESSING ERROR **** '         
              DISPLAY '**    7120-CLOSE-BG-CURSOR      **'              
              DISPLAY '**    ERROR ON CLOSE  '                          
              DISPLAY '**    RETURN CODE ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**    TABLE CSS_BILLING_DET'                     
              DISPLAY '**    KEY IS  '                                  
              DISPLAY '**    BG.ACCOUNT_NO      '  BG-ACCOUNT-NO        
              DISPLAY '**    BG.PREMISE_NO      '  BG-PREMISE-NO        
              DISPLAY '**    BG.CODE_UTIL_TYPE  '  BG-CODE-UTIL-TYPE    
              DISPLAY '**    BG.IC_NO           '  BG-IC-NO             
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_BILLING_DET  '        TO TABLE-1                
              MOVE 'PREMISE_NO    '           TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'IC_NO          '          TO TABLE-ELEMENT-4        
              MOVE BG-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE BG-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  RETRIEVE 90 DAYS PRIOR TO CURRENT DATE                  *              
      ************************************************************              
      *                                                                         
       7150-90-DAYS-PRIOR-DATE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -89, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-90-DAYS-PRIOR
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-90-DAYS-PRIOR   = DATE(:WS-CURRENT-DATE) - 89 DAYS        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    SCSCA185 - PARA: 7150    **'               
              DISPLAY '** SELECTING 90 DAYS PRIOR DATE **'              
              DISPLAY '**    SQL CODE = ' SQLCODE                       
              DISPLAY '** WS-CURRENT-DATE ' WS-CURRENT-DATE             
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE '90 DAYS PRIOR'                TO TABLE-1            
              MOVE '7150'                         TO ACTIVE-PARAGRAPH   
              MOVE 'SET'                          TO ABEND-FUNCTION     
              MOVE SQLCODE                        TO RS-RETURN-CODE     
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  RETRIEVE LAST YEAR THIS DATE                            *              
      ************************************************************              
      *                                                                         
       7160-1-YEAR-PRIOR-DATE.                                          
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( YEAR, -1, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-1-YR-PRIOR 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-1-YR-PRIOR      = DATE(:WS-CURRENT-DATE) - 1 YEAR         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**    SCSCA185 - PARA: 7160    **'               
              DISPLAY '** SELECTING 1 YEAR PRIOR DATE **'               
              DISPLAY '**    SQL CODE = ' SQLCODE                       
              DISPLAY '** WS-CURRENT-DATE ' WS-CURRENT-DATE             
              DISPLAY '**    PROCESSING TERMINATED    **'               
              MOVE '1 YEAR PRIOR'                 TO TABLE-1            
              MOVE 'SET'                          TO ABEND-FUNCTION     
              MOVE SQLCODE                        TO RS-RETURN-CODE     
              MOVE '7160'                         TO ACTIVE-PARAGRAPH   
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  RETRIEVE 90 DAYS PRIOR LAST YEAR THIS DATE              *              
      ************************************************************              
      *                                                                         
       7170-90-DAYS-PRIOR-LAST-YEAR.                                    
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -89, IIF(TRY_CONVERT(DATE, :WS-1-YR-PRIOR
              ) IS NULL OR (PATINDEX('%.%', :WS-1-YR-PRIOR
              ) <> 0) OR (LEN(:WS-1-YR-PRIOR) <> 10), CIS.CHAR2DATE(
                                                         :WS-1-YR-PRIOR
              ), CONVERT(DATE, :WS-1-YR-PRIOR) ) )
            INTO
              :WS-90-DAYS-1-PRIOR  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-90-DAYS-1-PRIOR = DATE(:WS-1-YR-PRIOR) - 89 DAYS          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**        SCSCA185 - PARA: 7170        **'       
              DISPLAY '** SELECTING 90 DAYS 1 YEAR PRIOR DATE **'       
              DISPLAY '**    SQL CODE = ' SQLCODE                       
              DISPLAY '** WS-1-YR-PRIOR   ' WS-1-YR-PRIOR               
              DISPLAY '**        PROCESSING TERMINATED        **'       
              MOVE '1 YEAR PRIOR 90 DAYS'         TO TABLE-1            
              MOVE 'SET'                          TO ABEND-FUNCTION     
              MOVE SQLCODE                        TO RS-RETURN-CODE     
              MOVE '7170'                         TO ACTIVE-PARAGRAPH   
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * GET TEMPARATURE FROM DB WHEN REQUIRED DATA NOT PRESENT IN               
      * WORKING STORAGE TEMPARATURE TABLES.                                     
      *----------------------------------------------------------------*        
      *                                                                         
       7175-SELECT-TEMPERATURE.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT AVG ((IIF(TRY_CAST(COLA_LOW AS INT) IS NULL, 
              CIS.INTEGER(COLA_LOW), CAST(COLA_LOW AS INT)) + 
              IIF(TRY_CAST(COLA_HIGH AS INT) IS NULL, CIS.INTEGER(
           COLA_HIGH), CAST(COLA_HIGH AS INT))) / 2 ),     
                       AVG ((IIF(TRY_CAST(CHAS_LOW AS INT) IS NULL, 
              CIS.INTEGER(CHAS_LOW), CAST(CHAS_LOW AS INT)) + 
              IIF(TRY_CAST(CHAS_HIGH AS INT) IS NULL, CIS.INTEGER(
           CHAS_HIGH), CAST(CHAS_HIGH AS INT))) / 2 ),     
                       AVG ((IIF(TRY_CAST(AIKEN_LOW AS INT) IS NULL, 
              CIS.INTEGER(AIKEN_LOW), CAST(AIKEN_LOW AS INT)) + 
              IIF(TRY_CAST(AIKEN_HIGH AS INT) IS NULL, CIS.INTEGER(
           AIKEN_HIGH), CAST(AIKEN_HIGH AS INT))) / 2 )    
                  INTO :E8-COLA-HIGH :WS-NULL-IND-2,                    
                       :E8-CHAS-HIGH :WS-NULL-IND-3,                    
                       :E8-AIKEN-HIGH :WS-NULL-IND-4                    
                FROM CSS_TEMPERATURE                                    
                WHERE TEMP_DT BETWEEN IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ) AND                
                                      IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )                      
                  AND COMPANY_NO = :E8-COMPANY-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AVG ((INT(COLA_LOW) + INT(COLA_HIGH)) / 2 ),             
MFA-TR*                AVG ((INT(CHAS_LOW) + INT(CHAS_HIGH)) / 2 ),             
MFA-TR*                AVG ((INT(AIKEN_LOW) + INT(AIKEN_HIGH)) / 2 )            
MFA-TR*           INTO :E8-COLA-HIGH :WS-NULL-IND-2,                            
MFA-TR*                :E8-CHAS-HIGH :WS-NULL-IND-3,                            
MFA-TR*                :E8-AIKEN-HIGH :WS-NULL-IND-4                            
MFA-TR*         FROM CSS_TEMPERATURE                                            
MFA-TR*         WHERE TEMP_DT BETWEEN :WS-START-DATE AND                        
MFA-TR*                               :WS-END-DATE                              
MFA-TR*           AND COMPANY_NO = :E8-COMPANY-NO                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '**   SCSCA185 - PARA: 7175    **'          
                    DISPLAY '**  SELECT TEMPERATURE        **'          
                    DISPLAY '**    SQL CODE = ' SQLCODE                 
                    DISPLAY '**   PROCESSING TERMINATED    **'          
                    MOVE 'CSS_TEMPERATURE '      TO TABLE-1             
                    MOVE 'SELECT '               TO ABEND-FUNCTION      
                    MOVE SQLCODE                 TO RS-RETURN-CODE      
                    MOVE '7175'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'TEMP_DT     '          TO TABLE-ELEMENT-1     
                    MOVE 'COMPANY_NO  '          TO TABLE-ELEMENT-2     
                    MOVE WS-START-DATE           TO HOSTVAR-ELEMENT-1   
                    MOVE WS-END-DATE             TO HOSTVAR-ELEMENT-2   
                    MOVE E8-COMPANY-NO           TO HOSTVAR-ELEMENT-3   
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
      *                                                                         
       7175-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      **  CHECK IF THE UNMTR_PROV_FL IS SET TO 'Y' IN CSS_RATE_PLAN_DESC        
      **  FOR THE RATE_PLAN_NO AND CODE_UTIL_TYPE. IF THIS FL IS SET  **        
      **  TO 'Y', SKIP AND PROCESS THE NEXT IC IN 1000- PARAGRAPH.    **        
      *================================================================*        
      *                                                                         
       7200-CHECK-RATE-PLAN.                                            
      *                                                                         
           MOVE '7200'              TO ACTIVE-PARAGRAPH.                
      *                                                                         
           EXEC SQL                                                     
             SELECT UNMTR_PROV_FL                                       
               INTO :RD-UNMTR-PROV-FL                                   
               FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                 
              WHERE RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE              
                AND RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT UNMTR_PROV_FL                                               
MFA-TR*        INTO :RD-UNMTR-PROV-FL                                           
MFA-TR*        FROM CSS_RATE_PLAN_DESC RD                                       
MFA-TR*       WHERE RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                      
MFA-TR*         AND RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CSS_RATE_PLAN_DESC '      TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE '          TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO   '          TO TABLE-ELEMENT-2        
              MOVE RD-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE RD-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  OPEN TEMPERATURE CURSOR                                 *              
      ************************************************************              
      *                                                                         
       7225-OPEN-TEMP-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
               OPEN TEMPERATURE                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**   SCSCA185 - PARA: 7225    **'                
              DISPLAY '**  OPEN TEMPERATURE CURSOR   **'                
              DISPLAY '**    SQL CODE = ' SQLCODE                       
              DISPLAY '**   PROCESSING TERMINATED    **'                
              MOVE 'CSS_TEMPERATURE   '           TO TABLE-1            
              MOVE 'OPEN'                         TO ABEND-FUNCTION     
              MOVE SQLCODE                        TO RS-RETURN-CODE     
              MOVE '7225'                         TO ACTIVE-PARAGRAPH   
              MOVE 'TEMP_DT         '             TO TABLE-ELEMENT-1    
              MOVE 'COMPANY_NO      '             TO TABLE-ELEMENT-3    
              MOVE WS-START-DATE                  TO HOSTVAR-ELEMENT-1  
              MOVE WS-END-DATE                    TO HOSTVAR-ELEMENT-2  
              MOVE E8-COMPANY-NO                  TO HOSTVAR-ELEMENT-3  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
       7225-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  FETCH FROM TEMPERATURE CURSOR                           *              
      ************************************************************              
      *                                                                         
       7250-FETCH-TEMP-CURSOR.                                          
      *                                                                         
           MOVE 0                            TO WS-ROW-COUNT            
           INITIALIZE                           WS-MISC-HOST-VARIABLES  

MSQ008     MOVE 90 TO MSQ008-TEMPERATURE
           EXEC SQL                                                     
               FOR :MSQ008-TEMPERATURE
              FETCH 
              FROM TEMPERATURE            
                INTO :WS-TEMP-DT,                                       
                     :WS-COLA-LOW,                                      
                     :WS-COLA-HIGH,                                     
                     :WS-CHAS-LOW,                                      
                     :WS-CHAS-HIGH,                                     
                     :WS-AIKEN-LOW,                                     
                     :WS-AIKEN-HIGH                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM TEMPERATURE FOR 90 ROWS           00109700
MFA-TR*         INTO :WS-TEMP-DT,                                       00109800
MFA-TR*              :WS-COLA-LOW,                                      00109900
MFA-TR*              :WS-COLA-HIGH,                                     00110000
MFA-TR*              :WS-CHAS-LOW,                                      00110100
MFA-TR*              :WS-CHAS-HIGH,                                     00110200
MFA-TR*              :WS-AIKEN-LOW,                                     00110300
MFA-TR*              :WS-AIKEN-HIGH                                     00110400
MFA-TR*    END-EXEC.                                                    00110500

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-TEMPERATURE
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE 90                  TO WS-ROW-COUNT            
               WHEN NOT-FOUND                                           
                   EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT                      
MSQ012             END-EXEC                   MOVE MFA-GD-ROW-COUNT TO 
                   WS-ROW-COUNT

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                             00111200
MFA-TR*                  :WS-ROW-COUNT = ROW_COUNT                      00111300
MFA-TR*            END-EXEC                                             00111400
                                             
               WHEN OTHER                                               
                   DISPLAY '**   SCSCA185 - PARA: 7250    **'           
                   DISPLAY '** FETCH FROM CSS_TEMPERATURE **'           
                   DISPLAY '**    SQL CODE = ' SQLCODE                  
                   DISPLAY '**   PROCESSING TERMINATED    **'           
                   MOVE 'CSS_TEMPERATURE   '      TO TABLE-1            
                   MOVE 'FETCH'                   TO ABEND-FUNCTION     
                   MOVE SQLCODE                   TO RS-RETURN-CODE     
                   MOVE '7250'                    TO ACTIVE-PARAGRAPH   
                   MOVE 'TEMP_DT         '        TO TABLE-ELEMENT-1    
                   MOVE 'COMPANY_NO      '        TO TABLE-ELEMENT-3    
                   MOVE WS-START-DATE             TO HOSTVAR-ELEMENT-1  
                   MOVE WS-END-DATE               TO HOSTVAR-ELEMENT-2  
                   MOVE E8-COMPANY-NO             TO HOSTVAR-ELEMENT-3  
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      00120600
      *  CLOSE TEMPERATURE CURSOR                                *      00120700
      ************************************************************      00120800
      *                                                                         
       7275-CLOSE-TEMP-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
               CLOSE TEMPERATURE                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**   SCSCA185 - PARA: 7275    **'                
              DISPLAY '**  CLOSE TEMPERATURE CURSOR  **'                
              DISPLAY '**    SQL CODE = ' SQLCODE                       
              DISPLAY '**   PROCESSING TERMINATED    **'                
              MOVE 'CSS_TEMPERATURE   '         TO TABLE-1              
              MOVE 'CLOSE CURSOR'               TO ABEND-FUNCTION       
              MOVE SQLCODE                      TO RS-RETURN-CODE       
              MOVE '7275'                       TO ACTIVE-PARAGRAPH     
              MOVE 'TEMP_DT         '           TO TABLE-ELEMENT-1      
              MOVE 'COMPANY_NO      '           TO TABLE-ELEMENT-3      
              MOVE WS-START-DATE                TO HOSTVAR-ELEMENT-1    
              MOVE WS-END-DATE                  TO HOSTVAR-ELEMENT-2    
              MOVE E8-COMPANY-NO                TO HOSTVAR-ELEMENT-3    
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
       7275-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR TO                **        
      **  CSS_BILL_CAL_DET  TABLE.                                    **        
      ******************************************************************        
       7500-GET-BZ-DATA.                                                
      *                                                                         
           MOVE '7500'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
             SELECT SUM (BILL_UNITS)                                    
               INTO :BZ-BILL-UNITS :WS-NULL-IND-1                       
              FROM CSS_BILL_CALC_DET WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO         = :BZ-ACCOUNT-NO                 
                AND CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE             
                AND BILL_NO            = :BZ-BILL-NO                    
                AND IC_NO              = :BZ-IC-NO                      
                AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BZ-BILL-ITEM-TIMESTMP
              )         
                AND INSTR_USE_TYPE_CD  = 'R'                            
                AND CONSUMPT_TYPE_CD   IN ('B', 'C')                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SUM (BILL_UNITS)                                            
MFA-TR*        INTO :BZ-BILL-UNITS :WS-NULL-IND-1                               
MFA-TR*       FROM CSS_BILL_CALC_DET                                            
MFA-TR*       WHERE ACCOUNT_NO         = :BZ-ACCOUNT-NO                         
MFA-TR*         AND CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE                     
MFA-TR*         AND BILL_NO            = :BZ-BILL-NO                            
MFA-TR*         AND IC_NO              = :BZ-IC-NO                              
MFA-TR*         AND BILL_ITEM_TIMESTMP = :BZ-BILL-ITEM-TIMESTMP                 
MFA-TR*         AND INSTR_USE_TYPE_CD  = 'R'                                    
MFA-TR*         AND CONSUMPT_TYPE_CD   IN ('B', 'C')                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '**   SCSCA185 - PARA: 7500    **'          
                    DISPLAY '**      7500-GET-BZ-DATA      **'          
                    DISPLAY '**    SQL CODE = ' SQLCODE                 
                    DISPLAY '**   PROCESSING TERMINATED    **'          
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'SELECT'             TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE '7500'               TO ACTIVE-PARAGRAPH       
                    MOVE 'CSS_BILL_CALC_DET'  TO TABLE-1                
                    MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1        
                    MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2        
                    MOVE 'BILL_NO '           TO TABLE-ELEMENT-3        
                    MOVE 'IC_NO'              TO TABLE-ELEMENT-4        
                    MOVE BZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    MOVE BZ-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2      
                    MOVE BZ-BILL-NO           TO HOSTVAR-ELEMENT-3      
                    MOVE BZ-IC-NO             TO HOSTVAR-ELEMENT-4      
                    PERFORM 9900-ABEND        THRU 9900-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  OPEN SERVICE DIVISION CURSOR                            *              
      ************************************************************              
       7600-OPEN-SER-DIV-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN SERV_DIV                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**   SCSCA185 - PARA: 7600    **'                
              DISPLAY '**  OPEN SERV_DIV CURSOR      **'                
              DISPLAY '**    SQL CODE = ' SQLCODE                       
              DISPLAY '**   PROCESSING TERMINATED    **'                
              MOVE 'CSS_LOCAL_OFFICE '               TO TABLE-1         
              MOVE 'OPEN CURSOR'                     TO ABEND-FUNCTION  
              MOVE SQLCODE                           TO RS-RETURN-CODE  
              MOVE '7600'                            TO ACTIVE-PARAGRAPH
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  FETCH SERVICE DIVISION                                  *              
      ************************************************************              
      *                                                                         
       7610-FETCH-SER-DIV-CURSOR.                                       

MSQ008     MOVE 200 TO MSQ008-SERV-DIV
      *                                                                         
      *                                                                         
           EXEC SQL                                                     
               FOR :MSQ008-SERV-DIV
              FETCH 
              FROM SERV_DIV  INTO        
                                :WS-COMPANY                             
                               ,:WS-LOCAL-OFF                           
                               ,:WS-SERV-DIV                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM SERV_DIV FOR 200 ROWS INTO        13070034
MFA-TR*                         :WS-COMPANY                                     
MFA-TR*                        ,:WS-LOCAL-OFF                                   
MFA-TR*                        ,:WS-SERV-DIV                                    
MFA-TR*    END-EXEC                                                             

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-SERV-DIV
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                         TO                      
                                                WS-ACTIVE-RETURN-CODE   
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
      *****    WHEN 354                                                 13170034
                   EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT                      
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                             13180034
MFA-TR*                  :WS-ROW-COUNT = ROW_COUNT                      13190034
MFA-TR*            END-EXEC                                             13200034
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-ROW-COUNT
                   IF WS-ROW-COUNT = 200                                
                      DISPLAY '***********************************'     
                      DISPLAY '   SERVICE DIVISION WORKIG STORAGE '     
                      DISPLAY '       TABLE EXCEEDS THE SIZE      '     
                      DISPLAY '***********************************'     
                      MOVE +16                TO RETURN-CODE            
                      PERFORM 9999-BAIL-OUT   THRU 9999-EXIT            
                   END-IF                                               
               WHEN OTHER                                               
                    DISPLAY '**   SCSCA185 - PARA: 7610    **'          
                    DISPLAY '**  FETCH SERV_DIV CURSOR     **'          
                    DISPLAY '**    SQL CODE = ' SQLCODE                 
                    DISPLAY '**   PROCESSING TERMINATED    **'          
                    MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE     
                    MOVE PROGRAM-NAME             TO ABEND-PROGRAM      
                    MOVE 'FETCH'                  TO ABEND-FUNCTION     
                    MOVE 'CSS_LOCAL_OFFICE'       TO TABLE-1            
                    MOVE '7610'                   TO ACTIVE-PARAGRAPH   
                    PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       7610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  CLOSE SERVICE DIVISION CURSOR                           *              
      ************************************************************              
      *                                                                         
       7620-CLOSE-SER-DIV-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
                CLOSE SERV_DIV                                          
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**   SCSCA185 - PARA: 7620    **'                
              DISPLAY '**  CLOSE SERV_DIV CURSOR     **'                
              DISPLAY '**    SQL CODE = ' SQLCODE                       
              DISPLAY '**   PROCESSING TERMINATED    **'                
              MOVE 'CSS_LOCAL_OFFICE'                TO TABLE-1         
              MOVE 'CLOSE CURSOR'                    TO ABEND-FUNCTION  
              MOVE SQLCODE                           TO RS-RETURN-CODE  
              MOVE  '7620'                           TO ACTIVE-PARAGRAPH
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================* *       
      * GET HISTORICAL CURRENT NO OF DAYS. GET THIS DATA FROM CNSMPTN *         
      * HISTORY INSTEAD OF BILLING DETAILS (NO OF CONS ROWS BG)       *         
      *===============================================================* *       
       7625-GET-CX-DAYS.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SUM(NO_DAYS)                                      
                 INTO :CX-NO-DAYS                                       
                 FROM CSS_CNSMPTN_HIST                                  
                WHERE ACCOUNT_NO        = :CX-ACCOUNT-NO                
                  AND CODE_UTIL_TYPE    = :CX-CODE-UTIL-TYPE            
                  AND BILL_NO           = :CX-BILL-NO                   
                  AND IC_NO             = :CX-IC-NO                     
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )       
ACT015            AND CODE_USAGE_SOURCE IN ('B','J','K')                
                  AND CODE_USAGE_ID  NOT IN ('1', '2', '3')             
                GROUP BY MTR_REF_NO, REG_ID_NO, CODE_TIME_PERIOD        
                ORDER BY 1 DESC                                         
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(NO_DAYS)                                              
MFA-TR*          INTO :CX-NO-DAYS                                               
MFA-TR*          FROM CSS_CNSMPTN_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO        = :CX-ACCOUNT-NO                        
MFA-TR*           AND CODE_UTIL_TYPE    = :CX-CODE-UTIL-TYPE                    
MFA-TR*           AND BILL_NO           = :CX-BILL-NO                           
MFA-TR*           AND IC_NO             = :CX-IC-NO                             
MFA-TR*           AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP               
MFA-TR*           AND CODE_USAGE_SOURCE IN ('B','J','K')                        
MFA-TR*           AND CODE_USAGE_ID  NOT IN ('1', '2', '3')                     
MFA-TR*         GROUP BY MTR_REF_NO, REG_ID_NO, CODE_TIME_PERIOD                
MFA-TR*         ORDER BY 1 DESC                                                 
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    INITIALIZE CX-NO-DAYS                               
               WHEN OTHER                                               
                    DISPLAY '**   SCSCA185 - PARA: 7625    **'          
                    DISPLAY '**  SELECT CX-DAYS            **'          
                    DISPLAY '**    SQL CODE = ' SQLCODE                 
                    DISPLAY '**   PROCESSING TERMINATED    **'          
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7625'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SELECT'              TO ABEND-FUNCTION        
                    MOVE 'CSS_CNSMPTN_HIST'    TO TABLE-1               
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2       
                    MOVE 'IC_NO'               TO TABLE-ELEMENT-3       
                    MOVE 'BILL_NO'             TO TABLE-ELEMENT-4       
                    MOVE CX-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    MOVE CX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2     
                    MOVE CX-IC-NO              TO HOSTVAR-ELEMENT-3     
                    MOVE CX-BILL-NO            TO HOSTVAR-ELEMENT-4     
                    MOVE SQLCODE               TO RS-RETURN-CODE        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7625-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *===============================================================* *       
      * TO GET LATEST READ DATE FROM CX CONSUMPTION ROWS.                       
      *===============================================================* *       
      *                                                                         
       7650-GET-READ-DATE-CX.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) DATE_READ                                           
               INTO :CX-DATE-READ :WS-NULL-IND                           
               FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO        = :CX-ACCOUNT-NO                  
                AND CODE_UTIL_TYPE    = :CX-CODE-UTIL-TYPE              
                AND BILL_NO           = :CX-BILL-NO                     
                AND IC_NO             = :CX-IC-NO                       
                AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )         
ACT015          AND CODE_USAGE_SOURCE IN ('B','J','K')                  
              ORDER BY DATE_READ DESC                                   
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DATE_READ                                                   
MFA-TR*        INTO :CX-DATE-READ:WS-NULL-IND                                   
MFA-TR*        FROM CSS_CNSMPTN_HIST                                            
MFA-TR*       WHERE ACCOUNT_NO        = :CX-ACCOUNT-NO                          
MFA-TR*         AND CODE_UTIL_TYPE    = :CX-CODE-UTIL-TYPE                      
MFA-TR*         AND BILL_NO           = :CX-BILL-NO                             
MFA-TR*         AND IC_NO             = :CX-IC-NO                               
MFA-TR*         AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP                 
MFA-TR*         AND CODE_USAGE_SOURCE IN ('B','J','K')                          
MFA-TR*       ORDER BY DATE_READ DESC                                           
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   IF WS-NULL-IND < 0                                   
                      INITIALIZE CX-DATE-READ                           
                   END-IF                                               
              WHEN OTHER                                                
                    DISPLAY '**   SCSCA185 - PARA: 7650    **'          
                    DISPLAY '**  SELECT READ DATE FROM CX  **'          
                    DISPLAY '**    SQL CODE = ' SQLCODE                 
                    DISPLAY '**   PROCESSING TERMINATED    **'          
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7650'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'SELECT'               TO ABEND-FUNCTION       
                    MOVE 'CSS_CNSMPTN_HIST'     TO TABLE-1              
                    MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1      
                    MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2      
                    MOVE 'IC_NO'                TO TABLE-ELEMENT-3      
                    MOVE 'BILL_NO'              TO TABLE-ELEMENT-4      
                    MOVE CX-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1    
                    MOVE CX-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2    
                    MOVE CX-IC-NO               TO HOSTVAR-ELEMENT-3    
                    MOVE CX-BILL-NO             TO HOSTVAR-ELEMENT-4    
                    MOVE SQLCODE                TO RS-RETURN-CODE       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *  9700-PROCESS-ABEND.                                                    
       COPY CPD0023B.                                                           
      *                                                                         
      ******************************************************************        
      * RETURNS TO CALLING PROGRAM UNDER ABNORMAL CONDITIONS WITH A    *        
      * APPROPRIATE MESG AND RETURN-CODE                               *        
      ******************************************************************        
       9900-ABEND.                                                      
      *                                                                         
           MOVE TABLE-1                              TO WS-DB2-TABLE-ID.
           MOVE ABEND-FUNCTION                       TO WS-DB2-FUNCTION.
           MOVE RS-RETURN-CODE                       TO                 
                                                 WS-DB2-RETURN-CODE.    
           MOVE '185'                                TO                 
                                                 WS-DB2-MODULE-ID.      
           MOVE ACTIVE-PARAGRAPH                     TO                 
                                                 WS-DB2-PARAGRAPH.      
           MOVE HOSTVAR-ELEMENT-1                    TO WS-DB2-KEY-1.   
           MOVE HOSTVAR-ELEMENT-2                    TO WS-DB2-KEY-2.   
           MOVE HOSTVAR-ELEMENT-3                    TO WS-DB2-KEY-3.   
           MOVE HOSTVAR-ELEMENT-4                    TO WS-DB2-KEY-4.   
           MOVE 12                                   TO RETURN-CODE.    
           PERFORM 9999-BAIL-OUT                     THRU 9999-EXIT.    
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9910-MISC-ERROR.                                                 
      *                                                                         
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
                                                                        
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
                                                                        
              MOVE ZEROES        TO WS-BILL-NO-WQ                       
              MOVE SPACES TO WS-CODE-UTIL-TYPE-WQ                       
                             WS-RATE-PLAN-NO-WQ                         
              MOVE ZEROES TO WS-IC-NO-WQ                                
                                                                        
              COMPUTE WS-START-POS                                      
                = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1              
              MOVE WS-SUPPLEMENTAL-TXT-WQ                               
                TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)
              ADD WS-SUPPLEMENTAL-TXT-LEN-WQ                            
                TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX)                 
ACT071        MOVE PROGRAM-NAME                                         
ACT071          TO WS-CREATED-BY-WF (WS-BILL-WQ-INDX)                   
           END-IF.                                                      
      *                                                                 40880000
       9910-EXIT.                                                       
           EXIT.                                                        
      *                                                                 40880000
       9999-BAIL-OUT.                                                   
      *                                                                         
           MOVE RETURN-CODE                          TO                 
                                               WS-SCSCA-RETURN-CODE.    
           EXIT PROGRAM.                                                
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
