       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   SCSCA184.                                          
       AUTHOR.       GOKUL SATHIYAMOORTHY.                              
       DATE-WRITTEN. JULY 2007.                                         
                                                                        
      ***************************************************************** 00000600
      **              SOUTH CAROLINA ELECTRICITY  & GAS              ** 00000700
      **                                                             ** 00000800
      ********            CUSTOMER SERVICE SYSTEM             ********* 00000900
      ********                   DB2                          ********* 00001000
      ***************************************************************** 00001100
      **                                                             ** 00001200
      **              PROGRAM  MODIFICATION  LOG                     ** 00001300
      **                                                             ** 00001400
      **                                                             ** 00001500
      **  DATE    INITIALS             REASON                        ** 00001600
      **________  ________           ______________                  ** 00001700
      **                                                             ** 00001800
      ** 07/07    GOKUL           INITIAL VERSION OF  PROGRAM        ** 00001900
T37389** 06/08    SV82012         CHANGES TO GENERATE MEMO BILLS     **         
T37389** 07/08    RV97439         ADDITIONAL LOGIC ADDED FOR ADDRESS **         
T37389**                          AND NAME VALIDATION.               **         
T37629** 09/08    SV82012         CUSTOMER NAME TRUNCATED IN "PAY TO **         
T37629**                          THE ORDER OF"                      **         
A00943** 05/09    BD0955          PUT TWO SPACES IN FRONT OF ZIP     **         
A00943**                          CODE FOR FREEFORM ADDRESSES, SAME  **         
A00943**                          AS WITH FORMATTED.                 **         
A02515** 06/10    SJ97149         GETTING FULL_NAME AS THE ADDRESS FOR*         
A02515**          ACT0001         THE CUSTOMER WHEN NO DATA IS FOUND **         
A02515**                          FOR FIRST_NAME,LAST_NAME ETC., WHEN *         
A02515**                          THE CUSTOMER OF TYPE BUSINESS      **         
P00704** 10/13    BD09555         FOR CUSTOMER ADDRESS, LOOK AT      **         
P00704**                          EITHER FREEFORM OR FORMATTED TABLE.**         
P00740** 05/14    BD09555         FOR THIRD PARTY AND MEMO ADDRESSES,**         
P00740** 05/14    BD09555         LOOK AT FREEFORM OR FORMATTED TABLE**         
P00740**                          DEPENDING ON FORMAT.               **         
P00740** 07/14    BD09555         MOVE LOCATION WHERE NAME ID IS LOADED         
A04127*  11/14    MJ13662         IF PROCESSING ALOC OR ITPA LETTERS, *         
A04127*                           WS-ALOC-ITPA-PROCESS = 'A', USE     *         
A04127*                           INDIVIDUAL BUSINESS NAMES.          *         
A04127*                           IF NOT-FOUND OR SPACES, FOR         *         
A04127*                           WS-ADDRESS-TYPE = 'C' USE           *         
A04127*                           DQ-FULL-NAME, FOR OTHER ADDRESS-TYPES         
A04127*                           USE EXISTING RULES.                 *         
ACT071*  16/03/15 SS7F226         ADD CREATED-BY FIELD IN WF AREA.    *         
ACT071*            A04860                                             *         
ACT120*  06/10/15 BD09555         CORRECT ISSUES WITH THIRD PARTY     *         
ACT120*                           PROCESSING.  ALSO INITIALIZE ITEMS  *         
ACT120*                           IN ADDRESS PROCESSING SO THAT       *         
ACT120*                           PREVIOUSLY RETRIEVED COLUMNS ARE NOT*         
ACT120*                           ERRONEOUSLY PICKED UP WHEN A        *         
ACT120*                           SUBSEQUENT SELECT RETURNS NOT FOUND.*         
      ***************************************************************** 00002000
      * PROGRAM NARRATIVE                                             * 00002100
      *                                                               * 00002200
      * THIS PROGRAM IS USED TO GET NAMES AND ADDRESSES (SERVICE/MAIL)* 00002300
      * ======> NAME/ADDRESS INFORMATION ARE FORMATTED.               * 00002400
      * ======> THE ADDRESS IS VALIDATED WITH FINALIST.               * 00002500
      * ======> CHANGED ADDRESS RECORDS ARE WRITTEN TO A FILE.        * 00002600
      * ======> USED BY ALL COMMUNICATIONS GENERATED BY BILL PRINT.   * 00002700
      *                                                               * 00002800
      ***************************************************************** 00002900
                                                                        
      *                                                                 00003100
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
       ENVIRONMENT DIVISION.                                            
                                                                        
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA184'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-SWITCHES.                                                 
           05  PROGNAME                  PIC X(08) VALUE 'SCSCA184'.    
           05  PROGRAM-NAME              PIC X(08) VALUE 'SCSCA184'.    
                                                                        
       01 CWS00074-FIELDS.                                              
      *                                                                 00005100
           05  SUB1                        PIC S9(04) COMP.             
           05  SUB2                        PIC S9(04) COMP.             
           05 WS-NULL-IND1                 PIC S9(04) COMP   VALUE 0.   
           05  RS-RETURN-CODE              PIC S9(04) COMP.             
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
           05  WS-DISPLAY-ACCOUNT          PIC Z(13).                   
           05  WS-DISPLAY-ADDR-ID          PIC Z(13).                   
T37389     05  WS-DISPLAY-NAME-ID          PIC Z(13).                   
           05  WS-MAIL-ADDR-TYPE           PIC X(01).                   
           05  WS-BUSINESS-NAME-ENTRY      PIC X(185).                  
           05  WS-CUSTOMER-NAME            PIC X(50).                   
      *  ACCOUNT NAME WILL CONTAIN CUSTOMER NAME IF NO SEPARATE         00006200
      *  ACCOUNT NAME EXISTS                                            00006300
           05  WS-ACCOUNT-NAME             PIC X(50).                   
           05  WS-HOLD-BARCODE-ZIP         PIC X(11).                   
           05  WS-NAME-ONLY-SW             PIC X(01) VALUE SPACE.       
               88  WS-NAME-ONLY            VALUE 'Y'.                   
           05  WS-SPECIAL-MAIL-ADDR-SW     PIC X(01) VALUE SPACE.       
           05  WS-FORMAT-ZIP-PLUS.                                      
               10  WS-FORMAT-ZIP-1         PIC X(5).                    
               10  FILLER                  PIC X  VALUE '-'.            
               10  WS-FORMAT-ZIP-2         PIC X(4).                    
      *                                                                 00007200
      **************************************************************    00007300
      *    THE NAME/ADDRESS ROUTINE WILL PLACE THE RESULTS IN THE  *    00007400
      *    FOLLOWING TABLE. THE ADDRESS LINES ARE READY TO PRINT   *    00007500
      *    THE WS-NAME-ADDR-LINE IS WHAT SHOULD BE MOVED TO THE    *    00007600
      *    PRINT LINE. THE WS-NAME-ADDR-TYPE CONTAINS THE FOLLOWING*    00007700
      *    VALUES TO IDENTIFY THE DATA IN EACH ENTRY.              *    00007800
      *      CN - CUSTOMER NAME                                    *    00007900
      *      AN - BILLING NAME                                     *    00008000
      *      AA - ATTENTION NAME                                   *    00008100
      *      AI - IN CARE OF NAME                                  *    00008200
      *      AO - ADDRESS OVERFLOW                                 *    00008300
      *      AS - STREET ADDRESS                                   *    00008400
      *      AZ - CITY/STATE/ZIP/COUNTRY ADDRESS                   *    00008500
      **************************************************************    00008600
       01  WS-NAME-ADDR-TABLE.                                          
           05  WS-NAME-ADDR-ENTRY         OCCURS 6                      
                                         INDEXED BY WS-NM-ADDR-INDX.    
               10 WS-NAME-ADDR-TYPE       PIC X(02).                    
               10 WS-NAME-ADDR-LINE       PIC X(50).                    
                                                                        
      **************************************************************    00009300
      *    CONTAINS THE PREMISE ADDRESS (WHICH MAY BE DIFFERENT    *    00009400
      *    FROM THE MAIL ADDRESS)                                  *    00009500
      **************************************************************    00009600
       01  WS-PREMISE-ADDR.                                             
           05  WS-PR-STREET                     PIC X(79).              
           05  WS-PR-ADDR-OVERFLOW              PIC X(26).              
           05  WS-PR-ADDR-CITY-STATE            PIC X(30).              
           05  WS-PR-ADDR-CITY-STATE-ZIP        PIC X(41).              
           05  WS-PR-ADDR-ZIP.                                          
               10  WS-PR-ADDR-ZIP-CODE          PIC X(05).              
               10  WS-PR-ADDR-ZIP-PLUS-4        PIC X(04).              
               10  WS-PR-ADDR-USPS-DELIV-PT-CD  PIC X(02).              
      **************************************************************    00010600
      *    CONTAINS THE MAIL ADDRESS (ONLY IF DIFFERENT FROM       *    00010700
      *    PREMISE ADDRESS)                                        *    00010800
      **************************************************************    00010900
       01  WS-MAIL-ADDR.                                                
           05  WS-MAIL-ADDR-STREET              PIC X(79).              
           05  WS-MAIL-ADDR-OVERFLOW            PIC X(26).              
           05  WS-MAIL-ADDR-CITY-STATE          PIC X(30).              
           05  WS-MAIL-ADDR-CITY-STATE-ZIP      PIC X(41).              
           05  WS-MAIL-ADDR-ZIP                 PIC X(05).              
           05  WS-MAIL-ADDR-ZIP-PLUS-4          PIC X(04).              
           05  WS-MAIL-ADDR-USPS-DELIV-PT-CD    PIC X(02).              
      *                                                                 00011800
      **************************************************************    00011900
      *    WS-NAME-TABLE HOLDS THE NAMES AS THEY ARE LOADED FROM   *    00012000
      *    NAME TABLE. AFTER INTERROGATING THE NAME, AND REMOVING  *    00012100
      *    IMBEDDED SPACES, THE NAME IS PUT IN WS-NAME.            *    00012200
      **************************************************************    00012300
       01  WS-NAME-TABLE.                                               
           05  WS-NAME-ENTRY             OCCURS 5                       
                                         INDEXED BY WS-NAME-INDX.       
               10 WS-NAME-TYPE            PIC X(2).                     
               10 WS-NAME-FORMAT          PIC X(1).                     
               10 WS-FIRST-NAME           PIC X(15).                    
               10 WS-MIDDLE-NAME          PIC X(15).                    
               10 WS-LAST-NAME            PIC X(40).                    
               10 WS-NICKNAME             PIC X(50).                    
               10 WS-TITLE-PREFIX         PIC X(9).                     
               10 WS-TITLE-SUFFIX-1       PIC X(3).                     
               10 WS-TITLE-SUFFIX-2       PIC X(3).                     
               10 WS-FULL-NAME            PIC X(85).                    
               10  WS-NAME.                                             
                   15  WS-NAME-ATTN-CO      PIC X(06).                  
T37629             15  WS-NAME-REST         PIC X(90).                  
                                                                        
       01  WS-MAIL-CARRIER-ROUTE          PIC X(05).                    
                                                                        
       01  WS-FORMATTED-NAME.                                           
               10 WS-FMT-TITLE-PREFIX     PIC X(9).                     
               10 FILLER                  PIC X(01).                    
               10 WS-FMT-FIRST-NAME       PIC X(15).                    
               10 FILLER                  PIC X(01).                    
               10 WS-FMT-MIDDLE-NAME      PIC X(15).                    
               10 FILLER                  PIC X(01).                    
               10 WS-FMT-LAST-NAME        PIC X(40).                    
               10 FILLER                  PIC X(01).                    
               10 WS-FMT-TITLE-SUFFIX-1   PIC X(3).                     
               10 FILLER                  PIC X(01).                    
               10 WS-FMT-TITLE-SUFFIX-2   PIC X(3).                     
                                                                        
      **************************************************************    00015600
      *   WORK AREA FOR FORMATTED SALUATION NAME. IF A PREFIX IS   *    00015700
      *   PRESENT, THEN PREFIX AND LAST NAME WILL BE USED,         *    00015800
      *   OTHERWISE, ONLY FIRST, MIDDLE AND LAST NAME WILL BE USED.*    00015900
      **************************************************************    00016000
       01  WS-FMT-SALUTATION-NAME         PIC X(72).                    
       01  WS-FMT-SAL-NAME-1 REDEFINES WS-FMT-SALUTATION-NAME.          
               10 WS-FMT-SAL-TITLE-1      PIC X(9).                     
               10 FILLER                  PIC X(01).                    
               10 WS-FMT-SAL-LAST-NAME-1  PIC X(40).                    
               10 FILLER                  PIC X(22).                    
       01  WS-FMT-SAL-NAME-2 REDEFINES WS-FMT-SALUTATION-NAME.          
               10 WS-FMT-SAL-FIRST-NAME       PIC X(15).                
               10 FILLER                      PIC X(01).                
               10 WS-FMT-SAL-MIDDLE-NAME      PIC X(15).                
               10 FILLER                      PIC X(01).                
               10 WS-FMT-SAL-LAST-NAME        PIC X(40).                
       01  WS-SALUTATION-NAME                 PIC X(72).                
      **************************************************************    00017400
      *   WORK AREA FOR FORMATTED ADDRESS PIECES PRIOR TO PUTTING  *    00017500
      *   THEM TOGETHER AND REMOVING IMBEDDED SPACES.              *    00017600
      **************************************************************    00017700
       01  WS-HOUSE-NO-N.                                               
           05  WS-HOUSE-NO-IN       PIC X(01)                           
                                    OCCURS 15 TIMES                     
                                    INDEXED BY WS-HOUSE-IN-IDX.         
       01  WS-HOUSE-NO-1.                                               
           05  WS-HOUSE-NO-OUT      PIC X(01)                           
                                    OCCURS 15 TIMES                     
                                    INDEXED BY WS-HOUSE-OUT-IDX.        
                                                                        
       01  WS-ADDRESS.                                                  
           10  WS-STREET-ADDRESS.                                       
               15  WS-HOUSE-NO              PIC X(15).                  
               15  FILLER                   PIC X(01).                  
               15  WS-ADDR-PREFIX-1         PIC X(03).                  
               15  FILLER                   PIC X(01).                  
               15  WS-ADDR-PREFIX-2         PIC X(02).                  
               15  FILLER                   PIC X(01).                  
               15  WS-NAME-STREET           PIC X(30).                  
               15  FILLER                   PIC X(01).                  
               15  WS-STREET-SUFFIX         PIC X(04).                  
               15  FILLER                   PIC X(01).                  
               15  WS-ADDRESS-SUFFIX        PIC X(02).                  
               15  FILLER                   PIC X(01).                  
               15  WS-STREET-LOCATION-1     PIC X(04).                  
               15  FILLER                   PIC X(01).                  
               15  WS-STREET-LOCATION-2     PIC X(11).                  
               15  FILLER                   PIC X(04).                  
           10  WS-CITY-STATE.                                           
               15  WS-CITY                  PIC X(26).                  
               15  FILLER                   PIC X(01).                  
               15  WS-STATE                 PIC X(02).                  
               15  WS-ZIP-FILLER            PIC X(02) VALUE ' *'.       
               15  WS-ZIP.                                              
                   20  WS-ZIP-CODE          PIC X(05).                  
                   20  WS-ZIP-DASH          PIC X(01) VALUE '-'.        
                   20  WS-ZIP-PLUS-4        PIC X(04).                  
                                                                        
      **************************************************************    00021500
      *   WORK AREA FOR FORMATTED ADDRESS PIECES AFTER PUTTING ALL *    00021600
      *   THE PIECES TOGETHER                                      *    00021700
      **************************************************************    00021800
       01  WS-FORMATTED-ADDRESS.                                        
           10  WS-FMT-ADDR-STREET           PIC X(79).                  
           10  WS-FMT-ADDR-OVERFLOW         PIC X(26).                  
           10  WS-FMT-CITY-STATE            PIC X(30).                  
           10  WS-FMT-CITY-STATE-ZIP        PIC X(41).                  
           10  WS-FMT-ZIP.                                              
               15  WS-FMT-ZIP-CODE          PIC X(05).                  
               15  WS-FMT-ZIP-PLUS-4        PIC X(04).                  
               15  WS-FMT-USPS-DELIV-PT-CD  PIC X(02).                  
           10  WS-FMT-VALIDATION-TS         PIC X(26).                  
      *                                                                 00022900
                                                                        
      **************************************************************    00023100
      *   WORK AREA FOR FREEFORM ADDRESS PIECES FROM THE FREEFORM  *    00023200
      *   AND BOND_CO TABLES                                       *    00023300
      **************************************************************    00023400
       01  WS-FREEFORM-ADDRESS.                                         
           10  WS-FRE-ADDR-STREET           PIC X(55).                  
           10  WS-FRE-ADDRESS-OVERFLOW      PIC X(35).                  
           10  WS-FRE-ADDR-CITY-STATE       PIC X(30).                  
           10  WS-FRE-ADDR-ZIP-CODE         PIC X(09).                  
           10  WS-FRE-ADDR-COUNTRY          PIC X(35).                  
           10  WS-FRE-ADDR-USPS-DEL-PT-CD   PIC X(02).                  
           10  WS-FRE-VALIDATION-TS         PIC X(26).                  
      *                                                                 00024300
       01  WS-THD-PRTY-DETAILS.                                         
           10  WS-TP-NAME                   PIC X(70).                  
           10  WS-THD-PRTY-ADDRESS.                                     
               15  WS-TP-ADDR-STREET        PIC X(55).                  
               15  WS-TP-ADDRESS-OVERFLOW   PIC X(35).                  
               15  WS-TP-ADDR-CITY-STATE    PIC X(30).                  
               15  WS-TP-ADDR-ZIP-CODE      PIC X(09).                  
               15  WS-TP-ADDR-COUNTRY       PIC X(35).                  
               15  WS-TP-ADDR-USPS-DELPT-CD PIC X(02).                  
               15  WS-TP-VALIDATION-TS      PIC X(26).                  
      *                                                                 00025400
       01  WS-SQL-ERROR-FIELDS-74.                                      
           10  WS-TABLE-ID-74               PIC XX.                     
           10  WS-FUNCTION-74               PIC X(6).                   
           10  WS-RETURN-CODE-74            PIC S9(3).                  
           10  WS-PARAGRAPH-74              PIC X(4).                   
           10  WS-DB2-KEY-1-74.                                         
               15  WS-DB2-KEY-1N-74         PIC 9(13).                  
               15  FILLER                   PIC X(7).                   
           10  WS-DB2-KEY-2-74.                                         
               15  WS-DB2-KEY-2N-74         PIC 9(13).                  
               15  FILLER                   PIC X(7).                   
      *                                                                 00026600
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME               PIC X(08) VALUE 'SCSCA184'.    
           05  WS-Y                      PIC X(01) VALUE 'Y'.           
                                                                        
A04127 01  WS-FLAGS.                                                    
A04127     05  WS-IB-NAME-FOUND          PIC X(01) VALUE 'N'.           
      *                                                                 00027000
A04127 01  WS-HOLD-DQ-FIELDS.                                           
COB305     10 WS-HOLD-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.    
A04127     10 WS-HOLD-NAME-TYPE            PIC X(2).                    
A04127     10 WS-HOLD-NAME-FORMAT          PIC X(1).                    
A04127     10 WS-HOLD-CREATED-DATE         PIC X(26).                   
A04127     10 WS-HOLD-FIRST-NAME           PIC X(15).                   
A04127     10 WS-HOLD-MIDDLE-NAME          PIC X(15).                   
A04127     10 WS-HOLD-LAST-NAME            PIC X(40).                   
A04127     10 WS-HOLD-NICKNAME             PIC X(50).                   
A04127     10 WS-HOLD-TITLE-PREFIX         PIC X(9).                    
A04127     10 WS-HOLD-TITLE-SUFFIX-1       PIC X(3).                    
A04127     10 WS-HOLD-TITLE-SUFFIX-2       PIC X(3).                    
A04127     10 WS-HOLD-FULL-NAME            PIC X(70).                   
                                                                        
       COPY FIOCA00.                                                    00027100
       COPY FIOJC01.                                                    00027200
      * COPYBOOK FOR DB2 ERROR CHECK                                    00027300
       COPY CWS00303.                                                   00027400
       COPY CWS00023.                                                   00027500
      ***************************************************************** 00027600
      *  THIS COPYBOOK IS USED WITH THE CPD09900 INCLUDE MEMBER       * 00027700
      *  WHICH INVOKES THE ABEND ROUTINE                              * 00027800
      ***************************************************************** 00027900
       COPY CWS09900.                                                   00028000
      *                                                                 00028100
       COPY CWS00010.                                                   00028200
      *                                                                 00028300
       COPY CWS0070B.                                                   00028400
                                                                        
           EXEC SQL                                                     00028600
                INCLUDE SQLCA                                           00028700
           END-EXEC.                                                    00028800
      *                                                                 00028900
           EXEC SQL                                                     00029400
               INCLUDE TBACCT                                           00029500
           END-EXEC.                                                    00029600
      *                                                                 00029700
           EXEC SQL                                                     00029800
               INCLUDE TBCUST                                           00029900
           END-EXEC.                                                    00030000
      *                                                                 00030100
           EXEC SQL                                                     00030200
               INCLUDE TBNAME                                           00030300
           END-EXEC.                                                    00030400
      *                                                                 00030500
           EXEC SQL                                                     00030600
               INCLUDE TBNMACTX                                         00030700
           END-EXEC.                                                    00030800
      *                                                                 00030900
           EXEC SQL                                                     00031000
               INCLUDE TBCSADRX                                         00031100
           END-EXEC.                                                    00031200
      *                                                                 00031300
           EXEC SQL                                                     00031400
               INCLUDE TBADRFRE                                         00031500
           END-EXEC.                                                    00031600
      *                                                                 00031700
           EXEC SQL                                                     00031800
               INCLUDE TBADRFMT                                         00031900
           END-EXEC.                                                    00032000
      *                                                                 00032100
           EXEC SQL                                                     00032200
               INCLUDE TBZIPCD                                          00032300
           END-EXEC.                                                    00032400
      *                                                                 00032500
           EXEC SQL                                                     00032600
               INCLUDE TBATMISC                                         00032700
           END-EXEC.                                                    00032800
      *                                                                 00032900
P00740     EXEC SQL                                                     00032600
P00740         INCLUDE TBTHDPTY                                         00032700
P00740     END-EXEC.                                                    00032800
P00740*                                                                 00032900
P00740     EXEC SQL                                                     00032600
P00740         INCLUDE TBCNTACT                                         00032700
P00740     END-EXEC.                                                    00032800
P00740*                                                                 00032900
A04127******************************************************************01404000
A04127*    CE - CSS_CUST_STATS                                         *01404100
A04127******************************************************************01404200
A04127*                                                                 01404300
A04127     EXEC SQL                                                     01404400
A04127         INCLUDE TBCSTSTS                                         01404500
A04127     END-EXEC.                                                    01404600
A04127*                                                                 01404800
           EXEC SQL                                                     00033000
               INCLUDE CWS00038                                         00033100
           END-EXEC.                                                    00033200
      *                                                                 00033300
           EXEC SQL                                                     00033400
               INCLUDE CWS00114                                         00033500
           END-EXEC.                                                    00033600
      *                                                                 00033700
                                                                        
      **************************************************************    00033900
      *         CURSOR DECLARATIONS                                *    00034000
      **************************************************************    00034100
                                                                        
           EXEC SQL                                                     
               DECLARE NAME_CURSOR CURSOR FOR                           
               SELECT  A.NAME_ID,                                       
                       A.COMPANY_NO,                                    
                       A.CUSTOMER_NO,                                   
                       A.ACCOUNT_NO,                                    
                       A.ADDRESS_ID,                                    
                       A.PREMISE_NO,                                    
                       A.CONTACT_ID,                                    
                       B.NAME_TYPE,                                     
                       B.NAME_FORMAT,                                   
                       B.FIRST_NAME,                                    
                       B.MIDDLE_NAME,                                   
                       B.LAST_NAME,                                     
                       B.TITLE_PREFIX,                                  
                       B.TITLE_SUFFIX_1,                                
                       B.TITLE_SUFFIX_2,                                
                       B.FULL_NAME                                      
               FROM CSS_NAME_ACCT_XREF A
                           WITH(READUNCOMMITTED), CSS_NAME B
                           WITH(READUNCOMMITTED)                    
               WHERE  A.ACCOUNT_NO = :HT-ACCOUNT-NO AND                 
                      A.NAME_ID = B.NAME_ID AND                         
                      A.CUSTOMER_ROLE_CD = :HT-CUSTOMER-ROLE-CD AND     
                      B.NAME_TYPE IN ('CN', 'AN', 'AA', 'DB', 'AI')     
               FOR READ ONLY                                    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00034300
MFA-TR*        DECLARE NAME_CURSOR CURSOR FOR                           00034400
MFA-TR*        SELECT  A.NAME_ID,                                       00034500
MFA-TR*                A.COMPANY_NO,                                    00034600
MFA-TR*                A.CUSTOMER_NO,                                   00034700
MFA-TR*                A.ACCOUNT_NO,                                    00034800
MFA-TR*                A.ADDRESS_ID,                                    00034900
MFA-TR*                A.PREMISE_NO,                                    00035000
MFA-TR*                A.CONTACT_ID,                                    00035100
MFA-TR*                B.NAME_TYPE,                                     00035200
MFA-TR*                B.NAME_FORMAT,                                   00035300
MFA-TR*                B.FIRST_NAME,                                    00035400
MFA-TR*                B.MIDDLE_NAME,                                   00035500
MFA-TR*                B.LAST_NAME,                                     00035600
MFA-TR*                B.TITLE_PREFIX,                                  00035700
MFA-TR*                B.TITLE_SUFFIX_1,                                00035800
MFA-TR*                B.TITLE_SUFFIX_2,                                00035900
MFA-TR*                B.FULL_NAME                                      00036000
MFA-TR*        FROM CSS_NAME_ACCT_XREF A, CSS_NAME B                    00036100
MFA-TR*        WHERE  A.ACCOUNT_NO = :HT-ACCOUNT-NO AND                 00036200
MFA-TR*               A.NAME_ID = B.NAME_ID AND                         00036300
MFA-TR*               A.CUSTOMER_ROLE_CD = :HT-CUSTOMER-ROLE-CD AND     00036400
MFA-TR*               B.NAME_TYPE IN ('CN', 'AN', 'AA', 'DB', 'AI')     00036500
MFA-TR*        FOR FETCH ONLY WITH UR                                   00036510
MFA-TR*     END-EXEC.                                                   00036600
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
T37389 COPY CWSCA184.                                                   00036900
                                                                        
       01 WS-MST-SUB-ACCT-IND-AT                   PIC X(01).           
       01 WS-CODE-PRNT-BLL-MST-AT                  PIC X(01).           
       01 WS-CODE-TEMP-BILL-AT                     PIC X(01).           
       01 WS-SCSCA-RETURN-CODE                     PIC S9(4) COMP.      
       01 LS-CURR-WQ-ITEM                          PIC S9(4) COMP.      
       01  WS-BILLING-WQ-ITEMS-WF.                                      
           05  WS-BILLING-WQ-ITEMS-DATA-WF                              
                   OCCURS 50 TIMES INDEXED BY WS-BILL-WQ-INDX.          
               10  WS-CATEGORY-ID-WF               PIC S9(04)  COMP.    
               10  WS-PRIORITY-WF                  PIC X(1).            
               10  WS-ROUTE-CATEGORY-WF            PIC X(01).           
               10  WS-COMMENTS-WF.                                      
                   15  WS-COMMENTS-LEN-WF          PIC S9(04)  COMP.    
                   15  WS-COMMENTS-TEXT-WF         PIC X(250).          
ACT071         10  WS-CREATED-BY-WF                PIC X(16).           
ACT071         10  FILLER                          PIC X(228).          
A04127 01 WS-ALOC-ITPA-PROCESS                     PIC X(01).           
                                                                        
       PROCEDURE DIVISION USING WS-SCSCA184-PARMS                       
                                WS-MST-SUB-ACCT-IND-AT                  
                                WS-CODE-PRNT-BLL-MST-AT                 
                                WS-CODE-TEMP-BILL-AT                    
                                WS-SCSCA-RETURN-CODE                    
                                LS-CURR-WQ-ITEM                         
                                WS-BILLING-WQ-ITEMS-WF                  
A04127                          WS-ALOC-ITPA-PROCESS.                   
      *                                                                 00041500
       0000-MAINLINE.                                                   
      *                                                                 00041700
                                                                        
           DISPLAY 'SCSCA184 - ADDRESS PROCESSING'.                     
           PERFORM 0100-INITIALIZATION                THRU 0100-EXIT.   
                                                                        
           PERFORM 1000-PROCESS-ADDRESS               THRU 1000-EXIT.   
                                                                        
           MOVE WS-PREMISE-ADDR                       TO                
                                               WS-PREMISE-ADDRESS.      
           MOVE WS-MAIL-ADDR                          TO                
                                               WS-MAIL-ADDRESS.         
           MOVE WS-FORMATTED-ADDRESS                  TO                
                                               WS-FORM-ADDRESS.         
           MOVE WS-FREEFORM-ADDRESS                   TO                
                                               WS-FREE-ADDRESS.         
           MOVE WS-THD-PRTY-DETAILS                   TO                
                                               WS-TP-ADDRESS.           
           MOVE WS-NAME-ADDR-TABLE                    TO                
                                               WS-NAME-ADDRESS-TABLE.   
           MOVE WS-CUSTOMER-NAME                      TO                
                                               WS-CUST-NAME.            
           MOVE WS-ACCOUNT-NAME                       TO                
                                               WS-ACCT-NAME.            
A04127     MOVE ' '                            TO WS-ALOC-ITPA-PROCESS. 
           EXIT PROGRAM.                                                
      *                                                                 00043600
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   00044000
      * INITIALIZE THE VARIABLES & GET THE VALIDATION TIMESTAMP     *   00044100
      * JOB_PARM. IF THIS IS THE FIRST CALL SET FINALIST FLAG TO    *   00044200
      * PERFORM THE INITIAL CALL IN THE VALIDATION SUB PROGRAM.     *   00044300
      ***************************************************************   00044400
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE                            WS-EMB-INPUT           
                                                 WS-SPECIAL-MAIL-ADDR-SW
                                                 WS-CMP-TABLE           
                                                 WS-NAME-TABLE          
                                                 WS-ADDRESS             
                                                 WS-HOUSE-NO-N          
                                                 WS-HOUSE-NO-1          
                                                 WS-STREET-ADDRESS      
                                                 WS-CITY                
                                                 WS-STATE               
                                                 WS-ZIP-CODE            
                                                 WS-ZIP-PLUS-4          
                                                 WS-THD-PRTY-DETAILS    
                                                 WS-MAIL-CARRIER-ROUTE  
                                                 WS-FORMATTED-ADDRESS   
                                                 WS-FREEFORM-ADDRESS    
                                                 WS-PREMISE-ADDR        
                                                 WS-MAIL-ADDR           
                                                 WS-MAIL-ADDR-TYPE      
                                                 WS-FORMATTED-NAME      
                                                 WS-SALUTATION-NAME     
                                                 WS-FMT-SALUTATION-NAME 
                                                 WS-CUSTOMER-NAME       
                                                 WS-ACCOUNT-NAME        
                                                 WS-CUST-NAME           
                                                 WS-ACCT-NAME           
                                                 WS-BARCODE-ZIP         
                                                 WS-TP-BARCODE-ZIP      
                                                 WS-HOLD-BARCODE-ZIP    
                                                 WS-FORM-ADDRESS        
                                                 WS-FREE-ADDRESS        
                                                 WS-TP-ADDRESS          
                                                 WS-NAME-ADDRESS-TABLE  
                                                 HT-CUSTOMER-ROLE-CD    
                                                 WS-NAME-ADDR-TABLE     
A04127                                           WS-HOLD-DQ-FIELDS.     
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   00047400
      * MAIN ADDRESS PROCESSING, IDENTIFIES THE TYPE OF PROCESSING. *   00047500
      ***************************************************************   00047600
                                                                        
       1000-PROCESS-ADDRESS.                                            
                                                                        
           MOVE WS-ACCOUNT-NO-AS                      TO AT-ACCOUNT-NO. 
           MOVE WS-ADDRESS-FORMAT-AS                  TO                
                                                      AT-ADDRESS-FORMAT.
           MOVE WS-ADDRESS-ID-AS                      TO AT-ADDRESS-ID. 
           MOVE WS-CUSTOMER-NO-AS                     TO CU-CUSTOMER-NO 
                                                         HT-CUSTOMER-NO 
A04127                                                   CE-CUSTOMER-NO.
                                                                        
           EVALUATE WS-ADDRESS-FLAG                                     
               WHEN 'A'                                                 
                   PERFORM 4000-MAIL-NAME-ADDRESS     THRU 4000-EXIT    
                   PERFORM 7400-GET-COAPPLICANT-NAME  THRU 7400-EXIT    
                   IF WS-MAIL-ADDR-TYPE = 'F'                           
                      MOVE WS-FMT-ZIP                 TO                
                                                      WS-BARCODE-ZIP    
                   END-IF                                               
                   IF WS-MAIL-ADDR-TYPE = 'U'                           
                      STRING                WS-FRE-ADDR-ZIP-CODE        
                                            WS-FRE-ADDR-USPS-DEL-PT-CD  
                                            DELIMITED BY SIZE INTO      
                                            WS-BARCODE-ZIP              
                   END-IF                                               
               WHEN 'C'                                                 
                   PERFORM 2000-CUST-NAME-ADDRESS     THRU 2000-EXIT    
               WHEN 'T'                                                 
                   PERFORM 4000-MAIL-NAME-ADDRESS     THRU 4000-EXIT    
                   PERFORM 7400-GET-COAPPLICANT-NAME  THRU 7400-EXIT    
                   PERFORM 2500-THD-PRTY-NAME-ADDRESS THRU 2500-EXIT    
T37389             PERFORM 2610-CHECK-TP-ADDRESS      THRU 2610-EXIT    
T37389         WHEN 'M'                                                 
T37389             PERFORM 2700-MEMO-ADDRESS          THRU 2700-EXIT    
           END-EVALUATE.                                                
                                                                        
T37389     PERFORM 2600-CHECK-ADDRESS                 THRU 2600-EXIT.   
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ***************************************************************   00050200
      * PROCESS TO GET THE CUSTOMER NAME.                           *   00050300
A04127* IF ALOC OR ITPA LETTERS, USE NAME-TYPE 'IB' NAME-TYPE       *           
A04127* TO GET NAMES.  IF NOT FOUND, USE FULL-NAME.                 *           
      ***************************************************************   00050400
                                                                        
       2000-CUST-NAME-ADDRESS.                                          
P00704     PERFORM 4080-SELECT-CUST-ADDR-XREF         THRU 4080-EXIT.   
P00704     IF DM-ADDRESS-FORMAT = 'A'                                   
P00704         MOVE DM-ADDRESS-ID TO DY-ADDRESS-ID                      
P00704         PERFORM 4050-GET-FORMATTED-ADDRESS THRU 4050-EXIT        
P00704         MOVE 'F'                   TO   WS-MAIL-ADDR-TYPE        
P00704     ELSE                                                         
P00704         MOVE DM-ADDRESS-ID TO DZ-ADDRESS-ID                      
P00704         PERFORM 4090-SELECT-ADDR-FREEFORM  THRU 4090-EXIT        
P00704         MOVE 'U'                   TO   WS-MAIL-ADDR-TYPE        
P00704     END-IF.                                                      
           PERFORM 7300-GET-CUST-NAME                 THRU 7300-EXIT.   
A04127     IF (DQ-FIRST-NAME     = SPACES OR                            
A02515         DQ-LAST-NAME      = SPACES) AND                          
A02515        DQ-NAME-FORMAT    = 'B' THEN                              
A04127        IF WS-ALOC-ITPA-PROCESS          = 'A'                    
A04127            PERFORM 4055-BUS-ALOC-ITPA      THRU 4055-EXIT        
A04127        ELSE                                                      
A04127            MOVE DQ-FULL-NAME                   TO                
A04127                                         WS-FORMATTED-NAME        
A04127        END-IF                                                    
A02515     ELSE                                                         
A02515        MOVE DQ-TITLE-PREFIX                    TO                
A02515                                         WS-FMT-TITLE-PREFIX      
A02515        MOVE DQ-FIRST-NAME                      TO                
A02515                                         WS-FMT-FIRST-NAME        
A02515        MOVE DQ-MIDDLE-NAME                     TO                
A02515                                         WS-FMT-MIDDLE-NAME       
A02515        MOVE DQ-LAST-NAME                       TO                
A02515                                         WS-FMT-LAST-NAME         
A02515        MOVE DQ-TITLE-SUFFIX-1                  TO                
A02515                                         WS-FMT-TITLE-SUFFIX-1    
A02515     END-IF.                                                      
           MOVE WS-FORMATTED-NAME                     TO                
                                               WS-NAME-REST(1).         
           MOVE 'CN'                                  TO                
                                               WS-NAME-TYPE(1).         
           MOVE WS-NAME (1)                           TO WS-EMB-INPUT.  
           INSPECT WS-EMB-INPUT REPLACING ALL                           
                                           LOW-VALUES BY SPACES.        
T37629     MOVE 96                                    TO WS-EMB-LENG.   
P00704     MOVE SPACES                                TO WS-CMP-TABLE   
A00943     PERFORM 6010-REDUCE-EMBEDDED-SPACES        THRU 6010-EXIT.   
           MOVE SPACES                                TO WS-NAME (1).   
           MOVE WS-CMP-TABLE                          TO WS-NAME (1)    
                                               WS-CUSTOMER-NAME.        
                                                                        
           PERFORM 4030-LOAD-NAME-ADDR                THRU 4030-EXIT.   
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ***************************************************************   00053700
      * MOVE FREEFORM ADDRESS FROM THE TABLE TO THE WORKING STORAGE.*   00053800
      ***************************************************************   00053900
                                                                        
       2150-MOVE-FREEFORM-ADDR.                                         
                                                                        
           MOVE DZ-ADDR-STREET                     TO                   
                                            WS-FRE-ADDR-STREET          
           MOVE DZ-ADDR-CITY-STATE                 TO                   
                                            WS-FRE-ADDR-CITY-STATE      
                                                                        
           INSPECT WS-FRE-ADDR-CITY-STATE REPLACING ALL ',' BY ' '.     
                                                                        
           MOVE DZ-ADDR-ZIP-CODE                   TO                   
                                            WS-FRE-ADDR-ZIP-CODE        
           MOVE DZ-ADDR-COUNTRY                    TO                   
                                            WS-FRE-ADDR-COUNTRY         
           MOVE DZ-USPS-DELIV-PT-CD                TO                   
                                            WS-FRE-ADDR-USPS-DEL-PT-CD  
           MOVE DZ-ADDRESS-OVERFLOW                TO                   
                                            WS-FRE-ADDRESS-OVERFLOW     
           MOVE DZ-VALIDATION-TS                   TO                   
                                            WS-FRE-VALIDATION-TS.       
           MOVE 'U'                                TO                   
                                            WS-MAIL-ADDR-TYPE.          
           STRING                           WS-FRE-ADDR-ZIP-CODE        
                                            WS-FRE-ADDR-USPS-DEL-PT-CD  
                                            DELIMITED BY SIZE INTO      
                                            WS-BARCODE-ZIP.             
       2150-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ***************************************************************   00056500
      * GET THIRD PARTY NAME & ADDRESS.                             *   00056600
      ***************************************************************   00056700
                                                                        
       2500-THD-PRTY-NAME-ADDRESS.                                      
                                                                        
           MOVE WS-TP-NAME-ID                         TO DQ-NAME-ID.    
P00740     PERFORM 4077-MASH-THIRD-PARTY-ADDR         THRU 4077-EXIT.   
P00740     IF ZW-ADDRESS-FORMAT = 'A '                                  
P00740         MOVE WS-TP-ADDRESS-ID        TO DY-ADDRESS-ID            
P00740         PERFORM 4050-GET-FORMATTED-ADDRESS THRU 4050-EXIT        
P00740         MOVE WS-FMT-ADDR-STREET      TO WS-TP-ADDR-STREET        
P00740         MOVE WS-FMT-ADDR-OVERFLOW    TO WS-TP-ADDRESS-OVERFLOW   
P00740         MOVE WS-FMT-CITY-STATE       TO WS-TP-ADDR-CITY-STATE    
P00740         MOVE WS-FMT-ZIP              TO WS-TP-ADDR-ZIP-CODE      
P00740         MOVE ' '                     TO WS-TP-ADDR-COUNTRY       
P00740         MOVE WS-FMT-USPS-DELIV-PT-CD TO WS-TP-ADDR-USPS-DELPT-CD 
P00740         MOVE WS-FMT-VALIDATION-TS    TO WS-TP-VALIDATION-TS      
P00740     ELSE                                                         
P00740         MOVE WS-TP-ADDRESS-ID        TO DZ-ADDRESS-ID            
P00740         PERFORM 4090-SELECT-ADDR-FREEFORM  THRU 4090-EXIT        
               MOVE WS-FREEFORM-ADDRESS                   TO            
                                                WS-THD-PRTY-ADDRESS     
P00740         MOVE 'U'                   TO   WS-MAIL-ADDR-TYPE        
P00740     END-IF.                                                      
           MOVE WS-BARCODE-ZIP                        TO                
                                                WS-HOLD-BARCODE-ZIP.    
           MOVE WS-BARCODE-ZIP                        TO                
                                                WS-TP-BARCODE-ZIP.      
           MOVE WS-HOLD-BARCODE-ZIP                   TO                
                                                WS-BARCODE-ZIP.         
           PERFORM 4060-GET-NAME                      THRU 4060-EXIT.   
                                                                        
           IF WS-NAME(WS-NAME-INDX)   > SPACES                          
               MOVE WS-NAME(WS-NAME-INDX)             TO WS-TP-NAME     
           ELSE                                                         
               MOVE WS-FULL-NAME(WS-NAME-INDX)        TO WS-TP-NAME     
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ***************************************************************   00058800
      * ERROR PROCESSING.                                           *   00058900
      ***************************************************************   00059000
                                                                        
       2600-CHECK-ADDRESS.                                              
                                                                        
T37389     IF (WS-ADDRESS-FORMAT-AS = 'A'                               
T37389        OR WS-MAIL-ADDR-TYPE = 'F')                               
                 IF WS-FMT-CITY-STATE-ZIP(1:7) = 'UNKNOWN'              
                    MOVE 'T'                               TO           
                                                WS-CODE-TEMP-BILL-AT    
                    STRING    'SCSCA184 : ZIP CODE NOT FOUND ON TABLE ' 
                                                A4-ZIP-CODE             
                                                ' '                     
                                                A4-ZIP-CODE-TOKEN       
                                                DELIMITED BY SIZE       
                                                INTO WS-MISC-MSG-TEXT   
                    MOVE +50                      TO WS-MISC-MSG-LEN    
                    PERFORM 9910-MISC-ERROR     THRU 9910-EXIT          
                 END-IF                                                 
           END-IF.                                                      
                                                                        
T35152     IF WS-ADDRESS-FLAG NOT = 'M'                                 
T37389         IF (WS-ACCOUNT-NAME = SPACES                             
T37389             AND WS-CUSTOMER-NAME = SPACES)                       
T37389             MOVE 'T'                             TO              
T37389                                            WS-CODE-TEMP-BILL-AT  
T37389             MOVE WS-ACCOUNT-NO-AS                TO              
T37389                                            WS-DISPLAY-ACCOUNT    
T37389             STRING          'SCSCA184 : NAME NOT FOUND-ACCT'     
T37389                                            WS-DISPLAY-ACCOUNT    
T37389                                            DELIMITED BY SIZE     
T37389                                            INTO WS-MISC-MSG-TEXT 
T37389             MOVE +59                         TO WS-MISC-MSG-LEN  
T37389             PERFORM 9910-MISC-ERROR        THRU 9910-EXIT        
T37389         END-IF                                                   
T35152     END-IF                                                       
                                                                        
T37389     IF WS-MAIL-ADDR-TYPE = SPACES                                
T37389        MOVE 'T'                             TO                   
T37389                                         WS-CODE-TEMP-BILL-AT     
T37389        MOVE WS-ACCOUNT-NO-AS                TO                   
T37389                                         WS-DISPLAY-ACCOUNT       
T37389        STRING          'SCSCA184 : ADDR NOT FOUND-ACCT'          
T37389                                         WS-DISPLAY-ACCOUNT       
T37389                                         DELIMITED BY SIZE        
T37389                                         INTO WS-MISC-MSG-TEXT    
T37389        MOVE +59                             TO WS-MISC-MSG-LEN   
T37389        PERFORM 9910-MISC-ERROR              THRU 9910-EXIT       
T37389     END-IF                                                       
                                                                        
T37389     IF (WS-ADDRESS-FORMAT-AS = 'A'                               
T37389        OR WS-MAIL-ADDR-TYPE = 'F')                               
                 IF ((WS-FMT-ADDR-STREET = SPACES                       
                    OR WS-FMT-CITY-STATE = SPACES)                      
                    AND (WS-MST-SUB-ACCT-IND-AT NOT = 'S'               
                    AND WS-CODE-PRNT-BLL-MST-AT NOT = 'A'))             
                         MOVE 'T'                             TO        
                                                    WS-CODE-TEMP-BILL-AT
                         MOVE WS-ACCOUNT-NO-AS                TO        
                                                    WS-DISPLAY-ACCOUNT  
T37389                   IF WS-ADDRESS-FORMAT-AS = 'A'                  
                            MOVE WS-ADDRESS-ID-AS                TO     
                                                    WS-DISPLAY-ADDR-ID  
T37389                      STRING 'SCSCA184 : FMT ADDR NOT FOUND-ACCT '
                                               WS-DISPLAY-ACCOUNT       
                                             ' ADDR ID '                
                                               WS-DISPLAY-ADDR-ID       
                                               DELIMITED BY SIZE        
                                               INTO WS-MISC-MSG-TEXT    
T37389                   ELSE                                           
T37389                      STRING 'SCSCA184 : FMT ADDR NOT FOUND-ACCT '
T37389                                         WS-DISPLAY-ACCOUNT       
T37389                                         DELIMITED BY SIZE        
T37389                                         INTO WS-MISC-MSG-TEXT    
T37389                   END-IF                                         
T37389                   MOVE +70                     TO WS-MISC-MSG-LEN
                         PERFORM 9910-MISC-ERROR      THRU 9910-EXIT    
                 END-IF                                                 
           END-IF.                                                      
                                                                        
T37389     IF (WS-ADDRESS-FORMAT-AS = 'B'                               
T37389        OR WS-MAIL-ADDR-TYPE = 'U')                               
                 IF (WS-FRE-ADDR-STREET = SPACES                        
                    OR WS-FRE-ADDR-CITY-STATE = SPACES)                 
                    AND (WS-MST-SUB-ACCT-IND-AT NOT = 'S'               
                    AND WS-CODE-PRNT-BLL-MST-AT NOT = 'A')              
                        MOVE 'T'                             TO         
                                                    WS-CODE-TEMP-BILL-AT
                        MOVE WS-ACCOUNT-NO-AS                TO         
                                                    WS-DISPLAY-ACCOUNT  
T37389                  IF WS-ADDRESS-FORMAT-AS = 'B'                   
                           MOVE WS-ADDRESS-ID-AS             TO         
                                                    WS-DISPLAY-ADDR-ID  
T37389                     STRING 'SCSCA184 : FRE ADDR NOT FOUND-ACCT ' 
                                   WS-DISPLAY-ACCOUNT                   
                                   ' ADDR ID '                          
                                   WS-DISPLAY-ADDR-ID                   
                                   DELIMITED BY SIZE                    
                                   INTO WS-MISC-MSG-TEXT                
T37389                  ELSE                                            
T37389                     STRING 'SCSCA184 : FRE ADDR NOT FOUND-ACCT ' 
T37389                             WS-DISPLAY-ACCOUNT                   
T37389                             DELIMITED BY SIZE                    
T37389                             INTO WS-MISC-MSG-TEXT                
T37389                  END-IF                                          
                        MOVE +70                      TO WS-MISC-MSG-LEN
                        PERFORM 9910-MISC-ERROR       THRU 9910-EXIT    
                 END-IF                                                 
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00065300
T37389 2610-CHECK-TP-ADDRESS.                                           
T37389*                                                                 00065300
T37389     IF (WS-TP-ADDR-STREET = SPACES OR                            
T37389         WS-TP-ADDR-CITY-STATE = SPACES)                          
T37389          MOVE 'T'                             TO                 
T37389                                         WS-CODE-TEMP-BILL-AT     
T37389          MOVE WS-ACCOUNT-NO-AS                TO                 
T37389                                         WS-DISPLAY-ACCOUNT       
T37389          MOVE WS-TP-ADDRESS-ID                TO                 
T37389                                         WS-DISPLAY-ADDR-ID       
T37389          STRING 'SCSCA184 : TP ADDR NOT FOUND-ACCT'              
T37389                                         WS-DISPLAY-ACCOUNT       
T37389                                        ' ADDR ID '               
T37389                                         WS-DISPLAY-ADDR-ID       
T37389                                         DELIMITED BY SIZE        
T37389                                         INTO WS-MISC-MSG-TEXT    
T37389          MOVE +70                             TO WS-MISC-MSG-LEN 
T37389          PERFORM 9910-MISC-ERROR              THRU 9910-EXIT     
T37389     END-IF.                                                      
T37389                                                                  
T37389     IF WS-TP-NAME = SPACES                                       
T37389          MOVE 'T'                             TO                 
T37389                                         WS-CODE-TEMP-BILL-AT     
T37389          MOVE WS-ACCOUNT-NO-AS                TO                 
T37389                                         WS-DISPLAY-ACCOUNT       
T37389          MOVE WS-TP-NAME-ID                   TO                 
T37389                                         WS-DISPLAY-NAME-ID       
T37389          STRING 'SCSCA184 : TP NAME NOT FOUND-ACCT'              
T37389                                         WS-DISPLAY-ACCOUNT       
T37389                                        ' NAME ID '               
T37389                                         WS-DISPLAY-NAME-ID       
T37389                                         DELIMITED BY SIZE        
T37389                                         INTO WS-MISC-MSG-TEXT    
T37389          MOVE +70                             TO WS-MISC-MSG-LEN 
T37389          PERFORM 9910-MISC-ERROR              THRU 9910-EXIT     
T37389     END-IF.                                                      
T37389*                                                                 00065300
T37389 2610-EXIT.                                                       
T37389      EXIT.                                                       
T37389*                                                                 00065300
T37389**************************************************************            
T37389** 2700-MEMO-ADDRESS -- PROCESS MEMO ADDRESS                **            
T37389**************************************************************            
T37389                                                                  
T37389 2700-MEMO-ADDRESS.                                               
T37389                                                                  
T37389     MOVE WS-ACCOUNT-NO-AS               TO HT-ACCOUNT-NO.        
T37389     MOVE WS-NAME-ID-AS                  TO DQ-NAME-ID.           
T37389     MOVE WS-ADDRESS-ID-AS               TO DZ-ADDRESS-ID.        
T37389     PERFORM 4060-GET-NAME              THRU 4060-EXIT.           
P00740     IF CV-ADDRESS-FORMAT = 'A '                                  
P00740         MOVE WS-ADDRESS-ID-AS TO DY-ADDRESS-ID                   
P00740         PERFORM 4050-GET-FORMATTED-ADDRESS THRU 4050-EXIT        
P00740         MOVE 'F'                   TO   WS-MAIL-ADDR-TYPE        
P00740     ELSE                                                         
P00740         MOVE WS-ADDRESS-ID-AS TO DZ-ADDRESS-ID                   
P00740         PERFORM 4090-SELECT-ADDR-FREEFORM  THRU 4090-EXIT        
P00740         MOVE 'U'                   TO   WS-MAIL-ADDR-TYPE        
P00740     END-IF.                                                      
           PERFORM 7300-GET-CUST-NAME                 THRU 7300-EXIT.   
T37389     PERFORM 4030-LOAD-NAME-ADDR        THRU 4030-EXIT.           
T37389     MOVE WS-FRE-ADDR-ZIP-CODE (1:5)     TO WS-ACCT-ZIPCODE.      
T37389     MOVE WS-FRE-ADDR-ZIP-CODE (6:4)     TO                       
T37389                                      WS-ACCT-ZIP-PLUS-FOUR.      
T37389                                                                  
T37389 2700-EXIT.                                                       
T37389     EXIT.                                                        
T37389                                                                  
      **************************************************************    00065400
      * PRIOR TO PERFORMING THIS ROUTINE, THE ACCOUNT TABLE HAS    *    00065500
      * BEEN READ. THIS ROUTINE OPENS A CURSOR FOR THE NAME AND    *    00065600
      * NAME XREF TABLES AND SELECTS ONLY NAMES WITH A TYPE OF     *    00065700
      * CN, AN, AA, DB, AND AI WHICH ARE NAMES THAT WOULD BE USED  *    00065800
      * FOR MAILING PURPOSES. THIS ROUTINE CAN BE USED TO RETRIEVE *    00065900
      * ALL NAMES THAT ARE ASSOCIATED WITH AN ACCOUNT.             *    00066000
      * BE SURE TO INCLUDE THE FOLLOWING COPYBOOKS:                *    00066100
      *    1. CWS000074 WORK AREAS FOR NAME AND ADDRESS            *    00066200
      *    2. CPD000004 6010-REDUCE-EMBEDDED-SPACES.               *    00066300
      *    3. CWS000011 FOR  6010-REDUCE-EMBEDDED-SPACES.          *    00066400
      * BE SURE TO INCLUDE THE FOLLOWING TABLES:                   *    00066500
      *    1. TBNAME     NAME TABLE                                *    00066600
      *    2. TBNMACTX   NAME ACCOUNT CROSS REFERENCE              *    00066700
      *    3. TBCSADRX   CUSTOMER ADDRESS CROSS REFERENCE          *    00066800
      *    4. TBADRFRE   FREE FORM ADDRESS TABLE                   *    00066900
      *    5. TBADRFMT   FORMATTED ADDRESS TABLE                   *    00067000
      *    6. TBZIPCD    ZIP CODE TABLE                            *    00067100
      *    7. TBATMISC   ACCOUNT MISCELLANEOUS INFO                *    00067200
      **************************************************************    00067300
      * THIS ROUTINE IS USED TO GET THE MAILING NAME AND ADDRESS   *    00067400
      * TO PRINT ON NOTICES AND BILLS. THIS ROUTINE WILL PERFORM   *    00067500
      * THE FOLLOWING:                                             *    00067600
      *   1. RETRIEVE ALL NAMES ASSOCIATED WITH AN ACCOUNT WITH    *    00067700
      *      NAME TYPES AS FOLLOWS:                                *    00067800
      *      CN - CUSTOMER NAME                                    *    00067900
      *      AN - BILLING NAME                                     *    00068000
      *      AA - ATTENTION NAME                                   *    00068100
      *      AI - IN CARE OF NAME                                  *    00068200
      *      DB - DOING BUSINESS AS NAME                           *    00068300
      *   2. TO CONFORM TO POSTAL REQUIREMENTS (ALONG WITH SOME    *    00068400
      *      INTERNAL ISSUES)  THE FOLLOWING RULES HAVE BEEN       *    00068500
      *      IF CUSTOMER NAME AND BILLING NAME ARE ON THE ACCOUNT, *    00068600
      *         USE BILLING NAME                                   *    00068700
      *      IF NAME (CUST OR BILLING) IS A BUSINESS NAME, PRINT   *    00068800
      *         IT ON THE LINE DIRECTLY ABOVE THE FIRST LINE OF    *    00068900
      *         THE ADDRESS OTHERWISE PRINTIT ON THE LINE AFTER    *    00069000
      *         THE ATTN LINE                                      *    00069100
      *      IF IN CARE OF AND ATTN BOTH EXIST, USE THE ATTN NAME  *    00069200
      *                                                            *    00069300
      *  3.  TO DETERMINE THE MAILING ADDRESS, THE FOLLOWING       *    00069400
      *      LOGIC MUST BE PERFORMED                               *    00069500
      *      FIRST GET THE PREMISE ADDRESS USING THE ADDRESS ID    *    00069600
      *      FROM THE NAME-ADDR-XREF TABLE AND RETRIEVE THE        *    00069700
      *      ADDRESS FROM THE FORMATTED ADDRESS TABLE.             *    00069800
      *      FOR MAILING ADDRESS, CHECK THE AT TABLE TO SEE IF     *    00069900
      *      AN ADDRESS ID IS PRESENT. IF IT IS, COMPARE IT TO     *    00070000
      *      THE ADDRESS ID ON THE NAME-ADDRESS-XREF TABLE. IF     *    00070100
      *      THEY ARE THE SAME, THE PREMISE ADDRESS IS THE MAILING *    00070200
      *      ADDRESS. IF THEY ARE DIFFERENT, CHECK THE ADDRESS     *    00070300
      *      TYPE TO DETERMINE WHERE TO GET THE ADDRESS FROM.      *    00070400
      *      IF THE ADDRESS FORMAT IS 'A', READ THE FORMATTED      *    00070500
      *      ADDRESS TABLE, AND IF IT IS A 'B', READ THE FREEFORM  *    00070600
      *      ADDRESS TABLE AND LOAD THE ADDRESS INTO WOEKING       *    00070700
      *      STORAGE.                                              *    00070800
      *  4.  AFTER LOADING ALL NAMES AND ADDRESES INTO WORKING     *    00070900
      *      STORAGE TABLES, THE BLANK OCCURENCES ARE SHIFTED      *    00071000
      *      OUT SO THAT THE NAME AND ADDRESS LINES TO BE USED     *    00071100
      *      WILL BE CONSECUTIVE IN THE NAME-ADDRESS TABLE         *    00071200
      *  5.  A MAXIMUM OF 6 LINES EACH ONE BEING 50 BYTES IN       *    00071300
      *      LENGTH ARE AVAILABLE TO HOLD THE MAILING NAME AND     *    00071400
      *      ADDRESS. THE FOLLOWING IS THE ORDER EACH ITEM WILL BE *    00071500
      *      PRINTED IN IF THEY EXIST.                             *    00071600
      *         1. ADDITIONAL BILL NAME                            *    00071700
      *         2. ATTN NAME                                       *    00071800
      *         3. CUSTOMER OR BILLING NAME (IF INDIVIDUAL)        *    00071900
      *         4. DOING BUSINESS AS NAME                          *    00072000
      *         5. IN CARE OF NAME                                 *    00072100
      *         6. CUSTOMER OR BILLING NAME (IF BUSINESS NAME)     *    00072200
      *         7. ADDRESS OVERFLOW (IF PRESENT)                   *    00072300
      *         8. STREET ADDRESS LINE                             *    00072400
      *         9. CITY/STATE/ZIP/COUNTRY LINE                     *    00072500
      *  6.  AFTER COMPLETION OF THIS ROUTINE, THE MAIL NAME AND   *    00072600
      *      ADDRESS TABLE WILL BE LOADED WITH THE NAME AND        *    00072700
      *      ADDRESS AND BE READY FOR PRINTING. BLANK LINES WILL   *    00072800
      *      ALL BE AT THE BOTTOM.                                 *    00072900
      *  7.  EACH ENTRY IN THE TABLE CONTAINS A 50 BYTE NAME OR    *    00073000
      *      ADDRESS, AND A 2 BYTE NAME/ADDR TYPE SO THAT THE      *    00073100
      *      NAME OR ADDRESS CAN BE USED BY THE PROGRAM            *    00073200
      *      THE NAME/ADDRESS TYPE CODES AS FOLLOWS:               *    00073300
      *      CN - CUSTOMER NAME                                    *    00073400
      *      AN - BILLING NAME                                     *    00073500
      *      AA - ATTENTION NAME                                   *    00073600
      *      AB - ADDITIONAL BILL NAME                             *    00073700
      *      AI - IN CARE OF NAME                                  *    00073800
      *      DB - DOING BUSINESS AS NAME                           *    00073900
      *      AO - ADDRESS OVERFLOW                                 *    00074000
      *      AS - STREET ADDRESS                                   *    00074100
      *      AZ - CITY/STATE/ZIP/COUNTRY ADDRESS                   *    00074200
      *  8.  PARSED NAMES AND ADDRESSES ARE PUT TOGETHER AND RUN   *    00074300
      *      THROUGH THE REMOVE EMBEDDED SPACES ROUTINE TO PUT     *    00074400
      *      THEM TOGETHER IN A READABLE FORMAT                    *    00074500
      *  9.  ADDITIONAL FIELDS POPULATED BY THIS ROUTINE           *    00074600
      *      CUSTOMER NAME - WS-CUSTOMER-NAME                      *    00074700
      *      ACCOUNT NAME  - WS-ACCOUNT-NAME   ** THIS FIELD WILL  *    00074800
      *                      CONTAIN THE CUSTOMER NAME IF THERE IS *    00074900
      *                      NOT A SEPARATE ACCOUNT NAME           *    00075000
      *      SERVICE ADDRESS- WS-PREMISE-ADDR                      *    00075100
      *      MAIL ADDRESS   - WS-MAIL-ADDR  ** THIS FIELD WILL     *    00075200
      *                      CONTAIN SPACES IF THERE IS NO SPECIAL *    00075300
      *                      MAIL ADDRESS FOR THE ACCOUNT- IF MAIL *    00075400
      *                      ADDRESS IS NEEDED, USE PREMISE ADDR   *    00075500
      **************************************************************    00075600
      *                                                                 00075700
       4000-MAIL-NAME-ADDRESS.                                          
                                                                        
           MOVE AT-ACCOUNT-NO                         TO HT-ACCOUNT-NO. 
                                                                        
           PERFORM 4010-GET-ALL-NAMES                 THRU 4010-EXIT.   
           PERFORM 4025-DETERMINE-ADDRESS             THRU 4025-EXIT.   
           PERFORM 4030-LOAD-NAME-ADDR                THRU 4030-EXIT.   
                                                                        
           IF WS-NAME-ADDR-ENTRY (6) = SPACES                           
              MOVE AT-ACCOUNT-NO                      TO                
                                                TA-ACCOUNT-NO           
              MOVE SPACES                             TO                
                                                TA-ADDTL-BILL-NAME-TX   
                                                                        
              PERFORM 4075-SELECT-ACCT-MISC-INFO      THRU 4075-EXIT    
                                                                        
              IF TA-ADDTL-BILL-NAME-TX > SPACES                         
                 PERFORM 4035-LOAD-ADDL-BILL-NAME     THRU 4035-EXIT    
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       4000-EXIT.                                                       
           EXIT.                                                        
A04127**************************************************************    00078200
A04127*      IF ALOC OR ITPA LETTERS USE NAME-TYPE                 *            
A04127*      'IB' TO GET NAMES. IF NOT FOUND, USE EXISTING RULES.  *            
A04127**************************************************************    00078200
       4010-GET-ALL-NAMES.                                              
                                                                        
           PERFORM 7100-OPEN-NAME-CURSOR              THRU 7100-EXIT.   
           PERFORM 7150-FETCH-NAME                    THRU 7150-EXIT.   
A04127     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A04127         IF (DQ-NAME-FORMAT = 'B' AND WS-ALOC-ITPA-PROCESS = 'A') 
A04127              PERFORM 4045-MOVE-DQ-TO-HOLD-FIELDS THRU 4045-EXIT  
A04127              PERFORM 4055-BUS-ALOC-ITPA          THRU 4055-EXIT  
A04127              IF WS-IB-NAME-FOUND       = 'Y'                     
A04127                 PERFORM 7200-CLOSE-NAME        THRU 7200-EXIT    
A04127                 MOVE WS-FORMATTED-NAME    TO      WS-NAME-REST(1)
A04127                 MOVE 'CN'                 TO      WS-NAME-TYPE(1)
A04127                 MOVE WS-NAME (1)          TO      WS-EMB-INPUT   
A04127                 INSPECT WS-EMB-INPUT REPLACING ALL               
A04127                                              LOW-VALUES BY SPACES
A04127                 MOVE 96                   TO       WS-EMB-LENG   
A04127                 MOVE SPACES               TO       WS-CMP-TABLE  
A04127                 PERFORM 6010-REDUCE-EMBEDDED-SPACES              
A04127                                           THRU 6010-EXIT         
A04127                 MOVE SPACES               TO       WS-NAME (1)   
A04127                 MOVE WS-CMP-TABLE         TO       WS-NAME (1)   
A04127                                                  WS-CUSTOMER-NAME
A04127                 GO TO 4010-EXIT                                  
A04127              ELSE                                                
A04127                 MOVE ZEROES            TO WS-ACTIVE-RETURN-CODE  
A04127                 PERFORM 4047-MOVE-HOLD-FIELDS-TO-DQ              
A04127                                           THRU 4047-EXIT         
A04127              END-IF                                              
A04127         END-IF                                                   
A04127     END-IF                                                       
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
             PERFORM 4040-MOVE-DQ-TO-WS               THRU 4040-EXIT    
             PERFORM 7150-FETCH-NAME                  THRU 7150-EXIT    
           END-PERFORM.                                                 
                                                                        
           PERFORM 7200-CLOSE-NAME                    THRU 7200-EXIT.   
           PERFORM 4070-SELECT-BILL-NAME              THRU 4070-EXIT.   
                                                                        
      * SAVE CUSTOMER NAME                                              00079600
           IF WS-NAME-TYPE (2) = 'CN'                                   
              SET WS-NAME-INDX                        TO 2              
              PERFORM 4020-FORMAT-NAME                THRU 4020-EXIT    
              MOVE WS-NAME (WS-NAME-INDX)             TO                
                                               WS-CUSTOMER-NAME         
                                               WS-ACCOUNT-NAME          
              PERFORM 4022-SALUTATION-NAME            THRU 4022-EXIT    
           END-IF.                                                      
                                                                        
      * IF MAILING NAME('AN') EXISTS, THEN CUSTOMER NAME 'CN'           00080600
      * SHOULD NOT BE USED                                              00080700
      *                                                                 00080800
           IF WS-NAME-TYPE (3) = 'AN'                                   
              MOVE WS-NAME-ENTRY (3)                  TO                
                                               WS-NAME-ENTRY (2)        
              MOVE SPACES                             TO                
                                               WS-NAME-ENTRY (3)        
      *                                                                 00081400
              SET WS-NAME-INDX                        TO 2              
              PERFORM 4020-FORMAT-NAME                THRU 4020-EXIT    
              MOVE WS-NAME (WS-NAME-INDX)             TO WS-ACCOUNT-NAME
      *                                                                 00081800
              PERFORM 4022-SALUTATION-NAME            THRU 4022-EXIT    
           END-IF.                                                      
      *                                                                 00082100
      * ATTN AND IN CARE  OF SHOULD NOT BOTH BE ON AN ACCOUNT           00082200
      * IF THEY ARE BOTH FOUND, THE ATTN WILL OVERRIDE, SO MOVE         00082300
      * SPACES TO THE IN CARE OF ENTRY                                  00082400
      *                                                                 00082500
           IF WS-NAME-TYPE (1) = 'AA'                                   
              IF WS-NAME-ENTRY (4) = 'AI'                               
                 MOVE SPACES                          TO                
                                               WS-NAME-ENTRY (4)        
           END-IF
           END-IF.                                                      
      *                                                                 00083100
      * IF CUSTOMER/BILLING NAME IS 'B' (BUSINESS), IT SHOULD BE        00083200
      * SHIFTED SO THAT IT IS THE LAST NAME THAT APPEARS BEFORE         00083300
      * THE ADDRESS                                                     00083400
      *                                                                 00083500
           IF WS-NAME-TYPE (4) = 'DB'                                   
               CONTINUE                                                 
           ELSE                                                         
               IF WS-NAME-FORMAT (2) = 'B'                              
                  MOVE WS-NAME-ENTRY (2)              TO                
                                               WS-BUSINESS-NAME-ENTRY   
                  MOVE WS-NAME-ENTRY (3)              TO                
                                               WS-NAME-ENTRY (2)        
                  MOVE WS-NAME-ENTRY (4)              TO                
                                               WS-NAME-ENTRY (3)        
                  MOVE WS-NAME-ENTRY (5)              TO                
                                               WS-NAME-ENTRY (4)        
                  MOVE WS-BUSINESS-NAME-ENTRY         TO                
                                               WS-NAME-ENTRY (5)        
               END-IF                                                   
           END-IF.                                                      
      *                                                                 00085200
           MOVE 1                                     TO SUB1.          
           MOVE 2                                     TO SUB2.          
           PERFORM 4015-SHIFT-NAME-TABLE              THRU 4015-EXIT.   
           PERFORM 4020-FORMAT-NAME                   THRU 4020-EXIT    
                             VARYING WS-NAME-INDX FROM 1 BY 1 UNTIL     
                             (WS-NAME-INDX > 5 OR                       
                                WS-NAME-ENTRY (WS-NAME-INDX) = SPACES). 
                                                                        
       4010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************    00086400
      * THIS ROUTINE SHIFTS IN THE WS TABLE UP, LEAVING BLANK      *    00086500
      * OCCURRENCES AT THE END.                                    *    00086600
      **************************************************************    00086700
       4015-SHIFT-NAME-TABLE.                                           
                                                                        
              IF SUB2 > 5                                               
                 GO TO 4015-EXIT
              END-IF.                                       
                                                                        
              IF WS-NAME-ENTRY (SUB1) = SPACES                          
                 IF WS-NAME-ENTRY (SUB2) > SPACES                       
                    MOVE WS-NAME-ENTRY (SUB2)         TO                
                                               WS-NAME-ENTRY (SUB1)     
                    MOVE SPACES                       TO                
                                               WS-NAME-ENTRY (SUB2)     
                    ADD 1                             TO SUB1 SUB2      
                 ELSE                                                   
                    ADD 1                             TO SUB2           
                 END-IF                                                 
              ELSE                                                      
                 ADD 1                                TO SUB1 SUB2      
              END-IF.                                                   
                                                                        
              GO TO 4015-SHIFT-NAME-TABLE.                              
                                                                        
       4015-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00089100
      ****************************************************************  00089200
      * THIS ROUTINE MOVE THE FULL NAME IF THE NAME TYPE IS BUSINESS *  00089300
      * AND PUTS NAME PIECES TOGETHER TO FORM THE INDIVIDUAL'S NAME. *  00089400
      ****************************************************************  00089500
       4020-FORMAT-NAME.                                                
                                                                        
           MOVE SPACES                                TO                
                                               WS-NAME(WS-NAME-INDX)    
                                               WS-FORMATTED-NAME        
                                               WS-EMB-INPUT             
                                               WS-CMP-TABLE.            
                                                                        
           IF WS-NAME-FORMAT (WS-NAME-INDX) = 'B'                       
              MOVE WS-FULL-NAME (WS-NAME-INDX)        TO                
                                             WS-NAME-REST (WS-NAME-INDX)
           ELSE                                                         
              MOVE WS-FIRST-NAME(WS-NAME-INDX)        TO                
                                               WS-FMT-FIRST-NAME        
              MOVE WS-MIDDLE-NAME(WS-NAME-INDX)       TO                
                                               WS-FMT-MIDDLE-NAME       
              MOVE WS-LAST-NAME(WS-NAME-INDX)         TO                
                                               WS-FMT-LAST-NAME         
              MOVE WS-TITLE-PREFIX(WS-NAME-INDX)      TO                
                                               WS-FMT-TITLE-PREFIX      
              MOVE WS-TITLE-SUFFIX-1(WS-NAME-INDX)    TO                
                                               WS-FMT-TITLE-SUFFIX-1    
              MOVE WS-TITLE-SUFFIX-2(WS-NAME-INDX)    TO                
                                               WS-FMT-TITLE-SUFFIX-2    
              MOVE WS-FORMATTED-NAME                  TO                
                                             WS-NAME-REST (WS-NAME-INDX)
           END-IF.                                                      
                                                                        
           IF WS-NAME-TYPE (WS-NAME-INDX) = 'AA'                        
             MOVE 'ATTN: '                            TO                
                                          WS-NAME-ATTN-CO (WS-NAME-INDX)
           END-IF.                                                      
                                                                        
           IF WS-NAME-TYPE (WS-NAME-INDX) = 'AI'                        
             MOVE 'C/O '                              TO                
                                          WS-NAME-ATTN-CO (WS-NAME-INDX)
           END-IF.                                                      
                                                                        
           IF WS-NAME-TYPE (WS-NAME-INDX) = 'DB'                        
             MOVE 'DBA '                              TO                
                                          WS-NAME-ATTN-CO (WS-NAME-INDX)
             MOVE WS-FULL-NAME (WS-NAME-INDX)         TO                
                                          WS-NAME-REST (WS-NAME-INDX)   
           END-IF.                                                      
                                                                        
           MOVE WS-NAME (WS-NAME-INDX)                TO WS-EMB-INPUT.  
           INSPECT WS-EMB-INPUT REPLACING ALL                           
                                           LOW-VALUES BY SPACES.        
T37629     MOVE 96                                    TO WS-EMB-LENG.   
A00943     PERFORM 6010-REDUCE-EMBEDDED-SPACES        THRU 6010-EXIT.   
           MOVE SPACES                                TO                
                                               WS-NAME (WS-NAME-INDX).  
           MOVE WS-CMP-TABLE                          TO                
                                               WS-NAME (WS-NAME-INDX).  
                                                                        
       4020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00094900
      ****************************************************************  00095000
      * THIS ROUTINE WILL CREATE A SALUTATION NAME USING THE NAME IN *  00095100
      * OCCURENCE 2 OF THE NAME TABLE (WILL BE EITHER CUSTOMER NAME  *  00095200
      * OR ACCOUNT NAME). IF A NAME PREFIX IS FOUND, THE PREFIX AND  *  00095300
      * LAST NAME WILL BE PUT TOGETHR, OTHERWISE, FIRST, MIDDLE AND  *  00095400
      * LAST NAME WILL BE USED.                                      *  00095500
      ****************************************************************  00095600
       4022-SALUTATION-NAME.                                            
           INITIALIZE                          WS-SALUTATION-NAME       
                                               WS-FMT-SALUTATION-NAME   
                                               WS-CMP-TABLE             
                                               WS-EMB-INPUT.            
           IF WS-NAME-FORMAT (2) = 'B'                                  
              MOVE WS-FULL-NAME (2)                   TO                
                                               WS-FMT-SALUTATION-NAME   
           ELSE                                                         
              IF WS-TITLE-PREFIX (2) > SPACES                           
                 MOVE WS-TITLE-PREFIX (2)             TO                
                                               WS-FMT-SAL-TITLE-1       
                 MOVE WS-LAST-NAME (2)                TO                
                                               WS-FMT-SAL-LAST-NAME-1   
              ELSE                                                      
                  MOVE WS-FIRST-NAME (2)              TO                
                                               WS-FMT-SAL-FIRST-NAME    
                  MOVE WS-MIDDLE-NAME (2)             TO                
                                               WS-FMT-SAL-MIDDLE-NAME   
                  MOVE WS-LAST-NAME (2)               TO                
                                               WS-FMT-SAL-LAST-NAME
              END-IF
           END-IF.    
                                                                        
           MOVE WS-FMT-SALUTATION-NAME                TO WS-EMB-INPUT.  
           INSPECT WS-EMB-INPUT REPLACING ALL                           
                                           LOW-VALUES BY SPACES.        
           MOVE 91                                    TO WS-EMB-LENG.   
A00943     PERFORM 6010-REDUCE-EMBEDDED-SPACES        THRU 6010-EXIT.   
           MOVE SPACES                                TO                
                                               WS-SALUTATION-NAME.      
           MOVE WS-CMP-TABLE                          TO                
                                               WS-SALUTATION-NAME.      
                                                                        
       4022-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************    00098800
      * GET PREMISE ADDRESS, AND SEE IF THERE IS A SPECIAL MAILING *    00098900
      * ADDRESS THAT SHOULD BE USED.                               *    00099000
      **************************************************************    00099100
       4025-DETERMINE-ADDRESS.                                          
                                                                        
           MOVE HT-ADDRESS-ID                         TO DY-ADDRESS-ID. 
           PERFORM 4050-GET-FORMATTED-ADDRESS         THRU 4050-EXIT.   
           IF WS-FORMATTED-ADDRESS = SPACES                             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-FMT-ADDR-STREET                 TO                
                                               WS-PR-STREET             
              MOVE WS-FMT-ADDR-OVERFLOW               TO                
                                               WS-PR-ADDR-OVERFLOW      
              MOVE WS-FMT-CITY-STATE                  TO                
                                               WS-PR-ADDR-CITY-STATE    
              MOVE WS-FMT-CITY-STATE-ZIP              TO                
                                               WS-PR-ADDR-CITY-STATE-ZIP
              MOVE WS-FMT-ZIP                         TO                
                                               WS-PR-ADDR-ZIP           
                                               WS-BARCODE-ZIP           
              MOVE 'F'                                TO                
                                               WS-MAIL-ADDR-TYPE        
           END-IF.                                                      
                                                                        
           IF AT-ADDRESS-ID NOT EQUAL ZERO    AND                       
              AT-ADDRESS-ID NOT EQUAL HT-ADDRESS-ID                     
              MOVE 'Y'                                TO                
                                               WS-SPECIAL-MAIL-ADDR-SW  
              INITIALIZE                       WS-FORMATTED-ADDRESS     
              IF AT-ADDRESS-FORMAT = 'A'                                
                 MOVE AT-ADDRESS-ID                   TO DY-ADDRESS-ID  
                 PERFORM 4050-GET-FORMATTED-ADDRESS   THRU 4050-EXIT    
                 IF WS-FORMATTED-ADDRESS > SPACES                       
                    MOVE 'F'                          TO                
                                               WS-MAIL-ADDR-TYPE        
                 END-IF                                                 
                 MOVE SPACES                          TO                
                                               WS-BARCODE-ZIP           
                 MOVE WS-FMT-ZIP                      TO                
                                               WS-BARCODE-ZIP           
              ELSE                                                      
                 IF AT-ADDRESS-FORMAT = 'B'                             
                    MOVE AT-ADDRESS-ID                TO DZ-ADDRESS-ID  
                    PERFORM 4090-SELECT-ADDR-FREEFORM THRU 4090-EXIT    
P00704              MOVE 'U'                          TO                
P00704                                         WS-MAIL-ADDR-TYPE        
                    MOVE SPACES                       TO                
                                               WS-BARCODE-ZIP           
                    STRING                  WS-FRE-ADDR-ZIP-CODE        
                                            WS-FRE-ADDR-USPS-DEL-PT-CD  
                                            DELIMITED BY SIZE INTO      
                                            WS-BARCODE-ZIP              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       4025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  00103600
      * MOVE MAILING NAME AND ADDRESS TO NAME-ADDR-LINES             *  00103700
      * ADDITIONALLY, THE WS-MAIL-ADDR FIELD IS LOADED AS THIS IS    *  00103800
      * BEING BUILT, BUT IF THE ACCOUNT DOES NOT HAVE A SPECIAL MAIL *  00103900
      * ADDRESS, THE FIELD WILL BE INITIALIZED, SO THAT ONLY ACCOUNT *  00104000
      * WITH SPECIAL MAIL ADDRESS WILL HAVE THIS WS FIELD POPULATED  *  00104100
      ****************************************************************  00104200
                                                                        
       4030-LOAD-NAME-ADDR.                                             
                                                                        
            INITIALIZE                         WS-NAME-ADDR-TABLE       
                                               WS-MAIL-CARRIER-ROUTE.   
            SET WS-NM-ADDR-INDX                       TO 1.             
                                                                        
            IF WS-NAME-ENTRY (1) > SPACES                               
               MOVE WS-NAME-TYPE (1)                  TO                
                                   WS-NAME-ADDR-TYPE (WS-NM-ADDR-INDX)  
               MOVE WS-NAME (1)                       TO                
                                   WS-NAME-ADDR-LINE (WS-NM-ADDR-INDX)  
               SET WS-NM-ADDR-INDX                    UP BY 1           
            END-IF.                                                     
                                                                        
            IF WS-NAME-ENTRY (2) > SPACES                               
               MOVE WS-NAME-TYPE (2)                  TO                
                                   WS-NAME-ADDR-TYPE (WS-NM-ADDR-INDX)  
               MOVE WS-NAME (2)                       TO                
                                   WS-NAME-ADDR-LINE (WS-NM-ADDR-INDX)  
               SET WS-NM-ADDR-INDX                    UP BY 1           
            END-IF.                                                     
                                                                        
            IF WS-NAME-ENTRY (3) > SPACES                               
               MOVE WS-NAME-TYPE (3)                  TO                
                                   WS-NAME-ADDR-TYPE (WS-NM-ADDR-INDX)  
               MOVE WS-NAME (3)                       TO                
                                   WS-NAME-ADDR-LINE (WS-NM-ADDR-INDX)  
               SET WS-NM-ADDR-INDX                    UP BY 1           
            END-IF.                                                     
                                                                        
            IF WS-MAIL-ADDR-TYPE = 'F'                                  
               IF WS-FMT-ADDR-OVERFLOW > SPACES                         
                  MOVE WS-FMT-ADDR-OVERFLOW           TO                
                                   WS-NAME-ADDR-LINE (WS-NM-ADDR-INDX)  
                                   WS-MAIL-ADDR-OVERFLOW                
                  MOVE 'AO'                           TO                
                                   WS-NAME-ADDR-TYPE (WS-NM-ADDR-INDX)  
                  SET WS-NM-ADDR-INDX                 UP BY 1           
               END-IF                                                   
            ELSE                                                        
               IF WS-FRE-ADDRESS-OVERFLOW > SPACES                      
                  MOVE WS-FRE-ADDRESS-OVERFLOW        TO                
                                   WS-NAME-ADDR-LINE (WS-NM-ADDR-INDX)  
                                   WS-MAIL-ADDR-OVERFLOW                
                  MOVE 'AO'                           TO                
                                   WS-NAME-ADDR-TYPE (WS-NM-ADDR-INDX)  
                  SET WS-NM-ADDR-INDX                 UP BY 1           
               END-IF                                                   
            END-IF.                                                     
                                                                        
            IF WS-MAIL-ADDR-TYPE = 'F'                                  
               IF WS-FMT-ADDR-STREET > SPACES                           
                  MOVE WS-FMT-ADDR-STREET             TO                
                                   WS-NAME-ADDR-LINE (WS-NM-ADDR-INDX)  
                                   WS-MAIL-ADDR-STREET                  
                  MOVE 'AS'                           TO                
                                   WS-NAME-ADDR-TYPE (WS-NM-ADDR-INDX)  
                  SET WS-NM-ADDR-INDX                 UP BY 1           
               END-IF                                                   
            ELSE                                                        
               IF WS-FRE-ADDR-STREET > SPACES                           
                  MOVE WS-FRE-ADDR-STREET             TO                
                                   WS-NAME-ADDR-LINE (WS-NM-ADDR-INDX)  
                                   WS-MAIL-ADDR-STREET                  
                  MOVE 'AS'                           TO                
                                   WS-NAME-ADDR-TYPE (WS-NM-ADDR-INDX)  
                  SET WS-NM-ADDR-INDX                 UP BY 1           
               END-IF                                                   
            END-IF.                                                     
            IF WS-MAIL-ADDR-TYPE = 'F'                                  
               IF WS-FMT-CITY-STATE-ZIP  > SPACES                       
                  MOVE WS-FMT-CITY-STATE-ZIP          TO                
                                   WS-NAME-ADDR-LINE (WS-NM-ADDR-INDX)  
                                   WS-MAIL-ADDR-CITY-STATE-ZIP          
                  MOVE 'AZ'                           TO                
                                   WS-NAME-ADDR-TYPE (WS-NM-ADDR-INDX)  
                  SET WS-NM-ADDR-INDX                 UP BY 1           
               END-IF                                                   
            ELSE                                                        
               IF WS-FRE-ADDR-CITY-STATE > SPACES                       
                  IF WS-FRE-ADDR-ZIP-CODE (6:4) > 0                     
                      MOVE WS-FRE-ADDR-ZIP-CODE (1:5) TO                
                                               WS-FORMAT-ZIP-1          
                      MOVE WS-FRE-ADDR-ZIP-CODE (6:4) TO                
                                               WS-FORMAT-ZIP-2          
                                                                        
                      STRING    WS-FRE-ADDR-CITY-STATE                  
A00943                          '*'                                     
                                WS-FORMAT-ZIP-PLUS                      
                                WS-FRE-ADDR-COUNTRY                     
                                DELIMITED BY SIZE                       
                                INTO WS-NAME-ADDR-LINE (WS-NM-ADDR-INDX)
                  ELSE                                                  
                      STRING    WS-FRE-ADDR-CITY-STATE                  
A00943                          '*'                                     
                                WS-FRE-ADDR-ZIP-CODE                    
                                WS-FRE-ADDR-COUNTRY                     
                                DELIMITED BY SIZE                       
                                INTO WS-NAME-ADDR-LINE (WS-NM-ADDR-INDX)
                  END-IF                                                
                  MOVE 'AZ'                           TO                
                                   WS-NAME-ADDR-TYPE (WS-NM-ADDR-INDX)  
                  MOVE 64                             TO WS-EMB-LENG    
                  MOVE SPACES                         TO WS-EMB-INPUT   
                                                         WS-CMP-TABLE   
                  MOVE WS-NAME-ADDR-LINE(WS-NM-ADDR-INDX) TO            
                                                         WS-EMB-INPUT   
                  INSPECT WS-EMB-INPUT REPLACING ALL                    
                                           LOW-VALUES BY SPACES         
A00943            PERFORM 6010-REDUCE-EMBEDDED-SPACES     THRU 6010-EXIT
A00943            INSPECT WS-CMP-TABLE REPLACING ALL                    
A00943                                     '*'        BY SPACES         
                  MOVE SPACES                         TO                
                                   WS-NAME-ADDR-LINE (WS-NM-ADDR-INDX)  
                                   WS-MAIL-ADDR-CITY-STATE-ZIP          
                  MOVE WS-CMP-TABLE                   TO                
                                   WS-NAME-ADDR-LINE (WS-NM-ADDR-INDX)  
                                   WS-MAIL-ADDR-CITY-STATE-ZIP          
                  SET WS-NM-ADDR-INDX                 UP BY 1           
               END-IF                                                   
            END-IF.                                                     
            IF WS-MAIL-ADDR-TYPE = 'F'                                  
               IF WS-FMT-CITY-STATE > SPACES                            
                  MOVE WS-FMT-CITY-STATE              TO                
                                               WS-MAIL-ADDR-CITY-STATE  
                  MOVE WS-FMT-ZIP-CODE                TO                
                                               WS-MAIL-ADDR-ZIP         
                  MOVE WS-FMT-ZIP-PLUS-4              TO                
                                               WS-MAIL-ADDR-ZIP-PLUS-4  
                  MOVE WS-FMT-USPS-DELIV-PT-CD        TO                
                                           WS-MAIL-ADDR-USPS-DELIV-PT-CD
               END-IF                                                   
            ELSE                                                        
               IF WS-FRE-ADDR-CITY-STATE > SPACES                       
                  MOVE WS-FRE-ADDR-CITY-STATE         TO                
                                                WS-MAIL-ADDR-CITY-STATE 
                  MOVE WS-FRE-ADDR-ZIP-CODE(1:5)      TO                
                                                WS-MAIL-ADDR-ZIP        
                  MOVE WS-FRE-ADDR-ZIP-CODE(6:4)      TO                
                                                WS-MAIL-ADDR-ZIP-PLUS-4 
               END-IF                                                   
            END-IF.                                                     
                                                                        
            IF WS-SPECIAL-MAIL-ADDR-SW NOT EQUAL 'Y'                    
               MOVE SPACES                            TO WS-MAIL-ADDR   
            END-IF.                                                     
                                                                        
       4030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************    00118700
      * MOVE ADDITIONAL BILL NAME INFO TO NAME ADDR FIRST POSITION *    00118800
      **************************************************************    00118900
      *                                                                 00119000
       4035-LOAD-ADDL-BILL-NAME.                                        
                                                                        
           MOVE WS-NAME-ADDR-ENTRY (5)                TO                
                                               WS-NAME-ADDR-ENTRY (6).  
           MOVE WS-NAME-ADDR-ENTRY (4)                TO                
                                               WS-NAME-ADDR-ENTRY (5).  
           MOVE WS-NAME-ADDR-ENTRY (3)                TO                
                                               WS-NAME-ADDR-ENTRY (4).  
           MOVE WS-NAME-ADDR-ENTRY (2)                TO                
                                               WS-NAME-ADDR-ENTRY (3).  
           MOVE WS-NAME-ADDR-ENTRY (1)                TO                
                                               WS-NAME-ADDR-ENTRY (2).  
           MOVE TA-ADDTL-BILL-NAME-TX                 TO                
                                               WS-NAME-ADDR-LINE (1).   
           MOVE 'AB'                                  TO                
                                               WS-NAME-TYPE (1).        
                                                                        
       4035-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00121000
      **************************************************************    00121100
      * MOVE NAMES FROM NAME TABLE TO WORKING STORAGE              *    00121200
      **************************************************************    00121300
      *                                                                 00121400
       4040-MOVE-DQ-TO-WS.                                              
                                                                        
            MOVE DQ-NAME-TYPE                         TO                
                                          WS-NAME-TYPE (WS-NAME-INDX).  
            MOVE DQ-NAME-FORMAT                       TO                
                                          WS-NAME-FORMAT (WS-NAME-INDX).
            MOVE DQ-FIRST-NAME                        TO                
                                          WS-FIRST-NAME (WS-NAME-INDX). 
            MOVE DQ-MIDDLE-NAME                       TO                
                                          WS-MIDDLE-NAME (WS-NAME-INDX).
            MOVE DQ-LAST-NAME                         TO                
                                          WS-LAST-NAME(WS-NAME-INDX).   
            MOVE DQ-TITLE-PREFIX                      TO                
                                          WS-TITLE-PREFIX(WS-NAME-INDX).
            MOVE DQ-TITLE-SUFFIX-1                    TO                
                                        WS-TITLE-SUFFIX-1(WS-NAME-INDX).
            MOVE DQ-TITLE-SUFFIX-2                    TO                
                                        WS-TITLE-SUFFIX-2(WS-NAME-INDX).
            MOVE DQ-FULL-NAME                         TO                
                                          WS-FULL-NAME (WS-NAME-INDX).  
                                                                        
       4040-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04127**************************************************************    00121100
A04127* MOVE DQ-NAMES TO HOLD FIELDS IN CASE THEY ARE NEEDED.      *    00121200
A04127**************************************************************    00121300
A04127*                                                                 00121400
A04127 4045-MOVE-DQ-TO-HOLD-FIELDS.                                     
A04127                                                                  
A04127      MOVE DQ-NAME-TYPE       TO    WS-HOLD-NAME-TYPE.            
A04127      MOVE DQ-NAME-FORMAT     TO    WS-HOLD-NAME-FORMAT.          
A04127      MOVE DQ-FIRST-NAME      TO    WS-HOLD-FIRST-NAME.           
A04127      MOVE DQ-MIDDLE-NAME     TO    WS-HOLD-MIDDLE-NAME.          
A04127      MOVE DQ-LAST-NAME       TO    WS-HOLD-LAST-NAME.            
A04127      MOVE DQ-TITLE-PREFIX    TO    WS-HOLD-TITLE-PREFIX.         
A04127      MOVE DQ-TITLE-SUFFIX-1  TO    WS-HOLD-TITLE-SUFFIX-1.       
A04127      MOVE DQ-TITLE-SUFFIX-2  TO    WS-HOLD-TITLE-SUFFIX-2.       
A04127      MOVE DQ-FULL-NAME       TO    WS-HOLD-FULL-NAME.            
A04127                                                                  
A04127 4045-EXIT.                                                       
A04127     EXIT.                                                        
A04127**************************************************************    00121100
A04127* MOVE HOLD-FIELDS TO DQ FIELDS.                             *    00121200
A04127**************************************************************    00121300
A04127*                                                                 00121400
A04127 4047-MOVE-HOLD-FIELDS-TO-DQ.                                     
A04127                                                                  
A04127     MOVE WS-HOLD-NAME-TYPE       TO    DQ-NAME-TYPE.             
A04127     MOVE WS-HOLD-NAME-FORMAT     TO    DQ-NAME-FORMAT.           
A04127     MOVE WS-HOLD-FIRST-NAME      TO    DQ-FIRST-NAME.            
A04127     MOVE WS-HOLD-MIDDLE-NAME     TO    DQ-MIDDLE-NAME.           
A04127     MOVE WS-HOLD-LAST-NAME       TO    DQ-LAST-NAME.             
A04127     MOVE WS-HOLD-TITLE-PREFIX    TO    DQ-TITLE-PREFIX.          
A04127     MOVE WS-HOLD-TITLE-SUFFIX-1  TO    DQ-TITLE-SUFFIX-1.        
A04127     MOVE WS-HOLD-TITLE-SUFFIX-2  TO    DQ-TITLE-SUFFIX-2.        
A04127     MOVE WS-HOLD-FULL-NAME       TO    DQ-FULL-NAME.             
A04127                                                                  
A04127 4047-EXIT.                                                       
A04127     EXIT.                                                        
      **************************************************************    00123900
      * READ THE FORMATTED ADDRESS TABLE AND PUT THE INDIVIDUAL    *    00124000
      * ADDRESS PIECES TOGETHER TO FORM A STREET ADDRESS AND THEN  *    00124100
      * PERFORM ROUTINE TO REMOVE IMBEDDED SPACES. READ ZIP CODE   *    00124200
      * TABLE TO GET CITY, AND THEN PUT CITY, STATE AND ZIP        *    00124300
      * TOGETHER AND REMOVE EMBEDDED SPACES.                       *    00124400
      **************************************************************    00124500
      *                                                                 00124600
       4050-GET-FORMATTED-ADDRESS.                                      
                                                                        
           INITIALIZE                          WS-EMB-INPUT             
                                               WS-CMP-TABLE             
                                               WS-FORMATTED-ADDRESS     
                                               WS-ADDRESS.              
      *                                                                 00125300
           PERFORM 4085-SELECT-ADDR-FORMATTED         THRU 4085-EXIT.   
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              GO TO 4050-EXIT                                           
           END-IF.                                                      
      *                                                                 00125800
      *  REMOVE LEADING ZEROS FROM HOUSE NUMBER                         00125900
                                                                        
           MOVE ZEROS                                 TO WS-HOUSE-NO-N. 
           IF WS-HOUSE-NO NUMERIC                                       
              MOVE DY-HOUSE-NO                        TO WS-HOUSE-NO-N  
              MOVE SPACES                             TO WS-HOUSE-NO    
              PERFORM 5000-REMOVE-LEADING-ZEROS       THRU 5000-EXIT    
              MOVE WS-HOUSE-NO-1                      TO WS-HOUSE-NO    
           ELSE                                                         
              MOVE DY-HOUSE-NO                        TO WS-HOUSE-NO    
           END-IF.                                                      
                                                                        
           MOVE SPACES                                TO WS-EMB-INPUT   
                                                         WS-CMP-TABLE.  
           MOVE DY-ADDR-PREFIX-1                      TO                
                                               WS-ADDR-PREFIX-1.        
           MOVE DY-ADDR-PREFIX-2                      TO                
                                               WS-ADDR-PREFIX-2.        
           MOVE DY-STREET-NAME                        TO                
                                               WS-NAME-STREET.          
           MOVE DY-STREET-SUFFIX                      TO                
                                               WS-STREET-SUFFIX.        
           MOVE DY-STREET-LOCATION-1                  TO                
                                               WS-STREET-LOCATION-1.    
           MOVE DY-STREET-LOCATION-2                  TO                
                                               WS-STREET-LOCATION-2.    
           MOVE DY-ADDR-SUFFIX                        TO                
                                               WS-ADDRESS-SUFFIX.       
           MOVE WS-STREET-ADDRESS                     TO WS-EMB-INPUT.  
           INSPECT WS-EMB-INPUT REPLACING ALL                           
                                           LOW-VALUES BY SPACES.        
           MOVE 90                                    TO WS-EMB-LENG.   
           PERFORM 6010-REDUCE-EMBEDDED-SPACES        THRU 6010-EXIT.   
           MOVE SPACES                                TO                
                                               WS-FMT-ADDR-STREET.      
           MOVE WS-CMP-TABLE                          TO                
                                               WS-FMT-ADDR-STREET.      
           MOVE DY-ADDRESS-OVERFLOW                   TO                
                                               WS-FMT-ADDR-OVERFLOW.    
           MOVE DY-VALIDATION-TS                      TO                
                                               WS-FMT-VALIDATION-TS.    
           MOVE DY-ZIP-CODE                           TO A4-ZIP-CODE    
                                                         WS-ZIP-CODE.   
           MOVE DY-ZIP-CODE-PLUS-FOUR                 TO WS-ZIP-PLUS-4. 
           MOVE DY-ZIP-CODE-TOKEN                     TO                
                                               A4-ZIP-CODE-TOKEN.       
           IF DY-ZIP-CODE-PLUS-FOUR > SPACES                            
               MOVE '-'                               TO WS-ZIP-DASH    
           END-IF.                                                      
                                                                        
           MOVE ' *'                                  TO WS-ZIP-FILLER. 
           PERFORM 4095-SELECT-ZIP-CODE               THRU 4095-EXIT.   
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SPACES                             TO WS-STATE       
              MOVE 'UNKNOWN *'                        TO WS-CITY        
              MOVE DY-ZIP-CODE                        TO WS-ZIP-CODE    
           ELSE                                                         
              MOVE A4-STATE                           TO WS-STATE       
              MOVE A4-TOWN                            TO WS-CITY        
           END-IF.                                                      
      *                                                                 00131500
           MOVE SPACES                                TO WS-EMB-INPUT   
                                                         WS-CMP-TABLE.  
           MOVE WS-CITY-STATE                         TO WS-EMB-INPUT.  
           INSPECT WS-EMB-INPUT REPLACING ALL                           
                                           LOW-VALUES BY SPACES.        
           MOVE 41                                    TO WS-EMB-LENG.   
           PERFORM 6010-REDUCE-EMBEDDED-SPACES        THRU 6010-EXIT.   
           MOVE SPACES                                TO                
                                               WS-FMT-CITY-STATE-ZIP.   
           MOVE WS-CMP-TABLE                          TO                
                                               WS-FMT-CITY-STATE-ZIP.   
      *                                                                 00132300
           UNSTRING WS-FMT-CITY-STATE-ZIP                               
               DELIMITED BY '*'                                         
           INTO                                                         
               WS-FMT-CITY-STATE.                                       
      *                                                                 00132800
           INSPECT WS-FMT-CITY-STATE-ZIP  REPLACING ALL '*' BY SPACES.  
           MOVE WS-ZIP-CODE                           TO                
                                               WS-FMT-ZIP-CODE.         
           MOVE WS-ZIP-PLUS-4                         TO                
                                               WS-FMT-ZIP-PLUS-4.       
           MOVE DY-USPS-DELIV-PT-CD                   TO                
                                               WS-FMT-USPS-DELIV-PT-CD. 
       4050-EXIT.                                                       
           EXIT.                                                        
A04127**************************************************************    00133900
A04127*  THIS NAME ROUTINE WILL RETRIEVE 'IB' NAME-TYPE BASED ON   *    00134000
A04127*  NAME-ID ON CSS_CUST_STATS.  IF NOT-FOUND, FOR             *    00134100
A04127*  WS-ADDRESS-FLAG = 'C', WE USE                             *            
A04127*  FULL-NAME PREVIOUSLY RETRIEVED. IF FOUND AND NAMES = SPACES    00134200
A04127*  FOR WS-ADDRESS-FLAG = 'C', WE USE                         *            
A04127*  FULL-NAME PREVIOUSLY RETRIEVED.                           *    00134300
A04127**************************************************************    00134600
A04127 4055-BUS-ALOC-ITPA.                                              
A04127                                                                  
A04127     MOVE 'N'                    TO WS-IB-NAME-FOUND.             
A04127     PERFORM 7350-GET-INDIV-BUS-NAME   THRU 7350-EXIT.            
A04127     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A04127        IF WS-ADDRESS-FLAG = 'C'                                  
A04127            MOVE DQ-FULL-NAME    TO WS-FORMATTED-NAME             
A04127        ELSE                                                      
A04127            CONTINUE                                              
A04127        END-IF                                                    
A04127     ELSE                                                         
A04127        IF DQ-FIRST-NAME     = SPACES OR                          
A04127           DQ-LAST-NAME      = SPACES                             
A04127           IF WS-ADDRESS-FLAG = 'C'                               
A04127               MOVE DQ-FULL-NAME  TO WS-FORMATTED-NAME            
A04127           ELSE                                                   
A04127               CONTINUE                                           
A04127           END-IF                                                 
A04127        ELSE                                                      
A04127           MOVE 'Y' TO              WS-IB-NAME-FOUND              
A04127           MOVE DQ-TITLE-PREFIX            TO                     
A04127                                    WS-FMT-TITLE-PREFIX           
A04127           MOVE DQ-FIRST-NAME              TO                     
A04127                                    WS-FMT-FIRST-NAME             
A04127           MOVE DQ-MIDDLE-NAME             TO                     
A04127                                    WS-FMT-MIDDLE-NAME            
A04127           MOVE DQ-LAST-NAME               TO                     
A04127                                    WS-FMT-LAST-NAME              
A04127           MOVE DQ-TITLE-SUFFIX-1          TO                     
A04127                                    WS-FMT-TITLE-SUFFIX-1         
A04127        END-IF                                                    
A04127     END-IF.                                                      
A04127                                                                  
A04127 4055-EXIT.                                                       
A04127     EXIT.                                                        
      *                                                                 00133800
      **************************************************************    00133900
      *  THIS NAME ROUTINE WILL RETRIEVE A NAME IF THE NAME ID     *    00134000
      *  IS KNOWN. THE NAME WILL BE PLACED IN THE 1ST OCCURRENCE   *    00134100
      *  OF THE NAME TABLE AND WILL THEN GO THROUGH THE NAME       *    00134200
      *  FORMATTING LOGIC ROUTINE TO DETERMINE BUSINESS OR         *    00134300
      *  INDIVIDUAL NAME, AND WILL REMOVE ALL EMBEDDED SPACES      *    00134400
      *  AND PLACE THE NAME IN WS-NAME                             *    00134500
      **************************************************************    00134600
       4060-GET-NAME.                                                   
                                                                        
P00740     IF WS-ADDRESS-FLAG = 'M'                                     
P00740         PERFORM 4066-SELECT-NAME-AND-FORMAT                      
P00740     ELSE                                                         
P00740         PERFORM 4065-SELECT-NAME                                 
P00740     END-IF.                                                      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              SET WS-NAME-INDX                        TO 1              
              PERFORM 4040-MOVE-DQ-TO-WS              THRU 4040-EXIT    
              PERFORM 4020-FORMAT-NAME                THRU 4020-EXIT    
           END-IF.                                                      
                                                                        
       4060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************    00136000
      *  GET THE NAME FROM CSS_NAME USING THE NAME_ID.             *    00136100
      **************************************************************    00136200
       4065-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
           SELECT                                                       
                 FIRST_NAME,                                            
                 MIDDLE_NAME,                                           
                 LAST_NAME,                                             
                 FULL_NAME,                                             
                 NAME_TYPE,                                             
                 NAME_FORMAT,                                           
                 TITLE_PREFIX,                                          
                 TITLE_SUFFIX_1,                                        
                 TITLE_SUFFIX_2                                         
               INTO                                                     
                 :DQ-FIRST-NAME,                                        
                 :DQ-MIDDLE-NAME,                                       
                 :DQ-LAST-NAME,                                         
                 :DQ-FULL-NAME,                                         
                 :DQ-NAME-TYPE,                                         
                 :DQ-NAME-FORMAT,                                       
                 :DQ-TITLE-PREFIX,                                      
                 :DQ-TITLE-SUFFIX-1,                                    
                 :DQ-TITLE-SUFFIX-2                                     
              FROM CSS_NAME WITH(READUNCOMMITTED)                               
             WHERE NAME_ID = :DQ-NAME-ID                                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00136500
MFA-TR*    SELECT                                                       00136600
MFA-TR*          FIRST_NAME,                                            00136700
MFA-TR*          MIDDLE_NAME,                                           00136800
MFA-TR*          LAST_NAME,                                             00136900
MFA-TR*          FULL_NAME,                                             00137000
MFA-TR*          NAME_TYPE,                                             00137100
MFA-TR*          NAME_FORMAT,                                           00137200
MFA-TR*          TITLE_PREFIX,                                          00137300
MFA-TR*          TITLE_SUFFIX_1,                                        00137400
MFA-TR*          TITLE_SUFFIX_2                                         00137500
MFA-TR*        INTO                                                     00137600
MFA-TR*          :DQ-FIRST-NAME,                                        00137700
MFA-TR*          :DQ-MIDDLE-NAME,                                       00137800
MFA-TR*          :DQ-LAST-NAME,                                         00137900
MFA-TR*          :DQ-FULL-NAME,                                         00138000
MFA-TR*          :DQ-NAME-TYPE,                                         00138100
MFA-TR*          :DQ-NAME-FORMAT,                                       00138200
MFA-TR*          :DQ-TITLE-PREFIX,                                      00138300
MFA-TR*          :DQ-TITLE-SUFFIX-1,                                    00138400
MFA-TR*          :DQ-TITLE-SUFFIX-2                                     00138500
MFA-TR*       FROM CSS_NAME                                             00138600
MFA-TR*      WHERE NAME_ID = :DQ-NAME-ID                                00138700
MFA-TR*      WITH UR                                                    00138710
MFA-TR*    END-EXEC.                                                    00138800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE   EQUAL      SUCCESSFUL-CALL OR     
                                               NOT-FOUND                
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
               MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
               MOVE 'SELECT'                          TO ABEND-FUNCTION 
               MOVE 'CSS_NAME'                        TO TABLE-1        
               MOVE '4065'                            TO                
                                               ACTIVE-PARAGRAPH         
               MOVE DQ-NAME-ID                        TO                
                                               HOSTVAR-ELEMENT-1        
               MOVE 'NAME_ID'                         TO                
                                               TABLE-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       4065-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00141100
P00740 4066-SELECT-NAME-AND-FORMAT.                                     
P00740                                                                  
P00740     EXEC SQL                                                     
P00740     SELECT                                                       
P00740           FIRST_NAME,                                            
P00740           MIDDLE_NAME,                                           
P00740           LAST_NAME,                                             
P00740           FULL_NAME,                                             
P00740           NAME_TYPE,                                             
P00740           NAME_FORMAT,                                           
P00740           TITLE_PREFIX,                                          
P00740           TITLE_SUFFIX_1,                                        
P00740           TITLE_SUFFIX_2,                                        
P00740           ADDRESS_FORMAT                                         
P00740         INTO                                                     
P00740           :DQ-FIRST-NAME,                                        
P00740           :DQ-MIDDLE-NAME,                                       
P00740           :DQ-LAST-NAME,                                         
P00740           :DQ-FULL-NAME,                                         
P00740           :DQ-NAME-TYPE,                                         
P00740           :DQ-NAME-FORMAT,                                       
P00740           :DQ-TITLE-PREFIX,                                      
P00740           :DQ-TITLE-SUFFIX-1,                                    
P00740           :DQ-TITLE-SUFFIX-2,                                    
P00740           :CV-ADDRESS-FORMAT                                     
P00740        FROM CSS_NAME DQ WITH(READUNCOMMITTED),                           
P00740             CSS_CONTACT CV WITH(READUNCOMMITTED)                         
P00740       WHERE DQ.NAME_ID = :DQ-NAME-ID AND                         
P00740             CV.NAME_ID = DQ.NAME_ID                              
P00740                                                           
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00136500
MFA-TR*    SELECT                                                       00136600
MFA-TR*          FIRST_NAME,                                            00136700
MFA-TR*          MIDDLE_NAME,                                           00136800
MFA-TR*          LAST_NAME,                                             00136900
MFA-TR*          FULL_NAME,                                             00137000
MFA-TR*          NAME_TYPE,                                             00137100
MFA-TR*          NAME_FORMAT,                                           00137200
MFA-TR*          TITLE_PREFIX,                                          00137300
MFA-TR*          TITLE_SUFFIX_1,                                        00137400
MFA-TR*          TITLE_SUFFIX_2,                                        00137500
MFA-TR*          ADDRESS_FORMAT                                         00137500
MFA-TR*        INTO                                                     00137600
MFA-TR*          :DQ-FIRST-NAME,                                        00137700
MFA-TR*          :DQ-MIDDLE-NAME,                                       00137800
MFA-TR*          :DQ-LAST-NAME,                                         00137900
MFA-TR*          :DQ-FULL-NAME,                                         00138000
MFA-TR*          :DQ-NAME-TYPE,                                         00138100
MFA-TR*          :DQ-NAME-FORMAT,                                       00138200
MFA-TR*          :DQ-TITLE-PREFIX,                                      00138300
MFA-TR*          :DQ-TITLE-SUFFIX-1,                                    00138400
MFA-TR*          :DQ-TITLE-SUFFIX-2,                                    00138500
MFA-TR*          :CV-ADDRESS-FORMAT                                     00138500
MFA-TR*       FROM CSS_NAME DQ,                                         00138600
MFA-TR*            CSS_CONTACT CV                                       00138600
MFA-TR*      WHERE DQ.NAME_ID = :DQ-NAME-ID AND                         00138700
MFA-TR*            CV.NAME_ID = DQ.NAME_ID                              00138700
MFA-TR*      WITH UR                                                    00138710
MFA-TR*    END-EXEC.                                                    00138800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE                               TO                
P00740                                         WS-ACTIVE-RETURN-CODE.   
P00740     IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL OR       
P00740                                         NOT-FOUND                
P00740         NEXT SENTENCE                                            
P00740     ELSE                                                         
P00740         MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
P00740         MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
P00740         MOVE 'SELECT'                          TO ABEND-FUNCTION 
P00740         MOVE 'CSS_NAME'                        TO TABLE-1        
P00740         MOVE '4066'                            TO                
P00740                                         ACTIVE-PARAGRAPH         
P00740         MOVE DQ-NAME-ID                        TO                
P00740                                         HOSTVAR-ELEMENT-1        
P00740         MOVE 'NAME_ID'                         TO                
P00740                                         TABLE-ELEMENT-1          
P00740         PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
P00740     END-IF.                                                      
P00740                                                                  
P00740 4066-EXIT.                                                       
P00740     EXIT.                                                        
P00740*                                                                 00141100
       4070-SELECT-BILL-NAME.                                           
      *                                                                 00141300
           EXEC SQL                                                     
              SELECT B.FULL_NAME,                                       
                     B.NAME_FORMAT,                                     
                     B.NAME_TYPE                                        
                INTO :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT,                                   
                     :DQ-NAME-TYPE                                      
                FROM CSS_ACCT_BILL_NMES A WITH(READUNCOMMITTED),                
                     CSS_NAME B WITH(READUNCOMMITTED)                           
               WHERE A.ACCOUNT_NO = :HT-ACCOUNT-NO AND                  
                     A.NAME_ID = B.NAME_ID AND                          
                     A.NAME_TYPE = 'DB'                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00141400
MFA-TR*       SELECT B.FULL_NAME,                                       00141500
MFA-TR*              B.NAME_FORMAT,                                     00141600
MFA-TR*              B.NAME_TYPE                                        00141700
MFA-TR*         INTO :DQ-FULL-NAME,                                     00141800
MFA-TR*              :DQ-NAME-FORMAT,                                   00141900
MFA-TR*              :DQ-NAME-TYPE                                      00142000
MFA-TR*         FROM CSS_ACCT_BILL_NMES A,                              00142100
MFA-TR*              CSS_NAME B                                         00142200
MFA-TR*        WHERE A.ACCOUNT_NO = :HT-ACCOUNT-NO AND                  00142300
MFA-TR*              A.NAME_ID = B.NAME_ID AND                          00142400
MFA-TR*              A.NAME_TYPE = 'DB'                                 00142500
MFA-TR*        WITH UR                                                  00142510
MFA-TR*    END-EXEC.                                                    00142600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL          
              MOVE DQ-FULL-NAME                       TO WS-FULL-NAME(4)
              MOVE DQ-NAME-FORMAT                     TO                
                                               WS-NAME-FORMAT (4)       
              MOVE DQ-NAME-TYPE                       TO                
                                               WS-NAME-TYPE (4)         
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL  NOT-FOUND                
                   MOVE ZEROES                        TO                
                                               WS-ACTIVE-RETURN-CODE    
               ELSE                                                     
                   MOVE WS-ACTIVE-RETURN-CODE         TO RS-RETURN-CODE 
                   MOVE PROGRAM-NAME                  TO ABEND-PROGRAM  
                   MOVE 'SELECT'                      TO ABEND-FUNCTION 
                   MOVE 'CSS_ACCT_BILL_NMES'          TO TABLE-1        
                   MOVE '4070'                        TO                
                                               ACTIVE-PARAGRAPH         
                   MOVE AT-ACCOUNT-NO                 TO                
                                               HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'                  TO                
                                               TABLE-ELEMENT-1          
                   PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT    
              END-IF                                                    
           END-IF.                                                      
                                                                        
       4070-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00145700
       4075-SELECT-ACCT-MISC-INFO.                                      
                                                                        
           EXEC SQL                                                     
              SELECT ADDTL_BILL_NAME_TX                                 
                INTO :TA-ADDTL-BILL-NAME-TX                             
                FROM CSS_ACCT_MISC_INFO WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :TA-ACCOUNT-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00146000
MFA-TR*       SELECT ADDTL_BILL_NAME_TX                                 00146100
MFA-TR*         INTO :TA-ADDTL-BILL-NAME-TX                             00146200
MFA-TR*         FROM CSS_ACCT_MISC_INFO                                 00146300
MFA-TR*        WHERE ACCOUNT_NO = :TA-ACCOUNT-NO                        00146400
MFA-TR*        WITH UR                                                  00146410
MFA-TR*    END-EXEC.                                                    00146500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL OR       
                                               NOT-FOUND                
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
               MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
               MOVE 'SELECT'                          TO ABEND-FUNCTION 
               MOVE 'CSS_ACCT_MISC_INFO'              TO TABLE-1        
               MOVE '4075'                            TO                
                                               ACTIVE-PARAGRAPH         
               MOVE TA-ACCOUNT-NO                     TO                
                                               HOSTVAR-ELEMENT-1        
               MOVE 'ACCOUNT_NO'                      TO                
                                               TABLE-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       4075-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00148800
P00740 4077-MASH-THIRD-PARTY-ADDR.                                      
P00740                                                                  
ACT120     INITIALIZE ZW-ADDRESS-FORMAT.                                
P00740     EXEC SQL                                                     
P00740       SELECT                                                     
P00740       ADDRESS_FORMAT                                             
P00740       INTO :ZW-ADDRESS-FORMAT                                    
P00740       FROM CSS_THD_PRTY WITH(READUNCOMMITTED)                            
P00740       WHERE ACCOUNT_NO      =  :AT-ACCOUNT-NO AND                
P00740             NAME_ID         =  :DQ-NAME-ID                       
P00740                                                           
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00149100
MFA-TR*      SELECT                                                     00149200
MFA-TR*      ADDRESS_FORMAT                                             00149500
MFA-TR*      INTO :ZW-ADDRESS-FORMAT                                    00149800
MFA-TR*      FROM CSS_THD_PRTY                                          00149900
MFA-TR*      WHERE ACCOUNT_NO      =  :AT-ACCOUNT-NO AND                00150000
MFA-TR*            NAME_ID         =  :DQ-NAME-ID                       00150000
MFA-TR*      WITH UR                                                    00150110
MFA-TR*    END-EXEC.                                                    00150200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE                               TO                
P00740                                         WS-ACTIVE-RETURN-CODE.   
ACT120     IF WS-ACTIVE-RETURN-CODE EQUAL      NOT-FOUND                
ACT120         DISPLAY 'THIRD PARTY WAS NOT FOUND FOR ' AT-ACCOUNT-NO   
ACT120            ' ' DQ-NAME-ID                                        
P00740     ELSE                                                         
ACT120       IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL             
P00740         MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
P00740         MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
P00740         MOVE 'SELECT'                          TO ABEND-FUNCTION 
P00740         MOVE 'CSS_THIRD-PARTY   '              TO TABLE-1        
P00740         MOVE '4077'                            TO                
P00740                                         ACTIVE-PARAGRAPH         
P00740         MOVE AT-ACCOUNT-NO                     TO                
P00740                                         HOSTVAR-ELEMENT-1        
P00740         MOVE 'ACCOUNT-NO '                     TO                
P00740                                         TABLE-ELEMENT-1          
P00740         MOVE DQ-NAME-ID                        TO                
P00740                                         HOSTVAR-ELEMENT-2        
P00740         MOVE 'NAME-ID    '                     TO                
P00740                                         TABLE-ELEMENT-2          
P00740         PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
P00740       END-IF                                                     
P00740     END-IF.                                                      
P00740                                                                  
P00740 4077-EXIT.                                                       
P00740     EXIT.                                                        
      *                                                                 00152900
      *                                                                 00152900
       4080-SELECT-CUST-ADDR-XREF.                                      
ACT120     INITIALIZE DM-ADDRESS-ID DM-ADDRESS-FORMAT.                  
           EXEC SQL                                                     
             SELECT                                                     
               ADDRESS_ID,                                              
               ADDRESS_FORMAT                                           
             INTO :DM-ADDRESS-ID,                                       
                  :DM-ADDRESS-FORMAT                                    
             FROM CSS_CUST_ADDR_XREF WITH(READUNCOMMITTED)                      
P00704       WHERE CUSTOMER_NO =  :CU-CUSTOMER-NO                       
P00704       AND   ADDRESS_TYPE = 'M'                                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00149100
MFA-TR*      SELECT                                                     00149200
MFA-TR*        ADDRESS_ID,                                              00149400
MFA-TR*        ADDRESS_FORMAT                                           00149500
MFA-TR*      INTO :DM-ADDRESS-ID,                                       00149700
MFA-TR*           :DM-ADDRESS-FORMAT                                    00149800
MFA-TR*      FROM CSS_CUST_ADDR_XREF                                    00149900
MFA-TR*      WHERE CUSTOMER_NO =  :CU-CUSTOMER-NO                       00150000
MFA-TR*      AND   ADDRESS_TYPE = 'M'                                   00150100
MFA-TR*      WITH UR                                                    00150110
MFA-TR*    END-EXEC.                                                    00150200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
ACT120     IF WS-ACTIVE-RETURN-CODE EQUAL      NOT-FOUND                
ACT120         DISPLAY CU-CUSTOMER-NO ' WAS NOT FOUND ON '              
ACT120             'CSS_CUST_ADDR_XREF TABLE'                           
           ELSE                                                         
ACT120       IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL             
               MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
               MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
               MOVE 'SELECT'                          TO ABEND-FUNCTION 
               MOVE 'CSS_CUST_ADDR_XREF'              TO TABLE-1        
               MOVE '4080'                            TO                
                                               ACTIVE-PARAGRAPH         
P00704         MOVE CU-CUSTOMER-NO                    TO                
                                               HOSTVAR-ELEMENT-1        
               MOVE 'CUSTOMER_NO'                     TO                
                                               TABLE-ELEMENT-1          
               MOVE DM-ADDRESS-TYPE                   TO                
                                               HOSTVAR-ELEMENT-2        
               MOVE 'ADDRESS_TYPE'                    TO                
                                               TABLE-ELEMENT-2          
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
ACT120       END-IF                                                     
           END-IF.                                                      
                                                                        
       4080-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00152900
       4085-SELECT-ADDR-FORMATTED.                                      
           INITIALIZE                          DY-VALIDATION-TS.        
           EXEC SQL                                                     
             SELECT                                                     
               HOUSE_NO,                                                
               ADDR_PREFIX_1,                                           
               ADDR_PREFIX_2,                                           
               STREET_NAME,                                             
               STREET_LOCATION_1,                                       
               STREET_LOCATION_2,                                       
               STREET_SUFFIX,                                           
               ADDRESS_OVERFLOW,                                        
               ZIP_CODE,                                                
               ZIP_CODE_PLUS_FOUR,                                      
               ZIP_CODE_TOKEN,                                          
               USPS_DELIV_PT_CD,                                        
               REPLACE(REPLACE(CONVERT(CHAR(26), VALIDATION_TS, 121), 
           ' ', '-'), ':', '.') VALIDATION_TS,                                 
               ADDR_SUFFIX                                              
             INTO :DY-HOUSE-NO,                                         
                  :DY-ADDR-PREFIX-1,                                    
                  :DY-ADDR-PREFIX-2,                                    
                  :DY-STREET-NAME,                                      
                  :DY-STREET-LOCATION-1,                                
                  :DY-STREET-LOCATION-2,                                
                  :DY-STREET-SUFFIX,                                    
                  :DY-ADDRESS-OVERFLOW,                                 
                  :DY-ZIP-CODE,                                         
                  :DY-ZIP-CODE-PLUS-FOUR,                               
                  :DY-ZIP-CODE-TOKEN,                                   
                  :DY-USPS-DELIV-PT-CD,                                 
                  :DY-VALIDATION-TS :WS-NULL-IND1,                       
                  :DY-ADDR-SUFFIX                                       
             FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                      
             WHERE ADDRESS_ID = :DY-ADDRESS-ID                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     00153300
MFA-TR*      SELECT                                                     00153400
MFA-TR*        HOUSE_NO,                                                00153500
MFA-TR*        ADDR_PREFIX_1,                                           00153600
MFA-TR*        ADDR_PREFIX_2,                                           00153700
MFA-TR*        STREET_NAME,                                             00153800
MFA-TR*        STREET_LOCATION_1,                                       00153900
MFA-TR*        STREET_LOCATION_2,                                       00154000
MFA-TR*        STREET_SUFFIX,                                           00154100
MFA-TR*        ADDRESS_OVERFLOW,                                        00154200
MFA-TR*        ZIP_CODE,                                                00154300
MFA-TR*        ZIP_CODE_PLUS_FOUR,                                      00154400
MFA-TR*        ZIP_CODE_TOKEN,                                          00154500
MFA-TR*        USPS_DELIV_PT_CD,                                        00154600
MFA-TR*        VALIDATION_TS,                                           00154700
MFA-TR*        ADDR_SUFFIX                                              00154800
MFA-TR*      INTO :DY-HOUSE-NO,                                         00154900
MFA-TR*           :DY-ADDR-PREFIX-1,                                    00155000
MFA-TR*           :DY-ADDR-PREFIX-2,                                    00155100
MFA-TR*           :DY-STREET-NAME,                                      00155200
MFA-TR*           :DY-STREET-LOCATION-1,                                00155300
MFA-TR*           :DY-STREET-LOCATION-2,                                00155400
MFA-TR*           :DY-STREET-SUFFIX,                                    00155500
MFA-TR*           :DY-ADDRESS-OVERFLOW,                                 00155600
MFA-TR*           :DY-ZIP-CODE,                                         00155700
MFA-TR*           :DY-ZIP-CODE-PLUS-FOUR,                               00155800
MFA-TR*           :DY-ZIP-CODE-TOKEN,                                   00155900
MFA-TR*           :DY-USPS-DELIV-PT-CD,                                 00156000
MFA-TR*           :DY-VALIDATION-TS:WS-NULL-IND1,                       00156100
MFA-TR*           :DY-ADDR-SUFFIX                                       00156200
MFA-TR*      FROM CSS_ADDR_FORMATTED                                    00156300
MFA-TR*      WHERE ADDRESS_ID = :DY-ADDRESS-ID                          00156400
MFA-TR*      WITH UR                                                    00156410
MFA-TR*    END-EXEC.                                                    00156500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL OR       
                                               NOT-FOUND                
               IF WS-NULL-IND1 = -1                                     
                  MOVE SPACES                         TO                
                                               DY-VALIDATION-TS         
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
               MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
               MOVE 'SELECT'                          TO ABEND-FUNCTION 
               MOVE 'CSS_ADDR_FORMATTED'              TO TABLE-1        
               MOVE '4085'                            TO                
                                               ACTIVE-PARAGRAPH         
               MOVE DY-ADDRESS-ID                     TO                
                                               HOSTVAR-ELEMENT-1        
               MOVE 'ADDRESS_ID'                      TO                
                                               TABLE-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       4085-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00159100
       4090-SELECT-ADDR-FREEFORM.                                       
                                                                        
ACT120     INITIALIZE DZ-ADDR-STREET                                    
ACT120                DZ-ADDR-CITY-STATE                                
ACT120                DZ-ADDR-ZIP-CODE                                  
ACT120                DZ-ADDR-COUNTRY                                   
ACT120                DZ-USPS-DELIV-PT-CD                               
ACT120                DZ-VALIDATION-TS                                  
ACT120                DZ-ADDRESS-OVERFLOW                               
ACT120                WS-NULL-IND1                                      
ACT120                WS-MAIL-ADDR-TYPE.                                
           EXEC SQL                                                     
             SELECT                                                     
               ADDR_STREET,                                             
               ADDR_CITY_STATE,                                         
               ADDR_ZIP_CODE,                                           
               ADDR_COUNTRY,                                            
               USPS_DELIV_PT_CD,                                        
               REPLACE(REPLACE(CONVERT(CHAR(26), VALIDATION_TS, 121), 
           ' ', '-'), ':', '.') VALIDATION_TS,                                 
               ADDRESS_OVERFLOW                                         
             INTO :DZ-ADDR-STREET,                                      
                  :DZ-ADDR-CITY-STATE,                                  
                  :DZ-ADDR-ZIP-CODE,                                    
                  :DZ-ADDR-COUNTRY,                                     
                  :DZ-USPS-DELIV-PT-CD,                                 
                  :DZ-VALIDATION-TS :WS-NULL-IND1,                       
                  :DZ-ADDRESS-OVERFLOW                                  
             FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                       
             WHERE ADDRESS_ID = :DZ-ADDRESS-ID                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     00159700
MFA-TR*      SELECT                                                     00159800
MFA-TR*        ADDR_STREET,                                             00159900
MFA-TR*        ADDR_CITY_STATE,                                         00160000
MFA-TR*        ADDR_ZIP_CODE,                                           00160100
MFA-TR*        ADDR_COUNTRY,                                            00160200
MFA-TR*        USPS_DELIV_PT_CD,                                        00160300
MFA-TR*        VALIDATION_TS,                                           00160400
MFA-TR*        ADDRESS_OVERFLOW                                         00160500
MFA-TR*      INTO :DZ-ADDR-STREET,                                      00160600
MFA-TR*           :DZ-ADDR-CITY-STATE,                                  00160700
MFA-TR*           :DZ-ADDR-ZIP-CODE,                                    00160800
MFA-TR*           :DZ-ADDR-COUNTRY,                                     00160900
MFA-TR*           :DZ-USPS-DELIV-PT-CD,                                 00161000
MFA-TR*           :DZ-VALIDATION-TS:WS-NULL-IND1,                       00161100
MFA-TR*           :DZ-ADDRESS-OVERFLOW                                  00161200
MFA-TR*      FROM CSS_ADDR_FREEFORM                                     00161300
MFA-TR*      WHERE ADDRESS_ID = :DZ-ADDRESS-ID                          00161400
MFA-TR*      WITH UR                                                    00161410
MFA-TR*    END-EXEC.                                                    00161500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL          
               IF WS-NULL-IND1 = -1                                     
                  MOVE SPACES                         TO                
                                               DZ-VALIDATION-TS         
               END-IF                                                   
              PERFORM 2150-MOVE-FREEFORM-ADDR         THRU 2150-EXIT    
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
                NEXT SENTENCE                                           
             ELSE                                                       
               MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
               MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
               MOVE 'SELECT'                          TO ABEND-FUNCTION 
               MOVE 'CSS_ADDR_FORMATTED'              TO TABLE-1        
               MOVE '4090'                            TO                
                                               ACTIVE-PARAGRAPH         
               MOVE DZ-ADDRESS-ID                     TO                
                                               HOSTVAR-ELEMENT-1        
               MOVE 'ADDRESS_ID'                      TO                
                                               TABLE-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              MOVE 'U'                                TO                
                                               WS-MAIL-ADDR-TYPE        
           END-IF.                                                      
                                                                        
       4090-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00165000
       4095-SELECT-ZIP-CODE.                                            
                                                                        
           EXEC SQL                                                     
             SELECT                                                     
               TOWN,                                                    
               STATE                                                    
             INTO :A4-TOWN,                                             
                  :A4-STATE                                             
             FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                            
             WHERE ZIP_CODE = :A4-ZIP-CODE AND                          
                   ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00165300
MFA-TR*      SELECT                                                     00165400
MFA-TR*        TOWN,                                                    00165500
MFA-TR*        STATE                                                    00165600
MFA-TR*      INTO :A4-TOWN,                                             00165700
MFA-TR*           :A4-STATE                                             00165800
MFA-TR*      FROM CSS_ZIP_CODE                                          00165900
MFA-TR*      WHERE ZIP_CODE = :A4-ZIP-CODE AND                          00166000
MFA-TR*            ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                  00166100
MFA-TR*      WITH UR                                                    00166110
MFA-TR*    END-EXEC.                                                    00166200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL OR       
                                               NOT-FOUND                
                NEXT SENTENCE                                           
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
               MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
               MOVE 'SELECT'                          TO ABEND-FUNCTION 
               MOVE 'CSS_ZIP_CODE'                    TO TABLE-1        
               MOVE '4095'                            TO                
                                               ACTIVE-PARAGRAPH         
               MOVE A4-ZIP-CODE                       TO                
                                               HOSTVAR-ELEMENT-1        
               MOVE 'ZIP_CODE'                        TO                
                                               TABLE-ELEMENT-1          
               MOVE A4-ZIP-CODE-TOKEN                 TO                
                                               HOSTVAR-ELEMENT-2        
               MOVE 'ZIP_CODE_TOKEN'                  TO                
                                               TABLE-ELEMENT-2          
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       4095-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00168900
      **************************************************************    00169000
      *  REMOVE LEADING ZEROES FROM THE HOUSE NUMBER.              *    00169100
      **************************************************************    00169200
       5000-REMOVE-LEADING-ZEROS.                                       
                                                                        
           SET WS-HOUSE-IN-IDX                        TO 1.             
           SET WS-HOUSE-OUT-IDX                       TO 1.             
           MOVE SPACES                                TO WS-HOUSE-NO-1. 
                                                                        
           PERFORM UNTIL WS-HOUSE-NO-IN (WS-HOUSE-IN-IDX) > 0           
               SET WS-HOUSE-IN-IDX                    UP BY 1           
           END-PERFORM.                                                 
                                                                        
           PERFORM UNTIL WS-HOUSE-IN-IDX > 15                           
               MOVE WS-HOUSE-NO-IN (WS-HOUSE-IN-IDX)  TO                
                                   WS-HOUSE-NO-OUT (WS-HOUSE-OUT-IDX)   
               SET WS-HOUSE-IN-IDX                    UP BY 1           
               SET WS-HOUSE-OUT-IDX                   UP BY 1           
           END-PERFORM.                                                 
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00171200
      **************************************************************    00171300
      *  FETCH ALL THE NAMES FROM THE TABLE.                       *    00171400
      **************************************************************    00171500
       7100-OPEN-NAME-CURSOR.                                           
                                                                        
           INITIALIZE                          HT-CUSTOMER-ROLE-CD.     
      *                                                                 00171900
            EXEC SQL                                                    
                OPEN NAME_CURSOR                                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL          
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
               MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
               MOVE 'OPEN'                            TO ABEND-FUNCTION 
               MOVE 'CSS_NAME'                        TO TABLE-1        
               MOVE '7100'                            TO                
                                               ACTIVE-PARAGRAPH         
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00174000
       7150-FETCH-NAME.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH NAME_CURSOR INTO                                   
                       :HT-NAME-ID,                                    
                       :HT-COMPANY-NO,                                 
                       :HT-CUSTOMER-NO,                                
                       :HT-ACCOUNT-NO,                                 
                       :HT-ADDRESS-ID,                                 
                       :HT-PREMISE-NO,                                 
                       :HT-CONTACT-ID,                                 
                       :DQ-NAME-TYPE,                                  
                       :DQ-NAME-FORMAT,                                
                       :DQ-FIRST-NAME,                                 
                       :DQ-MIDDLE-NAME,                                
                       :DQ-LAST-NAME,                                  
                       :DQ-TITLE-PREFIX,                               
                       :DQ-TITLE-SUFFIX-1,                             
                       :DQ-TITLE-SUFFIX-2,                             
                       :DQ-FULL-NAME                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL OR       
                                               NOT-FOUND                
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
               MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
               MOVE 'FETCH'                           TO ABEND-FUNCTION 
               MOVE 'CSS_NAME_ACCT_XREF'              TO TABLE-1        
               MOVE 'CSS_NAME'                        TO TABLE-2        
               MOVE '7150'                            TO                
                                               ACTIVE-PARAGRAPH         
               MOVE HT-ACCOUNT-NO                     TO                
                                               HOSTVAR-ELEMENT-1        
               MOVE 'ACCOUNT_NO'                      TO                
                                               TABLE-ELEMENT-1          
               MOVE HT-CUSTOMER-ROLE-CD               TO                
                                               HOSTVAR-ELEMENT-2        
               MOVE 'CUSTOMER_ROLE_CD'                TO                
                                               TABLE-ELEMENT-2          
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
                                                                        
              EVALUATE DQ-NAME-TYPE                                     
                WHEN 'AA'                                               
                   SET WS-NAME-INDX                   TO 1              
                WHEN 'CN'                                               
                   SET WS-NAME-INDX                   TO 2              
                WHEN 'AN'                                               
                   SET WS-NAME-INDX                   TO 3              
                WHEN 'DB'                                               
                   SET WS-NAME-INDX                   TO 4              
                WHEN 'AI'                                               
                   SET WS-NAME-INDX                   TO 5              
              END-EVALUATE                                              
                                                                        
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-CLOSE-NAME.                                                 
                                                                        
            EXEC SQL                                                    
              CLOSE NAME_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL          
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
               MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
               MOVE 'CLOSE'                           TO ABEND-FUNCTION 
               MOVE 'CSS_NAME'                        TO TABLE-1        
               MOVE '7200'                            TO                
                                               ACTIVE-PARAGRAPH         
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00182800
      **************************************************************    00182900
      *  FETCH CUSTOMER ADDRESS FROM TABLE.                        *    00183000
      **************************************************************    00183100
       7250-GET-CUST-ADDR.                                              
                                                                        
           INITIALIZE                          WS-NULL-IND1.            
           MOVE 'M'                                   TO                
                                               DM-ADDRESS-TYPE.         
      *                                                                 00183700
            EXEC SQL                                                    
              SELECT A.ADDRESS_ID,                                      
                     B.ADDR_STREET,                                     
                     B.ADDR_CITY_STATE,                                 
                     B.ADDR_ZIP_CODE,                                   
                     B.ADDR_COUNTRY,                                    
                     B.ADDRESS_OVERFLOW,                                
                     B.USPS_DELIV_PT_CD,                                
                     REPLACE(REPLACE(CONVERT(CHAR(26), B.VALIDATION_TS
           , 121), ' ', '-'), ':', '.') VALIDATION_TS                          
                INTO :DM-ADDRESS-ID,                                    
                     :DZ-ADDR-STREET,                                   
                     :DZ-ADDR-CITY-STATE,                               
                     :DZ-ADDR-ZIP-CODE,                                 
                     :DZ-ADDR-COUNTRY,                                  
                     :DZ-ADDRESS-OVERFLOW,                              
                     :DZ-USPS-DELIV-PT-CD,                              
                     :DZ-VALIDATION-TS :WS-NULL-IND1                     
               FROM CSS_CUST_ADDR_XREF A WITH(READUNCOMMITTED),                 
                    CSS_ADDR_FREEFORM B WITH(READUNCOMMITTED)                   
               WHERE A.CUSTOMER_NO     = :CU-CUSTOMER-NO AND            
                     B.ADDRESS_ID      = A.ADDRESS_ID AND               
                     A.ADDRESS_TYPE    = :DM-ADDRESS-TYPE               
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                    00183800
MFA-TR*       SELECT A.ADDRESS_ID,                                      00183900
MFA-TR*              B.ADDR_STREET,                                     00184000
MFA-TR*              B.ADDR_CITY_STATE,                                 00184100
MFA-TR*              B.ADDR_ZIP_CODE,                                   00184200
MFA-TR*              B.ADDR_COUNTRY,                                    00184300
MFA-TR*              B.ADDRESS_OVERFLOW,                                00184400
MFA-TR*              B.USPS_DELIV_PT_CD,                                00184500
MFA-TR*              B.VALIDATION_TS                                    00184600
MFA-TR*         INTO :DM-ADDRESS-ID,                                    00184700
MFA-TR*              :DZ-ADDR-STREET,                                   00184800
MFA-TR*              :DZ-ADDR-CITY-STATE,                               00184900
MFA-TR*              :DZ-ADDR-ZIP-CODE,                                 00185000
MFA-TR*              :DZ-ADDR-COUNTRY,                                  00185100
MFA-TR*              :DZ-ADDRESS-OVERFLOW,                              00185200
MFA-TR*              :DZ-USPS-DELIV-PT-CD,                              00185300
MFA-TR*              :DZ-VALIDATION-TS:WS-NULL-IND1                     00185400
MFA-TR*        FROM CSS_CUST_ADDR_XREF A,                               00185500
MFA-TR*             CSS_ADDR_FREEFORM B                                 00185600
MFA-TR*        WHERE A.CUSTOMER_NO     = :CU-CUSTOMER-NO AND            00185700
MFA-TR*              B.ADDRESS_ID      = A.ADDRESS_ID AND               00185800
MFA-TR*              A.ADDRESS_TYPE    = :DM-ADDRESS-TYPE               00185900
MFA-TR*        WITH UR                                                  00185910
MFA-TR*     END-EXEC.                                                   00186000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL          
                                                                        
               IF WS-NULL-IND1 = -1                                     
                  MOVE SPACES                         TO                
                                               DZ-VALIDATION-TS         
               END-IF                                                   
              MOVE DM-ADDRESS-ID                      TO DZ-ADDRESS-ID  
              PERFORM 2150-MOVE-FREEFORM-ADDR         THRU 2150-EXIT    
                                                                        
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
                NEXT SENTENCE                                           
             ELSE                                                       
               MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
               MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
               MOVE 'SELECT'                          TO ABEND-FUNCTION 
               MOVE '7250'                            TO                
                                               ACTIVE-PARAGRAPH         
               MOVE 'CSS_CUST_ADDR_XREF'              TO TABLE-1        
               MOVE 'CSS_ADDR_FREEFORM'               TO TABLE-2        
               MOVE '7250'                            TO                
                                               ACTIVE-PARAGRAPH         
               MOVE CU-CUSTOMER-NO                    TO                
                                               HOSTVAR-ELEMENT-1        
               MOVE 'CUSTOMER_NO'                     TO                
                                               TABLE-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00189600
      **************************************************************    00189700
      *  FETCH CUSTOMER NAME FROM THE TABLE.                       *    00189800
      **************************************************************    00189900
       7300-GET-CUST-NAME.                                              
                                                                        
           INITIALIZE                                 HT-NAME-ID        
                                                      DQ-NAME-TYPE      
                                                      DQ-NAME-FORMAT    
                                                      DQ-FIRST-NAME     
                                                      DQ-MIDDLE-NAME    
                                                      DQ-LAST-NAME      
                                                      DQ-TITLE-PREFIX   
                                                      DQ-TITLE-SUFFIX-1 
                                                      DQ-TITLE-SUFFIX-2 
                                                      DQ-FULL-NAME.     
                                                                        
           MOVE 'CN'                                  TO DQ-NAME-TYPE.  
      *                                                                 00190300
            EXEC SQL                                                    
               SELECT TOP(1) A.NAME_ID,
              B.NAME_TYPE,
              B.NAME_FORMAT,
              B.FIRST_NAME,
              B.MIDDLE_NAME,
              B.LAST_NAME,
              B.TITLE_PREFIX,
              B.TITLE_SUFFIX_1,
              B.TITLE_SUFFIX_2,
              B.FULL_NAME                                       
                INTO  :HT-NAME-ID,                                      
                      :DQ-NAME-TYPE,                                    
                      :DQ-NAME-FORMAT,                                  
                      :DQ-FIRST-NAME,                                   
                      :DQ-MIDDLE-NAME,                                  
                      :DQ-LAST-NAME,                                    
                      :DQ-TITLE-PREFIX,                                 
                      :DQ-TITLE-SUFFIX-1,                               
                      :DQ-TITLE-SUFFIX-2,                               
                      :DQ-FULL-NAME                                     
               FROM CSS_NAME_ACCT_XREF A,                               
                    CSS_NAME B                                          
               WHERE CUSTOMER_NO       = :HT-CUSTOMER-NO AND            
                    A.NAME_ID          = B.NAME_ID AND                  
                    A.CUSTOMER_ROLE_CD = :HT-CUSTOMER-ROLE-CD AND       
                    B.NAME_TYPE        = :DQ-NAME-TYPE                  
                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*     EXEC SQL                                                    00190400
MFA-TR*        SELECT A.NAME_ID,                                        00190500
MFA-TR*               B.NAME_TYPE,                                      00190600
MFA-TR*               B.NAME_FORMAT,                                    00190700
MFA-TR*               B.FIRST_NAME,                                     00190800
MFA-TR*               B.MIDDLE_NAME,                                    00190900
MFA-TR*               B.LAST_NAME,                                      00191000
MFA-TR*               B.TITLE_PREFIX,                                   00191100
MFA-TR*               B.TITLE_SUFFIX_1,                                 00191200
MFA-TR*               B.TITLE_SUFFIX_2,                                 00191300
MFA-TR*               B.FULL_NAME                                       00191400
MFA-TR*         INTO  :HT-NAME-ID,                                      00191500
MFA-TR*               :DQ-NAME-TYPE,                                    00191600
MFA-TR*               :DQ-NAME-FORMAT,                                  00191700
MFA-TR*               :DQ-FIRST-NAME,                                   00191800
MFA-TR*               :DQ-MIDDLE-NAME,                                  00191900
MFA-TR*               :DQ-LAST-NAME,                                    00192000
MFA-TR*               :DQ-TITLE-PREFIX,                                 00192100
MFA-TR*               :DQ-TITLE-SUFFIX-1,                               00192200
MFA-TR*               :DQ-TITLE-SUFFIX-2,                               00192300
MFA-TR*               :DQ-FULL-NAME                                     00192400
MFA-TR*        FROM CSS_NAME_ACCT_XREF A,                               00192500
MFA-TR*             CSS_NAME B                                          00192600
MFA-TR*        WHERE CUSTOMER_NO       = :HT-CUSTOMER-NO AND            00192700
MFA-TR*             A.NAME_ID          = B.NAME_ID AND                  00192800
MFA-TR*             A.CUSTOMER_ROLE_CD = :HT-CUSTOMER-ROLE-CD AND       00192900
MFA-TR*             B.NAME_TYPE        = :DQ-NAME-TYPE                  00193000
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                  00193100
MFA-TR*     END-EXEC.                                                   00193200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
                NEXT SENTENCE                                           
             ELSE                                                       
               MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
               MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
               MOVE 'SELECT'                          TO ABEND-FUNCTION 
               MOVE '7300'                            TO                
                                               ACTIVE-PARAGRAPH         
               MOVE 'CSS_NAME_ACCT_XREF'              TO TABLE-1        
               MOVE 'CSS_NAME '                       TO TABLE-2        
               MOVE '7300'                            TO                
                                               ACTIVE-PARAGRAPH         
               MOVE CU-CUSTOMER-NO                    TO                
                                               HOSTVAR-ELEMENT-1        
               MOVE 'CUSTOMER_NO'                     TO                
                                               TABLE-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04127*                                                                 00189600
A04127**************************************************************    00189700
A04127*  FETCH INDIVIDUAL FIRST AND LAST NAME FROM TABLE.          *    00189800
A04127**************************************************************    00189900
A04127 7350-GET-INDIV-BUS-NAME.                                         
A04127                                                                  
A04127     INITIALIZE                                 DQ-NAME-ID        
A04127                                                DQ-NAME-TYPE      
A04127                                                DQ-NAME-FORMAT    
A04127                                                DQ-FIRST-NAME     
A04127                                                DQ-MIDDLE-NAME    
A04127                                                DQ-LAST-NAME      
A04127                                                DQ-TITLE-PREFIX   
A04127                                                DQ-TITLE-SUFFIX-1.
A04127                                                                  
A04127      EXEC SQL                                                    
A04127         SELECT TOP(1) B.NAME_ID,
              B.NAME_TYPE,
              B.NAME_FORMAT,
              B.FIRST_NAME,
              B.MIDDLE_NAME,
              B.LAST_NAME,
              B.TITLE_PREFIX,
              B.TITLE_SUFFIX_1                                  
A04127          INTO  :DQ-NAME-ID,                                      
A04127                :DQ-NAME-TYPE,                                    
A04127                :DQ-NAME-FORMAT,                                  
A04127                :DQ-FIRST-NAME,                                   
A04127                :DQ-MIDDLE-NAME,                                  
A04127                :DQ-LAST-NAME,                                    
A04127                :DQ-TITLE-PREFIX,                                 
A04127                :DQ-TITLE-SUFFIX-1                                
A04127         FROM CSS_CUST_STATS A,                                   
A04127              CSS_NAME B                                          
A04127         WHERE A.CUSTOMER_NO     = :CE-CUSTOMER-NO AND            
A04127              A.INDIV_NAME_ID    = B.NAME_ID AND                  
A04127              B.NAME_TYPE        = 'IB'                           
A04127                                           
A04127      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*     EXEC SQL                                                    00190400
MFA-TR*        SELECT B.NAME_ID,                                        00190500
MFA-TR*               B.NAME_TYPE,                                      00190600
MFA-TR*               B.NAME_FORMAT,                                    00190700
MFA-TR*               B.FIRST_NAME,                                     00190800
MFA-TR*               B.MIDDLE_NAME,                                    00190900
MFA-TR*               B.LAST_NAME,                                      00191000
MFA-TR*               B.TITLE_PREFIX,                                   00191100
MFA-TR*               B.TITLE_SUFFIX_1                                  00191200
MFA-TR*         INTO  :DQ-NAME-ID,                                      00191500
MFA-TR*               :DQ-NAME-TYPE,                                    00191600
MFA-TR*               :DQ-NAME-FORMAT,                                  00191700
MFA-TR*               :DQ-FIRST-NAME,                                   00191800
MFA-TR*               :DQ-MIDDLE-NAME,                                  00191900
MFA-TR*               :DQ-LAST-NAME,                                    00192000
MFA-TR*               :DQ-TITLE-PREFIX,                                 00192100
MFA-TR*               :DQ-TITLE-SUFFIX-1                                00192200
MFA-TR*        FROM CSS_CUST_STATS A,                                   00192500
MFA-TR*             CSS_NAME B                                          00192600
MFA-TR*        WHERE A.CUSTOMER_NO     = :CE-CUSTOMER-NO AND            00192700
MFA-TR*             A.INDIV_NAME_ID    = B.NAME_ID AND                  00192800
MFA-TR*             B.NAME_TYPE        = 'IB'                           00193000
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                  00193100
MFA-TR*     END-EXEC.                                                   00193200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04127                                                                  
A04127     MOVE SQLCODE                               TO                
A04127                                         WS-ACTIVE-RETURN-CODE.   
A04127                                                                  
A04127     IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
A04127        CONTINUE                                                  
A04127     ELSE                                                         
A04127       IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
A04127          CONTINUE                                                
A04127       ELSE                                                       
A04127         MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
A04127         MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
A04127         MOVE 'SELECT'                          TO ABEND-FUNCTION 
A04127         MOVE '7350'                            TO                
A04127                                         ACTIVE-PARAGRAPH         
A04127         MOVE 'CSS_CUST_STATS'                  TO TABLE-1        
A04127         MOVE 'CSS_NAME '                       TO TABLE-2        
A04127         MOVE CE-CUSTOMER-NO                    TO                
A04127                                         HOSTVAR-ELEMENT-1        
A04127         MOVE 'CUSTOMER_NO'                     TO                
A04127                                         TABLE-ELEMENT-1          
A04127         PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
A04127     END-IF
           END-IF.                                                      
A04127                                                                  
A04127 7350-EXIT.                                                       
A04127     EXIT.                                                        
                                                                        
      **************************************************************    00196110
      *  FETCH COAPPLICANT NAME FROM THE TABLE                     *    00196120
      **************************************************************    00196130
       7400-GET-COAPPLICANT-NAME.                                       
           MOVE SPACES                                TO WS-COAPPL-NAME 
                                                         DQ-NAME-FORMAT 
                                                         DQ-FIRST-NAME  
                                                         DQ-MIDDLE-NAME 
                                                         DQ-LAST-NAME   
                                                         DQ-FULL-NAME.  
      *                                                                 00196170
            EXEC SQL                                                    
               SELECT TOP(1) B.NAME_FORMAT,
              B.FIRST_NAME,
              B.MIDDLE_NAME,
              B.LAST_NAME,
              B.FULL_NAME                                       
                INTO  :DQ-NAME-FORMAT,                                  
                      :DQ-FIRST-NAME,                                   
                      :DQ-MIDDLE-NAME,                                  
                      :DQ-LAST-NAME,                                    
                      :DQ-FULL-NAME                                     
               FROM CSS_NAME_ACCT_XREF A,                               
                    CSS_NAME B                                          
               WHERE A.ACCOUNT_NO      = :HT-ACCOUNT-NO  AND            
                    A.NAME_ID          = B.NAME_ID       AND            
                    A.CUSTOMER_ROLE_CD = 'B'                            
                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*     EXEC SQL                                                    00196180
MFA-TR*        SELECT B.NAME_FORMAT,                                    00196192
MFA-TR*               B.FIRST_NAME,                                     00196193
MFA-TR*               B.MIDDLE_NAME,                                    00196194
MFA-TR*               B.LAST_NAME,                                      00196195
MFA-TR*               B.FULL_NAME                                       00196199
MFA-TR*         INTO  :DQ-NAME-FORMAT,                                  00196202
MFA-TR*               :DQ-FIRST-NAME,                                   00196203
MFA-TR*               :DQ-MIDDLE-NAME,                                  00196204
MFA-TR*               :DQ-LAST-NAME,                                    00196205
MFA-TR*               :DQ-FULL-NAME                                     00196209
MFA-TR*        FROM CSS_NAME_ACCT_XREF A,                               00196210
MFA-TR*             CSS_NAME B                                          00196211
MFA-TR*        WHERE A.ACCOUNT_NO      = :HT-ACCOUNT-NO  AND            00196212
MFA-TR*             A.NAME_ID          = B.NAME_ID       AND            00196213
MFA-TR*             A.CUSTOMER_ROLE_CD = 'B'                            00196214
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                  00196216
MFA-TR*     END-EXEC.                                                   00196217

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
                                                                        
              IF DQ-NAME-FORMAT = 'B'                                   
                 MOVE DQ-FULL-NAME                    TO WS-COAPPL-NAME 
              END-IF                                                    
                                                                        
              IF DQ-NAME-FORMAT = 'I'                                   
                 MOVE SPACES                          TO WS-EMB-INPUT   
                                                         WS-CMP-TABLE   
                 STRING                     DQ-FIRST-NAME               
                                            DQ-MIDDLE-NAME              
                                            DQ-LAST-NAME                
                                            DELIMITED BY SIZE INTO      
                                            WS-EMB-INPUT                
                 INSPECT WS-EMB-INPUT REPLACING ALL                     
                                            LOW-VALUES BY SPACES        
                 MOVE 50                              TO WS-EMB-LENG    
                 PERFORM 6010-REDUCE-EMBEDDED-SPACES     THRU 6010-EXIT 
                 MOVE WS-CMP-TABLE                    TO WS-COAPPL-NAME 
              END-IF                                                    
                                                                        
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
                NEXT SENTENCE                                           
             ELSE                                                       
               MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE 
               MOVE PROGRAM-NAME                      TO ABEND-PROGRAM  
               MOVE 'SELECT'                          TO ABEND-FUNCTION 
               MOVE '7300'                            TO                
                                               ACTIVE-PARAGRAPH         
               MOVE 'CSS_NAME_ACCT_XREF'              TO TABLE-1        
               MOVE 'CSS_NAME '                       TO TABLE-2        
               MOVE '7300'                            TO                
                                               ACTIVE-PARAGRAPH         
               MOVE CU-CUSTOMER-NO                    TO                
                                               HOSTVAR-ELEMENT-1        
               MOVE 'CUSTOMER_NO'                     TO                
                                               TABLE-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *  REDUCE EMBEDDED BLANKS                                         00196270
       COPY CPD00004.                                                   00196300
                                                                        
      *  9700-PROCESS-ABEND.                                            00196500
       COPY CPD0023B.                                                   00196600
      *                                                                 00196700
      ******************************************************************00196800
      * RETURNS TO CALLING PROGRAM UNDER ABNORMAL CONDITIONS WITH A    *00196900
      * APPROPRIATE MESG AND RETURN-CODE 9                             *00197000
      ******************************************************************00197100
                                                                        
       9900-ABEND.                                                      
           MOVE TABLE-1                              TO WS-DB2-TABLE-ID.
           MOVE ABEND-FUNCTION                       TO WS-DB2-FUNCTION.
           MOVE RS-RETURN-CODE                       TO                 
                                                 WS-DB2-RETURN-CODE.    
T37389     MOVE '184'                                TO                 
                                                 WS-DB2-MODULE-ID.      
           MOVE ACTIVE-PARAGRAPH                     TO                 
                                                 WS-DB2-PARAGRAPH.      
           MOVE HOSTVAR-ELEMENT-1                    TO WS-DB2-KEY-1.   
           MOVE HOSTVAR-ELEMENT-2                    TO WS-DB2-KEY-2.   
           MOVE 12                                   TO RETURN-CODE.    
T37389     IF LS-CURR-WQ-ITEM = 50                                      
T37389        DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
T37389        DISPLAY 'PROCESSING TERMINATED'                           
T37389        MOVE 16                                TO RETURN-CODE     
T37389     ELSE                                                         
T37389        ADD 1                                  TO LS-CURR-WQ-ITEM 
T37389        SET WS-BILL-WQ-INDX                    TO LS-CURR-WQ-ITEM 
T37389        MOVE WS-SQL-ERROR-TXT-WQ               TO                 
                   WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
ACT071        MOVE WS-PGRMNAME                       TO                 
ACT071             WS-CREATED-BY-WF (WS-BILL-WQ-INDX)                   
           END-IF.                                                      
           PERFORM 9999-BAIL-OUT                     THRU 9999-EXIT.    
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9910-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16                                TO RETURN-CODE     
T37389        PERFORM 9999-BAIL-OUT                  THRU 9999-EXIT     
           ELSE                                                         
              ADD 1                                  TO LS-CURR-WQ-ITEM 
              SET WS-BILL-WQ-INDX                    TO LS-CURR-WQ-ITEM 
              MOVE WS-MISCELLANEOUS-MESSAGE          TO                 
                   WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
ACT071        MOVE WS-PGRMNAME                       TO                 
ACT071             WS-CREATED-BY-WF (WS-BILL-WQ-INDX)                   
           END-IF.                                                      
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-BAIL-OUT.                                                   
                                                                        
           MOVE RETURN-CODE                          TO                 
                                               WS-SCSCA-RETURN-CODE.    
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
