       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA183.                                        
      ***************************************************************** 00030000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00040000
      **                     PRICE WATERHOUSE                        ** 00050000
      **                                                             ** 00060000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00070000
      **                                                             ** 00080000
      ***************************************************************** 00090000
      **               P R O G R A M  S U M M A R Y                  ** 00100000
      **                                                             ** 00110000
      ** SCSCA183 FORMATS LARGE INDUSTRIAL GAS RATES AND CHARGES FOR ** 00120000
      ** BILL PRINT.  THIS PROGRAM IS CALLED FROM PCSCA166 WHEN THE  ** 00130000
      ** BILL FORMAT CODE IS '10'.                                   ** 00140000
      ** THIS IS A REWRITE OF SCSCA172.                              ** 00150000
      **                                                             ** 00160000
      ***************************************************************** 00170000
      *                                                              ** 00180000
      *              PROGRAM  MODIFICATION  LOG                      ** 00190000
      *                                                              ** 00200000
      *    DATE     INITIALS  REASON                                 ** 00210000
      *    ----     --------  ------                                 ** 00220000
      *    10/02    SV        REWRITE SCSCA172 TO SCSCA183.          ** 00230000
T28734*    04/03    SV82012   Pull Adjustment Reasons for Non-Calcs  ** 00240000
T28734*                       from DB2 Table.                        ** 00250000
T28985*    05/03    EM19682   Added code to display to right billing ** 00251000
T28985*                       period date and correct cross foot err.** 00252000
T29598*    10/03    EM19682   CML 29598   Franchise Fee verbiage     ** 00253000
T29854*    10/03    SV        CML 29854   Historical Usage Doubling  ** 00253100
T29854*                               when None Calc Adjustments Done** 00253200
T30013*    11/03    ESM       CML 30013   Added code to not display  ** 00253300
T30013*                                   the franchise fee line item** 00253400
T30013*                                   for none-calcs.            ** 00253500
T30583*    03/04    SV        Print Franchise Fee and Sales tax % on ** 00253600
T30583*                       Rebills.                               ** 00253700
T29450*    01/05    SV        Block Level Details needed for Penalty ** 00253803
T29450*                       Charges.                               ** 00253903
T35364*    02/07    Gokul     Change Linkage section to match with   ** 00253904
T35364*                       Tables passed from PCSCA166.           ** 00253905
T36419*    10/07    MVC       CML 36419   PREVENT CANCEL/REBILL      **         
T36419*                                   ACCOUNTS WITH ADJUSTMENT   **         
T36419*                                   FOR SALES TAXES TO BE      **         
T36419*                                   PLACED IN CCX PULL GROUP.  **         
T35152*    08/08    RV        To Populate Billing Period in Numerals ** 00253904
I00177*    01/09    RV        REMOVE INDEX HARDCODING FOR BC, UM, UC,**         
I00177*                       CT, EA, CL, DA, DV, AC, BZ, CP TABLES. **         
A00789*    02/09    SV        Commodity Charge should display WNA    **         
A00789*                       factor when it is present.             **         
A01336*    06/09    SV        Spell out the word Transportation      **         
A01336*                       instead of abbreviation Trnsp.         **         
PRJ251*    04/10    RAJ       NET METERING.                          ** 00253904
A02624*    07/10    SV        Correct Presentation on CIG Bills      **         
A02003*    09/10    DMS       REMOVED XFOOT WQ GENERATION.           **         
A03303**   09/11    SV95326   FIXED FACTOR PRECISION CHANGES.        **         
P00496*    05/11    RAJ       PROJ 496    Enhancements to Industrial **         
P00496*                                   Billing.                   **         
A03876*    02/12    SV        RATE D31/D33 ENDING PARENTHESIS MISSING**         
A03959*    03/12    RAJ       PROJ 496 WARRANTY WORK                 **         
A03959*                       (ADDITIONAL REQUIREMENTS).             **         
P00680*    06/12    RAJ       SCANA ENERGY RETENTION & ACQUISTION.   **         
A04860**   02/15    AS7C117   REPLACE CSS_WQ_ITEMS_MF WITH            *         
A04860**            ACT067    CSS_WQ_ITEMS.                           *         
ACT071**   16/03/15 SS7F226   ADD CREATED-BY FIELD LOGIC IN WF AREA.  *         
ACT071**             A04860                                           *         
ACT018**   06/02/16 SV95326   ADD NEW LITERALS FOR DEMAND GAS RATES.  *         
ACT018**            A05462                                            *         
ACT18A**   07/11/17 DMS       REMOVE CODE FOR ACT018                  *         
ACT018**   12/07/16 SV95326   ADD NEW LITERALS FOR DEMAND GAS RATES   *         
ACT018**            A05462    35A AND 35B.                            *         
      ***end*********************************************************** 00254000
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA183'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-MISC.                                                     
           05  WS-CHECK-MM                  PIC XX.                     
           05  WS-START-DATE                PIC X(10).                  
           05  WS-END-DATE                  PIC X(10).                  
           05  WS-CALC-NO-DAYS              PIC S9(9) COMP.             
           05  WS-HOLD-NO-OF-DAYS           PIC S9(9) COMP.             
           05  WS-WNA-SIGN                  PIC X.                      
COB305     05 WS-HOLD-AMT-BILL-ITEM        PIC S9(9)V99 COMP-3 VALUE 0.        
           05  WS-HOLD-FACTOR               PIC S9(9)V99999.            
           05  WS-DISP-FACTOR               PIC -Z(8)9.99999.           
           05  WS-HOLD-METER-NO             PIC X(9) VALUE SPACES.      
A02624     05  WS-HOLD-MSG                  PIC X(80).                  
           05  WS-DT                        PIC X(02) VALUE 'DT'.       
COB305     05 WS-FACTOR-COMP        PIC S9(9)V9(2) COMP-3 VALUE 0.      
           05  WS-SEASONAL-PRORATE          PIC X    VALUE 'N'.         
           05  WS-VERSION-PRORATE           PIC X    VALUE 'N'.         
           05  WS-BC-TABLE-LOADED           PIC X    VALUE 'N'.         
           05  WS-GAS-METER-CHANGE          PIC X    VALUE 'N'.         
COB305     05 WS-NO-THERMS        PIC S9(9) COMP-3 VALUE 0.           
COB305     05 WS-WNA-TOTAL-AMT        PIC S9(9)V9(2) COMP-3 VALUE 0.      
           05  WS-MATCH-FOUND               PIC X VALUE 'N'.            
               88  MATCH-FOUND                    VALUE 'Y'.            
           05  SUB2                         PIC 9(3) VALUE 0.           
           05  SUB3                         PIC 9(3) VALUE 0.           
           05  SUB4                         PIC 9(3) VALUE 0.           
T28734     05  WS-HOLD-NONECALC-LITERAL     PIC X(100).                 
T28734     05  WS-NC-SUB                    PIC S9(4) COMP.             
           05  WS-BLOCK-SUB                 PIC 9(3) VALUE 0.           
           05  WS-CHECK-CX-SUB              PIC 9(3) VALUE 0.           
           05  WS-HOLD-BG-SUB               PIC 9(3) VALUE 0.           
           05  WS-HOLD-BASIC-FACILITY       PIC S9(9)V99 VALUE 0.       
           05  WS-ROUNDED-BFC               PIC S9(9)V99 VALUE 0.       
T29450     05  WS-BLOCK-USE-OR-SVCS         PIC S9(9)V   VALUE 0.       
T29450     05  WS-HOLD-BLOCK-USE-OR-SVCS    PIC S9(9)V   VALUE 0.       
           05  WS-SUM-BC-TABLE.                                         
               07  WS-BC-TABLE    OCCURS 10.                            
COB305             10 WS-BC-UNITS        PIC S9(9) COMP-3 VALUE 0.           
COB305             10 WS-BC-READ-UNITS        PIC S9(9) COMP-3 VALUE 0.         
                   10  WS-BC-CONSUMPTION-TYPE                           
                                            PIC X.                      
COB305             10 WS-BC-DOLLAR-AMT        PIC S9(9)V99 COMP-3 
COB305               VALUE 0.        
COB305             10 WS-BC-RATE        PIC S9(5)V9(12) COMP-3 VALUE 0.     
                   10  WS-BC-COMPONENT-ID   PIC X(2).                   
                   10  WS-BC-CODE-REVENUE-CLASS                         
                                            PIC X(3).                   
           05  WS-CHARGES-MESSAGE-FIELDS.                               
NOV07          10  WS-FORMAT-MESSAGE        PIC X(100).                 
               10  WS-FORMAT-GAS-MESSAGE.                               
A02624             15  WS-FORMAT-LITERAL    PIC X(09).                  
                   15  WS-FORMAT-UNITS      PIC -Z(8)9.                 
A02624             15  F                    PIC X(03)                   
A02624                                      VALUE ' DT'.                
A03876         10  WS-FORMAT-RATES          PIC X(34).                  
               10  WS-DISPLAY-UNITS         PIC -Z(8)9.                 
               10  WS-DISPLAY-SQLCODE       PIC -ZZZZZZZZ9.             
               10  WS-HOLD-DESC             PIC X(255).                 
               10  WS-HOLD-COMP-EMER-DESC   PIC X(40).                  
               10  WS-DISPLAY-UNITS-2       PIC -Z(8)9.                 
P00496         10  WS-DISPLAY-RATE          PIC -Z(4)9.999999.          
P00496         10  WS-DISPLAY-RATE-DISP     PIC S9(5)V999999.           
               10  WS-CNSMPTN-TYPE          PIC X(10).                  
               10  WS-DISPLAY-FACTOR        PIC -ZZ.9(5).               
               10  WS-DISPLAY-WNA           PIC ZZ.9(5).                
               10  WS-DISPLAY-WNA-TOTAL-AMT PIC -Z,ZZZ.99.              
               10  WS-DISPLAY-PCT           PIC -ZZ.99.                 
               10  WS-COMPUTE-PCT           PIC S9(3)V99.               
           05  WS-UNFORMAT-DATE             PIC X(10).                  
           05  WS-FORMAT-DATE.                                          
               10  WS-FORMAT-MM             PIC XX.                     
               10  F                        PIC X VALUE '/'.            
               10  WS-FORMAT-DD             PIC XX.                     
               10  F                        PIC X VALUE '/'.            
               10  WS-FORMAT-YY             PIC XX.                     
           05  WS-ENGLISH-DATE.                                         
               10  WS-ENGLISH-MM            PIC XXX.                    
               10  F                        PIC X VALUE ' '.            
               10  WS-ENGLISH-DD            PIC XX.                     
T29450     05  WS-PENALTY-BLK-MESSAGE.                                  
T29450         10  F                        PIC X(21) VALUE             
T29450             'Unauthorized overrun '.                             
T29450         10  WS-PENALTY-BLK-MSG2      PIC X(20) VALUE SPACES.     
           05  WS-START-POS                 PIC S9(4) COMP.             
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  FILLER                   PIC S9(4) COMP VALUE +121.  
               10  FILLER                   PIC X(1)  VALUE 'N'.        
               10  FILLER                   PIC X(1)  VALUE '4'.        
               10  WS-MISC-MSG-LEN          PIC S9(4) COMP VALUE +250.  
               10  WS-MISC-MSG-TEXT         PIC X(250).                 
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER                   PIC S9(4) COMP VALUE +121.  
               10  FILLER                   PIC X(1)  VALUE 'N'.        
               10  FILLER                   PIC X(1)  VALUE '4'.        
               10  FILLER                   PIC S9(4) COMP VALUE +29.   
               10  FILLER                   PIC X(30) VALUE             
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-LAST-GAS-BG               PIC X VALUE ' '.            
T29598     05  RS-RETURN-CODE               PIC S9(4) COMP.             
T29598     05  WS-CURRENT-DATE              PIC X(10) VALUE SPACES.     
T29598     05  WS-RUN-DATE                  PIC X(10) VALUE SPACES.     
A03303     05  WS-FH-FACTOR                 PIC S9(09)V9(06)            
A03303                                       USAGE COMP-3 VALUE 0.      
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                  PIC  X(08) VALUE 'SCSCA183'.
T29598     05  PROGRAM-NAME                 PIC  X(08) VALUE 'SCSCA183'.
A04860     05  SCSCB077                PIC  X(08) VALUE 'SCSCB077'.     
                                                                        
P00680*  Working storage fields for CPD00095                                    
P00680 COPY CWSD0095.                                                           
      *  SUPPLEMENTAL WORK QUEUE FIELDS                                 01570000
       COPY CWS0070B.                                                   01580000
      *  FIELDS FOR DB2/SQL ERROR CHECKING                              01590000
       COPY CWS00303.                                                   01600000
      *  ABEND FIELDS                                                   01610000
       COPY CWS00010.                                                   01620000
      *  FIELDS USED TO REDUCE EMBEDDED BLANKS                          01630000
A02624 COPY CWS0011A.                                                   01640000
T29598*  FIELDS USED TO REMOVE PARENS                                   01650000
T29598 COPY CWS00500.                                                   01660000
      *  ABEND SWITCH                                                   01670000
       COPY CWS09900.                                                   01680000
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
A04860*                                                                         
           EXEC SQL                                                     01690000
               INCLUDE SQLCA                                            01700000
           END-EXEC.                                                    01710000
           EXEC SQL                                                     01720000
               INCLUDE TBMODEL                                          01730000
           END-EXEC.                                                    01740000
           EXEC SQL                                                     01750000
               INCLUDE TBSPLFTR                                         01760000
           END-EXEC.                                                    01770000
           EXEC SQL                                                     01780000
               INCLUDE TBFXHST                                          01790000
           END-EXEC.                                                    01800000
           EXEC SQL                                                     01810000
               INCLUDE TBSVCCAT                                         01820000
           END-EXEC.                                                    01830000
T29598*********************************************************         01831000
T29598*          INCLUDE THE DCLGEN FOR CSS_REV_DISTRICT      *         01832000
T29598*********************************************************         01833000
T29598     EXEC SQL                                                     01834000
T29598          INCLUDE TBRVDST                                         01835000
T29598     END-EXEC.                                                    01836000
T29450*********************************************************         01839404
T29450*          INCLUDE THE DCLGEN FOR CSS_PRICE_SCHED       *         01839504
T29450*********************************************************         01839604
T29450     EXEC SQL                                                     01839704
T29450          INCLUDE TBPRCSCH                                        01839804
T29450     END-EXEC.                                                    01839904
                                                                        
           EXEC SQL                                                     
               DECLARE COMP_EMER CURSOR FOR                             
                   SELECT FACTOR,                                       
                          BILL_UNITS                                    
                     FROM CSS_FIXED_FCT_HIST                            
                    WHERE ACCOUNT_NO         =:FH-ACCOUNT-NO            
                      AND BILL_NO            =:FH-BILL-NO               
                      AND CODE_UTIL_TYPE     =:FH-CODE-UTIL-TYPE        
                      AND IC_NO              =:FH-IC-NO                 
                      AND BILL_ITEM_TIMESTMP =CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )    
                      AND FACTOR_ID          =:FH-FACTOR-ID             
                      AND ENERGY_UNIT_CD     ='D'                       
                   ORDER BY FIXED_FCTR_SEQ_NO ASC, EFF_DATE_FROM ASC    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     01840104
MFA-TR*        DECLARE COMP_EMER CURSOR FOR                             01840204
MFA-TR*            SELECT FACTOR,                                       01840304
MFA-TR*                   BILL_UNITS                                    01840404
MFA-TR*              FROM CSS_FIXED_FCT_HIST                            01840504
MFA-TR*             WHERE ACCOUNT_NO         =:FH-ACCOUNT-NO            01841004
MFA-TR*               AND BILL_NO            =:FH-BILL-NO               01850000
MFA-TR*               AND CODE_UTIL_TYPE     =:FH-CODE-UTIL-TYPE        01860000
MFA-TR*               AND IC_NO              =:FH-IC-NO                 01870000
MFA-TR*               AND BILL_ITEM_TIMESTMP =:FH-BILL-ITEM-TIMESTMP    01880000
MFA-TR*               AND FACTOR_ID          =:FH-FACTOR-ID             01890000
MFA-TR*               AND ENERGY_UNIT_CD     ='D'                       01900000
MFA-TR*            ORDER BY FIXED_FCTR_SEQ_NO ASC, EFF_DATE_FROM ASC    01910000
MFA-TR*    END-EXEC.                                                    01920000
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
      *  BILLING EXTRACT FILE                                           01960000
      *  SPLIT CWS10000 INTO 2 COPYBOOKS                                01970000
       COPY CWS1000A.                                                   01980000
       COPY CWS1000B.                                                   01990000
      *  BILLING EXTRACT FILE                                           02000000
      *  SPLIT CWS10001 INTO 2 COPYBOOKS                                02010000
       COPY CWS1001A.                                                   02020000
       COPY CWS1001B.                                                   02030000
      *  BILLING EXTRACT FILE                                           02040000
       COPY CWS10009.                                                   02050000
       01  SUB1                             PIC 9(3).                   
       01  WS-CIG-CAN-REBILL                PIC X(1).                   
       01  WS-CIG-CAN-DOB                   PIC X(10).                  
       01  WS-SCSCA-RETURN-CODE             PIC S9(4) comp.             
       01  WS-FUEL-ADJ-SW                   PIC X      VALUE 'N'.       
COB305 01 WS-HOLD-FUEL-ADJ-FACTOR        PIC S9(3)V9(12) comp-3 VALUE 0.     
      *  INDUSTRIAL GAS FIELDS                                          02120000
A02624 COPY CWS00183.                                                   02130000
T35364 COPY CWS00184.                                                   02130100
      *  WORK QUEUE FIELDS                                              02140000
       COPY CWS0024B.                                                   02150000
T28734*  NONECALC FIELDS                                                02160000
T28734 COPY CWS00097.                                                   02170000
P00496*  CSS_RATE_COMPONENT DUMPED TABLE                                        
P00496 COPY CWSCA925.                                                           
                                                                        
       PROCEDURE DIVISION USING WS-ACCOUNT-AT                           
                                WS-MISC-BILL-INFO                       
                                WS-PREV-BILL-INFO                       
T29598                          WS-PREMISE-PR                           
                                WS-BILLING-BG                           
                                WS-CNSMPTN-HIST-CX                      
                                WS-BILL-ADJUST-DETAIL                   
                                WS-BILL-CALC-DETAIL                     
                                WS-MTRD-ENVRNMT-TABLE-MN                
                                WS-FIXED-FCTR-HIST-FH                   
                                SUB1                                    
T28734                          WS-NONCALC-LITERALS                     
                                WS-CIG-CAN-REBILL                       
                                WS-CIG-CAN-DOB                          
                                WS-SCSCA-RETURN-CODE                    
                                LS-PCSCA100-COMM-AREA                   
                                WS-BILLING-WQ-ITEMS-WF                  
                                WS-BILLING-BI                           
                                WS-IGAS-BILL-PRINT                      
T35364                          WS-IGAS-CORR-BILL                       
                                WS-FUEL-ADJ-SW                          
T30187                          WS-BILL-ADJUSTMNT                       
I00177                          WS-HOLD-FUEL-ADJ-FACTOR                 
I00177                          WS-CWS1000B-MAX-TBL-LIMITS              
P00496                          WS-RATE-COMPONENT.                      

SCA006        SET SPCL-FACTOR-IND TO 1.
                                                                        
      ************************************************************      02410000
      *  PROGRAM IS CALLED FROM PCSCA166.  GAS RATE DATA IS      *      02420000
      *  IS FORMATTED FOR CSF.                                   *      02430000
      ************************************************************      02440000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           DISPLAY 'SCSCA183 - LARGE INDUSTRIAL GAS'.                   
           MOVE SPACES                       TO WS-HOLD-METER-NO.       
           INITIALIZE  WS-SUM-BC-TABLE                                  
                       WS-GAS-METER-CHANGE                              
                       WS-HOLD-NO-OF-DAYS                               
                       WS-DISPLAY-RATE                                  
                       WS-DISPLAY-RATE-DISP                             
                       WS-HOLD-COMP-EMER-DESC                           
                       WS-HOLD-FACTOR                                   
                       WS-FACTOR-COMP                                   
                       WS-FORMAT-UNITS                                  
T29450                 WS-BLOCK-USE-OR-SVCS                             
T29450                 WS-HOLD-BLOCK-USE-OR-SVCS                        
                       WS-HOLD-BASIC-FACILITY.                          
           MOVE 'N'                           TO WS-VERSION-PRORATE.    
           MOVE 'Y'                           TO WS-INDUS-GAS-CUSTOMER. 
P00496     MOVE 1                             TO WS-IGAS-CX-SUB         
P00496                                           WS-IGAS-SUB.           
P00496     PERFORM 1100-BUILD-GAS-TABLE              THRU 1100-EXIT.    
P00496     IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                         
P00496        PERFORM 1050-FORMAT-NONE-CALC-GAS-IC      THRU 1050-EXIT  
P00496     ELSE                                                         
P00496        PERFORM 1000-FORMAT-GAS-IC                THRU 1000-EXIT  
P00496     END-IF.                                                      
           PERFORM 9999-BAIL-OUT                     THRU 9999-EXIT.    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      02680000
      *  THIS ROUTINE FORMATS THE RATE IC DATA.  WITHIN EACH RATE*      02690000
      *  IC HEADER WILL BE RATE METER RECORDS AND RATE CHARGES   *      02700000
      *  RECORDS.  TOTALS ARE COMPARED;  IF THEY DO NOT MATCH, A *      02710000
      *  CROSSFOOT ERROR IS GENERATED.  HISTORICAL DATA IS       *      02720000
      *  OBTAINED.                                               *      02730000
      ************************************************************      02740000
                                                                        
       1000-FORMAT-GAS-IC.                                              
                                                                        
           IF (WS-PRORATE-CD-BG (SUB1) > ' ' AND                        
              (WS-NO-OF-CONS-DAYS-BG (SUB1) < 27 OR                     
               WS-NO-OF-CONS-DAYS-BG (SUB1) > 34))                      
ACT037*        SET WS-PRORATED-YES                   TO   TRUE                  
               PERFORM 1510-GAS-CHGS-PRORATE         THRU 1510-EXIT     
           ELSE                                                         
               PERFORM 1300-GAS-CHARGES              THRU 1300-EXIT     
           END-IF.                                                      
                                                                        
           IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                         
               PERFORM 3700-NONE-CALC                THRU 3700-EXIT     
               MOVE 1                         TO WS-IGAS-CHG-SUB        
               PERFORM 1310-DETERMINE-CHG-SUB        THRU 1310-EXIT     
               MOVE WS-HOLD-NONECALC-LITERAL  TO                        
                         WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB)  
               IF WS-CODE-DR-CR-CNSMPTN-BG (SUB1) = 'C'                 
                  COMPUTE WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB) 
                                     = WS-AMT-BILL-ITEM-BG (SUB1) * -1  
               ELSE                                                     
                   MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO                   
                        WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB)   
               END-IF                                                   
               ADD WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB) TO     
                                      WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)  
           END-IF.                                                      
                                                                        
P00496     MOVE SPACES TO WS-PREV-FACTOR.                               
           PERFORM 3600-GET-FACTORS                  THRU 3600-EXIT.    
           MOVE 1                             TO WS-IGAS-CHG-SUB.       
           PERFORM 1310-DETERMINE-CHG-SUB            THRU 1310-EXIT.    
           MOVE 1                             TO WS-HOLD-FACTOR-SUB.    
P00496     PERFORM UNTIL WS-HOLD-FACTOR-SUB > 50 OR                     
P00496          WS-HOLD-FACTOR-FLAG(WS-HOLD-FACTOR-SUB) = SPACES        
                   MOVE WS-HOLD-FACTOR-DESC (WS-HOLD-FACTOR-SUB) TO     
                        WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB)   
                   MOVE WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO      
                        WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB)   
                   ADD WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO       
                                       WS-IGAS-TOTAL-CALC (WS-IGAS-SUB) 
                   ADD 1                      TO WS-IGAS-CHG-SUB        
                                                 WS-HOLD-FACTOR-SUB     
           END-PERFORM.                                                 
                                                                        
           IF WS-REPLACE-FACTOR-ID > SPACES                             
               PERFORM VARYING WS-IGAS-CHG-SUB FROM 1 BY 1 UNTIL        
                       WS-IGAS-CHG-SUB > 200 OR                         
                       WS-IGAS-CHG-MSG                                  
                          (WS-IGAS-SUB WS-IGAS-CHG-SUB) <= SPACES       
                  SUBTRACT WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB)
                      FROM WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)             
                  MOVE SPACES                  TO                       
                       WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB)    
                  MOVE ZERO                    TO                       
                         WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB)  
               END-PERFORM                                              
               MOVE WS-REPLACE-FACTOR-AMT       TO                      
                                      WS-IGAS-CHG-AMT (WS-IGAS-SUB 1)   
               ADD WS-REPLACE-FACTOR-AMT        TO                      
                                      WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)  
               EVALUATE WS-REPLACE-FACTOR-ID                            
                   WHEN 'SPMNTMIN'                                      
                       MOVE 'Monthly Minimum Contract' TO               
                                      WS-IGAS-CHG-MSG (WS-IGAS-SUB 1)   
A02003         END-EVALUATE                                             
A02003     END-IF.                                                      
                                                                        
           IF WS-IGAS-TOTAL (WS-IGAS-SUB) NOT =                         
              WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)                          
                  MOVE 'C'                    TO WS-BILL-DEST-CODE      
                  MOVE 'X'                    TO WS-SYSTEM-CNTRL-CODE   
A02003     END-IF.                                                      
                                                                        
T29854     IF WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S'                     
             MOVE 1 TO SUB2                                             
             PERFORM UNTIL SUB2 > 10 OR WS-PREVIOUS-RATE (SUB2) = SPACES
               IF WS-PREVIOUS-RATE (SUB2) =                             
                  WS-IGAS-PLAN (WS-IGAS-SUB) AND                        
                  WS-PREVIOUS-IC-NO (SUB2) =                            
                  WS-IGAS-IC-NO (WS-IGAS-SUB)                           
                  ADD WS-PREVIOUS-USAGE (SUB2)  TO                      
                                        WS-IGAS-PREV-USE (WS-IGAS-SUB)  
                  ADD WS-PREVIOUS-AMOUNT (SUB2) TO                      
                                       WS-IGAS-PREV-COST (WS-IGAS-SUB)  
                  MOVE WS-PREVIOUS-DAYS (SUB2)  TO                      
                                       WS-IGAS-PREV-DAYS (WS-IGAS-SUB)  
                  MOVE WS-PREVIOUS-TEMP (SUB2)  TO                      
                                       WS-IGAS-PREV-TEMP (WS-IGAS-SUB)  
                  MOVE WS-CURRENT-TEMP (SUB2)   TO                      
                                       WS-IGAS-CURR-TEMP (WS-IGAS-SUB)  
               END-IF                                                   
               ADD 1 TO SUB2                                            
             END-PERFORM                                                
T29854     END-IF.                                                      
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00496************************************************************      02680000
P00496*  THIS ROUTINE FORMATS THE RATE IC DATA FOR NONE-CALC.    *      02690000
P00496************************************************************      02740000
P00496                                                                  
P00496 1050-FORMAT-NONE-CALC-GAS-IC.                                    
                                                                        
           PERFORM 3700-NONE-CALC                THRU 3700-EXIT.        
           MOVE 1                         TO WS-IGAS-CHG-SUB.           
           PERFORM 1310-DETERMINE-CHG-SUB        THRU 1310-EXIT.        
           MOVE WS-HOLD-NONECALC-LITERAL  TO                            
                     WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB).     
           IF WS-CODE-DR-CR-CNSMPTN-BG (SUB1) = 'C'                     
              COMPUTE WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB)     
                                 = WS-AMT-BILL-ITEM-BG (SUB1) * -1      
           ELSE                                                         
               MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO                       
                    WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB)       
           END-IF.                                                      
           ADD WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB) TO         
                                  WS-IGAS-TOTAL-CALC (WS-IGAS-SUB).     
                                                                        
           IF WS-IGAS-TOTAL (WS-IGAS-SUB) NOT =                         
              WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)                          
                  MOVE 'C'                    TO WS-BILL-DEST-CODE      
                  MOVE 'X'                    TO WS-SYSTEM-CNTRL-CODE   
A02003     END-IF.                                                      
                                                                        
P00496 1050-EXIT.                                                       
P00496     EXIT.                                                        
                                                                        
      ************************************************************      03800000
      *  THIS ROUTINE BUILDS A WORKING STORAGE TABLE CONTAINING  *      03810000
      *  ALL GAS RATES.  THE SUBSCRIPT FOR THIS TABLE IS ALWAYS  *      03820000
      *  WS-IGAS-SUB.                                            *      03830000
      ************************************************************      03840000
                                                                        
       1100-BUILD-GAS-TABLE.                                            
                                                                        
           IF WS-CODE-DR-CR-CNSMPTN-BG (SUB1) = 'C'                     
              COMPUTE WS-HOLD-AMT-BILL-ITEM =                           
                                     WS-AMT-BILL-ITEM-BG (SUB1) * -1    
           ELSE                                                         
              MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO                        
                                               WS-HOLD-AMT-BILL-ITEM    
           END-IF                                                       
           IF WS-IGAS-PLAN (WS-IGAS-SUB) =                              
              WS-RATE-PLAN-NO-BG (SUB1) AND                             
              WS-IGAS-IC-NO (WS-IGAS-SUB) = WS-IC-NO-BG (SUB1) AND      
              WS-IGAS-REBILL-SW(WS-IGAS-SUB) = WS-CIG-CAN-REBILL AND    
              WS-IGAS-DATE-ORIG-BILL(WS-IGAS-SUB)  = WS-CIG-CAN-DOB AND 
              WS-IGAS-CODE-REV-CLASS (WS-IGAS-SUB) =                    
                                   WS-CODE-REVENUE-CLASS-BG(SUB1)       
                  ADD WS-HOLD-AMT-BILL-ITEM   TO                        
                      WS-IGAS-TOTAL (WS-IGAS-SUB)                       
                  IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                  
                     COMPUTE WS-IGAS-CURR-COST (WS-IGAS-SUB) =          
                             WS-IGAS-CURR-COST (WS-IGAS-SUB) +          
                             WS-HOLD-AMT-BILL-ITEM                      
                  ELSE                                                  
                     COMPUTE WS-IGAS-CURR-COST (WS-IGAS-SUB) =          
                             WS-IGAS-CURR-COST (WS-IGAS-SUB) +          
                             WS-HOLD-AMT-BILL-ITEM      -               
                             WS-AMT-STATE-TAX-BG (SUB1)                 
                  END-IF                                                
                  IF  WS-CIG-CAN-REBILL = 'Y'                           
                  AND WS-CODE-BILL-ITM-TYPE-BG(SUB1) = 'C'              
                     MOVE 'Y'                TO                         
                                       WS-IGAS-REBILL-SW(WS-IGAS-SUB)   
                     MOVE WS-DATE-ORIG-BILL-BG(SUB1) TO                 
                                  WS-IGAS-DATE-ORIG-BILL(WS-IGAS-SUB)   
                  ELSE                                                  
                     MOVE 'N'                TO                         
                                       WS-IGAS-REBILL-SW(WS-IGAS-SUB)   
                  END-IF                                                
T28985            MOVE WS-REV-MTH-ORIG-BILL-BG(SUB1) TO                 
T28985                            WS-IGAS-REV-ORIG-BILL-BG(WS-IGAS-SUB) 
                  PERFORM 1110-DETERMINE-CX-SUB    THRU 1110-EXIT       
                  PERFORM 1150-SUM-CURR-USAGE      THRU 1150-EXIT       
                  GO TO 1100-EXIT                                       
           ELSE                                                         
               IF WS-IGAS-PLAN (WS-IGAS-SUB) = SPACES                   
                   MOVE WS-RATE-PLAN-NO-BG (SUB1) TO                    
                        WS-IGAS-PLAN (WS-IGAS-SUB)                      
                   PERFORM 1105-GET-SVC-CAT-CD     THRU 1105-EXIT       
                   MOVE Z4-PRTY-SVC-CAT-CD     TO                       
                        WS-IGAS-SVC-CAT-CD(WS-IGAS-SUB)                 
                   MOVE WS-IC-NO-BG (SUB1)    TO                        
                                          WS-IGAS-IC-NO (WS-IGAS-SUB)   
                   MOVE WS-RATE-DESCRIPTION-CALC (SUB1) TO              
                                           WS-IGAS-DESC (WS-IGAS-SUB)   
                   MOVE WS-CODE-UTIL-TYPE-BG (SUB1) TO                  
                                      WS-IGAS-UTIL-TYPE (WS-IGAS-SUB)   
                   MOVE WS-GAS-BASE-USE-BG (SUB1) TO                    
                                  WS-IGAS-SUMMER-BASE (WS-IGAS-SUB)     
                   MOVE WS-HOLD-AMT-BILL-ITEM      TO                   
                                        WS-IGAS-TOTAL (WS-IGAS-SUB)     
                   IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                 
                      COMPUTE WS-IGAS-CURR-COST (WS-IGAS-SUB) =         
                              WS-HOLD-AMT-BILL-ITEM                     
                   ELSE                                                 
                      COMPUTE WS-IGAS-CURR-COST (WS-IGAS-SUB) =         
                            WS-HOLD-AMT-BILL-ITEM      -                
                            WS-AMT-STATE-TAX-BG (SUB1)                  
                   END-IF                                               
                   IF WS-CIG-CAN-REBILL = 'Y'                           
                  AND WS-CODE-BILL-ITM-TYPE-BG(SUB1) = 'C'              
                      MOVE 'Y'                TO                        
                                       WS-IGAS-REBILL-SW(WS-IGAS-SUB)   
                      MOVE WS-DATE-ORIG-BILL-BG(SUB1) TO                
                                  WS-IGAS-DATE-ORIG-BILL(WS-IGAS-SUB)   
                   ELSE                                                 
                      MOVE 'N'                TO                        
                                       WS-IGAS-REBILL-SW(WS-IGAS-SUB)   
                   END-IF                                               
T28985             MOVE WS-REV-MTH-ORIG-BILL-BG(SUB1) TO                
T28985                            WS-IGAS-REV-ORIG-BILL-BG(WS-IGAS-SUB) 
                   PERFORM 1150-SUM-CURR-USAGE THRU 1150-EXIT           
                   GO TO 1100-EXIT
               END-IF
           END-IF.                                     
           ADD 1                              TO WS-IGAS-SUB.           
           IF WS-IGAS-SUB > 20                                          
               MOVE 12                        TO RETURN-CODE            
               MOVE 'OVER 20 GAS RATES'       TO WS-MISC-MSG-TEXT       
               MOVE +17                       TO WS-MISC-MSG-LEN        
               PERFORM 9910-MISC-ERROR             THRU 9910-EXIT       
               PERFORM 9999-BAIL-OUT               THRU 9999-EXIT       
           END-IF.                                                      
           GO TO 1100-BUILD-GAS-TABLE.                                  
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1105-GET-SVC-CAT-CD.                                             
                                                                        
            IF WS-CODE-CURTAIL-PRTY-BG(SUB1) > 0                        
               MOVE WS-CODE-CURTAIL-PRTY-BG(SUB1)                       
                                           TO Z4-CODE-CURTAIL-PRTY      
               MOVE WS-COMPANY-NO-AT       TO Z4-COMPANY-NO             
               PERFORM 7000-SEL-SVC-CAT-CD THRU 7000-EXIT               
            ELSE                                                        
               MOVE SPACES                 TO Z4-PRTY-SVC-CAT-CD        
            END-IF.                                                     
                                                                        
       1105-EXIT.                                                       
           EXIT.                                                        
      ************************************************************      04960000
      *  DETERMINE THE FIRST BLANK LINE IN THE METER TABLE.      *      04970000
      *  THIS WILL BE NECESSARY ONLY WHEN ACCUMULATING DATA FOR  *      04980000
      *  ONE IC FROM MULTIPLE BG SEGMENTS.                       *      04990000
      ************************************************************      05000000
                                                                        
       1110-DETERMINE-CX-SUB.                                           
                                                                        
           IF WS-IGAS-METER (WS-IGAS-SUB WS-IGAS-CX-SUB) <= SPACES      
               GO TO 1110-EXIT                                          
           ELSE                                                         
               ADD 1                          TO WS-IGAS-CX-SUB         
               IF WS-IGAS-CX-SUB > 200                                  
                   MOVE 12                    TO RETURN-CODE            
                   MOVE 'OVER 100 METERS'     TO WS-MISC-MSG-TEXT       
                                                                        
                   MOVE +15                   TO WS-MISC-MSG-LEN        
                   PERFORM 9910-MISC-ERROR          THRU 9910-EXIT      
                   PERFORM 9999-BAIL-OUT            THRU 9999-EXIT      
               END-IF                                                   
               GO TO 1110-DETERMINE-CX-SUB                              
           END-IF.                                                      
                                                                        
       1110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      05220000
      *  PROCESS ALL CONSUMPTION HISTORY RECORDS FOR THIS RATE,  *      05230000
      *  SUMMING USAGE INTO THE CORRECT WORKING STORAGE TABLE.   *      05240000
      ************************************************************      05250000
                                                                        
       1150-SUM-CURR-USAGE.                                             
                                                                        
           PERFORM 1151-CHECK-METER-EXCHANGE       THRU 1151-EXIT.      
                                                                        
           MOVE 1                             TO SUB3.                  
           PERFORM UNTIL SUB3 > 200 OR WS-ACCOUNT-NO-CX (SUB3) = ZEROES 
               IF  WS-ACCOUNT-NO-CX (SUB3) = WS-ACCOUNT-NO-BG (SUB1)    
               AND WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S'                
               AND WS-BILL-NO-CX (SUB3) = WS-BILL-NO-BG (SUB1)          
               AND WS-CODE-UTIL-TYPE-CX (SUB3) =                        
                                        WS-CODE-UTIL-TYPE-BG (SUB1)     
               AND WS-IC-NO-CX (SUB3) = WS-IC-NO-BG (SUB1)              
               AND WS-BILL-ITEM-TIMESTMP-CX (SUB3) =                    
                                    WS-BILL-ITEM-TIMESTMP-BG (SUB1)     
               AND WS-CODE-ITEM-STATUS-CX (SUB3) NOT = 'I'              
               AND WS-CODE-USAGE-TYPE-CX (SUB3) = 'C'                   
PRJ251         AND WS-PRV-MTR-READ-COMB-FLG-CX (SUB3) NOT= 'S'          
                   IF WS-DATE-READ-CX (SUB3) >                          
                                     WS-IGAS-DATE-READ (WS-IGAS-SUB)    
                      MOVE WS-DATE-READ-CX (SUB3) TO                    
                                     WS-IGAS-DATE-READ (WS-IGAS-SUB)    
                      PERFORM 1210-GET-READ-TIME   THRU 1210-EXIT       
                   END-IF                                               
                   IF WS-METER-NO-CX (SUB3) NOT = WS-HOLD-METER-NO      
                      IF WS-DATE-READ-CX (SUB3) >                       
                         WS-IGAS-DATE-READ (WS-IGAS-SUB)                
                             MOVE WS-DATE-READ-CX (SUB3) TO             
                                       WS-IGAS-DATE-READ (WS-IGAS-SUB)  
                             PERFORM 1210-GET-READ-TIME THRU 1210-EXIT  
                      END-IF                                            
                      MOVE WS-CODE-METER-NO-READ-CX (SUB3) TO           
                                   WS-IGAS-NO-READ-REASON (WS-IGAS-SUB) 
                      MOVE WS-CODE-METER-READ-CX (SUB3) TO              
                                  WS-IGAS-CODE-METER-READ (WS-IGAS-SUB) 
                      PERFORM 1200-GAS-METER       THRU 1200-EXIT       
                      MOVE WS-METER-NO-CX (SUB3) TO WS-HOLD-METER-NO    
                   ELSE                                                 
                      PERFORM 1200-GAS-METER       THRU 1200-EXIT       
                      MOVE SPACES             TO                        
                          WS-IGAS-METER (WS-IGAS-SUB WS-IGAS-CX-SUB)    
                          WS-IGAS-SUPPLYING(WS-IGAS-SUB WS-IGAS-CX-SUB) 
                   END-IF                                               
                   MOVE 'X'              TO WS-IGAS-CHECK               
                                            (WS-IGAS-SUB WS-IGAS-CX-SUB)
                   COMPUTE WS-NO-THERMS ROUNDED =                       
                           WS-NO-UNITS-CX(SUB3) *                       
                                                WS-BTU-FACTOR-BG(SUB1)  
PRJ251             IF WS-CODE-DEBIT-CREDIT-CX (SUB3) = 'C'              
PRJ251                COMPUTE WS-NO-THERMS = WS-NO-THERMS * -1          
PRJ251             END-IF                                               
                   ADD WS-NO-THERMS      TO                             
                                        WS-IGAS-CURR-USE (WS-IGAS-SUB)  
                   IF WS-GAS-METER-CHANGE = 'Y'                         
                      MOVE WS-HOLD-NO-OF-DAYS  TO                       
                                        WS-IGAS-CURR-DAYS (WS-IGAS-SUB) 
                   ELSE                                                 
                     MOVE WS-NO-DAYS-CX (SUB3) TO                       
                                        WS-IGAS-CURR-DAYS (WS-IGAS-SUB) 
                   END-IF                                               
                   ADD 1                 TO WS-IGAS-CX-SUB              
               END-IF                                                   
               ADD 1                     TO SUB3                        
           END-PERFORM.                                                 
      *                                                                 05850000
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05880000
       1151-CHECK-METER-EXCHANGE.                                       
      *                                                                 05900000
           MOVE 1                        TO WS-CHECK-CX-SUB             
      *                                                                 05920000
           PERFORM UNTIL WS-CODE-UTIL-TYPE-CX(WS-CHECK-CX-SUB) = SPACES 
              IF WS-CODE-UTIL-TYPE-CX(WS-CHECK-CX-SUB) = 'G' AND        
                 WS-CODE-METER-READ-CX(WS-CHECK-CX-SUB) = 'B'           
                 MOVE 'Y'                TO WS-GAS-METER-CHANGE         
                 MOVE 'N'                TO WS-MATCH-FOUND              
                 PERFORM VARYING WS-HOLD-BG-SUB FROM 1 BY 1 UNTIL       
                         MATCH-FOUND OR WS-ACCOUNT-NO-BG(WS-HOLD-BG-SUB)
                         EQUAL ZERO                                     
                      IF WS-ACCOUNT-NO-BG (WS-HOLD-BG-SUB) =            
                         WS-ACCOUNT-NO-CX (WS-CHECK-CX-SUB) AND         
                         WS-BILL-ITEM-TIMESTMP-BG(WS-HOLD-BG-SUB) =     
                         WS-BILL-ITEM-TIMESTMP-CX(WS-CHECK-CX-SUB) AND  
                         WS-CODE-UTIL-TYPE-BG (WS-HOLD-BG-SUB) =        
                         WS-CODE-UTIL-TYPE-CX (WS-CHECK-CX-SUB) AND     
                         WS-IC-NO-BG (WS-HOLD-BG-SUB) =                 
                         WS-IC-NO-CX (WS-CHECK-CX-SUB)                  
                         MOVE WS-NO-OF-CONS-DAYS-BG (WS-HOLD-BG-SUB)    
                                         TO WS-HOLD-NO-OF-DAYS          
                         MOVE 'Y'        TO WS-MATCH-FOUND              
                      END-IF                                            
                 END-PERFORM                                            
              END-IF                                                    
              ADD 1                      TO WS-CHECK-CX-SUB             
           END-PERFORM.                                                 
                                                                        
       1151-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ************************************************************      06220000
      *  MOVE APPROPRIATE DATA FROM CONSUMPTION HISTORY TO THE   *      06230000
      *  GAS WORKING STORAGE TABLE.  THIS PART OF THE TABLE IS   *      06240000
      *  TWO-DIMENSIONAL;  THE SUBSCRIPTS ARE WS-IGAS-SUB,       *      06250000
      *  WS-IGAS-CX-SUB.  DATES ARE REFORMATTED FROM CCYYMMDD TO *      06260000
      *  MMM DD.  THE NUMBER OF DAYS BETWEEN THE BILLING PERIOD  *      06270000
      *  START AND END IS COMPUTED.  METER SUPPLYING COMES FROM  *      06280000
      *  THE METERED ENVIRONMENT SEGMENT.                        *      06290000
      ************************************************************      06300000
                                                                        
       1200-GAS-METER.                                                  
                                                                        
           MOVE WS-METER-NO-CX (SUB3)    TO                             
                             WS-IGAS-METER (WS-IGAS-SUB WS-IGAS-CX-SUB).
           MOVE WS-NO-DIALS-CX (SUB3)    TO                             
                         WS-IGAS-NO-DIALS (WS-IGAS-SUB WS-IGAS-CX-SUB). 
           MOVE WS-PREV-METER-READ-DATE-CALC (SUB3) TO                  
                                                    WS-UNFORMAT-DATE.   
           MOVE SPACES                        TO WS-ENGLISH-DATE.       
           MOVE WS-UNFORMAT-DATE(9:2)         TO WS-ENGLISH-DD.         
           PERFORM 4000-ENGLISH-MONTH              THRU 4000-EXIT.      
           MOVE WS-ENGLISH-DATE               TO                        
                        WS-IGAS-ST-DATE (WS-IGAS-SUB WS-IGAS-CX-SUB).   
           MOVE WS-DATE-READ-CX (SUB3)        TO WS-UNFORMAT-DATE.      
           MOVE SPACES                        TO WS-ENGLISH-DATE.       
           MOVE WS-UNFORMAT-DATE(9:2)         TO WS-ENGLISH-DD.         
           PERFORM 4000-ENGLISH-MONTH              THRU 4000-EXIT.      
           MOVE WS-ENGLISH-DATE               TO                        
                       WS-IGAS-END-DATE (WS-IGAS-SUB WS-IGAS-CX-SUB).   
           MOVE WS-PREV-METER-READ-DATE-CALC (SUB3)                     
T35152                                        TO WS-START-DATE          
T35152                                           WS-IGAS-ST-DATE-NUM    
T35152                                    (WS-IGAS-SUB WS-IGAS-CX-SUB). 
T35152     MOVE WS-DATE-READ-CX (SUB3)        TO WS-END-DATE            
T35152                                           WS-IGAS-END-DATE-NUM   
T35152                                    (WS-IGAS-SUB WS-IGAS-CX-SUB). 
           MOVE WS-NO-DAYS-CX (SUB3)          TO                        
                           WS-IGAS-DAYS (WS-IGAS-SUB WS-IGAS-CX-SUB).   
           MOVE WS-PREV-METER-READ-CALC (SUB3) TO                       
                     WS-IGAS-PREV-READING (WS-IGAS-SUB WS-IGAS-CX-SUB). 
           MOVE WS-METER-READING-CX (SUB3)    TO                        
                     WS-IGAS-CURR-READING (WS-IGAS-SUB WS-IGAS-CX-SUB). 
           MOVE WS-CONSTANT-CX (SUB3)         TO                        
                         WS-IGAS-CONSTANT (WS-IGAS-SUB WS-IGAS-CX-SUB). 
           MOVE WS-NO-UNITS-CX (SUB3)         TO                        
                         WS-IGAS-USAGE (WS-IGAS-SUB WS-IGAS-CX-SUB).    
PRJ251     IF WS-CODE-DEBIT-CREDIT-CX (SUB3) = 'C'                      
PRJ251        COMPUTE WS-IGAS-USAGE (WS-IGAS-SUB WS-IGAS-CX-SUB) =      
PRJ251                WS-IGAS-USAGE (WS-IGAS-SUB WS-IGAS-CX-SUB)* -1    
PRJ251     END-IF.                                                      
           SET WS-MTRD-INDX                   TO 1.                     
           SEARCH WS-MTRD-ENVRNMT-DATA                                  
               AT END                                                   
                   MOVE SPACES                TO WS-IGAS-SUPPLYING      
                                          (WS-IGAS-SUB WS-IGAS-CX-SUB)  
               WHEN WS-ACCOUNT-NO-MN (WS-MTRD-INDX) = ZEROES            
                   MOVE SPACES                TO WS-IGAS-SUPPLYING      
                                          (WS-IGAS-SUB WS-IGAS-CX-SUB)  
               WHEN WS-ACCOUNT-NO-MN (WS-MTRD-INDX) =                   
                    WS-ACCOUNT-NO-CX (SUB3) AND                         
                    WS-CODE-UTIL-TYPE-MN (WS-MTRD-INDX) =               
                    WS-CODE-UTIL-TYPE-CX (SUB3) AND                     
                    WS-IC-NO-MN (WS-MTRD-INDX) =                        
                    WS-IC-NO-CX (SUB3) AND                              
                    WS-MTR-REF-NO-MN (WS-MTRD-INDX) =                   
                    WS-MTR-REF-NO-CX (SUB3) AND                         
                    WS-METER-NO-MN (WS-MTRD-INDX) =                     
                    WS-METER-NO-CX (SUB3)                               
                        MOVE WS-METER-SUPPLYING-MN (WS-MTRD-INDX) TO    
                             WS-IGAS-SUPPLYING                          
                                 (WS-IGAS-SUB WS-IGAS-CX-SUB).          
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1210-GET-READ-TIME.                                              
                                                                        
           SET WS-MTRD-INDX                   TO 1.                     
           SEARCH WS-MTRD-ENVRNMT-DATA                                  
               AT END                                                   
                   MOVE SPACES TO WS-IGAS-TIME-READ (WS-IGAS-SUB)       
               WHEN WS-ACCOUNT-NO-MN (WS-MTRD-INDX) = ZEROES            
                   MOVE SPACES TO WS-IGAS-TIME-READ (WS-IGAS-SUB)       
               WHEN WS-ACCOUNT-NO-MN (WS-MTRD-INDX) =                   
                    WS-ACCOUNT-NO-CX (SUB3) AND                         
                    WS-CODE-UTIL-TYPE-MN (WS-MTRD-INDX) =               
                    WS-CODE-UTIL-TYPE-CX (SUB3) AND                     
                    WS-IC-NO-MN (WS-MTRD-INDX) =                        
                    WS-IC-NO-CX (SUB3) AND                              
                    WS-LAST-VALID-READ-DT-MN (WS-MTRD-INDX) =           
                    WS-DATE-READ-CX (SUB3)                              
                        MOVE WS-LAST-VALID-READ-TM-MN (WS-MTRD-INDX) TO 
                             WS-IGAS-TIME-READ (WS-IGAS-SUB).           
                                                                        
       1210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      07110000
      *  PROCESS ALL BILL ADJUSTMENTS AND CALCULATIONS (GAS).    *      07120000
      *  BASIC FACILITY CHARGES WILL PRINT FIRST.  SAVE WNA AND  *      07130000
      *  BTU FACTORS FOR PRINTING.  FRANCHISE TAX PRINTS LAST.   *      07140000
      ************************************************************      07150000
                                                                        
       1300-GAS-CHARGES.                                                
                                                                        
           MOVE 1                             TO SUB2 WS-IGAS-CHG-SUB.  
           PERFORM 1310-DETERMINE-CHG-SUB THRU 1310-EXIT.               
           PERFORM UNTIL SUB2 > 100 OR WS-ACCOUNT-NO-BA (SUB2) = ZEROES 
              IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BA (SUB2) AND  
                 WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BA (SUB2) AND        
                 WS-CODE-UTIL-TYPE-BG (SUB1) =                          
                             WS-CODE-UTIL-TYPE-BA (SUB2) AND            
                 WS-IC-NO-BG (SUB1) = WS-IC-NO-BA (SUB2) AND            
                 WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
                             WS-BILL-ITEM-TIMESTMP-BA (SUB2) AND        
                 WS-FACTOR-ID-BA (SUB2) = 'BFACCHRG'                    
                     MOVE 'Basic Facilities Charge' TO                  
                         WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB)  
                     COMPUTE WS-ROUNDED-BFC ROUNDED =                   
                             WS-AMT-ADJUSTMENT-BA (SUB2) * 1            
                     MOVE WS-ROUNDED-BFC TO                             
                          WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB) 
                          WS-HOLD-BASIC-FACILITY                        
                     ADD WS-AMT-ADJUSTMENT-BA (SUB2) TO                 
                         WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)               
                     ADD 1                    TO WS-IGAS-CHG-SUB        
               END-IF                                                   
               ADD 1                          TO SUB2                   
           END-PERFORM.                                                 
                                                                        
           MOVE 1 TO SUB2.                                              
I00177     PERFORM UNTIL SUB2 > WS-BZ-MAX-ENTRY OR                      
                         WS-ACCOUNT-NO-BC (SUB2) = ZEROES               
               IF WS-ACCOUNT-NO-BG (SUB1) =                             
                  WS-ACCOUNT-NO-BC (SUB2) AND                           
                  WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BC (SUB2) AND       
                  WS-CODE-UTIL-TYPE-BG (SUB1) =                         
                  WS-CODE-UTIL-TYPE-BC (SUB2) AND                       
                  WS-IC-NO-BG (SUB1) = WS-IC-NO-BC (SUB2) AND           
                  WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                     
                  WS-BILL-ITEM-TIMESTMP-BC (SUB2)                       
                      PERFORM 1400-GAS-CALCS       THRU 1400-EXIT       
               END-IF                                                   
               ADD 1 TO SUB2                                            
            END-PERFORM.                                                
           IF WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S'                     
              PERFORM 1320-FRANCHISE-TAX           THRU 1320-EXIT       
           END-IF.                                                      
                                                                        
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      07670000
      *  DETERMINE THE FIRST BLANK LINE IN THE CHARGES TABLE.    *      07680000
      ************************************************************      07690000
                                                                        
       1310-DETERMINE-CHG-SUB.                                          
                                                                        
           IF WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB) <= SPACES   
               GO TO 1310-EXIT                                          
           ELSE                                                         
               ADD 1                          TO WS-IGAS-CHG-SUB        
               IF WS-IGAS-CHG-SUB > 200                                 
                   MOVE 12                    TO RETURN-CODE            
                   MOVE 'OVER 200 CHARGES'    TO WS-MISC-MSG-TEXT       
                   MOVE +16                   TO WS-MISC-MSG-LEN        
                   PERFORM 9910-MISC-ERROR         THRU 9910-EXIT       
                   PERFORM 9999-BAIL-OUT           THRU 9999-EXIT       
               END-IF                                                   
               GO TO 1310-DETERMINE-CHG-SUB
           END-IF.                            
                                                                        
       1310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1320-FRANCHISE-TAX.                                              
                                                                        
           IF WS-AMT-CITY-TAX-BG (SUB1) > ZEROES                        
T30013     AND WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S'                    
               MOVE SPACES                    TO WS-FORMAT-MESSAGE      
               COMPUTE WS-COMPUTE-PCT =                                 
                             WS-FRANCHISE-TX-RATE-CALC (SUB1) * 100     
               MOVE WS-COMPUTE-PCT            TO WS-DISPLAY-PCT         
T29598         IF (CSR-DATABASE                                         
T30583         AND WS-CIG-CAN-REBILL = 'N'                              
T29598         AND WS-COMPANY-NO-AT = '01')                             
T29598            MOVE SPACES TO WS-REV-INPUT                           
T29598                           WS-REV-TABLE                           
T29598            MOVE 35 TO WS-REV-LENG                                
T29598            MOVE WS-REV-DISTRICT-CD-PR TO A9-REV-DISTRICT-CD      
T29598            PERFORM 6500-GET-REV-DIST-DESC THRU 6500-EXIT         
T29598            STRING 'Franchise Fee '                               
T29598                   WS-DISPLAY-PCT                                 
T29598                   '% paid to the '                               
T29598                   WS-REV-TABLE                                   
T29598                   DELIMITED BY SIZE                              
T29598                   INTO WS-FORMAT-MESSAGE                         
T29598            MOVE 75 TO WS-EMB-LENG                                
T29598         ELSE                                                     
                  STRING 'Franchise Fee - '                             
                         WS-DISPLAY-PCT                                 
                         '%'                                            
                         DELIMITED BY SIZE                              
                    INTO WS-FORMAT-MESSAGE                              
                  MOVE 23                     TO WS-EMB-LENG            
T29598         END-IF                                                   
               MOVE SPACES                    TO WS-EMB-INPUT           
                                                 WS-CMP-TABLE           
               MOVE WS-FORMAT-MESSAGE         TO WS-EMB-INPUT           
               PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT       
               MOVE WS-CMP-TABLE              TO                        
                                   WS-IGAS-FRAN-MSG (WS-IGAS-SUB)       
               ADD WS-AMT-CITY-TAX-BG (SUB1)  TO                        
                                   WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)     
               MOVE WS-AMT-CITY-TAX-BG (SUB1) TO                        
                                   WS-IGAS-FRAN-AMT (WS-IGAS-SUB)       
           END-IF.                                                      
           ADD WS-AMT-STATE-TAX-BG (SUB1)     TO                        
                                   WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)     
                             WS-IGAS-STATE-TAX-AMT (WS-IGAS-SUB).       
           IF WS-AMT-STATE-TAX-BG (SUB1) NOT = 0                        
              COMPUTE WS-COMPUTE-PCT =                                  
T29035               WS-STATE-TX-RATE-CALC (SUB1) * 100                 
              MOVE WS-COMPUTE-PCT            TO WS-DISPLAY-PCT          
              MOVE SPACES                    TO WS-EMB-INPUT            
                                                WS-CMP-TABLE            
              STRING 'State Sales Tax at'                               
                     WS-DISPLAY-PCT                                     
                     ' % '                                              
                     DELIMITED BY SIZE                                  
                INTO WS-EMB-INPUT                                       
              MOVE 28                        TO WS-EMB-LENG             
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT        
              MOVE WS-CMP-TABLE              TO                         
                   WS-IGAS-STATE-TAX-MSG(WS-IGAS-SUB)                   
           END-IF.                                                      
      *                                                                 08300000
       1320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      08340000
      *  THIS ROUTINE PROCESSES ALL BLOCKS OF GAS USAGE, PRINTING*      08350000
      *  THE CORRECT MESSAGE AND SHOWING WNA USAGE WHERE         *      08360000
      *  APPLICABLE.  ALSO ONE LINE SHOWING THE CCF TO THERM     *      08370000
      *  CONVERSION PRINTS.  NOTE THAT READ-UNITS-BC CONTAINS    *      08380000
      *  USAGE AND NET-UNITS-BC CONTAINS THERMS.                 *      08390000
      ************************************************************      08400000
                                                                        
       1400-GAS-CALCS.                                                  
A02624*                                                                         
A02624     INITIALIZE WS-FORMAT-LITERAL                                 
A02624                WS-FORMAT-UNITS.                                  
                                                                        
      *The logic is to process only the Emergency gas and Competitive*  08440000
      *pricing.                                                      *  08450000
           IF WS-COMPONENT-ID-BC(SUB2) = '15' OR '51'                   
              PERFORM 1450-GET-COMP-EMER-DATA THRU 1450-EXIT            
              GO TO 1400-EXIT                                           
           END-IF.                                                      
      *The logic to process the remaining Charges.                   *  08500000
           MOVE SPACES              TO WS-FORMAT-MESSAGE.               
           MOVE 'DT' TO WS-IGAS-CHG-UNIT(WS-IGAS-SUB WS-IGAS-CHG-SUB)   
           IF  WS-CODE-REVENUE-CLASS-BG(SUB1) = '000'                   
               MOVE WS-CODE-REVENUE-CLASS-BG(SUB1) TO                   
                                  WS-IGAS-CODE-REV-CLASS(WS-IGAS-SUB)   
               MOVE 'Y' TO WS-IGAS-TRANSP-IND(WS-IGAS-SUB)              
               IF WS-COMPONENT-ID-BC(SUB2) = '70' OR '71'               
                  PERFORM 1430-OBTAIN-TRANSP-DETAILS THRU 1430-EXIT     
                  GO TO 1400-EXIT                                       
               END-IF                                                   
           ELSE                                                         
              MOVE 'N'      TO WS-IGAS-TRANSP-IND(WS-IGAS-SUB)          
              MOVE WS-CODE-REVENUE-CLASS-BG(SUB1) TO                    
                                  WS-IGAS-CODE-REV-CLASS(WS-IGAS-SUB)   
           END-IF                                                       
           IF WS-BLOCKS-USED-BC (SUB2) = 1                              
              MOVE SPACES                      TO WS-HOLD-MSG           
              IF WS-COMPONENT-ID-BC(SUB2) = '55'                        
                 MOVE 'Penalty Gas'            TO WS-HOLD-MSG           
ACT18A        ELSE                                                      
ACT18A          IF  WS-CODE-REVENUE-CLASS-BG(SUB1) = '000'              
ACT18A            IF WS-CONSUMPTION-TYPE-BC (SUB2) = 'D'                
ACT18A               MOVE 'Transportation'    TO WS-HOLD-MSG            
ACT18A            ELSE                                                  
ACT18A               MOVE 'Transportation Demand' TO WS-HOLD-MSG        
ACT18A            END-IF                                                
ACT18A          ELSE                                                    
ACT18A           IF  WS-CONSUMPTION-TYPE-BC (SUB2) = 'D'                
ACT18A               MOVE 'Commodity Charge'  TO WS-HOLD-MSG            
ACT18A           ELSE                                                   
ACT018               IF WS-COMPONENT-ID-BC(SUB2)   = '30' AND           
ACT018                  WS-RATE-SUB-GRP-TYPE(SUB1) = 'S'                
ACT018                  MOVE 'Standby Demand Charge' TO WS-HOLD-MSG     
ACT018               ELSE                                               
ACT018                  MOVE 'Demand Charge' TO WS-HOLD-MSG             
ACT018               END-IF                                             
ACT18A           END-IF                                                 
ACT18A          END-IF                                                  
ACT18A        END-IF                                                    
                                                                        
               MOVE 1                         TO WS-BLOCK-SUB           
               MOVE WS-UNITS-BILLED-BC (SUB2 1) TO                      
                    WS-IGAS-CHG-USAGE (WS-IGAS-SUB WS-IGAS-CHG-SUB)     
                    WS-FORMAT-UNITS                                     
               MOVE WS-AMT-NET-RATE-BC (SUB2 1) TO                      
                    WS-DISPLAY-RATE                                     
               MOVE WS-DISPLAY-RATE             TO                      
                    WS-IGAS-CHG-FACTOR(WS-IGAS-SUB WS-IGAS-CHG-SUB)     
               PERFORM 1410-FORMAT-WNA             THRU 1410-EXIT       
               MOVE WS-FORMAT-RATES             TO                      
                    WS-IGAS-CHG-FACTOR(WS-IGAS-SUB WS-IGAS-CHG-SUB)     
A02624         MOVE SPACES                      TO WS-EMB-INPUT         
A02624                                             WS-CMP-TABLE         
               IF WS-PRICE-TYPE-CD-BC (SUB2, 1) = 'F'                   
                   MOVE 'First'                TO WS-FORMAT-LITERAL     
                   STRING                                               
                      WS-HOLD-MSG                                       
A02624                ' - '                                             
                      WS-FORMAT-GAS-MESSAGE                             
                      DELIMITED BY SIZE                                 
                  INTO WS-EMB-INPUT                                     
A02624            MOVE 105                      TO WS-EMB-LENG          
                  PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT    
                  MOVE WS-CMP-TABLE             TO                      
                         WS-IGAS-CHG-MSG(WS-IGAS-SUB WS-IGAS-CHG-SUB)   
                  MOVE SPACES                   TO                      
                       WS-IGAS-CHG-FACTOR(WS-IGAS-SUB WS-IGAS-CHG-SUB)  
                       WS-IGAS-CHG-UNIT(WS-IGAS-SUB WS-IGAS-CHG-SUB)    
                  MOVE ZEROS                    TO                      
                       WS-IGAS-CHG-USAGE (WS-IGAS-SUB WS-IGAS-CHG-SUB)  
               ELSE                                                     
                   STRING                                               
A02624                WS-HOLD-MSG                                       
A02624                ' - '                                             
A02624                WS-FORMAT-UNITS                                   
A02624                ' DT x '                                          
A02624                WS-FORMAT-RATES                                   
A02624                DELIMITED BY SIZE                                 
A02624            INTO WS-EMB-INPUT                                     
A03876            MOVE 135                      TO WS-EMB-LENG          
A02624            PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT    
A02624*           MOVE WS-HOLD-MSG              TO                      09160000
A02624            MOVE WS-CMP-TABLE             TO                      
                       WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB)    
               END-IF                                                   
               MOVE WS-AMT-BLOCK-BC (SUB2 1)    TO                      
                       WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB)    
               ADD WS-AMT-BLOCK-BC (SUB2 1)     TO                      
                                  WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)      
               ADD 1                            TO WS-IGAS-CHG-SUB      
           ELSE                                                         
               MOVE 1                           TO WS-BLOCK-SUB         
               PERFORM UNTIL WS-BLOCK-SUB > 9 OR                        
                       WS-BLOCK-SUB > WS-BLOCKS-USED-BC (SUB2)          
T29450          IF WS-COMPONENT-ID-BC(SUB2) = '55'                      
T29450             MOVE WS-COMPONENT-ID-BC(SUB2)   TO PS-CMPNT-ID-CD    
T29450             MOVE WS-CODE-UTIL-TYPE-BC(SUB2) TO PS-CODE-UTIL-TYPE 
T29450             MOVE WS-RATE-PLAN-NO-BG (SUB1)  TO PS-RATE-PLAN-NO   
T29450             MOVE WS-BLOCK-SUB               TO PS-BLOCK-NO       
T29450             PERFORM 7100-GET-PENALTY-BLOCKS THRU 7100-EXIT       
T29450             PERFORM 1475-PROCESS-PENALTY-BLKS THRU 1475-EXIT     
T29450          ELSE                                                    
ACT18A            IF  WS-CODE-REVENUE-CLASS-BG(SUB1) = '000'            
ACT18A                IF WS-CONSUMPTION-TYPE-BC (SUB2) = 'D'            
ACT18A                 MOVE 'Transportation'        TO WS-HOLD-MSG      
ACT18A                ELSE                                              
ACT18A                 MOVE 'Transportation Demand' TO WS-HOLD-MSG      
ACT18A                END-IF                                            
ACT18A            ELSE                                                  
ACT18A                IF WS-CONSUMPTION-TYPE-BC (SUB2) = 'D'            
ACT18A                   MOVE 'Commodity Charge'      TO WS-HOLD-MSG    
ACT18A                ELSE                                              
ACT018                   IF WS-COMPONENT-ID-BC(SUB2)   = '30' AND       
ACT018                      WS-RATE-SUB-GRP-TYPE(SUB1) = 'S'            
ACT018                      MOVE 'Standby Demand Charge' TO WS-HOLD-MSG 
ACT018                   ELSE                                           
ACT018                      MOVE 'Demand Charge' TO WS-HOLD-MSG         
ACT018                   END-IF                                         
ACT18A                END-IF                                            
ACT18A            END-IF                                                
                  MOVE WS-UNITS-BILLED-BC (SUB2 WS-BLOCK-SUB) TO        
                    WS-IGAS-CHG-USAGE (WS-IGAS-SUB WS-IGAS-CHG-SUB)     
                    WS-FORMAT-UNITS                                     
                  MOVE 'DT' TO                                          
                       WS-IGAS-CHG-UNIT(WS-IGAS-SUB WS-IGAS-CHG-SUB)    
                  MOVE WS-AMT-NET-RATE-BC (SUB2 WS-BLOCK-SUB) TO        
                       WS-DISPLAY-RATE                                  
                  MOVE WS-DISPLAY-RATE              TO                  
                      WS-IGAS-CHG-FACTOR(WS-IGAS-SUB WS-IGAS-CHG-SUB)   
                   PERFORM 1410-FORMAT-WNA         THRU 1410-EXIT       
                   MOVE WS-FORMAT-RATES             TO                  
                      WS-IGAS-CHG-FACTOR(WS-IGAS-SUB WS-IGAS-CHG-SUB)   
                   IF WS-BLOCK-SUB = 1                                  
                      IF WS-GAS-BASE-USE-BG (SUB1) = 0 AND              
                         WS-BLOCK-SIZE-BC (SUB2 1) = 0 AND              
                         WS-UNITS-BILLED-BC (SUB2 1) = 0                
                            PERFORM 1420-ZERO-SUMMER-BASE THRU          
                                    1420-EXIT                           
                      END-IF                                            
                      MOVE 'First'             TO WS-FORMAT-LITERAL     
                      IF WS-PRICE-TYPE-CD-BC (SUB2, 1) = 'F'            
                        MOVE SPACES            TO                       
                        WS-IGAS-CHG-FACTOR(WS-IGAS-SUB WS-IGAS-CHG-SUB) 
                        WS-IGAS-CHG-UNIT(WS-IGAS-SUB WS-IGAS-CHG-SUB)   
                        MOVE ZEROS             TO                       
A02624                  WS-DISPLAY-RATE                                 
                        WS-IGAS-CHG-USAGE (WS-IGAS-SUB WS-IGAS-CHG-SUB) 
A02624                  INITIALIZE WS-HOLD-DESC                         
A02624                  STRING WS-HOLD-MSG                              
A02624                         ' - '                                    
A02624                         WS-FORMAT-GAS-MESSAGE                    
A02624                         DELIMITED BY SIZE                        
A02624                    INTO WS-HOLD-DESC                             
A02624                ELSE                                              
A02624                  INITIALIZE WS-HOLD-DESC                         
A02624                  STRING WS-HOLD-MSG                              
A02624                         ' - '                                    
A02624                         WS-FORMAT-GAS-MESSAGE                    
A02624                         ' x '                                    
A02624                         WS-FORMAT-RATES                          
A02624                         DELIMITED BY SIZE                        
A02624                    INTO WS-HOLD-DESC                             
                      END-IF                                            
                   ELSE                                                 
A02624                INITIALIZE WS-HOLD-DESC                           
A02624                MOVE 'Remaining'         TO WS-FORMAT-LITERAL     
A02624                STRING WS-HOLD-MSG                                
A02624                       ' - '                                      
A02624                       WS-FORMAT-GAS-MESSAGE                      
A02624                       ' x '                                      
A02624                       WS-FORMAT-RATES                            
A02624                       DELIMITED BY SIZE                          
A02624                  INTO WS-HOLD-DESC                               
                   END-IF                                               
                   MOVE SPACES                TO WS-EMB-INPUT           
                                                 WS-CMP-TABLE           
A03876             MOVE 144                   TO WS-EMB-LENG            
                   MOVE WS-HOLD-DESC          TO WS-EMB-INPUT           
                   PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT   
                   INSPECT WS-CMP-TABLE REPLACING ALL '*' BY HIGH-VALUES
                   MOVE WS-CMP-TABLE          TO                        
                         WS-IGAS-CHG-MSG(WS-IGAS-SUB WS-IGAS-CHG-SUB)   
                   MOVE WS-AMT-BLOCK-BC (SUB2 WS-BLOCK-SUB) TO          
                        WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB)   
                   ADD WS-AMT-BLOCK-BC (SUB2 WS-BLOCK-SUB) TO           
                                    WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)    
                   ADD 1                      TO WS-IGAS-CHG-SUB        
                                                 WS-BLOCK-SUB           
T29450          END-IF                                                  
               END-PERFORM                                              
           END-IF.                                                      
           IF WS-IGAS-CHG-SUB > 200                                     
               MOVE 12                        TO RETURN-CODE            
               MOVE 'OVER 200 CHARGE MESSAGES' TO WS-MISC-MSG-TEXT      
               MOVE +24                       TO WS-MISC-MSG-LEN        
               PERFORM 9910-MISC-ERROR             THRU 9910-EXIT       
               PERFORM 9999-BAIL-OUT               THRU 9999-EXIT       
           END-IF.                                                      
                                                                        
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      10070000
      *  DETERMINE IF GAS CHARGE LINE DESCRIPTION NEEDS TO       *      10080000
      *  CONTAIN WNA FACTOR DATA.                                *      10090000
      ************************************************************      10100000
                                                                        
       1410-FORMAT-WNA.                                                 
                                                                        
           MOVE SPACES                        TO WS-FORMAT-RATES.       
           IF WS-WNA-FACTOR-BG (SUB1) < 0                               
               MOVE '-'                       TO WS-WNA-SIGN            
           ELSE                                                         
               MOVE '+'                       TO WS-WNA-SIGN            
           END-IF.                                                      
           MOVE WS-WNA-FACTOR-BG (SUB1) TO WS-DISPLAY-WNA.              
           IF WS-FIRST-WNA-BLOCK-BC (SUB2) <= WS-BLOCK-SUB AND          
              WS-FIRST-WNA-BLOCK-BC (SUB2) > 0                          
              MOVE WS-AMT-NET-RATE-BC (SUB2 WS-BLOCK-SUB) TO            
                                        WS-DISPLAY-RATE-DISP            
              COMPUTE WS-DISPLAY-RATE = WS-DISPLAY-RATE-DISP -          
                                        WS-WNA-FACTOR-BG(SUB1)          
               STRING '($'                                              
                      WS-DISPLAY-RATE                                   
                      ' '                                               
                      WS-WNA-SIGN                                       
                      ' $'                                              
                      WS-DISPLAY-WNA                                    
                      ' WNA)'                                           
                      DELIMITED BY SIZE                                 
                 INTO WS-FORMAT-RATES                                   
A02624*        MOVE WS-DISPLAY-RATE    TO WS-IGAS-CHG-FCTR                      
A02624*                                  (WS-IGAS-SUB WS-IGAS-CHG-SUB)          
A02624*        MOVE WS-WNA-SIGN        TO WS-IGAS-WNA-SIGN                      
A02624*                                  (WS-IGAS-SUB WS-IGAS-CHG-SUB)          
A02624*        MOVE WS-DISPLAY-WNA     TO WS-IGAS-WNA-FACT                      
A02624*                                  (WS-IGAS-SUB WS-IGAS-CHG-SUB)          
           ELSE                                                         
A02624*        MOVE WS-DISPLAY-RATE    TO WS-IGAS-CHG-FCTR                      
A02624*                                  (WS-IGAS-SUB WS-IGAS-CHG-SUB)          
A02624         STRING ' $'                                              
                      WS-DISPLAY-RATE                                   
                      DELIMITED BY SIZE                                 
                 INTO WS-FORMAT-RATES
           END-IF.                                  
                                                                        
       1410-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       1420-ZERO-SUMMER-BASE.                                           
                                                                        
            ADD +1                            TO WS-BLOCK-SUB.          
            MOVE WS-UNITS-BILLED-BC (SUB2 WS-BLOCK-SUB) TO              
                 WS-IGAS-CHG-USAGE (WS-IGAS-SUB WS-IGAS-CHG-SUB)        
                 WS-FORMAT-UNITS.                                       
            MOVE WS-AMT-NET-RATE-BC (SUB2 WS-BLOCK-SUB) TO              
                 WS-DISPLAY-RATE                                        
            MOVE WS-DISPLAY-RATE              TO                        
                 WS-IGAS-CHG-FACTOR (WS-IGAS-SUB WS-IGAS-CHG-SUB).      
            PERFORM 1410-FORMAT-WNA                THRU 1410-EXIT.      
            MOVE WS-FORMAT-RATES              TO                        
                 WS-IGAS-CHG-FACTOR(WS-IGAS-SUB WS-IGAS-CHG-SUB).       
                                                                        
       1420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10620000
      ************************************************************      10630000
      *THIS ROUTINE IS TO GET THE DETAILS TO PRINT FOR A TRANSPOR*      10640000
      *TATION FACTOR AND THE BILLED AMOUNT                       *      10650000
      ************************************************************      10660000
      *                                                                 10670000
       1430-OBTAIN-TRANSP-DETAILS.                                      
           EVALUATE WS-COMPONENT-ID-BC(SUB2)                            
              WHEN '70'                                                 
A01336          MOVE 'Transportation Balance & Shrinkage' TO            
A02624             WS-HOLD-MSG                                          
              WHEN '71'                                                 
A01336          MOVE 'Transportation over MDQ & Shrinkage' TO           
A02624             WS-HOLD-MSG                                          
           END-EVALUATE                                                 
A03303     MOVE ZERO                TO FH-FCTR-POWER-10.                
           PERFORM 1440-GET-TRANSP-FACTOR        THRU 1440-EXIT.        
A03303     IF FH-FCTR-POWER-10  = 0                                     
A03303        MOVE FH-FACTOR                  TO WS-DISPLAY-FACTOR      
A03303     ELSE                                                         
A03303        COMPUTE WS-FH-FACTOR = FH-FACTOR * 10**FH-FCTR-POWER-10   
A03303        MOVE WS-FH-FACTOR               TO WS-DISPLAY-FACTOR      
A03303     END-IF                                                       
A02624     INITIALIZE WS-DISPLAY-RATE WS-FORMAT-UNITS                   
           MOVE WS-AMT-NET-RATE-BC (SUB2 1)   TO WS-DISPLAY-RATE.       
           MOVE WS-DISPLAY-RATE               TO                        
                WS-IGAS-CHG-FACTOR(WS-IGAS-SUB WS-IGAS-CHG-SUB).        
           MOVE WS-NET-COMPONENT-AMT-BC(SUB2) TO                        
                WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB).          
           MOVE WS-UNITS-BILLED-BC (SUB2 1)   TO                        
A02624          WS-FORMAT-UNITS                                         
                WS-IGAS-CHG-USAGE (WS-IGAS-SUB WS-IGAS-CHG-SUB).        
A02624     INITIALIZE  WS-HOLD-DESC                                     
A02624     STRING WS-HOLD-MSG                                           
A02624            ' - '                                                 
A02624            WS-FORMAT-UNITS                                       
A02624            ' DT x $ '                                            
A02624            WS-DISPLAY-RATE                                       
A02624            DELIMITED BY SIZE                                     
A02624       INTO WS-HOLD-DESC.                                         
A02624       MOVE SPACES                      TO WS-EMB-INPUT           
A02624                                           WS-CMP-TABLE           
A02624       MOVE 141                         TO WS-EMB-LENG            
A02624       MOVE WS-HOLD-DESC                TO WS-EMB-INPUT           
A02624       PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT         
A02624       INSPECT WS-CMP-TABLE REPLACING ALL '*' BY HIGH-VALUES      
A02624       MOVE WS-CMP-TABLE                TO                        
A02624             WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB)        
T28985     ADD WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB) TO         
T28985          WS-IGAS-TOTAL-CALC (WS-IGAS-SUB).                       
           ADD 1                              TO WS-IGAS-CHG-SUB.       
      *                                                                 10900000
       1430-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10930000
       1440-GET-TRANSP-FACTOR.                                          
*                                                                       
           MOVE WS-ACCOUNT-NO-BG(SUB1)         TO  FH-ACCOUNT-NO.       
           MOVE WS-BILL-NO-BG(SUB1)            TO  FH-BILL-NO.          
           MOVE WS-CODE-UTIL-TYPE-BG(SUB1)     TO  FH-CODE-UTIL-TYPE.   
           MOVE WS-IC-NO-BG(SUB1)              TO  FH-IC-NO.            
           MOVE WS-BILL-ITEM-TIMESTMP-BG(SUB1) TO                       
                                              FH-BILL-ITEM-TIMESTMP.    
           MOVE WS-COMPONENT-ID-BC(SUB2)       TO FH-CMPNT-ID-CD.       
      *                                                                 11030000
           EXEC SQL                                                     
               SELECT FACTOR                                            
                    , BILL_UNITS                                        
A03303              , FCTR_POWER_10                                     
                 INTO :FH-FACTOR                                        
                    , :FH-BILL-UNITS                                    
                    , :FH-FCTR-POWER-10                                 
                 FROM CSS_FIXED_FCT_HIST                                
                WHERE ACCOUNT_NO          = :FH-ACCOUNT-NO              
                  AND BILL_NO             = :FH-BILL-NO                 
                  AND CODE_UTIL_TYPE      = :FH-CODE-UTIL-TYPE          
                  AND IC_NO               = :FH-IC-NO                   
                  AND BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )      
                  AND CMPNT_ID_CD         = :FH-CMPNT-ID-CD             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11040000
MFA-TR*        SELECT FACTOR                                            11050000
MFA-TR*             , BILL_UNITS                                        11060000
MFA-TR*             , FCTR_POWER_10                                             
MFA-TR*          INTO :FH-FACTOR                                        11070000
MFA-TR*             , :FH-BILL-UNITS                                    11080000
MFA-TR*             , :FH-FCTR-POWER-10                                         
MFA-TR*          FROM CSS_FIXED_FCT_HIST                                11090000
MFA-TR*         WHERE ACCOUNT_NO          = :FH-ACCOUNT-NO              11100000
MFA-TR*           AND BILL_NO             = :FH-BILL-NO                 11110000
MFA-TR*           AND CODE_UTIL_TYPE      = :FH-CODE-UTIL-TYPE          11120000
MFA-TR*           AND IC_NO               = :FH-IC-NO                   11130000
MFA-TR*           AND BILL_ITEM_TIMESTMP  = :FH-BILL-ITEM-TIMESTMP      11140000
MFA-TR*           AND CMPNT_ID_CD         = :FH-CMPNT-ID-CD             11150000
MFA-TR*    END-EXEC.                                                    11160000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             WS-DISPLAY-SQLCODE.        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN -811                                                
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                   MOVE ZEROES            TO FH-FACTOR                  
                                             FH-BILL-UNITS              
                   MOVE SPACES            TO                            
                        WS-IGAS-CHG-FACTOR(WS-IGAS-SUB WS-IGAS-CHG-SUB) 
               WHEN OTHER                                               
                   MOVE 12              TO RETURN-CODE                  
                   DISPLAY ' ** 1440-GET-TRANSP-FACTOR'                 
                   DISPLAY ' **  SCSCA183 PROCESSING ERROR'             
                   DISPLAY ' ** ERROR ON SELECT '                       
                   DISPLAY ' ** TABLE - CSS_FIXED_FCT_HIST '            
                   DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE        
                   DISPLAY ' ** KEY '                                   
                   DISPLAY ' ** ACCOUNT_NO         'FH-ACCOUNT-NO       
                   DISPLAY ' ** BILL_NO            'FH-BILL-NO          
                   DISPLAY ' ** CODE_UTIL_TYPE     'FH-CODE-UTIL-TYPE   
                   DISPLAY ' ** IC_NO              'FH-IC-NO            
                   DISPLAY ' ** BILL_ITEM_TIMESTMP '                    
                                                FH-BILL-ITEM-TIMESTMP   
                   DISPLAY ' ** CMPNT_ID_CD        'FH-CMPNT-ID-CD      
                   PERFORM 9999-BAIL-OUT  THRU 9999-EXIT                
           END-EVALUATE.                                                
      *                                                                 11450000
       1440-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11480000
      *************************************************************     11490000
      *THIS ROUTINE IS TO GET THE DETAILS TO PRINT FOR COMPETITIVE*     11500000
      *PRICING AND ALSO FOR EMERGENCY GAS.                        *     11510000
      *************************************************************     11520000
      *                                                                 11530000
       1450-GET-COMP-EMER-DATA.                                         
           PERFORM 1440-GET-TRANSP-FACTOR        THRU 1440-EXIT.        
           EVALUATE WS-COMPONENT-ID-BC(SUB2)                            
               WHEN '15'                                                
                   MOVE 'Competitive'       TO WS-HOLD-COMP-EMER-DESC   
                   PERFORM 1460-LOAD-COMPETITIVE THRU 1460-EXIT         
               WHEN '51'                                                
                   MOVE 'Emergency Gas'     TO WS-HOLD-COMP-EMER-DESC   
                   PERFORM 1465-LOAD-EMER-GAS    THRU 1465-EXIT         
           END-EVALUATE.                                                
      *                                                                 11710000
       1450-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11740000
       1460-LOAD-COMPETITIVE.                                           
A02624     INITIALIZE  WS-HOLD-DESC.                                    
           SET WS-FH-HIST-INDX TO 1.                                    
           PERFORM VARYING WS-FH-HIST-INDX FROM 1 BY 1 UNTIL            
SCA006      WS-FH-HIST-INDX > 200 OR 
            WS-ACCOUNT-NO-FH(WS-FH-HIST-INDX) = ZERO                            
             IF WS-ACCOUNT-NO-BC(SUB2) =                                
                WS-ACCOUNT-NO-FH(WS-FH-HIST-INDX) AND                   
                WS-BILL-NO-BC(SUB2) =                                   
                WS-BILL-NO-FH(WS-FH-HIST-INDX) AND                      
                WS-CODE-UTIL-TYPE-BC(SUB2) =                            
                WS-CODE-UTIL-TYPE-FH(WS-FH-HIST-INDX) AND               
                WS-IC-NO-BC(SUB2) =                                     
                WS-IC-NO-FH(WS-FH-HIST-INDX) AND                        
                WS-BILL-ITEM-TIMESTMP-BC(SUB2) =                        
                WS-BILL-ITEM-TIMESTMP-FH(WS-FH-HIST-INDX) AND           
                WS-FACTOR-ID-FH(WS-FH-HIST-INDX) = 'COMPPRICE'          
                  INITIALIZE WS-FACTOR-COMP                             
A02624                       WS-HOLD-DESC                               
                  MOVE WS-BILL-UNITS-FH(WS-FH-HIST-INDX) TO             
                       WS-IGAS-CHG-USAGE (WS-IGAS-SUB WS-IGAS-CHG-SUB)  
A02624                 WS-FORMAT-UNITS                                  
                  MOVE WS-DT                     TO                     
                       WS-IGAS-CHG-UNIT (WS-IGAS-SUB WS-IGAS-CHG-SUB)   
A03303            IF WS-FCTR-POWER-10-FH(WS-FH-HIST-INDX) = 0           
A03303               MOVE WS-FACTOR-FH(WS-FH-HIST-INDX) TO              
A03303                    WS-HOLD-FACTOR                                
A03303            ELSE                                                  
A03303               MOVE WS-LONG-FACTOR-FH(WS-FH-HIST-INDX) TO         
A03303                    WS-HOLD-FACTOR                                
A03303            END-IF                                                
                  MOVE WS-HOLD-FACTOR                TO                 
                       WS-DISP-FACTOR                                   
                  MOVE WS-DISP-FACTOR                TO                 
                       WS-IGAS-CHG-FACTOR (WS-IGAS-SUB WS-IGAS-CHG-SUB) 
A03303            IF WS-FCTR-POWER-10-FH(WS-FH-HIST-INDX) = 0           
A03303               COMPUTE WS-FACTOR-COMP ROUNDED =                   
A03303                       WS-FACTOR-COMP +                           
A03303                      (WS-FACTOR-FH(WS-FH-HIST-INDX) *            
A03303                       WS-BILL-UNITS-FH(WS-FH-HIST-INDX))         
A03303            ELSE                                                  
A03303               COMPUTE WS-FACTOR-COMP ROUNDED =                   
A03303                       WS-FACTOR-COMP +                           
A03303                      (WS-LONG-FACTOR-FH(WS-FH-HIST-INDX) *       
A03303                       WS-BILL-UNITS-FH(WS-FH-HIST-INDX))         
A03303            END-IF                                                
                  MOVE WS-FACTOR-COMP            TO                     
                       WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB)    
T28985            ADD WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB) TO  
T28985                 WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)                 
A02624            STRING WS-HOLD-COMP-EMER-DESC                         
A02624                   ' - '                                          
A02624                   WS-FORMAT-UNITS                                
A02624                   ' DT x $ '                                     
A02624                   WS-DISP-FACTOR                                 
A02624                   DELIMITED BY SIZE                              
A02624              INTO WS-HOLD-DESC                                   
A02624            MOVE SPACES                    TO WS-EMB-INPUT        
A02624                                              WS-CMP-TABLE        
A02624            MOVE 141                       TO WS-EMB-LENG         
A02624            MOVE WS-HOLD-DESC              TO WS-EMB-INPUT        
A02624            PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT    
A02624            INSPECT WS-CMP-TABLE REPLACING ALL '*' BY HIGH-VALUES 
A02624            MOVE WS-CMP-TABLE              TO                     
A02624                 WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB)    
                  ADD 1                          TO WS-IGAS-CHG-SUB     
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 12115000
       1460-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12118000
       1465-LOAD-EMER-GAS.                                              
           PERFORM VARYING WS-FH-HIST-INDX FROM 1 BY 1 UNTIL            
SCA006      WS-FH-HIST-INDX > 200 OR 
            WS-ACCOUNT-NO-FH(WS-FH-HIST-INDX) = ZERO                            
             IF WS-ACCOUNT-NO-BC(SUB2) =                                
                WS-ACCOUNT-NO-FH(WS-FH-HIST-INDX) AND                   
                WS-BILL-NO-BC(SUB2) =                                   
                WS-BILL-NO-FH(WS-FH-HIST-INDX) AND                      
                WS-CODE-UTIL-TYPE-BC(SUB2) =                            
                WS-CODE-UTIL-TYPE-FH(WS-FH-HIST-INDX) AND               
                WS-IC-NO-BC(SUB2) =                                     
                WS-IC-NO-FH(WS-FH-HIST-INDX) AND                        
                WS-BILL-ITEM-TIMESTMP-BC(SUB2) =                        
                WS-BILL-ITEM-TIMESTMP-FH(WS-FH-HIST-INDX) AND           
                WS-BILL-UNITS-FH(WS-FH-HIST-INDX) > 0 AND               
                WS-FACTOR-ID-FH(WS-FH-HIST-INDX) = '&EMERMAX'           
                  INITIALIZE WS-FACTOR-COMP                             
A02624                        WS-HOLD-DESC                              
                  MOVE WS-HOLD-COMP-EMER-DESC    TO                     
                       WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB)    
                  MOVE WS-BILL-UNITS-FH(WS-FH-HIST-INDX) TO             
                       WS-IGAS-CHG-USAGE (WS-IGAS-SUB WS-IGAS-CHG-SUB)  
A02624                 WS-FORMAT-UNITS                                  
                  MOVE WS-DT                     TO                     
                       WS-IGAS-CHG-UNIT (WS-IGAS-SUB WS-IGAS-CHG-SUB)   
A03303            IF WS-FCTR-POWER-10-FH(WS-FH-HIST-INDX) = 0           
A03303               MOVE WS-FACTOR-FH(WS-FH-HIST-INDX) TO              
A03303                    WS-HOLD-FACTOR                                
A03303            ELSE                                                  
A03303               MOVE WS-LONG-FACTOR-FH(WS-FH-HIST-INDX) TO         
A03303                    WS-HOLD-FACTOR                                
A03303            END-IF                                                
                  MOVE WS-HOLD-FACTOR                TO WS-DISP-FACTOR  
                  MOVE WS-DISP-FACTOR                TO                 
                       WS-IGAS-CHG-FACTOR (WS-IGAS-SUB WS-IGAS-CHG-SUB) 
A03303            IF WS-FCTR-POWER-10-FH(WS-FH-HIST-INDX) = 0           
A03303               COMPUTE WS-FACTOR-COMP ROUNDED =                   
A03303                       WS-FACTOR-COMP +                           
A03303                       (WS-FACTOR-FH(WS-FH-HIST-INDX) *           
A03303                        WS-BILL-UNITS-FH(WS-FH-HIST-INDX))        
A03303            ELSE                                                  
A03303               COMPUTE WS-FACTOR-COMP ROUNDED =                   
A03303                       WS-FACTOR-COMP +                           
A03303                       (WS-LONG-FACTOR-FH(WS-FH-HIST-INDX) *      
A03303                        WS-BILL-UNITS-FH(WS-FH-HIST-INDX))        
A03303            END-IF                                                
                  MOVE WS-FACTOR-COMP            TO                     
                       WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB)    
T28985            ADD WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB) TO  
T28985                 WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)                 
A02624            STRING WS-HOLD-COMP-EMER-DESC                         
A02624                   ' - '                                          
A02624                   WS-FORMAT-UNITS                                
A02624                   ' DT x $ '                                     
A02624                   WS-DISP-FACTOR                                 
A02624                   DELIMITED BY SIZE                              
A02624              INTO WS-HOLD-DESC                                   
A02624            MOVE SPACES                    TO WS-EMB-INPUT        
A02624                                              WS-CMP-TABLE        
A02624            MOVE 141                       TO WS-EMB-LENG         
A02624            MOVE WS-HOLD-DESC              TO WS-EMB-INPUT        
A02624            PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT    
A02624            INSPECT WS-CMP-TABLE REPLACING ALL '*' BY HIGH-VALUES 
A02624            MOVE WS-CMP-TABLE              TO                     
A02624                 WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB)    
                  ADD 1                          TO WS-IGAS-CHG-SUB     
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 12500000
       1465-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12530000
T29450 1475-PROCESS-PENALTY-BLKS.                                       
T29450*                                                                 12530202
T29450     INITIALIZE WS-DISPLAY-UNITS                                  
T29450                WS-PENALTY-BLK-MSG2.                              
T29450     IF PS-BLOCK-USE-OR-SVCS = 100                                
T29450        MOVE 'excess.'               TO WS-PENALTY-BLK-MSG2       
T29450     ELSE                                                         
T29450        IF WS-BLOCK-SUB = 1                                       
T29450           MOVE PS-BLOCK-USE-OR-SVCS TO WS-BLOCK-USE-OR-SVCS      
T29450                                        WS-HOLD-BLOCK-USE-OR-SVCS 
T29450           MOVE WS-HOLD-BLOCK-USE-OR-SVCS TO WS-DISPLAY-UNITS     
T29450           STRING 'first '                                        
T29450                  WS-DISPLAY-UNITS ' %'                           
T29450                  DELIMITED BY SIZE                               
T29450             INTO WS-PENALTY-BLK-MSG2                             
T29450        ELSE                                                      
T29450           COMPUTE WS-HOLD-BLOCK-USE-OR-SVCS =                    
T29450                   PS-BLOCK-USE-OR-SVCS - WS-BLOCK-USE-OR-SVCS    
T29450           MOVE WS-HOLD-BLOCK-USE-OR-SVCS  TO WS-DISPLAY-UNITS    
T29450           MOVE PS-BLOCK-USE-OR-SVCS TO WS-BLOCK-USE-OR-SVCS      
T29450           STRING 'next '                                         
T29450                  WS-DISPLAY-UNITS ' %'                           
T29450                  DELIMITED BY SIZE                               
T29450             INTO WS-PENALTY-BLK-MSG2                             
T29450        END-IF                                                    
T29450     END-IF.                                                      
T29450                                                                  
T29450     MOVE WS-UNITS-BILLED-BC (SUB2 WS-BLOCK-SUB) TO               
T29450       WS-IGAS-CHG-USAGE (WS-IGAS-SUB WS-IGAS-CHG-SUB)            
T29450       WS-FORMAT-UNITS.                                           
T29450     MOVE 'DT' TO                                                 
T29450          WS-IGAS-CHG-UNIT(WS-IGAS-SUB WS-IGAS-CHG-SUB).          
T29450     MOVE WS-AMT-NET-RATE-BC (SUB2 WS-BLOCK-SUB) TO               
T29450          WS-DISPLAY-RATE.                                        
T29450     MOVE WS-DISPLAY-RATE              TO                         
T29450         WS-IGAS-CHG-FACTOR(WS-IGAS-SUB WS-IGAS-CHG-SUB).         
T29450     MOVE WS-AMT-BLOCK-BC (SUB2 WS-BLOCK-SUB) TO                  
T29450          WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB).          
T29450     ADD WS-AMT-BLOCK-BC (SUB2 WS-BLOCK-SUB) TO                   
T29450                      WS-IGAS-TOTAL-CALC (WS-IGAS-SUB).           
T29450     MOVE SPACES                     TO WS-EMB-INPUT              
T29450                                        WS-CMP-TABLE.             
A02624     STRING                                                       
A02624         WS-PENALTY-BLK-MSG2                                      
A02624         ' - '                                                    
A02624         WS-FORMAT-UNITS                                          
A02624         ' DT x $ '                                               
A02624         WS-DISPLAY-RATE                                          
A02624         DELIMITED BY SIZE                                        
A02624      INTO WS-EMB-INPUT                                           
T29450     MOVE 141                        TO WS-EMB-LENG.              
T29450     MOVE WS-PENALTY-BLK-MESSAGE     TO WS-EMB-INPUT.             
T29450     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
T29450     MOVE WS-CMP-TABLE               TO                           
T29450               WS-IGAS-CHG-MSG(WS-IGAS-SUB WS-IGAS-CHG-SUB).      
T29450     ADD 1                           TO WS-IGAS-CHG-SUB           
T29450                                        WS-BLOCK-SUB.             
T29450     INITIALIZE WS-DISPLAY-UNITS.                                 
T29450*                                                                 12535102
T29450 1475-EXIT.                                                       
T29450     EXIT.                                                        
      *                                                                 12536002
       1510-GAS-CHGS-PRORATE.                                           
                                                                        
      ********************************                                  12560000
      *  SUM BASIC FACILITY CHARGES  *                                  12570000
      ********************************                                  12580000
                                                                        
           MOVE 1 TO SUB2.                                              
           PERFORM UNTIL SUB2 > 100 OR WS-ACCOUNT-NO-BA (SUB2) = ZEROES 
              IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BA (SUB2) AND  
                 WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BA (SUB2) AND        
                 WS-CODE-UTIL-TYPE-BG (SUB1) =                          
                             WS-CODE-UTIL-TYPE-BA (SUB2) AND            
                 WS-IC-NO-BG (SUB1) = WS-IC-NO-BA (SUB2) AND            
                 WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
                             WS-BILL-ITEM-TIMESTMP-BA (SUB2) AND        
                 WS-FACTOR-ID-BA (SUB2) = 'BFACCHRG'                    
                     COMPUTE WS-ROUNDED-BFC ROUNDED =                   
                             WS-AMT-ADJUSTMENT-BA (SUB2) * 1            
                     ADD WS-ROUNDED-BFC TO                              
                                 WS-HOLD-BASIC-FACILITY                 
               END-IF                                                   
               ADD 1 TO SUB2                                            
           END-PERFORM.                                                 
                                                                        
      ******************************************                        12780000
      *  PROCESS BILLING DETAIL RECORDS FOR IC *                        12790000
      ******************************************                        12800000
                                                                        
           MOVE 1 TO SUB2.                                              
I00177     PERFORM UNTIL SUB2 > WS-BZ-MAX-ENTRY                         
I00177                OR WS-ACCOUNT-NO-BC (SUB2) = ZEROES               
              IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BC (SUB2) AND  
                 WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BC (SUB2) AND        
                 WS-CODE-UTIL-TYPE-BG (SUB1) =                          
                             WS-CODE-UTIL-TYPE-BC (SUB2) AND            
                 WS-IC-NO-BG (SUB1) = WS-IC-NO-BC (SUB2) AND            
                 WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
                             WS-BILL-ITEM-TIMESTMP-BC (SUB2)            
                     PERFORM 1520-SUM-PRORATE-USAGE THRU 1520-EXIT      
              END-IF                                                    
              ADD 1 TO SUB2                                             
           END-PERFORM.                                                 
                                                                        
      ******************************************************            12960000
      *  DETERMINE FIRST BLANK OCCURRENCE IN CHARGES TABLE *            12970000
      ******************************************************            12980000
                                                                        
           MOVE 1 TO WS-IGAS-CHG-SUB.                                   
           PERFORM 1310-DETERMINE-CHG-SUB THRU 1310-EXIT.               
                                                                        
I00177     IF WS-HOLD-BASIC-FACILITY NOT = 0                            
I00177        MOVE 'BASIC FACILITIES CHARGE' TO                         
I00177             WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB)        
I00177        MOVE WS-HOLD-BASIC-FACILITY    TO                         
I00177             WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB)        
I00177        ADD WS-HOLD-BASIC-FACILITY     TO                         
I00177                   WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)               
I00177        ADD 1                          TO WS-IGAS-CHG-SUB         
I00177     END-IF.                                                      
I00177                                                                  
           MOVE 1 TO SUB4.                                              
           PERFORM UNTIL SUB4 > 10                                      
                         OR WS-BC-CONSUMPTION-TYPE (SUB4) = SPACES      
               PERFORM 1530-PRORATE-CALCS THRU 1530-EXIT                
               ADD +1 TO SUB4                                           
           END-PERFORM.                                                 
T36419     IF WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S'                     
              PERFORM 1320-FRANCHISE-TAX THRU 1320-EXIT                 
T36419     END-IF.                                                      
                                                                        
      *                                                                 13110000
       1510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13140000
       1520-SUM-PRORATE-USAGE.                                          
                                                                        
           MOVE 'N' TO WS-BC-TABLE-LOADED.                              
           MOVE 1 TO SUB4.                                              
           PERFORM UNTIL SUB4 > 10 OR WS-BC-TABLE-LOADED = 'Y'          
               IF WS-CONSUMPTION-TYPE-BC (SUB2) =                       
                  WS-BC-CONSUMPTION-TYPE (SUB4) AND                     
                  WS-COMPONENT-ID-BC(SUB2) = WS-BC-COMPONENT-ID (SUB4)  
                  MOVE 'Y'                       TO WS-BC-TABLE-LOADED  
                  ADD WS-NET-UNITS-BC (SUB2)     TO WS-BC-UNITS (SUB4)  
                  ADD WS-CALC-COMPONENT-AMT-BC (SUB2) TO                
                                               WS-BC-DOLLAR-AMT (SUB4)  
               ELSE                                                     
                  IF WS-BC-CONSUMPTION-TYPE (SUB4) = SPACES             
                      MOVE 'Y'                    TO WS-BC-TABLE-LOADED 
                      MOVE WS-NET-UNITS-BC (SUB2) TO WS-BC-UNITS (SUB4) 
                      MOVE WS-READ-UNITS-BC(SUB2) TO                    
                                                WS-BC-READ-UNITS (SUB4) 
                      MOVE WS-CONSUMPTION-TYPE-BC (SUB2) TO             
                                          WS-BC-CONSUMPTION-TYPE (SUB4) 
                      MOVE WS-CALC-COMPONENT-AMT-BC (SUB2) TO           
                                                WS-BC-DOLLAR-AMT (SUB4) 
                      MOVE WS-COMPONENT-ID-BC(SUB2) TO                  
                                               WS-BC-COMPONENT-ID(SUB4) 
                      MOVE WS-CODE-REVENUE-CLASS-BG(SUB1) TO            
                                         WS-BC-CODE-REVENUE-CLASS(SUB4) 
                  END-IF                                                
               END-IF                                                   
               ADD +1 TO SUB4                                           
           END-PERFORM.                                                 
                                                                        
           IF WS-BC-TABLE-LOADED = 'N'                                  
      *        YOU'VE GOT REAL PROBLEMS -- NO MATCH, NO OPENING!!       13470000
               MOVE 12                       TO RETURN-CODE             
               MOVE                                                     
               'NO MATCH/SPACE FOR PRORATED USAGE IN WS-SUM-BC-TABLE'   
                                             TO WS-MISC-MSG-TEXT        
               MOVE +52                      TO WS-MISC-MSG-LEN         
               PERFORM 9910-MISC-ERROR       THRU 9910-EXIT             
               PERFORM 9999-BAIL-OUT         THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
       1520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13590000
       1530-PRORATE-CALCS.                                              
      *                                                                 13610000
           MOVE 'DT'                         TO WS-CNSMPTN-TYPE.        
                                                                        
           IF WS-BC-CODE-REVENUE-CLASS(SUB4) = '000'                    
T29344        EVALUATE WS-BC-COMPONENT-ID(SUB4)                         
T29344            WHEN '70'                                             
A01336               MOVE 'Transportation Balance & Shrinkage'          
T29344                                         TO WS-HOLD-MSG           
T29344            WHEN '71'                                             
A01336               MOVE 'Transportation over MDQ & Shrinkage'         
T29344                                         TO WS-HOLD-MSG           
T29344            WHEN OTHER                                            
                     IF WS-BC-CONSUMPTION-TYPE (SUB4) = 'D'             
                        MOVE 'Transportation'  TO WS-HOLD-MSG           
                     ELSE                                               
A01336                  MOVE 'Transportation Demand' TO WS-HOLD-MSG     
                     END-IF                                             
T29344        END-EVALUATE                                              
           ELSE                                                         
T29344        EVALUATE WS-BC-COMPONENT-ID(SUB4)                         
T29344            WHEN '55'                                             
T29344              MOVE 'Penalty Gas'         TO WS-HOLD-MSG           
T29344            WHEN '15'                                             
T29344              MOVE 'Competitive'         TO WS-HOLD-MSG           
T29344            WHEN '51'                                             
T29344              MOVE 'Emergency Gas'       TO WS-HOLD-MSG           
T29344            WHEN OTHER                                            
T29344              IF WS-CONSUMPTION-TYPE-BC (SUB4) = 'D'              
                       MOVE 'Commodity Charge' TO WS-HOLD-MSG           
                    ELSE                                                
                       MOVE 'Demand Charge'  TO WS-HOLD-MSG             
                    END-IF                                              
T29344        END-EVALUATE                                              
           END-IF                                                       
           MOVE SPACES                       TO WS-FORMAT-MESSAGE.      
           MOVE WS-BC-READ-UNITS(SUB4)       TO WS-DISPLAY-UNITS.       
           IF WS-BC-CONSUMPTION-TYPE (SUB4) > SPACES                    
T29344         IF WS-BC-UNITS (SUB4) NOT = 0                            
                MOVE WS-BC-UNITS (SUB4)       TO WS-DISPLAY-UNITS       
                STRING WS-HOLD-MSG                                      
                       ' '                                              
                       WS-DISPLAY-UNITS                                 
                       ' '                                              
                       WS-CNSMPTN-TYPE                                  
                       DELIMITED BY SIZE                                
                  INTO WS-FORMAT-MESSAGE                                
A01336          MOVE 70                       TO WS-EMB-LENG            
                MOVE SPACES                   TO WS-EMB-INPUT           
                                                 WS-CMP-TABLE           
                MOVE WS-FORMAT-MESSAGE        TO WS-EMB-INPUT           
                PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT      
                MOVE WS-CMP-TABLE             TO                        
                     WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB)      
T29344         ELSE                                                     
T29344          MOVE WS-HOLD-MSG              TO                        
                     WS-IGAS-CHG-MSG (WS-IGAS-SUB WS-IGAS-CHG-SUB)      
T29344         END-IF                                                   
               ADD WS-BC-DOLLAR-AMT(SUB4)    TO                         
                    WS-IGAS-CHG-AMT (WS-IGAS-SUB WS-IGAS-CHG-SUB)       
               ADD WS-BC-DOLLAR-AMT(SUB4)    TO                         
                   WS-IGAS-TOTAL-CALC (WS-IGAS-SUB)                     
               MOVE ZEROS                    TO                         
                    WS-IGAS-CHG-USAGE (WS-IGAS-SUB WS-IGAS-CHG-SUB)     
               MOVE SPACES                   TO                         
                    WS-IGAS-CHG-FACTOR(WS-IGAS-SUB WS-IGAS-CHG-SUB)     
                    WS-IGAS-CHG-UNIT(WS-IGAS-SUB WS-IGAS-CHG-SUB)       
               ADD 1                         TO WS-IGAS-CHG-SUB         
           END-IF.                                                      
           IF WS-IGAS-CHG-SUB > 200                                     
               MOVE 12                       TO RETURN-CODE             
               MOVE 'OVER 200 CHARGE MESSAGES'                          
                                             TO WS-MISC-MSG-TEXT        
               MOVE +24                      TO WS-MISC-MSG-LEN         
               PERFORM 9910-MISC-ERROR       THRU 9910-EXIT             
               PERFORM 9999-BAIL-OUT         THRU 9999-EXIT             
           END-IF.                                                      
      *                                                                 14290000
       1530-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14320000
      ************************************************************      14330000
      *  3600-GET-FACTORS                                        *      14340000
      *  3610-ADJUSTMENTS                                        *      14350000
      *  3620-FORMAT-FACTORS                                     *      14360000
      *  3630-BUILD-FACTOR-TABLE                                 *      14370000
      ************************************************************      14380000
                                                                        
           EXEC SQL                                                     14400000
               INCLUDE CPD00095                                         14410000
           END-EXEC.                                                    14420000
                                                                        
      ************************************************************      14440000
      *  3700-NONE-CALC.                                         *      14450000
      ************************************************************      14460000
                                                                        
           EXEC SQL                                                     14480000
               INCLUDE CPD00097                                         14490000
           END-EXEC.                                                    14500000
                                                                        
      ************************************************************      14520000
      *  4000-ENGLISH-MONTH                                      *      14530000
      *  4010-COUNT-DAYS                                         *      14540000
      ************************************************************      14550000
                                                                        
           EXEC SQL                                                     14570000
               INCLUDE CPD00200                                         14580000
           END-EXEC.                                                    14590000
                                                                        
      ************************************************************      14610000
      *  6010-REDUCE-EMBEDDED-SPACES                             *      14620000
      ************************************************************      14630000
                                                                        
       COPY CPD00004.                                                   14650000
                                                                        
T29598************************************************************      14670000
T29598*  6500-GET-REV-DIST-DESC                                  *      14671000
T29598************************************************************      14672000
T29598                                                                  
T29598     EXEC SQL                                                     14674000
T29598         INCLUDE CPD00500                                         14675000
T29598     END-EXEC.                                                    14676000
T29598                                                                  
       7000-SEL-SVC-CAT-CD.                                             
      *                                                                 14679000
            EXEC SQL                                                    
                SELECT PRTY_SVC_CAT_CD                                  
                  INTO :Z4-PRTY-SVC-CAT-CD                              
                  FROM CSS_PRTY_SVC_CAT Z4                              
                 WHERE Z4.COMPANY_NO        = :Z4-COMPANY-NO            
                   AND Z4.CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY     
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14750000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 14780000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE SPACES               TO Z4-PRTY-SVC-CAT-CD     
               WHEN OTHER                                               
                    DISPLAY ' ** ERROR IN 7000-SEL-SVC-CAT'             
                    DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'      
                    DISPLAY ' ** ERROR ON SELECT '                      
                    DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE       
                    DISPLAY ' ** TABLE   -  CSS_PRTY_SVC_CAT '          
                    DISPLAY ' ** KEY IS  '                              
                    DISPLAY ' ** COMPANY_NO        'Z4-COMPANY-NO       
                    DISPLAY ' ** CODE_CURTAIL_PRTY 'Z4-CODE-CURTAIL-PRTY
                    PERFORM 9999-BAIL-OUT THRU 9999-EXIT                
           END-EVALUATE.                                                
      *                                                                 14950000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14980000
T29450 7100-GET-PENALTY-BLOCKS.                                         
T29450*                                                                 14982001
T29450     EXEC SQL                                                     
T29450         SELECT BLOCK_USE_OR_SVCS                                 
T29450           INTO :PS-BLOCK-USE-OR-SVCS                             
T29450           FROM CSS_PRICE_SCHED                                   
T29450          WHERE CODE_UTIL_TYPE = :PS-CODE-UTIL-TYPE               
T29450            AND RATE_PLAN_NO   = :PS-RATE-PLAN-NO                 
T29450            AND CMPNT_ID_CD    = :PS-CMPNT-ID-CD                  
T29450            AND BLOCK_NO       = :PS-BLOCK-NO                     
T29450      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T29450                                                                  
T29450     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
T29450                                           WS-DISPLAY-SQLCODE.    
T29450*                                                                 14989601
T29450     EVALUATE WS-ACTIVE-RETURN-CODE                               
T29450         WHEN SUCCESSFUL-CALL                                     
T29450         WHEN -811                                                
T29450              CONTINUE                                            
T29450         WHEN NOT-FOUND                                           
T29450              MOVE ZEROS                TO PS-BLOCK-USE-OR-SVCS   
T29450         WHEN OTHER                                               
T29450              DISPLAY ' ** ERROR IN 7100-GET-PENALTY-BLOCKS '     
T29450              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'      
T29450              DISPLAY ' ** ERROR ON SELECT '                      
T29450              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE       
T29450              DISPLAY ' ** TABLE   -  CSS_PRICE_SCHED  '          
T29450              DISPLAY ' ** KEY IS  '                              
T29450              DISPLAY ' ** CODE_UTIL_TYPE  ' PS-CODE-UTIL-TYPE    
T29450              DISPLAY ' ** RATE_PLAN_NO    ' PS-RATE-PLAN-NO      
T29450              DISPLAY ' ** CMPNT_ID_CD     ' PS-CMPNT-ID-CD       
T29450              DISPLAY ' ** BLOCK_NO        ' PS-BLOCK-NO          
T29450              PERFORM 9999-BAIL-OUT THRU 9999-EXIT                
T29450     END-EVALUATE.                                                
T29450*                                                                 14992301
T29450 7100-EXIT.                                                       
T29450     EXIT.                                                        
T29450*                                                                 14992601
T29598************************************************************      14993000
T29598*  8895-INSERT-WORK-QUEUE                                  *      15000000
T29598************************************************************      15010000
T29598                                                                  
A04860*                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860                                                                  
A04860     MOVE PROGRAM-NAME            TO WS-77-CREATED-BY.            
A04860                                                                  
A04860     MOVE SPACES TO ABEND-FUNCTION.                               
A04860                                                                  
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
T29598************************************************************      15016000
T29598*  9700-PROCESS-ABEND                                      *      15017000
T29598************************************************************      15018000
T29598                                                                  
T29598 9700-PROCESS-ABEND.                                              
T29598     DISPLAY ' 8895-INSERT-WORK-QUEUE '.                          
T29598     DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'.              
A04860     DISPLAY ' ** ERROR ON INSERT CSS_WQ_ITEMS'.                  
T29598     DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE.            
A04860     DISPLAY ' ** ACCOUNT NO = ' WS-77-ACCOUNT-NO.                
T29598     MOVE 12 TO RETURN-CODE.                                      
T29598     PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
T29598 9700-EXIT.                                                       
T29598     EXIT.                                                        
T29598                                                                  
       9910-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16                         TO RETURN-CODE            
           ELSE                                                         
              ADD 1                           TO LS-CURR-WQ-ITEM        
              SET WS-BILL-WQ-INDX             TO LS-CURR-WQ-ITEM        
              MOVE WS-MISCELLANEOUS-MESSAGE   TO                        
                        WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)   
ACT071        MOVE WS-PGRMNAME                TO                        
ACT071                  WS-CREATED-BY-WF (WS-BILL-WQ-INDX)              
           END-IF.                                                      
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-BAIL-OUT.                                                   
                                                                        
           MOVE RETURN-CODE                   TO WS-SCSCA-RETURN-CODE.  
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
