       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA181.                                        
      ***************************************************************** 00030000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00040000
      **                     PRICE WATERHOUSE                        ** 00050000
      **                                                             ** 00060000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00070000
      **                                                             ** 00080000
      ***************************************************************** 00090000
      **               P R O G R A M  S U M M A R Y                  ** 00100000
      **                                                             ** 00110000
      ** SCSCA181 FORMATS GAS RATES, METERS, AND CHARGES FOR BILL    ** 00120000
      ** PRINT.  THIS PROGRAM IS CALLED FROM PCSCA910 WHEN THE BILL  ** 00130000
      ** FORMAT CODE IS '02'.                                        ** 00140000
      **                                                             ** 00150000
      ***************************************************************** 00160000
      *                                                              ** 00170000
      *              PROGRAM  MODIFICATION  LOG                      ** 00180000
      *                                                              ** 00190000
      *    DATE     INITIALS  REASON                                 ** 00200000
      *    ----     --------  ------                                 ** 00210000
T23650*    02/01    JDW       CML 23650   ADD NEW RATES FOR FEB 2001 ** 00220000
T23696*    02/01    JDW       CML 23696   Eliminate duplicate        ** 00230000
      *                                   processing in PCSCA167 and ** 00240000
      *                                   SCSCA181.                  ** 00250000
T23798*    03/01    JDW       CML 23798   Step rates with no         ** 00260000
      *                                   consumption aren't setting ** 00270000
      *                                   the step-rate flag.        ** 00280000
T23820*    03/01    JDW       CML 23820   Add new step rates 229, 279** 00290000
      *    06/01    PB        CML 24281   Don't show tax on none-calc** 00300000
T25298*    10/01    JDW       CML 25298   Add new step rates 286, 288** 00310000
T26472*    08/02    SV        CML 26472   Bill message for estimating** 00320000
T26472*                                   two months.                ** 00330000
T28132*    01/03    ESM       CML 28132   Added code to correct      ** 00340000
T28132*                                   Customer Service Charge.   ** 00350000
T28274*    03/03    ESM       CML 28274   Added code for BFC         ** 00360000
T28274*                                   adjustments.               ** 00370000
T28734*    04/03    SV82012   CML 28734   Pull Adjustment Reasons for** 00380000
T28734*                                   for Non-calcs from DB2 Table. 00390000
T29854*    11/03    SV        CML 29854   Historical Usage Doubling  ** 00400000
T29854*                               when None Calc Adjustments Done** 00410000
T32043*    07/05    SV        CML 32043   Correct Customer service Chg* 00420000
T32043*    08/02    RV97439   CML 35152   BILL REDESIGN               * 00430000
SEBTAX*  06/2008    DB41297   Add tax logic for reconnect fees.       * 00440000
I00172*    01/09    RV97439   Meter Exchange By Itself.               * 00450000
I00177*    01/09    RV        REMOVE INDEX HARDCODING FOR BC, UM, UC,** 00460000
I00177*                       CT, EA, CL, DA, DV, AC, BZ, CP TABLES. ** 00470000
A01239*    06/09    RAJ       APPL01239   Populate Meter reading diff** 00480000
PRJ165*    09/09    DMS       Change to print percentage consumption ** 00490000
PRJ165*                       amount on the bill.                    ** 00500000
A02163*    02/19    MC95456   CHANGES TO PRINT CORRECT NET RATE AND  ** 00510000
A02163*                       CHARGES ON LINE ITEM WHEN ACCOUNT HAS  ** 00520000
A02163*                       MULTIPLE CANCEL/REBILLS                ** 00530000
P00246**   02/10    ESM       Override Revenue Month.                ** 00540000
PRJ251**   04/10    RAJ       NET METERING.                          ** 00550000
A02003**   10/10    DMS       CLEAN UP WQ GENERATION                 ** 00560000
A03268**   03/11    VIJAY     Last Block of charges is not printing  ** 00570000
A03268**                      as 'Remaining Natraul Gas Consumption  ** 00580000
A03268**                      Charge + DDDC Charge' when no of blocks** 00590000
A03268**                      are < 4 .                              ** 00600000
A03019*    06/11    DMS       APPL03019   Add BTU Factor to gas IC   ** 00610000
P00496*    05/11    RAJ       Enhancements to Industrial Billing     ** 00620000
P00496* *  10/11    SV        Enhancements to Industrial Billing     ** 00630000
A03959*    03/12    RAJ       PROJ 496 WARRANTY WORK                 ** 00640000
A03959*                       (ADDITIONAL REQUIREMENTS).             ** 00650000
A04087*    04/12    RAJ       Breakout of Transportation.            ** 00660000
P00680*    06/12    RAJ       SCANA ENERGY RETENTION & ACQUISTION.   ** 00670000
A04897*    01/14    RAJ       Remove DDC factor for percentage       ** 00680000
A04897*                       billing.                               ** 00690000
A05037*    10/14    ESM       TRANSPORTATION FEE CHANGES             ** 00700000
A05290*    08/15    SS45239   Additional AGL Passthrough charges.    ** 00701000
A05146*    10/15    DMS       ACT034 - INCREASE FACTOR TO 6 DIGITS & **         
A05146*                       SUPPRESS TRAILING ZEROS                **         
A05462**   05/16    SV95326   ACT039 - CHANGE BASIS FACTOR DEFINITION**         
A05462**                      IN BILL PRINT WORKING STORAGE.         **         
ACT003**   05/16    SV95326   FIRST MONTH CSC MISSING ON REVENUE     **         
ACT003**            A*5633    OVERRIDE BILL.                         **         
      ******End******************************************************** 00710000
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA181'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-MISC.                                                     
           05  WS-CHECK-MM                  PIC XX.                     
           05  WS-START-DATE                PIC X(10).                  
           05  WS-END-DATE                  PIC X(10).                  
           05  WS-CALC-NO-DAYS              PIC S9(9) COMP.             
           05  WS-WNA-SIGN                  PIC X.                      
COB305     05 WS-HOLD-AMT-BILL-ITEM        PIC S9(9)V99 COMP-3 VALUE 0.        
T4543      05  WS-HOLD-BASIC-FACILITY       PIC S9(9)V99 VALUE 0.       
TP8812     05  WS-HOLD-METER-NO             PIC X(9) VALUE SPACES.      
T23050     05  WS-TEMP-METER-NO             PIC X(9) VALUE SPACES.      
P00680     05  WS-FACTOR-DESC-TEMP          PIC X(120).                 
P00680     05  WS-FACTOR-DUR-REM            PIC ZZZ9 VALUE ZEROES.      
P00680     05  WS-FACTOR-FH-FOUND           PIC X(1) VALUE SPACE.       
P00680         88 FH-FOUND                  VALUE 'Y'.                  
P00680     05  WS-FACTOR-FOR-PRICE          PIC X(1) VALUE SPACE.       
P00680         88 HAS-FACTOR-FOR-PRICE      VALUE 'Y'.                  
P00680     05  WS-FACTOR-FOR-CSC            PIC X(1) VALUE SPACE.       
P00680         88 HAS-FACTOR-FOR-CSC        VALUE 'Y'.                  
SEBTAX     05 WS-NON-PREMIUM-FACTOR      PIC X(9)    VALUE SPACES.      
SEBTAX        88 NON-PREMIUM-FCTR     VALUE 'MTRORDNPR'.                
T8820      05  WS-VERSION-PRORATE           PIC X    VALUE 'N'.         
T8820      05  WS-BC-TABLE-LOADED           PIC X    VALUE 'N'.         
COB305     05 WS-NO-THERMS        PIC S9(9) COMP-3 VALUE 0.           
COB305     05 WS-HOLD-SUM-THERMS        PIC S9(9)V9(6) COMP-3 VALUE 0.      
COB305     05 WS-LONG-NO-THERMS        PIC S9(9)V9(6) COMP-3 VALUE 0.      
COB305     05 WS-LONG-NO-THERMS-SUM        PIC S9(9)V9(6) COMP-3 
COB305       VALUE 0.      
COB305     05 WS-RND-NO-THERMS        PIC S9(9) COMP-3 VALUE 0.           
SEB        05  WS-CUST-SERV-FOUND-SW        PIC X VALUE 'N'.            
SEB            88  CUST-SERV-FOUND                VALUE 'Y'.            
SEB        05  WS-GAS-CONS-FOUND-SW         PIC X VALUE 'N'.            
SEB            88  GAS-CONS-FOUND                 VALUE 'Y'.            
SEB        05  WS-PRO-FCTR-FOUND-SW         PIC X VALUE 'N'.            
SEB            88  PRO-FCTR-FOUND                 VALUE 'Y'.            
PRJ165     05  WS-PRORATE-CHGS-SW           PIC X VALUE 'N'.            
PRJ165         88  PRORATE-CHGS                   VALUE 'Y'.            
PRJ165     05  WS-DDDC-ADDED-SW             PIC X VALUE 'N'.            
PRJ165         88  DDDC-ADDED                     VALUE 'Y'.            
PRJ165         88  DDDC-NOT-ADDED                 VALUE 'N'.            
PRJ165     05  WS-FIRST-BLOCK-TYPE-SW       PIC X VALUE 'N'.            
PRJ165         88  UNIT-BLOCK                     VALUE 'Y'.            
P00246     05  WS-OVR-MATCH-FOUND-SW        PIC X(01) VALUE 'N'.        
P00246         88  OVR-MATCH-FOUND                    VALUE 'Y'.        
SEB        05  PRO-SUB                      PIC 9(3) VALUE 0.           
P00246     05  REV-OVR-SUB                  PIC 9(03) VALUE 0.          
P00246     05  WS-REV-OVR-DT                PIC 9(06).                  
P00246     05  WS-OVR-MTH-VERBIAGE.                                     
P00246         10  WS-OVR-MTH-LONG          PIC X(09).                  
P00246         10  FILLER                   PIC X(01) VALUE SPACES.     
P00246         10  FILLER                   PIC X(07) VALUE 'Charges'.  
COB305     05 WS-MSG-INDX        PIC S9(05) COMP-3 VALUE 0.         
T26472     05  WS-ESTIMATE-TWO-MONTH-FL     PIC X VALUE 'N'.            
           05  SUB2                         PIC 9(3) VALUE 0.           
           05  SUB3                         PIC 9(3) VALUE 0.           
T8820      05  SUB4                         PIC 9(3) VALUE 0.           
COB305     05 WS-BA-SUB        PIC S9(3) COMP-3 VALUE 0.           
T30187     05  WS-HOLD-NONECALC-LITERAL     PIC X(255).                 
T28734     05  WS-NC-SUB                    PIC S9(4) COMP.             
           05  WS-BLOCK-SUB                 PIC 9(3) VALUE 0.           
T13821     05  WS-ROUNDED-BFC               PIC S9(9)V99 VALUE 0.       
COB305     05 WS-HOLD-BFCADJ-AMT        PIC S9(9)V9(6) COMP-3 VALUE 0.      
SEB        05  WS-TOT-CUST-SERV-CHG         PIC S9(9)V99 VALUE 0.       
SEB        05  WS-PRORATE-AMT               PIC S9(9)V9(4).             
SEB        05  WS-TOTAL-GAS-CONS-AMT        PIC S9(9)V9(4).             
T8820      05  WS-SUM-BC-TABLE.                                         
T8820          07  WS-BC-TABLE    OCCURS 10.                            
COB305             10 WS-BC-UNITS        PIC S9(9) COMP-3 VALUE 0.       
COB305             10 WS-BC-READ-UNITS        PIC S9(9) COMP-3 VALUE 0.       
T8820              10  WS-BC-CONSUMPTION-TYPE   PIC X.                  
COB305             10 WS-BC-DOLLAR-AMT        PIC S9(9)V99 COMP-3 
COB305               VALUE 0.    
T8820              10  WS-BC-TIME-PERIOD        PIC 9.                  
COB305             10 WS-BC-RATE        PIC S9(5)V9(12) COMP-3 VALUE 0. 
           05  WS-CHARGES-MESSAGE-FIELDS.                               
PRJ165         10  WS-FORMAT-MESSAGE        PIC X(100).                 
               10  WS-FORMAT-GAS-MESSAGE.                               
                   15  WS-FORMAT-LITERAL    PIC X(13).                  
T14413             15  WS-FORMAT-UNITS      PIC -Z(8)9.                 
                   15  F                    PIC X(9) VALUE ' Therms X'. 
A05146             15  WS-FORMAT-RATES      PIC -ZZ9.9(6).              
A05146             15  WS-TEMP-RATE-DISP REDEFINES WS-FORMAT-RATES      
A05146                                      PIC X(11).                  
PRJ165             15  WS-FORMAT-BLOCKS     PIC -Z(8)9.                 
T5333          10  WS-DISPLAY-UNITS         PIC -Z(8)9.                 
T5333          10  WS-DISPLAY-UNITS-2       PIC -Z(8)9.                 
P00680         10  WS-DISPLAY-RATE          PIC -Z(4)9.9999.            
P00496         10  WS-DISPLAY-RATE-DISP     PIC S9(5)V999999.           
               10  WS-CNSMPTN-TYPE          PIC X(6).                   
               10  WS-DISPLAY-FACTOR        PIC -ZZ.9(5).               
               10  WS-DISPLAY-WNA           PIC ZZ.9(5).                
T4049          10  WS-DISPLAY-PCT           PIC -ZZ.99.                 
T4049          10  WS-COMPUTE-PCT           PIC S9(3)V99.               
PRJ165         10  WS-GAS-CONS-MSG          PIC X(31).                  
           05  WS-UNFORMAT-DATE             PIC X(10).                  
           05  WS-FORMAT-DATE.                                          
               10  WS-FORMAT-MM             PIC XX.                     
               10  F                        PIC X VALUE '/'.            
               10  WS-FORMAT-DD             PIC XX.                     
               10  F                        PIC X VALUE '/'.            
               10  WS-FORMAT-YY             PIC XX.                     
           05  WS-ENGLISH-DATE.                                         
               10  WS-ENGLISH-MM            PIC XXX.                    
               10  F                        PIC X VALUE ' '.            
               10  WS-ENGLISH-DD            PIC XX.                     
           05  WS-START-POS                 PIC S9(4) COMP.             
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  FILLER                  PIC S9(4) COMP VALUE +121.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  WS-MISC-MSG-LEN         PIC S9(4) COMP VALUE +250.   
               10  WS-MISC-MSG-TEXT        PIC X(250).                  
T10737     05  WS-DATABASE-EXCEPTION.                                   
T10737         10  FILLER                  PIC S9(4) COMP VALUE +121.   
T10737         10  FILLER                  PIC X(1)  VALUE 'N'.         
T10737         10  FILLER                  PIC X(1)  VALUE '4'.         
T10737         10  FILLER                  PIC S9(4) COMP VALUE +29.    
T10737         10  FILLER                  PIC X(30) VALUE              
T10737             'A DATABASE EXCEPTION OCCURRED'.                     
ACT039     05  WS-DDC-THERM-DESC           PIC X(18) VALUE              
ACT039                                     '+ ($  8.50 X DDDC)'.        
PRJ165     05  WS-DDC-THERM-RED REDEFINES WS-DDC-THERM-DESC.            
PRJ165         10 FILLER                   PIC X(4).                    
ACT039         10 WS-DDC-FACTOR            PIC Z(2)9.99.                
PRJ165         10 FILLER                   PIC X(8).                    
PRJ165     05  WS-TEMP-GAS-SUB             PIC S9(3) COMP-3 VALUE 0.    
PRJ165     05  WS-HOLD-UNITS-BILLED        PIC 9(9) VALUE 0.            
PRJ165     05  WS-HOLD-DESC                PIC X(100).                  
PRJ165     05  WS-DDC-COUNTER              PIC 99.                      
P00246     05  WS-HOLD-CHG-SUB             PIC S9(3) COMP-3 VALUE 0.    
A05146     05  WS-TALLY                    PIC 9(2).                    
A05146     05  WS-HOLD-RATE-DISP           PIC X(11).                   
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC  X(08) VALUE 'SCSCA181'.     
                                                                        
      *  Working storage fields for CPD00095                            02110000
       COPY CWSD0095.                                                   02120000
      *  SUPPLEMENTAL WORK QUEUE FIELDS                                 02130000
       COPY CWS0070B.                                                   02140000
      *  FIELDS FOR DB2/SQL ERROR CHECKING                              02150000
       COPY CWS00303.                                                   02160000
      *  ABEND FIELDS                                                   02170000
       COPY CWS00010.                                                   02180000
      *  FIELDS USED TO REDUCE EMBEDDED BLANKS                          02190000
PRJ165 COPY CWS00023.                                                   02200000
      *  ABEND SWITCH                                                   02210000
       COPY CWS09900.                                                   02220000
           EXEC SQL                                                     02230000
               INCLUDE SQLCA                                            02240000
           END-EXEC.                                                    02250000
           EXEC SQL                                                     02260000
               INCLUDE TBMODEL                                          02270000
           END-EXEC.                                                    02280000
T10737     EXEC SQL                                                     02290000
T10737         INCLUDE TBSPLFTR                                         02300000
T10737     END-EXEC.                                                    02310000
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
      *  BILLING EXTRACT FILE                                           02350000
      *  SPLIT CWS10000 INTO 2 COPYBOOKS                                02360000
       COPY CWS1000A.                                                   02370000
       COPY CWS1000B.                                                   02380000
      *  BILLING EXTRACT FILE                                           02390000
      *  SPLIT CWS10001 INTO 2 COPYBOOKS                                02400000
       COPY CWS1001A.                                                   02410000
       COPY CWS1001B.                                                   02420000
      *  BILLING EXTRACT FILE                                           02430000
       COPY CWS10009.                                                   02440000
       01  SUB1                         PIC 9(3).                       
       01  WS-SCSCA-RETURN-CODE         PIC S9(4) comp.                 
T14010 01  WS-FUEL-ADJ-SW               PIC X      VALUE 'N'.           
COB305 01 WS-HOLD-FUEL-ADJ-FACTOR        PIC S9(3)V9(12) comp-3 VALUE 0.        
SEB    01  WS-SCANA-FLAG                PIC X.                          
SEB    01  WS-HOLD-SUB3                 PIC 9(3).                       
P00246 01  WS-ACCT-HAS-RTOV-SW          PIC X(01).                      
      *  GAS FIELDS                                                     02520000
       COPY CWS0083A.                                                   02540000
      *  WORK QUEUE FIELDS                                              02550000
       COPY CWS0024B.                                                   02560000
T28734*  NONECALC FIELDS                                                02570000
T28734 COPY CWS00097.                                                   02580000
T30766 01  WS-CUST-SVC-CHG-FCTR-ID      PIC X(9)  VALUE SPACES.         
T23696 01  WS-STEP-RATE-FLAG            PIC X.                          
COB305 01 WS-BASE-THERM-RATE-CA195        PIC S9(3)V9(6) COMP-3 VALUE 0.        
PRJ165 01  WS-MULTIPLE-BLOCKS           PIC X VALUE 'N'.                
T35152 01  WS-DDDC-ADDER-FLAG           PIC X.                          
PRJ165 01  WS-DDDC-TABLE.                                               
PRJ165     05 DDC-CNT                        PIC S9(5) COMP-3 VALUE +0. 
PRJ165     05 WS-DDDC-TBL OCCURS 0 TO 999                               
PRJ165                    DEPENDING ON DDC-CNT                          
PRJ165                    ASCENDING KEY DDC-RATE-PLAN-NO                
PRJ165                    INDEXED BY DDC-IND.                           
PRJ165        10 DDC-RATE-PLAN-NO            PIC X(3).                  
PRJ165        10 DDC-FACTOR                  PIC S9(3)V99.              
P00496*  CSS_RATE_COMPONENT DUMPED TABLE                                02720000
P00496 COPY CWSCA925.                                                   02730000
                                                                        
       PROCEDURE DIVISION USING WS-ACCOUNT-AT                           
                                WS-MISC-BILL-INFO                       
                                WS-PREV-BILL-INFO                       
                                WS-BILLING-BG                           
                                WS-CNSMPTN-HIST-CX                      
                                WS-BILL-ADJUST-DETAIL                   
                                WS-BILL-CALC-DETAIL                     
                                WS-MTRD-ENVRNMT-TABLE-MN                
                                SUB1                                    
T28734                          WS-NONCALC-LITERALS                     
T8312                           WS-SCSCA-RETURN-CODE                    
                                LS-PCSCA100-COMM-AREA                   
                                WS-BILLING-WQ-ITEMS-WF                  
                                WS-BILLING-BI                           
                                WS-GAS-BILL-PRINT                       
T14010                          WS-FUEL-ADJ-SW                          
T14010                          WS-HOLD-FUEL-ADJ-FACTOR                 
SEB                             WS-SCANA-FLAG                           
SEB                             WS-HOLD-SUB3                            
J18384                          WS-CUST-SVC-CHG-FCTR-ID                 
T30187                          WS-BILL-ADJUSTMNT                       
T23696                          WS-STEP-RATE-FLAG                       
T35152                          WS-BASE-THERM-RATE-CA195                
I00177                          WS-DDDC-ADDER-FLAG                      
I00177                          WS-CWS1000B-MAX-TBL-LIMITS              
P00246                          WS-ACCT-HAS-RTOV-SW                     
PRJ165                          WS-MULTIPLE-BLOCKS                      
PRJ165                          WS-DDDC-TABLE                           
P00496                          WS-RATE-COMPONENT                       
P00680                          WS-FIXED-FCTR-HIST-FH.                  

SCA006        SET DDC-IND TO 1.
SCA006        SET SPCL-FACTOR-IND TO 1.
                                                                        
      ************************************************************      03060000
      *  PROGRAM IS CALLED FROM PCSCA910.  GAS RATE DATA IS      *      03070000
      *  IS FORMATTED FOR CSF.                                   *      03080000
      ************************************************************      03090000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           DISPLAY 'SCSCA181 - GAS'.                                    
TP8812     MOVE SPACES TO   WS-HOLD-METER-NO                            
T23050                      WS-TEMP-METER-NO                            
T8820      INITIALIZE       WS-SUM-BC-TABLE                             
T8820                       WS-HOLD-BASIC-FACILITY                      
P00680                      WS-HOLD-FACTOR-TABLE.                       
T28132     MOVE ZEROES   TO WS-HOLD-BFCADJ-AMT.                         
TST496     MOVE 1        TO WS-GAS-CX-SUB                               
TST496                      WS-GAS-SUB.                                 
A05037     PERFORM 0500-IDENTIFY-2PART-RATES  THRU 0500-EXIT.           
P00496     PERFORM 1100-BUILD-GAS-TABLE THRU 1100-EXIT.                 
P00496     IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                         
P00496        PERFORM 1050-FORMAT-NONE-CALC-GAS-IC THRU 1050-EXIT       
P00496     ELSE                                                         
P00496        PERFORM 1500-CHECK-FOR-PRORATE THRU 1500-EXIT             
P00496        PERFORM 1000-FORMAT-GAS-IC THRU 1000-EXIT                 
P00496        PERFORM 2000-GENERATE-MESSAGE THRU 2000-EXIT              
           END-IF.                                                      
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05037****************************************************************  03360000
A05037** SPCL-GROUP-CD IS DEFINED IN CSS_SPCL_FCTR TABLE TO GROUP       03370000
A05037** SIMILAR FACTORS.                                               03380000
A05037** SPCL-GROUP-CD = 'DD' IS FOR SPECIAL DDC FACTORS 'SPC DDC',     03390000
A05037**                      'SPCDDC1', 'SPCDDC2' ETC.                 03400000
A05037****************************************************************  03410000
A05037 0500-IDENTIFY-2PART-RATES.                                       
A05037     MOVE 1 TO WS-BA-SUB.                                         
A05037     PERFORM UNTIL WS-BA-SUB > 200 OR                             
A05037                   WS-ACCOUNT-NO-BA (WS-BA-SUB) EQUAL TO ZEROES   
A05037         IF WS-SPCL-GROUP-CD-BA(WS-BA-SUB) = 'DD'                 
A05037             COMPUTE WS-DDC-FACTOR                                
A05037                     ROUNDED = WS-FACTOR-BA (WS-BA-SUB)           
A05037             MOVE 200 TO WS-BA-SUB                                
A05037         END-IF                                                   
A05037         ADD 1 TO WS-BA-SUB                                       
A05037     END-PERFORM.                                                 
A05037 0500-EXIT.                                                       
A05037     EXIT.                                                        
A05037                                                                  
      ************************************************************      03560000
      *  THIS ROUTINE FORMATS THE RATE IC DATA.  WITHIN EACH RATE*      03570000
      *  IC HEADER WILL BE RATE METER RECORDS AND RATE CHARGES   *      03580000
      *  RECORDS.  TOTALS ARE COMPARED;  IF THEY DO NOT MATCH, A *      03590000
      *  CROSSFOOT ERROR IS GENERATED.  HISTORICAL DATA IS       *      03600000
      *  OBTAINED.                                               *      03610000
      ************************************************************      03620000
                                                                        
       1000-FORMAT-GAS-IC.                                              
                                                                        
PRJ165     MOVE 'N' TO WS-PRORATE-CHGS-SW.                              
PRJ165     MOVE 'Natural Gas Consumption Charge:'                       
PRJ165                              TO WS-GAS-CONS-MSG.                 
T21302     IF WS-VERSION-PRORATE = 'Y' OR                               
SEB           (WS-PRORATE-CD-BG (SUB1) > ' ' AND                        
T12523         (WS-NO-OF-CONS-DAYS-BG (SUB1) < 27 OR                    
T12523          WS-NO-OF-CONS-DAYS-BG (SUB1) > 34))                     
T8820          PERFORM 1510-GAS-CHGS-PRORATE THRU 1510-EXIT             
T8820      ELSE                                                         
               PERFORM 1300-GAS-CHARGES THRU 1300-EXIT
           END-IF.                 
                                                                        
P00496     MOVE SPACES TO WS-PREV-FACTOR.                               
T10737     PERFORM 3600-GET-FACTORS THRU 3600-EXIT.                     
T12827     MOVE 1 TO WS-GAS-CHG-SUB.                                    
T10737     PERFORM 1310-DETERMINE-CHG-SUB THRU 1310-EXIT.               
T10737     MOVE 1 TO WS-HOLD-FACTOR-SUB.                                
P00496     PERFORM UNTIL WS-HOLD-FACTOR-SUB > 50 OR                     
P00496          WS-HOLD-FACTOR-FLAG(WS-HOLD-FACTOR-SUB) = SPACES        
               IF WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) NOT = 0       
A04087           IF WS-HOLD-FACTOR-ID (WS-HOLD-FACTOR-SUB)              
A04087                                  = 'SPCDDC1'                     
PRJ165                 PERFORM 2760-ADD-DDDC-CHRGS THRU 2760-EXIT       
PRJ165           ELSE                                                   
P00680*******Insert blank line after printing all bolded factors.       03890000
P00680             IF WS-HOLD-FACTOR-SUB > 1                            
P00680                IF  WS-HOLD-FACTOR-HDR (WS-HOLD-FACTOR-SUB) = 'N' 
P00680                 AND WS-HOLD-FACTOR-HDR (WS-HOLD-FACTOR-SUB - 1)  
P00680                                                             = 'Y'
P00680                     MOVE 'N' TO WS-GAS-CHG-HDR-ROW               
P00680                                    (WS-GAS-SUB WS-GAS-CHG-SUB)   
P00680                   ADD 1 TO WS-GAS-CHG-SUB                        
P00680                END-IF                                            
P00680             END-IF                                               
P00680             MOVE WS-HOLD-FACTOR-HDR  (WS-HOLD-FACTOR-SUB) TO     
P00680                  WS-GAS-CHG-HDR-ROW (WS-GAS-SUB WS-GAS-CHG-SUB)  
T10737             MOVE WS-HOLD-FACTOR-DESC (WS-HOLD-FACTOR-SUB) TO     
T10737                  WS-GAS-CHG-MSG (WS-GAS-SUB WS-GAS-CHG-SUB)      
T10737             MOVE WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO      
T10737                  WS-GAS-CHG-AMT (WS-GAS-SUB WS-GAS-CHG-SUB)      
SEBTAX             MOVE WS-HOLD-FACTOR-ID (WS-HOLD-FACTOR-SUB) TO       
SEBTAX                  WS-NON-PREMIUM-FACTOR                           
SEBTAX             IF NON-PREMIUM-FCTR                                  
SEBTAX                MOVE 'Y' TO                                       
SEBTAX                  WS-NON-PREMIUM-FLAG(WS-GAS-SUB WS-GAS-CHG-SUB)  
SEBTAX             ELSE                                                 
SEBTAX                MOVE 'N' TO                                       
SEBTAX                  WS-NON-PREMIUM-FLAG(WS-GAS-SUB WS-GAS-CHG-SUB)  
SEBTAX             END-IF                                               
T10737             ADD WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO       
T10737                 WS-GAS-TOTAL-CALC (WS-GAS-SUB)                   
T10737             ADD 1 TO WS-GAS-CHG-SUB                              
               END-IF                                                   
PRJ165      END-IF                                                      
T10737             ADD 1 TO WS-HOLD-FACTOR-SUB                          
T10737     END-PERFORM.                                                 
                                                                        
T12681     IF WS-REPLACE-FACTOR-ID > SPACES                             
T12681         PERFORM VARYING WS-GAS-CHG-SUB FROM 1 BY 1 UNTIL         
T12681                 WS-GAS-CHG-SUB > 200 OR                          
T12681                 WS-GAS-CHG-MSG                                   
T12681                    (WS-GAS-SUB WS-GAS-CHG-SUB) <= SPACES         
T12681             SUBTRACT WS-GAS-CHG-AMT                              
T12681                     (WS-GAS-SUB WS-GAS-CHG-SUB) FROM             
T12681                      WS-GAS-TOTAL-CALC (WS-GAS-SUB)              
T12681             MOVE 0.00 TO                                         
T12681                  WS-GAS-CHG-AMT                                  
T12681                    (WS-GAS-SUB WS-GAS-CHG-SUB)                   
T12681             MOVE SPACES TO                                       
T12681                  WS-GAS-CHG-MSG (WS-GAS-SUB WS-GAS-CHG-SUB)      
P00680                  WS-GAS-CHG-HDR-ROW (WS-GAS-SUB WS-GAS-CHG-SUB)  
T12681         END-PERFORM                                              
T12681         MOVE WS-REPLACE-FACTOR-AMT TO                            
T12681              WS-GAS-CHG-AMT (WS-GAS-SUB 1)                       
T12681         ADD WS-REPLACE-FACTOR-AMT TO                             
T12681              WS-GAS-TOTAL-CALC (WS-GAS-SUB)                      
                                                                        
           IF WS-GAS-TOTAL (WS-GAS-SUB) NOT =                           
              WS-GAS-TOTAL-CALC (WS-GAS-SUB)                            
                    MOVE 'C' TO WS-BILL-DEST-CODE                       
                    MOVE 'X' TO WS-SYSTEM-CNTRL-CODE                    
           END-IF
           END-IF.                                                      
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00496************************************************************      04500000
P00496*  THIS ROUTINE FORMATS THE RATE IC DATA FOR NONE-CALC.    *      04510000
P00496************************************************************      04520000
P00496                                                                  
P00496 1050-FORMAT-NONE-CALC-GAS-IC.                                    
                                                                        
           PERFORM 3700-NONE-CALC THRU 3700-EXIT.                       
           MOVE 1 TO WS-GAS-CHG-SUB.                                    
           PERFORM 1310-DETERMINE-CHG-SUB THRU 1310-EXIT.               
P00680     MOVE 'N' TO WS-GAS-CHG-HDR-ROW (WS-GAS-SUB WS-GAS-CHG-SUB).  
           MOVE WS-HOLD-NONECALC-LITERAL TO                             
           WS-GAS-CHG-MSG (WS-GAS-SUB WS-GAS-CHG-SUB).                  
           IF WS-CODE-DR-CR-CNSMPTN-BG (SUB1) = 'C'                     
              COMPUTE WS-GAS-CHG-AMT (WS-GAS-SUB WS-GAS-CHG-SUB) =      
                      WS-AMT-BILL-ITEM-BG (SUB1) * -1                   
           ELSE                                                         
               MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO                       
                    WS-GAS-CHG-AMT (WS-GAS-SUB WS-GAS-CHG-SUB)          
           END-IF.                                                      
           ADD WS-GAS-CHG-AMT (WS-GAS-SUB WS-GAS-CHG-SUB) TO            
                   WS-GAS-TOTAL-CALC (WS-GAS-SUB).                      
                                                                        
           IF WS-GAS-TOTAL (WS-GAS-SUB) NOT =                           
              WS-GAS-TOTAL-CALC (WS-GAS-SUB)                            
                   MOVE 'C' TO WS-BILL-DEST-CODE                        
                   MOVE 'X' TO WS-SYSTEM-CNTRL-CODE                     
           END-IF.                                                      
                                                                        
P00496 1050-EXIT.                                                       
P00496     EXIT.                                                        
P00496                                                                  
      ************************************************************      04810000
      *  THIS ROUTINE BUILDS A WORKING STORAGE TABLE CONTAINING  *      04820000
      *  ALL GAS RATES.  THE SUBSCRIPT FOR THIS TABLE IS ALWAYS  *      04830000
      *  WS-GAS-SUB.                                             *      04840000
      ************************************************************      04850000
                                                                        
       1100-BUILD-GAS-TABLE.                                            
T15113                                                                  
T15113     IF WS-CODE-DR-CR-CNSMPTN-BG (SUB1) = 'C'                     
T15113        COMPUTE WS-HOLD-AMT-BILL-ITEM =                           
T15113              WS-AMT-BILL-ITEM-BG (SUB1) * -1                     
T15113     ELSE                                                         
T15113        MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO                        
T15113             WS-HOLD-AMT-BILL-ITEM                                
T15113     END-IF                                                       
           IF WS-GAS-PLAN (WS-GAS-SUB) =                                
T4601         WS-RATE-PLAN-NO-BG (SUB1) AND                             
              WS-GAS-IC-NO (WS-GAS-SUB) = WS-IC-NO-BG (SUB1)            
                  ADD WS-HOLD-AMT-BILL-ITEM      TO                     
                      WS-GAS-TOTAL (WS-GAS-SUB)                         
T15557            IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                  
T15557               COMPUTE WS-GAS-CURR-COST (WS-GAS-SUB) =            
T15557                       WS-GAS-CURR-COST (WS-GAS-SUB) +            
T15557                       WS-HOLD-AMT-BILL-ITEM                      
T15557            ELSE                                                  
T15557               COMPUTE WS-GAS-CURR-COST (WS-GAS-SUB) =            
T15557                       WS-GAS-CURR-COST (WS-GAS-SUB) +            
T15557                       WS-HOLD-AMT-BILL-ITEM      -               
T15557                       WS-AMT-STATE-TAX-BG (SUB1)                 
T15557            END-IF                                                
                  PERFORM 1110-DETERMINE-CX-SUB THRU 1110-EXIT          
                  PERFORM 1150-SUM-CURR-USAGE THRU 1150-EXIT            
                  GO TO 1100-EXIT                                       
           ELSE                                                         
               IF WS-GAS-PLAN (WS-GAS-SUB) = SPACES                     
T4601              MOVE WS-RATE-PLAN-NO-BG (SUB1) TO                    
                        WS-GAS-PLAN (WS-GAS-SUB)                        
                   MOVE WS-IC-NO-BG (SUB1) TO                           
                        WS-GAS-IC-NO (WS-GAS-SUB)                       
                   MOVE WS-RATE-DESCRIPTION-CALC (SUB1) TO              
                        WS-GAS-DESC (WS-GAS-SUB)                        
                   MOVE WS-CODE-UTIL-TYPE-BG (SUB1) TO                  
                        WS-GAS-UTIL-TYPE (WS-GAS-SUB)                   
                   MOVE WS-HOLD-AMT-BILL-ITEM      TO                   
                        WS-GAS-TOTAL (WS-GAS-SUB)                       
A03019             MOVE WS-BTU-FACTOR-BG (SUB1)    TO                   
A03019                  WS-GAS-BTU-FACTOR (WS-GAS-SUB)                  
T15557             IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                 
T15557                COMPUTE WS-GAS-CURR-COST (WS-GAS-SUB) =           
T15557                        WS-HOLD-AMT-BILL-ITEM                     
T15557             ELSE                                                 
T15557                COMPUTE WS-GAS-CURR-COST (WS-GAS-SUB) =           
T15557                      WS-HOLD-AMT-BILL-ITEM      -                
T15557                      WS-AMT-STATE-TAX-BG (SUB1)                  
T15557             END-IF                                               
                   PERFORM 1150-SUM-CURR-USAGE THRU 1150-EXIT           
                   GO TO 1100-EXIT
               END-IF
           END-IF.                                     
           ADD 1 TO WS-GAS-SUB.                                         
           IF WS-GAS-SUB > 20                                           
               MOVE 12 TO RETURN-CODE                                   
               MOVE 'OVER 20 GAS RATES' TO                              
                    WS-MISC-MSG-TEXT                                    
               MOVE +17 TO WS-MISC-MSG-LEN                              
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
               PERFORM 9999-BAIL-OUT THRU 9999-EXIT
           END-IF.                    
           GO TO 1100-BUILD-GAS-TABLE.                                  
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      05510000
      *  DETERMINE THE FIRST BLANK LINE IN THE METER TABLE.      *      05520000
      *  THIS WILL BE NECESSARY ONLY WHEN ACCUMULATING DATA FOR  *      05530000
      *  ONE IC FROM MULTIPLE BG SEGMENTS.                       *      05540000
      ************************************************************      05550000
                                                                        
       1110-DETERMINE-CX-SUB.                                           
                                                                        
           IF WS-GAS-METER (WS-GAS-SUB WS-GAS-CX-SUB) <= SPACES         
               GO TO 1110-EXIT                                          
           ELSE                                                         
               ADD 1 TO WS-GAS-CX-SUB                                   
               IF WS-GAS-CX-SUB > 200                                   
                   MOVE 12 TO RETURN-CODE                               
                   MOVE 'OVER 100 METERS' TO                            
                        WS-MISC-MSG-TEXT                                
                   MOVE +15 TO WS-MISC-MSG-LEN                          
                   PERFORM 9910-MISC-ERROR THRU 9910-EXIT               
                   PERFORM 9999-BAIL-OUT THRU 9999-EXIT                 
               END-IF                                                   
               GO TO 1110-DETERMINE-CX-SUB
           END-IF.                             
                                                                        
       1110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      05760000
      *  PROCESS ALL CONSUMPTION HISTORY RECORDS FOR THIS RATE,  *      05770000
      *  SUMMING USAGE INTO THE CORRECT WORKING STORAGE TABLE.   *      05780000
      ************************************************************      05790000
                                                                        
       1150-SUM-CURR-USAGE.                                             
                                                                        
           MOVE 1 TO SUB3.                                              
SEB        MOVE ZEROES TO WS-LONG-NO-THERMS-SUM.                        
T23050     MOVE ZEROES TO WS-HOLD-SUM-THERMS.                           
           PERFORM UNTIL SUB3 > 200 OR WS-ACCOUNT-NO-CX (SUB3) = ZEROES 
               IF WS-ACCOUNT-NO-CX (SUB3) = WS-ACCOUNT-NO-BG (SUB1) AND 
T16622            WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S' AND             
I00172            WS-PRV-MTR-READ-COMB-FLG-CX (SUB3) NOT = 'S' AND      
                  WS-BILL-NO-CX (SUB3) = WS-BILL-NO-BG (SUB1) AND       
                  WS-CODE-UTIL-TYPE-CX (SUB3) =                         
                      WS-CODE-UTIL-TYPE-BG (SUB1) AND                   
                  WS-IC-NO-CX (SUB3) = WS-IC-NO-BG (SUB1) AND           
                  WS-BILL-ITEM-TIMESTMP-CX (SUB3) =                     
                      WS-BILL-ITEM-TIMESTMP-BG (SUB1) AND               
T5333             WS-CODE-ITEM-STATUS-CX (SUB3) NOT = 'I'               
I00172             IF (WS-METER-NO-CX (SUB3) NOT = WS-HOLD-METER-NO) OR 
I00172                (WS-METER-NO-CX (SUB3) = WS-HOLD-METER-NO AND     
I00172                 WS-PRV-MTR-READ-COMB-FLG-CX (SUB3) = 'N')        
                      IF WS-DATE-READ-CX (SUB3) >                       
                         WS-GAS-DATE-READ (WS-GAS-SUB)                  
                             MOVE WS-DATE-READ-CX (SUB3) TO             
                                  WS-GAS-DATE-READ (WS-GAS-SUB)         
                             PERFORM 1210-GET-READ-TIME THRU 1210-EXIT  
                      END-IF                                            
                      MOVE WS-CODE-METER-NO-READ-CX (SUB3) TO           
                           WS-GAS-NO-READ-REASON (WS-GAS-SUB)           
T4604                 MOVE WS-CODE-METER-READ-CX (SUB3) TO              
T4604                      WS-GAS-CODE-METER-READ (WS-GAS-SUB)          
SEB                   MOVE SUB3 TO WS-HOLD-SUB3                         
                      PERFORM 1200-GAS-METER THRU 1200-EXIT             
TP8812                MOVE WS-METER-NO-CX (SUB3) TO                     
TP8812                     WS-HOLD-METER-NO                             
TP8812             ELSE                                                 
TP8812                PERFORM 1200-GAS-METER THRU 1200-EXIT             
TP8812                MOVE SPACES TO                                    
TP8812                     WS-GAS-METER                                 
TP8812                        (WS-GAS-SUB WS-GAS-CX-SUB)                
TP8812                     WS-GAS-SUPPLYING                             
TP8812                        (WS-GAS-SUB WS-GAS-CX-SUB)                
TP8812             END-IF                                               
TP8812             MOVE 'X' TO WS-GAS-CHECK                             
TP8812                     (WS-GAS-SUB WS-GAS-CX-SUB)                   
SEB                COMPUTE WS-LONG-NO-THERMS =                          
SEB                   WS-NO-UNITS-CX (SUB3) *                           
SEB                   WS-BTU-FACTOR-BG (SUB1)                           
PRJ251             IF WS-CODE-DEBIT-CREDIT-CX (SUB3) = 'C'              
PRJ251                COMPUTE WS-LONG-NO-THERMS =                       
PRJ251                        WS-LONG-NO-THERMS * -1                    
PRJ251             END-IF                                               
I00172             IF (WS-METER-NO-CX (SUB3) NOT = WS-TEMP-METER-NO) OR 
I00172                (WS-METER-NO-CX (SUB3) = WS-TEMP-METER-NO AND     
I00172                 WS-PRV-MTR-READ-COMB-FLG-CX (SUB3) = 'N')        
T23050                MOVE WS-LONG-NO-THERMS     TO                     
T23050                     WS-HOLD-SUM-THERMS                           
T23050                MOVE WS-METER-NO-CX (SUB3) TO                     
T23050                     WS-TEMP-METER-NO                             
T23050             ELSE                                                 
T23050                ADD  WS-LONG-NO-THERMS     TO                     
T23050                     WS-HOLD-SUM-THERMS                           
T23050             END-IF                                               
T21028             COMPUTE WS-RND-NO-THERMS ROUNDED =                   
T23050                     WS-HOLD-SUM-THERMS * 1                       
T23050             MOVE WS-RND-NO-THERMS TO                             
T21028                  WS-GAS-THERM-USAGE (WS-GAS-SUB WS-GAS-CX-SUB)   
SEB                ADD WS-LONG-NO-THERMS TO                             
SEB                    WS-LONG-NO-THERMS-SUM                            
T19838             ADD WS-NO-DAYS-CX (SUB3) TO                          
T19838                     WS-GAS-CURR-DAYS (WS-GAS-SUB)                
                   ADD 1 TO WS-GAS-CX-SUB                               
               END-IF                                                   
               ADD 1 TO SUB3                                            
           END-PERFORM.                                                 
SEB        COMPUTE WS-RND-NO-THERMS ROUNDED =                           
SEB                WS-LONG-NO-THERMS-SUM * 1.                           
SEB        ADD     WS-RND-NO-THERMS TO                                  
SEB                WS-GAS-CURR-USE (WS-GAS-SUB).                        
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      06620000
      *  MOVE APPROPRIATE DATA FROM CONSUMPTION HISTORY TO THE   *      06630000
      *  GAS WORKING STORAGE TABLE.  THIS PART OF THE TABLE IS   *      06640000
      *  TWO-DIMENSIONAL;  THE SUBSCRIPTS ARE WS-GAS-SUB,        *      06650000
      *  WS-GAS-CX-SUB.  DATES ARE REFORMATTED FROM CCYYMMDD TO  *      06660000
      *  MMM DD.  THE NUMBER OF DAYS BETWEEN THE BILLING PERIOD  *      06670000
      *  START AND END IS COMPUTED.  METER SUPPLYING COMES FROM  *      06680000
      *  THE METERED ENVIRONMENT SEGMENT.                        *      06690000
      ************************************************************      06700000
                                                                        
       1200-GAS-METER.                                                  
                                                                        
           MOVE WS-METER-NO-CX (SUB3) TO                                
                WS-GAS-METER (WS-GAS-SUB WS-GAS-CX-SUB).                
TP9261     MOVE WS-NO-DIALS-CX (SUB3) TO                                
TP9261          WS-GAS-NO-DIALS (WS-GAS-SUB WS-GAS-CX-SUB).             
           MOVE WS-PREV-METER-READ-DATE-CALC (SUB3) TO                  
                WS-UNFORMAT-DATE.                                       
           MOVE SPACES TO WS-ENGLISH-DATE.                              
           MOVE WS-UNFORMAT-DATE(9:2) TO WS-ENGLISH-DD.                 
           PERFORM 4000-ENGLISH-MONTH THRU 4000-EXIT.                   
           MOVE WS-ENGLISH-DATE TO                                      
                WS-GAS-ST-DATE (WS-GAS-SUB WS-GAS-CX-SUB).              
           MOVE WS-DATE-READ-CX (SUB3) TO                               
                WS-UNFORMAT-DATE.                                       
           MOVE SPACES TO WS-ENGLISH-DATE.                              
           MOVE WS-UNFORMAT-DATE(9:2) TO WS-ENGLISH-DD.                 
           PERFORM 4000-ENGLISH-MONTH THRU 4000-EXIT.                   
           MOVE WS-ENGLISH-DATE TO                                      
                WS-GAS-END-DATE (WS-GAS-SUB WS-GAS-CX-SUB).             
           MOVE WS-PREV-METER-READ-DATE-CALC (SUB3) TO                  
                WS-START-DATE                                           
SEB             WS-GAS-ST-DATE-NUM (WS-GAS-SUB WS-GAS-CX-SUB).          
           MOVE WS-DATE-READ-CX (SUB3) TO WS-END-DATE                   
SEB             WS-GAS-END-DATE-NUM (WS-GAS-SUB WS-GAS-CX-SUB).         
           MOVE WS-NO-DAYS-CX (SUB3) TO                                 
                WS-GAS-DAYS (WS-GAS-SUB WS-GAS-CX-SUB).                 
           MOVE WS-PREV-METER-READ-CALC (SUB3) TO                       
                WS-GAS-PREV-READING (WS-GAS-SUB WS-GAS-CX-SUB).         
           MOVE WS-METER-READING-CX (SUB3) TO                           
                WS-GAS-CURR-READING (WS-GAS-SUB WS-GAS-CX-SUB).         
A01239     MOVE WS-READ-INDEX-UNITS-CX (SUB3) TO                        
A01239          WS-GAS-READING-DIFF (WS-GAS-SUB WS-GAS-CX-SUB).         
           MOVE WS-CONSTANT-CX (SUB3) TO                                
                WS-GAS-CONSTANT (WS-GAS-SUB WS-GAS-CX-SUB).             
           MOVE WS-NO-UNITS-CX (SUB3) TO                                
                WS-GAS-USAGE (WS-GAS-SUB WS-GAS-CX-SUB).                
PRJ251     IF WS-CODE-DEBIT-CREDIT-CX (SUB3) = 'C'                      
PRJ251        COMPUTE WS-GAS-USAGE (WS-GAS-SUB WS-GAS-CX-SUB) =         
PRJ251                WS-GAS-USAGE (WS-GAS-SUB WS-GAS-CX-SUB) * -1      
PRJ251     END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1210-GET-READ-TIME.                                              
                                                                        
           SET WS-MTRD-INDX TO 1.                                       
           SEARCH WS-MTRD-ENVRNMT-DATA                                  
               AT END                                                   
                   MOVE SPACES TO WS-GAS-TIME-READ (WS-GAS-SUB)         
               WHEN WS-ACCOUNT-NO-MN (WS-MTRD-INDX) = ZEROES            
                   MOVE SPACES TO WS-GAS-TIME-READ (WS-GAS-SUB)         
               WHEN WS-ACCOUNT-NO-MN (WS-MTRD-INDX) =                   
                    WS-ACCOUNT-NO-CX (SUB3) AND                         
                    WS-CODE-UTIL-TYPE-MN (WS-MTRD-INDX) =               
                    WS-CODE-UTIL-TYPE-CX (SUB3) AND                     
                    WS-IC-NO-MN (WS-MTRD-INDX) =                        
                    WS-IC-NO-CX (SUB3) AND                              
                    WS-MTR-REF-NO-MN (WS-MTRD-INDX) =                   
                    WS-MTR-REF-NO-CX (SUB3) AND                         
                    WS-METER-NO-MN (WS-MTRD-INDX) =                     
                    WS-METER-NO-CX (SUB3)                               
                        MOVE WS-LAST-VALID-READ-TM-MN (WS-MTRD-INDX) TO 
                             WS-GAS-TIME-READ (WS-GAS-SUB).             
                                                                        
       1210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      07410000
      *  PROCESS ALL BILL ADJUSTMENTS AND CALCULATIONS (GAS).    *      07420000
      *  BASIC FACILITY CHARGES WILL PRINT FIRST.  SAVE WNA AND  *      07430000
      *  BTU FACTORS FOR PRINTING.  FRANCHISE TAX PRINTS LAST.   *      07440000
      ************************************************************      07450000
                                                                        
       1300-GAS-CHARGES.                                                
                                                                        
SEB        MOVE ZEROES TO WS-TOTAL-GAS-CONS-AMT.                        
SEB        MOVE 'N' TO WS-GAS-CONS-FOUND-SW.                            
SEB        MOVE 1 TO PRO-SUB.                                           
P00246     MOVE 1 TO SUB2 WS-GAS-CHG-SUB WS-HOLD-CHG-SUB.               
PRJ165     PERFORM 1310-DETERMINE-CHG-SUB THRU 1310-EXIT.               
P00246     MOVE WS-GAS-CHG-SUB TO WS-HOLD-CHG-SUB.                      
I00177     PERFORM UNTIL SUB2 > WS-BZ-MAX-ENTRY OR                      
                         WS-ACCOUNT-NO-BC (SUB2) = ZEROES               
               IF WS-ACCOUNT-NO-BG (SUB1) =                             
                  WS-ACCOUNT-NO-BC (SUB2) AND                           
                  WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BC (SUB2) AND       
                  WS-CODE-UTIL-TYPE-BG (SUB1) =                         
                  WS-CODE-UTIL-TYPE-BC (SUB2) AND                       
                  WS-IC-NO-BG (SUB1) = WS-IC-NO-BC (SUB2) AND           
                  WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                     
                  WS-BILL-ITEM-TIMESTMP-BC (SUB2)                       
                      PERFORM 1400-GAS-CALCS THRU 1400-EXIT             
               END-IF                                                   
               ADD 1 TO SUB2                                            
           END-PERFORM.                                                 
                                                                        
SEB        MOVE 0 TO WS-TOT-CUST-SERV-CHG                               
T28132               WS-HOLD-BFCADJ-AMT                                 
SEB                  WS-HOLD-BASIC-FACILITY.                            
SEB        INITIALIZE WS-CUST-SERV-FOUND-SW.                            
ACT003     MOVE 1 TO SUB2.                                              
           PERFORM UNTIL SUB2 > 100 OR WS-ACCOUNT-NO-BA (SUB2) = ZEROES 
              IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BA (SUB2) AND  
                 WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BA (SUB2) AND        
                 WS-CODE-UTIL-TYPE-BG (SUB1) =                          
                             WS-CODE-UTIL-TYPE-BA (SUB2) AND            
                 WS-IC-NO-BG (SUB1) = WS-IC-NO-BA (SUB2) AND            
                 WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
T28132                       WS-BILL-ITEM-TIMESTMP-BA (SUB2)            
T28132           IF WS-FACTOR-ID-BA (SUB2) = 'BFACCHRG'                 
SEB                 SET CUST-SERV-FOUND TO TRUE                         
SEB                 COMPUTE WS-ROUNDED-BFC ROUNDED =                    
SEB                    WS-AMT-ADJUSTMENT-BA (SUB2) * 1                  
T28132              COMPUTE WS-ROUNDED-BFC ROUNDED =                    
T28274                 WS-ROUNDED-BFC + WS-HOLD-BFCADJ-AMT              
SEB                 ADD WS-ROUNDED-BFC TO                               
SEB                     WS-TOT-CUST-SERV-CHG                            
SEB                     WS-HOLD-BASIC-FACILITY                          
SEB                     WS-GAS-TOTAL-CALC (WS-GAS-SUB)                  
T28132           ELSE                                                   
T28132              IF (WS-FACTOR-ID-BA (SUB2) = 'BFC REFND'            
T28274              OR WS-FACTOR-ID-BA (SUB2) (1:6) = 'BFCADJ')         
T28274                 IF WS-CODE-ADJUST-TYPE-BA (SUB2) = 'H'           
T28274                    COMPUTE WS-HOLD-BFCADJ-AMT =                  
T28274                      WS-HOLD-BFCADJ-AMT +                        
T28274                     (WS-AMT-ADJUSTMENT-BA (SUB2) * -1)           
T28274                 ELSE                                             
T28274                    COMPUTE WS-HOLD-BFCADJ-AMT =                  
T28274                      WS-HOLD-BFCADJ-AMT +                        
T28274                      WS-AMT-ADJUSTMENT-BA (SUB2)                 
T28274                 END-IF                                           
J18384                 MOVE WS-FACTOR-ID-BA (SUB2) TO                   
J18384                      WS-CUST-SVC-CHG-FCTR-ID                     
T28132              END-IF                                              
T28132           END-IF                                                 
               END-IF                                                   
               ADD 1 TO SUB2                                            
           END-PERFORM.                                                 
SEB        IF CUST-SERV-FOUND AND                                       
T32043        WS-TOT-CUST-SERV-CHG NOT = 0                              
P00680        MOVE 'N' TO WS-GAS-CHG-HDR-ROW (WS-GAS-SUB WS-GAS-CHG-SUB)
SEB           MOVE 'Customer Service Charge' TO                         
SEB              WS-GAS-CHG-MSG (WS-GAS-SUB WS-GAS-CHG-SUB)             
SEB           MOVE WS-TOT-CUST-SERV-CHG TO                              
SEB              WS-GAS-CHG-AMT (WS-GAS-SUB WS-GAS-CHG-SUB)             
SEB           ADD 1 TO WS-GAS-CHG-SUB                                   
SEB        END-IF.                                                      
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      08240000
      *  DETERMINE THE FIRST BLANK LINE IN THE CHARGES TABLE.    *      08250000
      ************************************************************      08260000
                                                                        
       1310-DETERMINE-CHG-SUB.                                          
                                                                        
P00680     IF WS-GAS-CHG-HDR-ROW (WS-GAS-SUB WS-GAS-CHG-SUB) <= SPACES  
               GO TO 1310-EXIT                                          
           ELSE                                                         
               ADD 1 TO WS-GAS-CHG-SUB                                  
T14555         IF WS-GAS-CHG-SUB > 200                                  
                   MOVE 12 TO RETURN-CODE                               
T14555             MOVE 'OVER 200 CHARGES' TO                           
                        WS-MISC-MSG-TEXT                                
                   MOVE +16 TO WS-MISC-MSG-LEN                          
                   PERFORM 9910-MISC-ERROR THRU 9910-EXIT               
                   PERFORM 9999-BAIL-OUT THRU 9999-EXIT                 
               END-IF                                                   
               GO TO 1310-DETERMINE-CHG-SUB
           END-IF.                            
                                                                        
       1310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      08470000
      *  THIS ROUTINE PROCESSES ALL BLOCKS OF GAS USAGE, PRINTING*      08480000
      *  THE CORRECT MESSAGE AND SHOWING WNA USAGE WHERE         *      08490000
      *  APPLICABLE.  ALSO ONE LINE SHOWING THE CCF TO THERM     *      08500000
      *  CONVERSION PRINTS.  NOTE THAT READ-UNITS-BC CONTAINS    *      08510000
      *  USAGE AND NET-UNITS-BC CONTAINS THERMS.                 *      08520000
      ************************************************************      08530000
                                                                        
       1400-GAS-CALCS.                                                  
                                                                        
           MOVE SPACES TO WS-FORMAT-MESSAGE.                            
PRJ165     MOVE ZEROES TO WS-HOLD-UNITS-BILLED.                         
           IF WS-UNITS-BILLED-BC (SUB2 1) > 0                           
              MOVE 'N' TO WS-PRO-FCTR-FOUND-SW                          
              PERFORM UNTIL PRO-SUB > 100 OR                            
                 WS-ACCOUNT-NO-BA (PRO-SUB) = ZEROES                    
                 OR PRO-FCTR-FOUND                                      
                 IF WS-ACCOUNT-NO-BG (SUB1) =                           
                    WS-ACCOUNT-NO-BA (PRO-SUB) AND                      
                    WS-BILL-NO-BG (SUB1) =                              
                       WS-BILL-NO-BA (PRO-SUB) AND                      
                    WS-CODE-UTIL-TYPE-BG (SUB1) =                       
                       WS-CODE-UTIL-TYPE-BA (PRO-SUB) AND               
                    WS-IC-NO-BG (SUB1) =                                
                       WS-IC-NO-BA (PRO-SUB) AND                        
                    WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                   
                       WS-BILL-ITEM-TIMESTMP-BA (PRO-SUB) AND           
451                 WS-RATE-VERSION-BC (SUB2) =                         
451                    WS-FCT-RATE-VERSION-BA (PRO-SUB) AND             
                    WS-FACTOR-ID-BA (PRO-SUB) = 'RTPROPCT'              
                    SET PRO-FCTR-FOUND TO TRUE                          
                    COMPUTE WS-PRORATE-AMT =                            
                       WS-AMT-BLOCK-BC (SUB2 1) *                       
                       WS-FACTOR-BA (PRO-SUB)                           
                 END-IF                                                 
                 ADD 1 TO PRO-SUB                                       
              END-PERFORM                                               
              SET GAS-CONS-FOUND TO TRUE                                
451           MOVE 1 TO PRO-SUB                                         
              MOVE WS-UNITS-BILLED-BC (SUB2 1)                          
PRJ165           TO WS-HOLD-UNITS-BILLED                                
              IF PRO-FCTR-FOUND                                         
                 ADD WS-PRORATE-AMT TO WS-TOTAL-GAS-CONS-AMT            
              ELSE                                                      
                 ADD WS-AMT-BLOCK-BC (SUB2 1)                           
                    TO WS-TOTAL-GAS-CONS-AMT                            
              END-IF                                                    
P00246        PERFORM 1405-CHECK-FOR-REV-OVRIDE THRU 1405-EXIT          
PRJ165        PERFORM 1410-EVALUATE-TYPE THRU 1410-EXIT                 
P00246     ELSE                                                         
P00246        PERFORM 1405-CHECK-FOR-REV-OVRIDE THRU 1405-EXIT          
SEB        END-IF.                                                      
                                                                        
P00680     PERFORM 1445-CHCK-SPCL-PRT-FCTRS THRU 1445-EXIT.             
P00680                                                                  
T14555     IF WS-GAS-CHG-SUB > 200                                      
               MOVE 12 TO RETURN-CODE                                   
T14555         MOVE 'OVER 200 CHARGE MESSAGES' TO                       
                    WS-MISC-MSG-TEXT                                    
               MOVE +24 TO WS-MISC-MSG-LEN                              
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
               PERFORM 9999-BAIL-OUT THRU 9999-EXIT
           END-IF.                    
                                                                        
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00246 1405-CHECK-FOR-REV-OVRIDE.                                       
P00246     MOVE 1               TO REV-OVR-SUB.                         
P00246     MOVE 'N'             TO WS-OVR-MATCH-FOUND-SW.               
P00246     PERFORM UNTIL REV-OVR-SUB > 20                               
P00246         OR WS-ACCOUNT-NO-BP (REV-OVR-SUB) = ZEROES               
P00246         OR OVR-MATCH-FOUND                                       
P00246         IF WS-ACCOUNT-NO-BG (SUB1) =                             
P00246            WS-ACCOUNT-NO-BP (REV-OVR-SUB)                        
P00246         AND WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BP (REV-OVR-SUB)   
P00246         AND WS-CODE-UTIL-TYPE-BG (SUB1) =                        
P00246             WS-CODE-UTIL-TYPE-BP (REV-OVR-SUB)                   
P00246         AND WS-IC-NO-BG (SUB1) = WS-IC-NO-BP (REV-OVR-SUB)       
P00246         AND WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                    
P00246            WS-BILL-ITEM-TIMESTMP-BP (REV-OVR-SUB)                
P00246         AND WS-ADJ-TYPE-CD-BP (REV-OVR-SUB) = 'RTOV'             
P00246            MOVE WS-OVRRIDE-RT-REV-MTH-BP (REV-OVR-SUB) TO        
P00246                 WS-REV-OVR-DT                                    
P00246            PERFORM 1425-GET-LONG-MONTH THRU 1425-EXIT            
P00246            DISPLAY WS-OVR-MTH-VERBIAGE                           
P00246            MOVE LENGTH OF WS-OVR-MTH-VERBIAGE TO WS-EMB-LENG     
P00246            MOVE SPACES TO WS-EMB-INPUT                           
P00246                           WS-CMP-TABLE                           
P00246            MOVE WS-OVR-MTH-VERBIAGE TO WS-EMB-INPUT              
P00246            PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT    
P00246            MOVE WS-CMP-TABLE TO                                  
P00246***         MOVE WS-OVR-MTH-VERBIAGE TO                           09380000
P00246                 WS-GAS-CHG-MSG (WS-GAS-SUB WS-GAS-CHG-SUB)       
P00680            MOVE 'N' TO WS-GAS-CHG-HDR-ROW                        
P00680                        (WS-GAS-SUB WS-GAS-CHG-SUB)               
P00246            MOVE 'Y' TO WS-OVR-MATCH-FOUND-SW                     
P00246            ADD 1 TO WS-GAS-CHG-SUB                               
P00246         END-IF                                                   
P00246         ADD 1 TO REV-OVR-SUB                                     
P00246     END-PERFORM.                                                 
P00246                                                                  
P00246***  IF ((REV-OVR-SUB > 20                                        09480000
P00246***  OR WS-ACCOUNT-NO-BP (REV-OVR-SUB) = ZEROES)                  09490000
P00246     IF (WS-ACCT-HAS-RTOV-SW = 'Y'                                
P00246     AND WS-ACCOUNT-NO-BG (SUB1) NOT = ZERO                       
P00246     AND NOT OVR-MATCH-FOUND)                                     
P00246        MOVE WS-REVENUE-MONTH-BG (SUB1) TO WS-REV-OVR-DT          
P00246        PERFORM 1425-GET-LONG-MONTH THRU 1425-EXIT                
P00246        DISPLAY WS-OVR-MTH-VERBIAGE                               
P00246        MOVE LENGTH OF WS-OVR-MTH-VERBIAGE TO WS-EMB-LENG         
P00246        MOVE SPACES TO WS-EMB-INPUT                               
P00246                       WS-CMP-TABLE                               
P00246        MOVE WS-OVR-MTH-VERBIAGE TO WS-EMB-INPUT                  
P00246        PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT        
P00246        MOVE WS-CMP-TABLE TO                                      
P00246             WS-GAS-CHG-MSG (WS-GAS-SUB WS-GAS-CHG-SUB)           
P00680             MOVE 'N' TO WS-GAS-CHG-HDR-ROW                       
P00680                            (WS-GAS-SUB WS-GAS-CHG-SUB)           
P00246        ADD 1 TO WS-GAS-CHG-SUB                                   
P00246     END-IF.                                                      
P00246 1405-EXIT.                                                       
P00246     EXIT.                                                        
                                                                        
PRJ165************************************************************      09700000
PRJ165*  THIS ROUTINE PROCESSES ALL BLOCKS OF GAS USAGE AND      *      09710000
PRJ165*  CONTRUCTS THE APPROPRIATE GAS CHARGE MESSAGE BASED ON   *      09720000
PRJ165*  THE PRICE-TYPE-CD.                                      *      09730000
PRJ165************************************************************      09740000
PRJ165                                                                  
PRJ165 1410-EVALUATE-TYPE.                                              
PRJ165                                                                  
PRJ165     MOVE 'N' TO WS-MULTIPLE-BLOCKS.                              
PRJ165     MOVE 'N' TO WS-FIRST-BLOCK-TYPE-SW.                          
PRJ165     PERFORM 1420-DET-CNSMPTN-TYPE THRU 1420-EXIT.                
PRJ165     PERFORM VARYING WS-BLOCK-SUB FROM 1 BY 1 UNTIL               
PRJ165      WS-BLOCK-SUB > WS-BLOCKS-USED-BC (SUB2)                     
PRJ165        MOVE SPACES TO WS-FORMAT-MESSAGE                          
A05146                       WS-HOLD-RATE-DISP                          
A05146        MOVE 0 TO WS-TALLY                                        
PRJ165        MOVE WS-BLOCK-SIZE-BC (SUB2 WS-BLOCK-SUB)                 
PRJ165             TO WS-FORMAT-BLOCKS                                  
PRJ165        MOVE WS-UNITS-BILLED-BC (SUB2 WS-BLOCK-SUB)               
PRJ165             TO WS-FORMAT-UNITS                                   
P00496                WS-GAS-CHG-USAGE (WS-GAS-SUB WS-GAS-CHG-SUB)      
P00496        MOVE WS-CNSMPTN-TYPE                                      
P00496             TO WS-GAS-CHG-USAGE-TYPE (WS-GAS-SUB WS-GAS-CHG-SUB) 
PRJ165        MOVE WS-AMT-NET-RATE-BC (SUB2 WS-BLOCK-SUB)               
PRJ165             TO WS-FORMAT-RATES                                   
A05146** REMOVE TRAILING ZEROS FROM RATE                                09930000
A05146        MOVE FUNCTION REVERSE (WS-TEMP-RATE-DISP)                 
A05146          TO WS-HOLD-RATE-DISP                                    
A05146        INSPECT WS-HOLD-RATE-DISP                                 
A05146          TALLYING WS-TALLY FOR LEADING ZEROS                     
A05146        MOVE WS-HOLD-RATE-DISP(WS-TALLY + 1 :) TO                 
A05146          WS-TEMP-RATE-DISP                                       
A05146        MOVE FUNCTION REVERSE (WS-TEMP-RATE-DISP)                 
A05146          TO WS-TEMP-RATE-DISP                                    
PRJ165** REMOVE EXTRA SPACES FROM RATE                                  09930000
PRJ165        MOVE 12 TO WS-EMB-LENG                                    
PRJ165        MOVE SPACES TO WS-EMB-INPUT                               
PRJ165                       WS-CMP-TABLE                               
PRJ165        MOVE WS-FORMAT-RATES TO WS-EMB-INPUT                      
PRJ165        PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT        
PRJ165        MOVE WS-CMP-TABLE TO WS-FORMAT-RATES                      
PRJ165                                                                  
PRJ165        EVALUATE WS-PRICE-TYPE-CD-BC (SUB2 WS-BLOCK-SUB)          
PRJ165** PERCENT BLOCK                                                  10020000
PRJ165          WHEN 'P'                                                
PRJ165            MOVE 'Y' TO WS-MULTIPLE-BLOCKS                        
PRJ165** IF THE FIRST BLOCK FOR THIS RATES IS A UNIT BLOCK              10050000
PRJ165** THEN PRINT 'Remaining' ON THE LAST LINE INSTEAD OF             10060000
PRJ165** THE PERCENTAGE.                                                10070000
PRJ165            IF WS-BLOCK-SUB = WS-BLOCKS-USED-BC (SUB2)            
PRJ165               AND UNIT-BLOCK                                     
PRJ165               STRING 'Remaining '                                
PRJ165                       WS-GAS-CONS-MSG                            
PRJ165                       WS-FORMAT-UNITS                            
PRJ165                       ' '                                        
PRJ165                       WS-CNSMPTN-TYPE                            
PRJ165                       ' x $'                                     
PRJ165                       WS-FORMAT-RATES                            
PRJ165                       DELIMITED BY SIZE                          
PRJ165                  INTO WS-FORMAT-MESSAGE                          
PRJ165            ELSE                                                  
PRJ165               STRING WS-FORMAT-BLOCKS                            
PRJ165                      '% of '                                     
PRJ165                      WS-GAS-CONS-MSG                             
PRJ165                      WS-FORMAT-UNITS                             
PRJ165                      ' '                                         
PRJ165                      WS-CNSMPTN-TYPE                             
PRJ165                      ' x $'                                      
PRJ165                      WS-FORMAT-RATES                             
PRJ165                      DELIMITED BY SIZE                           
PRJ165                 INTO WS-FORMAT-MESSAGE                           
PRJ165            END-IF                                                
PRJ165** FIXED BLOCK                                                    10310000
PRJ165          WHEN 'F'                                                
PRJ165            MOVE 'Y' TO WS-MULTIPLE-BLOCKS                        
PRJ165            IF WS-BLOCK-SUB = 1                                   
PRJ165                STRING 'First '                                   
PRJ165                       WS-FORMAT-UNITS                            
PRJ165                       ' '                                        
PRJ165                       WS-CNSMPTN-TYPE                            
PRJ165                       ' '                                        
PRJ165                       WS-GAS-CONS-MSG                            
PRJ165                       ' '                                        
PRJ165                       WS-FORMAT-UNITS                            
PRJ165                       ' '                                        
PRJ165                       WS-CNSMPTN-TYPE                            
PRJ165                       ' x $'                                     
PRJ165                       WS-FORMAT-RATES                            
PRJ165                       DELIMITED BY SIZE                          
PRJ165                INTO WS-FORMAT-MESSAGE                            
PRJ165            ELSE                                                  
A03268                IF WS-BLOCK-SUB = WS-BLOCKS-USED-BC (SUB2)        
PRJ165                   IF WS-DDDC-ADDER-FLAG = 'Y'                    
PRJ165*****A05037         PERFORM 2750-SEARCH-DDDC-TBL THRU 2750-EXIT   10520000
PRJ165                    STRING 'Remaining '                           
PRJ165                           WS-GAS-CONS-MSG                        
PRJ165                           ' '                                    
PRJ165                           WS-FORMAT-UNITS                        
PRJ165                           ' x $'                                 
PRJ165                           WS-FORMAT-RATES                        
PRJ165                           WS-DDC-THERM-DESC                      
PRJ165                           DELIMITED BY SIZE                      
PRJ165                    INTO WS-FORMAT-MESSAGE                        
PRJ165                   ELSE                                           
PRJ165                    STRING 'Remaining '                           
PRJ165                           WS-GAS-CONS-MSG                        
PRJ165                           ' '                                    
PRJ165                           WS-FORMAT-UNITS                        
PRJ165                           ' x $'                                 
PRJ165                           WS-FORMAT-RATES                        
PRJ165                           DELIMITED BY SIZE                      
PRJ165                    INTO WS-FORMAT-MESSAGE                        
PRJ165                   END-IF                                         
PRJ165                ELSE                                              
PRJ165                    STRING 'Next '                                
PRJ165                           WS-FORMAT-UNITS                        
PRJ165                           ' '                                    
PRJ165                           WS-CNSMPTN-TYPE                        
PRJ165                           ' '                                    
PRJ165                           WS-GAS-CONS-MSG                        
PRJ165                           ' '                                    
PRJ165                           WS-FORMAT-UNITS                        
PRJ165                           ' x $'                                 
PRJ165                           WS-FORMAT-RATES                        
PRJ165                           DELIMITED BY SIZE                      
PRJ165                    INTO WS-FORMAT-MESSAGE                        
PRJ165                END-IF                                            
PRJ165            END-IF                                                
PRJ165** UNIT BLOCK                                                     10870000
PRJ165          WHEN 'U'                                                
PRJ165** PROCESSING FOR WHEN IT IS NOT A STEP RATE                      10890000
A03268           IF WS-BLOCKS-USED-BC (SUB2) = 1                        
PRJ165               MOVE WS-HOLD-UNITS-BILLED TO WS-FORMAT-UNITS       
PRJ165            IF PRORATE-CHGS                                       
PRJ165               MOVE WS-BC-DOLLAR-AMT (SUB2) TO                    
PRJ165                 WS-GAS-CHG-AMT (WS-GAS-SUB WS-GAS-CHG-SUB)       
PRJ165            ELSE                                                  
PRJ165               COMPUTE WS-GAS-CHG-AMT (WS-GAS-SUB WS-GAS-CHG-SUB) 
PRJ165                 ROUNDED = WS-TOTAL-GAS-CONS-AMT * 1              
PRJ165            END-IF                                                
PRJ165              IF WS-DDDC-ADDER-FLAG = 'Y'                         
PRJ165                   STRING WS-GAS-CONS-MSG                         
PRJ165                      WS-FORMAT-UNITS                             
PRJ165                      ' '                                         
PRJ165                      WS-CNSMPTN-TYPE                             
PRJ165                      ' '                                         
PRJ165                      DELIMITED BY SIZE                           
PRJ165                   INTO WS-FORMAT-MESSAGE                         
PRJ165              ELSE                                                
PRJ165                   STRING WS-GAS-CONS-MSG                         
PRJ165                      WS-FORMAT-UNITS                             
PRJ165                      ' '                                         
PRJ165                      WS-CNSMPTN-TYPE                             
PRJ165                      ' x $'                                      
PRJ165                      WS-FORMAT-RATES                             
PRJ165                      DELIMITED BY SIZE                           
PRJ165                   INTO WS-FORMAT-MESSAGE                         
PRJ165              END-IF                                              
PRJ165** PROCESSING FOR A STEP RATE                                     11170000
PRJ165           ELSE                                                   
PRJ165              MOVE 'Y' TO WS-MULTIPLE-BLOCKS                      
PRJ165              IF WS-BLOCK-SUB = 1                                 
PRJ165                 SET UNIT-BLOCK TO TRUE                           
PRJ165              END-IF                                              
A03268              IF WS-BLOCK-SUB = WS-BLOCKS-USED-BC (SUB2)          
PRJ165                 IF WS-DDDC-ADDER-FLAG = 'Y'                      
PRJ165*****A05037        PERFORM 2750-SEARCH-DDDC-TBL THRU 2750-EXIT    11250000
PRJ165                   STRING 'Remaining '                            
PRJ165                      WS-GAS-CONS-MSG                             
PRJ165                      ' '                                         
PRJ165                      WS-FORMAT-UNITS                             
PRJ165                      ' '                                         
PRJ165                      WS-CNSMPTN-TYPE                             
PRJ165                      ' x $'                                      
PRJ165                      WS-FORMAT-RATES                             
PRJ165                      WS-DDC-THERM-DESC                           
PRJ165                      DELIMITED BY SIZE                           
PRJ165                   INTO WS-FORMAT-MESSAGE                         
PRJ165                 ELSE                                             
PRJ165                   STRING 'Remaining '                            
PRJ165                      WS-GAS-CONS-MSG                             
PRJ165                      ' '                                         
PRJ165                      WS-FORMAT-UNITS                             
PRJ165                      ' '                                         
PRJ165                      WS-CNSMPTN-TYPE                             
PRJ165                      ' x $'                                      
PRJ165                      WS-FORMAT-RATES                             
PRJ165                      DELIMITED BY SIZE                           
PRJ165                   INTO WS-FORMAT-MESSAGE                         
PRJ165                 END-IF                                           
PRJ165              ELSE                                                
PRJ165** WHEN ONLY 1 BLOCK IS USED AND THERE IS DDDC THEN ADD           11500000
PRJ165** THE DDDC DESCRIPTION TO THE END OF THE CHARGE MESSAGE.         11510000
PRJ165               IF WS-DDDC-ADDER-FLAG = 'Y' AND                    
PRJ165                  WS-BLOCKS-USED-BC (SUB2) = 1                    
PRJ165                   STRING WS-GAS-CONS-MSG                         
PRJ165                    ' '                                           
PRJ165                    WS-FORMAT-UNITS                               
PRJ165                    ' '                                           
PRJ165                    WS-CNSMPTN-TYPE                               
PRJ165                    ' x $'                                        
PRJ165                    WS-FORMAT-RATES                               
PRJ165                    WS-DDC-THERM-DESC                             
PRJ165                    DELIMITED BY SIZE                             
PRJ165                 INTO WS-FORMAT-MESSAGE                           
PRJ165               ELSE                                               
PRJ165                 STRING WS-GAS-CONS-MSG                           
PRJ165                  ' '                                             
PRJ165                  WS-FORMAT-UNITS                                 
PRJ165                  ' '                                             
PRJ165                  WS-CNSMPTN-TYPE                                 
PRJ165                  ' x $'                                          
PRJ165                  WS-FORMAT-RATES                                 
PRJ165                  DELIMITED BY SIZE                               
PRJ165               INTO WS-FORMAT-MESSAGE                             
PRJ165               END-IF                                             
PRJ165              END-IF                                              
PRJ165           END-IF                                                 
PRJ165        END-EVALUATE                                              
PRJ165                                                                  
PRJ165        MOVE LENGTH OF WS-FORMAT-MESSAGE TO WS-EMB-LENG           
PRJ165        MOVE SPACES TO WS-EMB-INPUT                               
PRJ165                       WS-CMP-TABLE                               
PRJ165        MOVE WS-FORMAT-MESSAGE TO WS-EMB-INPUT                    
PRJ165        PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT        
PRJ165        MOVE WS-CMP-TABLE TO                                      
PRJ165           WS-GAS-CHG-MSG (WS-GAS-SUB WS-GAS-CHG-SUB)             
P00680        MOVE 'N' TO WS-GAS-CHG-HDR-ROW                            
P00680                            (WS-GAS-SUB WS-GAS-CHG-SUB)           
PRJ165        MOVE WS-AMT-BLOCK-BC (SUB2 WS-BLOCK-SUB) TO               
PRJ165           WS-GAS-CHG-AMT (WS-GAS-SUB WS-GAS-CHG-SUB)             
PRJ165        ADD WS-GAS-CHG-AMT (WS-GAS-SUB WS-GAS-CHG-SUB)            
PRJ165           TO WS-GAS-TOTAL-CALC (WS-GAS-SUB)                      
PRJ165        ADD 1 TO WS-GAS-CHG-SUB                                   
PRJ165     END-PERFORM.                                                 
PRJ165                                                                  
PRJ165 1410-EXIT.                                                       
PRJ165     EXIT.                                                        
PRJ165                                                                  
PRJ165************************************************************      11980000
PRJ165*  TRANSLATE CONSUMPTION TYPE INTO A LITERAL.              *      11990000
PRJ165************************************************************      12000000
PRJ165 1420-DET-CNSMPTN-TYPE.                                           
PRJ165                                                                  
PRJ165     EVALUATE WS-CONSUMPTION-TYPE-BC (SUB2)                       
PRJ165         WHEN 'C'                                                 
PRJ165             MOVE 'therms' TO WS-CNSMPTN-TYPE                     
PRJ165     END-EVALUATE.                                                
PRJ165                                                                  
PRJ165 1420-EXIT.                                                       
PRJ165     EXIT.                                                        
PRJ165                                                                  
P00246 1425-GET-LONG-MONTH.                                             
P00246     EVALUATE WS-REV-OVR-DT(5:2)                                  
P00246         WHEN 01                                                  
P00246             MOVE 'January  ' TO WS-OVR-MTH-LONG                  
P00246         WHEN 02                                                  
P00246             MOVE 'February ' TO WS-OVR-MTH-LONG                  
P00246         WHEN 03                                                  
P00246             MOVE 'March    ' TO WS-OVR-MTH-LONG                  
P00246         WHEN 04                                                  
P00246             MOVE 'April    ' TO WS-OVR-MTH-LONG                  
P00246         WHEN 05                                                  
P00246             MOVE 'May      ' TO WS-OVR-MTH-LONG                  
P00246         WHEN 06                                                  
P00246             MOVE 'June     ' TO WS-OVR-MTH-LONG                  
P00246         WHEN 07                                                  
P00246             MOVE 'July     ' TO WS-OVR-MTH-LONG                  
P00246         WHEN 08                                                  
P00246             MOVE 'August   ' TO WS-OVR-MTH-LONG                  
P00246         WHEN 09                                                  
P00246             MOVE 'September' TO WS-OVR-MTH-LONG                  
P00246         WHEN 10                                                  
P00246             MOVE 'October  ' TO WS-OVR-MTH-LONG                  
P00246         WHEN 11                                                  
P00246             MOVE 'November ' TO WS-OVR-MTH-LONG                  
P00246         WHEN 12                                                  
P00246             MOVE 'December ' TO WS-OVR-MTH-LONG                  
P00246         WHEN OTHER                                               
P00246             MOVE SPACES TO WS-OVR-MTH-LONG                       
P00246     END-EVALUATE.                                                
P00246 1425-EXIT.                                                       
P00246     EXIT.                                                        
                                                                        
P00680***************************************************************** 12430000
P00680***  Identify factors that need to be printed immediately after * 12440000
P00680***  its bill calc and if there is any factors that just        * 12450000
P00680***  need to be printed in bold.                                * 12460000
P00680***************************************************************** 12470000
P00680 1445-CHCK-SPCL-PRT-FCTRS.                                        
                                                                        
           INITIALIZE WS-FACTOR-FOR-PRICE                               
                      WS-FACTOR-FOR-CSC                                 
                      WS-FACTOR-DESC-TEMP                               
                      WS-FACTOR-DUR-REM                                 
                      WS-FACTOR-FH-FOUND.                               
                                                                        
           PERFORM VARYING WS-BILL-ADJ-INDX FROM 1 BY 1 UNTIL           
              WS-BILL-ADJ-INDX >  WS-BA-MAX-ENTRY OR                    
              WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX) = ZEROES              
                                                                        
              IF WS-BILLING-KEY-BA (WS-BILL-ADJ-INDX) =                 
                 WS-BILLING-KEY-BC (SUB2) AND                           
                 WS-FCT-CMPNT-ID-BA (WS-BILL-ADJ-INDX) =                
                 WS-COMPONENT-CODE-BC (SUB2) AND                        
                 WS-FCT-CNSMPT-TYPE-BA (WS-BILL-ADJ-INDX) =             
                 WS-CONSUMPTION-TYPE-BC (SUB2) AND                      
                 WS-FCT-REGISTER-TYPE-BA (WS-BILL-ADJ-INDX) =           
                 WS-REGISTER-TYPE-BC (SUB2) AND                         
                 WS-FCT-TOU-BA (WS-BILL-ADJ-INDX) =                     
                 WS-CODE-TOU-BC (SUB2) AND                              
                 WS-FCT-RATE-VERSION-BA (WS-BILL-ADJ-INDX) =            
                 WS-RATE-VERSION-BC (SUB2) AND                          
                 WS-AMT-ADJUSTMENT-BA (WS-BILL-ADJ-INDX) NOT = 0.0      
                                                                        
                 EVALUATE WS-BILL-PRT-LN-ITM-FL-BA (WS-BILL-ADJ-INDX)   
                 WHEN 'C'                                               
                     MOVE 'Y'                TO WS-FACTOR-FOR-PRICE     
                     PERFORM 1450-FORMAT-PRICE-FACTORS THRU 1450-EXIT   
                 WHEN 'D'                                               
                     MOVE 'Y'                TO WS-FACTOR-FOR-CSC       
                 WHEN OTHER                                             
                     CONTINUE                                           
                 END-EVALUATE                                           
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
      ****Blank line after printing consumption charges and price disc  12860000
      ****No Blank line if charges start with CSC                       12870000
           IF (HAS-FACTOR-FOR-PRICE OR HAS-FACTOR-FOR-CSC) AND          
                 WS-GAS-CHG-SUB NOT= 1                                  
              MOVE 'N' TO WS-GAS-CHG-HDR-ROW                            
                                         (WS-GAS-SUB WS-GAS-CHG-SUB)    
              ADD 1 TO WS-GAS-CHG-SUB                                   
            END-IF.                                                     
                                                                        
P00680 1445-EXIT.                                                       
P00680     EXIT.                                                        
                                                                        
      ************************************************************      12980000
      *  FORMAT PRICE RELATED FACTORS THAT NEED TO BE PRINTED    *      12990000
      *  IMMEDIATELY AFTER CONSUMPTION CHARGES.                  *      13000000
      ************************************************************      13010000
P00680 1450-FORMAT-PRICE-FACTORS.                                       
                                                                        
           INITIALIZE WS-FACTOR-DESC-BC-PRINT                           
                      WS-FACTOR-DESC-BC-HDR                             
                      WS-FACTOR-AMT-BC-PRINT. .                         
**********Blank line                                                    13070000
           PERFORM 3620-FORMAT-FACTORS THRU 3620-EXIT.                  
**********Description as header row                                     13090000
           MOVE WS-FACTOR-DESC-BC-HDR  TO WS-GAS-CHG-MSG                
                                          (WS-GAS-SUB WS-GAS-CHG-SUB).  
           MOVE 'Y'                    TO WS-GAS-CHG-HDR-ROW            
                                          (WS-GAS-SUB WS-GAS-CHG-SUB).  
           ADD 1                       TO WS-GAS-CHG-SUB.               
**********Details following the header row                              13150000
************* Duration of discount from FH.                             13160000
           INITIALIZE WS-FACTOR-FH-FOUND.                               
           PERFORM VARYING WS-FH-HIST-INDX FROM 1 BY 1                  
                   UNTIL FH-FOUND OR                                    
                         WS-FH-HIST-INDX > WS-FH-MAX-ENTRY OR           
                         WS-ACCOUNT-NO-FH (WS-FH-HIST-INDX) = 0         
               IF WS-FACTOR-ID-FH (WS-FH-HIST-INDX) =                   
                                      WS-FACTOR-ID-BA (WS-BILL-ADJ-INDX)
                  SET FH-FOUND         TO TRUE                          
                  MOVE WS-TOTAL-DURATION-NO-FH (WS-FH-HIST-INDX)        
                                       TO WS-FACTOR-DUR-REM             
               END-IF                                                   
           END-PERFORM.                                                 
           IF FH-FOUND                                                  
              STRING WS-FACTOR-DESC-BC-PRINT                            
                     ' for '                                            
                     WS-FACTOR-DUR-REM                                  
                     ' Months'                                          
              DELIMITED BY SIZE INTO WS-FACTOR-DESC-TEMP                
              MOVE LENGTH OF WS-FACTOR-DESC-TEMP  TO WS-EMB-LENG        
              MOVE WS-FACTOR-DESC-TEMP            TO WS-EMB-INPUT       
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT        
              MOVE WS-CMP-TABLE                   TO                    
                      WS-GAS-CHG-MSG (WS-GAS-SUB WS-GAS-CHG-SUB)        
           ELSE                                                         
              MOVE WS-FACTOR-DESC-BC-PRINT        TO                    
                         WS-GAS-CHG-MSG(WS-GAS-SUB WS-GAS-CHG-SUB)      
           END-IF.                                                      
           MOVE 'N' TO WS-GAS-CHG-HDR-ROW (WS-GAS-SUB WS-GAS-CHG-SUB).  
           MOVE WS-FACTOR-AMT-BC-PRINT            TO                    
                      WS-GAS-CHG-AMT (WS-GAS-SUB WS-GAS-CHG-SUB).       
           ADD 1                                  TO WS-GAS-CHG-SUB     
           ADD WS-FACTOR-AMT-BC-PRINT             TO                    
                   WS-GAS-TOTAL-CALC (WS-GAS-SUB).                      
                                                                        
P00680 1450-EXIT.                                                       
P00680     EXIT.                                                        
                                                                        
      ************************************************************      13540000
      *  CHECK BA FOR FACTORS INDICATING A SEASONAL OR VERSION   *      13550000
      *  PRORATION; CHECK BG FOR USAGE PRORATION.                *      13560000
      ************************************************************      13570000
T8820  1500-CHECK-FOR-PRORATE.                                          
                                                                        
T8820      MOVE 1 TO WS-GAS-SUB.                                        
T8820      IF WS-GAS-PLAN (WS-GAS-SUB) =  WS-RATE-PLAN-NO-BG (SUB1)     
T8820            AND WS-GAS-IC-NO (WS-GAS-SUB) = WS-IC-NO-BG (SUB1)     
T8820          PERFORM VARYING SUB2 FROM 1 BY 1                         
T8820            UNTIL SUB2 > 100                                       
T8820            OR WS-ACCOUNT-NO-BA (SUB2) = ZEROES                    
T8820              IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BA (SUB2) 
T8820                 AND WS-BILL-NO-BG (SUB1) =   WS-BILL-NO-BA (SUB2) 
T8820                 AND WS-CODE-UTIL-TYPE-BG (SUB1) =                 
T8820                                       WS-CODE-UTIL-TYPE-BA (SUB2) 
T8820                 AND WS-IC-NO-BG (SUB1) =       WS-IC-NO-BA (SUB2) 
T8820                 AND WS-BILL-ITEM-TIMESTMP-BG (SUB1) =             
T8820                                   WS-BILL-ITEM-TIMESTMP-BA (SUB2) 
T8820                  IF WS-FACTOR-BA (SUB2) > 0                       
T8820                       EVALUATE WS-FACTOR-ID-BA (SUB2)             
T8820                           WHEN 'RTPROPCT'                         
T8820                               MOVE 'Y' TO WS-VERSION-PRORATE      
T8820                       END-EVALUATE                                
T8820                  END-IF                                           
T8820               END-IF                                              
T8820          END-PERFORM
           END-IF.                                             
                                                                        
T8820  1500-EXIT.                                                       
T8820      EXIT.                                                        
                                                                        
T8820  1510-GAS-CHGS-PRORATE.                                           
                                                                        
T8820 ********************************                                  13870000
T8820 *  SUM BASIC FACILITY CHARGES  *                                  13880000
T8820 ********************************                                  13890000
                                                                        
T28132     MOVE ZEROES TO WS-HOLD-BFCADJ-AMT.                           
T8820      MOVE 1 TO SUB2.                                              
T8820      PERFORM UNTIL SUB2 > 100 OR WS-ACCOUNT-NO-BA (SUB2) = ZEROES 
T8820         IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BA (SUB2) AND  
T8820            WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BA (SUB2) AND        
T8820            WS-CODE-UTIL-TYPE-BG (SUB1) =                          
T8820                        WS-CODE-UTIL-TYPE-BA (SUB2) AND            
T8820            WS-IC-NO-BG (SUB1) = WS-IC-NO-BA (SUB2) AND            
T8820            WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
T8820                        WS-BILL-ITEM-TIMESTMP-BA (SUB2)            
T28132           IF WS-FACTOR-ID-BA (SUB2) = 'BFACCHRG'                 
T28132              COMPUTE WS-ROUNDED-BFC ROUNDED =                    
T28132                      WS-AMT-ADJUSTMENT-BA (SUB2) * 1             
T28132              COMPUTE WS-ROUNDED-BFC ROUNDED =                    
T28274                      WS-ROUNDED-BFC + WS-HOLD-BFCADJ-AMT         
T28132              ADD WS-ROUNDED-BFC TO                               
T28132                      WS-HOLD-BASIC-FACILITY                      
T28132           ELSE                                                   
T28132              IF (WS-FACTOR-ID-BA (SUB2) = 'BFC REFND'            
T28274              OR WS-FACTOR-ID-BA (SUB2) (1:6) = 'BFCADJ')         
T28274                 IF WS-CODE-ADJUST-TYPE-BA (SUB2) = 'H'           
T28274                    COMPUTE WS-HOLD-BFCADJ-AMT =                  
T28274                      WS-HOLD-BFCADJ-AMT +                        
T28274                     (WS-AMT-ADJUSTMENT-BA (SUB2) * -1)           
T28274                 ELSE                                             
T28274                    COMPUTE WS-HOLD-BFCADJ-AMT =                  
T28274                      WS-HOLD-BFCADJ-AMT +                        
T28274                      WS-AMT-ADJUSTMENT-BA (SUB2)                 
T28274                 END-IF                                           
T28132              END-IF                                              
T28132           END-IF                                                 
T8820         END-IF                                                    
T8820         ADD 1 TO SUB2                                             
T8820      END-PERFORM.                                                 
                                                                        
T8820 ******************************************                        14260000
T8820 *  PROCESS BILLING DETAIL RECORDS FOR IC *                        14270000
T8820 ******************************************                        14280000
                                                                        
T8820      MOVE 1 TO SUB2.                                              
I00177     PERFORM UNTIL SUB2 > WS-BZ-MAX-ENTRY                         
I00177                OR WS-ACCOUNT-NO-BC (SUB2) = ZEROES               
T8820         IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BC (SUB2) AND  
T8820            WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BC (SUB2) AND        
T8820            WS-CODE-UTIL-TYPE-BG (SUB1) =                          
T8820                        WS-CODE-UTIL-TYPE-BC (SUB2) AND            
T8820            WS-IC-NO-BG (SUB1) = WS-IC-NO-BC (SUB2) AND            
T8820            WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
T8820                        WS-BILL-ITEM-TIMESTMP-BC (SUB2)            
T8820                PERFORM 1520-SUM-PRORATE-USAGE THRU 1520-EXIT      
P00680               PERFORM 1445-CHCK-SPCL-PRT-FCTRS THRU 1445-EXIT    
T8820         END-IF                                                    
T8820         ADD 1 TO SUB2                                             
T8820      END-PERFORM.                                                 
                                                                        
T32043     IF WS-HOLD-BASIC-FACILITY NOT = 0                            
SEB           MOVE 'Customer Service Charge' TO                         
SEB                      WS-GAS-CHG-MSG (WS-GAS-SUB WS-GAS-CHG-SUB)     
P00680        MOVE 'N' TO WS-GAS-CHG-HDR-ROW                            
P00680                                  (WS-GAS-SUB WS-GAS-CHG-SUB)     
T8820         MOVE WS-HOLD-BASIC-FACILITY TO                            
T8820                    WS-GAS-CHG-AMT (WS-GAS-SUB WS-GAS-CHG-SUB)     
T8820         ADD WS-HOLD-BASIC-FACILITY TO                             
T8820                 WS-GAS-TOTAL-CALC (WS-GAS-SUB)                    
T8820         ADD 1 TO WS-GAS-CHG-SUB                                   
T32043     END-IF.                                                      
                                                                        
T14555     IF WS-GAS-CHG-SUB > 200                                      
T8820         MOVE 12 TO RETURN-CODE                                    
T14555        MOVE 'OVER 200 CHARGE MESSAGES' TO                        
T8820                                        WS-MISC-MSG-TEXT           
T8820         MOVE +24 TO WS-MISC-MSG-LEN                               
T8820         PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
T8820         PERFORM 9999-BAIL-OUT THRU 9999-EXIT                      
P00680     END-IF.                                                      
                                                                        
T8820  1510-EXIT.                                                       
T8820      EXIT.                                                        
                                                                        
T8820  1520-SUM-PRORATE-USAGE.                                          
                                                                        
T8820      MOVE 'N' TO WS-BC-TABLE-LOADED.                              
T8820      MOVE 1 TO SUB4.                                              
T8820      PERFORM UNTIL SUB4 > 10 OR WS-BC-TABLE-LOADED = 'Y'          
T8820          IF WS-CONSUMPTION-TYPE-BC (SUB2) =                       
T8820             WS-BC-CONSUMPTION-TYPE (SUB4) AND                     
T8820             WS-CODE-TOU-BC (SUB2) = WS-BC-TIME-PERIOD (SUB4)      
T8820             MOVE 'Y' TO WS-BC-TABLE-LOADED                        
T8820             ADD WS-NET-UNITS-BC (SUB2) TO WS-BC-UNITS (SUB4)      
T8820             ADD WS-CALC-COMPONENT-AMT-BC (SUB2) TO                
T8820                                      WS-BC-DOLLAR-AMT (SUB4)      
T8820          ELSE                                                     
T8820             IF WS-BC-CONSUMPTION-TYPE (SUB4) = SPACES             
T8820                 MOVE 'Y' TO WS-BC-TABLE-LOADED                    
T8820                 MOVE WS-NET-UNITS-BC (SUB2) TO WS-BC-UNITS (SUB4) 
T8820                 MOVE WS-READ-UNITS-BC (SUB2) TO                   
T8820                                           WS-BC-READ-UNITS (SUB4) 
T8820                 MOVE WS-CONSUMPTION-TYPE-BC (SUB2) TO             
T8820                                     WS-BC-CONSUMPTION-TYPE (SUB4) 
T8820                 MOVE WS-CALC-COMPONENT-AMT-BC (SUB2) TO           
T8820                                           WS-BC-DOLLAR-AMT (SUB4) 
      ************************************************************      14920000
      *  ASSUMING THAT SCSCA181 IS BASIC GAS, ONLY PRINT         *      14930000
      *  WS-CONSUMPTION-TYPE-BC NOT = C.  THIS WAY, ERRONEOUS    *      14940000
      *  CONSUMPTION TYPES DON'T GET PRINTED.                    *      14950000
      ************************************************************      14960000
T8820             END-IF                                                
T8820          END-IF                                                   
T8820          ADD +1 TO SUB4                                           
T8820      END-PERFORM.                                                 
                                                                        
T8820      IF WS-BC-TABLE-LOADED = 'N'                                  
T8820 *        YOU'VE GOT REAL PROBLEMS -- NO MATCH, NO OPENING!!       15030000
T8820          MOVE 12 TO RETURN-CODE                                   
T8820          MOVE                                                     
T8820          'NO MATCH/SPACE FOR PRORATED USAGE IN WS-SUM-BC-TABLE'   
T8820                TO WS-MISC-MSG-TEXT                                
T8820          MOVE +52 TO WS-MISC-MSG-LEN                              
T8820          PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
T8820          PERFORM 9999-BAIL-OUT THRU 9999-EXIT                     
T8820      END-IF.                                                      
                                                                        
A02163******************************************************            15130000
A02163*  DETERMINE FIRST BLANK OCCURRENCE IN CHARGES TABLE *            15140000
A02163******************************************************            15150000
                                                                        
P00246     MOVE 1 TO WS-GAS-CHG-SUB WS-HOLD-CHG-SUB.                    
A02163     PERFORM 1310-DETERMINE-CHG-SUB THRU 1310-EXIT.               
P00246     MOVE WS-GAS-CHG-SUB TO WS-HOLD-CHG-SUB.                      
                                                                        
A02163     MOVE 1 TO SUB4.                                              
A02163     PERFORM UNTIL SUB4 > 10                                      
A02163                   OR WS-BC-CONSUMPTION-TYPE (SUB4) = SPACES      
A02163         PERFORM 1530-PRORATE-CALCS THRU 1530-EXIT                
A02163         ADD +1 TO SUB4                                           
A02163     END-PERFORM.                                                 
                                                                        
T8820  1520-EXIT.                                                       
T8820      EXIT.                                                        
                                                                        
      ************************************************************      15310000
      *  THIS ROUTINE PROCESSES GAS USAGE, WITH ONE LINE SHOWING *      15320000
      *  THE CCF TO THERM CONVERSION.  NOTE THAT READ-UNITS-BC   *      15330000
      *  CONTAINS USAGE AND NET-UNITS-BC CONTAINS THERMS.        *      15340000
      ************************************************************      15350000
                                                                        
T8820  1530-PRORATE-CALCS.                                              
                                                                        
                                                                        
T8820      MOVE WS-BTU-FACTOR-BG (SUB1) TO WS-DISPLAY-FACTOR.           
A02163     MOVE WS-BC-READ-UNITS (SUB4) TO WS-DISPLAY-UNITS.            
A02163     MOVE WS-BC-UNITS (SUB4)      TO WS-HOLD-UNITS-BILLED.        
PRJ165     SET PRORATE-CHGS             TO TRUE.                        
P00246     PERFORM 1405-CHECK-FOR-REV-OVRIDE                            
P00246                                     THRU 1405-EXIT.              
A02163     IF WS-BC-UNITS (SUB4) > 0                                    
PRJ165        PERFORM 1410-EVALUATE-TYPE   THRU 1410-EXIT               
A02163     END-IF.                                                      
                                                                        
T8820  1530-EXIT.                                                       
T8820      EXIT.                                                        
                                                                        
T26472************************************************************      15530000
T26472* 2000-GENERATE-MESSAGE IS TO GENERATE A MESSAGE NO INTO   *      15540000
T26472* WS-BILL-MESSAGE-NO-CALC                                  *      15550000
T26472************************************************************      15560000
T26472*                                                                 15570000
T26472 2000-GENERATE-MESSAGE.                                           
T26472*                                                                 15590000
T26472     MOVE 'N'                       TO WS-ESTIMATE-TWO-MONTH-FL.  
T26472     PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL            
T26472      WS-BILLING-INDX > 30 OR                                     
T26472      WS-ACCOUNT-NO-BG(WS-BILLING-INDX) = ZERO                    
T26472         PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1 UNTIL        
T26472          WS-CNSMPTN-INDX > 200 OR                                
T26472          WS-ACCOUNT-NO-CX(WS-CNSMPTN-INDX) = ZERO                
T26472            IF  WS-ACCOUNT-NO-BG(WS-BILLING-INDX) =               
T26472                WS-ACCOUNT-NO-CX(WS-CNSMPTN-INDX)                 
T26472            AND WS-BILL-NO-BG(WS-BILLING-INDX) =                  
T26472                WS-BILL-NO-CX(WS-CNSMPTN-INDX)                    
T26472            AND WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) =           
T26472                WS-CODE-UTIL-TYPE-CX(WS-CNSMPTN-INDX)             
T26472            AND WS-IC-NO-BG(WS-BILLING-INDX) =                    
T26472                WS-IC-NO-CX(WS-CNSMPTN-INDX)                      
T26472            AND WS-BILL-ITEM-TIMESTMP-BG(WS-BILLING-INDX) =       
T26472                WS-BILL-ITEM-TIMESTMP-CX(WS-CNSMPTN-INDX)         
T26472            AND WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX) =           
T26472                SPACES OR LOW-VALUES                              
T26472            AND WS-REV-MTH-ORIG-BILL-BG(WS-BILLING-INDX) = ZERO   
T26472            AND WS-CODE-SOURCE-ID-CX(WS-CNSMPTN-INDX) = 'G'       
PRJ251            AND WS-PRV-MTR-READ-COMB-FLG-CX(WS-CNSMPTN-INDX)      
PRJ251                                                    NOT= 'S'      
T26472                MOVE 'Y'            TO WS-ESTIMATE-TWO-MONTH-FL   
T26472            END-IF                                                
T26472         END-PERFORM                                              
T26472     END-PERFORM.                                                 
T26472*                                                                 15870000
T26472     IF WS-ESTIMATE-TWO-MONTH-FL = 'Y'                            
T26472        PERFORM 2010-LOAD-BILL-MESSAGE  THRU 2010-EXIT            
T26472     END-IF.                                                      
T26472*                                                                 15910000
T26472 2000-EXIT.                                                       
T26472     EXIT.                                                        
T26472*                                                                 15940000
T26472 2010-LOAD-BILL-MESSAGE.                                          
T26472*                                                                 15960000
T26472     PERFORM VARYING WS-MSG-INDX FROM 1 BY 1                      
T26472       UNTIL WS-MSG-INDX > 10                                     
T26472        IF WS-BILL-MESSAGE-NO-CALC (WS-MSG-INDX) <= 0             
T26472           MOVE '95005'  TO WS-BILL-MESSAGE-NO-CALC (WS-MSG-INDX) 
T26472           MOVE 11 TO WS-MSG-INDX                                 
T26472        END-IF                                                    
T26472     END-PERFORM.                                                 
T26472*                                                                 16040000
T26472 2010-EXIT.                                                       
T26472     EXIT.                                                        
T26472                                                                  
PRJ165************************************************************      16080000
PRJ165*  SEARCH THE DDDC TABLE.                                  *      16090000
PRJ165************************************************************      16100000
PRJ165 2750-SEARCH-DDDC-TBL.                                            
PRJ165                                                                  
PRJ165     SEARCH ALL WS-DDDC-TBL                                       
PRJ165        AT END                                                    
PRJ165           DISPLAY 'NO DDDC FACTOR FOR RATE '                     
PRJ165           WS-RATE-PLAN-NO-BG (SUB1)                              
PRJ165           MOVE 8.50                TO WS-DDC-FACTOR              
PRJ165        WHEN DDC-RATE-PLAN-NO(DDC-IND) =                          
PRJ165             WS-RATE-PLAN-NO-BG (SUB1)                            
PRJ165           MOVE DDC-FACTOR(DDC-IND) TO WS-DDC-FACTOR              
PRJ165     END-SEARCH.                                                  
PRJ165                                                                  
PRJ165 2750-EXIT.                                                       
PRJ165                                                                  
PRJ165************************************************************      16250000
PRJ165*  WHEN THERE IS A DDDC CHARGE IT SHOULD BE ADDED TO THE   *      16260000
PRJ165*  CURRENT CHARGES.  IF THIS IS A STEP RATE THEN ADD THE   *      16270000
PRJ165*  DDDC CHARGE TO THE RECORD WITH 'X DDDC'.  WHEN ITS NOT  *      16280000
PRJ165*  A STEP RATE THEN ADD THE DDDC CHARGE TO THE NATURAL GAS *      16290000
PRJ165*  RECORD. IF THERE ARE NO CURRENT CHARGES THEN CREATE A   *      16300000
PRJ165*  A RECORD WITH THE DDDC CHARGES.                         *      16310000
PRJ165************************************************************      16320000
PRJ165 2760-ADD-DDDC-CHRGS.                                             
PRJ165                                                                  
PRJ165     MOVE 'N' TO WS-DDDC-ADDED-SW.                                
PRJ165**** PERFORM VARYING WS-TEMP-GAS-SUB FROM 1 BY 1 UNTIL            16360000
P00246     PERFORM VARYING WS-TEMP-GAS-SUB                              
P00246             FROM WS-HOLD-CHG-SUB BY 1 UNTIL                      
PRJ165       WS-TEMP-GAS-SUB > 200 OR                                   
P00680       WS-GAS-CHG-HDR-ROW (WS-GAS-SUB WS-TEMP-GAS-SUB) <= SPACES  
PRJ165        MOVE WS-GAS-CHG-MSG (WS-GAS-SUB WS-TEMP-GAS-SUB) TO       
PRJ165             WS-HOLD-DESC                                         
PRJ165        MOVE ZEROES TO WS-DDC-COUNTER                             
PRJ165        INSPECT WS-HOLD-DESC                                      
PRJ165            TALLYING WS-DDC-COUNTER FOR ALL 'x DDDC)'             
PRJ165        IF WS-DDC-COUNTER > 0 OR                                  
PRJ165           (WS-MULTIPLE-BLOCKS = 'N' AND                          
PRJ165            WS-HOLD-DESC (1:7) = 'Natural')                       
PRJ165           ADD WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO         
PRJ165           WS-GAS-CHG-AMT (WS-GAS-SUB WS-TEMP-GAS-SUB)            
PRJ165           SET DDDC-ADDED TO TRUE                                 
PRJ165        END-IF                                                    
PRJ165     END-PERFORM.                                                 
PRJ165     IF DDDC-NOT-ADDED                                            
PRJ165        MOVE WS-HOLD-UNITS-BILLED TO WS-FORMAT-UNITS              
PRJ165        STRING WS-GAS-CONS-MSG                                    
PRJ165           ' '                                                    
PRJ165           WS-FORMAT-UNITS                                        
PRJ165           ' therms '                                             
PRJ165           DELIMITED BY SIZE                                      
PRJ165        INTO WS-GAS-CHG-MSG (WS-GAS-SUB WS-GAS-CHG-SUB)           
P00680        MOVE 'N' TO WS-GAS-CHG-HDR-ROW                            
P00680                            (WS-GAS-SUB WS-GAS-CHG-SUB)           
PRJ165        MOVE WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO           
PRJ165             WS-GAS-CHG-AMT (WS-GAS-SUB WS-GAS-CHG-SUB)           
PRJ165        ADD WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO            
PRJ165            WS-GAS-TOTAL-CALC (WS-GAS-SUB)                        
PRJ165        ADD 1 TO WS-GAS-CHG-SUB                                   
PRJ165     END-IF.                                                      
PRJ165 2760-EXIT.                                                       
PRJ165     EXIT.                                                        
PRJ165                                                                  
T10737************************************************************      16730000
T10737*  3600-GET-FACTORS                                        *      16740000
T10737*  3610-ADJUSTMENTS                                        *      16750000
T10737*  3620-FORMAT-FACTORS                                     *      16760000
T10737*  3630-BUILD-FACTOR-TABLE                                 *      16770000
T10737************************************************************      16780000
T10737                                                                  
T10737     EXEC SQL                                                     16800000
P00496         INCLUDE CPD00095                                         16810000
T10737     END-EXEC.                                                    16820000
                                                                        
T12827************************************************************      16840000
T12827*  3700-NONE-CALC.                                         *      16850000
T12827************************************************************      16860000
T12827                                                                  
T12827     EXEC SQL                                                     16880000
T12827         INCLUDE CPD00097                                         16890000
T12827     END-EXEC.                                                    16900000
                                                                        
      ************************************************************      16920000
      *  4000-ENGLISH-MONTH                                      *      16930000
      *  4010-COUNT-DAYS                                         *      16940000
      ************************************************************      16950000
                                                                        
           EXEC SQL                                                     16970000
               INCLUDE CPD00200                                         16980000
           END-EXEC.                                                    16990000
                                                                        
      ************************************************************      17010000
      *  6010-REDUCE-EMBEDDED-SPACES                             *      17020000
      ************************************************************      17030000
                                                                        
       COPY CPD00004.                                                   17050000
                                                                        
       9910-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
           END-IF.                                                      
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-BAIL-OUT.                                                   
                                                                        
T8312      MOVE RETURN-CODE TO WS-SCSCA-RETURN-CODE.                    
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
