       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA174.                                        
      ***************************************************************** 00030000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00040000
      **                     PRICE WATERHOUSE                        ** 00050000
      **                                                             ** 00060000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00070000
      **                                                             ** 00080000
      ***************************************************************** 00090000
      **               P R O G R A M  S U M M A R Y                  ** 00100000
      **                                                             ** 00110000
      ** SCSCA174 FORMATS UNMETERED, NON-MUNICIPAL LIGHT RATES, BILL ** 00120000
      ** PERIOD, AND CHARGES FOR BILL PRINT.  THIS PROGRAM IS CALLED ** 00130000
T5193 ** FROM PCSCA925 WHEN THE BILL FORMAT CODE IS '05'.  THIS DATA ** 00140000
T5193 ** CAN BE FOR ELECTRIC OR GAS LIGHTS, DEPENDING ON SERVICE     ** 00150000
T5193 ** TYPE.  IF ELECTRIC AND OTHER ELEC RATES ARE ALSO PRESENT,   ** 00160000
      ** THESE CHARGES WILL PRINT WITH ELECTRIC;  IF NOT, THEY WILL  ** 00170000
T5193 ** PRINT ALONE.  DITTO GAS.                                    ** 00180000
      *                                                              ** 00230000
      ***************************************************************** 00240000
      *                                                              ** 00250000
      *              PROGRAM  MODIFICATION  LOG                      ** 00260000
      *                                                              ** 00270000
      *    DATE     INITIALS  REASON                                 ** 00280000
      *    ----     --------  ------                                 ** 00290000
      *    06/95    FB        PRELIMINARY VERSION                    ** 00300000
      *    12/95    FB        CHANGE PROGRAM TO BREAK ON IC          ** 00310000
      *    01/96    FB        CSF REWRITE                            ** 00320000
      *    03/96    FB        GET CORRECT EQUIPMENT DESCRIPTION      ** 00330000
      *    05/96    FB        TPR 4049                               ** 00340000
      *    06/96    FB        TPR 4523                               ** 00350000
      *    06/96    FB        TPR 4532                               ** 00360000
      *    06/96    FB        TPR 4564                               ** 00370000
      *    06/96    FB        TPR 4540                               ** 00380000
      *    08/96    FB        TPR 5193                               ** 00390000
      *    01/97    PJB       TPR 8312  PASS RETURN CODE TO PCSCA166 ** 00400000
      *    05/97    KDF       TPR10739   change work queue cat field ** 00410000
      *                                  from +17 to +21 for all     ** 00420000
      *                                  bill print pgms.            ** 00430000
      *    06/97    PB        TPR 8820  Proration                    ** 00440000
      *    06/97    FB        TPR 11731                              ** 00450000
      *    08/97    PB        TPR 12523  Add days to prorate check   ** 00460000
      *    08/97    FB        TPR 12827, 12765                       ** 00470000
      *    08/97    KDF       TPR 12934  Change None-calc logic.     ** 00480000
      *    03/98    PB        TPR 15214  KWH summary                 ** 00490000
      *    06/98    PB        TPR 16002  Rate 36                     ** 00500000
T17308*    08/98    KDF       TPR 17308  ADD FIELD TO CWS00085 FOR   ** 00510000
T16998*                                  TOTAL FROM BG FOR LANDSCAPE ** 00520000
T17591*    09/98    SV        TPR 17591  END DATE CALCULATION FOR    ** 00530000
      *                                  LANDSCAPE BILL.             ** 00540000
T17710*    10/98    SV        TPR 17710  GAS LIGHTING CHARGES TO HAVE** 00550000
T17710*                                  CORRECT NUMBER OF LIGHTS.   ** 00560000
T17592*    10/98    SV        TPR 17592  HAVE ALL LIGHTING CHARGES   ** 00570000
T17592*                                  FOR ALL RATES.              ** 00580000
T17840*    12/98    SV        TPR 17840  TOTAL ELECTRIC CHARGES AND  ** 00590000
T17840*                                  TOTAL MISCELLANEOUS CHARGES ** 00600000
T17840*                                  TO ADD UP TO TOTAL CURRENT  ** 00610000
T17840*                                  MONTH CHARGES.              ** 00620000
T20121*    07/99    SV        TPR 20121  Facility Charges not showing** 00630000
T20121*                                  correct on Bill.            ** 00640000
T20438*    07/99    SV        TPR 20438  None-Calc bill should not go * 00650000
T20438*                                  Group2 CC4 when there is no ** 00660000
T20438*                                  No of days.                 ** 00670000
SEB   *    10/99    CDS       SEB CHANGE  ADDED WORKING STORAGE      ** 00671000
SEB   *                                   FOR CPD00095 CHANGES.      ** 00672000
T21017*    10/99    SV        TPR 21017  Total Electric Charges not  ** 00680000
T21017*                                  adding down Correctly.      ** 00690000
T21983*    05/00    PB        tpr 21983   ADDED WORKING STORAGE      ** 00700000
      *                                   FOR CPD00095 CHANGES.      ** 00710000
T23721*    04/01    JDW       TPR 23721  Combining multiple IC's with** 00720000
      *                                  the same rate is causing  a ** 00730000
      *                                  problem showing all IC's on ** 00740000
      *                                  the consolidated landscape  ** 00750000
      *                                  bill.  Making changes to    ** 00760000
      *                                  display all IC's separately.** 00770000
T23830*    05/01    SV        TPR 23830  Unmetered Gas Light should  ** 00780000
T23830*                                  show table desc on bill.    ** 00790000
T25547*    11/01    gm        TPR 25547  CHANGE DESCRIPTION FOR PSNC ** 00800000
T25547*                                  TO OUTDOOR LIGHTING SERVICE.** 00810000
T25960*    02/02    JDW       TPR 25960  Formatting changes for BTU  ** 00820000
T25960*                                  Factor                      ** 00830000
T28734*    04/03    SV82012   Pull Adjustment Reasons for Non-Calcs  ** 00830100
T28734*                       from DB2 Table.                        ** 00830200
T29598*    10/03    ESM       CML 29598  Franchise Fee verbiage      ** 00831000
T30013*    11/03    ESM       CML 30013  Added code to not display   ** 00831100
T30013*                                  the franchise fee line item ** 00831200
T30013*                                  for none-calcs.             ** 00831300
T32865*    06/05    SV        CML 32865  Crossfoot error on lighting ** 00831400
T32865*                                  credits.                    ** 00831500
T35434*    05/07    RV97439   CML 35434  Replace MODEL_SQL with      ** 00831600
T35434*                                  SET statement               ** 00831700
T35152**   08/08    RV97439   BILL REDESIGN CHANGES.                 ** 00831800
I00177*    01/09    RV97439   REMOVE INDEX HARDCODING FOR BC, UM, UC,** 00831900
I00177*                       CT, EA, CL, DA, DV, AC, BZ, CP TABLES. ** 00832000
I00323*    06/09    DMS       Changed gas lights to display basic    ** 00832100
I00323*                       facilities charge and factor info.     ** 00832200
A02533*    06/10    SJ97149   1.TAKING THE CORRECT DATE FOR THE CANCEL* 00832300
A02533*                         REBILL FOR THE UNMETER LIGHTING      ** 00832400
A02533*                         ACCOUNTS                             ** 00832500
A02533*                       2.USING CORRESPONDING TABLE INDEX      ** 00832600
A02533*                         INSTEAD OF USING TEMPORARY WORKING   ** 00832700
A02533*                         STORAGE VARIABLES.                   ** 00832800
A02003*    09/10    DMS       REMOVED XFOOT WQ GENERATION.           ** 00832900
A02003*    10/10    DMS       CLEAN UP WQ GENERATION.                ** 00833000
P00496*    05/11    RAJ       Industrial Billing Enhancements.       ** 00833100
A03959*    03/12    RAJ       PROJ 496 WARRANTY WORK                 ** 00833200
A03959*                       (ADDITIONAL REQUIREMENTS).             ** 00833300
P00680*    06/12    RAJ       SCANA ENERGY RETENTION & ACQUISTION.   ** 00833401
A04860**   02/15    AS7C117   REPLACE CSS_WQ_ITEMS_MF WITH            * 00833402
A04860**            ACT066    CSS_WQ_ITEMS.                           * 00833403
ACT071**   16/03/15 SS7F226   ADD CREATED-BY FIELD LOGIC IN WF AREA.  * 00833402
ACT071**             A04860                                           * 00833403
      ***************************************************************** 00833500
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
                                                                        
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA174'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-MISC.                                                     
           05  WS-CHECK-MM                  PIC XX.                     
           05  WS-START-DATE                PIC X(10).                  
           05  WS-END-DATE                  PIC X(10).                  
           05  WS-CALC-START-DATE           PIC X(10).                  
           05  WS-CALC-NO-DAYS              PIC S9(9) COMP.             
           05  WS-DISPLAY-DAYS              PIC 9(9).                   
T5193      05  WS-HOLD-SERVICE-TYPE         PIC X VALUE SPACES.         
T28734     05  WS-HOLD-NONECALC-LITERAL     PIC X(255).                 
T28734     05  WS-NC-SUB                    PIC S9(4) COMP.             
T8820      05  WS-SEASONAL-PRORATE          PIC X    VALUE 'N'.         
T8820      05  WS-VERSION-PRORATE           PIC X    VALUE 'N'.         
P00680     05  WS-DISPLAY-UNITS             PIC -ZZZ,ZZZ,ZZ9.           
P00680     05  WS-DISPLAY-RATE              PIC -Z(4)9.999999.          
A02533     05  WS-HOLD-CALC-INDX            PIC 9(3).                   
           05  WS-CHARGES-MESSAGE-FIELDS.                               
               10  WS-FORMAT-MESSAGE        PIC X(75).                  
               10  WS-DISPLAY-PCT           PIC -ZZ.99.                 
               10  WS-COMPUTE-PCT           PIC S9(3)V99.               
           05  WS-UNFORMAT-DATE             PIC X(10).                  
           05  WS-FORMAT-DATE.                                          
               10  WS-FORMAT-MM             PIC XX.                     
               10  F                        PIC X VALUE '/'.            
               10  WS-FORMAT-DD             PIC XX.                     
               10  F                        PIC X VALUE '/'.            
               10  WS-FORMAT-YY             PIC XX.                     
           05  WS-ENGLISH-DATE.                                         
               10  WS-ENGLISH-MM            PIC XXX.                    
               10  F                        PIC X VALUE ' '.            
               10  WS-ENGLISH-DD            PIC XX.                     
I00323     05  WS-GASLITE-DISPLAY-MSG.                                  
T5193          10  F                        PIC X(10) VALUE             
T5193              'Gas Light '.                                        
T5193          10  WS-DISPLAY-CCF           PIC Z(9).                   
T5193          10  F                        PIC X(7) VALUE              
T5193              ' CCF X '.                                           
T5193          10  WS-DISPLAY-FACTOR        PIC -ZZ.9(5).               
T5193          10  F                        PIC X(15) VALUE             
T25960             '  BTU Factor = '.                                   
T5193          10  WS-DISPLAY-THERMS        PIC Z(9).                   
T5193          10  F                        PIC X(7) VALUE              
T5193              ' Therms'.                                           
           05  WS-START-POS                 PIC S9(4) COMP.             
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER                  PIC S9(4) COMP VALUE +121.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +29.    
               10  FILLER                  PIC X(30) VALUE              
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  FILLER                  PIC S9(4) COMP VALUE +121.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  WS-MISC-MSG-LEN         PIC S9(4) COMP VALUE +250.   
               10  WS-MISC-MSG-TEXT        PIC X(250).                  
T29598     05  RS-RETURN-CODE               PIC S9(4) COMP.             
T29598     05  WS-CURRENT-DATE              PIC X(10) VALUE SPACES.     
T29598     05  WS-RUN-DATE                  PIC X(10) VALUE SPACES.     
I00323     05  WS-ROUNDED-BFC               PIC S9(9)V99 VALUE 0.       
T20121 01  WS-FUEL-ADJ-SW               PIC X      VALUE 'N'.           
COB305 01 WS-HOLD-FUEL-ADJ-FACTOR        PIC S9(3)V9(12) comp-3 VALUE 0.        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC  X(08) VALUE 'SCSCA174'.     
T29598     05  PROGRAM-NAME            PIC  X(08) VALUE 'SCSCA174'.     
A04860     05  SCSCB077                PIC  X(08) VALUE 'SCSCB077'.     
                                                                        
      *  Working storage fields for CPD00095                            01771002
       COPY CWSD0095.                                                   01772002
      *  FIELDS USED IN DB2/SQL ERROR CHECKING                          01780000
       COPY CWS00303.                                                   01790000
      *  ABEND FIELDS                                                   01800000
       COPY CWS00010.                                                   01810000
      *  FIELDS USED TO REDUCE EMBEDDED BLANKS                          01820000
       COPY CWS00011.                                                   01830000
T29598*  FIELDS USED TO REMOVE PARENS                                   01840000
T29598 COPY CWS00500.                                                   01850000
      *  ABEND SWITCH                                                   01860000
       COPY CWS09900.                                                   01870000
      *  SUPPLEMENTAL WORK QUEUE FIELDS                                 01880000
       COPY CWS0070B.                                                   01890000
                                                                        
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077     01900100
A04860      EXEC SQL                                                    01900200
A04860           INCLUDE CWS00077                                       01900300
A04860      END-EXEC.                                                   01900400
A04860*                                                                 01900500
T20121     EXEC SQL                                                     01910000
T20121         INCLUDE TBSPLFTR                                         01920000
T20121     END-EXEC.                                                    01930000
                                                                        
           EXEC SQL                                                     01950000
               INCLUDE SQLCA                                            01960000
           END-EXEC.                                                    01970000
           EXEC SQL                                                     01980000
               INCLUDE TBMODEL                                          01990000
           END-EXEC.                                                    02000000
T29598*********************************************************         02010000
T29598*          INCLUDE THE DCLGEN FOR CSS_REV_DISTRICT      *         02020000
T29598*********************************************************         02021000
T29598     EXEC SQL                                                     02022000
T29598          INCLUDE TBRVDST                                         02023000
T29598     END-EXEC.                                                    02024000
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
      *  BILLING EXTRACT FILE                                           02029500
      *  SPLIT CWS10000 INTO 2 COPYBOOKS                                02029600
       COPY CWS1000A.                                                   02029700
       COPY CWS1000B.                                                   02029800
      *  BILLING EXTRACT FILE                                           02029900
       COPY CWS10009.                                                   02030000
       01  SUB1                         PIC 9(3).                       
       01  WS-SCSCA-RETURN-CODE         PIC S9(4) comp.                 
      *  NON-MUNICIPAL LIGHTS (ELECTRIC)                                02060000
       COPY CWS00085.                                                   02070000
T5193 *  NON-MUNICIPAL LIGHTS (GAS)                                     02080000
T5193  COPY CWS00093.                                                   02090000
      *  WORK QUEUE FIELDS                                              02100000
       COPY CWS0024B.                                                   02110000
T28734*  NONECALC FIELDS                                                02120000
T28734 COPY CWS00097.                                                   02130000
P00496*  CSS_RATE_COMPONENT DUMPED TABLE                                02131000
P00496 COPY CWSCA925.                                                   02132000
                                                                        
       PROCEDURE DIVISION USING WS-ACCOUNT-AT                           
                                WS-MISC-BILL-INFO                       
                                WS-PREV-BILL-INFO                       
T29598                          WS-PREMISE-PR                           
                                WS-BILLING-BG                           
                                WS-CNSMPTN-HIST-CX                      
                                WS-BILL-ADJUST-DETAIL                   
                                WS-BILL-CALC-DETAIL                     
                                WS-UNMTRD-CNSMPTN-UC                    
                                SUB1                                    
T28734                          WS-NONCALC-LITERALS                     
T8312                           WS-SCSCA-RETURN-CODE                    
                                LS-PCSCA100-COMM-AREA                   
                                WS-BILLING-WQ-ITEMS-WF                  
                                WS-BILLING-BI                           
                                WS-UNMTRD-NON-MUNI-BILL-PRINT           
T30187                          WS-BILL-ADJUSTMNT                       
I00177                          WS-GASLITE-NON-MUNI-BILL-PRINT          
I00177                          WS-CWS1000B-MAX-TBL-LIMITS              
P00496                          WS-RATE-COMPONENT.                      

SCA006        SET SPCL-FACTOR-IND TO 1.
                                                                        
      ************************************************************      02330000
      *  PROGRAM IS CALLED FROM PCSCA925.  UNMETERED             *      02340000
      *  NON-MUNICIPAL RATE DATA IS FORMATTED FOR CSF.  FIRST    *      02350000
      *  DETERMINE IF THE CODE SERVICE TYPE SPECIFIES ELECTRIC   *      02360000
      *  OR GAS.                                                 *      02370000
      ************************************************************      02380000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           DISPLAY 'SCSCA174 - NON-MUNICIPAL LIGHTS'.                   
T28305     MOVE 'N' TO WS-VERSION-PRORATE                               
T28305                 WS-SEASONAL-PRORATE.                             
T8820      PERFORM 3000-CHECK-FOR-PRORATE THRU 3000-EXIT.               
                                                                        
T12827     IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                         
T12765         PERFORM 0500-NONE-CALC THRU 0500-EXIT                    
T12765         PERFORM 9999-BAIL-OUT THRU 9999-EXIT
           END-IF.                    
T12827                                                                  
T5193      MOVE ' ' TO WS-HOLD-SERVICE-TYPE.                            
A02533     PERFORM VARYING WS-UNMTRD-CNSMPTN-INDX FROM 1 BY 1           
A02533             UNTIL WS-UNMTRD-CNSMPTN-INDX > WS-UC-MAX-ENTRY       
A02533             OR WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX) = ZEROES
A02533      IF WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX) =              
A02533                                 WS-ACCOUNT-NO-BG (SUB1) AND      
A02533         WS-BILL-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                   
A02533                                 = WS-BILL-NO-BG (SUB1) AND       
A02533         WS-CODE-UTIL-TYPE-UC (WS-UNMTRD-CNSMPTN-INDX) =          
A02533                            WS-CODE-UTIL-TYPE-BG (SUB1) AND       
A02533         WS-IC-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                     
A02533                                   = WS-IC-NO-BG (SUB1) AND       
A02533         WS-BILL-ITEM-TIMESTMP-UC (WS-UNMTRD-CNSMPTN-INDX)=       
A02533                        WS-BILL-ITEM-TIMESTMP-BG (SUB1)           
A02533         IF WS-HOLD-SERVICE-TYPE <= SPACES                        
A02533            MOVE WS-CODE-SERVICE-TYPE-UC (WS-UNMTRD-CNSMPTN-INDX) 
A02533                         TO  WS-HOLD-SERVICE-TYPE                 
A02533         ELSE                                                     
A02533            IF WS-CODE-SERVICE-TYPE-UC (WS-UNMTRD-CNSMPTN-INDX)   
A02533                     NOT = WS-HOLD-SERVICE-TYPE                   
A02533               PERFORM 0100-SERVICE-TYPE-MISMATCH THRU 0100-EXIT  
A02533            END-IF                                                
A02533        END-IF                                                    
A02533     END-IF                                                       
A02533     END-PERFORM.                                                 
T5193                                                                   
T5193      EVALUATE WS-HOLD-SERVICE-TYPE                                
T5193          WHEN 'E'                                                 
T5193              PERFORM 1000-FORMAT-UNMTRD-IC THRU 1000-EXIT         
T5193          WHEN 'G'                                                 
T5193              PERFORM 2000-FORMAT-GASLITE-IC THRU 2000-EXIT        
T5193          WHEN OTHER                                               
T5193              MOVE 'C' TO WS-BILL-DEST-CODE                        
T5193              MOVE '6' TO WS-SYSTEM-CNTRL-CODE                     
T5193      END-EVALUATE.                                                
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
T5193 ************************************************************      02970000
T5193 *  IF SERVICE TYPES FROM THE UC SEQMENTS DO NOT ALL MATCH, *      02980000
T5193 *  WRITE A WORK QUEUE ERROR AND EXIT THIS SUB-PROGRAM.     *      02990000
T5193 ************************************************************      03000000
T5193                                                                   
T5193  0100-SERVICE-TYPE-MISMATCH.                                      
T5193                                                                   
T5193      MOVE 'C' TO WS-BILL-DEST-CODE.                               
T5193      MOVE '7' TO WS-SYSTEM-CNTRL-CODE.                            
T5193      PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
T5193                                                                   
T5193  0100-EXIT.                                                       
T5193      EXIT.                                                        
                                                                        
T12765 0500-NONE-CALC.                                                  
T12765                                                                  
T12765     MOVE 'Y' TO WS-UNMTRD-DATA.                                  
T17591     MOVE WS-DATE-USAGE-ENDS-UC(1) TO WS-UNFORMAT-DATE.           
T12765     MOVE SPACES TO WS-ENGLISH-DATE.                              
T12765     MOVE WS-UNFORMAT-DATE(9:2) TO WS-ENGLISH-DD.                 
T12765     PERFORM 4000-ENGLISH-MONTH THRU 4000-EXIT.                   
T12765     IF WS-UNMTRD-END-DATE <= SPACES                              
T12765       MOVE WS-ENGLISH-DATE TO WS-UNMTRD-END-DATE
           END-IF.                
T35152     IF WS-UNMTRD-END-DATE-NUM <= SPACES                          
T35152       MOVE WS-DATE-USAGE-ENDS-UC(1) TO WS-UNMTRD-END-DATE-NUM    
T35152     END-IF.                                                      
T17591     MOVE WS-DATE-USAGE-ENDS-UC(1) TO WS-END-DATE.                
T12765     MOVE WS-NO-OF-CONS-DAYS-BG (SUB1) TO WS-CALC-NO-DAYS.        
T12765     EXEC SQL                                                     
T35434          SELECT
              DATEADD( DAY, -:WS-CALC-NO-DAYS, IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) )
            INTO
              :WS-CALC-START-DATE         
T12765     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     03340000
MFA-TR*         SET :WS-CALC-START-DATE =                               03371000
MFA-TR*              DATE(:WS-END-DATE) - :WS-CALC-NO-DAYS DAYS         03372000
MFA-TR*    END-EXEC.                                                    03380000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T12765     IF SQLCODE NOT = SUCCESSFUL-CALL                             
T12765         MOVE SPACES TO WS-CALC-START-DATE
           END-IF.                       
T12765                                                                  
T12765     MOVE WS-CALC-START-DATE TO WS-UNFORMAT-DATE.                 
T12765     MOVE SPACES TO WS-ENGLISH-DATE.                              
T12765     MOVE WS-UNFORMAT-DATE(9:2) TO WS-ENGLISH-DD.                 
T12765     PERFORM 4000-ENGLISH-MONTH THRU 4000-EXIT.                   
T12765     IF WS-UNMTRD-ST-DATE <= SPACES                               
T12765         MOVE WS-ENGLISH-DATE TO WS-UNMTRD-ST-DATE
           END-IF.               
T35152     IF WS-UNMTRD-ST-DATE-NUM <= SPACES                           
T35152         MOVE WS-CALC-START-DATE TO WS-UNMTRD-ST-DATE-NUM         
T35152     END-IF.                                                      
T12765     MOVE WS-CODE-UTIL-TYPE-BG (SUB1) TO                          
T12765          WS-UNMTRD-UTIL-TYPE.                                    
T12765     MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO                           
T12765          WS-UNMTRD-TOTAL.                                        
T21017     IF WS-CODE-DR-CR-CNSMPTN-BG (SUB1) = 'C'                     
T21017        COMPUTE WS-UNMTRD-CURR-COST =                             
T21017                WS-UNMTRD-CURR-COST -                             
T32865                WS-AMT-BILL-ITEM-BG (SUB1)                        
T21017     ELSE                                                         
T12765        COMPUTE WS-UNMTRD-CURR-COST =                             
T12765                WS-UNMTRD-CURR-COST +                             
T12765                WS-AMT-BILL-ITEM-BG (SUB1) -                      
T12765                WS-AMT-STATE-TAX-BG (SUB1)                        
T21017     END-IF.                                                      
T12765     MOVE ZEROES TO WS-UNMTRD-TOTAL-CALC.                         
T12765     IF WS-AMT-CITY-TAX-BG (SUB1) > ZEROES                        
T30013     AND WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S'                    
T12765         MOVE SPACES TO WS-FORMAT-MESSAGE                         
T12765         COMPUTE WS-COMPUTE-PCT =                                 
T12765                 WS-FRANCHISE-TX-RATE-CALC (SUB1) * 100           
T12765         MOVE WS-COMPUTE-PCT TO WS-DISPLAY-PCT                    
T29598         IF (CSR-DATABASE                                         
T29598         AND WS-COMPANY-NO-AT = '01')                             
T29598            MOVE SPACES TO WS-REV-INPUT                           
T29598                           WS-REV-TABLE                           
T29598            MOVE 35 TO WS-REV-LENG                                
T29598            MOVE WS-REV-DISTRICT-CD-PR TO A9-REV-DISTRICT-CD      
T29598            PERFORM 6500-GET-REV-DIST-DESC THRU 6500-EXIT         
T29598            STRING 'Franchise Fee '                               
T29598                   WS-DISPLAY-PCT                                 
T29598                   '% paid to the '                               
T29598                   WS-REV-TABLE                                   
T29598                   DELIMITED BY SIZE                              
T29598                   INTO WS-FORMAT-MESSAGE                         
T29598            MOVE 75 TO WS-EMB-LENG                                
T29598         ELSE                                                     
T12765            STRING 'Franchise Fee - '                             
T12765                   WS-DISPLAY-PCT                                 
T12765                   '%'                                            
T12765                   DELIMITED BY SIZE                              
T12765                   INTO WS-FORMAT-MESSAGE                         
T12765            MOVE 23 TO WS-EMB-LENG                                
T29598         END-IF                                                   
T12765         MOVE SPACES TO WS-EMB-INPUT                              
T12765                       WS-CMP-TABLE                               
T12765         MOVE WS-FORMAT-MESSAGE TO WS-EMB-INPUT                   
T12765         PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT       
T12765         MOVE WS-CMP-TABLE TO WS-UNMTRD-FRAN-MSG                  
T12765         ADD WS-AMT-CITY-TAX-BG (SUB1) TO WS-UNMTRD-FRAN-AMT      
T12765         ADD WS-AMT-CITY-TAX-BG (SUB1) TO WS-UNMTRD-TOTAL-CALC
           END-IF.   
T32865     IF WS-CODE-DR-CR-CNSMPTN-BG (SUB1) = 'C'                     
T32865        CONTINUE                                                  
T32865     ELSE                                                         
T12765        ADD WS-AMT-STATE-TAX-BG (SUB1) TO WS-UNMTRD-TOTAL-CALC    
T32865     END-IF.                                                      
T12765                                                                  
T12765     PERFORM 3700-NONE-CALC THRU 3700-EXIT.                       
           PERFORM VARYING WS-UNMTRD-SUB FROM 1 BY 1                    
               UNTIL WS-UNMTRD-SUB > 100 OR                             
               WS-UNMTRD-DESC (WS-UNMTRD-SUB) <= SPACES                 
           END-PERFORM.                                                 
T12765     MOVE WS-HOLD-NONECALC-LITERAL TO                             
T12765          WS-UNMTRD-DESC (WS-UNMTRD-SUB).                         
T12765     IF WS-CODE-DR-CR-CNSMPTN-BG (SUB1) = 'C'                     
T12934        COMPUTE WS-UNMTRD-TOTAL-CALC = WS-UNMTRD-TOTAL-CALC * -1  
T12934        COMPUTE WS-UNMTRD-TOTAL = WS-UNMTRD-TOTAL * -1            
T12765        COMPUTE WS-UNMTRD-AMT (WS-UNMTRD-SUB) =                   
T30013            (WS-AMT-BILL-ITEM-BG (SUB1) * -1)                     
T12765     ELSE                                                         
T12765        COMPUTE WS-UNMTRD-AMT (WS-UNMTRD-SUB) =                   
T12934            (WS-AMT-BILL-ITEM-BG (SUB1) -                         
T12934             WS-AMT-STATE-TAX-BG (SUB1) -                         
T12934             WS-AMT-CITY-TAX-BG (SUB1) )                          
T12765     END-IF                                                       
T12765     ADD WS-UNMTRD-AMT (WS-UNMTRD-SUB) TO                         
T12765         WS-UNMTRD-TOTAL-CALC.                                    
T12765     IF WS-UNMTRD-TOTAL NOT = WS-UNMTRD-TOTAL-CALC                
T12765         MOVE 'C' TO WS-BILL-DEST-CODE                            
T12765         MOVE 'X' TO WS-SYSTEM-CNTRL-CODE                         
T12765     END-IF.                                                      
T12765                                                                  
T12765 0500-EXIT.                                                       
T12765     EXIT.                                                        
                                                                        
      ************************************************************      04330000
      *                    ELECTRIC                              *      04340000
      *  THIS ROUTINE FORMATS THE IC HEADER DATA.  WITHIN EACH   *      04350000
      *  RATE IC HEADER WILL BE RATE METER RECORDS AND RATE      *      04360000
      *  CHARGES RECORDS.  BILL PERIOD END DATE IS THE BILLING   *      04370000
      *  DATE.  GET THE MAXIMUM NUMBER OF DAYS FROM THE          *      04380000
      *  UNMETERED COMSUMPTION SEGMENTS.  CALCULATE THE BILL     *      04390000
      *  PERIOD START DATE = END DATE - # DAYS.  TOTALS ARE      *      04400000
      *  COMPARED.  IF THEY ARE NOT EQUAL, A CROSSFOOT ERROR IS  *      04410000
      *  GENERATED.  NO HISTORICAL DATA IS MAINTAINED FOR        *      04420000
      *  UNMETERED RATES.                                        *      04430000
      ************************************************************      04440000
                                                                        
       1000-FORMAT-UNMTRD-IC.                                           
                                                                        
A02533     PERFORM VARYING WS-UNMTRD-CNSMPTN-INDX FROM 1 BY 1           
A02533             UNTIL WS-UNMTRD-CNSMPTN-INDX > WS-UC-MAX-ENTRY       
A02533             OR WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX) = ZEROES
A02533      IF WS-ACCOUNT-NO-UC(WS-UNMTRD-CNSMPTN-INDX) =               
A02533                             WS-ACCOUNT-NO-BG (SUB1) AND          
A02533         WS-BILL-NO-UC(WS-UNMTRD-CNSMPTN-INDX) =                  
A02533                                WS-BILL-NO-BG (SUB1) AND          
A02533         WS-CODE-UTIL-TYPE-UC(WS-UNMTRD-CNSMPTN-INDX)             
A02533                        = WS-CODE-UTIL-TYPE-BG(SUB1) AND          
A02533         WS-IC-NO-UC(WS-UNMTRD-CNSMPTN-INDX) =                    
A02533                                  WS-IC-NO-BG (SUB1) AND          
A02533         WS-BILL-ITEM-TIMESTMP-UC(WS-UNMTRD-CNSMPTN-INDX) =       
A02533         WS-BILL-ITEM-TIMESTMP-BG (SUB1)                          
A02533        IF WS-NO-DAYS-UC (WS-UNMTRD-CNSMPTN-INDX) > WS-UNMTRD-DAYS
A02533            MOVE WS-NO-DAYS-UC (WS-UNMTRD-CNSMPTN-INDX)           
A02533                                             TO  WS-UNMTRD-DAYS   
A02533            MOVE 'Y'                         TO WS-UNMTRD-DATA    
A02533            MOVE WS-DATE-USAGE-ENDS-UC(WS-UNMTRD-CNSMPTN-INDX)    
A02533                                             TO WS-UNFORMAT-DATE  
A02533            MOVE SPACES                      TO WS-ENGLISH-DATE   
A02533            MOVE WS-UNFORMAT-DATE(9:2)       TO WS-ENGLISH-DD     
A02533            PERFORM 4000-ENGLISH-MONTH       THRU 4000-EXIT       
A02533            MOVE WS-ENGLISH-DATE             TO WS-UNMTRD-END-DATE
A02533            MOVE WS-DATE-USAGE-ENDS-UC(WS-UNMTRD-CNSMPTN-INDX)    
A02533                                             TO WS-END-DATE       
A02533                                      WS-UNMTRD-END-DATE-NUM      
               END-IF                                                   
            END-IF                                                      
           END-PERFORM.                                                 
                                                                        
           MOVE WS-UNMTRD-DAYS TO WS-CALC-NO-DAYS.                      
           EXEC SQL                                                     
T35434          SELECT
              DATEADD( DAY, -:WS-CALC-NO-DAYS, IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) )
            INTO
              :WS-CALC-START-DATE         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     04760000
MFA-TR*         SET :WS-CALC-START-DATE =                               04791000
MFA-TR*              DATE(:WS-END-DATE) - :WS-CALC-NO-DAYS DAYS         04792000
MFA-TR*    END-EXEC.                                                    04800000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
               MOVE 'C' TO WS-BILL-DEST-CODE                            
               MOVE '4' TO WS-SYSTEM-CNTRL-CODE                         
A02003         MOVE SPACES TO WS-CALC-START-DATE                        
A02003     END-IF.                                                      
                                                                        
T35152     MOVE WS-CALC-START-DATE TO WS-UNFORMAT-DATE                  
T35152                                WS-UNMTRD-ST-DATE-NUM.            
           MOVE SPACES TO WS-ENGLISH-DATE.                              
           MOVE WS-UNFORMAT-DATE(9:2) TO WS-ENGLISH-DD.                 
           PERFORM 4000-ENGLISH-MONTH THRU 4000-EXIT.                   
           MOVE WS-ENGLISH-DATE TO WS-UNMTRD-ST-DATE.                   
           MOVE WS-CODE-UTIL-TYPE-BG (SUB1) TO                          
                WS-UNMTRD-UTIL-TYPE.                                    
T17840     ADD  WS-AMT-BILL-ITEM-BG (SUB1) TO                           
                WS-UNMTRD-TOTAL                                         
           COMPUTE WS-UNMTRD-CURR-COST =                                
T4640              WS-UNMTRD-CURR-COST +                                
                   WS-AMT-BILL-ITEM-BG (SUB1) -                         
                   WS-AMT-STATE-TAX-BG (SUB1).                          
           PERFORM 1300-UNMETERED-CHARGES THRU 1300-EXIT.               
           IF WS-AMT-CITY-TAX-BG (SUB1) > ZEROES                        
T30013     AND WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S'                    
               MOVE SPACES TO WS-FORMAT-MESSAGE                         
               COMPUTE WS-COMPUTE-PCT =                                 
                       WS-FRANCHISE-TX-RATE-CALC (SUB1) * 100           
               MOVE WS-COMPUTE-PCT TO WS-DISPLAY-PCT                    
T29598         IF (CSR-DATABASE                                         
T29598         AND WS-COMPANY-NO-AT = '01')                             
T29598            MOVE SPACES TO WS-REV-INPUT                           
T29598                           WS-REV-TABLE                           
T29598            MOVE 35 TO WS-REV-LENG                                
T29598            MOVE WS-REV-DISTRICT-CD-PR TO A9-REV-DISTRICT-CD      
T29598            PERFORM 6500-GET-REV-DIST-DESC THRU 6500-EXIT         
T29598            STRING 'Franchise Fee '                               
T29598                   WS-DISPLAY-PCT                                 
T29598                   '% paid to the '                               
T29598                   WS-REV-TABLE                                   
T29598                   DELIMITED BY SIZE                              
T29598                   INTO WS-FORMAT-MESSAGE                         
T29598            MOVE 75 TO WS-EMB-LENG                                
T29598         ELSE                                                     
                  STRING 'Franchise Fee - '                             
                         WS-DISPLAY-PCT                                 
                         '%'                                            
                         DELIMITED BY SIZE                              
                         INTO WS-FORMAT-MESSAGE                         
                  MOVE 23 TO WS-EMB-LENG                                
T29598         END-IF                                                   
               MOVE SPACES TO WS-EMB-INPUT                              
                             WS-CMP-TABLE                               
               MOVE WS-FORMAT-MESSAGE TO WS-EMB-INPUT                   
               PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT       
               MOVE WS-CMP-TABLE TO WS-UNMTRD-FRAN-MSG                  
               ADD WS-AMT-CITY-TAX-BG (SUB1) TO WS-UNMTRD-FRAN-AMT      
               ADD WS-AMT-CITY-TAX-BG (SUB1) TO WS-UNMTRD-TOTAL-CALC
           END-IF.   
           ADD WS-AMT-STATE-TAX-BG (SUB1) TO WS-UNMTRD-TOTAL-CALC.      
                                                                        
P00496     MOVE SPACES TO WS-PREV-FACTOR.                               
T20121     PERFORM 3600-GET-FACTORS THRU 3600-EXIT.                     
T20121     MOVE 1 TO WS-U-FACT-SUB.                                     
T20121     MOVE 1 TO WS-UNMTRD-CHG-SUB.                                 
T20121     PERFORM 1310-DETERMINE-CHG-SUB THRU 1310-EXIT.               
T20121     MOVE 1 TO WS-HOLD-FACTOR-SUB.                                
P00496     PERFORM UNTIL WS-HOLD-FACTOR-SUB > 50 OR                     
P00496          WS-HOLD-FACTOR-FLAG(WS-HOLD-FACTOR-SUB) = SPACES        
T20121           MOVE WS-HOLD-FACTOR-DESC (WS-HOLD-FACTOR-SUB) TO       
T20121               WS-UNMTRD-CHG-MSG (WS-U-FACT-SUB WS-UNMTRD-CHG-SUB)
T20121           MOVE WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO        
T20121               WS-UNMTRD-CHG-AMT (WS-U-FACT-SUB WS-UNMTRD-CHG-SUB)
T20121           ADD WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO         
T20121               WS-UNMTRD-TOTAL-CALC                               
T20121           ADD 1 TO WS-UNMTRD-CHG-SUB                             
T20121                    WS-HOLD-FACTOR-SUB                            
T20121     END-PERFORM.                                                 
T20121                                                                  
T20121     IF  WS-REPLACE-FACTOR-ID > SPACES                            
T20121         PERFORM VARYING WS-UNMTRD-CHG-SUB FROM 1 BY 1 UNTIL      
T20121                 WS-UNMTRD-CHG-SUB > 200 OR                       
T20121                 WS-UNMTRD-CHG-MSG                                
T20121                    (WS-U-FACT-SUB WS-UNMTRD-CHG-SUB) <= SPACES   
T20121             SUBTRACT WS-UNMTRD-CHG-AMT                           
T20121                     (WS-U-FACT-SUB WS-UNMTRD-CHG-SUB) FROM       
T20121                      WS-UNMTRD-TOTAL-CALC                        
T20121             MOVE SPACES TO                                       
T20121                  WS-UNMTRD-CHG-MSG                               
T20121                    (WS-U-FACT-SUB WS-UNMTRD-CHG-SUB)             
T20121             MOVE 0.00 TO                                         
T20121                  WS-UNMTRD-CHG-AMT                               
T20121                    (WS-U-FACT-SUB WS-UNMTRD-CHG-SUB)             
T20121                                                                  
T20121         END-PERFORM                                              
T20121         MOVE WS-REPLACE-FACTOR-AMT TO                            
T20121              WS-UNMTRD-CHG-AMT (WS-U-FACT-SUB 1)                 
T20121         ADD WS-REPLACE-FACTOR-AMT TO                             
T20121             WS-UNMTRD-TOTAL-CALC                                 
T20121         EVALUATE WS-REPLACE-FACTOR-ID                            
T20121             WHEN 'SPMNTMIN'                                      
T20121                 MOVE 'Monthly Minimum Contract' TO               
T20121                       WS-UNMTRD-CHG-MSG (WS-U-FACT-SUB 1)        
A02003         END-EVALUATE                                             
A02003     END-IF.                                                      
A02003                                                                  
           IF WS-UNMTRD-TOTAL NOT = WS-UNMTRD-TOTAL-CALC                
               MOVE 'C' TO WS-BILL-DEST-CODE                            
               MOVE 'X' TO WS-SYSTEM-CNTRL-CODE                         
A02003     END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      05950000
      *  PROCESS ALL BILL ADJUSTMENTS AND CALCULATIONS           *      05960000
      *  (UNMETERED).  GET THE DESCRIPTION.  THIS DATA WILL      *      05970000
      *  ACCUMULATE IN THE UNMETERED WORKING STORAGE TABLE.      *      05980000
      ************************************************************      05990000
                                                                        
       1300-UNMETERED-CHARGES.                                          
                                                                        
           MOVE 1 TO WS-UNMTRD-SUB                                      
A02533     PERFORM VARYING WS-CALC-INDX FROM 1 BY 1                     
A02533             UNTIL WS-CALC-INDX > WS-BZ-MAX-ENTRY                 
A02533                OR WS-ACCOUNT-NO-BC (WS-CALC-INDX) = ZEROES       
A02533        IF WS-ACCOUNT-NO-BG (SUB1) =                              
A02533                        WS-ACCOUNT-NO-BC (WS-CALC-INDX) AND       
A02533           WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BC (WS-CALC-INDX) AND
A02533           WS-CODE-UTIL-TYPE-BG (SUB1) =                          
A02533                       WS-CODE-UTIL-TYPE-BC (WS-CALC-INDX) AND    
A02533           WS-IC-NO-BG (SUB1) = WS-IC-NO-BC (WS-CALC-INDX) AND    
A02533           WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
A02533                       WS-BILL-ITEM-TIMESTMP-BC (WS-CALC-INDX)    
A02533               IF WS-PRORATE-CD-BG (SUB1) > ' ' AND               
A02533                 (WS-NO-OF-CONS-DAYS-BG (SUB1) < 27 OR            
A02533                  WS-NO-OF-CONS-DAYS-BG (SUB1) > 34)              
A02533                   ADD WS-NET-UNITS-BC (WS-CALC-INDX)             
A02533                                              TO WS-UNMTRD-USAGE  
A02533               ELSE                                               
A02533                   ADD WS-READ-UNITS-BC (WS-CALC-INDX)            
A02533                                               TO WS-UNMTRD-USAGE 
A02533               END-IF                                             
A02533               PERFORM 1400-BUILD-UNMETERED-TABLE THRU 1400-EXIT  
A02533        END-IF                                                    
A02533     END-PERFORM.                                                 
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
T20121 1310-DETERMINE-CHG-SUB.                                          
T20121                                                                  
T20121     IF WS-UNMTRD-CHG-MSG (WS-U-FACT-SUB WS-UNMTRD-CHG-SUB)       
T20121        <= SPACES                                                 
T20121         GO TO 1310-EXIT                                          
T20121     ELSE                                                         
T20121         ADD 1 TO WS-UNMTRD-CHG-SUB                               
T20121         IF WS-UNMTRD-CHG-SUB > 200                               
T20121             MOVE 12 TO RETURN-CODE                               
T20121             MOVE 'OVER 200 CHARGES' TO                           
T20121                  WS-MISC-MSG-TEXT                                
T20121             MOVE +16 TO WS-MISC-MSG-LEN                          
T20121             PERFORM 9910-MISC-ERROR THRU 9910-EXIT               
T20121             PERFORM 9999-BAIL-OUT THRU 9999-EXIT                 
T20121         END-IF                                                   
T20121         GO TO 1310-DETERMINE-CHG-SUB
           END-IF.                            
T20121                                                                  
T20121 1310-EXIT.                                                       
T20121     EXIT.                                                        
I00323************************************************************      06462000
I00323*  DETERMINE THE FIRST BLANK LINE IN THE CHARGES TABLE.    *      06463000
I00323************************************************************      06464000
I00323 1320-DETERMINE-CHG-SUB.                                          
I00323                                                                  
I00323     PERFORM UNTIL WS-GASLITE-CHG-MSG (WS-GASLITE-SUB             
I00323                             WS-GASLITE-CHG-SUB) <= SPACES        
I00323         ADD 1 TO WS-GASLITE-CHG-SUB                              
I00323         IF WS-GASLITE-CHG-SUB > 200                              
I00323             MOVE 12 TO RETURN-CODE                               
I00323             MOVE 'OVER 200 CHARGES' TO                           
I00323                  WS-MISC-MSG-TEXT                                
I00323             MOVE +16 TO WS-MISC-MSG-LEN                          
I00323             PERFORM 9910-MISC-ERROR THRU 9910-EXIT               
I00323             PERFORM 9999-BAIL-OUT THRU 9999-EXIT                 
I00323         END-IF                                                   
I00323     END-PERFORM.                                                 
I00323 1320-EXIT.                                                       
I00323     EXIT.                                                        
      ************************************************************      06472000
      *  ACCUMULATE DESCRIPTIONS AND CHARGES INTO THE WORKING    *      06480000
      *  STORAGE TABLE.                                          *      06490000
      ************************************************************      06500000
                                                                        
       1400-BUILD-UNMETERED-TABLE.                                      
                                                                        
T23721     IF  WS-RATE-PLAN-NO-BG (SUB1) =                              
T23721         WS-UNMTRD-RATE (WS-UNMTRD-SUB)                           
T23721     AND WS-IC-NO-BG (SUB1) =                                     
T23721         WS-UNMTRD-IC-NO (WS-UNMTRD-SUB)                          
T23721         MOVE WS-RATE-PLAN-NO-BG (SUB1) TO                        
T23721              WS-UNMTRD-RATE (WS-UNMTRD-SUB)                      
T23721         MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO                       
T23721              WS-UNMTRD-TOT-AMT (WS-UNMTRD-SUB)                   
T17592        MOVE WS-IC-NO-BG (SUB1) TO WS-UNMTRD-IC-NO (WS-UNMTRD-SUB)
T8820         IF ( WS-PRORATE-CD-BG (SUB1) > ' ' AND                    
T12523            (WS-NO-OF-CONS-DAYS-BG (SUB1) < 27 OR                 
T12523             WS-NO-OF-CONS-DAYS-BG (SUB1) > 34))                  
A02533           OR ( WS-CALC-COMPONENT-AMT-BC (WS-CALC-INDX)           
A02533             NOT EQUAL TO WS-NET-COMPONENT-AMT-BC (WS-CALC-INDX)) 
A02533           ADD WS-CALC-COMPONENT-AMT-BC (WS-CALC-INDX) TO         
T8820                WS-UNMTRD-AMT (WS-UNMTRD-SUB)                      
A02533           ADD WS-CALC-COMPONENT-AMT-BC (WS-CALC-INDX) TO         
T8820                WS-UNMTRD-TOTAL-CALC                               
T8820         ELSE                                                      
A02533           ADD WS-NET-COMPONENT-AMT-BC (WS-CALC-INDX) TO          
                     WS-UNMTRD-AMT (WS-UNMTRD-SUB)                      
A02533           ADD WS-NET-COMPONENT-AMT-BC (WS-CALC-INDX) TO          
                     WS-UNMTRD-TOTAL-CALC                               
T8820         END-IF                                                    
              GO TO 1400-EXIT                                           
           END-IF                                                       
T4564      IF WS-UNMTRD-DESC (WS-UNMTRD-SUB) = SPACES                   
              MOVE WS-RATE-PLAN-NO-BG (SUB1) TO                         
                   WS-UNMTRD-RATE (WS-UNMTRD-SUB)                       
T16998         MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO                       
T16998              WS-UNMTRD-TOT-AMT (WS-UNMTRD-SUB)                   
T4532          MOVE WS-RATE-DESCRIPTION-CALC (SUB1) TO                  
                        WS-UNMTRD-DESC (WS-UNMTRD-SUB)                  
T8820          IF ( WS-PRORATE-CD-BG (SUB1) > ' ' AND                   
T12523              (WS-NO-OF-CONS-DAYS-BG (SUB1) < 27 OR               
T12523               WS-NO-OF-CONS-DAYS-BG (SUB1) > 34))                
A02533            OR ( WS-CALC-COMPONENT-AMT-BC (WS-CALC-INDX)          
A02533              NOT EQUAL TO WS-NET-COMPONENT-AMT-BC (WS-CALC-INDX))
A02533             MOVE WS-CALC-COMPONENT-AMT-BC (WS-CALC-INDX) TO      
T8820                   WS-UNMTRD-AMT (WS-UNMTRD-SUB)                   
A02533             ADD  WS-CALC-COMPONENT-AMT-BC (WS-CALC-INDX) TO      
T8820                   WS-UNMTRD-TOTAL-CALC                            
T8820          ELSE                                                     
A02533             MOVE WS-NET-COMPONENT-AMT-BC (WS-CALC-INDX) TO       
                        WS-UNMTRD-AMT (WS-UNMTRD-SUB)                   
A02533             ADD  WS-NET-COMPONENT-AMT-BC (WS-CALC-INDX) TO       
                        WS-UNMTRD-TOTAL-CALC                            
T8820          END-IF                                                   
T17592        MOVE WS-IC-NO-BG (SUB1) TO WS-UNMTRD-IC-NO (WS-UNMTRD-SUB)
               GO TO 1400-EXIT
           END-IF.                                         
T17592     MOVE WS-IC-NO-BG (SUB1) TO WS-UNMTRD-IC-NO (WS-UNMTRD-SUB).  
           ADD 1 TO WS-UNMTRD-SUB.                                      
           IF WS-UNMTRD-SUB > 100                                       
               MOVE 12 TO RETURN-CODE                                   
               MOVE 'OVER 100 UNMETERED' TO                             
                    WS-MISC-MSG-TEXT                                    
               MOVE +18 TO WS-MISC-MSG-LEN                              
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
               PERFORM 9999-BAIL-OUT THRU 9999-EXIT
           END-IF.                    
               GO TO 1400-BUILD-UNMETERED-TABLE.                        
                                                                        
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
T5193 ************************************************************      07320000
T5193 *                        GAS                               *      07330000
T5193 *  THIS ROUTINE FORMATS THE IC HEADER DATA.  WITHIN EACH   *      07340000
T5193 *  RATE IC HEADER WILL BE RATE METER RECORDS AND RATE      *      07350000
T5193 *  CHARGES RECORDS.  BILL PERIOD END DATE IS THE BILLING   *      07360000
T5193 *  DATE.  GET THE MAXIMUM NUMBER OF DAYS FROM THE          *      07370000
T5193 *  UNMETERED COMSUMPTION SEGMENTS.  CALCULATE THE BILL     *      07380000
T5193 *  PERIOD START DATE = END DATE - # DAYS.  TOTALS ARE      *      07390000
T5193 *  COMPARED.  IF THEY ARE NOT EQUAL, A CROSSFOOT ERROR IS  *      07400000
T5193 *  GENERATED.  NO HISTORICAL DATA IS MAINTAINED FOR        *      07410000
T5193 *  UNMETERED RATES.                                        *      07420000
T5193 ************************************************************      07430000
T5193                                                                   
T5193  2000-FORMAT-GASLITE-IC.                                          
T5193                                                                   
T5193                                                                   
A02533     PERFORM VARYING WS-UNMTRD-CNSMPTN-INDX FROM 1 BY 1           
A02533             UNTIL WS-UNMTRD-CNSMPTN-INDX > WS-UC-MAX-ENTRY       
A02533             OR WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX) = ZEROES
A02533      IF WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                
A02533                                 = WS-ACCOUNT-NO-BG (SUB1) AND    
A02533         WS-BILL-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                   
A02533                                 = WS-BILL-NO-BG (SUB1) AND       
A02533         WS-CODE-UTIL-TYPE-UC (WS-UNMTRD-CNSMPTN-INDX) =          
A02533                                  WS-CODE-UTIL-TYPE-BG (SUB1) AND 
A02533         WS-IC-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                     
A02533                                 = WS-IC-NO-BG (SUB1) AND         
A02533         WS-BILL-ITEM-TIMESTMP-UC (WS-UNMTRD-CNSMPTN-INDX) =      
A02533                                   WS-BILL-ITEM-TIMESTMP-BG (SUB1)
A02533         IF WS-NO-DAYS-UC (WS-UNMTRD-CNSMPTN-INDX)                
A02533                                 > WS-GASLITE-DAYS                
A02533            MOVE WS-NO-DAYS-UC (WS-UNMTRD-CNSMPTN-INDX)           
A02533                                          TO WS-GASLITE-DAYS      
A02533            MOVE 'Y'                      TO WS-GASLITE-DATA      
A02533            MOVE WS-DATE-USAGE-ENDS-UC(WS-UNMTRD-CNSMPTN-INDX)    
A02533                                          TO WS-UNFORMAT-DATE     
A02533            MOVE SPACES                   TO WS-ENGLISH-DATE      
A02533            MOVE WS-UNFORMAT-DATE(9:2)    TO WS-ENGLISH-DD        
A02533            PERFORM 4000-ENGLISH-MONTH THRU 4000-EXIT             
A02533            MOVE WS-ENGLISH-DATE          TO WS-GASLITE-END-DATE  
A02533            MOVE WS-DATE-USAGE-ENDS-UC(WS-UNMTRD-CNSMPTN-INDX)    
A02533                                          TO WS-END-DATE          
A02533                                      WS-GASLITE-END-DATE-NUM     
A02533         END-IF                                                   
A02533      END-IF                                                      
A02533     END-PERFORM.                                                 
T5193                                                                   
T5193      MOVE WS-GASLITE-DAYS TO WS-CALC-NO-DAYS.                     
T5193      EXEC SQL                                                     
T35434          SELECT
              DATEADD( DAY, -:WS-CALC-NO-DAYS, IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) )
            INTO
              :WS-CALC-START-DATE         
T5193      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     07750000
MFA-TR*         SET :WS-CALC-START-DATE =                               07781000
MFA-TR*              DATE(:WS-END-DATE) - :WS-CALC-NO-DAYS DAYS         07782000
MFA-TR*    END-EXEC.                                                    07790000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T5193      IF SQLCODE NOT = SUCCESSFUL-CALL                             
T5193          MOVE 'C' TO WS-BILL-DEST-CODE                            
T5193          MOVE '4' TO WS-SYSTEM-CNTRL-CODE                         
A02003         MOVE SPACES TO WS-CALC-START-DATE                        
A02003     END-IF.                                                      
T5193                                                                   
T35152     MOVE WS-CALC-START-DATE TO WS-UNFORMAT-DATE                  
T35152                                WS-GASLITE-ST-DATE-NUM.           
T5193      MOVE SPACES TO WS-ENGLISH-DATE.                              
T5193      MOVE WS-UNFORMAT-DATE(9:2) TO WS-ENGLISH-DD.                 
T5193      PERFORM 4000-ENGLISH-MONTH THRU 4000-EXIT.                   
T5193      MOVE WS-ENGLISH-DATE TO WS-GASLITE-ST-DATE.                  
T5193      MOVE WS-CODE-UTIL-TYPE-BG (SUB1) TO                          
T5193           WS-GASLITE-UTIL-TYPE.                                   
T5193      MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO                           
T5193           WS-GASLITE-TOTAL.                                       
T5193      COMPUTE WS-GASLITE-CURR-COST =                               
T5193              WS-GASLITE-CURR-COST +                               
T5193              WS-AMT-BILL-ITEM-BG (SUB1) -                         
T5193              WS-AMT-STATE-TAX-BG (SUB1).                          
T5193      MOVE ZEROES TO WS-GASLITE-TOTAL-CALC.                        
I00323     MOVE 1 TO WS-GASLITE-SUB.                                    
I00323************************************************************      08107000
I00323* POPULATE BASIC FACILITY CHARGES                          *      08108000
I00323************************************************************      08109000
A02533     MOVE 1 TO WS-GASLITE-CHG-SUB.                                
A02533     PERFORM VARYING WS-BILL-ADJ-INDX FROM 1 BY 1                 
A02533             UNTIL WS-BILL-ADJ-INDX > WS-BA-MAX-ENTRY             
A02533             OR WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX) = ZEROES      
A02533        IF WS-ACCOUNT-NO-BG (SUB1) =                              
A02533                          WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX) AND 
A02533           WS-BILL-NO-BG (SUB1) =                                 
A02533                          WS-BILL-NO-BA (WS-BILL-ADJ-INDX) AND    
A02533           WS-CODE-UTIL-TYPE-BG (SUB1) =                          
A02533                       WS-CODE-UTIL-TYPE-BA (WS-BILL-ADJ-INDX) AND
A02533           WS-IC-NO-BG (SUB1) = WS-IC-NO-BA (WS-BILL-ADJ-INDX) AND
A02533           WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
A02533                  WS-BILL-ITEM-TIMESTMP-BA (WS-BILL-ADJ-INDX) AND 
A02533           WS-FACTOR-ID-BA (WS-BILL-ADJ-INDX) = 'BFACCHRG'        
I00323             MOVE 'Basic Facilities Charge' TO                    
I00323               WS-GASLITE-CHG-MSG (WS-GASLITE-SUB                 
I00323                                   WS-GASLITE-CHG-SUB)            
I00323             COMPUTE WS-ROUNDED-BFC ROUNDED =                     
A02533                     WS-AMT-ADJUSTMENT-BA (WS-BILL-ADJ-INDX) * 1  
I00323               MOVE WS-ROUNDED-BFC TO                             
I00323                    WS-GASLITE-CHG-AMT (WS-GASLITE-SUB            
I00323                                        WS-GASLITE-CHG-SUB)       
A02533               ADD WS-AMT-ADJUSTMENT-BA (WS-BILL-ADJ-INDX) TO     
I00323                   WS-GASLITE-TOTAL-CALC                          
I00323               ADD 1 TO WS-GASLITE-CHG-SUB                        
I00323         END-IF                                                   
I00323     END-PERFORM.                                                 
I00323                                                                  
T5193      PERFORM 2300-GASLITE-CHARGES THRU 2300-EXIT.                 
T5193      IF WS-AMT-CITY-TAX-BG (SUB1) > ZEROES                        
T30013     AND WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S'                    
T5193          MOVE SPACES TO WS-FORMAT-MESSAGE                         
T5193          COMPUTE WS-COMPUTE-PCT =                                 
T5193                  WS-FRANCHISE-TX-RATE-CALC (SUB1) * 100           
T5193          MOVE WS-COMPUTE-PCT TO WS-DISPLAY-PCT                    
T29598         IF (CSR-DATABASE                                         
T29598         AND WS-COMPANY-NO-AT = '01')                             
T29598            MOVE SPACES TO WS-REV-INPUT                           
T29598                           WS-REV-TABLE                           
T29598            MOVE 35 TO WS-REV-LENG                                
T29598            MOVE WS-REV-DISTRICT-CD-PR TO A9-REV-DISTRICT-CD      
T29598            PERFORM 6500-GET-REV-DIST-DESC THRU 6500-EXIT         
T29598            STRING 'Franchise Fee '                               
T29598                   WS-DISPLAY-PCT                                 
T29598                   '% paid to the '                               
T29598                   WS-REV-TABLE                                   
T29598                   DELIMITED BY SIZE                              
T29598                   INTO WS-FORMAT-MESSAGE                         
T29598            MOVE 75 TO WS-EMB-LENG                                
T29598         ELSE                                                     
T5193             STRING 'Franchise Fee - '                             
T5193                    WS-DISPLAY-PCT                                 
T5193                    '%'                                            
T5193                    DELIMITED BY SIZE                              
T5193                    INTO WS-FORMAT-MESSAGE                         
T5193             MOVE 23 TO WS-EMB-LENG                                
T29598         END-IF                                                   
T5193          MOVE SPACES TO WS-EMB-INPUT                              
T5193                        WS-CMP-TABLE                               
T5193          MOVE WS-FORMAT-MESSAGE TO WS-EMB-INPUT                   
T5193          PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT       
T5193          MOVE WS-CMP-TABLE TO WS-GASLITE-FRAN-MSG                 
T5193          ADD WS-AMT-CITY-TAX-BG (SUB1) TO WS-GASLITE-FRAN-AMT     
T5193          ADD WS-AMT-CITY-TAX-BG (SUB1) TO WS-GASLITE-TOTAL-CALC
           END-IF.  
T5193      ADD WS-AMT-STATE-TAX-BG (SUB1) TO WS-GASLITE-TOTAL-CALC.     
I00323     MOVE WS-IC-NO-BG (SUB1) TO                                   
I00323                       WS-GASLITE-IC-NO (WS-GASLITE-SUB).         
I00323     MOVE WS-RATE-PLAN-NO-BG (SUB1) TO                            
I00323                       WS-GASLITE-RATE (WS-GASLITE-SUB).          
I00323     MOVE 'Lighting Service' TO                                   
I00323                       WS-GASLITE-DESC (WS-GASLITE-SUB).          
T5193                                                                   
T5193      IF WS-GASLITE-TOTAL NOT = WS-GASLITE-TOTAL-CALC              
T5193          MOVE 'C' TO WS-BILL-DEST-CODE                            
T5193          MOVE 'X' TO WS-SYSTEM-CNTRL-CODE                         
A02003     END-IF.                                                      
T5193                                                                   
T5193                                                                   
T5193  2000-EXIT.                                                       
T5193      EXIT.                                                        
T5193                                                                   
T5193 ************************************************************      08440000
T5193 *  PROCESS ALL BILL ADJUSTMENTS AND CALCULATIONS           *      08450000
T5193 *  (UNMETERED).  GET THE DESCRIPTION.  THIS DATA WILL      *      08460000
T5193 *  ACCUMULATE IN THE UNMETERED WORKING STORAGE TABLE.      *      08470000
T5193 ************************************************************      08480000
T5193                                                                   
T5193  2300-GASLITE-CHARGES.                                            
T5193                                                                   
A02533     PERFORM VARYING WS-CALC-INDX FROM 1 BY 1                     
A02533             UNTIL WS-CALC-INDX > WS-BZ-MAX-ENTRY                 
A02533                OR WS-ACCOUNT-NO-BC (WS-CALC-INDX) = ZEROES       
A02533        IF WS-ACCOUNT-NO-BG (SUB1)                                
A02533                  = WS-ACCOUNT-NO-BC (WS-CALC-INDX) AND           
A02533           WS-BILL-NO-BG (SUB1)                                   
A02533                  = WS-BILL-NO-BC (WS-CALC-INDX) AND              
A02533           WS-CODE-UTIL-TYPE-BG (SUB1) =                          
A02533                       WS-CODE-UTIL-TYPE-BC (WS-CALC-INDX) AND    
A02533           WS-IC-NO-BG (SUB1) = WS-IC-NO-BC (WS-CALC-INDX) AND    
A02533           WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
A02533                       WS-BILL-ITEM-TIMESTMP-BC (WS-CALC-INDX)    
A02533           MOVE 1 TO WS-GASLITE-SUB                               
A02533           PERFORM 2400-BUILD-GASLITE-TABLE THRU 2400-EXIT        
A02533        END-IF                                                    
T5193      END-PERFORM.                                                 
T5193                                                                   
T5193  2300-EXIT.                                                       
T5193      EXIT.                                                        
T5193                                                                   
T5193 ************************************************************      08700000
T5193 *  ACCUMULATE DESCRIPTIONS AND CHARGES INTO THE WORKING    *      08710000
T5193 *  STORAGE TABLE.                                          *      08720000
T5193 ************************************************************      08730000
T5193                                                                   
T5193  2400-BUILD-GASLITE-TABLE.                                        
T5193                                                                   
A02533     ADD WS-READ-UNITS-BC (WS-CALC-INDX) TO WS-GASLITE-USAGE.     
T5193      IF WS-GASLITE-DESC (WS-GASLITE-SUB) = SPACES                 
A02533         MOVE WS-READ-UNITS-BC (WS-CALC-INDX) TO WS-DISPLAY-CCF   
A02533         MOVE WS-NET-UNITS-BC (WS-CALC-INDX) TO WS-DISPLAY-THERMS 
T5193          MOVE WS-BTU-FACTOR-BG (SUB1) TO WS-DISPLAY-FACTOR        
A02533         SET WS-HOLD-CALC-INDX       TO  WS-CALC-INDX             
P00496         MOVE SPACES TO WS-PREV-FACTOR                            
I00323         PERFORM 3600-GET-FACTORS THRU 3600-EXIT                  
A02533         SET WS-CALC-INDX            TO WS-HOLD-CALC-INDX         
I00323         MOVE 1 TO WS-GASLITE-CHG-SUB                             
I00323         PERFORM 1320-DETERMINE-CHG-SUB THRU 1320-EXIT            
I00323         MOVE 1 TO WS-HOLD-FACTOR-SUB                             
P00496         PERFORM UNTIL WS-HOLD-FACTOR-SUB > 50 OR                 
P00496             WS-HOLD-FACTOR-FLAG(WS-HOLD-FACTOR-SUB) = SPACES     
I00323           MOVE WS-HOLD-FACTOR-DESC (WS-HOLD-FACTOR-SUB) TO       
I00323                WS-GASLITE-CHG-MSG (WS-GASLITE-SUB                
I00323                                    WS-GASLITE-CHG-SUB)           
I00323           MOVE WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO        
I00323                WS-GASLITE-CHG-AMT (WS-GASLITE-SUB                
I00323                                    WS-GASLITE-CHG-SUB)           
I00323           ADD WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO         
I00323               WS-GASLITE-TOTAL-CALC                              
I00323           ADD 1 TO WS-GASLITE-CHG-SUB                            
I00323                    WS-HOLD-FACTOR-SUB                            
I00323         END-PERFORM                                              
I00323                                                                  
I00323         PERFORM 1320-DETERMINE-CHG-SUB THRU 1320-EXIT            
I00323         IF WS-COMPANY-NO-AT = '26'                               
I00323         MOVE 'Outdoor Lighting Service' TO                       
I00323          WS-GASLITE-CHG-MSG (WS-GASLITE-SUB WS-GASLITE-CHG-SUB)  
I00323         ELSE                                                     
I00323         MOVE 'Subdivision Gas Lighting' TO                       
I00323          WS-GASLITE-CHG-MSG (WS-GASLITE-SUB WS-GASLITE-CHG-SUB)  
I00323         END-IF                                                   
A02533         MOVE WS-CALC-COMPONENT-AMT-BC (WS-CALC-INDX) TO          
I00323              WS-GASLITE-CHG-AMT (WS-GASLITE-SUB                  
I00323                                  WS-GASLITE-CHG-SUB)             
A02533         ADD  WS-CALC-COMPONENT-AMT-BC (WS-CALC-INDX) TO          
I00323              WS-GASLITE-TOTAL-CALC                               
T5193          GO TO 2400-EXIT
           END-IF.                                         
T5193      ADD 1 TO WS-GASLITE-SUB.                                     
T5193      IF WS-GASLITE-SUB > 100                                      
T5193          MOVE 12 TO RETURN-CODE                                   
T5193          MOVE 'OVER 100 GASLITE' TO                               
T5193               WS-MISC-MSG-TEXT                                    
T5193          MOVE +16 TO WS-MISC-MSG-LEN                              
T5193          PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
T5193          PERFORM 9999-BAIL-OUT THRU 9999-EXIT
           END-IF.                    
T5193      GO TO 2400-BUILD-GASLITE-TABLE.                              
T5193                                                                   
T5193  2400-EXIT.                                                       
T5193      EXIT.                                                        
                                                                        
T8820  3000-CHECK-FOR-PRORATE.                                          
                                                                        
A02533     PERFORM VARYING WS-BILL-ADJ-INDX FROM 1 BY 1                 
A02533             UNTIL WS-BILL-ADJ-INDX  > 100                        
A02533             OR WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX) = ZEROES      
A02533      IF WS-ACCOUNT-NO-BG (SUB1)                                  
A02533                         = WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX)    
A02533         AND WS-BILL-NO-BG (SUB1)                                 
A02533                         = WS-BILL-NO-BA (WS-BILL-ADJ-INDX)       
A02533         AND WS-CODE-UTIL-TYPE-BG (SUB1) =                        
A02533                        WS-CODE-UTIL-TYPE-BA (WS-BILL-ADJ-INDX)   
A02533         AND WS-IC-NO-BG (SUB1)                                   
A02533                        = WS-IC-NO-BA (WS-BILL-ADJ-INDX)          
A02533         AND WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                    
A02533                       WS-BILL-ITEM-TIMESTMP-BA (WS-BILL-ADJ-INDX)
A02533         IF WS-FACTOR-BA (WS-BILL-ADJ-INDX) > 0                   
A02533            EVALUATE WS-FACTOR-ID-BA (WS-BILL-ADJ-INDX)           
T8820                      WHEN 'SNPROPCT'                              
T8820                      WHEN 'S2PROPCT'                              
T8820                      WHEN 'NSPROPCT'                              
T8820                      WHEN 'N2PROPCT'                              
T8820                      MOVE 'Y' TO WS-SEASONAL-PRORATE              
T8820                      WHEN 'RTPROPCT'                              
T8820                            MOVE 'Y' TO WS-VERSION-PRORATE         
T8820             END-EVALUATE                                          
T8820          END-IF                                                   
T8820       END-IF                                                      
T8820      END-PERFORM.                                                 
                                                                        
T8820  3000-EXIT.                                                       
T8820      EXIT.                                                        
                                                                        
T12827************************************************************      09610000
T20121*  3600-GET-FACTORS                                        *      09620000
T20121*  3610-ADJUSTMENTS                                        *      09630000
T20121*  3620-FORMAT-FACTORS                                     *      09640000
T20121*  3630-BUILD-FACTOR-TABLE                                 *      09650000
T20121************************************************************      09660000
T20121                                                                  
T20121     EXEC SQL                                                     09680000
T20121         INCLUDE CPD00095                                         09690000
T20121     END-EXEC.                                                    09700000
                                                                        
T12827************************************************************      09720000
T12827*  3700-NONE-CALC.                                         *      09730000
T12827************************************************************      09740000
T12827                                                                  
T12827     EXEC SQL                                                     09760000
T12827         INCLUDE CPD00097                                         09770000
T12827     END-EXEC.                                                    09780000
                                                                        
      ************************************************************      09800000
      *  4000-ENGLISH-MONTH                                      *      09810000
      *  4010-COUNT-DAYS                                         *      09820000
      ************************************************************      09830000
                                                                        
           EXEC SQL                                                     09850000
               INCLUDE CPD00200                                         09860000
           END-EXEC.                                                    09870000
                                                                        
      ************************************************************      09890000
      *  6010-REDUCE-EMBEDDED-SPACES                             *      09900000
      ************************************************************      09910000
                                                                        
       COPY CPD00004.                                                   09930000
                                                                        
T29598************************************************************      09950000
T29598*  6500-GET-REV-DIST-DESC                                  *      09960000
T29598************************************************************      09970000
T29598                                                                  
T29598     EXEC SQL                                                     09981000
T29598         INCLUDE CPD00500                                         09982000
T29598     END-EXEC.                                                    09983000
T29598                                                                  
T29598************************************************************      09985000
T29598*  8895-INSERT-WORK-QUEUE                                  *      09986000
T29598************************************************************      09987000
A04860*                                                                 09987100
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860                                                                  
A04860     MOVE PROGRAM-NAME            TO WS-77-CREATED-BY.            
A04860                                                                  
A04860     MOVE SPACES TO ABEND-FUNCTION.                               
A04860                                                                  
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
T29598                                                                  
T29598************************************************************      09989400
T29598*  9700-PROCESS-ABEND                                      *      09989500
T29598************************************************************      09989600
T29598                                                                  
T29598 9700-PROCESS-ABEND.                                              
T29598     DISPLAY ' 8895-INSERT-WORK-QUEUE '.                          
T29598     DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'.              
A04860     DISPLAY ' ** ERROR ON INSERT CSS_WQ_ITEMS'.                  
T29598     DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE.            
A04860     DISPLAY ' ** ACCOUNT NO = ' WS-77-ACCOUNT-NO.                
T29598     MOVE 12 TO RETURN-CODE.                                      
T29598     PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
T29598 9700-EXIT.                                                       
T29598     EXIT.                                                        
T29598                                                                  
       9900-SQL-ERROR.                                                  
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
           END-IF.                                                      
                                                                        
           MOVE WS-DATABASE-EXCEPTION                                   
             TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)           
                                                                        
           COMPUTE WS-START-POS                                         
             = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1                 
           MOVE WS-SQL-ERROR-TXT-WQ                                     
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)   
           ADD WS-SQL-ERROR-TXT-LEN-WQ                                  
             TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                   
ACT071     MOVE WS-PGRMNAME                                             
ACT071       TO WS-CREATED-BY-WF (WS-BILL-WQ-INDX).                     
                                                                        
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       9900-SQL-EXIT.                                                   
           EXIT.                                                        
                                                                        
       9910-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
ACT071        MOVE WS-PGRMNAME                                          
ACT071          TO WS-CREATED-BY-WF (WS-BILL-WQ-INDX)                   
           END-IF.                                                      
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-BAIL-OUT.                                                   
                                                                        
T8312      MOVE RETURN-CODE TO WS-SCSCA-RETURN-CODE.                    
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
