       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA173.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      ** SCSCA173 FORMATS UNMETERED, MUNICIPAL LIGHT RATES AND       **         
      ** CHARGES FOR BILL PRINT.  THIS PROGRAM IS CALLED FROM        **         
      ** PCSCA166 WHEN THE BILL FORMAT CODE IS '04'.                 **         
      **                                                             **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    08/95    FB        PRELIMINARY VERSION                    **         
      *    12/95    FB        CHANGE PROGRAM TO BREAK ON IC          **         
      *    01/96    FB        CSF REWRITE                            **         
      *    03/96    FB        GET CORRECT EQUIPMENT DESCRIPTION      **         
      *    05/96    FB        TPR 4049, 4047                         **         
      *    06/96    FB        TPR 4601                               **         
      *    03/97    KB        TPR 9592 PRINT FRANCHISE FEE FOR       **         
      *                                MUNICIPAL LIGHTS              **         
      *    05/97    Kdf       TPR10739   change work queue cat field **         
      *                                  from +17 to +21 for all     **         
      *                                  bill print pgms.            **         
      *    06/97    PB        TPR 8820  Proration                    **         
      *    06/97    FB        TPR 11731                              **         
      *    08/97    PB        TPR 12523 Add days to prorate check    **         
      *    08/97    FB        TPR 12827                              **         
T15113*    03/98    KDF       TPR 15113   COMPUTE AMT-BG FOR NEG AMT.**         
      *    04/98    PB        TPR 15988 Charges for Muni lights      **         
T15557*    05/98    KDF       TPR 15557   EXCLUDE TAX CALCULATION    **         
T15557*                                   FOR NONE-CALC              **         
T17308*    08/98    KDF       TPR 17308   Consolidated Landscape     **         
T28305*    02/03    JDW       CML 28305 Add code to display charges  **         
T28305*                                 for rate versio prorated     **         
T28305*                                 bills.                       **         
T28478*    03/03    JDW       CML 28478 Check Factor ID for numeric  **         
T28478*                                 data before checking for     **         
T28478*                                 prorate.                     **         
T28734*    04/03    SV82012   CML 28734 Pull Adjustment Reasons for  **         
T28734*                                 for Non-calcs from DB2 Table.**         
T29598*    10/03    ESM       CML 29598   Franchise Fee verbiage     **         
T35434*    05/07    RV97439   CML 35434 Replace model_sql with       **         
T35434*                                 set statement                **         
T31511*    05/07    RV97439   CML 31511 To print facility charge on  **         
T31511*                                 bills                        **         
T35152*    08/08    RV97439   CML 35152 BILL REDESIGN CHANGES.       **         
I00177*    01/09    RV97439   REMOVE INDEX HARDCODING FOR BC, UM, UC,**         
I00177*                       CT, EA, CL, DA, DV, AC, BZ, CP TABLES. **         
A02003*    09/10    DMS       REMOVE XFOOT WQ GENERATION.            **         
A02003*    10/10    DMS       CLEAN UP WQ GENERATION                 **         
A04860**   02/15    AS7C117   REPLACE CSS_WQ_ITEMS_MF WITH            *         
A04860**            ACT065    CSS_WQ_ITEMS.                           *         
ACT071**   16/03/15 SS7F226   ADD CREATED-BY FIELD LOGIC IN WF AREA.  *         
ACT071**             A04860                                           *         
I01959**   08/31/15 SV95326   RATE PLAN AND DESCRIPTION GETS FROM    **         
I01959**                      BILL_LITERAL_TX FROM CSS_RATE_PLAN_DESC**         
I01959**                      TABLE.                                 **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
                                                                        
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA173'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-MISC.                                                     
           05  SUB2                         PIC 9(3) VALUE 0.           
           05  SUB3                         PIC 9(3) VALUE 0.           
T28734     05  WS-HOLD-NONECALC-LITERAL     PIC X(255).                 
T28734     05  WS-NC-SUB                    PIC S9(4) COMP.             
T8820      05  WS-SEASONAL-PRORATE          PIC X    VALUE 'N'.         
T8820      05  WS-VERSION-PRORATE           PIC X    VALUE 'N'.         
COB305     05 WS-HOLD-AMT-BILL-ITEM        PIC S9(9)V99 COMP-3 VALUE 0.        
           05  WS-NULL-IND-1                PIC S9(4) COMP.             
           05  WS-EQUIP-DESC                PIC X.                      
T17308     05  WS-START-DATE                PIC X(10).                  
T17308     05  WS-CHECK-MM                  PIC XX.                     
           05  WS-CALC-START-DATE           PIC X(10).                  
T17308     05  WS-UNFORMAT-DATE             PIC X(10).                  
T17308     05  WS-FORMAT-DATE.                                          
T17308         10  WS-FORMAT-MM             PIC XX.                     
T17308         10  F                        PIC X VALUE '/'.            
T17308         10  WS-FORMAT-DD             PIC XX.                     
T17308         10  F                        PIC X VALUE '/'.            
T17308         10  WS-FORMAT-YY             PIC XX.                     
T17308     05  WS-ENGLISH-DATE.                                         
T17308         10  WS-ENGLISH-MM            PIC XXX.                    
T17308         10  F                        PIC X VALUE ' '.            
T17308         10  WS-ENGLISH-DD            PIC XX.                     
           05  WS-END-DATE                  PIC X(10).                  
           05  WS-CALC-NO-DAYS              PIC S9(9) COMP.             
           05  WS-DISPLAY-DAYS              PIC 9(9).                   
           05  WS-USAGE-FIXED               PIC S9(9)V99 VALUE 0.       
           05  WS-USAGE-DISPLAY             PIC -Z(8)9.99.              
           05  WS-START-POS                 PIC S9(4) COMP.             
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER                  PIC S9(4) COMP VALUE +121.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +29.    
               10  FILLER                  PIC X(30) VALUE              
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  FILLER                  PIC S9(4) COMP VALUE +121.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  WS-MISC-MSG-LEN         PIC S9(4) COMP VALUE +250.   
               10  WS-MISC-MSG-TEXT        PIC X(250).                  
TP9592     05  WS-CHARGES-MESSAGE-FIELDS.                               
TP9592         10  WS-FORMAT-MESSAGE        PIC X(75).                  
TP9592         10  WS-DISPLAY-PCT           PIC -ZZ.99.                 
TP9592         10  WS-COMPUTE-PCT           PIC S9(3)V99.               
T29598     05  RS-RETURN-CODE               PIC S9(4) COMP.             
T29598     05  WS-CURRENT-DATE              PIC X(10) VALUE SPACES.     
T29598     05  WS-RUN-DATE                  PIC X(10) VALUE SPACES.     
T31511     05  WS-HOLD-BASIC-FACILITY       PIC S9(9)V99 VALUE 0.       
T31511     05  WS-ROUNDED-BFC               PIC S9(9)V99 VALUE 0.       
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC  X(08) VALUE 'SCSCA173'.     
T29598     05  PROGRAM-NAME            PIC  X(08) VALUE 'SCSCA173'.     
A04860     05  SCSCB077                PIC  X(08) VALUE 'SCSCB077'.     
                                                                        
      *  SUPPLEMENTAL WORK QUEUE FIELDS                                         
       COPY CWS0070B.                                                           
      *  FIELDS USED IN DB2/SQL ERROR CHECKING                                  
       COPY CWS00303.                                                           
      *  ABEND FIELDS                                                           
       COPY CWS00010.                                                           
      *  FIELDS USED TO REDUCE EMBEDDED BLANKS                                  
       COPY CWS00011.                                                           
T29598*  FIELDS USED TO REMOVE PARENS                                           
T29598 COPY CWS00500.                                                           
      *  ABEND SWITCH                                                           
       COPY CWS09900.                                                           
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *  RATE CREATOR TABLE                                                     
           EXEC SQL                                                             
               INCLUDE TBRTCRTR                                                 
           END-EXEC.                                                            
      *  UNMETERED PLAN TABLE                                                   
           EXEC SQL                                                             
               INCLUDE TBUMPLAN                                                 
           END-EXEC.                                                            
      *  UNMETERED EQUIPMENT TABLE                                              
           EXEC SQL                                                             
               INCLUDE TBUMEQP                                                  
           END-EXEC.                                                            
T29598*********************************************************                 
T29598*          INCLUDE THE DCLGEN FOR CSS_REV_DISTRICT      *                 
T29598*********************************************************                 
T29598     EXEC SQL                                                             
T29598          INCLUDE TBRVDST                                                 
T29598     END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
      *  BILLING EXTRACT FILE                                                   
      *  SPLIT CWS10000 INTO 2 COPYBOOKS                                        
       COPY CWS1000A.                                                           
       COPY CWS1000B.                                                           
      *  BILLING EXTRACT FILE                                                   
       COPY CWS10009.                                                           
       01  SUB1                         PIC 9(3).                       
       01  WS-SCSCA-RETURN-CODE         PIC S9(4) comp.                 
      *  MUNICIPAL LIGHT FIELDS                                                 
       COPY CWS00084.                                                           
      *  WORK QUEUE FIELDS                                                      
       COPY CWS0024B.                                                           
T28734*  NONECALC FIELDS                                                        
T28734 COPY CWS00097.                                                           
                                                                        
       PROCEDURE DIVISION USING WS-ACCOUNT-AT                           
T29598                          WS-PREMISE-PR                           
                                WS-BILLING-BG                           
                                WS-BILL-ADJUST-DETAIL                   
                                WS-BILL-CALC-DETAIL                     
                                WS-UNMTRD-CNSMPTN-UC                    
                                WS-MISC-BILL-INFO                       
                                SUB1                                    
T28734                          WS-NONCALC-LITERALS                     
T8312                           WS-SCSCA-RETURN-CODE                    
                                LS-PCSCA100-COMM-AREA                   
                                WS-BILLING-WQ-ITEMS-WF                  
                                WS-BILLING-BI                           
T30187                          WS-BILL-ADJUSTMNT                       
I00177                          WS-MUNI-LIGHTS-BILL-PRINT               
I00177                          WS-CWS1000B-MAX-TBL-LIMITS.             
                                                                        
      ************************************************************              
      *  PROGRAM IS CALLED FROM PCSCA166.  UNMETERED MUNICIPAL   *              
      *  RATE DATA IS FORMATTED FOR CSF.  TOTALS ARE COMPARED;   *              
      *  IF THEY DO NOT MATCH, A CROSSFOOT ERROR IS GENERATED.   *              
      *  NO HISTORICAL DATA IS ACCUMULATED FOR UNMETERED RATES.  *              
      ************************************************************              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           DISPLAY 'SCSCA173 - MUNICIPAL LIGHTS'.                       
T31511     INITIALIZE       WS-HOLD-BASIC-FACILITY.                     
           MOVE 1 TO WS-MUNI-RATE-SUB.                                  
T28305     MOVE 'N' TO WS-VERSION-PRORATE                               
T28305                 WS-SEASONAL-PRORATE.                             
           PERFORM 1000-LOCATE-TABLE THRU 1000-EXIT.                    
T15557     IF WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S'                     
P00496       PERFORM 1400-CHECK-FOR-PRORATE THRU 1400-EXIT              
P00496       PERFORM 1100-UNMETERED-CHARGES THRU 1100-EXIT              
P00496       PERFORM 1010-GET-DAYS-DATE THRU 1010-EXIT                  
             ADD WS-AMT-STATE-TAX-BG (SUB1) TO                          
                 WS-MUNI-TOTAL-CALC (WS-MUNI-RATE-SUB)                  
T4047        ADD WS-AMT-CITY-TAX-BG (SUB1) TO                           
T4047            WS-MUNI-TOTAL-CALC (WS-MUNI-RATE-SUB)                  
T9592        IF WS-AMT-CITY-TAX-BG (SUB1) > ZEROES                      
T9592           MOVE SPACES TO WS-FORMAT-MESSAGE                        
T9592           COMPUTE WS-COMPUTE-PCT =                                
T9592                    WS-FRANCHISE-TX-RATE-CALC (SUB1) * 100         
T9592           MOVE WS-COMPUTE-PCT   TO   WS-DISPLAY-PCT               
T29598          IF (CSR-DATABASE                                        
T29598          AND WS-COMPANY-NO-AT = '01')                            
T29598             MOVE SPACES TO WS-REV-INPUT                          
T29598                            WS-REV-TABLE                          
T29598             MOVE 35 TO WS-REV-LENG                               
T29598             MOVE WS-REV-DISTRICT-CD-PR TO A9-REV-DISTRICT-CD     
T29598             PERFORM 6500-GET-REV-DIST-DESC THRU 6500-EXIT        
T29598             STRING 'Franchise Fee '                              
T29598                    WS-DISPLAY-PCT                                
T29598                    '% paid to the '                              
T29598                    WS-REV-TABLE                                  
T29598                    DELIMITED BY SIZE                             
T29598                    INTO WS-FORMAT-MESSAGE                        
T29598             MOVE 75 TO WS-EMB-LENG                               
T29598          ELSE                                                    
T9592              STRING 'FRANCHISE FEE - '                            
T9592                     WS-DISPLAY-PCT                                
T9592                     '%'                                           
T9592                     DELIMITED BY SIZE                             
T9592                     INTO WS-FORMAT-MESSAGE                        
T9592              MOVE 23  TO   WS-EMB-LENG                            
T29598          END-IF                                                  
T9592           MOVE SPACES TO  WS-EMB-INPUT                            
T9592                             WS-CMP-TABLE                          
T9592           MOVE WS-FORMAT-MESSAGE TO   WS-EMB-INPUT                
T9592           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT      
T9592           MOVE WS-CMP-TABLE   TO                                  
T9592                 WS-MUNI-FRAN-MSG (WS-MUNI-RATE-SUB)               
T9592           MOVE WS-AMT-CITY-TAX-BG (SUB1) TO                       
T9592                 WS-MUNI-FRAN-AMT (WS-MUNI-RATE-SUB)               
P00496     END-IF
           END-IF.                                                      
                                                                        
T12827     IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                         
T12827         PERFORM 3700-NONE-CALC THRU 3700-EXIT                    
T12827         MOVE WS-HOLD-NONECALC-LITERAL TO                         
T12827              WS-MUNI-NONECALC-MSG (WS-MUNI-RATE-SUB)             
T12827         IF WS-CODE-DR-CR-CNSMPTN-BG (SUB1) = 'C'                 
T12827             COMPUTE WS-MUNI-NONECALC-AMT (WS-MUNI-RATE-SUB) =    
T12827                 WS-AMT-BILL-ITEM-BG (SUB1) * -1                  
T12827         ELSE                                                     
T12827             MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO                   
T12827                  WS-MUNI-NONECALC-AMT (WS-MUNI-RATE-SUB)         
T12827         END-IF                                                   
T12827         ADD WS-MUNI-NONECALC-AMT (WS-MUNI-RATE-SUB) TO           
T12827             WS-MUNI-TOTAL-CALC (WS-MUNI-RATE-SUB)
           END-IF.               
T12827                                                                  
           IF WS-MUNI-TOTAL (WS-MUNI-RATE-SUB) NOT =                    
              WS-MUNI-TOTAL-CALC (WS-MUNI-RATE-SUB)                     
                  MOVE 'C' TO WS-BILL-DEST-CODE                         
                  MOVE 'X' TO WS-SYSTEM-CNTRL-CODE                      
A02003     END-IF.                                                      
                                                                        
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  GET POSITION IN THE MUNI LIGHTS WORKING STORAGE TABLE.  *              
      *  IF THE RATE EXISTS, ADD CHARGES TO IT.  IF NOT, CREATE  *              
      *  IT IN THE TABLE.                                        *              
      ************************************************************              
                                                                        
       1000-LOCATE-TABLE.                                               
                                                                        
T15113                                                                  
T15113     IF WS-CODE-DR-CR-CNSMPTN-BG (SUB1) = 'C'                     
T15113        COMPUTE WS-HOLD-AMT-BILL-ITEM =                           
T15113              WS-AMT-BILL-ITEM-BG (SUB1) * -1                     
T15113     ELSE                                                         
T15113        MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO                        
T15113             WS-HOLD-AMT-BILL-ITEM                                
T15113     END-IF                                                       
           IF WS-MUNI-LIGHT-PLAN (WS-MUNI-RATE-SUB) =                   
#4601         WS-RATE-PLAN-NO-BG (SUB1) AND                             
              WS-MUNI-LIGHT-IC-NO (WS-MUNI-RATE-SUB) =                  
              WS-IC-NO-BG (SUB1)                                        
                  ADD WS-HOLD-AMT-BILL-ITEM      TO                     
                      WS-MUNI-TOTAL (WS-MUNI-RATE-SUB)                  
T15557            IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                  
                    COMPUTE WS-MUNI-CURR-COST (WS-MUNI-RATE-SUB) =      
                            WS-MUNI-CURR-COST (WS-MUNI-RATE-SUB) +      
                            WS-HOLD-AMT-BILL-ITEM                       
                  ELSE                                                  
                    COMPUTE WS-MUNI-CURR-COST (WS-MUNI-RATE-SUB) =      
                            WS-MUNI-CURR-COST (WS-MUNI-RATE-SUB) +      
                            WS-HOLD-AMT-BILL-ITEM      -                
                            WS-AMT-STATE-TAX-BG (SUB1)                  
                  END-IF                                                
                  GO TO 1000-EXIT
           END-IF.                                      
           IF WS-MUNI-LIGHT-PLAN (WS-MUNI-RATE-SUB) = SPACES            
#4601             MOVE WS-RATE-PLAN-NO-BG (SUB1) TO                     
                       WS-MUNI-LIGHT-PLAN (WS-MUNI-RATE-SUB)            
                  MOVE WS-IC-NO-BG (SUB1) TO                            
                       WS-MUNI-LIGHT-IC-NO (WS-MUNI-RATE-SUB)           
                  MOVE WS-RATE-DESCRIPTION-CALC (SUB1) TO               
                       WS-MUNI-LIGHT-PLAN-DESC (WS-MUNI-RATE-SUB)       
I01959            MOVE WS-BILL-LITTERAL-TX-CALC (SUB1) TO               
I01959                 WS-MUNI-LIGHT-BILL-LITERAL-TX (WS-MUNI-RATE-SUB) 
                  MOVE WS-CODE-UTIL-TYPE-BG (SUB1) TO                   
                       WS-MUNI-UTIL-TYPE (WS-MUNI-RATE-SUB)             
                  MOVE WS-HOLD-AMT-BILL-ITEM      TO                    
                       WS-MUNI-TOTAL (WS-MUNI-RATE-SUB)                 
T15557            IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                  
                    COMPUTE WS-MUNI-CURR-COST (WS-MUNI-RATE-SUB) =      
                            WS-HOLD-AMT-BILL-ITEM                       
                  ELSE                                                  
                    COMPUTE WS-MUNI-CURR-COST (WS-MUNI-RATE-SUB) =      
                            WS-HOLD-AMT-BILL-ITEM      -                
                            WS-AMT-STATE-TAX-BG (SUB1)                  
                  END-IF                                                
                  GO TO 1000-EXIT
           END-IF.                                      
           ADD 1 TO WS-MUNI-RATE-SUB.                                   
           IF WS-MUNI-RATE-SUB > 10                                     
               MOVE 12 TO RETURN-CODE                                   
               MOVE 'OVER 20 MUNICIPAL LIGHT RATES' TO                  
                    WS-MISC-MSG-TEXT                                    
               MOVE +30 TO WS-MISC-MSG-LEN                              
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
               PERFORM 9999-BAIL-OUT THRU 9999-EXIT
           END-IF.                    
           GO TO 1000-LOCATE-TABLE.                                     
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  THE BILL PERIOD END DATE IS THE BILLING DATE.  GET THE  *              
      *  LARGEST NUMBER OF BILLING PERIOD DAYS FROM THE UNMETERED*              
      *  CONSUMPTION SEGMENT.  CALCULATE THE BILL PERIOD START = *              
      *  END DATE - # DAYS.                                      *              
      ************************************************************              
                                                                        
       1010-GET-DAYS-DATE.                                              
                                                                        
           MOVE WS-DATE-BILLED-BI TO WS-END-DATE.                       
                                                                        
           MOVE 1 TO SUB3.                                              
I00177     PERFORM UNTIL SUB3 > WS-UC-MAX-ENTRY                         
I00177                OR WS-ACCOUNT-NO-UC (SUB3) = ZEROES               
               IF WS-ACCOUNT-NO-UC (SUB3) = WS-ACCOUNT-NO-BG (SUB1) AND 
                  WS-BILL-NO-UC (SUB3) = WS-BILL-NO-BG (SUB1) AND       
                  WS-CODE-UTIL-TYPE-UC (SUB3) =                         
                      WS-CODE-UTIL-TYPE-BG (SUB1) AND                   
                  WS-IC-NO-UC (SUB3) = WS-IC-NO-BG (SUB1) AND           
                  WS-BILL-ITEM-TIMESTMP-UC (SUB3) =                     
                      WS-BILL-ITEM-TIMESTMP-BG (SUB1)                   
                          IF WS-NO-DAYS-UC (SUB3) >                     
                             WS-MUNI-DAYS (WS-MUNI-RATE-SUB)            
                                  MOVE WS-NO-DAYS-UC (SUB3) TO          
                                       WS-MUNI-DAYS (WS-MUNI-RATE-SUB)  
                          END-IF                                        
               END-IF                                                   
               ADD 1 TO SUB3                                            
           END-PERFORM.                                                 
                                                                        
           MOVE WS-MUNI-DAYS (WS-MUNI-RATE-SUB) TO WS-CALC-NO-DAYS.     
           EXEC SQL                                                     
T35434          SELECT
              DATEADD( DAY, -:WS-CALC-NO-DAYS, IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) )
            INTO
              :WS-CALC-START-DATE         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CALC-START-DATE =                                       
MFA-TR*              DATE(:WS-END-DATE) - :WS-CALC-NO-DAYS DAYS                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
               MOVE 'C' TO WS-BILL-DEST-CODE                            
               MOVE '4' TO WS-SYSTEM-CNTRL-CODE                         
A02003         MOVE SPACES TO WS-CALC-START-DATE                        
A02003     END-IF.                                                      
T17308     MOVE WS-CALC-START-DATE TO WS-MUNI-DATE (WS-MUNI-RATE-SUB)   
T17308     MOVE WS-CALC-START-DATE TO WS-UNFORMAT-DATE.                 
T17308     MOVE SPACES TO WS-ENGLISH-DATE.                              
T17308     MOVE WS-UNFORMAT-DATE(9:2) TO WS-ENGLISH-DD.                 
T17308     PERFORM 4000-ENGLISH-MONTH THRU 4000-EXIT.                   
T17308     IF WS-MUNI-ST-DATE <= SPACES                                 
T17308         MOVE WS-ENGLISH-DATE TO WS-MUNI-ST-DATE
           END-IF.                 
T35152     IF WS-MUNI-ST-DATE-NUM <= SPACES                             
T35152         MOVE WS-CALC-START-DATE TO WS-MUNI-ST-DATE-NUM           
T35152     END-IF.                                                      
T17308     MOVE WS-END-DATE TO WS-UNFORMAT-DATE.                        
T17308     MOVE SPACES TO WS-ENGLISH-DATE.                              
T17308     MOVE WS-UNFORMAT-DATE(9:2) TO WS-ENGLISH-DD.                 
T17308     PERFORM 4000-ENGLISH-MONTH THRU 4000-EXIT.                   
T17308     IF WS-MUNI-END-DATE <= SPACES                                
T17308         MOVE WS-ENGLISH-DATE TO WS-MUNI-END-DATE                 
T17308     END-IF.                                                      
T35152     IF WS-MUNI-END-DATE-NUM <= SPACES                            
T35152         MOVE WS-END-DATE     TO WS-MUNI-END-DATE                 
T35152     END-IF.                                                      
                                                                        
       1010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  PROCESS ALL BILL ADJUSTMENTS AND CALCULATIONS           *              
      *  (UNMETERED).  GET THE DESCRIPTION.  THIS DATA WILL      *              
      *  ACCUMULATE IN THE UNMETERED WORKING STORAGE TABLE.      *              
      ************************************************************              
                                                                        
       1100-UNMETERED-CHARGES.                                          
                                                                        
T31511     MOVE 1 TO SUB2 WS-MUNI-CHG-SUB.                              
T31511     PERFORM 1310-DETERMINE-CHG-SUB THRU 1310-EXIT.               
T31511     PERFORM UNTIL SUB2 > 100 OR WS-ACCOUNT-NO-BA (SUB2) = ZEROES 
T31511        IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BA (SUB2) AND  
T31511           WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BA (SUB2) AND        
T31511           WS-CODE-UTIL-TYPE-BG (SUB1) =                          
T31511                       WS-CODE-UTIL-TYPE-BA (SUB2) AND            
T31511           WS-IC-NO-BG (SUB1) = WS-IC-NO-BA (SUB2) AND            
T31511           WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
T31511                       WS-BILL-ITEM-TIMESTMP-BA (SUB2) AND        
T31511           WS-FACTOR-ID-BA (SUB2) = 'FACILITY'                    
T31511               MOVE 'Facility Charge' TO                          
T31511             WS-MUNI-CHG-MSG (WS-MUNI-RATE-SUB WS-MUNI-CHG-SUB)   
T31511               COMPUTE WS-ROUNDED-BFC ROUNDED =                   
T31511                       WS-AMT-ADJUSTMENT-BA (SUB2) * 1            
T31511               MOVE WS-ROUNDED-BFC TO                             
T31511                WS-MUNI-CHG-AMT (WS-MUNI-RATE-SUB WS-MUNI-CHG-SUB)
T31511                    WS-HOLD-BASIC-FACILITY                        
T31511               ADD WS-AMT-ADJUSTMENT-BA (SUB2) TO                 
T31511                   WS-MUNI-TOTAL-CALC (WS-MUNI-RATE-SUB)          
T31511               ADD 1 TO WS-MUNI-CHG-SUB                           
T31511         END-IF                                                   
T31511         ADD 1 TO SUB2                                            
T31511     END-PERFORM.                                                 
T31511                                                                  
           MOVE 1 TO SUB2.                                              
I00177     PERFORM UNTIL SUB2 > WS-BZ-MAX-ENTRY                         
                      OR WS-ACCOUNT-NO-BC (SUB2) = ZEROES               
              IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BC (SUB2) AND  
                 WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BC (SUB2) AND        
                 WS-CODE-UTIL-TYPE-BG (SUB1) =                          
                             WS-CODE-UTIL-TYPE-BC (SUB2) AND            
                 WS-IC-NO-BG (SUB1) = WS-IC-NO-BC (SUB2) AND            
                 WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
                             WS-BILL-ITEM-TIMESTMP-BC (SUB2)            
                     MOVE 1 TO WS-MUNI-LIGHT-SUB                        
                     PERFORM 1200-BUILD-UNMETERED-TABLE THRU 1200-EXIT  
              END-IF                                                    
              ADD 1 TO SUB2                                             
           END-PERFORM.                                                 
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  ACCUMULATE DESCRIPTION AND CHARGES IN THE MUNICIPAL     *              
      *  WORKING STORAGE TABLE.  NOTE THAT NET-UNITS-BC CONTAINS *              
      *  A COUNT.                                                *              
      ************************************************************              
                                                                        
       1200-BUILD-UNMETERED-TABLE.                                      
                                                                        
           IF WS-MUNI-COMP-ID (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB) =    
                      SPACES                                            
               MOVE WS-COMPONENT-ID-BC (SUB2) TO WS-MUNI-COMP-ID        
                        (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB)            
               MOVE WS-NET-UNITS-BC (SUB2) TO WS-MUNI-LIGHT-COUNT       
                        (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB)            
T28305         MOVE WS-RATE-ITEM-CODE-BC (SUB2) TO WS-MUNI-RATE-ITEM-CD 
T28305                  (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB)            
               PERFORM 1210-GET-UM-DESC THRU 1210-EXIT                  
               IF WS-EQUIP-DESC = 'N'                                   
                   MOVE 'Unmetered Equipment' TO WS-MUNI-LIGHT-DESC     
                            (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB)        
                   MOVE 'C' TO WS-BILL-DEST-CODE                        
                   MOVE 'L' TO WS-SYSTEM-CNTRL-CODE                     
               END-IF                                                   
T28305         IF (WS-COMPANY-NO-AT = '01' AND                          
T28305             WS-VERSION-PRORATE = 'Y') OR                         
T8820             WS-PRORATE-CD-BG (SUB1) > ' ' AND                     
T12523            (WS-NO-OF-CONS-DAYS-BG (SUB1) < 27 OR                 
T12523             WS-NO-OF-CONS-DAYS-BG (SUB1) > 34)                   
T31511            OR ( WS-CALC-COMPONENT-AMT-BC (SUB2) NOT EQUAL TO     
T31511               WS-NET-COMPONENT-AMT-BC (SUB2))                    
T8820               MOVE WS-CALC-COMPONENT-AMT-BC (SUB2) TO             
T8820                   WS-MUNI-LIGHT-CHARGES                           
T8820                       (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB)        
T8820               ADD WS-CALC-COMPONENT-AMT-BC (SUB2) TO              
T8820                  WS-MUNI-TOTAL-CALC (WS-MUNI-RATE-SUB)            
T31511              IF (WS-COMPANY-NO-AT = '01' AND                     
T31511                  WS-VERSION-PRORATE = 'Y') OR                    
T31511                  WS-PRORATE-CD-BG (SUB1) > ' ' AND               
T31511                 (WS-NO-OF-CONS-DAYS-BG (SUB1) < 27 OR            
T31511                  WS-NO-OF-CONS-DAYS-BG (SUB1) > 34)              
T31511                     MOVE 0 TO WS-MUNI-LIGHT-RATE                 
T31511                           (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB)   
T31511              ELSE                                                
T31511                     MOVE WS-AMT-NET-RATE-BC (SUB2 1) TO          
T31511                            WS-MUNI-LIGHT-RATE                    
T31511                           (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB)   
T31511              END-IF                                              
T8820          ELSE                                                     
                   MOVE WS-NET-COMPONENT-AMT-BC (SUB2) TO               
                        WS-MUNI-LIGHT-CHARGES                           
                            (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB)        
                   ADD WS-NET-COMPONENT-AMT-BC (SUB2) TO                
                       WS-MUNI-TOTAL-CALC (WS-MUNI-RATE-SUB)            
                   MOVE WS-AMT-NET-RATE-BC (SUB2 1) TO                  
                        WS-MUNI-LIGHT-RATE                              
                            (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB)        
T8820          END-IF                                                   
               GO TO 1200-EXIT                                          
T28305     ELSE                                                         
T28305         IF WS-MUNI-COMP-ID                                       
T28305            (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB) EQUAL TO         
T28305            WS-COMPONENT-ID-BC (SUB2) AND                         
T28305            WS-MUNI-RATE-ITEM-CD                                  
T28305            (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB) EQUAL TO         
T28305            WS-RATE-ITEM-CODE-BC (SUB2)                           
T28305             IF (WS-COMPANY-NO-AT = '01' AND                      
T28305                 WS-VERSION-PRORATE = 'Y') OR                     
T28305                 WS-PRORATE-CD-BG (SUB1) > ' ' AND                
T28305                (WS-NO-OF-CONS-DAYS-BG (SUB1) < 27 OR             
T28305                 WS-NO-OF-CONS-DAYS-BG (SUB1) > 34)               
T31511            OR ( WS-CALC-COMPONENT-AMT-BC (SUB2) NOT EQUAL TO     
T31511               WS-NET-COMPONENT-AMT-BC (SUB2))                    
T28305                     ADD WS-CALC-COMPONENT-AMT-BC (SUB2) TO       
T28305                         WS-MUNI-LIGHT-CHARGES                    
T28305                         (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB)     
T28305                     ADD WS-CALC-COMPONENT-AMT-BC (SUB2) TO       
T28305                         WS-MUNI-TOTAL-CALC (WS-MUNI-RATE-SUB)    
T28305             ELSE                                                 
T28305                 ADD WS-NET-COMPONENT-AMT-BC (SUB2) TO            
T28305                     WS-MUNI-LIGHT-CHARGES                        
T28305                    (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB)          
T28305                 ADD WS-NET-COMPONENT-AMT-BC (SUB2) TO            
T28305                     WS-MUNI-TOTAL-CALC (WS-MUNI-RATE-SUB)        
T28305             END-IF                                               
T28305             GO TO 1200-EXIT                                      
T28305         END-IF                                                   
T28305     END-IF.                                                      
           ADD 1 TO WS-MUNI-LIGHT-SUB.                                  
           IF WS-MUNI-LIGHT-SUB > 50                                    
               MOVE 12 TO RETURN-CODE                                   
               MOVE 'OVER 50 MUNICIPAL LIGHTS' TO                       
                    WS-MISC-MSG-TEXT                                    
               MOVE +24 TO WS-MISC-MSG-LEN                              
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
               PERFORM 9999-BAIL-OUT THRU 9999-EXIT
           END-IF.                    
           GO TO 1200-BUILD-UNMETERED-TABLE.                            
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  GET THE UNMETERED EQUIPMENT SHORT DESCRIPTION.          *              
      ************************************************************              
                                                                        
       1210-GET-UM-DESC.                                                
                                                                        
           MOVE ' ' TO WS-EQUIP-DESC.                                   
           MOVE WS-CODE-UTIL-TYPE-BG (SUB1) TO RT-CODE-UTIL-TYPE.       
           MOVE WS-RATE-PLAN-NO-BG (SUB1) TO RT-RATE-PLAN-NO.           
           MOVE WS-DATE-BILLED-BI TO RT-FROM-EFFECTIVE-DT.              
           EXEC SQL                                                     
               SELECT MAX(VERSION_NO_CNTRL)                             
                 INTO :RT-VERSION-NO-CNTRL :WS-NULL-IND-1               
                 FROM CSS_RATE_CREATOR                                  
                WHERE CODE_UTIL_TYPE = :RT-CODE-UTIL-TYPE               
                  AND RATE_PLAN_NO = :RT-RATE-PLAN-NO                   
                  AND CODE_STATUS IN ('A', 'I')                         
                  AND FROM_EFFECTIVE_DT <= IIF(TRY_CONVERT(DATE, 
                                                  :RT-FROM-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :RT-FROM-EFFECTIVE-DT
              ) <> 0) OR (LEN(:RT-FROM-EFFECTIVE-DT
              ) <> 10), CIS.CHAR2DATE(:RT-FROM-EFFECTIVE-DT
              ), CONVERT(DATE, :RT-FROM-EFFECTIVE-DT) )        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(VERSION_NO_CNTRL)                                     
MFA-TR*          INTO :RT-VERSION-NO-CNTRL :WS-NULL-IND-1                       
MFA-TR*          FROM CSS_RATE_CREATOR                                          
MFA-TR*         WHERE CODE_UTIL_TYPE = :RT-CODE-UTIL-TYPE                       
MFA-TR*           AND RATE_PLAN_NO = :RT-RATE-PLAN-NO                           
MFA-TR*           AND CODE_STATUS IN ('A', 'I')                                 
MFA-TR*           AND FROM_EFFECTIVE_DT <= :RT-FROM-EFFECTIVE-DT                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND-1 < 0                                 
                       MOVE 'N' TO WS-EQUIP-DESC                        
                       GO TO 1210-EXIT                                  
                   ELSE                                                 
                       CONTINUE                                         
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-EQUIP-DESC                            
                   GO TO 1210-EXIT                                      
               WHEN OTHER                                               
                   MOVE 'RT' TO WS-DB2-TABLE-ID                         
                   MOVE 'SELECT' TO WS-DB2-FUNCTION                     
                   MOVE SQLCODE TO WS-DB2-RETURN-CODE                   
                   MOVE '173' TO WS-DB2-MODULE-ID                       
                   MOVE '1210' TO WS-DB2-PARAGRAPH                      
                   MOVE RT-RATE-PLAN-NO TO WS-DB2-KEY-1                 
                   MOVE RT-CODE-UTIL-TYPE TO WS-DB2-KEY-2               
                   MOVE 12 TO RETURN-CODE                               
                   PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT            
           END-EVALUATE.                                                
           EXEC SQL                                                     
               SELECT CODE_STATUS                                       
                 INTO :RT-CODE-STATUS                                   
                 FROM CSS_RATE_CREATOR                                  
                WHERE CODE_UTIL_TYPE = :RT-CODE-UTIL-TYPE               
                  AND RATE_PLAN_NO = :RT-RATE-PLAN-NO                   
                  AND VERSION_NO_CNTRL = :RT-VERSION-NO-CNTRL           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RT-CODE-STATUS = 'A'                              
                       CONTINUE                                         
                   ELSE                                                 
                       MOVE 'N' TO WS-EQUIP-DESC                        
                       GO TO 1210-EXIT                                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-EQUIP-DESC                            
                   GO TO 1210-EXIT                                      
               WHEN OTHER                                               
                   MOVE 'RT' TO WS-DB2-TABLE-ID                         
                   MOVE 'SELECT' TO WS-DB2-FUNCTION                     
                   MOVE SQLCODE TO WS-DB2-RETURN-CODE                   
                   MOVE '173' TO WS-DB2-MODULE-ID                       
                   MOVE '1210' TO WS-DB2-PARAGRAPH                      
                   MOVE RT-RATE-PLAN-NO TO WS-DB2-KEY-1                 
                   MOVE RT-CODE-UTIL-TYPE TO WS-DB2-KEY-2               
                   MOVE 12 TO RETURN-CODE                               
                   PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT            
           END-EVALUATE.                                                
           MOVE WS-CODE-UTIL-TYPE-BG (SUB1) TO UP-CODE-UTIL-TYPE.       
           MOVE WS-RATE-PLAN-NO-BG (SUB1) TO UP-RATE-PLAN-NO.           
           MOVE RT-VERSION-NO-CNTRL TO UP-VERSION-NO-CNTRL.             
           MOVE WS-RATE-ITEM-CODE-BC (SUB2) TO UP-RATE-ITEM-CODE.       
           EXEC SQL                                                     
               SELECT B.UM_EQUIP_SHRT_DESC                              
                 INTO :L9-UM-EQUIP-SHRT-DESC                            
                 FROM CSS_UNMTR_PLAN A,                                 
                      CSS_UM_EQUIPMENT B                                
                WHERE A.CODE_UTIL_TYPE = :UP-CODE-UTIL-TYPE             
                  AND A.RATE_PLAN_NO = :UP-RATE-PLAN-NO                 
                  AND A.VERSION_NO_CNTRL = :UP-VERSION-NO-CNTRL         
                  AND A.RATE_ITEM_CODE = :UP-RATE-ITEM-CODE             
                  AND A.UM_EQUIP_ID = B.UM_EQUIP_ID                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
T15988             MOVE L9-UM-EQUIP-SHRT-DESC TO WS-MUNI-LIGHT-DESC     
                            (WS-MUNI-RATE-SUB WS-MUNI-LIGHT-SUB)        
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-EQUIP-DESC                            
               WHEN OTHER                                               
                   MOVE 'L9' TO WS-DB2-TABLE-ID                         
                   MOVE 'SELECT' TO WS-DB2-FUNCTION                     
                   MOVE SQLCODE TO WS-DB2-RETURN-CODE                   
                   MOVE '173' TO WS-DB2-MODULE-ID                       
                   MOVE '1210' TO WS-DB2-PARAGRAPH                      
                   MOVE UP-RATE-PLAN-NO TO WS-DB2-KEY-1                 
                   MOVE UP-CODE-UTIL-TYPE TO WS-DB2-KEY-2               
                   MOVE 12 TO RETURN-CODE                               
                   PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT            
           END-EVALUATE.                                                
                                                                        
       1210-EXIT.                                                       
           EXIT.                                                        
                                                                        
T31511 1310-DETERMINE-CHG-SUB.                                          
T31511                                                                  
T31511     IF WS-MUNI-CHG-MSG (WS-MUNI-RATE-SUB WS-MUNI-CHG-SUB)        
T31511        <= SPACES                                                 
T31511         GO TO 1310-EXIT                                          
T31511     ELSE                                                         
T31511         ADD 1 TO WS-MUNI-CHG-SUB                                 
T31511         IF WS-MUNI-CHG-SUB > 50                                  
T31511             MOVE 12 TO RETURN-CODE                               
T31511             MOVE 'OVER 50 CHARGES' TO                            
T31511                  WS-MISC-MSG-TEXT                                
T31511             MOVE +16 TO WS-MISC-MSG-LEN                          
T31511             PERFORM 9910-MISC-ERROR THRU 9910-EXIT               
T31511             PERFORM 9999-BAIL-OUT THRU 9999-EXIT                 
T31511         END-IF                                                   
T31511         GO TO 1310-DETERMINE-CHG-SUB
           END-IF.                            
T31511                                                                  
T31511 1310-EXIT.                                                       
T31511     EXIT.                                                        
                                                                        
       1400-CHECK-FOR-PRORATE.                                          
                                                                        
T8820      IF WS-MUNI-LIGHT-PLAN (WS-MUNI-RATE-SUB) =                   
T8820         WS-RATE-PLAN-NO-BG (SUB1) AND                             
T8820         WS-MUNI-LIGHT-IC-NO (WS-MUNI-RATE-SUB) =                  
T8820                              WS-IC-NO-BG (SUB1)                   
T8820          PERFORM VARYING SUB2 FROM 1 BY 1                         
T8820            UNTIL SUB2 > 100                                       
T8820            OR WS-ACCOUNT-NO-BA (SUB2) = ZEROES                    
T8820              IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BA (SUB2) 
T8820                 AND WS-BILL-NO-BG (SUB1) =   WS-BILL-NO-BA (SUB2) 
T8820                 AND WS-CODE-UTIL-TYPE-BG (SUB1) =                 
T8820                                       WS-CODE-UTIL-TYPE-BA (SUB2) 
T8820                 AND WS-IC-NO-BG (SUB1) =       WS-IC-NO-BA (SUB2) 
T8820                 AND WS-BILL-ITEM-TIMESTMP-BG (SUB1) =             
T8820                                   WS-BILL-ITEM-TIMESTMP-BA (SUB2) 
T28478                 IF WS-FACTOR-BA (SUB2) NUMERIC                   
T8820                      IF WS-FACTOR-BA (SUB2) > 0                   
T8820                           EVALUATE WS-FACTOR-ID-BA (SUB2)         
T8820                               WHEN 'SNPROPCT'                     
T8820                               WHEN 'S2PROPCT'                     
T8820                               WHEN 'NSPROPCT'                     
T8820                               WHEN 'N2PROPCT'                     
T8820                                   MOVE 'Y' TO WS-SEASONAL-PRORATE 
T8820                               WHEN 'RTPROPCT'                     
T8820                                   MOVE 'Y' TO WS-VERSION-PRORATE  
T8820                           END-EVALUATE                            
T8820                      END-IF                                       
T28478                 END-IF                                           
T8820               END-IF                                              
T8820          END-PERFORM
           END-IF.                                             
                                                                        
T8820  1400-EXIT.                                                       
T8820      EXIT.                                                        
                                                                        
T12827************************************************************              
T12827*  3700-NONE-CALC.                                         *              
T12827************************************************************              
T12827                                                                  
T12827     EXEC SQL                                                             
T12827         INCLUDE CPD00097                                                 
T12827     END-EXEC.                                                            
      ************************************************************              
      *  4000-ENGLISH-MONTH                                      *              
      *  4010-COUNT-DAYS                                         *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00200                                                 
           END-EXEC.                                                            
                                                                        
                                                                        
      ************************************************************              
      *  6010-REDUCE-EMBEDDED-SPACES                             *              
      ************************************************************              
                                                                        
       COPY CPD00004.                                                           
                                                                        
T29598************************************************************              
T29598*  6500-GET-REV-DIST-DESC                                  *              
T29598************************************************************              
T29598                                                                  
T29598     EXEC SQL                                                             
T29598         INCLUDE CPD00500                                                 
T29598     END-EXEC.                                                            
T29598                                                                  
T29598************************************************************              
T29598*  8895-INSERT-WORK-QUEUE                                  *              
T29598************************************************************              
      *                                                                 33439100
A04860*                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860                                                                  
A04860     MOVE PROGRAM-NAME            TO WS-77-CREATED-BY.            
A04860                                                                  
A04860     MOVE SPACES TO ABEND-FUNCTION.                               
A04860                                                                  
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
T29598************************************************************              
T29598*  9700-PROCESS-ABEND                                      *              
T29598************************************************************              
T29598                                                                  
T29598 9700-PROCESS-ABEND.                                              
T29598     DISPLAY ' 8895-INSERT-WORK-QUEUE '.                          
T29598     DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'.              
A04860     DISPLAY ' ** ERROR ON INSERT CSS_WQ_ITEMS'.                  
T29598     DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE.            
A04860     DISPLAY ' ** ACCOUNT NO = ' WS-77-ACCOUNT-NO.                
T29598     MOVE 12 TO RETURN-CODE.                                      
T29598     PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
T29598 9700-EXIT.                                                       
T29598     EXIT.                                                        
T29598                                                                  
       9900-SQL-ERROR.                                                  
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
           END-IF.                                                      
                                                                        
           MOVE WS-DATABASE-EXCEPTION                                   
             TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)           
                                                                        
           COMPUTE WS-START-POS                                         
             = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1                 
           MOVE WS-SQL-ERROR-TXT-WQ                                     
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)   
           ADD WS-SQL-ERROR-TXT-LEN-WQ                                  
             TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                   
ACT071     MOVE WS-PGRMNAME                                             
ACT071       TO WS-CREATED-BY-WF (WS-BILL-WQ-INDX).                     
                                                                        
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       9900-SQL-EXIT.                                                   
           EXIT.                                                        
                                                                        
       9910-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
ACT071        MOVE WS-PGRMNAME                                          
ACT071          TO WS-CREATED-BY-WF (WS-BILL-WQ-INDX)                   
           END-IF.                                                      
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-BAIL-OUT.                                                   
                                                                        
T8312      MOVE RETURN-CODE TO WS-SCSCA-RETURN-CODE.                    
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
