       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA170.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      ** SCSCA170 FORMATS ALL ELECTRIC & GAS IC RATES, METERS, CHARGES*         
      ** FOR BILL PRINT.  THIS PROGRAM IS CALLED FROM PCSCA925 FOR   **         
      ** THE BILL FORMAT CODES '01','02','03','06','07','08','09'    **         
      **                                                             **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    12/10    SV        INITIAL VERSION                        **         
P00496*    05/11    RAJ       PROJ 496    Enhancements to Industrial **         
P00496*                                   Billing.                   **         
A3019 *    12/11    SV        Fix proration rate discrepancy in Gas  **         
A3019 *                       processing.                            **         
P00496*    01/12    RAJ       Supress blank line if component desc   **         
P00496*                       is missing.                            **         
A03959*    03/12    RAJ       PROJ 496 WARRANTY WORK                 **         
A03959*                       (ADDITIONAL REQUIREMENTS).             **         
P00680*    06/12    RAJ       SCANA ENERGY RETENTION & ACQUISTION.   **         
A04860**   02/15    AS7C117   REPLACE CSS_WQ_ITEMS_MF WITH            *         
A04860**            ACT064    CSS_WQ_ITEMS.                           *         
ACT071**   06/04/15 SS7F226   ADD CREATED-BY FIELD LOGIC IN WF AREA.  *         
ACT071**             A04860                                           *         
I01959**   07/27/15 DMS       New bill format code for solar         **         
I01959**   08/31/15 SV95326   RATE PLAN AND DESCRIPTION GETS FROM    **         
I01959**                      BILL_LITERAL_TX FROM CSS_RATE_PLAN_DESC**         
I01959**                      TABLE.                                 **         
I01959**   09/10/15 SV95326   NEW BILL FORMAT CODE FOR SOLAR-TOU     **         
I01959**   09/16/15 SV95326   SUPRESS ZERO RATE FOR SOLAR & SOLAR-TOU**         
I02104**   06/02/16 DMS       ADD CRITICAL PEAK FOR PR1 & BCA ACCTS  **         
I2104A**   06/14/16 DMS       FIX CRITICAL PEAK FLAG FOR SUB ACCTS   **         
I02104**   08/08/16 AK7T405   I02104-FIX FOR PRORATED BILL PRINT ISSUE*         
P01175**   08/18/16 SV95326   SOLAR RENEWABLE CHANGES.               **         
ACT059**   09/19/16 DMS       A05462 - ADD CONSTANT TO TOU MTR DETAIL**         
P1175A**   10/19/16 DMS       CORRECT ISSUE WITH WS-SEASON-CODE      **         
P01175**   12/21/16 SV95326   IF THE ACCOUNT HAS ONLY USS RATE PLAN  **         
P01175**                      RATE_SUB_GRP_TYPE = F  THEN PAYMENT    **         
P01175**                      OPTIONS NEED NOT PRINT IN THE BILL.    **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
                                                                        
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA170'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-MISC.                                                     
           05  WS-CHECK-MM                     PIC XX.                  
           05  WS-START-DATE                   PIC X(10).               
           05  WS-END-DATE                     PIC X(10).               
COB305     05 WS-CALC-NO-DAYS        PIC S9(9) COMP-3 VALUE 0.        
           05  WS-HOLD-NO-OF-DAYS              PIC S9(9) COMP.          
A02003     05  WS-HOLD-CONSUMPTION-TYPE        PIC X.                   
A02003     05  WS-HOLD-TIME-PERIOD             PIC 9.                   
           05  WS-HOLD-METER-NO                PIC X(9) VALUE SPACES.   
COB305     05 WS-HOLD-PCOMP        PIC S9(02)V99999 COMP-3 VALUE 0. 
A02003     05  WS-TEMP-METER-NO                PIC X(9) VALUE SPACES.   
           05  WS-SEASONAL-PRORATE             PIC X    VALUE 'N'.      
           05  WS-VERSION-PRORATE              PIC X    VALUE 'N'.      
           05  WS-BC-TABLE-LOADED              PIC X    VALUE 'N'.      
           05  WS-HOLD-USAGE-ID                PIC X    VALUE SPACES.   
           05  WS-UTIL-METER-CHANGE            PIC X    VALUE 'N'.      
A12003*    05  WS-GAS-METER-CHANGE             PIC X    VALUE 'N'.              
A12003     05  WS-UNIT-SEL-LOAD-SW             PIC X    VALUE 'N'.      
A12003     05  WS-UTIL-DEM-SUM-FLAG            PIC X    VALUE 'N'.      
A12003     05  WS-UTIL-DEM-NM-FLAG             PIC X    VALUE 'N'.      
A12003     05  WS-CURR-USE-LOADED-FL           PIC X    VALUE 'N'.      
A12003     05  WS-CNSMPTN-FOUND-FLAG           PIC X    VALUE 'Y'.      
A12003         88  CNSMPTN-FOUND                        VALUE 'Y'.      
A12003         88  CNSMPTN-NOT-FOUND                    VALUE 'N'.      
COB305     05 WS-BILL-DEMAND        PIC S9(9) COMP-3 VALUE 0.        
A12003     05  WS-SEASON-CHANGE                PIC X VALUE 'N'.         
           05  WS-MATCH-FOUND                  PIC X VALUE 'N'.         
               88  MATCH-FOUND                       VALUE 'Y'.         
COB305     05 WS-HOLD-SUM-THERMS        PIC S9(9)V9(6) COMP-3 VALUE 0.   
COB305     05 WS-RND-NO-THERMS        PIC S9(9) COMP-3 VALUE 0.        
COB305     05 WS-LONG-NO-THERMS        PIC S9(9)V9(6) COMP-3 VALUE 0.   
A02003     05  WS-HOLD-BILL-FORMAT             PIC X(2).                
A02003         88 ELEC-NONDEM                     VALUES '01'.          
A02003         88 ELEC-DEMAND                     VALUES '03'.          
A02003         88 GAS                             VALUES '02'.          
A02003         88 WHOLESALE                       VALUES '06'.          
A02003         88 TOU-NONDEM                      VALUES '07'.          
A02003         88 TOU-DEMAND                      VALUES '08'.          
A02003         88 RTP                             VALUES '09'.          
I01959         88 SOLAR                           VALUES '11'.          
I01959         88 SOLAR-TOU                       VALUES '12'.          
A02003     05  WS-TOU-SEASON-CODE              PIC X(23).               
A02003     05  WS-SEASON-CODE                  PIC X(13).               
I02104     05  WS-TOU-CODE                     PIC X(14).               
A02003     05  WS-MTR-READ-SOURCE-CD           PIC X(1).                
COB305     05 WS-UNITS-BILLED        PIC S9(9)V9999 COMP-3 VALUE 0.   
P01175     05  WS-170-RATE-SUB-GRP-TYPE-CD     PIC X(1) VALUE SPACES.   
           05  SUB2                            PIC 9(3) VALUE 0.        
           05  SUB3                            PIC 9(3) VALUE 0.        
           05  SUB4                            PIC 9(3) VALUE 0.        
           05  SUB5                            PIC 9(3) VALUE 0.        
I02104     05  SUB6                            PIC 9(3) VALUE 0.        
P00496     05  WS-SUB                          PIC 9(3) VALUE 0.        
A12003     05  WS-SAVE-CX-SUB                  PIC 9(3) VALUE 0.        
A12003     05  WS-UC-SUB                       PIC 9(3) VALUE 0.        
           05  WS-HOLD-NONECALC-LITERAL        PIC X(255).              
           05  WS-NC-SUB                       PIC S9(4) COMP.          
           05  USAGE-SUB                       PIC 9(3) VALUE 0.        
           05  WS-CHECK-CX-SUB                 PIC 9(3) VALUE 0.        
           05  WS-RTP-TEMP-CHG-SUB             PIC 999 VALUE 0.         
           05  WS-RTP-TEMP-SUB                 PIC 999 VALUE 0.         
           05  WS-NEED-TOU-LOADED              PIC X VALUE 'N'.         
               88  NEED-TOU-LOADED                   VALUE 'Y'.         
           05  WS-METER-NBR-LOADED             PIC X VALUE 'N'.         
           05  WS-HOLD-BG-SUB                  PIC 9(3) VALUE 0.        
           05  WS-GET-TOU-DEM-SUM-SW           PIC X VALUE 'N'.         
           05  WS-MULTI-METER-FLAG             PIC X VALUE 'N'.         
COB305     05 WS-TOU-DEM-KW-ON-PEAK        PIC S9(9)V COMP-3 VALUE 0.       
COB305     05 WS-TOU-DEM-KW-OFF-PEAK        PIC S9(9)V COMP-3 VALUE 0.       
COB305     05 WS-HOLD-AMT-BILL-ITEM        PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-STORE-RETURN-CODE            PIC S9(4) COMP.          
P00496     05  WS-PREV-COMPONENT-ID            PIC X(2).                
COB305     05 WS-HOLD-ALLOCATED-KWH        PIC S9(9)V COMP-3 VALUE 0.       
COB305     05 WS-HOLD-ALLOCATED-KW        PIC S9(9)V COMP-3 VALUE 0.       
COB305     05 WS-HOLD-ALLOCATED-KVA        PIC S9(9)V COMP-3 VALUE 0.       
           05  WS-BLOCK-SUB                    PIC 9(3) VALUE 0.        
           05  WS-HOLD-BASIC-FACILITY          PIC S9(9)V99 VALUE 0.    
           05  WS-ROUNDED-BFC                  PIC S9(9)V99 VALUE 0.    
           05  WS-SUM-BC-TABLE.                                         
               10 WS-BC-TABLE    OCCURS 10.                             
COB305            15 WS-BC-UNITS        PIC S9(9) COMP-3 VALUE 0.        
COB305            15 WS-BC-READ-UNITS        PIC S9(9) COMP-3 VALUE 0.        
                  15  WS-BC-CONSUMPTION-TYPE   PIC X.                   
COB305            15 WS-BC-DOLLAR-AMT        PIC S9(9)V99 COMP-3 
COB305               VALUE 0.     
                  15  WS-BC-TIME-PERIOD        PIC 9.                   
COB305            15 WS-BC-RATE        PIC S9(5)V9(12) COMP-3 VALUE 0.  
COB305            15 WS-BC-AMT-BASE-RATE        PIC S9(5)V9(6) COMP-3 
COB305               VALUE 0.   
COB305            15 WS-BC-WNA-BLOCK-FCT        PIC S9(2)V9(5) COMP-3 
COB305               VALUE 0.   
           05  WS-NDEM-TABLE.                                           
               10 WS-NDEM-USAGE  OCCURS 3.                              
                  15  WS-NDEM-FLAG            PIC X   VALUE 'N'.        
COB305            15 WS-NDEM-CSEA-KWH        PIC S9(9)V COMP-3 VALUE 0.        
COB305            15 WS-NDEM-CSEA-CONSTANT        PIC S9(6)V999 COMP-3 
COB305               VALUE 0.     
                  15  WS-NDEM-CSEA-NO-DIALS   PIC 9(4) COMP.            
COB305            15 WS-NDEM-CSEA-KW        PIC S9(9)V COMP-3 VALUE 0.        
COB305            15 WS-NDEM-CSEA-CURR-INDEX        PIC S9(11)V COMP-3 
COB305               VALUE 0.       
COB305            15 WS-NDEM-CSEA-PREV-INDEX        PIC S9(11)V COMP-3 
COB305               VALUE 0.       
COB305            15 WS-NDEM-CSEA-INDEX-DIFF        PIC S9(09)V COMP-3 
COB305               VALUE 0.      
COB305            15 WS-NDEM-PSEA-KWH        PIC S9(9)V COMP-3 VALUE 0.        
COB305            15 WS-NDEM-PSEA-CONSTANT        PIC S9(6)V999 COMP-3 
COB305               VALUE 0.     
                  15  WS-NDEM-PSEA-NO-DIALS   PIC 9(4) COMP.            
COB305            15 WS-NDEM-PSEA-KW        PIC S9(9)V COMP-3 VALUE 0.        
COB305            15 WS-NDEM-PSEA-CURR-INDEX        PIC S9(11)V COMP-3 
COB305               VALUE 0.       
COB305            15 WS-NDEM-PSEA-PREV-INDEX        PIC S9(11)V COMP-3 
COB305               VALUE 0.       
COB305            15 WS-NDEM-PSEA-INDEX-DIFF        PIC S9(09)V COMP-3 
COB305               VALUE 0.      
           05  WS-CHARGES-MESSAGE-FIELDS.                               
A02003         10  WS-FORMAT-BASE-LITERAL     PIC X(30).                
A02003         10  WS-FORMAT-LITERAL          PIC X(30).                
A02003         10  WS-FORMAT-UNITS            PIC -Z(8)9.               
I02104         10  WS-FORMAT-MESSAGE          PIC X(250).               
A03959         10  WS-DISPLAY-UNITS           PIC -ZZZ,ZZZ,ZZ9.         
A03959         10  WS-DISPLAY-RATE-NM         PIC S9(5)V999999.         
               10  WS-DISPLAY-RATE            PIC -Z(4)9.999999.        
               10  WS-DISPLAY-RATE2           PIC -Z(4)9.999999999999.  
               10  WS-CNSMPTN-TYPE            PIC X(6).                 
               10  WS-DISPLAY-PCT             PIC -ZZ.99.               
               10  WS-COMPUTE-PCT             PIC S9(3)V99.             
               10  WS-COMPUTE-PF              PIC S999.                 
               10  WS-DISPLAY-PF              PIC -ZZ9.                 
COB305         10 WS-WNA-TOTAL-AMT        PIC S9(9)V9(2) COMP-3 VALUE 0.    
               10  WS-DISPLAY-WNA-TOTAL-AMT   PIC -ZZ,ZZZ.99.           
           05  WS-UNFORMAT-DATE               PIC X(10).                
           05  WS-FORMAT-DATE.                                          
               10  WS-FORMAT-MM               PIC XX.                   
               10  F                          PIC X VALUE '/'.          
               10  WS-FORMAT-DD               PIC XX.                   
               10  F                          PIC X VALUE '/'.          
               10  WS-FORMAT-YY               PIC XX.                   
           05  WS-ENGLISH-DATE.                                         
               10  WS-ENGLISH-MM              PIC XXX.                  
               10  F                          PIC X VALUE ' '.          
               10  WS-ENGLISH-DD              PIC XX.                   
           05  WS-START-POS                   PIC S9(4) COMP.           
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  FILLER                     PIC S9(4) COMP VALUE +121.
               10  FILLER                     PIC X(1)  VALUE 'N'.      
               10  FILLER                     PIC X(1)  VALUE '4'.      
               10  WS-MISC-MSG-LEN            PIC S9(4) COMP VALUE +250.
               10  WS-MISC-MSG-TEXT           PIC X(250).               
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER                     PIC S9(4) COMP VALUE +121.
               10  FILLER                     PIC X(1)  VALUE 'N'.      
               10  FILLER                     PIC X(1)  VALUE '4'.      
               10  FILLER                     PIC S9(4) COMP VALUE +29. 
               10  FILLER                     PIC X(30) VALUE           
                   'A DATABASE EXCEPTION OCCURRED'.                     
A02003     05  WS-LAST-GAS-BG                  PIC X VALUE ' '.         
           05  RS-RETURN-CODE                  PIC S9(4) COMP.          
           05  WS-CURRENT-DATE                 PIC X(10) VALUE SPACES.  
           05  WS-RUN-DATE                     PIC X(10) VALUE SPACES.  
           05  WS-HOLD-PREV-METER-READ-CALC    PIC S9(11)V COMP-3 VALUE 
                                                                ZEROES. 
           05  WS-HOLD-PREV-METER-READ-DATE    PIC X(10) VALUE SPACES.  
           05  WS-USAGE.                                                
COB305         10 WS-BASE-KWH-UNITS        PIC S9(9)V COMP-3 VALUE 0.       
COB305         10 WS-BASE-KW-UNITS        PIC S9(9)V COMP-3 VALUE 0.       
COB305         10 WS-BASE-KVA-UNITS        PIC S9(9)V COMP-3 VALUE 0.       
           05  WS-DEMAND-TABLE.                                         
               10  WS-DEM-USAGE      OCCURS 4.                          
                   15  WS-DEM-FLAG             PIC X   VALUE 'N'.       
COB305             15 WS-KWH-UNITS        PIC S9(9)V COMP-3 VALUE 0.       
COB305             15 WS-KW-UNITS        PIC S9(9)V COMP-3 VALUE 0.       
COB305             15 WS-KVA-UNITS        PIC S9(9)V COMP-3 VALUE 0.       
           05  WS-CHARGES.                                              
               10  WS-BASE-KWH                 PIC S9(9)V99.            
               10  WS-BASE-KW                  PIC S9(9)V99.            
               10  WS-BASE-KVA                 PIC S9(9)V99.            
               10  WS-RTP-KWH-OVER             PIC S9(9)V99.            
               10  WS-RTP-KW-OVER              PIC S9(9)V99.            
               10  WS-RTP-KVA-OVER             PIC S9(9)V99.            
               10  WS-RTP-KWH-UNDER            PIC S9(9)V99.            
               10  WS-RTP-KW-UNDER             PIC S9(9)V99.            
               10  WS-RTP-KVA-UNDER            PIC S9(9)V99.            
               10  WS-RTP-KWH-READ-UNITS-OVER  PIC S9(9).               
               10  WS-RTP-KWH-READ-UNITS-UNDER PIC S9(9).               
A03959     05  WS-FH-FACTOR-FOUND              PIC X    VALUE 'N'.      
A03959     05  WS-PREV-BILL-PRT-SEQ-NO         PIC S9(4) USAGE COMP.    
I02104     05  WS-PR1-RATE-FL                  PIC X    VALUE 'N'.      
I02104     05  WS-CRITICAL-PEAK-FL             PIC X    VALUE 'N'.      
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                  PIC  X(08) VALUE 'SCSCA170'.
           05  PROGRAM-NAME                 PIC  X(08) VALUE 'SCSCA170'.
A04860     05  SCSCB077                     PIC  X(08) VALUE 'SCSCB077'.
                                                                        
P00680*  Working storage fields for CPD00095                                    
P00680 COPY CWSD0095.                                                           
      *  SUPPLEMENTAL WORK QUEUE FIELDS                                         
       COPY CWS0070B.                                                           
      *  FIELDS FOR SQL/DB2 ERROR CHECKING                                      
       COPY CWS00303.                                                           
      *  ABEND FIELDS                                                           
       COPY CWS00010.                                                           
      *  FIELDS USED TO REDUCE EMBEDDED BLANKS                                  
P00496 COPY CWS0011A.                                                           
      *  FIELDS USED TO REMOVE PARENS                                           
       COPY CWS00500.                                                           
      *  FIELDS DEFINED FOR WNA                                                 
       COPY CWS00064.                                                           
      *  ABEND SWITCH                                                           
       COPY CWS09900.                                                           
A04860*                                                                         
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
A04860*                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBSPLFTR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
                                                                        
      *********************************************************                 
      *          INCLUDE THE DCLGEN FOR CSS_REV_DISTRICT      *                 
      *********************************************************                 
           EXEC SQL                                                             
                INCLUDE TBRVDST                                                 
           END-EXEC.                                                            
       LINKAGE SECTION.                                                 
                                                                        
      *  BILLING EXTRACT FILE                                                   
       COPY CWS1000A.                                                           
       COPY CWS1000B.                                                           
      *  BILLING EXTRACT FILE                                                   
       COPY CWS1001A.                                                           
       COPY CWS1001B.                                                           
      *  BILLING EXTRACT FILE                                                   
       COPY CWS10009.                                                           
       01  SUB1                         PIC 9(3).                       
       01  WS-SCSCA-RETURN-CODE         PIC S9(4) comp.                 
       01  WS-FUEL-ADJ-SW               PIC X      VALUE 'N'.           
COB305 01 WS-HOLD-FUEL-ADJ-FACTOR        PIC S9(3)V9(12) comp-3 VALUE 0.        
       01  WS-HOLD-WNA-TOTAL-AMT        PIC S9(9)V99.                   
COB305 01 WS-HOLD-CRIT-FACTOR        PIC S9(9)V9(6) COMP-3 VALUE 0.          
COB305 01 WS-HOLD-ONPK-FACTOR        PIC S9(9)V9(6) COMP-3 VALUE 0.          
P1175A 01  WS-HOLD-SEASON-CODE          PIC X(13).                      
COB305 01 WS-ENERGY-FROM-CUST        PIC S9(9)V9 COMP-3 VALUE 0.             
P01175 01  WS-RATE-SUB-GRP-TYPE-CD      PIC X(1).                       
      *  UTIL DETAILS                                                           
A02003 COPY CWS00170.                                                           
      *  RATCHET MESSAGE FIELDS                                                 
       COPY CWS00089.                                                           
      *  WORK QUEUE FIELDS                                                      
       COPY CWS0024B.                                                           
      *  NONECALC FIELDS                                                        
       COPY CWS00097.                                                           
P00496* CSS_RATE_COMPONENT DUMPED TABLE                                         
P00496 COPY CWSCA925.                                                           
                                                                        
       PROCEDURE DIVISION USING WS-ACCOUNT-AT                           
                                WS-MISC-BILL-INFO                       
                                WS-PREV-BILL-INFO                       
                                WS-PREMISE-PR                           
                                WS-BILLING-BG                           
                                WS-CNSMPTN-HIST-CX                      
                                WS-BILL-ADJUST-DETAIL                   
                                WS-BILL-CALC-DETAIL                     
                                WS-MTRD-ENVRNMT-TABLE-MN                
                                SUB1                                    
                                WS-NONCALC-LITERALS                     
                                WS-SCSCA-RETURN-CODE                    
                                LS-PCSCA100-COMM-AREA                   
                                WS-BILLING-WQ-ITEMS-WF                  
                                WS-BILLING-BI                           
                                WS-UTIL-BILL-PRINT                      
                                WS-UNITS-SELECTION-MESSAGES             
                                WS-FUEL-ADJ-SW                          
                                WS-BILL-ADJUSTMNT                       
                                WS-HOLD-FUEL-ADJ-FACTOR                 
                                WS-HOLD-WNA-TOTAL-AMT                   
A02003                          WS-UNMTRD-CNSMPTN-UC                    
                                WS-CWS1000B-MAX-TBL-LIMITS              
P00496                          WS-RATE-COMPONENT                       
P00496                          WS-BILL-CALC-X-DETAIL                   
A03959                          WS-FIXED-FCTR-HIST-FH                   
I02104                          WS-HOLD-CRIT-FACTOR                     
I02104                          WS-HOLD-ONPK-FACTOR                     
P1175A                          WS-HOLD-SEASON-CODE                     
P01175                          WS-ENERGY-FROM-CUST                     
P01175                          WS-RATE-SUB-GRP-TYPE-CD.                

SCA006        SET SPCL-FACTOR-IND TO 1.
                                                                        
      ***************************************************************           
      *  PROGRAM IS CALLED FROM PCSCA925.                           *           
      *  DATA IS FORMATTED FOR DIALOGUE.                            *           
      *  COMMON TERMS USED                                          *           
A02003*  CODE USAGE TYPE       DESCRIPTION                          *           
A02003*         B                 KWH                               *           
A02003*         C                 CCF                               *           
A02003*         E                 KVA                               *           
A02003*         J                 KW                                *           
A02003*  CODE USAGE ID         DESCRIPTION                          *           
A02003*         A              BASIC SERVICE                        *           
A02003*         F              CO-GENERATION                        *           
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE WS-BILL-FORMAT-CODE-RT (SUB1)   TO WS-HOLD-BILL-FORMAT. 
           EVALUATE TRUE                                                
               WHEN ELEC-NONDEM                                         
                   DISPLAY 'SCSCA170 - ELECTRIC NON-DEMAND'             
               WHEN ELEC-DEMAND                                         
                   DISPLAY 'SCSCA170 - ELECTRIC DEMAND'                 
               WHEN GAS                                                 
                   DISPLAY 'SCSCA170 - GAS'                             
               WHEN WHOLESALE                                           
                   DISPLAY 'SCSCA170 - WHOLESALE'                       
               WHEN TOU-NONDEM                                          
                   DISPLAY 'SCSCA170 - TOU NON-DEMAND'                  
               WHEN TOU-DEMAND                                          
                   DISPLAY 'SCSCA170 - TOU DEMAND'                      
               WHEN RTP                                                 
                   DISPLAY 'SCSCA170 - RTP'                             
I01959         WHEN SOLAR                                               
I01959             DISPLAY 'SCSCA170 - SOLAR'                           
I01959         WHEN SOLAR-TOU                                           
I01959             DISPLAY 'SCSCA170 - SOLAR TOU'                       
           END-EVALUATE.                                                
           PERFORM 0100-INITIALIZE      THRU 0100-EXIT.                 
           PERFORM 1100-BUILD-UTIL-TABLE  THRU 1100-EXIT.               
P00496*****None-Calcs need not process the BC and BA rows                       
P00496     IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                         
P00496        PERFORM 1050-FORMAT-NONE-CALC-UTIL-IC  THRU 1050-EXIT     
P00496     ELSE                                                         
P00496        IF NOT RTP                                                
P00496           PERFORM 1600-CHECK-FOR-PRORATE THRU 1600-EXIT          
P00496        END-IF                                                    
P00496        PERFORM 1000-FORMAT-UTIL-IC    THRU 1000-EXIT             
P00496     END-IF.                                                      
           PERFORM 9999-BAIL-OUT          THRU 9999-EXIT.               
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  INITIALIZE FIELDS                                       *              
      ************************************************************              
       0100-INITIALIZE.                                                 
                                                                        
           IF TOU-DEMAND                                                
              IF WS-UTIL-DEM-SUM-SW(1 1) = LOW-VALUES OR SPACES         
                 MOVE 'Y' TO WS-GET-TOU-DEM-SUM-SW                      
                 INITIALIZE WS-TOU-DEM-KW-ON-PEAK                       
                            WS-TOU-DEM-KW-OFF-PEAK                      
              END-IF                                                    
              IF WS-GET-TOU-DEM-SUM-SW = 'Y'                            
                 PERFORM VARYING WS-UTIL-SUB FROM 1 BY 1 UNTIL          
                              WS-UTIL-SUB > 20                          
                   PERFORM VARYING WS-UTIL-SUM-SUB FROM 1 BY 1 UNTIL    
                                  WS-UTIL-SUM-SUB > 3                   
                      MOVE 'N' TO WS-UTIL-DEM-SUM-SW                    
                               (WS-UTIL-SUB WS-UTIL-SUM-SUB)            
                      MOVE WS-UTIL-SUM-SUB TO WS-UTIL-DEM-SUM-TIME-PD   
                               (WS-UTIL-SUB WS-UTIL-SUM-SUB)            
                   END-PERFORM                                          
                   PERFORM VARYING WS-UTIL-NM-SUB FROM 1 BY 1 UNTIL     
                                  WS-UTIL-NM-SUB > 3                    
                      MOVE 'N' TO WS-UTIL-DEM-NM-SW                     
                               (WS-UTIL-SUB WS-UTIL-NM-SUB)             
                      MOVE WS-UTIL-NM-SUB TO WS-UTIL-DEM-NM-TIME-PD     
                               (WS-UTIL-SUB WS-UTIL-NM-SUB)             
                   END-PERFORM                                          
                 END-PERFORM                                            
                 MOVE 'N' TO WS-GET-TOU-DEM-SUM-SW                      
              END-IF                                                    
           END-IF.                                                      
           INITIALIZE   WS-SUM-BC-TABLE                                 
                        WS-UTIL-METER-CHANGE                            
A12003*                 WS-GAS-METER-CHANGE                                     
                        WS-DEMAND-TABLE                                 
                        WS-NDEM-TABLE                                   
                        WS-MULTI-METER-FLAG                             
                        WS-HOLD-BASIC-FACILITY                          
                        WS-SAVE-CX-SUB                                  
                        WS-HOLD-PREV-METER-READ-CALC                    
                        WS-CHARGES                                      
                        WS-HOLD-PREV-METER-READ-DATE                    
P00680                  WS-PREV-COMPONENT-ID                            
P00680                  WS-HOLD-FACTOR-TABLE                            
P01175                  WS-UNITS-BILLED                                 
P01175                  WS-170-RATE-SUB-GRP-TYPE-CD.                    
           MOVE SPACES              TO WS-HOLD-METER-NO.                
           MOVE 'N'                 TO WS-VERSION-PRORATE               
                                       WS-SEASONAL-PRORATE              
I02104                                 WS-PR1-RATE-FL                   
I02104                                 WS-CRITICAL-PEAK-FL              
P00496                                 WS-FACTOR-BLK-LN-FL.             
           MOVE 1                   TO WS-UTIL-CX-SUB                   
                                       WS-UTIL-SUB                      
                                       WS-UC-SUB.                       
       0100-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      *  THIS ROUTINE FORMATS THE RATE IC DATA.  WITHIN EACH RATE*              
      *  IC HEADER WILL BE RATE METER RECORDS AND RATE CHARGES   *              
      *  RECORDS.  TOTALS ARE COMPARED;  IF THEY DO NOT MATCH, A *              
      *  CROSSFOOT ERROR IS GENERATED.                           *              
      ************************************************************              
                                                                        
       1000-FORMAT-UTIL-IC.                                             
                                                                        
P00496     PERFORM 1250-UNITS-ALLOCATION THRU 1250-EXIT                 
ACT042     MOVE 'N'                 TO WS-IS-PRORATED.                  
           IF WS-VERSION-PRORATE = 'Y' OR                               
              (WS-PRORATE-CD-BG (SUB1) > ' ' AND NOT RTP AND            
              (WS-NO-OF-CONS-DAYS-BG (SUB1) < 27 OR                     
               WS-NO-OF-CONS-DAYS-BG (SUB1) > 34))                      
ACT042         MOVE 'Y'             TO WS-IS-PRORATED                   
               PERFORM 1610-UTIL-CHGS-PRORATE THRU 1610-EXIT            
           ELSE                                                         
               PERFORM 1300-UTIL-CHARGES THRU 1300-EXIT                 
           END-IF.                                                      
                                                                        
           IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                         
               PERFORM 3700-NONE-CALC THRU 3700-EXIT                    
               MOVE 1               TO WS-UTIL-CHG-SUB                  
               PERFORM 1310-DETERMINE-CHG-SUB THRU 1310-EXIT            
               MOVE WS-HOLD-NONECALC-LITERAL TO                         
                    WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)       
P00496         MOVE 'N' TO WS-UTIL-CHG-HDR-ROW                          
P00496                              (WS-UTIL-SUB WS-UTIL-CHG-SUB)       
               IF WS-CODE-DR-CR-CNSMPTN-BG (SUB1) = 'C'                 
                   COMPUTE WS-UTIL-CHG-AMT(WS-UTIL-SUB WS-UTIL-CHG-SUB) 
                        =  WS-AMT-BILL-ITEM-BG (SUB1) * -1              
               ELSE                                                     
                   MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO                   
                        WS-UTIL-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               END-IF                                                   
               ADD WS-UTIL-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB) TO     
                   WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                     
           END-IF.                                                      
                                                                        
P00496     MOVE SPACES TO WS-PREV-FACTOR.                               
           PERFORM 3600-GET-FACTORS THRU 3600-EXIT.                     
           MOVE 1                   TO WS-UTIL-CHG-SUB.                 
           PERFORM 1310-DETERMINE-CHG-SUB THRU 1310-EXIT.               
           MOVE 1                   TO WS-HOLD-FACTOR-SUB.              
P00496     PERFORM UNTIL WS-HOLD-FACTOR-SUB > 50 OR                     
P00496                  WS-HOLD-FACTOR-FLAG(WS-HOLD-FACTOR-SUB) = SPACES
P00496             IF WS-FACTOR-BLK-LN-FL = 'Y' AND                     
P00496                WS-HOLD-FACTOR-SUB = 1                            
P00496                 MOVE 'Y' TO WS-UTIL-CHG-HDR-ROW                  
P00496                                 (WS-UTIL-SUB WS-UTIL-CHG-SUB)    
P00496                 ADD 1 TO WS-UTIL-CHG-SUB                         
P00496             END-IF                                               
                   MOVE WS-HOLD-FACTOR-DESC (WS-HOLD-FACTOR-SUB) TO     
                        WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
P00496             MOVE 'N' TO WS-UTIL-CHG-HDR-ROW                      
P00496                                 (WS-UTIL-SUB WS-UTIL-CHG-SUB)    
                   MOVE WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO      
                        WS-UTIL-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
                   ADD WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO       
                       WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                 
                   IF RTP                                               
                      ADD WS-HOLD-FACTOR-AMT (WS-HOLD-FACTOR-SUB) TO    
                          WS-TOTAL-RTP-CHARGES (WS-UTIL-SUB)            
                   END-IF                                               
                   ADD 1 TO WS-UTIL-CHG-SUB                             
                            WS-HOLD-FACTOR-SUB                          
           END-PERFORM.                                                 
                                                                        
           IF WS-REPLACE-FACTOR-ID > SPACES                             
               PERFORM VARYING WS-UTIL-CHG-SUB FROM 1 BY 1 UNTIL        
                 WS-UTIL-CHG-SUB > 200 OR                               
                 WS-UTIL-CHG-MSG(WS-UTIL-SUB WS-UTIL-CHG-SUB) <= SPACES 
                   SUBTRACT WS-UTIL-CHG-AMT(WS-UTIL-SUB WS-UTIL-CHG-SUB)
                       FROM WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)            
                   MOVE SPACES      TO                                  
                        WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
P00496                  WS-UTIL-CHG-HDR-ROW                             
P00496                                  (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
                   MOVE 0.00        TO                                  
                        WS-UTIL-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               END-PERFORM                                              
               MOVE WS-REPLACE-FACTOR-AMT TO                            
                    WS-UTIL-CHG-AMT (WS-UTIL-SUB 1)                     
               ADD WS-REPLACE-FACTOR-AMT TO                             
                   WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                     
               EVALUATE WS-REPLACE-FACTOR-ID                            
                   WHEN 'SPMNTMIN'                                      
                       MOVE 'Monthly Minimum Contract' TO               
                             WS-UTIL-CHG-MSG (WS-UTIL-SUB 1)            
P00496                 MOVE 'N' TO WS-UTIL-CHG-HDR-ROW                  
P00496                                 (WS-UTIL-SUB 1)                  
               END-EVALUATE                                             
           END-IF.                                                      
                                                                        
           IF RTP                                                       
T17207        MOVE 'Total RTP Charges    ' TO                           
T17207              WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)       
P00496        MOVE 'N' TO WS-UTIL-CHG-HDR-ROW                           
P00496                              (WS-UTIL-SUB WS-UTIL-CHG-SUB)       
T17207        MOVE WS-TOTAL-RTP-CHARGES (WS-UTIL-SUB) TO                
T17207             WS-UTIL-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)        
T17207        ADD 1 TO WS-UTIL-CHG-SUB                                  
T17207     END-IF.                                                      
                                                                        
           IF WS-UTIL-TOTAL (WS-UTIL-SUB) NOT =                         
              WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                          
                  MOVE 'C' TO WS-BILL-DEST-CODE                         
                  MOVE 'X' TO WS-SYSTEM-CNTRL-CODE                      
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  THIS ROUTINE FORMATS THE RATE IC DATA FOR NONE-CALCS.   *              
      ************************************************************              
                                                                        
       1050-FORMAT-NONE-CALC-UTIL-IC.                                   
                                                                        
           IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                         
               PERFORM 3700-NONE-CALC THRU 3700-EXIT                    
               MOVE 1               TO WS-UTIL-CHG-SUB                  
               PERFORM 1310-DETERMINE-CHG-SUB THRU 1310-EXIT            
               MOVE WS-HOLD-NONECALC-LITERAL TO                         
                    WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)       
P00496         MOVE 'N' TO WS-UTIL-CHG-HDR-ROW                          
P00496                              (WS-UTIL-SUB WS-UTIL-CHG-SUB)       
               IF WS-CODE-DR-CR-CNSMPTN-BG (SUB1) = 'C'                 
                   COMPUTE WS-UTIL-CHG-AMT(WS-UTIL-SUB WS-UTIL-CHG-SUB) 
                        =  WS-AMT-BILL-ITEM-BG (SUB1) * -1              
               ELSE                                                     
                   MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO                   
                        WS-UTIL-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               END-IF                                                   
               ADD WS-UTIL-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB) TO     
                   WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                     
           END-IF.                                                      
                                                                        
           IF WS-UTIL-TOTAL (WS-UTIL-SUB) NOT =                         
              WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                          
                  MOVE 'C' TO WS-BILL-DEST-CODE                         
                  MOVE 'X' TO WS-SYSTEM-CNTRL-CODE                      
           END-IF.                                                      
                                                                        
       1050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  THIS ROUTINE BUILDS A WORKING STORAGE TABLE CONTAINING  *              
      *  ALL ELECTRIC DEMAND RATES.  THE SUBSCRIPT FOR THIS      *              
      *  TABLE IS WS-UTIL-SUB.                                   *              
      ************************************************************              
                                                                        
       1100-BUILD-UTIL-TABLE.                                           
                                                                        
           IF WS-CODE-DR-CR-CNSMPTN-BG (SUB1) = 'C'                     
              COMPUTE WS-HOLD-AMT-BILL-ITEM =                           
                    WS-AMT-BILL-ITEM-BG (SUB1) * -1                     
           ELSE                                                         
              MOVE WS-AMT-BILL-ITEM-BG (SUB1) TO WS-HOLD-AMT-BILL-ITEM  
           END-IF                                                       
                                                                        
I2104A     IF WS-RATE-PLAN-NO-BG (SUB1) = 'PR1' OR 'Q22' OR 'Q20' OR    
I2104A        'Q18' OR 'Q14'                                            
I2104A        MOVE 'Y' TO WS-CRITICAL-PEAK-FL                           
I2104A     END-IF.                                                      
I2104A                                                                  
           IF  WS-UTIL-PLAN (WS-UTIL-SUB) = WS-RATE-PLAN-NO-BG (SUB1)   
           AND WS-UTIL-IC-NO (WS-UTIL-SUB) = WS-IC-NO-BG (SUB1)         
               ADD WS-HOLD-AMT-BILL-ITEM TO WS-UTIL-TOTAL (WS-UTIL-SUB) 
               IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                     
                  COMPUTE WS-UTIL-CURR-COST (WS-UTIL-SUB) =             
                          WS-UTIL-CURR-COST (WS-UTIL-SUB) +             
                          WS-HOLD-AMT-BILL-ITEM                         
               ELSE                                                     
                  COMPUTE WS-UTIL-CURR-COST (WS-UTIL-SUB) =             
                          WS-UTIL-CURR-COST (WS-UTIL-SUB) +             
                          WS-HOLD-AMT-BILL-ITEM      -                  
                          WS-AMT-STATE-TAX-BG (SUB1)                    
               END-IF                                                   
               PERFORM 1110-DETERMINE-CX-SUB THRU 1110-EXIT             
               PERFORM 1150-SUM-CURR-USAGE THRU 1150-EXIT               
               GO TO 1100-EXIT                                          
           ELSE                                                         
               IF WS-UTIL-PLAN (WS-UTIL-SUB) = SPACES                   
                  MOVE WS-RATE-PLAN-NO-BG (SUB1)                        
                     TO WS-UTIL-PLAN (WS-UTIL-SUB)                      
A02003             MOVE WS-BILL-FORMAT-CODE-RT (SUB1)                   
A02003               TO WS-UTIL-BILL-FORMAT-CODE (WS-UTIL-SUB)          
                   MOVE WS-IC-NO-BG (SUB1)                              
                     TO WS-UTIL-IC-NO (WS-UTIL-SUB)                     
                   MOVE WS-RATE-DESCRIPTION-CALC (SUB1)                 
                     TO WS-UTIL-DESC (WS-UTIL-SUB)                      
I01959             MOVE WS-BILL-LITTERAL-TX-CALC (SUB1)                 
I01959               TO WS-UTIL-BILL-LITERAL-TX (WS-UTIL-SUB)           
P01175             MOVE WS-RATE-SUB-GRP-TYPE(SUB1) TO                   
P01175                  WS-UTIL-RATE-SUB-GRP-TYPE (WS-UTIL-SUB)         
P01175             IF WS-RATE-SUB-GRP-TYPE(SUB1) = 'B' OR               
P01175                WS-RATE-SUB-GRP-TYPE(SUB1) = 'C' OR               
P01175                WS-RATE-SUB-GRP-TYPE(SUB1) = 'D' OR               
P01175                WS-RATE-SUB-GRP-TYPE(SUB1) = 'F'                  
P01175                MOVE WS-RATE-SUB-GRP-TYPE (SUB1)                  
P01175                            TO WS-RATE-SUB-GRP-TYPE-CD            
P01175                               WS-RATE-SUB-GRP-TYPE (WS-UTIL-SUB) 
P01175                               WS-170-RATE-SUB-GRP-TYPE-CD        
P01175             END-IF                                               
                   MOVE WS-CODE-UTIL-TYPE-BG (SUB1)                     
                     TO WS-UTIL-CODE-UTIL-TYPE (WS-UTIL-SUB)            
A03019             MOVE WS-BTU-FACTOR-BG (SUB1)    TO                   
A03019                  WS-UTIL-BTU-FACTOR (WS-UTIL-SUB)                
A12003****        LOAD GAS SUMMER BASE                     *****                
A02003             MOVE WS-GAS-BASE-USE-BG (SUB1) TO                    
A02003                  WS-UTIL-SUMMER-BASE (WS-UTIL-SUB)               
A12003****                                                 *****                
                   MOVE WS-HOLD-AMT-BILL-ITEM                           
                     TO WS-UTIL-TOTAL (WS-UTIL-SUB)                     
A12003****        THESE LINES ARE ADDED FOR RTP            *****                
                   MOVE WS-POWER-FACTOR-CALC (SUB1) TO                  
                        WS-UTIL-RTP-POWER-FACTOR (WS-UTIL-SUB)          
                   COMPUTE WS-UTIL-RTP-POWER-FACTOR (WS-UTIL-SUB) =     
                          WS-UTIL-RTP-POWER-FACTOR (WS-UTIL-SUB) * 100  
A12003****                                                 *****                
                  IF WS-CODE-BILL-CALC-BG (SUB1) = 'S'                  
                     COMPUTE WS-UTIL-CURR-COST (WS-UTIL-SUB) =          
                             WS-HOLD-AMT-BILL-ITEM                      
                  ELSE                                                  
                     COMPUTE WS-UTIL-CURR-COST (WS-UTIL-SUB) =          
                             WS-HOLD-AMT-BILL-ITEM      -               
                             WS-AMT-STATE-TAX-BG (SUB1)                 
                  END-IF                                                
                  PERFORM 1150-SUM-CURR-USAGE THRU 1150-EXIT            
                  GO TO 1100-EXIT                                       
               END-IF                                                   
           END-IF.                                                      
                                                                        
           ADD 1 TO WS-UTIL-SUB.                                        
           IF WS-UTIL-SUB > 20                                          
               MOVE 12                   TO RETURN-CODE                 
               MOVE 'OVER 20 UTIL RATES' TO WS-MISC-MSG-TEXT            
               MOVE +29                  TO WS-MISC-MSG-LEN             
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
               PERFORM 9999-BAIL-OUT THRU 9999-EXIT                     
           END-IF.                                                      
           GO TO 1100-BUILD-UTIL-TABLE.                                 
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  DETERMINE THE FIRST BLANK LINE IN THE METER TABLE.      *              
      *  THIS WILL BE NECESSARY ONLY WHEN ACCUMULATING DATA FOR  *              
      *  ONE IC FROM MULTIPLE BG SEGMENTS.                       *              
      ************************************************************              
                                                                        
       1110-DETERMINE-CX-SUB.                                           
                                                                        
           PERFORM VARYING WS-UTIL-CX-SUB FROM 1 BY 1 UNTIL             
              WS-UTIL-CX-SUB > 200  OR                                  
              WS-UTIL-METER (WS-UTIL-SUB WS-UTIL-CX-SUB) <= SPACES      
           END-PERFORM.                                                 
           IF WS-UTIL-CX-SUB > 200                                      
              MOVE 12          TO RETURN-CODE                           
              MOVE 'OVER 200 METERS' TO WS-MISC-MSG-TEXT                
              MOVE +15               TO WS-MISC-MSG-LEN                 
              PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
              PERFORM 9999-BAIL-OUT THRU 9999-EXIT                      
           END-IF.                                                      
                                                                        
       1110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  PROCESS ALL CONSUMPTION HISTORY RECORDS FOR THIS RATE,  *              
      *  SUMMING USAGE INTO THE CORRECT WORKING STORAGE TABLE.   *              
      *  READ DATE AND TIME, AS WELL AS NO READ REASON, ARE      *              
      *  OBTAINED.                                               *              
      ************************************************************              
                                                                        
       1150-SUM-CURR-USAGE.                                             
                                                                        
      ********  RTP CHANGES      ****                                           
           INITIALIZE WS-BASE-KWH-UNITS                                 
                      WS-BASE-KW-UNITS                                  
                      WS-BASE-KVA-UNITS.                                
           MOVE 'N'              TO WS-NEED-TOU-LOADED.                 
      *******************************                                           
           MOVE 'N'              TO WS-CNSMPTN-FOUND-FLAG.              
           PERFORM 1151-CHECK-METER-EXCHANGE THRU 1151-EXIT.            
                                                                        
           IF TOU-DEMAND                                                
              PERFORM 1160-PROCESS-RATE-20T     THRU 1160-EXIT          
           END-IF.                                                      
                                                                        
           MOVE 1 TO SUB3.                                              
           PERFORM UNTIL SUB3 > 200 OR WS-ACCOUNT-NO-CX (SUB3) = ZEROES 
             IF WS-ACCOUNT-NO-CX (SUB3)    = WS-ACCOUNT-NO-BG (SUB1)    
            AND WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S'                   
            AND WS-PRV-MTR-READ-COMB-FLG-CX (SUB3) NOT = 'S'            
            AND WS-BILL-NO-CX (SUB3)       = WS-BILL-NO-BG (SUB1)       
            AND WS-CODE-UTIL-TYPE-CX(SUB3) = WS-CODE-UTIL-TYPE-BG(SUB1) 
            AND WS-IC-NO-CX (SUB3)         = WS-IC-NO-BG (SUB1)         
            AND WS-BILL-ITEM-TIMESTMP-CX (SUB3) =                       
                WS-BILL-ITEM-TIMESTMP-BG (SUB1)                         
               PERFORM 1155-CHECK-MORE-COND   THRU 1155-EXIT            
             END-IF                                                     
             ADD 1 TO SUB3                                              
           END-PERFORM.                                                 
                                                                        
      ************************************************************              
      *  LOAD METER DATA                                         *              
      ************************************************************              
                                                                        
           IF NEED-TOU-LOADED                                           
              EVALUATE TRUE                                             
                  WHEN TOU-NONDEM                                       
I01959            WHEN SOLAR-TOU                                        
                     PERFORM 1216-LOAD-NDEM-UNITS THRU 1216-EXIT        
                  WHEN TOU-DEMAND                                       
                     PERFORM 1217-LOAD-DEM-UNITS THRU 1217-EXIT         
              END-EVALUATE                                              
           END-IF                                                       
                                                                        
I01959*    IF ELEC-NONDEM AND CNSMPTN-NOT-FOUND                                 
I01959     IF (ELEC-NONDEM OR SOLAR) AND CNSMPTN-NOT-FOUND              
              MOVE 1                         TO WS-UC-SUB               
              PERFORM VARYING WS-UC-SUB FROM 1 BY 1 UNTIL               
                WS-UC-SUB > 200 OR WS-ACCOUNT-NO-UC(WS-UC-SUB) = ZEROES 
                IF WS-ACCOUNT-NO-UC(WS-UC-SUB) = WS-ACCOUNT-NO-BG(SUB1) 
               AND WS-IC-NO-UC (WS-UC-SUB) = WS-IC-NO-BG (SUB1)         
               AND WS-CODE-UTIL-TYPE-UC (WS-UC-SUB) =                   
                   WS-CODE-UTIL-TYPE-BG (SUB1)                          
               AND WS-BILL-ITEM-TIMESTMP-UC (WS-UC-SUB) =               
                   WS-BILL-ITEM-TIMESTMP-BG (SUB1)                      
               AND WS-BILL-NO-UC (WS-UC-SUB) = WS-BILL-NO-BG (SUB1)     
                   MOVE WS-USAGE-FIXED-UC (WS-UC-SUB) TO                
                        WS-UTIL-CURR-USE (WS-UTIL-SUB)                  
                   MOVE WS-NO-DAYS-UC (WS-UC-SUB)     TO                
                        WS-UTIL-CURR-DAYS (WS-UTIL-SUB)                 
               END-IF                                                   
             END-PERFORM                                                
           END-IF.                                                      
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1151-CHECK-METER-EXCHANGE.                                       
      *                                                                         
           MOVE 1                        TO WS-CHECK-CX-SUB             
      *                                                                         
           PERFORM UNTIL WS-CODE-UTIL-TYPE-CX(WS-CHECK-CX-SUB) = SPACES 
              IF WS-CODE-UTIL-TYPE-CX(WS-CHECK-CX-SUB) =                
                 WS-CODE-UTIL-TYPE-BG (SUB1) AND                        
                 WS-CODE-METER-READ-CX(WS-CHECK-CX-SUB) = 'B'           
A12003*          EVALUATE WS-CODE-UTIL-TYPE-BG (SUB1)                           
A12003*              WHEN 'E'                                                   
                           MOVE 'Y'     TO WS-UTIL-METER-CHANGE         
A12003*              WHEN 'G'                                                   
A12003*                    MOVE 'Y'     TO WS-GAS-METER-CHANGE                  
A12003*          END-EVALUATE                                                   
                 MOVE 'N'                TO WS-MATCH-FOUND              
                 PERFORM VARYING WS-HOLD-BG-SUB FROM 1 BY 1 UNTIL       
                         MATCH-FOUND OR WS-ACCOUNT-NO-BG(WS-HOLD-BG-SUB)
                         EQUAL ZERO                                     
                     IF WS-ACCOUNT-NO-BG (WS-HOLD-BG-SUB) =             
                        WS-ACCOUNT-NO-CX (WS-CHECK-CX-SUB) AND          
                        WS-BILL-ITEM-TIMESTMP-BG (WS-HOLD-BG-SUB) =     
                        WS-BILL-ITEM-TIMESTMP-CX (WS-CHECK-CX-SUB) AND  
                        WS-CODE-UTIL-TYPE-BG (WS-HOLD-BG-SUB) =         
                        WS-CODE-UTIL-TYPE-CX (WS-CHECK-CX-SUB) AND      
                        WS-IC-NO-BG (WS-HOLD-BG-SUB) =                  
                        WS-IC-NO-CX (WS-CHECK-CX-SUB)                   
                         MOVE WS-NO-OF-CONS-DAYS-BG (WS-HOLD-BG-SUB)    
                           TO WS-HOLD-NO-OF-DAYS                        
                         MOVE 'Y' TO WS-MATCH-FOUND                     
                     END-IF                                             
                 END-PERFORM                                            
              END-IF                                                    
              ADD 1 TO WS-CHECK-CX-SUB                                  
           END-PERFORM.                                                 
                                                                        
       1151-EXIT.                                                       
           EXIT.                                                        
A02003                                                                  
A02003***************************************************************           
A02003*  BASED ON RATE FORMAT BUILD SUMM CURR USAGE                 *           
A02003***************************************************************           
A02003 1155-CHECK-MORE-COND.                                            
A02003      EVALUATE TRUE                                               
A02003         WHEN ELEC-NONDEM                                         
I01959         WHEN SOLAR                                               
A02003          IF WS-CODE-USAGE-TYPE-CX (SUB3) = 'B' AND               
A02003             WS-CODE-USAGE-ID-CX (SUB3) NOT NUMERIC               
A02003            PERFORM 1165-ELEC-NON-DEM         THRU 1165-EXIT      
A02003           END-IF                                                 
A02003         WHEN ELEC-DEMAND                                         
A02003         WHEN WHOLESALE                                           
A02003           IF  WS-CODE-USAGE-ID-CX (SUB3) = ('A' OR 'F') AND      
A02003* BILLING CHECKS ONLY FOR CODE ITEM STATUS NOT = 'K'                      
A02003            WS-CODE-ITEM-STATUS-CX (SUB3) NOT = 'K'               
A02003            PERFORM 1166-ELEC-DEM-WHSL        THRU 1166-EXIT      
A02003           END-IF                                                 
A02003         WHEN GAS                                                 
A02003           IF WS-CODE-ITEM-STATUS-CX (SUB3) NOT = 'I' AND         
A02003              WS-CODE-USAGE-TYPE-CX (SUB3) = 'C'                  
A02003               PERFORM 1170-BUILD-GAS-DETAILS     THRU 1170-EXIT  
A02003           END-IF                                                 
A02003         WHEN TOU-NONDEM                                          
A02003         WHEN TOU-DEMAND                                          
I01959         WHEN SOLAR-TOU                                           
A02003            IF WS-CODE-TIME-PERIOD-CX (SUB3) > 0                  
A02003               PERFORM 1175-BUILD-TOU-DETAILS     THRU 1175-EXIT  
A02003            END-IF                                                
A02003         WHEN RTP                                                 
A02003            IF WS-CODE-ITEM-STATUS-CX (SUB3) = 'I'                
A02003               PERFORM 1180-BUILD-RTP-DETAILS     THRU 1180-EXIT  
A02003            END-IF                                                
A02003      END-EVALUATE.                                               
A02003 1155-EXIT.                                                       
A02003     EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * IF RATE 20T IS PROCESSED THEN CHECK IF THE CODE TIME PERIOD IS *        
      * ZERO AS RATE 20T IS PARTIALLY TOU AND THE DEMAND SIDE IS NOT   *        
      * TOU.                                                           *        
      ******************************************************************        
      *                                                                         
       1160-PROCESS-RATE-20T.                                           
           MOVE 1 TO SUB3.                                              
           PERFORM UNTIL SUB3 > 200 OR WS-ACCOUNT-NO-CX (SUB3) = ZEROES 
             IF WS-ACCOUNT-NO-CX (SUB3) = WS-ACCOUNT-NO-BG (SUB1)       
            AND WS-BILL-NO-CX (SUB3) = WS-BILL-NO-BG (SUB1)             
            AND WS-CODE-UTIL-TYPE-CX(SUB3) = WS-CODE-UTIL-TYPE-BG(SUB1) 
            AND WS-IC-NO-CX (SUB3) = WS-IC-NO-BG (SUB1)                 
            AND WS-BILL-ITEM-TIMESTMP-CX (SUB3) =                       
                WS-BILL-ITEM-TIMESTMP-BG (SUB1)                         
            AND WS-RATE-PLAN-NO-BG (SUB1) = '20T'                       
            AND WS-CODE-TIME-PERIOD-CX (SUB3) = 0                       
            AND WS-PRV-MTR-READ-COMB-FLG-CX(SUB3) NOT= 'S'              
                 MOVE 1                         TO USAGE-SUB            
                 EVALUATE WS-CODE-USAGE-TYPE-CX (SUB3) ALSO             
                          WS-CODE-USAGE-ID-CX (SUB3)                    
                     WHEN 'B' ALSO 'A'                                  
                     WHEN 'B' ALSO 'F'                                  
                          MOVE 'Y' TO WS-DEM-FLAG (USAGE-SUB)           
                          IF WS-CODE-DEBIT-CREDIT-CX (SUB3) = 'C'       
A12003                       SUBTRACT WS-NO-UNITS-CX (SUB3) FROM        
A12003                            WS-UTIL-CURR-USE (WS-UTIL-SUB)        
                             SUBTRACT WS-NO-UNITS-CX (SUB3) FROM        
                                  WS-KWH-UNITS (USAGE-SUB)              
                          ELSE                                          
A12003                       ADD WS-NO-UNITS-CX (SUB3) TO               
A12003                           WS-UTIL-CURR-USE (WS-UTIL-SUB)         
                             ADD WS-NO-UNITS-CX (SUB3) TO               
                                 WS-KWH-UNITS (USAGE-SUB)               
                          END-IF                                        
                          IF WS-DATE-READ-CX (SUB3) >                   
                             WS-UTIL-DATE-READ (WS-UTIL-SUB)            
                             MOVE WS-DATE-READ-CX (SUB3) TO             
                                  WS-UTIL-DATE-READ (WS-UTIL-SUB)       
                             PERFORM 1210-GET-TIME-READ THRU 1210-EXIT  
                          END-IF                                        
                          MOVE WS-CODE-METER-NO-READ-CX (SUB3) TO       
                               WS-UTIL-NO-READ-REASON(WS-UTIL-SUB)      
                          MOVE WS-CODE-METER-READ-CX (SUB3) TO          
                             WS-UTIL-CODE-METER-READ(WS-UTIL-SUB)       
                          PERFORM 1200-METER-INFO THRU 1200-EXIT        
                          MOVE 'Y'      TO WS-NEED-TOU-LOADED           
                          MOVE 1        TO WS-UTIL-SUM-SUB              
                          MOVE 1        TO WS-CODE-TIME-PERIOD-CX (SUB3)
                          IF WS-CODE-USAGE-ID-CX (SUB3) = 'F'           
                            MOVE 1      TO WS-UTIL-NM-SUB               
                            MOVE 'N'    TO WS-UTIL-DEM-NM-FLAG          
                            PERFORM 1270-SUMMARIZE-NM-TOU THRU 1270-EXIT
                          ELSE                                          
                            MOVE 1      TO WS-UTIL-SUM-SUB              
                            MOVE 'N'    TO WS-UTIL-DEM-SUM-FLAG         
                            PERFORM 1265-SUMMARIZE-TOU THRU 1265-EXIT   
                          END-IF                                        
T25539                    MOVE 0 TO WS-CODE-TIME-PERIOD-CX (SUB3)       
                  END-EVALUATE                                          
               END-IF                                                   
               ADD 1 TO SUB3                                            
           END-PERFORM.                                                 
                                                                        
       1160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *  1165 - ELECTRIC NON DEMAND                                 *           
      ***************************************************************           
       1165-ELEC-NON-DEM.                                               
                                                                        
           MOVE 'Y'                      TO WS-CNSMPTN-FOUND-FLAG.      
           PERFORM 1201-KWH-USAGE        THRU 1201-EXIT.                
                                                                        
       1165-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *  1166 - ELECTRIC DEMAND & WHOLESALE METER INFO              *           
      ***************************************************************           
       1166-ELEC-DEM-WHSL.                                              
                                                                        
           EVALUATE WS-CODE-USAGE-TYPE-CX (SUB3) ALSO                   
                    WS-CODE-USAGE-SOURCE-CX (SUB3)                      
               WHEN 'B' ALSO 'B'                                        
               WHEN 'B' ALSO 'J'                                        
               WHEN 'B' ALSO 'K'                                        
                   PERFORM 1201-KWH-USAGE THRU 1201-EXIT                
               WHEN 'J' ALSO ANY                                        
                   PERFORM 1202-KW-USAGE THRU 1202-EXIT                 
               WHEN 'E' ALSO ANY                                        
                   PERFORM 1203-KVA-USAGE THRU 1203-EXIT                
I01959         WHEN 'B' ALSO 'C'                                        
I01959             IF WS-REG-ID-NO-CX (SUB3) = 11                       
I01959                PERFORM 1201-KWH-USAGE THRU 1201-EXIT             
I01959             END-IF                                               
           END-EVALUATE.                                                
       1166-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      *  1170 - GAS - SCEG & PSNC                                   *           
      ***************************************************************           
       1170-BUILD-GAS-DETAILS.                                          
           PERFORM 1204-NEW-METER-CHECK THRU 1204-EXIT.                 
           IF (WS-METER-NO-CX (SUB3) NOT = WS-HOLD-METER-NO) OR         
              (WS-METER-NO-CX (SUB3) = WS-HOLD-METER-NO AND             
               WS-PRV-MTR-READ-COMB-FLG-CX (SUB3) = 'N')                
              MOVE WS-PCOMP-FCT-CX (SUB3) TO WS-HOLD-PCOMP              
           ELSE                                                         
               IF WS-PCOMP-FCT-CX (SUB3) EQUAL TO WS-HOLD-PCOMP         
                  MOVE SPACES TO                                        
                       WS-UTIL-METER (WS-UTIL-SUB WS-UTIL-CX-SUB)       
                       WS-UTIL-SUPPLYING (WS-UTIL-SUB WS-UTIL-CX-SUB)   
               ELSE                                                     
                   MOVE WS-PCOMP-FCT-CX (SUB3) TO WS-HOLD-PCOMP         
               END-IF                                                   
           END-IF.                                                      
                                                                        
           IF WS-PCOMP-FCT-CX (SUB3) > 1                                
               MOVE 'Y' TO WS-HDR-IC-PCOMP-DISP-FL (WS-UTIL-SUB)        
           END-IF.                                                      
           MOVE WS-PCOMP-FCT-CX (SUB3) TO                               
                WS-UTIL-PCOMP (WS-UTIL-SUB WS-UTIL-CX-SUB).             
                                                                        
           PERFORM 1200-METER-INFO      THRU 1200-EXIT.                 
                                                                        
            COMPUTE WS-LONG-NO-THERMS =                                 
                    WS-NO-UNITS-CX (SUB3) * WS-BTU-FACTOR-BG (SUB1)     
            IF WS-CODE-DEBIT-CREDIT-CX (SUB3) = 'C'                     
               COMPUTE WS-LONG-NO-THERMS = WS-LONG-NO-THERMS * (-1)     
            END-IF                                                      
            IF (WS-METER-NO-CX (SUB3) NOT = WS-TEMP-METER-NO) OR        
               (WS-METER-NO-CX (SUB3) = WS-TEMP-METER-NO AND            
               WS-PRV-MTR-READ-COMB-FLG-CX (SUB3) = 'N')                
               MOVE WS-LONG-NO-THERMS     TO WS-HOLD-SUM-THERMS         
               MOVE WS-METER-NO-CX (SUB3) TO WS-TEMP-METER-NO           
            ELSE                                                        
               ADD  WS-LONG-NO-THERMS     TO WS-HOLD-SUM-THERMS         
            END-IF.                                                     
            COMPUTE WS-RND-NO-THERMS ROUNDED = WS-HOLD-SUM-THERMS * 1.  
            MOVE WS-RND-NO-THERMS TO                                    
                 WS-UTIL-THERM-USAGE (WS-UTIL-SUB WS-UTIL-CX-SUB)       
            PERFORM 1172-POPULATE-CURR-USE THRU 1172-EXIT.              
            ADD WS-NO-DAYS-CX (SUB3) TO WS-UTIL-CURR-DAYS (WS-UTIL-SUB).
                                                                        
       1170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *  THIS ROUTINE IS USED TO POPULATE THE GAS CURR USAGE FROM THE*          
      *  NET UNITS FROM THE TABLE BC INSTEAD OF ADDING THE USAGE FROM*          
      *  BG.                                                         *          
      ****************************************************************          
       1172-POPULATE-CURR-USE.                                          
           MOVE 1                         TO SUB2.                      
           MOVE 'N'                       TO WS-CURR-USE-LOADED-FL.     
           PERFORM UNTIL SUB2 > WS-BZ-MAX-ENTRY OR                      
                  WS-ACCOUNT-NO-BC (SUB2) = ZEROES OR                   
                  WS-CURR-USE-LOADED-FL = 'Y'                           
               IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BC (SUB2) AND 
                  WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BC (SUB2) AND       
                  WS-CODE-UTIL-TYPE-BG (SUB1) =                         
                  WS-CODE-UTIL-TYPE-BC (SUB2) AND                       
                  WS-IC-NO-BG (SUB1) = WS-IC-NO-BC (SUB2) AND           
                  WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                     
                  WS-BILL-ITEM-TIMESTMP-BC (SUB2)                       
                  IF WS-NET-UNITS-BC(SUB2) > 0                          
                     MOVE WS-NET-UNITS-BC(SUB2)   TO                    
                          WS-UTIL-CURR-USE (WS-UTIL-SUB)                
                     MOVE WS-READ-UNITS-BC(SUB2)  TO                    
                          WS-UTIL-TOT-READ-UNITS (WS-UTIL-SUB)          
                     MOVE 'N'            TO WS-CURR-USE-LOADED-FL       
                  END-IF                                                
               END-IF                                                   
               ADD 1 TO SUB2                                            
            END-PERFORM.                                                
                                                                        
       1172-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *  1175 - TOU DEMAND AND NON DEMAND                           *           
      ***************************************************************           
                                                                        
       1175-BUILD-TOU-DETAILS.                                          
           IF WS-METER-NO-CX (SUB3) NOT = WS-HOLD-METER-NO OR           
             (WS-CODE-USAGE-ID-CX (SUB3) NOT = WS-HOLD-USAGE-ID AND     
              TOU-NONDEM)                                               
I01959        OR (WS-CODE-USAGE-ID-CX (SUB3) NOT = WS-HOLD-USAGE-ID AND 
I01959        SOLAR-TOU)                                                
               IF WS-HOLD-METER-NO > SPACES                             
                   EVALUATE TRUE                                        
                     WHEN TOU-NONDEM                                    
I01959               WHEN SOLAR-TOU                                     
                        PERFORM 1216-LOAD-NDEM-UNITS THRU 1216-EXIT     
                     WHEN TOU-DEMAND                                    
                        MOVE 'Y' TO WS-MULTI-METER-FLAG                 
A12003                  IF WS-UTIL-METER-CHANGE = 'Y'                   
                           MOVE WS-HOLD-NO-OF-DAYS TO                   
                                WS-UTIL-CURR-DAYS (WS-UTIL-SUB)         
                        ELSE                                            
                           MOVE WS-NO-DAYS-CX (SUB3) TO                 
                                WS-UTIL-CURR-DAYS (WS-UTIL-SUB)         
                        END-IF                                          
                        PERFORM 1217-LOAD-DEM-UNITS THRU 1217-EXIT      
                   END-EVALUATE                                         
               END-IF                                                   
               MOVE WS-METER-NO-CX (SUB3)      TO WS-HOLD-METER-NO      
               MOVE WS-CODE-USAGE-ID-CX (SUB3) TO WS-HOLD-USAGE-ID      
I01959         IF (TOU-NONDEM OR SOLAR-TOU)                             
                  PERFORM 1218-CHECK-FOR-SEASON-CHANGE THRU 1218-EXIT   
               END-IF                                                   
           END-IF.                                                      
           MOVE WS-CODE-TIME-PERIOD-CX (SUB3) TO USAGE-SUB.             
           EVALUATE WS-CODE-USAGE-TYPE-CX (SUB3) ALSO                   
                    WS-CODE-USAGE-ID-CX (SUB3)                          
               WHEN 'B' ALSO 'A'                                        
               WHEN 'B' ALSO 'F'                                        
                   EVALUATE TRUE                                        
                       WHEN TOU-NONDEM                                  
I01959                 WHEN SOLAR-TOU                                   
                           MOVE 'Y' TO WS-NDEM-FLAG (USAGE-SUB)         
                       WHEN TOU-DEMAND                                  
                           MOVE 'Y' TO WS-DEM-FLAG (USAGE-SUB)          
                   END-EVALUATE                                         
                   IF WS-CODE-DEBIT-CREDIT-CX (SUB3) = 'C'              
A12003                SUBTRACT WS-NO-UNITS-CX (SUB3) FROM               
A12003                    WS-UTIL-CURR-USE (WS-UTIL-SUB)                
                      SUBTRACT WS-NO-UNITS-CX (SUB3) FROM               
                          WS-KWH-UNITS (USAGE-SUB)                      
                   ELSE                                                 
A12003                ADD WS-NO-UNITS-CX (SUB3) TO                      
A12003                    WS-UTIL-CURR-USE (WS-UTIL-SUB)                
                      ADD WS-NO-UNITS-CX (SUB3) TO                      
                          WS-KWH-UNITS (USAGE-SUB)                      
                   END-IF                                               
I01959             IF (TOU-NONDEM OR SOLAR-TOU)                         
                     EVALUATE WS-CODE-TOU-SEASN-CX (SUB3)               
                       WHEN 'C'                                         
                           MOVE WS-NO-UNITS-CX (SUB3) TO                
                                   WS-NDEM-CSEA-KWH (USAGE-SUB)         
P01175                     IF WS-CODE-DEBIT-CREDIT-CX(SUB3)='C' AND     
P01175                        WS-170-RATE-SUB-GRP-TYPE-CD NOT = 'B' AND 
P01175                        WS-170-RATE-SUB-GRP-TYPE-CD NOT = 'D' AND 
P01175                        WS-170-RATE-SUB-GRP-TYPE-CD NOT = 'C' AND 
P01175                        WS-170-RATE-SUB-GRP-TYPE-CD NOT = 'F'     
                              COMPUTE WS-NDEM-CSEA-KWH (USAGE-SUB)=     
                                      WS-NDEM-CSEA-KWH (USAGE-SUB) * -1 
                           END-IF                                       
                           MOVE WS-READ-INDEX-UNITS-CX (SUB3) TO        
                                WS-NDEM-CSEA-INDEX-DIFF (USAGE-SUB)     
                                                                        
                           MOVE WS-METER-READING-CX (SUB3) TO           
                                WS-NDEM-CSEA-CURR-INDEX (USAGE-SUB)     
                           IF WS-SEASON-CHANGE = 'Y'                    
                               CONTINUE                                 
                           ELSE                                         
                               MOVE WS-PREV-METER-READ-CALC (SUB3)      
                                 TO WS-NDEM-CSEA-PREV-INDEX (USAGE-SUB) 
                           END-IF                                       
                           MOVE WS-CONSTANT-CX (SUB3) TO                
                                WS-NDEM-CSEA-CONSTANT (USAGE-SUB)       
                           MOVE WS-NO-DIALS-CX (SUB3) TO                
                                WS-NDEM-CSEA-NO-DIALS (USAGE-SUB)       
                       WHEN 'P'                                         
                           MOVE WS-NO-UNITS-CX (SUB3) TO                
                                   WS-NDEM-PSEA-KWH (USAGE-SUB)         
P01175                     IF WS-CODE-DEBIT-CREDIT-CX(SUB3)='C' AND     
P01175                        WS-170-RATE-SUB-GRP-TYPE-CD NOT = 'B' AND 
P01175                        WS-170-RATE-SUB-GRP-TYPE-CD NOT = 'D' AND 
P01175                        WS-170-RATE-SUB-GRP-TYPE-CD NOT = 'C' AND 
P01175                        WS-170-RATE-SUB-GRP-TYPE-CD NOT = 'F'     
                              COMPUTE WS-NDEM-PSEA-KWH (USAGE-SUB)      
                                    = WS-NDEM-PSEA-KWH (USAGE-SUB) * -1 
                           END-IF                                       
                           MOVE WS-READ-INDEX-UNITS-CX (SUB3) TO        
                                WS-NDEM-PSEA-INDEX-DIFF (USAGE-SUB)     
                           MOVE WS-METER-READING-CX (SUB3) TO           
                                WS-NDEM-PSEA-CURR-INDEX (USAGE-SUB)     
                                WS-NDEM-CSEA-PREV-INDEX (USAGE-SUB)     
                           MOVE WS-PREV-METER-READ-CALC (SUB3)          
                             TO WS-NDEM-PSEA-PREV-INDEX (USAGE-SUB)     
                           MOVE WS-CONSTANT-CX (SUB3) TO                
                                WS-NDEM-PSEA-CONSTANT (USAGE-SUB)       
                           MOVE WS-NO-DIALS-CX (SUB3) TO                
                                WS-NDEM-PSEA-NO-DIALS (USAGE-SUB)       
ACT059                 WHEN OTHER                                       
ACT059                     MOVE WS-CONSTANT-CX (SUB3) TO                
ACT059                          WS-NDEM-CSEA-CONSTANT (USAGE-SUB)       
                     END-EVALUATE                                       
                   END-IF                                               
                   IF WS-DATE-READ-CX (SUB3) >                          
                          WS-UTIL-DATE-READ (WS-UTIL-SUB)               
                       MOVE WS-DATE-READ-CX (SUB3) TO                   
                          WS-UTIL-DATE-READ (WS-UTIL-SUB)               
                       PERFORM 1210-GET-TIME-READ THRU 1210-EXIT        
                   END-IF                                               
                   MOVE WS-CODE-METER-NO-READ-CX (SUB3) TO              
                        WS-UTIL-NO-READ-REASON (WS-UTIL-SUB)            
                   MOVE WS-CODE-METER-READ-CX (SUB3) TO                 
                        WS-UTIL-CODE-METER-READ (WS-UTIL-SUB)           
                   IF (TOU-DEMAND AND WS-CODE-TIME-PERIOD-CX (SUB3) = 1)
I01959             OR TOU-NONDEM OR SOLAR-TOU                           
                      PERFORM 1200-METER-INFO THRU 1200-EXIT            
                      MOVE 'Y'                   TO WS-NEED-TOU-LOADED  
                      PERFORM 1205-METER-ENVRNMT-INFO THRU 1205-EXIT    
                   END-IF                                               
               WHEN 'J' ALSO 'A'                                        
                   EVALUATE TRUE                                        
                       WHEN TOU-NONDEM                                  
I01959                 WHEN SOLAR-TOU                                   
                           MOVE 'Y' TO WS-NDEM-FLAG (USAGE-SUB)         
                       WHEN TOU-DEMAND                                  
                           MOVE 'Y' TO WS-DEM-FLAG (USAGE-SUB)          
                   END-EVALUATE                                         
I01959             IF (TOU-NONDEM OR SOLAR-TOU)                         
                      EVALUATE WS-CODE-TOU-SEASN-CX (SUB3)              
                        WHEN 'C'                                        
                            ADD WS-NO-DEMAND-UNITS-CX (SUB3) TO         
                                WS-NDEM-CSEA-KW (USAGE-SUB)             
                        WHEN 'P'                                        
                            ADD WS-NO-DEMAND-UNITS-CX (SUB3) TO         
                                  WS-NDEM-PSEA-KW (USAGE-SUB)           
                      END-EVALUATE                                      
                   END-IF                                               
                   IF TOU-DEMAND                                        
A03343                IF WS-UTIL-METER-CHANGE = 'Y'                     
A03343                   IF WS-NO-DEMAND-UNITS-CX (SUB3) >              
A03343                      WS-KW-UNITS (USAGE-SUB)                     
A03343                      MOVE WS-NO-DEMAND-UNITS-CX (SUB3) TO        
A03343                           WS-KW-UNITS (USAGE-SUB)                
A03343                   END-IF                                         
A03343                ELSE                                              
A03343                   ADD WS-NO-DEMAND-UNITS-CX (SUB3) TO            
A03343                       WS-KW-UNITS (USAGE-SUB)                    
A03343                END-IF                                            
                   END-IF                                               
               WHEN 'E' ALSO 'A'                                        
                   EVALUATE TRUE                                        
                       WHEN TOU-NONDEM                                  
I01959                 WHEN SOLAR-TOU                                   
                           MOVE 'Y' TO WS-NDEM-FLAG (USAGE-SUB)         
                       WHEN TOU-DEMAND                                  
                           MOVE 'Y' TO WS-DEM-FLAG (USAGE-SUB)          
                   END-EVALUATE                                         
A03343             IF WS-UTIL-METER-CHANGE = 'Y'                        
A03343                IF WS-NO-DEMAND-UNITS-CX (SUB3) >                 
A03343                   WS-KVA-UNITS (USAGE-SUB)                       
A03343                   MOVE WS-NO-DEMAND-UNITS-CX (SUB3) TO           
A03343                        WS-KVA-UNITS (USAGE-SUB)                  
A03343                END-IF                                            
A03343             ELSE                                                 
A03343                ADD WS-NO-DEMAND-UNITS-CX (SUB3) TO               
A03343                    WS-KVA-UNITS (USAGE-SUB)                      
A03343             END-IF                                               
           END-EVALUATE.                                                
           IF TOU-DEMAND                                                
             IF WS-CODE-USAGE-ID-CX (SUB3) = 'F'                        
                MOVE 1                 TO WS-UTIL-NM-SUB                
                PERFORM 1270-SUMMARIZE-NM-TOU THRU 1270-EXIT            
             ELSE                                                       
                MOVE 1                 TO WS-UTIL-SUM-SUB               
                PERFORM 1265-SUMMARIZE-TOU    THRU 1265-EXIT            
             END-IF                                                     
           END-IF.                                                      
                                                                        
A03343      IF TOU-DEMAND AND WS-UTIL-METER-CHANGE = 'Y'                
A03343         MOVE WS-HOLD-NO-OF-DAYS TO                               
A03343                 WS-UTIL-CURR-DAYS (WS-UTIL-SUB)                  
A03343      ELSE                                                        
A03343         ADD WS-NO-DAYS-CX (SUB3) TO                              
A03343             WS-UTIL-CURR-DAYS (WS-UTIL-SUB)                      
A03343      END-IF.                                                     
                                                                        
       1175-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      *  1180 - RTP DETAILS                                         *           
      ***************************************************************           
                                                                        
       1180-BUILD-RTP-DETAILS.                                          
                                                                        
           IF WS-DATE-READ-CX (SUB3) > WS-UTIL-DATE-READ (WS-UTIL-SUB)  
              MOVE WS-DATE-READ-CX (SUB3) TO                            
                       WS-UTIL-DATE-READ (WS-UTIL-SUB)                  
              PERFORM 1210-GET-TIME-READ THRU 1210-EXIT                 
           END-IF.                                                      
           MOVE WS-CODE-METER-NO-READ-CX (SUB3) TO                      
                WS-UTIL-NO-READ-REASON (WS-UTIL-SUB).                   
           MOVE WS-CODE-METER-READ-CX (SUB3) TO                         
                WS-UTIL-CODE-METER-READ (WS-UTIL-SUB).                  
           EVALUATE WS-CODE-USAGE-TYPE-CX (SUB3)                        
               WHEN 'E'                                                 
                   ADD WS-METER-READING-CX (SUB3) TO                    
                       WS-UTIL-RTP-BILLING-DEM (WS-UTIL-SUB)            
                   ADD WS-DEMAND-READING-CX (SUB3) TO                   
                       WS-UTIL-RTP-SUM-KVA (WS-UTIL-SUB)                
               WHEN 'J'                                                 
                   ADD WS-METER-READING-CX (SUB3) TO                    
                       WS-UTIL-RTP-BILLING-DEM (WS-UTIL-SUB)            
                   ADD WS-DEMAND-READING-CX (SUB3) TO                   
                       WS-UTIL-RTP-SUM-KW (WS-UTIL-SUB)                 
               WHEN 'B'                                                 
                  PERFORM 1200-METER-INFO THRU 1200-EXIT                
                  PERFORM 1205-METER-ENVRNMT-INFO THRU 1205-EXIT        
                  ADD 1                 TO WS-UTIL-CX-SUB               
           END-EVALUATE.                                                
                                                                        
       1180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *  METER SUPPLYING COMES FROM THE METERED ENVIRONMENT SEGMENT.*           
      ***************************************************************           
                                                                        
       1200-METER-INFO.                                                 
                                                                        
           MOVE WS-UTIL-CX-SUB       TO WS-SAVE-CX-SUB.                 
           MOVE WS-METER-NO-CX (SUB3) TO MN-METER-NO                    
                WS-UTIL-METER (WS-UTIL-SUB WS-UTIL-CX-SUB).             
      * MULTIPLE IS ONLY FOR TOU DEM MULTIPLE METERS                            
           IF WS-MULTI-METER-FLAG = 'Y' AND TOU-DEMAND                  
              MOVE 'MULTIPLE'            TO WS-TEMP-METER-NO            
                   WS-UTIL-METER (WS-UTIL-SUB WS-UTIL-CX-SUB)           
           END-IF.                                                      
           MOVE WS-NO-DIALS-CX (SUB3) TO                                
                WS-UTIL-NO-DIALS (WS-UTIL-SUB WS-UTIL-CX-SUB).          
           MOVE WS-CONSTANT-CX (SUB3) TO                                
                WS-UTIL-CONSTANT (WS-UTIL-SUB WS-UTIL-CX-SUB).          
           MOVE WS-ACCOUNT-NO-MN (WS-MTRD-INDX)  TO MN-ACCOUNT-NO.      
           MOVE WS-METER-READING-CX (SUB3) TO                           
                WS-UTIL-CURR-READING (WS-UTIL-SUB WS-UTIL-CX-SUB).      
           MOVE WS-DATE-READ-CX (SUB3) TO WS-END-DATE                   
                   WS-UTIL-END-DATE-NUM (WS-UTIL-SUB WS-UTIL-CX-SUB).   
           MOVE WS-DATE-READ-CX (SUB3) TO WS-UNFORMAT-DATE.             
           MOVE SPACES TO WS-ENGLISH-DATE.                              
           MOVE WS-UNFORMAT-DATE(9:2) TO WS-ENGLISH-DD.                 
           PERFORM 4000-ENGLISH-MONTH THRU 4000-EXIT.                   
           MOVE WS-ENGLISH-DATE TO                                      
                WS-UTIL-END-DATE (WS-UTIL-SUB WS-UTIL-CX-SUB).          
                                                                        
           IF TOU-DEMAND  AND WS-UTIL-METER-CHANGE = 'Y'                
              MOVE WS-HOLD-NO-OF-DAYS TO                                
               WS-UTIL-DAYS (WS-UTIL-SUB WS-UTIL-CX-SUB)                
              IF WS-UTIL-ST-DATE-NUM                                    
                (WS-UTIL-SUB WS-UTIL-CX-SUB) = SPACES                   
                 MOVE WS-PREV-METER-READ-DATE-CALC (SUB3) TO            
                      WS-UTIL-ST-DATE-NUM (WS-UTIL-SUB WS-UTIL-CX-SUB)  
              END-IF                                                    
              IF WS-UTIL-ST-DATE-NUM                                    
                (WS-UTIL-SUB WS-UTIL-CX-SUB) > SPACES AND               
                 WS-PREV-METER-READ-DATE-CALC (SUB3) <                  
                 WS-UTIL-ST-DATE-NUM (WS-UTIL-SUB WS-UTIL-CX-SUB)       
                 MOVE WS-PREV-METER-READ-DATE-CALC (SUB3) TO            
                      WS-START-DATE                                     
                      WS-UTIL-ST-DATE-NUM (WS-UTIL-SUB WS-UTIL-CX-SUB)  
              END-IF                                                    
           ELSE                                                         
             IF WS-PRV-MTR-READ-COMB-FLG-CX(SUB3) = 'N'                 
               MOVE WS-PREV-METER-READ-DATE-CALC (SUB3) TO WS-START-DATE
                     WS-HOLD-PREV-METER-READ-DATE                       
                     WS-UTIL-ST-DATE-NUM (WS-UTIL-SUB WS-UTIL-CX-SUB)   
A02003               WS-UNFORMAT-DATE                                   
                MOVE WS-PREV-METER-READ-CALC (SUB3) TO                  
                     WS-UTIL-PREV-READING (WS-UTIL-SUB WS-UTIL-CX-SUB)  
                     WS-HOLD-PREV-METER-READ-CALC                       
      * CHECK FOR RTP AS WS-METER-READING-CX (SUB3) IS USED FOR USAGE           
                MOVE WS-NO-UNITS-CX (SUB3) TO                           
                     WS-UTIL-USAGE (WS-UTIL-SUB WS-UTIL-CX-SUB)         
                MOVE WS-READ-INDEX-UNITS-CX (SUB3) TO                   
                     WS-UTIL-READING-DIFF (WS-UTIL-SUB WS-UTIL-CX-SUB)  
P01175          IF WS-CODE-DEBIT-CREDIT-CX (SUB3) = 'C'  AND            
P01175             WS-170-RATE-SUB-GRP-TYPE-CD NOT = 'B' AND            
P01175             WS-170-RATE-SUB-GRP-TYPE-CD NOT = 'D' AND            
P01175             WS-170-RATE-SUB-GRP-TYPE-CD NOT = 'C' AND            
P01175             WS-170-RATE-SUB-GRP-TYPE-CD NOT = 'F'                
                    COMPUTE  WS-UTIL-USAGE (WS-UTIL-SUB WS-UTIL-CX-SUB) 
                    =  WS-UTIL-USAGE (WS-UTIL-SUB WS-UTIL-CX-SUB) * -1  
               END-IF                                                   
               MOVE WS-NO-DAYS-CX (SUB3) TO                             
                    WS-UTIL-DAYS (WS-UTIL-SUB WS-UTIL-CX-SUB)           
             ELSE                                                       
               MOVE WS-HOLD-PREV-METER-READ-DATE TO WS-START-DATE       
                    WS-UTIL-ST-DATE-NUM (WS-UTIL-SUB WS-UTIL-CX-SUB)    
A02003              WS-UNFORMAT-DATE                                    
               MOVE WS-HOLD-PREV-METER-READ-CALC   TO                   
                    WS-UTIL-PREV-READING (WS-UTIL-SUB WS-UTIL-CX-SUB)   
               IF WS-CODE-DEBIT-CREDIT-CX (SUB3) = 'C'                  
                  SUBTRACT WS-NO-UNITS-CX (SUB3) FROM                   
                           WS-UTIL-USAGE (WS-UTIL-SUB WS-UTIL-CX-SUB)   
               ELSE                                                     
                  ADD WS-NO-UNITS-CX (SUB3) TO                          
                    WS-UTIL-USAGE (WS-UTIL-SUB WS-UTIL-CX-SUB)          
               END-IF                                                   
               ADD  WS-READ-INDEX-UNITS-CX (SUB3) TO                    
                    WS-UTIL-READING-DIFF (WS-UTIL-SUB WS-UTIL-CX-SUB)   
               ADD  WS-NO-DAYS-CX (SUB3) TO                             
                    WS-UTIL-DAYS (WS-UTIL-SUB WS-UTIL-CX-SUB)           
             END-IF                                                     
           END-IF.                                                      
                                                                        
           MOVE SPACES                TO WS-ENGLISH-DATE.               
           MOVE WS-UNFORMAT-DATE(9:2) TO WS-ENGLISH-DD.                 
           PERFORM 4000-ENGLISH-MONTH THRU 4000-EXIT.                   
           MOVE WS-ENGLISH-DATE TO                                      
                WS-UTIL-ST-DATE (WS-UTIL-SUB WS-UTIL-CX-SUB).           
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  MOVE APPROPRIATE DATA FROM CONSUMPTION HISTORY TO THE   *              
      *  ELECTRIC DEMAND W/S TABLE. THIS PART OF THE TABLE IS    *              
      *  TWO-DIMENSIONAL;  THE SUBSCRIPTS ARE WS-UTIL-SUB,       *              
      *  WS-UTIL-CX-SUB. DATES ARE REFORMATTED FROM CCYYMMDD TO *               
      *  MMM DD.  THE NUMBER OF DAYS BETWEEN THE BILLING PERIOD  *              
      *  START AND END IS COMPUTED.                              *              
      ************************************************************              
                                                                        
       1201-KWH-USAGE.                                                  
                                                                        
           PERFORM 1204-NEW-METER-CHECK THRU 1204-EXIT.                 
P01175     IF WS-CNSMPTN-FOUND-FLAG        = 'Y'  AND                   
P01175       (WS-170-RATE-SUB-GRP-TYPE-CD  = 'B' OR                     
P01175        WS-170-RATE-SUB-GRP-TYPE-CD  = 'D' OR                     
P01175        WS-170-RATE-SUB-GRP-TYPE-CD  = 'C' OR                     
P01175        WS-170-RATE-SUB-GRP-TYPE-CD  = 'F')                       
P01175        ADD WS-NO-UNITS-CX (SUB3) TO                              
P01175            WS-UTIL-CURR-USE (WS-UTIL-SUB)                        
P01175            WS-ENERGY-FROM-CUST                                   
P01175     ELSE                                                         
P01175        IF WS-CODE-DEBIT-CREDIT-CX (SUB3) = 'C'                   
P01175           SUBTRACT WS-NO-UNITS-CX (SUB3) FROM                    
P01175                    WS-UTIL-CURR-USE (WS-UTIL-SUB)                
P01175        ELSE                                                      
P01175           ADD WS-NO-UNITS-CX (SUB3) TO                           
P01175               WS-UTIL-CURR-USE (WS-UTIL-SUB)                     
P01175        END-IF                                                    
P01175     END-IF.                                                      
           PERFORM 1200-METER-INFO      THRU 1200-EXIT.                 
           IF WS-MTR-READ-SOURCE-CD = 'M' AND ELEC-DEMAND               
              MOVE ZEROS         TO                                     
                   WS-UTIL-CURR-READING (WS-UTIL-SUB WS-UTIL-CX-SUB)    
           END-IF.                                                      
                                                                        
       1201-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1202-KW-USAGE.                                                   
                                                                        
           PERFORM 1204-NEW-METER-CHECK THRU 1204-EXIT.                 
           ADD  WS-NO-DEMAND-UNITS-CX (SUB3) TO                         
                           WS-UTIL-CURR-KW (WS-UTIL-SUB).               
           MOVE WS-NO-DEMAND-UNITS-CX (SUB3) TO                         
                WS-UTIL-KW (WS-UTIL-SUB WS-UTIL-CX-SUB).                
                                                                        
       1202-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * When there is a meter change, pick up the max of KVA.         *         
      * On multiple meters sum all the KVA.                           *         
      *****************************************************************         
       1203-KVA-USAGE.                                                  
                                                                        
           PERFORM 1204-NEW-METER-CHECK THRU 1204-EXIT.                 
           IF WS-UTIL-METER-CHANGE = 'Y'                                
              IF WS-NO-DEMAND-UNITS-CX (SUB3) >                         
                           WS-UTIL-CURR-KVA (WS-UTIL-SUB)               
                  MOVE WS-NO-DEMAND-UNITS-CX (SUB3) TO                  
                           WS-UTIL-CURR-KVA (WS-UTIL-SUB)               
               END-IF                                                   
           ELSE                                                         
               ADD  WS-NO-DEMAND-UNITS-CX (SUB3) TO                     
                           WS-UTIL-CURR-KVA (WS-UTIL-SUB)               
           END-IF.                                                      
           MOVE WS-NO-DEMAND-UNITS-CX (SUB3) TO                         
                WS-UTIL-KVA (WS-UTIL-SUB WS-UTIL-CX-SUB).               
                                                                        
       1203-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1204-NEW-METER-CHECK.                                            
                                                                        
           IF WS-DATE-READ-CX (SUB3) > WS-UTIL-DATE-READ (WS-UTIL-SUB)  
              MOVE WS-DATE-READ-CX (SUB3) TO                            
                   WS-UTIL-DATE-READ (WS-UTIL-SUB)                      
              PERFORM 1210-GET-TIME-READ THRU 1210-EXIT                 
           END-IF.                                                      
      *                                                                         
           IF (WS-METER-NO-CX (SUB3) NOT = WS-HOLD-METER-NO) OR         
              (WS-METER-NO-CX (SUB3) = WS-HOLD-METER-NO AND             
A02003        (WS-CODE-USAGE-TYPE-CX (SUB3) = 'B'   OR                  
A02003         WS-CODE-USAGE-TYPE-CX (SUB3) = 'C') AND                  
A02003*       ((WS-CODE-USAGE-TYPE-CX (SUB3) = 'B' AND NOT GAS) OR              
A02003*       (WS-CODE-USAGE-TYPE-CX (SUB3) = 'C' AND GAS)) AND                 
              WS-PRV-MTR-READ-COMB-FLG-CX (SUB3) = 'N')                 
              IF WS-UTIL-METER-CHANGE = 'Y'                             
                 MOVE WS-HOLD-NO-OF-DAYS TO                             
                      WS-UTIL-CURR-DAYS (WS-UTIL-SUB)                   
              ELSE                                                      
                 MOVE WS-NO-DAYS-CX (SUB3) TO                           
                      WS-UTIL-CURR-DAYS (WS-UTIL-SUB)                   
              END-IF                                                    
      *                                                                         
              MOVE WS-CODE-METER-NO-READ-CX (SUB3) TO                   
                   WS-UTIL-NO-READ-REASON (WS-UTIL-SUB)                 
              MOVE WS-CODE-METER-READ-CX (SUB3) TO                      
                   WS-UTIL-CODE-METER-READ (WS-UTIL-SUB)                
              PERFORM 1205-METER-ENVRNMT-INFO THRU 1205-EXIT            
              IF WS-HOLD-METER-NO > SPACES                              
                  ADD 1 TO WS-UTIL-CX-SUB                               
              END-IF                                                    
              MOVE WS-METER-NO-CX (SUB3) TO WS-HOLD-METER-NO            
           END-IF.                                                      
           MOVE 'X' TO WS-UTIL-CHECK (WS-UTIL-SUB WS-UTIL-CX-SUB).      
                                                                        
       1204-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * SEARCH MTRD ENVRNMT TO FIND METER SUPPLY AND READ SOURCE CODE *         
      *****************************************************************         
       1205-METER-ENVRNMT-INFO.                                         
                                                                        
           SET WS-MTRD-INDX TO 1.                                       
           SEARCH WS-MTRD-ENVRNMT-DATA                                  
            AT END                                                      
               MOVE SPACES TO WS-UTIL-SUPPLYING                         
                              (WS-UTIL-SUB WS-UTIL-CX-SUB)              
                              WS-MTR-READ-SOURCE-CD                     
            WHEN WS-ACCOUNT-NO-MN (WS-MTRD-INDX) = ZEROES               
               MOVE SPACES TO WS-UTIL-SUPPLYING                         
                             (WS-UTIL-SUB WS-UTIL-CX-SUB)               
                              WS-MTR-READ-SOURCE-CD                     
            WHEN WS-ACCOUNT-NO-MN(WS-MTRD-INDX) = WS-ACCOUNT-NO-CX(SUB3)
             AND WS-CODE-UTIL-TYPE-MN(WS-MTRD-INDX) =                   
                 WS-CODE-UTIL-TYPE-CX(SUB3)                             
             AND WS-IC-NO-MN (WS-MTRD-INDX)     = WS-IC-NO-CX (SUB3)    
             AND WS-MTR-REF-NO-MN(WS-MTRD-INDX) = WS-MTR-REF-NO-CX(SUB3)
             AND WS-METER-NO-MN (WS-MTRD-INDX)  = WS-METER-NO-CX (SUB3) 
                 MOVE WS-METER-SUPPLYING-MN (WS-MTRD-INDX) TO           
                      WS-UTIL-SUPPLYING (WS-UTIL-SUB WS-UTIL-CX-SUB)    
                 MOVE WS-MTR-READ-SOURCE-CD-MN (WS-MTRD-INDX) TO        
                      WS-MTR-READ-SOURCE-CD                             
           END-SEARCH.                                                  
                                                                        
       1205-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1210-GET-TIME-READ.                                              
                                                                        
           SET WS-MTRD-INDX TO 1.                                       
           SEARCH WS-MTRD-ENVRNMT-DATA                                  
               AT END                                                   
                   MOVE SPACES TO WS-UTIL-TIME-READ (WS-UTIL-SUB)       
               WHEN WS-ACCOUNT-NO-MN (WS-MTRD-INDX) = ZEROES            
                   MOVE SPACES TO WS-UTIL-TIME-READ (WS-UTIL-SUB)       
               WHEN WS-ACCOUNT-NO-MN (WS-MTRD-INDX) =                   
                    WS-ACCOUNT-NO-CX (SUB3) AND                         
                    WS-CODE-UTIL-TYPE-MN (WS-MTRD-INDX) =               
                    WS-CODE-UTIL-TYPE-CX (SUB3) AND                     
                    WS-IC-NO-MN (WS-MTRD-INDX) =                        
                    WS-IC-NO-CX (SUB3) AND                              
                    WS-LAST-VALID-READ-DT-MN (WS-MTRD-INDX) =           
                    WS-DATE-READ-CX (SUB3)                              
                        MOVE WS-LAST-VALID-READ-TM-MN (WS-MTRD-INDX) TO 
                             WS-UTIL-TIME-READ (WS-UTIL-SUB)            
           END-SEARCH.                                                  
                                                                        
       1210-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
T11597 1216-LOAD-NDEM-UNITS.                                            
                                                                        
           MOVE WS-SAVE-CX-SUB TO SUB5.                                 
T13795     MOVE 'N' TO WS-METER-NBR-LOADED.                             
T11597     PERFORM VARYING USAGE-SUB FROM 1 BY 1 UNTIL USAGE-SUB > 3    
               IF WS-NDEM-FLAG (USAGE-SUB) = 'Y'                        
                   EVALUATE USAGE-SUB                                   
                       WHEN 1                                           
                           MOVE 'On-peak' TO WS-UTIL-CODE-TIME-PERIOD   
                              (WS-UTIL-SUB WS-UTIL-CX-SUB)              
                       WHEN 2                                           
                           MOVE 'Off-peak' TO WS-UTIL-CODE-TIME-PERIOD  
                              (WS-UTIL-SUB WS-UTIL-CX-SUB)              
                       WHEN 3                                           
I02104                     IF WS-CRITICAL-PEAK-FL = 'Y'                 
I02104                        MOVE 'Crit-pk' TO                         
I02104                              WS-UTIL-CODE-TIME-PERIOD            
I02104                               (WS-UTIL-SUB WS-UTIL-CX-SUB)       
I02104                     ELSE                                         
I02104                        MOVE 'Shoulder' TO                        
I02104                              WS-UTIL-CODE-TIME-PERIOD            
I02104                               (WS-UTIL-SUB WS-UTIL-CX-SUB)       
I02104                     END-IF                                       
                       WHEN OTHER                                       
                           MOVE SPACES TO WS-UTIL-CODE-TIME-PERIOD      
                              (WS-UTIL-SUB WS-UTIL-CX-SUB)              
                   END-EVALUATE                                         
                                                                        
                   MOVE WS-NDEM-CSEA-KWH (USAGE-SUB) TO                 
                        WS-UTIL-USAGE (WS-UTIL-SUB WS-UTIL-CX-SUB)      
                   MOVE WS-NDEM-CSEA-KW (USAGE-SUB) TO                  
                        WS-UTIL-KW (WS-UTIL-SUB WS-UTIL-CX-SUB)         
                   MOVE WS-NDEM-CSEA-CURR-INDEX (USAGE-SUB) TO          
                        WS-UTIL-CURR-READING(WS-UTIL-SUB WS-UTIL-CX-SUB)
                   MOVE WS-NDEM-CSEA-PREV-INDEX (USAGE-SUB) TO          
                        WS-UTIL-PREV-READING(WS-UTIL-SUB WS-UTIL-CX-SUB)
                   MOVE WS-NDEM-CSEA-INDEX-DIFF  (USAGE-SUB) TO         
                        WS-UTIL-READING-DIFF(WS-UTIL-SUB WS-UTIL-CX-SUB)
                   MOVE WS-NDEM-CSEA-CONSTANT (USAGE-SUB) TO            
                        WS-UTIL-CONSTANT (WS-UTIL-SUB WS-UTIL-CX-SUB)   
                   MOVE WS-NDEM-CSEA-NO-DIALS (USAGE-SUB) TO            
                        WS-UTIL-NO-DIALS (WS-UTIL-SUB WS-UTIL-CX-SUB)   
                   MOVE 'X' TO WS-UTIL-CHECK(WS-UTIL-SUB WS-UTIL-CX-SUB)
                                                                        
                   IF WS-METER-NBR-LOADED = 'Y'                         
                      MOVE SPACES TO                                    
                        WS-UTIL-METER  (WS-UTIL-SUB WS-UTIL-CX-SUB)     
                        WS-UTIL-ST-DATE (WS-UTIL-SUB WS-UTIL-CX-SUB)    
                        WS-UTIL-ST-DATE-NUM (WS-UTIL-SUB WS-UTIL-CX-SUB)
                        WS-UTIL-END-DATE (WS-UTIL-SUB WS-UTIL-CX-SUB)   
                        WS-UTIL-END-DATE-NUM(WS-UTIL-SUB WS-UTIL-CX-SUB)
                        WS-UTIL-SUPPLYING (WS-UTIL-SUB WS-UTIL-CX-SUB)  
                      MOVE ZEROES TO WS-UTIL-DAYS                       
                                     (WS-UTIL-SUB WS-UTIL-CX-SUB)       
                   END-IF                                               
T13795             ADD 1 TO WS-UTIL-CX-SUB                              
T13795             MOVE 'Y' TO WS-METER-NBR-LOADED                      
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
T12620     IF WS-SEASON-CHANGE = 'Y'                                    
T11597         PERFORM VARYING USAGE-SUB FROM 1 BY 1                    
T11597                                   UNTIL USAGE-SUB > 3            
                   IF WS-NDEM-FLAG (USAGE-SUB) = 'Y'                    
                       MOVE 'X' TO WS-UTIL-CHECK                        
T13795                            (WS-UTIL-SUB WS-UTIL-CX-SUB)          
                       EVALUATE USAGE-SUB                               
                           WHEN 1                                       
                             MOVE 'On-peak' TO WS-UTIL-CODE-TIME-PERIOD 
T13795                            (WS-UTIL-SUB WS-UTIL-CX-SUB)          
                           WHEN 2                                       
                             MOVE 'Off-peak' TO WS-UTIL-CODE-TIME-PERIOD
T13795                            (WS-UTIL-SUB WS-UTIL-CX-SUB)          
                           WHEN 3                                       
I02104                       IF WS-CRITICAL-PEAK-FL = 'Y'               
I02104                          MOVE 'Crit-pk' TO                       
I02104                             WS-UTIL-CODE-TIME-PERIOD             
I02104                              (WS-UTIL-SUB WS-UTIL-CX-SUB)        
I02104                       ELSE                                       
I02104                          MOVE 'Shoulder' TO                      
I02104                             WS-UTIL-CODE-TIME-PERIOD             
I02104                              (WS-UTIL-SUB WS-UTIL-CX-SUB)        
I02104                       END-IF                                     
                           WHEN OTHER                                   
                             MOVE SPACES TO WS-UTIL-CODE-TIME-PERIOD    
T13795                            (WS-UTIL-SUB WS-UTIL-CX-SUB)          
                       END-EVALUATE                                     
                                                                        
                       MOVE WS-NDEM-PSEA-KWH (USAGE-SUB) TO             
                            WS-UTIL-USAGE (WS-UTIL-SUB WS-UTIL-CX-SUB)  
                       MOVE WS-NDEM-PSEA-KW (USAGE-SUB) TO              
                            WS-UTIL-KW (WS-UTIL-SUB WS-UTIL-CX-SUB)     
                       MOVE WS-NDEM-PSEA-CURR-INDEX (USAGE-SUB) TO      
                            WS-UTIL-CURR-READING                        
                                     (WS-UTIL-SUB WS-UTIL-CX-SUB)       
                       MOVE WS-NDEM-PSEA-PREV-INDEX (USAGE-SUB) TO      
                            WS-UTIL-PREV-READING                        
                                     (WS-UTIL-SUB WS-UTIL-CX-SUB)       
                       MOVE WS-NDEM-PSEA-INDEX-DIFF  (USAGE-SUB) TO     
                            WS-UTIL-READING-DIFF                        
                                     (WS-UTIL-SUB WS-UTIL-CX-SUB)       
                       MOVE WS-NDEM-PSEA-CONSTANT (USAGE-SUB) TO        
                            WS-UTIL-CONSTANT(WS-UTIL-SUB WS-UTIL-CX-SUB)
                       MOVE WS-NDEM-PSEA-NO-DIALS (USAGE-SUB) TO        
                            WS-UTIL-NO-DIALS(WS-UTIL-SUB WS-UTIL-CX-SUB)
                                                                        
                       MOVE SPACES TO                                   
                        WS-UTIL-METER  (WS-UTIL-SUB WS-UTIL-CX-SUB)     
                        WS-UTIL-ST-DATE (WS-UTIL-SUB WS-UTIL-CX-SUB)    
                        WS-UTIL-ST-DATE-NUM (WS-UTIL-SUB WS-UTIL-CX-SUB)
                        WS-UTIL-END-DATE (WS-UTIL-SUB WS-UTIL-CX-SUB)   
                        WS-UTIL-END-DATE-NUM(WS-UTIL-SUB WS-UTIL-CX-SUB)
                        WS-UTIL-SUPPLYING (WS-UTIL-SUB WS-UTIL-CX-SUB)  
                       MOVE ZEROES TO                                   
                        WS-UTIL-DAYS (WS-UTIL-SUB WS-UTIL-CX-SUB)       
                   END-IF                                               
                   ADD 1 TO WS-UTIL-CX-SUB                              
               END-PERFORM                                              
           END-IF.                                                      
                                                                        
           INITIALIZE WS-NDEM-TABLE.                                    
           MOVE 'N' TO WS-NEED-TOU-LOADED.                              
                                                                        
       1216-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1217-LOAD-DEM-UNITS.                                             
                                                                        
           MOVE WS-SAVE-CX-SUB TO SUB5.                                 
T11597     PERFORM VARYING USAGE-SUB FROM 1 BY 1 UNTIL USAGE-SUB > 3    
               IF WS-DEM-FLAG (USAGE-SUB) = 'Y'                         
                   MOVE 'X' TO WS-UTIL-CHECK(WS-UTIL-SUB SUB5)          
                   EVALUATE USAGE-SUB                                   
                       WHEN 1                                           
                           MOVE 'On-peak' TO WS-UTIL-CODE-TIME-PERIOD   
                              (WS-UTIL-SUB SUB5)                        
                       WHEN 2                                           
                           MOVE 'Off-peak' TO WS-UTIL-CODE-TIME-PERIOD  
                              (WS-UTIL-SUB SUB5)                        
                       WHEN 3                                           
                           MOVE 'Shoulder' TO WS-UTIL-CODE-TIME-PERIOD  
                              (WS-UTIL-SUB SUB5)                        
                       WHEN OTHER                                       
                           MOVE SPACES TO WS-UTIL-CODE-TIME-PERIOD      
                              (WS-UTIL-SUB SUB5)                        
                   END-EVALUATE                                         
                                                                        
                   MOVE WS-KWH-UNITS (USAGE-SUB) TO                     
                        WS-UTIL-USAGE (WS-UTIL-SUB SUB5)                
                   MOVE WS-KW-UNITS (USAGE-SUB) TO                      
                        WS-UTIL-KW (WS-UTIL-SUB SUB5)                   
                   EVALUATE USAGE-SUB                                   
                       WHEN 1                                           
                          ADD WS-KW-UNITS (USAGE-SUB) TO                
                              WS-TOU-DEM-KW-ON-PEAK                     
                       WHEN 2                                           
                          ADD WS-KW-UNITS (USAGE-SUB) TO                
                              WS-TOU-DEM-KW-OFF-PEAK                    
                   END-EVALUATE                                         
                   EVALUATE USAGE-SUB                                   
                       WHEN 1                                           
                       WHEN 2                                           
                          IF  WS-TOU-DEM-KW-ON-PEAK >                   
                                 WS-TOU-DEM-KW-OFF-PEAK                 
                              MOVE WS-TOU-DEM-KW-ON-PEAK TO             
                                     WS-UTIL-CURR-KW (WS-UTIL-SUB)      
                          ELSE                                          
                              MOVE WS-TOU-DEM-KW-OFF-PEAK TO            
                                     WS-UTIL-CURR-KW (WS-UTIL-SUB)      
                          END-IF                                        
                       WHEN OTHER                                       
                         IF WS-KW-UNITS (USAGE-SUB) >                   
                            WS-UTIL-CURR-KW (WS-UTIL-SUB)               
                            MOVE WS-KW-UNITS (USAGE-SUB) TO             
                                 WS-UTIL-CURR-KW (WS-UTIL-SUB)          
                         END-IF                                         
                   END-EVALUATE                                         
                   MOVE WS-KVA-UNITS (USAGE-SUB) TO                     
                        WS-UTIL-KVA (WS-UTIL-SUB SUB5)                  
                   IF WS-KVA-UNITS (USAGE-SUB) >                        
                         WS-UTIL-CURR-KVA (WS-UTIL-SUB)                 
                       MOVE WS-KVA-UNITS (USAGE-SUB) TO                 
                         WS-UTIL-CURR-KVA (WS-UTIL-SUB)                 
                   END-IF                                               
                   IF SUB5 > 1                                          
                      IF WS-TEMP-METER-NO = 'MULTIPLE'                  
                          MOVE 'MV99' TO                                
                             WS-UTIL-METER  (WS-UTIL-SUB SUB5)          
                          MOVE SPACES TO WS-TEMP-METER-NO               
                      ELSE                                              
                          MOVE SPACES TO                                
                             WS-UTIL-METER  (WS-UTIL-SUB SUB5)          
                      END-IF                                            
                      MOVE SPACES TO                                    
                        WS-UTIL-ST-DATE (WS-UTIL-SUB SUB5)              
                        WS-UTIL-ST-DATE-NUM (WS-UTIL-SUB SUB5)          
                        WS-UTIL-END-DATE (WS-UTIL-SUB SUB5)             
                        WS-UTIL-END-DATE-NUM(WS-UTIL-SUB SUB5)          
                        WS-UTIL-SUPPLYING (WS-UTIL-SUB SUB5)            
                      MOVE ZEROES TO WS-UTIL-DAYS (WS-UTIL-SUB SUB5)    
                   END-IF                                               
T13795             ADD 1 TO SUB5                                        
T13795             MOVE 'Y' TO WS-METER-NBR-LOADED                      
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
           INITIALIZE WS-DEMAND-TABLE.                                  
           MOVE 'N' TO WS-NEED-TOU-LOADED.                              
           MOVE WS-CODE-TIME-PERIOD-CX (SUB3) TO USAGE-SUB.             
                                                                        
       1217-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1218-CHECK-FOR-SEASON-CHANGE.                                    
                                                                        
           MOVE 'N'                 TO WS-SEASON-CHANGE.                
           MOVE 1                   TO SUB5.                            
           PERFORM UNTIL SUB5 > 200 OR WS-ACCOUNT-NO-CX (SUB5) = ZEROES 
             IF WS-ACCOUNT-NO-CX (SUB5) = WS-ACCOUNT-NO-BG (SUB1) AND   
                WS-BILL-NO-CX (SUB5)    = WS-BILL-NO-BG (SUB1) AND      
                WS-CODE-UTIL-TYPE-CX(SUB5) = WS-CODE-UTIL-TYPE-BG(SUB1) 
            AND WS-IC-NO-CX (SUB5)      = WS-IC-NO-BG (SUB1) AND        
                WS-BILL-ITEM-TIMESTMP-CX (SUB5) =                       
                WS-BILL-ITEM-TIMESTMP-BG (SUB1) AND                     
                WS-METER-NO-CX (SUB5)   = WS-HOLD-METER-NO AND          
                WS-CODE-TIME-PERIOD-CX (SUB5) > 0                       
            AND WS-PRV-MTR-READ-COMB-FLG-CX (SUB3) NOT= 'S'             
                IF WS-CODE-TOU-SEASN-CX (SUB5) = 'P'                    
                   MOVE 'Y'            TO WS-SEASON-CHANGE              
                END-IF                                                  
             END-IF                                                     
             ADD 1 TO SUB5                                              
           END-PERFORM.                                                 
                                                                        
       1218-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00496************************************************************              
P00496*  BUILD THE UNITS ALLOCATION RECORDS WHICH GET REDUCED    *              
P00496*  FROM CUSTOMER'S USAGE.                                  *              
P00496************************************************************              
                                                                        
       1250-UNITS-ALLOCATION.                                           
                                                                        
           MOVE 1 TO SUB2                                               
                     WS-UTIL-SEPA-SUB.                                  
           INITIALIZE WS-HOLD-ALLOCATED-KWH                             
                      WS-HOLD-ALLOCATED-KW                              
                      WS-HOLD-ALLOCATED-KVA                             
A03959                WS-PREV-BILL-PRT-SEQ-NO.                          
           PERFORM UNTIL SUB2 > WS-BA-MAX-ENTRY OR                      
                                WS-ACCOUNT-NO-BA (SUB2) = ZEROES        
             IF WS-ACCOUNT-NO-BA (SUB2) = WS-ACCOUNT-NO-BG (SUB1)       
            AND WS-BILL-NO-BA (SUB2) = WS-BILL-NO-BG (SUB1)             
            AND WS-CODE-UTIL-TYPE-BA(SUB2) = WS-CODE-UTIL-TYPE-BG(SUB1) 
            AND WS-IC-NO-BA (SUB2) = WS-IC-NO-BG (SUB1)                 
            AND WS-BILL-ITEM-TIMESTMP-BA (SUB2) =                       
                WS-BILL-ITEM-TIMESTMP-BG (SUB1)                         
            AND WS-BILL-PRT-UNITS-CD-BA (SUB2) = 'M'                    
                IF WS-UTIL-SEPA-DESC (WS-UTIL-SUB 1)                    
                   <= SPACES                                            
                   MOVE 'Actual Energy/Demand Summary' TO               
                        WS-UTIL-SEPA-DESC (WS-UTIL-SUB 1)               
                   MOVE WS-UTIL-CURR-USE (WS-UTIL-SUB) TO               
                        WS-UTIL-SEPA-KWH (WS-UTIL-SUB 1)                
                   MOVE WS-UTIL-CURR-KW (WS-UTIL-SUB) TO                
                        WS-UTIL-SEPA-KW (WS-UTIL-SUB 1)                 
                   MOVE WS-UTIL-CURR-KVA (WS-UTIL-SUB) TO               
                        WS-UTIL-SEPA-KVA (WS-UTIL-SUB 1)                
                END-IF                                                  
                PERFORM 1260-UNITS-ALLOCATION THRU 1260-EXIT            
            END-IF                                                      
           ADD 1 TO SUB2                                                
           END-PERFORM.                                                 
           IF WS-UTIL-SEPA-DESC (WS-UTIL-SUB 1) > SPACES                
              IF WS-UTIL-SEPA-SUB < 200                                 
                 ADD +1                   TO WS-UTIL-SEPA-SUB           
                 MOVE 'Net Energy/Demand' TO                            
                       WS-UTIL-SEPA-DESC (WS-UTIL-SUB WS-UTIL-SEPA-SUB) 
                 COMPUTE WS-UTIL-SEPA-KWH (WS-UTIL-SUB WS-UTIL-SEPA-SUB)
                       = WS-UTIL-SEPA-KWH (WS-UTIL-SUB 1) +             
                         WS-HOLD-ALLOCATED-KWH                          
                 COMPUTE WS-UTIL-SEPA-KW (WS-UTIL-SUB WS-UTIL-SEPA-SUB) 
                       = WS-UTIL-SEPA-KW (WS-UTIL-SUB 1) +              
                         WS-HOLD-ALLOCATED-KW                           
                 COMPUTE WS-UTIL-SEPA-KVA (WS-UTIL-SUB WS-UTIL-SEPA-SUB)
                       = WS-UTIL-SEPA-KVA (WS-UTIL-SUB 1) +             
                         WS-HOLD-ALLOCATED-KVA                          
              ELSE                                                      
                 MOVE 12                   TO RETURN-CODE               
                 MOVE 'OVER 200 UNIT ALLOCATION' TO WS-MISC-MSG-TEXT    
                 MOVE +30                  TO WS-MISC-MSG-LEN           
                 PERFORM 9910-MISC-ERROR THRU 9910-EXIT                 
                 PERFORM 9999-BAIL-OUT THRU 9999-EXIT                   
              END-IF                                                    
           END-IF.                                                      
                                                                        
       1250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  GET ALLOCATION VALUES FROM THE BA SEGMENTS.             *              
      ************************************************************              
                                                                        
       1260-UNITS-ALLOCATION.                                           
                                                                        
A03959****MATCH FH ROW FOR the CORRESPONDING BA TO DETERMINE TYPE OF            
A03959****CONSUMPTION. THE FACTORS WITH SAME BILL PRINT SEQUENCE NO WILL        
A03959****PRINT IN THE SAME LINE. THEY WILL BE GROUPED TOGETHER AND SENT        
A03959****FROM BILLING.                                                         
           MOVE 'N'                         TO WS-FH-FACTOR-FOUND.      
           PERFORM VARYING WS-FH-HIST-INDX FROM 1 BY 1                  
SCA006       UNTIL WS-FH-FACTOR-FOUND = 'Y' OR 
                   WS-FH-HIST-INDX > WS-FH-MAX-ENTRY OR 
                   WS-ACCOUNT-NO-FH (WS-FH-HIST-INDX) = ZEROS                   
               IF WS-BILLING-KEY-FH(WS-FH-HIST-INDX) =                  
                                         WS-BILLING-KEY-BA(SUB2) AND    
                  WS-FACTOR-ID-BA (SUB2) =                              
                                      WS-FACTOR-ID-FH (WS-FH-HIST-INDX) 
                  MOVE 'Y' TO         WS-FH-FACTOR-FOUND                
                  IF WS-BILL-PRT-SEQ-NO-BA (SUB2) NOT =                 
                                           WS-PREV-BILL-PRT-SEQ-NO      
                     IF WS-UTIL-SEPA-SUB < 200                          
                        ADD +1                   TO WS-UTIL-SEPA-SUB    
                        MOVE WS-FACTOR-ID-BA (SUB2) TO SF-FACTOR-ID     
                        MOVE SPACES                 TO SF-FACTOR-DESC   
                                                       SF-FACTOR-TYPE   
                                                       WS-FACTOR-FOUND  
                        PERFORM 3662-GET-FACTOR-DESC    THRU 3662-EXIT  
                        MOVE SF-FACTOR-DESC TO WS-FACTOR-DESC           
                        WS-UTIL-SEPA-DESC (WS-UTIL-SUB WS-UTIL-SEPA-SUB)
                     ELSE                                               
                        MOVE 12                   TO RETURN-CODE        
                        MOVE 'OVER 200 UNIT ALLOCATION' TO              
                                                     WS-MISC-MSG-TEXT   
                        MOVE +30                  TO WS-MISC-MSG-LEN    
                        PERFORM 9910-MISC-ERROR THRU 9910-EXIT          
                        PERFORM 9999-BAIL-OUT THRU 9999-EXIT            
                     END-IF                                             
                  END-IF                                                
                  EVALUATE WS-FIXED-FCTR-TYP-CD-FH (WS-FH-HIST-INDX)    
                  WHEN '09'                                             
                        MOVE WS-ADJ-UNITS-BA (SUB2) TO                  
                         WS-UTIL-SEPA-KWH (WS-UTIL-SUB WS-UTIL-SEPA-SUB)
                        ADD WS-ADJ-UNITS-BA (SUB2) TO                   
                                             WS-HOLD-ALLOCATED-KWH      
                  WHEN '08'                                             
                        MOVE WS-ADJ-UNITS-BA (SUB2) TO                  
                          WS-UTIL-SEPA-KW (WS-UTIL-SUB WS-UTIL-SEPA-SUB)
                        ADD WS-ADJ-UNITS-BA (SUB2) TO                   
                                           WS-HOLD-ALLOCATED-KW         
                  WHEN '14'                                             
                       MOVE WS-ADJ-UNITS-BA (SUB2) TO                   
                         WS-UTIL-SEPA-KVA (WS-UTIL-SUB WS-UTIL-SEPA-SUB)
                       ADD WS-ADJ-UNITS-BA (SUB2) TO                    
                                           WS-HOLD-ALLOCATED-KVA        
                  END-EVALUATE                                          
                 MOVE WS-BILL-PRT-SEQ-NO-BA (SUB2) TO                   
                                              WS-PREV-BILL-PRT-SEQ-NO   
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
A03959 1260-EXIT.                                                       
A03959     EXIT.                                                        
A03959                                                                  
      ************************************************************              
      *  SUMMARIZE TIME OF USE DEMAND AND USAGE BY TIME PERIOD.  *              
      ************************************************************              
                                                                        
       1265-SUMMARIZE-TOU.                                              
                                                                        
           PERFORM VARYING WS-UTIL-SUM-SUB FROM 1 BY 1 UNTIL            
             WS-UTIL-SUM-SUB > 3                                        
             IF WS-CODE-TIME-PERIOD-CX (SUB3) = WS-UTIL-DEM-SUM-TIME-PD 
               (WS-UTIL-SUB WS-UTIL-SUM-SUB)                            
                  MOVE 'Y' TO WS-UTIL-DEM-SUM-SW                        
                             (WS-UTIL-SUB WS-UTIL-SUM-SUB)              
                             WS-UTIL-DEM-SUM-FLAG                       
                  EVALUATE WS-CODE-USAGE-TYPE-CX (SUB3)                 
                      WHEN 'B'                                          
                           IF WS-CODE-DEBIT-CREDIT-CX (SUB3) = 'C'      
                              SUBTRACT WS-NO-UNITS-CX (SUB3) FROM       
                              WS-UTIL-DEM-SUM-KWH                       
                                  (WS-UTIL-SUB WS-UTIL-SUM-SUB)         
                           ELSE                                         
                              ADD WS-NO-UNITS-CX (SUB3) TO              
                              WS-UTIL-DEM-SUM-KWH                       
                                  (WS-UTIL-SUB WS-UTIL-SUM-SUB)         
                           END-IF                                       
                      WHEN 'J'                                          
A03343                IF WS-UTIL-METER-CHANGE = 'Y'                     
A03343                   IF WS-NO-DEMAND-UNITS-CX (SUB3) >              
A03343                      WS-UTIL-DEM-SUM-KW                          
A03343                          (WS-UTIL-SUB WS-UTIL-SUM-SUB)           
A03343                      MOVE WS-NO-DEMAND-UNITS-CX (SUB3) TO        
A03343                           WS-UTIL-DEM-SUM-KW                     
A03343                              (WS-UTIL-SUB WS-UTIL-SUM-SUB)       
A03343                   END-IF                                         
A03343                ELSE                                              
                          ADD WS-NO-DEMAND-UNITS-CX (SUB3) TO           
                              WS-UTIL-DEM-SUM-KW                        
                                  (WS-UTIL-SUB WS-UTIL-SUM-SUB)         
A03343                END-IF                                            
                      WHEN 'E'                                          
A03343                IF WS-UTIL-METER-CHANGE = 'Y'                     
A03343                   IF WS-NO-DEMAND-UNITS-CX (SUB3) >              
A03343                      WS-UTIL-DEM-SUM-KVA                         
A03343                          (WS-UTIL-SUB WS-UTIL-SUM-SUB)           
A03343                      MOVE WS-NO-DEMAND-UNITS-CX (SUB3) TO        
A03343                           WS-UTIL-DEM-SUM-KVA                    
A03343                              (WS-UTIL-SUB WS-UTIL-SUM-SUB)       
A03343                   END-IF                                         
A03343                ELSE                                              
                          ADD WS-NO-DEMAND-UNITS-CX (SUB3) TO           
                              WS-UTIL-DEM-SUM-KVA                       
                                  (WS-UTIL-SUB WS-UTIL-SUM-SUB)         
A03343                END-IF                                            
                  END-EVALUATE                                          
             END-IF                                                     
           END-PERFORM.                                                 
      * check what cond we need here ***                                        
           IF WS-UTIL-DEM-SUM-FLAG NOT = 'Y'                            
              MOVE 12                              TO RETURN-CODE       
              MOVE 'INVALID CODE TIME PERIOD (CX)' TO WS-MISC-MSG-TEXT  
              MOVE +29                             TO WS-MISC-MSG-LEN   
              PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
              PERFORM 9999-BAIL-OUT   THRU 9999-EXIT                    
           END-IF.                                                      
       1265-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  SUMMARIZE TIME OF USE DEMAND AND USAGE BY TIME PERIOD.  *              
      ************************************************************              
                                                                        
       1270-SUMMARIZE-NM-TOU.                                           
                                                                        
           PERFORM VARYING WS-UTIL-NM-SUB FROM 1 BY 1 UNTIL             
             WS-UTIL-NM-SUB > 3                                         
             IF WS-CODE-TIME-PERIOD-CX (SUB3) =                         
                WS-UTIL-DEM-NM-TIME-PD (WS-UTIL-SUB WS-UTIL-NM-SUB)     
                  MOVE 'Y' TO WS-UTIL-DEM-NM-SW                         
                              (WS-UTIL-SUB WS-UTIL-NM-SUB)              
                              WS-UTIL-DEM-NM-FLAG                       
                  EVALUATE WS-CODE-USAGE-TYPE-CX (SUB3)                 
                     WHEN 'B'                                           
                           IF WS-CODE-DEBIT-CREDIT-CX (SUB3) = 'C'      
                              SUBTRACT WS-NO-UNITS-CX (SUB3) FROM       
                              WS-UTIL-DEM-NM-KWH                        
                                  (WS-UTIL-SUB WS-UTIL-NM-SUB)          
                           ELSE                                         
                              ADD WS-NO-UNITS-CX (SUB3) TO              
                              WS-UTIL-DEM-NM-KWH                        
                                  (WS-UTIL-SUB WS-UTIL-NM-SUB)          
                           END-IF                                       
                      WHEN 'J'                                          
A03343                  IF WS-UTIL-METER-CHANGE = 'Y'                   
A03343                     IF WS-NO-DEMAND-UNITS-CX (SUB3) >            
A03343                        WS-UTIL-DEM-NM-KW                         
A03343                          (WS-UTIL-SUB WS-UTIL-NM-SUB)            
A03343                        MOVE WS-NO-DEMAND-UNITS-CX (SUB3) TO      
A03343                             WS-UTIL-DEM-NM-KW                    
A03343                              (WS-UTIL-SUB WS-UTIL-NM-SUB)        
A03343                     END-IF                                       
A03343                  ELSE                                            
                          ADD WS-NO-DEMAND-UNITS-CX (SUB3) TO           
                              WS-UTIL-DEM-NM-KW                         
                                  (WS-UTIL-SUB WS-UTIL-NM-SUB)          
A03343                  END-IF                                          
                      WHEN 'E'                                          
A03343                  IF WS-UTIL-METER-CHANGE = 'Y'                   
A03343                     IF WS-NO-DEMAND-UNITS-CX (SUB3) >            
A03343                        WS-UTIL-DEM-NM-KVA                        
A03343                          (WS-UTIL-SUB WS-UTIL-NM-SUB)            
A03343                        MOVE WS-NO-DEMAND-UNITS-CX (SUB3) TO      
A03343                             WS-UTIL-DEM-NM-KVA                   
A03343                              (WS-UTIL-SUB WS-UTIL-NM-SUB)        
A03343                     END-IF                                       
A03343                  ELSE                                            
                          ADD WS-NO-DEMAND-UNITS-CX (SUB3) TO           
                              WS-UTIL-DEM-NM-KVA                        
                                  (WS-UTIL-SUB WS-UTIL-NM-SUB)          
A03343                  END-IF                                          
                  END-EVALUATE                                          
             END-IF                                                     
           END-PERFORM.                                                 
           IF WS-UTIL-DEM-NM-FLAG NOT = 'Y'                             
              MOVE WS-CODE-TIME-PERIOD-CX (SUB3) TO                     
                WS-UTIL-DEM-NM-TIME-PD(WS-UTIL-SUB WS-UTIL-NM-SUB)      
                   MOVE 12                    TO RETURN-CODE            
                   MOVE +29                   TO WS-MISC-MSG-LEN        
                   PERFORM 9910-MISC-ERROR THRU 9910-EXIT               
                   PERFORM 9999-BAIL-OUT   THRU 9999-EXIT               
           END-IF.                                                      
                                                                        
       1270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  PROCESS ALL BILL ADJUSTMENTS AND CALCULATIONS.  BASIC   *              
      *  FACILITY CHARGE (IF PRESENT) PRINTS FIRST AND FRANCHISE *              
      *  FEE PRINTS LAST.                                        *              
      ************************************************************              
                                                                        
       1300-UTIL-CHARGES.                                               
                                                                        
           IF RTP                                                       
              PERFORM 1350-RTP-CALC THRU 1350-EXIT                      
           END-IF.                                                      
                                                                        
P00496********Check if the customer has billed bill component other than        
P00496********10 (Basic Component) to print component description.              
P00496     MOVE 'N' TO WS-PRINT-CMPNT-DESC-FL                           
P00496     MOVE 1 TO SUB2                                               
P00496     PERFORM UNTIL SUB2 > WS-BZ-MAX-ENTRY OR                      
P00496             WS-ACCOUNT-NO-BC (SUB2) = ZEROES                     
P00496       IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BC (SUB2)       
P00496      AND WS-BILL-NO-BG (SUB1)    = WS-BILL-NO-BC (SUB2)          
P00496      AND WS-CODE-UTIL-TYPE-BG(SUB1) = WS-CODE-UTIL-TYPE-BC(SUB2) 
P00496      AND WS-IC-NO-BG (SUB1)      = WS-IC-NO-BC (SUB2)            
P00496      AND WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                       
P00496          WS-BILL-ITEM-TIMESTMP-BC (SUB2)                         
P00496      AND WS-COMPONENT-ID-BC(SUB2) NOT EQUAl TO 10                
P00496          MOVE 'Y' TO WS-PRINT-CMPNT-DESC-FL                      
P00496       END-IF                                                     
P00496       ADD 1 TO SUB2                                              
P00496     END-PERFORM.                                                 
P00496                                                                  
           MOVE 1 TO SUB2 WS-UTIL-CHG-SUB.                              
           PERFORM UNTIL SUB2 > 100 OR WS-ACCOUNT-NO-BA (SUB2) = ZEROES 
            IF  WS-ACCOUNT-NO-BG (SUB1)    = WS-ACCOUNT-NO-BA (SUB2)    
            AND WS-BILL-NO-BG (SUB1)       = WS-BILL-NO-BA (SUB2)       
            AND WS-CODE-UTIL-TYPE-BG(SUB1) = WS-CODE-UTIL-TYPE-BA(SUB2) 
            AND WS-IC-NO-BG (SUB1)         = WS-IC-NO-BA (SUB2)         
            AND WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                       
                WS-BILL-ITEM-TIMESTMP-BA (SUB2)                         
            AND WS-FACTOR-ID-BA (SUB2)     = 'BFACCHRG'                 
                IF WS-AMT-ADJUSTMENT-BA (SUB2) > 0                      
                   IF RTP                                               
                      PERFORM 1315-DETERMINE-BASE-CHG THRU 1315-EXIT    
                      MOVE 'Basic Facilities Charge' TO                 
                       WS-UTIL-BASE-CHG-MSG(WS-UTIL-SUB WS-UTIL-CHG-SUB)
                      MOVE WS-AMT-ADJUSTMENT-BA (SUB2) TO               
                       WS-UTIL-BASE-CHG-AMT(WS-UTIL-SUB WS-UTIL-CHG-SUB)
                      ADD WS-AMT-ADJUSTMENT-BA (SUB2) TO                
                       WS-RTP-TOT-BASE-CHARGES(WS-UTIL-SUB)             
                   ELSE                                                 
                      PERFORM 1310-DETERMINE-CHG-SUB  THRU 1310-EXIT    
                      MOVE 'Basic Facilities Charge' TO                 
                           WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)
P00496                MOVE 'N' TO WS-UTIL-CHG-HDR-ROW                   
P00496                                     (WS-UTIL-SUB WS-UTIL-CHG-SUB)
                      COMPUTE WS-ROUNDED-BFC ROUNDED =                  
                              WS-AMT-ADJUSTMENT-BA (SUB2) * 1           
                      MOVE WS-ROUNDED-BFC TO                            
                           WS-UTIL-CHG-AMT(WS-UTIL-SUB WS-UTIL-CHG-SUB) 
                           WS-HOLD-BASIC-FACILITY                       
                   END-IF                                               
                   ADD WS-AMT-ADJUSTMENT-BA (SUB2) TO                   
                       WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                 
                END-IF                                                  
            END-IF                                                      
            ADD 1 TO SUB2                                               
           END-PERFORM.                                                 
                                                                        
           IF RTP                                                       
              PERFORM 1370-RTP-OTHER-CALC THRU 1370-EXIT                
           END-IF.                                                      
                                                                        
           MOVE 1 TO WS-UTIL-CHG-SUB.                                   
           PERFORM 1310-DETERMINE-CHG-SUB  THRU 1310-EXIT.              
                                                                        
           MOVE 1 TO SUB2                                               
           PERFORM UNTIL SUB2 > WS-BZ-MAX-ENTRY OR                      
                   WS-ACCOUNT-NO-BC (SUB2) = ZEROES                     
             IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BC (SUB2)       
            AND WS-BILL-NO-BG (SUB1)    = WS-BILL-NO-BC (SUB2)          
            AND WS-CODE-UTIL-TYPE-BG(SUB1) = WS-CODE-UTIL-TYPE-BC(SUB2) 
            AND WS-IC-NO-BG (SUB1)      = WS-IC-NO-BC (SUB2)            
            AND WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                       
                WS-BILL-ITEM-TIMESTMP-BC (SUB2)                         
A03959          IF WS-FACTOR-BLK-LN-FL = 'Y'                            
A03959             MOVE 'Y' TO WS-UTIL-CHG-HDR-ROW                      
A03959                         (WS-UTIL-SUB WS-UTIL-CHG-SUB)            
A03959             ADD 1 TO WS-UTIL-CHG-SUB                             
A03959           END-IF                                                 
A03959          PERFORM 1400-UTIL-CALCS THRU 1400-EXIT                  
A03959          PERFORM VARYING WS-BILL-ADJ-INDX FROM 1 BY 1 UNTIL      
A03959           WS-BILL-ADJ-INDX >  WS-BA-MAX-ENTRY OR                 
A03959           WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX) = ZEROES           
A03959           IF WS-BILLING-KEY-BA (WS-BILL-ADJ-INDX) =              
A03959              WS-BILLING-KEY-BC (SUB2) AND                        
A03959              WS-FCT-CMPNT-ID-BA (WS-BILL-ADJ-INDX) =             
A03959              WS-COMPONENT-CODE-BC (SUB2) AND                     
A03959              WS-FCT-CNSMPT-TYPE-BA (WS-BILL-ADJ-INDX) =          
A03959              WS-CONSUMPTION-TYPE-BC (SUB2) AND                   
A03959              WS-FCT-REGISTER-TYPE-BA (WS-BILL-ADJ-INDX) =        
A03959              WS-REGISTER-TYPE-BC (SUB2) AND                      
A03959              WS-FCT-TOU-BA (WS-BILL-ADJ-INDX) =                  
A03959              WS-CODE-TOU-BC (SUB2) AND                           
A03959              WS-FCT-RATE-VERSION-BA (WS-BILL-ADJ-INDX) =         
A03959              WS-RATE-VERSION-BC (SUB2) AND                       
A03959              WS-BLOCK-NO-BA (WS-BILL-ADJ-INDX) = 0 AND           
A03959              WS-BILL-PRT-LN-ITM-FL-BA (WS-BILL-ADJ-INDX) =       
P00636                                               ('B' OR 'R') AND   
A03959              WS-AMT-ADJUSTMENT-BA (WS-BILL-ADJ-INDX) NOT = 0.0   
A03959              PERFORM 3620-FORMAT-FACTORS THRU 3620-EXIT          
P00636              IF WS-BILL-PRT-LN-ITM-FL-BA (WS-BILL-ADJ-INDX) = 'R'
P00636                 PERFORM 1550-UNIT-SEL-MESSAGE THRU 1550-EXIT     
P00636              ELSE                                                
A03959                 MOVE WS-FACTOR-DESC-BC-PRINT TO                  
A03959                     WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)
A03959                 MOVE 'N' TO WS-UTIL-CHG-HDR-ROW                  
A03959                                   (WS-UTIL-SUB WS-UTIL-CHG-SUB)  
A03959                 MOVE WS-FACTOR-AMT-BC-PRINT TO                   
A03959                     WS-UTIL-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)
A03959                 ADD WS-FACTOR-AMT-BC-PRINT TO                    
A03959                     WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)             
A03959                 IF RTP                                           
A03959                    ADD WS-FACTOR-AMT-BC-PRINT TO                 
A03959                     WS-TOTAL-RTP-CHARGES (WS-UTIL-SUB)           
A03959                 END-IF                                           
A03959                 ADD 1 TO WS-UTIL-CHG-SUB                         
P00636              END-IF                                              
A03959           END-IF                                                 
A03959          END-PERFORM                                             
             END-IF                                                     
             ADD 1 TO SUB2                                              
           END-PERFORM.                                                 
                                                                        
           IF WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S'                     
              PERFORM 1320-FRANCHISE-TAX THRU 1320-EXIT                 
           END-IF.                                                      
                                                                        
           IF WS-COMPANY-NO-AT = '26'                                   
              MOVE SUB1           TO SUB2                               
              ADD 1               TO SUB2                               
              MOVE 'Y'            TO WS-LAST-GAS-BG                     
              PERFORM UNTIL SUB2 > 30 OR WS-LAST-GAS-BG = 'N' OR        
                WS-ACCOUNT-NO-BG (SUB2) <= ZEROES                       
                IF WS-DATE-ORIG-BILL-BG (SUB2) <= SPACES                
                    MOVE 'N' TO WS-LAST-GAS-BG                          
                END-IF                                                  
                ADD 1 TO SUB2                                           
              END-PERFORM                                               
              IF WS-LAST-GAS-BG = 'Y'                                   
                PERFORM 1430-FORMAT-TOTAL-WNA-CHARGES  THRU 1430-EXIT   
              END-IF                                                    
           END-IF.                                                      
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  DETERMINE THE FIRST BLANK LINE IN THE CHARGES TABLE.    *              
      ************************************************************              
                                                                        
       1310-DETERMINE-CHG-SUB.                                          
                                                                        
           PERFORM VARYING WS-UTIL-CHG-SUB FROM 1 BY 1                  
             UNTIL WS-UTIL-CHG-SUB > 200 OR                             
P00496       WS-UTIL-CHG-HDR-ROW (WS-UTIL-SUB WS-UTIL-CHG-SUB) <= SPACES
           END-PERFORM.                                                 
           IF WS-UTIL-CHG-SUB > 200                                     
              MOVE 12                 TO RETURN-CODE                    
              MOVE 'OVER 200 CHARGES' TO WS-MISC-MSG-TEXT               
              MOVE +16                TO WS-MISC-MSG-LEN                
              PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
              PERFORM 9999-BAIL-OUT   THRU 9999-EXIT                    
           END-IF.                                                      
                                                                        
       1310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  DETERMINE THE FIRST BLANK LINE IN THE BASE CHARGE TABLE.*              
      ************************************************************              
                                                                        
       1315-DETERMINE-BASE-CHG.                                         
                                                                        
           PERFORM VARYING WS-UTIL-CHG-SUB FROM 1 BY 1                  
            UNTIL WS-UTIL-CHG-SUB > 200 OR                              
            WS-UTIL-BASE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB) <= SPACES
           END-PERFORM.                                                 
           IF WS-UTIL-CHG-SUB > 200                                     
              MOVE 12                 TO RETURN-CODE                    
              MOVE 'OVER 200 CHARGES' TO WS-MISC-MSG-TEXT               
              MOVE +16                TO WS-MISC-MSG-LEN                
              PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
              PERFORM 9999-BAIL-OUT   THRU 9999-EXIT                    
           END-IF.                                                      
                                                                        
       1315-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  DETERMINE THE FIRST BLANK LINE IN THE BASELINE CHARGE   *              
      ************************************************************              
                                                                        
       1317-DETERMINE-BASELINE-SUB.                                     
                                                                        
           PERFORM VARYING WS-UTIL-CHG-SUB FROM 1 BY 1                  
            UNTIL WS-UTIL-CHG-SUB > 200 OR                              
            WS-BASELINE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB) <= SPACES 
           END-PERFORM.                                                 
           IF WS-UTIL-CHG-SUB > 200                                     
              MOVE 12                 TO RETURN-CODE                    
              MOVE 'OVER 200 CHARGES' TO WS-MISC-MSG-TEXT               
              MOVE +16                TO WS-MISC-MSG-LEN                
              PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
              PERFORM 9999-BAIL-OUT   THRU 9999-EXIT                    
           END-IF.                                                      
                                                                        
       1317-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1320-FRANCHISE-TAX.                                              
                                                                        
           IF WS-AMT-CITY-TAX-BG (SUB1) > ZEROES                        
           AND WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S'                    
               MOVE SPACES          TO WS-FORMAT-MESSAGE                
               COMPUTE WS-COMPUTE-PCT =                                 
                       WS-FRANCHISE-TX-RATE-CALC (SUB1) * 100           
               MOVE WS-COMPUTE-PCT  TO WS-DISPLAY-PCT                   
               IF (CSR-DATABASE AND WS-COMPANY-NO-AT = '01')            
                  MOVE SPACES       TO WS-REV-INPUT                     
                                       WS-REV-TABLE                     
                  MOVE 35           TO WS-REV-LENG                      
                  MOVE WS-REV-DISTRICT-CD-PR TO A9-REV-DISTRICT-CD      
                  PERFORM 6500-GET-REV-DIST-DESC THRU 6500-EXIT         
                  STRING 'Franchise Fee '                               
                         WS-DISPLAY-PCT                                 
                         '% paid to the '                               
                         WS-REV-TABLE                                   
                         DELIMITED BY SIZE                              
                         INTO WS-FORMAT-MESSAGE                         
                  MOVE 75 TO WS-EMB-LENG                                
               ELSE                                                     
                  STRING 'Franchise Fee - '                             
                         WS-DISPLAY-PCT                                 
                         '%'                                            
                         DELIMITED BY SIZE                              
                         INTO WS-FORMAT-MESSAGE                         
                  MOVE 23 TO WS-EMB-LENG                                
               END-IF                                                   
               MOVE SPACES            TO WS-EMB-INPUT                   
                                         WS-CMP-TABLE                   
               MOVE WS-FORMAT-MESSAGE TO WS-EMB-INPUT                   
               PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT       
               MOVE WS-CMP-TABLE      TO WS-UTIL-FRAN-MSG (WS-UTIL-SUB) 
               MOVE WS-AMT-CITY-TAX-BG(SUB1) TO                         
                    WS-UTIL-FRAN-AMT(WS-UTIL-SUB)                       
               ADD WS-AMT-CITY-TAX-BG (SUB1) TO                         
                   WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                     
           END-IF.                                                      
           ADD WS-AMT-STATE-TAX-BG (SUB1) TO                            
               WS-UTIL-TOTAL-CALC (WS-UTIL-SUB).                        
                                                                        
       1320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  THIS ROUTINE PROCESSES RTP BASE CHGS AND BASELINE CHGS  *              
      ************************************************************              
                                                                        
       1350-RTP-CALC.                                                   
                                                                        
           PERFORM VARYING SUB2 FROM 1 BY 1 UNTIL                       
             SUB2 > WS-BZ-MAX-ENTRY OR WS-ACCOUNT-NO-BC (SUB2) = 0      
             IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BC (SUB2) AND   
                WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BC (SUB2) AND         
                WS-CODE-UTIL-TYPE-BG(SUB1) = WS-CODE-UTIL-TYPE-BC(SUB2) 
            AND WS-IC-NO-BG (SUB1) = WS-IC-NO-BC (SUB2) AND             
                WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                       
                WS-BILL-ITEM-TIMESTMP-BC (SUB2)                         
                PERFORM 1360-RTP-CALCS THRU 1360-EXIT                   
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
                                                                        
       1350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1360-RTP-CALCS.                                                  
                                                                        
           IF WS-COMPONENT-ID-BC (SUB2) = '80'                          
               ADD WS-CALC-COMPONENT-AMT-BC (SUB2) TO                   
                   WS-RTP-TOT-BASE-CHARGES  (WS-UTIL-SUB)               
                   WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                     
               EVALUATE WS-CONSUMPTION-TYPE-BC (SUB2)                   
                   WHEN 'B'                                             
                       ADD WS-CALC-COMPONENT-AMT-BC (SUB2) TO           
                           WS-BASE-KWH                                  
                       ADD WS-NET-UNITS-BC (SUB2) TO                    
                           WS-BASE-KWH-UNITS                            
                   WHEN 'E'                                             
                       ADD WS-CALC-COMPONENT-AMT-BC (SUB2) TO           
                           WS-BASE-KVA                                  
                       ADD WS-NET-UNITS-BC (SUB2) TO                    
                           WS-BASE-KVA-UNITS                            
                   WHEN 'J'                                             
                       ADD WS-CALC-COMPONENT-AMT-BC (SUB2) TO           
                           WS-BASE-KW                                   
                       ADD WS-NET-UNITS-BC (SUB2) TO                    
                           WS-BASE-KW-UNITS                             
               END-EVALUATE
           END-IF.                                            
           IF WS-COMPONENT-ID-BC (SUB2) = '90'                          
               ADD WS-CALC-COMPONENT-AMT-BC (SUB2) TO                   
                   WS-TOTAL-RTP-CHARGES (WS-UTIL-SUB)                   
                   WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                     
               EVALUATE WS-CONSUMPTION-TYPE-BC (SUB2)                   
                   WHEN 'B'                                             
                       ADD WS-CALC-COMPONENT-AMT-BC (SUB2) TO           
                           WS-RTP-KWH-OVER                              
                       ADD WS-READ-UNITS-BC(SUB2) TO                    
                           WS-RTP-KWH-READ-UNITS-OVER                   
                   WHEN 'E'                                             
                       ADD WS-NET-COMPONENT-AMT-BC (SUB2) TO            
                           WS-RTP-KVA-OVER                              
                   WHEN 'J'                                             
                       ADD WS-NET-COMPONENT-AMT-BC (SUB2) TO            
                           WS-RTP-KW-OVER                               
               END-EVALUATE
           END-IF.                                            
           IF WS-COMPONENT-ID-BC (SUB2) = '91'                          
               ADD WS-NET-COMPONENT-AMT-BC (SUB2) TO                    
                   WS-TOTAL-RTP-CHARGES (WS-UTIL-SUB)                   
                   WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                     
               EVALUATE WS-CONSUMPTION-TYPE-BC (SUB2)                   
                   WHEN 'B'                                             
                       ADD WS-NET-COMPONENT-AMT-BC (SUB2) TO            
                           WS-RTP-KWH-UNDER                             
                       ADD WS-READ-UNITS-BC(SUB2) TO                    
                           WS-RTP-KWH-READ-UNITS-UNDER                  
                   WHEN 'E'                                             
                       ADD WS-NET-COMPONENT-AMT-BC (SUB2) TO            
                           WS-RTP-KVA-UNDER                             
                   WHEN 'J'                                             
                       ADD WS-NET-COMPONENT-AMT-BC (SUB2) TO            
                           WS-RTP-KW-UNDER                              
               END-EVALUATE
           END-IF.                                            
                                                                        
      ****************************************************************          
      **** no rate comparison amt for RTP                                       
      ****************************************************************          
                                                                        
       1360-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1370-RTP-OTHER-CALC.                                             
                                                                        
           MOVE 1                         TO WS-UTIL-CHG-SUB.           
           PERFORM 1315-DETERMINE-BASE-CHG THRU 1315-EXIT               
           IF WS-BASE-KWH > 0.00                                        
              MOVE SPACES                 TO WS-FORMAT-MESSAGE          
              MOVE WS-BASE-KWH-UNITS      TO WS-DISPLAY-UNITS           
P00496             WS-UTIL-CHG-USAGE(WS-UTIL-SUB WS-UTIL-CHG-SUB)       
P00496        MOVE 'kWh '                 TO                            
P00496             WS-UTIL-CHG-USAGE-TYPE(WS-UTIL-SUB WS-UTIL-CHG-SUB)  
              STRING 'Energy Charge '                                   
                      WS-DISPLAY-UNITS                                  
                      ' '                                               
                      'kWh '                                            
                      DELIMITED BY SIZE                                 
                 INTO WS-FORMAT-MESSAGE                                 
              MOVE 31                     TO WS-EMB-LENG                
              MOVE SPACES                 TO WS-EMB-INPUT               
                                             WS-CMP-TABLE               
              MOVE WS-FORMAT-MESSAGE      TO WS-EMB-INPUT               
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT        
              MOVE WS-CMP-TABLE           TO                            
                   WS-UTIL-BASE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
              MOVE WS-BASE-KWH            TO                            
                   WS-UTIL-BASE-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
              ADD 1                       TO WS-UTIL-CHG-SUB            
           END-IF.                                                      
           IF WS-BASE-KW > 0.00                                         
              MOVE SPACES                TO WS-FORMAT-MESSAGE           
              MOVE WS-BASE-KW-UNITS      TO WS-DISPLAY-UNITS            
                                  WS-UTIL-RTP-BILLING-DEM(WS-UTIL-SUB)  
P00496             WS-UTIL-CHG-USAGE(WS-UTIL-SUB WS-UTIL-CHG-SUB)       
              MOVE 'KW '          TO WS-UTIL-RTP-UNIT-TYPE (WS-UTIL-SUB)
P00496             WS-UTIL-CHG-USAGE-TYPE(WS-UTIL-SUB WS-UTIL-CHG-SUB)  
              STRING 'Demand Charge '                                   
                      WS-DISPLAY-UNITS                                  
                      ' '                                               
                      'kW '                                             
                      DELIMITED BY SIZE                                 
                 INTO WS-FORMAT-MESSAGE                                 
              MOVE 30                    TO WS-EMB-LENG                 
              MOVE SPACES                TO WS-EMB-INPUT                
                                            WS-CMP-TABLE                
              MOVE WS-FORMAT-MESSAGE     TO WS-EMB-INPUT                
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT        
              MOVE WS-CMP-TABLE          TO                             
                   WS-UTIL-BASE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
              MOVE WS-BASE-KW            TO                             
                    WS-UTIL-BASE-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)  
              ADD 1                      TO WS-UTIL-CHG-SUB             
           END-IF.                                                      
           IF WS-BASE-KVA > 0.00 AND WS-BASE-KVA-UNITS NOT EQUAL TO ZERO
              MOVE SPACES                TO WS-FORMAT-MESSAGE           
              MOVE WS-BASE-KVA-UNITS     TO WS-DISPLAY-UNITS            
                                  WS-UTIL-RTP-BILLING-DEM(WS-UTIL-SUB)  
P00496             WS-UTIL-CHG-USAGE(WS-UTIL-SUB WS-UTIL-CHG-SUB)       
              MOVE 'kVA'        TO WS-UTIL-RTP-UNIT-TYPE (WS-UTIL-SUB)  
P00496             WS-UTIL-CHG-USAGE-TYPE(WS-UTIL-SUB WS-UTIL-CHG-SUB)  
              STRING 'Demand Charge '                                   
                     WS-DISPLAY-UNITS                                   
                     ' '                                                
                     'kVA '                                             
                     DELIMITED BY SIZE                                  
                INTO WS-FORMAT-MESSAGE                                  
              MOVE 31                    TO WS-EMB-LENG                 
              MOVE SPACES                TO WS-EMB-INPUT                
                                            WS-CMP-TABLE                
              MOVE WS-FORMAT-MESSAGE     TO WS-EMB-INPUT                
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT        
              MOVE WS-CMP-TABLE          TO                             
                   WS-UTIL-BASE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
              MOVE WS-BASE-KVA           TO                             
                   WS-UTIL-BASE-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
              ADD 1 TO WS-UTIL-CHG-SUB                                  
           END-IF.                                                      
                                                                        
           IF WS-RTP-TOT-BASE-CHARGES   (WS-UTIL-SUB) NOT EQUAL ZERO    
               MOVE SPACES               TO                             
                    WS-UTIL-BASE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)  
               MOVE 'Total Baseline Charges' TO                         
                    WS-UTIL-BASE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)  
               MOVE WS-RTP-TOT-BASE-CHARGES  (WS-UTIL-SUB) TO           
                    WS-UTIL-BASE-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)  
               ADD 1                     TO WS-UTIL-CHG-SUB             
           END-IF.                                                      
                                                                        
           MOVE 1                        TO WS-UTIL-CHG-SUB.            
           PERFORM 1317-DETERMINE-BASELINE-SUB THRU 1317-EXIT           
           IF WS-RTP-KWH-OVER > 0.00                                    
               MOVE SPACES TO WS-FORMAT-MESSAGE                         
               MOVE WS-RTP-KWH-READ-UNITS-OVER  TO WS-DISPLAY-UNITS     
P00496             WS-UTIL-CHG-USAGE(WS-UTIL-SUB WS-UTIL-CHG-SUB)       
P00496         MOVE 'kWh ' TO                                           
P00496             WS-UTIL-CHG-USAGE-TYPE(WS-UTIL-SUB WS-UTIL-CHG-SUB)  
               STRING 'Above Baseline '                                 
                       WS-DISPLAY-UNITS                                 
                       ' '                                              
                       'kWh '                                           
                       DELIMITED BY SIZE                                
                         INTO WS-FORMAT-MESSAGE                         
               MOVE 32 TO WS-EMB-LENG                                   
               MOVE SPACES TO WS-EMB-INPUT                              
                              WS-CMP-TABLE                              
               MOVE WS-FORMAT-MESSAGE TO WS-EMB-INPUT                   
               PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT       
               MOVE WS-CMP-TABLE TO                                     
                    WS-BASELINE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               MOVE WS-RTP-KWH-OVER TO                                  
                    WS-BASELINE-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               ADD 1 TO WS-UTIL-CHG-SUB                                 
           END-IF.                                                      
           IF WS-RTP-KVA-OVER > 0.00                                    
               MOVE 'Above Baseline kVA' TO                             
                    WS-BASELINE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               MOVE WS-RTP-KVA-OVER      TO                             
                    WS-BASELINE-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               ADD 1                     TO WS-UTIL-CHG-SUB             
           END-IF.                                                      
           IF WS-RTP-KW-OVER > 0.00                                     
               MOVE 'Above Baseline kW' TO                              
                    WS-BASELINE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               MOVE WS-RTP-KW-OVER      TO                              
                    WS-BASELINE-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               ADD 1                    TO WS-UTIL-CHG-SUB              
           END-IF.                                                      
           IF WS-RTP-KWH-UNDER < 0.00                                   
               MOVE SPACES               TO WS-FORMAT-MESSAGE           
               MOVE WS-RTP-KWH-READ-UNITS-UNDER TO WS-DISPLAY-UNITS     
P00496              WS-UTIL-CHG-USAGE(WS-UTIL-SUB WS-UTIL-CHG-SUB)      
P00496         MOVE 'kWh ' TO                                           
P00496             WS-UTIL-CHG-USAGE-TYPE(WS-UTIL-SUB WS-UTIL-CHG-SUB)  
               STRING 'Below Baseline '                                 
                      WS-DISPLAY-UNITS                                  
                      ' '                                               
                      'kWh '                                            
                      DELIMITED BY SIZE                                 
                 INTO WS-FORMAT-MESSAGE                                 
               MOVE 32                   TO WS-EMB-LENG                 
               MOVE SPACES               TO WS-EMB-INPUT                
                                            WS-CMP-TABLE                
               MOVE WS-FORMAT-MESSAGE    TO WS-EMB-INPUT                
               PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT       
               MOVE WS-CMP-TABLE         TO                             
                    WS-BASELINE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               MOVE WS-RTP-KWH-UNDER     TO                             
                    WS-BASELINE-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               ADD 1                     TO WS-UTIL-CHG-SUB             
           END-IF.                                                      
           IF WS-RTP-KVA-UNDER < 0.00                                   
               MOVE 'Below Baseline kVA' TO                             
                    WS-BASELINE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               MOVE WS-RTP-KVA-UNDER     TO                             
                    WS-BASELINE-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               ADD 1                     TO WS-UTIL-CHG-SUB             
           END-IF.                                                      
           IF WS-RTP-KW-UNDER < 0.00                                    
               MOVE 'Below Baseline kW' TO                              
                    WS-BASELINE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               MOVE WS-RTP-KW-UNDER     TO                              
                    WS-BASELINE-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
               ADD 1                    TO WS-UTIL-CHG-SUB              
           END-IF.                                                      
           MOVE 1 TO SUB2.                                              
           PERFORM UNTIL SUB2 > 100 OR WS-ACCOUNT-NO-BA (SUB2) = ZEROES 
              IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BA (SUB2) AND  
                 WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BA (SUB2) AND        
                 WS-CODE-UTIL-TYPE-BG (SUB1) =                          
                 WS-CODE-UTIL-TYPE-BA (SUB2) AND                        
                 WS-IC-NO-BG (SUB1) = WS-IC-NO-BA (SUB2) AND            
                 WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
                 WS-BILL-ITEM-TIMESTMP-BA (SUB2) AND                    
                 WS-FACTOR-ID-BA (SUB2) = 'ADMIN   '                    
                   MOVE 'Administration Charge' TO                      
                      WS-BASELINE-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB) 
                   MOVE WS-AMT-ADJUSTMENT-BA (SUB2) TO                  
                      WS-BASELINE-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB) 
                   ADD WS-AMT-ADJUSTMENT-BA (SUB2) TO                   
                         WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)               
                         WS-TOTAL-RTP-CHARGES (WS-UTIL-SUB)             
                     ADD 1 TO WS-UTIL-CHG-SUB                           
               END-IF                                                   
               ADD 1 TO SUB2                                            
           END-PERFORM.                                                 
                                                                        
       1370-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  THIS ROUTINE PROCESSES ALL BLOCKS OF ELECTRIC DEMAND    *              
      *  USAGE, PRINTING THE CORRECT MESSAGE.                    *              
P00496*  PARAGRAPH RESTRUCTURED.                                                
      ************************************************************              
                                                                        
       1400-UTIL-CALCS.                                                 
                                                                        
      **** FOR RTP UTIL CALC IS PROCESSED ONLY WHEN COMPONENT ID BC - 20        
           IF RTP AND WS-COMPONENT-ID-BC (SUB2) NOT = '20'              
              GO TO 1400-EXIT                                           
           END-IF.                                                      
                                                                        
P00496**** GET THE COMPONENT DESC AND MARK THE ROW AS HEADER.                   
P00496     IF WS-PRINT-CMPNT-DESC-FL = 'Y' AND                          
P00496       WS-PREV-COMPONENT-ID NOT EQUAL TO WS-COMPONENT-ID-BC (SUB2)
P00496        PERFORM 6000-GET-COMPONENT-DESC THRU 6000-EXIT            
P00496        IF WS-CMPNT-DESC > SPACES                                 
P00496*A03059    MOVE SPACES        TO                                          
P00496*A03059         WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)             
P00496*A03059    MOVE 'Y' TO WS-UTIL-CHG-HDR-ROW                                
P00496*A03059                           (WS-UTIL-SUB WS-UTIL-CHG-SUB)           
P00496*A03059    ADD +1                      TO WS-UTIL-CHG-SUB                 
P00496           MOVE WS-CMPNT-DESC TO                                  
P00496                WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)     
P00496           MOVE 'Y' TO WS-UTIL-CHG-HDR-ROW                        
P00496                                  (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
P00496           ADD +1                      TO WS-UTIL-CHG-SUB         
P00496        END-IF                                                    
P00496     END-IF.                                                      
P00496                                                                  
           MOVE SPACES              TO WS-FORMAT-MESSAGE                
                                       WS-FORMAT-LITERAL.               
           PERFORM 1410-EVALUATE-TYPE THRU 1410-EXIT.                   
           IF (ELEC-DEMAND OR WHOLESALE OR TOU-DEMAND ) AND             
              WS-NET-UNIT-SEL-RSN-BC (SUB2) > SPACES                    
               MOVE 1               TO WS-UNIT-SEL-SUB                  
               PERFORM 1500-UNIT-SEL-MESSAGE THRU 1500-EXIT             
           END-IF.                                                      
           IF WS-CONSUMPTION-TYPE-BC (SUB2) = 'E' OR 'J'                
              ADD WS-NET-UNITS-BC (SUB2) TO                             
                  WS-UTIL-CURR-BILL-DEM (WS-UTIL-SUB)                   
XXXXXX**** SHOULD THIS ONLY BE FOR TOU?                                         
              IF TOU-DEMAND                                             
                 ADD WS-NET-UNITS-BC (SUB2) TO                          
                     WS-UTIL-DEM-CURR-BILL-DEM (WS-UTIL-SUB)            
T12357           EVALUATE WS-CODE-TOU-BC (SUB2)                         
T12357               WHEN 1                                             
T12357                   ADD WS-NET-UNITS-BC (SUB2) TO                  
T12357                       WS-UTIL-DEM-CURR-DEM-ON(WS-UTIL-SUB)       
T12357               WHEN 2                                             
T12357                   ADD WS-NET-UNITS-BC (SUB2) TO                  
T12357                       WS-UTIL-DEM-CURR-DEM-OFF(WS-UTIL-SUB)      
T12357           END-EVALUATE                                           
              END-IF                                                    
XXXXXX**** SHOULD THIS ONLY BE FOR TOU?                                         
              IF WS-CONSUMPTION-TYPE-BC (SUB2) = 'E'                    
                 MOVE 'kVA' TO WS-UTIL-CURR-BILL-UNITS (WS-UTIL-SUB)    
                               WS-UTIL-DEM-CURR-BILL-UNTS (WS-UTIL-SUB) 
              ELSE                                                      
                 MOVE 'kW ' TO WS-UTIL-CURR-BILL-UNITS (WS-UTIL-SUB)    
                               WS-UTIL-DEM-CURR-BILL-UNTS (WS-UTIL-SUB) 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF GAS AND WS-COMPANY-NO-AT = '01'                           
                 MOVE 'Base -' TO WS-FORMAT-LITERAL                     
           END-IF.                                                      
                                                                        
           MOVE 1 TO WS-BLOCK-SUB.                                      
           PERFORM UNTIL WS-BLOCK-SUB > 9 OR                            
                         WS-BLOCK-SUB > WS-BLOCKS-USED-BC (SUB2)        
P01175        IF WS-UNITS-BILLED-BC (SUB2 WS-BLOCK-SUB) < 0  AND        
P01175          (WS-170-RATE-SUB-GRP-TYPE-CD = 'B'  OR                  
P01175           WS-170-RATE-SUB-GRP-TYPE-CD = 'D'  OR                  
P01175           WS-170-RATE-SUB-GRP-TYPE-CD = 'C'  OR                  
P01175           WS-170-RATE-SUB-GRP-TYPE-CD = 'F')                     
P01175           COMPUTE WS-UNITS-BILLED =                              
P01175                   WS-UNITS-BILLED-BC (SUB2 WS-BLOCK-SUB) * -1    
P01175           MOVE WS-UNITS-BILLED   TO WS-DISPLAY-UNITS             
P01175           MOVE WS-UNITS-BILLED-BC (SUB2 WS-BLOCK-SUB) TO         
P01175                WS-UTIL-CHG-USAGE (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
P01175        ELSE                                                      
P01175           MOVE WS-UNITS-BILLED-BC (SUB2 WS-BLOCK-SUB) TO         
P01175                WS-DISPLAY-UNITS                                  
P01175                WS-UTIL-CHG-USAGE (WS-UTIL-SUB WS-UTIL-CHG-SUB)   
P01175        END-IF                                                    
P00496        MOVE WS-CNSMPTN-TYPE  TO                                  
P00496             WS-UTIL-CHG-USAGE-TYPE (WS-UTIL-SUB WS-UTIL-CHG-SUB) 
      **** STATELINE BILLING RATE IS CARRIED TO 12 DECIMAL PLACES AS            
      **** OPPOSED TO 5 FOR REGULAR RATES                                       
              IF WS-RATE-PLAN-NO-BG (SUB1) = '065' OR '066'             
                 MOVE WS-AMT-NET-RATE-BC (SUB2 WS-BLOCK-SUB) TO         
                                                     WS-DISPLAY-RATE2   
              ELSE                                                      
P01175           IF (WS-170-RATE-SUB-GRP-TYPE-CD = 'B'  OR              
P01175               WS-170-RATE-SUB-GRP-TYPE-CD = 'D'  OR              
P01175               WS-170-RATE-SUB-GRP-TYPE-CD = 'C'  OR              
P01175               WS-170-RATE-SUB-GRP-TYPE-CD = 'F') AND             
P01175              WS-AMT-NET-RATE-BC (SUB2 WS-BLOCK-SUB) > 0          
P01175              COMPUTE WS-DISPLAY-RATE =                           
P01175                WS-AMT-NET-RATE-BC (SUB2 WS-BLOCK-SUB) * -1       
P01175           ELSE                                                   
P01175                MOVE WS-AMT-NET-RATE-BC (SUB2 WS-BLOCK-SUB) TO    
P01175                                                 WS-DISPLAY-RATE  
P01175           END-IF                                                 
              END-IF                                                    
              IF WS-PRICE-TYPE-CD-BC (SUB2 WS-BLOCK-SUB) = 'F'          
                 MOVE SPACES                      TO WS-FORMAT-RATES    
              ELSE                                                      
                 PERFORM 1415-FORMAT-BC-DETAILS THRU 1415-EXIT          
              END-IF                                                    
              MOVE SPACES               TO WS-FORMAT-MESSAGE            
                                           WS-FORMAT-BASE-LITERAL       
P00496        PERFORM 6100-GET-BLOCK-DESC   THRU 6100-EXIT              
              IF WS-BLOCK-SUB = 1                                       
                 IF GAS                                                 
                    IF WS-GAS-BASE-USE-BG (SUB1) = 0 AND                
                       WS-BLOCK-SIZE-BC (SUB2 1) = 0 AND                
                       WS-UNITS-BILLED-BC (SUB2 1) = 0                  
                       PERFORM 1425-ZERO-SUMMER-BASE THRU 1425-EXIT     
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 IF GAS                                                 
                    MOVE SPACES           TO WS-FORMAT-LITERAL          
                 END-IF                                                 
              END-IF                                                    
              IF WS-EVENT-DATE-BC (SUB2) > SPACES                       
                 MOVE WS-EVENT-DATE-BC(SUB2) TO WS-EVENT-DATE-FMT       
                 STRING    WS-EVENT-MM                                  
                           '/'                                          
                           WS-EVENT-DD                                  
                           DELIMITED BY SIZE INTO WS-EVENT-DETAIL       
              ELSE                                                      
                 MOVE SPACES                 TO WS-EVENT-DETAIL         
              END-IF                                                    
I01959        IF (WS-HOLD-BILL-FORMAT = '11' OR                         
I01959            WS-HOLD-BILL-FORMAT = '12') AND                       
I01959            WS-FORMAT-RATES = ' X $     0.000000'                 
I01959               MOVE SPACES   TO WS-FORMAT-RATES                   
I01959        END-IF                                                    
I02104* Add * for footnote only on PR1 rate                                     
I02104        IF WS-PR1-RATE-FL = 'Y' AND WS-HOLD-TIME-PERIOD = 3       
I02104           STRING WS-EVENT-DETAIL                                 
I02104                  ' '                                             
I02104                  WS-FORMAT-LITERAL                               
I02104                  WS-BLK-DESC                                     
I02104                  WS-DISPLAY-UNITS                                
I02104                  ' '                                             
I02104                  WS-CNSMPTN-TYPE                                 
I02104                  WS-FORMAT-RATES                                 
I02104                  ' *'                                            
I02104                  DELIMITED BY SIZE INTO WS-FORMAT-MESSAGE        
I02104        ELSE                                                      
P00496           STRING WS-EVENT-DETAIL                                 
                        ' '                                             
                        WS-FORMAT-LITERAL                               
P00496                  WS-BLK-DESC                                     
                        WS-DISPLAY-UNITS                                
                        ' '                                             
                        WS-CNSMPTN-TYPE                                 
                        WS-FORMAT-RATES                                 
                        DELIMITED BY SIZE INTO WS-FORMAT-MESSAGE        
I02104        END-IF                                                    
A03959        MOVE 217 TO WS-EMB-LENG                                   
              MOVE SPACES TO WS-EMB-INPUT                               
                             WS-CMP-TABLE                               
              MOVE WS-FORMAT-MESSAGE TO WS-EMB-INPUT                    
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT        
              MOVE WS-CMP-TABLE TO                                      
                   WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)        
P00496        MOVE 'N' TO WS-UTIL-CHG-HDR-ROW                           
P00496                             (WS-UTIL-SUB WS-UTIL-CHG-SUB)        
              MOVE WS-AMT-BLOCK-BC (SUB2 WS-BLOCK-SUB) TO               
                   WS-UTIL-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)        
              ADD  WS-AMT-BLOCK-BC (SUB2 WS-BLOCK-SUB) TO               
                   WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                     
A03959        PERFORM VARYING WS-BILL-ADJ-INDX FROM 1 BY 1 UNTIL        
A03959           WS-BILL-ADJ-INDX >  WS-BA-MAX-ENTRY OR                 
A03959           WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX) = ZEROES           
A03959           IF WS-BILLING-KEY-BA (WS-BILL-ADJ-INDX) =              
A03959              WS-BILLING-KEY-BC (SUB2) AND                        
A03959              WS-FCT-CMPNT-ID-BA (WS-BILL-ADJ-INDX) =             
A03959              WS-COMPONENT-CODE-BC (SUB2) AND                     
A03959              WS-FCT-CNSMPT-TYPE-BA (WS-BILL-ADJ-INDX) =          
A03959              WS-CONSUMPTION-TYPE-BC (SUB2) AND                   
A03959              WS-FCT-REGISTER-TYPE-BA (WS-BILL-ADJ-INDX) =        
A03959              WS-REGISTER-TYPE-BC (SUB2) AND                      
A03959              WS-FCT-TOU-BA (WS-BILL-ADJ-INDX) =                  
A03959              WS-CODE-TOU-BC (SUB2) AND                           
A03959              WS-FCT-RATE-VERSION-BA (WS-BILL-ADJ-INDX) =         
A03959              WS-RATE-VERSION-BC (SUB2) AND                       
A03959              (WS-BLOCK-NO-BA (WS-BILL-ADJ-INDX) = WS-BLOCK-SUB)  
A03950                                                             AND  
A03959              WS-BILL-PRT-LN-ITM-FL-BA (WS-BILL-ADJ-INDX) = 'B'   
A03959                                                             AND  
A03959              WS-AMT-ADJUSTMENT-BA (WS-BILL-ADJ-INDX) NOT = 0.0   
A03959              ADD 1 TO WS-UTIL-CHG-SUB                            
A03959              PERFORM 3620-FORMAT-FACTORS THRU 3620-EXIT          
A03959              MOVE WS-FACTOR-DESC-BC-PRINT TO                     
A03959                   WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)  
A03959              MOVE 'N' TO WS-UTIL-CHG-HDR-ROW                     
A03959                                   (WS-UTIL-SUB WS-UTIL-CHG-SUB)  
A03959              MOVE WS-FACTOR-AMT-BC-PRINT TO                      
A03959                   WS-UTIL-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)  
A03959              ADD WS-FACTOR-AMT-BC-PRINT TO                       
A03959                  WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                
A03959              IF RTP                                              
A03959                 ADD WS-FACTOR-AMT-BC-PRINT TO                    
A03959                     WS-TOTAL-RTP-CHARGES (WS-UTIL-SUB)           
A03959              END-IF                                              
A03959           END-IF                                                 
A03959        END-PERFORM                                               
              ADD 1 TO WS-UTIL-CHG-SUB WS-BLOCK-SUB                     
           END-PERFORM.                                                 
P00496     MOVE WS-COMPONENT-ID-BC (SUB2) TO WS-PREV-COMPONENT-ID.      
                                                                        
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  TRANSLATE CONSUMPTION TYPE INTO A LITERAL.              *              
      ************************************************************              
                                                                        
       1410-EVALUATE-TYPE.                                              
                                                                        
           MOVE WS-CONSUMPTION-TYPE-BC (SUB2)                           
                                         TO WS-HOLD-CONSUMPTION-TYPE.   
           MOVE WS-CODE-TOU-BC (SUB2)    TO WS-HOLD-TIME-PERIOD.        
           PERFORM 1411-FORMAT-TYPE      THRU 1411-EXIT.                
           INITIALIZE WS-FORMAT-LITERAL.                                
I01959     IF (TOU-NONDEM OR TOU-DEMAND OR SOLAR-TOU )                  
              EVALUATE WS-CODE-SEASON-BC (SUB2)                         
                  WHEN 'N'                                              
                      MOVE 'Non-summer ' TO WS-SEASON-CODE              
                           WS-UTIL-SEASON-CODE(WS-UTIL-SUB)             
                  WHEN 'S'                                              
                      MOVE 'Summer '     TO WS-SEASON-CODE              
                           WS-UTIL-SEASON-CODE(WS-UTIL-SUB)             
                  WHEN OTHER                                            
                      MOVE SPACES        TO WS-SEASON-CODE              
              END-EVALUATE                                              
P1175A        MOVE WS-SEASON-CODE        TO WS-HOLD-SEASON-CODE         
              STRING WS-TOU-CODE                                        
                     WS-SEASON-CODE                                     
                     DELIMITED BY SIZE                                  
                INTO WS-FORMAT-LITERAL                                  
           ELSE                                                         
              INITIALIZE WS-TOU-CODE                                    
                         WS-SEASON-CODE                                 
           END-IF.                                                      
           IF RTP                                                       
              EVALUATE WS-CNSMPTN-TYPE                                  
                  WHEN 'kW '                                            
                       MOVE 'Demand Charge '     TO WS-FORMAT-LITERAL   
                  WHEN 'kWh'                                            
                       MOVE 'Energy Charge '     TO WS-FORMAT-LITERAL   
                  WHEN OTHER                                            
                       MOVE SPACES               TO WS-FORMAT-LITERAL   
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
I02104     IF WS-RATE-PLAN-NO-BG (SUB1) = 'PR1'                         
I02104        PERFORM 1640-BUILD-CRITICAL-PEAK THRU 1640-EXIT           
I02104     END-IF.                                                      
I02104                                                                  
       1410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1411-FORMAT-TYPE.                                                
                                                                        
           EVALUATE WS-HOLD-CONSUMPTION-TYPE                            
               WHEN 'B'                                                 
                   MOVE 'kWh'    TO WS-CNSMPTN-TYPE                     
               WHEN 'C'                                                 
                   MOVE 'Therms' TO WS-CNSMPTN-TYPE                     
               WHEN 'E'                                                 
                   MOVE 'kVA'    TO WS-CNSMPTN-TYPE                     
               WHEN 'J'                                                 
                   MOVE 'kW'     TO WS-CNSMPTN-TYPE                     
           END-EVALUATE.                                                
                                                                        
                                                                        
I01959     IF (TOU-NONDEM OR TOU-DEMAND OR SOLAR-TOU )                  
              EVALUATE WS-HOLD-TIME-PERIOD                              
                  WHEN 1                                                
                      MOVE 'On-peak'  TO WS-TOU-CODE                    
                  WHEN 2                                                
                      MOVE 'Off-peak' TO WS-TOU-CODE                    
                  WHEN 3                                                
I02104                IF WS-CRITICAL-PEAK-FL = 'Y'                      
I02104                   MOVE 'Critical-peak' TO WS-TOU-CODE            
I02104                ELSE                                              
I02104                   MOVE 'Shoulder' TO WS-TOU-CODE                 
I02104                END-IF                                            
                  WHEN OTHER                                            
                      MOVE SPACES     TO WS-TOU-CODE                    
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
       1411-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *DETERMINE IF ELECTRIC CHARGE LINE DESCRIPTION NEEDS TO   **              
      *CONTAIN WNA FACTOR DATA.                                 **              
      ************************************************************              
      *                                                                         
       COPY CPD00064.                                                           
      *                                                                         
       1425-ZERO-SUMMER-BASE.                                           
                                                                        
            ADD +1                 TO WS-BLOCK-SUB.                     
            MOVE WS-UNITS-BILLED-BC(SUB2 WS-BLOCK-SUB) TO               
                 WS-FORMAT-UNITS                                        
P00496           WS-UTIL-CHG-USAGE (WS-UTIL-SUB WS-UTIL-CHG-SUB)        
                 WS-DISPLAY-UNITS.                                      
            MOVE WS-AMT-NET-RATE-BC(SUB2 WS-BLOCK-SUB) TO               
                 WS-DISPLAY-RATE.                                       
            PERFORM 1415-FORMAT-BC-DETAILS THRU 1415-EXIT.              
                                                                        
       1425-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       1430-FORMAT-TOTAL-WNA-CHARGES.                                   
      *                                                                         
           MOVE 1                   TO SUB2.                            
           MOVE +0.00 TO WS-WNA-TOTAL-AMT.                              
      *                                                                         
           PERFORM UNTIL SUB2 > WS-BZ-MAX-ENTRY OR                      
             WS-ACCOUNT-NO-BC (SUB2) = ZEROES                           
              IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BC (SUB2)      
             AND WS-BILL-NO-BG (SUB1)    = WS-BILL-NO-BC (SUB2)         
             AND WS-CODE-UTIL-TYPE-BG(SUB1) = WS-CODE-UTIL-TYPE-BC(SUB2)
             AND WS-IC-NO-BG (SUB1)      = WS-IC-NO-BC (SUB2)           
             AND WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
                 WS-BILL-ITEM-TIMESTMP-BC (SUB2)                        
                 ADD WS-TOTAL-WNA-AMT-BC (SUB2)                         
                  TO WS-WNA-TOTAL-AMT ROUNDED                           
              END-IF                                                    
              ADD 1                 TO SUB2                             
           END-PERFORM.                                                 
      *                                                                         
           IF WS-WNA-TOTAL-AMT EQUAL ZERO                               
              GO TO 1430-EXIT                                           
           ELSE                                                         
              MOVE WS-WNA-TOTAL-AMT TO WS-DISPLAY-WNA-TOTAL-AMT         
              STRING 'Total Gas Charges include Weather '               
                     'Normalization Adjustment (WNA) of $'              
                     WS-DISPLAY-WNA-TOTAL-AMT                           
                     DELIMITED BY SIZE                                  
                INTO WS-FORMAT-MESSAGE                                  
              MOVE SPACES            TO WS-EMB-INPUT                    
                                        WS-CMP-TABLE                    
              MOVE 99                TO WS-EMB-LENG                     
              MOVE WS-FORMAT-MESSAGE TO WS-EMB-INPUT                    
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT        
              MOVE WS-CMP-TABLE TO                                      
                     WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)      
P00496        MOVE 'N' TO WS-UTIL-CHG-HDR-ROW                           
P00496                             (WS-UTIL-SUB WS-UTIL-CHG-SUB)        
      *                                                                         
              ADD 1 TO WS-UTIL-CHG-SUB                                  
      *                                                                         
              IF WS-UTIL-CHG-SUB > 200                                  
                 MOVE 12                         TO RETURN-CODE         
                 MOVE 'OVER 200 CHARGE MESSAGES' TO WS-MISC-MSG-TEXT    
                 MOVE +24                        TO WS-MISC-MSG-LEN     
                 PERFORM 9910-MISC-ERROR THRU 9910-EXIT                 
                 PERFORM 9999-BAIL-OUT THRU 9999-EXIT                   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  FORMAT CWS00089 COPYBOOK WITH DATA FOR ADJUSTMENT REASON*              
      *  MESSAGES.  THE MESSAGE WILL BE FORMATTED IN PCSCA925/910*              
      ************************************************************              
                                                                        
       1500-UNIT-SEL-MESSAGE.                                           
                                                                        
           INITIALIZE WS-UNIT-SEL-LOAD-SW.                              
           PERFORM VARYING WS-UNIT-SEL-SUB FROM 1 BY 1 UNTIL            
             WS-UNIT-SEL-SUB > 10 OR                                    
             WS-UNIT-SEL-LOAD-SW = 'Y' OR                               
            (WS-NET-UNIT-SEL-RSN-BC (SUB2) =                            
             WS-UNIT-SEL-RSN (WS-UNIT-SEL-SUB) AND                      
             WS-IC-NO-BC(SUB2) = WS-RATCHET-IC-NO(WS-UNIT-SEL-SUB))     
             IF WS-UNIT-SEL-RSN (WS-UNIT-SEL-SUB) = SPACES AND          
P00636          WS-RATCHET-MESSAGE (WS-UNIT-SEL-SUB) = SPACES           
               MOVE 'Y'           TO WS-UNIT-SEL-LOAD-SW                
               EVALUATE TRUE                                            
                   WHEN ELEC-DEMAND                                     
                     MOVE 'D'     TO WS-MSG-RATE-TYPE (WS-UNIT-SEL-SUB) 
                   WHEN WHOLESALE                                       
                     MOVE 'W'     TO WS-MSG-RATE-TYPE (WS-UNIT-SEL-SUB) 
                   WHEN TOU-DEMAND                                      
                     MOVE 'O'     TO WS-MSG-RATE-TYPE (WS-UNIT-SEL-SUB) 
               END-EVALUATE                                             
               MOVE WS-IC-NO-BC(SUB2)             TO                    
                    WS-RATCHET-IC-NO(WS-UNIT-SEL-SUB)                   
               MOVE WS-NET-UNIT-SEL-RSN-BC (SUB2) TO                    
                    WS-UNIT-SEL-RSN (WS-UNIT-SEL-SUB)                   
               MOVE WS-CNSMPTN-TYPE TO                                  
                    WS-CONSUMPTION-TYPE (WS-UNIT-SEL-SUB)               
               MOVE WS-RATCHET-DEM-USED-CALC (SUB1) TO                  
                    WS-RATCHET-DEM-USED (WS-UNIT-SEL-SUB)               
               MOVE WS-RATCHET-DATE-CALC (SUB1) (6:2) TO                
                    WS-RATCHET-DATE (WS-UNIT-SEL-SUB) (1:2)             
               MOVE '/' TO WS-RATCHET-DATE (WS-UNIT-SEL-SUB) (3:1)      
               MOVE WS-RATCHET-DATE-CALC (SUB1) (3:2) TO                
                    WS-RATCHET-DATE (WS-UNIT-SEL-SUB) (4:2)             
               COMPUTE WS-COMPUTE-PCT =                                 
                       WS-RATCHET-PCT-CALC (SUB1) * 100                 
               MOVE WS-COMPUTE-PCT TO WS-DISPLAY-PCT                    
               MOVE WS-DISPLAY-PCT TO                                   
                    WS-RATCHET-PCT (WS-UNIT-SEL-SUB)                    
               COMPUTE WS-COMPUTE-PF =                                  
                       WS-POWER-FACTOR-CALC (SUB1) * 100                
               MOVE WS-COMPUTE-PF TO                                    
                    WS-POWER-FACTOR (WS-UNIT-SEL-SUB)                   
               IF WS-CONTRACT-DEM-CALC (SUB1) > 0                       
                  MOVE WS-CONTRACT-DEM-CALC (SUB1) TO                   
                       WS-CONTRACT-DEMAND (WS-UNIT-SEL-SUB)             
               ELSE                                                     
                  MOVE WS-BILL-CALC-DEM-USED-CALC (SUB1) TO             
                       WS-CONTRACT-DEMAND (WS-UNIT-SEL-SUB)             
               END-IF                                                   
               IF TOU-DEMAND                                            
                  MOVE WS-CODE-TOU-BC (SUB2) TO                         
                       WS-TIME-PERIOD (WS-UNIT-SEL-SUB)                 
               ELSE                                                     
                  MOVE SPACES TO WS-TIME-PERIOD (WS-UNIT-SEL-SUB)       
               END-IF                                                   
             END-IF                                                     
           END-PERFORM.                                                 
           IF WS-UNIT-SEL-SUB > 10                                      
               MOVE 12                         TO RETURN-CODE           
               MOVE 'OVER 20 RATCHET MESSAGES' TO WS-MISC-MSG-TEXT      
               MOVE +24                        TO WS-MISC-MSG-LEN       
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
               PERFORM 9999-BAIL-OUT THRU 9999-EXIT                     
           END-IF.                                                      
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00636************************************************************              
      *  FORMAT CWS00089 COPYBOOK WITH DATA FOR ADJUSTMENT REASON*              
      *  MESSAGES.  THE MESSAGE WILL BE FORMATTED IN PCSCA925/910*              
      ************************************************************              
                                                                        
       1550-UNIT-SEL-MESSAGE.                                           
                                                                        
           PERFORM VARYING WS-UNIT-SEL-SUB FROM 1 BY 1 UNTIL            
             WS-UNIT-SEL-SUB > 10 OR                                    
             WS-MSG-RATE-TYPE (WS-UNIT-SEL-SUB) = SPACES                
           END-PERFORM.                                                 
           EVALUATE TRUE                                                
           WHEN ELEC-DEMAND                                             
                MOVE 'D'     TO WS-MSG-RATE-TYPE (WS-UNIT-SEL-SUB)      
           WHEN WHOLESALE                                               
                MOVE 'W'     TO WS-MSG-RATE-TYPE (WS-UNIT-SEL-SUB)      
           WHEN TOU-DEMAND                                              
                MOVE 'O'     TO WS-MSG-RATE-TYPE (WS-UNIT-SEL-SUB)      
           END-EVALUATE.                                                
           MOVE WS-IC-NO-BC(SUB2) TO  WS-RATCHET-IC-NO(WS-UNIT-SEL-SUB).
           COMPUTE WS-COMPUTE-PCT =                                     
                   WS-FACTOR-BA (WS-BILL-ADJ-INDX) * 100                
           MOVE WS-COMPUTE-PCT    TO  WS-DISPLAY-PCT                    
                                                                        
           MOVE SPACES                               TO WS-EMB-INPUT    
                                                        WS-CMP-TABLE    
           STRING WS-FACTOR-DESC-BC-PRINT                               
                  ' '                                                   
                  WS-DISPLAY-PCT                                        
                  '%'                                                   
                  DELIMITED BY SIZE INTO                                
                  WS-EMB-INPUT.                                         
           MOVE 97                             TO WS-EMB-LENG .         
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.          
           MOVE WS-CMP-TABLE                   TO                       
                                    WS-RATCHET-MESSAGE(WS-UNIT-SEL-SUB).
           IF WS-UNIT-SEL-SUB > 10                                      
               MOVE 12                         TO RETURN-CODE           
               MOVE 'OVER 20 RATCHET MESSAGES' TO WS-MISC-MSG-TEXT      
               MOVE +24                        TO WS-MISC-MSG-LEN       
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
               PERFORM 9999-BAIL-OUT THRU 9999-EXIT                     
           END-IF.                                                      
                                                                        
       1550-EXIT.                                                       
           EXIT.                                                        
P00636                                                                  
      ************************************************************              
      *  CHECK BA FOR FACTORS INDICATING A SEASONAL OR VERSION   *              
      *  PRORATION; CHECK BG FOR USAGE PRORATION.                *              
      ************************************************************              
                                                                        
       1600-CHECK-FOR-PRORATE.                                          
                                                                        
           IF WS-UTIL-PLAN (WS-UTIL-SUB) =    WS-RATE-PLAN-NO-BG (SUB1) 
                 AND WS-UTIL-IC-NO (WS-UTIL-SUB) = WS-IC-NO-BG (SUB1)   
               PERFORM VARYING SUB2 FROM 1 BY 1 UNTIL SUB2 > 100        
                 OR WS-ACCOUNT-NO-BA (SUB2) = ZEROES                    
                   IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BA (SUB2) 
                      AND WS-BILL-NO-BG (SUB1) =   WS-BILL-NO-BA (SUB2) 
                      AND WS-CODE-UTIL-TYPE-BG (SUB1) =                 
                                            WS-CODE-UTIL-TYPE-BA (SUB2) 
                      AND WS-IC-NO-BG (SUB1) =       WS-IC-NO-BA (SUB2) 
                      AND WS-BILL-ITEM-TIMESTMP-BG (SUB1) =             
                                        WS-BILL-ITEM-TIMESTMP-BA (SUB2) 
                       IF WS-FACTOR-BA (SUB2) > 0                       
                            EVALUATE WS-FACTOR-ID-BA (SUB2)             
                                WHEN 'SNPROPCT'                         
                                WHEN 'S2PROPCT'                         
                                WHEN 'NSPROPCT'                         
                                WHEN 'N2PROPCT'                         
                                    MOVE 'Y' TO WS-SEASONAL-PRORATE     
                                WHEN 'RTPROPCT'                         
                                    MOVE 'Y' TO WS-VERSION-PRORATE      
                            END-EVALUATE                                
                       END-IF                                           
                    END-IF                                              
               END-PERFORM                                              
           END-IF.                                                      
                                                                        
       1600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1610-UTIL-CHGS-PRORATE.                                          
                                                                        
      ********************************                                          
      *  SUM BASIC FACILITY CHARGES  *                                          
      ********************************                                          
                                                                        
           MOVE 1 TO SUB2.                                              
           PERFORM UNTIL SUB2 > 100 OR WS-ACCOUNT-NO-BA (SUB2) = ZEROES 
              IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BA (SUB2) AND  
                 WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BA (SUB2) AND        
                 WS-CODE-UTIL-TYPE-BG (SUB1) =                          
                 WS-CODE-UTIL-TYPE-BA (SUB2) AND                        
                 WS-IC-NO-BG (SUB1) = WS-IC-NO-BA (SUB2) AND            
                 WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
                 WS-BILL-ITEM-TIMESTMP-BA (SUB2) AND                    
                 WS-FACTOR-ID-BA (SUB2) = 'BFACCHRG'                    
                   COMPUTE WS-ROUNDED-BFC ROUNDED =                     
                             WS-AMT-ADJUSTMENT-BA (SUB2) * 1            
                   ADD WS-ROUNDED-BFC TO WS-HOLD-BASIC-FACILITY         
               END-IF                                                   
               ADD 1 TO SUB2                                            
           END-PERFORM.                                                 
                                                                        
      ******************************************                                
      *  PROCESS BILLING DETAIL RECORDS FOR IC *                                
      ******************************************                                
                                                                        
           MOVE 1 TO SUB2.                                              
           PERFORM UNTIL SUB2 > WS-BZ-MAX-ENTRY                         
                      OR WS-ACCOUNT-NO-BC (SUB2) = ZEROES               
              IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BC (SUB2) AND  
                 WS-BILL-NO-BG (SUB1) = WS-BILL-NO-BC (SUB2) AND        
                 WS-CODE-UTIL-TYPE-BG (SUB1) =                          
                             WS-CODE-UTIL-TYPE-BC (SUB2) AND            
                 WS-IC-NO-BG (SUB1) = WS-IC-NO-BC (SUB2) AND            
                 WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                      
                 WS-BILL-ITEM-TIMESTMP-BC (SUB2)                        
                   PERFORM 1620-SUM-PRORATE-USAGE THRU 1620-EXIT        
                   IF NOT GAS                                           
                      COMPUTE WS-HOLD-WNA-TOTAL-AMT =                   
                       WS-HOLD-WNA-TOTAL-AMT + WS-TOTAL-WNA-AMT-BC(SUB2)
                   END-IF                                               
                   IF (ELEC-DEMAND OR WHOLESALE OR TOU-DEMAND) AND      
                      WS-NET-UNIT-SEL-RSN-BC (SUB2) > SPACES            
                      MOVE SPACES            TO WS-FORMAT-MESSAGE       
                      PERFORM 1410-EVALUATE-TYPE THRU 1410-EXIT         
                      MOVE 1                 TO WS-UNIT-SEL-SUB         
                      PERFORM 1500-UNIT-SEL-MESSAGE THRU 1500-EXIT      
                   END-IF                                               
      *******NOT FOR BILL FORMAT 07 TOU - NDEM                                  
                   IF WS-CONSUMPTION-TYPE-BC (SUB2) = 'E' OR 'J'        
                      ADD WS-NET-UNITS-BC (SUB2) TO                     
                          WS-UTIL-CURR-BILL-DEM (WS-UTIL-SUB)           
                      IF TOU-DEMAND                                     
                         EVALUATE WS-CODE-TOU-BC (SUB2)                 
                            WHEN 1                                      
                             ADD WS-NET-UNITS-BC (SUB2) TO              
                                 WS-UTIL-DEM-CURR-DEM-ON (WS-UTIL-SUB)  
                            WHEN 2                                      
                             ADD WS-NET-UNITS-BC (SUB2) TO              
                                 WS-UTIL-DEM-CURR-DEM-OFF (WS-UTIL-SUB) 
                         END-EVALUATE                                   
                      END-IF                                            
                      IF WS-CONSUMPTION-TYPE-BC (SUB2) = 'E'            
                         MOVE 'kVA' TO                                  
                             WS-UTIL-CURR-BILL-UNITS (WS-UTIL-SUB)      
                      ELSE                                              
                         MOVE 'kW ' TO                                  
                             WS-UTIL-CURR-BILL-UNITS (WS-UTIL-SUB)      
                      END-IF                                            
                   END-IF                                               
              END-IF                                                    
              ADD 1 TO SUB2                                             
           END-PERFORM.                                                 
                                                                        
      ******************************************************                    
      *  DETERMINE FIRST BLANK OCCURRENCE IN CHARGES TABLE *                    
      ******************************************************                    
                                                                        
           MOVE 1 TO WS-UTIL-CHG-SUB.                                   
           PERFORM 1310-DETERMINE-CHG-SUB THRU 1310-EXIT.               
                                                                        
           IF WS-HOLD-BASIC-FACILITY > 0                                
              MOVE 'Basic Facilities Charge' TO                         
                    WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)       
P00496        MOVE 'N' TO WS-UTIL-CHG-HDR-ROW                           
P00496                             (WS-UTIL-SUB WS-UTIL-CHG-SUB)        
              MOVE WS-HOLD-BASIC-FACILITY TO                            
                    WS-UTIL-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)       
              ADD WS-HOLD-BASIC-FACILITY TO                             
                    WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                    
              ADD 1 TO WS-UTIL-CHG-SUB                                  
           END-IF.                                                      
                                                                        
           MOVE 1 TO SUB4.                                              
           PERFORM UNTIL SUB4 > 10                                      
                         OR WS-BC-CONSUMPTION-TYPE (SUB4) = SPACES      
               PERFORM 1630-PRORATE-CALCS THRU 1630-EXIT                
               ADD +1 TO SUB4                                           
           END-PERFORM.                                                 
                                                                        
           IF WS-CODE-BILL-CALC-BG (SUB1) NOT = 'S'                     
              PERFORM 1320-FRANCHISE-TAX THRU 1320-EXIT                 
           END-IF.                                                      
                                                                        
           IF WS-COMPANY-NO-AT = '26'                                   
              MOVE SUB1                TO SUB2                          
              ADD 1                    TO SUB2                          
              MOVE 'Y'                 TO WS-LAST-GAS-BG                
              PERFORM UNTIL SUB2 > 30 OR                                
                 WS-ACCOUNT-NO-BG (SUB2) <= ZEROES OR                   
                 WS-LAST-GAS-BG = 'N'                                   
                 IF (GAS AND WS-DATE-ORIG-BILL-BG (SUB2) <= SPACES)     
                     MOVE 'N'          TO WS-LAST-GAS-BG                
                 END-IF                                                 
                 ADD 1                 TO SUB2                          
              END-PERFORM                                               
              IF WS-LAST-GAS-BG = 'Y'                                   
                PERFORM 1430-FORMAT-TOTAL-WNA-CHARGES  THRU 1430-EXIT   
              END-IF                                                    
           END-IF.                                                      
                                                                        
       1610-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1620-SUM-PRORATE-USAGE.                                          
                                                                        
           MOVE 'N' TO WS-BC-TABLE-LOADED.                              
           MOVE 1 TO SUB4.                                              
           PERFORM UNTIL SUB4 > 10 OR WS-BC-TABLE-LOADED = 'Y'          
             IF WS-CONSUMPTION-TYPE-BC (SUB2) =                         
                WS-BC-CONSUMPTION-TYPE (SUB4) AND                       
                WS-CODE-TOU-BC (SUB2) = WS-BC-TIME-PERIOD (SUB4)        
                MOVE 'Y' TO WS-BC-TABLE-LOADED                          
                ADD WS-NET-UNITS-BC (SUB2) TO WS-BC-UNITS (SUB4)        
                ADD WS-CALC-COMPONENT-AMT-BC (SUB2) TO                  
                                         WS-BC-DOLLAR-AMT (SUB4)        
                IF WS-COMPANY-NO-AT = '26'                              
                   ADD WS-READ-UNITS-BC (SUB2) TO WS-BC-READ-UNITS(SUB4)
                END-IF                                                  
             ELSE                                                       
                IF WS-BC-CONSUMPTION-TYPE (SUB4) = SPACES               
                   MOVE 'Y' TO WS-BC-TABLE-LOADED                       
                   MOVE WS-NET-UNITS-BC (SUB2) TO WS-BC-UNITS (SUB4)    
                   MOVE WS-READ-UNITS-BC(SUB2) TO WS-BC-READ-UNITS(SUB4)
                   MOVE WS-CONSUMPTION-TYPE-BC (SUB2) TO                
                                          WS-BC-CONSUMPTION-TYPE (SUB4) 
                   MOVE WS-CODE-TOU-BC (SUB2) TO                        
                                          WS-BC-TIME-PERIOD (SUB4)      
                   MOVE WS-CALC-COMPONENT-AMT-BC (SUB2) TO              
                                          WS-BC-DOLLAR-AMT (SUB4)       
A3019              MOVE WS-AMT-BASE-RATE-BC(SUB2,1) TO                  
A3019                                WS-BC-AMT-BASE-RATE (SUB4)         
A3019              MOVE WS-WNA-BLOCK-FCT-BC(SUB2,1) TO                  
A3019                                WS-BC-WNA-BLOCK-FCT (SUB4)         
                END-IF                                                  
             END-IF                                                     
             ADD +1 TO SUB4                                             
           END-PERFORM.                                                 
                                                                        
           IF WS-BC-TABLE-LOADED = 'N'                                  
      *      YOU'VE GOT REAL PROBLEMS -- NO MATCH, NO OPENING!!                 
             MOVE 12                     TO RETURN-CODE                 
             MOVE 'NO MATCH/SPACE FOR PRORATED USAGE IN WS-SUM-BC-TABLE'
                                         TO WS-MISC-MSG-TEXT            
             MOVE +52                    TO WS-MISC-MSG-LEN             
             PERFORM 9910-MISC-ERROR THRU 9910-EXIT                     
             PERFORM 9999-BAIL-OUT THRU 9999-EXIT                       
           END-IF.                                                      
                                                                        
       1620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  THIS ROUTINE PROCESSES ALL UTILITY USAGE                *              
      ************************************************************              
                                                                        
       1630-PRORATE-CALCS.                                              
                                                                        
           INITIALIZE WS-TOU-CODE.                                      
                                                                        
           MOVE WS-BC-CONSUMPTION-TYPE (SUB4)                           
                                          TO WS-HOLD-CONSUMPTION-TYPE.  
           MOVE WS-BC-TIME-PERIOD (SUB4)  TO WS-HOLD-TIME-PERIOD.       
           PERFORM 1411-FORMAT-TYPE      THRU 1411-EXIT.                
                                                                        
           MOVE SPACES TO WS-FORMAT-MESSAGE.                            
           IF (ELEC-DEMAND OR WHOLESALE OR TOU-DEMAND) AND              
              WS-NET-UNIT-SEL-RSN-BC (SUB2) > SPACES                    
              MOVE 1             TO WS-UNIT-SEL-SUB                     
              PERFORM 1500-UNIT-SEL-MESSAGE THRU 1500-EXIT              
           END-IF.                                                      
                                                                        
           MOVE SPACES TO WS-FORMAT-MESSAGE.                            
           IF WS-BC-CONSUMPTION-TYPE (SUB4) > SPACES AND ( NOT GAS OR   
T35152        (GAS AND WS-BC-UNITS (SUB4) NOT EQUAL TO ZERO))           
P01175        IF (WS-170-RATE-SUB-GRP-TYPE-CD  = 'B' OR                 
P01175            WS-170-RATE-SUB-GRP-TYPE-CD  = 'D' OR                 
P01175            WS-170-RATE-SUB-GRP-TYPE-CD  = 'C' OR                 
P01175            WS-170-RATE-SUB-GRP-TYPE-CD  = 'F') AND               
P01175            WS-BC-UNITS (SUB4) < 0                                
P01175            COMPUTE WS-BC-UNITS (SUB4) = WS-BC-UNITS (SUB4) * -1  
P01175        END-IF                                                    
              MOVE WS-BC-UNITS (SUB4) TO WS-DISPLAY-UNITS               
P00496             WS-UTIL-CHG-USAGE (WS-UTIL-SUB WS-UTIL-CHG-SUB)      
P00496        MOVE WS-CNSMPTN-TYPE  TO                                  
P00496             WS-UTIL-CHG-USAGE-TYPE (WS-UTIL-SUB WS-UTIL-CHG-SUB) 
              IF WS-COMPANY-NO-AT = '26' AND                            
                 WS-BC-UNITS (SUB4) > 0                                 
                 MOVE 1                  TO SUB2                        
                 MOVE +0.00              TO WS-WNA-TOTAL-AMT            
*                                                                       
                 PERFORM UNTIL SUB2 > WS-BZ-MAX-ENTRY OR                
                        WS-ACCOUNT-NO-BC (SUB2) = ZEROES                
                   IF WS-ACCOUNT-NO-BG (SUB1) = WS-ACCOUNT-NO-BC (SUB2) 
                  AND WS-BILL-NO-BG (SUB1)    = WS-BILL-NO-BC (SUB2)    
                  AND WS-IC-NO-BG (SUB1)      = WS-IC-NO-BC (SUB2)      
                  AND WS-CODE-UTIL-TYPE-BG (SUB1) =                     
                      WS-CODE-UTIL-TYPE-BC (SUB2)                       
                  AND WS-BILL-ITEM-TIMESTMP-BG (SUB1) =                 
                      WS-BILL-ITEM-TIMESTMP-BC (SUB2)                   
                      ADD WS-TOTAL-WNA-AMT-BC (SUB2)                    
                       TO WS-WNA-TOTAL-AMT ROUNDED                      
                   END-IF                                               
                   ADD 1 TO SUB2                                        
                 END-PERFORM                                            
*                                                                       
A3019            IF WS-VERSION-PRORATE = 'Y'                            
A3019               COMPUTE WS-DISPLAY-RATE ROUNDED =                   
A3019                (WS-BC-DOLLAR-AMT (SUB4) -   WS-WNA-TOTAL-AMT) /   
A3019                          WS-BC-UNITS (SUB4)                       
A3019               COMPUTE WS-DISPLAY-WNA ROUNDED =                    
A3019                         WS-WNA-TOTAL-AMT / WS-BC-UNITS (SUB4)     
A3019            ELSE                                                   
A3019               COMPUTE WS-DISPLAY-RATE ROUNDED =                   
A3019                (WS-BC-AMT-BASE-RATE (SUB4) +                      
A3019                 WS-BC-WNA-BLOCK-FCT (SUB4))                       
A3019               MOVE WS-BC-WNA-BLOCK-FCT (SUB4) TO WS-DISPLAY-WNA   
A3019            END-IF                                                 
*                                                                       
                 IF WS-WNA-TOTAL-AMT < 0                                
                    MOVE '-'             TO WS-WNA-SIGN                 
                 ELSE                                                   
                    MOVE '+'             TO WS-WNA-SIGN                 
                 END-IF                                                 
*                                                                       
                 IF WS-WNA-TOTAL-AMT EQUAL ZERO                         
                     STRING WS-DISPLAY-UNITS                            
                            ' '                                         
                            WS-CNSMPTN-TYPE                             
                            ' X $'                                      
                            WS-DISPLAY-RATE                             
                     DELIMITED BY SIZE                                  
                     INTO WS-FORMAT-MESSAGE                             
                 ELSE                                                   
                     STRING WS-DISPLAY-UNITS                            
                            ' '                                         
                            WS-CNSMPTN-TYPE                             
                            ' X ($'                                     
                            WS-DISPLAY-RATE                             
                            ' '                                         
                            WS-WNA-SIGN                                 
                            ' $'                                        
                            WS-DISPLAY-WNA                              
                            ' WNA)'                                     
                     DELIMITED BY SIZE                                  
                     INTO WS-FORMAT-MESSAGE                             
                 END-IF                                                 
A03959           MOVE 73 TO WS-EMB-LENG                                 
              ELSE                                                      
                 STRING WS-TOU-CODE                                     
                        ' '                                             
                        WS-DISPLAY-UNITS                                
                        ' '                                             
                        WS-CNSMPTN-TYPE                                 
                        DELIMITED BY SIZE                               
                   INTO WS-FORMAT-MESSAGE                               
A03959             MOVE 32            TO WS-EMB-LENG                    
              END-IF                                                    
              MOVE SPACES             TO WS-EMB-INPUT                   
                                         WS-CMP-TABLE                   
              MOVE WS-FORMAT-MESSAGE  TO WS-EMB-INPUT                   
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT        
              MOVE WS-CMP-TABLE       TO                                
                   WS-UTIL-CHG-MSG (WS-UTIL-SUB WS-UTIL-CHG-SUB)        
P00496        MOVE 'N' TO WS-UTIL-CHG-HDR-ROW                           
P00496                             (WS-UTIL-SUB WS-UTIL-CHG-SUB)        
              MOVE WS-BC-DOLLAR-AMT (SUB4) TO                           
                   WS-UTIL-CHG-AMT (WS-UTIL-SUB WS-UTIL-CHG-SUB)        
              ADD WS-BC-DOLLAR-AMT (SUB4) TO                            
                  WS-UTIL-TOTAL-CALC (WS-UTIL-SUB)                      
              ADD 1 TO WS-UTIL-CHG-SUB                                  
           END-IF.                                                      
           IF WS-UTIL-CHG-SUB > 200                                     
               MOVE 12                         TO RETURN-CODE           
               MOVE 'OVER 200 CHARGE MESSAGES' TO WS-MISC-MSG-TEXT      
               MOVE +24                        TO WS-MISC-MSG-LEN       
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
               PERFORM 9999-BAIL-OUT THRU 9999-EXIT                     
           END-IF.                                                      
                                                                        
       1630-EXIT.                                                       
           EXIT.                                                        
                                                                        
I02104**************************************************************            
I02104*  GET FACTORS TO BUILD CRITICAL PEAK FOOTNOTE FOR PR1 RATES *            
I02104**************************************************************            
I02104                                                                  
I02104 1640-BUILD-CRITICAL-PEAK.                                        
I02104                                                                  
I02104     MOVE 'Y' TO WS-PR1-RATE-FL.                                  
I02104                                                                  
I02104     PERFORM VARYING SUB6 FROM 1 BY 1 UNTIL                       
I02104          SUB6 > 200 OR                                           
I02104          WS-ACCOUNT-NO-BA (SUB6) = ZEROES                        
I02104          IF (WS-BILLING-KEY-BA (SUB6) =                          
I02104             WS-BILLING-KEY-BC (SUB2) AND                         
I02104             WS-FCT-CMPNT-ID-BA (SUB6) =                          
I02104             WS-COMPONENT-CODE-BC (SUB2) AND                      
I02104             WS-FCT-CNSMPT-TYPE-BA (SUB6) =                       
I02104             WS-CONSUMPTION-TYPE-BC (SUB2) AND                    
I02104             WS-FCT-REGISTER-TYPE-BA (SUB6) =                     
I02104             WS-REGISTER-TYPE-BC (SUB2) AND                       
I02104             WS-FCT-TOU-BA (SUB6) =                               
I02104             WS-CODE-TOU-BC (SUB2) AND                            
I2104A             WS-FCT-RATE-VERSION-BA (SUB6) =                      
I2104A             WS-RATE-VERSION-BC (SUB2) AND                        
I2104A             WS-FCT-SEASON-BA (SUB6) =                            
I2104A             WS-CODE-SEASON-BC (SUB2))                            
I02104                 IF WS-FACTOR-BA (SUB6) > 0                       
I02104                      EVALUATE WS-FACTOR-ID-BA (SUB6)             
I02104                          WHEN 'PR1PRICE'                         
I02104                              IF WS-CODE-TOU-BC (SUB2) = 1        
I02104                                 MOVE WS-FACTOR-BA (SUB6) TO      
I02104                                   WS-HOLD-ONPK-FACTOR            
I02104                              END-IF                              
I02104                          WHEN 'PR1CRITPK'                        
I02104                              MOVE WS-FACTOR-BA (SUB6) TO         
I02104                                WS-HOLD-CRIT-FACTOR               
I02104                      END-EVALUATE                                
I02104                 END-IF                                           
I02104          END-IF                                                  
I02104     END-PERFORM.                                                 
I02104                                                                  
I02104 1640-EXIT.                                                       
I02104     EXIT.                                                        
                                                                        
      ************************************************************              
      *  3600-GET-FACTORS                                        *              
      *  3610-ADJUSTMENTS                                        *              
      *  3620-FORMAT-FACTORS                                     *              
      *  3630-BUILD-FACTOR-TABLE                                 *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
A02003         INCLUDE CPD00095                                                 
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *  3700-NONE-CALC.                                         *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00097                                                 
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      *  4000-ENGLISH-MONTH                                      *              
      *  4010-COUNT-DAYS                                         *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00200                                                 
           END-EXEC.                                                            
                                                                        
P00496************************************************************              
P00496*  6000-GET-EVENT-DESC                                     *              
P00496************************************************************              
P00496                                                                  
P00496 COPY CPD00098.                                                           
P00496                                                                  
      ************************************************************              
      *  6010-REDUCE-EMBEDDED-SPACES                             *              
      ************************************************************              
                                                                        
       COPY CPD00004.                                                           
                                                                        
      ************************************************************              
      *  6500-GET-REV-DIST-DESC                                  *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00500                                                 
           END-EXEC.                                                            
                                                                        
                                                                        
      ************************************************************              
      *  8895-INSERT-WORK-QUEUE                                  *              
      ************************************************************              
      *                                                                 33439100
A04860*                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860                                                                  
A04860     MOVE PROGRAM-NAME            TO WS-77-CREATED-BY.            
A04860                                                                  
A04860     MOVE SPACES TO ABEND-FUNCTION.                               
A04860                                                                  
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
                                                                        
      ************************************************************              
      *  9700-PROCESS-ABEND                                      *              
      ************************************************************              
                                                                        
       9700-PROCESS-ABEND.                                              
           DISPLAY ' 8895-INSERT-WORK-QUEUE '.                          
           DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'.              
A04860     DISPLAY ' ** ERROR ON INSERT CSS_WQ_ITEMS '.                 
           DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE.            
A04860     DISPLAY ' ** ACCOUNT NO = ' WS-77-ACCOUNT-NO.                
           MOVE 12 TO RETURN-CODE.                                      
           PERFORM 9900-SQL-ERROR THRU 9900-SQL-EXIT.                   
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR.                                                  
           MOVE RETURN-CODE TO WS-STORE-RETURN-CODE                     
                                                                        
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
           END-IF.                                                      
                                                                        
           MOVE WS-DATABASE-EXCEPTION                                   
             TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)           
                                                                        
           COMPUTE WS-START-POS                                         
             = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1                 
           MOVE WS-SQL-ERROR-TXT-WQ                                     
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)   
           ADD WS-SQL-ERROR-TXT-LEN-WQ                                  
             TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                   
ACT071     MOVE WS-PGRMNAME                                             
ACT071       TO WS-CREATED-BY-WF (WS-BILL-WQ-INDX).                     
                                                                        
           IF RETURN-CODE = 0                                           
               MOVE WS-STORE-RETURN-CODE TO RETURN-CODE
           END-IF.                
                                                                        
           PERFORM 9999-BAIL-OUT  THRU 9999-EXIT.                       
       9900-SQL-EXIT.                                                   
           EXIT.                                                        
                                                                        
       9910-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
ACT071        MOVE WS-PGRMNAME                                          
ACT071          TO WS-CREATED-BY-WF (WS-BILL-WQ-INDX)                   
           END-IF.                                                      
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       9999-BAIL-OUT.                                                   
                                                                        
           MOVE RETURN-CODE TO WS-SCSCA-RETURN-CODE.                    
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
