       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA159.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                   COMPANY NAME: SCE&G                       **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      **  THIS PROGRAM IS A SUB-ROUTINE CALLED FROM THE BILL PRINT   **         
      **  EXTRACT DRIVER.  IT SETS FLAGS TO BE USED AS RULES FOR THE **         
      **  REMOTE COLLABORATION MESSAGE GENERATION TOOL.              **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    09/12    SV        Rewrite.                               **         
A04283*    11/12    DB41297   Changes for December inserts           **         
A04474*    12/10    SV        Changes for SCEG January inserts       **         
A04474*    01/13    DB41297   Changes for February inserts           **         
A04255*    03/27    DB41297   Changes for April inserts              **         
A04475*    03/27    DB41297   Changes for May   inserts              **         
A04475*    08/02    DB41297   Changes for Aug   inserts              **         
A04478*    08/26    DB41297   Changes for Sep   inserts              **         
A04476*    12/06    SV95326   COMMENT SERVICE CARE INSERT PARA(4110) **         
A04474*    01/13    SV95326   MAP CODES DATA PRESENT VALUES .        **         
A04895*    05/19    DB41297   ADD VALUES TO GRILL CAMPAIGN AND       **         
ACT006*                       DELETE OLD REDUNDANT CODE.             **         
A04895*    07/19    DB41297   CHECK FOR 0% FINANCING CUSTOMERS.      **         
ACT008*                                                              **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
      *****************************************************************         
      **    WORKING STORAGE SECTION                                   *         
      *****************************************************************         
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA159'.
MSQ017     COPY MFASQLM.
       01  WS-START                            PIC X(40)                
           VALUE 'WORKING STORAGE FOR SCSCA159 STARTS HERE'.            
       01  WS-MISC.                                                     
           05  WS-REV-MONTH-QTR                PIC 9(2).                
               88  JAN-APR-JUL-OCT             VALUE 1 4 7 10.          
           05  WS-CODES-DATA-PRESENT.                                   
               10  FILLER                      PIC X(2).                
3              10  WS-CODE-BUDGET              PIC X.                   
               10  FILLER                      PIC X(01).               
5              10  WS-CODE-DFA-ACCT            PIC X(01).               
               10  FILLER                      PIC X(08).               
14             10  WS-CODE-BANK-EFT            PIC X(01).               
15             10  WS-CODE-PRP                 PIC X.                   
                   88 PREPAY                   VALUE 'A'.               
               10  FILLER                      PIC X(6).                
22             10  WS-CODE-STA-ACCT            PIC X.                   
               10  FILLER                      PIC X(1).                
24             10  WS-CODE-MEDICAL             PIC X.                   
               10  FILLER                      PIC X(1).                
26             10  WS-CODE-DPP-ACCT            PIC X.                   
               10  FILLER                      PIC X(2).                
29             10  WS-CODE-PENDING-DNP         PIC X.                   
               10  FILLER                      PIC X(03).               
           05  WS-BILL-MSG-ID              PIC 9(5) VALUE ZERO.         
           05  WS-MSG-SUB                  PIC 9(2) VALUE 0.            
           05  WS-INS-SUB                  PIC 9(2) VALUE 0.            
           05  WS-DONOT-PROCESS-FL         PIC X VALUE 'N'.             
           05  WS-GAS-FUEL-STATION-SW      PIC X(1) VALUE 'N'.          
A04283     05  WS-FRANCHISE-FEE-SW         PIC X(1) VALUE 'N'.          
           05  WS-ACCT-CURR-REV-MO         PIC 9(6).                    
           05  WS-REVENUE-MONTH            PIC 9(6).                    
           05  FILLER REDEFINES WS-REVENUE-MONTH.                       
               10  WS-REVENUE-CC            PIC 9(2).                   
               10  WS-REVENUE-YY            PIC 9(2).                   
               10  WS-REVENUE-MM            PIC 9(2).                   
           05  FILLER REDEFINES WS-REVENUE-MONTH.                       
               10  WS-REV-CCYY             PIC 9(4).                    
               10  WS-REV-MM               PIC 9(2).                    
COB305     05 WS-CURR-REV-MO        PIC S9(6)V USAGE COMP-3 VALUE 0.     
COB305     05 WS-HOLD-REVENUE-MONTH        PIC S9(06)V COMP-3 VALUE 0.          
           05  WS-BILL-CCYYMM-CYCLE        PIC X(8).                    
           05  WS-BILL-CCYYMM              PIC X(6).                    
           05  WS-BILL-CCYYMM-CYCLE-ST.                                 
               10  WS-REV-MO-ST            PIC 9(06).                   
               10  WS-BILL-CYCLE-ST        PIC 9(02).                   
           05  WS-BILL-CCYYMM-CYCLE-END.                                
               10  WS-REV-MO-END           PIC 9(06).                   
               10  WS-BILL-CYCLE-END       PIC 9(02).                   
           05  WS-BUDGET-OFFER-DATE.                                    
               10  WS-BUDGET-OFFER-CCYY    PIC 9(4).                    
               10  WS-BUDGET-OFFER-MM      PIC 9(2).                    
COB305     05 WS-HOLD-BI-MSG        PIC S9(5) COMP-3 VALUE 0.            
           05  WS-HOLD-MKT-TIER-RANKING    PIC S9(4).                   
               88  TIER-1-1A               VALUE  7  10.                
               88  TIER-OTHR               VALUE  20 30 40 50.          
           05  WS-START-POS                PIC S9(4) COMP.              
           05  WS-UC-IDX                   PIC 999 VALUE 0.             
           05  WS-HOLD-BUDGET-OFFER-DATE.                               
               10  WS-HOLD-BUDGET-OFFER-YR PIC 9(4).                    
               10  FILLER                  PIC X.                       
               10  WS-HOLD-BUDGET-OFFER-MM PIC 9(2).                    
               10  FILLER                  PIC X(3).                    
           05  WS-EPP-OFFER-DATE.                                       
               10  WS-EPP-OFFER-CCYY       PIC 9(4).                    
               10  WS-EPP-OFFER-MM         PIC 9(2).                    
           05  WS-EPP-OFFER-DATE-NUM REDEFINES WS-EPP-OFFER-DATE        
                                           PIC 9(6).                    
           05  WS-LOCAL-OFFICE             PIC X(3).                    
A04474         88 COLUMBIA-RESIDENTIAL     VALUE '002' '005' '008'.     
               88 COLUMBIA-AREA            VALUE '002' '003' '004'      
                                           '005' '006' '008' '083'.     
A04474         88 CHAS-WINE-FOOD           VALUE '002' '005' '008'      
A04474            '070' '071' '073' '074' '075' '076' '080' '086' '087' 
A04474            '088' '089' '090' '091' '092' '094' '095' '060' '065'.
ACT006         88 GRILL-CAMPAIGN          VALUE '210' '211' '220' '230' 
ACT006            '240' '241' '243' '245' '246' '247' '251' '270' '271' 
ACT006            '272' '290' '291' '292' '293' '276'.                  
A04475         88 PRODUCT-INSERT           VALUE '210' '211' '220'      
A04475             '230' '240' '241' '243' '245' '246' '247' '251' '270'
A04475             '271' '272' '290' '291' '292' '293' '276'.           
A04475         88 RALEIGH-INSERT     VALUE                              
A04475            '200' '205'.                                          
A04475         88 KANNAPOLIS-INSERT  VALUE                              
A04475            '250' '252'.                                          
A04475         88 SHOWROOM-INSERT    VALUE                              
A04475            '200' '205' '220' '230'.                              
A04475         88 REPAIR-PROGRAM     VALUE                              
A04475            '009' '011' '061' '065' '071' '075' '084' '085' '086' 
A04475            '087' '088' '089' '094'.                              
           05  WS-HOLD-TIER-ACCT-TYPE      PIC X(1).                    
               88  SMALL-COMM              VALUE 'S'.                   
               88  CONTR-RES               VALUE 'R'.                   
               88  CONTR-COMM              VALUE 'L'.                   
           05  WS-ACCT-ON-VAR-RATE         PIC X(01) VALUE 'N'.         
           05  WS-CSC-RATE-PLAN            PIC X(3) VALUE SPACES.       
               88  CSC-404-RATE               VALUE '404'.              
               88  CSC-360-RATE               VALUE '360'.              
               88  CSC-CORE-RATE              VALUE                     
                   '310' '340' '510' '540' '570'.                       
               88  CSC-INCREASE               VALUE                     
                   '243' '258' '259' '260' '262' '263' '264' '265' '266'
                   '267' '268' '269' '270' '271' '272' '273' '482' '486'
                   '310' '340' '360' '404' '450' '461' '463' '464' '478'
                   '479' '480' '483' '484' '485' '487' '488' '489' '490'
                   '493' '510' '540' '570' '900' '901' '902' '903'.     
A04476         88  CSC-ARBITRATION            VALUE                     
A04476             '450' '461' '463' '464' '465' '471' '480' '481' '482'
A04476             '483' '484' '486' '487' '488' '489' '490' '495' '900'
A04476             '901' '902'.                                         
           05  WS-COMP-RATE-PLAN           PIC X(3) VALUE SPACES.       
           05  WS-HOLD-RATE-PLAN           PIC X(3) VALUE SPACES.       
               88  EDI-MSG-RATES                     VALUE              
                   '125' '126' '127' '145' '150' '160' '165' '175'      
                   '225' '227' '180' '140'.                             
               88  ONLINE-MSG-RATES                  VALUE              
                   '125' '126' '127' '225' '227'.                       
               88  ADD-OR-CHANGE-EQUIP-RATE          VALUE              
                   '125' '126' '225' '127' '145' '150' '160'            
                   '175' '180'.                                         
               88  RATES-101-102                     VALUE              
                   '101' '102'.                                         
               88  INTERRUPT-RATES                   VALUE              
                   '150' '160' '165' '180'.                             
               88  CUT-COMM-RATES                    VALUE              
                   '125' '127' '225' '227'.                             
               88  CUT-INDUSTRIAL                    VALUE              
                   '126' '135' '145' '150' '160' '165' '175' '180'.     
               88  COMMERCIAL-BILL-RATES             VALUE              
                   '125' '126' '127' '145' '150' '160' '165' '175'      
                   '180' '225' '227'.                                   
               88  PNC-CUT-RATES                     VALUE              
                   '101' '102' '115' '126' '135' '145' '150'            
                   '175' '180' '125' '225' '127' '227'.                 
A04255     05  WS-SENIOR-575-CSC           PIC X(1) VALUE SPACES.       
A04255         88  SENIOR-575-CSC                   VALUE 'Y'.          
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  FILLER                  PIC S9(4) COMP VALUE +121.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  WS-MISC-MSG-LEN         PIC S9(4) COMP VALUE +250.   
               10  WS-MISC-MSG-TEXT        PIC X(60).                   
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER                  PIC S9(04) COMP VALUE +121.  
               10  FILLER                  PIC  X(01) VALUE 'N'.        
               10  FILLER                  PIC  X(01) VALUE '4'.        
               10  FILLER                  PIC S9(04) COMP VALUE +29.   
               10  FILLER                  PIC  X(30) VALUE             
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-PROGRAM-FL               PIC X VALUE ' '.             
           05  SUB1                        PIC 999 VALUE 0.             
           05  SUB2                        PIC 999 VALUE 0.             
           05  SUB3                        PIC 999 VALUE 0.             
           05  SUB4                        PIC 999 VALUE 0.             
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBSBLMSG                                                 
           END-EXEC.                                                            
      *   SUPPLEMENTAL WQ TEXT                                                  
       COPY CWS0070B.                                                           
                                                                        
      *   ABEND SWITCH                                                          
       COPY CWS00303.                                                           
                                                                        
       COPY CWS09900.                                                           
                                                                        
           EXEC SQL                                                     
               DECLARE SPCL_BILL_MSG CURSOR FOR                         
                   SELECT U1.BILL_MSG_ID                                
                         ,U1.MSG_TYPE_CD                                
                         ,U1.REVENUE_MO_ST                              
                         ,U1.REVENUE_MO_END                             
                         ,U1.BILL_CYCLE_ST                              
                         ,U1.BILL_CYCLE_END                             
                     FROM CSS_SPCL_BILL_MSG U1                          
                    WHERE U1.ACCOUNT_NO = :U1-ACCOUNT-NO                
                      AND U1.COMPANY_NO = :U1-COMPANY-NO                
                      AND (U1.REVENUE_MO_ST <= :WS-CURR-REV-MO          
                      AND U1.REVENUE_MO_END >= :WS-CURR-REV-MO)         
           END-EXEC.                                                    
                                                                        
                                                                        
       01  WS-END                              PIC X(40)                
           VALUE 'WORKING STORAGE FOR SCSCA159 ENDS HERE  '.            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       COPY CWS1000A.                                                           
       COPY CWS1000B.                                                           
       COPY CWS10009.                                                           
       COPY CWS0024B.                                                           
       COPY CWS10001.                                                           
       01  WS-SCSCA-RETURN-CODE            PIC S9(4) COMP.              
       01  WS-WQ-CREATED-SW                PIC X(01).                   
       01  WS-INITIAL-FLAG                 PIC X(01).                   
           88  CANCEL-REBILL-INITIAL                  VALUE 'Y'.        
           88  INITIAL-BILL                           VALUE 'I'.        
       COPY CWS00195.                                                           
                                                                        
       PROCEDURE DIVISION USING WS-PREMISE-PR                           
                                WS-ACCOUNT-AT                           
                                WS-BILLING-BI                           
                                WS-BILLING-BG                           
                                WS-CONTRACT-CT                          
                                WS-AR-CNTRL-AC                          
                                WS-BUDGET-PLAN-BU                       
                                WS-PROJECT-SHARE-PJ                     
                                WS-MISC-BILL-INFO                       
                                WS-NAME-ADDRESS                         
                                WS-BANK-EFT-BE                          
                                LS-PCSCA100-COMM-AREA                   
                                WS-SCSCA-RETURN-CODE                    
                                WS-WQ-CREATED-SW                        
                                WS-BILLING-WQ-ITEMS-WF                  
                                WS-UTILITY-TABLE-UT                     
                                WS-CUST-STATS-CE                        
                                WS-UNMTRD-CNSMPTN-UC                    
                                WS-ADDR-FREEFORM-DZ                     
                                WS-ADDR-FORMATTED-DY                    
                                WS-CWS1000B-MAX-TBL-LIMITS              
                                WS-FIXED-FCTR-HIST-FH                   
                                WS-BILL-DET-BT                          
                                WS-CA195-GRP2-FIELDS                    
                                WS-ACCT-MKT-TIER-DD                     
                                WS-CNSMPTN-HIST-CX                      
                                WS-CREDIT-PROFILE-CZ                    
                                WS-ACCT-RTPK-AGR-DF                     
                                WS-BI-FIXED-FCTR-FF                     
                                WS-INITIAL-FLAG                         
                                WS-EXTRM-RCB-REC.                       
                                                                        
      ************************************************************              
      *  GET BILL DATE AND CYCLE. PROCESS ALL BG, AC, CT AND UC  *              
      *  RECORDS SETTING WORKING STORAGE ACCOUNT FLAGS, BASED ON *              
      *  THE DATA.  DETERMINE IF THE ACCOUNT HAS ANY ARREARS.    *              
      ************************************************************              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           IF  WS-MST-SUB-ACCT-IND-AT = 'S'                             
           OR WS-CODE-ACCT-STAT-AT = 'B'                                
              EXIT PROGRAM                                              
           END-IF.                                                      
                                                                        
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT.            
           PERFORM 1000-POPULATE-FLAGS       THRU 1000-EXIT.            
           PERFORM 1100-SPCL-BILL-MSGS       THRU 1100-EXIT.            
                                                                        
           IF SEB-DATABASE                                              
              IF WS-REGULATED-CD-AT = '02'                              
                  PERFORM 3000-SBR-SPECIFIC-FLAGS   THRU 3000-EXIT      
                  PERFORM 4000-SBR-INSERT-MSGS      THRU 4000-EXIT      
              ELSE                                                      
      **    PERMANENT - DO NOT REMOVE!    *                                     
      **   IF SERVICECARE DO NOT PROCESS  *                                     
      *************************************                                     
                  IF WS-LOCAL-OFFICE-AT  = ('301' OR '302' OR '303')    
A04476*              PERFORM 4110-NEW-INSERTS THRU 4110-EXIT                    
                     EXIT PROGRAM                                       
                  ELSE                                                  
                     PERFORM 3100-SEB-SPECIFIC-FLAGS   THRU 3100-EXIT   
                     PERFORM 4100-SEB-INSERT-MSGS      THRU 4100-EXIT   
                  END-IF                                                
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF CSR-DATABASE                                              
              IF WS-COMPANY-NO-AT = '26'                                
                 PERFORM 3200-PSNC-SPECIFIC-FLAGS  THRU 3200-EXIT       
                 PERFORM 4200-PSNC-INSERT-MSGS     THRU 4200-EXIT       
              ELSE                                                      
                 PERFORM 3300-SCEG-SPECIFIC-FLAGS  THRU 3300-EXIT       
                 PERFORM 4300-SCEG-INSERT-MSGS     THRU 4300-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************* *           
      *  INSERT-MARK(1)  TOP OF PAGE                                *           
      *  INSERT-MARK(2)  1 = SAME ENVELOPE; 0 = NEW ENVELOPE        *           
      *  INSERT-MARK(3)  INSERT POCKET 1                            *           
      *  INSERT-MARK(4)  INSERT POCKET 2                            *           
      *  INSERT-MARK(5)  INSERT POCKET 3                            *           
      *  INSERT-MARK(6)  INSERT POCKET 4                            *           
      *  INSERT-MARK(7)  INSERT POCKET 5                            *           
      *  INSERT-MARK(8)  ZIPCODE CHANGE, WILL BE SET BY MAILSTREAM  *           
      ***************************************************************           
       0100-INITIALIZE.                                                 
           INITIALIZE WS-EXTRM-RCB-REC                                  
                      WS-HOLD-REVENUE-MONTH                             
                      WS-CSC-RATE-PLAN                                  
A04474                WS-SENIOR-575-CSC                                 
                      WS-HOLD-RATE-PLAN.                                
                                                                        
           MOVE 'N'                    TO WS-WQ-CREATED-SW.             
           MOVE ALL 'N'                TO WS-EXTRM-RCB-FLAGS.           
           MOVE ZEROS                  TO WS-REV-MO-ST                  
                                          WS-BILL-CYCLE-ST              
                                          WS-REV-MO-END                 
                                          WS-BILL-CYCLE-END.            
                                                                        
      *INITIALIZE THE INSERT MARKS FROM  3 TO 7.                                
                                                                        
           MOVE 3 TO WS-INS-SUB.                                        
           PERFORM UNTIL WS-INS-SUB > 7                                 
               MOVE '0' TO WS-INSERT-MARK (WS-INS-SUB)                  
               ADD 1 TO WS-INS-SUB                                      
           END-PERFORM.                                                 
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-POPULATE-FLAGS.                                             
                                                                        
           MOVE WS-REV-MTH-LST-NRML-AT TO WS-CURR-REV-MO                
                                          WS-REVENUE-MONTH              
                                          WS-ACCT-CURR-REV-MO           
                                          WS-EXTRM-RCB-REV-MONTH.       
           MOVE WS-REVENUE-MONTH       TO WS-BILL-CCYYMM-CYCLE(1:6)     
                                          WS-BILL-CCYYMM.               
           MOVE WS-BILL-CYCLE-AT       TO WS-BILL-CCYYMM-CYCLE(7:2).    
           MOVE WS-REV-MM              TO WS-REV-MONTH-QTR.             
           MOVE WS-BILL-CYCLE-AT       TO WS-EXTRM-RCB-BILL-CYCLE.      
           MOVE WS-LOCAL-OFFICE-AT     TO WS-LOCAL-OFFICE               
                                          WS-EXTRM-RCB-LOCAL-OFFICE.    
           MOVE WS-REV-DISTRICT-CD-PR  TO WS-EXTRM-RCB-DISTRICT.        
           MOVE WS-COUNTY-PR           TO WS-EXTRM-RCB-COUNTY.          
           MOVE SPACES                 TO WS-CODES-DATA-PRESENT.        
           MOVE WS-CODES-DATA-PRESENT-AT TO WS-CODES-DATA-PRESENT.      
           IF WS-CODE-BUDGET  = 'A'                                     
              MOVE 'Y'                 TO WS-EXTRM-RCB-BUDGET-FL        
           END-IF.                                                      
           IF WS-CODE-PENDING-DNP = 'A'                                 
              MOVE WS-CODE-PENDING-DNP TO WS-EXTRM-RCB-PENDING-DNP-FL   
           END-IF.                                                      
           MOVE WS-EPP-OFFER-DATE-AT    TO WS-HOLD-BUDGET-OFFER-DATE.   
           MOVE WS-HOLD-BUDGET-OFFER-YR TO WS-BUDGET-OFFER-CCYY         
                                           WS-EPP-OFFER-CCYY.           
           MOVE WS-HOLD-BUDGET-OFFER-MM TO WS-BUDGET-OFFER-MM           
                                           WS-EPP-OFFER-MM.             
                                                                        
           IF (WS-EDI-DEST-ID > SPACES                                  
           AND WS-EDI-DEST-ID NOT = 'CHECKFREE')                        
              MOVE 'Y'                 TO WS-EXTRM-RCB-EDI-FL           
           END-IF.                                                      
                                                                        
           EVALUATE WS-ACCOUNT-TYPE-CODE-AT                             
             WHEN 'R'                                                   
                MOVE 'Y'               TO WS-EXTRM-RCB-RESIDENTIAL-FL   
             WHEN 'C'                                                   
                MOVE 'Y'               TO WS-EXTRM-RCB-COMMERCIAL-FL    
             WHEN 'I'                                                   
                MOVE 'Y'               TO WS-EXTRM-RCB-INDUSTRIAL-FL    
             WHEN 'M'                                                   
                MOVE 'Y'               TO WS-EXTRM-RCB-PUB-ST-LIGHT     
             WHEN 'W'                                                   
                MOVE 'Y'               TO WS-EXTRM-RCB-WHOLESALE-FL     
             WHEN 'N'                                                   
                MOVE 'Y'               TO WS-EXTRM-RCB-NONUTILITY-FL    
                MOVE WS-REV-MTH-LST-NRML-AT TO WS-HOLD-REVENUE-MONTH    
             WHEN 'B'                                                   
                MOVE 'Y'               TO WS-EXTRM-RCB-CONSLD-MASTER    
                MOVE WS-REV-MTH-LST-NRML-AT TO WS-HOLD-REVENUE-MONTH    
             END-EVALUATE.                                              
                                                                        
           PERFORM 2000-SEARCH-BG-RECS       THRU 2000-EXIT.            
           PERFORM 2100-SEARCH-AC-RECS       THRU 2100-EXIT.            
           PERFORM 2200-SEARCH-CT-RECS       THRU 2200-EXIT.            
           PERFORM 2300-SEARCH-UC-RECS       THRU 2300-EXIT.            
                                                                        
           IF WS-EBILL-REGISTER-IND-CE = 'Y'                            
               MOVE 'Y'                TO WS-EXTRM-RCB-EBILL-FL         
           END-IF.                                                      
                                                                        
           IF WS-ACCOUNT-NO-BE > ZEROES                                 
           AND RCB-EBILL                                                
              EVALUATE WS-STATUS-CODE-BE                                
                  WHEN 'A'                                              
                    MOVE 'Y'           TO WS-EXTRM-RCB-EDRAFT-FL        
                  WHEN 'M'                                              
                    MOVE 'Y'           TO WS-EXTRM-RCB-EPAY-FL          
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
           IF WS-NO-BILL-COPIES-AT = ZERO                               
              MOVE 'Y'                 TO WS-EXTRM-RCB-PAPERLESS-FL     
           END-IF.                                                      
                                                                        
           IF WS-ACCOUNT-NO-BE > ZEROES                                 
           AND WS-STATUS-CODE-BE = 'A'                                  
              MOVE 'Y'                 TO WS-EXTRM-RCB-BANK-DRAFT       
           END-IF.                                                      
A04283                                                                  
A04283     EVALUATE WS-COMPANY-NO-AT                                    
A04283     WHEN '26'                                                    
A04283        MOVE 'PNC'       TO WS-EXTRM-RCB-COMPANY                  
A04283     WHEN '01'                                                    
A04283        IF SEB-DATABASE AND WS-REGULATED-CD-AT > '  '             
A04283           MOVE 'SBR'       TO WS-EXTRM-RCB-COMPANY               
A04283        END-IF                                                    
A04283        IF SEB-DATABASE AND WS-REGULATED-CD-AT = '  '             
A04283           IF WS-LOCAL-OFFICE-AT  = ('301' OR '302' OR '303')     
A04283              MOVE 'SVC'       TO WS-EXTRM-RCB-COMPANY            
A04283           ELSE                                                   
A04283              MOVE 'SEB'       TO WS-EXTRM-RCB-COMPANY            
A04283           END-IF                                                 
A04283        END-IF                                                    
A04283        IF CSR-DATABASE                                           
A04283           MOVE 'CSR'       TO WS-EXTRM-RCB-COMPANY               
A04283        END-IF                                                    
A04283     END-EVALUATE.                                                
                                                                        
ACT008     IF WS-HOLD-REVENUE-MONTH = 201609     AND                    
ACT008        CSR-DATABASE                       AND                    
ACT008        WS-BILL-CYCLE-AT            = '01' AND                    
ACT008        WS-EXTRM-RCB-SERVICECARE-FL = 'N'  AND                    
ACT008        WS-EXTRM-RCB-FIN-CUST-FL    = 'N'                         
ACT008          PERFORM 2250-FINANCE-CUST THRU 2250-EXIT                
ACT008     END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * THIS ROUTINE IS USED TO SELECT SPECIAL BILL MESSAGES OR    *            
      * SPECIAL INSERT MARK IF THERE IS ANY AVAILABLE FROM TABLE   *            
      * CSS_SPCL_BILL_MSG.                                         *            
      **************************************************************            
       1100-SPCL-BILL-MSGS.                                             
                                                                        
           MOVE WS-ACCOUNT-NO-AT             TO U1-ACCOUNT-NO.          
           MOVE WS-COMPANY-NO-AT             TO U1-COMPANY-NO.          
           PERFORM 7000-OPEN-SPCL-BILL-MSG       THRU 7000-EXIT.        
           PERFORM 7100-FETCH-SPCL-BILL-MSG      THRU 7100-EXIT.        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
             MOVE U1-REVENUE-MO-ST     TO WS-REV-MO-ST                  
             MOVE U1-BILL-CYCLE-ST     TO WS-BILL-CYCLE-ST              
             MOVE U1-REVENUE-MO-END    TO WS-REV-MO-END                 
             MOVE U1-BILL-CYCLE-END    TO WS-BILL-CYCLE-END             
             IF (WS-BILL-CCYYMM-CYCLE >= WS-BILL-CCYYMM-CYCLE-ST) AND   
                (WS-BILL-CCYYMM-CYCLE <= WS-BILL-CCYYMM-CYCLE-END)      
                 PERFORM 1200-PROCESS-DETAILS        THRU 1200-EXIT     
             END-IF                                                     
             PERFORM 7100-FETCH-SPCL-BILL-MSG    THRU 7100-EXIT         
           END-PERFORM.                                                 
           PERFORM 7200-CLOSE-SPCL-BILL-MSG      THRU 7200-EXIT.        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1200-PROCESS-DETAILS.                                            
                                                                        
           EVALUATE U1-MSG-TYPE-CD                                      
               WHEN 'M'                                                 
                    PERFORM 1210-PROCESS-MESSAGE THRu 1210-EXIT         
               WHEN 'I'                                                 
                    PERFORM 1220-PROCESS-INSERT  THRU 1220-EXIT         
           END-EVALUATE.                                                
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1210-PROCESS-MESSAGE.                                            
                                                                        
           MOVE U1-BILL-MSG-ID               TO WS-HOLD-BI-MSG.         
           PERFORM 5100-ADD-MESSAGE-TO-BIREC THRU 5100-EXIT.            
                                                                        
       1210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * IN THIS ROUTINE WE ARE NOT PROCESSING FOR POCKET 1 AS IT IS *           
      * ALWAYS USED FOR RETURNED ENVELOPE.                          *           
      ***************************************************************           
       1220-PROCESS-INSERT.                                             
                                                                        
           MOVE U1-BILL-MSG-ID                TO WS-BILL-MSG-ID.        
           EVALUATE WS-BILL-MSG-ID (5:1)                                
               WHEN 1                                                   
                    CONTINUE                                            
               WHEN 2                                                   
                    MOVE '1'                  TO WS-INSERT-MARK (4)     
               WHEN 3                                                   
                    MOVE '1'                  TO WS-INSERT-MARK (5)     
               WHEN 4                                                   
                    MOVE '1'                  TO WS-INSERT-MARK (6)     
               WHEN 5                                                   
                    MOVE '1'                  TO WS-INSERT-MARK (7)     
           END-EVALUATE.                                                
                                                                        
       1220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  LOOP THROUGH THE BG RECORDS TO SET:                     *              
      *  - UTILITY TYPE                                          *              
      *  - STATE TAX                                             *              
      *  - RATE GROUP FOR RATES 101 AND 102                      *              
      ************************************************************              
       2000-SEARCH-BG-RECS.                                             
                                                                        
A04283     MOVE 'N' TO WS-FRANCHISE-FEE-SW.                             
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1                  
                   UNTIL WS-BILLING-INDX > WS-BG-MAX-ENTRY              
                      OR WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = ZEROES    
              IF WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'G'           
                 MOVE 'Y'              TO WS-EXTRM-RCB-GAS-FL           
              END-IF                                                    
              IF WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'E'           
                 MOVE 'Y'              TO WS-EXTRM-RCB-ELECTRIC-FL      
              END-IF                                                    
              IF WS-AMT-STATE-TAX-BG (WS-BILLING-INDX) > 0              
                 MOVE 'Y'              TO WS-EXTRM-RCB-TAX-FL           
              END-IF                                                    
              IF WS-BILL-FORMAT-CODE-RT (WS-BILLING-INDX) = '05'        
                 MOVE 'Y'              TO WS-EXTRM-RCB-NON-MUN-LIGHT    
              END-IF                                                    
A04283        IF WS-CODE-BILL-CALC-BG (WS-BILLING-INDX) NOT = 'S' AND   
A04283           WS-AMT-CITY-TAX-BG (WS-BILLING-INDX) > 0               
A04283             MOVE 'Y' TO WS-FRANCHISE-FEE-SW                      
A04283        END-IF                                                    
           END-PERFORM.                                                 
                                                                        
      *    IF CANCEL REBILLED USE REVENUE MONTH ORIGINAL BILL                   
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1                  
                   UNTIL  WS-BILLING-INDX > 30 OR                       
                           WS-ACCOUNT-NO-BG(WS-BILLING-INDX) = ZERO     
             IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) = LOW-VALUES AND 
                WS-CODE-BILL-ITM-TYPE-BG (WS-BILLING-INDX) = 'C' AND    
                WS-CODE-BILL-ITM-IND-BG (WS-BILLING-INDX) = 'A'         
                 MOVE WS-REV-MTH-LST-NRML-AT TO WS-HOLD-REVENUE-MONTH   
                 SET  WS-BILLING-INDX        TO 30                      
             ELSE                                                       
                IF WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX) > ZERO AND 
                   WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX) >          
                                         WS-HOLD-REVENUE-MONTH          
                   MOVE WS-REV-MTH-ORIG-BILL-BG(WS-BILLING-INDX)        
                                            TO  WS-HOLD-REVENUE-MONTH   
                END-IF                                                  
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  LOOP THROUGH THE AC RECORDS TO SET:                     *              
      *  - ARREARS                                               *              
      *  - 30, 60, AND 90 DAY ARREARS                            *              
      ************************************************************              
       2100-SEARCH-AC-RECS.                                             
                                                                        
           PERFORM VARYING WS-AR-DATA-INDX FROM 1 BY 1                  
                   UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY              
                      OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZEROES    
              IF WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX) > 0.00           
                  MOVE 'Y'             TO WS-EXTRM-RCB-30DAY-ARREARS-FL 
              END-IF                                                    
              IF WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX) > 0.00           
                  MOVE 'Y'             TO WS-EXTRM-RCB-60DAY-ARREARS-FL 
              END-IF                                                    
              IF WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX) > 0.00           
                  MOVE 'Y'             TO WS-EXTRM-RCB-90DAY-ARREARS-FL 
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           IF WS-EXTRM-RCB-30DAY-ARREARS-FL = 'Y'                       
           OR WS-EXTRM-RCB-60DAY-ARREARS-FL = 'Y'                       
           OR WS-EXTRM-RCB-90DAY-ARREARS-FL = 'Y'                       
              MOVE 'Y'                 TO WS-EXTRM-RCB-ARREARS-FL       
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  LOOP THROUGH THE CT RECORDS TO SET:                     *              
      *  - FINANCING CUSTOMER                                    *              
      *  - SERVICECARE CUSTOMER                                  *              
      ************************************************************              
       2200-SEARCH-CT-RECS.                                             
                                                                        
           PERFORM VARYING WS-CNT-INDX FROM 1 BY 1                      
                   UNTIL WS-CNT-INDX > WS-CT-MAX-ENTRY                  
                      OR WS-ACCOUNT-NO-CT (WS-CNT-INDX) = ZEROES        
              IF (WS-CNT-STATUS-CD-CT (WS-CNT-INDX) = 'B'               
              AND  WS-INTRST-RATE-CT (WS-CNT-INDX)  > 0 )               
                 MOVE 'Y'              TO WS-EXTRM-RCB-FIN-CUST-FL      
              END-IF                                                    
              IF (WS-CNT-STATUS-CD-CT (WS-CNT-INDX) = 'B'               
              AND WS-CODE-CONTRACT-TYPE-CT (WS-CNT-INDX) = 'F')         
                 MOVE 'Y'              TO WS-EXTRM-RCB-SERVICECARE-FL   
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
A04475                                                                  
A04475************************************************************              
A04475*  TEMPORARY CODE TO SEE IF FINANCIAL CUSTOMER WITH        *              
A04475*  ZERO PERCENT INTEREST RATE                              *              
A04475************************************************************              
A04475 2250-FINANCE-CUST.                                               
A04475                                                                  
A04475     MOVE WS-ACCOUNT-NO-AT TO U1-ACCOUNT-NO.                      
A04475                                                                  
A04475     EXEC SQL                                                     
A04475         SELECT TOP(1) '1'                                               
A04475         INTO  :WS-PROGRAM-FL                                     
A04475         FROM CSS_ACCOUNT A WITH(READUNCOMMITTED)                         
A04475             ,CSS_CONTRACT B WITH(READUNCOMMITTED)                        
A04475             ,CSS_CNT_DETAIL C WITH(READUNCOMMITTED)                      
A04475         WHERE A.ACCOUNT_NO = :U1-ACCOUNT-NO                      
A04475          AND  A.ACCOUNT_NO = B.ACCOUNT_NO                        
A04475          AND  A.ACCOUNT_NO = C.ACCOUNT_NO                        
A04475         AND A.CODE_ACCT_STAT = 'A'                               
A04475         AND B.CNT_ITEM_ID = C.CNT_ITEM_ID                        
A04475         AND B.CNT_STATUS_CD = 'B'                                
A04475         AND B.CODE_CONTRACT_TYPE IN('B','F')                     
A04475         AND C.CHARGE_TYPE_CD     IN('B','F')                     
A04475                                       
A04475     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT '1'                                                       
MFA-TR*        INTO  :WS-PROGRAM-FL                                             
MFA-TR*        FROM CSS_ACCOUNT A                                               
MFA-TR*            ,CSS_CONTRACT B                                              
MFA-TR*            ,CSS_CNT_DETAIL C                                            
MFA-TR*        WHERE A.ACCOUNT_NO = :U1-ACCOUNT-NO                              
MFA-TR*         AND  A.ACCOUNT_NO = B.ACCOUNT_NO                                
MFA-TR*         AND  A.ACCOUNT_NO = C.ACCOUNT_NO                                
MFA-TR*        AND A.CODE_ACCT_STAT = 'A'                                       
MFA-TR*        AND B.CNT_ITEM_ID = C.CNT_ITEM_ID                                
MFA-TR*        AND B.CNT_STATUS_CD = 'B'                                        
MFA-TR*        AND B.CODE_CONTRACT_TYPE IN('B','F')                             
MFA-TR*        AND C.CHARGE_TYPE_CD     IN('B','F')                             
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04475                                                                  
A04475     MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
A04475     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04475       WHEN SUCCESSFUL-CALL                                       
A04475         MOVE 'Y' TO WS-EXTRM-RCB-FIN-CUST-FL                     
A04475         GO TO 2250-EXIT                                          
A04475       WHEN NOT-FOUND                                             
A04475         CONTINUE                                                 
A04475       WHEN OTHER                                                 
A04475         DISPLAY 'SCSCA159:2250'                                  
A04475         MOVE 'U1'             TO WS-DB2-TABLE-ID                 
A04475         MOVE 'SELECT'         TO WS-DB2-FUNCTION                 
A04475         MOVE SQLCODE          TO WS-DB2-RETURN-CODE              
A04475         MOVE '159'            TO WS-DB2-MODULE-ID                
A04475         MOVE '2250'           TO WS-DB2-PARAGRAPH                
A04475         MOVE WS-ACCOUNT-NO-AT TO WS-DB2-KEY-1N                   
A04475         MOVE 12               TO RETURN-CODE                     
A04475         PERFORM 9800-SQL-ERROR       THRU 9800-EXIT              
A04475     END-EVALUATE.                                                
A04475                                                                  
A04475 2250-EXIT.                                                       
A04475     EXIT.                                                        
                                                                        
      ************************************************************              
      *  LOOP THROUGH THE UC RECORDS TO SET:                     *              
      *  - UNMETERED ELECTRIC                                    *              
      *  - UNMETERED GAS                                         *              
      *  - UNMETERED UTILITY                                     *              
      ************************************************************              
       2300-SEARCH-UC-RECS.                                             
                                                                        
           PERFORM VARYING WS-UC-IDX FROM 1 BY 1                        
                   UNTIL WS-UC-IDX > WS-UC-MAX-ENTRY OR                 
                   WS-ACCOUNT-NO-UC (WS-UC-IDX) = ZEROES                
               IF WS-ACCOUNT-NO-AT = WS-ACCOUNT-NO-UC (WS-UC-IDX)       
                   IF WS-CODE-SERVICE-TYPE-UC (WS-UC-IDX) = 'E' AND     
                      WS-CODE-ITEM-STATUS-UC (WS-UC-IDX)  = 'A'         
                        MOVE 'Y'       TO WS-EXTRM-RCB-UNMET-ELE-FL     
                   END-IF                                               
                   IF WS-CODE-SERVICE-TYPE-UC (WS-UC-IDX) = 'G' AND     
                      WS-CODE-ITEM-STATUS-UC (WS-UC-IDX)  = 'A'         
                        MOVE 'Y'       TO WS-EXTRM-RCB-UNMET-GAS-FL     
                   END-IF                                               
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
           IF RCB-UNMETERED-ELECTRIC                                    
           OR RCB-UNMETERED-GAS                                         
              MOVE 'Y'                 TO WS-EXTRM-RCB-UNMETERED-FL     
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * COPY BOOK TO LOAD SCEG INSERTS AND MESSAGES                   *         
      *****************************************************************         
       COPY  CPD0159S.                                                          
      *****************************************************************         
      * COPY BOOK TO LOAD PSNC INSERTS AND MESSAGES                   *         
      *****************************************************************         
       COPY  CPD0159P.                                                          
      *****************************************************************         
      * COPY BOOK TO LOAD SEB  INSERTS AND MESSAGES                   *         
      *****************************************************************         
       COPY  CPD0159D.                                                          
      *****************************************************************         
      * COPY BOOK TO LOAD SBR  INSERTS AND MESSAGES                   *         
      *****************************************************************         
       COPY  CPD0159R.                                                          
                                                                        
       5100-ADD-MESSAGE-TO-BIREC.                                       
      *                                                                         
           MOVE 'N'                      TO WS-DONOT-PROCESS-FL.        
      *                                                                         
           PERFORM VARYING WS-MSG-NO-INDX FROM 1 BY 1 UNTIL             
                   WS-MSG-NO-INDX > 10 OR                               
                   WS-BILL-MESSAGE-NO-CALC (WS-MSG-NO-INDX) <= ZEROS    
              IF WS-BILL-MESSAGE-NO-CALC (WS-MSG-NO-INDX) =             
                 WS-HOLD-BI-MSG                                         
                 IF CSR-DATABASE AND WS-HOLD-BI-MSG = 60206             
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE 'Y'                TO WS-DONOT-PROCESS-FL      
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           IF WS-MSG-NO-INDX < 10 AND WS-DONOT-PROCESS-FL = 'N'         
              AND  WS-HOLD-BI-MSG > ZERO                                
              MOVE WS-HOLD-BI-MSG        TO                             
                   WS-BILL-MESSAGE-NO-CALC (WS-MSG-NO-INDX)             
              INITIALIZE WS-HOLD-BI-MSG                                 
           END-IF.                                                      
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-OPEN-SPCL-BILL-MSG.                                         
                                                                        
           EXEC SQL                                                     
               OPEN SPCL_BILL_MSG                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
               CONTINUE                                                 
             WHEN OTHER                                                 
               DISPLAY 'SCSCA159:7000'                                  
               MOVE 'U1'             TO WS-DB2-TABLE-ID                 
               MOVE 'OPEN  '         TO WS-DB2-FUNCTION                 
               MOVE SQLCODE          TO WS-DB2-RETURN-CODE              
               MOVE '159'            TO WS-DB2-MODULE-ID                
               MOVE '7000'           TO WS-DB2-PARAGRAPH                
               MOVE U1-ACCOUNT-NO    TO WS-DB2-KEY-1N                   
               MOVE U1-REVENUE-MO-ST TO WS-DB2-KEY-2N                   
               MOVE U1-COMPANY-NO    TO WS-DB2-KEY-3N                   
               MOVE 12               TO RETURN-CODE                     
               PERFORM 9800-SQL-ERROR       THRU 9800-EXIT              
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-FETCH-SPCL-BILL-MSG.                                        
                                                                        
           EXEC SQL                                                     
               FETCH SPCL_BILL_MSG                                      
                INTO :U1-BILL-MSG-ID                                    
                    ,:U1-MSG-TYPE-CD                                    
                    ,:U1-REVENUE-MO-ST                                  
                    ,:U1-REVENUE-MO-END                                 
                    ,:U1-BILL-CYCLE-ST                                  
                    ,:U1-BILL-CYCLE-END                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
             WHEN NOT-FOUND                                             
               CONTINUE                                                 
             WHEN OTHER                                                 
               DISPLAY 'SCSCA159:7100'                                  
               MOVE 'U1'             TO WS-DB2-TABLE-ID                 
               MOVE 'FETCH '         TO WS-DB2-FUNCTION                 
               MOVE SQLCODE          TO WS-DB2-RETURN-CODE              
               MOVE '159'            TO WS-DB2-MODULE-ID                
               MOVE '7100'           TO WS-DB2-PARAGRAPH                
               MOVE U1-ACCOUNT-NO    TO WS-DB2-KEY-1N                   
               MOVE U1-REVENUE-MO-ST TO WS-DB2-KEY-2N                   
               MOVE U1-COMPANY-NO    TO WS-DB2-KEY-3N                   
               MOVE 12               TO RETURN-CODE                     
               PERFORM 9800-SQL-ERROR       THRU 9800-EXIT              
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-CLOSE-SPCL-BILL-MSG.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE SPCL_BILL_MSG                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
               CONTINUE                                                 
             WHEN OTHER                                                 
               DISPLAY 'SCSCA159:7200'                                  
               MOVE 'U1'             TO WS-DB2-TABLE-ID                 
               MOVE 'CLOSE '         TO WS-DB2-FUNCTION                 
               MOVE SQLCODE          TO WS-DB2-RETURN-CODE              
               MOVE '159'            TO WS-DB2-MODULE-ID                
               MOVE '7200'           TO WS-DB2-PARAGRAPH                
               MOVE U1-ACCOUNT-NO    TO WS-DB2-KEY-1N                   
               MOVE U1-COMPANY-NO    TO WS-DB2-KEY-3N                   
               MOVE 12               TO RETURN-CODE                     
               PERFORM 9800-SQL-ERROR       THRU 9800-EXIT              
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9800-SQL-ERROR.                                                  
                                                                        
           IF LS-CURR-WQ-ITEM = 50                                      
               DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                
               DISPLAY 'PROCESSING TERMINATED'                          
               MOVE 16 TO RETURN-CODE                                   
           ELSE                                                         
               MOVE 'Y' TO WS-WQ-CREATED-SW                             
               ADD 1 TO LS-CURR-WQ-ITEM                                 
               SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                   
           END-IF.                                                      
           MOVE WS-DATABASE-EXCEPTION                                   
             TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX).          
           COMPUTE WS-START-POS                                         
             = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1.                
           MOVE WS-SQL-ERROR-TXT-WQ                                     
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:).  
           ADD WS-SQL-ERROR-TXT-LEN-WQ                                  
             TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                   
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
                                                                        
       9800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-ABEND.                                                      
           PERFORM 9910-MISC-ERROR THRU 9910-EXIT.                      
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9910-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              MOVE 'Y' TO WS-WQ-CREATED-SW                              
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
                                                                        
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
           END-IF.                                                      
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-BAIL-OUT.                                                   
                                                                        
           MOVE RETURN-CODE TO WS-SCSCA-RETURN-CODE.                    
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
