       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       SCSCA158.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A CALLED FROM PCSCA293 TO OBTAIN 24 MONTHS    *        
      *  BILLING HIST AND DETAILS.                                     *        
      *  THIS PROGRAM IS CLONED FRPM CSR02093                          *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
A4149 *               SV      INITIAL VERSION                          *        
P00821*  01/14/15  HA7A338    CHANGE THE LOGIC IN 2200- PARA TO FETCH  *        
P00821*                       THE BILL DETAILS TILL THE BILL-NO PASSED *        
P00821*                       THROUGH LINKAGE SECTION.                 *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA158'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR SCSCA158 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLACXF                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBGTHST                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLCLDT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBUMCNSM                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCSTPLN                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRTCDEF                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_MKT_XREF_ACCT                                                       
           EXEC SQL                                                             
               INCLUDE TBMRKXR                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_MTRD_ENVRNMT                                                        
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_BILL_WINDOW,   BN                                                   
           EXEC SQL                                                             
             INCLUDE TBBILWDW                                                   
           END-EXEC.                                                            
      *                                                                         
      * CSS_BILL_ADJUSTMNT BP                                                   
           EXEC SQL                                                             
             INCLUDE TBBILADJ                                                   
           END-EXEC.                                                            
      * CSS_PREPAY_HIST PK                                                      
           EXEC SQL                                                             
             INCLUDE TBPREHST                                                   
           END-EXEC.                                                            
      *                                                                         
      * CSS_REV_CLS_RATE   Q8                                                   
           EXEC SQL                                                             
             INCLUDE TBRVCLS                                                    
           END-EXEC.                                                            
      *                                                                         
      * CSS_ACCT_RTPK_AGR, DF                                                   
           EXEC SQL                                                             
               INCLUDE TBACCTRG                                                 
           END-EXEC.                                                            
      *                                                                         
      * CRM_RT_PKG_OPTION, FI                                                   
           EXEC SQL                                                             
               INCLUDE TBRTPKGO                                                 
           END-EXEC.                                                            
      *                                                                         
      * CSS_DELINQUENCY, C8                                                     
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
      * CSS_UTIL_ENVRMT, UT                                                     
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
      *--------< SUPPORTS JOB PARM CALCULATION >                                
           COPY CWS00038.                                                       
                                                                        
           COPY CWS00056.                                                       
                                                                        
           COPY CWS00011.                                                       
                                                                        
       01  WS-ACCUMULATORS.                                             
                                                                        
           05 WS-TOTAL-BG-DOLLARS      PIC S9(09)V99                    
                                                  VALUE 0.              
           05 WS-ACCUM-NO-DAYS         PIC S9(05) VALUE 0    COMP.      
           05 WS-ACCUM-NO-UNITS        PIC S9(09) VALUE 0    COMP-3.    
           05 WS-ACCUM-READ-UNITS      PIC S9(09) VALUE 0    COMP-3.    
           05 WS-ACCUM-UNITS-TP        PIC S9(09) VALUE 0    COMP-3.    
           05 WS-ACCUM-NO-KW           PIC S9(05) VALUE 0    COMP-3.    
           05 WS-ACCUM-NO-KVA          PIC S9(05) VALUE 0    COMP-3.    
           05 WS-AMT-TAXES             PIC S9(09)V99                    
                                                  VALUE 0    COMP-3.    
           05 WS-NO-DAYS               PIC S9(05) VALUE 0    COMP-3.    
           05 WS-ROW-COUNT             PIC S9(05) VALUE 0    COMP-3.    
           05 WS-BG-ROW-COUNT          PIC S9(09) VALUE 0    COMP-3.    
           05 WS-UT-ROW-COUNT          PIC S9(09) VALUE 0    COMP-3.    
           05 WS-CALC-FUT-BILL-HOOK-FL PIC X(01)  VALUE SPACES.         
           05 WS-BI-BILL-NO            PIC S9(09) COMP VALUE 0.         
           05 CTR-COLUMN               PIC S9(09) VALUE 1    COMP.      
           05 CTR-ROWS                 PIC S9(09) VALUE 0    COMP.      
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05 WS-ACTIVE                PIC X(01) VALUE 'A'.             
           05 WS-SUB                   PIC 9(03) VALUE 0.               
           05 WS-Y                     PIC X(01) VALUE 'Y'.             
           05 WS-YES                   PIC X(01) VALUE 'Y'.             
           05 WS-NO                    PIC X(01) VALUE 'N'.             
           05 WS-HEADER-REC-ID         PIC X(01) VALUE 'H'.             
           05 WS-DETAIL-REC-ID         PIC X(01) VALUE 'D'.             
           05 WS-HOLD-REV-MM           PIC S9(06) VALUE +0.             
           05 WS-HOLD-REV-MM-CHAR      PIC X(6).                        
           05 WS-TEMP                  PIC S9(02) VALUE +0.             
           05 WS-TP-HOLD               PIC S9(02) VALUE +0.             
           05 WS-MTR-REF-COMP          PIC S9(4) USAGE COMP VALUE +0.   
           05 WS-REG-ID-COMP           PIC S9(4) USAGE COMP VALUE +0.   
           05 WS-TP-COMP               PIC S9(4) USAGE COMP VALUE +0.   
           05 WS-BUD-AMT-FOUND-FLAG    PIC X(01) VALUE 'N'.             
           05 WS-BILL-ADJ-EXIST        PIC X(01) VALUE 'N'.             
           05 WS-PREPAY-COUNT          PIC S9(04) COMP VALUE 0.         
           05 WS-PREPAY-COUNT-NULL     PIC S9(04) COMP VALUE 0.         
           05 WS-COMMON-DATE           PIC X(10) VALUE SPACES.          
           05 WS-INPUT-REV-MONTH        PIC X(06).                      
           05 WS-ADD-R                  PIC 9(02) VALUE 0.              
           05 WS-MONTHS-TO-ADD          PIC 9(02) VALUE 0.              
           05 WS-START-DATE.                                            
              10 WS-START-YR            PIC X(04).                      
              10 FILLER                 PIC X(01) VALUE '-'.            
              10 WS-START-MT            PIC X(02).                      
              10 FILLER                 PIC X(01) VALUE '-'.            
              10 WS-START-DY            PIC X(02).                      
           05 WS-START-DATE-N.                                          
              10 WS-START-YR-N          PIC S9(4) USAGE COMP.           
              10 WS-START-MT-N          PIC S9(2) USAGE COMP.           
           05 WS-REG-TYPE-CD           PIC X(01) VALUE SPACES.          
           05 WS-BAL-FWD-CD            PIC X(01) VALUE SPACES.          
      *    05 MULTIPLE-ROWS            PIC S9(9) VALUE -811 COMP.               
           05 WS-ELEC-WNA-DLNQ-CD      PIC X(20) VALUE                  
                                   'ELECTRIC-WNA-START  '.              
           05 WS-ELEC-WNA-WORK         PIC 9(06)V9(2).                  
           05 WS-ELEC-WNA-VALUE        PIC 9(06) VALUE 0.               
           05 WS-BILL-DATE.                                             
              10  WS-CCYY              PIC X(04).                       
              10  FILLER               PIC X(01).                       
              10  WS-MM                PIC X(02).                       
              10  FILLER               PIC X(01).                       
              10  WS-DD                PIC X(02).                       
           05 WS-BILL-DATE-CH   REDEFINES   WS-BILL-DATE                
                                       PIC X(10).                       
           05 WS-BILL-DATE-MMDDCCYY.                                    
              10  WS-MM                PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '/'.             
              10  WS-DD                PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '/'.             
              10  WS-CCYY              PIC X(04) VALUE SPACES.          
           05 WS-DATE-READ.                                             
              10  WS-CCYY              PIC X(04).                       
              10  FILLER               PIC X(01).                       
              10  WS-MM                PIC X(02).                       
              10  FILLER               PIC X(01).                       
              10  WS-DD                PIC X(02).                       
           05 WS-DATE-READ-MMDDCCYY.                                    
              10  WS-MM                PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '/'.             
              10  WS-DD                PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '/'.             
              10  WS-CCYY              PIC X(04) VALUE SPACES.          
           05 WS-DATE-READ-COMPARE     PIC X(10) VALUE SPACES.          
           05 WS-PREV-BILL-DATE        PIC X(10) VALUE SPACES.          
           05 WS-PREVBILL-AR-TRNSHIST-SEQ PIC X(26) VALUE SPACES.       
           05 WS-CURRBILL-AR-TRNSHIST-SEQ PIC X(26) VALUE SPACES.       
           05 WS-PARM-BILL-NO          PIC S9(09)                       
                                                 VALUE +0   COMP.       
           05 WS-NULL-IND              PIC S9(04)           COMP.       
           05 WS-NULL-IND-HEADER       PIC S9(04)           COMP.       
           05 WS-NULL-IND-1            PIC S9(04)           COMP.       
           05 WS-NULL-IND-2            PIC S9(04)           COMP.       
           05 WS-NULL-IND-3            PIC S9(04)           COMP.       
           05 WS-NULL-IND-4            PIC S9(04)           COMP.       
           05 WS-NULL-IND-5            PIC S9(04)           COMP.       
           05 WS-NULL-IND-6            PIC S9(04)           COMP.       
           05 WS-ITM-IND-STATUS.                                        
              10  WS-HOLD-CODE-BILL-ITM-IND                             
                                       PIC X(01).                       
              10  WS-HOLD-CODE-ITEM-STATUS                              
                                       PIC X(01).                       
           05 WS-MAX-ROWS              PIC S9(02) VALUE +06 COMP.       
           05 PROGRAM-NAME             PIC X(08)  VALUE 'SCSCA158'.     
           05  WS-SQLSTATE             PIC X(5).                        
           05 WS-PGRMNAME              PIC X(08).                       
           05 WS-CUT-OFF-DATE          PIC X(10).                       
           05 WS-PSNC                  PIC X(2) VALUE '26'.             
           05 WS-CIG                   PIC X(2) VALUE '01'.             
           05  WS-CUTOFF-DATA-BREAKDOWN.                                
               10  WS-SYSINPUT         PIC  X(12).                      
                   88  CUT-OFF-DATE                                     
                     VALUE 'CUT OFF DATE'.                              
               10  FILLER              PIC  X(01).                      
               10  WS-INPUT-CUT-DATE.                                   
                   15  WS-INPUT-CUT-DATE-CC    PIC  X(02).              
                   15  WS-INPUT-CUT-DATE-YY    PIC  X(02).              
                   15    FILLER                PIC  X(01).              
                   15  WS-INPUT-CUT-DATE-MM    PIC  X(02).              
                   15    FILLER                PIC  X(01).              
                   15  WS-INPUT-CUT-DATE-DD    PIC  X(02).              
               10  FILLER                      PIC  X(58).              
           05 WS-TEMP-DATE-CCYYMMDD.                                    
              10  WS-TEMP-CC           PIC X(02) VALUE SPACES.          
              10  WS-TEMP-YY           PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-TEMP-MM           PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-TEMP-DD           PIC X(04) VALUE SPACES.          
           05 WS-PARM-DATA             PIC X(80) VALUE SPACES.          
           05 WS-PARM-DATA-RED   REDEFINES WS-PARM-DATA.                
              10 WS-PARM-DESC          PIC X(23).                       
              10 WS-PARM-CUT-REV       PIC X(06).                       
              10 FILLER                PIC X(51).                       
           05 WS-EMC-REV-MM            PIC X(06) VALUE SPACES.          
           05 WS-COBB-SNAPSHOAL        PIC X(01) VALUE SPACES.          
           05 WS-ELEC-INTRUPT-ACCT     PIC X(01) VALUE SPACES.          
           05 WS-ENABLE-BILL-CALC      PIC X(01) VALUE SPACES.          
      *                                                                         
       01  WS-SERV-ADDR.                                                
      *                                                                         
           05 WS-ADDR-PREFIX-1         PIC X(03) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 WS-ADDR-PREFIX-2         PIC X(02) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
      *    05 WS-HOUSE-NO              PIC X(05) VALUE SPACES.                  
           05 WS-HOUSE-NO              PIC X(15) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
      *    05 WS-STREET-NAME           PIC X(16) VALUE SPACES.                  
           05 WS-STREET-NAME           PIC X(30) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 WS-STREET-LOCATION-1     PIC X(04) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
      *    05 WS-STREET-LOCATION-2     PIC X(04) VALUE SPACES.                  
           05 WS-STREET-LOCATION-2     PIC X(11) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 WS-STREET-SUFFIX         PIC X(04) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 WS-ZIP-CODE              PIC X(05) VALUE SPACES.          
      *                                                                         
       01  SWITCHES.                                                    
      *                                                                         
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  END-OF-BG-SW            PIC X(01) VALUE 'N'.             
               88 NO-MORE-DETAIL-RECS            VALUE 'Y'.             
           05  WS-FIRST-TIME-SW        PIC X(01) VALUE 'N'.             
               88 FIRST-TIME-IN                  VALUE 'Y'.             
           05  END-OF-BI-SW            PIC X(01) VALUE 'N'.             
               88 NO-MORE-HEADER-RECS            VALUE 'Y'.             
           05  BUDGET-RECORD-FOUND-SW  PIC X(01) VALUE 'N'.             
               88 BUDGET-RECORD-FOUND            VALUE 'Y'.             
           05  MST-SUB-ACCT-IND-SW     PIC X(01) VALUE ' '.             
               88 MASTER-ACCOUNT                 VALUE 'M'.             
           05  BUDGER-RECORD-FOUND-SW  PIC X(01) VALUE 'N'.             
               88 BUDGET-RECORD-FOUND            VALUE 'Y'.             
           05  WS-MORE-SUBS-SW         PIC X(01) VALUE 'Y'.             
               88 NO-MORE-SUBS                   VALUE 'N'.             
           05  WS-MORE-BGS-SW          PIC X(01) VALUE 'Y'.             
               88 NO-MORE-BGS                    VALUE 'N'.             
           05  WS-INDUST-GAS-CUST      PIC X(01) VALUE 'N'.             
               88 INDUST-GAS-CUST                VALUE 'Y'.             
           05  WS-DATABASE             PIC 9(01) VALUE ZERO.            
               88  CSR-DATABASE                  VALUE 1.               
               88  SEB-DATABASE                  VALUE 2.               
                                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
      *                                                                         
           05  WS-RECORD-ID            PIC X(01)     VALUE SPACES.      
           05  WS-REVENUE-MONTH        PIC X(02)     VALUE SPACES.      
           05  WS-DATE-BILLED          PIC X(10)     VALUE SPACES.      
           05  WS-CODE-BILL-TYPE       PIC X(01)     VALUE SPACES.      
           05  WS-BILL-AMOUNT          PIC S9(09)V99 VALUE 0 COMP-3.    
           05  WS-PAYMENTS             PIC S9(09)V99 VALUE 0 COMP-3.    
           05  WS-TOT-OTHER-CHARGES    PIC S9(09)V99 VALUE 0 COMP-3.    
           05  WS-TOTAL-ARREARS        PIC S9(09)V99 VALUE 0 COMP-3.    
           05  WS-BILL-NO              PIC S9(09)    VALUE 0 COMP.      
           05  WS-CODE-BILL-STATUS     PIC X(01)     VALUE SPACES.      
           05  WS-BILL-DATE-READ       PIC X(10)     VALUE SPACES.      
           05  WS-CODE-UTIL-TYPE       PIC X(01)     VALUE SPACES.      
           05  WS-IC-NO                PIC S9(04)    VALUE 0 COMP.      
           05  WS-ADDL-HIST            PIC X(1)      VALUE SPACES.      
           05  WS-RATE-PLAN-DESC       PIC X(50)     VALUE SPACES.      
           05  WS-NO-UNITS             PIC S9(09)    VALUE 0 COMP-3.    
           05  WS-CODE-USAGE-TYPE      PIC X(01)     VALUE SPACES.      
           05  WS-NO-OF-DAYS           PIC S9(04)    VALUE 0 COMP.      
           05  WS-AMT-BILL-ITEM        PIC S9(09)V99 VALUE 0 COMP-3.    
           05  WS-AMT-TAX              PIC S9(09)V99 VALUE 0 COMP-3.    
           05  WS-CODE-BILL-ITM-IND    PIC X(01)     VALUE SPACES.      
           05  WS-BILL-ITEM-TIMESTMP   PIC X(26)     VALUE SPACES.      
           05  WS-SUB-ACCOUNT-NO       PIC S9(13)    VALUE 0 COMP-3.    
           05  WS-SERV-ADDRESS         PIC X(81)     VALUE SPACES.      
           05  WS-RATE-PLAN-NO         PIC X(03)     VALUE SPACES.      
           05  WS-TOTAL-BILL-AMOUNT    PIC S9(09)V99 VALUE 0 COMP-3.    
           05  WS-CODE-BILL-CALC       PIC X(01)     VALUE SPACES.      
           05  WS-UNMTRD-ELEC-GAS      PIC X(01)     VALUE SPACES.      
           05  WS-PSNC-FLAG            PIC X(01)     VALUE SPACES.      
           05  WS-CIG-FLAG             PIC X(01)     VALUE SPACES.      
           05  WS-INDUS-GAS-CUST       PIC X(01)     VALUE SPACES.      
           05  WS-EMC-FLAG             PIC X(01)     VALUE 'N'.         
           05  WS-MTR-READ-SOURCE-CD   PIC X(01)     VALUE SPACES.      
           05  WS-READ-UNITS           PIC S9(09)    VALUE 0 COMP-3.    
           05  WS-FUT-BILL-HOOK-INS-FL PIC X(01)     VALUE SPACES.      
           05  WS-NET-MTR-ACCOUNT      PIC X(01)     VALUE SPACES.      
           05  WS-RT-PKG-OPT-SEQ-NO    PIC S9(9)     VALUE 0 COMP.      
           05  WS-EWNA-FUTURE-HOOK-FL  PIC X(01)     VALUE 'N'.         
           05  WS-ELEC-WNA-START       PIC X(06)     VALUE SPACES.      
           05  WS-BILL-ADJ-FLAG        PIC X(01)     VALUE SPACES.      
           05  WS-PRP-FRST-EST-FLAG    PIC X(01)     VALUE SPACES.      
           05  WS-ELEC-INTRUPT-ACCOUNT PIC X(01)     VALUE SPACES.      
           05  WS-ENABLE-BILL-CALC-SW  PIC X(01)     VALUE SPACES.      
                                                                        
      *                                                                         
      ******************************************************************        
      *                    C U R S O R  D E C L A R A T I O N S        *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF    **        
      *  ROWS FROM THE CSS_BUDGET_HIST TABLE FOR A GIVEN ACCOUNT      **        
      *  NUMBER TO EXTRACT THE EFFECTIVE BUDGET AMOUNT.               **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE BH-CURSOR CURSOR FOR                             
                   SELECT AMT_MO_PYMT,                                  
                          DATE_PYMT_STRT                                
                   FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                   
                   WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO             
                     AND PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL      
                ORDER BY DATE_PYMT_STRT DESC                            
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BH-CURSOR CURSOR FOR                                     
MFA-TR*            SELECT AMT_MO_PYMT,                                          
MFA-TR*                   DATE_PYMT_STRT                                        
MFA-TR*            FROM CSS_BUDGET_HIST                                         
MFA-TR*            WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO                     
MFA-TR*              AND PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL              
MFA-TR*         ORDER BY DATE_PYMT_STRT DESC                                    
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  ROWS FROM THE CSS_BILLING_HDR TABLE FOR A GIVEN ACCOUNT     **        
      **  NUMBER.                                                     **        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BI-CURSOR CURSOR FOR                             
                   SELECT BILL_NO,                                      
                          DATE_BILLED,                                  
                          CODE_BILL_TYPE,                               
                          CODE_BILL_STATUS,                             
                          TOT_OTHER_CHARGES,                            
                          TOTAL_ARREARS                                 
                   FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                   
                   WHERE ACCOUNT_NO  =  :BI-ACCOUNT-NO                  
                   ORDER BY BILL_NO DESC                                
                   FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BI-CURSOR CURSOR FOR                                     
MFA-TR*            SELECT BILL_NO,                                              
MFA-TR*                   DATE_BILLED,                                          
MFA-TR*                   CODE_BILL_TYPE,                                       
MFA-TR*                   CODE_BILL_STATUS,                                     
MFA-TR*                   TOT_OTHER_CHARGES,                                    
MFA-TR*                   TOTAL_ARREARS                                         
MFA-TR*            FROM CSS_BILLING_HDR                                         
MFA-TR*            WHERE ACCOUNT_NO  =  :BI-ACCOUNT-NO                          
MFA-TR*            ORDER BY BILL_NO DESC                                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  ROWS FROM THE CSS_BILLING_DET TABLE WHERE THE ACCOUNT       **        
      **  NUMBER AND BILL NUMBER ARE EQUAL TO THE ACCOUNT NUMBER AND  **        
      **  BILL NUMBER ON THE CURRENT CSS_BILLING_HDR ROW.             **        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BG-CURSOR CURSOR FOR                             
                   SELECT CODE_UTIL_TYPE,                               
                          IC_NO,                                        
                          AMT_BILL_ITEM,                                
                          AMT_STATE_TAX,                                
                          AMT_CITY_TAX,                                 
                          AMT_OTHER_TAX,                                
                          CODE_REVENUE_CLASS,                           
                          CODE_BILL_CALC,                               
                          CODE_BILL_ITM_IND,                            
                          CODE_BILL_ITM_TYPE,                           
                          CODE_DR_CR_CNSMPTN,                           
                          RATE_PLAN_NO,                                 
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                           
                          REVENUE_MONTH,                                
                          DATE_ORIG_BILL,                               
                          BTU_FACTOR,                                   
                          ACCOUNT_NO,                                   
                          BILL_NO,                                      
                          NO_OF_CONS_DAYS,                              
                          REV_RPT_CD,                                   
                          RT_PKG_OPT_SEQ_NO                             
                     FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                 
                    WHERE ACCOUNT_NO        = :BG-ACCOUNT-NO            
                      AND BILL_NO           = :BG-BILL-NO               
                    ORDER BY ACCOUNT_NO         ASC,                    
                             BILL_NO            DESC,                   
                             CODE_UTIL_TYPE     ASC,                    
                             IC_NO              ASC,                    
                             BILL_ITEM_TIMESTMP ASC                     
                    FOR READ ONLY                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BG-CURSOR CURSOR FOR                                     
MFA-TR*            SELECT CODE_UTIL_TYPE,                                       
MFA-TR*                   IC_NO,                                                
MFA-TR*                   AMT_BILL_ITEM,                                        
MFA-TR*                   AMT_STATE_TAX,                                        
MFA-TR*                   AMT_CITY_TAX,                                         
MFA-TR*                   AMT_OTHER_TAX,                                        
MFA-TR*                   CODE_REVENUE_CLASS,                                   
MFA-TR*                   CODE_BILL_CALC,                                       
MFA-TR*                   CODE_BILL_ITM_IND,                                    
MFA-TR*                   CODE_BILL_ITM_TYPE,                                   
MFA-TR*                   CODE_DR_CR_CNSMPTN,                                   
MFA-TR*                   RATE_PLAN_NO,                                         
MFA-TR*                   BILL_ITEM_TIMESTMP,                                   
MFA-TR*                   REVENUE_MONTH,                                        
MFA-TR*                   DATE_ORIG_BILL,                                       
MFA-TR*                   BTU_FACTOR,                                           
MFA-TR*                   ACCOUNT_NO,                                           
MFA-TR*                   BILL_NO,                                              
MFA-TR*                   NO_OF_CONS_DAYS,                                      
MFA-TR*                   REV_RPT_CD,                                           
MFA-TR*                   RT_PKG_OPT_SEQ_NO                                     
MFA-TR*              FROM CSS_BILLING_DET                                       
MFA-TR*             WHERE ACCOUNT_NO        = :BG-ACCOUNT-NO                    
MFA-TR*               AND BILL_NO           = :BG-BILL-NO                       
MFA-TR*             ORDER BY ACCOUNT_NO         ASC,                            
MFA-TR*                      BILL_NO            DESC,                           
MFA-TR*                      CODE_UTIL_TYPE     ASC,                            
MFA-TR*                      IC_NO              ASC,                            
MFA-TR*                      BILL_ITEM_TIMESTMP ASC                             
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ************************************************************              
      * THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF*              
      * ROWS FROM THE CSS_CNSMPTN_HIST TABLE.                    *              
      ************************************************************              
      *                                                                         
            EXEC SQL                                                    
                DECLARE CX-CURSOR CURSOR FOR                            
              SELECT CODE_USAGE_TYPE,                                   
                     METER_NO,                                          
                     DATE_READ,                                         
                     NO_UNITS,                                          
                     NO_DEMAND_UNITS,                                   
                     NO_DAYS,                                           
                     CODE_SOURCE_ID,                                    
                     CODE_DEBIT_CREDIT,                                 
                     MTR_REF_NO,                                        
                     REG_ID_NO,                                         
                     CODE_TOU_SEASN,                                    
                     CODE_TIME_PERIOD,                                  
                     CODE_ITEM_STATUS                                   
                   FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                  
                   WHERE  ACCOUNT_NO        = :CX-ACCOUNT-NO            
                   AND    CODE_UTIL_TYPE    = :CX-CODE-UTIL-TYPE        
                   AND    BILL_NO           = :CX-BILL-NO               
                   AND    IC_NO             = :CX-IC-NO                 
                   AND    BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )   
                   AND    CODE_ITEM_STATUS IN ( 'A' , 'T')              
                   ORDER BY DATE_READ DESC,                             
                            CODE_USAGE_TYPE ASC                         
                   FOR READ ONLY                                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE CX-CURSOR CURSOR FOR                                    
MFA-TR*       SELECT CODE_USAGE_TYPE,                                           
MFA-TR*              METER_NO,                                                  
MFA-TR*              DATE_READ,                                                 
MFA-TR*              NO_UNITS,                                                  
MFA-TR*              NO_DEMAND_UNITS,                                           
MFA-TR*              NO_DAYS,                                                   
MFA-TR*              CODE_SOURCE_ID,                                            
MFA-TR*              CODE_DEBIT_CREDIT,                                         
MFA-TR*              MTR_REF_NO,                                                
MFA-TR*              REG_ID_NO,                                                 
MFA-TR*              CODE_TOU_SEASN,                                            
MFA-TR*              CODE_TIME_PERIOD,                                          
MFA-TR*              CODE_ITEM_STATUS                                           
MFA-TR*            FROM CSS_CNSMPTN_HIST                                        
MFA-TR*            WHERE  ACCOUNT_NO        = :CX-ACCOUNT-NO                    
MFA-TR*            AND    CODE_UTIL_TYPE    = :CX-CODE-UTIL-TYPE                
MFA-TR*            AND    BILL_NO           = :CX-BILL-NO                       
MFA-TR*            AND    IC_NO             = :CX-IC-NO                         
MFA-TR*            AND    BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP           
MFA-TR*            AND    CODE_ITEM_STATUS IN ( 'A' , 'T')                      
MFA-TR*            ORDER BY DATE_READ DESC,                                     
MFA-TR*                     CODE_USAGE_TYPE ASC                                 
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*     END-EXEC.                                                           
                                                                        
      *                                                                         
      *****************************************************************         
      ***    THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET  **         
      ***       ROWS FROM THE CSS_UM_CNSMPT_HIST TABLE.              **         
      ***                                                            **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE UC-CURSOR CURSOR FOR                             
               SELECT DATE_USAGE_ENDS,                                  
                      NO_UNITS,                                         
                      NO_DAYS,                                          
                      MTHLY_AMOUNT_FIXED,                               
                      CODE_DEBIT_CREDIT                                 
               FROM CSS_UM_CNSMPT_HIST WITH(READUNCOMMITTED)                    
               WHERE  ACCOUNT_NO           = :UC-ACCOUNT-NO             
                 AND  CODE_UTIL_TYPE       = :UC-CODE-UTIL-TYPE         
                 AND  BILL_NO              = :UC-BILL-NO                
                 AND  IC_NO                = :UC-IC-NO                  
                 AND  BILL_ITEM_TIMESTMP   = CIS.CHAR2TIMESTAMP(
                                                 :UC-BILL-ITEM-TIMESTMP
              )     
      *        ORDER BY DATE_USAGE_ENDS DESC                                    
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UC-CURSOR CURSOR FOR                                     
MFA-TR*        SELECT DATE_USAGE_ENDS,                                          
MFA-TR*               NO_UNITS,                                                 
MFA-TR*               NO_DAYS,                                                  
MFA-TR*               MTHLY_AMOUNT_FIXED,                                       
MFA-TR*               CODE_DEBIT_CREDIT                                         
MFA-TR*        FROM CSS_UM_CNSMPT_HIST                                          
MFA-TR*        WHERE  ACCOUNT_NO           = :UC-ACCOUNT-NO                     
MFA-TR*          AND  CODE_UTIL_TYPE       = :UC-CODE-UTIL-TYPE                 
MFA-TR*          AND  BILL_NO              = :UC-BILL-NO                        
MFA-TR*          AND  IC_NO                = :UC-IC-NO                          
MFA-TR*          AND  BILL_ITEM_TIMESTMP   = :UC-BILL-ITEM-TIMESTMP             
MFA-TR*        ORDER BY DATE_USAGE_ENDS DESC                                    
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      ******************************************************************        
      ****THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **** ROWS FROM THE CSS_BILL_CALC_DET.                           **        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE BZ-CURSOR CURSOR FOR                              
              SELECT BILL_UNITS,                                        
                     BILLED_COMP_AM,                                    
                     CONSUMPT_TYPE_CD,                                  
                     CMPNT_ID_CD                                        
                    ,READ_UNITS                                         
                FROM CSS_BILL_CALC_DET WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO           = :BZ-ACCOUNT-NO              
                 AND   CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE          
                 AND   BILL_NO            = :BZ-BILL-NO                 
                 AND   IC_NO              = :BZ-IC-NO                   
                 AND   BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BZ-BILL-ITEM-TIMESTMP
              )      
                 AND   (CMPNT_ID_CD NOT IN ('92','93'))                 
              ORDER BY CONSUMPT_TYPE_CD ASC                             
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BZ-CURSOR CURSOR FOR                                      
MFA-TR*       SELECT BILL_UNITS,                                                
MFA-TR*              BILLED_COMP_AM,                                            
MFA-TR*              CONSUMPT_TYPE_CD,                                          
MFA-TR*              CMPNT_ID_CD                                                
MFA-TR*             ,READ_UNITS                                                 
MFA-TR*         FROM CSS_BILL_CALC_DET                                          
MFA-TR*        WHERE ACCOUNT_NO           = :BZ-ACCOUNT-NO                      
MFA-TR*          AND   CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE                  
MFA-TR*          AND   BILL_NO            = :BZ-BILL-NO                         
MFA-TR*          AND   IC_NO              = :BZ-IC-NO                           
MFA-TR*          AND   BILL_ITEM_TIMESTMP = :BZ-BILL-ITEM-TIMESTMP              
MFA-TR*          AND   (CMPNT_ID_CD NOT IN ('92','93'))                         
MFA-TR*       ORDER BY CONSUMPT_TYPE_CD ASC                                     
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      ****THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING SUB ACCOUNT**        
      **** NUMBERS FROM THE BILL_ACCT_XFER TABLE FOR A MASTER ACCOUNT.**        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE XFER-CURSOR CURSOR FOR                            
              SELECT DISTINCT (BILL_NO_XFER_FROM),                      
                     ACCT_XFER_FROM                                     
                FROM CSS_BILL_ACCT_XFER WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO         = :AF-ACCOUNT-NO              
                 AND  BILL_NO            = :AF-BILL-NO                 
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE XFER-CURSOR CURSOR FOR                                    
MFA-TR*       SELECT DISTINCT (BILL_NO_XFER_FROM),                              
MFA-TR*              ACCT_XFER_FROM                                             
MFA-TR*         FROM CSS_BILL_ACCT_XFER                                         
MFA-TR*         WHERE ACCOUNT_NO         = : AF-ACCOUNT-NO                      
MFA-TR*          AND  BILL_NO            = : AF-BILL-NO                         
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
HPCCDM*EJECT                                                                    
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO             PIC X(13).                       
       01  PARM-BILL-NO                PIC X(04).                       
       01  WS-SCSCA-RETURN-CODE        PIC S9(4) COMP.                  
       COPY CWS00158.                                                   13800036
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-BILL-NO                            
                                WS-SCSCA-RETURN-CODE                    
                                WS-CA158-BILLSTMT-INFO.                 
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE               THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
           PERFORM 2000-PROCESS-OUTPUT           THRU 2000-EXIT.        
           PERFORM 9999-END-PROGRAM              THRU 9999-EXIT.        
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           MOVE WS-ELEC-WNA-DLNQ-CD         TO C8-DELINQ-CD.            
           MOVE '01'                        TO C8-COMPANY-NO.           
           PERFORM 7970-SELECT-DELINQUENCY      THRU 7970-EXIT.         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              MOVE C8-DELINQ-VALUE          TO WS-ELEC-WNA-WORK         
              MULTIPLY WS-ELEC-WNA-WORK BY 100                          
                GIVING WS-ELEC-WNA-VALUE                                
           ELSE                                                         
              MOVE 999999                   TO WS-ELEC-WNA-VALUE        
           END-IF.                                                      
           MOVE WS-ELEC-WNA-VALUE           TO WS-ELEC-WNA-START.       
           INITIALIZE WS-ACCUMULATORS                                   
                      SWITCHES.                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO         TO BI-ACCOUNT-NO.               
           MOVE PARM-ACCOUNT-NO         TO BG-ACCOUNT-NO.               
           MOVE PARM-ACCOUNT-NO         TO AT-ACCOUNT-NO.               
           MOVE PARM-ACCOUNT-NO         TO BH-ACCOUNT-NO.               
           MOVE PARM-ACCOUNT-NO         TO AR-ACCOUNT-NO.               
           MOVE PARM-ACCOUNT-NO         TO BP-ACCOUNT-NO                
                                           PK-ACCOUNT-NO.               
           MOVE PARM-BILL-NO            TO WS-PARM-BILL-NO.             
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      *                                                                *        
      *     ALL BILLING HEADER RECORDS WILL BE RETRIEVED WITH THEIR    *        
      *      ASSOCIATED DETAIL RECORDS AND PROCESSED ONCE.             *        
      *     THE RESULTS WILL BE FORMATTED AND SENT BACK IN A TDS       *        
      *      RESULT SET TO THE CALLING PROGRAM. JPB 2/7/1996           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           PERFORM 2200-BUILD-RESULT-HEADER                             
              THRU 2200-EXIT.                                           
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *2000A-LOAD-RESULT.                                                       
      ******************************************************************        
       2000A-LOAD-RESULT.                                               
      *                                                                         
           PERFORM 2100-DETERMINE-STMT-SUB        THRU  2100-EXIT.      
           MOVE WS-RECORD-ID          TO WS-CA158-RECORD-ID(WS-SUB).    
           MOVE WS-REVENUE-MONTH      TO WS-CA158-REVENUE-MONTH(WS-SUB).
           MOVE WS-DATE-BILLED        TO WS-CA158-DATE-BILLED(WS-SUB).  
           MOVE WS-CODE-BILL-TYPE     TO WS-CA158-CODE-BILL-TYPE(WS-SUB)
           MOVE WS-BILL-AMOUNT        TO WS-CA158-BILL-AMOUNT(WS-SUB).  
           MOVE WS-PAYMENTS           TO WS-CA158-PAYMENTS(WS-SUB).     
           MOVE WS-TOT-OTHER-CHARGES  TO                                
                WS-CA158-TOT-OTHER-CHARGES(WS-SUB).                     
           MOVE WS-TOTAL-ARREARS      TO WS-CA158-TOTAL-ARREARS(WS-SUB).
           MOVE WS-BILL-NO            TO WS-CA158-BILL-NO(WS-SUB).      
           MOVE WS-CODE-BILL-STATUS   TO                                
                WS-CA158-CODE-BILL-STATUS(WS-SUB).                      
           MOVE WS-BILL-DATE-READ     TO WS-CA158-DATE-READ(WS-SUB).    
           MOVE WS-CODE-UTIL-TYPE     TO WS-CA158-CODE-UTIL-TYPE(WS-SUB)
           MOVE WS-IC-NO              TO WS-CA158-IC-NO(WS-SUB).        
           MOVE WS-ADDL-HIST          TO WS-CA158-ADDL-HIST(WS-SUB).    
           MOVE WS-RATE-PLAN-DESC     TO WS-CA158-RATE-PLAN-DESC(WS-SUB)
           MOVE WS-NO-UNITS           TO WS-CA158-NO-UNITS(WS-SUB).     
           MOVE WS-CODE-USAGE-TYPE    TO                                
                WS-CA158-CODE-USAGE-TYPE(WS-SUB).                       
           MOVE WS-NO-OF-DAYS         TO WS-CA158-NO-DAYS(WS-SUB).      
           MOVE WS-AMT-BILL-ITEM      TO WS-CA158-AMT-BILL-ITEM(WS-SUB).
           MOVE WS-AMT-TAX            TO WS-CA158-AMT-TAXES(WS-SUB).    
           MOVE WS-CODE-BILL-ITM-IND  TO                                
                WS-CA158-CODE-BILL-ITM-IND(WS-SUB).                     
           MOVE WS-BILL-ITEM-TIMESTMP TO                                
                WS-CA158-BILL-ITEM-TIMESTMP(WS-SUB).                    
           MOVE WS-SUB-ACCOUNT-NO     TO WS-CA158-SUB-ACCOUNT-NO(WS-SUB)
           MOVE WS-SERV-ADDRESS       TO WS-CA158-SERV-ADDR(WS-SUB).    
           MOVE WS-RATE-PLAN-NO       TO WS-CA158-RATE-PLAN-NO(WS-SUB). 
           MOVE WS-TOTAL-BILL-AMOUNT  TO                                
                WS-CA158-TOTAL-BILL-AMOUNT(WS-SUB).                     
           MOVE WS-CODE-BILL-CALC     TO WS-CA158-CODE-BILL-CALC(WS-SUB)
           MOVE WS-UNMTRD-ELEC-GAS    TO                                
                WS-CA158-UNMTRD-ELEC-GAS(WS-SUB).                       
           MOVE WS-PSNC-FLAG          TO WS-CA158-PSNC-FLAG(WS-SUB).    
           MOVE WS-CIG-FLAG           TO WS-CA158-CIG-FLAG(WS-SUB).     
           MOVE WS-INDUS-GAS-CUST    TO WS-CA158-INDUST-GAS-CUST(WS-SUB)
           MOVE WS-EMC-FLAG           TO WS-CA158-EMC-FLAG(WS-SUB).     
           MOVE WS-MTR-READ-SOURCE-CD TO                                
                WS-CA158-MTR-READ-SOURCE-CD(WS-SUB).                    
           MOVE WS-READ-UNITS         TO WS-CA158-READ-UNITS(WS-SUB).   
           MOVE WS-FUT-BILL-HOOK-INS-FL TO                              
                WS-CA158-FUT-BILL-HOOK-INS-FL(WS-SUB).                  
           MOVE WS-NET-MTR-ACCOUNT      TO                              
                WS-CA158-NET-MTR-ACCOUNT(WS-SUB).                       
           MOVE WS-RT-PKG-OPT-SEQ-NO  TO                                
                WS-CA158-RT-PKG-OPT-SEQ-NO(WS-SUB).                     
           MOVE WS-EWNA-FUTURE-HOOK-FL TO                               
                WS-CA158-EWNA-FUTURE-HOOK-FL(WS-SUB).                   
           MOVE WS-ELEC-WNA-START     TO                                
                WS-CA158-ELEC-WNA-START(WS-SUB).                        
           MOVE WS-BILL-ADJ-FLAG      TO                                
                WS-CA158-BILL-ADJ-FLAG(WS-SUB).                         
           MOVE WS-PRP-FRST-EST-FLAG  TO                                
                WS-CA158-PRP-FRST-EST-FLAG(WS-SUB).                     
           MOVE WS-ELEC-INTRUPT-ACCOUNT TO                              
                WS-CA158-ELEC-INTRUPT-ACCT(WS-SUB).                     
           MOVE WS-ENABLE-BILL-CALC-SW TO                               
                WS-CA158-ENABLE-BILL-CALC(WS-SUB).                      
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
HPCCDM*    EJECT                                                                
       2100-DETERMINE-STMT-SUB.                                         
      *                                                                         
           PERFORM VARYING WS-SUB FROM 1 BY 1 UNTIL WS-SUB > 999 OR     
             WS-CA158-RECORD-ID (WS-SUB) <= SPACES                      
           END-PERFORM.                                                 
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT-HEADER                                       *        
      *                                                                *        
      *     BUILD THE HEADER RESULT SET DESCRIBED ABOVE.               *        
      *                                                                *        
      *     THIS ROUTINE WILL RETRIEVE ALL BILLING HEADER RECORDS AND  *        
      *      ASSOCIATED DETAIL RECORDS WITHIN A SINGLE PASS.           *        
      *                                                                *        
      ******************************************************************        
      *    THIS ROUTINE WILL ALSO PERFORM A PRIMING READ OF THE *               
      *     CSS-BILLING-HEADER TABLE. IF THE PRIMING READ RETURNS A NOT*        
      *     FOUND, THEN THE CURRENT THINKING IS THAT A SERIOUS ERROR   *        
      *     EXISTS. A DUMMY HEADER AND DETAIL RECORD IS SET-UP FOR     *        
      *     EACH ACCOUNT. THEREFORE, EVERY ACCOUNT SHOULD HAVE AT LEAST*        
      *     ONE HEADER AND DETAIL RECORD.                                       
      ****************************************************************          
                                                                        
       2200-BUILD-RESULT-HEADER.                                        
                                                                        
      ****SET FUT-BILL-HOOK-INS-FL ONLY ONCE BY USING WS VARIABLE               
           MOVE 'Y'                     TO WS-CALC-FUT-BILL-HOOK-FL.    
           MOVE 'N'                     TO WS-FUT-BILL-HOOK-INS-FL.     
A04149     MOVE 'N'                     TO END-OF-BG-SW.                
                                                                        
           PERFORM 7000-OPEN-BI-CURSOR                                  
              THRU 7000-EXIT.                                           
                                                                        
           PERFORM 7010-FETCH-BI-ROW                                    
              THRU 7010-EXIT.                                           
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE '2200'              TO ACTIVE-PARAGRAPH             
               MOVE 'FETCH'             TO ABEND-FUNCTION               
               MOVE 'CSS_BILLING_HDR  ' TO TABLE-1                      
               MOVE 'ACCOUNT_NO  '      TO TABLE-ELEMENT-1              
               MOVE BI-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           ELSE                                                         
              IF WS-CALC-FUT-BILL-HOOK-FL = 'Y'                         
                 IF WS-NULL-IND-HEADER < 0                              
                    MOVE BI-BILL-NO        TO WS-BI-BILL-NO             
                    MOVE BI-ACCOUNT-NO     TO BG-ACCOUNT-NO             
                    PERFORM 7950-SELECT-BILLING-DET    THRU 7950-EXIT   
                 ELSE                                                   
                    PERFORM 7940-SELECT-BILLING-HDR    THRU 7940-EXIT   
                    IF WS-BI-BILL-NO > 0                                
                       MOVE BI-ACCOUNT-NO     TO BG-ACCOUNT-NO          
                       PERFORM 7950-SELECT-BILLING-DET THRU 7950-EXIT   
                    ELSE                                                
                       MOVE 0         TO WS-BG-ROW-COUNT                
                    END-IF                                              
                 END-IF                                                 
                 MOVE BI-ACCOUNT-NO             TO UT-ACCOUNT-NO        
                 PERFORM 7960-SELECT-UT-ROW     THRU 7960-EXIT          
                 IF WS-BG-ROW-COUNT NOT EQUAL WS-UT-ROW-COUNT           
                    MOVE 'Y'          TO WS-FUT-BILL-HOOK-INS-FL        
                 ELSE                                                   
                    MOVE 'N'          TO WS-FUT-BILL-HOOK-INS-FL        
                 END-IF                                                 
                 MOVE 'N'             TO WS-CALC-FUT-BILL-HOOK-FL       
              END-IF                                                    
                                                                        
              PERFORM 7200-SELECT-AT                                    
                 THRU 7200-EXIT                                         
                                                                        
              MOVE 'DATABASE'               TO C8-DELINQ-CD             
              MOVE AT-COMPANY-NO            TO C8-COMPANY-NO            
              PERFORM 7530-GET-DATABASE       THRU 7530-EXIT            
                                                                        
              MOVE 'N'                      TO WS-EWNA-FUTURE-HOOK-FL   
              IF CSR-DATABASE AND AT-COMPANY-NO = '01'                  
                                                                        
                 PERFORM 7210-GET-COMMON-DATE THRU 7210-EXIT            
                                                                        
                 MOVE AT-BILL-CYCLE         TO BN-BILL-CYCLE            
                                                                        
                 IF AT-REV-MTH-LST-NRML > ZEROS                         
                                                                        
                    MOVE AT-REV-MTH-LST-NRML TO WS-INPUT-REV-MONTH      
                    MOVE +01                 TO WS-MONTHS-TO-ADD        
                    PERFORM 5000-INCRMT-REV-MONTHS                      
                                             THRU 5000-EXIT             
                    MOVE WS-INPUT-REV-MONTH  TO BN-REVENUE-MONTH        
                                                                        
                    PERFORM 7220-GET-BN-OPEN-DT-REV-MNTH                
                                             THRU 7220-EXIT             
                 ELSE                                                   
                    PERFORM 7230-GET-BN-OPEN-DT-BILL-CYC                
                                             THRU 7230-EXIT             
                 END-IF                                                 
                 IF WS-COMMON-DATE >= BN-DATE-EXTRACT                   
                    MOVE 'Y'                 TO WS-EWNA-FUTURE-HOOK-FL  
                 END-IF                                                 
              END-IF                                                    
                                                                        
              MOVE AT-CODES-DATA-PRESENT                                
                                       TO WS-CODES-DATA-PRESENT         
              MOVE 'N'                 TO WS-CIG-FLAG                   
              MOVE BI-ACCOUNT-NO       TO XM-ACCOUNT-NO                 
              PERFORM 7118-SELECT-COBB-SNAPSHOAL  THRU 7118-EXIT        
              IF WS-COBB-SNAPSHOAL = 'C' OR 'S'                         
                 MOVE PROGRAM-NAME     TO G6-PROGRAM-NAME               
                 MOVE 'PARM'           TO G6-CMND-CODE                  
                 MOVE 'A'              TO G6-STATUS                     
                 IF WS-COBB-SNAPSHOAL = 'C'                             
                    MOVE 0001          TO G6-SEQ-NO                     
                 ELSE                                                   
                    MOVE 0002          TO G6-SEQ-NO                     
                 END-IF                                                 
                 PERFORM 7920-SELECT-JOB-PARM     THRU 7920-EXIT        
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                    MOVE SPACES           TO WS-PARM-DATA               
                 ELSE                                                   
                     MOVE G6-PARM-DATA     TO WS-PARM-DATA              
                  END-IF                                                
               END-IF                                                   
               MOVE 'N'                 TO WS-PSNC-FLAG                 
               IF  AT-COMPANY-NO = WS-PSNC                              
                   MOVE PROGRAM-NAME TO WS-PGRMNAME                     
                   PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT           
               END-IF                                                   
                                                                        
               IF  PARM-BILL-NO = '0000'                                
                   MOVE 'Y' TO WS-FIRST-TIME-SW                         
                   PERFORM 2210-BUILD-RESULT-HEADER                     
                      THRU 2210-EXIT                                    
                   UNTIL (WS-ROW-COUNT > WS-MAX-ROWS)      OR           
                          NO-MORE-HEADER-RECS                           
               ELSE                                                     
                   MOVE 'N' TO WS-FIRST-TIME-SW                         
                   PERFORM 2210-BUILD-RESULT-HEADER                     
                      THRU 2210-EXIT                                    
                   UNTIL NO-MORE-HEADER-RECS             OR             
                         (WS-PARM-BILL-NO >= BI-BILL-NO  AND            
                             PARM-BILL-NO NOT = '9999')                 
               END-IF                                                   
           END-IF.                                                      
                                                                        
           PERFORM 7020-CLOSE-BI-CURSOR                                 
              THRU 7020-EXIT.                                           
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
      ******************************************************************        
      * 2210-BUILD-RESULT-HEADER                                       *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2210-BUILD-RESULT-HEADER.                                        
      *                                                                         
                                                                        
           MOVE BI-BILL-NO              TO BG-BILL-NO                   
                                           WS-BILL-NO                   
                                           BP-BILL-NO                   
                                           AF-BILL-NO.                  
           MOVE AT-ACCOUNT-NO           TO AF-ACCOUNT-NO.               
           MOVE 'A'                     TO BG-CODE-BILL-ITM-IND.        
           MOVE 'N'                     TO WS-BILL-ADJ-FLAG             
                                           WS-PRP-FRST-EST-FLAG.        
                                                                        
           IF  WS-NULL-IND-HEADER < 0                                   
               MOVE SPACES              TO WS-DATE-BILLED               
      *        MOVE 'Y'                 TO WS-PSNC-FLAG                         
      *        MOVE 'Y'                 TO WS-CIG-FLAG                          
               MOVE SPACES              TO WS-BILL-DATE                 
           ELSE                                                         
               MOVE BI-DATE-BILLED      TO WS-BILL-DATE                 
               MOVE WS-CCYY OF WS-BILL-DATE                             
                                     TO WS-CCYY OF WS-BILL-DATE-MMDDCCYY
               MOVE WS-MM OF WS-BILL-DATE                               
                                     TO WS-MM OF WS-BILL-DATE-MMDDCCYY  
               MOVE WS-DD OF WS-BILL-DATE                               
                                     TO WS-DD OF WS-BILL-DATE-MMDDCCYY  
               MOVE WS-BILL-DATE-MMDDCCYY                               
                                        TO WS-DATE-BILLED               
           END-IF.                                                      
           IF WS-DATE-BILLED > SPACES                                   
              IF AT-COMPANY-NO = WS-PSNC                                
                 PERFORM 2238-CHECK-DATE-BILLED                         
                                     THRU 2238-EXIT                     
              END-IF                                                    
              PERFORM 2240-GET-TOTAL THRU 2240-EXIT                     
           ELSE                                                         
              MOVE ZERO                 TO WS-TOTAL-BILL-AMOUNT         
           END-IF.                                                      
           PERFORM 2500-BUILD-RESULT-DETAIL                             
              THRU 2500-EXIT.                                           
                                                                        
           IF SEB-DATABASE                                              
              PERFORM 7280-CHECK-BILL-ADJUSTMNT THRU 7280-EXIT          
              IF WS-BILL-ADJ-EXIST = 'Y' THEN                           
                 MOVE WS-BILL-ADJ-EXIST TO WS-BILL-ADJ-FLAG             
              END-IF                                                    
              IF BI-BILL-NO = +1 THEN                                   
                 IF WS-CODE-PRE-PAY-PLAN = WS-ACTIVE                    
                    MOVE WS-YES         TO WS-PRP-FRST-EST-FLAG         
                 ELSE                                                   
                    PERFORM 7290-GET-PREPAY-HIST-ROWCOUNT               
                                           THRU 7290-EXIT               
                    IF WS-PREPAY-COUNT > 0 THEN                         
                       MOVE WS-YES         TO WS-PRP-FRST-EST-FLAG      
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE BI-CODE-BILL-TYPE       TO WS-CODE-BILL-TYPE.           
           MOVE BI-CODE-BILL-STATUS     TO WS-CODE-BILL-STATUS.         
           MOVE BI-TOT-OTHER-CHARGES    TO WS-TOT-OTHER-CHARGES.        
           MOVE BI-TOTAL-ARREARS        TO WS-TOTAL-ARREARS.            
           MOVE WS-HEADER-REC-ID        TO WS-RECORD-ID.                
                                                                        
           MOVE +000 TO WS-ACTIVE-RETURN-CODE.                          
           MOVE WS-TOTAL-BG-DOLLARS TO WS-BILL-AMOUNT.                  
           MOVE WS-HOLD-REV-MM TO WS-HOLD-REV-MM-CHAR.                  
           MOVE WS-HOLD-REV-MM-CHAR          TO WS-EMC-REV-MM.          
           MOVE WS-HOLD-REV-MM-CHAR (5:2) TO WS-REVENUE-MONTH.          
           INITIALIZE WS-HOLD-REV-MM                                    
                      WS-HOLD-REV-MM-CHAR.                              
           PERFORM 7010-FETCH-BI-ROW                                    
              THRU 7010-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE BI-DATE-BILLED       TO WS-PREV-BILL-DATE            
              IF FIRST-TIME-IN                                          
                 AND WS-ROW-COUNT = 6                                   
                    PERFORM 7010-FETCH-BI-ROW                           
                       THRU 7010-EXIT                                   
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       MOVE 'Y' TO WS-ADDL-HIST                         
                    ELSE                                                
                       MOVE 'N' TO WS-ADDL-HIST                         
                    END-IF                                              
              END-IF                                                    
           ELSE                                                         
              MOVE 'N' TO WS-ADDL-HIST                                  
              MOVE 'Y' TO END-OF-BI-SW                                  
              MOVE SPACES TO WS-PREV-BILL-DATE
           END-IF.                         
                                                                        
           IF WS-PREV-BILL-DATE EQUAL SPACES AND                        
              WS-BILL-DATE       >  SPACES                              
              MOVE '1900-01-01'         TO WS-PREV-BILL-DATE            
           END-IF.                                                      
                                                                        
           IF WS-PREV-BILL-DATE  >  SPACES  AND                         
              WS-BILL-DATE       >  SPACES                              
              PERFORM 2230-PYMTS-BET-2-BILL-DATES  THRU  2230-EXIT      
              MOVE AR-AMT-ORIG-ENTERED  TO WS-PAYMENTS                  
           ELSE                                                         
              MOVE ZEROS                TO WS-PAYMENTS                  
           END-IF.                                                      
                                                                        
           PERFORM 2000A-LOAD-RESULT           THRU 2000A-EXIT.         
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2215-GET-BUD-AMT                                               *        
      *                                                                *        
      *     FETCHES THE BUD HISTORY TABLE.                             *        
      ******************************************************************        
      *                                                                         
      *                                                                         
       2215-GET-BUD-AMT.                                                
      *                                                                         
           IF BH-DATE-PYMT-STRT <= WS-BILL-DATE                         
              MOVE 'Y' TO WS-BUD-AMT-FOUND-FLAG                         
              GO TO 2215-EXIT                                           
           END-IF.                                                      
           PERFORM 7510-FETCH-BH-ROW   THRU 7510-EXIT.                  
       2215-EXIT.                                                       
            EXIT.                                                       
HPCCDM*     EJECT                                                               
      ******************************************************************        
      * 2230-PYMTS-BET-2-BILL-DATES                                    *        
      *                                                                *        
      *     OBTAINS ALL THE PAYMENTS BETWEEN TWO BILLING DATES.        *        
      ******************************************************************        
      *                                                                         
       2230-PYMTS-BET-2-BILL-DATES.                                     
      *                                                                         
      *    TO GET AR-TRANS-HIST-SEQ-NO USING CURR BILL DATE.                    
           MOVE WS-BILL-DATE-CH TO AR-DATE-TRANS.                       
           PERFORM  7400-GET-AR-TRANS-SEQ-NO THRU 7400-EXIT.            
           MOVE AR-TRANS-HIST-SEQ-NO TO WS-CURRBILL-AR-TRNSHIST-SEQ.    
                                                                        
      *    TO GET AR-TRANS-HIST-SEQ-NO USING PREVIOUS BILL DATE.                
           IF WS-PREV-BILL-DATE = '1900-01-01'                          
              MOVE '1900-01-01-00.00.00.000000'                         
                                        TO WS-PREVBILL-AR-TRNSHIST-SEQ  
           ELSE                                                         
              MOVE WS-PREV-BILL-DATE    TO AR-DATE-TRANS                
              PERFORM  7400-GET-AR-TRANS-SEQ-NO THRU 7400-EXIT          
              MOVE AR-TRANS-HIST-SEQ-NO TO WS-PREVBILL-AR-TRNSHIST-SEQ  
           END-IF.                                                      
                                                                        
           IF WS-CURRBILL-AR-TRNSHIST-SEQ > SPACES AND                  
              WS-PREVBILL-AR-TRNSHIST-SEQ > SPACES                      
               PERFORM  7450-GET-PAYMENT-AMT       THRU 7450-EXIT       
           ELSE                                                         
              MOVE ZEROS                TO AR-AMT-ORIG-ENTERED          
           END-IF.                                                      
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2238-CHECK-DATE-BILLED                                         *        
      *                                                                *        
      *     CALCULATES IF THE DATE BILLED IS LESS THAN CUT OFF DATE    *        
      ******************************************************************        
       2238-CHECK-DATE-BILLED.                                          
            MOVE 'N'                        TO WS-PSNC-FLAG             
            MOVE WS-BILL-DATE-MMDDCCYY(7:2) TO WS-TEMP-CC               
            MOVE WS-BILL-DATE-MMDDCCYY(9:2) TO WS-TEMP-YY               
            MOVE WS-BILL-DATE-MMDDCCYY(1:2) TO WS-TEMP-MM               
            MOVE WS-BILL-DATE-MMDDCCYY(4:2) TO WS-TEMP-DD               
            IF  WS-TEMP-DATE-CCYYMMDD < WS-CUT-OFF-DATE                 
                MOVE 'Y'                    TO WS-PSNC-FLAG             
            END-IF.                                                     
       2238-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2240-GET-TOTAL                                                 *        
      *                                                                *        
      *     OBTAINS TOTAL BILL AMOUNT FOR A GIVEN BILL DATE            *        
      ******************************************************************        
      *                                                                         
      *                                                                         
       2240-GET-TOTAL.                                                  
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(AMT_BILLED_UNPAID)                             
              INTO  :AR-AMT-BILLED-UNPAID :WS-NULL-IND-3                 
              FROM   CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
              WHERE  ACCOUNT_NO   = :AT-ACCOUNT-NO                      
              AND    DATE_TRANS   = IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )                     
              AND    CODE_TRAN_TYPE = 'B'                               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_BILLED_UNPAID)                                     
MFA-TR*       INTO  :AR-AMT-BILLED-UNPAID:WS-NULL-IND-3                         
MFA-TR*       FROM   CSS_AR_TRANS_HIST                                          
MFA-TR*       WHERE  ACCOUNT_NO   = :AT-ACCOUNT-NO                              
MFA-TR*       AND    DATE_TRANS   = :BI-DATE-BILLED                             
MFA-TR*       AND    CODE_TRAN_TYPE = 'B'                                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-3 < 0                                      
                 MOVE 0 TO AR-AMT-BILLED-UNPAID                         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '2240'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_AR_TRANS_HIST'     TO TABLE-1                   
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'DATE_TRANS'         TO TABLE-ELEMENT-2              
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              MOVE BI-DATE-BILLED       TO HOSTVAR-ELEMENT-2            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AR-AMT-BILLED-UNPAID TO WS-TOTAL-BILL-AMOUNT         
           ELSE                                                         
              MOVE ZEROES TO WS-TOTAL-BILL-AMOUNT                       
           END-IF.                                                      
                                                                        
       2240-EXIT.                                                       
           EXIT.                                                        
HPCCDM*     EJECT                                                               
      *                                                                         
      ******************************************************************        
      * 2500-BUILD-RESULT-DETAIL                                       *        
      *                                                                *        
      *     OBTAINS THE BILLING DETAILS DATA.                          *        
      ******************************************************************        
      *                                                                         
       2500-BUILD-RESULT-DETAIL.                                        
      *                                                                         
           MOVE 0                       TO WS-TOTAL-BG-DOLLARS.         
           MOVE AT-MST-SUB-ACCT-IND     TO MST-SUB-ACCT-IND-SW.         
      ******************************************************************        
                                                                        
           IF MASTER-ACCOUNT                                            
              PERFORM 7050-OPEN-XFER-CURSOR THRU 7050-EXIT              
              PERFORM 7055-FETCH-XFER-ROW THRU 7055-EXIT                
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y' TO WS-MORE-BGS-SW                             
                 PERFORM 2501-PROCESS-SUBS THRU 2501-EXIT               
                    UNTIL NO-MORE-SUBS                                  
                 MOVE 'Y' TO WS-MORE-SUBS-SW                            
                 PERFORM 7060-CLOSE-XFER-CURSOR THRU 7060-EXIT          
              ELSE                                                      
                 PERFORM 7060-CLOSE-XFER-CURSOR THRU 7060-EXIT          
              END-IF                                                    
              GO TO 2500-EXIT                                           
           END-IF.                                                      
                                                                        
                                                                        
      ****************************************************************          
      ***  OPEN THE CSS-BILLING-DETAIL TABLE                                    
      ****************************************************************          
           PERFORM 7100-OPEN-BG-CURSOR                                  
              THRU 7100-EXIT.                                           
      ****************************************************************          
      **   READ FIRST OF CSS-BILLING-DETAIL USING ACCOUNT-NO AND                
      **    BILL-NO FROM THE ROW IN THE CSS-BILLING-HEADER                      
      ****************************************************************          
                                                                        
           PERFORM 7110-FETCH-BG-ROW                                    
              THRU 7110-EXIT.                                           
                                                                        
      ***  THIS LOGIC IS THE SAME AS THE OLD S093 PROGRAM IS THAT               
      ***  REVENUE MONTH IS SAVED AFTER THE FIRST RETRIEVE OF                   
      ***  OF BILLING DETAIL.                                                   
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE SPACES               TO WS-CODE-BILL-STATUS          
              MOVE SPACES               TO WS-REVENUE-MONTH             
              MOVE SPACES               TO WS-CODE-BILL-TYPE            
              MOVE 0                    TO WS-BILL-AMOUNT               
              MOVE 0                    TO WS-PAYMENTS                  
              MOVE 0                    TO WS-TOT-OTHER-CHARGES         
              MOVE 0                    TO WS-TOTAL-ARREARS             
              MOVE 0                    TO WS-NO-OF-DAYS                
              PERFORM 2510-PROCESS-BG-CURSOR                            
                 THRU 2510-EXIT                                         
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
           ELSE                                                         
              MOVE 0                    TO WS-HOLD-REV-MM               
           END-IF                                                       
                                                                        
           PERFORM 7120-CLOSE-BG-CURSOR                                 
              THRU 7120-EXIT.                                           
                                                                        
           PERFORM 2505-INIT-WS-DETAIL-FIELDS                           
              THRU 2505-EXIT.                                           
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2501-PROCESS-SUBS                                              *        
      *                                                                *        
      *   THIS ROUTINE WILL PROCESS THE BILLING DETAILS FOR ALL SUB    *        
      *   ACCOUNTS WITHIN A GIVEN BILL NUMBER.                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2501-PROCESS-SUBS.                                               
                                                                        
           MOVE AF-ACCT-XFER-FROM TO BG-ACCOUNT-NO.                     
           MOVE AF-BILL-NO-XFER-FROM TO BG-BILL-NO.                     
      ****************************************************************          
      ***  OPEN THE CSS-BILLING-DETAIL TABLE                                    
      ****************************************************************          
           PERFORM 7100-OPEN-BG-CURSOR                                  
              THRU 7100-EXIT.                                           
      ****************************************************************          
      **   READ FIRST OF CSS-BILLING-DETAIL USING ACCOUNT-NO AND                
      **    BILL-NO FROM THE ROW IN THE CSS-BILLING-HEADER                      
      ****************************************************************          
           PERFORM 7110-FETCH-BG-ROW                                    
              THRU 7110-EXIT.                                           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2510-PROCESS-BG-CURSOR THRU 2510-EXIT             
                 UNTIL NO-MORE-BGS                                      
           END-IF.                                                      
           PERFORM 7120-CLOSE-BG-CURSOR                                 
              THRU 7120-EXIT.                                           
           PERFORM 7055-FETCH-XFER-ROW THRU 7055-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'N' TO WS-MORE-SUBS-SW                               
           ELSE                                                         
              MOVE 'Y' TO WS-MORE-BGS-SW                                
           END-IF.                                                      
                                                                        
       2501-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2505-INIT-DETAIL-RETURN FIELDS                                 *        
      *                                                                         
      *   THIS ROUTINE WILL INITIALIZE ALL BILLING DETAIL COLUMNS               
      *   THAT ARE UNRELATED TO THE BILLING HEADER RECORDS TO BE                
      *   RETURNED.                                                             
      *                                                                         
      ******************************************************************        
      *                                                                         
       2505-INIT-WS-DETAIL-FIELDS.                                      
      *                                                                         
      *                                                                         
           MOVE SPACES                  TO WS-BILL-DATE-READ.           
           MOVE SPACES                  TO WS-CODE-UTIL-TYPE.           
           MOVE SPACES                  TO WS-ADDL-HIST.                
           MOVE SPACES                  TO WS-RATE-PLAN-DESC.           
           MOVE SPACES                  TO WS-CODE-USAGE-TYPE.          
           MOVE SPACES                  TO WS-CODE-BILL-ITM-IND.        
           MOVE SPACES                  TO WS-BILL-ITEM-TIMESTMP.       
           MOVE SPACES                  TO WS-SERV-ADDRESS.             
           MOVE SPACES                  TO WS-RATE-PLAN-NO.             
           MOVE 0                       TO WS-SUB-ACCOUNT-NO.           
           MOVE 0                       TO WS-AMT-BILL-ITEM.            
           MOVE 0                       TO WS-AMT-TAX.                  
           MOVE 0                       TO WS-NO-OF-DAYS.               
           MOVE 0                       TO WS-NO-UNITS.                 
           MOVE 0                       TO WS-IC-NO.                    
           MOVE 0                       TO WS-READ-UNITS.               
       2505-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2510-PROCESS-BG-CURSOR                                         *        
      *                                                                *        
      *     OBTAINS THE BILLING DETAILS DATA.                          *        
      ******************************************************************        
      *                                                                         
       2510-PROCESS-BG-CURSOR.                                          
      *                                                                         
           IF MASTER-ACCOUNT                                            
              PERFORM 2600-GET-SUB-ADDRESS                              
                 THRU 2600-EXIT                                         
           END-IF.                                                      
                                                                        
           IF WS-NULL-IND-2 < 0                                         
              MOVE SPACES               TO BG-DATE-ORIG-BILL            
           END-IF.                                                      
                                                                        
           MOVE SPACES            TO MN-MTR-READ-SOURCE-CD.             
           MOVE BG-ACCOUNT-NO     TO MN-ACCOUNT-NO.                     
           MOVE BG-IC-NO          TO MN-IC-NO.                          
           MOVE BG-CODE-UTIL-TYPE TO MN-CODE-UTIL-TYPE.                 
                                                                        
           PERFORM 7930-SEL-MTR-READ-CD                                 
              THRU 7930-EXIT.                                           
                                                                        
           MOVE MN-MTR-READ-SOURCE-CD   TO WS-MTR-READ-SOURCE-CD.       
                                                                        
           MOVE BG-CODE-UTIL-TYPE       TO WS-CODE-UTIL-TYPE.           
           MOVE BG-NO-OF-CONS-DAYS      TO WS-NO-OF-DAYS.               
           MOVE BG-IC-NO                TO WS-IC-NO.                    
           IF BG-REVENUE-MONTH > WS-HOLD-REV-MM                         
              MOVE BG-REVENUE-MONTH TO WS-HOLD-REV-MM                   
           END-IF.                                                      
           MOVE WS-HOLD-REV-MM               TO WS-HOLD-REV-MM-CHAR.    
           MOVE WS-HOLD-REV-MM-CHAR          TO WS-EMC-REV-MM.          
           MOVE WS-HOLD-REV-MM-CHAR (5:2)    TO WS-REVENUE-MONTH.       
                                                                        
      *    CHECK WHETHER THE RATE BELONGS TO INDUSTRIAL GAS OR NET-MTR          
           INITIALIZE WS-REG-TYPE-CD                                    
                      WS-BAL-FWD-CD.                                    
           PERFORM 7910-CHECK-INDUS-NETMTR-CUST                         
                                        THRU 7910-EXIT.                 
           IF WS-REG-TYPE-CD = 'D'                                      
              MOVE 'Y'                  TO WS-INDUST-GAS-CUST           
              MOVE WS-YES               TO WS-INDUS-GAS-CUST            
           ELSE                                                         
              MOVE 'N'                  TO WS-INDUST-GAS-CUST           
              MOVE WS-NO                TO WS-INDUS-GAS-CUST            
           END-IF.                                                      
                                                                        
           IF WS-BAL-FWD-CD > ' '                                       
              MOVE WS-YES               TO WS-NET-MTR-ACCOUNT           
           ELSE                                                         
              MOVE WS-NO                TO WS-NET-MTR-ACCOUNT           
           END-IF.                                                      
      *                                                                         
           MOVE 'N'                     TO WS-ELEC-INTRUPT-ACCT.        
           PERFORM 7980-CHK-ELEC-INTRUPT-ACCT THRU 7980-EXIT.           
           MOVE WS-ELEC-INTRUPT-ACCT    TO WS-ELEC-INTRUPT-ACCOUNT.     
                                                                        
           MOVE 'N'                     TO WS-ENABLE-BILL-CALC.         
           PERFORM 7990-GET-BILL-CALC-FL      THRU 7990-EXIT.           
           MOVE WS-ENABLE-BILL-CALC     TO WS-ENABLE-BILL-CALC-SW.      
                                                                        
           IF WS-DATE-BILLED > SPACES                                   
              MOVE 'N'                        TO WS-EMC-FLAG            
              IF WS-COBB-SNAPSHOAL = 'C' OR 'S'                         
                 IF WS-EMC-REV-MM  < WS-PARM-CUT-REV                    
                    MOVE 'Y'                     TO WS-EMC-FLAG         
                 END-IF                                                 
              END-IF                                                    
              IF INDUST-GAS-CUST                                        
                 MOVE PROGRAM-NAME      TO WS-PGRMNAME                  
                 PERFORM 6251-GET-FJC01-DATE                            
                                        THRU 6251-EXIT                  
                 MOVE WS-BILL-DATE-MMDDCCYY(7:2)                        
                                        TO WS-TEMP-CC                   
                 MOVE WS-BILL-DATE-MMDDCCYY(9:2)                        
                                        TO WS-TEMP-YY                   
                 MOVE WS-BILL-DATE-MMDDCCYY(1:2)                        
                                        TO WS-TEMP-MM                   
                 MOVE WS-BILL-DATE-MMDDCCYY(4:2)                        
                                        TO WS-TEMP-DD                   
                 IF WS-TEMP-DATE-CCYYMMDD < WS-CUT-OFF-DATE             
                    MOVE 'Y'            TO WS-CIG-FLAG                  
                 ELSE                                                   
                    MOVE 'N'            TO WS-CIG-FLAG                  
                 END-IF                                                 
              ELSE                                                      
                 MOVE 'N'               TO WS-CIG-FLAG                  
              END-IF                                                    
           END-IF.                                                      
           MOVE BG-CODE-UTIL-TYPE       TO RD-CODE-UTIL-TYPE            
                                           Q8-CODE-UTIL-TYPE.           
           MOVE BG-RATE-PLAN-NO         TO RD-RATE-PLAN-NO              
                                           Q8-RATE-PLAN-NO.             
           MOVE BG-CODE-REVENUE-CLASS   TO Q8-CODE-REVENUE-CLASS.       
                                                                        
           IF CSR-DATABASE AND WS-EWNA-FUTURE-HOOK-FL = 'Y'             
              PERFORM 7240-GET-WNA-GROUP-NO THRU 7240-EXIT              
              IF Q8-ELEC-WNA-GROUP-NO = 0 THEN                          
                 MOVE 'N'               TO WS-EWNA-FUTURE-HOOK-FL       
              END-IF                                                    
           END-IF.                                                      
      *    ADDED THE FOLLOWING PROCEDURE.                                       
           PERFORM 2535-CALC-BG-TAXES   THRU 2535-EXIT.                 
                                                                        
           PERFORM 7300-SELECT-RD  THRU 7300-EXIT.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE RD-RATE-DESC         TO WS-RATE-PLAN-DESC            
           ELSE                                                         
              MOVE BG-RATE-PLAN-NO      TO WS-RATE-PLAN-DESC            
           END-IF.                                                      
                                                                        
           MOVE BG-RATE-PLAN-NO         TO WS-RATE-PLAN-NO              
           MOVE BG-RT-PKG-OPT-SEQ-NO    TO WS-RT-PKG-OPT-SEQ-NO         
                                                                        
      *    MOVE 'DATABASE'              TO C8-DELINQ-CD                         
      *    MOVE AT-COMPANY-NO           TO C8-COMPANY-NO                        
      *    PERFORM 7530-GET-DATABASE    THRU 7530-EXIT                          
                                                                        
           IF SEB-DATABASE                                              
              IF BG-RT-PKG-OPT-SEQ-NO > 0                               
                 MOVE BG-ACCOUNT-NO     TO DF-ACCOUNT-NO                
                 MOVE BG-CODE-UTIL-TYPE TO DF-CODE-UTIL-TYPE            
                 MOVE BG-IC-NO          TO DF-IC-NO                     
                 MOVE BG-RT-PKG-OPT-SEQ-NO                              
                                        TO DF-RT-PKG-OPT-SEQ-NO         
                 PERFORM 7540-GET-OPTION-DESC                           
                    THRU 7540-EXIT                                      
                                                                        
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE FI-OPT-DESC-INT TO WS-RATE-PLAN-DESC           
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF BG-DATE-ORIG-BILL GREATER SPACES                          
              IF BG-CODE-BILL-ITM-TYPE = 'B'                            
                 MOVE 'B' TO WS-CODE-BILL-ITM-IND                       
              ELSE                                                      
                 IF BG-CODE-BILL-ITM-TYPE = 'C'                         
                    IF BG-CODE-BILL-ITM-IND = 'K'                       
                       MOVE 'C' TO WS-CODE-BILL-ITM-IND                 
                    ELSE                                                
                       MOVE 'R' TO WS-CODE-BILL-ITM-IND                 
                    END-IF                                              
                 ELSE                                                   
                    MOVE 'U' TO WS-CODE-BILL-ITM-IND                    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF BG-DATE-ORIG-BILL EQUAL SPACES                            
              IF BG-CODE-BILL-ITM-TYPE = 'C' AND                        
                 BG-CODE-BILL-ITM-IND = 'J' OR 'K'                      
                 MOVE 'C' TO WS-CODE-BILL-ITM-IND                       
              ELSE                                                      
                 IF BG-CODE-BILL-ITM-TYPE = 'C' AND                     
                    BG-CODE-BILL-ITM-IND = 'A' OR 'S' OR 'T'            
                    MOVE BG-CODE-BILL-ITM-IND TO WS-CODE-BILL-ITM-IND   
                 ELSE                                                   
                    MOVE 'U' TO WS-CODE-BILL-ITM-IND                    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE BG-CODE-BILL-CALC TO WS-CODE-BILL-CALC.                 
                                                                        
           MOVE BG-ACCOUNT-NO         TO CX-ACCOUNT-NO                  
                                         BZ-ACCOUNT-NO                  
                                         UC-ACCOUNT-NO                  
                                         CP-ACCOUNT-NO                  
                                         BI-ACCOUNT-NO.                 
                                                                        
           MOVE BG-CODE-UTIL-TYPE     TO CX-CODE-UTIL-TYPE              
                                         BZ-CODE-UTIL-TYPE              
                                         CP-CODE-UTIL-TYPE              
                                         UC-CODE-UTIL-TYPE.             
                                                                        
           MOVE BG-IC-NO              TO CX-IC-NO                       
                                         BZ-IC-NO                       
                                         CP-IC-NO                       
                                         UC-IC-NO.                      
                                                                        
           MOVE BG-BILL-NO            TO CX-BILL-NO                     
                                         BZ-BILL-NO                     
                                         UC-BILL-NO.                    
                                                                        
           MOVE BG-BILL-ITEM-TIMESTMP TO CX-BILL-ITEM-TIMESTMP          
                                         BZ-BILL-ITEM-TIMESTMP          
                                         WS-BILL-ITEM-TIMESTMP          
                                         UC-BILL-ITEM-TIMESTMP.         
                                                                        
      *    IF  WS-CODE-BUDGET = 'A'                                             
      *        NEXT SENTENCE                                                    
      *    ELSE                                                                 
               IF  BG-CODE-DR-CR-CNSMPTN = 'C'                          
                   SUBTRACT BG-AMT-BILL-ITEM FROM WS-TOTAL-BG-DOLLARS   
               ELSE                                                     
                   ADD BG-AMT-BILL-ITEM TO WS-TOTAL-BG-DOLLARS          
               END-IF                                                   
      *    END-IF                                                               
                                                                        
           MOVE 'N'                 TO WS-UNMTRD-ELEC-GAS               
           PERFORM 7350-CUST-PLAN-EXISTS  THRU 7350-EXIT                
                                                                        
           IF BG-CODE-UTIL-TYPE EQUAL 'U'                               
              PERFORM 2515-UNMETERED-CNSMPTN                            
                 THRU 2515-EXIT                                         
           ELSE                                                         
              IF WS-UNMTRD-ELEC-GAS = 'Y'                               
                 PERFORM 2515-UNMETERED-CNSMPTN                         
                         THRU 2515-EXIT                                 
              ELSE                                                      
                 MOVE 'N'                 TO WS-UNMTRD-ELEC-GAS         
                 PERFORM 2520-METERED-CNSMPTN                           
                    THRU 2520-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7110-FETCH-BG-ROW                                    
              THRU 7110-EXIT.                                           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'N' TO WS-MORE-BGS-SW                                
           END-IF.                                                      
                                                                        
      *    MOVE ZEROES                  TO WS-AMT-TAXES.                        
       2510-EXIT.                                                       
           EXIT.                                                        
HPCCDM*     EJECT                                                               
      *                                                                         
      ******************************************************************        
      * 2515-UNMETERED-CNSMPTN                                         *        
      *                                                                *        
      *     OBTAINS AND SENDS THE UNMETERD CONSUMPTION DATA            *        
      ******************************************************************        
      *                                                                         
       2515-UNMETERED-CNSMPTN.                                          
      *                                                                         
           MOVE ZEROES               TO WS-NO-UNITS                     
                                        WS-READ-UNITS                   
                                        WS-AMT-BILL-ITEM.               
           MOVE SPACES               TO WS-CODE-USAGE-TYPE.             
           MOVE SPACES               TO WS-BILL-DATE-READ.              
           PERFORM 7700-OPEN-UC-CURSOR                                  
              THRU 7700-EXIT.                                           
           PERFORM 7710-FETCH-UC-ROW                                    
              THRU 7710-EXIT.                                           
                                                                        
      * SEE 2535-CALC-BG-TAXES                                                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                                                        
              MOVE SPACES               TO WS-BILL-DATE-READ            
              MOVE 'U'                  TO WS-CODE-USAGE-TYPE           
                                                                        
              PERFORM 2550-PROCESS-UC-CURSOR                            
                 THRU 2550-EXIT                                         
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                                                                        
              IF WS-BILL-DATE-READ NOT EQUAL SPACES                     
                 PERFORM 2525-FORMAT-DATE-READ                          
                    THRU 2525-EXIT                                      
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES               TO WS-BILL-DATE-READ            
                                           WS-CODE-USAGE-TYPE           
              MOVE ZEROES               TO WS-NO-UNITS                  
              MOVE ZEROES               TO WS-AMT-BILL-ITEM             
              MOVE ZEROES               TO WS-READ-UNITS                
           END-IF.                                                      
                                                                        
           PERFORM 7720-CLOSE-UC-CURSOR                                 
              THRU 7720-EXIT.                                           
                                                                        
           PERFORM 7600-OPEN-BZ-CURSOR                                  
              THRU 7600-EXIT.                                           
           PERFORM 7610-FETCH-BZ-ROW                                    
              THRU 7610-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2560-PROC-BZ-UNMETERED                            
                 THRU 2560-EXIT                                         
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
           ELSE                                                         
              COMPUTE WS-AMT-BILL-ITEM =                                
                      BG-AMT-BILL-ITEM - WS-AMT-TAXES                   
              IF BG-CODE-DR-CR-CNSMPTN = 'C'                            
                 COMPUTE WS-AMT-BILL-ITEM = WS-AMT-BILL-ITEM * -1       
              END-IF                                                    
              MOVE SPACES               TO WS-CODE-USAGE-TYPE           
              PERFORM 2000A-LOAD-RESULT THRU 2000A-EXIT                 
              MOVE ZEROES TO WS-AMT-TAXES, WS-AMT-TAX                   
           END-IF.                                                      
                                                                        
           PERFORM 7620-CLOSE-BZ-CURSOR                                 
              THRU 7620-EXIT.                                           
                                                                        
       2515-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2520-METERED-CNSMPTN                                           *        
      *                                                                *        
      *     OBTAINES AND SENDS THE METERD CONSUMPTION DATA.            *        
      ******************************************************************        
      *                                                                         
       2520-METERED-CNSMPTN.                                            
      *                                                                         
           MOVE ZEROES                  TO WS-NO-UNITS                  
                                           WS-READ-UNITS                
                                           WS-AMT-BILL-ITEM.            
           MOVE ZEROES                  TO WS-ACCUM-NO-UNITS            
                                           WS-ACCUM-READ-UNITS          
                                           WS-ACCUM-UNITS-TP.           
           MOVE SPACES                  TO WS-CODE-USAGE-TYPE.          
                                                                        
           PERFORM 7800-OPEN-CX-CURSOR                                  
              THRU 7800-EXIT.                                           
           PERFORM 7810-FETCH-CX-ROW                                    
              THRU 7810-EXIT.                                           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CX-DATE-READ         TO WS-DATE-READ                 
              PERFORM 2525-FORMAT-DATE-READ                             
                 THRU 2525-EXIT                                         
              MOVE CX-CODE-ITEM-STATUS  TO WS-HOLD-CODE-ITEM-STATUS     
              MOVE SPACES               TO WS-DATE-READ-COMPARE         
              MOVE CX-MTR-REF-NO        TO WS-MTR-REF-COMP              
              MOVE CX-REG-ID-NO         TO WS-REG-ID-COMP               
              MOVE CX-CODE-TIME-PERIOD  TO WS-TP-COMP                   
              MOVE ZEROES               TO WS-ACCUM-NO-UNITS            
                                           WS-ACCUM-NO-KW               
                                           WS-ACCUM-NO-KVA              
                                           WS-ACCUM-NO-DAYS             
                                           WS-TP-HOLD                   
                                           WS-ACCUM-UNITS-TP            
                                           WS-ACCUM-READ-UNITS          
              PERFORM 2540-ACCUM-NO-DAYS                                
                 THRU 2540-EXIT                                         
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
              IF WS-NO-OF-DAYS = 0                                      
                 MOVE WS-ACCUM-NO-DAYS TO WS-NO-OF-DAYS                 
                                          WS-NO-DAYS                    
              ELSE                                                      
                 MOVE WS-NO-OF-DAYS    TO WS-NO-DAYS                    
              END-IF                                                    
           ELSE                                                         
      *       IF BG-CODE-REVENUE-CLASS = '000' AND                              
      *          AT-CODE-COMPANY-ACCT  NOT EQUAL 'B' AND                        
              IF BG-REV-RPT-CD = 'T' AND                                
                 WS-INDUST-GAS-CUST = 'Y'                               
                 IF WS-DATE-BILLED EQUAL SPACES                         
                    MOVE ZEROES         TO WS-NO-UNITS                  
                                           WS-READ-UNITS                
                 END-IF                                                 
                 MOVE WS-NO-DAYS        TO WS-NO-OF-DAYS                
              END-IF                                                    
      *       MOVE ZEROES               TO WS-NO-OF-DAYS                        
              MOVE SPACES               TO WS-BILL-DATE-READ            
              MOVE SPACES               TO WS-CODE-USAGE-TYPE           
                                           WS-HOLD-CODE-ITEM-STATUS     
           END-IF.                                                      
                                                                        
           PERFORM 7820-CLOSE-CX-CURSOR                                 
              THRU 7820-EXIT.                                           
                                                                        
           PERFORM 7600-OPEN-BZ-CURSOR                                  
              THRU 7600-EXIT.                                           
                                                                        
           PERFORM 7610-FETCH-BZ-ROW                                    
              THRU 7610-EXIT.                                           
                                                                        
      *  SEE 2535-CALC-BG-TAXES                                                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE BZ-CONSUMPT-TYPE-CD  TO WS-CODE-USAGE-TYPE           
              PERFORM 2530-PROCESS-BZ-CURSOR THRU 2530-EXIT             
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
           ELSE                                                         
              IF WS-ACCUM-UNITS-TP > 0                                  
                MOVE WS-ACCUM-UNITS-TP    TO WS-NO-UNITS                
              ELSE                                                      
                MOVE WS-ACCUM-NO-UNITS    TO WS-NO-UNITS                
              END-IF                                                    
              MOVE WS-ACCUM-READ-UNITS    TO WS-READ-UNITS              
              COMPUTE WS-AMT-BILL-ITEM =                                
                     (BG-AMT-BILL-ITEM - WS-AMT-TAXES)                  
              IF BG-CODE-DR-CR-CNSMPTN = 'C'                            
                 COMPUTE WS-AMT-BILL-ITEM = WS-AMT-BILL-ITEM * -1       
              END-IF                                                    
              IF WS-CODE-UTIL-TYPE = 'E'                                
                 MOVE 'B'               TO WS-CODE-USAGE-TYPE           
              ELSE                                                      
                 IF WS-CODE-UTIL-TYPE = 'G'                             
                    MOVE 'T'             TO WS-CODE-USAGE-TYPE          
                 END-IF                                                 
              END-IF                                                    
              IF BG-CODE-BILL-ITM-TYPE = 'B'                            
                 AND BG-DATE-ORIG-BILL  NOT = SPACES                    
                 PERFORM 7900-GET-BILL-UNITS                            
                       THRU 7900-EXIT                                   
                 MOVE WS-ACCUM-NO-UNITS    TO WS-NO-UNITS               
                 MOVE WS-ACCUM-READ-UNITS  TO WS-READ-UNITS             
                 IF WS-CODE-UTIL-TYPE = 'E'                             
                    MOVE 'B'               TO WS-CODE-USAGE-TYPE        
                 ELSE                                                   
                    IF WS-CODE-UTIL-TYPE = 'G'                          
                       MOVE 'C'             TO WS-CODE-USAGE-TYPE       
                       IF WS-INDUST-GAS-CUST = 'Y'                      
                          MOVE 'D'          TO WS-CODE-USAGE-TYPE       
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
              PERFORM 2000A-LOAD-RESULT THRU 2000A-EXIT                 
              MOVE ZEROES              TO WS-AMT-TAXES                  
                                          WS-AMT-TAX
           END-IF.                   
                                                                        
                                                                        
           PERFORM 7620-CLOSE-BZ-CURSOR                                 
              THRU 7620-EXIT.                                           
       2520-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2525-FORMAT-DATE-READ                                          *        
      *                                                                *        
      *     REFORMATS DATE INTO MMDDCCYY FORMAT.                       *        
      ******************************************************************        
      *                                                                         
       2525-FORMAT-DATE-READ.                                           
      *                                                                         
            MOVE WS-CCYY OF WS-DATE-READ                                
                                   TO WS-CCYY OF WS-DATE-READ-MMDDCCYY. 
            MOVE WS-MM OF WS-DATE-READ                                  
                                   TO WS-MM OF WS-DATE-READ-MMDDCCYY.   
            MOVE WS-DD OF WS-DATE-READ                                  
                                   TO WS-DD OF WS-DATE-READ-MMDDCCYY.   
            MOVE WS-DATE-READ-MMDDCCYY                                  
                                   TO WS-BILL-DATE-READ.                
       2525-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2530-PROCESS-BZ-CURSOR                                         *        
      *                                                                *        
      *     OBTAINES AND SENDS THE METERD CONSUMPTION DATA.            *        
      ******************************************************************        
       2530-PROCESS-BZ-CURSOR.                                          
                                                                        
           IF BZ-BILL-UNITS NOT NUMERIC                                 
              MOVE ZEROES TO BZ-BILL-UNITS                              
           END-IF.                                                      
                                                                        
           IF BZ-READ-UNITS NOT NUMERIC                                 
              MOVE ZEROES TO BZ-READ-UNITS                              
           END-IF.                                                      
                                                                        
           IF BZ-BILLED-COMP-AM NOT NUMERIC                             
              MOVE ZEROES TO BZ-BILLED-COMP-AM                          
           END-IF.                                                      
                                                                        
           IF WS-CODE-USAGE-TYPE = BZ-CONSUMPT-TYPE-CD                  
              IF(BZ-CMPNT-ID-CD NOT EQUAL '70' AND                      
                 BZ-CMPNT-ID-CD NOT EQUAL '71')                         
                 ADD BZ-BILL-UNITS      TO WS-NO-UNITS                  
                 ADD BZ-READ-UNITS      TO WS-READ-UNITS                
              END-IF                                                    
              ADD BZ-BILLED-COMP-AM  TO WS-AMT-BILL-ITEM                
           ELSE                                                         
      *       IF WS-CODE-UTIL-TYPE = 'G'                                        
      *          MULTIPLY BG-BTU-FACTOR BY WS-NO-UNITS                          
      *            GIVING WS-NO-UNITS ROUNDED                                   
      *       END-IF                                                            
              PERFORM 2000A-LOAD-RESULT THRU 2000A-EXIT                 
              MOVE ZEROES              TO WS-AMT-TAXES                  
                                          WS-AMT-TAX                    
              MOVE BZ-CONSUMPT-TYPE-CD TO WS-CODE-USAGE-TYPE            
              MOVE BZ-BILL-UNITS       TO WS-NO-UNITS                   
              MOVE BZ-READ-UNITS       TO WS-READ-UNITS                 
              MOVE BZ-BILLED-COMP-AM   TO WS-AMT-BILL-ITEM              
           END-IF.                                                      
                                                                        
           PERFORM 7610-FETCH-BZ-ROW                                    
              THRU 7610-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  NOT-FOUND                   
              PERFORM 2000A-LOAD-RESULT THRU 2000A-EXIT                 
              MOVE ZEROES              TO WS-AMT-TAXES                  
                                          WS-AMT-TAX                    
              MOVE NOT-FOUND           TO WS-ACTIVE-RETURN-CODE         
           END-IF.                                                      
                                                                        
       2530-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * THIS PROCESS HAS BEEN ADDED TO RATIONALISE TAX CALCULATION              
      * SO THAT IT IS DONE JUST AT ONE POINT OF TIME DURING PROCESSING.         
      * - M ROUTH 7/17/96                                                       
      ****************************************************************          
       2535-CALC-BG-TAXES.                                              
      *                                                                         
           MOVE ZEROES                 TO WS-AMT-TAXES                  
                                          WS-AMT-TAX.                   
                                                                        
           ADD BG-AMT-STATE-TAX                                         
               BG-AMT-CITY-TAX                                          
               BG-AMT-OTHER-TAX         TO WS-AMT-TAXES.                
                                                                        
           IF WS-AMT-TAXES NOT = ZEROES                                 
              MOVE WS-AMT-TAXES         TO WS-AMT-TAX                   
           END-IF.                                                      
           IF BG-CODE-DR-CR-CNSMPTN = 'C'                               
              COMPUTE WS-AMT-TAX   = WS-AMT-TAX   * -1                  
           END-IF.                                                      
                                                                        
       2535-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      *                                                                         
       2540-ACCUM-NO-DAYS.                                              
      *                                                                         
           IF (CX-CODE-USAGE-TYPE = 'B' OR 'C')                         
              AND CX-MTR-REF-NO    = WS-MTR-REF-COMP                    
              AND CX-CODE-TIME-PERIOD = 0                               
              AND CX-CODE-DEBIT-CREDIT = 'D'                            
              ADD CX-NO-DAYS    TO  WS-ACCUM-NO-DAYS                    
              MOVE CX-MTR-REF-NO TO WS-MTR-REF-COMP                     
           END-IF.                                                      
           IF (CX-CODE-USAGE-TYPE = 'B' OR 'C')                         
             AND CX-CODE-TIME-PERIOD = 0                                
             IF CX-CODE-DEBIT-CREDIT = 'C'                              
                SUBTRACT CX-NO-UNITS FROM WS-ACCUM-NO-UNITS             
             ELSE                                                       
                ADD CX-NO-UNITS      TO WS-ACCUM-NO-UNITS               
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF CX-CODE-USAGE-TYPE = 'B'                                  
             AND CX-CODE-TIME-PERIOD > 0                                
             AND CX-CODE-TOU-SEASN   = 'C'                              
               ADD CX-NO-UNITS   TO WS-ACCUM-UNITS-TP                   
           END-IF.                                                      
                                                                        
           IF ((CX-CODE-USAGE-TYPE = 'E' OR 'J')                        
             AND CX-DATE-READ NOT = WS-DATE-READ-COMPARE)               
             AND CX-MTR-REF-NO    = WS-MTR-REF-COMP                     
             AND CX-REG-ID-NO     = WS-REG-ID-COMP                      
             AND CX-CODE-TIME-PERIOD = WS-TP-COMP                       
      *       ADD CX-NO-DAYS           TO  WS-ACCUM-NO-DAYS                     
              MOVE CX-NO-DEMAND-UNITS  TO WS-ACCUM-NO-KVA               
              MOVE CX-DATE-READ        TO WS-DATE-READ-COMPARE          
              MOVE CX-MTR-REF-NO TO WS-MTR-REF-COMP                     
              MOVE CX-REG-ID-NO  TO WS-REG-ID-COMP                      
              MOVE CX-CODE-TIME-PERIOD TO WS-TP-COMP                    
           END-IF.                                                      
                                                                        
           PERFORM 7810-FETCH-CX-ROW    THRU  7810-EXIT.                
       2540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2550-PROCESS-UC-CURSOR.                                          
                                                                        
           IF UC-DATE-USAGE-ENDS > WS-BILL-DATE-READ                    
              AND WS-NULL-IND NOT < ZERO                                
              MOVE UC-DATE-USAGE-ENDS   TO WS-DATE-READ                 
           END-IF.                                                      
                                                                        
      *    IF UC-NO-DAYS GREATER THAN WS-NO-OF-DAYS                             
      *       MOVE UC-NO-DAYS        TO WS-NO-OF-DAYS                           
      *    END-IF.                                                              
      *                                                                         
           IF UC-CODE-DEBIT-CREDIT = 'C'                                
              SUBTRACT UC-NO-UNITS FROM WS-NO-UNITS                     
              SUBTRACT UC-NO-UNITS FROM WS-READ-UNITS                   
           ELSE                                                         
              ADD UC-NO-UNITS      TO   WS-NO-UNITS                     
              ADD UC-NO-UNITS      TO   WS-READ-UNITS                   
           END-IF.                                                      
      *                                                                         
      *    ADD UC-NO-UNITS           TO WS-NO-UNITS.                            
      *    ADD UC-NO-UNITS           TO WS-READ-UNITS.                          
                                                                        
           PERFORM 7710-FETCH-UC-ROW                                    
              THRU 7710-EXIT.                                           
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2560-PROC-BZ-UNMETERED.                                          
                                                                        
           IF BZ-BILLED-COMP-AM NOT NUMERIC                             
              MOVE ZEROES TO BZ-BILLED-COMP-AM                          
           END-IF.                                                      
                                                                        
           ADD BZ-BILLED-COMP-AM  TO WS-AMT-BILL-ITEM                   
                                                                        
           PERFORM 7610-FETCH-BZ-ROW                                    
              THRU 7610-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 2000A-LOAD-RESULT THRU 2000A-EXIT                 
              MOVE ZEROES              TO WS-AMT-TAXES                  
                                          WS-AMT-TAX                    
              MOVE NOT-FOUND           TO WS-ACTIVE-RETURN-CODE
           END-IF.        
                                                                        
       2560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       2600-GET-SUB-ADDRESS.                                            
      *                                                                         
           MOVE ZEROES TO WS-SUB-ACCOUNT-NO.                            
           MOVE SPACES TO WS-SERV-ADDRESS.                              
                                                                        
           MOVE AF-ACCT-XFER-FROM TO HT-ACCOUNT-NO                      
                                     WS-SUB-ACCOUNT-NO.                 
           PERFORM 7260-SELECT-ADDR-ID                                  
              THRU 7260-EXIT.                                           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE HT-ADDRESS-ID TO DY-ADDRESS-ID                       
              PERFORM 7270-SELECT-DY                                    
                 THRU 7270-EXIT                                         
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE DY-HOUSE-NO          TO WS-HOUSE-NO                  
              MOVE DY-ADDR-PREFIX-1     TO WS-ADDR-PREFIX-1             
              MOVE DY-ADDR-PREFIX-2     TO WS-ADDR-PREFIX-2             
              MOVE DY-STREET-NAME       TO WS-STREET-NAME               
              MOVE DY-STREET-LOCATION-1 TO WS-STREET-LOCATION-1         
              MOVE DY-STREET-LOCATION-2 TO WS-STREET-LOCATION-2         
              MOVE DY-STREET-SUFFIX     TO WS-STREET-SUFFIX             
              MOVE DY-ZIP-CODE          TO WS-ZIP-CODE                  
           ELSE                                                         
              MOVE SPACES               TO WS-HOUSE-NO                  
              MOVE SPACES               TO WS-ADDR-PREFIX-1             
              MOVE SPACES               TO WS-ADDR-PREFIX-2             
              MOVE SPACES               TO WS-STREET-NAME               
              MOVE SPACES               TO WS-STREET-LOCATION-1         
              MOVE SPACES               TO WS-STREET-LOCATION-2         
              MOVE SPACES               TO WS-STREET-SUFFIX             
              MOVE SPACES               TO WS-ZIP-CODE                  
           END-IF.                                                      
           MOVE WS-SERV-ADDR                 TO WS-EMB-INPUT.           
           MOVE 81                           TO WS-EMB-LENG.            
           MOVE SPACES                       TO WS-CMP-TABLE.           
           PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
           MOVE WS-CMP-TABLE                 TO WS-SERV-ADDRESS.        
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5000-INCRMT-REV-MONTHS.                                        *        
      *     ADD REVENUE MONTHS.                                        *        
      ******************************************************************        
       5000-INCRMT-REV-MONTHS.                                          
                                                                        
           MOVE 1                           TO WS-ADD-R.                
           PERFORM 5050-GET-NEXT-REV-MONTH  THRU 5050-EXIT              
             UNTIL WS-ADD-R > WS-MONTHS-TO-ADD.                         
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5050-GET-NEXT-REV-MONTH.                                       *        
      *     STEPUP BY 1 MONTH FROM THE INPUT REVENUE MONTH             *        
      ******************************************************************        
       5050-GET-NEXT-REV-MONTH.                                         
                                                                        
           ADD 1                           TO WS-ADD-R.                 
           MOVE WS-INPUT-REV-MONTH(1:4)    TO WS-START-YR.              
           MOVE WS-INPUT-REV-MONTH(5:2)    TO WS-START-MT.              
           MOVE WS-START-YR                TO WS-START-YR-N.            
           MOVE WS-START-MT                TO WS-START-MT-N.            
           COMPUTE WS-START-MT-N = WS-START-MT-N + 1.                   
           IF WS-START-MT-N > 12                                        
              COMPUTE WS-START-YR-N = WS-START-YR-N + 1                 
              MOVE 01                      TO WS-START-MT-N             
           END-IF.                                                      
           MOVE WS-START-YR-N              TO WS-INPUT-REV-MONTH(1:4).  
           MOVE WS-START-MT-N              TO WS-INPUT-REV-MONTH(5:2).  
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
       COPY CPD00004.                                                           
                                                                        
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      *     CALLS 7600-START-FCSJC01                                   *        
      *           7610-READ-FCSJC01                                    *        
      *           7611-CLOSE                                           *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      ******************************************************************        
       6251-GET-FJC01-DATE.                                             
      *                                                                         
           MOVE  WS-PGRMNAME TO WS-PROGRAM.                             
           MOVE  WS-DATE     TO WS-COMMAND.                             
           MOVE  ZEROS       TO WS-SEQUENCE.                            
           MOVE  SPACES      TO WS-SYSIPT.                              
           MOVE  WS-KEY-AREA TO E-FJC01-KEY.                            
           PERFORM 7600-START-FCSJC01  THRU  7600-FCSJC01-EXIT.         
           PERFORM 7610-READ-FCSJC01   THRU  7610-FCSJC01-EXIT          
               UNTIL CUT-OFF-DATE OR END-OF-SYSIPT.                     
      *                                                                         
           IF NOT END-OF-SYSIPT                                         
                    AND WS-INPUT-CUT-DATE-MM  NUMERIC                   
                    AND WS-INPUT-CUT-DATE-DD  NUMERIC                   
                    AND WS-INPUT-CUT-DATE-CC  NUMERIC                   
                    AND WS-INPUT-CUT-DATE-YY  NUMERIC                   
               PERFORM 7611-CLOSE THRU 7611-EXIT                        
               MOVE  WS-INPUT-CUT-DATE   TO    WS-CUT-OFF-DATE          
           END-IF.                                                      
      *                                                                         
       6251-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7000-OPEN-BI-CURSOR.                                             
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **        
      **  ROWS FROM THE CSS_BILLING_HDR TABLE.                        **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               OPEN BI-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE '7000'              TO ACTIVE-PARAGRAPH             
               MOVE 'OPEN'              TO ABEND-FUNCTION               
               MOVE SPACES              TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
               MOVE 'CSS_BILLING_HDR  ' TO TABLE-1                      
               MOVE 'ACCOUNT_NO  '      TO TABLE-ELEMENT-1              
               MOVE BI-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7010-FETCH-BI-ROW.                                               
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **        
      **  CSS_BILLING_HDR TABLE WHERE THE ACCOUNT NUMBER IS EQUAL TO  **        
      **  THE ACCOUNT NUMBER PASSED TO THIS PROGRAM VIA THE           **        
      **  COMMUNICATION AREA ACCOUNT NUMBER.                          **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               FETCH BI-CURSOR                                          
                INTO :BI-BILL-NO,                                       
                     :BI-DATE-BILLED :WS-NULL-IND-HEADER,               
                     :BI-CODE-BILL-TYPE,                                
                     :BI-CODE-BILL-STATUS,                              
                     :BI-TOT-OTHER-CHARGES,                             
                     :BI-TOTAL-ARREARS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1                   TO WS-ROW-COUNT                 
           ELSE                                                         
           IF  WS-ACTIVE-RETURN-CODE  = NOT-FOUND                       
               MOVE 'Y'                 TO END-OF-BG-SW                 
               MOVE 9999                TO WS-PARM-BILL-NO              
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
               MOVE '7010'              TO ACTIVE-PARAGRAPH             
               MOVE 'FETCH'             TO ABEND-FUNCTION               
               MOVE SPACES              TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_BILLING_HDR  '  TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE BI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
       7020-CLOSE-BI-CURSOR.                                            
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_BILLING_HDR TABLE.                        **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               CLOSE BI-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7020'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_BILLING_HDR  '  TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE BI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7020-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
       7050-OPEN-XFER-CURSOR.                                           
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **        
      **  ROWS FROM THE CSS_XFER_ACCT TABLE.                          **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               OPEN XFER-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_ACCT_XFER'       TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE AF-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AF-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7050-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      *                                                                         
       7055-FETCH-XFER-ROW.                                             
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **        
      **  CSS_XFER_ACCT TABLE WHERE THE MASTER ACCT NO IS EQUAL TO    **        
      **  THE ACCOUNT NUMBER PASSED TO THIS PROGRAM VIA THE           **        
      **  COMMUNICATION AREA ACCOUNT NUMBER AND THE BILL NUMBER IS    **        
      **  EQUAL THE CURRENT CSS_BILLING_HDR ROW BILL NUMBER.          **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               FETCH XFER-CURSOR                                        
               INTO :AF-BILL-NO-XFER-FROM,                              
                    :AF-ACCT-XFER-FROM                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7055'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_ACCT_XFER'       TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE AF-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AF-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7055-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
       7060-CLOSE-XFER-CURSOR.                                          
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_XFER_ACCT TABLE.                          **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               CLOSE XFER-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7060'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_ACCT_XFER'       TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
              MOVE AF-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AF-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7060-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
       7100-OPEN-BG-CURSOR.                                             
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **        
      **  ROWS FROM THE CSS_BILLING_DET TABLE.                        **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               OPEN BG-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET  '        TO TABLE-1                
              MOVE 'BILL_NO  '                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-2        
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-1      
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      *                                                                         
       7110-FETCH-BG-ROW.                                               
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **        
      **  CSS_BILLING_DET TABLE WHERE THE ACCOUNT NUMBER IS EQUAL TO  **        
      **  THE ACCOUNT NUMBER PASSED TO THIS PROGRAM VIA THE           **        
      **  COMMUNICATION AREA ACCOUNT NUMBER AND THE BILL NUMBER IS    **        
      **  EQUAL THE CURRENT CSS_BILLING_HDR ROW BILL NUMBER.          **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               FETCH BG-CURSOR                                          
               INTO :BG-CODE-UTIL-TYPE,                                 
                    :BG-IC-NO,                                          
                    :BG-AMT-BILL-ITEM,                                  
                    :BG-AMT-STATE-TAX,                                  
                    :BG-AMT-CITY-TAX,                                   
                    :BG-AMT-OTHER-TAX,                                  
                    :BG-CODE-REVENUE-CLASS,                             
                    :BG-CODE-BILL-CALC,                                 
                    :BG-CODE-BILL-ITM-IND,                              
                    :BG-CODE-BILL-ITM-TYPE,                             
                    :BG-CODE-DR-CR-CNSMPTN,                             
                    :BG-RATE-PLAN-NO,                                   
                    :BG-BILL-ITEM-TIMESTMP,                             
                    :BG-REVENUE-MONTH,                                  
                    :BG-DATE-ORIG-BILL :WS-NULL-IND-2,                  
                    :BG-BTU-FACTOR,                                     
                    :BG-ACCOUNT-NO,                                     
                    :BG-BILL-NO,                                        
                    :BG-NO-OF-CONS-DAYS,                                
                    :BG-REV-RPT-CD,                                     
                    :BG-RT-PKG-OPT-SEQ-NO                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE WS-DETAIL-REC-ID   TO WS-RECORD-ID                  
           ELSE                                                         
           IF  WS-ACTIVE-RETURN-CODE  = NOT-FOUND                       
              MOVE 'N' TO WS-MORE-BGS-SW                                
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET  '        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO  '                TO TABLE-ELEMENT-2        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF
           END-IF.           
       7110-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
       7118-SELECT-COBB-SNAPSHOAL.                                      
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO SELECT THE ORIGINATION CODE       **        
      **  FIELD FROM THE CSS-MKT-XFER-ACCT TABLE.                     **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) XM.ORIGINATION_CD                                   
               INTO :WS-COBB-SNAPSHOAL                                  
               FROM CSS_MKT_XREF_ACCT XM WITH(READUNCOMMITTED)                  
              WHERE XM.ACCOUNT_NO  = :XM-ACCOUNT-NO                     
                                                    
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT XM.ORIGINATION_CD                                           
MFA-TR*        INTO :WS-COBB-SNAPSHOAL                                          
MFA-TR*        FROM CSS_MKT_XREF_ACCT XM                                        
MFA-TR*       WHERE XM.ACCOUNT_NO  = :XM-ACCOUNT-NO                             
MFA-TR*      FETCH FIRST ROW ONLY                                               
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7118'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MKT_XREF_ACCT'        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE XM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7118-EXIT.                                                       
            EXIT.                                                       
HPCCDM*     EJECT                                                               
       7120-CLOSE-BG-CURSOR.                                            
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_BILLING_DET TABLE.                        **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               CLOSE BG-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILLING_DET  '        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'BILL_NO  '                TO TABLE-ELEMENT-2        
              MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BG-BILL-NO                 TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7120-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
       7200-SELECT-AT.                                                  
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO SELECT THE CODES-DATA-PRESENT     **        
      **  FIELD FROM THE CSS-ACCOUNT TABLE.                           **        
      ******************************************************************        
           EXEC SQL                                                     
              SELECT CODES_DATA_PRESENT,                                
                     MST_SUB_ACCT_IND,                                  
                     COMPANY_NO,                                        
                     CODE_COMPANY_ACCT,                                 
                     REV_MTH_LST_NRML,                                  
                     BILL_CYCLE                                         
               INTO :AT-CODES-DATA-PRESENT,                             
                    :AT-MST-SUB-ACCT-IND,                               
                    :AT-COMPANY-NO,                                     
                    :AT-CODE-COMPANY-ACCT,                              
                    :AT-REV-MTH-LST-NRML,                               
                    :AT-BILL-CYCLE                                      
                   FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                       
                   WHERE  ACCOUNT_NO      =  :AT-ACCOUNT-NO             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODES_DATA_PRESENT,                                        
MFA-TR*              MST_SUB_ACCT_IND,                                          
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              CODE_COMPANY_ACCT,                                         
MFA-TR*              REV_MTH_LST_NRML,                                          
MFA-TR*              BILL_CYCLE                                                 
MFA-TR*        INTO :AT-CODES-DATA-PRESENT,                                     
MFA-TR*             :AT-MST-SUB-ACCT-IND,                                       
MFA-TR*             :AT-COMPANY-NO,                                             
MFA-TR*             :AT-CODE-COMPANY-ACCT,                                      
MFA-TR*             :AT-REV-MTH-LST-NRML,                                       
MFA-TR*             :AT-BILL-CYCLE                                              
MFA-TR*            FROM CSS_ACCOUNT                                             
MFA-TR*            WHERE  ACCOUNT_NO      =  :AT-ACCOUNT-NO                     
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
           NEXT SENTENCE                                                
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT      '        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 7210-GET-COMMON-DATE                                         **        
      ** GET THE COMMON DATE                                          **        
      ******************************************************************        
       7210-GET-COMMON-DATE.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT CIS.SUBSTR3(PARM_DATA,10,10)                            
                INTO :WS-COMMON-DATE                                    
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = 'COMMON'                            
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'DATE'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBSTR(PARM_DATA,10,10)                                    
MFA-TR*         INTO :WS-COMMON-DATE                                            
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = 'COMMON'                                    
MFA-TR*          AND COMPANY_NO   = '01'                                        
MFA-TR*          AND CMND_CODE    = 'DATE'                                      
MFA-TR*          AND SEQ_NO       = 10                                          
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*      QUERYNO 7210                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_JOB_PARM'             TO TABLE-1                
              MOVE 'PROGRAM_NAME'             TO TABLE-ELEMENT-1        
              MOVE 'COMMON'                   TO HOSTVAR-ELEMENT-1      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 7220-GET-BN-OPEN-DT-REV-MNTH                                 **        
      ** GET THE DATE EXTRACT BASED ON REVENUE MONTH                  **        
      ******************************************************************        
       7220-GET-BN-OPEN-DT-REV-MNTH.                                    
      *                                                                         
           EXEC SQL                                                     
              SELECT MIN(DATE_EXTRACT)                                  
                INTO :BN-DATE-EXTRACT                                   
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE BILL_CYCLE    = :BN-BILL-CYCLE                     
                 AND REVENUE_MONTH = :BN-REVENUE-MONTH                  
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(DATE_EXTRACT)                                          
MFA-TR*         INTO :BN-DATE-EXTRACT                                           
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE BILL_CYCLE    = :BN-BILL-CYCLE                             
MFA-TR*          AND REVENUE_MONTH = :BN-REVENUE-MONTH                          
MFA-TR*      QUERYNO 7220                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7220'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'BILL_CYCLE'               TO TABLE-ELEMENT-1        
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
              MOVE BN-BILL-CYCLE              TO HOSTVAR-ELEMENT-1      
              MOVE BN-REVENUE-MONTH           TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7230-GET-BN-OPEN-DT-BILL-CYC                                 **        
      ** GET THE DATE EXTRACT BASED ON BILL CYCLE                     **        
      ******************************************************************        
       7230-GET-BN-OPEN-DT-BILL-CYC.                                    
      *                                                                         
           EXEC SQL                                                     
              SELECT MIN(DATE_EXTRACT)                                  
                INTO :BN-DATE-EXTRACT                                   
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE BILL_CYCLE    = :BN-BILL-CYCLE                     
                 AND DATE_EXTRACT >= CAST(SYSDATETIMEOFFSET() AS DATE)          
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(DATE_EXTRACT)                                          
MFA-TR*         INTO :BN-DATE-EXTRACT                                           
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE BILL_CYCLE    = :BN-BILL-CYCLE                             
MFA-TR*          AND DATE_EXTRACT >= CURRENT DATE                               
MFA-TR*      QUERYNO 7230                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7230'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'BILL_CYCLE'               TO TABLE-ELEMENT-1        
              MOVE BN-BILL-CYCLE              TO HOSTVAR-ELEMENT-1      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7240-GET-WNA-GROUP-NO                                          *        
      ******************************************************************        
      *                                                                         
       7240-GET-WNA-GROUP-NO.                                           
      *                                                                         
            MOVE '7240'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
               SELECT TOP(1) ELEC_WNA_GROUP_NO                                 
                 INTO :Q8-ELEC-WNA-GROUP-NO                             
                 FROM CSS_REV_CLS_RATE Q8 WITH(READUNCOMMITTED)                 
                WHERE RATE_PLAN_NO       = :Q8-RATE-PLAN-NO             
                  AND CODE_REVENUE_CLASS = :Q8-CODE-REVENUE-CLASS       
                  AND CODE_UTIL_TYPE     = :Q8-CODE-UTIL-TYPE           
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT ELEC_WNA_GROUP_NO                                         
MFA-TR*          INTO :Q8-ELEC-WNA-GROUP-NO                                     
MFA-TR*          FROM CSS_REV_CLS_RATE Q8                                       
MFA-TR*         WHERE RATE_PLAN_NO       = :Q8-RATE-PLAN-NO                     
MFA-TR*           AND CODE_REVENUE_CLASS = :Q8-CODE-REVENUE-CLASS               
MFA-TR*           AND CODE_UTIL_TYPE     = :Q8-CODE-UTIL-TYPE                   
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7240                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE ZERO               TO Q8-ELEC-WNA-GROUP-NO       
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_REV_CLS_RATE'    TO TABLE-1                    
               MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-1            
               MOVE 'CODE_REVENUE_CLASS'  TO TABLE-ELEMENT-2            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3            
               MOVE Q8-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-1          
               MOVE Q8-CODE-REVENUE-CLASS TO HOSTVAR-ELEMENT-2          
               MOVE Q8-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-3          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*     EJECT                                                               
       7250-SELECT-AF.                                                  
           EXEC SQL                                                     
             SELECT ACCT_XFER_FROM,                                     
                    BILL_NO_XFER_FROM                                   
              INTO :AF-ACCT-XFER-FROM,                                  
                   :AF-BILL-NO-XFER-FROM                                
                FROM CSS_BILL_ACCT_XFER WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO         = :AF-ACCOUNT-NO              
                 AND  BILL_NO            = :AF-BILL-NO                 
                 AND  CODE_UTIL_TYPE     = :AF-CODE-UTIL-TYPE          
                 AND  IC_NO              = :AF-IC-NO                   
                 AND  BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :AF-BILL-ITEM-TIMESTMP
              )      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT ACCT_XFER_FROM,                                             
MFA-TR*             BILL_NO_XFER_FROM                                           
MFA-TR*       INTO :AF-ACCT-XFER-FROM,                                          
MFA-TR*            :AF-BILL-NO-XFER-FROM                                        
MFA-TR*         FROM CSS_BILL_ACCT_XFER                                         
MFA-TR*         WHERE ACCOUNT_NO         = : AF-ACCOUNT-NO                      
MFA-TR*          AND  BILL_NO            = : AF-BILL-NO                         
MFA-TR*          AND  CODE_UTIL_TYPE     = : AF-CODE-UTIL-TYPE                  
MFA-TR*          AND  IC_NO              = : AF-IC-NO                           
MFA-TR*          AND  BILL_ITEM_TIMESTMP = : AF-BILL-ITEM-TIMESTMP              
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_ACCT_XFER'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE AF-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE AF-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE AF-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE AF-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7250-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
                                                                        
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO FETCH A SINGLE ROW FROM THE       **        
      **  HT-CURSOR BASED ON AN ACCOUNT NUMBER.  ONE ADDRESS-ID ONLY. **        
      ******************************************************************        
       7260-SELECT-ADDR-ID.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT DISTINCT (ADDRESS_ID)                              
                INTO :HT-ADDRESS-ID                                     
                FROM CSS_NAME_ACCT_XREF WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISTINCT (ADDRESS_ID)                                      
MFA-TR*         INTO :HT-ADDRESS-ID                                             
MFA-TR*         FROM CSS_NAME_ACCT_XREF                                         
MFA-TR*        WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7260'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_NAME_ACCT_XREF'       TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE HT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7260-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *                                                                         
       7270-SELECT-DY.                                                  
           EXEC SQL                                                     
              SELECT HOUSE_NO,                                          
                     ADDR_PREFIX_1,                                     
                     ADDR_PREFIX_2,                                     
                     STREET_NAME,                                       
                     STREET_LOCATION_1,                                 
                     STREET_LOCATION_2,                                 
                     STREET_SUFFIX,                                     
                     ZIP_CODE                                           
               INTO :DY-HOUSE-NO,                                       
                    :DY-ADDR-PREFIX-1,                                  
                    :DY-ADDR-PREFIX-2,                                  
                    :DY-STREET-NAME,                                    
                    :DY-STREET-LOCATION-1,                              
                    :DY-STREET-LOCATION-2,                              
                    :DY-STREET-SUFFIX,                                  
                    :DY-ZIP-CODE                                        
                   FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                
                   WHERE  ADDRESS_ID =  :DY-ADDRESS-ID                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HOUSE_NO,                                                  
MFA-TR*              ADDR_PREFIX_1,                                             
MFA-TR*              ADDR_PREFIX_2,                                             
MFA-TR*              STREET_NAME,                                               
MFA-TR*              STREET_LOCATION_1,                                         
MFA-TR*              STREET_LOCATION_2,                                         
MFA-TR*              STREET_SUFFIX,                                             
MFA-TR*              ZIP_CODE                                                   
MFA-TR*        INTO :DY-HOUSE-NO,                                               
MFA-TR*             :DY-ADDR-PREFIX-1,                                          
MFA-TR*             :DY-ADDR-PREFIX-2,                                          
MFA-TR*             :DY-STREET-NAME,                                            
MFA-TR*             :DY-STREET-LOCATION-1,                                      
MFA-TR*             :DY-STREET-LOCATION-2,                                      
MFA-TR*             :DY-STREET-SUFFIX,                                          
MFA-TR*             :DY-ZIP-CODE                                                
MFA-TR*            FROM CSS_ADDR_FORMATTED                                      
MFA-TR*            WHERE  ADDRESS_ID =  :DY-ADDRESS-ID                          
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7270'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ADDR_FORMATTED'       TO TABLE-1                
              MOVE 'ADDRESS_ID  '             TO TABLE-ELEMENT-1        
              MOVE DY-ADDRESS-ID              TO HOSTVAR-ELEMENT-1      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7270-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7280-CHECK-BILL-ADJUSTMNT                                      *        
      ******************************************************************        
      *                                                                         
       7280-CHECK-BILL-ADJUSTMNT.                                       
      *                                                                         
            MOVE '7280'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-BILL-ADJ-EXIST                                
                 FROM  CSS_BILL_ADJUSTMNT   BP WITH(READUNCOMMITTED)            
                      ,CSS_BILLING_DET      BG WITH(READUNCOMMITTED)            
                WHERE  BP.ACCOUNT_NO         = :BP-ACCOUNT-NO           
                  AND  BP.BILL_NO            = :BP-BILL-NO              
                  AND  BG.ACCOUNT_NO         =  BP.ACCOUNT_NO           
                  AND  BG.BILL_NO            =  BP.BILL_NO              
                  AND  BG.CODE_UTIL_TYPE     =  BP.CODE_UTIL_TYPE       
                  AND  BG.IC_NO              =  BP.IC_NO                
                  AND  BG.BILL_ITEM_TIMESTMP =  BP.BILL_ITEM_TIMESTMP   
                  AND  BG.CODE_BILL_CALC     = 'A'                      
                  AND  BG.CODE_BILL_ITM_TYPE = 'C'                      
                  AND  BG.CODE_BILL_ITM_IND  IN ('A','K')               
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-BILL-ADJ-EXIST                                        
MFA-TR*          FROM  CSS_BILL_ADJUSTMNT   BP                                  
MFA-TR*               ,CSS_BILLING_DET      BG                                  
MFA-TR*         WHERE  BP.ACCOUNT_NO         = :BP-ACCOUNT-NO                   
MFA-TR*           AND  BP.BILL_NO            = :BP-BILL-NO                      
MFA-TR*           AND  BG.ACCOUNT_NO         =  BP.ACCOUNT_NO                   
MFA-TR*           AND  BG.BILL_NO            =  BP.BILL_NO                      
MFA-TR*           AND  BG.CODE_UTIL_TYPE     =  BP.CODE_UTIL_TYPE               
MFA-TR*           AND  BG.IC_NO              =  BP.IC_NO                        
MFA-TR*           AND  BG.BILL_ITEM_TIMESTMP =  BP.BILL_ITEM_TIMESTMP           
MFA-TR*           AND  BG.CODE_BILL_CALC     = 'A'                              
MFA-TR*           AND  BG.CODE_BILL_ITM_TYPE = 'C'                              
MFA-TR*           AND  BG.CODE_BILL_ITM_IND  IN ('A','K')                       
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7280                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE 'N'                TO WS-BILL-ADJ-EXIST          
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_BILL_ADJUSTMNT'  TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'BILL_NO'             TO TABLE-ELEMENT-2            
               MOVE BP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE BP-BILL-NO            TO HOSTVAR-ELEMENT-2          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7290-GET-PREPAY-HIST-ROWCOUNT                                  *        
      ******************************************************************        
      *                                                                         
       7290-GET-PREPAY-HIST-ROWCOUNT.                                   
      *                                                                         
            MOVE '7290'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                 SELECT COUNT(1)                                        
                   INTO :WS-PREPAY-COUNT :WS-PREPAY-COUNT-NULL           
                   FROM CSS_PREPAY_HIST PK WITH(READUNCOMMITTED)                
                  WHERE PK.ACCOUNT_NO        = :PK-ACCOUNT-NO           
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT COUNT(1)                                                
MFA-TR*            INTO :WS-PREPAY-COUNT:WS-PREPAY-COUNT-NULL                   
MFA-TR*            FROM CSS_PREPAY_HIST PK                                      
MFA-TR*           WHERE PK.ACCOUNT_NO        = :PK-ACCOUNT-NO                   
MFA-TR*            WITH UR                                                      
MFA-TR*       QUERYNO 7280                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF WS-PREPAY-COUNT-NULL = -1                             
                  MOVE ZERO            TO WS-PREPAY-COUNT               
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_PREPAY_HIST'     TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE PK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7300-SELECT-RD.                                                  
      *                                                                         
           EXEC SQL                                                     
              SELECT RATE_DESC                                          
               INTO :RD-RATE-DESC                                       
                   FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                
                   WHERE  CODE_UTIL_TYPE  =  :RD-CODE-UTIL-TYPE         
                     AND  RATE_PLAN_NO    =  :RD-RATE-PLAN-NO           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_DESC                                                  
MFA-TR*        INTO :RD-RATE-DESC                                               
MFA-TR*            FROM CSS_RATE_PLAN_DESC                                      
MFA-TR*            WHERE  CODE_UTIL_TYPE  =  :RD-CODE-UTIL-TYPE                 
MFA-TR*              AND  RATE_PLAN_NO    =  :RD-RATE-PLAN-NO                   
MFA-TR*              WITH UR                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE RD-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE RD-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * CHECK TO SEE IF UNMETERED ACCOUNT EXISTS WITH UTIL TYPE E OR G *        
      ******************************************************************        
      *                                                                         
       7350-CUST-PLAN-EXISTS.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT  'Y'                                              
                 INTO  :WS-UNMTRD-ELEC-GAS                              
                 FROM  CSS_CUST_PLAN WITH(READUNCOMMITTED)                      
                WHERE  ACCOUNT_NO     = :CP-ACCOUNT-NO                  
                  AND  CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE              
                  AND  IC_NO          = :CP-IC-NO                       
                  AND  CODE_UTIL_TYPE IN ('E', 'G')                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*          INTO  :WS-UNMTRD-ELEC-GAS                                      
MFA-TR*          FROM  CSS_CUST_PLAN                                            
MFA-TR*         WHERE  ACCOUNT_NO     = :CP-ACCOUNT-NO                          
MFA-TR*           AND  CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                      
MFA-TR*           AND  IC_NO          = :CP-IC-NO                               
MFA-TR*           AND  CODE_UTIL_TYPE IN ('E', 'G')                             
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7350'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CUST_PLAN'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE CP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       7400-GET-AR-TRANS-SEQ-NO.                                        
      ******************************************************************        
      ** TO GET AR-TRANS-HIST-SEQ-NO FROM CSS_AR_TRANS_HIST TABLE      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           AR.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                              
                 INTO :AR-TRANS-HIST-SEQ-NO                             
                 FROM CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                
                WHERE AR.ACCOUNT_NO     = :AR-ACCOUNT-NO                
                  AND AR.DATE_TRANS     = IIF(TRY_CONVERT(DATE, 
                                                         :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )                
                  AND AR.CODE_TRAN_TYPE = 'B'                           
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AR.TRANS_HIST_SEQ_NO                                      
MFA-TR*          INTO :AR-TRANS-HIST-SEQ-NO                                     
MFA-TR*          FROM CSS_AR_TRANS_HIST AR                                      
MFA-TR*         WHERE AR.ACCOUNT_NO     = :AR-ACCOUNT-NO                        
MFA-TR*           AND AR.DATE_TRANS     = :AR-DATE-TRANS                        
MFA-TR*           AND AR.CODE_TRAN_TYPE = 'B'                                   
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_TRANS'               TO TABLE-ELEMENT-2        
              MOVE AR-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE AR-DATE-TRANS              TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7450-GET-PAYMENT-AMT.                                            
      ******************************************************************        
      ** THIS PARA IS USED TO GET AR-AMT-ORIG-ENTERED FROM             *        
      ** CSS_AR_TRANS_HIST TABLE.                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
                SELECT SUM(AMT_ORIG_ENTERED)                            
                  INTO  :AR-AMT-ORIG-ENTERED :WS-NULL-IND-6              
                  FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                  
                 WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO               
                   AND CODE_TRAN_TYPE    = 'P'                          
                   AND RECORD_ONLY_FL    <> 'Y'                         
                   AND TRANS_HIST_SEQ_NO                                
                                 BETWEEN CIS.CHAR2TIMESTAMP(
                                           :WS-PREVBILL-AR-TRNSHIST-SEQ
              )   
                                     AND CIS.CHAR2TIMESTAMP(
                                           :WS-CURRBILL-AR-TRNSHIST-SEQ
              )   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SUM(AMT_ORIG_ENTERED)                                    
MFA-TR*           INTO  :AR-AMT-ORIG-ENTERED:WS-NULL-IND-6                      
MFA-TR*           FROM CSS_AR_TRANS_HIST                                        
MFA-TR*          WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                       
MFA-TR*            AND CODE_TRAN_TYPE    = 'P'                                  
MFA-TR*            AND RECORD_ONLY_FL    <> 'Y'                                 
MFA-TR*            AND TRANS_HIST_SEQ_NO                                        
MFA-TR*                          BETWEEN :WS-PREVBILL-AR-TRNSHIST-SEQ           
MFA-TR*                              AND :WS-CURRBILL-AR-TRNSHIST-SEQ           
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-NULL-IND-6 < 0                                         
              MOVE 0 TO AR-AMT-ORIG-ENTERED                             
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7450'                      TO ACTIVE-PARAGRAPH      
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_AR_TRANS_HIST'         TO TABLE-1               
              MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
              MOVE 'MIN_TRNS_HIST_SEQ'         TO TABLE-ELEMENT-2       
              MOVE 'MAX_TRNS_HIST_SEQ'         TO TABLE-ELEMENT-3       
              MOVE AR-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              MOVE WS-PREVBILL-AR-TRNSHIST-SEQ TO HOSTVAR-ELEMENT-2     
              MOVE WS-CURRBILL-AR-TRNSHIST-SEQ TO HOSTVAR-ELEMENT-3     
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*EJECT                                                                    
       7500-OPEN-BH-CURSOR.                                             
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR TO                **        
      **  CSS_BUDGET_HIST TABLE.                                      **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               OPEN BH-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BUDGET_HIST  '        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'PYMT_PRIORITY_LVL'        TO TABLE-ELEMENT-2        
              MOVE BH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BH-PYMT-PRIORITY-LVL       TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7500-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
       7510-FETCH-BH-ROW.                                               
      ******************************************************************        
      **  THIS PARAGRAPH FETCHES THE BUDGET AMOUNT ROWS FROM          **        
      **  CSS_BUDGET_HIST TABLE FOR A GIVEN ACCOUNT NUMBER.           **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               FETCH BH-CURSOR                                          
               INTO :BH-AMT-MO-PYMT,                                    
                    :BH-DATE-PYMT-STRT :WS-NULL-IND-2                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               IF WS-NULL-IND-2 < ZERO                                  
                   MOVE LOW-VALUES     TO BH-DATE-PYMT-STRT             
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7510'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BUDGET_HIST  '        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'PYMT_PRIORITY_LVL'        TO TABLE-ELEMENT-2        
              MOVE BH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BH-PYMT-PRIORITY-LVL       TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7510-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
       7520-CLOSE-BH-CURSOR.                                            
      ******************************************************************        
      **  THIS PARAGRAPH IS CLOSES THE CURSOR TO CSS_BUDGET_HIST.     **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               CLOSE BH-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7520'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BUDGET_HIST  '        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'PYMT_PRIORITY_LVL'        TO TABLE-ELEMENT-2        
              MOVE BH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BH-PYMT-PRIORITY-LVL       TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7520-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      *****************************************************************         
      * 7530-GET-DATABASE                                             *         
      *     SELECTS BILLING ENTITY (SEB OR SCEG) FROM CSS_DELINQUENCY *         
      *****************************************************************         
       7530-GET-DATABASE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C8-DELINQ-VALUE TO WS-DATABASE                       
           ELSE                                                         
              MOVE '7530'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
              MOVE C8-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7540-GET-OPTION-DESC.                                            
                                                                        
           EXEC SQL                                                     
              SELECT FI.OPT_DESC_INT                                    
                INTO :FI-OPT-DESC-INT                                   
                FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
                    ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
               WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
                 AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE         
                 AND DF.IC_NO              = :DF-IC-NO                  
                 AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO      
                 AND DF.OPTION_CD          = FI.OPTION_CD               
                 AND FI.OPT_VSTART_TS     <= CIS.CURRENT$TIMESTAMP()          
                 AND FI.OPT_VEND_TS       >= CIS.CURRENT$TIMESTAMP()          
                 AND FI.PROC_STATUS_CD     = 'AC'                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FI.OPT_DESC_INT                                            
MFA-TR*         INTO :FI-OPT-DESC-INT                                           
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CRM_RT_PKG_OPTION FI                                       
MFA-TR*        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE     = :DF-CODE-UTIL-TYPE                 
MFA-TR*          AND DF.IC_NO              = :DF-IC-NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  = :DF-RT-PKG-OPT-SEQ-NO              
MFA-TR*          AND DF.OPTION_CD          = FI.OPTION_CD                       
MFA-TR*          AND FI.OPT_VSTART_TS     <= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.OPT_VEND_TS       >= CURRENT TIMESTAMP                  
MFA-TR*          AND FI.PROC_STATUS_CD     = 'AC'                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7540'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCT_RTPK_AGR'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
              MOVE 'RT_PKG_OPT_SEQ_NO'        TO TABLE-ELEMENT-4        
              MOVE DF-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE DF-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE DF-IC-NO                   TO HOSTVAR-ELEMENT-3      
              MOVE DF-RT-PKG-OPT-SEQ-NO       TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-START-FCSJC01                                             *        
      *                                                                *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 6251-GET-FJC01-DATE                            *        
      ******************************************************************        
       7600-START-FCSJC01.                                              
      *                                                                         
           EXEC SQL                                                     
              DECLARE PARM_CSR CURSOR FOR                               
              SELECT  PROGRAM_NAME                                      
                      ,COMPANY_NO                                       
                      ,CMND_CODE                                        
                      ,SEQ_NO                                           
                      ,STATUS                                           
                      ,PARM_DATA                                        
              FROM    CSS_JOB_PARM WITH(READUNCOMMITTED)                        
              WHERE   PROGRAM_NAME   = :G6-PROGRAM-NAME                 
                AND   CMND_CODE      = :G6-CMND-CODE                    
                AND   COMPANY_NO     = :G6-COMPANY-NO                   
              ORDER BY SEQ_NO                                           
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PARM_CSR CURSOR FOR                                       
MFA-TR*       SELECT  PROGRAM_NAME                                              
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*               ,CMND_CODE                                                
MFA-TR*               ,SEQ_NO                                                   
MFA-TR*               ,STATUS                                                   
MFA-TR*               ,PARM_DATA                                                
MFA-TR*       FROM    CSS_JOB_PARM                                              
MFA-TR*       WHERE   PROGRAM_NAME   = :G6-PROGRAM-NAME                         
MFA-TR*         AND   CMND_CODE      = :G6-CMND-CODE                            
MFA-TR*         AND   COMPANY_NO     = :G6-COMPANY-NO                           
MFA-TR*       ORDER BY SEQ_NO                                                   
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE WS-PROGRAM    TO G6-PROGRAM-NAME.                       
           MOVE WS-COMMAND    TO G6-CMND-CODE.                          
           IF INDUST-GAS-CUST                                           
              MOVE WS-CIG     TO G6-COMPANY-NO                          
           ELSE                                                         
              MOVE WS-PSNC    TO G6-COMPANY-NO                          
           END-IF.                                                      
                                                                        
           EXEC SQL OPEN PARM_CSR END-EXEC.                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'DECLARE'             TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1           
              MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
      *                                                                         
       7600-FCSJC01-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7610-READ-FCSJC01                                              *        
      *                                                                *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 6251-GET-FJC01-DATE                            *        
      ******************************************************************        
       7610-READ-FCSJC01.                                               
      *                                                                         
           EXEC SQL FETCH PARM_CSR                                      
                INTO   :G6-PROGRAM-NAME                                 
                      ,:G6-COMPANY-NO                                   
                      ,:G6-CMND-CODE                                    
                      ,:G6-SEQ-NO                                       
                      ,:G6-STATUS                                       
                      ,:G6-PARM-DATA                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE G6-SEQ-NO       TO E-FJC01-SEQ-NBR                  
                                       WS-SEQ-NBR                       
               MOVE G6-PROGRAM-NAME TO E-FJC01-PGRM-NAME                
               MOVE G6-CMND-CODE    TO E-FJC01-CMND-CODE                
               MOVE G6-STATUS       TO E-FJC01-STATUS                   
                                       WS-INPUT-STATUS                  
               MOVE G6-PARM-DATA    TO WS-CUTOFF-DATA-BREAKDOWN         
                                       E-FJC01-PARAMETER-DATA           
           ELSE                                                         
           IF SQLCODE EQUAL NOT-FOUND                                   
               MOVE 'END' TO WS-SYSIPT                                  
               PERFORM 7611-CLOSE THRU 7611-EXIT                        
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7610'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1           
              MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF
           END-IF.            
                                                                        
       7610-FCSJC01-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7611-CLOSE                                                     *        
      *                                                                *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 6251-GET-FJC01-DATE                            *        
      ******************************************************************        
       7611-CLOSE.                                                      
                                                                        
           EXEC SQL CLOSE PARM_CSR END-EXEC.                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7611'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE WS-PGRMNAME           TO HOSTVAR-ELEMENT-1           
              MOVE +100                  TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
       7611-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7600-OPEN-BZ-CURSOR.                                             
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR TO                **        
      **  CSS_BILL_CALC_DET TABLE.                                    **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               OPEN BZ-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_CALC_DET'        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BZ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BZ-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE BZ-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE BZ-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7610-FETCH-BZ-ROW.                                               
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH FETCHES THE PAYMENT ROWS FROM THE            **        
      **  CSS_BILL_CALC_DET TABLE FOR A GIVEN ACCOUNT NUMBER AND      **        
      **  IC-NO.                                                      **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               FETCH BZ-CURSOR                                          
                  INTO :BZ-BILL-UNITS,                                  
                       :BZ-BILLED-COMP-AM,                              
                       :BZ-CONSUMPT-TYPE-CD,                            
                       :BZ-CMPNT-ID-CD                                  
                      ,:BZ-READ-UNITS                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR          
                                            NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7610'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_CALC_DET'        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BZ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BZ-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE BZ-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE BZ-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7610-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      *                                                                         
       7620-CLOSE-BZ-CURSOR.                                            
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_BILL_CALC_DET TABLE.                      **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               CLOSE BZ-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7620'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_CALC_DET'        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BZ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BZ-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE BZ-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE BZ-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7700-OPEN-UC-CURSOR.                                             
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR TO                **        
      **  CSS_UM_CNSMPT_HIST TABLE.                                   **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               OPEN UC-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_UM_CNSMPT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE UC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE UC-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE UC-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7710-FETCH-UC-ROW.                                               
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH FETCHES THE PAYMENT ROWS FROM THE            **        
      **  CSS_UM_CNSMPT_HIS TABLE FOR A GIVEN ACCOUNT NUMBER AND      **        
      **  IC-NO.                                                      **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               FETCH UC-CURSOR                                          
                  INTO :UC-DATE-USAGE-ENDS :WS-NULL-IND,                
                       :UC-NO-UNITS,                                    
                       :UC-NO-DAYS,                                     
                       :UC-MTHLY-AMOUNT-FIXED,                          
                       :UC-CODE-DEBIT-CREDIT                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR          
                                            NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7710'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_UM_CNSMPT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE UC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE UC-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE UC-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7710-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      *                                                                         
       7720-CLOSE-UC-CURSOR.                                            
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_UM_CNSMPT_HIS TABLE.                      **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               CLOSE UC-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7720'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_UM_CNSMPT_HIST'       TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE UC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE UC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE UC-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE UC-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7720-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
      *                                                                         
      *                                                                         
       7800-OPEN-CX-CURSOR.                                             
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR TO                **        
      **  CSS_CNSMPTN_HIST  TABLE.                                    **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               OPEN CX-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7800'                     TO ACTIVE-PARAGRAPH       
              MOVE '0PEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST '        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7810-FETCH-CX-ROW.                                               
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH FETCHES THE PAYMENT ROWS FROM THE            **        
      **  CSS_CNSMPTN_HIST  TABLE FOR A GIVEN ACCOUNT NUMBER AND      **        
      **  IC-NO.                                                      **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               FETCH CX-CURSOR                                          
                  INTO :CX-CODE-USAGE-TYPE,                             
                       :CX-METER-NO,                                    
                       :CX-DATE-READ :WS-NULL-IND-1,                    
                       :CX-NO-UNITS,                                    
                       :CX-NO-DEMAND-UNITS,                             
                       :CX-NO-DAYS,                                     
                       :CX-CODE-SOURCE-ID,                              
                       :CX-CODE-DEBIT-CREDIT,                           
                       :CX-MTR-REF-NO,                                  
                       :CX-REG-ID-NO,                                   
                       :CX-CODE-TOU-SEASN,                              
                       :CX-CODE-TIME-PERIOD,                            
                       :CX-CODE-ITEM-STATUS                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR          
                                            NOT-FOUND                   
               IF WS-NULL-IND-1 < ZERO                                  
                   MOVE LOW-VALUES     TO CX-DATE-READ                  
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7810'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST '        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7820-CLOSE-CX-CURSOR.                                            
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_CNSMPTN_HIST TABLE.                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               CLOSE CX-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7820'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CNSMPTN_HIST '        TO TABLE-1                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_NO'                  TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-3      
              MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7900-GET-BILL-UNITS.                                             
                                                                        
      ******************************************************************        
      **  THIS PARAGRAPH SELECT THE SUM OF BILL_UNITS   FROM          **        
      **  CSS_BILL_CALC_DET TABLE FOR A GIVEN ACCOUNT NUMBER AND      **        
      **  IC-NO ONLY FOR BACK OUT ITEMS                               **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(BILL_UNITS)                                    
                    ,SUM(READ_UNITS)                                    
                INTO :WS-ACCUM-NO-UNITS :WS-NULL-IND-4                  
                    ,:WS-ACCUM-READ-UNITS :WS-NULL-IND-5                
              FROM CSS_BILL_CALC_DET BZ WITH(READUNCOMMITTED)                   
              WHERE BZ.ACCOUNT_NO           = :BZ-ACCOUNT-NO            
                AND BZ.CODE_UTIL_TYPE       = :BZ-CODE-UTIL-TYPE        
                AND BZ.IC_NO                = :BZ-IC-NO                 
                AND BZ.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BZ-BILL-ITEM-TIMESTMP
              )      
                AND (CMPNT_ID_CD NOT IN ('92','93'))                    
                AND INSTR_USE_TYPE_CD  = 'R'                            
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(BILL_UNITS)                                            
MFA-TR*             ,SUM(READ_UNITS)                                            
MFA-TR*         INTO :WS-ACCUM-NO-UNITS :WS-NULL-IND-4                          
MFA-TR*             ,:WS-ACCUM-READ-UNITS :WS-NULL-IND-5                        
MFA-TR*       FROM CSS_BILL_CALC_DET BZ                                         
MFA-TR*       WHERE BZ.ACCOUNT_NO           = :BZ-ACCOUNT-NO                    
MFA-TR*         AND BZ.CODE_UTIL_TYPE       = :BZ-CODE-UTIL-TYPE                
MFA-TR*         AND BZ.IC_NO                = :BZ-IC-NO                         
MFA-TR*         AND BZ.BILL_ITEM_TIMESTMP = :BZ-BILL-ITEM-TIMESTMP              
MFA-TR*         AND (CMPNT_ID_CD NOT IN ('92','93'))                            
MFA-TR*         AND INSTR_USE_TYPE_CD  = 'R'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              IF WS-NULL-IND-4 < 0                                      
                 MOVE 0 TO WS-ACCUM-NO-UNITS                            
              END-IF                                                    
              IF WS-NULL-IND-5 < 0                                      
                 MOVE 0 TO WS-ACCUM-READ-UNITS                          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7900'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_CALC_DET'        TO TABLE-1                
              MOVE 'CSS_BILLING_HDR'          TO TABLE-2                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'DATE_BILLED'              TO TABLE-ELEMENT-3        
              MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
              MOVE BZ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE BZ-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE BI-DATE-BILLED             TO HOSTVAR-ELEMENT-3      
              MOVE BZ-IC-NO                   TO HOSTVAR-ELEMENT-4      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7910-CHECK-INDUS-NETMTR-CUST.                                    
                                                                        
      ******************************************************************        
      **  THIS PARAGRAPH CHECKS WHETHER THE GIVEN BG-RATE-PLAN-NO     **        
      **  BELONGS TO INDUSTRIAL GAS OR NET-METRING CUSTOMER           **        
      **                                                              **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) J1.REG_TYPE_CD,
              J1.BAL_FWD_CD                                      
                INTO :WS-REG-TYPE-CD                                    
                    ,:WS-BAL-FWD-CD                                     
              FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                   
              WHERE J1.RATE_PLAN_NO         = :BG-RATE-PLAN-NO          
                AND J1.CODE_UTIL_TYPE       = :BG-CODE-UTIL-TYPE        
      *         AND J1.REG_TYPE_CD          = 'D'                               
                AND J1.VERSION_NO_CNTRL     =                           
                    (SELECT MAX(A1.VERSION_NO_CNTRL)                    
                       FROM CSS_RATE_COMP_DEF A1 WITH(READUNCOMMITTED)          
                WHERE A1.RATE_PLAN_NO       = :BG-RATE-PLAN-NO          
                  AND A1.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE)       
                                                    
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT J1.REG_TYPE_CD                                             
MFA-TR*             ,J1.BAL_FWD_CD                                              
MFA-TR*         INTO :WS-REG-TYPE-CD                                            
MFA-TR*             ,:WS-BAL-FWD-CD                                             
MFA-TR*       FROM CSS_RATE_COMP_DEF J1                                         
MFA-TR*       WHERE J1.RATE_PLAN_NO         = :BG-RATE-PLAN-NO                  
MFA-TR*         AND J1.CODE_UTIL_TYPE       = :BG-CODE-UTIL-TYPE                
MFA-TR*         AND J1.REG_TYPE_CD          = 'D'                               
MFA-TR*         AND J1.VERSION_NO_CNTRL     =                                   
MFA-TR*             (SELECT MAX(A1.VERSION_NO_CNTRL)                            
MFA-TR*                FROM CSS_RATE_COMP_DEF A1                                
MFA-TR*         WHERE A1.RATE_PLAN_NO       = :BG-RATE-PLAN-NO                  
MFA-TR*           AND A1.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE)               
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
      *                                     OR MULTIPLE-ROWS                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7910'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE BG-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7920-SELECT-JOB-PARM.                                          *        
      ******************************************************************        
       7920-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
               SELECT G6.PARM_DATA                                      
                 INTO :G6-PARM-DATA                                     
                 FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                     
                WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                
                  AND G6.CMND_CODE    = :G6-CMND-CODE                   
                  AND G6.STATUS       = :G6-STATUS                      
                  AND G6.SEQ_NO       = :G6-SEQ-NO                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT G6.PARM_DATA                                              
MFA-TR*          INTO :G6-PARM-DATA                                             
MFA-TR*          FROM CSS_JOB_PARM G6                                           
MFA-TR*         WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                        
MFA-TR*           AND G6.CMND_CODE    = :G6-CMND-CODE                           
MFA-TR*           AND G6.STATUS       = :G6-STATUS                              
MFA-TR*           AND G6.SEQ_NO       = :G6-SEQ-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7920'                   TO ACTIVE-PARAGRAPH        
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSS_JOB_PARM'           TO TABLE-1                 
               MOVE 'CUT REV MTH'            TO TABLE-ELEMENT-1         
               MOVE  WS-PARM-CUT-REV         TO HOSTVAR-ELEMENT-1       
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7920-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7930-SEL-MTR-READ-CD.                                          *        
      ******************************************************************        
       7930-SEL-MTR-READ-CD.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MTR_READ_SOURCE_CD                                
                 INTO :MN-MTR-READ-SOURCE-CD                            
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO      = :MN-ACCOUNT-NO                  
                  AND IC_NO           = :MN-IC-NO                       
                  AND CODE_UTIL_TYPE  = :MN-CODE-UTIL-TYPE              
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MTR_READ_SOURCE_CD                                        
MFA-TR*          INTO :MN-MTR-READ-SOURCE-CD                                    
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO      = :MN-ACCOUNT-NO                          
MFA-TR*           AND IC_NO           = :MN-IC-NO                               
MFA-TR*           AND CODE_UTIL_TYPE  = :MN-CODE-UTIL-TYPE                      
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7930'                   TO ACTIVE-PARAGRAPH        
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSS_MTRD_ENVRNMT'       TO TABLE-1                 
               MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1         
               MOVE  BG-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7930-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **                                                               *        
      ** 7940-SELECT-BILLING-HDR.                                      *        
      ** SELECT THE BILL NO & ACCOUNT NO FROM BILLING HDR.             *        
      ******************************************************************        
       7940-SELECT-BILLING-HDR.                                         
                                                                        
           EXEC SQL                                                     
                SELECT COALESCE(MAX(BI.BILL_NO), 0)                       
                  INTO :WS-BI-BILL-NO                                   
                  FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                 
                 WHERE BI.ACCOUNT_NO   = :BI-ACCOUNT-NO                 
                   AND BI.DATE_BILLED IS NULL                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT IFNULL(MAX(BI.BILL_NO), 0)                               
MFA-TR*           INTO :WS-BI-BILL-NO                                           
MFA-TR*           FROM CSS_BILLING_HDR BI                                       
MFA-TR*          WHERE BI.ACCOUNT_NO   = :BI-ACCOUNT-NO                         
MFA-TR*            AND BI.DATE_BILLED IS NULL                                   
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      **                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
      **                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SPACES                    TO ABEND-FILE             
               MOVE '7940'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_BILLING_HDR'          TO TABLE-1               
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE BI-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      **                                                                        
       7940-EXIT.                                                       
            EXIT.                                                       
      **                                                                        
      ******************************************************************        
      *** SELECT DETAILS FROM BG                                     **         
      *** SELECT THE TOTAL NO OF ROWS FOR BI IN BG TABLE.            **         
      ******************************************************************        
       7950-SELECT-BILLING-DET.                                         
           EXEC SQL                                                     
                SELECT COUNT(1)                                         
                  INTO :WS-BG-ROW-COUNT                                 
                  FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                 
                 WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO              
                   AND BILL_NO            = :WS-BI-BILL-NO              
                   AND DATE_ORIG_BILL    IS NULL                        
                   AND CODE_BILL_CALC     = 'A'                         
                   AND CODE_BILL_ITM_TYPE = 'C'                         
                   AND CODE_BILL_ITM_IND  = 'A'                         
                   AND REVENUE_MONTH      = 0                           
                   AND REV_MTH_ORIG_BILL  = 0                           
                   AND REV_RPT_CD        <> 'T'                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT COUNT(1)                                                 
MFA-TR*           INTO :WS-BG-ROW-COUNT                                         
MFA-TR*           FROM CSS_BILLING_DET BG                                       
MFA-TR*          WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                      
MFA-TR*            AND BILL_NO            = :WS-BI-BILL-NO                      
MFA-TR*            AND DATE_ORIG_BILL    IS NULL                                
MFA-TR*            AND CODE_BILL_CALC     = 'A'                                 
MFA-TR*            AND CODE_BILL_ITM_TYPE = 'C'                                 
MFA-TR*            AND CODE_BILL_ITM_IND  = 'A'                                 
MFA-TR*            AND REVENUE_MONTH      = 0                                   
MFA-TR*            AND REV_MTH_ORIG_BILL  = 0                                   
MFA-TR*            AND REV_RPT_CD        <> 'T'                                 
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      **                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      **                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SPACES                    TO ABEND-FILE             
               MOVE '7950'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_BILLING_DET'         TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE 'BILL_NO   '              TO TABLE-ELEMENT-2        
               MOVE WS-BI-BILL-NO             TO HOSTVAR-ELEMENT-2      
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      **                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
      **                                                                        
      ******************************************************************        
      **                                                               *        
      ** 7960-SELECT-UT-ROW.                                           *        
      ** SELECT THE TOTAL NUMBER OF ROWS FOR THE BG ACCOUNT IN UT TBL. *        
      ******************************************************************        
       7960-SELECT-UT-ROW.                                              
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(1)                                          
               INTO :WS-UT-ROW-COUNT                                    
                FROM  CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
               WHERE UT.ACCOUNT_NO        =   :UT-ACCOUNT-NO            
               AND(                                                     
                  (EXISTS                                               
                  (SELECT 1                                             
                    FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)              
                   WHERE MN.ACCOUNT_NO        =  UT.ACCOUNT_NO          
                     AND MN.IC_NO             =  UT.IC_NO               
                     AND MN.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE      
                     AND MN.CODE_METER_STATUS IN ('A','B','I')))        
                OR                                                      
                  (EXISTS                                               
                  (SELECT 1                                             
                     FROM CSS_CUST_PLAN CU WITH(READUNCOMMITTED)                
                   WHERE CU.ACCOUNT_NO        =  UT.ACCOUNT_NO          
                     AND CU.IC_NO             =  UT.IC_NO               
                     AND CU.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE      
                     AND CU.CODE_PLAN_STATUS  =  'A'                    
                     AND CU.REMOVE_DATE       IS NULL)))                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(1)                                                  
MFA-TR*        INTO :WS-UT-ROW-COUNT                                            
MFA-TR*         FROM  CSS_UTIL_ENVRNMT UT                                       
MFA-TR*        WHERE UT.ACCOUNT_NO        =   :UT-ACCOUNT-NO                    
MFA-TR*        AND(                                                             
MFA-TR*           (EXISTS                                                       
MFA-TR*           (SELECT 1                                                     
MFA-TR*             FROM CSS_MTRD_ENVRNMT MN                                    
MFA-TR*            WHERE MN.ACCOUNT_NO        =  UT.ACCOUNT_NO                  
MFA-TR*              AND MN.IC_NO             =  UT.IC_NO                       
MFA-TR*              AND MN.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE              
MFA-TR*              AND MN.CODE_METER_STATUS IN ('A','B','I')))                
MFA-TR*         OR                                                              
MFA-TR*           (EXISTS                                                       
MFA-TR*           (SELECT 1                                                     
MFA-TR*              FROM CSS_CUST_PLAN CU                                      
MFA-TR*            WHERE CU.ACCOUNT_NO        =  UT.ACCOUNT_NO                  
MFA-TR*              AND CU.IC_NO             =  UT.IC_NO                       
MFA-TR*              AND CU.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE              
MFA-TR*              AND CU.CODE_PLAN_STATUS  =  'A'                            
MFA-TR*              AND CU.REMOVE_DATE       IS NULL)))                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7960'                   TO ACTIVE-PARAGRAPH        
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSS_UTIL_ENVRMT'        TO TABLE-1                 
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7960-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **                                                               *        
      ** 7970-SELECT-DELINQUENCY.                                      *        
      ** SELECT THE DELINQUENCY VALUE.                                 *        
      ******************************************************************        
       7970-SELECT-DELINQUENCY.                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7970                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES                  TO ABEND-FILE               
               MOVE '7970'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_DELINQUENCY'       TO TABLE-1                  
               MOVE 'DELINQ_CD'             TO TABLE-ELEMENT-1          
               MOVE 'C8-COMPANY-NO'         TO TABLE-ELEMENT-2          
               MOVE C8-DELINQ-CD            TO HOSTVAR-ELEMENT-1        
               MOVE C8-COMPANY-NO           TO HOSTVAR-ELEMENT-2        
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7970-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7980-CHK-ELEC-INTRUPT-ACCT.                                    *        
      ******************************************************************        
      *                                                                         
       7980-CHK-ELEC-INTRUPT-ACCT.                                      
      *                                                                         
            MOVE '7980'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
              SELECT TOP(1) 'Y'                                                
                INTO :WS-ELEC-INTRUPT-ACCT                              
                FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                 
               WHERE J1.RATE_PLAN_NO         = :BG-RATE-PLAN-NO         
                 AND J1.CODE_UTIL_TYPE       = :BG-CODE-UTIL-TYPE       
      *          AND J1.CMPNT_ID_CD          = :BG-CMPNT-ID-CD                  
                 AND J1.CMPNT_ID_CD IN ('30','40','50','62')            
                 AND J1.VERSION_NO_CNTRL     =                          
                    (SELECT MAX(A1.VERSION_NO_CNTRL)                    
                       FROM CSS_RATE_COMP_DEF A1 WITH(READUNCOMMITTED)          
                WHERE A1.RATE_PLAN_NO       = :BG-RATE-PLAN-NO          
                  AND A1.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE)       
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-ELEC-INTRUPT-ACCT                                      
MFA-TR*         FROM CSS_RATE_COMP_DEF J1                                       
MFA-TR*        WHERE J1.RATE_PLAN_NO         = :BG-RATE-PLAN-NO                 
MFA-TR*          AND J1.CODE_UTIL_TYPE       = :BG-CODE-UTIL-TYPE               
MFA-TR*          AND J1.CMPNT_ID_CD          = :BG-CMPNT-ID-CD                  
MFA-TR*          AND J1.CMPNT_ID_CD IN ('30','40','50','62')                    
MFA-TR*          AND J1.VERSION_NO_CNTRL     =                                  
MFA-TR*             (SELECT MAX(A1.VERSION_NO_CNTRL)                            
MFA-TR*                FROM CSS_RATE_COMP_DEF A1                                
MFA-TR*         WHERE A1.RATE_PLAN_NO       = :BG-RATE-PLAN-NO                  
MFA-TR*           AND A1.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE)               
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7980                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7980'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE BG-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7980-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 7990-GET-BILL-CALC-FL.                                       **        
      ******************************************************************        
       7990-GET-BILL-CALC-FL.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT CIS.SUBSTR3(PARM_DATA,18,1)                             
                INTO :WS-ENABLE-BILL-CALC                               
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE PROGRAM_NAME = :PROGRAM-NAME                       
                 AND COMPANY_NO   = :AT-COMPANY-NO                      
                 AND CMND_CODE    = 'DATE'                              
                 AND SEQ_NO       = 2                                   
                 AND STATUS       = 'A'                                 
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBSTR(PARM_DATA,18,1)                                     
MFA-TR*         INTO :WS-ENABLE-BILL-CALC                                       
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = :PROGRAM-NAME                               
MFA-TR*          AND COMPANY_NO   = :AT-COMPANY-NO                              
MFA-TR*          AND CMND_CODE    = 'DATE'                                      
MFA-TR*          AND SEQ_NO       = 2                                           
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*      QUERYNO 7990                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7990'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_JOB_PARM'             TO TABLE-1                
              MOVE 'PROGRAM_NAME'             TO TABLE-ELEMENT-1        
              MOVE 'COMMON'                   TO HOSTVAR-ELEMENT-1      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7990-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           MOVE 12                        TO RETURN-CODE .              
           DISPLAY 'PROCESSING TERMINATED'.                             
           PERFORM 9999-END-PROGRAM       THRU 9999-EXIT.               
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9999-END-PROGRAM.                                                
           MOVE RETURN-CODE               TO WS-SCSCA-RETURN-CODE .     
           EXIT PROGRAM.                                                
       9999-EXIT.                                                       
           EXIT.                                                        
