       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   SCSCA151.                                          
       AUTHOR.       VAISHNAVI.                                         
       DATE-WRITTEN. AUG 2008.                                          
                                                                        
      ***************************************************************** 00000600
      **              SOUTH CAROLINA ELECTRICITY  & GAS              ** 00000700
      **                                                             ** 00000800
      ********            CUSTOMER SERVICE SYSTEM             ********* 00000900
      ********                   DB2                          ********* 00001000
      ***************************************************************** 00001100
      **                                                             ** 00001200
      **              PROGRAM  MODIFICATION  LOG                     ** 00001300
      **                                                             ** 00001400
      **                                                             ** 00001500
      **  DATE    INITIALS             REASON                        ** 00001600
      **________  ________           ______________                  ** 00001700
      **                                                             ** 00001800
      ** 08/08    SV82012         INITIAL VERSION OF  PROGRAM        ** 00001900
P00599** 07/12    AA97148         CREDIT SIMPLIFICATION CHANGES.     **         
P00599** 11/12    GOKUL           INCREMENT CA151-TOT-ACCTS-OMITTED  **         
P00599**                          ONCE FOR AN ACCOUNT.               **         
      ***************************************************************** 00002000
      * PROGRAM NARRATIVE                                             * 00002100
      *                                                               * 00002200
      * AT FIRST CALL LOAD ALL THE ACCOUNTS TO BE SKIPPED FROM BILL   *         
      * PRINT PROCESS FROM FCSOMIT FILE.                              *         
      * TO VERIFY IF THE ACCOUNT NEED TO BE SKIPPED FROM BILL PRINT.  * 00002300
      *                                                               * 00002500
      ***************************************************************** 00002900
                                                                        
      *                                                                 00003100
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
       ENVIRONMENT DIVISION.                                            
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSOMIT.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDOMIT.                                                            
       COPY FIOOMIT.                                                            
                                                                        
                                                                        
       WORKING-STORAGE SECTION.                                         
                                                                        
       01  WS-SWITCHES.                                                 
           05  PROGNAME                    PIC X(08) VALUE 'SCSCA151'.  
           05  PROGRAM-NAME                PIC X(08) VALUE 'SCSCA151'.  
                                                                        
       01  WS-OMIT-STATUS                  PIC X(02) EXTERNAL.          
           88  OMIT-SUCCESSFUL             VALUE '00'.                  
           88  OMIT-READ-OK                VALUE '00' '04'.             
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  WS-END-OF-OMIT              PIC X(01) VALUE 'N'.         
               88  END-OF-OMIT                       VALUE 'Y'.         
           05  WS-SKIP-SUB                 PIC S9(04) COMP.             
           05  SUB1                        PIC S9(04) COMP.             
           05  WS-DISPLAY-ACCOUNT          PIC Z(13).                   
P00599     05  WS-SKIP-ACCOUNT             PIC S9(13) OCCURS 500 TIMES. 
      *                                                                 00026600
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08) VALUE 'SCSCA151'.  
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
      *                                                                 00027000
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       COPY CWSCA151.                                                   00036900
                                                                        
       01  WS-SCSCA-RETURN-CODE            PIC S9(4) COMP.              
                                                                        
       PROCEDURE DIVISION USING WS-SCSCA151-PARMS                       
                                WS-SCSCA-RETURN-CODE.                   
      *                                                                 00041500
       0000-MAINLINE.                                                   
      *                                                                 00041700
                                                                        
           PERFORM 0100-INITIALIZATION                THRU 0100-EXIT.   
                                                                        
           PERFORM 1000-PROCESS-OMIT-ACCOUNT          THRU 1000-EXIT.   
           MOVE 0                         TO RETURN-CODE.               
           PERFORM 9999-BAIL-OUT                      THRU 9999-EXIT.   
      *                                                                 00043600
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  00044000
      * INITIALIZE THE VARIABLES & WHEN THE WS-CA151-FIRST-CALL-SW   *  00044100
      * IS 'Y' LOAD THE DATA FROM CSS_PAY_AGCY_XREF AND CSS_LOCATION.*  00044200
      * SET THE WS-CA151-FIRST-CALL-SW TO 'N' IN CALLING PROGRAM AFTER  00044300
      * THE FIRST CALL IS OVER.                                      *          
      ****************************************************************  00044400
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE WS-N                      TO WS-CA151-OMIT-ACCOUNT-FL.  
           IF WS-CA151-FIRST-CALL-SW = WS-Y                             
              DISPLAY 'SCSCA151 - PROCESS TO SKIP ACCTS FROM BILL PRINT'
P00599        MOVE 'N'                    TO WS-CA151-FIRST-CALL-SW     
              INITIALIZE    WS-CA151-OMIT-ACCOUNT                       
              OPEN INPUT OMITACCT-FILE                                  
              IF NOT OMIT-SUCCESSFUL                                    
                  DISPLAY '**************************************'      
                  DISPLAY '**   0100-INITIALIZATION, SCSCA151    '      
                  DISPLAY '**   ERROR OPENING FCSOMIT'                  
                  DISPLAY '**   FILE STATUS = ' WS-OMIT-STATUS          
                  DISPLAY '**************************************'      
                  MOVE 12                  TO RETURN-CODE               
                  PERFORM 9999-BAIL-OUT          THRU 9999-EXIT         
              END-IF                                                    
              PERFORM 0200-LOAD-SKIP-ACCTS       THRU 0200-EXIT         
              CLOSE OMITACCT-FILE                                       
              IF NOT OMIT-SUCCESSFUL                                    
                  DISPLAY '**************************************'      
                  DISPLAY '**   0100-INITIALIZATION, SCSCA151    '      
                  DISPLAY '**   ERROR CLOSING FCSOMIT'                  
                  DISPLAY '**   FILE STATUS = ' WS-OMIT-STATUS          
                  DISPLAY '**************************************'      
                  MOVE 12                  TO RETURN-CODE               
                  PERFORM 9999-BAIL-OUT          THRU 9999-EXIT         
              END-IF                                                    
              MOVE 0                      TO RETURN-CODE                
              PERFORM 9999-BAIL-OUT              THRU 9999-EXIT         
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   00044000
      * OPEN INPUT FILE AND READ THE DATA AND LOAD ACCTS TO WS.     *   00044100
      ***************************************************************   00047400
       0200-LOAD-SKIP-ACCTS.                                            
                                                                        
      *                                                                         
           MOVE 0                         TO WS-CA151-INPUT-ACCOUNT.    
           MOVE 0                         TO SUB1.                      
P00599     PERFORM 7900-READ-INPUT-ACCTS         THRU 7900-EXIT UNTIL   
P00599             END-OF-OMIT OR SUB1 > 500.                           
P00599     IF SUB1 <= 500                                               
              IF SUB1 = 0 AND END-OF-OMIT 
                 SET NO-ACCTS-TO-PROCESS  TO TRUE 
                 MOVE 0                   TO RETURN-CODE
                 CLOSE OMITACCT-FILE
                 PERFORM 9999-BAIL-OUT         THRU 9999-EXIT
              ELSE                                                      
P00599           SET CA151-ACCTS-FOUND    TO TRUE                       
                 SET ACCTS-TO-PROCESS     TO TRUE                       
                 MOVE 1                   TO WS-SKIP-SUB                
                 PERFORM VARYING WS-SKIP-SUB FROM 1 BY 1 UNTIL          
                         WS-SKIP-SUB > SUB1                             
                   MOVE WS-SKIP-ACCOUNT(WS-SKIP-SUB) TO                 
                        WS-CA151-OMIT-ACCT-NO(WS-SKIP-SUB)              
                   MOVE WS-N                TO                          
                        WS-CA151-ACCT-PROCESS-FL(WS-SKIP-SUB)           
                   ADD 1                 TO WS-CA151-TOT-ACCTS-FROM-FILE
                 END-PERFORM                                            
              END-IF                                                    
           ELSE                                                         
               CLOSE OMITACCT-FILE                                      
P00599         DISPLAY 'MORE THAN 500 ACCOUNTS TO SKIP FROM BILL PRINT' 
               DISPLAY 'CHECK THE OMIT FILE'                            
               MOVE 12                       TO RETURN-CODE             
               PERFORM 9999-BAIL-OUT         THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   00047400
      * PROCESS OMIT ACCOUNTS                                       *   00047500
      ***************************************************************   00047600
                                                                        
       1000-PROCESS-OMIT-ACCOUNT.                                       
                                                                        
           PERFORM 1100-PROCESS-INPUT-ACCOUNT   THRU 1100-EXIT.         
           PERFORM 1200-PROCESS-TOTALS          THRU 1200-EXIT.         
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00171200
      ***************************************************************   00047400
      * CHECK INPUT ACCOUNT NO IN OMIT TABLE. WHEN THE ACCOUNT IS   *   00047500
      * FOUND SET ACCOUNT-PROCESS-FL AND OMIT-ACCOUNT-FL TO 'Y' AND *           
      * INCREMENT THE COUNTER ON TOT-ACCTS-OMITTED BY 1.            *           
      ***************************************************************   00047600
                                                                        
       1100-PROCESS-INPUT-ACCOUNT.                                      
                                                                        
           PERFORM VARYING WS-SKIP-SUB FROM 1 BY 1 UNTIL                
SCA006             WS-CA151-OMIT-ACCOUNT-FL = WS-Y OR 
                   WS-SKIP-SUB > 100 OR 
                   WS-CA151-OMIT-ACCT-NO(WS-SKIP-SUB) = +0                      
                   IF WS-CA151-OMIT-ACCT-NO(WS-SKIP-SUB) =              
                      WS-CA151-INPUT-ACCOUNT                            
P00599                IF WS-CA151-ACCT-PROCESS-FL (WS-SKIP-SUB)         
P00599                   NOT = 'Y'                                      
P00599                   ADD 1            TO WS-CA151-TOT-ACCTS-OMITTED 
P00599                END-IF                                            
                      MOVE WS-Y           TO WS-CA151-ACCT-PROCESS-FL   
                                             (WS-SKIP-SUB)              
                                             WS-CA151-OMIT-ACCOUNT-FL   
                   END-IF                                               
           END-PERFORM.                                                 
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00171200
      ***************************************************************   00047400
      * CHECK THE TOT-ACCTS-OMITTED AND TOT-ACCTS-FROM FILE. IF THEY*   00047500
      * ARE THE SAME, SEE IF THERE ARE ANY ACCOUNTS WITH ACCT-PROCESS           
      * -FL AS "N". IF SO ABEND THE PROGRAM, IF NO ACCOUNTS ARE FOUND           
      * WITH ACCT-PROCESS-FL = 'N' SET NO-ACCTS-TO-PROCESS TO TRUE. *           
      ***************************************************************   00047600
       1200-PROCESS-TOTALS.                                             
                                                                        
           IF WS-CA151-TOT-ACCTS-OMITTED = WS-CA151-TOT-ACCTS-FROM-FILE 
              SET NO-ACCTS-TO-PROCESS    TO TRUE                        
           END-IF.                                                      
      *                                                                 00171200
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00171200
      ***************************************************************   00047400
      * READ THE INPUT FILE FCSOMIT                                 *   00047500
      ***************************************************************   00047400
      *                                                                 00171200
       7900-READ-INPUT-ACCTS.                                           
                                                                        
           READ OMITACCT-FILE AT END                                    
               MOVE WS-Y                  TO WS-END-OF-OMIT             
           END-READ.                                                    
           IF  OMIT-READ-OK OR END-OF-OMIT                              
               IF OMIT-READ-OK                                          
                  ADD 1                   TO SUB1                       
                  MOVE E-SKIP-ACCOUNT-NO  TO WS-SKIP-ACCOUNT (SUB1)     
               END-IF                                                   
           ELSE                                                         
               MOVE 12                    TO RETURN-CODE                
               DISPLAY '****************************************'       
               DISPLAY '**     SCSCA151 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSOMIT FILE   **'       
               DISPLAY '**     FILE STATUS = ' WS-OMIT-STATUS           
               DISPLAY '****************************************'       
               PERFORM 9999-BAIL-OUT              THRU 9999-EXIT        
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-BAIL-OUT.                                                   
                                                                        
           MOVE RETURN-CODE               TO  WS-SCSCA-RETURN-CODE.     
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
