       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   SCSCA150.                                          
       AUTHOR.       VAISHNAVI.                                         
       DATE-WRITTEN. AUG 2008.                                          
      ***************************************************************** 00000600
      **              SOUTH CAROLINA ELECTRICITY  & GAS              ** 00000700
      **                                                             ** 00000800
      ********            CUSTOMER SERVICE SYSTEM             ********* 00000900
      ********                   DB2                          ********* 00001000
      ***************************************************************** 00001100
      **                                                             ** 00001200
      **              PROGRAM  MODIFICATION  LOG                     ** 00001300
      **                                                             ** 00001400
      **                                                             ** 00001500
      **  DATE    INITIALS             REASON                        ** 00001600
      **________  ________           ______________                  ** 00001700
      **                                                             ** 00001800
      ** 08/08   VAISHNAVI        INITIAL VERSION OF  PROGRAM        ** 00001900
T37389** 06/08    SV82012         CHANGES TO GENERATE MEMO BILLS     **         
A03253** 04/11    SDHAL           SELECT PYMT AGCY FOR COMPANY NO    **         
A03253**                          AND ADD ZIP CODE MATCH FOR PSNC    **         
ACT126** 07/14    BD09555         INCREASE PAYMENT AGENCY TABLE SIZE **         
ACT126** 07/14 A04880-ACT126                                         **         
ACT145** 12/10    BD09555         INCREASE SUBSCRIPT CHECK FOR       **         
ACT145**       A04880-ACT145      PAYMENT AGENCY TABLE               **         
ACT071** 16/03/15 SS7F226         ADD CREATED-BY FIELD IN WF AREA.   **         
ACT071**           A04860                                            **         
      ***************************************************************** 00002000
      * PROGRAM NARRATIVE                                             * 00002100
      *                                                               * 00002200
      * THIS SUB PROGRAM IS USED TO GET PAYMENT AGENCY/BUSINESS OFFICE* 00002300
      * INFORMATION FOR ALL COMPANIES.                                * 00002400
      *                                                               * 00002500
      ***************************************************************** 00002900
                                                                        
      *                                                                 00003100
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9900 - 9999     ABEND/ABORT MODULES                     
       ENVIRONMENT DIVISION.                                            
                                                                        
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-LOCATION  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-PAYMENT-AGENCY  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA150'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-LOC-FOUND-SW             PIC X(01) VALUE 'N'.         
               88 LOC-FOUND                VALUE 'Y'.                   
           05  PROGNAME                    PIC X(08) VALUE 'SCSCA150'.  
           05  PROGRAM-NAME                PIC X(08) VALUE 'SCSCA150'.  
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  SUB1                        PIC S9(04) COMP.             
           05  SUB2                        PIC S9(04) COMP.             
           05  WS-NULL-IND1                PIC S9(04) COMP   VALUE 0.   
           05  WS-MISC-INDX                PIC 9(09) COMP-3 VALUE 0.    
           05  WS-ROW-COUNT                PIC S9(09) USAGE COMP.       
           05  RS-RETURN-CODE              PIC S9(04) COMP.             
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
           05  WS-DISPLAY-ACCOUNT          PIC Z(13).                   
           05  WS-DATABASE                 PIC 9(1) VALUE ZERO.         
               88  CSR-DATABASE            VALUE 1.                     
               88  SEB-DATABASE            VALUE 2.                     
           05  WS-COMPANY                  PIC X(2) VALUE ZERO.         
               88  SCEG                    VALUE '01'.                  
               88  PSNC                    VALUE '26'.                  
           05  WS-COMPANY-NO1              PIC X(2) OCCURS 500 TIMES.   
           05  WS-LOCAL-OFFICE1            PIC X(3) OCCURS 500 TIMES.   
           05  WS-ZIP-CODE1                PIC X(5) OCCURS 500 TIMES.   
           05  WS-LOCATION-ID1             PIC X(6) OCCURS 500 TIMES.   
           05  WS-LOCATION-TYPE-CD1        PIC X(3) OCCURS 500 TIMES.   
           05  WS-LOCATION-ID2             PIC X(6) OCCURS 100 TIMES.   
           05  WS-LOCATION-TX2             PIC X(40) OCCURS 100 TIMES.  
           05  WS-PAY-AGCY-ADDRESS2        PIC X(35) OCCURS 100 TIMES.  
           05  WS-PAY-AGCY-CITY-ST2        PIC X(30) OCCURS 100 TIMES.  
           05  WS-HOLD-STRING              PIC X(200) VALUE SPACES.     
      *                                                                 00026600
       01 WS-PAY-AGCY-XREF-TABLE.                                       
ACT126     05  WS-PAY-AGCY-LINE OCCURS 2000.                            
               10  WS-PAY-COMPANY-NO       PIC X(2).                    
               10  WS-PAY-LOCAL-OFFICE     PIC X(3).                    
               10  WS-PAY-ZIP-CODE         PIC X(5).                    
               10  WS-PAY-LOCATION-ID      PIC X(6).                    
               10  WS-PAY-LOCATION-TYPE-CD PIC X(3).                    
ACT126     05  WS-PAY-SUB                  PIC 9(4) VALUE ZERO.         
ACT145     05  WS-MAX-PAY-SUB              PIC 9(4) VALUE 2000.         
      *                                                                 00026600
       01 WS-LOCATION-TABLE.                                            
           05  WS-LOCATION-LINE OCCURS 200.                             
               10  WS-LOCATION-ID          PIC X(6).                    
               10  WS-LOCATION-TX          PIC X(40).                   
               10  WS-PAY-AGCY-ADDRESS     PIC X(35).                   
               10  WS-PAY-AGCY-CITY-ST     PIC X(30).                   
           05  WS-LOC-SUB                  PIC 9(3) VALUE ZERO.         
      *                                                                 00026600
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08) VALUE 'SCSCA150'.  
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
      *                                                                 00027000
       COPY FIOCA00.                                                    00027100
       COPY FIOJC01.                                                    00027200
      * COPYBOOK FOR DB2 ERROR CHECK                                    00027300
       COPY CWS00303.                                                   00027400
      * WORKING STORAGE FOR REDUCE EMBEDDED BLANKS                              
       COPY CWS00023.                                                   00027500
      * WORKING STORAGE FOR SUPPLEMENTAL WQ TEXT                                
       COPY CWS0070B.                                                   00027500
      ***************************************************************** 00027600
      *  THIS COPYBOOK IS USED WITH THE CPD09900 INCLUDE MEMBER       * 00027700
      *  WHICH INVOKES THE ABEND ROUTINE                              * 00027800
      ***************************************************************** 00027900
       COPY CWS09900.                                                   00028000
      *                                                                 00028100
       COPY CWS00010.                                                   00028200
      *                                                                 00028300
           EXEC SQL                                                     00028600
                INCLUDE SQLCA                                           00028700
           END-EXEC.                                                    00028800
      *                                                                 00028900
           EXEC SQL                                                     00029000
                INCLUDE TBJBPARM                                        00029100
           END-EXEC.                                                    00029200
      *                                                                 00029300
      *********************************************************                 
      *          INCLUDE THE DCLGEN FOR CSS_PAY_AGCY_XREF     *                 
      *********************************************************                 
           EXEC SQL                                                             
               INCLUDE TBPAXREF                                                 
           END-EXEC.                                                            
      *********************************************************                 
      *          INCLUDE THE DCLGEN FOR CSS_LOCATION          *                 
      *********************************************************                 
           EXEC SQL                                                             
               INCLUDE TBLOC                                            00033800
           END-EXEC.                                                    00033900
      *                                                                 00034000
      **************************************************************    00034100
      *     DECLARE CURSOR FOR EXTRACTING CSS_PAY_AGCY_XREF        *            
      **************************************************************    00034100
                                                                        
           EXEC SQL                                                     
               DECLARE PAYMENT_AGENCY CURSOR WITH ROWSET POSITIONING FOR
                   SELECT COMPANY_NO                                    
                         ,LOCAL_OFFICE                                  
                         ,ZIP_CODE                                      
                         ,LOCATION_ID                                   
                         ,LOCATION_TYPE_CD                              
                     FROM CSS_PAY_AGCY_XREF WITH(READUNCOMMITTED)               
A03253               WHERE COMPANY_NO = :P8-COMPANY-NO                  
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00034300
MFA-TR*        DECLARE PAYMENT_AGENCY CURSOR WITH ROWSET POSITIONING FOR00034400
MFA-TR*            SELECT COMPANY_NO                                    00034500
MFA-TR*                  ,LOCAL_OFFICE                                          
MFA-TR*                  ,ZIP_CODE                                              
MFA-TR*                  ,LOCATION_ID                                           
MFA-TR*                  ,LOCATION_TYPE_CD                                      
MFA-TR*              FROM CSS_PAY_AGCY_XREF                             00034600
MFA-TR*              WHERE COMPANY_NO = :P8-COMPANY-NO                          
MFA-TR*        FOR FETCH ONLY WITH UR                                   00036510
MFA-TR*    END-EXEC.                                                    00034900
                                                                        
           EXEC SQL                                                     
               DECLARE LOCATION CURSOR WITH ROWSET POSITIONING FOR      
                   SELECT LOCATION_ID                                   
                         ,LOCATION_TX                                   
                         ,PAY_AGCY_ADDRESS                              
                         ,PAY_AGCY_CITY_ST                              
                     FROM CSS_LOCATION WITH(READUNCOMMITTED)                    
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00035100
MFA-TR*        DECLARE LOCATION CURSOR WITH ROWSET POSITIONING FOR      00035200
MFA-TR*            SELECT LOCATION_ID                                   00035300
MFA-TR*                  ,LOCATION_TX                                           
MFA-TR*                  ,PAY_AGCY_ADDRESS                                      
MFA-TR*                  ,PAY_AGCY_CITY_ST                                      
MFA-TR*              FROM CSS_LOCATION                                  00035400
MFA-TR*        FOR FETCH ONLY WITH UR                                   00036510
MFA-TR*    END-EXEC.                                                    00035700
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       COPY CWSCA150.                                                   00036900
                                                                        
       05  WS-PAY-SUB1                     PIC S9(04) COMP.             
       05  WS-BUS-SUB1                     PIC S9(04) COMP.             
       01  WS-SCSCA-RETURN-CODE            PIC S9(4) COMP.              
       01  LS-CURR-WQ-ITEM                 PIC S9(4) COMP.              
       01  WS-BILLING-WQ-ITEMS-WF.                                      
           05  WS-BILLING-WQ-ITEMS-DATA-WF                              
                   OCCURS 50 TIMES INDEXED BY WS-BILL-WQ-INDX.          
               10  WS-CATEGORY-ID-WF       PIC S9(04)  COMP.            
               10  WS-PRIORITY-WF          PIC X(1).                    
               10  WS-ROUTE-CATEGORY-WF    PIC X(01).                   
               10  WS-COMMENTS-WF.                                      
                   15  WS-COMMENTS-LEN-WF  PIC S9(04)  COMP.            
                   15  WS-COMMENTS-TEXT-WF PIC X(250).                  
ACT071         10  WS-CREATED-BY-WF        PIC X(16).                   
ACT071         10  FILLER                  PIC X(228).                  
                                                                        
       PROCEDURE DIVISION USING WS-SCSCA150-PARMS                       
                                WS-PAY-AGNCY-TABLE                      
                                WS-BUS-OFFICE-TABLE                     
                                WS-SCSCA-RETURN-CODE                    
                                LS-CURR-WQ-ITEM                         
                                WS-BILLING-WQ-ITEMS-WF.                 
      *                                                                 00041500
       0000-MAINLINE.                                                   
      *                                                                 00041700
                                                                        
           DISPLAY 'SCSCA150 - PAY AGENCY/BUSINESS OFFICE INFOMATION'.  
           PERFORM 0100-INITIALIZATION                THRU 0100-EXIT.   
                                                                        
           PERFORM 1000-PROCESS-PAY-AGENCY            THRU 1000-EXIT.   
                                                                        
           EXIT PROGRAM.                                                
      *                                                                 00043600
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  00044000
      * INITIALIZE THE VARIABLES & WHEN THE WS-CA150-FIRST-CALL-SW   *  00044100
      * IS 'Y' LOAD THE DATA FROM CSS_PAY_AGCY_XREF AND CSS_LOCATION.*  00044200
      * SET THE WS-CA150-FIRST-CALL-SW TO 'N'.                       *  00044300
      ****************************************************************  00044400
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE                            WS-EMB-INPUT           
                                                 WS-CMP-TABLE           
                                                 WS-PAY-AGNCY-TABLE     
                                                 WS-BUS-OFFICE-TABLE.   
           IF WS-CA150-FIRST-CALL-SW = WS-Y                             
A03253        MOVE WS-CA150-COMPANY-NO           TO P8-COMPANY-NO       
              PERFORM 0200-LOAD-PAY-AGCY-XREF    THRU 0200-EXIT         
              PERFORM 0300-LOAD-LOCATION         THRU 0300-EXIT         
              MOVE WS-N                   TO WS-CA150-FIRST-CALL-SW     
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   00044000
      * DUMP DATA FROM CSS_PAY_AGCY_XREF.                           *   00044100
      ***************************************************************   00047400
       0200-LOAD-PAY-AGCY-XREF.                                         
                                                                        
           PERFORM 7100-OPEN-PAY-AGCY-XREF       THRU 7100-EXIT.        
           MOVE 1                         TO WS-PAY-SUB.                
           MOVE 1                         TO WS-MISC-INDX.              
           PERFORM 7110-FETCH-PAY-AGCY-XREF      THRU 7110-EXIT         
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 7120-CLOSE-PAY-AGCY-XREF      THRU 7120-EXIT.        
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   00044000
      * DUMP DATA FROM CSS_LOCATION.                                *   00044100
      ***************************************************************   00047400
       0300-LOAD-LOCATION.                                              
                                                                        
           PERFORM 7200-OPEN-LOCATION            THRU 7200-EXIT.        
           MOVE 1                         TO WS-LOC-SUB.                
           MOVE 1                         TO WS-MISC-INDX.              
           PERFORM 7210-FETCH-LOCATION           THRU 7210-EXIT         
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
           PERFORM 7220-CLOSE-LOCATION           THRU 7220-EXIT.        
                                                                        
       0300-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************   00047400
      * PAY AGENCY / BUSINESS OFFICE PROCESSING.                    *   00047500
      ***************************************************************   00047600
                                                                        
       1000-PROCESS-PAY-AGENCY.                                         
                                                                        
           MOVE WS-CA150-DATABASE         TO WS-DATABASE.               
           EVALUATE WS-DATABASE                                         
               WHEN 1                                                   
                    PERFORM 1100-PROCESS-CSR      THRU 1100-EXIT        
               WHEN OTHER                                               
                    CONTINUE                                            
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00171200
      ***************************************************************   00047400
      * PAY AGENCY / BUSINESS OFFICE PROCESSING.                    *   00047500
      ***************************************************************   00047600
                                                                        
       1100-PROCESS-CSR.                                                
                                                                        
           MOVE WS-CA150-COMPANY-NO       TO WS-COMPANY.                
           EVALUATE WS-COMPANY                                          
               WHEN '26'                                                
                    MOVE 0                TO WS-PAY-SUB1                
                    PERFORM 1110-GET-PAY-AGNCY  THRU 1110-EXIT          
               WHEN '01'                                                
                    MOVE 0                TO WS-PAY-SUB1                
                    MOVE 0                TO WS-BUS-SUB1                
                    PERFORM 1120-GET-BUS-OFFICE THRU 1120-EXIT          
           END-EVALUATE.                                                
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00171200
       1110-GET-PAY-AGNCY.                                              
                                                                        
           PERFORM VARYING WS-PAY-SUB FROM 1 BY 1                       
ACT145       UNTIL WS-PAY-SUB > WS-MAX-PAY-SUB OR WS-PAY-SUB1 > 10      
                OR WS-PAY-COMPANY-NO(WS-PAY-SUB) = SPACES               
                IF WS-PAY-COMPANY-NO(WS-PAY-SUB) = WS-CA150-COMPANY-NO  
               AND WS-PAY-LOCAL-OFFICE(WS-PAY-SUB) =                    
                   WS-CA150-LOCAL-OFFICE                                
A03253         AND WS-PAY-ZIP-CODE(WS-PAY-SUB) = WS-CA150-SERVICE-ZIP   
                   MOVE WS-N              TO WS-LOC-FOUND-SW            
                   PERFORM VARYING WS-LOC-SUB FROM 1 BY 1               
                     UNTIL WS-LOC-SUB > 200 OR LOC-FOUND                
                     IF WS-LOCATION-ID(WS-LOC-SUB) =                    
                        WS-PAY-LOCATION-ID(WS-PAY-SUB)                  
                        ADD 1             TO WS-PAY-SUB1                
                        INITIALIZE WS-EMB-INPUT                         
                                   WS-CMP-TABLE                         
                                   WS-HOLD-STRING                       
                        STRING WS-LOCATION-TX(WS-LOC-SUB)               
                              ,', '                                     
                              ,WS-PAY-AGCY-ADDRESS(WS-LOC-SUB)          
                              ,', '                                     
                              ,WS-PAY-AGCY-CITY-ST(WS-LOC-SUB)          
                               DELIMITED BY '  '                        
                          INTO WS-HOLD-STRING                           
                         INSPECT WS-HOLD-STRING REPLACING ALL " , "     
                                 BY ",  "                               
                         MOVE WS-HOLD-STRING TO WS-EMB-INPUT            
                         MOVE 105         TO WS-EMB-LENG                
                         PERFORM 6010-REDUCE-EMBEDDED-SPACES            
                            THRU 6011-EXIT                              
                         MOVE WS-CMP-TABLE TO                           
                                        WS-PAY-AGNCY-LINE(WS-PAY-SUB1)  
                         MOVE WS-Y        TO WS-LOC-FOUND-SW            
                      END-IF                                            
                    END-PERFORM                                         
                END-IF                                                  
           END-PERFORM.                                                 
      *                                                                 00171200
       1110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00171200
       1120-GET-BUS-OFFICE.                                             
                                                                        
           PERFORM VARYING WS-PAY-SUB FROM 1 BY 1                       
ACT145       UNTIL WS-PAY-SUB > WS-MAX-PAY-SUB                          
                OR (WS-PAY-SUB1 + WS-BUS-SUB1) > 20                     
                OR WS-PAY-COMPANY-NO(WS-PAY-SUB) = SPACES               
                IF WS-PAY-COMPANY-NO(WS-PAY-SUB) = WS-CA150-COMPANY-NO  
               AND WS-PAY-ZIP-CODE(WS-PAY-SUB)   = WS-CA150-SERVICE-ZIP 
               AND WS-PAY-LOCAL-OFFICE(WS-PAY-SUB) =                    
                   WS-CA150-LOCAL-OFFICE                                
                   MOVE WS-N              TO WS-LOC-FOUND-SW            
                   PERFORM VARYING WS-LOC-SUB FROM 1 BY 1               
                     UNTIL WS-LOC-SUB > 200 OR LOC-FOUND                
                     IF WS-LOCATION-ID(WS-LOC-SUB) =                    
                        WS-PAY-LOCATION-ID(WS-PAY-SUB)                  
                        INITIALIZE WS-EMB-INPUT                         
                                   WS-CMP-TABLE                         
                                   WS-HOLD-STRING                       
                        STRING WS-LOCATION-TX(WS-LOC-SUB)               
                              ,', '                                     
                              ,WS-PAY-AGCY-ADDRESS(WS-LOC-SUB)          
                              ,', '                                     
                              ,WS-PAY-AGCY-CITY-ST(WS-LOC-SUB)          
                               DELIMITED BY '  '                        
                          INTO WS-HOLD-STRING                           
                         INSPECT WS-HOLD-STRING REPLACING ALL " , "     
                                 BY ",  "                               
                         MOVE WS-HOLD-STRING TO WS-EMB-INPUT            
                         MOVE 105         TO WS-EMB-LENG                
                         PERFORM 6010-REDUCE-EMBEDDED-SPACES            
                            THRU 6011-EXIT                              
                         EVALUATE WS-PAY-LOCATION-TYPE-CD (WS-PAY-SUB)  
                             WHEN 'PAY'                                 
                               IF WS-PAY-SUB1 <= 10                     
                                  ADD 1             TO WS-PAY-SUB1      
                                  MOVE WS-CMP-TABLE TO                  
                                       WS-PAY-AGNCY-LINE(WS-PAY-SUB1)   
                               END-IF                                   
                             WHEN 'LOC'                                 
                               IF WS-BUS-SUB1 <= 10                     
                                  ADD 1             TO WS-BUS-SUB1      
                                  MOVE WS-CMP-TABLE TO                  
                                       WS-BUS-OFFICE-LINE(WS-BUS-SUB1)  
                               END-IF                                   
                         END-EVALUATE                                   
                         MOVE WS-Y        TO WS-LOC-FOUND-SW            
                      END-IF                                            
                    END-PERFORM                                         
                END-IF                                                  
           END-PERFORM.                                                 
      *                                                                 00171200
       1120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00171200
      **************************************************************    00171300
      *  FETCH ALL THE PAYMENT AGENCY CROSS REFERENCE INFORMATION  *    00171400
      **************************************************************    00171500
       7100-OPEN-PAY-AGCY-XREF.                                         
                                                                        
      *                                                                 00171900
            EXEC SQL                                                    
                OPEN PAYMENT_AGENCY                                     
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL          
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'CSS_PAY_AGCY_XREF'   TO TABLE-1                    
               MOVE '7100'                TO   ACTIVE-PARAGRAPH         
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00174000
       7110-FETCH-PAY-AGCY-XREF.                                        
                                                                        
           MOVE 0                         TO WS-ROW-COUNT.              

MSQ008     MOVE 500 TO MSQ008-PAYMENT-AGENCY
                                                                        
           EXEC SQL                                                     
               FOR :MSQ008-PAYMENT-AGENCY
              FETCH 
              FROM PAYMENT_AGENCY        
                INTO :WS-COMPANY-NO1                                    
                    ,:WS-LOCAL-OFFICE1                                  
                    ,:WS-ZIP-CODE1                                      
                    ,:WS-LOCATION-ID1                                   
                    ,:WS-LOCATION-TYPE-CD1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     00174300
MFA-TR*        FETCH NEXT ROWSET FROM PAYMENT_AGENCY FOR 500 ROWS       00090900
MFA-TR*         INTO :WS-COMPANY-NO1                                    00174500
MFA-TR*             ,:WS-LOCAL-OFFICE1                                  00174500
MFA-TR*             ,:WS-ZIP-CODE1                                      00174500
MFA-TR*             ,:WS-LOCATION-ID1                                   00174500
MFA-TR*             ,:WS-LOCATION-TYPE-CD1                              00174600
MFA-TR*    END-EXEC.                                                    00176100

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-PAYMENT-AGENCY
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                   TO   WS-ACTIVE-RETURN-CODE.   
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   PERFORM UNTIL WS-MISC-INDX > 500                     
                      MOVE WS-COMPANY-NO1 (WS-MISC-INDX)                
                        TO WS-PAY-COMPANY-NO (WS-PAY-SUB)               
                      MOVE WS-LOCAL-OFFICE1 (WS-MISC-INDX)              
                        TO WS-PAY-LOCAL-OFFICE (WS-PAY-SUB)             
                      MOVE WS-ZIP-CODE1(WS-MISC-INDX)                   
                        TO WS-PAY-ZIP-CODE (WS-PAY-SUB)                 
                      MOVE WS-LOCATION-ID1 (WS-MISC-INDX)               
                        TO WS-PAY-LOCATION-ID (WS-PAY-SUB)              
                      MOVE WS-LOCATION-TYPE-CD1 (WS-MISC-INDX)          
                        TO WS-PAY-LOCATION-TYPE-CD(WS-PAY-SUB)          
                       ADD 1              TO WS-PAY-SUB                 
                       ADD 1              TO WS-MISC-INDX               
                   END-PERFORM                                          
               WHEN NOT-FOUND                                           
               WHEN 354                                                 
                   EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT                      
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                             00176600
MFA-TR*                  :WS-ROW-COUNT = ROW_COUNT                      00176600
MFA-TR*            END-EXEC                                             00176600
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-ROW-COUNT
                   PERFORM UNTIL WS-MISC-INDX > WS-ROW-COUNT            
                      MOVE WS-COMPANY-NO1 (WS-MISC-INDX)                
                        TO WS-PAY-COMPANY-NO (WS-PAY-SUB)               
                      MOVE WS-LOCAL-OFFICE1 (WS-MISC-INDX)              
                        TO WS-PAY-LOCAL-OFFICE (WS-PAY-SUB)             
                      MOVE WS-ZIP-CODE1(WS-MISC-INDX)                   
                        TO WS-PAY-ZIP-CODE (WS-PAY-SUB)                 
                      MOVE WS-LOCATION-ID1 (WS-MISC-INDX)               
                        TO WS-PAY-LOCATION-ID (WS-PAY-SUB)              
                      MOVE WS-LOCATION-TYPE-CD1 (WS-MISC-INDX)          
                        TO WS-PAY-LOCATION-TYPE-CD(WS-PAY-SUB)          
                      ADD 1               TO WS-PAY-SUB                 
                      ADD 1               TO WS-MISC-INDX               
                   END-PERFORM                                          
               WHEN OTHER                                               
                   MOVE '  '              TO WS-DB2-TABLE-ID            
                   MOVE 'FETCH'           TO WS-DB2-FUNCTION            
                   MOVE SQLCODE           TO WS-DB2-RETURN-CODE         
                   MOVE '158'             TO WS-DB2-MODULE-ID           
                   MOVE '7110'            TO WS-DB2-PARAGRAPH           
                   MOVE 'CSS_PAY_AGCY_XREF'  TO TABLE-1                 
                   MOVE 12                TO RETURN-CODE                
                   DISPLAY '*** IN 7110-FETCH-PAY-AGCY-XREF ***'        
                   DISPLAY '*** SQL CODE = ' SQLCODE                    
                   PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT       
           END-EVALUATE.                                                
           MOVE 1                         TO WS-MISC-INDX.              
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-CLOSE-PAY-AGCY-XREF.                                        
                                                                        
            EXEC SQL                                                    
              CLOSE PAYMENT_AGENCY                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO   WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'CSS_PAY_AGCY_XREF'   TO TABLE-1                    
               MOVE '7120'                TO ACTIVE-PARAGRAPH           
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00182800
      **************************************************************    00171300
      *  FETCH ALL LOCATION_TX, PAY_AGCY_ADDRESS,PAY_ACY_CITY_ST   *    00171400
      **************************************************************    00171500
       7200-OPEN-LOCATION.                                              
                                                                        
      *                                                                 00171900
            EXEC SQL                                                    
                OPEN LOCATION                                           
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'CSS_LOCATION     '   TO TABLE-1                    
               MOVE '7200'                TO ACTIVE-PARAGRAPH           
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00174000
       7210-FETCH-LOCATION.                                             
                                                                        
           MOVE 0                         TO WS-ROW-COUNT.              

MSQ008     MOVE 100 TO MSQ008-LOCATION
                                                                        
           EXEC SQL                                                     
               FOR :MSQ008-LOCATION
              FETCH 
              FROM LOCATION              
                INTO :WS-LOCATION-ID2                                   
                    ,:WS-LOCATION-TX2                                   
                    ,:WS-PAY-AGCY-ADDRESS2                              
                    ,:WS-PAY-AGCY-CITY-ST2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     00174300
MFA-TR*        FETCH NEXT ROWSET FROM LOCATION FOR 100 ROWS             00090900
MFA-TR*         INTO :WS-LOCATION-ID2                                   00174500
MFA-TR*             ,:WS-LOCATION-TX2                                   00174600
MFA-TR*             ,:WS-PAY-AGCY-ADDRESS2                              00174600
MFA-TR*             ,:WS-PAY-AGCY-CITY-ST2                              00174600
MFA-TR*    END-EXEC.                                                    00176100

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-LOCATION
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                   TO   WS-ACTIVE-RETURN-CODE.   
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   PERFORM UNTIL WS-MISC-INDX > 100                     
                       MOVE WS-LOCATION-ID2(WS-MISC-INDX)               
                         TO WS-LOCATION-ID(WS-LOC-SUB)                  
                       MOVE WS-LOCATION-TX2(WS-MISC-INDX)               
                         TO WS-LOCATION-TX (WS-LOC-SUB)                 
                       MOVE WS-PAY-AGCY-ADDRESS2(WS-MISC-INDX)          
                         TO WS-PAY-AGCY-ADDRESS (WS-LOC-SUB)            
                       MOVE WS-PAY-AGCY-CITY-ST2(WS-MISC-INDX)          
                         TO WS-PAY-AGCY-CITY-ST (WS-LOC-SUB)            
                       ADD 1              TO WS-LOC-SUB                 
                       ADD 1              TO WS-MISC-INDX               
                   END-PERFORM                                          
               WHEN NOT-FOUND                                           
                   EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT                      
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                             00176600
MFA-TR*                  :WS-ROW-COUNT = ROW_COUNT                      00176600
MFA-TR*            END-EXEC                                             00176600
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-ROW-COUNT
                   PERFORM UNTIL WS-MISC-INDX > WS-ROW-COUNT            
                      MOVE WS-LOCATION-ID2(WS-MISC-INDX)                
                        TO WS-LOCATION-ID(WS-LOC-SUB)                   
                      MOVE WS-LOCATION-TX2(WS-MISC-INDX)                
                        TO WS-LOCATION-TX (WS-LOC-SUB)                  
                      MOVE WS-PAY-AGCY-ADDRESS2(WS-MISC-INDX)           
                        TO WS-PAY-AGCY-ADDRESS (WS-LOC-SUB)             
                      MOVE WS-PAY-AGCY-CITY-ST2(WS-MISC-INDX)           
                        TO WS-PAY-AGCY-CITY-ST (WS-LOC-SUB)             
                      ADD 1               TO WS-LOC-SUB                 
                      ADD 1               TO WS-MISC-INDX               
                   END-PERFORM                                          
               WHEN OTHER                                               
                   MOVE '  '                 TO WS-DB2-TABLE-ID         
                   MOVE 'FETCH'              TO WS-DB2-FUNCTION         
                   MOVE SQLCODE              TO WS-DB2-RETURN-CODE      
                   MOVE '158'                TO WS-DB2-MODULE-ID        
                   MOVE '7210'               TO WS-DB2-PARAGRAPH        
                   MOVE 'CSS_LOCATION     '  TO TABLE-1                 
                   MOVE 12                   TO RETURN-CODE             
                   DISPLAY '*** IN 7210-FETCH-LOCATION      ***'        
                   DISPLAY '*** SQL CODE = ' SQLCODE                    
                   PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT       
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-CLOSE-LOCATION.                                             
                                                                        
            EXEC SQL                                                    
              CLOSE LOCATION                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL          
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'CSS_LOCATION     '   TO TABLE-1                    
               MOVE '7220'                TO ACTIVE-PARAGRAPH           
               PERFORM 9700-PROCESS-ABEND             THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00182800
      *  REDUCE EMBEDDED BLANKS                                         00196270
       COPY CPD00004.                                                   00196300
                                                                        
      *  9700-PROCESS-ABEND.                                            00196500
       COPY CPD0023B.                                                   00196600
      *                                                                 00196700
      ******************************************************************00196800
      * RETURNS TO CALLING PROGRAM UNDER ABNORMAL CONDITIONS WITH A    *00196900
      * APPROPRIATE MESG AND RETURN-CODE 9                             *00197000
      ******************************************************************00197100
                                                                        
       9900-ABEND.                                                      
           MOVE TABLE-1                   TO WS-DB2-TABLE-ID.           
           MOVE ABEND-FUNCTION            TO WS-DB2-FUNCTION.           
           MOVE RS-RETURN-CODE            TO WS-DB2-RETURN-CODE.        
           MOVE '158'                     TO WS-DB2-MODULE-ID.          
           MOVE ACTIVE-PARAGRAPH          TO WS-DB2-PARAGRAPH.          
           MOVE HOSTVAR-ELEMENT-1         TO WS-DB2-KEY-1.              
           MOVE HOSTVAR-ELEMENT-2         TO WS-DB2-KEY-2.              
           MOVE 12                        TO RETURN-CODE.               
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16                     TO RETURN-CODE                
           ELSE                                                         
              ADD 1                       TO LS-CURR-WQ-ITEM            
              SET WS-BILL-WQ-INDX         TO LS-CURR-WQ-ITEM            
              MOVE WS-SQL-ERROR-TXT-WQ    TO                            
                   WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
ACT071        MOVE WS-PGRMNAME            TO                            
ACT071             WS-CREATED-BY-WF (WS-BILL-WQ-INDX)                   
           END-IF.                                                      
           PERFORM 9999-BAIL-OUT                     THRU 9999-EXIT.    
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-BAIL-OUT.                                                   
                                                                        
           MOVE RETURN-CODE               TO  WS-SCSCA-RETURN-CODE.     
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
