       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   SCSCA121.                                          
      ***************************************************************** 00030000
      *                                                               * 00040000
      *                SOUTH CAROLINA ELECTRIC & GAS                  * 00050000
      *                       PRICE WATERHOUSE                        * 00060000
      *                                                               * 00070000
      *                 CUSTOMER INFORMATION SYSTEM                   * 00080000
      *                                                               * 00090000
      ***************************************************************** 00100000
      *                 P R O G R A M   S U M M A R Y                 * 00110000
      *                                                               * 00120000
      * RECEIVES DATA FROM THE DRIVER PROGRAM PCSKR150 AND WRITES THE * 00130000
      * NON-MARKETING LETTERS & NOTICES FILE FOR EXSTREAM.  IT        * 00140000
      * POPULATES THE SERVICE ADDRESSES AND MAILING ADDRESSES FOR     * 00150000
      * ACCOUNTS & ITPA.  THIS PROGRAM IS THE DRIVER FOR THE CLFN     * 00160000
      * ADDRESS PROCESSING PROGRAM SCSCA184.                          * 00170000
      *                                                               * 00180000
      ***************************************************************** 00190000
      *                                                               * 00200000
      *               PROGRAM  MODIFICATION  LOG                      * 00210000
      *      DATE    INITIALS     REASON                              * 00220000
      *    ________  ________     __________________________________  * 00230000
P00599*    08/22/12    DMS        INITIAL VERSION                     * 00240000
P00599*    02/05/13    DMS        CORRECT UNMASK FILE SORT CODE       * 00250000
P00599*    02/06/13    DMS        USE TPGN LETTER UNIQUE ID FOR       * 00251000
      *                           DUPLICATE NOTICE                    * 00252000
A04735*    08/08/13    MC95456    REMOVED DCLGEN OF CSS_CUST_COMM_MF  * 00260000
A04815*    03/18/14    MJ13662    WHEN WRITING WQ, CORRECTED DATE     * 00261000
      *                           CHECK AND MISSING CUSTOMER NO       * 00262000
      *                           AND DELETED 2300-CENTURY DATE CHECK.* 00263000
A04897*    10/01/14    SV95326    BUSINESS OFFICE CLOSING LETTER 75008*.00264000
ACT135*    11/05/14    BD09555    PROCESS REFUND ADDRESS FROM         *.00265000
ACT135*  A04880                   CSS_CORRESP_VAR TABLE WHEN PRESENT  *.00266000
A04127*    11/24/14    MJ13662    IF ALOC OR ITPA IS BEING GENERATED  * 00267000
A04127*                           MOVE 'A'                            * 00267100
A04127*                           TO WS-ALOC-ITPA-PROCESS SO THAT IN  * 00268000
A04127*                           SCSCA184, BUSINESS FIRST-NAME AND   * 00269000
A04127*                           LAST-NAME WILL BE USED ON LETTER    * 00269100
A04127*                           INSTEAD OF FULL-NAME.               * 00269200
A04860**   02/05/15   AS7C117     REPLACE CSS_WQ_ITEMS_MF WITH        * 00269300
A04860**              ACT059      CSS_WQ_ITEMS.                       * 00269400
A05198**   12/16/2015 MJ13662     USE WS-EXT-ALPHA-VARIABLE(6) ON     * 00269500
A05198**                          SELECT TO CSS_CRED_BUREAU_RD. THIS  * 00269600
A05198**                          CONTAINS SCORE-MODEL-CD (A OR B)    * 00269700
A05382**   02/07/2016 MJ13662     ADDED LOGIC FOR RISK BASED PRICING  * 00269800
A05382**                          LETTER - 90704.                     * 00269900
ACT045**   02/24/2017 BD09555     CHANGED SIGNATURE FROM MARK CANNON  * 00270001
ACT045**                          TO IRIS GRIFFIN                     * 00270101
      ***************************************************************** 00271000
      *                                                               * 00280000
      *         -----    BASIC SEQUENCE STRUCTURE   -----             * 00290000
      * 0000         MODULE CONTROL                                   * 00300000
      * 0100 - 0999  INITIALIZATION                                   * 00310000
      * 1000 - 1999  FUNCTIONAL CONTROL                               * 00320000
      * 2000 - 4999  DETAIL LOGIC                                     * 00330000
      * 5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES               * 00340000
      * 6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)     * 00350000
      * 7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.    * 00360000
      * 8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC    * 00370000
      * 9000 - 9999  ABEND / ERROR ROUTINES.                          * 00380000
      *                                                               * 00390000
      ***************************************************************** 00400000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00420000
       INPUT-OUTPUT SECTION.                                            
      *                                                                 00440000
       FILE-CONTROL.                                                    
           COPY CSSKR150.                                               00460000
HPCCDM*    EJECT                                                        00470000
      *                                                                 00480000
       DATA DIVISION.                                                   
      *                                                                 00500000
       FILE SECTION.                                                    
      *                                                                 00520000
       COPY CFDKR150.                                                   00530000
       01  EXTMCLFN                         PIC X(1375).                
      *                                                                 00550000
HPCCDM*EJECT                                                            00560000
      *                                                                 00570000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA121'.
MSQ017     COPY MFASQLM.
      *                                                                 00590000
       01  WS-NAME-ADDR-TABLE.                                          
           05  WS-NAME-ADDR-ENTRY           OCCURS  6                   
                                            INDEXED BY WS-NM-ADDR-INDX. 
               10 WS-NAME-ADDR-TYPE         PIC X(02).                  
               10 WS-NAME-ADDR-LINE         PIC X(50).                  
      *                                                                 00650000
       01  WS-HOLD-SW                       PIC X(1) VALUE 'N'.         
       01  WS-HOLD-KEY.                                                 
           05 WS-HOLD-MESS-REC-SEQ          PIC X(03).                  
           05 WS-HOLD-MESS-REC-ID           PIC X(8).                   
       01  WS-HOLD-MESS.                                                
           05 WS-HOLD-MESS-MSG1             PIC X(255).                 
           05 WS-HOLD-MESS-MSG2             PIC X(255).                 
           05 WS-HOLD-MESS-MSG3             PIC X(255).                 
           05 WS-HOLD-MESS-MSG4             PIC X(255).                 
           05 WS-HOLD-MESS-MSG5             PIC X(255).                 
       01  WS-HOLD-ISMASKED                 PIC X(1) VALUE 'N'.         
      *                                                                 00850000
       01  HOLD-EXTMCLFN                    PIC X(1375).                
       01  HOLD-EXTHDR.                                                 
P00599     05  FILLER                       PIC X(132).                 
P00599     05  WS-HOLD-UNIQUE-ID            PIC X(9).                   
P00599     05  FILLER                       PIC X(1234).                
       01  HOLD-EXTNOTC                     PIC X(1375).                
       01  HOLD-EXTMAIL                     PIC X(1375).                
       01  HOLD-EXTVAR                      PIC X(1375).                
       01  HOLD-EXTAINFO.                                               
           05  FILLER                       PIC X(232).                 
           05  WS-HOLD-OMR.                                             
               10  WS-HOLD-OMR-MARK-1         PIC X.                    
               10  WS-HOLD-OMR-MARK-2         PIC X.                    
               10  WS-HOLD-OMR-MARK-3         PIC X.                    
               10  WS-HOLD-OMR-MARK-4         PIC X.                    
               10  WS-HOLD-OMR-MARK-5         PIC X.                    
               10  WS-HOLD-OMR-MARK-6         PIC X.                    
               10  WS-HOLD-OMR-MARK-7         PIC X.                    
               10  WS-HOLD-OMR-MARK-8         PIC X.                    
               10  WS-HOLD-OMR-MARK-9         PIC X.                    
               10  WS-HOLD-OMR-MARK-10        PIC X.                    
               10  WS-HOLD-OMR-MARK-11        PIC X.                    
               10  WS-HOLD-OMR-MARK-12        PIC X.                    
               10  WS-HOLD-OMR-MARK-13        PIC X.                    
           05  WS-HOLD-TOTAL-SHEET          PIC 9(2).                   
           05  FILLER                       PIC X(1128).                
      *                                                                 00940000
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'SCSCA121'. 
A04860     05  SCSCB077                     PIC X(08) VALUE 'SCSCB077'. 
           05  WS-Y                         PIC X(01) VALUE 'Y'.        
           05  WS-N                         PIC X(01) VALUE 'N'.        
           05  WS-SIGNATURE-BRKDWN.                                     
               10  FILLER                   PIC X(2)  VALUE '@'.       
               10  WS-SIG-NAME              PIC X(12) VALUE             
                                              'IRIS GRIFFIN'.           
               10  FILLER                   PIC X(2)  VALUE '@'.       
               10  FILLER                   PIC X(7)  VALUE SPACES.     
           05  WS-SIGNATURE REDEFINES                                   
                        WS-SIGNATURE-BRKDWN PIC X(25).                  
      *                                                                 01080000
       01  WS-PROG-MISC.                                                
           05  WS-FCSKR150-STATUS           PIC X(02).                  
               88  KR150-SUCCESSFUL         VALUE '00'.                 
           05  WS-811                       PIC S9(4) COMP VALUE -811.  
           05  WS-REC-SKIPPED               PIC 9(9)  VALUE 0.          
           05  WS-RED-FL-NULL-IND           PIC S9(4) COMP  VALUE 0.    
           05  WS-NULL-IND1                 PIC S9(04) COMP VALUE 0.    
           05  WS-DATABASE                  PIC 9(01) VALUE 0.          
               88  CSR-DATABASE             VALUE 1.                    
               88  SEB-DATABASE             VALUE 2.                    
                                                                        
           05  HOLD-ACCOUNT-NO              PIC X(13) VALUE SPACES.     
           05  HOLD-CUSTOMER-NO             PIC X(10) VALUE SPACES.     
           05  HOLD-MESSAGE-NO              PIC 9(05) VALUE 0.          
           05  HOLD-COAPPLICANT-NAME        PIC X(50) VALUE SPACES.     
           05  HOLD-MAIL-ADDRESS            VALUE SPACES.               
               10  HOLD-MAILING-ADDRESS     PIC X(50) OCCURS 6.         
           05  WS-HOLD-CUSTOMER-NAME        PIC X(50) VALUE SPACES.     
           05  WS-HOLD-SERVICE-ADDRESS      PIC X(50) OCCURS 3.         
           05  WS-HOLD-ZIPCODE              PIC X(11) VALUE SPACES.     
           05  WS-HOLD-PR-ZIP-CODE          PIC X(05) VALUE SPACES.     
COB305     05 WS-HOLD-CUST-NO        PIC S9(10)V COMP-3 VALUE 0.       
           05  WS-HOLD-COMPANY-NO           PIC  X(02).                 
               88 SCEG                      VALUE '01'.                 
               88 PSNC                      VALUE '26'.                 
           05  WS-INITIAL-COMMENT-TX.                                   
               10 WS-INITIAL-COMMENT-TX-LEN PIC S9(4) USAGE COMP.       
               10 WS-INITIAL-COMMENT-TX-TEXT                            
                                            PIC X(255).                 
           05  WS-TIMESTAMP                 PIC X(26) VALUE SPACES.     
           05  WS-DISPLAY-SCSCA             PIC X(08).                  
           05  WS-END-NULL-IND              PIC S9(4) COMP  VALUE 0.    
           05  SCSCA184                     PIC  X(08) VALUE 'SCSCA184'.
           05  SCSCA150                     PIC  X(08) VALUE 'SCSCA150'.
           05  WS-SUB                       PIC 9(01)  VALUE ZEROS.     
           05  WS-SUB1                      PIC 9(01)  VALUE ZEROS.     
           05  WS-CHECKED-DATE.                                         
               10 WS-CKD-DATE-YY            PIC 9(2)  VALUE ZEROES.     
               10 WS-CKD-DATE-MM            PIC 9(2)  VALUE ZEROES.     
               10 WS-CKD-DATE-DD            PIC 9(2)  VALUE ZEROES.     
           05  WS-CURRNT-CC                 PIC 9(2) VALUE 19.          
           05  WS-NXT-CC                    PIC 9(2) VALUE 20.          
           05  VNDR-NAME-TBL.                                           
               10  WS-PHONECHG-01           PIC X(02) VALUE 'V1'.       
               10  WS-PHONECHG-26           PIC X(02) VALUE 'V2'.       
               10  WS-EQUIFAX-01            PIC X(02) VALUE 'V3'.       
               10  WS-EQUIFAX-26            PIC X(02) VALUE 'V4'.       
           05  WS-REGULATED-FLAG            PIC X VALUE 'N'.            
               88  DEREG-ACCOUNT            VALUE 'N'.                  
               88  REGULATED-ACCOUNT        VALUE 'Y'.                  
               88  SVC-ACCOUNT              VALUE 'V'.                  
           05  WS-INSERT-MARK OCCURS 13     PIC X VALUE '0'.            
           05  WS-TP-FLAG                   PIC X VALUE 'N'.            
           05  WS-GN-FLAG                   PIC X VALUE 'N'.            
               88  GUARNTR                  VALUE 'Y'.                  
           05  WS-TPGN                      PIC X VALUE 'N'.            
               88  NOT-TPGN                 VALUE 'N'.                  
               88  TPGN                     VALUE 'Y'.                  
           05  WS-TMP-ACCOUNT-NBR           PIC X(13) VALUE SPACES.     
           05  WS-TMP-PHONE                 PIC X(10) VALUE SPACES.     
           05  WS-HOLD-ALPHA-VAR            PIC X(25) VALUE SPACES.     
           05  WS-DATE-8.                                               
               10 WS-DATE-MM                PIC X(2)  VALUE SPACES.     
               10 FILLER                    PIC X     VALUE '/'.        
               10 WS-DATE-DD                PIC X(2)  VALUE SPACES.     
               10 FILLER                    PIC X     VALUE '/'.        
               10 WS-DATE-YY                PIC X(2)  VALUE SPACES.     
           05  WS-WQ-DATE-10.                                           
               10  WS-WQ-DATE-CC            PIC X(2)  VALUE SPACES.     
               10  WS-WQ-DATE-YY            PIC X(2)  VALUE SPACES.     
               10  FILLER                   PIC X     VALUE '-'.        
               10  WS-WQ-DATE-MM            PIC X(2)  VALUE SPACES.     
               10  FILLER                   PIC X     VALUE '-'.        
               10  WS-WQ-DATE-DD            PIC X(2)  VALUE SPACES.     
           05  WS-TABLE-NAME                PIC X(20).                  
           05  WS-PARA-NAME                 PIC X(30).                  
           05  WS-HOLD-ALPHA-VARIABLE-1     PIC X(25) VALUE SPACES.     
           05  WS-HOLD-ALPHA-VARIABLE-2     PIC X(25) VALUE SPACES.     
           05  WS-HOLD-ALPHA-VARIABLE-3     PIC X(25) VALUE SPACES.     
           05  WS-HOLD-ALPHA-VARIABLE-4     PIC X(25) VALUE SPACES.     
           05  WS-PARAGRAPH-CD              PIC X(01) VALUE SPACE.      
           05  WS-NOT-FOUND-CNTR            PIC 9.                      
           05  SUB1                         PIC 9(3)  VALUE 0.          
           05  SUB2                         PIC 9(3)  VALUE 0.          
           05  WS-NOT-FOUND-RC-TB           OCCURS 4 TIMES.             
               10  WS-NOT-FOUND-RC-TYPE     PIC X(1).                   
               10  FILLER                   PIC X(1).                   
               10  WS-NOT-FOUND-CB-RC       PIC X(5).                   
A05198         10  WS-NOT-FOUND-MODEL-CD    PIC X(1).                   
           05  DISPLAY-NOT-FOUND-TXT.                                   
               10  DISPLAY-STRING           PIC X(46).                  
               10  DISPLAY-NOT-FOUND-TXT-LINE OCCURS 4 TIMES.           
A05198             15  WS-NOT-FND-ITEM      PIC X(53).                  
           05  WS-DISPLAY-SQL-CODE          PIC S9(3) USAGE DISPLAY.    
           05  WS-CUST-NO-DISPLAY           PIC 9(10) USAGE DISPLAY.    
COB305     05 WS-HOLD-ACCT-NBR        PIC S9(13) COMP-3 VALUE 0.         
           05  RS-RETURN-CODE-DISP          PIC -Z(4).                  
           05  WS-MAIL-ADDR-LINES.                                      
               10  WS-MAIL-ADDR-LINE-1      PIC X(50).                  
               10  WS-MAIL-ADDR-LINE-2      PIC X(50).                  
               10  WS-MAIL-ADDR-LINE-3      PIC X(50).                  
               10  WS-MAIL-ADDR-LINE-4      PIC X(50).                  
               10  WS-MAIL-ADDR-LINE-5      PIC X(50).                  
               10  WS-MAIL-ADDR-LINE-6      PIC X(50).                  
           05  WS-ACCOUNT-NO-TEMP.                                      
               10 ACCOUNT-NO-TEMP           PIC X(13).                  
               10 ACCOUNT-NO-TEMP-1         PIC X(12).                  
           05 WS-HOLD-ACCOUNT-NO            PIC X(13).                  
           05  WS-CA166-PGRM-NAME           PIC X(08) VALUE 'SCSCA121'. 
           05  WS-VENDOR-NAME               PIC X(50) VALUE SPACES.     
           05  WS-HOLD-DATE-CC              PIC X(2) VALUE SPACES.      
           05  WS-HOLD-FILE-SORT            PIC X(02) VALUE SPACES.     
           05  WS-CHECK-DIGIT-FIELDS.                                   
               10  WS-CHECK-DIGIT           PIC 9.                      
               10  WS-CHECKED-PROD          PIC S99  VALUE +0.          
               10  WS-CHECKED-SUM           PIC S999 VALUE +0.          
               10  WS-CHECKED-EDIT          PIC 999.                    
               10  WS-CHECKED-EDITX REDEFINES WS-CHECKED-EDIT.          
                   15  F                    PIC 99.                     
                   15  WS-LAST-DIGIT        PIC 9.                      
               10  WS-EDIT-ACC.                                         
                   15  WS-EDIT-ACCT1        PIC X(13).                  
                   15  WS-EDIT-ACCT2        PIC X.                      
               10  WS-EDIT-CHECK-ACCT.                                  
                   15  WS-ACC1              PIC 9.                      
                   15  WS-ACC2              PIC 9.                      
                   15  WS-ACC3              PIC 9.                      
                   15  WS-ACC4              PIC 9.                      
                   15  WS-ACC5              PIC 9.                      
                   15  WS-ACC6              PIC 9.                      
                   15  WS-ACC7              PIC 9.                      
                   15  WS-ACC8              PIC 9.                      
                   15  WS-ACC9              PIC 9.                      
                   15  WS-ACC10             PIC 9.                      
                   15  WS-ACC11             PIC 9.                      
                   15  WS-ACC12             PIC 9.                      
                   15  WS-ACC13             PIC 9.                      
                   15  WS-ACC14             PIC 9.                      
      *                                                                 02590000
       01  WS-THD-PRTY-DETAILS.                                         
           10  WS-TP-NAME                   PIC X(70).                  
           10  WS-THD-PRTY-ADDRESS.                                     
               15  WS-TP-ADDR-STREET        PIC X(55).                  
               15  WS-TP-ADDRESS-OVERFLOW   PIC X(35).                  
               15  WS-TP-ADDR-CITY-STATE    PIC X(30).                  
               15  WS-TP-ADDR-ZIP-CODE      PIC X(09).                  
               15  WS-TP-ADDR-COUNTRY       PIC X(35).                  
               15  WS-TP-ADDR-USPS-DELPT-CD PIC X(02).                  
               15  WS-TP-VALIDATION-TS      PIC X(26).                  
      *                                                                 02700000
       01  WS-PREMISE-ADDR.                                             
           05  WS-PR-STREET                     PIC X(79).              
           05  WS-PR-ADDR-OVERFLOW              PIC X(26).              
           05  WS-PR-ADDR-CITY-STATE            PIC X(30).              
           05  WS-PR-ADDR-CITY-STATE-ZIP        PIC X(41).              
           05  WS-PR-ADDR-ZIP.                                          
               10  WS-PR-ADDR-ZIP-CODE          PIC X(05).              
               10  WS-PR-ADDR-ZIP-PLUS-4        PIC X(04).              
               10  WS-PR-ADDR-USPS-DELIV-PT-CD  PIC X(02).              
      *                                                                 02800000
       01  WS-ALOC-NOT-FOUND-STR            PIC X(46) VALUE             
                   'UNIDENTIFIED CREDIT BUREAU RETURN CODES ARE:  '.    
      *                                                                 02830000
       01  WS-CB-RC-NOT-FOUND-STR.                                      
           05  DISPLAY-NOT-FOUND OCCURS 4 TIMES.                        
               10  FILLER                   PIC X(11) VALUE             
                   ' TYPE CODE='.                                       
               10  WS-DISPLAY-TYPE-CD       PIC X(1).                   
               10  FILLER                   PIC X(16) VALUE             
                   '  CRED. BUR. RC='.                                  
               10  WS-DISPLAY-CB-RC         PIC X(5).                   
A05198         10  WS-DISPLAY-MODEL-CD      PIC X(1).                   
A05198         10  FILLER                   PIC X(19) VALUE             
A05198             '  SCORE. MODEL. CD='.                               
      *                                                                 02920000
      *                                                                 02930000
       01  WS-BILLING-WQ-ITEMS-WF.                                      
           05  WS-BILLING-WQ-ITEMS-DATA-WF                              
                   OCCURS 50 TIMES INDEXED BY WS-BILL-WQ-INDX.          
               10  WS-CATEGORY-ID-WF        PIC S9(04)  COMP.           
               10  WS-PRIORITY-WF           PIC X(1).                   
               10  WS-ROUTE-CATEGORY-WF     PIC X(01).                  
               10  WS-COMMENTS-WF.                                      
                   15  WS-COMMENTS-LEN-WF   PIC S9(04)  COMP.           
                   15  WS-COMMENTS-TEXT-WF  PIC X(250).                 
               10  FILLER                   PIC X(244).                 
                                                                        
                                                                        
       01 WS-MST-SUB-ACCT-IND-AT            PIC X(01).                  
       01 WS-CODE-PRNT-BLL-MST-AT           PIC X(01).                  
       01 WS-CODE-TEMP-BILL-AT              PIC X(01).                  
       01 WS-SCSCA-RETURN-CODE              PIC S9(4) COMP.             
       01 LS-CURR-WQ-ITEM                   PIC S9(4) COMP.             
       01 WS-ERROR-REASON                   PIC X(30).                  
A04127 01 WS-ALOC-ITPA-PROCESS              PIC X(01).                  
                                                                        
      *****COPYBOOK FOR CREDIT SIMPLIFICATON *******************        03130000
       COPY FIOCOID.                                                    03140000
       COPY FIOCOKEY.                                                   03150000
      *****COPYBOOK FOR SCSCA184 WORKING STORAGE*****************       03160000
       COPY CWSCA184.                                                   03170000
       COPY CWSCA150.                                                   03180000
       COPY CWS00010.                                                   03190000
      *****REDUCES EMBEDDED BLANKS*******************************       03200000
       COPY CWS00011.                                                   03210000
      ********WS FOR DB2 & CICS ERROR PROCESSING*****************       03220000
       COPY CWS00303.                                                   03230000
      ********WS-ABEND-SWITCH************************************       03240000
       COPY CWS09900.                                                   03250000
      *  SUPPLEMENTAL WQ TEXT                                           03260000
       COPY CWS0070B.                                                   03270000
      ********SQLCA**********************************************       03280000
           EXEC SQL                                                     03290000
                INCLUDE SQLCA                                           03300000
           END-EXEC.                                                    03310000
      ******* TABLE DECLARATION FOR  CSS_CRED_ITPA_HIST  ********       03360000
           EXEC SQL                                                     03370000
               INCLUDE TBCRITPA                                         03380000
           END-EXEC.                                                    03390000
      ******* TABLE DECLARATION FOR CSS_DELINQUENCY  ************       03400000
           EXEC SQL                                                     03410000
               INCLUDE TBDELQ                                           03420000
           END-EXEC.                                                    03430000
      ******* TABLE DECLARATION FOR CSS_COMM_DATA ***************       03440000
           EXEC SQL                                                     03450000
              INCLUDE TBCOMDAT                                          03460000
           END-EXEC.                                                    03470000
      ******* CREDIT BUREAU RETURN CODES-CSS_CRED_BUREAU_RC *****       03520000
            EXEC SQL                                                    03530000
                 INCLUDE TBCRBURC                                       03540000
            END-EXEC.                                                   03550000
A04860*                                                                 03700100
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077     03700200
A04860      EXEC SQL                                                    03700300
A04860           INCLUDE CWS00077                                       03700400
A04860      END-EXEC.                                                   03700500
A04860*                                                                 03700600
      **********************************************************        03860000
       01  WS-END                           PIC X(40)                   
           VALUE 'WORKING STORAGE FOR SCSCA121 ENDS HERE  '.            
HPCCDM*    EJECT                                                        03890000
      *                                                                 03900000
       LINKAGE SECTION.                                                 
       COPY FIOCOINF.                                                   03920000
       COPY CWS00103.                                                   03930000
                                                                        
       01 WS-UPDATE-DB-FL             PIC X(01).                        
          88 UPDATE-DB-FL                        VALUE 'Y'.             
                                                                        
       01 RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.          
                                                                        
       01 WS-RECORD-CNT               PIC 9(02)  VALUE 0.               
                                                                        
      *                                                                 04010000
       PROCEDURE DIVISION USING WS-EXT-HDR                              
                                WS-EXT-NOTICE                           
                                WS-EXT-MAILING-DTL                      
                                WS-EXT-ALPHA-VARIABLE-DTL               
                                WS-EXT-ADDITIONAL-INFO                  
                                WS-EXT-PAYMENT-AGENCY                   
                                WS-EXT-BUS-OFFICE                       
                                WS-EXT-ALOC-DTL                         
                                WS-INTERNAL-VARIABLES                   
                                WS-UPDATE-DB-FL                         
                                RS-RETURN-CODE                          
                                WS-RECORD-CNT.                          
      *                                                                 04130000
       0000-MAINLINE.                                                   
      ******************************************************************04150000
      *   CONTROLS MAIN PROCESSING FLOW                                *04160000
      ******************************************************************04170000
                                                                        
            PERFORM 0100-INITIALIZE          THRU  0100-EXIT.           
                                                                        
            PERFORM 1000-PROCESSING          THRU  1000-EXIT.           
                                                                        
            PERFORM 9000-TERMINATE           THRU  9000-EXIT.           
                                                                        
      *                                                                 04250000
       0000-EXIT.                                                       
            GOBACK.                                                     
HPCCDM*     EJECT                                                       04280000
      *                                                                 04290000
       0100-INITIALIZE.                                                 
      ******************************************************************04310000
      * INITIALIZE RUN                                                 *04320000
      ******************************************************************04330000
      *                                                                 04340000
           INITIALIZE                  WS-FCSKR150-STATUS               
                                       WS-EXT-SORT-KEY                  
                                       WS-EXT-CORR-DATA                 
                                       WS-SCSCA-RETURN-CODE             
                                       WS-RECORD-CNT.                   
       0100-EXIT.                                                       
            EXIT.                                                       
HPCCDM*    EJECT                                                        04430000
      *                                                                 04440000
      ******************************************************************04450000
      * MAIN PROCESSING MODULE                                         *04460000
      ******************************************************************04470000
       1000-PROCESSING.                                                 
                                                                        
      ** GET VALUES FOR RECORD KEY                                      04620000
           MOVE WS-EXT-MESSAGE-ID           TO WS-EXT-KEY-MESSAGE-ID.   
           MOVE WS-EXT-STMT-DATE            TO WS-EXT-KEY-STMT-DATE.    
           MOVE WS-EXT-ACCOUNT-NO           TO WS-EXT-KEY-ACCOUNT-NO.   
           MOVE WS-EXT-CUSTOMER-NO          TO WS-EXT-KEY-CUSTOMER-NO.  
           MOVE WS-EXT-COMPANY-NO           TO WS-EXT-KEY-COMPANY-NO.   
           MOVE WS-EXT-REG-GROUP-CD         TO WS-EXT-KEY-REG-GROUP-CD. 
           MOVE WS-EXT-LOCAL-OFFICE         TO WS-EXT-KEY-LOCAL-OFFICE. 
                                                                        
           MOVE 'EN'                        TO WS-EXT-TRACK-STATUS-CD.  
                                                                        
           MOVE '01'                        TO C8-COMPANY-NO            
                                               WS-HOLD-COMPANY-NO.      
           MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
           PERFORM 7500-GET-DATABASE        THRU 7500-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
                                                                        
           IF SEB-DATABASE                                              
              PERFORM 5900-DETERMINE-COMPANY THRU 5900-EXIT             
           END-IF.                                                      
                                                                        
           PERFORM 2110-CALCULATE-CHECK-DIGIT THRU 2110-EXIT.           
                                                                        
      ** CHECK FOR COMPANY CONTACT FOR ALOC & ITPA LETTERS              04821000
           IF WS-EXT-MESSAGE-ID = (90701 OR 90799 OR 92063 OR 92064     
A05382                          OR 90704)                               
              AND ((WS-EXT-CONTACT-ADDR-ST = SPACES) OR                 
                   (WS-EXT-CONTACT-CITY-STATE = SPACES) OR              
                   (WS-EXT-CONTACT-ZIP    = SPACES))                    
              MOVE 'NO COMPANY CONTACT INFO'  TO WS-ERROR-REASON        
              PERFORM 9995-ERROR-ROUTINE THRU 9995-EXIT                 
           END-IF.                                                      
                                                                        
           MOVE 'N'                            TO   WS-TP-FLAG,         
                                                    WS-GN-FLAG          
                                                    WS-HOLD-ISMASKED.   
           IF WS-EXT-TYPE-CD = 'TP'                                     
              MOVE 'Y'                         TO   WS-TP-FLAG          
           END-IF.                                                      
      *                                                                 04970000
           IF WS-EXT-TYPE-CD = 'GN'                                     
              MOVE 'Y'                         TO   WS-GN-FLAG          
           END-IF.                                                      
      *                                                                 05010000
           EVALUATE WS-EXT-TYPE-CD                                      
              WHEN 'TP'                                                 
              WHEN 'GN'                                                 
                 IF  WS-EXT-ACCOUNT-NO NOT EQUAL HOLD-ACCOUNT-NO AND    
                     WS-EXT-MESSAGE-ID NOT EQUAL 90307                  
                     PERFORM 9996-ERROR-ROUTINE THRU 9996-EXIT          
                 ELSE                                                   
                     IF WS-EXT-MESSAGE-ID NOT EQUAL 90307               
                       MOVE WS-Y TO WS-TPGN                             
                     ELSE                                               
                      MOVE WS-N TO WS-TPGN                              
                     END-IF                                             
                 END-IF                                                 
              WHEN OTHER                                                
                    MOVE WS-N TO WS-TPGN                                
           END-EVALUATE.                                                
      *                                                                 05180000
           PERFORM 2500-FORMAT-OMR-MARKS           THRU 2500-EXIT.      
      *                                                                 05250000
      ** ALOC LETTERS - IF THERE IS A CREDIT SCORE SET FLAGS SO THAT    05250100
      ** THAT SCORE SHOWS ON THE AFP TO THE CUSTOMER AND THE PDF THAT   05250200
      ** GOES TO FILENET. MASK IT ON THE PDF THAT IS IMAGED IN CIS.     05250300
           IF WS-EXT-MESSAGE-ID EQUAL TO (90701 OR 90799 OR 90706 OR    
A05382                                    90704)                        
           AND WS-EXT-NUM-VARIABLE(1) > 0                               
                  MOVE 'MASKED'            TO WS-EXT-ALPHA-VARIABLE(10) 
                  MOVE 'Y'                 TO WS-HOLD-ISMASKED          
           END-IF.                                                      
                                                                        
      ** ALOC LETTERS - POPULATE ALOC REASON MSGS                       05252000
           IF WS-EXT-MESSAGE-ID EQUAL TO (90701 OR 90799 OR 90702 OR    
                                          90706 OR 90704)               
              INITIALIZE WS-HOLD-MESS, WS-HOLD-SW, WS-HOLD-KEY          
              PERFORM 3200-PROCESS-MESSAGES        THRU 3200-EXIT       
           END-IF.                                                      
                                                                        
      ** FOR 2ND COPY OF ITPA LETTER ENSURE THAT PREVIOUS LETTER WAS    05360000
      ** AN ITPA LETTER.                                                05370000
           IF  WS-EXT-MESSAGE-ID = ('92062' OR '92064' OR               
                                      '92066' OR '92068')               
                                                                        
               MOVE SPACES                    TO WS-CODE-TEMP-BILL-AT   
               IF (WS-EXT-MESSAGE-ID = '92062'   AND                    
                   HOLD-MESSAGE-NO      = '92061')  OR                  
                  (WS-EXT-MESSAGE-ID = '92064'   AND                    
                   HOLD-MESSAGE-NO      = '92063')  OR                  
                  (WS-EXT-MESSAGE-ID = '92066'   AND                    
                   HOLD-MESSAGE-NO      = '92065')  OR                  
                  (WS-EXT-MESSAGE-ID = '92068'   AND                    
                   HOLD-MESSAGE-NO      = '92067')                      
                                                                        
      ** MOVE ITPA ADDRESS TO MAILING ADDRESS IF DIFFERENT FROM PREVIOUS05631000
      ** ITPA LETTER MAILING ADDRESS                                    05632000
                  IF WS-ITPA-ADDR-1 NOT EQUAL TO                        
                                     HOLD-MAILING-ADDRESS(2) OR         
                     WS-ITPA-ADDR-2 NOT EQUAL TO                        
                                     HOLD-MAILING-ADDRESS(3) OR         
                     WS-ITPA-ADDR-3 NOT EQUAL TO                        
                                     HOLD-MAILING-ADDRESS(4)            
                     MOVE WS-EXT-CUSTOMER-NO TO WS-EXT-ACCOUNT-NO       
                     MOVE SPACES TO WS-EXT-MAILING-ADDR(1)              
                                    WS-EXT-MAILING-ADDR(2)              
                     IF WS-UPDATE-DB-FL = 'Y'                           
                        PERFORM 8400-INSERT-CUST-COMM-ITPA              
                                                       THRU 8400-EXIT   
                     END-IF                                             
                                                                        
      ** MOVE CUST NAME TO LINE 1 OF MAILING ADDRESS AND ITPA ADDRESS   05780000
      ** TO REMAINING MAILING ADDRESS LINES                             05781000
                     MOVE HOLD-MAILING-ADDRESS(1) TO                    
                                            WS-EXT-MAILING-ADDR(1)      
                     MOVE WS-ITPA-ADDR-1 TO WS-EXT-MAILING-ADDR(2)      
                     MOVE WS-ITPA-ADDR-2 TO WS-EXT-MAILING-ADDR(3)      
                     MOVE WS-ITPA-ADDR-3 TO WS-EXT-MAILING-ADDR(4)      
                     PERFORM 5000-FORMAT-MAILING-ADDR THRU 5000-EXIT    
                     MOVE HOLD-COAPPLICANT-NAME TO                      
                                             WS-EXT-COAPPLICANT-NAME    
                     MOVE WS-HOLD-CUSTOMER-NAME TO WS-EXT-CUSTOMER-NAME 
                     MOVE WS-HOLD-ZIPCODE         TO WS-EXT-BARCODE-ZIP 
                                                                        
                     MOVE WS-EXT-MESSAGE-ID          TO  HOLD-MESSAGE-NO
                                                                        
                     IF WS-EXT-CUSTOMER-NAME = SPACES                   
                        MOVE  'T'               TO WS-CODE-TEMP-BILL-AT 
                     END-IF                                             
                                                                        
                     PERFORM 8000-WRITE-FCSKR150-FILE THRU 8000-EXIT    
                                                                        
                  END-IF                                                
               ELSE                                                     
                  MOVE  'T'                     TO WS-CODE-TEMP-BILL-AT 
                  PERFORM 8000-WRITE-FCSKR150-FILE THRU 8000-EXIT       
               END-IF                                                   
           ELSE                                                         
               PERFORM 2000-GET-NAMES-ADDRESSES THRU 2000-EXIT          
               MOVE WS-EXT-MESSAGE-ID           TO   HOLD-MESSAGE-NO    
               INITIALIZE HOLD-MAIL-ADDRESS                             
               MOVE WS-EXT-MAIL-ADDRESS         TO   HOLD-MAIL-ADDRESS  
               MOVE WS-EXT-COAPPLICANT-NAME     TO                      
                                                 HOLD-COAPPLICANT-NAME  
               PERFORM 5000-FORMAT-MAILING-ADDR THRU 5000-EXIT          
               PERFORM 8000-WRITE-FCSKR150-FILE THRU 8000-EXIT          
           END-IF.                                                      
                                                                        
      ** WRITE ALOC HOLD RECORD                                         06091000
           IF WS-EXT-MESSAGE-ID = (90701 OR 90799 OR 90706 OR 90702 OR  
A05382                             90704)                               
           AND WS-HOLD-SW = 'Y'                                         
              INITIALIZE                         WS-EXT-CORR-DATA       
              MOVE WS-HOLD-MESS-REC-SEQ     TO   WS-EXT-KEY-REC-SEQ     
              MOVE WS-HOLD-MESS-REC-ID      TO   WS-EXT-KEY-RECORD-ID   
              MOVE WS-HOLD-MESS             TO   WS-EXT-CORR-DATA       
              PERFORM 8100-WRITE-RECORD THRU 8100-EXIT                  
           END-IF.                                                      
                                                                        
           IF CSR-DATABASE AND (WS-EXT-MESSAGE-ID NOT EQUAL TO 90601)   
               PERFORM 2600-FORMAT-PAYMENT-AGENCIES     THRU 2600-EXIT  
               IF SCEG                                                  
                  PERFORM 2700-FORMAT-BUSINESS-OFFICES  THRU 2700-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
           IF TPGN                                                      
              PERFORM 2800-FORMAT-TPGN-CN THRU 2800-EXIT                
           END-IF.                                                      
                                                                        
           INITIALIZE EXTMCLFN                                          
                      EXTCOKEY.                                         
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 06360000
      ******************************************************************06370000
      * CALLS PROGRAM SCSCA184 TO GET NAMES AND ADDRESSES              *06380000
      ******************************************************************06390000
       2000-GET-NAMES-ADDRESSES.                                        
      *                                                                 06410000
           INITIALIZE                          WS-SCSCA184-PARMS        
                                               WS-CODE-TEMP-BILL-AT.    
                                                                        
           MOVE    WS-EXT-CUSTOMER-NO       TO   HOLD-CUSTOMER-NO       
                                                  LF-CUSTOMER-NO.       
                                                                        
      ** USE GUARANTOR ACCT NUMBER FOR GUARANTOR LETTERS                06471000
           IF WS-EXT-MESSAGE-ID = '90810' OR '90812' OR '90109' OR      
                                    '90306' OR '90307'                  
              MOVE WS-EXT-GUARNTR-ACCT-NO         TO WS-ACCOUNT-NO-AS   
           ELSE                                                         
              MOVE WS-EXT-ACCOUNT-NO              TO WS-ACCOUNT-NO-AS   
           END-IF.                                                      
                                                                        
           MOVE WS-EXT-CUSTOMER-NO            TO WS-CUSTOMER-NO-AS.     
           MOVE WS-CC-ADDRESS-ID              TO WS-TP-ADDRESS-ID.      
           MOVE WS-CC-NAME-ID                 TO WS-TP-NAME-ID.         
      ** FOR GUARANTOR NOTICES USE GUARANTOR ADDRESS ID AND FORMAT      06571000
           IF WS-EXT-MESSAGE-ID =  '90306' OR '90307' OR '90109'        
              MOVE WS-CC-ADDRESS-ID            TO WS-ADDRESS-ID-AS      
              MOVE WS-CC-ADDRESS-FORMAT        TO WS-ADDRESS-FORMAT-AS  
           ELSE                                                         
ACT135** USE SPECIAL REFUND ADDRESS FOR REFUND CHECK IF PRESENT         06590400
ACT135        IF WS-EXT-MESSAGE-ID = '90601' AND WS-RN-ADDRESS-ID > 0   
ACT135           MOVE WS-RN-ADDRESS-ID         TO WS-ADDRESS-ID-AS      
ACT135           MOVE WS-RN-ADDRESS-FORMAT     TO WS-ADDRESS-FORMAT-AS  
ACT135        ELSE                                                      
      ** USE OLD ACCT ADDRESS ID FOR FB BANK PAYMENT LETTER             06591000
ACT135           MOVE WS-ADDRESS-FORMAT        TO WS-ADDRESS-FORMAT-AS  
ACT135           IF WS-EXT-MESSAGE-ID = '90210'                         
ACT135             MOVE WS-EXT-NUM-VARIABLE(2)   TO WS-ADDRESS-ID-AS    
ACT135             MOVE WS-EXT-ALPHA-VARIABLE(2) TO WS-ADDRESS-FORMAT-AS
ACT135           ELSE                                                   
ACT135             MOVE WS-ADDRESS-ID            TO WS-ADDRESS-ID-AS    
ACT135           END-IF                                                 
ACT135        END-IF                                                    
ACT135     END-IF.                                                      
                                                                        
           IF WS-EXT-ACCOUNT-NO = '0000000000000'                       
              MOVE 'C'                         TO WS-ADDRESS-FLAG       
           ELSE                                                         
      *  THIRD PARTY LETTERS                                            06691000
             IF WS-EXT-MESSAGE-ID = ('90818' OR '90819' OR '90820'  OR  
                                     '90821' OR '90822' OR '90823'  OR  
                                     '90824' OR '90825') OR             
                WS-EXT-TYPE-CD = 'TP'                                   
                MOVE 'T'                         TO WS-ADDRESS-FLAG     
             ELSE                                                       
                MOVE 'A'                         TO WS-ADDRESS-FLAG     
             END-IF                                                     
           END-IF.                                                      
                                                                        
      *  ALOC AND ITPA LETTERS                                          06781000
           IF  WS-EXT-MESSAGE-ID = ('92061' OR '92062' OR '92063' OR    
                                      '92064' OR '90701' OR '90799' OR  
                                      '92065' OR '92066' OR '92067' OR  
                                      '92068' OR '90702' OR '90706' OR  
A05382                                '90704')                          
A04127         MOVE 'A'                      TO WS-ALOC-ITPA-PROCESS    
               MOVE WS-EXT-CUSTOMER-NO       TO WS-EXT-ACCOUNT-NO       
A04127     ELSE                                                         
A04127         MOVE ' '                      TO WS-ALOC-ITPA-PROCESS    
           END-IF.                                                      
                                                                        
           INITIALIZE                            WS-NAME-ADDR-TABLE.    
                                                                        
           DISPLAY 'CALLING SCSCA184 FROM SCSCA121'.                    
           PERFORM 5800-CALL-SCSCA184         THRU 5800-EXIT.           
                                                                        
           MOVE WS-NAME-ADDRESS-TABLE         TO WS-NAME-ADDR-TABLE.    
           MOVE WS-TP-ADDRESS                TO WS-THD-PRTY-DETAILS.    
           MOVE WS-PREMISE-ADDRESS           TO WS-PREMISE-ADDR.        
                                                                        
           IF WS-CUST-NAME GREATER THAN SPACES                          
              MOVE WS-CUST-NAME              TO WS-EXT-CUSTOMER-NAME    
                                                WS-HOLD-CUSTOMER-NAME   
           ELSE                                                         
              MOVE WS-ACCT-NAME              TO WS-EXT-CUSTOMER-NAME    
                                                WS-HOLD-CUSTOMER-NAME   
           END-IF.                                                      
                                                                        
           MOVE WS-COAPPL-NAME               TO                         
                                             WS-EXT-COAPPLICANT-NAME.   
                                                                        
      ** ZIPCODE FORMATTING                                             07091000
           IF WS-EXT-MESSAGE-ID NOT EQUAL  TO ('90822' AND '90823' AND  
                                                 '90824' AND '90825')   
              MOVE WS-BARCODE-ZIP(1:5)       TO                         
                                             WS-EXT-BARCODE-ZIP(1:5)    
              IF WS-BARCODE-ZIP(6:4) > ' '                              
                 MOVE WS-BARCODE-ZIP(6:4)    TO                         
                                             WS-EXT-BARCODE-ZIP(6:4)    
              ELSE                                                      
                 MOVE SPACES                 TO                         
                                             WS-EXT-BARCODE-ZIP(6:4)    
              END-IF                                                    
              IF WS-BARCODE-ZIP(10:2) > ' '                             
                 MOVE WS-BARCODE-ZIP(10:2)   TO                         
                                             WS-EXT-BARCODE-ZIP(10:2)   
              ELSE                                                      
                 MOVE SPACES                 TO                         
                                             WS-EXT-BARCODE-ZIP(10:2)   
              END-IF                                                    
              MOVE WS-EXT-BARCODE-ZIP       TO WS-HOLD-ZIPCODE          
           ELSE                                                         
      ** USE THIRD PARTY ZIPCODE FOR THIRD PARTY NOTICES                07301000
              MOVE WS-TP-BARCODE-ZIP(1:5)    TO                         
                                             WS-EXT-BARCODE-ZIP(1:5)    
              IF WS-TP-BARCODE-ZIP(6:4) > ' '                           
                 MOVE WS-TP-BARCODE-ZIP(6:4) TO                         
                                             WS-EXT-BARCODE-ZIP(6:4)    
              ELSE                                                      
                 MOVE SPACES                 TO                         
                                             WS-EXT-BARCODE-ZIP(6:4)    
              END-IF                                                    
              IF WS-TP-BARCODE-ZIP(10:2) > ' '                          
                 MOVE WS-TP-BARCODE-ZIP(10:2) TO                        
                                             WS-EXT-BARCODE-ZIP(10:2)   
              ELSE                                                      
                 MOVE SPACES                 TO                         
                                             WS-EXT-BARCODE-ZIP(10:2)   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE SPACES                       TO                         
                                             WS-HOLD-SERVICE-ADDRESS(1) 
                                             WS-HOLD-SERVICE-ADDRESS(2) 
                                             WS-HOLD-SERVICE-ADDRESS(3) 
           MOVE WS-PR-STREET                 TO                         
                                             WS-HOLD-SERVICE-ADDRESS(1).
           IF WS-PR-ADDR-OVERFLOW > SPACES                              
              MOVE WS-PR-ADDR-OVERFLOW       TO                         
                                             WS-HOLD-SERVICE-ADDRESS(2) 
              MOVE WS-PR-ADDR-CITY-STATE-ZIP TO                         
                                             WS-HOLD-SERVICE-ADDRESS(3) 
           ELSE                                                         
              MOVE WS-PR-ADDR-CITY-STATE-ZIP TO                         
                                             WS-HOLD-SERVICE-ADDRESS(2) 
           END-IF                                                       
           MOVE WS-TP-ADDR-STREET        TO WS-EXT-THRD-PTY-ADDR(1)     
           MOVE WS-TP-ADDRESS-OVERFLOW   TO WS-EXT-THRD-PTY-ADDR(2)     
           MOVE WS-TP-ADDR-CITY-STATE    TO WS-EXT-THRD-PTY-ADDR(3)     
           MOVE WS-TP-ADDR-ZIP-CODE      TO WS-EXT-THRD-PTY-ADDR(4)     
           MOVE WS-TP-ADDR-COUNTRY       TO WS-EXT-THRD-PTY-ADDR(5)     
                                                                        
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
                                         UNTIL WS-SUB > 6               
                   MOVE WS-NAME-ADDR-LINE(WS-SUB) TO                    
                                        WS-EXT-MAILING-ADDR(WS-SUB)     
           END-PERFORM.                                                 
                                                                        
      ** ADDRESS PROCESSING FOR GUARANTOR AND TRANSFER LETTERS          07751000
           IF WS-EXT-MESSAGE-ID = '90817' OR '90812' OR '90109' OR      
                                    '90306' OR '90307' or '90810' OR    
                                    '90210'                             
              INITIALIZE                        WS-SCSCA184-PARMS       
                                                WS-PREMISE-ADDR         
              IF  WS-EXT-ALPHA-VARIABLE(1) GREATER THAN SPACES AND      
                  (WS-EXT-MESSAGE-ID = '90817' OR                       
                  WS-EXT-MESSAGE-ID = '90210')                          
                  MOVE WS-EXT-ALPHA-VARIABLE(1) TO WS-ACCOUNT-NO-TEMP   
                  MOVE ACCOUNT-NO-TEMP          TO WS-ACCOUNT-NO-AS     
              ELSE                                                      
                  MOVE WS-EXT-ACCOUNT-NO        TO WS-ACCOUNT-NO-AS     
              END-IF                                                    
              MOVE 'A'                          TO WS-ADDRESS-FLAG      
                                                                        
              DISPLAY 'CALLING SCSCA184 - II FROM SCSCA121'             
              PERFORM 5800-CALL-SCSCA184     THRU 5800-EXIT             
                                                                        
              IF WS-EXT-MESSAGE-ID NOT = '90810'                        
                 IF WS-EXT-MESSAGE-ID =  '90210'                        
                    MOVE WS-PREMISE-ADDRESS        TO WS-PREMISE-ADDR   
                    MOVE WS-PR-STREET              TO                   
                                             WS-EXT-ALPHA-VARIABLE(6)   
                    MOVE WS-EXT-ACCOUNT-NO  TO WS-EXT-ALPHA-VARIABLE(2) 
                 ELSE                                                   
                    MOVE WS-PREMISE-ADDRESS        TO WS-PREMISE-ADDR   
                    MOVE WS-PR-STREET              TO                   
                                             WS-HOLD-SERVICE-ADDRESS(1) 
                    IF WS-PR-ADDR-OVERFLOW > SPACES                     
                       MOVE WS-PR-ADDR-OVERFLOW    TO                   
                                             WS-HOLD-SERVICE-ADDRESS(2) 
                       MOVE WS-PR-ADDR-CITY-STATE-ZIP TO                
                                             WS-HOLD-SERVICE-ADDRESS(3) 
                    ELSE                                                
                       MOVE WS-PR-ADDR-CITY-STATE-ZIP TO                
                                             WS-HOLD-SERVICE-ADDRESS(2) 
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 IF WS-CUST-NAME GREATER THAN SPACES                    
                    MOVE WS-CUST-NAME        TO                         
                                             WS-EXT-COAPPLICANT-NAME    
                 ELSE                                                   
                    MOVE WS-ACCT-NAME        TO                         
                                             WS-EXT-COAPPLICANT-NAME    
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-EXT-MESSAGE-ID = ('90812' OR '90109' OR '90306' OR  
                                        '90307')                        
                 IF WS-CUST-NAME GREATER THAN SPACES                    
                    MOVE WS-CUST-NAME        TO WS-EXT-CUSTOMER-NAME    
                 ELSE                                                   
                    MOVE WS-ACCT-NAME        TO WS-EXT-CUSTOMER-NAME    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                 08330000
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 08360000
      ************************************************************      08370000
      *  THIS ROUTINE CALCULATES A CHECK DIGIT FOR THE 13 BYTE   *      08380000
      *  ACCOUNT NUMBER;  IT WILL PRINT ON THE SCAN LINE.        *      08390000
      ************************************************************      08400000
      *                                                                 08410000
       2110-CALCULATE-CHECK-DIGIT.                                      
                                                                        
           MOVE WS-EXT-ACCOUNT-NO TO WS-EDIT-ACCT1.                     
           MOVE 0 TO WS-EDIT-ACCT2.                                     
           MOVE WS-EDIT-ACC TO WS-EDIT-CHECK-ACCT.                      
           MOVE +0 TO WS-CHECKED-SUM.                                   
           MULTIPLY +2 BY WS-ACC2 GIVING WS-CHECKED-PROD.               
           ADD WS-CHECKED-PROD TO WS-CHECKED-SUM.                       
           MULTIPLY +2 BY WS-ACC4 GIVING WS-CHECKED-PROD.               
           ADD WS-CHECKED-PROD TO WS-CHECKED-SUM.                       
           MULTIPLY +2 BY WS-ACC6 GIVING WS-CHECKED-PROD.               
           ADD WS-CHECKED-PROD TO WS-CHECKED-SUM.                       
           MULTIPLY +2 BY WS-ACC8 GIVING WS-CHECKED-PROD.               
           ADD WS-CHECKED-PROD TO WS-CHECKED-SUM.                       
           MULTIPLY +2 BY WS-ACC10 GIVING WS-CHECKED-PROD.              
           ADD WS-CHECKED-PROD TO WS-CHECKED-SUM.                       
           MULTIPLY +2 BY WS-ACC12 GIVING WS-CHECKED-PROD.              
           ADD WS-CHECKED-PROD TO WS-CHECKED-SUM.                       
           MULTIPLY +2 BY WS-ACC14 GIVING WS-CHECKED-PROD.              
           ADD WS-CHECKED-PROD TO WS-CHECKED-SUM.                       
           ADD WS-ACC1 WS-ACC3 WS-ACC5 WS-ACC7                          
               WS-ACC9 WS-ACC11 WS-ACC13 TO WS-CHECKED-SUM.             
           MOVE WS-CHECKED-SUM TO WS-CHECKED-EDIT.                      
           SUBTRACT WS-LAST-DIGIT FROM 10 GIVING WS-CHECK-DIGIT.        
           MOVE WS-CHECK-DIGIT TO WS-EXT-CHECK-DIGIT.                   
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08930000
      * SETS THE OMR MARKS FOR THE INSERTING PROCESS.                 * 08940000
      ***************************************************************** 08950000
       2500-FORMAT-OMR-MARKS.                                           
      *                                                                 08970000
           MOVE '1'                          TO WS-INSERT-MARK (1).     
           MOVE '0'                          TO WS-INSERT-MARK (2).     
           MOVE WS-INSERT-MARK (1)           TO WS-EXT-OMR-MARK-1.      
           MOVE WS-INSERT-MARK (2)           TO WS-EXT-OMR-MARK-2.      
           MOVE WS-INSERT-MARK (3)           TO WS-EXT-OMR-MARK-3.      
           MOVE WS-INSERT-MARK (4)           TO WS-EXT-OMR-MARK-4.      
           MOVE WS-INSERT-MARK (5)           TO WS-EXT-OMR-MARK-5.      
           MOVE WS-INSERT-MARK (6)           TO WS-EXT-OMR-MARK-6.      
           MOVE WS-INSERT-MARK (7)           TO WS-EXT-OMR-MARK-7.      
           MOVE WS-INSERT-MARK (8)           TO WS-EXT-OMR-MARK-8.      
           MOVE WS-INSERT-MARK (9)           TO WS-EXT-OMR-MARK-9.      
           MOVE WS-INSERT-MARK (10)          TO WS-EXT-OMR-MARK-10.     
           MOVE WS-INSERT-MARK (11)          TO WS-EXT-OMR-MARK-11.     
           MOVE WS-INSERT-MARK (12)          TO WS-EXT-OMR-MARK-12.     
           MOVE WS-INSERT-MARK (13)          TO WS-EXT-OMR-MARK-13.     
      *                                                                 09121000
           EVALUATE WS-EXT-MESSAGE-ID                                   
           WHEN 10301                                                   
                MOVE '0'                     TO WS-EXT-OMR-MARK-4       
                                                WS-EXT-OMR-MARK-5       
                                                WS-EXT-OMR-MARK-6       
                IF WS-EXT-REG-GROUP-CD = '100'                          
                   MOVE '1'                  TO WS-EXT-OMR-MARK-5       
                ELSE                                                    
                   IF WS-EXT-REG-GROUP-CD = '200'                       
                      MOVE '1'               TO WS-EXT-OMR-MARK-6       
                   ELSE                                                 
                      MOVE '1'               TO WS-EXT-OMR-MARK-4       
                   END-IF                                               
                END-IF                                                  
A04897     WHEN 75005                                                   
A04897          MOVE '1'                     TO WS-EXT-OMR-MARK-3       
A04897     WHEN 75008                                                   
A04897          MOVE '1'                     TO WS-EXT-OMR-MARK-3       
           END-EVALUATE.                                                
      *                                                                 09130200
      *                                                                 09131000
       2500-EXIT.                                                       
            EXIT.                                                       
      *                                                                 09160000
      ***********************************************************       09170000
      *    BUILD THE PAYMENT AGENCY RECORD                      *       09180000
      ***********************************************************       09190000
       2600-FORMAT-PAYMENT-AGENCIES.                                    
                                                                        
           PERFORM 5500-CALL-SCSCA150      THRU 5500-EXIT.              
           PERFORM VARYING SUB1 FROM 1 BY 1  UNTIL                      
               SUB1 > 50                OR                              
               WS-PAY-AGNCY-LINE(SUB1) <= SPACES                        
               INITIALIZE                           EXTMCLFN            
               MOVE WS-PAY-AGENCY-ID         TO                         
                                         WS-EXT-KEY-RECORD-ID           
               MOVE WS-PAY-AGENCY-REC        TO                         
                                         WS-EXT-KEY-REC-SEQ             
               MOVE SPACES                   TO                         
                                         WS-EXT-PAY-AGNCY-DETAIL        
               MOVE WS-PAY-AGNCY-LINE(SUB1)  TO                         
                                         WS-EXT-PAY-AGNCY-DETAIL        
               MOVE WS-EXT-PAYMENT-AGENCY    TO WS-EXT-CORR-DATA        
                                                                        
               PERFORM 8100-WRITE-RECORD THRU 8100-EXIT                 
                                                                        
           END-PERFORM.                                                 
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09430000
      ***********************************************************       09440000
      *    BUILD THE BUSINESS OFFICE RECORD                     *       09450000
      ***********************************************************       09460000
       2700-FORMAT-BUSINESS-OFFICES.                                    
      *                                                                 09480000
           PERFORM VARYING SUB1 FROM 1 BY 1 UNTIL                       
               SUB1 > 50                   OR                           
               WS-BUS-OFFICE-LINE(SUB1) <= SPACES                       
               INITIALIZE                           EXTMCLFN            
               MOVE WS-BUS-OFFICE-ID         TO                         
                                         WS-EXT-KEY-RECORD-ID           
               MOVE WS-BUS-OFFICE-REC        TO                         
                                         WS-EXT-KEY-REC-SEQ             
               MOVE SPACES                   TO                         
                                         WS-EXT-BUS-OFFICE-DETAIL       
               MOVE WS-BUS-OFFICE-LINE(SUB1) TO                         
                                         WS-EXT-BUS-OFFICE-DETAIL       
               MOVE WS-EXT-BUS-OFFICE        TO WS-EXT-CORR-DATA        
                                                                        
               PERFORM 8100-WRITE-RECORD    THRU 8100-EXIT              
                                                                        
           END-PERFORM.                                                 
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09690000
      *************************************************************     09700000
      * FORMAT RECORDS FOR SENDING WITH THIRD PARTY AND GUARANTOR *     09710000
      *************************************************************     09720000
       2800-FORMAT-TPGN-CN.                                             
      *                                                                 09740000
      * NEED TO USE THE FILE SORT CODE OF THE TPGN LETTER FOR THE       09750000
      * DUPLICATE NOTICE INSTEAD OF THE ONE IN THE HOLD NOTICE DATA.    09760000
      * AFTER HOLD DATA IS MOVED OVERWRITE FILE SORT CODE               09760100
           MOVE WS-EXT-KEY-FILE-SORT      TO WS-HOLD-FILE-SORT.         
                                                                        
      * WRITE HEADER RECORD                                             09770000
      * USE UNIQUE ID OF THE TPGN LETTER INSTEAD OF NOTICE UNIQUE ID    09771000
P00599     MOVE WS-EXT-UNIQUE-ID          TO WS-HOLD-UNIQUE-ID.         
           MOVE HOLD-EXTHDR               TO EXTCOKEY.                  
           MOVE WS-HOLD-FILE-SORT         TO WS-EXT-KEY-FILE-SORT.      
                                                                        
      * IF THIS IS A GUARNTR ACCOUNT THE KEY SHOULD HAVE GUARNTR ACCT   09800000
      * AND GUARNTR CUST SO THE LETTER WILL BE IMAGED TO GUARNTR ACCOUNT09801000
           IF GUARNTR                                                   
              MOVE WS-EXT-GUARNTR-ACCT-NO TO WS-EXT-KEY-ACCOUNT-NO      
              MOVE WS-EXT-GUARNTR-CUST-NO TO WS-EXT-KEY-CUSTOMER-NO     
           END-IF.                                                      
                                                                        
      * GET VALUES FOR SCSCA150 CALL                                    09890000
           MOVE HOLD-ACCOUNT-NO           TO WS-CA150-ACCOUNT-NO.       
           MOVE WS-EXT-COMPANY-NO       TO WS-CA150-COMPANY-NO          
                                                WS-HOLD-COMPANY-NO.     
           MOVE WS-HOLD-PR-ZIP-CODE       TO WS-CA150-SERVICE-ZIP.      
           MOVE WS-EXT-LOCAL-OFFICE     TO WS-CA150-LOCAL-OFFICE.       
                                                                        
           PERFORM 8100-WRITE-RECORD     THRU 8100-EXIT.                
                                                                        
      * WRITE NOTICE RECORD                                             09980000
           IF HOLD-EXTNOTC > SPACES                                     
              MOVE HOLD-EXTNOTC              TO EXTCOKEY                
              MOVE WS-HOLD-FILE-SORT         TO WS-EXT-KEY-FILE-SORT    
              IF GUARNTR                                                
                 MOVE WS-EXT-GUARNTR-ACCT-NO TO WS-EXT-KEY-ACCOUNT-NO   
                 MOVE WS-EXT-GUARNTR-CUST-NO TO WS-EXT-KEY-CUSTOMER-NO  
              END-IF                                                    
              PERFORM 8100-WRITE-RECORD     THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
      * WRITE MAILING DETAIL RECORD                                     10080000
           IF HOLD-EXTMAIL > SPACES                                     
              MOVE HOLD-EXTMAIL              TO EXTCOKEY                
              MOVE WS-HOLD-FILE-SORT         TO WS-EXT-KEY-FILE-SORT    
              IF GUARNTR                                                
                 MOVE WS-EXT-GUARNTR-ACCT-NO TO WS-EXT-KEY-ACCOUNT-NO   
                 MOVE WS-EXT-GUARNTR-CUST-NO TO WS-EXT-KEY-CUSTOMER-NO  
              END-IF                                                    
              PERFORM 8100-WRITE-RECORD     THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
      * WRITE ALPHA/NUM VARIABLE RECORD                                 10180000
           IF HOLD-EXTVAR  > SPACES                                     
              MOVE HOLD-EXTVAR               TO EXTCOKEY                
              MOVE WS-HOLD-FILE-SORT         TO WS-EXT-KEY-FILE-SORT    
              IF GUARNTR                                                
                 MOVE WS-EXT-GUARNTR-ACCT-NO TO WS-EXT-KEY-ACCOUNT-NO   
                 MOVE WS-EXT-GUARNTR-CUST-NO TO WS-EXT-KEY-CUSTOMER-NO  
              END-IF                                                    
              PERFORM 8100-WRITE-RECORD     THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
      * WRITE ADDITIONAL INFO RECORD                                    10280000
           IF HOLD-EXTAINFO > SPACES                                    
              MOVE '1'                       TO WS-HOLD-OMR-MARK-2      
              MOVE 2                         TO WS-HOLD-TOTAL-SHEET     
              MOVE HOLD-EXTAINFO             TO EXTCOKEY                
              MOVE WS-HOLD-FILE-SORT         TO WS-EXT-KEY-FILE-SORT    
              IF GUARNTR                                                
                 MOVE WS-EXT-GUARNTR-ACCT-NO TO WS-EXT-KEY-ACCOUNT-NO   
                 MOVE WS-EXT-GUARNTR-CUST-NO TO WS-EXT-KEY-CUSTOMER-NO  
              END-IF                                                    
              PERFORM 8100-WRITE-RECORD     THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 2600-FORMAT-PAYMENT-AGENCIES THRU 2600-EXIT.         
           IF SCEG                                                      
              PERFORM 2700-FORMAT-BUSINESS-OFFICES  THRU 2700-EXIT      
           END-IF.                                                      
      *                                                                 10420000
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10450000
      ******************************************************************10460000
      * 3200-PROCESS-MESSAGES. POPULATES ADV LTR OF CREDIT REASON MSGS.*10470000
      ******************************************************************10480000
       3200-PROCESS-MESSAGES.                                           
      *                                                                 10500000
            MOVE ZERO                        TO WS-NOT-FOUND-CNTR.      
            MOVE 1                           TO SUB2.                   
                                                                        
            IF WS-EXT-MESSAGE-ID EQUAL ('90701' OR '90799' OR '90702'   
                                        OR '90706' OR '90704')          
                IF WS-EXT-MESSAGE-ID EQUAL ('90799')                    
                   MOVE '30'                 TO COMPANY-NO              
                ELSE                                                    
                   MOVE WS-EXT-COMPANY-NO    TO COMPANY-NO              
                END-IF                                                  
                MOVE WS-EXT-ALPHA-VARIABLE(1)(2:1)                      
                                             TO CB-CODE-TYPE-CD         
                MOVE WS-EXT-ALPHA-VARIABLE(2)(1:5)                      
                                             TO CB-RETURN-CD            
A05198          MOVE WS-EXT-ALPHA-VARIABLE(6)(1:1)                      
A05198                                       TO SCORE-MODEL-CD          
                MOVE SPACES                  TO WS-HOLD-MESS-MSG1       
                MOVE SPACES TO PRINT-MESSAGE-TX,                        
                               PRINT-FL                                 
                IF CB-RETURN-CD GREATER THAN SPACES AND                 
                   CB-RETURN-CD NOT EQUAL TO ZEROES                     
                    PERFORM 7300-GET-MESSAGE THRU 7300-EXIT             
                END-IF                                                  
                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                AND PRINT-FL EQUAL WS-Y                                 
                    MOVE PRINT-MESSAGE-TX(3:255)                        
                                             TO WS-HOLD-MESS-MSG1       
                END-IF                                                  
                                                                        
                MOVE WS-EXT-ALPHA-VARIABLE(3)(1:5)                      
                                             TO CB-RETURN-CD            
                MOVE SPACES                  TO WS-HOLD-MESS-MSG2       
                MOVE SPACES TO PRINT-MESSAGE-TX,                        
                               PRINT-FL                                 
                IF CB-RETURN-CD GREATER THAN SPACES AND                 
                   CB-RETURN-CD NOT EQUAL TO ZEROES                     
                    PERFORM 7300-GET-MESSAGE THRU 7300-EXIT             
                END-IF                                                  
                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                AND PRINT-FL EQUAL WS-Y                                 
                    MOVE PRINT-MESSAGE-TX(3:255)                        
                                             TO WS-HOLD-MESS-MSG2       
                END-IF                                                  
                                                                        
                MOVE WS-EXT-ALPHA-VARIABLE(4)(1:5)                      
                                             TO CB-RETURN-CD            
                MOVE SPACES                  TO WS-HOLD-MESS-MSG3       
                MOVE SPACES TO PRINT-MESSAGE-TX,                        
                               PRINT-FL                                 
                IF CB-RETURN-CD GREATER THAN SPACES AND                 
                   CB-RETURN-CD NOT EQUAL TO ZEROES                     
                    PERFORM 7300-GET-MESSAGE THRU 7300-EXIT             
                END-IF                                                  
                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                AND PRINT-FL EQUAL WS-Y                                 
                    MOVE PRINT-MESSAGE-TX(3:255)                        
                                             TO WS-HOLD-MESS-MSG3       
                END-IF                                                  
                                                                        
                MOVE WS-EXT-ALPHA-VARIABLE(5)(1:5)                      
                                             TO CB-RETURN-CD            
                MOVE SPACES                  TO WS-HOLD-MESS-MSG4       
                MOVE SPACES TO PRINT-MESSAGE-TX,                        
                               PRINT-FL                                 
                IF CB-RETURN-CD GREATER THAN SPACES AND                 
                   CB-RETURN-CD NOT EQUAL TO ZEROES                     
                    PERFORM 7300-GET-MESSAGE THRU 7300-EXIT             
                END-IF                                                  
                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                AND PRINT-FL EQUAL WS-Y                                 
                    MOVE PRINT-MESSAGE-TX(3:255)                        
                                             TO WS-HOLD-MESS-MSG4       
                END-IF                                                  
                                                                        
                MOVE SPACES                  TO WS-HOLD-MESS-MSG5,      
                                                CB-RETURN-CD            
                MOVE WS-EXT-ALPHA-VARIABLE(9)(1:1)                      
                                             TO CB-RETURN-CD            
                MOVE SPACES TO PRINT-MESSAGE-TX,                        
                               PRINT-FL                                 
                IF CB-RETURN-CD GREATER THAN SPACES AND                 
                   CB-RETURN-CD NOT EQUAL TO ZEROES                     
                    PERFORM 7300-GET-MESSAGE THRU 7300-EXIT             
                END-IF                                                  
                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
                AND PRINT-FL EQUAL WS-Y                                 
                    MOVE PRINT-MESSAGE-TX(3:255)                        
                                             TO WS-HOLD-MESS-MSG5       
                END-IF                                                  
            END-IF.                                                     
            MOVE WS-EXT-COMPANY-NO          TO COMPANY-NO.              
      **************************************************************    11400000
      **  IF ANY SELECT HAS FAILED, WRITE A WORK QUEUE ON THE     **    11410000
      **  CUSTOMER NUMBER.                                        **    11420000
      **************************************************************    11430000
            IF WS-NOT-FOUND-CNTR > 0                                    
                PERFORM 7400-WRITE-ADV-LTR-WQ THRU 7400-EXIT            
            ELSE                                                        
                MOVE WS-ALOC-DTL-ID       TO WS-HOLD-MESS-REC-ID        
                MOVE WS-ALOC-DTL-REC      TO WS-HOLD-MESS-REC-SEQ       
                MOVE 'Y'                  TO WS-HOLD-SW                 
            END-IF.                                                     
      *                                                                 11590000
       3200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11620000
      ******************************************************************11630000
      * FORMATS THE MAILING ADDRESS MOVING THE SPACES TO BACK          *11640000
      ******************************************************************11650000
       5000-FORMAT-MAILING-ADDR.                                        
      *                                                                 11670000
           PERFORM VARYING WS-SUB FROM 1 BY 1 UNTIL WS-SUB > 6          
             IF WS-EXT-MAILING-ADDR(WS-SUB) EQUAL TO SPACES             
                COMPUTE WS-SUB1 = WS-SUB + 1                            
                PERFORM VARYING WS-SUB1 FROM WS-SUB1 BY 1               
                                        UNTIL WS-SUB1 > 6               
                   IF WS-EXT-MAILING-ADDR(WS-SUB1) NOT                  
                                      EQUAL TO SPACES                   
                        MOVE WS-EXT-MAILING-ADDR(WS-SUB1) TO            
                             WS-EXT-MAILING-ADDR(WS-SUB)                
                        MOVE SPACES                           TO        
                                        WS-EXT-MAILING-ADDR(WS-SUB1)    
                        ADD  +1              TO WS-SUB                  
                   END-IF                                               
                END-PERFORM                                             
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 11840000
       5000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 11870000
      ***************************************************************** 11880000
      * FORMATS THE ALPHA VARIABLES AS NEEDED IN NOTICES              * 11890000
      ****************************************************************  11900000
       5090-FORMAT-ALPHA.                                               
      *                                                                 11930000
           EVALUATE WS-EXT-MESSAGE-ID                                   
               WHEN 40003                                               
      *            MOVE THE CORRECT SERVICE TYPE TO ALPHA-VAR-1         11951000
                    IF WS-EXT-ALPHA-VARIABLE(1) = 'E' AND               
                       WS-EXT-ALPHA-VARIABLE(3) = 'G'                   
                       MOVE 'C' TO WS-EXT-ALPHA-VARIABLE(1)             
                    ELSE                                                
                       IF WS-EXT-ALPHA-VARIABLE(3) = 'G'                
                          MOVE WS-EXT-ALPHA-VARIABLE(3) TO              
                               WS-EXT-ALPHA-VARIABLE(1)                 
                       END-IF                                           
                    END-IF                                              
               WHEN 90817                                               
                    MOVE WS-HOLD-ACCT-NBR    TO                         
                                              WS-TMP-ACCOUNT-NBR        
                      STRING                  WS-TMP-ACCOUNT-NBR(1:1)   
                                              '-'                       
                                              WS-TMP-ACCOUNT-NBR(2:4)   
                                              '-'                       
                                              WS-TMP-ACCOUNT-NBR(6:4)   
                                              '-'                       
                                              WS-TMP-ACCOUNT-NBR(10:4)  
                                              DELIMITED BY SIZE INTO    
                                              WS-EXT-ALPHA-VARIABLE(1)  
               WHEN 90818                                               
               WHEN 90819                                               
               WHEN 90820                                               
               WHEN 90821                                               
               WHEN 90822                                               
               WHEN 90823                                               
               WHEN 90824                                               
               WHEN 90825                                               
                    MOVE WS-TP-NAME                  TO                 
                                                WS-EXT-ALPHA-VARIABLE(1)
                    IF WS-EXT-ALPHA-VARIABLE(4) > SPACES                
                      MOVE WS-EXT-ALPHA-VARIABLE(4)  TO WS-TMP-PHONE    
                      MOVE SPACES                    TO                 
                                               WS-EXT-ALPHA-VARIABLE(4) 
                      STRING                   '('                      
                                               WS-TMP-PHONE(1:3)        
                                               ')'                      
                                               WS-TMP-PHONE(4:3)        
                                               '-'                      
                                               WS-TMP-PHONE(7:4)        
                                               DELIMITED BY SIZE INTO   
                                               WS-EXT-ALPHA-VARIABLE(4) 
                   END-IF                                               
                                                                        
                   IF WS-EXT-ALPHA-VARIABLE(5) > SPACES                 
                      MOVE WS-EXT-ALPHA-VARIABLE(5)  TO WS-TMP-PHONE    
                      MOVE SPACES                    TO                 
                                               WS-EXT-ALPHA-VARIABLE(5) 
                      STRING                   '('                      
                                               WS-TMP-PHONE(1:3)        
                                               ')'                      
                                               WS-TMP-PHONE(4:3)        
                                               '-'                      
                                               WS-TMP-PHONE(7:4)        
                                               DELIMITED BY SIZE INTO   
                                               WS-EXT-ALPHA-VARIABLE(5) 
                   END-IF                                               
               WHEN 90203                                               
                    MOVE WS-EXT-ALPHA-VARIABLE(2) TO WS-HOLD-ALPHA-VAR  
                    PERFORM 5095-REFORMAT-ALPHA-VAR-DATE THRU 5095-EXIT 
                    MOVE WS-DATE-8          TO WS-EXT-ALPHA-VARIABLE(2) 
                                               WS-HOLD-ALPHA-VARIABLE-2 
                                                                        
                    IF WS-EXT-ALPHA-VARIABLE(4) GREATER THAN SPACES     
                       MOVE WS-EXT-ALPHA-VARIABLE(4) TO                 
                                                     WS-HOLD-ALPHA-VAR  
                       PERFORM 5095-REFORMAT-ALPHA-VAR-DATE THRU        
                                                     5095-EXIT          
                       MOVE WS-DATE-8        TO WS-EXT-ALPHA-VARIABLE(4)
                                                WS-HOLD-ALPHA-VARIABLE-4
                    ELSE                                                
                       MOVE WS-EXT-ALPHA-VARIABLE(4) TO                 
                                                WS-HOLD-ALPHA-VARIABLE-4
                    END-IF                                              
               WHEN 90601                                               
                    MOVE WS-SIGNATURE        TO WS-EXT-ALPHA-VARIABLE(2)
                    MOVE SPACES              TO WS-EXT-ALPHA-VARIABLE(3)
                    MOVE SPACES              TO WS-EXT-ALPHA-VARIABLE(4)
                    MOVE SPACES              TO WS-EXT-ALPHA-VARIABLE(5)
               WHEN 90810                                               
                    IF WS-EXT-ALPHA-VARIABLE(3) > SPACES                
                      MOVE WS-EXT-ALPHA-VARIABLE(3)  TO WS-TMP-PHONE    
                      MOVE SPACES                    TO                 
                                               WS-EXT-ALPHA-VARIABLE(3) 
                      STRING                   '('                      
                                               WS-TMP-PHONE(1:3)        
                                               ')'                      
                                               WS-TMP-PHONE(4:3)        
                                               '-'                      
                                               WS-TMP-PHONE(7:4)        
                                               DELIMITED BY SIZE INTO   
                                               WS-EXT-ALPHA-VARIABLE(3) 
                   END-IF                                               
                    IF WS-EXT-ALPHA-VARIABLE(4) > SPACES                
                      MOVE WS-EXT-ALPHA-VARIABLE(4)  TO WS-TMP-PHONE    
                      MOVE SPACES                    TO                 
                                               WS-EXT-ALPHA-VARIABLE(4) 
                      STRING                   '('                      
                                               WS-TMP-PHONE(1:3)        
                                               ')'                      
                                               WS-TMP-PHONE(4:3)        
                                               '-'                      
                                               WS-TMP-PHONE(7:4)        
                                               DELIMITED BY SIZE INTO   
                                               WS-EXT-ALPHA-VARIABLE(4) 
                   END-IF                                               
               WHEN 90109                                               
               WHEN 90306                                               
                    MOVE WS-EXT-GUARNTR-ACCT-NO TO WS-EXT-KEY-ACCOUNT-NO
                    MOVE WS-EXT-GUARNTR-CUST-NO TO                      
                                             WS-EXT-KEY-CUSTOMER-NO     
               WHEN OTHER                                               
                    IF TPGN AND HOLD-MESSAGE-NO EQUAL 90203             
                       MOVE WS-HOLD-ALPHA-VARIABLE-1 TO                 
                                               WS-EXT-ALPHA-VARIABLE(1) 
                       MOVE WS-HOLD-ALPHA-VARIABLE-2 TO                 
                                               WS-EXT-ALPHA-VARIABLE(2) 
                       MOVE WS-HOLD-ALPHA-VARIABLE-4 TO                 
                                               WS-EXT-ALPHA-VARIABLE(4) 
                    ELSE                                                
                      IF WS-EXT-MESSAGE-ID = ('90701' OR '90799' OR     
                                              '90702' OR '90706' OR     
A05382                                        '90704')                  
                         MOVE WS-EXT-ALPHA-VARIABLE(1)(1:1) TO          
                                                        WS-PARAGRAPH-CD 
                         MOVE WS-PARAGRAPH-CD  TO                       
                                               WS-EXT-ALPHA-VARIABLE(1) 
                         MOVE WS-EXT-ALPHA-VARIABLE(8)                  
                                               TO WS-HOLD-ALPHA-VAR     
                         PERFORM 5095-REFORMAT-ALPHA-VAR-DATE           
                                               THRU 5095-EXIT           
                         MOVE WS-DATE-8                                 
                                         TO WS-EXT-ALPHA-VARIABLE(8)    
                      END-IF                                            
                    END-IF                                              
           END-EVALUATE.                                                
                                                                        
           MOVE SPACES                    TO WS-EMB-INPUT.              
           MOVE SPACES                    TO WS-CMP-TABLE.              
           STRING                            WS-EXT-ALPHA-VARIABLE(1)   
                                             DELIMITED BY SIZE INTO     
                                             WS-EMB-INPUT               
           INSPECT                           WS-EMB-INPUT               
           REPLACING ALL LOW-VALUES BY SPACES                           
           MOVE 50                        TO WS-EMB-LENG                
                                                                        
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                             THRU 6011-EXIT.            
           MOVE SPACES                    TO WS-EXT-ALPHA-VARIABLE(1).  
           MOVE WS-CMP-TABLE              TO WS-EXT-ALPHA-VARIABLE(1).  
                                                                        
           MOVE SPACES                    TO WS-EMB-INPUT.              
           MOVE SPACES                    TO WS-CMP-TABLE.              
           STRING                            WS-EXT-ALPHA-VARIABLE(2)   
                                             DELIMITED BY SIZE INTO     
                                             WS-EMB-INPUT               
           INSPECT                           WS-EMB-INPUT               
           REPLACING ALL LOW-VALUES BY SPACES                           
           MOVE 50                        TO WS-EMB-LENG                
                                                                        
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                             THRU 6011-EXIT.            
           MOVE SPACES                    TO WS-EXT-ALPHA-VARIABLE(2).  
           MOVE WS-CMP-TABLE              TO WS-EXT-ALPHA-VARIABLE(2).  
                                                                        
           MOVE SPACES                    TO WS-EMB-INPUT.              
           MOVE SPACES                    TO WS-CMP-TABLE.              
           STRING                            WS-EXT-ALPHA-VARIABLE(3)   
                                             DELIMITED BY SIZE INTO     
                                             WS-EMB-INPUT               
           INSPECT                           WS-EMB-INPUT               
           REPLACING ALL LOW-VALUES BY SPACES                           
           MOVE 50                        TO WS-EMB-LENG                
                                                                        
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                             THRU 6011-EXIT.            
           MOVE SPACES                    TO WS-EXT-ALPHA-VARIABLE(3).  
           MOVE WS-CMP-TABLE              TO WS-EXT-ALPHA-VARIABLE(3).  
                                                                        
           MOVE SPACES                    TO WS-EMB-INPUT.              
           MOVE SPACES                    TO WS-CMP-TABLE.              
           STRING                            WS-EXT-ALPHA-VARIABLE(4)   
                                             DELIMITED BY SIZE INTO     
                                             WS-EMB-INPUT               
           INSPECT                           WS-EMB-INPUT               
           REPLACING ALL LOW-VALUES BY SPACES                           
           MOVE 50                        TO WS-EMB-LENG                
                                                                        
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                             THRU 6011-EXIT.            
           MOVE SPACES                    TO WS-EXT-ALPHA-VARIABLE(4).  
           MOVE WS-CMP-TABLE              TO WS-EXT-ALPHA-VARIABLE(4).  
                                                                        
           MOVE SPACES                    TO WS-EMB-INPUT.              
           MOVE SPACES                    TO WS-CMP-TABLE.              
           STRING                            WS-EXT-ALPHA-VARIABLE(5)   
                                             DELIMITED BY SIZE INTO     
                                             WS-EMB-INPUT               
           INSPECT                           WS-EMB-INPUT               
           REPLACING ALL LOW-VALUES BY SPACES                           
           MOVE 50                        TO WS-EMB-LENG                
                                                                        
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                             THRU 6011-EXIT.            
           MOVE SPACES                    TO WS-EXT-ALPHA-VARIABLE(5).  
           MOVE WS-CMP-TABLE              TO WS-EXT-ALPHA-VARIABLE(5).  
                                                                        
      *                                                                 14290000
       5090-EXIT.                                                       
            EXIT.                                                       
      *                                                                 14320000
      ******************************************************************14330000
      * THIS REFORMATS DB2 DATES FROM ALPHA VARS INTO MM/DD/YY FORMAT  *14340000
      ******************************************************************14350000
       5095-REFORMAT-ALPHA-VAR-DATE.                                    
      *                                                                 14370000
            IF WS-HOLD-ALPHA-VAR (1:4) NUMERIC AND                      
               WS-HOLD-ALPHA-VAR (6:2) NUMERIC AND                      
               WS-HOLD-ALPHA-VAR (9:2) NUMERIC                          
               MOVE WS-HOLD-ALPHA-VAR (6:2) TO WS-DATE-MM               
               MOVE WS-HOLD-ALPHA-VAR (9:2) TO WS-DATE-DD               
               MOVE WS-HOLD-ALPHA-VAR (3:2) TO WS-DATE-YY               
            ELSE                                                        
            IF WS-HOLD-ALPHA-VAR (3:1) = '/' AND                        
               WS-HOLD-ALPHA-VAR (6:1) = '/' AND                        
               WS-HOLD-ALPHA-VAR (1:2) NUMERIC AND                      
               WS-HOLD-ALPHA-VAR (4:2) NUMERIC AND                      
               WS-HOLD-ALPHA-VAR (7:2) NUMERIC                          
               MOVE WS-HOLD-ALPHA-VAR (1:8) TO WS-DATE-8                
            ELSE                                                        
               PERFORM 9997-ERROR-ROUTINE THRU 9997-EXIT                
            END-IF
            END-IF.                                                     
      *                                                                 14540000
       5095-EXIT.                                                       
            EXIT.                                                       
      *                                                                 14570000
      ************************************************************      14580000
      *  CALL SCSCA150 TO GET PAYMENT AGENCY AND BUSINESS OFFICE *      14590000
      *  INFORMATION.                                            *      14600000
      ************************************************************      14610000
                                                                        
       5500-CALL-SCSCA150.                                              
                                                                        
           MOVE WS-DATABASE               TO WS-CA150-DATABASE.         
                                                                        
           CALL SCSCA150                  USING WS-SCSCA150-PARMS       
                                                WS-PAY-AGNCY-TABLE      
                                                WS-BUS-OFFICE-TABLE     
                                                WS-SCSCA-RETURN-CODE    
                                                LS-CURR-WQ-ITEM         
                                                WS-BILLING-WQ-ITEMS-WF. 
                                                                        
           MOVE 'SCSCA150'                   TO WS-DISPLAY-SCSCA.       
                                                                        
           IF WS-SCSCA-RETURN-CODE NOT = 0                              
               PERFORM 9200-SCSCA-ERROR THRU 9200-EXIT                  
           END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      14830000
      *  CALL SCSCA184 TO GET ADDRESS.                           *      14840000
      ************************************************************      14850000
                                                                        
       5800-CALL-SCSCA184.                                              
                                                                        
           CALL SCSCA184                  USING WS-SCSCA184-PARMS       
                                                WS-MST-SUB-ACCT-IND-AT  
                                                WS-CODE-PRNT-BLL-MST-AT 
                                                WS-CODE-TEMP-BILL-AT    
                                                WS-SCSCA-RETURN-CODE    
                                                LS-CURR-WQ-ITEM         
                                                WS-BILLING-WQ-ITEMS-WF  
A04127                                          WS-ALOC-ITPA-PROCESS.   
                                                                        
           MOVE 'SCSCA184'                   TO WS-DISPLAY-SCSCA.       
                                                                        
           IF WS-SCSCA-RETURN-CODE NOT = 0                              
               PERFORM 9200-SCSCA-ERROR      THRU 9200-EXIT             
           END-IF.                                                      
      *                                                                 15020000
       5800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15050000
      ************************************************************      15060000
      *  DETERMINE IF SEB, SBR, OR SVC                           *      15070000
      ************************************************************      15080000
       5900-DETERMINE-COMPANY.                                          
                                                                        
            IF WS-EXT-LOCAL-OFFICE = ('301' OR '302' OR '303')          
                MOVE 'V'                     TO WS-REGULATED-FLAG       
            ELSE                                                        
                IF WS-EXT-REG-GROUP-CD = SPACES                         
                    MOVE 'N'                 TO WS-REGULATED-FLAG       
                ELSE                                                    
                    MOVE 'Y'                 TO WS-REGULATED-FLAG       
                END-IF                                                  
            END-IF.                                                     
      *                                                                 15200000
       5900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15230000
      ***************************************************************** 15240000
      *  REMOVE EMBEDDED SPACES                                       * 15250000
      ***************************************************************** 15260000
       COPY CPD00004.                                                   15270000
      *                                                                 15280000
      ***************************************************************** 15290000
      *  DETERMINE FILE SORT CODE AND JOB ID                          * 15300000
      ***************************************************************** 15310000
       COPY CPDCA121.                                                   15320000
      *                                                                 15330000
      ******************************************************************15410000
      * 7100-GET-ITPA-COMMENT                                          *15420000
      *  FETCHES THE ITPA COMMENT TO INSERT INTO CSS_COMM_DATA TABLE   *15430000
      ******************************************************************15440000
       7100-GET-ITPA-COMMENT.                                           
      *                                                                 15460000
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO,
              CR_HIST_TRAN_DT,
              REPLACE(CONVERT(CHAR(8), CR_HIST_TRAN_TM, 108), ':', '.') 
           CR_HIST_TRAN_TM,
              LETTER_NOTIFY_CD,
              LETTER_MAILED_DT,
              ITPA_RSLT_CURR_CD                                  
               INTO :LF-CUSTOMER-NO,                                    
                    :LF-CR-HIST-TRAN-DT,                                
                    :LF-CR-HIST-TRAN-TM,                                
                    :LF-LETTER-NOTIFY-CD,                               
                    :LF-LETTER-MAILED-DT :WS-NULL-IND1,                  
                    :LF-ITPA-RSLT-CURR-CD                               
              FROM  CSS_CRED_ITPA_HIST WITH(READUNCOMMITTED)                    
              WHERE  LETTER_NOTIFY_CD IN ('A','U')                      
              AND    CUSTOMER_NO = :LF-CUSTOMER-NO                      
              ORDER BY CR_HIST_TRAN_DT DESC,                            
                    CR_HIST_TRAN_TM DESC                                
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     15470000
MFA-TR*       SELECT CUSTOMER_NO,                                       15480000
MFA-TR*              CR_HIST_TRAN_DT,                                   15490000
MFA-TR*              CR_HIST_TRAN_TM,                                   15500000
MFA-TR*              LETTER_NOTIFY_CD,                                  15510000
MFA-TR*              LETTER_MAILED_DT,                                  15520000
MFA-TR*              ITPA_RSLT_CURR_CD                                  15530000
MFA-TR*        INTO :LF-CUSTOMER-NO,                                    15540000
MFA-TR*             :LF-CR-HIST-TRAN-DT,                                15550000
MFA-TR*             :LF-CR-HIST-TRAN-TM,                                15560000
MFA-TR*             :LF-LETTER-NOTIFY-CD,                               15570000
MFA-TR*             :LF-LETTER-MAILED-DT:WS-NULL-IND1,                  15580000
MFA-TR*             :LF-ITPA-RSLT-CURR-CD                               15590000
MFA-TR*       FROM  CSS_CRED_ITPA_HIST                                  15600000
MFA-TR*       WHERE  LETTER_NOTIFY_CD IN ('A','U')                      15610000
MFA-TR*       AND    CUSTOMER_NO = :LF-CUSTOMER-NO                      15620000
MFA-TR*       ORDER BY CR_HIST_TRAN_DT DESC,                            15630000
MFA-TR*             CR_HIST_TRAN_TM DESC                                15640000
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                              15650000
MFA-TR*    END-EXEC.                                                    15660000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF  LF-LETTER-NOTIFY-CD = 'A'                            
                   STRING 'RESEARCH: '         DELIMITED BY SIZE,       
                           WS-EXT-MESSAGE-ID DELIMITED BY SIZE,         
                           INTO WS-INITIAL-COMMENT-TX-TEXT              
               ELSE                                                     
               IF  LF-LETTER-NOTIFY-CD = 'U'                            
                   IF  LF-ITPA-RSLT-CURR-CD = 'V'                       
                       STRING 'ID VERIFIED - UNAUTHORIZED REQUEST: '    
                                             DELIMITED BY SIZE          
                        WS-EXT-MESSAGE-ID DELIMITED BY SIZE             
                               INTO WS-INITIAL-COMMENT-TX-TEXT          
                   ELSE                                                 
                   IF  LF-ITPA-RSLT-CURR-CD = 'U'                       
                       STRING 'UNVERIFIED : ' DELIMITED BY SIZE         
                         WS-EXT-MESSAGE-ID DELIMITED BY SIZE            
                               INTO WS-INITIAL-COMMENT-TX-TEXT          
               END-IF                                                   
               MOVE LENGTH OF WS-INITIAL-COMMENT-TX-TEXT                
                                         TO WS-INITIAL-COMMENT-TX-LEN
                   END-IF   
           ELSE                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
                 DISPLAY 'CHECK WHAT NEEDS TO BE DONE'                  
           ELSE                                                         
              DISPLAY '7100-GET-ITPA-COMMENT ERROR'                     
                      ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY 'CUSTOMER NUMBER :' WS-EXT-CUSTOMER-NO            
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF
               END-IF
               END-IF
           END-IF.                                                      
      *                                                                 15990000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16280000
      **************************************************************    16290000
      *  RETRIEVES MESSAGE TO BE PRINTED ON THE ADV LTR OF CREDIT. *    16300000
      **************************************************************    16310000
       7300-GET-MESSAGE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT PRINT_MESSAGE_TX,                                 
                      PRINT_FL                                          
               INTO  :PRINT-MESSAGE-TX,                                 
                     :PRINT-FL                                          
               FROM CSS_CRED_BUREAU_RC WITH(READUNCOMMITTED)                    
               WHERE COMPANY_NO        = :COMPANY-NO                    
               AND   CB_CODE_TYPE_CD   = :CB-CODE-TYPE-CD               
               AND   CB_RETURN_CD      = :CB-RETURN-CD                  
A05198         AND   SCORE_MODEL_CD    = :SCORE-MODEL-CD                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16340000
MFA-TR*        SELECT PRINT_MESSAGE_TX,                                 16350000
MFA-TR*               PRINT_FL                                          16360000
MFA-TR*        INTO  :PRINT-MESSAGE-TX,                                 16370000
MFA-TR*              :PRINT-FL                                          16380000
MFA-TR*        FROM CSS_CRED_BUREAU_RC                                  16390000
MFA-TR*        WHERE COMPANY_NO        = :COMPANY-NO                    16400000
MFA-TR*        AND   CB_CODE_TYPE_CD   = :CB-CODE-TYPE-CD               16410000
MFA-TR*        AND   CB_RETURN_CD      = :CB-RETURN-CD                  16420000
MFA-TR*        AND   SCORE_MODEL_CD    = :SCORE-MODEL-CD                16421000
MFA-TR*        WITH UR                                                  16430000
MFA-TR*    END-EXEC.                                                    16440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                  CONTINUE                                              
              WHEN NOT-FOUND                                            
                  ADD 1 TO WS-NOT-FOUND-CNTR                            
                  MOVE +100                  TO WS-ACTIVE-RETURN-CODE   
                  MOVE CB-RETURN-CD          TO WS-NOT-FOUND-CB-RC(SUB2)
                  MOVE CB-CODE-TYPE-CD       TO                         
                                             WS-NOT-FOUND-RC-TYPE(SUB2) 
A05198            MOVE SCORE-MODEL-CD        TO                         
A05198                                       WS-NOT-FOUND-MODEL-CD(SUB2)
                  ADD 1                      TO SUB2                    
                  GO TO 7300-EXIT                                       
              WHEN OTHER                                                
                   DISPLAY '*************************************'      
                   DISPLAY '* 7300-GET-MESSAGE'                         
                   DISPLAY '* ACCOUNT_NO  = ' WS-EXT-ACCOUNT-NO         
                   DISPLAY '* SQL RETURN CODE = ' SQLCODE               
                   DISPLAY '*************************************'      
                   PERFORM 9900-ABEND                THRU 9900-EXIT     
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16700000
      **************************************************************    16710000
      *  COLLECTS DATA FOR WRITING TO ADVERSE LETTER WORK QUEUE.   *    16720000
      **************************************************************    16730000
       7400-WRITE-ADV-LTR-WQ.                                           
      *                                                                 16750000
A04860     INITIALIZE CWS00077-FIELDS.                                  
           MOVE SQLCODE                      TO WS-DISPLAY-SQL-CODE.    
A04860     MOVE 227                          TO WS-77-CATEGORY-ID.      
A04860     MOVE 'N'                          TO WS-77-PRIORITY.         
A04860     MOVE 4                            TO WS-77-ROUTE-CATEGORY.   
A04860     MOVE 250                          TO WS-77-COMMENTS-LEN.     
A04815     MOVE WS-EXT-CUSTOMER-NO           TO WS-CUST-NO-DISPLAY.     
           MOVE 1                            TO SUB2.                   
                                                                        
           PERFORM UNTIL SUB2 > 4                                       
               MOVE WS-NOT-FOUND-RC-TYPE(SUB2) TO                       
                    WS-DISPLAY-TYPE-CD(SUB2)                            
               MOVE WS-NOT-FOUND-CB-RC(SUB2) TO                         
                    WS-DISPLAY-CB-RC(SUB2)                              
A05198         MOVE WS-NOT-FOUND-MODEL-CD(SUB2) TO                      
A05198              WS-DISPLAY-MODEL-CD(SUB2)                           
               ADD 1 TO SUB2                                            
           END-PERFORM.                                                 
                                                                        
           MOVE 1 TO SUB2.                                              
           PERFORM UNTIL SUB2 > WS-NOT-FOUND-CNTR                       
               MOVE DISPLAY-NOT-FOUND(SUB2)  TO WS-NOT-FND-ITEM(SUB2)   
               ADD 1 TO SUB2                                            
           END-PERFORM.                                                 
                                                                        
           MOVE WS-ALOC-NOT-FOUND-STR        TO DISPLAY-STRING.         
           STRING 'ADV LETTER OF CREDIT FAILED TO SELECT REASON'        
                  ' CUST NO = '                                         
                  WS-CUST-NO-DISPLAY                                    
                  '  '                                                  
                  DISPLAY-NOT-FOUND-TXT                                 
                  DELIMITED BY SIZE                                     
A04860            INTO WS-77-COMMENTS-TEXT.                             
                                                                        
A04860     MOVE ZERO                         TO WS-77-SERV-ORDER-NO.    
A04815     IF WS-EXT-STMT-DATE > SPACES                                 
A04860        MOVE WS-EXT-STMT-DATE          TO WS-77-DATE-REQUIRED     
A04815     ELSE                                                         
A04815        MOVE 'NON-NUMERIC DATA IN DATE FIELDS' TO                 
A04815                                       WS-ERROR-REASON            
A04815        PERFORM 9995-ERROR-ROUTINE    THRU 9995-EXIT              
A04815     END-IF.                                                      
A04860     MOVE ZEROES                       TO WS-77-ACCOUNT-NO.       
A04860     MOVE ZEROES                       TO WS-77-PREMISE-NO.       
A04860     MOVE WS-EXT-CUSTOMER-NO           TO WS-77-CUSTOMER-NO.      
A04860     MOVE 437                          TO WS-77-RESP-AREA-ID.     
A04860     MOVE SPACES                       TO WS-77-LOCAL-OFFICE.     
A04860     MOVE ZEROES                       TO WS-77-FREE-FORM-LEN.    
A04860     MOVE LOW-VALUES                   TO WS-77-FREE-FORM-TXT.    
A04860     MOVE PROGRAM-NAME                 TO WS-77-CREATED-BY.       
           PERFORM 8895-INSERT-WORK-QUEUE    THRU 8895-EXIT.            
           MOVE +100                         TO WS-ACTIVE-RETURN-CODE.  
      *                                                                 17250000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17280000
      ******************************************************************17290000
      *  DETERMINE WHETHER WE'RE IN SEB OR CSR.                        *17300000
      ******************************************************************17310000
       7500-GET-DATABASE.                                               
      *                                                                 17330000
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :C8-DELINQ-VALUE                                  
              FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
              WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
              AND     COMPANY_NO = :C8-COMPANY-NO                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17340000
MFA-TR*       SELECT  DELINQ_VALUE                                      17350000
MFA-TR*       INTO    :C8-DELINQ-VALUE                                  17360000
MFA-TR*       FROM    CSS_DELINQUENCY                                   17370000
MFA-TR*       WHERE   DELINQ_CD  = :C8-DELINQ-CD                        17380000
MFA-TR*       AND     COMPANY_NO = :C8-COMPANY-NO                       17390000
MFA-TR*       WITH UR                                                   17400000
MFA-TR*    END-EXEC.                                                    17410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 7500-GET-DATABASE'                            
               DISPLAY '* DELINQ_CD  = ' C8-DELINQ-CD                   
               DISPLAY '* COMPANY_NO = ' C8-COMPANY-NO                  
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 17560000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17590000
      ******************************************************************17910000
      *  FORMATS AND WRITES RECORDS                                    *17920000
      ******************************************************************17930000
       8000-WRITE-FCSKR150-FILE.                                        
      *                                                                 17950000
           MOVE WS-EXT-COMPANY-NO                TO WS-CA150-COMPANY-NO.
           IF WS-EXT-MESSAGE-ID = 90810                                 
              MOVE WS-EXT-ACCOUNT-NO             TO WS-HOLD-ACCOUNT-NO  
              MOVE WS-EXT-GUARNTR-ACCT-NO        TO WS-EXT-ACCOUNT-NO   
                                                    WS-CA150-ACCOUNT-NO 
              MOVE WS-HOLD-ACCOUNT-NO            TO                     
                                           WS-EXT-GUARNTR-ACCT-NO       
           ELSE                                                         
              IF WS-EXT-MESSAGE-ID = 90817 AND                          
                 WS-EXT-ALPHA-VARIABLE(1) GREATER THAN SPACES           
                MOVE WS-EXT-ACCOUNT-NO          TO WS-HOLD-ACCT-NBR     
                MOVE WS-EXT-ALPHA-VARIABLE(1)   TO WS-EXT-ACCOUNT-NO    
                                                    WS-CA150-ACCOUNT-NO 
              ELSE                                                      
                MOVE WS-EXT-ACCOUNT-NO           TO WS-CA150-ACCOUNT-NO 
              END-IF                                                    
           END-IF.                                                      
      ******************************************************************18120000
      *        FORMATTING ADDRESS FOR THIRD PARTY                      *18130000
      ******************************************************************18140000
           IF WS-EXT-MESSAGE-ID = 90822 OR 90823 OR 90824 OR            
                                    90825 OR 90108                      
               INITIALIZE                  WS-MAIL-ADDR-LINES           
               MOVE WS-TP-NAME               TO                         
                                                 WS-MAIL-ADDR-LINE-1    
               INITIALIZE                        WS-MAIL-ADDR-LINE-2    
               MOVE SPACES                   TO  WS-EMB-INPUT           
                                                 WS-CMP-TABLE           
               STRING                            WS-EXT-THRD-PTY-ADDR(1)
                                                 ' '                    
                                                 WS-EXT-THRD-PTY-ADDR(2)
                                                 DELIMITED BY SIZE INTO 
                                                 WS-EMB-INPUT           
               MOVE 56                       TO WS-EMB-LENG             
                                                                        
               PERFORM 6010-REDUCE-EMBEDDED-SPACES                      
                                             THRU 6011-EXIT             
                                                                        
               INITIALIZE                        WS-MAIL-ADDR-LINE-2    
               MOVE WS-CMP-TABLE             TO                         
                                                 WS-MAIL-ADDR-LINE-2    
                                                                        
               STRING                         WS-TP-ADDR-CITY-STATE     
                                              ' '                       
                                              WS-TP-ADDR-ZIP-CODE(1:5)  
                                              '-'                       
                                              WS-TP-ADDR-ZIP-CODE(6:4)  
                                              DELIMITED BY SIZE INTO    
                                              WS-MAIL-ADDR-LINE-3       
               IF WS-EXT-THRD-PTY-ADDR(4)(6:4) = SPACES                 
                  INITIALIZE                  WS-MAIL-ADDR-LINE-3       
                  STRING                      WS-TP-ADDR-CITY-STATE     
                                              ' '                       
                                              WS-TP-ADDR-ZIP-CODE(1:5)  
                                              DELIMITED BY SIZE INTO    
                                              WS-MAIL-ADDR-LINE-3       
               END-IF                                                   
               MOVE SPACES                   TO WS-EMB-INPUT            
               MOVE SPACES                   TO WS-CMP-TABLE            
               MOVE WS-MAIL-ADDR-LINE-3      TO WS-EMB-INPUT            
               MOVE 50                       TO WS-EMB-LENG             
                                                                        
               PERFORM 6010-REDUCE-EMBEDDED-SPACES                      
                                             THRU 6011-EXIT             
                                                                        
               INITIALIZE                     WS-MAIL-ADDR-LINE-3       
               MOVE WS-CMP-TABLE             TO                         
                                              WS-MAIL-ADDR-LINE-3       
                                                                        
               MOVE WS-EXT-THRD-PTY-ADDR(5)  TO                         
                                              WS-MAIL-ADDR-LINE-4       
               MOVE WS-MAIL-ADDR-LINES       TO WS-EXT-MAIL-ADDRESS     
               PERFORM 5000-FORMAT-MAILING-ADDR                         
                                             THRU  5000-EXIT            
            END-IF.                                                     
      ******************************************************************18720000
      *        GET SERVICE ADDRESS                                     *18730000
      ******************************************************************18740000
           MOVE WS-PR-ADDR-ZIP-CODE          TO WS-CA150-SERVICE-ZIP.   
           MOVE WS-EXT-LOCAL-OFFICE          TO WS-CA150-LOCAL-OFFICE.  
           MOVE WS-HOLD-SERVICE-ADDRESS(1)   TO                         
                                          WS-EXT-SERVICE-ADDRESS(1).    
           MOVE WS-HOLD-SERVICE-ADDRESS(2)   TO                         
                                          WS-EXT-SERVICE-ADDRESS(2).    
           MOVE WS-HOLD-SERVICE-ADDRESS(3)   TO                         
                                          WS-EXT-SERVICE-ADDRESS(3).    
           IF WS-EXT-STMT-DATE GREATER THAN SPACES                      
              MOVE WS-EXT-STMT-DATE(6:2) TO                             
                                         WS-EXT-BILL-MMYY(1:2)          
              MOVE WS-EXT-STMT-DATE(3:2) TO                             
                                         WS-EXT-BILL-MMYY(3:2)          
           END-IF.                                                      
           PERFORM 5090-FORMAT-ALPHA         THRU 5090-EXIT.            
                                                                        
           IF NOT-TPGN                                                  
              INITIALIZE  HOLD-EXTHDR                                   
                          HOLD-EXTNOTC                                  
                          HOLD-EXTMAIL                                  
                          HOLD-EXTVAR                                   
                          HOLD-EXTAINFO                                 
           END-IF.                                                      
                                                                        
      * DETERMINE THE FILE SORT CODE AND JOB ID                         18990000
           PERFORM 6200-GET-FILE-SORT-JOB-ID THRU 6200-EXIT.            
                                                                        
      * WRITE HEADER RECORD                                             19020000
           IF WS-EXT-HDR-CORR-ID >= ZEROS                               
              MOVE WS-CORR-HDR-ID  TO WS-EXT-KEY-RECORD-ID              
              MOVE WS-CORR-HDR-REC TO WS-EXT-KEY-REC-SEQ                
              MOVE WS-EXT-HDR TO WS-EXT-CORR-DATA                       
              IF NOT-TPGN                                               
                 MOVE EXTCOKEY            TO HOLD-EXTHDR                
                 MOVE WS-EXT-ACCOUNT-NO   TO HOLD-ACCOUNT-NO            
                 MOVE WS-PR-ADDR-ZIP-CODE TO WS-HOLD-PR-ZIP-CODE        
              ELSE                                                      
                 MOVE 2                   TO WS-EXT-TOTAL-SHEET         
              END-IF                                                    
              PERFORM 8100-WRITE-RECORD THRU 8100-EXIT                  
           END-IF.                                                      
                                                                        
      * WRITE NOTICE RECORD                                             19170000
           IF WS-EXT-NOTICE-CORR-ID >= ZEROS                            
              MOVE WS-NOTICE-DTL-ID  TO  WS-EXT-KEY-RECORD-ID           
              MOVE WS-NOTICE-DTL-REC TO WS-EXT-KEY-REC-SEQ              
              MOVE WS-EXT-NOTICE TO WS-EXT-CORR-DATA                    
              IF NOT-TPGN                                               
                 MOVE EXTCOKEY            TO HOLD-EXTNOTC               
              END-IF                                                    
              PERFORM 8100-WRITE-RECORD THRU 8100-EXIT                  
           END-IF.                                                      
                                                                        
      * WRITE MAILING DETAIL RECORD                                     19280000
           IF WS-EXT-MAILING-DTL > SPACES                               
              MOVE WS-MAILING-DTL-ID TO  WS-EXT-KEY-RECORD-ID           
              MOVE WS-MAILING-DTL-REC TO WS-EXT-KEY-REC-SEQ             
              MOVE WS-EXT-MAILING-DTL TO WS-EXT-CORR-DATA               
              IF NOT-TPGN                                               
                 MOVE EXTCOKEY            TO HOLD-EXTMAIL               
              END-IF                                                    
              PERFORM 8100-WRITE-RECORD THRU 8100-EXIT                  
           END-IF.                                                      
                                                                        
      * WRITE ALPHA/NUM VARIABLE RECORD                                 19390000
           IF WS-EXT-VAR-CORR-ID >= ZEROS                               
              MOVE WS-VAR-DTL-ID   TO WS-EXT-KEY-RECORD-ID              
              MOVE WS-VAR-DTL-REC TO WS-EXT-KEY-REC-SEQ                 
              MOVE WS-EXT-ALPHA-VARIABLE-DTL TO WS-EXT-CORR-DATA        
              IF NOT-TPGN                                               
                 MOVE EXTCOKEY            TO HOLD-EXTVAR                
              END-IF                                                    
              PERFORM 8100-WRITE-RECORD THRU 8100-EXIT                  
           END-IF.                                                      
                                                                        
      * WRITE ADDITIONAL INFO RECORD                                    19500000
           IF WS-EXT-ADDITIONAL-INFO > SPACES                           
              MOVE WS-ADDL-INFO-DTL-ID TO  WS-EXT-KEY-RECORD-ID         
              MOVE WS-ADDL-INFO-DTL-REC TO WS-EXT-KEY-REC-SEQ           
              MOVE WS-EXT-ADDITIONAL-INFO TO WS-EXT-CORR-DATA           
              IF NOT-TPGN                                               
                 MOVE EXTCOKEY            TO HOLD-EXTAINFO              
              END-IF                                                    
              PERFORM 8100-WRITE-RECORD THRU 8100-EXIT                  
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19630000
       8100-WRITE-RECORD.                                               
      *                                                                 19650000
           IF WS-CODE-TEMP-BILL-AT = 'T'                                
              MOVE 'ADDRESS PROCESSING ERROR' TO WS-ERROR-REASON        
              PERFORM 9995-ERROR-ROUTINE       THRU 9995-EXIT           
           ELSE                                                         
              MOVE EXTCOKEY               TO EXTMCLFN                   
              WRITE EXTMCLFN                                            
              ADD 1                       TO WS-RECORD-CNT              
      ** WRITE OUT A DUPLICATE OF ALOC LETTER INTO UNMASKED FILE        19902000
A05382        IF WS-EXT-MESSAGE-ID = (90701 OR 90799 OR 90704 OR 90706) 
              AND WS-HOLD-ISMASKED = 'Y'                                
                  IF WS-EXT-KEY-RECORD-ID EQUAL 'VARI-DTL'              
                     IF WS-EXT-MESSAGE-ID = 90799                       
                        MOVE 'NOCUST'     TO WS-EXT-ALPHA-VARIABLE(10)  
                     ELSE                                               
                        MOVE SPACES       TO WS-EXT-ALPHA-VARIABLE(10)  
                     END-IF                                             
                     MOVE WS-EXT-ALPHA-VARIABLE-DTL TO WS-EXT-CORR-DATA 
                  END-IF                                                
                  MOVE WS-EXT-KEY-FILE-SORT TO WS-HOLD-FILE-SORT        
P00599            MOVE 'M' TO WS-EXT-KEY-FILE-SORT(2:1)                 
                  MOVE EXTCOKEY                  TO EXTMCLFN            
                  WRITE EXTMCLFN                                        
                  MOVE WS-HOLD-FILE-SORT TO WS-EXT-KEY-FILE-SORT        
                  ADD 1 TO WS-RECORD-CNT                                
              END-IF                                                    
           END-IF.                                                      
      *                                                                 20170000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20200000
      ******************************************************************20210000
      *   8400-INSERT-CUST-COMM-ITPA.                                  *20220000
      ******************************************************************20230000
       8400-INSERT-CUST-COMM-ITPA.                                      
      *                                                                 20250000
           MOVE 0                            TO KO-ACCOUNT-NO.          
           MOVE WS-EXT-COMPANY-NO            TO KO-COMPANY-NO.          
           MOVE WS-N                         TO KO-RED-FLAG-IND.        
           MOVE SPACES                       TO KO-RED-FLAG-EXPIRE-DT.  
           MOVE -1                           TO WS-RED-FL-NULL-IND.     
           MOVE 'L'                          TO KO-COMM-METHOD.         
           MOVE 'O'                          TO KO-COMM-DIRECTION.      
           MOVE '05'                         TO KO-COMM-TYPE-CD.        
           MOVE '13'                         TO KO-COMM-SUBTYPE-CODE.   
           MOVE 'SYSTEM'                     TO KO-USER-ID-ORIG.        
           MOVE SPACES                       TO KO-PROMOTION-ID.        
           MOVE SPACES                       TO KO-PSC-COMPLIANCE-IND.  
           MOVE 0                            TO KO-CALL-ORIGIN-ID.      
           MOVE SPACES                       TO KO-CALL-END-TIME.       
           MOVE -1                           TO WS-END-NULL-IND.        
           MOVE 0                            TO KO-NUMBER-TRANSFERS.    
           MOVE 0                            TO KO-HOLD-TIME.           
           MOVE 0                            TO KO-QUEUE-TIME.          
           MOVE WS-N                         TO KO-SCREEN-POP-IND.      
           MOVE 0                            TO KO-TOTAL-CALL-TIME.     
           PERFORM 7100-GET-ITPA-COMMENT   THRU 7100-EXIT.              
           MOVE WS-INITIAL-COMMENT-TX        TO KO-INITIAL-COMMENT-TX.  
           MOVE SPACES                       TO KO-RESPONSE-REASON-CD.  
           MOVE SPACES                       TO KO-RESPONSE-TYPE-CD.    
           MOVE SPACES                       TO KO-SOLICITATION-CD.     
           MOVE 'C'                          TO KO-COMM-ASSOC-CD.       
           MOVE WS-N                         TO KO-COMPLAINT-FL.        
           MOVE SPACES                       TO KO-DISCOVERY-MTHD-CD.   
           MOVE SPACES                       TO KO-PREV-MARKETER-CD.    
           IF SEB-DATABASE                                              
              MOVE 'CREDIT DEPARTMENT'       TO KO-CONTACT-NAME         
           ELSE                                                         
              MOVE 'RECEIVABLES MANAGEMENT'                             
                                             TO KO-CONTACT-NAME         
           END-IF.                                                      
           MOVE WS-EXT-CUSTOMER-NO           TO KO-CUSTOMER-NO.         
           MOVE ZEROS                        TO KO-PREMISE-NO.          
           MOVE 'SYSTEM'                     TO KO-USER-ID-ORIG.        
      *                                                                 20670000
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                        (COMMUNICATION_ID,                              
                         ACCOUNT_NO,                                    
                         CUSTOMER_NO,                                   
                         PREMISE_NO,                                    
                         COMPANY_NO,                                    
                         RED_FLAG_IND,                                  
                         RED_FLAG_EXPIRE_DT,                            
                         COMM_METHOD,                                   
                         COMM_DIRECTION,                                
                         COMM_TYPE_CD,                                  
                         COMM_SUBTYPE_CODE,                             
                         USER_ID_ORIG,                                  
                         CONTACT_NAME,                                  
                         PROMOTION_ID,                                  
                         PSC_COMPLIANCE_IND,                            
                         CALL_ORIGIN_ID,                                
                         CALL_END_TIME,                                 
                         NUMBER_TRANSFERS,                              
                         HOLD_TIME,                                     
                         QUEUE_TIME,                                    
                         SCREEN_POP_IND,                                
                         TOTAL_CALL_TIME,                               
                         INITIAL_COMMENT_TX,                            
                         RESPONSE_REASON_CD,                            
                         RESPONSE_TYPE_CD,                              
                         SOLICITATION_CD,                               
                         COMM_ASSOC_CD,                                 
                         COMPLAINT_FL,                                  
                         DISCOVERY_MTHD_CD,                             
                         PREV_MARKETER_CD)                              
                VALUES   (CIS.CURRENT$TIMESTAMP(),                            
                         :KO-ACCOUNT-NO,                                
                         :KO-CUSTOMER-NO,                               
                         :KO-PREMISE-NO,                                
                         :KO-COMPANY-NO,                                
                         :KO-RED-FLAG-IND,                              
                         CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
                         :KO-COMM-METHOD,                               
                         :KO-COMM-DIRECTION,                            
                         :KO-COMM-TYPE-CD,                              
                         :KO-COMM-SUBTYPE-CODE,                         
                         :KO-USER-ID-ORIG,                              
                         :KO-CONTACT-NAME,                              
                         :KO-PROMOTION-ID,                              
                         :KO-PSC-COMPLIANCE-IND,                        
                         :KO-CALL-ORIGIN-ID,                            
                         CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
                         :KO-NUMBER-TRANSFERS,                          
                         :KO-HOLD-TIME,                                 
                         :KO-QUEUE-TIME,                                
                         :KO-SCREEN-POP-IND,                            
                         :KO-TOTAL-CALL-TIME,                           
                         :KO-INITIAL-COMMENT-TX,                        
                         :KO-RESPONSE-REASON-CD,                        
                         :KO-RESPONSE-TYPE-CD,                          
                         :KO-SOLICITATION-CD,                           
                         :KO-COMM-ASSOC-CD,                             
                         :KO-COMPLAINT-FL,                              
                         :KO-DISCOVERY-MTHD-CD,                         
                         :KO-PREV-MARKETER-CD)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     20680000
MFA-TR*         INSERT INTO CSS_COMM_DATA                               20690000
MFA-TR*                 (COMMUNICATION_ID,                              20700000
MFA-TR*                  ACCOUNT_NO,                                    20710000
MFA-TR*                  CUSTOMER_NO,                                   20720000
MFA-TR*                  PREMISE_NO,                                    20730000
MFA-TR*                  COMPANY_NO,                                    20740000
MFA-TR*                  RED_FLAG_IND,                                  20750000
MFA-TR*                  RED_FLAG_EXPIRE_DT,                            20760000
MFA-TR*                  COMM_METHOD,                                   20770000
MFA-TR*                  COMM_DIRECTION,                                20780000
MFA-TR*                  COMM_TYPE_CD,                                  20790000
MFA-TR*                  COMM_SUBTYPE_CODE,                             20800000
MFA-TR*                  USER_ID_ORIG,                                  20810000
MFA-TR*                  CONTACT_NAME,                                  20820000
MFA-TR*                  PROMOTION_ID,                                  20830000
MFA-TR*                  PSC_COMPLIANCE_IND,                            20840000
MFA-TR*                  CALL_ORIGIN_ID,                                20850000
MFA-TR*                  CALL_END_TIME,                                 20860000
MFA-TR*                  NUMBER_TRANSFERS,                              20870000
MFA-TR*                  HOLD_TIME,                                     20880000
MFA-TR*                  QUEUE_TIME,                                    20890000
MFA-TR*                  SCREEN_POP_IND,                                20900000
MFA-TR*                  TOTAL_CALL_TIME,                               20910000
MFA-TR*                  INITIAL_COMMENT_TX,                            20920000
MFA-TR*                  RESPONSE_REASON_CD,                            20930000
MFA-TR*                  RESPONSE_TYPE_CD,                              20940000
MFA-TR*                  SOLICITATION_CD,                               20950000
MFA-TR*                  COMM_ASSOC_CD,                                 20960000
MFA-TR*                  COMPLAINT_FL,                                  20970000
MFA-TR*                  DISCOVERY_MTHD_CD,                             20980000
MFA-TR*                  PREV_MARKETER_CD)                              20990000
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                            21000000
MFA-TR*                  :KO-ACCOUNT-NO,                                21010000
MFA-TR*                  :KO-CUSTOMER-NO,                               21020000
MFA-TR*                  :KO-PREMISE-NO,                                21030000
MFA-TR*                  :KO-COMPANY-NO,                                21040000
MFA-TR*                  :KO-RED-FLAG-IND,                              21050000
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,     21060000
MFA-TR*                  :KO-COMM-METHOD,                               21070000
MFA-TR*                  :KO-COMM-DIRECTION,                            21080000
MFA-TR*                  :KO-COMM-TYPE-CD,                              21090000
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                         21100000
MFA-TR*                  :KO-USER-ID-ORIG,                              21110000
MFA-TR*                  :KO-CONTACT-NAME,                              21120000
MFA-TR*                  :KO-PROMOTION-ID,                              21130000
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                        21140000
MFA-TR*                  :KO-CALL-ORIGIN-ID,                            21150000
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,             21160000
MFA-TR*                  :KO-NUMBER-TRANSFERS,                          21170000
MFA-TR*                  :KO-HOLD-TIME,                                 21180000
MFA-TR*                  :KO-QUEUE-TIME,                                21190000
MFA-TR*                  :KO-SCREEN-POP-IND,                            21200000
MFA-TR*                  :KO-TOTAL-CALL-TIME,                           21210000
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                        21220000
MFA-TR*                  :KO-RESPONSE-REASON-CD,                        21230000
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                          21240000
MFA-TR*                  :KO-SOLICITATION-CD,                           21250000
MFA-TR*                  :KO-COMM-ASSOC-CD,                             21260000
MFA-TR*                  :KO-COMPLAINT-FL,                              21270000
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                         21280000
MFA-TR*                  :KO-PREV-MARKETER-CD)                          21290000
MFA-TR*    END-EXEC.                                                    21300000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21310000
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 8400-INSERT-CUST-COMM-ITPA'                   
               DISPLAY '* ACCOUNT_NO  = ' WS-EXT-ACCOUNT-NO             
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 21430000
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21460000
      ************************************************************      21470000
      *  8895-INSERT-WORK-QUEUE                                  *      21480000
      ************************************************************      21490000
      *                                                                 21500000
A04860*                                                                 21500100
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860                                                                  
A04860     MOVE SPACES TO ABEND-FUNCTION.                               
A04860                                                                  
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      *                                                                 21540000
      ***************************************************************** 21550000
      ** TERMINATION ROUTINE.                                        ** 21560000
      ***************************************************************** 21570000
       9000-TERMINATE.                                                  
                                                                        
            EXIT PROGRAM.                                               
                                                                        
       9000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 21640000
       9200-SCSCA-ERROR.                                                
                                                                        
           MOVE WS-SCSCA-RETURN-CODE TO RETURN-CODE.                    
           DISPLAY ' '.                                                 
           DISPLAY '********************************************'.      
           DISPLAY '**  CALLED PGM  = ' WS-DISPLAY-SCSCA.               
           DISPLAY '**  RETURN CODE = ' WS-SCSCA-RETURN-CODE.           
           DISPLAY '**  ACCOUNT     = ' WS-EXT-ACCOUNT-NO.              
           DISPLAY '********************************************'.      
           DISPLAY ' '.                                                 
           DISPLAY ' '.                                                 
           DISPLAY '********************************************'.      
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
                                                                        
       9200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21820000
      ************************************************************      21830000
      *  9700-PROCESS-ABEND                                      *      21840000
      ************************************************************      21850000
                                                                        
       COPY CPD0023B.                                                   21870000
                                                                        
      *                                                                 21890000
      ***************************************************************** 21900000
      ** 9900-ABEND.                                                 ** 21910000
      ***************************************************************** 21920000
      *                                                                 21930000
       9900-ABEND.                                                      
                                                                        
           MOVE 12 TO RETURN-CODE.                                      
                                                                        
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22320000
       9995-ERROR-ROUTINE.                                              
      *                                                                 22340000
           DISPLAY '****9995-ERROR-ROUTINE***********************'.     
           DISPLAY '*          SCSCA121 PROCESSING ERROR        *'.     
           DISPLAY '******      ACCOUNT SKIPPED            ******'.     
           DISPLAY '*********************************************'.     
           DISPLAY '* ERROR REASON            ' WS-ERROR-REASON.        
           DISPLAY '* ACCOUNT NUMBER          ' WS-EXT-ACCOUNT-NO.      
           DISPLAY '* MESSAGE NUMBER          ' WS-EXT-MESSAGE-ID.      
           MOVE 8                            TO RETURN-CODE.            
           PERFORM 9999-BAIL-OUT             THRU 9999-EXIT.            
      *                                                                 22450000
       9995-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22480000
       9996-ERROR-ROUTINE.                                              
           DISPLAY '**********  CHECK-NOTICE-TYPE       *********'.     
           DISPLAY '*          SCSCA121 PROCESSING ERROR        *'.     
           DISPLAY '* ACCT# FOR THIRD/PARTY OR GUARNATOR RECORD *'.     
           DISPLAY '* DOES NOT MATCH PREVIOUS RECORD OR CONTAINS*'.     
           DISPLAY '* AN INVALID NOTICE TYPE. CHECK INPUT FILE. *'.     
           DISPLAY '******      PROCESSING IS STOPPED      ******'.     
           DISPLAY '*********************************************'.     
           DISPLAY '* ACCOUNT NUMBER          ' WS-EXT-ACCOUNT-NO.      
           DISPLAY '* MESSAGE NUMBER          ' WS-EXT-MESSAGE-ID.      
           DISPLAY '* NOTICE  TYPE            ' WS-EXT-TYPE-CD.         
           MOVE 12                      TO RETURN-CODE.                 
           PERFORM 9999-BAIL-OUT        THRU 9999-EXIT.                 
                                                                        
       9996-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22660000
       9997-ERROR-ROUTINE.                                              
           DISPLAY '****************************************'.          
           DISPLAY '**     SCSCA121 PROCESSING ERROR      **'.          
           DISPLAY '** INVALID ALPHA-VARIABLE DATA FOR    **'.          
           DISPLAY '** MESSAGE NUMBER ' WS-EXT-MESSAGE-ID.              
           DISPLAY '** CONTENTS OF ALPHA-VARIABLE FIELD   **'.          
           DISPLAY '** SHOULD BE A DB2 DATE OR IN MM/DD/YY**'.          
           DISPLAY '** FORMAT.    PROCESSING STOPPED.     **'.          
           DISPLAY '****************************************'.          
           DISPLAY '* ACCOUNT NUMBER          ' WS-EXT-ACCOUNT-NO.      
           DISPLAY '* CONTENTS OF ALPA-VAR = ' WS-HOLD-ALPHA-VAR.       
           MOVE 12                      TO RETURN-CODE.                 
           PERFORM 9999-BAIL-OUT        THRU 9999-EXIT.                 
                                                                        
       9997-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22840000
       9999-BAIL-OUT.                                                   
                                                                        
           MOVE RETURN-CODE TO RS-RETURN-CODE.                          
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22930000
