       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. SCSCA120.                                            
       AUTHOR. VALERIE LANGLEY.                                         
       DATE-WRITTEN. AUGUST 1987.                                       
      ***************************************************************** 00050001
      ***************************************************************** 00060067
      **               SOUTH CAROLINA ELECTRIC & GAS                 ** 00070001
      **                                                             ** 00090001
      ********            CUSTOMER SERVICE SYSTEM             ********* 00100001
      ********                      DB2                       ********* 00110001
      ***************************************************************** 00120001
      **               PROGRAM MODIFICATION LOG                      ** 00140001
      **                                                             ** 00130001
      **    DATE    INITIALS     REASON                              ** 00150001
      **    ----    --------     -----------------                   ** 00160080
      **  03/13/03   SG18894     CLONED GAS802 PROGRAM               ** 00210000
      ***************************************************************** 00170001
           REMARKS.                                                     
                              SCSCA120 NARRATIVE                        
      ***************************************************************** SCSCA120
      *                                                                 SCSCA120
      * FPV FACTOR CALCULATIONS                                         SCSCA120
      *                                                                 SCSCA120
      * 1. PURPOSE                                                      SCSCA120
      * THIS SUBPROGRAM CALCULATES THE SUPERCOMPRESSIBILITY(FPV) FACTOR SCSCA120
      * USED IN DETERMINING BOTH ORIFICE AND POSITIVE METERED NATURAL   SCSCA120
      * GAS VOLUMES.                                                    SCSCA120
      *                                                                 SCSCA120
      * RETURNS:                                                        SCSCA120
      *   FPV FACTOR FOR DAILY VOLUME                                   SCSCA120
      *   ERROR MESSAGE 901394 WHEN PRESSURE OUT OF RANGE OF E CALC.    SCSCA120
      *                                                                 SCSCA120
      ***************************************************************** SCSCA120
      *                                                                 00240001
                   ---- BASIC BATCH SEQUENCE STRUCTURE ----             
                                                                        
                  0000 - 0000     MAIN CONTROL PATH                     
                  0100 - 0999     INITIALIZATION                        
                  1000 - 4999     MAJOR PROCESSING LOOP                 
                  5000 - 5999     COMMON PROGRAM MODULES                
                  7000 - 7999     SQL MODULES                           
                  8000 - 8999     OUTPUT MODULES                        
                  9000 - 9799     TERMINATION MODULES                   
                  9900 - 9999     ABEND/ABORT MODULES                   
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         
HPCCDM*SKIP2                                                            SCSCA120
      *MOLECULAR WEIGHT OF CARBON DIOXIDE                               SCSCA120
      *77  M-SUB-C                         COMP-2     VALUE 0.0102935.  SCSCA120
       77  M-SUB-C                         COMP-2     VALUE 1.02935E-02.
      *MOLECULAR WEIGHT OF NITROGEN                                     SCSCA120
      *77  M-SUB-N                         COMP-2     VALUE 0.00708297. SCSCA120
       77  M-SUB-N                         COMP-2     VALUE 7.08297E-03.
      *NATURAL LOG CONSTANT (NAPIERIAN CONSTANT)                        SCSCA120
       77  LOWERCASE-E       COMP-2 VALUE 2.71828182846E-00.            
                                                                        
       01  INTERMEDIATE-VARIABLES COMP-2.                               
           05 ADJUSTED-PRESSURE.                                        
           05 ADJUSTED-TEMPERATURE.                                     
           05 ABSOLUTE-GAUGE-PRESSURE.                                  
           05 D-SUB-F.                                                  
           05 LOWERCASE-B.                                              
           05 UPPERCASE-B.                                              
           05 N.                                                        
           05 M.                                                        
           05 PI.                                                       
           05 TAU.                                                      
           05 F-SUB-SP.                                                 
           05 F-SUB-ST.                                                 
           05 K-SUB-T.                                                  
           05 K-SUB-P.                                                  
           05 UPPERCASE-E.                                              
           05 DELTA.                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  SCSCA120-LINK-RECORD.                                        
           05 ERROR-NUMBER                  PIC 9(6).                   
COB305     05 TEMPERATURE        PIC S999 COMP-3 VALUE 0.            
COB305     05 SPECIFIC-GRAVITY        PIC S9V999 COMP-3 VALUE 0.          
COB305     05 GAUGE-PRESSURE        PIC S9(4)V9 COMP-3 VALUE 0.         
COB305     05 FPV-FACTOR        PIC S9V9(4) COMP-3 VALUE 0.         
                                                                        
       PROCEDURE DIVISION USING SCSCA120-LINK-RECORD.                   
           MOVE ZERO TO FPV-FACTOR, ERROR-NUMBER.                       
      *    DISPLAY 'TEMP = ', TEMPERATURE.                                      
      *    DISPLAY 'SP. GRAVITY = ', SPECIFIC-GRAVITY                           
      *    DISPLAY 'PRES = ', GAUGE-PRESSURE.                                   
      *    DISPLAY '*****CALC*****'                                             
           PERFORM P010-CALCULATE-K-SUB-T.                              
           PERFORM P020-CALCULATE-F-SUB-ST.                             
           PERFORM P030-CALCULATE-ADJUSTED-TEMP.                        
           PERFORM P040-CALCULATE-K-SUB-P.                              
           PERFORM P050-CALCULATE-F-SUB-SP.                             
           PERFORM P060-CALCULATE-ADJUSTED-PRESS.                       
           PERFORM P070-CALCULATE-TAU.                                  
           PERFORM P080-CALCULATE-PI.                                   
           PERFORM P090-CALCULATE-M.                                    
           PERFORM P100-CALCULATE-N.                                    
           PERFORM P110-CALCULATE-UPPERCASE-B.                          
           PERFORM P120-CALCULATE-E.                                    
           IF ERROR-NUMBER > 0                                          
              GOBACK
           END-IF.                                                   
           PERFORM P130-CALCULATE-LOWERCASEB.                           
           PERFORM P140-CALCULATE-D-SUB-F.                              
           PERFORM P150-CALCULATE-FPV.                                  
      *    DISPLAY 'FPV FACTOR = ', FPV-FACTOR.                                 
           GOBACK.                                                      
                                                                        
       P010-CALCULATE-K-SUB-T.                                          
           COMPUTE K-SUB-T ROUNDED = M-SUB-C + (1.681 * M-SUB-N).       
           COMPUTE K-SUB-T ROUNDED = M-SUB-C + (1.681E+00 * M-SUB-N).   
                                                                        
       P020-CALCULATE-F-SUB-ST.                                         
           COMPUTE F-SUB-ST ROUNDED = 2.2629E+02 /                      
              (9.915E+01 + (2.119E+02 * SPECIFIC-GRAVITY) - K-SUB-T).   
                                                                        
       P030-CALCULATE-ADJUSTED-TEMP.                                    
           COMPUTE ADJUSTED-TEMPERATURE =                               
              ((TEMPERATURE + 4.60E+02) * F-SUB-ST) - 4.60E+02.         
                                                                        
       P040-CALCULATE-K-SUB-P.                                          
           COMPUTE K-SUB-P ROUNDED = M-SUB-C - (0.392 * M-SUB-N).       
           COMPUTE K-SUB-P = M-SUB-C - (3.92E-01 * M-SUB-N).            
                                                                        
       P050-CALCULATE-F-SUB-SP.                                         
           COMPUTE F-SUB-SP ROUNDED = 156.47 / (160.8 -                 
              (7.22 * SPECIFIC-GRAVITY) + K-SUB-P).                     
           COMPUTE F-SUB-SP = 1.5647E+02 / (1.608E+02 -                 
              (7.22E+00 * SPECIFIC-GRAVITY) + K-SUB-P).                 
                                                                        
       P060-CALCULATE-ADJUSTED-PRESS.                                   
           COMPUTE ADJUSTED-PRESSURE ROUNDED =                          
              GAUGE-PRESSURE * F-SUB-SP.                                
                                                                        
       P070-CALCULATE-TAU.                                              
           COMPUTE TAU = (ADJUSTED-TEMPERATURE + 4.60E+02) / 5.00E+02.  
                                                                        
       P080-CALCULATE-PI.                                               
           COMPUTE PI = (ADJUSTED-PRESSURE + 1.47E+01) / 1.000E+03.     
                                                                        
       P090-CALCULATE-M.                                                
           COMPUTE M =                                                  
              (3.30378E-02 * (TAU ** (-2))) -                           
              (2.21323E-02 * (TAU ** (-3))) +                           
              (1.61353E-02 * (TAU ** (-5))).                            
                                                                        
       P100-CALCULATE-N.                                                
           COMPUTE N  =                                                 
              ((2.65827E-01 * (TAU ** (-2))) +                          
               (4.57697E-02 * (TAU ** (-4))) -                          
               (1.33185E-01 * (TAU ** (-1)))) / M.                      
                                                                        
       P110-CALCULATE-UPPERCASE-B.                                      
           COMPUTE UPPERCASE-B =                                        
              (3.0E+00 - (M * (N ** 2))) /                              
              (9.0E+00 * M * (PI ** 2)).                                
                                                                        
       P120-CALCULATE-E.                                                
           IF ((PI NOT < 0) AND (PI NOT > 2) AND (TAU NOT < 1.09) AND   
              (TAU NOT > 1.4))                                          
              COMPUTE DELTA = TAU - 1.09                                
              COMPUTE UPPERCASE-E =                                     
                 1.0E+00 - ((7.5E-04 * PI ** 2.3) *                     
                 (LOWERCASE-E ** (-2.0E+01 * DELTA))) -                 
                 ((1.1E-03 * DELTA ** 0.5) *                            
                 (PI ** 2) *                                            
                 (2.17E+00 + (1.4E+00 * DELTA ** 0.5) - PI) ** 2)       
           ELSE                                                         
              COMPUTE DELTA = 1.09 - TAU                                
              IF ((PI NOT < 0) AND (PI NOT > 1.3) AND                   
                 (TAU NOT < 0.84) AND (TAU NOT > 1.09))                 
                 COMPUTE UPPERCASE-E =                                  
                    1.0E+00 - (7.5E-04 * PI ** 2.3) *                   
                    (2.0E+00 - LOWERCASE-E ** (-2.0E+01 * DELTA)) -     
                    (1.317E+00 * DELTA ** 4) * PI                       
                    * (1.69E+00 - (PI ** 2))                            
           ELSE                                                         
              IF ((PI NOT < 1.3) AND (PI NOT > 2) AND                   
                 (TAU NOT < 0.88) AND (TAU NOT > 1.09))                 
                    COMPUTE UPPERCASE-E = 1.0E+00                       
                      - (7.5E-04 * PI ** 2.3) * (2.0E+00 - (LOWERCASE-E 
                      ** (-2.0E+01 * DELTA))) + (4.55E-01 * ((2.00E+02 *
                      DELTA ** 6) - (3.249E-02 * DELTA) + (2.0167E+00 * 
                      DELTA ** 2) - (1.8028E+01 * DELTA ** 3) +         
                      (4.2844E+01 * DELTA ** 4))) * (PI - 1.3E+00) *    
                      ((1.69E+00 * 2.0E+00 ** 1.25) - (PI ** 2))        
           ELSE                                                         
              MOVE 901394 TO ERROR-NUMBER
              END-IF
              END-IF
           END-IF.                              
                                                                        
       P130-CALCULATE-LOWERCASEB.                                       
           COMPUTE LOWERCASE-B =                                        
              ((9.0E+00 * N) - (2.0E+00 * M * N ** 3))                  
              / (5.4E+01 * M * PI ** 3)                                 
              - UPPERCASE-E / (2.0E+00 * M * PI ** 2).                  
                                                                        
       P140-CALCULATE-D-SUB-F.                                          
           COMPUTE D-SUB-F ROUNDED =                                    
              (LOWERCASE-B +                                            
              ((LOWERCASE-B ** 2) + (UPPERCASE-B ** 3)) ** (.5))        
              ** (.333333333).                                          
                                                                        
       P150-CALCULATE-FPV.                                              
           COMPUTE FPV-FACTOR ROUNDED =                                 
              (((UPPERCASE-B / D-SUB-F) - D-SUB-F +                     
              (N / (3.0E+00 * PI))) ** 0.5) /                           
              (1.0E+00 + (1.32E-03 / (TAU ** 3.25))).                   
                                                                        
