       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA119.                                        
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                   PRICE WATERHOUSE                          **         
      **                                                             **         
      **              CUSTOMER INFORMATION SYSTEM                    **         
      *****************************************************************         
      **              P R O G R A M  S U M M A R Y                   **         
      **                                                             **         
      ** SCSCA119 WRITES IDR WORKSHEETS TO QSAM FILE FOR REPORTING   **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  -------   --------     ------                              **         
      **  06/01/97    WTF        INITIAL PROGRAM VERSION             **         
C24625**  08/03/01    LAT        WQ WRITTEN WHEN THE TABLE INDEX GOES**         
C24625**                         OUT OF RANGE.                       **         
T26776**  06/23/03    RAH        DEFINE EACH HOUR AS ON OR OFF PEAK  **         
T26776**                         FOR LAFARGE.  DO NOT GIVE BELOW     **         
T26776**                         BASELINE CREDIT DURING OFF PEAK HOURS*         
T29567**  10/24/03    VIJAY      WS-IDR-DAY-ENTRY TABLE INCREASED TO **         
T29567**                         120 OCCURANCES.                     **         
I00177**  02/05/09  SS97726      INIT WQ AREA WS-SQL-ERROR-TXT-WQ.   **         
P00496**  04/12/11  RH15956      INDUSTRIAL ENHANCEMENTS.            **         
ACT068*   02/24/15  SS7F226      ADD CREATED-BY FIELD IN WF AREA.       00656504
ACT068*   A04860                                                        00656504
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
      *** WK05 IS A REPORT EXTRACT CONTAINING IDR WORKSHEET DATA                
       COPY CSSWK05.                                                            
                                                                        
      /                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDWK05.                                                            
       COPY FIOWK05.                                                            
      /                                                                         
       WORKING-STORAGE SECTION.                                         
      **  WORK QUEUE WORK AREA                                                  
       COPY CWS0070B.                                                           
       01  WS-START                      PIC X(40)                      
           VALUE 'WORKING STORAGE FOR SCSCA119 STARTS HERE'.            
       01  WS-FWK05-STATUS               PIC X(02) EXTERNAL.            
           88  FWK05-SUCCESSFUL            VALUE '00'.                  
C24625 01  WS-LITERALS.                                                 
C24625     05  WS-REJECT                 PIC X(1)  VALUE 'R'.           
ACT068     05  WS-PGRMNAME               PIC X(8)  VALUE 'SCSCA119'.    
C24625 01  WS-MISC.                                                     
C24625     05 WS-START-POS               PIC S9(4) COMP.                
       01  WS-MISCELLANEOUS-MESSAGE.                                    
           10  FILLER                    PIC S9(4) COMP VALUE +17.      
           10  FILLER                    PIC X(1)  VALUE 'N'.           
           10  FILLER                    PIC X(1)  VALUE '4'.           
           10  WS-MISC-MSG-LEN           PIC S9(4) COMP VALUE +60.      
           10  WS-MISC-MSG-TEXT          PIC X(60).                     
C24625 01  WS-TABLE-INDEX-MSG.                                          
C24625     10  FILLER                    PIC S9(4) COMP VALUE +137.     
C24625     10  FILLER                    PIC X(1)  VALUE 'N'.           
C24625     10  FILLER                    PIC X(1)  VALUE '4'.           
C24625     10  FILLER                    PIC S9(4) COMP VALUE +25.      
C24625     10  FILLER                    PIC X(25)                      
C24625         VALUE 'IDR-DAY-INDX OUT OF RANGE'.                       
                                                                        
      /                                                                         
       LINKAGE SECTION.                                                 
       01  WS-SCSCA119-COMM-AREA.                                       
           05  WS-WORKSHEET-METER               PIC X(9).               
       01  WS-IDR-WORKSHEET.                                            
TP4737     02  WS-PRICING-TYPE-IND              PIC X(1).               
               88  REAL-TIME-PRICING        VALUE 'A'.                  
               88  BASIC-PRICING            VALUE 'B'.                  
               88  CONTRACT-PRICING         VALUE 'C'.                  
TP4737     02  WS-MAX-DAYS                      PIC S9(4)  COMP.        
TP4737     02  WS-IDR-WORKSHEET-ENTRIES         PIC S9(4) COMP.         
TP4737     02  WS-IDR-WORKSHEET-DATA.                                   
           03  WS-IDR-DST-DATA.                                         
               05  WS-IDR-DST-DATE              PIC X(10).              
               05  WS-IDR-DST-HOUR              PIC 9(2).               
               05  WS-IDR-DST-ENTRY                                     
                     OCCURS 4 TIMES                                     
                     INDEXED BY IDR-DST-INDX.                           
COB305             07 WS-IDR-DST-KW-UNITS        PIC S9(9)V99 COMP-3 
COB305               VALUE 0.    
COB305             07 WS-IDR-DST-KWH-UNITS        PIC S9(9)V9(5) COMP-3 
COB305               VALUE 0.  
COB305             07 WS-IDR-DST-KVA-UNITS        PIC S9(9)V99 COMP-3 
COB305               VALUE 0.    
COB305             07 WS-IDR-DST-KVAR-UNITS        PIC S9(9)V99 COMP-3 
COB305               VALUE 0.    
           03  WS-IDR-DAY-ENTRY                                         
T29567            OCCURS 120 TIMES                                      
                  DESCENDING KEY WS-IDR-DATE                            
                  INDEXED BY IDR-DAY-INDX.                              
               05  WS-IDR-DATE                  PIC X(10).              
      ** TOU TEST DATE IS MMDD FORMAT FOR COMPARE TO TOU START/END DATES        
               05  WS-IDR-TOU-TEST-DATE         PIC S9(4) COMP.         
               05  WS-IDR-DAY-OF-WEEK           PIC 9(1).               
               05  WS-IDR-ON-PEAK-DAY           PIC X(1).               
               05  WS-IDR-HOLIDAY-IND           PIC X(1).               
               05  WS-IDR-SEASON                PIC X(1).               
               05  WS-IDR-HOUR-ENTRY                                    
                      OCCURS 24 TIMES                                   
                      INDEXED BY IDR-ENT-INDX                           
                                 IDR-ENT-INDX2                          
                                 IDR-ENT-INDX3.                         
      ***************************************************************           
COB305             07 WS-IDR-INTERVAL-PRICE        PIC S9(3)V9(6) 
COB305               COMP-3 VALUE 0.  
      **  INTERVAL PRICE IS:                                                    
      **     (1) MARGINAL PRICE FOR RTP (BECOMES NET RATE)                      
      **     (2) FUEL COST FOR VARIABLE FUEL PRICING (ADJUSTS NET)              
      **                                                                        
      ***************************************************************           
COB305             07 WS-IDR-BASELINE-KWH        PIC S9(7) COMP-3 
COB305               VALUE 0.       
COB305             07 WS-IDR-ECON-MAX-KWH        PIC S9(7) COMP-3 
COB305               VALUE 0.       
      **  BASELINE KWH IS:                                                      
      **     (1) CUSTOMER BASELINE FOR RTP                                      
      **     (2) FIRM DEMAND POINT FOR SWITCH FROM FIRM TO ECONOMY              
      **           (KWH ABOVE THIS LEVEL UP TO ECON-MAX ARE ECONOMY)            
      **     (3) INTERRUPTABLE DEMAND LIMIT FOR CURTAILMENT                     
      **           (KWH OVER THIS LEVEL DID NOT COMPLY WITH INTERRUPT)          
      **                                                                        
      ***************************************************************           
                   07  WS-IDR-INTERVAL-ENTRIES.                         
                     08  WS-IDR-INTERVAL-ENTRY                          
                          OCCURS 4 TIMES                                
                          INDEXED BY IDR-INTV-INDX                      
                                     IDR-INTV-INDX2                     
                                     IDR-INTV-INDX3.                    
TP4636                 10  WS-IDR-UNITS.                                
COB305                   11 WS-IDR-KW-UNITS        PIC S9(9)V99 COMP-3 
COB305                       VALUE 0.  
COB305                   11 WS-IDR-KWH-UNITS        PIC S9(9)V9(5) 
COB305                       COMP-3 VALUE 0.
COB305                   11 WS-IDR-KVA-UNITS        PIC S9(9)V99 COMP-3 
COB305                       VALUE 0.  
COB305                   11 WS-IDR-KVAR-UNITS        PIC S9(9)V99 
COB305                       COMP-3 VALUE 0.  
                       10  WS-IDR-INT-TYPE      PIC X(1).               
RODFIX                 10  WS-IDR-EVENT-NO      PIC 9(2).               
                       10  WS-IDR-CURTAIL-IND   PIC X(1).               
                       10  WS-IDR-TIME-OF-USE   PIC 9(1).               
T26776             07  WS-IDR-TYPE-CODE         PIC X(1).               
       COPY CWS0022B.                                                           
       COPY CWS0024B.                                                           
C24625 COPY CWS1000A.                                                           
C24625 COPY CWS10001.                                                           
      /                                                                         
       PROCEDURE DIVISION USING LS-PCSCA100-COMM-AREA                   
                                WS-BILL-CALC-BG                         
                                WS-SCSCA119-COMM-AREA                   
                                WS-IDR-WORKSHEET                        
C24625                          WS-BILLING-WQ-ITEMS-WF.                 
       0000-MAINLINE.                                                   
I00177     INITIALIZE WS-SQL-ERROR-TXT-WQ.                              
      ** WRITE WORKSHEET IN ASCENDING DATE SEQUENCE                             
           PERFORM VARYING IDR-DAY-INDX                                 
                     FROM WS-IDR-WORKSHEET-ENTRIES BY -1                
                     UNTIL IDR-DAY-INDX < 1                             
T29567        IF WS-IDR-WORKSHEET-ENTRIES > 120                         
C24625           MOVE 16                  TO RETURN-CODE                
C24625           PERFORM 4505-SET-WQ-DETAILS THRU 4505-EXIT             
C24625        END-IF                                                    
              PERFORM VARYING IDR-ENT-INDX FROM 1 BY 1                  
                      UNTIL IDR-ENT-INDX > 24                           
                 INITIALIZE E-FWK05-DATA                                
                 MOVE WS-BC-ACCOUNT-NO-BG TO E-FWK05-ACCOUNT-NO         
                 MOVE WS-WORKSHEET-METER  TO E-FWK05-METER-NO           
                 MOVE WS-PRICING-TYPE-IND TO E-FWK05-REC-TYPE           
                                                                        
                 MOVE WS-IDR-DATE (IDR-DAY-INDX) TO E-FWK05-USAGE-DATE  
                 SET E-FWK05-USAGE-HOUR TO IDR-ENT-INDX                 
                                                                        
                 MOVE WS-IDR-SEASON (IDR-DAY-INDX)                      
                    TO E-FWK05-SEASON-CODE                              
                 MOVE WS-IDR-BASELINE-KWH (IDR-DAY-INDX IDR-ENT-INDX)   
                   TO E-FWK05-BASELINE-LOAD                             
                 MOVE WS-IDR-INTERVAL-PRICE (IDR-DAY-INDX IDR-ENT-INDX) 
                   TO E-FWK05-RATE-1                                    
                 MOVE WS-IDR-TIME-OF-USE (IDR-DAY-INDX IDR-ENT-INDX 1)  
                   TO E-FWK05-TOU-CODE                                  
                                                                        
                 PERFORM VARYING IDR-INTV-INDX FROM 1 BY 1              
                         UNTIL IDR-INTV-INDX > 4                        
                    SET WK05-INTV TO IDR-INTV-INDX                      
                    MOVE WS-IDR-INT-TYPE                                
                          (IDR-DAY-INDX IDR-ENT-INDX IDR-INTV-INDX)     
                      TO E-FWK05-LOAD-TYPE-CD (WK05-INTV)               
                    MOVE WS-IDR-KW-UNITS                                
                          (IDR-DAY-INDX IDR-ENT-INDX IDR-INTV-INDX)     
                      TO E-FWK05-KW-UNITS (WK05-INTV)                   
                    COMPUTE E-FWK05-KWH-UNITS (WK05-INTV) ROUNDED       
                       = WS-IDR-KWH-UNITS                               
                          (IDR-DAY-INDX IDR-ENT-INDX IDR-INTV-INDX)     
                    MOVE WS-IDR-KVA-UNITS                               
                          (IDR-DAY-INDX IDR-ENT-INDX IDR-INTV-INDX)     
                      TO E-FWK05-KVA-UNITS (WK05-INTV)                  
                    MOVE WS-IDR-KVAR-UNITS                              
                          (IDR-DAY-INDX IDR-ENT-INDX IDR-INTV-INDX)     
                      TO E-FWK05-KVAR-UNITS (WK05-INTV)                 
                 END-PERFORM                                            
                 PERFORM 8300-WRITE-WK05 THRU 8300-EXIT                 
              END-PERFORM                                               
           END-PERFORM                                                  
                                                                        
           EXIT PROGRAM                                                 
           .                                                            
       4500-EXIT.                                                       
           EXIT.                                                        
                                                                        
C24625 4505-SET-WQ-DETAILS.                                             
C24625     IF LS-CURR-WQ-ITEM = 50                                      
C24625        DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
C24625        DISPLAY 'PROCESSING CONTINUING'                           
C24625        PERFORM 9999-BAIL-OUT THRU 9999-EXIT                      
C24625     ELSE                                                         
C24625        ADD 1                           TO LS-CURR-WQ-ITEM        
C24625        SET WS-BILL-WQ-INDX             TO LS-CURR-WQ-ITEM        
C24625        MOVE WS-TABLE-INDEX-MSG         TO                        
C24625                  WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)   
C24625        MOVE WS-REJECT                  TO WS-EXCEPTION-CODE-WQ   
C24625        MOVE WS-BC-BILL-NO-BG           TO WS-BILL-NO-WQ          
C24625        MOVE WS-BC-CODE-UTIL-TYPE-BG    TO WS-CODE-UTIL-TYPE-WQ   
C24625        MOVE WS-BC-RATE-PLAN-NO-BG      TO WS-RATE-PLAN-NO-WQ     
C24625        MOVE WS-BC-IC-NO-BG             TO WS-IC-NO-WQ            
C24625        COMPUTE WS-START-POS                                      
C24625           = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1             
C24625        MOVE WS-SUPPLEMENTAL-TXT-WQ     TO                        
C24625           WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)  
C24625        ADD WS-SUPPLEMENTAL-TXT-LEN-WQ  TO                        
C24625                    WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX)          
ACT068        MOVE WS-PGRMNAME                TO                        
ACT068             WS-CREATED-BY-WF (WS-BILL-WQ-INDX)                   
C24625        PERFORM 9999-BAIL-OUT           THRU 9999-EXIT            
C24625     END-IF.                                                      
C24625 4505-EXIT.                                                       
C24625     EXIT.                                                        
      /                                                                         
       8300-WRITE-WK05.                                                 
           WRITE FIOWK05.                                               
                                                                        
           IF FWK05-SUCCESSFUL                                          
              ADD 1 TO LS-FCSWK05-REC-CNTR                              
           ELSE                                                         
              DISPLAY 'WRITE ERROR ON WK05. STATUS = '                  
                      WS-FWK05-STATUS                                   
              MOVE 16 TO RETURN-CODE                                    
              EXIT PROGRAM                                              
           END-IF                                                       
           .                                                            
       8300-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
C24625*                                                                         
C24625 9999-BAIL-OUT.                                                   
C24625     EXIT PROGRAM.                                                
C24625                                                                  
C24625 9999-EXIT.                                                       
C24625     EXIT.                                                        
