       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA117.                                        
      ****************************************************************  00030000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00040000
      **                     PRICE WATERHOUSE                        ** 00050000
      **                                                             ** 00060000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00070000
      **                                                             ** 00080000
      ***************************************************************** 00090000
      **               P R O G R A M  S U M M A R Y                  ** 00100000
      **                                                             ** 00110000
      **   THIS MODULE PROCESSES CREDIT CONTRACTS (REBATES).         ** 00120000
      **   IF A CONTRACT IS ACTIVE, THE MONTHLY CREDIT AMOUNT WILL   ** 00130000
      **   BE APPLIED AS PAYMENT.  CPD00010 WILL POST THE CREDIT     ** 00140000
      **   AND JOURNAL THE TRANSACTION.                              ** 00150000
      **                                                             ** 00160000
      ***************************************************************** 00170000
      **                                                             ** 00180000
      **              PROGRAM  MODIFICATION  LOG                     ** 00190000
      **                                                             ** 00200000
      **    DATE    INITIALS  REASON                                 ** 00210000
      **  ________  ________  ______                                 ** 00220000
      **   3/14/95     HC     INITIAL PROGRAM VERSION                ** 00230000
      **                      MODULE RUNS BEFORE SCSCA102            ** 00240000
      **   3/21/95     HC     MODULE RUNS AFTER SCSCA102             ** 00250000
      **   6/20/96     CSG    ADDED TBPRJSHR.                        ** 00260000
      **   9/17/96     CSG    ADD PROJECT SHARE WORKING STORAGE TO   ** 00270000
      **                      LINKAGE.                               ** 00280000
PCR294**   09/22/96    CDS    PCR294 REMOVED WS-MONTHLY-CREDIT FRM WS** 00290000
PCR072**   09/26/96    CDS    PCR072 ADDED COPY OF CJF00105 FOR JRNL ** 00300000
PCR072**   10/01/96    PD     PCR072 REMOVED CODE FOR CIAC.          ** 00310000
PCR072**   10/25/96    PD     ADDED COPYBOOK FOR CPD10.              ** 00320000
T11144**   05/19/97    CSG    MAKE PROGRAM WORK USING CPD00010       ** 00330000
      **                      CORRECTLY.                             ** 00340000
T11784**   06/23/97    CSG    APPLY CREDIT IF MORE THAN 1 CONTRACT   ** 00350000
      **                      EXISTS WITHOUT BOMBING.                ** 00360000
T13536**   11/13/97    CSG    INCREASE SIZE OF WK03 HOLD AREA.       ** 00370000
C23235**   07/14/01    MDJ    ADDED DCLGEN TBUTLENV FOR CPD0010B.    ** 00380000
C26130**   06/12/02   SRIDEVI ADDED DCLGEN TBMNHIST & TBMNHDT FOR    ** 00390000
C26130**                      CPD0010B.                              ** 00400000
T27925**   03/19/03  COVANSYS CHANGED FILEDS DEFINED AS 9(07)        ** 00410000
      **                      TO 9(11).                              ** 00420000
T37302**   06/17/08   MR97640 DELETE DCLGEN TBCIAC                   ** 00430000
P00097**   01/27/09   SS97726 INCREASE WS-CNT-INDX FROM 20 TO 50 AND ** 00440000
P00097**                      REMOVE RELAETED IDX HARD CODING        ** 00450000
A03730**   09/15/09   MN90523 REMOVED DATA ITEMS RELATED TO TABLE RA ** 00451000
A05460**   05/03/16   MC95456 REMOVED DCLGEN FOR CSS_WQ_ITEMS_MF.    ** 00451100
ACT284*    09/29/16  VIJAY    SET INDEXES TO 1 TO AVOID EXCEPTIONS IN   00451200
ACT284*    A05460             MFES ENVIRONMENT.                         00451300
ACT278*    11/16/16  TP7R341  REMOVE UNWANTED COLUMN FROM CONTRACT   ** 00451400
ACT278*     A05460            DETAIL TABLE                           ** 00451500
      ***************************************************************** 00460000
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00470000
      **                                                             ** 00480000
      **  0000         MODULE CONTROL                                ** 00490000
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00500000
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00510000
      **  2000 - 4999  DETAIL LOGIC                                  ** 00520000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00530000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00540000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00550000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00560000
      **                                                             ** 00570000
      ***************************************************************** 00580000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
                                                                        
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA117'.
MSQ017     COPY MFASQLM.
       01  WS-START                   PIC X(40)                         
           VALUE 'WORKING STORAGE FOR SCSCA117 STARTS HERE'.            
                                                                        
       COPY FIOWK03.                                                    00670000
      /*****************************************************************00680000
      *   TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS      *00690000
      *   (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM      *00700000
      *   WILL ALWAYS BE SQLCA.                                        *00710000
      ******************************************************************00720000
      /***** SQL COMMUNICATIONS AREA                                    00730000
           EXEC SQL                                                     00740000
               INCLUDE SQLCA                                            00750000
           END-EXEC.                                                    00760000
      /***** CSS_CONTRACT                                               00770000
           EXEC SQL                                                     00780000
               INCLUDE TBCNTRCT                                         00790000
           END-EXEC.                                                    00800000
      /***** CSS_CONTRACT_INFO                                          00810000
           EXEC SQL                                                     00820000
               INCLUDE TBCNTINF                                         00830000
           END-EXEC.                                                    00840000
T11144/***** CSS_CNT_DETAIL                                             00850000
T11144     EXEC SQL                                                     00860000
T11144         INCLUDE TBCNTDET                                         00870000
T11144     END-EXEC.                                                    00880000
      /***** CSS_ACCOUNT                                                00890000
           EXEC SQL                                                     00900000
               INCLUDE TBACCT                                           00910000
           END-EXEC.                                                    00920000
      /***** CSS_PREMISE                                                00930000
           EXEC SQL                                                     00940000
               INCLUDE TBPREM                                           00950000
           END-EXEC.                                                    00960000
      /***** CSS_CUSTOMER                                               00970000
           EXEC SQL                                                     00980000
               INCLUDE TBCUST                                           00990000
           END-EXEC.                                                    01000000
      /***** CSS_DEP_PAY_HST                                            01010000
           EXEC SQL                                                     01020000
               INCLUDE TBDEPHST                                         01030000
           END-EXEC.                                                    01040000
      /***** CSS_AR_CNTL                                                01050000
           EXEC SQL                                                     01060000
               INCLUDE TBARCNTL                                         01070000
           END-EXEC.                                                    01080000
      /***** CSS_AR_TRANS_HIST                                          01090000
           EXEC SQL                                                     01100000
               INCLUDE TBARHIST                                         01110000
           END-EXEC.                                                    01120000
      /***** CSS_AR_TRN_HST_DET                                         01130000
           EXEC SQL                                                     01140000
               INCLUDE TBARHDT                                          01150000
           END-EXEC.                                                    01160000
      /***** CSS_BATCH_JRNL                                             01170000
           EXEC SQL                                                     01180000
               INCLUDE TBBTJRNL                                         01190000
           END-EXEC.                                                    01200000
      /***** CSS_CSH_DRWR_JRNL                                          01210000
           EXEC SQL                                                     01220000
               INCLUDE TBCDJRNL                                         01230000
           END-EXEC.                                                    01240000
      /***** CSS_MISC_JRNL                                              01250000
           EXEC SQL                                                     01260000
               INCLUDE TBMSJRNL                                         01270000
           END-EXEC.                                                    01280000
      /***** CSS_BCH_JRNL_CNTL                                          01290000
           EXEC SQL                                                     01300000
               INCLUDE TBBJCNTL                                         01310000
           END-EXEC.                                                    01320000
      /***** CSS_CSH_DRWR_CNTL                                          01330000
           EXEC SQL                                                     01340000
               INCLUDE TBCDCNTL                                         01350000
           END-EXEC.                                                    01360000
      /***** CSS_MODEL_SQL                                              01370000
           EXEC SQL                                                     01380000
               INCLUDE TBMODEL                                          01390000
           END-EXEC.                                                    01400000
      /***** CSS_RESP_AREA                                              01410000
           EXEC SQL                                                     01420000
               INCLUDE TBRSAREA                                         01430000
           END-EXEC.                                                    01440000
      /***** CSS_AR_PMT_PRTY                                            01450000
           EXEC SQL                                                     01460000
               INCLUDE TBARPMT                                          01470000
           END-EXEC.                                                    01480000
      /***** CSS_DFA_ACCT                                               01490000
           EXEC SQL                                                     01500000
               INCLUDE TBDFAACT                                         01510000
           END-EXEC.                                                    01520000
      /***** CSS_CHARGE_OFF                                             01530000
           EXEC SQL                                                     01540000
               INCLUDE TBCHGOFF                                         01550000
           END-EXEC.                                                    01560000
      /***** CSS_CRED_COLL                                              01570000
           EXEC SQL                                                     01580000
               INCLUDE TBCRCOLL                                         01590000
           END-EXEC.                                                    01600000
      /***** CSS_RECONNECT                                              01610000
           EXEC SQL                                                     01620000
               INCLUDE TBRECNCT                                         01630000
           END-EXEC.                                                    01640000
      /***** CSS_DFA_RECVBL                                             01650000
           EXEC SQL                                                     01660000
               INCLUDE TBDFARCV                                         01670000
           END-EXEC.                                                    01680000
      /***** CSS_USER_PROFILE                                           01730000
           EXEC SQL                                                     01740000
               INCLUDE TBUSRPRF                                         01750000
           END-EXEC.                                                    01760000
      /***** CSS_DEP_ON_HAND                                            01770000
           EXEC SQL                                                     01780000
               INCLUDE TBDEPHND                                         01790000
           END-EXEC.                                                    01800000
      /***** CSS_BUDGET_PLAN                                            01810000
           EXEC SQL                                                     01820000
               INCLUDE TBBGTPLN                                         01830000
           END-EXEC.                                                    01840000
      /***** CSS_BUDGET_HIST                                            01890000
           EXEC SQL                                                     01900000
               INCLUDE TBBGTHST                                         01910000
           END-EXEC.                                                    01920000
      /***** CSS_CREDIT_PROFILE                                         01930000
           EXEC SQL                                                     01940000
               INCLUDE TBCRPROF                                         01950000
           END-EXEC.                                                    01960000
      /***** CSS_NSF_HIST                                               01970000
           EXEC SQL                                                     01980000
               INCLUDE TBNSFHST                                         01990000
           END-EXEC.                                                    02000000
      /***** CSS_LIEAP                                                  02010000
           EXEC SQL                                                     02020000
               INCLUDE TBLIEAP                                          02030000
           END-EXEC.                                                    02040000
C26130/***** CSS_MNT_TRANS_HIST                                         02050000
C26130     EXEC SQL                                                     02060000
C26130        INCLUDE TBMNHIST                                          02070000
C26130     END-EXEC.                                                    02080000
C26130/***** CSS_MT_TRN_HST_DET                                         02090000
C26130     EXEC SQL                                                     02100000
C26130        INCLUDE TBMNHDT                                           02110000
C26130     END-EXEC.                                                    02120000
TP3228/***** CSS_PROJ_SHARE                                             02130000
TP3228     EXEC SQL                                                     02140000
TP3228         INCLUDE TBPRJSHR                                         02150000
TP3228     END-EXEC.                                                    02160000
PCR072******************************************************************02170000
PCR072*    CSS_DELINQUENCY                                              02180000
PCR072******************************************************************02190000
PCR072                                                                  
PCR072     EXEC SQL                                                     02210000
PCR072         INCLUDE TBDELQ                                           02220000
PCR072     END-EXEC.                                                    02230000
HPCCDM*EJECT                                                            02240000
PCR072******************************************************************02250000
PCR072*    CSS_CONNECT_CHRG                                             02260000
PCR072******************************************************************02270000
PCR072                                                                  
PCR072     EXEC SQL                                                     02290000
PCR072         INCLUDE TBCCCHRG                                         02300000
PCR072     END-EXEC.                                                    02310000
HPCCDM*EJECT                                                            02320000
PCR072******************************************************************02330000
PCR072*    CSS_RECONNECT_CHRG                                           02340000
PCR072******************************************************************02350000
PCR072                                                                  
PCR072     EXEC SQL                                                     02370000
PCR072         INCLUDE TBRCNCHR                                         02380000
PCR072     END-EXEC.                                                    02390000
HPCCDM*EJECT                                                            02400000
PCR072******************************************************************02410000
PCR072*    CSS_LOCAL_OFFICE                                             02420000
PCR072******************************************************************02430000
PCR072                                                                  
PCR072     EXEC SQL                                                     02450000
PCR072         INCLUDE TBLOCOFC                                         02460000
PCR072     END-EXEC.                                                    02470000
C23235*************************************************************     02480000
C23235* DCLGEN FOR CSS_UTIL_ENVRNMT                               *     02490000
C23235*************************************************************     02500000
C23235                                                                  
C23235     EXEC SQL                                                     02520000
C23235         INCLUDE TBUTLENV                                         02530000
C23235     END-EXEC.                                                    02540000
C23235*                                                                 02550000
HPCCDM*EJECT                                                            02560000
                                                                        
      /                                                                 02580000
      *01  WS-WORK-VARIABLES.                                           02590000
      **     THE WORK VARIABLE AREA IS USED FOR TRANSIENT DATA. IT   ** 02600000
      **     IS INITIALIZED ON EACH CALL TO THE SUBROUTINE.          ** 02610000
      **     THE OTHER WORK AREAS ARE INITIALIZED UNDER PROGRAM      ** 02620000
      **     CONTROL.  ADD ANY NEW DATA FIELDS ACCORDINGLY.          ** 02630000
      **                                                             ** 02640000
      /**************************************************************** 02650000
      **                                                             ** 02660000
       01  WS-CONSTANTS.                                                
           05  WS-A                        PIC X(1)    VALUE 'A'.       
           05  WS-C                        PIC X(1)    VALUE 'C'.       
           05  WS-ADJUST                   PIC X(1)    VALUE 'A'.       
           05  WS-APPROVED                 PIC X(1)    VALUE 'B'.       
           05  WS-BAT                      PIC X(03)   VALUE 'BAT'.     
           05  WS-BATCH                    PIC X(1)    VALUE 'B'.       
           05  WS-BILLING                  PIC X(1)    VALUE 'C'.       
FCS   *    05  WS-CASH-DRAWER-ID           PIC X(1)    VALUE 'A'.       02750000
FCS        05  WS-CASH-DRAWER.                                          
FCS          10  WS-CD-COMPANY-NO          PIC X(2).                    
FCS          10  WS-CD-LOCAL-OFFICE        PIC X(03).                   
FCS          10  WS-CD-REPORT-NO           PIC X(03).                   
FCS          10  WS-CD-REPORT-DATE         PIC X(10).                   
FCS          10  WS-CASH-DRAWER-ID         PIC S9(04) COMP.             
           05  WS-INDIRECT-JRNL            PIC X(1)    VALUE 'A'.       
           05  WS-NO                       PIC X(1)    VALUE 'N'.       
           05  WS-PGRMNAME                 PIC X(08)   VALUE 'SCSCA117'.
           05  WS-REFUND                   PIC X(04)   VALUE 'RFND'.    
T11144     05  WS-BILL                     PIC X(04)   VALUE 'BILL'.    
           05  WS-SYSTEM                   PIC X(07)   VALUE 'SYSTEM '. 
           05  WS-YES                      PIC X(1)    VALUE 'Y'.       
           05  WS-101                      PIC S9(05)  COMP-3           
                                                       VALUE +00101.    
      *                                                                 02910000
       01  WS-COUNTERS.                                                 
           05  WS-START-POS                PIC S9(04)  COMP VALUE ZERO. 
           05  WS-CURRENT-WQ-ITEM          PIC S9(04)  COMP VALUE ZERO. 
      *                                                                 02950000
       01  WS-FLAGS.                                                    
           05  WS-FLAG                     PIC X(01) VALUE 'N'.         
      *                                                                 02980000
       01  WS-TEMP-VARIABLES.                                           
T27925     05  WS-DETAIL-END-BAL           PIC S9(11)V99  VALUE ZERO.   
T27925     05  WS-DETAIL-END-AR-BAL        PIC S9(11)V99  VALUE ZERO.   
           05  WS-CURRENT-DATE             PIC X(10).                   
           05  WS-CURRENT-TIMESTAMP        PIC X(26).                   
           05  WS-TEMP-DT                  PIC X(10).                   
           05  WS-TEMP-TIMESTAMP           PIC X(29).                   
           05  WS-DATE-ORIG-PYMT-IND       PIC S9(4) COMP.              
           05  RS-RETURN-CODE              PIC S9(4) COMP.              
T11784     05  WS-HOLD-CNT-INDX            PIC S9(4) COMP.              
      *                                                                 03090000
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-1               PIC S9(04) COMP.             
      *                                                                 03120000
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                PIC X(08) VALUE 'SCSCA117'.  
T11144     05  WS-WRITE-WK03               PIC X(01) VALUE 'Y'.         
      *                                                                 03160000
      /**************************************************************** 03170000
      **     PUT ANY PROGRAM SWITCH VARIABLES YOU NEED HERE.  IF     ** 03180000
      **     POSSIBLE, INCLUDE AT LEAST TWO CONDITION NAMES. IN THE  ** 03190000
      **     PROCEDURE DIVISION, USE "SET CONDITION-NAME TO TRUE"    ** 03200000
      **     RATHER THAN "MOVE 'Y' TO INDICATOR-VARIABLE-NAME"       ** 03210000
      **                                                             ** 03220000
       01  WS-SWITCHES-AND-INDICATORS.                                  
           05  WS-EXCEPTION-INDICATOR      PIC X(1).                    
               88  NO-EXCEPTIONS           VALUE '0'.                   
               88  EXCEPTION-ENCOUNTERED   VALUE '1'.                   
           05  WS-NO-MORE-DATA       PIC X(01) VALUE 'N'.               
               88  NO-MORE-DATA                VALUE 'Y'.               
                                                                        
      /**************************************************************** 03300000
      **     WORKING STORAGE FOR WQ MESSAGES PERTAINING TO           ** 03310000
      **     SQL ERRORS AND OTHER PROGRAM PROBLEMS.                  ** 03320000
      **                                                             ** 03330000
      ***************************************************************** 03340000
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER                  PIC S9(04)  COMP.            
               10  FILLER                  PIC X(01)   VALUE 'N'.       
               10  FILLER                  PIC X(01)   VALUE '4'.       
               10  FILLER                  PIC S9(04)  COMP VALUE +29.  
               10  FILLER                  PIC X(30)   VALUE            
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-PAYMENT-APPL-ERROR.                                   
               10  FILLER                  PIC S9(04)  COMP.            
               10  FILLER                  PIC X(01)   VALUE 'N'.       
               10  FILLER                  PIC X(01)   VALUE '4'.       
               10  FILLER                  PIC S9(04)  COMP VALUE +29.  
               10  FILLER                  PIC X(25)   VALUE            
                   'PAYMENT PROCESSING ERROR'.                          
               10  WS-PMT-ERROR-CODE       PIC X(4).                    
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  FILLER                  PIC S9(04)  COMP.            
               10  FILLER                  PIC X(01)   VALUE 'N'.       
               10  FILLER                  PIC X(01)   VALUE '4'.       
               10  WS-MISC-MSG-LEN         PIC S9(04)  COMP VALUE +60.  
               10  WS-MISC-MSG-TEXT        PIC X(60).                   
                                                                        
      /*****************************************************************03580000
      *                                                                *03590000
      *  WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS              *03600000
      *                                                                *03610000
      ******************************************************************03620000
      /*****   SQL WORK VARIABLES                                       03630000
       COPY CWS00303.                                                   03640000
                                                                        
      /*****   WQ WORKING STORAGE                                       03660000
       COPY CWS0070B.                                                   03670000
                                                                        
      /*****                                                            03690000
       COPY CWS00027.                                                   03700000
                                                                        
      /*****                                                            03720000
       COPY CWS00010.                                                   03730000
                                                                        
      /*****  WORKING STORAGE FOR CODES-DATA-PRESENT                    03750000
       COPY CWS00056.                                                   03760000
                                                                        
      /***** WORKING STORAGE FOR PAYMENT JOURNAL                        03780000
       COPY CJF00101.                                                   03790000
                                                                        
      /***** WORKING STORAGE FOR JOURNAL                                03810000
       COPY CJF00102.                                                   03820000
                                                                        
PCR072/***** WORKING STORAGE FOR JOURNAL                                03840000
PCR072 COPY CJF00105.                                                   03850000
PCR072                                                                  
      /*****                                                            03870000
           EXEC SQL                                                     03880000
               INCLUDE CWS00013                                         03890000
           END-EXEC.                                                    03900000
                                                                        
      /*****                                                            03920000
           EXEC SQL                                                     03930000
               INCLUDE CWS00073                                         03940000
           END-EXEC.                                                    03950000
                                                                        
      /*****                                                            03970000
           EXEC SQL                                                     03980000
               INCLUDE CWS00017                                         03990000
           END-EXEC.                                                    04000000
                                                                        
      /*****                                                            04020000
           EXEC SQL                                                     04030000
               INCLUDE CWS00004                                         04040000
           END-EXEC.                                                    04050000
                                                                        
      /*****                                                            04070000
           EXEC SQL                                                     04080000
               INCLUDE CWS00008                                         04090000
           END-EXEC.                                                    04100000
                                                                        
      /*****                                                            04120000
           EXEC SQL                                                     04130000
               INCLUDE CWS00007                                         04140000
           END-EXEC.                                                    04150000
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR SCSCA117 START HERE '.               
                                                                        
       LINKAGE SECTION.                                                 
      /*****   LS-PCSCA100-COMM-AREA                                    04210000
           EXEC SQL                                                     04220000
               INCLUDE CWS0024B                                         04230000
           END-EXEC.                                                    04240000
      /*****   BILL EXTRACT (BE00)                                      04250000
           EXEC SQL                                                     04260000
               INCLUDE CWS1000A                                         04270000
           END-EXEC.                                                    04280000
           EXEC SQL                                                     04290000
               INCLUDE CWS1000B                                         04300000
           END-EXEC.                                                    04310000
      /*****   ACCOUNTS FILE (DB07)                                     04320000
           COPY FIODB07.                                                04330000
      /*****   WORKING STORAGE FOR G/L MNEMONICS                        04340000
           COPY CWS00061.                                               04350000
       01  WS-HOLD-WK03.                                                
COB305     03 WS-WK03-TOTAL-AR-BAL        PIC S9(9)V99 COMP-3 VALUE 0.        
           03  WS-WK03-COUNT                PIC S9(4) COMP.             
           03  WS-HOLD-WK03-DATA            PIC X(220)                  
T13536            OCCURS 5000 TIMES                                     
                  INDEXED BY WK03-INDX.                                 
                                                                        
      /                                                                 04430000
       PROCEDURE DIVISION USING LS-PCSCA100-COMM-AREA                   
                                WS-BILLING-WQ-ITEMS-WF                  
                                WS-GL-NAME-INFO                         
                                WS-GL-ACCT-NO-TABLE                     
                                WS-GL-ACCT-MAJOR-FIELDS                 
                                WS-PREMISE-PR                           
                                WS-CUSTOMER-CU                          
                                WS-ACCOUNT-AT                           
                                WS-CONTRACT-CT                          
                                WS-CHRG-OFF-CO                          
                                WS-AR-CNTRL-AC                          
                                WS-DFA-ACCT-DA                          
                                WS-DFA-RECV-DV                          
PCR072*                         WS-CIAC-CI                              04570000
                                WS-DEP-ON-HAND-DO                       
T5499                           WS-PROJECT-SHARE-PJ                     
                                WS-HOLD-WK03                            
P00097                          WS-CWS1000B-MAX-TBL-LIMITS.             
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04630000
      **                                                              **04640000
      **    0000-MAINLINE                                             **04650000
      **                                                              **04660000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04670000
       0000-MAINLINE.                                                   
      *                                                                 04690000
ACT284     SET WS-GL-SUB  TO 1                                          
T11144     INITIALIZE CJF00101.                                         
I00177     INITIALIZE WS-100-USER-DEFINED-AREA                          
I00177                WS-SQL-ERROR-TXT-WQ.                              
           MOVE ZERO TO RETURN-CODE.                                    
      *                                                                 04740000
           MOVE WS-ACCOUNT-NO-AT  TO AT-ACCOUNT-NO                      
T11144                               AU-ACCOUNT-NO                      
T11144                               WS-100-ACCT-NO                     
                                     AC-ACCOUNT-NO.                     
                                                                        
T11144     MOVE LS-INPUT-DATE     TO WS-CURRENT-DATE.                   
                                                                        
      ***  SETUP FOR PAR ROUTINE                                        04820000
                                                                        
           MOVE WS-LOCAL-OFFICE-AT TO WS-PAR-ACCESS-LOC                 
T11144                                WS-PAR-LOCAL-OFFICE               
T11144                                WS-CD-LOCAL-OFFICE                
T11144                                AT-LOCAL-OFFICE.                  
           MOVE WS-COMPANY-NO-AT   TO WS-100-COMPANY-NO                 
T11144                                WS-PAR-COMPANY-NO                 
T11144                                AT-COMPANY-NO.                    
T11144     MOVE WS-CUSTOMER-NO-AT  TO AT-CUSTOMER-NO.                   
=====>     MOVE 'XXXXXXXX'      TO WS-PAR-OPERATOR-ID.                  
                                                                        
T11144     MOVE WS-REV-DISTRICT-CD-PR TO PR-REV-DISTRICT-CD.            
                                                                        
           MOVE SPACES       TO WS-JRNL-OL-PERM-ID                      
                                WS-PAR-PYMT-FACILITY-CD                 
                                WS-PAR-EIBTRNID                         
                                WS-PAR-APPL-PROG-ID.                    
           MOVE ZEROS        TO WS-PAR-TYPE                             
                                WS-PAR-TYPE-NO                          
                                WS-PAR-TRAN-APPL-NO                     
                                WS-100-JRNL-TRAN-APPL-NO                
                                AU-TRAN-APPL-NO.                        
           MOVE 'B'          TO WS-PAR-CODE-SOURCE.                     
           MOVE 'N'          TO WS-IS-THIS-DIRECTED-PYMT.               
      *    WS-PAR-CODE-TRAN-TYPE = 'P' SETS THE AT-LAST-PYMT-AMOUNT     05070000
T11144*    MOVE 'P'          TO WS-PAR-CODE-TRAN-TYPE.                  05080000
                                                                        
T11144     MOVE WS-CURRENT-DATE TO WS-CD-REPORT-DATE                    
T11144                             WS-PAR-REPORT-DATE.                  
T11144     MOVE WS-CASH-DRAWER-ID TO WS-PAR-CASH-DRAWER.                
      *                                                                 05130000
T11784     PERFORM VARYING WS-HOLD-CNT-INDX FROM 1 BY 1                 
P00097             UNTIL WS-HOLD-CNT-INDX > WS-CT-MAX-ENTRY             
T11784*               OR WS-ACCOUNT-NO-CT (WS-CNT-INDX) = ZERO          05160000
T11784        SET WS-CNT-INDX TO WS-HOLD-CNT-INDX                       
              IF WS-CODE-BILL-TYPE-CT (WS-CNT-INDX)                     
                                = WS-MONTHLY-CREDIT                     
T11784             AND WS-ACCOUNT-NO-CT (WS-CNT-INDX) > ZERO            
                   AND WS-CNT-STATUS-CD-CT (WS-CNT-INDX) = WS-APPROVED  
                 PERFORM 5050-APPLY-AS-PAYMENT  THRU 5050-EXIT          
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                 05250000
           EXIT PROGRAM.                                                
                                                                        
      *                                                                 05280000
       5050-APPLY-AS-PAYMENT.                                           
      ** THIS IS A NON-DIRECTED PYMT. WS-PAYMENT-AMOUNT AND             05300000
      ** WS-PAYMENT-AMOUNT-TOTAL ARE THE SAME.                          05310000
      ** PAYMENT TYPE IS CASH                                           05320000
           MOVE WS-AMT-MO-PYMT-CT (WS-CNT-INDX)                         
             TO WS-PAYMENT-AMOUNT-TOTAL                                 
                WS-AMT-CASH                                             
                WS-PAYMENT-AMOUNT                                       
T11144          AU-AMT-POSTED                                           
T11144          WS-PAR-AMT-POSTED                                       
                                                                        
T11144     MOVE WS-ACCOUNT-NO-CT (WS-CNT-INDX) TO CT-ACCOUNT-NO.        
T11144     MOVE WS-CNT-ITEM-ID-CT (WS-CNT-INDX) TO CT-CNT-ITEM-ID.      
           PERFORM 7030-GET-CONTRACT-INFO THRU 7030-EXIT.               
T11144     MOVE EA-GL-ACCT-NO        TO WS-PAR-GEN-LEDG-DB              
T11144                                  WS-101-ACCT-GEN-LED-DR          
                                                                        
T11144     MOVE WS-PAR-B                TO WS-PAR-UPDATE-TYPE           
                                                                        
T11144     MOVE 'N' TO WS-IS-THIS-DIRECTED-PYMT.                        
           PERFORM 6700-APPLY-PAYMENT      THRU 6700-EXIT.              
                                                                        
           IF NOT PYMT-WAS-SUCCESSFUL                                   
               PERFORM 5200-PYMT-APPL-ERR  THRU 5200-EXIT               
           END-IF.                                                      
       5050-EXIT.                                                       
           EXIT.                                                        
       5200-PYMT-APPL-ERR.                                              
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
           END-IF.                                                      
                                                                        
           MOVE WS-PAR-MESSAGE-NO TO WS-PMT-ERROR-CODE                  
           MOVE WS-PAYMENT-APPL-ERROR                                   
             TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)           
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       5200-EXIT.                                                       
           EXIT.                                                        
      /***** 6100 SERIES - COMPUTE REBATE AMOUNT                        05720000
           EXEC SQL                                                     05730000
               INCLUDE CPD0003B                                         05740000
           END-EXEC.                                                    05750000
                                                                        
      /***** 6400 SERIES - BATCH JOURNAL ROUTINE                        05770000
      ****** CPD00007 IS NOT USED FOR THIS PROGRAM!!!                   05780000
                                                                        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05800000
      **    6400-ONLINE-JRNL-ROUTINE.                                 **05810000
      **                                                              **05820000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05830000
       6400-ONLINE-JRNL-ROUTINE.                                        
      ** ALL 101 FIELDS ARE SET IN CPD00010                             05850000
T11144     MOVE WS-PAR-AMT-POSTED   TO AR-AMT-ORIG-ENTERED              
T11144                                 AU-AMT-POSTED.                   
           MOVE AU-AMT-POSTED       TO E-FWK03-RCV-DEBIT-AMT            
                                       E-FWK03-GEN-LEG-CREDIT-AMT.      
           MOVE ZEROS               TO E-FWK03-RCV-CREDIT-AMT           
                                       E-FWK03-GEN-LEG-DEBIT-AMT.       
           MOVE ZERO                TO WS-DETAIL-END-BAL                
                                       WS-DETAIL-END-AR-BAL.            
T11144     INITIALIZE CJF00101.                                         
T11144     MOVE WS-AR-CNT-GL-NO (WS-GL-SUB) TO                          
T11144                                 WS-101-ACCT-GEN-LED-CR           
T11144                                 AU-GL-ACCT-CREDIT.               
T11144     PERFORM 6420-CREATE-101-JRNL   THRU 6420-EXIT.               
                                                                        
       6400-EXIT.                                                       
           EXIT.                                                        
                                                                        
T11144 6420-CREATE-101-JRNL.                                            
           MOVE WS-BAT                  TO AR-RESP-AREA-ID.             
           MOVE WS-PGRMNAME             TO AR-APPL-PROGRAM-ID.          
           MOVE WS-SYSTEM               TO AR-USER-ID.                  
           MOVE ZEROS                   TO AU-CURRENCY-AMT.             
           MOVE SPACES                  TO AR-PYMT-FACILITY-CD          
                                           AR-RECORD-ONLY-FL            
                                           AU-CODE-CONTRACT-TYPE        
                                           AU-CURRENCY-TYPE.            
           MOVE WS-101                  TO WS-101-JRNL-FORMAT-NO.       
FCS        MOVE SPACES                  TO WS-101-CASH-DRAWER-USED.     
           MOVE AR-AMT-ORIG-ENTERED     TO WS-101-AMOUNT-ENTERED        
           MOVE AU-AMT-POSTED           TO WS-101-AMT-POSTED            
           MOVE 'P'                     TO WS-101-AR-AGE.               
           MOVE LS-INPUT-DATE           TO WS-101-DATE-AR-BILLED.       
           MOVE AU-ITEM-ID              TO WS-101-ITEM-ID-NO            
           MOVE WS-DETAIL-END-BAL       TO WS-101-DETAIL-END-BAL        
           MOVE WS-DETAIL-END-AR-BAL    TO WS-101-DETAIL-END-AR-BAL     
           MOVE WS-TOTAL-AR-BALANCE-AT  TO WS-101-ACCT-END-AR-BAL       
                                           AR-AMT-BILLED-UNPAID.        
           MOVE WS-REV-DISTRICT-CD-PR   TO WS-101-CODE-REVENUE-DISTRICT.
PAL        MOVE LS-CURR-REVENUE-MONTH   TO WS-101-REVENUE-MONTH         
           MOVE WS-CODE-EMPL-ACCT-CU    TO WS-101-CODE-EMPL-ACCT.       
           MOVE WS-CODE-COMPANY-ACCT-AT TO WS-101-CODE-COMPANY-ACCT.    
           MOVE WS-CODE-ACCT-STAT-AT    TO WS-101-CODE-ACCOUNT-STATUS.  
           MOVE WS-CODE-PREMISE-STAT-PR TO WS-101-CODE-PREMISE-STATUS.  
           MOVE WS-INDIRECT-JRNL        TO E-FWK03-JRNL-SORT-ID.        
           MOVE AT-ACCOUNT-NO           TO E-FWK03-ACCT-NO.             
           MOVE WS-LOCAL-OFFICE-AT      TO E-FWK03-LOCAL-OFFICE         
   FCS                                     AR-CASH-LOCAL-OFFICE.        
   FCS     MOVE WS-COMPANY-NO-AT        TO E-FWK03-COMPANY-NO           
   FCS                                     AR-COMPANY-NO.               
   FCS     MOVE WS-CD-REPORT-NO         TO AR-CASH-REPORT-NO.           
   FCS     MOVE WS-CASH-DRAWER-ID       TO AR-CASH-DRAWER-ID.           
           MOVE WS-CUSTOMER-NO-AT       TO E-FWK03-CUSTOMER-NO.         
T11144     MOVE WS-BILL                 TO E-FWK03-CODE-TERMINAL-TRAN.  
T11144*    MOVE WS-REFUND               TO  E-FWK03-CODE-TERMINAL-TRAN. 06390000
           MOVE 1                       TO E-FWK03-JRNL-TRAN-APPL-NO    
                                           AU-TRAN-APPL-NO.             
           MOVE LS-INPUT-DATE           TO WS-DATE-LAST-ACTION-AT       
                                           AR-DATE-TRANS                
                                           E-FWK03-DATE-LAST-ACTION.    
           MOVE SPACES                  TO E-FWK03-TRAN-ERRORS.         
           MOVE 'B'                     TO E-FWK03-CODE-ENTRY-SOURCE.   
           MOVE WS-ADJUST               TO AR-CODE-TRAN-TYPE.           
PAL          MOVE WS-100-USER-DEFINED-AREA  TO CJF00101                 
             IF WS-101-ACCT-GEN-LED-CR   NOT NUMERIC                    
             AND  WS-101-ACCT-GEN-LED-DR NOT NUMERIC                    
             AND  WS-101-AMT-POSTED      NOT NUMERIC                    
                  MOVE 'N' TO WS-WRITE-WK03                             
             ELSE                                                       
                IF WS-101-AMT-POSTED < 0                                
                   MOVE 'N' TO WS-WRITE-WK03                            
                END-IF                                                  
             END-IF                                                     
PAL          MOVE LS-CURR-REVENUE-MONTH   TO WS-101-REVENUE-MONTH       
T10759       MOVE 'P'                     TO WS-101-AR-AGE              
PAL          MOVE CJF00101 TO  E-FWK03-USER-DEFINED-AREA                
           MOVE ZEROS                   TO E-FWK03-SORT-SUM-FLD.        
           IF WS-WRITE-WK03 = 'Y'                                       
              PERFORM 8200-WRITE-WK03      THRU 8200-EXIT               
           END-IF.                                                      
           MOVE 'Y'                     TO  WS-WRITE-WK03.              
      *                                                                 06660000
           MOVE AT-ACCOUNT-NO           TO  AR-ACCOUNT-NO               
                                            AU-ACCOUNT-NO.              
           PERFORM 7010-GET-AR-TIMESTAMP          THRU 7010-EXIT.       
           MOVE AR-TRANS-HIST-SEQ-NO    TO AU-TRANS-HIST-SEQ-NO.        
           ADD +1                       TO AU-TRAN-APPL-NO.             
                                                                        
T11144 6420-EXIT.                                                       
T11144     EXIT.                                                        
                                                                        
      /***** 6500 SERIES - BATCH LOAD ROUTINE                           06760000
       6500-ONLINE-LOAD-AR-TRAN-HIST.                                   
T11144     MOVE 0 TO WS-ACTIVE-RETURN-CODE.                             
      ** THIS IS A DUMMY PARAGRAPH FOR CPD00010.                        06790000
       6500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06820000
      /***** 6700 SERIES - APPLY PAYMENT ROUTINE                        06830000
DC         EXEC SQL                                                     06840000
DC             INCLUDE CPD00010                                         06850000
DC         END-EXEC.                                                    06860000
DC         EXEC SQL                                                     06870000
DC             INCLUDE CPD0010B                                         06880000
DC         END-EXEC.                                                    06890000
                                                                        
      /***** 6800 SERIES - APPLY PAYMENT TO WRITE-OFF. N/A THIS RTN     06910000
       6800-APPLY-PYMT-CO.                                              
           CONTINUE.                                                    
       6800-APPLY-PYMT-CO-EXIT.                                         
            EXIT.                                                       
                                                                        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06970000
      **    7010-GET-AR-TIMESTAMP                                     **06980000
      **    GET TIMESTAMP FROM AR                                     **06990000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **07000000
T11144 7010-GET-AR-TIMESTAMP.                                           
           EXEC SQL                                                     
                SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                INTO :AR-TRANS-HIST-SEQ-NO                              
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     07020000
MFA-TR*         SELECT CURRENT TIMESTAMP                                07030000
MFA-TR*         INTO :AR-TRANS-HIST-SEQ-NO                              07040000
MFA-TR*         FROM CSS_MODEL_SQL                                      07050000
MFA-TR*    END-EXEC.                                                    07060000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE 'AR'                    TO WS-DB2-TABLE-ID          
               MOVE 'SELECT'                TO WS-DB2-FUNCTION          
               MOVE SQLCODE                 TO WS-DB2-RETURN-CODE       
               MOVE '106'                   TO WS-DB2-MODULE-ID         
               MOVE '7010'                  TO WS-DB2-PARAGRAPH         
               MOVE 12                      TO RETURN-CODE              
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
T11144 7010-EXIT.                                                       
T11144     EXIT.                                                        
                                                                        
       7030-GET-CONTRACT-INFO.                                          
           EXEC SQL                                                     
T11144         SELECT GL_ACCT_NO                                        
T11144           INTO :EA-GL-ACCT-NO                                    
T11144           FROM CSS_CNT_DETAIL                                    
T11144          WHERE ACCOUNT_NO  = :CT-ACCOUNT-NO                      
T11144            AND CNT_ITEM_ID = :CT-CNT-ITEM-ID                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
T11144        MOVE 'EA'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '117'                TO WS-DB2-MODULE-ID             
              MOVE '7030'               TO WS-DB2-PARAGRAPH             
T11144        MOVE CT-CNT-ITEM-ID       TO WS-DB2-KEY-1                 
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9910-SQL-ERROR     THRU 9910-EXIT                 
           END-IF.                                                      
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **07440000
      **    8200-WRITE-WK03.                                          **07450000
      **                                                              **07460000
      **    UPDATE COLUMNS ON REFUND TABLE.                           **07470000
      **                                                              **07480000
      **    CALLED BY:  6430-CREATE-FIOWK03.                          **07490000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **07500000
       8200-WRITE-WK03.                                                 
           ADD 1 TO WS-WK03-COUNT                                       
T13536     IF WS-WK03-COUNT > 5000                                      
              MOVE 'WK03 HOLD TABLE OVERFLOW'                           
                TO WS-MISC-MSG-TEXT                                     
              MOVE +24 TO WS-MISC-MSG-LEN                               
              MOVE 16 TO RETURN-CODE                                    
              PERFORM 9920-MISC-ERROR THRU 9920-EXIT                    
           ELSE                                                         
              SET WK03-INDX TO WS-WK03-COUNT                            
              MOVE FIOWK03 TO WS-HOLD-WK03-DATA (WK03-INDX)             
              INITIALIZE FIOWK03                                        
           END-IF                                                       
           .                                                            
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07680000
       9900-SQL-ERROR-ROUTINE.                                          
           MOVE SPACES         TO WS-DB2-TABLE-ID                       
           MOVE ABEND-FUNCTION TO WS-DB2-FUNCTION                       
           MOVE SQLCODE        TO WS-DB2-RETURN-CODE                    
           MOVE 'PAR'          TO WS-DB2-MODULE-ID                      
           MOVE ACTIVE-PARAGRAPH TO WS-DB2-PARAGRAPH                    
           MOVE 12             TO RETURN-CODE                           
           PERFORM 9910-SQL-ERROR THRU 9910-EXIT.                       
       9900-EXIT.                                                       
            EXIT.                                                       
      *                                                                 07790000
       9910-SQL-ERROR.                                                  
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
           END-IF.                                                      
                                                                        
           MOVE WS-DATABASE-EXCEPTION                                   
             TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)           
                                                                        
           COMPUTE WS-START-POS                                         
             = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1                 
           MOVE WS-SQL-ERROR-TXT-WQ                                     
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)   
           ADD WS-SQL-ERROR-TXT-LEN-WQ                                  
             TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                   
                                                                        
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       9910-EXIT.                                                       
           EXIT.                                                        
       9920-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
                                                                        
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
           END-IF.                                                      
                                                                        
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       9920-EXIT.                                                       
           EXIT.                                                        
      **                                                                08190000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **08200000
      **    9999-BAIL-OUT                                             **08210000
      **                                                              **08220000
      **    TO ABEND PROGRAM                                          **08230000
      **                                                              **08240000
      **    CALLED BY: 9900-SQL-ERROR                                 **08250000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **08260000
       9999-BAIL-OUT.                                                   
           EXIT PROGRAM.                                                
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
