       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA116.                                        
      ***************************************************************** 00030000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00040000
      **                     PRICE WATERHOUSE                        ** 00050000
      **                                                             ** 00060000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00070000
      **                                                             ** 00080000
      ***************************************************************** 00090000
      **               P R O G R A M  S U M M A R Y                  ** 00100000
      **                                                             ** 00110000
      **  THIS MODULE CREATES THE BILL EXTRACT DATA RECORDS (BE00    ** 00120000
      **  AND BE01) FROM CWS10000 AND CWS10001 RESPECTIVELY.         ** 00130000
      **                                                             ** 00140000
      ***************************************************************** 00150000
      **                                                             ** 00160000
      **              PROGRAM  MODIFICATION  LOG                     ** 00170000
      **                                                             ** 00180000
      **    DATE    INITIALS  REASON                                 ** 00190000
      **  ________  ________  ______                                 ** 00200000
      **  2/20/95    WTF      INITIAL PROGRAM VERSION                ** 00210000
      **  1/18/96    LMB      TPR 2699 - ADV COLL TABLE DROPPED      ** 00220000
      **  6/03/96    LMB      TPR 4331 - DELETED CRED-COLL ROWS      ** 00230000
      **                      SHOULD NOT BE WRITTEN TO BE00 FILE.    ** 00240000
      **  8/8/96     WTF      ADDED CODE TO WRITE OUT BILL CONTRACT, ** 00250000
      **                      CONTRACT HISTORY, AND REFUND SEGMENTS  ** 00260000
      **                                                             ** 00270000
PCR072**  9/26/96    PD       COMMENTED OUT CODE FOR CIAC FOR PCR072.** 00280000
PCR285**  9/28/96    CDS      PCR285 - NO RECORDS WRITTEN TO BE00 IF ** 00290000
PCR285**                      THE ACCOUNT HAS A MEDICAL CERTIFICATE  ** 00300000
PCR285**                      AND DATE BILL IS NOT 00 DAY BILL.      ** 00310000
T12261**  8/01/97    CSG      CHANGE THE REFUND OCCURENCE TO 20.     ** 00320000
T13410** 10/29/97    CSG      WRITE OUT THE CNSMPTN HIST RECORDS IN  ** 00330000
      **                      METER NUMBER ORDER.                    ** 00340000
PCR629**  04/24/98     AMG    CHANGED THE CATEGORIES OF SOME         ** 00350000
PCR629**                      WORK QUEUES                            ** 00360000
PCR647**  05/18/98     CSG    FILL ACCOUNTING REV MO FOR MONTHLIES   ** 00370000
T18110**  10/10/98     MDJ    INCREASED THE NUMBER OF OCCURENCES FOR ** 00380000
      **                      DEPOSITS ON HAND FROM 5 TO 15.         ** 00390000
T19483**  03/24/99    RGB     SET CODE-TEMP-BILL PULL TO 'T' WHEN AMT** 00400000
T19483**                      BILL ITEM > 400 & ALSO TOTAL-AR-BALANCE * 00410000
T19483**                      IS > 700 FOR RESIDENTIAL ACCOUNTS      ** 00420000
T22315**  06/07/00     MDJ    ADDED LOGIC TO PARA 8250 TO WRITE CRED ** 00430000
      **                      COLL ROWS T U AND X IF ACCOUNT IS ON   ** 00440000
      **                      MEDICAL CERTIFICATE JUST LIKE ROWS E F ** 00450000
      **                      AND G.                                 ** 00460000
T23497**  01/15/01    RGB     SET CODE-TEMP-BILL PULL TO 'T' WHEN AMT** 00470000
T23497**                      BILL ITEM > 600 & ALSO TOTAL-AR-BALANCE * 00480000
T23497**                      IS > 800 FOR RESIDENTIAL ACCOUNTS      ** 00490000
      **  03/07/01 BERNARD    CHANGED TO NOT CHANGE WS-CODE-TEMP-PULL** 00500000
      **  TPR23829 MITCHELL   -TEMP-PULL-AT IF IT IS = 'R' AND IS A  ** 00510000
      **                      SEB ACCOUNT.                           ** 00520000
C23632**  03/20/01    GSR     CHANGES MADE TO SET CODE TO NOT PRINT  ** 00530000
C23632**                      BILLS FOR ADDITIVE METER SUBS.          * 00540000
PULLFI**  02/01/02    RGB     CHANGES MADE TO SET CODE-TEMP-PULL-CODE** 00550000
PULLFI**                      PROPERLY.                               * 00560000
T26765**  07/18/02    DVK     CHANGES MADE TO SET BILL PULL CODE FOR  * 00570000
T26765**                      ACCOUNTS REPORTED ON HIGH BILL SPUFI RPT* 00580000
T26765**                      PGM(SEB045) FOR COMMERCIAL.             * 00590000
T27350**  11/15/02    PD      DO NOT PULL THE BILL IF AMT > 600 OR    * 00600000
T27350**                      BILLED BALANCE > 800.                   * 00610000
T33924**  08/15/06  DB41297  PSNC RATE CASE CHANGES                  *  00620000
T33924**                     WRITE BILL_ADJ TO BE00 FILE.            *  00630000
C34569**  05/05/08  SS95855  SEB RATE RE-ENGINEERING.                *  00640000
I00177**  01/05/09  SS97726  CHANGE WS-CUST-PLAN-INDX 100 TO 1000    ** 00650000
I00177**                     & WS-UNMTRD-CNSMPTN-INDX 100 TO 200     ** 00660000
I00177**                     & REMOVE IDX HARD CODING                ** 00670000
P00097**  01/27/09  SS97726  CHANGE WS-CL-INDX      FROM 21 TO 50    ** 00680000
P00097**                            WS-DFA-INDX     FROM 20 TO 50    ** 00690000
P00097**                            WS-DV-INDX      FROM 20 TO 50    ** 00700000
P00097**                            WS-CNT-INDX     FROM 20 TO 50    ** 00710000
P00097**                            WS-CNT-DET-INDX FROM 20 TO 50    ** 00720000
P00097**                            WS-AR-DATA      FROM 50 TO 150   ** 00730000
P00097**                     & REMOVE RELATED IDX HARD CODING        ** 00740000
I00177**  03/26/09  RH15956  WRITE 'RTPROPCT' FACTOR TO BE00 FOR ALL ** 00750000
I00177**                     RATE VERSIONS.                          ** 00760000
P00577**  06/01/09  AW41078  WRITE ADDITIONAL CONTRACT DETAILS TO    ** 00770000
P00577**                     BE00. CNT_ADDL_DESC ADDED TO            ** 00780000
P00577**                     CSS_CONTRACT.                           ** 00790000
A03730** 09/15/09   MN90523  REMOVED DATA ITEMS RELATED TO           ** 00791000
A03730**                     TABLES BY, RA, LN                       ** 00792000
P00166**  08/10/09  AW41078  WRITE CSS_CORR_MAIL_STAT DETAILS TO BE00** 00793000
A00835** 12/09/09   VV94890  FIX TO NOT PRINT MEDICAL CERTIFICATE MSG** 00794000
A00835**                     ON FINAL BILLS - NOT WRITING 'D' ROWS IN** 00795000
A00835**                     BE00 FILE.                              ** 00796000
P00257** 02/14/10   RH15956  CHANGES FOR REVENUE REPORTING PROJECT.  ** 00797000
P00257**                     ADD NEW RECORD TYPE 'XD' RECORD ID 1925 ** 00798000
P00257**                     TO BE00 FILE.                           ** 00799000
P00251** 04/07/10   SS97726  NET METERING PROJECT CHANGES.           ** 00799100
P00411** 06/23/10   RH15956  ELECTRIC WNA PROJECT CHANGES.           ** 00799200
P00251** 10/02/10   VY95550  WRITE CSS_UTL_BI_REL_HST DETAILS TO BE01** 00799300
P00453** 02/02/11   MN90523  PREPAID PLAN CHANGES                    ** 00799500
P00496** 04/05/11   SS97726  INDUSTRIAL BILLING ENHANCEMENTS.        ** 00799600
RODFIX** 05/23/11   RH15956  INDUSTRIAL ELECTRIC BILLING ENHANCEMENTS** 00799700
VKSACT*  09/08/11  VIJAY   History rows creation for event process.   * 00799800
      *  P00496            This includes Curtailment, Maintenance     * 00799900
      *                    and Standby events.                        * 00799910
A03850*  03/07/11  VIJAY   PROCESS ALL BBP ROWS TO MAKE SURE ALL ICs  *         
      *  ACT001            ARE MOVED TO OUTPUT (SOME TIMES THERE WILL *         
      *                    BE A BLANK ARRAY DUE TO DROPPED/NEW ICS).  *         
P00599*  02/13/12   SP95538  REMOVE WRITING TO CSS_CRED_COLL TABLE AS** 00799700
P00599*                      A PART OF CREDIT SIMPLIFICATION CHANGES.** 00799700
P00599*  07/20/12   GOKUL    DO NOT WRITE BE01 FILE FOR ACCTS WITH   ** 00799700
P00599*                      WS-ACCT-SUPPRESS-IND = Z. THESE ACCOUNTS** 00799700
P00599*                      WILL BE DROPPED FROM BE00 FILES AFTER   ** 00799700
P00599*                      THE POST BILLING CREDIT PROCESS RUNS.   ** 00799700
ACT028*  01/29/14   VIJAY    DO NOT WRITE BP RECORD FOR 'RTOV' (RATE ** 00799700
ACT028*   A04880             OVVERIDE) PARM WHEN CONSUMPTION ADJUST- ** 00799700
ACT028*                      MENT IS FOR ONE MUNTH FOR A BILL.       ** 00799700
ACT028*  07/23/14   VIJAY    BACKOUT ACT028 CHANGES.                 ** 00799700
A05290*  05/19/15   SS45239  REMOVE DUMMY CX CREATED FOR ADDITIONAL  **         
A05290*                      AGL PASSTHROUGH CHARGES.                **         
ACT100*  03/23/16   VIJAY    USE SUPPRESS FLAG FOR DUMMY CX,SO THAT  **         
ACT100*  A05460              BILL PRINT WILL NOT USE IT.             **         
ACT284*  09/22/16  VIJAY     SET INDEXES TO 1 TO AVOID EXCEPTIONS IN **         
ACT284*   A05631             MFES ENVIRONMENT.                       **         
      ***************************************************************** 00800000
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00810000
      **                                                             ** 00820000
      **  0000         MODULE CONTROL                                ** 00830000
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00840000
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00850000
      **  2000 - 4999  DETAIL LOGIC                                  ** 00860000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00870000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00880000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00890000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00900000
      **                                                             ** 00910000
      ***************************************************************** 00920000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSBE00.                                                    00960000
      *                                                                 00970000
       COPY CSSBE01.                                                    00980000
      *                                                                 00990000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDBE00X.                                                   01020000
       COPY FIOBE00.                                                    01030000
                                                                        
       COPY CFDBE01X.                                                   01050000
       COPY FIOBE01.                                                    01060000
                                                                        
       WORKING-STORAGE SECTION.                                         
       01  WS-START                   PIC X(40)                         
           VALUE 'WORKING STORAGE FOR SCSCA116 STARTS HERE'.            
       01  WS-MISC.                                                     
           05  WS-START-POS           PIC S9(4) COMP.                   
           05  WS-DELETE              PIC X(01) VALUE 'D'.              
P00453     05  WS-ACTIVE              PIC X(01) VALUE 'A'.              
T19483     05  WS-TOT-AMT-BILL-ITEM   PIC S9(9)V99  VALUE ZEROES.       
T19483     05  WS-ACCOUNT-NO          PIC 9(13).                        
T19483     05  WS-ACCOUNT-NO-R REDEFINES WS-ACCOUNT-NO PIC X(13).       
RATEH      05  WS-PREV-BILLING-KEY-BA.                                  
COB305         10 WS-PREV-ACCOUNT-NO-BA        PIC S9(13)V COMP-3 
COB305           VALUE 0.    
RATEH          10  WS-PREV-BILL-NO-BA           PIC S9(09)   COMP.      
RATEH          10  WS-PREV-CODE-UTIL-TYPE-BA    PIC X(01).              
RATEH          10  WS-PREV-IC-NO-BA             PIC S9(04)   COMP.      
RATEH          10  WS-PREV-BILL-ITEM-TIMESTMP-BA PIC X(26).             
RODFIX     05  WS-CNSMPTN-DATA-HOLD   PIC X(500).                       
       01  WS-FBE00-STATUS            PIC X(2) EXTERNAL.                
           88  FBE00-SUCCESSFUL        VALUE '00'.                      
       01  WS-FBE01-STATUS            PIC X(2) EXTERNAL.                
           88  FBE01-SUCCESSFUL        VALUE '00'.                      
      /****** CWS00050 CONTAINS RECORD-TYPE CODES FOR BILL EXTRACT      01270000
       01  WS-EXTRACT-RECORD-TYPES.                                     
           COPY CWS00050.                                               01290000
      /****** CWS00056 CONTAINS CODES DATA PRESENT                      01300000
           COPY CWS00056.                                               01310000
      /********************************************************         01320000
      *                                                       *         01330000
      *   WORKING STORAGE FOR BASIC WQ MESSAGE TEXT           *         01340000
      *                                                       *         01350000
      *********************************************************         01360000
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-MESSAGE-PATTERN.                                      
               10  WS-WQ-CATEGORY-ID       PIC S9(4) COMP.              
               10  WS-WQ-PRIORITY          PIC X(1).                    
               10  WS-WQ-ROUTE-CATEGORY    PIC X(1).                    
               10  WS-WQ-MESSAGE-LENGTH    PIC S9(4) COMP.              
               10  WS-WQ-MESSAGE-TEXT      PIC X(30).                   
           05  WS-MISCELLANEOUS-MESSAGE.                                
PCR629         10  WS-MISC-CATEGORY        PIC S9(4) COMP VALUE +17.    
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  WS-MISC-MSG-LEN         PIC S9(4) COMP VALUE +60.    
               10  WS-MISC-MSG-TEXT        PIC X(60).                   
                                                                        
           COPY CWS0070B.                                               01510000
                                                                        
       LINKAGE SECTION.                                                 
           COPY CWS0024B.                                               01540000
      /                                                                 01550000
           COPY CWS1000A.                                               01560000
           COPY CWS1000B.                                               01570000
      /                                                                 01580000
           COPY CWS1001A.                                               01590000
           COPY CWS1001B.                                               01600000
      /                                                                 01610000
       01  WS-PART-NO                 PIC 9(02).                        
       PROCEDURE DIVISION USING LS-PCSCA100-COMM-AREA                   
                                 WS-PREMISE-PR                          
                                 WS-PREMISE-INSTR-PS                    
                                 WS-PREMISE-DIRECT-PP                   
                                 WS-PREMISE-PAD-PC                      
                                 WS-CUSTOMER-CU                         
                                 WS-CUST-PREM-HIST-CH                   
                                 WS-ACCOUNT-AT                          
                                 WS-DEP-ON-HAND-DO                      
                                 WS-CHRG-OFF-CO                         
                                 WS-CUST-STATS-CE                       
                                 WS-CUST-ALERT-CA                       
                                 WS-BANK-EFT-BE                         
                                 WS-CRED-COLL-CL                        
                                 WS-SURETY-BOND-SB                      
                                 WS-LIEAP-LI                            
                                 WS-PEAK-HIST-PH                        
                                 WS-BILLING-BI                          
                                 WS-BILLING-BG                          
                                 WS-BILL-CALC-DETAIL                    
                                 WS-BILL-ADJUST-DETAIL                  
                                 WS-CNSMPTN-HIST-CX                     
                                 WS-UNMTRD-CNSMPTN-UC                   
                                 WS-FIXED-FCTR-HIST-FH                  
                                 WS-BILL-CONTRACT-BK                    
                                 WS-BILL-CNTR-HIST-BX                   
                                 WS-AR-CNTRL-AC                         
                                 WS-BUDGET-PLAN-BU                      
                                 WS-CONNECT-CHRG-CC                     
                                 WS-DFA-ACCT-DA                         
                                 WS-DFA-RECV-DV                         
PCR072*                          WS-CIAC-CI                             01940000
                                 WS-DEP-REQ-DR                          
                                 WS-CONTRACT-CT                         
                                 WS-CONTRACT-DETAIL-TABLE-EA            
TP2699*                          WS-ADV-COLL-AD                         01980000
                                 WS-BUS-CUST-STATS-BS                   
                                 WS-CONTACT-CN                          
                                 WS-ACCT-BILL-NMES-AB                   
                                 WS-ADDR-FREEFORM-DZ                    
                                 WS-ADDR-FORMATTED-DY                   
                                 WS-CREDIT-PROFILE-CZ                   
                                 WS-SHORT-TERM-AGMT-SA                  
                                 WS-PROJECT-SHARE-PJ                    
                                 WS-INTERRUPT-ACCT-IP                   
                                 WS-STANDBY-GEN-SE                      
                                 WS-INTERRUPT-IR                        
                                 WS-FINAL-WO-FW                         
                                 WS-UTILITY-TABLE-UT                    
                                 WS-USAGE-HIST-TABLE-UH                 
                                 WS-REGISTER-READ-TABLE-RG              
                                 WS-UTL-BILL-REL-TABLE-UR               
                                 WS-FIXED-FCTR-TABLE-FF                 
                                 WS-MTRD-ENVRNMT-TABLE-MN               
                                 WS-MTR-CAP-TABLE-MC                    
                                 WS-EQUIPMENT-TABLE-EQ                  
                                 WS-CUST-PLAN-TABLE-CP                  
                                 WS-BILLING-WQ-ITEMS-WF                 
                                 WS-12-MONTH-DATA-EPP                   
                                 WS-RATE-COMPARE-RC                     
                                 WS-PART-NO                             
                                 WS-REFUND-RN                           
C34569                           WS-ACCT-ATTRIBUTE-YP                   
C34569                           WS-ACCT-MKT-TIER-DD                    
C34569                           WS-ACCT-RTPK-AGR-DF                    
C34569                           WS-BI-FIXED-FCTR-FF                    
C34569                           WS-BILL-DET-BT                         
T33924                           WS-BILL-ADJUSTMNT                      
I00177                           WS-CWS1000B-MAX-TBL-LIMITS             
I00177                           WS-CWS1001B-MAX-TBL-LIMITS             
P00577                           WS-CONTRACT-CONT-1C                    
P00166                           WS-CORR-MAIL-STAT-MW                   
P00257                           WS-BILL-CALC-X-DETAIL                  
P00251                           WS-VOL-DAILY-ND                        
P00251                           WS-UTL-BI-REL-HST-TABLE-UX             
P00453                           WS-PREPAY-HIST-PK                      
P00496                           WS-BILL-BSLN-CNTR-LN                   
P00496                           WS-BILL-BSLN-HIST-LO                   
VKSACT                           WS-INTERRUPT-NZ.                       
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **02370000
      **                                                              **02380000
      **    0000-MAINLINE                                             **02390000
      **                                                              **02400000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **02410000
       0000-MAINLINE.                                                   
I00177     INITIALIZE WS-SQL-ERROR-TXT-WQ.                              
ACT284     PERFORM 0100-SET-BE00-BE01-INDX THRU 0100-EXIT               
           PERFORM 1100-WRITE-BE00-DATA THRU 1100-EXIT.                 
P00599     IF WS-ACCT-SUPPRESS-IND NOT = 'Z'                            
P00599        PERFORM 1200-WRITE-BE01-DATA THRU 1200-EXIT               
P00599     END-IF.                                                      
      *                                                                 02460000
           EXIT PROGRAM.                                                
                                                                        
ACT284****************************************************************          
ACT284* 0100-SET-BE00-BE01-INDX.                                                
ACT284****************************************************************          
ACT284 0100-SET-BE00-BE01-INDX.                                         
ACT284     SET WS-CSTADR-INDX                                           
ACT284         WS-CH-INDX                                               
ACT284         WS-DEP-INDX                                              
ACT284         WS-CHG-OFF-INDX                                          
ACT284         WS-CL-INDX                                               
ACT284         WS-SB-INDX                                               
ACT284         WS-BILLING-INDX                                          
ACT284         WS-CALC-INDX                                             
ACT284         WS-CALC-X-INDX                                           
ACT284         WS-BILL-ADJ-INDX                                         
ACT284         WS-CNSMPTN-INDX                                          
ACT284         WS-ND-INDX                                               
ACT284         WS-UNMTRD-CNSMPTN-INDX                                   
ACT284         WS-FH-HIST-INDX                                          
ACT284         WS-BK-INDX                                               
ACT284         WS-BX-INDX                                               
ACT284         WS-AR-DATA-INDX                                          
ACT284         WS-CCC-INDX                                              
ACT284         WS-DFA-INDX                                              
ACT284         WS-DV-INDX                                               
ACT284         WS-DEP-REQ-INDX                                          
ACT284         WS-CNT-INDX                                              
ACT284         WS-CNT-DET-INDX                                          
ACT284         WS-FREE-INDX                                             
ACT284         WS-FMTD-INDX                                             
ACT284         WS-STA-DETAIL-INDX                                       
ACT284         WS-PH-INDX                                               
ACT284         WS-INTR-INDX                                             
ACT284         WS-NMES-INDX                                             
ACT284         WS-EPP-INDX                                              
ACT284         WS-FW-INDX                                               
ACT284         WS-RC-INDX                                               
ACT284         WS-RN-INDX                                               
ACT284         WS-PK-INDX                                               
ACT284         WS-BI-FF-INDX                                            
ACT284         WS-TIER-INDX                                             
ACT284         WS-RTPK-INDX                                             
ACT284         WS-ATTR-INDX                                             
ACT284         WS-BDET-INDX                                             
ACT284         WS-ADJUSTMNT-INDEX                                       
ACT284         WS-CNTCONT-INDX                                          
ACT284         WS-LN-INDX                                               
ACT284         WS-LO-INDEX                                              
ACT284         WS-NZ-INDX                                               
ACT284         HOURLY-INDX TO 1.                                        
ACT284                                                                  
ACT284     SET  WS-UTIL-INDX                                            
ACT284          WS-USAGE-HIST-INDX                                      
ACT284          WS-REG-RD-INDX                                          
ACT284          WS-UR-INDX                                              
ACT284          WS-FF-INDX                                              
ACT284          WS-MTRD-INDX                                            
ACT284          WS-MTR-CAP-INDX                                         
ACT284          WS-EQUIP-DATA-INDX                                      
ACT284          WS-CUST-PLAN-INDX                                       
ACT284          WS-UX-INDX TO 1.                                        
ACT284 0100-EXIT.                                                       
ACT284      EXIT.                                                       
      *                                                                         
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  ** 02480000
      *                                                              ** 02490000
      *    3100-WRITE-BE00-DATA                                      ** 02500000
      *                                                              ** 02510000
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  ** 02520000
       1100-WRITE-BE00-DATA.                                            
           PERFORM 8500-WRITE-PREMISE        THRU 8500-EXIT.            
           IF WS-PREMISE-NO-PS > ZERO                                   
              PERFORM 8501-WRITE-PREMISE-INSTR  THRU 8501-EXIT
           END-IF.         
           IF WS-PREMISE-NO-PP > ZERO                                   
              PERFORM 8502-WRITE-PREMISE-DIRECT THRU 8502-EXIT
           END-IF.         
           IF WS-PREMISE-NO-PC > ZERO                                   
              PERFORM 8503-WRITE-PREMISE-PAD    THRU 8503-EXIT
           END-IF.         
           PERFORM 8200-WRITE-CUSTOMER  THRU 8200-EXIT.                 
      *                                                                 02620000
           PERFORM 8290-WRITE-PREM-HIST THRU 8290-EXIT                  
              VARYING WS-CH-INDX     FROM 1 BY 1                        
              UNTIL  WS-CH-INDX GREATER THAN 10                         
              OR     WS-ACCOUNT-NO-CH (WS-CH-INDX)                      
                EQUAL +0.                                               
      *                                                                 02680000
           PERFORM 8100-WRITE-ACCOUNT  THRU  8100-EXIT.                 
                                                                        
T27350*****                                                             02710000
T27350***** COMMENTING FOR T27350 STARTS HERE. THE CODE IS NOT REMOVED  02720000
T27350***** AS IT CAN BE RECREATED EASILY IF IT NEEDS TO BE PUT BACK.   02730000
T27350*****                                                             02740000
T19483*    MOVE ZEROES                 TO WS-TOT-AMT-BILL-ITEM.         02750000
T19483*    PERFORM 1300-CHECK-AMT-BILL-ITEM  THRU 1300-EXIT             02760000
T19483*       VARYING WS-BILLING-INDX            FROM 1 BY 1            02770000
T19483*       UNTIL  WS-BILLING-INDX GREATER THAN 30                    02780000
T19483*       OR    WS-ACCOUNT-NO-BG (WS-BILLING-INDX)                  02790000
T19483*         EQUAL +0.                                               02800000
T23497*     IF WS-TOT-AMT-BILL-ITEM > 600                               02810000
T23829*        IF SEB-DATABASE                                          02820000
T23829*          AND WS-CODE-TEMP-BILL-AT = 'R'                         02830000
T23829*            CONTINUE                                             02840000
T23829*        ELSE                                                     02850000
T19483*          MOVE 'T' TO   WS-CODE-TEMP-BILL-AT                     02860000
T23829*        END-IF                                                   02870000
T19483*     END-IF.                                                     02880000
T26765*     IF SEB-DATABASE                                             02890000
T26765*        IF WS-CODE-TEMP-BILL-AT = 'R'                            02900000
T26765*           CONTINUE                                              02910000
T26765*        ELSE                                                     02920000
T26765*           IF WS-TOT-AMT-BILL-ITEM > 400                         02930000
T26765*              MOVE 'T' TO WS-CODE-TEMP-BILL-AT                   02940000
T26765*           END-IF                                                02950000
T26765*        END-IF                                                   02960000
T26765*     END-IF.                                                     02970000
T19483*     MOVE WS-ACCOUNT-NO-AT      TO WS-ACCOUNT-NO.                02980000
T19483*     IF WS-CREDIT-GROUP-AT = 'D'      AND                        02990000
T19483*        WS-MST-SUB-ACCT-IND-AT NOT = 'M' AND                     03000000
T23497*        WS-TOTAL-AR-BALANCE-AT  > 800 AND                        03010000
T19483*        WS-ACCOUNT-NO-R (4:2)   NOT = '98'                       03020000
T23829*          IF SEB-DATABASE                                        03030000
T23829*            AND WS-CODE-TEMP-BILL-AT = 'R'                       03040000
T23829*              CONTINUE                                           03050000
T23829*          ELSE                                                   03060000
T19483*           MOVE 'T'             TO WS-CODE-TEMP-BILL-AT          03070000
T23829*          END-IF                                                 03080000
T19483*     END-IF                                                      03090000
T27350*****                                                             03100000
T27350***** COMMENTING FOR T27350 ENDS HERE                             03110000
T27350*****                                                             03120000
      *                                                                 03130000
           PERFORM 8140-WRITE-DEP-ON-HAND  THRU 8140-EXIT               
              VARYING WS-DEP-INDX     FROM 1 BY 1                       
T18110          UNTIL WS-DEP-INDX GREATER THAN 15                       
                   OR WS-ACCOUNT-NO-DO (WS-DEP-INDX) EQUAL ZERO.        
      *                                                                 03180000
           PERFORM 8150-WRITE-CHRG-OFF  THRU 8150-EXIT                  
              VARYING WS-CHG-OFF-INDX     FROM 1 BY 1                   
              UNTIL  WS-CHG-OFF-INDX GREATER THAN 9                     
              OR    WS-ACCOUNT-NO-CO (WS-CHG-OFF-INDX)                  
                EQUAL +0.                                               
      *                                                                 03240000
           PERFORM 8210-WRITE-CUST-STATS  THRU 8210-EXIT.               
           PERFORM 8220-WRITE-CUST-ALERT  THRU 8220-EXIT.               
           PERFORM 8240-WRITE-BANK-EFT THRU 8240-EXIT.                  
      *                                                                 03280000
           PERFORM 8260-WRITE-SURETY-BOND THRU 8260-EXIT                
DP102         VARYING WS-SB-INDX     FROM 1 BY 1                        
DP102         UNTIL WS-SB-INDX GREATER THAN 10                          
DP102         OR    WS-ACCOUNT-NO-SB (WS-SB-INDX)                       
DP102               EQUAL +0.                                           
      *                                                                 03400000
           PERFORM 8160-WRITE-LIEAP  THRU 8160-EXIT.                    
      *                                                                 03420000
           PERFORM 8400-WRITE-BILLING THRU 8400-EXIT.                   
      *                                                                 03440000
           PERFORM 8401-WRITE-BILLING-DET    THRU 8401-EXIT             
              VARYING WS-BILLING-INDX            FROM 1 BY 1            
              UNTIL  WS-BILLING-INDX GREATER THAN 30                    
              OR    WS-ACCOUNT-NO-BG (WS-BILLING-INDX)                  
                EQUAL +0.                                               
      *                                                                 03500000
           PERFORM 8402-WRITE-BILL-RESULTS   THRU 8402-EXIT             
              VARYING WS-CALC-INDX            FROM 1 BY 1               
I00177        UNTIL  WS-CALC-INDX GREATER THAN WS-BZ-MAX-ENTRY          
              OR    WS-ACCOUNT-NO-BC (WS-CALC-INDX)                     
                EQUAL +0.                                               
P00257*                                                                 03560000
P00257     PERFORM 8402A-WRITE-BILL-RESULTS   THRU 8402A-EXIT           
P00257        VARYING WS-CALC-X-INDX FROM 1 BY 1                        
P00257        UNTIL WS-CALC-X-INDX GREATER THAN WS-BZ-MAX-ENTRY         
P00257        OR WS-ACCOUNT-NO-XD (WS-CALC-X-INDX)                      
P00257          EQUAL +0.                                               
      *                                                                 03566000
P00251     PERFORM 8402B-WRITE-VOL-DAILY     THRU 8402B-EXIT            
P00251        VARYING WS-ND-INDX             FROM 1 BY 1                
P00251        UNTIL WS-ND-INDX GREATER THAN WS-ND-MAX-ENTRY             
P00251        OR WS-ACCOUNT-NO-ND (WS-ND-INDX)                          
P00251          EQUAL +0.                                               
P00251*                                                                 03566700
RATEH      MOVE ZEROES                  TO WS-PREV-ACCOUNT-NO-BA        
RATEH      MOVE ZEROES                  TO WS-PREV-BILL-NO-BA           
RATEH      MOVE SPACES                  TO WS-PREV-CODE-UTIL-TYPE-BA    
RATEH      MOVE ZEROES                  TO WS-PREV-IC-NO-BA             
RATEH      MOVE SPACES                  TO WS-PREV-BILL-ITEM-TIMESTMP-BA
                                                                        
           PERFORM 8403-WRITE-BILL-ADJUST THRU 8403-EXIT                
              VARYING WS-BILL-ADJ-INDX FROM 1 BY 1                      
31178 *       UNTIL WS-BILL-ADJ-INDX GREATER THAN 100                   03620000
31178         UNTIL WS-BILL-ADJ-INDX GREATER THAN 200                   
              OR WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX)                    
                EQUAL +0.                                               
      *                                                                 03660000
           PERFORM 8405-WRITE-BILL-CNTRACT THRU 8405-EXIT               
              VARYING  WS-BK-INDX FROM 1 BY 1                           
              UNTIL  WS-BK-INDX GREATER THAN 20                         
              OR    WS-ACCOUNT-NO-BK (WS-BK-INDX)                       
                EQUAL +0.                                               
      *                                                                 03720000
           PERFORM 8407-WRITE-BX-HISTORY THRU 8407-EXIT                 
              VARYING  WS-BX-INDX FROM 1 BY 1                           
              UNTIL  WS-BX-INDX GREATER THAN 20                         
              OR    WS-ACCOUNT-NO-BX (WS-BX-INDX)                       
                EQUAL +0.                                               
      *                                                                 03780000
P00496     PERFORM 8408-WRITE-BILL-BSLN-CNTR THRU 8408-EXIT             
P00496        VARYING  WS-LN-INDX FROM 1 BY 1                           
P00496        UNTIL  WS-LN-INDX GREATER THAN 20                         
P00496        OR    WS-ACCOUNT-NO-LN (WS-LN-INDX)                       
P00496          EQUAL +0.                                               
P00496*                                                                 03786000
P00496     PERFORM 8409-WRITE-BILL-BSLN-HIST THRU 8409-EXIT             
P00496        VARYING  WS-LO-INDEX FROM 1 BY 1                          
P00496        UNTIL  WS-LO-INDEX GREATER THAN 20                        
P00496        OR    WS-ACCOUNT-NO-LO (WS-LO-INDEX)                      
                EQUAL +0.                                               
T33924*                                                                 05250000
RODFIX*    PERFORM 8410-FIND-METER-EXCHANGE THRU 8410-EXIT.             03791000
                                                                        
RODFIX*    PERFORM 8412-WRITE-CNSMPTN-HIST THRU 8412-EXIT               03850000
RODFIX*       VARYING WS-CNSMPTN-INDX FROM 1 BY 1                       03851000
RODFIX*       UNTIL WS-CNSMPTN-INDX > WS-CX-MAX-ENTRY                   03852000
RODFIX*       OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) = +0.               03853000
      *                                                                 03870000
           PERFORM 8410-SORT-CNSMPTN-HIST THRU 8410-EXIT                
              VARYING  WS-CNSMPTN-INDX2 FROM 1 BY 1                     
RODFIX        UNTIL  WS-CNSMPTN-INDX2 > 199.                            
                                                                        
RODFIX     SET WS-CNSMPTN-INDX TO 200.                                  
T13410     IF WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) NOT = 0                
T13410        PERFORM 8412-WRITE-CNSMPTN-HIST THRU 8412-EXIT            
T13410     END-IF.                                                      
      *                                                                 03879000
           PERFORM 8420-WRITE-UNMTRD-CNSMPTN THRU 8420-EXIT             
              VARYING WS-UNMTRD-CNSMPTN-INDX     FROM 1 BY 1            
I00177        UNTIL  WS-UNMTRD-CNSMPTN-INDX GREATER THAN                
I00177               WS-UC-MAX-ENTRY                                    
              OR    WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX)           
                EQUAL +0.                                               
      *                                                                 03940000
           PERFORM 8430-WRITE-FIXED-FCT-HIST THRU 8430-EXIT             
              VARYING WS-FH-HIST-INDX FROM 1 BY 1                       
31178 *       UNTIL WS-FH-HIST-INDX GREATER THAN 100                    03970000
31178         UNTIL WS-FH-HIST-INDX GREATER THAN 200                    
              OR WS-ACCOUNT-NO-FH (WS-FH-HIST-INDX)                     
                EQUAL +0.                                               
      *                                                                 04010000
           PERFORM 8110-WRITE-AR-CNTRL  THRU 8110-EXIT                  
              VARYING WS-AR-DATA-INDX FROM 1 BY 1                       
P00097        UNTIL  WS-AR-DATA-INDX GREATER THAN WS-AC-MAX-ENTRY       
              OR    WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX)                  
                EQUAL +0.                                               
      *                                                                 04070000
           PERFORM 8530-WRITE-BUDGET-HIST  THRU 8530-EXIT.              
      *                                                                 04090000
           PERFORM 8540-WRITE-CONNECT-CHRG THRU 8540-EXIT               
              VARYING WS-CCC-INDX     FROM 1 BY 1                       
              UNTIL  WS-CCC-INDX GREATER THAN 20                        
              OR    WS-ACCOUNT-NO-CC (WS-CCC-INDX)                      
                EQUAL +0.                                               
      *                                                                 04150000
           PERFORM 8550-WRITE-DFA-ACCT THRU 8550-EXIT                   
              VARYING WS-DFA-INDX     FROM 1 BY 1                       
P00097        UNTIL  WS-DFA-INDX GREATER THAN WS-DA-MAX-ENTRY           
              OR    WS-ACCOUNT-NO-DA (WS-DFA-INDX)                      
                EQUAL +0.                                               
      *                                                                 04210000
           PERFORM 8560-WRITE-DFA-RECV THRU 8560-EXIT                   
              VARYING WS-DV-INDX     FROM 1 BY 1                        
P00097        UNTIL  WS-DV-INDX GREATER THAN WS-DV-MAX-ENTRY            
              OR    WS-ACCOUNT-NO-DV (WS-DV-INDX)                       
                EQUAL +0.                                               
      *                                                                 04270000
PCR072*    PERFORM 8570-WRITE-CIAC  THRU 8570-EXIT                      04280000
PCR072*       VARYING WS-CIAC-INDX     FROM 1 BY 1                      04290000
PCR072*       UNTIL  WS-CIAC-INDX GREATER THAN 20                       04300000
PCR072*       OR    WS-ACCOUNT-NO-CI (WS-CIAC-INDX)                     04310000
PCR072*         EQUAL +0.                                               04320000
      *                                                                 04330000
           PERFORM 8580-WRITE-DEP-REQ  THRU 8580-EXIT                   
              VARYING WS-DEP-REQ-INDX     FROM 1 BY 1                   
              UNTIL  WS-DEP-REQ-INDX GREATER THAN 20                    
              OR    WS-ACCOUNT-NO-DR (WS-DEP-REQ-INDX)                  
                EQUAL +0.                                               
      *                                                                 04390000
           PERFORM 8590-WRITE-CONTRACT THRU 8590-EXIT                   
              VARYING WS-CNT-INDX     FROM 1 BY 1                       
P00097        UNTIL  WS-CNT-INDX GREATER THAN WS-CT-MAX-ENTRY           
              OR    WS-ACCOUNT-NO-CT (WS-CNT-INDX)                      
                NOT NUMERIC                                             
              OR    WS-ACCOUNT-NO-CT (WS-CNT-INDX)                      
                EQUAL +0.                                               
      *                                                                 04470000
P00577     PERFORM 8595-WRITE-CONTRACT-CONT THRU 8595-EXIT              
P00577        VARYING WS-CNTCONT-INDX FROM 1 BY 1                       
P00577        UNTIL  WS-CNTCONT-INDX GREATER THAN WS-1C-MAX-ENTRY       
P00577        OR    WS-ACCOUNT-NO-1C (WS-CNTCONT-INDX)                  
P00577          NOT NUMERIC                                             
P00577        OR    WS-ACCOUNT-NO-1C (WS-CNTCONT-INDX)                  
P00577          EQUAL +0.                                               
P00577*                                                                 04550000
TP2699*    PERFORM 8280-WRITE-ADV-COLL   THRU 8280-EXIT                 04560000
TP2699*       VARYING WS-ADV-INDX     FROM 1 BY 1                       04570000
TP2699*       UNTIL  WS-ADV-INDX GREATER THAN 5                         04580000
TP2699*       OR    WS-ACCOUNT-NO-AD (WS-ADV-INDX)                      04590000
TP2699*         EQUAL +0.                                               04600000
      *                                                                 04610000
           PERFORM 8610-WRITE-BUS-CUST-STATS THRU 8610-EXIT.            
      *                                                                 04630000
           PERFORM 8620-WRITE-ACCT-BILL-NMES THRU 8620-EXIT             
              VARYING WS-NMES-INDX    FROM 1 BY 1                       
              UNTIL  WS-NMES-INDX GREATER THAN 20                       
              OR    WS-ACCOUNT-NO-AB (WS-NMES-INDX)                     
                EQUAL +0.                                               
      *                                                                 04690000
           PERFORM 8630-WRITE-CONTACT        THRU 8630-EXIT.            
      *                                                                 04710000
           PERFORM 8640-WRITE-ADDR-FORMATTED THRU 8640-EXIT             
              VARYING WS-FMTD-INDX    FROM 1 BY 1                       
              UNTIL  WS-FMTD-INDX GREATER THAN 20                       
              OR    WS-ADDRESS-ID-DY (WS-FMTD-INDX)                     
                EQUAL +0.                                               
      *                                                                 04770000
           PERFORM 8650-WRITE-ADDR-FREEFORM  THRU 8650-EXIT             
              VARYING WS-FREE-INDX    FROM 1 BY 1                       
              UNTIL  WS-FREE-INDX GREATER THAN 20                       
              OR    WS-ADDRESS-ID-DZ (WS-FREE-INDX)                     
                EQUAL +0.                                               
      *                                                                 04830000
           PERFORM 8660-WRITE-CREDIT-PROFILE THRU 8660-EXIT.            
      *                                                                 04850000
DP111      PERFORM 8670-WRITE-SHORT-TERM-AGMT THRU 8670-EXIT.           
      *                                                                 04870000
DP129      PERFORM 8680-WRITE-PROJECT-SHARE  THRU 8680-EXIT.            
      *                                                                 04890000
           PERFORM 8700-WRITE-PEAK-HIST THRU 8700-EXIT                  
              VARYING WS-PH-INDX  FROM 1 BY 1                           
              UNTIL  WS-PH-INDX GREATER THAN 24                         
                 OR  WS-ACCOUNT-NO-PH (WS-PH-INDX) = ZERO.              
      *                                                                 04940000
           IF WS-ACCOUNT-NO-IP > ZERO                                   
              PERFORM 8710-WRITE-INTERRUPT-ACCT THRU 8710-EXIT
           END-IF.         
      *                                                                 04970000
           IF WS-ACCOUNT-NO-SE > ZERO                                   
              PERFORM 8720-STDBY-GENERATOR-ACCT THRU 8720-EXIT
           END-IF.         
      *                                                                 05000000
           PERFORM 8730-WRITE-INTERRUPT THRU 8730-EXIT                  
              VARYING WS-INTR-INDX  FROM 1 BY 1                         
              UNTIL  WS-INTR-INDX GREATER THAN 10                       
                 OR  WS-ACCOUNT-NO-IR (WS-INTR-INDX) = ZERO.            
      *                                                                 05050000
6081       PERFORM 8740-WRITE-FINAL-WO  THRU 8740-EXIT                  
6081          VARYING WS-FW-INDX  FROM 1 BY 1                           
6081          UNTIL  WS-FW-INDX GREATER THAN 10                         
6081             OR  WS-ACCOUNT-NO-FW (WS-FW-INDX) = ZERO.              
      *                                                                 05100000
           PERFORM 8750-WRITE-EPP-HIST THRU 8750-EXIT                   
              VARYING WS-EPP-INDX  FROM 1 BY 1                          
A03850        UNTIL  WS-EPP-INDX GREATER THAN 4.                        
      *                                                                 05150000
           PERFORM 8760-WRITE-RATE-COMP THRU 8760-EXIT                  
              VARYING WS-RC-INDX  FROM 1 BY 1                           
              UNTIL  WS-RC-INDX GREATER THAN 10                         
                 OR  WS-ACCOUNT-RC (WS-RC-INDX) = ZERO.                 
      *                                                                 05200000
           PERFORM 8770-WRITE-REFUND THRU 8770-EXIT                     
              VARYING WS-RN-INDX  FROM 1 BY 1                           
T12261        UNTIL  WS-RN-INDX GREATER THAN 20                         
                 OR  WS-ACCOUNT-NO-RN (WS-RN-INDX) = ZERO.              
C34569*                                                                 05300000
T33924     PERFORM 8780-WRITE-BILLADJ THRU 8780-EXIT                    
T33924        VARYING WS-ADJUSTMNT-INDEX FROM 1 BY 1                    
T33924        UNTIL  WS-ADJUSTMNT-INDEX GREATER THAN 20                 
T33924           OR  WS-ACCOUNT-NO-BP (WS-ADJUSTMNT-INDEX) = ZERO.      
C34569*                                                                 05300000
C34569     PERFORM 8850-WRITE-FF-AREA  THRU 8850-EXIT                   
C34569        VARYING WS-BI-FF-INDX FROM 1 BY 1                         
C34569        UNTIL  WS-BI-FF-INDX GREATER THAN 200                     
C34569        OR    WS-BI-ACCOUNT-NO-FF (WS-BI-FF-INDX) = ZERO.         
C34569*                                                                 05350000
C34569     PERFORM 8820-WRITE-MKTTIER THRU 8820-EXIT                    
C34569        VARYING WS-TIER-INDX    FROM 1 BY 1                       
C34569        UNTIL   WS-TIER-INDX    GREATER THAN 25                   
C34569           OR  WS-ACCOUNT-NO-DD (WS-TIER-INDX) = ZERO.            
C34569*                                                                 05400000
C34569     PERFORM 8790-WRITE-RTPKAGR THRU 8790-EXIT                    
C34569        VARYING WS-RTPK-INDX    FROM 1 BY 1                       
C34569        UNTIL   WS-RTPK-INDX    GREATER THAN 25                   
C34569           OR  WS-ACCOUNT-NO-DF (WS-RTPK-INDX) = ZERO.            
C34569*                                                                 05450000
C34569     PERFORM 8830-WRITE-ACCTATTR THRU 8830-EXIT                   
C34569        VARYING WS-ATTR-INDX    FROM 1 BY 1                       
C34569        UNTIL   WS-ATTR-INDX    GREATER THAN 25                   
C34569           OR  WS-ACCOUNT-NO-YP (WS-ATTR-INDX) = ZERO.            
C34569*                                                                 05500000
C34569     PERFORM 8840-WRITE-BT-AREA  THRU 8840-EXIT                   
C34569        VARYING WS-BDET-INDX    FROM 1 BY 1                       
C34569        UNTIL   WS-BDET-INDX    GREATER THAN 30                   
C34569           OR  WS-ACCOUNT-NO-BT (WS-BDET-INDX) = ZERO.            
C34569*                                                                 05550000
P00166     IF LS-PROCESS-UNIQUE-ID AND WS-ACCOUNT-NO-MW > ZERO          
P00166        PERFORM 8860-WRITE-CORR-MAIL-STAT THRU 8860-EXIT          
P00166     END-IF.                                                      
P00166*                                                                 05590000
P00453     MOVE WS-CODES-DATA-PRESENT-AT TO WS-CODES-DATA-PRESENT       
P00453     IF SEB-DATABASE AND WS-CODE-PRE-PAY-PLAN = WS-ACTIVE         
P00453        PERFORM 8870-WRITE-PRE-PAY-HIST   THRU 8870-EXIT          
P00453        VARYING WS-PK-INDX  FROM 1 BY 1                           
P00453          UNTIL WS-PK-INDX GREATER THAN WS-PK-MAX-ENTRY           
P00453             OR WS-ACCOUNT-NO-PK (WS-PK-INDX) = ZERO              
P00453     END-IF.                                                      
P00453*                                                                 05593000
       1100-EXIT.                                                       
           EXIT.                                                        
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  ** 05620000
      *                                                              ** 05630000
      *    3200-WRITE-BE01-DATA                                      ** 05640000
      *                                                              ** 05650000
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  ** 05660000
       1200-WRITE-BE01-DATA.                                            
           PERFORM 8300-WRITE-UTILITY THRU 8300-EXIT                    
              VARYING WS-UTIL-INDX     FROM 1 BY 1                      
              UNTIL  WS-UTIL-INDX GREATER THAN 40                       
              OR    WS-PREMISE-NO-UT (WS-UTIL-INDX)                     
                EQUAL +0.                                               
      *                                                                 05730000
           PERFORM 8310-WRITE-MTRD-ENVRNMT THRU 8310-EXIT               
              VARYING WS-MTRD-INDX     FROM 1 BY 1                      
C23632        UNTIL  WS-MTRD-INDX GREATER THAN WS-MAX-MN-ENTRIES        
              OR    WS-ACCOUNT-NO-MN (WS-MTRD-INDX)                     
                EQUAL +0.                                               
      *                                                                 05790000
           PERFORM 8320-WRITE-CUST-PLAN  THRU 8320-EXIT                 
              VARYING WS-CUST-PLAN-INDX FROM 1 BY 1                     
I00177        UNTIL  WS-CUST-PLAN-INDX GREATER THAN                     
I00177               WS-CP-MAX-ENTRY                                    
              OR    WS-ACCOUNT-NO-CP (WS-CUST-PLAN-INDX)                
                EQUAL +0.                                               
      *                                                                 05860000
           PERFORM 8330-WRITE-REG-READ THRU 8330-EXIT                   
              VARYING WS-REG-RD-INDX FROM 1 BY 1                        
              UNTIL  WS-REG-RD-INDX GREATER THAN 20                     
              OR    WS-ACCOUNT-NO-RG (WS-REG-RD-INDX)                   
                EQUAL +0.                                               
      *                                                                 05920000
           PERFORM 8340-WRITE-MTR-CAP   THRU 8340-EXIT                  
              VARYING WS-MTR-CAP-INDX FROM 1 BY 1                       
C23632        UNTIL  WS-MTR-CAP-INDX GREATER THAN WS-MAX-MC-ENTRIES     
              OR    WS-METER-NO-MC (WS-MTR-CAP-INDX)                    
                EQUAL SPACES.                                           
      *                                                                 05980000
C34569*    PERFORM 8350-WRITE-FIXED-FCTR THRU 8350-EXIT                 05990000
C34569*       VARYING WS-FF-INDX FROM 1 BY 1                            06000000
C34569*       UNTIL  WS-FF-INDX GREATER THAN 20                         06010000
C34569*       OR    WS-ACCOUNT-NO-FF (WS-FF-INDX)                       06020000
C34569*         EQUAL +0.                                               06030000
      *                                                                 05980000
           PERFORM 8360-WRITE-UTL-BILL-REL THRU 8360-EXIT               
              VARYING WS-UR-INDX FROM 1 BY 1                            
P00251        UNTIL  WS-UR-INDX GREATER THAN WS-MAX-UR-ENTRIES          
              OR    WS-ACCOUNT-NO-DEP-UR (WS-UR-INDX)                   
                EQUAL +0.                                               
      *                                                                 06100000
           PERFORM 8370-WRITE-USAGE-HIST THRU 8370-EXIT                 
              VARYING WS-USAGE-HIST-INDX FROM 1 BY 1                    
C23632        UNTIL  WS-USAGE-HIST-INDX GREATER THAN WS-MAX-CX-ENTRIES  
              OR    WS-ACCOUNT-NO-UH (WS-USAGE-HIST-INDX)               
                EQUAL +0.                                               
      *                                                                 06160000
           PERFORM 8375-WRITE-CNT-DETAIL THRU 8375-EXIT                 
              VARYING WS-CNT-DET-INDX FROM 1 BY 1                       
P00097        UNTIL  WS-CNT-DET-INDX > WS-EA-MAX-ENTRY                  
              OR    WS-ACCOUNT-NO-EA (WS-CNT-DET-INDX)                  
                EQUAL +0.                                               
      *                                                                 06220000
           PERFORM 8380-WRITE-METER        THRU 8380-EXIT               
              VARYING WS-EQUIP-DATA-INDX FROM 1 BY 1                    
C23632        UNTIL  WS-EQUIP-DATA-INDX GREATER THAN WS-MAX-EQ-ENTRIES  
              OR    WS-DEVICE-NO-EQ (WS-EQUIP-DATA-INDX)                
                EQUAL SPACE.                                            
P00251*                                                                 06270100
P00251     PERFORM 8390-WRITE-UTL-BI-REL-HST THRU 8390-EXIT             
P00251        VARYING WS-UX-INDX FROM 1 BY 1                            
P00251        UNTIL  WS-UX-INDX GREATER THAN WS-MAX-UX-ENTRIES          
P00251        OR    WS-ACCOUNT-NO-MST-UX (WS-UX-INDX)                   
P00251          EQUAL +0.                                               
      *                                                                 06280000
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
T19483 1300-CHECK-AMT-BILL-ITEM.                                        
T19483      IF WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX) (2:1) = '1'   
T26765       OR (SEB-DATABASE AND                                       
T26765          (WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX) (2:1) = '2' 
T26765       OR WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX) (2:1) = '3'))
PULFIX        IF ((WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) = LOW-VALUES) 
PULFIX       OR (WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) = HIGH-VALUES)) 
T19484            COMPUTE WS-TOT-AMT-BILL-ITEM  =  WS-TOT-AMT-BILL-ITEM 
T19483            + WS-AMT-BILL-ITEM-BG(WS-BILLING-INDX)                
T19483            IF WS-CREDIT-GROUP-AT NOT = 'D' AND                   
T23497                         WS-TOTAL-AR-BALANCE-AT  > 800            
T23829               IF SEB-DATABASE                                    
T23829                  AND WS-CODE-TEMP-BILL-AT = 'R'                  
T23829                   CONTINUE                                       
T23829                ELSE                                              
T19483                   MOVE 'T'             TO WS-CODE-TEMP-BILL-AT   
T23829                END-IF                                            
T19483             END-IF                                               
PULFIX          END-IF                                                  
T19483      END-IF.                                                     
T19483 1300-EXIT.                                                       
T19483     EXIT.                                                        
      /                                                                 06540000
       8100-WRITE-ACCOUNT.                                              
           MOVE WS-ACCOUNT-AT TO E-FBE00-DATA.                          
           MOVE WS-AT TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06610000
       8110-WRITE-AR-CNTRL.                                             
           IF WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX) EQUAL WS-DELETE 
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-AR-DATA (WS-AR-DATA-INDX) TO E-FBE00-DATA         
              MOVE WS-AC TO E-FBE00-TABLE-ID                            
              PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT                 
           END-IF.                                                      
       8110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06720000
       8140-WRITE-DEP-ON-HAND.                                          
           MOVE WS-DEP-ON-HAND-DATA (WS-DEP-INDX) TO E-FBE00-DATA.      
           MOVE WS-DO TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06790000
       8150-WRITE-CHRG-OFF.                                             
           MOVE WS-CHRG-OFF-DATA (WS-CHG-OFF-INDX) TO E-FBE00-DATA.     
           MOVE WS-CO TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06860000
       8160-WRITE-LIEAP.                                                
           IF  WS-ACCOUNT-NO-LI EQUAL ZERO                              
               GO TO 8160-EXIT
           END-IF.                                         
           MOVE WS-LIEAP-LI TO E-FBE00-DATA.                            
           MOVE WS-LI TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06950000
       8200-WRITE-CUSTOMER.                                             
           MOVE WS-CUSTOMER-CU TO E-FBE00-DATA.                         
           MOVE WS-CU TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07020000
       8210-WRITE-CUST-STATS.                                           
           IF  WS-CUSTOMER-NO-CE EQUAL ZERO                             
               GO TO 8210-EXIT
           END-IF.                                         
      *                                                                 07060000
           MOVE WS-CUST-STATS-CE TO E-FBE00-DATA.                       
           MOVE WS-CE TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07120000
       8220-WRITE-CUST-ALERT.                                           
           IF  WS-ACCOUNT-NO-CA EQUAL ZERO                              
               GO TO 8220-EXIT
           END-IF.                                         
           MOVE WS-CUST-ALERT-CA TO E-FBE00-DATA.                       
           MOVE WS-CA TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07210000
       8240-WRITE-BANK-EFT.                                             
           IF  WS-CUSTOMER-NO-BE EQUAL ZERO                             
               GO TO 8240-EXIT
           END-IF.                                         
           MOVE WS-BANK-EFT-BE  TO E-FBE00-DATA.                        
           MOVE WS-BE TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8240-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07300000
       8260-WRITE-SURETY-BOND.                                          
           MOVE WS-SURETY-BOND-DATA (WS-SB-INDX) TO E-FBE00-DATA.       
           MOVE WS-SB TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8260-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08160000
TP2699*8280-WRITE-ADV-COLL.                                             08170000
TP2699*    MOVE WS-ADV-COLL-DATA (WS-ADV-INDX) TO E-FBE00-DATA.         08180000
TP2699*    MOVE WS-AD TO E-FBE00-TABLE-ID.                              08190000
TP2699*    PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   08200000
TP2699*8280-EXIT.                                                       08210000
TP2699*    EXIT.                                                        08220000
      *                                                                 08230000
       8290-WRITE-PREM-HIST.                                            
           MOVE WS-CUST-PREM-HIST-DATA (WS-CH-INDX) TO E-FBE00-DATA.    
           MOVE WS-CH TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8290-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08300000
       8300-WRITE-UTILITY.                                              
           MOVE WS-UTILITY-DATA (WS-UTIL-INDX) TO E-FBE01-DATA.         
           MOVE WS-UT TO E-FBE01-TABLE-ID.                              
           PERFORM 8810-WRITE-FCSBE01 THRU 8810-EXIT.                   
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08370000
       8310-WRITE-MTRD-ENVRNMT.                                         
           MOVE WS-MTRD-ENVRNMT-DATA (WS-MTRD-INDX) TO E-FBE01-DATA.    
           MOVE WS-MN TO E-FBE01-TABLE-ID.                              
           PERFORM 8810-WRITE-FCSBE01 THRU 8810-EXIT.                   
       8310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08440000
       8320-WRITE-CUST-PLAN.                                            
           MOVE WS-CUST-PLAN-DATA (WS-CUST-PLAN-INDX) TO E-FBE01-DATA.  
           MOVE WS-CP TO E-FBE01-TABLE-ID.                              
           PERFORM 8810-WRITE-FCSBE01 THRU 8810-EXIT.                   
       8320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08510000
       8330-WRITE-REG-READ.                                             
           MOVE WS-REGISTER-READ-DATA (WS-REG-RD-INDX)                  
                           TO E-FBE01-DATA.                             
           MOVE WS-RG TO E-FBE01-TABLE-ID.                              
           PERFORM 8810-WRITE-FCSBE01 THRU 8810-EXIT.                   
       8330-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08590000
       8340-WRITE-MTR-CAP.                                              
           MOVE WS-MTR-CAP-DATA (WS-MTR-CAP-INDX) TO E-FBE01-DATA.      
           MOVE WS-MC TO E-FBE01-TABLE-ID.                              
           PERFORM 8810-WRITE-FCSBE01 THRU 8810-EXIT.                   
       8340-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08660000
C34569*8350-WRITE-FIXED-FCTR.                                           08670000
C34569*    MOVE WS-FIXED-FCTR-DATA (WS-FF-INDX) TO E-FBE01-DATA.        08680000
C34569*    MOVE WS-FF TO E-FBE01-TABLE-ID.                              08690000
C34569*    PERFORM 8810-WRITE-FCSBE01 THRU 8810-EXIT.                   08700000
C34569*8350-EXIT.                                                       08710000
C34569*    EXIT.                                                        08720000
      *                                                                 08730000
       8360-WRITE-UTL-BILL-REL.                                         
           MOVE WS-UTL-BILL-REL-DATA (WS-UR-INDX) TO E-FBE01-DATA.      
           MOVE WS-UR TO E-FBE01-TABLE-ID.                              
           PERFORM 8810-WRITE-FCSBE01 THRU 8810-EXIT.                   
       8360-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08800000
       8370-WRITE-USAGE-HIST.                                           
           MOVE WS-USAGE-HIST-DATA-WORK (WS-USAGE-HIST-INDX)            
                TO E-FBE01-DATA.                                        
           MOVE WS-UH TO E-FBE01-TABLE-ID.                              
           PERFORM 8810-WRITE-FCSBE01 THRU 8810-EXIT.                   
       8370-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08880000
       8380-WRITE-METER.                                                
           MOVE WS-EQUIP-DATA (WS-EQUIP-DATA-INDX) TO E-FBE01-DATA.     
           MOVE WS-EQ TO E-FBE01-TABLE-ID.                              
           PERFORM 8810-WRITE-FCSBE01 THRU 8810-EXIT.                   
       8380-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08950000
       8375-WRITE-CNT-DETAIL.                                           
           MOVE WS-CNT-DETAIL-DATA (WS-CNT-DET-INDX) TO E-FBE01-DATA.   
           MOVE WS-EA TO E-FBE01-TABLE-ID.                              
           PERFORM 8810-WRITE-FCSBE01 THRU 8810-EXIT.                   
       8375-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09020000
P00251 8390-WRITE-UTL-BI-REL-HST.                                       
P00251     MOVE WS-UTL-BI-REL-HST-DATA (WS-UX-INDX)  TO E-FBE01-DATA.   
P00251     MOVE WS-UX TO E-FBE01-TABLE-ID.                              
P00251     PERFORM 8810-WRITE-FCSBE01 THRU 8810-EXIT.                   
P00251 8390-EXIT.                                                       
P00251     EXIT.                                                        
P00251*                                                                 09027000
       8400-WRITE-BILLING.                                              
           IF  WS-ACCOUNT-NO-BI EQUAL ZERO                              
               GO TO 8400-EXIT
           END-IF.                                         
           MOVE WS-BILLING-BI  TO E-FBE00-DATA.                         
           MOVE WS-BI TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09110000
       8401-WRITE-BILLING-DET.                                          
PCR647     MOVE LS-CURR-REVENUE-MONTH TO                                
PCR647              WS-ACCNTING-REV-MONTH-CALC (WS-BILLING-INDX).       
           MOVE WS-BILLING-DATA (WS-BILLING-INDX) TO E-FBE00-DATA.      
           MOVE WS-BG TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
A05290     IF WS-REV-RPT-CD-BG (WS-BILLING-INDX) EQUAL 'P'              
A05290        PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1               
A05290          UNTIL WS-CNSMPTN-INDX > 200                             
A05290            IF  WS-BILLING-KEY (WS-BILLING-INDX)   =              
A05290                WS-BILLING-KEY-CX (WS-CNSMPTN-INDX)  AND          
A05290                WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) > 0            
ACT100                MOVE 'S'                                          
ACT100                  TO WS-PRV-MTR-READ-COMB-FLG-CX(WS-CNSMPTN-INDX) 
A05290            END-IF                                                
A05290        END-PERFORM                                               
A05290     END-IF.                                                      
       8401-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09200000
       8402-WRITE-BILL-RESULTS.                                         
           MOVE WS-BILL-CALC-DATA (WS-CALC-INDX) TO E-FBE00-DATA.       
           MOVE WS-BC TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8402-EXIT.                                                       
           EXIT.                                                        
P00257*                                                                 09270000
P00257 8402A-WRITE-BILL-RESULTS.                                        
P00257     MOVE WS-BILL-CALC-X-DATA (WS-CALC-X-INDX) TO E-FBE00-DATA.   
P00257     MOVE WS-XD TO E-FBE00-TABLE-ID.                              
P00257     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
P00257 8402A-EXIT.                                                      
P00257     EXIT.                                                        
      *                                                                 09295000
P00251 8402B-WRITE-VOL-DAILY.                                           
P00251     MOVE WS-VOL-DAILY-DATA (WS-ND-INDX) TO E-FBE00-DATA.         
P00251     MOVE WS-ND TO E-FBE00-TABLE-ID.                              
P00251     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
P00251 8402B-EXIT.                                                      
P00251     EXIT.                                                        
P00251*                                                                 09295800
P00411******************************************************************09295900
P00411*  ANY CHANGES TO THE LIST OF FACTOR IDS BELOW SHOULD ALSO BE    *09296000
P00411*  MADE IN PCSCA177.                                             *09296100
P00496*  Commented hard-coded factor list. Use MULTI-VRSN-BA-CD instead*09296200
P00411******************************************************************09296300
P00411*                                                                 09296400
       8403-WRITE-BILL-ADJUST.                                          
           MOVE WS-BILL-ADJ-DATA (WS-BILL-ADJ-INDX) TO E-FBE00-DATA.    
           MOVE WS-BA TO E-FBE00-TABLE-ID.                              
RATEH      IF (WS-CODE-UTIL-TYPE-BA (WS-BILL-ADJ-INDX) =  'E')          
RATEH        AND (WS-BILLING-KEY-BA(WS-BILL-ADJ-INDX) =                 
RATEH                         WS-PREV-BILLING-KEY-BA)                   
RATEH        AND (WS-FCT-RATE-VERSION-BA(WS-BILL-ADJ-INDX) NOT = '1' )  
P00496       AND (WS-MULTI-VRSN-BA-CD-BA (WS-BILL-ADJ-INDX) NOT = 'A')  
P00496*      AND (WS-FACTOR-ID-BA (WS-BILL-ADJ-INDX) NOT = 'BFACCHRG')  09320000
P00496*      AND (WS-FACTOR-ID-BA (WS-BILL-ADJ-INDX) NOT = 'RTPROPCT')  09330000
P00496*      AND (WS-FACTOR-ID-BA (WS-BILL-ADJ-INDX) NOT = 'WNA-AMT')   09331000
RATEH        CONTINUE                                                   
RATEH      ELSE                                                         
RATEH        MOVE WS-ACCOUNT-NO-BA (WS-BILL-ADJ-INDX)                   
RATEH                                    TO WS-PREV-ACCOUNT-NO-BA       
RATEH        MOVE WS-BILL-NO-BA (WS-BILL-ADJ-INDX)                      
RATEH                                    TO WS-PREV-BILL-NO-BA          
RATEH        MOVE WS-CODE-UTIL-TYPE-BA (WS-BILL-ADJ-INDX)               
RATEH                                   TO WS-PREV-CODE-UTIL-TYPE-BA    
RATEH        MOVE WS-IC-NO-BA (WS-BILL-ADJ-INDX)                        
RATEH                                      TO WS-PREV-IC-NO-BA          
RATEH        MOVE WS-BILL-ITEM-TIMESTMP-BA (WS-BILL-ADJ-INDX)           
RATEH                                  TO WS-PREV-BILL-ITEM-TIMESTMP-BA 
             PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT                  
RATEH      END-IF.                                                      
       8403-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09510000
       8405-WRITE-BILL-CNTRACT.                                         
           MOVE WS-BILL-CNTRCT-DATA (WS-BK-INDX) TO E-FBE00-DATA.       
           MOVE WS-BK TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8405-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09580000
       8407-WRITE-BX-HISTORY.                                           
           MOVE WS-BILL-CNTR-HIST-DATA (WS-BX-INDX) TO E-FBE00-DATA.    
           MOVE WS-BX TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8407-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09650000
P00496 8408-WRITE-BILL-BSLN-CNTR.                                       
P00496     MOVE WS-BILL-BSLN-CNTR-DATA (WS-LN-INDX) TO E-FBE00-DATA.    
P00496     MOVE WS-LN TO E-FBE00-TABLE-ID.                              
P00496     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
P00496 8408-EXIT.                                                       
P00496     EXIT.                                                        
P00496*                                                                 09657200
P00496 8409-WRITE-BILL-BSLN-HIST.                                       
P00496     MOVE WS-BILL-BSLN-HIST-DATA (WS-LO-INDEX) TO E-FBE00-DATA.   
P00496     MOVE WS-LO TO E-FBE00-TABLE-ID.                              
P00496     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
P00496 8409-EXIT.                                                       
P00496     EXIT.                                                        
RODFIX*                                                                 09659500
RODFIX******************************************************************09659600
RODFIX* SEARCH THRU BG TABLE TO FIND A SCEG CANCEL/REBILL.  IF FOUND,  *09659700
RODFIX* SEARCH THRU CX TABLE TO FIND A METER EXCHANGE WITH ITSELF.  IF *09659800
RODFIX* FOUND, CALL ROUTINE TO PROPERLY SORT CX'S.                     *09659900
RODFIX******************************************************************09660000
RODFIX*                                                                 09660100
RODFIX*8410-FIND-METER-EXCHANGE.                                        09660200
RODFIX*                                                                 09660300
RODFIX*    PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1                  09660400
RODFIX*      UNTIL WS-BILLING-INDX GREATER THAN WS-BG-MAX-ENTRY         09660500
RODFIX*      OR WS-ACCOUNT-NO-BG (WS-BILLING-INDX) EQUAL +0             09660600
RODFIX*        IF WS-COMPANY-NO-BG (WS-BILLING-INDX) = '01'             09660700
RODFIX*          AND WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) > SPACES    09660800
RODFIX*           PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1           09660900
RODFIX*             UNTIL WS-CNSMPTN-INDX > WS-CX-MAX-ENTRY             09661000
RODFIX*               OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) = 0         09661100
RODFIX*                IF WS-BILLING-KEY-CX (WS-CNSMPTN-INDX) =         09661200
RODFIX*                   WS-BILLING-KEY (WS-BILLING-INDX)              09661300
RODFIX*                   AND WS-PRV-MTR-READ-COMB-FLG-CX               09661400
RODFIX*                      (WS-CNSMPTN-INDX) = 'C'                    09661500
RODFIX*                        PERFORM 8411-SORT-CX THRU 8411-EXIT      09661600
RODFIX*                        SET WS-CNSMPTN-INDX TO WS-CX-MAX-ENTRY   09661700
RODFIX*                END-IF                                           09661800
RODFIX*           END-PERFORM                                           09661900
RODFIX*        END-IF                                                   09662000
RODFIX*    END-PERFORM.                                                 09662100
RODFIX*                                                                 09662200
RODFIX*8410-EXIT.                                                       09662300
RODFIX*    EXIT.                                                        09662400
RODFIX*                                                                 09662500
RODFIX******************************************************************09662600
RODFIX* SORT CX'S BY DATE READ WITHIN METER NUMBER.  THEN SORT THEM BY *09662700
RODFIX* CODE-USAGE-VALUES WITHIN DATE READ.                            *09662800
RODFIX******************************************************************09663000
RODFIX*                                                                 09663100
RODFIX*8411-SORT-CX.                                                    09663200
RODFIX*                                                                 09663300
RODFIX*    PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1                  09663400
RODFIX*      UNTIL WS-CNSMPTN-INDX > WS-CX-MAX-ENTRY                    09663500
RODFIX*        OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) = 0                09663600
RODFIX*        OR WS-BILLING-KEY-CX (WS-CNSMPTN-INDX) NOT =             09663700
RODFIX*           WS-BILLING-KEY (WS-BILLING-INDX)                      09663800
RODFIX*          SET WS-CNSMPTN-INDX2 TO WS-CNSMPTN-INDX                09663900
RODFIX*          SET WS-CNSMPTN-INDX2 UP BY 1                           09664000
RODFIX*          PERFORM VARYING WS-CNSMPTN-INDX2                       09664100
RODFIX*            FROM WS-CNSMPTN-INDX2 BY 1                           09664200
RODFIX*              UNTIL WS-CNSMPTN-INDX2 > WS-CX-MAX-ENTRY           09664300
RODFIX*               OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX2) = 0        09664400
RODFIX*               OR WS-BILLING-KEY-CX (WS-CNSMPTN-INDX2) NOT =     09664500
RODFIX*                  WS-BILLING-KEY (WS-BILLING-INDX)               09664600
RODFIX*                IF WS-BILLING-KEY-CX (WS-CNSMPTN-INDX2) =        09664700
RODFIX*                     WS-BILLING-KEY-CX (WS-CNSMPTN-INDX)         09664800
RODFIX*                 AND WS-MTR-REF-NO-CX (WS-CNSMPTN-INDX2) =       09664900
RODFIX*                     WS-MTR-REF-NO-CX (WS-CNSMPTN-INDX)          09665000
RODFIX*                 AND WS-DATE-READ-CX (WS-CNSMPTN-INDX2) <        09665100
RODFIX*                     WS-DATE-READ-CX (WS-CNSMPTN-INDX)           09665200
RODFIX*                  MOVE WS-CNSMPTN-DATA (WS-CNSMPTN-INDX)         09665300
RODFIX*                     TO WS-CNSMPTN-DATA-HOLD                     09665400
RODFIX*                  MOVE WS-CNSMPTN-DATA (WS-CNSMPTN-INDX2)        09665500
RODFIX*                     TO WS-CNSMPTN-DATA (WS-CNSMPTN-INDX)        09665600
RODFIX*                  MOVE WS-CNSMPTN-DATA-HOLD                      09665700
RODFIX*                     TO WS-CNSMPTN-DATA (WS-CNSMPTN-INDX2)       09665800
RODFIX*                END-IF                                           09665900
RODFIX*          END-PERFORM                                            09666000
RODFIX*    END-PERFORM.                                                 09666100
RODFIX*                                                                 09666200
RODFIX*    PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1                  09666300
RODFIX*      UNTIL WS-CNSMPTN-INDX > WS-CX-MAX-ENTRY                    09666400
RODFIX*        OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) = 0                09666500
RODFIX*        OR WS-BILLING-KEY-CX (WS-CNSMPTN-INDX) NOT =             09666600
RODFIX*           WS-BILLING-KEY (WS-BILLING-INDX)                      09666700
RODFIX*          SET WS-CNSMPTN-INDX2 TO WS-CNSMPTN-INDX                09666800
RODFIX*          SET WS-CNSMPTN-INDX2 UP BY 1                           09666900
RODFIX*          PERFORM VARYING WS-CNSMPTN-INDX2                       09667100
RODFIX*            FROM WS-CNSMPTN-INDX2 BY 1                           09667200
RODFIX*              UNTIL WS-CNSMPTN-INDX2 > WS-CX-MAX-ENTRY           09667300
RODFIX*               OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX2) = 0        09667400
RODFIX*               OR WS-BILLING-KEY-CX (WS-CNSMPTN-INDX2) NOT =     09667500
RODFIX*                  WS-BILLING-KEY (WS-BILLING-INDX)               09667600
RODFIX*                IF WS-BILLING-KEY-CX (WS-CNSMPTN-INDX2) =        09667700
RODFIX*                     WS-BILLING-KEY-CX (WS-CNSMPTN-INDX)         09667800
RODFIX*                 AND WS-MTR-REF-NO-CX (WS-CNSMPTN-INDX2) =       09667900
RODFIX*                     WS-MTR-REF-NO-CX (WS-CNSMPTN-INDX)          09668000
RODFIX*                 AND WS-DATE-READ-CX (WS-CNSMPTN-INDX2) =        09668100
RODFIX*                     WS-DATE-READ-CX (WS-CNSMPTN-INDX)           09668200
RODFIX*                 AND WS-CODE-USAGE-VALUES-CX (WS-CNSMPTN-INDX2) <09668300
RODFIX*                     WS-CODE-USAGE-VALUES-CX (WS-CNSMPTN-INDX)   09668400
RODFIX*                  MOVE WS-CNSMPTN-DATA (WS-CNSMPTN-INDX)         09668500
RODFIX*                     TO WS-CNSMPTN-DATA-HOLD                     09668600
RODFIX*                  MOVE WS-CNSMPTN-DATA (WS-CNSMPTN-INDX2)        09668700
RODFIX*                     TO WS-CNSMPTN-DATA (WS-CNSMPTN-INDX)        09668800
RODFIX*                  MOVE WS-CNSMPTN-DATA-HOLD                      09668900
RODFIX*                     TO WS-CNSMPTN-DATA (WS-CNSMPTN-INDX2)       09669000
RODFIX*                END-IF                                           09669100
RODFIX*          END-PERFORM                                            09669200
RODFIX*    END-PERFORM.                                                 09669300
RODFIX*8411-EXIT.                                                       09669400
RODFIX*    EXIT.                                                        09670000
      *                                                                 09902000
T13410 8410-SORT-CNSMPTN-HIST.                                          
T13410*    FIRST WRITE THE CNSMPTN FOR A METER                          09905000
T13410     IF WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX2) > 0                   
T13410        PERFORM 8415-WRITE-CNSMPTN-HIST THRU 8415-EXIT
           END-IF.           
*                                                                       
T13410*    NEXT FIND ANY OTHER CNSMPTN ROWS FOR THAT METER AND          09909000
T13410*    WRITE THEM                                                   09909100
T13410     SET WS-CNSMPTN-INDX TO WS-CNSMPTN-INDX2.                     
T13410     SET WS-CNSMPTN-INDX UP BY 1.                                 
T13410     PERFORM VARYING WS-CNSMPTN-INDX FROM WS-CNSMPTN-INDX BY 1    
T13410       UNTIL WS-CNSMPTN-INDX > 200                                
T13410         IF  WS-BILLING-KEY-CX (WS-CNSMPTN-INDX) =                
T13410             WS-BILLING-KEY-CX (WS-CNSMPTN-INDX2)                 
T13410         AND WS-METER-NO-CX (WS-CNSMPTN-INDX) =                   
T13410             WS-METER-NO-CX (WS-CNSMPTN-INDX2)                    
T13410         AND WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) > 0               
T13410            PERFORM 8412-WRITE-CNSMPTN-HIST THRU 8412-EXIT        
T13410            INITIALIZE WS-CNSMPTN-DATA (WS-CNSMPTN-INDX)          
T13410         END-IF                                                   
T13410     END-PERFORM.                                                 
*                                                                       
T13410     INITIALIZE WS-CNSMPTN-DATA (WS-CNSMPTN-INDX2).               
       8410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09911000
       8412-WRITE-CNSMPTN-HIST.                                         
           MOVE WS-CNSMPTN-DATA (WS-CNSMPTN-INDX) TO E-FBE00-DATA.      
           MOVE WS-CX TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8412-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10040000
T13410 8415-WRITE-CNSMPTN-HIST.                                         
T13410     MOVE WS-CNSMPTN-DATA (WS-CNSMPTN-INDX2) TO E-FBE00-DATA.     
T13410     MOVE WS-CX TO E-FBE00-TABLE-ID.                              
T13410     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
T13410 8415-EXIT.                                                       
T13410     EXIT.                                                        
      *                                                                 10047000
       8420-WRITE-UNMTRD-CNSMPTN.                                       
           MOVE WS-UNMTRD-CNSMPTN-DATA (WS-UNMTRD-CNSMPTN-INDX) TO      
                                  E-FBE00-DATA.                         
           MOVE WS-UC TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10120000
       8430-WRITE-FIXED-FCT-HIST.                                       
           MOVE WS-FIXED-FACTR-DATA-HIST (WS-FH-HIST-INDX) TO           
                                  E-FBE00-DATA.                         
           MOVE WS-FH TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8430-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10200000
       8500-WRITE-PREMISE.                                              
           MOVE WS-PREMISE-PR TO E-FBE00-DATA.                          
           MOVE WS-PR TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10270000
       8501-WRITE-PREMISE-INSTR.                                        
           MOVE WS-PREMISE-INSTR-PS TO E-FBE00-DATA.                    
           MOVE WS-PS TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8501-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10340000
       8502-WRITE-PREMISE-DIRECT.                                       
           MOVE WS-PREMISE-DIRECT-PP TO E-FBE00-DATA.                   
           MOVE WS-PP TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8502-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10410000
       8503-WRITE-PREMISE-PAD.                                          
           MOVE WS-PREMISE-PAD-PC TO E-FBE00-DATA.                      
           MOVE WS-PC TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8503-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10480000
       8530-WRITE-BUDGET-HIST.                                          
           IF  WS-ACCOUNT-NO-BU EQUAL ZERO                              
               GO TO 8530-EXIT
           END-IF.                                         
122294     MOVE WS-BUDGET-PLAN-BU TO E-FBE00-DATA.                      
           MOVE WS-BU TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8530-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10570000
       8540-WRITE-CONNECT-CHRG.                                         
           MOVE WS-CONNECT-CHRG-DATA (WS-CCC-INDX) TO E-FBE00-DATA.     
           MOVE WS-CC TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8540-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10640000
       8550-WRITE-DFA-ACCT.                                             
           MOVE WS-DFA-ACCT-DATA (WS-DFA-INDX) TO E-FBE00-DATA.         
           MOVE WS-DA TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10710000
       8560-WRITE-DFA-RECV.                                             
           MOVE WS-DFA-RECV-DATA (WS-DV-INDX) TO E-FBE00-DATA.          
           MOVE WS-DV TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8560-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10780000
PCR072*8570-WRITE-CIAC.                                                 10790000
PCR072*    MOVE WS-CIAC-DATA (WS-CIAC-INDX) TO E-FBE00-DATA.            10800000
PCR072*    MOVE WS-CI TO E-FBE00-TABLE-ID.                              10810000
PCR072*    PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   10820000
PCR072*8570-EXIT.                                                       10830000
PCR072*    EXIT.                                                        10840000
      *                                                                 10850000
       8580-WRITE-DEP-REQ.                                              
           MOVE WS-DEP-REQ-DATA (WS-DEP-REQ-INDX) TO E-FBE00-DATA.      
           MOVE WS-DR TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8580-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10920000
       8590-WRITE-CONTRACT.                                             
           MOVE WS-CONTRACT-DATA (WS-CNT-INDX) TO E-FBE00-DATA.         
           MOVE WS-CT TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8590-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10990000
P00577 8595-WRITE-CONTRACT-CONT.                                        
P00577     MOVE WS-CONTRACT-CONT-DATA (WS-CNTCONT-INDX)                 
P00577                               TO E-FBE00-DATA.                   
P00577     MOVE WS-1C TO E-FBE00-TABLE-ID.                              
P00577     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
P00577 8595-EXIT.                                                       
P00577     EXIT.                                                        
P00577*                                                                 11070000
       8610-WRITE-BUS-CUST-STATS.                                       
           IF  WS-CUSTOMER-NO-BS EQUAL ZERO                             
               GO TO 8610-EXIT
           END-IF.                                         
           MOVE WS-BUS-CUST-STATS-BS TO E-FBE00-DATA.                   
           MOVE WS-BS TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8610-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11160000
       8620-WRITE-ACCT-BILL-NMES.                                       
           MOVE WS-ACCT-BILL-NMES-DATA (WS-NMES-INDX) TO E-FBE00-DATA.  
           MOVE WS-AB TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8620-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11230000
       8630-WRITE-CONTACT.                                              
           IF  WS-CONTACT-ID-CN EQUAL ZERO                              
               GO TO 8630-EXIT
           END-IF.                                         
           MOVE WS-CONTACT-CN        TO E-FBE00-DATA.                   
           MOVE WS-CN TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8630-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11320000
       8640-WRITE-ADDR-FORMATTED.                                       
           MOVE WS-ADDR-FORMATTED-DATA (WS-FMTD-INDX) TO E-FBE00-DATA.  
           MOVE WS-DY                TO E-FBE00-TABLE-ID.               
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8640-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11390000
       8650-WRITE-ADDR-FREEFORM.                                        
           MOVE WS-ADDR-FREEFORM-DATA (WS-FREE-INDX) TO E-FBE00-DATA.   
           MOVE WS-DZ               TO E-FBE00-TABLE-ID.                
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8650-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11460000
       8660-WRITE-CREDIT-PROFILE.                                       
           IF  WS-ACCOUNT-NO-CZ EQUAL ZERO                              
               GO TO 8660-EXIT
           END-IF.                                         
           MOVE WS-CREDIT-PROFILE-CZ TO E-FBE00-DATA.                   
           MOVE WS-CZ TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8660-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11550000
DP111  8670-WRITE-SHORT-TERM-AGMT.                                      
           IF  WS-ACCOUNT-NO-SM EQUAL ZERO                              
               GO TO 8670-EXIT
           END-IF.                                         
           MOVE WS-SHORT-TERM-AGMT-SA  TO E-FBE00-DATA.                 
           MOVE WS-SA TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8670-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11640000
DP129  8680-WRITE-PROJECT-SHARE.                                        
           IF  WS-ACCOUNT-NO-PJ EQUAL ZERO                              
               GO TO 8680-EXIT
           END-IF.                                         
           MOVE WS-PROJECT-SHARE-PJ    TO E-FBE00-DATA.                 
           MOVE WS-PJ TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8680-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11730000
       8700-WRITE-PEAK-HIST.                                            
           MOVE WS-PEAK-HIST-DATA (WS-PH-INDX) TO E-FBE00-DATA.         
           MOVE WS-PH                TO E-FBE00-TABLE-ID.               
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11800000
       8710-WRITE-INTERRUPT-ACCT.                                       
           MOVE WS-INTERRUPT-ACCT-IP   TO E-FBE00-DATA.                 
           MOVE WS-IP TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8710-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11870000
       8720-STDBY-GENERATOR-ACCT.                                       
           MOVE WS-STANDBY-GEN-SE    TO E-FBE00-DATA.                   
           MOVE WS-SE TO E-FBE00-TABLE-ID.                              
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8720-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11940000
       8730-WRITE-INTERRUPT.                                            
           MOVE WS-INTERRUPT-DATA (WS-INTR-INDX) TO E-FBE00-DATA.       
           MOVE WS-IR                TO E-FBE00-TABLE-ID.               
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8730-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12010000
013195 8740-WRITE-FINAL-WO.                                             
6081       MOVE WS-FINAL-WO-DATA (WS-FW-INDX) TO E-FBE00-DATA.          
013195     MOVE WS-FW                TO E-FBE00-TABLE-ID.               
013195     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
013195 8740-EXIT.                                                       
013195     EXIT.                                                        
      *                                                                 12080000
       8750-WRITE-EPP-HIST.                                             
A03850     IF WS-ACCOUNT-EPP (WS-EPP-INDX) > 0                          
              MOVE WS-EPP-IC-DATA (WS-EPP-INDX) TO E-FBE00-DATA         
              MOVE WS-EPP                       TO E-FBE00-TABLE-ID     
              PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT                 
A03850     END-IF.                                                      
       8750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12150000
       8760-WRITE-RATE-COMP.                                            
           MOVE WS-RATE-COMPARE-DATA (WS-RC-INDX) TO E-FBE00-DATA.      
           MOVE WS-RC                TO E-FBE00-TABLE-ID.               
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8760-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12220000
       8770-WRITE-REFUND.                                               
           MOVE WS-REFUND-DATA (WS-RN-INDX) TO E-FBE00-DATA.            
           MOVE WS-RN                       TO E-FBE00-TABLE-ID.        
           PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
       8770-EXIT.                                                       
           EXIT.                                                        
T33924*                                                                 12290000
T33924 8780-WRITE-BILLADJ.                                              
T33924     MOVE WS-BILL-ADJUSTMNT-DATA(WS-ADJUSTMNT-INDEX) TO           
T33924          E-FBE00-DATA.                                           
T33924     MOVE WS-BP                       TO E-FBE00-TABLE-ID.        
T33924     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
T33924 8780-EXIT.                                                       
T33924     EXIT.                                                        
      *                                                                 12370000
C34569 8850-WRITE-FF-AREA.                                              
C34569     MOVE WS-BI-FIXED-FCTR-DATA (WS-BI-FF-INDX) TO E-FBE00-DATA.  
C34569     MOVE WS-FF                 TO E-FBE00-TABLE-ID.              
C34569     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
C34569 8850-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                 12440000
C34569 8790-WRITE-RTPKAGR.                                              
C34569     MOVE WS-RTPK-AGR-DATA (WS-RTPK-INDX) TO E-FBE00-DATA.        
C34569     MOVE WS-DF                 TO E-FBE00-TABLE-ID.              
C34569     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
C34569 8790-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                 12510000
C34569 8820-WRITE-MKTTIER.                                              
C34569     MOVE WS-MKT-TIER-DATA (WS-TIER-INDX) TO E-FBE00-DATA.        
C34569     MOVE WS-DD                 TO E-FBE00-TABLE-ID.              
C34569     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
C34569 8820-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                 12580000
C34569 8830-WRITE-ACCTATTR.                                             
C34569     MOVE WS-ACCT-ATTR-DATA (WS-ATTR-INDX) TO E-FBE00-DATA.       
C34569     MOVE WS-YP                 TO E-FBE00-TABLE-ID.              
C34569     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
C34569 8830-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                 12650000
C34569 8840-WRITE-BT-AREA.                                              
C34569     MOVE WS-BILL-DET-DATA (WS-BDET-INDX) TO E-FBE00-DATA.        
C34569     MOVE WS-BT                 TO E-FBE00-TABLE-ID.              
C34569     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
C34569 8840-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                 12720000
P00166 8860-WRITE-CORR-MAIL-STAT.                                       
P00166     MOVE WS-CORR-MAIL-STAT-DATA TO E-FBE00-DATA.                 
P00166     MOVE WS-MW                  TO E-FBE00-TABLE-ID.             
P00166     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
P00166 8860-EXIT.                                                       
P00166     EXIT.                                                        
P00166*                                                                 12790000
P00453 8870-WRITE-PRE-PAY-HIST.                                         
P00453     MOVE WS-PREPAY-HIST-DATA(WS-PK-INDX) TO E-FBE00-DATA.        
P00453     MOVE WS-PK                  TO E-FBE00-TABLE-ID.             
P00453     PERFORM 8800-WRITE-FCSBE00 THRU 8800-EXIT.                   
P00453 8870-EXIT.                                                       
P00453     EXIT.                                                        
P00453*                                                                 12797000
       8800-WRITE-FCSBE00.                                              
           MOVE WS-COMPANY-NO-AT        TO E-FBE00-COMPANY-NO           
           MOVE WS-ACCOUNT-NO-AT        TO E-FBE00-ACCOUNT-NO           
           MOVE WS-LOCAL-OFFICE-AT      TO E-FBE00-LOCAL-OFFICE         
           MOVE WS-PREMISE-NO-AT        TO E-FBE00-PREMISE-NO           
           MOVE WS-ACCT-XFER-TO-AT      TO E-FBE00-MST-ACCT-NO          
           MOVE WS-MST-SUB-ACCT-IND-AT  TO E-FBE00-MST-SUB-IND          
      *                                                                 12870000
           MOVE ZERO  TO  E-FBE00-SORT-SUM-FLD.                         
      *                                                                 12890000
           WRITE FIOBE00.                                               
           ADD 1 TO LS-FCSBE00-REC-CNTR                                 
           IF FBE00-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 'WRITE ERROR ON BE00. STATUS = '                     
                TO WS-MISC-MSG-TEXT                                     
              MOVE WS-FBE00-STATUS                                      
                TO WS-MISC-MSG-TEXT (32:2)                              
PCR629        MOVE +137 TO WS-MISC-CATEGORY                             
              MOVE +33 TO WS-MISC-MSG-LEN                               
              MOVE 16 TO RETURN-CODE                                    
              PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8810-WRITE-FCSBE01.                                              
           MOVE WS-COMPANY-NO-AT        TO E-FBE01-COMPANY-NO           
           MOVE WS-ACCOUNT-NO-AT        TO E-FBE01-ACCOUNT-NO           
           MOVE WS-LOCAL-OFFICE-AT      TO E-FBE01-LOCAL-OFFICE         
           MOVE WS-PREMISE-NO-AT        TO E-FBE01-PREMISE-NO           
           MOVE WS-ACCT-XFER-TO-AT      TO E-FBE01-MST-ACCT-NO          
           MOVE WS-MST-SUB-ACCT-IND-AT  TO E-FBE01-MST-SUB-IND          
           MOVE ZERO                    TO E-FBE01-SORT-SUM-FLD.        
           WRITE FIOBE01.                                               
           IF FBE01-SUCCESSFUL                                          
               ADD 1 TO LS-FCSBE01-REC-CNTR                             
           ELSE                                                         
              MOVE 'WRITE ERROR ON BE01. STATUS = '                     
                TO WS-MISC-MSG-TEXT                                     
              MOVE WS-FBE01-STATUS                                      
                TO WS-MISC-MSG-TEXT (32:2)                              
PCR629        MOVE +137 TO WS-MISC-CATEGORY                             
              MOVE +33 TO WS-MISC-MSG-LEN                               
              MOVE 16 TO RETURN-CODE                                    
              PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
           END-IF.                                                      
                                                                        
       8810-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9910-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
                                                                        
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
                                                                        
              MOVE WS-BILL-NO-BG (WS-BILLING-INDX) TO WS-BILL-NO-WQ     
              MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)               
                TO  WS-CODE-UTIL-TYPE-WQ                                
              MOVE WS-IC-NO-BG (WS-BILLING-INDX)  TO  WS-IC-NO-WQ       
              MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)                 
                TO  WS-RATE-PLAN-NO-WQ                                  
                                                                        
              COMPUTE WS-START-POS                                      
                = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1              
              MOVE WS-SUPPLEMENTAL-TXT-WQ                               
                TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)
              ADD WS-SUPPLEMENTAL-TXT-LEN-WQ                            
                TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX)                 
           END-IF.                                                      
                                                                        
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       9910-EXIT.                                                       
           EXIT.                                                        
      **                                                                13630000
       9999-BAIL-OUT.                                                   
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
