       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA115.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      **  SUBROUTINE SCSCA115 IS A COMPONENT OF PCSCA100 (BATCH      **         
      **  BILLING).                                                  **         
      **                                                             **         
      **  CALLED BY: PCSCA100 (24 HOUR BILLING DRIVER)               **         
      **                                                             **         
      **  SCSCA115 PREPARES GUARANTORS, TRANSFERS, AND CONSOLIDATED  **         
      **  BILLING TO BE UPDATED IN SCSCA113.                         **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      **          ---- BASIC SEQUENCE STRUCTURE ----                 **         
      **                                                             **         
      **  0000         MODULE CONTROL                                **         
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     **         
      **  1000 - 1999  FUNCTIONAL CONTROL                            **         
      **  2000 - 4999  DETAIL LOGIC                                  **         
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            **         
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  **         
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)**         
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)*         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS  REASON                                 **         
      **  ________  ________  ______                                 **         
      **  3/10/95     GXP     INITIAL PROGRAM VERSION                **         
TP4389**  6/3/96      KMG    TPR 4389 - FIXED CODE SO THAT AC,BG,CX, **         
TP4389**                     UC ARE FULLY INITIALIZED AND AN UPDATE  **         
TP4389**                     OR INSERT IS MOVED TO ENDING FIELD ON   **         
TP4389**                     THESE TABLES SO SCSCA114 HANDLES RECS   **         
TP4362**  6/3/96      RSN    TPR 4362 - CHANGED CODE TO ACCOUNT FOR  **         
TP4362**                     UNMETERED BILL ITEMS.                   **         
TP4345**  6/5/96      RSN    TPR 4345 - PROCESS TRANSFER FOR MEMO SUB**         
TP4505**  7/18/96     KMG    TPR 4505 - MOVE DATE ORIG BILL TO BG2   **         
TP4365**  6/13/96     LMB    TPR 4365 - REMOVE AR_TRANS_HIST-HDR&DET **         
TP4365**                     DBASE PROCESSING - PCSCA100 DOES THIS   **         
RSN2  **  7/17/96     RSN    FIX B/H TRANSFER                        **         
P0194 **  7/19/96     JRX    PCR 194 - PROCESS BALANCES TO MULTIPLE  **         
      **                     GUARANTOR ACCOUNTS IF THE CUSTOMER DOES **         
      **                     NOT PAY THE FINAL BILL.                 **         
T7881 ** 12/03/96     CSG    TPR 7881.  CHANGE ERROR CODE IN 1000-   **         
      **                     PROCESS-ACCOUNT TO A 12 INSTEAD OF A 16.**         
      **                     CREATE WORK QUEUE.                      **         
TP7995** 12/05/96     ELJ    TPR 7995.  INITIALIZE E-FWK03-RCV-CREDIT**         
      **                     -AMT AND E-FWK03-GEN-LEG-DEBIT-AMT TO 0 **         
      **                     WHEN PROCESSING CJF00103 RECORDS.       **         
TP7965**  1/06/97     ADA    CHANGES TO DO TRANSFERS OF MONEY FROM THE*         
TP7965**                     GUARANTEE ACCT TO THE GUARANTOR ACCT BY **         
TP7965**                     USING THE BE11.                         **         
T8330 **  1/29/97     CSG    CORRECTLY JOURNAL UNMETERED RECEIVABLES. *         
T7970 **  1/31/97     FSW    CORRECT CONSOLIDATE BILLING              *         
T9238 **  2/12/97     PD     INITIALIZE WK03 VARIABLES.               *         
T4940 **  2/12/97     FSW    CORRECT BE11 BG EXTRACT                  *         
T10743**  4/30/97     MJL    INITIALIZE FIOWK03.                      *         
T10789**  5/5/97      MJL    MOVE LOGIC FROM SCSCA108 TO SCSCA115 TO  *         
      **                     WRITE TRANSFER INFO TO BE11 FOR SCSCA102 *         
T10791**  6/17/92     MJL    REMOVE LOGIC TO WRITE BILL HIST TO BE10  *         
      **                     FOR SUB.  WRITE AR_CNTL ONLY.            *         
PCR408**  6/27/97     MAD    ADDED LOGIC TO ACCUMULATE THE TOTAL AMT  *         
      **                     TRANSFERRED TO GUARANTORS - WILL BE      *         
      **                     STORED IN WS-GUARANTOR-XFER-AM-FW.       *         
T11939**  7/3/97      MJL    CHANGED LOGIC TO WRITE TO PENDING_XFER   *         
      **                     INSTEAD OF BE11 FILE.                    *         
PCR526**  7/28/97     MJL    REMOVE LOGIC TO CREATE MAINT TRANS HIST  *         
      **                     FOR GUARANTOR TRANSFER.                  *         
T12586**  8/7/97      MJL    ADD LOGIC TO CREATE WORK QUEUE IF        *         
      **                     TRANSFERING RECV. TO GUARANTOR WITH TYPE *         
      **                     NSC, NSA, RCC, OR CNT (TYPES C,D,E).     *         
T12732**  8/13/97     MJL    LOAD WS-103-DETAIL-END-BAL WITH TOTAL OF *         
      **                     ALL BUCKETS FOR RECV.                    *         
T12863**  8/20/97     MJL    MOVE 0 TO AMT-UNUSED-CR ON AR CNTL OF    *         
      **                     SUB ACCOUNT AFTER TRANSFER TO MASTER.    *         
T12878**  8/21/97     MJL    TRANSFER CREDIT AS NEGATIVE AMOUNT.      *         
T13181**  9/30/97     MJL    FIX POPULATION OF FW-GUAR-XFER-AMT       *         
T13172**  10/08/97    MJL    CHANGE TRANSFER LOGICE TO TRANSFER FROM  *         
      **                     AR CONTROL INSTEAD OF BILLING DETAIL.    *         
T13536**  11/13/97    CSG    INCREASE THE SIZE OF WK03 HOLD AREA.     *         
T14027**  12/10/97    CSG    DON'T WRITE PENDING_XFER AND JOURNALS    *         
      **                     FOR $0.                                  *         
T14555**  01/28/98    RAH    INCREASE CX OCCURANCES TO 200            *         
T14271**  02/05/98    JHR    FIX TRANSFER AMT TO S9(7)V99.            *         
CSG803**  02/26/98    CSG    CHECK FOR A RECORD ON THE PENDING_XFER   *         
      **                     TABLE BEFORE THE INSERT.                 *         
T15190**  03/03/98    AMG    ADDED NULL INDICATOR TO XP-SEQUENCE-NO   *         
T15190**                     IN 8205-SELECT-MAX-SEQ-NO TO AVOID THE   *         
T15190**                     POSSIBILITY OF SQL ERROR CODE -305.      *         
PCR614**  03/30/98    CSG    ALLOW XFER OF CIA.                       *         
T15889**  04/15/98    KSB    UPDATE LAST-UPDATE-TS FOR GUARANTOR TABLE*         
PCR629**  04/24/98    AMG    CHANGED THE CATEGORIES OF SOME           *         
PCR629**                     WORK QUEUES                              *         
T16851**  06/22/98    CSG    DO NOT USE ELEC/GAS ALLOC IF BOTH DO NOT *         
      **                     EXIST.                                   *         
T17340**  09/21/98    KLP    DO NOT INSERT 9000 ROW IF NOT BEING FINAL*         
      **                     BILLED.                                  *         
T18042**  10/20/98    JER    IF "TRANSFER TO" ACCT IS A FINAL BILL OR *         
      **                     WRITE OFF, THEN CREATE WORK QUEUE        *         
T18340**  11/09/98    JER    FIXED GAS TRANSFER TO GUARANTOR ACCT.    *         
T18587**  12/01/98    RGB    CODE CHANGED TO MAKE GUARANTOR TRANSFER  *         
T18587**                     OCCUR PROPERLY FOR RECEIVABLES           *         
T18705**  12/16/98    RGB    CODE CHANGED TO MAKE DFA SET UP ON       *         
T18705**                     GUARANTOR ACCT NOT MORE THAN THE         *         
T18705**                     GUARANTEED AMOUNT                        *         
T21753**  05/12/00    CBSI   METER READ EXCEPTIONS FOR SOME SECURED   *         
T21753**             CHENNAI RATES RECEIVE WRONG WORK QUEUES          *         
T22729**  09/14/00    CBSI   GUARANTOR TRANSFER WITH GUARANTEE BEING  *         
T22729**             CHENNAI WRITE OFF ACCT, SHOULD NOT TRANSFER.     *         
T23011** 11/17/00    VIJAY   COMMENTED THE LOGIC OF CREATING  WQ      *         
      **                     IF  TRANSFERING RECV. TO GUARANTOR WITH  *         
      **                     TYPE NSC, NSA, RCC, OR CNT (TYPES C,D,E). *        
T25652** 11/27/01    VIJAY   CHANGES MADE TO TRANSFER LPC AMOUNT TO   *         
      **                     ANOTHER ACCOUNT.                                   
T28018** 01/09/03   COVANSYS IF MASTER ACCOUNT IS FINAL BILLED CREATE *         
T28018**             CHENNAI  WORK QUEUE.                             *         
T27925**  03/19/03  COVANSYS  CHANGED FILEDS DEFINED AS 9(07)         *         
      **                      TO 9(11).                               *         
T33182**  07/29/06  DB41297  PERFORMANCE IMPROVEMENTS.               *          
C33968**  10/29/06  DB41297  ADD NAICS FIELDS.                       *          
C35244**  01/25/07  DM94438  PREVENT TRANSFERS TO AN ACTIVE EPP ACCOUNT         
C35244**                     THIS WILL STOP ACCTS FROM HAVING MULTIPLE          
C35244**                     RECEIVABLES LIKE UTE,UTG,EPP AT SAMETIME           
C30169**  02/05/08  CVNS     WRITE OFF RECOVERY CHANGES.                        
      **            CHENNAI  1. GUARANTOR TRANSFER AMOUNT WILL BE               
      **                        BE UPDATED IN CSS_FIN_WO_ACTION FOR             
      **                        ACTION TYPE GAXF.                               
I00177**  01/05/09  SS97726  CHANGE WS-UNMTRD-CNSMPTN-INDX FROM       *         
I00177**                     100 TO 200 AND REMOVE IDX HARD CODING    *         
PRJ583**  02/03/09  SS97726  TRANSFER NEWLY ADDED CX FIELDS FOR METER *         
PRJ583**                     EXCHANGE WITH ITSELF PROJECT             *         
A01041**  04/30/09  CVNS     SETUP NEW G/L(184.2500) FOR MASTER/SUB   *         
A01041**            CHENNAI  ACCOUNT CLEARING.                        *         
P00166**  08/17/09  AW41078  ADDING UNIQUE IDENTIFIER TO WS-FIODB07.  *         
P00166**                     ALSO ADDING MISSING CREDIT LETTER IND.   *         
P00166**  01/11/10  AW41078  ADD PROCESS FLAG TO WS-FIODB07.          *         
A03153**  02/28/11  DB18339  REMOVED EPP REFERENCES IN WQ COMMENTS.   *         
P00599**  08/23/12  AA97148  INSERT A ROW INTO CSS_FIN_WO_ACTION FOR            
P00599**                     EVERY GUARANTOR TRANSFER THAT IS DONE HERE.        
I01959**  08/26/15  SS45239  SOLAR/RENEWABLE NET METERING 2.0         *         
ACT153**  05/09/16  VIJAY    DO NOT INCLUDE PBI MONEY.                *         
ACT153**   A05460                                                     *         
ACT311**  10/21/16  VIJAY    CORRECT INDEX VARIABLE NAME TO           *         
ACT311**   A05460            WS-AX-DATA-INDX                          *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA115'.
MSQ017     COPY MFASQLM.
       01  WS-START                        PIC X(40)                    
           VALUE 'WORKING STORAGE FOR SCSCA115 STARTS HERE'.            
      *                                                                         
       COPY FIOWK03.                                                            
      *                                                                         
TP4389 COPY CWS10013.                                                           
      *                                                                         
       01  WS-WORK-VARIABLES.                                           
FCS        05 WS-AR-INIT-CASH-KEY.                                      
FCS           10 WS-AR-COMPANY-NO          PIC X(02) VALUE '01'.        
FCS           10 WS-AR-REPORT-NO           PIC X(03) VALUE '997'.       
FCS           10 WS-AR-REPORT-DATE         PIC X(10) VALUE SPACES.      
FCS           10 WS-AR-CASH-DRAWER-ID      PIC S9(04) VALUE 9999.       
T14271     05  WS-TRANS-AMT                PIC S9(07)V99.               
           05  WS-TRANS-TYPE               PIC X(03).                   
T18042     05  WS-ACCT-TO-CODE-STAT        PIC X(01).                   
T35244     05  WS-BUDGET-FL                PIC X(01) VALUE SPACES.      
           05  WS-TRANSFER-CR-GL           PIC 9(03)V9(04).             
           05  WS-TRANSFER-DR-GL           PIC 9(03)V9(04).             
           05  WS-CLEARING-GL              PIC 9(03)V9(04).             
COB305     05 WS-ACCT-NO-TO-FROM        PIC S9(13)V COMP-3 VALUE 0.          
COB305     05 WS-XFER-TO-ACCT        PIC S9(13)V COMP-3 VALUE 0.          
T7970      05  WS-ACCOUNT-NO-PREV       PIC S9(13)V COMP-3 VALUE ZERO.  
T7970      05  WS-SEQ-NO                   PIC 9(04) VALUE ZERO.        
           05  WS-START-POS                PIC S9(4) COMP.              
T14271*    05  WS-TRANSFER-AMT             PIC S9(07)V99.                       
T27925     05  WS-TRANSFER-AMT             PIC S9(11)V99.               
COB305     05 WS-GUARANTEED-XFER-AMT        PIC S9(11)V99 COMP-3 
COB305       VALUE 0.        
TP7965*    05  WS-AMT-TO-MOVE              PIC S9(07)V99 COMP-3.                
COB305     05 WS-AMT-TO-MOVE        PIC S9(11)V99 COMP-3 VALUE 0.        
PCR408     05  WS-TOTAL-GUAR-TRANS-AMT     PIC S9(09)V99 COMP-3 VALUE 0.
COB305     05 WS-AMT-TO-POST        PIC S9(11)V99 COMP-3 VALUE 0.        
           05  WS-ITEM-ID                  PIC S9(09)  COMP.            
           05  WS-RESULT-OF-PREPD          PIC S9(07)V99  VALUE ZERO.   
           05  WS-AMT-BILLED-UNPAID-HOLD   PIC S9(07)V99  VALUE ZERO.   
           05  WS-AMT-OWED              PIC S9(07)V99 COMP-3 VALUE ZERO.
           05  WS-COMPANY-HOLD             PIC 9(02) VALUE ZERO.        
           05  WS-SUBSCRIPT-GL             PIC S9(04) VALUE ZERO.       
           05  WS-TRAN-APPL-NO             PIC S9(4) COMP.              
           05  WS-CURRENT-TIMESTAMP        PIC X(26).                   
           05  WS-TRANSFER-MSG             PIC X(30).                   
P00599     05  WS-TOT-GUAR-TRANS-AMT       PIC S9(09)V99 COMP-3 VALUE 0.
P00599     05  PROGRAM-NAME                PIC X(08) VALUE 'SCSCA115'.  
P00599     05  WS-HOST-ELEMENT             PIC X(10).                   
      *                                                                         
       01  WS-BC-KEY-FOR-POST-NO.                                       
           05  FILLER                      PIC 9(04)       VALUE 9999.  
           05  WS-BC-LOCAL-OFFICE          PIC X(03).                   
      *                                                                         
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-MESSAGE-PATTERN.                                      
               10  WS-WQ-CATEGORY-ID       PIC S9(4) COMP.              
               10  WS-WQ-PRIORITY          PIC X(1).                    
               10  WS-WQ-ROUTE-CATEGORY    PIC X(1).                    
               10  WS-WQ-MESSAGE-LENGTH    PIC S9(4) COMP.              
TP7965         10  WS-WQ-MESSAGE-TEXT      PIC X(62).                   
TP7965     05  WS-GUARANTOR-FINALLED-WQ-MSG.                            
TP7965         10  FILLER                  PIC S9(4) COMP VALUE +117.   
TP7965         10  FILLER                  PIC X(1)  VALUE 'N'.         
TP7965         10  FILLER                  PIC X(1)  VALUE '4'.         
TP7965         10  FILLER                  PIC S9(4) COMP VALUE +62.    
TP7965         10  WS-GUAR-MSG             PIC X(62).                   
T18042     05  WS-TRANSFER-TO-FINALLED-WQ-MSG.                          
T18042         10  FILLER                  PIC S9(4) COMP VALUE +17.    
T18042         10  FILLER                  PIC X(1)  VALUE 'N'.         
T18042         10  FILLER                  PIC X(1)  VALUE '4'.         
A03153         10  FILLER                  PIC S9(4) COMP VALUE +80.    
A03153         10  WS-FINALLED-MSG         PIC X(80).                   
T18042                                                                  
T12586     05  WS-GUARANTOR-RECV-WQ-MSG.                                
T12586         10  FILLER                  PIC S9(4) COMP VALUE +117.   
T12586         10  FILLER                  PIC X(1)  VALUE 'N'.         
T12586         10  FILLER                  PIC X(1)  VALUE '4'.         
T12586         10  FILLER                  PIC S9(4) COMP VALUE +118.   
T12586         10  WS-GUAR-RECV-MSG        PIC X(118).                  
T28018     05  WS-CONSLDT-XFER-WQ-MSG.                                  
T28018         10  FILLER                  PIC S9(4) COMP VALUE +4.     
T28018         10  FILLER                  PIC X(1)  VALUE 'N'.         
T28018         10  FILLER                  PIC X(1)  VALUE '4'.         
T28018         10  FILLER                  PIC S9(4) COMP VALUE +24.    
T28018         10  FILLER                  PIC X(24) VALUE              
T28018             'TRANSFER ERROR TO MASTER'.                          
           05  WS-UPDATE-PRINT-FLAG-MSG.                                
               10  FILLER                  PIC S9(4) COMP VALUE +17.    
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +47.    
               10  FILLER                  PIC X(47) VALUE              
                   'UPD PRT FLAG IF BILL IMMEDIATELY IS NOT DESIRED'.   
           05  WS-TRANS-ACCT-HAS-RCV-MSG.                               
PCR629         10  FILLER                  PIC S9(4) COMP VALUE +4.     
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +47.    
               10  FILLER                  PIC X(38) VALUE              
                   'TRANSFER ACCT NO. HAS RECEIVABLES'.                 
           05  WS-DATABASE-EXCEPTION.                                   
PCR629         10  FILLER                  PIC S9(4) COMP VALUE +137.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +29.    
               10  FILLER                  PIC X(30) VALUE              
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-MISCELLANEOUS-MESSAGE.                                
PCR629         10  WS-MISC-CATEGORY        PIC S9(4) COMP VALUE +17.    
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  WS-MISC-MSG-LEN         PIC S9(4) COMP VALUE +60.    
               10  WS-MISC-MSG-TEXT        PIC X(60).                   
      *                                                                         
TP7965 01  WS-GUAR-MSG-PART1               PIC X(19) VALUE              
TP7965     'GUARANTOR FINALLED('.                                       
T22729 01  WS-GUAR-MSG-PART2               PIC X(19) VALUE              
T22729     'GUARANTOR WRITEOFF('.                                       
TP7965 01  WS-GUAR-MSG-ACCOUNT.                                         
TP7965     05  WS-GUAR-MSG-ACCOUNT-NUM     PIC 9(13).                   
TP7965 01  WS-GUAR-MSG-PART3               PIC X(30) VALUE              
TP7965     '), NO TRANSFER FROM GUARANTEE '.                            
      *                                                                         
T12586 01  WS-GUAR-RECV-MSG-PART1          PIC X(53) VALUE              
T12586     'GUARANTEED ACCT HAS NSC, NSA, RCC OR CNT RECEIVABLES '.     
T12586 01  WS-GUAR-RECV-MSG-PART2          PIC X(52) VALUE              
T12586     'THAT HAVE NOT BEEN TRANSFERED TO THE GUARANTOR ACCT '.      
T12586 01  WS-GUAR-RECV-MSG-ACCOUNT.                                    
T12586     05  WS-GUAR-RECV-ACCOUNT        PIC 9(13).                   
      *                                                                         
A03153 01  WS-FINAL-MSG-PART.                                           
A03153     05  WS-FINAL-MSG-PART1               PIC X(51) VALUE         
A03153  'CANNOT TRANSFER TO FINALBILL OR WRITEOFF OR BUDGET'.           
A03153     05  WS-FINAL-MSG-PART2               PIC X(16) VALUE         
A03153  'BILLING ACCOUNT '.                                             
T18042 01  WS-TRANSFER-TO-MSG-ACCOUNT.                                  
T18042     05  WS-TRANSFER-TO-MSG-ACCOUNT-NUM     PIC 9(13).            
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      *                                                                         
      **     THE WORK VARIABLE AREA IS USED FOR TRANSIENT DATA. IT   **         
      **     IS INITIALIZED ON EACH CALL TO THE SUBROUTINE.          **         
      **     THE OTHER WORK AREAS ARE INITIALIZED UNDER PROGRAM      **         
      **     CONTROL.  ADD ANY NEW DATA FIELDS ACCORDINGLY.          **         
      **                                                             **         
      /****************************************************************         
      **     THE FOLLOWING ARE A REPRESENTATIVE SAMPLING.  ADD ITEMS **         
      **     AS NECESSARY; DELETE THOSE WHICH YOU DO NOT USE.  DO    **         
      **     ===NOT=== USE DATA NAMES SUCH AS 'WS-A' (VALUE 'A').    **         
      **     USE A NAME THAT IS DESCRIPTIVE.                         **         
      **                                                             **         
       01  WS-CONSTANTS.                                                
           05  WS-NORMAL-BILL              PIC X(1)    VALUE 'A'.       
           05  WS-FINAL-BILL               PIC X(1)    VALUE 'B'.       
           05  WS-WRITE-OFF                PIC X(1)    VALUE 'S'.       
           05  WS-INSERT                   PIC X(1)    VALUE 'I'.       
           05  WS-DELETE                   PIC X(1)    VALUE 'D'.       
           05  WS-UPDATE                   PIC X(1)    VALUE 'U'.       
           05  WS-YES                      PIC X(1)    VALUE 'Y'.       
           05  WS-NO                       PIC X(1)    VALUE 'N'.       
           05  WS-KWH                      PIC X(1)    VALUE 'B'.       
           05  WS-COMBINED                 PIC X(1)    VALUE 'C'.       
           05  WS-SEPARATE                 PIC X(1)    VALUE 'D'.       
           05  WS-COGEN                    PIC X(1)    VALUE 'D'.       
           05  WS-DEBIT                    PIC X(1)    VALUE 'D'.       
           05  WS-EST                      PIC X(1)    VALUE 'E'.       
           05  WS-KVA                      PIC X(1)    VALUE 'E'.       
           05  WS-CANNOT-EST               PIC X(1)    VALUE 'F'.       
           05  WS-KW                       PIC X(1)    VALUE 'J'.       
           05  WS-INACT                    PIC X(1)    VALUE 'J'.       
           05  WS-INSUFFICIENT-USAGE-DAYS  PIC X(1)    VALUE 'J'.       
           05  WS-INACT-OFF                PIC X(1)    VALUE 'K'.       
           05  WS-CALC-ERROR               PIC X(1)    VALUE 'K'.       
           05  WS-MISC                     PIC X(1)    VALUE 'Z'.       
           05  WS-XW                       PIC X(2)    VALUE ' W'.      
           05  WS-WARNING                  PIC X(1)    VALUE 'W'.       
           05  WS-REJECT                   PIC X(1)    VALUE 'R'.       
           05  WS-ELE                      PIC X(1)    VALUE 'E'.       
           05  WS-GAS                      PIC X(1)    VALUE 'G'.       
           05  WS-SUB                      PIC X(1)    VALUE 'S'.       
           05  WS-CR                       PIC X(1)    VALUE 'C'.       
           05  WS-DR                       PIC X(1)    VALUE 'D'.       
           05  WS-103                   PIC S9(5)  COMP-3 VALUE +00103. 
           05  WS-1                        PIC S9 COMP-3 VALUE +1.      
           05  WS-X                        PIC X(01)   VALUE 'X'.       
           05  WS-F                        PIC X(01)   VALUE 'F'.       
           05  WS-S                        PIC X(01)   VALUE 'S'.       
           05  WS-T                        PIC X(01)   VALUE 'T'.       
           05  WS-ASCENDING                PIC X(01)   VALUE 'A'.       
           05  WS-BILL                     PIC X(04)   VALUE 'BILL'.    
           05  WS-BATCH                    PIC X       VALUE 'B'.       
           05  WS-TO                       PIC X       VALUE 'T'.       
           05  WS-FROM                     PIC X       VALUE 'F'.       
           05  WS-UTE                     PIC S9(3)  COMP-3 VALUE +040. 
           05  WS-UTG                     PIC S9(3)  COMP-3 VALUE +045. 
CBK002     05  WS-NSC                     PIC S9(3)  COMP-3 VALUE +019. 
           05  WS-NSA                     PIC S9(3)  COMP-3 VALUE +020. 
           05  WS-DFA                     PIC S9(3)  COMP-3 VALUE +090. 
           05  WS-LPC                     PIC S9(3)  COMP-3 VALUE +030. 
CBK002     05  WS-RCC                     PIC S9(3)  COMP-3 VALUE +060. 
           05  WS-CNT                     PIC S9(3)  COMP-3 VALUE +100. 
PCR614     05  WS-CIA                     PIC S9(3)  COMP-3 VALUE +070. 
           05  WS-ACTIVE                   PIC X       VALUE 'A'.       
           05  WS-PREPAY                   PIC X       VALUE 'P'.       
           05  WS-ADJ                      PIC X       VALUE 'A'.       
           05  WS-COMPANY-IN-TABLE         PIC X       VALUE 'N'.       
           05  WS-GUARANTEE                PIC X       VALUE 'E'.       
TP7965     05  WS-90-DAY                   PIC X       VALUE '9'.       
TP7965     05  WS-60-DAY                   PIC X       VALUE '6'.       
TP7965     05  WS-30-DAY                   PIC X       VALUE '3'.       
TP7965     05  WS-00-DAY                   PIC X       VALUE '0'.       
TP7965     05  WS-CANCELLED                PIC X       VALUE 'C'.       
T12586     05  WS-CONTRACT-TYPE-CODES.                                  
T12586         10  WS-SERVICE-CHARGE       PIC X VALUE 'C'.             
T12586         10  WS-ENDV-CHARGE          PIC X VALUE 'D'.             
T12586         10  WS-MISC-CHARGE          PIC X VALUE 'E'.             
SP7965                                                                  
TP7965 01  WS-GUAR-BILLED-MSG              PIC X(20) VALUE              
TP7965     'GUARANTOR BILLED.   '.                                      
TP7965 01  WS-GUAR-FB-AMT-PAID-MSG         PIC X(20) VALUE              
TP7965     'FINAL BILL AMT PAID.'.                                      
      *                                                                         
       01  WS-NSA-AR-INDX                  USAGE INDEX.                 
       01  WS-DFA-AR-INDX                  USAGE INDEX.                 
       01  WS-LPC-AR-INDX                  USAGE INDEX.                 
      /****************************************************************         
      **     PUT ANY PROGRAM SWITCH VARIABLES YOU NEED HERE.  IF     **         
      **     POSSIBLE, INCLUDE AT LEAST TWO CONDITION NAMES. IN THE  **         
      **     PROCEDURE DIVISION, USE "SET CONDITION-NAME TO TRUE"    **         
      **     RATHER THAN "MOVE 'Y' TO INDICATOR-VARIABLE-NAME"       **         
      **                                                             **         
       01  WS-SWITCHES-AND-INDICATORS.                                  
           05  WS-EXCEPTION-INDICATOR      PIC X(1).                    
               88  NO-EXCEPTIONS           VALUE '0'.                   
               88  EXCEPTION-ENCOUNTERED   VALUE '1'.                   
      *                                                                         
           05  WS-SUCCESSFUL-BILL-IND      PIC X(01).                   
               88  SUCCESSFUL-BILL         VALUE 'Y'.                   
               88  UNSUCCESSFUL-BILL       VALUE 'N'.                   
TP7965*                                                                         
TP7965     05  WS-GUARANTOR-BILLED-SW      PIC X(01).                   
TP7965         88  WS-GUARANTOR-BILLED     VALUE 'Y'.                   
TP7965         88  WS-GUARANTOR-NOT-BILLED VALUE 'N'.                   
TP7965*                                                                         
TP7965     05  WS-MOVING-UTG-SW            PIC X(01).                   
TP7965         88  WS-MOVING-UTG           VALUE 'Y'.                   
TP7965         88  WS-NOT-MOVING-UTG       VALUE 'N'.                   
      *                                                                         
I01959     05  WS-TRANSFER-TO-ASSIGNEE     PIC X(01).                   
I01959         88  TRANSFER-TO-ASSIGNEE    VALUE 'Y'.                   
I01959         88  NO-TRANSFER-TO-ASSIGNEE VALUE 'N'.                   
      *                                                                         
           05  WS-HAS-UTE                  PIC X(01).                   
               88  HAS-UTE                 VALUE 'Y'.                   
               88  NO-UTE                  VALUE 'N'.                   
      *                                                                         
           05  WS-HAS-UTG                  PIC X(01).                   
               88  HAS-UTG                 VALUE 'Y'.                   
               88  NO-UTG                  VALUE 'N'.                   
      *                                                                         
           05  WS-HAS-LPC                  PIC X(01).                   
               88  HAS-LPC                 VALUE 'Y'.                   
               88  NO-LPC                  VALUE 'N'.                   
T12586*                                                                         
T12586     05  WS-GUAR-RECV-WQ-IND         PIC X(01).                   
T12586         88  CREATE-GUAR-RECV-WQ     VALUE 'Y'.                   
T12586         88  NO-GUAR-RECV-WQ         VALUE 'N'.                   
      *                                                                         
      *                                                                         
           05  WS-CNTRL-REC-FLAG           PIC X(01)     VALUE 'N'.     
      *                                                                         
           05  WS-PYMT-LVL-CHECK           PIC 9(04).                   
               88 LPC         VALUE 030.                                
               88 LPN         VALUE 039.                                
               88 UTE         VALUE 040.                                
               88 UTG         VALUE 045.                                
               88 UTW         VALUE 047.                                
               88 BUD         VALUE 050.                                
               88 CCC         VALUE 060.                                
               88 DFA         VALUE 090.                                
               88 CIA         VALUE 070.                                
               88 DEP         VALUE 080.                                
               88 CNT         VALUE 100.                                
               88 RVC         VALUE 110.                                
               88 NSF         VALUE 020.                                
               88 NSA         VALUE 020.                                
               88 NSN         VALUE 029.                                
               88 NSC         VALUE 019.                                
               88 PJS         VALUE 129.                                
      *                                                                         
           05  WS-AR-AGE                   PIC X(01) VALUE 'N'.         
      *                                                                         
           05  WS-HOLD-INDX                PIC S9(04) VALUE ZEROES.     
      *                                                                         
T15190 01  WS-NULL-INDICATORS.                                          
T15190     05  NULL-VALUE                  PIC S9(4) COMP  VALUE -1.    
T15190     05  XP-SEQUENCE-NO-IND          PIC S9(4) COMP.              
      *                                                                         
       01  WS-COUNTERS.                                                 
           05  WS-CURRENT-WQ-ITEM          PIC S9(04)  COMP VALUE ZERO. 
      *                                                                         
TP7965 01  WS-AR-CNTRL-AC3-START               PIC X(36) VALUE          
TP7965     'WS-AR-CNTRL-AC3 STARTS HERE*********'.                      
TP7965 01  WS-AC-TABLE3.                                                
TP7965    05  WS-AR-DATA-AC3 OCCURS 5 TIMES                             
TP7965                       INDEXED BY WS-AR-DATA-INDX3                
TP7965                                  WS-UTE-AR-INDX3                 
TP7965                                  WS-UTG-AR-INDX3                 
TP7965                                  WS-LPC-AR-INDX3.                
TP7965     10  WS-AR-CNTRL-KEY-AC3.                                     
COB305         15 WS-ACCOUNT-NO-AC3        PIC S9(13)V COMP-3 VALUE 0.   
TP7965         15  WS-PYMT-PRIORITY-LVL-AC3    PIC S9(04)     COMP.     
TP7965         15  WS-ITEM-ID-AC3              PIC S9(09)     COMP.     
COB305     10 WS-AMT-AR-DAY-00-AC3        PIC S9(09)V99 COMP-3 VALUE 0.   
COB305     10 WS-AMT-AR-DAY-30-AC3        PIC S9(09)V99 COMP-3 VALUE 0.   
COB305     10 WS-AMT-AR-DAY-60-AC3        PIC S9(09)V99 COMP-3 VALUE 0.   
COB305     10 WS-AMT-AR-DAY-90-AC3        PIC S9(09)V99 COMP-3 VALUE 0.   
COB305     10 WS-AMT-UNUSED-CR-AC3        PIC S9(09)V99 COMP-3 VALUE 0.   
COB305     10 WS-AMT-TRAN-BALANCE-AC3        PIC S9(09)V99 COMP-3 
COB305          VALUE 0.   
COB305     10 WS-TOT-SUMM-UNBILLED-AC3        PIC S9(09)V99 COMP-3 
COB305          VALUE 0.   
TP7965     10  WS-LAST-UPDATE-TS-AC3           PIC X(26).               
TP7965*** NOT ON AC TABLE                                                       
COB305     10 WS-TOT-NEW-CHRGS-CALC-AC3        PIC S9(09)V99 COMP-3 
COB305          VALUE 0.   
TP7965     10  WS-CURRENT-LT-25-DAYS-CALC-AC3  PIC X(1).                
TP7965     10  WS-UPDATE-ACTION-IND-AC3        PIC X(1).                
TP7965     10  WS-XFER-TO-GUARANTOR-IND-AC3    PIC X(1).                
TP7965     10  FILLER                          PIC X(410).              
TP7965*                                                                         
       01  WS-FWK03-STATUS                 PIC X(02) EXTERNAL.          
           88  FWK03-SUCCESSFUL            VALUE '00'.                  
      /********************************************************                 
      *                                                       *                 
      *   WORKING STORAGE FOR WQ MESSAGE TEXT (IF APPLICABLE) *                 
      *   EACH MESSAGE WILL HAVE ITS OWN TEXT.                *                 
      *                                                       *                 
      *********************************************************                 
       01  WS-WQ-MESSAGE-TXT.                                           
           05  WS-WORK-QUQ-MESSAGE-1       PIC X(30)                    
               VALUE '  THIS IS A REAL PROBLEM      '.                  
                                                                        
      /*****************************************************************        
      *                                                                *        
      *  WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS              *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWS00013                                                 
           END-EXEC.                                                            
      *                                                                         
P00599******************************************************************        
P00599*  WORKING STORAGE COPY BOOKS FOR CPD00348                       *        
P00599******************************************************************        
P00599                                                                  
P00599     EXEC SQL                                                             
P00599         INCLUDE CWS00348                                                 
P00599     END-EXEC.                                                            
P00599                                                                  
      /*****   SQL WORK VARIABLES                                               
       COPY CWS00303.                                                           
      /*****   JOURNAL FORMAT 103                                               
       COPY CJF00103.                                                           
      ****** CODES DATA PRESENT                                                 
       COPY CWS00056.                                                           
      ****** PAYMENT APPLICATION WORKING STORAGE                                
       COPY CWS00017.                                                           
      /****** CWS00070 HAS BILLING WORK QUEUE LAYOUTS                           
      *******  VARIABLES ARE USED AS HOST VARIABLES IS THE                      
      *******  IT IS USED LIKE THIS INSTEAD OF JUST A 'COPY'                    
      *                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR SCSCA115 START HERE '.               
      /*****************************************************************        
      *   TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS      *        
      *   (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM      *        
      *   WILL ALWAYS BE SQLCA.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBBJCNTL                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBMSTSUB                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBGTNTR                                                  
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
TP7965/* DCLGEN FOR CSS_AR_PMT_PRTY                                             
TP7965     EXEC SQL                                                             
TP7965         INCLUDE TBARPMT                                                  
TP7965     END-EXEC.                                                            
P00599******************************************************************        
P00599* DCLGEN FOR CSS_FIN_WO_ACTION - KD                              *        
P00599******************************************************************        
P00599                                                                  
P00599     EXEC SQL                                                             
P00599         INCLUDE TBFWACTN                                                 
P00599     END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
T11939         INCLUDE TBPENXFR                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE CWS0070B                                                
           END-EXEC.                                                            
      /                                                                         
       LINKAGE SECTION.                                                 
      /*****   LS-PCSCS100-COMM-AREA                                            
           COPY CWS0024B.                                                       
      /                                                                         
       01  WS-HOLD-WK03.                                                
COB305     03 WS-WK03-TOTAL-AR-BAL        PIC S9(9)V99 COMP-3 VALUE 0.         
           03  WS-WK03-COUNT               PIC S9(4) COMP.              
           03  WS-HOLD-WK03-DATA           PIC X(220)                   
T13536            OCCURS 5000 TIMES                                     
                  INDEXED BY WK03-INDX.                                 
      /                                                                         
       01  WS-FIODB07.                                                  
COB305     05 WS-FDB07-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.           
           05  WS-FDB07-PROCESS-CONTROL.                                
               10  WS-ON-OFF-CYCLE-IND          PIC X(1).               
                   88  WS-OFF-CYCLE-FINAL        VALUE 'B'.             
                   88  WS-OFF-CYCLE-REBILL       VALUE 'O'.             
                   88  WS-ON-CYCLE-BILL          VALUE 'A'.             
                   88  WS-APPLY-LPC-ONLY         VALUE 'L'.             
TP4569             88  WS-OFF-CYCLE-ACCT-TRANS   VALUE 'T'.             
TF1            10  WS-SINGLE-ITEM-BILL-IND      PIC X(1).               
TF1                88  WS-SINGLE-ITEM-BILL       VALUE 'S'.             
               10  WS-MASTER-ACCOUNT-IND        PIC X(1).               
                   88  WS-MASTER-ACCOUNT         VALUE 'M'.             
               10  WS-REFUND-CONTROL-IND        PIC X(1).               
                   88  WS-PROCESS-REFUND         VALUE 'R'.             
               10  WS-GUARANTEE-TRANSFER-IND    PIC X(1).               
                   88  WS-TRANSFER-GUARANTEE     VALUE 'E'.             
                   88  WS-TRANSFER-GUARANTOR     VALUE 'G'.             
           05  WS-FDB07-NO-BILL-CYCLES          PIC S9(4) COMP.         
TF1        05  WS-FDB07-PYMT-PRIORITY-LVL       PIC S9(4) COMP.         
TF1        05  WS-FDB07-ITEM-ID                 PIC S9(9) COMP.         
P00166     05  WS-FDB07-CREDIT-LETTER-IND       PIC X(01).              
P00166     05  WS-FDB07-BARCODE-UNIQUE-ID       PIC X(09).              
P00166     05  WS-PROCESS-UNIQUE-ID-FL          PIC X(01) VALUE 'N'.    
P00166         88 WS-PROCESS-UNIQUE-ID                    VALUE 'Y'.    
P00166         88 WS-DO-NOT-PROCESS-UNIQUE-ID             VALUE 'N'.    
T19317 01  LS-TRAN-SUCCESSFUL-FL   PIC X(1).                            
                                                                        
      /*****   BILL EXTRACT (BE00)                                              
           COPY CWS1000A.                                                       
C30169     COPY CWS1000B.                                                       
           COPY CWS100XX.                                                       
      /*****   BILL EXTRACT (BE01)                                              
           COPY CWS1001A.                                                       
           COPY CWS1001B.                                                       
      /*****   GL-NUMBERS TABLE                                                 
           COPY CWS00061.                                                       
P00599 01  WS-NEXT-DATE            PIC X(10).                           
      *                                                                         
      ********************************************************                  
      *                                                       *                 
      *    DECLARING GUARANTOR-CURSOR                         *                 
      *                                                       *                 
      ********************************************************                  
      *                                                                         
           EXEC SQL                                                     
                DECLARE   GUARANTOR_CURSOR CURSOR FOR                   
                SELECT    GUARNTR_ACCT_NO,                              
                          AMOUNT_GUARANTEED,                            
                          GUAR_ESTBLSH_DT,                              
                          SERVICE_TYPE_CD                               
                FROM      CSS_GUARANTOR                                 
                WHERE     ACCOUNT_NO     = :GU-ACCOUNT-NO               
                AND       GUAR_STATUS_CD = :WS-ACTIVE                   
                ORDER BY GUAR_ESTBLSH_DT                                
           END-EXEC.                                                    
      *                                                                         
       PROCEDURE DIVISION USING LS-PCSCA100-COMM-AREA                   
                                WS-FIODB07                              
                                WS-ACCOUNT-AT                           
                                WS-PREMISE-PR                           
                                WS-CUSTOMER-CU                          
                                WS-CUST-PLAN-TABLE-CP                   
                                WS-BILLING-BG                           
                                WS-BILLING-BI                           
                                WS-CNSMPTN-HIST-CX                      
                                WS-UNMTRD-CNSMPTN-UC                    
                                WS-AR-CNTRL-AC                          
                                WS-BILLING-WQ-ITEMS-WF                  
T12586                          WS-CONTRACT-CT                          
PCR408                          WS-FINAL-WO-FW                          
                                WS-GL-ACCT-NO-TABLE                     
                                WS-HOLD-WK03                            
T19317                          LS-TRAN-SUCCESSFUL-FL                   
C30169                          WS-FINAL-WO-ACTN-KD                     
C30169                          WS-FINAL-WO-COLL-IZ                     
I00177                          WS-CWS1000B-MAX-TBL-LIMITS              
P00599                          WS-NEXT-DATE                            
I01959                          WS-AR-CNTRL-ASGNE-XFER-AX.              
      *                                                                         
      /*****************************************************************        
      *                                                                *        
      *     0000-MAINLINE                                              *        
      *                                                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
           MOVE ZERO TO RETURN-CODE.                                    
I00177     INITIALIZE WS-SQL-ERROR-TXT-WQ.                              
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
           PERFORM 1000-PROCESS-ACCOUNT THRU 1000-EXIT.                 
      *                                                                         
           EXIT PROGRAM.                                                
      ******************************************************************        
      *                                                                *        
      *     0100-INITIALIZATION                                        *        
      *    SET ALL CONDITION NAMES TO THEIR DEFAULT VALUES             *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
           INITIALIZE WS-WORK-VARIABLES                                 
                      WS-AC-TABLE                                       
                      WS-BG-TABLE                                       
                      WS-CX-TABLE                                       
                      WS-UC-TABLE                                       
TP7965                WS-AC-TABLE3                                      
                      CJF00103.                                         
      *                                                                         
           SET WS-GL-SUB TO 1                                           
           SEARCH WS-CO-GL-ACCT-NO-ENTRIES                              
               AT END                                                   
                  SET WS-GL-SUB TO 1                                    
               WHEN WS-COMPANY-NO-AT = WS-GL-COMPANY-NO (WS-GL-SUB)     
                  CONTINUE                                              
           END-SEARCH.                                                  
      *                                                                         
           MOVE WS-CODES-DATA-PRESENT-AT TO WS-CODES-DATA-PRESENT.      
      *                                                                         
           PERFORM 7500-GET-CURRENT-TIMESTAMP THRU 7500-EXIT.           
      *                                                                         
           MOVE WS-NO TO WS-HAS-UTG                                     
                         WS-HAS-UTE                                     
                         WS-HAS-LPC.                                    
I01959     SET NO-TRANSFER-TO-ASSIGNEE   TO TRUE.                       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************        
      *                                                                *        
      *     1000-PROCESS-ACCOUNT                                       *        
      *       THIS DECIDES WHICH TYPE OF TRANSFER IS TAKING PLACE      *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-ACCOUNT.                                            
           INITIALIZE FIOWK03                                           
           EVALUATE TRUE                                                
               WHEN WS-MST-SUB-ACCT-IND-AT = WS-SUB                     
                  IF (WS-AR-XFER-IND-AT = WS-YES                        
TP4345               AND WS-BILL-HIST-XFER-IND-AT = WS-YES)             
                     AND WS-ACCT-XFER-TO-AT NOT EQUAL ZEROES            
                     MOVE 'TRANSFER TO MASTER ' TO WS-TRANSFER-MSG      
                     PERFORM 1050-CONSLDT-TRANSFER THRU 1050-EXIT       
                  ELSE                                                  
RSN2                 IF WS-BILL-HIST-XFER-IND-AT EQUAL WS-YES           
RSN2                  AND WS-AR-XFER-IND-AT NOT EQUAL WS-YES            
RSN2                  AND WS-ACCT-XFER-TO-AT NOT EQUAL ZEROES           
RSN2                   PERFORM 1300-TRANSFER-BILL-HIST THRU 1300-EXIT   
RSN2                 ELSE                                               
T7881                  MOVE 12 TO RETURN-CODE                           
T7881                  MOVE 'NO TRANSFER INDICATOR SET FOR SUB ACCOUNT' 
T7881                           TO WS-MISC-MSG-TEXT                     
PCR629                 MOVE +4 TO WS-MISC-CATEGORY                      
T7881                  MOVE +41 TO WS-MISC-MSG-LEN                      
T7881                  PERFORM 9910-MISC-ERROR THRU 9910-EXIT           
RSN2                 END-IF                                             
                  END-IF                                                
               WHEN WS-TRANSFER-GUARANTEE                               
                  MOVE 'TRANSFER TO GUARANTOR' TO WS-TRANSFER-MSG       
                  PERFORM 1500-TRANSFER-GUARANTOR THRU 1500-EXIT        
I01959**** TRANSFER PBI/BCA TO ASSIGNEE ****                                    
I01959         WHEN WS-COGEN-AR-XFER-IND EQUAL 'Y'                      
I01959            IF WS-XFER-TO-ASSIGNEE-ACCT NOT EQUAL 0               
I01959               MOVE 'TRANSFER TO ASSIGNEE' TO WS-TRANSFER-MSG     
I01959               SET  TRANSFER-TO-ASSIGNEE   TO TRUE                
I01959               PERFORM 1075-XFER-TO-ASSIGNEE  THRU 1075-EXIT      
I01959            END-IF                                                
               WHEN OTHER                                               
                  MOVE 'TRANSFER UTILITY' TO WS-TRANSFER-MSG            
                  PERFORM 1070-REGULAR-TRANSFER THRU 1070-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 1050-CONSLDT-TRANSFER                                        *          
      *    THE FOLLOWING MOVES THE AR-CNTRL TO THE MASTER-ACCOUNT    *          
      *                                                              *          
      ****************************************************************          
       1050-CONSLDT-TRANSFER.                                           
T28018     MOVE WS-ACCT-XFER-TO-AT TO WS-XFER-TO-ACCT                   
T28018     PERFORM 7400-GET-CODE-ACCT-STAT    THRU 7400-EXIT.           
T28018     IF WS-ACCT-TO-CODE-STAT EQUAL WS-FINAL-BILL OR WS-WRITE-OFF  
T28018        PERFORM 1595-CREATE-FINAL-XFER-WQ THRU 1595-EXIT          
T28018        MOVE 'N' TO LS-TRAN-SUCCESSFUL-FL                         
T28018     ELSE                                                         
              PERFORM VARYING WS-AR-DATA-INDX FROM 1 BY 1               
P00097          UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY                 
                   OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZERO         
T13172           IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)           
T13172             = WS-UTE OR WS-UTG                                   
PCR614                   OR WS-CIA                                      
T25652                   OR WS-LPC                                      
                    PERFORM 1200-TRANSFER-OTHER THRU 1200-EXIT          
T13172           END-IF                                                 
T28018        END-PERFORM                                               
T28018     END-IF.                                                      
      *                                                                         
       1050-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 1070-REGULAR-TRANSFER                                         *         
      *      TRANSFERS UTILITY FOR REGULAR TRANSFERS THE REST OF THE  *         
      *      RECEIVABLES ARE DONE ONLINE                              *         
      *                                                               *         
      *****************************************************************         
       1070-REGULAR-TRANSFER.                                           
T18042     MOVE WS-ACCT-XFER-TO-AT TO WS-XFER-TO-ACCT                   
T18042     PERFORM 7400-GET-CODE-ACCT-STAT    THRU 7400-EXIT.           
T18042     IF WS-ACCT-TO-CODE-STAT EQUAL WS-FINAL-BILL OR WS-WRITE-OFF  
C35244     OR (WS-BUDGET-FL = 'A' AND                                   
C35244         WS-ACCT-TO-CODE-STAT EQUAL WS-NORMAL-BILL)               
T18042        PERFORM 1590-CREATE-FINAL-XFER-TO-WQ THRU 1590-EXIT       
KDFKDF        MOVE 'N' TO LS-TRAN-SUCCESSFUL-FL                         
T18042     ELSE                                                         
              PERFORM VARYING WS-AR-DATA-INDX FROM 1 BY 1               
P00097          UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY                 
                   OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZERO         
T13172           IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)           
T13172             = WS-UTE OR WS-UTG                                   
PCR614                      OR WS-CIA                                   
T25652                      OR WS-LPC                                   
T13172              PERFORM 1200-TRANSFER-OTHER  THRU 1200-EXIT         
T13172           END-IF                                                 
              END-PERFORM                                               
              IF WS-BILL-HIST-XFER-IND-AT = WS-YES                      
                 PERFORM 1300-TRANSFER-BILL-HIST THRU 1300-EXIT         
T13172        END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1070-EXIT.                                                       
           EXIT.                                                        
I01959*****************************************************************         
I01959*                                                               *         
I01959* 1075-XFER-TO-ASSIGNEE.                                        *         
I01959*      TRANSFERS PBI/BCA TO ASSIGNEE ACCOUNT                    *         
I01959*                                                               *         
I01959*****************************************************************         
I01959 1075-XFER-TO-ASSIGNEE.                                           
I01959                                                                  
I01959     MOVE WS-XFER-TO-ASSIGNEE-ACCT   TO WS-XFER-TO-ACCT.          
I01959     PERFORM 7400-GET-CODE-ACCT-STAT         THRU 7400-EXIT.      
I01959     IF WS-ACCT-TO-CODE-STAT EQUAL WS-FINAL-BILL OR WS-WRITE-OFF  
I01959        OR (WS-BUDGET-FL = 'A' AND                                
I01959            WS-ACCT-TO-CODE-STAT EQUAL WS-NORMAL-BILL)            
I01959        PERFORM 1590-CREATE-FINAL-XFER-TO-WQ THRU 1590-EXIT       
I01959        MOVE 'N'                     TO LS-TRAN-SUCCESSFUL-FL     
I01959     ELSE                                                         
I01959        PERFORM VARYING WS-AX-DATA-INDX FROM 1 BY 1               
I01959                  UNTIL WS-AX-DATA-INDX > 50                      
I01959                     OR WS-ACCOUNT-NO-AX (WS-AX-DATA-INDX) = ZERO 
I01959           IF WS-PYMT-PRIORITY-LVL-AX (WS-AX-DATA-INDX)           
I01959                                           = WS-UTE OR WS-CIA     
I01959              INITIALIZE WS-AC-TABLE                              
I01959                         E-FWK03-RCV-CREDIT-AMT                   
I01959                         E-FWK03-RCV-DEBIT-AMT                    
I01959                         E-FWK03-GEN-LEG-DEBIT-AMT                
I01959                         E-FWK03-GEN-LEG-CREDIT-AMT               
ACT311              MOVE WS-PYMT-PRIORITY-LVL-AX (WS-AX-DATA-INDX)      
I01959                   TO WS-PYMT-LVL-CHECK                           
I01959              MOVE WS-CLR-AR-XFR-GL-NO (WS-GL-SUB)                
I01959                   TO WS-CLEARING-GL                              
I01959              PERFORM 1215-MOVE-TO-ASSIGNEE  THRU 1215-EXIT       
I01959              PERFORM 1225-JOURNAL-XFER-ASSIGNEE                  
I01959                                             THRU 1225-EXIT       
I01959           END-IF                                                 
I01959        END-PERFORM                                               
I01959     END-IF.                                                      
I01959*                                                                         
I01959 1075-EXIT.                                                       
I01959     EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 1200-TRANSFER-OTHER                                          *          
      *                                                              *          
      ****************************************************************          
       1200-TRANSFER-OTHER.                                             
           INITIALIZE WS-AC-TABLE                                       
                      WS-BG-TABLE                                       
                      WS-CX-TABLE                                       
                      WS-UC-TABLE                                       
TP7995                E-FWK03-RCV-CREDIT-AMT                            
TP9238                E-FWK03-RCV-DEBIT-AMT                             
TP7995                E-FWK03-GEN-LEG-DEBIT-AMT                         
TP9238                E-FWK03-GEN-LEG-CREDIT-AMT.                       
           MOVE WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)               
                TO WS-PYMT-LVL-CHECK.                                   
A01041     IF WS-MST-SUB-ACCT-IND-AT = 'S'                              
A01041        MOVE WS-CLR-MSTSUB-GL-NO (WS-GL-SUB) TO WS-CLEARING-GL    
A01041     ELSE                                                         
              MOVE WS-CLR-AR-XFR-GL-NO (WS-GL-SUB) TO WS-CLEARING-GL    
A01041     END-IF                                                       
           PERFORM 1210-MOVE-TO-MASTER THRU 1210-EXIT                   
           PERFORM 1220-JOURNAL-SUB-OTHER THRU 1220-EXIT.               
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      *                                                             *           
      *   1210-MOVE-TO-MASTER                                       *           
      *                                                             *           
      ***************************************************************           
       1210-MOVE-TO-MASTER.                                             
           MOVE WS-ACCT-XFER-TO-AT TO WS-ACCOUNT-NO-AC2.                
           MOVE WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)               
                TO WS-PYMT-PRIORITY-LVL-AC2.                            
           IF BUD                                                       
              MOVE WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)             
                   TO WS-AMT-TRAN-BALANCE-AC2                           
           ELSE                                                         
PCR614*       IF WS-ITEM-ID GREATER THAN ZERO                                   
PCR614        IF WS-ITEM-ID-AC (WS-AR-DATA-INDX) GREATER THAN ZERO      
                 MOVE WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)             
                      TO WS-AMT-TRAN-BALANCE-AC2                        
PCR614           ADD WS-TOT-SUMM-UNBILLED-AC (WS-AR-DATA-INDX)          
PCR614                TO WS-AMT-TRAN-BALANCE-AC2                        
PCR614           ADD WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)              
PCR614                TO WS-AMT-TRAN-BALANCE-AC2                        
PCR614        ELSE                                                      
PCR614           MOVE 0 TO WS-AMT-TRAN-BALANCE-AC2                      
              END-IF                                                    
           END-IF.                                                      
T13172*  MOVE ZERO DAY, SUM UNBILLED TO SUM UNBILLED OF TRANSFER 'TO'           
T13172*  ACCOUNT.  MOVE AMOUNT UNUSED CREDIT.                                   
T14027     IF WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX) = 0                 
T14027       AND WS-TOT-SUMM-UNBILLED-AC (WS-AR-DATA-INDX) = 0          
T14027       AND WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) = 0              
T14027        CONTINUE                                                  
T14027     ELSE                                                         
              MOVE WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)                
                TO WS-TOT-SUMM-UNBILLED-AC2                             
T13172        ADD WS-TOT-SUMM-UNBILLED-AC (WS-AR-DATA-INDX)             
T13172          TO WS-TOT-SUMM-UNBILLED-AC2                             
T13172        MOVE WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)                
T13172          TO WS-AMT-UNUSED-CR-AC2                                 
              MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID-AC2    
              PERFORM 8100-WRITE-MASTER-AR-CNTRL THRU 8100-EXIT         
T14027     END-IF.                                                      
       1210-EXIT.                                                       
           EXIT.                                                        
I01959***************************************************************           
I01959*                                                             *           
I01959*   1215-MOVE-TO-ASSIGNEE.                                    *           
I01959*                                                             *           
I01959***************************************************************           
I01959 1215-MOVE-TO-ASSIGNEE.                                           
I01959                                                                  
I01959     MOVE WS-XFER-TO-ASSIGNEE-ACCT  TO WS-ACCOUNT-NO-AC2.         
I01959     MOVE WS-PYMT-PRIORITY-LVL-AX (WS-AX-DATA-INDX)               
I01959                                    TO WS-PYMT-PRIORITY-LVL-AC2.  
I01959     MOVE 0                         TO WS-AMT-TRAN-BALANCE-AC2.   
I01959     IF WS-AMT-AR-DAY-00-AX (WS-AX-DATA-INDX) = 0                 
I01959        AND WS-TOT-SUMM-UNBILLED-AX (WS-AX-DATA-INDX) = 0         
I01959        AND WS-AMT-UNUSED-CR-AX (WS-AX-DATA-INDX) = 0             
I01959        CONTINUE                                                  
I01959     ELSE                                                         
I01959        MOVE WS-AMT-AR-DAY-00-AX (WS-AX-DATA-INDX)                
I01959                                    TO WS-TOT-SUMM-UNBILLED-AC2   
I01959        ADD  WS-TOT-SUMM-UNBILLED-AX (WS-AX-DATA-INDX)            
I01959                                    TO WS-TOT-SUMM-UNBILLED-AC2   
I01959        MOVE WS-AMT-UNUSED-CR-AX (WS-AX-DATA-INDX)                
I01959                                    TO WS-AMT-UNUSED-CR-AC2       
I01959        MOVE WS-AMT-TRAN-BALANCE-AX (WS-AX-DATA-INDX)             
I01959                                    TO WS-AMT-TRAN-BALANCE-AC2    
I01959        MOVE WS-ITEM-ID-AX (WS-AX-DATA-INDX)                      
I01959                                    TO WS-ITEM-ID-AC2             
I01959        PERFORM 8100-WRITE-MASTER-AR-CNTRL THRU 8100-EXIT         
I01959     END-IF.                                                      
I01959                                                                  
I01959 1215-EXIT.                                                       
I01959     EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 1220-JOURNAL-SUB-OTHER                                      *           
      * TAKING RECEIVABLES OUT OF SUB AND MOVE TO CLEARING           *          
      *                                                              *          
      ****************************************************************          
       1220-JOURNAL-SUB-OTHER.                                          
T13172*  ADD AMOUNTS IN ZERO DAY, UNUSED CREDIT, AND SUM UNBILLED               
T13172*  TO TRANSFER AMOUNT.                                                    
T14027     IF WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX) = 0 AND             
T14027        WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) = 0 AND             
T14027        WS-TOT-SUMM-UNBILLED-AC (WS-AR-DATA-INDX) = 0             
T14027          GO TO 1220-EXIT                                         
T14027     END-IF.                                                      
T13172     MOVE WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)                   
T13172          TO WS-TRANSFER-AMT.                                     
T13172     ADD WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)                    
T13172          TO WS-TRANSFER-AMT.                                     
T13172     ADD WS-TOT-SUMM-UNBILLED-AC (WS-AR-DATA-INDX)                
T13172          TO WS-TRANSFER-AMT.                                     
           IF BUD                                                       
              MOVE ZEROES TO WS-AMT-TRAN-BALANCE-AC2                    
           ELSE                                                         
PCR614        IF WS-ITEM-ID-AC (WS-AR-DATA-INDX) GREATER THAN           
                 ZERO                                                   
                 SUBTRACT WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)         
PCR614                   WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)          
PCR614                   WS-TOT-SUMM-UNBILLED-AC (WS-AR-DATA-INDX) FROM 
PCR614*              WS-AMT-TRAN-BALANCE-AC2                                    
                     WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)           
              END-IF                                                    
           END-IF.                                                      
T13172*  CLEAR OUT RECIEVABLE FOR TRANSFER 'FROM' ACCOUNT                       
           MOVE ZEROES TO WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)         
T13172                    WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)         
T13172                    WS-TOT-SUMM-UNBILLED-AC (WS-AR-DATA-INDX)     
           MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID.          
           INITIALIZE CJF00103.                                         
T13172*    MOVE WS-ADJ TO WS-AR-AGE.                                            
T13172     MOVE SPACES TO WS-AR-AGE.                                    
           MOVE WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) TO            
                WS-PYMT-LVL-CHECK                                       
                WS-PYMT-PRIORITY-LVL-AC2.                               
           PERFORM 5110-SELECT-GL-FROM-OTHER THRU 5110-EXIT.            
           MOVE WS-ACCT-XFER-TO-AT TO WS-ACCT-NO-TO-FROM.               
           MOVE WS-TOTAL-AR-BALANCE-AT TO WS-103-ACCT-END-AR-BAL.       
           SUBTRACT WS-TRANSFER-AMT FROM WS-103-ACCT-END-AR-BAL.        
T13172     IF WS-TRANSFER-AMT < 0                                       
T13172        COMPUTE WS-TRANSFER-AMT = 0 - WS-TRANSFER-AMT             
T13172        MOVE WS-TRANSFER-AMT TO E-FWK03-RCV-DEBIT-AMT             
T13172                                E-FWK03-GEN-LEG-CREDIT-AMT        
T13172     ELSE                                                         
T13172        MOVE WS-TRANSFER-AMT TO E-FWK03-RCV-CREDIT-AMT            
T13172                                E-FWK03-GEN-LEG-DEBIT-AMT         
T13172     END-IF.                                                      
           PERFORM 2200-WRITE-TRANSFER-JRNL THRU 2200-EXIT.             
       1220-EXIT.                                                       
           EXIT.                                                        
I01959****************************************************************          
I01959*                                                              *          
I01959* 1225-JOURNAL-XFER-ASSIGNEE.                                  *          
I01959* TAKING RECEIVABLES FOR PBI/BCA AND MOVE TO CLEARING          *          
I01959*                                                              *          
I01959****************************************************************          
I01959 1225-JOURNAL-XFER-ASSIGNEE.                                      
I01959*  ADD AMOUNTS IN ZERO DAY, UNUSED CREDIT, AND SUM UNBILLED               
I01959*  TO TRANSFER AMOUNT.                                                    
I01959     IF WS-AMT-AR-DAY-00-AX (WS-AX-DATA-INDX) = 0 AND             
I01959        WS-AMT-UNUSED-CR-AX (WS-AX-DATA-INDX) = 0 AND             
I01959        WS-TOT-SUMM-UNBILLED-AX (WS-AX-DATA-INDX) = 0             
I01959        GO TO 1225-EXIT                                           
I01959     END-IF.                                                      
I01959     MOVE WS-AMT-AR-DAY-00-AX (WS-AX-DATA-INDX)                   
I01959          TO WS-TRANSFER-AMT.                                     
I01959     ADD WS-AMT-UNUSED-CR-AX (WS-AX-DATA-INDX)                    
I01959          TO WS-TRANSFER-AMT.                                     
I01959     ADD WS-TOT-SUMM-UNBILLED-AX (WS-AX-DATA-INDX)                
I01959          TO WS-TRANSFER-AMT.                                     
I01959*  CLEAR OUT RECIEVABLE FOR TRANSFER 'FROM' ACCOUNT                       
I01959     MOVE ZEROES TO WS-AMT-AR-DAY-00-AX (WS-AX-DATA-INDX)         
I01959                    WS-AMT-UNUSED-CR-AX (WS-AX-DATA-INDX)         
I01959                    WS-TOT-SUMM-UNBILLED-AX (WS-AX-DATA-INDX)     
I01959     MOVE WS-ITEM-ID-AX (WS-AX-DATA-INDX)                         
I01959          TO WS-ITEM-ID.                                          
I01959     INITIALIZE CJF00103.                                         
I01959     MOVE 'F'    TO WS-AR-AGE.                                    
I01959     MOVE WS-PYMT-PRIORITY-LVL-AX (WS-AX-DATA-INDX)               
I01959          TO WS-PYMT-LVL-CHECK                                    
I01959             WS-PYMT-PRIORITY-LVL-AC2.                            
I01959     PERFORM 5110-SELECT-GL-FROM-OTHER THRU 5110-EXIT.            
I01959     MOVE WS-XFER-TO-ASSIGNEE-ACCT  TO WS-ACCT-NO-TO-FROM.        
I01959     MOVE WS-TOTAL-AR-BALANCE-AT    TO WS-103-ACCT-END-AR-BAL.    
ACT153***  SUBTRACT WS-TRANSFER-AMT FROM WS-103-ACCT-END-AR-BAL.                
I01959     IF WS-TRANSFER-AMT < 0                                       
I01959        COMPUTE WS-TRANSFER-AMT = 0 - WS-TRANSFER-AMT             
I01959        MOVE WS-TRANSFER-AMT        TO E-FWK03-RCV-DEBIT-AMT      
I01959                                       E-FWK03-GEN-LEG-CREDIT-AMT 
I01959     ELSE                                                         
I01959        MOVE WS-TRANSFER-AMT        TO E-FWK03-RCV-CREDIT-AMT     
I01959                                       E-FWK03-GEN-LEG-DEBIT-AMT  
I01959     END-IF.                                                      
I01959     PERFORM 2200-WRITE-TRANSFER-JRNL  THRU 2200-EXIT.            
I01959                                                                  
I01959 1225-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 1300-TRANSFER-BILL-HIST                                       *         
      *                                                               *         
      *****************************************************************         
       1300-TRANSFER-BILL-HIST.                                         
           IF WS-ACCT-XFER-TO-AT GREATER THAN ZERO                      
              NEXT SENTENCE                                             
           ELSE                                                         
              GO TO 1300-EXIT                                           
           END-IF.                                                      
      *                                                                         
           PERFORM 1310-TRANSFER-BILLING  THRU  1310-EXIT               
                   VARYING WS-BILLING-INDX FROM 1 BY 1                  
                   UNTIL WS-BILLING-INDX GREATER THAN 30 OR             
                         WS-ACCOUNT-NO-BG (WS-BILLING-INDX)             
                         EQUAL ZERO.                                    
                                                                        
           PERFORM 1320-TRANSFER-CNSMPTN      THRU 1320-EXIT            
                   VARYING  WS-CNSMPTN-INDX FROM 1 BY 1                 
T14555             UNTIL  WS-CNSMPTN-INDX  GREATER THAN 200 OR          
                   WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) EQUAL  ZERO.      
                                                                        
           PERFORM 1330-TRANSFER-UNMTRD-CNSMPTN   THRU 1330-EXIT        
                 VARYING  WS-UNMTRD-CNSMPTN-INDX FROM 1 BY 1            
I00177           UNTIL  WS-UNMTRD-CNSMPTN-INDX  GREATER THAN            
I00177                  WS-UC-MAX-ENTRY OR                              
                 WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX) EQUAL  ZERO. 
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 1310-TRANSFER-BILLING                                        *          
      *    TRANSFER BG DATA                                          *          
      *                                                              *          
      ****************************************************************          
       1310-TRANSFER-BILLING.                                           
           INITIALIZE WS-BG-TABLE.                                      
T4940      MOVE WS-ACCOUNT-NO-BG     (WS-BILLING-INDX)    TO            
T4940           WS-ACCOUNT-NO-BG2.                                      
T4940      MOVE WS-BILL-NO-BG        (WS-BILLING-INDX)    TO            
T4940           WS-BILL-NO-BG2.                                         
           MOVE WS-CODE-SUB-TOTAL-BG (WS-BILLING-INDX)                  
                                   TO WS-CODE-SUB-TOTAL-BG2.            
           MOVE WS-CODE-UTIL-TYPE-BG     (WS-BILLING-INDX)    TO        
                WS-CODE-UTIL-TYPE-BG2.                                  
           MOVE WS-IC-NO-BG              (WS-BILLING-INDX)    TO        
                WS-IC-NO-BG2.                                           
TP4505     MOVE WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX)        TO        
TP4505          WS-DATE-ORIG-BILL-BG2.                                  
           MOVE WS-CODE-BILL-ITM-TYPE-BG (WS-BILLING-INDX)    TO        
                WS-CODE-BILL-ITM-TYPE-BG2.                              
           MOVE WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)    TO        
                WS-BILL-ITEM-TIMESTMP-BG2                               
                                                                        
           IF WS-AR-XFER-IND-AT EQUAL WS-YES AND                        
              WS-BILL-HIST-XFER-IND-AT EQUAL WS-YES                     
              MOVE WS-T TO WS-CODE-BILL-ITM-IND-BG2                     
           ELSE                                                         
              MOVE WS-S TO WS-CODE-BILL-ITM-IND-BG2                     
           END-IF.                                                      
                                                                        
           MOVE WS-S TO WS-CODE-BILL-CALC-BG2.                          
           MOVE WS-COMPANY-NO-BG         (WS-BILLING-INDX) TO           
                WS-COMPANY-NO-BG2.                                      
           MOVE WS-PREMISE-NO-BG         (WS-BILLING-INDX) TO           
                WS-PREMISE-NO-BG2.                                      
           MOVE WS-CODE-DR-CR-CNSMPTN-BG (WS-BILLING-INDX) TO           
                WS-CODE-DR-CR-CNSMPTN-BG2.                              
           MOVE WS-CODE-STAT-TAX-XMT-BG  (WS-BILLING-INDX) TO           
                WS-CODE-STAT-TAX-XMT-BG2.                               
           MOVE WS-CODE-CITY-TAX-XMT-BG  (WS-BILLING-INDX) TO           
                WS-CODE-CITY-TAX-XMT-BG2.                               
           MOVE WS-CODE-OTHR-TAX-XMT-BG  (WS-BILLING-INDX) TO           
                WS-CODE-OTHR-TAX-XMT-BG2.                               
           MOVE WS-RATE-PLAN-NO-BG       (WS-BILLING-INDX) TO           
                WS-RATE-PLAN-NO-BG2.                                    
           MOVE WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX) TO           
                WS-CODE-REVENUE-CLASS-BG2.                              
           MOVE WS-CODE-SIC-NO-BG        (WS-BILLING-INDX) TO           
                WS-CODE-SIC-NO-BG2.                                     
C33968     MOVE WS-NAICS-CD-BG           (WS-BILLING-INDX) TO           
C33968          WS-NAICS-CD-BG2.                                        
           MOVE WS-CODE-CURTAIL-PRTY-BG  (WS-BILLING-INDX) TO           
                WS-CODE-CURTAIL-PRTY-BG2.                               
           MOVE WS-AMT-BILL-ITEM-BG      (WS-BILLING-INDX) TO           
                WS-AMT-BILL-ITEM-BG2.                                   
           MOVE WS-AMT-STATE-TAX-BG      (WS-BILLING-INDX) TO           
                WS-AMT-STATE-TAX-BG2.                                   
           MOVE WS-AMT-CITY-TAX-BG       (WS-BILLING-INDX) TO           
                WS-AMT-CITY-TAX-BG2.                                    
           MOVE WS-AMT-OTHER-TAX-BG      (WS-BILLING-INDX) TO           
                WS-AMT-OTHER-TAX-BG2.                                   
           MOVE WS-REV-RPT-CD-BG         (WS-BILLING-INDX) TO           
                WS-REV-RPT-CD-BG2.                                      
           MOVE WS-STANDBY-COMPLIED-BG   (WS-BILLING-INDX) TO           
                WS-STANDBY-COMPLIED-BG2.                                
           MOVE WS-PRORATE-CD-BG         (WS-BILLING-INDX) TO           
                WS-PRORATE-CD-BG2.                                      
           MOVE WS-NEW-RATE-PCT-BG       (WS-BILLING-INDX) TO           
                WS-NEW-RATE-PCT-BG2.                                    
           MOVE WS-CODE-SUB-TOTAL-BG     (WS-BILLING-INDX) TO           
                WS-CODE-SUB-TOTAL-BG2.                                  
           MOVE WS-TAX-REFUND-CD-BG      (WS-BILLING-INDX) TO           
                WS-TAX-REFUND-CD-BG2.                                   
           MOVE WS-DATE-LFTM-HI-DMD-BG   (WS-BILLING-INDX) TO           
                WS-DATE-LFTM-HI-DMD-BG2.                                
           MOVE WS-LFTM-HI-PEAK-DMD-BG   (WS-BILLING-INDX) TO           
                WS-LFTM-HI-PEAK-DMD-BG2.                                
           MOVE WS-REBILL-IND-BG         (WS-BILLING-INDX) TO           
                WS-REBILL-IND-BG2.                                      
           MOVE WS-ADJ-REASON-CD-BG      (WS-BILLING-INDX) TO           
                WS-ADJ-REASON-CD-BG2.                                   
           MOVE WS-REVENUE-MONTH-BG      (WS-BILLING-INDX) TO           
                WS-REVENUE-MONTH-BG2.                                   
           MOVE WS-GAS-BASE-USE-BG       (WS-BILLING-INDX) TO           
                WS-GAS-BASE-USE-BG2                                     
           MOVE WS-WNA-FACTOR-BG         (WS-BILLING-INDX) TO           
                WS-WNA-FACTOR-BG2.                                      
           MOVE WS-BTU-FACTOR-BG         (WS-BILLING-INDX) TO           
                WS-BTU-FACTOR-BG2.                                      
TP4389     MOVE WS-INSERT                TO WS-UPDATE-ACTION-IND-BG2.   
           PERFORM 8120-WRITE-BILLING-DETAIL THRU 8120-EXIT.            
      *                                                                         
       1310-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 1320-TRANSFER-CNSMPTN                                         *         
      *     TRANSFER CX DATA                                          *         
      *                                                               *         
      *****************************************************************         
       1320-TRANSFER-CNSMPTN.                                           
           MOVE WS-ACCT-XFER-TO-AT TO WS-ACCOUNT-NO-CX2.                
           MOVE ZERO               TO WS-BILL-NO-CX2.                   
           MOVE WS-CODE-UTIL-TYPE-CX     (WS-CNSMPTN-INDX)  TO          
                WS-CODE-UTIL-TYPE-CX2.                                  
           MOVE WS-IC-NO-CX              (WS-CNSMPTN-INDX)  TO          
                WS-IC-NO-CX2.                                           
           MOVE WS-BILL-ITEM-TIMESTMP-CX (WS-CNSMPTN-INDX)  TO          
                WS-BILL-ITEM-TIMESTMP-CX2.                              
           MOVE WS-MTR-REF-NO-CX         (WS-CNSMPTN-INDX)  TO          
                WS-MTR-REF-NO-CX2.                                      
           MOVE WS-CODE-TIME-PERIOD-CX   (WS-CNSMPTN-INDX)  TO          
                WS-CODE-TIME-PERIOD-CX2.                                
           MOVE WS-METER-NO-CX           (WS-CNSMPTN-INDX)  TO          
                WS-METER-NO-CX2.                                        
           MOVE WS-REG-ID-NO-CX          (WS-CNSMPTN-INDX)  TO          
                WS-REG-ID-NO-CX2.                                       
           MOVE WS-CODE-USAGE-TYPE-CX    (WS-CNSMPTN-INDX)  TO          
                WS-CODE-USAGE-TYPE-CX2.                                 
           MOVE WS-CODE-USAGE-ID-CX      (WS-CNSMPTN-INDX)  TO          
                WS-CODE-USAGE-ID-CX2.                                   
           MOVE WS-CODE-USAGE-SOURCE-CX  (WS-CNSMPTN-INDX)  TO          
                WS-CODE-USAGE-SOURCE-CX2.                               
           MOVE WS-ITEM-SEQ-NO-CX        (WS-CNSMPTN-INDX)  TO          
                WS-ITEM-SEQ-NO-CX2.                                     
           MOVE WS-DATE-READ-CX          (WS-CNSMPTN-INDX)  TO          
                WS-DATE-READ-CX2.                                       
           MOVE WS-CODE-METER-READ-CX    (WS-CNSMPTN-INDX)  TO          
                WS-CODE-METER-READ-CX2.                                 
           MOVE WS-CODE-METER-NO-READ-CX (WS-CNSMPTN-INDX)  TO          
                WS-CODE-METER-NO-READ-CX2.                              
           MOVE WS-METER-READING-CX      (WS-CNSMPTN-INDX)  TO          
                WS-METER-READING-CX2.                                   
           MOVE WS-DEMAND-READING-CX     (WS-CNSMPTN-INDX)  TO          
                WS-DEMAND-READING-CX2.                                  
           MOVE WS-NO-UNITS-CX           (WS-CNSMPTN-INDX)  TO          
                WS-NO-UNITS-CX2.                                        
           MOVE WS-NO-DEMAND-UNITS-CX    (WS-CNSMPTN-INDX)  TO          
                WS-NO-DEMAND-UNITS-CX2.                                 
           MOVE WS-EMPLOYEE-NO-CX        (WS-CNSMPTN-INDX)  TO          
                WS-EMPLOYEE-NO-CX2.                                     
           MOVE WS-NO-DAYS-CX            (WS-CNSMPTN-INDX)  TO          
                WS-NO-DAYS-CX2.                                         
           MOVE WS-CODE-SOURCE-ID-CX     (WS-CNSMPTN-INDX)  TO          
                WS-CODE-SOURCE-ID-CX2.                                  
           MOVE WS-CODE-DEBIT-CREDIT-CX  (WS-CNSMPTN-INDX)  TO          
                WS-CODE-DEBIT-CREDIT-CX2.                               
           MOVE WS-CODE-ITEM-STATUS-CX   (WS-CNSMPTN-INDX)  TO          
                WS-CODE-ITEM-STATUS-CX2.                                
           MOVE WS-CODE-DISCOUNT-CX      (WS-CNSMPTN-INDX)  TO          
                WS-CODE-DISCOUNT-CX2.                                   
           MOVE WS-CONSTANT-CX           (WS-CNSMPTN-INDX)  TO          
                WS-CONSTANT-CX2.                                        
           MOVE WS-NO-DIALS-CX           (WS-CNSMPTN-INDX)  TO          
                WS-NO-DIALS-CX2.                                        
           MOVE WS-COMPANY-NO-CX         (WS-CNSMPTN-INDX)  TO          
                WS-COMPANY-NO-CX2.                                      
           MOVE WS-EXCEPT-OVERRIDE-CD-CX (WS-CNSMPTN-INDX)  TO          
                WS-EXCEPT-OVERRIDE-CD-CX2.                              
           MOVE WS-REQUESTED-USAGE-CX    (WS-CNSMPTN-INDX)  TO          
                WS-REQUESTED-USAGE-CX2.                                 
           MOVE WS-DIGTL-INTRL-MTR-NO-CX (WS-CNSMPTN-INDX)  TO          
                WS-DIGTL-INTRL-MTR-NO-CX2.                              
           MOVE WS-CODE-TOU-SEASN-CX     (WS-CNSMPTN-INDX)  TO          
                WS-CODE-TOU-SEASN-CX2.                                  
           MOVE WS-DIGTL-MTR-TYPE-CX     (WS-CNSMPTN-INDX)  TO          
                WS-DIGTL-MTR-TYPE-CX2.                                  
           MOVE WS-EXCL-DMD-RCHT-IND-CX  (WS-CNSMPTN-INDX)  TO          
                WS-EXCL-DMD-RCHT-IND-CX2.                               
PRJ583     MOVE WS-PREV-METER-READ-CALC (WS-CNSMPTN-INDX)  TO           
PRJ583          WS-PREV-METER-READ-CALC-CX2.                            
PRJ583     MOVE WS-PREV-METER-READ-DATE-CALC (WS-CNSMPTN-INDX)          
PRJ583       TO WS-PREV-MTR-READ-DATE-CALC-CX2.                         
PRJ583     MOVE WS-PRV-MTR-READ-COMB-FLG-CX (WS-CNSMPTN-INDX)           
PRJ583       TO WS-PRV-MTR-READ-COMB-FLG-CX2.                           
TP4389     MOVE WS-INSERT                TO WS-UPDATE-ACTION-IND-CX2.   
           PERFORM 8130-WRITE-CONSUMPTION THRU 8130-EXIT.               
      *                                                                         
       1320-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 1330-TRANSFER-UNMTRD-CNSMPTN                                  *         
      *                                                               *         
      *****************************************************************         
       1330-TRANSFER-UNMTRD-CNSMPTN.                                    
           MOVE WS-ACCT-XFER-TO-AT TO WS-ACCOUNT-NO-UC2.                
           MOVE ZERO               TO WS-BILL-NO-UC2.                   
           MOVE WS-IC-NO-UC              (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-IC-NO-UC2.                                           
           MOVE WS-CODE-UTIL-TYPE-UC     (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-CODE-UTIL-TYPE-UC2.                                  
           MOVE WS-BILL-ITEM-TIMESTMP-UC (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-BILL-ITEM-TIMESTMP-UC2.                              
           MOVE WS-NO-UNITS-UC           (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-NO-UNITS-UC2.                                        
           MOVE WS-NO-DAYS-UC            (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-NO-DAYS-UC2.                                         
           MOVE WS-CODE-DEBIT-CREDIT-UC  (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-CODE-DEBIT-CREDIT-UC2.                               
           MOVE WS-USAGE-FIXED-UC        (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-USAGE-FIXED-UC2.                                     
           MOVE WS-CODE-ITEM-STATUS-UC   (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-CODE-ITEM-STATUS-UC2.                                
           MOVE WS-CODE-SOURCE-ID-UC     (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-CODE-SOURCE-ID-UC2.                                  
           MOVE WS-DATE-USAGE-ENDS-UC    (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-DATE-USAGE-ENDS-UC2.                                 
           MOVE WS-RATE-ITEM-CODE-UC     (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-RATE-ITEM-CODE-UC2.                                  
           MOVE WS-ITEM-SEQ-NO-UC        (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-ITEM-SEQ-NO-UC2.                                     
           MOVE WS-MTHLY-AMOUNT-FIXED-UC (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-MTHLY-AMOUNT-FIXED-UC2                               
           MOVE WS-DIST-NO-UC            (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-DIST-NO-UC2.                                         
           MOVE WS-LIGHT-NO-UC           (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-LIGHT-NO-UC2.                                        
           MOVE WS-POLE-NO-UC            (WS-UNMTRD-CNSMPTN-INDX) TO    
                WS-POLE-NO-UC2.                                         
TP4389     MOVE WS-INSERT                TO WS-UPDATE-ACTION-IND-UC2.   
      *                                                                         
           PERFORM 8140-WRITE-UNMTRD-CNSMPTN THRU 8140-EXIT.            
      *                                                                         
       1330-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 1500-TRANSFER-GUARANTOR                                      *          
      *                                                              *          
      ****************************************************************          
       1500-TRANSFER-GUARANTOR.                                         
           MOVE WS-CLR-AR-XFR-GL-NO (WS-GL-SUB)                         
                                       TO WS-CLEARING-GL.               
TP7965     MOVE WS-TOTAL-AR-BALANCE-AT TO WS-GUARANTEED-XFER-AMT.       
TP7965** INITIALIZE AND LOAD THE UNDIRECTED PYMT PRIORITY SCHEDULE              
TP7965** TO MOVE MONEY FROM THE GUARANTEED ACCT TO THE GUARANTOR'S.             
TP7965     MOVE WS-PAR-B               TO WS-PAR-UPDATE-TYPE.           
TP7965     PERFORM 6721X-LOAD-PYMT-PRTY-TABLE THRU 6721X-EXIT.          
TP7965*                                                                         
           PERFORM 1505-PROCESS-GUARANTOR     THRU 1505-EXIT.           
T10789     MOVE SPACE TO WS-CODE-SEC-ACCT.                              
T10789     MOVE WS-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT-AT.      
       1500-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
TP7965* OPEN THE CURSOR FOR CURRENT ACCOUNT'S GUARANTORS THEN TRANSFER          
TP7965* THE MONEY FROM THIS ACCOUNT TO THE GUARANTORS.               *          
      ****************************************************************          
       1505-PROCESS-GUARANTOR.                                          
      *                                                                         
           MOVE WS-ACCOUNT-NO-AT       TO GU-ACCOUNT-NO.                
           MOVE WS-TOTAL-AR-BALANCE-AT TO WS-103-ACCT-END-AR-BAL.       
TP7965     PERFORM 1510-SET-PRIORITY-INDX     THRU 1510-EXIT.           
TP7965     SET WS-UTE-AR-INDX3         TO 1.                            
TP7965     SET WS-UTG-AR-INDX3         TO 2.                            
TP7965     SET WS-LPC-AR-INDX3         TO 3.                            
TP7965     PERFORM 1515-SET-ELEC-GAS-ALLOC    THRU 1515-EXIT.           
           PERFORM 7200-OPEN-GUARANTOR-CURSOR     THRU 7200-EXIT.       
           PERFORM 7210-FETCH-GUARANTOR-CURSOR    THRU 7210-EXIT.       
           PERFORM 1507-TRANSFER-ACCOUNT-BALANCE  THRU 1507-EXIT        
TP7965             UNTIL WS-ACTIVE-RETURN-CODE  EQUAL NOT-FOUND         
           PERFORM 7220-CLOSE-GUARANTOR-CURSOR    THRU 7220-EXIT.       
      *                                                                         
P00599     IF WS-TOT-GUAR-TRANS-AMT > ZEROES                            
P00599        MOVE WS-ACCOUNT-NO-AT      TO KD-ACCOUNT-NO               
P00599        MOVE WS-TOT-GUAR-TRANS-AMT TO KD-FW-ACTION-AM             
P00599        MOVE WS-LOWER-SEQ-NO       TO KD-FW-SEQ-NO                
P00599        PERFORM 8010-UPDATE-PROCESSED-FL    THRU 8010-EXIT        
P00599     END-IF.                                                      
P00599*                                                                         
       1505-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
TP7965***************************************************************           
TP7965** LOAD FIELDS TO POPULATE THE XFER TABL AND SEARCH THROUGH THE           
TP7965** PMT PRTY TABLE TO MOVE THE MONEY OFF OF THE GUARANTEED ACCT*           
TP7965** TO THE GUARANTOR ACCT IN THE CORRECT ORDER.                *           
TP7965***************************************************************           
       1507-TRANSFER-ACCOUNT-BALANCE.                                   
TP7965     MOVE WS-NO                  TO WS-GUARANTOR-BILLED-SW.       
           MOVE GU-GUARNTR-ACCT-NO     TO WS-ACCOUNT-NO-AC2             
                                          WS-ACCT-NO-TO-FROM.           
TP7965     PERFORM 7600-SELECT-GUAR-ACCOUNT   THRU 7600-EXIT.           
T22729     IF AT-CODE-ACCT-STAT = WS-FINAL-BILL OR WS-WRITE-OFF         
TP7965** IT HAS BEEN FINAL BILLED, SEND A WORK QUEUE THAT NO MONEY              
TP7965** COULD BE TRANSFERRED TO IT.                                            
TP7965        PERFORM 1560-CREATE-GUAR-WQ     THRU 1560-EXIT            
TP7965     ELSE                                                         
TP7965        MOVE GU-AMOUNT-GUARANTEED TO WS-REMAINING-PYMT-AMT        
TP7965        MOVE 1                    TO WS-PAR-SUB                   
TP7965        PERFORM 1520-TEST-SEG-PRESENCE   THRU 1520-EXIT           
TP7965        VARYING WS-PAR-SUB FROM WS-PAR-SUB BY 1                   
SCA006          UNTIL WS-GUARANTEED-XFER-AMT       EQUAL ZERO OR 
SCA006                WS-REMAINING-PYMT-AMT        EQUAL ZERO OR 
                      WS-PAR-SUB GREATER THAN 52 OR 
                      WS-APPL-FUNC-ID (WS-PAR-SUB) EQUAL ZERO           
TP7965     END-IF.                                                      
      ** CHECK FOR RECEIVABLE NSC, NSA, RCC, OR CNT (TYPES C,D,E)               
      ** CREATE WORK QUEUE SINCE THESE RECEIVABLE ARE NOT TRANSFERED.           
T23011**   SET NO-GUAR-RECV-WQ TO TRUE.                                         
T23011**   SEARCH WS-AR-DATA                                                    
T23011**       AT END                                                           
T23011**            CONTINUE                                                    
T23011**       WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = 0                      
T23011**            CONTINUE                                                    
T23011**       WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)                   
T23011**              = WS-NSC OR WS-NSA OR WS-RCC                              
T23011**            SET CREATE-GUAR-RECV-WQ TO TRUE                             
T23011**       WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)                   
T23011**              = WS-CNT                                                  
T23011**            SET WS-CNT-INDX TO 1                                        
T23011**            PERFORM VARYING WS-CNT-INDX FROM 1 BY 1                     
T23011**              UNTIL WS-CNT-INDX > 20                                    
T23011**                 OR WS-ACCOUNT-NO-CT (WS-CNT-INDX) = ZERO               
T23011**                 OR CREATE-GUAR-RECV-WQ                                 
T23011**               IF WS-CODE-CONTRACT-TYPE-CT (WS-CNT-INDX)                
T23011**                 = WS-SERVICE-CHARGE OR WS-ENDV-CHARGE                  
T23011**                   OR WS-MISC-CHARGE                                    
T23011**                  SET CREATE-GUAR-RECV-WQ TO TRUE                       
T23011**               END-IF                                                   
T23011**            END-PERFORM                                                 
T23011**   END-SEARCH.                                                          
T23011**                                                                        
T23011**   IF CREATE-GUAR-RECV-WQ                                               
T23011**      PERFORM 1565-CREATE-GUAR-RECV-WQ THRU 1565-EXIT                   
T23011**   END-IF.                                                              
T23011**                                                                        
                                                                        
TP7965     IF WS-GUARANTOR-BILLED                                       
TP7965** WRITE OUT PENDING XFER RECORDS FROM THE MONEY TRANSFERRED.             
TP7965        PERFORM 1580-INIT-PENDING-XFER THRU 1580-EXIT             
TP7965        VARYING WS-AR-DATA-INDX3  FROM 1 BY 1                     
TP7965          UNTIL WS-AR-DATA-INDX3 GREATER THAN 5                   
TP7965        INITIALIZE WS-AC-TABLE3                                   
TP7965        MOVE WS-CANCELLED            TO GU-GUAR-STATUS-CD         
TP7965        MOVE WS-GUAR-BILLED-MSG      TO GU-GUAR-STATUS-REASON     
TP7965     ELSE                                                         
TP7965** WRITE OUT A PENDING XFR RECORD INDICATING NO MONEY XFERRED, BUT        
TP7965** WRITE ONE FOR THE RECORDS TO MATCH WITH ACCTS IN SCSCA102.             
TP7965        MOVE WS-PAR-B             TO WS-XFER-TO-GUARANTOR-IND-AC2 
TP7965        PERFORM 8100-WRITE-MASTER-AR-CNTRL   THRU 8100-EXIT       
TP7965        MOVE WS-CANCELLED            TO GU-GUAR-STATUS-CD         
TP7965        MOVE WS-GUAR-FB-AMT-PAID-MSG TO GU-GUAR-STATUS-REASON     
TP7965     END-IF.                                                      
T22729     IF AT-CODE-ACCT-STAT NOT EQUAL WS-FINAL-BILL OR WS-WRITE-OFF 
T17340* THE FOLLOWING CODE WAS COMMENTED OUT FOR T17340                         
T10789*       MOVE 9000                    TO XP-TABLE-ID                       
T11939*       MOVE WS-ACCOUNT-NO-AT        TO XP-ACCT-XFER-FROM                 
T10789*       MOVE GU-GUARNTR-ACCT-NO      TO XP-ACCT-XFER-TO                   
T10789*       MOVE WS-LOCAL-OFFICE-AT      TO XP-LOCAL-OFFICE                   
T10789*       MOVE WS-PREMISE-NO-AT        TO XP-PREMISE-NO                     
T10789*       MOVE 9                       TO XP-PARTITION-ID                   
T11939*       MOVE WS-YES                  TO XP-SUB-ACCT-BLLD-OK               
T10789*       MOVE GU-SERVICE-TYPE-CD      TO XP-XFER-DATA-TEXT                 
T11939*       MOVE LENGTH OF XP-XFER-DATA-TEXT TO XP-XFER-DATA-LEN              
T11939*       PERFORM 8200-INSERT-PENDING-XFER THRU 8200-EXIT                   
T10789        PERFORM 8000-UPDATE-GUARANTOR-STATUS THRU 8000-EXIT       
TP7965     END-IF.                                                      
P00599                                                                  
P00599     IF WS-TOTAL-GUAR-TRANS-AMT > 0                               
P00599        MOVE LS-INPUT-DATE           TO WS-FW-ACTION-DT           
P00599        MOVE WS-ACCOUNT-NO-AT        TO KD-ACCOUNT-NO             
P00599        PERFORM 6600-PROCESS-CALC-NEW-SEQ-NO THRU 6600-CPD348-EXIT
P00599        MOVE '90307'                 TO KD-FW-ACTION-TYPE-CD      
P00599        MOVE WS-NEXT-DATE            TO KD-FW-ACTION-DT           
P00599        MOVE WS-TOTAL-GUAR-TRANS-AMT TO KD-FW-ACTION-AM           
P00599        MOVE WS-NEW-SEQ-NO           TO KD-FW-SEQ-NO              
P00599        MOVE SPACES                  TO KD-FW-MANUAL-FL           
P00599        MOVE SPACES                  TO KD-FW-ACTION-COMMENTS-TEXT
P00599        MOVE 'FN'                    TO KD-FW-BUS-PROCESS-CD      
P00599        MOVE SPACES                  TO KD-FW-PROCESSED-FL        
P00599        MOVE GU-GUARNTR-ACCT-NO      TO KD-GUARANTOR-ACCT-NO      
P00599        PERFORM 8210-INSERT-FINAL-WO-ACTN    THRU 8210-EXIT       
P00599     END-IF.                                                      
P00599     ADD WS-TOTAL-GUAR-TRANS-AMT     TO WS-TOT-GUAR-TRANS-AMT.    
P00599     MOVE ZEROS  TO WS-TOTAL-GUAR-TRANS-AMT.                      
P00599                                                                  
           PERFORM 7210-FETCH-GUARANTOR-CURSOR     THRU 7210-EXIT.      
       1507-EXIT.                                                       
           EXIT.                                                        
TP7965**********************************************************                
TP7965* SET INDEXES TO POINT TO A CERTAIN ROW IN THE AR DATA   *                
TP7965* TABLE FOR CERTAIN RECEIVABLES.                         *                
TP7965**********************************************************                
TP7965 1510-SET-PRIORITY-INDX.                                          
TP7965     PERFORM VARYING WS-AR-DATA-INDX                              
P00097        FROM 1 BY 1 UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY       
TP7965          OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZEROES          
TP7965             EVALUATE TRUE                                        
TP7965                WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) =  
TP7965                     WS-UTE                                       
TP7965                     SET WS-UTE-AR-INDX TO WS-AR-DATA-INDX        
TP7965                     MOVE WS-YES TO WS-HAS-UTE                    
TP7965                WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) =  
TP7965                     WS-UTG                                       
TP7965                     SET WS-UTG-AR-INDX TO WS-AR-DATA-INDX        
TP7965                     MOVE WS-YES TO WS-HAS-UTG                    
TP7965                WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) =  
TP7965                     WS-LPC                                       
TP7965                     SET WS-LPC-AR-INDX TO WS-AR-DATA-INDX        
TP7965                     MOVE WS-YES TO WS-HAS-LPC                    
TP7965             END-EVALUATE                                         
TP7965     END-PERFORM.                                                 
TP7965*                                                                         
TP7965 1510-EXIT.                                                       
TP7965     EXIT.                                                        
TP7965*                                                                         
TP7965**********************************************************                
TP7965* GET ELEC  AND GAS TOTALS AND CALCULATE THE ALLOCATION  *                
TP7965* PERCENTAGES FOR EACH AGING BUCKET.                     *                
TP7965**********************************************************                
TP7965 1515-SET-ELEC-GAS-ALLOC.                                         
T16851     IF HAS-UTE                                                   
TP7965     MOVE WS-AMT-AR-DAY-00-AC(WS-UTE-AR-INDX) TO WS-PAR-AMT-UTE-00
TP7965     MOVE WS-AMT-AR-DAY-30-AC(WS-UTE-AR-INDX) TO WS-PAR-AMT-UTE-30
TP7965     MOVE WS-AMT-AR-DAY-60-AC(WS-UTE-AR-INDX) TO WS-PAR-AMT-UTE-60
TP7965     MOVE WS-AMT-AR-DAY-90-AC(WS-UTE-AR-INDX) TO WS-PAR-AMT-UTE-90
T16851     ELSE                                                         
T16851       MOVE ZERO TO WS-PAR-AMT-UTE-00                             
T16851       MOVE ZERO TO WS-PAR-AMT-UTE-30                             
T16851       MOVE ZERO TO WS-PAR-AMT-UTE-60                             
T16851       MOVE ZERO TO WS-PAR-AMT-UTE-90                             
T16851     END-IF.                                                      
TP7965*                                                                         
T16851     IF HAS-UTG                                                   
TP7965     MOVE WS-AMT-AR-DAY-00-AC(WS-UTG-AR-INDX) TO WS-PAR-AMT-UTG-00
TP7965     MOVE WS-AMT-AR-DAY-30-AC(WS-UTG-AR-INDX) TO WS-PAR-AMT-UTG-30
TP7965     MOVE WS-AMT-AR-DAY-60-AC(WS-UTG-AR-INDX) TO WS-PAR-AMT-UTG-60
TP7965     MOVE WS-AMT-AR-DAY-90-AC(WS-UTG-AR-INDX) TO WS-PAR-AMT-UTG-90
T16851     ELSE                                                         
T16851       MOVE ZERO TO WS-PAR-AMT-UTG-00                             
T16851       MOVE ZERO TO WS-PAR-AMT-UTG-30                             
T16851       MOVE ZERO TO WS-PAR-AMT-UTG-60                             
T16851       MOVE ZERO TO WS-PAR-AMT-UTG-90                             
T16851     END-IF.                                                      
TP7965*                                                                         
TP7965     COMPUTE WS-PAR-AMT-UTL-00 = WS-PAR-AMT-UTE-00                
TP7965                                + WS-PAR-AMT-UTG-00.              
TP7965     COMPUTE WS-PAR-AMT-UTL-30 = WS-PAR-AMT-UTE-30                
TP7965                                + WS-PAR-AMT-UTG-30.              
TP7965     COMPUTE WS-PAR-AMT-UTL-60 = WS-PAR-AMT-UTE-60                
TP7965                                + WS-PAR-AMT-UTG-60.              
TP7965     COMPUTE WS-PAR-AMT-UTL-90 = WS-PAR-AMT-UTE-90                
TP7965                                + WS-PAR-AMT-UTG-90.              
TP7965*                                                                         
TP7965     IF WS-PAR-AMT-UTL-00 EQUAL ZEROES                            
TP7965        MOVE ZEROES TO WS-PAR-UTE-PERCENT-00                      
TP7965                       WS-PAR-UTG-PERCENT-00                      
TP7965     ELSE                                                         
TP7965        COMPUTE WS-PAR-UTE-PERCENT-00 ROUNDED =                   
TP7965           (WS-PAR-AMT-UTE-00 / WS-PAR-AMT-UTL-00)                
TP7965        COMPUTE WS-PAR-UTG-PERCENT-00 ROUNDED =                   
TP7965           (1 - WS-PAR-UTE-PERCENT-00)                            
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965     IF WS-PAR-AMT-UTL-30 EQUAL ZEROES                            
TP7965        MOVE ZEROES TO WS-PAR-UTE-PERCENT-30                      
TP7965                       WS-PAR-UTG-PERCENT-30                      
TP7965     ELSE                                                         
TP7965        COMPUTE WS-PAR-UTE-PERCENT-30 ROUNDED =                   
TP7965           (WS-PAR-AMT-UTE-30 / WS-PAR-AMT-UTL-30)                
TP7965        COMPUTE WS-PAR-UTG-PERCENT-30 ROUNDED =                   
TP7965           (1 - WS-PAR-UTE-PERCENT-30)                            
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965     IF WS-PAR-AMT-UTL-60 EQUAL ZEROES                            
TP7965        MOVE ZEROES TO WS-PAR-UTE-PERCENT-60                      
TP7965                       WS-PAR-UTG-PERCENT-60                      
TP7965     ELSE                                                         
TP7965        COMPUTE WS-PAR-UTE-PERCENT-60 ROUNDED =                   
TP7965           (WS-PAR-AMT-UTE-60 / WS-PAR-AMT-UTL-60)                
TP7965        COMPUTE WS-PAR-UTG-PERCENT-60 ROUNDED =                   
TP7965           (1 - WS-PAR-UTE-PERCENT-60)                            
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965     IF WS-PAR-AMT-UTL-90 EQUAL ZEROES                            
TP7965        MOVE ZEROES TO WS-PAR-UTE-PERCENT-90                      
TP7965                       WS-PAR-UTG-PERCENT-90                      
TP7965     ELSE                                                         
TP7965        COMPUTE WS-PAR-UTE-PERCENT-90 ROUNDED =                   
TP7965           (WS-PAR-AMT-UTE-90 / WS-PAR-AMT-UTL-90)                
TP7965        COMPUTE WS-PAR-UTG-PERCENT-90 ROUNDED =                   
TP7965           (1 - WS-PAR-UTE-PERCENT-90)                            
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965 1515-EXIT.                                                       
TP7965     EXIT.                                                        
TP7965**************************************************************            
TP7965* SEARCH THROUGH THE AR DATA   TABLE TO FIND THE SAME        *            
TP7965* RECEVIABLE AS FROM THE PMT PRTY TABLE.                     *            
TP7965**************************************************************            
TP7965 1520-TEST-SEG-PRESENCE.                                          
TP7965     SET WS-AR-DATA-INDX TO 1.                                    
TP7965     SEARCH WS-AR-DATA                                            
TP7965         AT END                                                   
TP7965              CONTINUE                                            
TP7965         WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = 0              
TP7965              CONTINUE                                            
TP7965         WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)           
TP7965*               = WS-APPL-FUNC-ID (WS-PAR-SUB)                            
T18340                = WS-APPL-FUNC-ID (WS-PAR-SUB) OR WS-UTG          
TP7965              IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
TP7965                = WS-UTE OR WS-UTG OR WS-LPC                      
TP7965                 PERFORM 1530-MOVE-TO-GUARANTOR THRU 1530-EXIT    
TP7965              END-IF                                              
TP7965     END-SEARCH.                                                  
TP7965 1520-EXIT.                                                       
TP7965     EXIT.                                                        
TP7965*************************************************************             
TP7965* MOVE THE MONEY FROM THE GUARANTEED ACCT TO GUARANTOR FOR  *             
TP7965* THE ENTRY FROM THE PYMT PRTY TABLE WHICH HAS MATCHED.     *             
TP7965*************************************************************             
TP7965 1530-MOVE-TO-GUARANTOR.                                          
TP7965*                                                                         
TP7965** MOVE MONEY FROM 90 DAY                                                 
TP7965     IF WS-APPL-AGING (WS-PAR-SUB) = WS-90-DAY                    
TP7965      IF WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX) > ZERO             
TP7965      OR (WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 40          
TP7965          AND WS-PAR-AMT-UTG-90 > 0)                              
TP7965         MOVE WS-90-DAY                TO WS-AR-AGE               
TP7965         IF WS-REMAINING-PYMT-AMT > WS-GUARANTEED-XFER-AMT        
TP7965            MOVE WS-GUARANTEED-XFER-AMT TO WS-AMT-TO-MOVE         
TP7965         ELSE                                                     
TP7965            MOVE WS-REMAINING-PYMT-AMT TO WS-AMT-TO-MOVE          
TP7965         END-IF                                                   
T18587*        IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 40                
T18587*           PERFORM 1540-DET-90-DAY-ELEC-GAS THRU 1540-EXIT               
T18587*        ELSE                                                             
T18705            IF WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)              
T18705                                    <   WS-AMT-TO-MOVE            
TP7965               MOVE WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)         
TP7965                                       TO WS-AMT-TO-MOVE          
T18705            END-IF                                                
TP7965            MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID    
TP7965            SUBTRACT WS-AMT-TO-MOVE                               
TP7965                FROM WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)        
TP7965            PERFORM 1535-POPULATE-TO-JRNL      THRU 1535-EXIT     
T18587*        END-IF                                                           
T13181         COMPUTE WS-TOTAL-GUAR-TRANS-AMT =                        
T13181           WS-TOTAL-GUAR-TRANS-AMT + WS-AMT-TO-MOVE               
TP7965      END-IF                                                      
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965** MOVE MONEY FROM 60 DAY                                                 
TP7965     IF WS-APPL-AGING (WS-PAR-SUB) = WS-60-DAY                    
TP7965      IF WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX) > ZERO             
TP7965      OR (WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 40          
TP7965          AND WS-PAR-AMT-UTG-60 > 0)                              
TP7965         MOVE WS-60-DAY                TO WS-AR-AGE               
TP7965         IF WS-REMAINING-PYMT-AMT > WS-GUARANTEED-XFER-AMT        
TP7965            MOVE WS-GUARANTEED-XFER-AMT TO WS-AMT-TO-MOVE         
TP7965         ELSE                                                     
TP7965            MOVE WS-REMAINING-PYMT-AMT TO WS-AMT-TO-MOVE          
TP7965         END-IF                                                   
T18587*        IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 40                
T18587*           PERFORM 1545-DET-60-DAY-ELEC-GAS THRU 1545-EXIT               
T18587*        ELSE                                                             
T18705            IF WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)              
T18705                                       < WS-AMT-TO-MOVE           
TP7965               MOVE WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)         
TP7965                                       TO WS-AMT-TO-MOVE          
T18705            END-IF                                                
TP7965            MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID    
TP7965            SUBTRACT WS-AMT-TO-MOVE                               
TP7965                FROM WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)        
TP7965            PERFORM 1535-POPULATE-TO-JRNL      THRU 1535-EXIT     
T18587*        END-IF                                                           
T13181         COMPUTE WS-TOTAL-GUAR-TRANS-AMT =                        
T13181           WS-TOTAL-GUAR-TRANS-AMT + WS-AMT-TO-MOVE               
TP7965      END-IF                                                      
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965** MOVE MONEY FROM 30 DAY                                                 
TP7965     IF WS-APPL-AGING (WS-PAR-SUB) = WS-30-DAY                    
TP7965      IF WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX) > ZERO             
TP7965      OR (WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 40          
TP7965          AND WS-PAR-AMT-UTG-30 > 0)                              
TP7965         MOVE WS-30-DAY                TO WS-AR-AGE               
TP7965         IF WS-REMAINING-PYMT-AMT > WS-GUARANTEED-XFER-AMT        
TP7965            MOVE WS-GUARANTEED-XFER-AMT TO WS-AMT-TO-MOVE         
TP7965         ELSE                                                     
TP7965            MOVE WS-REMAINING-PYMT-AMT TO WS-AMT-TO-MOVE          
TP7965         END-IF                                                   
T18587*        IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 40                
T18587*           PERFORM 1550-DET-30-DAY-ELEC-GAS THRU 1550-EXIT               
T18587*        ELSE                                                             
T18705            IF WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)              
T18705                                       < WS-AMT-TO-MOVE           
TP7965               MOVE WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)         
TP7965                                       TO WS-AMT-TO-MOVE          
T18705            END-IF                                                
TP7965            MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID    
TP7965            SUBTRACT WS-AMT-TO-MOVE                               
TP7965                FROM WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)        
TP7965            PERFORM 1535-POPULATE-TO-JRNL      THRU 1535-EXIT     
T18587*        END-IF                                                           
T13181         COMPUTE WS-TOTAL-GUAR-TRANS-AMT =                        
T13181           WS-TOTAL-GUAR-TRANS-AMT + WS-AMT-TO-MOVE               
TP7965      END-IF                                                      
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965** MOVE MONEY FROM CURRENT OR 00 DAY                                      
TP7965     IF WS-APPL-AGING (WS-PAR-SUB) = WS-00-DAY                    
TP7965      IF WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX) > ZERO             
TP7965      OR (WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 40          
TP7965          AND WS-PAR-AMT-UTG-00 > 0)                              
TP7965         MOVE WS-00-DAY                TO WS-AR-AGE               
TP7965         IF WS-REMAINING-PYMT-AMT > WS-GUARANTEED-XFER-AMT        
TP7965            MOVE WS-GUARANTEED-XFER-AMT TO WS-AMT-TO-MOVE         
TP7965         ELSE                                                     
TP7965            MOVE WS-REMAINING-PYMT-AMT TO WS-AMT-TO-MOVE          
TP7965         END-IF                                                   
T18587*        IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 40                
T18587*           PERFORM 1555-DET-00-DAY-ELEC-GAS THRU 1555-EXIT               
T18587*        ELSE                                                             
T18705            IF WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)              
T18705                                     < WS-AMT-TO-MOVE             
TP7965               MOVE WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)         
TP7965                                       TO WS-AMT-TO-MOVE          
T18705            END-IF                                                
TP7965            MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID    
TP7965            SUBTRACT WS-AMT-TO-MOVE                               
TP7965                FROM WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)        
TP7965            PERFORM 1535-POPULATE-TO-JRNL      THRU 1535-EXIT     
T18587*        END-IF                                                           
PCR408         COMPUTE WS-TOTAL-GUAR-TRANS-AMT =                        
PCR408           WS-TOTAL-GUAR-TRANS-AMT + WS-AMT-TO-MOVE               
TP7965      END-IF                                                      
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965 1530-EXIT.                                                       
TP7965     EXIT.                                                        
TP7965*                                                                         
TP7965****************************************************************          
TP7965* COMMON AREA FOR UPDATING VALUES, GETTING THE GL NUMBERS AND  *          
TP7965* WRITING TO THE JOURNALS.                                     *          
TP7965****************************************************************          
TP7965 1535-POPULATE-TO-JRNL.                                           
TP7965*                                                                         
T18587*    IF WS-MOVING-UTG                                                     
T18587*       COMPUTE WS-103-DETAIL-END-AR-BAL =                                
T18587*               WS-AMT-AR-DAY-90-AC (WS-UTG-AR-INDX)                      
T18587*             + WS-AMT-AR-DAY-60-AC (WS-UTG-AR-INDX)                      
T18587*             + WS-AMT-AR-DAY-30-AC (WS-UTG-AR-INDX)                      
T18587*             + WS-AMT-AR-DAY-00-AC (WS-UTG-AR-INDX)                      
T18587*    ELSE                                                                 
TP7965        COMPUTE WS-103-DETAIL-END-AR-BAL =                        
TP7965                WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)             
TP7965              + WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)             
TP7965              + WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)             
TP7965              + WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)             
T18587*    END-IF.                                                              
T12732*                                                                         
T12732     MOVE WS-103-DETAIL-END-AR-BAL TO WS-103-DETAIL-END-BAL.      
TP7965*                                                                         
T18587*    IF WS-MOVING-UTG                                                     
T18587*      MOVE WS-PYMT-PRIORITY-LVL-AC (WS-UTG-AR-INDX)                      
T18587*                                  TO WS-PYMT-PRIORITY-LVL-AC2            
T18587*    ELSE                                                                 
TP7965       MOVE WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)             
TP7965                                   TO WS-PYMT-PRIORITY-LVL-AC2    
T18587*    END-IF.                                                              
TP7965     PERFORM 5110-SELECT-GL-FROM-OTHER THRU 5110-EXIT.            
TP7965*                                                                         
TP7965     PERFORM 1570-SAVE-INFO-TO-AC3     THRU 1570-EXIT.            
TP7965*                                                                         
TP7965     SUBTRACT WS-AMT-TO-MOVE FROM WS-GUARANTEED-XFER-AMT.         
TP7965     SUBTRACT WS-AMT-TO-MOVE FROM WS-REMAINING-PYMT-AMT.          
TP7965     SUBTRACT WS-AMT-TO-MOVE FROM WS-103-ACCT-END-AR-BAL.         
TP7965     MOVE WS-AMT-TO-MOVE         TO WS-TRANSFER-AMT.              
TP7965     PERFORM 2200-WRITE-TRANSFER-JRNL THRU 2200-EXIT.             
TP7965     MOVE WS-YES                 TO WS-GUARANTOR-BILLED-SW.       
TP7965 1535-EXIT.                                                       
TP7965     EXIT.                                                        
TP7965*                                                                         
TP7965****************************************************************          
TP7965* MOVE ELEC AND GAS OFF OF THE ACCOUNT SINCE AN ALLOCATION MAY *          
TP7965* NEED TO BE DONE AND THERE IS ONLY ONE ENTRY IN THE AR PMT    *          
TP7965* PRTY TABLE FOR BOTH ELEC AND GAS.                            *          
TP7965****************************************************************          
TP7965 1540-DET-90-DAY-ELEC-GAS.                                        
TP7965** MOVE ALL MONEY FROM ELEC AND GAS 90 DAY SINCE AMT GUARANTEED           
TP7965** IS MORE THAN 90 ELEC AND GAS.                                          
TP7965     IF WS-PAR-AMT-UTL-90     <= WS-AMT-TO-MOVE                   
TP7965        IF WS-PAR-AMT-UTE-90 > 0                                  
TP7965          MOVE WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)              
TP7965                                       TO WS-AMT-TO-MOVE          
TP7965          MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID      
TP7965          SUBTRACT WS-AMT-TO-MOVE                                 
TP7965                FROM WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)        
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-90          
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTE-90          
TP7965          PERFORM 1535-POPULATE-TO-JRNL    THRU 1535-EXIT         
TP7965        END-IF                                                    
TP7965        IF WS-PAR-AMT-UTG-90 > 0                                  
TP7965          MOVE WS-AMT-AR-DAY-90-AC (WS-UTG-AR-INDX)               
TP7965                                       TO WS-AMT-TO-MOVE          
TP7965          MOVE WS-ITEM-ID-AC (WS-UTG-AR-INDX) TO WS-ITEM-ID       
TP7965          SUBTRACT WS-AMT-TO-MOVE                                 
TP7965                  FROM WS-AMT-AR-DAY-90-AC (WS-UTG-AR-INDX)       
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-90          
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTG-90          
TP7965          MOVE WS-PAR-YES              TO WS-MOVING-UTG-SW        
TP7965          PERFORM 1535-POPULATE-TO-JRNL    THRU 1535-EXIT         
TP7965          MOVE WS-PAR-NO               TO WS-MOVING-UTG-SW        
TP7965        END-IF                                                    
TP7965     ELSE                                                         
TP7965        PERFORM 1540-CONTINUED             THRU 1540-CONT-EXIT    
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965 1540-EXIT.                                                       
TP7965     EXIT.                                                        
TP7965*                                                                         
TP7965** MOVE MONEY FROM ELEC AND GAS 90 DAY BY USING THE ALLOCATION            
TP7965** FACTOR SINCE THERE IS MORE 90 DAY MONEY THAN THE AMOUNT THAT           
TP7965** THE GUARANTOR HAS GUARANTEED.                                          
TP7965 1540-CONTINUED.                                                  
TP7965     IF WS-PAR-AMT-UTL-90     > WS-AMT-TO-MOVE                    
TP7965       COMPUTE WS-PAR-AMT-PMT-UTE-90 = WS-PAR-UTE-PERCENT-90      
TP7965                                     * WS-AMT-TO-MOVE             
TP7965       COMPUTE WS-PAR-AMT-PMT-UTG-90 = WS-AMT-TO-MOVE             
TP7965                                     - WS-PAR-AMT-PMT-UTE-90      
TP7965*                                                                         
TP7965       IF WS-PAR-AMT-PMT-UTE-90 > 0                               
TP7965        MOVE WS-PAR-AMT-PMT-UTE-90   TO WS-AMT-TO-MOVE            
TP7965        MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID        
TP7965        SUBTRACT WS-AMT-TO-MOVE                                   
TP7965                FROM WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)        
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-90            
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTE-90            
TP7965        PERFORM 1535-POPULATE-TO-JRNL      THRU 1535-EXIT         
TP7965       END-IF                                                     
TP7965       IF WS-PAR-AMT-PMT-UTG-90 > 0                               
TP7965        MOVE WS-PAR-AMT-PMT-UTG-90   TO WS-AMT-TO-MOVE            
TP7965        MOVE WS-ITEM-ID-AC (WS-UTG-AR-INDX) TO WS-ITEM-ID         
TP7965        SUBTRACT WS-AMT-TO-MOVE                                   
TP7965                FROM WS-AMT-AR-DAY-90-AC (WS-UTG-AR-INDX)         
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-90            
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTG-90            
TP7965        MOVE WS-PAR-YES              TO WS-MOVING-UTG-SW          
TP7965        PERFORM 1535-POPULATE-TO-JRNL      THRU 1535-EXIT         
TP7965        MOVE WS-PAR-NO               TO WS-MOVING-UTG-SW          
TP7965       END-IF                                                     
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965 1540-CONT-EXIT.                                                  
TP7965     EXIT.                                                        
TP7965*                                                                         
TP7965****************************************************************          
TP7965* MOVE ELEC AND GAS OFF OF THE ACCOUNT SINCE AN ALLOCATION MAY *          
TP7965* NEED TO BE DONE AND THERE IS ONLY ONE ENTRY IN THE AR PMT    *          
TP7965* PRTY TABLE FOR BOTH ELEC AND GAS.                            *          
TP7965****************************************************************          
TP7965 1545-DET-60-DAY-ELEC-GAS.                                        
TP7965** MOVE ALL MONEY FROM ELEC AND GAS 60 DAY SINCE AMT GUARANTEED           
TP7965** IS MORE THAN 60 ELEC AND GAS.                                          
TP7965     IF WS-PAR-AMT-UTL-60     <= WS-AMT-TO-MOVE                   
TP7965        IF WS-PAR-AMT-UTE-60 > 0                                  
TP7965          MOVE WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)              
TP7965                                       TO WS-AMT-TO-MOVE          
TP7965          MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID      
TP7965          SUBTRACT WS-AMT-TO-MOVE                                 
TP7965                FROM WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)        
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-60          
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTE-60          
TP7965          PERFORM 1535-POPULATE-TO-JRNL    THRU 1535-EXIT         
TP7965        END-IF                                                    
TP7965        IF WS-PAR-AMT-UTG-60 > 0                                  
TP7965          MOVE WS-AMT-AR-DAY-60-AC (WS-UTG-AR-INDX)               
TP7965                                       TO WS-AMT-TO-MOVE          
TP7965          MOVE WS-ITEM-ID-AC (WS-UTG-AR-INDX) TO WS-ITEM-ID       
TP7965          SUBTRACT WS-AMT-TO-MOVE                                 
TP7965                  FROM WS-AMT-AR-DAY-60-AC (WS-UTG-AR-INDX)       
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-60          
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTG-60          
TP7965          MOVE WS-PAR-YES              TO WS-MOVING-UTG-SW        
TP7965          PERFORM 1535-POPULATE-TO-JRNL    THRU 1535-EXIT         
TP7965          MOVE WS-PAR-NO               TO WS-MOVING-UTG-SW        
TP7965        END-IF                                                    
TP7965     ELSE                                                         
TP7965        PERFORM 1545-CONTINUED             THRU 1545-CONT-EXIT    
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965 1545-EXIT.                                                       
TP7965     EXIT.                                                        
TP7965*                                                                         
TP7965** MOVE MONEY FROM ELEC AND GAS 60 DAY BY USING THE ALLOCATION            
TP7965** FACTOR SINCE THERE IS MORE 60 DAY MONEY THAN THE AMOUNT THAT           
TP7965** THE GUARANTOR HAS GUARANTEED.                                          
TP7965 1545-CONTINUED.                                                  
TP7965     IF WS-PAR-AMT-UTL-60     > WS-AMT-TO-MOVE                    
TP7965       COMPUTE WS-PAR-AMT-PMT-UTE-60 = WS-PAR-UTE-PERCENT-60      
TP7965                                     * WS-AMT-TO-MOVE             
TP7965       COMPUTE WS-PAR-AMT-PMT-UTG-60 = WS-AMT-TO-MOVE             
TP7965                                     - WS-PAR-AMT-PMT-UTE-60      
TP7965*                                                                         
TP7965       IF WS-PAR-AMT-PMT-UTE-60 > 0                               
TP7965        MOVE WS-PAR-AMT-PMT-UTE-60   TO WS-AMT-TO-MOVE            
TP7965        MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID        
TP7965        SUBTRACT WS-AMT-TO-MOVE                                   
TP7965                FROM WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)        
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-60            
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTE-60            
TP7965        PERFORM 1535-POPULATE-TO-JRNL      THRU 1535-EXIT         
TP7965       END-IF                                                     
TP7965       IF WS-PAR-AMT-PMT-UTG-60 > 0                               
TP7965        MOVE WS-PAR-AMT-PMT-UTG-60   TO WS-AMT-TO-MOVE            
TP7965        MOVE WS-ITEM-ID-AC (WS-UTG-AR-INDX) TO WS-ITEM-ID         
TP7965        SUBTRACT WS-AMT-TO-MOVE                                   
TP7965                FROM WS-AMT-AR-DAY-60-AC (WS-UTG-AR-INDX)         
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-60            
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTG-60            
TP7965        MOVE WS-PAR-YES              TO WS-MOVING-UTG-SW          
TP7965        PERFORM 1535-POPULATE-TO-JRNL      THRU 1535-EXIT         
TP7965        MOVE WS-PAR-NO               TO WS-MOVING-UTG-SW          
TP7965       END-IF                                                     
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965 1545-CONT-EXIT.                                                  
TP7965     EXIT.                                                        
TP7965*                                                                         
TP7965****************************************************************          
TP7965* MOVE ELEC AND GAS OFF OF THE ACCOUNT SINCE AN ALLOCATION MAY *          
TP7965* NEED TO BE DONE AND THERE IS ONLY ONE ENTRY IN THE AR PMT    *          
TP7965* PRTY TABLE FOR BOTH ELEC AND GAS.                            *          
TP7965****************************************************************          
TP7965 1550-DET-30-DAY-ELEC-GAS.                                        
TP7965** MOVE ALL MONEY FROM ELEC AND GAS 30 DAY SINCE AMT GUARANTEED           
TP7965** IS MORE THAN 30 ELEC AND GAS.                                          
TP7965     IF WS-PAR-AMT-UTL-30     <= WS-AMT-TO-MOVE                   
TP7965        IF WS-PAR-AMT-UTE-30 > 0                                  
TP7965          MOVE WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)              
TP7965                                       TO WS-AMT-TO-MOVE          
TP7965          MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID      
TP7965          SUBTRACT WS-AMT-TO-MOVE                                 
TP7965                FROM WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)        
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-30          
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTE-30          
TP7965          PERFORM 1535-POPULATE-TO-JRNL    THRU 1535-EXIT         
TP7965        END-IF                                                    
TP7965        IF WS-PAR-AMT-UTG-30 > 0                                  
TP7965          MOVE WS-AMT-AR-DAY-30-AC (WS-UTG-AR-INDX)               
TP7965                                       TO WS-AMT-TO-MOVE          
TP7965          MOVE WS-ITEM-ID-AC (WS-UTG-AR-INDX) TO WS-ITEM-ID       
TP7965          SUBTRACT WS-AMT-TO-MOVE                                 
TP7965                  FROM WS-AMT-AR-DAY-30-AC (WS-UTG-AR-INDX)       
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-30          
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTG-30          
TP7965          MOVE WS-PAR-YES              TO WS-MOVING-UTG-SW        
TP7965          PERFORM 1535-POPULATE-TO-JRNL    THRU 1535-EXIT         
TP7965          MOVE WS-PAR-NO               TO WS-MOVING-UTG-SW        
TP7965        END-IF                                                    
TP7965     ELSE                                                         
TP7965        PERFORM 1550-CONTINUED             THRU 1550-CONT-EXIT    
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965 1550-EXIT.                                                       
TP7965     EXIT.                                                        
TP7965*                                                                         
TP7965** MOVE MONEY FROM ELEC AND GAS 30 DAY BY USING THE ALLOCATION            
TP7965** FACTOR SINCE THERE IS MORE 30 DAY MONEY THAN THE AMOUNT THAT           
TP7965** THE GUARANTOR HAS GUARANTEED.                                          
TP7965 1550-CONTINUED.                                                  
TP7965     IF WS-PAR-AMT-UTL-30     > WS-AMT-TO-MOVE                    
TP7965       COMPUTE WS-PAR-AMT-PMT-UTE-30 = WS-PAR-UTE-PERCENT-30      
TP7965                                     * WS-AMT-TO-MOVE             
TP7965       COMPUTE WS-PAR-AMT-PMT-UTG-30 = WS-AMT-TO-MOVE             
TP7965                                     - WS-PAR-AMT-PMT-UTE-30      
TP7965*                                                                         
TP7965       IF WS-PAR-AMT-PMT-UTE-30 > 0                               
TP7965        MOVE WS-PAR-AMT-PMT-UTE-30   TO WS-AMT-TO-MOVE            
TP7965        MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID        
TP7965        SUBTRACT WS-AMT-TO-MOVE                                   
TP7965                FROM WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)        
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-30            
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTE-30            
TP7965        PERFORM 1535-POPULATE-TO-JRNL      THRU 1535-EXIT         
TP7965       END-IF                                                     
TP7965       IF WS-PAR-AMT-PMT-UTG-30 > 0                               
TP7965        MOVE WS-PAR-AMT-PMT-UTG-30   TO WS-AMT-TO-MOVE            
TP7965        MOVE WS-ITEM-ID-AC (WS-UTG-AR-INDX) TO WS-ITEM-ID         
TP7965        SUBTRACT WS-AMT-TO-MOVE                                   
TP7965                FROM WS-AMT-AR-DAY-30-AC (WS-UTG-AR-INDX)         
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-30            
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTG-30            
TP7965        MOVE WS-PAR-YES              TO WS-MOVING-UTG-SW          
TP7965        PERFORM 1535-POPULATE-TO-JRNL      THRU 1535-EXIT         
TP7965        MOVE WS-PAR-NO               TO WS-MOVING-UTG-SW          
TP7965       END-IF                                                     
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965 1550-CONT-EXIT.                                                  
TP7965     EXIT.                                                        
TP7965*                                                                         
TP7965****************************************************************          
TP7965* MOVE ELEC AND GAS OFF OF THE ACCOUNT SINCE AN ALLOCATION MAY *          
TP7965* NEED TO BE DONE AND THERE IS ONLY ONE ENTRY IN THE AR PMT    *          
TP7965* PRTY TABLE FOR BOTH ELEC AND GAS.                            *          
TP7965****************************************************************          
TP7965 1555-DET-00-DAY-ELEC-GAS.                                        
TP7965** MOVE ALL MONEY FROM ELEC AND GAS 00 DAY SINCE AMT GUARANTEED           
TP7965** IS MORE THAN 00 ELEC AND GAS.                                          
TP7965     IF WS-PAR-AMT-UTL-00     <= WS-AMT-TO-MOVE                   
TP7965        IF WS-PAR-AMT-UTE-00 > 0                                  
TP7965          MOVE WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)              
TP7965                                       TO WS-AMT-TO-MOVE          
TP7965          MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID      
TP7965          SUBTRACT WS-AMT-TO-MOVE                                 
TP7965                FROM WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)        
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-00          
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTE-00          
TP7965          PERFORM 1535-POPULATE-TO-JRNL    THRU 1535-EXIT         
TP7965        END-IF                                                    
TP7965        IF WS-PAR-AMT-UTG-00 > 0                                  
TP7965          MOVE WS-AMT-AR-DAY-00-AC (WS-UTG-AR-INDX)               
TP7965                                       TO WS-AMT-TO-MOVE          
TP7965          MOVE WS-ITEM-ID-AC (WS-UTG-AR-INDX) TO WS-ITEM-ID       
TP7965          SUBTRACT WS-AMT-TO-MOVE                                 
TP7965                  FROM WS-AMT-AR-DAY-00-AC (WS-UTG-AR-INDX)       
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-00          
TP7965          SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTG-00          
TP7965          MOVE WS-PAR-YES              TO WS-MOVING-UTG-SW        
TP7965          PERFORM 1535-POPULATE-TO-JRNL    THRU 1535-EXIT         
TP7965          MOVE WS-PAR-NO               TO WS-MOVING-UTG-SW        
TP7965        END-IF                                                    
TP7965     ELSE                                                         
TP7965        PERFORM 1555-CONTINUED             THRU 1555-CONT-EXIT    
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965 1555-EXIT.                                                       
TP7965     EXIT.                                                        
TP7965*                                                                         
TP7965** MOVE MONEY FROM ELEC AND GAS 00 DAY BY USING THE ALLOCATION            
TP7965** FACTOR SINCE THERE IS MORE 00 DAY MONEY THAN THE AMOUNT THAT           
TP7965** THE GUARANTOR HAS GUARANTEED.                                          
TP7965 1555-CONTINUED.                                                  
TP7965     IF WS-PAR-AMT-UTL-00     > WS-AMT-TO-MOVE                    
TP7965       COMPUTE WS-PAR-AMT-PMT-UTE-00 = WS-PAR-UTE-PERCENT-00      
TP7965                                     * WS-AMT-TO-MOVE             
TP7965       COMPUTE WS-PAR-AMT-PMT-UTG-00 = WS-AMT-TO-MOVE             
TP7965                                     - WS-PAR-AMT-PMT-UTE-00      
TP7965*                                                                         
TP7965       IF WS-PAR-AMT-PMT-UTE-00 > 0                               
TP7965        MOVE WS-PAR-AMT-PMT-UTE-00   TO WS-AMT-TO-MOVE            
TP7965        MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-ITEM-ID        
TP7965        SUBTRACT WS-AMT-TO-MOVE                                   
TP7965                FROM WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)        
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-00            
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTE-00            
TP7965        PERFORM 1535-POPULATE-TO-JRNL      THRU 1535-EXIT         
TP7965       END-IF                                                     
TP7965       IF WS-PAR-AMT-PMT-UTG-00 > 0                               
TP7965        MOVE WS-PAR-AMT-PMT-UTG-00   TO WS-AMT-TO-MOVE            
TP7965        MOVE WS-ITEM-ID-AC (WS-UTG-AR-INDX) TO WS-ITEM-ID         
TP7965        SUBTRACT WS-AMT-TO-MOVE                                   
TP7965                FROM WS-AMT-AR-DAY-00-AC (WS-UTG-AR-INDX)         
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTL-00            
TP7965        SUBTRACT WS-AMT-TO-MOVE FROM WS-PAR-AMT-UTG-00            
TP7965        MOVE WS-PAR-YES              TO WS-MOVING-UTG-SW          
TP7965        PERFORM 1535-POPULATE-TO-JRNL      THRU 1535-EXIT         
TP7965        MOVE WS-PAR-NO               TO WS-MOVING-UTG-SW          
TP7965       END-IF                                                     
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965 1555-CONT-EXIT.                                                  
TP7965     EXIT.                                                        
TP7965*                                                                         
TP7965****************************************************************          
TP7965* CREATE A WORK QUEUE SINCE AN ACCOUNT IS AN ACTIVE GUARANTOR  *          
TP7965* BUT THE GUARANTOR ACCOUNT HAS BEEN FINALL BILLED.            *          
TP7965****************************************************************          
TP7965 1560-CREATE-GUAR-WQ.                                             
TP7965     IF LS-CURR-WQ-ITEM = 50                                      
TP7965        DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
TP7965        DISPLAY 'PROCESSING TERMINATED'                           
TP7965        MOVE 16 TO RETURN-CODE                                    
TP7965        PERFORM 9999-BAIL-OUT THRU 9999-EXIT                      
TP7965     ELSE                                                         
TP7965        ADD 1 TO LS-CURR-WQ-ITEM                                  
TP7965        SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
T22729        IF AT-CODE-ACCT-STAT = WS-FINAL-BILL                      
TP7965           MOVE WS-GUAR-MSG-PART1   TO WS-GUAR-MSG(1:19)          
T22729        ELSE                                                      
T22729           MOVE WS-GUAR-MSG-PART2   TO WS-GUAR-MSG(1:19)          
T22729        END-IF                                                    
TP7965        MOVE GU-GUARNTR-ACCT-NO  TO WS-GUAR-MSG-ACCOUNT-NUM       
TP7965        MOVE WS-GUAR-MSG-ACCOUNT TO WS-GUAR-MSG(20:13)            
TP7965        MOVE WS-GUAR-MSG-PART3   TO WS-GUAR-MSG(33:30)            
TP7965        MOVE WS-GUARANTOR-FINALLED-WQ-MSG                         
TP7965          TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
TP7965     END-IF.                                                      
TP7965                                                                  
TP7965 1560-EXIT.                                                       
TP7965     EXIT.                                                        
TP7965*                                                                         
T23011****************************************************************          
T23011* CREATE A WORK QUEUE SINCE AN ACCOUNT IS TRANSFERING RECV     *          
T23011* FROM THE GUARANTEE BUT ALSO HAS RECV OTHER THAN UTE,UTG,LPC. *          
T23011****************************************************************          
T23011*1565-CREATE-GUAR-RECV-WQ.                                                
T23011*    IF LS-CURR-WQ-ITEM = 50                                              
T23011*       DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                         
T23011*       DISPLAY 'PROCESSING TERMINATED'                                   
T23011*       MOVE 16 TO RETURN-CODE                                            
T23011*       PERFORM 9999-BAIL-OUT THRU 9999-EXIT                              
T23011*    ELSE                                                                 
T23011*       ADD 1 TO LS-CURR-WQ-ITEM                                          
T23011*       SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                            
T23011*       MOVE WS-GUAR-RECV-MSG-PART1 TO WS-GUAR-RECV-MSG(1:53)             
T23011*       MOVE WS-GUAR-RECV-MSG-PART2 TO WS-GUAR-RECV-MSG(54:52)            
T23011*       MOVE GU-GUARNTR-ACCT-NO     TO WS-GUAR-RECV-ACCOUNT               
T23011*       MOVE WS-GUAR-RECV-ACCOUNT   TO WS-GUAR-RECV-MSG(106:13)           
T23011*       MOVE WS-GUARANTOR-RECV-WQ-MSG                                     
T23011*         TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)                
T23011*    END-IF.                                                              
T23011*1565-EXIT.                                                               
T23011*    EXIT.                                                                
TP7965****************************************************************          
TP7965* SAVE OFF INFO ABOUT MONEY BEING MOVED TO BE11 TO THE WORKING *          
TP7965* STORAGE TABLE AC3.                                           *          
TP7965****************************************************************          
TP7965 1570-SAVE-INFO-TO-AC3.                                           
TP7965*                                                                         
TP7965     EVALUATE WS-PYMT-PRIORITY-LVL-AC2                            
TP7965       WHEN WS-VALUE-30                                           
TP7965         SET WS-AR-DATA-INDX3         TO WS-LPC-AR-INDX3          
TP7965       WHEN WS-VALUE-40                                           
TP7965         SET WS-AR-DATA-INDX3         TO WS-UTE-AR-INDX3          
TP7965       WHEN WS-VALUE-45                                           
TP7965         SET WS-AR-DATA-INDX3         TO WS-UTG-AR-INDX3          
TP7965     END-EVALUATE.                                                
TP7965*                                                                         
TP7965     MOVE GU-GUARNTR-ACCT-NO                                      
TP7965                 TO WS-ACCOUNT-NO-AC3 (WS-AR-DATA-INDX3)          
TP7965     MOVE WS-PYMT-PRIORITY-LVL-AC2                                
TP7965                 TO WS-PYMT-PRIORITY-LVL-AC3 (WS-AR-DATA-INDX3).  
TP7965     IF WS-MOVING-UTG                                             
TP7965       MOVE WS-ITEM-ID-AC (WS-UTG-AR-INDX)                        
TP7965                 TO WS-ITEM-ID-AC3 (WS-AR-DATA-INDX3)             
TP7965     ELSE                                                         
TP7965       MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX)                       
TP7965                 TO WS-ITEM-ID-AC3 (WS-AR-DATA-INDX3)             
TP7965     END-IF.                                                      
TP7965*                                                                         
TP7965     EVALUATE WS-APPL-AGING (WS-PAR-SUB)                          
TP7965       WHEN WS-90-DAY                                             
TP7965         MOVE WS-AMT-TO-MOVE                                      
TP7965                     TO WS-AMT-AR-DAY-90-AC3 (WS-AR-DATA-INDX3)   
TP7965       WHEN WS-60-DAY                                             
TP7965         MOVE WS-AMT-TO-MOVE                                      
TP7965                     TO WS-AMT-AR-DAY-60-AC3 (WS-AR-DATA-INDX3)   
TP7965       WHEN WS-30-DAY                                             
TP7965         MOVE WS-AMT-TO-MOVE                                      
TP7965                     TO WS-AMT-AR-DAY-30-AC3 (WS-AR-DATA-INDX3)   
TP7965       WHEN WS-00-DAY                                             
TP7965         MOVE WS-AMT-TO-MOVE                                      
TP7965                     TO WS-AMT-AR-DAY-00-AC3 (WS-AR-DATA-INDX3)   
TP7965     END-EVALUATE.                                                
TP7965*                                                                         
TP7965     MOVE WS-PAR-A                                                
TP7965             TO WS-XFER-TO-GUARANTOR-IND-AC3 (WS-AR-DATA-INDX3).  
TP7965*                                                                         
TP7965 1570-EXIT.                                                       
TP7965     EXIT.                                                        
TP7965*                                                                         
TP7965****************************************************************          
TP7965* MOVE AC3 TABLE ENTRIES THAT HAVE INFO TO THE BE11 AREA AND   *          
TP7965* CREATE THE BE11 RECORDS FOR THE XFER TO ONE GUARANTOR.       *          
TP7965****************************************************************          
TP7965 1580-INIT-PENDING-XFER.                                          
TP7965     IF WS-ACCOUNT-NO-AC3 (WS-AR-DATA-INDX3) > 0                  
TP7965        MOVE WS-AR-DATA-AC3 (WS-AR-DATA-INDX3) TO WS-AC-TABLE     
TP7965        PERFORM 8100-WRITE-MASTER-AR-CNTRL THRU 8100-EXIT         
TP7965     END-IF.                                                      
TP7965 1580-EXIT.                                                       
TP7965     EXIT.                                                        
      ****************************************************************          
T18042* CREATE A WORK QUEUE WHEN THE TRANSFER TO ACCOUNT IS EITHER   *          
T18042* FINAL BILLED OR WRITE OFF. DON'T TRANSFER MONEY              *          
C35244* ALSO ACTIVE EPP ACCTS. DON'T TRANSFER MONEY                  *          
T18042****************************************************************          
T18042 1590-CREATE-FINAL-XFER-TO-WQ.                                    
T18042     IF LS-CURR-WQ-ITEM = 50                                      
T18042        DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
T18042        DISPLAY 'PROCESSING TERMINATED'                           
T18042        MOVE 16 TO RETURN-CODE                                    
T18042        PERFORM 9999-BAIL-OUT THRU 9999-EXIT                      
T18042     ELSE                                                         
T18042        ADD 1 TO LS-CURR-WQ-ITEM                                  
T18042        SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
A03153        MOVE WS-FINAL-MSG-PART   TO WS-FINALLED-MSG(1:67)         
T18042        MOVE WS-XFER-TO-ACCT   TO WS-TRANSFER-TO-MSG-ACCOUNT-NUM  
A03153        MOVE WS-TRANSFER-TO-MSG-ACCOUNT TO WS-FINALLED-MSG(68:13) 
T18042        MOVE WS-TRANSFER-TO-FINALLED-WQ-MSG                       
T18042          TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
T21753*                                                                         
T21753        IF WS-SECURED-RATE-FL = 'Y'                               
T21753           MOVE +138 TO WS-CATEGORY-ID-WF(WS-BILL-WQ-INDX)        
T21753        END-IF                                                    
C35244        IF (WS-BUDGET-FL = 'A' AND                                
C35244         WS-ACCT-TO-CODE-STAT EQUAL WS-NORMAL-BILL)               
T35244           MOVE +152 TO WS-CATEGORY-ID-WF(WS-BILL-WQ-INDX)        
T35244        END-IF                                                    
T21753*                                                                         
T18042     END-IF.                                                      
T18042                                                                  
T18042 1590-EXIT.                                                       
T18042     EXIT.                                                        
T18042*                                                                         
      *                                                                         
      ****************************************************************          
T28018* CREATE A WORK QUEUE WHEN THE MASTER ACCOUNT IS EITHER        *          
T28018* FINAL BILLED OR WRITE OFF.                                   *          
T28018****************************************************************          
T28018 1595-CREATE-FINAL-XFER-WQ.                                       
T28018     IF LS-CURR-WQ-ITEM = 50                                      
T28018        DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
T28018        DISPLAY 'PROCESSING TERMINATED'                           
T28018        MOVE 16 TO RETURN-CODE                                    
T28018        PERFORM 9999-BAIL-OUT THRU 9999-EXIT                      
T28018     ELSE                                                         
T28018        ADD 1 TO LS-CURR-WQ-ITEM                                  
T28018        SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
T28018        MOVE WS-XFER-TO-ACCT   TO WS-TRANSFER-TO-MSG-ACCOUNT-NUM  
T28018        MOVE WS-CONSLDT-XFER-WQ-MSG                               
T28018          TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
T28018     END-IF.                                                      
T28018                                                                  
T28018 1595-EXIT.                                                       
T28018     EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 2200-WRITE-TRANSFER-JRNL                                     *          
      *                                                              *          
      ****************************************************************          
       2200-WRITE-TRANSFER-JRNL.                                        
           MOVE WS-103                  TO WS-103-JRNL-FORMAT-NO.       
           MOVE WS-X                    TO WS-103-CASH-DRAWER-USED.     
           MOVE WS-TRANSFER-AMT         TO WS-103-AMOUNT-ENTERED        
                                           WS-103-AMT-POSTED.           
           MOVE WS-TRANSFER-DR-GL       TO WS-103-ACCT-GEN-LED-DR.      
           MOVE WS-TRANSFER-CR-GL       TO WS-103-ACCT-GEN-LED-CR.      
           MOVE WS-AR-AGE               TO WS-103-AR-AGE                
           MOVE WS-DATE-BILLED-BI       TO WS-103-DATE-AR-BILLED.       
           MOVE WS-ITEM-ID              TO WS-103-ITEM-ID-NO.           
           MOVE WS-ACCT-NO-TO-FROM      TO WS-103-TRAN-ACCT-NO          
           MOVE WS-REV-DISTRICT-CD-PR  TO WS-103-CODE-REVENUE-DISTRICT. 
           MOVE WS-CODE-EMPL-ACCT-CU    TO WS-103-CODE-EMPL-ACCT.       
           MOVE WS-CODE-COMPANY-ACCT-AT TO WS-103-CODE-COMPANY-ACCT.    
           MOVE WS-CODE-ACCT-STAT-AT    TO WS-103-CODE-ACCT-STATUS.     
           MOVE WS-CODE-PREMISE-STAT-PR TO WS-103-CODE-PREMISE-STATUS.  
           MOVE WS-ASCENDING            TO E-FWK03-JRNL-SORT-ID.        
           MOVE WS-CUSTOMER-NO-CU       TO E-FWK03-CUSTOMER-NO.         
           MOVE WS-ACCOUNT-NO-AT        TO E-FWK03-ACCT-NO.             
           MOVE WS-COMPANY-NO-AT        TO E-FWK03-COMPANY-NO.          
           MOVE WS-LOCAL-OFFICE-AT      TO E-FWK03-LOCAL-OFFICE.        
           MOVE WS-BILL                 TO E-FWK03-CODE-TERMINAL-TRAN.  
           ADD 1 TO WS-TRAN-APPL-NO                                     
           MOVE WS-TRAN-APPL-NO         TO E-FWK03-JRNL-TRAN-APPL-NO.   
           MOVE LS-INPUT-DATE           TO WS-JRNL-TRAN-DATE            
                                           E-FWK03-DATE-LAST-ACTION.    
           MOVE WS-BATCH                TO E-FWK03-CODE-ENTRY-SOURCE.   
           MOVE CJF00103                TO E-FWK03-USER-DEFINED-AREA.   
           MOVE WS-JRNL-ONLY            TO WS-JRNL-OPERATION-RQST       
           MOVE ZEROS                   TO E-FWK03-SORT-SUM-FLD.        
           MOVE SPACES                  TO E-FWK03-TRAN-ERRORS.         
           MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-BT-AUTH-TYPE         
           MOVE ZEROES                  TO WS-JRNL-BT-ENTRY-LOC-OFF.    
           MOVE WS-103-ACCT-END-AR-BAL  TO WS-TOTAL-AR-BALANCE-AT.      
           PERFORM 8900-WRITE-FIOWK03 THRU 8900-EXIT.                   
       2200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *  5XXX SERIES PARAGRAPHS ARE "COMMON" OR "UTILITY" PARAGRAPHS   *        
      *                                                                *        
      ******************************************************************        
      ****************************************************************          
      *                                                              *          
      * 5110-SELECT-GL-FROM-OTHER                                    *          
      *      THIS PARAGRAPH PICKS THE TRANSFER CR AND DR DEPENDING   *          
      *      ON THE RECEIVABLE TYPE. THIS IS FOR OTHER   RECEIVABLES *          
      *                                                              *          
      ****************************************************************          
       5110-SELECT-GL-FROM-OTHER.                                       
           MOVE WS-PYMT-PRIORITY-LVL-AC2 TO WS-PYMT-LVL-CHECK           
           IF WS-TRANSFER-AMT >= 0                                      
              MOVE WS-CLEARING-GL TO WS-TRANSFER-DR-GL                  
              EVALUATE TRUE                                             
                  WHEN UTE                                              
                     MOVE WS-AR-UTE-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-CR-GL                             
                  WHEN UTG                                              
                     MOVE WS-AR-UTG-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-CR-GL                             
                  WHEN NSA                                              
                     MOVE WS-AR-NSA-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-CR-GL                             
                  WHEN DEP                                              
                     MOVE WS-AR-DEP-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-CR-GL                             
                  WHEN DFA                                              
                     MOVE WS-AR-DFA-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-CR-GL                             
                  WHEN CNT                                              
                     MOVE WS-AR-CNT-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-CR-GL                             
                  WHEN CCC                                              
                     MOVE WS-AR-CCC-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-CR-GL                             
                  WHEN CIA                                              
                     MOVE WS-AR-CIA-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-CR-GL                             
                  WHEN PJS                                              
                     MOVE WS-AR-PJS-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-CR-GL                             
                  WHEN LPC                                              
                     MOVE WS-AR-LPC-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-CR-GL                             
              END-EVALUATE                                              
           ELSE                                                         
              MOVE WS-CLEARING-GL TO WS-TRANSFER-CR-GL                  
              EVALUATE TRUE                                             
                  WHEN UTE                                              
                     MOVE WS-AR-UTE-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-DR-GL                             
                  WHEN UTG                                              
                     MOVE WS-AR-UTG-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-DR-GL                             
                  WHEN NSA                                              
                     MOVE WS-AR-NSA-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-DR-GL                             
                  WHEN DEP                                              
                     MOVE WS-AR-DEP-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-DR-GL                             
                  WHEN DFA                                              
                     MOVE WS-AR-DFA-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-DR-GL                             
                  WHEN CNT                                              
                     MOVE WS-AR-CNT-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-DR-GL                             
                  WHEN CCC                                              
                     MOVE WS-AR-CCC-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-DR-GL                             
                  WHEN CIA                                              
                     MOVE WS-AR-CIA-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-DR-GL                             
                  WHEN PJS                                              
                     MOVE WS-AR-PJS-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-DR-GL                             
                  WHEN LPC                                              
                     MOVE WS-AR-LPC-GL-NO (WS-GL-SUB) TO                
                          WS-TRANSFER-DR-GL                             
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
       5110-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *     5400-PROCESS-EXCEPTION                                     *        
      *  SET UP WORK QUEUE VARIABLES                                   *        
      *                                                                *        
      ******************************************************************        
       5400-PROCESS-EXCEPTION.                                          
           IF WS-EXCEPTION-CODE-WQ = WS-REJECT                          
              MOVE WS-CALC-ERROR                                        
                TO WS-CODE-BILL-ITM-IND-BG (WS-BILLING-INDX)            
              MOVE WS-UPDATE                                            
                TO WS-UPDATE-ACTION-IND-BG (WS-BILLING-INDX)            
           ELSE                                                         
              MOVE WS-YES TO WS-WARNING-BILL-IND-BI                     
           END-IF.                                                      
           MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)                  
             TO WS-CODE-UTIL-TYPE-WQ.                                   
           MOVE WS-IC-NO-BG (WS-BILLING-INDX) TO WS-IC-NO-WQ.           
           MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)                    
             TO WS-RATE-PLAN-NO-WQ.                                     
           MOVE WS-SQL-ERROR-TXT-WQ                                     
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:).  
           COMPUTE WS-START-POS                                         
                = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1.             
           ADD WS-SUPPLEMENTAL-TXT-LEN-WQ                               
             TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                   
      *                                                                         
       5400-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      /* 5900-CALC-VARCHAR-LENGTH. (PERFORMED FROM CPD00070)                    
      ***COPY CPD00060.                                                         
TP7965**************************************************************            
TP7965* COPYBOOK FOR LOADING INFO FROM CSS_AR_PMT_PRTY.            *            
TP7965* 6721X-LOAD-PYMT-PRTY-TABLE                                 *            
TP7965**************************************************************            
TP7965     EXEC SQL                                                             
TP7965         INCLUDE CPD0130B                                                 
TP7965     END-EXEC.                                                            
P00599**************************************************************            
P00599**  6600-PROCESS-CALC-NEW-SEQ-NO.                            *            
P00599**************************************************************            
P00599                                                                  
P00599     EXEC SQL                                                             
P00599         INCLUDE CPD00348                                                 
P00599     END-EXEC.                                                            
P00599                                                                  
      **************************************************************            
      *                                                            *            
      *    7200-OPEN-GUARANTOR-CURSOR                              *            
      *                                                            *            
      **************************************************************            
       7200-OPEN-GUARANTOR-CURSOR.                                      
           EXEC SQL                                                     
               OPEN GUARANTOR_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'GU'                TO WS-DB2-TABLE-ID               
              MOVE 'OPEN'              TO WS-DB2-FUNCTION               
              MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
              MOVE '115'               TO WS-DB2-MODULE-ID              
              MOVE '7200'              TO WS-DB2-PARAGRAPH              
              MOVE GU-ACCOUNT-NO       TO WS-DB2-KEY-1N                 
              MOVE 12                  TO RETURN-CODE                   
              PERFORM 9900-SQL-ERROR   THRU 9900-EXIT                   
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      *                                                             *           
      *         7210-FETCH-GUARANTOR-CURSOR                         *           
      *                                                             *           
      **************************************************************            
       7210-FETCH-GUARANTOR-CURSOR.                                     
           EXEC SQL                                                     
               FETCH GUARANTOR_CURSOR                                   
               INTO  :GU-GUARNTR-ACCT-NO,                               
                     :GU-AMOUNT-GUARANTEED,                             
                     :GU-GUAR-ESTBLSH-DT,                               
                     :GU-SERVICE-TYPE-CD                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'GU'                    TO WS-DB2-TABLE-ID           
              MOVE 'FETCH'                 TO WS-DB2-FUNCTION           
              MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
              MOVE '115'                   TO WS-DB2-MODULE-ID          
              MOVE '7210'                  TO WS-DB2-PARAGRAPH          
              MOVE GU-ACCOUNT-NO           TO WS-DB2-KEY-1N             
              MOVE 12                      TO RETURN-CODE               
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
       7210-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      *        7220-CLOSE-GUARANTOR-CURSOR                         *            
      *                                                            *            
      **************************************************************            
       7220-CLOSE-GUARANTOR-CURSOR.                                     
           EXEC SQL                                                     
              CLOSE GUARANTOR_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'GU'                    TO WS-DB2-TABLE-ID           
              MOVE 'CLOSE'                 TO WS-DB2-FUNCTION           
              MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
              MOVE '115'                   TO WS-DB2-MODULE-ID          
              MOVE '7220'                  TO WS-DB2-PARAGRAPH          
              MOVE GU-ACCOUNT-NO           TO WS-DB2-KEY-1N             
              MOVE 12                      TO RETURN-CODE               
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
       7220-EXIT.                                                       
           EXIT.                                                        
T18042******************************************************************        
T18042*    SELECT TRANSFER TO'S ACCOUNT STATUS.                                 
T18042******************************************************************        
T18042 7400-GET-CODE-ACCT-STAT.                                         
T18042     EXEC SQL                                                     
T18042        SELECT CODE_ACCT_STAT,                                    
T35244               CIS.SUBSTR3(CODES_DATA_PRESENT,3,1)                     
T18042          INTO :WS-ACCT-TO-CODE-STAT,                             
T35244               :WS-BUDGET-FL                                      
T18042          FROM CSS_ACCOUNT                                        
T18042         WHERE ACCOUNT_NO = :WS-XFER-TO-ACCT                      
T18042     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_ACCT_STAT,                                            
MFA-TR*              SUBSTR(CODES_DATA_PRESENT,3,1)                             
MFA-TR*         INTO :WS-ACCT-TO-CODE-STAT,                                     
MFA-TR*              :WS-BUDGET-FL                                              
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :WS-XFER-TO-ACCT                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T18042     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T18042     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
T35244        MOVE  SPACES           TO WS-BUDGET-FL                    
T18042        MOVE 'AT'              TO WS-DB2-TABLE-ID                 
T18042        MOVE 'SELECT'          TO WS-DB2-FUNCTION                 
T18042        MOVE SQLCODE           TO WS-DB2-RETURN-CODE              
T18042        MOVE '115'             TO WS-DB2-MODULE-ID                
T18042        MOVE '7400'            TO WS-DB2-PARAGRAPH                
T18042        MOVE 16                TO RETURN-CODE                     
T18042        PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
T18042     END-IF.                                                      
T18042 7400-EXIT.                                                       
T18042     EXIT.                                                        
      **************************************************************            
      *                                                            *            
      *    7500-GET-CURRENT-TIMESTAMP                              *            
      *                                                            *            
      **************************************************************            
       7500-GET-CURRENT-TIMESTAMP.                                      
           EXEC SQL                                                     
T33182        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'MS'              TO WS-DB2-TABLE-ID                 
              MOVE 'SELECT'          TO WS-DB2-FUNCTION                 
              MOVE SQLCODE           TO WS-DB2-RETURN-CODE              
              MOVE '115'             TO WS-DB2-MODULE-ID                
              MOVE '7500'            TO WS-DB2-PARAGRAPH                
              MOVE 16                TO RETURN-CODE                     
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
           END-IF.                                                      
       7500-EXIT.                                                       
           EXIT.                                                        
TP7965******************************************************************        
TP7965*    SELECT GUARANTOR'S ACCOUNT STATUS.                                   
TP7965******************************************************************        
TP7965 7600-SELECT-GUAR-ACCOUNT.                                        
TP7965     EXEC SQL                                                     
TP7965        SELECT CODE_ACCT_STAT                                     
TP7965          INTO :AT-CODE-ACCT-STAT                                 
TP7965          FROM CSS_ACCOUNT                                        
TP7965         WHERE ACCOUNT_NO = :GU-GUARNTR-ACCT-NO                   
TP7965     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP7965     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP7965     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
TP7965        MOVE 'AT'              TO WS-DB2-TABLE-ID                 
TP7965        MOVE 'SELECT'          TO WS-DB2-FUNCTION                 
TP7965        MOVE SQLCODE           TO WS-DB2-RETURN-CODE              
TP7965        MOVE '115'             TO WS-DB2-MODULE-ID                
TP7965        MOVE '7600'            TO WS-DB2-PARAGRAPH                
TP7965        MOVE 16                TO RETURN-CODE                     
TP7965        PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
TP7965     END-IF.                                                      
TP7965 7600-EXIT.                                                       
TP7965     EXIT.                                                        
TP7965******************************************************************        
TP7965*    UPDATE GUARANTOR STATUS AND THE STATUS REASON.                       
TP7965******************************************************************        
TP7965 8000-UPDATE-GUARANTOR-STATUS.                                    
TP7965     EXEC SQL                                                     
TP7965        UPDATE CSS_GUARANTOR                                      
TP7965           SET GUAR_STATUS_CD     = :GU-GUAR-STATUS-CD,           
TP7965               GUAR_STATUS_REASON = :GU-GUAR-STATUS-REASON,       
T15889               LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
TP7965         WHERE ACCOUNT_NO         = :GU-ACCOUNT-NO                
TP7965           AND GUARNTR_ACCT_NO    = :GU-GUARNTR-ACCT-NO           
TP7965     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_GUARANTOR                                              
MFA-TR*          SET GUAR_STATUS_CD     = :GU-GUAR-STATUS-CD,                   
MFA-TR*              GUAR_STATUS_REASON = :GU-GUAR-STATUS-REASON,               
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         = :GU-ACCOUNT-NO                        
MFA-TR*          AND GUARNTR_ACCT_NO    = :GU-GUARNTR-ACCT-NO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP7965     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP7965     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
TP7965        MOVE 'GU'              TO WS-DB2-TABLE-ID                 
TP7965        MOVE 'UPDATE'          TO WS-DB2-FUNCTION                 
TP7965        MOVE SQLCODE           TO WS-DB2-RETURN-CODE              
TP7965        MOVE '115'             TO WS-DB2-MODULE-ID                
TP7965        MOVE '8000'            TO WS-DB2-PARAGRAPH                
TP7965        MOVE 16                TO RETURN-CODE                     
TP7965        PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
TP7965     END-IF.                                                      
TP7965 8000-EXIT.                                                       
TP7965     EXIT.                                                        
P00599******************************************************************15170000
P00599* 8010-UPDATE-PROCESSED-FL                                       *15180000
P00599******************************************************************15190000
P00599                                                                  
P00599 8010-UPDATE-PROCESSED-FL.                                        
P00599                                                                  
P00599     EXEC SQL                                                     
P00599        UPDATE CSS_FIN_WO_ACTION                                  
P00599           SET FW_PROCESSED_FL     = 'Y'                          
P00599              ,FW_ACTION_AM        = :KD-FW-ACTION-AM             
P00599         WHERE ACCOUNT_NO          = :KD-ACCOUNT-NO               
P00599           AND FW_SEQ_NO           = :KD-FW-SEQ-NO                
P00599           AND FW_ACTION_TYPE_CD   = 'GAXF'                       
P00599                                                      
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIN_WO_ACTION                                          
MFA-TR*          SET FW_PROCESSED_FL     = 'Y'                                  
MFA-TR*             ,FW_ACTION_AM        = :KD-FW-ACTION-AM                     
MFA-TR*        WHERE ACCOUNT_NO          = :KD-ACCOUNT-NO                       
MFA-TR*          AND FW_SEQ_NO           = :KD-FW-SEQ-NO                        
MFA-TR*          AND FW_ACTION_TYPE_CD   = 'GAXF'                               
MFA-TR*      QUERYNO 8010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599                                                                  
P00599     IF SQLCODE = SUCCESSFUL-CALL                                 
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        MOVE 'KD'              TO WS-DB2-TABLE-ID                 
P00599        MOVE 'UPDATE'          TO WS-DB2-FUNCTION                 
P00599        MOVE SQLCODE           TO WS-DB2-RETURN-CODE              
P00599        MOVE '115'             TO WS-DB2-MODULE-ID                
P00599        MOVE '8010'            TO WS-DB2-PARAGRAPH                
P00599        MOVE KD-ACCOUNT-NO     TO WS-DB2-KEY-1N                   
P00599        MOVE KD-FW-SEQ-NO      TO WS-DB2-KEY-2N                   
P00599        MOVE 12                TO RETURN-CODE                     
P00599        PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
P00599     END-IF.                                                      
P00599                                                                  
P00599 8010-EXIT.                                                       
P00599     EXIT.                                                        
P00599                                                                  
      ****************************************************************          
      *                                                              *          
      * 8100-WRITE-MASTER-AR-CNTRL                                   *          
      *   WRITES THE AR-CNTRL FROM THE SUB TO THE MASTER             *          
      *                                                              *          
      ****************************************************************          
       8100-WRITE-MASTER-AR-CNTRL.                                      
           MOVE 2400                   TO XP-TABLE-ID.                  
T11939     MOVE WS-ACCOUNT-NO-AT       TO XP-ACCT-XFER-FROM             
I01959     IF TRANSFER-TO-ASSIGNEE                                      
I01959        MOVE WS-XFER-TO-ASSIGNEE-ACCT TO XP-ACCT-XFER-TO          
I01959     ELSE                                                         
              IF WS-TRANSFER-GUARANTEE                                  
                 MOVE GU-GUARNTR-ACCT-NO    TO XP-ACCT-XFER-TO          
              ELSE                                                      
                 MOVE WS-ACCT-XFER-TO-AT    TO XP-ACCT-XFER-TO          
              END-IF                                                    
I01959     END-IF.                                                      
           MOVE WS-AC-TABLE            TO XP-XFER-DATA-TEXT.            
           MOVE WS-PREMISE-NO-AT       TO XP-PREMISE-NO.                
           MOVE WS-LOCAL-OFFICE-AT     TO XP-LOCAL-OFFICE.              
           MOVE 9                      TO XP-PARTITION-ID.              
T11939     MOVE WS-YES                 TO XP-SUB-ACCT-BLLD-OK.          
T11939     MOVE LENGTH OF XP-XFER-DATA-TEXT TO XP-XFER-DATA-LEN         
T11939     PERFORM 8200-INSERT-PENDING-XFER THRU 8200-EXIT.             
       8100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 8120-WRITE-BILLING-DETAIL                                    *          
      *   WRITES THE BILLING DET  FOR THE MASTER                     *          
      *                                                              *          
      ****************************************************************          
       8120-WRITE-BILLING-DETAIL.                                       
           MOVE 1910                   TO XP-TABLE-ID.                  
T11939     MOVE WS-ACCOUNT-NO-AT       TO XP-ACCT-XFER-FROM             
           MOVE WS-ACCT-XFER-TO-AT     TO XP-ACCT-XFER-TO.              
           MOVE WS-BG-TABLE            TO XP-XFER-DATA-TEXT.            
           MOVE WS-PREMISE-NO-AT       TO XP-PREMISE-NO.                
           MOVE WS-LOCAL-OFFICE-AT     TO XP-LOCAL-OFFICE.              
           MOVE 9                      TO XP-PARTITION-ID.              
T11939     MOVE WS-YES                 TO XP-SUB-ACCT-BLLD-OK.          
T11939     MOVE LENGTH OF XP-XFER-DATA-TEXT TO XP-XFER-DATA-LEN         
T11939     PERFORM 8200-INSERT-PENDING-XFER THRU 8200-EXIT.             
       8120-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 8130-WRITE-CONSUMPTION                                       *          
      *   WRITES THE CONSUMPTION FOR THE MASTER                      *          
      *                                                              *          
      ****************************************************************          
       8130-WRITE-CONSUMPTION.                                          
           MOVE 2100                   TO XP-TABLE-ID.                  
T11939     MOVE WS-ACCOUNT-NO-AT       TO XP-ACCT-XFER-FROM             
           MOVE WS-ACCT-XFER-TO-AT     TO XP-ACCT-XFER-TO.              
           MOVE WS-CX-TABLE            TO XP-XFER-DATA-TEXT.            
           MOVE WS-PREMISE-NO-AT       TO XP-PREMISE-NO.                
           MOVE WS-LOCAL-OFFICE-AT     TO XP-LOCAL-OFFICE.              
           MOVE 9                      TO XP-PARTITION-ID.              
T11939     MOVE WS-YES                 TO XP-SUB-ACCT-BLLD-OK.          
T11939     MOVE LENGTH OF XP-XFER-DATA-TEXT TO XP-XFER-DATA-LEN         
T11939     PERFORM 8200-INSERT-PENDING-XFER THRU 8200-EXIT.             
       8130-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 8140-WRITE-UNMTRD-CNSMPTN                                    *          
      *                                                              *          
      ****************************************************************          
       8140-WRITE-UNMTRD-CNSMPTN.                                       
           MOVE 2200                   TO XP-TABLE-ID.                  
T11939     MOVE WS-ACCOUNT-NO-AT       TO XP-ACCT-XFER-FROM             
           MOVE WS-ACCT-XFER-TO-AT     TO XP-ACCT-XFER-TO.              
           MOVE WS-UC-TABLE            TO XP-XFER-DATA-TEXT.            
           MOVE WS-PREMISE-NO-AT       TO XP-PREMISE-NO.                
           MOVE WS-LOCAL-OFFICE-AT     TO XP-LOCAL-OFFICE.              
           MOVE 9                      TO XP-PARTITION-ID.              
T11939     MOVE WS-YES                 TO XP-SUB-ACCT-BLLD-OK.          
T11939     MOVE LENGTH OF XP-XFER-DATA-TEXT TO XP-XFER-DATA-LEN         
T11939     PERFORM 8200-INSERT-PENDING-XFER THRU 8200-EXIT.             
       8140-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 8200-INSERT-PENDING-XFER                                     *          
      *                                                              *          
      ****************************************************************          
T11939 8200-INSERT-PENDING-XFER.                                        
T7970      IF WS-ACCOUNT-NO-AT = WS-ACCOUNT-NO-PREV                     
T7970         ADD 1 TO WS-SEQ-NO                                        
T7970      ELSE                                                         
CSG803        PERFORM 8205-SELECT-MAX-SEQ-NO THRU 8205-EXIT             
CSG803        ADD +1 TO WS-SEQ-NO                                       
T7970         MOVE WS-ACCOUNT-NO-AT  TO WS-ACCOUNT-NO-PREV              
T7970      END-IF.                                                      
T7970      MOVE WS-SEQ-NO TO XP-SEQUENCE-NO.                            
           EXEC SQL                                                     
              INSERT INTO CSS_PENDING_XFER                              
                    (ACCT_XFER_TO,                                      
                     TABLE_ID,                                          
                     PARTITION_ID,                                      
                     LOCAL_OFFICE,                                      
                     PREMISE_NO,                                        
                     SEQUENCE_NO,                                       
                     SUB_ACCT_BLLD_OK,                                  
                     ACCT_XFER_FROM,                                    
                     XFER_DATA)                                         
             VALUES (:XP-ACCT-XFER-TO,                                  
                     :XP-TABLE-ID,                                      
                     :XP-PARTITION-ID,                                  
                     :XP-LOCAL-OFFICE,                                  
                     :XP-PREMISE-NO,                                    
                     :XP-SEQUENCE-NO,                                   
                     :XP-SUB-ACCT-BLLD-OK,                              
                     :XP-ACCT-XFER-FROM,                                
                     :XP-XFER-DATA)                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'XP'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '115'                TO WS-DB2-MODULE-ID             
              MOVE '8200'               TO WS-DB2-PARAGRAPH             
              MOVE XP-ACCT-XFER-FROM,   TO WS-DB2-KEY-1N                
              MOVE XP-TABLE-ID          TO WS-DB2-KEY-2N                
              MOVE XP-SEQUENCE-NO       TO WS-DB2-KEY-3N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8200-EXIT.                                                       
           EXIT.                                                        
CSG803 8205-SELECT-MAX-SEQ-NO.                                          
CSG803     EXEC SQL                                                     
CSG803        SELECT MAX(SEQUENCE_NO)                                   
T15190          INTO :XP-SEQUENCE-NO :XP-SEQUENCE-NO-IND                 
CSG803          FROM CSS_PENDING_XFER                                   
CSG803         WHERE ACCT_XFER_TO = :XP-ACCT-XFER-TO                    
CSG803           AND TABLE_ID = :XP-TABLE-ID                            
CSG803           AND PARTITION_ID = :XP-PARTITION-ID                    
CSG803           AND LOCAL_OFFICE = :XP-LOCAL-OFFICE                    
CSG803           AND PREMISE_NO = :XP-PREMISE-NO                        
CSG803     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T15190     IF XP-SEQUENCE-NO-IND EQUAL NULL-VALUE                       
T15190        MOVE NOT-FOUND TO WS-ACTIVE-RETURN-CODE                   
T15190     ELSE                                                         
T15190        MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
T15190     END-IF.                                                      
                                                                        
CSG803     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
CSG803        MOVE XP-SEQUENCE-NO TO WS-SEQ-NO                          
CSG803     ELSE                                                         
CSG803      IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
CSG803        MOVE ZERO TO WS-SEQ-NO                                    
CSG803      ELSE                                                        
CSG803        MOVE 'XP'                 TO WS-DB2-TABLE-ID              
CSG803        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
CSG803        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
CSG803        MOVE '115'                TO WS-DB2-MODULE-ID             
CSG803        MOVE '8205'               TO WS-DB2-PARAGRAPH             
CSG803        MOVE XP-ACCT-XFER-FROM,   TO WS-DB2-KEY-1N                
CSG803        MOVE XP-TABLE-ID          TO WS-DB2-KEY-2N                
CSG803        MOVE XP-SEQUENCE-NO       TO WS-DB2-KEY-3N                
CSG803        MOVE 12 TO RETURN-CODE                                    
CSG803        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
CSG803      END-IF                                                      
CSG803     END-IF.                                                      
CSG803 8205-EXIT.                                                       
CSG803     EXIT.                                                        
P00599                                                                  
P00599 8210-INSERT-FINAL-WO-ACTN.                                       
P00599                                                                  
P00599     EXEC SQL                                                     
P00599          INSERT INTO CSS_FIN_WO_ACTION                           
P00599               (ACCOUNT_NO,                                       
P00599                FW_SEQ_NO,                                        
P00599                FW_ACTION_TYPE_CD,                                
P00599                FW_ACTION_DT,                                     
P00599                FW_ACTION_AM,                                     
P00599                FW_MANUAL_FL,                                     
P00599                FW_BUS_PROCESS_CD,                                
P00599                FW_PROCESSED_FL,                                  
P00599                GUARANTOR_ACCT_NO,                                
P00599                FW_ACTION_COMMENTS)                               
P00599         VALUES                                                   
P00599               (:KD-ACCOUNT-NO,                                   
P00599                :KD-FW-SEQ-NO,                                    
P00599                :KD-FW-ACTION-TYPE-CD,                            
P00599                IIF(TRY_CONVERT(DATE, :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) ),                            
P00599                :KD-FW-ACTION-AM,                                 
P00599                :KD-FW-MANUAL-FL,                                 
P00599                :KD-FW-BUS-PROCESS-CD,                            
P00599                :KD-FW-PROCESSED-FL,                              
P00599                :KD-GUARANTOR-ACCT-NO,                            
P00599                :KD-FW-ACTION-COMMENTS)                           
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_FIN_WO_ACTION                                   
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*               FW_SEQ_NO,                                                
MFA-TR*               FW_ACTION_TYPE_CD,                                        
MFA-TR*               FW_ACTION_DT,                                             
MFA-TR*               FW_ACTION_AM,                                             
MFA-TR*               FW_MANUAL_FL,                                             
MFA-TR*               FW_BUS_PROCESS_CD,                                        
MFA-TR*               FW_PROCESSED_FL,                                          
MFA-TR*               GUARANTOR_ACCT_NO,                                        
MFA-TR*               FW_ACTION_COMMENTS)                                       
MFA-TR*        VALUES                                                           
MFA-TR*              (:KD-ACCOUNT-NO,                                           
MFA-TR*               :KD-FW-SEQ-NO,                                            
MFA-TR*               :KD-FW-ACTION-TYPE-CD,                                    
MFA-TR*               :KD-FW-ACTION-DT,                                         
MFA-TR*               :KD-FW-ACTION-AM,                                         
MFA-TR*               :KD-FW-MANUAL-FL,                                         
MFA-TR*               :KD-FW-BUS-PROCESS-CD,                                    
MFA-TR*               :KD-FW-PROCESSED-FL,                                      
MFA-TR*               :KD-GUARANTOR-ACCT-NO,                                    
MFA-TR*               :KD-FW-ACTION-COMMENTS)                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599                                                                  
P00599     IF SQLCODE = SUCCESSFUL-CALL                                 
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        MOVE 'KD'                 TO WS-DB2-TABLE-ID              
P00599        MOVE 'INSERT'             TO WS-DB2-FUNCTION              
P00599        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00599        MOVE '115'                TO WS-DB2-MODULE-ID             
P00599        MOVE '8210'               TO WS-DB2-PARAGRAPH             
P00599        MOVE KD-ACCOUNT-NO        TO WS-DB2-KEY-1N                
P00599        MOVE KD-FW-SEQ-NO         TO WS-DB2-KEY-2N                
P00599        MOVE KD-FW-ACTION-TYPE-CD TO WS-DB2-KEY-3N                
P00599        MOVE 12 TO RETURN-CODE                                    
P00599        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
P00599     END-IF.                                                      
P00599                                                                  
P00599 8210-EXIT.                                                       
P00599     EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 8900-WRITE-FIOWK03                                           *          
      *                                                              *          
      ****************************************************************          
       8900-WRITE-FIOWK03.                                              
           ADD 1 TO WS-WK03-COUNT                                       
T13536     IF WS-WK03-COUNT > 5000                                      
              MOVE 'WK03 HOLD TABLE OVERFLOW'                           
                TO WS-MISC-MSG-TEXT                                     
PCR629        MOVE +137 TO WS-MISC-CATEGORY                             
              MOVE +24 TO WS-MISC-MSG-LEN                               
              MOVE 16 TO RETURN-CODE                                    
              PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
           ELSE                                                         
              SET WK03-INDX TO WS-WK03-COUNT                            
              MOVE FIOWK03 TO WS-HOLD-WK03-DATA (WK03-INDX)             
              INITIALIZE FIOWK03                                        
           END-IF.                                                      
       8900-EXIT.                                                       
           EXIT.                                                        
P00599******************************************************************        
P00599* 9700-PROCESS-ABEND                                             *        
P00599******************************************************************        
P00599                                                                  
P00599 9700-PROCESS-ABEND.                                              
P00599                                                                  
P00599     MOVE HOSTVAR-ELEMENT-2    TO WS-HOST-ELEMENT.                
P00599     MOVE 'KD'                 TO WS-DB2-TABLE-ID.                
P00599     MOVE 'SELECT'             TO WS-DB2-FUNCTION.                
P00599     MOVE SQLCODE              TO WS-DB2-RETURN-CODE.             
P00599     MOVE ACTIVE-PARAGRAPH     TO WS-DB2-PARAGRAPH.               
P00599     MOVE '115'                TO WS-DB2-MODULE-ID.               
P00599     MOVE KD-ACCOUNT-NO        TO WS-DB2-KEY-1N.                  
P00599     MOVE WS-HOST-ELEMENT      TO WS-DB2-KEY-2N.                  
P00599     MOVE 12                   TO RETURN-CODE.                    
P00599     PERFORM 9900-SQL-ERROR    THRU 9900-EXIT.                    
P00599                                                                  
P00599 9700-EXIT.                                                       
P00599     EXIT.                                                        
P00599                                                                  
      ****************************************************************          
      *                                                              *          
      * 9900-SQL-ERROR                                               *          
      *                                                              *          
      ****************************************************************          
       9900-SQL-ERROR.                                                  
           IF WS-CURRENT-WQ-ITEM = 50                                   
              DISPLAY 'WS=BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO WS-CURRENT-WQ-ITEM                               
              SET WS-BILL-WQ-INDX TO WS-CURRENT-WQ-ITEM                 
           END-IF.                                                      
           MOVE WS-DATABASE-EXCEPTION                                   
             TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX).          
           COMPUTE WS-START-POS                                         
                =  WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1             
           MOVE WS-SQL-ERROR-TXT-WQ                                     
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)   
           ADD WS-SQL-ERROR-TXT-LEN-WQ                                  
            TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                    
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       9900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9910-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
                                                                        
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
           END-IF.                                                      
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       9910-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      *  9999-BAIL-OUT                                               *          
      *                                                              *          
      ****************************************************************          
       9999-BAIL-OUT.                                                   
           EXIT PROGRAM.                                                
       9999-EXIT.                                                       
           EXIT.                                                        
