       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA114.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      **  SUBROUTINE SCSCA114 IS A COMPONENT OF PCSCA100 (BATCH      **         
      **  BILLING).                                                  **         
      **                                                             **         
      **  CALLED BY: SCSCA110 WICH IS CALLED BY PCSCA100 (DRIVER)    **         
      **                                                             **         
      **  SCSCA114 UPDATES DB2 TABLES FOR AN ACCOUNT FROM THE BILL   **         
      **  EXTRACT (CWS10000/10001) FORMAT.  UPDATES UTILITY AND      **         
      **  BILL HISTORY INFORMATION.                                  **         
      **                                                             **         
      **  THIS PROGRAM WAS BASED ON S2K BASE PROGRAM PCSCA100.       **         
      **                                                             **         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  12-15-94            INITIAL SCE&G VERSION                  **         
      **  02-15-95     WTF    CONVERTED TO SUBROUTINE FOR 24 HR      **         
TP3309**  03-07-96     LMB    CONSUMPT-TYPE-CD INCORRECT FOR INSERT  **         
TP3309**                      INTO CSS_BILL_CALC_DET TABLE           **         
TP4314**  05-28-96     KMG    FIX LOGIC  TO INSERT BILL HDR FOR MST  **         
TP4508**  06-10-96     KMG    FIX LOGIC TO NOT ACCUM TO ANNUAL       **         
TP4508**                      SUMMARY TABLE FOR MASTER ACCOUNTS      **         
TP4688**  06-24-96     KMG    ONLY MOVE LS-INPUT DATE TO DATE BILLED **         
TP4688**  06-24-96            IF ON CYCLE                            **         
TP4822**  07-02-96     FSW    CORRECT -803 ABEND FOR MV90 ACCOUNTS   **         
TP4822**  06-02-96            WHEN INSERT CX ROWS                    **         
RSN2  **  07-17-96     RSN    WORK AROUND ADDED FOR CANCEL/REBILL.   **         
RSN2  **                      PENDING ON DISCUSSION WITH TIM FULLER  **         
      **  08/14/96     WTF    FIXED FH, BX, AND BK UPDATES TO MATCH  **         
      **                      DATABASE; MODIFIED BILL HOOK LOGIC     **         
      **                      (REF SCSCA102)                                    
TP4910**  09/10/96     TCB    ADDED CODE TO BYPASS CREATING A BILL   **         
TP4910**                      HOOK IF THERE IS NOT A UTIL ENVRNMT    **         
TP4910**                      FOR THE ACCOUNT (MASTER ACCOUNT).      **         
TP5281**  09/10/96     TCB    CHANGED CODE TO UPDATE BI AND AT BILL  **         
TP5281**                      NO WITH THE VALUE IN                   **         
TP5281**                      WS-NEXT-BILL-NO-CALC.                  **         
P356  **  09/11/96     WTF    ADDED UPDATE FOR STANDBY GENERATOR     **         
      **  10/23/96     CSG    TPRS 5521 AND 5837.                    **         
T5521 **                      ADDED LOGIC FOR METER'S WITH MULTIPLE  **         
      **                      REGISTERS - THE FIRST IS MONITOR ONLY- **         
      **                      TO STILL PROCESS AS ACTIVE.            **         
T5837 **                      CORRECTED LOGIC FOR CONSOLIDATED MSTR  **         
      **                      ACCOUNTS BILL HOOK CREATION.  THE BILL **         
      **                      HOOK WILL BE CREATED FOR ON-CYCLE MSTRS**         
TP4755**  11/06/96     JPC    TPR 4755 - UPDATE POINT ID TO X(10).   **         
TP4940**  02/11/97     FSW    TPR 4940 - INSERT CSS_BILL_ACCT_XFER   **         
TP6055**  3/12/97      ELJ    ACCOUNT_NO_SUMM COLUMN HAS BEEN DROPPED**         
      **                      FROM CSS_BILLING_HDR. ALL REFERENCE    **         
      **                      TO ACCOUNT_NO_SUMM AND IT'S RELATED    **         
      **                      COLUMNS NXT_SMRY_BILL_NO AND           **         
      **                      NXT_SMRY_REBILL_NO OF THE CSS_ACCOUNT  **         
      **                      TABLE SHOULD BE REMOVED.               **         
T8770 **  3/14/97      MJL    TPR 8770 WRITE TRANS HIST IF THERE WAS **         
      **                      A RATE CHANGE DURING BILLING           **         
T9914 **  4/01/97      MJL    TPR 9914 DO NOT USE METER NO. WHEN SEL **         
      **                      MAX SEQ NO. FROM CX.  USE MTR REF NO.  **         
      **                      IN PARA 8712.                          **         
T5502 **  4/10/97      MJL    MOVE LOGIC FROM CA114 TO CA113 TO      **         
      **                      UPDATE BILL HEADER.                    **         
T10791**  6/17/97      MJL    CHANGE LOGIC TO HAVE SUB ACCOUNTS WRITE**         
      **                      TO BILL_ACCT_XFER INSTEAD OF MASTER.   **         
PERF  **  01/05/98     PD     REDUCE WORKING STORAGE FOR ONLINE      **         
PERF  **                      BY SPLITING WORKING STORAGE FOR        **         
PERF  **                      ONLINE AND BATCH PROGRAMS USING        **         
PERF  **                      CWS10000 AND CWS10001.                 **         
T14555**  01/28/98    RAH     INCREASE CX OCCURANCES TO 200          **         
PCR629**  04/24/98    AMG     CHANGED THE CATEGORIES OF SOME         **         
PCR629**                      WORK QUEUES                            **         
T16109**  05/15/98    CSG     FILL REV. MO IF NOT ALREADY DONE IN 105**         
T17222**  08/12/98    RAQ     YTD ANNUAL SUMMARY SHOULD NOT BE       **         
T17222**                      MAINTAINED FOR CURRENT YEAR            **         
T17222**                      FOR PRIOR YEARS IF CANCEL/REBILL THEN  **         
T17222*                       CALCULATE NET VALUES AND UPDATE SUMMARY**         
T18995**  02/02/99    RAH     CHECK TO SEE IF ACCOUNT HAS BILLED OK  **         
T18995**                      BEFORE WRITING TO CSS_BILL_ACCT_XFER   **         
T21155**  11/11/99    RGB     CODE CHANGED TO FIX THE -803 ERROR     **         
T21155**                      DUIRNG INSERT INTO CSS_FIXED_FCT_HIST  **         
T21153**  11/16/99    RGB     CODE CHANGED TO FILL REVENUE MONTH     **         
T21153**                      BEFORE  UPDATING  CSS_BILLIGN_DET      **         
T21932**  03/23/00    RGB     REMOVED UPDATE\INSERT OF CSS_PEAK_HISTOR*         
T21932**                      TABLE SINCE LOGIC IS MOVED TO PCSBW112 **         
T22406**  06/26/00    RAH     ADD $1 BFC TO EMC SEB CUSTOMERS        **         
T22488**  07/24/00    RAH     HANDLE FH ROWS WITH DUPLICATE SEQ NOS  **         
T22570**  08/01/00    RAH     CANCEL/REBILLS MESSING UP BUILD UP CNTR**         
T23513**  01/31/00    CBSI    REPLACED TK-MKT-ID-CD = 'AGL' BY       **         
T23513**              MADRAS  SEB-DATABASE.                          **         
T23951**  07/27/01    SR16861 MOVED WS-COMPANY-NO-AT TO BG-COMPANY-NO**         
T23951**                      ADDED A DISPLAY IF THE BG-COMPANY-NO = **         
T23951**                      SPACES OR LOW-VALS BEFORE IT'S INSERTED**         
T23631**  07/31/01    VIJAY   CHANGES MADE TO ADD NEW FIELDS IN      **         
      **                      2250-PROCESS-CONTRACT-HISTORY.         **         
C23632** 08/27/01     GSR     CHANGES MADE TO INCREASE THE           ** 00110000
C23632**                      OCCURRENCES TO HANDLE UPTO 50 METERS.  ** 00110000
T23301**  10/16/01    VIJAY   CHANGES MADE TO INCLUDE WNA_COMP_AM.   **         
T23631**  10/29/01    VIJAY   ADDED SHIPPER CODE MOVE TO BX TABLE.   **         
T25885**  01/16/02    GANESH  CHANGES MADE TO POPULATE THE CURR      **         
T25885**                      REVENUE MONTH FOR THE BACK OUT ROWS    **         
T25762**  02/06/02    VIJAY   ADDED VERS_PRORATE_CD TO BILL CONTRACT **         
T25762**                      HISTORY TABLE.                         **         
T26639** 06/27/02    COVANSYS CODE FOR SETTING PRORATE_CD PROPERLY IN**         
T26639**             CHENNAI  CSS_BILLING_DETAIL                     **         
T23951**  09/12/02    VIJAY   MOVE STATEMENT OF COMPANY-NO MOVED TO  **         
T23951**                      PROPER PLACE TO AVOID NULL VALUES.     **         
CIG   *  10/01/02    GANESH   CHANGES MADE TO SUPPORT THE INDUSTRIAL **         
CIG   *                       GAS CUSTOMERS IN OUR CIS SYSTEM.       **         
C29528*  03/12/04    GANESH   CHANGES MADE TO ADD STATE AND FRANCHISE**         
C29528*                       TAX PERCENT ON CSS_BILLING_DET.        **         
C30135*  07/02/04   GANESH    CHANGES MADE TO LAOD THE CURRENT REVENUE          
      *                       DIST IN THE BILL DETAILS.                         
C31332*  9 AUG 2004 RDF       FIX BILL-UNITS AND READ-UNITS FOR BZ   **         
C29967*  09/29/04   JAYANTHI  CORRECTED TO NOT CREATE FUTURE BILL    **         
C29967*                       HOOK FOR REMOVED METER.                **         
T30989*  04/06/05   VIJAY     UPDATE PCOMP_FCT IN CX TABLE(AMR PROJECT)         
C32676*  08/22/05   GANESH    CHANGES FOR THE GAS RATE PROJECT 2005  **         
C32676*                                                              **         
C33362*  01/16/06   ROD       ADD BG-BILL-CALC-CYCLE TO THE BILLING  **         
C33362*                       DETAIL RECORD.                         **         
T33182** 08/28/06    DB41297       PERFORMANCE IMPROVEMENTS.         **         
T33924**  08/15/06  DB41297  PSNC RATE CASE CHANGES                  *          
T33924**                     DECLARE 3 NEW DELINQUENCY VALUES.       *          
C33968**  11/01/06  DB41297  ADD NAICS CODE.                         *          
T33182**  11/06/06  DB41297  PERFORMANCE IMPROVEMENTS.               *          
T35135*   12/13/06  VIJAY    MOVED INSERTING PROCESS OF                         
      *                      CSS_BILL_ADJUSTMNT AFTER BILLING_DET    *          
      *                      PROCESS TO AVOID -530 ERRORS.           *          
C34569* 05/05/08  SS95855    SEB RATE RE-ENGINEERING.                *          
I00177* 01/05/09  SS97726    CHANGE WS-CUST-PLAN-INDX 100 TO 1000    *          
I00177*                      & WS-UNMTRD-CNSMPTN-INDX 100 TO 200     *          
I00177*                      & REMOVE INDX HARD CODING               *          
PRJ583* 02/06/09  SS97726    METER EXCHANGE WITH ITSELF CHANGES.     *          
PRJ583*                      PASS PREV METER READ INDEX AND COMBINE  *          
PRJ583*                      FLAG TO BILL PRINT IN BE00 FILE.        *          
PRJ583* 04/02/09  SS97726    CREATED COPYBOOK TO MAKE CODE RE-USABLE *          
PRJ583*                      BY BILL PRINT                           *          
P00143* 04/22/09  SS97726    REMOVE LOGIC FOR POPULATING CUST PLAN   *          
P00143*                      LAST BILL DATE AS THIS WILL BE DONE IN  *          
P00143*                      SCSCA105 GOING FORWARD.                 *          
P00165* 07/02/09  SS97726    AUTOMATE SEB PERCENTAGE BILLING.        *          
P00166* 08/31/09  AW41078    ADDING UNIQUE IDENTIFIER TO WS-FIODB07. *          
P00166*                      ALSO ADDING MISSING CREDIT LETTER IND.  *          
P00246* 12/18/09  SS97726    ABILITY TO OVERRIDE RATE PARAMTERS.     *          
P00251* 10/01/10  VY95550    UPDATE MASTER DEPENDENT RELATIONSHIP    *          
P00251*                      HISTORY.                                *          
P00471* 01/11/11  SP95538    DELETE THE ENTRIES FROM CSS_ACCT_ATTRIB *          
P00471*                      TABLE FOR DPP DROP.                     *          
A03303* 08/31/11  SV95326    FACTOR_PRECISION_CHANGES. INSERT AND    *          
A03303*                      UPDATE  FCTR_POWER_10 VALUE IN          *          
A03303*                      CSS_FIXED_FCT_HIST TABLE.               *          
P00496* 04/05/11  SS97726    INDUSTRIAL BILLING ENHANCEMENTS.        *          
P00496*  09/08/11  VIJAY   History rows creation for event process.   *         
      *                    This includes Curtailment, Maintenance     *         
      *                    and Standby events.                        *         
A03446*  02/07/12  VIJAY   ADD PEAK_DEMAND_DT, PRV_MTR_RD_COMB_FL TO  *         
      *                    CX.                                        *         
P00680*  05/14/12  SV95326 ADD STAT_ADJUSTABLE_CD IN CSS_ACCT_RTPK_AGR*         
      *                    UPDATE/INSERT LOGIC.                       *         
A03956*  11/26/12  VIJAY   ALLOW FUTURE BILL HOOK CREATION FOR MICHELIN         
      *                    MASTER ACCOUNT (NEEDED SPECIAL LOGIC AS IT'S         
      *                    METER IS ALWAYS IN 'REMOVED' STATUS).                
ACT004*  02/16/15  VIJAY   ADD DF.STATUS_CHANGE_DT.                   *         
ACT004*  A05094                                                       *         
P00892*  07/29/15  VIJAY   WRITE MNT TRANSACTION DURING RTPKG STATUS  *         
P00892*                    CHANGE TO 'OPEN FOR RENEWAL'               *         
ACT204*  10/19/15  VIJAY   ADD MI-TABLE-ID IN INSERT STATEMENT.       *         
ACT204*                                                               *         
ACT249*  12/10/15  VIJAY   WRITE MNT TRANSACTION OF 'OPEN FOR RENEWAL'*         
ACT249*  A05136            ONLY DURING UPDATE OF RTPKG.               *         
ACT031*  A05305    VIVEK   ADDED THE NET METER RATE PLAN 2NM,2NE,8NM, *         
ACT031*  A05305    VIVEK   8NE IN 2340 PARA FOR TRANSACTION HISTORY.  *         
ACT243*  08/01/16  VIJAY   REMOVE CSS_STNADBY_GEN TABLE RELATED CODE  *         
ACT243*  A05460            AS IT IS NOT USED ANY MORE.                *         
ACT006*  09/26/16  VIJAY   INCLUDE FH DELETE CODE                     *         
ACT006*  A05460                                                       *         
      *****************************************************************         
      /                                                                         
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA114'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR SCSCA114 STARTS HERE'.            
      /                                                                         
       01  WS-WORK-VARIABLES.                                           
TP4822     05  WS-MAX-ITEM-SEQ-NO          PIC S9(4) COMP.              
COB305     05 WS-MSG-INDX        PIC S9(5) COMP-3 VALUE 0.            
COB305     05 WS-BUILD-UP-CNT        PIC S9(2) COMP-3 VALUE 0.            
COB305     05 WS-HOLD-INDX        PIC S9(5) COMP-3 VALUE 0.            
           05  WS-SAVE-PRIOR-ACCT-BILL-NO  PIC S9(9) COMP.              
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.    
           05  WS-ROW-COUNT                PIC S9(9) COMP.              
           05  WS-NULL-IND                 PIC S9(4) COMP.              
           05  WS-BILL-NO-CALC             PIC S9(9) COMP.              
           05  WS-START-POS                PIC S9(4) COMP.              
P00892     05  WS-TRAN-APPL-NO             PIC S9(4) COMP.              
           05  WS-CURRENT-TIMESTAMP        PIC X(26).                   
T17222     05  WS-REV-MONTH-YYYYMM         PIC 9(6).                    
T17222     05  WS-REV-MONTH-YYYYMM-R REDEFINES WS-REV-MONTH-YYYYMM.     
T17222         10  WS-REV-MONTH-YYYY       PIC 9(4).                    
T17222         10  WS-REV-MONTH-MM         PIC 9(2).                    
T17222*DC         05  WS-REV-MONTH-YYYYMM.                                      
T17222*DC             10  WS-REV-MONTH-YYYY       PIC 9(04) COMP-3.             
T17222*DC             10  WS-REV-MONTH-MM         PIC 9(02) COMP-3.             
COB305     05 WS-BZ-READ-UNITS        PIC S9(9) COMP-3 VALUE 0.            
T17222     05  WS-TEMP-REV-MONTH.                                       
T17222         10  WS-TEMP-REV-YYYY        PIC 9(04).                   
T17222         10  WS-TEMP-REV-MM          PIC 9(02).                   
                                                                        
       01  WS-SWITCHES-AND-INDICATORS.                                  
           05  WS-FIRST-PASS             PIC X(01).                     
               88  FIRST-PASS              VALUE 'Y'.                   
               88  NOT-FIRST-PASS          VALUE 'Y'.                   
           05  WS-CNSMPTN-FLAG           PIC X(01).                     
               88  CNSMPTN-NOT-FOUND       VALUE 'N'.                   
               88  CNSMPTN-FOUND           VALUE 'Y'.                   
T5521      05  WS-ACTIVE-REG-FOUND-IND   PIC X(01).                     
T5521          88  WS-ACTIVE-REG-FOUND     VALUE 'Y'.                   
T5521          88  WS-NO-ACTIVE-REG-FOUND  VALUE 'N'.                   
T18995     05  WS-SUB-BILLED-SW          PIC X(01).                     
T18995         88  SUB-BILLED-OK           VALUE 'Y'.                   
CIG        05  WS-TRNSP-CNTR-EXIST       PIC X(01) VALUE 'Y'.           
P00892     05  WS-OPEN-FOR-RENEWAL       PIC X(01) VALUE 'O'.           
                                                                        
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-1               PIC S9(4) COMP.              
           05  WS-NULL-IND-2               PIC S9(4) COMP.              
           05  WS-NULL-IND-3               PIC S9(4) COMP.              
           05  WS-NULL-IND-4               PIC S9(4) COMP.              
           05  WS-NULL-IND-5               PIC S9(4) COMP.              
           05  WS-NULL-IND-6               PIC S9(4) COMP.              
           05  WS-NULL-IND-7               PIC S9(4) COMP.              
           05  WS-NULL-IND-8               PIC S9(4) COMP.              
           05  WS-NULL-IND-9               PIC S9(4) COMP.              
           05  WS-NULL-IND-10              PIC S9(4) COMP.              
           05  WS-NULL-IND-11              PIC S9(4) COMP.              
           05  WS-NULL-IND-12              PIC S9(4) COMP.              
           05  WS-NULL-IND-13              PIC S9(4) COMP.              
           05  WS-NULL-IND-14              PIC S9(4) COMP.              
           05  WS-NULL-IND-15              PIC S9(4) COMP.              
           05  WS-NULL-IND-16              PIC S9(4) COMP.              
           05  WS-NULL-IND-17              PIC S9(4) COMP.              
           05  WS-NULL-IND-18              PIC S9(4) COMP.              
           05  WS-NULL-IND-19              PIC S9(4) COMP.              
           05  WS-NULL-IND-20              PIC S9(4) COMP.              
           05  WS-NULL-IND-21              PIC S9(4) COMP.              
           05  WS-NULL-IND-22              PIC S9(4) COMP.              
           05  WS-NULL-IND-23              PIC S9(4) COMP.              
C34569     05  WS-NULL-IND-24              PIC S9(4) COMP.              
C34569     05  WS-NULL-IND-25              PIC S9(4) COMP.              
C34569     05  WS-NULL-IND-26              PIC S9(4) COMP.              
C34569     05  WS-NULL-IND-27              PIC S9(4) COMP.              
C34569     05  WS-NULL-IND-29              PIC S9(4) COMP.              
C34569     05  WS-NULL-IND-30              PIC S9(4) COMP.              
P00246     05  WS-NULL-IND-31              PIC S9(4) COMP VALUE +0.     
A03446     05  WS-NULL-IND-32              PIC S9(4) COMP VALUE +0.     
A03446     05  WS-NULL-IND-33              PIC S9(4) COMP VALUE +0.     
      /                                                                         
       01  WS-LITERALS.                                                 
      ** BILL ITEM INDICATORS                                                   
           05  WS-ACTIVE                   PIC X(1) VALUE 'A'.          
           05  WS-BACKOUT                  PIC X(1) VALUE 'B'.          
           05  WS-CLERK-CANCEL             PIC X(1) VALUE 'J'.          
           05  WS-CALC-ERROR               PIC X(1) VALUE 'K'.          
           05  WS-SUMMARY-ITEM             PIC X(1) VALUE 'S'.          
           05  WS-TRANSFER-ITEM            PIC X(1) VALUE 'T'.          
      ** BILL ITEM TYPES                                                        
           05  WS-PRE-CALC                 PIC X(1) VALUE 'S'.          
           05  WS-TAX-ONLY                 PIC X(1) VALUE 'J'.          
           05  WS-REGULAR-BULL             PIC X(1) VALUE 'A'.          
           05  WS-FCM16-STATUS             PIC X(2).                    
T8770 ** TRANS HIST                                                             
T8770      05  WS-SYSTEM                   PIC X(6) VALUE 'SYSTEM'.     
T8770      05  WS-SCSCA102B                PIC X(9) VALUE 'SCSCA102B'.  
T8770      05  WS-MAINT-TRAN-TYPE          PIC X(1) VALUE 'F'.          
T8770      05  WS-CUST-ACCT-RESP-AREA      PIC X(3) VALUE '001'.        
T8770      05  WS-MAINT-TRAN-DESC          PIC X(32)                    
T8770          VALUE 'AUTOMATIC RATE CHANGE PERFORMED.'.                
T8770      05  WS-RATE-PLAN-DESC           PIC X(15)                    
T8770          VALUE 'RATE PLAN NO.'.                                   
T8770 ** BILL MESSAGES                                                          
T8770      05  WS-RATE-8TO2                PIC S9(5) COMP-3             
T8770                                      VALUE 91012.                 
T8770      05  WS-RATE-2TOX                PIC S9(5) COMP-3             
T8770                                      VALUE 91014.                 
T8770      05  WS-RATE-10TO9               PIC S9(5) COMP-3             
T8770                                      VALUE 91015.                 
A05305     05  WS-RATE-2NMTO8              PIC S9(5) COMP-3             
A05305                                     VALUE 91014.                 
A05305     05  WS-RATE-2NETO8              PIC S9(5) COMP-3             
A05305                                     VALUE 91014.                 
A05305     05  WS-RATE-8NMTO2              PIC S9(5) COMP-3             
A05305                                     VALUE 91012.                 
A05305     05  WS-RATE-8NETO2              PIC S9(5) COMP-3             
A05305                                     VALUE 91012.                 
C32676     05  WS-MSG-GAS-RTCHG-RESH       PIC S9(5) COMP-3             
C32676                                     VALUE 95102.                 
C32676     05  WS-MSG-GAS-RTCHG-COMH       PIC S9(5) COMP-3             
C32676                                     VALUE 95104.                 
C32676     05  WS-MSG-GAS-RTCHG-RESL       PIC S9(5) COMP-3             
C32676                                     VALUE 95103.                 
C32676     05  WS-MSG-GAS-RTCHG-COML       PIC S9(5) COMP-3             
C32676                                     VALUE 95105.                 
T33924     05  WS-MSG-RT-110-105       PIC S9(5) COMP-3                 
T33924                                 VALUE 95155.                     
T33924     05  WS-MSG-RT-105-110       PIC S9(5) COMP-3                 
                                       VALUE 95157.                     
      ** MISC CONSTANTS                                                         
           05  WS-REGULAR-BILL             PIC X(1)  VALUE 'A'.         
           05  WS-FINAL-BILL               PIC X(1)  VALUE 'B'.         
           05  WS-CURRENT                  PIC X(1)  VALUE 'C'.         
           05  WS-PENDING-NEXT-BILL        PIC X(1)  VALUE 'B'.         
           05  WS-REBILL-IMMEDIATE         PIC X(1)  VALUE 'A'.         
           05  WS-ACTIVE-MONITOR           PIC X(1)  VALUE 'I'.         
           05  WS-BILLED                   PIC X(1)  VALUE 'I'.         
           05  WS-NO                       PIC X(1)  VALUE 'N'.         
           05  WS-UNMETERED                PIC X(1)  VALUE 'U'.         
           05  WS-YES                      PIC X(1)  VALUE 'Y'.         
           05  WS-PGRMNAME                 PIC X(8)  VALUE 'SCSCA114'.  
           05  WS-INSERT                   PIC X(1)  VALUE 'I'.         
           05  WS-UPDATE                   PIC X(1)  VALUE 'U'.         
P00471     05  WS-DELETE                   PIC X(1)  VALUE 'D'.         
           05  WS-RESET                    PIC X(1)  VALUE 'Z'.         
           05  WS-MASTER                   PIC X(1)  VALUE 'M'.         
           05  WS-SUB                      PIC X(1)  VALUE 'S'.         
 CIG       05  WS-TRNSP-PURCH              PIC X(9)  VALUE 'TRNSPURCH'. 
      /********************************************************                 
      *                                                       *                 
      *   WORKING STORAGE FOR BASIC WQ MESSAGE TEXT           *                 
      *                                                       *                 
      *********************************************************                 
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-MESSAGE-PATTERN.                                      
               10  WS-WQ-CATEGORY-ID       PIC S9(4) COMP.              
               10  WS-WQ-PRIORITY          PIC X(1).                    
               10  WS-WQ-ROUTE-CATEGORY    PIC X(1).                    
               10  WS-WQ-MESSAGE-LENGTH    PIC S9(4) COMP.              
               10  WS-WQ-MESSAGE-TEXT      PIC X(30).                   
           05  WS-DATABASE-EXCEPTION.                                   
PCR629         10  FILLER                  PIC S9(4) COMP VALUE +137.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +29.    
               10  FILLER                  PIC X(30) VALUE              
                   'A DATABASE EXCEPTION OCCURRED'.                     
                                                                        
      /                                                                         
           COPY CWS00010.                                                       
           COPY CWS00303.                                                       
           COPY CWS0070B.                                                       
      /*****   WS AREA FOR CPD00225 TO GET ADDITIONAL CX DETAILS.               
PRJ583     EXEC SQL                                                             
PRJ583          INCLUDE CWS00225                                                
PRJ583     END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
T18995          INCLUDE TBMSTSUB                                                
T18995     END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBUTLENV                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC  SQL                                                            
                INCLUDE TBCNSMP                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBUMCNSM                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBBLLDET                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBBLLHDR                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBPREM                                                  
           END-EXEC.                                                            
      /                                                                         
T4940      EXEC SQL                                                             
T4940           INCLUDE TBBLACXF                                                
T4940      END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBBLCLDT                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBFXHST                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBMTRENV                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBRGREAD                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBBLCNTR                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBBLCNTH                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBINTRPT                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBFXDFCT                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBPKHIST                                                
           END-EXEC.                                                            
      /                                                                         
DC         EXEC SQL                                                             
DC              INCLUDE TBANLSUM                                                
DC         END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBINTACT                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBCSTPLN                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBMNHIST                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBMNHDT                                                 
           END-EXEC.                                                            
      /                                                                         
      *****************CIG TASK******************                               
           EXEC SQL                                                             
                INCLUDE TBVOLBLK                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBTRNCNT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBTRNBLK                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBVBHST                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBTRNVHS                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBTRNHST                                                
           END-EXEC.                                                            
                                                                        
T33924     EXEC SQL                                                             
T33924          INCLUDE TBBILADJ                                                
T33924     END-EXEC.                                                            
P00251                                                                  
P00251*****************************************************************         
P00251* CSS_UTL_BI_REL_HST UX                                         *         
P00251*****************************************************************         
P00251       EXEC SQL                                                           
P00251           INCLUDE TBUTRLHS                                               
P00251       END-EXEC.                                                          
P00496                                                                  
P00496*****************************************************************         
P00496* CSS_BILL_BSLN_HIST LO                                         *         
P00496*****************************************************************         
P00496       EXEC SQL                                                           
P00496           INCLUDE TBBLHIST                                               
P00496       END-EXEC.                                                          
                                                                        
P00496                                                                  
P00496*****************************************************************         
P00496*  CSS_INTERRUP_HIST NZ                                                   
P00496*****************************************************************         
P00496       EXEC SQL                                                           
P00496           INCLUDE TBINHIST                                               
P00496       END-EXEC.                                                          
                                                                        
P00496*****************************************************************         
P00496* CSS_INTERRUPT_AHST TH                                                   
P00496*****************************************************************         
P00496     EXEC SQL                                                             
P00496         INCLUDE TBINTAHS                                                 
P00496     END-EXEC.                                                            
                                                                        
                                                                        
C34569***************************************************************** 01167000
C34569* CSS_ACCT_RTPK_AGR DF                                          * 01168000
C34569***************************************************************** 01169000
C34569       EXEC SQL                                                   01163000
C34569           INCLUDE TBACCTRG                                       01164000
C34569       END-EXEC.                                                  01165000
C34569***************************************************************** 01167000
C34569* CSS_ACCT_MKT_TIER DD                                          * 01168000
C34569***************************************************************** 01169000
C34569       EXEC SQL                                                   01163000
C34569           INCLUDE TBMKTIER                                       01164000
C34569       END-EXEC.                                                  01165000
C34569***************************************************************** 01167000
C34569* CSS_ACCT_ATTRIBUTE, YP                                        * 01168000
C34569***************************************************************** 01169000
C34569       EXEC SQL                                                   01163000
C34569           INCLUDE TBACTATT                                       01164000
C34569       END-EXEC.                                                  01165000
                                                                        
                                                                        
P00496*-*************************************************************** 01167000
P00496*-CSS_CNSMPTN_HRLY, 2C                                          * 01168000
P00496*-*************************************************************** 01169000
P00496        EXEC SQL                                                  01163000
P00496            INCLUDE TBCNSHR                                       01164000
P00496        END-EXEC.                                                 01165000
                                                                        
P00892***************************************************************** 01167000
P00892* CSS_ACCT_RATE_HIST 5H                                         * 01168000
P00892***************************************************************** 01169000
P00892        EXEC SQL                                                  01163000
P00892            INCLUDE TBACRTHS                                      01164000
P00892        END-EXEC.                                                 01165000
                                                                        
      ********************CIG TASK *************                                
           EXEC SQL                                                     
                DECLARE BILLING_DETAIL CURSOR FOR                       
                SELECT                                                  
                   ACCOUNT_NO,         BILL_NO,                         
                   CODE_UTIL_TYPE,     IC_NO,                           
                   REPLACE(REPLACE(CONVERT(CHAR(26), BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP,                    
                   DATE_ORIG_BILL,                                      
                   AMT_BILL_ITEM,      CODE_BILL_CALC,                  
                   CODE_BILL_ITM_TYPE, CODE_BILL_ITM_IND,               
                   CODE_DR_CR_CNSMPTN, AMT_STATE_TAX,                   
                   AMT_CITY_TAX,       AMT_OTHER_TAX,                   
                   CODE_REVENUE_CLASS,                                  
                   CODE_SIC_NO,        RATE_PLAN_NO,                    
                   CODE_CURTAIL_PRTY,  CODE_STAT_TAX_XMT,               
                   CODE_CITY_TAX_XMT,  CODE_OTHR_TAX_XMT,               
                   BTU_FACTOR,         WNA_FACTOR,                      
                   GAS_BASE_USE,                                        
                   REVENUE_MONTH,                                       
C29528             CITY_TAX_RATE,                                       
C29528             STATE_TAX_RATE,                                      
C34569             RT_PKG_OPT_SEQ_NO,                                   
C33968             NAICS_CD                                             
                FROM CSS_BILLING_DET                                    
                WHERE   ACCOUNT_NO = :BG-ACCOUNT-NO    AND              
                        BILL_NO    = :BG-BILL-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE BILLING_DETAIL CURSOR FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*            ACCOUNT_NO,         BILL_NO,                                 
MFA-TR*            CODE_UTIL_TYPE,     IC_NO,                                   
MFA-TR*            BILL_ITEM_TIMESTMP,                                          
MFA-TR*            DATE_ORIG_BILL,                                              
MFA-TR*            AMT_BILL_ITEM,      CODE_BILL_CALC,                          
MFA-TR*            CODE_BILL_ITM_TYPE, CODE_BILL_ITM_IND,                       
MFA-TR*            CODE_DR_CR_CNSMPTN, AMT_STATE_TAX,                           
MFA-TR*            AMT_CITY_TAX,       AMT_OTHER_TAX,                           
MFA-TR*            CODE_REVENUE_CLASS,                                          
MFA-TR*            CODE_SIC_NO,        RATE_PLAN_NO,                            
MFA-TR*            CODE_CURTAIL_PRTY,  CODE_STAT_TAX_XMT,                       
MFA-TR*            CODE_CITY_TAX_XMT,  CODE_OTHR_TAX_XMT,                       
MFA-TR*            BTU_FACTOR,         WNA_FACTOR,                              
MFA-TR*            GAS_BASE_USE,                                                
MFA-TR*            REVENUE_MONTH,                                               
MFA-TR*            CITY_TAX_RATE,                                               
MFA-TR*            STATE_TAX_RATE,                                              
MFA-TR*            RT_PKG_OPT_SEQ_NO,                                           
MFA-TR*            NAICS_CD                                                     
MFA-TR*         FROM CSS_BILLING_DET                                            
MFA-TR*         WHERE   ACCOUNT_NO = :BG-ACCOUNT-NO    AND                      
MFA-TR*                 BILL_NO    = :BG-BILL-NO                                
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE CNSMPTN_HIST CURSOR FOR                         
                SELECT                                                  
                   ACCOUNT_NO,         BILL_NO,                         
                   CODE_UTIL_TYPE,     IC_NO,                           
                   REPLACE(REPLACE(CONVERT(CHAR(26), BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP,                    
                   CODE_TIME_PERIOD,   MTR_REF_NO,                      
                   CODE_USAGE_TYPE,    CODE_USAGE_ID,                   
                   CODE_USAGE_SOURCE,  ITEM_SEQ_NO,                     
                   METER_NO,                                            
                   REG_ID_NO,          DATE_READ,                       
                   CODE_METER_READ,    CODE_METER_NO_READ,              
                   METER_READING,      DEMAND_READING,                  
                   EMPLOYEE_NO,        NO_UNITS,                        
                   NO_DEMAND_UNITS,    NO_DAYS,                         
                   CODE_SOURCE_ID,     CODE_DEBIT_CREDIT,               
                   CODE_ITEM_STATUS,   CODE_DISCOUNT,                   
                   CONSTANT,           NO_DIALS,                        
                   COMPANY_NO,                                          
                   EXCEPT_OVERRIDE_CD,                                  
                   REQUESTED_USAGE,                                     
                   DIGTL_INTRL_MTR_NO,                                  
                   DIGTL_MTR_TYPE,                                      
                   CODE_TOU_SEASN,                                      
                   EXCL_DMD_RCHT_IND                                    
A03446            ,PEAK_DEMAND_DT                                       
A03446            ,PRV_MTR_RD_COMB_FL                                   
                FROM CSS_CNSMPTN_HIST                                   
                WHERE   ACCOUNT_NO      = :CX-ACCOUNT-NO                
                  AND   BILL_NO         = :CX-BILL-NO                   
                  AND   CODE_UTIL_TYPE  = :CX-CODE-UTIL-TYPE            
                  AND   IC_NO           = :CX-IC-NO                     
                  AND   BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )     
                  AND   CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CNSMPTN_HIST CURSOR FOR                                 
MFA-TR*         SELECT                                                          
MFA-TR*            ACCOUNT_NO,         BILL_NO,                                 
MFA-TR*            CODE_UTIL_TYPE,     IC_NO,                                   
MFA-TR*            BILL_ITEM_TIMESTMP,                                          
MFA-TR*            CODE_TIME_PERIOD,   MTR_REF_NO,                              
MFA-TR*            CODE_USAGE_TYPE,    CODE_USAGE_ID,                           
MFA-TR*            CODE_USAGE_SOURCE,  ITEM_SEQ_NO,                             
MFA-TR*            METER_NO,                                                    
MFA-TR*            REG_ID_NO,          DATE_READ,                               
MFA-TR*            CODE_METER_READ,    CODE_METER_NO_READ,                      
MFA-TR*            METER_READING,      DEMAND_READING,                          
MFA-TR*            EMPLOYEE_NO,        NO_UNITS,                                
MFA-TR*            NO_DEMAND_UNITS,    NO_DAYS,                                 
MFA-TR*            CODE_SOURCE_ID,     CODE_DEBIT_CREDIT,                       
MFA-TR*            CODE_ITEM_STATUS,   CODE_DISCOUNT,                           
MFA-TR*            CONSTANT,           NO_DIALS,                                
MFA-TR*            COMPANY_NO,                                                  
MFA-TR*            EXCEPT_OVERRIDE_CD,                                          
MFA-TR*            REQUESTED_USAGE,                                             
MFA-TR*            DIGTL_INTRL_MTR_NO,                                          
MFA-TR*            DIGTL_MTR_TYPE,                                              
MFA-TR*            CODE_TOU_SEASN,                                              
MFA-TR*            EXCL_DMD_RCHT_IND                                            
MFA-TR*           ,PEAK_DEMAND_DT                                       01311000
MFA-TR*           ,PRV_MTR_RD_COMB_FL                                   01311000
MFA-TR*         FROM CSS_CNSMPTN_HIST                                           
MFA-TR*         WHERE   ACCOUNT_NO      = :CX-ACCOUNT-NO                        
MFA-TR*           AND   BILL_NO         = :CX-BILL-NO                           
MFA-TR*           AND   CODE_UTIL_TYPE  = :CX-CODE-UTIL-TYPE                    
MFA-TR*           AND   IC_NO           = :CX-IC-NO                             
MFA-TR*           AND   BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP             
MFA-TR*           AND   CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD               
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE UM_CNSMPT_HIST CURSOR FOR                       
                SELECT                                                  
                   ACCOUNT_NO,                                          
                   BILL_NO,                                             
                   CODE_UTIL_TYPE,                                      
                   IC_NO,                                               
                   REPLACE(REPLACE(CONVERT(CHAR(26), BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP,                    
                   ITEM_SEQ_NO,                                         
                   NO_UNITS,                                            
                   NO_DAYS,                                             
                   CODE_DEBIT_CREDIT,                                   
                   USAGE_FIXED,                                         
                   DATE_USAGE_ENDS,                                     
                   CODE_SERVICE_TYPE,                                   
                   CODE_ITEM_STATUS,                                    
                   CODE_SOURCE_ID,                                      
                   MTHLY_AMOUNT_FIXED,                                  
                   DIST_NO,                                             
                   LIGHT_NO,                                            
                   POLE_NO                                              
                FROM CSS_UM_CNSMPT_HIST                                 
                WHERE   ACCOUNT_NO      = :UC-ACCOUNT-NO                
                  AND   BILL_NO         = :UC-BILL-NO                   
                  AND   CODE_UTIL_TYPE  = :UC-CODE-UTIL-TYPE            
                  AND   IC_NO           = :UC-IC-NO                     
                  AND   BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :UC-BILL-ITEM-TIMESTMP
              )     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE UM_CNSMPT_HIST CURSOR FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            BILL_NO,                                                     
MFA-TR*            CODE_UTIL_TYPE,                                              
MFA-TR*            IC_NO,                                                       
MFA-TR*            BILL_ITEM_TIMESTMP,                                          
MFA-TR*            ITEM_SEQ_NO,                                                 
MFA-TR*            NO_UNITS,                                                    
MFA-TR*            NO_DAYS,                                                     
MFA-TR*            CODE_DEBIT_CREDIT,                                           
MFA-TR*            USAGE_FIXED,                                                 
MFA-TR*            DATE_USAGE_ENDS,                                             
MFA-TR*            CODE_SERVICE_TYPE,                                           
MFA-TR*            CODE_ITEM_STATUS,                                            
MFA-TR*            CODE_SOURCE_ID,                                              
MFA-TR*            MTHLY_AMOUNT_FIXED,                                          
MFA-TR*            DIST_NO,                                                     
MFA-TR*            LIGHT_NO,                                                    
MFA-TR*            POLE_NO                                                      
MFA-TR*         FROM CSS_UM_CNSMPT_HIST                                         
MFA-TR*         WHERE   ACCOUNT_NO      = :UC-ACCOUNT-NO                        
MFA-TR*           AND   BILL_NO         = :UC-BILL-NO                           
MFA-TR*           AND   CODE_UTIL_TYPE  = :UC-CODE-UTIL-TYPE                    
MFA-TR*           AND   IC_NO           = :UC-IC-NO                             
MFA-TR*           AND   BILL_ITEM_TIMESTMP = :UC-BILL-ITEM-TIMESTMP             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE UTIL_ENVRNMT CURSOR FOR                         
                SELECT                                                  
                   CODE_UTIL_TYPE,     IC_NO,                           
                   CODE_ESTIMATE_OK,   CODE_CURTAIL_PRTY,               
                   CODE_REVENUE_CLASS, CODE_SERVICE_TYPE,               
                   DATE_LST_NRML_BILL, RATE_PLAN_NO,                    
                   END_USER_PER_RATE,  DATE_INSTALL,                    
                   READ_CYCLE,         READ_ROUTE,                      
                   CODE_SIC_NO,        CODE_MTR_READ_FREQ,              
                   ACCOUNT_NO,                                          
                   ENERGY_SOURCE,                                       
                   SPLY_SENSITIVE_IND,                                  
                   SEASONAL_USE_CODE,                                   
                   COMPANY_NO,                                          
                   PRV_RATE_PLAN_NO,                                    
                   CODE_STAT_TAX_XMT,                                   
                   CODE_CITY_TAX_XMT,                                   
                   CODE_OTHR_TAX_XMT,                                   
                   CODE_XCIS_TAX_XMT,                                   
                   STATE_TAX_EXMPT_NO,                                  
                   TOU_RATE_IND,                                        
                   GAS_BASE_LAST_UPDT,                                  
                   GAS_PREV_BASE_USE,                                   
                   GAS_BASE_USE,                                        
                   AUTO_RATE_SW_FL                                      
                FROM CSS_UTIL_ENVRNMT                                   
                WHERE                                                   
                   ACCOUNT_NO  = :UT-ACCOUNT-NO                         
                   FOR UPDATE OF DATE_LST_NRML_BILL                     
           END-EXEC.                                                    
      *                                                                         
           EXEC SQL                                                     
                DECLARE BILLING_DET CURSOR FOR                          
                SELECT                                                  
                   REPLACE(REPLACE(CONVERT(CHAR(26), BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP                     
                FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                      
                WHERE                                                   
                   ACCOUNT_NO     = :BG-ACCOUNT-NO      AND             
                   BILL_NO        = :BG-BILL-NO         AND             
                   CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE  AND             
                   IC_NO          = :BG-IC-NO                           
T33182          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE BILLING_DET CURSOR FOR                                  
MFA-TR*         SELECT                                                          
MFA-TR*            BILL_ITEM_TIMESTMP                                           
MFA-TR*         FROM CSS_BILLING_DET                                            
MFA-TR*         WHERE                                                           
MFA-TR*            ACCOUNT_NO     = :BG-ACCOUNT-NO      AND                     
MFA-TR*            BILL_NO        = :BG-BILL-NO         AND                     
MFA-TR*            CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE  AND                     
MFA-TR*            IC_NO          = :BG-IC-NO                                   
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                DECLARE MTRD_ENVRNMT CURSOR FOR                         
                SELECT                                                  
                   CODE_UTIL_TYPE,                                      
                   IC_NO,                                               
                   MTR_REF_NO,                                          
                   CODE_TIME_PERIOD,                                    
                   METER_NO,                                            
                   CODE_DISCOUNT,                                       
                   CODE_METER_LOC,                                      
                   CODE_METER_STATUS,                                   
                   CODE_STATUS_REAS,                                    
                   CODE_ALRT_CHNG_IND,                                  
                   DIST_NODE_POINT,                                     
                   CODE_DIVERSION,                                      
                   DATE_MTR_INSTALL,                                    
                   CODE_SPCL_SEAL,                                      
                   EST_USAGE,                                           
                   SPCL_MTR_CONDITION,                                  
                   CODE_DATA_PRESENT,                                   
                   CODE_USAGE_TYPE,                                     
                   CODE_USAGE_ID,                                       
                   CODE_USAGE_SOURCE,                                   
                   REG_ID_NO,                                           
                   REGISTER_RD_SEQ,                                     
                   CODE_CRNT_REG_READ,                                  
                   CODE_NO_RD_REASON,                                   
                   CODE_LAST_REG_READ,                                  
                   LAST_REG_READ_DATE,                                  
                   LAST_REG_READ_TIME,                                  
                   LAST_READ_VALUE,                                     
                   NO_CONSEC_ESTIMATE,                                  
                   NO_CONSEC_CRD_READ,                                  
                   POINT_ID,                                            
                   LOCK_TYPE_ID,                                        
                   SEAL_CODE_ID,                                        
                   HEXAGRAM_LOCATION,                                   
                   INSULATED_IND,                                       
                   METER_SUPPLYING,                                     
                   READ_CARD_PRINT_DT,                                  
                   EXCEPT_OVERRIDE_CD,                                  
                   CODE_MTR_RD_INST1,                                   
                   CODE_MTR_RD_INST2,                                   
                   CODE_MTR_RD_INST3                                    
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
                WHERE                                                   
                   ACCOUNT_NO     = :MN-ACCOUNT-NO      AND             
                   CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE  AND             
                   IC_NO          = :MN-IC-NO           AND             
                   MTR_REF_NO     = :MN-MTR-REF-NO      AND             
                   METER_NO       = :MN-METER-NO                        
T33182          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE MTRD_ENVRNMT CURSOR FOR                                 
MFA-TR*         SELECT                                                          
MFA-TR*            CODE_UTIL_TYPE,                                              
MFA-TR*            IC_NO,                                                       
MFA-TR*            MTR_REF_NO,                                                  
MFA-TR*            CODE_TIME_PERIOD,                                            
MFA-TR*            METER_NO,                                                    
MFA-TR*            CODE_DISCOUNT,                                               
MFA-TR*            CODE_METER_LOC,                                              
MFA-TR*            CODE_METER_STATUS,                                           
MFA-TR*            CODE_STATUS_REAS,                                            
MFA-TR*            CODE_ALRT_CHNG_IND,                                          
MFA-TR*            DIST_NODE_POINT,                                             
MFA-TR*            CODE_DIVERSION,                                              
MFA-TR*            DATE_MTR_INSTALL,                                            
MFA-TR*            CODE_SPCL_SEAL,                                              
MFA-TR*            EST_USAGE,                                                   
MFA-TR*            SPCL_MTR_CONDITION,                                          
MFA-TR*            CODE_DATA_PRESENT,                                           
MFA-TR*            CODE_USAGE_TYPE,                                             
MFA-TR*            CODE_USAGE_ID,                                               
MFA-TR*            CODE_USAGE_SOURCE,                                           
MFA-TR*            REG_ID_NO,                                                   
MFA-TR*            REGISTER_RD_SEQ,                                             
MFA-TR*            CODE_CRNT_REG_READ,                                          
MFA-TR*            CODE_NO_RD_REASON,                                           
MFA-TR*            CODE_LAST_REG_READ,                                          
MFA-TR*            LAST_REG_READ_DATE,                                          
MFA-TR*            LAST_REG_READ_TIME,                                          
MFA-TR*            LAST_READ_VALUE,                                             
MFA-TR*            NO_CONSEC_ESTIMATE,                                          
MFA-TR*            NO_CONSEC_CRD_READ,                                          
MFA-TR*            POINT_ID,                                                    
MFA-TR*            LOCK_TYPE_ID,                                                
MFA-TR*            SEAL_CODE_ID,                                                
MFA-TR*            HEXAGRAM_LOCATION,                                           
MFA-TR*            INSULATED_IND,                                               
MFA-TR*            METER_SUPPLYING,                                             
MFA-TR*            READ_CARD_PRINT_DT,                                          
MFA-TR*            EXCEPT_OVERRIDE_CD,                                          
MFA-TR*            CODE_MTR_RD_INST1,                                           
MFA-TR*            CODE_MTR_RD_INST2,                                           
MFA-TR*            CODE_MTR_RD_INST3                                            
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*         WHERE                                                           
MFA-TR*            ACCOUNT_NO     = :MN-ACCOUNT-NO      AND                     
MFA-TR*            CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE  AND                     
MFA-TR*            IC_NO          = :MN-IC-NO           AND                     
MFA-TR*            MTR_REF_NO     = :MN-MTR-REF-NO      AND                     
MFA-TR*            METER_NO       = :MN-METER-NO                                
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                DECLARE REGISTER_READ CURSOR FOR                        
                SELECT                                                  
                   ACCOUNT_NO,                                          
                   CODE_UTIL_TYPE,                                      
                   IC_NO,                                               
                   MTR_REF_NO,                                          
                   REG_ID_NO,                                           
                   METER_NO,                                            
                   CODE_USAGE_TYPE,                                     
                   CODE_USAGE_ID,                                       
                   CODE_USAGE_SOURCE,                                   
                   CODE_TIME_PERIOD,                                    
                   REGISTER_RD_SEQ,                                     
                   CODE_REG_STATUS,                                     
                   CODE_STATUS_REAS,                                    
                   CODE_LAST_REG_READ,                                  
                   LAST_REG_READ_DT,                                    
                   LAST_REG_READ_TM,                                    
                   LAST_READ_VALUE,                                     
                   NEXT_READ_MONTH,                                     
                   CODE_CRNT_REG_READ,                                  
                   CODE_NO_RD_REASON,                                   
                   CODE_LAST_VALID_RD,                                  
                   LAST_VALID_READ_TM,                                  
                   LAST_VALID_READ_DT,                                  
                   LAST_VAL_RD_VALUE,                                   
                   SEASONAL_USE_CD                                      
                FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                    
                WHERE                                                   
                   ACCOUNT_NO     = :RG-ACCOUNT-NO      AND             
                   CODE_UTIL_TYPE = :RG-CODE-UTIL-TYPE  AND             
                   IC_NO          = :RG-IC-NO           AND             
                   MTR_REF_NO     = :RG-MTR-REF-NO      AND             
                   REG_ID_NO      = :RG-REG-ID-NO       AND             
                   METER_NO       = :RG-METER-NO        AND             
                   CODE_USAGE_TYPE    = :RG-CODE-USAGE-TYPE   AND       
                   CODE_USAGE_ID      = :RG-CODE-USAGE-ID     AND       
                   CODE_USAGE_SOURCE  = :RG-CODE-USAGE-SOURCE AND       
                   CODE_TIME_PERIOD   = :RG-CODE-TIME-PERIOD            
T33182          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE REGISTER_READ CURSOR FOR                                
MFA-TR*         SELECT                                                          
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CODE_UTIL_TYPE,                                              
MFA-TR*            IC_NO,                                                       
MFA-TR*            MTR_REF_NO,                                                  
MFA-TR*            REG_ID_NO,                                                   
MFA-TR*            METER_NO,                                                    
MFA-TR*            CODE_USAGE_TYPE,                                             
MFA-TR*            CODE_USAGE_ID,                                               
MFA-TR*            CODE_USAGE_SOURCE,                                           
MFA-TR*            CODE_TIME_PERIOD,                                            
MFA-TR*            REGISTER_RD_SEQ,                                             
MFA-TR*            CODE_REG_STATUS,                                             
MFA-TR*            CODE_STATUS_REAS,                                            
MFA-TR*            CODE_LAST_REG_READ,                                          
MFA-TR*            LAST_REG_READ_DT,                                            
MFA-TR*            LAST_REG_READ_TM,                                            
MFA-TR*            LAST_READ_VALUE,                                             
MFA-TR*            NEXT_READ_MONTH,                                             
MFA-TR*            CODE_CRNT_REG_READ,                                          
MFA-TR*            CODE_NO_RD_REASON,                                           
MFA-TR*            CODE_LAST_VALID_RD,                                          
MFA-TR*            LAST_VALID_READ_TM,                                          
MFA-TR*            LAST_VALID_READ_DT,                                          
MFA-TR*            LAST_VAL_RD_VALUE,                                           
MFA-TR*            SEASONAL_USE_CD                                              
MFA-TR*         FROM CSS_REGISTER_READ                                          
MFA-TR*         WHERE                                                           
MFA-TR*            ACCOUNT_NO     = :RG-ACCOUNT-NO      AND                     
MFA-TR*            CODE_UTIL_TYPE = :RG-CODE-UTIL-TYPE  AND                     
MFA-TR*            IC_NO          = :RG-IC-NO           AND                     
MFA-TR*            MTR_REF_NO     = :RG-MTR-REF-NO      AND                     
MFA-TR*            REG_ID_NO      = :RG-REG-ID-NO       AND                     
MFA-TR*            METER_NO       = :RG-METER-NO        AND                     
MFA-TR*            CODE_USAGE_TYPE    = :RG-CODE-USAGE-TYPE   AND               
MFA-TR*            CODE_USAGE_ID      = :RG-CODE-USAGE-ID     AND               
MFA-TR*            CODE_USAGE_SOURCE  = :RG-CODE-USAGE-SOURCE AND               
MFA-TR*            CODE_TIME_PERIOD   = :RG-CODE-TIME-PERIOD                    
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************CIG TASK*********************                
                                                                        
           EXEC SQL                                                     
                DECLARE TRNSP_VOL_BLK CURSOR FOR                        
                SELECT                                                  
                   TRNSP_SEQ,                                           
                   IC_NO,                                               
                   CODE_REVENUE_CLASS,                                  
                   RATE_PLAN_NO                                         
                FROM CSS_TRNSP_VOL_BLK WITH(READUNCOMMITTED)                    
                WHERE                                                   
                   ACCOUNT_NO       = :TZ-ACCOUNT-NO      AND           
                   CODE_UTIL_TYPE   = :TZ-CODE-UTIL-TYPE  AND           
                   PRIMARY_IC_NO    = :TZ-PRIMARY-IC-NO   AND           
                   CNTRCT_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                    :TZ-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :TZ-CNTRCT-START-DT
              ) <> 0) OR (LEN(:TZ-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:TZ-CNTRCT-START-DT
              ), CONVERT(DATE, :TZ-CNTRCT-START-DT) )               
T33182          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE TRNSP_VOL_BLK CURSOR FOR                                
MFA-TR*         SELECT                                                          
MFA-TR*            TRNSP_SEQ,                                                   
MFA-TR*            IC_NO,                                                       
MFA-TR*            CODE_REVENUE_CLASS,                                          
MFA-TR*            RATE_PLAN_NO                                                 
MFA-TR*         FROM CSS_TRNSP_VOL_BLK                                          
MFA-TR*         WHERE                                                           
MFA-TR*            ACCOUNT_NO       = :TZ-ACCOUNT-NO      AND                   
MFA-TR*            CODE_UTIL_TYPE   = :TZ-CODE-UTIL-TYPE  AND                   
MFA-TR*            PRIMARY_IC_NO    = :TZ-PRIMARY-IC-NO   AND                   
MFA-TR*            CNTRCT_START_DT  = :TZ-CNTRCT-START-DT                       
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR SCSCA114 ENDS HERE  '.            
      /                                                                         
       LINKAGE SECTION.                                                 
PERF   COPY CWS1000A.                                                           
      /                                                                         
PERF   COPY CWS1000B.                                                           
      /                                                                         
PERF   COPY CWS1001A.                                                           
      /                                                                         
PERF   COPY CWS1001B.                                                           
      /                                                                         
       COPY CWS0024B.                                                           
      /***** DB07 FILE                                                          
       01  WS-FIODB07.                                                  
COB305     05 WS-FDB07-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.      
           05  WS-FDB07-PROCESS-CONTROL.                                
               10  WS-ON-OFF-CYCLE-IND          PIC X(1).               
                   88  WS-OFF-CYCLE-FINAL        VALUE 'B'.             
                   88  WS-OFF-CYCLE-REBILL       VALUE 'O'.             
                   88  WS-ON-CYCLE-BILL          VALUE 'A'.             
                   88  WS-APPLY-LPC-ONLY         VALUE 'L'.             
TP4569             88  WS-OFF-CYCLE-ACCT-TRANS   VALUE 'T'.             
TF1            10  WS-SINGLE-ITEM-BILL-IND      PIC X(1).               
TF1                88  WS-SINGLE-ITEM-BILL       VALUE 'S'.             
TP4688         10  WS-MASTER-ACCOUNT-IND        PIC X(1).               
TP4688             88  WS-CONS-BILL-MAST         VALUE 'M'.             
TP4688             88  WS-ADDITIVE-MAST          VALUE 'A'.             
               10  WS-REFUND-CONTROL-IND        PIC X(1).               
                   88  WS-PROCESS-REFUND         VALUE 'R'.             
               10  WS-GUARANTEE-TRANSFER-IND    PIC X(1).               
                   88  WS-TRANSFER-GUARANTEE     VALUE 'E'.             
                   88  WS-TRANSFER-GUARANTOR     VALUE 'G'.             
           05  WS-FDB07-NO-BILL-CYCLES          PIC S9(4) COMP.         
TF1        05  WS-FDB07-PYMT-PRIORITY-LVL       PIC S9(4) COMP.         
TF1        05  WS-FDB07-ITEM-ID                 PIC S9(9) COMP.         
P00166     05  WS-FDB07-CREDIT-LETTER-IND       PIC X(01).              
P00166     05  WS-FDB07-BARCODE-UNIQUE-ID       PIC X(09).              
      /                                                                         
                                                                        
       PROCEDURE DIVISION USING LS-PCSCA100-COMM-AREA                   
TP4688                          WS-FIODB07                              
                                WS-PREMISE-PR                           
                                WS-ACCOUNT-AT                           
                                WS-BILLING-BI                           
                                WS-BILLING-BG                           
                                WS-BILL-CALC-DETAIL                     
                                WS-BILL-ADJUST-DETAIL                   
                                WS-CNSMPTN-HIST-CX                      
                                WS-UNMTRD-CNSMPTN-UC                    
                                WS-FIXED-FCTR-HIST-FH                   
                                WS-BILL-CONTRACT-BK                     
                                WS-CUST-PLAN-TABLE-CP                   
                                WS-FIXED-FCTR-TABLE-FF                  
                                WS-BILL-CNTR-HIST-BX                    
                                WS-PEAK-HIST-PH                         
                                WS-INTERRUPT-ACCT-IP                    
                                WS-STANDBY-GEN-SE                       
                                WS-INTERRUPT-IR                         
                                WS-UTILITY-TABLE-UT                     
                                WS-REGISTER-READ-TABLE-RG               
                                WS-MTRD-ENVRNMT-TABLE-MN                
                                WS-BILLING-WQ-ITEMS-WF                  
C34569                          WS-ACCT-ATTRIBUTE-YP                    
C34569                          WS-ACCT-MKT-TIER-DD                     
C34569                          WS-ACCT-RTPK-AGR-DF                     
C34569                          WS-BI-FIXED-FCTR-FF                     
T33924                          WS-BILL-ADJUSTMNT                       
I00177                          WS-CWS1000B-MAX-TBL-LIMITS              
P00251                          WS-CWS1001B-MAX-TBL-LIMITS              
P00251                          WS-UTL-BI-REL-HST-TABLE-UX              
P00496                          WS-BILL-BSLN-CNTR-LN                    
P00496                          WS-BILL-BSLN-HIST-LO                    
P00496                          WS-INTERRUPT-NZ                         
P00496                          WS-CNSMPTN-HOURLY.                      
                                                                        
      ******************************************************************        
      *                                                                *        
      *   0000-MAINLINE.                                               *        
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           MOVE ZERO TO RETURN-CODE.                                    
I00177     INITIALIZE WS-WORK-VARIABLES                                 
I00177                WS-SQL-ERROR-TXT-WQ.                              
           SET FIRST-PASS TO TRUE                                       
           PERFORM 2000-PROCESS-ACCOUNT THRU 2000-EXIT                  
      *                                                                         
           EXIT PROGRAM.                                                
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*****************************************************************        
      *                                                                *        
      *   1000-MAIN-PROCESS                                            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-ACCOUNT.                                            
      *                                                                         
      ** UPDATE UTIL ENVRNMT FROM BILLING EXTRACT                               
      *                                                                         
           PERFORM VARYING WS-UTIL-INDX FROM 1 BY 1                     
                   UNTIL WS-UTIL-INDX GREATER THAN 40 OR                
                         WS-ACCOUNT-NO-UT (WS-UTIL-INDX) EQUAL ZERO     
              IF WS-UPDATE-ACTION-IND-UT (WS-UTIL-INDX) NOT = SPACE     
                 PERFORM 2280-PROCESS-UT-UPDATES THRU 2280-EXIT         
      *                                                                         
      ** INSERT MAINTENANCE TRANSACTION HISTORY IF RATE CHANGE ON UT            
      *                                                                         
T8770            PERFORM 2340-PROCESS-RATE-CHANGE THRU 2340-EXIT        
                 IF WS-UPDATE-ACTION-IND-UT (WS-UTIL-INDX) = WS-UPDATE  
                    PERFORM 8300-UPDATE-UTIL-ENVRNMT THRU 8300-EXIT     
                 ELSE                                                   
                    PERFORM 8310-INSERT-UTIL-ENVRNMT THRU 8310-EXIT     
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
      ** UPDATE METERED ENVRNMT FROM BILLING EXTRACT                            
      *                                                                         
           PERFORM VARYING WS-MTRD-INDX FROM 1 BY 1                     
C23632         UNTIL WS-MTRD-INDX GREATER THAN WS-MAX-MN-ENTRIES OR     
                         WS-ACCOUNT-NO-MN (WS-MTRD-INDX) EQUAL ZERO     
              IF WS-UPDATE-ACTION-IND-MN (WS-MTRD-INDX) NOT = SPACE     
                 PERFORM 2260-PROCESS-MN-UPDATES THRU 2260-EXIT         
                 IF WS-UPDATE-ACTION-IND-MN (WS-MTRD-INDX) = WS-UPDATE  
                    PERFORM 8130-UPDATE-MTRD-ENVRNMT THRU 8130-EXIT     
                 ELSE                                                   
                    PERFORM 8135-INSERT-MTRD-ENVRNMT THRU 8135-EXIT     
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
      ** UPDATE REGISTER READS FROM BILLING EXTRACT                             
      *                                                                         
           PERFORM VARYING WS-REG-RD-INDX FROM 1 BY 1                   
                   UNTIL WS-REG-RD-INDX GREATER THAN 20 OR              
                         WS-ACCOUNT-NO-RG (WS-REG-RD-INDX) EQUAL ZERO   
              IF WS-UPDATE-ACTION-IND-RG (WS-REG-RD-INDX) NOT = SPACE   
                 PERFORM 2270-PROCESS-RG-UPDATES THRU 2270-EXIT         
                 IF WS-UPDATE-ACTION-IND-RG (WS-REG-RD-INDX) = WS-UPDATE
                    PERFORM 8120-UPDATE-REGISTER-READ THRU 8120-EXIT    
                 ELSE                                                   
                    PERFORM 8125-INSERT-REGISTER-READ THRU 8125-EXIT    
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
      ** UPDATE CUST PLANS FROM BILLING EXTRACT                                 
      *                                                                         
           PERFORM VARYING WS-CUST-PLAN-INDX FROM 1 BY 1                
I00177             UNTIL WS-CUST-PLAN-INDX > WS-CP-MAX-ENTRY OR         
                         WS-ACCOUNT-NO-CP (WS-CUST-PLAN-INDX) = ZERO    
              IF WS-UPDATE-ACTION-IND-CP (WS-CUST-PLAN-INDX) = WS-UPDATE
                 PERFORM 2290-PROCESS-CP-UPDATES THRU 2290-EXIT         
                 PERFORM 8820-UPDATE-CUST-PLAN THRU 8820-EXIT           
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
      ** UPDATE BILL-CONTRACT                                                   
      *                                                                         
           PERFORM VARYING WS-BK-INDX FROM 1 BY 1                       
                   UNTIL WS-BK-INDX > 20 OR                             
                         WS-ACCOUNT-NO-BK (WS-BK-INDX) = ZERO           
              IF WS-UPDATE-ACTION-IND-BK (WS-BK-INDX) = WS-UPDATE       
                 PERFORM 2310-PROCESS-BK-UPDATES THRU 2310-EXIT         
                 PERFORM 8830-UPDATE-BILL-CNTRCT THRU 8830-EXIT         
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
      ** UPDATE INTERRUPT ACCOUNT                                               
      *                                                                         
           IF WS-UPDATE-ACTION-IND-IP = WS-UPDATE                       
              PERFORM 2320-PROCESS-IP-UPDATES THRU 2320-EXIT            
              PERFORM 8850-UPDATE-INT-ACCOUNT THRU 8850-EXIT            
           END-IF                                                       
                                                                        
      *                                                                         
      ** UPDATE INTERRUPT ACCOUNT HISTORY                                       
      *                                                                         
P00496     IF WS-ACCOUNT-NO-IP > ZERO                                   
P00496        MOVE WS-ACCOUNT-NO-IP         TO  TH-ACCOUNT-NO           
P00496        MOVE WS-BILL-NO-IP            TO  TH-BILL-NO              
P00496        MOVE WS-CODE-UTIL-TYPE-IP     TO  TH-CODE-UTIL-TYPE       
P00496        MOVE WS-IC-NO-IP              TO  TH-IC-NO                
P00496        MOVE WS-BILL-ITEM-TIMESTMP-IP                             
P00496                                      TO  TH-BILL-ITEM-TIMESTMP   
P00496        MOVE WS-CONTRACT-DATE-IP      TO  TH-CONTRACT-DATE        
P00496        MOVE WS-CATEGORY-IP           TO  TH-CATEGORY             
P00496        MOVE WS-FIRM-DEMAND-LEVEL-IP  TO  TH-FIRM-DEMAND-LEVEL    
P00496        MOVE WS-TYP-INTRPT-DEMAND-IP  TO  TH-TYP-INTRPT-DEMAND    
P00496        MOVE WS-NON-COMPLIANCE-CNT-IP TO  TH-NON-COMPLIANCE-CNT   
P00496        PERFORM 8852-INSERT-AHST      THRU 8852-EXIT              
P00496     END-IF.                                                      
      *                                                                         
      ** UPDATE INTERRUPT EVENTS                                                
      *                                                                         
           PERFORM VARYING WS-INTR-INDX FROM 1 BY 1                     
P00496             UNTIL WS-INTR-INDX > WS-IR-MAX-ENTRY OR              
                         WS-ACCOUNT-NO-IR (WS-INTR-INDX) = ZERO         
              IF WS-UPDATE-ACTION-IND-IR (WS-INTR-INDX) = WS-UPDATE     
                 PERFORM 2330-PROCESS-IR-UPDATES THRU 2330-EXIT         
                 PERFORM 8840-UPDATE-INT-REQUEST THRU 8840-EXIT         
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
      ** UPDATE INTERRUPT HISTORY                                               
      *                                                                         
P00496     PERFORM VARYING WS-NZ-INDX FROM 1 BY 1                       
P00496               UNTIL WS-NZ-INDX > WS-IR-MAX-ENTRY  OR             
P00496                WS-ACCOUNT-NO-NZ (WS-NZ-INDX) = ZERO              
P00496         PERFORM 8841-PROCESS-INT-HIST THRU 8841-EXIT             
P00496         PERFORM 8842-INSERT-INT-HIST  THRU 8842-EXIT             
P00496     END-PERFORM.                                                 
      *                                                                         
      ** UPDATE BILLING HISTORY FROM BILLING EXTRACT                            
      *                                                                         
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1                  
                   UNTIL WS-BILLING-INDX GREATER THAN 30 OR             
                         WS-ACCOUNT-NO-BG (WS-BILLING-INDX) EQUAL ZERO  
              IF WS-UPDATE-ACTION-IND-BG (WS-BILLING-INDX) NOT = SPACE  
                 PERFORM 2100-PROCESS-BG-BILLING THRU 2100-EXIT         
              END-IF                                                    
           END-PERFORM                                                  
T33924*                                                                         
T33924** UPDATE BILL ADJUSTMENTS                                                
T33924*                                                                         
T33924     PERFORM VARYING WS-ADJUSTMNT-INDEX FROM 1 BY 1               
T33924             UNTIL WS-ADJUSTMNT-INDEX > WS-BP-MAX-ENTRY OR        
T33924                   WS-ACCOUNT-NO-BP (WS-ADJUSTMNT-INDEX) = ZERO   
T33924       IF WS-UPDATE-ACTION-IND-BP(WS-ADJUSTMNT-INDEX) NOT = ' '   
T33924          PERFORM 2335-PROCESS-BP-UPDATES THRU 2335-EXIT          
T33924          IF WS-UPDATE-ACTION-IND-BP(WS-ADJUSTMNT-INDEX) =        
T33924             WS-UPDATE                                            
T33924             PERFORM 8845-UPDATE-BILL-ADJUST THRU 8845-EXIT       
T33924          ELSE                                                    
T33924             PERFORM 8870-INSERT-BILL-ADJUST THRU 8870-EXIT       
T33924          END-IF                                                  
T33924       END-IF                                                     
T33924     END-PERFORM                                                  
      *                                                                         
      ** UPDATE COMSUMPTION HIST FROM BILLING EXTRACT                           
      *                                                                         
PRJ583     MOVE SPACES                 TO WS-PREV-METER-NO              
PRJ583                                    WS-PREV-CODE-UTIL-TYPE        
PRJ583                                    WS-PREV-CODE-USAGE-TYPE       
PRJ583                                    WS-PREV-CODE-USAGE-ID         
PRJ583                                    WS-PREV-CODE-USAGE-SOURCE     
P00246                                    WS-PREV-BILL-ITEM-TIMESTMP.   
PRJ583     MOVE ZEROS                  TO WS-PREV-CODE-TIME-PERIOD      
PRJ583                                    WS-PREV-CONSTANT              
PRJ583                                    WS-PREV-PCOMP-FCT.            
           PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1                  
T14555             UNTIL WS-CNSMPTN-INDX GREATER THAN 200 OR            
                         WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) EQUAL ZERO  
PRJ583        PERFORM 4060-GET-ADTNL-CX-DETAILS THRU 4060-EXIT          
              IF WS-UPDATE-ACTION-IND-CX (WS-CNSMPTN-INDX) NOT = SPACE  
                 PERFORM 2200-PROCESS-CNSMPT-HIST THRU 2200-EXIT        
                 IF WS-UPDATE-ACTION-IND-CX (WS-CNSMPTN-INDX)           
                       = WS-UPDATE                                      
                    PERFORM 8715-UPDATE-CNSMPTN-HIST THRU 8715-EXIT     
                 ELSE                                                   
                    PERFORM 8710-INSERT-CNSMPTN-HIST THRU 8710-EXIT     
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM                                                  
P00496*-                                                                        
P00496** UPDATE CONSUMPTION HOURLY FROM BILLING EXTRACT                         
P00496*-                                                                        
P00496     PERFORM  VARYING HOURLY-INDX FROM 1 BY 1                     
HOREBL        UNTIL  HOURLY-INDX GREATER THAN 6800 OR                   
P00496               WS-ACCOUNT-NO-2C (HOURLY-INDX) EQUAL ZERO          
P00496        PERFORM  2205-PROCESS-CNSMPT-HOURLY THRU 2205-EXIT        
P00496        PERFORM  8707-INSERT-CNSMPTN-HOURLY thru 8707-exit        
P00496     END-PERFORM.                                                 
      *                                                                         
      ** UPDATE UM-CNSMPTN HIST FROM BILLING EXTRACT                            
      *                                                                         
           PERFORM VARYING WS-UNMTRD-CNSMPTN-INDX FROM 1 BY 1           
I00177             UNTIL WS-UNMTRD-CNSMPTN-INDX GREATER THAN            
I00177                   WS-UC-MAX-ENTRY OR                             
                        WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX) = ZERO
              IF WS-UPDATE-ACTION-IND-UC (WS-UNMTRD-CNSMPTN-INDX)       
                          NOT = SPACE                                   
                 PERFORM 2210-PROCESS-UM-CNSMPT-HIST THRU 2210-EXIT     
                 IF WS-UPDATE-ACTION-IND-UC (WS-UNMTRD-CNSMPTN-INDX)    
                       = WS-UPDATE                                      
                    PERFORM 8525-UPDATE-UM-CNSMPT-HIST THRU 8525-EXIT   
                 ELSE                                                   
                    PERFORM 8520-INSERT-UM-CNSMPT-HIST THRU 8520-EXIT   
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
C34569** UPDATE FIXED FACTOR FROM BILLING EXTRACT                               
C34569*                                                                         
C34569     PERFORM VARYING WS-BI-FF-INDX FROM 1 BY 1                    
C34569             UNTIL WS-BI-FF-INDX GREATER THAN 200 OR              
C34569               WS-BI-ACCOUNT-NO-FF (WS-BI-FF-INDX) = ZERO         
C34569     IF WS-BI-UPDATE-ACTION-IND-FF (WS-BI-FF-INDX) NOT = SPACE    
C34569           PERFORM 2235-PROCESS-FIXED-FCTR THRU 2235-EXIT         
C34569           IF WS-BI-UPDATE-ACTION-IND-FF (WS-BI-FF-INDX)          
C34569                 = WS-UPDATE                                      
C34569              PERFORM 8750-UPDATE-FIXED-FCTR THRU 8750-EXIT       
C34569           ELSE                                                   
C34569              PERFORM 8755-INSERT-FIXED-FCTR THRU 8755-EXIT       
C34569           END-IF                                                 
C34569        END-IF                                                    
C34569     END-PERFORM                                                  
C34569*                                                                         
C34569** UPDATE ACCOUNT ATTRIBUTE FROM BILLING EXTRACT                          
C34569*                                                                         
C34569     PERFORM VARYING WS-ATTR-INDX FROM 1 BY 1                     
C34569             UNTIL WS-ATTR-INDX GREATER THAN 25 OR                
C34569                  WS-ACCOUNT-NO-YP (WS-ATTR-INDX) = ZERO          
C34569        IF WS-UPDATE-ACTION-IND-YP (WS-ATTR-INDX) NOT = SPACE     
C34569           PERFORM 2236-PROCESS-ACCT-ATTR THRU 2236-EXIT          
P00471           EVALUATE WS-UPDATE-ACTION-IND-YP (WS-ATTR-INDX)        
P00471              WHEN WS-UPDATE                                      
P00471                   PERFORM 8880-UPDATE-ACCT-ATTR THRU 8880-EXIT   
P00471              WHEN WS-INSERT                                      
P00471                   PERFORM 8885-INSERT-ACCT-ATTR THRU 8885-EXIT   
P00471              WHEN WS-DELETE                                      
P00471                   PERFORM 8887-DELETE-ACCT-ATTR THRU 8887-EXIT   
P00471              WHEN OTHER                                          
P00471                   CONTINUE                                       
P00471           END-EVALUATE                                           
C34569        END-IF                                                    
C34569     END-PERFORM                                                  
C34569*                                                                         
C34569** UPDATE MARKET TIER FROM BILLING EXTRACT                                
C34569*                                                                         
C34569     PERFORM VARYING WS-TIER-INDX FROM 1 BY 1                     
C34569             UNTIL WS-TIER-INDX GREATER THAN 25 OR                
C34569                  WS-ACCOUNT-NO-DD (WS-TIER-INDX) = ZERO          
C34569        IF WS-UPDATE-ACTION-IND-DD (WS-TIER-INDX) NOT = SPACE     
C34569           PERFORM 2237-PROCESS-MKT-TIER THRU 2237-EXIT           
C34569           IF WS-UPDATE-ACTION-IND-DD (WS-TIER-INDX)              
C34569                 = WS-UPDATE                                      
C34569              PERFORM 8890-UPDATE-MKT-TIER THRU 8890-EXIT         
C34569           ELSE                                                   
C34569              PERFORM 8895-INSERT-MKT-TIER THRU 8895-EXIT         
C34569           END-IF                                                 
C34569        END-IF                                                    
C34569     END-PERFORM                                                  
C34569*                                                                         
C34569** UPDATE RATE PACKAGE AGREEMENT FROM BILLING EXTRACT                     
C34569*                                                                         
C34569     PERFORM VARYING WS-RTPK-INDX FROM 1 BY 1                     
C34569             UNTIL WS-RTPK-INDX GREATER THAN 25 OR                
C34569                  WS-ACCOUNT-NO-DF (WS-RTPK-INDX) = ZERO          
C34569        IF WS-UPDATE-ACTION-IND-DF (WS-RTPK-INDX) NOT = SPACE     
C34569           PERFORM 2238-PROCESS-RTPK-AGR THRU 2238-EXIT           
C34569           IF WS-UPDATE-ACTION-IND-DF (WS-RTPK-INDX)              
C34569                 = WS-UPDATE                                      
C34569              PERFORM 8900-UPDATE-RTPK-AGR THRU 8900-EXIT         
ACT249              IF DF-STATUS-CD = WS-OPEN-FOR-RENEWAL               
ACT249                 PERFORM 2239-RTPKG-STATUS-CHNG-MNT THRU 2239-EXIT
ACT249              END-IF                                              
C34569           ELSE                                                   
C34569              PERFORM 8905-INSERT-RTPK-AGR THRU 8905-EXIT         
C34569           END-IF                                                 
C34569        END-IF                                                    
C34569     END-PERFORM                                                  
C34569*                                                                         
      ** UPDATE FACTOR HIST FROM BILLING EXTRACT                                
      *                                                                         
           PERFORM VARYING WS-FH-HIST-INDX FROM 1 BY 1                  
T22488             UNTIL WS-FH-HIST-INDX GREATER THAN 200 OR            
                        WS-ACCOUNT-NO-FH (WS-FH-HIST-INDX) = ZERO       
              IF WS-UPDATE-ACTION-IND-FH (WS-FH-HIST-INDX)              
                          NOT = SPACE                                   
                 PERFORM 2230-PROCESS-FACTOR-HIST THRU 2230-EXIT        
                 EVALUATE WS-UPDATE-ACTION-IND-FH (WS-FH-HIST-INDX)     
                    WHEN WS-UPDATE                                      
 CIG                   IF FH-FACTOR-ID =  WS-TRNSP-PURCH                
 CIG                     PERFORM 8731-UPDATE-FCT-HIST-CIG               
 CIG                                                   THRU 8731-EXIT   
 CIG                   ELSE                                             
 CIG                      PERFORM 8730-UPDATE-FCT-HIST THRU 8730-EXIT   
 CIG                   END-IF                                           
                    WHEN WS-RESET                                       
TP9796                 PERFORM 8720-INSERT-FCT-HIST THRU 8720-EXIT      
                       PERFORM 8732-RESET-FXD-FCTR THRU 8732-EXIT       
                    WHEN WS-INSERT                                      
                       PERFORM 8720-INSERT-FCT-HIST THRU 8720-EXIT      
T22488                 IF SQLCODE = ALREADY-EXISTS                      
T22488                    PERFORM UNTIL SQLCODE = SUCCESSFUL-CALL       
T22488                       OR FH-FIXED-FCTR-SEQ-NO > 200              
T22488                      PERFORM 8730-UPDATE-FCT-HIST THRU 8730-EXIT 
T22488                      IF SQLCODE = NOT-FOUND                      
T22488                         ADD 1 TO FH-FIXED-FCTR-SEQ-NO            
T22488                       PERFORM 8720-INSERT-FCT-HIST THRU 8720-EXIT
T22488                      END-IF                                      
T22488                    END-PERFORM                                   
T22488                 END-IF                                           
ACT006              WHEN WS-DELETE                                      
ACT006                  PERFORM 8733-DELETE-FCT-HIST THRU 8733-EXIT     
                 END-EVALUATE                                           
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
      ** UPDATE BILLING RESULTS FROM BILLING EXTRACT                            
      *                                                                         
           PERFORM VARYING WS-CALC-INDX FROM 1 BY 1                     
I00177             UNTIL WS-CALC-INDX > WS-BZ-MAX-ENTRY OR              
                        WS-ACCOUNT-NO-BC (WS-CALC-INDX) = ZERO          
              IF WS-UPDATE-ACTION-IND-BC (WS-CALC-INDX) = 'I'           
                 PERFORM 2240-PROCESS-CALC-RESULTS THRU 2240-EXIT       
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
      ** UPDATE CONTRACT HISTORY FROM BILLING EXTRACT                           
      *                                                                         
           PERFORM VARYING WS-BX-INDX FROM 1 BY 1                       
                   UNTIL WS-BX-INDX > 20                                
                      OR WS-ACCOUNT-NO-BX (WS-BX-INDX) = ZERO           
              IF WS-UPDATE-ACTION-IND-BX (WS-BX-INDX) NOT = SPACE       
                 PERFORM 2250-PROCESS-CONTRACT-HIST THRU 2250-EXIT      
                 IF WS-UPDATE-ACTION-IND-BX (WS-BX-INDX) = WS-INSERT    
                    PERFORM 8770-INSERT-BILL-CNTR-HIST THRU 8770-EXIT   
                 ELSE                                                   
                    PERFORM 8760-UPDATE-BILL-CNTR-HIST                  
                                 THRU 8760-EXIT                         
                 END-IF                                                 
CIG              MOVE BX-ACCOUNT-NO          TO UB-ACCOUNT-NO           
CIG                                             HV-ACCOUNT-NO           
CIG                                             TW-ACCOUNT-NO           
CIG                                             UW-ACCOUNT-NO           
CIG                                             TZ-ACCOUNT-NO           
CIG              MOVE BX-BILL-NO             TO HV-BILL-NO              
CIG                                             UW-BILL-NO              
CIG              MOVE BX-CODE-UTIL-TYPE      TO UB-CODE-UTIL-TYPE       
CIG                                             HV-CODE-UTIL-TYPE       
CIG                                             TW-CODE-UTIL-TYPE       
CIG                                             UW-CODE-UTIL-TYPE       
CIG                                             TZ-CODE-UTIL-TYPE       
CIG              MOVE BX-IC-NO               TO UB-IC-NO                
CIG                                             HV-IC-NO                
CIG                                             TW-PRIMARY-IC-NO        
CIG                                             TZ-PRIMARY-IC-NO        
CIG              MOVE BX-BILL-ITEM-TIMESTMP  TO HV-BILL-ITEM-TIMESTMP   
CIG                                             UW-BILL-ITEM-TIMESTMP   
CIG              MOVE BX-CNTRCT-START-DT     TO UB-CNTRCT-START-DT      
CIG                                             HV-CNTRCT-START-DT      
CIG                                             TW-CNTRCT-START-DT      
CIG                                             UW-CNTRCT-START-DT      
CIG                                             TZ-CNTRCT-START-DT      
CIG              PERFORM 8771-PROCESS-VOL-BLOCK-TB THRU 8771-EXIT       
CIG              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
CIG                 MOVE UB-PRIMARY-IC-NO       TO HV-PRIMARY-IC-NO     
CIG                 MOVE UB-VOL-BLOCK-SEQ       TO HV-VOL-BLOCK-SEQ     
CIG                 MOVE UB-VOL-BLOCK-FACTOR    TO HV-VOL-BLOCK-FACTOR  
CIG                 PERFORM 8773-UPDATE-VOL-BLOCK-HST THRU 8773-EXIT    
CIG                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
CIG                    PERFORM 8772-INSERT-VOL-BLOCK-HST THRU 8772-EXIT 
CIG                 END-IF                                              
CIG              END-IF                                                 
CIG              MOVE 'N'              TO WS-TRNSP-CNTR-EXIST           
CIG              PERFORM 8774-PROCESS-TRNSP-CNTR-TB THRU 8774-EXIT      
CIG              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
CIG                 MOVE 'Y'              TO WS-TRNSP-CNTR-EXIST        
CIG                 MOVE TW-PRIMARY-IC-NO       TO UW-PRIMARY-IC-NO     
CIG                 MOVE TW-TRNSP-SHRINK-PCT    TO UW-TRNSP-SHRINK-PCT  
CIG                 MOVE TW-TRNSP-MDQ           TO UW-TRNSP-MDQ         
CIG                 MOVE TW-TRANSM-ACCT-NO      TO UW-TRANSM-ACCT-NO    
CIG                 MOVE TW-FUEL-SHIPPER-CD     TO UW-FUEL-SHIPPER-CD   
CIG                   PERFORM 8776-UPDATE-TRNSP-CNTR-HST THRU 8776-EXIT 
CIG                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
CIG                    PERFORM 8775-INSERT-TRNSP-CNTR-HST THRU 8775-EXIT
CIG                 END-IF                                              
CIG              END-IF                                                 
CIG              IF WS-TRNSP-CNTR-EXIST = 'Y'                           
CIG                 PERFORM 8777-OPEN-TRNSP-VOL-BLK   THRU 8777-EXIT    
CIG                 PERFORM 8778-FETCH-TRNSP-VOL-BLK   THRU 8778-EXIT   
CIG                 PERFORM 8779-PROCESS-TRNSP-VOL-BLK  THRU 8779-EXIT  
CIG                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND         
CIG                 PERFORM 8782-CLOSE-TRNSP-VOL-BLK   THRU 8782-EXIT   
CIG              END-IF                                                 
              END-IF                                                    
           END-PERFORM                                                  
P00251*                                                                         
P00251** UPDATE MASTER DEPENDENT RELATIONSHIP HISTORY                           
P00251** FROM BILLING EXTRACT                                                   
P00251*                                                                         
P00251     PERFORM VARYING WS-UX-INDX FROM 1 BY 1                       
P00251             UNTIL WS-UX-INDX > WS-MAX-UX-ENTRIES                 
P00251               OR WS-ACCOUNT-NO-MST-UX (WS-UX-INDX) = ZERO        
P00251        IF WS-UPDATE-ACTION-IND-UX (WS-UX-INDX) = WS-INSERT       
P00251           PERFORM 2360-PROCESS-UTL-BI-REL-HST THRU 2360-EXIT     
P00251           PERFORM 8910-INSERT-UTL-BI-REL-HST  THRU 8910-EXIT     
P00251        END-IF                                                    
P00251     END-PERFORM                                                  
P00251                                                                  
P00496*                                                                         
P00496** INSERT BILL CONTRACT BASELINE HISTORY FROM BILLING EXTRACT.            
P00496*                                                                         
P00496     PERFORM VARYING WS-LO-INDEX FROM 1 BY 1                      
P00496       UNTIL WS-LO-INDEX > 20                                     
P00496          OR WS-ACCOUNT-NO-LO (WS-LO-INDEX) = ZERO                
P00496        IF WS-UPDATE-ACTION-IND-LO (WS-LO-INDEX) = WS-INSERT      
P00496           PERFORM VARYING WS-LO-UNITS-INDX FROM 1 BY 1           
P00496             UNTIL WS-LO-UNITS-INDX > 30                          
P00496                OR WS-CMPNT-ID-CD-LO                              
P00496                     (WS-LO-INDEX WS-LO-UNITS-INDX) = SPACES      
P00496              PERFORM 2370-PROCESS-BILL-BSLN-HIST THRU 2370-EXIT  
P00496              PERFORM 8920-INSERT-BILL-BSLN-HIST  THRU 8920-EXIT  
P00496           END-PERFORM                                            
P00496        END-IF                                                    
P00496     END-PERFORM                                                  
      *                                                                         
      **  IF THIS IS THE CURRENT ACCOUNT AT THE PREMISE, AND IF                 
      **  THE BILL HEADER BEING BILLED/UPDATED IS THE CURRENT ONE               
      **  CREATE A NEW UNBILLED HISTORY SET.                                    
      *                                                                         
TP4910     IF WS-NEXT-BILL-NO-CALC > ZERO                               
             AND WS-MST-SUB-ACCT-IND-AT NOT = WS-MASTER                 
              PERFORM 5800-CREATE-BH-HIST-HOOKS THRU 5800-EXIT          
           END-IF.                                                      
      *                                                                         
           PERFORM 2005-CLEANUP-SPEC-MTR-MSG THRU 2005-EXIT.            
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04217000
      /****************************************************************         
      *  2005-CLEANUP-SPEC-MTR-MSG                                    *         
      *                                                               *         
      *  WHEN THE DATE OF COLUMN DATE_SPCL_MSG_ENDS IS PREVIOUS TO    *         
      *  THE CURRENT DATE, SPACES ARE MOVED TO THE MESSAGE AND ZEROS  *         
      *  ARE MOVED TO THE DATE FIELD IN THE CSS_PREMISE TABLE.        *         
      *****************************************************************         
       2005-CLEANUP-SPEC-MTR-MSG.                                       
      *                                                                         
           IF WS-DATE-SPCL-MSG-ENDS-PR > LOW-VALUES                     
                 AND WS-DATE-SPCL-MSG-ENDS-PR < LS-INPUT-DATE           
              MOVE WS-PREMISE-NO-PR TO PR-PREMISE-NO                    
              MOVE LOW-VALUES       TO WS-DATE-SPCL-MSG-ENDS-PR         
              MOVE ZERO             TO PR-SPCL-READ-INSTR-LEN           
              MOVE SPACES           TO PR-SPCL-READ-INSTR-TEXT          
              PERFORM 8110-UPDATE-PREMISE THRU 8110-EXIT                
           END-IF.                                                      
      *                                                                         
       2005-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************        
      *                                                                *        
      *  2100-PROCESS-BE-BILLING.                                      *        
      *                                                                *        
      *   INSERT/UPDATE BILLING DETAIL ROWS FROM BILL EXTRACT          *        
      *                                                                *        
      ******************************************************************        
       2100-PROCESS-BG-BILLING.                                         
T4940      IF WS-ACCOUNT-NO-BG (WS-BILLING-INDX) EQUAL WS-ACCOUNT-NO-BI 
T4940         MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX) TO  BG-ACCOUNT-NO 
T4940         MOVE WS-BILL-NO-BG (WS-BILLING-INDX)    TO  BG-BILL-NO    
T4940      ELSE                                                         
T4940         MOVE WS-ACCOUNT-NO-BI TO  BG-ACCOUNT-NO                   
T4940         MOVE WS-BILL-NO-BI    TO  BG-BILL-NO                      
T4940      END-IF.                                                      
           MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)                  
             TO BG-CODE-UTIL-TYPE.                                      
           MOVE WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX) TO           
                BG-BILL-ITEM-TIMESTMP.                                  
           MOVE WS-IC-NO-BG (WS-BILLING-INDX)                           
             TO BG-IC-NO.                                               
           MOVE WS-ADJ-REASON-CD-BG (WS-BILLING-INDX)                   
             TO BG-ADJ-REASON-CD                                        
T22406******************************************************************        
T22406* WS-CODE-CURTAIL-PRTY-BG IS BEING USED TO FLAG EMC SEB CUSTOMERS*        
T22406*   THIS FLAG IS USED FOR SPECIAL BILLING PURPOSES               *        
T22406******************************************************************        
T22406     MOVE WS-CODE-CURTAIL-PRTY-BG (WS-BILLING-INDX)               
T22406       TO BG-CODE-CURTAIL-PRTY                                    
           MOVE WS-CODE-BILL-ITM-TYPE-BG (WS-BILLING-INDX)              
             TO BG-CODE-BILL-ITM-TYPE                                   
           MOVE WS-CODE-BILL-ITM-IND-BG (WS-BILLING-INDX)               
             TO BG-CODE-BILL-ITM-IND                                    
           MOVE WS-CODE-DR-CR-CNSMPTN-BG (WS-BILLING-INDX)              
             TO BG-CODE-DR-CR-CNSMPTN                                   
           MOVE WS-CODE-BILL-CALC-BG (WS-BILLING-INDX)                  
             TO BG-CODE-BILL-CALC                                       
           MOVE WS-PREMISE-NO-BG (WS-BILLING-INDX)                      
             TO BG-PREMISE-NO.                                          
           MOVE WS-COMPANY-NO-BG (WS-BILLING-INDX)                      
             TO BG-COMPANY-NO                                           
           MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)                    
             TO BG-RATE-PLAN-NO                                         
           MOVE WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX)              
             TO BG-CODE-REVENUE-CLASS                                   
           MOVE WS-CODE-SIC-NO-BG (WS-BILLING-INDX)                     
             TO BG-CODE-SIC-NO                                          
           MOVE WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)                   
             TO BG-AMT-BILL-ITEM                                        
           MOVE WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)                   
             TO BG-AMT-STATE-TAX                                        
           MOVE WS-AMT-CITY-TAX-BG (WS-BILLING-INDX)                    
             TO BG-AMT-CITY-TAX                                         
           MOVE WS-AMT-OTHER-TAX-BG (WS-BILLING-INDX)                   
             TO BG-AMT-OTHER-TAX                                        
           MOVE WS-NEW-RATE-PCT-BG (WS-BILLING-INDX)                    
             TO BG-NEW-RATE-PCT                                         
           MOVE WS-LFTM-HI-PEAK-DMD-BG (WS-BILLING-INDX)                
             TO BG-LFTM-HI-PEAK-DMD                                     
           MOVE WS-REVENUE-MONTH-BG (WS-BILLING-INDX)                   
             TO BG-REVENUE-MONTH                                        
           MOVE WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)               
             TO BG-REV-MTH-ORIG-BILL                                    
           MOVE WS-AMT-OTHER-TAX-BG (WS-BILLING-INDX)                   
             TO BG-AMT-OTHER-TAX                                        
           MOVE WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX)                  
             TO BG-DATE-ORIG-BILL                                       
           MOVE WS-CODE-SUB-TOTAL-BG (WS-BILLING-INDX)                  
             TO BG-CODE-SUB-TOTAL                                       
           MOVE WS-TAX-REFUND-CD-BG (WS-BILLING-INDX)                   
             TO BG-TAX-REFUND-CD                                        
           MOVE WS-DATE-LFTM-HI-DMD-BG (WS-BILLING-INDX)                
             TO BG-DATE-LFTM-HI-DMD                                     
           MOVE WS-REBILL-IND-BG (WS-BILLING-INDX)                      
             TO BG-REBILL-IND                                           
           MOVE WS-CODE-CITY-TAX-XMT-BG (WS-BILLING-INDX)               
             TO BG-CODE-CITY-TAX-XMT                                    
           MOVE WS-CODE-OTHR-TAX-XMT-BG (WS-BILLING-INDX)               
             TO BG-CODE-OTHR-TAX-XMT                                    
           MOVE WS-REV-RPT-CD-BG (WS-BILLING-INDX)                      
             TO BG-REV-RPT-CD                                           
           MOVE WS-STANDBY-COMPLIED-BG (WS-BILLING-INDX)                
             TO BG-STANDBY-COMPLIED                                     
           MOVE WS-PRORATE-CD-BG (WS-BILLING-INDX)                      
             TO BG-PRORATE-CD                                           
           MOVE WS-CODE-SUB-TOTAL-BG (WS-BILLING-INDX)                  
             TO BG-CODE-SUB-TOTAL                                       
           MOVE WS-TAX-REFUND-CD-BG (WS-BILLING-INDX)                   
             TO BG-TAX-REFUND-CD                                        
           MOVE WS-CODE-STAT-TAX-XMT-BG (WS-BILLING-INDX)               
             TO BG-CODE-STAT-TAX-XMT                                    
           MOVE WS-CODE-CITY-TAX-XMT-BG (WS-BILLING-INDX)               
             TO BG-CODE-CITY-TAX-XMT                                    
           MOVE WS-BTU-FACTOR-BG (WS-BILLING-INDX)                      
             TO BG-BTU-FACTOR                                           
           MOVE WS-WNA-FACTOR-BG (WS-BILLING-INDX)                      
             TO BG-WNA-FACTOR                                           
           MOVE WS-GAS-BASE-USE-BG (WS-BILLING-INDX)                    
             TO BG-GAS-BASE-USE                                         
           MOVE WS-NO-OF-CONS-DAYS-BG (WS-BILLING-INDX)                 
             TO BG-NO-OF-CONS-DAYS                                      
           MOVE WS-REV-DISTRICT-CD-BG (WS-BILLING-INDX)                 
             TO BG-REV-DISTRICT-CD                                      
T23631     MOVE WS-FUEL-SHIPPER-CD-BG (WS-BILLING-INDX)                 
T23631       TO BG-FUEL-SHIPPER-CD                                      
C29528     MOVE WS-STATE-TX-RATE-CALC (WS-BILLING-INDX)                 
C29528       TO BG-STATE-TAX-RATE                                       
C29528     MOVE WS-FRANCHISE-TX-RATE-CALC (WS-BILLING-INDX)             
C29528       TO BG-CITY-TAX-RATE                                        
C33362     MOVE WS-BILL-CALC-CYCLE-BG (WS-BILLING-INDX)                 
C33362       TO BG-BILL-CALC-CYCLE                                      
                                                                        
           IF BG-CODE-BILL-ITM-IND = WS-BACKOUT                         
              MOVE WS-ACTIVE TO BG-CODE-BILL-ITM-IND                    
           END-IF.                                                      
C33968     MOVE WS-NAICS-CD-BG (WS-BILLING-INDX) TO                     
C33968          BG-NAICS-CD.                                            
C34569     MOVE WS-RT-PKG-OPT-SEQ-NO-BG (WS-BILLING-INDX) TO            
C34569          BG-RT-PKG-OPT-SEQ-NO.                                   
                                                                        
           IF WS-UPDATE-ACTION-IND-BG (WS-BILLING-INDX) = WS-UPDATE     
              PERFORM 8420-UPDATE-BILLING-DET THRU 8420-EXIT            
           ELSE                                                         
              IF BG-DATE-ORIG-BILL = LOW-VALUES OR SPACES               
                 PERFORM 8421-INSERT-BILLING-DET THRU 8421-EXIT         
              ELSE                                                      
RSN2****************GO FIND MATCHING CONSUMPTION AND CHANGE TIMESTAMP           
RSN2****************ON THE CONSUMPTION BEFORE CHANGING ON BG                    
RSN2             PERFORM 5900-SEARCH-FOR-CONSUMPTION THRU 5900-EXIT     
                 PERFORM 8421-INSERT-BILLING-DET THRU 8421-EXIT         
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF BG-CODE-BILL-ITM-IND = WS-CLERK-CANCEL                    
                 AND BG-CODE-UTIL-TYPE NOT = WS-UNMETERED               
              PERFORM 2110-PROCESS-CANCELLED THRU 2110-EXIT             
           END-IF.                                                      
TP4508     IF WS-MST-SUB-ACCT-IND-AT  NOT = WS-MASTER                   
DC            PERFORM 2140-PROCESS-ANNUAL-SUMMARY THRU 2140-EXIT        
TP4508     END-IF.                                                      
                                                                        
T10791     IF WS-MST-SUB-ACCT-IND-AT = WS-SUB                           
T18995        MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX) TO WS-ACCOUNT-NO  
T18995        MOVE SPACE TO WS-SUB-BILLED-SW                            
T18995        PERFORM 7000-SELECT-MSTSUB-ACCT THRU 7000-EXIT            
T10791        PERFORM 2120-INSERT-AF  THRU 2120-EXIT                    
T10791     END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
T4940  2120-INSERT-AF.                                                  
T10791     MOVE WS-ACCT-XFER-TO-AT TO AT-ACCOUNT-NO                     
T10791                                AF-ACCOUNT-NO.                    
T10791     PERFORM 7350-SELECT-MASTER-AT THRU 7350-EXIT.                
T18995     IF SUB-BILLED-OK                                             
T18995        MOVE AT-NXT-BILL-NO TO AF-BILL-NO                         
T18995     ELSE                                                         
T18995        COMPUTE AF-BILL-NO = AT-NXT-BILL-NO + 1                   
T18995     END-IF.                                                      
T10791     MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX)                      
T10791          TO AF-ACCT-XFER-FROM.                                   
T10791     MOVE WS-BILL-NO-BG (WS-BILLING-INDX)                         
T10791          TO AF-BILL-NO-XFER-FROM.                                
T10791     MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)                  
T10791          TO AF-CODE-UTIL-TYPE.                                   
T10791     MOVE WS-IC-NO-BG (WS-BILLING-INDX)                           
T10791          TO AF-IC-NO.                                            
T10791     MOVE WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)              
T10791          TO AF-BILL-ITEM-TIMESTMP.                               
T4940      PERFORM  8000-INSERT-BILL-ACCT-XFER  THRU  8000-EXIT.        
T4940  2120-EXIT.                                                       
T4940      EXIT.                                                        
                                                                        
      /                                                                         
       2110-PROCESS-CANCELLED.                                          
           IF WS-UT-TABLE-COUNT-CALC > ZERO                             
              MOVE WS-PENDING-NEXT-BILL TO WS-CODE-BILL-PEND-AT         
              IF BG-CODE-BILL-CALC = WS-REGULAR-BILL                    
                 PERFORM 5100-PROCESS-NORM-ITEM THRU 5100-EXIT          
              ELSE                                                      
                 PERFORM 5200-PROCESS-SPEC-ITEM THRU 5200-EXIT
              END-IF          
           ELSE                                                         
              PERFORM 5300-PROCESS-PRIOR-ACCT THRU 5300-EXIT
           END-IF.           
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
DC     2140-PROCESS-ANNUAL-SUMMARY.                                     
DC         IF BG-REV-MTH-ORIG-BILL > 0                                  
DC           MOVE BG-REV-MTH-ORIG-BILL      TO WS-REV-MONTH-YYYYMM      
DC         ELSE                                                         
DC           MOVE BG-REVENUE-MONTH          TO WS-REV-MONTH-YYYYMM      
DC         END-IF.                                                      
DC                                                                      
DC         MOVE ZEROS                         TO WS-BZ-READ-UNITS.      
T17222     IF BG-CODE-BILL-ITM-TYPE = 'B'                               
T17222        PERFORM 2151-GET-CX-UNITS THRU 2151-EXIT                  
DC                VARYING WS-CNSMPTN-INDX FROM 1 BY 1                   
I00177               UNTIL WS-CNSMPTN-INDX > WS-CX-MAX-ENTRY            
T17222                  OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) = 0       
T17222     ELSE                                                         
DC            PERFORM 2150-GET-READ-UNITS THRU 2150-EXIT                
DC                VARYING WS-CALC-INDX FROM 1 BY 1                      
I00177               UNTIL WS-CALC-INDX > WS-BZ-MAX-ENTRY               
DC                      OR WS-ACCOUNT-NO-BC (WS-CALC-INDX) = 0
           END-IF.         
DC                                                                      
T17222     MOVE LS-CURR-REVENUE-MONTH         TO WS-TEMP-REV-MONTH      
T17222     IF WS-REV-MONTH-YYYY = WS-TEMP-REV-YYYY                      
T17222        GO TO 2140-EXIT
           END-IF.                                          
T17222*                                                                         
DC         PERFORM 7250-SELECT-ANNUAL-SUMMARY THRU 7250-EXIT.           
DC                                                                      
DC         EVALUATE TRUE                                                
DC             WHEN BG-CODE-BILL-ITM-IND = 'A'                          
DC                      AND BG-CODE-BILL-ITM-TYPE = 'C'                 
DC                 ADD BG-AMT-BILL-ITEM        TO AS-TOTAL-REVENUE      
DC                 ADD BG-NO-OF-CONS-DAYS      TO AS-NO-DAYS            
DC                 ADD WS-BZ-READ-UNITS        TO AS-TOTAL-USAGE        
DC             WHEN BG-CODE-BILL-ITM-TYPE = 'B'                         
DC                 SUBTRACT BG-AMT-BILL-ITEM   FROM AS-TOTAL-REVENUE    
DC                 SUBTRACT BG-NO-OF-CONS-DAYS FROM AS-NO-DAYS          
DC                 SUBTRACT WS-BZ-READ-UNITS   FROM AS-TOTAL-USAGE      
DC         END-EVALUATE.                                                
DC                                                                      
DC         IF SQLCODE = NOT-FOUND                                       
DC             PERFORM 8800-INSERT-ANNUAL-SUMMARY THRU 8800-EXIT        
DC         ELSE                                                         
DC             PERFORM 8810-UPDATE-ANNUAL-SUMMARY THRU 8810-EXIT
           END-IF.       
DC                                                                      
DC     2140-EXIT.                                                       
DC         EXIT.                                                        
DC                                                                      
DC     2150-GET-READ-UNITS.                                             
DC         IF WS-ACCOUNT-NO-BC (WS-CALC-INDX)  = BG-ACCOUNT-NO          
DC                  AND WS-BILL-NO-BC (WS-CALC-INDX)     = BG-BILL-NO   
DC                  AND WS-CODE-UTIL-TYPE-BC (WS-CALC-INDX) =           
DC                                          BG-CODE-UTIL-TYPE           
DC                  AND WS-IC-NO-BC (WS-CALC-INDX)       = BG-IC-NO     
DC                  AND WS-BILL-ITEM-TIMESTMP-BC (WS-CALC-INDX) =       
DC                                      BG-BILL-ITEM-TIMESTMP           
DC                  AND WS-CONSUMPTION-TYPE-BC (WS-CALC-INDX) NOT = 'E' 
DC                  AND WS-CONSUMPTION-TYPE-BC (WS-CALC-INDX) NOT = 'J' 
DC            ADD WS-NET-UNITS-BC (WS-CALC-INDX)                        
DC              TO WS-BZ-READ-UNITS
           END-IF.                                    
DC                                                                      
DC     2150-EXIT.                                                       
DC         EXIT.                                                        
DC    /                                                                         
T17222 2151-GET-CX-UNITS.                                               
T17222     IF WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) = BG-ACCOUNT-NO        
T17222            AND WS-BILL-NO-CX (WS-CNSMPTN-INDX)  = BG-BILL-NO     
T17222            AND WS-CODE-UTIL-TYPE-CX (WS-CNSMPTN-INDX) =          
T17222                BG-CODE-UTIL-TYPE                                 
T17222            AND WS-IC-NO-CX (WS-CNSMPTN-INDX)    = BG-IC-NO       
T17222            AND WS-BILL-ITEM-TIMESTMP-CX (WS-CNSMPTN-INDX) =      
T17222                BG-BILL-ITEM-TIMESTMP                             
T17222            AND WS-CODE-USAGE-ID-CX (WS-CNSMPTN-INDX) NOT NUMERIC 
T17222            AND WS-CODE-ITEM-STATUS-CX (WS-CNSMPTN-INDX) = 'A'    
T17222        ADD WS-NO-UNITS-CX (WS-CNSMPTN-INDX)                      
T17222          TO WS-BZ-READ-UNITS
           END-IF.                                    
T17222                                                                  
T17222 2151-EXIT.                                                       
T17222     EXIT.                                                        
T17222                                                                  
       2200-PROCESS-CNSMPT-HIST.                                        
           MOVE WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX)                      
             TO CX-ACCOUNT-NO                                           
           MOVE WS-BILL-NO-CX (WS-CNSMPTN-INDX)                         
             TO CX-BILL-NO                                              
           MOVE WS-CODE-UTIL-TYPE-CX (WS-CNSMPTN-INDX)                  
             TO CX-CODE-UTIL-TYPE                                       
           MOVE WS-IC-NO-CX (WS-CNSMPTN-INDX)                           
             TO CX-IC-NO                                                
           MOVE WS-BILL-ITEM-TIMESTMP-CX (WS-CNSMPTN-INDX)              
             TO CX-BILL-ITEM-TIMESTMP                                   
           MOVE WS-MTR-REF-NO-CX (WS-CNSMPTN-INDX)                      
             TO CX-MTR-REF-NO                                           
           MOVE WS-CODE-USAGE-TYPE-CX (WS-CNSMPTN-INDX)                 
             TO CX-CODE-USAGE-TYPE                                      
           MOVE WS-CODE-USAGE-ID-CX (WS-CNSMPTN-INDX)                   
             TO CX-CODE-USAGE-ID                                        
           MOVE WS-CODE-USAGE-SOURCE-CX (WS-CNSMPTN-INDX)               
             TO CX-CODE-USAGE-SOURCE                                    
           MOVE WS-CODE-TIME-PERIOD-CX (WS-CNSMPTN-INDX)                
             TO CX-CODE-TIME-PERIOD                                     
           MOVE WS-ITEM-SEQ-NO-CX (WS-CNSMPTN-INDX)                     
             TO CX-ITEM-SEQ-NO                                          
           MOVE WS-METER-NO-CX (WS-CNSMPTN-INDX)                        
             TO CX-METER-NO                                             
           MOVE WS-REG-ID-NO-CX (WS-CNSMPTN-INDX)                       
             TO CX-REG-ID-NO                                            
           MOVE WS-DATE-READ-CX (WS-CNSMPTN-INDX)                       
             TO CX-DATE-READ                                            
           MOVE WS-CODE-METER-READ-CX (WS-CNSMPTN-INDX)                 
             TO CX-CODE-METER-READ                                      
           MOVE WS-CODE-METER-NO-READ-CX (WS-CNSMPTN-INDX)              
             TO CX-CODE-METER-NO-READ                                   
           MOVE WS-METER-READING-CX (WS-CNSMPTN-INDX)                   
             TO CX-METER-READING                                        
           MOVE WS-DEMAND-READING-CX (WS-CNSMPTN-INDX)                  
             TO CX-DEMAND-READING                                       
           MOVE WS-EMPLOYEE-NO-CX (WS-CNSMPTN-INDX)                     
             TO CX-EMPLOYEE-NO                                          
           MOVE WS-NO-UNITS-CX (WS-CNSMPTN-INDX)                        
             TO CX-NO-UNITS                                             
           MOVE WS-NO-DEMAND-UNITS-CX (WS-CNSMPTN-INDX)                 
             TO CX-NO-DEMAND-UNITS                                      
           MOVE WS-NO-DAYS-CX (WS-CNSMPTN-INDX)                         
             TO CX-NO-DAYS                                              
           MOVE WS-CODE-SOURCE-ID-CX (WS-CNSMPTN-INDX)                  
             TO CX-CODE-SOURCE-ID                                       
           MOVE WS-CODE-DEBIT-CREDIT-CX (WS-CNSMPTN-INDX)               
             TO CX-CODE-DEBIT-CREDIT                                    
           MOVE WS-CODE-ITEM-STATUS-CX (WS-CNSMPTN-INDX)                
             TO CX-CODE-ITEM-STATUS                                     
           MOVE WS-CODE-DISCOUNT-CX (WS-CNSMPTN-INDX)                   
             TO CX-CODE-DISCOUNT                                        
           MOVE WS-CONSTANT-CX (WS-CNSMPTN-INDX)                        
             TO CX-CONSTANT                                             
           MOVE WS-NO-DIALS-CX (WS-CNSMPTN-INDX)                        
             TO CX-NO-DIALS                                             
           MOVE WS-EXCEPT-OVERRIDE-CD-CX (WS-CNSMPTN-INDX)              
             TO CX-EXCEPT-OVERRIDE-CD                                   
           MOVE WS-REQUESTED-USAGE-CX (WS-CNSMPTN-INDX)                 
             TO CX-REQUESTED-USAGE                                      
           MOVE WS-DIGTL-INTRL-MTR-NO-CX (WS-CNSMPTN-INDX)              
             TO CX-DIGTL-INTRL-MTR-NO                                   
           MOVE WS-DIGTL-MTR-TYPE-CX (WS-CNSMPTN-INDX)                  
             TO CX-DIGTL-MTR-TYPE                                       
           MOVE WS-CODE-TOU-SEASN-CX (WS-CNSMPTN-INDX)                  
             TO CX-CODE-TOU-SEASN                                       
           MOVE WS-EXCL-DMD-RCHT-IND-CX (WS-CNSMPTN-INDX)               
             TO CX-EXCL-DMD-RCHT-IND                                    
           MOVE WS-MTR-READ-SOURCE-CD-CX (WS-CNSMPTN-INDX)              
             TO CX-MTR-READ-SOURCE-CD                                   
           MOVE WS-COMPANY-NO-CX (WS-CNSMPTN-INDX)                      
             TO CX-COMPANY-NO.                                          
T30989     MOVE WS-PCOMP-FCT-CX (WS-CNSMPTN-INDX)                       
T30989       TO CX-PCOMP-FCT.                                           
A03446     MOVE WS-DATE-PEAK-DEMAND-CX (WS-CNSMPTN-INDX)                
A03446       TO CX-PEAK-DEMAND-DT.                                      
A03446     MOVE WS-PRV-MTR-READ-COMB-FLG-CX (WS-CNSMPTN-INDX)           
A03446       TO CX-PRV-MTR-RD-COMB-FL.                                  
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
P00496                                                                  
P00496 2205-PROCESS-CNSMPT-HOURLY.                                      
P00496                                                                  
P00496     MOVE WS-ACCOUNT-NO-2C (HOURLY-INDX)                          
P00496       TO 2C-ACCOUNT-NO                                           
P00496     MOVE WS-BILL-NO-2C (HOURLY-INDX)                             
P00496       TO 2C-BILL-NO                                              
P00496     MOVE WS-CODE-UTIL-TYPE-2C (HOURLY-INDX)                      
P00496       TO 2C-CODE-UTIL-TYPE                                       
P00496     MOVE WS-IC-NO-2C (HOURLY-INDX)                               
P00496       TO 2C-IC-NO                                                
P00496     MOVE WS-BILL-ITEM-TIMESTMP-2C (HOURLY-INDX)                  
P00496       TO 2C-BILL-ITEM-TIMESTMP                                   
P00496     MOVE WS-CMPNT-ID-CD-2C (HOURLY-INDX)                         
P00496       TO 2C-CMPNT-ID-CD                                          
P00496     MOVE WS-BLOCK-NO-2C (HOURLY-INDX)                            
P00496       TO 2C-BLOCK-NO                                             
P00496     MOVE WS-INSTR-USE-TYPE-CD-2C (HOURLY-INDX)                   
P00496       TO 2C-INSTR-USE-TYPE-CD                                    
P00496     MOVE WS-DATE-READ-2C (HOURLY-INDX)                           
P00496       TO 2C-DATE-READ                                            
P00496     MOVE WS-TIME-READ-2C (HOURLY-INDX)                           
P00496       TO 2C-TIME-READ                                            
P00496     MOVE WS-DST-CHNG-IND-2C (HOURLY-INDX)                        
P00496       TO 2C-DST-CHNG-IND                                         
P00496     MOVE WS-NO-UNITS-2C (HOURLY-INDX)                            
P00496       TO 2C-NO-UNITS                                             
P00496     MOVE WS-TOTAL-UNIT-PRICE-2C (HOURLY-INDX)                    
P00496       TO 2C-TOTAL-UNIT-PRICE                                     
P00496     MOVE WS-VARIABL-UNIT-PRICE-2C (HOURLY-INDX)                  
P00496       TO 2C-VARIABL-UNIT-PRICE                                   
P00496     .                                                            
P00496                                                                  
P00496 2205-EXIT.                                                       
P00496     EXIT.                                                        
P00496                                                                  
      /                                                                         
       2210-PROCESS-UM-CNSMPT-HIST.                                     
           MOVE WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX)               
             TO UC-ACCOUNT-NO                                           
           MOVE WS-BILL-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                  
             TO UC-BILL-NO                                              
           MOVE WS-CODE-UTIL-TYPE-UC (WS-UNMTRD-CNSMPTN-INDX)           
             TO UC-CODE-UTIL-TYPE                                       
           MOVE WS-IC-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                    
             TO UC-IC-NO                                                
           MOVE WS-BILL-ITEM-TIMESTMP-UC (WS-UNMTRD-CNSMPTN-INDX)       
             TO UC-BILL-ITEM-TIMESTMP                                   
           MOVE WS-RATE-ITEM-CODE-UC (WS-UNMTRD-CNSMPTN-INDX)           
             TO UC-RATE-ITEM-CODE                                       
           MOVE WS-ITEM-SEQ-NO-UC (WS-UNMTRD-CNSMPTN-INDX)              
             TO UC-ITEM-SEQ-NO                                          
           MOVE WS-NO-UNITS-UC (WS-UNMTRD-CNSMPTN-INDX)                 
             TO UC-NO-UNITS                                             
           MOVE WS-NO-DAYS-UC (WS-UNMTRD-CNSMPTN-INDX)                  
             TO UC-NO-DAYS                                              
           MOVE WS-CODE-DEBIT-CREDIT-UC (WS-UNMTRD-CNSMPTN-INDX)        
             TO UC-CODE-DEBIT-CREDIT                                    
           MOVE WS-USAGE-FIXED-UC (WS-UNMTRD-CNSMPTN-INDX)              
             TO UC-USAGE-FIXED                                          
           MOVE WS-DATE-USAGE-ENDS-UC (WS-UNMTRD-CNSMPTN-INDX)          
             TO UC-DATE-USAGE-ENDS                                      
           MOVE WS-CODE-SERVICE-TYPE-UC (WS-UNMTRD-CNSMPTN-INDX)        
             TO UC-CODE-SERVICE-TYPE                                    
           MOVE WS-CODE-ITEM-STATUS-UC (WS-UNMTRD-CNSMPTN-INDX)         
             TO UC-CODE-ITEM-STATUS                                     
           MOVE WS-CODE-SOURCE-ID-UC (WS-UNMTRD-CNSMPTN-INDX)           
             TO UC-CODE-SOURCE-ID                                       
           MOVE WS-DIST-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                  
             TO UC-DIST-NO                                              
           MOVE WS-LIGHT-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                 
             TO UC-LIGHT-NO                                             
           MOVE WS-POLE-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                  
             TO UC-POLE-NO                                              
           MOVE WS-MTHLY-AMOUNT-FIXED-UC (WS-UNMTRD-CNSMPTN-INDX)       
             TO UC-MTHLY-AMOUNT-FIXED.                                  
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       2230-PROCESS-FACTOR-HIST.                                        
           MOVE WS-ACCOUNT-NO-FH (WS-FH-HIST-INDX)                      
             TO FH-ACCOUNT-NO                                           
           MOVE WS-BILL-NO-FH (WS-FH-HIST-INDX)                         
             TO FH-BILL-NO                                              
           MOVE WS-CODE-UTIL-TYPE-FH (WS-FH-HIST-INDX)                  
             TO FH-CODE-UTIL-TYPE                                       
           MOVE WS-IC-NO-FH (WS-FH-HIST-INDX)                           
             TO FH-IC-NO                                                
           MOVE WS-BILL-ITEM-TIMESTMP-FH (WS-FH-HIST-INDX)              
             TO FH-BILL-ITEM-TIMESTMP                                   
           MOVE WS-FIXED-FCTR-SEQ-NO-FH (WS-FH-HIST-INDX)               
             TO FH-FIXED-FCTR-SEQ-NO                                    
                                                                        
           MOVE WS-FACTOR-ID-FH (WS-FH-HIST-INDX)                       
             TO FH-FACTOR-ID                                            
           MOVE WS-EFF-DATE-FROM-FH (WS-FH-HIST-INDX)                   
             TO FH-EFF-DATE-FROM                                        
                                                                        
           MOVE WS-CMPNT-ID-CD-FH (WS-FH-HIST-INDX)                     
             TO FH-CMPNT-ID-CD                                          
           MOVE WS-CODE-SEASON-FH (WS-FH-HIST-INDX)                     
             TO FH-CODE-SEASON                                          
           MOVE WS-INSTR-USE-TYPE-CD-FH (WS-FH-HIST-INDX)               
             TO FH-INSTR-USE-TYPE-CD                                    
           MOVE WS-CODE-TIME-PERIOD-FH (WS-FH-HIST-INDX)                
             TO FH-CODE-TIME-PERIOD                                     
                                                                        
           MOVE WS-CODE-DEBIT-CREDIT-FH (WS-FH-HIST-INDX)               
             TO FH-CODE-DEBIT-CREDIT                                    
           MOVE WS-CODE-REVENUE-CLASS-FH (WS-FH-HIST-INDX)              
             TO FH-CODE-REVENUE-CLASS                                   
           MOVE WS-CODE-TAX-STAT-XMT-FH (WS-FH-HIST-INDX)               
             TO FH-CODE-TAX-STAT-XMT                                    
           MOVE WS-CODE-TAX-CITY-XMT-FH (WS-FH-HIST-INDX)               
             TO FH-CODE-TAX-CITY-XMT                                    
           MOVE WS-CODE-TAX-OTHR-XMT-FH (WS-FH-HIST-INDX)               
             TO FH-CODE-TAX-OTHR-XMT                                    
           MOVE WS-FACTOR-FH  (WS-FH-HIST-INDX)                         
             TO  FH-FACTOR                                              
           MOVE WS-EFF-DATE-TO-FH (WS-FH-HIST-INDX)                     
             TO FH-EFF-DATE-TO                                          
           MOVE WS-FIXED-FCTR-TYP-CD-FH (WS-FH-HIST-INDX)               
             TO FH-FIXED-FCTR-TYP-CD.                                   
CIG        MOVE WS-BILL-UNITS-FH (WS-FH-HIST-INDX)                      
CIG          TO FH-BILL-UNITS.                                          
CIG        MOVE WS-ENERGY-UNIT-CD-FH (WS-FH-HIST-INDX)                  
CIG          TO FH-ENERGY-UNIT-CD.                                      
                                                                        
C34569     MOVE WS-DURATION-REMAIN-NO-FH (WS-FH-HIST-INDX)              
C34569       TO FH-DURATION-REMAIN-NO                                   
C34569     MOVE WS-OVR-RT-VER-PRO-FL-FH (WS-FH-HIST-INDX)               
C34569       TO FH-OVR-RT-VER-PRO-FL                                    
C34569     MOVE WS-RT-PKG-OPT-SEQ-NO-FH (WS-FH-HIST-INDX)               
C34569       TO FH-RT-PKG-OPT-SEQ-NO.                                   
P00165     MOVE WS-BLOCK-NO-FH (WS-FH-HIST-INDX)                        
P00165       TO FH-BLOCK-NO.                                            
A03303     MOVE WS-FCTR-POWER-10-FH (WS-FH-HIST-INDX)                   
A03303       TO FH-FCTR-POWER-10.                                       
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
C34569/                                                                         
C34569 2235-PROCESS-FIXED-FCTR.                                         
C34569     MOVE WS-BI-ACCOUNT-NO-FF (WS-BI-FF-INDX)                     
C34569       TO FF-ACCOUNT-NO                                           
C34569     MOVE WS-BI-CODE-UTIL-TYPE-FF (WS-BI-FF-INDX)                 
C34569       TO FF-CODE-UTIL-TYPE                                       
C34569     MOVE WS-BI-IC-NO-FF (WS-BI-FF-INDX)                          
C34569       TO FF-IC-NO                                                
C34569     MOVE WS-BI-FIXED-FCTR-SEQ-NO-FF (WS-BI-FF-INDX)              
C34569       TO FF-FIXED-FCTR-SEQ-NO                                    
C34569     MOVE WS-BI-FACTOR-ID-FF (WS-BI-FF-INDX)                      
C34569       TO FF-FACTOR-ID                                            
C34569     MOVE WS-BI-EFF-DATE-FROM-FF (WS-BI-FF-INDX)                  
C34569       TO FF-EFF-DATE-FROM                                        
C34569     MOVE WS-BI-CMPNT-ID-CD-FF (WS-BI-FF-INDX)                    
C34569       TO FF-CMPNT-ID-CD                                          
C34569     MOVE WS-BI-CODE-SEASON-FF (WS-BI-FF-INDX)                    
C34569       TO FF-CODE-SEASON                                          
C34569     MOVE WS-BI-INSTR-USE-TYPE-CD-FF (WS-BI-FF-INDX)              
C34569       TO FF-INSTR-USE-TYPE-CD                                    
C34569     MOVE WS-BI-CODE-TIME-PERIOD-FF (WS-BI-FF-INDX)               
C34569       TO FF-CODE-TIME-PERIOD                                     
C34569     MOVE WS-BI-EFF-DATE-TO-FF (WS-BI-FF-INDX)                    
C34569       TO FF-EFF-DATE-TO                                          
C34569     MOVE WS-BI-FIXED-FCTR-TYP-CD-FF (WS-BI-FF-INDX)              
C34569       TO FF-FIXED-FCTR-TYP-CD                                    
C34569     MOVE WS-BI-FACTOR-FF (WS-BI-FF-INDX)                         
C34569       TO FF-FACTOR                                               
C34569     MOVE WS-BI-FAC-CHRG-BASE-AM-FF (WS-BI-FF-INDX)               
C34569       TO FF-FAC-CHRG-BASE-AM                                     
C34569     MOVE WS-BI-LAST-UPDATE-TS-FF (WS-BI-FF-INDX)                 
C34569       TO FF-LAST-UPDATE-TS                                       
C34569     MOVE WS-BI-DURATION-REMAIN-NO-FF (WS-BI-FF-INDX)             
C34569       TO FF-DURATION-REMAIN-NO                                   
C34569     MOVE WS-BI-RT-PKG-OPT-SEQ-NO-FF (WS-BI-FF-INDX)              
C34569       TO FF-RT-PKG-OPT-SEQ-NO.                                   
P00165     MOVE WS-BI-BLOCK-NO-FF (WS-BI-FF-INDX)                       
P00165       TO FF-BLOCK-NO.                                            
C34569*                                                                         
C34569 2235-EXIT.                                                       
C34569     EXIT.                                                        
C34569/                                                                         
C34569 2236-PROCESS-ACCT-ATTR.                                          
C34569     MOVE WS-ACCOUNT-NO-YP (WS-ATTR-INDX)                         
C34569       TO YP-ACCOUNT-NO                                           
C34569     MOVE WS-ATTRIBUTE-DESC-YP (WS-ATTR-INDX)                     
C34569       TO YP-ATTRIBUTE-DESC                                       
C34569     MOVE WS-ATTRIBUTE-VALUE-CD-YP (WS-ATTR-INDX)                 
C34569       TO YP-ATTRIBUTE-VALUE-CD                                   
C34569     MOVE WS-ATTRIBUTE-VALUE-DT-YP (WS-ATTR-INDX)                 
C34569       TO YP-ATTRIBUTE-VALUE-DT                                   
C34569     MOVE WS-ATTRIBUTE-VALUE-TX-YP (WS-ATTR-INDX)                 
C34569       TO YP-ATTRIBUTE-VALUE-TX                                   
C34569     MOVE WS-CREATED-TS-YP (WS-ATTR-INDX)                         
C34569       TO YP-CREATED-TS                                           
C34569     MOVE WS-STATUS-CD-YP (WS-ATTR-INDX)                          
C34569       TO YP-STATUS-CD.                                           
C34569*                                                                         
C34569 2236-EXIT.                                                       
C34569     EXIT.                                                        
C34569/                                                                         
C34569 2237-PROCESS-MKT-TIER.                                           
C34569     MOVE WS-ACCOUNT-NO-DD (WS-TIER-INDX)                         
C34569       TO DD-ACCOUNT-NO                                           
C34569     MOVE WS-TIER-CUST-STAT-CD-DD (WS-TIER-INDX)                  
C34569       TO DD-TIER-CUST-STAT-CD                                    
C34569     MOVE WS-TIER-ACCT-TYPE-CD-DD (WS-TIER-INDX)                  
C34569       TO DD-TIER-ACCT-TYPE-CD                                    
C34569     MOVE WS-MKT-TIER-RANKING-DD (WS-TIER-INDX)                   
C34569       TO DD-MKT-TIER-RANKING                                     
C34569     MOVE WS-MKT-TIER-START-DT-DD (WS-TIER-INDX)                  
C34569       TO DD-MKT-TIER-START-DT                                    
C34569     MOVE WS-COMPANY-NO-DD (WS-TIER-INDX)                         
C34569       TO DD-COMPANY-NO                                           
C34569     MOVE WS-CREATED-TS-DD (WS-TIER-INDX)                         
C34569       TO DD-CREATED-TS                                           
C34569     MOVE WS-LAST-UPDATE-USERID-DD (WS-TIER-INDX)                 
C34569       TO DD-LAST-UPDATE-USERID                                   
C34569     MOVE WS-EFF-START-DT-DD (WS-TIER-INDX)                       
C34569       TO DD-EFF-START-DT                                         
C34569     MOVE WS-LAST-UPDATE-TS-DD (WS-TIER-INDX)                     
C34569       TO DD-LAST-UPDATE-TS                                       
C34569     MOVE WS-LAST-EVALUATED-DT-DD (WS-TIER-INDX)                  
C34569       TO DD-LAST-EVALUATED-DT                                    
C34569     MOVE WS-TIER-SOURCE-CD-DD (WS-TIER-INDX)                     
C34569       TO DD-TIER-SOURCE-CD                                       
C34569     MOVE WS-ADJ-TIER-SEQ-NO-DD (WS-TIER-INDX)                    
C34569       TO DD-ADJ-TIER-SEQ-NO.                                     
C34569*                                                                         
C34569 2237-EXIT.                                                       
C34569     EXIT.                                                        
C34569/                                                                         
C34569 2238-PROCESS-RTPK-AGR.                                           
C34569     MOVE WS-ACCOUNT-NO-DF (WS-RTPK-INDX)                         
C34569       TO DF-ACCOUNT-NO                                           
C34569     MOVE WS-CODE-UTIL-TYPE-DF (WS-RTPK-INDX)                     
C34569       TO DF-CODE-UTIL-TYPE                                       
C34569     MOVE WS-IC-NO-DF (WS-RTPK-INDX)                              
C34569       TO DF-IC-NO                                                
C34569     MOVE WS-RT-PKG-OPT-SEQ-NO-DF (WS-RTPK-INDX)                  
C34569       TO DF-RT-PKG-OPT-SEQ-NO                                    
C34569     MOVE WS-TRANS-SEQ-ID-DF (WS-RTPK-INDX)                       
C34569       TO DF-TRANS-SEQ-ID                                         
C34569     MOVE WS-OFFER-CD-DF (WS-RTPK-INDX)                           
C34569       TO DF-OFFER-CD                                             
C34569     MOVE WS-OPTION-CD-DF (WS-RTPK-INDX)                          
C34569       TO DF-OPTION-CD                                            
C34569     MOVE WS-PROMO-CD-DF (WS-RTPK-INDX)                           
C34569       TO DF-PROMO-CD                                             
C34569     MOVE WS-STATUS-CD-DF (WS-RTPK-INDX)                          
C34569       TO DF-STATUS-CD                                            
C34569     MOVE WS-COMM-CHANNEL-DF (WS-RTPK-INDX)                       
C34569       TO DF-COMM-CHANNEL                                         
C34569     MOVE WS-CREATED-USERID-DF (WS-RTPK-INDX)                     
C34569       TO DF-CREATED-USERID                                       
P00892     MOVE 'SYSTEM'                                                
P00892       TO WS-LAST-UPDATE-USERID-DF (WS-RTPK-INDX)                 
C34569     MOVE WS-LAST-UPDATE-USERID-DF (WS-RTPK-INDX)                 
C34569       TO DF-LAST-UPDATE-USERID                                   
C34569     MOVE WS-OPT-AGRMT-EFF-DT-DF (WS-RTPK-INDX)                   
C34569       TO DF-OPT-AGRMT-EFF-DT                                     
C34569     MOVE WS-OPT-AGRMT-EFF-TM-DF (WS-RTPK-INDX)                   
C34569       TO DF-OPT-AGRMT-EFF-TM                                     
C34569     MOVE WS-CREATED-TS-DF (WS-RTPK-INDX)                         
C34569       TO DF-CREATED-TS                                           
C34569     MOVE WS-LAST-UPDATE-TS-DF (WS-RTPK-INDX)                     
C34569       TO DF-LAST-UPDATE-TS                                       
C34569     MOVE WS-COMPANY-NO-DF (WS-RTPK-INDX)                         
C34569       TO DF-COMPANY-NO                                           
C34569     MOVE WS-STATUS-EFF-REV-MTH-DF (WS-RTPK-INDX)                 
C34569       TO DF-STATUS-EFF-REV-MTH                                   
C34569     MOVE WS-AGREEMNT-SOURCE-CD-DF (WS-RTPK-INDX)                 
C34569       TO DF-AGREEMNT-SOURCE-CD                                   
C34569     MOVE WS-ADJ-TIER-SEQ-NO-DF (WS-RTPK-INDX)                    
C34569       TO DF-ADJ-TIER-SEQ-NO.                                     
P00680     MOVE WS-STAT-ADJUSTABLE-CD-DF (WS-RTPK-INDX)                 
P00680       TO DF-STAT-ADJUSTABLE-CD.                                  
ACT004     MOVE WS-STATUS-CHANGE-DT-DF   (WS-RTPK-INDX)                 
ACT004       TO DF-STATUS-CHANGE-DT.                                    
C34569*                                                                         
C34569 2238-EXIT.                                                       
C34569     EXIT.                                                        
                                                                        
P00892******************************************************************        
P00892*  MNT TRANSACTION OF RTPKG STATUS CHANGE                        *        
P00892******************************************************************        
P00892 2239-RTPKG-STATUS-CHNG-MNT.                                      
P00892     PERFORM 7300-GET-TIMESTAMP  THRU 7300-EXIT.                  
P00892     MOVE DF-ACCOUNT-NO          TO MH-ACCOUNT-NO.                
P00892     MOVE LS-INPUT-DATE          TO MH-DATE-TRANS.                
P00892     MOVE WS-MAINT-TRAN-TYPE     TO MH-CODE-TRAN-TYPE.            
P00892     MOVE SPACES                 TO MH-RESP-AREA-ID.              
P00892     MOVE 0                      TO MH-CUSTOMER-NO.               
P00892     MOVE 0                      TO MH-PREMISE-NO.                
P00892     MOVE WS-SYSTEM              TO MH-USER-ID.                   
P00892     MOVE WS-PGRMNAME            TO MH-APPL-PROGRAM-ID.           
P00892     MOVE 'Rate Package status changed to Open for Renewal'       
P00892                                 TO MH-TRAN-COMMENT-TEXT.         
P00892     MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
P00892                                 TO MH-TRAN-COMMENT-LEN.          
P00892                                                                  
P00892     PERFORM 8860-INSERT-MNT-TRANS-HIST THRU 8860-EXIT.           
P00892                                                                  
P00892**---INSERT INTO CSS_ACCT_RATE_HIST                                       
P00892     MOVE DF-ACCOUNT-NO          TO 5H-ACCOUNT-NO.                
P00892     MOVE DF-CODE-UTIL-TYPE      TO 5H-CODE-UTIL-TYPE.            
P00892     MOVE DF-IC-NO               TO 5H-IC-NO.                     
P00892     MOVE DF-RT-PKG-OPT-SEQ-NO   TO 5H-RT-PKG-OPT-SEQ-NO.         
P00892     MOVE MH-TRANS-HIST-SEQ-NO   TO 5H-TRANS-HIST-SEQ-NO.         
P00892     PERFORM 8861-INSERT-ACCT-RATE-HIST THRU 8861-EXIT.           
P00892                                                                  
P00892**---DF-STATUS =  'A'PPLIED -----                                         
P00892     MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO.         
P00892     MOVE 'STATUS_CD'            TO MI-COLUMN-DESC.               
P00892     MOVE 'DF'                   TO MI-TABLE-ID.                  
P00892     MOVE +1                     TO WS-TRAN-APPL-NO.              
P00892     MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO.              
P00892     MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN       
P00892                                    MI-CHG-COLUMN-VALUE-LEN.      
P00892     MOVE 'A'                    TO MI-PRV-COLUMN-VALUE-TEXT.     
P00892     MOVE DF-STATUS-CD           TO MI-CHG-COLUMN-VALUE-TEXT.     
P00892     PERFORM 8865-INSERT-MT-TRN-HST-DET THRU 8865-EXIT.           
P00892                                                                  
P00892**---OFFER_CD                                                             
P00892     MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO.         
P00892     MOVE 'OFFER_CD'             TO MI-COLUMN-DESC.               
P00892     MOVE 'FG'                   TO MI-TABLE-ID.                  
P00892     ADD  +1                     TO WS-TRAN-APPL-NO.              
P00892     MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO.              
P00892     MOVE DF-OFFER-CD            TO MI-PRV-COLUMN-VALUE-TEXT      
P00892     MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
P00892                                 TO MI-PRV-COLUMN-VALUE-LEN       
P00892     MOVE DF-OFFER-CD            TO MI-CHG-COLUMN-VALUE-TEXT      
P00892     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
P00892                                 TO MI-CHG-COLUMN-VALUE-LEN       
P00892     PERFORM 8865-INSERT-MT-TRN-HST-DET THRU 8865-EXIT.           
P00892                                                                  
P00892**---OPTION_CD                                                            
P00892     MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO.         
P00892     MOVE 'OPTION_CD'            TO MI-COLUMN-DESC.               
P00892     MOVE 'FI'                   TO MI-TABLE-ID.                  
P00892     ADD  +1                     TO WS-TRAN-APPL-NO.              
P00892     MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO.              
P00892     MOVE DF-OPTION-CD           TO MI-PRV-COLUMN-VALUE-TEXT      
P00892     MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
P00892                                 TO MI-PRV-COLUMN-VALUE-LEN       
P00892     MOVE DF-OPTION-CD           TO MI-CHG-COLUMN-VALUE-TEXT      
P00892     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
P00892                                 TO MI-CHG-COLUMN-VALUE-LEN       
P00892     PERFORM 8865-INSERT-MT-TRN-HST-DET THRU 8865-EXIT.           
P00892                                                                  
P00892**---RT_PKG_OPT_SEQ_NO'                                                   
P00892     MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO.         
P00892     MOVE 'RT_PKG_OPT_SEQ#'      TO MI-COLUMN-DESC.               
P00892     MOVE SPACES                 TO MI-TABLE-ID.                  
P00892     ADD  +1                     TO WS-TRAN-APPL-NO.              
P00892     MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO.              
P00892     MOVE DF-RT-PKG-OPT-SEQ-NO   TO MI-PRV-COLUMN-VALUE-TEXT      
P00892     MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
P00892                                 TO MI-PRV-COLUMN-VALUE-LEN       
P00892     MOVE DF-RT-PKG-OPT-SEQ-NO   TO MI-CHG-COLUMN-VALUE-TEXT      
P00892     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
P00892                                 TO MI-CHG-COLUMN-VALUE-LEN       
P00892     PERFORM 8865-INSERT-MT-TRN-HST-DET THRU 8865-EXIT.           
P00892                                                                  
P00892 2239-EXIT.                                                       
P00892     EXIT.                                                        
      /                                                                         
       2240-PROCESS-CALC-RESULTS.                                       
      **                                                                        
           MOVE WS-ACCOUNT-NO-BC (WS-CALC-INDX)                         
             TO BZ-ACCOUNT-NO                                           
           MOVE WS-BILL-NO-BC (WS-CALC-INDX)                            
             TO BZ-BILL-NO                                              
           MOVE WS-CODE-UTIL-TYPE-BC (WS-CALC-INDX)                     
             TO BZ-CODE-UTIL-TYPE                                       
           MOVE WS-IC-NO-BC (WS-CALC-INDX)                              
             TO BZ-IC-NO                                                
           MOVE WS-BILL-ITEM-TIMESTMP-BC (WS-CALC-INDX)                 
             TO BZ-BILL-ITEM-TIMESTMP                                   
                                                                        
           IF WS-CODE-UTIL-TYPE-BC (WS-CALC-INDX) = 'U'                 
              MOVE WS-COMPONENT-CODE-BC (WS-CALC-INDX) (2:2)            
                TO BZ-CMPNT-ID-CD                                       
           ELSE                                                         
              MOVE WS-COMPONENT-CODE-BC (WS-CALC-INDX) (1:2)            
                TO BZ-CMPNT-ID-CD                                       
           END-IF                                                       
                                                                        
DC         IF WS-CONSUMPTION-TYPE-BC (WS-CALC-INDX) = 'E' OR            
DC            WS-CONSUMPTION-TYPE-BC (WS-CALC-INDX) = 'J' OR            
DC            WS-CONSUMPTION-TYPE-BC (WS-CALC-INDX) = 'Q'               
DC               MOVE 'D'                   TO BZ-INSTR-USE-TYPE-CD     
DC         ELSE                                                         
DC               MOVE 'R'                   TO BZ-INSTR-USE-TYPE-CD
           END-IF.    
           MOVE WS-CODE-TOU-BC (WS-CALC-INDX)                           
             TO BZ-CODE-TIME-PERIOD                                     
           MOVE WS-CODE-SEASON-BC (WS-CALC-INDX)                        
             TO BZ-CODE-SEASON                                          
           MOVE WS-CONSUMPTION-TYPE-BC (WS-CALC-INDX)                   
             TO BZ-CONSUMPT-TYPE-CD                                     
      *                                                                         
           PERFORM 7600-GET-BZ THRU 7600-EXIT.                          
      *                                                                         
           IF WS-CONSUMPTION-TYPE-BC (WS-CALC-INDX) = 'E' OR            
                 WS-CONSUMPTION-TYPE-BC (WS-CALC-INDX) = 'J'            
      *                                                                         
              IF WS-READ-UNITS-BC (WS-CALC-INDX) > BZ-READ-UNITS        
                   MOVE WS-READ-UNITS-BC (WS-CALC-INDX)                 
                         TO BZ-READ-UNITS                               
C31332         END-IF                                                   
C31332         IF WS-NET-UNITS-BC (WS-CALC-INDX) > BZ-BILL-UNITS        
                  MOVE WS-NET-UNITS-BC (WS-CALC-INDX)                   
                         TO BZ-BILL-UNITS                               
C31332         END-IF                                                   
           ELSE                                                         
              ADD WS-READ-UNITS-BC (WS-CALC-INDX)                       
                TO BZ-READ-UNITS                                        
              ADD WS-NET-UNITS-BC (WS-CALC-INDX)                        
                TO BZ-BILL-UNITS                                        
           END-IF                                                       
                                                                        
           MOVE WS-NET-UNIT-SEL-RSN-BC (WS-CALC-INDX)                   
             TO BZ-NET-UNIT-SEL-RSN                                     
           ADD WS-CALC-COMPONENT-AMT-BC (WS-CALC-INDX)                  
             TO BZ-CALC-COMP-AM                                         
T23301     ADD WS-TOTAL-WNA-AMT-BC (WS-CALC-INDX)                       
T23301       TO BZ-WNA-COMP-AM                                          
CIG        MOVE WS-AMT-NET-RATE-BC (WS-CALC-INDX,1)                     
CIG          TO BZ-UNIT-PRICE-AM                                        
           ADD WS-NET-COMPONENT-AMT-BC (WS-CALC-INDX)                   
             TO BZ-BILLED-COMP-AM.                                      
           IF SQLCODE = SUCCESSFUL-CALL                                 
              PERFORM 8160-UPDATE-BILL-CALC-DET THRU 8160-EXIT          
           ELSE                                                         
              PERFORM 8150-INSERT-BILL-CALC-DET THRU 8150-EXIT          
           END-IF.                                                      
      *                                                                         
       2240-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       2250-PROCESS-CONTRACT-HIST.                                      
           MOVE WS-ACCOUNT-NO-BX (WS-BX-INDX)      TO BX-ACCOUNT-NO     
           MOVE WS-BILL-NO-BX (WS-BX-INDX)         TO BX-BILL-NO        
           MOVE WS-CODE-UTIL-TYPE-BX (WS-BX-INDX)  TO BX-CODE-UTIL-TYPE 
           MOVE WS-IC-NO-BX (WS-BX-INDX)           TO BX-IC-NO          
           MOVE WS-BILL-ITEM-TIMESTMP-BX (WS-BX-INDX)                   
             TO BX-BILL-ITEM-TIMESTMP                                   
      *                                                                         
           MOVE WS-CNTRCT-START-DT-BX (WS-BX-INDX)                      
             TO BX-CNTRCT-START-DT                                      
           MOVE WS-CNTRCT-END-DT-BX (WS-BX-INDX)                        
             TO BX-CNTRCT-END-DT                                        
           MOVE WS-SPCL-MO-MIN-AM-BX (WS-BX-INDX)                       
             TO BX-SPCL-MO-MIN-AM                                       
                                                                        
           MOVE WS-SPCL-ANN-MIN-AM-BX (WS-BX-INDX)                      
             TO BX-SPCL-ANN-MIN-AM                                      
           MOVE WS-ANN-MIN-TYPE-CD-BX (WS-BX-INDX)                      
             TO BX-ANN-MIN-TYPE-CD                                      
                                                                        
           MOVE WS-CBL-REF-RATE-PLN-BX (WS-BX-INDX)                     
             TO BX-CBL-REF-RATE-PLN                                     
           MOVE WS-COMP-RATE-PLAN-BX (WS-BX-INDX)                       
             TO BX-COMP-RATE-PLAN                                       
           MOVE WS-COMPARE-TYPE-CD-BX (WS-BX-INDX)                      
             TO BX-COMPARE-TYPE-CD                                      
                                                                        
           MOVE WS-DEM-CNSLDTN-CD-BX (WS-BX-INDX)                       
             TO BX-DEM-CNSLDTN-CD                                       
           MOVE WS-DFLT-USAGE-CLS-CD-BX (WS-BX-INDX)                    
             TO BX-DFLT-USAGE-CLS-CD                                    
                                                                        
           MOVE WS-CANCEL-CHRG-AM-BX (WS-BX-INDX)                       
             TO BX-CANCEL-CHRG-AM                                       
                                                                        
           MOVE WS-CONTRACT-STDBY-DEM-BX (WS-BX-INDX)                   
             TO BX-CONTRACT-STDBY-DEM                                   
           MOVE WS-CONTRACT-DEMAND-BX (WS-BX-INDX)                      
             TO BX-CONTRACT-DEMAND                                      
           MOVE WS-BUILD-UP-MONTHS-BX (WS-BX-INDX)                      
             TO BX-BUILD-UP-MONTHS                                      
                                                                        
           MOVE WS-STDBY-LIMIT-HRS-BX (WS-BX-INDX)                      
             TO BX-STDBY-LIMIT-HRS                                      
           MOVE WS-STDBY-LIMIT-PK-HRS-BX (WS-BX-INDX)                   
             TO BX-STDBY-LIMIT-PK-HRS                                   
           MOVE WS-STDBY-YTD-PK-HRS-BX (WS-BX-INDX)                     
             TO BX-STDBY-YTD-PK-HRS                                     
           MOVE WS-STDBY-YTD-HRS-BX (WS-BX-INDX)                        
             TO BX-STDBY-YTD-HRS                                        
           MOVE WS-STDBY-RESET-MTH-BX (WS-BX-INDX)                      
             TO BX-STDBY-RESET-MTH                                      
                                                                        
           MOVE WS-MAX-ECON-DEM-BX (WS-BX-INDX)                         
             TO BX-MAX-ECON-DEM                                         
           MOVE WS-CONTRACT-ECON-DEM-BX (WS-BX-INDX)                    
             TO BX-CONTRACT-ECON-DEM                                    
           MOVE WS-FIRM-PER-HR-KWH-BX (WS-BX-INDX)                      
             TO BX-FIRM-PER-HR-KWH                                      
T25762     MOVE WS-VERS-PRORATE-CD-BX (WS-BX-INDX)                      
T25762       TO BX-VERS-PRORATE-CD                                      
                                                                        
T23631     MOVE WS-ALT-SPLY-RATE-NO-BX (WS-BX-INDX)                     
T23631       TO BX-ALT-SPLY-RATE-NO                                     
T23631     MOVE WS-ALT-SPLY-REV-CL-CD-BX (WS-BX-INDX)                   
T23631       TO BX-ALT-SPLY-REV-CL-CD                                   
T23631     MOVE WS-ALTERNATE-FUEL-CD-BX (WS-BX-INDX)                    
T23631       TO BX-ALTERNATE-FUEL-CD                                    
T23631     MOVE WS-ALTN-FUEL-SPLY-CD-BX (WS-BX-INDX)                    
T23631       TO BX-ALTN-FUEL-SPLY-CD                                    
T23631     MOVE WS-FUEL-SHIPPER-CD-BX (WS-BX-INDX)                      
T23631       TO BX-FUEL-SHIPPER-CD                                      
CIG        MOVE WS-ANN-REVIEW-MONTH-BX (WS-BX-INDX)                     
CIG          TO BX-ANN-REVIEW-MONTH                                     
CIG        MOVE WS-CONTRACT-TERM-CD-BX (WS-BX-INDX)                     
CIG          TO BX-CONTRACT-TERM-CD                                     
           .                                                            
       2250-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       2260-PROCESS-MN-UPDATES.                                         
           MOVE WS-ACCOUNT-NO-MN (WS-MTRD-INDX)                         
             TO MN-ACCOUNT-NO                                           
           MOVE WS-CODE-UTIL-TYPE-MN (WS-MTRD-INDX)                     
             TO MN-CODE-UTIL-TYPE                                       
           MOVE WS-IC-NO-MN (WS-MTRD-INDX)                              
             TO MN-IC-NO                                                
           MOVE WS-MTR-REF-NO-MN (WS-MTRD-INDX)                         
             TO MN-MTR-REF-NO                                           
           MOVE WS-CODE-TIME-PERIOD-MN (WS-MTRD-INDX)                   
             TO MN-CODE-TIME-PERIOD                                     
           MOVE WS-METER-NO-MN (WS-MTRD-INDX)                           
             TO MN-METER-NO                                             
           MOVE WS-CODE-DISCOUNT-MN (WS-MTRD-INDX)                      
             TO MN-CODE-DISCOUNT                                        
           MOVE WS-CODE-METER-LOC-MN (WS-MTRD-INDX)                     
             TO MN-CODE-METER-LOC                                       
           MOVE WS-CODE-METER-STATUS-MN (WS-MTRD-INDX)                  
             TO MN-CODE-METER-STATUS                                    
           MOVE WS-CODE-STATUS-REAS-MN (WS-MTRD-INDX)                   
             TO MN-CODE-STATUS-REAS                                     
           MOVE WS-CODE-ALRT-CHNG-IND-MN (WS-MTRD-INDX)                 
             TO MN-CODE-ALRT-CHNG-IND                                   
           MOVE WS-DIST-NODE-POINT-MN (WS-MTRD-INDX)                    
             TO MN-DIST-NODE-POINT                                      
           MOVE WS-CODE-DIVERSION-MN (WS-MTRD-INDX)                     
             TO MN-CODE-DIVERSION                                       
           MOVE WS-DATE-MTR-INSTALL-MN (WS-MTRD-INDX)                   
             TO MN-DATE-MTR-INSTALL                                     
           MOVE WS-CODE-SPCL-SEAL-MN (WS-MTRD-INDX)                     
             TO MN-CODE-SPCL-SEAL                                       
           MOVE WS-EST-USAGE-MN (WS-MTRD-INDX)                          
             TO MN-EST-USAGE                                            
           MOVE WS-SPCL-MTR-CONDITION-MN (WS-MTRD-INDX)                 
             TO MN-SPCL-MTR-CONDITION                                   
           MOVE WS-CODE-DATA-PRESENT-MN (WS-MTRD-INDX)                  
             TO MN-CODE-DATA-PRESENT                                    
           MOVE WS-CODE-USAGE-TYPE-MN (WS-MTRD-INDX)                    
             TO MN-CODE-USAGE-TYPE                                      
           MOVE WS-CODE-USAGE-ID-MN (WS-MTRD-INDX)                      
             TO MN-CODE-USAGE-ID                                        
           MOVE WS-CODE-USAGE-SOURCE-MN (WS-MTRD-INDX)                  
             TO MN-CODE-USAGE-SOURCE                                    
           MOVE WS-REG-ID-NO-MN (WS-MTRD-INDX)                          
             TO MN-REG-ID-NO                                            
           MOVE WS-REGISTER-RD-SEQ-MN (WS-MTRD-INDX)                    
             TO MN-REGISTER-RD-SEQ                                      
           MOVE WS-CODE-CRNT-REG-READ-MN (WS-MTRD-INDX)                 
             TO MN-CODE-CRNT-REG-READ                                   
           MOVE WS-CODE-NO-RD-REASON-MN (WS-MTRD-INDX)                  
             TO MN-CODE-NO-RD-REASON                                    
           MOVE WS-CODE-LAST-REG-READ-MN (WS-MTRD-INDX)                 
             TO MN-CODE-LAST-REG-READ                                   
           MOVE WS-LAST-REG-READ-DATE-MN (WS-MTRD-INDX)                 
             TO MN-LAST-REG-READ-DATE                                   
           MOVE WS-LAST-REG-READ-TIME-MN (WS-MTRD-INDX)                 
             TO MN-LAST-REG-READ-TIME                                   
           MOVE WS-LAST-READ-VALUE-MN (WS-MTRD-INDX)                    
             TO MN-LAST-READ-VALUE                                      
           MOVE WS-NO-CONSEC-ESTIMATE-MN (WS-MTRD-INDX)                 
             TO MN-NO-CONSEC-ESTIMATE                                   
           MOVE WS-NO-CONSEC-CRD-READ-MN (WS-MTRD-INDX)                 
             TO MN-NO-CONSEC-CRD-READ                                   
           MOVE WS-POINT-ID-MN (WS-MTRD-INDX)                           
             TO MN-POINT-ID                                             
           MOVE WS-LOCK-TYPE-ID-MN (WS-MTRD-INDX)                       
             TO MN-LOCK-TYPE-ID                                         
           MOVE WS-SEAL-CODE-ID-MN (WS-MTRD-INDX)                       
             TO MN-SEAL-CODE-ID                                         
           MOVE WS-HEXAGRAM-LOCATION-MN (WS-MTRD-INDX)                  
             TO MN-HEXAGRAM-LOCATION                                    
           MOVE WS-INSULATED-IND-MN (WS-MTRD-INDX)                      
             TO MN-INSULATED-IND                                        
           MOVE WS-METER-SUPPLYING-MN (WS-MTRD-INDX)                    
             TO MN-METER-SUPPLYING                                      
           MOVE WS-LAST-VALID-READ-DT-MN (WS-MTRD-INDX)                 
             TO MN-LAST-VALID-READ-DT                                   
           MOVE WS-LAST-VALID-READ-TM-MN (WS-MTRD-INDX)                 
             TO MN-LAST-VALID-READ-TM                                   
           MOVE WS-READ-CARD-PRINT-DT-MN (WS-MTRD-INDX)                 
             TO MN-READ-CARD-PRINT-DT                                   
           MOVE WS-EXCEPT-OVERRIDE-CD-MN (WS-MTRD-INDX)                 
             TO MN-EXCEPT-OVERRIDE-CD                                   
           MOVE WS-CODE-MTR-RD-INST1-MN (WS-MTRD-INDX)                  
             TO MN-CODE-MTR-RD-INST1                                    
           MOVE WS-CODE-MTR-RD-INST2-MN (WS-MTRD-INDX)                  
             TO MN-CODE-MTR-RD-INST2                                    
           MOVE WS-CODE-MTR-RD-INST3-MN (WS-MTRD-INDX)                  
             TO MN-CODE-MTR-RD-INST3                                    
           MOVE WS-DIGTL-MTR-TYPE-MN (WS-MTRD-INDX)                     
             TO MN-DIGTL-MTR-TYPE.                                      
           MOVE WS-REMOTE-READ-IND-MN (WS-MTRD-INDX)                    
             TO MN-REMOTE-READ-IND                                      
           MOVE WS-LAST-UPDATE-TS-MN (WS-MTRD-INDX)                     
             TO MN-LAST-UPDATE-TS                                       
           MOVE WS-LAST-VAL-RD-VALUE-MN (WS-MTRD-INDX)                  
             TO MN-LAST-VAL-RD-VALUE.                                   
           MOVE WS-IDR-RECIPIENT-CD-MN (WS-MTRD-INDX)                   
             TO MN-IDR-RECIPIENT-CD                                     
           MOVE WS-MTR-READ-SOURCE-CD-MN (WS-MTRD-INDX)                 
             TO MN-MTR-READ-SOURCE-CD.                                  
           MOVE WS-CODE-LAST-VALID-RD-MN (WS-MTRD-INDX)                 
             TO MN-CODE-LAST-VALID-RD                                   
           MOVE WS-MTR-STATUS-CHNG-DT-MN (WS-MTRD-INDX)                 
             TO MN-MTR-STATUS-CHNG-DT.                                  
                                                                        
       2260-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       2270-PROCESS-RG-UPDATES.                                         
           MOVE WS-ACCOUNT-NO-RG (WS-REG-RD-INDX)                       
             TO RG-ACCOUNT-NO                                           
           MOVE WS-CODE-UTIL-TYPE-RG (WS-REG-RD-INDX)                   
             TO RG-CODE-UTIL-TYPE                                       
           MOVE WS-IC-NO-RG (WS-REG-RD-INDX)                            
             TO RG-IC-NO                                                
           MOVE WS-MTR-REF-NO-RG (WS-REG-RD-INDX)                       
             TO RG-MTR-REF-NO                                           
           MOVE WS-REG-ID-NO-RG (WS-REG-RD-INDX)                        
             TO RG-REG-ID-NO                                            
           MOVE WS-METER-NO-RG (WS-REG-RD-INDX)                         
             TO RG-METER-NO                                             
           MOVE WS-CODE-USAGE-TYPE-RG (WS-REG-RD-INDX)                  
             TO RG-CODE-USAGE-TYPE                                      
           MOVE WS-CODE-USAGE-ID-RG (WS-REG-RD-INDX)                    
             TO RG-CODE-USAGE-ID                                        
           MOVE WS-CODE-USAGE-SOURCE-RG (WS-REG-RD-INDX)                
             TO RG-CODE-USAGE-SOURCE                                    
           MOVE WS-CODE-TIME-PERIOD-RG (WS-REG-RD-INDX)                 
             TO RG-CODE-TIME-PERIOD                                     
           MOVE WS-REGISTER-RD-SEQ-RG (WS-REG-RD-INDX)                  
             TO RG-REGISTER-RD-SEQ                                      
           MOVE WS-CODE-REG-STATUS-RG (WS-REG-RD-INDX)                  
             TO RG-CODE-REG-STATUS                                      
           MOVE WS-CODE-STATUS-REAS-RG (WS-REG-RD-INDX)                 
             TO RG-CODE-STATUS-REAS                                     
           MOVE WS-CODE-LAST-REG-READ-RG (WS-REG-RD-INDX)               
             TO RG-CODE-LAST-REG-READ                                   
           MOVE WS-LAST-REG-READ-DT-RG (WS-REG-RD-INDX)                 
             TO RG-LAST-REG-READ-DT                                     
           MOVE WS-LAST-REG-READ-TM-RG (WS-REG-RD-INDX)                 
             TO RG-LAST-REG-READ-TM                                     
           MOVE WS-LAST-READ-VALUE-RG (WS-REG-RD-INDX)                  
             TO RG-LAST-READ-VALUE                                      
           MOVE WS-NEXT-READ-MONTH-RG (WS-REG-RD-INDX)                  
             TO RG-NEXT-READ-MONTH                                      
           MOVE WS-CODE-CRNT-REG-READ-RG (WS-REG-RD-INDX)               
             TO RG-CODE-CRNT-REG-READ                                   
           MOVE WS-CODE-NO-RD-REASON-RG (WS-REG-RD-INDX)                
             TO RG-CODE-NO-RD-REASON                                    
           MOVE WS-CODE-LAST-VALID-RD-RG (WS-REG-RD-INDX)               
             TO RG-CODE-LAST-VALID-RD                                   
           MOVE WS-LAST-VALID-READ-DT-RG (WS-REG-RD-INDX)               
             TO RG-LAST-VALID-READ-DT                                   
           MOVE WS-LAST-VALID-READ-TM-RG (WS-REG-RD-INDX)               
             TO RG-LAST-VALID-READ-TM                                   
           MOVE WS-LAST-VAL-RD-VALUE-RG (WS-REG-RD-INDX)                
             TO RG-LAST-VAL-RD-VALUE                                    
           MOVE WS-SEASONAL-USE-CD-RG (WS-REG-RD-INDX)                  
             TO RG-SEASONAL-USE-CD                                      
           MOVE WS-LAST-UPDATE-TS-RG (WS-REG-RD-INDX)                   
             TO RG-LAST-UPDATE-TS.                                      
                                                                        
       2270-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       2280-PROCESS-UT-UPDATES.                                         
           MOVE WS-ACCOUNT-NO-UT (WS-UTIL-INDX)                         
             TO UT-ACCOUNT-NO                                           
           MOVE WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX)                     
             TO UT-CODE-UTIL-TYPE                                       
           MOVE WS-IC-NO-UT (WS-UTIL-INDX)                              
             TO UT-IC-NO                                                
                                                                        
           MOVE WS-CODE-ESTIMATE-OK-UT (WS-UTIL-INDX)                   
             TO UT-CODE-ESTIMATE-OK                                     
           MOVE WS-CODE-CURTAIL-PRTY-UT (WS-UTIL-INDX)                  
             TO UT-CODE-CURTAIL-PRTY                                    
           MOVE WS-CODE-REVENUE-CLASS-UT (WS-UTIL-INDX)                 
             TO UT-CODE-REVENUE-CLASS                                   
           MOVE WS-CODE-SERVICE-TYPE-UT (WS-UTIL-INDX)                  
             TO UT-CODE-SERVICE-TYPE                                    
           MOVE LS-INPUT-DATE                                           
             TO UT-DATE-LST-NRML-BILL                                   
           MOVE WS-RATE-PLAN-NO-UT (WS-UTIL-INDX)                       
             TO UT-RATE-PLAN-NO                                         
           MOVE WS-END-USER-PER-RATE-UT (WS-UTIL-INDX)                  
             TO UT-END-USER-PER-RATE                                    
           MOVE WS-DATE-INSTALL-UT (WS-UTIL-INDX)                       
             TO UT-DATE-INSTALL                                         
           MOVE WS-READ-CYCLE-UT (WS-UTIL-INDX)                         
             TO UT-READ-CYCLE                                           
           MOVE WS-READ-ROUTE-UT (WS-UTIL-INDX)                         
             TO UT-READ-ROUTE                                           
           MOVE WS-CODE-MTR-READ-FREQ-UT (WS-UTIL-INDX)                 
             TO UT-CODE-MTR-READ-FREQ                                   
           MOVE WS-CODE-SIC-NO-UT (WS-UTIL-INDX)                        
             TO UT-CODE-SIC-NO                                          
           MOVE WS-ENERGY-SOURCE-UT (WS-UTIL-INDX)                      
             TO UT-ENERGY-SOURCE                                        
           MOVE WS-SPLY-SENSITIVE-IND-UT (WS-UTIL-INDX)                 
             TO UT-SPLY-SENSITIVE-IND                                   
           MOVE WS-SEASONAL-USE-CODE-UT (WS-UTIL-INDX)                  
             TO UT-SEASONAL-USE-CODE                                    
           MOVE WS-COMPANY-NO-UT (WS-UTIL-INDX)                         
             TO UT-COMPANY-NO                                           
           MOVE WS-PRV-RATE-PLAN-NO-UT (WS-UTIL-INDX)                   
             TO UT-PRV-RATE-PLAN-NO                                     
           MOVE WS-CODE-STAT-TAX-XMT-UT (WS-UTIL-INDX)                  
             TO UT-CODE-STAT-TAX-XMT                                    
           MOVE WS-CODE-CITY-TAX-XMT-UT (WS-UTIL-INDX)                  
             TO UT-CODE-CITY-TAX-XMT                                    
           MOVE WS-CODE-OTHR-TAX-XMT-UT (WS-UTIL-INDX)                  
             TO UT-CODE-OTHR-TAX-XMT                                    
           MOVE WS-CODE-XCIS-TAX-XMT-UT (WS-UTIL-INDX)                  
             TO UT-CODE-XCIS-TAX-XMT                                    
           MOVE WS-STATE-TAX-EXMPT-NO-UT (WS-UTIL-INDX)                 
             TO UT-STATE-TAX-EXMPT-NO                                   
           MOVE WS-TOU-RATE-IND-UT (WS-UTIL-INDX)                       
             TO UT-TOU-RATE-IND                                         
           MOVE WS-GAS-BASE-LAST-UPDT-UT (WS-UTIL-INDX)                 
             TO UT-GAS-BASE-LAST-UPDT                                   
           MOVE WS-GAS-PREV-BASE-USE-UT (WS-UTIL-INDX)                  
             TO UT-GAS-PREV-BASE-USE                                    
           MOVE WS-GAS-BASE-USE-UT (WS-UTIL-INDX)                       
             TO UT-GAS-BASE-USE                                         
           MOVE WS-LAST-UPDATE-TS-UT (WS-UTIL-INDX)                     
             TO UT-LAST-UPDATE-TS                                       
           MOVE WS-AUTO-RATE-SW-FL-UT(WS-UTIL-INDX)                     
             TO UT-AUTO-RATE-SW-FL                                      
C33968     MOVE WS-NAICS-CD-UT (WS-UTIL-INDX) TO UT-NAICS-CD            
C34569     MOVE WS-RT-PKG-OPT-SEQ-NO-UT (WS-UTIL-INDX)                  
C34569       TO UT-RT-PKG-OPT-SEQ-NO                                    
           .                                                            
       2280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2290-PROCESS-CP-UPDATES.                                         
P00143     MOVE WS-LAST-BILL-DATE-CP (WS-CUST-PLAN-INDX)                
P00143       TO CP-LAST-BILL-DATE                                       
           MOVE WS-ACCOUNT-NO-CP (WS-CUST-PLAN-INDX) TO CP-ACCOUNT-NO   
           MOVE WS-IC-NO-CP (WS-CUST-PLAN-INDX)      TO CP-IC-NO        
           MOVE WS-CODE-UTIL-TYPE-CP (WS-CUST-PLAN-INDX)                
             TO CP-CODE-UTIL-TYPE                                       
           MOVE WS-RATE-ITEM-CODE-CP (WS-CUST-PLAN-INDX)                
             TO CP-RATE-ITEM-CODE                                       
           MOVE WS-ITEM-SEQ-NO-CP (WS-CUST-PLAN-INDX) TO CP-ITEM-SEQ-NO 
           .                                                            
       2290-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       2310-PROCESS-BK-UPDATES.                                         
           MOVE WS-ACCOUNT-NO-BK (WS-BK-INDX)                           
             TO BK-ACCOUNT-NO                                           
           MOVE WS-IC-NO-BK (WS-BK-INDX)                                
             TO BK-IC-NO                                                
           MOVE WS-CODE-UTIL-TYPE-BK (WS-BK-INDX)                       
             TO BK-CODE-UTIL-TYPE                                       
           MOVE WS-CNTRCT-START-DT-BK (WS-BK-INDX)                      
             TO BK-CNTRCT-START-DT                                      
T22570     SET WS-HOLD-INDX TO WS-BK-INDX                               
T22570     MOVE WS-BUILD-UP-MONTHS-BK (WS-BK-INDX) TO WS-BUILD-UP-CNT   
T22570     PERFORM VARYING WS-BK-INDX FROM 1 BY 1                       
T22570        UNTIL WS-BK-INDX > 20 OR                                  
T22570              WS-ACCOUNT-NO-BK (WS-BK-INDX) = ZERO                
T22570          IF WS-BUILD-UP-MONTHS-BK (WS-BK-INDX) < WS-BUILD-UP-CNT 
T22570             MOVE WS-BUILD-UP-MONTHS-BK (WS-BK-INDX)              
T22570                  TO WS-BUILD-UP-CNT                              
T22570          END-IF                                                  
T22570     END-PERFORM                                                  
T22570     MOVE WS-BUILD-UP-CNT TO BK-BUILD-UP-MONTHS                   
T22570     SET WS-BK-INDX TO WS-HOLD-INDX                               
           MOVE WS-DATE-LFTM-HI-DMD-BK (WS-BK-INDX)                     
             TO BK-DATE-LFTM-HI-DMD                                     
           MOVE WS-LFTM-HI-PEAK-DMD-BK (WS-BK-INDX)                     
             TO BK-LFTM-HI-PEAK-DMD                                     
      *    MOVE WS-STDBY-HOURS-YTD-BK (WS-BK-INDX)                              
      *      TO BK-STDBY-HOURS-YTD                                              
      *    MOVE WS-STDBY-PK-HRS-YTD-BK (WS-BK-INDX)                             
      *      TO BK-STDBY-PK-HRS-YTD                                             
           .                                                            
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2320-PROCESS-IP-UPDATES.                                         
           MOVE WS-STATUS-IP             TO IP-STATUS                   
           MOVE WS-NON-COMPLIANCE-CNT-IP TO IP-NON-COMPLIANCE-CNT       
           MOVE WS-ACCOUNT-NO-IP         TO IP-ACCOUNT-NO               
           MOVE WS-IC-NO-IP              TO IP-IC-NO                    
           MOVE WS-CODE-UTIL-TYPE-IP     TO IP-CODE-UTIL-TYPE           
           .                                                            
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2330-PROCESS-IR-UPDATES.                                         
           MOVE WS-NON-COMPLIANCE-IND-IR (WS-INTR-INDX)                 
             TO IR-NON-COMPLIANCE-IND                                   
           MOVE WS-ACCOUNT-NO-IR (WS-INTR-INDX)                         
             TO IR-ACCOUNT-NO                                           
           MOVE WS-IC-NO-IR (WS-INTR-INDX)                              
             TO IR-IC-NO                                                
           MOVE WS-CODE-UTIL-TYPE-IR (WS-INTR-INDX)                     
             TO IR-CODE-UTIL-TYPE                                       
           MOVE WS-INTERRUPT-DATE-IR (WS-INTR-INDX)                     
             TO IR-INTERRUPT-DATE                                       
           MOVE WS-INTERRUPT-TIME-OFF-IR (WS-INTR-INDX)                 
             TO IR-INTERRUPT-TIME-OFF                                   
           .                                                            
       2330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
T33924 2335-PROCESS-BP-UPDATES.                                         
                                                                        
T33924     MOVE WS-ACCOUNT-NO-BP(WS-ADJUSTMNT-INDEX)                    
T33924       TO BP-ACCOUNT-NO                                           
T33924     MOVE WS-BILL-NO-BP(WS-ADJUSTMNT-INDEX)                       
T33924       TO BP-BILL-NO                                              
T33924     MOVE WS-CODE-UTIL-TYPE-BP(WS-ADJUSTMNT-INDEX)                
T33924       TO BP-CODE-UTIL-TYPE                                       
T33924     MOVE WS-IC-NO-BP(WS-ADJUSTMNT-INDEX)                         
T33924       TO BP-IC-NO                                                
T33924     MOVE WS-BILL-ITEM-TIMESTMP-BP(WS-ADJUSTMNT-INDEX)            
T33924       TO BP-BILL-ITEM-TIMESTMP                                   
T33924     MOVE WS-ADJ-TYPE-CD-BP(WS-ADJUSTMNT-INDEX)                   
T33924       TO BP-ADJ-TYPE-CD                                          
T33924     MOVE WS-REVENUE-MONTH-BP(WS-ADJUSTMNT-INDEX)                 
T33924       TO BP-REVENUE-MONTH                                        
T33924     MOVE WS-ADJ-REASON-DESC-LEN-BP(WS-ADJUSTMNT-INDEX)           
T33924       TO BP-ADJ-REASON-DESC-LEN                                  
T33924     MOVE WS-ADJ-REASON-DESC-TEXT-BP(WS-ADJUSTMNT-INDEX)          
T33924       TO BP-ADJ-REASON-DESC-TEXT                                 
P00246     MOVE WS-OVRRIDE-RT-REV-MTH-BP(WS-ADJUSTMNT-INDEX)            
P00246       TO BP-OVRRIDE-RT-REV-MTH                                   
P00246     MOVE WS-OVRRIDE-RT-BILL-DT-BP(WS-ADJUSTMNT-INDEX)            
P00246       TO BP-OVRRIDE-RT-BILL-DT                                   
P00246     MOVE WS-OVRRIDE-RT-BILL-CY-BP(WS-ADJUSTMNT-INDEX)            
P00246       TO BP-OVRRIDE-RT-BILL-CY                                   
P00246     IF WS-OVRRIDE-RT-BILL-DT-BP(WS-ADJUSTMNT-INDEX) = SPACES     
P00246        MOVE -1 TO WS-NULL-IND-31                                 
P00246     END-IF                                                       
T33924     .                                                            
T33924 2335-EXIT.                                                       
T33924     EXIT.                                                        
      *                                                                         
      * SEARCH BILL MESSAGES FOR RATE CHANGE                                    
      *                                                                         
T8770  2340-PROCESS-RATE-CHANGE.                                        
T8770      PERFORM VARYING WS-MSG-INDX FROM 1 BY 1                      
T8770        UNTIL WS-MSG-INDX > 10                                     
T8770           OR WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) <= 0            
T8770         IF (WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) = WS-RATE-2TOX   
T8770             AND UT-PRV-RATE-PLAN-NO = '002')                      
T8770          OR (WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) = WS-RATE-8TO2  
T8770              AND UT-PRV-RATE-PLAN-NO = '008')                     
T8770          OR (WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) = WS-RATE-10TO9 
T8770              AND UT-PRV-RATE-PLAN-NO = '010')                     
A05305         OR (WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) = WS-RATE-2NMTO8
A05305             AND UT-PRV-RATE-PLAN-NO = '2NM')                     
A05305         OR (WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) = WS-RATE-2NETO8
A05305             AND UT-PRV-RATE-PLAN-NO = '2NE')                     
A05305         OR (WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) = WS-RATE-8NMTO2
A05305             AND UT-PRV-RATE-PLAN-NO = '8NM')                     
A05305         OR (WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) = WS-RATE-8NETO2
A05305             AND UT-PRV-RATE-PLAN-NO = '8NE')                     
C32676         OR (WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) =               
C32676                           WS-MSG-GAS-RTCHG-RESL AND              
C32676             WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX) = 'G')           
C32676         OR (WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) =               
C32676                           WS-MSG-GAS-RTCHG-RESH AND              
C32676             WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX) = 'G')           
C32676         OR (WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) =               
C32676                           WS-MSG-GAS-RTCHG-COML AND              
C32676             WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX) = 'G')           
C32676         OR (WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) =               
C32676                           WS-MSG-GAS-RTCHG-COMH AND              
C32676             WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX) = 'G')           
T33924         OR (WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) =               
T33924                           WS-MSG-RT-105-110 AND                  
T33924             WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX) = 'G')           
T33924         OR (WS-BILL-MESSAGE-NO-CALC(WS-MSG-INDX) =               
T33924                           WS-MSG-RT-110-105 AND                  
T33924             WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX) = 'G')           
T8770            PERFORM 2350-LOAD-MNT-HISTORY THRU 2350-EXIT           
T8770            PERFORM 8860-INSERT-MNT-TRANS-HIST THRU 8860-EXIT      
T8770            PERFORM 8865-INSERT-MT-TRN-HST-DET THRU 8865-EXIT      
T8770            MOVE 11 TO WS-MSG-INDX                                 
T8770         END-IF                                                    
T8770      END-PERFORM.                                                 
T8770  2340-EXIT.                                                       
T8770      EXIT.                                                        
T8770 *                                                                         
T8770  2350-LOAD-MNT-HISTORY.                                           
T8770 *                                                                         
T8770      PERFORM 7300-GET-TIMESTAMP  THRU 7300-EXIT.                  
T8770      MOVE LS-INPUT-DATE          TO MH-DATE-TRANS.                
T8770      MOVE WS-MAINT-TRAN-TYPE     TO MH-CODE-TRAN-TYPE.            
T8770      MOVE WS-CUST-ACCT-RESP-AREA TO MH-RESP-AREA-ID.              
T8770      MOVE WS-CUSTOMER-NO-AT      TO MH-CUSTOMER-NO.               
T8770      MOVE UT-ACCOUNT-NO          TO MH-ACCOUNT-NO.                
T8770      MOVE WS-PREMISE-NO-PR       TO MH-PREMISE-NO.                
T8770      MOVE WS-SYSTEM              TO MH-USER-ID.                   
T8770      MOVE WS-SCSCA102B           TO MH-APPL-PROGRAM-ID.           
T8770      MOVE LENGTH OF WS-MAINT-TRAN-DESC                            
T8770                                  TO MH-TRAN-COMMENT-LEN.          
T8770      MOVE WS-MAINT-TRAN-DESC     TO MH-TRAN-COMMENT-TEXT.         
T8770 *                                                                         
T8770      MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO.         
T8770      MOVE WS-RATE-PLAN-DESC      TO MI-COLUMN-DESC.               
T8770      MOVE +3                     TO MI-PRV-COLUMN-VALUE-LEN       
T8770                                     MI-CHG-COLUMN-VALUE-LEN.      
T8770      MOVE UT-RATE-PLAN-NO        TO MI-CHG-COLUMN-VALUE-TEXT.     
T8770      MOVE UT-PRV-RATE-PLAN-NO    TO MI-PRV-COLUMN-VALUE-TEXT.     
ACT204     MOVE SPACES                 TO MI-TABLE-ID.                  
T8770 *                                                                         
T8770  2350-EXIT.                                                       
T8770      EXIT.                                                        
P00251*                                                                         
P00251 2360-PROCESS-UTL-BI-REL-HST.                                     
P00251*                                                                         
P00251     MOVE WS-ACCOUNT-NO-MST-UX (WS-UX-INDX)                       
P00251          TO UX-ACCOUNT-NO-MST.                                   
P00251     MOVE WS-BILL-NO-UX (WS-UX-INDX)                              
P00251          TO UX-BILL-NO.                                          
P00251     MOVE WS-CODE-UTIL-TYPE-MST-UX (WS-UX-INDX)                   
P00251          TO UX-CODE-UTIL-TYPE-MST.                               
P00251     MOVE WS-IC-NO-MST-UX (WS-UX-INDX)                            
P00251          TO UX-IC-NO-MST.                                        
P00251     MOVE WS-BILL-ITEM-TIMESTMP-UX (WS-UX-INDX)                   
P00251          TO UX-BILL-ITEM-TIMESTMP.                               
P00251     MOVE WS-MTR-REF-NO-MST-UX (WS-UX-INDX)                       
P00251          TO UX-MTR-REF-NO-MST.                                   
P00251     MOVE WS-DEP-REL-START-DT-UX (WS-UX-INDX)                     
P00251          TO UX-DEP-REL-START-DT.                                 
P00251     MOVE WS-ACCOUNT-NO-DEP-UX (WS-UX-INDX)                       
P00251          TO UX-ACCOUNT-NO-DEP.                                   
P00251     MOVE WS-CODE-UTIL-TYPE-DEP-UX (WS-UX-INDX)                   
P00251          TO UX-CODE-UTIL-TYPE-DEP.                               
P00251     MOVE WS-IC-NO-DEP-UX (WS-UX-INDX)                            
P00251          TO UX-IC-NO-DEP.                                        
P00251     MOVE WS-MTR-REF-NO-DEP-UX (WS-UX-INDX)                       
P00251          TO UX-MTR-REF-NO-DEP.                                   
P00251     MOVE WS-CODE-RELATION-TYPE-UX (WS-UX-INDX)                   
P00251          TO UX-CODE-RELATION-TYPE.                               
P00251     MOVE WS-DEP-REL-END-DT-UX (WS-UX-INDX)                       
P00251          TO UX-DEP-REL-END-DT.                                   
P00251*                                                                         
P00251 2360-EXIT.                                                       
P00251     EXIT.                                                        
      *                                                                         
P00496 2370-PROCESS-BILL-BSLN-HIST.                                     
P00496*                                                                         
P00496     MOVE WS-ACCOUNT-NO-LO (WS-LO-INDEX)                          
P00496          TO LO-ACCOUNT-NO.                                       
P00496     MOVE WS-CODE-UTIL-TYPE-LO (WS-LO-INDEX)                      
P00496          TO LO-CODE-UTIL-TYPE.                                   
P00496     MOVE WS-IC-NO-LO (WS-LO-INDEX)                               
P00496          TO LO-IC-NO.                                            
P00496     MOVE WS-BILL-NO-LO (WS-LO-INDEX)                             
P00496          TO LO-BILL-NO.                                          
P00496     MOVE WS-BILL-ITEM-TIMESTMP-LO (WS-LO-INDEX)                  
P00496          TO LO-BILL-ITEM-TIMESTMP.                               
P00496     MOVE WS-CNTRCT-START-DT-LO (WS-LO-INDEX)                     
P00496          TO LO-CNTRCT-START-DT.                                  
P00496     MOVE WS-BASELINE-MONTH-LO (WS-LO-INDEX)                      
P00496          TO LO-BASELINE-MONTH.                                   
P00496     MOVE WS-CMPNT-ID-CD-LO (WS-LO-INDEX WS-LO-UNITS-INDX)        
P00496          TO LO-CMPNT-ID-CD.                                      
P00496     MOVE WS-INSTR-USE-TYPE-CD-LO (WS-LO-INDEX WS-LO-UNITS-INDX)  
P00496          TO LO-INSTR-USE-TYPE-CD.                                
P00496     MOVE WS-CODE-TIME-PERIOD-LO (WS-LO-INDEX WS-LO-UNITS-INDX)   
P00496          TO LO-CODE-TIME-PERIOD.                                 
P00496     MOVE WS-BASELINE-UNITS-LO (WS-LO-INDEX WS-LO-UNITS-INDX)     
P00496          TO LO-BASELINE-UNITS.                                   
P00496*                                                                         
P00496 2370-EXIT.                                                       
P00496     EXIT.                                                        
      *                                                                         
PRJ583/*****************************************************************        
PRJ583*  4060-GET-ADTNL-CX-DETAILS.                                    *        
PRJ583*  DERIVE THE FOLLOWING DETAILS FOR CX                           *        
PRJ583*    1. CONSUMPTION START DATE                                   *        
PRJ583*    2. PREVIOUS METER READ INDEX                                *        
PRJ583*    3. COMBINE FLAG                                             *        
PRJ583******************************************************************        
PRJ583*                                                                         
PRJ583     EXEC SQL                                                             
PRJ583         INCLUDE CPD00225                                                 
PRJ583     END-EXEC.                                                            
      *                                                                         
      /*****************************************************************        
      *                                                                *        
      *  5100-PROCESS-NORM-ITEM                                        *        
      *                                                                *        
      *  IF A NORMAL BILL ITEM HAS ERRORS, A NEW BILL HOOK IS CREATED  *        
      *  AND THE CONSUMPTION FROM THE CURRENT BILL DETAIL IS ATTACHED  *        
      *  TO IT. (THIS IS IN ADDITION TO THE BILL HOOK CREATED AT THE   *        
      *  TOP OF THE PROGRAM; THAT ONE IS FOR THE NEXT REGULAR BILL,    *        
      *  THIS ONE WILL SUPPORT THE REBILL OF THE CORRECTED ITEM).      *        
      *                                                                *        
      *  THERE MAY BE MULTIPLE CANCEL ITEMS, BUT THEY WILL ALL GO      *        
      *  UNDER THE SAME UNBILLED HOOKS (ONE BI PLUS A BG FOR EACH IC)  *        
      *                                                                *        
      ******************************************************************        
       5100-PROCESS-NORM-ITEM.                                          
           IF WS-CODE-ACCT-STAT-AT  EQUAL  WS-FINAL-BILL                
              IF FIRST-PASS                                             
                 SET NOT-FIRST-PASS TO TRUE                             
                 PERFORM 5800-CREATE-BH-HIST-HOOKS THRU 5800-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           SET CNSMPTN-NOT-FOUND TO TRUE                                
           PERFORM 5750-SEARCH-UM-CNSMPT-HIST THRU 5750-EXIT.           
           PERFORM 5760-SEARCH-CNSMPTN-HIST THRU 5760-EXIT.             
           IF CNSMPTN-FOUND                                             
               PERFORM 5610-FIND-BILL-DETAIL  THRU  5610-EXIT           
               PERFORM 5710-COPY-UM-CNSMPT-HIST THRU 5710-EXIT          
               PERFORM 5720-COPY-CNSMPTN-HIST THRU 5720-EXIT            
               PERFORM 5730-COPY-FCT-HIST THRU 5730-EXIT                
           END-IF.                                                      
       5100-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************        
      *                                                                *        
      *  5200-PROCESS-SPEC-ITEM                                        *        
      *                                                                *        
      *  IF A SPECIAL REBILL ITEM (TAX ONLY OR PRECALC) HAD A CALC     *        
      *  ERROR, A NEW BILL DETAIL IS CREATED UNDER THE CURRENT BILL    *        
      *  HEADER, AND THE CONSUMPTION COPIED UNDER IT.                  *        
      *                                                                *        
      *  SINCE THESE ITEMS ARE REBILLS IN THE FIRST PLACE, IT IS       *        
      *  NOT NECESSARY TO CREATE THE SECOND UNBILLED HOOK FOR THEM.    *        
      *                                                                *        
      ******************************************************************        
       5200-PROCESS-SPEC-ITEM.                                          
           SET CNSMPTN-NOT-FOUND TO TRUE                                
           PERFORM 5750-SEARCH-UM-CNSMPT-HIST THRU 5750-EXIT.           
           PERFORM 5760-SEARCH-CNSMPTN-HIST THRU 5760-EXIT.             
           IF CNSMPTN-FOUND                                             
T5502 *        MOVE WS-NXT-BILL-NO-AT TO BG-BILL-NO                     18740000
               MOVE WS-NEXT-BILL-NO-CALC TO BG-BILL-NO                  
               PERFORM 5620-INSERT-BILLING-DET THRU 5620-EXIT           
               PERFORM 5710-COPY-UM-CNSMPT-HIST THRU 5710-EXIT          
               PERFORM 5720-COPY-CNSMPTN-HIST THRU 5720-EXIT            
               PERFORM 5730-COPY-FCT-HIST THRU 5730-EXIT
           END-IF.               
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*****************************************************************        
      *                                                                *        
      *  5300-PROCESS-PRIOR-ACCT.                                      *        
      *                                                                *        
      *  A BILL ITEM FROM A PRIOR ACCOUNT (TENANT) HAS BEEN CANCELLED ;*        
      *  A NEW BILLING HEADER, BILLING DETAIL AND CONSUMPTION MUST BE  *        
      *  CREATED. UNILKE THE "REGULAR" BILLS, BILL DETAILS ARE CREATED *        
      *  FROM THE BILL DETAIL RATHER THAN FROM THE UT'S, SINCE THE     *        
      *  UT ROWS ARE NO LONGER ATTACHED TO THE ACCOUNT.                *        
      *                                                                *        
      ******************************************************************        
       5300-PROCESS-PRIOR-ACCT.                                         
           SET CNSMPTN-NOT-FOUND TO TRUE                                
           PERFORM 5750-SEARCH-UM-CNSMPT-HIST THRU 5750-EXIT.           
           PERFORM 5760-SEARCH-CNSMPTN-HIST THRU 5760-EXIT.             
                                                                        
           IF CNSMPTN-FOUND                                             
               IF FIRST-PASS                                            
                  SET NOT-FIRST-PASS TO TRUE                            
                  PERFORM 5630-CREATE-BILLING-HDR THRU 5630-EXIT        
               END-IF                                                   
               MOVE WS-SAVE-PRIOR-ACCT-BILL-NO TO BG-BILL-NO            
               PERFORM 5620-INSERT-BILLING-DET THRU 5620-EXIT           
               PERFORM 5710-COPY-UM-CNSMPT-HIST THRU 5710-EXIT          
               PERFORM 5720-COPY-CNSMPTN-HIST THRU 5720-EXIT            
               PERFORM 5730-COPY-FCT-HIST THRU 5730-EXIT
           END-IF.               
       5300-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************        
      *                                                                *        
      *  5610-FIND-BILL-DETAIL.                                        *        
      *                                                                *        
      *  DETERMINE IF A BILLING DETAIL EXISTS FOR THE NEW BILL HOOK    *        
      *  WHICH MATCHES THE CANCELLED TRANSACTION ; IF IT DOESN'T,      *        
      *  CREATE ONE.                                                   *        
      *                                                                *        
      ******************************************************************        
       5610-FIND-BILL-DETAIL.                                           
           MOVE WS-PREMISE-NO-PR TO PR-PREMISE-NO.                      
      *                                                                         
           MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX) TO  BG-ACCOUNT-NO.   
           MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)   TO             
                BG-CODE-UTIL-TYPE.                                      
           MOVE WS-IC-NO-BG (WS-BILLING-INDX)            TO             
                BG-IC-NO.                                               
           MOVE ZERO TO WS-ROW-COUNT.                                   
           PERFORM 7410-COUNT-BILLING-DET THRU 7410-EXIT.               
           IF WS-ROW-COUNT EQUAL ZERO                                   
T5502 *        MOVE WS-NXT-BILL-NO-AT TO BG-BILL-NO                     18740000
T5502          MOVE WS-NEXT-BILL-NO-CALC TO BG-BILL-NO                  
               PERFORM 5620-INSERT-BILLING-DET THRU 5620-EXIT           
           END-IF                                                       
           PERFORM 7420-OPEN-BILLING-DET THRU 7420-EXIT                 
           PERFORM 7430-FETCH-BILLING-DET THRU 7430-EXIT                
           PERFORM 7440-CLOSE-BILLING-DET THRU 7440-EXIT.               
       5610-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************        
      *                                                                *        
      *  5620-INSERT-BILLING-DET.                                      *        
      *                                                                *        
      *  CREATE A COPY OF THE BILLING DETAIL AND ASSOCIATE IT WITH     *        
      *  THE NEW BILL HOOK.                                            *        
      *                                                                *        
      *  THE BILL_NO IS SET TO THE PREMISE NEXT_BILL_NO. SINCE THIS IS *        
      *  A SPECIAL BILL ITEM, THE BILL_ITEM_TIMESTMP MUST BE RETAINED  *        
      *  TO AVOID ADDING DUPLICATE BILLING DETAILS.                    *        
      *                                                                *        
      ******************************************************************        
       5620-INSERT-BILLING-DET.                                         
           MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX)         TO           
                BG-ACCOUNT-NO.                                          
           MOVE WS-PREMISE-NO-BG (WS-BILLING-INDX)         TO           
                BG-PREMISE-NO.                                          
           MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)     TO           
                BG-CODE-UTIL-TYPE.                                      
           MOVE WS-IC-NO-BG (WS-BILLING-INDX)              TO           
                BG-IC-NO.                                               
                                                                        
           PERFORM 7100-GET-CURRENT-TIMESTAMP THRU 7100-EXIT            
                                                                        
           MOVE WS-CURRENT-TIMESTAMP TO BG-BILL-ITEM-TIMESTMP.          
                                                                        
           MOVE WS-CODE-BILL-ITM-TYPE-BG (WS-BILLING-INDX) TO           
                BG-CODE-BILL-ITM-TYPE.                                  
           MOVE WS-ACTIVE                                  TO           
                BG-CODE-BILL-ITM-IND.                                   
           MOVE WS-CODE-DR-CR-CNSMPTN-BG (WS-BILLING-INDX) TO           
                BG-CODE-DR-CR-CNSMPTN.                                  
           MOVE WS-CODE-BILL-CALC-BG (WS-BILLING-INDX)     TO           
                BG-CODE-BILL-CALC.                                      
           MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)       TO           
                BG-RATE-PLAN-NO.                                        
           MOVE WS-COMPANY-NO-BG (WS-BILLING-INDX)       TO             
                BG-COMPANY-NO.                                          
           MOVE WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX) TO           
                BG-CODE-REVENUE-CLASS.                                  
           MOVE WS-CODE-SIC-NO-BG (WS-BILLING-INDX)        TO           
                BG-CODE-SIC-NO.                                         
           MOVE WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)      TO           
                BG-AMT-BILL-ITEM.                                       
           MOVE WS-ADJ-REASON-CD-BG (WS-BILLING-INDX)    TO             
                BG-ADJ-REASON-CD                                        
           MOVE WS-BTU-FACTOR-BG (WS-BILLING-INDX)                      
                TO BG-BTU-FACTOR                                        
           MOVE WS-GAS-BASE-USE-BG (WS-BILLING-INDX)                    
                TO BG-GAS-BASE-USE.                                     
           MOVE WS-WNA-FACTOR-BG (WS-BILLING-INDX)                      
                TO BG-WNA-FACTOR.                                       
C33968     MOVE WS-NAICS-CD-BG (WS-BILLING-INDX) TO                     
C33968          BG-NAICS-CD.                                            
C34569     MOVE WS-RT-PKG-OPT-SEQ-NO-BG (WS-BILLING-INDX) TO            
C34569          BG-RT-PKG-OPT-SEQ-NO.                                   
C29528     MOVE ZEROES TO BG-STATE-TAX-RATE                             
C29528     MOVE ZEROES TO BG-CITY-TAX-RATE                              
           PERFORM 8421-INSERT-BILLING-DET THRU 8421-EXIT.              
       5620-EXIT.                                                       
           EXIT.                                                        
       5630-CREATE-BILLING-HDR.                                         
      ** SINCE A PRIOR ACCOUNT IS BEING BILLED, A NEW BILLING HEADER            
      ** IS CREATED AND THE ASSOCIATED BILLING DETAILS, ALONG WITH              
      ** THEIR CONSUMPTION, ARE MOVED TO IT                                     
      *                                                                         
           MOVE WS-NXT-BILL-NO-AT  TO WS-SAVE-PRIOR-ACCT-BILL-NO.       
           ADD 1                   TO WS-NXT-BILL-NO-AT.                
                                                                        
      *                                                                         
           MOVE WS-ACCOUNT-NO-AT           TO BI-ACCOUNT-NO.            
           PERFORM 7210-SELECT-BILLING-HDR THRU 7210-EXIT.              
      *                                                                         
      ** CREATE A NEW BILLING HEADER FOR THE PREVIOUS ACCOUNT.                  
      *                                                                         
           PERFORM 7210-SELECT-BILLING-HDR THRU 7210-EXIT.              
           PERFORM 8210-INSERT-BILLING-HDR THRU 8210-EXIT.              
                                                                        
      *                                                                         
      ** MOVE THE BILLING DETAILS FROM THE PREVIOUS BILL HOOK FOR               
      ** THE CURRENT ACCOUNT.                                                   
      *                                                                         
           MOVE ZERO TO WS-ROW-COUNT.                                   
           MOVE WS-ACCOUNT-NO-BI           TO BG-ACCOUNT-NO.            
           MOVE WS-SAVE-PRIOR-ACCT-BILL-NO TO BG-BILL-NO.               
           PERFORM 7450-COUNT-BILLING-DET THRU 7450-EXIT.               
           IF WS-ROW-COUNT EQUAL ZERO                                   
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 7810-OPEN-BILLING-DETAIL   THRU 7810-EXIT         
              PERFORM 7812-FETCH-BILLING-DETAIL  THRU 7812-EXIT         
              PERFORM 5635-UPDATE-BILLING-DETAIL THRU 5635-EXIT         
                UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND             
              PERFORM 7814-CLOSE-BILLING-DETAIL  THRU 7814-EXIT
           END-IF.        
      *                                                                         
      ** CHANGE THE PREVIOUS BILL HOOK TO REFLECT THE PRIOR CUSTOMER            
      ** AND ACCOUNT NUMBER.                                                    
      *                                                                         
           MOVE WS-CUSTOMER-NO-AT          TO BI-CUSTOMER-NO.           
           MOVE WS-ACCOUNT-NO-AT           TO BI-ACCOUNT-NO.            
           MOVE WS-SAVE-PRIOR-ACCT-BILL-NO TO BI-BILL-NO.               
           PERFORM 8200-UPDATE-BILLING-HDR THRU 8200-EXIT.              
       5630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5635-UPDATE-BILLING-DETAIL.                                      
           MOVE WS-BILL-NO-BI TO BG-BILL-NO.                            
           PERFORM 8421-INSERT-BILLING-DET THRU 8421-EXIT.              
      *                                                                         
      ** MOVE THE METERED CONSUMPTION FROM THE PREVIOUS BILL HOOK               
      ** FOR THE CURRENT ACCOUNT.                                               
      *                                                                         
           MOVE ZERO TO WS-ROW-COUNT.                                   
           MOVE BG-ACCOUNT-NO              TO CX-ACCOUNT-NO.            
           MOVE WS-SAVE-PRIOR-ACCT-BILL-NO TO CX-BILL-NO.               
           MOVE BG-CODE-UTIL-TYPE          TO CX-CODE-UTIL-TYPE.        
           MOVE BG-IC-NO                   TO CX-IC-NO.                 
           MOVE BG-BILL-ITEM-TIMESTMP      TO CX-BILL-ITEM-TIMESTMP.    
           PERFORM 7700-COUNT-CNSMPTN-HIST THRU 7700-EXIT.              
           IF WS-ROW-COUNT EQUAL ZERO                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 7830-OPEN-CNSMPTN-HIST     THRU 7830-EXIT        
               PERFORM 7832-FETCH-CNSMPTN-HIST    THRU 7832-EXIT        
               PERFORM 5636-UPDATE-CNSMPTN-HIST   THRU 5636-EXIT        
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               PERFORM 7834-CLOSE-CNSMPTN-HIST    THRU 7834-EXIT
           END-IF.       
                                                                        
      ** MOVE THE UN-METERED CONSUMPTION FROM THE PREVIOUS BILL HOOK            
      ** FOR THE CURRENT ACCOUNT.                                               
      *                                                                         
           MOVE ZERO TO WS-ROW-COUNT.                                   
           MOVE BG-ACCOUNT-NO              TO UC-ACCOUNT-NO.            
           MOVE WS-SAVE-PRIOR-ACCT-BILL-NO TO UC-BILL-NO.               
           MOVE BG-CODE-UTIL-TYPE          TO UC-CODE-UTIL-TYPE.        
           MOVE BG-IC-NO                   TO UC-IC-NO.                 
           MOVE BG-BILL-ITEM-TIMESTMP      TO UC-BILL-ITEM-TIMESTMP.    
           PERFORM 7510-COUNT-UM-CNSMPT-HIST THRU 7510-EXIT.            
           IF WS-ROW-COUNT EQUAL ZERO                                   
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 7820-OPEN-UM-CNSMPT-HIST   THRU 7820-EXIT        
               PERFORM 7822-FETCH-UM-CNSMPT-HIST  THRU 7822-EXIT        
               PERFORM 5637-UPDATE-UM-CNSMPT-HIST THRU 5637-EXIT        
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               PERFORM 7824-CLOSE-UM-CNSMPT-HIST  THRU 7824-EXIT
           END-IF.       
           PERFORM 8435-DELETE-BILLING-DETAIL THRU 8435-EXIT.           
           PERFORM 7812-FETCH-BILLING-DETAIL  THRU 7812-EXIT.           
                                                                        
       5635-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5636-UPDATE-CNSMPTN-HIST.                                        
           PERFORM 8705-DELETE-CNSMPTN-HIST THRU 8705-EXIT.             
           MOVE WS-BILL-NO-BI TO CX-BILL-NO.                            
           PERFORM 8710-INSERT-CNSMPTN-HIST THRU 8710-EXIT.             
           PERFORM 7832-FETCH-CNSMPTN-HIST  THRU 7832-EXIT.             
       5636-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5637-UPDATE-UM-CNSMPT-HIST.                                      
           PERFORM 8515-DELETE-UM-CNSMPT-HIST THRU 8515-EXIT.           
           MOVE WS-BILL-NO-BI TO UC-BILL-NO.                            
           PERFORM 8520-INSERT-UM-CNSMPT-HIST THRU 8520-EXIT.           
           PERFORM 7822-FETCH-UM-CNSMPT-HIST  THRU 7822-EXIT.           
       5637-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       5710-COPY-UM-CNSMPT-HIST.                                        
           PERFORM VARYING WS-UNMTRD-CNSMPTN-INDX FROM 1 BY 1           
I00177             UNTIL WS-UNMTRD-CNSMPTN-INDX >                       
I00177                   WS-UC-MAX-ENTRY                                
                      OR WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX)      
                           = ZERO                                       
               IF WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX) =           
                       WS-ACCOUNT-NO-BG (WS-BILLING-INDX)               
                    AND WS-CODE-UTIL-TYPE-UC (WS-UNMTRD-CNSMPTN-INDX) = 
                        WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)          
                    AND WS-BILL-NO-UC (WS-UNMTRD-CNSMPTN-INDX) =        
                        WS-BILL-NO-BG (WS-BILLING-INDX)                 
                    AND WS-IC-NO-UC (WS-UNMTRD-CNSMPTN-INDX) =          
                        WS-IC-NO-BG (WS-BILLING-INDX)                   
                   AND WS-BILL-ITEM-TIMESTMP-UC (WS-UNMTRD-CNSMPTN-INDX)
                      = WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)      
                    AND WS-NO-UNITS-UC (WS-UNMTRD-CNSMPTN-INDX) > ZERO  
                    AND WS-NO-DAYS-UC (WS-UNMTRD-CNSMPTN-INDX) > ZERO   
                 PERFORM 5712-CREATE-UM-CNSMPT-HIST THRU 5712-EXIT      
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       5710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5712-CREATE-UM-CNSMPT-HIST.                                      
           PERFORM 2210-PROCESS-UM-CNSMPT-HIST.                         
           MOVE BG-ACCOUNT-NO          TO UC-ACCOUNT-NO.                
           MOVE BG-BILL-NO             TO UC-BILL-NO.                   
           MOVE BG-CODE-UTIL-TYPE      TO UC-CODE-UTIL-TYPE.            
           MOVE BG-IC-NO               TO UC-IC-NO.                     
           MOVE BG-BILL-ITEM-TIMESTMP  TO UC-BILL-ITEM-TIMESTMP.        
           PERFORM 8520-INSERT-UM-CNSMPT-HIST THRU 8520-EXIT            
                TEST AFTER                                              
                VARYING UC-ITEM-SEQ-NO FROM UC-ITEM-SEQ-NO BY 1         
                UNTIL WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL.      
                                                                        
       5712-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       5720-COPY-CNSMPTN-HIST.                                          
           PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1                  
T14555             UNTIL WS-CNSMPTN-INDX > 200                          
                      OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX)             
                           = ZERO                                       
               IF WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) =                  
                       WS-ACCOUNT-NO-BG (WS-BILLING-INDX)               
                    AND WS-CODE-UTIL-TYPE-CX (WS-CNSMPTN-INDX) =        
                        WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)          
                    AND WS-BILL-NO-CX (WS-CNSMPTN-INDX) =               
                        WS-BILL-NO-BG (WS-BILLING-INDX)                 
                    AND WS-IC-NO-CX (WS-CNSMPTN-INDX) =                 
                        WS-IC-NO-BG (WS-BILLING-INDX)                   
                    AND WS-BILL-ITEM-TIMESTMP-CX (WS-CNSMPTN-INDX)      
                      = WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)      
                    AND (WS-NO-UNITS-CX (WS-CNSMPTN-INDX) > ZERO        
                      OR WS-NO-DEMAND-UNITS-CX (WS-CNSMPTN-INDX) > ZERO)
                    AND WS-CODE-ITEM-STATUS-CX (WS-CNSMPTN-INDX)        
                        NOT = WS-ACTIVE-MONITOR                         
                 PERFORM 5722-CREATE-CNSMPTN-HIST THRU 5722-EXIT        
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       5720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5722-CREATE-CNSMPTN-HIST.                                        
           PERFORM 2200-PROCESS-CNSMPT-HIST.                            
                                                                        
           MOVE BG-ACCOUNT-NO           TO CX-ACCOUNT-NO.               
           MOVE BG-BILL-NO              TO CX-BILL-NO.                  
           MOVE BG-CODE-UTIL-TYPE       TO CX-CODE-UTIL-TYPE.           
           MOVE BG-IC-NO                TO CX-IC-NO.                    
           MOVE BG-BILL-ITEM-TIMESTMP   TO CX-BILL-ITEM-TIMESTMP.       
                                                                        
           PERFORM 8710-INSERT-CNSMPTN-HIST THRU 8710-EXIT              
                TEST AFTER                                              
                VARYING CX-ITEM-SEQ-NO FROM CX-ITEM-SEQ-NO BY 1         
                UNTIL WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL.      
                                                                        
       5722-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       5730-COPY-FCT-HIST.                                              
           PERFORM VARYING WS-FH-HIST-INDX FROM 1 BY 1                  
                   UNTIL WS-FH-HIST-INDX > 200                          
                      OR WS-ACCOUNT-NO-FH (WS-FH-HIST-INDX)             
                           = ZERO                                       
               IF WS-ACCOUNT-NO-FH (WS-FH-HIST-INDX) =                  
                       WS-ACCOUNT-NO-BG (WS-BILLING-INDX)               
                    AND WS-CODE-UTIL-TYPE-FH (WS-FH-HIST-INDX) =        
                        WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)          
                    AND WS-BILL-NO-FH (WS-FH-HIST-INDX) =               
                        WS-BILL-NO-BG (WS-BILLING-INDX)                 
                    AND WS-IC-NO-FH (WS-FH-HIST-INDX) =                 
                        WS-IC-NO-BG (WS-BILLING-INDX)                   
                   AND WS-BILL-ITEM-TIMESTMP-FH (WS-FH-HIST-INDX)       
                      = WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)      
                 PERFORM 5732-CREATE-FCT-HIST THRU 5732-EXIT            
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       5730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5732-CREATE-FCT-HIST.                                            
           PERFORM 2230-PROCESS-FACTOR-HIST THRU 2230-EXIT              
           MOVE BG-ACCOUNT-NO         TO FH-ACCOUNT-NO.                 
           MOVE BG-BILL-NO            TO FH-BILL-NO.                    
           MOVE BG-CODE-UTIL-TYPE     TO FH-CODE-UTIL-TYPE.             
           MOVE BG-IC-NO              TO FH-IC-NO.                      
           MOVE BG-BILL-ITEM-TIMESTMP TO FH-BILL-ITEM-TIMESTMP.         
           PERFORM 8720-INSERT-FCT-HIST THRU 8720-EXIT.                 
       5732-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************        
      *                                                                *        
      *  5750-SEARCH-UM-CNSMPT-HIST.                                   *        
      *                                                                *        
      ******************************************************************        
       5750-SEARCH-UM-CNSMPT-HIST.                                      
           PERFORM VARYING WS-UNMTRD-CNSMPTN-INDX FROM 1 BY 1           
I00177             UNTIL WS-UNMTRD-CNSMPTN-INDX >                       
I00177                   WS-UC-MAX-ENTRY                                
                      OR CNSMPTN-FOUND                                  
                      OR WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX)      
                           = ZERO                                       
               IF WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX) =           
                       WS-ACCOUNT-NO-BG (WS-BILLING-INDX)               
                    AND WS-CODE-UTIL-TYPE-UC (WS-UNMTRD-CNSMPTN-INDX) = 
                        WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)          
                    AND WS-BILL-NO-UC (WS-UNMTRD-CNSMPTN-INDX) =        
                        WS-BILL-NO-BG (WS-BILLING-INDX)                 
                    AND WS-IC-NO-UC (WS-UNMTRD-CNSMPTN-INDX) =          
                        WS-IC-NO-BG (WS-BILLING-INDX)                   
                   AND WS-BILL-ITEM-TIMESTMP-UC (WS-UNMTRD-CNSMPTN-INDX)
                      = WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)      
                    AND WS-NO-UNITS-UC (WS-UNMTRD-CNSMPTN-INDX) > ZERO  
                    AND WS-NO-DAYS-UC (WS-UNMTRD-CNSMPTN-INDX) > ZERO   
                 SET CNSMPTN-FOUND TO TRUE                              
              END-IF                                                    
           END-PERFORM.                                                 
       5750-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *  5760-SEARCH-CNSMPTN-HIST.                                     *        
      *                                                                *        
      ******************************************************************        
       5760-SEARCH-CNSMPTN-HIST.                                        
           PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1                  
T14555             UNTIL WS-CNSMPTN-INDX > 200                          
                      OR CNSMPTN-FOUND                                  
                      OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX)             
                           = ZERO                                       
               IF WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) =                  
                       WS-ACCOUNT-NO-BG (WS-BILLING-INDX)               
                    AND WS-CODE-UTIL-TYPE-CX (WS-CNSMPTN-INDX) =        
                        WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)          
                    AND WS-BILL-NO-CX (WS-CNSMPTN-INDX) =               
                        WS-BILL-NO-BG (WS-BILLING-INDX)                 
                    AND WS-IC-NO-CX (WS-CNSMPTN-INDX) =                 
                        WS-IC-NO-BG (WS-BILLING-INDX)                   
                    AND WS-BILL-ITEM-TIMESTMP-CX (WS-CNSMPTN-INDX)      
                      = WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)      
                    AND (WS-NO-UNITS-CX (WS-CNSMPTN-INDX) > ZERO        
                      OR WS-NO-DEMAND-UNITS-CX (WS-CNSMPTN-INDX) > ZERO)
                    AND WS-CODE-ITEM-STATUS-CX (WS-CNSMPTN-INDX)        
                        NOT = WS-ACTIVE-MONITOR                         
                 SET CNSMPTN-FOUND TO TRUE                              
              END-IF                                                    
           END-PERFORM.                                                 
       5760-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************        
      *                                                                *        
      *   5800-CREATE-BH-HIST-HOOKS.                                   *        
      *                                                                *        
      ** CREATE A BILLING HEADER FOR THE NEW BILL HOOK.                         
      *                                                                         
      ******************************************************************        
       5800-CREATE-BH-HIST-HOOKS.                                       
           PERFORM 5810-PROCESS-UTIL-ENVRNMT THRU 5810-EXIT             
               VARYING WS-UTIL-INDX FROM 1 BY 1                         
               UNTIL WS-UTIL-INDX > 40                                  
                  OR WS-ACCOUNT-NO-UT (WS-UTIL-INDX) = ZERO.            
       5800-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *   5810-PROCESS-UTIL-ENVRNMT.                                   *        
      *                                                                *        
      *  NOTE: METERED IC'S CAN HAVE MN AND CP DETAILS; UNMETERED IC'S *        
      *        CAN HAVE CP DETAILS ONLY                                *        
      *                                                                *        
      ******************************************************************        
       5810-PROCESS-UTIL-ENVRNMT.                                       
           MOVE ZERO TO WS-ROW-COUNT                                    
           PERFORM VARYING WS-CUST-PLAN-INDX FROM 1 BY 1                
I00177             UNTIL WS-CUST-PLAN-INDX > WS-CP-MAX-ENTRY            
                      OR WS-ACCOUNT-NO-CP (WS-CUST-PLAN-INDX) = ZERO    
              IF WS-CODE-PLAN-STATUS-CP (WS-CUST-PLAN-INDX) = 'A'       
                    AND WS-CODE-UTIL-TYPE-CP (WS-CUST-PLAN-INDX)        
                          = WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX)         
                    AND WS-IC-NO-CP (WS-CUST-PLAN-INDX)                 
                          = WS-IC-NO-UT (WS-UTIL-INDX)                  
                 ADD 1 TO WS-ROW-COUNT                                  
              END-IF                                                    
           END-PERFORM                                                  
           IF WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX) NOT = WS-UNMETERED    
              PERFORM VARYING WS-MTRD-INDX FROM 1 BY 1                  
C23632                UNTIL WS-MTRD-INDX > WS-MAX-MN-ENTRIES            
                         OR WS-ACCOUNT-NO-MN (WS-MTRD-INDX) = ZERO      
A03956           IF (WS-CODE-METER-STATUS-MN (WS-MTRD-INDX) = 'A'       
A03956               OR WS-SPCL-MTR-CONDITION-MN (WS-MTRD-INDX) = 'M')  
                       AND WS-CODE-UTIL-TYPE-MN (WS-MTRD-INDX)          
                             = WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX)      
                       AND WS-IC-NO-MN (WS-MTRD-INDX)                   
                             = WS-IC-NO-UT (WS-UTIL-INDX)               
                    ADD 1 TO WS-ROW-COUNT                               
T5521            ELSE                                                   
T5521              IF WS-CODE-METER-STATUS-MN (WS-MTRD-INDX) = 'I'      
C29967                 AND WS-CODE-UTIL-TYPE-MN (WS-MTRD-INDX)          
C29967                       = WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX)      
C29967                 AND WS-IC-NO-MN (WS-MTRD-INDX)                   
C29967                       = WS-IC-NO-UT (WS-UTIL-INDX)               
T5521 *            FOR A METER WITH MORE THAN 1 REGISTER - THE FIRST            
T5521 *            BEING A MONITOR ONLY - CHECK THE REGISTER READ               
T5521 *            TABLE TO DETERMINE IF IT'S ACTIVE OR NOT.                    
T5521                MOVE 'N' TO WS-ACTIVE-REG-FOUND-IND                
T5521                PERFORM VARYING WS-REG-RD-INDX FROM 1 BY 1         
SCA006                  UNTIL WS-ACTIVE-REG-FOUND OR 
                              WS-REG-RD-INDX > 20 OR 
                              WS-ACCOUNT-NO-RG (WS-REG-RD-INDX) = ZERO          
T5521                  IF WS-CODE-REG-STATUS-RG (WS-REG-RD-INDX) = 'A'  
T5521                       AND WS-ACCOUNT-NO-RG (WS-REG-RD-INDX) =     
T5521                          WS-ACCOUNT-NO-MN (WS-MTRD-INDX)          
T5521                       AND WS-CODE-UTIL-TYPE-RG (WS-REG-RD-INDX)   
T5521                          = WS-CODE-UTIL-TYPE-MN (WS-MTRD-INDX)    
T5521                       AND WS-IC-NO-RG (WS-REG-RD-INDX)            
T5521                          = WS-IC-NO-MN (WS-MTRD-INDX)             
T5521                       AND WS-METER-NO-RG (WS-REG-RD-INDX)         
T5521                          = WS-METER-NO-MN (WS-MTRD-INDX)          
T5521                    ADD 1 TO WS-ROW-COUNT                          
T5521                    MOVE 'Y' TO WS-ACTIVE-REG-FOUND-IND            
T5521                  END-IF                                           
T5521                END-PERFORM                                        
T5521              END-IF                                               
                 END-IF                                                 
              END-PERFORM                                               
           END-IF                                                       
      *                                                                         
           IF WS-ROW-COUNT > ZERO                                       
              PERFORM 5815-LOAD-DATA-FOR-BG THRU 5815-EXIT              
           END-IF.                                                      
      *                                                                         
       5810-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *   5815-LOAD-DATA-FOR-BILLING.                                  *        
      *                                                                *        
      ******************************************************************        
       5815-LOAD-DATA-FOR-BG.                                           
           INITIALIZE DCLCSS-BILLING-DET.                               
           MOVE WS-ACCOUNT-NO-BI       TO BG-ACCOUNT-NO.                
           MOVE WS-PREMISE-NO-BI       TO BG-PREMISE-NO.                
           MOVE WS-NEXT-BILL-NO-CALC   TO BG-BILL-NO.                   
           MOVE WS-REV-DISTRICT-CD-PR                                   
             TO BG-REV-DISTRICT-CD.                                     
           PERFORM 7100-GET-CURRENT-TIMESTAMP THRU 7100-EXIT            
T23513     IF SEB-DATABASE                                              
SEB           MOVE 'P' TO BG-PRORATE-CD                                 
SEB        END-IF.                                                      
           MOVE WS-CURRENT-TIMESTAMP   TO BG-BILL-ITEM-TIMESTMP.        
           MOVE WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX)                     
             TO BG-CODE-UTIL-TYPE.                                      
           MOVE WS-IC-NO-UT (WS-UTIL-INDX)                              
             TO BG-IC-NO.                                               
           MOVE WS-CURRENT             TO BG-CODE-BILL-ITM-TYPE.        
           MOVE WS-CODE-SIC-NO-UT (WS-UTIL-INDX)                        
             TO BG-CODE-SIC-NO.                                         
      *                                                                         
           MOVE WS-ACTIVE              TO BG-CODE-BILL-ITM-IND          
           MOVE WS-REGULAR-BILL        TO BG-CODE-BILL-CALC.            
           MOVE WS-CODE-STAT-TAX-XMT-UT (WS-UTIL-INDX)                  
             TO BG-CODE-STAT-TAX-XMT.                                   
           MOVE WS-CODE-CITY-TAX-XMT-UT (WS-UTIL-INDX)                  
             TO BG-CODE-CITY-TAX-XMT.                                   
           MOVE WS-CODE-OTHR-TAX-XMT-UT (WS-UTIL-INDX)                  
             TO BG-CODE-OTHR-TAX-XMT.                                   
           MOVE WS-COMPANY-NO-UT (WS-UTIL-INDX)                         
             TO BG-COMPANY-NO.                                          
T23951     MOVE WS-COMPANY-NO-AT  TO BG-COMPANY-NO.                     
           MOVE WS-RATE-PLAN-NO-UT (WS-UTIL-INDX)                       
             TO BG-RATE-PLAN-NO.                                        
T22406     MOVE WS-CODE-CURTAIL-PRTY-UT (WS-UTIL-INDX)                  
T22406       TO BG-CODE-CURTAIL-PRTY.                                   
           MOVE WS-CODE-REVENUE-CLASS-UT (WS-UTIL-INDX)                 
             TO BG-CODE-REVENUE-CLASS.                                  
           MOVE WS-CODE-SIC-NO-UT (WS-UTIL-INDX)                        
             TO BG-CODE-SIC-NO.                                         
           MOVE WS-GAS-BASE-USE-UT (WS-UTIL-INDX)                       
             TO BG-GAS-BASE-USE.                                        
C33968     MOVE WS-NAICS-CD-UT (WS-UTIL-INDX) TO BG-NAICS-CD.           
C34569     MOVE WS-RT-PKG-OPT-SEQ-NO-UT (WS-UTIL-INDX) TO               
C34569          BG-RT-PKG-OPT-SEQ-NO.                                   
C29528     MOVE ZEROES  TO BG-STATE-TAX-RATE.                           
C29528     MOVE ZEROES  TO BG-CITY-TAX-RATE.                            
           PERFORM 8421-INSERT-BILLING-DET THRU 8421-EXIT.              
       5815-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      ******************************************************************        
      *                                                                *        
RSN2  *  5900-SEARCH-FOR-CONSUMPTION.                                  *        
      *     FOR CANCEL REBILLS - BEFORE YOU CHANGE THE TIMESTAMP       *        
      *     ON THE BG SO THAT IT CAN BE INSERTED ONTO THE MASTER       *        
      *     CHANGE THE TIMESTAMP ALSO ON THE CX OR UC SO THAT THERE    *        
      *     WON'T BE A PROBLEM WHEN THE ARE INSERTED ONTO THE MASTER   *        
      *                                                                *        
      ******************************************************************        
       5900-SEARCH-FOR-CONSUMPTION.                                     
           IF WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) = 'E' OR 'G'        
             PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1                
T14555             UNTIL WS-CNSMPTN-INDX > 200                          
                      OR CNSMPTN-FOUND                                  
                      OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX)             
                           = ZERO                                       
               IF WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) =                  
                       WS-ACCOUNT-NO-BG (WS-BILLING-INDX)               
                    AND WS-CODE-UTIL-TYPE-CX (WS-CNSMPTN-INDX) =        
                        WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)          
                    AND WS-BILL-NO-CX (WS-CNSMPTN-INDX) =               
                        WS-BILL-NO-BG (WS-BILLING-INDX)                 
                    AND WS-IC-NO-CX (WS-CNSMPTN-INDX) =                 
                        WS-IC-NO-BG (WS-BILLING-INDX)                   
                    AND WS-BILL-ITEM-TIMESTMP-CX (WS-CNSMPTN-INDX)      
                      = WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)      
                      PERFORM 7100-GET-CURRENT-TIMESTAMP THRU 7100-EXIT 
                      MOVE WS-CURRENT-TIMESTAMP TO                      
                             BG-BILL-ITEM-TIMESTMP                      
                             WS-BILL-ITEM-TIMESTMP-CX (WS-CNSMPTN-INDX) 
              END-IF                                                    
             END-PERFORM                                                
           ELSE                                                         
             IF WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX) = 'U'             
                PERFORM VARYING WS-UNMTRD-CNSMPTN-INDX FROM 1 BY 1      
I00177             UNTIL WS-UNMTRD-CNSMPTN-INDX >                       
I00177                   WS-UC-MAX-ENTRY                                
                      OR CNSMPTN-FOUND                                  
                      OR WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX)      
                             = ZERO                                     
                  IF WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX) =        
                       WS-ACCOUNT-NO-BG (WS-BILLING-INDX)               
                    AND WS-CODE-UTIL-TYPE-UC (WS-UNMTRD-CNSMPTN-INDX) = 
                        WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)          
                    AND WS-BILL-NO-UC (WS-UNMTRD-CNSMPTN-INDX) =        
                        WS-BILL-NO-BG (WS-BILLING-INDX)                 
                    AND WS-IC-NO-UC (WS-UNMTRD-CNSMPTN-INDX) =          
                        WS-IC-NO-BG (WS-BILLING-INDX)                   
                   AND WS-BILL-ITEM-TIMESTMP-UC (WS-UNMTRD-CNSMPTN-INDX)
                      = WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)      
                      PERFORM 7100-GET-CURRENT-TIMESTAMP THRU 7100-EXIT 
                      MOVE WS-CURRENT-TIMESTAMP TO                      
                                                 BG-BILL-ITEM-TIMESTMP  
                       WS-BILL-ITEM-TIMESTMP-UC (WS-UNMTRD-CNSMPTN-INDX)
                  END-IF                                                
                END-PERFORM                                             
           END-IF
           END-IF.                                                      
       5900-EXIT.                                                       
           EXIT.                                                        
                                                                        
T18995 7000-SELECT-MSTSUB-ACCT.                                         
T18995     EXEC SQL                                                     
T18995        SELECT SUB_ACCT_BLLD_OK                                   
T18995          INTO :WS-SUB-BILLED-SW                                  
T18995          FROM CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                      
T18995         WHERE SUB_ACCT_NO  = :WS-ACCOUNT-NO                      
T33182                                                           
T18995     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUB_ACCT_BLLD_OK                                           
MFA-TR*         INTO :WS-SUB-BILLED-SW                                          
MFA-TR*         FROM CSS_MSTSUB_ACCT                                            
MFA-TR*        WHERE SUB_ACCT_NO  = :WS-ACCOUNT-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T18995     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
T18995     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T18995        CONTINUE                                                  
T18995     ELSE                                                         
T18995        MOVE 'MU'                 TO WS-DB2-TABLE-ID              
T18995        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
T18995        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T18995        MOVE '114'                TO WS-DB2-MODULE-ID             
T18995        MOVE '7000'               TO WS-DB2-PARAGRAPH             
T18995        MOVE WS-ACCOUNT-NO        TO WS-DB2-KEY-1N                
T18995        MOVE 12 TO RETURN-CODE                                    
T18995        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
T18995     END-IF.                                                      
T18995 7000-EXIT.                                                       
T18995     EXIT.                                                        
      *                                                                         
       7100-GET-CURRENT-TIMESTAMP.                                      
           EXEC SQL                                                     
T33182        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP                                    
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP =                                       
MFA-TR*            CURRENT TIMESTAMP                                            
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       7100-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       7210-SELECT-BILLING-HDR.                                         
           EXEC SQL                                                     
              SELECT DATE_BILLED,                                       
                     CODE_BILL_REASON,                                  
                     CODE_BILL_STATUS,                                  
                     CODE_BILL_TYPE,                                    
                     CUSTOMER_NO,                                       
                     PREMISE_NO,                                        
                     CODE_SPCL_BILL,                                    
                     PREM_ACCT_SEQ_NO,                                  
                     COMPANY_NO                                         
                INTO :BI-DATE-BILLED :WS-NULL-IND,                      
                     :BI-CODE-BILL-REASON,                              
                     :BI-CODE-BILL-STATUS,                              
                     :BI-CODE-BILL-TYPE,                                
                     :BI-CUSTOMER-NO,                                   
                     :BI-PREMISE-NO,                                    
                     :BI-CODE-SPCL-BILL,                                
                     :BI-PREM-ACCT-SEQ-NO,                              
                     :BI-COMPANY-NO                                     
                FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :BI-ACCOUNT-NO                        
                 AND BILL_NO    = :BI-BILL-NO                           
T33182                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_BILLED,                                               
MFA-TR*              CODE_BILL_REASON,                                          
MFA-TR*              CODE_BILL_STATUS,                                          
MFA-TR*              CODE_BILL_TYPE,                                            
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              CODE_SPCL_BILL,                                            
MFA-TR*              PREM_ACCT_SEQ_NO,                                          
MFA-TR*              COMPANY_NO                                                 
MFA-TR*         INTO :BI-DATE-BILLED :WS-NULL-IND,                              
MFA-TR*              :BI-CODE-BILL-REASON,                                      
MFA-TR*              :BI-CODE-BILL-STATUS,                                      
MFA-TR*              :BI-CODE-BILL-TYPE,                                        
MFA-TR*              :BI-CUSTOMER-NO,                                           
MFA-TR*              :BI-PREMISE-NO,                                            
MFA-TR*              :BI-CODE-SPCL-BILL,                                        
MFA-TR*              :BI-PREM-ACCT-SEQ-NO,                                      
MFA-TR*              :BI-COMPANY-NO                                             
MFA-TR*         FROM CSS_BILLING_HDR                                            
MFA-TR*        WHERE ACCOUNT_NO = :BI-ACCOUNT-NO                                
MFA-TR*          AND BILL_NO    = :BI-BILL-NO                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF  WS-NULL-IND < ZERO                                    
                  MOVE LOW-VALUES         TO BI-DATE-BILLED             
              END-IF                                                    
           ELSE                                                         
              MOVE 'BI'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7210'               TO WS-DB2-PARAGRAPH             
              MOVE BI-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BI-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
DC     7250-SELECT-ANNUAL-SUMMARY.                                      
DC                                                                      
DC         MOVE WS-REV-MONTH-YYYY           TO AS-SUMMARY-YEAR.         
DC         MOVE BG-ACCOUNT-NO               TO AS-ACCOUNT-NO.           
DC         MOVE BG-IC-NO                    TO AS-IC-NO.                
DC         MOVE BG-CODE-UTIL-TYPE           TO AS-CODE-UTIL-TYPE.       
DC                                                                      
DC         EXEC SQL                                                     
DC             SELECT SUMMARY_YEAR,      ACCOUNT_NO,                    
DC                    IC_NO,             CODE_UTIL_TYPE,                
                      TOTAL_USAGE,                                      
                      NO_DAYS,                                          
                      TOTAL_REVENUE                                     
DC             INTO  :AS-SUMMARY-YEAR,  :AS-ACCOUNT-NO,                 
DC                   :AS-IC-NO,         :AS-CODE-UTIL-TYPE,             
                     :AS-TOTAL-USAGE,                                   
                     :AS-NO-DAYS,                                       
                     :AS-TOTAL-REVENUE                                  
DC             FROM   CSS_ANNUAL_SUMMARY WITH(READUNCOMMITTED)                  
DC             WHERE  SUMMARY_YEAR   = :AS-SUMMARY-YEAR   AND           
DC                    ACCOUNT_NO     = :AS-ACCOUNT-NO     AND           
DC                    IC_NO          = :AS-IC-NO          AND           
DC                    CODE_UTIL_TYPE = :AS-CODE-UTIL-TYPE               
T33182                                                           
DC         END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUMMARY_YEAR,      ACCOUNT_NO,                            
MFA-TR*               IC_NO,             CODE_UTIL_TYPE,                        
MFA-TR*               TOTAL_USAGE,                                              
MFA-TR*               NO_DAYS,                                                  
MFA-TR*               TOTAL_REVENUE                                             
MFA-TR*        INTO  :AS-SUMMARY-YEAR,  :AS-ACCOUNT-NO,                         
MFA-TR*              :AS-IC-NO,         :AS-CODE-UTIL-TYPE,                     
MFA-TR*              :AS-TOTAL-USAGE,                                           
MFA-TR*              :AS-NO-DAYS,                                               
MFA-TR*              :AS-TOTAL-REVENUE                                          
MFA-TR*        FROM   CSS_ANNUAL_SUMMARY                                        
MFA-TR*        WHERE  SUMMARY_YEAR   = :AS-SUMMARY-YEAR   AND                   
MFA-TR*               ACCOUNT_NO     = :AS-ACCOUNT-NO     AND                   
MFA-TR*               IC_NO          = :AS-IC-NO          AND                   
MFA-TR*               CODE_UTIL_TYPE = :AS-CODE-UTIL-TYPE                       
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

DC                                                                      
DC         IF SQLCODE = SUCCESSFUL-CALL                                 
DC            NEXT SENTENCE                                             
DC         ELSE                                                         
DC         IF SQLCODE = NOT-FOUND                                       
DC            MOVE ZEROS                    TO AS-TOTAL-USAGE           
DC                                             AS-NO-DAYS               
DC                                             AS-TOTAL-REVENUE         
DC         ELSE                                                         
DC            MOVE 'AS'                     TO WS-DB2-TABLE-ID          
DC            MOVE 'SELECT'                 TO WS-DB2-FUNCTION          
DC            MOVE SQLCODE                  TO WS-DB2-RETURN-CODE       
DC            MOVE '114'                    TO WS-DB2-MODULE-ID         
DC            MOVE '7250'                   TO WS-DB2-PARAGRAPH         
DC            MOVE AS-SUMMARY-YEAR          TO WS-DB2-KEY-1N            
DC            MOVE AS-ACCOUNT-NO            TO WS-DB2-KEY-2N            
DC            MOVE 12 TO RETURN-CODE                                    
DC            PERFORM 9900-SQL-ERROR        THRU 9900-EXIT              
DC         END-IF
           END-IF.                                                      
DC                                                                      
DC     7250-EXIT.                                                       
DC         EXIT.                                                        
DC    /                                                                         
       7300-GET-TIMESTAMP.                                              
           EXEC SQL                                                     
T33182        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO =                                       
MFA-TR*            CURRENT TIMESTAMP                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'MH'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7300'               TO WS-DB2-PARAGRAPH             
              MOVE MH-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7350-SELECT-MASTER-AT.                                           
           EXEC SQL                                                     
              SELECT ACCT_XFER_TO,                                      
                     NXT_BILL_NO                                        
                INTO :AT-ACCT-XFER-TO,                                  
                     :AT-NXT-BILL-NO                                    
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
T33182                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCT_XFER_TO,                                              
MFA-TR*              NXT_BILL_NO                                                
MFA-TR*         INTO :AT-ACCT-XFER-TO,                                          
MFA-TR*              :AT-NXT-BILL-NO                                            
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AT'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7350'               TO WS-DB2-PARAGRAPH             
              MOVE AT-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7410-COUNT-BILLING-DET.                                          
           EXEC SQL                                                     
                SELECT 1 INTO  :WS-ROW-COUNT                            
                FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                      
                WHERE   ACCOUNT_NO     = :BG-ACCOUNT-NO       AND       
                        BILL_NO        = :BG-BILL-NO          AND       
                        CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE   AND       
                        IC_NO          = :BG-IC-NO                      
T33182                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 1 INTO  :WS-ROW-COUNT                                    
MFA-TR*         FROM CSS_BILLING_DET                                            
MFA-TR*         WHERE   ACCOUNT_NO     = :BG-ACCOUNT-NO       AND               
MFA-TR*                 BILL_NO        = :BG-BILL-NO          AND               
MFA-TR*                 CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE   AND               
MFA-TR*                 IC_NO          = :BG-IC-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 'BG'                 TO WS-DB2-TABLE-ID              
              MOVE 'COUNT '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7410'               TO WS-DB2-PARAGRAPH             
              MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BG-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE BG-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE BG-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7410-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       7420-OPEN-BILLING-DET.                                           
           EXEC SQL                                                     
                OPEN BILLING_DET                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'BG'                 TO WS-DB2-TABLE-ID              
              MOVE 'OPEN  '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7420'               TO WS-DB2-PARAGRAPH             
              MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BG-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7420-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       7430-FETCH-BILLING-DET.                                          
           EXEC SQL                                                     
                FETCH BILLING_DET  INTO                                 
                   :BG-BILL-ITEM-TIMESTMP                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                 OR NOT-FOUND                                           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'BG'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7430'               TO WS-DB2-PARAGRAPH             
              MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BG-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7430-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       7440-CLOSE-BILLING-DET.                                          
           EXEC SQL                                                     
                CLOSE BILLING_DET                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'BG'                 TO WS-DB2-TABLE-ID              
              MOVE 'CLOSE '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7440'               TO WS-DB2-PARAGRAPH             
              MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BG-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7440-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       7450-COUNT-BILLING-DET.                                          
           EXEC SQL                                                     
                SELECT 1 INTO  :WS-ROW-COUNT                            
                FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                      
                WHERE   ACCOUNT_NO     = :BG-ACCOUNT-NO       AND       
                        BILL_NO        = :BG-BILL-NO                    
T33182                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 1 INTO  :WS-ROW-COUNT                                    
MFA-TR*         FROM CSS_BILLING_DET                                            
MFA-TR*         WHERE   ACCOUNT_NO     = :BG-ACCOUNT-NO       AND               
MFA-TR*                 BILL_NO        = :BG-BILL-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 'BG'                 TO WS-DB2-TABLE-ID              
              MOVE 'COUNT '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7450'               TO WS-DB2-PARAGRAPH             
              MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BG-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7450-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      /                                                                         
       7510-COUNT-UM-CNSMPT-HIST.                                       
           EXEC SQL                                                     
                SELECT 1 INTO  :WS-ROW-COUNT                            
                FROM CSS_UM_CNSMPT_HIST WITH(READUNCOMMITTED)                   
                WHERE   ACCOUNT_NO      = :UC-ACCOUNT-NO                
                  AND   BILL_NO         = :UC-BILL-NO                   
                  AND   CODE_UTIL_TYPE  = :UC-CODE-UTIL-TYPE            
                  AND   IC_NO           = :UC-IC-NO                     
                  AND   BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :UC-BILL-ITEM-TIMESTMP
              )     
T33182                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 1 INTO  :WS-ROW-COUNT                                    
MFA-TR*         FROM CSS_UM_CNSMPT_HIST                                         
MFA-TR*         WHERE   ACCOUNT_NO      = :UC-ACCOUNT-NO                        
MFA-TR*           AND   BILL_NO         = :UC-BILL-NO                           
MFA-TR*           AND   CODE_UTIL_TYPE  = :UC-CODE-UTIL-TYPE                    
MFA-TR*           AND   IC_NO           = :UC-IC-NO                             
MFA-TR*           AND   BILL_ITEM_TIMESTMP = :UC-BILL-ITEM-TIMESTMP             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 'UC'                 TO WS-DB2-TABLE-ID              
              MOVE 'COUNT '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7510'               TO WS-DB2-PARAGRAPH             
              MOVE UC-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UC-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE UC-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE UC-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7510-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       7600-GET-BZ.                                                     
           EXEC SQL                                                     
              SELECT READ_UNITS,                                        
                     BILL_UNITS,                                        
                     NET_UNIT_SEL_RSN,                                  
                     CALC_COMP_AM,                                      
                     BILLED_COMP_AM,                                    
T23301               WNA_COMP_AM,                                       
CIG                  UNIT_PRICE_AM                                      
               INTO  :BZ-READ-UNITS,                                    
                     :BZ-BILL-UNITS,                                    
                     :BZ-NET-UNIT-SEL-RSN,                              
                     :BZ-CALC-COMP-AM,                                  
                     :BZ-BILLED-COMP-AM,                                
T23301               :BZ-WNA-COMP-AM,                                   
CIG                  :BZ-UNIT-PRICE-AM                                  
               FROM CSS_BILL_CALC_DET WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO         = :BZ-ACCOUNT-NO                
                 AND BILL_NO            = :BZ-BILL-NO                   
                 AND CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE            
                 AND IC_NO              = :BZ-IC-NO                     
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BZ-BILL-ITEM-TIMESTMP
              )        
                 AND CMPNT_ID_CD        = :BZ-CMPNT-ID-CD               
                 AND INSTR_USE_TYPE_CD  = :BZ-INSTR-USE-TYPE-CD         
                 AND CODE_TIME_PERIOD   = :BZ-CODE-TIME-PERIOD          
                 AND CODE_SEASON        = :BZ-CODE-SEASON               
                 AND CONSUMPT_TYPE_CD   = :BZ-CONSUMPT-TYPE-CD          
T33182                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT READ_UNITS,                                                
MFA-TR*              BILL_UNITS,                                                
MFA-TR*              NET_UNIT_SEL_RSN,                                          
MFA-TR*              CALC_COMP_AM,                                              
MFA-TR*              BILLED_COMP_AM,                                            
MFA-TR*              WNA_COMP_AM,                                               
MFA-TR*              UNIT_PRICE_AM                                              
MFA-TR*        INTO  :BZ-READ-UNITS,                                            
MFA-TR*              :BZ-BILL-UNITS,                                            
MFA-TR*              :BZ-NET-UNIT-SEL-RSN,                                      
MFA-TR*              :BZ-CALC-COMP-AM,                                          
MFA-TR*              :BZ-BILLED-COMP-AM,                                        
MFA-TR*              :BZ-WNA-COMP-AM,                                           
MFA-TR*              :BZ-UNIT-PRICE-AM                                          
MFA-TR*        FROM CSS_BILL_CALC_DET                                           
MFA-TR*        WHERE ACCOUNT_NO         = :BZ-ACCOUNT-NO                        
MFA-TR*          AND BILL_NO            = :BZ-BILL-NO                           
MFA-TR*          AND CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE                    
MFA-TR*          AND IC_NO              = :BZ-IC-NO                             
MFA-TR*          AND BILL_ITEM_TIMESTMP = :BZ-BILL-ITEM-TIMESTMP                
MFA-TR*          AND CMPNT_ID_CD        = :BZ-CMPNT-ID-CD                       
MFA-TR*          AND INSTR_USE_TYPE_CD  = :BZ-INSTR-USE-TYPE-CD                 
MFA-TR*          AND CODE_TIME_PERIOD   = :BZ-CODE-TIME-PERIOD                  
MFA-TR*          AND CODE_SEASON        = :BZ-CODE-SEASON                       
MFA-TR*          AND CONSUMPT_TYPE_CD   = :BZ-CONSUMPT-TYPE-CD                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE ZERO TO  BZ-READ-UNITS                            
                               BZ-BILL-UNITS                            
                               BZ-CALC-COMP-AM                          
                               BZ-BILLED-COMP-AM                        
T23301                         BZ-WNA-COMP-AM                           
CIG                            BZ-UNIT-PRICE-AM                         
TP3309*          MOVE SPACE TO BZ-CONSUMPT-TYPE-CD                              
                 MOVE SPACE TO BZ-NET-UNIT-SEL-RSN                      
              WHEN OTHER                                                
                 MOVE 'BZ'                 TO WS-DB2-TABLE-ID           
                 MOVE 'INSERT'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '114'                TO WS-DB2-MODULE-ID          
                 MOVE '8150'               TO WS-DB2-PARAGRAPH          
                 MOVE BZ-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE BZ-BILL-NO           TO WS-DB2-KEY-2N             
                 MOVE BZ-CODE-UTIL-TYPE    TO WS-DB2-KEY-3              
                 MOVE BZ-IC-NO             TO WS-DB2-KEY-4N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       7700-COUNT-CNSMPTN-HIST.                                         
           EXEC SQL                                                     
                SELECT 1 INTO  :WS-ROW-COUNT                            
                FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                     
                WHERE   ACCOUNT_NO      = :CX-ACCOUNT-NO                
                  AND   BILL_NO         = :CX-BILL-NO                   
                  AND   CODE_UTIL_TYPE  = :CX-CODE-UTIL-TYPE            
                  AND   IC_NO           = :CX-IC-NO                     
                  AND   BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )     
T33182                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 1 INTO  :WS-ROW-COUNT                                    
MFA-TR*         FROM CSS_CNSMPTN_HIST                                           
MFA-TR*         WHERE   ACCOUNT_NO      = :CX-ACCOUNT-NO                        
MFA-TR*           AND   BILL_NO         = :CX-BILL-NO                           
MFA-TR*           AND   CODE_UTIL_TYPE  = :CX-CODE-UTIL-TYPE                    
MFA-TR*           AND   IC_NO           = :CX-IC-NO                             
MFA-TR*           AND   BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 'CX'                 TO WS-DB2-TABLE-ID              
              MOVE 'COUNT '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7700'               TO WS-DB2-PARAGRAPH             
              MOVE CX-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE CX-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE CX-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE CX-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7700-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       7810-OPEN-BILLING-DETAIL.                                        
           EXEC SQL                                                     
                OPEN BILLING_DETAIL                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'BG'                 TO WS-DB2-TABLE-ID              
              MOVE 'OPEN  '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7810'               TO WS-DB2-PARAGRAPH             
              MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BG-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7812-FETCH-BILLING-DETAIL.                                       
           EXEC SQL                                                     
                FETCH BILLING_DETAIL  INTO                              
                  :BG-ACCOUNT-NO,         :BG-BILL-NO,                  
                  :BG-CODE-UTIL-TYPE,     :BG-IC-NO,                    
                  :BG-BILL-ITEM-TIMESTMP,                               
                  :BG-DATE-ORIG-BILL,                                   
                  :BG-AMT-BILL-ITEM,      :BG-CODE-BILL-CALC,           
                  :BG-CODE-BILL-ITM-TYPE, :BG-CODE-BILL-ITM-IND,        
                  :BG-CODE-DR-CR-CNSMPTN, :BG-AMT-STATE-TAX,            
                  :BG-AMT-CITY-TAX,       :BG-AMT-OTHER-TAX,            
                  :BG-CODE-REVENUE-CLASS,                               
                  :BG-CODE-SIC-NO,        :BG-RATE-PLAN-NO,             
                  :BG-CODE-CURTAIL-PRTY,  :BG-CODE-STAT-TAX-XMT,        
                  :BG-CODE-CITY-TAX-XMT,  :BG-CODE-OTHR-TAX-XMT,        
                  :BG-BTU-FACTOR,         :BG-WNA-FACTOR,               
                  :BG-GAS-BASE-USE,                                     
                  :BG-REVENUE-MONTH,                                    
C29528            :BG-CITY-TAX-RATE,                                    
C29528            :BG-STATE-TAX-RATE,                                   
C34569            :BG-RT-PKG-OPT-SEQ-NO,                                
C33968            :BG-NAICS-CD                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'BG'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7812'               TO WS-DB2-PARAGRAPH             
              MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BG-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7812-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7814-CLOSE-BILLING-DETAIL.                                       
           EXEC SQL                                                     
                CLOSE BILLING_DETAIL                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'BG'                 TO WS-DB2-TABLE-ID              
              MOVE 'CLOSE '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7814'               TO WS-DB2-PARAGRAPH             
              MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BG-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7814-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       7820-OPEN-UM-CNSMPT-HIST.                                        
           EXEC SQL                                                     
                OPEN UM_CNSMPT_HIST                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'UM'                 TO WS-DB2-TABLE-ID              
              MOVE 'OPEN  '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7820'               TO WS-DB2-PARAGRAPH             
              MOVE UC-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UC-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE UC-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE UC-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7822-FETCH-UM-CNSMPT-HIST.                                       
           EXEC SQL                                                     
                FETCH UM_CNSMPT_HIST  INTO                              
                  :UC-ACCOUNT-NO,                                       
                  :UC-BILL-NO,                                          
                  :UC-CODE-UTIL-TYPE,                                   
                  :UC-IC-NO,                                            
                  :UC-BILL-ITEM-TIMESTMP,                               
                  :UC-ITEM-SEQ-NO,                                      
                  :UC-NO-UNITS,                                         
                  :UC-NO-DAYS,                                          
                  :UC-CODE-DEBIT-CREDIT,                                
                  :UC-USAGE-FIXED,                                      
                  :UC-DATE-USAGE-ENDS,                                  
                  :UC-CODE-SERVICE-TYPE,                                
                  :UC-CODE-ITEM-STATUS,                                 
                  :UC-CODE-SOURCE-ID,                                   
                  :UC-MTHLY-AMOUNT-FIXED,                               
                  :UC-DIST-NO,                                          
                  :UC-LIGHT-NO,                                         
                  :UC-POLE-NO                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'UM'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7822'               TO WS-DB2-PARAGRAPH             
              MOVE UC-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UC-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE UC-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE UC-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7822-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7824-CLOSE-UM-CNSMPT-HIST.                                       
           EXEC SQL                                                     
                CLOSE UM_CNSMPT_HIST                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'UM'                 TO WS-DB2-TABLE-ID              
              MOVE 'CLOSE '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7824'               TO WS-DB2-PARAGRAPH             
              MOVE UC-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UC-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE UC-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE UC-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7824-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       7830-OPEN-CNSMPTN-HIST.                                          
           EXEC SQL                                                     
                OPEN CNSMPTN_HIST                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CX'                 TO WS-DB2-TABLE-ID              
              MOVE 'OPEN  '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7830'               TO WS-DB2-PARAGRAPH             
              MOVE CX-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE CX-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE CX-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE CX-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7830-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7832-FETCH-CNSMPTN-HIST.                                         
           EXEC SQL                                                     
                FETCH CNSMPTN_HIST  INTO                                
                  :CX-ACCOUNT-NO,         :CX-BILL-NO,                  
                  :CX-CODE-UTIL-TYPE,     :CX-IC-NO,                    
                  :CX-BILL-ITEM-TIMESTMP,                               
                  :CX-CODE-TIME-PERIOD,   :CX-MTR-REF-NO,               
                  :CX-CODE-USAGE-TYPE,    :CX-CODE-USAGE-ID,            
                  :CX-CODE-USAGE-SOURCE,  :CX-ITEM-SEQ-NO,              
                  :CX-METER-NO,                                         
                  :CX-REG-ID-NO,          :CX-DATE-READ,                
                  :CX-CODE-METER-READ,    :CX-CODE-METER-NO-READ,       
                  :CX-METER-READING,      :CX-DEMAND-READING,           
                  :CX-EMPLOYEE-NO,        :CX-NO-UNITS,                 
                  :CX-NO-DEMAND-UNITS,    :CX-NO-DAYS,                  
                  :CX-CODE-SOURCE-ID,     :CX-CODE-DEBIT-CREDIT,        
                  :CX-CODE-ITEM-STATUS,   :CX-CODE-DISCOUNT,            
                  :CX-CONSTANT,                                         
                  :CX-NO-DIALS,                                         
                  :CX-COMPANY-NO,                                       
                  :CX-EXCEPT-OVERRIDE-CD,                               
                  :CX-REQUESTED-USAGE,                                  
                  :CX-DIGTL-INTRL-MTR-NO,                               
                  :CX-DIGTL-MTR-TYPE,                                   
                  :CX-CODE-TOU-SEASN,                                   
                  :CX-EXCL-DMD-RCHT-IND                                 
A03446           ,:CX-PEAK-DEMAND-DT :WS-NULL-IND-33                    
A03446           ,:CX-PRV-MTR-RD-COMB-FL                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A03446         IF WS-NULL-IND-33 < ZERO                                 
A03446             MOVE LOW-VALUES TO CX-PEAK-DEMAND-DT                 
A03446         END-IF                                                   
           ELSE                                                         
              MOVE 'CX'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7832'               TO WS-DB2-PARAGRAPH             
              MOVE CX-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE CX-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE CX-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE CX-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7832-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7834-CLOSE-CNSMPTN-HIST.                                         
           EXEC SQL                                                     
                CLOSE CNSMPTN_HIST                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CX'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '7834'               TO WS-DB2-PARAGRAPH             
              MOVE CX-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE CX-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE CX-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE CX-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       7834-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
T4940 *                                                                         
T4940  8000-INSERT-BILL-ACCT-XFER.                                      
T4940      EXEC SQL                                                     
T4940           INSERT  INTO  CSS_BILL_ACCT_XFER                        
T4940             (ACCOUNT_NO,                                          
T4940              BILL_NO,                                             
T4940              CODE_UTIL_TYPE,                                      
T4940              IC_NO,                                               
T4940              BILL_ITEM_TIMESTMP,                                  
T4940              ACCT_XFER_FROM,                                      
T4940              BILL_NO_XFER_FROM)                                   
T4940          VALUES                                                   
T4940             (:AF-ACCOUNT-NO,                                      
T4940              :AF-BILL-NO,                                         
T4940              :AF-CODE-UTIL-TYPE,                                  
T4940              :AF-IC-NO,                                           
T4940              CIS.CHAR2TIMESTAMP(:AF-BILL-ITEM-TIMESTMP),                  
T4940              :AF-ACCT-XFER-FROM,                                  
T4940              :AF-BILL-NO-XFER-FROM)                               
T4940      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT  INTO  CSS_BILL_ACCT_XFER                                
MFA-TR*           (ACCOUNT_NO,                                                  
MFA-TR*            BILL_NO,                                                     
MFA-TR*            CODE_UTIL_TYPE,                                              
MFA-TR*            IC_NO,                                                       
MFA-TR*            BILL_ITEM_TIMESTMP,                                          
MFA-TR*            ACCT_XFER_FROM,                                              
MFA-TR*            BILL_NO_XFER_FROM)                                           
MFA-TR*        VALUES                                                           
MFA-TR*           (:AF-ACCOUNT-NO,                                              
MFA-TR*            :AF-BILL-NO,                                                 
MFA-TR*            :AF-CODE-UTIL-TYPE,                                          
MFA-TR*            :AF-IC-NO,                                                   
MFA-TR*            :AF-BILL-ITEM-TIMESTMP,                                      
MFA-TR*            :AF-ACCT-XFER-FROM,                                          
MFA-TR*            :AF-BILL-NO-XFER-FROM)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T4940      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T4940      IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
T17130       AND WS-ACTIVE-RETURN-CODE NOT = ALREADY-EXISTS             
T4940         MOVE 'AF'                 TO WS-DB2-TABLE-ID              
T4940         MOVE 'INSERT'             TO WS-DB2-FUNCTION              
T4940         MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T4940         MOVE '114'                TO WS-DB2-MODULE-ID             
T4940         MOVE '8000'               TO WS-DB2-PARAGRAPH             
T4940         MOVE AF-ACCOUNT-NO        TO WS-DB2-KEY-1N                
T4940         MOVE AF-BILL-NO           TO WS-DB2-KEY-2N                
T4940         MOVE AF-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
T4940         MOVE AF-IC-NO             TO WS-DB2-KEY-4N                
T4940         MOVE 12 TO RETURN-CODE                                    
T4940         PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
T4940      END-IF.                                                      
T4940  8000-EXIT.                                                       
T4940      EXIT.                                                        
       8110-UPDATE-PREMISE.                                             
           EXEC SQL                                                     
                UPDATE CSS_PREMISE                                      
                   SET DATE_SPCL_MSG_ENDS = NULL,                       
                       SPCL_READ_INSTR    = :PR-SPCL-READ-INSTR         
                 WHERE PREMISE_NO         = :PR-PREMISE-NO              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'PR'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8110'               TO WS-DB2-PARAGRAPH             
              MOVE PR-PREMISE-NO        TO WS-DB2-KEY-1N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8110-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8120-UPDATE-REGISTER-READ.                                       
           IF RG-LAST-REG-READ-TM = LOW-VALUES                          
              MOVE -1 TO WS-NULL-IND-1                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-1                                
           END-IF                                                       
                                                                        
           IF RG-LAST-REG-READ-DT = LOW-VALUES                          
              MOVE -1 TO WS-NULL-IND-2                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-2                                
           END-IF                                                       
                                                                        
           IF RG-LAST-VALID-READ-TM = LOW-VALUES                        
              MOVE -1 TO WS-NULL-IND-3                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-3                                
           END-IF                                                       
                                                                        
           IF RG-LAST-VALID-READ-DT = LOW-VALUES                        
              MOVE -1 TO WS-NULL-IND-4                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-4                                
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
                UPDATE  CSS_REGISTER_READ                               
                SET REGISTER_RD_SEQ        =  :RG-REGISTER-RD-SEQ,      
                   CODE_REG_STATUS         =  :RG-CODE-REG-STATUS,      
                   CODE_STATUS_REAS        =  :RG-CODE-STATUS-REAS,     
                   CODE_LAST_REG_READ      =  :RG-CODE-LAST-REG-READ,   
                   LAST_REG_READ_TM        =  CIS.CHAR2TIME(
                                                  :RG-LAST-REG-READ-TM 
                                                         :WS-NULL-IND-1
              ),           
                   LAST_REG_READ_DT        =  IIF(TRY_CONVERT(DATE, 
                                                  :RG-LAST-REG-READ-DT 
                                                         :WS-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :RG-LAST-REG-READ-DT 
                                                         :WS-NULL-IND-2
              ) <> 0) OR (LEN(:RG-LAST-REG-READ-DT :WS-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:RG-LAST-REG-READ-DT 
                                                         :WS-NULL-IND-2
              ), CONVERT(DATE, :RG-LAST-REG-READ-DT :WS-NULL-IND-2) ),         
                   LAST_READ_VALUE         =  :RG-LAST-READ-VALUE,      
                   NEXT_READ_MONTH         =  :RG-NEXT-READ-MONTH,      
                   CODE_CRNT_REG_READ      =  :RG-CODE-CRNT-REG-READ,   
                   CODE_NO_RD_REASON       =  :RG-CODE-NO-RD-REASON,    
                   CODE_LAST_VALID_RD      =  :RG-CODE-LAST-VALID-RD,   
                   LAST_VALID_READ_TM      =  CIS.CHAR2TIME(
                                                :RG-LAST-VALID-READ-TM 
                                                         :WS-NULL-IND-3
              ),           
                   LAST_VALID_READ_DT      =  IIF(TRY_CONVERT(DATE, 
                                                :RG-LAST-VALID-READ-DT 
                                                         :WS-NULL-IND-4
              ) IS NULL OR (PATINDEX('%.%', :RG-LAST-VALID-READ-DT 
                                                         :WS-NULL-IND-4
              ) <> 0) OR (LEN(:RG-LAST-VALID-READ-DT :WS-NULL-IND-4
              ) <> 10), CIS.CHAR2DATE(:RG-LAST-VALID-READ-DT 
                                                         :WS-NULL-IND-4
              ), CONVERT(DATE, :RG-LAST-VALID-READ-DT :WS-NULL-IND-4
              ) ),           
                   LAST_VAL_RD_VALUE       =  :RG-LAST-VAL-RD-VALUE,    
                   SEASONAL_USE_CD         =  :RG-SEASONAL-USE-CD,      
                   LAST_UPDATE_TS          =  CIS.CURRENT$TIMESTAMP()         
                WHERE                                                   
                   ACCOUNT_NO         = :RG-ACCOUNT-NO        AND       
                   CODE_UTIL_TYPE     = :RG-CODE-UTIL-TYPE    AND       
                   IC_NO              = :RG-IC-NO             AND       
                   MTR_REF_NO         = :RG-MTR-REF-NO        AND       
                   REG_ID_NO          = :RG-REG-ID-NO         AND       
                   METER_NO           = :RG-METER-NO          AND       
                   CODE_USAGE_TYPE    = :RG-CODE-USAGE-TYPE   AND       
                   CODE_USAGE_ID      = :RG-CODE-USAGE-ID     AND       
                   CODE_USAGE_SOURCE  = :RG-CODE-USAGE-SOURCE AND       
                   CODE_TIME_PERIOD   = :RG-CODE-TIME-PERIOD  AND       
                   LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :RG-LAST-UPDATE-TS
              )              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE  CSS_REGISTER_READ                                       
MFA-TR*         SET REGISTER_RD_SEQ        =  :RG-REGISTER-RD-SEQ,              
MFA-TR*            CODE_REG_STATUS         =  :RG-CODE-REG-STATUS,              
MFA-TR*            CODE_STATUS_REAS        =  :RG-CODE-STATUS-REAS,             
MFA-TR*            CODE_LAST_REG_READ      =  :RG-CODE-LAST-REG-READ,           
MFA-TR*            LAST_REG_READ_TM        =  :RG-LAST-REG-READ-TM              
MFA-TR*                                       :WS-NULL-IND-1,                   
MFA-TR*            LAST_REG_READ_DT        =  :RG-LAST-REG-READ-DT              
MFA-TR*                                       :WS-NULL-IND-2,                   
MFA-TR*            LAST_READ_VALUE         =  :RG-LAST-READ-VALUE,              
MFA-TR*            NEXT_READ_MONTH         =  :RG-NEXT-READ-MONTH,              
MFA-TR*            CODE_CRNT_REG_READ      =  :RG-CODE-CRNT-REG-READ,           
MFA-TR*            CODE_NO_RD_REASON       =  :RG-CODE-NO-RD-REASON,            
MFA-TR*            CODE_LAST_VALID_RD      =  :RG-CODE-LAST-VALID-RD,           
MFA-TR*            LAST_VALID_READ_TM      =  :RG-LAST-VALID-READ-TM            
MFA-TR*                                       :WS-NULL-IND-3,                   
MFA-TR*            LAST_VALID_READ_DT      =  :RG-LAST-VALID-READ-DT            
MFA-TR*                                       :WS-NULL-IND-4,                   
MFA-TR*            LAST_VAL_RD_VALUE       =  :RG-LAST-VAL-RD-VALUE,            
MFA-TR*            SEASONAL_USE_CD         =  :RG-SEASONAL-USE-CD,              
MFA-TR*            LAST_UPDATE_TS          =  CURRENT TIMESTAMP                 
MFA-TR*         WHERE                                                           
MFA-TR*            ACCOUNT_NO         = :RG-ACCOUNT-NO        AND               
MFA-TR*            CODE_UTIL_TYPE     = :RG-CODE-UTIL-TYPE    AND               
MFA-TR*            IC_NO              = :RG-IC-NO             AND               
MFA-TR*            MTR_REF_NO         = :RG-MTR-REF-NO        AND               
MFA-TR*            REG_ID_NO          = :RG-REG-ID-NO         AND               
MFA-TR*            METER_NO           = :RG-METER-NO          AND               
MFA-TR*            CODE_USAGE_TYPE    = :RG-CODE-USAGE-TYPE   AND               
MFA-TR*            CODE_USAGE_ID      = :RG-CODE-USAGE-ID     AND               
MFA-TR*            CODE_USAGE_SOURCE  = :RG-CODE-USAGE-SOURCE AND               
MFA-TR*            CODE_TIME_PERIOD   = :RG-CODE-TIME-PERIOD  AND               
MFA-TR*            LAST_UPDATE_TS     = :RG-LAST-UPDATE-TS                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 DISPLAY 'TIMESTAMP ERROR'                              
                 MOVE 4 TO RETURN-CODE                                  
                 PERFORM 9999-BAIL-OUT THRU 9999-EXIT                   
              WHEN OTHER                                                
                 MOVE 'RG'                 TO WS-DB2-TABLE-ID           
                 MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '114'                TO WS-DB2-MODULE-ID          
                 MOVE '8120'               TO WS-DB2-PARAGRAPH          
                 MOVE RG-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE RG-CODE-UTIL-TYPE    TO WS-DB2-KEY-2              
                 MOVE RG-IC-NO             TO WS-DB2-KEY-3N             
                 MOVE RG-METER-NO          TO WS-DB2-KEY-4              
                 MOVE RG-CODE-USAGE-TYPE   TO WS-DB2-KEY-4 (11:1)       
                 MOVE RG-CODE-USAGE-ID     TO WS-DB2-KEY-4 (13:1)       
                 MOVE RG-CODE-USAGE-SOURCE TO WS-DB2-KEY-4 (15:1)       
                 MOVE RG-CODE-TIME-PERIOD  TO WS-DB2-KEY-4 (17:1)       
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-EVALUATE.                                                
       8120-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8125-INSERT-REGISTER-READ.                                       
      ***** ADDED 041795                                                        
           IF RG-LAST-REG-READ-TM = LOW-VALUES OR SPACES                
              MOVE -1 TO WS-NULL-IND-1                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-1                                
           END-IF                                                       
                                                                        
           IF RG-LAST-REG-READ-DT = LOW-VALUES OR SPACES                
              MOVE -1 TO WS-NULL-IND-2                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-2                                
           END-IF                                                       
                                                                        
           IF RG-LAST-VALID-READ-TM = LOW-VALUES OR SPACES              
              MOVE -1 TO WS-NULL-IND-3                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-3                                
           END-IF                                                       
                                                                        
           IF RG-LAST-VALID-READ-DT = LOW-VALUES OR SPACES              
              MOVE -1 TO WS-NULL-IND-4                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-4                                
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
                INSERT  INTO  CSS_REGISTER_READ                         
                  (ACCOUNT_NO,                                          
                   CODE_UTIL_TYPE,                                      
                   IC_NO,                                               
                   MTR_REF_NO,                                          
                   REG_ID_NO,                                           
                   METER_NO,                                            
                   CODE_USAGE_TYPE,                                     
                   CODE_USAGE_ID,                                       
                   CODE_USAGE_SOURCE,                                   
                   CODE_TIME_PERIOD,                                    
                   REGISTER_RD_SEQ,                                     
                   CODE_REG_STATUS,                                     
                   CODE_STATUS_REAS,                                    
                   CODE_LAST_REG_READ,                                  
                   LAST_REG_READ_TM,                                    
                   LAST_REG_READ_DT,                                    
                   LAST_READ_VALUE,                                     
                   NEXT_READ_MONTH,                                     
                   CODE_CRNT_REG_READ,                                  
                   CODE_NO_RD_REASON,                                   
                   CODE_LAST_VALID_RD,                                  
                   LAST_VALID_READ_TM,                                  
                   LAST_VALID_READ_DT,                                  
                   LAST_VAL_RD_VALUE,                                   
                   SEASONAL_USE_CD,                                     
                   LAST_UPDATE_TS)                                      
               VALUES                                                   
                  (:RG-ACCOUNT-NO,                                      
                   :RG-CODE-UTIL-TYPE,                                  
                   :RG-IC-NO,                                           
                   :RG-MTR-REF-NO,                                      
                   :RG-REG-ID-NO,                                       
                   :RG-METER-NO,                                        
                   :RG-CODE-USAGE-TYPE,                                 
                   :RG-CODE-USAGE-ID,                                   
                   :RG-CODE-USAGE-SOURCE,                               
                   :RG-CODE-TIME-PERIOD,                                
                   :RG-REGISTER-RD-SEQ,                                 
                   :RG-CODE-REG-STATUS,                                 
                   :RG-CODE-STATUS-REAS,                                
                   :RG-CODE-LAST-REG-READ,                              
                   CIS.CHAR2TIME(:RG-LAST-REG-READ-TM :WS-NULL-IND-1),          
                   IIF(TRY_CONVERT(DATE, :RG-LAST-REG-READ-DT 
                                         :WS-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :RG-LAST-REG-READ-DT 
                                                         :WS-NULL-IND-2
              ) <> 0) OR (LEN(:RG-LAST-REG-READ-DT :WS-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:RG-LAST-REG-READ-DT 
                                                         :WS-NULL-IND-2
              ), CONVERT(DATE, :RG-LAST-REG-READ-DT :WS-NULL-IND-2) ),         
                   :RG-LAST-READ-VALUE,                                 
                   :RG-NEXT-READ-MONTH,                                 
                   :RG-CODE-CRNT-REG-READ,                              
                   :RG-CODE-NO-RD-REASON,                               
                   :RG-CODE-LAST-VALID-RD,                              
                   CIS.CHAR2TIME(:RG-LAST-VALID-READ-TM :WS-NULL-IND-3),        
                   IIF(TRY_CONVERT(DATE, :RG-LAST-VALID-READ-DT 
                                         :WS-NULL-IND-4
              ) IS NULL OR (PATINDEX('%.%', :RG-LAST-VALID-READ-DT 
                                                         :WS-NULL-IND-4
              ) <> 0) OR (LEN(:RG-LAST-VALID-READ-DT :WS-NULL-IND-4
              ) <> 10), CIS.CHAR2DATE(:RG-LAST-VALID-READ-DT 
                                                         :WS-NULL-IND-4
              ), CONVERT(DATE, :RG-LAST-VALID-READ-DT :WS-NULL-IND-4
              ) ),               
                   :RG-LAST-VAL-RD-VALUE,                               
                   :RG-SEASONAL-USE-CD,                                 
                   CIS.CURRENT$TIMESTAMP())                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT  INTO  CSS_REGISTER_READ                                 
MFA-TR*           (ACCOUNT_NO,                                                  
MFA-TR*            CODE_UTIL_TYPE,                                              
MFA-TR*            IC_NO,                                                       
MFA-TR*            MTR_REF_NO,                                                  
MFA-TR*            REG_ID_NO,                                                   
MFA-TR*            METER_NO,                                                    
MFA-TR*            CODE_USAGE_TYPE,                                             
MFA-TR*            CODE_USAGE_ID,                                               
MFA-TR*            CODE_USAGE_SOURCE,                                           
MFA-TR*            CODE_TIME_PERIOD,                                            
MFA-TR*            REGISTER_RD_SEQ,                                             
MFA-TR*            CODE_REG_STATUS,                                             
MFA-TR*            CODE_STATUS_REAS,                                            
MFA-TR*            CODE_LAST_REG_READ,                                          
MFA-TR*            LAST_REG_READ_TM,                                            
MFA-TR*            LAST_REG_READ_DT,                                            
MFA-TR*            LAST_READ_VALUE,                                             
MFA-TR*            NEXT_READ_MONTH,                                             
MFA-TR*            CODE_CRNT_REG_READ,                                          
MFA-TR*            CODE_NO_RD_REASON,                                           
MFA-TR*            CODE_LAST_VALID_RD,                                          
MFA-TR*            LAST_VALID_READ_TM,                                          
MFA-TR*            LAST_VALID_READ_DT,                                          
MFA-TR*            LAST_VAL_RD_VALUE,                                           
MFA-TR*            SEASONAL_USE_CD,                                             
MFA-TR*            LAST_UPDATE_TS)                                              
MFA-TR*        VALUES                                                           
MFA-TR*           (:RG-ACCOUNT-NO,                                              
MFA-TR*            :RG-CODE-UTIL-TYPE,                                          
MFA-TR*            :RG-IC-NO,                                                   
MFA-TR*            :RG-MTR-REF-NO,                                              
MFA-TR*            :RG-REG-ID-NO,                                               
MFA-TR*            :RG-METER-NO,                                                
MFA-TR*            :RG-CODE-USAGE-TYPE,                                         
MFA-TR*            :RG-CODE-USAGE-ID,                                           
MFA-TR*            :RG-CODE-USAGE-SOURCE,                                       
MFA-TR*            :RG-CODE-TIME-PERIOD,                                        
MFA-TR*            :RG-REGISTER-RD-SEQ,                                         
MFA-TR*            :RG-CODE-REG-STATUS,                                         
MFA-TR*            :RG-CODE-STATUS-REAS,                                        
MFA-TR*            :RG-CODE-LAST-REG-READ,                                      
MFA-TR*            :RG-LAST-REG-READ-TM :WS-NULL-IND-1,                         
MFA-TR*            :RG-LAST-REG-READ-DT :WS-NULL-IND-2,                         
MFA-TR*            :RG-LAST-READ-VALUE,                                         
MFA-TR*            :RG-NEXT-READ-MONTH,                                         
MFA-TR*            :RG-CODE-CRNT-REG-READ,                                      
MFA-TR*            :RG-CODE-NO-RD-REASON,                                       
MFA-TR*            :RG-CODE-LAST-VALID-RD,                                      
MFA-TR*            :RG-LAST-VALID-READ-TM :WS-NULL-IND-3,                       
MFA-TR*            :RG-LAST-VALID-READ-DT :WS-NULL-IND-4,                       
MFA-TR*            :RG-LAST-VAL-RD-VALUE,                                       
MFA-TR*            :RG-SEASONAL-USE-CD,                                         
MFA-TR*            CURRENT TIMESTAMP)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'RG'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8125'               TO WS-DB2-PARAGRAPH             
              MOVE RG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE RG-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
              MOVE RG-IC-NO             TO WS-DB2-KEY-3N                
              MOVE RG-METER-NO          TO WS-DB2-KEY-4                 
              MOVE RG-CODE-USAGE-TYPE   TO WS-DB2-KEY-4 (11:1)          
              MOVE RG-CODE-USAGE-ID     TO WS-DB2-KEY-4 (13:1)          
              MOVE RG-CODE-USAGE-SOURCE TO WS-DB2-KEY-4 (15:1)          
              MOVE RG-CODE-TIME-PERIOD  TO WS-DB2-KEY-4 (17:1)          
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8125-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8130-UPDATE-MTRD-ENVRNMT.                                        
      ***** ADDED 041795                                                        
           IF MN-DATE-MTR-INSTALL = LOW-VALUES                          
              MOVE -1 TO WS-NULL-IND-5                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-5                                
           END-IF                                                       
                                                                        
           IF MN-LAST-REG-READ-TIME = LOW-VALUES                        
              MOVE -1 TO WS-NULL-IND-6                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-6                                
           END-IF                                                       
                                                                        
           IF MN-LAST-REG-READ-DATE = LOW-VALUES                        
              MOVE -1 TO WS-NULL-IND-7                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-7                                
           END-IF                                                       
                                                                        
           IF MN-LAST-VALID-READ-TM = LOW-VALUES                        
              MOVE -1 TO WS-NULL-IND-8                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-8                                
           END-IF                                                       
                                                                        
           IF MN-LAST-VALID-READ-DT = LOW-VALUES                        
              MOVE -1 TO WS-NULL-IND-9                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-9                                
           END-IF                                                       
                                                                        
           IF MN-READ-CARD-PRINT-DT = LOW-VALUES                        
              MOVE -1 TO WS-NULL-IND-10                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-10                               
           END-IF                                                       
                                                                        
           IF MN-MTR-STATUS-CHNG-DT = LOW-VALUES                        
              MOVE -1 TO WS-NULL-IND-11                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-11                               
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
                UPDATE  CSS_MTRD_ENVRNMT                                
                  SET                                                   
                   CODE_DISCOUNT       =  :MN-CODE-DISCOUNT,            
                   CODE_METER_LOC      =  :MN-CODE-METER-LOC,           
                   CODE_METER_STATUS   =  :MN-CODE-METER-STATUS,        
                   CODE_STATUS_REAS    =  :MN-CODE-STATUS-REAS,         
                   CODE_ALRT_CHNG_IND  =  :MN-CODE-ALRT-CHNG-IND,       
                   DIST_NODE_POINT     =  :MN-DIST-NODE-POINT,          
                   CODE_DIVERSION      =  :MN-CODE-DIVERSION,           
                   DATE_MTR_INSTALL    =  IIF(TRY_CONVERT(DATE, 
                                                  :MN-DATE-MTR-INSTALL 
                                                         :WS-NULL-IND-5
              ) IS NULL OR (PATINDEX('%.%', :MN-DATE-MTR-INSTALL 
                                                         :WS-NULL-IND-5
              ) <> 0) OR (LEN(:MN-DATE-MTR-INSTALL :WS-NULL-IND-5
              ) <> 10), CIS.CHAR2DATE(:MN-DATE-MTR-INSTALL 
                                                         :WS-NULL-IND-5
              ), CONVERT(DATE, :MN-DATE-MTR-INSTALL :WS-NULL-IND-5) ),         
                   CODE_SPCL_SEAL      =  :MN-CODE-SPCL-SEAL,           
                   EST_USAGE           =  :MN-EST-USAGE,                
                   SPCL_MTR_CONDITION  =  :MN-SPCL-MTR-CONDITION,       
                   CODE_DATA_PRESENT   =  :MN-CODE-DATA-PRESENT,        
                   CODE_USAGE_TYPE     =  :MN-CODE-USAGE-TYPE,          
                   CODE_USAGE_ID       =  :MN-CODE-USAGE-ID,            
                   CODE_USAGE_SOURCE   =  :MN-CODE-USAGE-SOURCE,        
                   REG_ID_NO           =  :MN-REG-ID-NO,                
                   REGISTER_RD_SEQ     =  :MN-REGISTER-RD-SEQ,          
                   CODE_CRNT_REG_READ  =  :MN-CODE-CRNT-REG-READ,       
                   CODE_NO_RD_REASON   =  :MN-CODE-NO-RD-REASON,        
                   CODE_LAST_REG_READ  =  :MN-CODE-LAST-REG-READ,       
                   LAST_REG_READ_TIME  =  CIS.CHAR2TIME(
                                                :MN-LAST-REG-READ-TIME 
                                                        :WS-NULL-IND-6
              ),               
                   LAST_REG_READ_DATE  =  IIF(TRY_CONVERT(DATE, 
                                                :MN-LAST-REG-READ-DATE 
                                                         :WS-NULL-IND-7
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-REG-READ-DATE 
                                                         :WS-NULL-IND-7
              ) <> 0) OR (LEN(:MN-LAST-REG-READ-DATE :WS-NULL-IND-7
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-REG-READ-DATE 
                                                         :WS-NULL-IND-7
              ), CONVERT(DATE, :MN-LAST-REG-READ-DATE :WS-NULL-IND-7
              ) ),               
                   LAST_READ_VALUE     =  :MN-LAST-READ-VALUE,          
                   NO_CONSEC_ESTIMATE  =  :MN-NO-CONSEC-ESTIMATE,       
                   NO_CONSEC_CRD_READ  =  :MN-NO-CONSEC-CRD-READ,       
                   POINT_ID            =  :MN-POINT-ID,                 
                   LOCK_TYPE_ID        =  :MN-LOCK-TYPE-ID,             
                   SEAL_CODE_ID        =  :MN-SEAL-CODE-ID,             
                   HEXAGRAM_LOCATION   =  :MN-HEXAGRAM-LOCATION,        
                   INSULATED_IND       =  :MN-INSULATED-IND,            
                   METER_SUPPLYING     =  :MN-METER-SUPPLYING,          
                   LAST_VALID_READ_TM  =  CIS.CHAR2TIME(
                                                :MN-LAST-VALID-READ-TM 
                                                        :WS-NULL-IND-8
              ),               
                   LAST_VALID_READ_DT  = IIF(TRY_CONVERT(DATE, 
                                                :MN-LAST-VALID-READ-DT 
                                                         :WS-NULL-IND-9
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-VALID-READ-DT 
                                                         :WS-NULL-IND-9
              ) <> 0) OR (LEN(:MN-LAST-VALID-READ-DT :WS-NULL-IND-9
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-VALID-READ-DT 
                                                         :WS-NULL-IND-9
              ), CONVERT(DATE, :MN-LAST-VALID-READ-DT :WS-NULL-IND-9
              ) ),               
                   READ_CARD_PRINT_DT  =  IIF(TRY_CONVERT(DATE, 
                                                :MN-READ-CARD-PRINT-DT 
                                                        :WS-NULL-IND-10
              ) IS NULL OR (PATINDEX('%.%', :MN-READ-CARD-PRINT-DT 
                                                        :WS-NULL-IND-10
              ) <> 0) OR (LEN(:MN-READ-CARD-PRINT-DT :WS-NULL-IND-10
              ) <> 10), CIS.CHAR2DATE(:MN-READ-CARD-PRINT-DT 
                                                        :WS-NULL-IND-10
              ), CONVERT(DATE, :MN-READ-CARD-PRINT-DT :WS-NULL-IND-10
              ) ),              
                   EXCEPT_OVERRIDE_CD  =  :MN-EXCEPT-OVERRIDE-CD,       
                   CODE_MTR_RD_INST1   =  :MN-CODE-MTR-RD-INST1,        
                   CODE_MTR_RD_INST2   =  :MN-CODE-MTR-RD-INST2,        
                   CODE_MTR_RD_INST3   =  :MN-CODE-MTR-RD-INST3,        
                   DIGTL_MTR_TYPE      =  :MN-DIGTL-MTR-TYPE,           
                   REMOTE_READ_IND     =  :MN-REMOTE-READ-IND,          
                   LAST_VAL_RD_VALUE   =  :MN-LAST-VAL-RD-VALUE,        
                   IDR_RECIPIENT_CD    =  :MN-IDR-RECIPIENT-CD,         
                   MTR_READ_SOURCE_CD  =  :MN-MTR-READ-SOURCE-CD,       
                   CODE_LAST_VALID_RD  =  :MN-CODE-LAST-VALID-RD,       
                   LAST_UPDATE_TS      =  CIS.CURRENT$TIMESTAMP(),            
C24056             MTR_STATUS_CHNG_DT  =  IIF(TRY_CONVERT(DATE, 
                                                :MN-MTR-STATUS-CHNG-DT 
                                                        :WS-NULL-IND-10
              ) IS NULL OR (PATINDEX('%.%', :MN-MTR-STATUS-CHNG-DT 
                                                        :WS-NULL-IND-10
              ) <> 0) OR (LEN(:MN-MTR-STATUS-CHNG-DT :WS-NULL-IND-10
              ) <> 10), CIS.CHAR2DATE(:MN-MTR-STATUS-CHNG-DT 
                                                        :WS-NULL-IND-10
              ), CONVERT(DATE, :MN-MTR-STATUS-CHNG-DT :WS-NULL-IND-10
              ) )               
                WHERE                                                   
                   ACCOUNT_NO     = :MN-ACCOUNT-NO      AND             
                   CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE  AND             
                   IC_NO          = :MN-IC-NO           AND             
                   MTR_REF_NO     = :MN-MTR-REF-NO      AND             
                   METER_NO       = :MN-METER-NO        AND             
                   LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :MN-LAST-UPDATE-TS
              )                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE  CSS_MTRD_ENVRNMT                                        
MFA-TR*           SET                                                           
MFA-TR*            CODE_DISCOUNT       =  :MN-CODE-DISCOUNT,                    
MFA-TR*            CODE_METER_LOC      =  :MN-CODE-METER-LOC,                   
MFA-TR*            CODE_METER_STATUS   =  :MN-CODE-METER-STATUS,                
MFA-TR*            CODE_STATUS_REAS    =  :MN-CODE-STATUS-REAS,                 
MFA-TR*            CODE_ALRT_CHNG_IND  =  :MN-CODE-ALRT-CHNG-IND,               
MFA-TR*            DIST_NODE_POINT     =  :MN-DIST-NODE-POINT,                  
MFA-TR*            CODE_DIVERSION      =  :MN-CODE-DIVERSION,                   
MFA-TR*            DATE_MTR_INSTALL    =  :MN-DATE-MTR-INSTALL                  
MFA-TR*                                   :WS-NULL-IND-5,                       
MFA-TR*            CODE_SPCL_SEAL      =  :MN-CODE-SPCL-SEAL,                   
MFA-TR*            EST_USAGE           =  :MN-EST-USAGE,                        
MFA-TR*            SPCL_MTR_CONDITION  =  :MN-SPCL-MTR-CONDITION,               
MFA-TR*            CODE_DATA_PRESENT   =  :MN-CODE-DATA-PRESENT,                
MFA-TR*            CODE_USAGE_TYPE     =  :MN-CODE-USAGE-TYPE,                  
MFA-TR*            CODE_USAGE_ID       =  :MN-CODE-USAGE-ID,                    
MFA-TR*            CODE_USAGE_SOURCE   =  :MN-CODE-USAGE-SOURCE,                
MFA-TR*            REG_ID_NO           =  :MN-REG-ID-NO,                        
MFA-TR*            REGISTER_RD_SEQ     =  :MN-REGISTER-RD-SEQ,                  
MFA-TR*            CODE_CRNT_REG_READ  =  :MN-CODE-CRNT-REG-READ,               
MFA-TR*            CODE_NO_RD_REASON   =  :MN-CODE-NO-RD-REASON,                
MFA-TR*            CODE_LAST_REG_READ  =  :MN-CODE-LAST-REG-READ,               
MFA-TR*            LAST_REG_READ_TIME  =  :MN-LAST-REG-READ-TIME                
MFA-TR*                                   :WS-NULL-IND-6,                       
MFA-TR*            LAST_REG_READ_DATE  =  :MN-LAST-REG-READ-DATE                
MFA-TR*                                   :WS-NULL-IND-7,                       
MFA-TR*            LAST_READ_VALUE     =  :MN-LAST-READ-VALUE,                  
MFA-TR*            NO_CONSEC_ESTIMATE  =  :MN-NO-CONSEC-ESTIMATE,               
MFA-TR*            NO_CONSEC_CRD_READ  =  :MN-NO-CONSEC-CRD-READ,               
MFA-TR*            POINT_ID            =  :MN-POINT-ID,                         
MFA-TR*            LOCK_TYPE_ID        =  :MN-LOCK-TYPE-ID,                     
MFA-TR*            SEAL_CODE_ID        =  :MN-SEAL-CODE-ID,                     
MFA-TR*            HEXAGRAM_LOCATION   =  :MN-HEXAGRAM-LOCATION,                
MFA-TR*            INSULATED_IND       =  :MN-INSULATED-IND,                    
MFA-TR*            METER_SUPPLYING     =  :MN-METER-SUPPLYING,                  
MFA-TR*            LAST_VALID_READ_TM  =  :MN-LAST-VALID-READ-TM                
MFA-TR*                                   :WS-NULL-IND-8,                       
MFA-TR*            LAST_VALID_READ_DT  = :MN-LAST-VALID-READ-DT                 
MFA-TR*                                   :WS-NULL-IND-9,                       
MFA-TR*            READ_CARD_PRINT_DT  =  :MN-READ-CARD-PRINT-DT                
MFA-TR*                                   :WS-NULL-IND-10,                      
MFA-TR*            EXCEPT_OVERRIDE_CD  =  :MN-EXCEPT-OVERRIDE-CD,               
MFA-TR*            CODE_MTR_RD_INST1   =  :MN-CODE-MTR-RD-INST1,                
MFA-TR*            CODE_MTR_RD_INST2   =  :MN-CODE-MTR-RD-INST2,                
MFA-TR*            CODE_MTR_RD_INST3   =  :MN-CODE-MTR-RD-INST3,                
MFA-TR*            DIGTL_MTR_TYPE      =  :MN-DIGTL-MTR-TYPE,                   
MFA-TR*            REMOTE_READ_IND     =  :MN-REMOTE-READ-IND,                  
MFA-TR*            LAST_VAL_RD_VALUE   =  :MN-LAST-VAL-RD-VALUE,                
MFA-TR*            IDR_RECIPIENT_CD    =  :MN-IDR-RECIPIENT-CD,                 
MFA-TR*            MTR_READ_SOURCE_CD  =  :MN-MTR-READ-SOURCE-CD,               
MFA-TR*            CODE_LAST_VALID_RD  =  :MN-CODE-LAST-VALID-RD,               
MFA-TR*            LAST_UPDATE_TS      =  CURRENT TIMESTAMP,                    
MFA-TR*            MTR_STATUS_CHNG_DT  =  :MN-MTR-STATUS-CHNG-DT                
MFA-TR*                                   :WS-NULL-IND-10                       
MFA-TR*         WHERE                                                           
MFA-TR*            ACCOUNT_NO     = :MN-ACCOUNT-NO      AND                     
MFA-TR*            CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE  AND                     
MFA-TR*            IC_NO          = :MN-IC-NO           AND                     
MFA-TR*            MTR_REF_NO     = :MN-MTR-REF-NO      AND                     
MFA-TR*            METER_NO       = :MN-METER-NO        AND                     
MFA-TR*            LAST_UPDATE_TS = :MN-LAST-UPDATE-TS                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 DISPLAY 'TIMESTAMP ERROR'                              
                 MOVE 4 TO RETURN-CODE                                  
                 PERFORM 9999-BAIL-OUT THRU 9999-EXIT                   
              WHEN OTHER                                                
                 MOVE 'MN'                 TO WS-DB2-TABLE-ID           
                 MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '114'                TO WS-DB2-MODULE-ID          
                 MOVE '8130'               TO WS-DB2-PARAGRAPH          
                 MOVE MN-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE MN-CODE-UTIL-TYPE    TO WS-DB2-KEY-2              
                 MOVE MN-IC-NO             TO WS-DB2-KEY-3N             
                 MOVE MN-METER-NO          TO WS-DB2-KEY-4              
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-EVALUATE.                                                
       8130-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8135-INSERT-MTRD-ENVRNMT.                                        
      ***** ADDED 041795                                                        
           IF MN-DATE-MTR-INSTALL = LOW-VALUES  OR SPACES               
              MOVE -1 TO WS-NULL-IND-5                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-5                                
           END-IF                                                       
                                                                        
           IF MN-LAST-REG-READ-TIME = LOW-VALUES OR SPACES              
              MOVE -1 TO WS-NULL-IND-6                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-6                                
           END-IF                                                       
                                                                        
           IF MN-LAST-REG-READ-DATE = LOW-VALUES OR SPACES              
              MOVE -1 TO WS-NULL-IND-7                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-7                                
           END-IF                                                       
                                                                        
           IF MN-LAST-VALID-READ-TM = LOW-VALUES OR SPACES              
              MOVE -1 TO WS-NULL-IND-8                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-8                                
           END-IF                                                       
                                                                        
           IF MN-LAST-VALID-READ-DT = LOW-VALUES OR SPACES              
              MOVE -1 TO WS-NULL-IND-9                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-9                                
           END-IF                                                       
                                                                        
           IF MN-READ-CARD-PRINT-DT = LOW-VALUES OR SPACES              
              MOVE -1 TO WS-NULL-IND-10                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-10                               
           END-IF                                                       
                                                                        
           IF MN-MTR-STATUS-CHNG-DT = LOW-VALUES OR SPACES              
              MOVE -1 TO WS-NULL-IND-11                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-11                               
           END-IF                                                       
                                                                        
            EXEC SQL                                                    
                 INSERT INTO  CSS_MTRD_ENVRNMT                          
                 (ACCOUNT_NO,                                           
                   CODE_UTIL_TYPE,                                      
                   IC_NO,                                               
                   MTR_REF_NO,                                          
                   CODE_TIME_PERIOD,                                    
                   METER_NO,                                            
                   CODE_DISCOUNT,                                       
                   CODE_METER_LOC,                                      
                   CODE_METER_STATUS,                                   
                   CODE_STATUS_REAS,                                    
                   CODE_ALRT_CHNG_IND,                                  
                   DIST_NODE_POINT,                                     
                   CODE_DIVERSION,                                      
                   DATE_MTR_INSTALL,                                    
                   CODE_SPCL_SEAL,                                      
                   EST_USAGE,                                           
                   SPCL_MTR_CONDITION,                                  
                   CODE_DATA_PRESENT,                                   
                   CODE_USAGE_TYPE,                                     
                   CODE_USAGE_ID,                                       
                   CODE_USAGE_SOURCE,                                   
                   REG_ID_NO,                                           
                   REGISTER_RD_SEQ,                                     
                   CODE_CRNT_REG_READ,                                  
                   CODE_NO_RD_REASON,                                   
                   CODE_LAST_REG_READ,                                  
                   LAST_REG_READ_TIME,                                  
                   LAST_REG_READ_DATE,                                  
                   LAST_READ_VALUE,                                     
                   NO_CONSEC_ESTIMATE,                                  
                   NO_CONSEC_CRD_READ,                                  
                   POINT_ID,                                            
                   LOCK_TYPE_ID,                                        
                   SEAL_CODE_ID,                                        
                   HEXAGRAM_LOCATION,                                   
                   INSULATED_IND,                                       
                   METER_SUPPLYING,                                     
                   LAST_VALID_READ_TM,                                  
                   LAST_VALID_READ_DT,                                  
                   READ_CARD_PRINT_DT,                                  
                   EXCEPT_OVERRIDE_CD,                                  
                   CODE_MTR_RD_INST1,                                   
                   CODE_MTR_RD_INST2,                                   
                   CODE_MTR_RD_INST3,                                   
                   DIGTL_MTR_TYPE,                                      
                   REMOTE_READ_IND,                                     
                   LAST_VAL_RD_VALUE,                                   
                   IDR_RECIPIENT_CD,                                    
                   MTR_READ_SOURCE_CD,                                  
                   CODE_LAST_VALID_RD,                                  
                   MTR_STATUS_CHNG_DT,                                  
                   LAST_UPDATE_TS)                                      
                 VALUES                                                 
                 (:MN-ACCOUNT-NO,                                       
                  :MN-CODE-UTIL-TYPE,                                   
                  :MN-IC-NO,                                            
                  :MN-MTR-REF-NO,                                       
                  :MN-CODE-TIME-PERIOD,                                 
                  :MN-METER-NO,                                         
                  :MN-CODE-DISCOUNT,                                    
                  :MN-CODE-METER-LOC,                                   
                  :MN-CODE-METER-STATUS,                                
                  :MN-CODE-STATUS-REAS,                                 
                  :MN-CODE-ALRT-CHNG-IND,                               
                  :MN-DIST-NODE-POINT,                                  
                  :MN-CODE-DIVERSION,                                   
                  IIF(TRY_CONVERT(DATE, :MN-DATE-MTR-INSTALL 
                                        :WS-NULL-IND-5
              ) IS NULL OR (PATINDEX('%.%', :MN-DATE-MTR-INSTALL 
                                                         :WS-NULL-IND-5
              ) <> 0) OR (LEN(:MN-DATE-MTR-INSTALL :WS-NULL-IND-5
              ) <> 10), CIS.CHAR2DATE(:MN-DATE-MTR-INSTALL 
                                                         :WS-NULL-IND-5
              ), CONVERT(DATE, :MN-DATE-MTR-INSTALL :WS-NULL-IND-5) ),         
                  :MN-CODE-SPCL-SEAL,                                   
                  :MN-EST-USAGE,                                        
                  :MN-SPCL-MTR-CONDITION,                               
                  :MN-CODE-DATA-PRESENT,                                
                  :MN-CODE-USAGE-TYPE,                                  
                  :MN-CODE-USAGE-ID,                                    
                  :MN-CODE-USAGE-SOURCE,                                
                  :MN-REG-ID-NO,                                        
                  :MN-REGISTER-RD-SEQ,                                  
KMG*********      CURRENT TIMESTAMP,                                            
                  :MN-CODE-CRNT-REG-READ,                               
                  :MN-CODE-NO-RD-REASON,                                
                  :MN-CODE-LAST-REG-READ,                               
                  CIS.CHAR2TIME(:MN-LAST-REG-READ-TIME :WS-NULL-IND-6),         
                  IIF(TRY_CONVERT(DATE, :MN-LAST-REG-READ-DATE 
                                        :WS-NULL-IND-7
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-REG-READ-DATE 
                                                         :WS-NULL-IND-7
              ) <> 0) OR (LEN(:MN-LAST-REG-READ-DATE :WS-NULL-IND-7
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-REG-READ-DATE 
                                                         :WS-NULL-IND-7
              ), CONVERT(DATE, :MN-LAST-REG-READ-DATE :WS-NULL-IND-7
              ) ),                
                  :MN-LAST-READ-VALUE,                                  
                  :MN-NO-CONSEC-ESTIMATE,                               
                  :MN-NO-CONSEC-CRD-READ,                               
                  :MN-POINT-ID,                                         
                  :MN-LOCK-TYPE-ID,                                     
                  :MN-SEAL-CODE-ID,                                     
                  :MN-HEXAGRAM-LOCATION,                                
                  :MN-INSULATED-IND,                                    
                  :MN-METER-SUPPLYING,                                  
                  CIS.CHAR2TIME(:MN-LAST-VALID-READ-TM :WS-NULL-IND-8),         
                  IIF(TRY_CONVERT(DATE, :MN-LAST-VALID-READ-DT 
                                        :WS-NULL-IND-9
              ) IS NULL OR (PATINDEX('%.%', :MN-LAST-VALID-READ-DT 
                                                         :WS-NULL-IND-9
              ) <> 0) OR (LEN(:MN-LAST-VALID-READ-DT :WS-NULL-IND-9
              ) <> 10), CIS.CHAR2DATE(:MN-LAST-VALID-READ-DT 
                                                         :WS-NULL-IND-9
              ), CONVERT(DATE, :MN-LAST-VALID-READ-DT :WS-NULL-IND-9
              ) ),                
                  IIF(TRY_CONVERT(DATE, :MN-READ-CARD-PRINT-DT 
                                        :WS-NULL-IND-10
              ) IS NULL OR (PATINDEX('%.%', :MN-READ-CARD-PRINT-DT 
                                                        :WS-NULL-IND-10
              ) <> 0) OR (LEN(:MN-READ-CARD-PRINT-DT :WS-NULL-IND-10
              ) <> 10), CIS.CHAR2DATE(:MN-READ-CARD-PRINT-DT 
                                                        :WS-NULL-IND-10
              ), CONVERT(DATE, :MN-READ-CARD-PRINT-DT :WS-NULL-IND-10
              ) ),               
                  :MN-EXCEPT-OVERRIDE-CD,                               
                  :MN-CODE-MTR-RD-INST1,                                
                  :MN-CODE-MTR-RD-INST2,                                
                  :MN-CODE-MTR-RD-INST3,                                
                  :MN-DIGTL-MTR-TYPE,                                   
                  :MN-REMOTE-READ-IND,                                  
                  :MN-LAST-VAL-RD-VALUE,                                
                  :MN-IDR-RECIPIENT-CD,                                 
                  :MN-MTR-READ-SOURCE-CD,                               
                  :MN-CODE-LAST-VALID-RD,                               
                  IIF(TRY_CONVERT(DATE, :MN-MTR-STATUS-CHNG-DT 
                                        :WS-NULL-IND-11
              ) IS NULL OR (PATINDEX('%.%', :MN-MTR-STATUS-CHNG-DT 
                                                        :WS-NULL-IND-11
              ) <> 0) OR (LEN(:MN-MTR-STATUS-CHNG-DT :WS-NULL-IND-11
              ) <> 10), CIS.CHAR2DATE(:MN-MTR-STATUS-CHNG-DT 
                                                        :WS-NULL-IND-11
              ), CONVERT(DATE, :MN-MTR-STATUS-CHNG-DT :WS-NULL-IND-11
              ) ),               
                  CIS.CURRENT$TIMESTAMP())                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO  CSS_MTRD_ENVRNMT                                  
MFA-TR*          (ACCOUNT_NO,                                                   
MFA-TR*            CODE_UTIL_TYPE,                                              
MFA-TR*            IC_NO,                                                       
MFA-TR*            MTR_REF_NO,                                                  
MFA-TR*            CODE_TIME_PERIOD,                                            
MFA-TR*            METER_NO,                                                    
MFA-TR*            CODE_DISCOUNT,                                               
MFA-TR*            CODE_METER_LOC,                                              
MFA-TR*            CODE_METER_STATUS,                                           
MFA-TR*            CODE_STATUS_REAS,                                            
MFA-TR*            CODE_ALRT_CHNG_IND,                                          
MFA-TR*            DIST_NODE_POINT,                                             
MFA-TR*            CODE_DIVERSION,                                              
MFA-TR*            DATE_MTR_INSTALL,                                            
MFA-TR*            CODE_SPCL_SEAL,                                              
MFA-TR*            EST_USAGE,                                                   
MFA-TR*            SPCL_MTR_CONDITION,                                          
MFA-TR*            CODE_DATA_PRESENT,                                           
MFA-TR*            CODE_USAGE_TYPE,                                             
MFA-TR*            CODE_USAGE_ID,                                               
MFA-TR*            CODE_USAGE_SOURCE,                                           
MFA-TR*            REG_ID_NO,                                                   
MFA-TR*            REGISTER_RD_SEQ,                                             
MFA-TR*            CODE_CRNT_REG_READ,                                          
MFA-TR*            CODE_NO_RD_REASON,                                           
MFA-TR*            CODE_LAST_REG_READ,                                          
MFA-TR*            LAST_REG_READ_TIME,                                          
MFA-TR*            LAST_REG_READ_DATE,                                          
MFA-TR*            LAST_READ_VALUE,                                             
MFA-TR*            NO_CONSEC_ESTIMATE,                                          
MFA-TR*            NO_CONSEC_CRD_READ,                                          
MFA-TR*            POINT_ID,                                                    
MFA-TR*            LOCK_TYPE_ID,                                                
MFA-TR*            SEAL_CODE_ID,                                                
MFA-TR*            HEXAGRAM_LOCATION,                                           
MFA-TR*            INSULATED_IND,                                               
MFA-TR*            METER_SUPPLYING,                                             
MFA-TR*            LAST_VALID_READ_TM,                                          
MFA-TR*            LAST_VALID_READ_DT,                                          
MFA-TR*            READ_CARD_PRINT_DT,                                          
MFA-TR*            EXCEPT_OVERRIDE_CD,                                          
MFA-TR*            CODE_MTR_RD_INST1,                                           
MFA-TR*            CODE_MTR_RD_INST2,                                           
MFA-TR*            CODE_MTR_RD_INST3,                                           
MFA-TR*            DIGTL_MTR_TYPE,                                              
MFA-TR*            REMOTE_READ_IND,                                             
MFA-TR*            LAST_VAL_RD_VALUE,                                           
MFA-TR*            IDR_RECIPIENT_CD,                                            
MFA-TR*            MTR_READ_SOURCE_CD,                                          
MFA-TR*            CODE_LAST_VALID_RD,                                          
MFA-TR*            MTR_STATUS_CHNG_DT,                                          
MFA-TR*            LAST_UPDATE_TS)                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (:MN-ACCOUNT-NO,                                               
MFA-TR*           :MN-CODE-UTIL-TYPE,                                           
MFA-TR*           :MN-IC-NO,                                                    
MFA-TR*           :MN-MTR-REF-NO,                                               
MFA-TR*           :MN-CODE-TIME-PERIOD,                                         
MFA-TR*           :MN-METER-NO,                                                 
MFA-TR*           :MN-CODE-DISCOUNT,                                            
MFA-TR*           :MN-CODE-METER-LOC,                                           
MFA-TR*           :MN-CODE-METER-STATUS,                                        
MFA-TR*           :MN-CODE-STATUS-REAS,                                         
MFA-TR*           :MN-CODE-ALRT-CHNG-IND,                                       
MFA-TR*           :MN-DIST-NODE-POINT,                                          
MFA-TR*           :MN-CODE-DIVERSION,                                           
MFA-TR*           :MN-DATE-MTR-INSTALL :WS-NULL-IND-5,                          
MFA-TR*           :MN-CODE-SPCL-SEAL,                                           
MFA-TR*           :MN-EST-USAGE,                                                
MFA-TR*           :MN-SPCL-MTR-CONDITION,                                       
MFA-TR*           :MN-CODE-DATA-PRESENT,                                        
MFA-TR*           :MN-CODE-USAGE-TYPE,                                          
MFA-TR*           :MN-CODE-USAGE-ID,                                            
MFA-TR*           :MN-CODE-USAGE-SOURCE,                                        
MFA-TR*           :MN-REG-ID-NO,                                                
MFA-TR*           :MN-REGISTER-RD-SEQ,                                          
MFA-TR******      CURRENT TIMESTAMP,                                            
MFA-TR*           :MN-CODE-CRNT-REG-READ,                                       
MFA-TR*           :MN-CODE-NO-RD-REASON,                                        
MFA-TR*           :MN-CODE-LAST-REG-READ,                                       
MFA-TR*           :MN-LAST-REG-READ-TIME :WS-NULL-IND-6,                        
MFA-TR*           :MN-LAST-REG-READ-DATE :WS-NULL-IND-7,                        
MFA-TR*           :MN-LAST-READ-VALUE,                                          
MFA-TR*           :MN-NO-CONSEC-ESTIMATE,                                       
MFA-TR*           :MN-NO-CONSEC-CRD-READ,                                       
MFA-TR*           :MN-POINT-ID,                                                 
MFA-TR*           :MN-LOCK-TYPE-ID,                                             
MFA-TR*           :MN-SEAL-CODE-ID,                                             
MFA-TR*           :MN-HEXAGRAM-LOCATION,                                        
MFA-TR*           :MN-INSULATED-IND,                                            
MFA-TR*           :MN-METER-SUPPLYING,                                          
MFA-TR*           :MN-LAST-VALID-READ-TM :WS-NULL-IND-8,                        
MFA-TR*           :MN-LAST-VALID-READ-DT :WS-NULL-IND-9,                        
MFA-TR*           :MN-READ-CARD-PRINT-DT :WS-NULL-IND-10,                       
MFA-TR*           :MN-EXCEPT-OVERRIDE-CD,                                       
MFA-TR*           :MN-CODE-MTR-RD-INST1,                                        
MFA-TR*           :MN-CODE-MTR-RD-INST2,                                        
MFA-TR*           :MN-CODE-MTR-RD-INST3,                                        
MFA-TR*           :MN-DIGTL-MTR-TYPE,                                           
MFA-TR*           :MN-REMOTE-READ-IND,                                          
MFA-TR*           :MN-LAST-VAL-RD-VALUE,                                        
MFA-TR*           :MN-IDR-RECIPIENT-CD,                                         
MFA-TR*           :MN-MTR-READ-SOURCE-CD,                                       
MFA-TR*           :MN-CODE-LAST-VALID-RD,                                       
MFA-TR*           :MN-MTR-STATUS-CHNG-DT :WS-NULL-IND-11,                       
MFA-TR*           CURRENT TIMESTAMP)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'MN'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8135'               TO WS-DB2-PARAGRAPH             
              MOVE MN-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE MN-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
              MOVE MN-IC-NO             TO WS-DB2-KEY-3N                
              MOVE MN-METER-NO          TO WS-DB2-KEY-4                 
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8135-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8150-INSERT-BILL-CALC-DET.                                       
                                                                        
           EXEC SQL                                                     
                INSERT  INTO  CSS_BILL_CALC_DET                         
                  (ACCOUNT_NO,                                          
                   BILL_NO,                                             
                   CODE_UTIL_TYPE,                                      
                   IC_NO,                                               
                   BILL_ITEM_TIMESTMP,                                  
                   CMPNT_ID_CD,                                         
                   INSTR_USE_TYPE_CD,                                   
                   CODE_TIME_PERIOD,                                    
                   CODE_SEASON,                                         
                   READ_UNITS,                                          
                   BILL_UNITS,                                          
                   CONSUMPT_TYPE_CD,                                    
                   NET_UNIT_SEL_RSN,                                    
                   CALC_COMP_AM,                                        
                   BILLED_COMP_AM,                                      
T23301             WNA_COMP_AM,                                         
CIG                UNIT_PRICE_AM)                                       
               VALUES                                                   
                  (:BZ-ACCOUNT-NO,                                      
                   :BZ-BILL-NO,                                         
                   :BZ-CODE-UTIL-TYPE,                                  
                   :BZ-IC-NO,                                           
                   CIS.CHAR2TIMESTAMP(:BZ-BILL-ITEM-TIMESTMP),                  
                   :BZ-CMPNT-ID-CD,                                     
                   :BZ-INSTR-USE-TYPE-CD,                               
                   :BZ-CODE-TIME-PERIOD,                                
                   :BZ-CODE-SEASON,                                     
                   :BZ-READ-UNITS,                                      
                   :BZ-BILL-UNITS,                                      
                   :BZ-CONSUMPT-TYPE-CD,                                
                   :BZ-NET-UNIT-SEL-RSN,                                
                   :BZ-CALC-COMP-AM,                                    
                   :BZ-BILLED-COMP-AM,                                  
T23301             :BZ-WNA-COMP-AM,                                     
CIG                :BZ-UNIT-PRICE-AM)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT  INTO  CSS_BILL_CALC_DET                                 
MFA-TR*           (ACCOUNT_NO,                                                  
MFA-TR*            BILL_NO,                                                     
MFA-TR*            CODE_UTIL_TYPE,                                              
MFA-TR*            IC_NO,                                                       
MFA-TR*            BILL_ITEM_TIMESTMP,                                          
MFA-TR*            CMPNT_ID_CD,                                                 
MFA-TR*            INSTR_USE_TYPE_CD,                                           
MFA-TR*            CODE_TIME_PERIOD,                                            
MFA-TR*            CODE_SEASON,                                                 
MFA-TR*            READ_UNITS,                                                  
MFA-TR*            BILL_UNITS,                                                  
MFA-TR*            CONSUMPT_TYPE_CD,                                            
MFA-TR*            NET_UNIT_SEL_RSN,                                            
MFA-TR*            CALC_COMP_AM,                                                
MFA-TR*            BILLED_COMP_AM,                                              
MFA-TR*            WNA_COMP_AM,                                                 
MFA-TR*            UNIT_PRICE_AM)                                               
MFA-TR*        VALUES                                                           
MFA-TR*           (:BZ-ACCOUNT-NO,                                              
MFA-TR*            :BZ-BILL-NO,                                                 
MFA-TR*            :BZ-CODE-UTIL-TYPE,                                          
MFA-TR*            :BZ-IC-NO,                                                   
MFA-TR*            :BZ-BILL-ITEM-TIMESTMP,                                      
MFA-TR*            :BZ-CMPNT-ID-CD,                                             
MFA-TR*            :BZ-INSTR-USE-TYPE-CD,                                       
MFA-TR*            :BZ-CODE-TIME-PERIOD,                                        
MFA-TR*            :BZ-CODE-SEASON,                                             
MFA-TR*            :BZ-READ-UNITS,                                              
MFA-TR*            :BZ-BILL-UNITS,                                              
MFA-TR*            :BZ-CONSUMPT-TYPE-CD,                                        
MFA-TR*            :BZ-NET-UNIT-SEL-RSN,                                        
MFA-TR*            :BZ-CALC-COMP-AM,                                            
MFA-TR*            :BZ-BILLED-COMP-AM,                                          
MFA-TR*            :BZ-WNA-COMP-AM,                                             
MFA-TR*            :BZ-UNIT-PRICE-AM)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'BZ'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8150'               TO WS-DB2-PARAGRAPH             
              MOVE BZ-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BZ-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE BZ-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE BZ-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8160-UPDATE-BILL-CALC-DET.                                       
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILL_CALC_DET                                 
                   SET READ_UNITS        =  :BZ-READ-UNITS,             
                       BILL_UNITS        =  :BZ-BILL-UNITS,             
                       CONSUMPT_TYPE_CD  =  :BZ-CONSUMPT-TYPE-CD,       
                       NET_UNIT_SEL_RSN  =  :BZ-NET-UNIT-SEL-RSN,       
                       CALC_COMP_AM      =  :BZ-CALC-COMP-AM,           
                       BILLED_COMP_AM    =  :BZ-BILLED-COMP-AM,         
T23301                 WNA_COMP_AM       =  :BZ-WNA-COMP-AM,            
CIG                    UNIT_PRICE_AM       =  :BZ-UNIT-PRICE-AM         
                   WHERE ACCOUNT_NO         = :BZ-ACCOUNT-NO            
                     AND BILL_NO            = :BZ-BILL-NO               
                     AND CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE        
                     AND IC_NO              = :BZ-IC-NO                 
                     AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BZ-BILL-ITEM-TIMESTMP
              )    
                     AND CMPNT_ID_CD        = :BZ-CMPNT-ID-CD           
                     AND INSTR_USE_TYPE_CD  = :BZ-INSTR-USE-TYPE-CD     
                     AND CODE_TIME_PERIOD   = :BZ-CODE-TIME-PERIOD      
                     AND CODE_SEASON        = :BZ-CODE-SEASON           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILL_CALC_DET                                         
MFA-TR*            SET READ_UNITS        =  :BZ-READ-UNITS,                     
MFA-TR*                BILL_UNITS        =  :BZ-BILL-UNITS,                     
MFA-TR*                CONSUMPT_TYPE_CD  =  :BZ-CONSUMPT-TYPE-CD,               
MFA-TR*                NET_UNIT_SEL_RSN  =  :BZ-NET-UNIT-SEL-RSN,               
MFA-TR*                CALC_COMP_AM      =  :BZ-CALC-COMP-AM,                   
MFA-TR*                BILLED_COMP_AM    =  :BZ-BILLED-COMP-AM,                 
MFA-TR*                WNA_COMP_AM       =  :BZ-WNA-COMP-AM,                    
MFA-TR*                UNIT_PRICE_AM       =  :BZ-UNIT-PRICE-AM                 
MFA-TR*            WHERE ACCOUNT_NO         = :BZ-ACCOUNT-NO                    
MFA-TR*              AND BILL_NO            = :BZ-BILL-NO                       
MFA-TR*              AND CODE_UTIL_TYPE     = :BZ-CODE-UTIL-TYPE                
MFA-TR*              AND IC_NO              = :BZ-IC-NO                         
MFA-TR*              AND BILL_ITEM_TIMESTMP = :BZ-BILL-ITEM-TIMESTMP            
MFA-TR*              AND CMPNT_ID_CD        = :BZ-CMPNT-ID-CD                   
MFA-TR*              AND INSTR_USE_TYPE_CD  = :BZ-INSTR-USE-TYPE-CD             
MFA-TR*              AND CODE_TIME_PERIOD   = :BZ-CODE-TIME-PERIOD              
MFA-TR*              AND CODE_SEASON        = :BZ-CODE-SEASON                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'BZ'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8160'               TO WS-DB2-PARAGRAPH             
              MOVE BZ-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BZ-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE BZ-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE BZ-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       8160-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8200-UPDATE-BILLING-HDR.                                         
           IF BI-DATE-BILLED = LOW-VALUES                               
              MOVE -1 TO WS-NULL-IND-11                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-11                               
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
                UPDATE  CSS_BILLING_HDR                                 
                SET   CODE_BILL_REASON   =  :BI-CODE-BILL-REASON,       
                      DATE_BILLED        =  IIF(TRY_CONVERT(DATE, 
                                                       :BI-DATE-BILLED 
                                                        :WS-NULL-IND-11
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED 
                                                        :WS-NULL-IND-11
              ) <> 0) OR (LEN(:BI-DATE-BILLED :WS-NULL-IND-11
              ) <> 10), CIS.CHAR2DATE(:BI-DATE-BILLED :WS-NULL-IND-11
              ), CONVERT(DATE, :BI-DATE-BILLED :WS-NULL-IND-11) ),            
                      CODE_BILL_STATUS   =  :BI-CODE-BILL-STATUS,       
                      CODE_BILL_TYPE     =  :BI-CODE-BILL-TYPE,         
                      CUSTOMER_NO        =  :BI-CUSTOMER-NO,            
                      PREMISE_NO         =  :BI-PREMISE-NO,             
                      CODE_SPCL_BILL     =  :BI-CODE-SPCL-BILL,         
                      PREM_ACCT_SEQ_NO   =  :BI-PREM-ACCT-SEQ-NO,       
TP6055*               SMRY_BILL_NO       =  :BI-SMRY-BILL-NO,                   
TP6055*               SMRY_REBILL_NO     =  :BI-SMRY-REBILL-NO,                 
TP6055*               ACCOUNT_NO_SUMM    =  :BI-ACCOUNT-NO-SUMM,                
                      COMPANY_NO         =  :BI-COMPANY-NO,             
                      TOT_OTHER_CHARGES  =  :BI-TOT-OTHER-CHARGES,      
                      TOTAL_ARREARS      =  :BI-TOTAL-ARREARS,          
                      LAST_UPDATE_TS     =  CIS.CURRENT$TIMESTAMP()           
                WHERE ACCOUNT_NO         =  :BI-ACCOUNT-NO        AND   
                      BILL_NO            =  :BI-BILL-NO           AND   
                      LAST_UPDATE_TS     =  CIS.CHAR2TIMESTAMP(
                                                     :BI-LAST-UPDATE-TS
              )          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE  CSS_BILLING_HDR                                         
MFA-TR*         SET   CODE_BILL_REASON   =  :BI-CODE-BILL-REASON,               
MFA-TR*               DATE_BILLED        =  :BI-DATE-BILLED                     
MFA-TR*                                     :WS-NULL-IND-11,                    
MFA-TR*               CODE_BILL_STATUS   =  :BI-CODE-BILL-STATUS,               
MFA-TR*               CODE_BILL_TYPE     =  :BI-CODE-BILL-TYPE,                 
MFA-TR*               CUSTOMER_NO        =  :BI-CUSTOMER-NO,                    
MFA-TR*               PREMISE_NO         =  :BI-PREMISE-NO,                     
MFA-TR*               CODE_SPCL_BILL     =  :BI-CODE-SPCL-BILL,                 
MFA-TR*               PREM_ACCT_SEQ_NO   =  :BI-PREM-ACCT-SEQ-NO,               
MFA-TR*               SMRY_BILL_NO       =  :BI-SMRY-BILL-NO,                   
MFA-TR*               SMRY_REBILL_NO     =  :BI-SMRY-REBILL-NO,                 
MFA-TR*               ACCOUNT_NO_SUMM    =  :BI-ACCOUNT-NO-SUMM,                
MFA-TR*               COMPANY_NO         =  :BI-COMPANY-NO,                     
MFA-TR*               TOT_OTHER_CHARGES  =  :BI-TOT-OTHER-CHARGES,              
MFA-TR*               TOTAL_ARREARS      =  :BI-TOTAL-ARREARS,                  
MFA-TR*               LAST_UPDATE_TS     =  CURRENT TIMESTAMP                   
MFA-TR*         WHERE ACCOUNT_NO         =  :BI-ACCOUNT-NO        AND           
MFA-TR*               BILL_NO            =  :BI-BILL-NO           AND           
MFA-TR*               LAST_UPDATE_TS     =  :BI-LAST-UPDATE-TS                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 DISPLAY 'TIMESTAMP ERROR'                              
                 MOVE 4 TO RETURN-CODE                                  
                 PERFORM 9999-BAIL-OUT THRU 9999-EXIT                   
              WHEN OTHER                                                
                 MOVE 'BI'                 TO WS-DB2-TABLE-ID           
                 MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '114'                TO WS-DB2-MODULE-ID          
                 MOVE '8200'               TO WS-DB2-PARAGRAPH          
                 MOVE BI-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE BI-BILL-NO           TO WS-DB2-KEY-2N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-EVALUATE.                                                
       8200-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8210-INSERT-BILLING-HDR.                                         
           IF BI-DATE-BILLED = LOW-VALUES OR SPACES                     
              MOVE -1 TO WS-NULL-IND-11                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-11                               
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_BILLING_HDR                             
                     (ACCOUNT_NO,                                       
                      BILL_NO,                                          
                      DATE_BILLED,                                      
                      CODE_BILL_REASON,                                 
                      CODE_BILL_TYPE,                                   
                      CODE_BILL_STATUS,                                 
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      CODE_SPCL_BILL,                                   
                      PREM_ACCT_SEQ_NO,                                 
TP6055*               SMRY_BILL_NO,                                             
TP6055*               SMRY_REBILL_NO,                                           
TP6055*               ACCOUNT_NO_SUMM,                                          
                      COMPANY_NO,                                       
                      TOT_OTHER_CHARGES,                                
                      TOTAL_ARREARS,                                    
                      LAST_UPDATE_TS)                                   
               VALUES                                                   
                     (:BI-ACCOUNT-NO,                                   
                      :BI-BILL-NO,                                      
                      IIF(TRY_CONVERT(DATE, :BI-DATE-BILLED 
                                            :WS-NULL-IND-11
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED 
                                                        :WS-NULL-IND-11
              ) <> 0) OR (LEN(:BI-DATE-BILLED :WS-NULL-IND-11
              ) <> 10), CIS.CHAR2DATE(:BI-DATE-BILLED :WS-NULL-IND-11
              ), CONVERT(DATE, :BI-DATE-BILLED :WS-NULL-IND-11) ),             
                      :BI-CODE-BILL-REASON,                             
                      :BI-CODE-BILL-TYPE,                               
                      :BI-CODE-BILL-STATUS,                             
                      :BI-CUSTOMER-NO,                                  
                      :BI-PREMISE-NO,                                   
                      :BI-CODE-SPCL-BILL,                               
                      :BI-PREM-ACCT-SEQ-NO,                             
TP6055*               :BI-SMRY-BILL-NO,                                         
TP6055*               :BI-SMRY-REBILL-NO,                                       
TP6055*               :BI-ACCOUNT-NO-SUMM,                                      
                      :BI-COMPANY-NO,                                   
                      :BI-TOT-OTHER-CHARGES,                            
                      :BI-TOTAL-ARREARS,                                
                      CIS.CURRENT$TIMESTAMP())                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_BILLING_HDR                                     
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*               BILL_NO,                                                  
MFA-TR*               DATE_BILLED,                                              
MFA-TR*               CODE_BILL_REASON,                                         
MFA-TR*               CODE_BILL_TYPE,                                           
MFA-TR*               CODE_BILL_STATUS,                                         
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               CODE_SPCL_BILL,                                           
MFA-TR*               PREM_ACCT_SEQ_NO,                                         
MFA-TR*               SMRY_BILL_NO,                                             
MFA-TR*               SMRY_REBILL_NO,                                           
MFA-TR*               ACCOUNT_NO_SUMM,                                          
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               TOT_OTHER_CHARGES,                                        
MFA-TR*               TOTAL_ARREARS,                                            
MFA-TR*               LAST_UPDATE_TS)                                           
MFA-TR*        VALUES                                                           
MFA-TR*              (:BI-ACCOUNT-NO,                                           
MFA-TR*               :BI-BILL-NO,                                              
MFA-TR*               :BI-DATE-BILLED :WS-NULL-IND-11,                          
MFA-TR*               :BI-CODE-BILL-REASON,                                     
MFA-TR*               :BI-CODE-BILL-TYPE,                                       
MFA-TR*               :BI-CODE-BILL-STATUS,                                     
MFA-TR*               :BI-CUSTOMER-NO,                                          
MFA-TR*               :BI-PREMISE-NO,                                           
MFA-TR*               :BI-CODE-SPCL-BILL,                                       
MFA-TR*               :BI-PREM-ACCT-SEQ-NO,                                     
MFA-TR*               :BI-SMRY-BILL-NO,                                         
MFA-TR*               :BI-SMRY-REBILL-NO,                                       
MFA-TR*               :BI-ACCOUNT-NO-SUMM,                                      
MFA-TR*               :BI-COMPANY-NO,                                           
MFA-TR*               :BI-TOT-OTHER-CHARGES,                                    
MFA-TR*               :BI-TOTAL-ARREARS,                                        
MFA-TR*               CURRENT TIMESTAMP)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'BI'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8210'               TO WS-DB2-PARAGRAPH             
              MOVE BI-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BI-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8210-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8300-UPDATE-UTIL-ENVRNMT.                                        
           IF UT-DATE-LST-NRML-BILL = LOW-VALUES                        
              MOVE -1 TO WS-NULL-IND-12                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-12                               
           END-IF                                                       
                                                                        
           IF UT-DATE-INSTALL = LOW-VALUES                              
              MOVE -1 TO WS-NULL-IND-13                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-13                               
           END-IF                                                       
                                                                        
           IF UT-GAS-BASE-LAST-UPDT = LOW-VALUES                        
              MOVE -1 TO WS-NULL-IND-14                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-14                               
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_UTIL_ENVRNMT                                 
                SET  CODE_ESTIMATE_OK    = :UT-CODE-ESTIMATE-OK,        
                     CODE_CURTAIL_PRTY   = :UT-CODE-CURTAIL-PRTY,       
                     CODE_REVENUE_CLASS  = :UT-CODE-REVENUE-CLASS,      
                     CODE_SERVICE_TYPE   = :UT-CODE-SERVICE-TYPE,       
                     DATE_LST_NRML_BILL  = IIF(TRY_CONVERT(DATE, 
                                                :UT-DATE-LST-NRML-BILL 
                                                        :WS-NULL-IND-12
              ) IS NULL OR (PATINDEX('%.%', :UT-DATE-LST-NRML-BILL 
                                                        :WS-NULL-IND-12
              ) <> 0) OR (LEN(:UT-DATE-LST-NRML-BILL :WS-NULL-IND-12
              ) <> 10), CIS.CHAR2DATE(:UT-DATE-LST-NRML-BILL 
                                                        :WS-NULL-IND-12
              ), CONVERT(DATE, :UT-DATE-LST-NRML-BILL :WS-NULL-IND-12
              ) ),             
                     RATE_PLAN_NO        = :UT-RATE-PLAN-NO,            
                     END_USER_PER_RATE   = :UT-END-USER-PER-RATE,       
                     DATE_INSTALL        = IIF(TRY_CONVERT(DATE, 
                                                      :UT-DATE-INSTALL 
                                                        :WS-NULL-IND-13
              ) IS NULL OR (PATINDEX('%.%', :UT-DATE-INSTALL 
                                                        :WS-NULL-IND-13
              ) <> 0) OR (LEN(:UT-DATE-INSTALL :WS-NULL-IND-13
              ) <> 10), CIS.CHAR2DATE(:UT-DATE-INSTALL :WS-NULL-IND-13
              ), CONVERT(DATE, :UT-DATE-INSTALL :WS-NULL-IND-13) ),            
                     READ_CYCLE          = :UT-READ-CYCLE,              
                     READ_ROUTE          = :UT-READ-ROUTE,              
                     CODE_MTR_READ_FREQ  = :UT-CODE-MTR-READ-FREQ,      
                     CODE_SIC_NO         = :UT-CODE-SIC-NO,             
                     ENERGY_SOURCE       = :UT-ENERGY-SOURCE,           
                     SPLY_SENSITIVE_IND  = :UT-SPLY-SENSITIVE-IND,      
                     SEASONAL_USE_CODE   = :UT-SEASONAL-USE-CODE,       
                     COMPANY_NO          = :UT-COMPANY-NO,              
                     PRV_RATE_PLAN_NO    = :UT-PRV-RATE-PLAN-NO,        
                     CODE_STAT_TAX_XMT   = :UT-CODE-STAT-TAX-XMT,       
                     CODE_CITY_TAX_XMT   = :UT-CODE-CITY-TAX-XMT,       
                     CODE_OTHR_TAX_XMT   = :UT-CODE-OTHR-TAX-XMT,       
                     CODE_XCIS_TAX_XMT   = :UT-CODE-XCIS-TAX-XMT,       
                     STATE_TAX_EXMPT_NO  = :UT-STATE-TAX-EXMPT-NO,      
                     TOU_RATE_IND        = :UT-TOU-RATE-IND,            
                     GAS_BASE_LAST_UPDT  = IIF(TRY_CONVERT(DATE, 
                                                :UT-GAS-BASE-LAST-UPDT 
                                                        :WS-NULL-IND-14
              ) IS NULL OR (PATINDEX('%.%', :UT-GAS-BASE-LAST-UPDT 
                                                        :WS-NULL-IND-14
              ) <> 0) OR (LEN(:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-14
              ) <> 10), CIS.CHAR2DATE(:UT-GAS-BASE-LAST-UPDT 
                                                        :WS-NULL-IND-14
              ), CONVERT(DATE, :UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-14
              ) ),             
                     GAS_PREV_BASE_USE   = :UT-GAS-PREV-BASE-USE,       
                     GAS_BASE_USE        = :UT-GAS-BASE-USE,            
                     LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP(),           
                     AUTO_RATE_SW_FL     = :UT-AUTO-RATE-SW-FL,         
C34569               RT_PKG_OPT_SEQ_NO   = :UT-RT-PKG-OPT-SEQ-NO,       
C33968               NAICS_CD            = :UT-NAICS-CD                 
                WHERE ACCOUNT_NO         = :UT-ACCOUNT-NO        AND    
                      CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE    AND    
                      IC_NO              = :UT-IC-NO             AND    
                      LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :UT-LAST-UPDATE-TS
              )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_UTIL_ENVRNMT                                         
MFA-TR*         SET  CODE_ESTIMATE_OK    = :UT-CODE-ESTIMATE-OK,                
MFA-TR*              CODE_CURTAIL_PRTY   = :UT-CODE-CURTAIL-PRTY,               
MFA-TR*              CODE_REVENUE_CLASS  = :UT-CODE-REVENUE-CLASS,              
MFA-TR*              CODE_SERVICE_TYPE   = :UT-CODE-SERVICE-TYPE,               
MFA-TR*              DATE_LST_NRML_BILL  = :UT-DATE-LST-NRML-BILL               
MFA-TR*                                    :WS-NULL-IND-12,                     
MFA-TR*              RATE_PLAN_NO        = :UT-RATE-PLAN-NO,                    
MFA-TR*              END_USER_PER_RATE   = :UT-END-USER-PER-RATE,               
MFA-TR*              DATE_INSTALL        = :UT-DATE-INSTALL                     
MFA-TR*                                    :WS-NULL-IND-13,                     
MFA-TR*              READ_CYCLE          = :UT-READ-CYCLE,                      
MFA-TR*              READ_ROUTE          = :UT-READ-ROUTE,                      
MFA-TR*              CODE_MTR_READ_FREQ  = :UT-CODE-MTR-READ-FREQ,              
MFA-TR*              CODE_SIC_NO         = :UT-CODE-SIC-NO,                     
MFA-TR*              ENERGY_SOURCE       = :UT-ENERGY-SOURCE,                   
MFA-TR*              SPLY_SENSITIVE_IND  = :UT-SPLY-SENSITIVE-IND,              
MFA-TR*              SEASONAL_USE_CODE   = :UT-SEASONAL-USE-CODE,               
MFA-TR*              COMPANY_NO          = :UT-COMPANY-NO,                      
MFA-TR*              PRV_RATE_PLAN_NO    = :UT-PRV-RATE-PLAN-NO,                
MFA-TR*              CODE_STAT_TAX_XMT   = :UT-CODE-STAT-TAX-XMT,               
MFA-TR*              CODE_CITY_TAX_XMT   = :UT-CODE-CITY-TAX-XMT,               
MFA-TR*              CODE_OTHR_TAX_XMT   = :UT-CODE-OTHR-TAX-XMT,               
MFA-TR*              CODE_XCIS_TAX_XMT   = :UT-CODE-XCIS-TAX-XMT,               
MFA-TR*              STATE_TAX_EXMPT_NO  = :UT-STATE-TAX-EXMPT-NO,              
MFA-TR*              TOU_RATE_IND        = :UT-TOU-RATE-IND,                    
MFA-TR*              GAS_BASE_LAST_UPDT  = :UT-GAS-BASE-LAST-UPDT               
MFA-TR*                                    :WS-NULL-IND-14,                     
MFA-TR*              GAS_PREV_BASE_USE   = :UT-GAS-PREV-BASE-USE,               
MFA-TR*              GAS_BASE_USE        = :UT-GAS-BASE-USE,                    
MFA-TR*              LAST_UPDATE_TS      = CURRENT TIMESTAMP,                   
MFA-TR*              AUTO_RATE_SW_FL     = :UT-AUTO-RATE-SW-FL,                 
MFA-TR*              RT_PKG_OPT_SEQ_NO   = :UT-RT-PKG-OPT-SEQ-NO,               
MFA-TR*              NAICS_CD            = :UT-NAICS-CD                         
MFA-TR*         WHERE ACCOUNT_NO         = :UT-ACCOUNT-NO        AND            
MFA-TR*               CODE_UTIL_TYPE     = :UT-CODE-UTIL-TYPE    AND            
MFA-TR*               IC_NO              = :UT-IC-NO             AND            
MFA-TR*               LAST_UPDATE_TS     = :UT-LAST-UPDATE-TS                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 DISPLAY 'TIMESTAMP ERROR'                              
                 MOVE 4 TO RETURN-CODE                                  
                 PERFORM 9999-BAIL-OUT THRU 9999-EXIT                   
              WHEN OTHER                                                
                 MOVE 'UT'                 TO WS-DB2-TABLE-ID           
                 MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '114'                TO WS-DB2-MODULE-ID          
                 MOVE '8300'               TO WS-DB2-PARAGRAPH          
                 MOVE UT-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE UT-CODE-UTIL-TYPE    TO WS-DB2-KEY-2              
                 MOVE UT-IC-NO             TO WS-DB2-KEY-3N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
              END-EVALUATE.                                             
       8300-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8310-INSERT-UTIL-ENVRNMT.                                        
           IF UT-DATE-LST-NRML-BILL = LOW-VALUES OR SPACES              
              MOVE -1 TO WS-NULL-IND-12                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-12                               
           END-IF                                                       
                                                                        
           IF UT-DATE-INSTALL = LOW-VALUES OR SPACES                    
              MOVE -1 TO WS-NULL-IND-13                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-13                               
           END-IF                                                       
                                                                        
           IF UT-GAS-BASE-LAST-UPDT = LOW-VALUES OR SPACES              
              MOVE -1 TO WS-NULL-IND-14                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-14                               
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_UTIL_ENVRNMT                              
                (ACCOUNT_NO,                                            
                 CODE_UTIL_TYPE,                                        
                 IC_NO,                                                 
                 CODE_ESTIMATE_OK,                                      
                 CODE_CURTAIL_PRTY,                                     
                 CODE_REVENUE_CLASS,                                    
                 CODE_SERVICE_TYPE,                                     
                 DATE_LST_NRML_BILL,                                    
                 RATE_PLAN_NO,                                          
                 END_USER_PER_RATE,                                     
                 DATE_INSTALL,                                          
                 READ_CYCLE,                                            
                 READ_ROUTE,                                            
                 CODE_MTR_READ_FREQ,                                    
                 CODE_SIC_NO,                                           
                 ENERGY_SOURCE,                                         
                 SPLY_SENSITIVE_IND,                                    
                 SEASONAL_USE_CODE,                                     
                 COMPANY_NO,                                            
                 PRV_RATE_PLAN_NO,                                      
                 CODE_STAT_TAX_XMT,                                     
                 CODE_CITY_TAX_XMT,                                     
                 CODE_OTHR_TAX_XMT,                                     
                 CODE_XCIS_TAX_XMT,                                     
                 STATE_TAX_EXMPT_NO,                                    
                 TOU_RATE_IND,                                          
                 GAS_BASE_LAST_UPDT,                                    
                 GAS_PREV_BASE_USE,                                     
                 GAS_BASE_USE,                                          
                 PREMISE_NO,                                            
                 LAST_UPDATE_TS,                                        
                 AUTO_RATE_SW_FL,                                       
C34569           RT_PKG_OPT_SEQ_NO,                                     
C33968           NAICS_CD)                                              
                VALUES (                                                
                 :UT-ACCOUNT-NO,                                        
                 :UT-CODE-UTIL-TYPE,                                    
                 :UT-IC-NO,                                             
                 :UT-CODE-ESTIMATE-OK,                                  
                 :UT-CODE-CURTAIL-PRTY,                                 
                 :UT-CODE-REVENUE-CLASS,                                
                 :UT-CODE-SERVICE-TYPE,                                 
                 IIF(TRY_CONVERT(DATE, :UT-DATE-LST-NRML-BILL 
                                       :WS-NULL-IND-12
              ) IS NULL OR (PATINDEX('%.%', :UT-DATE-LST-NRML-BILL 
                                                        :WS-NULL-IND-12
              ) <> 0) OR (LEN(:UT-DATE-LST-NRML-BILL :WS-NULL-IND-12
              ) <> 10), CIS.CHAR2DATE(:UT-DATE-LST-NRML-BILL 
                                                        :WS-NULL-IND-12
              ), CONVERT(DATE, :UT-DATE-LST-NRML-BILL :WS-NULL-IND-12
              ) ),                
                 :UT-RATE-PLAN-NO,                                      
                 :UT-END-USER-PER-RATE,                                 
                 IIF(TRY_CONVERT(DATE, :UT-DATE-INSTALL :WS-NULL-IND-13
              ) IS NULL OR (PATINDEX('%.%', :UT-DATE-INSTALL 
                                                        :WS-NULL-IND-13
              ) <> 0) OR (LEN(:UT-DATE-INSTALL :WS-NULL-IND-13
              ) <> 10), CIS.CHAR2DATE(:UT-DATE-INSTALL :WS-NULL-IND-13
              ), CONVERT(DATE, :UT-DATE-INSTALL :WS-NULL-IND-13) ),            
                 :UT-READ-CYCLE,                                        
                 :UT-READ-ROUTE,                                        
                 :UT-CODE-MTR-READ-FREQ,                                
                 :UT-CODE-SIC-NO,                                       
                 :UT-ENERGY-SOURCE,                                     
                 :UT-SPLY-SENSITIVE-IND,                                
                 :UT-SEASONAL-USE-CODE,                                 
                 :UT-COMPANY-NO,                                        
                 :UT-PRV-RATE-PLAN-NO,                                  
                 :UT-CODE-STAT-TAX-XMT,                                 
                 :UT-CODE-CITY-TAX-XMT,                                 
                 :UT-CODE-OTHR-TAX-XMT,                                 
                 :UT-CODE-XCIS-TAX-XMT,                                 
                 :UT-STATE-TAX-EXMPT-NO,                                
                 :UT-TOU-RATE-IND,                                      
                 IIF(TRY_CONVERT(DATE, :UT-GAS-BASE-LAST-UPDT 
                                       :WS-NULL-IND-14
              ) IS NULL OR (PATINDEX('%.%', :UT-GAS-BASE-LAST-UPDT 
                                                        :WS-NULL-IND-14
              ) <> 0) OR (LEN(:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-14
              ) <> 10), CIS.CHAR2DATE(:UT-GAS-BASE-LAST-UPDT 
                                                        :WS-NULL-IND-14
              ), CONVERT(DATE, :UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-14
              ) ),                
                 :UT-GAS-PREV-BASE-USE,                                 
                 :UT-GAS-BASE-USE,                                      
                 :UT-PREMISE-NO,                                        
                 CIS.CURRENT$TIMESTAMP(),                                     
                 :UT-AUTO-RATE-SW-FL,                                   
C34569           :UT-RT-PKG-OPT-SEQ-NO,                                 
C33968           :UT-NAICS-CD)                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_UTIL_ENVRNMT                                      
MFA-TR*         (ACCOUNT_NO,                                                    
MFA-TR*          CODE_UTIL_TYPE,                                                
MFA-TR*          IC_NO,                                                         
MFA-TR*          CODE_ESTIMATE_OK,                                              
MFA-TR*          CODE_CURTAIL_PRTY,                                             
MFA-TR*          CODE_REVENUE_CLASS,                                            
MFA-TR*          CODE_SERVICE_TYPE,                                             
MFA-TR*          DATE_LST_NRML_BILL,                                            
MFA-TR*          RATE_PLAN_NO,                                                  
MFA-TR*          END_USER_PER_RATE,                                             
MFA-TR*          DATE_INSTALL,                                                  
MFA-TR*          READ_CYCLE,                                                    
MFA-TR*          READ_ROUTE,                                                    
MFA-TR*          CODE_MTR_READ_FREQ,                                            
MFA-TR*          CODE_SIC_NO,                                                   
MFA-TR*          ENERGY_SOURCE,                                                 
MFA-TR*          SPLY_SENSITIVE_IND,                                            
MFA-TR*          SEASONAL_USE_CODE,                                             
MFA-TR*          COMPANY_NO,                                                    
MFA-TR*          PRV_RATE_PLAN_NO,                                              
MFA-TR*          CODE_STAT_TAX_XMT,                                             
MFA-TR*          CODE_CITY_TAX_XMT,                                             
MFA-TR*          CODE_OTHR_TAX_XMT,                                             
MFA-TR*          CODE_XCIS_TAX_XMT,                                             
MFA-TR*          STATE_TAX_EXMPT_NO,                                            
MFA-TR*          TOU_RATE_IND,                                                  
MFA-TR*          GAS_BASE_LAST_UPDT,                                            
MFA-TR*          GAS_PREV_BASE_USE,                                             
MFA-TR*          GAS_BASE_USE,                                                  
MFA-TR*          PREMISE_NO,                                                    
MFA-TR*          LAST_UPDATE_TS,                                                
MFA-TR*          AUTO_RATE_SW_FL,                                               
MFA-TR*          RT_PKG_OPT_SEQ_NO,                                             
MFA-TR*          NAICS_CD)                                                      
MFA-TR*         VALUES (                                                        
MFA-TR*          :UT-ACCOUNT-NO,                                                
MFA-TR*          :UT-CODE-UTIL-TYPE,                                            
MFA-TR*          :UT-IC-NO,                                                     
MFA-TR*          :UT-CODE-ESTIMATE-OK,                                          
MFA-TR*          :UT-CODE-CURTAIL-PRTY,                                         
MFA-TR*          :UT-CODE-REVENUE-CLASS,                                        
MFA-TR*          :UT-CODE-SERVICE-TYPE,                                         
MFA-TR*          :UT-DATE-LST-NRML-BILL :WS-NULL-IND-12,                        
MFA-TR*          :UT-RATE-PLAN-NO,                                              
MFA-TR*          :UT-END-USER-PER-RATE,                                         
MFA-TR*          :UT-DATE-INSTALL :WS-NULL-IND-13,                              
MFA-TR*          :UT-READ-CYCLE,                                                
MFA-TR*          :UT-READ-ROUTE,                                                
MFA-TR*          :UT-CODE-MTR-READ-FREQ,                                        
MFA-TR*          :UT-CODE-SIC-NO,                                               
MFA-TR*          :UT-ENERGY-SOURCE,                                             
MFA-TR*          :UT-SPLY-SENSITIVE-IND,                                        
MFA-TR*          :UT-SEASONAL-USE-CODE,                                         
MFA-TR*          :UT-COMPANY-NO,                                                
MFA-TR*          :UT-PRV-RATE-PLAN-NO,                                          
MFA-TR*          :UT-CODE-STAT-TAX-XMT,                                         
MFA-TR*          :UT-CODE-CITY-TAX-XMT,                                         
MFA-TR*          :UT-CODE-OTHR-TAX-XMT,                                         
MFA-TR*          :UT-CODE-XCIS-TAX-XMT,                                         
MFA-TR*          :UT-STATE-TAX-EXMPT-NO,                                        
MFA-TR*          :UT-TOU-RATE-IND,                                              
MFA-TR*          :UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-14,                        
MFA-TR*          :UT-GAS-PREV-BASE-USE,                                         
MFA-TR*          :UT-GAS-BASE-USE,                                              
MFA-TR*          :UT-PREMISE-NO,                                                
MFA-TR*          CURRENT TIMESTAMP,                                             
MFA-TR*          :UT-AUTO-RATE-SW-FL,                                           
MFA-TR*          :UT-RT-PKG-OPT-SEQ-NO,                                         
MFA-TR*          :UT-NAICS-CD)                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'UT'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8210'               TO WS-DB2-PARAGRAPH             
              MOVE UT-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UT-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
              MOVE UT-IC-NO             TO WS-DB2-KEY-3N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8310-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8420-UPDATE-BILLING-DET.                                         
                                                                        
T16109     IF (BG-REVENUE-MONTH NOT NUMERIC OR                          
T21153         BG-REVENUE-MONTH = 0)                                    
T21153*       BG-CODE-BILL-ITM-IND NOT = WS-ACTIVE                              
T16109          MOVE LS-CURR-REVENUE-MONTH TO BG-REVENUE-MONTH          
T16109     END-IF                                                       
                                                                        
T25885     IF (BG-REVENUE-MONTH NOT EQUAL TO LS-CURR-REVENUE-MONTH )    
T25885       AND  BG-CODE-BILL-ITM-TYPE  = WS-BACKOUT                   
T25885          MOVE LS-CURR-REVENUE-MONTH TO BG-REVENUE-MONTH          
T25885     END-IF                                                       
                                                                        
                                                                        
           IF BG-DATE-ORIG-BILL = LOW-VALUES                            
              MOVE -1 TO WS-NULL-IND-15                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-15                               
           END-IF                                                       
                                                                        
           IF BG-DATE-LFTM-HI-DMD = LOW-VALUES                          
              MOVE -1 TO WS-NULL-IND-16                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-16                               
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
                UPDATE  CSS_BILLING_DET                                 
                SET   AMT_BILL_ITEM      =  :BG-AMT-BILL-ITEM,          
                      CODE_BILL_CALC     =  :BG-CODE-BILL-CALC,         
                      CODE_BILL_ITM_IND  =  :BG-CODE-BILL-ITM-IND,      
                      CODE_BILL_ITM_TYPE =  :BG-CODE-BILL-ITM-TYPE,     
                      CODE_DR_CR_CNSMPTN =  :BG-CODE-DR-CR-CNSMPTN,     
                      AMT_STATE_TAX      =  :BG-AMT-STATE-TAX,          
                      AMT_CITY_TAX       =  :BG-AMT-CITY-TAX,           
                      AMT_OTHER_TAX      =  :BG-AMT-OTHER-TAX,          
                      CODE_REVENUE_CLASS =  :BG-CODE-REVENUE-CLASS,     
                      CODE_SIC_NO        =  :BG-CODE-SIC-NO,            
                      RATE_PLAN_NO       =  :BG-RATE-PLAN-NO,           
                      CODE_CURTAIL_PRTY  =  :BG-CODE-CURTAIL-PRTY,      
                      CODE_STAT_TAX_XMT  =  :BG-CODE-STAT-TAX-XMT,      
                      CODE_CITY_TAX_XMT  =  :BG-CODE-CITY-TAX-XMT,      
                      CODE_OTHR_TAX_XMT  =  :BG-CODE-OTHR-TAX-XMT,      
                      REVENUE_MONTH      =  :BG-REVENUE-MONTH,          
                      REV_MTH_ORIG_BILL  =  :BG-REV-MTH-ORIG-BILL,      
                      BTU_FACTOR         =  :BG-BTU-FACTOR,             
                      WNA_FACTOR         =  :BG-WNA-FACTOR,             
                      GAS_BASE_USE       =  :BG-GAS-BASE-USE,           
                      NO_OF_CONS_DAYS    =  :BG-NO-OF-CONS-DAYS,        
T26639                PRORATE_CD         =  :BG-PRORATE-CD,             
T23631                FUEL_SHIPPER_CD    =  :BG-FUEL-SHIPPER-CD,        
C29528                CITY_TAX_RATE      =  :BG-CITY-TAX-RATE,          
C29528                STATE_TAX_RATE     =  :BG-STATE-TAX-RATE,         
C30135                REV_DISTRICT_CD    =  :BG-REV-DISTRICT-CD,        
C33362                BILL_CALC_CYCLE    =  :BG-BILL-CALC-CYCLE,        
C34569                RT_PKG_OPT_SEQ_NO  =  :BG-RT-PKG-OPT-SEQ-NO,      
C33968                NAICS_CD           =  :BG-NAICS-CD                
                WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO        AND   
                       BILL_NO            = :BG-BILL-NO           AND   
                       CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE    AND   
                       IC_NO              = :BG-IC-NO             AND   
                       BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE  CSS_BILLING_DET                                         
MFA-TR*         SET   AMT_BILL_ITEM      =  :BG-AMT-BILL-ITEM,                  
MFA-TR*               CODE_BILL_CALC     =  :BG-CODE-BILL-CALC,                 
MFA-TR*               CODE_BILL_ITM_IND  =  :BG-CODE-BILL-ITM-IND,              
MFA-TR*               CODE_BILL_ITM_TYPE =  :BG-CODE-BILL-ITM-TYPE,             
MFA-TR*               CODE_DR_CR_CNSMPTN =  :BG-CODE-DR-CR-CNSMPTN,             
MFA-TR*               AMT_STATE_TAX      =  :BG-AMT-STATE-TAX,                  
MFA-TR*               AMT_CITY_TAX       =  :BG-AMT-CITY-TAX,                   
MFA-TR*               AMT_OTHER_TAX      =  :BG-AMT-OTHER-TAX,                  
MFA-TR*               CODE_REVENUE_CLASS =  :BG-CODE-REVENUE-CLASS,             
MFA-TR*               CODE_SIC_NO        =  :BG-CODE-SIC-NO,                    
MFA-TR*               RATE_PLAN_NO       =  :BG-RATE-PLAN-NO,                   
MFA-TR*               CODE_CURTAIL_PRTY  =  :BG-CODE-CURTAIL-PRTY,              
MFA-TR*               CODE_STAT_TAX_XMT  =  :BG-CODE-STAT-TAX-XMT,              
MFA-TR*               CODE_CITY_TAX_XMT  =  :BG-CODE-CITY-TAX-XMT,              
MFA-TR*               CODE_OTHR_TAX_XMT  =  :BG-CODE-OTHR-TAX-XMT,              
MFA-TR*               REVENUE_MONTH      =  :BG-REVENUE-MONTH,                  
MFA-TR*               REV_MTH_ORIG_BILL  =  :BG-REV-MTH-ORIG-BILL,              
MFA-TR*               BTU_FACTOR         =  :BG-BTU-FACTOR,                     
MFA-TR*               WNA_FACTOR         =  :BG-WNA-FACTOR,                     
MFA-TR*               GAS_BASE_USE       =  :BG-GAS-BASE-USE,                   
MFA-TR*               NO_OF_CONS_DAYS    =  :BG-NO-OF-CONS-DAYS,                
MFA-TR*               PRORATE_CD         =  :BG-PRORATE-CD,                     
MFA-TR*               FUEL_SHIPPER_CD    =  :BG-FUEL-SHIPPER-CD,                
MFA-TR*               CITY_TAX_RATE      =  :BG-CITY-TAX-RATE,                  
MFA-TR*               STATE_TAX_RATE     =  :BG-STATE-TAX-RATE,                 
MFA-TR*               REV_DISTRICT_CD    =  :BG-REV-DISTRICT-CD,                
MFA-TR*               BILL_CALC_CYCLE    =  :BG-BILL-CALC-CYCLE,                
MFA-TR*               RT_PKG_OPT_SEQ_NO  =  :BG-RT-PKG-OPT-SEQ-NO,              
MFA-TR*               NAICS_CD           =  :BG-NAICS-CD                        
MFA-TR*         WHERE  ACCOUNT_NO         = :BG-ACCOUNT-NO        AND           
MFA-TR*                BILL_NO            = :BG-BILL-NO           AND           
MFA-TR*                CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE    AND           
MFA-TR*                IC_NO              = :BG-IC-NO             AND           
MFA-TR*                BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'BG'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8420'               TO WS-DB2-PARAGRAPH             
              MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BG-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE BG-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE BG-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8421-INSERT-BILLING-DET.                                         
T16109     IF (BG-REVENUE-MONTH NOT NUMERIC OR                          
T16109         BG-REVENUE-MONTH = 0) AND                                
T16109        BG-CODE-BILL-ITM-IND NOT = WS-ACTIVE                      
T16109          MOVE LS-CURR-REVENUE-MONTH TO BG-REVENUE-MONTH          
T16109     END-IF                                                       
                                                                        
           IF BG-DATE-ORIG-BILL = LOW-VALUES OR SPACES                  
              MOVE -1 TO WS-NULL-IND-15                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-15                               
           END-IF                                                       
                                                                        
           IF BG-DATE-LFTM-HI-DMD = LOW-VALUES OR SPACES                
              MOVE -1 TO WS-NULL-IND-16                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-16                               
           END-IF                                                       
                                                                        
T23951     IF BG-COMPANY-NO = SPACES OR ZEROS OR LOW-VALUES             
T23951        DISPLAY ' '                                               
T23951        DISPLAY '** SCSCA114-8421 INVALID BG-COMPANY-NO'          
T23951        DISPLAY '** 'BG-ACCOUNT-NO ' ' BG-COMPANY-NO              
T23951     END-IF                                                       
T23951                                                                  
           EXEC SQL                                                     
                INSERT INTO CSS_BILLING_DET                             
                     (ACCOUNT_NO,                                       
                      BILL_NO,                                          
                      CODE_UTIL_TYPE,                                   
                      IC_NO,                                            
                      BILL_ITEM_TIMESTMP,                               
                      DATE_ORIG_BILL,                                   
                      AMT_BILL_ITEM,                                    
                      PREMISE_NO,                                       
                      CODE_BILL_CALC,                                   
                      CODE_BILL_ITM_TYPE,                               
                      CODE_BILL_ITM_IND,                                
                      CODE_DR_CR_CNSMPTN,                               
                      AMT_STATE_TAX,                                    
                      AMT_CITY_TAX,                                     
                      AMT_OTHER_TAX,                                    
                      CODE_REVENUE_CLASS,                               
                      CODE_SIC_NO,                                      
                      RATE_PLAN_NO,                                     
                      CODE_CURTAIL_PRTY,                                
                      CODE_STAT_TAX_XMT,                                
                      CODE_CITY_TAX_XMT,                                
                      CODE_OTHR_TAX_XMT,                                
                      REV_RPT_CD,                                       
                      STANDBY_COMPLIED,                                 
                      PRORATE_CD,                                       
                      NEW_RATE_PCT,                                     
                      CODE_SUB_TOTAL,                                   
                      TAX_REFUND_CD,                                    
                      COMPANY_NO,                                       
                      DATE_LFTM_HI_DMD,                                 
                      LFTM_HI_PEAK_DMD,                                 
                      REBILL_IND,                                       
                      ADJ_REASON_CD,                                    
                      BTU_FACTOR,                                       
                      WNA_FACTOR,                                       
                      GAS_BASE_USE,                                     
                      REVENUE_MONTH,                                    
                      NO_OF_CONS_DAYS,                                  
                      REV_DISTRICT_CD,                                  
                      REV_MTH_ORIG_BILL,                                
T23631                FUEL_SHIPPER_CD,                                  
C29528                CITY_TAX_RATE,                                    
C29528                STATE_TAX_RATE,                                   
C33362                BILL_CALC_CYCLE,                                  
C34569                RT_PKG_OPT_SEQ_NO,                                
C33968                NAICS_CD)                                         
                VALUES                                                  
                   (:BG-ACCOUNT-NO,                                     
                      :BG-BILL-NO,                                      
                      :BG-CODE-UTIL-TYPE,                               
                      :BG-IC-NO,                                        
                      CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP),               
                      IIF(TRY_CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                            :WS-NULL-IND-15
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL 
                                                        :WS-NULL-IND-15
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL :WS-NULL-IND-15
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL 
                                                        :WS-NULL-IND-15
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL :WS-NULL-IND-15) ),          
                      :BG-AMT-BILL-ITEM,                                
                      :BG-PREMISE-NO,                                   
                      :BG-CODE-BILL-CALC,                               
                      :BG-CODE-BILL-ITM-TYPE,                           
                      :BG-CODE-BILL-ITM-IND,                            
                      :BG-CODE-DR-CR-CNSMPTN,                           
                      :BG-AMT-STATE-TAX,                                
                      :BG-AMT-CITY-TAX,                                 
                      :BG-AMT-OTHER-TAX,                                
                      :BG-CODE-REVENUE-CLASS,                           
                      :BG-CODE-SIC-NO,                                  
                      :BG-RATE-PLAN-NO,                                 
                      :BG-CODE-CURTAIL-PRTY,                            
                      :BG-CODE-STAT-TAX-XMT,                            
                      :BG-CODE-CITY-TAX-XMT,                            
                      :BG-CODE-OTHR-TAX-XMT,                            
                      :BG-REV-RPT-CD,                                   
                      :BG-STANDBY-COMPLIED,                             
                      :BG-PRORATE-CD,                                   
                      :BG-NEW-RATE-PCT,                                 
                      :BG-CODE-SUB-TOTAL,                               
                      :BG-TAX-REFUND-CD,                                
                      :BG-COMPANY-NO,                                   
                      IIF(TRY_CONVERT(DATE, :BG-DATE-LFTM-HI-DMD 
                                            :WS-NULL-IND-16
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-LFTM-HI-DMD 
                                                        :WS-NULL-IND-16
              ) <> 0) OR (LEN(:BG-DATE-LFTM-HI-DMD :WS-NULL-IND-16
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-LFTM-HI-DMD 
                                                        :WS-NULL-IND-16
              ), CONVERT(DATE, :BG-DATE-LFTM-HI-DMD :WS-NULL-IND-16) ),        
                      :BG-LFTM-HI-PEAK-DMD,                             
                      :BG-REBILL-IND,                                   
                      :BG-ADJ-REASON-CD,                                
                      :BG-BTU-FACTOR,                                   
                      :BG-WNA-FACTOR,                                   
                      :BG-GAS-BASE-USE,                                 
                      :BG-REVENUE-MONTH,                                
                      :BG-NO-OF-CONS-DAYS,                              
                      :BG-REV-DISTRICT-CD,                              
                      :BG-REV-MTH-ORIG-BILL,                            
T23631                :BG-FUEL-SHIPPER-CD,                              
C29528                :BG-CITY-TAX-RATE,                                
C29528                :BG-STATE-TAX-RATE,                               
C33362                :BG-BILL-CALC-CYCLE,                              
C34569                :BG-RT-PKG-OPT-SEQ-NO,                            
C33968                :BG-NAICS-CD)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_BILLING_DET                                     
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*               BILL_NO,                                                  
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               IC_NO,                                                    
MFA-TR*               BILL_ITEM_TIMESTMP,                                       
MFA-TR*               DATE_ORIG_BILL,                                           
MFA-TR*               AMT_BILL_ITEM,                                            
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               CODE_BILL_CALC,                                           
MFA-TR*               CODE_BILL_ITM_TYPE,                                       
MFA-TR*               CODE_BILL_ITM_IND,                                        
MFA-TR*               CODE_DR_CR_CNSMPTN,                                       
MFA-TR*               AMT_STATE_TAX,                                            
MFA-TR*               AMT_CITY_TAX,                                             
MFA-TR*               AMT_OTHER_TAX,                                            
MFA-TR*               CODE_REVENUE_CLASS,                                       
MFA-TR*               CODE_SIC_NO,                                              
MFA-TR*               RATE_PLAN_NO,                                             
MFA-TR*               CODE_CURTAIL_PRTY,                                        
MFA-TR*               CODE_STAT_TAX_XMT,                                        
MFA-TR*               CODE_CITY_TAX_XMT,                                        
MFA-TR*               CODE_OTHR_TAX_XMT,                                        
MFA-TR*               REV_RPT_CD,                                               
MFA-TR*               STANDBY_COMPLIED,                                         
MFA-TR*               PRORATE_CD,                                               
MFA-TR*               NEW_RATE_PCT,                                             
MFA-TR*               CODE_SUB_TOTAL,                                           
MFA-TR*               TAX_REFUND_CD,                                            
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               DATE_LFTM_HI_DMD,                                         
MFA-TR*               LFTM_HI_PEAK_DMD,                                         
MFA-TR*               REBILL_IND,                                               
MFA-TR*               ADJ_REASON_CD,                                            
MFA-TR*               BTU_FACTOR,                                               
MFA-TR*               WNA_FACTOR,                                               
MFA-TR*               GAS_BASE_USE,                                             
MFA-TR*               REVENUE_MONTH,                                            
MFA-TR*               NO_OF_CONS_DAYS,                                          
MFA-TR*               REV_DISTRICT_CD,                                          
MFA-TR*               REV_MTH_ORIG_BILL,                                        
MFA-TR*               FUEL_SHIPPER_CD,                                          
MFA-TR*               CITY_TAX_RATE,                                            
MFA-TR*               STATE_TAX_RATE,                                           
MFA-TR*               BILL_CALC_CYCLE,                                          
MFA-TR*               RT_PKG_OPT_SEQ_NO,                                        
MFA-TR*               NAICS_CD)                                                 
MFA-TR*         VALUES                                                          
MFA-TR*            (:BG-ACCOUNT-NO,                                             
MFA-TR*               :BG-BILL-NO,                                              
MFA-TR*               :BG-CODE-UTIL-TYPE,                                       
MFA-TR*               :BG-IC-NO,                                                
MFA-TR*               :BG-BILL-ITEM-TIMESTMP,                                   
MFA-TR*               :BG-DATE-ORIG-BILL :WS-NULL-IND-15,                       
MFA-TR*               :BG-AMT-BILL-ITEM,                                        
MFA-TR*               :BG-PREMISE-NO,                                           
MFA-TR*               :BG-CODE-BILL-CALC,                                       
MFA-TR*               :BG-CODE-BILL-ITM-TYPE,                                   
MFA-TR*               :BG-CODE-BILL-ITM-IND,                                    
MFA-TR*               :BG-CODE-DR-CR-CNSMPTN,                                   
MFA-TR*               :BG-AMT-STATE-TAX,                                        
MFA-TR*               :BG-AMT-CITY-TAX,                                         
MFA-TR*               :BG-AMT-OTHER-TAX,                                        
MFA-TR*               :BG-CODE-REVENUE-CLASS,                                   
MFA-TR*               :BG-CODE-SIC-NO,                                          
MFA-TR*               :BG-RATE-PLAN-NO,                                         
MFA-TR*               :BG-CODE-CURTAIL-PRTY,                                    
MFA-TR*               :BG-CODE-STAT-TAX-XMT,                                    
MFA-TR*               :BG-CODE-CITY-TAX-XMT,                                    
MFA-TR*               :BG-CODE-OTHR-TAX-XMT,                                    
MFA-TR*               :BG-REV-RPT-CD,                                           
MFA-TR*               :BG-STANDBY-COMPLIED,                                     
MFA-TR*               :BG-PRORATE-CD,                                           
MFA-TR*               :BG-NEW-RATE-PCT,                                         
MFA-TR*               :BG-CODE-SUB-TOTAL,                                       
MFA-TR*               :BG-TAX-REFUND-CD,                                        
MFA-TR*               :BG-COMPANY-NO,                                           
MFA-TR*               :BG-DATE-LFTM-HI-DMD :WS-NULL-IND-16,                     
MFA-TR*               :BG-LFTM-HI-PEAK-DMD,                                     
MFA-TR*               :BG-REBILL-IND,                                           
MFA-TR*               :BG-ADJ-REASON-CD,                                        
MFA-TR*               :BG-BTU-FACTOR,                                           
MFA-TR*               :BG-WNA-FACTOR,                                           
MFA-TR*               :BG-GAS-BASE-USE,                                         
MFA-TR*               :BG-REVENUE-MONTH,                                        
MFA-TR*               :BG-NO-OF-CONS-DAYS,                                      
MFA-TR*               :BG-REV-DISTRICT-CD,                                      
MFA-TR*               :BG-REV-MTH-ORIG-BILL,                                    
MFA-TR*               :BG-FUEL-SHIPPER-CD,                                      
MFA-TR*               :BG-CITY-TAX-RATE,                                        
MFA-TR*               :BG-STATE-TAX-RATE,                                       
MFA-TR*               :BG-BILL-CALC-CYCLE,                                      
MFA-TR*               :BG-RT-PKG-OPT-SEQ-NO,                                    
MFA-TR*               :BG-NAICS-CD)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'BG'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8421'               TO WS-DB2-PARAGRAPH             
              MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BG-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE BG-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE BG-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8421-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8435-DELETE-BILLING-DETAIL.                                      
           EXEC SQL                                                     
                DELETE                                                  
                FROM CSS_BILLING_DET                                    
                WHERE CURRENT OF BILLING_DETAIL                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'BG'                 TO WS-DB2-TABLE-ID              
              MOVE 'DELETE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8300'               TO WS-DB2-PARAGRAPH             
              MOVE UT-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UT-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
              MOVE UT-IC-NO             TO WS-DB2-KEY-3N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8435-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8515-DELETE-UM-CNSMPT-HIST.                                      
           EXEC SQL                                                     
                DELETE                                                  
                FROM CSS_UM_CNSMPT_HIST                                 
                WHERE CURRENT OF UM_CNSMPT_HIST                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'UM'                 TO WS-DB2-TABLE-ID              
              MOVE 'DELETE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8515'               TO WS-DB2-PARAGRAPH             
              MOVE UC-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UC-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE UC-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE UC-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8515-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8520-INSERT-UM-CNSMPT-HIST.                                      
           IF UC-DATE-USAGE-ENDS = LOW-VALUES OR SPACES                 
              MOVE -1 TO WS-NULL-IND-17                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-17                               
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_UM_CNSMPT_HIST                             
             (ACCOUNT_NO,                                               
              BILL_NO,                                                  
              CODE_UTIL_TYPE,                                           
              IC_NO,                                                    
              BILL_ITEM_TIMESTMP,                                       
              RATE_ITEM_CODE,                                           
              ITEM_SEQ_NO,                                              
              NO_UNITS,                                                 
              NO_DAYS,                                                  
              CODE_DEBIT_CREDIT,                                        
              USAGE_FIXED,                                              
              DATE_USAGE_ENDS,                                          
              CODE_SERVICE_TYPE,                                        
              CODE_ITEM_STATUS,                                         
              CODE_SOURCE_ID,                                           
              MTHLY_AMOUNT_FIXED,                                       
              DIST_NO,                                                  
              LIGHT_NO,                                                 
              POLE_NO)                                                  
             VALUES                                                     
             (:UC-ACCOUNT-NO,                                           
              :UC-BILL-NO,                                              
              :UC-CODE-UTIL-TYPE,                                       
              :UC-IC-NO,                                                
              CIS.CHAR2TIMESTAMP(:UC-BILL-ITEM-TIMESTMP),                       
              :UC-RATE-ITEM-CODE,                                       
              :UC-ITEM-SEQ-NO,                                          
              :UC-NO-UNITS,                                             
              :UC-NO-DAYS,                                              
              :UC-CODE-DEBIT-CREDIT,                                    
              :UC-USAGE-FIXED,                                          
              IIF(TRY_CONVERT(DATE, :UC-DATE-USAGE-ENDS :WS-NULL-IND-17
              ) IS NULL OR (PATINDEX('%.%', :UC-DATE-USAGE-ENDS 
                                                        :WS-NULL-IND-17
              ) <> 0) OR (LEN(:UC-DATE-USAGE-ENDS :WS-NULL-IND-17
              ) <> 10), CIS.CHAR2DATE(:UC-DATE-USAGE-ENDS 
                                                        :WS-NULL-IND-17
              ), CONVERT(DATE, :UC-DATE-USAGE-ENDS :WS-NULL-IND-17) ),         
              :UC-CODE-SERVICE-TYPE,                                    
              :UC-CODE-ITEM-STATUS,                                     
              :UC-CODE-SOURCE-ID,                                       
              :UC-MTHLY-AMOUNT-FIXED,                                   
              :UC-DIST-NO,                                              
              :UC-LIGHT-NO,                                             
              :UC-POLE-NO)                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_UM_CNSMPT_HIST                                     
MFA-TR*      (ACCOUNT_NO,                                                       
MFA-TR*       BILL_NO,                                                          
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       IC_NO,                                                            
MFA-TR*       BILL_ITEM_TIMESTMP,                                               
MFA-TR*       RATE_ITEM_CODE,                                                   
MFA-TR*       ITEM_SEQ_NO,                                                      
MFA-TR*       NO_UNITS,                                                         
MFA-TR*       NO_DAYS,                                                          
MFA-TR*       CODE_DEBIT_CREDIT,                                                
MFA-TR*       USAGE_FIXED,                                                      
MFA-TR*       DATE_USAGE_ENDS,                                                  
MFA-TR*       CODE_SERVICE_TYPE,                                                
MFA-TR*       CODE_ITEM_STATUS,                                                 
MFA-TR*       CODE_SOURCE_ID,                                                   
MFA-TR*       MTHLY_AMOUNT_FIXED,                                               
MFA-TR*       DIST_NO,                                                          
MFA-TR*       LIGHT_NO,                                                         
MFA-TR*       POLE_NO)                                                          
MFA-TR*      VALUES                                                             
MFA-TR*      (:UC-ACCOUNT-NO,                                                   
MFA-TR*       :UC-BILL-NO,                                                      
MFA-TR*       :UC-CODE-UTIL-TYPE,                                               
MFA-TR*       :UC-IC-NO,                                                        
MFA-TR*       :UC-BILL-ITEM-TIMESTMP,                                           
MFA-TR*       :UC-RATE-ITEM-CODE,                                               
MFA-TR*       :UC-ITEM-SEQ-NO,                                                  
MFA-TR*       :UC-NO-UNITS,                                                     
MFA-TR*       :UC-NO-DAYS,                                                      
MFA-TR*       :UC-CODE-DEBIT-CREDIT,                                            
MFA-TR*       :UC-USAGE-FIXED,                                                  
MFA-TR*       :UC-DATE-USAGE-ENDS :WS-NULL-IND-17,                              
MFA-TR*       :UC-CODE-SERVICE-TYPE,                                            
MFA-TR*       :UC-CODE-ITEM-STATUS,                                             
MFA-TR*       :UC-CODE-SOURCE-ID,                                               
MFA-TR*       :UC-MTHLY-AMOUNT-FIXED,                                           
MFA-TR*       :UC-DIST-NO,                                                      
MFA-TR*       :UC-LIGHT-NO,                                                     
MFA-TR*       :UC-POLE-NO)                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'UC'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8520'               TO WS-DB2-PARAGRAPH             
              MOVE UC-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UC-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE UC-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE UC-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8520-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8525-UPDATE-UM-CNSMPT-HIST.                                      
           IF UC-DATE-USAGE-ENDS = LOW-VALUES                           
              MOVE -1 TO WS-NULL-IND-17                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-17                               
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_UM_CNSMPT_HIST                               
                SET                                                     
                    NO_UNITS             =  :UC-NO-UNITS,               
                    NO_DAYS              =  :UC-NO-DAYS,                
                    CODE_DEBIT_CREDIT    =  :UC-CODE-DEBIT-CREDIT,      
                    USAGE_FIXED          =  :UC-USAGE-FIXED,            
                    DATE_USAGE_ENDS      =  IIF(TRY_CONVERT(DATE, 
                                                   :UC-DATE-USAGE-ENDS 
                                                        :WS-NULL-IND-17
              ) IS NULL OR (PATINDEX('%.%', :UC-DATE-USAGE-ENDS 
                                                        :WS-NULL-IND-17
              ) <> 0) OR (LEN(:UC-DATE-USAGE-ENDS :WS-NULL-IND-17
              ) <> 10), CIS.CHAR2DATE(:UC-DATE-USAGE-ENDS 
                                                        :WS-NULL-IND-17
              ), CONVERT(DATE, :UC-DATE-USAGE-ENDS :WS-NULL-IND-17) ),         
                    CODE_SERVICE_TYPE    =  :UC-CODE-SERVICE-TYPE,      
                    CODE_ITEM_STATUS     =  :UC-CODE-ITEM-STATUS,       
                    CODE_SOURCE_ID       =  :UC-CODE-SOURCE-ID,         
                    MTHLY_AMOUNT_FIXED   =  :UC-MTHLY-AMOUNT-FIXED,     
                    DIST_NO              =  :UC-DIST-NO,                
                    POLE_NO              =  :UC-POLE-NO,                
                    LIGHT_NO             =  :UC-LIGHT-NO                
                WHERE ACCOUNT_NO         = :UC-ACCOUNT-NO               
                  AND BILL_NO            = :UC-BILL-NO                  
                  AND CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE           
                  AND IC_NO              = :UC-IC-NO                    
                  AND ITEM_SEQ_NO        = :UC-ITEM-SEQ-NO              
                  AND RATE_ITEM_CODE     = :UC-RATE-ITEM-CODE           
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :UC-BILL-ITEM-TIMESTMP
              )       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_UM_CNSMPT_HIST                                       
MFA-TR*         SET                                                             
MFA-TR*             NO_UNITS             =  :UC-NO-UNITS,                       
MFA-TR*             NO_DAYS              =  :UC-NO-DAYS,                        
MFA-TR*             CODE_DEBIT_CREDIT    =  :UC-CODE-DEBIT-CREDIT,              
MFA-TR*             USAGE_FIXED          =  :UC-USAGE-FIXED,                    
MFA-TR*             DATE_USAGE_ENDS      =  :UC-DATE-USAGE-ENDS                 
MFA-TR*                                     :WS-NULL-IND-17,                    
MFA-TR*             CODE_SERVICE_TYPE    =  :UC-CODE-SERVICE-TYPE,              
MFA-TR*             CODE_ITEM_STATUS     =  :UC-CODE-ITEM-STATUS,               
MFA-TR*             CODE_SOURCE_ID       =  :UC-CODE-SOURCE-ID,                 
MFA-TR*             MTHLY_AMOUNT_FIXED   =  :UC-MTHLY-AMOUNT-FIXED,             
MFA-TR*             DIST_NO              =  :UC-DIST-NO,                        
MFA-TR*             POLE_NO              =  :UC-POLE-NO,                        
MFA-TR*             LIGHT_NO             =  :UC-LIGHT-NO                        
MFA-TR*         WHERE ACCOUNT_NO         = :UC-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :UC-BILL-NO                          
MFA-TR*           AND CODE_UTIL_TYPE     = :UC-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :UC-IC-NO                            
MFA-TR*           AND ITEM_SEQ_NO        = :UC-ITEM-SEQ-NO                      
MFA-TR*           AND RATE_ITEM_CODE     = :UC-RATE-ITEM-CODE                   
MFA-TR*           AND BILL_ITEM_TIMESTMP = :UC-BILL-ITEM-TIMESTMP               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'UC'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8525'               TO WS-DB2-PARAGRAPH             
              MOVE UC-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UC-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE UC-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE UC-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /                                                                         
       8705-DELETE-CNSMPTN-HIST.                                        
           EXEC SQL                                                     
                DELETE                                                  
                FROM CSS_CNSMPTN_HIST                                   
                WHERE CURRENT OF CNSMPTN_HIST                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'CX'                 TO WS-DB2-TABLE-ID              
              MOVE 'DELETE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8705'               TO WS-DB2-PARAGRAPH             
              MOVE CX-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE CX-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE CX-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE CX-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8705-EXIT.                                                       
           EXIT.                                                        
P00496                                                                  
P00496 8707-INSERT-CNSMPTN-HOURLY.                                      
P00496                                                                  
P00496     EXEC SQL                                                     
P00496          INSERT INTO CSS_CNSMPTN_HRLY                            
P00496           (ACCOUNT_NO,                                           
P00496            CODE_UTIL_TYPE,                                       
P00496            IC_NO,                                                
P00496            BILL_NO,                                              
P00496            BILL_ITEM_TIMESTMP,                                   
P00496            CMPNT_ID_CD,                                          
P00496            BLOCK_NO,                                             
P00496            INSTR_USE_TYPE_CD,                                    
P00496            DATE_READ,                                            
P00496            TIME_READ,                                            
P00496            DST_CHNG_IND,                                         
P00496            NO_UNITS,                                             
P00496            TOTAL_UNIT_PRICE,                                     
P00496            VARIABL_UNIT_PRICE)                                   
P00496          VALUES                                                  
P00496           (:2C-ACCOUNT-NO,                                       
P00496            :2C-CODE-UTIL-TYPE,                                   
P00496            :2C-IC-NO,                                            
P00496            :2C-BILL-NO,                                          
P00496            CIS.CHAR2TIMESTAMP(:2C-BILL-ITEM-TIMESTMP),                   
P00496            :2C-CMPNT-ID-CD,                                      
P00496            :2C-BLOCK-NO,                                         
P00496            :2C-INSTR-USE-TYPE-CD,                                
P00496            IIF(TRY_CONVERT(DATE, :2C-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :2C-DATE-READ
              ) <> 0) OR (LEN(:2C-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :2C-DATE-READ
              ), CONVERT(DATE, :2C-DATE-READ) ),                               
P00496            CIS.CHAR2TIME(:2C-TIME-READ),                                 
P00496            :2C-DST-CHNG-IND,                                     
P00496            :2C-NO-UNITS,                                         
P00496            :2C-TOTAL-UNIT-PRICE,                                 
P00496            :2C-VARIABL-UNIT-PRICE)                               
P00496     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_CNSMPTN_HRLY                                    
MFA-TR*          (ACCOUNT_NO,                                                   
MFA-TR*           CODE_UTIL_TYPE,                                               
MFA-TR*           IC_NO,                                                        
MFA-TR*           BILL_NO,                                                      
MFA-TR*           BILL_ITEM_TIMESTMP,                                           
MFA-TR*           CMPNT_ID_CD,                                                  
MFA-TR*           BLOCK_NO,                                                     
MFA-TR*           INSTR_USE_TYPE_CD,                                            
MFA-TR*           DATE_READ,                                                    
MFA-TR*           TIME_READ,                                                    
MFA-TR*           DST_CHNG_IND,                                                 
MFA-TR*           NO_UNITS,                                                     
MFA-TR*           TOTAL_UNIT_PRICE,                                             
MFA-TR*           VARIABL_UNIT_PRICE)                                           
MFA-TR*         VALUES                                                          
MFA-TR*          (:2C-ACCOUNT-NO,                                               
MFA-TR*           :2C-CODE-UTIL-TYPE,                                           
MFA-TR*           :2C-IC-NO,                                                    
MFA-TR*           :2C-BILL-NO,                                                  
MFA-TR*           :2C-BILL-ITEM-TIMESTMP,                                       
MFA-TR*           :2C-CMPNT-ID-CD,                                              
MFA-TR*           :2C-BLOCK-NO,                                                 
MFA-TR*           :2C-INSTR-USE-TYPE-CD,                                        
MFA-TR*           :2C-DATE-READ,                                                
MFA-TR*           :2C-TIME-READ,                                                
MFA-TR*           :2C-DST-CHNG-IND,                                             
MFA-TR*           :2C-NO-UNITS,                                                 
MFA-TR*           :2C-TOTAL-UNIT-PRICE,                                         
MFA-TR*           :2C-VARIABL-UNIT-PRICE)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00496                                                                  
P00496     EVALUATE SQLCODE                                             
P00496        WHEN SUCCESSFUL-CALL                                      
P00496           GO TO 8707-EXIT                                        
P00496        WHEN ALREADY-EXISTS                                       
P00496           GO TO 8707-EXIT                                        
P00496        WHEN OTHER                                                
P00496           MOVE '2C'                 TO WS-DB2-TABLE-ID           
P00496           MOVE 'INSERT'             TO WS-DB2-FUNCTION           
P00496           MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
P00496           MOVE '114'                TO WS-DB2-MODULE-ID          
P00496           MOVE '8707'               TO WS-DB2-PARAGRAPH          
P00496           MOVE 2C-ACCOUNT-NO        TO WS-DB2-KEY-1N             
P00496           MOVE 2C-BILL-NO           TO WS-DB2-KEY-2N             
P00496           MOVE 2C-CODE-UTIL-TYPE    TO WS-DB2-KEY-3              
P00496           MOVE 2C-IC-NO             TO WS-DB2-KEY-4N             
P00496           MOVE 12 TO RETURN-CODE                                 
P00496           PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
P00496     END-EVALUATE.                                                
P00496                                                                  
P00496 8707-EXIT.                                                       
P00496     EXIT.                                                        
      /                                                                         
       8710-INSERT-CNSMPTN-HIST.                                        
           IF CX-DATE-READ = LOW-VALUES OR SPACES                       
              MOVE -1 TO WS-NULL-IND-18                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-18                               
           END-IF                                                       
                                                                        
A03446     IF CX-PEAK-DEMAND-DT = LOW-VALUES OR SPACES                  
A03446        MOVE -1 TO WS-NULL-IND-32                                 
A03446     ELSE                                                         
A03446        MOVE ZERO TO WS-NULL-IND-32                               
A03446     END-IF                                                       
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_CNSMPTN_HIST                            
                 (ACCOUNT_NO,                                           
                  CODE_UTIL_TYPE,                                       
                  IC_NO,                                                
                  BILL_NO,                                              
                  BILL_ITEM_TIMESTMP,                                   
                  METER_NO,                                             
                  MTR_REF_NO,                                           
                  REG_ID_NO,                                            
                  CODE_USAGE_TYPE,                                      
                  CODE_USAGE_ID,                                        
                  CODE_USAGE_SOURCE,                                    
                  ITEM_SEQ_NO,                                          
                  DATE_READ,                                            
                  CODE_METER_READ,                                      
                  CODE_METER_NO_READ,                                   
                  METER_READING,                                        
                  DEMAND_READING,                                       
                  EMPLOYEE_NO,                                          
                  NO_UNITS,                                             
                  NO_DEMAND_UNITS,                                      
                  NO_DAYS,                                              
                  CODE_SOURCE_ID,                                       
                  CODE_DEBIT_CREDIT,                                    
                  CODE_ITEM_STATUS,                                     
                  CODE_DISCOUNT,                                        
                  NO_DIALS,                                             
                  CODE_TIME_PERIOD,                                     
                  CONSTANT,                                             
                  COMPANY_NO,                                           
                  EXCEPT_OVERRIDE_CD,                                   
                  REQUESTED_USAGE,                                      
                  DIGTL_INTRL_MTR_NO,                                   
                  CODE_TOU_SEASN,                                       
                  EXCL_DMD_RCHT_IND,                                    
                  MTR_READ_SOURCE_CD,                                   
                  DIGTL_MTR_TYPE,                                       
T30989            PCOMP_FCT                                             
A03446           ,PEAK_DEMAND_DT                                        
A03446           ,PRV_MTR_RD_COMB_FL)                                   
                VALUES                                                  
                 (:CX-ACCOUNT-NO,                                       
                  :CX-CODE-UTIL-TYPE,                                   
                  :CX-IC-NO,                                            
                  :CX-BILL-NO,                                          
                  CIS.CHAR2TIMESTAMP(:CX-BILL-ITEM-TIMESTMP),                   
                  :CX-METER-NO,                                         
                  :CX-MTR-REF-NO,                                       
                  :CX-REG-ID-NO,                                        
                  :CX-CODE-USAGE-TYPE,                                  
                  :CX-CODE-USAGE-ID,                                    
                  :CX-CODE-USAGE-SOURCE,                                
                  :CX-ITEM-SEQ-NO,                                      
                  IIF(TRY_CONVERT(DATE, :CX-DATE-READ :WS-NULL-IND-18
              ) IS NULL OR (PATINDEX('%.%', :CX-DATE-READ 
                                                        :WS-NULL-IND-18
              ) <> 0) OR (LEN(:CX-DATE-READ :WS-NULL-IND-18
              ) <> 10), CIS.CHAR2DATE(:CX-DATE-READ :WS-NULL-IND-18
              ), CONVERT(DATE, :CX-DATE-READ :WS-NULL-IND-18) ),               
                  :CX-CODE-METER-READ,                                  
                  :CX-CODE-METER-NO-READ,                               
                  :CX-METER-READING,                                    
                  :CX-DEMAND-READING,                                   
                  :CX-EMPLOYEE-NO,                                      
                  :CX-NO-UNITS,                                         
                  :CX-NO-DEMAND-UNITS,                                  
                  :CX-NO-DAYS,                                          
                  :CX-CODE-SOURCE-ID,                                   
                  :CX-CODE-DEBIT-CREDIT,                                
                  :CX-CODE-ITEM-STATUS,                                 
                  :CX-CODE-DISCOUNT,                                    
                  :CX-NO-DIALS,                                         
                  :CX-CODE-TIME-PERIOD,                                 
                  :CX-CONSTANT,                                         
                  :CX-COMPANY-NO,                                       
                  :CX-EXCEPT-OVERRIDE-CD,                               
                  :CX-REQUESTED-USAGE,                                  
                  :CX-DIGTL-INTRL-MTR-NO,                               
                  :CX-CODE-TOU-SEASN,                                   
                  :CX-EXCL-DMD-RCHT-IND,                                
                  :CX-MTR-READ-SOURCE-CD,                               
                  :CX-DIGTL-MTR-TYPE,                                   
T30989            :CX-PCOMP-FCT                                         
A03446           ,IIF(TRY_CONVERT(DATE, :CX-PEAK-DEMAND-DT 
                                        :WS-NULL-IND-32
              ) IS NULL OR (PATINDEX('%.%', :CX-PEAK-DEMAND-DT 
                                                        :WS-NULL-IND-32
              ) <> 0) OR (LEN(:CX-PEAK-DEMAND-DT :WS-NULL-IND-32
              ) <> 10), CIS.CHAR2DATE(:CX-PEAK-DEMAND-DT 
                                                        :WS-NULL-IND-32
              ), CONVERT(DATE, :CX-PEAK-DEMAND-DT :WS-NULL-IND-32) )           
A03446           ,:CX-PRV-MTR-RD-COMB-FL)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_CNSMPTN_HIST                                    
MFA-TR*          (ACCOUNT_NO,                                                   
MFA-TR*           CODE_UTIL_TYPE,                                               
MFA-TR*           IC_NO,                                                        
MFA-TR*           BILL_NO,                                                      
MFA-TR*           BILL_ITEM_TIMESTMP,                                           
MFA-TR*           METER_NO,                                                     
MFA-TR*           MTR_REF_NO,                                                   
MFA-TR*           REG_ID_NO,                                                    
MFA-TR*           CODE_USAGE_TYPE,                                              
MFA-TR*           CODE_USAGE_ID,                                                
MFA-TR*           CODE_USAGE_SOURCE,                                            
MFA-TR*           ITEM_SEQ_NO,                                                  
MFA-TR*           DATE_READ,                                                    
MFA-TR*           CODE_METER_READ,                                              
MFA-TR*           CODE_METER_NO_READ,                                           
MFA-TR*           METER_READING,                                                
MFA-TR*           DEMAND_READING,                                               
MFA-TR*           EMPLOYEE_NO,                                                  
MFA-TR*           NO_UNITS,                                                     
MFA-TR*           NO_DEMAND_UNITS,                                              
MFA-TR*           NO_DAYS,                                                      
MFA-TR*           CODE_SOURCE_ID,                                               
MFA-TR*           CODE_DEBIT_CREDIT,                                            
MFA-TR*           CODE_ITEM_STATUS,                                             
MFA-TR*           CODE_DISCOUNT,                                                
MFA-TR*           NO_DIALS,                                                     
MFA-TR*           CODE_TIME_PERIOD,                                             
MFA-TR*           CONSTANT,                                                     
MFA-TR*           COMPANY_NO,                                                   
MFA-TR*           EXCEPT_OVERRIDE_CD,                                           
MFA-TR*           REQUESTED_USAGE,                                              
MFA-TR*           DIGTL_INTRL_MTR_NO,                                           
MFA-TR*           CODE_TOU_SEASN,                                               
MFA-TR*           EXCL_DMD_RCHT_IND,                                            
MFA-TR*           MTR_READ_SOURCE_CD,                                           
MFA-TR*           DIGTL_MTR_TYPE,                                               
MFA-TR*           PCOMP_FCT                                                     
MFA-TR*          ,PEAK_DEMAND_DT                                        01311000
MFA-TR*          ,PRV_MTR_RD_COMB_FL)                                   01311000
MFA-TR*         VALUES                                                          
MFA-TR*          (:CX-ACCOUNT-NO,                                               
MFA-TR*           :CX-CODE-UTIL-TYPE,                                           
MFA-TR*           :CX-IC-NO,                                                    
MFA-TR*           :CX-BILL-NO,                                                  
MFA-TR*           :CX-BILL-ITEM-TIMESTMP,                                       
MFA-TR*           :CX-METER-NO,                                                 
MFA-TR*           :CX-MTR-REF-NO,                                               
MFA-TR*           :CX-REG-ID-NO,                                                
MFA-TR*           :CX-CODE-USAGE-TYPE,                                          
MFA-TR*           :CX-CODE-USAGE-ID,                                            
MFA-TR*           :CX-CODE-USAGE-SOURCE,                                        
MFA-TR*           :CX-ITEM-SEQ-NO,                                              
MFA-TR*           :CX-DATE-READ :WS-NULL-IND-18,                                
MFA-TR*           :CX-CODE-METER-READ,                                          
MFA-TR*           :CX-CODE-METER-NO-READ,                                       
MFA-TR*           :CX-METER-READING,                                            
MFA-TR*           :CX-DEMAND-READING,                                           
MFA-TR*           :CX-EMPLOYEE-NO,                                              
MFA-TR*           :CX-NO-UNITS,                                                 
MFA-TR*           :CX-NO-DEMAND-UNITS,                                          
MFA-TR*           :CX-NO-DAYS,                                                  
MFA-TR*           :CX-CODE-SOURCE-ID,                                           
MFA-TR*           :CX-CODE-DEBIT-CREDIT,                                        
MFA-TR*           :CX-CODE-ITEM-STATUS,                                         
MFA-TR*           :CX-CODE-DISCOUNT,                                            
MFA-TR*           :CX-NO-DIALS,                                                 
MFA-TR*           :CX-CODE-TIME-PERIOD,                                         
MFA-TR*           :CX-CONSTANT,                                                 
MFA-TR*           :CX-COMPANY-NO,                                               
MFA-TR*           :CX-EXCEPT-OVERRIDE-CD,                                       
MFA-TR*           :CX-REQUESTED-USAGE,                                          
MFA-TR*           :CX-DIGTL-INTRL-MTR-NO,                                       
MFA-TR*           :CX-CODE-TOU-SEASN,                                           
MFA-TR*           :CX-EXCL-DMD-RCHT-IND,                                        
MFA-TR*           :CX-MTR-READ-SOURCE-CD,                                       
MFA-TR*           :CX-DIGTL-MTR-TYPE,                                           
MFA-TR*           :CX-PCOMP-FCT                                                 
MFA-TR*          ,:CX-PEAK-DEMAND-DT :WS-NULL-IND-32                    15920000
MFA-TR*          ,:CX-PRV-MTR-RD-COMB-FL)                               15920000
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
TP4822     EVALUATE SQLCODE                                             
TP4822     WHEN SUCCESSFUL-CALL                                         
TP4822        GO TO 8710-EXIT                                           
TP4822     WHEN ALREADY-EXISTS                                          
TP4822        PERFORM 8711-DO-AGAIN  THRU  8711-EXIT                    
TP4822     WHEN OTHER                                                   
TP4822*    IF SQLCODE NOT = SUCCESSFUL-CALL                                     
              MOVE 'CX'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8710'               TO WS-DB2-PARAGRAPH             
              MOVE CX-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE CX-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE CX-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE CX-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
TP4822        END-EVALUATE.                                             
TP4822*    END-IF.                                                              
       8710-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
TP4822 8711-DO-AGAIN.                                                   
TP4822       PERFORM 8712-GET-NEXT-SEQ-NO  THRU  8712-EXIT.             
TP4822       COMPUTE WS-MAX-ITEM-SEQ-NO = WS-MAX-ITEM-SEQ-NO + 1.       
TP4822       MOVE WS-MAX-ITEM-SEQ-NO  TO CX-ITEM-SEQ-NO.                
TP4822       PERFORM 8710-INSERT-CNSMPTN-HIST  THRU  8710-EXIT.         
TP4822 8711-EXIT.                                                       
TP4822     EXIT.                                                        
      /                                                                         
TP4822 8712-GET-NEXT-SEQ-NO.                                            
TP4822                                                                  
TP4822     EXEC SQL                                                     
TP4822        SELECT MAX(ITEM_SEQ_NO)                                   
TP4822          INTO :WS-MAX-ITEM-SEQ-NO                                
TP4822          FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                     
TP4822         WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                
TP4822           AND BILL_NO            = :CX-BILL-NO                   
TP4822           AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE            
TP4822           AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )        
TP4822           AND IC_NO              = :CX-IC-NO                     
TP4822           AND MTR_REF_NO         = :CX-MTR-REF-NO                
TP4822           AND REG_ID_NO          = :CX-REG-ID-NO                 
TP4822           AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD          
T33182                                                           
TP4822     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(ITEM_SEQ_NO)                                           
MFA-TR*         INTO :WS-MAX-ITEM-SEQ-NO                                        
MFA-TR*         FROM CSS_CNSMPTN_HIST                                           
MFA-TR*        WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                        
MFA-TR*          AND BILL_NO            = :CX-BILL-NO                           
MFA-TR*          AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                    
MFA-TR*          AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP                
MFA-TR*          AND IC_NO              = :CX-IC-NO                             
MFA-TR*          AND MTR_REF_NO         = :CX-MTR-REF-NO                        
MFA-TR*          AND REG_ID_NO          = :CX-REG-ID-NO                         
MFA-TR*          AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP4822                                                                  
TP4822     IF SQLCODE NOT = SUCCESSFUL-CALL                             
TP4822        MOVE 'CX'                 TO WS-DB2-TABLE-ID              
TP4822        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
TP4822        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
TP4822        MOVE '114'                TO WS-DB2-MODULE-ID             
TP4822        MOVE '8712'               TO WS-DB2-PARAGRAPH             
TP4822        MOVE CX-ACCOUNT-NO        TO WS-DB2-KEY-1N                
TP4822        MOVE CX-BILL-NO           TO WS-DB2-KEY-2N                
TP4822        MOVE CX-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
TP4822        MOVE CX-IC-NO             TO WS-DB2-KEY-4N                
TP4822        MOVE 12 TO RETURN-CODE                                    
TP4822        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
TP4822     END-IF.                                                      
TP4822                                                                  
TP4822 8712-EXIT.                                                       
TP4822     EXIT.                                                        
                                                                        
      /                                                                         
       8715-UPDATE-CNSMPTN-HIST.                                        
           IF CX-DATE-READ = LOW-VALUES                                 
              MOVE -1 TO WS-NULL-IND-18                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-18                               
           END-IF                                                       
A03446     IF CX-PEAK-DEMAND-DT = LOW-VALUES OR SPACES                  
A03446        MOVE -1 TO WS-NULL-IND-32                                 
A03446     ELSE                                                         
A03446        MOVE ZERO TO WS-NULL-IND-32                               
A03446     END-IF                                                       
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_CNSMPTN_HIST                                 
                SET                                                     
                    METER_NO         =  :CX-METER-NO,                   
                    DATE_READ        =  IIF(TRY_CONVERT(DATE, 
                                                         :CX-DATE-READ 
                                                        :WS-NULL-IND-18
              ) IS NULL OR (PATINDEX('%.%', :CX-DATE-READ 
                                                        :WS-NULL-IND-18
              ) <> 0) OR (LEN(:CX-DATE-READ :WS-NULL-IND-18
              ) <> 10), CIS.CHAR2DATE(:CX-DATE-READ :WS-NULL-IND-18
              ), CONVERT(DATE, :CX-DATE-READ :WS-NULL-IND-18) ),               
                    CODE_METER_READ  =  :CX-CODE-METER-READ,            
                    CODE_METER_NO_READ  = :CX-CODE-METER-NO-READ,       
                    METER_READING    =  :CX-METER-READING,              
                    DEMAND_READING   =  :CX-DEMAND-READING,             
                    EMPLOYEE_NO      =  :CX-EMPLOYEE-NO,                
                    NO_UNITS         =  :CX-NO-UNITS,                   
                    NO_DEMAND_UNITS  =  :CX-NO-DEMAND-UNITS,            
                    NO_DAYS          =  :CX-NO-DAYS,                    
                    CODE_SOURCE_ID   =  :CX-CODE-SOURCE-ID,             
                    CODE_DEBIT_CREDIT  =  :CX-CODE-DEBIT-CREDIT,        
                    CODE_ITEM_STATUS  =  :CX-CODE-ITEM-STATUS,          
                    CODE_DISCOUNT    =  :CX-CODE-DISCOUNT,              
                    CONSTANT         =  :CX-CONSTANT,                   
                    NO_DIALS         =  :CX-NO-DIALS,                   
                    COMPANY_NO       =  :CX-COMPANY-NO,                 
                    EXCEPT_OVERRIDE_CD  =  :CX-EXCEPT-OVERRIDE-CD,      
                    REQUESTED_USAGE  =  :CX-REQUESTED-USAGE,            
                    DIGTL_INTRL_MTR_NO  = :CX-DIGTL-INTRL-MTR-NO,       
                    DIGTL_MTR_TYPE   =  :CX-DIGTL-MTR-TYPE,             
                    CODE_TOU_SEASN   =  :CX-CODE-TOU-SEASN,             
                    EXCL_DMD_RCHT_IND = :CX-EXCL-DMD-RCHT-IND,          
                    MTR_READ_SOURCE_CD = :CX-MTR-READ-SOURCE-CD,        
T30989              PCOMP_FCT          = :CX-PCOMP-FCT                  
A03446             ,PEAK_DEMAND_DT     = IIF(TRY_CONVERT(DATE, 
                                                    :CX-PEAK-DEMAND-DT 
                                                        :WS-NULL-IND-32
              ) IS NULL OR (PATINDEX('%.%', :CX-PEAK-DEMAND-DT 
                                                        :WS-NULL-IND-32
              ) <> 0) OR (LEN(:CX-PEAK-DEMAND-DT :WS-NULL-IND-32
              ) <> 10), CIS.CHAR2DATE(:CX-PEAK-DEMAND-DT 
                                                        :WS-NULL-IND-32
              ), CONVERT(DATE, :CX-PEAK-DEMAND-DT :WS-NULL-IND-32) )           
A03446             ,PRV_MTR_RD_COMB_FL = :CX-PRV-MTR-RD-COMB-FL         
                WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO         AND   
                      BILL_NO            = :CX-BILL-NO            AND   
                      CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE     AND   
                      BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              ) AND   
                      IC_NO              = :CX-IC-NO              AND   
                      MTR_REF_NO         = :CX-MTR-REF-NO         AND   
                      CODE_USAGE_TYPE    = :CX-CODE-USAGE-TYPE    AND   
                      CODE_USAGE_ID      = :CX-CODE-USAGE-ID      AND   
                      CODE_USAGE_SOURCE  = :CX-CODE-USAGE-SOURCE  AND   
                      CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD   AND   
                      ITEM_SEQ_NO        = :CX-ITEM-SEQ-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_CNSMPTN_HIST                                         
MFA-TR*         SET                                                             
MFA-TR*             METER_NO         =  :CX-METER-NO,                           
MFA-TR*             DATE_READ        =  :CX-DATE-READ                           
MFA-TR*                                 :WS-NULL-IND-18,                        
MFA-TR*             CODE_METER_READ  =  :CX-CODE-METER-READ,                    
MFA-TR*             CODE_METER_NO_READ  = :CX-CODE-METER-NO-READ,               
MFA-TR*             METER_READING    =  :CX-METER-READING,                      
MFA-TR*             DEMAND_READING   =  :CX-DEMAND-READING,                     
MFA-TR*             EMPLOYEE_NO      =  :CX-EMPLOYEE-NO,                        
MFA-TR*             NO_UNITS         =  :CX-NO-UNITS,                           
MFA-TR*             NO_DEMAND_UNITS  =  :CX-NO-DEMAND-UNITS,                    
MFA-TR*             NO_DAYS          =  :CX-NO-DAYS,                            
MFA-TR*             CODE_SOURCE_ID   =  :CX-CODE-SOURCE-ID,                     
MFA-TR*             CODE_DEBIT_CREDIT  =  :CX-CODE-DEBIT-CREDIT,                
MFA-TR*             CODE_ITEM_STATUS  =  :CX-CODE-ITEM-STATUS,                  
MFA-TR*             CODE_DISCOUNT    =  :CX-CODE-DISCOUNT,                      
MFA-TR*             CONSTANT         =  :CX-CONSTANT,                           
MFA-TR*             NO_DIALS         =  :CX-NO-DIALS,                           
MFA-TR*             COMPANY_NO       =  :CX-COMPANY-NO,                         
MFA-TR*             EXCEPT_OVERRIDE_CD  =  :CX-EXCEPT-OVERRIDE-CD,              
MFA-TR*             REQUESTED_USAGE  =  :CX-REQUESTED-USAGE,                    
MFA-TR*             DIGTL_INTRL_MTR_NO  = :CX-DIGTL-INTRL-MTR-NO,               
MFA-TR*             DIGTL_MTR_TYPE   =  :CX-DIGTL-MTR-TYPE,                     
MFA-TR*             CODE_TOU_SEASN   =  :CX-CODE-TOU-SEASN,                     
MFA-TR*             EXCL_DMD_RCHT_IND = :CX-EXCL-DMD-RCHT-IND,                  
MFA-TR*             MTR_READ_SOURCE_CD = :CX-MTR-READ-SOURCE-CD,                
MFA-TR*             PCOMP_FCT          = :CX-PCOMP-FCT                          
MFA-TR*            ,PEAK_DEMAND_DT     = :CX-PEAK-DEMAND-DT                     
MFA-TR*                                  :WS-NULL-IND-32                        
MFA-TR*            ,PRV_MTR_RD_COMB_FL = :CX-PRV-MTR-RD-COMB-FL                 
MFA-TR*         WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO         AND           
MFA-TR*               BILL_NO            = :CX-BILL-NO            AND           
MFA-TR*               CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE     AND           
MFA-TR*               BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP AND           
MFA-TR*               IC_NO              = :CX-IC-NO              AND           
MFA-TR*               MTR_REF_NO         = :CX-MTR-REF-NO         AND           
MFA-TR*               CODE_USAGE_TYPE    = :CX-CODE-USAGE-TYPE    AND           
MFA-TR*               CODE_USAGE_ID      = :CX-CODE-USAGE-ID      AND           
MFA-TR*               CODE_USAGE_SOURCE  = :CX-CODE-USAGE-SOURCE  AND           
MFA-TR*               CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD   AND           
MFA-TR*               ITEM_SEQ_NO        = :CX-ITEM-SEQ-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'CX'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8715'               TO WS-DB2-PARAGRAPH             
              MOVE CX-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE CX-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE CX-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE CX-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       8715-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /                                                                         
       8720-INSERT-FCT-HIST.                                            
           IF FH-EFF-DATE-TO = LOW-VALUES OR SPACES                     
              MOVE -1 TO WS-NULL-IND-20                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-20                               
           END-IF                                                       
                                                                        
C34569     IF FH-DURATION-REMAIN-NO = -1                                
C34569        MOVE -1 TO WS-NULL-IND-21                                 
C34569     ELSE                                                         
C34569        MOVE ZERO TO WS-NULL-IND-21                               
C34569     END-IF                                                       
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_FIXED_FCT_HIST                          
                 (ACCOUNT_NO,                                           
                  BILL_NO,                                              
                  CODE_UTIL_TYPE,                                       
                  IC_NO,                                                
                  BILL_ITEM_TIMESTMP,                                   
                  FIXED_FCTR_SEQ_NO,                                    
                  FACTOR_ID,                                            
                  EFF_DATE_FROM,                                        
                  CMPNT_ID_CD,                                          
                  CODE_SEASON,                                          
                  INSTR_USE_TYPE_CD,                                    
                  CODE_TIME_PERIOD,                                     
                  CODE_DEBIT_CREDIT,                                    
                  CODE_REVENUE_CLASS,                                   
                  CODE_TAX_STAT_XMT,                                    
                  CODE_TAX_CITY_XMT,                                    
                  CODE_TAX_OTHR_XMT,                                    
                  FACTOR,                                               
                  EFF_DATE_TO,                                          
                  FIXED_FCTR_TYP_CD,                                    
C34569            DURATION_REMAIN_NO,                                   
C34569            OVR_RT_VER_PRO_FL,                                    
C34569            RT_PKG_OPT_SEQ_NO,                                    
P00165            BLOCK_NO,                                             
A03303            FCTR_POWER_10,                                        
CIG               BILL_UNITS,                                           
CIG               ENERGY_UNIT_CD)                                       
                VALUES                                                  
                 (:FH-ACCOUNT-NO,                                       
                  :FH-BILL-NO,                                          
                  :FH-CODE-UTIL-TYPE,                                   
                  :FH-IC-NO,                                            
                  CIS.CHAR2TIMESTAMP(:FH-BILL-ITEM-TIMESTMP),                   
                  :FH-FIXED-FCTR-SEQ-NO,                                
                  :FH-FACTOR-ID,                                        
                  IIF(TRY_CONVERT(DATE, :FH-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FH-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FH-EFF-DATE-FROM
              ), CONVERT(DATE, :FH-EFF-DATE-FROM) ),                           
                  :FH-CMPNT-ID-CD,                                      
                  :FH-CODE-SEASON,                                      
                  :FH-INSTR-USE-TYPE-CD,                                
                  :FH-CODE-TIME-PERIOD,                                 
                  :FH-CODE-DEBIT-CREDIT,                                
                  :FH-CODE-REVENUE-CLASS,                               
                  :FH-CODE-TAX-STAT-XMT,                                
                  :FH-CODE-TAX-CITY-XMT,                                
                  :FH-CODE-TAX-OTHR-XMT,                                
                  :FH-FACTOR,                                           
                  IIF(TRY_CONVERT(DATE, :FH-EFF-DATE-TO :WS-NULL-IND-20
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-TO 
                                                        :WS-NULL-IND-20
              ) <> 0) OR (LEN(:FH-EFF-DATE-TO :WS-NULL-IND-20
              ) <> 10), CIS.CHAR2DATE(:FH-EFF-DATE-TO :WS-NULL-IND-20
              ), CONVERT(DATE, :FH-EFF-DATE-TO :WS-NULL-IND-20) ),             
                  :FH-FIXED-FCTR-TYP-CD,                                
C34569            :FH-DURATION-REMAIN-NO :WS-NULL-IND-21,               
C34569            :FH-OVR-RT-VER-PRO-FL,                                
C34569            :FH-RT-PKG-OPT-SEQ-NO,                                
P00165            :FH-BLOCK-NO,                                         
A03303            :FH-FCTR-POWER-10,                                    
CIG               :FH-BILL-UNITS,                                       
CIG               :FH-ENERGY-UNIT-CD)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_FIXED_FCT_HIST                                  
MFA-TR*          (ACCOUNT_NO,                                                   
MFA-TR*           BILL_NO,                                                      
MFA-TR*           CODE_UTIL_TYPE,                                               
MFA-TR*           IC_NO,                                                        
MFA-TR*           BILL_ITEM_TIMESTMP,                                           
MFA-TR*           FIXED_FCTR_SEQ_NO,                                            
MFA-TR*           FACTOR_ID,                                                    
MFA-TR*           EFF_DATE_FROM,                                                
MFA-TR*           CMPNT_ID_CD,                                                  
MFA-TR*           CODE_SEASON,                                                  
MFA-TR*           INSTR_USE_TYPE_CD,                                            
MFA-TR*           CODE_TIME_PERIOD,                                             
MFA-TR*           CODE_DEBIT_CREDIT,                                            
MFA-TR*           CODE_REVENUE_CLASS,                                           
MFA-TR*           CODE_TAX_STAT_XMT,                                            
MFA-TR*           CODE_TAX_CITY_XMT,                                            
MFA-TR*           CODE_TAX_OTHR_XMT,                                            
MFA-TR*           FACTOR,                                                       
MFA-TR*           EFF_DATE_TO,                                                  
MFA-TR*           FIXED_FCTR_TYP_CD,                                            
MFA-TR*           DURATION_REMAIN_NO,                                           
MFA-TR*           OVR_RT_VER_PRO_FL,                                            
MFA-TR*           RT_PKG_OPT_SEQ_NO,                                            
MFA-TR*           BLOCK_NO,                                                     
MFA-TR*           FCTR_POWER_10,                                                
MFA-TR*           BILL_UNITS,                                                   
MFA-TR*           ENERGY_UNIT_CD)                                               
MFA-TR*         VALUES                                                          
MFA-TR*          (:FH-ACCOUNT-NO,                                               
MFA-TR*           :FH-BILL-NO,                                                  
MFA-TR*           :FH-CODE-UTIL-TYPE,                                           
MFA-TR*           :FH-IC-NO,                                                    
MFA-TR*           :FH-BILL-ITEM-TIMESTMP,                                       
MFA-TR*           :FH-FIXED-FCTR-SEQ-NO,                                        
MFA-TR*           :FH-FACTOR-ID,                                                
MFA-TR*           :FH-EFF-DATE-FROM,                                            
MFA-TR*           :FH-CMPNT-ID-CD,                                              
MFA-TR*           :FH-CODE-SEASON,                                              
MFA-TR*           :FH-INSTR-USE-TYPE-CD,                                        
MFA-TR*           :FH-CODE-TIME-PERIOD,                                         
MFA-TR*           :FH-CODE-DEBIT-CREDIT,                                        
MFA-TR*           :FH-CODE-REVENUE-CLASS,                                       
MFA-TR*           :FH-CODE-TAX-STAT-XMT,                                        
MFA-TR*           :FH-CODE-TAX-CITY-XMT,                                        
MFA-TR*           :FH-CODE-TAX-OTHR-XMT,                                        
MFA-TR*           :FH-FACTOR,                                                   
MFA-TR*           :FH-EFF-DATE-TO :WS-NULL-IND-20,                              
MFA-TR*           :FH-FIXED-FCTR-TYP-CD,                                        
MFA-TR*           :FH-DURATION-REMAIN-NO :WS-NULL-IND-21,                       
MFA-TR*           :FH-OVR-RT-VER-PRO-FL,                                        
MFA-TR*           :FH-RT-PKG-OPT-SEQ-NO,                                        
MFA-TR*           :FH-BLOCK-NO,                                                 
MFA-TR*           :FH-FCTR-POWER-10,                                            
MFA-TR*           :FH-BILL-UNITS,                                               
MFA-TR*           :FH-ENERGY-UNIT-CD)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T21155     EVALUATE SQLCODE                                             
T21155        WHEN SUCCESSFUL-CALL                                      
T21155        WHEN ALREADY-EXISTS                                       
T21155             CONTINUE                                             
T21155        WHEN OTHER                                                
                  MOVE 'FH'                 TO WS-DB2-TABLE-ID          
                  MOVE 'INSERT'             TO WS-DB2-FUNCTION          
                  MOVE SQLCODE              TO WS-DB2-RETURN-CODE       
                  MOVE '114'                TO WS-DB2-MODULE-ID         
                  MOVE '8720'               TO WS-DB2-PARAGRAPH         
                  MOVE FH-ACCOUNT-NO        TO WS-DB2-KEY-1N            
                  MOVE FH-BILL-NO           TO WS-DB2-KEY-2N            
                  MOVE FH-CODE-UTIL-TYPE    TO WS-DB2-KEY-3             
                  MOVE FH-IC-NO             TO WS-DB2-KEY-4N            
                  MOVE 12 TO RETURN-CODE                                
                  PERFORM 9900-SQL-ERROR     THRU 9900-EXIT             
T21155     END-EVALUATE.                                                
       8720-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8730-UPDATE-FCT-HIST.                                            
                                                                        
           IF FH-EFF-DATE-TO = LOW-VALUES                               
              MOVE -1 TO WS-NULL-IND-20                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-20                               
           END-IF                                                       
                                                                        
C34569     IF FH-DURATION-REMAIN-NO = -1                                
C34569        MOVE -1 TO WS-NULL-IND-21                                 
C34569     ELSE                                                         
C34569        MOVE ZERO TO WS-NULL-IND-21                               
C34569     END-IF                                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_FIXED_FCT_HIST                                 
                 SET   EFF_DATE_FROM         =  IIF(TRY_CONVERT(DATE, 
                                                      :FH-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FH-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FH-EFF-DATE-FROM
              ), CONVERT(DATE, :FH-EFF-DATE-FROM) ),      
                       CMPNT_ID_CD           =  :FH-CMPNT-ID-CD,        
                       CODE_SEASON           =  :FH-CODE-SEASON,        
                       INSTR_USE_TYPE_CD     =  :FH-INSTR-USE-TYPE-CD,  
                       CODE_TIME_PERIOD      =  :FH-CODE-TIME-PERIOD,   
                       CODE_DEBIT_CREDIT     =  :FH-CODE-DEBIT-CREDIT,  
                       CODE_REVENUE_CLASS    =  :FH-CODE-REVENUE-CLASS, 
                       CODE_TAX_STAT_XMT     =  :FH-CODE-TAX-STAT-XMT,  
                       CODE_TAX_CITY_XMT     =  :FH-CODE-TAX-CITY-XMT,  
                       CODE_TAX_OTHR_XMT     =  :FH-CODE-TAX-OTHR-XMT,  
                       FACTOR                =  :FH-FACTOR,             
                       EFF_DATE_TO           =  IIF(TRY_CONVERT(DATE, 
                                                       :FH-EFF-DATE-TO 
                                                        :WS-NULL-IND-20
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-TO 
                                                        :WS-NULL-IND-20
              ) <> 0) OR (LEN(:FH-EFF-DATE-TO :WS-NULL-IND-20
              ) <> 10), CIS.CHAR2DATE(:FH-EFF-DATE-TO :WS-NULL-IND-20
              ), CONVERT(DATE, :FH-EFF-DATE-TO :WS-NULL-IND-20) ),        
                       FIXED_FCTR_TYP_CD      =  :FH-FIXED-FCTR-TYP-CD, 
CIG                    BILL_UNITS             =  :FH-BILL-UNITS,        
C34569                 DURATION_REMAIN_NO     = :FH-DURATION-REMAIN-NO 
                                                :WS-NULL-IND-21,        
C34569                 OVR_RT_VER_PRO_FL      = :FH-OVR-RT-VER-PRO-FL,  
C34569                 RT_PKG_OPT_SEQ_NO      = :FH-RT-PKG-OPT-SEQ-NO,  
P00165                 BLOCK_NO               = :FH-BLOCK-NO,           
A03303                 FCTR_POWER_10          = :FH-FCTR-POWER-10,      
CIG                    ENERGY_UNIT_CD         =  :FH-ENERGY-UNIT-CD     
                 WHERE  ACCOUNT_NO            =  :FH-ACCOUNT-NO         
                   AND  BILL_NO               =  :FH-BILL-NO            
                   AND  CODE_UTIL_TYPE        =  :FH-CODE-UTIL-TYPE     
                   AND  IC_NO                 =  :FH-IC-NO              
                   AND  FIXED_FCTR_SEQ_NO     =  :FH-FIXED-FCTR-SEQ-NO  
                   AND  BILL_ITEM_TIMESTMP    =  CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              ) 
                   AND  FACTOR_ID             =  :FH-FACTOR-ID          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIXED_FCT_HIST                                         
MFA-TR*          SET   EFF_DATE_FROM         =  :FH-EFF-DATE-FROM,              
MFA-TR*                CMPNT_ID_CD           =  :FH-CMPNT-ID-CD,                
MFA-TR*                CODE_SEASON           =  :FH-CODE-SEASON,                
MFA-TR*                INSTR_USE_TYPE_CD     =  :FH-INSTR-USE-TYPE-CD,          
MFA-TR*                CODE_TIME_PERIOD      =  :FH-CODE-TIME-PERIOD,           
MFA-TR*                CODE_DEBIT_CREDIT     =  :FH-CODE-DEBIT-CREDIT,          
MFA-TR*                CODE_REVENUE_CLASS    =  :FH-CODE-REVENUE-CLASS,         
MFA-TR*                CODE_TAX_STAT_XMT     =  :FH-CODE-TAX-STAT-XMT,          
MFA-TR*                CODE_TAX_CITY_XMT     =  :FH-CODE-TAX-CITY-XMT,          
MFA-TR*                CODE_TAX_OTHR_XMT     =  :FH-CODE-TAX-OTHR-XMT,          
MFA-TR*                FACTOR                =  :FH-FACTOR,                     
MFA-TR*                EFF_DATE_TO           =  :FH-EFF-DATE-TO                 
MFA-TR*                                         :WS-NULL-IND-20,                
MFA-TR*                FIXED_FCTR_TYP_CD      =  :FH-FIXED-FCTR-TYP-CD,         
MFA-TR*                BILL_UNITS             =  :FH-BILL-UNITS,                
MFA-TR*                DURATION_REMAIN_NO     = :FH-DURATION-REMAIN-NO          
MFA-TR*                                         :WS-NULL-IND-21,                
MFA-TR*                OVR_RT_VER_PRO_FL      = :FH-OVR-RT-VER-PRO-FL,          
MFA-TR*                RT_PKG_OPT_SEQ_NO      = :FH-RT-PKG-OPT-SEQ-NO,          
MFA-TR*                BLOCK_NO               = :FH-BLOCK-NO,                   
MFA-TR*                FCTR_POWER_10          = :FH-FCTR-POWER-10,              
MFA-TR*                ENERGY_UNIT_CD         =  :FH-ENERGY-UNIT-CD             
MFA-TR*          WHERE  ACCOUNT_NO            =  :FH-ACCOUNT-NO                 
MFA-TR*            AND  BILL_NO               =  :FH-BILL-NO                    
MFA-TR*            AND  CODE_UTIL_TYPE        =  :FH-CODE-UTIL-TYPE             
MFA-TR*            AND  IC_NO                 =  :FH-IC-NO                      
MFA-TR*            AND  FIXED_FCTR_SEQ_NO     =  :FH-FIXED-FCTR-SEQ-NO          
MFA-TR*            AND  BILL_ITEM_TIMESTMP    =  :FH-BILL-ITEM-TIMESTMP         
MFA-TR*            AND  FACTOR_ID             =  :FH-FACTOR-ID                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T22488     IF SQLCODE = NOT-FOUND                                       
T22488        CONTINUE                                                  
T22488     ELSE                                                         
T22488        IF SQLCODE NOT = SUCCESSFUL-CALL                          
                 MOVE 'FH'                 TO WS-DB2-TABLE-ID           
                 MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '114'                TO WS-DB2-MODULE-ID          
                 MOVE '8730'               TO WS-DB2-PARAGRAPH          
                 MOVE FH-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE FH-BILL-NO           TO WS-DB2-KEY-2N             
                 MOVE FH-CODE-UTIL-TYPE    TO WS-DB2-KEY-3              
                 MOVE FH-IC-NO             TO WS-DB2-KEY-4N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
T22488        END-IF                                                    
           END-IF.                                                      
       8730-EXIT.                                                       
           EXIT.                                                        
 CIG   8731-UPDATE-FCT-HIST-CIG.                                        
 ST                                                                     
           EXEC SQL                                                     
              UPDATE CSS_FIXED_FCT_HIST                                 
                   SET   FACTOR               =  :FH-FACTOR             
                 WHERE  ACCOUNT_NO            =  :FH-ACCOUNT-NO         
                   AND  BILL_NO               =  :FH-BILL-NO            
                   AND  CODE_UTIL_TYPE        =  :FH-CODE-UTIL-TYPE     
                   AND  IC_NO                 =  :FH-IC-NO              
                   AND  BILL_ITEM_TIMESTMP    =  CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              ) 
                   AND  FACTOR_ID             =  :FH-FACTOR-ID          
                   AND  EFF_DATE_FROM         =  IIF(TRY_CONVERT(DATE, 
                                                      :FH-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FH-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FH-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FH-EFF-DATE-FROM
              ), CONVERT(DATE, :FH-EFF-DATE-FROM) )      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIXED_FCT_HIST                                         
MFA-TR*            SET   FACTOR               =  :FH-FACTOR                     
MFA-TR*          WHERE  ACCOUNT_NO            =  :FH-ACCOUNT-NO                 
MFA-TR*            AND  BILL_NO               =  :FH-BILL-NO                    
MFA-TR*            AND  CODE_UTIL_TYPE        =  :FH-CODE-UTIL-TYPE             
MFA-TR*            AND  IC_NO                 =  :FH-IC-NO                      
MFA-TR*            AND  BILL_ITEM_TIMESTMP    =  :FH-BILL-ITEM-TIMESTMP         
MFA-TR*            AND  FACTOR_ID             =  :FH-FACTOR-ID                  
MFA-TR*            AND  EFF_DATE_FROM         =  :FH-EFF-DATE-FROM              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = NOT-FOUND                                       
              CONTINUE                                                  
           ELSE                                                         
              IF SQLCODE NOT = SUCCESSFUL-CALL                          
                 MOVE 'FH'                 TO WS-DB2-TABLE-ID           
                 MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '114'                TO WS-DB2-MODULE-ID          
                 MOVE '8731'               TO WS-DB2-PARAGRAPH          
                 MOVE FH-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE FH-BILL-NO           TO WS-DB2-KEY-2N             
                 MOVE FH-CODE-UTIL-TYPE    TO WS-DB2-KEY-3              
                 MOVE FH-IC-NO             TO WS-DB2-KEY-4N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
              END-IF                                                    
           END-IF.                                                      
 END   8731-EXIT.                                                       
 CIG       EXIT.                                                        
      /                                                                         
       8732-RESET-FXD-FCTR.                                             
           EXEC SQL                                                     
              UPDATE CSS_FIXED_FCT_HIST                                 
                 SET  FACTOR                  =  0                      
                 WHERE  ACCOUNT_NO            =  :FH-ACCOUNT-NO         
                   AND  CODE_UTIL_TYPE        =  :FH-CODE-UTIL-TYPE     
                   AND  IC_NO                 =  :FH-IC-NO              
                   AND  FACTOR_ID             =  :FH-FACTOR-ID          
                   AND  FIXED_FCTR_SEQ_NO     =  :FH-FIXED-FCTR-SEQ-NO  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'FF'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8732'               TO WS-DB2-PARAGRAPH             
              MOVE FH-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE FH-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
              MOVE FH-IC-NO             TO WS-DB2-KEY-3N                
              MOVE FH-FIXED-FCTR-SEQ-NO TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8732-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT006 8733-DELETE-FCT-HIST.                                            
ACT006     EXEC SQL                                                     
ACT006        DELETE CSS_FIXED_FCT_HIST                                 
ACT006           WHERE  ACCOUNT_NO            =  :FH-ACCOUNT-NO         
ACT006             AND  CODE_UTIL_TYPE        =  :FH-CODE-UTIL-TYPE     
ACT006             AND  IC_NO                 =  :FH-IC-NO              
ACT006             AND  BILL_ITEM_TIMESTMP    =  CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              ) 
ACT006             AND  FIXED_FCTR_SEQ_NO     =  :FH-FIXED-FCTR-SEQ-NO  
ACT006             AND  FACTOR_ID             =  :FH-FACTOR-ID          
ACT006     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE CSS_FIXED_FCT_HIST                                         
MFA-TR*          WHERE  ACCOUNT_NO            =  :FH-ACCOUNT-NO                 
MFA-TR*            AND  CODE_UTIL_TYPE        =  :FH-CODE-UTIL-TYPE             
MFA-TR*            AND  IC_NO                 =  :FH-IC-NO                      
MFA-TR*            AND  BILL_ITEM_TIMESTMP    =  :FH-BILL-ITEM-TIMESTMP         
MFA-TR*            AND  FIXED_FCTR_SEQ_NO     =  :FH-FIXED-FCTR-SEQ-NO          
MFA-TR*            AND  FACTOR_ID             =  :FH-FACTOR-ID                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT006                                                                  
ACT006     IF SQLCODE  = SUCCESSFUL-CALL OR NOT-FOUND                   
ACT006        CONTINUE                                                  
ACT006     ELSE                                                         
ACT006      IF SQLCODE NOT = SUCCESSFUL-CALL                            
ACT006         MOVE 'FH'                 TO WS-DB2-TABLE-ID             
ACT006         MOVE 'DELETE'             TO WS-DB2-FUNCTION             
ACT006         MOVE SQLCODE              TO WS-DB2-RETURN-CODE          
ACT006         MOVE '114'                TO WS-DB2-MODULE-ID            
ACT006         MOVE '8733'               TO WS-DB2-PARAGRAPH            
ACT006         MOVE FH-ACCOUNT-NO        TO WS-DB2-KEY-1N               
ACT006         MOVE FH-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                
ACT006         MOVE FH-IC-NO             TO WS-DB2-KEY-3N               
ACT006         MOVE FH-FIXED-FCTR-SEQ-NO TO WS-DB2-KEY-4N               
ACT006         MOVE 12 TO RETURN-CODE                                   
ACT006         PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                
ACT006      END-IF                                                      
ACT006     END-IF.                                                      
ACT006 8733-EXIT.                                                       
ACT006     EXIT.                                                        
      /                                                                         
C34569 8750-UPDATE-FIXED-FCTR.                                          
C34569                                                                  
C34569     IF FF-EFF-DATE-TO = LOW-VALUES OR SPACES                     
C34569        MOVE -1 TO WS-NULL-IND-24                                 
C34569     ELSE                                                         
C34569        MOVE ZERO TO WS-NULL-IND-24                               
C34569     END-IF                                                       
C34569                                                                  
C34569     IF FF-DURATION-REMAIN-NO = -1                                
C34569        MOVE -1 TO WS-NULL-IND-25                                 
C34569     ELSE                                                         
C34569        MOVE ZERO TO WS-NULL-IND-25                               
C34569     END-IF.                                                      
C34569                                                                  
C34569     EXEC SQL                                                     
C34569        UPDATE CSS_FIXED_FCTR                                     
C34569           SET   EFF_DATE_FROM          = IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )       
C34569                ,FACTOR                 = :FF-FACTOR              
C34569                ,EFF_DATE_TO            = IIF(TRY_CONVERT(DATE, 
                                                       :FF-EFF-DATE-TO 
                                                        :WS-NULL-IND-24
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO 
                                                        :WS-NULL-IND-24
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO :WS-NULL-IND-24
              ) <> 10), CIS.CHAR2DATE(:FF-EFF-DATE-TO :WS-NULL-IND-24
              ), CONVERT(DATE, :FF-EFF-DATE-TO :WS-NULL-IND-24) )         
C34569                ,FIXED_FCTR_TYP_CD      = :FF-FIXED-FCTR-TYP-CD   
C34569                ,CMPNT_ID_CD            = :FF-CMPNT-ID-CD         
C34569                ,CODE_SEASON            = :FF-CODE-SEASON         
C34569                ,INSTR_USE_TYPE_CD      = :FF-INSTR-USE-TYPE-CD   
C34569                ,CODE_TIME_PERIOD       = :FF-CODE-TIME-PERIOD    
C34569                ,DURATION_REMAIN_NO     = :FF-DURATION-REMAIN-NO 
                                                :WS-NULL-IND-25         
C34569                ,FACTOR_ID              = :FF-FACTOR-ID           
C34569                ,RT_PKG_OPT_SEQ_NO      = :FF-RT-PKG-OPT-SEQ-NO   
P00165                ,BLOCK_NO               = :FF-BLOCK-NO            
C34569           WHERE  ACCOUNT_NO            = :FF-ACCOUNT-NO          
C34569             AND  CODE_UTIL_TYPE        = :FF-CODE-UTIL-TYPE      
C34569             AND  IC_NO                 = :FF-IC-NO               
C34569             AND  FIXED_FCTR_SEQ_NO     = :FF-FIXED-FCTR-SEQ-NO   
C34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIXED_FCTR                                             
MFA-TR*          SET   EFF_DATE_FROM          = :FF-EFF-DATE-FROM               
MFA-TR*               ,FACTOR                 = :FF-FACTOR                      
MFA-TR*               ,EFF_DATE_TO            = :FF-EFF-DATE-TO                 
MFA-TR*                                         :WS-NULL-IND-24                 
MFA-TR*               ,FIXED_FCTR_TYP_CD      = :FF-FIXED-FCTR-TYP-CD           
MFA-TR*               ,CMPNT_ID_CD            = :FF-CMPNT-ID-CD                 
MFA-TR*               ,CODE_SEASON            = :FF-CODE-SEASON                 
MFA-TR*               ,INSTR_USE_TYPE_CD      = :FF-INSTR-USE-TYPE-CD           
MFA-TR*               ,CODE_TIME_PERIOD       = :FF-CODE-TIME-PERIOD            
MFA-TR*               ,DURATION_REMAIN_NO     = :FF-DURATION-REMAIN-NO          
MFA-TR*                                         :WS-NULL-IND-25                 
MFA-TR*               ,FACTOR_ID              = :FF-FACTOR-ID                   
MFA-TR*               ,RT_PKG_OPT_SEQ_NO      = :FF-RT-PKG-OPT-SEQ-NO           
MFA-TR*               ,BLOCK_NO               = :FF-BLOCK-NO                    
MFA-TR*          WHERE  ACCOUNT_NO            = :FF-ACCOUNT-NO                  
MFA-TR*            AND  CODE_UTIL_TYPE        = :FF-CODE-UTIL-TYPE              
MFA-TR*            AND  IC_NO                 = :FF-IC-NO                       
MFA-TR*            AND  FIXED_FCTR_SEQ_NO     = :FF-FIXED-FCTR-SEQ-NO           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569                                                                  
C34569     IF SQLCODE = NOT-FOUND                                       
C34569        CONTINUE                                                  
C34569     ELSE                                                         
C34569        IF SQLCODE NOT = SUCCESSFUL-CALL                          
C34569           MOVE 'FF'                 TO WS-DB2-TABLE-ID           
C34569           MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
C34569           MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
C34569           MOVE '114'                TO WS-DB2-MODULE-ID          
C34569           MOVE '8750'               TO WS-DB2-PARAGRAPH          
C34569           MOVE FF-ACCOUNT-NO        TO WS-DB2-KEY-1N             
C34569           MOVE FF-CODE-UTIL-TYPE    TO WS-DB2-KEY-2N             
C34569           MOVE FF-IC-NO             TO WS-DB2-KEY-3              
C34569           MOVE FF-FACTOR-ID         TO WS-DB2-KEY-4N             
C34569           MOVE 12 TO RETURN-CODE                                 
C34569           PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
C34569        END-IF                                                    
C34569     END-IF.                                                      
C34569 8750-EXIT.                                                       
C34569     EXIT.                                                        
C34569                                                                  
C34569 8755-INSERT-FIXED-FCTR.                                          
C34569                                                                  
C34569     IF FF-EFF-DATE-TO = LOW-VALUES OR SPACES                     
C34569        MOVE -1 TO WS-NULL-IND-24                                 
C34569     ELSE                                                         
C34569        MOVE ZERO TO WS-NULL-IND-24                               
C34569     END-IF                                                       
C34569                                                                  
C34569     IF FF-DURATION-REMAIN-NO = -1                                
C34569        MOVE -1 TO WS-NULL-IND-25                                 
C34569     ELSE                                                         
C34569        MOVE ZERO TO WS-NULL-IND-25                               
C34569     END-IF.                                                      
C34569                                                                  
C34569     EXEC SQL                                                     
C34569          INSERT INTO CSS_FIXED_FCTR                              
C34569           (ACCOUNT_NO                                            
C34569           ,CODE_UTIL_TYPE                                        
C34569           ,IC_NO                                                 
C34569           ,FIXED_FCTR_SEQ_NO                                     
C34569           ,FACTOR_ID                                             
C34569           ,EFF_DATE_FROM                                         
C34569           ,CMPNT_ID_CD                                           
C34569           ,CODE_SEASON                                           
C34569           ,INSTR_USE_TYPE_CD                                     
C34569           ,CODE_TIME_PERIOD                                      
C34569           ,EFF_DATE_TO                                           
C34569           ,FIXED_FCTR_TYP_CD                                     
C34569           ,FACTOR                                                
C34569           ,FAC_CHRG_BASE_AM                                      
C34569           ,LAST_UPDATE_TS                                        
C34569           ,DURATION_REMAIN_NO                                    
C34569           ,RT_PKG_OPT_SEQ_NO                                     
P00165           ,BLOCK_NO)                                             
C34569          VALUES                                                  
C34569           (:FF-ACCOUNT-NO,                                       
C34569            :FF-CODE-UTIL-TYPE,                                   
C34569            :FF-IC-NO,                                            
C34569            :FF-FIXED-FCTR-SEQ-NO,                                
C34569            :FF-FACTOR-ID,                                        
C34569            IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) ),                           
C34569            :FF-CMPNT-ID-CD,                                      
C34569            :FF-CODE-SEASON,                                      
C34569            :FF-INSTR-USE-TYPE-CD,                                
C34569            :FF-CODE-TIME-PERIOD,                                 
C34569            IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO :WS-NULL-IND-24
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO 
                                                        :WS-NULL-IND-24
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO :WS-NULL-IND-24
              ) <> 10), CIS.CHAR2DATE(:FF-EFF-DATE-TO :WS-NULL-IND-24
              ), CONVERT(DATE, :FF-EFF-DATE-TO :WS-NULL-IND-24) ),             
C34569            :FF-FIXED-FCTR-TYP-CD,                                
C34569            :FF-FACTOR,                                           
C34569            :FF-FAC-CHRG-BASE-AM,                                 
C34569            CIS.CHAR2TIMESTAMP(:FF-LAST-UPDATE-TS),                       
C34569            :FF-DURATION-REMAIN-NO :WS-NULL-IND-25,               
C34569            :FF-RT-PKG-OPT-SEQ-NO,                                
P00165            :FF-BLOCK-NO)                                         
C34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_FIXED_FCTR                                      
MFA-TR*          (ACCOUNT_NO                                                    
MFA-TR*          ,CODE_UTIL_TYPE                                                
MFA-TR*          ,IC_NO                                                         
MFA-TR*          ,FIXED_FCTR_SEQ_NO                                             
MFA-TR*          ,FACTOR_ID                                                     
MFA-TR*          ,EFF_DATE_FROM                                                 
MFA-TR*          ,CMPNT_ID_CD                                                   
MFA-TR*          ,CODE_SEASON                                                   
MFA-TR*          ,INSTR_USE_TYPE_CD                                             
MFA-TR*          ,CODE_TIME_PERIOD                                              
MFA-TR*          ,EFF_DATE_TO                                                   
MFA-TR*          ,FIXED_FCTR_TYP_CD                                             
MFA-TR*          ,FACTOR                                                        
MFA-TR*          ,FAC_CHRG_BASE_AM                                              
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,DURATION_REMAIN_NO                                            
MFA-TR*          ,RT_PKG_OPT_SEQ_NO                                             
MFA-TR*          ,BLOCK_NO)                                                     
MFA-TR*         VALUES                                                          
MFA-TR*          (:FF-ACCOUNT-NO,                                               
MFA-TR*           :FF-CODE-UTIL-TYPE,                                           
MFA-TR*           :FF-IC-NO,                                                    
MFA-TR*           :FF-FIXED-FCTR-SEQ-NO,                                        
MFA-TR*           :FF-FACTOR-ID,                                                
MFA-TR*           :FF-EFF-DATE-FROM,                                            
MFA-TR*           :FF-CMPNT-ID-CD,                                              
MFA-TR*           :FF-CODE-SEASON,                                              
MFA-TR*           :FF-INSTR-USE-TYPE-CD,                                        
MFA-TR*           :FF-CODE-TIME-PERIOD,                                         
MFA-TR*           :FF-EFF-DATE-TO :WS-NULL-IND-24,                              
MFA-TR*           :FF-FIXED-FCTR-TYP-CD,                                        
MFA-TR*           :FF-FACTOR,                                                   
MFA-TR*           :FF-FAC-CHRG-BASE-AM,                                         
MFA-TR*           :FF-LAST-UPDATE-TS,                                           
MFA-TR*           :FF-DURATION-REMAIN-NO :WS-NULL-IND-25,                       
MFA-TR*           :FF-RT-PKG-OPT-SEQ-NO,                                        
MFA-TR*           :FF-BLOCK-NO)                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569                                                                  
C34569     EVALUATE SQLCODE                                             
C34569        WHEN SUCCESSFUL-CALL                                      
C34569        WHEN ALREADY-EXISTS                                       
C34569             CONTINUE                                             
C34569        WHEN OTHER                                                
C34569            MOVE 'FF'                 TO WS-DB2-TABLE-ID          
C34569            MOVE 'INSERT'             TO WS-DB2-FUNCTION          
C34569            MOVE SQLCODE              TO WS-DB2-RETURN-CODE       
C34569            MOVE '114'                TO WS-DB2-MODULE-ID         
C34569            MOVE '8755'               TO WS-DB2-PARAGRAPH         
C34569            MOVE FF-ACCOUNT-NO        TO WS-DB2-KEY-1N            
C34569            MOVE FF-CODE-UTIL-TYPE    TO WS-DB2-KEY-2N            
C34569            MOVE FH-IC-NO             TO WS-DB2-KEY-3             
C34569            MOVE FF-FACTOR-ID         TO WS-DB2-KEY-4N            
C34569            MOVE 12 TO RETURN-CODE                                
C34569            PERFORM 9900-SQL-ERROR     THRU 9900-EXIT             
C34569     END-EVALUATE.                                                
C34569 8755-EXIT.                                                       
C34569     EXIT.                                                        
      /                                                                         
       8760-UPDATE-BILL-CNTR-HIST.                                      
           EXEC SQL                                                     
              UPDATE CSS_BILL_CNTR_HIST                                 
                 SET CNTRCT_START_DT      = IIF(TRY_CONVERT(DATE, 
                                                    :BX-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :BX-CNTRCT-START-DT
              ) <> 0) OR (LEN(:BX-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:BX-CNTRCT-START-DT
              ), CONVERT(DATE, :BX-CNTRCT-START-DT) ),        
                     CNTRCT_END_DT        = IIF(TRY_CONVERT(DATE, 
                                                      :BX-CNTRCT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :BX-CNTRCT-END-DT
              ) <> 0) OR (LEN(:BX-CNTRCT-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :BX-CNTRCT-END-DT
              ), CONVERT(DATE, :BX-CNTRCT-END-DT) ),          
                     SPCL_MO_MIN_AM       = :BX-SPCL-MO-MIN-AM,         
                     SPCL_ANN_MIN_AM      = :BX-SPCL-ANN-MIN-AM,        
                     ANN_MIN_TYPE_CD      = :BX-ANN-MIN-TYPE-CD,        
                     CBL_REF_RATE_PLN     = :BX-CBL-REF-RATE-PLN,       
                     COMP_RATE_PLAN       = :BX-COMP-RATE-PLAN,         
                     COMPARE_TYPE_CD      = :BX-COMPARE-TYPE-CD,        
                     DEM_CNSLDTN_CD       = :BX-DEM-CNSLDTN-CD,         
                     DFLT_USAGE_CLS_CD    = :BX-DFLT-USAGE-CLS-CD,      
                     STDBY_LIMIT_HRS      = :BX-STDBY-LIMIT-HRS,        
                     STDBY_LIMIT_PK_HRS   = :BX-STDBY-LIMIT-PK-HRS,     
                     STDBY_YTD_PK_HRS     = :BX-STDBY-YTD-PK-HRS,       
                     STDBY_YTD_HRS        = :BX-STDBY-YTD-HRS,          
                     STDBY_RESET_MTH      = :BX-STDBY-RESET-MTH,        
                     MAX_ECON_DEM         = :BX-MAX-ECON-DEM,           
                     CONTRACT_ECON_DEM    = :BX-CONTRACT-ECON-DEM,      
                     CANCEL_CHRG_AM       = :BX-CANCEL-CHRG-AM,         
                     FIRM_PER_HR_KWH      = :BX-FIRM-PER-HR-KWH,        
                     CONTRACT_STDBY_DEM   = :BX-CONTRACT-STDBY-DEM,     
                     CONTRACT_DEMAND      = :BX-CONTRACT-DEMAND,        
                     BUILD_UP_MONTHS      = :BX-BUILD-UP-MONTHS,        
T23631               ALTN_FUEL_SPLY_CD    = :BX-ALTN-FUEL-SPLY-CD,      
T23631               FUEL_SHIPPER_CD      = :BX-FUEL-SHIPPER-CD,        
T23631               ALT_SPLY_RATE_NO     = :BX-ALT-SPLY-RATE-NO,       
T23631               ALT_SPLY_REV_CL_CD   = :BX-ALT-SPLY-REV-CL-CD,     
T23631               ALTERNATE_FUEL_CD    = :BX-ALTERNATE-FUEL-CD,      
T25762               VERS_PRORATE_CD      = :BX-VERS-PRORATE-CD,        
CIG                  ANN_REVIEW_MONTH     = :BX-ANN-REVIEW-MONTH,       
CIG                  CONTRACT_TERM_CD     = :BX-CONTRACT-TERM-CD        
                 WHERE ACCOUNT_NO         = :BX-ACCOUNT-NO              
                   AND BILL_NO            = :BX-BILL-NO                 
                   AND CODE_UTIL_TYPE     = :BX-CODE-UTIL-TYPE          
                   AND IC_NO              = :BX-IC-NO                   
                   AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BX-BILL-ITEM-TIMESTMP
              )      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BILL_CNTR_HIST                                         
MFA-TR*          SET CNTRCT_START_DT      = :BX-CNTRCT-START-DT,                
MFA-TR*              CNTRCT_END_DT        = :BX-CNTRCT-END-DT,                  
MFA-TR*              SPCL_MO_MIN_AM       = :BX-SPCL-MO-MIN-AM,                 
MFA-TR*              SPCL_ANN_MIN_AM      = :BX-SPCL-ANN-MIN-AM,                
MFA-TR*              ANN_MIN_TYPE_CD      = :BX-ANN-MIN-TYPE-CD,                
MFA-TR*              CBL_REF_RATE_PLN     = :BX-CBL-REF-RATE-PLN,               
MFA-TR*              COMP_RATE_PLAN       = :BX-COMP-RATE-PLAN,                 
MFA-TR*              COMPARE_TYPE_CD      = :BX-COMPARE-TYPE-CD,                
MFA-TR*              DEM_CNSLDTN_CD       = :BX-DEM-CNSLDTN-CD,                 
MFA-TR*              DFLT_USAGE_CLS_CD    = :BX-DFLT-USAGE-CLS-CD,              
MFA-TR*              STDBY_LIMIT_HRS      = :BX-STDBY-LIMIT-HRS,                
MFA-TR*              STDBY_LIMIT_PK_HRS   = :BX-STDBY-LIMIT-PK-HRS,             
MFA-TR*              STDBY_YTD_PK_HRS     = :BX-STDBY-YTD-PK-HRS,               
MFA-TR*              STDBY_YTD_HRS        = :BX-STDBY-YTD-HRS,                  
MFA-TR*              STDBY_RESET_MTH      = :BX-STDBY-RESET-MTH,                
MFA-TR*              MAX_ECON_DEM         = :BX-MAX-ECON-DEM,                   
MFA-TR*              CONTRACT_ECON_DEM    = :BX-CONTRACT-ECON-DEM,              
MFA-TR*              CANCEL_CHRG_AM       = :BX-CANCEL-CHRG-AM,                 
MFA-TR*              FIRM_PER_HR_KWH      = :BX-FIRM-PER-HR-KWH,                
MFA-TR*              CONTRACT_STDBY_DEM   = :BX-CONTRACT-STDBY-DEM,             
MFA-TR*              CONTRACT_DEMAND      = :BX-CONTRACT-DEMAND,                
MFA-TR*              BUILD_UP_MONTHS      = :BX-BUILD-UP-MONTHS,                
MFA-TR*              ALTN_FUEL_SPLY_CD    = :BX-ALTN-FUEL-SPLY-CD,              
MFA-TR*              FUEL_SHIPPER_CD      = :BX-FUEL-SHIPPER-CD,                
MFA-TR*              ALT_SPLY_RATE_NO     = :BX-ALT-SPLY-RATE-NO,               
MFA-TR*              ALT_SPLY_REV_CL_CD   = :BX-ALT-SPLY-REV-CL-CD,             
MFA-TR*              ALTERNATE_FUEL_CD    = :BX-ALTERNATE-FUEL-CD,              
MFA-TR*              VERS_PRORATE_CD      = :BX-VERS-PRORATE-CD,                
MFA-TR*              ANN_REVIEW_MONTH     = :BX-ANN-REVIEW-MONTH,               
MFA-TR*              CONTRACT_TERM_CD     = :BX-CONTRACT-TERM-CD                
MFA-TR*          WHERE ACCOUNT_NO         = :BX-ACCOUNT-NO                      
MFA-TR*            AND BILL_NO            = :BX-BILL-NO                         
MFA-TR*            AND CODE_UTIL_TYPE     = :BX-CODE-UTIL-TYPE                  
MFA-TR*            AND IC_NO              = :BX-IC-NO                           
MFA-TR*            AND BILL_ITEM_TIMESTMP = :BX-BILL-ITEM-TIMESTMP              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'BX'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8760'               TO WS-DB2-PARAGRAPH             
              MOVE BX-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BX-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE BX-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE BX-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8760-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8770-INSERT-BILL-CNTR-HIST.                                      
           EXEC SQL                                                     
                INSERT INTO CSS_BILL_CNTR_HIST                          
                (ACCOUNT_NO,                                            
                 BILL_NO,                                               
                 CODE_UTIL_TYPE,                                        
                 IC_NO,                                                 
                 BILL_ITEM_TIMESTMP,                                    
                 CNTRCT_START_DT,                                       
                 CNTRCT_END_DT,                                         
                 SPCL_MO_MIN_AM,                                        
                 SPCL_ANN_MIN_AM,                                       
                 ANN_MIN_TYPE_CD,                                       
                 CBL_REF_RATE_PLN,                                      
                 COMP_RATE_PLAN,                                        
                 COMPARE_TYPE_CD,                                       
                 DEM_CNSLDTN_CD,                                        
                 DFLT_USAGE_CLS_CD,                                     
                 STDBY_LIMIT_HRS,                                       
                 STDBY_LIMIT_PK_HRS,                                    
                 STDBY_YTD_PK_HRS,                                      
                 STDBY_YTD_HRS,                                         
                 STDBY_RESET_MTH,                                       
                 MAX_ECON_DEM,                                          
                 CONTRACT_ECON_DEM,                                     
                 CANCEL_CHRG_AM,                                        
                 FIRM_PER_HR_KWH,                                       
                 CONTRACT_STDBY_DEM,                                    
                 CONTRACT_DEMAND,                                       
                 BUILD_UP_MONTHS,                                       
T23631           ALTN_FUEL_SPLY_CD,                                     
T23631           FUEL_SHIPPER_CD,                                       
T23631           ALT_SPLY_RATE_NO,                                      
T23631           ALT_SPLY_REV_CL_CD,                                    
T23631           ALTERNATE_FUEL_CD,                                     
T25762           VERS_PRORATE_CD,                                       
CIG              ANN_REVIEW_MONTH,                                      
CIG              CONTRACT_TERM_CD)                                      
             VALUES                                                     
                (:BX-ACCOUNT-NO,                                        
                 :BX-BILL-NO,                                           
                 :BX-CODE-UTIL-TYPE,                                    
                 :BX-IC-NO,                                             
                 CIS.CHAR2TIMESTAMP(:BX-BILL-ITEM-TIMESTMP),                    
                 IIF(TRY_CONVERT(DATE, :BX-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :BX-CNTRCT-START-DT
              ) <> 0) OR (LEN(:BX-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:BX-CNTRCT-START-DT
              ), CONVERT(DATE, :BX-CNTRCT-START-DT) ),                         
                 IIF(TRY_CONVERT(DATE, :BX-CNTRCT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :BX-CNTRCT-END-DT
              ) <> 0) OR (LEN(:BX-CNTRCT-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :BX-CNTRCT-END-DT
              ), CONVERT(DATE, :BX-CNTRCT-END-DT) ),                           
                 :BX-SPCL-MO-MIN-AM,                                    
                 :BX-SPCL-ANN-MIN-AM,                                   
                 :BX-ANN-MIN-TYPE-CD,                                   
                 :BX-CBL-REF-RATE-PLN,                                  
                 :BX-COMP-RATE-PLAN,                                    
                 :BX-COMPARE-TYPE-CD,                                   
                 :BX-DEM-CNSLDTN-CD,                                    
                 :BX-DFLT-USAGE-CLS-CD,                                 
                 :BX-STDBY-LIMIT-HRS,                                   
                 :BX-STDBY-LIMIT-PK-HRS,                                
                 :BX-STDBY-YTD-PK-HRS,                                  
                 :BX-STDBY-YTD-HRS,                                     
                 :BX-STDBY-RESET-MTH,                                   
                 :BX-MAX-ECON-DEM,                                      
                 :BX-CONTRACT-ECON-DEM,                                 
                 :BX-CANCEL-CHRG-AM,                                    
                 :BX-FIRM-PER-HR-KWH,                                   
                 :BX-CONTRACT-STDBY-DEM,                                
                 :BX-CONTRACT-DEMAND,                                   
                 :BX-BUILD-UP-MONTHS,                                   
T23631           :BX-ALTN-FUEL-SPLY-CD,                                 
T23631           :BX-FUEL-SHIPPER-CD,                                   
T23631           :BX-ALT-SPLY-RATE-NO,                                  
T23631           :BX-ALT-SPLY-REV-CL-CD,                                
T23631           :BX-ALTERNATE-FUEL-CD,                                 
T25762           :BX-VERS-PRORATE-CD,                                   
CIG              :BX-ANN-REVIEW-MONTH,                                  
CIG              :BX-CONTRACT-TERM-CD)                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_BILL_CNTR_HIST                                  
MFA-TR*         (ACCOUNT_NO,                                                    
MFA-TR*          BILL_NO,                                                       
MFA-TR*          CODE_UTIL_TYPE,                                                
MFA-TR*          IC_NO,                                                         
MFA-TR*          BILL_ITEM_TIMESTMP,                                            
MFA-TR*          CNTRCT_START_DT,                                               
MFA-TR*          CNTRCT_END_DT,                                                 
MFA-TR*          SPCL_MO_MIN_AM,                                                
MFA-TR*          SPCL_ANN_MIN_AM,                                               
MFA-TR*          ANN_MIN_TYPE_CD,                                               
MFA-TR*          CBL_REF_RATE_PLN,                                              
MFA-TR*          COMP_RATE_PLAN,                                                
MFA-TR*          COMPARE_TYPE_CD,                                               
MFA-TR*          DEM_CNSLDTN_CD,                                                
MFA-TR*          DFLT_USAGE_CLS_CD,                                             
MFA-TR*          STDBY_LIMIT_HRS,                                               
MFA-TR*          STDBY_LIMIT_PK_HRS,                                            
MFA-TR*          STDBY_YTD_PK_HRS,                                              
MFA-TR*          STDBY_YTD_HRS,                                                 
MFA-TR*          STDBY_RESET_MTH,                                               
MFA-TR*          MAX_ECON_DEM,                                                  
MFA-TR*          CONTRACT_ECON_DEM,                                             
MFA-TR*          CANCEL_CHRG_AM,                                                
MFA-TR*          FIRM_PER_HR_KWH,                                               
MFA-TR*          CONTRACT_STDBY_DEM,                                            
MFA-TR*          CONTRACT_DEMAND,                                               
MFA-TR*          BUILD_UP_MONTHS,                                               
MFA-TR*          ALTN_FUEL_SPLY_CD,                                             
MFA-TR*          FUEL_SHIPPER_CD,                                               
MFA-TR*          ALT_SPLY_RATE_NO,                                              
MFA-TR*          ALT_SPLY_REV_CL_CD,                                            
MFA-TR*          ALTERNATE_FUEL_CD,                                             
MFA-TR*          VERS_PRORATE_CD,                                               
MFA-TR*          ANN_REVIEW_MONTH,                                              
MFA-TR*          CONTRACT_TERM_CD)                                              
MFA-TR*      VALUES                                                             
MFA-TR*         (:BX-ACCOUNT-NO,                                                
MFA-TR*          :BX-BILL-NO,                                                   
MFA-TR*          :BX-CODE-UTIL-TYPE,                                            
MFA-TR*          :BX-IC-NO,                                                     
MFA-TR*          :BX-BILL-ITEM-TIMESTMP,                                        
MFA-TR*          :BX-CNTRCT-START-DT,                                           
MFA-TR*          :BX-CNTRCT-END-DT,                                             
MFA-TR*          :BX-SPCL-MO-MIN-AM,                                            
MFA-TR*          :BX-SPCL-ANN-MIN-AM,                                           
MFA-TR*          :BX-ANN-MIN-TYPE-CD,                                           
MFA-TR*          :BX-CBL-REF-RATE-PLN,                                          
MFA-TR*          :BX-COMP-RATE-PLAN,                                            
MFA-TR*          :BX-COMPARE-TYPE-CD,                                           
MFA-TR*          :BX-DEM-CNSLDTN-CD,                                            
MFA-TR*          :BX-DFLT-USAGE-CLS-CD,                                         
MFA-TR*          :BX-STDBY-LIMIT-HRS,                                           
MFA-TR*          :BX-STDBY-LIMIT-PK-HRS,                                        
MFA-TR*          :BX-STDBY-YTD-PK-HRS,                                          
MFA-TR*          :BX-STDBY-YTD-HRS,                                             
MFA-TR*          :BX-STDBY-RESET-MTH,                                           
MFA-TR*          :BX-MAX-ECON-DEM,                                              
MFA-TR*          :BX-CONTRACT-ECON-DEM,                                         
MFA-TR*          :BX-CANCEL-CHRG-AM,                                            
MFA-TR*          :BX-FIRM-PER-HR-KWH,                                           
MFA-TR*          :BX-CONTRACT-STDBY-DEM,                                        
MFA-TR*          :BX-CONTRACT-DEMAND,                                           
MFA-TR*          :BX-BUILD-UP-MONTHS,                                           
MFA-TR*          :BX-ALTN-FUEL-SPLY-CD,                                         
MFA-TR*          :BX-FUEL-SHIPPER-CD,                                           
MFA-TR*          :BX-ALT-SPLY-RATE-NO,                                          
MFA-TR*          :BX-ALT-SPLY-REV-CL-CD,                                        
MFA-TR*          :BX-ALTERNATE-FUEL-CD,                                         
MFA-TR*          :BX-VERS-PRORATE-CD,                                           
MFA-TR*          :BX-ANN-REVIEW-MONTH,                                          
MFA-TR*          :BX-CONTRACT-TERM-CD)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'BX'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSSRT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8760'               TO WS-DB2-PARAGRAPH             
              MOVE BX-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BX-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE BX-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE BX-IC-NO             TO WS-DB2-KEY-4N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8770-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************CIG CHANGES *****************                            
       8771-PROCESS-VOL-BLOCK-TB.                                       
                                                                        
                                                                        
           EXEC SQL                                                     
              SELECT PRIMARY_IC_NO,                                     
                     VOL_BLOCK_SEQ,                                     
                     VOL_BLOCK_FACTOR                                   
                INTO :UB-PRIMARY-IC-NO,                                 
                     :UB-VOL-BLOCK-SEQ,                                 
                     :UB-VOL-BLOCK-FACTOR                               
               FROM CSS_VOL_BLOCK WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :UB-ACCOUNT-NO                        
                 AND CODE_UTIL_TYPE  = :UB-CODE-UTIL-TYPE               
                 AND IC_NO           = :UB-IC-NO                        
                 AND CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                    :UB-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UB-CNTRCT-START-DT
              ) <> 0) OR (LEN(:UB-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:UB-CNTRCT-START-DT
              ), CONVERT(DATE, :UB-CNTRCT-START-DT) )              
T33182                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PRIMARY_IC_NO,                                             
MFA-TR*              VOL_BLOCK_SEQ,                                             
MFA-TR*              VOL_BLOCK_FACTOR                                           
MFA-TR*         INTO :UB-PRIMARY-IC-NO,                                         
MFA-TR*              :UB-VOL-BLOCK-SEQ,                                         
MFA-TR*              :UB-VOL-BLOCK-FACTOR                                       
MFA-TR*        FROM CSS_VOL_BLOCK                                               
MFA-TR*        WHERE ACCOUNT_NO = :UB-ACCOUNT-NO                                
MFA-TR*          AND CODE_UTIL_TYPE  = :UB-CODE-UTIL-TYPE                       
MFA-TR*          AND IC_NO           = :UB-IC-NO                                
MFA-TR*          AND CNTRCT_START_DT = :UB-CNTRCT-START-DT                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'UB'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8771'               TO WS-DB2-PARAGRAPH             
              MOVE UB-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UB-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
              MOVE UB-IC-NO             TO WS-DB2-KEY-3N                
              MOVE UB-CNTRCT-START-DT   TO WS-DB2-KEY-2                 
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       8771-EXIT.                                                       
           EXIT.                                                        
       8772-INSERT-VOL-BLOCK-HST.                                       
                                                                        
                                                                        
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_VOL_BLOCK_HIST                             
               (ACCOUNT_NO                                              
               ,BILL_NO                                                 
               ,CODE_UTIL_TYPE                                          
               ,IC_NO                                                   
               ,BILL_ITEM_TIMESTMP                                      
               ,CNTRCT_START_DT                                         
               ,PRIMARY_IC_NO                                           
               ,VOL_BLOCK_SEQ                                           
               ,VOL_BLOCK_FACTOR)                                       
             VALUES                                                     
              (:HV-ACCOUNT-NO                                           
              ,:HV-BILL-NO                                              
              ,:HV-CODE-UTIL-TYPE                                       
              ,:HV-IC-NO                                                
              ,CIS.CHAR2TIMESTAMP(:HV-BILL-ITEM-TIMESTMP)                       
              ,IIF(TRY_CONVERT(DATE, :HV-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :HV-CNTRCT-START-DT
              ) <> 0) OR (LEN(:HV-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:HV-CNTRCT-START-DT
              ), CONVERT(DATE, :HV-CNTRCT-START-DT) )                          
              ,:HV-PRIMARY-IC-NO                                        
              ,:HV-VOL-BLOCK-SEQ                                        
              ,:HV-VOL-BLOCK-FACTOR)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_VOL_BLOCK_HIST                                     
MFA-TR*        (ACCOUNT_NO                                                      
MFA-TR*        ,BILL_NO                                                         
MFA-TR*        ,CODE_UTIL_TYPE                                                  
MFA-TR*        ,IC_NO                                                           
MFA-TR*        ,BILL_ITEM_TIMESTMP                                              
MFA-TR*        ,CNTRCT_START_DT                                                 
MFA-TR*        ,PRIMARY_IC_NO                                                   
MFA-TR*        ,VOL_BLOCK_SEQ                                                   
MFA-TR*        ,VOL_BLOCK_FACTOR)                                               
MFA-TR*      VALUES                                                             
MFA-TR*       (:HV-ACCOUNT-NO                                                   
MFA-TR*       ,:HV-BILL-NO                                                      
MFA-TR*       ,:HV-CODE-UTIL-TYPE                                               
MFA-TR*       ,:HV-IC-NO                                                        
MFA-TR*       ,:HV-BILL-ITEM-TIMESTMP                                           
MFA-TR*       ,:HV-CNTRCT-START-DT                                              
MFA-TR*       ,:HV-PRIMARY-IC-NO                                                
MFA-TR*       ,:HV-VOL-BLOCK-SEQ                                                
MFA-TR*       ,:HV-VOL-BLOCK-FACTOR)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'HV'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8772'               TO WS-DB2-PARAGRAPH             
              MOVE HV-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE HV-IC-NO             TO WS-DB2-KEY-2N                
              MOVE HV-BILL-NO             TO WS-DB2-KEY-4N              
              MOVE HV-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE 12                   TO RETURN-CODE                  
              PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
           END-IF.                                                      
       8772-EXIT.                                                       
           EXIT.                                                        
       8773-UPDATE-VOL-BLOCK-HST.                                       
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_VOL_BLOCK_HIST                                  
               SET CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                    :HV-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :HV-CNTRCT-START-DT
              ) <> 0) OR (LEN(:HV-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:HV-CNTRCT-START-DT
              ), CONVERT(DATE, :HV-CNTRCT-START-DT) )                
                  ,PRIMARY_IC_NO   = :HV-PRIMARY-IC-NO                  
                  ,VOL_BLOCK_SEQ   = :HV-VOL-BLOCK-SEQ                  
                  ,VOL_BLOCK_FACTOR = :HV-VOL-BLOCK-FACTOR              
             WHERE ACCOUNT_NO         = :HV-ACCOUNT-NO                  
               AND BILL_NO            = :HV-BILL-NO                     
               AND CODE_UTIL_TYPE     = :HV-CODE-UTIL-TYPE              
               AND IC_NO              = :HV-IC-NO                       
      *        AND BILL_ITEM_TIMESTMP = :HV-BILL-ITEM-TIMESTMP                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_VOL_BLOCK_HIST                                          
MFA-TR*        SET CNTRCT_START_DT = :HV-CNTRCT-START-DT                        
MFA-TR*           ,PRIMARY_IC_NO   = :HV-PRIMARY-IC-NO                          
MFA-TR*           ,VOL_BLOCK_SEQ   = :HV-VOL-BLOCK-SEQ                          
MFA-TR*           ,VOL_BLOCK_FACTOR = :HV-VOL-BLOCK-FACTOR                      
MFA-TR*      WHERE ACCOUNT_NO         = :HV-ACCOUNT-NO                          
MFA-TR*        AND BILL_NO            = :HV-BILL-NO                             
MFA-TR*        AND CODE_UTIL_TYPE     = :HV-CODE-UTIL-TYPE                      
MFA-TR*        AND IC_NO              = :HV-IC-NO                               
MFA-TR*        AND BILL_ITEM_TIMESTMP = :HV-BILL-ITEM-TIMESTMP                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'HV'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8773'               TO WS-DB2-PARAGRAPH             
              MOVE HV-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE HV-IC-NO             TO WS-DB2-KEY-2N                
              MOVE HV-BILL-NO             TO WS-DB2-KEY-4N              
              MOVE HV-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE 12                   TO RETURN-CODE                  
              PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
           END-IF.                                                      
       8773-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       8774-PROCESS-TRNSP-CNTR-TB.                                      
                                                                        
                                                                        
           EXEC SQL                                                     
              SELECT TRNSP_SHRINK_PCT,                                  
                     TRNSP_MDQ,                                         
                     TRANSM_ACCT_NO,                                    
                     FUEL_SHIPPER_CD                                    
                INTO :TW-TRNSP-SHRINK-PCT                               
                    ,:TW-TRNSP-MDQ                                      
                    ,:TW-TRANSM-ACCT-NO                                 
                    ,:TW-FUEL-SHIPPER-CD                                
               FROM CSS_TRNSP_CONTRACT WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO      = :TW-ACCOUNT-NO                   
                 AND CODE_UTIL_TYPE  = :TW-CODE-UTIL-TYPE               
                 AND PRIMARY_IC_NO   = :TW-PRIMARY-IC-NO                
                 AND CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                    :TW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :TW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:TW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:TW-CNTRCT-START-DT
              ), CONVERT(DATE, :TW-CNTRCT-START-DT) )              
T33182                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TRNSP_SHRINK_PCT,                                          
MFA-TR*              TRNSP_MDQ,                                                 
MFA-TR*              TRANSM_ACCT_NO,                                            
MFA-TR*              FUEL_SHIPPER_CD                                            
MFA-TR*         INTO :TW-TRNSP-SHRINK-PCT                                       
MFA-TR*             ,:TW-TRNSP-MDQ                                              
MFA-TR*             ,:TW-TRANSM-ACCT-NO                                         
MFA-TR*             ,:TW-FUEL-SHIPPER-CD                                        
MFA-TR*        FROM CSS_TRNSP_CONTRACT                                          
MFA-TR*        WHERE ACCOUNT_NO      = :TW-ACCOUNT-NO                           
MFA-TR*          AND CODE_UTIL_TYPE  = :TW-CODE-UTIL-TYPE                       
MFA-TR*          AND PRIMARY_IC_NO   = :TW-PRIMARY-IC-NO                        
MFA-TR*          AND CNTRCT_START_DT = :TW-CNTRCT-START-DT                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'TW'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8774'               TO WS-DB2-PARAGRAPH             
              MOVE TW-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE TW-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
              MOVE TW-PRIMARY-IC-NO     TO WS-DB2-KEY-3N                
              MOVE TW-CNTRCT-START-DT   TO WS-DB2-KEY-2                 
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       8774-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8775-INSERT-TRNSP-CNTR-HST.                                      
                                                                        
                                                                        
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_TRNSP_CNTR_HST                             
               ( ACCOUNT_NO                                             
               , BILL_NO                                                
               , CODE_UTIL_TYPE                                         
               , PRIMARY_IC_NO                                          
               , BILL_ITEM_TIMESTMP                                     
               , CNTRCT_START_DT                                        
               , TRNSP_SHRINK_PCT                                       
               , TRNSP_MDQ                                              
               , TRANSM_ACCT_NO                                         
               , FUEL_SHIPPER_CD)                                       
             VALUES                                                     
              (:UW-ACCOUNT-NO                                           
              ,:UW-BILL-NO                                              
              ,:UW-CODE-UTIL-TYPE                                       
              ,:UW-PRIMARY-IC-NO                                        
              ,CIS.CHAR2TIMESTAMP(:UW-BILL-ITEM-TIMESTMP)                       
              ,IIF(TRY_CONVERT(DATE, :UW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:UW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:UW-CNTRCT-START-DT
              ), CONVERT(DATE, :UW-CNTRCT-START-DT) )                          
              ,:UW-TRNSP-SHRINK-PCT                                     
              ,:UW-TRNSP-MDQ                                            
              ,:UW-TRANSM-ACCT-NO                                       
              ,:UW-FUEL-SHIPPER-CD)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_TRNSP_CNTR_HST                                     
MFA-TR*        ( ACCOUNT_NO                                                     
MFA-TR*        , BILL_NO                                                        
MFA-TR*        , CODE_UTIL_TYPE                                                 
MFA-TR*        , PRIMARY_IC_NO                                                  
MFA-TR*        , BILL_ITEM_TIMESTMP                                             
MFA-TR*        , CNTRCT_START_DT                                                
MFA-TR*        , TRNSP_SHRINK_PCT                                               
MFA-TR*        , TRNSP_MDQ                                                      
MFA-TR*        , TRANSM_ACCT_NO                                                 
MFA-TR*        , FUEL_SHIPPER_CD)                                               
MFA-TR*      VALUES                                                             
MFA-TR*       (:UW-ACCOUNT-NO                                                   
MFA-TR*       ,:UW-BILL-NO                                                      
MFA-TR*       ,:UW-CODE-UTIL-TYPE                                               
MFA-TR*       ,:UW-PRIMARY-IC-NO                                                
MFA-TR*       ,:UW-BILL-ITEM-TIMESTMP                                           
MFA-TR*       ,:UW-CNTRCT-START-DT                                              
MFA-TR*       ,:UW-TRNSP-SHRINK-PCT                                             
MFA-TR*       ,:UW-TRNSP-MDQ                                                    
MFA-TR*       ,:UW-TRANSM-ACCT-NO                                               
MFA-TR*       ,:UW-FUEL-SHIPPER-CD)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'UW'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8775'               TO WS-DB2-PARAGRAPH             
              MOVE UW-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UW-PRIMARY-IC-NO     TO WS-DB2-KEY-2N                
              MOVE UW-BILL-NO           TO WS-DB2-KEY-4N                
              MOVE UW-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE 12                   TO RETURN-CODE                  
              PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
           END-IF.                                                      
       8775-EXIT.                                                       
           EXIT.                                                        
       8776-UPDATE-TRNSP-CNTR-HST.                                      
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_TRNSP_CNTR_HST                                  
               SET CNTRCT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :UW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:UW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:UW-CNTRCT-START-DT
              ), CONVERT(DATE, :UW-CNTRCT-START-DT) )             
                  ,TRNSP_SHRINK_PCT   = :UW-TRNSP-SHRINK-PCT            
                  ,TRNSP_MDQ          = :UW-TRNSP-MDQ                   
                  ,TRANSM_ACCT_NO     = :UW-TRANSM-ACCT-NO              
                  ,FUEL_SHIPPER_CD    = :UW-FUEL-SHIPPER-CD             
             WHERE ACCOUNT_NO         = :UW-ACCOUNT-NO                  
               AND BILL_NO            = :UW-BILL-NO                     
               AND CODE_UTIL_TYPE     = :UW-CODE-UTIL-TYPE              
               AND PRIMARY_IC_NO      = :UW-PRIMARY-IC-NO               
      *        AND BILL_ITEM_TIMESTMP = :UW-BILL-ITEM-TIMESTMP                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_TRNSP_CNTR_HST                                          
MFA-TR*        SET CNTRCT_START_DT    = :UW-CNTRCT-START-DT                     
MFA-TR*           ,TRNSP_SHRINK_PCT   = :UW-TRNSP-SHRINK-PCT                    
MFA-TR*           ,TRNSP_MDQ          = :UW-TRNSP-MDQ                           
MFA-TR*           ,TRANSM_ACCT_NO     = :UW-TRANSM-ACCT-NO                      
MFA-TR*           ,FUEL_SHIPPER_CD    = :UW-FUEL-SHIPPER-CD                     
MFA-TR*      WHERE ACCOUNT_NO         = :UW-ACCOUNT-NO                          
MFA-TR*        AND BILL_NO            = :UW-BILL-NO                             
MFA-TR*        AND CODE_UTIL_TYPE     = :UW-CODE-UTIL-TYPE                      
MFA-TR*        AND PRIMARY_IC_NO      = :UW-PRIMARY-IC-NO                       
MFA-TR*        AND BILL_ITEM_TIMESTMP = :UW-BILL-ITEM-TIMESTMP                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'HV'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8776'               TO WS-DB2-PARAGRAPH             
              MOVE UW-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UW-PRIMARY-IC-NO     TO WS-DB2-KEY-2N                
              MOVE UW-BILL-NO           TO WS-DB2-KEY-4N                
              MOVE UW-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE 12                   TO RETURN-CODE                  
              PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
           END-IF.                                                      
       8776-EXIT.                                                       
           EXIT.                                                        
       8777-OPEN-TRNSP-VOL-BLK.                                         
           EXEC SQL                                                     
                OPEN TRNSP_VOL_BLK                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'TZ'                 TO WS-DB2-TABLE-ID              
              MOVE 'OPEN  '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8777'               TO WS-DB2-PARAGRAPH             
              MOVE TZ-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE TZ-PRIMARY-IC-NO     TO WS-DB2-KEY-2N                
              MOVE TZ-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE TZ-CNTRCT-START-DT   TO WS-DB2-KEY-4                 
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8777-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8778-FETCH-TRNSP-VOL-BLK.                                        
           EXEC SQL                                                     
                FETCH TRNSP_VOL_BLK INTO                                
                  :TZ-TRNSP-SEQ,                                        
                  :TZ-IC-NO,                                            
                  :TZ-CODE-REVENUE-CLASS,                               
                  :TZ-RATE-PLAN-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'TZ'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8778'               TO WS-DB2-PARAGRAPH             
              MOVE TZ-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE TZ-PRIMARY-IC-NO     TO WS-DB2-KEY-2N                
              MOVE TZ-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE TZ-CNTRCT-START-DT   TO WS-DB2-KEY-4                 
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8778-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8782-CLOSE-TRNSP-VOL-BLK.                                        
           EXEC SQL                                                     
                CLOSE TRNSP_VOL_BLK                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'TZ'                 TO WS-DB2-TABLE-ID              
              MOVE 'CLOSE '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8782'               TO WS-DB2-PARAGRAPH             
              MOVE TZ-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE TZ-PRIMARY-IC-NO     TO WS-DB2-KEY-2N                
              MOVE TZ-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE TZ-CNTRCT-START-DT   TO WS-DB2-KEY-4                 
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8782-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8779-PROCESS-TRNSP-VOL-BLK.                                      
            MOVE TZ-ACCOUNT-NO          TO UZ-ACCOUNT-NO                
            MOVE BX-BILL-NO             TO UZ-BILL-NO                   
            MOVE TZ-CODE-UTIL-TYPE      TO UZ-CODE-UTIL-TYPE            
            MOVE BX-BILL-ITEM-TIMESTMP  TO UZ-BILL-ITEM-TIMESTMP        
            MOVE TZ-PRIMARY-IC-NO       TO UZ-PRIMARY-IC-NO             
            MOVE TZ-TRNSP-SEQ           TO UZ-TRNSP-SEQ                 
            MOVE TZ-IC-NO               TO UZ-IC-NO                     
            MOVE TZ-CODE-REVENUE-CLASS  TO UZ-CODE-REVENUE-CLASS        
            MOVE TZ-RATE-PLAN-NO        TO UZ-RATE-PLAN-NO              
            PERFORM 8781-UPDATE-TRNSP-VOL-HST THRU 8781-EXIT            
            IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               PERFORM 8780-INSERT-TRNSP-VOL-HST  THRU 8780-EXIT        
            END-IF                                                      
            PERFORM 8778-FETCH-TRNSP-VOL-BLK   THRU 8778-EXIT.          
       8779-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8780-INSERT-TRNSP-VOL-HST.                                       
                                                                        
                                                                        
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_TRNSP_VOL_HIST                             
               ( ACCOUNT_NO                                             
               , BILL_NO                                                
               , CODE_UTIL_TYPE                                         
               , BILL_ITEM_TIMESTMP                                     
               , PRIMARY_IC_NO                                          
               , TRNSP_SEQ                                              
               , IC_NO                                                  
               , CODE_REVENUE_CLASS                                     
               , RATE_PLAN_NO)                                          
             VALUES                                                     
              (:UZ-ACCOUNT-NO                                           
              ,:UZ-BILL-NO                                              
              ,:UZ-CODE-UTIL-TYPE                                       
              ,CIS.CHAR2TIMESTAMP(:UZ-BILL-ITEM-TIMESTMP)                       
              ,:UZ-PRIMARY-IC-NO                                        
              ,:UZ-TRNSP-SEQ                                            
              ,:UZ-IC-NO                                                
              ,:UZ-CODE-REVENUE-CLASS                                   
              ,:UZ-RATE-PLAN-NO)                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_TRNSP_VOL_HIST                                     
MFA-TR*        ( ACCOUNT_NO                                                     
MFA-TR*        , BILL_NO                                                        
MFA-TR*        , CODE_UTIL_TYPE                                                 
MFA-TR*        , BILL_ITEM_TIMESTMP                                             
MFA-TR*        , PRIMARY_IC_NO                                                  
MFA-TR*        , TRNSP_SEQ                                                      
MFA-TR*        , IC_NO                                                          
MFA-TR*        , CODE_REVENUE_CLASS                                             
MFA-TR*        , RATE_PLAN_NO)                                                  
MFA-TR*      VALUES                                                             
MFA-TR*       (:UZ-ACCOUNT-NO                                                   
MFA-TR*       ,:UZ-BILL-NO                                                      
MFA-TR*       ,:UZ-CODE-UTIL-TYPE                                               
MFA-TR*       ,:UZ-BILL-ITEM-TIMESTMP                                           
MFA-TR*       ,:UZ-PRIMARY-IC-NO                                                
MFA-TR*       ,:UZ-TRNSP-SEQ                                                    
MFA-TR*       ,:UZ-IC-NO                                                        
MFA-TR*       ,:UZ-CODE-REVENUE-CLASS                                           
MFA-TR*       ,:UZ-RATE-PLAN-NO)                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'UZ'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8780'               TO WS-DB2-PARAGRAPH             
              MOVE UZ-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UZ-PRIMARY-IC-NO     TO WS-DB2-KEY-2N                
              MOVE UZ-BILL-NO           TO WS-DB2-KEY-4N                
              MOVE UZ-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE 12                   TO RETURN-CODE                  
              PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
           END-IF.                                                      
       8780-EXIT.                                                       
           EXIT.                                                        
       8781-UPDATE-TRNSP-VOL-HST.                                       
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_TRNSP_VOL_HIST                                  
               SET IC_NO              = :UZ-IC-NO                       
                  ,RATE_PLAN_NO       = :UZ-RATE-PLAN-NO                
                  ,CODE_REVENUE_CLASS = :UZ-CODE-REVENUE-CLASS          
             WHERE ACCOUNT_NO         = :UZ-ACCOUNT-NO                  
               AND BILL_NO            = :UZ-BILL-NO                     
               AND CODE_UTIL_TYPE     = :UZ-CODE-UTIL-TYPE              
               AND PRIMARY_IC_NO      = :UZ-PRIMARY-IC-NO               
      *        AND BILL_ITEM_TIMESTMP = :UZ-BILL-ITEM-TIMESTMP                  
               AND TRNSP_SEQ          = :UZ-TRNSP-SEQ                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'HV'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8781'               TO WS-DB2-PARAGRAPH             
              MOVE UZ-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE UZ-PRIMARY-IC-NO     TO WS-DB2-KEY-2N                
              MOVE UZ-BILL-NO           TO WS-DB2-KEY-4N                
              MOVE UZ-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
              MOVE 12                   TO RETURN-CODE                  
              PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
           END-IF.                                                      
       8781-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
DC     8800-INSERT-ANNUAL-SUMMARY.                                      
DC         EXEC SQL                                                     
DC           INSERT INTO CSS_ANNUAL_SUMMARY                             
DC              (TOTAL_USAGE,                                           
DC              NO_DAYS,                                                
DC              CODE_UTIL_TYPE,                                         
DC              IC_NO,                                                  
DC              SUMMARY_YEAR,                                           
DC              TOTAL_REVENUE,                                          
DC              ACCOUNT_NO)                                             
DC           VALUES                                                     
DC              (:AS-TOTAL-USAGE,                                       
DC                :AS-NO-DAYS,                                          
DC                :AS-CODE-UTIL-TYPE,                                   
DC                :AS-IC-NO,                                            
DC                :AS-SUMMARY-YEAR,                                     
DC                :AS-TOTAL-REVENUE,                                    
DC                :AS-ACCOUNT-NO)                                       
DC         END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

DC                                                                      
DC         IF SQLCODE NOT = SUCCESSFUL-CALL                             
DC            MOVE 'AS'                 TO WS-DB2-TABLE-ID              
DC            MOVE 'INSERT'             TO WS-DB2-FUNCTION              
DC            MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
DC            MOVE '114'                TO WS-DB2-MODULE-ID             
DC            MOVE '8800'               TO WS-DB2-PARAGRAPH             
DC            MOVE AS-ACCOUNT-NO        TO WS-DB2-KEY-1N                
DC            MOVE AS-IC-NO             TO WS-DB2-KEY-2N                
DC            MOVE AS-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
DC            MOVE 12                   TO RETURN-CODE                  
DC            PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
DC         END-IF.                                                      
DC                                                                      
DC     8800-EXIT.                                                       
DC         EXIT.                                                        
DC                                                                      
DC     8810-UPDATE-ANNUAL-SUMMARY.                                      
DC         EXEC SQL                                                     
DC             UPDATE CSS_ANNUAL_SUMMARY                                
DC                SET   TOTAL_USAGE    = :AS-TOTAL-USAGE,               
DC                      NO_DAYS        = :AS-NO-DAYS,                   
DC                      TOTAL_REVENUE  = :AS-TOTAL-REVENUE              
DC                WHERE SUMMARY_YEAR   = :AS-SUMMARY-YEAR   AND         
DC                      ACCOUNT_NO     = :AS-ACCOUNT-NO     AND         
DC                      IC_NO          = :AS-IC-NO          AND         
DC                      CODE_UTIL_TYPE = :AS-CODE-UTIL-TYPE             
DC         END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

DC                                                                      
DC         MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
DC         IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
DC            MOVE 'AS'                 TO WS-DB2-TABLE-ID              
DC            MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
DC            MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
DC            MOVE '114'                TO WS-DB2-MODULE-ID             
DC            MOVE '8810'               TO WS-DB2-PARAGRAPH             
DC            MOVE AS-ACCOUNT-NO        TO WS-DB2-KEY-1N                
DC            MOVE AS-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
DC            MOVE AS-IC-NO             TO WS-DB2-KEY-3N                
DC            MOVE 12                   TO RETURN-CODE                  
DC            PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
DC         END-IF.                                                      
DC                                                                      
DC     8810-EXIT.                                                       
DC         EXIT.                                                        
                                                                        
       8820-UPDATE-CUST-PLAN.                                           
           EXEC SQL                                                     
               UPDATE CSS_CUST_PLAN                                     
                  SET LAST_BILL_DATE   = IIF(TRY_CONVERT(DATE, 
                                                     :CP-LAST-BILL-DATE
              ) IS NULL OR (PATINDEX('%.%', :CP-LAST-BILL-DATE
              ) <> 0) OR (LEN(:CP-LAST-BILL-DATE
              ) <> 10), CIS.CHAR2DATE(:CP-LAST-BILL-DATE
              ), CONVERT(DATE, :CP-LAST-BILL-DATE) )             
                  WHERE ACCOUNT_NO     = :CP-ACCOUNT-NO                 
                    AND IC_NO          = :CP-IC-NO                      
                    AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE             
                    AND RATE_ITEM_CODE = :CP-RATE-ITEM-CODE             
                    AND ITEM_SEQ_NO    = :CP-ITEM-SEQ-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUST_PLAN                                             
MFA-TR*           SET LAST_BILL_DATE   = :CP-LAST-BILL-DATE                     
MFA-TR*           WHERE ACCOUNT_NO     = :CP-ACCOUNT-NO                         
MFA-TR*             AND IC_NO          = :CP-IC-NO                              
MFA-TR*             AND CODE_UTIL_TYPE = :CP-CODE-UTIL-TYPE                     
MFA-TR*             AND RATE_ITEM_CODE = :CP-RATE-ITEM-CODE                     
MFA-TR*             AND ITEM_SEQ_NO    = :CP-ITEM-SEQ-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'CP'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8820'               TO WS-DB2-PARAGRAPH             
              MOVE CP-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE CP-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
              MOVE CP-IC-NO             TO WS-DB2-KEY-3N                
              MOVE CP-RATE-ITEM-CODE    TO WS-DB2-KEY-4N                
              MOVE 12                   TO RETURN-CODE                  
              PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
       8820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /                                                                         
       8830-UPDATE-BILL-CNTRCT.                                         
           IF BK-DATE-LFTM-HI-DMD = LOW-VALUES                          
              MOVE -1 TO WS-NULL-IND-1                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-1                                
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILL_CONTRACT                                 
                  SET BUILD_UP_MONTHS  = :BK-BUILD-UP-MONTHS,           
                      DATE_LFTM_HI_DMD = IIF(TRY_CONVERT(DATE, 
                                                  :BK-DATE-LFTM-HI-DMD 
                                                         :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :BK-DATE-LFTM-HI-DMD 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:BK-DATE-LFTM-HI-DMD :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:BK-DATE-LFTM-HI-DMD 
                                                         :WS-NULL-IND-1
              ), CONVERT(DATE, :BK-DATE-LFTM-HI-DMD :WS-NULL-IND-1) ),         
                      LFTM_HI_PEAK_DMD = :BK-LFTM-HI-PEAK-DMD,          
                      STDBY_YTD_HRS    = :BK-STDBY-YTD-HRS,             
                      STDBY_YTD_PK_HRS = :BK-STDBY-YTD-PK-HRS           
                  WHERE ACCOUNT_NO     = :BK-ACCOUNT-NO                 
                    AND IC_NO          = :BK-IC-NO                      
                    AND CODE_UTIL_TYPE = :BK-CODE-UTIL-TYPE             
                    AND CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                    :BK-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :BK-CNTRCT-START-DT
              ) <> 0) OR (LEN(:BK-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:BK-CNTRCT-START-DT
              ), CONVERT(DATE, :BK-CNTRCT-START-DT) )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILL_CONTRACT                                         
MFA-TR*           SET BUILD_UP_MONTHS  = :BK-BUILD-UP-MONTHS,                   
MFA-TR*               DATE_LFTM_HI_DMD = :BK-DATE-LFTM-HI-DMD                   
MFA-TR*                                  :WS-NULL-IND-1,                        
MFA-TR*               LFTM_HI_PEAK_DMD = :BK-LFTM-HI-PEAK-DMD,                  
MFA-TR*               STDBY_YTD_HRS    = :BK-STDBY-YTD-HRS,                     
MFA-TR*               STDBY_YTD_PK_HRS = :BK-STDBY-YTD-PK-HRS                   
MFA-TR*           WHERE ACCOUNT_NO     = :BK-ACCOUNT-NO                         
MFA-TR*             AND IC_NO          = :BK-IC-NO                              
MFA-TR*             AND CODE_UTIL_TYPE = :BK-CODE-UTIL-TYPE                     
MFA-TR*             AND CNTRCT_START_DT = :BK-CNTRCT-START-DT                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'BK'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8830'               TO WS-DB2-PARAGRAPH             
              MOVE BK-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BK-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
              MOVE BK-IC-NO             TO WS-DB2-KEY-3N                
              MOVE BK-CNTRCT-START-DT   TO WS-DB2-KEY-4                 
              MOVE 12                   TO RETURN-CODE                  
              PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
           END-IF.                                                      
       8830-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8840-UPDATE-INT-REQUEST.                                         
           EXEC SQL                                                     
               UPDATE CSS_INTERRUPT                                     
                  SET NON_COMPLIANCE_IND = :IR-NON-COMPLIANCE-IND       
                  WHERE ACCOUNT_NO         = :IR-ACCOUNT-NO             
                    AND IC_NO              = :IR-IC-NO                  
                    AND CODE_UTIL_TYPE     = :IR-CODE-UTIL-TYPE         
                    AND INTERRUPT_DATE     = IIF(TRY_CONVERT(DATE, 
                                                     :IR-INTERRUPT-DATE
              ) IS NULL OR (PATINDEX('%.%', :IR-INTERRUPT-DATE
              ) <> 0) OR (LEN(:IR-INTERRUPT-DATE
              ) <> 10), CIS.CHAR2DATE(:IR-INTERRUPT-DATE
              ), CONVERT(DATE, :IR-INTERRUPT-DATE) )         
                    AND INTERRUPT_TIME_OFF = CIS.CHAR2TIME(
                                                 :IR-INTERRUPT-TIME-OFF
              )     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_INTERRUPT                                             
MFA-TR*           SET NON_COMPLIANCE_IND = :IR-NON-COMPLIANCE-IND               
MFA-TR*           WHERE ACCOUNT_NO         = :IR-ACCOUNT-NO                     
MFA-TR*             AND IC_NO              = :IR-IC-NO                          
MFA-TR*             AND CODE_UTIL_TYPE     = :IR-CODE-UTIL-TYPE                 
MFA-TR*             AND INTERRUPT_DATE     = :IR-INTERRUPT-DATE                 
MFA-TR*             AND INTERRUPT_TIME_OFF = :IR-INTERRUPT-TIME-OFF             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'RP'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8840'               TO WS-DB2-PARAGRAPH             
              MOVE IR-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE IR-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
              MOVE IR-IC-NO             TO WS-DB2-KEY-3N                
              MOVE IR-INTERRUPT-DATE    TO WS-DB2-KEY-4                 
              MOVE 12                   TO RETURN-CODE                  
              PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
       8840-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00496 8841-PROCESS-INT-HIST.                                           
P00496     MOVE WS-ACCOUNT-NO-NZ (WS-NZ-INDX) TO NZ-ACCOUNT-NO          
P00496     MOVE WS-BILL-NO-NZ (WS-NZ-INDX)    TO NZ-BILL-NO             
P00496     MOVE WS-CODE-UTIL-TYPE-NZ (WS-NZ-INDX)                       
P00496                                   TO NZ-CODE-UTIL-TYPE           
P00496     MOVE WS-IC-NO-NZ (WS-NZ-INDX) TO NZ-IC-NO                    
P00496     MOVE WS-BILL-ITEM-TIMESTMP-NZ (WS-NZ-INDX)                   
P00496                                   TO NZ-BILL-ITEM-TIMESTMP       
P00496     MOVE WS-INTERRUPT-START-DT-NZ (WS-NZ-INDX)                   
P00496                                   TO NZ-INTERRUPT-START-DT       
P00496     MOVE WS-INTERRUPT-START-TIME-NZ (WS-NZ-INDX)                 
P00496                                   TO NZ-INTERRUPT-START-TM       
P00496     MOVE WS-EXCEPTION-CD-NZ (WS-NZ-INDX)                         
P00496                                   TO NZ-EXCEPTION-CD             
P00496     MOVE WS-NON-COMPLIANCE-IND-NZ (WS-NZ-INDX)                   
P00496                                   TO NZ-HOLD-TO-MDQ-FL           
P00496     MOVE WS-INTERRUPT-END-DT-NZ (WS-NZ-INDX)                     
P00496                                   TO NZ-INTERRUPT-END-DT         
P00496     MOVE WS-INTERRUPT-END-TM-NZ (WS-NZ-INDX)                     
P00496                                   TO NZ-INTERRUPT-END-TM         
P00496     MOVE WS-POWER-COST-NZ (WS-NZ-INDX)                           
P00496                                   TO NZ-EGAS-UNIT-AM             
P00496     MOVE SPACE TO NZ-COMMENT                                     
P00496     MOVE 13              TO NZ-COMMENT-LEN                       
P00496     MOVE 'BATCH BILLING' TO NZ-COMMENT-TEXT                      
P00496     .                                                            
P00496 8841-EXIT.                                                       
P00496     EXIT.                                                        
                                                                        
P00496 8842-INSERT-INT-HIST.                                            
P00496     EXEC SQL                                                     
P00496       INSERT INTO CSS_INTERRUPT_HIST                             
P00496          (ACCOUNT_NO                                             
P00496          ,BILL_NO                                                
P00496          ,CODE_UTIL_TYPE                                         
P00496          ,BILL_ITEM_TIMESTMP                                     
P00496          ,IC_NO                                                  
P00496          ,INTERRUPT_START_DT                                     
P00496          ,INTERRUPT_START_TM                                     
P00496          ,EXCEPTION_CD                                           
P00496          ,HOLD_TO_MDQ_FL                                         
P00496          ,INTERRUPT_END_DT                                       
P00496          ,INTERRUPT_END_TM                                       
P00496          ,COMMENT                                                
P00496          ,EGAS_UNIT_AM)                                          
P00496       VALUES                                                     
P00496          (:NZ-ACCOUNT-NO                                         
P00496          ,:NZ-BILL-NO                                            
P00496          ,:NZ-CODE-UTIL-TYPE                                     
P00496          ,CIS.CHAR2TIMESTAMP(:NZ-BILL-ITEM-TIMESTMP)                     
P00496          ,:NZ-IC-NO                                              
P00496          ,IIF(TRY_CONVERT(DATE, :NZ-INTERRUPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :NZ-INTERRUPT-START-DT
              ) <> 0) OR (LEN(:NZ-INTERRUPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:NZ-INTERRUPT-START-DT
              ), CONVERT(DATE, :NZ-INTERRUPT-START-DT) )                       
P00496          ,CIS.CHAR2TIME(:NZ-INTERRUPT-START-TM)                          
P00496          ,:NZ-EXCEPTION-CD                                       
P00496          ,:NZ-HOLD-TO-MDQ-FL                                     
P00496          ,IIF(TRY_CONVERT(DATE, :NZ-INTERRUPT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :NZ-INTERRUPT-END-DT
              ) <> 0) OR (LEN(:NZ-INTERRUPT-END-DT
              ) <> 10), CIS.CHAR2DATE(:NZ-INTERRUPT-END-DT
              ), CONVERT(DATE, :NZ-INTERRUPT-END-DT) )                         
P00496          ,CIS.CHAR2TIME(:NZ-INTERRUPT-END-TM)                            
P00496          ,:NZ-COMMENT                                            
P00496          ,:NZ-EGAS-UNIT-AM)                                      
P00496     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_INTERRUPT_HIST                                     
MFA-TR*         (ACCOUNT_NO                                                     
MFA-TR*         ,BILL_NO                                                        
MFA-TR*         ,CODE_UTIL_TYPE                                                 
MFA-TR*         ,BILL_ITEM_TIMESTMP                                             
MFA-TR*         ,IC_NO                                                          
MFA-TR*         ,INTERRUPT_START_DT                                             
MFA-TR*         ,INTERRUPT_START_TM                                             
MFA-TR*         ,EXCEPTION_CD                                                   
MFA-TR*         ,HOLD_TO_MDQ_FL                                                 
MFA-TR*         ,INTERRUPT_END_DT                                               
MFA-TR*         ,INTERRUPT_END_TM                                               
MFA-TR*         ,COMMENT                                                        
MFA-TR*         ,EGAS_UNIT_AM)                                                  
MFA-TR*      VALUES                                                             
MFA-TR*         (:NZ-ACCOUNT-NO                                                 
MFA-TR*         ,:NZ-BILL-NO                                                    
MFA-TR*         ,:NZ-CODE-UTIL-TYPE                                             
MFA-TR*         ,:NZ-BILL-ITEM-TIMESTMP                                         
MFA-TR*         ,:NZ-IC-NO                                                      
MFA-TR*         ,:NZ-INTERRUPT-START-DT                                         
MFA-TR*         ,:NZ-INTERRUPT-START-TM                                         
MFA-TR*         ,:NZ-EXCEPTION-CD                                               
MFA-TR*         ,:NZ-HOLD-TO-MDQ-FL                                             
MFA-TR*         ,:NZ-INTERRUPT-END-DT                                           
MFA-TR*         ,:NZ-INTERRUPT-END-TM                                           
MFA-TR*         ,:NZ-COMMENT                                                    
MFA-TR*         ,:NZ-EGAS-UNIT-AM)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00496                                                                  
P00496     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00496     EVALUATE TRUE                                                
P00496       WHEN WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
P00496            CONTINUE                                              
P00496       WHEN OTHER                                                 
P00496        MOVE 'NZ'                TO WS-DB2-TABLE-ID               
P00496        MOVE 'INSERT'            TO WS-DB2-FUNCTION               
P00496        MOVE SQLCODE             TO WS-DB2-RETURN-CODE            
P00496        MOVE '114'               TO WS-DB2-MODULE-ID              
P00496        MOVE '8842'              TO WS-DB2-PARAGRAPH              
P00496        MOVE NZ-ACCOUNT-NO       TO WS-DB2-KEY-1N                 
P00496        MOVE 12                  TO RETURN-CODE                   
P00496        PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
P00496     END-EVALUATE.                                                
P00496 8842-EXIT.                                                       
P00496     EXIT.                                                        
      /                                                                         
T33924 8845-UPDATE-BILL-ADJUST.                                         
                                                                        
T33924     EXEC SQL                                                     
T33924         UPDATE CSS_BILL_ADJUSTMNT                                
P00246            SET REVENUE_MONTH        = :BP-REVENUE-MONTH          
T33924               ,ADJ_REASON_DESC      = :BP-ADJ-REASON-DESC        
T33924            WHERE ACCOUNT_NO         = :BP-ACCOUNT-NO             
T33924              AND BILL_NO            = :BP-BILL-NO                
T33924              AND CODE_UTIL_TYPE     = :BP-CODE-UTIL-TYPE         
T33924              AND IC_NO              = :BP-IC-NO                  
P00246              AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BP-BILL-ITEM-TIMESTMP
              )     
P00246              AND ADJ_TYPE_CD        = :BP-ADJ-TYPE-CD            
T33924     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILL_ADJUSTMNT                                        
MFA-TR*           SET REVENUE_MONTH        = :BP-REVENUE-MONTH                  
MFA-TR*              ,ADJ_REASON_DESC      = :BP-ADJ-REASON-DESC                
MFA-TR*           WHERE ACCOUNT_NO         = :BP-ACCOUNT-NO                     
MFA-TR*             AND BILL_NO            = :BP-BILL-NO                        
MFA-TR*             AND CODE_UTIL_TYPE     = :BP-CODE-UTIL-TYPE                 
MFA-TR*             AND IC_NO              = :BP-IC-NO                          
MFA-TR*             AND BILL_ITEM_TIMESTMP = :BP-BILL-ITEM-TIMESTMP             
MFA-TR*             AND ADJ_TYPE_CD        = :BP-ADJ-TYPE-CD                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T33924                                                                  
T33924     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T33924     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
T33924        MOVE 'BP'                 TO WS-DB2-TABLE-ID              
T33924        MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
T33924        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T33924        MOVE '114'                TO WS-DB2-MODULE-ID             
T33924        MOVE '8845'               TO WS-DB2-PARAGRAPH             
T33924        MOVE BP-ACCOUNT-NO        TO WS-DB2-KEY-1N                
T33924        MOVE BP-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
T33924        MOVE BP-IC-NO             TO WS-DB2-KEY-3N                
T33924        MOVE 12                   TO RETURN-CODE                  
T33924        PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
T33924     END-IF.                                                      
T33924                                                                  
T33924 8845-EXIT.                                                       
T33924     EXIT.                                                        
                                                                        
       8850-UPDATE-INT-ACCOUNT.                                         
           EXEC SQL                                                     
               UPDATE CSS_INTERRUPT_ACCT                                
                  SET STATUS             = :IP-STATUS,                  
                      NON_COMPLIANCE_CNT = :IP-NON-COMPLIANCE-CNT       
                  WHERE ACCOUNT_NO     = :IP-ACCOUNT-NO                 
                    AND IC_NO          = :IP-IC-NO                      
                    AND CODE_UTIL_TYPE = :IP-CODE-UTIL-TYPE             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'IP'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8850'               TO WS-DB2-PARAGRAPH             
              MOVE IP-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE IP-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
              MOVE IP-IC-NO             TO WS-DB2-KEY-3N                
              MOVE 12                   TO RETURN-CODE                  
              PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
       8850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ** INSERT INTERRUPT ACCOUNT HISTORY                                       
      *                                                                         
                                                                        
P00496 8852-INSERT-AHST.                                                
P00496     EXEC SQL                                                     
P00496       INSERT INTO CSS_INTERRUPT_AHST                             
P00496              (ACCOUNT_NO                                         
P00496              ,CODE_UTIL_TYPE                                     
P00496              ,IC_NO                                              
P00496              ,BILL_NO                                            
P00496              ,BILL_ITEM_TIMESTMP                                 
P00496              ,CONTRACT_DATE                                      
P00496              ,CATEGORY                                           
P00496              ,FIRM_DEMAND_LEVEL                                  
P00496              ,TYP_INTRPT_DEMAND                                  
P00496              ,NON_COMPLIANCE_CNT)                                
P00496       VALUES                                                     
P00496              (:TH-ACCOUNT-NO                                     
P00496              ,:TH-CODE-UTIL-TYPE                                 
P00496              ,:TH-IC-NO                                          
P00496              ,:TH-BILL-NO                                        
P00496              ,CIS.CHAR2TIMESTAMP(:TH-BILL-ITEM-TIMESTMP)                 
P00496              ,IIF(TRY_CONVERT(DATE, :TH-CONTRACT-DATE
              ) IS NULL OR (PATINDEX('%.%', :TH-CONTRACT-DATE
              ) <> 0) OR (LEN(:TH-CONTRACT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :TH-CONTRACT-DATE
              ), CONVERT(DATE, :TH-CONTRACT-DATE) )                            
P00496              ,:TH-CATEGORY                                       
P00496              ,:TH-FIRM-DEMAND-LEVEL                              
P00496              ,:TH-TYP-INTRPT-DEMAND                              
P00496              ,:TH-NON-COMPLIANCE-CNT)                            
P00496     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_INTERRUPT_AHST                                     
MFA-TR*             (ACCOUNT_NO                                                 
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,BILL_ITEM_TIMESTMP                                         
MFA-TR*             ,CONTRACT_DATE                                              
MFA-TR*             ,CATEGORY                                                   
MFA-TR*             ,FIRM_DEMAND_LEVEL                                          
MFA-TR*             ,TYP_INTRPT_DEMAND                                          
MFA-TR*             ,NON_COMPLIANCE_CNT)                                        
MFA-TR*      VALUES                                                             
MFA-TR*             (:TH-ACCOUNT-NO                                             
MFA-TR*             ,:TH-CODE-UTIL-TYPE                                         
MFA-TR*             ,:TH-IC-NO                                                  
MFA-TR*             ,:TH-BILL-NO                                                
MFA-TR*             ,:TH-BILL-ITEM-TIMESTMP                                     
MFA-TR*             ,:TH-CONTRACT-DATE                                          
MFA-TR*             ,:TH-CATEGORY                                               
MFA-TR*             ,:TH-FIRM-DEMAND-LEVEL                                      
MFA-TR*             ,:TH-TYP-INTRPT-DEMAND                                      
MFA-TR*             ,:TH-NON-COMPLIANCE-CNT)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00496                                                                  
P00496     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00496     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00496        CONTINUE                                                  
P00496     ELSE                                                         
P00496        MOVE 'TH'                 TO WS-DB2-TABLE-ID              
P00496        MOVE 'INSERT'             TO WS-DB2-FUNCTION              
P00496        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00496        MOVE '114'                TO WS-DB2-MODULE-ID             
P00496        MOVE '8852'               TO WS-DB2-PARAGRAPH             
P00496        MOVE TH-ACCOUNT-NO        TO WS-DB2-KEY-1N                
P00496        MOVE TH-IC-NO             TO WS-DB2-KEY-2N                
P00496        MOVE TH-BILL-NO           TO WS-DB2-KEY-4N                
P00496        MOVE TH-CODE-UTIL-TYPE    TO WS-DB2-KEY-3                 
P00496        MOVE 12                   TO RETURN-CODE                  
P00496        PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
P00496     END-IF.                                                      
P00496                                                                  
P00496 8852-EXIT.                                                       
P00496     EXIT.                                                        
                                                                        
      *                                                                         
       8860-INSERT-MNT-TRANS-HIST.                                      
           EXEC SQL                                                     
              INSERT INTO CSS_MNT_TRANS_HIST                            
                 ( TRANS_HIST_SEQ_NO,                                   
                   DATE_TRANS,                                          
                   CODE_TRAN_TYPE,                                      
                   RESP_AREA_ID,                                        
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,                                         
                   PREMISE_NO,                                          
                   USER_ID,                                             
                   APPL_PROGRAM_ID,                                     
                   TRAN_COMMENT)                                        
              VALUES                                                    
                 ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),                   
                   IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
                   :MH-CODE-TRAN-TYPE,                                  
                   :MH-RESP-AREA-ID,                                    
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,                                     
                   :MH-PREMISE-NO,                                      
                   :MH-USER-ID,                                         
                   :MH-APPL-PROGRAM-ID,                                 
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MNT_TRANS_HIST                                    
MFA-TR*          ( TRANS_HIST_SEQ_NO,                                           
MFA-TR*            DATE_TRANS,                                                  
MFA-TR*            CODE_TRAN_TYPE,                                              
MFA-TR*            RESP_AREA_ID,                                                
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            PREMISE_NO,                                                  
MFA-TR*            USER_ID,                                                     
MFA-TR*            APPL_PROGRAM_ID,                                             
MFA-TR*            TRAN_COMMENT)                                                
MFA-TR*       VALUES                                                            
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO,                                       
MFA-TR*            :MH-DATE-TRANS,                                              
MFA-TR*            :MH-CODE-TRAN-TYPE,                                          
MFA-TR*            :MH-RESP-AREA-ID,                                            
MFA-TR*            :MH-ACCOUNT-NO,                                              
MFA-TR*            :MH-CUSTOMER-NO,                                             
MFA-TR*            :MH-PREMISE-NO,                                              
MFA-TR*            :MH-USER-ID,                                                 
MFA-TR*            :MH-APPL-PROGRAM-ID,                                         
MFA-TR*            :MH-TRAN-COMMENT)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'MH'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8860'               TO WS-DB2-PARAGRAPH             
              MOVE MH-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       8860-EXIT.                                                       
           EXIT.                                                        
P00892*****************************************************************         
P00892** INSERT INTO CSS_ACCT_RATE_HIST                                         
P00892*****************************************************************         
P00892 8861-INSERT-ACCT-RATE-HIST.                                      
P00892     EXEC SQL                                                     
P00892        INSERT INTO CSS_ACCT_RATE_HIST                            
P00892           ( ACCOUNT_NO                                           
P00892            ,CODE_UTIL_TYPE                                       
P00892            ,IC_NO                                                
P00892            ,RT_PKG_OPT_SEQ_NO                                    
P00892            ,TRANS_HIST_SEQ_NO                                    
P00892            ,LAST_UPDATE_TS                                       
P00892           )                                                      
P00892        VALUES                                                    
P00892           ( :5H-ACCOUNT-NO                                       
P00892            ,:5H-CODE-UTIL-TYPE                                   
P00892            ,:5H-IC-NO                                            
P00892            ,:5H-RT-PKG-OPT-SEQ-NO                                
P00892            ,CIS.CHAR2TIMESTAMP(:5H-TRANS-HIST-SEQ-NO)                    
P00892            ,CIS.CURRENT$TIMESTAMP()                                    
P00892            )                                                     
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCT_RATE_HIST                                    
MFA-TR*          ( ACCOUNT_NO                                                   
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,IC_NO                                                        
MFA-TR*           ,RT_PKG_OPT_SEQ_NO                                            
MFA-TR*           ,TRANS_HIST_SEQ_NO                                            
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          ( :5H-ACCOUNT-NO                                               
MFA-TR*           ,:5H-CODE-UTIL-TYPE                                           
MFA-TR*           ,:5H-IC-NO                                                    
MFA-TR*           ,:5H-RT-PKG-OPT-SEQ-NO                                        
MFA-TR*           ,:5H-TRANS-HIST-SEQ-NO                                        
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00892     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
P00892        NEXT SENTENCE                                             
P00892     ELSE                                                         
P00892        MOVE '5H'                 TO WS-DB2-TABLE-ID              
P00892        MOVE 'INSERT'             TO WS-DB2-FUNCTION              
P00892        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00892        MOVE '114'                TO WS-DB2-MODULE-ID             
P00892        MOVE '8861'               TO WS-DB2-PARAGRAPH             
P00892        MOVE 5H-ACCOUNT-NO        TO WS-DB2-KEY-1N                
P00892        MOVE 12 TO RETURN-CODE                                    
P00892        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
P00892     END-IF.                                                      
P00892                                                                  
P00892 8861-EXIT.                                                       
P00892     EXIT.                                                        
      *                                                                         
       8865-INSERT-MT-TRN-HST-DET.                                      
           EXEC SQL                                                     
              INSERT INTO CSS_MT_TRN_HST_DET                            
                 ( TRANS_HIST_SEQ_NO,                                   
                   TRAN_APPL_NO,                                        
                   COLUMN_DESC,                                         
ACT204             TABLE_ID,                                            
                   PRV_COLUMN_VALUE,                                    
                   CHG_COLUMN_VALUE)                                    
              VALUES                                                    
                 ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),                   
                   :MI-TRAN-APPL-NO,                                    
                   :MI-COLUMN-DESC,                                     
ACT204             :MI-TABLE-ID,                                        
                   :MI-PRV-COLUMN-VALUE,                                
                   :MI-CHG-COLUMN-VALUE)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MT_TRN_HST_DET                                    
MFA-TR*          ( TRANS_HIST_SEQ_NO,                                           
MFA-TR*            TRAN_APPL_NO,                                                
MFA-TR*            COLUMN_DESC,                                                 
MFA-TR*            TABLE_ID,                                                    
MFA-TR*            PRV_COLUMN_VALUE,                                            
MFA-TR*            CHG_COLUMN_VALUE)                                            
MFA-TR*       VALUES                                                            
MFA-TR*          ( :MI-TRANS-HIST-SEQ-NO,                                       
MFA-TR*            :MI-TRAN-APPL-NO,                                            
MFA-TR*            :MI-COLUMN-DESC,                                             
MFA-TR*            :MI-TABLE-ID,                                                
MFA-TR*            :MI-PRV-COLUMN-VALUE,                                        
MFA-TR*            :MI-CHG-COLUMN-VALUE)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'MI'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '114'                TO WS-DB2-MODULE-ID             
              MOVE '8865'               TO WS-DB2-PARAGRAPH             
              MOVE MH-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       8865-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T33924 8870-INSERT-BILL-ADJUST.                                         
T33924                                                                  
T33924     EXEC SQL                                                     
T33924       INSERT INTO CSS_BILL_ADJUSTMNT                             
T33924         (ACCOUNT_NO                                              
T33924         ,BILL_NO                                                 
T33924         ,CODE_UTIL_TYPE                                          
T33924         ,IC_NO                                                   
T33924         ,BILL_ITEM_TIMESTMP                                      
T33924         ,ADJ_TYPE_CD                                             
T33924         ,REVENUE_MONTH                                           
T33924         ,ADJ_REASON_DESC                                         
P00246         ,OVRRIDE_RT_REV_MTH                                      
P00246         ,OVRRIDE_RT_BILL_DT                                      
P00246         ,OVRRIDE_RT_BILL_CY)                                     
T33924       VALUES                                                     
T33924           (:BP-ACCOUNT-NO                                        
T33924           ,:BP-BILL-NO                                           
T33924           ,:BP-CODE-UTIL-TYPE                                    
T33924           ,:BP-IC-NO                                             
T33924           ,CIS.CHAR2TIMESTAMP(:BP-BILL-ITEM-TIMESTMP)                    
T33924           ,:BP-ADJ-TYPE-CD                                       
T33924           ,:BP-REVENUE-MONTH                                     
T33924           ,:BP-ADJ-REASON-DESC                                   
P00246           ,:BP-OVRRIDE-RT-REV-MTH                                
P00246           ,IIF(TRY_CONVERT(DATE, :BP-OVRRIDE-RT-BILL-DT 
                                        :WS-NULL-IND-31
              ) IS NULL OR (PATINDEX('%.%', :BP-OVRRIDE-RT-BILL-DT 
                                                        :WS-NULL-IND-31
              ) <> 0) OR (LEN(:BP-OVRRIDE-RT-BILL-DT :WS-NULL-IND-31
              ) <> 10), CIS.CHAR2DATE(:BP-OVRRIDE-RT-BILL-DT 
                                                        :WS-NULL-IND-31
              ), CONVERT(DATE, :BP-OVRRIDE-RT-BILL-DT :WS-NULL-IND-31
              ) )                 
P00246           ,:BP-OVRRIDE-RT-BILL-CY)                               
T33924     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_BILL_ADJUSTMNT                                     
MFA-TR*        (ACCOUNT_NO                                                      
MFA-TR*        ,BILL_NO                                                         
MFA-TR*        ,CODE_UTIL_TYPE                                                  
MFA-TR*        ,IC_NO                                                           
MFA-TR*        ,BILL_ITEM_TIMESTMP                                              
MFA-TR*        ,ADJ_TYPE_CD                                                     
MFA-TR*        ,REVENUE_MONTH                                                   
MFA-TR*        ,ADJ_REASON_DESC                                                 
MFA-TR*        ,OVRRIDE_RT_REV_MTH                                              
MFA-TR*        ,OVRRIDE_RT_BILL_DT                                              
MFA-TR*        ,OVRRIDE_RT_BILL_CY)                                             
MFA-TR*      VALUES                                                             
MFA-TR*          (:BP-ACCOUNT-NO                                                
MFA-TR*          ,:BP-BILL-NO                                                   
MFA-TR*          ,:BP-CODE-UTIL-TYPE                                            
MFA-TR*          ,:BP-IC-NO                                                     
MFA-TR*          ,:BP-BILL-ITEM-TIMESTMP                                        
MFA-TR*          ,:BP-ADJ-TYPE-CD                                               
MFA-TR*          ,:BP-REVENUE-MONTH                                             
MFA-TR*          ,:BP-ADJ-REASON-DESC                                           
MFA-TR*          ,:BP-OVRRIDE-RT-REV-MTH                                        
MFA-TR*          ,:BP-OVRRIDE-RT-BILL-DT:WS-NULL-IND-31                         
MFA-TR*          ,:BP-OVRRIDE-RT-BILL-CY)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T33924                                                                  
T33924     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T33924     EVALUATE TRUE                                                
T33924     WHEN WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
T33924        CONTINUE                                                  
T33924     WHEN WS-ACTIVE-RETURN-CODE = -803                            
T33924        PERFORM 8845-UPDATE-BILL-ADJUST THRU 8845-EXIT            
T33924     WHEN OTHER                                                   
T33924        MOVE 'BP'                 TO WS-DB2-TABLE-ID              
T33924        MOVE 'INSERT'             TO WS-DB2-FUNCTION              
T33924        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T33924        MOVE '114'                TO WS-DB2-MODULE-ID             
T33924        MOVE '8870'               TO WS-DB2-PARAGRAPH             
T33924        MOVE BP-ACCOUNT-NO        TO WS-DB2-KEY-1N                
T33924        MOVE 12 TO RETURN-CODE                                    
T33924        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
T33924     END-EVALUATE.                                                
T33924*                                                                         
T33924 8870-EXIT.                                                       
T33924     EXIT.                                                        
      *                                                                         
      /                                                                         
C34569 8880-UPDATE-ACCT-ATTR.                                           
C34569     IF YP-ATTRIBUTE-VALUE-DT = LOW-VALUES OR SPACES              
C34569        MOVE -1 TO WS-NULL-IND-26                                 
C34569     ELSE                                                         
C34569        MOVE ZERO TO WS-NULL-IND-26                               
C34569     END-IF                                                       
C34569     IF YP-ATTRIBUTE-VALUE-TX = LOW-VALUES OR SPACES              
C34569        MOVE -1 TO WS-NULL-IND-27                                 
C34569     ELSE                                                         
C34569        MOVE ZERO TO WS-NULL-IND-27                               
C34569     END-IF                                                       
C34569                                                                  
C34569     EXEC SQL                                                     
C34569        UPDATE CSS_ACCT_ATTRIBUTE                                 
C34569           SET ATTRIBUTE_VALUE_CD   = :YP-ATTRIBUTE-VALUE-CD      
C34569              ,ATTRIBUTE_VALUE_DT   = IIF(TRY_CONVERT(DATE, 
                                                :YP-ATTRIBUTE-VALUE-DT 
                                                        :WS-NULL-IND-26
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT 
                                                        :WS-NULL-IND-26
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT :WS-NULL-IND-26
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT 
                                                        :WS-NULL-IND-26
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT :WS-NULL-IND-26
              ) )             
C34569              ,ATTRIBUTE_VALUE_TX   = :YP-ATTRIBUTE-VALUE-TX 
                                            :WS-NULL-IND-27             
C34569              ,CREATED_TS           = CIS.CHAR2TIMESTAMP(
                                                         :YP-CREATED-TS
              )              
C34569              ,STATUS_CD            = :YP-STATUS-CD               
C34569           WHERE  ACCOUNT_NO        = :YP-ACCOUNT-NO              
C34569           AND    ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC          
C34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCT_ATTRIBUTE                                         
MFA-TR*          SET ATTRIBUTE_VALUE_CD   = :YP-ATTRIBUTE-VALUE-CD              
MFA-TR*             ,ATTRIBUTE_VALUE_DT   = :YP-ATTRIBUTE-VALUE-DT              
MFA-TR*                                     :WS-NULL-IND-26                     
MFA-TR*             ,ATTRIBUTE_VALUE_TX   = :YP-ATTRIBUTE-VALUE-TX              
MFA-TR*                                     :WS-NULL-IND-27                     
MFA-TR*             ,CREATED_TS           = :YP-CREATED-TS                      
MFA-TR*             ,STATUS_CD            = :YP-STATUS-CD                       
MFA-TR*          WHERE  ACCOUNT_NO        = :YP-ACCOUNT-NO                      
MFA-TR*          AND    ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569                                                                  
C34569     IF SQLCODE = NOT-FOUND                                       
C34569        CONTINUE                                                  
C34569     ELSE                                                         
C34569        IF SQLCODE NOT = SUCCESSFUL-CALL                          
C34569           MOVE 'FF'                 TO WS-DB2-TABLE-ID           
C34569           MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
C34569           MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
C34569           MOVE '114'                TO WS-DB2-MODULE-ID          
C34569           MOVE '8880'               TO WS-DB2-PARAGRAPH          
C34569           MOVE YP-ACCOUNT-NO        TO WS-DB2-KEY-1N             
C34569           MOVE YP-ATTRIBUTE-DESC    TO WS-DB2-KEY-2N             
C34569           MOVE YP-STATUS-CD         TO WS-DB2-KEY-3              
C34569           MOVE YP-ATTRIBUTE-VALUE-CD TO WS-DB2-KEY-4N            
C34569           MOVE 12 TO RETURN-CODE                                 
C34569           PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
C34569        END-IF                                                    
C34569     END-IF.                                                      
C34569 8880-EXIT.                                                       
C34569     EXIT.                                                        
C34569                                                                  
C34569 8885-INSERT-ACCT-ATTR.                                           
C34569     IF YP-ATTRIBUTE-VALUE-DT = LOW-VALUES OR SPACES              
C34569        MOVE -1 TO WS-NULL-IND-26                                 
C34569     ELSE                                                         
C34569        MOVE ZERO TO WS-NULL-IND-26                               
C34569     END-IF                                                       
C34569     IF YP-ATTRIBUTE-VALUE-TX = LOW-VALUES OR SPACES              
C34569        MOVE -1 TO WS-NULL-IND-27                                 
C34569     ELSE                                                         
C34569        MOVE ZERO TO WS-NULL-IND-27                               
C34569     END-IF                                                       
C34569                                                                  
C34569     EXEC SQL                                                     
C34569          INSERT INTO CSS_ACCT_ATTRIBUTE                          
C34569           (ACCOUNT_NO                                            
C34569           ,ATTRIBUTE_DESC                                        
C34569           ,ATTRIBUTE_VALUE_CD                                    
C34569           ,ATTRIBUTE_VALUE_DT                                    
C34569           ,ATTRIBUTE_VALUE_TX                                    
C34569           ,CREATED_TS                                            
C34569           ,STATUS_CD)                                            
C34569          VALUES                                                  
C34569           (:YP-ACCOUNT-NO,                                       
C34569            :YP-ATTRIBUTE-DESC,                                   
C34569            :YP-ATTRIBUTE-VALUE-CD,                               
C34569            IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT 
                                        :WS-NULL-IND-26
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT 
                                                        :WS-NULL-IND-26
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT :WS-NULL-IND-26
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT 
                                                        :WS-NULL-IND-26
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT :WS-NULL-IND-26
              ) ),               
C34569            :YP-ATTRIBUTE-VALUE-TX :WS-NULL-IND-27,               
C34569            CIS.CHAR2TIMESTAMP(:YP-CREATED-TS),                           
C34569            :YP-STATUS-CD)                                        
C34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ACCT_ATTRIBUTE                                  
MFA-TR*          (ACCOUNT_NO                                                    
MFA-TR*          ,ATTRIBUTE_DESC                                                
MFA-TR*          ,ATTRIBUTE_VALUE_CD                                            
MFA-TR*          ,ATTRIBUTE_VALUE_DT                                            
MFA-TR*          ,ATTRIBUTE_VALUE_TX                                            
MFA-TR*          ,CREATED_TS                                                    
MFA-TR*          ,STATUS_CD)                                                    
MFA-TR*         VALUES                                                          
MFA-TR*          (:YP-ACCOUNT-NO,                                               
MFA-TR*           :YP-ATTRIBUTE-DESC,                                           
MFA-TR*           :YP-ATTRIBUTE-VALUE-CD,                                       
MFA-TR*           :YP-ATTRIBUTE-VALUE-DT :WS-NULL-IND-26,                       
MFA-TR*           :YP-ATTRIBUTE-VALUE-TX :WS-NULL-IND-27,                       
MFA-TR*           :YP-CREATED-TS,                                               
MFA-TR*           :YP-STATUS-CD)                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569                                                                  
C34569     EVALUATE SQLCODE                                             
C34569        WHEN SUCCESSFUL-CALL                                      
C34569        WHEN ALREADY-EXISTS                                       
C34569             CONTINUE                                             
C34569        WHEN OTHER                                                
C34569            MOVE 'YP'                 TO WS-DB2-TABLE-ID          
C34569            MOVE 'INSERT'             TO WS-DB2-FUNCTION          
C34569            MOVE SQLCODE              TO WS-DB2-RETURN-CODE       
C34569            MOVE '114'                TO WS-DB2-MODULE-ID         
C34569            MOVE '8885'               TO WS-DB2-PARAGRAPH         
C34569            MOVE YP-ACCOUNT-NO        TO WS-DB2-KEY-1N            
C34569            MOVE YP-ATTRIBUTE-DESC    TO WS-DB2-KEY-2N            
C34569            MOVE YP-STATUS-CD         TO WS-DB2-KEY-3             
C34569            MOVE YP-ATTRIBUTE-VALUE-CD TO WS-DB2-KEY-4N           
C34569            MOVE 12 TO RETURN-CODE                                
C34569            PERFORM 9900-SQL-ERROR     THRU 9900-EXIT             
C34569     END-EVALUATE.                                                
C34569 8885-EXIT.                                                       
C34569     EXIT.                                                        
P00471*                                                                         
P00471******************************************************************15170000
P00471* 8887-DELETE-ACCT-ATTR.                                         *15180000
P00471******************************************************************15190000
P00471*                                                                 15200000
P00471 8887-DELETE-ACCT-ATTR.                                           
P00471*                                                                         
P00471     EXEC SQL                                                     
P00471         DELETE FROM CSS_ACCT_ATTRIBUTE                           
P00471          WHERE ACCOUNT_NO      = :YP-ACCOUNT-NO                  
P00471            AND ATTRIBUTE_DESC  = :YP-ATTRIBUTE-DESC              
P00471     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00471                                                                  
P00471     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
P00471         NEXT SENTENCE                                            
P00471     ELSE                                                         
P00471        MOVE 'YP'                 TO WS-DB2-TABLE-ID              
P00471        MOVE 'DELETE'             TO WS-DB2-FUNCTION              
P00471        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00471        MOVE '114'                TO WS-DB2-MODULE-ID             
P00471        MOVE '8887'               TO WS-DB2-PARAGRAPH             
P00471        MOVE YP-ACCOUNT-NO        TO WS-DB2-KEY-1N                
P00471        MOVE YP-ATTRIBUTE-DESC    TO WS-DB2-KEY-2N                
P00471        MOVE 12                   TO RETURN-CODE                  
P00471        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
P00471     END-IF.                                                      
P00471 8887-EXIT.                                                       
P00471     EXIT.                                                        
P00471*                                                                         
C34569/                                                                         
C34569 8890-UPDATE-MKT-TIER.                                            
C34569     EXEC SQL                                                     
C34569        UPDATE CSS_ACCT_MKT_TIER                                  
C34569           SET   CREATED_TS             = CIS.CHAR2TIMESTAMP(
                                                         :DD-CREATED-TS
              )          
C34569                ,LAST_UPDATE_USERID     = :DD-LAST-UPDATE-USERID  
C34569                ,EFF_START_DT           = IIF(TRY_CONVERT(DATE, 
                                                       :DD-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-EFF-START-DT
              ) <> 0) OR (LEN(:DD-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :DD-EFF-START-DT
              ), CONVERT(DATE, :DD-EFF-START-DT) )        
C34569                ,LAST_UPDATE_TS         = CIS.CHAR2TIMESTAMP(
                                                     :DD-LAST-UPDATE-TS
              )      
C34569                ,LAST_EVALUATED_DT      = IIF(TRY_CONVERT(DATE, 
                                                  :DD-LAST-EVALUATED-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-LAST-EVALUATED-DT
              ) <> 0) OR (LEN(:DD-LAST-EVALUATED-DT
              ) <> 10), CIS.CHAR2DATE(:DD-LAST-EVALUATED-DT
              ), CONVERT(DATE, :DD-LAST-EVALUATED-DT) )   
C34569                ,TIER_SOURCE_CD         = :DD-TIER-SOURCE-CD      
C34569                ,ADJ_TIER_SEQ_NO        = :DD-ADJ-TIER-SEQ-NO     
C34569           WHERE  ACCOUNT_NO            = :DD-ACCOUNT-NO          
C34569             AND  TIER_CUST_STAT_CD     = :DD-TIER-CUST-STAT-CD   
C34569             AND  TIER_ACCT_TYPE_CD     = :DD-TIER-ACCT-TYPE-CD   
C34569             AND  MKT_TIER_RANKING      = :DD-MKT-TIER-RANKING    
C34569             AND  MKT_TIER_START_DT     = IIF(TRY_CONVERT(DATE, 
                                                  :DD-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DD-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DD-MKT-TIER-START-DT
              ), CONVERT(DATE, :DD-MKT-TIER-START-DT) )   
C34569             AND  COMPANY_NO            = :DD-COMPANY-NO          
C34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCT_MKT_TIER                                          
MFA-TR*          SET   CREATED_TS             = :DD-CREATED-TS                  
MFA-TR*               ,LAST_UPDATE_USERID     = :DD-LAST-UPDATE-USERID          
MFA-TR*               ,EFF_START_DT           = :DD-EFF-START-DT                
MFA-TR*               ,LAST_UPDATE_TS         = :DD-LAST-UPDATE-TS              
MFA-TR*               ,LAST_EVALUATED_DT      = :DD-LAST-EVALUATED-DT           
MFA-TR*               ,TIER_SOURCE_CD         = :DD-TIER-SOURCE-CD              
MFA-TR*               ,ADJ_TIER_SEQ_NO        = :DD-ADJ-TIER-SEQ-NO             
MFA-TR*          WHERE  ACCOUNT_NO            = :DD-ACCOUNT-NO                  
MFA-TR*            AND  TIER_CUST_STAT_CD     = :DD-TIER-CUST-STAT-CD           
MFA-TR*            AND  TIER_ACCT_TYPE_CD     = :DD-TIER-ACCT-TYPE-CD           
MFA-TR*            AND  MKT_TIER_RANKING      = :DD-MKT-TIER-RANKING            
MFA-TR*            AND  MKT_TIER_START_DT     = :DD-MKT-TIER-START-DT           
MFA-TR*            AND  COMPANY_NO            = :DD-COMPANY-NO                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569                                                                  
C34569     IF SQLCODE = NOT-FOUND                                       
C34569        CONTINUE                                                  
C34569     ELSE                                                         
C34569        IF SQLCODE NOT = SUCCESSFUL-CALL                          
C34569           MOVE 'DD'                 TO WS-DB2-TABLE-ID           
C34569           MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
C34569           MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
C34569           MOVE '114'                TO WS-DB2-MODULE-ID          
C34569           MOVE '8890'               TO WS-DB2-PARAGRAPH          
C34569           MOVE DD-ACCOUNT-NO        TO WS-DB2-KEY-1N             
C34569           MOVE DD-TIER-CUST-STAT-CD TO WS-DB2-KEY-2N             
C34569           MOVE DD-MKT-TIER-START-DT TO WS-DB2-KEY-4N             
C34569           MOVE 12 TO RETURN-CODE                                 
C34569           PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
C34569        END-IF                                                    
C34569     END-IF.                                                      
C34569 8890-EXIT.                                                       
C34569     EXIT.                                                        
C34569 8895-INSERT-MKT-TIER.                                            
C34569     EXEC SQL                                                     
C34569          INSERT INTO CSS_ACCT_MKT_TIER                           
C34569           (ACCOUNT_NO                                            
C34569           ,TIER_CUST_STAT_CD                                     
C34569           ,TIER_ACCT_TYPE_CD                                     
C34569           ,MKT_TIER_RANKING                                      
C34569           ,MKT_TIER_START_DT                                     
C34569           ,CREATED_TS                                            
C34569           ,COMPANY_NO                                            
C34569           ,LAST_UPDATE_USERID                                    
C34569           ,EFF_START_DT                                          
C34569           ,LAST_UPDATE_TS                                        
C34569           ,LAST_EVALUATED_DT                                     
C34569           ,TIER_SOURCE_CD                                        
C34569           ,ADJ_TIER_SEQ_NO)                                      
C34569          VALUES                                                  
C34569           (:DD-ACCOUNT-NO,                                       
C34569            :DD-TIER-CUST-STAT-CD,                                
C34569            :DD-TIER-ACCT-TYPE-CD,                                
C34569            :DD-MKT-TIER-RANKING,                                 
C34569            IIF(TRY_CONVERT(DATE, :DD-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DD-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DD-MKT-TIER-START-DT
              ), CONVERT(DATE, :DD-MKT-TIER-START-DT) ),                       
C34569            CIS.CHAR2TIMESTAMP(:DD-CREATED-TS),                           
C34569            :DD-COMPANY-NO,                                       
C34569            :DD-LAST-UPDATE-USERID,                               
C34569            IIF(TRY_CONVERT(DATE, :DD-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-EFF-START-DT
              ) <> 0) OR (LEN(:DD-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :DD-EFF-START-DT
              ), CONVERT(DATE, :DD-EFF-START-DT) ),                            
C34569            CIS.CHAR2TIMESTAMP(:DD-LAST-UPDATE-TS),                       
C34569            IIF(TRY_CONVERT(DATE, :DD-LAST-EVALUATED-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-LAST-EVALUATED-DT
              ) <> 0) OR (LEN(:DD-LAST-EVALUATED-DT
              ) <> 10), CIS.CHAR2DATE(:DD-LAST-EVALUATED-DT
              ), CONVERT(DATE, :DD-LAST-EVALUATED-DT) ),                       
C34569            :DD-TIER-SOURCE-CD,                                   
C34569            :DD-ADJ-TIER-SEQ-NO)                                  
C34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ACCT_MKT_TIER                                   
MFA-TR*          (ACCOUNT_NO                                                    
MFA-TR*          ,TIER_CUST_STAT_CD                                             
MFA-TR*          ,TIER_ACCT_TYPE_CD                                             
MFA-TR*          ,MKT_TIER_RANKING                                              
MFA-TR*          ,MKT_TIER_START_DT                                             
MFA-TR*          ,CREATED_TS                                                    
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,EFF_START_DT                                                  
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,LAST_EVALUATED_DT                                             
MFA-TR*          ,TIER_SOURCE_CD                                                
MFA-TR*          ,ADJ_TIER_SEQ_NO)                                              
MFA-TR*         VALUES                                                          
MFA-TR*          (:DD-ACCOUNT-NO,                                               
MFA-TR*           :DD-TIER-CUST-STAT-CD,                                        
MFA-TR*           :DD-TIER-ACCT-TYPE-CD,                                        
MFA-TR*           :DD-MKT-TIER-RANKING,                                         
MFA-TR*           :DD-MKT-TIER-START-DT,                                        
MFA-TR*           :DD-CREATED-TS,                                               
MFA-TR*           :DD-COMPANY-NO,                                               
MFA-TR*           :DD-LAST-UPDATE-USERID,                                       
MFA-TR*           :DD-EFF-START-DT,                                             
MFA-TR*           :DD-LAST-UPDATE-TS,                                           
MFA-TR*           :DD-LAST-EVALUATED-DT,                                        
MFA-TR*           :DD-TIER-SOURCE-CD,                                           
MFA-TR*           :DD-ADJ-TIER-SEQ-NO)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569                                                                  
C34569     EVALUATE SQLCODE                                             
C34569        WHEN SUCCESSFUL-CALL                                      
C34569        WHEN ALREADY-EXISTS                                       
C34569             CONTINUE                                             
C34569        WHEN OTHER                                                
C34569            MOVE 'DD'                 TO WS-DB2-TABLE-ID          
C34569            MOVE 'INSERT'             TO WS-DB2-FUNCTION          
C34569            MOVE SQLCODE              TO WS-DB2-RETURN-CODE       
C34569            MOVE '114'                TO WS-DB2-MODULE-ID         
C34569            MOVE '8895'               TO WS-DB2-PARAGRAPH         
C34569            MOVE DD-ACCOUNT-NO        TO WS-DB2-KEY-1N            
C34569            MOVE DD-TIER-CUST-STAT-CD TO WS-DB2-KEY-2N            
C34569            MOVE DD-MKT-TIER-START-DT TO WS-DB2-KEY-4N            
C34569            MOVE 12 TO RETURN-CODE                                
C34569            PERFORM 9900-SQL-ERROR     THRU 9900-EXIT             
C34569     END-EVALUATE.                                                
C34569 8895-EXIT.                                                       
C34569     EXIT.                                                        
C34569/                                                                         
C34569 8900-UPDATE-RTPK-AGR.                                            
C34569*                                                                         
C34569     EXEC SQL                                                     
C34569        UPDATE CSS_ACCT_RTPK_AGR                                  
C34569           SET    TRANS_SEQ_ID          = :DF-TRANS-SEQ-ID        
C34569                 ,OFFER_CD              = :DF-OFFER-CD            
C34569                 ,OPTION_CD             = :DF-OPTION-CD           
C34569                 ,PROMO_CD              = :DF-PROMO-CD            
C34569                 ,STATUS_CD             = :DF-STATUS-CD           
C34569                 ,COMM_CHANNEL          = :DF-COMM-CHANNEL        
C34569                 ,CREATED_USERID        = :DF-CREATED-USERID      
C34569                 ,LAST_UPDATE_USERID    = :DF-LAST-UPDATE-USERID  
C34569                 ,OPT_AGRMT_EFF_DT      = IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )    
C34569                 ,OPT_AGRMT_EFF_TM      = CIS.CHAR2TIME(
                                                   :DF-OPT-AGRMT-EFF-TM
              )    
C34569                 ,CREATED_TS            = CIS.CHAR2TIMESTAMP(
                                                         :DF-CREATED-TS
              )          
C34569                 ,LAST_UPDATE_TS        = CIS.CHAR2TIMESTAMP(
                                                     :DF-LAST-UPDATE-TS
              )      
C34569                 ,COMPANY_NO            = :DF-COMPANY-NO          
C34569                 ,STATUS_EFF_REV_MTH    = :DF-STATUS-EFF-REV-MTH  
C34569                 ,AGREEMNT_SOURCE_CD    = :DF-AGREEMNT-SOURCE-CD  
C34569                 ,ADJ_TIER_SEQ_NO       = :DF-ADJ-TIER-SEQ-NO     
P00680                 ,STAT_ADJUSTABLE_CD    = :DF-STAT-ADJUSTABLE-CD  
ACT004                 ,STATUS_CHANGE_DT      = IIF(TRY_CONVERT(DATE, 
                                                   :DF-STATUS-CHANGE-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-STATUS-CHANGE-DT
              ) <> 0) OR (LEN(:DF-STATUS-CHANGE-DT
              ) <> 10), CIS.CHAR2DATE(:DF-STATUS-CHANGE-DT
              ), CONVERT(DATE, :DF-STATUS-CHANGE-DT) )    
C34569           WHERE  ACCOUNT_NO            = :DF-ACCOUNT-NO          
C34569             AND  CODE_UTIL_TYPE        = :DF-CODE-UTIL-TYPE      
C34569             AND  IC_NO                 = :DF-IC-NO               
C34569             AND  RT_PKG_OPT_SEQ_NO     = :DF-RT-PKG-OPT-SEQ-NO   
C34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCT_RTPK_AGR                                          
MFA-TR*          SET    TRANS_SEQ_ID          = :DF-TRANS-SEQ-ID                
MFA-TR*                ,OFFER_CD              = :DF-OFFER-CD                    
MFA-TR*                ,OPTION_CD             = :DF-OPTION-CD                   
MFA-TR*                ,PROMO_CD              = :DF-PROMO-CD                    
MFA-TR*                ,STATUS_CD             = :DF-STATUS-CD                   
MFA-TR*                ,COMM_CHANNEL          = :DF-COMM-CHANNEL                
MFA-TR*                ,CREATED_USERID        = :DF-CREATED-USERID              
MFA-TR*                ,LAST_UPDATE_USERID    = :DF-LAST-UPDATE-USERID          
MFA-TR*                ,OPT_AGRMT_EFF_DT      = :DF-OPT-AGRMT-EFF-DT            
MFA-TR*                ,OPT_AGRMT_EFF_TM      = :DF-OPT-AGRMT-EFF-TM            
MFA-TR*                ,CREATED_TS            = :DF-CREATED-TS                  
MFA-TR*                ,LAST_UPDATE_TS        = :DF-LAST-UPDATE-TS              
MFA-TR*                ,COMPANY_NO            = :DF-COMPANY-NO                  
MFA-TR*                ,STATUS_EFF_REV_MTH    = :DF-STATUS-EFF-REV-MTH          
MFA-TR*                ,AGREEMNT_SOURCE_CD    = :DF-AGREEMNT-SOURCE-CD          
MFA-TR*                ,ADJ_TIER_SEQ_NO       = :DF-ADJ-TIER-SEQ-NO             
MFA-TR*                ,STAT_ADJUSTABLE_CD    = :DF-STAT-ADJUSTABLE-CD          
MFA-TR*                ,STATUS_CHANGE_DT      = :DF-STATUS-CHANGE-DT            
MFA-TR*          WHERE  ACCOUNT_NO            = :DF-ACCOUNT-NO                  
MFA-TR*            AND  CODE_UTIL_TYPE        = :DF-CODE-UTIL-TYPE              
MFA-TR*            AND  IC_NO                 = :DF-IC-NO                       
MFA-TR*            AND  RT_PKG_OPT_SEQ_NO     = :DF-RT-PKG-OPT-SEQ-NO           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569                                                                  
C34569     IF SQLCODE = NOT-FOUND                                       
C34569        CONTINUE                                                  
C34569     ELSE                                                         
C34569        IF SQLCODE NOT = SUCCESSFUL-CALL                          
C34569           MOVE 'DF'                 TO WS-DB2-TABLE-ID           
C34569           MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
C34569           MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
C34569           MOVE '114'                TO WS-DB2-MODULE-ID          
C34569           MOVE '8900'               TO WS-DB2-PARAGRAPH          
C34569           MOVE DF-ACCOUNT-NO        TO WS-DB2-KEY-1N             
C34569           MOVE DF-CODE-UTIL-TYPE    TO WS-DB2-KEY-2N             
C34569           MOVE DF-IC-NO             TO WS-DB2-KEY-3              
C34569           MOVE DF-RT-PKG-OPT-SEQ-NO TO WS-DB2-KEY-4N             
C34569           MOVE 12 TO RETURN-CODE                                 
C34569           PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
C34569        END-IF                                                    
C34569     END-IF.                                                      
C34569*                                                                         
C34569 8900-EXIT.                                                       
C34569     EXIT.                                                        
C34569/                                                                         
C34569 8905-INSERT-RTPK-AGR.                                            
C34569*                                                                         
C34569     EXEC SQL                                                     
C34569          INSERT INTO CSS_ACCT_RTPK_AGR                           
C34569           (ACCOUNT_NO                                            
C34569           ,CODE_UTIL_TYPE                                        
C34569           ,IC_NO                                                 
C34569           ,RT_PKG_OPT_SEQ_NO                                     
C34569           ,TRANS_SEQ_ID                                          
C34569           ,OFFER_CD                                              
C34569           ,OPTION_CD                                             
C34569           ,PROMO_CD                                              
C34569           ,STATUS_CD                                             
C34569           ,COMM_CHANNEL                                          
C34569           ,CREATED_USERID                                        
C34569           ,LAST_UPDATE_USERID                                    
C34569           ,OPT_AGRMT_EFF_DT                                      
C34569           ,OPT_AGRMT_EFF_TM                                      
C34569           ,CREATED_TS                                            
C34569           ,LAST_UPDATE_TS                                        
C34569           ,COMPANY_NO                                            
C34569           ,STATUS_EFF_REV_MTH                                    
C34569           ,AGREEMNT_SOURCE_CD                                    
C34569           ,ADJ_TIER_SEQ_NO                                       
P00680           ,STAT_ADJUSTABLE_CD                                    
act004           ,STATUS_CHANGE_DT )                                    
C34569          VALUES                                                  
C34569           (:DF-ACCOUNT-NO,                                       
C34569            :DF-CODE-UTIL-TYPE,                                   
C34569            :DF-IC-NO,                                            
C34569            :DF-RT-PKG-OPT-SEQ-NO,                                
C34569            :DF-TRANS-SEQ-ID,                                     
C34569            :DF-OFFER-CD,                                         
C34569            :DF-OPTION-CD,                                        
C34569            :DF-PROMO-CD,                                         
C34569            :DF-STATUS-CD,                                        
C34569            :DF-COMM-CHANNEL,                                     
C34569            :DF-CREATED-USERID,                                   
C34569            :DF-LAST-UPDATE-USERID,                               
C34569            IIF(TRY_CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) ),                        
C34569            CIS.CHAR2TIME(:DF-OPT-AGRMT-EFF-TM),                          
C34569            CIS.CHAR2TIMESTAMP(:DF-CREATED-TS),                           
C34569            CIS.CHAR2TIMESTAMP(:DF-LAST-UPDATE-TS),                       
C34569            :DF-COMPANY-NO,                                       
C34569            :DF-STATUS-EFF-REV-MTH,                               
C34569            :DF-AGREEMNT-SOURCE-CD,                               
C34569            :DF-ADJ-TIER-SEQ-NO,                                  
P00680            :DF-STAT-ADJUSTABLE-CD                                
ACT004           ,IIF(TRY_CONVERT(DATE, :DF-STATUS-CHANGE-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-STATUS-CHANGE-DT
              ) <> 0) OR (LEN(:DF-STATUS-CHANGE-DT
              ) <> 10), CIS.CHAR2DATE(:DF-STATUS-CHANGE-DT
              ), CONVERT(DATE, :DF-STATUS-CHANGE-DT) ))                        
C34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ACCT_RTPK_AGR                                   
MFA-TR*          (ACCOUNT_NO                                                    
MFA-TR*          ,CODE_UTIL_TYPE                                                
MFA-TR*          ,IC_NO                                                         
MFA-TR*          ,RT_PKG_OPT_SEQ_NO                                             
MFA-TR*          ,TRANS_SEQ_ID                                                  
MFA-TR*          ,OFFER_CD                                                      
MFA-TR*          ,OPTION_CD                                                     
MFA-TR*          ,PROMO_CD                                                      
MFA-TR*          ,STATUS_CD                                                     
MFA-TR*          ,COMM_CHANNEL                                                  
MFA-TR*          ,CREATED_USERID                                                
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,OPT_AGRMT_EFF_DT                                              
MFA-TR*          ,OPT_AGRMT_EFF_TM                                              
MFA-TR*          ,CREATED_TS                                                    
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,STATUS_EFF_REV_MTH                                            
MFA-TR*          ,AGREEMNT_SOURCE_CD                                            
MFA-TR*          ,ADJ_TIER_SEQ_NO                                               
MFA-TR*          ,STAT_ADJUSTABLE_CD                                            
MFA-TR*          ,STATUS_CHANGE_DT )                                            
MFA-TR*         VALUES                                                          
MFA-TR*          (:DF-ACCOUNT-NO,                                               
MFA-TR*           :DF-CODE-UTIL-TYPE,                                           
MFA-TR*           :DF-IC-NO,                                                    
MFA-TR*           :DF-RT-PKG-OPT-SEQ-NO,                                        
MFA-TR*           :DF-TRANS-SEQ-ID,                                             
MFA-TR*           :DF-OFFER-CD,                                                 
MFA-TR*           :DF-OPTION-CD,                                                
MFA-TR*           :DF-PROMO-CD,                                                 
MFA-TR*           :DF-STATUS-CD,                                                
MFA-TR*           :DF-COMM-CHANNEL,                                             
MFA-TR*           :DF-CREATED-USERID,                                           
MFA-TR*           :DF-LAST-UPDATE-USERID,                                       
MFA-TR*           :DF-OPT-AGRMT-EFF-DT,                                         
MFA-TR*           :DF-OPT-AGRMT-EFF-TM,                                         
MFA-TR*           :DF-CREATED-TS,                                               
MFA-TR*           :DF-LAST-UPDATE-TS,                                           
MFA-TR*           :DF-COMPANY-NO,                                               
MFA-TR*           :DF-STATUS-EFF-REV-MTH,                                       
MFA-TR*           :DF-AGREEMNT-SOURCE-CD,                                       
MFA-TR*           :DF-ADJ-TIER-SEQ-NO,                                          
MFA-TR*           :DF-STAT-ADJUSTABLE-CD                                        
MFA-TR*          ,:DF-STATUS-CHANGE-DT)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569                                                                  
C34569     EVALUATE SQLCODE                                             
C34569        WHEN SUCCESSFUL-CALL                                      
C34569        WHEN ALREADY-EXISTS                                       
C34569             CONTINUE                                             
C34569        WHEN OTHER                                                
C34569            MOVE 'DF'                 TO WS-DB2-TABLE-ID          
C34569            MOVE 'INSERT'             TO WS-DB2-FUNCTION          
C34569            MOVE SQLCODE              TO WS-DB2-RETURN-CODE       
C34569            MOVE '114'                TO WS-DB2-MODULE-ID         
C34569            MOVE '8905'               TO WS-DB2-PARAGRAPH         
C34569            MOVE DF-ACCOUNT-NO        TO WS-DB2-KEY-1N            
C34569            MOVE DF-CODE-UTIL-TYPE    TO WS-DB2-KEY-2N            
C34569            MOVE DF-IC-NO             TO WS-DB2-KEY-3             
C34569            MOVE DF-RT-PKG-OPT-SEQ-NO TO WS-DB2-KEY-4N            
C34569            MOVE 12 TO RETURN-CODE                                
C34569            PERFORM 9900-SQL-ERROR     THRU 9900-EXIT             
C34569     END-EVALUATE.                                                
C34569*                                                                         
C34569 8905-EXIT.                                                       
C34569     EXIT.                                                        
P00251*                                                                         
P00251 8910-INSERT-UTL-BI-REL-HST.                                      
P00251*                                                                         
P00251      EXEC SQL                                                    
P00251           INSERT INTO CSS_UTL_BI_REL_HST                         
P00251           (ACCOUNT_NO_MST                                        
P00251           ,BILL_NO                                               
P00251           ,CODE_UTIL_TYPE_MST                                    
P00251           ,IC_NO_MST                                             
P00251           ,BILL_ITEM_TIMESTMP                                    
P00251           ,MTR_REF_NO_MST                                        
P00251           ,DEP_REL_START_DT                                      
P00251           ,ACCOUNT_NO_DEP                                        
P00251           ,CODE_UTIL_TYPE_DEP                                    
P00251           ,IC_NO_DEP                                             
P00251           ,MTR_REF_NO_DEP                                        
P00251           ,CODE_RELATION_TYPE                                    
P00251           ,DEP_REL_END_DT)                                       
P00251        VALUES                                                    
P00251           (:UX-ACCOUNT-NO-MST                                    
P00251           ,:UX-BILL-NO                                           
P00251           ,:UX-CODE-UTIL-TYPE-MST                                
P00251           ,:UX-IC-NO-MST                                         
P00251           ,CIS.CHAR2TIMESTAMP(:UX-BILL-ITEM-TIMESTMP)                    
P00251           ,:UX-MTR-REF-NO-MST                                    
P00251           ,IIF(TRY_CONVERT(DATE, :UX-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UX-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UX-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UX-DEP-REL-START-DT
              ), CONVERT(DATE, :UX-DEP-REL-START-DT) )                         
P00251           ,:UX-ACCOUNT-NO-DEP                                    
P00251           ,:UX-CODE-UTIL-TYPE-DEP                                
P00251           ,:UX-IC-NO-DEP                                         
P00251           ,:UX-MTR-REF-NO-DEP                                    
P00251           ,:UX-CODE-RELATION-TYPE                                
P00251           ,IIF(TRY_CONVERT(DATE, :UX-DEP-REL-END-DT
              ) IS NULL OR (PATINDEX('%.%', :UX-DEP-REL-END-DT
              ) <> 0) OR (LEN(:UX-DEP-REL-END-DT
              ) <> 10), CIS.CHAR2DATE(:UX-DEP-REL-END-DT
              ), CONVERT(DATE, :UX-DEP-REL-END-DT) ))                          
P00251      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO CSS_UTL_BI_REL_HST                                 
MFA-TR*          (ACCOUNT_NO_MST                                                
MFA-TR*          ,BILL_NO                                                       
MFA-TR*          ,CODE_UTIL_TYPE_MST                                            
MFA-TR*          ,IC_NO_MST                                                     
MFA-TR*          ,BILL_ITEM_TIMESTMP                                            
MFA-TR*          ,MTR_REF_NO_MST                                                
MFA-TR*          ,DEP_REL_START_DT                                              
MFA-TR*          ,ACCOUNT_NO_DEP                                                
MFA-TR*          ,CODE_UTIL_TYPE_DEP                                            
MFA-TR*          ,IC_NO_DEP                                                     
MFA-TR*          ,MTR_REF_NO_DEP                                                
MFA-TR*          ,CODE_RELATION_TYPE                                            
MFA-TR*          ,DEP_REL_END_DT)                                               
MFA-TR*       VALUES                                                            
MFA-TR*          (:UX-ACCOUNT-NO-MST                                            
MFA-TR*          ,:UX-BILL-NO                                                   
MFA-TR*          ,:UX-CODE-UTIL-TYPE-MST                                        
MFA-TR*          ,:UX-IC-NO-MST                                                 
MFA-TR*          ,:UX-BILL-ITEM-TIMESTMP                                        
MFA-TR*          ,:UX-MTR-REF-NO-MST                                            
MFA-TR*          ,:UX-DEP-REL-START-DT                                          
MFA-TR*          ,:UX-ACCOUNT-NO-DEP                                            
MFA-TR*          ,:UX-CODE-UTIL-TYPE-DEP                                        
MFA-TR*          ,:UX-IC-NO-DEP                                                 
MFA-TR*          ,:UX-MTR-REF-NO-DEP                                            
MFA-TR*          ,:UX-CODE-RELATION-TYPE                                        
MFA-TR*          ,:UX-DEP-REL-END-DT)                                           
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251      IF SQLCODE NOT = SUCCESSFUL-CALL                            
P00251         MOVE 'UX'                  TO WS-DB2-TABLE-ID            
P00251         MOVE 'INSERT'              TO WS-DB2-FUNCTION            
P00251         MOVE SQLCODE               TO WS-DB2-RETURN-CODE         
P00251         MOVE '114'                 TO WS-DB2-MODULE-ID           
P00251         MOVE '8910'                TO WS-DB2-PARAGRAPH           
P00251         MOVE UX-ACCOUNT-NO-MST     TO WS-DB2-KEY-1N              
P00251         MOVE UX-BILL-NO            TO WS-DB2-KEY-2N              
P00251         MOVE UX-CODE-UTIL-TYPE-MST TO WS-DB2-KEY-3               
P00251         MOVE UX-IC-NO-MST          TO WS-DB2-KEY-4N              
P00251         MOVE 12                    TO RETURN-CODE                
P00251         PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                
P00251      END-IF.                                                     
P00251  8910-EXIT.                                                      
P00251      EXIT.                                                       
P00496*                                                                         
P00496 8920-INSERT-BILL-BSLN-HIST.                                      
P00496*                                                                         
P00496      EXEC SQL                                                    
P00496           INSERT INTO CSS_BILL_BSLN_HIST                         
P00496           (ACCOUNT_NO                                            
P00496           ,CODE_UTIL_TYPE                                        
P00496           ,IC_NO                                                 
P00496           ,BILL_NO                                               
P00496           ,BILL_ITEM_TIMESTMP                                    
P00496           ,CNTRCT_START_DT                                       
P00496           ,CMPNT_ID_CD                                           
P00496           ,INSTR_USE_TYPE_CD                                     
P00496           ,CODE_TIME_PERIOD                                      
P00496           ,BASELINE_MONTH                                        
P00496           ,BASELINE_UNITS)                                       
P00496        VALUES                                                    
P00496           (:LO-ACCOUNT-NO                                        
P00496           ,:LO-CODE-UTIL-TYPE                                    
P00496           ,:LO-IC-NO                                             
P00496           ,:LO-BILL-NO                                           
P00496           ,CIS.CHAR2TIMESTAMP(:LO-BILL-ITEM-TIMESTMP)                    
P00496           ,IIF(TRY_CONVERT(DATE, :LO-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :LO-CNTRCT-START-DT
              ) <> 0) OR (LEN(:LO-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:LO-CNTRCT-START-DT
              ), CONVERT(DATE, :LO-CNTRCT-START-DT) )                          
P00496           ,:LO-CMPNT-ID-CD                                       
P00496           ,:LO-INSTR-USE-TYPE-CD                                 
P00496           ,:LO-CODE-TIME-PERIOD                                  
P00496           ,:LO-BASELINE-MONTH                                    
P00496           ,:LO-BASELINE-UNITS)                                   
P00496      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO CSS_BILL_BSLN_HIST                                 
MFA-TR*          (ACCOUNT_NO                                                    
MFA-TR*          ,CODE_UTIL_TYPE                                                
MFA-TR*          ,IC_NO                                                         
MFA-TR*          ,BILL_NO                                                       
MFA-TR*          ,BILL_ITEM_TIMESTMP                                            
MFA-TR*          ,CNTRCT_START_DT                                               
MFA-TR*          ,CMPNT_ID_CD                                                   
MFA-TR*          ,INSTR_USE_TYPE_CD                                             
MFA-TR*          ,CODE_TIME_PERIOD                                              
MFA-TR*          ,BASELINE_MONTH                                                
MFA-TR*          ,BASELINE_UNITS)                                               
MFA-TR*       VALUES                                                            
MFA-TR*          (:LO-ACCOUNT-NO                                                
MFA-TR*          ,:LO-CODE-UTIL-TYPE                                            
MFA-TR*          ,:LO-IC-NO                                                     
MFA-TR*          ,:LO-BILL-NO                                                   
MFA-TR*          ,:LO-BILL-ITEM-TIMESTMP                                        
MFA-TR*          ,:LO-CNTRCT-START-DT                                           
MFA-TR*          ,:LO-CMPNT-ID-CD                                               
MFA-TR*          ,:LO-INSTR-USE-TYPE-CD                                         
MFA-TR*          ,:LO-CODE-TIME-PERIOD                                          
MFA-TR*          ,:LO-BASELINE-MONTH                                            
MFA-TR*          ,:LO-BASELINE-UNITS)                                           
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00496      IF SQLCODE NOT = SUCCESSFUL-CALL                            
P00496         MOVE 'LO'                  TO WS-DB2-TABLE-ID            
P00496         MOVE 'INSERT'              TO WS-DB2-FUNCTION            
P00496         MOVE SQLCODE               TO WS-DB2-RETURN-CODE         
P00496         MOVE '114'                 TO WS-DB2-MODULE-ID           
P00496         MOVE '8920'                TO WS-DB2-PARAGRAPH           
P00496         MOVE LO-ACCOUNT-NO         TO WS-DB2-KEY-1N              
P00496         MOVE LO-BILL-NO            TO WS-DB2-KEY-2N              
P00496         MOVE LO-IC-NO              TO WS-DB2-KEY-3               
P00496         MOVE LO-BASELINE-MONTH     TO WS-DB2-KEY-4N              
P00496         MOVE 12                    TO RETURN-CODE                
P00496         PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                
P00496      END-IF.                                                     
P00496 8920-EXIT.                                                       
P00496     EXIT.                                                        
P00496*                                                                         
      /*****************************************************************        
      *                                                                *        
      *     CONTROLS ABNORMAL PROGRAM TERMINATION                      *        
      *                                                                *        
      ******************************************************************        
       9900-SQL-ERROR.                                                  
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
           END-IF.                                                      
                                                                        
           MOVE WS-DATABASE-EXCEPTION                                   
             TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)           
                                                                        
           COMPUTE WS-START-POS                                         
             = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1                 
           MOVE WS-SQL-ERROR-TXT-WQ                                     
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)   
           ADD WS-SQL-ERROR-TXT-LEN-WQ                                  
             TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                   
                                                                        
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       9900-EXIT.                                                       
           EXIT.                                                        
      **                                                                        
       9999-BAIL-OUT.                                                   
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
