       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA113.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      **  SUBROUTINE SCSCA113 IS A COMPONENT OF PCSCA100 (BATCH      **         
      **  BILLING).                                                  **         
      **                                                             **         
      **  CALLED BY: SCSCA110 (UPDATE BILL RESULTS)                  **         
      **                                                             **         
      **  SCSCA113 POSTS ALL A/R-RELATED UPDATES TO THE DATABASE     **         
      **                                                             **         
      **  THIS PROGRAM WAS BASED ON S2K BASE PROGRAM PCSCA150.       **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS  REASON                                 **         
      **  ________  ________  ______                                 **         
      **  01/20/95  XX57149   ORIGINAL SCE&G CHANGE REQUESTS         **         
      **  07/17/95  KMG       FIXED NULLS IN UPDATE AND INSERT OF FW **         
      **                      TABLE IN PARAGRAPH 8300,8310           **         
      **  12/19/95  ELJ       BU-AMT-PYMT-NEW IS NOT POPULATED BEFORE**         
      **                      PARGRAPH 8713-UPDATE-BUDGET-PLAN IS    **         
      **                      IS EXECUTED. TPR 2374.                 **         
      **  2/1/96    RSN       MOVE AND UPDATE CREDIT-STATUS CODE     **         
      **                      TPR #2998                              **         
      **  3/6/96    LMB       TPR 3442 - ADD ANNIVERSARY DATE TO     **         
      **                      UPDATE OF CSS_BUDGET_PLAN              **         
      **  4/30/96   LMB       TPR 3874 - AR SUMMARY ROWS(ITEM-ID = 0)**         
      **                      SHOULD HAVE 0 IN AMT-TRANS-BALANCE.    **         
      **  5/08/96   LMB       TPR 4039 - UPDATE CSS_MSTSUB_ACCT      **         
      **                      SUB-ACCT-BLLD-OK WITH 'Y'. (BILLED)    **         
      **  5/08/96   LMB       TPR 4079 - DPP EARNEST PAYMENTS SHOULD **         
      **                      BE BYPASSED DURING DFA-ACCT-TBL UPDATE **         
      **  6/18/96   LMB       TPR 4590 - IF BUDGET PLAN IS REMOVED,  **         
      **                      ZEROES MOVED TO WS-ACCOUNT-NO-BU SO    **         
      **                      BU ROW IS NOT WRITTEN ON BE00 FILE.    **         
      **  6/22/96   KMG       ADDED NULL IND TO 0 DAY DUE TO MASTER  **         
      **                      UPDATES FOR CONSOLIDATED BILLING WOULD **         
      **                      NOT HAVE A DATE IN 00 DAY DURING       **         
      **                      PARTITION 9 PROCESSING FOR INSERT      **         
      **                      OF SUB INFO ONTO THE MASTER            **         
      **  7/24/96   PP        PCR 0160 - POPULATING EPP_MTHS_RMNG_QT **         
      **                      IN CSS_BUDGET_HIST                     **         
      **  8/15/96   WTF       ADDED UPDATE TO CSS_REFUND FOR STANDBY **         
      **                      GENERATOR CREDITS                      **         
      **  8/19/96   WTF       TPR3019                                **         
PCR233**  9/25/96   MAD       ADDED LOGIC TO LOAD THE LAST NORMAL    **         
PCR233**                      BILL REVENUE MONTH AND UPDATE CSS_     **         
PCR233**                      ACCOUNT WITH THE LAST NORMAL BILL REV. **         
PCR233**                      MONTH FROM CWS10000.                   **         
PCR263**  9/27/96   CDS       PCR 263 - ADD LOGIC TO PROCESS NEW NOTC**         
PCR263**                      TYPES OF N AND O. ALSO FORCAST ROWS FRM**         
PCR263**                      CSS_CRED_COLL WILL BE DELETED WHEN THE **         
PCR263**                      BILLING DATE IS NOT EQUAL TO TODAYS    **         
PCR263**                      BILL DATE.                             **         
PCR285**  9/27/96   CDS       PCR 285 - FORECASTED ROWS IN TABLE     **         
PCR285**                      CSS_CRED_COLL WILL BE DELETED IF THE   **         
PCR285**                      ACCOUNT IS NOT ON MEDICAL CERTIFICATES.**         
PCR072** 10/01/96   PD        PCR 072 - REMOVED CODE FPR CIAC.       **         
PCR136** 10/02/96   CDS       PCR 136- ADD LOGIC TO UPDATE           **         
PCR136**                      NOTICE_EXEMPT_CD ON CSS_ACCOUNT.       **         
PCR212** 10/09/96   CDS       PCR212 - ADDED LOGIC TO UPDATE ON TABLE**         
PCR212**                      CSS_ACCOUNT FIELD ELEC_REV_PCT.        **         
T5832 ** 11/12/96   CSG       T5832 - CHANGE DELETE OF CSS_PROJ_SHARE**         
      **                      ROW TO DELETE OF THE PJS ROWS ON       **         
      **                      CSS_AR_CNTL.                           **         
T8117 ** 12/13/96   CSG       T8117 - WHEN REMOVED FROM EPP, SET THE **         
      **                      CODE-UTL FLAG IN CODES-DATA-PRESENT.   **         
T8654 ** 01/21/97   CSG       ****THIS LOGIC WILL BE REMOVED WHEN *****         
      **                      ****THE UPDATE FLAG IS ADDED TO CWS1000**         
      **                      T8654 - UPDATE CREDIT ACTION DATE ON   **         
      **                      NOTICE TYPE 'O' ROWS WHEN THE 'K' FLAG **         
      **                      IS SET.                                **         
TP7965**  1/28/97   ADA       T7965 - DFA RECECVBLE ROWS FROM A GUAR-**         
TP7965**                      ANTOR TRANSFER NEEDS TO BE INSERTED.   **         
TP6213**  1/28/97   ADA       T6213 - DPP ROWS SHOULD BE UPDATED BUT **         
TP6213**                      DFA WE DO NOT WANT TO UPDATE BECAUSE WE**         
TP6213**                      WANT TO KEEP THEM AS HISTORICAL DATA.  **         
TP6117**  1/29/97   ADA       T6117 - ADDED LOGIC TO DELETE AR_CNTL  **         
TP6117**                      ROWS WHEN THEY SHOULD.                 **         
T8843 **  2/03/97   CSG       T8843 - CHANGE THE CRED COLL LOGIC TO  **         
      **                      DELETE ROWS ONLY WHEN THE INDICATOR IS **         
      **                      SET TO 'D'.                            **         
T9134 **                      T9134 - INSERT AR CNTL ROWS IF THE UPD **         
      **                      INDICATOR IS SPACES.                   **         
CG0218**  2/18/97   CSG       CORRECT THE DELETE LOGIC OF THE AR CNTL**         
      **                      SUMMARY ROWS FOR PPL = 40, 45, 50, 129.**         
TP6055**  3/12/97   ELJ       ACCOUNT_NO_SUMM COLUMN HAS BEEN DROPPED**         
      **                      FROM CSS_BILLING_HDR. ALL REFERENCE    **         
      **                      TO ACCOUNT_NO_SUMM AND IT'S RELATED    **         
      **                      COLUMNS NXT_SMRY_BILL_NO AND           **         
      **                      NXT_SMRY_REBILL_NO OF THE CSS_ACCOUNT  **         
      **                      TABLE SHOULD BE REMOVED.               **         
TP8961**  3/18/97   RAH       POPULATE AT-ACCT-FINALED-DT WHEN AN    **         
      **                      ACCOUNT IS FINAL BILLED.               **         
T10149**  4/8/97    MJL       UPDATE CASH_ONLY_FL AND CSH_ONLY_EFFECT**         
      **                      DATE ON CSS_CREDIT_PROFILE             **         
T10177**  4/8/97    MJL       UPDATE AT-ACCT-FINALED-DT WITH INPUT   **         
      **                      INPUT DATE RATHER THAN CURRENT TIMESTMP**         
T10282**  4/9/97    TF        DO NOT DELETE CONTROL AC WHEN DETAILS  **         
      **                      ONLY HAVE TRAN BALANCE                 **         
T5502 **  4/10/97   MJL       MOVE LOGIC FROM CA114 TO CA113 TO      **         
      **                      UPDATE BILL HEADER.                    **         
T10534**  4/21/97   CSG       IF THE AR_CNTL CONNECT CHARGE ROW HAS  **         
      **                      BEEN DELETED, ALLOW A +100 RETURN CODE **         
      **                      FROM THE UPDATE OF CSS_CONNECT_CHRG.   **         
T10533**  4/22/97   MJL       CALCULATE TOTAL OTHER CHARGES AND TOTAL**         
      **                      ARREARS WHEN UPDATING BILL HEADER.     **         
T10749**  5/1/97    MJL       MOVE WS-DFA-PYMT-PRIORITY-DV TO        **         
      **                      DV-DFA-PYMT-PRIORITY INSTEAD OF 90     **         
T10723**  5/2/97    MJL       SET BILL HEADER TO FINAL FOR ALL FINAL **         
      **                      ACCOUNTS.                              **         
T10918**  5/7/97    CSG       UPDATE THE CANCEL/REBILL FIELDS ON THE **         
      **                      ACCOUNT TABLE.                         **         
T11084**  5/12/97   MJL       UPDATE DATE-PYMT-START ON DFA-ACCT     **         
PCR393**  6/5/97    MAD       DCR FOR CSS_DFA_RECVBLE.CNT_ITEM_ID.   **         
      **  6/11/97   CSG       TPRS 11624 AND 11538.                  **         
T11624**                      UPDATE ACCT-TERM-DT ON PROJ_SHARE TABLE**         
T11538**                      DON'T ADD TO WS-TOT-YTD-AM-PJ (THIS IS **         
      **                      IN CPD00010 WHEN A PYMT IS MADE).      **         
T11799**  6/24/97   MJL       UPDATE CWS1000 DATE-BILLED-BI.         **         
PCR408**  6/27/97   MAD       ADDED LOGIC TO UPDATE/INSERT NEW FIELDS**         
      **                       WS-GUARANTEED-IND-FW, WS-GUARANTOR-   **         
      **                       XFER-AM-FW AND WS-GUARANTOR-XFER-DT-FW**         
      **                       INTO CSS_FINAL_WO.                    **         
T11939**  7/3/97    MJL       ADD LOGIC TO SET SUB_ACCT_BILLED_OK    **         
      **                      AFTER SUB AND MASTER SUCCESSFULLY BILL **         
      **                      ADD LOGIC TO DELETE PENDING_XFER FROM  **         
      **                      PCSCA100.                              **         
T12094**  7/16/97   MJL       ADD NON UTILITY LOGIC TO CREATE WORK   **         
      **                      QUEUE TO FINAL BILL ACCOUNT            **         
T12238**  7/22/97   MAD       MODIFIED LOGIC TO UPDATE DATE_REFUNDED **         
      **                      ON CSS_REFUND - ADDED NULL INDICATORS  **         
      **                      TO DATE FIELDS INSERTED INTO CSS_REFUND**         
T12033**  7/31/97   MJL       UPDATE MASTER ACCT OVERRIDE IND AFTER  **         
      **                      SUCCESSFUL BILLING.                    **         
T12261**  8/01/97   CSG       CHANGE THE OCCURENCE OF THE REFUND     **         
      **                      TABLE TO 20.                           **         
      **  8/11/97   CSG       REMOVE THE SPECIAL CNT CODE ADDED TO   **         
      **                      DELETE MONTHLY CHARGE/CREDIT AR-CNTL.  **         
T12722**  8/13/97   MJL       DO NOT CREATE NON-UTIL FINAL BILL WQ   **         
      **                      IF THE ACCOUNT IS BEING FINAL BILLED.  **         
      **  8/14/97   CSG       TPRS 12721 AND 12716.                  **         
T12721**                      CORRECT AR-CNTL UPDATE LOGIC FOR SUMM  **         
      **                      ROWS.                                  **         
T12802**  8/19/97   CSG       DO NOT INCLUDE NSC/NSA/NSN IN THE      **         
      **                      AR-CNTL SUMMARY TABLE (THEY AREN'T     **         
      **                      DETAIL/SUMMARY PPLS).                  **         
T13274** 10/08/97   CSG       ONLY DELETE PJS AR-CNTL IF THE STATUS  **         
      **                      IS INACTIVE AND THERE IS NO MONEY LEFT.**         
T13451** 10/22/97   CSG       CHANGE THE VALUES WE USE TO CHECK      **         
      **                      WS-CODE-BILL-TYPE-CT AGAINST.          **         
T13529** 11/12/97   CSG       UPDATE THE ANNIVERSARY DATE/START DATE **         
      **                      FOR EPP EVEN IF NO NEW AMOUNT WAS      **         
      **                      CALC'D.                                **         
PERF  **  01/05/98    PD      REDUCE WORKING STORAGE FOR ONLINE      **         
PERF  **                      BY SPLITING WORKING STORAGE FOR        **         
PERF  **                      ONLINE AND BATCH PROGRAMS USING        **         
PERF  **                      CWS10000.                              **         
T14446** 01/23/98   CSG       MOVE LOGIC TO CHANGE CODE-BILL-PEND    **         
      **                      FROM SCSCA102.                         **         
T14428** 01/24/98   CSG       DO NOT RESET CODE-TEMP-BILL TO 'A'.    **         
      **                      IF A WQ EXISTS, SET THE FIELD TO       **         
      **                      WS-PULL-BILL.  WQ'S IN SCSCA114 WILL   **         
      **                      NOT SET THE FLAG, HOWEVER, THOSE ARE   **         
      **                      FATAL ERRORS AND THE ACCOUNT WILL NOT  **         
      **                      BE PASSED TO BILL PRINT.               **         
T15098** 02/26/98   CSG       CORRECT -811 ON PENDING_XFER.          **         
T14429** 03/06/98   RAH       UPDATE AT-CODE-TEMP-BILL WITH AN 'A'.  **         
T15127** 03/19/98   MDJ       UPDATE AT-AR-XFER-IND WITH WS-AR-XFER- **         
      **                      IND-AT.                                **         
T14628** 03/19/98   MDJ       WHEN DNP IS CANCELLED, CZ_DISC_EXCEPTN_**         
      **                      HIST OR CD_DISCONNECT_HIST IS UPDATED  **         
      **                      WITH 'I' IN SECOND POSITION.           **         
PCR629**  04/24/98     AMG    CHANGED THE CATEGORIES OF SOME         **         
PCR629**                      WORK QUEUES                            **         
T16221**  05/15/98  GAC       ALTERED IF STATEMENT SO CRED HIST IS   **         
      **                      ALWAYS UPDATED.                        **         
T16491**  05/20/98  CSG       UPDATE SUB FLAGS FOR FINAL BILLS.      **         
T16413**  05/26/98  GAC       CALCULATE UTILITY BALANCE INSTEAD OF   **         
      **                      SETTING TO 0 WHEN EPP AUTO DROPPED.    **         
T16564**  05/28/98  GAC       WHEN UPDATING CSS_CONNECT_CHRG, USE    **         
      **                      LS-INPUT-DATE FOR DATE_CCC_BILLED.     **         
T17277**  08/04/98  JER       ADDED NULL INDICATOR TO PARA 8250-     **         
      **                      UPDATE-CRED-COLL TO FIELD DATE-BILL    **         
T17240**  08/06/98  VK        MOVE LOCAL-OFFICE (WS-LOCAL-OFFICE-AT) **         
      **                      TO WS-LOCAL-OFFICE-RN(1).              **         
T17335**  08/11/98  KLP       UPDATE DATE_PYMT_STRT IN BUDGET_HIST   **         
      **                      WITH REV MONTH(CCYY-MM-DD) & DD='01'   **         
      **                      WHEN ACCOUNT IS REMOVED FROM EPP       **         
T17410**  08/19/98  JYL       CHANGED 1200- TO DELETE PAID/CANCELLED **         
T17410**                      CONTRACTS THAT ARE OF BILL_TYPE_CODE   **         
T17410**                      = ONE TIME CHARGE.                     **         
T17443**  08/19/98  JER       ADDED CODE TO ALLOW FOR A DUPLICATE    **         
      **                      KEY IN 8950-INSERT-CANCEL-DNP.         **         
T17946**  10/06/98  JYL       ADD PARA-8734 TO DELETE ROW FROM       **         
T17946**                      CSS_DFA_RECVBLE WHEN UPDATE ACTION IND **         
T17946**                      IN WS-DFA-RECV-DATA IS 'D'.  ALSO      **         
T17946**                      CHANGED SEARCH STATEMENT IN PARA-1258  **         
T17946**                      TO SEARCH THROUGH ALL WS-DFA-RECV-DATA.**         
      **                      ALSO UPDATED DV-AMT-CONTRCT-DEFR.      **         
T18219**  10/26/98  AAT       ADDED UPDATE TO CSS_STA_SUMMARY        **         
T18394**  11/05/98  AAT       DELETED UPDATE OF ACCOUNT_NO BECAUSE   **         
      **                      CAUSING A PROBLEM IN BINDING           **         
T18452**  11/12/98  AAT       DELETED UPDATE OF ACCOUNT_NO AND       **         
      **                      AGREEMENTE_NO FROM UPDATE OF           **         
      **                      CSS_STA_SUMMARY.                       **         
T18694**  12/14/98  RGB       CODE CHANGED TO NOT SET WS-PULL-BILL   **         
T18694**                      WHEN ACCT HAS MAXIMUM WNA  FACTRO      **         
T18741**  01/07/99  SHF       IF STA IS COMPLETE THEN THE STA FLAG   **         
      **                      ON CSS_ACCOUNT SHOULD NOT BE ACTIVE.   **         
T18724**  01/11/99  RGB       CODE CHANGED TO PREVENT WQ NON UTILITY **         
      **                      ACCT ELIGIBLE FOR FINAL BILL COMING OUT**         
      **                      ON UTILITY ACCTS                       **         
T18857**  01/12/99  KDF       DELETE YEAR END PROCESSING FOR PROJ.   **         
      **                      SHARE                                  **         
T19547**  03/30/99  ZB17046   CANCEL SHORT TERM ARRANGEMENTS ONLY    **         
T19547**                      FOR ACTIVE ACCOUNTS.                   **         
T19782**  04/21/99  KDF       CHANGE SELECT CRITERIA TO ELIMINATE -911*         
T20380**  07/28/99  KDF       SUB-BILLED-OK VALUE OF B WAS ADDED     **         
T20182**  08/13/99  RDF       FOR FINAL ACCOUNT - LEAVE CODE-LPC-XMT **         
T20182**  08/13/99  RDF        ON ACCOUNT TABLE ALONG.               **         
T20512**  09/16/99  RDF       ONLY LOAD AT-ACCT-FINALED-DT WHEN      **         
T20512**                       FINAL BILLING.                        **         
T19929**  09/28/99  SHF       ADDED NEW COLUMN ACCT_XFER_FROM TO THE **         
      **                      INSERT FOR TABLE CSS_DFA_ACCT TABLE.   **         
T21287**  11/09/99  KDF       CHANE UPDATE SQL IN 8840-              **         
T21945**  03/31/00  SS82048   DELETE CODE USING CRED-COL OF CODES    **         
      **                      DATA PRESENT.                          **         
T22006**  05/04/00  MDJ       ADDED LOGIC TO UPDATE 2 NEW NON UTIL   **         
      **                      CREDIT HISTORY FIELDS.                 **         
T22140**  06/05/00  MDJ       IF MED CERT DO NOT DELETE ROWS T,U OR X**         
      **                      IF ROW E OR T CODE-MESSAGE-TYPE > 0 MOVE*         
      **                      ZEROES TO CODE-MESSAGE-TYPE.           **         
T22113**  10/11/00  VIJAY     CHANGED TO UPDATE TABLE CSS_SO_DNP_CANCEL         
      **                      WITH CODE 'B' IN TBL FLD SO_UPDT_ACTION_FL        
      **                      IN PARA 8955-UPDATE-CANCEL-DNP IF ROW             
      **                      EXISTS ALREADY.                                   
T23501**  02/14/01   SS82048  DELINQUENCY TABLE CHANGES TO SUPPORT   **         
      **                      MULTI-COMPANY AND PSNC CONVERSION      **         
T23235**  06/05/01   VIJAY    MCR 57 - CHANGES FOR PSNC              **         
T24367**  09/20/01   SFH      ADDED LOGIC TO CANCEL NOT.             **         
T25090**  09/20/01   SFH      ADDED NULL INDICATORS TO DATES THAT    **         
T25090**                      UPDATE CSS_STA_SUMMARY.                **         
T23947**  11/15/01   COVANSYS BILL-TYPE SHOULD BE PROPERLY POPULATED **         
T23947**             CHENNAI  ON A CANCEL/REBILL WHEN IT IS BILL     **         
T23947**                      IMMEDIATE                              **         
C25250**  12/14/01   MDJ      IF ON MEDICAL CERTIFICATE, MESSAGE/NOTICE         
      **                      NUMBER SHOULD BE UPDATED ON CSS_CRED_COLL.        
C26229**  04/05/02   AS82045  IF AN ACCOUNT IS SETUP ON EPP AT THE OPEN         
C26229**                      OF THE BILL CYCLE WITH A NEXT BILL OPTION         
C26229**                      DATE PYMT START WOULD SHOW UP THE NEXT            
C26229**                      REVENUE MONTH. IF THIS ACCOUNT IS BILLED          
C26229**                      BETWEEN THE CLOSE OF THE BILL CYCLE THERE         
C26229**                      WOULD BE A MISMATCH IN THE DATE PYMT STRT         
C26229**                      AND THE BILLING REVENUE MONTH. BILL PRINT         
C26229**                      TREATS IT AS A NON EPP BILL. FIXING THE           
C26229**                      DATE PYMT STRT TO BE THE SAME AS BILLING          
C26229**                      REVENUE MONTH IN THIS CASE.                       
T27284**  11/28/02   COVANSYS DO NOT GENERATE WQ FOR NON-UTILITY     **         
T27284**             CHENNAI  ACCTS ELIGIBLE FOR FINAL BILL AND OF   **         
T27284**                      TYPE PROJECT SHARE & CONTRACT.         **         
T28126**  03/05/03   GS90520  FOR MASTERS IF CONSOLIDATED BILLING    **         
T28126**                      DO NOT RESET LPC_XMT                   **         
T28788**  06/30/03   MDJ      UPDATE IVR-EXEMPT-CD ON CSS_ACCOUNT.   **         
T30467**  05/05/04   VIJAY    UPDATE WITH BILLED REVENUE MONTH IN    **         
      **                      CSS_DFA_ACCT.                                     
T29815**  07/12/04   SV82012  EPP OFFERS AT ANNIVERSARY WHEN EPP     **         
T29815**                      ACCOUNT BALANCE LE 0.00.               **         
T31345**  08/12/04   SV82012  DO NOT OFFER A PLAN OPTION IF CREDIT   **         
T31345**                      BALANCE IS GT PROJECTED COST.          **         
C26296**  12/16/04   WR19680  ADDED CODE TO CHECK THE AUTO DNP AND **           
C26296**                      RETURN CHECK INDICATOR TO SEE IF ROWS **          
C26296**                      NEED TO BE ADDED/DELETED OR MODIFIED **           
C26296**                      ON CSS_ACCT_ATTRIBUTE TABLE. **                   
T32482**  03/21/05   VIJAY    UPDATE STATUS_CHANGE_DT IN CSS_CONTRACT.          
T32480*   05/26/05  JC91900   INSERT DETAILS TO CSS_DNP_NOT_WORKED   **         
T32480*                       TABLE WHEN DNP GOT CANCELLED.          **         
T33147*   08/24/05  SS82048   MOVE SPACES TO CODE-DNP-TYPE.          **         
      *                       NEW OPEN CLIENT RPC WILL UPDATE        **         
      *                       CODE-DNP-TYPE FROM SYBASE.             **         
T34800*   01/11/07  DM94438   EPP ANNIVERSARY PAYMENT OPTION ERRORS  **         
T34800*                       WERE FIXED. ADDED THE 'T' (TARIFF CHG) **         
T34800*                       IN THE WHERE CLAUSE IN PARA            **         
T34800*                       7070-GET-PREV-BUD-AMT.**                          
C36124*   08/08/07  VP94820   MST/SUB TRANSFERS ISSUE WAS FIXED.     **         
C36303*   12/26/07  VP94820   RESETTING 'WS-CODE-CONTRACT' AFTER     **         
C36303*                       DELETING THE CONTRACTS SUMMARY ROW.    **         
C35326*   01/22/08  VP94820   UPDATING AR_CNTL FOR INACTIVE PJS.     **         
C30169**  06/16/08  COVANSYS  WRITE OFF RECOVERY PROJECT CML 30169.  **         
      **            CHENNAI   INCLUDED CODE FOR UPDATE,INSERT ON     **         
      **                      CSS_FIN_WO_ACTION AND CSS_FIN_WO_COLLECT*         
C30169**  10/20/08  CVNS      DELETE THE CODE THAT HAVE REFERENCE    ** 02910001
C30169**            CHENNAI   TO CSS_FINAL_WO FIELD WHICH ARE DELETED** 02920001
C30169**                      FROM THE DB2.                          ** 02930001
A35920**  12/08/08  VP94820   UPDATE ONLY CSS_DFA_RECVBLE FOR REBILLS** 02910001
P00047**  01/30/08  VP94820   EPP TO BBP CHANGES.                    **         
P00097**  01/26/09  VP94820   INCREASE NUMBER OF ACTIVE DFA/CNT AND  **         
P00097**                      FORECASTED CREDIT ACTIONS  ALLOWED ON  **         
P00097**                      AN ACCOUNT TO 50.                      **         
A35920**  03/31/09  VP94820   FIX FOR PRODUCTION ISSUE.              ** 02910001
P00128**  03/30/09  VP94820   STOP BILLING PAID SONP'S FOR SEB.      **         
APP869**  05/21/09   SK42147  FOR PAYMENT_PRIORTY > 49 AND ITEM_ID 0 **         
APP869*                       AMT_TRAN_BALANCE AND TOT_SUM_UNBILLED  **         
APP869*                       SHOULD ALWAYS BE ZERO.                 **         
A01050**  05/28/09  DM94438   BBP PAYMENT OPTIONS ARE INCORRECT DUE  **         
A01050*                       TO THE SIGN GETTING DROPPED IN         **         
A01050*                       1285-CALC-EPP-AMT PARA. FIXING THE SAME**         
A01355*   06/19/09  MJ13662   IF OLD CREDIT GROUP OR OLD CREDIT GROUP**         
A01355*                       EFFECTIVE DATE CHANGES, INSERT MAINT   **         
A01355*                       TRANS HISTORY.                         **         
A00755**  08/27/09  DM94438   REMOVE UPDATES TO STA TABLES AS THEY   **         
A00755**                      ARE NOT PROCESSED IN BILLING AND ALSO  **         
A00755**                      REMOVE REFERENCES TO TBRVCACTTABLE     **         
A00755**                      AND REMOVE REFERENCES TO COLUMNS OF    **         
A00755**                      FINAL_WO TABLE,FW-INVEST-COMMENT AND   **         
A00755**                      SECOND-INVEST-COMMENT                  **         
A01016**  07/14/09  VP94820   DNP CANCEL LOGIC MOVED TO CSR02336     **         
P00166**  08/17/09  AW41078   ADD UNIQUE ID TO WS-FIODB07. ALSO ADDED**         
P00166**                      MISSING CREDIT LETTER IND              **         
P00166**  01/11/10  AW41078   ADD PROCESS FLAG TO WS-FIODB07.        **         
A01703**  02/16/10  VP94820   REDUCE LPC EXEMPTIONS FOR MST ACCOUNTS **         
A01703**                      WHEN MST&SUB ACCOUNT BILLING SAME DAY  **         
A02278**  05/25/10  VV94890   INITIALIZE CZ-AUTO-DEP-AM.             **         
P00399**  08/16/10  MJ13662   REMOVE DISCONNECT HISTORY FROM COMMENTS**         
P00399**                      WHEN CREDIT GROUP CHANGES.             **         
P00399**                      SHOW THE ARREARS HISTORY THAT WAS USED **         
P00399**                      TO MAKE THE CREDIT GROUP CHANGE DECISION*         
P00399**                      BASED ON DELINQUENCY VALUE.            **         
A01433**  09/30/10  VP94820   DISPLAY BBP OPTION 2 WHEN ACCT BAL <   **         
A01433**                      BBP AMOUNT.                            **         
A02036**  10/13/10  VP94820   INITIALIZE CL-DATE-NOTICE-DUE.         **         
A03175*   03/23/11  VIJAY     CHANGE CREDIT GROUP MOVEMENT MNT ROW   **         
A03175*   ACT003              APPEARS ON THE ACCOUNT DETAILS TRANS-  **         
A03175*                       HIST ONLY.                             **         
P00506**  05/02/11  VV94890   SEB - DISPLAY BBP OPTION 2 LIKE CSR    **         
P00453**  05/26/11  AA97148   1. ADDED LOGIC TO UPDATE RECORDS INTO  **         
P00453**                         CSS_PREPAY_HIST TABLE.              **         
P00453**                      2. ADDED WITH UR TO AVOID -911.        **         
P00453**                      3. ADDED QUERYNO.                      **         
P00471**  07/27/11  SP95538   DELETE THE ENTRIES FROM CSS_ACCT_ATTRIB**         
P00471**                      TABLE FOR DPP DROP.                    **         
VKSACT**  09/08/11  VIJAY     HISTORY ROWS CREATION FOR EVENT PROCESS.*         
VKSACT**  P00496              THIS INCLUDES CURTAILMENT, MAINTENANCE **         
VKSACT**                      AND STANDBY EVENTS.                    **         
P00453**  11/15/11  VP43661   FOR PRP 1ST BILLS POPULATE PRP TRAN BAL**         
P00453**                      TO PLAN_ACCT_BAL_AM ON CSS_PREPAY_HIST **         
P00599**  12/14/12  SP95538   REMOVE CSS_CRED_COLL UPDATE/INSERT/DELETE         
P00599**                      ,DPP DROP EXEMPTION AND HISTORY UPDATE **         
P00599**                      LOGIC.                                 **         
P00599**  08/24/12  AA97148   REMOVE REFERENCES TO CSS_FIN_WO_ACTION,**         
P00599**                      CSS_FIN_WO_COLL AND CSS_FINAL_WO AS PART*         
P00599**                      OF CREDIT SIMPLIFICATION PROJECT.      **         
ACT091**  06/26/13  VIJAY     INCLUDE ALL ICs IN CUMULATING BBP MONI- *         
ACT091**  A04527              ES.When there is a blank IC in between,**         
ACT091**                      it was not considering next available IC.         
ACT091**                      Example, in ICs EGU,if G is removed, U is         
ACT091**                      not included.                                     
ACT107**  07/16/13  VIJAY     REMOVE CODE_ACCT_STAT update in 8000-   *         
ACT107**  A04527              PARAGRAPH.                             **         
ACT117**  07/25/13  VIJAY     DELETE ONE TIME PJS ROWS FROM AR WHEN IT*         
ACT117**  A04527              IS PAID OFF FULL.                      **         
ACT117**  08/02/13  VIJAY     ADDED PJS CODE BUG IS FIXED.            *         
ACT037**  06/27/14  VIJAY     WRITE WQ DETAILS INTO WQ WORKING STORA- *         
ACT037**  A04860              AGE WHICH IS SUBSEQUENTLY WRITTEN BY    *         
ACT037**                      PCSCA100.                               *         
ACT009**  12/31/14  VIJAY     UPDATE DFA_RECVBLE DATA.                *         
ACT009**  A05136                                                      *         
A05154**  05/05/15  RF10596   REMOVE UNUSED CODE                      *         
I01959**  09/25/15  SS45239   SOLAR/RENEWABLE NEM 2.0                 *         
ACT153**  05/09/16  VIJAY     DO NOT ADJUST PBI MONEY                 *         
ACT153**  A05460                                                      *         
ACT278**  11/03/16  TP7R341   REMOVE UNWANTED COLUMNS                 *         
ACT278**   A05460                                                     *         
ACT342**  11/11/16  VIJAY     INITIALIZE INDEX TO SUPPORT MFES.       *         
ACT342**   A05460             (WS-BILLING-INDX)                       *         
      *****************************************************************         
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA113'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR SCSCA113 STARTS HERE'.            
      /                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-PYMT-LVL-CHECK               PIC S9(04) COMP.         
               88 NSF         VALUE +0019.                              
               88 NSA         VALUE +0020.                              
               88 NSN         VALUE +0029.                              
               88 LPC         VALUE +0030.                              
               88 LPN         VALUE +0039.                              
               88 UTE         VALUE +0040.                              
               88 UTG         VALUE +0045.                              
               88 BUD         VALUE +0050.                              
               88 CCC         VALUE +0060.                              
               88 DFA         VALUE +0090.                              
               88 CIA         VALUE +0070.                              
               88 DEP         VALUE +0080.                              
               88 CNT         VALUE +0100.                              
               88 RVC         VALUE +0110.                              
               88 PJS         VALUE +0129.                              
COB305     05 WS-HOLD-TRAN-BALANCE        PIC S9(07)V99 COMP-3 VALUE 0.        
COB305     05 WS-HOLD-UTIL-BALANCE        PIC S9(07)V99 COMP-3 VALUE 0.        
           05  WS-NULL-IND-1               PIC S9(04) COMP.             
           05  WS-NULL-IND-2               PIC S9(04) COMP.             
           05  WS-NULL-IND-3               PIC S9(04) COMP.             
           05  WS-NULL-IND-4               PIC S9(04) COMP.             
           05  WS-NULL-IND-5               PIC S9(04) COMP.             
           05  WS-NULL-IND-6               PIC S9(04) COMP.             
           05  WS-NULL-IND-7               PIC S9(04) COMP.             
           05  WS-NULL-IND-8               PIC S9(04) COMP.             
           05  WS-NULL-IND-9               PIC S9(04) COMP.             
           05  WS-NULL-IND-10              PIC S9(04) COMP.             
           05  WS-NULL-IND-11              PIC S9(04) COMP.             
           05  WS-NULL-IND-12              PIC S9(04) COMP.             
           05  WS-NULL-IND-13              PIC S9(04) COMP.             
           05  WS-NULL-IND-14              PIC S9(04) COMP.             
PCR408     05  WS-NULL-IND-15              PIC S9(04) COMP.             
T17277     05  WS-NULL-IND-16              PIC S9(04) COMP.             
T17931     05  WS-NULL-IND-17              PIC S9(04) COMP.             
C30169     05  WS-NULL-IND-18              PIC S9(04) COMP.             
T29815     05  WS-EPP-PROJ-COST            PIC S9(09)V99.               
T29815     05  WS-EPP-AMT                  PIC S9(09)V99.               
T29815     05  WS-EPP-ESTIMATE             PIC S9(09)V99.               
T29815     05  WS-AMT-MO-PYMT-BRKDWN.                                   
T29815         10  WS-AMT-MO-PMT-DLLR      PIC S9(9).                   
T29815         10  WS-AMT-MO-PMT-CNTS      PIC V99.                     
COB305     05 WS-EPP-FINAL-TOTAL-WBAL        PIC S9(09) COMP-3 VALUE 0.         
           05  WS-COMPANY-IN-TABLE         PIC X(01).                   
T11939     05  WS-PREV-SUB-ACCT-BLLD       PIC X(01) VALUE SPACES.      
           05  WS-START-POS                PIC S9(04) COMP.             
           05  WS-AC-FOUND                 PIC X(1).                    
               88  WS-HAS-AC               VALUE 'Y'.                   
T12721     05  WS-VALID-AC-FOUND           PIC X(1).                    
T12721         88  WS-HAS-VALID-AC         VALUE 'Y'.                   
P00399     05  WS-VARIABLE-ID              PIC X(20).                   
COB305     05 WS-VARIABLE-VALUE        PIC S9(4)V9(5) COMP-3 VALUE 0.       
COB305     05 WS-REVENUE-MONTH        PIC S9(6) COMP-3 VALUE 0.                
           05  WS-REVENUE-MONTH-X      PIC X(6) VALUE SPACES.           
           05  WS-REVENUE-MONTH-NULL   PIC S9(4) COMP.                  
T17335     05  WS-REVENUE-MONTH-HOLD   PIC S9(6) VALUE ZERO.            
T17335     05  WS-REVENUE-MONTH-HOLD2  REDEFINES                        
T17335         WS-REVENUE-MONTH-HOLD.                                   
T17335         10  WS-H2-CCYY     PIC X(04).                            
T17335         10  WS-H2-MM       PIC X(02).                            
T17335     05  WS-REVENUE-MONTH-CONSTRCT.                               
T17335         10  WS-RM-CONSTRCT-YR   PIC 9(04) VALUE ZERO.            
T17335         10  FILLER              PIC X(01) VALUE '-'.             
T17335         10  WS-RM-CONSTRCT-MO   PIC 9(02) VALUE ZERO.            
T17335         10  FILLER              PIC X(01) VALUE '-'.             
T17335         10  WS-RM-CONSTRCT-DY   PIC 9(02) VALUE 1.               
T17335     05  WS-BU-DPS-TEMP          PIC X(10) VALUE ZERO.            
C26229     05  WS-BH-REV-MTH           PIC 9(06) VALUE ZEROS.           
           05  WS-ANNIVERSARY-DATE.                                     
               10  WS-AD-YEAR          PIC X(04) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE SPACES.          
               10  WS-AD-MONTH         PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE SPACES.          
               10  WS-AD-DAY           PIC X(02) VALUE SPACES.          
           05  WS-AD-MONTH-X           PIC X(02) VALUE SPACES.          
           05  WS-AD-MONTH-RED                                          
                  REDEFINES WS-AD-MONTH-X PIC 9(02).                    
                                                                        
           05  WS-AD-YEAR-X            PIC X(04) VALUE SPACES.          
           05  WS-AD-YEAR-RED                                           
                  REDEFINES WS-AD-YEAR-X  PIC 9(04).                    
                                                                        
P00399     05  WS-MAX-MONTH            PIC S9(02) COMP VALUE 0.         
           05  WS-YEAR-MONTH1.                                          
               10 WS-YEAR1             PIC 9(04)  VALUE ZERO.           
               10 WS-MONTH1            PIC 9(02)  VALUE ZERO.           
                                                                        
           05  WS-YEAR-MONTH2.                                          
               10 WS-YEAR2             PIC 9(04)  VALUE ZERO.           
               10 WS-MONTH2            PIC 9(02)  VALUE ZERO.           
C26229     05  WS-YEAR-MONTH3.                                          
C26229         10 WS-YEAR3             PIC 9(04)  VALUE ZERO.           
C26229         10 WS-MONTH3            PIC 9(02)  VALUE ZERO.           
C26229     05  WS-YEAR-MONTH3-NUM      PIC 9(06)  VALUE ZERO.           
T12094     05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
T12094     05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
T16413     05  WS-EPP-DRP-AR-HLD-INDX  PIC S9(04) COMP VALUE 1.         
C26296     05  WS-ATTRIBUTE-VALUE-TX   PIC X(22)  VALUE SPACES.         
A01355     05  WS-TRAN-APPL-NO         PIC S9(04) COMP VALUE ZERO.      
COB305     05 WS-AMT-MO-PYMT-PREV        PIC S9(09)V99 COMP-3 VALUE 0.          
                                                                        
P00399 01 WS-SWITCHES.                                                  
P00399     05  WS-DELINQ-WORK-AREA         PIC X(1) VALUE '0'.          
P00399         88  DW-NOT-LOADED                    VALUE '0'.          
P00399         88  DW-LOADED                        VALUE '1'.          
P00399 01 WS-DELINQ-VALUES.                                             
P00399     05  WS-RESIDENT-MONTHS          PIC S9(04) COMP VALUE 0.     
P00399     05  WS-COMMER-MONTHS            PIC S9(04) COMP VALUE 0.     
P00399     05  WS-INDUST-MONTHS            PIC S9(04) COMP VALUE 0.     
P00399     05  WS-DAY-NU-FBPAID            PIC S9(04) COMP VALUE 0.     
P00399 01  WS-DELINQUENCY-VALUES-TABLE.                                 
P00399     05  WS-DELINQ-COMPANY-ENTRY-TB                               
P00399         OCCURS 5 TIMES                                           
P00399         INDEXED BY TB-CO-INDEX.                                  
P00399         10  WS-DELINQ-VALUE-ENTRY-TB                             
P00399             OCCURS 10 TIMES                                      
P00399             INDEXED BY TB-VAL-INDEX.                             
P00399             15  WS-DELINQ-COMPANY-TB  PIC X(02).                 
P00399             15  WS-DELINQ-CODE-TB     PIC X(20).                 
COB305             15 WS-DELINQ-VALUE-TB        PIC S9(4)V9(5) COMP-3 
COB305               VALUE 0.     
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                PIC X(8) VALUE 'SCSCA113'.   
T5832      05  WS-129                      PIC S9(04) COMP VALUE +129.  
TP6213     05  WS-90                       PIC S9(04) COMP VALUE +90.   
TP6213     05  WS-40                       PIC S9(04) COMP VALUE +40.   
TP6213     05  WS-45                       PIC S9(04) COMP VALUE +45.   
TP6213     05  WS-50                       PIC S9(04) COMP VALUE +50.   
TP6213     05  WS-100                      PIC S9(04) COMP VALUE +100.  
           05  WS-INACTIVE                 PIC X(01)  VALUE 'I'.        
ACT117     05  WS-ONE-TIME-CONTRIBUTION    PIC X(01)  VALUE 'O'.        
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-YES                      PIC X(01)  VALUE 'Y'.        
T11939     05  WS-NO                       PIC X(01)  VALUE 'N'.        
           05  WS-FIA                      PIC X(01)  VALUE 'F'.        
           05  WS-PGRMNAME                 PIC X(08)  VALUE 'SCSCA113'. 
T14428     05  WS-PULL-BILL                PIC X(1)   VALUE 'X'.        
           05  WS-NORMAL                   PIC X(1)   VALUE 'A'.        
           05  WS-CODE-USED                PIC X(1)   VALUE 'A'.        
           05  WS-SIMPLE-INTEREST          PIC X(1)   VALUE 'C'.        
           05  WS-INSERT                   PIC X(1)   VALUE 'I'.        
           05  WS-UPDATE                   PIC X(1)   VALUE 'U'.        
           05  WS-DELETE                   PIC X(1)   VALUE 'D'.        
           05  WS-BUDGET-OFFER             PIC X(1)   VALUE 'B'.        
           05  WS-DPP                      PIC X(1)   VALUE 'B'.        
TP7965     05  WS-DFA                      PIC X(1)   VALUE 'A'.        
           05  WS-SUB                      PIC X(1)   VALUE 'S'.        
           05  WS-CUST-USAGE-LIT           PIC X(01)  VALUE 'C'.        
T3019      05  WS-CHG-REASON-LIT           PIC X(01)  VALUE 'T'.        
           05  WS-EPP-REMOVE-MSG           PIC X(30)                    
P00047            VALUE 'AUTOMATICALLY DROPPED FROM BBP'.               
PCR233     05  WS-CURRENT                  PIC X(01)  VALUE 'C'.        
P00399     05  WS-DELINQ-COMPANY           PIC X(02).                   
P00399     05  WS-CURRENT-COMPANY          PIC X(02) VALUE SPACES.      
PCR233     05  WS-REGULAR-BILL             PIC X(01)  VALUE 'A'.        
T14446     05  WS-REBILL-ASAP              PIC X(1) VALUE 'A'.          
T14446     05  WS-REBILL-NEXT-REGULAR      PIC X(1) VALUE 'B'.          
T14446     05  WS-REBILL-COMPLETE          PIC X(1) VALUE 'C'.          
T13451     05  WS-INSTALLMENT-CNTRACT      PIC X(01)  VALUE 'C'.        
T17410     05  WS-ONE-TIME-CHARGE          PIC X(01)  VALUE 'A'.        
T5502      05  WS-MASTER                   PIC X(01)  VALUE 'M'.        
T5502      05  WS-BILLED                   PIC X(01)  VALUE 'I'.        
T5502      05  WS-ACTIVE                   PIC X(01)  VALUE 'A'.        
T10723     05  WS-FINAL-AT                 PIC X(01)  VALUE 'B'.        
T11939     05  WS-TRANSFER                 PIC X(01)  VALUE 'T'.        
T11939     05  WS-SUSPENDED                PIC X(01)  VALUE 'S'.        
T20380     05  WS-BYPASSED                 PIC X(01)  VALUE 'B'.        
T11939     05  WS-OFF-CYCLE                PIC X(01)  VALUE 'O'.        
T12094     05  WS-CODE-APPLIES             PIC X(01)  VALUE 'A'.        
T17335     05  WS-DAY-ONE                  PIC X(02)  VALUE '01'.       
T24367     05  WS-PSNC                     PIC X(02)  VALUE '26'.       
T24367     05  WS-SCEG                     PIC X(02)  VALUE '01'.       
A01355     05  WS-CRED-GRP-MAINT-DESC-SEB.                              
A01355         10  FILLER                   PIC X(40)                   
A01355             VALUE 'CREDIT GROUP CHANGED BY SYSTEM BASED ON '.    
A01355         10  FILLER                   PIC X(11)                   
A01355             VALUE 'HISTORIES: '.                                 
A01355         10  FILLER                   PIC X(12)                   
A01355             VALUE '            '.                                
A01355         10  FILLER                   PIC X(09)                   
A01355             VALUE 'ARREARS: '.                                   
A01355         10  WS-ARREARS-HIST-SEB      PIC X(12).                  
A01355         10  FILLER                   PIC X(09)                   
A01355             VALUE ' NORMAL: '.                                   
A01355         10  WS-DISCONNECT-HIST       PIC X(12).                  
A01355         10  FILLER                   PIC X(21)                   
A01355             VALUE '                     '.                       
A01355         10  FILLER                   PIC X(13)                   
A01355             VALUE 'EXCEPTIONAL: '.                               
A01355         10  WS-DISC-EXCEPTN-HIST     PIC X(12).                  
A01355     05  WS-CRED-GRP-MAINT-DESC.                                  
A01355         10  FILLER                   PIC X(40)                   
A01355             VALUE 'CREDIT GROUP CHANGED BY SYSTEM BASED ON '.    
A01355         10  FILLER                   PIC X(09)                   
A01355             VALUE 'HISTORY: '.                                   
A01355         10  FILLER                   PIC X(14)                   
A01355             VALUE '              '.                              
A01355         10  FILLER                   PIC X(09)                   
A01355             VALUE 'ARREARS: '.                                   
A01355         10  WS-ARREARS-HIST          PIC X(24).                  
A01355     05  WS-CRED-GROUP-DESC           PIC X(15)  VALUE            
A01355          'CREDIT GROUP   '.                                      
A01355     05  WS-EFFECT-DT-DESC            PIC X(15)  VALUE            
A01355         'EFFECTIVE DT   '.                                       
       01  WS-AR-CNTRL-SUMMARY-LIST.                                    
           05  WS-AR-CNTRL-DTL-PPL-LIST.                                
               10  FILLER     PIC S9(4) COMP VALUE +0050.               
               10  FILLER     PIC S9(4) COMP VALUE +0060.               
               10  FILLER     PIC S9(4) COMP VALUE +0090.               
               10  FILLER     PIC S9(4) COMP VALUE +0070.               
               10  FILLER     PIC S9(4) COMP VALUE +0080.               
               10  FILLER     PIC S9(4) COMP VALUE +0100.               
               10  FILLER     PIC S9(4) COMP VALUE +0110.               
               10  FILLER     PIC S9(4) COMP VALUE +0129.               
           05  FILLER REDEFINES WS-AR-CNTRL-DTL-PPL-LIST.               
               10  WS-AR-CNTL-DTL-PPL                                   
T12802                OCCURS  8 TIMES                                   
                      INDEXED BY WS-PPL-INDX  PIC S9(4) COMP.           
           05  WS-DETAIL-FOUND-IND               PIC X(1).              
               88  WS-HAS-DETAIL                 VALUE '1'.             
               88  WS-HAS-NO-DETAIL              VALUE '0'.             
C35326     05  WS-PJS-STATUS-IND                 PIC X(1).              
C35326         88  WS-PJS-DELETED                VALUE 'Y'.             
C35326         88  WS-PJS-NOT-DELETED            VALUE 'N'.             
A35920     05  WS-DPP-RECVBLE                    PIC X(1).              
           05  WS-SUMMARY-AR.                                           
COB305         10 WS-ACCOUNT-NO-SUM        PIC S9(13)V COMP-3 VALUE 0. 
               10  WS-PYMT-PRIORITY-LVL-SUM      PIC S9(04)     COMP.   
               10  WS-ITEM-ID-SUM                PIC S9(09)     COMP.   
COB305         10 WS-AMT-AR-DAY-00-SUM        PIC S9(09)V99 COMP-3 
COB305           VALUE 0. 
COB305         10 WS-AMT-AR-DAY-30-SUM        PIC S9(09)V99 COMP-3 
COB305           VALUE 0. 
COB305         10 WS-AMT-AR-DAY-60-SUM        PIC S9(09)V99 COMP-3 
COB305           VALUE 0. 
COB305         10 WS-AMT-AR-DAY-90-SUM        PIC S9(09)V99 COMP-3 
COB305           VALUE 0. 
COB305         10 WS-AMT-UNUSED-CR-SUM        PIC S9(09)V99 COMP-3 
COB305           VALUE 0. 
COB305         10 WS-AMT-TRAN-BALANCE-SUM        PIC S9(09)V99 COMP-3 
COB305           VALUE 0. 
COB305         10 WS-TOT-SUMM-UNBILLED-SUM        PIC S9(09)V99 COMP-3 
COB305           VALUE 0. 
               10  WS-LAST-UPDATE-TS-SUM         PIC X(26).             
      /********************************************************                 
      *                                                       *                 
      *   WORKING STORAGE FOR BASIC WQ MESSAGE TEXT           *                 
      *                                                       *                 
      *********************************************************                 
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-MESSAGE-PATTERN.                                      
               10  WS-WQ-CATEGORY-ID       PIC S9(4) COMP.              
               10  WS-WQ-PRIORITY          PIC X(1).                    
               10  WS-WQ-ROUTE-CATEGORY    PIC X(1).                    
               10  WS-WQ-MESSAGE-LENGTH    PIC S9(4) COMP.              
               10  WS-WQ-MESSAGE-TEXT      PIC X(30).                   
           05  WS-DATABASE-EXCEPTION.                                   
PCR629         10  FILLER                  PIC S9(4) COMP VALUE +137.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +29.    
               10  FILLER                  PIC X(30) VALUE              
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-MISCELLANEOUS-MESSAGE.                                
PCR629         10  WS-MISC-CATEGORY        PIC S9(4) COMP VALUE +17.    
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  WS-MISC-MSG-LEN         PIC S9(4) COMP VALUE +60.    
               10  WS-MISC-MSG-TEXT        PIC X(60).                   
                                                                        
       COPY CWS0070B.                                                           
      /                                                                         
       COPY CWS00010.                                                           
      /                                                                         
       COPY CWS00303.                                                           
      / WORKING STORAGE REQUIRED FOR CPD0010S.                                  
            EXEC SQL                                                            
T12094         INCLUDE CWS00017                                                 
            END-EXEC.                                                           
      / WORKING STORAGE REQUIRED FOR CPD00312.                                  
            EXEC SQL                                                            
T12094         INCLUDE CWS10016                                                 
            END-EXEC.                                                           
      /                                                                         
       COPY CWS00061.                                                           
      /                                                                         
       COPY CWS00056.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBBGTPLN                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBACCT                                                 
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBOFFCYL                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBARCNTL                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBCRPROF                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBBLLHDR                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBBGTHST                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBCCCHRG                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBDFAACT                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBCNTRCT                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBPRJSHR                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBDFARCV                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBMSTSUB                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBBLLDET                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBREFUND                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
T11939           INCLUDE TBPENXFR                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
T12094           INCLUDE TBDELQ                                                 
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
T12094           INCLUDE TBHLDAY                                                
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
T12716           INCLUDE TBSODNPC                                               
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE SQLCA                                                  
            END-EXEC.                                                           
      *                                                                         
P00453***************************************************************** 01498100
P00453* CSS_PREPAY_HIST - PK                                          * 01498200
P00453***************************************************************** 01498300
P00453       EXEC SQL                                                   01498400
P00453           INCLUDE TBPREHST                                       01498500
P00453       END-EXEC.                                                  01498600
A01355***************************************************************** 07450000
A01355* CSS_MNT_TRANS_HIST     MH                                       07460000
A01355***************************************************************** 07470000
A01355*                                                                 07480000
A01355     EXEC SQL                                                     07490000
A01355        INCLUDE TBMNHIST                                          07500000
A01355     END-EXEC.                                                    07510000
A01355*                                                                 07520000
A01355***************************************************************** 07530000
A01355* CSS_MT_TRN_HST_DET     MI                                       07540000
A01355***************************************************************** 07550000
A01355*                                                                 07560000
A01355     EXEC SQL                                                     07570000
A01355        INCLUDE TBMNHDT                                           07580000
A01355     END-EXEC.                                                    07590000
A01355*                                                                 07600000
P00399     EXEC SQL                                                     
P00399        DECLARE DELINQUENCY-CSR CURSOR FOR                        
P00399           SELECT DELINQ_CD,                                      
P00399                  DELINQ_VALUE,                                   
P00399                  COMPANY_NO                                      
P00399             FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                   
P00399            WHERE DELINQ_CD IN ('RETAIN-RESIDENT-DEP',            
P00399                                 'RETAIN-COMMER-DEP',             
P00399                                 'RETAIN-INDUST-DEP',             
P00399                                 'DAY-NU-FBPAID')                 
P00399           ORDER BY COMPANY_NO,                                   
P00399                    DELINQ_VALUE                                  
P00399           FOR READ ONLY                                  
P00399                                                      
P00399     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01872000
MFA-TR*       DECLARE DELINQUENCY-CSR CURSOR FOR                        01873000
MFA-TR*          SELECT DELINQ_CD,                                      01874000
MFA-TR*                 DELINQ_VALUE,                                   01875000
MFA-TR*                 COMPANY_NO                                      01876000
MFA-TR*            FROM CSS_DELINQUENCY                                 01877000
MFA-TR*           WHERE DELINQ_CD IN ('RETAIN-RESIDENT-DEP',            01942000
MFA-TR*                                'RETAIN-COMMER-DEP',                     
MFA-TR*                                'RETAIN-INDUST-DEP',                     
MFA-TR*                                'DAY-NU-FBPAID')                         
MFA-TR*          ORDER BY COMPANY_NO,                                   01878000
MFA-TR*                   DELINQ_VALUE                                  01879000
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7010                                                   
MFA-TR*    END-EXEC.                                                    01880000
      /                                                                         
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR SCSCA113 ENDS HERE  '.            
HPCCDM*    EJECT                                                                
      /                                                                         
       LINKAGE SECTION.                                                 
       COPY CWS0024B.                                                           
      /                                                                         
       COPY CWS1000A.                                                           
T23501     EXEC SQL                                                             
T23501         INCLUDE CWS1000B                                                 
T23501     END-EXEC.                                                            
      /                                                                         
PCR233 COPY CWS00039.                                                           
PCR233/                                                                         
T5502 /***** DB07 FILE                                                          
T5502  01  WS-FIODB07.                                                  
COB305     05 WS-FDB07-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.      
T5502      05  WS-FDB07-PROCESS-CONTROL.                                
T5502          10  WS-ON-OFF-CYCLE-IND          PIC X(1).               
T5502              88  WS-OFF-CYCLE-FINAL        VALUE 'B'.             
T5502              88  WS-OFF-CYCLE-REBILL       VALUE 'O'.             
T5502              88  WS-ON-CYCLE-BILL          VALUE 'A'.             
T5502              88  WS-OFF-CYCLE-ACCT-TRANS   VALUE 'T'.             
T5502          10  WS-SINGLE-ITEM-BILL-IND      PIC X(1).               
T5502              88  WS-SINGLE-ITEM-BILL       VALUE 'S'.             
T5502          10  WS-MASTER-ACCOUNT-IND        PIC X(1).               
T5502              88  WS-CONS-BILL-MAST         VALUE 'M'.             
T5502              88  WS-ADDITIVE-MAST          VALUE 'A'.             
T5502          10  WS-REFUND-CONTROL-IND        PIC X(1).               
T5502              88  WS-PROCESS-REFUND         VALUE 'R'.             
T5502          10  WS-GUARANTEE-TRANSFER-IND    PIC X(1).               
T5502              88  WS-TRANSFER-GUARANTEE     VALUE 'E'.             
T5502              88  WS-TRANSFER-GUARANTOR     VALUE 'G'.             
T5502      05  WS-FDB07-NO-BILL-CYCLES          PIC S9(4) COMP.         
T5502      05  WS-FDB07-PYMT-PRIORITY-LVL       PIC S9(4) COMP.         
T5502      05  WS-FDB07-ITEM-ID                 PIC S9(9) COMP.         
P00166     05  WS-FDB07-CREDIT-LETTER-IND       PIC X(01).              
P00166     05  WS-FDB07-BARCODE-UNIQUE-ID       PIC X(09).              
P00166     05  WS-PROCESS-UNIQUE-ID-FL          PIC X(01) VALUE 'N'.    
P00166         88 WS-PROCESS-UNIQUE-ID                    VALUE 'Y'.    
P00166         88 WS-DO-NOT-PROCESS-UNIQUE-ID             VALUE 'N'.    
      /                                                                         
PCR526 01  WS-PART-NO                           PIC 9(2).               
      /                                                                         
       PROCEDURE DIVISION USING LS-PCSCA100-COMM-AREA                   
T5502                           WS-FIODB07                              
PCR526                          WS-PART-NO                              
T5502                           WS-PREMISE-PR                           
                                WS-ACCOUNT-AT                           
                                WS-CRED-COLL-CL                         
                                WS-BILLING-BI                           
                                WS-BILLING-BG                           
                                WS-AR-CNTRL-AC                          
                                WS-BUDGET-PLAN-BU                       
                                WS-CONNECT-CHRG-CC                      
                                WS-DFA-ACCT-DA                          
                                WS-CONTRACT-CT                          
                                WS-CREDIT-PROFILE-CZ                    
                                WS-PROJECT-SHARE-PJ                     
                                WS-FINAL-WO-FW                          
                                WS-SURETY-BOND-SB                       
                                WS-BILLING-WQ-ITEMS-WF                  
                                WS-DFA-RECV-DV                          
                                WS-REFUND-RN                            
PCR233                          WS-FCA00-BILL-CYCLES-RECORD             
T29815                          WS-12-MONTH-DATA-EPP                    
T29815                          WS-BANK-EFT-BE                          
T18219                          WS-SHORT-TERM-AGMT-SA                   
C30169                          WS-FINAL-WO-ACTN-KD                     
P00097                          WS-FINAL-WO-COLL-IZ                     
P00097                          WS-CWS1000B-MAX-TBL-LIMITS              
P00453                          WS-PREPAY-HIST-PK                       
VKSACT                          WS-INTERRUPT-NZ.                        

SCA006        SET WS-BILLING-INDX TO 1.
      ******************************************************************        
      *                                                                *        
      *   0000-MAINLINE.                                               *        
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *        
      *                                                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
P00097     INITIALIZE WS-SQL-ERROR-TXT-WQ.                              
           INITIALIZE DCLCSS-BUDGET-PLAN.                               
           MOVE ZERO TO RETURN-CODE.                                    
           INITIALIZE WS-WORK-AREA.                                     
ACT342     SET WS-BILLING-INDX TO 1.                                    
C35326     MOVE SPACE TO WS-PJS-STATUS-IND.                             
           MOVE WS-CODES-DATA-PRESENT-AT TO WS-CODES-DATA-PRESENT       
P00399     IF DW-NOT-LOADED                                             
P00399        PERFORM 0110-LOAD-DELINQUENCY-TABLE   THRU 0110-EXIT      
P00399        SET DW-LOADED TO TRUE                                     
P00399     END-IF.                                                      
P00399     IF WS-COMPANY-NO-AT NOT EQUAL WS-CURRENT-COMPANY             
P00399         PERFORM 7300-LOAD-DELINQ-VALUES THRU 7300-EXIT           
P00399     END-IF.                                                      
      *                                                                         
ACT153*    IF WS-COGEN-AR-XFER-IND EQUAL 'Y'                                    
ACT153*       AND WS-XFER-TO-ASSIGNEE-ACCT  NOT EQUAL ZEROES                    
ACT153*       PERFORM VARYING WS-BILLING-INDX   FROM 1 BY 1                     
ACT153*                 UNTIL WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = 0            
ACT153*                    OR WS-BILLING-INDX > 30                              
ACT153*          IF WS-XFER-TO-ASSIGNEE-BG (WS-BILLING-INDX) EQUAL 'Y'          
ACT153*             PERFORM 1150-ADJUST-AR-CNTL THRU 1150-EXIT                  
ACT153*          END-IF                                                         
ACT153*       END-PERFORM                                                       
ACT153*    END-IF.                                                              
      *                                                                         
           PERFORM VARYING WS-AR-DATA-INDX FROM 1 BY 1                  
P00097       UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY                    
                OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZERO            
              PERFORM 1200-UPDATE-AR-CNTL-DTL THRU 1200-EXIT            
              IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 30 OR 39   
T12802         OR 40 OR 45 OR 19 OR 20 OR 29                            
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 1252-PROCESS-AR-DETAIL THRU 1252-EXIT          
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
P00506     IF ( WS-TOTAL-AR-BALANCE-AT < 0  OR                          
A01433          WS-TOTAL-AR-BALANCE-AT < WS-AMT-MO-PYMT-PREV )          
A01433        IF WS-ACCOUNT-EPP(1) = WS-ACCOUNT-NO-AT                   
T29815          INITIALIZE DCLCSS-BUDGET-PLAN                           
T29815                     DCLCSS-BUDGET-HIST                           
T29815          MOVE WS-ACCOUNT-NO-AT           TO BU-ACCOUNT-NO        
T29815                                             BH-ACCOUNT-NO        
T29815          MOVE 50                         TO BU-PYMT-PRIORITY-LVL 
T29815                                             BH-PYMT-PRIORITY-LVL 
T29815          MOVE 1                          TO BU-BP-ITEM-ID        
T29815                                             BH-ITEM-ID           
T29815          PERFORM 1280-GET-PROJECTED-COST THRU 1280-EXIT          
T29815          PERFORM 1285-CALC-EPP-AMT       THRU 1285-EXIT          
T29815       END-IF                                                     
T29815     END-IF.                                                      
T29815*                                                                         
                                                                        
           PERFORM 1220-UPDATE-AR-CNTL-SUMM THRU 1220-EXIT.             
      *                                                                         
P00599     PERFORM 1230-UPDATE-CRED-HIST    THRU 1230-EXIT.             
      *                                                                         
           PERFORM 1500-REFUNDS  THRU 1500-EXIT                         
              VARYING WS-RN-INDX FROM 1 BY 1                            
T12261          UNTIL WS-RN-INDX > 20                                   
                   OR WS-ACCOUNT-NO-RN (WS-RN-INDX) = ZERO.             
      *                                                                         
           IF WS-MST-SUB-ACCT-IND-AT = WS-SUB                           
T11939       AND NOT WS-OFF-CYCLE-REBILL                                
              MOVE WS-ACCOUNT-NO-AT TO MU-SUB-ACCT-NO                   
T11939        PERFORM 7000-SELECT-MSTSUB-ACCT THRU 7000-EXIT            
T11939        EVALUATE MU-SUB-ACCT-BLLD-OK                              
T20380           WHEN WS-BYPASSED                                       
T20380              MOVE WS-YES TO MU-SUB-ACCT-BLLD-OK                  
T11939           WHEN WS-SUSPENDED                                      
T11939              MOVE WS-NO TO MU-SUB-ACCT-BLLD-OK                   
T11939           WHEN WS-NO                                             
T11939              MOVE WS-YES TO MU-SUB-ACCT-BLLD-OK                  
T11939           WHEN WS-YES                                            
C36124              MOVE WS-YES TO MU-SUB-ACCT-BLLD-OK                  
T16491           WHEN WS-TRANSFER                                       
KDFKDF              MOVE WS-PREMISE-NO-AT TO XP-PREMISE-NO              
T11939              MOVE WS-TRANSFER TO MU-SUB-ACCT-BLLD-OK             
T11939              MOVE MU-SUB-ACCT-NO TO XP-ACCT-XFER-FROM            
T11939              MOVE MU-MST-ACCT-NO TO XP-ACCT-XFER-TO              
T11939              PERFORM 8810-UPDATE-PENDING-XFER THRU 8810-EXIT     
T11939        END-EVALUATE                                              
              PERFORM 8800-UPDATE-MSTSUB-ACCT THRU 8800-EXIT            
           END-IF.                                                      
      *                                                                         
PCR526     IF WS-PART-NO = 9                                            
T11939        MOVE WS-ACCOUNT-NO-AT TO XP-ACCT-XFER-TO                  
T11939        PERFORM 8890-DELETE-PENDING-XFER THRU 8890-EXIT           
T11939     END-IF.                                                      
      *                                                                         
T11939     IF WS-MST-SUB-ACCT-IND-AT = WS-MASTER                        
T11939      AND WS-ON-OFF-CYCLE-IND NOT = SPACES                        
T11939        MOVE WS-ACCOUNT-NO-AT    TO MU-MST-ACCT-NO                
T11939        MOVE WS-SUSPENDED        TO MU-SUB-ACCT-BLLD-OK           
T11939        MOVE WS-NO               TO WS-PREV-SUB-ACCT-BLLD         
T20380        PERFORM 8840-UPDATE-IF-ACTIVE     THRU 8840-EXIT          
T20380        MOVE WS-NO               TO MU-SUB-ACCT-BLLD-OK           
T20380        MOVE WS-BYPASSED         TO WS-PREV-SUB-ACCT-BLLD         
T20380        PERFORM 8840-UPDATE-IF-ACTIVE THRU 8840-EXIT              
T11939        MOVE WS-NO               TO MU-SUB-ACCT-BLLD-OK           
T11939        MOVE WS-YES              TO WS-PREV-SUB-ACCT-BLLD         
T11939        PERFORM 8830-UPDATE-SUB-ACCT-BLLD THRU 8830-EXIT          
T11939        PERFORM 8820-UPDATE-PENDING-XFER THRU 8820-EXIT           
T11939        MOVE WS-YES              TO MU-SUB-ACCT-BLLD-OK           
T11939        MOVE WS-TRANSFER         TO WS-PREV-SUB-ACCT-BLLD         
T20380        PERFORM 8840-UPDATE-IF-ACTIVE THRU 8840-EXIT              
T11939        IF SQLCODE = SUCCESSFUL-CALL                              
T11939           MOVE WS-ACCOUNT-NO-AT       TO OC-ACCOUNT-NO           
T11939           MOVE WS-CUSTOMER-NO-AT      TO OC-CUSTOMER-NO          
T11939           MOVE WS-MASTER              TO OC-CODE-BILL-OFF-CYCL   
T11939           PERFORM 8860-INSERT-OFF-CYCLE  THRU 8860-EXIT          
T11939        END-IF                                                    
T12417        MOVE WS-NO               TO WS-MST-OVRRD-BLL-IND-AT       
T11939     END-IF.                                                      
      *                                                                         
T5502      IF WS-UPDATE-ACTION-IND-BI NOT EQUAL SPACES                  
P0097         AND WS-ACCOUNT-NO-BI > 0                                  
T5502         PERFORM 1240-UPDATE-BILL-HEADER THRU 1240-EXIT            
T5502         IF WS-UPDATE-ACTION-IND-BI EQUAL WS-INSERT                
T5502            PERFORM 8400-INSERT-BILLING-HDR THRU 8400-EXIT         
T5502         ELSE                                                      
T5502            PERFORM 8410-UPDATE-BILLING-HDR THRU 8410-EXIT         
T5502         END-IF                                                    
T5502      END-IF.                                                      
      *                                                                         
      **  IF THIS IS THE CURRENT ACCOUNT AT THE PREMISE, AND IF                 
      **  THE BILL HEADER BEING BILLED/UPDATED IS THE CURRENT ONE               
      **  CREATE A NEW UNBILLED HEADER.                                         
T5837 **  IF THE MASTER IS BILLING ON CYCLE, CREATE BILL HOOK                   
T5502      IF WS-MST-SUB-ACCT-IND-AT = WS-MASTER                        
T5502         IF WS-ON-CYCLE-BILL AND WS-NEXT-BILL-NO-CALC > ZERO       
T5502            PERFORM 5800-CREATE-BILL-HEADER THRU 5800-EXIT         
T5502         END-IF                                                    
T5502      ELSE                                                         
T5502         IF WS-NEXT-BILL-NO-CALC > ZERO                            
T5502            PERFORM 5800-CREATE-BILL-HEADER THRU 5800-EXIT         
T5502         END-IF                                                    
T5502      END-IF.                                                      
      *                                                                         
T19547     IF WS-ACCOUNT-NO-SM NOT EQUAL ZEROS AND                      
T19547        WS-CODE-ACCT-STAT-AT = WS-ACTIVE                          
A00755        IF WS-CODE-DFA-STATUS-SM = 'C'                            
T18741           MOVE SPACE TO WS-CODE-STA-ACCT                         
T18741        END-IF                                                    
T18219     END-IF.                                                      
      *                                                                         
P00128     IF CSR-DATABASE                                              
T24367        IF WS-ON-OFF-CYCLE-IND = SPACES                           
T24367           NEXT SENTENCE                                          
T24367        ELSE                                                      
T12716           IF WS-CODE-PENDING-DNP = WS-CODE-APPLIES               
T12716              MOVE WS-ACCOUNT-NO-AT TO XK-ACCOUNT-NO              
T12716              MOVE 'B'           TO XK-SO-UPDT-ACTION-FL          
T12716              PERFORM 8950-INSERT-CANCEL-DNP THRU 8950-EXIT       
T22113              IF SQLCODE EQUAL ALREADY-EXISTS                     
T22113                 PERFORM 8955-UPDATE-CANCEL-DNP THRU 8955-EXIT    
T22113              END-IF                                              
T12716           END-IF                                                 
T24367        END-IF                                                    
P00128     END-IF.                                                      
                                                                        
           MOVE WS-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT-AT.      
T12094* CREATE A WORK QUEUE IF NON-UTILITY ACCOUNTS DO NOT HAVE ANY             
T12722* RECEIVABLES LEFT UNLESS THE ACCOUNT IS BEING FINAL BILLED               
T12722     IF WS-CODE-ACCT-STAT-AT NOT = WS-FINAL-AT                    
T12094        IF WS-MST-SUB-ACCT-IND-AT = WS-MASTER                     
T12094          OR (WS-CODE-UTL NOT = WS-CODE-APPLIES                   
T12094          AND WS-CODE-BUDGET NOT = WS-CODE-APPLIES                
T18724          AND  WS-CREDIT-GROUP-AT = 'D')                          
T12094           MOVE PROGRAM-NAME TO WS-NON-UTIL-PROG                  
T12094           PERFORM 6709A-NON-UTILITY-PROCESS THRU 6709A-EXIT      
T12722        END-IF                                                    
T12094     END-IF.                                                      
      *                                                                         
           PERFORM 1250-UPDATE-ACCOUNT THRU 1250-EXIT.                  
      *                                                                         
A01355     IF WS-OLD-CREDIT-GROUP  > SPACE                              
A01355         PERFORM 6510-MOVE-TRANS-HDR-DETAILS  THRU 6510-EXIT      
A01355         PERFORM 6550-MOVE-CR-TRAN-HIST       THRU 6550-EXIT      
A01355     END-IF.                                                      
                                                                        
           EXIT PROGRAM.                                                
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
P00399*****************************************************************         
P00399*0110-LOAD-DELINQUENCY-TABLE.                                   *         
P00399*****************************************************************         
P00399 0110-LOAD-DELINQUENCY-TABLE.                                     
P00399                                                                  
P00399     PERFORM 7010-OPEN-DW THRU 7010-EXIT.                         
P00399     PERFORM 7012-FETCH-DW THRU 7012-EXIT.                        
P00399     SET TB-CO-INDEX TO 1.                                        
P00399     SET TB-VAL-INDEX TO 1.                                       
P00399     PERFORM 0111-LOAD-DW-VARIABLE THRU 0111-EXIT                 
P00399             UNTIL SQLCODE = NOT-FOUND.                           
P00399     PERFORM 7014-CLOSE-DW THRU 7014-EXIT.                        
P00399                                                                  
P00399 0110-EXIT.                                                       
P00399     EXIT.                                                        
P00399*****************************************************************         
P00399*0111-LOAD-DW-VARIABLE.                                         *         
P00399*****************************************************************         
P00399 0111-LOAD-DW-VARIABLE.                                           
P00399                                                                  
P00399     MOVE C8-DELINQ-CD    TO WS-VARIABLE-ID.                      
P00399     MOVE C8-DELINQ-VALUE TO WS-VARIABLE-VALUE.                   
P00399     MOVE C8-COMPANY-NO   TO WS-DELINQ-COMPANY.                   
P00399     PERFORM 0112-LOAD-TABLE-ENTRY THRU 0112-EXIT.                
P00399     PERFORM 7012-FETCH-DW         THRU 7012-EXIT.                
P00399                                                                  
P00399     IF C8-COMPANY-NO NOT EQUAL WS-DELINQ-COMPANY                 
P00399         SET TB-CO-INDEX UP BY 1                                  
P00399         SET TB-VAL-INDEX TO 1                                    
P00399     END-IF.                                                      
P00399                                                                  
P00399 0111-EXIT.                                                       
P00399     EXIT.                                                        
P00399                                                                  
P00399*****************************************************************         
P00399*0112-LOAD-TABLE-ENTRY.                                         *         
P00399*****************************************************************         
P00399 0112-LOAD-TABLE-ENTRY.                                           
P00399                                                                  
P00399     MOVE WS-DELINQ-COMPANY TO                                    
P00399         WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX).        
P00399     MOVE WS-VARIABLE-ID TO                                       
P00399         WS-DELINQ-CODE-TB (TB-CO-INDEX, TB-VAL-INDEX).           
P00399     MOVE WS-VARIABLE-VALUE TO                                    
P00399         WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX).          
P00399     SET TB-VAL-INDEX UP BY 1.                                    
P00399                                                                  
P00399 0112-EXIT.                                                       
P00399     EXIT.                                                        
                                                                        
I01959*****************************************************************         
I01959* 1150-ADJUST-AR-CNTL.                                          *         
I01959* ADJUST TRANSFER FROM ACCOUNT AR BALANCE FOR MONEY TRANSFERRED *         
I01959* TO THE ASSIGNEE ACCOUNT.                                      *         
I01959*****************************************************************         
I01959 1150-ADJUST-AR-CNTL.                                             
I01959                                                                  
I01959     SET WS-AR-DATA-INDX TO 1.                                    
I01959     SEARCH WS-AR-DATA                                            
I01959         AT END                                                   
I01959            CONTINUE                                              
I01959       WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) EQUAL              
I01959            WS-ACCOUNT-NO-BG (WS-BILLING-INDX) AND                
I01959            WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) EQUAL 40    
I01959            IF WS-CODE-DR-CR-CNSMPTN-BG (WS-BILLING-INDX) = 'D'   
I01959               COMPUTE WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)      
I01959                 EQUAL WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)      
I01959                     - WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)      
I01959            ELSE                                                  
I01959               COMPUTE WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)      
I01959                 EQUAL WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)      
I01959                     + WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)      
I01959            END-IF                                                
I01959       WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) EQUAL 0            
I01959            MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX)               
I01959              TO WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX)               
I01959            MOVE 40                                               
I01959              TO WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
I01959            IF WS-CODE-DR-CR-CNSMPTN-BG (WS-BILLING-INDX) = 'D'   
I01959               COMPUTE WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)      
I01959                 EQUAL WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)      
I01959                     - WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)      
I01959            ELSE                                                  
I01959               COMPUTE WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)      
I01959                 EQUAL WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)      
I01959                     + WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)      
I01959            END-IF                                                
I01959            MOVE 'I'                                              
I01959              TO WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX)        
I01959     END-SEARCH.                                                  
I01959                                                                  
I01959 1150-EXIT.                                                       
I01959     EXIT.                                                        
                                                                        
      /*****************************************************************        
      *                                                                *        
      *   1200-UPDATE-AR-CNTL.                                         *        
      *                                                                *        
      * SCSCA102 EXTRACTS ALL NON-SUMMARY AR CONTROL ROWS. THESE ARE   *        
      * UPDATED IN SCSCA108 (AND SUBORDINATES).  THIS REWRITES THESE   *        
      * ROWS WITH THE RESULTS OF THE UPDATE.                           *        
      *                                                                *        
      * SEVERAL PROCESSES (E.G., TRANSFERS) CAN "CREATE" AR DETAIL.    *        
      * THE UPDATE-INDICATOR IS SET TO 'U' IN SCSCA102 FOR ROWS THAT   *        
      * ARE EXTRACTED FROM THE DATABASE.  THESE ROWS ARE UPDATED; ANY  *        
      * NEW ROWS WILL BE INSERTED.                                     *        
      *                                                                *        
      ******************************************************************        
       1200-UPDATE-AR-CNTL-DTL.                                         
           MOVE WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) TO AC-ACCOUNT-NO     
           MOVE WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)               
             TO AC-PYMT-PRIORITY-LVL                                    
           MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO AC-ITEM-ID           
           MOVE WS-LAST-UPDATE-TS-AC (WS-AR-DATA-INDX)                  
             TO AC-LAST-UPDATE-TS                                       
      *                                                                         
           MOVE WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)                   
             TO AC-AMT-AR-DAY-00                                        
           MOVE WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)                   
             TO AC-AMT-AR-DAY-30                                        
           MOVE WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)                   
             TO AC-AMT-AR-DAY-60                                        
           MOVE WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)                   
             TO AC-AMT-AR-DAY-90                                        
           MOVE WS-TOT-SUMM-UNBILLED-AC (WS-AR-DATA-INDX)               
             TO AC-TOT-SUMM-UNBILLED                                    
           MOVE WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)                   
             TO AC-AMT-UNUSED-CR                                        
           MOVE WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)                
             TO AC-AMT-TRAN-BALANCE                                     
      *                                                                         
           PERFORM 7100-SELECT-AR-CNTRL THRU 7100-EXIT                  
TP6117     IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) =               
TP6117                         WS-40 OR WS-45 OR WS-50 OR WS-129        
TP6117         PERFORM 1205-CHK-INSERT-UPDATE  THRU 1205-EXIT           
TP6117     ELSE                                                         
TP6117      IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = WS-100       
TP6117       PERFORM 1207-FIND-CONTRACT      THRU 1207-EXIT             
TP6117       IF  ((WS-CODE-BILL-TYPE-CT (WS-CNT-INDX)                   
TP6117                                  = WS-MONTHLY-CHARGE)            
TP6117         OR (WS-CODE-BILL-TYPE-CT (WS-CNT-INDX)                   
TP6117                                  = WS-MONTHLY-CREDIT)            
T13451         OR (WS-CODE-BILL-TYPE-CT (WS-CNT-INDX)                   
T13451                                  = WS-INSTALLMENT-CNTRACT)       
T17410         OR (WS-CODE-BILL-TYPE-CT (WS-CNT-INDX)                   
T17410                                  = WS-ONE-TIME-CHARGE))          
TP6117       AND ((WS-CNT-STATUS-CD-CT (WS-CNT-INDX)= WS-CNT-CANCELLED) 
TP6117         OR (WS-CNT-STATUS-CD-CT (WS-CNT-INDX) = WS-CNT-PAID))    
             AND AC-AMT-AR-DAY-00     EQUAL ZEROES                      
             AND AC-AMT-AR-DAY-30     EQUAL ZEROES                      
             AND AC-AMT-AR-DAY-60     EQUAL ZEROES                      
             AND AC-AMT-AR-DAY-90     EQUAL ZEROES                      
             AND AC-AMT-UNUSED-CR     EQUAL ZEROES                      
             AND AC-AMT-TRAN-BALANCE  EQUAL ZEROES                      
             AND AC-TOT-SUMM-UNBILLED EQUAL ZEROES                      
TP6117         PERFORM 8785-DELETE-AR-CNTL-ITEM THRU 8785-EXIT          
TP6117       ELSE                                                       
TP6117         PERFORM 1205-CHK-INSERT-UPDATE  THRU 1205-EXIT           
TP6117       END-IF                                                     
TP6117      ELSE                                                        
TP6117       IF  AC-AMT-AR-DAY-00     EQUAL ZEROES                      
TP6117       AND AC-AMT-AR-DAY-30     EQUAL ZEROES                      
TP6117       AND AC-AMT-AR-DAY-60     EQUAL ZEROES                      
TP6117       AND AC-AMT-AR-DAY-90     EQUAL ZEROES                      
TP6117       AND AC-AMT-UNUSED-CR     EQUAL ZEROES                      
TP6117       AND AC-AMT-TRAN-BALANCE  EQUAL ZEROES                      
TP6117       AND AC-TOT-SUMM-UNBILLED EQUAL ZEROES                      
TP6117        IF WS-HAS-AC                                              
TP6117         PERFORM 8785-DELETE-AR-CNTL-ITEM THRU 8785-EXIT          
TP6117        ELSE                                                      
TP6117         NEXT SENTENCE                                            
TP6117        END-IF                                                    
TP6117       ELSE                                                       
TP6117         PERFORM 1205-CHK-INSERT-UPDATE  THRU 1205-EXIT           
TP6117       END-IF                                                     
TP6117      END-IF                                                      
TP6117     END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
TP6117 1205-CHK-INSERT-UPDATE.                                          
TP6117     EVALUATE WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX)           
TP6117       WHEN WS-UPDATE                                             
TP6117          PERFORM 8120-UPDATE-AR-CNTRL THRU 8120-EXIT             
TP6117       WHEN WS-INSERT                                             
T9134        WHEN SPACES                                                
TP6117          PERFORM 8123-INSERT-AR-CNTRL THRU 8123-EXIT             
TP6117     END-EVALUATE.                                                
TP6117*                                                                         
TP6117 1205-EXIT.                                                       
TP6117     EXIT.                                                        
TP6117*                                                                         
TP6117 1207-FIND-CONTRACT.                                              
TP6117     PERFORM VARYING WS-CNT-INDX FROM 1 BY 1                      
P00097       UNTIL WS-CNT-INDX > WS-CT-MAX-ENTRY                        
TP6117          OR WS-ACCOUNT-NO-CT (WS-CNT-INDX) = ZERO                
TP6117          OR WS-CNT-ITEM-ID-CT (WS-CNT-INDX) =                    
TP6117               WS-ITEM-ID-AC (WS-AR-DATA-INDX)                    
TP6117     END-PERFORM.                                                 
TP6117*                                                                         
TP6117 1207-EXIT.                                                       
TP6117     EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *   1220-UPDATE-AR-CNTL-SUMM.                                    *        
      *                                                                *        
      * SUMMARY ROWS ARE RE-CREATED FOR EACH AR TYPE (PRIORITY LEVEL)  *        
      * THAT HAS DETAIL BY SUMMING THE INDIVIDUAL AC DETAIL DATA. NOTE *        
      * THAT TRAN BALANCE IS NOT ACCUMULATED FOR BUDGET.               *        
      *                                                                *        
      * SINCE THESE ROWS ARE NOT IN CWS10000, THEY MUST BE RETRIEVED   *        
      * AT THIS POINT TO DETERMINE WHETHER AN INSERT OR AN UPDATE IS   *        
      * REQUIRED.                                                      *        
      *                                                                *        
      ******************************************************************        
       1220-UPDATE-AR-CNTL-SUMM.                                        
           PERFORM VARYING WS-PPL-INDX FROM 1 BY 1                      
T12802       UNTIL WS-PPL-INDX > 8                                      
              INITIALIZE WS-SUMMARY-AR                                  
              SET WS-HAS-NO-DETAIL TO TRUE                              
              IF WS-AR-CNTL-DTL-PPL (WS-PPL-INDX) = 50                  
                    AND WS-CODE-RMOVE-FRM-BUD-CALC = WS-YES             
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM VARYING WS-AR-DATA-INDX FROM 1 BY 1            
P00097                   UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY        
                            OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZERO
                    IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
                           = WS-AR-CNTL-DTL-PPL (WS-PPL-INDX)           
                       SET WS-HAS-DETAIL TO TRUE                        
                       MOVE WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX)          
                         TO WS-ACCOUNT-NO-SUM                           
                       MOVE WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)   
                         TO WS-PYMT-PRIORITY-LVL-SUM                    
                       MOVE ZEROES                                      
                         TO WS-ITEM-ID-SUM                              
                       ADD WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)        
                         TO WS-AMT-AR-DAY-00-SUM                        
                       ADD WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)        
                         TO WS-AMT-AR-DAY-30-SUM                        
                       ADD WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)        
                         TO WS-AMT-AR-DAY-60-SUM                        
                       ADD WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)        
                         TO WS-AMT-AR-DAY-90-SUM                        
                       ADD WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)        
                         TO WS-AMT-UNUSED-CR-SUM                        
                       ADD WS-TOT-SUMM-UNBILLED-AC (WS-AR-DATA-INDX)    
                         TO WS-TOT-SUMM-UNBILLED-SUM                    
T10282                 ADD WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)     
T10282                   TO WS-AMT-TRAN-BALANCE-SUM                     
                    END-IF                                              
                 END-PERFORM                                            
              END-IF                                                    
                                                                        
              IF WS-HAS-DETAIL                                          
C35326           AND NOT (WS-PYMT-PRIORITY-LVL-SUM = 129 AND            
C35326                    WS-PJS-DELETED)                               
                 MOVE WS-ACCOUNT-NO-SUM         TO AC-ACCOUNT-NO        
                 MOVE WS-PYMT-PRIORITY-LVL-SUM  TO AC-PYMT-PRIORITY-LVL 
                 MOVE WS-ITEM-ID-SUM            TO AC-ITEM-ID           
                 MOVE WS-AMT-AR-DAY-00-SUM      TO AC-AMT-AR-DAY-00     
                 MOVE WS-AMT-AR-DAY-30-SUM      TO AC-AMT-AR-DAY-30     
                 MOVE WS-AMT-AR-DAY-60-SUM      TO AC-AMT-AR-DAY-60     
                 MOVE WS-AMT-AR-DAY-90-SUM      TO AC-AMT-AR-DAY-90     
                 MOVE WS-AMT-UNUSED-CR-SUM      TO AC-AMT-UNUSED-CR     
T10282           MOVE ZERO                      TO AC-AMT-TRAN-BALANCE  
                 MOVE WS-TOT-SUMM-UNBILLED-SUM  TO AC-TOT-SUMM-UNBILLED 
                 PERFORM 7100-SELECT-AR-CNTRL THRU 7100-EXIT            
CG0218           IF AC-PYMT-PRIORITY-LVL =                              
TP6117                         WS-40 OR WS-45 OR WS-50 OR WS-129        
                  IF WS-HAS-AC                                          
                    MOVE WS-LAST-UPDATE-TS-SUM                          
                      TO AC-LAST-UPDATE-TS                              
                    PERFORM 8120-UPDATE-AR-CNTRL THRU 8120-EXIT         
                  ELSE                                                  
                    PERFORM 8123-INSERT-AR-CNTRL THRU 8123-EXIT         
                  END-IF                                                
TP6117           ELSE                                                   
TP6117              PERFORM 1222-CHK-FOR-DELETE  THRU 1222-EXIT         
TP6117           END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
       1220-EXIT.                                                       
           EXIT.                                                        
TP6117*                                                                         
TP6117 1222-CHK-FOR-DELETE.                                             
TP6117     IF WS-HAS-AC                                                 
T12721      PERFORM 7105-SELECT-VALID-DETAIL THRU 7105-EXIT             
T12721      IF WS-HAS-VALID-AC                                          
TP6117           MOVE WS-LAST-UPDATE-TS-SUM                             
TP6117                               TO AC-LAST-UPDATE-TS               
TP6117           PERFORM 8120-UPDATE-AR-CNTRL THRU 8120-EXIT            
TP6117      ELSE                                                        
TP6117            PERFORM 8785-DELETE-AR-CNTL-ITEM THRU 8785-EXIT       
C36303            IF AC-PYMT-PRIORITY-LVL = 100                         
C36303               MOVE SPACES TO WS-CODE-CONTRACT                    
C36303            END-IF                                                
TP6117      END-IF                                                      
TP6117     ELSE                                                         
T12721      PERFORM 7105-SELECT-VALID-DETAIL THRU 7105-EXIT             
T12721*     THE DETAIL ROWS WERE JUST INSERTED IN THIS BILLING, SO              
T12721*     CREATE A SUMMARY ROW                                                
T12721      IF WS-HAS-VALID-AC                                          
TP6117         PERFORM 8123-INSERT-AR-CNTRL THRU 8123-EXIT              
TP6117      END-IF                                                      
TP6117     END-IF.                                                      
TP6117                                                                  
TP6117 1222-EXIT.                                                       
           EXIT.                                                        
P00599******************************************************************        
P00599* 1230-UPDATE-CRED-HIST.                                         *        
P00599******************************************************************        
P00599                                                                  
P00599 1230-UPDATE-CRED-HIST.                                           
P00599                                                                  
P00599     MOVE WS-ACCOUNT-NO-CZ         TO CZ-ACCOUNT-NO.              
P00599     MOVE WS-LAST-UPDATE-TS-CZ     TO CZ-LAST-UPDATE-TS.          
P00599     MOVE WS-CASH-ONLY-FL-CZ       TO CZ-CASH-ONLY-FL.            
P00599     MOVE WS-CSH-ONLY-EFFECT-DT-CZ TO CZ-CSH-ONLY-EFFECT-DT.      
P00599     MOVE ZEROS                    TO CZ-AUTO-DEP-AM.             
P00599     PERFORM 8210-UPDATE-CREDIT-PROFILE  THRU  8210-EXIT.         
P00599                                                                  
P00599 1230-EXIT.                                                       
P00599     EXIT.                                                        
P00599                                                                  
      /*****************************************************************        
      *                                                                *        
      *   1240-UPDATE-BILL-HEADER.                                     *        
      *                                                                *        
      * APPLIES UPDATES TO BILLING HEADER FIELDS.                      *        
      *                                                                *        
      ******************************************************************        
T5502  1240-UPDATE-BILL-HEADER.                                         
           INITIALIZE DCLCSS-BILLING-HDR                                
           MOVE WS-BILL-NO-BI          TO BI-BILL-NO.                   
           MOVE WS-ACCOUNT-NO-BI       TO BI-ACCOUNT-NO.                
           MOVE WS-COMPANY-NO-BI       TO BI-COMPANY-NO.                
T5837      IF (WS-CONS-BILL-MAST                                        
            AND (WS-OFF-CYCLE-REBILL OR WS-ON-CYCLE-BILL))              
T5837         MOVE LS-INPUT-DATE       TO BI-DATE-BILLED                
T11779                                    WS-DATE-BILLED-BI             
T5837         MOVE WS-BILLED           TO BI-CODE-BILL-STATUS           
T5837      ELSE                                                         
T5837         IF WS-CONS-BILL-MAST                                      
TP4688           MOVE LOW-VALUES       TO BI-DATE-BILLED                
T11779                                    WS-DATE-BILLED-BI             
TP4688           MOVE WS-ACTIVE        TO BI-CODE-BILL-STATUS           
TP4688        ELSE                                                      
TP4688           MOVE LS-INPUT-DATE    TO BI-DATE-BILLED                
T11779                                    WS-DATE-BILLED-BI             
TP4688           MOVE WS-BILLED        TO BI-CODE-BILL-STATUS           
TP4688        END-IF                                                    
T5837      END-IF.                                                      
T10533* COMPUTE TOTAL OTHER CHARGES                                             
T10533     PERFORM VARYING WS-AR-DATA-INDX FROM 1 BY 1                  
P00097       UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY                    
T10533          OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZERO            
T10533        IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)              
T10533         NOT = 40 AND 45 AND 50                                   
T10533           ADD WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)              
T10533               TO WS-TOT-OTHER-CHARGES-BI                         
T10533        END-IF                                                    
T10533     END-PERFORM.                                                 
T10533* COMPUTE TOTAL ARREARS                                                   
T10533     PERFORM VARYING WS-AR-DATA-INDX FROM 1 BY 1                  
P00097       UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY                    
T10533          OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZERO            
T10533        IF NOT WS-SINGLE-ITEM-BILL                                
T10533         OR (WS-SINGLE-ITEM-BILL                                  
T10533            AND WS-FDB07-PYMT-PRIORITY-LVL                        
T10533             = WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)          
T10533            AND WS-FDB07-ITEM-ID                                  
T10533             = WS-ITEM-ID-AC (WS-AR-DATA-INDX))                   
T10533           COMPUTE WS-TOTAL-ARREARS-BI                            
T10533             = WS-TOTAL-ARREARS-BI                                
T10533             + WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)              
T10533             + WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)              
T10533             + WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)              
T10533        END-IF                                                    
T10533     END-PERFORM.                                                 
           MOVE WS-TOT-OTHER-CHARGES-BI TO BI-TOT-OTHER-CHARGES.        
           MOVE WS-TOTAL-ARREARS-BI    TO BI-TOTAL-ARREARS.             
T10723     IF WS-CODE-ACCT-STAT-AT = WS-FINAL-AT                        
T10723        MOVE WS-FINAL-AT TO WS-CODE-BILL-TYPE-BI                  
T23947        IF WS-OFF-CYCLE-REBILL                                    
T23947           IF WS-ACCT-FINALED-DT-AT EQUAL SPACES OR LOW-VALUES    
T23947              MOVE WS-REGULAR-BILL TO WS-CODE-BILL-TYPE-BI        
T23947           END-IF                                                 
T23947        END-IF                                                    
T10723     END-IF.                                                      
           MOVE WS-CODE-BILL-TYPE-BI   TO BI-CODE-BILL-TYPE.            
           MOVE WS-CODE-BILL-REASON-BI TO BI-CODE-BILL-REASON.          
           MOVE WS-CUSTOMER-NO-BI      TO BI-CUSTOMER-NO.               
           MOVE WS-PREMISE-NO-BI       TO BI-PREMISE-NO.                
           MOVE WS-CODE-SPCL-BILL-BI   TO BI-CODE-SPCL-BILL.            
           MOVE WS-PREM-ACCT-SEQ-NO-BI TO BI-PREM-ACCT-SEQ-NO.          
           MOVE WS-LAST-UPDATE-TS-BI   TO BI-LAST-UPDATE-TS.            
       1240-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *   1250-UPDATE-ACCOUNT.                                         *        
      *                                                                *        
      * APPLIES UPDATES TO VARIOUS ACCOUNT DATA FIELDS.                *        
      *                                                                *        
      ******************************************************************        
       1250-UPDATE-ACCOUNT.                                             
           MOVE WS-ACCOUNT-NO-AT         TO AT-ACCOUNT-NO.              
           MOVE WS-COMPANY-NO-AT         TO AT-COMPANY-NO.              
           MOVE WS-LAST-UPDATE-TS-AT     TO AT-LAST-UPDATE-TS.          
           MOVE WS-CREDIT-STATUS-CODE-AT TO AT-CREDIT-STATUS-CODE.      
           MOVE WS-CREDIT-GROUP-AT       TO AT-CREDIT-GROUP.            
           MOVE WS-CODE-ACCT-STAT-AT     TO AT-CODE-ACCT-STAT.          
      *                                                                         
T20512     IF WS-CODE-ACCT-STAT-AT = 'B' AND WS-ON-OFF-CYCLE-IND = 'B'  
TP8961      AND (WS-ACCT-FINALED-DT-AT EQUAL SPACES OR LOW-VALUES)      
T10114        STRING LS-INPUT-DATE                                      
T10114               '-00.00.00.000000'                                 
T10114          DELIMITED BY SIZE                                       
T10114          INTO WS-ACCT-FINALED-DT-AT                              
TP8961     END-IF.                                                      
           MOVE WS-ACCT-FINALED-DT-AT    TO AT-ACCT-FINALED-DT.         
           MOVE WS-DATE-BILL-DAY-00-AT   TO AT-DATE-BILL-DAY-00.        
           MOVE WS-DATE-BILL-DAY-30-AT   TO AT-DATE-BILL-DAY-30.        
           MOVE WS-DATE-BILL-DAY-60-AT   TO AT-DATE-BILL-DAY-60.        
           MOVE WS-DATE-BILL-DAY-90-AT   TO AT-DATE-BILL-DAY-90.        
PCR212     MOVE WS-ELEC-REV-ALLOC-PCT-AT TO AT-ELEC-REV-ALLOC-PCT.      
           MOVE WS-LAST-PYMT-DATE-AT     TO AT-LAST-PYMT-DATE.          
           MOVE WS-TOTAL-AR-BALANCE-AT   TO AT-TOTAL-AR-BALANCE.        
           MOVE WS-CODE-LPC-XMT-AT       TO AT-CODE-LPC-XMT.            
           MOVE WS-CODE-BILL-FREQ-AT     TO AT-CODE-BILL-FREQ.          
           MOVE WS-CODE-PERM-BILL-AT     TO AT-CODE-PERM-BILL.          
           MOVE WS-DATE-LAST-ACTION-AT   TO AT-DATE-LAST-ACTION.        
           MOVE WS-CODE-DISC-OK-AT       TO AT-CODE-DISC-OK.            
           MOVE WS-NXT-BILL-NO-AT        TO AT-NXT-BILL-NO.             
           MOVE WS-LAST-PYMT-DATE-AT     TO AT-LAST-PYMT-DATE.          
           MOVE WS-LAST-PYMT-AMOUNT-AT   TO AT-LAST-PYMT-AMOUNT.        
           MOVE WS-EPP-OFFER-AMOUNT-AT   TO AT-EPP-OFFER-AMOUNT.        
           MOVE WS-EPP-OFFER-DATE-AT     TO AT-EPP-OFFER-DATE.          
           MOVE WS-CODES-DATA-PRESENT-AT TO AT-CODES-DATA-PRESENT.      
PCR136     MOVE WS-NOTICE-EXEMPT-CD-AT   TO AT-NOTICE-EXEMPT-CD.        
T28788     MOVE WS-IVR-EXEMPT-CD-AT      TO AT-IVR-EXEMPT-CD.           
T10918     MOVE WS-CANREB-CODE-00-DAY-AT TO AT-CANREB-CODE-00-DAY.      
T10918     MOVE WS-CANREB-CODE-30-DAY-AT TO AT-CANREB-CODE-30-DAY.      
T10918     MOVE WS-CANREB-CODE-60-DAY-AT TO AT-CANREB-CODE-60-DAY.      
T10918     MOVE WS-CANREB-CODE-90-DAY-AT TO AT-CANREB-CODE-90-DAY.      
T12417     MOVE WS-MST-OVRRD-BLL-IND-AT  TO AT-MST-OVRRD-BLL-IND.       
T5502      IF WS-NEXT-BILL-NO-CALC > 0                                  
T5502         MOVE WS-BILL-NO-BI TO WS-LAST-NRML-BILL-NO-AT             
T5502         MOVE LS-CURR-REVENUE-MONTH TO WS-REV-MTH-LST-NRML-AT      
T5502      END-IF.                                                      
T5502      MOVE WS-REV-MTH-LST-NRML-AT TO AT-REV-MTH-LST-NRML           
T5502      MOVE WS-LAST-NRML-BILL-NO-AT TO AT-LAST-NRML-BILL-NO.        
           IF WS-CODE-PERM-BILL-AT EQUAL LOW-VALUES                     
              MOVE WS-NORMAL TO AT-CODE-PERM-BILL                       
           END-IF.                                                      
           IF WS-CODE-RMOVE-FRM-RVC-CALC EQUAL WS-YES                   
              MOVE ZERO TO AT-DATE-REV-CHG-AUTH                         
           END-IF.                                                      
T14429     MOVE WS-NORMAL TO AT-CODE-TEMP-BILL.                         
           MOVE SPACE TO AT-CODE-P-BILL-DEST.                           
           MOVE SPACE TO AT-CODE-BILL-PEND.                             
      *                                                                         
T14446     IF (WS-CODE-BILL-PEND-AT                                     
T14446         = WS-REBILL-ASAP OR WS-REBILL-NEXT-REGULAR)              
T14446          AND (WS-ON-CYCLE-BILL OR WS-OFF-CYCLE-FINAL)            
T14446        MOVE WS-REBILL-COMPLETE TO WS-CODE-BILL-PEND-AT
           END-IF.          
T15127     MOVE WS-AR-XFER-IND-AT     TO AT-AR-XFER-IND.                
           PERFORM 8000-UPDATE-ACCOUNT THRU 8000-EXIT.                  
       1250-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************        
      *                                                                *        
      *   1252-PROCESS-AR-DETAIL                                       *        
      *                                                                *        
      * APPLIES UPDATES TO ANY DETAIL AR TABLES ASSOCIATED WITH AR     *        
      * CONTROL DETAIL ROWS.                                           *        
      *                                                                *        
      ******************************************************************        
       1252-PROCESS-AR-DETAIL.                                          
           MOVE WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) TO            
                WS-PYMT-LVL-CHECK.                                      
           EVALUATE TRUE                                                
P00453*    Process Prepay accounts                                              
              WHEN BUD AND WS-CODE-PRE-PAY-PLAN = 'A'                   
P00453*    Update PrePayPlan account form billing extract                       
P00453           SET WS-PK-INDX TO 1                                    
P00453           PERFORM UNTIL WS-PK-INDX > WS-PK-MAX-ENTRY             
P00453                   OR WS-ACCOUNT-NO-PK (WS-PK-INDX) =  ZERO       
P00453              IF WS-UPDATE-ACTION-IND-PK (WS-PK-INDX) = WS-UPDATE 
P00453                 PERFORM 1510-PROCESS-PREPAY-HIST THRU 1510-EXIT  
P00453                 PERFORM 8920-UPDATE-PREPAY-HIST  THRU 8920-EXIT  
P00453              END-IF                                              
P00453              SET WS-PK-INDX UP BY 1                              
P00453           END-PERFORM                                            
P00453*    Process Budget Billing accounts                                      
P00453        WHEN BUD AND WS-CODE-PRE-PAY-PLAN NOT = 'A'               
                 IF WS-CODE-RMOVE-FRM-BUD-CALC = WS-YES                 
                    MOVE 'A'   TO WS-CODE-UTL                           
                    MOVE SPACE TO WS-CODE-BUDGET                        
                    PERFORM 1270-REMOVE-BUDGET THRU 1270-EXIT           
                 ELSE                                                   
A01433              IF WS-CODE-TARIFF-CHANGE-CALC = 'A' OR              
A01433                 WS-ACCOUNT-EPP(1) = WS-ACCOUNT-NO-AT             
A01433                 MOVE WS-ACCOUNT-NO-AT TO BU-ACCOUNT-NO           
A01433                 MOVE 50               TO BU-PYMT-PRIORITY-LVL    
A01433                 MOVE 1                TO BU-BP-ITEM-ID           
A01433                 PERFORM 7090-GET-AMT-MO-PYMT THRU 7090-EXIT      
A01433                 MOVE BU-AMT-MO-PYMT   TO WS-AMT-MO-PYMT-PREV     
A01433              END-IF                                              
                    PERFORM 1263-CHECK-BUD  THRU 1263-EXIT              
                 END-IF                                                 
              WHEN DFA                                                  
                 PERFORM 1258-UPDATE-DFA  THRU  1258-EXIT               
              WHEN CNT                                                  
                 PERFORM 1259-UPDATE-CNT  THRU 1259-EXIT                
              WHEN CCC                                                  
                 PERFORM 1264-UPDATE-CONNECT-CHG THRU 1264-EXIT         
              WHEN PJS                                                  
C35326           SET WS-PJS-NOT-DELETED      TO TRUE                    
                 PERFORM 1266-UPD-PROJ-SHARE THRU 1266-EXIT             
           END-EVALUATE.                                                
       1252-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************        
      *                                                                *        
      *   1258-UPDATE-DFA                                              *        
      *                                                                *        
      * FINDS CORRESPONDING CWS10000 RECORD AND APPLIES UPDATES        *        
      *                                                                *        
      ******************************************************************        
       1258-UPDATE-DFA.                                                 
A35920     MOVE 'N'   TO WS-DPP-RECVBLE.                                
           SET WS-DFA-INDX TO +1.                                       
           SEARCH  WS-DFA-ACCT-DATA                                     
              AT END                                                    
                 CONTINUE                                               
              WHEN  WS-ACCOUNT-NO-DA (WS-DFA-INDX)                      
                       = WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX)             
                   AND WS-DFA-ITEM-ID-DA  (WS-DFA-INDX)                 
                       = WS-ITEM-ID-AC (WS-AR-DATA-INDX)                
                 MOVE WS-ACCOUNT-NO-DA (WS-DFA-INDX)                    
                   TO DA-ACCOUNT-NO                                     
                 MOVE WS-PYMT-PRIORITY-LVL-DA (WS-DFA-INDX)             
                   TO DA-PYMT-PRIORITY-LVL                              
                 MOVE WS-DFA-ITEM-ID-DA (WS-DFA-INDX)                   
                   TO DA-DFA-ITEM-ID                                    
                 MOVE WS-AMT-MO-PYMT-DA (WS-DFA-INDX)                   
                   TO DA-AMT-MO-PYMT                                    
                 MOVE WS-CODE-DFA-STATUS-DA (WS-DFA-INDX)               
                   TO DA-CODE-DFA-STATUS                                
                 MOVE WS-RCNTLY-BLLD-MTH-DA (WS-DFA-INDX)               
                   TO DA-RCNTLY-BLLD-MTH                                
                 MOVE WS-CODE-COMPLY-HIST-DA (WS-DFA-INDX)              
                   TO DA-CODE-COMPLY-HIST                               
T11084           MOVE WS-DATE-PYMT-START-DA (WS-DFA-INDX)               
T11084             TO DA-DATE-PYMT-START                                
                 MOVE WS-LAST-UPDATE-TS-DA (WS-DFA-INDX)                
                   TO DA-LAST-UPDATE-TS                                 
T30467           MOVE WS-REVENUE-MONTH-DA (WS-DFA-INDX)                 
T30467             TO DA-REVENUE-MONTH                                  
A35920           IF WS-CODE-DFA-TYPE-DA (WS-DFA-INDX) = WS-DPP          
A35920              MOVE 'Y'   TO WS-DPP-RECVBLE                        
A35920           END-IF                                                 
                 EVALUATE WS-UPDATE-ACTION-IND-DA (WS-DFA-INDX)         
                    WHEN WS-UPDATE                                      
                       PERFORM 8730-UPDATE-DFA-ACCT THRU 8730-EXIT      
                       IF WS-CODE-DFA-TYPE-DA (WS-DFA-INDX) = WS-DPP    
T17946                    SET WS-DV-INDX TO +1                          
T17946                    SEARCH WS-DFA-RECV-DATA                       
T17946                       AT END                                     
T17946                          CONTINUE                                
T17946                       WHEN WS-AGREEMENT-NO-DV (WS-DV-INDX)       
                                  = DA-DFA-ITEM-ID                      
T17946                        AND WS-DFA-PYMT-PRIORITY-DV (WS-DV-INDX)  
T17946                            = WS-90                               
                                MOVE WS-AMT-DAY-00-DV (WS-DV-INDX)      
                                  TO DV-AMT-DAY-00                      
                                MOVE WS-AMT-DAY-30-DV (WS-DV-INDX)      
                                  TO DV-AMT-DAY-30                      
                                MOVE WS-AMT-DAY-60-DV (WS-DV-INDX)      
                                  TO DV-AMT-DAY-60                      
                                MOVE WS-AMT-DAY-90-DV (WS-DV-INDX)      
                                  TO DV-AMT-DAY-90                      
T17946                          MOVE WS-AMT-CONTRACT-DEFR-DV            
T17946                                (WS-DV-INDX)                      
T17946                            TO DV-AMT-CONTRACT-DEFR               
                                MOVE WS-PYMT-PRIORITY-LVL-DV            
                                      (WS-DV-INDX)                      
                                  TO DV-PYMT-PRIORITY-LVL               
PCR393                          MOVE WS-DFA-PYMT-PRIORITY-DV            
PCR393                                (WS-DV-INDX)                      
PCR393                            TO DV-DFA-PYMT-PRIORITY               
PCR393                          MOVE WS-CNT-ITEM-ID-DV (WS-DV-INDX)     
PCR393                            TO DV-CNT-ITEM-ID                     
T17946                          IF WS-UPDATE-ACTION-IND-DV (WS-DV-INDX) 
T17946                                 = 'D'                            
T17946                             PERFORM 8734-DELETE-DFA-RECV         
T17946                                THRU 8734-EXIT                    
T17946                          ELSE                                    
T17946                             PERFORM 8735-UPDATE-DFA-RECV         
T17946                                THRU 8735-EXIT                    
T17946                          END-IF                                  
A35920                          MOVE 'N'   TO WS-DPP-RECVBLE            
                             END-SEARCH                                 
                       END-IF                                           
                    WHEN WS-INSERT                                      
                       MOVE WS-DATE-OF-AGREE-DA (WS-DFA-INDX)           
                         TO DA-DATE-OF-AGREE                            
                       MOVE WS-CODE-DFA-TYPE-DA (WS-DFA-INDX)           
                         TO DA-CODE-DFA-TYPE                            
                       MOVE WS-NO-SCHED-PYMTS-DA (WS-DFA-INDX)          
                         TO DA-NO-SCHED-PYMTS                           
                       MOVE WS-AMT-ORIG-ENTERED-DA (WS-DFA-INDX)        
                         TO DA-AMT-ORIG-ENTERED                         
                       MOVE WS-CSR-USERID-DA (WS-DFA-INDX)              
                         TO DA-CSR-USERID                               
                       MOVE WS-CODE-DFA-STATUS-DA (WS-DFA-INDX)         
                         TO DA-CODE-DFA-STATUS                          
                       MOVE WS-AMT-UNDEFERD-RECV-DA (WS-DFA-INDX)       
                         TO DA-AMT-UNDEFERD-RECV                        
                       MOVE WS-CODE-DFA-DESC-DA (WS-DFA-INDX)           
                         TO DA-CODE-DFA-DESC                            
                       MOVE WS-AMT-EXTRA-DEPOSIT-DA (WS-DFA-INDX)       
                         TO DA-AMT-EXTRA-DEPOSIT                        
                       MOVE WS-REVERSE-REASON-DA (WS-DFA-INDX)          
                         TO DA-REVERSE-REASON                           
                       MOVE WS-FRST-ERNST-PAY-AMT-DA (WS-DFA-INDX)      
                         TO DA-FRST-ERNST-PAY-AMT                       
                       MOVE WS-SCND-ERNST-PAY-AMT-DA (WS-DFA-INDX)      
                         TO DA-SCND-ERNST-PAY-AMT                       
                       MOVE WS-PYMNT-ARNGMNT-CMTS-DA (WS-DFA-INDX)      
                         TO DA-PYMNT-ARNGMNT-CMTS                       
T19929                 MOVE WS-ACCT-XFER-FROM-DA (WS-DFA-INDX)          
T19929                   TO DA-ACCT-XFER-FROM                           
                       PERFORM 8731-INSERT-DFA-ACCT THRU 8731-EXIT      
                       IF WS-CODE-DFA-TYPE-DA (WS-DFA-INDX) = WS-DPP    
TP7965                 OR WS-CODE-DFA-TYPE-DA (WS-DFA-INDX) = WS-DFA    
                          PERFORM VARYING WS-DV-INDX FROM 1 BY 1        
P00097                       UNTIL WS-DV-INDX > WS-DV-MAX-ENTRY         
                                       OR WS-ACCOUNT-NO-DV (WS-DV-INDX) 
                                          = ZERO                        
                             IF WS-AGREEMENT-NO-DV (WS-DV-INDX)         
                                  = DA-DFA-ITEM-ID                      
                                MOVE WS-AMT-DAY-00-DV (WS-DV-INDX)      
                                  TO DV-AMT-DAY-00                      
                                MOVE WS-AMT-DAY-30-DV (WS-DV-INDX)      
                                  TO DV-AMT-DAY-30                      
                                MOVE WS-AMT-DAY-60-DV (WS-DV-INDX)      
                                  TO DV-AMT-DAY-60                      
                                MOVE WS-AMT-DAY-90-DV (WS-DV-INDX)      
                                  TO DV-AMT-DAY-90                      
                                MOVE WS-AMT-CONTRACT-DEFR-DV            
                                        (WS-DV-INDX)                    
                                  TO DV-AMT-CONTRACT-DEFR               
                                MOVE WS-ACCOUNT-NO-DV (WS-DV-INDX)      
                                  TO DV-ACCOUNT-NO                      
                                MOVE WS-AGREEMENT-NO-DV (WS-DV-INDX)    
                                  TO DV-AGREEMENT-NO                    
                                MOVE WS-PYMT-PRIORITY-LVL-DV            
                                        (WS-DV-INDX)                    
                                  TO DV-PYMT-PRIORITY-LVL               
T10749                          MOVE WS-DFA-PYMT-PRIORITY-DV            
                                        (WS-DV-INDX)                    
                                  TO DV-DFA-PYMT-PRIORITY               
PCR393                          MOVE WS-CNT-ITEM-ID-DV (WS-DV-INDX)     
PCR393                            TO DV-CNT-ITEM-ID                     
                                PERFORM 8736-INSERT-DFA-RECV            
                                   THRU 8736-EXIT                       
A35920                          MOVE 'N'   TO WS-DPP-RECVBLE            
                             END-IF                                     
                          END-PERFORM                                   
                       END-IF                                           
                 END-EVALUATE                                           
           END-SEARCH.                                                  
A35920*                                                                         
ACT009     IF (WS-OFF-CYCLE-REBILL OR WS-ON-CYCLE-BILL) AND             
A35920               WS-DPP-RECVBLE = 'Y'                               
A35920        SET WS-DV-INDX TO +1                                      
A35920        SEARCH WS-DFA-RECV-DATA                                   
A35920           AT END                                                 
A35920              CONTINUE                                            
A35920           WHEN WS-ACCOUNT-NO-DV (WS-DV-INDX)    =                
A35920                WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX)                
A35920            AND WS-AGREEMENT-NO-DV (WS-DV-INDX)  =                
A35920                WS-ITEM-ID-AC (WS-AR-DATA-INDX)                   
A35920            AND WS-AGREEMENT-NO-DV (WS-DV-INDX) = DA-DFA-ITEM-ID  
A35920            AND WS-PYMT-PRIORITY-LVL-DV (WS-DV-INDX) = WS-90      
A35920            AND WS-DFA-PYMT-PRIORITY-DV(WS-DV-INDX)  = WS-90      
A35920                MOVE WS-PYMT-PRIORITY-LVL-DV                      
A35920                      (WS-DV-INDX)                                
A35920                  TO DV-PYMT-PRIORITY-LVL                         
A35920                MOVE WS-DFA-PYMT-PRIORITY-DV                      
A35920                      (WS-DV-INDX)                                
A35920                  TO DV-DFA-PYMT-PRIORITY                         
A35920                MOVE WS-CNT-ITEM-ID-DV (WS-DV-INDX)               
A35920                  TO DV-CNT-ITEM-ID                               
A35920                IF WS-UPDATE-ACTION-IND-DV (WS-DV-INDX) = 'D'     
A35920                   PERFORM 8734-DELETE-DFA-RECV THRU 8734-EXIT    
A35920                ELSE                                              
A35920                   MOVE WS-AMT-DAY-00-DV (WS-DV-INDX)             
A35920                     TO DV-AMT-DAY-00                             
A35920                   MOVE WS-AMT-DAY-30-DV (WS-DV-INDX)             
A35920                     TO DV-AMT-DAY-30                             
A35920                   MOVE WS-AMT-DAY-60-DV (WS-DV-INDX)             
A35920                     TO DV-AMT-DAY-60                             
A35920                   MOVE WS-AMT-DAY-90-DV (WS-DV-INDX)             
A35920                     TO DV-AMT-DAY-90                             
A35920                   MOVE WS-AMT-CONTRACT-DEFR-DV                   
A35920                         (WS-DV-INDX)                             
A35920                     TO DV-AMT-CONTRACT-DEFR                      
A35920                   PERFORM 8735-UPDATE-DFA-RECV THRU 8735-EXIT    
A35920                END-IF                                            
A35920        END-SEARCH                                                
A35920     END-IF.                                                      
       1258-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************        
      *                                                                *        
      *   1259-UPDATE-CNT                                              *        
      *                                                                *        
      * FINDS CORRESPONDING CWS10000 RECORD AND APPLIES UPDATES        *        
      *                                                                *        
      ******************************************************************        
       1259-UPDATE-CNT.                                                 
           SET WS-CNT-INDX TO +1.                                       
           SEARCH  WS-CONTRACT-DATA                                     
              AT END                                                    
                 MOVE 'CNT NOT FOUND FOR AC'                            
                   TO WS-MISC-MSG-TEXT                                  
PCR629           MOVE +137 TO WS-MISC-CATEGORY                          
                 MOVE +23 TO WS-MISC-MSG-LEN                            
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9910-MISC-ERROR THRU 9910-EXIT                 
              WHEN  WS-ACCOUNT-NO-CT (WS-CNT-INDX)                      
                       = WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX)             
                   AND WS-CNT-ITEM-ID-CT  (WS-CNT-INDX)                 
                       = WS-ITEM-ID-AC (WS-AR-DATA-INDX)                
                 MOVE WS-ACCOUNT-NO-CT (WS-CNT-INDX)                    
                   TO CT-ACCOUNT-NO                                     
                 MOVE WS-PYMT-PRIORITY-LVL-CT (WS-CNT-INDX)             
                   TO CT-PYMT-PRIORITY-LVL                              
                 MOVE WS-CNT-ITEM-ID-CT (WS-CNT-INDX)                   
                   TO CT-CNT-ITEM-ID                                    
                 MOVE WS-CNT-STATUS-CD-CT (WS-CNT-INDX)                 
                   TO CT-CNT-STATUS-CD                                  
                 MOVE WS-AMT-MO-PYMT-CT (WS-CNT-INDX)                   
                   TO CT-AMT-MO-PYMT                                    
                 MOVE WS-LAST-UPDATE-TS-CT (WS-CNT-INDX)                
                   TO CT-LAST-UPDATE-TS                                 
                 MOVE WS-CODE-INTRST-METH-CT (WS-CNT-INDX)              
                   TO CT-CODE-INTRST-METH                               
                 MOVE WS-INTRST-PRIOR-YR-CT (WS-CNT-INDX)               
                   TO CT-INTRST-PRIOR-YR                                
                 MOVE WS-INTRST-YTD-CT (WS-CNT-INDX)                    
                   TO CT-INTRST-YTD                                     
                 MOVE WS-AMT-DEF-INTEREST-CT (WS-CNT-INDX)              
                   TO CT-AMT-DEF-INTEREST                               
T32482           MOVE WS-STATUS-CHANGE-DT-CT (WS-CNT-INDX)              
T32482             TO CT-STATUS-CHANGE-DT                               
T32482           IF  CT-STATUS-CHANGE-DT = LOW-VALUES OR SPACES         
T32482               MOVE -1   TO WS-NULL-IND-1                         
T32482           ELSE                                                   
T32482               MOVE ZERO TO WS-NULL-IND-1                         
T32482           END-IF                                                 
                 IF CT-CODE-INTRST-METH EQUAL WS-SIMPLE-INTEREST        
                       AND (WS-CODE-BILL-PEND-AT EQUAL 'C' OR SPACE)    
                    IF LS-INPUT-DATE (6:2) EQUAL '01'                   
                       MOVE WS-INTRST-YTD-CT (WS-CNT-INDX)              
                         TO CT-INTRST-PRIOR-YR                          
                       MOVE WS-SMPL-INT-FIN-CHRG-CT-CALC (WS-CNT-INDX)  
                         TO CT-INTRST-YTD                               
                    ELSE                                                
                       ADD WS-SMPL-INT-FIN-CHRG-CT-CALC (WS-CNT-INDX)   
                         TO CT-INTRST-YTD                               
                    END-IF                                              
                 END-IF                                                 
                 PERFORM 8760-UPDATE-CNT      THRU 8760-EXIT            
           END-SEARCH.                                                  
       1259-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       1263-CHECK-BUD.                                                  
           MOVE WS-ACCOUNT-NO-AT                TO BU-ACCOUNT-NO        
C26229                                             BH-ACCOUNT-NO        
           MOVE 50                              TO BU-PYMT-PRIORITY-LVL 
C26229                                             BH-PYMT-PRIORITY-LVL 
           MOVE 1                               TO BU-BP-ITEM-ID        
C26229                                             BH-ITEM-ID           
           MOVE WS-LAST-UPDATE-TS-BU            TO BU-LAST-UPDATE-TS    
           MOVE WS-DATE-PYMT-STRT-BU            TO BU-DATE-PYMT-STRT    
           MOVE WS-AMT-MO-PYMT-BU               TO BU-AMT-MO-PYMT       
           MOVE WS-AMT-MO-PYT-BAL-FWD-BU        TO BU-AMT-MO-PYT-BAL-FWD
           MOVE WS-ANNIVERSARY-DATE-BU          TO BU-ANNIVERSARY-DATE  
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-CODE-TARIFF-CHANGE-CALC = 'A'                     
                                                                        
                 COMPUTE BH-EPP-ESTIMATE                                
                    = WS-AMT-MO-PYMT-BU - WS-THIS-BUD-ORIG-PMT-CALC     
                 MOVE WS-AMT-MO-PYMT-BU TO BU-AMT-MO-PYMT               
                                           BH-AMT-MO-PYMT               
                 MOVE WS-AMT-MO-PYT-BAL-FWD-BU TO BU-AMT-MO-PYT-BAL-FWD 
                                                                        
                 MOVE LS-INPUT-DATE           TO BU-DATE-PYMT-STRT      
T71335* INSERT CURRENT REVENUE MONTH INTO BUDG HIST DATE-PAY-START              
T17335           PERFORM 7110-SELECT-BILLING-DET THRU 7110-EXIT         
T17335           MOVE WS-REVENUE-MONTH       TO  WS-REVENUE-MONTH-HOLD  
T17335           MOVE WS-REVENUE-MONTH-HOLD(1:4) TO WS-RM-CONSTRCT-YR   
T17335           MOVE WS-REVENUE-MONTH-HOLD(5:2) TO WS-RM-CONSTRCT-MO   
T17335           MOVE WS-DAY-ONE                 TO WS-RM-CONSTRCT-DY   
T17335           MOVE WS-REVENUE-MONTH-CONSTRCT  TO BH-DATE-PYMT-STRT   
                 MOVE WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)          
                   TO BH-UTILITY-BALANCE                                
                                                                        
      * THE NEW-BAL-FWD-CALC FIELD IS SET TO THE CURRENT BAL FWD BY             
      * SCSCA102. THIS AMOUNT IS CARRIED FORWARD INTO THE NEW HISTORY           
      * ROW. SINCE THERE IS NO "NEW" (RECALCULATED) VALUE, THE CALC             
      * FIELD IS CLEARED.                                                       
                                                                        
                 MOVE WS-AMT-MO-PMT-NEW-BAL-FWD-CALC                    
                   TO  BH-BALANCE-FORWARD                               
                 MOVE ZERO TO WS-AMT-MO-PMT-NEW-BAL-FWD-CALC            
                                                                        
                 MOVE ZERO TO BH-REMARKS-LEN                            
                 MOVE LOW-VALUES TO BH-REMARKS-TEXT                     
                 MOVE WS-CUST-USAGE-LIT TO BH-METHOD-OF-ESTIMATE        
                 MOVE WS-CHG-REASON-LIT TO BH-CHANGE-REASON             
                                                                        
                 MOVE WS-AMT-MO-PYMT-NEW-BU TO BU-AMT-MO-PYMT-NEW       
                 PERFORM 7110-SELECT-BILLING-DET  THRU 7110-EXIT        
                 PERFORM 5000-COMPUTE-FIELDS      THRU 5000-EXIT        
T16413           MOVE ZERO TO BH-UTILITY-BALANCE                        
                 PERFORM 8717-INSERT-BUDGET-HIST  THRU 8717-EXIT        
                 PERFORM 8713-UPDATE-BUDGET-PLAN  THRU 8713-EXIT        
T13529        WHEN OTHER                                                
                 MOVE WS-AMT-MO-PYMT-NEW-BU TO BU-AMT-MO-PYMT-NEW       
                 MOVE WS-AMT-MO-PYT-BAL-FWD-BU TO BU-AMT-MO-PYT-BAL-FWD 
C26229           IF WS-CATEGORY-ID-WF (1) > 0                           
C26229              CONTINUE                                            
C26229           ELSE                                                   
C26229              PERFORM 7050-SELECT-BUDGET-HIST THRU 7050-EXIT      
C26229              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
C26229                 MOVE BH-DATE-PYMT-STRT(1:4) TO WS-BH-REV-MTH(1:4)
C26229                 MOVE BH-DATE-PYMT-STRT(6:2) TO WS-BH-REV-MTH(5:2)
C26229                 IF WS-BH-REV-MTH  > LS-CURR-REVENUE-MONTH        
C26229                    MOVE WS-BH-REV-MTH       TO WS-YEAR-MONTH3-NUM
C26229                    MOVE WS-YEAR-MONTH3-NUM  TO WS-YEAR-MONTH3    
C26229                    COMPUTE WS-MONTH3 = WS-MONTH3 - 1             
C26229                    IF WS-MONTH3 = 0                              
C26229                       MOVE 12               TO WS-MONTH3         
C26229                       COMPUTE WS-YEAR3 = WS-YEAR3 - 1            
C26229                    END-IF                                        
C26229                    MOVE WS-YEAR-MONTH3      TO WS-YEAR-MONTH3-NUM
C26229                    MOVE WS-YEAR-MONTH3-NUM  TO WS-BH-REV-MTH     
C26229                    MOVE WS-BH-REV-MTH(1:4)  TO                   
C26229                                            BH-DATE-PYMT-STRT(1:4)
C26229                    MOVE WS-BH-REV-MTH(5:2)  TO                   
C26229                                            BH-DATE-PYMT-STRT(6:2)
C26229                    MOVE BH-DATE-PYMT-STRT   TO BU-DATE-PYMT-STRT 
C26229                    PERFORM 8420-UPDATE-BUDGET-HIST THRU 8420-EXIT
C26229                    MOVE BU-ANNIVERSARY-DATE(1:4)                 
C26229                                             TO WS-BH-REV-MTH(1:4)
C26229                    MOVE BU-ANNIVERSARY-DATE(6:2)                 
C26229                                             TO WS-BH-REV-MTH(5:2)
C26229                    MOVE WS-BH-REV-MTH       TO WS-YEAR-MONTH3-NUM
C26229                    MOVE WS-YEAR-MONTH3-NUM  TO WS-YEAR-MONTH3    
C26229                    COMPUTE WS-MONTH3 = WS-MONTH3 - 1             
C26229                    IF WS-MONTH3 = 0                              
C26229                       MOVE 12               TO WS-MONTH3         
C26229                       COMPUTE WS-YEAR3 = WS-YEAR3 - 1            
C26229                    END-IF                                        
C26229                    MOVE WS-YEAR-MONTH3      TO WS-YEAR-MONTH3-NUM
C26229                    MOVE WS-YEAR-MONTH3-NUM  TO WS-BH-REV-MTH     
C26229                    MOVE WS-BH-REV-MTH(1:4)  TO                   
C26229                                          BU-ANNIVERSARY-DATE(1:4)
C26229                    MOVE WS-BH-REV-MTH(5:2)  TO                   
C26229                                          BU-ANNIVERSARY-DATE(6:2)
C26229                 END-IF                                           
C26229              END-IF                                              
C26229           END-IF                                                 
C26229*                                                                         
                 PERFORM 8713-UPDATE-BUDGET-PLAN  THRU 8713-EXIT        
           END-EVALUATE.                                                
                                                                        
       1263-EXIT.                                                       
            EXIT.                                                       
      /                                                                         
       1264-UPDATE-CONNECT-CHG.                                         
           SET WS-CCC-INDX TO +1.                                       
           SEARCH  WS-CONNECT-CHRG-DATA                                 
              AT END                                                    
                 MOVE 'CCC NOT FOUND FOR AC'                            
                   TO WS-MISC-MSG-TEXT                                  
PCR629           MOVE +137 TO WS-MISC-CATEGORY                          
                 MOVE +23 TO WS-MISC-MSG-LEN                            
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9910-MISC-ERROR THRU 9910-EXIT                 
              WHEN  WS-ACCOUNT-NO-CC (WS-CCC-INDX)                      
                       = WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX)             
                   AND WS-CCC-ITEM-ID-CC  (WS-CCC-INDX)                 
                       = WS-ITEM-ID-AC (WS-AR-DATA-INDX)                
T16564           MOVE LS-INPUT-DATE     TO CC-DATE-CCC-BILLED           
                 MOVE WS-LAST-UPDATE-TS-CC (WS-CCC-INDX)                
                   TO CC-LAST-UPDATE-TS                                 
T17931           IF WS-UPDATE-ACTION-IND-CC (WS-CCC-INDX) = 'I'         
T17931             MOVE WS-ACCOUNT-NO-CC (WS-CCC-INDX)                  
T17931               TO CC-ACCOUNT-NO                                   
T17931             MOVE WS-PYMT-PRIORITY-LVL-CC (WS-CCC-INDX)           
T17931               TO CC-PYMT-PRIORITY-LVL                            
T17931             MOVE WS-CCC-ITEM-ID-CC (WS-CCC-INDX)                 
T17931               TO CC-CCC-ITEM-ID                                  
T17931             MOVE WS-AMT-ORIG-ENTERED-CC (WS-CCC-INDX)            
T17931               TO CC-AMT-ORIG-ENTERED                             
T17931             MOVE WS-CODE-CCC-TYPE-CC (WS-CCC-INDX)               
T17931               TO CC-CODE-CCC-TYPE                                
T17931             MOVE WS-AMT-TAX-STATE-CC (WS-CCC-INDX)               
T17931               TO CC-AMT-TAX-STATE                                
T17931             MOVE WS-AMT-TAX-CITY-CC (WS-CCC-INDX)                
T17931               TO CC-AMT-TAX-CITY                                 
T17931             MOVE WS-AMT-TAX-XCISE-CC (WS-CCC-INDX)               
T17931               TO CC-AMT-TAX-XCISE                                
T17931             MOVE WS-AMT-TAX-OTHER-CC (WS-CCC-INDX)               
T17931               TO CC-AMT-TAX-OTHER                                
T17931             MOVE WS-AMT-TRANS-CC (WS-CCC-INDX)                   
T17931               TO CC-AMT-TRANS                                    
T17931             MOVE WS-DATE-CCC-BILLED-CC (WS-CCC-INDX)             
T17931               TO CC-DATE-CCC-BILLED                              
T17931             IF   CC-DATE-CCC-BILLED = SPACES                     
T17931               MOVE -1 TO WS-NULL-IND-17                          
T17931             END-IF                                               
T17931             MOVE WS-DATE-TRANS-CC (WS-CCC-INDX)                  
T17931               TO CC-DATE-TRANS                                   
T17931             MOVE WS-LAST-UPDATE-TS-CC (WS-CCC-INDX)              
T17931               TO CC-LAST-UPDATE-TS                               
T17931             MOVE WS-RCNCT-TYPE-NO-CC (WS-CCC-INDX)               
T17931               TO CC-RCNCT-TYPE-NO                                
T17931             PERFORM 8725-INSERT-CCC THRU 8725-EXIT               
T17931           ELSE                                                   
                   PERFORM 8720-UPDATE-CCC THRU 8720-EXIT               
T17391           END-IF                                                 
           END-SEARCH.                                                  
       1264-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       1266-UPD-PROJ-SHARE.                                             
ACT117     IF (WS-SHARE-STATUS-CD-PJ = WS-INACTIVE                      
ACT117        OR WS-SHARE-STATUS-CD-PJ = WS-ONE-TIME-CONTRIBUTION)      
T13274       AND WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX) = 0              
T13274       AND WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX) = 0              
T13274       AND WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX) = 0              
T13274       AND WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX) = 0              
ACT117       AND WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) = 0           
ACT117       AND WS-TOT-SUMM-UNBILLED-AC (WS-AR-DATA-INDX) = 0          
T5832         MOVE WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) TO AC-ACCOUNT-NO  
TP6117        MOVE WS-129                   TO AC-PYMT-PRIORITY-LVL     
              MOVE SPACE TO WS-CODE-PROJECT-SHARE                       
TP6117        PERFORM 8126-DELETE-AR-CNTL   THRU 8126-EXIT              
C35326        SET WS-PJS-DELETED            TO   TRUE                   
           END-IF                                                       
                                                                        
T5832      MOVE WS-TOT-PREV-AM-PJ        TO  PJ-TOT-PREV-AM             
T5832      MOVE WS-TOT-YTD-AM-PJ         TO  PJ-TOT-YTD-AM              
T5832      MOVE WS-SHARE-STATUS-CD-PJ    TO  PJ-SHARE-STATUS-CD         
T11624     MOVE WS-ACCT-TERM-DT-PJ       TO  PJ-ACCT-TERM-DT            
                                                                        
           PERFORM 8780-UPDATE-PJS THRU 8780-EXIT.                      
       1266-EXIT.                                                       
           EXIT.                                                        
      /                                                                *        
       1270-REMOVE-BUDGET.                                              
           MOVE WS-ACCOUNT-NO-AT  TO AC-ACCOUNT-NO                      
                                     BU-ACCOUNT-NO.                     
           MOVE WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) TO            
                   AC-PYMT-PRIORITY-LVL.                                
           MOVE WS-DELETE         TO                                    
                   WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX).           
           PERFORM 8126-DELETE-AR-CNTL THRU 8126-EXIT.                  
           MOVE 50                TO BU-PYMT-PRIORITY-LVL.              
           MOVE 1                 TO BU-BP-ITEM-ID.                     
           MOVE WS-AMT-MO-PYMT-BU TO BH-AMT-MO-PYMT.                    
           MOVE SPACES            TO BH-METHOD-OF-ESTIMATE.             
           MOVE 'D'               TO BH-CHANGE-REASON.                  
           MOVE 30                TO BH-REMARKS-LEN.                    
           MOVE WS-EPP-REMOVE-MSG TO BH-REMARKS-TEXT.                   
           PERFORM 7110-SELECT-BILLING-DET  THRU 7110-EXIT              
           PERFORM 5000-COMPUTE-FIELDS      THRU 5000-EXIT              
T16413     SET WS-EPP-DRP-AR-HLD-INDX TO WS-AR-DATA-INDX.               
T16413     PERFORM 5805-CALC-UTIL-BAL       THRU 5805-EXIT.             
T16413     SET WS-AR-DATA-INDX    TO WS-EPP-DRP-AR-HLD-INDX.            
T17335     MOVE BU-DATE-PYMT-STRT          TO WS-BU-DPS-TEMP.           
T17335     MOVE WS-REVENUE-MONTH       TO  WS-REVENUE-MONTH-HOLD.       
T17335     MOVE WS-REVENUE-MONTH-HOLD(1:4) TO WS-RM-CONSTRCT-YR.        
T17335     MOVE WS-REVENUE-MONTH-HOLD(5:2) TO WS-RM-CONSTRCT-MO.        
T17335     MOVE WS-DAY-ONE                 TO WS-RM-CONSTRCT-DY.        
T17335     MOVE WS-REVENUE-MONTH-CONSTRCT  TO BU-DATE-PYMT-STRT.        
           PERFORM 8717-INSERT-BUDGET-HIST  THRU 8717-EXIT.             
T17335     MOVE WS-BU-DPS-TEMP             TO BU-DATE-PYMT-STRT.        
           MOVE ZEROES            TO WS-ACCOUNT-NO-BU.                  
       1270-EXIT.                                                       
           EXIT.                                                        
T29815******************************************************************        
T29815* GET PROJECTED COST FOR EPP ACCOUNTS WITH CREDIT BALANCE THAT  **        
T29815* GO THRU ANNIVERSARY.                                          **        
T29815******************************************************************        
T29815*                                                                         
T29815 1280-GET-PROJECTED-COST.                                         
T29815*                                                                         
T29815     INITIALIZE WS-EPP-PROJ-COST.                                 
T29815     PERFORM VARYING WS-EPP-INDX FROM 1 BY 1                      
T29815             UNTIL WS-EPP-INDX > 4                                
ACT091      IF WS-CODE-UTIL-TYPE-EPP (WS-EPP-INDX) NOT = SPACES         
T29815        PERFORM VARYING WS-EPP-12-INDX FROM 1 BY 1                
T29815               UNTIL WS-EPP-12-INDX > 12                          
T29815           ADD WS-IC-NEW-AMOUNT-EPP ( WS-EPP-INDX, WS-EPP-12-INDX)
T29815               TO WS-EPP-PROJ-COST                                
T29815        END-PERFORM                                               
ACT091      END-IF                                                      
T29815     END-PERFORM.                                                 
T29815*                                                                         
T29815 1280-EXIT.                                                       
T29815     EXIT.                                                        
T29815******************************************************************        
T29815* CALCULATE AND UPDATE NEW EPP AMOUNT AND EPP ESTIMATE.         **        
T29815******************************************************************        
T29815*                                                                         
T29815 1285-CALC-EPP-AMT.                                               
T29815*                                                                         
T31345* DO NOT RE-CALCULATE THE EPP AMOUNT & ESTIMATE IF THE CREDIT BAL         
T31345* IS GREATER THAN THE PROJECTED COST.                                     
T31345*                                                                         
T29815      PERFORM 7060-GET-BUD-DATE-PYMT-STRT    THRU 7060-EXIT.      
T29815      IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T29815         MOVE BU-DATE-PYMT-STRT         TO BH-DATE-PYMT-STRT      
T29815         PERFORM 7070-GET-PREV-BUD-AMT       THRU 7070-EXIT       
T29815         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
A01433            IF WS-TOTAL-AR-BALANCE-AT < 0                         
A01433               COMPUTE WS-EPP-AMT  ROUNDED = (WS-EPP-PROJ-COST +  
A01433                       WS-TOTAL-AR-BALANCE-AT) / 12               
A01433            ELSE                                                  
A01433               COMPUTE WS-EPP-AMT ROUNDED = WS-EPP-PROJ-COST / 12 
A01433            END-IF                                                
T29815            COMPUTE WS-EPP-ESTIMATE ROUNDED = (WS-EPP-PROJ-COST + 
T29815                    WS-TOTAL-AR-BALANCE-AT - BH-AMT-MO-PYMT) / 12 
T29815            MOVE BH-AMT-MO-PYMT         TO WS-EPP-OFFER-AMOUNT-AT 
T29815            PERFORM 7080-GET-BUD-HIST-SEQ-NO THRU 7080-EXIT       
T29815            MOVE WS-EPP-AMT             TO WS-AMT-MO-PYMT-BRKDWN  
A01050                                         WS-EPP-FINAL-TOTAL-WBAL  
T29815            IF WS-AMT-MO-PMT-CNTS > 0                             
T29815               ADD 1                    TO WS-EPP-FINAL-TOTAL-WBAL
T29815            END-IF                                                
T29815            MOVE WS-EPP-FINAL-TOTAL-WBAL TO BH-AMT-MO-PYMT        
T29815                                            BU-AMT-MO-PYMT        
T29815                                            WS-AMT-MO-PYMT-BU     
T29815            MOVE WS-EPP-ESTIMATE         TO WS-AMT-MO-PYMT-BRKDWN 
A01050                                           WS-EPP-FINAL-TOTAL-WBAL
T29815            IF WS-AMT-MO-PMT-CNTS > 0                             
T29815               ADD 1                    TO WS-EPP-FINAL-TOTAL-WBAL
T29815            END-IF                                                
T29815            IF WS-ACCOUNT-NO-BE = WS-ACCOUNT-NO-AT AND            
T29815               WS-STATUS-CODE-BE = 'A'                            
T29815              MOVE WS-AMT-MO-PYMT-BU       TO BH-EPP-ESTIMATE     
T29815                                              BU-AMT-MO-PYMT-NEW  
T29815                                            WS-AMT-MO-PYMT-NEW-BU 
T29815            ELSE                                                  
T29815              MOVE WS-EPP-FINAL-TOTAL-WBAL TO BH-EPP-ESTIMATE     
T29815                                              BU-AMT-MO-PYMT-NEW  
T29815                                            WS-AMT-MO-PYMT-NEW-BU 
T29815            END-IF                                                
T29815            MOVE WS-TOTAL-AR-BALANCE-AT      TO                   
T29815                                         WS-AMT-MO-PYT-BAL-FWD-BU 
T29815                                         BU-AMT-MO-PYT-BAL-FWD    
T29815                                         BH-BALANCE-FORWARD       
T31345            IF (WS-TOTAL-AR-BALANCE-AT + WS-EPP-PROJ-COST) < 0    
T31345               MOVE ZERO                   TO BH-AMT-MO-PYMT      
T31345                                              BU-AMT-MO-PYMT      
T31345                                              WS-AMT-MO-PYMT-BU   
T31345                                              BH-EPP-ESTIMATE     
T31345                                              BU-AMT-MO-PYMT-NEW  
T31345                                            WS-AMT-MO-PYMT-NEW-BU 
T31345            END-IF                                                
T29815            PERFORM 8714-UPDATE-BUDGET-PLAN  THRU 8714-EXIT       
T29815            PERFORM 8715-UPDATE-BUDGET-HIST  THRU 8715-EXIT       
T29815          END-IF                                                  
T29815       END-IF.                                                    
T29815*                                                                         
T29815 1285-EXIT.                                                       
T29815     EXIT.                                                        
      *                                                                         
       1500-REFUNDS.                                                    
           MOVE WS-REFUND-ITEM-ID-RN (WS-RN-INDX)                       
             TO RN-REFUND-ITEM-ID                                       
           MOVE WS-REFUND-CHECK-NO-RN (WS-RN-INDX)                      
             TO RN-REFUND-CHECK-NO                                      
           MOVE WS-DEPOSIT-CERT-NO-RN (WS-RN-INDX)                      
             TO RN-DEPOSIT-CERT-NO                                      
T17240     MOVE WS-LOCAL-OFFICE-AT                                      
             TO RN-LOCAL-OFFICE                                         
           MOVE WS-AMT-REFUNDED-RN (WS-RN-INDX)                         
             TO RN-AMT-REFUNDED                                         
           MOVE WS-DATE-REFUNDED-RN (WS-RN-INDX)                        
             TO RN-DATE-REFUNDED                                        
           MOVE WS-REQUEST-DT-RN (WS-RN-INDX)                           
             TO RN-REQUEST-DT                                           
           MOVE WS-CLEARED-DT-RN (WS-RN-INDX)                           
             TO RN-CLEARED-DT                                           
           MOVE WS-DATE-CHECK-VOIDED-RN (WS-RN-INDX)                    
             TO RN-DATE-CHECK-VOIDED                                    
           MOVE WS-STOP-REQUEST-DT-RN (WS-RN-INDX)                      
             TO RN-STOP-REQUEST-DT                                      
           MOVE WS-STOP-CONFIRM-DT-RN (WS-RN-INDX)                      
             TO RN-STOP-CONFIRM-DT                                      
           MOVE WS-CHECK-REMAIL-DT-RN (WS-RN-INDX)                      
             TO RN-CHECK-REMAIL-DT                                      
           MOVE WS-CHECK-STATUS-CD-RN (WS-RN-INDX)                      
             TO RN-CHECK-STATUS-CD                                      
           MOVE WS-CHECK-ISS-REAS-CD-RN (WS-RN-INDX)                    
             TO RN-CHECK-ISS-REAS-CD                                    
           MOVE WS-REISSUED-DATE-RN (WS-RN-INDX)                        
             TO RN-REISSUED-DATE                                        
           MOVE WS-ORIGINAL-CHECK-NO-RN (WS-RN-INDX)                    
             TO RN-ORIGINAL-CHECK-NO                                    
           MOVE WS-RETURNED-REASON-RN (WS-RN-INDX)                      
             TO RN-RETURNED-REASON                                      
           MOVE WS-MANUAL-INDICATOR-RN (WS-RN-INDX)                     
             TO RN-MANUAL-INDICATOR                                     
           MOVE WS-USER-ID-APPRVD-BY-RN (WS-RN-INDX)                    
             TO RN-USER-ID-APPRVD-BY                                    
           MOVE WS-REFUND-STATUS-DT-RN (WS-RN-INDX)                     
             TO RN-REFUND-STATUS-DT                                     
           MOVE WS-USER-ID-RQSTED-BY-RN (WS-RN-INDX)                    
             TO RN-USER-ID-RQSTED-BY                                    
           MOVE WS-ACCOUNT-NO-RN (WS-RN-INDX)                           
             TO RN-ACCOUNT-NO                                           
           MOVE WS-RETURNED-DATE-RN (WS-RN-INDX)                        
             TO RN-RETURNED-DATE                                        
           MOVE WS-DATE-APPROPRIATED-RN (WS-RN-INDX)                    
             TO RN-DATE-APPROPRIATED                                    
           MOVE WS-DATE-ESCHEATED-RN (WS-RN-INDX)                       
             TO RN-DATE-ESCHEATED                                       
           MOVE WS-DATE-CANCELLED-RN (WS-RN-INDX)                       
             TO RN-DATE-CANCELLED                                       
           MOVE WS-PANEL-NO-RN (WS-RN-INDX)                             
             TO RN-PANEL-NO                                             
           MOVE WS-ADDRESS-ID-RN (WS-RN-INDX)                           
             TO RN-ADDRESS-ID                                           
           MOVE WS-TRANS-HIST-SEQ-NO-RN (WS-RN-INDX)                    
             TO RN-TRANS-HIST-SEQ-NO                                    
           MOVE WS-ESCHEAT-RETURN-DT-RN (WS-RN-INDX)                    
             TO RN-ESCHEAT-RETURN-DT                                    
           MOVE WS-ESCHEAT-VERIFY-DT-RN (WS-RN-INDX)                    
             TO RN-ESCHEAT-VERIFY-DT                                    
           MOVE WS-COMMENTS-RN (WS-RN-INDX)                             
             TO RN-COMMENTS.                                            
           PERFORM 8910-INSERT-CSS-REFUND THRU 8910-EXIT.               
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
P00453******************************************************************        
P00453* 1510-PROCESS-PREPAY-HIST                                       *        
P00453******************************************************************        
P00453*                                                                         
P00453 1510-PROCESS-PREPAY-HIST.                                        
P00453*                                                                         
P00453     MOVE WS-ACCOUNT-NO-PK (WS-PK-INDX)                           
P00453                                       TO PK-ACCOUNT-NO.          
P00453     MOVE WS-PREPAY-HIST-SEQ-TS-PK (WS-PK-INDX)                   
P00453                                       TO PK-PREPAY-HIST-SEQ-TS.  
P00453* For PRP initial bills, override estimated rev mnth with billing         
P00453* rev mnth to present PRP statement correctly                             
P00453* Populate PRP Tran Bal to correct correct presentation issues            
P00453* when payment received prior to initial bill                             
P00453     IF WS-PREPAY-BILL-TYPE-PK (WS-PK-INDX) = '1'                 
P00453        MOVE LS-CURR-REVENUE-MONTH     TO                         
P00453                                 WS-REVENUE-MONTH-PK (WS-PK-INDX) 
P00453        COMPUTE WS-PLAN-ACCT-BAL-AM-PK (WS-PK-INDX) =             
P00453           WS-TOTAL-AR-BALANCE-AT - WS-EST-BILL-AM-PK (WS-PK-INDX)
P00453     END-IF.                                                      
P00453     MOVE WS-REVENUE-MONTH-PK (WS-PK-INDX)                        
P00453                                       TO PK-REVENUE-MONTH.       
P00453     MOVE WS-EST-METHOD-CD-PK (WS-PK-INDX)                        
P00453                                       TO PK-EST-METHOD-CD.       
P00453     MOVE WS-EST-NO-UNITS-PK (WS-PK-INDX)                         
P00453                                       TO PK-EST-NO-UNITS.        
P00453     MOVE WS-EST-UNIT-PRICE-AM-PK (WS-PK-INDX)                    
P00453                                       TO PK-EST-UNIT-PRICE-AM.   
P00453     MOVE WS-EST-ADDL-CHARGE-AM-PK (WS-PK-INDX)                   
P00453                                       TO PK-EST-ADDL-CHARGE-AM.  
P00453     MOVE WS-EST-CUSTSVC-CHG-AM-PK (WS-PK-INDX)                   
P00453                                       TO PK-EST-CUSTSVC-CHG-AM.  
P00453     MOVE WS-EST-MISC-CHARGE-AM-PK (WS-PK-INDX)                   
P00453                                       TO PK-EST-MISC-CHARGE-AM.  
P00453     MOVE WS-EST-CONNECT-CHG-AM-PK (WS-PK-INDX)                   
P00453                                       TO PK-EST-CONNECT-CHG-AM.  
P00453     MOVE WS-EST-BILL-AM-PK (WS-PK-INDX)                          
P00453                                       TO PK-EST-BILL-AM.         
P00453     MOVE WS-NET-BILL-ADJ-AM-PK (WS-PK-INDX)                      
P00453                                       TO PK-NET-BILL-ADJ-AM.     
P00453     MOVE WS-ARREARS-AMT-PK (WS-PK-INDX)                          
P00453                                       TO PK-ARREARS-AMT.         
P00453     MOVE WS-BILLED-AMT-PK (WS-PK-INDX)                           
P00453                                       TO PK-BILLED-AMT.          
P00453     MOVE WS-REMARKS-PK (WS-PK-INDX)                              
P00453                                       TO PK-REMARKS.             
P00453     MOVE WS-PLAN-ACCT-BAL-AM-PK (WS-PK-INDX)                     
P00453                                       TO PK-PLAN-ACCT-BAL-AM.    
P00453     MOVE WS-BILL-VARIANCE-AM-PK (WS-PK-INDX)                     
P00453                                       TO PK-BILL-VARIANCE-AM.    
P00453*                                                                         
P00453 1510-EXIT.                                                       
P00453     EXIT.                                                        
P00453*                                                                         
      ******************************************************************        
      * 5000-COMPUTE-FIELDS                                            *        
      ******************************************************************        
       5000-COMPUTE-FIELDS.                                             
                                                                        
           MOVE WS-ANNIVERSARY-DATE-BU TO WS-ANNIVERSARY-DATE.          
           MOVE WS-AD-MONTH          TO WS-AD-MONTH-X.                  
           MOVE WS-AD-YEAR           TO WS-AD-YEAR-X.                   
           MOVE WS-AD-MONTH-RED      TO WS-MONTH1.                      
           MOVE WS-AD-YEAR-RED       TO WS-YEAR1.                       
           MOVE WS-REVENUE-MONTH     TO WS-REVENUE-MONTH-X.             
           MOVE WS-REVENUE-MONTH-X   TO WS-YEAR-MONTH2.                 
           IF WS-MONTH2 = 12 AND WS-YEAR1 = WS-YEAR2 + 2                
              ADD  1                    TO WS-MONTH2
           END-IF.                   
           IF WS-MONTH2 > 12                                            
              COMPUTE WS-MONTH2 = WS-MONTH2 - 12                        
              COMPUTE WS-YEAR2  = WS-YEAR2 + 1                          
           END-IF.                                                      
           IF WS-YEAR1 > WS-YEAR2                                       
              ADD +12 TO WS-MONTH1                                      
           END-IF.                                                      
           COMPUTE BH-EPP-MTHS-RMNG-QT = WS-MONTH1 - WS-MONTH2.         
       5000-EXIT.                                                       
           EXIT.                                                        
T5502  5800-CREATE-BILL-HEADER.                                         
T5502      INITIALIZE DCLCSS-BILLING-HDR                                
T5502      MOVE WS-NEXT-BILL-NO-CALC      TO BI-BILL-NO                 
T5502                                        WS-NXT-BILL-NO-AT.         
T5502      MOVE WS-ACCOUNT-NO-BI          TO BI-ACCOUNT-NO.             
T5502      MOVE WS-PREMISE-NO-BI          TO BI-PREMISE-NO.             
T5502      MOVE WS-CUSTOMER-NO-AT         TO BI-CUSTOMER-NO.            
T5502      MOVE WS-COMPANY-NO-AT          TO BI-COMPANY-NO.             
T5502      MOVE WS-ACTIVE                 TO BI-CODE-BILL-STATUS        
T10723     IF WS-CODE-ACCT-STAT-AT = WS-FINAL-AT                        
T10723        MOVE WS-FINAL-AT TO BI-CODE-BILL-TYPE                     
T23947        IF WS-OFF-CYCLE-REBILL                                    
T23947           IF WS-ACCT-FINALED-DT-AT EQUAL SPACES OR LOW-VALUES    
T23947              MOVE WS-REGULAR-BILL TO BI-CODE-BILL-TYPE           
T23947           END-IF                                                 
T23947        END-IF                                                    
T10723     ELSE                                                         
T5502         MOVE WS-REGULAR-BILL        TO BI-CODE-BILL-TYPE          
T10723     END-IF.                                                      
T5502      MOVE WS-REGULAR-BILL           TO BI-CODE-BILL-REASON.       
T5502      MOVE SPACES                    TO BI-CODE-SPCL-BILL.         
T5502      MOVE WS-PREM-ACCT-SEQ-NO-PR    TO BI-PREM-ACCT-SEQ-NO.       
T5502      PERFORM 8400-INSERT-BILLING-HDR THRU 8400-EXIT.              
T5502  5800-EXIT.                                                       
T5502      EXIT.                                                        
      *                                                                         
T16413***************************************************************           
T16413* COMPUTE THE UTILITY BALANCE WHEN DROPPING CUSTOMER FROM EPP *           
T16413***************************************************************           
T16413 5805-CALC-UTIL-BAL.                                              
T16413     MOVE ZERO TO BH-UTILITY-BALANCE.                             
T16413     PERFORM VARYING WS-AR-DATA-INDX FROM 1 BY 1                  
P00097       UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY                    
T16413          OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZERO            
T16413        IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 40 OR 45   
T16413           ADD WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX) TO           
T16413               BH-UTILITY-BALANCE                                 
T16413           ADD WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX) TO           
T16413               BH-UTILITY-BALANCE                                 
T16413           ADD WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX) TO           
T16413               BH-UTILITY-BALANCE                                 
T16413        ELSE                                                      
T16413           CONTINUE                                               
T16413        END-IF                                                    
T16413     END-PERFORM.                                                 
T16413                                                                  
T16413 5805-EXIT.                                                       
T16413     EXIT.                                                        
      *                                                                         
A01355*****************************************************************         
A01355*                                                               *         
A01355* 6510-MOVE-TRANS-HDR-DETAILS.                                  *         
A01355*****************************************************************         
A01355 6510-MOVE-TRANS-HDR-DETAILS.                                     
A01355                                                                  
A01355     PERFORM 7240-SELECT-MH-DATE-TIME      THRU 7240-EXIT.        
A01355     MOVE 'F'                           TO MH-CODE-TRAN-TYPE.     
A01355     MOVE SPACES                        TO MH-RESP-AREA-ID.       
A01355     MOVE WS-ACCOUNT-NO-AT              TO MH-ACCOUNT-NO.         
A03175     MOVE ZERO                          TO MH-CUSTOMER-NO.        
A01355     MOVE ZERO                          TO MH-PREMISE-NO.         
A01355     MOVE 'SYSTEM'                      TO MH-USER-ID.            
A01355     MOVE 'SCSCA110B'                   TO MH-APPL-PROGRAM-ID.    
A01355                                                                  
A01355 6510-EXIT.                                                       
A01355     EXIT.                                                        
A01355                                                                  
A01355******************************************************************        
A01355*  6550-MOVE-CR-TRAN-HIST                                        *        
A01355******************************************************************        
A01355 6550-MOVE-CR-TRAN-HIST.                                          
A01355*                                                                         
A01355     MOVE MH-TRANS-HIST-SEQ-NO             TO                     
P00399                                           MI-TRANS-HIST-SEQ-NO.  
P00399     IF SEB-DATABASE                                              
P00399        MOVE WS-ARREARS-HIST-CZ(1:12)      TO WS-ARREARS-HIST-SEB 
P00399        MOVE WS-DISCONNECT-HIST-CZ(1:12)   TO WS-DISCONNECT-HIST  
P00399        MOVE WS-DISC-EXCEPTN-HIST-CZ(1:12) TO WS-DISC-EXCEPTN-HIST
P00399        MOVE WS-CRED-GRP-MAINT-DESC-SEB    TO MH-TRAN-COMMENT-TEXT
P00399     ELSE                                                         
P00399        EVALUATE WS-ACCOUNT-TYPE-CODE-AT                          
P00399           WHEN 'C'                                               
P00399                MOVE WS-COMMER-MONTHS      TO WS-MAX-MONTH        
P00399           WHEN 'I'                                               
P00399                MOVE WS-INDUST-MONTHS      TO WS-MAX-MONTH        
P00399           WHEN OTHER                                             
P00399                MOVE WS-RESIDENT-MONTHS    TO WS-MAX-MONTH        
P00399        END-EVALUATE                                              
P00399        MOVE WS-ARREARS-HIST-CZ(1:WS-MAX-MONTH)                   
P00399                                           TO WS-ARREARS-HIST     
A01355        MOVE WS-CRED-GRP-MAINT-DESC        TO MH-TRAN-COMMENT-TEXT
P00399     END-IF                                                       
A01355     MOVE LENGTH OF MH-TRAN-COMMENT-TEXT   TO MH-TRAN-COMMENT-LEN.
A01355     MOVE 1                                TO WS-TRAN-APPL-NO.    
A01355     MOVE WS-TRAN-APPL-NO                  TO MI-TRAN-APPL-NO.    
A01355     MOVE WS-CRED-GROUP-DESC               TO MI-COLUMN-DESC.     
A01433     MOVE '33'                             TO MI-TABLE-ID.        
A01355     MOVE WS-OLD-CREDIT-GROUP              TO                     
P00399                                         MI-PRV-COLUMN-VALUE-TEXT.
A01355     MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT TO                   
A01355                                         MI-PRV-COLUMN-VALUE-LEN. 
A01355     MOVE WS-CREDIT-GROUP-AT               TO                     
P00399                                         MI-CHG-COLUMN-VALUE-TEXT.
A01355     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
A01355                                           TO                     
P00399                                         MI-CHG-COLUMN-VALUE-LEN. 
A01355     PERFORM 6560-LOAD-MNT-TRANS-HIST     THRU 6560-EXIT.         
A01355     ADD 1                                 TO WS-TRAN-APPL-NO.    
A01355                                                                  
A01355     IF WS-OLD-CR-GRP-EFFECT-DT > SPACES                          
A01355        MOVE WS-TRAN-APPL-NO               TO MI-TRAN-APPL-NO     
A01355        MOVE WS-EFFECT-DT-DESC             TO MI-COLUMN-DESC      
A01355        MOVE SPACES                        TO MI-TABLE-ID         
A01355        MOVE WS-OLD-CR-GRP-EFFECT-DT       TO                     
P00399                                         MI-PRV-COLUMN-VALUE-TEXT 
A01355        MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT TO                
A01355                                         MI-PRV-COLUMN-VALUE-LEN  
A01355        IF WS-CR-GRP-EFFECT-DT-CZ > SPACES                        
A01355           MOVE WS-CR-GRP-EFFECT-DT-CZ     TO                     
A01355                                         MI-CHG-COLUMN-VALUE-TEXT 
A01355        ELSE                                                      
A01355           MOVE '*DELETED*'                TO                     
P00399                                         MI-CHG-COLUMN-VALUE-TEXT 
A01355        END-IF                                                    
A01355        MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT TO                
A01355                                         MI-CHG-COLUMN-VALUE-LEN  
A01355        PERFORM 6560-LOAD-MNT-TRANS-HIST     THRU 6560-EXIT       
A01355     END-IF.                                                      
A01355                                                                  
A01355 6550-EXIT.                                                       
A01355     EXIT.                                                        
A01355*****************************************************************         
A01355*                                                               *         
A01355* 6560-LOAD-MNT-TRANS-HIST.                                     *         
A01355*****************************************************************         
A01355 6560-LOAD-MNT-TRANS-HIST.                                        
A01355                                                                  
A01355     IF MI-TRAN-APPL-NO EQUAL 1                                   
A01355        PERFORM 8970-INSERT-MNT-TRANS-HIST THRU 8970-EXIT         
A01355        PERFORM 8980-INSERT-MT-TRN-HST-DET THRU 8980-EXIT         
A01355     ELSE                                                         
A01355        PERFORM 8980-INSERT-MT-TRN-HST-DET THRU 8980-EXIT         
A01355     END-IF.                                                      
A01355                                                                  
A01355 6560-EXIT.                                                       
A01355     EXIT.                                                        
A01355                                                                  
T12094 6709A-NON-UTILITY-PROCESS.                                       
T12094     PERFORM 6715A-SELECT-TOTAL-UTIL THRU 6715A-EXIT.             
T12094     IF WS-PAR-AMT-TOT-UTL <= 0                                   
T12094        MOVE PROGRAM-NAME TO WS-NON-UTIL-PROG                     
T12094        PERFORM 5500-CHECK-NON-UTIL THRU 5500-CHECK-NON-UTIL-EXIT 
T12094        IF NON-UTIL-REC-FAILED  OR                                
T12094           NON-UTIL-GUAR-FAILED OR                                
T27284           NON-UTIL-SUB-FAILED  OR                                
T27284           NON-UTIL-PJS-FAILED                                    
T12094           NEXT SENTENCE                                          
T12094        ELSE                                                      
T12094           PERFORM 6709B-WRITE-FINAL-BILL-WQ  THRU 6709B-EXIT     
T14428           MOVE WS-PULL-BILL TO WS-CODE-TEMP-BILL-AT              
T12094        END-IF                                                    
T12094     END-IF.                                                      
T12094 6709A-EXIT.                                                      
T12094     EXIT.                                                        
T12094*                                                                         
T12094 6709B-WRITE-FINAL-BILL-WQ.                                       
T12094     PERFORM 6709C-ADD-DELIN-DAYS   THRU 6709C-EXIT.              
ACT037     IF LS-CURR-WQ-ITEM = 50                                      
ACT037        DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
ACT037        DISPLAY 'PROCESSING TERMINATED'                           
ACT037        MOVE 16 TO RETURN-CODE                                    
ACT037        PERFORM 9999-BAIL-OUT THRU 9999-EXIT                      
ACT037     ELSE                                                         
ACT037        ADD 1 TO LS-CURR-WQ-ITEM                                  
ACT037        SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
ACT037*                                                                 03444000
ACT037        MOVE 125     TO WS-CATEGORY-ID-WF(WS-BILL-WQ-INDX)        
ACT037        MOVE 'N'     TO WS-PRIORITY-WF (WS-BILL-WQ-INDX)          
ACT037        MOVE '4'     TO WS-ROUTE-CATEGORY-WF(WS-BILL-WQ-INDX)     
ACT037        MOVE +52     TO WS-COMMENTS-LEN-WF(WS-BILL-WQ-INDX)       
ACT037        MOVE WS-PAR-NONUTL-FINALBILL                              
ACT037                     TO WS-COMMENTS-TEXT-WF(WS-BILL-WQ-INDX)      
ACT037        MOVE WS-PAR-HOLD-DATE                                     
ACT037          TO WS-DATE-REQUIRED-WF (WS-BILL-WQ-INDX)                
ACT037        MOVE 'SCSCA113' TO WS-CREATED-BY-WF (WS-BILL-WQ-INDX)     
ACT037     END-IF.                                                      
T12094 6709B-EXIT.                                                      
T12094     EXIT.                                                        
T12094*                                                                         
T12094 6709C-ADD-DELIN-DAYS.                                            
P00399     MOVE WS-DAY-NU-FBPAID         TO WS-PAR-X-BUS-DAYS-FOUND.    
T12094     MOVE LS-INPUT-DATE            TO WS-PAR-HOLD-DATE.           
T12094     PERFORM 6709D-GET-X-FUTURE-BUS-DAYS   THRU 6709D-EXIT        
T12094         UNTIL WS-PAR-DAY-COUNTER EQUAL WS-PAR-X-BUS-DAYS-FOUND.  
T12094 6709C-EXIT.                                                      
T12094     EXIT.                                                        
T12094*                                                                         
T12094 6709D-GET-X-FUTURE-BUS-DAYS.                                     
T12094     PERFORM 6709E-GET-NEXT-DAY    THRU 6709E-EXIT.               
T12094     EVALUATE TRUE                                                
T12094        WHEN WS-PAR-DAY EQUAL 6 OR WS-PAR-DAY EQUAL ZEROES        
T12094            CONTINUE                                              
T12094        WHEN OTHER                                                
T12094            MOVE WS-PAR-HOLD-DATE       TO J8-HOLIDAY-DT          
T12094            PERFORM 6709F-SELECT-HOLIDAY    THRU 6709F-EXIT       
T12094            IF WS-PAR-HOLIDAY-EXISTS = 'Y'                        
T12094               CONTINUE                                           
T12094            ELSE                                                  
T12094               ADD 1 TO WS-PAR-DAY-COUNTER                        
T12094            END-IF                                                
T12094     END-EVALUATE.                                                
T12094 6709D-EXIT.                                                      
T12094     EXIT.                                                        
T12094*                                                                         
T12094 6709E-GET-NEXT-DAY.                                              
T34800*PERFORMANCE ENHANCEMENT CHANGE - COMMENTED CSS_MODEL_SQL AND     15025205
T34800*ADDED THE SET COMMAND                                            15025205
T12094     EXEC SQL                                                     
T34800        SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-PAR-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PAR-HOLD-DATE
              ) <> 0) OR (LEN(:WS-PAR-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-PAR-HOLD-DATE
              ), CONVERT(DATE, :WS-PAR-HOLD-DATE) ) ),
              CIS.DAYS (DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                      :WS-PAR-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PAR-HOLD-DATE
              ) <> 0) OR (LEN(:WS-PAR-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-PAR-HOLD-DATE
              ), CONVERT(DATE, :WS-PAR-HOLD-DATE) ) ))    
T34800        - (CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                      :WS-PAR-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PAR-HOLD-DATE
              ) <> 0) OR (LEN(:WS-PAR-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-PAR-HOLD-DATE
              ), CONVERT(DATE, :WS-PAR-HOLD-DATE) ) ))/7 * 7)
            INTO
              :WS-PAR-HOLD-DATE,
              :WS-PAR-DAY 
T12094     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     15025207
MFA-TR*       SET :WS-PAR-HOLD-DATE = DATE(:WS-PAR-HOLD-DATE) + 1 DAYS  15025208
MFA-TR*       ,:WS-PAR-DAY = DAYS (DATE(:WS-PAR-HOLD-DATE) + 1 DAYS)    15025209
MFA-TR*       - (INTEGER(DAYS(DATE(:WS-PAR-HOLD-DATE) + 1 DAYS)/7) * 7) 15025210
MFA-TR*    END-EXEC.                                                    15025214

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T12094     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T12094     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T12094        NEXT SENTENCE                                             
T12094     ELSE                                                         
T12094        MOVE 'MS'                 TO WS-DB2-TABLE-ID              
T12094        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
T12094        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T12094        MOVE '113'                TO WS-DB2-MODULE-ID             
T12094        MOVE '6709E'              TO WS-DB2-PARAGRAPH             
T12094        MOVE WS-PAR-HOLD-DATE     TO WS-DB2-KEY-1N                
T12094        MOVE 12 TO RETURN-CODE                                    
T12094        PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
T12094     END-IF.                                                      
T12094 6709E-EXIT.                                                      
T12094     EXIT.                                                        
T12094*                                                                         
T12094 6709F-SELECT-HOLIDAY.                                            
T12094     MOVE 'N'    TO WS-PAR-HOLIDAY-EXISTS.                        
T12094     EXEC SQL                                                     
T12094        SELECT DISTINCT ('Y')                                     
T12094          INTO :WS-PAR-HOLIDAY-EXISTS                             
T12094          FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                          
T12094         WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                        
T34800                                                           
P00399                                                     
T12094     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15024669
MFA-TR*       SELECT DISTINCT ('Y')                                     15024670
MFA-TR*         INTO :WS-PAR-HOLIDAY-EXISTS                             15024671
MFA-TR*         FROM CSS_HOLIDAY                                        15024672
MFA-TR*        WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                        15024673
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 67091                                                    
MFA-TR*    END-EXEC.                                                    15024674

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T12094     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T12094     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T12094        NEXT SENTENCE                                             
T12094     ELSE                                                         
T12094        MOVE 'J8'                 TO WS-DB2-TABLE-ID              
T12094        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
T12094        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T12094        MOVE '113'                TO WS-DB2-MODULE-ID             
T12094        MOVE '6709F'              TO WS-DB2-PARAGRAPH             
T12094        MOVE J8-HOLIDAY-DT        TO WS-DB2-KEY-1N                
T12094        MOVE 12 TO RETURN-CODE                                    
T12094        PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
T12094     END-IF.                                                      
T12094 6709F-EXIT.                                                      
T12094     EXIT.                                                        
T12094*                                                                         
T12094 6715A-SELECT-TOTAL-UTIL.                                         
T12094     MOVE WS-ACCOUNT-NO-AT TO AT-ACCOUNT-NO.                      
T12094     MOVE ZEROES TO WS-PAR-AMT-TOT-UTL                            
T12094                    WS-PAR-AMT-UTL-00                             
T12094                    WS-PAR-AMT-UTL-30                             
T12094                    WS-PAR-AMT-UTL-60                             
T12094                    WS-PAR-AMT-UTL-90                             
T12094                    WS-PAR-AMT-UTL-CR.                            
T12094     EXEC SQL                                                     
T12094         SELECT SUM(AMT_AR_DAY_00),                               
T12094                SUM(AMT_AR_DAY_30),                               
T12094                SUM(AMT_AR_DAY_60),                               
T12094                SUM(AMT_AR_DAY_90),                               
T12094                SUM(AMT_UNUSED_CR),                               
T12094                SUM(AMT_AR_DAY_00 +                               
T12094                    AMT_AR_DAY_30 +                               
T12094                    AMT_AR_DAY_60 +                               
T12094                    AMT_AR_DAY_90 +                               
T12094                    AMT_UNUSED_CR)                                
T12094           INTO :WS-PAR-AMT-UTL-00 :WS-PAR-NULL-IND,               
T12094                :WS-PAR-AMT-UTL-30 :WS-PAR-NULL-IND-1,             
T12094                :WS-PAR-AMT-UTL-60 :WS-PAR-NULL-IND-2,             
T12094                :WS-PAR-AMT-UTL-90 :WS-PAR-NULL-IND-3,             
T12094                :WS-PAR-AMT-UTL-CR :WS-PAR-NULL-IND-4,             
T12094                :WS-PAR-AMT-TOT-UTL :WS-PAR-NULL-IND-5             
T12094           FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
T12094          WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
T27284            AND PYMT_PRIORITY_LVL IN (040, 045, 100, 129)         
T12094            AND ITEM_ID           = 0                             
P00453                                                           
P00399                                                      
T12094         END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_AR_DAY_00),                                       
MFA-TR*               SUM(AMT_AR_DAY_30),                                       
MFA-TR*               SUM(AMT_AR_DAY_60),                                       
MFA-TR*               SUM(AMT_AR_DAY_90),                                       
MFA-TR*               SUM(AMT_UNUSED_CR),                                       
MFA-TR*               SUM(AMT_AR_DAY_00 +                                       
MFA-TR*                   AMT_AR_DAY_30 +                                       
MFA-TR*                   AMT_AR_DAY_60 +                                       
MFA-TR*                   AMT_AR_DAY_90 +                                       
MFA-TR*                   AMT_UNUSED_CR)                                        
MFA-TR*          INTO :WS-PAR-AMT-UTL-00:WS-PAR-NULL-IND,                       
MFA-TR*               :WS-PAR-AMT-UTL-30:WS-PAR-NULL-IND-1,                     
MFA-TR*               :WS-PAR-AMT-UTL-60:WS-PAR-NULL-IND-2,                     
MFA-TR*               :WS-PAR-AMT-UTL-90:WS-PAR-NULL-IND-3,                     
MFA-TR*               :WS-PAR-AMT-UTL-CR:WS-PAR-NULL-IND-4,                     
MFA-TR*               :WS-PAR-AMT-TOT-UTL:WS-PAR-NULL-IND-5                     
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL IN (040, 045, 100, 129)                 
MFA-TR*           AND ITEM_ID           = 0                                     
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 6715                                                    
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T12094     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T12094     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T12094        NEXT SENTENCE                                             
T12094     ELSE                                                         
T12094        MOVE 'AC'                 TO WS-DB2-TABLE-ID              
T12094        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
T12094        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T12094        MOVE '113'                TO WS-DB2-MODULE-ID             
T12094        MOVE '6715A'              TO WS-DB2-PARAGRAPH             
T12094        MOVE AC-ACCOUNT-NO        TO WS-DB2-KEY-1N                
T12094        MOVE 12 TO RETURN-CODE                                    
T12094        PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
T12094     END-IF.                                                      
T12094 6715A-EXIT.                                                      
T12094     EXIT.                                                        
      *****************************************************************         
      *                                                              **         
      *   5500-CHECK-NON-UTIL.                                       **         
      *                                                              **         
      *****************************************************************         
           EXEC SQL                                                             
T12094        INCLUDE CPD00312                                                  
           END-EXEC.                                                            
      *                                                                         
T11939 7000-SELECT-MSTSUB-ACCT.                                         
T11939     EXEC SQL                                                     
T11939        SELECT MST_ACCT_NO,                                       
T11939               SUB_ACCT_BLLD_OK                                   
T11939          INTO :MU-MST-ACCT-NO,                                   
T11939               :MU-SUB-ACCT-BLLD-OK                               
T11939          FROM CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                      
T11939         WHERE SUB_ACCT_NO  = :MU-SUB-ACCT-NO                     
T34800                                                           
P00399                                                      
T11939     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MST_ACCT_NO,                                               
MFA-TR*              SUB_ACCT_BLLD_OK                                           
MFA-TR*         INTO :MU-MST-ACCT-NO,                                           
MFA-TR*              :MU-SUB-ACCT-BLLD-OK                                       
MFA-TR*         FROM CSS_MSTSUB_ACCT                                            
MFA-TR*        WHERE SUB_ACCT_NO  = :MU-SUB-ACCT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11939     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
T11939     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T11939        CONTINUE                                                  
T11939     ELSE                                                         
T11939        MOVE 'MU'                 TO WS-DB2-TABLE-ID              
T11939        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
T11939        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T11939        MOVE '113'                TO WS-DB2-MODULE-ID             
T11939        MOVE '7000'               TO WS-DB2-PARAGRAPH             
T11939        MOVE MU-SUB-ACCT-NO       TO WS-DB2-KEY-1N                
T11939        MOVE 12 TO RETURN-CODE                                    
T11939        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
T11939     END-IF.                                                      
T11939 7000-EXIT.                                                       
T11939     EXIT.                                                        
      *                                                                         
P00399*****************************************************************         
P00399*                                                              **         
P00399*   7010-OPEN-DW.                                              **         
P00399*                                                              **         
P00399*****************************************************************         
P00399 7010-OPEN-DW.                                                    
P00399                                                                  
P00399     EXEC SQL                                                     
P00399        OPEN DELINQUENCY-CSR                                      
P00399     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00399                                                                  
P00399     IF SQLCODE NOT = SUCCESSFUL-CALL                             
P00399        MOVE 'C8'                 TO WS-DB2-TABLE-ID              
P00399        MOVE 'OPEN'               TO WS-DB2-FUNCTION              
P00399        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00399        MOVE '113'                TO WS-DB2-MODULE-ID             
P00399        MOVE '7010'               TO WS-DB2-PARAGRAPH             
P00399        MOVE LS-INPUT-DATE        TO WS-DB2-KEY-1                 
P00399        MOVE 16 TO RETURN-CODE                                    
P00399        PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
P00399     END-IF.                                                      
P00399                                                                  
P00399 7010-EXIT.                                                       
P00399     EXIT.                                                        
P00399*****************************************************************         
P00399*                                                              **         
P00399*   7012-FETCH-DW.                                             **         
P00399*                                                              **         
P00399*****************************************************************         
P00399 7012-FETCH-DW.                                                   
P00399                                                                  
P00399     EXEC SQL                                                     
P00399        FETCH DELINQUENCY-CSR                                     
P00399           INTO :C8-DELINQ-CD,                                    
P00399                :C8-DELINQ-VALUE,                                 
P00399                :C8-COMPANY-NO                                    
P00399     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00399                                                                  
P00399     IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
P00399        MOVE 'C8'                 TO WS-DB2-TABLE-ID              
P00399        MOVE 'FETCH'              TO WS-DB2-FUNCTION              
P00399        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00399        MOVE '113'                TO WS-DB2-MODULE-ID             
P00399        MOVE '7012'               TO WS-DB2-PARAGRAPH             
P00399        MOVE LS-INPUT-DATE        TO WS-DB2-KEY-1                 
P00399        MOVE 16 TO RETURN-CODE                                    
P00399        PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
P00399     END-IF.                                                      
P00399                                                                  
P00399 7012-EXIT.                                                       
P00399     EXIT.                                                        
P00399*****************************************************************         
P00399*                                                              **         
P00399*   7014-CLOSE-DW.                                             **         
P00399*                                                              **         
P00399*****************************************************************         
P00399 7014-CLOSE-DW.                                                   
P00399                                                                  
P00399     EXEC SQL                                                     
P00399        CLOSE DELINQUENCY-CSR                                     
P00399     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00399                                                                  
P00399     IF SQLCODE NOT = SUCCESSFUL-CALL                             
P00399        MOVE 'C8'                 TO WS-DB2-TABLE-ID              
P00399        MOVE 'CLOSE'              TO WS-DB2-FUNCTION              
P00399        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00399        MOVE '113'                TO WS-DB2-MODULE-ID             
P00399        MOVE '7014'               TO WS-DB2-PARAGRAPH             
P00399        MOVE LS-INPUT-DATE        TO WS-DB2-KEY-1                 
P00399        MOVE 16 TO RETURN-CODE                                    
P00399        PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
P00399     END-IF.                                                      
P00399                                                                  
P00399 7014-EXIT.                                                       
P00399     EXIT.                                                        
C26229*                                                                         
C26229 7050-SELECT-BUDGET-HIST.                                         
C26229*                                                                         
C26229     EXEC SQL                                                     
C26229         SELECT DATE_PYMT_STRT,                                   
C26229                REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
C26229           INTO :BH-DATE-PYMT-STRT,                               
C26229                :BH-LAST-UPDATE-TS                                
C26229           FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                     
C26229          WHERE ACCOUNT_NO     = :BH-ACCOUNT-NO                   
C26229            AND CHANGE_REASON  = 'S'                              
C26229            AND LAST_UPDATE_TS =                                  
C26229                (SELECT MAX(LAST_UPDATE_TS)                       
C26229                   FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)             
C26229                  WHERE ACCOUNT_NO    = :BH-ACCOUNT-NO            
C26229                    AND CHANGE_REASON = 'S')                      
P00453                                                           
P00399                                                      
C26229     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_PYMT_STRT,                                           
MFA-TR*               LAST_UPDATE_TS                                            
MFA-TR*          INTO :BH-DATE-PYMT-STRT,                                       
MFA-TR*               :BH-LAST-UPDATE-TS                                        
MFA-TR*          FROM CSS_BUDGET_HIST                                           
MFA-TR*         WHERE ACCOUNT_NO     = :BH-ACCOUNT-NO                           
MFA-TR*           AND CHANGE_REASON  = 'S'                                      
MFA-TR*           AND LAST_UPDATE_TS =                                          
MFA-TR*               (SELECT MAX(LAST_UPDATE_TS)                               
MFA-TR*                  FROM CSS_BUDGET_HIST                                   
MFA-TR*                 WHERE ACCOUNT_NO    = :BH-ACCOUNT-NO                    
MFA-TR*                   AND CHANGE_REASON = 'S')                              
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26229*                                                                         
C26229     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
C26229     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C26229        CONTINUE                                                  
C26229     ELSE                                                         
C26229        MOVE 'BH'                 TO WS-DB2-TABLE-ID              
C26229        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
C26229        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
C26229        MOVE '113'                TO WS-DB2-MODULE-ID             
C26229        MOVE '7050'               TO WS-DB2-PARAGRAPH             
C26229        MOVE BH-ACCOUNT-NO        TO WS-DB2-KEY-1N                
C26229        MOVE 12                   TO RETURN-CODE                  
C26229        PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
C26229     END-IF.                                                      
C26229*                                                                         
C26229 7050-EXIT.                                                       
C26229     EXIT.                                                        
C26229*                                                                         
T29815 7060-GET-BUD-DATE-PYMT-STRT.                                     
T29815*                                                                         
T29815     EXEC SQL                                                     
T29815         SELECT DATE_PYMT_STRT,                                   
T29815                REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
T29815           INTO :BU-DATE-PYMT-STRT,                               
T29815                :BU-LAST-UPDATE-TS                                
T29815           FROM CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                  
T29815          WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                
T29815            AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL         
T29815            AND BP_ITEM_ID        = :BU-BP-ITEM-ID                
P00453                                                           
P00399                                                      
T29815     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_PYMT_STRT,                                           
MFA-TR*               LAST_UPDATE_TS                                            
MFA-TR*          INTO :BU-DATE-PYMT-STRT,                                       
MFA-TR*               :BU-LAST-UPDATE-TS                                        
MFA-TR*          FROM CSS_BUDGET_PLAN BU                                        
MFA-TR*         WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL                 
MFA-TR*           AND BP_ITEM_ID        = :BU-BP-ITEM-ID                        
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7060                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T29815*                                                                         
T29815     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
T29815     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T29815        CONTINUE                                                  
T29815     ELSE                                                         
T29815        MOVE 'BU'                 TO WS-DB2-TABLE-ID              
T29815        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
T29815        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T29815        MOVE '113'                TO WS-DB2-MODULE-ID             
T29815        MOVE '7060'               TO WS-DB2-PARAGRAPH             
T29815        MOVE BU-ACCOUNT-NO        TO WS-DB2-KEY-1N                
T29815        MOVE 12                   TO RETURN-CODE                  
T29815        PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
T29815     END-IF.                                                      
T29815*                                                                         
T29815 7060-EXIT.                                                       
T29815     EXIT.                                                        
T29815*                                                                         
T29815 7070-GET-PREV-BUD-AMT.                                           
T34800* ADD 'T' IN SQL-  CHANGE_REASON  IN ('S', 'A', 'M', 'C','T'))            
T29815*                                                                         
T29815     EXEC SQL                                                     
T29815       SELECT AMT_MO_PYMT                                         
T29815         INTO :BH-AMT-MO-PYMT                                     
T29815         FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                       
T29815        WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO                  
T29815          AND PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL           
T29815          AND ITEM_ID           = :BH-ITEM-ID                     
T29815          AND BUD_HIST_SEQ_NO   =                                 
T29815            (SELECT MAX(B1.BUD_HIST_SEQ_NO)                       
T29815              FROM CSS_BUDGET_HIST B1 WITH(READUNCOMMITTED)               
T29815             WHERE B1.ACCOUNT_NO        = :BH-ACCOUNT-NO          
T29815               AND B1.PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL   
T29815               AND B1.ITEM_ID           = :BH-ITEM-ID             
T29815               AND B1.DATE_PYMT_STRT    < IIF(TRY_CONVERT(DATE, 
                                                     :BH-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BH-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BH-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BH-DATE-PYMT-STRT
              ), CONVERT(DATE, :BH-DATE-PYMT-STRT) )      
T34800               AND B1.CHANGE_REASON  IN ('S', 'A', 'M', 'C','T')) 
P00453                                                           
P00399                                                      
T29815     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT AMT_MO_PYMT                                                 
MFA-TR*        INTO :BH-AMT-MO-PYMT                                             
MFA-TR*        FROM CSS_BUDGET_HIST                                             
MFA-TR*       WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO                          
MFA-TR*         AND PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL                   
MFA-TR*         AND ITEM_ID           = :BH-ITEM-ID                             
MFA-TR*         AND BUD_HIST_SEQ_NO   =                                         
MFA-TR*           (SELECT MAX(B1.BUD_HIST_SEQ_NO)                               
MFA-TR*             FROM CSS_BUDGET_HIST B1                                     
MFA-TR*            WHERE B1.ACCOUNT_NO        = :BH-ACCOUNT-NO                  
MFA-TR*              AND B1.PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL           
MFA-TR*              AND B1.ITEM_ID           = :BH-ITEM-ID                     
MFA-TR*              AND B1.DATE_PYMT_STRT    < :BH-DATE-PYMT-STRT              
MFA-TR*              AND B1.CHANGE_REASON  IN ('S', 'A', 'M', 'C','T'))         
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7060                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T29815*                                                                         
T29815     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
T29815     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T29815        CONTINUE                                                  
T29815     ELSE                                                         
T29815        MOVE 'BH'                 TO WS-DB2-TABLE-ID              
T29815        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
T29815        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T29815        MOVE '113'                TO WS-DB2-MODULE-ID             
T29815        MOVE '7070'               TO WS-DB2-PARAGRAPH             
T29815        MOVE BH-ACCOUNT-NO        TO WS-DB2-KEY-1N                
T29815        MOVE 12                   TO RETURN-CODE                  
T29815        PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
T29815     END-IF.                                                      
T29815*                                                                         
T29815 7070-EXIT.                                                       
T29815     EXIT.                                                        
T29815*                                                                         
T29815 7080-GET-BUD-HIST-SEQ-NO.                                        
T29815*                                                                         
T29815     EXEC SQL                                                     
T29815       SELECT REPLACE(REPLACE(CONVERT(CHAR(26), BUD_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') BUD_HIST_SEQ_NO                        
T29815         INTO :BH-BUD-HIST-SEQ-NO                                 
T29815         FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                       
T29815        WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO                  
T29815          AND PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL           
T29815          AND ITEM_ID           = :BH-ITEM-ID                     
T29815          AND BUD_HIST_SEQ_NO   =                                 
T29815            (SELECT MAX(B1.BUD_HIST_SEQ_NO)                       
T29815              FROM CSS_BUDGET_HIST B1 WITH(READUNCOMMITTED)               
T29815             WHERE B1.ACCOUNT_NO        = :BH-ACCOUNT-NO          
T29815               AND B1.PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL   
T29815               AND B1.ITEM_ID           = :BH-ITEM-ID             
T29815               AND B1.CHANGE_REASON  ='A')                        
T34800                                                           
P00399                                                      
T29815     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT BUD_HIST_SEQ_NO                                             
MFA-TR*        INTO :BH-BUD-HIST-SEQ-NO                                         
MFA-TR*        FROM CSS_BUDGET_HIST                                             
MFA-TR*       WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO                          
MFA-TR*         AND PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL                   
MFA-TR*         AND ITEM_ID           = :BH-ITEM-ID                             
MFA-TR*         AND BUD_HIST_SEQ_NO   =                                         
MFA-TR*           (SELECT MAX(B1.BUD_HIST_SEQ_NO)                               
MFA-TR*             FROM CSS_BUDGET_HIST B1                                     
MFA-TR*            WHERE B1.ACCOUNT_NO        = :BH-ACCOUNT-NO                  
MFA-TR*              AND B1.PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL           
MFA-TR*              AND B1.ITEM_ID           = :BH-ITEM-ID                     
MFA-TR*              AND B1.CHANGE_REASON  ='A')                                
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T29815*                                                                         
T29815     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
T29815     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T29815        CONTINUE                                                  
T29815     ELSE                                                         
T29815        MOVE 'BH'                 TO WS-DB2-TABLE-ID              
T29815        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
T29815        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T29815        MOVE '113'                TO WS-DB2-MODULE-ID             
T29815        MOVE '7080'               TO WS-DB2-PARAGRAPH             
T29815        MOVE BH-ACCOUNT-NO        TO WS-DB2-KEY-1N                
T29815        MOVE 12                   TO RETURN-CODE                  
T29815        PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
T29815     END-IF.                                                      
T29815*                                                                         
T29815 7080-EXIT.                                                       
T29815     EXIT.                                                        
T29815*                                                                         
A01433******************************************************************        
A01433* 7090-GET-AMT-MO-PYMT                                           *        
A01433******************************************************************        
A01433*                                                                         
A01433 7090-GET-AMT-MO-PYMT.                                            
A01433*                                                                         
A01433     EXEC SQL                                                     
A01433         SELECT                                                   
A01433                AMT_MO_PYMT                                       
A01433           INTO                                                   
A01433                :BU-AMT-MO-PYMT                                   
A01433           FROM                                                   
A01433                CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                  
A01433          WHERE                                                   
A01433                ACCOUNT_NO        = :BU-ACCOUNT-NO                
A01433            AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL         
A01433            AND BP_ITEM_ID        = :BU-BP-ITEM-ID                
P00453                                                           
P00453                                                      
A01433     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*               AMT_MO_PYMT                                               
MFA-TR*          INTO                                                           
MFA-TR*               :BU-AMT-MO-PYMT                                           
MFA-TR*          FROM                                                           
MFA-TR*               CSS_BUDGET_PLAN BU                                        
MFA-TR*         WHERE                                                           
MFA-TR*               ACCOUNT_NO        = :BU-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL                 
MFA-TR*           AND BP_ITEM_ID        = :BU-BP-ITEM-ID                        
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7090                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01433*                                                                         
A01433     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
A01433*                                                                         
A01433     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01433        CONTINUE                                                  
A01433     ELSE                                                         
A01433        MOVE 'BU'                 TO WS-DB2-TABLE-ID              
A01433        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
A01433        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
A01433        MOVE '113'                TO WS-DB2-MODULE-ID             
A01433        MOVE '7090'               TO WS-DB2-PARAGRAPH             
A01433        MOVE BU-ACCOUNT-NO        TO WS-DB2-KEY-1N                
A01433        MOVE 12                   TO RETURN-CODE                  
A01433        PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
A01433     END-IF.                                                      
A01433*                                                                         
A01433 7090-EXIT.                                                       
A01433     EXIT.                                                        
T29815*                                                                         
       7100-SELECT-AR-CNTRL.                                            
           EXEC SQL                                                     
              SELECT 'Y',                                               
                     REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO :WS-AC-FOUND,                                      
                     :WS-LAST-UPDATE-TS-SUM                             
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
P00453                                                           
P00399                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y',                                                       
MFA-TR*              LAST_UPDATE_TS                                             
MFA-TR*         INTO :WS-AC-FOUND,                                              
MFA-TR*              :WS-LAST-UPDATE-TS-SUM                                     
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*          AND ITEM_ID           = :AC-ITEM-ID                            
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N' TO WS-AC-FOUND                                
              WHEN OTHER                                                
                 MOVE 'AC'                 TO WS-DB2-TABLE-ID           
                 MOVE 'SELECT'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '113'                TO WS-DB2-MODULE-ID          
                 MOVE '7100'               TO WS-DB2-PARAGRAPH          
                 MOVE AC-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE AC-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N             
                 MOVE AC-ITEM-ID           TO WS-DB2-KEY-3N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-EVALUATE.                                                
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
T12721 7105-SELECT-VALID-DETAIL.                                        
T12721     EXEC SQL                                                     
T12721        SELECT DISTINCT 'Y'                                       
T12721          INTO :WS-VALID-AC-FOUND                                 
T12721          FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
T12721         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
T12721           AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
T12721           AND ITEM_ID           > 0                              
P00453                                                           
P00399                                                      
T12721     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISTINCT 'Y'                                               
MFA-TR*         INTO :WS-VALID-AC-FOUND                                         
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*          AND ITEM_ID           > 0                                      
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7105                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T12721     EVALUATE SQLCODE                                             
T12721        WHEN SUCCESSFUL-CALL                                      
T12721           CONTINUE                                               
T12721        WHEN NOT-FOUND                                            
T12721           MOVE 'N' TO WS-VALID-AC-FOUND                          
T12721        WHEN OTHER                                                
T12721           MOVE 'AC'                 TO WS-DB2-TABLE-ID           
T12721           MOVE 'SELECT'             TO WS-DB2-FUNCTION           
T12721           MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
T12721           MOVE '113'                TO WS-DB2-MODULE-ID          
T12721           MOVE '7105'               TO WS-DB2-PARAGRAPH          
T12721           MOVE AC-ACCOUNT-NO        TO WS-DB2-KEY-1N             
T12721           MOVE AC-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N             
T12721           MOVE 12 TO RETURN-CODE                                 
T12721           PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
T12721     END-EVALUATE.                                                
T12721 7105-EXIT.                                                       
T12721     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-SELECT-BILLING-DET.                                       *        
      ******************************************************************        
       7110-SELECT-BILLING-DET.                                         
                                                                        
           EXEC SQL                                                     
              SELECT MAX(REVENUE_MONTH)                                 
                INTO :WS-REVENUE-MONTH :WS-REVENUE-MONTH-NULL            
                FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                 
T34800                                                           
P00399                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(REVENUE_MONTH)                                         
MFA-TR*         INTO :WS-REVENUE-MONTH:WS-REVENUE-MONTH-NULL                    
MFA-TR*         FROM CSS_BILLING_DET                                            
MFA-TR*        WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 71101                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-DB2-RETURN-CODE                           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-REVENUE-MONTH-NULL < 0 OR WS-REVENUE-MONTH = 0      
                 EXEC SQL                                               
                    SELECT MAX(REVENUE_MONTH)                           
                      INTO :WS-REVENUE-MONTH                            
                      FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                
T34800                                                           
P00399                                                     
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*          EXEC SQL                                                       
MFA-TR*             SELECT MAX(REVENUE_MONTH)                                   
MFA-TR*               INTO :WS-REVENUE-MONTH                                    
MFA-TR*               FROM CSS_BILLING_DET                                      
MFA-TR*             WITH UR                                                     
MFA-TR*             QUERYNO 71102                                               
MFA-TR*          END-EXEC                                                       

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                 MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                  
                                 WS-DB2-RETURN-CODE                     
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE 'BG'                 TO WS-DB2-TABLE-ID        
                    MOVE 'SELECT'             TO WS-DB2-FUNCTION        
                    MOVE '113'                TO WS-DB2-MODULE-ID       
                    MOVE '7110'               TO WS-DB2-PARAGRAPH       
                    MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N          
                    MOVE 12                   TO RETURN-CODE            
                    PERFORM 9900-SQL-ERROR    THRU 9900-EXIT            
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE 'BG'                 TO WS-DB2-TABLE-ID              
              MOVE 'SELECT'             TO WS-DB2-FUNCTION              
              MOVE '113'                TO WS-DB2-MODULE-ID             
              MOVE '7110'               TO WS-DB2-PARAGRAPH             
              MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE 12                   TO RETURN-CODE                  
              PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
A01355*****************************************************************         
A01355*                                                               *         
A01355* 7240-SELECT-MH-DATE-TIME.                                     *         
A01355*****************************************************************         
A01355 7240-SELECT-MH-DATE-TIME.                                        
A01355                                                                  
A01355     EXEC SQL                                                     
A01355        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                  
A01355     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*          ,:MH-DATE-TRANS        = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01355                                                                  
A01355     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
A01355                                          WS-DB2-RETURN-CODE.     
A01355                                                                  
A01355     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A01355        NEXT SENTENCE                                             
A01355     ELSE                                                         
A01355        MOVE 'MS'                      TO WS-DB2-TABLE-ID         
A01355        MOVE 'SET'                     TO WS-DB2-FUNCTION         
A01355        MOVE '113'                     TO WS-DB2-MODULE-ID        
A01355        MOVE '7240'                    TO WS-DB2-PARAGRAPH        
A01355        MOVE 12                        TO RETURN-CODE             
A01355        PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
A01355     END-IF.                                                      
A01355                                                                  
A01355 7240-EXIT.                                                       
A01355     EXIT.                                                        
                                                                        
P00399*****************************************************************         
P00399* 7300-LOAD-DELINQ-VALUES                                       *         
P00399*****************************************************************         
P00399 7300-LOAD-DELINQ-VALUES.                                         
P00399                                                                  
P00399     SET TB-CO-INDEX TO 1.                                        
P00399     SET TB-VAL-INDEX TO 1.                                       
P00399                                                                  
P00399     PERFORM UNTIL                                                
P00399       WS-COMPANY-NO-AT EQUAL                                     
P00399       WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX)           
P00399       OR TB-CO-INDEX > 5                                         
P00399                                                                  
P00399         IF WS-COMPANY-NO-AT EQUAL                                
P00399            WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX)      
P00399             NEXT SENTENCE                                        
P00399         ELSE                                                     
P00399             SET TB-CO-INDEX UP BY 1                              
P00399         END-IF                                                   
P00399                                                                  
P00399     END-PERFORM.                                                 
P00399                                                                  
P00399     PERFORM 7310-LOAD-DW-VARIABLE    THRU 7310-EXIT              
P00399         UNTIL TB-VAL-INDEX > 10.                                 
P00399     PERFORM 7320-VERIFY-DW-VARIABLES THRU 7320-EXIT.             
P00399                                                                  
P00399     MOVE WS-COMPANY-NO-AT TO WS-CURRENT-COMPANY.                 
P00399                                                                  
P00399 7300-EXIT.                                                       
P00399     EXIT.                                                        
                                                                        
P00399*****************************************************************         
P00399* 7310-LOAD-DW-VARIABLE.                                        *         
P00399*****************************************************************         
P00399 7310-LOAD-DW-VARIABLE.                                           
P00399                                                                  
P00399     EVALUATE WS-DELINQ-CODE-TB (TB-CO-INDEX, TB-VAL-INDEX)       
P00399        WHEN 'RETAIN-RESIDENT-DEP'                                
P00399           MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)    
P00399               TO WS-RESIDENT-MONTHS                              
P00399           SET TB-VAL-INDEX UP BY 1                               
P00399        WHEN 'RETAIN-COMMER-DEP'                                  
P00399           MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)    
P00399               TO WS-COMMER-MONTHS                                
P00399           SET TB-VAL-INDEX UP BY 1                               
P00399        WHEN 'RETAIN-INDUST-DEP'                                  
P00399           MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)    
P00399               TO WS-INDUST-MONTHS                                
P00399           SET TB-VAL-INDEX UP BY 1                               
P00399        WHEN 'DAY-NU-FBPAID'                                      
P00399           MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)    
P00399               TO WS-DAY-NU-FBPAID                                
P00399           SET TB-VAL-INDEX UP BY 1                               
P00399        WHEN OTHER                                                
P00399           SET TB-VAL-INDEX UP BY 1                               
P00399     END-EVALUATE.                                                
P00399                                                                  
P00399 7310-EXIT.                                                       
P00399     EXIT.                                                        
                                                                        
P00399*****************************************************************         
P00399* 7320-VERIFY-DW-VARIABLES.                                     *         
P00399*****************************************************************         
P00399 7320-VERIFY-DW-VARIABLES.                                        
P00399     IF        WS-RESIDENT-MONTHS               > ZERO            
P00399           AND WS-COMMER-MONTHS                 > ZERO            
P00399           AND WS-INDUST-MONTHS                 > ZERO            
P00399           AND WS-DAY-NU-FBPAID                 > ZERO            
P00399        CONTINUE                                                  
P00399     ELSE                                                         
P00399        MOVE 'DELINQ CONSTANTS NOT CORRECT'                       
P00399          TO WS-MISC-MSG-TEXT                                     
P00399        MOVE +28 TO WS-MISC-MSG-LEN                               
P00399        MOVE +17 TO WS-MISC-CATEGORY                              
P00399        MOVE 16 TO RETURN-CODE                                    
P00399        PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
P00399     END-IF.                                                      
P00399 7320-EXIT.                                                       
P00399     EXIT.                                                        
       8000-UPDATE-ACCOUNT.                                             
           IF AT-DATE-BILL-DAY-00 = LOW-VALUES OR SPACES                
              MOVE -1 TO WS-NULL-IND-1                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-1                                
           END-IF                                                       
           IF AT-DATE-BILL-DAY-30 = LOW-VALUES OR SPACES                
              MOVE -1 TO WS-NULL-IND-2                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-2                                
           END-IF                                                       
           IF AT-DATE-BILL-DAY-60 = LOW-VALUES OR SPACES                
              MOVE -1 TO WS-NULL-IND-3                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-3                                
           END-IF                                                       
           IF AT-DATE-BILL-DAY-90 = LOW-VALUES OR SPACES                
              MOVE -1 TO WS-NULL-IND-4                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-4                                
           END-IF                                                       
           IF AT-LAST-PYMT-DATE = LOW-VALUES OR SPACES                  
              MOVE -1 TO WS-NULL-IND-5                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-5                                
           END-IF                                                       
           IF AT-EPP-OFFER-DATE = LOW-VALUES OR SPACES                  
              MOVE -1 TO WS-NULL-IND-6                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-6                                
           END-IF                                                       
           IF AT-ACCT-FINALED-DT = LOW-VALUES OR SPACES                 
              MOVE -1 TO WS-NULL-IND-7                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-7                                
           END-IF                                                       
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
ACT107        SET                                                       
                 DATE_BILL_DAY_00 = IIF(TRY_CONVERT(DATE, 
                                                  :AT-DATE-BILL-DAY-00 
                                                          :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00 :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00 
                                                         :WS-NULL-IND-1
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00 :WS-NULL-IND-1) ),
                 DATE_BILL_DAY_30 = IIF(TRY_CONVERT(DATE, 
                                                  :AT-DATE-BILL-DAY-30 
                                                          :WS-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-30 
                                                         :WS-NULL-IND-2
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-30 :WS-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-30 
                                                         :WS-NULL-IND-2
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-30 :WS-NULL-IND-2) ),
                 DATE_BILL_DAY_60 = IIF(TRY_CONVERT(DATE, 
                                                  :AT-DATE-BILL-DAY-60 
                                                          :WS-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-60 
                                                         :WS-NULL-IND-3
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-60 :WS-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-60 
                                                         :WS-NULL-IND-3
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-60 :WS-NULL-IND-3) ),
                 DATE_BILL_DAY_90 = IIF(TRY_CONVERT(DATE, 
                                                  :AT-DATE-BILL-DAY-90 
                                                          :WS-NULL-IND-4
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-90 
                                                         :WS-NULL-IND-4
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-90 :WS-NULL-IND-4
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-90 
                                                         :WS-NULL-IND-4
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-90 :WS-NULL-IND-4) ),
PCR212           ELEC_REV_ALLOC_PCT = :AT-ELEC-REV-ALLOC-PCT,           
                 TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,             
P00599*          CREDIT_GROUP       = :AT-CREDIT-GROUP,                         
P00599*          CREDIT_STATUS_CODE = :AT-CREDIT-STATUS-CODE,                   
                 CODE_BILL_FREQ     = :AT-CODE-BILL-FREQ,               
                 CODE_PERM_BILL     = :AT-CODE-PERM-BILL,               
                 CODE_P_BILL_DEST   = :AT-CODE-P-BILL-DEST,             
                 CODE_TEMP_BILL     = :AT-CODE-TEMP-BILL,               
                 CODE_BILL_PEND     = :AT-CODE-BILL-PEND,               
                 DATE_LAST_ACTION   = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:AT-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-LAST-ACTION
              ), CONVERT(DATE, :AT-DATE-LAST-ACTION) ),             
                 NXT_BILL_NO        = :AT-NXT-BILL-NO,                  
                 LAST_NRML_BILL_NO  = :AT-LAST-NRML-BILL-NO,            
                 CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,           
                 LAST_PYMT_DATE     = IIF(TRY_CONVERT(DATE, 
                                                    :AT-LAST-PYMT-DATE 
                                                         :WS-NULL-IND-5
              ) IS NULL OR (PATINDEX('%.%', :AT-LAST-PYMT-DATE 
                                                         :WS-NULL-IND-5
              ) <> 0) OR (LEN(:AT-LAST-PYMT-DATE :WS-NULL-IND-5
              ) <> 10), CIS.CHAR2DATE(:AT-LAST-PYMT-DATE :WS-NULL-IND-5
              ), CONVERT(DATE, :AT-LAST-PYMT-DATE :WS-NULL-IND-5) ),
                 LAST_PYMT_AMOUNT   = :AT-LAST-PYMT-AMOUNT,             
                 EPP_OFFER_DATE     = IIF(TRY_CONVERT(DATE, 
                                                    :AT-EPP-OFFER-DATE 
                                                         :WS-NULL-IND-6
              ) IS NULL OR (PATINDEX('%.%', :AT-EPP-OFFER-DATE 
                                                         :WS-NULL-IND-6
              ) <> 0) OR (LEN(:AT-EPP-OFFER-DATE :WS-NULL-IND-6
              ) <> 10), CIS.CHAR2DATE(:AT-EPP-OFFER-DATE :WS-NULL-IND-6
              ), CONVERT(DATE, :AT-EPP-OFFER-DATE :WS-NULL-IND-6) ),
                 EPP_OFFER_AMOUNT   = :AT-EPP-OFFER-AMOUNT,             
PCR233           REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML,             
                 ACCT_FINALED_DT    = CIS.CHAR2TIMESTAMP(
                                                   :AT-ACCT-FINALED-DT 
                                                         :WS-NULL-IND-7
              ),                   
T10918           CANREB_CODE_00_DAY = :AT-CANREB-CODE-00-DAY,           
T10918           CANREB_CODE_30_DAY = :AT-CANREB-CODE-30-DAY,           
T10918           CANREB_CODE_60_DAY = :AT-CANREB-CODE-60-DAY,           
T10918           CANREB_CODE_90_DAY = :AT-CANREB-CODE-90-DAY,           
T12417           MST_OVRRD_BLL_IND  = :AT-MST-OVRRD-BLL-IND,            
T15127           AR_XFER_IND        = :AT-AR-XFER-IND,                  
                 LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()                 
              WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                    
               AND COMPANY_NO       = :AT-COMPANY-NO                    
               AND LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*       SET                                                               
MFA-TR*          DATE_BILL_DAY_00 = :AT-DATE-BILL-DAY-00 :WS-NULL-IND-1,        
MFA-TR*          DATE_BILL_DAY_30 = :AT-DATE-BILL-DAY-30 :WS-NULL-IND-2,        
MFA-TR*          DATE_BILL_DAY_60 = :AT-DATE-BILL-DAY-60 :WS-NULL-IND-3,        
MFA-TR*          DATE_BILL_DAY_90 = :AT-DATE-BILL-DAY-90 :WS-NULL-IND-4,        
MFA-TR*          ELEC_REV_ALLOC_PCT = :AT-ELEC-REV-ALLOC-PCT,                   
MFA-TR*          TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,                     
MFA-TR*          CREDIT_GROUP       = :AT-CREDIT-GROUP,                         
MFA-TR*          CREDIT_STATUS_CODE = :AT-CREDIT-STATUS-CODE,                   
MFA-TR*          CODE_BILL_FREQ     = :AT-CODE-BILL-FREQ,                       
MFA-TR*          CODE_PERM_BILL     = :AT-CODE-PERM-BILL,                       
MFA-TR*          CODE_P_BILL_DEST   = :AT-CODE-P-BILL-DEST,                     
MFA-TR*          CODE_TEMP_BILL     = :AT-CODE-TEMP-BILL,                       
MFA-TR*          CODE_BILL_PEND     = :AT-CODE-BILL-PEND,                       
MFA-TR*          DATE_LAST_ACTION   = :AT-DATE-LAST-ACTION,                     
MFA-TR*          NXT_BILL_NO        = :AT-NXT-BILL-NO,                          
MFA-TR*          LAST_NRML_BILL_NO  = :AT-LAST-NRML-BILL-NO,                    
MFA-TR*          CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,                   
MFA-TR*          LAST_PYMT_DATE     = :AT-LAST-PYMT-DATE :WS-NULL-IND-5,        
MFA-TR*          LAST_PYMT_AMOUNT   = :AT-LAST-PYMT-AMOUNT,                     
MFA-TR*          EPP_OFFER_DATE     = :AT-EPP-OFFER-DATE :WS-NULL-IND-6,        
MFA-TR*          EPP_OFFER_AMOUNT   = :AT-EPP-OFFER-AMOUNT,                     
MFA-TR*          REV_MTH_LST_NRML   = :AT-REV-MTH-LST-NRML,                     
MFA-TR*          ACCT_FINALED_DT    = :AT-ACCT-FINALED-DT                       
MFA-TR*                               :WS-NULL-IND-7,                           
MFA-TR*          CANREB_CODE_00_DAY = :AT-CANREB-CODE-00-DAY,                   
MFA-TR*          CANREB_CODE_30_DAY = :AT-CANREB-CODE-30-DAY,                   
MFA-TR*          CANREB_CODE_60_DAY = :AT-CANREB-CODE-60-DAY,                   
MFA-TR*          CANREB_CODE_90_DAY = :AT-CANREB-CODE-90-DAY,                   
MFA-TR*          MST_OVRRD_BLL_IND  = :AT-MST-OVRRD-BLL-IND,                    
MFA-TR*          AR_XFER_IND        = :AT-AR-XFER-IND,                          
MFA-TR*          LAST_UPDATE_TS     = CURRENT TIMESTAMP                         
MFA-TR*       WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                            
MFA-TR*        AND COMPANY_NO       = :AT-COMPANY-NO                            
MFA-TR*        AND LAST_UPDATE_TS   = :AT-LAST-UPDATE-TS                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 4 TO RETURN-CODE                                  
                 DISPLAY 'TIMESTAMP ERROR'                              
                 PERFORM 9999-BAIL-OUT THRU 9999-EXIT                   
              WHEN OTHER                                                
                 MOVE 'AT'                 TO WS-DB2-TABLE-ID           
                 MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '113'                TO WS-DB2-MODULE-ID          
                 MOVE '8000'               TO WS-DB2-PARAGRAPH          
                 MOVE AT-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE AT-COMPANY-NO        TO WS-DB2-KEY-2N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-EVALUATE.                                                
       8000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8120-UPDATE-AR-CNTRL.                                            
APP869                                                                  
APP869     IF  AC-PYMT-PRIORITY-LVL  > 049 AND AC-ITEM-ID = 0           
APP869         MOVE ZEROS             TO AC-AMT-TRAN-BALANCE            
APP869                                   AC-TOT-SUMM-UNBILLED           
APP869     END-IF.                                                      
APP869                                                                  
           EXEC SQL                                                     
              UPDATE CSS_AR_CNTL                                        
                 SET AMT_AR_DAY_00       = :AC-AMT-AR-DAY-00,           
                     AMT_AR_DAY_30       = :AC-AMT-AR-DAY-30,           
                     AMT_AR_DAY_60       = :AC-AMT-AR-DAY-60,           
                     AMT_AR_DAY_90       = :AC-AMT-AR-DAY-90,           
                     TOT_SUMM_UNBILLED   = :AC-TOT-SUMM-UNBILLED,       
                     AMT_UNUSED_CR       = :AC-AMT-UNUSED-CR,           
                     AMT_TRAN_BALANCE    = :AC-AMT-TRAN-BALANCE,        
                     LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP()            
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
                 AND LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :AC-LAST-UPDATE-TS
              )             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_AR_CNTL                                                
MFA-TR*          SET AMT_AR_DAY_00       = :AC-AMT-AR-DAY-00,                   
MFA-TR*              AMT_AR_DAY_30       = :AC-AMT-AR-DAY-30,                   
MFA-TR*              AMT_AR_DAY_60       = :AC-AMT-AR-DAY-60,                   
MFA-TR*              AMT_AR_DAY_90       = :AC-AMT-AR-DAY-90,                   
MFA-TR*              TOT_SUMM_UNBILLED   = :AC-TOT-SUMM-UNBILLED,               
MFA-TR*              AMT_UNUSED_CR       = :AC-AMT-UNUSED-CR,                   
MFA-TR*              AMT_TRAN_BALANCE    = :AC-AMT-TRAN-BALANCE,                
MFA-TR*              LAST_UPDATE_TS      = CURRENT TIMESTAMP                    
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*          AND ITEM_ID           = :AC-ITEM-ID                            
MFA-TR*          AND LAST_UPDATE_TS    = :AC-LAST-UPDATE-TS                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 4 TO RETURN-CODE                                  
                 PERFORM 9999-BAIL-OUT THRU 9999-EXIT                   
              WHEN OTHER                                                
                 MOVE 'AC'                 TO WS-DB2-TABLE-ID           
                 MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '113'                TO WS-DB2-MODULE-ID          
                 MOVE '8120'               TO WS-DB2-PARAGRAPH          
                 MOVE AC-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE AC-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N             
                 MOVE AC-ITEM-ID           TO WS-DB2-KEY-3N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-EVALUATE.                                                
       8120-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8123-INSERT-AR-CNTRL.                                            
APP869                                                                  
APP869     IF  AC-PYMT-PRIORITY-LVL  > 049 AND AC-ITEM-ID = 0           
APP869         MOVE ZEROS             TO AC-AMT-TRAN-BALANCE            
APP869                                   AC-TOT-SUMM-UNBILLED           
APP869     END-IF.                                                      
APP869                                                                  
           EXEC SQL                                                     
              INSERT INTO CSS_AR_CNTL                                   
                (ACCOUNT_NO,                                            
                 PYMT_PRIORITY_LVL,                                     
                 ITEM_ID,                                               
                 AMT_AR_DAY_00,                                         
                 AMT_AR_DAY_30,                                         
                 AMT_AR_DAY_60,                                         
                 AMT_AR_DAY_90,                                         
                 AMT_UNUSED_CR,                                         
                 AMT_TRAN_BALANCE,                                      
                 TOT_SUMM_UNBILLED,                                     
                 LAST_UPDATE_TS)                                        
              VALUES                                                    
                (:AC-ACCOUNT-NO,                                        
                 :AC-PYMT-PRIORITY-LVL,                                 
                 :AC-ITEM-ID,                                           
                 :AC-AMT-AR-DAY-00,                                     
                 :AC-AMT-AR-DAY-30,                                     
                 :AC-AMT-AR-DAY-60,                                     
                 :AC-AMT-AR-DAY-90,                                     
                 :AC-AMT-UNUSED-CR,                                     
                 :AC-AMT-TRAN-BALANCE,                                  
                 :AC-TOT-SUMM-UNBILLED,                                 
                 CIS.CURRENT$TIMESTAMP())                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_AR_CNTL                                           
MFA-TR*         (ACCOUNT_NO,                                                    
MFA-TR*          PYMT_PRIORITY_LVL,                                             
MFA-TR*          ITEM_ID,                                                       
MFA-TR*          AMT_AR_DAY_00,                                                 
MFA-TR*          AMT_AR_DAY_30,                                                 
MFA-TR*          AMT_AR_DAY_60,                                                 
MFA-TR*          AMT_AR_DAY_90,                                                 
MFA-TR*          AMT_UNUSED_CR,                                                 
MFA-TR*          AMT_TRAN_BALANCE,                                              
MFA-TR*          TOT_SUMM_UNBILLED,                                             
MFA-TR*          LAST_UPDATE_TS)                                                
MFA-TR*       VALUES                                                            
MFA-TR*         (:AC-ACCOUNT-NO,                                                
MFA-TR*          :AC-PYMT-PRIORITY-LVL,                                         
MFA-TR*          :AC-ITEM-ID,                                                   
MFA-TR*          :AC-AMT-AR-DAY-00,                                             
MFA-TR*          :AC-AMT-AR-DAY-30,                                             
MFA-TR*          :AC-AMT-AR-DAY-60,                                             
MFA-TR*          :AC-AMT-AR-DAY-90,                                             
MFA-TR*          :AC-AMT-UNUSED-CR,                                             
MFA-TR*          :AC-AMT-TRAN-BALANCE,                                          
MFA-TR*          :AC-TOT-SUMM-UNBILLED,                                         
MFA-TR*          CURRENT TIMESTAMP)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'AC'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '113'                TO WS-DB2-MODULE-ID             
              MOVE '8123'               TO WS-DB2-PARAGRAPH             
              MOVE AC-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE AC-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N                
              MOVE AC-ITEM-ID           TO WS-DB2-KEY-3N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8123-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8126-DELETE-AR-CNTL.                                             
           EXEC SQL                                                     
                DELETE FROM CSS_AR_CNTL                                 
                WHERE  ACCOUNT_NO        =  :AC-ACCOUNT-NO              
                  AND  PYMT_PRIORITY_LVL =  :AC-PYMT-PRIORITY-LVL       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'AC'                 TO WS-DB2-TABLE-ID              
              MOVE 'DELETE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '113'                TO WS-DB2-MODULE-ID             
              MOVE '8126'               TO WS-DB2-PARAGRAPH             
              MOVE AC-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE AC-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8126-EXIT.                                                       
           EXIT.                                                        
P00599******************************************************************        
P00599* 8210-UPDATE-CREDIT-PROFILE                                     *        
P00599******************************************************************        
P00599                                                                  
P00599 8210-UPDATE-CREDIT-PROFILE.                                      
P00599                                                                  
P00599     IF CZ-CSH-ONLY-EFFECT-DT = SPACES OR LOW-VALUES              
P00599        MOVE -1   TO WS-NULL-IND-2                                
P00599     ELSE                                                         
P00599        MOVE ZERO TO WS-NULL-IND-2                                
P00599     END-IF.                                                      
P00599                                                                  
P00599     EXEC SQL                                                     
P00599        UPDATE CSS_CREDIT_PROFILE                                 
P00599           SET CASH_ONLY_FL       = :CZ-CASH-ONLY-FL              
P00599              ,CSH_ONLY_EFFECT_DT = IIF(TRY_CONVERT(DATE, 
                                                :CZ-CSH-ONLY-EFFECT-DT 
                                                         :WS-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :CZ-CSH-ONLY-EFFECT-DT 
                                                         :WS-NULL-IND-2
              ) <> 0) OR (LEN(:CZ-CSH-ONLY-EFFECT-DT :WS-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:CZ-CSH-ONLY-EFFECT-DT 
                                                         :WS-NULL-IND-2
              ), CONVERT(DATE, :CZ-CSH-ONLY-EFFECT-DT :WS-NULL-IND-2) )        
P00599              ,AUTO_DEP_AM        = :CZ-AUTO-DEP-AM               
P00599              ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
P00599         WHERE ACCOUNT_NO         = :CZ-ACCOUNT-NO                
P00599           AND LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :CZ-LAST-UPDATE-TS
              )            
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CREDIT_PROFILE                                         
MFA-TR*          SET CASH_ONLY_FL       = :CZ-CASH-ONLY-FL                      
MFA-TR*             ,CSH_ONLY_EFFECT_DT = :CZ-CSH-ONLY-EFFECT-DT                
MFA-TR*                                   :WS-NULL-IND-2                        
MFA-TR*             ,AUTO_DEP_AM        = :CZ-AUTO-DEP-AM                       
MFA-TR*             ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO         = :CZ-ACCOUNT-NO                        
MFA-TR*          AND LAST_UPDATE_TS     = :CZ-LAST-UPDATE-TS                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599                                                                  
P00599     EVALUATE SQLCODE                                             
P00599         WHEN SUCCESSFUL-CALL                                     
P00599              CONTINUE                                            
P00599         WHEN NOT-FOUND                                           
P00599              MOVE 4 TO RETURN-CODE                               
P00599              PERFORM 9999-BAIL-OUT THRU 9999-EXIT                
P00599         WHEN OTHER                                               
P00599              MOVE 'CZ'                 TO WS-DB2-TABLE-ID        
P00599              MOVE 'UPDATE'             TO WS-DB2-FUNCTION        
P00599              MOVE SQLCODE              TO WS-DB2-RETURN-CODE     
P00599              MOVE '113'                TO WS-DB2-MODULE-ID       
P00599              MOVE '8210'               TO WS-DB2-PARAGRAPH       
P00599              MOVE CZ-ACCOUNT-NO        TO WS-DB2-KEY-1N          
P00599              MOVE 12 TO RETURN-CODE                              
P00599              PERFORM 9900-SQL-ERROR THRU 9900-EXIT               
P00599     END-EVALUATE.                                                
P00599                                                                  
P00599 8210-EXIT.                                                       
P00599     EXIT.                                                        
      /                                                                         
      /                                                                         
T5502  8400-INSERT-BILLING-HDR.                                         
           IF BI-DATE-BILLED = LOW-VALUES OR SPACES                     
              MOVE -1 TO WS-NULL-IND-11                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-11                               
           END-IF                                                       
           EXEC SQL                                                     
              INSERT INTO CSS_BILLING_HDR                               
                     (ACCOUNT_NO,                                       
                      BILL_NO,                                          
                      DATE_BILLED,                                      
                      CODE_BILL_REASON,                                 
                      CODE_BILL_TYPE,                                   
                      CODE_BILL_STATUS,                                 
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      CODE_SPCL_BILL,                                   
                      PREM_ACCT_SEQ_NO,                                 
                      COMPANY_NO,                                       
                      TOT_OTHER_CHARGES,                                
                      TOTAL_ARREARS,                                    
                      LAST_UPDATE_TS)                                   
               VALUES                                                   
                     (:BI-ACCOUNT-NO,                                   
                      :BI-BILL-NO,                                      
                      IIF(TRY_CONVERT(DATE, :BI-DATE-BILLED 
                                            :WS-NULL-IND-11
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED 
                                                        :WS-NULL-IND-11
              ) <> 0) OR (LEN(:BI-DATE-BILLED :WS-NULL-IND-11
              ) <> 10), CIS.CHAR2DATE(:BI-DATE-BILLED :WS-NULL-IND-11
              ), CONVERT(DATE, :BI-DATE-BILLED :WS-NULL-IND-11) ),             
                      :BI-CODE-BILL-REASON,                             
                      :BI-CODE-BILL-TYPE,                               
                      :BI-CODE-BILL-STATUS,                             
                      :BI-CUSTOMER-NO,                                  
                      :BI-PREMISE-NO,                                   
                      :BI-CODE-SPCL-BILL,                               
                      :BI-PREM-ACCT-SEQ-NO,                             
                      :BI-COMPANY-NO,                                   
                      :BI-TOT-OTHER-CHARGES,                            
                      :BI-TOTAL-ARREARS,                                
                      CIS.CURRENT$TIMESTAMP())                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_BILLING_HDR                                       
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*               BILL_NO,                                                  
MFA-TR*               DATE_BILLED,                                              
MFA-TR*               CODE_BILL_REASON,                                         
MFA-TR*               CODE_BILL_TYPE,                                           
MFA-TR*               CODE_BILL_STATUS,                                         
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               CODE_SPCL_BILL,                                           
MFA-TR*               PREM_ACCT_SEQ_NO,                                         
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               TOT_OTHER_CHARGES,                                        
MFA-TR*               TOTAL_ARREARS,                                            
MFA-TR*               LAST_UPDATE_TS)                                           
MFA-TR*        VALUES                                                           
MFA-TR*              (:BI-ACCOUNT-NO,                                           
MFA-TR*               :BI-BILL-NO,                                              
MFA-TR*               :BI-DATE-BILLED :WS-NULL-IND-11,                          
MFA-TR*               :BI-CODE-BILL-REASON,                                     
MFA-TR*               :BI-CODE-BILL-TYPE,                                       
MFA-TR*               :BI-CODE-BILL-STATUS,                                     
MFA-TR*               :BI-CUSTOMER-NO,                                          
MFA-TR*               :BI-PREMISE-NO,                                           
MFA-TR*               :BI-CODE-SPCL-BILL,                                       
MFA-TR*               :BI-PREM-ACCT-SEQ-NO,                                     
MFA-TR*               :BI-COMPANY-NO,                                           
MFA-TR*               :BI-TOT-OTHER-CHARGES,                                    
MFA-TR*               :BI-TOTAL-ARREARS,                                        
MFA-TR*               CURRENT TIMESTAMP)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'BI'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '113'                TO WS-DB2-MODULE-ID             
              MOVE '8400'               TO WS-DB2-PARAGRAPH             
              MOVE BI-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BI-BILL-NO           TO WS-DB2-KEY-2N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8400-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
T5502  8410-UPDATE-BILLING-HDR.                                         
           IF BI-DATE-BILLED = LOW-VALUES                               
              MOVE -1 TO WS-NULL-IND-11                                 
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-11                               
           END-IF                                                       
           EXEC SQL                                                     
              UPDATE CSS_BILLING_HDR                                    
                 SET CODE_BILL_REASON   =  :BI-CODE-BILL-REASON,        
                     DATE_BILLED        =  IIF(TRY_CONVERT(DATE, 
                                                       :BI-DATE-BILLED 
                                                        :WS-NULL-IND-11
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED 
                                                        :WS-NULL-IND-11
              ) <> 0) OR (LEN(:BI-DATE-BILLED :WS-NULL-IND-11
              ) <> 10), CIS.CHAR2DATE(:BI-DATE-BILLED :WS-NULL-IND-11
              ), CONVERT(DATE, :BI-DATE-BILLED :WS-NULL-IND-11) ),             
                     CODE_BILL_STATUS   =  :BI-CODE-BILL-STATUS,        
                     CODE_BILL_TYPE     =  :BI-CODE-BILL-TYPE,          
                     CUSTOMER_NO        =  :BI-CUSTOMER-NO,             
                     PREMISE_NO         =  :BI-PREMISE-NO,              
                     CODE_SPCL_BILL     =  :BI-CODE-SPCL-BILL,          
                     PREM_ACCT_SEQ_NO   =  :BI-PREM-ACCT-SEQ-NO,        
                     COMPANY_NO         =  :BI-COMPANY-NO,              
                     TOT_OTHER_CHARGES  =  :BI-TOT-OTHER-CHARGES,       
                     TOTAL_ARREARS      =  :BI-TOTAL-ARREARS,           
                     LAST_UPDATE_TS     =  CIS.CURRENT$TIMESTAMP()            
               WHERE ACCOUNT_NO         =  :BI-ACCOUNT-NO               
                 AND BILL_NO            =  :BI-BILL-NO                  
                 AND LAST_UPDATE_TS     =  CIS.CHAR2TIMESTAMP(
                                                     :BI-LAST-UPDATE-TS
              )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BILLING_HDR                                            
MFA-TR*          SET CODE_BILL_REASON   =  :BI-CODE-BILL-REASON,                
MFA-TR*              DATE_BILLED        =  :BI-DATE-BILLED                      
MFA-TR*                                    :WS-NULL-IND-11,                     
MFA-TR*              CODE_BILL_STATUS   =  :BI-CODE-BILL-STATUS,                
MFA-TR*              CODE_BILL_TYPE     =  :BI-CODE-BILL-TYPE,                  
MFA-TR*              CUSTOMER_NO        =  :BI-CUSTOMER-NO,                     
MFA-TR*              PREMISE_NO         =  :BI-PREMISE-NO,                      
MFA-TR*              CODE_SPCL_BILL     =  :BI-CODE-SPCL-BILL,                  
MFA-TR*              PREM_ACCT_SEQ_NO   =  :BI-PREM-ACCT-SEQ-NO,                
MFA-TR*              COMPANY_NO         =  :BI-COMPANY-NO,                      
MFA-TR*              TOT_OTHER_CHARGES  =  :BI-TOT-OTHER-CHARGES,               
MFA-TR*              TOTAL_ARREARS      =  :BI-TOTAL-ARREARS,                   
MFA-TR*              LAST_UPDATE_TS     =  CURRENT TIMESTAMP                    
MFA-TR*        WHERE ACCOUNT_NO         =  :BI-ACCOUNT-NO                       
MFA-TR*          AND BILL_NO            =  :BI-BILL-NO                          
MFA-TR*          AND LAST_UPDATE_TS     =  :BI-LAST-UPDATE-TS                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 DISPLAY 'TIMESTAMP ERROR'                              
                 MOVE 4 TO RETURN-CODE                                  
                 PERFORM 9999-BAIL-OUT THRU 9999-EXIT                   
              WHEN OTHER                                                
                 MOVE 'BI'                 TO WS-DB2-TABLE-ID           
                 MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '113'                TO WS-DB2-MODULE-ID          
                 MOVE '8410'               TO WS-DB2-PARAGRAPH          
                 MOVE BI-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE BI-BILL-NO           TO WS-DB2-KEY-2N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-EVALUATE.                                                
       8410-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
C26229*                                                                         
C26229 8420-UPDATE-BUDGET-HIST.                                         
C26229*                                                                         
C26229     EXEC SQL                                                     
C26229          UPDATE CSS_BUDGET_HIST                                  
C26229            SET DATE_PYMT_STRT    = IIF(TRY_CONVERT(DATE, 
                                                     :BH-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BH-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BH-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BH-DATE-PYMT-STRT
              ), CONVERT(DATE, :BH-DATE-PYMT-STRT) ),           
C26229                LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()             
C26229          WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO                
C26229            AND PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL         
C26229            AND ITEM_ID           = :BH-ITEM-ID                   
C26229            AND LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :BH-LAST-UPDATE-TS
              )            
C26229            AND CHANGE_REASON     = 'S'                           
C26229     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_BUDGET_HIST                                          
MFA-TR*           SET DATE_PYMT_STRT    = :BH-DATE-PYMT-STRT,                   
MFA-TR*               LAST_UPDATE_TS    = CURRENT TIMESTAMP                     
MFA-TR*         WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL                 
MFA-TR*           AND ITEM_ID           = :BH-ITEM-ID                           
MFA-TR*           AND LAST_UPDATE_TS    = :BH-LAST-UPDATE-TS                    
MFA-TR*           AND CHANGE_REASON     = 'S'                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26229                                                                  
C26229     EVALUATE SQLCODE                                             
C26229        WHEN SUCCESSFUL-CALL                                      
C26229           CONTINUE                                               
C26229        WHEN NOT-FOUND                                            
C26229           MOVE 4 TO RETURN-CODE                                  
C26229           PERFORM 9999-BAIL-OUT THRU 9999-EXIT                   
C26229        WHEN OTHER                                                
C26229           MOVE 'BH'                 TO WS-DB2-TABLE-ID           
C26229           MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
C26229           MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
C26229           MOVE '113'                TO WS-DB2-MODULE-ID          
C26229           MOVE '8420'               TO WS-DB2-PARAGRAPH          
C26229           MOVE BH-ACCOUNT-NO        TO WS-DB2-KEY-1N             
C26229           MOVE BH-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N             
C26229           MOVE 12                   TO RETURN-CODE               
C26229           PERFORM 9900-SQL-ERROR    THRU 9900-EXIT               
C26229     END-EVALUATE.                                                
C26229*                                                                         
C26229 8420-EXIT.                                                       
C26229     EXIT.                                                        
C26229*                                                                         
       8710-INSERT-BUDGET-PLAN.                                         
           EXEC SQL                                                     
              INSERT INTO CSS_BUDGET_PLAN                               
                 ( ACCOUNT_NO,                                          
                   PYMT_PRIORITY_LVL,                                   
                   BP_ITEM_ID,                                          
                   AMT_MO_PYMT,                                         
                   AMT_MO_PYT_BAL_FWD,                                  
                   AMT_MO_PYMT_NEW,                                     
                   LAST_UPDATE_TS)                                      
                 VALUES                                                 
                 ( :BU-ACCOUNT-NO,                                      
                   :BU-PYMT-PRIORITY-LVL,                               
                   :BU-BP-ITEM-ID,                                      
                   0,                                                   
                   0,                                                   
                   :BU-AMT-MO-PYMT-NEW,                                 
                   CIS.CURRENT$TIMESTAMP())                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_BUDGET_PLAN                                       
MFA-TR*          ( ACCOUNT_NO,                                                  
MFA-TR*            PYMT_PRIORITY_LVL,                                           
MFA-TR*            BP_ITEM_ID,                                                  
MFA-TR*            AMT_MO_PYMT,                                                 
MFA-TR*            AMT_MO_PYT_BAL_FWD,                                          
MFA-TR*            AMT_MO_PYMT_NEW,                                             
MFA-TR*            LAST_UPDATE_TS)                                              
MFA-TR*          VALUES                                                         
MFA-TR*          ( :BU-ACCOUNT-NO,                                              
MFA-TR*            :BU-PYMT-PRIORITY-LVL,                                       
MFA-TR*            :BU-BP-ITEM-ID,                                              
MFA-TR*            0,                                                           
MFA-TR*            0,                                                           
MFA-TR*            :BU-AMT-MO-PYMT-NEW,                                         
MFA-TR*            CURRENT TIMESTAMP)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
                 MOVE 'BU'                 TO WS-DB2-TABLE-ID           
                 MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '113'                TO WS-DB2-MODULE-ID          
                 MOVE '8710'               TO WS-DB2-PARAGRAPH          
                 MOVE BU-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE BU-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N             
                 MOVE BU-BP-ITEM-ID        TO WS-DB2-KEY-3N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-IF.                                                      
       8710-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8713-UPDATE-BUDGET-PLAN.                                         
           EXEC SQL                                                     
                UPDATE CSS_BUDGET_PLAN                                  
                SET  AMT_MO_PYMT        = :BU-AMT-MO-PYMT,              
                     AMT_MO_PYMT_NEW    = :BU-AMT-MO-PYMT-NEW,          
                     AMT_MO_PYT_BAL_FWD = :BU-AMT-MO-PYT-BAL-FWD,       
                     DATE_PYMT_STRT     = IIF(TRY_CONVERT(DATE, 
                                                     :BU-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BU-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BU-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BU-DATE-PYMT-STRT
              ), CONVERT(DATE, :BU-DATE-PYMT-STRT) ),           
                     ANNIVERSARY_DATE   = IIF(TRY_CONVERT(DATE, 
                                                   :BU-ANNIVERSARY-DATE
              ) IS NULL OR (PATINDEX('%.%', :BU-ANNIVERSARY-DATE
              ) <> 0) OR (LEN(:BU-ANNIVERSARY-DATE
              ) <> 10), CIS.CHAR2DATE(:BU-ANNIVERSARY-DATE
              ), CONVERT(DATE, :BU-ANNIVERSARY-DATE) ),         
                     LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
                WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL         
                  AND BP_ITEM_ID        = :BU-BP-ITEM-ID                
                  AND LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :BU-LAST-UPDATE-TS
              )            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_BUDGET_PLAN                                          
MFA-TR*         SET  AMT_MO_PYMT        = :BU-AMT-MO-PYMT,                      
MFA-TR*              AMT_MO_PYMT_NEW    = :BU-AMT-MO-PYMT-NEW,                  
MFA-TR*              AMT_MO_PYT_BAL_FWD = :BU-AMT-MO-PYT-BAL-FWD,               
MFA-TR*              DATE_PYMT_STRT     = :BU-DATE-PYMT-STRT,                   
MFA-TR*              ANNIVERSARY_DATE   = :BU-ANNIVERSARY-DATE,                 
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*         WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL                 
MFA-TR*           AND BP_ITEM_ID        = :BU-BP-ITEM-ID                        
MFA-TR*           AND LAST_UPDATE_TS    = :BU-LAST-UPDATE-TS                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 4 TO RETURN-CODE                                  
                 PERFORM 9999-BAIL-OUT THRU 9999-EXIT                   
              WHEN OTHER                                                
                 MOVE 'BU'                 TO WS-DB2-TABLE-ID           
                 MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '113'                TO WS-DB2-MODULE-ID          
                 MOVE '8713'               TO WS-DB2-PARAGRAPH          
                 MOVE BU-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE BU-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N             
                 MOVE BU-BP-ITEM-ID        TO WS-DB2-KEY-3N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-EVALUATE.                                                
       8713-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
T29815****************************************************************          
T29815* UPDATE THE RECALCULATED AMT_MO_PYMT INTO CSS_BUDGET_PLAN ON **          
T29815* EPP ACCOUNTS WHEN TOTAL AR BALANCE IS LESS THAN ZERO        **          
T29815****************************************************************          
T29815 8714-UPDATE-BUDGET-PLAN.                                         
T29815     EXEC SQL                                                     
T29815          UPDATE CSS_BUDGET_PLAN                                  
T29815          SET  AMT_MO_PYMT        = :BU-AMT-MO-PYMT,              
T29815               AMT_MO_PYMT_NEW    = :BU-AMT-MO-PYMT-NEW,          
T29815               AMT_MO_PYT_BAL_FWD = :BU-AMT-MO-PYT-BAL-FWD,       
T29815               LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
T29815          WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                
T29815            AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL         
T29815            AND BP_ITEM_ID        = :BU-BP-ITEM-ID                
T29815            AND LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :BU-LAST-UPDATE-TS
              )            
T29815     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_BUDGET_PLAN                                          
MFA-TR*         SET  AMT_MO_PYMT        = :BU-AMT-MO-PYMT,                      
MFA-TR*              AMT_MO_PYMT_NEW    = :BU-AMT-MO-PYMT-NEW,                  
MFA-TR*              AMT_MO_PYT_BAL_FWD = :BU-AMT-MO-PYT-BAL-FWD,               
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*         WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL                 
MFA-TR*           AND BP_ITEM_ID        = :BU-BP-ITEM-ID                        
MFA-TR*           AND LAST_UPDATE_TS    = :BU-LAST-UPDATE-TS                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T29815*                                                                         
T29815     EVALUATE SQLCODE                                             
T29815        WHEN SUCCESSFUL-CALL                                      
T29815           CONTINUE                                               
T29815        WHEN NOT-FOUND                                            
T29815           MOVE 4 TO RETURN-CODE                                  
T29815           PERFORM 9999-BAIL-OUT THRU 9999-EXIT                   
T29815        WHEN OTHER                                                
T29815           MOVE 'BU'                 TO WS-DB2-TABLE-ID           
T29815           MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
T29815           MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
T29815           MOVE '113'                TO WS-DB2-MODULE-ID          
T29815           MOVE '8714'               TO WS-DB2-PARAGRAPH          
T29815           MOVE BU-ACCOUNT-NO        TO WS-DB2-KEY-1N             
T29815           MOVE BU-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N             
T29815           MOVE BU-BP-ITEM-ID        TO WS-DB2-KEY-3N             
T29815           MOVE 12 TO RETURN-CODE                                 
T29815           PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
T29815     END-EVALUATE.                                                
T29815 8714-EXIT.                                                       
T29815     EXIT.                                                        
T29815*                                                                         
T29815****************************************************************          
T29815* UPDATE THE RECALCULATED AMT_MO_PYMT INTO CSS_BUDGET_HIST ON **          
T29815* EPP ACCOUNTS WHEN TOTAL AR BALANCE IS LESS THAN ZERO        **          
T29815****************************************************************          
T29815 8715-UPDATE-BUDGET-HIST.                                         
T29815*                                                                         
T29815     EXEC SQL                                                     
T29815          UPDATE CSS_BUDGET_HIST                                  
T29815            SET AMT_MO_PYMT       = :BH-AMT-MO-PYMT,              
T29815                EPP_ESTIMATE      = :BH-EPP-ESTIMATE,             
T29815                BALANCE_FORWARD   = :BH-BALANCE-FORWARD,          
T29815                LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()             
T29815          WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO                
T29815            AND PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL         
T29815            AND ITEM_ID           = :BH-ITEM-ID                   
T29815            AND BUD_HIST_SEQ_NO   = CIS.CHAR2TIMESTAMP(
                                                    :BH-BUD-HIST-SEQ-NO
              )           
T29815            AND CHANGE_REASON     = 'A'                           
T29815     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_BUDGET_HIST                                          
MFA-TR*           SET AMT_MO_PYMT       = :BH-AMT-MO-PYMT,                      
MFA-TR*               EPP_ESTIMATE      = :BH-EPP-ESTIMATE,                     
MFA-TR*               BALANCE_FORWARD   = :BH-BALANCE-FORWARD,                  
MFA-TR*               LAST_UPDATE_TS    = CURRENT TIMESTAMP                     
MFA-TR*         WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL                 
MFA-TR*           AND ITEM_ID           = :BH-ITEM-ID                           
MFA-TR*           AND BUD_HIST_SEQ_NO   = :BH-BUD-HIST-SEQ-NO                   
MFA-TR*           AND CHANGE_REASON     = 'A'                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T29815*                                                                         
T29815     EVALUATE SQLCODE                                             
T29815        WHEN SUCCESSFUL-CALL                                      
T29815           CONTINUE                                               
T29815        WHEN NOT-FOUND                                            
T29815           MOVE 4 TO RETURN-CODE                                  
T29815           PERFORM 9999-BAIL-OUT THRU 9999-EXIT                   
T29815        WHEN OTHER                                                
T29815           MOVE 'BH'                 TO WS-DB2-TABLE-ID           
T29815           MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
T29815           MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
T29815           MOVE '113'                TO WS-DB2-MODULE-ID          
T29815           MOVE '8715'               TO WS-DB2-PARAGRAPH          
T29815           MOVE BH-ACCOUNT-NO        TO WS-DB2-KEY-1N             
T29815           MOVE BH-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N             
T29815           MOVE BH-ITEM-ID           TO WS-DB2-KEY-3N             
T29815           MOVE 12 TO RETURN-CODE                                 
T29815           PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
T29815     END-EVALUATE.                                                
T29815 8715-EXIT.                                                       
T29815     EXIT.                                                        
T29815*                                                                         
       8716-INSERT-BUDGET-PLAN.                                         
           EXEC SQL                                                     
                INSERT INTO CSS_BUDGET_PLAN                             
                 (ACCOUNT_NO,                                           
                  BP_ITEM_ID,                                           
                  PYMT_PRIORITY_LVL,                                    
                  AMT_MO_PYMT,                                          
                  AMT_MO_PYT_BAL_FWD,                                   
                  DATE_PYMT_STRT,                                       
                  AMT_MO_PYMT_NEW,                                      
                  ANNIVERSARY_DATE,                                     
                  LAST_UPDATE_TS)                                       
                VALUES                                                  
                 (:BU-ACCOUNT-NO,                                       
                  :BU-BP-ITEM-ID,                                       
                  :BU-PYMT-PRIORITY-LVL,                                
                  :BU-AMT-MO-PYMT,                                      
                  :BU-AMT-MO-PYT-BAL-FWD,                               
                  NULL,                                                 
                  :BU-AMT-MO-PYMT-NEW,                                  
                  NULL,                                                 
                  CIS.CURRENT$TIMESTAMP())                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_BUDGET_PLAN                                     
MFA-TR*          (ACCOUNT_NO,                                                   
MFA-TR*           BP_ITEM_ID,                                                   
MFA-TR*           PYMT_PRIORITY_LVL,                                            
MFA-TR*           AMT_MO_PYMT,                                                  
MFA-TR*           AMT_MO_PYT_BAL_FWD,                                           
MFA-TR*           DATE_PYMT_STRT,                                               
MFA-TR*           AMT_MO_PYMT_NEW,                                              
MFA-TR*           ANNIVERSARY_DATE,                                             
MFA-TR*           LAST_UPDATE_TS)                                               
MFA-TR*         VALUES                                                          
MFA-TR*          (:BU-ACCOUNT-NO,                                               
MFA-TR*           :BU-BP-ITEM-ID,                                               
MFA-TR*           :BU-PYMT-PRIORITY-LVL,                                        
MFA-TR*           :BU-AMT-MO-PYMT,                                              
MFA-TR*           :BU-AMT-MO-PYT-BAL-FWD,                                       
MFA-TR*           NULL,                                                         
MFA-TR*           :BU-AMT-MO-PYMT-NEW,                                          
MFA-TR*           NULL,                                                         
MFA-TR*           CURRENT TIMESTAMP)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'BU'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '113'                TO WS-DB2-MODULE-ID             
              MOVE '8716'               TO WS-DB2-PARAGRAPH             
              MOVE BU-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE AC-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N                
              MOVE BU-BP-ITEM-ID        TO WS-DB2-KEY-3N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8716-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8717-INSERT-BUDGET-HIST.                                         
T16413*    REPLACED 0 WITH BH-UTILITY-BALANCE.                                  
T17335*    DATE_PYMT_STRT POP'D WITH CURR REV MNTH RATHER THAN NULL             
           EXEC SQL                                                     
                INSERT INTO CSS_BUDGET_HIST                             
                 (ACCOUNT_NO,                                           
                  PYMT_PRIORITY_LVL,                                    
                  ITEM_ID,                                              
                  BUD_HIST_SEQ_NO,                                      
                  AMT_MO_PYMT,                                          
                  UTILITY_BALANCE,                                      
                  BALANCE_FORWARD,                                      
                  METHOD_OF_ESTIMATE,                                   
                  CHANGE_REASON,                                        
                  DATE_PYMT_STRT,                                       
                  LAST_UPDATE_TS,                                       
                  EPP_MTHS_RMNG_QT,                                     
                  REMARKS)                                              
                VALUES                                                  
                 (:BU-ACCOUNT-NO,                                       
                  :BU-PYMT-PRIORITY-LVL,                                
                  :BU-BP-ITEM-ID,                                       
                  CIS.CURRENT$TIMESTAMP(),                                    
                  :BH-AMT-MO-PYMT,                                      
                  :BH-UTILITY-BALANCE,                                  
                  0,                                                    
                  :BH-METHOD-OF-ESTIMATE,                               
                  :BH-CHANGE-REASON,                                    
                  IIF(TRY_CONVERT(DATE, :BU-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BU-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BU-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BU-DATE-PYMT-STRT
              ), CONVERT(DATE, :BU-DATE-PYMT-STRT) ),                          
                  CIS.CURRENT$TIMESTAMP(),                                    
                  :BH-EPP-MTHS-RMNG-QT,                                 
                  :BH-REMARKS)                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_BUDGET_HIST                                     
MFA-TR*          (ACCOUNT_NO,                                                   
MFA-TR*           PYMT_PRIORITY_LVL,                                            
MFA-TR*           ITEM_ID,                                                      
MFA-TR*           BUD_HIST_SEQ_NO,                                              
MFA-TR*           AMT_MO_PYMT,                                                  
MFA-TR*           UTILITY_BALANCE,                                              
MFA-TR*           BALANCE_FORWARD,                                              
MFA-TR*           METHOD_OF_ESTIMATE,                                           
MFA-TR*           CHANGE_REASON,                                                
MFA-TR*           DATE_PYMT_STRT,                                               
MFA-TR*           LAST_UPDATE_TS,                                               
MFA-TR*           EPP_MTHS_RMNG_QT,                                             
MFA-TR*           REMARKS)                                                      
MFA-TR*         VALUES                                                          
MFA-TR*          (:BU-ACCOUNT-NO,                                               
MFA-TR*           :BU-PYMT-PRIORITY-LVL,                                        
MFA-TR*           :BU-BP-ITEM-ID,                                               
MFA-TR*           CURRENT TIMESTAMP,                                            
MFA-TR*           :BH-AMT-MO-PYMT,                                              
MFA-TR*           :BH-UTILITY-BALANCE,                                          
MFA-TR*           0,                                                            
MFA-TR*           :BH-METHOD-OF-ESTIMATE,                                       
MFA-TR*           :BH-CHANGE-REASON,                                            
MFA-TR*           :BU-DATE-PYMT-STRT,                                           
MFA-TR*           CURRENT TIMESTAMP,                                            
MFA-TR*           :BH-EPP-MTHS-RMNG-QT,                                         
MFA-TR*           :BH-REMARKS)                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'BH'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '113'                TO WS-DB2-MODULE-ID             
              MOVE '8717'               TO WS-DB2-PARAGRAPH             
              MOVE BU-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BU-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N                
              MOVE BU-BP-ITEM-ID        TO WS-DB2-KEY-3N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8717-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8720-UPDATE-CCC.                                                 
           EXEC SQL                                                     
                UPDATE CSS_CONNECT_CHRG                                 
                SET   DATE_CCC_BILLED  =  IIF(TRY_CONVERT(DATE, 
                                                    :CC-DATE-CCC-BILLED
              ) IS NULL OR (PATINDEX('%.%', :CC-DATE-CCC-BILLED
              ) <> 0) OR (LEN(:CC-DATE-CCC-BILLED
              ) <> 10), CIS.CHAR2DATE(:CC-DATE-CCC-BILLED
              ), CONVERT(DATE, :CC-DATE-CCC-BILLED) ),          
                      LAST_UPDATE_TS   =  CIS.CURRENT$TIMESTAMP()             
                WHERE ACCOUNT_NO       =  :AC-ACCOUNT-NO                
                  AND CCC_ITEM_ID      =  :AC-ITEM-ID                   
                  AND LAST_UPDATE_TS   =  CIS.CHAR2TIMESTAMP(
                                                     :CC-LAST-UPDATE-TS
              )            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_CONNECT_CHRG                                         
MFA-TR*         SET   DATE_CCC_BILLED  =  :CC-DATE-CCC-BILLED,                  
MFA-TR*               LAST_UPDATE_TS   =  CURRENT TIMESTAMP                     
MFA-TR*         WHERE ACCOUNT_NO       =  :AC-ACCOUNT-NO                        
MFA-TR*           AND CCC_ITEM_ID      =  :AC-ITEM-ID                           
MFA-TR*           AND LAST_UPDATE_TS   =  :CC-LAST-UPDATE-TS                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
T10534        WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE 'CC'                 TO WS-DB2-TABLE-ID           
                 MOVE 'INSERT'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '113'                TO WS-DB2-MODULE-ID          
                 MOVE '8720'               TO WS-DB2-PARAGRAPH          
                 MOVE AC-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE AC-ITEM-ID           TO WS-DB2-KEY-2N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-EVALUATE.                                                
       8720-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
T17931 8725-INSERT-CCC.                                                 
T17931     EXEC SQL                                                     
T17931        INSERT INTO CSS_CONNECT_CHRG                              
T17931               (ACCOUNT_NO,                                       
T17931                PYMT_PRIORITY_LVL,                                
T17931                CCC_ITEM_ID,                                      
T17931                AMT_ORIG_ENTERED,                                 
T17931                CODE_CCC_TYPE,                                    
T17931                AMT_TAX_STATE,                                    
T17931                AMT_TAX_CITY,                                     
T17931                AMT_TAX_XCISE,                                    
T17931                AMT_TAX_OTHER,                                    
T17931                AMT_TRANS,                                        
T17931                DATE_CCC_BILLED,                                  
T17931                DATE_TRANS,                                       
T17931                LAST_UPDATE_TS,                                   
T17931                RCNCT_TYPE_NO)                                    
T17931        VALUES (:CC-ACCOUNT-NO,                                   
T17931                :CC-PYMT-PRIORITY-LVL,                            
T17931                :CC-CCC-ITEM-ID,                                  
T17931                :CC-AMT-ORIG-ENTERED,                             
T17931                :CC-CODE-CCC-TYPE,                                
T17931                :CC-AMT-TAX-STATE,                                
T17931                :CC-AMT-TAX-CITY,                                 
T17931                :CC-AMT-TAX-XCISE,                                
T17931                :CC-AMT-TAX-OTHER,                                
T17931                :CC-AMT-TRANS,                                    
T17931                IIF(TRY_CONVERT(DATE, :CC-DATE-CCC-BILLED 
                                            :WS-NULL-IND-17
              ) IS NULL OR (PATINDEX('%.%', :CC-DATE-CCC-BILLED 
                                                        :WS-NULL-IND-17
              ) <> 0) OR (LEN(:CC-DATE-CCC-BILLED :WS-NULL-IND-17
              ) <> 10), CIS.CHAR2DATE(:CC-DATE-CCC-BILLED 
                                                        :WS-NULL-IND-17
              ), CONVERT(DATE, :CC-DATE-CCC-BILLED :WS-NULL-IND-17) ),         
T17931                IIF(TRY_CONVERT(DATE, :CC-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :CC-DATE-TRANS
              ) <> 0) OR (LEN(:CC-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :CC-DATE-TRANS
              ), CONVERT(DATE, :CC-DATE-TRANS) ),                              
T17931                CIS.CURRENT$TIMESTAMP(),                                
T17931                :CC-RCNCT-TYPE-NO)                                
T17931     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CONNECT_CHRG                                      
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*               PYMT_PRIORITY_LVL,                                        
MFA-TR*               CCC_ITEM_ID,                                              
MFA-TR*               AMT_ORIG_ENTERED,                                         
MFA-TR*               CODE_CCC_TYPE,                                            
MFA-TR*               AMT_TAX_STATE,                                            
MFA-TR*               AMT_TAX_CITY,                                             
MFA-TR*               AMT_TAX_XCISE,                                            
MFA-TR*               AMT_TAX_OTHER,                                            
MFA-TR*               AMT_TRANS,                                                
MFA-TR*               DATE_CCC_BILLED,                                          
MFA-TR*               DATE_TRANS,                                               
MFA-TR*               LAST_UPDATE_TS,                                           
MFA-TR*               RCNCT_TYPE_NO)                                            
MFA-TR*       VALUES (:CC-ACCOUNT-NO,                                           
MFA-TR*               :CC-PYMT-PRIORITY-LVL,                                    
MFA-TR*               :CC-CCC-ITEM-ID,                                          
MFA-TR*               :CC-AMT-ORIG-ENTERED,                                     
MFA-TR*               :CC-CODE-CCC-TYPE,                                        
MFA-TR*               :CC-AMT-TAX-STATE,                                        
MFA-TR*               :CC-AMT-TAX-CITY,                                         
MFA-TR*               :CC-AMT-TAX-XCISE,                                        
MFA-TR*               :CC-AMT-TAX-OTHER,                                        
MFA-TR*               :CC-AMT-TRANS,                                            
MFA-TR*               :CC-DATE-CCC-BILLED:WS-NULL-IND-17,                       
MFA-TR*               :CC-DATE-TRANS,                                           
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*               :CC-RCNCT-TYPE-NO)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T17931                                                                  
                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
T17931        WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE 'CC'                 TO WS-DB2-TABLE-ID           
                 MOVE 'INSERT'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '113'                TO WS-DB2-MODULE-ID          
                 MOVE '8725'               TO WS-DB2-PARAGRAPH          
                 MOVE AC-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE AC-ITEM-ID           TO WS-DB2-KEY-2N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-EVALUATE.                                                
       8725-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8730-UPDATE-DFA-ACCT.                                            
           EXEC SQL                                                     
              UPDATE CSS_DFA_ACCT                                       
                 SET AMT_MO_PYMT      = :DA-AMT-MO-PYMT,                
                     CODE_DFA_STATUS  = :DA-CODE-DFA-STATUS,            
                     RCNTLY_BLLD_MTH  = :DA-RCNTLY-BLLD-MTH,            
T30467               REVENUE_MONTH    = :DA-REVENUE-MONTH,              
                     LAST_UPDATE_TS   = CIS.CURRENT$TIMESTAMP()               
                 WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO               
                   AND PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL        
                   AND DFA_ITEM_ID       = :DA-DFA-ITEM-ID              
                   AND LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :DA-LAST-UPDATE-TS
              )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_DFA_ACCT                                               
MFA-TR*          SET AMT_MO_PYMT      = :DA-AMT-MO-PYMT,                        
MFA-TR*              CODE_DFA_STATUS  = :DA-CODE-DFA-STATUS,                    
MFA-TR*              RCNTLY_BLLD_MTH  = :DA-RCNTLY-BLLD-MTH,                    
MFA-TR*              REVENUE_MONTH    = :DA-REVENUE-MONTH,                      
MFA-TR*              LAST_UPDATE_TS   = CURRENT TIMESTAMP                       
MFA-TR*          WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO                       
MFA-TR*            AND PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL                
MFA-TR*            AND DFA_ITEM_ID       = :DA-DFA-ITEM-ID                      
MFA-TR*            AND LAST_UPDATE_TS    = :DA-LAST-UPDATE-TS                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 DISPLAY 'TS CHANGED'                                   
                 MOVE 4 TO RETURN-CODE                                  
              WHEN OTHER                                                
                 MOVE 'DA'                 TO WS-DB2-TABLE-ID           
                 MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '113'                TO WS-DB2-MODULE-ID          
                 MOVE '8730'               TO WS-DB2-PARAGRAPH          
                 MOVE DA-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE DA-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N             
                 MOVE DA-DFA-ITEM-ID       TO WS-DB2-KEY-3N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       8730-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8731-INSERT-DFA-ACCT.                                            
           IF DA-DATE-PYMT-START  = LOW-VALUES                          
              MOVE -1 TO WS-NULL-IND-2                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-2                                
           END-IF                                                       
                                                                        
           IF DA-FRST-ERNST-PAY-DT = LOW-VALUES                         
              MOVE -1 TO WS-NULL-IND-3                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-3                                
           END-IF                                                       
                                                                        
           IF DA-SCND-ERNST-PAY-DT = LOW-VALUES                         
              MOVE -1 TO WS-NULL-IND-4                                  
           ELSE                                                         
              MOVE ZERO TO WS-NULL-IND-4                                
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_DFA_ACCT                                  
                 ( ACCOUNT_NO,                                          
                   PYMT_PRIORITY_LVL,                                   
                   DFA_ITEM_ID,                                         
                   DATE_OF_AGREE,                                       
                   CODE_DFA_TYPE,                                       
                   AMT_MO_PYMT,                                         
                   DATE_PYMT_START,                                     
                   NO_SCHED_PYMTS,                                      
                   AMT_ORIG_ENTERED,                                    
                   CSR_USERID,                                          
                   CODE_DFA_STATUS,                                     
                   RCNTLY_BLLD_MTH,                                     
                   AMT_UNDEFERD_RECV,                                   
                   CODE_DFA_DESC,                                       
                   AMT_EXTRA_DEPOSIT,                                   
                   REVERSE_REASON,                                      
                   CODE_COMPLY_HIST,                                    
                   FRST_ERNST_PAY_DT,                                   
                   FRST_ERNST_PAY_AMT,                                  
                   SCND_ERNST_PAY_DT,                                   
                   SCND_ERNST_PAY_AMT,                                  
                   PYMNT_ARNGMNT_CMTS,                                  
                   LAST_UPDATE_TS,                                      
T19929             ACCT_XFER_FROM,                                      
T30467             REVENUE_MONTH)                                       
           VALUES                                                       
                 ( :DA-ACCOUNT-NO,                                      
                   :DA-PYMT-PRIORITY-LVL,                               
                   :DA-DFA-ITEM-ID,                                     
                   IIF(TRY_CONVERT(DATE, :DA-DATE-OF-AGREE
              ) IS NULL OR (PATINDEX('%.%', :DA-DATE-OF-AGREE
              ) <> 0) OR (LEN(:DA-DATE-OF-AGREE) <> 10), CIS.CHAR2DATE(
                                                      :DA-DATE-OF-AGREE
              ), CONVERT(DATE, :DA-DATE-OF-AGREE) ),                           
                   :DA-CODE-DFA-TYPE,                                   
                   :DA-AMT-MO-PYMT,                                     
                   IIF(TRY_CONVERT(DATE, :DA-DATE-PYMT-START 
                                         :WS-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :DA-DATE-PYMT-START 
                                                         :WS-NULL-IND-2
              ) <> 0) OR (LEN(:DA-DATE-PYMT-START :WS-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:DA-DATE-PYMT-START 
                                                         :WS-NULL-IND-2
              ), CONVERT(DATE, :DA-DATE-PYMT-START :WS-NULL-IND-2) ),          
                   :DA-NO-SCHED-PYMTS,                                  
                   :DA-AMT-ORIG-ENTERED,                                
                   :DA-CSR-USERID,                                      
                   :DA-CODE-DFA-STATUS,                                 
                   :DA-RCNTLY-BLLD-MTH,                                 
                   :DA-AMT-UNDEFERD-RECV,                               
                   :DA-CODE-DFA-DESC,                                   
                   :DA-AMT-EXTRA-DEPOSIT,                               
                   :DA-REVERSE-REASON,                                  
                   :DA-CODE-COMPLY-HIST,                                
                   IIF(TRY_CONVERT(DATE, :DA-FRST-ERNST-PAY-DT 
                                         :WS-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :DA-FRST-ERNST-PAY-DT 
                                                         :WS-NULL-IND-3
              ) <> 0) OR (LEN(:DA-FRST-ERNST-PAY-DT :WS-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:DA-FRST-ERNST-PAY-DT 
                                                         :WS-NULL-IND-3
              ), CONVERT(DATE, :DA-FRST-ERNST-PAY-DT :WS-NULL-IND-3) ),        
                   :DA-FRST-ERNST-PAY-AMT,                              
                   IIF(TRY_CONVERT(DATE, :DA-SCND-ERNST-PAY-DT 
                                         :WS-NULL-IND-4
              ) IS NULL OR (PATINDEX('%.%', :DA-SCND-ERNST-PAY-DT 
                                                         :WS-NULL-IND-4
              ) <> 0) OR (LEN(:DA-SCND-ERNST-PAY-DT :WS-NULL-IND-4
              ) <> 10), CIS.CHAR2DATE(:DA-SCND-ERNST-PAY-DT 
                                                         :WS-NULL-IND-4
              ), CONVERT(DATE, :DA-SCND-ERNST-PAY-DT :WS-NULL-IND-4) ),        
                   :DA-SCND-ERNST-PAY-AMT,                              
                   :DA-PYMNT-ARNGMNT-CMTS,                              
                   CIS.CURRENT$TIMESTAMP(),                                   
T19929             :DA-ACCT-XFER-FROM,                                  
T30467             :DA-REVENUE-MONTH)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_DFA_ACCT                                          
MFA-TR*          ( ACCOUNT_NO,                                                  
MFA-TR*            PYMT_PRIORITY_LVL,                                           
MFA-TR*            DFA_ITEM_ID,                                                 
MFA-TR*            DATE_OF_AGREE,                                               
MFA-TR*            CODE_DFA_TYPE,                                               
MFA-TR*            AMT_MO_PYMT,                                                 
MFA-TR*            DATE_PYMT_START,                                             
MFA-TR*            NO_SCHED_PYMTS,                                              
MFA-TR*            AMT_ORIG_ENTERED,                                            
MFA-TR*            CSR_USERID,                                                  
MFA-TR*            CODE_DFA_STATUS,                                             
MFA-TR*            RCNTLY_BLLD_MTH,                                             
MFA-TR*            AMT_UNDEFERD_RECV,                                           
MFA-TR*            CODE_DFA_DESC,                                               
MFA-TR*            AMT_EXTRA_DEPOSIT,                                           
MFA-TR*            REVERSE_REASON,                                              
MFA-TR*            CODE_COMPLY_HIST,                                            
MFA-TR*            FRST_ERNST_PAY_DT,                                           
MFA-TR*            FRST_ERNST_PAY_AMT,                                          
MFA-TR*            SCND_ERNST_PAY_DT,                                           
MFA-TR*            SCND_ERNST_PAY_AMT,                                          
MFA-TR*            PYMNT_ARNGMNT_CMTS,                                          
MFA-TR*            LAST_UPDATE_TS,                                              
MFA-TR*            ACCT_XFER_FROM,                                              
MFA-TR*            REVENUE_MONTH)                                               
MFA-TR*    VALUES                                                               
MFA-TR*          ( :DA-ACCOUNT-NO,                                              
MFA-TR*            :DA-PYMT-PRIORITY-LVL,                                       
MFA-TR*            :DA-DFA-ITEM-ID,                                             
MFA-TR*            :DA-DATE-OF-AGREE,                                           
MFA-TR*            :DA-CODE-DFA-TYPE,                                           
MFA-TR*            :DA-AMT-MO-PYMT,                                             
MFA-TR*            :DA-DATE-PYMT-START :WS-NULL-IND-2,                          
MFA-TR*            :DA-NO-SCHED-PYMTS,                                          
MFA-TR*            :DA-AMT-ORIG-ENTERED,                                        
MFA-TR*            :DA-CSR-USERID,                                              
MFA-TR*            :DA-CODE-DFA-STATUS,                                         
MFA-TR*            :DA-RCNTLY-BLLD-MTH,                                         
MFA-TR*            :DA-AMT-UNDEFERD-RECV,                                       
MFA-TR*            :DA-CODE-DFA-DESC,                                           
MFA-TR*            :DA-AMT-EXTRA-DEPOSIT,                                       
MFA-TR*            :DA-REVERSE-REASON,                                          
MFA-TR*            :DA-CODE-COMPLY-HIST,                                        
MFA-TR*            :DA-FRST-ERNST-PAY-DT :WS-NULL-IND-3,                        
MFA-TR*            :DA-FRST-ERNST-PAY-AMT,                                      
MFA-TR*            :DA-SCND-ERNST-PAY-DT :WS-NULL-IND-4,                        
MFA-TR*            :DA-SCND-ERNST-PAY-AMT,                                      
MFA-TR*            :DA-PYMNT-ARNGMNT-CMTS,                                      
MFA-TR*            CURRENT TIMESTAMP,                                           
MFA-TR*            :DA-ACCT-XFER-FROM,                                          
MFA-TR*            :DA-REVENUE-MONTH)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'DA'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '113'                TO WS-DB2-MODULE-ID             
              MOVE '8731'               TO WS-DB2-PARAGRAPH             
              MOVE DA-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE DA-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N                
              MOVE DA-DFA-ITEM-ID       TO WS-DB2-KEY-3N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       8731-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
T17946 8734-DELETE-DFA-RECV.                                            
T17946     EXEC SQL                                                     
T17946        DELETE FROM CSS_DFA_RECVBLE                               
T17946        WHERE ACCOUNT_NO = :DA-ACCOUNT-NO                         
T17946          AND AGREEMENT_NO = :DA-DFA-ITEM-ID                      
T17946          AND PYMT_PRIORITY_LVL = :DV-PYMT-PRIORITY-LVL           
T17946          AND DFA_PYMT_PRIORITY = :DV-DFA-PYMT-PRIORITY           
T17946          AND CNT_ITEM_ID = :DV-CNT-ITEM-ID                       
T17946     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T17946                                                                  
T17946     IF SQLCODE NOT = SUCCESSFUL-CALL                             
T17946        MOVE 'DV'                 TO WS-DB2-TABLE-ID              
T17946        MOVE 'DELETE'             TO WS-DB2-FUNCTION              
T17946        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T17946        MOVE '113'                TO WS-DB2-MODULE-ID             
T17946        MOVE '8734'               TO WS-DB2-PARAGRAPH             
T17946        MOVE DA-ACCOUNT-NO        TO WS-DB2-KEY-1N                
T17946        MOVE DA-DFA-ITEM-ID       TO WS-DB2-KEY-2N                
T17946        MOVE DV-PYMT-PRIORITY-LVL TO WS-DB2-KEY-3N                
T17946        MOVE 12 TO RETURN-CODE                                    
T17946        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
T17946     END-IF.                                                      
T17946                                                                  
T17946                                                                  
T17946 8734-EXIT.                                                       
T17946     EXIT.                                                        
      /                                                                         
       8735-UPDATE-DFA-RECV.                                            
           EXEC SQL                                                     
              UPDATE CSS_DFA_RECVBLE                                    
              SET AMT_DAY_00  = :DV-AMT-DAY-00,                         
                  AMT_DAY_30  = :DV-AMT-DAY-30,                         
                  AMT_DAY_60 = :DV-AMT-DAY-60,                          
                  AMT_DAY_90 = :DV-AMT-DAY-90,                          
T17946            AMT_CONTRACT_DEFR = :DV-AMT-CONTRACT-DEFR             
              WHERE ACCOUNT_NO = :DA-ACCOUNT-NO                         
                AND AGREEMENT_NO = :DA-DFA-ITEM-ID                      
                AND PYMT_PRIORITY_LVL = :DV-PYMT-PRIORITY-LVL           
TP6213          AND DFA_PYMT_PRIORITY = :DV-DFA-PYMT-PRIORITY           
PCR393          AND CNT_ITEM_ID = :DV-CNT-ITEM-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'DV'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '113'                TO WS-DB2-MODULE-ID             
              MOVE '8735'               TO WS-DB2-PARAGRAPH             
              MOVE DA-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE DA-DFA-ITEM-ID       TO WS-DB2-KEY-2N                
              MOVE DV-PYMT-PRIORITY-LVL TO WS-DB2-KEY-3N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
                                                                        
       8735-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8736-INSERT-DFA-RECV.                                            
           EXEC SQL                                                     
              INSERT INTO CSS_DFA_RECVBLE (                             
                   ACCOUNT_NO,                                          
                   PYMT_PRIORITY_LVL,                                   
                   AGREEMENT_NO,                                        
                   AMT_CONTRACT_DEFR,                                   
                   AMT_DAY_00,                                          
                   AMT_DAY_30,                                          
                   AMT_DAY_60,                                          
                   AMT_DAY_90,                                          
                   DFA_PYMT_PRIORITY,                                   
PCR393             CNT_ITEM_ID )                                        
                VALUES (                                                
                   :DV-ACCOUNT-NO,                                      
                   :DV-PYMT-PRIORITY-LVL,                               
                   :DV-AGREEMENT-NO,                                    
                   :DV-AMT-CONTRACT-DEFR,                               
                   :DV-AMT-DAY-00,                                      
                   :DV-AMT-DAY-30,                                      
                   :DV-AMT-DAY-60,                                      
                   :DV-AMT-DAY-90,                                      
                   :DV-DFA-PYMT-PRIORITY,                               
PCR393             :DV-CNT-ITEM-ID)                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'DV'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '113'                TO WS-DB2-MODULE-ID             
              MOVE '8736'               TO WS-DB2-PARAGRAPH             
              MOVE DA-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE DA-DFA-ITEM-ID       TO WS-DB2-KEY-2N                
              MOVE DV-PYMT-PRIORITY-LVL TO WS-DB2-KEY-3N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       8736-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8760-UPDATE-CNT.                                                 
           EXEC SQL                                                     
                UPDATE CSS_CONTRACT                                     
                SET   INTRST_YTD       =  :CT-INTRST-YTD,               
                      INTRST_PRIOR_YR  =  :CT-INTRST-PRIOR-YR,          
                      AMT_DEF_INTEREST =  :CT-AMT-DEF-INTEREST,         
                      AMT_MO_PYMT      =  :CT-AMT-MO-PYMT,              
                      CNT_STATUS_CD    =  :CT-CNT-STATUS-CD,            
T32482                STATUS_CHANGE_DT =  IIF(TRY_CONVERT(DATE, 
                                                  :CT-STATUS-CHANGE-DT 
                                                         :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :CT-STATUS-CHANGE-DT 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:CT-STATUS-CHANGE-DT :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:CT-STATUS-CHANGE-DT 
                                                         :WS-NULL-IND-1
              ), CONVERT(DATE, :CT-STATUS-CHANGE-DT :WS-NULL-IND-1) ),         
                      LAST_UPDATE_TS   =  CIS.CURRENT$TIMESTAMP()             
                WHERE ACCOUNT_NO       =  :CT-ACCOUNT-NO                
                  AND CNT_ITEM_ID      =  :CT-CNT-ITEM-ID               
                  AND LAST_UPDATE_TS   =  CIS.CHAR2TIMESTAMP(
                                                     :CT-LAST-UPDATE-TS
              )            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_CONTRACT                                             
MFA-TR*         SET   INTRST_YTD       =  :CT-INTRST-YTD,                       
MFA-TR*               INTRST_PRIOR_YR  =  :CT-INTRST-PRIOR-YR,                  
MFA-TR*               AMT_DEF_INTEREST =  :CT-AMT-DEF-INTEREST,                 
MFA-TR*               AMT_MO_PYMT      =  :CT-AMT-MO-PYMT,                      
MFA-TR*               CNT_STATUS_CD    =  :CT-CNT-STATUS-CD,                    
MFA-TR*               STATUS_CHANGE_DT =  :CT-STATUS-CHANGE-DT                  
MFA-TR*                                   :WS-NULL-IND-1,                       
MFA-TR*               LAST_UPDATE_TS   =  CURRENT TIMESTAMP                     
MFA-TR*         WHERE ACCOUNT_NO       =  :CT-ACCOUNT-NO                        
MFA-TR*           AND CNT_ITEM_ID      =  :CT-CNT-ITEM-ID                       
MFA-TR*           AND LAST_UPDATE_TS   =  :CT-LAST-UPDATE-TS                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 4 TO RETURN-CODE                                  
                 DISPLAY 'TS CHANGED'                                   
              WHEN OTHER                                                
                 MOVE 'CT'                 TO WS-DB2-TABLE-ID           
                 MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
                 MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
                 MOVE '113'                TO WS-DB2-MODULE-ID          
                 MOVE '8760'               TO WS-DB2-PARAGRAPH          
                 MOVE CT-ACCOUNT-NO        TO WS-DB2-KEY-1N             
                 MOVE CT-CNT-ITEM-ID       TO WS-DB2-KEY-2N             
                 MOVE 12 TO RETURN-CODE                                 
                 PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       8760-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       8780-UPDATE-PJS.                                                 
T11624     IF PJ-ACCT-TERM-DT = LOW-VALUES OR SPACES                    
T11624        MOVE -1 TO WS-NULL-IND-1                                  
T11624     ELSE                                                         
T11624        MOVE ZERO TO WS-NULL-IND-1                                
T11624     END-IF                                                       
           EXEC SQL                                                     
                UPDATE CSS_PROJ_SHARE                                   
                SET   TOT_PREV_AM     = :PJ-TOT-PREV-AM,                
                      TOT_YTD_AM      = :PJ-TOT-YTD-AM,                 
                      SHARE_STATUS_CD = :PJ-SHARE-STATUS-CD,            
T11624                ACCT_TERM_DT    = IIF(TRY_CONVERT(DATE, 
                                                      :PJ-ACCT-TERM-DT 
                                                         :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :PJ-ACCT-TERM-DT 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:PJ-ACCT-TERM-DT :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:PJ-ACCT-TERM-DT :WS-NULL-IND-1
              ), CONVERT(DATE, :PJ-ACCT-TERM-DT :WS-NULL-IND-1) )  
                WHERE ACCOUNT_NO      =  :AC-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_PROJ_SHARE                                           
MFA-TR*         SET   TOT_PREV_AM     = :PJ-TOT-PREV-AM,                        
MFA-TR*               TOT_YTD_AM      = :PJ-TOT-YTD-AM,                         
MFA-TR*               SHARE_STATUS_CD = :PJ-SHARE-STATUS-CD,                    
MFA-TR*               ACCT_TERM_DT    = :PJ-ACCT-TERM-DT:WS-NULL-IND-1          
MFA-TR*         WHERE ACCOUNT_NO      =  :AC-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'PJ'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '113'                TO WS-DB2-MODULE-ID             
              MOVE '8780'               TO WS-DB2-PARAGRAPH             
              MOVE AC-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8780-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /                                                                         
       8785-DELETE-AR-CNTL-ITEM.                                        
           EXEC SQL                                                     
T5832           DELETE FROM CSS_AR_CNTL                                 
T5832           WHERE ACCOUNT_NO        =  :AC-ACCOUNT-NO               
TP6117            AND PYMT_PRIORITY_LVL =  :AC-PYMT-PRIORITY-LVL        
TP6117            AND ITEM_ID           =  :AC-ITEM-ID                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'AC'                 TO WS-DB2-TABLE-ID              
              MOVE 'DELETE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '113'                TO WS-DB2-MODULE-ID             
              MOVE '8785'               TO WS-DB2-PARAGRAPH             
              MOVE AC-ACCOUNT-NO        TO WS-DB2-KEY-1N                
TP6117        MOVE AC-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N                
TP6117        MOVE AC-ITEM-ID           TO WS-DB2-KEY-3N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8785-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8800-UPDATE-MSTSUB-ACCT.                                         
           EXEC SQL                                                     
              UPDATE CSS_MSTSUB_ACCT                                    
                 SET SUB_ACCT_BLLD_OK = :MU-SUB-ACCT-BLLD-OK            
               WHERE SUB_ACCT_NO      = :MU-SUB-ACCT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'MU'                 TO WS-DB2-TABLE-ID              
              MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '113'                TO WS-DB2-MODULE-ID             
              MOVE '8800'               TO WS-DB2-PARAGRAPH             
              MOVE MU-SUB-ACCT-NO       TO WS-DB2-KEY-1N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T11939 8810-UPDATE-PENDING-XFER.                                        
T11939     EXEC SQL                                                     
T11939        UPDATE CSS_PENDING_XFER                                   
T16491           SET SUB_ACCT_BLLD_OK = :MU-SUB-ACCT-BLLD-OK            
T11939         WHERE ACCT_XFER_FROM   = :XP-ACCT-XFER-FROM              
T11939           AND ACCT_XFER_TO     = :XP-ACCT-XFER-TO                
T11939           AND PREMISE_NO       = :XP-PREMISE-NO                  
T11939     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11939     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
T11939        NEXT SENTENCE                                             
T11939     ELSE                                                         
T11939        MOVE 'XP'                 TO WS-DB2-TABLE-ID              
T11939        MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
T11939        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T11939        MOVE '113'                TO WS-DB2-MODULE-ID             
T11939        MOVE '8810'               TO WS-DB2-PARAGRAPH             
T11939        MOVE XP-ACCT-XFER-FROM    TO WS-DB2-KEY-1N                
T11939        MOVE 12 TO RETURN-CODE                                    
T11939        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
T11939     END-IF.                                                      
T11939 8810-EXIT.                                                       
T11939     EXIT.                                                        
T11939*                                                                         
T11939 8820-UPDATE-PENDING-XFER.                                        
T11939     EXEC SQL                                                     
T11939        UPDATE CSS_PENDING_XFER                                   
T11939           SET SUB_ACCT_BLLD_OK = :WS-YES                         
T11939         WHERE ACCT_XFER_TO     = :MU-MST-ACCT-NO                 
T15098           AND ACCT_XFER_FROM IN                                  
T11939               (SELECT SUB_ACCT_NO                                
T11939                  FROM CSS_MSTSUB_ACCT                            
T11939                 WHERE SUB_ACCT_BLLD_OK = :WS-TRANSFER            
T11939                   AND MST_ACCT_NO      = :MU-MST-ACCT-NO)        
P00399                                                      
T11939     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PENDING_XFER                                           
MFA-TR*          SET SUB_ACCT_BLLD_OK = :WS-YES                                 
MFA-TR*        WHERE ACCT_XFER_TO     = :MU-MST-ACCT-NO                         
MFA-TR*          AND ACCT_XFER_FROM IN                                          
MFA-TR*              (SELECT SUB_ACCT_NO                                        
MFA-TR*                 FROM CSS_MSTSUB_ACCT                                    
MFA-TR*                WHERE SUB_ACCT_BLLD_OK = :WS-TRANSFER                    
MFA-TR*                  AND MST_ACCT_NO      = :MU-MST-ACCT-NO)                
MFA-TR*       QUERYNO 8820                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11939     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
T11939        NEXT SENTENCE                                             
T11939     ELSE                                                         
T11939        MOVE 'XP'                 TO WS-DB2-TABLE-ID              
T11939        MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
T11939        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T11939        MOVE '113'                TO WS-DB2-MODULE-ID             
T11939        MOVE '8820'               TO WS-DB2-PARAGRAPH             
T11939        MOVE XP-ACCT-XFER-FROM    TO WS-DB2-KEY-1N                
T11939        MOVE 12 TO RETURN-CODE                                    
T11939        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
T11939     END-IF.                                                      
T11939 8820-EXIT.                                                       
T11939     EXIT.                                                        
T11939*                                                                         
T11939 8830-UPDATE-SUB-ACCT-BLLD.                                       
T11939     EXEC SQL                                                     
T11939        UPDATE CSS_MSTSUB_ACCT                                    
T11939           SET SUB_ACCT_BLLD_OK = :MU-SUB-ACCT-BLLD-OK            
T11939         WHERE MST_ACCT_NO      = :MU-MST-ACCT-NO                 
T11939           AND SUB_ACCT_BLLD_OK = :WS-PREV-SUB-ACCT-BLLD          
T11939     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11939     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
T11939        NEXT SENTENCE                                             
T11939     ELSE                                                         
T11939        MOVE 'MU'                 TO WS-DB2-TABLE-ID              
T11939        MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
T11939        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T11939        MOVE '113'                TO WS-DB2-MODULE-ID             
T11939        MOVE '8830'               TO WS-DB2-PARAGRAPH             
T11939        MOVE MU-MST-ACCT-NO       TO WS-DB2-KEY-1N                
T11939        MOVE 12 TO RETURN-CODE                                    
T11939        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
T11939     END-IF.                                                      
T11939 8830-EXIT.                                                       
T11939     EXIT.                                                        
T11939*                                                                         
T20380*********************************************************                 
T20380*     UPDATE SUB ACCOUNTS SUB_BLLD_OK FLAG IF                             
T20380*     ACCOUNT IS ACTIVE SO HE IS READY FOR NEXT MONTH.                    
T20380*********************************************************                 
T20380 8840-UPDATE-IF-ACTIVE.                                           
T20380     EXEC SQL                                                     
T20380        UPDATE CSS_MSTSUB_ACCT                                    
T20380           SET SUB_ACCT_BLLD_OK = :MU-SUB-ACCT-BLLD-OK            
T20380         WHERE MST_ACCT_NO      = :MU-MST-ACCT-NO                 
T20380           AND SUB_ACCT_BLLD_OK = :WS-PREV-SUB-ACCT-BLLD          
T21287           AND SUB_ACCT_NO IN                                     
T20380               (SELECT ACCOUNT_NO                                 
T20380                  FROM CSS_ACCOUNT                                
T20380                 WHERE ACCT_XFER_TO = :MU-MST-ACCT-NO             
T20380                   AND CODE_ACCT_STAT = 'A')                      
P00399                                                      
T20380     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_MSTSUB_ACCT                                            
MFA-TR*          SET SUB_ACCT_BLLD_OK = :MU-SUB-ACCT-BLLD-OK                    
MFA-TR*        WHERE MST_ACCT_NO      = :MU-MST-ACCT-NO                         
MFA-TR*          AND SUB_ACCT_BLLD_OK = :WS-PREV-SUB-ACCT-BLLD                  
MFA-TR*          AND SUB_ACCT_NO IN                                             
MFA-TR*              (SELECT ACCOUNT_NO                                         
MFA-TR*                 FROM CSS_ACCOUNT                                        
MFA-TR*                WHERE ACCT_XFER_TO = :MU-MST-ACCT-NO                     
MFA-TR*                  AND CODE_ACCT_STAT = 'A')                              
MFA-TR*       QUERYNO 8840                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20380     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
T20380        NEXT SENTENCE                                             
T20380     ELSE                                                         
T20380        MOVE 'MU'                 TO WS-DB2-TABLE-ID              
T20380        MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
T20380        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T20380        MOVE '113'                TO WS-DB2-MODULE-ID             
T20380        MOVE '8840'               TO WS-DB2-PARAGRAPH             
T20380        MOVE MU-MST-ACCT-NO       TO WS-DB2-KEY-1N                
T20380        MOVE 12 TO RETURN-CODE                                    
T20380        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
T20380     END-IF.                                                      
T20380 8840-EXIT.                                                       
T20380     EXIT.                                                        
T20380*                                                                         
T11939 8860-INSERT-OFF-CYCLE.                                           
T11939     EXEC SQL                                                     
T11939        INSERT INTO CSS_OFF_CYCL_ACCT                             
T11939               (ACCOUNT_NO,                                       
T11939                CODE_BILL_OFF_CYCL,                               
T11939                CUSTOMER_NO,                                      
T11939                LAST_UPDATE_TS)                                   
T11939        VALUES (:OC-ACCOUNT-NO,                                   
T11939                :OC-CODE-BILL-OFF-CYCL,                           
T11939                :OC-CUSTOMER-NO,                                  
T11939                CIS.CURRENT$TIMESTAMP())                                
T11939     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_OFF_CYCL_ACCT                                     
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*               CODE_BILL_OFF_CYCL,                                       
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               LAST_UPDATE_TS)                                           
MFA-TR*       VALUES (:OC-ACCOUNT-NO,                                           
MFA-TR*               :OC-CODE-BILL-OFF-CYCL,                                   
MFA-TR*               :OC-CUSTOMER-NO,                                          
MFA-TR*               CURRENT TIMESTAMP)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11939     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T11939     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T11939       OR ALREADY-EXISTS                                          
T11939        CONTINUE                                                  
T11939     ELSE                                                         
T11939        MOVE 'OC'                 TO WS-DB2-TABLE-ID              
T11939        MOVE 'UPDATE'             TO WS-DB2-FUNCTION              
T11939        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T11939        MOVE '113'                TO WS-DB2-MODULE-ID             
T11939        MOVE '8860'               TO WS-DB2-PARAGRAPH             
T11939        MOVE OC-ACCOUNT-NO        TO WS-DB2-KEY-1N                
T11939        MOVE 12 TO RETURN-CODE                                    
T11939        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
T11939     END-IF.                                                      
T11939 8860-EXIT.                                                       
T11939     EXIT.                                                        
T11939*                                                                         
T11939 8890-DELETE-PENDING-XFER.                                        
T11939     EXEC SQL                                                     
T11939        DELETE FROM CSS_PENDING_XFER                              
T11939         WHERE ACCT_XFER_TO     = :XP-ACCT-XFER-TO                
T11939           AND SUB_ACCT_BLLD_OK = :WS-YES                         
T11939     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11939     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T11939     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T11939        CONTINUE                                                  
T11939     ELSE                                                         
T11939        MOVE 'XP'                 TO WS-DB2-TABLE-ID              
T11939        MOVE 'DELETE'             TO WS-DB2-FUNCTION              
T11939        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T11939        MOVE '113'                TO WS-DB2-MODULE-ID             
T11939        MOVE '8890'               TO WS-DB2-PARAGRAPH             
T11939        MOVE XP-ACCT-XFER-TO      TO WS-DB2-KEY-1N                
T11939        MOVE 12 TO RETURN-CODE                                    
T11939        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
T11939     END-IF.                                                      
T11939 8890-EXIT.                                                       
T11939     EXIT.                                                        
      *                                                                         
       8910-INSERT-CSS-REFUND.                                          
                                                                        
T12238     IF RN-DATE-REFUNDED = LOW-VALUES OR SPACES                   
T12238        MOVE -1 TO WS-NULL-IND-1                                  
T12238     ELSE                                                         
T12238        MOVE ZERO TO WS-NULL-IND-1                                
T12238     END-IF.                                                      
T12238     IF RN-REQUEST-DT = LOW-VALUES OR SPACES                      
T12238        MOVE -1 TO WS-NULL-IND-2                                  
T12238     ELSE                                                         
T12238        MOVE ZERO TO WS-NULL-IND-2                                
T12238     END-IF.                                                      
T12238     IF RN-REFUND-STATUS-DT = LOW-VALUES OR SPACES                
T12238        MOVE -1 TO WS-NULL-IND-3                                  
T12238     ELSE                                                         
T12238        MOVE ZERO TO WS-NULL-IND-3                                
T12238     END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_REFUND                                  
                  (REFUND_ITEM_ID,                                      
                   REFUND_CHECK_NO,                                     
                   DEPOSIT_CERT_NO,                                     
                   LOCAL_OFFICE,                                        
T12238             DATE_REFUNDED,                                       
                   AMT_REFUNDED,                                        
                   REQUEST_DT,                                          
                   CHECK_STATUS_CD,                                     
                   CHECK_ISS_REAS_CD,                                   
                   ORIGINAL_CHECK_NO,                                   
                   RETURNED_REASON,                                     
                   MANUAL_INDICATOR,                                    
                   USER_ID_APPRVD_BY,                                   
                   REFUND_STATUS_DT,                                    
                   USER_ID_RQSTED_BY,                                   
                   ACCOUNT_NO,                                          
                   PANEL_NO,                                            
                   ADDRESS_ID,                                          
                   TRANS_HIST_SEQ_NO,                                   
                   COMMENTS)                                            
                VALUES                                                  
                   (:RN-REFUND-ITEM-ID,                                 
                    :RN-REFUND-CHECK-NO,                                
                    :RN-DEPOSIT-CERT-NO,                                
                    :RN-LOCAL-OFFICE,                                   
T12238              IIF(TRY_CONVERT(DATE, :RN-DATE-REFUNDED 
                                          :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-REFUNDED :WS-NULL-IND-1
              ), CONVERT(DATE, :RN-DATE-REFUNDED :WS-NULL-IND-1) ),            
                    :RN-AMT-REFUNDED,                                   
T12238              IIF(TRY_CONVERT(DATE, :RN-REQUEST-DT :WS-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT 
                                                         :WS-NULL-IND-2
              ) <> 0) OR (LEN(:RN-REQUEST-DT :WS-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:RN-REQUEST-DT :WS-NULL-IND-2
              ), CONVERT(DATE, :RN-REQUEST-DT :WS-NULL-IND-2) ),               
                    :RN-CHECK-STATUS-CD,                                
                    :RN-CHECK-ISS-REAS-CD,                              
                    :RN-ORIGINAL-CHECK-NO,                              
                    :RN-RETURNED-REASON,                                
                    :RN-MANUAL-INDICATOR,                               
                    :RN-USER-ID-APPRVD-BY,                              
T12238              IIF(TRY_CONVERT(DATE, :RN-REFUND-STATUS-DT 
                                          :WS-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT 
                                                         :WS-NULL-IND-3
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT :WS-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT 
                                                         :WS-NULL-IND-3
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT :WS-NULL-IND-3) ),         
                    :RN-USER-ID-RQSTED-BY,                              
                    :RN-ACCOUNT-NO,                                     
                    :RN-PANEL-NO,                                       
                    :RN-ADDRESS-ID,                                     
                    CIS.CURRENT$TIMESTAMP(),                                  
                    :RN-COMMENTS)                                       
                END-EXEC.                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_REFUND                                          
MFA-TR*           (REFUND_ITEM_ID,                                              
MFA-TR*            REFUND_CHECK_NO,                                             
MFA-TR*            DEPOSIT_CERT_NO,                                             
MFA-TR*            LOCAL_OFFICE,                                                
MFA-TR*            DATE_REFUNDED,                                               
MFA-TR*            AMT_REFUNDED,                                                
MFA-TR*            REQUEST_DT,                                                  
MFA-TR*            CHECK_STATUS_CD,                                             
MFA-TR*            CHECK_ISS_REAS_CD,                                           
MFA-TR*            ORIGINAL_CHECK_NO,                                           
MFA-TR*            RETURNED_REASON,                                             
MFA-TR*            MANUAL_INDICATOR,                                            
MFA-TR*            USER_ID_APPRVD_BY,                                           
MFA-TR*            REFUND_STATUS_DT,                                            
MFA-TR*            USER_ID_RQSTED_BY,                                           
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            PANEL_NO,                                                    
MFA-TR*            ADDRESS_ID,                                                  
MFA-TR*            TRANS_HIST_SEQ_NO,                                           
MFA-TR*            COMMENTS)                                                    
MFA-TR*         VALUES                                                          
MFA-TR*            (:RN-REFUND-ITEM-ID,                                         
MFA-TR*             :RN-REFUND-CHECK-NO,                                        
MFA-TR*             :RN-DEPOSIT-CERT-NO,                                        
MFA-TR*             :RN-LOCAL-OFFICE,                                           
MFA-TR*             :RN-DATE-REFUNDED:WS-NULL-IND-1,                            
MFA-TR*             :RN-AMT-REFUNDED,                                           
MFA-TR*             :RN-REQUEST-DT:WS-NULL-IND-2,                               
MFA-TR*             :RN-CHECK-STATUS-CD,                                        
MFA-TR*             :RN-CHECK-ISS-REAS-CD,                                      
MFA-TR*             :RN-ORIGINAL-CHECK-NO,                                      
MFA-TR*             :RN-RETURNED-REASON,                                        
MFA-TR*             :RN-MANUAL-INDICATOR,                                       
MFA-TR*             :RN-USER-ID-APPRVD-BY,                                      
MFA-TR*             :RN-REFUND-STATUS-DT:WS-NULL-IND-3,                         
MFA-TR*             :RN-USER-ID-RQSTED-BY,                                      
MFA-TR*             :RN-ACCOUNT-NO,                                             
MFA-TR*             :RN-PANEL-NO,                                               
MFA-TR*             :RN-ADDRESS-ID,                                             
MFA-TR*             CURRENT TIMESTAMP,                                          
MFA-TR*             :RN-COMMENTS)                                               
MFA-TR*         END-EXEC.                                                       

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'RN'             TO  WS-DB2-TABLE-ID                 
              MOVE 'INSERT'         TO  WS-DB2-FUNCTION                 
              MOVE SQLCODE          TO  WS-DB2-RETURN-CODE              
              MOVE '113'            TO  WS-DB2-MODULE-ID                
              MOVE '8910'           TO  WS-DB2-PARAGRAPH                
              MOVE 12               TO  RETURN-CODE                     
              PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
           END-IF.                                                      
       8910-EXIT.                                                       
           EXIT.                                                        
P00453******************************************************************        
P00453* 8920-UPDATE-PREPAY-HIST                                        *        
P00453******************************************************************        
P00453*                                                                         
P00453  8920-UPDATE-PREPAY-HIST.                                        
P00453*                                                                         
P00453     EXEC SQL                                                     
P00453          UPDATE CSS_PREPAY_HIST                                  
P00453          SET   REVENUE_MONTH      = :PK-REVENUE-MONTH            
P00453               ,EST_METHOD_CD      = :PK-EST-METHOD-CD            
P00453               ,EST_NO_UNITS       = :PK-EST-NO-UNITS             
P00453               ,EST_UNIT_PRICE_AM  = :PK-EST-UNIT-PRICE-AM        
P00453               ,EST_ADDL_CHARGE_AM = :PK-EST-ADDL-CHARGE-AM       
P00453               ,EST_CUSTSVC_CHG_AM = :PK-EST-CUSTSVC-CHG-AM       
P00453               ,EST_MISC_CHARGE_AM = :PK-EST-MISC-CHARGE-AM       
P00453               ,EST_CONNECT_CHG_AM = :PK-EST-CONNECT-CHG-AM       
P00453               ,EST_BILL_AM        = :PK-EST-BILL-AM              
P00453               ,NET_BILL_ADJ_AM    = :PK-NET-BILL-ADJ-AM          
P00453               ,ARREARS_AMT        = :PK-ARREARS-AMT              
P00453               ,BILLED_AMT         = :PK-BILLED-AMT               
P00453               ,REMARKS            = :PK-REMARKS                  
P00453               ,PLAN_ACCT_BAL_AM   = :PK-PLAN-ACCT-BAL-AM         
P00453               ,BILL_VARIANCE_AM   = :PK-BILL-VARIANCE-AM         
P00453          WHERE ACCOUNT_NO         = :PK-ACCOUNT-NO               
P00453            AND PREPAY_HIST_SEQ_TS = CIS.CHAR2TIMESTAMP(
                                                 :PK-PREPAY-HIST-SEQ-TS
              )       
P00453     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_PREPAY_HIST                                          
MFA-TR*         SET   REVENUE_MONTH      = :PK-REVENUE-MONTH                    
MFA-TR*              ,EST_METHOD_CD      = :PK-EST-METHOD-CD                    
MFA-TR*              ,EST_NO_UNITS       = :PK-EST-NO-UNITS                     
MFA-TR*              ,EST_UNIT_PRICE_AM  = :PK-EST-UNIT-PRICE-AM                
MFA-TR*              ,EST_ADDL_CHARGE_AM = :PK-EST-ADDL-CHARGE-AM               
MFA-TR*              ,EST_CUSTSVC_CHG_AM = :PK-EST-CUSTSVC-CHG-AM               
MFA-TR*              ,EST_MISC_CHARGE_AM = :PK-EST-MISC-CHARGE-AM               
MFA-TR*              ,EST_CONNECT_CHG_AM = :PK-EST-CONNECT-CHG-AM               
MFA-TR*              ,EST_BILL_AM        = :PK-EST-BILL-AM                      
MFA-TR*              ,NET_BILL_ADJ_AM    = :PK-NET-BILL-ADJ-AM                  
MFA-TR*              ,ARREARS_AMT        = :PK-ARREARS-AMT                      
MFA-TR*              ,BILLED_AMT         = :PK-BILLED-AMT                       
MFA-TR*              ,REMARKS            = :PK-REMARKS                          
MFA-TR*              ,PLAN_ACCT_BAL_AM   = :PK-PLAN-ACCT-BAL-AM                 
MFA-TR*              ,BILL_VARIANCE_AM   = :PK-BILL-VARIANCE-AM                 
MFA-TR*         WHERE ACCOUNT_NO         = :PK-ACCOUNT-NO                       
MFA-TR*           AND PREPAY_HIST_SEQ_TS = :PK-PREPAY-HIST-SEQ-TS               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00453*                                                                         
P00453     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00453     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P00453        MOVE 'PK'                  TO WS-DB2-TABLE-ID             
P00453        MOVE 'UPDATE'              TO WS-DB2-FUNCTION             
P00453        MOVE SQLCODE               TO WS-DB2-RETURN-CODE          
P00453        MOVE '113'                 TO WS-DB2-MODULE-ID            
P00453        MOVE '8920'                TO WS-DB2-PARAGRAPH            
P00453        MOVE PK-ACCOUNT-NO         TO WS-DB2-KEY-1N               
P00453        MOVE PK-PREPAY-HIST-SEQ-TS TO WS-DB2-KEY-2N               
P00453        MOVE PK-REVENUE-MONTH      TO WS-DB2-KEY-3N               
P00453        MOVE PK-EST-METHOD-CD      TO WS-DB2-KEY-4N               
P00453        MOVE 12                    TO RETURN-CODE                 
P00453        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
P00453     END-IF.                                                      
P00453*                                                                         
P00453 8920-EXIT.                                                       
P00453     EXIT.                                                        
P00453*                                                                         
      /                                                                         
T12716 8950-INSERT-CANCEL-DNP.                                          
T12716     EXEC SQL                                                     
T12716        INSERT INTO CSS_SO_DNP_CANCEL                             
T12716               (ACCOUNT_NO,                                       
T12716                SO_UPDT_ACTION_FL)                                
T12716         VALUES                                                   
T12716               (:XK-ACCOUNT-NO,                                   
T12716                :XK-SO-UPDT-ACTION-FL)                            
T12716     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T12716     IF SQLCODE EQUAL SUCCESSFUL-CALL OR ALREADY-EXISTS           
T17443        CONTINUE                                                  
T17443     ELSE                                                         
T12716           MOVE 'XK'                 TO WS-DB2-TABLE-ID           
T12716           MOVE 'INSERT'             TO WS-DB2-FUNCTION           
T12716           MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
T12716           MOVE '113'                TO WS-DB2-MODULE-ID          
T12716           MOVE '8950'               TO WS-DB2-PARAGRAPH          
T12716           MOVE XK-ACCOUNT-NO        TO WS-DB2-KEY-1N             
T12716           MOVE XK-SO-UPDT-ACTION-FL TO WS-DB2-KEY-2N             
T12716           MOVE 12 TO RETURN-CODE                                 
T12716           PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
T12716     END-IF.                                                      
T12716 8950-EXIT.                                                       
T12716     EXIT.                                                        
      /                                                                         
T22113 8955-UPDATE-CANCEL-DNP.                                          
T22113     EXEC SQL                                                     
T22113        UPDATE CSS_SO_DNP_CANCEL                                  
T22113          SET   SO_UPDT_ACTION_FL = :XK-SO-UPDT-ACTION-FL         
T22113          WHERE ACCOUNT_NO        = :XK-ACCOUNT-NO                
T22113     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22113     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
T22113        CONTINUE                                                  
T22113     ELSE                                                         
T22113           MOVE 'XK'                 TO WS-DB2-TABLE-ID           
T22113           MOVE 'UPDATE'             TO WS-DB2-FUNCTION           
T22113           MOVE SQLCODE              TO WS-DB2-RETURN-CODE        
T22113           MOVE '113'                TO WS-DB2-MODULE-ID          
T22113           MOVE '8955'               TO WS-DB2-PARAGRAPH          
T22113           MOVE XK-ACCOUNT-NO        TO WS-DB2-KEY-1N             
T22113           MOVE XK-SO-UPDT-ACTION-FL TO WS-DB2-KEY-2N             
T22113           MOVE 12 TO RETURN-CODE                                 
T22113           PERFORM 9900-SQL-ERROR     THRU 9900-EXIT              
T22113     END-IF.                                                      
T22113 8955-EXIT.                                                       
T22113     EXIT.                                                        
A01355*                                                                 15160000
A01355******************************************************************15170000
A01355* 8970-INSERT-MN-TRANS-HIST.                                     *15180000
A01355******************************************************************15190000
A01355*                                                                 15200000
A01355 8970-INSERT-MNT-TRANS-HIST.                                      
A01355*                                                                 15220000
A01355     EXEC SQL                                                     
A01355          INSERT INTO CSS_MNT_TRANS_HIST                          
A01355               ( TRANS_HIST_SEQ_NO,                               
A01355                 DATE_TRANS,                                      
A01355                 CODE_TRAN_TYPE,                                  
A01355                 RESP_AREA_ID,                                    
A01355                 ACCOUNT_NO,                                      
A01355                 CUSTOMER_NO,                                     
A01355                 PREMISE_NO,                                      
A01355                 USER_ID,                                         
A01355                 APPL_PROGRAM_ID,                                 
A01355                 TRAN_COMMENT)                                    
A01355          VALUES                                                  
A01355               ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),               
A01355                 IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
A01355                 :MH-CODE-TRAN-TYPE,                              
A01355                 :MH-RESP-AREA-ID,                                
A01355                 :MH-ACCOUNT-NO,                                  
A01355                 :MH-CUSTOMER-NO,                                 
A01355                 :MH-PREMISE-NO,                                  
A01355                 :MH-USER-ID,                                     
A01355                 :MH-APPL-PROGRAM-ID,                             
A01355                 :MH-TRAN-COMMENT)                                
A01355     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15230000
MFA-TR*         INSERT INTO CSS_MNT_TRANS_HIST                          15240000
MFA-TR*              ( TRANS_HIST_SEQ_NO,                               15250000
MFA-TR*                DATE_TRANS,                                      15260000
MFA-TR*                CODE_TRAN_TYPE,                                  15270000
MFA-TR*                RESP_AREA_ID,                                    15280000
MFA-TR*                ACCOUNT_NO,                                      15290000
MFA-TR*                CUSTOMER_NO,                                     15300000
MFA-TR*                PREMISE_NO,                                      15310000
MFA-TR*                USER_ID,                                         15320000
MFA-TR*                APPL_PROGRAM_ID,                                 15330000
MFA-TR*                TRAN_COMMENT)                                    15340000
MFA-TR*         VALUES                                                  15360000
MFA-TR*              ( :MH-TRANS-HIST-SEQ-NO,                           15370000
MFA-TR*                :MH-DATE-TRANS,                                  15380000
MFA-TR*                :MH-CODE-TRAN-TYPE,                              15390000
MFA-TR*                :MH-RESP-AREA-ID,                                15400000
MFA-TR*                :MH-ACCOUNT-NO,                                  15410000
MFA-TR*                :MH-CUSTOMER-NO,                                 15420000
MFA-TR*                :MH-PREMISE-NO,                                  15430000
MFA-TR*                :MH-USER-ID,                                     15440000
MFA-TR*                :MH-APPL-PROGRAM-ID,                             15450000
MFA-TR*                :MH-TRAN-COMMENT)                                15460000
MFA-TR*    END-EXEC.                                                    15480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01355*                                                                 15490000
A01355     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
A01355                                                                  
A01355     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01355        NEXT SENTENCE                                             
A01355     ELSE                                                         
A01355        MOVE 'MH'                 TO WS-DB2-TABLE-ID              
A01355        MOVE 'INSERT'             TO WS-DB2-FUNCTION              
A01355        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
A01355        MOVE '113'                TO WS-DB2-MODULE-ID             
A01355        MOVE '8970'               TO WS-DB2-PARAGRAPH             
A01355        MOVE MH-ACCOUNT-NO        TO WS-DB2-KEY-1N                
A01355        MOVE MH-TRANS-HIST-SEQ-NO TO WS-DB2-KEY-2N                
A01355        MOVE 12                   TO RETURN-CODE                  
A01355        PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
A01355     END-IF.                                                      
A01355*                                                                 15600000
A01355 8970-EXIT.                                                       
A01355     EXIT.                                                        
A01355*                                                                 15630000
A01355******************************************************************15640000
A01355* 8980-INSERT-MN-TRN-HST-DET                                     *15650000
A01355******************************************************************15660000
A01355*                                                                 15670000
A01355 8980-INSERT-MT-TRN-HST-DET.                                      
A01355*                                                                 15690000
A01355     EXEC SQL                                                     
A01355          INSERT INTO CSS_MT_TRN_HST_DET                          
A01355               ( TRANS_HIST_SEQ_NO,                               
A01355                 TRAN_APPL_NO,                                    
A01355                 COLUMN_DESC,                                     
A01355                 TABLE_ID,                                        
A01355                 PRV_COLUMN_VALUE,                                
A01355                 CHG_COLUMN_VALUE)                                
A01355          VALUES                                                  
A01355               ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),               
A01355                 :MI-TRAN-APPL-NO,                                
A01355                 :MI-COLUMN-DESC,                                 
A01355                 :MI-TABLE-ID,                                    
A01355                 :MI-PRV-COLUMN-VALUE,                            
A01355                 :MI-CHG-COLUMN-VALUE)                            
A01355     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15700000
MFA-TR*         INSERT INTO CSS_MT_TRN_HST_DET                          15710000
MFA-TR*              ( TRANS_HIST_SEQ_NO,                               15720000
MFA-TR*                TRAN_APPL_NO,                                    15730000
MFA-TR*                COLUMN_DESC,                                     15740000
MFA-TR*                TABLE_ID,                                        15750000
MFA-TR*                PRV_COLUMN_VALUE,                                15760000
MFA-TR*                CHG_COLUMN_VALUE)                                15770000
MFA-TR*         VALUES                                                  15780000
MFA-TR*              ( :MI-TRANS-HIST-SEQ-NO,                           15790000
MFA-TR*                :MI-TRAN-APPL-NO,                                15800000
MFA-TR*                :MI-COLUMN-DESC,                                 15810000
MFA-TR*                :MI-TABLE-ID,                                    15820000
MFA-TR*                :MI-PRV-COLUMN-VALUE,                            15830000
MFA-TR*                :MI-CHG-COLUMN-VALUE)                            15840000
MFA-TR*    END-EXEC.                                                    15850000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01355*                                                                 15860000
A01355     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
A01355                                                                  
A01355     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01355        NEXT SENTENCE                                             
A01355     ELSE                                                         
A01355        MOVE 'MI'                 TO WS-DB2-TABLE-ID              
A01355        MOVE 'INSERT'             TO WS-DB2-FUNCTION              
A01355        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
A01355        MOVE '113'                TO WS-DB2-MODULE-ID             
A01355        MOVE '8980'               TO WS-DB2-PARAGRAPH             
A01355        MOVE MH-ACCOUNT-NO        TO WS-DB2-KEY-1N                
A01355        MOVE MI-TRANS-HIST-SEQ-NO TO WS-DB2-KEY-2N                
A01355        MOVE MI-TRAN-APPL-NO      TO WS-DB2-KEY-3N                
A01355        MOVE MI-COLUMN-DESC       TO WS-DB2-KEY-4N                
A01355        MOVE 12                   TO RETURN-CODE                  
A01355        PERFORM 9900-SQL-ERROR    THRU 9900-EXIT                  
A01355     END-IF.                                                      
A01355                                                                  
A01355 8980-EXIT.                                                       
A01355     EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *    9700-PROCESS-ABEND                                         *         
      *         CALLED FROM CPD00312                                  *         
      *****************************************************************         
T12094 9700-PROCESS-ABEND.                                              
T12094     MOVE TABLE-1           TO  WS-DB2-TABLE-ID                   
T12094     MOVE ABEND-FUNCTION    TO  WS-DB2-FUNCTION                   
T12094     MOVE SQLCODE           TO  WS-DB2-RETURN-CODE                
T12094     MOVE '113'             TO  WS-DB2-MODULE-ID                  
T12094     MOVE '5500'            TO  WS-DB2-PARAGRAPH                  
T12094     MOVE HOSTVAR-ELEMENT-1 TO  WS-DB2-KEY-1N                     
T12094     MOVE 12                TO  RETURN-CODE                       
T12094     PERFORM 9900-SQL-ERROR THRU 9900-EXIT.                       
T12094 9700-EXIT.                                                       
      /*****************************************************************        
      *                                                                *        
      *     CONTROLS ABNORMAL PROGRAM TERMINATION                      *        
      *                                                                *        
      ******************************************************************        
       9900-SQL-ERROR.                                                  
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
           END-IF.                                                      
                                                                        
           MOVE WS-DATABASE-EXCEPTION                                   
             TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)           
                                                                        
           COMPUTE WS-START-POS                                         
             = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1                 
           MOVE WS-SQL-ERROR-TXT-WQ                                     
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)   
           ADD WS-SQL-ERROR-TXT-LEN-WQ                                  
             TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                   
                                                                        
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       9900-EXIT.                                                       
           EXIT.                                                        
      **                                                                        
       9910-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
                                                                        
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
                                                                        
              MOVE WS-BILL-NO-BG (WS-BILLING-INDX) TO WS-BILL-NO-WQ     
              MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)               
                TO  WS-CODE-UTIL-TYPE-WQ                                
              MOVE WS-IC-NO-BG (WS-BILLING-INDX)  TO  WS-IC-NO-WQ       
              MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)                 
                TO  WS-RATE-PLAN-NO-WQ                                  
                                                                        
              COMPUTE WS-START-POS                                      
                = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1              
              MOVE WS-SUPPLEMENTAL-TXT-WQ                               
                TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)
              ADD WS-SUPPLEMENTAL-TXT-LEN-WQ                            
                TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX)                 
           END-IF.                                                      
                                                                        
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       9910-EXIT.                                                       
           EXIT.                                                        
      **                                                                        
       9999-BAIL-OUT.                                                   
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
