       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA112.                                        
      ****************************************************************  00030000
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL              **  00040000
      **                     PRICE WATERHOUSE                       **  00050000
      **                1410 NORTH WESTSHORE BLVD                   **  00060000
      **                   TAMPA, FLORIDA  33607                    **  00070000
      **                      (813) 287-9200                        **  00080000
      **                                                            **  00090000
      ********            CUSTOMER SERVICE SYSTEM            *********  00100000
      ********                      DB2                      *********  00110000
      ****************************************************************  00120000
      *  EPP - EQUAL PAYMENT PLAN MODULE                            **  00130000
      *  THE PURPOSE OF THIS MODULE IS TO SETUP, MAINTAIN, AND/OR   **  00140000
      *  REMOVE AN ACCOUNT FROM THE EQUAL PAYMENT PLAN.             **  00150000
      *  THERE ARE FOUR MAIN PARTS:                                 **  00160000
      *       1. MONTHLY MONITORING OF THE EPP.                     **  00170000
      *       2. ANNUAL RECALCULATION OF THE EPP.                   **  00180000
      *       3. THE EPP OFFER TO THE CUSTOMER.                     **  00190000
      *       4. RECALCULATION OF THE EPP UPON A RATE TARIFF CHANGE.**  00200000
      *                                                             **  00210000
      ****************************************************************  00220000
      *                                                             **  00230000
      *              PROGRAM  MODIFICATION  LOG                     **  00240000
      *                                                             **  00250000
      *    DATE     INITIALS  REASON                                **  00260000
      *    ----     --------  ------                                **  00270000
      *  02/27/96     LMB     TPR 3355 - CODES-DATA-PRESENT NOT     **  00280000
      *                       MOVED BACK TO CWS10000 VALUE          **  00290000
      *  03/06/96     LMB     TPR 3442 - UPDATE VALUES IN DATE-PYMT-**  00300000
      *                       START AND ANNIVERSARY DATE AFTER      **  00310000
      *                       ANNUAL CALCULATION.                   **  00320000
      *  03/07/96     LMB     TPR 3441 - INSERT ROW FOR TABLE       **  00330000
      *                       CSS_BUDGET_HIST FOR EPP ANNIVERSARY   **  00340000
      *  03/12/96     LMB     TPR 3505 - RATE TARIFF CHANGE NOT     **  00350000
      *                       PROCESSING EPP RECALCULATION.         **  00360000
      *  08/14/96     WTF     UPDATED DEFINITIONS OF WORKSHEET AND  **  00370000
      *                       HOLD AREAS TO MATCH SCSCA107;         **  00380000
      *                       ADDED WS-REFUND TO CALL ARGS          **  00390000
      *  08/26/96     SG      TPR 4592 - CHANGED CHECK FOR NON-UTIL **  00400000
PCR212*  10/07/96     CSG     PCR 212. FOR COMBINATION ELEC/GAS EPP **  00410000
      *                       ACCTS CALCULATE ALLOCATION PERCENTAGE **  00420000
      *                       USING 12 MONTHS OF BILL DATA BASED ON **  00430000
      *                       UTILITY REVENUE.                      **  00440000
TP6163*  11/19/96     ADA     CHANGED CODE TO CORRECTLY TEST IF THE **  00450000
TP6163*                       ACCT IS NONUTILITY FOR EPP OFFER.     **  00460000
T7883 *  12/03/96     CSG     ONLY CREATE WORK QUEUE TO REVIEW EPP  **  00470000
      *                       AMOUNT ON THE 1ST MONTH A NEW SERVICE **  00480000
      *                       WAS ADDED (NOT ALL SUBSEQUENT MONTHS).**  00490000
PCR470*  03/10/97     CSG     ON ANNUAL RECALCULATION, IF THERE IS  **  00500000
      *                       UNUSED CREDIT, CREATE A CIA AR ROW SO **  00510000
      *                       THE AMOUNT CAN BE USED FOR ALL        **  00520000
      *                       RECEIVABLES ON THE ACCOUNT.           **  00530000
T8752 *  03/24/97     CSG     ON ANNUAL RECALCULATION, CORRECT THE  **  00540000
      *                       VALUES IN CSS_BUDGET_HIST:  BALANCE   **  00550000
      *                       FORWARD, EPP ESTIMATE, AMT MO PYMT    **  00560000
      *                       AND # PYMTS REMAINING.                **  00570000
T9895 *  03/27/97     CSG     ON THE FIRST MONTH AFTER SETUP, RESET **  00580000
      *                       THE BALANCE FORWARD IF A PAYMENT HAS  **  00590000
      *                       BEEN MADE.                            **  00600000
      *  04/02/97     CSG     TPRS 10045 AND 9678.                  **  00610000
T10045*                       SET FIELDS BEFORE CALLING SCSCA107 SO **  00620000
      *                       IT USES THE CURRENT RATES AND FACTORS **  00630000
      *                       AND DOESN'T APPLY WNA.                **  00640000
T9678 *                       ON EPP OFFER, UPDATE THE BUDGET HIST  **  00650000
      *                       CHANGE REASON WITH AN 'O' (EPP-OFFER) **  00660000
      *                       AND ADD THE REMARKS TO THE DB.        **  00670000
      *  04/08/97     CSG     TPRS 10157 AND 10082.                 **  00680000
T10157*                       BALANCE FORWARD SHOULD BE UTILITY     **  00690000
      *                       BALANCE MINUS THE EPP AMT FROM PREV.  **  00700000
      *                       YEAR (NOT NEW EPP AMT).               **  00710000
T10082*                       ADD JOURNALING FOR CREATING A CIA ON  **  00720000
      *                       EPP ANNIVERSARY WITH A CREDIT BALANCE.**  00730000
T8752 *  04/17/97     CSG     UPDATE THE EPP OFFER AMOUNT WITH ALL  **  00740000
      *                       RECEIVABLES BALANCE, NOT JUST EPP.    **  00750000
T10583*  04/25/97     CSG     CORRECT THE TOTAL FIELDS FOR ANNIV.   **  00760000
T10760*  05/02/97     CSG     MOVE 0 TO 0-DAY BUCKET IF THERE IS    **  00770000
      *                       A CREDIT BALANCE AT ANNIV TIME.       **  00780000
T10869*  05/05/97     CSG     SET AMT MO PYMT FIELDS CORRECTLY FOR  **  00790000
      *                       A CREDIT BALANCE ACCT.                **  00800000
      *  05/12/97     CSG     TPRS 11078 AND 10954.                 **  00810000
T10954*                       DON'T CHECK LAST BILL DATE BEFORE     **  00820000
      *                       CREATING THE WORK QUEUE FOR RATE CHG. **  00830000
T11078*                       MOVE LOGIC TO COMPUTE EPP-OFFER-AMT TO**  00840000
      *                       SCSCA108.                             **  00850000
T11374*  06/04/97     CSG     POPULATE THE USAGE IN THE CWS10000    **  00860000
      *                       6100 RECORD FOR THE CURRENT MONTH.    **  00870000
      *  06/04/97     CSG     TPRS 11560 AND 11561.                 **  00880000
T11560*                       CORRECT BALANCE FORWARD AMOUNT.       **  00890000
T11561*                       WRITE 'NEW SERVICE' WORK QUEUE IF THE **  00900000
      *                       IC EXISTS BUT WAS TURNED ON SINCE THE **  00910000
      *                       LAST BILL.                            **  00920000
T13330*  10/20/97     CSG     CALC AMT MO PYMT FIELD FOR AN ACCT W/ **  00930000
      *                       TRAN-BAL < AMT-MO-PYMT (PREV YR) BASED**  00940000
      *                       ON USAGE ONLY (DO NOT INCLUDE BAL FWD)**  00950000
      *                       ALSO MAKE THE 0-DAY = TRAN-BAL.       **  00960000
T13536*  11/13/97     CSG     INCREASE THE SIZE OF WK03 HOLD AREA.  **  00970000
T13804*  12/17/97     CSG     REMOVE WQ FOR METER INSTALLED SINCE   **  00980000
      *                       LAST BILL.                            **  00990000
PERF  **  01/05/98    PD      REDUCE WORKING STORAGE FOR ONLINE     **  01000000
PERF  **                      BY SPLITING WORKING STORAGE FOR       **  01010000
PERF  **                      ONLINE AND BATCH PROGRAMS USING       **  01020000
PERF  **                      CWS10000 AND CWS10001.                **  01030000
T13996*  01/26/98     GAC     EPP WORK QUEUES GENERATED SHOULD BE   **  01040000
T13996*                       CATEGORY 6 (EPP) INSTEAD OF 17 (BILL  **  01050000
T13996*                       EXCEPTIONS).                          **  01060000
T14555**  01/28/98    RAH     INCREASE CX OCCURANCES TO 200         **  01070000
T14583**  01/30/98    CSG     WHEN CREATING A CIA FROM A NEG. BAL.  **  01080000
      *                       JRNL THE AMT OF THE NEG. BAL NOT THE  **  01090000
      *                       ENTIRE TRAN BAL OF THE CIA (IF CIA    **  01100000
      *                       ALREADY EXISTS).                      **  01110000
T11587*   02/02/98    SV      TO REMOVE BILL NO, UTILITY TYPE, IC NO**  01120000
      *                       ETC FROM MESSAGE.                     **  01130000
T14869*   03/10/98    GAC     2.5% BUFFER SHOULD NOT BE ADDED TO    **  01140000
      *                       FIXED-COST LIGHTING (UNMETERED).      **  01150000
T14959*   03/17/98    GAC     EPP USAGE PASSED TO BILL PRINT FOR EPP**  01160000
      *                       ADJUSTMENT STATEMENT SHOULD BE IN     **  01170000
      *                       THERMS, NOT CCF'S.  (*BTU)            **  01180000
PCR629**  04/24/98     AMG    CHANGED THE CATEGORIES OF SOME        **  01190000
PCR629**                      WORK QUEUES                           **  01200000
T15927**  04/27/98     CSG    UPDATE BAL FWD ON MONTH AFTER ANNIV.  **  01210000
T16339**  05/12/98     GAC    INITIALIZE FLAGS WS-START-UP-EXISTS   **  01220000
      **                      AND WS-ROW-EXISTS TO N.               **  01230000
T16415**  05/14/98     GAC    ROUND CALC OF EPP-USAGE FOR BILL PRINT**  01240000
      **                      INSTEAD OF TRUNCATING.                **  01250000
T16496**  05/26/98     CSG    TREAT CODE UTIL TYPE 'E' W/ A CUST    **  01260000
      **                      PLAN THE SAME AS UNMETERED IN ANNIV   **  01270000
      **                      PROCESSING (EX. RATE 68A).            **  01280000
T17201**  08/7/98      KLP    DON'T NEED COMPLETE 12 MO HISTORY FOR **  01290000
      **                      UNMETERED SERV IF COMPLETE FOR OTHERS **  01300000
T17335**  08/14/98     KLP    DATE_PYMT_STRT IN CSS_BUDGET_HIST     **  01310000
      **                      IS NOW POPULATED WITH THE NEXT        **  01320000
      **                      REVENUE MONTH W/DD='01'               **  01330000
T17423**  08/17/98     KLP    OFFER-DATE-EPP-AT NOW BASED ON REV    **  01340000
      **                      MONTH RATHER THAN CALENDAR DATE       **  01350000
T17437**  08/21/98     KLP    SET TEMP-BILL-CODE TO 'T' WHEN EPP    **  01360000
      **                      ANNIV RECALC FAILS B/C INCOMPLETE NEW **  01370000
      **                      SERVICE HISTORY - WRITTEN TO BE00 FILE**  01380000
      **                      AT-TABLE UPDATED IN 113 WITH 'A'      **  01390000
      **                      THIS JUST KEEPS THE BILL FROM GETTING **  01400000
      **                      MAILED TO THE CUSTOMER - CORRECTION TO**  01410000
T17529**  08/27/98     KLP    CORRECTION TO 1PR13996 - CHANGED EPP  **  01420000
      **                      MONITOR WQS TO HAVE OWN CATEGORY OF   **  01430000
      **                      +152 - EPP MAINTANENCE                **  01440000
T17241**  08/27/98     KLP    IN DETERMINING WQS FOR EPP BALANCE    **  01450000
      **                      0,30,60 DAY BILLED BALANCE SUBTRACTED **  01460000
      **                      FROM AMNT TRAN BALANCE - THE CHECK IS **  01470000
      **                      NOT DONE WHEN TODAY IS WITHIN 2 MOS   **  01480000
      **                      OF THE ANNIV DATE                     **  01490000
T17777**  09/23/98     JYL    ADDED LOGIC TO APPLY CIA MONEY TO     **  01500000
      **                      EPP TRAN BALANCE BEFORE ANNIVERSARY   **  01510000
      **                      CALCULATIONS.                         **  01520000
T18078**  10/12/98     JYL    MODIFIED 2030- TO UPDATE THE CIA      **  01530000
      **                      AR ROW WHEN APPLYING CIA TO EPP       **  01540000
      **                      TRAN-BAL.                                 01550000
T18237**  10/19/98     JYL    MODIFIED 2030-.  ADDED END-IF         **  01560000
      **                      STATEMENT.                            **  01570000
T18242**  10/20/98     JYL    MODIFIED 2030-. IF THE ACCOUNT HAS    **  01580000
      **                      ARREARS IN EPP AND HAS CREDIT EPP TRAN**  01590000
      **                      BALANCE, ZERO OUT THE ARREARS AND     **  01600000
      **                      SUBTRACT FROM BILLED BALANCE.             01610000
T18579**  12/08/98     JYL    MODIFIED 2020-. COMMENTED OUT THE     **  01620000
      **                      LOGIC THAT BILLS THE TRAN-BAL WHEN IT **  01630000
      **                      IS LESS THAN THE EPP MONTHLY AMT.     **  01640000
      **                      THIS LOGIC HAS BEEN MOVED TO SCSCA108.**  01650000
      **                      ALSO CHANGED AR-AGE CODE WHEN CREDIT  **  01660000
      **                      IS APPLIED AGAINST EPP-TRAN-BAL.      **  01670000
T17859**  01/06/99     JYL    MODIFIED PROGRAM TO ALLOW FOR ANNIV   **  01680000
      **                      CALCULATION FOR ACCTS HAD NEW SERVICES**  01690000
      **                      ADDED WITH <12, BUT >9 MTHS OF HISTORY**  01700000
T17883**  01/14/99     JYL    MODIFIED PROGRAM TO ALLOW FOR RECALC  **  01710000
      **                      OF THE EPP AMOUNT FOR ACCOUNTS THAT GO**  01720000
      **                      THROUGH CANCEL/REBILL DURING THE      **  01730000
      **                      ANNIVERSARY MONTH.                    **  01740000
T19141**  02/16/99     KDF    CHANGED WS-EPP-BALANCE-WARNING TO     **  01750000
T19141**                      4 TIMES EPP AMOUT FROM 3 TIMES        **  01760000
T19142**  02/17/99     KDF    PRODUCE ONLY ONE  IC-ADDED WARNING WQ **  01770000
T19278**  03/02/99     KDF    CHANGE BH-EPP-MTHS-RMNG-QT FROM 1 TO  **  01780000
T19278**                      12 AT ANIVERSARY.                     **  01790000
T20014**  05/19/99     KDF    CHANGE OCCURS TO 5 ON IC TABLES       **  01800000
T19143**                                                            **  01810000
T19143**  06/01/99     SWR    CHANGE CODE TO PUT OUT WQ (TRAN BAL 4 **  01820000
T19143**                      TIMES > OR 4 TIMES < THE EPP AMOUNT,  **  01830000
T19143**                      ONLY WHEN EPP MONTHS REMAINING = 3 OR **  01840000
T19143**                      6 OR 9 (IN OTHER WORDS, QUARTERLY).   **  01850000
T20395**  07/15/99     KDF    DO NOT SET "INCOMPLETE SET" FLAG FOR  **  01860000
T20395**                      UNMETERED LIGHTS                      **  01870000
T20503**  08/13/99     KDF    GENERATE A WQ IF EPP HISTORY HAS 0.00 **  01880000
T20178**  09/24/99     KDF    DO NOT RECALC EPP ANIV ON C/R         **  01890000
T19679**  09/28/99     KDF    CHANGED EPP TO GENERATE ANNIV STATEMENT*  01900000
T19679**                      WHEN LESS THAN FULL 12 MONTHS **          01910000
T20781**  09/28/99     KDF    GENERATE 6100- RECORD FOR BP ON C/R   **  01920000
T20781**                      AT ANNIVERSARY                        **  01930000
T21087**  11/11/99     KDF    GET ACCURATE LAST 11 MONTHS BILLED    **  01940000
T21551**  02/02/00     KDF    STOP LOOPING ON BAD EPP ANIVERSARY    **  01950000
T21551**                      DATE IN PARA 1200-                    **  01960000
T22202**  08/17/00     DCS    USE SAME (CURRENT) REVENUE MONTH FOR  **  01970000
T22202**                      CALC OF ALL PRIOR MONTHS EST FOR EPP. **  01980000
T22741**  08/30/00     DCS    FIRST MONTH OF EPP ANNIVERSARY        **  01990000
T22741**                      SCHEDULE WAS NOT INCLUDING ALL BILLED **  02000000
T22741**                      AMOUNTS. THE FIX WAS :                **  02010000
T22741**                      FOR THE CURRENT  REVENUE MONTH USE    **  02020000
T22741**                      'A' FOR WS-BC-CODE-BILL-STATUS-BI.    **  02030000
T22741**                      FOR ALL PRIOR MONTHS ON SCHEDULE USE  **  02040000
T22741**                      'I' FOR WS-BC-CODE-BILL-STATUS-BI.    **  02050000
T22742**  08/31/00     DCS    LAST MONTH OF EPP ANNIVERSARY         **  02060000
T22742**                      SCHEDULE WAS NOT PRORATED.            **  02070000
T22742**                      THE FIX WAS :                         **  02080000
T22742**                      FOR THE BI_BG_EPP CURSOR ADD BG-      **  02090000
T22742**                      PRORATE-CD AND THEN PASS THIS TO      **  02100000
T22742**                      SCSCA107 FOR EVERY MONTH. THEN ANY    **  02110000
T22742**                      MONTHS THAT SHOULD BE PRORATED WILL BE.*  02120000
T22788**  09/11/00     DCS    IF SCEG:                              **  02130000
T22788**                      USE ACTUAL REVENUE MONTH FOR CALC OF  **  02140000
T22788**                      ALL PRIOR MONTHS EST FOR EPP.         **  02150000
T22788**                      IF SEB:                               **  02160000
T22788**                      USE SAME (CURRENT) REVENUE MONTH FOR  **  02170000
T22788**                      CALC OF ALL PRIOR MONTHS EST FOR EPP. **  02180000
T22520**  10/12/00     DCS    HANDLE -181 ABEND WHEN MISSING A      **  02190000
T22520**                      MONTH IN THE CONSUMPTION HISTORY DURING*  02200000
T22520**                      RECALC OF ANNIVERSARY EPP SCHEDULE.   **  02210000
T22520**                        WHEN THIS HAPPENS:                  **  02220000
T22520**                        1. CONTINUE PROCESSING              **  02230000
T22520**                        2. CREATE WQ REQUEST                **  02240000
T22520**                        3. MAKE THIS AN EXCEPTION BILL      **  02250000
T22520**                           (DOES NOT GO OUT THE DOOR)       **  02260000
T22862**  10/12/00     DCS    CHANGE CALCULATION OF BALANCE BROUGHT **  02270000
T22862**                      FORWARD TO INCLUDE REDUCTION BY -30,  **  02280000
T22862**                      -60, AND -90 DAY AGING AMOUNTS.       **  02290000
T22594**  10/12/00     DCS    1. IF A CREDIT BALANCE ON THE EPP CNTL**  02300000
T22594**                      RECORD THAN DO NOT ZERO IT OUT, WANT  **  02310000
T22594**                      THIS AMOUNT TO GO TO THE BUDGET_HIST  **  02320000
T22594**                      TABLE TO SHOW THE CREDIT BALANCE IN   **  02330000
T22594**                      THE BALANCE FORWARD FIELD.            **  02340000
T22594**                      UTILITY BALANCE SHOULD REMAIN ZERO.   **  02350000
T22594**                      2. NO UPDATING OF THE BUDGET_HIST     **  02360000
T22594**                      TABLE. COMMENT OUT CODE THAT CONTROLS **  02370000
T22594**                      THAT LOGIC.                           **  02380000
T21442**  10/12/00     DCS    ALLOW ANNIV PROCESSING TO CONTINUE IF **  02390000
T21442**                      A RATE CHANGE SINCE LAST EPP ANNIV.   **  02400000
T21442**                      ALSO MAKE THIS AN EXCEPTION BILL (DOES**  02410000
T21442**                      NOT GO OUT THE DOOR).                 **  02420000
T22796**  10/19/00     RAH    USE SAME (CURRENT) REVENUE MONTH FOR  **  02430000
T22796**                      CALC OF ALL PRIOR MONTHS EST FOR EPP. **  02440000
T23332**  02/01/01     RAH    MAKE EPP CALCULATIONS USE FUTURE DDDC **  02450000
T23332**                      FACTORS.                              **  02460000
T23513**  02/16/01     CBSI   MADE CHGS TO CHECK FOR SEB-DATABASE   **  02470000
T23513**               MADRAS INSTEAD OF LS-SEB  FOR SEB REGION     **  02480000
      *   02/26/01 BERNARD   ADD WS-ACCOUNT-AT TO USING STATEMENT.  **  02490000
      *   TPR23529 MITCHELL                                         **  02500000
      **  03/07/01 BERNARD    CHANGED TO NOT CHANGE WS-CODE-TEMP-PULL** 02510000
      **  TPR23829 MITCHELL   -TEMP-PULL-AT IF IT IS = 'R' AND IS A  ** 02520000
      **                      SEB ACCOUNT.                           ** 02530000
      **  03/07/01 B. MITCHEL CHANGED TO CHECK SEB-DATABASE INSTEAD  ** 02540000
      **  TPR23829            OF COMPANY-NO-AT.                      ** 02550000
C23501**  04/20/01 VIJAY      MULTI COMPANY CHANGES FOR DELINQUENCY **  02560000
      **                      VALUES(PSNC) .                        **  02570000
T24096**  05/17/01 MCCARTNEY  EPP USAGE ERROR TO DO A TEMP PULL.    **  02580000
VVKS  **  08/18/01 VIJAY      WS-HOLD-BC-DATA LENGTH CHANGED FROM       02590000
      **                      7420 TO 9220 DUE TO ADDITION OF WNA       02600000
      **                      FIELDS IN PRICE BLOCK.                    02610000
C23632** 08/27/01    GSR      CHANGES MADE TO INCREASE THE          **  02620000
C23632**                      OCCURRENCES TO HANDLE UPTO 50 METERS. **  02630000
T24685**  08/24/01 SV         ANNIVERSARY STATEMENT NOT PICKING UP  **  02640000
T24685**                      CORRECT LAST YESAR'S USAGE AND COST WHEN  02650000
T24685**                      THE ANNIVERSARY BILL IS CANCEL REBILLED*  02660000
T23339**  09/27/01 ESM        ADDED CODE FOR 1RATE PLAN.            **  02670000
T23301**  10/16/01 VIJAY      WS-HOLD-BC-DATA PICTURE CLAUSE CHANGED**  02680000
      **                      FROM 9220 TO 9300 TO INCLUDE TOTAL WNA**  02690000
      **                      AMOUNT.                               **  02700000
T25213**  10/17/01 ESM        ADDED CODE FOR PREFERRED PLUS PLAN.   **  02701000
T25475**  10/25/01 SK88120    ADDED LOGIC TO INCLUDE PSNC EXCISE TAX**  02701100
T25475**                      IN PROJECTED EPP AMOUNT.              **  02701200
T25763**  12/13/01 COVANSYS   CHANGES ARE MADE TO GENERATE WQ WHEN  **  02701300
T25763**           CHENNAI    CREDIT BALANCE MORE THAN (+ OR -) 4   **  02701400
T25763**                      TIMES OF THE MONTHLY EPP AMOUNT       **  02701500
T23363**  01/31/02 GANESH \   IF RATE PLAN IS UNMETERED BUT CODE    **  02701600
T23363**           VIJAY      UTIL TYPE IS E/G, DO NOT CALL SCSCA107**  02701700
T23363**                      USE AMOUNTS IN BILLING DETAIL         **  02701800
T23363**                      THIS WILL RESOLVE THE CML 24546       **  02701900
T23363**                      PROBLEM ALSO                          **  02702000
C25936**  02/25/02 SRIDEVI    CREATE AN ADJ ROW DURING  ANNIVERSARY **  02702100
C25936**                      WHEN THE ACCOUNT HAS A CREDIT BALANCE **  02702200
C25936**                      AND NO PAYMENT IS MADE IN THE MONTH   **  02702300
C25936**                      BEFORE ANNIVERSARY-MONTH              **  02702400
C26679**  06/10/02 SRIDEVI    WHEN RUNNING DIFFERENT PARTITIONS SIMUL*  02702500
C26679**                      TANEOUSLY JRNLG IS FAILING WITH -803.  *  02702600
C26679**                      CHANGED THE CODE TO WRITE INTO WK03 FILE  02702700
C26679**                      OVERWRITING THE CHANGES OF CML 25936   *  02702800
T26188**  05/29/02 COVANSYS   CORRECTED EPP OFFER AMT FOR USAGE     **  02702900
T26188**           (CHENNAI)  < 12 MONTHS.                          **  02703000
C26130**  06/05/02 MDJ        ADDED/CHANGED LOGIC FOR AUTOMATIC EPP **  02703100
C26130**                      OFFER.                                **  02703200
C27553**  10/02/02 SRIDEVI    IN CASE OF AN ACCOUNT THAT HAS BOTH UTE*  02703300
C27553**                      AND UTG OFFER WILL BE GIVEN ONLY IF BOTH  02703400
C27553**                      UTE AND UTG HAS 12 MONTHS OF USAGE     *  02703500
C28085**  01/09/03 SRIDEVI    MOVED THE LOGIC CODED FOR C27553 TO THE*  02703604
C28085**                      MOST APPROPRIATE PLACE                 *  02703704
CIG   **  01/10/03 PER GANESH INCREASED SIZE OF WS-HOLD-BX-DATA FROM *  02703705
CIG   **                      2440 TO 2880                           *  02703706
C26164**  10/17/02 SS82048    CHANGE EPP CALCULATION METHODOLOGY     *  02703800
C26164**  01/16/03 SS82048    BUFFER TO SHOW AS 0.069 INSTEAD OF 6.90*  02703800
C28085**  01/20/03 SRIDEVI    DO NOT WRITE WQ WS-EPP-MONTH-NOT-FOUND *          
C28085**                      FOR LESS THAN 12 MONTHS OF USAGE IN CASE          
C28085**                      OF AN OFFER                            *          
C26164**  01/22/03 SS82048    REMARKS TO SHOW BUFFER USED WHEN       *  02703800
      **                      EPP OFFER ROW IS WRITTEN TO BUDGET HIST*  02703800
T27925**  03/19/03 COVANSYS   CHANGED FILEDS DEFINED AS 9(07)        *          
      **                      TO 9(11).                              *          
T28606**  03/24/03 SV82012    CHANGE THE WAY EPP WQ'S GENERATE.      *  02703800
CIG   **  01/10/03 PER GANESH INCREASED SIZE OF WS-HOLD-BX-DATA FROM *  02703705
CIG   **                      2880 TO 10000                          *  02703706
T28606**  05/16/03 KB40308    ADDED 'M' TO THE EPP_CHG_CHK CURSOR    *  02703800
T29146**  06/06/03 SV82012    GENERATE EPP WQ ON THE 4TH, 6TH AND 8TH*          
T29146**                      MONTHS.                                *          
T23452**  06/07/03 COVANSYS   STOP 2500 RECORD TO BILL PRINT ON C/R  *          
T23452**                      EPP SETUP NEXT BILL.                   *          
T27705**  07/29/03 COVANSYS   CORRECT EPP LIGHTING CACULATION ON     *          
T27705**                      CREDIT ADJUSTMENTS FOR UMMETERED SERVICE          
C30317**  02/10/04 SRIDEVI    DO NOT SEND A WQ IN CASE OF CALC ERROR *          
C30317**                      FOR EPP OFFER                          *          
T29768**  08/16/04 VIJAY ACT1-CANCEL/REBILL NON-CALCS SHOULD NOT BE  *          
T29768**                      USED IN EPP CALCULATIONS.REMOVED CML   *          
T29768**                      27705 CHANGES.                         *          
T29768**                 ACT2-WQ 'EPP HISTORY USAGE CONTAINS $0.00'  *          
T29768**                      BE PUT IN PULL GROUP CODE 'Z'.         *          
T29768**                                                             *          
T29768**                 ACT3-WQ 'EPP HISTORY USAGE CONTAINS $0.00'  *          
T29768**                      BE PUT IN HIGH PRIORITY.               *          
T31866**  11/17/04   KSB  TO USE A BUFFER OF 29% FOR SEB FIXED       *          
T31866**                  RATE CUSTOMERS ON EPP                      *          
T32593**  04/07/05 VIJAY  PUT ACCOUNTS INTO # GROUP FOR CATEGORY ID  *          
      **                  6,53 AND 152 WHICH ARE CURRENTLY PUT INTO  *          
      **                  'X' GROUP.                                 **         
T32676**  10/04/05 GANESH DO NOT GENERATE WQ "RATE PLAN CHANGE SINCE **         
T32676**                  LAST BILL" FOR RATE 032 CUSTOMERS AS PART  **         
T32676**                  OF GAS RATE INCREASE PROJECT.              **         
T32676**                  CODE CHANGED TO PASS ORIGINAL REVENUE      **         
T32676**                  MONTH TO SCSCA107 FOR EPP ANNIVERSARY      **         
T32040**  10/25/05 DAS    ADD INTELLIGENCE TO WQ CAT ID 152.         **         
T32040**                  CALL SCSCA107 MULTIPLE TIMES TO ESTIMATE   **         
T32040**                  THE EPP AMT BASED ON THE HISTORICAL CONSUM **         
T32040**                  PTION BUT WITH CURRENT RATES. THIS CALCULAT**         
T32040**                  ED AMT IS COMPARED AGAINST CURRENT EPP     **         
T32040**                  TIMES A FACTOR BEFORE GENERATING WQ        **         
T33004**  01/09/06 JAYANTHI  ADDED CODE TO PULL BILL AND CREATE WQ   **         
T33004**                     IF EPP AMT FOR CURRENT BILL IS ZERO     **         
C32891**  03/28/06 ROD    CHANGE WS-HOLD-BA-DATA TO 11800 BYTES TO   **         
C32891**                  HOLD ENTIRE BILL ADJUSTMENT AREA.          **         
T34243**  05/15/06 DAS    HANDLE SQL -180 IN THE SAME WAY AS SQL-181 **         
T34243**                  ANNIV. ACCOUNTS ARE NOT GOING THRO BILLING **         
T34243**                  FOR SEASONAL BLOKED ACCOUNTS               **         
T34391**  06/10/06 DAS    INCORRECT NEW EPP AMTS IN 4/6/8 MTH MONITOR**         
T34391**                  FIX - LOOK FOR CONSECUTIVE REV. MTHS IN    **         
T34391**                  BILL DETAIL TO DETERMINE SEASONAL ACCTS    **         
T34391**                  AND GENERATE A WQ                          **         
T34356**  06/10/06 DAS    UPDATE THE WQ INTELLIGENCE CML 32040 WITH  **         
T34356**                  SPECIFIC ENHANCEMENTS,AS THE VOLUME OF WQS **         
T34356**                  GENERATED IS TOO MANY.GENERATE WQ ONLY     **         
T34356**                  IF MEETING THE NEW CRITERIA                **         
T34474**  07/11/06 DAS    FOR COBB AND SS ACCOUNTS DO NOT GENERATE   **         
T34474**                  THE EPP 4,6,8 MTH WQ UNTIL ANNIVERSARY     **         
C33924**  09/13/06 ROD    ADD WS-BC-BILL-ADJUSTMNT TO CA107 CALL     **         
T34990**  11/17/06 DAS    ONE RATE EPP ANNIVERSARY CHANGE - SEB ACCOUNT         
T34990**                  ESTIMATES THE EPP AMTS MUCH HIGHER BECAUSE THE        
T34990**                  RATES USED WERE NOT FUTURE, CODE CHANGES DONE         
T34990**                  TO GET CORRECT EPP ESTIMATE USING FUTURE RATES        
T34990**                  WHEN OFFER IS GIVEN AT ANNIVERSARY                    
T34990**                  ALSO APPLIED PERFORMANCE TUNING CHANGES               
C34216**  05/01/06 WILLIE CHANGE PARAGRAPH 2020 TO CHECK TO SEE IF   **         
C34216**                  THE CUSTOMER ACCOUNT BALANCE IS LESS THAN  **         
C34216**                  EPP PAYMENT WITH ARREARS.  IF SO BILL THE  **         
C34216**                  CUSTOMER THE ACCOUNT BALANCE AND NOT THE   **         
C34216**                  EPP PAYMENT.                               **         
C34459** 02/08/07 DM94438 WITH THE HUGE VOLUMES WQS GETING GENERATED **         
C34459**                  AN USER INTERFACE PROVIDED TO CONTROL THE  **         
C34459**                  VOLUMES. MADE CHANGES TO READ DELINQUENCY  **         
C34459**                  TABLES TO GET THE FACTORS BEFORE GENRATING **         
C34459**                  EPP MAINTENANCE WQS                        **         
C33708**  03/29/07 WILLIE   ADDED GAS LIGHTING TO EPP TOTAL PROJECTED**         
C33708**                    COST                                     **         
C34569**  06/14/07 DM94438  SEB REENGINEERING CHANGES  STARTED IN 07 **         
C34569**           WILLIE   AND COMPLETED IN FEB'08                             
C34569**                                                                        
C36331**  07/18/08 DM94438  CORRECT CRITERIA FOR DETERMINING DR OR CR           
C36331**                    FORMULA FOR 4 MTHS REMAINING EPP WQS                
C36956**  10/07/08 RC41079  BUDGET BILLING CHANGES - CHANGED ALL     **         
C36956**                    ERRORS CONTAINING EPP TO BBP. REMOVED    **         
C36956**                    "AND WS-USE-DUMMY-RATE='Y'" FROM 5711-.  **         
I00177**  01/05/09 SS97726  CHANGE WS-CUST-PLAN-INDX FROM 100 TO 1000**         
I00177**                    & WS-UNMTRD-CNSMPTN-INDX FROM 100 TO 200 **         
I00177**                    & REMOVE IDX HARD CODING.                **         
I00177**  03/05/09 SS97726  PASS WS-BC-CODE-MTR-READ-FREQ-BG VALUE TO**         
I00177**                    BILL CALC IN CWS0022B COPYBOOK           **         
P00097**  02/02/09 SS97726  CHANGE WS-AR-DATA FROM 50 TO 150 & REMOVE**         
P00097**                    ANY INDX HARD CODING.                    **         
A01021**  04/01/09 RC41079  REMOVED CODE THAT GENERATES WQ "RATE PLAN**         
A01021**                    CHANGE SINCE LAST BILL" AND "RATE PLAN   **         
A01021**                    CHANGE SINCE LAST CYCLE".                **         
A00981**  05/01/09 DM94438  CHANGE THE LOGIC TO FLAG USAGE ERROR EVEN**         
A00981**                    IF BILL # IS ZERO, THAT WAY A "Z" PULL   **         
A00981**                    CODE WILL BE SEND FOR SUCH ACCTS TO BILPRNT         
A31046**                    AND ALSO REMOVE DCL FOR CSS_ACCOUNT_XSELL           
A31046**                    ALONG WITH CHANGES RELATED TO THIS TABLE            
A00312**  06/05/09 VV94890 FIX TO SET CIA CDP POSITION 6 LOGIC FOR   **         
A00312**                   CANCEL\REBILLS.                           **         
P00120**  09/16/09 SS97726  INCREASE BA HOLD AREA LENGTH.            **         
P00165**  09/23/09 SS97726  INCREASE BA HOLD AREA LENGTH.            **         
A01315**  09/24/09 DB41297 DELETE WORK QUEUE PER CLIENT REQUEST.     **         
A01315**                   NEW IC INSTALLED SINCE EPP CHG            **         
A01315**                   ALSO CHANGE EPP-AMT TO DISPLAY NEGATIVES. **         
A01315**                   HAD TO INCREASE BY 1 BYTE SINCE THE '-'   **         
A01315**                   SYMBOL TAKES UP ONE SPACE.                **         
P00211**  10/20/09 WR19680  CHANGED CALLED TO SCSCA328 TO CHECK FOR  **         
P00211**                    FOR PENDING OPTION FLAG.  IF PENDING     **         
P00211**                    OPTION EXIST, USE PENDING THERM PRICE    **         
P00251**  04/12/10 SS97726  CHANGES FOR NET METERING PROJECT.        **         
P00257**  04/23/10 RH15956  REVENUE REPORTING CHANGES.               **         
P00307**  04/28/10 WR19680  AUTOMATE MONTHLY MONITORING OF BUDGET    **         
P00307**                    BILLING PAYMENTS AND UPDATE THEM         **         
P00307**                    AUTOMATICALLY BASED ON DELIQUENCY VALUE. **         
P00396**  08/02/10 WR19680  CHANGE TO BBP CALCULATION TO USE         **         
P00396**                    WS-BBP-ANNIV-PRICE INSTEAD OF            **         
P00396**                    WS-RET-THERM-PRICE(1)WHEN RETURNED FROM  **         
P00396**                    SCSCA328.                                           
A02094**  09/20/10  DM94438  IF AN ICP IS DROPPED AND THE OTHER ICPS ARE        
A02094**                     NOT CONTIGUOUS, WE HAVE ISSUES IN BBP CALC         
A02094**                     ULATION. SO CHANGING THE PERFORM VARYING           
A02094**                     LOGIC  WHERE ICD-INDX IS CHECKED FOR               
A02094**                     NOT SPACES.                                        
A02036**  10/08/10  DM94438  1.TO HANDLE UNMETER ELECTRIC ICPS IN SEASON        
A02036**                     AL CHECK PARA SO AS TO STOP THESE FROM             
A02036**                     BEING TREATED AS SEAONAL ACCOUNT EVENTHOUGH        
A02036**                     THEY ARE NOT. (ACTIVITY 106 IN APPL2036)           
A02036**                     2.HANDLE -180 ERROR IN  7100-OPEN-CNSMP            
A02036**                     PARA BY INCLUDING CHECK IF TIMESTAMP>SPACES        
A02036**                     (ACTIVITY 107 IN APPL2036)                         
A02036**                     3. FIX RESP AREA TO SHOW BILLING (NOT BAT)         
A02036**                     (ACTIVITY 117 IN APPL2036)                         
A02036**                     4. CHECK UPDATE FLAG BEFORE PERFORMING             
A02036**                     DATABASE UPDATES  (ACTIVITY113 IN APPL2036)        
A02036**                     5. REMOVE UNUSED PARA THATS NEVER EXECUTED AND     
A02036**                     COMMENTED LINES.                                   
I01119**  01/10/11 VY95550  PASS PROGRAM-NAME TO SCSCA328            **         
A03106**  02/02/11 DM94438   STOP "NO CONSUMPTION FOUND FOR IC BILL" WQ         
A03106**                     WHEN BBP ANNIV OR MONTHLY MONITOR                  
ACT134**  06/15/11 DB41297   STOP "NO CONSUMPTION FOUND FOR IC BILL" WQ         
ACT134**  A03082             WHEN NOT BBP ANNIV OR MONTHLY MONITOR              
P00496**  04/05/11 SS97726   INDUSTRIAL BILLING ENHANCEMENTS.        **         
VKSACT*  09/08/11  VIJAY   History rows creation for event process.   *         
      *  P00496            This includes Curtailment, Maintenance     *         
      *                    and Standby events.                        *         
A03850*  01/30/12  VIJAY 1.GENERATE WS-EPP-BALANCE-WARNING-E WQ ONLY  *         
      *                    AT 6 MONTHS REVIEW.                        *         
      *                  2.ADD OLD AMOUNT IN WQ DISPLAY               *         
ACT003*  03/08/12  VIJAY 1.ADDED OLD AMOUNT AND REMAINING MONTHS IN   *         
      *  A03850            WS-EPP-BALANCE-WARNING-E WQ display.       *         
P00694*  07/27/12  VIJAY 1.FOR SCEG use BG monies instead of getting  *         
      *                    with latest rate by calling SCSCA107.      *         
      *  10/18/12  VIJAY 2.Use CSC-AMT returned from SCSCA328 for cal-*         
      *                    culation in Anniversery.                   *         
ACT027*  03/13/13  VIJAY 1.Pull into ONLINE BillView for              *         
      *  A04527            PRICE-ROUTINE-ERROR WQ                     *         
      *                  2.Deleted more than 3 changes wq in bbp      *         
      *                    (WS-NO-BUD-CHANGES-CALC > 3 then create wq)*         
ACT045*  04/16/13  VIJAY 1.GENERATE WS-EPP-BALANCE-WARNING-E WQ       *         
      *  A04527            AT 4 MONTHS REVIEW.                        *         
ACT065*  05/31/13  VIJAY   FIX PSNC BBP OFFER ISSUES(IT WAS NOT CALLING         
      *  A04527            SCSCA107 TO CALCULATE MONIES. DELETED      *         
      *                    ANNV FLAG AND MONITOR FLAG CHECK).         *         
ACT084*  06/21/13  VIJAY   CHANGED PICTURE CLAUSE FROM S99V9(3) TO    *         
      *  A04527            S9V9(4) TO FIX DECIMAL ISSUES FOR THE      *         
      *                    FIELDS WS-BD-STATE-TAX-RATE,               *         
      *                           WS-BD-CITY-TAX-RATE                 *         
ACT119*  07/30/13  bd09555 add CSR04617A to paragraph 7890            *         
ACT190*  11/06/13  VIJAY   DELETE CSS_BUDGMENT_PAYMENT TABLE AND IT'S *         
      *  A04527            RELATED CODE WHICH IS NOT REQUIRED ANY MORE*         
      *                                                               *         
ACT241*  12/20/13  VIJAY   Fix no of months for unmeters during anni- *         
ACT241*  A04527            versary when it is added in current month. *         
ACT029*  02/03/14  VIJAY   FIX TO CRETE WQ AT 100% ADJUSTMENT DURING  *         
ACT029*  A04480            MONITORING PROCESS.                        *         
ACT078*  04/03/14  VIJAY   FIX TO BBP OFFER AMOUNT CALCULATION WHEN   *         
ACT078*  A04480            HISTORY IS PRESENT LESS THAN 12 MONTHS.    *         
ACT275*  10/09/14  VIJAY   DO NOT APPLY EXTCREDTX factor              *         
ACT275*  A04880                                                       *         
ACT088*  04/17/15  VIJAY   USE TAX-RATE TO CALCULATE TAXES INSTEAD OF *         
ACT088*  A05136            ALREADY CALCULATED AMOUNTS IN BILLING.     *         
ACT122*  06/11/15  VIJAY   PROCESS MULTIPLE EXIT FEE FACTORS OF A BILL*         
ACT122*  A05136                                                       *         
ACT002*  06/11/15  VIJAY   FIX ABEND IN 7970- PARA.                             
ACT002*  A05460                                                       *         
ACT284*  09/28/16  VIJAY  SET INDEXES TO 1 TO AVOID EXCEPTIONS IN    *          
ACT284*   A05460          MFES ENVIRONMENT.                                     
ACT332*  11/09/16  VIJAY  FIX ERRONEOUS INDEX IN PERFORM LOOPING.    *          
ACT332*   A05460          INITIALIZE WS-BDET-INDX.                              
ACT072*  03/23/17  VIJAY  INCLUDE LOYALTY CREDIT IN BBP CALCULATIONS.*          
ACT072*   A05744                                                                
      ****************************************************************  02703900
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 02704000
      **                                                             ** 02704100
      **  0000         MODULE CONTROL                                ** 02705000
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 02706000
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 02707000
      **                                   /EPP MONTHLY MONITORING   ** 02708000
      **  2000 - 4999  DETAIL LOGIC                                  ** 02709000
      **                           /2000-2999   EPP ANNUAL RECALC    ** 02710000
      **                           /3000-3999   EPP RATE TARIFF      ** 02720000
      **                           /4000-4999   EPP OFFER            ** 02730000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 02740000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 02750000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 02760000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 02770000
      **                                                             ** 02780000
      /**************************************************************** 02790000
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA112'.
MSQ017     COPY MFASQLM.
       01  WS-START                         PIC X(40)                   
           VALUE 'WORKING STORAGE FOR SCSCA112 STARTS HERE'.            
                                                                        
       01  WS-WORK-VARIABLES.                                           
C34569     05  RS-RETURN-CODE       PIC S9(9) VALUE 0 COMP.             
C34569     05  RS-RETURN-CODE-DISP  PIC S9(9) VALUE 0 COMP.             
T17201     05  WS-ICD-INDX-CALC             PIC 9(9) COMP.              
COB305     05 WS-EPP-GAS-REV        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 WS-EPP-ELEC-REV        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 WS-TOTAL-EPP-REV        PIC S9(9)V99 COMP-3 VALUE 0.        
T31866     05  WS-DELINQ-CD-VALUE           PIC X(20) VALUE SPACES.     
T31866     05  WS-CHECK-RATE-PLAN           PIC X(03) VALUE SPACES.     
T31866     05  WS-RATE-CALC-TYP-CD          PIC X(02) VALUE SPACES.     
           05  WS-INSERT-POINT              PIC S9(4) COMP.             
           05  WS-NULL-IND1                 PIC S9(4) COMP.             
C25936     05  WS-NULL-IND-00               PIC S9(4) COMP.             
C25936     05  WS-NULL-IND-30               PIC S9(4) COMP.             
C25936     05  WS-NULL-IND-60               PIC S9(4) COMP.             
C25936     05  WS-NULL-IND-90               PIC S9(4) COMP.             
C25936     05  WS-NULL-IND-UCR              PIC S9(4) COMP.             
           05  WS-START-POS                 PIC S9(4) COMP.             
T23452     05  WS-BH-REV-MNTH               PIC 9(06) VALUE ZEROS.      
T34391     05  WS-REV-MTH-DIFF              PIC 9(2)  VALUE ZEROS.      
T34391     05  WS-REV-YR-DIFF               PIC 9(2)  VALUE ZEROS.      
T34391     05  WS-TEMP-SMTHG                PIC 9(6)  VALUE ZEROS.      
T34391     05  WS-TEMP-SMTHE                PIC 9(6)  VALUE ZEROS.      
T34391     05  WS-SEAG-INDX                 PIC 9(2)  VALUE ZEROS.      
T34391     05  WS-SEAG-INDX1                PIC 9(2)  VALUE ZEROS.      
T34391     05  WS-SEAE-INDX                 PIC 9(2)  VALUE ZEROS.      
T34391     05  WS-SEAE-INDX1                PIC 9(2)  VALUE ZEROS.      
T34356     05  WS-OLD-EPP3                  PIC S9(07)V99 VALUE ZEROS.  
T34356     05  WS-NEW-EPP4                  PIC S9(07)V99 VALUE ZEROS.  
           05  WS-REVENUE-MONTH             PIC 9(6).                   
           05  FILLER REDEFINES WS-REVENUE-MONTH.                       
               10  WS-REV-YEAR              PIC 9(4).                   
               10  WS-REV-MONTH             PIC 9(2).                   
COB305     05 WS-START-REV-MONTH        PIC S9(6) COMP-3 VALUE 0.           
COB305     05 WS-ACCOUNT-NO-WQ        PIC S9(13) COMP-3 VALUE 0.          
COB305     05 WS-ACCOUNT-NO-HOLD-AC        PIC S9(13) COMP-3 VALUE 0.          
PCR470     05  WS-HOLD-ITEM-ID              PIC S9(9) COMP.             
COB305     05 WS-AMT-TRAN-BAL-HOLD-AC        PIC S9(9)V99 COMP-3 
COB305       VALUE 0.        
C25936     05  WS-ARREARS-AMOUNT            PIC S9(9)V99 COMP-3 VALUE 0.
C25936     05  WS-TOTAL-BALANCE             PIC S9(11)V9(2) USAGE       
C25936                                                   COMP-3 VALUE 0.
COB305     05 WS-CURR-UTIL-BAL        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 EPP-TOTAL        PIC S9(09)V99 COMP-3 VALUE 0.       
COB305     05 EPP-OFFER-AMOUNT        PIC S9(09)V99 COMP-3 VALUE 0.       
C26130     05  WS-HIST-DATA-SUFFICIENT      PIC X(01)  VALUE 'N'.       
C27553     05  WS-GAS-SW                    PIC X(01)  VALUE 'N'.       
C27553     05  WS-ELEC-SW                   PIC X(01)  VALUE 'N'.       
T28606     05  WS-LOAD-WQ-FOR-BAL           PIC X(01)  VALUE 'N'.       
T28606     05  WS-ORIG-AMT-MO-PYMT          PIC S9(9)V99.               
C27553     05  WS-FUTURE-BILL-HOOK          PIC X(01)  VALUE 'N'.       
C27553     05  WS-ELEC-USAGE-MTHS           PIC S9(04) COMP VALUE 0.    
C27553     05  WS-GAS-USAGE-MTHS            PIC S9(04) COMP VALUE 0.    
COB305     05 WS-REMAINDER        PIC 99 COMP-3 VALUE 0.              
COB305     05 WS-EPP-MONTHS-REMAINING        PIC S9(3) COMP-3 VALUE 0.          
COB305     05 WS-MONTH-CTR        PIC S9(3) COMP-3 VALUE 0.           
T10583     05  WS-AMT-MO-PMT-HOLD           PIC S9(9)V99.               
T32040     05  WS-EPP-DIFF                  PIC S9(9).                  
C34216     05  WS-EPP-DIFF2                 PIC S9(9).                  
T10583     05  WS-AMT-MO-PYMT-BRKDWN.                                   
T10583         10  WS-AMT-MO-PMT-DLLR       PIC S9(9).                  
T10583         10  WS-AMT-MO-PMT-CNTS       PIC V99.                    
COB305     05 EPP-FINAL-TOTAL        PIC S9(09) COMP-3 VALUE 0.          
COB305     05 EPP-FINAL-TOTAL-WBAL        PIC S9(09) COMP-3 VALUE 0.          
COB305     05 WS-EPP-AMT        PIC S9(09)V99 COMP-3 VALUE 0.       
COB305     05 WS-IC-EPP-TOTAL        PIC S9(09)V99 COMP-3 VALUE 0.       
P00307     05  WS-AMT-MO-PYMT-X             PIC ZZZZZZZZ9.99.           
COB305     05 WS-BBP-NOADJ-AMT        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.
P00307     05  WS-BPP-PERCENT-CALC          PIC S9(9).                  
COB305     05 WS-BBP-PERCENT-DELQ        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.
COB305     05 WS-BBP-PERCENT-MAX-DELQ        PIC S9(4)V9(5) 
COB305       USAGE COMP-3 VALUE 0.
COB305     05 WS-BBP-CAP-AMOUNT        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.
P00694     05  WS-BBP-ANNIV-PRICE-DISP      PIC 99.999999 VALUE ZEROS.  
P00694     05  WS-BBP-CSC-AMT-DISP          PIC Z9.99     VALUE ZEROS.  
P00307     05  WS-GENERATE-WQ               PIC X VALUE SPACES.         
P00307     05  WS-EXEMPT-FLAG               PIC X VALUE SPACES.         
P00307     05  WS-REFUND-EXIST              PIC X VALUE 'N'.            
P00307     05  WS-PREV-ADJUSTMENT           PIC X VALUE SPACES.         
P00307     05  WS-BBP-HOLD-OLD-AMT          PIC 9(04) VALUE ZEROS.      
P00307     05  CURRENT-TIMESTAMP            PIC X(26).                  
P00307     05  WS-CURRENT-TIMESTAMP REDEFINES CURRENT-TIMESTAMP.        
P00307         10  WS-TS-DATE               PIC X(10).                  
P00307         10  FILLER                   PIC X(16).                  
P00307     05  CURRENT-DATE                 PIC X(10).                  
P00307     05  WS-HOLD-REV-MONTH            PIC 9(06).                  
P00307     05  WS-BILL-DATE                 PIC 9(06).                  
P00307     05  WS-BILL-DATE-R REDEFINES WS-BILL-DATE.                   
P00307         10  WS-BILL-DATE-CCYY        PIC X(04).                  
P00307         10  WS-BILL-DATE-MM          PIC X(02).                  
P00307     05  WS-TRAN-COMMENT-TEXT         PIC X(210).                 
           05  WS-COMMENT-LENGTH.                                       
               10 WS-TRAN-COMMENT-LEN       PIC X(04).                  
               10 WS-TRAN-COMMENT-LEN-N REDEFINES WS-TRAN-COMMENT-LEN   
                                            PIC 9(04).                  
               10 WS-TRAN-COMMENT-LEN-C     PIC S9(04) USAGE COMP.      
           05  WS-TEST-KEY.                                             
               10  WS-TK-CODE-UTIL-TYPE     PIC X(1).                   
               10  WS-TK-RATE-PLAN-NO       PIC X(3).                   
               10  WS-TK-REVENUE-MONTH      PIC 9(6).                   
           05  WS-HOLD-BUDGET-INDX          PIC S9(4) COMP.             
PCR470     05  WS-AR-HOLD-INDX              PIC S9(4) COMP.             
TP3442     05  WS-WORK-DATE.                                            
TP3442         10 WS-WORK-DATE-CCYY         PIC 9(04).                  
TP3442         10 FILLER                    PIC X(01).                  
TP3442         10 WS-WORK-DATE-MM           PIC 9(02).                  
TP3442         10 FILLER                    PIC X(03).                  
                                                                        
T19143     05  WS-TEMP-DATE-X.                                          
T19143         10 WS-TEMP-CCYY-X            PIC X(04).                  
T19143         10 WS-TEMP-D1-X              PIC X(01) VALUE '-'.        
T19143         10 WS-TEMP-MM-X              PIC X(02).                  
T19143         10 WS-TEMP-D2-X              PIC X(01) VALUE '-'.        
T19143         10 WS-TEMP-DD-X              PIC X(02) VALUE '01'.       
                                                                        
T19143     05  WS-TEMP-DATE-9.                                          
T19143         10 WS-TEMP-CCYY-9            PIC 9(04).                  
T19143         10 WS-TEMP-MM-9              PIC 9(02).                  
                                                                        
T17241     05  WS-ANN-DATE-BOUND.                                       
T17241         10 WS-ANN-DATE-BOUND-CCYY     PIC X(04).                 
T17241         10 WS-ANN-DATE-BOUND-MM       PIC X(02).                 
T17241     05  WS-ANN-DATE-BOUND-NUM REDEFINES                          
T17241         WS-ANN-DATE-BOUND.                                       
T17241         10 WS-ANN-DATE-BOUND-NUM-CCYY PIC 9(04).                 
T17241         10 WS-ANN-DATE-BOUND-NUM-MM   PIC 9(02).                 
T17241     05  WS-EPP-WQ-BOUND.                                         
T17241         10 WS-EPP-WQ-BOUND-CCYY       PIC 9(04).                 
T17241         10 WS-EPP-WQ-BOUND-MM         PIC 9(02).                 
T17241     05  WS-EPP-WQ-UBOUND.                                        
T17241         10 WS-EPP-WQ-UBOUND-CCYY      PIC 9(04).                 
T17241         10 WS-EPP-WQ-UBOUND-MM        PIC 9(02).                 
T17241     05  WS-EPP-WQ-LBOUND.                                        
T17241         10 WS-EPP-WQ-LBOUND-CCYY      PIC 9(04).                 
T17241         10 WS-EPP-WQ-LBOUND-MM        PIC 9(02).                 
T17241         10 WS-EPP-WQ-LBOUND-MMN REDEFINES                        
T17241            WS-EPP-WQ-LBOUND-MM.                                  
T17241            15  WS-EPP-MM-CALC         PIC S9(02).                
T17241     05  WS-EPP-HOLD                   PIC 9(02).                 
T17241     05  WS-TODAY.                                                
T17241         10 WS-INPUT-DATE-CCYY         PIC X(04).                 
T17241         10 WS-INPUT-DATE-MM           PIC X(02).                 
T17241     05  WS-TODAY-NUM REDEFINES WS-TODAY.                         
T17241         10 WS-TODAY-COMPARE           PIC 9(06).                 
T17241     05  WS-EPP-EXCPTN-BAL             PIC S9(07)V99.             
T32040     05  WS-EPP-TOTAL-BAL              PIC S9(07)V99.             
T17241                                                                  
P00694      05  WS-PCT-RESRATEINCR-ELEC      PIC S9(4)V9(5) COMP-3      
P00694                                                      VALUE 0.    
P00694      05  WS-PCT-RESRATEINCR-GAS       PIC S9(4)V9(5) COMP-3      
P00694                                                      VALUE 0.    
P00694      05  WS-PCT-COMRATEINCR-ELEC      PIC S9(4)V9(5) COMP-3      
P00694                                                      VALUE 0.    
P00694      05  WS-PCT-COMRATEINCR-GAS       PIC S9(4)V9(5) COMP-3      
P00694                                                      VALUE 0.    
C26164      05  WS-PCT-ESTRATEINCR-ELEC      PIC S9(4)V9(5) COMP-3      
C26164                                                      VALUE 0.    
C26164      05  WS-PCT-ESTRATEINCR-GAS       PIC S9(4)V9(5) COMP-3      
C26164                                                      VALUE 0.    
T34990      05  WS-SEB-MTRD-FACTOR            PIC S9(4)V9(5) COMP-3     
T34990                                                      VALUE 0.    
C26164      05  WS-ELEC-BUFFER               PIC -9.9999.               
C26164      05  WS-GAS-BUFFER                PIC -9.9999.               
COB305      05 WS-MSG-INDX        PIC S9(5) COMP-3 VALUE 0.          
T17777***** WORKING STORAGE FOR VARIABLES ADDED FOR TPR17777            03760000
T17777  01 WS-WORK-VARIABLES-CIA.                                       
                                                                        
COB305     05 WS-CIA-LIHEAP-CREDIT        PIC S9(09)V99 COMP-3 VALUE 0.      
COB305     05 WS-CIA-LIHEAP-REMAIN        PIC S9(09)V99 COMP-3 VALUE 0.      
COB305     05 WS-CIA-LIHEAP-AMT        PIC S9(09)V99 COMP-3 VALUE 0.      
T17777     05  WS-CIA-LIHEAP-INDX            PIC S9(4) COMP.            
COB305     05 WS-CIA-CASH-CREDIT        PIC S9(09)V99 COMP-3 VALUE 0.      
COB305     05 WS-CIA-CASH-REMAIN        PIC S9(09)V99 COMP-3 VALUE 0.      
COB305     05 WS-CIA-CASH-AMT        PIC S9(09)V99 COMP-3 VALUE 0.      
T17777     05  WS-CIA-CASH-INDX              PIC S9(4) COMP.            
COB305     05 WS-NEW-TRAN-BALANCE        PIC S9(09)V99 COMP-3 VALUE 0.      
COB305     05 WS-PAID-TRAN-BALANCE        PIC S9(09)V99 COMP-3 VALUE 0.      
T17777     05  WS-DELETE                     PIC X(01) VALUE 'D'.       
T17777     05  WS-P                          PIC X(01) VALUE 'P'.       
T17777     05  WS-PGRMNAME                   PIC X(08)                  
T17777                                             VALUE 'SCSCA112'.    
T17777     05  WS-SYSTEM                     PIC X(07) VALUE 'SYSTEM'.  
T17777     05  WS-ADJUST                     PIC X(01) VALUE 'A'.       
T17777     05  WS-INDIRECT-JRNL              PIC X(01) VALUE 'A'.       
T27925     05  WS-DETAIL-END-BAL             PIC S9(11)V99  VALUE ZERO. 
T27925     05  WS-DETAIL-END-AR-BAL          PIC S9(11)V99  VALUE ZERO. 
                                                                        
       01  WS-CONSTANTS.                                                
           05  SCSCA107                     PIC X(8) VALUE 'SCSCA107'.  
C34569     05  SCSCA328                     PIC X(8) VALUE 'SCSCA328'.  
      ** BILL ITEM INDICATORS                                           04020000
           05  WS-ACTIVE-ITEM               PIC X(1) VALUE 'A'.         
           05  WS-BACKOUT                   PIC X(1) VALUE 'B'.         
           05  WS-CLERK-CANCEL              PIC X(1) VALUE 'J'.         
           05  WS-CALC-CANCEL               PIC X(1) VALUE 'K'.         
           05  WS-SUMMARY-ITEM              PIC X(1) VALUE 'S'.         
           05  WS-TRANSFER-ITEM             PIC X(1) VALUE 'T'.         
      ** BILL ITEM TYPES                                                04090000
           05  WS-CURRENT-TYPE              PIC X(1) VALUE 'C'.         
           05  WS-PRE-CALC                  PIC X(1) VALUE 'S'.         
           05  WS-TAX-ONLY                  PIC X(1) VALUE 'J'.         
           05  WS-REGULAR-BILL              PIC X(1) VALUE 'A'.         
      ** BILL ITEM TYPES                                                04140000
           05  WS-WARNING                   PIC X(1) VALUE 'W'.         
           05  WS-REJECT                    PIC X(1) VALUE 'R'.         
                                                                        
TP3441     05  WS-A                         PIC X(01) VALUE 'A'.        
T10082     05  WS-B                         PIC X(01) VALUE 'B'.        
TP3441     05  WS-M                         PIC X(01) VALUE 'M'.        
TP6269     05  WS-N                         PIC X(01) VALUE 'N'.        
T9678      05  WS-O                         PIC X(01) VALUE 'O'.        
T10082     05  WS-X                         PIC X(01) VALUE 'X'.        
TP6269     05  WS-Y                         PIC X(01) VALUE 'Y'.        
T10082     05  WS-BILL                      PIC X(04) VALUE 'BILL'.     
T10082     05  WS-101                       PIC S9(05) COMP-3           
T10082                                           VALUE +00101.          
T15927     05  WS-ANNIV                     PIC X(01) VALUE 'A'.        
T15927     05  WS-START-UP                  PIC X(01) VALUE 'S'.        
T29768     05  WS-EPP-USAGE-ERROR-PULLCD    PIC X(01) VALUE 'Z'.        
T17335     05  WS-BH-DATE-FROM-REV-MON   .                              
T17335         10  WS-BH-DATE-CCYYY    PIC 9(04) VALUE ZERO.            
T17335         10  FILLER              PIC X(01) VALUE '-'.             
T17335         10  WS-BH-DATE-MM       PIC 9(02) VALUE ZERO.            
T17335         10  FILLER              PIC X(01) VALUE '-'.             
T17335         10  WS-BH-DATE-DD       PIC 9(02) VALUE 01.              
C34569     05  WS-REV-DATE-FROM.                                        
C34569         10  WS-REV-DATE-CCYYY   PIC 9(04) VALUE ZERO.            
C34569         10  FILLER              PIC X(01) VALUE '-'.             
C34569         10  WS-REV-DATE-MM      PIC 9(02) VALUE ZERO.            
C34569         10  FILLER              PIC X(01) VALUE '-'.             
C34569         10  WS-REV-DATE-DD      PIC 9(02) VALUE 01.              
C34569     05  WS-REV-DATE-TO.                                          
C34569         10  WS-REV2-DATE-CCYYY   PIC 9(04) VALUE ZERO.           
C34569         10  FILLER               PIC X(01) VALUE '-'.            
C34569         10  WS-REV2-DATE-MM      PIC 9(02) VALUE ZERO.           
C34569         10  FILLER               PIC X(01) VALUE '-'.            
C34569         10  WS-REV2-DATE-DD      PIC 9(02) VALUE 01.             
C34569     05  WS-LAST-DAY-OF-MONTH     PIC X(10).                      
C34569     05  WS-LAST-REV-DATE         PIC X(10).                      
C34569     05  WS-LAST-REV-DT.                                          
C34569         10  WS-LAST-REVDT-CCYYY  PIC 9(04) VALUE ZERO.           
C34569         10  FILLER               PIC X(01) VALUE '-'.            
C34569         10  WS-LAST-REVDT-MM     PIC 9(02) VALUE ZERO.           
C34569         10  FILLER               PIC X(01) VALUE '-'.            
C34569         10  WS-LAST-REVDT-DD     PIC 9(02) VALUE 01.             
T17335     05  WS-REV-CCYYMM-TEMP           .                           
T17335         10  WS-REV-CCYY-TEMP         PIC 9(04).                  
T17335         10  WS-REV-MM-TEMP           PIC 9(02).                  
C33924     05  WS-MSG-RT-110-105       PIC S9(5) COMP-3 VALUE 95155.    
C33924     05  WS-MSG-RT-105-110       PIC S9(5) COMP-3 VALUE 95157.    
P00307     05  WS-MONITOR-DATE              PIC X(10).                  
P00307     05  WS-MONITOR-DATE-1            PIC X(10).                  
P00307     05  WS-MONITOR-DATE-R.                                       
P00307         10  WS-MON-DATE-CCYY         PIC X(04) VALUE SPACES.     
P00307         10  FILLER                   PIC X(01) VALUE '-'.        
P00307         10  WS-MON-DATE-MM           PIC X(02) VALUE SPACES.     
P00307         10  FILLER                   PIC X(01) VALUE '-'.        
P00307         10  WS-MON-DATE-DD           PIC X(02) VALUE '01'.       
                                                                        
T20178 01  WS-CANCEL-REBILL-FLAG            PIC X(01).                  
T20178     88  WS-NOT-BILL-CORR                VALUE 'N'.               
T20178     88  WS-BILL-CORRECTION              VALUE 'Y'.               
T34569 01  WS-NEXT-REV-MTH                  PIC 9(6) VALUE 0.           
T34569 01  WS-NEXT-REV-YR                    PIC 9(4) VALUE 0.          
T34990 01  WS-DUMMY-REV-MTH                 PIC 9(6) VALUE 0.           
T34990 01  WS-COMP-REV-YR                   PIC 9(4) VALUE 0.           
T34990 01  WS-DUMMY-MTH-CTR                 PIC 9(4) VALUE 0.           
      ***                                                               04430000
       01  WS-SWITCHES.                                                 
T22520     05  WS-181-SW                    PIC X(01) VALUE 'N'.        
T34243     05  WS-180-SW                    PIC X(01) VALUE 'N'.        
T19142     05  WS-IC-WARNING-FLAG           PIC X(01) VALUE 'N'.        
           05  WS-WQ-MESSAGE-SET-SW         PIC X(01).                  
               88  WS-WQ-MESSAGE-SET            VALUE '1'.              
               88  WS-WQ-MESSAGE-NOT-SET        VALUE '0'.              
           05  WS-ANNUAL-RECALC-SW          PIC X(01).                  
               88 ANNUAL-RECALC-NOT-DONE        VALUE '0'.              
               88 ANNUAL-RECALC-COMPLETE        VALUE '1'.              
           05  WS-RATE-TARIFF-CHANGE-SW     PIC X(01).                  
               88 RATE-TARIFF-CHANGE-NOT-DONE   VALUE '0'.              
               88 RATE-TARIFF-CHANGE-COMPLETE   VALUE '1'.              
           05  WS-UNMETERED-IC-IND          PIC X(1).                   
               88  WS-UNMETERED-IC              VALUE 'Y'.              
T19679     05  WS-TEMP-INCOMPLETE-SET       PIC X(1) VALUE 'N'.         
T19679     05  WS-TEMP-UNMETERED-IC         PIC X(1) VALUE 'N'.         
           05  WS-COMPLETE-SET-IND          PIC X(1).                   
               88  WS-INCOMPLETE-SET            VALUE '0'.              
               88  WS-COMPLETE-SET              VALUE '1'.              
T32040     05  WS-COMPLETE-SET-468          PIC X(1).                   
T32040         88  WS-INCOMPLETE-468            VALUE '0'.              
T32040         88  WS-COMPLETE-468              VALUE '1'.              
T34391     05  WS-SEASONAL-ACC              PIC X(1).                   
T34391         88  WS-SEASONAL-NO               VALUE '0'.              
T34391         88  WS-SEASONAL-YES              VALUE '1'.              
T20503     05  WS-EPP-HIST-USAGE-ERROR-FL   PIC X(1) VALUE 'N'.         
T20503         88  WS-EPP-HIST-USAGE-ERROR      VALUE 'Y'.              
T33004     05  WS-EPP-ANNIV-PROJ-COST-FL    PIC X(1) VALUE 'N'.         
T33004         88  WS-EPP-ANN-PRJ-CST-ERROR     VALUE 'Y'.              
PCR212     05  WS-ELEC-SERVICE-IND          PIC X(1).                   
PCR212         88  WS-ELEC-SERVICE              VALUE 'Y'.              
PCR212         88  WS-NO-ELEC-SERVICE           VALUE 'N'.              
PCR212     05  WS-GAS-SERVICE-IND           PIC X(1).                   
PCR212         88  WS-GAS-SERVICE               VALUE 'Y'.              
PCR212         88  WS-NO-GAS-SERVICE            VALUE 'N'.              
T16496     05  WS-ELEC-UNMTRD-SWITCH        PIC X(1).                   
T16496         88  WS-ELEC-AS-UNMTRD            VALUE 'Y'.              
T16496         88  WS-ELEC-NOT-AS-UNMTRD        VALUE 'N'.              
T9895      05  WS-ROW-EXISTS                PIC X(1) VALUE 'N'.         
T9895          88  ROW-EXISTS                   VALUE 'Y'.              
T9895      05  WS-START-UP-EXISTS           PIC X(1) VALUE 'N'.         
T9895          88  START-UP-EXISTS              VALUE 'Y'.              
T34474     05  WS-EPP-WQ-REQD               PIC X(1) VALUE 'N'.         
T34474         88  EPP-WQ-REQD                  VALUE 'Y'.              
T19143     05  WS-ANNIV-FND-SW              PIC X(1) VALUE 'N'.         
T32040     05  WS-MONITOR-EPP-FLAG          PIC X(1) VALUE 'N'.         
C33924     05  WS-RATE-FLIP-FOUND-SW        PIC X(1) VALUE 'N'.         
I00177     05  WS-UT-MATCH-SW               PIC X(1).                   
I00177         88  UT-MATCH-FOUND               VALUE 'Y'.              
I00177         88  UT-MATCH-NOT-FOUND           VALUE 'N'.              
P00694     05  WS-CURR-MTH-BILL-SW          PIC X(1).                   
P00694         88  CURR-MTH-BILL                VALUE 'Y'.              
P00694         88  NOT-CURR-MTH-BILL            VALUE 'N'.              
                                                                        
COB305 01 WS-NO-OF-EPP-MONTHS        PIC S9(3) COMP-3 VALUE 0.           
COB305 01 WS-NO-OF-MONTHS-HELD        PIC S9(3) COMP-3 VALUE 0.           
COB305 01 WS-BILL-CTRE        PIC S9(3) COMP-3 VALUE 0.           
COB305 01 WS-BILL-CTRG        PIC S9(3) COMP-3 VALUE 0.           
COB305 01 WS-BILL-CTRU        PIC S9(3) COMP-3 VALUE 0.           
                                                                        
I00177 01  WS-HOLD-CX-DATA                  PIC X(31000).               
CIG    01  WS-HOLD-BX-DATA                  PIC X(10000).               
P00496 01  WS-HOLD-LN-DATA                  PIC X(10000).               
P00496 01  WS-HOLD-LO-DATA                  PIC X(10000).               
I00177 01  WS-HOLD-BC-DATA                  PIC X(100000).              
P00496 01  WS-HOLD-BA-DATA                  PIC X(20400).               
C34569 01  WS-HOLD-BT-DATA                  PIC X(15000).               
T32040 01  WS-HOLD-CALC-WORK                PIC X(62).                  
T32040*THE ABOVE CHANGE IS DONE AS THE LENGTH 55 IS INCORRECT PER VIJAY 04980000
T32040*THIS CHANGE IS NOT REALLY PART OF THIS CML32040                  04980000
                                                                        
      /                                                                 05000000
T10082 COPY FIOWK03.                                                    05010000
      /********************************************************         05020000
      *                                                       *         05030000
      *   WORKING STORAGE FOR BASIC WQ MESSAGE TEXT           *         05040000
      *                                                       *         05050000
      *********************************************************         05060000
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-WORK-MESSAGE.                                         
               10  WS-WQ-CATEGORY-ID       PIC S9(4) COMP.              
               10  WS-WQ-PRIORITY          PIC X(1).                    
               10  WS-WQ-ROUTE-CATEGORY    PIC X(1).                    
               10  WS-WQ-MESSAGE-LENGTH    PIC S9(4) COMP.              
T22520         10  WS-WQ-MESSAGE-TEXT      PIC X(250).                  
               10  WS-WQ-SUPPL-TYPE        PIC X(1).                    
T20503     05  WS-EPP-USAGE-ERROR.                                      
T20503         10  FILLER                  PIC S9(4) COMP VALUE +169.   
T29768         10  FILLER                  PIC X(1)  VALUE 'H'.         
T20503         10  FILLER                  PIC X(1)  VALUE '4'.         
T20503         10  FILLER                  PIC S9(4) COMP VALUE +60.    
T20503         10  FILLER                  PIC X(34) VALUE              
T20503             'BBP HISTORY USAGE CONTAINS $0.00 .'.                
T24096         10  FILLER                  PIC X(26) VALUE              
T24096            ' TEMPORARY BILL PULL SET. '.                         
T20503         10  FILLER                  PIC X(1) VALUE ' '.          
T28606     05  WS-EPP-BALANCE-WARNING-A.                                
T28606         10  FILLER                  PIC S9(4) COMP VALUE +152.   
T28606         10  FILLER                  PIC X(1)  VALUE 'N'.         
T28606         10  FILLER                  PIC X(1)  VALUE '4'.         
T28606         10  FILLER                  PIC S9(4) COMP VALUE +49.    
T28606         10  FILLER                  PIC X(60) VALUE              
T28606             'BALANCE MORE THAN + OR - 3 TIMES MONTHLY BBP AMT.'. 
T28606         10  FILLER                  PIC X(1) VALUE ' '.          
T32040     05  WS-EPP-BALANCE-WARNING-B.                                
T32040         10  FILLER                  PIC S9(4) COMP VALUE +152.   
T32040         10  FILLER                  PIC X(1)  VALUE 'N'.         
T32040         10  FILLER                  PIC X(1)  VALUE '4'.         
A03850         10  FILLER                  PIC S9(4) COMP VALUE +81.    
T32040         10  FILLER                  PIC X(60) VALUE              
T32040   'NEW BBP CALC AT 4 MONTHS NEEDS REVIEW.NEW AMT CALCULATED IS '.
A01315         10  WS-NEW-EPP-AMT4         PIC ----9.                   
T32040         10  FILLER                  PIC X(1) VALUE ' '.          
A03850         10  FILLER                  PIC X(9) VALUE 'OLD AMT: '.  
A03850         10  WS-OLD-EPP-AMT4         PIC ----9.                   
T32040     05  WS-EPP-BALANCE-WARNING-C.                                
T32040         10  FILLER                  PIC S9(4) COMP VALUE +152.   
T32040         10  FILLER                  PIC X(1)  VALUE 'N'.         
T32040         10  FILLER                  PIC X(1)  VALUE '4'.         
A03850         10  FILLER                  PIC S9(4) COMP VALUE +81.    
T32040         10  FILLER                  PIC X(60) VALUE              
T32040   'NEW BBP CALC AT 8 MONTHS NEEDS REVIEW.NEW AMT CALCULATED IS '.
A01315         10  WS-NEW-EPP-AMT8         PIC ----9.                   
T32040         10  FILLER                  PIC X(1) VALUE ' '.          
A03850         10  FILLER                  PIC X(9) VALUE 'OLD AMT: '.  
A03850         10  WS-OLD-EPP-AMT8         PIC ----9.                   
T32040     05  WS-EPP-BALANCE-WARNING-D.                                
T32040         10  FILLER                  PIC S9(4) COMP VALUE +152.   
T32040         10  FILLER                  PIC X(1)  VALUE 'N'.         
T32040         10  FILLER                  PIC X(1)  VALUE '4'.         
A03850         10  FILLER                  PIC S9(4) COMP VALUE +81.    
T32040         10  FILLER                  PIC X(60) VALUE              
T32040   'NEW BBP CALC AT 6 MONTHS NEEDS REVIEW.NEW AMT CALCULATED IS '.
A01315         10  WS-NEW-EPP-AMT6         PIC ----9.                   
T32040         10  FILLER                  PIC X(1) VALUE ' '.          
A03850         10  FILLER                  PIC X(9) VALUE 'OLD AMT: '.  
A03850         10  WS-OLD-EPP-AMT6         PIC ----9.                   
T32040     05  WS-EPP-BALANCE-WARNING-E.                                
T32040         10  FILLER                  PIC S9(4) COMP VALUE +152.   
T32040         10  FILLER                  PIC X(1)  VALUE 'N'.         
T32040         10  FILLER                  PIC X(1)  VALUE '4'.         
T32040         10  FILLER                  PIC S9(4) COMP VALUE +88.    
T32040         10  FILLER                  PIC X(60) VALUE              
T32040   'NEW BBP WILL NOT BE CALCULATED,HISTORY NOT AVAIL,REVIEW REQD'.
T32040         10  FILLER                  PIC X(1) VALUE ' '.          
ACT003         10  FILLER                  PIC X(9) VALUE 'OLD AMT: '.  
ACT003         10  WS-OLD-EPP-AMT-E        PIC ----9.                   
ACT003         10  FILLER                  PIC X(1)  VALUE ' '.         
ACT003         10  FILLER                  PIC X(10) VALUE 'REM MTHS: '.
ACT003         10  WS-REM-EPP-MTHS-E       PIC -9.                      
           05  WS-EPP-BALANCE-WARNING.                                  
T17529         10  FILLER                  PIC S9(4) COMP VALUE +152.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +49.    
               10  FILLER                  PIC X(60) VALUE              
T19141             'BALANCE MORE THAN + OR - 4 TIMES MONTHLY BBP AMT.'. 
               10  FILLER                  PIC X(1) VALUE ' '.          
6320       05  WS-EPP-BUDGET-WARNING.                                   
T17529         10  FILLER                  PIC S9(4) COMP VALUE +152.   
6320           10  FILLER                  PIC X(1)  VALUE 'N'.         
6320           10  FILLER                  PIC X(1)  VALUE '4'.         
6320           10  FILLER                  PIC S9(4) COMP VALUE +56.    
6320           10  FILLER                  PIC X(49) VALUE              
6320              'BUDGET PAYMENT ROW MISSING UNABLE TO RECALL RATE '.  
6320           10  FILLER                  PIC X(7) VALUE               
6320              'TARIFF.'.                                            
               10  FILLER                  PIC X(1) VALUE 'H'.          
           05  WS-INSUFFICIENT-HISTORY.                                 
T17529         10  FILLER                  PIC S9(4) COMP VALUE +169.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +57.    
               10  FILLER                  PIC X(42) VALUE              
                   'LESS THAN 12 MONTHS HISTORY. CHECK RESULTS'.        
               10  FILLER                  PIC X(18) VALUE              
                   ' OF BBP RECALC.'.                                   
               10  FILLER                  PIC X(1) VALUE ' '.          
           05  WS-NO-BUDGET-AC.                                         
T17529         10  FILLER                  PIC S9(4) COMP VALUE +152.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +50.    
               10  FILLER                  PIC X(60) VALUE              
                   'NO BUDGET AR CONTROL FOUND. MONITORING TERMINATED.'.
               10  FILLER                  PIC X(1) VALUE ' '.          
           05  WS-MORE-THAN-3-CHANGES.                                  
T17529         10  FILLER                  PIC S9(4) COMP VALUE +152.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +30.    
               10  FILLER                  PIC X(60) VALUE              
                   'MORE THAN 3 CHANGES THIS YEAR'.                     
               10  FILLER                  PIC X(1) VALUE ' '.          
           05  WS-TOO-MANY-ICS.                                         
T17529         10  FILLER                  PIC S9(4) COMP VALUE +152.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +34.    
               10  FILLER                  PIC X(60) VALUE              
                   'CANNOT RECALC WITH MORE THAN 4 ICS'.                
               10  FILLER                  PIC X(1) VALUE ' '.          
           05  WS-CALC-ROUTINE-ERROR.                                   
T17529         10  FILLER                  PIC S9(4) COMP VALUE +152.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +53.    
               10  FILLER                  PIC X(45) VALUE              
                   'ERROR IN CALC ROUTINE. CANNOT COMPLETE BUDGET'.     
               10  FILLER                  PIC X(15) VALUE              
                   ' RECALC.'.                                          
               10  FILLER                  PIC X(1) VALUE ' '.          
P00211     05  WS-PRICE-ROUTINE-ERROR.                                  
P00211         10  FILLER                  PIC S9(4) COMP VALUE +152.   
P00211         10  FILLER                  PIC X(1)  VALUE 'N'.         
P00211         10  FILLER                  PIC X(1)  VALUE '4'.         
P00211         10  FILLER                  PIC S9(4) COMP VALUE +53.    
P00211         10  FILLER                  PIC X(46) VALUE              
P00211             'ERROR IN PRICE ROUTINE. CANNOT COMPLETE BUDGET'.    
P00211         10  FILLER                  PIC X(14) VALUE              
P00211             ' RECALC.'.                                          
P00211         10  FILLER                  PIC X(1) VALUE ' '.          
P00211     05  WS-PENDING-PRICE-ERROR.                                  
P00211         10  FILLER                  PIC S9(4) COMP VALUE +152.   
P00211         10  FILLER                  PIC X(1)  VALUE 'N'.         
P00211         10  FILLER                  PIC X(1)  VALUE '4'.         
P00211         10  FILLER                  PIC S9(4) COMP VALUE +53.    
P00211         10  FILLER                  PIC X(47) VALUE              
P00211             'ERROR GETTING PENDING PRICE CANNOT COMPLETE'.       
P00211         10  FILLER                  PIC X(13) VALUE              
P00211             'BUD RECALC.'.                                       
P00211         10  FILLER                  PIC X(1) VALUE ' '.          
C34569     05  WS-THERM-PRICE-ERROR.                                    
C34569         10  FILLER                  PIC S9(4) COMP VALUE +152.   
C34569         10  FILLER                  PIC X(1)  VALUE 'N'.         
C34569         10  FILLER                  PIC X(1)  VALUE '4'.         
C34569         10  FILLER                  PIC S9(4) COMP VALUE +53.    
C34569         10  FILLER                  PIC X(45) VALUE              
C34569             'ERROR GETTING THERM PRICE CANNOT COMPLETE'.         
C34569         10  FILLER                  PIC X(15) VALUE              
C34569             'BUD RECALC.'.                                       
C34569         10  FILLER                  PIC X(1) VALUE ' '.          
P00694     05  WS-CSC-AMT-ERROR.                                        
P00694         10  FILLER                  PIC S9(4) COMP VALUE +152.   
P00694         10  FILLER                  PIC X(1)  VALUE 'N'.         
P00694         10  FILLER                  PIC X(1)  VALUE '4'.         
P00694         10  FILLER                  PIC S9(4) COMP VALUE +53.    
P00694         10  FILLER                  PIC X(41) VALUE              
P00694             'ERROR GETTING CSC AMOUNT CANNOT COMPLETE '.         
P00694         10  FILLER                  PIC X(15) VALUE              
P00694             'BUD RECALC.'.                                       
P00694         10  FILLER                  PIC X(1) VALUE ' '.          
T21551     05  WS-EPP-ANIVERSARY-ERROR.                                 
T21551         10  FILLER                  PIC S9(4) COMP VALUE +137.   
T21551         10  FILLER                  PIC X(1)  VALUE 'N'.         
T21551         10  FILLER                  PIC X(1)  VALUE '4'.         
T21551         10  FILLER                  PIC S9(4) COMP VALUE +50.    
T21551         10  FILLER                  PIC X(60) VALUE              
T21551             'BBP-ANIVERSARY DATE IS NOT VALID MUST END IN 01'.   
T21551         10  FILLER                  PIC X(1) VALUE ' '.          
           05  WS-DATABASE-EXCEPTION.                                   
PCR629         10  FILLER                  PIC S9(4) COMP VALUE +137.   
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  FILLER                  PIC S9(4) COMP VALUE +29.    
               10  FILLER                  PIC X(60) VALUE              
                   'A DATABASE EXCEPTION OCCURRED'.                     
               10  FILLER                  PIC X(1) VALUE ' '.          
           05  WS-MISCELLANEOUS-MESSAGE.                                
PCR629         10  WS-MISC-CATEGORY        PIC S9(4) COMP VALUE +6.     
               10  FILLER                  PIC X(1)  VALUE 'N'.         
               10  FILLER                  PIC X(1)  VALUE '4'.         
               10  WS-MISC-MSG-LEN         PIC S9(4) COMP VALUE +60.    
               10  WS-MISC-MSG-TEXT        PIC X(60).                   
               10  FILLER                  PIC X(1) VALUE ' '.          
T22520     05  WS-EPP-MONTH-NOT-FOUND.                                  
T22520         10  FILLER                  PIC S9(4) COMP VALUE +169.   
T22520         10  FILLER                  PIC X(1)  VALUE 'H'.         
T22520         10  FILLER                  PIC X(1)  VALUE '4'.         
T22520         10  FILLER                  PIC S9(4) COMP VALUE +74.    
T22520         10  FILLER                  PIC X(50) VALUE              
T22520            'ACCOUNT DOES NOT HAVE CONSECUTIVE BILLING MONTHS. '. 
T22520         10  FILLER                  PIC X(24) VALUE              
T22520            'TEMPORARY BILL PULL SET.'.                           
T22520         10  FILLER                  PIC X(1) VALUE ' '.          
C26164         10  WS-REMARKS-TEXT         PIC X(50) VALUE SPACES.      
C26164         10  WS-REMARKS-LEN          PIC S9(04) COMP VALUE ZEROS. 
      /                                                                 06550000
P00307 01  WS-BBP-UPDATE-TEXT              PIC X(210) VALUE SPACES.     
P00307 01  WS-BBP-UPDATE-LEN               PIC S9(04) COMP VALUE +67.   
P00307 01  WS-BBP-UPDATE-MSG.                                           
P00307     05  FILLER                      PIC X(09) VALUE 'ADJ FROM '. 
P00307     05  WS-BBP-OLD-AMT              PIC 9(04) VALUE ZEROS.       
P00307     05  FILLER                      PIC X(04) VALUE ' TO '.      
P00307     05  WS-BBP-NEW-AMT              PIC 9(04) VALUE ZEROS.       
P00307     05  FILLER                      PIC X(29) VALUE              
P00307         ' TO AVOID LRG BAL @ ANNIV IN '.                         
P00307     05  WS-BBP-MSG-MTHS             PIC X(03) VALUE SPACES.      
P00307     05  FILLER                      PIC X(07) VALUE ' MONS/ '.   
P00307     05  WS-BBP-MSG-DATE.                                         
P00307         10  WS-BBP-MSG-DATE-MM      PIC X(02) VALUE SPACES.      
P00307         10  FILLER                  PIC X(01) VALUE '-'.         
P00307         10  WS-BBP-MSG-DATE-CCYY    PIC X(04) VALUE SPACES.      
P00307                                                                  
P00307 01  WS-BBP-LETTER-LEN               PIC S9(04) COMP VALUE +23.   
P00307 01  WS-BBP-LETTER-MSG.                                           
P00307     05  FILLER                      PIC X(29) VALUE              
P00307         'SYSTEM GENERATED LETTER'.                               
P00307                                                                  
P00307 01  WS-BBP-TRANS-HIST-LEN           PIC S9(04) COMP VALUE +69.   
P00307 01  WS-BBP-TRANS-HIST-MESS.                                      
P00307     05 FILLER                       PIC X(51) VALUE              
P00307        'SYSTEM UPDATED BBP AMT FOR 4/6/8 MONTH MONITORING. '.    
P00307     05 FILLER                       PIC X(18) VALUE              
P00307        'LETTER GENERATED.'.                                      
       01  WS-HOLD-BILL-DATA.                                           
           03  WS-IC-DATA                                               
T20014            OCCURS 5 TIMES                                        
                  INDEXED BY WS-ICD-INDX.                               
COB305         05 WS-ICD-TOTAL        PIC S9(9)V99 COMP-3 VALUE 0.    
               05  WS-ICD-RATE-PLAN-NO          PIC X(3).               
               05  WS-ICD-CODE-REVENUE-CLASS    PIC X(3).               
               05  WS-ICD-CODE-UTIL-TYPE        PIC X(1).               
               05  WS-ICD-IC-NO                 PIC S9(4) COMP.         
               05  WS-ICD-CURR-BG               PIC S9(4) COMP.         
T17859         05  WS-HOLD-NO-MONTHS            PIC S9(4) COMP.         
COB305         05 WS-ICD-CODE-CURTAIL-PRTY        PIC S9(02)V9 COMP-3 
COB305           VALUE 0.    
RODFIX         05  WS-ICD-RT-PKG-OPT-SEQ-NO     PIC S9(04) COMP.        
      *                                                                 06700000
T17859     03  WS-HIST-COUNTER                                          
T20014            OCCURS 5 TIMES                                        
T17859            INDEXED BY WS-ICD-HIST-INDX.                          
T17859         05 WS-ICD-NO-MONTHS              PIC S9(4) COMP.         
           03  WS-BD-REV-MONTH-ENTRY                                    
                  OCCURS 12 TIMES                                       
                  DESCENDING KEY WS-BD-REVENUE-MONTH                    
                  INDEXED BY WS-RM-INDX.                                
               05  WS-BD-REVENUE-MONTH          PIC 9(6).               
               05  FILLER REDEFINES WS-BD-REVENUE-MONTH.                
                   10  WS-BD-REV-YEAR           PIC 9(4).               
                   10  WS-BD-REV-MONTH          PIC 9(2).               
               05  WS-BD-IC-ENTRY                                       
T20014                OCCURS 5 TIMES                                    
                      INDEXED BY WS-IC-INDX.                            
                   10  WS-BD-BILL-NO            PIC S9(9)    COMP.      
                   10  WS-BD-BILL-ITEM-TIMESTMP PIC X(26).              
COB305             10 WS-BD-GAS-BASE-USE        PIC S9(9) COMP-3 
COB305               VALUE 0.    
COB305             10 WS-BD-WNA-FACTOR        PIC S99V9(5) COMP-3 
COB305               VALUE 0.    
COB305             10 WS-BD-BTU-FACTOR        PIC S99V9(5) COMP-3 
COB305               VALUE 0.    
COB305             10 WS-BD-AMT-BILL-ITEM        PIC S9(9)V99 COMP-3 
COB305               VALUE 0.    
                   10  WS-BD-ENERGY-UNITS       PIC S9(9)    COMP.      
COB305             10 WS-BD-STATE-TAX-RATE        PIC S9V9(4) COMP-3 
COB305               VALUE 0.    
COB305             10 WS-BD-CITY-TAX-RATE        PIC S9V9(4) COMP-3 
COB305               VALUE 0.    
T22742             10  WS-BD-PRORATE-CD         PIC X(01).              
COB305             10 WS-BD-AMT-STATE-TAX        PIC S9(7)V9(2) COMP-3 
COB305               VALUE 0.  
T34391*                                                                         
T34391 01 WS-BD-CHK-SEASN-BLK.                                          
T34391   03 WS-CK-SEASONAL-MTHA OCCURS 11 TIMES                         
T34391            INDEXED BY WS-SEAE-KEY.                               
T34391             05  WS-CK-SEASONAL-MTH   PIC 9(6).                   
T34391             05  WS-CK-SEASONAL-MTHN REDEFINES WS-CK-SEASONAL-MTH.
T34391                 10  WS-CK-SEAS-YEAR      PIC 9(4).               
T34391                 10  WS-CK-SEAS-MONTH     PIC 9(2).               
T34391   03 WS-CG-SEASONAL-MTHA OCCURS 11 TIMES                         
T34391            INDEXED BY WS-SEAG-KEY.                               
T34391             05  WS-CG-SEASONAL-MTH   PIC 9(6).                   
T34391             05  WS-CG-SEASONAL-MTHN REDEFINES WS-CG-SEASONAL-MTH.
T34391                 10  WS-CG-SEAS-YEAR      PIC 9(4).               
T34391                 10  WS-CG-SEAS-MONTH     PIC 9(2).               
      /****** CWS00022 CALC PASS AREA                                   07070000
       COPY CWS0022B.                                                   07080000
      /****** CWS00056 EXPANDS CODES-DATA-PRESENT                       07090000
       COPY CWS00056.                                                   07100000
                                                                        
      /****** CWS00303 CONTAINS WS-WARNING-DATA-ELEMENTS                07120000
       COPY CWS00303.                                                   07130000
                                                                        
C34569/****** CWS00063 CONTAINS PASS AREA FOR SCSCB328                  07120000
C34569 COPY CWS00328.                                                   07130000
                                                                        
C34569/****** CWS00010                                                  07120000
C34569 COPY CWS00010.                                                   07130000
                                                                        
C34569/****** CWS09900                                                  07120000
C34569 COPY CWS09900.                                                   07130000
                                                                        
T10082/***** WORKING STORAGE FOR PAYMENT JOURNAL                        07150000
T10082 COPY CJF00101.                                                   07160000
      /*******************************************************          07170000
      *    INCLUDE DCLGEN TABLES                             *          07180000
      ********************************************************          07190000
           EXEC SQL                                                     07200000
                INCLUDE SQLCA                                           07210000
           END-EXEC.                                                    07220000
      ****** CWS00070 HAS BILLING WORK QUEUE LAYOUTS                    07230000
           EXEC SQL                                                     07240000
                INCLUDE CWS0070B                                        07250000
           END-EXEC.                                                    07260000
      /****** TBBLLDET HAS DECLARE FOR CSS_BILLING_DET BG               07270000
           EXEC SQL                                                     07280000
                INCLUDE TBBLLDET                                        07290000
           END-EXEC.                                                    07300000
      /****** TBBLLHDR HAS DECLARE FOR CSS_BILLING_HDR BI               07310000
           EXEC SQL                                                     07320000
                INCLUDE TBBLLHDR                                        07330000
           END-EXEC.                                                    07340000
      /****** TBBGTHST HAS DECLARE FOR CSS_BUDGET_HIST BH               07430000
           EXEC SQL                                                     07440000
                INCLUDE TBBGTHST                                        07450000
           END-EXEC.                                                    07460000
      /****** TBCNSMP HAS DECLARE FOR CSS_CNSMPTN_HIST CX               07470000
           EXEC SQL                                                     07480000
                INCLUDE TBCNSMP                                         07490000
           END-EXEC.                                                    07500000
      /****** TBUMCNSM HAS DECLARE FOR CSS_UM_CNSMPT_HIST UC            07510000
           EXEC SQL                                                     07520000
                INCLUDE TBUMCNSM                                        07530000
           END-EXEC.                                                    07540000
T8752 /****** TBDELQ HAS DECLARE FOR CSS_DELIQUENCY C8                  07550000
T8752      EXEC SQL                                                     07560000
T8752           INCLUDE TBDELQ                                          07570000
T8752      END-EXEC.                                                    07580000
T17777/****** TBDELQ HAS DECLARE FOR CSS_AR_TRANS_HIST AR               07590000
T17777     EXEC SQL                                                     07600000
T17777          INCLUDE TBARHIST                                        07610000
T17777     END-EXEC.                                                    07620000
T17777/****** TBDELQ HAS DECLARE FOR CSS_AR_TRN_HST_DET AU              07630000
T17777     EXEC SQL                                                     07640000
T17777          INCLUDE TBARHDT                                         07650000
T17777     END-EXEC.                                                    07660000
C25936/****** CSS_AR_CNTL AC                                            07700100
C25936     EXEC SQL                                                     07700200
C25936          INCLUDE TBARCNTL                                        07700300
C25936     END-EXEC.                                                    07701000
honk**********CSS_RATE_ATTRIBUTE JR                                             
honk**********C SQL                                                             
honk**********  INCLUDE TBRTATTR                                                
honk**********-EXEC.                                                            
honk**********CSS_ACCT_RTPK_AGR DF                                              
honk**********EC SQL                                                            
honk********** INCLUDE TBACCTRG                                                 
honk**********D-EXEC.                                                           
P00307/******* CSS_ACCT_ATTRIBUTE YP                                            
P00307     EXEC SQL                                                             
P00307        INCLUDE TBACTATT                                                  
P00307     END-EXEC.                                                            
P00307/******* CSS_MNT_TRANS_HIST MH                                            
P00307     EXEC SQL                                                             
P00307        INCLUDE TBMNHIST                                                  
P00307     END-EXEC.                                                            
P00307******** CSS_MT_TRN_HST_DET MI                                            
P00307     EXEC SQL                                                             
P00307        INCLUDE TBMNHDT                                                   
P00307     END-EXEC.                                                            
P00307*                                                                         
honk********** CSS_BUDGET_PLAN BU                                               
honk**********C SQL                                                             
honk**********INCLUDE TBBGTPLN                                                  
honk**********-EXEC.                                                            
P00307*                                                                         
P00307/******* CSS_REFUND RN                                                    
P00307     EXEC SQL                                                             
P00307        INCLUDE TBREFUND                                                  
P00307     END-EXEC.                                                            
P00307*                                                                         
                                                                        
      /****** DECLARE FOR BILLING BG RECORD HISTORY SEARCH              07710000
      ******* FOR EPP CALCULATION                                       07720000
           EXEC SQL                                                     
                DECLARE BI_BG_EPP CURSOR FOR                            
                SELECT                                                  
                   BG.BILL_NO,                                          
                   CODE_UTIL_TYPE,                                      
                   IC_NO,                                               
                   REPLACE(REPLACE(CONVERT(CHAR(26), BILL_ITEM_TIMESTMP
           , 121), ' ', '-'), ':', '.') BILL_ITEM_TIMESTMP,                    
                   CODE_REVENUE_CLASS,                                  
                   RATE_PLAN_NO,                                        
                   REV_MTH_ORIG_BILL,                                   
                   REVENUE_MONTH,                                       
                   GAS_BASE_USE,                                        
                   WNA_FACTOR,                                          
                   BTU_FACTOR,                                          
                   AMT_BILL_ITEM,                                       
                   AMT_STATE_TAX,                                       
                   AMT_CITY_TAX,                                        
T22742             PRORATE_CD                                           
                FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED),                  
                     CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
                WHERE BG.ACCOUNT_NO   = :BG-ACCOUNT-NO                  
                  AND BI.ACCOUNT_NO   = BG.ACCOUNT_NO                   
                  AND BI.BILL_NO      = BG.BILL_NO                      
                  AND CODE_BILL_ITM_TYPE = 'C'                          
                  AND CODE_BILL_ITM_IND  = 'A'                          
T29768            AND CODE_BILL_CALC     = 'A'                          
                  AND ( (REV_MTH_ORIG_BILL >= :WS-START-REV-MONTH)      
                        OR (REV_MTH_ORIG_BILL = 0                       
                              AND REVENUE_MONTH >= :WS-START-REV-MONTH))
T34990           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     07730000
MFA-TR*         DECLARE BI_BG_EPP CURSOR FOR                            07740000
MFA-TR*         SELECT                                                  07750000
MFA-TR*            BG.BILL_NO,                                          07760000
MFA-TR*            CODE_UTIL_TYPE,                                      07770000
MFA-TR*            IC_NO,                                               07780000
MFA-TR*            BILL_ITEM_TIMESTMP,                                  07790000
MFA-TR*            CODE_REVENUE_CLASS,                                  07800000
MFA-TR*            RATE_PLAN_NO,                                        07810000
MFA-TR*            REV_MTH_ORIG_BILL,                                   07820000
MFA-TR*            REVENUE_MONTH,                                       07830000
MFA-TR*            GAS_BASE_USE,                                        07840000
MFA-TR*            WNA_FACTOR,                                          07850000
MFA-TR*            BTU_FACTOR,                                          07860000
MFA-TR*            AMT_BILL_ITEM,                                       07870000
MFA-TR*            AMT_STATE_TAX,                                       07880000
MFA-TR*            AMT_CITY_TAX,                                        07890000
MFA-TR*            PRORATE_CD                                           07900000
MFA-TR*         FROM CSS_BILLING_HDR BI,                                07910000
MFA-TR*              CSS_BILLING_DET BG                                 07920000
MFA-TR*         WHERE BG.ACCOUNT_NO   = :BG-ACCOUNT-NO                  07930000
MFA-TR*           AND BI.ACCOUNT_NO   = BG.ACCOUNT_NO                   07940000
MFA-TR*           AND BI.BILL_NO      = BG.BILL_NO                      07950000
MFA-TR*           AND CODE_BILL_ITM_TYPE = 'C'                          07960000
MFA-TR*           AND CODE_BILL_ITM_IND  = 'A'                          07970000
MFA-TR*           AND CODE_BILL_CALC     = 'A'                          07970000
MFA-TR*           AND ( (REV_MTH_ORIG_BILL >= :WS-START-REV-MONTH)      07980000
MFA-TR*                 OR (REV_MTH_ORIG_BILL = 0                       07990000
MFA-TR*                       AND REVENUE_MONTH >= :WS-START-REV-MONTH))08000000
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      /                                                                 08020000
           EXEC SQL                                                     
                DECLARE CNSMPTN_HIST CURSOR FOR                         
                SELECT                                                  
                     ACCOUNT_NO,                                        
                     BILL_NO,                                           
                     CODE_UTIL_TYPE,                                    
                     IC_NO,                                             
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                                
                     CODE_TIME_PERIOD,                                  
                     MTR_REF_NO,                                        
                     CODE_USAGE_TYPE,                                   
                     CODE_USAGE_ID,                                     
                     CODE_USAGE_SOURCE,                                 
                     ITEM_SEQ_NO,                                       
                     METER_NO,                                          
                     REG_ID_NO,                                         
                     DATE_READ,                                         
                     CODE_METER_READ,                                   
                     CODE_METER_NO_READ,                                
                     METER_READING,                                     
                     DEMAND_READING,                                    
                     EMPLOYEE_NO,                                       
                     NO_UNITS,                                          
                     NO_DEMAND_UNITS,                                   
                     NO_DAYS,                                           
                     CODE_SOURCE_ID,                                    
                     CODE_DEBIT_CREDIT,                                 
                     CODE_ITEM_STATUS,                                  
                     CODE_DISCOUNT,                                     
                     CONSTANT,                                          
                     NO_DIALS,                                          
                     COMPANY_NO,                                        
                     EXCEPT_OVERRIDE_CD,                                
                     REQUESTED_USAGE,                                   
                     DIGTL_INTRL_MTR_NO,                                
                     DIGTL_MTR_TYPE,                                    
                     CODE_TOU_SEASN,                                    
                     EXCL_DMD_RCHT_IND                                  
                FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO     = :CX-ACCOUNT-NO                   
                  AND BILL_NO        = :CX-BILL-NO                      
                  AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE               
                  AND IC_NO          = :CX-IC-NO                        
                  AND BILL_ITEM_TIMESTMP                                
                                     = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )           
T34990           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08030000
MFA-TR*         DECLARE CNSMPTN_HIST CURSOR FOR                         08040000
MFA-TR*         SELECT                                                  08050000
MFA-TR*              ACCOUNT_NO,                                        08060000
MFA-TR*              BILL_NO,                                           08070000
MFA-TR*              CODE_UTIL_TYPE,                                    08080000
MFA-TR*              IC_NO,                                             08090000
MFA-TR*              BILL_ITEM_TIMESTMP,                                08100000
MFA-TR*              CODE_TIME_PERIOD,                                  08110000
MFA-TR*              MTR_REF_NO,                                        08120000
MFA-TR*              CODE_USAGE_TYPE,                                   08130000
MFA-TR*              CODE_USAGE_ID,                                     08140000
MFA-TR*              CODE_USAGE_SOURCE,                                 08150000
MFA-TR*              ITEM_SEQ_NO,                                       08160000
MFA-TR*              METER_NO,                                          08170000
MFA-TR*              REG_ID_NO,                                         08180000
MFA-TR*              DATE_READ,                                         08190000
MFA-TR*              CODE_METER_READ,                                   08200000
MFA-TR*              CODE_METER_NO_READ,                                08210000
MFA-TR*              METER_READING,                                     08220000
MFA-TR*              DEMAND_READING,                                    08230000
MFA-TR*              EMPLOYEE_NO,                                       08240000
MFA-TR*              NO_UNITS,                                          08250000
MFA-TR*              NO_DEMAND_UNITS,                                   08260000
MFA-TR*              NO_DAYS,                                           08270000
MFA-TR*              CODE_SOURCE_ID,                                    08280000
MFA-TR*              CODE_DEBIT_CREDIT,                                 08290000
MFA-TR*              CODE_ITEM_STATUS,                                  08300000
MFA-TR*              CODE_DISCOUNT,                                     08310000
MFA-TR*              CONSTANT,                                          08320000
MFA-TR*              NO_DIALS,                                          08330000
MFA-TR*              COMPANY_NO,                                        08340000
MFA-TR*              EXCEPT_OVERRIDE_CD,                                08350000
MFA-TR*              REQUESTED_USAGE,                                   08360000
MFA-TR*              DIGTL_INTRL_MTR_NO,                                08370000
MFA-TR*              DIGTL_MTR_TYPE,                                    08380000
MFA-TR*              CODE_TOU_SEASN,                                    08390000
MFA-TR*              EXCL_DMD_RCHT_IND                                  08400000
MFA-TR*         FROM CSS_CNSMPTN_HIST                                   08410000
MFA-TR*         WHERE ACCOUNT_NO     = :CX-ACCOUNT-NO                   08420000
MFA-TR*           AND BILL_NO        = :CX-BILL-NO                      08430000
MFA-TR*           AND CODE_UTIL_TYPE = :CX-CODE-UTIL-TYPE               08440000
MFA-TR*           AND IC_NO          = :CX-IC-NO                        08450000
MFA-TR*           AND BILL_ITEM_TIMESTMP                                08460000
MFA-TR*                              = :CX-BILL-ITEM-TIMESTMP           08470000
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                    08480000
      /                                                                 08490000
           EXEC SQL                                                     
                DECLARE UM_CNSMPT_HIST CURSOR FOR                       
                SELECT                                                  
                     ACCOUNT_NO,                                        
                     BILL_NO,                                           
                     CODE_UTIL_TYPE,                                    
                     IC_NO,                                             
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                                
                     RATE_ITEM_CODE,                                    
                     ITEM_SEQ_NO,                                       
                     NO_UNITS,                                          
                     NO_DAYS,                                           
                     CODE_DEBIT_CREDIT,                                 
                     USAGE_FIXED,                                       
                     DATE_USAGE_ENDS,                                   
                     CODE_SERVICE_TYPE,                                 
                     CODE_ITEM_STATUS,                                  
                     CODE_SOURCE_ID,                                    
                     MTHLY_AMOUNT_FIXED,                                
                     DIST_NO,                                           
                     LIGHT_NO,                                          
                     POLE_NO                                            
                FROM CSS_UM_CNSMPT_HIST WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO     = :UC-ACCOUNT-NO                   
                  AND BILL_NO        = :UC-BILL-NO                      
                  AND CODE_UTIL_TYPE = :UC-CODE-UTIL-TYPE               
                  AND IC_NO          = :UC-IC-NO                        
                  AND BILL_ITEM_TIMESTMP                                
                                     = CIS.CHAR2TIMESTAMP(
                                                 :UC-BILL-ITEM-TIMESTMP
              )           
T34990           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08500000
MFA-TR*         DECLARE UM_CNSMPT_HIST CURSOR FOR                       08510000
MFA-TR*         SELECT                                                  08520000
MFA-TR*              ACCOUNT_NO,                                        08530000
MFA-TR*              BILL_NO,                                           08540000
MFA-TR*              CODE_UTIL_TYPE,                                    08550000
MFA-TR*              IC_NO,                                             08560000
MFA-TR*              BILL_ITEM_TIMESTMP,                                08570000
MFA-TR*              RATE_ITEM_CODE,                                    08580000
MFA-TR*              ITEM_SEQ_NO,                                       08590000
MFA-TR*              NO_UNITS,                                          08600000
MFA-TR*              NO_DAYS,                                           08610000
MFA-TR*              CODE_DEBIT_CREDIT,                                 08620000
MFA-TR*              USAGE_FIXED,                                       08630000
MFA-TR*              DATE_USAGE_ENDS,                                   08640000
MFA-TR*              CODE_SERVICE_TYPE,                                 08650000
MFA-TR*              CODE_ITEM_STATUS,                                  08660000
MFA-TR*              CODE_SOURCE_ID,                                    08670000
MFA-TR*              MTHLY_AMOUNT_FIXED,                                08680000
MFA-TR*              DIST_NO,                                           08690000
MFA-TR*              LIGHT_NO,                                          08700000
MFA-TR*              POLE_NO                                            08710000
MFA-TR*         FROM CSS_UM_CNSMPT_HIST                                 08720000
MFA-TR*         WHERE ACCOUNT_NO     = :UC-ACCOUNT-NO                   08730000
MFA-TR*           AND BILL_NO        = :UC-BILL-NO                      08740000
MFA-TR*           AND CODE_UTIL_TYPE = :UC-CODE-UTIL-TYPE               08750000
MFA-TR*           AND IC_NO          = :UC-IC-NO                        08760000
MFA-TR*           AND BILL_ITEM_TIMESTMP                                08770000
MFA-TR*                              = :UC-BILL-ITEM-TIMESTMP           08780000
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                    08790000
      /                                                                 08800000
T34569* ADD RT_PKG_OPT_SEQ_NO TO THE PRIOR_RATE CURSOR                          
           EXEC SQL                                                     
               DECLARE PRIOR_RATE CURSOR FOR                            
                  SELECT RATE_PLAN_NO, RT_PKG_OPT_SEQ_NO,               
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                             
                  FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED),                
                       CSS_BILLING_DET BG WITH(READUNCOMMITTED)                 
                  WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO                  
                    AND BG.ACCOUNT_NO = BI.ACCOUNT_NO                   
                    AND BG.BILL_NO = BI.BILL_NO                         
                    AND BG.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE          
                    AND BG.IC_NO = :BG-IC-NO                            
                    AND CODE_BILL_ITM_TYPE = 'C'                        
                    AND CODE_BILL_ITM_IND  = 'A'                        
                    AND ((BG.DATE_ORIG_BILL IS NULL                     
                             AND BI.DATE_BILLED = IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) ))      
                          OR BG.DATE_ORIG_BILL = IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) ))       
              ORDER BY BG.BILL_ITEM_TIMESTMP DESC                       
T34990        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08810000
MFA-TR*        DECLARE PRIOR_RATE CURSOR FOR                            08820000
MFA-TR*           SELECT RATE_PLAN_NO, RT_PKG_OPT_SEQ_NO,               08830000
MFA-TR*                  BILL_ITEM_TIMESTMP                             08840000
MFA-TR*           FROM CSS_BILLING_HDR BI,                              08850000
MFA-TR*                CSS_BILLING_DET BG                               08860000
MFA-TR*           WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO                  08870000
MFA-TR*             AND BG.ACCOUNT_NO = BI.ACCOUNT_NO                   08880000
MFA-TR*             AND BG.BILL_NO = BI.BILL_NO                         08890000
MFA-TR*             AND BG.CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE          08900000
MFA-TR*             AND BG.IC_NO = :BG-IC-NO                            08910000
MFA-TR*             AND CODE_BILL_ITM_TYPE = 'C'                        08920000
MFA-TR*             AND CODE_BILL_ITM_IND  = 'A'                        08930000
MFA-TR*             AND ((BG.DATE_ORIG_BILL IS NULL                     08940000
MFA-TR*                      AND BI.DATE_BILLED = :BI-DATE-BILLED)      08950000
MFA-TR*                   OR BG.DATE_ORIG_BILL = :BI-DATE-BILLED)       08960000
MFA-TR*       ORDER BY BG.BILL_ITEM_TIMESTMP DESC                       08970000
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    08980000
      /                                                                 08990000
      /                                                                 09100000
T21087     EXEC SQL                                                     
T21087         DECLARE VALID_REV_MTHS CURSOR FOR                        
T21087            SELECT DISTINCT REVENUE_MONTH                         
T21087              FROM CSS_BILLING_DET                                
T21087             WHERE ACCOUNT_NO = :BG-ACCOUNT-NO                    
T24685               AND REVENUE_MONTH < :BG-REVENUE-MONTH              
ACT134               AND REVENUE_MONTH > 0                              
T21087             ORDER BY REVENUE_MONTH DESC                          
T21087     END-EXEC.                                                    
                                                                        
      /                                                                 09200000
T28606     EXEC SQL                                                     
T28606         DECLARE EPP_CHG_CHK CURSOR FOR                           
T28606          SELECT AMT_MO_PYMT                                      
T28606            FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                    
T28606           WHERE ACCOUNT_NO          = :BH-ACCOUNT-NO             
T28606             AND PYMT_PRIORITY_LVL   = :BH-PYMT-PRIORITY-LVL      
T28606             AND ITEM_ID             = :BH-ITEM-ID                
T28606             AND BUD_HIST_SEQ_NO     > CIS.CHAR2TIMESTAMP(
                                                    :BH-BUD-HIST-SEQ-NO
              )        
T28606             AND AMT_MO_PYMT         > 0                          
T28606             AND CHANGE_REASON       IN ( 'C' , 'M' )             
T34990           FOR READ ONLY                                  
T28606     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09110000
MFA-TR*        DECLARE EPP_CHG_CHK CURSOR FOR                           09120000
MFA-TR*         SELECT AMT_MO_PYMT                                              
MFA-TR*           FROM CSS_BUDGET_HIST                                          
MFA-TR*          WHERE ACCOUNT_NO          = :BH-ACCOUNT-NO                     
MFA-TR*            AND PYMT_PRIORITY_LVL   = :BH-PYMT-PRIORITY-LVL              
MFA-TR*            AND ITEM_ID             = :BH-ITEM-ID                        
MFA-TR*            AND BUD_HIST_SEQ_NO     > :BH-BUD-HIST-SEQ-NO                
MFA-TR*            AND AMT_MO_PYMT         > 0                                  
MFA-TR*            AND CHANGE_REASON       IN ( 'C' , 'M' )                     
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                    09110000
      /                                                                 09220000
       LINKAGE SECTION.                                                 
      /****** CWS00024 CONTAINS COMMON SUBROUTINE DATA (24B-TEMP)       09220000
       COPY CWS0024B.                                                   09230000
      /****** CWS10000 CONTAINS BE00 RECORD LAYOUTS                     09240000
PERF   COPY CWS1000A.                                                   09250000
PERF   COPY CWS1000B.                                                   09260000
      /****** CWS10001 CONTAINS BE01 RECORD LAYOUTS                     09270000
PERF   COPY CWS1001A.                                                   09280000
PERF   COPY CWS1001B.                                                   09290000
                                                                        
T10082/*****   GL-NUMBERS TABLE                                         09310000
T10082 COPY CWS00061.                                                   09320000
      /                                                                 09330000
T10082 01  WS-HOLD-WK03.                                                
COB305     03 WS-WK03-TOTAL-AR-BAL        PIC S9(9)V99 COMP-3 VALUE 0.        
T10082     03  WS-WK03-COUNT                PIC S9(4) COMP.             
T10082     03  WS-HOLD-WK03-DATA            PIC X(220)                  
T13536            OCCURS 5000 TIMES                                     
T10082            INDEXED BY WK03-INDX.                                 
T17777                                                                  
COB305 01 WS-HOLD-AMT-POSTED        PIC S9(09)V99 COMP-3 VALUE 0.       
T17883 01  WS-CALC-EPP-ANNIV-FLG            PIC X(01).                  
       PROCEDURE DIVISION USING LS-PCSCA100-COMM-AREA                   
                                WS-PREMISE-PR                           
                                WS-CUSTOMER-CU                          
                                WS-ACCOUNT-AT                           
                                WS-BILLING-BI                           
                                WS-BILLING-BG                           
                                WS-BILL-CALC-DETAIL                     
                                WS-BILL-ADJUST-DETAIL                   
                                WS-CNSMPTN-HIST-CX                      
                                WS-UNMTRD-CNSMPTN-UC                    
                                WS-FIXED-FCTR-HIST-FH                   
                                WS-BILL-CONTRACT-BK                     
                                WS-CUST-PLAN-TABLE-CP                   
                                WS-FIXED-FCTR-TABLE-FF                  
                                WS-BILL-CNTR-HIST-BX                    
                                WS-AR-CNTRL-AC                          
                                WS-BUDGET-PLAN-BU                       
                                WS-PEAK-HIST-PH                         
                                WS-INTERRUPT-ACCT-IP                    
                                WS-INTERRUPT-IR                         
                                WS-UTILITY-TABLE-UT                     
                                WS-REGISTER-READ-TABLE-RG               
                                WS-MTRD-ENVRNMT-TABLE-MN                
                                WS-MTR-CAP-TABLE-MC                     
                                WS-BILLING-WQ-ITEMS-WF                  
                                WS-12-MONTH-DATA-EPP                    
                                WS-STANDBY-GEN-SE                       
                                WS-REFUND-RN                            
T10082                          WS-GL-NAME-INFO                         
T10082                          WS-GL-ACCT-NO-TABLE                     
T10082                          WS-HOLD-WK03                            
T17777                          WS-HOLD-AMT-POSTED                      
T17883                          WS-CALC-EPP-ANNIV-FLG                   
C34569                          WS-ACCT-RTPK-AGR-DF                     
C34569                          WS-BI-FIXED-FCTR-FF                     
C34569                          WS-BILL-DET-BT                          
C34569                          WS-BILL-ADJUSTMNT                       
I00177                          WS-CWS1000B-MAX-TBL-LIMITS              
I00177                          WS-CWS1001B-MAX-TBL-LIMITS              
P00496                          WS-BILL-BSLN-CNTR-LN                    
P00496                          WS-BILL-BSLN-HIST-LO                    
P00496                          WS-UTL-BILL-REL-TABLE-UR                
VKSACT                          WS-INTERRUPT-NZ                         
P00496                          WS-CNSMPTN-HOURLY.                      

SCA006        SET WS-BDET-INDX TO 1.
SCA006        SET WS-RTPK-INDX TO 1.
      *                                                                 09770000
HPCCDM*    EJECT                                                        09780000
      /********************************************************         09790000
      *    0000-MAINLINE                                      *         09810000
C26130* IF ACCOUNT IS NOT CURRENTLY                           *         09810100
C26130* ON EPP AND WS-CODE-EPP-OFFER IS SET, THEN AUTOMATIC   *         09810200
C26130* EPP OFFER IS BEING GIVEN.                             *         09811000
      *********************************************************         09830000
       0000-MAINLINE.                                                   
           MOVE ZERO TO RETURN-CODE                                     
C34569                  WS-DUMMY-MTH-CTR.                               
I00177     INITIALIZE WS-SQL-ERROR-TXT-WQ.                              
ACT284     SET WS-GL-SUB  TO 1                                          
ACT332     SET WS-BDET-INDX TO 1.                                       
T17335*****IF LS-CURR-REV NOT POPULATED - USE COMMON DATE AS BACKUP     09860000
T17335     IF LS-CURR-REVENUE-MONTH NOT NUMERIC                         
              MOVE LS-INPUT-DATE          TO  WS-REV-CCYYMM-TEMP        
           ELSE                                                         
T17335        MOVE LS-CURR-REVENUE-MONTH  TO  WS-REV-CCYYMM-TEMP        
           END-IF.                                                      
T17335     MOVE WS-REV-CCYY-TEMP        TO  WS-BH-DATE-CCYYY            
P00307                                      WS-BBP-MSG-DATE-CCYY        
P00307                                      WS-MON-DATE-CCYY.           
T17335     MOVE WS-REV-MM-TEMP          TO  WS-BH-DATE-MM               
P00307                                      WS-BBP-MSG-DATE-MM          
P00307                                      WS-MON-DATE-MM.             
                                                                        
C34569     MOVE WS-REV-CCYY-TEMP        TO  WS-REV-DATE-CCYYY.          
C34569     MOVE WS-REV-MM-TEMP          TO  WS-REV-DATE-MM.             
                                                                        
           PERFORM 0500-INITIALIZE               THRU 0500-EXIT.        
                                                                        
C23501     MOVE WS-COMPANY-NO-AT   TO  C8-COMPANY-NO.                   
C26164     IF  CSR-DATABASE AND C8-COMPANY-NO = '01'                    
P00694         MOVE 'PCT-RESRATEINCR-ELEC' TO C8-DELINQ-CD              
C26164         PERFORM 7540-SELECT-SCEG-RATE-PCT THRU 7540-EXIT         
P00694         MOVE C8-DELINQ-VALUE TO WS-PCT-RESRATEINCR-ELEC          
C26164         DIVIDE 100 INTO WS-PCT-RESRATEINCR-ELEC                  
C26164              ON SIZE ERROR                                       
C26164                MOVE 0 TO WS-PCT-RESRATEINCR-ELEC                 
C26164         END-DIVIDE                                               
                                                                        
P00694         MOVE 'PCT-COMRATEINCR-ELEC' TO C8-DELINQ-CD              
P00694         PERFORM 7540-SELECT-SCEG-RATE-PCT THRU 7540-EXIT         
P00694         MOVE C8-DELINQ-VALUE TO WS-PCT-COMRATEINCR-ELEC          
P00694         DIVIDE 100 INTO WS-PCT-COMRATEINCR-ELEC                  
P00694              ON SIZE ERROR                                       
P00694                MOVE 0 TO WS-PCT-COMRATEINCR-ELEC                 
P00694         END-DIVIDE                                               
                                                                        
P00694         MOVE 'PCT-COMRATEINCR-GAS' TO  C8-DELINQ-CD              
P00694         PERFORM 7540-SELECT-SCEG-RATE-PCT THRU 7540-EXIT         
P00694         MOVE C8-DELINQ-VALUE TO WS-PCT-COMRATEINCR-GAS           
P00694         DIVIDE 100 INTO WS-PCT-COMRATEINCR-GAS                   
P00694              ON SIZE ERROR                                       
P00694                MOVE 0 TO WS-PCT-COMRATEINCR-GAS                  
P00694         END-DIVIDE                                               
                                                                        
P00694         MOVE 'PCT-RESRATEINCR-GAS' TO  C8-DELINQ-CD              
P00694         PERFORM 7540-SELECT-SCEG-RATE-PCT THRU 7540-EXIT         
P00694         MOVE C8-DELINQ-VALUE TO WS-PCT-RESRATEINCR-GAS           
P00694         DIVIDE 100 INTO WS-PCT-RESRATEINCR-GAS                   
P00694              ON SIZE ERROR                                       
P00694                MOVE 0 TO WS-PCT-RESRATEINCR-GAS                  
P00694         END-DIVIDE                                               
P00694     ELSE                                                         
T31866         MOVE 'PCT-ESTRATEINCR-GAS' TO WS-DELINQ-CD-VALUE         
T8752          PERFORM 7550-SELECT-RATE-PERCENT      THRU 7550-EXIT     
C26164         DIVIDE 100 INTO WS-PCT-ESTRATEINCR-GAS                   
C26164             ON SIZE ERROR                                        
C26164           MOVE 0 TO WS-PCT-ESTRATEINCR-GAS                       
C26164         END-DIVIDE                                               
C26164     END-IF.                                                      
           IF WS-CODE-BUDGET = 'A'                                      
P00307        MOVE WS-AMT-MO-PYMT-BU TO WS-BBP-HOLD-OLD-AMT             
              PERFORM 0100-CHECK-EPP-ACCOUNT     THRU 0100-EXIT         
           ELSE                                                         
C26130        IF WS-CODE-EPP-OFFER = 'A'                                
P00307           MOVE ZERO           TO WS-BBP-HOLD-OLD-AMT             
C26130           PERFORM 4000-EPP-OFFER          THRU 4000-EXIT         
C26130        END-IF                                                    
           END-IF.                                                      
TP3355     MOVE WS-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT-AT.      
           EXIT PROGRAM.                                                
                                                                        
      ****************************************************************  10440000
      **    0100-CHECK-EPP-ACCOUNT.                                 **  10450000
      ** THIS PROCEDURE WILL PERFORM CHECK TO SEE WHAT TYPE OF      **  10460000
      ** PROCESSING NEEDS TO OCCUR FOR AN EXISTING EPP ACCOUNT.     **  10470000
      **                                                            **  10480000
      ****************************************************************  10490000
       0100-CHECK-EPP-ACCOUNT.                                          
           SET WS-AR-DATA-INDX TO 1                                     
           SEARCH WS-AR-DATA                                            
              AT END                                                    
                 MOVE WS-NO-BUDGET-AC TO WS-WORK-MESSAGE                
                 PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT          
              WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 50       
                      AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 1           
                 SET WS-HOLD-BUDGET-INDX TO WS-AR-DATA-INDX             
                                                                        
T17883           IF WS-CALC-EPP-ANNIV-FLG = 'Y'                         
                    PERFORM 2000-ANNUAL-RECALCULATION  THRU 2000-EXIT   
                    SET ANNUAL-RECALC-COMPLETE TO TRUE                  
                 END-IF                                                 
                                                                        
TP6269           IF ANNUAL-RECALC-NOT-DONE                              
TP6269                 AND RATE-TARIFF-CHANGE-NOT-DONE                  
TP6269              PERFORM 1000-MONTHLY-MONITORING    THRU 1000-EXIT   
TP6269           END-IF                                                 
T23452*                                                                         
T23452           MOVE ZEROS                        TO WS-BH-REV-MNTH    
T23452           MOVE WS-ACCOUNT-NO-AT             TO BH-ACCOUNT-NO     
T23452           PERFORM 7760-SELECT-BUDGET-HIST       THRU 7760-EXIT   
T23452           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
T23452              MOVE BH-DATE-PYMT-STRT(1:4)    TO                   
T23452                   WS-BH-REV-MNTH(1:4)                            
T23452              MOVE BH-DATE-PYMT-STRT(6:2)    TO                   
T23452                   WS-BH-REV-MNTH(5:2)                            
T23452           END-IF                                                 
T23452                                                                  
T20178*    DETERMINE IF THERE HAS BEEN A C/R                            11030000
T20178           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1            
T20178                    UNTIL WS-BILLING-INDX > 30                    
T20178                     OR WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = ZERO 
T20178             IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) > 0        
T20178              OR WS-ADJ-REASON-CD-BG (WS-BILLING-INDX) > SPACES   
T20178              OR WS-CODE-BILL-CALC-BG (WS-BILLING-INDX) NOT = 'A' 
T20178               SET WS-BILL-CORRECTION TO TRUE                     
T20178             END-IF                                               
T20178           END-PERFORM                                            
T23452*                                                                         
T23452           IF  WS-BH-REV-MNTH > WS-REV-CCYYMM-TEMP                
T23452               IF  WS-BILL-CORRECTION                             
T23452                   MOVE ZEROS TO WS-ACCOUNT-NO-BU                 
T23452               END-IF                                             
T23452           END-IF                                                 
T23452*                                                                         
TP3442           IF ANNUAL-RECALC-COMPLETE                              
T20178              IF WS-CODE-BILL-PEND-AT = 'A' AND                   
T20178                 WS-CANCEL-REBILL-FLAG = 'Y'                      
T20178                CONTINUE                                          
T20178              ELSE                                                
TP3442                MOVE WS-ANNIVERSARY-DATE-BU TO WS-WORK-DATE       
TP3442                ADD 1 TO WS-WORK-DATE-MM                          
TP3442                IF WS-WORK-DATE-MM > 12                           
TP3442                   MOVE 1 TO WS-WORK-DATE-MM                      
TP3442                   ADD 1 TO WS-WORK-DATE-CCYY                     
TP3442                END-IF                                            
TP3442                MOVE WS-WORK-DATE-CCYY TO                         
TP3442                                    WS-DATE-PYMT-STRT-BU(1:4)     
TP3442                MOVE WS-WORK-DATE-MM TO WS-DATE-PYMT-STRT-BU(6:2) 
TP3442                MOVE WS-ANNIVERSARY-DATE-BU TO WS-WORK-DATE       
TP3442                ADD 1 TO WS-WORK-DATE-CCYY                        
TP3442                MOVE WS-WORK-DATE TO WS-ANNIVERSARY-DATE-BU       
TP3442              END-IF                                              
TP3441******************************************************************11310000
TP3441* INSERT ROW INTO CSS_BUDGET_HIST FOR EPP ANNIVERSARY CALCULATION*11320000
TP3441******************************************************************11330000
TP3441              MOVE WS-ACCOUNT-NO-AT  TO BH-ACCOUNT-NO             
TP3441              MOVE 50                TO BH-PYMT-PRIORITY-LVL      
TP3441              MOVE 1                 TO BH-ITEM-ID                
TP3441              MOVE WS-AMT-MO-PYMT-BU TO BH-AMT-MO-PYMT            
P00307              MOVE WS-BBP-HOLD-OLD-AMT                            
P00307                                     TO BH-BUDG-BILL-PREV-AMT     
                    MOVE WS-DATE-PYMT-STRT-BU                           
TP3441                                     TO BH-DATE-PYMT-STRT         
TP3441              MOVE WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)       
TP3441                                     TO BH-UTILITY-BALANCE        
TP3441              MOVE WS-AMT-MO-PMT-NEW-BAL-FWD-CALC                 
TP3441                                     TO BH-BALANCE-FORWARD        
T19278              MOVE +1                TO BH-EPP-MTHS-RMNG-QT       
T8752               COMPUTE BH-EPP-ESTIMATE ROUNDED = EPP-FINAL-TOTAL   
TP3441              MOVE WS-A              TO BH-CHANGE-REASON          
C26164              IF  CSR-DATABASE AND C8-COMPANY-NO = '01'           
C26164                  IF  WS-ELEC-SW = 'Y' AND WS-GAS-SW = 'Y'        
C26164                      STRING 'BUFFER FACTOR ELEC: '               
C26164                      DELIMITED BY SIZE                           
C26164                         WS-ELEC-BUFFER   DELIMITED BY SIZE       
C26164                         ' GAS: '         DELIMITED BY SIZE       
C26164                         WS-GAS-BUFFER    DELIMITED BY SIZE       
C26164                      INTO BH-REMARKS-TEXT                        
C26164                      MOVE +40                 TO BH-REMARKS-LEN  
C26164                  ELSE                                            
C26164                      IF  WS-ELEC-SW = 'Y'                        
C26164                          STRING 'BUFFER FACTOR ELEC: '           
C26164                          DELIMITED BY SIZE                       
C26164                          WS-ELEC-BUFFER     DELIMITED BY SIZE    
C26164                          INTO BH-REMARKS-TEXT                    
C26164                          MOVE +27             TO BH-REMARKS-LEN  
C26164                      ELSE                                        
C26164                          IF  WS-GAS-SW = 'Y'                     
C26164                              STRING 'BUFFER FACTOR GAS: '        
C26164                              DELIMITED BY SIZE                   
C26164                              WS-GAS-BUFFER   DELIMITED BY SIZE   
C26164                              INTO BH-REMARKS-TEXT                
C26164                              MOVE +26        TO BH-REMARKS-LEN   
C26164                          END-IF                                  
C26164                      END-IF                                      
C26164                  END-IF                                          
C26164              ELSE                                                
P00694                 IF CSR-DATABASE AND C8-COMPANY-NO = '26'         
C26164                    STRING 'BUFFER FACTOR GAS: ' DELIMITED BY SIZE
C26164                           WS-GAS-BUFFER         DELIMITED BY SIZE
C26164                      INTO BH-REMARKS-TEXT                        
C26164                    MOVE +26                 TO BH-REMARKS-LEN    
P00694                 ELSE                                             
C26164                    STRING 'BUFFER FACTOR GAS: ' DELIMITED BY SIZE
C26164                           WS-GAS-BUFFER         DELIMITED BY SIZE
P00694                           ' PRICE :'            DELIMITED BY SIZE
P00694                           WS-BBP-ANNIV-PRICE-DISP                
P00694                                                 DELIMITED BY SIZE
P00694                           ' CSC AMT :'          DELIMITED BY SIZE
P00694                           WS-BBP-CSC-AMT-DISP                    
P00694                                                 DELIMITED BY SIZE
C26164                      INTO BH-REMARKS-TEXT                        
C26164                    MOVE +58                 TO BH-REMARKS-LEN    
P00694                 END-IF                                           
C26164              END-IF                                              
P00307              PERFORM 7950-GET-TIMESTAMP THRU 7950-EXIT           
P00307              MOVE CURRENT-TIMESTAMP TO BH-BUD-HIST-SEQ-NO        
P00694              MOVE 'SYSTEM'          TO BH-LAST-UPDATE-USERID     
A02036              IF LS-DATABASE-UPDATES = 'YES'                      
TP3441               PERFORM 8100-INSERT-BUDGET-HIST THRU 8100-EXIT     
A02036              END-IF                                              
TP3442           END-IF                                                 
           END-SEARCH.                                                  
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /***************************************************************  12270000
      **    0500-INITIALIZE.                                        **  12280000
      ** THIS PROCEDURE WILL INITIALIZE FIELDS.                     **  12290000
      **                                                            **  12300000
      ****************************************************************  12310000
       0500-INITIALIZE.                                                 
           INITIALIZE WS-WORK-VARIABLES                                 
                      WS-HOLD-BILL-DATA.                                
           SET RATE-TARIFF-CHANGE-NOT-DONE                              
               WS-WQ-MESSAGE-NOT-SET                                    
C26130         ANNUAL-RECALC-NOT-DONE        TO TRUE                    
           MOVE WS-CODES-DATA-PRESENT-AT  TO WS-CODES-DATA-PRESENT.     
T16339     MOVE 'N' TO WS-ROW-EXISTS.                                   
T16339     MOVE 'N' TO WS-START-UP-EXISTS.                              
                                                                        
      ** GET LATEST STARTING REVENUE MONTH FROM BILL DETAIL ARRAY       12750000
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1                  
                   UNTIL WS-BILLING-INDX > 30                           
                      OR WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = ZERO      
              IF WS-REVENUE-MONTH-BG (WS-BILLING-INDX) >                
                    WS-BD-REVENUE-MONTH (1)                             
                 MOVE WS-REVENUE-MONTH-BG (WS-BILLING-INDX)             
                   TO WS-BD-REVENUE-MONTH (1)                           
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
      ** BACKFILL PAST 11 REVENUE MONTHS                                12860000
T21807     MOVE WS-ACCOUNT-NO-AT TO BG-ACCOUNT-NO                       
T24685     MOVE WS-BD-REVENUE-MONTH (1)  TO BG-REVENUE-MONTH            
T21807     PERFORM 0510-OPEN-VALID-REV-MTHS THRU 0510-EXIT              
           PERFORM VARYING WS-RM-INDX FROM 2 BY 1                       
                     UNTIL WS-RM-INDX > 12                              
T21807        PERFORM 0515-FETCH-VALID-REV-MTHS THRU 0515-EXIT          
              IF SQLCODE = SUCCESSFUL-CALL                              
T21807           MOVE BG-REVENUE-MONTH                                  
T21807             TO WS-BD-REVENUE-MONTH (WS-RM-INDX)                  
T21807           IF WS-BD-REV-MONTH (WS-RM-INDX) = ZERO                 
T21807              MOVE 12 TO WS-BD-REV-MONTH (WS-RM-INDX)             
T21807              SUBTRACT 1 FROM WS-BD-REV-YEAR (WS-RM-INDX)         
T21807           END-IF                                                 
ACT078           MOVE WS-BD-REVENUE-MONTH (WS-RM-INDX)                  
ACT078             TO WS-START-REV-MONTH                                
              END-IF                                                    
           END-PERFORM                                                  
           PERFORM 0518-CLOSE-VALID-REV-MTHS THRU 0518-EXIT             
                                                                        
      ** LOAD ACTIVE IC'S FROM UTIL ENVRNMT                             13150000
TP3505     SET WS-ICD-INDX TO 1.                                        
           PERFORM VARYING WS-UTIL-INDX FROM 1 BY 1                     
                   UNTIL WS-UTIL-INDX > 40                              
                      OR WS-ICD-INDX > 4                                
                      OR WS-ACCOUNT-NO-UT (WS-UTIL-INDX) = ZERO         
              SET WS-ICD-INDX TO WS-UTIL-INDX                           
              IF WS-ICD-INDX > 4                                        
KDFKDF           DISPLAY 'WS-TOO-MANY-ICS '                             
                 MOVE WS-TOO-MANY-ICS TO  WS-WORK-MESSAGE               
                 PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT          
              ELSE                                                      
                 MOVE WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX)               
                   TO WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX)               
                 MOVE WS-IC-NO-UT (WS-UTIL-INDX)                        
                   TO WS-ICD-IC-NO (WS-ICD-INDX)                        
                 MOVE WS-RATE-PLAN-NO-UT (WS-UTIL-INDX)                 
                   TO WS-ICD-RATE-PLAN-NO (WS-ICD-INDX)                 
                 MOVE WS-CODE-REVENUE-CLASS-UT (WS-UTIL-INDX)           
                   TO WS-ICD-CODE-REVENUE-CLASS (WS-ICD-INDX)           
C22796           MOVE WS-CODE-CURTAIL-PRTY-UT (WS-UTIL-INDX)            
C22796             TO WS-ICD-CODE-CURTAIL-PRTY (WS-ICD-INDX)            
RODFIX           MOVE WS-RT-PKG-OPT-SEQ-NO-UT (WS-UTIL-INDX)            
RODFIX             TO WS-ICD-RT-PKG-OPT-SEQ-NO (WS-ICD-INDX)            
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
      /*******************************************************          13420000
      * OPEN THE CURSOR FOR THE BILLING HISTORY SEARCH OF THE*          13430000
      * DATABASE TABLE: CSS_BILLING_DET.                     *          13440000
      ********************************************************          13450000
T21087 0510-OPEN-VALID-REV-MTHS.                                        
                                                                        
T21087     EXEC SQL                                                     
T21087          OPEN VALID_REV_MTHS                                     
T21087     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21087                                                                  
T21087     IF SQLCODE NOT = SUCCESSFUL-CALL                             
T21087        MOVE 'BG'                    TO WS-DB2-TABLE-ID           
T21087        MOVE 'OPEN  '                TO WS-DB2-FUNCTION           
T21087        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
T21087        MOVE '112'                   TO WS-DB2-MODULE-ID          
T21087        MOVE '0510'                  TO WS-DB2-PARAGRAPH          
T21087        MOVE BG-ACCOUNT-NO           TO WS-DB2-KEY-1N             
T21087        MOVE BG-CODE-UTIL-TYPE       TO WS-DB2-KEY-2              
T21087        MOVE 12 TO RETURN-CODE                                    
T21087        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                
T21087                                                                  
T21087 0510-EXIT.                                                       
T21087     EXIT.                                                        
T21087                                                                  
T21087*                                                                 13660000
T21087 0515-FETCH-VALID-REV-MTHS.                                       
T21087     EXEC SQL                                                     
T21087          FETCH VALID_REV_MTHS INTO                               
T21087            :BG-REVENUE-MONTH                                     
T21087     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21087                                                                  
T21087     IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
T21087        MOVE 'BG'                 TO WS-DB2-TABLE-ID              
T21087        MOVE 'FETCH '             TO WS-DB2-FUNCTION              
T21087        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T21087        MOVE '112'                TO WS-DB2-MODULE-ID             
T21087        MOVE '0515'               TO WS-DB2-PARAGRAPH             
T21087        MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
T21087        MOVE BG-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
T21087        MOVE 12 TO RETURN-CODE                                    
T21087        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                
T21087                                                                  
T21087                                                                  
T21087 0515-EXIT.                                                       
T21087     EXIT.                                                        
T21087*                                                                 13870000
T21087 0518-CLOSE-VALID-REV-MTHS.                                       
T21087     EXEC SQL                                                     
T21087          CLOSE VALID_REV_MTHS                                    
T21087     END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
T21087                                                                  
T21087 0518-EXIT.                                                       
T21087     EXIT.                                                        
      /***************************************************************  13950000
      **    1000-MONTHLY-MONITORING.                                **  13960000
      **                                                            **  13970000
      ** ROUTINE MONITORING INCLUDES CHECKS FOR                     **  13980000
      **  1. EXCESSIVE CHANGE ACTIVITY                              **  13990000
      **  2. EXCESSIVE ACCUMULATED VARIANCE                         **  14000000
      **  3. IC-LEVEL CHANGES (NEW IC, NEW METER, NEW RATE **           14010000
      **                                                            **  14020000
      ****************************************************************  14030000
       1000-MONTHLY-MONITORING.                                         
                                                                        
T19143     PERFORM 1200-CALC-EPP-MONTHS-TO-GO THRU 1200-EXIT.           
T28606     IF WS-EPP-MONTHS-REMAINING = 4 OR 6 OR 8                     
T17241          COMPUTE WS-EPP-EXCPTN-BAL EQUAL                         
T17241                  WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) -      
T17241                  WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX) -         
T17241                  WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX) -         
T17241                  WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX) -         
T17241                  WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)           
T32040                  MOVE 'N' TO WS-MONITOR-EPP-FLAG                 
T34474          MOVE 'Y' TO WS-EPP-WQ-REQD                              
T28606          EVALUATE WS-EPP-MONTHS-REMAINING                        
T28606              WHEN 4                                              
P00694                  PERFORM 1004-MONITOR-BBP THRU 1004-EXIT         
T28606              WHEN 8                                              
P00694                  PERFORM 1008-MONITOR-BBP THRU 1008-EXIT         
T28606              WHEN 6                                              
P00694                  PERFORM 1006-MONITOR-BBP THRU 1006-EXIT         
                END-EVALUATE                                            
T28606     END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00694**---------------------------------------------------------               
P00694** BBP MONITORING AT 4 MONTHS REMAINING                                   
P00694**---------------------------------------------------------               
P00694 1004-MONITOR-BBP.                                                
T32040     MOVE 8  TO WS-NO-OF-EPP-MONTHS                               
T32040     MOVE 4  TO WS-NO-OF-MONTHS-HELD                              
T32040     MOVE 'Y' TO WS-MONITOR-EPP-FLAG                              
T32040     PERFORM 5000-LOAD-HISTORY THRU 5000-EXIT                     
T32040     IF WS-COMPLETE-468                                           
P00694        IF (CSR-DATABASE AND WS-COMPANY-NO-AT = '26') OR          
P00694            SEB-DATABASE                                          
                 PERFORM 5500-CALC-UTILITY-CHARGES   THRU 5500-EXIT     
P00694        ELSE                                                      
P00694           PERFORM 5505-GET-MON-BBP-AMT THRU 5505-EXIT            
P00694           PERFORM 5510-GET-BUFFERS     THRU 5510-EXIT            
P00694           PERFORM 5520-CALC-FINAL-BBP  THRU 5520-EXIT            
P00694        END-IF                                                    
T32040        MOVE 'N' TO WS-MONITOR-EPP-FLAG                           
P00307                                                                  
P00307*****CHECK TO SEE IF ACCOUNT IS EXEMPT FROM BBP                           
P00307        MOVE SPACE TO WS-EXEMPT-FLAG                              
P00307        MOVE WS-ACCOUNT-NO-AT      TO YP-ACCOUNT-NO               
P00307        MOVE 'BBP_REVIEW_EXEMPT'   TO YP-ATTRIBUTE-DESC           
P00307        PERFORM 7310-CHECK-EXEMPT-FLAG THRU 7310-EXIT             
P00307        IF WS-EXEMPT-FLAG = 'Y'                                   
P00307           NEXT SENTENCE                                          
P00307        END-IF                                                    
P00307                                                                  
P00307*****CHECK TO SEE IF THE ACCT HAS BEEN ADJUSTED IN THE LST 6 MTHS         
P00307        PERFORM 1070-CHECK-PREV-ADJUSTMENT THRU 1070-EXIT         
P00307        IF WS-PREV-ADJUSTMENT = 'Y'                               
P00307          NEXT SENTENCE                                           
P00307        END-IF                                                    
C36331                                                                  
P00694**----  EPP-FINAL-TOTAL INCLUDES TRANS BALANCE                            
C36331                                                                  
C36331        SUBTRACT WS-AMT-MO-PYMT-BU FROM EPP-FINAL-TOTAL           
C36331               GIVING WS-EPP-DIFF                                 
C36331        IF WS-EPP-DIFF < 0                                        
C36331           COMPUTE WS-EPP-DIFF = WS-EPP-DIFF * -1                 
C36331        END-IF                                                    
P00307        MOVE 'BBP-NO-ADJUST-LIMIT' TO C8-DELINQ-CD                
P00307        MOVE WS-COMPANY-NO-AT      TO  C8-COMPANY-NO              
P00307        PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT              
P00307        MOVE C8-DELINQ-VALUE TO WS-BBP-NOADJ-AMT                  
P00307        IF WS-EPP-DIFF <= WS-BBP-NOADJ-AMT                        
P00307           NEXT SENTENCE                                          
P00307        ELSE                                                      
C36331           MOVE EPP-FINAL-TOTAL TO WS-NEW-EPP-AMT4                
A03850           MOVE WS-AMT-MO-PYMT-BU TO WS-OLD-EPP-AMT4              
C36331           IF EPP-WQ-REQD                                         
P00307              PERFORM 1060-BBP-WQ-CHECK THRU 1060-EXIT            
P00307              IF WS-GENERATE-WQ = 'Y'                             
P00694                 AND WS-AMT-MO-PYMT-BU > 0                        
C36331                MOVE WS-EPP-BALANCE-WARNING-B                     
C36331                              TO WS-WORK-MESSAGE                  
C36331                PERFORM 5100-PROCESS-EXCEPTION THRU               
C36331                                 5100-EXIT                        
P00307              ELSE                                                
P00694                IF EPP-FINAL-TOTAL >= 0                           
P00307                   PERFORM 1050-UPDATE-BUDGET-AMT THRU            
P00307                                 1050-EXIT                        
P00694                END-IF                                            
P00307              END-IF                                              
C36331           END-IF                                                 
P00307        END-IF                                                    
T32040     ELSE                                                         
T32040         MOVE 'N' TO WS-MONITOR-EPP-FLAG                          
ACT045         IF EPP-WQ-REQD                                           
ACT045            MOVE WS-AMT-MO-PYMT-BU        TO WS-OLD-EPP-AMT-E     
ACT045            MOVE WS-NO-OF-MONTHS-HELD     TO WS-REM-EPP-MTHS-E    
ACT045            MOVE WS-EPP-BALANCE-WARNING-E TO WS-WORK-MESSAGE      
ACT045            PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT         
ACT045         END-IF                                                   
T32040     END-IF.                                                      
                                                                        
P00694 1004-EXIT.                                                       
P00694      EXIT.                                                       
                                                                        
P00694**---------------------------------------------------------               
P00694** BBP MONITORING AT 6 MONTHS REMAINING                                   
P00694**---------------------------------------------------------               
P00694 1006-MONITOR-BBP.                                                
T34459                                                                  
T32040     MOVE 6  TO WS-NO-OF-EPP-MONTHS                               
T32040     MOVE 6  TO WS-NO-OF-MONTHS-HELD                              
T32040     MOVE 'Y' TO WS-MONITOR-EPP-FLAG                              
T32040     PERFORM 5000-LOAD-HISTORY THRU 5000-EXIT                     
T32040     IF WS-COMPLETE-468                                           
P00694        IF (CSR-DATABASE AND WS-COMPANY-NO-AT = '26') OR          
P00694            SEB-DATABASE                                          
                 PERFORM 5500-CALC-UTILITY-CHARGES   THRU 5500-EXIT     
P00694        ELSE                                                      
P00694           PERFORM 5505-GET-MON-BBP-AMT THRU 5505-EXIT            
P00694           PERFORM 5510-GET-BUFFERS     THRU 5510-EXIT            
P00694           PERFORM 5520-CALC-FINAL-BBP  THRU 5520-EXIT            
P00694        END-IF                                                    
T32040        MOVE 'N' TO WS-MONITOR-EPP-FLAG                           
P00307                                                                  
P00307*****CHECK TO SEE IF ACCOUNT IS EXEMPT FROM BBP                           
P00307        MOVE SPACE TO WS-EXEMPT-FLAG                              
P00307        MOVE WS-ACCOUNT-NO-AT      TO YP-ACCOUNT-NO               
P00307        MOVE 'BBP_REVIEW_EXEMPT'   TO YP-ATTRIBUTE-DESC           
P00307        PERFORM 7310-CHECK-EXEMPT-FLAG THRU 7310-EXIT             
P00307        IF WS-EXEMPT-FLAG = 'Y'                                   
P00307           NEXT SENTENCE                                          
P00307        END-IF                                                    
P00307                                                                  
P00307*****CHECK TO SEE IF THE ACCT HAS BEEN ADJUSTED IN THE LST 6 MTHS         
P00307        PERFORM 1070-CHECK-PREV-ADJUSTMENT THRU 1070-EXIT         
P00307        IF WS-PREV-ADJUSTMENT = 'Y'                               
P00307          NEXT SENTENCE                                           
P00307        END-IF                                                    
P00307                                                                  
P00694**----  EPP-FINAL-TOTAL INCLUDES TRANS BALANCE                            
T32040        SUBTRACT EPP-FINAL-TOTAL                                  
T32040        FROM WS-AMT-MO-PYMT-BU GIVING WS-EPP-DIFF                 
T32040        IF WS-EPP-DIFF < 0                                        
T32040           COMPUTE WS-EPP-DIFF = WS-EPP-DIFF * -1                 
T32040        END-IF                                                    
P00307        MOVE 'BBP-NO-ADJUST-LIMIT' TO C8-DELINQ-CD                
P00307        MOVE WS-COMPANY-NO-AT      TO  C8-COMPANY-NO              
P00307        PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT              
P00307        MOVE C8-DELINQ-VALUE TO WS-BBP-NOADJ-AMT                  
P00307        IF WS-EPP-DIFF <= WS-BBP-NOADJ-AMT                        
P00307           NEXT SENTENCE                                          
P00307        ELSE                                                      
T32040           MOVE EPP-FINAL-TOTAL TO WS-NEW-EPP-AMT6                
A03850           MOVE WS-AMT-MO-PYMT-BU TO WS-OLD-EPP-AMT6              
T34474           IF EPP-WQ-REQD                                         
P00307              PERFORM 1060-BBP-WQ-CHECK THRU 1060-EXIT            
P00307              IF WS-GENERATE-WQ = 'Y'                             
P00694                 AND WS-AMT-MO-PYMT-BU > 0                        
T32040                 MOVE WS-EPP-BALANCE-WARNING-D                    
T32040                                     TO WS-WORK-MESSAGE           
T32040                 PERFORM 5100-PROCESS-EXCEPTION THRU              
T32040                                         5100-EXIT                
P00307              ELSE                                                
P00694                 IF EPP-FINAL-TOTAL >= 0                          
P00307                    PERFORM 1050-UPDATE-BUDGET-AMT THRU           
P00307                                        1050-EXIT                 
P00694                 END-IF                                           
P00307              END-IF                                              
T34474           END-IF                                                 
P00307        END-IF                                                    
T32040     ELSE                                                         
T32040         MOVE 'N' TO WS-MONITOR-EPP-FLAG                          
T34474         IF EPP-WQ-REQD                                           
ACT003            MOVE WS-AMT-MO-PYMT-BU   TO WS-OLD-EPP-AMT-E          
ACT003            MOVE WS-NO-OF-EPP-MONTHS TO WS-REM-EPP-MTHS-E         
T32040            MOVE WS-EPP-BALANCE-WARNING-E TO WS-WORK-MESSAGE      
T32040            PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT         
T34474         END-IF                                                   
T32040     END-IF.                                                      
                                                                        
P00694 1006-EXIT.                                                       
P00694      EXIT.                                                       
                                                                        
P00694**---------------------------------------------------------               
P00694** BBP MONITORING AT 8 MONTHS REMAINING                                   
P00694**---------------------------------------------------------               
P00694 1008-MONITOR-BBP.                                                
T34459     MOVE 4  TO WS-NO-OF-EPP-MONTHS                               
T32040     MOVE 8  TO WS-NO-OF-MONTHS-HELD                              
T32040     MOVE 'Y' TO WS-MONITOR-EPP-FLAG                              
T32040     PERFORM 5000-LOAD-HISTORY THRU 5000-EXIT                     
T32040                                                                  
T32040     IF WS-COMPLETE-468                                           
P00694         IF (CSR-DATABASE AND WS-COMPANY-NO-AT = '26') OR         
P00694            SEB-DATABASE                                          
                 PERFORM 5500-CALC-UTILITY-CHARGES   THRU 5500-EXIT     
P00694         ELSE                                                     
P00694           PERFORM 5505-GET-MON-BBP-AMT THRU 5505-EXIT            
P00694           PERFORM 5510-GET-BUFFERS     THRU 5510-EXIT            
P00694           PERFORM 5520-CALC-FINAL-BBP  THRU 5520-EXIT            
P00694         END-IF                                                   
T32040         MOVE 'N' TO WS-MONITOR-EPP-FLAG                          
T32040*                                                                         
P00307*****CHECK TO SEE IF ACCOUNT IS EXEMPT FROM BBP                           
P00307         MOVE SPACE TO WS-EXEMPT-FLAG                             
P00307         MOVE WS-ACCOUNT-NO-AT      TO YP-ACCOUNT-NO              
P00307         MOVE 'BBP_REVIEW_EXEMPT'   TO YP-ATTRIBUTE-DESC          
P00307         PERFORM 7310-CHECK-EXEMPT-FLAG THRU 7310-EXIT            
P00307         IF WS-EXEMPT-FLAG = 'Y'                                  
P00307            NEXT SENTENCE                                         
P00307         END-IF                                                   
P00307                                                                  
P00307*******CHECK TO SEE IF A REFUND EXIST ON THE ACCOUNT                      
P00307         MOVE 'N' TO WS-REFUND-EXIST                              
P00307         MOVE WS-ACCOUNT-NO-AT TO RN-ACCOUNT-NO                   
P00307         MOVE WS-DATE-PYMT-STRT-BU TO RN-DATE-REFUNDED            
P00307         PERFORM 7320-CHECK-FOR-REFUND THRU 7320-EXIT             
P00307         IF WS-REFUND-EXIST = 'N'                                 
P00307             NEXT SENTENCE                                        
P00307         END-IF                                                   
P00307                                                                  
P00694**----  EPP-FINAL-TOTAL INCLUDES TRANS BALANCE                            
T32040         SUBTRACT EPP-FINAL-TOTAL                                 
T32040         FROM WS-AMT-MO-PYMT-BU GIVING WS-EPP-DIFF                
T32040         IF WS-EPP-DIFF < 0                                       
T32040            COMPUTE WS-EPP-DIFF = WS-EPP-DIFF * -1                
T32040         END-IF                                                   
P00307         MOVE 'BBP-NO-ADJUST-LIMIT' TO C8-DELINQ-CD               
P00307         MOVE WS-COMPANY-NO-AT      TO  C8-COMPANY-NO             
P00307         PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT             
P00307         MOVE C8-DELINQ-VALUE TO WS-BBP-NOADJ-AMT                 
P00307         IF WS-EPP-DIFF <= WS-BBP-NOADJ-AMT                       
P00307                  NEXT SENTENCE                                   
P00307         ELSE                                                     
T32040            MOVE EPP-FINAL-TOTAL TO WS-NEW-EPP-AMT8               
A03850            MOVE WS-AMT-MO-PYMT-BU TO WS-OLD-EPP-AMT8             
T34474            IF EPP-WQ-REQD                                        
P00307               PERFORM 1060-BBP-WQ-CHECK THRU 1060-EXIT           
P00307               IF WS-GENERATE-WQ = 'Y'                            
P00694                 AND WS-AMT-MO-PYMT-BU > 0                        
T32040                  MOVE WS-EPP-BALANCE-WARNING-C                   
T33040                                    TO WS-WORK-MESSAGE            
T32040                  PERFORM 5100-PROCESS-EXCEPTION THRU             
T32040                                         5100-EXIT                
P00307               ELSE                                               
P00694                  IF EPP-FINAL-TOTAL >= 0                         
P00307                     PERFORM 1050-UPDATE-BUDGET-AMT THRU          
P00307                                         1050-EXIT                
P00694                  END-IF                                          
P00307               END-IF                                             
T32040            END-IF                                                
P00307         END-IF                                                   
T32040     ELSE                                                         
T32040         MOVE 'N' TO WS-MONITOR-EPP-FLAG                          
T32040     END-IF.                                                      
                                                                        
P00694 1008-EXIT.                                                       
P00694      EXIT.                                                       
                                                                        
P00307****************************************************************          
P00307**    1050-UPDATE-BUDGET-AMT.                                 **          
P00307**THIS PARAGRAPH WILL UPDATE BUDGET BILLING AMOUNT AUTOMATICALLY          
P00307** INSTEAD OF GENERATING A WORK QUE                           **          
P00307****************************************************************          
P00307 1050-UPDATE-BUDGET-AMT.                                          
P00307************ INSERT BUDGET HIST ROW FOR MONITORING *************          
P00307     PERFORM 7955-GET-TIMESTAMP-AND-DATE THRU 7955-EXIT.          
P00307     MOVE CURRENT-TIMESTAMP TO BH-BUD-HIST-SEQ-NO.                
P00307     MOVE WS-ACCOUNT-NO-AT  TO BH-ACCOUNT-NO.                     
P00307     MOVE 50                TO BH-PYMT-PRIORITY-LVL.              
P00307     MOVE 1                 TO BH-ITEM-ID.                        
P00307     MOVE WS-AMT-MO-PYMT-BU TO WS-BBP-OLD-AMT                     
P00307                               BH-BUDG-BILL-PREV-AMT.             
P00307     MOVE WS-DATE-PYMT-STRT-BU TO BH-DATE-PYMT-STRT.              
P00307     MOVE WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)                
P00307                            TO BH-UTILITY-BALANCE.                
P00307     MOVE 0                                                       
P00307                            TO BH-BALANCE-FORWARD.                
P00307     MOVE WS-EPP-MONTHS-REMAINING                                 
P00307                            TO BH-EPP-MTHS-RMNG-QT.               
P00307     MOVE 0                 TO BH-EPP-ESTIMATE                    
P00307     MOVE EPP-FINAL-TOTAL   TO BH-AMT-MO-PYMT                     
P00307                               WS-BBP-NEW-AMT.                    
P00307     MOVE WS-M              TO BH-CHANGE-REASON.                  
P00307     MOVE WS-EPP-MONTHS-REMAINING                                 
P00307                            TO WS-BBP-MSG-MTHS.                   
P00307     MOVE WS-BBP-UPDATE-MSG TO WS-BBP-UPDATE-TEXT.                
P00307     MOVE WS-BBP-UPDATE-LEN TO BH-REMARKS-LEN.                    
P00307     MOVE WS-BBP-UPDATE-TEXT TO BH-REMARKS-TEXT.                  
P00694     MOVE 'SYSTEM'           TO BH-LAST-UPDATE-USERID             
A02036     IF LS-DATABASE-UPDATES = 'YES'                               
P00307      PERFORM 8100-INSERT-BUDGET-HIST THRU 8100-EXIT              
A02036     END-IF.                                                      
P00307                                                                  
P00307************ INSERT BUDGET HIST ROW FOR LETTER *****************          
P00307     MOVE SPACES TO WS-BBP-UPDATE-TEXT.                           
P00307     MOVE 2                 TO BH-ITEM-ID.                        
P00307     MOVE WS-Y              TO BH-CHANGE-REASON.                  
P00307     MOVE WS-BBP-LETTER-MSG TO WS-BBP-UPDATE-TEXT.                
P00307     MOVE WS-BBP-LETTER-LEN TO BH-REMARKS-LEN.                    
P00307     MOVE WS-BBP-UPDATE-TEXT TO BH-REMARKS-TEXT.                  
P00694     MOVE 'SYSTEM'           TO BH-LAST-UPDATE-USERID             
A02036     IF LS-DATABASE-UPDATES = 'YES'                               
P00307      PERFORM 8100-INSERT-BUDGET-HIST THRU 8100-EXIT              
A02036     END-IF.                                                      
P00307                                                                  
P00307*********** LOAD AND INSERT MAINTENANCE TRAN HIST ***********             
P00307     MOVE WS-BBP-TRANS-HIST-MESS TO WS-TRAN-COMMENT-TEXT.         
                                                                        
P00307     MOVE WS-ACCOUNT-NO-AT        TO MH-ACCOUNT-NO.               
P00307     MOVE 0                       TO MH-CUSTOMER-NO.              
P00307     MOVE 0                       TO MH-PREMISE-NO.               
P00307     MOVE CURRENT-TIMESTAMP       TO MH-TRANS-HIST-SEQ-NO         
P00307                                     MI-TRANS-HIST-SEQ-NO.        
P00307     MOVE 'SCSCA112A'             TO MH-APPL-PROGRAM-ID.          
P00307     MOVE 1                       TO MI-TRAN-APPL-NO.             
P00307     MOVE CURRENT-DATE            TO MH-DATE-TRANS.               
P00307     MOVE 'F'                     TO MH-CODE-TRAN-TYPE.           
A02036     MOVE SPACES                  TO MH-RESP-AREA-ID.             
P00307     MOVE WS-SYSTEM               TO MH-USER-ID.                  
P00307     MOVE WS-TRAN-COMMENT-TEXT    TO MH-TRAN-COMMENT-TEXT.        
P00307     MOVE WS-BBP-TRANS-HIST-LEN   TO MH-TRAN-COMMENT-LEN.         
P00307     MOVE SPACES                  TO MI-TABLE-ID.                 
P00307                                                                  
P00307     MOVE 'BBP AMOUNT'            TO MI-COLUMN-DESC.              
P00307     MOVE WS-AMT-MO-PYMT-BU       TO WS-AMT-MO-PYMT-X.            
P00307     MOVE 12                      TO MI-PRV-COLUMN-VALUE-LEN.     
P00307     MOVE WS-AMT-MO-PYMT-X        TO MI-PRV-COLUMN-VALUE-TEXT.    
P00307     MOVE EPP-FINAL-TOTAL         TO WS-AMT-MO-PYMT-X.            
P00307     MOVE 12                      TO MI-CHG-COLUMN-VALUE-LEN.     
P00307     MOVE WS-AMT-MO-PYMT-X        TO MI-CHG-COLUMN-VALUE-TEXT.    
P00307     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
P00307     ADD +1                       TO MI-TRAN-APPL-NO.             
                                                                        
P00307****** UPDATING OLD AMOUNT SO THAT SCSCA113 CAN UPDATE ******             
P00307****** CSS_BUDGET_PLAN WITH NEW BBP AMOUNT             ******             
P00307     MOVE EPP-FINAL-TOTAL TO WS-AMT-MO-PYMT-BU.                   
                                                                        
P00307 1050-EXIT.                                                       
P00307     EXIT.                                                        
                                                                        
P00307****************************************************************          
P00307**  1060-BBP-WQ-CHECK.                                        **          
P00307** THIS PARAGRAPH WILL CHECK TO SEE IF WE NEED TO PRODUCE A WQ**          
P00307** OR AUTOMATICALLY UPDATE THE BBP AMOUNT                     **          
P00307****************************************************************          
P00307 1060-BBP-WQ-CHECK.                                               
P00307     MOVE SPACE TO WS-GENERATE-WQ.                                
P00307     IF WS-AMT-MO-PYMT-BU > 0                                     
P00307       COMPUTE WS-EPP-DIFF = EPP-FINAL-TOTAL - WS-AMT-MO-PYMT-BU  
P00307       COMPUTE WS-BPP-PERCENT-CALC ROUNDED =                      
P00307                         (WS-EPP-DIFF * 100)/WS-AMT-MO-PYMT-BU    
P00307       IF WS-EPP-DIFF < 0                                         
P00307         COMPUTE WS-BPP-PERCENT-CALC = WS-BPP-PERCENT-CALC * -1   
P00307         MOVE 'BBP-DECREASE-PCT' TO C8-DELINQ-CD                  
P00694         MOVE WS-COMPANY-NO-AT         TO  C8-COMPANY-NO          
P00694         PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT             
P00694         MOVE C8-DELINQ-VALUE          TO WS-BBP-PERCENT-DELQ     
P00694         IF WS-BPP-PERCENT-CALC >= WS-BBP-PERCENT-DELQ            
P00307            MOVE 'Y' TO WS-GENERATE-WQ                            
P00307         END-IF                                                   
P00307       ELSE                                                       
P00307         MOVE 'BBP-INCREASE-PCT' TO C8-DELINQ-CD                  
P00694         MOVE WS-COMPANY-NO-AT         TO  C8-COMPANY-NO          
P00694         PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT             
P00694         MOVE C8-DELINQ-VALUE          TO WS-BBP-PERCENT-DELQ     
p00694                                                                  
ACT029         MOVE 'BBP-INCREASE-PCT-MAX' TO C8-DELINQ-CD              
ACT029         MOVE WS-COMPANY-NO-AT         TO  C8-COMPANY-NO          
ACT029         PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT             
ACT029         MOVE C8-DELINQ-VALUE          TO WS-BBP-PERCENT-MAX-DELQ 
p00694                                                                  
P00694         MOVE WS-COMPANY-NO-AT         TO  C8-COMPANY-NO          
P00694         MOVE 'BBP-CAP-AMOUNT'         TO  C8-DELINQ-CD           
P00694         PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT             
P00694         MOVE C8-DELINQ-VALUE          TO  WS-BBP-CAP-AMOUNT      
p00694                                                                  
ACT029         IF (WS-BPP-PERCENT-CALC >= WS-BBP-PERCENT-DELQ           
ACT029             AND WS-AMT-MO-PYMT-BU >= WS-BBP-CAP-AMOUNT)          
ACT029                      OR                                          
P00694            WS-BPP-PERCENT-CALC >= WS-BBP-PERCENT-MAX-DELQ        
P00307            MOVE 'Y' TO WS-GENERATE-WQ                            
P00307         END-IF                                                   
P00307       END-IF                                                     
P00307     ELSE                                                         
P00307       MOVE 'Y' TO WS-GENERATE-WQ                                 
P00307     END-IF.                                                      
P00307                                                                  
P00307 1060-EXIT.                                                       
P00307     EXIT.                                                        
                                                                        
P00307****************************************************************          
P00307**** CHECK TO SEE IF BBP AMT HAS BEEN CHANGED IN LST 6 MTHS ****          
P00307****************************************************************          
P00307 1070-CHECK-PREV-ADJUSTMENT.                                      
P00307     MOVE WS-ACCOUNT-NO-AT TO MH-ACCOUNT-NO                       
P00307                              BG-ACCOUNT-NO.                      
P00307     MOVE SPACE TO WS-PREV-ADJUSTMENT.                            
P00307     MOVE WS-MONITOR-DATE-R TO WS-MONITOR-DATE-1.                 
P00307     PERFORM 7960-GET-MAINT-START-MONTH THRU 7960-EXIT.           
P00307     MOVE WS-MONITOR-DATE  TO WS-MONITOR-DATE-R.                  
P00307     MOVE WS-MON-DATE-CCYY TO WS-BILL-DATE-CCYY.                  
P00307     MOVE WS-MON-DATE-MM   TO WS-BILL-DATE-MM.                    
P00307     MOVE BG-REVENUE-MONTH TO WS-HOLD-REV-MONTH.                  
P00307     MOVE WS-BILL-DATE     TO BG-REVENUE-MONTH.                   
P00307     PERFORM 7970-GET-BILL-DATE THRU 7970-EXIT.                   
ACT002     IF SQLCODE = SUCCESSFUL-CALL                                 
P00307        MOVE WS-HOLD-REV-MONTH TO BG-REVENUE-MONTH                
P00307        MOVE WS-DATE-PYMT-STRT-BU TO BH-DATE-PYMT-STRT            
P00307        PERFORM 7980-CHECK-MAINT-HIST THRU 7980-EXIT              
ACT002     END-IF.                                                      
P00307 1070-EXIT.                                                       
P00307     EXIT.                                                        
T19143*                                                                 15120000
T19143****************************************************************  15130000
T19143**    1200-CALC-EPP-MONTHS-TO-GO.                             **  15140000
T19143** USING THE CURRENT REVENUE MONTH AS THE BASE LINE, GO FOR-  **  15150000
T19143** WARD TO THE ANNIVERSARY DATE TO DETEMINE THE NBR OF MONTHS **  15160000
T19143** REMAINING IN THIS EPP PLAN YEAR. IF THE NBR OF MONTHS IS   **  15170000
T19143** 3, 6 OR 9 CHECK FOR EXCESSIVE VARIANCE AND PUT OUT WORKQUE.**  15180000
T19143****************************************************************  15190000
T19143 1200-CALC-EPP-MONTHS-TO-GO.                                      
T19143     MOVE WS-REV-CCYY-TEMP TO WS-TEMP-CCYY-9.                     
T19143     MOVE WS-REV-MM-TEMP   TO WS-TEMP-MM-9.                       
T19143     MOVE ZEROS            TO WS-EPP-MONTHS-REMAINING.            
T19143     MOVE 'N'              TO WS-ANNIV-FND-SW.                    
T19143     PERFORM VARYING WS-MONTH-CTR FROM +1 BY +1                   
T19143        UNTIL WS-ANNIV-FND-SW = 'Y'                               
T19143           ADD +1 TO WS-TEMP-MM-9                                 
T19143           IF WS-TEMP-MM-9 =  13                                  
T19143              MOVE +1 TO WS-TEMP-MM-9                             
T19143              ADD  +1 TO WS-TEMP-CCYY-9                           
T19143           END-IF                                                 
T19143           ADD +1 TO WS-EPP-MONTHS-REMAINING                      
T19143           MOVE WS-TEMP-MM-9    TO WS-TEMP-MM-X                   
T19143           MOVE WS-TEMP-CCYY-9  TO WS-TEMP-CCYY-X                 
T19143           MOVE '01'            TO WS-TEMP-DD-X                   
T19143           MOVE '-'             TO WS-TEMP-D1-X                   
T19143                                   WS-TEMP-D2-X                   
T19143           IF WS-TEMP-DATE-X = WS-ANNIVERSARY-DATE-BU             
T19143              MOVE 'Y' TO WS-ANNIV-FND-SW                         
T21551           ELSE                                                   
T21551              IF WS-TEMP-DATE-X > WS-ANNIVERSARY-DATE-BU          
HONK                   MOVE 'Y' TO WS-ANNIV-FND-SW                      
T21551*                MOVE WS-EPP-ANIVERSARY-ERROR TO WS-WORK-MESSAGE  15430000
T21551*                PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT    15440000
T21551*                MOVE 12 TO RETURN-CODE                           15450000
T21551*                GO TO 9999-BAIL-OUT                              15460000
T21551              END-IF                                              
T19143           END-IF                                                 
T19143     END-PERFORM.                                                 
T19143                                                                  
T19143*                                                                 15510000
T19143 1200-EXIT.                                                       
T19143     EXIT.                                                        
T19143*                                                                 15540000
T28606 1250-DET-EPP-WQ.                                                 
T28606*                                                                         
T28606     INITIALIZE WS-ORIG-AMT-MO-PYMT.                              
T28606     MOVE 'Y'                         TO WS-LOAD-WQ-FOR-BAL.      
T28606     MOVE WS-ACCOUNT-NO-BU            TO BH-ACCOUNT-NO.           
T28606     MOVE WS-PYMT-PRIORITY-LVL-BU     TO BH-PYMT-PRIORITY-LVL.    
T28606     MOVE WS-BP-ITEM-ID-BU            TO BH-ITEM-ID.              
T28606                                                                  
T28606     PERFORM 7800-SEL-RECENT-CHG         THRU 7800-EXIT.          
T28606     IF SQLCODE = SUCCESSFUL-CALL                                 
T28606        MOVE BH-AMT-MO-PYMT           TO WS-ORIG-AMT-MO-PYMT      
T28606     ELSE                                                         
T28606        GO TO 1250-EXIT                                           
T28606     END-IF.                                                      
T28606                                                                  
T28606     PERFORM 7820-OPEN-CHANGED-ROW       THRU 7820-EXIT.          
T28606     PERFORM 7830-FETCH-CHANGED-ROW      THRU 7830-EXIT.          
T28606     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
T28606          OR WS-LOAD-WQ-FOR-BAL = 'N'                             
T28606       IF BH-AMT-MO-PYMT NOT = WS-ORIG-AMT-MO-PYMT                
T28606          MOVE 'N'                    TO WS-LOAD-WQ-FOR-BAL       
T28606       END-IF                                                     
T28606       PERFORM 7830-FETCH-CHANGED-ROW    THRU 7830-EXIT           
T28606     END-PERFORM.                                                 
T28606     PERFORM 7840-CLOSE-CHANGED-ROW      THRU 7840-EXIT.          
T28606                                                                  
T28606 1250-EXIT.                                                       
T28606     EXIT.                                                        
T28606                                                                  
      /***************************************************************  15550000
      **    2000-ANNUAL-RECALCULATION.                              **  15560000
      ** THIS PROCEDURE WILL RECACULATE THE EPP MONTHLY CHARGE USING**  15570000
      ** DATA FROM PREVIOUS MONTHS WITH CURRENT RATES.              **  15580000
      **                                                            **  15590000
      ****************************************************************  15600000
       2000-ANNUAL-RECALCULATION.                                       
                                                                        
T21442     IF WS-WQ-MESSAGE-SET                                         
T23829        IF SEB-DATABASE                                           
T23829          AND WS-CODE-TEMP-BILL-AT = 'R'                          
T23829              CONTINUE                                            
T23829        ELSE                                                      
T32593          MOVE '#'  TO  WS-CODE-TEMP-BILL-AT                      
T23829        END-IF                                                    
T21442     END-IF.                                                      
                                                                        
T17777        SET WS-AR-DATA-INDX  TO  WS-HOLD-BUDGET-INDX              
T17777        IF WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) > 0           
T17777            PERFORM 2010-APPLY-CIA-TO-TRAN-BAL  THRU 2010-EXIT    
T17777        END-IF                                                    
              PERFORM 5000-LOAD-HISTORY THRU 5000-EXIT                  
                                                                        
P00694        IF (CSR-DATABASE AND WS-COMPANY-NO-AT = '26') OR          
P00694            SEB-DATABASE                                          
                 PERFORM 5500-CALC-UTILITY-CHARGES   THRU 5500-EXIT     
P00694        ELSE                                                      
P00694           PERFORM 5506-GET-ANN-BBP-AMT THRU 5506-EXIT            
P00694           PERFORM 5510-GET-BUFFERS    THRU 5510-EXIT             
P00694           PERFORM 5520-CALC-FINAL-BBP THRU 5520-EXIT             
P00694        END-IF                                                    
                                                                        
              PERFORM 2020-UPDATE-BUDGET-AMOUNT   THRU 2020-EXIT        
              PERFORM 2050-BUILD-12-MONTH-SNAP    THRU 2050-EXIT        
PCR212        PERFORM 2100-PROCESS-EPP-ALLOC      THRU 2100-EXIT        
T19679        IF NOT WS-COMPLETE-SET                                    
T23829           IF SEB-DATABASE                                        
T23829               AND WS-CODE-TEMP-BILL-AT = 'R'                     
T23829               MOVE WS-INSUFFICIENT-HISTORY TO WS-WORK-MESSAGE    
T23829               PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT      
T23829           ELSE                                                   
T26188               MOVE '#' TO WS-CODE-TEMP-BILL-AT                   
                     MOVE WS-INSUFFICIENT-HISTORY TO WS-WORK-MESSAGE    
                     PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT      
                 END-IF                                                 
              END-IF.                                                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /***************************************************************  16010000
T17777**    2010-APPLY-CIA-TO-TRAN-BAL.                             **  16020000
T17777*                                                             **  16030000
T17777* IF THE ACCOUNT HAS CIA CREDIT ON IT, APPLY IT TO THE EPP    **  16040000
T17777* TRAN BALANCE.                                               **  16050000
T17777* (THE 00, 30, 60, 90 MONEY SHOULD HAVE BEEN PAID OFF IN      **  16060000
T17777* SCSCA108/SCSCA106 BEFORE GETTING TO THIS PROGRAM.               16070000
T17777****************************************************************  16080000
T17777 2010-APPLY-CIA-TO-TRAN-BAL.                                      
T17777                                                                  
T17777     MOVE ZEROES                TO WS-CIA-LIHEAP-CREDIT           
T17777                                   WS-CIA-CASH-CREDIT.            
T17777     SET WS-AR-DATA-INDX        TO 1.                             
T17777     SEARCH WS-AR-DATA                                            
T17777     AT END                                                       
T17777         CONTINUE                                                 
T17777     WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = 0                  
T17777         CONTINUE                                                 
T17777     WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 70          
T17777      AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 2                     
T17777         MOVE WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)               
T17777                             TO WS-CIA-LIHEAP-CREDIT              
T17777         SET WS-CIA-LIHEAP-INDX  TO  WS-AR-DATA-INDX              
T17777     END-SEARCH.                                                  
T17777                                                                  
T17777     SET WS-AR-DATA-INDX        TO 1.                             
T17777     SEARCH WS-AR-DATA                                            
T17777     AT END                                                       
T17777     CONTINUE                                                     
T17777     WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = 0                  
T17777         CONTINUE                                                 
T17777     WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 70          
T17777      AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 1                     
T17777         MOVE WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)               
T17777                             TO WS-CIA-CASH-CREDIT                
T17777         SET WS-CIA-CASH-INDX  TO  WS-AR-DATA-INDX                
T17777     END-SEARCH.                                                  
T17777                                                                  
T17777     IF WS-CIA-LIHEAP-CREDIT < 0 OR WS-CIA-CASH-CREDIT < 0        
T17777        CONTINUE                                                  
T17777     ELSE                                                         
T17777        GO TO 2010-EXIT                                           
T17777     END-IF.                                                      
T17777                                                                  
T17777     IF WS-CIA-LIHEAP-CREDIT < 0                                  
T17777        COMPUTE WS-CIA-LIHEAP-AMT = WS-CIA-LIHEAP-CREDIT * -1     
T17777        SET WS-AR-DATA-INDX   TO  WS-HOLD-BUDGET-INDX             
T17777        IF WS-CIA-LIHEAP-AMT >=                                   
T17777                        WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)  
T17777            COMPUTE WS-CIA-LIHEAP-REMAIN = WS-CIA-LIHEAP-AMT -    
T17777                         WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) 
T17777                                                                  
T17777            MOVE WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)         
T17777              TO WS-PAID-TRAN-BALANCE                             
T17777            MOVE ZEROES TO WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)  
T17777            MOVE ZEROES TO WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)  
T17777            MOVE ZEROES TO WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)  
T17777            MOVE ZEROES TO WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)  
T17777          MOVE ZEROES TO WS-AMT-TRAN-BALANCE-AC(WS-AR-DATA-INDX)  
T17777                         WS-NEW-TRAN-BALANCE                      
T17777                                                                  
T17777            SET WS-AR-DATA-INDX  TO WS-CIA-LIHEAP-INDX            
T17777            COMPUTE WS-CIA-LIHEAP-CREDIT =                        
T17777                           WS-CIA-LIHEAP-REMAIN * -1              
T17777            MOVE WS-CIA-LIHEAP-CREDIT                             
T17777                 TO WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)         
T17777                    WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)      
T17777            IF WS-CIA-LIHEAP-CREDIT = 0                           
T17777               MOVE WS-DELETE                                     
T17777                     TO WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX) 
T17777            END-IF                                                
T17777                                                                  
T17777            MOVE WS-PAID-TRAN-BALANCE  TO  WS-HOLD-AMT-POSTED     
T17777            ADD WS-HOLD-AMT-POSTED     TO  WS-TOTAL-AR-BALANCE-AT 
T17777                                                                  
T17777            PERFORM 5950-JOURNAL-APPLY-CIA THRU 5950-EXIT         
T17777        ELSE                                                      
T17777**** IF THE EPP TRAN BALANCE IS GREATER THAN THE CIA AMOUNT       16780000
T17777            SET WS-AR-DATA-INDX   TO  WS-HOLD-BUDGET-INDX         
T17777            COMPUTE WS-NEW-TRAN-BALANCE =                         
T17777                  WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) -      
T17777                          WS-CIA-LIHEAP-AMT                       
T17777            MOVE WS-NEW-TRAN-BALANCE  TO                          
                            WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)    
T17777                                                                  
T17777            SET WS-AR-DATA-INDX   TO  WS-CIA-LIHEAP-INDX          
T17777            MOVE ZEROES                                           
T17777              TO WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)            
T17777                 WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)         
T17777            MOVE WS-DELETE                                        
T17777              TO WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX)        
T17777                                                                  
T17777            MOVE WS-CIA-LIHEAP-AMT  TO WS-HOLD-AMT-POSTED         
T17777            ADD WS-HOLD-AMT-POSTED  TO                            
T17777                                    WS-TOTAL-AR-BALANCE-AT        
T17777            PERFORM 5950-JOURNAL-APPLY-CIA  THRU 5950-EXIT        
T17777        END-IF                                                    
T17777     ELSE                                                         
T17777     IF WS-CIA-CASH-CREDIT < 0                                    
T17777        COMPUTE WS-CIA-CASH-AMT = WS-CIA-CASH-CREDIT * -1         
T17777        SET WS-AR-DATA-INDX   TO  WS-HOLD-BUDGET-INDX             
T17777        IF WS-CIA-CASH-AMT >=                                     
T17777                        WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)  
T17777            COMPUTE WS-CIA-CASH-REMAIN = WS-CIA-CASH-AMT -        
T17777                         WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) 
T17777                                                                  
T17777            MOVE WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)         
T17777              TO WS-PAID-TRAN-BALANCE                             
T17777            MOVE ZEROES TO WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)  
T17777            MOVE ZEROES TO WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)  
T17777            MOVE ZEROES TO WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)  
T17777            MOVE ZEROES TO WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)  
T17777          MOVE ZEROES TO WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) 
T17777                         WS-NEW-TRAN-BALANCE                      
T17777                                                                  
T17777            SET WS-AR-DATA-INDX  TO WS-CIA-CASH-INDX              
T17777            COMPUTE WS-CIA-CASH-CREDIT =                          
T17777                           WS-CIA-CASH-REMAIN * -1                
T17777            MOVE WS-CIA-CASH-CREDIT                               
T17777                 TO WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)         
T17777                    WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)      
T17777            IF WS-CIA-CASH-CREDIT = 0                             
T17777               MOVE WS-DELETE                                     
T17777                     TO WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX) 
T17777            END-IF                                                
T17777                                                                  
T17777            MOVE WS-PAID-TRAN-BALANCE  TO  WS-HOLD-AMT-POSTED     
T17777            ADD WS-HOLD-AMT-POSTED     TO  WS-TOTAL-AR-BALANCE-AT 
T17777            PERFORM 5950-JOURNAL-APPLY-CIA THRU 5950-EXIT         
T17777                                                                  
T17777        ELSE                                                      
T17777**** IF THE EPP TRAN BALANCE IS GREATER THAN THE CIA AMOUNT       17320000
T17777            SET WS-AR-DATA-INDX   TO  WS-HOLD-BUDGET-INDX         
T17777            COMPUTE WS-NEW-TRAN-BALANCE =                         
T17777                  WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) -      
T17777                          WS-CIA-CASH-AMT                         
T17777            MOVE WS-NEW-TRAN-BALANCE  TO                          
T17777                  WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)        
T17777                                                                  
T17777            SET WS-AR-DATA-INDX   TO  WS-CIA-CASH-INDX            
T17777            MOVE ZEROES                                           
T17777              TO WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)            
T17777                 WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)         
T17777            MOVE WS-DELETE                                        
T17777              TO WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX)        
T17777                                                                  
T17777            MOVE WS-CIA-CASH-AMT   TO  WS-HOLD-AMT-POSTED         
T17777            ADD WS-HOLD-AMT-POSTED TO  WS-TOTAL-AR-BALANCE-AT     
T17777            PERFORM 5950-JOURNAL-APPLY-CIA THRU 5950-EXIT         
T17777                                                                  
T17777        END-IF                                                    
T17777     END-IF
           END-IF.                                                      
T17777                                                                  
T17777                                                                  
       2010-EXIT.                                                       
           EXIT.                                                        
T17777                                                                  
      /***************************************************************  17580000
      **    2020-UPDATE-BUDGET-AMOUNT.                              **  17590000
      *                                                                 17600000
      * IF THE BUDGET BALANCE IS A CREDIT, THEN MOVE THE                17610000
      * AMOUNT TO UNUSED CREDIT.                                        17620000
      * ELSE SET UP 2 AMOUNTS: ONE WITH THE BALANCE SPREAD OVER NEXT    17630000
      * 12 MONTHS AND ONE WITHOUT THE BALANCE                           17640000
      *                                                                 17650000
T22594* IF A CREDIT BALANCE ON THE EPP CNTL RECORD THAN DO NOT ZERO     17660000
T22594* IT OUT, WANT THIS AMOUNT TO GO TO BUDGET_HIST TABLE TO REFLECT  17670000
T22594* THE CREDIT BALANCE. UTILITY BALANCE SHOULD REMAIN ZERO.         17680000
      *                                                                 17690000
      ****************************************************************  17700000
       2020-UPDATE-BUDGET-AMOUNT.                                       
                                                                        
           SET WS-AR-DATA-INDX TO WS-HOLD-BUDGET-INDX                   
           IF WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) < 0              
C25936        IF WS-TOTAL-AR-BALANCE-AT NOT EQUAL 0                     
C25936           PERFORM 2200-BILL-ADJ-JRNL  THRU 2200-EXIT             
C25936        END-IF                                                    
PCR470        PERFORM 2030-CREATE-CIA    THRU 2030-EXIT                 
T10869        MOVE EPP-FINAL-TOTAL TO WS-AMT-MO-PYMT-BU                 
T10869                                WS-AMT-MO-PYMT-NEW-CALC           
T10869        MOVE ZERO            TO WS-AMT-MO-PYMT-NEW-BU             
T22594        MOVE WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)             
T22594                  TO WS-AMT-MO-PMT-NEW-BAL-FWD-CALC               
              MOVE ZERO TO WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)     
T22594*                    WS-AMT-MO-PMT-NEW-BAL-FWD-CALC               17820000
                           WS-AMT-MO-PYT-BAL-FWD-BU                     
T10760                     WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)        
T18242        IF WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX) > 0              
T18242           SUBTRACT WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)         
T18242               FROM WS-WK03-TOTAL-AR-BAL                          
T18242           MOVE ZERO TO WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)     
T18242        END-IF                                                    
T18242        IF WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX) > 0              
T18242           SUBTRACT WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)         
T18242               FROM WS-WK03-TOTAL-AR-BAL                          
T18242           MOVE ZERO TO WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)     
T18242        END-IF                                                    
T18242        IF WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX) > 0              
T18242           SUBTRACT WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)         
T18242               FROM WS-WK03-TOTAL-AR-BAL                          
T18242           MOVE ZERO TO WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)     
T18242        END-IF                                                    
           ELSE                                                         
T13330*     FOR ACCOUNTS WHOSE TRAN BAL IS LESS THAN THE NORMAL MO      18010000
T13330*     PYMT, MAKE THE 0-DAY EQUAL TO THE TRAN BAL AND BASE NEXT    18020000
T13330*     YRS MO PYMT ON USAGE ONLY (DON'T USE BAL FWD).              18030000
C34216        INITIALIZE WS-ARREARS-AMOUNT                              
C34216                   WS-TOTAL-BALANCE                               
C34216                                                                  
C34216        MOVE WS-ACCOUNT-NO-AT            TO AC-ACCOUNT-NO         
C34216        PERFORM 7565-SELECT-EPP-ARREARS  THRU 7565-EXIT           
C34216        COMPUTE WS-ARREARS-AMOUNT =                               
C34216                AC-AMT-AR-DAY-00 +                                
C34216                AC-AMT-AR-DAY-30 +                                
C34216                AC-AMT-AR-DAY-60 +                                
C34216                AC-AMT-AR-DAY-90 +                                
C34216                AC-AMT-UNUSED-CR                                  
C34216        IF WS-ARREARS-AMOUNT > 0 AND                              
C34216           (WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) <            
C34216           WS-AMT-MO-PYMT-BU + WS-ARREARS-AMOUNT)                 
C34216*             ADD EPP-FINAL-TOTAL  TO                                     
C34216*                 WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)                
C34216           IF WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) >          
C34216                     WS-AMT-MO-PYMT-BU                            
C34216             MOVE WS-AMT-MO-PYMT-BU TO                            
C34216                  WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)           
C34216             COMPUTE WS-EPP-DIFF2 =                               
C34216                     WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) -   
C34216                     WS-AMT-MO-PYMT-BU                            
C34216             MOVE WS-EPP-DIFF2 TO                                 
C34216                  WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)           
C34216             MOVE ZEROS TO WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)  
C34216                           WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)  
C34216             COMPUTE WS-TOTAL-BALANCE = WS-ARREARS-AMOUNT -       
C34216                                         WS-EPP-DIFF2             
C34216             COMPUTE WS-TOTAL-AR-BALANCE-AT =                     
C34216                       WS-TOTAL-AR-BALANCE-AT  -                  
C34216                                WS-TOTAL-BALANCE                  
T10869             MOVE EPP-FINAL-TOTAL TO WS-AMT-MO-PYMT-NEW-CALC      
T10869                                     WS-AMT-MO-PYMT-NEW-BU        
T22862             COMPUTE WS-AMT-MO-PMT-NEW-BAL-FWD-CALC ROUNDED =     
T22862                  (WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) -     
T22862                  (WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)  +       
T22862                   WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)))        
T10583             COMPUTE WS-AMT-MO-PMT-HOLD ROUNDED =                 
T10583              (EPP-TOTAL + WS-AMT-MO-PMT-NEW-BAL-FWD-CALC) / 12   
T10583             MOVE WS-AMT-MO-PMT-HOLD TO WS-AMT-MO-PYMT-BRKDWN     
T10583             MOVE WS-AMT-MO-PMT-DLLR TO EPP-FINAL-TOTAL-WBAL      
T10583             IF WS-AMT-MO-PMT-CNTS > 0                            
T10583                 ADD +1              TO EPP-FINAL-TOTAL-WBAL      
T10583             END-IF                                               
T8752              MOVE WS-AMT-MO-PMT-NEW-BAL-FWD-CALC TO               
T8752                                         WS-AMT-MO-PYT-BAL-FWD-BU  
                   MOVE EPP-FINAL-TOTAL-WBAL                            
T8752                                             TO WS-AMT-MO-PYMT-BU  
T17423             MOVE WS-BH-DATE-FROM-REV-MON TO WS-EPP-OFFER-DATE-AT 
T11078             MOVE 0 TO WS-EPP-OFFER-AMOUNT-AT                     
C34216           ELSE                                                   
C34216             MOVE WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)        
C34216                    TO   WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)    
C34216             COMPUTE WS-TOTAL-BALANCE = WS-ARREARS-AMOUNT         
C34216             COMPUTE WS-TOTAL-AR-BALANCE-AT =                     
C34216                       WS-TOTAL-AR-BALANCE-AT  -                  
C34216                                WS-ARREARS-AMOUNT                 
C34216             MOVE ZEROS TO WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)  
C34216                           WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)  
C34216                           WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)  
T13330             MOVE EPP-FINAL-TOTAL TO WS-AMT-MO-PYMT-BU            
T13330                                     WS-AMT-MO-PYMT-NEW-CALC      
T13330             MOVE ZERO            TO WS-AMT-MO-PYMT-NEW-BU        
T13330                                   WS-AMT-MO-PMT-NEW-BAL-FWD-CALC 
T13330                                     WS-AMT-MO-PYT-BAL-FWD-BU     
C34216           END-IF                                                 
C34216             MOVE ZEROS TO WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)  
C34216                                                                  
C34216                                                                  
C34216        IF  WS-ARREARS-AMOUNT >= 0 AND WS-TOTAL-BALANCE > 0       
C34216            CONTINUE                                              
C34216        ELSE                                                      
C34216            GO TO 2020-EXIT                                       
C34216        END-IF                                                    
C34216                                                                  
C34216        INITIALIZE CJF00101                                       
C34216        PERFORM 5965-CREATE-ADJ-JOURNAL THRU 5965-EXIT            
C34216      ELSE                                                        
T13330      IF WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) <               
T17777         WS-AMT-MO-PYMT-BU                                        
T13330        MOVE EPP-FINAL-TOTAL TO WS-AMT-MO-PYMT-BU                 
T13330                                WS-AMT-MO-PYMT-NEW-CALC           
T13330        MOVE ZERO TO WS-AMT-MO-PYMT-NEW-BU                        
T13330                     WS-AMT-MO-PMT-NEW-BAL-FWD-CALC               
T13330                     WS-AMT-MO-PYT-BAL-FWD-BU                     
T13330      ELSE                                                        
T10869        MOVE EPP-FINAL-TOTAL TO WS-AMT-MO-PYMT-NEW-CALC           
T10869                                WS-AMT-MO-PYMT-NEW-BU             
T22862        COMPUTE WS-AMT-MO-PMT-NEW-BAL-FWD-CALC ROUNDED =          
T22862              (WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) -         
T22862                (WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)  +         
T22862                 WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)  +         
T22862                 WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)  +         
T22862                 WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)))          
T10583        COMPUTE WS-AMT-MO-PMT-HOLD ROUNDED =                      
T10583           (EPP-TOTAL + WS-AMT-MO-PMT-NEW-BAL-FWD-CALC) / 12      
T10583        MOVE WS-AMT-MO-PMT-HOLD TO WS-AMT-MO-PYMT-BRKDWN          
T10583        MOVE WS-AMT-MO-PMT-DLLR TO EPP-FINAL-TOTAL-WBAL           
T10583        IF WS-AMT-MO-PMT-CNTS > 0                                 
T10583           ADD +1 TO EPP-FINAL-TOTAL-WBAL                         
T10583        END-IF                                                    
T8752         MOVE WS-AMT-MO-PMT-NEW-BAL-FWD-CALC TO                    
T8752              WS-AMT-MO-PYT-BAL-FWD-BU                             
              MOVE EPP-FINAL-TOTAL-WBAL                                 
T8752           TO WS-AMT-MO-PYMT-BU                                    
T17423*       MOVE LS-INPUT-DATE    TO WS-EPP-OFFER-DATE-AT             18370000
T17423        MOVE WS-BH-DATE-FROM-REV-MON TO WS-EPP-OFFER-DATE-AT      
T11078        MOVE 0 TO WS-EPP-OFFER-AMOUNT-AT                          
                                                                        
T13330      END-IF                                                      
C34216     END-IF                                                       
           END-IF.                                                      
       2020-EXIT.                                                       
           EXIT.                                                        
      /***************************************************************  18450000
      * CREATE THE INTERNAL CIA AR_CNTL ROW.                            18460000
      ****************************************************************  18470000
PCR470 2030-CREATE-CIA.                                                 
PCR470*    MOVE AMT-TRAN-BALANCE FROM THE EPP ROW TO THE NEW CIA ROW    18490000
PCR470*     (WS-CIA-CREDIT IS USED IN SCSCA108)                         18500000
PCR470     MOVE WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)                
PCR470       TO WS-AMT-TRAN-BAL-HOLD-AC.                                
PCR470     MOVE WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX)                      
PCR470             TO WS-ACCOUNT-NO-HOLD-AC.                            
PCR470     MOVE +1 TO WS-HOLD-ITEM-ID.                                  
                                                                        
PCR470*    SEARCH FOR THE NEXT AVAILABLE AR ROW                         18570000
PCR470     SET WS-AR-HOLD-INDX TO WS-AR-DATA-INDX.                      
PCR470     SET WS-AR-DATA-INDX TO 1.                                    
PCR470     SEARCH WS-AR-DATA                                            
PCR470        AT END                                                    
PCR470           MOVE 16 TO RETURN-CODE                                 
PCR470        WHEN (WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 70      
PCR470               AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 1)           
PCR470          OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZERO            
PCR470           CONTINUE                                               
PCR470     END-SEARCH.                                                  
                                                                        
PCR470*    MOVE THE VALUES TO THE NEW AR-CNTL CIA ROW                   18690000
PCR470     MOVE WS-ACCOUNT-NO-HOLD-AC                                   
PCR470             TO WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX).               
PCR470     MOVE +70 TO WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX).       
PCR470     MOVE WS-HOLD-ITEM-ID TO WS-ITEM-ID-AC (WS-AR-DATA-INDX).     
PCR470     MOVE ZERO TO                                                 
PCR470                WS-TOT-NEW-CHRGS-CALC-AC (WS-AR-DATA-INDX)        
PCR470                WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)             
PCR470                WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)             
PCR470                WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)             
PCR470                WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)             
PCR470                WS-TOT-SUMM-UNBILLED-AC (WS-AR-DATA-INDX)         
PCR470                WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX).         
PCR470     ADD  WS-AMT-TRAN-BAL-HOLD-AC                                 
PCR470             TO WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX).            
PCR470     IF ( WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX) = ' ' OR      
A00312         WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX) = 'I' )        
A00312        MOVE WS-CODES-DATA-PRESENT-AT TO WS-CODES-DATA-PRESENT    
A00312        MOVE 'A'                      TO WS-CODE-CIA              
A00312        MOVE WS-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT-AT 
PCR470        MOVE 'I' TO WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX)     
PCR470*    END-IF                                                       18860000
T18078     ELSE                                                         
T18078        IF WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX) = 'U'        
T18078           OR WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX) = 'D'     
T18078           MOVE 'U' TO WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX)  
T18327        END-IF                                                    
T18327     END-IF.                                                      
T10082     PERFORM 5900-CREATE-101-JOURNAL  THRU 5900-EXIT.             
                                                                        
PCR470*    SET THE AR-INDX BACK TO THE EPP ROW                          18950000
PCR470     SET WS-AR-DATA-INDX TO WS-AR-HOLD-INDX.                      
PCR470 2030-EXIT.                                                       
PCR470     EXIT.                                                        
      /                                                                 18990000
       2050-BUILD-12-MONTH-SNAP.                                        
           PERFORM VARYING WS-ICD-INDX FROM 1 BY 1                      
                     UNTIL WS-ICD-INDX > 4                              
A02094      IF WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX) NOT = SPACE          
              SET WS-EPP-INDX                                           
                  WS-IC-INDX TO WS-ICD-INDX                             
              MOVE WS-ACCOUNT-NO-AT                                     
                TO WS-ACCOUNT-EPP (WS-EPP-INDX)                         
              MOVE WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX)                  
                TO WS-CODE-UTIL-TYPE-EPP (WS-EPP-INDX)                  
              MOVE WS-ICD-IC-NO (WS-ICD-INDX)                           
                TO WS-IC-NO-EPP (WS-EPP-INDX)                           
T20503        MOVE 'N' TO WS-EPP-HIST-USAGE-ERROR-FL                    
              PERFORM VARYING WS-RM-INDX FROM 1 BY 1                    
                   UNTIL WS-RM-INDX > 12                                
                 SET WS-EPP-12-INDX TO WS-RM-INDX                       
T14959           IF WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX) = 'G'           
T14959              COMPUTE WS-USAGE-EPP (WS-EPP-INDX WS-EPP-12-INDX)   
T16415                ROUNDED =                                         
T14959                (WS-BD-ENERGY-UNITS (WS-RM-INDX WS-IC-INDX)) *    
T14959                (WS-BD-BTU-FACTOR (WS-RM-INDX WS-IC-INDX))        
T14959           ELSE                                                   
                    MOVE WS-BD-ENERGY-UNITS (WS-RM-INDX WS-IC-INDX)     
                      TO WS-USAGE-EPP (WS-EPP-INDX WS-EPP-12-INDX)      
T14959           END-IF                                                 
T20503           IF WS-BD-AMT-BILL-ITEM (WS-RM-INDX WS-IC-INDX) = 0.00  
T20503              AND WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX) NOT = 'U'   
T17859*             AND WS-BD-BILL-NO (WS-RM-INDX WS-IC-INDX) NOT = ZERO19370000
T20503              SET WS-EPP-HIST-USAGE-ERROR TO TRUE                 
T20503           END-IF                                                 
                 MOVE WS-BD-AMT-BILL-ITEM (WS-RM-INDX WS-IC-INDX)       
                   TO WS-IC-NEW-AMOUNT-EPP (WS-EPP-INDX WS-EPP-12-INDX) 
              END-PERFORM                                               
T20503*       IF WS-EPP-HIST-USAGE-ERROR                                19430000
T33004        IF WS-EPP-HIST-USAGE-ERROR OR WS-EPP-ANN-PRJ-CST-ERROR    
T24096           IF SEB-DATABASE                                        
T24096             AND WS-CODE-TEMP-BILL-AT = 'R'                       
T20503             MOVE WS-EPP-USAGE-ERROR TO  WS-WORK-MESSAGE          
T20503             PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT        
T24096           ELSE                                                   
T29768             MOVE WS-EPP-USAGE-ERROR-PULLCD                       
T29768                                     TO  WS-CODE-TEMP-BILL-AT     
T24096             MOVE WS-EPP-USAGE-ERROR TO  WS-WORK-MESSAGE          
T24096             PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT        
T24096           END-IF                                                 
T20503        END-IF                                                    
A02094      END-IF                                                      
           END-PERFORM.                                                 
                                                                        
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /***************************************************************  19590000
PCR212**    2100-PROCESS-EPP-ALLOC.                                 **  19600000
      ** THIS PROCEDURE WILL CALCULATE THE ALLOCATION PERCENTAGE.   **  19610000
      ****************************************************************  19620000
PCR212 2100-PROCESS-EPP-ALLOC.                                          
      *                                                                 19640000
PCR212     MOVE ZERO         TO WS-EPP-ELEC-REV                         
PCR212                          WS-EPP-GAS-REV.                         
                                                                        
PCR212     PERFORM VARYING WS-ICD-INDX FROM 1 BY 1                      
PCR212       UNTIL WS-ICD-INDX > 4                                      
A02094     IF WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX) NOT = SPACES          
PCR212       SET WS-IC-INDX TO WS-ICD-INDX                              
PCR212       PERFORM VARYING WS-RM-INDX FROM 1 BY 1                     
PCR212         UNTIL WS-RM-INDX > 12                                    
                                                                        
PCR212             EVALUATE WS-ICD-CODE-UTIL-TYPE(WS-ICD-INDX)          
PCR212               WHEN 'G'                                           
PCR212                 ADD WS-BD-AMT-BILL-ITEM(WS-RM-INDX WS-IC-INDX)   
PCR212                         TO WS-EPP-GAS-REV                        
PCR212               WHEN 'E'                                           
PCR212                 ADD WS-BD-AMT-BILL-ITEM(WS-RM-INDX WS-IC-INDX)   
PCR212                         TO WS-EPP-ELEC-REV                       
PCR212               WHEN 'U'                                           
PCR212                 SET WS-NO-ELEC-SERVICE                           
PCR212                     WS-NO-GAS-SERVICE  TO TRUE                   
                                                                        
PCR212*                CHECK EACH CUST PLAN FOR THE SERVICE TYPE OF     19870000
PCR212*                THIS UNMETERED UTIL TYPE.                        19880000
PCR212                 PERFORM VARYING WS-CUST-PLAN-INDX FROM 1 BY 1    
I00177                    UNTIL WS-CUST-PLAN-INDX >                     
I00177                          WS-CP-MAX-ENTRY OR                      
PCR212                       WS-ACCOUNT-NO-CP(WS-CUST-PLAN-INDX) = ZEROS
                                                                        
PCR212*                 ONLY CONSIDER THOSE WITH THE SAME IC NO.        19930000
PCR212                  IF WS-ICD-IC-NO (WS-ICD-INDX) =                 
PCR212                        WS-IC-NO-CP (WS-CUST-PLAN-INDX) AND       
PCR212                      WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX) =       
PCR212                        WS-CODE-UTIL-TYPE-CP (WS-CUST-PLAN-INDX)  
PCR212                   IF WS-CODE-SERVICE-TYPE-CP (WS-CUST-PLAN-INDX) 
PCR212                                             = 'E'                
PCR212                     IF WS-NO-ELEC-SERVICE                        
PCR212                       ADD                                        
PCR212                        WS-BD-AMT-BILL-ITEM(WS-RM-INDX WS-IC-INDX)
PCR212                           TO WS-EPP-ELEC-REV                     
PCR212                       SET WS-ELEC-SERVICE TO TRUE                
PCR212                     END-IF                                       
PCR212                   ELSE                                           
PCR212                     IF WS-NO-GAS-SERVICE                         
PCR212                       ADD                                        
PCR212                        WS-BD-AMT-BILL-ITEM(WS-RM-INDX WS-IC-INDX)
PCR212                           TO WS-EPP-GAS-REV                      
PCR212                       SET WS-GAS-SERVICE TO TRUE                 
PCR212                     END-IF                                       
PCR212                   END-IF                                         
PCR212                  END-IF                                          
PCR212                 END-PERFORM                                      
PCR212             END-EVALUATE                                         
PCR212       END-PERFORM                                                
A02094     END-IF                                                       
PCR212     END-PERFORM.                                                 
                                                                        
PCR212     IF WS-EPP-ELEC-REV > 0 AND WS-EPP-GAS-REV > 0                
PCR212        COMPUTE WS-TOTAL-EPP-REV ROUNDED = WS-EPP-ELEC-REV +      
PCR212                                           WS-EPP-GAS-REV         
PCR212        COMPUTE WS-ELEC-REV-ALLOC-PCT-AT ROUNDED =                
PCR212           (WS-EPP-ELEC-REV / WS-TOTAL-EPP-REV) * 100             
PCR212     ELSE                                                         
PCR212        MOVE ZERO     TO WS-ELEC-REV-ALLOC-PCT-AT                 
PCR212     END-IF.                                                      
      *                                                                 20280000
PCR212 2100-EXIT.                                                       
PCR212     EXIT.                                                        
                                                                        
C25936 2200-BILL-ADJ-JRNL.                                              
C25936*    PROCESS FILE MAINTENANCE ON EPP.                             20310200
C25936     INITIALIZE WS-ARREARS-AMOUNT                                 
C25936                WS-TOTAL-BALANCE.                                 
C25936*                                                                 20310500
C25936     MOVE WS-ACCOUNT-NO-AT           TO AC-ACCOUNT-NO             
C25936     PERFORM 7560-SELECT-ARREARS     THRU 7560-EXIT.              
C25936     COMPUTE WS-ARREARS-AMOUNT =                                  
C25936             AC-AMT-AR-DAY-00 +                                   
C25936             AC-AMT-AR-DAY-30 +                                   
C25936             AC-AMT-AR-DAY-60 +                                   
C25936             AC-AMT-AR-DAY-90 +                                   
C25936             AC-AMT-UNUSED-CR                                     
C25936*                                                                 20311700
C25936     COMPUTE WS-TOTAL-BALANCE = WS-TOTAL-AR-BALANCE-AT -          
C25936                                WS-ARREARS-AMOUNT                 
C25936*                                                                 20312000
C25936     IF  WS-ARREARS-AMOUNT >= 0 AND WS-TOTAL-BALANCE > 0          
C25936         CONTINUE                                                 
C25936     ELSE                                                         
C25936         GO TO 2200-EXIT                                          
C25936     END-IF.                                                      
C25936*                                                                 20312600
C25936     INITIALIZE CJF00101.                                         
C25936     PERFORM 5960-CREATE-ADJ-JOURNAL THRU 5960-EXIT.              
C25936                                                                  
C25936 2200-EXIT.                                                       
C25936     EXIT.                                                        
C25936*                                                                 20320000
      /***************************************************************  20870000
      **    4000-EPP-OFFER.                                         **  20880000
      ** THIS PROCEDURE WILL CALCULATE THE EPP AMOUNT IF AN ACCOUNT **  20890000
      ** HAS BEEN SELECTED FOR THE SPECIAL PLAN AND IS NOT ALREADY  **  20900000
      ** AN EPP ACCOUNT. (12 MONTHS HISTORY IS REQURIED).           **  20910000
      **                                                            **  20920000
      ****************************************************************  20930000
       4000-EPP-OFFER.                                                  
           PERFORM 5000-LOAD-HISTORY THRU 5000-EXIT                     
           IF WS-COMPLETE-SET                                           
P00694        IF (CSR-DATABASE AND WS-COMPANY-NO-AT = '26') OR          
P00694            SEB-DATABASE                                          
                 PERFORM 5500-CALC-UTILITY-CHARGES   THRU 5500-EXIT     
P00694        ELSE                                                      
P00694           PERFORM 5506-GET-ANN-BBP-AMT THRU 5506-EXIT            
P00694           PERFORM 5510-GET-BUFFERS     THRU 5510-EXIT            
P00694           PERFORM 5520-CALC-FINAL-BBP  THRU 5520-EXIT            
P00694        END-IF                                                    
                                                                        
C27553        IF WS-HIST-DATA-SUFFICIENT = 'Y'                          
                 MOVE EPP-FINAL-TOTAL       TO EPP-OFFER-AMOUNT         
                 MOVE ZEROES                TO BH-UTILITY-BALANCE       
                 PERFORM VARYING WS-AR-DATA-INDX FROM 1 BY 1            
P00097                  UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY         
                           OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZERO 
                   IF WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 40    
C26130                             OR 45 OR 19 OR 30 OR 60              
                      ADD WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)         
                        TO WS-CURR-UTIL-BAL                             
                      ADD WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)      
                        TO BH-UTILITY-BALANCE                           
                   ELSE                                                 
                      ADD WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)         
                         TO EPP-OFFER-AMOUNT                            
                   END-IF                                               
                 END-PERFORM                                            
                                                                        
                 IF WS-CURR-UTIL-BAL = EPP-OFFER-AMOUNT                 
                    SUBTRACT 1.00 FROM EPP-OFFER-AMOUNT                 
C26130                              EPP-FINAL-TOTAL                     
                 END-IF                                                 
                                                                        
C26130           IF EPP-OFFER-AMOUNT = 50.00 OR 100.00 OR 150.00        
C26130                                               OR 200.00          
C26130              ADD 1.00 TO EPP-OFFER-AMOUNT                        
C26130                       EPP-FINAL-TOTAL                            
C26130           END-IF                                                 
                                                                        
                 MOVE WS-ACCOUNT-NO-AT TO BH-ACCOUNT-NO                 
                 MOVE 50               TO BH-PYMT-PRIORITY-LVL          
                 MOVE 1                TO BH-ITEM-ID                    
                 MOVE EPP-OFFER-AMOUNT TO WS-EPP-OFFER-AMOUNT-AT        
                                          BH-EPP-ESTIMATE               
                                          BH-BALANCE-FORWARD            
P00307           MOVE WS-BBP-HOLD-OLD-AMT                               
P00307                                 TO BH-BUDG-BILL-PREV-AMT         
                 MOVE EPP-FINAL-TOTAL  TO WS-AMT-MO-PYMT-NEW-CALC       
                                          BH-AMT-MO-PYMT                
T17335           MOVE WS-BH-DATE-FROM-REV-MON   TO BH-DATE-PYMT-STRT    
T17423                                          WS-EPP-OFFER-DATE-AT    
T8752            MOVE +12              TO BH-EPP-MTHS-RMNG-QT           
T9678            MOVE WS-O             TO BH-CHANGE-REASON              
                 MOVE 9                TO BH-REMARKS-LEN                
C26164*          MOVE 'BBP OFFER'      TO BH-REMARKS-TEXT               21350000
C26164           MOVE 'BBP OFFER;'     TO BH-REMARKS-TEXT               
C26164****** REMARKS TO SHOW BUFFER USED WHEN OFFER ROW IS WRITTEN              
C26164           IF  CSR-DATABASE AND C8-COMPANY-NO = '01'              
C26164               IF  WS-ELEC-SW = 'Y' AND WS-GAS-SW = 'Y'           
C26164                   STRING '-BUFFER FACTOR ELEC: '                 
C26164                   DELIMITED BY SIZE                              
C26164                   WS-ELEC-BUFFER   DELIMITED BY SIZE             
C26164                   ' GAS: '         DELIMITED BY SIZE             
C26164                   WS-GAS-BUFFER    DELIMITED BY SIZE             
C26164                    ';'             DELIMITED BY SIZE             
C26164                   INTO WS-REMARKS-TEXT                           
C26164                   MOVE +41                 TO WS-REMARKS-LEN     
C26164               ELSE                                               
C26164                   IF  WS-ELEC-SW = 'Y'                           
C26164                       STRING '-BUFFER FACTOR ELEC: '             
C26164                       DELIMITED BY SIZE                          
C26164                       WS-ELEC-BUFFER     DELIMITED BY SIZE       
C26164                       ';'                DELIMITED BY SIZE       
C26164                       INTO WS-REMARKS-TEXT                       
C26164                       MOVE +28             TO WS-REMARKS-LEN     
C26164                   ELSE                                           
C26164                       IF  WS-GAS-SW = 'Y'                        
C26164                           STRING '-BUFFER FACTOR GAS: '          
C26164                           DELIMITED BY SIZE                      
C26164                           WS-GAS-BUFFER   DELIMITED BY SIZE      
C26164                          ';'                DELIMITED BY SIZE    
C26164                           INTO WS-REMARKS-TEXT                   
C26164                           MOVE +27        TO WS-REMARKS-LEN      
C26164                       END-IF                                     
C26164                   END-IF                                         
C26164               END-IF                                             
C26164           ELSE                                                   
C26164               STRING '-BUFFER FACTOR GAS: ' DELIMITED BY SIZE    
C26164               WS-GAS-BUFFER         DELIMITED BY SIZE            
C26164                ';'                  DELIMITED BY SIZE            
C26164               INTO WS-REMARKS-TEXT                               
C26164               MOVE +27                 TO WS-REMARKS-LEN         
C26164           END-IF                                                 
C26164           STRING BH-REMARKS-TEXT DELIMITED BY ';'                
C26164                  WS-REMARKS-TEXT DELIMITED BY ';'                
C26164             INTO BH-REMARKS-TEXT                                 
C26164           ADD WS-REMARKS-LEN     TO BH-REMARKS-LEN               
P00307           PERFORM 7950-GET-TIMESTAMP THRU 7950-EXIT              
P00307           MOVE CURRENT-TIMESTAMP TO BH-BUD-HIST-SEQ-NO           
P00694           MOVE 'SYSTEM'           TO BH-LAST-UPDATE-USERID       
A02036           IF LS-DATABASE-UPDATES = 'YES'                         
                  PERFORM 8100-INSERT-BUDGET-HIST                       
                      THRU 8100-EXIT                                    
A02036           END-IF                                                 
C27553        ELSE                                                      
C27553           MOVE ' ' TO WS-CODE-EPP-OFFER                          
C27553        END-IF                                                    
C26130     ELSE                                                         
C26130        MOVE ' ' TO WS-CODE-EPP-OFFER                             
           END-IF.                                                      
                                                                        
       4000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /***************************************************************  21430000
      **    5000-LOAD-HISTORY.                                      **  21440000
      ** THIS PROCEDURE LOADS A WORK TABLE WITH SUFFICIENT DATA     **  21450000
      ** TO CALC PAST 12 MONTHS (INCLUDING CURRENT BILL) FOR ALL **     21460000
      ** ICS. A CHECK IS ALSO MADE TO VERIFY THAT A FULL 12 MONTHS  **  21470000
      ** DATA IS AVAILABLE.                                         **  21480000
      **                                                            **  21490000
      ****************************************************************  21500000
       5000-LOAD-HISTORY.                                               
                                                                        
           MOVE WS-ACCOUNT-NO-AT TO BG-ACCOUNT-NO                       
C26130     MOVE 'N'              TO WS-HIST-DATA-SUFFICIENT             
C27553     MOVE 0                TO WS-GAS-USAGE-MTHS                   
C27553                              WS-ELEC-USAGE-MTHS                  
T32040                              WS-BILL-CTRE                        
T32040                              WS-BILL-CTRG                        
T32040                              WS-BILL-CTRU                        
C27553     MOVE 'N'              TO WS-GAS-SW                           
C27553                              WS-ELEC-SW                          
P00694     SET NOT-CURR-MTH-BILL TO TRUE.                               
      ** LOAD DATA FROM DATABASE                                        21540000
                                                                        
           PERFORM 7000-OPEN-BI-BG-EPP THRU 7000-EXIT                   
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
              PERFORM 7010-FETCH-BI-BG-EPP THRU 7010-EXIT               
              IF SQLCODE = SUCCESSFUL-CALL                              
T32040         IF BG-CODE-UTIL-TYPE = 'E'                               
A02036          SET WS-ELEC-NOT-AS-UNMTRD TO TRUE                       
A02036          PERFORM VARYING WS-CUST-PLAN-INDX FROM 1 BY 1           
SCA006            UNTIL WS-ELEC-AS-UNMTRD OR 
                        WS-CUST-PLAN-INDX > WS-CP-MAX-ENTRY OR 
                        WS-ACCOUNT-NO-CP(WS-CUST-PLAN-INDX) = ZEROS             
A02036            IF  BG-IC-NO = WS-IC-NO-CP (WS-CUST-PLAN-INDX)        
A02036            AND BG-CODE-UTIL-TYPE =                               
A02036                        WS-CODE-UTIL-TYPE-CP(WS-CUST-PLAN-INDX)   
A02036                SET WS-ELEC-AS-UNMTRD TO TRUE                     
A02036             END-IF                                               
A02036          END-PERFORM                                             
A02036                                                                  
A02036          IF WS-ELEC-NOT-AS-UNMTRD                                
T32040           COMPUTE WS-BILL-CTRE = WS-BILL-CTRE + 1                
T34391           IF  WS-MONITOR-EPP-FLAG = 'Y'                          
T34391           AND WS-BILL-CTRE < 12                                  
T34391              IF BG-REV-MTH-ORIG-BILL > 0                         
T34391                MOVE BG-REV-MTH-ORIG-BILL                         
T34391                      TO WS-CK-SEASONAL-MTH (WS-BILL-CTRE)        
T34391              ELSE                                                
T34391                MOVE BG-REVENUE-MONTH                             
T34391                      TO WS-CK-SEASONAL-MTH (WS-BILL-CTRE)        
T34391              END-IF                                              
T34391           END-IF                                                 
A02036          END-IF                                                  
T32040         END-IF                                                   
T32040         IF BG-CODE-UTIL-TYPE = 'G'                               
T32040          COMPUTE WS-BILL-CTRG = WS-BILL-CTRG + 1                 
T34391          IF  WS-MONITOR-EPP-FLAG = 'Y'                           
T34391          AND WS-BILL-CTRG < 12                                   
T34391           IF BG-REV-MTH-ORIG-BILL > 0                            
T34391             MOVE BG-REV-MTH-ORIG-BILL                            
T34391                     TO WS-CG-SEASONAL-MTH (WS-BILL-CTRG)         
T34391           ELSE                                                   
T34391             MOVE BG-REVENUE-MONTH                                
T34391                     TO WS-CG-SEASONAL-MTH (WS-BILL-CTRG)         
T34391           END-IF                                                 
T34391          END-IF                                                  
T32040         END-IF                                                   
T32040         IF BG-CODE-UTIL-TYPE = 'U'                               
T32040          COMPUTE WS-BILL-CTRU = WS-BILL-CTRU + 1                 
T32040         END-IF                                                   
               PERFORM 5010-LOAD-BG-DATA THRU 5010-EXIT                 
              END-IF                                                    
           END-PERFORM                                                  
           PERFORM 7020-CLOSE-BI-BG-EPP THRU 7020-EXIT                  
                                                                        
      ** INSERT CURRENT BILL DATA                                       21640000
                                                                        
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1                  
                   UNTIL WS-BILLING-INDX > 30                           
                      OR WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = ZERO      
T29768      IF WS-CODE-BILL-CALC-BG(WS-BILLING-INDX) = 'A' AND          
T29768         WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'C' AND      
T29768         WS-CODE-BILL-ITM-IND-BG(WS-BILLING-INDX)  = 'A'          
P00694        SET CURR-MTH-BILL TO TRUE                                 
              MOVE WS-BILL-NO-BG (WS-BILLING-INDX) TO BG-BILL-NO        
              MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)               
                 TO BG-CODE-UTIL-TYPE                                   
              MOVE WS-IC-NO-BG (WS-BILLING-INDX) TO BG-IC-NO            
              MOVE WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)           
                TO BG-BILL-ITEM-TIMESTMP                                
              MOVE WS-CODE-REVENUE-CLASS-BG (WS-BILLING-INDX)           
                TO BG-CODE-REVENUE-CLASS                                
              MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)                 
                TO BG-RATE-PLAN-NO                                      
              MOVE WS-REVENUE-MONTH-BG (WS-BILLING-INDX)                
                TO BG-REVENUE-MONTH                                     
              MOVE WS-GAS-BASE-USE-BG (WS-BILLING-INDX)                 
                TO BG-GAS-BASE-USE                                      
              MOVE WS-WNA-FACTOR-BG (WS-BILLING-INDX)                   
                TO BG-WNA-FACTOR                                        
              MOVE WS-BTU-FACTOR-BG (WS-BILLING-INDX)                   
                TO BG-BTU-FACTOR                                        
              MOVE WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)            
                TO BG-REV-MTH-ORIG-BILL                                 
              MOVE WS-REVENUE-MONTH-BG (WS-BILLING-INDX)                
                TO BG-REVENUE-MONTH                                     
T25475        MOVE WS-AMT-STATE-TAX-BG (WS-BILLING-INDX)                
T25475          TO BG-AMT-STATE-TAX                                     
P00694        MOVE WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)                
P00694          TO BG-AMT-BILL-ITEM                                     
              PERFORM 5010-LOAD-BG-DATA THRU 5010-EXIT                  
              SET WS-ICD-CURR-BG (WS-ICD-INDX) TO WS-RM-INDX            
                                                                        
P00694        IF (CSR-DATABASE AND WS-COMPANY-NO-AT = '26') OR          
P00694            SEB-DATABASE                                          
P00694             PERFORM 5005-LOAD-TAX-RATES   THRU 5005-EXIT         
P00694        END-IF                                                    
                                                                        
P00694        PERFORM 5006-LOAD-UM-BILL-AMT THRU 5006-EXIT              
                                                                        
T29768      END-IF                                                      
           END-PERFORM.                                                 
                                                                        
      **** GET RID OF OLD IC'S (NO CURRENT MONTH ENTRY)                 22180000
====> **** NOTE: ALSO NEED TO GET RID OF ANY UNMETERED PLANS THAT       22190000
====> **       WERE REMOVED IN THE CURRENT MONTH                        22200000
                                                                        
           PERFORM VARYING  WS-IC-INDX FROM 1 BY 1                      
                   UNTIL WS-IC-INDX > 4                                 
              SET WS-ICD-INDX TO WS-IC-INDX                             
              IF WS-BD-BILL-NO (1 WS-IC-INDX) = ZERO                    
                 INITIALIZE WS-IC-DATA (WS-ICD-INDX)                    
                 PERFORM VARYING WS-RM-INDX FROM 1 BY 1                 
                           UNTIL WS-RM-INDX > 12                        
                    INITIALIZE WS-BD-IC-ENTRY (WS-RM-INDX WS-IC-INDX)   
                 END-PERFORM                                            
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
      ** VERIFY THAT THERE IS AN ENTIRE "SET" OF DATA AVAILABLE         22330000
           SET WS-COMPLETE-SET TO TRUE                                  
T32040     SET WS-COMPLETE-468 TO TRUE                                  
           MOVE 'N' TO WS-UNMETERED-IC-IND                              
           PERFORM VARYING  WS-ICD-INDX FROM 1 BY 1                     
                   UNTIL WS-ICD-INDX > 4                                
A02094       IF WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX) NOT = SPACE         
              SET WS-IC-INDX TO WS-ICD-INDX                             
T17859        SET WS-ICD-HIST-INDX TO WS-ICD-INDX                       
T17859        MOVE ZERO TO WS-ICD-NO-MONTHS (WS-ICD-HIST-INDX)          
              MOVE 'N' TO WS-TEMP-INCOMPLETE-SET                        
              MOVE 'N' TO WS-TEMP-UNMETERED-IC                          
              PERFORM VARYING WS-RM-INDX FROM 1 BY 1                    
                        UNTIL WS-RM-INDX > 12                           
                           OR WS-TEMP-INCOMPLETE-SET = 'Y'              
                           OR WS-TEMP-UNMETERED-IC  = 'Y'               
T17859           IF WS-BD-BILL-NO (WS-RM-INDX WS-IC-INDX) > ZERO        
T17859               ADD 1 TO WS-ICD-NO-MONTHS (WS-ICD-HIST-INDX)       
T17859           ELSE                                                   
T17859             IF WS-BD-BILL-NO (WS-RM-INDX WS-IC-INDX) = ZERO      
ACT134               AND WS-RM-INDX >= 9                                
T17859                 CONTINUE                                         
T17859             ELSE                                                 
T17859               IF WS-BD-BILL-NO (WS-RM-INDX WS-IC-INDX) = ZERO    
T17859                 AND WS-RM-INDX < 9                               
T20395                  IF WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX) EQUAL 'U'
ACT241                     MOVE 12                                      
ACT241                       TO WS-ICD-NO-MONTHS (WS-ICD-HIST-INDX)     
T20395                     SET WS-UNMETERED-IC TO TRUE                  
T20395                     MOVE 'Y' TO WS-TEMP-UNMETERED-IC             
T20395                  ELSE                                            
T20395                     SET WS-INCOMPLETE-SET TO TRUE                
T19679                     MOVE 'Y' TO WS-TEMP-INCOMPLETE-SET           
T20395                  END-IF                                          
T17859               END-IF                                             
T17859             END-IF                                               
                 END-IF                                                 
              END-PERFORM                                               
                                                                        
T22520* IF PROCESSING LAST OCCURANCE IN TABLE, AND THE MONTH COUNT      22720000
T22520* IS LESS THAN 12, BUT THE BILL-NO IS POPULATED, THEN MOVE        22730000
T22520* 12 TO THE MONTH COUNTER.                                        22740000
T22520        IF  WS-ICD-NO-MONTHS (WS-ICD-HIST-INDX)  <  12            
T22520        AND WS-BD-BILL-NO (12 WS-IC-INDX)  NOT =  ZERO            
T22520            MOVE 12 TO WS-ICD-NO-MONTHS (WS-ICD-HIST-INDX)        
T22520        END-IF                                                    
A02094       END-IF                                                     
           END-PERFORM.                                                 
                                                                        
T17201*****IF INCOMPLETE SET ON ACCOUNT OF NEW UNMETERED ONLY           22810000
T17201*****RESET FLAG TO COMPLETE TO ALLOW EPP CALCULATION SINCE        22820000
T17201*****12 MOS OF UNMETERED HISTORY ARE NOT NEEDED FOR THE CALC      22830000
T32040** FIX FOR DB -180 ERROR                                                  
T32040     IF  WS-MONITOR-EPP-FLAG = 'Y'                                
T32040*****ELECTRIC ONLY SERVICE                                                
T32040      IF  WS-BILL-CTRG = 0                                        
T32040         IF WS-BILL-CTRE < 11                                     
T32040           SET WS-INCOMPLETE-468 TO TRUE                          
T32040         END-IF                                                   
T32040      ELSE                                                        
T32040***** BOTH GAS AND ELECTRIC                                       22340000
T32040         IF WS-BILL-CTRE >= 11 AND WS-BILL-CTRG < 11              
T32040           SET WS-INCOMPLETE-468 TO TRUE                          
T32040         END-IF                                                   
T32040         IF WS-BILL-CTRE < 11 AND WS-BILL-CTRG < 11               
T32040           SET WS-INCOMPLETE-468 TO TRUE                          
T32040         END-IF                                                   
T32040      END-IF                                                      
T32040*****GAS ONLY SERVICE                                                     
T32040      IF  WS-BILL-CTRE = 0                                        
T32040         IF WS-BILL-CTRG < 11                                     
T32040           SET WS-INCOMPLETE-468 TO TRUE                          
T32040         END-IF                                                   
T32040      ELSE                                                        
T32040******BOTH GAS AND ELECTRIC                                       22340000
T32040         IF WS-BILL-CTRG >= 11 AND WS-BILL-CTRE < 11              
T32040           SET WS-INCOMPLETE-468 TO TRUE                          
T32040         END-IF                                                   
T32040         IF WS-BILL-CTRG < 11 AND WS-BILL-CTRE < 11               
T32040           SET WS-INCOMPLETE-468 TO TRUE                          
T32040         END-IF                                                   
T32040      END-IF                                                      
T32040******IF THE BACKFILL LOGIC ABOVE DIDN'T FIND A REV MTH IN 12TH   22340000
T32040******OCCURANCE,IT'S AN INCOMPLETE SET( EMC ACCTS)                22340000
T32040      IF WS-BD-REVENUE-MONTH(12) = 0                              
T32040         SET WS-INCOMPLETE-468 TO TRUE                            
T32040      END-IF                                                      
T34391******SEASONAL ACOUNT                                             22340000
T34391       PERFORM 5830-CHECK-FOR-SEAS THRU 5830-EXIT                 
T34391       IF WS-SEASONAL-YES                                         
T34391         SET WS-INCOMPLETE-468 TO TRUE                            
T34391       END-IF                                                     
T34391       SET WS-SEASONAL-NO  TO TRUE                                
T32040     END-IF.                                                      
                                                                        
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00694 5005-LOAD-TAX-RATES.                                             
      ** LOAD TAX RATES FROM CURRENT BILL                               21940000
              PERFORM VARYING WS-RM-INDX FROM 1 BY 1                    
                        UNTIL WS-RM-INDX > 12                           
                 MOVE WS-STATE-TX-RATE-CALC (WS-BILLING-INDX)           
                   TO WS-BD-STATE-TAX-RATE (WS-RM-INDX WS-IC-INDX)      
                 MOVE WS-FRANCHISE-TX-RATE-CALC (WS-BILLING-INDX)       
                   TO WS-BD-CITY-TAX-RATE (WS-RM-INDX WS-IC-INDX)       
              END-PERFORM.                                              
P00694 5005-EXIT.                                                       
            EXIT.                                                       
                                                                        
P00694 5006-LOAD-UM-BILL-AMT.                                           
      ** LOAD UNMETERED BILL AMOUNT (+ 2.5%) FROM CURRENT BILL          22030000
T23363     PERFORM 5550-DETERMINE-ELEC-AS-UNMTRD                        
T23363                          THRU 5550-EXIT                          
T23363     IF (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'U') OR         
T23363        (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'E'             
T23363        AND WS-ELEC-AS-UNMTRD) OR                                 
C33708        (WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) = 'G'             
C33708        AND WS-ELEC-AS-UNMTRD)                                    
              PERFORM VARYING WS-RM-INDX FROM 1 BY 1                    
                        UNTIL WS-RM-INDX > 12                           
T14869           MOVE WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX) TO          
T14869                WS-BD-AMT-BILL-ITEM (WS-RM-INDX WS-IC-INDX)       
              END-PERFORM                                               
           END-IF.                                                      
P00694 5006-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5010-LOAD-BG-DATA.                                               
           IF BG-REV-MTH-ORIG-BILL > ZERO                               
              MOVE BG-REV-MTH-ORIG-BILL TO WS-REVENUE-MONTH             
           ELSE                                                         
              MOVE BG-REVENUE-MONTH TO WS-REVENUE-MONTH                 
           END-IF                                                       
                                                                        
           SEARCH ALL WS-BD-REV-MONTH-ENTRY                             
              WHEN WS-BD-REVENUE-MONTH (WS-RM-INDX) = WS-REVENUE-MONTH  
                 SET WS-ICD-INDX TO 1                                   
                 SEARCH WS-IC-DATA                                      
                    AT END                                              
                       MOVE WS-TOO-MANY-ICS TO WS-WORK-MESSAGE          
                       PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT    
                    WHEN WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX)            
                          = SPACE                                       
      ** NO LONGER AN ACTIVE IC                                         23180000
                       CONTINUE                                         
                    WHEN WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX)            
                          = BG-CODE-UTIL-TYPE                           
                         AND WS-ICD-IC-NO (WS-ICD-INDX)                 
                          = BG-IC-NO                                    
                       PERFORM 5011-LOAD-TABLE-ENTRY THRU 5011-EXIT     
                 END-SEARCH                                             
           END-SEARCH.                                                  
      *                                                                 23270000
       5010-EXIT.                                                       
           EXIT.                                                        
      /                                                                 23300000
       5011-LOAD-TABLE-ENTRY.                                           
           SET WS-IC-INDX TO WS-ICD-INDX                                
           MOVE BG-BILL-NO TO WS-BD-BILL-NO (WS-RM-INDX WS-IC-INDX)     
           MOVE BG-BILL-ITEM-TIMESTMP                                   
             TO WS-BD-BILL-ITEM-TIMESTMP (WS-RM-INDX WS-IC-INDX)        
           MOVE BG-GAS-BASE-USE                                         
             TO WS-BD-GAS-BASE-USE (WS-RM-INDX WS-IC-INDX)              
           MOVE BG-WNA-FACTOR                                           
             TO WS-BD-WNA-FACTOR (WS-RM-INDX WS-IC-INDX)                
           MOVE BG-BTU-FACTOR                                           
             TO WS-BD-BTU-FACTOR (WS-RM-INDX WS-IC-INDX).               
T22742     MOVE BG-PRORATE-CD                                           
T22742       TO WS-BD-PRORATE-CD (WS-RM-INDX WS-IC-INDX).               
T25475     MOVE BG-AMT-STATE-TAX                                        
T25475       TO WS-BD-AMT-STATE-TAX (WS-RM-INDX WS-IC-INDX).            
                                                                        
P00694     IF CSR-DATABASE AND WS-COMPANY-NO-AT = '01'                  
P00694        PERFORM 5550-DETERMINE-ELEC-AS-UNMTRD THRU 5550-EXIT      
P00694        IF (BG-CODE-UTIL-TYPE = 'U') OR                           
P00694           (BG-CODE-UTIL-TYPE = 'E' AND WS-ELEC-AS-UNMTRD) OR     
P00694           (BG-CODE-UTIL-TYPE = 'G' AND WS-ELEC-AS-UNMTRD)        
P00694             CONTINUE                                             
P00694        ELSE                                                      
P00694           PERFORM 5012-BUILD-BUFFER-AMT-SCEG THRU 5012-EXIT      
P00694           MOVE BG-AMT-BILL-ITEM                                  
P00694             TO WS-BD-AMT-BILL-ITEM (WS-RM-INDX WS-IC-INDX)       
P00694                                                                  
P00694           IF BG-CODE-UTIL-TYPE = 'G'                             
P00694              ADD 1         TO WS-GAS-USAGE-MTHS                  
P00694              MOVE 'Y'      TO WS-GAS-SW                          
P00694           END-IF                                                 
P00694                                                                  
P00694           IF BG-CODE-UTIL-TYPE = 'E'                             
P00694              ADD 1         TO WS-ELEC-USAGE-MTHS                 
P00694              MOVE 'Y'      TO WS-ELEC-SW                         
P00694           END-IF                                                 
P00694                                                                  
P00694           IF CURR-MTH-BILL                                       
P00694              PERFORM 7030-GET-CUR-MTH-UNITS THRU 7030-EXIT       
P00694           ELSE                                                   
P00694              PERFORM 7025-GET-HIST-UNITS    THRU 7025-EXIT       
P00694           END-IF                                                 
P00694           MOVE CX-NO-UNITS                                       
P00694             TO WS-BD-ENERGY-UNITS (WS-RM-INDX WS-IC-INDX)        
P00694        END-IF                                                    
P00694     END-IF.                                                      
                                                                        
       5011-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00694**-------------------------------------------------------                 
P00694** INCLUDE BUFFER                                                         
P00694** R - RESIDENTIAL CUSTOMERS                                              
P00694** C - COMMERCIAL  CUSTOMERS                                              
P00694**-------------------------------------------------------                 
P00694 5012-BUILD-BUFFER-AMT-SCEG.                                      
P00694     IF BG-CODE-UTIL-TYPE = 'E'                                   
P00694        EVALUATE WS-ACCOUNT-TYPE-CODE-AT                          
P00694           WHEN 'R'                                               
P00694              COMPUTE BG-AMT-BILL-ITEM ROUNDED =                  
P00694                 BG-AMT-BILL-ITEM * (1 + WS-PCT-RESRATEINCR-ELEC) 
P00694              END-COMPUTE                                         
P00694              MOVE WS-PCT-RESRATEINCR-ELEC                        
P00694                TO WS-PCT-ESTRATEINCR-ELEC                        
                                                                        
P00694           WHEN 'C'                                               
P00694              COMPUTE BG-AMT-BILL-ITEM ROUNDED =                  
P00694                 BG-AMT-BILL-ITEM * (1 + WS-PCT-COMRATEINCR-ELEC) 
P00694              END-COMPUTE                                         
P00694              MOVE WS-PCT-COMRATEINCR-ELEC                        
P00694                TO WS-PCT-ESTRATEINCR-ELEC                        
P00694        END-EVALUATE                                              
P00694     ELSE                                                         
P00694        EVALUATE WS-ACCOUNT-TYPE-CODE-AT                          
P00694            WHEN 'R'                                              
P00694              COMPUTE BG-AMT-BILL-ITEM ROUNDED =                  
P00694                 BG-AMT-BILL-ITEM * (1 + WS-PCT-RESRATEINCR-GAS)  
P00694              END-COMPUTE                                         
P00694              MOVE WS-PCT-RESRATEINCR-GAS                         
P00694                TO WS-PCT-ESTRATEINCR-GAS                         
                                                                        
P00694            WHEN 'C'                                              
P00694              COMPUTE BG-AMT-BILL-ITEM ROUNDED =                  
P00694                 BG-AMT-BILL-ITEM * (1 + WS-PCT-COMRATEINCR-GAS)  
P00694              END-COMPUTE                                         
P00694              MOVE WS-PCT-COMRATEINCR-GAS                         
P00694                TO WS-PCT-ESTRATEINCR-GAS                         
P00694        END-EVALUATE                                              
P00694     END-IF.                                                      
P00694 5012-EXIT.                                                       
P00694      EXIT.                                                       
      /                                                                 23460000
       5100-PROCESS-EXCEPTION.                                          
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
              PERFORM 9999-BAIL-OUT THRU 9999-EXIT                      
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
              MOVE WS-WORK-MESSAGE                                      
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
              SET WS-WQ-MESSAGE-SET TO TRUE                             
              MOVE SPACE TO WS-EXCEPTION-CODE-WQ                        
           END-IF.                                                      
      *                                                                 23610000
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /***************************************************************  23650000
      **    5500-CALC-UTILITY-CHARGES.                              **  23660000
      ** THIS PROCEDURE EXECUTES THE CALC MODULE FOR EACH OCCURRANCE**  23670000
      ** IN THE HISTORY TABLE.                                      **  23680000
      **                                                            **  23690000
      ****************************************************************  23700000
       5500-CALC-UTILITY-CHARGES.                                       
      ********************************************************          23720000
      ** SAVE OFF VALUES THAT WILL BE LOST ON THE CALL TO               23730000
      ** SCSCA107, THEN RESTORE LATER                                   23740000
      ********************************************************          23750000
           MOVE WS-BILLING-CALC-WORK  TO WS-HOLD-CALC-WORK.             
           MOVE WS-BILLING-COMPONENT  TO WS-HOLD-BC-DATA.               
           MOVE WS-BILLING-ADJUSTMENT TO WS-HOLD-BA-DATA.               
           MOVE WS-BILL-CNTR-HIST-BX  TO WS-HOLD-BX-DATA.               
P00496     MOVE WS-BILL-BSLN-CNTR-LN  TO WS-HOLD-LN-DATA.               
P00496     MOVE WS-BILL-BSLN-HIST-LO  TO WS-HOLD-LO-DATA.               
C34569     MOVE WS-BILL-DET-BT        TO WS-HOLD-BT-DATA.               
                                                                        
           PERFORM VARYING WS-ICD-INDX FROM 1 BY 1                      
                     UNTIL WS-ICD-INDX > 4                              
A02094       IF WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX) NOT = SPACE         
              SET WS-IC-INDX TO WS-ICD-INDX                             
T17859        SET WS-ICD-HIST-INDX TO WS-ICD-INDX                       
T17859        MOVE WS-ICD-NO-MONTHS (WS-ICD-HIST-INDX) TO               
T17859               WS-HOLD-NO-MONTHS (WS-ICD-INDX)                    
C28085        MOVE 'N'             TO WS-FUTURE-BILL-HOOK               
T33004        MOVE 'N'             TO WS-EPP-ANNIV-PROJ-COST-FL         
                                                                        
                                                                        
T32040* MOVED INLINE PERFORM TO A SEPARATE PARA BELOW                   24900000
T32040* SO THAT THE SAME PERFORM CAN BE CALLED WITH DIFFERENT WS-RM-INDX24900000
T32040        IF WS-MONITOR-EPP-FLAG  = 'Y'                             
T32040          AND  WS-COMPLETE-468                                    
T32040          SET WS-RM-INDX TO 12                                    
T32040          PERFORM 5711-PERFM-PASS-AREA THRU 5711-EXIT             
T32040             VARYING WS-RM-INDX FROM 12 BY -1                     
T32040               UNTIL WS-RM-INDX = WS-NO-OF-EPP-MONTHS             
T32040        ELSE                                                      
                                                                        
                 PERFORM 5711-PERFM-PASS-AREA THRU 5711-EXIT            
                     VARYING WS-RM-INDX FROM 1 BY 1                     
T17859               UNTIL WS-RM-INDX > WS-HOLD-NO-MONTHS (WS-ICD-INDX) 
T17859                                                                  
T32040        END-IF                                                    
              ADD WS-ICD-TOTAL (WS-ICD-INDX) TO EPP-TOTAL               
A02094       END-IF                                                     
           END-PERFORM.                                                 
                                                                        
P00694     PERFORM 5510-GET-BUFFERS    THRU 5510-EXIT.                  
P00694     PERFORM 5520-CALC-FINAL-BBP THRU 5520-EXIT.                  
                                                                        
      ********************************************************          24800000
      * RESTORE DATA FROM CURRENT BILL                       *          24810000
      ********************************************************          24820000
           MOVE WS-HOLD-CALC-WORK     TO WS-BILLING-CALC-WORK.          
           MOVE WS-HOLD-BC-DATA       TO WS-BILLING-COMPONENT.          
           MOVE WS-HOLD-BA-DATA       TO WS-BILLING-ADJUSTMENT.         
           MOVE WS-HOLD-BX-DATA       TO WS-BILL-CNTR-HIST-BX.          
P00496     MOVE WS-HOLD-LN-DATA       TO WS-BILL-BSLN-CNTR-LN.          
P00496     MOVE WS-HOLD-LO-DATA       TO WS-BILL-BSLN-HIST-LO.          
C34569     MOVE WS-HOLD-BT-DATA       TO WS-BILL-DET-BT.                
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00694**---------------------------------------------------------       24870000
P00694** ACCUMULATE AMOUNTS FROM ICD-DATA FOR MONTHLY MONITORING        24870000
P00694**---------------------------------------------------------       24870000
P00694 5505-GET-MON-BBP-AMT.                                            
P00694     PERFORM VARYING WS-ICD-INDX FROM 1 BY 1                      
P00694               UNTIL WS-ICD-INDX > 4                              
P00694       IF WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX) NOT = SPACE         
P00694          SET WS-IC-INDX TO WS-ICD-INDX                           
P00694          SET WS-ICD-HIST-INDX TO WS-ICD-INDX                     
P00694          MOVE WS-ICD-NO-MONTHS (WS-ICD-HIST-INDX) TO             
P00694               WS-HOLD-NO-MONTHS (WS-ICD-INDX)                    
P00694          PERFORM VARYING WS-RM-INDX FROM 12 BY -1                
P00694                  UNTIL WS-RM-INDX = WS-NO-OF-EPP-MONTHS          
P00694             ADD WS-BD-AMT-BILL-ITEM (WS-RM-INDX WS-IC-INDX)      
P00694              TO WS-ICD-TOTAL (WS-ICD-INDX)                       
P00694          END-PERFORM                                             
P00694          ADD WS-ICD-TOTAL (WS-ICD-INDX) TO EPP-TOTAL             
P00694       END-IF                                                     
P00694     END-PERFORM.                                                 
P00694 5505-EXIT.                                                       
P00694      EXIT.                                                       
                                                                        
P00694**-----------------------------------------------------           24870000
P00694** ACCUMULATE AMOUNTS FROM ICD-DATA FOR ANNIVERSARY               24870000
P00694**-----------------------------------------------------           24870000
P00694 5506-GET-ANN-BBP-AMT.                                            
P00694     PERFORM VARYING WS-ICD-INDX FROM 1 BY 1                      
P00694               UNTIL WS-ICD-INDX > 4                              
P00694       IF WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX) NOT = SPACE         
P00694          SET WS-IC-INDX TO WS-ICD-INDX                           
P00694          SET WS-ICD-HIST-INDX TO WS-ICD-INDX                     
P00694          MOVE WS-ICD-NO-MONTHS (WS-ICD-HIST-INDX) TO             
P00694               WS-HOLD-NO-MONTHS (WS-ICD-INDX)                    
P00694          PERFORM VARYING WS-RM-INDX FROM 1 BY 1 UNTIL            
P00694                  WS-RM-INDX > WS-HOLD-NO-MONTHS (WS-ICD-INDX)    
P00694             ADD WS-BD-AMT-BILL-ITEM (WS-RM-INDX WS-IC-INDX)      
P00694              TO WS-ICD-TOTAL (WS-ICD-INDX)                       
P00694          END-PERFORM                                             
P00694          ADD WS-ICD-TOTAL (WS-ICD-INDX) TO EPP-TOTAL             
P00694       END-IF                                                     
P00694     END-PERFORM.                                                 
P00694 5506-EXIT.                                                       
P00694      EXIT.                                                       
P00694                                                                  
P00694**-----------------------------------------------------------     24870000
P00694** BUILD BUFFERS TO DISPLAY IN BH REMARKS TO DISPLAY IN PANEL     24870000
P00694**-----------------------------------------------------------     24870000
P00694 5510-GET-BUFFERS.                                                
C27553                                                                  
C27553     IF WS-ELEC-SW = 'Y' AND WS-GAS-SW = 'Y'                      
C27553        IF WS-ELEC-USAGE-MTHS >= 12 AND WS-GAS-USAGE-MTHS >= 12   
C27553           MOVE 'Y'                 TO WS-HIST-DATA-SUFFICIENT    
C27553        END-IF                                                    
C26164        MOVE WS-PCT-ESTRATEINCR-ELEC TO WS-ELEC-BUFFER            
C26164        MOVE WS-PCT-ESTRATEINCR-GAS  TO WS-GAS-BUFFER             
C27553     ELSE                                                         
C27553        IF WS-ELEC-SW = 'Y'                                       
C27553           IF WS-ELEC-USAGE-MTHS >= 12                            
C27553              MOVE 'Y'              TO WS-HIST-DATA-SUFFICIENT    
C27553           END-IF                                                 
C26164           MOVE WS-PCT-ESTRATEINCR-ELEC TO WS-ELEC-BUFFER         
C27553        ELSE                                                      
C27553           IF WS-GAS-SW = 'Y'                                     
C27553              IF WS-GAS-USAGE-MTHS >= 12                          
C27553                 MOVE 'Y'           TO WS-HIST-DATA-SUFFICIENT    
C27553              END-IF                                              
C26164              MOVE WS-PCT-ESTRATEINCR-GAS TO WS-GAS-BUFFER        
C27553           END-IF                                                 
C27553        END-IF                                                    
C27553     END-IF.                                                      
P00694 5510-EXIT.                                                       
P00694     EXIT.                                                        
                                                                        
      ********************************************************          24560000
      * CALCULATE FINAL EPP TOTAL FROM ALL OTHER TOTALS.     *          24570000
      ********************************************************          24580000
P00694 5520-CALC-FINAL-BBP.                                             
T17859                                                                  
T17859     PERFORM VARYING WS-ICD-INDX FROM 1 BY 1                      
T17859               UNTIL WS-ICD-INDX > 4                              
A02094      IF WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX) NOT = SPACE          
P00694         SET WS-IC-INDX TO WS-ICD-INDX                            
P00694         SET WS-ICD-HIST-INDX TO WS-ICD-INDX                      
P00694         MOVE WS-ICD-NO-MONTHS (WS-ICD-HIST-INDX) TO              
P00694                WS-HOLD-NO-MONTHS (WS-ICD-INDX)                   
T17859                                                                  
T26188         IF  WS-HOLD-NO-MONTHS (WS-ICD-INDX)    <  12             
T26188         AND WS-BD-BILL-NO (12 WS-IC-INDX)  NOT =  ZERO           
T26188             MOVE 12 TO WS-HOLD-NO-MONTHS (WS-ICD-INDX)           
T26188         END-IF                                                   
T32040                                                                  
T32040         IF WS-MONITOR-EPP-FLAG  = 'Y'                            
T32040            COMPUTE WS-EPP-AMT = WS-ICD-TOTAL (WS-ICD-INDX) /     
T32040                                  WS-NO-OF-MONTHS-HELD            
T32040         ELSE                                                     
T17859            COMPUTE WS-EPP-AMT = WS-ICD-TOTAL (WS-ICD-INDX) /     
T17859                                  WS-HOLD-NO-MONTHS (WS-ICD-INDX) 
T32040         END-IF                                                   
                                                                        
T17859         COMPUTE WS-IC-EPP-TOTAL = WS-IC-EPP-TOTAL + WS-EPP-AMT   
T17859         MOVE WS-IC-EPP-TOTAL TO EPP-FINAL-TOTAL                  
A02094      END-IF                                                      
T17859     END-PERFORM                                                  
T32040*                                                                         
P00694**-- TRANS BALANCE PER MONTH + BBP AMT                                    
T32040     IF WS-MONITOR-EPP-FLAG  = 'Y'                                
T32040        COMPUTE WS-IC-EPP-TOTAL = WS-IC-EPP-TOTAL +               
T32040                  WS-EPP-EXCPTN-BAL / WS-NO-OF-MONTHS-HELD        
T32040        MOVE WS-IC-EPP-TOTAL TO EPP-FINAL-TOTAL                   
T32040     END-IF                                                       
T32040*                                                                 24750000
P00694**-- ROUNDING IT TO NEXT DOLLAR                                   24750000
T17859     IF WS-IC-EPP-TOTAL > EPP-FINAL-TOTAL                         
T17859        ADD +1 TO EPP-FINAL-TOTAL                                 
T10583     END-IF .                                                     
                                                                        
P00694 5520-EXIT.                                                       
P00694     EXIT.                                                        
                                                                        
      /***************************************************************  24910000
T16496**    5550-DETERMINE-ELEC-AS-UNMTRD.                          **  24920000
T16496** THIS PROCEDURE WILL IDENTIFY UNMETERED RATES WITH A CODE   **  24930000
T16496** UTIL TYPE OF 'E'.                                          **  24940000
      ****************************************************************  24950000
T16496 5550-DETERMINE-ELEC-AS-UNMTRD.                                   
T16496     SET WS-ELEC-NOT-AS-UNMTRD TO TRUE.                           
                                                                        
T16496     PERFORM VARYING WS-CUST-PLAN-INDX FROM 1 BY 1                
SCA006           UNTIL WS-ELEC-AS-UNMTRD OR 
                       WS-CUST-PLAN-INDX > WS-CP-MAX-ENTRY OR 
                       WS-ACCOUNT-NO-CP(WS-CUST-PLAN-INDX) = ZEROS              
                                                                        
T16496*       ONLY CONSIDER THOSE WITH THE SAME IC NO.                  25040000
T16496        IF WS-ICD-IC-NO (WS-ICD-INDX) =                           
T16496                WS-IC-NO-CP (WS-CUST-PLAN-INDX) AND               
T16496           WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX) =                  
T16496                WS-CODE-UTIL-TYPE-CP (WS-CUST-PLAN-INDX)          
T16496                  SET WS-ELEC-AS-UNMTRD TO TRUE                   
T16496        END-IF                                                    
T16496     END-PERFORM.                                                 
T16496 5550-EXIT.                                                       
T16496     EXIT.                                                        
                                                                        
      /***************************************************************  25150000
      **    5600-CALL-SCSCA107.                                     **  25160000
      ** THIS PROCEDURE WILL CALL THE MODULE SCSCA107 FOR THE       **  25170000
      ** CALCULATION OF A BILL WITH THE CURRENT RATES. THIS IS TO   **  25180000
      ** THE AMOUNT FOR EPP.                                        **  25190000
      ****************************************************************  25200000
       5600-CALL-SCSCA107.                                              
T22520     IF WS-181-SW  =  'Y'                                         
T34243     OR  WS-180-SW = 'Y'                                          
T22520        MOVE ZERO   TO  WS-BC-AMT-BILL-ITEM-BG                    
T22520     ELSE                                                         
C33924        INITIALIZE WS-BC-BILL-ADJUSTMNT                           
P00251                   WS-BC-VOL-DAILY-ND                             
P00257                   WS-BILL-CALC-DETAIL-X                          
P00496                   WS-BILL-BSLN-CNTR-LN                           
P00496                   WS-BILL-BSLN-HIST-LO                           
              CALL SCSCA107 USING LS-PCSCA100-COMM-AREA                 
                               WS-BILLING-CALC-WORK                     
                               WS-BILLING-COMPONENT                     
                               WS-BILLING-ADJUSTMENT                    
                               WS-BILL-CALC-BG                          
                               WS-BILL-CALC-CX                          
                               WS-BILL-CALC-UC                          
                               WS-BILL-CALC-FH                          
                               WS-BILL-CONTRACT-BK                      
                               WS-FIXED-FCTR-TABLE-FF                   
                               WS-BILL-CNTR-HIST-BX                     
                               WS-PEAK-HIST-PH                          
                               WS-INTERRUPT-ACCT-IP                     
                               WS-MTRD-ENVRNMT-TABLE-MN                 
                               WS-STANDBY-GEN-SE                        
                               WS-INTERRUPT-IR                          
                               WS-HOLD-CX-DATA                          
                               WS-HOLD-BC-DATA                          
                               WS-HOLD-BA-DATA                          
                               WS-BILLING-WQ-ITEMS-WF                   
                               WS-REFUND-RN                             
T23529                         WS-ACCOUNT-AT                            
C33924                         WS-BC-BILL-ADJUSTMNT                     
C34569                         WS-BC-ACCT-RTPK-AGR-DF                   
C34569                         WS-BC-FIXED-FCTR-FF                      
C34569                         WS-BC-BILL-DET-BT                        
I00177                         WS-CWS22B-MAX-TBL-LIMITS                 
P00257                         WS-BILL-CALC-DETAIL-X                    
P00251                         WS-BC-VOL-DAILY-ND                       
P00496                         WS-BILL-BSLN-CNTR-LN                     
P00496                         WS-BILL-BSLN-HIST-LO                     
P00496                         WS-UTL-BILL-REL-TABLE-UR                 
VKSACT                         WS-INTERRUPT-NZ                          
P00496                         WS-CNSMPTN-HOURLY                        
T22520     END-IF.                                                      
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /***************************************************************  25520000
      **    5700-BUILD-PASS-AREA.                                   **  25530000
      **                                                            **  25540000
      ** THE CURRENT BILL (I.E., THE ONE THAT IS BEING CALCULATED   **  25550000
      ** THIS RUN) IS RECALCED ALONG WITH HISTORICAL BILLS SINCE    **  25560000
      ** IT COULD BE A PRIOR MONTH REBILL.  THIS ENSURES THAT ALL   **  25570000
      ** BILLS ARE CALCULATED FOR CURRENT RATES AND FACTORS.  DATA  **  25580000
      ** FOR CURRENT BILL COMES FROM BILL EXTRACT; HISTORICAL DATA  **  25590000
      ** IS RETRIEVED FROM THE DATABASE.                            **  25600000
      **                                                            **  25610000
      ****************************************************************  25620000
       5700-BUILD-PASS-AREA.                                            
           INITIALIZE WS-BILL-CALC-BG                                   
                      WS-BILL-CALC-CX                                   
                      WS-BILL-CALC-UC                                   
                      WS-BILL-CALC-FH                                   
                      WS-BILLING-COMPONENT                              
                      WS-BILLING-ADJUSTMENT                             
                      WS-BILLING-CALC-WORK                              
C34569                WS-BC-BILL-DET-BT                                 
P00251                WS-BC-VOL-DAILY-ND                                
C34569     IF CSR-DATABASE OR (SEB-DATABASE                             
C34569        AND WS-CALC-EPP-ANNIV-FLG NOT = 'Y' )                     
C34569        OR  (SEB-DATABASE AND                                     
C34569            WS-RATE-CALC-TYPE-CD-BT (WS-BDET-INDX) NOT = '02')    
C34569          INITIALIZE  WS-BC-FIXED-FCTR-FF                         
C34569                                                                  
C34569     END-IF.                                                      
                                                                        
           PERFORM 5710-MOVE-BI-BG-FIELDS THRU 5710-EXIT.               
                                                                        
           IF WS-ICD-CURR-BG (WS-ICD-INDX) = WS-RM-INDX                 
              SET CX-INDX TO 1                                          
T22741        MOVE 'A'        TO WS-BC-CODE-BILL-STATUS-BI              
              PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1               
T14555                  UNTIL WS-CNSMPTN-INDX > 200                     
                           OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) = ZERO 
                 IF WS-BILL-NO-CX (WS-CNSMPTN-INDX)                     
                         = WS-BD-BILL-NO (WS-RM-INDX WS-IC-INDX)        
                       AND WS-CODE-UTIL-TYPE-CX (WS-CNSMPTN-INDX)       
                         = WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX)          
                       AND WS-IC-NO-CX (WS-CNSMPTN-INDX)                
                         = WS-ICD-IC-NO (WS-ICD-INDX)                   
                       AND WS-BILL-ITEM-TIMESTMP-CX (WS-CNSMPTN-INDX)   
                         = WS-BD-BILL-ITEM-TIMESTMP                     
                             (WS-RM-INDX WS-IC-INDX)                    
                    PERFORM 5740-LOAD-CX-FROM-BE THRU 5740-EXIT         
                    SET CX-INDX UP BY 1                                 
                 END-IF                                                 
              END-PERFORM                                               
                                                                        
              SET UC-INDX TO 1                                          
              PERFORM VARYING WS-UNMTRD-CNSMPTN-INDX FROM 1 BY 1        
I00177                  UNTIL WS-UNMTRD-CNSMPTN-INDX >                  
I00177                        WS-UC-MAX-ENTRY                           
                           OR WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX) 
                                   = ZERO                               
                 IF WS-BILL-NO-UC (WS-UNMTRD-CNSMPTN-INDX)              
                         = WS-BD-BILL-NO (WS-RM-INDX WS-IC-INDX)        
                       AND WS-CODE-UTIL-TYPE-UC (WS-UNMTRD-CNSMPTN-INDX)
                         = WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX)          
                       AND WS-IC-NO-UC (WS-UNMTRD-CNSMPTN-INDX)         
                         = WS-ICD-IC-NO (WS-ICD-INDX)                   
                       AND WS-BILL-ITEM-TIMESTMP-UC                     
                           (WS-UNMTRD-CNSMPTN-INDX)                     
                         = WS-BD-BILL-ITEM-TIMESTMP                     
                             (WS-RM-INDX WS-IC-INDX)                    
                    PERFORM 5750-LOAD-UC-FROM-BE THRU 5750-EXIT         
                    SET UC-INDX TO 1                                    
                 END-IF                                                 
              END-PERFORM                                               
           ELSE                                                         
A02036       IF CX-BILL-ITEM-TIMESTMP > SPACES                          
                                                                        
              PERFORM 7100-OPEN-CNSMPTN-HIST THRU 7100-EXIT             
              IF SQLCODE = SUCCESSFUL-CALL                              
                 SET CX-INDX TO 1                                       
C22796           MOVE 'A'        TO WS-BC-CODE-BILL-STATUS-BI           
                 PERFORM UNTIL SQLCODE = NOT-FOUND                      
T14555                      OR CX-INDX > 200                            
                    PERFORM 7110-FETCH-CNSMPTN-HIST THRU 7110-EXIT      
                    IF SQLCODE = SUCCESSFUL-CALL                        
                       PERFORM 5720-MOVE-CX-FIELDS THRU 5720-EXIT       
                       SET CX-INDX UP BY 1                              
                    END-IF                                              
                 END-PERFORM                                            
                 PERFORM 7120-CLOSE-CNSMPTN-HIST THRU 7120-EXIT         
              END-IF                                                    
                                                                        
T34243* ADDED WS-180-SW  TO THE IF CONDITION                                    
T22520        IF WS-181-SW  =  'N'  AND WS-180-SW = 'N'                 
                  PERFORM 7200-OPEN-UM-CNSMPT-HIST THRU 7200-EXIT       
                  IF SQLCODE = SUCCESSFUL-CALL                          
                     SET UC-INDX TO 1                                   
                     PERFORM UNTIL SQLCODE = NOT-FOUND                  
I00177                          OR UC-INDX > WS-UM-MAX-ENTRY            
                        PERFORM 7210-FETCH-UM-CNSMPT-HIST THRU 7210-EXIT
                        IF SQLCODE = SUCCESSFUL-CALL                    
                           PERFORM 5730-MOVE-UC-FIELDS THRU 5730-EXIT   
                           SET UC-INDX UP BY 1                          
                        END-IF                                          
                     END-PERFORM                                        
                    PERFORM 7220-CLOSE-UM-CNSMPT-HIST THRU 7220-EXIT    
                  END-IF                                                
T22520        END-IF                                                    
A02036       END-IF                                                     
           END-IF.                                                      
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /***************************************************************  26500000
      **    5710-MOVE-BI-BG-FIELDS                                      26510000
      **                                                            **  26520000
      ****************************************************************  26530000
       5710-MOVE-BI-BG-FIELDS.                                          
           MOVE ZEROES TO WS-BC-ELEC-CONTRACT-DEMAND.                   
           MOVE LS-INPUT-DATE TO WS-BC-CALC-DATE                        
                                 WS-BC-CURRENT-DATE.                    
           MOVE 'I'           TO WS-BC-PRORATE-OVERRIDE-IND.            
           MOVE WS-ACCOUNT-NO-AT TO WS-BC-ACCOUNT-NO-BG                 
                                    CX-ACCOUNT-NO                       
                                    UC-ACCOUNT-NO                       
           MOVE WS-BD-BILL-NO (WS-RM-INDX WS-IC-INDX)                   
             TO WS-BC-BILL-NO-BG                                        
                CX-BILL-NO                                              
                UC-BILL-NO                                              
T22742     MOVE WS-BD-PRORATE-CD (WS-RM-INDX WS-IC-INDX)                
T22742       TO WS-BC-PRORATE-CD-BG.                                    
           MOVE WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX)                     
             TO WS-BC-CODE-UTIL-TYPE-BG                                 
                CX-CODE-UTIL-TYPE                                       
                UC-CODE-UTIL-TYPE                                       
C28085     IF  WS-BD-BILL-ITEM-TIMESTMP (WS-RM-INDX WS-IC-INDX)         
C28085         EQUAL SPACES OR LOW-VALUES                               
C28085         MOVE 'Y'      TO WS-FUTURE-BILL-HOOK                     
C28085     END-IF                                                       
C28085*                                                                         
C28085     IF WS-BC-CODE-UTIL-TYPE-BG = 'G' AND                         
C28085        WS-FUTURE-BILL-HOOK = 'N'                                 
C28085        ADD 1         TO WS-GAS-USAGE-MTHS                        
C28085        MOVE 'Y'      TO WS-GAS-SW                                
C28085     END-IF                                                       
C28085*                                                                 26735004
C28085     IF WS-BC-CODE-UTIL-TYPE-BG = 'E'  AND                        
C28085        WS-FUTURE-BILL-HOOK = 'N'                                 
C28085        ADD 1         TO WS-ELEC-USAGE-MTHS                       
C28085        MOVE 'Y'      TO WS-ELEC-SW                               
C28085     END-IF                                                       
C28085*                                                                 26739104
           MOVE WS-ICD-IC-NO (WS-ICD-INDX)                              
             TO WS-BC-IC-NO-BG                                          
                CX-IC-NO                                                
                UC-IC-NO                                                
I00177                                                                  
I00177     SET UT-MATCH-NOT-FOUND TO TRUE                               
I00177                                                                  
I00177     PERFORM VARYING WS-UTIL-INDX FROM 1 BY 1                     
SCA006       UNTIL UT-MATCH-FOUND OR 
                   WS-UTIL-INDX > 40 OR 
                   WS-ACCOUNT-NO-UT (WS-UTIL-INDX) = ZERO                       
I00177          IF WS-ACCOUNT-NO-UT (WS-UTIL-INDX) =                    
I00177             WS-BC-ACCOUNT-NO-BG AND                              
I00177             WS-CODE-UTIL-TYPE-UT (WS-UTIL-INDX) =                
I00177             WS-BC-CODE-UTIL-TYPE-BG AND                          
I00177             WS-IC-NO-UT (WS-UTIL-INDX) =                         
I00177             WS-BC-IC-NO-BG                                       
I00177             SET UT-MATCH-FOUND TO TRUE                           
I00177             MOVE WS-CODE-MTR-READ-FREQ-UT (WS-UTIL-INDX)         
I00177               TO WS-BC-CODE-MTR-READ-FREQ-BG                     
I00177          END-IF                                                  
I00177     END-PERFORM                                                  
                                                                        
           MOVE WS-BD-BILL-ITEM-TIMESTMP (WS-RM-INDX WS-IC-INDX)        
             TO WS-BC-BILL-ITEM-TIMESTMP-BG                             
                CX-BILL-ITEM-TIMESTMP                                   
                UC-BILL-ITEM-TIMESTMP                                   
           MOVE WS-BD-GAS-BASE-USE (WS-RM-INDX WS-IC-INDX)              
             TO WS-BC-GAS-BASE-USE-BG                                   
T10045     MOVE ZERO                                                    
             TO WS-BC-WNA-FACTOR-BG                                     
           MOVE WS-BD-BTU-FACTOR (WS-RM-INDX WS-IC-INDX)                
             TO WS-BC-BTU-FACTOR-BG                                     
           MOVE WS-ICD-CODE-REVENUE-CLASS (WS-ICD-INDX)                 
             TO WS-BC-CODE-REVENUE-CLASS-BG                             
                                                                        
T23339     IF SEB-DATABASE                                              
C34569       IF WS-CALC-EPP-ANNIV-FLG  = 'Y' AND                        
C34569          WS-RATE-CALC-TYPE-CD-BT (WS-BDET-INDX) = '02'           
C34569***INCREMENT THE REV. MTH PASSED TO CALC MODULE IF ITS SEB ANNIV          
P00211           MOVE 12 TO  WS-BC-DURATION-REMAIN-NO-FF (WS-ICD-INDX)  
C34569           ADD 1 TO WS-DUMMY-MTH-CTR                              
C34569           IF WS-DUMMY-MTH-CTR = 1                                
C34569               INITIALIZE  WS-BC-FIXED-FCTR-FF                    
C34569               MOVE LS-CURR-REVENUE-MONTH TO WS-DUMMY-REV-MTH     
C34569* PASS OPTION-CD AND GET THERM PRICE JUST ONCE -FIRST TIME                
C34569               MOVE WS-OPTION-CD-BT (WS-BDET-INDX)                
C34569                                        TO WS-IN-OPTION-CD        
C34569               MOVE WS-ACCOUNT-NO-BG (WS-ICD-INDX)                
C34569                                        TO WS-IN-ACCOUNT-NO       
C34569               MOVE WS-CODE-UTIL-TYPE-BG (WS-ICD-INDX)            
C34569                                        TO WS-IN-CODE-UTIL-TYPE   
C34569               MOVE WS-IC-NO-BG (WS-ICD-INDX)                     
C34569                                        TO WS-IN-IC-NO            
C34569                                                                  
I01119               MOVE WS-PGRMNAME         TO WS-CPD00328-CALLING-PGM
C34569               MOVE SPACES              TO ABEND-FUNCTION         
                                          WS-OPTION-CD-BT(WS-BDET-INDX) 
P00211               MOVE 'Y'      TO WS-GET-PEND-PRICE-SW-328          
C34569               CALL SCSCA328  USING  CWS00328-FIELDS              
C34569                                    ,WS-RESULT-TABLE              
C34569                                    ,ABEND-FILE                   
C34569                                    ,RS-RETURN-CODE               
                                                                        
C34569               IF RS-RETURN-CODE NOT EQUAL ZERO                   
ACT027                 MOVE 'Z' TO WS-CODE-TEMP-BILL-AT                 
P00211                 MOVE WS-PRICE-ROUTINE-ERROR TO WS-WORK-MESSAGE   
P00211                 PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT    
P00211                 GO TO 9999-BAIL-OUT                              
P00211               END-IF                                             
                                                                        
P00211               IF WS-PEND-OPTN-EXIST-FL = 'Y'                     
P00211                 IF WS-PEND-THERM-PRICE > 0                       
P00211                   CONTINUE                                       
P00211                 ELSE                                             
P00211                   MOVE WS-PENDING-PRICE-ERROR TO WS-WORK-MESSAGE 
P00211                   PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT  
P00211                   GO TO 9999-BAIL-OUT                            
P00211                 END-IF                                           
P00211               ELSE                                               
P00396                 IF WS-BBP-ANNIV-PRICE > ZERO                     
C34569                   CONTINUE                                       
C34569                 ELSE                                             
C34569                   MOVE WS-THERM-PRICE-ERROR TO WS-WORK-MESSAGE   
C34569                   PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT  
C34569                   GO TO 9999-BAIL-OUT                            
P00211                 END-IF                                           
P00211               END-IF                                             
                                                                        
P00694               IF WS-BBP-PEND-CSC-AMT > 0                         
P00694                  MOVE WS-BBP-PEND-CSC-AMT TO WS-BBP-CSC-AMT      
P00694               END-IF                                             
P00694                                                                  
P00694               IF WS-BBP-CSC-AMT > ZERO                           
P00694                  MOVE WS-BBP-CSC-AMT TO WS-BBP-CSC-AMT-DISP      
P00694               ELSE                                               
P00694                 MOVE WS-CSC-AMT-ERROR TO WS-WORK-MESSAGE         
P00694                 PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT    
P00694                 GO TO 9999-BAIL-OUT                              
P00694               END-IF                                             
                                                                        
C34569               PERFORM 2750-MOVE-FF-FIELDS THRU 2750-EXIT         
P00211           END-IF                                                 
C34569                                                                  
C34569           COMPUTE WS-DUMMY-REV-MTH = WS-DUMMY-REV-MTH + 1        
C34569           IF WS-DUMMY-REV-MTH (5:2) = 13                         
C34569               MOVE 01 TO WS-DUMMY-REV-MTH (5:2)                  
C34569               MOVE WS-DUMMY-REV-MTH (1:4) TO WS-COMP-REV-YR      
C34569               COMPUTE WS-COMP-REV-YR = WS-COMP-REV-YR + 1        
C34569               MOVE WS-COMP-REV-YR TO  WS-DUMMY-REV-MTH (1:4)     
C34569           END-IF                                                 
                                                                        
C34569           MOVE WS-DUMMY-REV-MTH TO WS-BC-REVENUE-MONTH-BG        
C34569       END-IF                                                     
C34569     END-IF                                                       
C34569                                                                  
C34569**** TRANSFER RTPK AGR DATA FROM CWS1000B TO CWS0022B ****                
C34569                                                                  
C34569               INITIALIZE WS-BC-ACCT-RTPK-AGR-DF                  
C34569               SET WS-BC-RTPK-INDX  TO 1                          
ACT332               PERFORM VARYING WS-RTPK-INDX FROM 1 BY 1           
ACT332                     UNTIL WS-RTPK-INDX > 25                      
ACT332                     OR WS-ACCOUNT-NO-DF (WS-RTPK-INDX) = ZERO    
C34569                     PERFORM 2440-MOVE-DF-FIELDS THRU 2440-EXIT   
C34569                     SET  WS-BC-RTPK-INDX UP BY 1                 
C34569               END-PERFORM                                        
C34569****************************************                                  
                                                                        
           MOVE WS-ICD-RATE-PLAN-NO (WS-ICD-INDX)                       
                TO WS-BC-RATE-PLAN-NO-BG                                
C22796     MOVE WS-ICD-CODE-CURTAIL-PRTY (WS-ICD-INDX)                  
C22796       TO WS-BC-CODE-CURTAIL-PRTY-BG                              
RODFIX     MOVE WS-ICD-RT-PKG-OPT-SEQ-NO (WS-ICD-INDX)                  
RODFIX       TO WS-BC-RT-PKG-OPT-SEQ-NO-BG                              
           MOVE WS-COMPANY-NO-AT                                        
             TO WS-BC-COMPANY-NO-BG.                                    
T23332     MOVE WS-BD-REVENUE-MONTH (WS-RM-INDX)                        
T23332           TO WS-BC-REV-MTH-ORIG-BILL-BG.                         
T23339     IF (SEB-DATABASE AND                                         
C34569          WS-CALC-EPP-ANNIV-FLG  = 'Y' AND                        
C34569          WS-RATE-CALC-TYPE-CD-BT (WS-BDET-INDX) = '02')          
C34569              NEXT SENTENCE                                       
C34569     ELSE                                                         
T22796                MOVE LS-CURR-REVENUE-MONTH  TO                    
T22796                     WS-BC-REVENUE-MONTH-BG                       
C34569     END-IF.                                                      
T34990                                                                  
T34990                                                                  
T10045     MOVE LOW-VALUES                                              
T10045       TO WS-BC-DATE-ORIG-BILL-BG.                                
       5710-EXIT.                                                       
           EXIT.                                                        
                                                                        
T32040*                                                                 24900000
T32040****************************************************************  23650000
T32040** THIS PROCEDURE BUILDS PASS AREA AND CALL CALC ROUTINE      **  23670000
T32040** IN THE HISTORY TABLE FOR SEB AND PSNC                      **  23680000
T32040****************************************************************  23700000
T32040 5711-PERFM-PASS-AREA.                                            
           IF WS-ICD-CODE-UTIL-TYPE (WS-ICD-INDX) NOT = 'U'             
T23363        PERFORM 5550-DETERMINE-ELEC-AS-UNMTRD                     
T23363                       THRU 5550-EXIT                             
T23363        IF  WS-ELEC-AS-UNMTRD                                     
T23363           MOVE ZERO        TO RETURN-CODE                        
T23363        ELSE                                                      
T23363           PERFORM 5700-BUILD-PASS-AREA   THRU 5700-EXIT          
A03106                                                                  
A03106           IF CX-BILL-ITEM-TIMESTMP > SPACES                      
T23363              PERFORM 5600-CALL-SCSCA107     THRU 5600-EXIT       
A03106           END-IF                                                 
T23363        END-IF                                                    
                                                                        
T33004        IF WS-BC-AMT-BILL-ITEM-BG EQUAL ZERO AND                  
T33004           WS-COMPANY-NO-AT = '26'           AND                  
ACT134           CX-BILL-ITEM-TIMESTMP > SPACES                         
T33004           DISPLAY 'PSNC ACCT WITH ZERO AMT FOR BG : '            
T33004                                         WS-ACCOUNT-NO-AT         
T33004           DISPLAY 'BILL NO FOR PSNC ACCT WITH ZERO AMT : '       
T33004                                   WS-BC-BILL-NO-BG               
T33004           DISPLAY 'RETURNED PARAMETER FROM CPDCA107 : '          
T33004                                   WS-CALC-ERROR                  
T33004           SET WS-EPP-ANN-PRJ-CST-ERROR   TO TRUE                 
T33004        END-IF                                                    
                                                                        
              IF RETURN-CODE NOT = ZERO                                 
C30317            IF WS-CODE-EPP-OFFER = 'A'                            
C30317               MOVE 0             TO RETURN-CODE                  
C30317               MOVE 'N'           TO WS-HIST-DATA-SUFFICIENT      
C30317               GO TO 5500-EXIT                                    
C30317            ELSE                                                  
                     MOVE WS-CALC-ROUTINE-ERROR TO WS-WORK-MESSAGE      
                     PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT      
                     GO TO 9999-BAIL-OUT                                
C30317            END-IF                                                
              ELSE                                                      
                                                                        
P00694**----SUBTRACT EXIT FEE                                                   
                                                                        
P00694            IF SEB-DATABASE                                       
P00694               PERFORM VARYING FH-INDX FROM 1 BY 1                
P00694                 UNTIL FH-INDX > 200                              
P00694                    OR WS-BC-ACCOUNT-NO-FH (FH-INDX) = 0          
P00694                     IF WS-BC-FACTOR-ID-FH (FH-INDX) = 'EXIT FEE' 
P00694                        SUBTRACT WS-BC-FACTOR-FH (FH-INDX)        
P00694                            FROM WS-BC-AMT-BILL-ITEM-BG           
P00694                     END-IF                                       
P00694               END-PERFORM                                        
********-- EXTCREDTX is a credit factor which is subtracted in bill calc        
ACT275               PERFORM VARYING FH-INDX FROM 1 BY 1                
ACT275                 UNTIL FH-INDX > 200                              
ACT275                    OR WS-BC-ACCOUNT-NO-FH(FH-INDX) = 0           
ACT275                   IF (WS-BC-FACTOR-ID-FH (FH-INDX) = 'EXTCREDTX' 
ACT072                      OR WS-BC-FACTOR-ID-FH (FH-INDX) = 'LOYALTY')
ACT275                      ADD WS-BC-FACTOR-FH (FH-INDX)               
ACT275                       TO WS-BC-AMT-BILL-ITEM-BG                  
ACT275                   END-IF                                         
ACT275               END-PERFORM                                        
P00694            END-IF                                                
                                                                        
P00694**----STATE TAX INCLUSION                                                 
      **---'COMPANY 26' OR 'ELEC OR GAS AS UNMTRD' OR SEB ----                  
T23363              IF WS-ELEC-AS-UNMTRD                                
T23363                 COMPUTE                                          
T23363                   WS-BD-AMT-BILL-ITEM (WS-RM-INDX WS-IC-INDX)    
T23363                     ROUNDED                                      
T23363                   = ( WS-BD-AMT-BILL-ITEM                        
T23363                        (WS-RM-INDX WS-IC-INDX)                   
P00694                      * (1 + WS-BD-STATE-TAX-RATE                 
T23363                               (WS-RM-INDX WS-IC-INDX) ))         
P00694                 END-COMPUTE                                      
T23363              ELSE                                                
                       COMPUTE                                          
                          WS-BD-AMT-BILL-ITEM (WS-RM-INDX WS-IC-INDX)   
T16415                         ROUNDED                                  
                          = ( WS-BC-AMT-BILL-ITEM-BG                    
P00694                        * (1 + WS-BD-STATE-TAX-RATE               
                                       (WS-RM-INDX WS-IC-INDX) ))       
T23363              END-IF                                              
                                                                        
P00694**-------- ADD BUFFER TO GAS                                              
T16496            IF WS-ELEC-NOT-AS-UNMTRD                              
T31866               IF SEB-DATABASE                                    
T32040                    AND WS-MONITOR-EPP-FLAG = 'N'                 
C34569                  PERFORM 7575-GET-BUFF-FIXED-RATE THRU 7575-EXIT 
                     END-IF                                             
C26164               COMPUTE WS-BD-AMT-BILL-ITEM (WS-RM-INDX WS-IC-INDX)
C26164                 ROUNDED = (WS-BD-AMT-BILL-ITEM                   
C26164                            (WS-RM-INDX WS-IC-INDX) *             
P00694                               (1 + WS-PCT-ESTRATEINCR-GAS))      
C26164               END-COMPUTE                                        
                  END-IF                                                
              END-IF                                                    
           END-IF.                                                      
           ADD WS-BD-AMT-BILL-ITEM (WS-RM-INDX WS-IC-INDX)              
                   TO WS-ICD-TOTAL (WS-ICD-INDX).                       
T32040 5711-EXIT.                                                       
T32040         EXIT.                                                    
T32040                                                                  
      /***************************************************************  27292800
      **    5720-MOVE-CX-FIELDS.                                    **  27292900
      **                                                            **  27293000
      ****************************************************************  27294000
       5720-MOVE-CX-FIELDS.                                             
           MOVE CX-ACCOUNT-NO                                           
             TO WS-BC-ACCOUNT-NO-CX (CX-INDX)                           
           MOVE CX-BILL-NO                                              
             TO WS-BC-BILL-NO-CX (CX-INDX)                              
           MOVE CX-CODE-UTIL-TYPE                                       
             TO WS-BC-CODE-UTIL-TYPE-CX (CX-INDX)                       
           MOVE CX-IC-NO                                                
             TO WS-BC-IC-NO-CX (CX-INDX)                                
           MOVE CX-BILL-ITEM-TIMESTMP                                   
             TO WS-BC-BILL-ITEM-TIMESTMP-CX (CX-INDX)                   
           MOVE CX-MTR-REF-NO                                           
             TO WS-BC-MTR-REF-NO-CX (CX-INDX)                           
           MOVE CX-CODE-USAGE-TYPE                                      
             TO WS-BC-CODE-USAGE-TYPE-CX (CX-INDX)                      
           MOVE CX-CODE-USAGE-ID                                        
             TO WS-BC-CODE-USAGE-ID-CX (CX-INDX)                        
           MOVE CX-CODE-USAGE-SOURCE                                    
             TO WS-BC-CODE-USAGE-SOURCE-CX (CX-INDX)                    
           MOVE CX-CODE-TIME-PERIOD                                     
             TO WS-BC-CODE-TIME-PERIOD-CX (CX-INDX)                     
           MOVE CX-ITEM-SEQ-NO                                          
             TO WS-BC-ITEM-SEQ-NO-CX (CX-INDX)                          
           MOVE CX-METER-NO                                             
             TO WS-BC-METER-NO-CX (CX-INDX)                             
           MOVE CX-REG-ID-NO                                            
             TO WS-BC-REG-ID-NO-CX (CX-INDX)                            
           MOVE CX-DATE-READ                                            
             TO WS-BC-DATE-READ-CX (CX-INDX)                            
           MOVE CX-CODE-METER-READ                                      
             TO WS-BC-CODE-METER-READ-CX (CX-INDX)                      
           MOVE CX-CODE-METER-NO-READ                                   
             TO WS-BC-CODE-METER-NO-READ-CX (CX-INDX)                   
           MOVE CX-METER-READING                                        
             TO WS-BC-METER-READING-CX (CX-INDX)                        
           MOVE CX-DEMAND-READING                                       
             TO WS-BC-DEMAND-READING-CX (CX-INDX)                       
           MOVE CX-EMPLOYEE-NO                                          
             TO WS-BC-EMPLOYEE-NO-CX (CX-INDX)                          
           MOVE CX-NO-UNITS                                             
             TO WS-BC-NO-UNITS-CX (CX-INDX)                             
           ADD CX-NO-UNITS                                              
             TO WS-BD-ENERGY-UNITS (WS-RM-INDX WS-IC-INDX)              
           MOVE CX-NO-DEMAND-UNITS                                      
             TO WS-BC-NO-DEMAND-UNITS-CX (CX-INDX)                      
           MOVE CX-NO-DAYS                                              
             TO WS-BC-NO-DAYS-CX (CX-INDX)                              
           MOVE CX-CODE-SOURCE-ID                                       
             TO WS-BC-CODE-SOURCE-ID-CX (CX-INDX)                       
           MOVE CX-CODE-DEBIT-CREDIT                                    
             TO WS-BC-CODE-DEBIT-CREDIT-CX (CX-INDX)                    
           MOVE CX-CODE-ITEM-STATUS                                     
             TO WS-BC-CODE-ITEM-STATUS-CX (CX-INDX)                     
           MOVE CX-CODE-DISCOUNT                                        
             TO WS-BC-CODE-DISCOUNT-CX (CX-INDX)                        
           MOVE CX-CONSTANT                                             
             TO WS-BC-CONSTANT-CX (CX-INDX)                             
           MOVE CX-NO-DIALS                                             
             TO WS-BC-NO-DIALS-CX (CX-INDX)                             
           MOVE CX-COMPANY-NO                                           
             TO WS-BC-COMPANY-NO-CX (CX-INDX)                           
           MOVE CX-EXCEPT-OVERRIDE-CD                                   
             TO WS-BC-EXCEPT-OVERRIDE-CD-CX (CX-INDX)                   
           MOVE CX-REQUESTED-USAGE                                      
             TO WS-BC-REQUESTED-USAGE-CX (CX-INDX)                      
           MOVE CX-DIGTL-INTRL-MTR-NO                                   
             TO WS-BC-DIGTL-INTRL-MTR-NO-CX (CX-INDX)                   
           MOVE CX-DIGTL-MTR-TYPE                                       
             TO WS-BC-DIGTL-MTR-TYPE-CX (CX-INDX)                       
           MOVE CX-CODE-TOU-SEASN                                       
             TO WS-BC-CODE-TOU-SEASN-CX (CX-INDX)                       
           MOVE CX-EXCL-DMD-RCHT-IND                                    
             TO WS-BC-EXCL-DMD-RCHT-IND-CX (CX-INDX)                    
           MOVE SPACES                                                  
             TO WS-BC-UPDATE-ACTION-IND-CX (CX-INDX).                   
                                                                        
       5720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /***************************************************************  28040000
      **    5730-MOVE-UC-FIELDS.                                    **  28050000
      **                                                            **  28060000
      ****************************************************************  28070000
       5730-MOVE-UC-FIELDS.                                             
           MOVE UC-ACCOUNT-NO                                           
             TO WS-BC-ACCOUNT-NO-UC (UC-INDX)                           
           MOVE UC-BILL-NO                                              
             TO WS-BC-BILL-NO-UC (UC-INDX)                              
           MOVE UC-CODE-UTIL-TYPE                                       
             TO WS-BC-CODE-UTIL-TYPE-UC (UC-INDX)                       
           MOVE UC-IC-NO                                                
             TO WS-BC-IC-NO-UC (UC-INDX)                                
           MOVE UC-BILL-ITEM-TIMESTMP                                   
             TO WS-BC-BILL-ITEM-TIMESTMP-UC (UC-INDX)                   
           MOVE UC-RATE-ITEM-CODE                                       
             TO WS-BC-RATE-ITEM-CODE-UC (UC-INDX)                       
           MOVE UC-ITEM-SEQ-NO                                          
             TO WS-BC-ITEM-SEQ-NO-UC (UC-INDX)                          
           MOVE UC-NO-UNITS                                             
             TO WS-BC-NO-UNITS-UC (UC-INDX)                             
           MOVE UC-NO-DAYS                                              
             TO WS-BC-NO-DAYS-UC (UC-INDX)                              
           MOVE UC-CODE-DEBIT-CREDIT                                    
             TO WS-BC-CODE-DEBIT-CREDIT-UC (UC-INDX)                    
           MOVE UC-USAGE-FIXED                                          
             TO WS-BC-USAGE-FIXED-UC (UC-INDX)                          
           MOVE UC-DATE-USAGE-ENDS                                      
             TO WS-BC-DATE-USAGE-ENDS-UC (UC-INDX)                      
           MOVE UC-CODE-SERVICE-TYPE                                    
             TO WS-BC-CODE-SERVICE-TYPE-UC (UC-INDX)                    
           MOVE UC-CODE-ITEM-STATUS                                     
             TO WS-BC-CODE-ITEM-STATUS-UC (UC-INDX)                     
           MOVE UC-CODE-SOURCE-ID                                       
             TO WS-BC-CODE-SOURCE-ID-UC (UC-INDX)                       
           MOVE SPACES                                                  
             TO WS-BC-UPDATE-ACTION-IND-UC (UC-INDX)                    
           MOVE UC-DIST-NO                                              
             TO WS-BC-DIST-NO-UC (UC-INDX)                              
           MOVE UC-LIGHT-NO                                             
             TO WS-BC-LIGHT-NO-UC (UC-INDX)                             
           MOVE UC-POLE-NO                                              
             TO WS-BC-POLE-NO-UC (UC-INDX)                              
FORTIM     MOVE UC-MTHLY-AMOUNT-FIXED                                   
FORTIM       TO WS-BC-MTHLY-AMOUNT-FIXED-UC (UC-INDX)                   
           .                                                            
                                                                        
       5730-EXIT.                                                       
           EXIT.                                                        
      /************************************************************     28530000
       5740-LOAD-CX-FROM-BE.                                            
      **                                                            **  28550000
      ****************************************************************  28560000
           MOVE WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX)                      
             TO WS-BC-ACCOUNT-NO-CX (CX-INDX)                           
           MOVE WS-BILL-NO-CX (WS-CNSMPTN-INDX)                         
             TO WS-BC-BILL-NO-CX (CX-INDX)                              
           MOVE WS-CODE-UTIL-TYPE-CX (WS-CNSMPTN-INDX)                  
             TO WS-BC-CODE-UTIL-TYPE-CX (CX-INDX)                       
           MOVE WS-IC-NO-CX (WS-CNSMPTN-INDX)                           
             TO WS-BC-IC-NO-CX (CX-INDX)                                
           MOVE WS-BILL-ITEM-TIMESTMP-CX (WS-CNSMPTN-INDX)              
             TO WS-BC-BILL-ITEM-TIMESTMP-CX (CX-INDX)                   
           MOVE WS-MTR-REF-NO-CX (WS-CNSMPTN-INDX)                      
             TO WS-BC-MTR-REF-NO-CX (CX-INDX)                           
           MOVE WS-CODE-USAGE-TYPE-CX (WS-CNSMPTN-INDX)                 
             TO WS-BC-CODE-USAGE-TYPE-CX (CX-INDX)                      
           MOVE WS-CODE-USAGE-ID-CX (WS-CNSMPTN-INDX)                   
             TO WS-BC-CODE-USAGE-ID-CX (CX-INDX)                        
           MOVE WS-CODE-USAGE-SOURCE-CX (WS-CNSMPTN-INDX)               
             TO WS-BC-CODE-USAGE-SOURCE-CX (CX-INDX)                    
           MOVE WS-CODE-TIME-PERIOD-CX (WS-CNSMPTN-INDX)                
             TO WS-BC-CODE-TIME-PERIOD-CX (CX-INDX)                     
           MOVE WS-ITEM-SEQ-NO-CX (WS-CNSMPTN-INDX)                     
             TO WS-BC-ITEM-SEQ-NO-CX (CX-INDX)                          
           MOVE WS-METER-NO-CX (WS-CNSMPTN-INDX)                        
             TO WS-BC-METER-NO-CX (CX-INDX)                             
           MOVE WS-REG-ID-NO-CX (WS-CNSMPTN-INDX)                       
             TO WS-BC-REG-ID-NO-CX (CX-INDX)                            
           MOVE WS-DATE-READ-CX (WS-CNSMPTN-INDX)                       
             TO WS-BC-DATE-READ-CX (CX-INDX)                            
           MOVE WS-CODE-METER-READ-CX (WS-CNSMPTN-INDX)                 
             TO WS-BC-CODE-METER-READ-CX (CX-INDX)                      
           MOVE WS-CODE-METER-NO-READ-CX (WS-CNSMPTN-INDX)              
             TO WS-BC-CODE-METER-NO-READ-CX (CX-INDX)                   
           MOVE WS-METER-READING-CX (WS-CNSMPTN-INDX)                   
             TO WS-BC-METER-READING-CX (CX-INDX)                        
           MOVE WS-DEMAND-READING-CX (WS-CNSMPTN-INDX)                  
             TO WS-BC-DEMAND-READING-CX (CX-INDX)                       
           MOVE WS-EMPLOYEE-NO-CX (WS-CNSMPTN-INDX)                     
             TO WS-BC-EMPLOYEE-NO-CX (CX-INDX)                          
           MOVE WS-NO-UNITS-CX (WS-CNSMPTN-INDX)                        
             TO WS-BC-NO-UNITS-CX (CX-INDX)                             
T11374     ADD  WS-NO-UNITS-CX (WS-CNSMPTN-INDX)                        
T11374       TO WS-BD-ENERGY-UNITS (WS-RM-INDX WS-IC-INDX)              
           MOVE WS-NO-DEMAND-UNITS-CX (WS-CNSMPTN-INDX)                 
             TO WS-BC-NO-DEMAND-UNITS-CX (CX-INDX)                      
           MOVE WS-NO-DAYS-CX (WS-CNSMPTN-INDX)                         
             TO WS-BC-NO-DAYS-CX (CX-INDX)                              
           MOVE WS-CODE-SOURCE-ID-CX (WS-CNSMPTN-INDX)                  
             TO WS-BC-CODE-SOURCE-ID-CX (CX-INDX)                       
           MOVE WS-CODE-DEBIT-CREDIT-CX (WS-CNSMPTN-INDX)               
             TO WS-BC-CODE-DEBIT-CREDIT-CX (CX-INDX)                    
           MOVE WS-CODE-ITEM-STATUS-CX (WS-CNSMPTN-INDX)                
             TO WS-BC-CODE-ITEM-STATUS-CX (CX-INDX)                     
           MOVE WS-CODE-DISCOUNT-CX (WS-CNSMPTN-INDX)                   
             TO WS-BC-CODE-DISCOUNT-CX (CX-INDX)                        
           MOVE WS-CONSTANT-CX (WS-CNSMPTN-INDX)                        
             TO WS-BC-CONSTANT-CX (CX-INDX)                             
           MOVE WS-NO-DIALS-CX (WS-CNSMPTN-INDX)                        
             TO WS-BC-NO-DIALS-CX (CX-INDX)                             
           MOVE WS-COMPANY-NO-CX (WS-CNSMPTN-INDX)                      
             TO WS-BC-COMPANY-NO-CX (CX-INDX)                           
           MOVE WS-EXCEPT-OVERRIDE-CD-CX (WS-CNSMPTN-INDX)              
             TO WS-BC-EXCEPT-OVERRIDE-CD-CX (CX-INDX)                   
           MOVE WS-REQUESTED-USAGE-CX (WS-CNSMPTN-INDX)                 
             TO WS-BC-REQUESTED-USAGE-CX (CX-INDX)                      
           MOVE WS-DIGTL-INTRL-MTR-NO-CX (WS-CNSMPTN-INDX)              
             TO WS-BC-DIGTL-INTRL-MTR-NO-CX (CX-INDX)                   
           MOVE WS-DIGTL-MTR-TYPE-CX (WS-CNSMPTN-INDX)                  
             TO WS-BC-DIGTL-MTR-TYPE-CX (CX-INDX)                       
           MOVE WS-CODE-TOU-SEASN-CX (WS-CNSMPTN-INDX)                  
             TO WS-BC-CODE-TOU-SEASN-CX (CX-INDX)                       
           MOVE WS-EXCL-DMD-RCHT-IND-CX (WS-CNSMPTN-INDX)               
             TO WS-BC-EXCL-DMD-RCHT-IND-CX (CX-INDX)                    
           MOVE SPACES                                                  
             TO WS-BC-UPDATE-ACTION-IND-CX (CX-INDX).                   
                                                                        
       5740-EXIT.                                                       
           EXIT.                                                        
      /************************************************************     29340000
       5750-LOAD-UC-FROM-BE.                                            
      **                                                            **  29360000
      ****************************************************************  29370000
           MOVE WS-ACCOUNT-NO-UC (WS-UNMTRD-CNSMPTN-INDX)               
             TO WS-BC-ACCOUNT-NO-UC (UC-INDX)                           
           MOVE WS-BILL-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                  
             TO WS-BC-BILL-NO-UC (UC-INDX)                              
           MOVE WS-CODE-UTIL-TYPE-UC (WS-UNMTRD-CNSMPTN-INDX)           
             TO WS-BC-CODE-UTIL-TYPE-UC (UC-INDX)                       
           MOVE WS-IC-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                    
             TO WS-BC-IC-NO-UC (UC-INDX)                                
           MOVE WS-BILL-ITEM-TIMESTMP-UC (WS-UNMTRD-CNSMPTN-INDX)       
             TO WS-BC-BILL-ITEM-TIMESTMP-UC (UC-INDX)                   
           MOVE WS-RATE-ITEM-CODE-UC (WS-UNMTRD-CNSMPTN-INDX)           
             TO WS-BC-RATE-ITEM-CODE-UC (UC-INDX)                       
           MOVE WS-ITEM-SEQ-NO-UC (WS-UNMTRD-CNSMPTN-INDX)              
             TO WS-BC-ITEM-SEQ-NO-UC (UC-INDX)                          
           MOVE WS-NO-UNITS-UC (WS-UNMTRD-CNSMPTN-INDX)                 
             TO WS-BC-NO-UNITS-UC (UC-INDX)                             
           MOVE WS-NO-DAYS-UC (WS-UNMTRD-CNSMPTN-INDX)                  
             TO WS-BC-NO-DAYS-UC (UC-INDX)                              
           MOVE WS-CODE-DEBIT-CREDIT-UC (WS-UNMTRD-CNSMPTN-INDX)        
             TO WS-BC-CODE-DEBIT-CREDIT-UC (UC-INDX)                    
           MOVE WS-USAGE-FIXED-UC (WS-UNMTRD-CNSMPTN-INDX)              
             TO WS-BC-USAGE-FIXED-UC (UC-INDX)                          
           MOVE WS-DATE-USAGE-ENDS-UC (WS-UNMTRD-CNSMPTN-INDX)          
             TO WS-BC-DATE-USAGE-ENDS-UC (UC-INDX)                      
           MOVE WS-CODE-SERVICE-TYPE-UC (WS-UNMTRD-CNSMPTN-INDX)        
             TO WS-BC-CODE-SERVICE-TYPE-UC (UC-INDX)                    
           MOVE WS-CODE-ITEM-STATUS-UC (WS-UNMTRD-CNSMPTN-INDX)         
             TO WS-BC-CODE-ITEM-STATUS-UC (UC-INDX)                     
           MOVE WS-CODE-SOURCE-ID-UC (WS-UNMTRD-CNSMPTN-INDX)           
             TO WS-BC-CODE-SOURCE-ID-UC (UC-INDX)                       
           MOVE SPACES                                                  
             TO WS-BC-UPDATE-ACTION-IND-UC (UC-INDX)                    
           MOVE WS-DIST-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                  
             TO WS-BC-DIST-NO-UC (UC-INDX)                              
           MOVE WS-LIGHT-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                 
             TO WS-BC-LIGHT-NO-UC (UC-INDX)                             
           MOVE WS-POLE-NO-UC (WS-UNMTRD-CNSMPTN-INDX)                  
             TO WS-BC-POLE-NO-UC (UC-INDX).                             
FORTIM     MOVE WS-MTHLY-AMOUNT-FIXED-UC (WS-UNMTRD-CNSMPTN-INDX)       
FORTIM       TO WS-BC-MTHLY-AMOUNT-FIXED-UC (UC-INDX).                  
                                                                        
       5750-EXIT.                                                       
           EXIT.                                                        
                                                                        
C34569/***************************************************************  30940000
C34569 2440-MOVE-DF-FIELDS.                                             
C34569/***************************************************************  30940000
C34569     MOVE WS-ACCOUNT-NO-DF (WS-RTPK-INDX)                         
C34569       TO WS-BC-ACCOUNT-NO-DF (WS-BC-RTPK-INDX)                   
C34569     MOVE WS-CODE-UTIL-TYPE-DF (WS-RTPK-INDX)                     
C34569       TO WS-BC-CODE-UTIL-TYPE-DF (WS-BC-RTPK-INDX)               
C34569     MOVE WS-IC-NO-DF (WS-RTPK-INDX)                              
C34569       TO WS-BC-IC-NO-DF (WS-BC-RTPK-INDX)                        
C34569     MOVE WS-RT-PKG-OPT-SEQ-NO-DF (WS-RTPK-INDX)                  
C34569       TO WS-BC-RT-PKG-OPT-SEQ-NO-DF (WS-BC-RTPK-INDX)            
C34569     MOVE WS-TRANS-SEQ-ID-DF (WS-RTPK-INDX)                       
C34569       TO WS-BC-TRANS-SEQ-ID-DF (WS-BC-RTPK-INDX)                 
C34569     MOVE WS-OFFER-CD-DF (WS-RTPK-INDX)                           
C34569       TO WS-BC-OFFER-CD-DF (WS-BC-RTPK-INDX)                     
C34569     MOVE WS-OPTION-CD-DF (WS-RTPK-INDX)                          
C34569       TO WS-BC-OPTION-CD-DF (WS-BC-RTPK-INDX)                    
C34569     MOVE WS-PROMO-CD-DF (WS-RTPK-INDX)                           
C34569       TO WS-BC-PROMO-CD-DF (WS-BC-RTPK-INDX)                     
C34569     MOVE WS-STATUS-CD-DF (WS-RTPK-INDX)                          
C34569       TO WS-BC-STATUS-CD-DF (WS-BC-RTPK-INDX)                    
C34569     MOVE WS-COMM-CHANNEL-DF (WS-RTPK-INDX)                       
C34569       TO WS-BC-COMM-CHANNEL-DF (WS-BC-RTPK-INDX)                 
C34569     MOVE WS-CREATED-USERID-DF (WS-RTPK-INDX)                     
C34569       TO WS-BC-CREATED-USERID-DF (WS-BC-RTPK-INDX)               
C34569     MOVE WS-OPT-AGRMT-EFF-DT-DF (WS-RTPK-INDX)                   
C34569       TO  WS-BC-OPT-AGRMT-EFF-DT-DF (WS-BC-RTPK-INDX)            
C34569     MOVE  WS-LAST-UPDATE-USERID-DF (WS-RTPK-INDX)                
C34569       TO  WS-BC-LAST-UPDATE-USERID-DF (WS-BC-RTPK-INDX)          
C34569     MOVE WS-OPT-AGRMT-EFF-TM-DF (WS-RTPK-INDX)                   
C34569       TO WS-BC-OPT-AGRMT-EFF-TM-DF (WS-BC-RTPK-INDX)             
C34569     MOVE WS-CREATED-TS-DF (WS-RTPK-INDX)                         
C34569       TO WS-BC-CREATED-TS-DF (WS-BC-RTPK-INDX)                   
C34569     MOVE WS-LAST-UPDATE-TS-DF (WS-RTPK-INDX)                     
C34569       TO WS-BC-LAST-UPDATE-TS-DF (WS-BC-RTPK-INDX)               
C34569     MOVE WS-COMPANY-NO-DF (WS-RTPK-INDX)                         
C34569       TO WS-BC-COMPANY-NO-DF (WS-BC-RTPK-INDX)                   
C34569     MOVE WS-STATUS-EFF-REV-MTH-DF (WS-RTPK-INDX)                 
C34569       TO WS-BC-STATUS-EFF-REV-MTH-DF (WS-BC-RTPK-INDX)           
C34569     MOVE WS-AGREEMNT-SOURCE-CD-DF (WS-RTPK-INDX)                 
C34569       TO WS-BC-AGREEMNT-SOURCE-CD-DF (WS-BC-RTPK-INDX)           
C34569     MOVE WS-ADJ-TIER-SEQ-NO-DF (WS-RTPK-INDX)                    
C34569       TO WS-BC-ADJ-TIER-SEQ-NO-DF (WS-BC-RTPK-INDX)              
C34569     MOVE WS-UPDATE-ACTION-IND-DF (WS-RTPK-INDX)                  
C34569       TO WS-BC-UPDATE-ACTION-IND-DF (WS-BC-RTPK-INDX).           
C34569*                                                                         
C34569 2440-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                         
C34569/***************************************************************  31260000
C34569 2750-MOVE-FF-FIELDS.                                             
C34569/***************************************************************  30940000
C34569     MOVE WS-ACCOUNT-NO-BG (WS-ICD-INDX)     TO                   
C34569                            WS-BC-ACCOUNT-NO-FF (WS-ICD-INDX)     
C34569     MOVE WS-CODE-UTIL-TYPE-BG (WS-ICD-INDX) TO                   
C34569                            WS-BC-CODE-UTIL-TYPE-FF (WS-ICD-INDX) 
C34569     MOVE WS-IC-NO-BG (WS-ICD-INDX)          TO                   
C34569                            WS-BC-IC-NO-FF (WS-ICD-INDX)          
                                                                        
C34569     MOVE 1           TO WS-BC-FIXED-FCTR-SEQ-NO-FF (WS-ICD-INDX) 
C34569     MOVE '&EPPPRICE' TO WS-BC-FACTOR-ID-FF (WS-ICD-INDX)         
                                                                        
C34569* POPULATE TE CURRENT REV. MTH IN THE FROM DATE                           
C34569     MOVE WS-REV-CCYY-TEMP TO  WS-REV-DATE-CCYYY                  
C34569     MOVE WS-REV-MM-TEMP   TO WS-REV-DATE-MM                      
C34569                                                                  
C34569     COMPUTE WS-REV-DATE-MM  =  WS-REV-DATE-MM + 1                
C34569                                                                  
C34569     IF WS-REV-DATE-MM = 13                                       
C34569        MOVE 01 TO WS-REV-DATE-MM                                 
C34569        COMPUTE WS-REV-DATE-CCYYY = WS-REV-DATE-CCYYY + 1         
C34569     END-IF                                                       
C34569                                                                  
C34569     MOVE WS-REV-DATE-FROM                                        
C34569                 TO  WS-BC-EFF-DATE-FROM-FF (WS-ICD-INDX)         
C34569                                                                  
C34569     MOVE '10' TO WS-BC-CMPNT-ID-CD-FF (WS-ICD-INDX)              
C34569     MOVE 'B'  TO WS-BC-CODE-SEASON-FF (WS-ICD-INDX)              
C34569     MOVE 'R'  TO WS-BC-INSTR-USE-TYPE-CD-FF (WS-ICD-INDX)        
C34569                                                                  
C34569* POPULATE THE CURRENT REV MTH IN THE TO DATE                             
C34569     MOVE WS-REV-CCYY-TEMP TO  WS-REV2-DATE-CCYYY                 
C34569     MOVE WS-REV-MM-TEMP   TO WS-REV2-DATE-MM                     
C34569                                                                  
C34569     COMPUTE WS-REV2-DATE-MM  =  WS-REV2-DATE-MM + 11             
C34569     IF WS-REV2-DATE-MM > 12                                      
C34569        COMPUTE WS-REV2-DATE-MM    = WS-REV2-DATE-MM    - 12      
C34569        COMPUTE WS-REV2-DATE-CCYYY = WS-REV2-DATE-CCYYY + 1       
C34569     END-IF                                                       
C34569                                                                  
C34569     MOVE WS-REV-DATE-TO TO WS-BC-EFF-DATE-TO-FF (WS-ICD-INDX)    
C34569                                                                  
C34569     MOVE SPACES TO WS-BC-FIXED-FCTR-TYP-CD-FF (WS-ICD-INDX)      
C34569                    WS-BC-UPDATE-ACTION-IND-FF (WS-ICD-INDX)      
C34569                    WS-BC-LAST-UPDATE-TS-FF (WS-ICD-INDX)         
C34569     MOVE 0 TO WS-BC-CODE-TIME-PERIOD-FF (WS-ICD-INDX)            
C34569               WS-BC-FAC-CHRG-BASE-AM-FF (WS-ICD-INDX)            
C34569               WS-BC-RT-PKG-OPT-SEQ-NO-FF (WS-ICD-INDX)           
C34569                                                                  
P00694     MOVE WS-BBP-CSC-AMT                                          
P00694       TO WS-BC-FAC-CHRG-BASE-AM-FF (WS-ICD-INDX)                 
                                                                        
P00211     IF WS-PEND-OPTN-EXIST-FL = 'Y'                               
P00211        MOVE WS-PEND-THERM-PRICE TO                               
P00211                        WS-BC-FACTOR-FF (WS-ICD-INDX)             
P00694                        WS-BBP-ANNIV-PRICE-DISP                   
P00211     ELSE                                                         
P00396        MOVE WS-BBP-ANNIV-PRICE TO                                
C34569                        WS-BC-FACTOR-FF (WS-ICD-INDX)             
P00694                        WS-BBP-ANNIV-PRICE-DISP                   
P00211     END-IF.                                                      
C34569*                                                                         
C34569 2750-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                         
T34391/***************************************************************  23650000
T34391**  5830-CHECK-FOR-SEAS                                           23660000
T34391** THIS PROCEDURE CHECKS FOR CONSECUTIVE REV MTHS AND DECIDES **  23670000
T34391** IF THE ACCOUNT IS SEASONAL. THE ARRAY IS FIRST SORTED      **  23680000
T34391**                                                            **  23690000
T34391****************************************************************  23700000
T34391 5830-CHECK-FOR-SEAS.                                             
T34391****************************************************************          
T34391**SORT THE ARRAY IN DESC SEQUENCE  FOR ELECTRIC ACCOUNTS                  
T34391       PERFORM VARYING  WS-SEAE-INDX                              
T34391              FROM 1 BY 1 UNTIL WS-SEAE-INDX > 11                 
T34391        ADD 1 TO WS-SEAE-INDX GIVING WS-SEAE-INDX1                
T34391        PERFORM UNTIL  WS-SEAE-INDX1 > 11                         
T34391          IF  WS-CK-SEASONAL-MTH(WS-SEAE-INDX1) NOT = SPACES      
T34391            IF WS-CK-SEASONAL-MTH(WS-SEAE-INDX1) >                
T34391                           WS-CK-SEASONAL-MTH(WS-SEAE-INDX)       
T34391             MOVE WS-CK-SEASONAL-MTH(WS-SEAE-INDX1) TO            
T34391                  WS-TEMP-SMTHE                                   
T34391             MOVE WS-CK-SEASONAL-MTH(WS-SEAE-INDX) TO             
T34391                  WS-CK-SEASONAL-MTH(WS-SEAE-INDX1)               
T34391             MOVE WS-TEMP-SMTHE                      TO           
T34391                  WS-CK-SEASONAL-MTH(WS-SEAE-INDX)                
T34391            END-IF                                                
T34391          END-IF                                                  
T34391          ADD 1 TO WS-SEAE-INDX1                                  
T34391        END-PERFORM                                               
T34391       END-PERFORM.                                               
T34391*COMPARE THE SORTED ARRAY FOR CONSECUTIVE REV. MTHS                       
T34391*FOR ELECTRIC SERVICE                                                     
T34391      IF  WS-BILL-CTRE > 0                                        
T34391        PERFORM VARYING WS-SEAE-INDX FROM 1 BY 1                  
T34391               UNTIL WS-SEAE-INDX = 11                            
T34391               OR WS-SEASONAL-YES                                 
T34391        IF WS-CK-SEAS-MONTH (WS-SEAE-INDX + 1) NOT = 12           
T34391          SUBTRACT WS-CK-SEASONAL-MTH (WS-SEAE-INDX) FROM         
T34391            WS-CK-SEASONAL-MTH (WS-SEAE-INDX + 1)                 
T34391                 GIVING WS-REV-MTH-DIFF                           
T34391           IF WS-REV-MTH-DIFF NOT = 1                             
T34391              SET WS-SEASONAL-YES  TO TRUE                        
T34391           END-IF                                                 
T34391        ELSE                                                      
T34391          SUBTRACT WS-CK-SEAS-YEAR (WS-SEAE-INDX) FROM            
T34391            WS-CK-SEAS-YEAR (WS-SEAE-INDX + 1)                    
T34391                GIVING WS-REV-YR-DIFF                             
T34391          SUBTRACT WS-CK-SEAS-MONTH (WS-SEAE-INDX) FROM           
T34391            WS-CK-SEAS-MONTH (WS-SEAE-INDX + 1)                   
T34391                  GIVING WS-REV-MTH-DIFF                          
T34391          IF WS-REV-MTH-DIFF NOT = 11 OR WS-REV-YR-DIFF NOT = 1   
T34391              SET WS-SEASONAL-YES  TO TRUE                        
T34391          END-IF                                                  
T34391        END-IF                                                    
T34391        END-PERFORM                                               
T34391      END-IF.                                                     
T34391*                                                                         
T34391*SORT THE ARRAY IN DESC SEQUENCE  FOR GAS ACCOUNTS                        
T34391      PERFORM VARYING  WS-SEAG-INDX                               
T34391              FROM 1 BY 1 UNTIL WS-SEAG-INDX > 11                 
T34391        ADD 1 TO WS-SEAG-INDX GIVING WS-SEAG-INDX1                
T34391        PERFORM UNTIL  WS-SEAG-INDX1 > 11                         
T34391          IF  WS-CG-SEASONAL-MTH(WS-SEAG-INDX1) NOT = SPACES      
T34391            IF WS-CG-SEASONAL-MTH(WS-SEAG-INDX1) >                
T34391                           WS-CG-SEASONAL-MTH(WS-SEAG-INDX)       
T34391             MOVE WS-CG-SEASONAL-MTH(WS-SEAG-INDX1) TO            
T34391                  WS-TEMP-SMTHG                                   
T34391             MOVE WS-CG-SEASONAL-MTH(WS-SEAG-INDX) TO             
T34391                  WS-CG-SEASONAL-MTH(WS-SEAG-INDX1)               
T34391             MOVE WS-TEMP-SMTHG                      TO           
T34391                  WS-CG-SEASONAL-MTH(WS-SEAG-INDX)                
T34391            END-IF                                                
T34391          END-IF                                                  
T34391          ADD 1 TO WS-SEAG-INDX1                                  
T34391        END-PERFORM                                               
T34391      END-PERFORM.                                                
T34391*COMPARE THE SORTED ARRAY FOR CONSECUTIVE REV. MTHS                       
T34391*FOR GAS SERVICE                                                          
T34391      IF  WS-BILL-CTRG > 0                                        
T34391        PERFORM VARYING WS-SEAG-INDX FROM 1 BY 1                  
T34391               UNTIL WS-SEAG-INDX = 11                            
T34391               OR WS-SEASONAL-YES                                 
T34391        IF WS-CG-SEAS-MONTH (WS-SEAG-INDX + 1) NOT = 12           
T34391          SUBTRACT WS-CG-SEASONAL-MTH (WS-SEAG-INDX) FROM         
T34391            WS-CG-SEASONAL-MTH (WS-SEAG-INDX + 1)                 
T34391                 GIVING WS-REV-MTH-DIFF                           
T34391           IF WS-REV-MTH-DIFF NOT= 1                              
T34391              SET WS-SEASONAL-YES  TO TRUE                        
T34391           END-IF                                                 
T34391        ELSE                                                      
T34391          SUBTRACT WS-CG-SEAS-YEAR (WS-SEAG-INDX) FROM            
T34391            WS-CG-SEAS-YEAR (WS-SEAG-INDX + 1)                    
T34391                GIVING WS-REV-YR-DIFF                             
T34391          SUBTRACT WS-CG-SEAS-MONTH (WS-SEAG-INDX) FROM           
T34391            WS-CG-SEAS-MONTH (WS-SEAG-INDX + 1)                   
T34391                  GIVING WS-REV-MTH-DIFF                          
T34391          IF WS-REV-MTH-DIFF NOT = 11 OR WS-REV-YR-DIFF NOT = 1   
T34391              SET WS-SEASONAL-YES  TO TRUE                        
T34391          END-IF                                                  
T34391        END-IF                                                    
T34391        END-PERFORM                                               
T34391      END-IF.                                                     
T34391                                                                  
T34391 5830-EXIT.                                                       
T34391     EXIT.                                                        
T34391                                                                  
T10082 5900-CREATE-101-JOURNAL.                                         
T10082     INITIALIZE CJF00101.                                         
      *                                                                 31540000
      * JOURNAL KEY                                                     31550000
      *                                                                 31560000
T10082     MOVE WS-A                    TO  E-FWK03-JRNL-SORT-ID.       
T10082     MOVE WS-COMPANY-NO-AT        TO  E-FWK03-COMPANY-NO.         
T10082     MOVE WS-LOCAL-OFFICE-AT      TO  E-FWK03-LOCAL-OFFICE.       
T10082     MOVE WS-ACCOUNT-NO-AT        TO  E-FWK03-ACCT-NO.            
T10082     MOVE WS-CUSTOMER-NO-CU       TO  E-FWK03-CUSTOMER-NO.        
T10082     MOVE WS-BILL                 TO  E-FWK03-CODE-TERMINAL-TRAN. 
T10082     MOVE LS-INPUT-DATE           TO  E-FWK03-DATE-LAST-ACTION    
T10082     MOVE WS-B                    TO  E-FWK03-CODE-ENTRY-SOURCE.  
                                                                        
      *                                                                 31660000
      * COMMON JOURNAL DATA                                             31670000
      *                                                                 31680000
T10082     MOVE WS-101                  TO WS-101-JRNL-FORMAT-NO.       
T10082     MOVE WS-X                    TO WS-101-CASH-DRAWER-USED.     
                                                                        
                                                                        
T10082     MOVE WS-AR-CIA-GL-NO (WS-GL-SUB) TO                          
T10082                               WS-101-ACCT-GEN-LED-CR.            
T10082     MOVE WS-AR-BUD-GL-NO (WS-GL-SUB) TO                          
T10082                               WS-101-ACCT-GEN-LED-DR.            
                                                                        
T10082     MOVE ZERO TO WS-101-AR-AGE.                                  
T10082     COMPUTE WS-101-AMT-POSTED EQUAL                              
T14583                WS-AMT-TRAN-BAL-HOLD-AC * -1.                     
T10082     MOVE WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) TO             
T10082                               WS-101-DETAIL-END-BAL              
T10082     COMPUTE WS-101-DETAIL-END-AR-BAL EQUAL                       
T10082               (WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX) +           
T10082                WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX) +           
T10082                WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX) +           
T10082                WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX))            
                                                                        
T10082     MOVE WS-DATE-BILLED-BI       TO WS-101-DATE-AR-BILLED.       
                                                                        
T10082     MOVE WS-ITEM-ID-AC (WS-AR-DATA-INDX) TO WS-101-ITEM-ID-NO    
T10082     MOVE WS-REV-DISTRICT-CD-PR   TO WS-101-CODE-REVENUE-DISTRICT.
T10082     MOVE WS-CODE-EMPL-ACCT-CU    TO WS-101-CODE-EMPL-ACCT.       
T10082     MOVE WS-CODE-COMPANY-ACCT-AT TO WS-101-CODE-COMPANY-ACCT.    
T10082     MOVE WS-CODE-ACCT-STAT-AT    TO WS-101-CODE-ACCOUNT-STATUS.  
T10082     MOVE WS-CODE-PREMISE-STAT-PR TO WS-101-CODE-PREMISE-STATUS.  
T10082     MOVE WS-101-AMT-POSTED       TO WS-101-AMOUNT-ENTERED.       
                                                                        
T10082     MOVE WS-101-AMT-POSTED  TO  E-FWK03-RCV-DEBIT-AMT            
T10082                                 E-FWK03-GEN-LEG-CREDIT-AMT.      
T10082     MOVE ZEROS              TO  E-FWK03-RCV-CREDIT-AMT           
T10082                                 E-FWK03-GEN-LEG-DEBIT-AMT.       
T10082     MOVE CJF00101           TO  E-FWK03-USER-DEFINED-AREA.       
T10082     MOVE ZEROS              TO  E-FWK03-SORT-SUM-FLD.            
T10082     PERFORM 8300-WRITE-FCSWK03 THRU 8300-EXIT.                   
T10082 5900-EXIT.                                                       
T10082     EXIT.                                                        
                                                                        
T17777 5950-JOURNAL-APPLY-CIA.                                          
T17777     INITIALIZE CJF00101.                                         
T17777*                                                                 32110000
T17777* JOURNAL KEY                                                     32120000
T17777*                                                                 32130000
T17777     MOVE WS-HOLD-AMT-POSTED      TO  WS-101-AMT-POSTED.          
T17777     MOVE WS-101-AMT-POSTED       TO  AU-AMT-POSTED.              
T17777     MOVE WS-101-AMT-POSTED       TO AR-AMT-ORIG-ENTERED.         
T17777     MOVE AU-AMT-POSTED           TO  E-FWK03-RCV-DEBIT-AMT       
T17777                                      E-FWK03-GEN-LEG-CREDIT-AMT. 
T17777     MOVE ZEROES                  TO  E-FWK03-RCV-CREDIT-AMT      
T17777                                      E-FWK03-GEN-LEG-DEBIT-AMT.  
T17777     MOVE ZEROES                  TO  WS-DETAIL-END-BAL           
T17777                                      WS-DETAIL-END-AR-BAL.       
T17777     SET WS-AR-DATA-INDX          TO  WS-HOLD-BUDGET-INDX.        
T17777     MOVE WS-A                    TO  E-FWK03-JRNL-SORT-ID.       
T17777     MOVE WS-COMPANY-NO-AT        TO  E-FWK03-COMPANY-NO.         
T17777     MOVE WS-LOCAL-OFFICE-AT      TO  E-FWK03-LOCAL-OFFICE.       
T17777     MOVE WS-ACCOUNT-NO-AT        TO  E-FWK03-ACCT-NO.            
T17777     MOVE WS-CUSTOMER-NO-CU       TO  E-FWK03-CUSTOMER-NO.        
T17777     MOVE WS-BILL                 TO  E-FWK03-CODE-TERMINAL-TRAN. 
T17777     MOVE LS-INPUT-DATE           TO  E-FWK03-DATE-LAST-ACTION.   
T17777     MOVE WS-B                    TO  E-FWK03-CODE-ENTRY-SOURCE.  
T17777                                                                  
T17777*                                                                 32330000
T17777* COMMON JOURNAL DATA                                             32340000
T17777*                                                                 32350000
T17777     MOVE WS-101                  TO WS-101-JRNL-FORMAT-NO.       
T17777     MOVE WS-X                    TO WS-101-CASH-DRAWER-USED.     
T17777                                                                  
T17777                                                                  
T17777     MOVE WS-AR-CIA-GL-NO (WS-GL-SUB)  TO                         
T17777                               WS-101-ACCT-GEN-LED-DR.            
T17777     MOVE WS-AR-BUD-GL-NO (WS-GL-SUB)  TO                         
T17777                               WS-101-ACCT-GEN-LED-CR.            
T17777     MOVE 'APPLYING CIA'          TO AR-TRAN-COMMENT-TEXT.        
T17777     MOVE +12                     TO AR-TRAN-COMMENT-LEN.         
T17777                                                                  
A02036     MOVE SPACES                  TO AR-RESP-AREA-ID.             
T17777     MOVE WS-PGRMNAME             TO AR-APPL-PROGRAM-ID.          
T17777     MOVE WS-SYSTEM               TO AR-USER-ID.                  
T17777     MOVE ZEROES                  TO AU-CURRENCY-AMT.             
T17777     MOVE SPACES                  TO AR-PYMT-FACILITY-CD          
T17777                                     AR-RECORD-ONLY-FL            
T17777                                     AU-CODE-CONTRACT-TYPE        
T17777                                                                  
T18579     MOVE 'E'  TO WS-101-AR-AGE.                                  
T17777     MOVE WS-NEW-TRAN-BALANCE TO  WS-101-DETAIL-END-BAL           
T17777     COMPUTE WS-101-DETAIL-END-AR-BAL EQUAL                       
T17777               (WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX) +           
T17777                WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX) +           
T17777                WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX) +           
T17777                WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX))            
T17777                                                                  
T17777     MOVE WS-DATE-BILLED-BI       TO WS-101-DATE-AR-BILLED.       
T17777                                                                  
T17777     MOVE +1                      TO WS-101-ITEM-ID-NO.           
T17777     MOVE WS-REV-DISTRICT-CD-PR   TO WS-101-CODE-REVENUE-DISTRICT.
T17777     MOVE WS-CODE-EMPL-ACCT-CU    TO WS-101-CODE-EMPL-ACCT.       
T17777     MOVE WS-CODE-COMPANY-ACCT-AT TO WS-101-CODE-COMPANY-ACCT.    
T17777     MOVE WS-CODE-ACCT-STAT-AT    TO WS-101-CODE-ACCOUNT-STATUS.  
T17777     MOVE WS-CODE-PREMISE-STAT-PR TO WS-101-CODE-PREMISE-STATUS.  
T17777     MOVE WS-101-AMT-POSTED       TO WS-101-AMOUNT-ENTERED.       
T17777     MOVE WS-101                  TO WS-101-JRNL-FORMAT-NO.       
T17777     MOVE SPACES                  TO WS-101-CASH-DRAWER-USED.     
T17777     MOVE LS-INPUT-DATE           TO WS-101-DATE-AR-BILLED.       
T17777     ADD WS-DETAIL-END-BAL       TO WS-101-DETAIL-END-BAL.        
T17777     ADD WS-DETAIL-END-AR-BAL    TO WS-101-DETAIL-END-AR-BAL.     
T17777     MOVE WS-TOTAL-AR-BALANCE-AT  TO AR-AMT-BILLED-UNPAID         
T17777                                     WS-101-ACCT-END-AR-BAL.      
T17777     ADD WS-HOLD-AMT-POSTED       TO WS-WK03-TOTAL-AR-BAL.        
T17777                                                                  
T17777     MOVE LS-CURR-REVENUE-MONTH   TO WS-101-REVENUE-MONTH.        
T17777     MOVE WS-CODE-EMPL-ACCT-CU    TO WS-101-CODE-EMPL-ACCT.       
T17777     MOVE WS-CODE-COMPANY-ACCT-AT TO WS-101-CODE-COMPANY-ACCT.    
T17777     MOVE WS-CODE-ACCT-STAT-AT    TO WS-101-CODE-ACCOUNT-STATUS.  
T17777     MOVE WS-CODE-PREMISE-STAT-PR TO WS-101-CODE-PREMISE-STATUS.  
T17777     MOVE WS-INDIRECT-JRNL        TO E-FWK03-JRNL-SORT-ID.        
T17777     MOVE WS-ACCOUNT-NO-AT        TO E-FWK03-ACCT-NO.             
T17777     MOVE WS-LOCAL-OFFICE-AT      TO E-FWK03-LOCAL-OFFICE         
T17777                                     AR-CASH-LOCAL-OFFICE.        
T17777     MOVE WS-COMPANY-NO-AT        TO E-FWK03-COMPANY-NO           
T17777                                     AR-COMPANY-NO.               
T17777     MOVE WS-CUSTOMER-NO-AT       TO E-FWK03-CUSTOMER-NO.         
T17777     MOVE WS-BILL                 TO E-FWK03-CODE-TERMINAL-TRAN.  
T17777     MOVE 1                       TO E-FWK03-JRNL-TRAN-APPL-NO    
T17777                                     AU-TRAN-APPL-NO.             
T17777     MOVE LS-INPUT-DATE           TO WS-DATE-LAST-ACTION-AT       
T17777                                     AR-DATE-TRANS.               
T17777     MOVE SPACES                  TO E-FWK03-TRAN-ERRORS.         
T17777     MOVE 'B'                     TO E-FWK03-CODE-ENTRY-SOURCE.   
T17777     MOVE WS-ADJUST               TO AR-CODE-TRAN-TYPE.           
T17777     MOVE WS-ACCOUNT-NO-AT        TO AR-ACCOUNT-NO                
T17777                                     AU-ACCOUNT-NO.               
T17777     PERFORM 7900-GET-AR-TIMESTAMP     THRU  7900-EXIT.           
T17777     MOVE AR-TRANS-HIST-SEQ-NO     TO AU-TRANS-HIST-SEQ-NO.       
T17777     ADD +1                       TO AU-TRAN-APPL-NO.             
T17777                                                                  
T17777                                                                  
T17777     MOVE WS-101-AMT-POSTED  TO  E-FWK03-RCV-DEBIT-AMT            
T17777                                 E-FWK03-GEN-LEG-CREDIT-AMT.      
T17777     MOVE ZEROS              TO  E-FWK03-RCV-CREDIT-AMT           
T17777                                 E-FWK03-GEN-LEG-DEBIT-AMT.       
T17777     MOVE CJF00101           TO  E-FWK03-USER-DEFINED-AREA.       
T17777     MOVE ZEROS              TO  E-FWK03-SORT-SUM-FLD.            
T17777                                                                  
T17777     PERFORM 8300-WRITE-FCSWK03 THRU 8300-EXIT.                   
T17777 5950-EXIT.                                                       
T17777     EXIT.                                                        
C26679*                                                                 33190100
C26679 5960-CREATE-ADJ-JOURNAL.                                         
C26679     INITIALIZE CJF00101.                                         
C26679* JOURNAL KEY                                                     33190400
C26679     MOVE WS-INDIRECT-JRNL        TO E-FWK03-JRNL-SORT-ID.        
C26679     MOVE WS-COMPANY-NO-AT        TO E-FWK03-COMPANY-NO.          
C26679     MOVE WS-LOCAL-OFFICE-AT      TO E-FWK03-LOCAL-OFFICE.        
C26679     MOVE WS-ACCOUNT-NO-AT        TO E-FWK03-ACCT-NO.             
C26679     MOVE WS-CUSTOMER-NO-CU       TO E-FWK03-CUSTOMER-NO.         
C26679     MOVE 'A112'                  TO E-FWK03-CODE-TERMINAL-TRAN.  
C26679     MOVE LS-INPUT-DATE           TO E-FWK03-DATE-LAST-ACTION     
C26679     MOVE WS-B                    TO E-FWK03-CODE-ENTRY-SOURCE.   
C26679                                                                  
C26679* COMMON JOURNAL DATA                                             33191500
C26679     MOVE WS-101                  TO WS-101-JRNL-FORMAT-NO.       
C26679     MOVE SPACES                  TO WS-101-CASH-DRAWER-USED.     
C26679     MOVE WS-AR-BUD-GL-NO(WS-GL-SUB)                              
C26679                                  TO WS-101-ACCT-GEN-LED-CR       
C26679                                     WS-101-ACCT-GEN-LED-DR.      
C26679     MOVE WS-TOTAL-BALANCE        TO WS-101-AMT-POSTED            
C26679                                     WS-101-DETAIL-END-BAL        
C26679                                     WS-101-DETAIL-END-AR-BAL.    
C26679     MOVE LS-INPUT-DATE           TO WS-101-DATE-AR-BILLED.       
C26679     MOVE 1                       TO WS-101-ITEM-ID-NO.           
C26679     MOVE WS-REV-DISTRICT-CD-PR   TO WS-101-CODE-REVENUE-DISTRICT.
C26679     MOVE WS-CODE-EMPL-ACCT-CU    TO WS-101-CODE-EMPL-ACCT.       
C26679     MOVE WS-CODE-COMPANY-ACCT-AT TO WS-101-CODE-COMPANY-ACCT.    
C26679     MOVE WS-CODE-ACCT-STAT-AT    TO WS-101-CODE-ACCOUNT-STATUS.  
C26679     MOVE WS-CODE-PREMISE-STAT-PR TO WS-101-CODE-PREMISE-STATUS.  
C26679     MOVE WS-TOTAL-BALANCE        TO WS-101-AMOUNT-ENTERED.       
C26679     MOVE WS-101-AMT-POSTED       TO E-FWK03-RCV-DEBIT-AMT        
C26679                                     E-FWK03-RCV-CREDIT-AMT.      
C26679     MOVE ZEROS                   TO E-FWK03-GEN-LEG-CREDIT-AMT   
C26679                                     E-FWK03-GEN-LEG-DEBIT-AMT.   
C26679     MOVE WS-ARREARS-AMOUNT       TO WS-101-ACCT-END-AR-BAL.      
C26679     MOVE ZERO                    TO WS-101-AR-AGE                
C26679     MOVE ZERO                    TO WS-DETAIL-END-BAL            
C26679                                     WS-DETAIL-END-AR-BAL.        
C26679     MOVE 1                       TO E-FWK03-JRNL-TRAN-APPL-NO.   
C26679     MOVE LS-CURR-REVENUE-MONTH   TO WS-101-REVENUE-MONTH.        
C26679     MOVE CJF00101                TO E-FWK03-USER-DEFINED-AREA.   
C26679     MOVE ZEROS                   TO E-FWK03-SORT-SUM-FLD.        
C26679     PERFORM 8300-WRITE-FCSWK03   THRU 8300-EXIT.                 
C26679*                                                                 33196700
C26679 5960-EXIT.                                                       
C26679     EXIT.                                                        
                                                                        
C34216 5965-CREATE-ADJ-JOURNAL.                                         
C34216     INITIALIZE CJF00101.                                         
C34216* JOURNAL KEY                                                     33190400
C34216     MOVE WS-INDIRECT-JRNL        TO E-FWK03-JRNL-SORT-ID.        
C34216     MOVE WS-COMPANY-NO-AT        TO E-FWK03-COMPANY-NO.          
C34216     MOVE WS-LOCAL-OFFICE-AT      TO E-FWK03-LOCAL-OFFICE.        
C34216     MOVE WS-ACCOUNT-NO-AT        TO E-FWK03-ACCT-NO.             
C34216     MOVE WS-CUSTOMER-NO-CU       TO E-FWK03-CUSTOMER-NO.         
C34216     MOVE 'A112'                  TO E-FWK03-CODE-TERMINAL-TRAN.  
C34216     MOVE LS-INPUT-DATE           TO E-FWK03-DATE-LAST-ACTION     
C34216     MOVE WS-B                    TO E-FWK03-CODE-ENTRY-SOURCE.   
C34216                                                                  
C34216* COMMON JOURNAL DATA                                             33191500
C34216     MOVE WS-101                  TO WS-101-JRNL-FORMAT-NO.       
C34216     MOVE SPACES                  TO WS-101-CASH-DRAWER-USED.     
C34216     MOVE WS-AR-BUD-GL-NO(WS-GL-SUB)                              
C34216                                  TO WS-101-ACCT-GEN-LED-CR       
C34216                                     WS-101-ACCT-GEN-LED-DR.      
C34216     MOVE WS-TOTAL-BALANCE        TO WS-101-AMT-POSTED            
C34216                                     WS-101-DETAIL-END-BAL        
C34216                                     WS-101-DETAIL-END-AR-BAL.    
C34216     MOVE LS-INPUT-DATE           TO WS-101-DATE-AR-BILLED.       
C34216     MOVE 1                       TO WS-101-ITEM-ID-NO.           
C34216     MOVE WS-REV-DISTRICT-CD-PR   TO WS-101-CODE-REVENUE-DISTRICT.
C34216     MOVE WS-CODE-EMPL-ACCT-CU    TO WS-101-CODE-EMPL-ACCT.       
C34216     MOVE WS-CODE-COMPANY-ACCT-AT TO WS-101-CODE-COMPANY-ACCT.    
C34216     MOVE WS-CODE-ACCT-STAT-AT    TO WS-101-CODE-ACCOUNT-STATUS.  
C34216     MOVE WS-CODE-PREMISE-STAT-PR TO WS-101-CODE-PREMISE-STATUS.  
C34216     MOVE WS-TOTAL-BALANCE        TO WS-101-AMOUNT-ENTERED.       
C34216     MOVE WS-101-AMT-POSTED       TO E-FWK03-RCV-DEBIT-AMT        
C34216                                     E-FWK03-RCV-CREDIT-AMT.      
C34216     MOVE ZEROS                   TO E-FWK03-GEN-LEG-CREDIT-AMT   
C34216                                     E-FWK03-GEN-LEG-DEBIT-AMT.   
C34216     MOVE WS-TOTAL-AR-BALANCE-AT  TO WS-101-ACCT-END-AR-BAL       
C34216                                     AR-AMT-BILLED-UNPAID.        
C34216     MOVE SPACE                   TO WS-101-AR-AGE                
C34216     MOVE ZERO                    TO WS-DETAIL-END-BAL            
C34216                                     WS-DETAIL-END-AR-BAL.        
C34216     MOVE 1                       TO E-FWK03-JRNL-TRAN-APPL-NO.   
C34216     MOVE LS-CURR-REVENUE-MONTH   TO WS-101-REVENUE-MONTH.        
C34216     MOVE 'ADJS'                  TO WS-101-FUNCTION-CODE.        
C34216     MOVE CJF00101                TO E-FWK03-USER-DEFINED-AREA.   
C34216     MOVE ZEROS                   TO E-FWK03-SORT-SUM-FLD.        
C34216     PERFORM 8300-WRITE-FCSWK03   THRU 8300-EXIT.                 
C34216*                                                                 33196700
C34216 5965-EXIT.                                                       
C34216     EXIT.                                                        
                                                                        
P00307******************* INSERT MAINTENANCE TRANS HIST*****                    
P00307 6530-LOAD-MNT-TRANS-HIST.                                        
                                                                        
P00307     IF MI-TRAN-APPL-NO EQUAL 1                                   
A02036        IF LS-DATABASE-UPDATES = 'YES'                            
P00307         PERFORM 6540-INSERT-MNT-TRANS-HIST     THRU 6540-EXIT    
P00307         PERFORM 6550-INSERT-MT-TRN-HST-DET     THRU 6550-EXIT    
A02036        END-IF                                                    
P00307     ELSE                                                         
A02036        IF LS-DATABASE-UPDATES = 'YES'                            
P00307         PERFORM 6550-INSERT-MT-TRN-HST-DET     THRU 6550-EXIT    
A02036        END-IF
           END-IF.                                                   
P00307 6530-EXIT.                                                       
P00307     EXIT.                                                        
      /                                                                 08239000
P00307 6540-INSERT-MNT-TRANS-HIST.                                      
                                                                        
P00307     EXEC SQL                                                     
P00307         INSERT INTO CSS_MNT_TRANS_HIST                           
P00307           ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       
P00307             CODE_TRAN_TYPE,    RESP_AREA_ID,                     
P00307             ACCOUNT_NO,                                          
P00307             CUSTOMER_NO,       PREMISE_NO,                       
P00307             USER_ID,           APPL_PROGRAM_ID,                  
P00307             TRAN_COMMENT)                                        
P00307         VALUES                                                   
P00307           ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO), 
              IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),               
P00307             :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             
P00307             :MH-ACCOUNT-NO,                                      
P00307             :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               
P00307             :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          
P00307             :MH-TRAN-COMMENT)                                    
P00307     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08242000
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                           08243000
MFA-TR*          ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       08244000
MFA-TR*            CODE_TRAN_TYPE,    RESP_AREA_ID,                     08245000
MFA-TR*            ACCOUNT_NO,                                          08246000
MFA-TR*            CUSTOMER_NO,       PREMISE_NO,                       08247000
MFA-TR*            USER_ID,           APPL_PROGRAM_ID,                  08248000
MFA-TR*            TRAN_COMMENT)                                        08249000
MFA-TR*        VALUES                                                   08250000
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO, :MH-DATE-TRANS,               08251000
MFA-TR*            :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             08252000
MFA-TR*            :MH-ACCOUNT-NO,                                      08253000
MFA-TR*            :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               08254000
MFA-TR*            :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          08255000
MFA-TR*            :MH-TRAN-COMMENT)                                    08256000
MFA-TR*    END-EXEC.                                                    08257000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
P00307     IF SQLCODE NOT = SUCCESSFUL-CALL                             
P00307        MOVE 'MH'                 TO WS-DB2-TABLE-ID              
P00307        MOVE 'INSERT'             TO WS-DB2-FUNCTION              
P00307        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00307        MOVE '112'                TO WS-DB2-MODULE-ID             
P00307        MOVE '6540'               TO WS-DB2-PARAGRAPH             
P00307        MOVE MH-ACCOUNT-NO        TO WS-DB2-KEY-1                 
P00307        MOVE 16 TO RETURN-CODE                                    
P00307        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
P00307     END-IF.                                                      
                                                                        
P00307 6540-EXIT.                                                       
P00307     EXIT.                                                        
      /                                                                 08271000
P00307 6550-INSERT-MT-TRN-HST-DET.                                      
                                                                        
P00307     EXEC SQL                                                     
P00307         INSERT INTO CSS_MT_TRN_HST_DET                           
P00307         ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                       
P00307           COLUMN_DESC,       PRV_COLUMN_VALUE,                   
P00307           CHG_COLUMN_VALUE,                                      
P00307           TABLE_ID)                                              
P00307         VALUES                                                   
P00307         ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO), 
                                                      :MI-TRAN-APPL-NO,        
P00307           :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,           
P00307           :MI-CHG-COLUMN-VALUE,                                  
P00307           :MI-TABLE-ID)                                          
P00307     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08274000
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                           08275000
MFA-TR*        ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                       08276000
MFA-TR*          COLUMN_DESC,       PRV_COLUMN_VALUE,                   08277000
MFA-TR*          CHG_COLUMN_VALUE,                                      08278000
MFA-TR*          TABLE_ID)                                              08279000
MFA-TR*        VALUES                                                   08280000
MFA-TR*        ( :MI-TRANS-HIST-SEQ-NO, :MI-TRAN-APPL-NO,               08281000
MFA-TR*          :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,           08282000
MFA-TR*          :MI-CHG-COLUMN-VALUE,                                  08283000
MFA-TR*          :MI-TABLE-ID)                                          08284000
MFA-TR*    END-EXEC.                                                    08285000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
P00307     IF SQLCODE NOT = SUCCESSFUL-CALL                             
P00307        MOVE 'MI'                 TO WS-DB2-TABLE-ID              
P00307        MOVE 'INSERT'             TO WS-DB2-FUNCTION              
P00307        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00307        MOVE '112'                TO WS-DB2-MODULE-ID             
P00307        MOVE '6550'               TO WS-DB2-PARAGRAPH             
P00307        MOVE MI-TRANS-HIST-SEQ-NO TO WS-DB2-KEY-1                 
P00307        MOVE 16 TO RETURN-CODE                                    
P00307        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
P00307     END-IF.                                                      
                                                                        
P00307 6550-EXIT.                                                       
P00307     EXIT.                                                        
                                                                        
      /*******************************************************          33288900
      * OPEN THE CURSOR FOR THE BILLING HISTORY SEARCH OF THE*          33289000
      * DATABASE TABLE: CSS_BILLING_DET.                     *          33289100
      ********************************************************          33289200
       7000-OPEN-BI-BG-EPP.                                             
           EXEC SQL                                                     
                OPEN BI_BG_EPP                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'BG'                    TO WS-DB2-TABLE-ID           
              MOVE 'OPEN  '                TO WS-DB2-FUNCTION           
              MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
              MOVE '112'                   TO WS-DB2-MODULE-ID          
              MOVE '7000'                  TO WS-DB2-PARAGRAPH          
              MOVE BG-ACCOUNT-NO           TO WS-DB2-KEY-1N             
              MOVE BG-CODE-UTIL-TYPE       TO WS-DB2-KEY-2              
              MOVE BG-IC-NO                TO WS-DB2-KEY-3N             
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33440000
       7010-FETCH-BI-BG-EPP.                                            
           EXEC SQL                                                     
                FETCH BI_BG_EPP INTO                                    
                  :BG-BILL-NO,                                          
                  :BG-CODE-UTIL-TYPE,                                   
                  :BG-IC-NO,                                            
                  :BG-BILL-ITEM-TIMESTMP,                               
                  :BG-CODE-REVENUE-CLASS,                               
                  :BG-RATE-PLAN-NO,                                     
                  :BG-REV-MTH-ORIG-BILL,                                
                  :BG-REVENUE-MONTH,                                    
                  :BG-GAS-BASE-USE,                                     
                  :BG-WNA-FACTOR,                                       
                  :BG-BTU-FACTOR,                                       
                  :BG-AMT-BILL-ITEM,                                    
                  :BG-AMT-STATE-TAX,                                    
                  :BG-AMT-CITY-TAX,                                     
T22742            :BG-PRORATE-CD                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
              MOVE 'BG'                 TO WS-DB2-TABLE-ID              
              MOVE 'FETCH '             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '112'                TO WS-DB2-MODULE-ID             
              MOVE '7010'               TO WS-DB2-PARAGRAPH             
              MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BG-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
              MOVE BG-IC-NO             TO WS-DB2-KEY-3N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                
                                                                        
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33800000
       7020-CLOSE-BI-BG-EPP.                                            
           EXEC SQL                                                     
                CLOSE BI_BG_EPP                                         
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
P00694*--------------------------------------------------               33880000
P00694*  GET CX UNITS FOR HISTORY                                       33880000
P00694*--------------------------------------------------               33880000
P00694 7025-GET-HIST-UNITS.                                             
P00694     EXEC SQL                                                     
P00694          SELECT  SUM(NO_UNITS)                                   
P00694            INTO  :CX-NO-UNITS :WS-NULL-IND1                       
P00694            FROM  CSS_CNSMPTN_HIST  CX WITH(READUNCOMMITTED)              
P00694          WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                   
P00694            AND BILL_NO        = :BG-BILL-NO                      
P00694            AND ((CX.CODE_UTIL_TYPE      = 'E'                    
P00694                  AND CX.CODE_USAGE_TYPE = 'B') OR                
P00694                 (CX.CODE_UTIL_TYPE      = 'G'                    
P00694                  AND CX.CODE_USAGE_TYPE = 'C'))                  
P00694            AND IC_NO          = :BG-IC-NO                        
P00694            AND BILL_ITEM_TIMESTMP                                
P00694                               = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )           
P00694                                                      
P00694                                                           
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     35540000
MFA-TR*         SELECT  SUM(NO_UNITS)                                   08050000
MFA-TR*           INTO  :CX-NO-UNITS:WS-NULL-IND1                       08050000
MFA-TR*           FROM  CSS_CNSMPTN_HIST  CX                            08050000
MFA-TR*         WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                   08420000
MFA-TR*           AND BILL_NO        = :BG-BILL-NO                      08430000
MFA-TR*           AND ((CX.CODE_UTIL_TYPE      = 'E'                    08440000
MFA-TR*                 AND CX.CODE_USAGE_TYPE = 'B') OR                08440000
MFA-TR*                (CX.CODE_UTIL_TYPE      = 'G'                    08440000
MFA-TR*                 AND CX.CODE_USAGE_TYPE = 'C'))                  08440000
MFA-TR*           AND IC_NO          = :BG-IC-NO                        08450000
MFA-TR*           AND BILL_ITEM_TIMESTMP                                08460000
MFA-TR*                              = :BG-BILL-ITEM-TIMESTMP           08470000
MFA-TR*          QUERYNO 7025                                                   
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    33840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694                                                                  
P00694     IF SQLCODE = SUCCESSFUL-CALL OR  NOT-FOUND                   
P00694        IF WS-NULL-IND1    = -1                                   
P00694           MOVE ZEROS TO CX-NO-UNITS                              
P00694        END-IF                                                    
P00694     ELSE                                                         
P00694        MOVE 'CX'                 TO WS-DB2-TABLE-ID              
P00694        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
P00694        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
P00694        MOVE '112'                TO WS-DB2-MODULE-ID             
P00694        MOVE '7025'               TO WS-DB2-PARAGRAPH             
P00694        MOVE BG-ACCOUNT-NO        TO WS-DB2-KEY-1N                
P00694        MOVE BG-CODE-UTIL-TYPE    TO WS-DB2-KEY-2                 
P00694        MOVE BG-IC-NO             TO WS-DB2-KEY-3N                
P00694        MOVE 12 TO RETURN-CODE                                    
P00694        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
P00694     END-IF.                                                      
P00694                                                                  
P00694 7025-EXIT.                                                       
P00694      EXIT.                                                       
      *                                                                 33880000
P00694*--------------------------------------------------               33880000
P00694*  GET CX UNITS FOR CURRENT MONTH                                 33880000
P00694*--------------------------------------------------               33880000
P00694 7030-GET-CUR-MTH-UNITS.                                          
P00694     MOVE ZEROS TO CX-NO-UNITS.                                   
P00694     PERFORM VARYING WS-CNSMPTN-INDX FROM 1 BY 1                  
P00694               UNTIL WS-CNSMPTN-INDX > 200                        
P00694                  OR WS-ACCOUNT-NO-CX (WS-CNSMPTN-INDX) = ZERO    
P00694        IF WS-BILL-NO-CX (WS-CNSMPTN-INDX)                        
P00694               =  BG-BILL-NO                                      
P00694           AND WS-CODE-UTIL-TYPE-CX (WS-CNSMPTN-INDX)             
P00694               = BG-CODE-UTIL-TYPE                                
P00694           AND WS-IC-NO-CX (WS-CNSMPTN-INDX)                      
P00694               = BG-IC-NO                                         
P00694           AND WS-BILL-ITEM-TIMESTMP-CX (WS-CNSMPTN-INDX)         
P00694               = BG-BILL-ITEM-TIMESTMP                            
P00694             ADD WS-NO-UNITS-CX (WS-CNSMPTN-INDX) TO CX-NO-UNITS  
P00694        END-IF                                                    
P00694     END-PERFORM.                                                 
P00694 7030-EXIT.                                                       
P00694      EXIT.                                                       
                                                                        
      /*******************************************************          33890000
      * OPEN THE CURSOR FOR THE CONSUMPTION HISTORY SEARCH OF*          33900000
      * THE DATABASE TABLE: CSS_CNSMPTN_HIST.                *          33910000
      ********************************************************          33920000
       7100-OPEN-CNSMPTN-HIST.                                          
                                                                        
T22520     MOVE 'N'  TO  WS-181-SW.                                     
T34243     MOVE 'N'  TO  WS-180-SW.                                     
                                                                        
           EXEC SQL                                                     
                OPEN CNSMPTN_HIST                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T34243*ADDED -180 CHECK TO THE IF BELOW                                         
T22520     IF SQLCODE  =  -181  OR -180                                 
T34243       IF SQLCODE  =  -181                                        
T22520        MOVE 'Y'  TO  WS-181-SW                                   
T34243       END-IF                                                     
T34243*                                                                         
T34243       IF SQLCODE  =  -180                                        
T34243         MOVE 'Y'  TO  WS-180-SW                                  
T34243       END-IF                                                     
T22520*       CREATE WQ                                                 34030000
T22520*       UPDATE HOLD BILL CODE (TO CREATE AN EXCEPTION BILL,       34040000
T22520*                              IT DOES NOT GO OUT THE DOOR.)      34050000
C28085        IF WS-CODE-BUDGET = 'A'                                   
T23829           IF SEB-DATABASE                                        
T23829             AND WS-CODE-TEMP-BILL-AT = 'R'                       
T23829               MOVE WS-EPP-MONTH-NOT-FOUND TO WS-WORK-MESSAGE     
T23829                 PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT    
T23829           ELSE                                                   
T22520             MOVE 'X'                   TO   WS-CODE-TEMP-BILL-AT 
T22520             MOVE WS-EPP-MONTH-NOT-FOUND    TO   WS-WORK-MESSAGE  
T22520             PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT        
T23829           END-IF                                                 
C28085        END-IF                                                    
T32040        IF WS-MONITOR-EPP-FLAG = 'Y'                              
T32040           MOVE WS-EPP-BALANCE-WARNING-E TO WS-WORK-MESSAGE       
T32040           PERFORM 5100-PROCESS-EXCEPTION THRU 5100-EXIT          
T32040        END-IF                                                    
T22520     ELSE                                                         
              IF SQLCODE NOT = SUCCESSFUL-CALL                          
                MOVE 'CX'                    TO WS-DB2-TABLE-ID         
                MOVE 'OPEN  '                TO WS-DB2-FUNCTION         
                MOVE SQLCODE                 TO WS-DB2-RETURN-CODE      
                MOVE '112'                   TO WS-DB2-MODULE-ID        
                MOVE '7100'                  TO WS-DB2-PARAGRAPH        
                MOVE CX-ACCOUNT-NO           TO WS-DB2-KEY-1N           
                MOVE CX-CODE-UTIL-TYPE       TO WS-DB2-KEY-2            
                MOVE CX-IC-NO                TO WS-DB2-KEY-3N           
                MOVE 12 TO RETURN-CODE                                  
                PERFORM 9901-SQL-ERROR     THRU 9901-EXIT               
T22520        END-IF                                                    
T22520     END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 34320000
       7110-FETCH-CNSMPTN-HIST.                                         
           EXEC SQL                                                     
                FETCH CNSMPTN_HIST INTO                                 
                    :CX-ACCOUNT-NO,                                     
                    :CX-BILL-NO,                                        
                    :CX-CODE-UTIL-TYPE,                                 
                    :CX-IC-NO,                                          
                    :CX-BILL-ITEM-TIMESTMP,                             
                    :CX-CODE-TIME-PERIOD,                               
                    :CX-MTR-REF-NO,                                     
                    :CX-CODE-USAGE-TYPE,                                
                    :CX-CODE-USAGE-ID,                                  
                    :CX-CODE-USAGE-SOURCE,                              
                    :CX-ITEM-SEQ-NO,                                    
                    :CX-METER-NO,                                       
                    :CX-REG-ID-NO,                                      
                    :CX-DATE-READ :WS-NULL-IND1,                        
                    :CX-CODE-METER-READ,                                
                    :CX-CODE-METER-NO-READ,                             
                    :CX-METER-READING,                                  
                    :CX-DEMAND-READING,                                 
                    :CX-EMPLOYEE-NO,                                    
                    :CX-NO-UNITS,                                       
                    :CX-NO-DEMAND-UNITS,                                
                    :CX-NO-DAYS,                                        
                    :CX-CODE-SOURCE-ID,                                 
                    :CX-CODE-DEBIT-CREDIT,                              
                    :CX-CODE-ITEM-STATUS,                               
                    :CX-CODE-DISCOUNT,                                  
                    :CX-CONSTANT,                                       
                    :CX-NO-DIALS,                                       
                    :CX-COMPANY-NO,                                     
                    :CX-EXCEPT-OVERRIDE-CD,                             
                    :CX-REQUESTED-USAGE,                                
                    :CX-DIGTL-INTRL-MTR-NO,                             
                    :CX-DIGTL-MTR-TYPE,                                 
                    :CX-CODE-TOU-SEASN,                                 
                    :CX-EXCL-DMD-RCHT-IND                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
             MOVE 'CX'                    TO WS-DB2-TABLE-ID            
             MOVE 'FETCH '                TO WS-DB2-FUNCTION            
             MOVE SQLCODE                 TO WS-DB2-RETURN-CODE         
             MOVE '112'                   TO WS-DB2-MODULE-ID           
             MOVE '7110'                  TO WS-DB2-PARAGRAPH           
             MOVE CX-ACCOUNT-NO           TO WS-DB2-KEY-1N              
             MOVE CX-CODE-UTIL-TYPE       TO WS-DB2-KEY-2               
             MOVE CX-IC-NO                TO WS-DB2-KEY-3N              
             MOVE 12 TO RETURN-CODE                                     
             PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                 
                                                                        
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-CLOSE-CNSMPTN-HIST.                                         
           EXEC SQL                                                     
                CLOSE CNSMPTN_HIST                                      
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 34960000
      /*******************************************************          34970000
      * OPEN THE CURSOR FOR THE UNMETERED CONSUMPTION HISTORY*          34980000
      * SEARCH FOR THE DATABASE TABLE: CSS_UM_CNSMPT_HIST.   *          34990000
      ********************************************************          35000000
       7200-OPEN-UM-CNSMPT-HIST.                                        
           EXEC SQL                                                     
                OPEN UM_CNSMPT_HIST                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
             MOVE 'UC'                    TO WS-DB2-TABLE-ID            
             MOVE 'OPEN  '                TO WS-DB2-FUNCTION            
             MOVE SQLCODE                 TO WS-DB2-RETURN-CODE         
             MOVE '112'                   TO WS-DB2-MODULE-ID           
             MOVE '7200'                  TO WS-DB2-PARAGRAPH           
             MOVE UC-ACCOUNT-NO           TO WS-DB2-KEY-1N              
             MOVE UC-CODE-UTIL-TYPE       TO WS-DB2-KEY-2               
             MOVE UC-IC-NO                TO WS-DB2-KEY-3N              
             MOVE 12 TO RETURN-CODE                                     
             PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                 
                                                                        
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 35210000
       7210-FETCH-UM-CNSMPT-HIST.                                       
           EXEC SQL                                                     
                FETCH UM_CNSMPT_HIST INTO                               
                    :UC-ACCOUNT-NO,                                     
                    :UC-BILL-NO,                                        
                    :UC-CODE-UTIL-TYPE,                                 
                    :UC-IC-NO,                                          
                    :UC-BILL-ITEM-TIMESTMP,                             
                    :UC-RATE-ITEM-CODE,                                 
                    :UC-ITEM-SEQ-NO,                                    
                    :UC-NO-UNITS,                                       
                    :UC-NO-DAYS,                                        
                    :UC-CODE-DEBIT-CREDIT,                              
                    :UC-USAGE-FIXED,                                    
                    :UC-DATE-USAGE-ENDS,                                
                    :UC-CODE-SERVICE-TYPE,                              
                    :UC-CODE-ITEM-STATUS,                               
                    :UC-CODE-SOURCE-ID,                                 
                    :UC-MTHLY-AMOUNT-FIXED,                             
                    :UC-DIST-NO,                                        
                    :UC-LIGHT-NO,                                       
                    :UC-POLE-NO                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
             MOVE 'UC'                    TO WS-DB2-TABLE-ID            
             MOVE 'FETCH '                TO WS-DB2-FUNCTION            
             MOVE SQLCODE                 TO WS-DB2-RETURN-CODE         
             MOVE '112'                   TO WS-DB2-MODULE-ID           
             MOVE '7210'                  TO WS-DB2-PARAGRAPH           
             MOVE UC-ACCOUNT-NO           TO WS-DB2-KEY-1N              
             MOVE UC-CODE-UTIL-TYPE       TO WS-DB2-KEY-2               
             MOVE UC-IC-NO                TO WS-DB2-KEY-3N              
             MOVE 12 TO RETURN-CODE                                     
             PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                 
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 35600000
       7220-CLOSE-UM-CNSMPT-HIST.                                       
           EXEC SQL                                                     
                CLOSE UM_CNSMPT_HIST                                    
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 35680000
P00307****************************************************************          
P00307**       7300-GET-DELINQ-VALUE                                **          
P00307****************************************************************  35698000
P00307 7300-GET-DELINQ-VALUE.                                           
P00307                                                                  
P00307     EXEC SQL                                                     
P00307         SELECT  C8.DELINQ_VALUE                                  
P00307           INTO :C8-DELINQ-VALUE                                  
P00307           FROM  CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                 
P00307           WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                    
P00307             AND C8.COMPANY_NO = :C8-COMPANY-NO                   
P00307                                                           
P00307                                                      
P00307     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     35540000
MFA-TR*        SELECT  C8.DELINQ_VALUE                                  35550000
MFA-TR*          INTO :C8-DELINQ-VALUE                                  35560000
MFA-TR*          FROM  CSS_DELINQUENCY C8                               35570000
MFA-TR*          WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                    35580000
MFA-TR*            AND C8.COMPANY_NO = :C8-COMPANY-NO                   35590000
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7300                                                   
MFA-TR*    END-EXEC.                                                    35600000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00307                                                                  
P00307     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00307                                                                  
P00307     IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
P00307         NEXT SENTENCE                                            
P00307     ELSE                                                         
P00307        MOVE 'C8'                    TO WS-DB2-TABLE-ID           
P00307        MOVE 'SELECT'                TO WS-DB2-FUNCTION           
P00307        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
P00307        MOVE '112'                   TO WS-DB2-MODULE-ID          
P00307        MOVE '7300'                  TO WS-DB2-PARAGRAPH          
P00307        MOVE WS-ACCOUNT-NO-AT        TO WS-DB2-KEY-1N             
P00694        MOVE C8-DELINQ-CD            TO WS-DB2-KEY-2              
P00694        MOVE C8-COMPANY-NO           TO WS-DB2-KEY-3              
P00307        MOVE 12 TO RETURN-CODE                                    
P00307        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
P00307     END-IF.                                                      
P00307 7300-EXIT.                                                       
P00307     EXIT.                                                        
                                                                        
P00307*****************************************************************         
P00307*    CHECK FOR EXEMPTION ROW IN CSS_ATTRIBUTE TABLE.                      
P00307*****************************************************************         
P00307 7310-CHECK-EXEMPT-FLAG.                                          
P00307*                                                                         
P00307     EXEC SQL                                                     
P00307         SELECT ATTRIBUTE_VALUE_CD                                
P00307           INTO :YP-ATTRIBUTE-VALUE-CD                            
P00307           FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                  
P00307          WHERE ACCOUNT_NO           = :YP-ACCOUNT-NO             
P00307            AND ATTRIBUTE_DESC       = :YP-ATTRIBUTE-DESC         
P00307                                                           
P00307                                                      
P00307     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ATTRIBUTE_VALUE_CD                                        
MFA-TR*          INTO :YP-ATTRIBUTE-VALUE-CD                                    
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE                                        
MFA-TR*         WHERE ACCOUNT_NO           = :YP-ACCOUNT-NO                     
MFA-TR*           AND ATTRIBUTE_DESC       = :YP-ATTRIBUTE-DESC                 
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7310                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00307*                                                                         
P00307     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00307                                                                  
P00307     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00307        MOVE 'Y' TO WS-EXEMPT-FLAG                                
P00307     ELSE                                                         
P00307         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
P00307             MOVE 'N' TO WS-EXEMPT-FLAG                           
P00307         ELSE                                                     
P00307             MOVE 'YP'                    TO WS-DB2-TABLE-ID      
P00307             MOVE 'SELECT'                TO WS-DB2-FUNCTION      
P00307             MOVE SQLCODE                 TO WS-DB2-RETURN-CODE   
P00307             MOVE '112'                   TO WS-DB2-MODULE-ID     
P00307             MOVE '7310'                  TO WS-DB2-PARAGRAPH     
P00307             MOVE YP-ACCOUNT-NO           TO WS-DB2-KEY-1N        
P00307             MOVE 12 TO RETURN-CODE                               
P00307             PERFORM 9901-SQL-ERROR     THRU 9901-EXIT            
P00307         END-IF                                                   
P00307     END-IF.                                                      
P00307                                                                  
P00307 7310-EXIT.                                                       
P00307     EXIT.                                                        
                                                                        
P00307********* CHECK TO SEE IF REFUND OTHER THAN DEPOSIT  ******               
P00307*********  EXISTS IN CSS_REFUND                      ******               
P00307 7320-CHECK-FOR-REFUND.                                           
P00307*                                                                         
P00307     EXEC SQL                                                     
P00307         SELECT TOP(1) 'Y'                                               
P00307           INTO :WS-REFUND-EXIST                                  
P00307           FROM CSS_REFUND WITH(READUNCOMMITTED)                          
P00307          WHERE ACCOUNT_NO           = :RN-ACCOUNT-NO             
P00307            AND DEPOSIT_CERT_NO   = 0                             
P00307            AND DATE_REFUNDED     > IIF(TRY_CONVERT(DATE, 
                                                      :RN-DATE-REFUNDED
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED) <> 10), CIS.CHAR2DATE(
                                                      :RN-DATE-REFUNDED
              ), CONVERT(DATE, :RN-DATE-REFUNDED) )             
P00307                                                           
P00307                                              
P00307                                                      
P00307     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-REFUND-EXIST                                          
MFA-TR*          FROM CSS_REFUND                                                
MFA-TR*         WHERE ACCOUNT_NO           = :RN-ACCOUNT-NO                     
MFA-TR*           AND DEPOSIT_CERT_NO   = 0                                     
MFA-TR*           AND DATE_REFUNDED     > :RN-DATE-REFUNDED                     
MFA-TR*         WITH UR                                                         
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         QUERYNO 7320                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00307*                                                                         
P00307     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00307                                                                  
P00307     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00307        CONTINUE                                                  
P00307     ELSE                                                         
P00307        MOVE 'RN'                    TO WS-DB2-TABLE-ID           
P00307        MOVE 'SELECT'                TO WS-DB2-FUNCTION           
P00307        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
P00307        MOVE '112'                   TO WS-DB2-MODULE-ID          
P00307        MOVE '7320'                  TO WS-DB2-PARAGRAPH          
P00307        MOVE RN-ACCOUNT-NO           TO WS-DB2-KEY-1N             
P00307        MOVE 12 TO RETURN-CODE                                    
P00307        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
P00307     END-IF.                                                      
P00307                                                                  
P00307 7320-EXIT.                                                       
P00307     EXIT.                                                        
C26164****************************************************************  36530000
C26164** THIS PROCEDURE WILL GET BUFFER PERCENT FOR SCEG CUSTOMERS  **  36550000
C26164****************************************************************  36570000
C26164 7540-SELECT-SCEG-RATE-PCT.                                       
C26164                                                                  
C26164     EXEC SQL                                                     
C26164         SELECT DELINQ_VALUE                                      
C26164           INTO :C8-DELINQ-VALUE                                  
C26164           FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
C26164           WHERE DELINQ_CD       = :C8-DELINQ-CD                  
C26164             AND COMPANY_NO      = :C8-COMPANY-NO                 
T34990                                                           
C26164     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     36580200
MFA-TR*        SELECT DELINQ_VALUE                                      36580300
MFA-TR*          INTO :C8-DELINQ-VALUE                                  36580400
MFA-TR*          FROM CSS_DELINQUENCY                                   36580500
MFA-TR*          WHERE DELINQ_CD       = :C8-DELINQ-CD                  36580600
MFA-TR*            AND COMPANY_NO      = :C8-COMPANY-NO                 36580700
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    36580800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26164                                                                  
C26164     IF SQLCODE = SUCCESSFUL-CALL                                 
P00694        CONTINUE                                                  
C26164     ELSE                                                         
C26164        MOVE 'C8'                    TO WS-DB2-TABLE-ID           
C26164        MOVE 'SELECT'                TO WS-DB2-FUNCTION           
C26164        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
C26164        MOVE '112'                   TO WS-DB2-MODULE-ID          
C26164        MOVE '7540'                  TO WS-DB2-PARAGRAPH          
C26164        MOVE BG-ACCOUNT-NO           TO WS-DB2-KEY-1N             
C26164        MOVE BG-CODE-UTIL-TYPE       TO WS-DB2-KEY-2              
C26164        MOVE BG-IC-NO                TO WS-DB2-KEY-3N             
C26164        MOVE 12 TO RETURN-CODE                                    
C26164        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                
C26164                                                                  
C26164 7540-EXIT.                                                       
C26164     EXIT.                                                        
      /***************************************************************  36800100
T8752 **    7550-SELECT-RATE-PERCENT.                               **  36800200
T8752 ** THIS PROCEDURE WILL SUPPLY THE RATE PERCENT USED           **  36800300
T8752 ** TO CALCULATE THE MO PAYMENT/ESTIMATE.                      **  36800400
      ****************************************************************  36800500
T8752  7550-SELECT-RATE-PERCENT.                                        
T8752      EXEC SQL                                                     
T8752          SELECT DELINQ_VALUE                                      
C26164           INTO :WS-PCT-ESTRATEINCR-GAS                           
T8752            FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
T31866           WHERE DELINQ_CD       = :WS-DELINQ-CD-VALUE            
C23501             AND COMPANY_NO      = :C8-COMPANY-NO                 
T34990                                                           
T8752      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     36801700
MFA-TR*        SELECT DELINQ_VALUE                                      36801800
MFA-TR*          INTO :WS-PCT-ESTRATEINCR-GAS                           36801900
MFA-TR*          FROM CSS_DELINQUENCY                                   36802000
MFA-TR*          WHERE DELINQ_CD       = :WS-DELINQ-CD-VALUE            36802100
MFA-TR*            AND COMPANY_NO      = :C8-COMPANY-NO                 36802200
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    36802300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T8752      IF SQLCODE NOT = SUCCESSFUL-CALL                             
T8752         MOVE 'C8'                    TO WS-DB2-TABLE-ID           
T8752         MOVE 'SELECT'                TO WS-DB2-FUNCTION           
T8752         MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
T8752         MOVE '112'                   TO WS-DB2-MODULE-ID          
T8752         MOVE '7550'                  TO WS-DB2-PARAGRAPH          
T8752         MOVE BG-ACCOUNT-NO           TO WS-DB2-KEY-1N             
T8752         MOVE BG-CODE-UTIL-TYPE       TO WS-DB2-KEY-2              
T8752         MOVE BG-IC-NO                TO WS-DB2-KEY-3N             
T8752         MOVE 12 TO RETURN-CODE                                    
T8752         PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                
                                                                        
T8752  7550-EXIT.                                                       
T8752      EXIT.                                                        
*                                                                       
T34990/***************************************************************  36800100
T34990**    7566-SELECT-MTRRD-FACTOR.                               **  36800200
T34990** THIS PROCEDURE WILL SUPPLY THE MTRRD CHARGES               **  36800300
T34990** TO CALCULATE THE MO PAYMENT/ESTIMATE.                      **  36800400
T34990****************************************************************  36800500
T34990 7566-SELECT-MTRRD-FACTOR.                                        
T34990     EXEC SQL                                                     
T34990         SELECT DELINQ_VALUE                                      
T34990           INTO :WS-SEB-MTRD-FACTOR                               
T34990           FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
T34990           WHERE DELINQ_CD       = :C8-DELINQ-CD                  
T34990             AND COMPANY_NO      = :C8-COMPANY-NO                 
T34990                                                           
T34990     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     36801700
MFA-TR*        SELECT DELINQ_VALUE                                      36801800
MFA-TR*          INTO :WS-SEB-MTRD-FACTOR                               36801900
MFA-TR*          FROM CSS_DELINQUENCY                                   36802000
MFA-TR*          WHERE DELINQ_CD       = :C8-DELINQ-CD                  36802100
MFA-TR*            AND COMPANY_NO      = :C8-COMPANY-NO                 36802200
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    36802300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T34990     IF SQLCODE NOT = SUCCESSFUL-CALL                             
T34990        MOVE 'C8'                    TO WS-DB2-TABLE-ID           
T34990        MOVE 'SELECT'                TO WS-DB2-FUNCTION           
T34990        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
T34990        MOVE '112'                   TO WS-DB2-MODULE-ID          
T34990        MOVE '7566'                  TO WS-DB2-PARAGRAPH          
T34990        MOVE BG-ACCOUNT-NO           TO WS-DB2-KEY-1N             
T34990        MOVE BG-CODE-UTIL-TYPE       TO WS-DB2-KEY-2              
T34990        MOVE BG-IC-NO                TO WS-DB2-KEY-3N             
T34990        MOVE 12 TO RETURN-CODE                                    
T34990        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                
                                                                        
T34990 7566-EXIT.                                                       
T34990     EXIT.                                                        
*                                                                       
C25936/***************************************************************  36804000
C25936**    7560-SELECT-ARREARS.                                    **  36804100
C25936** SELECTS NON EPP ARREARS AMOUNT                             **  36804200
C25936****************************************************************  36804300
C25936 7560-SELECT-ARREARS.                                             
C25936     EXEC SQL                                                     
C25936         SELECT SUM(AC.AMT_AR_DAY_00)                             
C25936               ,SUM(AC.AMT_AR_DAY_30)                             
C25936               ,SUM(AC.AMT_AR_DAY_60)                             
C25936               ,SUM(AC.AMT_AR_DAY_90)                             
C25936               ,SUM(AC.AMT_UNUSED_CR)                             
C25936           INTO :AC-AMT-AR-DAY-00 :WS-NULL-IND-00                 
C25936               ,:AC-AMT-AR-DAY-30 :WS-NULL-IND-30                 
C25936               ,:AC-AMT-AR-DAY-60 :WS-NULL-IND-60                 
C25936               ,:AC-AMT-AR-DAY-90 :WS-NULL-IND-90                 
C25936               ,:AC-AMT-UNUSED-CR :WS-NULL-IND-UCR                
C25936           FROM CSS_AR_CNTL  AC WITH(READUNCOMMITTED)                     
C25936          WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO             
C25936            AND ((AC.PYMT_PRIORITY_LVL > 50                       
C25936            AND AC.ITEM_ID > 0)                                   
C25936             OR (AC.PYMT_PRIORITY_LVL < 50                        
C25936            AND AC.ITEM_ID = 0))                                  
T34990                                                           
C25936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     36804500
MFA-TR*        SELECT SUM(AC.AMT_AR_DAY_00)                             36804600
MFA-TR*              ,SUM(AC.AMT_AR_DAY_30)                             36804700
MFA-TR*              ,SUM(AC.AMT_AR_DAY_60)                             36804800
MFA-TR*              ,SUM(AC.AMT_AR_DAY_90)                             36804900
MFA-TR*              ,SUM(AC.AMT_UNUSED_CR)                             36805000
MFA-TR*          INTO :AC-AMT-AR-DAY-00 :WS-NULL-IND-00                 36805100
MFA-TR*              ,:AC-AMT-AR-DAY-30 :WS-NULL-IND-30                 36805200
MFA-TR*              ,:AC-AMT-AR-DAY-60 :WS-NULL-IND-60                 36805300
MFA-TR*              ,:AC-AMT-AR-DAY-90 :WS-NULL-IND-90                 36805400
MFA-TR*              ,:AC-AMT-UNUSED-CR :WS-NULL-IND-UCR                36805500
MFA-TR*          FROM CSS_AR_CNTL  AC                                   36805600
MFA-TR*         WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO             36805700
MFA-TR*           AND ((AC.PYMT_PRIORITY_LVL > 50                       36805800
MFA-TR*           AND AC.ITEM_ID > 0)                                   36805900
MFA-TR*            OR (AC.PYMT_PRIORITY_LVL < 50                        36806000
MFA-TR*           AND AC.ITEM_ID = 0))                                  36806100
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    36806200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C25936                                                                  
C25936     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
C25936        IF WS-NULL-IND-00  = -1 AND                               
C25936           WS-NULL-IND-30  = -1 AND                               
C25936           WS-NULL-IND-60  = -1 AND                               
C25936           WS-NULL-IND-90  = -1 AND                               
C25936           WS-NULL-IND-UCR = -1                                   
C25936           MOVE 0 TO AC-AMT-AR-DAY-00                             
C25936                     AC-AMT-AR-DAY-30                             
C25936                     AC-AMT-AR-DAY-60                             
C25936                     AC-AMT-AR-DAY-90                             
C25936                     AC-AMT-UNUSED-CR                             
C25936        END-IF                                                    
C25936     ELSE                                                         
C25936        MOVE 'AC'                    TO WS-DB2-TABLE-ID           
C25936        MOVE 'SELECT'                TO WS-DB2-FUNCTION           
C25936        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
C25936        MOVE '112'                   TO WS-DB2-MODULE-ID          
C25936        MOVE '7560'                  TO WS-DB2-PARAGRAPH          
C25936        MOVE AC-ACCOUNT-NO           TO WS-DB2-KEY-1N             
C25936        MOVE 12                      TO RETURN-CODE               
C25936        PERFORM 9901-SQL-ERROR       THRU 9901-EXIT               
C25936     END-IF.                                                      
C25936                                                                  
C25936 7560-EXIT.                                                       
C25936     EXIT.                                                        
                                                                        
C34216/***************************************************************  36804000
C34216**    7565-SELECT-EPP-ARREARS.                                **  36804100
C34216** SELECTS EPP ARREARS AMOUNT                                 **  36804200
C34216****************************************************************  36804300
C34216 7565-SELECT-EPP-ARREARS.                                         
C34216     EXEC SQL                                                     
C34216         SELECT AC.AMT_AR_DAY_00                                  
C34216               ,AC.AMT_AR_DAY_30                                  
C34216               ,AC.AMT_AR_DAY_60                                  
C34216               ,AC.AMT_AR_DAY_90                                  
C34216               ,AC.AMT_UNUSED_CR                                  
C34216           INTO :AC-AMT-AR-DAY-00 :WS-NULL-IND-00                 
C34216               ,:AC-AMT-AR-DAY-30 :WS-NULL-IND-30                 
C34216               ,:AC-AMT-AR-DAY-60 :WS-NULL-IND-60                 
C34216               ,:AC-AMT-AR-DAY-90 :WS-NULL-IND-90                 
C34216               ,:AC-AMT-UNUSED-CR :WS-NULL-IND-UCR                
C34216           FROM CSS_AR_CNTL  AC                                   
C34216          WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO             
C34216            AND (AC.PYMT_PRIORITY_LVL = 50                        
C34216            AND AC.ITEM_ID = 1)                                   
C34216     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34216                                                                  
C34216     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
C34216        IF WS-NULL-IND-00  = -1 AND                               
C34216           WS-NULL-IND-30  = -1 AND                               
C34216           WS-NULL-IND-60  = -1 AND                               
C34216           WS-NULL-IND-90  = -1 AND                               
C34216           WS-NULL-IND-UCR = -1                                   
C34216           MOVE 0 TO AC-AMT-AR-DAY-00                             
C34216                     AC-AMT-AR-DAY-30                             
C34216                     AC-AMT-AR-DAY-60                             
C34216                     AC-AMT-AR-DAY-90                             
C34216                     AC-AMT-UNUSED-CR                             
C34216        END-IF                                                    
C34216     ELSE                                                         
C34216        MOVE 'AC'                    TO WS-DB2-TABLE-ID           
C34216        MOVE 'SELECT'                TO WS-DB2-FUNCTION           
C34216        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
C34216        MOVE '112'                   TO WS-DB2-MODULE-ID          
C34216        MOVE '7565'                  TO WS-DB2-PARAGRAPH          
C34216        MOVE AC-ACCOUNT-NO           TO WS-DB2-KEY-1N             
C34216        MOVE 12                      TO RETURN-CODE               
C34216        PERFORM 9901-SQL-ERROR       THRU 9901-EXIT               
C34216     END-IF.                                                      
C34216                                                                  
C34216 7565-EXIT.                                                       
C34216     EXIT.                                                        
      /                                                                 36813000
C34569/***************************************************************  36800100
C34569**    7575-GET-BUFF-FIXED-RATE.                               **  36800200
C34569** THIS PROCEDURE WILL DETERMINE THE BUFFER FACTOR TO BE      **  36800300
C34569** USED FOR FIXED RATE SEB ACCOUNTS.                          **  36800400
C34569****************************************************************  36800500
C34569 7575-GET-BUFF-FIXED-RATE.                                        
C34569        IF WS-RATE-CALC-TYPE-CD-BT (WS-BDET-INDX) = '02'          
C34569           MOVE 'PCT-ESTRATEINCR-FR'  TO WS-DELINQ-CD-VALUE       
C34569           PERFORM 7550-SELECT-RATE-PERCENT      THRU 7550-EXIT   
C34569           DIVIDE 100 INTO WS-PCT-ESTRATEINCR-GAS                 
C34569             ON SIZE ERROR                                        
C34569                MOVE 0 TO WS-PCT-ESTRATEINCR-GAS                  
C34569           END-DIVIDE                                             
C34569        ELSE                                                      
C34569           MOVE 'PCT-ESTRATEINCR-GAS' TO WS-DELINQ-CD-VALUE       
C34569           PERFORM 7550-SELECT-RATE-PERCENT      THRU 7550-EXIT   
C34569           DIVIDE 100 INTO WS-PCT-ESTRATEINCR-GAS                 
C34569             ON SIZE ERROR                                        
C34569                MOVE 0 TO WS-PCT-ESTRATEINCR-GAS                  
C34569           END-DIVIDE                                             
C34569        END-IF.                                                   
                                                                        
C34569 7575-EXIT.                                                       
C34569     EXIT.                                                        
      /                                                                 36813000
       7600-OPEN-PRIOR-RATE.                                            
           EXEC SQL                                                     
               OPEN PRIOR_RATE                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'BG'                    TO WS-DB2-TABLE-ID           
              MOVE 'OPEN'                  TO WS-DB2-FUNCTION           
              MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
              MOVE '112'                   TO WS-DB2-MODULE-ID          
              MOVE '7600'                  TO WS-DB2-PARAGRAPH          
              MOVE BG-ACCOUNT-NO           TO WS-DB2-KEY-1N             
              MOVE BG-CODE-UTIL-TYPE       TO WS-DB2-KEY-2              
              MOVE BG-IC-NO                TO WS-DB2-KEY-3N             
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 37010000
       7602-FETCH-PRIOR-RATE.                                           
           EXEC SQL                                                     
               FETCH PRIOR_RATE                                         
               INTO :BG-RATE-PLAN-NO,:BG-RT-PKG-OPT-SEQ-NO,             
                    :BG-BILL-ITEM-TIMESTMP                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
              MOVE 'BG'                    TO WS-DB2-TABLE-ID           
              MOVE 'FETCH'                 TO WS-DB2-FUNCTION           
              MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
              MOVE '112'                   TO WS-DB2-MODULE-ID          
              MOVE '7602'                  TO WS-DB2-PARAGRAPH          
              MOVE BG-ACCOUNT-NO           TO WS-DB2-KEY-1N             
              MOVE BG-CODE-UTIL-TYPE       TO WS-DB2-KEY-2              
              MOVE BG-IC-NO                TO WS-DB2-KEY-3N             
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
           END-IF.                                                      
                                                                        
       7602-EXIT.                                                       
           EXIT.                                                        
      *                                                                 37230000
       7604-CLOSE-PRIOR-RATE.                                           
           EXEC SQL                                                     
               CLOSE PRIOR_RATE                                         
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       7604-EXIT.                                                       
           EXIT.                                                        
                                                                        
T23452****************************************************************          
T23452**    7760-SELECT-BUDGET-HIST.                                **          
T23452** THIS PROCEDURE WILL SEARCH THE DATABASE TABLE              **          
T23452** CSS_BUDGET_HIST TO DETERMINE THE MOST RECENT START UP ROW. **          
T23452****************************************************************          
T23452 7760-SELECT-BUDGET-HIST.                                         
T23452     EXEC SQL                                                     
T23452         SELECT DATE_PYMT_STRT                                    
T23452           INTO :BH-DATE-PYMT-STRT                                
T23452           FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                     
T23452          WHERE ACCOUNT_NO = :BH-ACCOUNT-NO                       
T23452            AND BUD_HIST_SEQ_NO IN                                
T23452                (SELECT MAX(BUD_HIST_SEQ_NO)                      
T23452                   FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)             
T23452                  WHERE ACCOUNT_NO = :BH-ACCOUNT-NO               
T23452                    AND CHANGE_REASON = 'S')                      
T34990                                                           
T23452     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_PYMT_STRT                                            
MFA-TR*          INTO :BH-DATE-PYMT-STRT                                        
MFA-TR*          FROM CSS_BUDGET_HIST                                           
MFA-TR*         WHERE ACCOUNT_NO = :BH-ACCOUNT-NO                               
MFA-TR*           AND BUD_HIST_SEQ_NO IN                                        
MFA-TR*               (SELECT MAX(BUD_HIST_SEQ_NO)                              
MFA-TR*                  FROM CSS_BUDGET_HIST                                   
MFA-TR*                 WHERE ACCOUNT_NO = :BH-ACCOUNT-NO                       
MFA-TR*                   AND CHANGE_REASON = 'S')                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23452*                                                                         
T23452     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
T23452     IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
T23452        MOVE 'BH'                    TO WS-DB2-TABLE-ID           
T23452        MOVE 'SELECT'                TO WS-DB2-FUNCTION           
T23452        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
T23452        MOVE '112'                   TO WS-DB2-MODULE-ID          
T23452        MOVE '7760'                  TO WS-DB2-PARAGRAPH          
T23452        MOVE BH-ACCOUNT-NO           TO WS-DB2-KEY-1N             
T23452        MOVE 4 TO RETURN-CODE                                     
T23452        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                
T23452 7760-EXIT.                                                       
T23452     EXIT.                                                        
T23452*                                                                         
T28606*                                                                         
T28606 7800-SEL-RECENT-CHG.                                             
T28606                                                                  
T28606     EXEC SQL                                                     
T28606       SELECT AMT_MO_PYMT                                         
T28606             ,CHANGE_REASON                                       
T28606             ,REPLACE(REPLACE(CONVERT(CHAR(26), BUD_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') BUD_HIST_SEQ_NO                        
T28606         INTO :BH-AMT-MO-PYMT                                     
T28606             ,:BH-CHANGE-REASON                                   
T28606             ,:BH-BUD-HIST-SEQ-NO                                 
T28606         FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                       
T28606        WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO                  
T28606          AND PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL           
T28606          AND ITEM_ID           = :BH-ITEM-ID                     
T28606          AND BUD_HIST_SEQ_NO   = (SELECT MAX(B1.BUD_HIST_SEQ_NO) 
T28606               FROM CSS_BUDGET_HIST B1 WITH(READUNCOMMITTED)              
T28606              WHERE B1.ACCOUNT_NO          = :BH-ACCOUNT-NO       
T28606                AND B1.PYMT_PRIORITY_LVL   = :BH-PYMT-PRIORITY-LVL
T28606                AND B1.ITEM_ID             = :BH-ITEM-ID          
T28606                AND B1.CHANGE_REASON  IN ('S', 'A'))              
T34990                                                           
T28606     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT AMT_MO_PYMT                                                 
MFA-TR*            ,CHANGE_REASON                                               
MFA-TR*            ,BUD_HIST_SEQ_NO                                             
MFA-TR*        INTO :BH-AMT-MO-PYMT                                             
MFA-TR*            ,:BH-CHANGE-REASON                                           
MFA-TR*            ,:BH-BUD-HIST-SEQ-NO                                         
MFA-TR*        FROM CSS_BUDGET_HIST                                             
MFA-TR*       WHERE ACCOUNT_NO        = :BH-ACCOUNT-NO                          
MFA-TR*         AND PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL                   
MFA-TR*         AND ITEM_ID           = :BH-ITEM-ID                             
MFA-TR*         AND BUD_HIST_SEQ_NO   = (SELECT MAX(B1.BUD_HIST_SEQ_NO)         
MFA-TR*              FROM CSS_BUDGET_HIST B1                                    
MFA-TR*             WHERE B1.ACCOUNT_NO          = :BH-ACCOUNT-NO               
MFA-TR*               AND B1.PYMT_PRIORITY_LVL   = :BH-PYMT-PRIORITY-LVL        
MFA-TR*               AND B1.ITEM_ID             = :BH-ITEM-ID                  
MFA-TR*               AND B1.CHANGE_REASON  IN ('S', 'A'))                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T28606                                                                  
T28606     IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
T28606        MOVE 'BH'                    TO WS-DB2-TABLE-ID           
T28606        MOVE 'SELECT'                TO WS-DB2-FUNCTION           
T28606        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
T28606        MOVE '112'                   TO WS-DB2-MODULE-ID          
T28606        MOVE '7800'                  TO WS-DB2-PARAGRAPH          
T28606        MOVE BH-ACCOUNT-NO           TO WS-DB2-KEY-1N             
T28606        MOVE BH-PYMT-PRIORITY-LVL    TO WS-DB2-KEY-2N             
T28606        MOVE BH-ITEM-ID              TO WS-DB2-KEY-3N             
T28606        MOVE 4 TO RETURN-CODE                                     
T28606        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
T28606     END-IF.                                                      
T28606*                                                                         
T28606 7800-EXIT.                                                       
T28606     EXIT.                                                        
T28606*                                                                         
T28606 7820-OPEN-CHANGED-ROW.                                           
T28606                                                                  
T28606     EXEC SQL                                                     
T28606       OPEN EPP_CHG_CHK                                           
T28606     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T28606                                                                  
T28606     IF SQLCODE NOT = SUCCESSFUL-CALL                             
T28606        MOVE 'BH'                    TO WS-DB2-TABLE-ID           
T28606        MOVE 'OPEN'                  TO WS-DB2-FUNCTION           
T28606        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
T28606        MOVE '112'                   TO WS-DB2-MODULE-ID          
T28606        MOVE '7820'                  TO WS-DB2-PARAGRAPH          
T28606        MOVE BH-ACCOUNT-NO           TO WS-DB2-KEY-1N             
T28606        MOVE BH-PYMT-PRIORITY-LVL    TO WS-DB2-KEY-2N             
T28606        MOVE BH-ITEM-ID              TO WS-DB2-KEY-3N             
T28606        MOVE BH-BUD-HIST-SEQ-NO      TO WS-DB2-KEY-4N             
T28606        MOVE 4 TO RETURN-CODE                                     
T28606        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
T28606     END-IF.                                                      
T28606                                                                  
T28606 7820-EXIT.                                                       
T28606     EXIT.                                                        
T28606                                                                  
T28606 7830-FETCH-CHANGED-ROW.                                          
T28606                                                                  
T28606     EXEC SQL                                                     
T28606       FETCH EPP_CHG_CHK                                          
T28606         INTO :BH-AMT-MO-PYMT                                     
T28606     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T28606                                                                  
T28606     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
T28606     IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
T28606        MOVE 'BH'                    TO WS-DB2-TABLE-ID           
T28606        MOVE 'FETCH'                 TO WS-DB2-FUNCTION           
T28606        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
T28606        MOVE '112'                   TO WS-DB2-MODULE-ID          
T28606        MOVE '7830'                  TO WS-DB2-PARAGRAPH          
T28606        MOVE BH-ACCOUNT-NO           TO WS-DB2-KEY-1N             
T28606        MOVE BH-PYMT-PRIORITY-LVL    TO WS-DB2-KEY-2N             
T28606        MOVE BH-ITEM-ID              TO WS-DB2-KEY-3N             
T28606        MOVE BH-BUD-HIST-SEQ-NO      TO WS-DB2-KEY-4N             
T28606        MOVE 4 TO RETURN-CODE                                     
T28606        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
T28606     END-IF.                                                      
T28606                                                                  
T28606 7830-EXIT.                                                       
T28606     EXIT.                                                        
T28606                                                                  
T28606 7840-CLOSE-CHANGED-ROW.                                          
T28606                                                                  
T28606     EXEC SQL                                                     
T28606       CLOSE EPP_CHG_CHK                                          
T28606     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T28606                                                                  
T28606     IF SQLCODE NOT = SUCCESSFUL-CALL                             
T28606        MOVE 'BH'                    TO WS-DB2-TABLE-ID           
T28606        MOVE 'CLOSE'                 TO WS-DB2-FUNCTION           
T28606        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
T28606        MOVE '112'                   TO WS-DB2-MODULE-ID          
T28606        MOVE '7840'                  TO WS-DB2-PARAGRAPH          
T28606        MOVE BH-ACCOUNT-NO           TO WS-DB2-KEY-1N             
T28606        MOVE BH-PYMT-PRIORITY-LVL    TO WS-DB2-KEY-2N             
T28606        MOVE BH-ITEM-ID              TO WS-DB2-KEY-3N             
T28606        MOVE BH-BUD-HIST-SEQ-NO      TO WS-DB2-KEY-4N             
T28606        MOVE 4 TO RETURN-CODE                                     
T28606        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
T28606     END-IF.                                                      
T28606                                                                  
T28606 7840-EXIT.                                                       
T28606     EXIT.                                                        
T28606                                                                  
      /***************************************************************  37890000
T17777**    7900-GET-AR-TIMESTAMP.                                 **   37900000
T17777**                                                                37910000
T17777** C                                                          **  37920000
T17777****************************************************************  37930000
T17777 7900-GET-AR-TIMESTAMP.                                           
T17777     EXEC SQL                                                     
T34990         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :AR-TRANS-HIST-SEQ-NO            
T17777     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     37950000
MFA-TR*        SET :AR-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP            37980000
MFA-TR*    END-EXEC.                                                    37990000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T17777                                                                  
T17777     IF SQLCODE NOT = SUCCESSFUL-CALL                             
T17777        MOVE 'AR'                    TO WS-DB2-TABLE-ID           
T17777        MOVE 'SELECT'                TO WS-DB2-FUNCTION           
T17777        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
T17777        MOVE '112'                   TO WS-DB2-MODULE-ID          
T17777        MOVE '7900'                  TO WS-DB2-PARAGRAPH          
T17777        MOVE 12 TO RETURN-CODE                                    
T17777        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                
T17777                                                                  
T17777 7900-EXIT.                                                       
T17777     EXIT.                                                        
                                                                        
P00307****************************************************************          
P00307* THIS MODULE GETS CURRENT TIMESTAMP AND DATE FOR CREATING     *          
P00307* JOURNAL ENTRIES                                              *          
P00307*                                                              *          
P00307****************************************************************          
P00307 7950-GET-TIMESTAMP.                                              
P00307                                                                  
P00307     EXEC SQL                                                     
P00307         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :CURRENT-TIMESTAMP               
P00307     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :CURRENT-TIMESTAMP = CURRENT TIMESTAMP                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00307                                                                  
P00307     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00307                                                                  
P00307     IF SQLCODE NOT = SUCCESSFUL-CALL                             
P00307        MOVE '  '                    TO WS-DB2-TABLE-ID           
P00307        MOVE 'SELECT'                TO WS-DB2-FUNCTION           
P00307        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
P00307        MOVE '112'                   TO WS-DB2-MODULE-ID          
P00307        MOVE '7950'                  TO WS-DB2-PARAGRAPH          
P00307        MOVE WS-ACCOUNT-NO-AT        TO WS-DB2-KEY-1N             
P00307        MOVE 12 TO RETURN-CODE                                    
P00307        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                
P00307                                                                  
P00307 7950-EXIT.                                                       
P00307     EXIT.                                                        
P00307****************************************************************          
P00307* THIS MODULE ADDS 5 MINUTES TO CURRENT TIMESTAMP              *          
P00307*                                                              *          
P00307*                                                              *          
P00307****************************************************************          
P00307 7955-GET-TIMESTAMP-AND-DATE.                                     
P00307                                                                  
P00307     EXEC SQL                                                     
P00307         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MINUTE, 5, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :CURRENT-TIMESTAMP,
              :CURRENT-DATE                         
P00307     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :CURRENT-TIMESTAMP = CURRENT TIMESTAMP + 5 MINUTES,          
MFA-TR*            :CURRENT-DATE = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00307                                                                  
P00307     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00307                                                                  
P00307     IF SQLCODE NOT = SUCCESSFUL-CALL                             
P00307        MOVE '  '                    TO WS-DB2-TABLE-ID           
P00307        MOVE 'SELECT'                TO WS-DB2-FUNCTION           
P00307        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
P00307        MOVE '112'                   TO WS-DB2-MODULE-ID          
P00307        MOVE '7955'                  TO WS-DB2-PARAGRAPH          
P00307        MOVE WS-ACCOUNT-NO-AT        TO WS-DB2-KEY-1N             
P00307        MOVE 12 TO RETURN-CODE                                    
P00307        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT
           END-IF.                
P00307                                                                  
P00307 7955-EXIT.                                                       
P00307     EXIT.                                                        
P00307****************************************************************          
P00307******* GET START DATE FOR MAINTENANCE HISTORY TO SEE IF *******          
P00307******* TO SEE IF ACCOUNT HAS BEEN ADJUSTED IN LAST 6TH MTHS ***          
P00307****************************************************************          
P00307 7960-GET-MAINT-START-MONTH.                                      
P00307     EXEC SQL                                                     
P00307       SELECT
              DATEADD( MONTH, -6, IIF(TRY_CONVERT(DATE, 
                                                     :WS-MONITOR-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-MONITOR-DATE-1
              ) <> 0) OR (LEN(:WS-MONITOR-DATE-1
              ) <> 10), CIS.CHAR2DATE(:WS-MONITOR-DATE-1
              ), CONVERT(DATE, :WS-MONITOR-DATE-1) ) )
            INTO
              :WS-MONITOR-DATE 
P00307     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-MONITOR-DATE = DATE(:WS-MONITOR-DATE-1) - 6 MONTHS         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00307                                                                  
P00307     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00307                                                                  
P00307     IF SQLCODE NOT = SUCCESSFUL-CALL                             
P00307        MOVE '  '                    TO WS-DB2-TABLE-ID           
P00307        MOVE 'SELECT'                TO WS-DB2-FUNCTION           
P00307        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
P00307        MOVE '112'                   TO WS-DB2-MODULE-ID          
P00307        MOVE '7960'                  TO WS-DB2-PARAGRAPH          
P00307        MOVE WS-ACCOUNT-NO-AT        TO WS-DB2-KEY-1N             
P00307        MOVE 12 TO RETURN-CODE                                    
P00307        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
P00307      END-IF.                                                     
P00307                                                                  
P00307 7960-EXIT.                                                       
P00307     EXIT.                                                        
P00307****************************************************************          
P00307********** GET THE DATE THE ACCOUNT BILLED TO USE AS ***********          
P00307********** THE START DATE FOR MAINTENANCE HISTORY    ***********          
P00307****************************************************************          
P00307 7970-GET-BILL-DATE.                                              
P00307     EXEC SQL                                                     
P00307       SELECT TOP(1) BI.DATE_BILLED                                      
P00307         INTO :BI-DATE-BILLED                                     
P00307         FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED),                   
P00307              CSS_BILLING_DET BG WITH(READUNCOMMITTED)                    
P00307        WHERE BI.ACCOUNT_NO     = :BG-ACCOUNT-NO                  
P00307          AND BI.ACCOUNT_NO     = BG.ACCOUNT_NO                   
P00307          AND BI.BILL_NO        = BG.BILL_NO                      
P00307          AND BG.REVENUE_MONTH     = :BG-REVENUE-MONTH            
P00307          AND BG.REV_MTH_ORIG_BILL = 0                            
P00307                                              
P00307                                                           
P00307                                                      
P00307     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT BI.DATE_BILLED                                              
MFA-TR*        INTO :BI-DATE-BILLED                                             
MFA-TR*        FROM CSS_BILLING_HDR BI,                                         
MFA-TR*             CSS_BILLING_DET BG                                          
MFA-TR*       WHERE BI.ACCOUNT_NO     = :BG-ACCOUNT-NO                          
MFA-TR*         AND BI.ACCOUNT_NO     = BG.ACCOUNT_NO                           
MFA-TR*         AND BI.BILL_NO        = BG.BILL_NO                              
MFA-TR*         AND BG.REVENUE_MONTH     = :BG-REVENUE-MONTH                    
MFA-TR*         AND BG.REV_MTH_ORIG_BILL = 0                                    
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7970                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00307                                                                  
P00307     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00307                                                                  
ACT002     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
ACT002        CONTINUE                                                  
ACT002     ELSE                                                         
P00307        MOVE 'BG'                    TO WS-DB2-TABLE-ID           
P00307        MOVE 'SELECT'                TO WS-DB2-FUNCTION           
P00307        MOVE SQLCODE                 TO WS-DB2-RETURN-CODE        
P00307        MOVE '112'                   TO WS-DB2-MODULE-ID          
P00307        MOVE '7970'                  TO WS-DB2-PARAGRAPH          
P00307        MOVE BG-ACCOUNT-NO           TO WS-DB2-KEY-1N             
P00307        MOVE BG-REVENUE-MONTH        TO WS-DB2-KEY-2N             
P00307        MOVE 12 TO RETURN-CODE                                    
P00307        PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
ACT002     END-IF.                                                      
P00307                                                                  
P00307 7970-EXIT.                                                       
P00307     EXIT.                                                        
                                                                        
P00307****************************************************************          
P00307********  CHECK TO SEE IF THERE IS AN ADJUSTMENT ROW  **********          
P00307********  IN MAINTENANCE TRANSACTION HISTORY          **********          
P00307****************************************************************          
P00307 7980-CHECK-MAINT-HIST.                                           
P00307     EXEC SQL                                                     
P00307        SELECT TOP(1) 'Y'                                                
P00307          INTO :WS-PREV-ADJUSTMENT                                
P00307          FROM CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED),               
P00307               CSS_MT_TRN_HST_DET MT WITH(READUNCOMMITTED)                
P00307         WHERE MH.ACCOUNT_NO        = :MH-ACCOUNT-NO              
P00307           AND MH.TRANS_HIST_SEQ_NO =  MT.TRANS_HIST_SEQ_NO       
P00307           AND MH.DATE_TRANS       >= IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )             
ACT119           AND MH.APPL_PROGRAM_ID  IN ('PANEL147A','SCSCA112A',   
ACT119                                       'CSR04617A')               
P00307           AND MT.COLUMN_DESC       =  'BBP AMOUNT'               
P00307           AND EXISTS                                             
P00307             (SELECT BH.ACCOUNT_NO                                
P00307                FROM CSS_BUDGET_HIST BH WITH(READUNCOMMITTED)             
P00307                WHERE BH.ACCOUNT_NO        = :MH-ACCOUNT-NO       
P00307                  AND BH.DATE_PYMT_STRT   = IIF(TRY_CONVERT(DATE, 
                                                     :BH-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BH-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BH-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BH-DATE-PYMT-STRT
              ), CONVERT(DATE, :BH-DATE-PYMT-STRT) )    
P00307                  AND BH.PYMT_PRIORITY_LVL = 50                   
P00307                  AND BH.CHANGE_REASON     IN ('M','C')           
P00307                  AND CAST(BH.BUD_HIST_SEQ_NO AS DATE)                    
P00307                               >= IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) ))                
P00307                                              
P00307                                                           
P00307                                                      
P00307    END-EXEC                                                      

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-PREV-ADJUSTMENT                                        
MFA-TR*         FROM CSS_MNT_TRANS_HIST MH,                                     
MFA-TR*              CSS_MT_TRN_HST_DET MT                                      
MFA-TR*        WHERE MH.ACCOUNT_NO        = :MH-ACCOUNT-NO                      
MFA-TR*          AND MH.TRANS_HIST_SEQ_NO =  MT.TRANS_HIST_SEQ_NO               
MFA-TR*          AND MH.DATE_TRANS       >= :BI-DATE-BILLED                     
MFA-TR*          AND MH.APPL_PROGRAM_ID  IN ('PANEL147A','SCSCA112A',           
MFA-TR*                                      'CSR04617A')                       
MFA-TR*          AND MT.COLUMN_DESC       =  'BBP AMOUNT'                       
MFA-TR*          AND EXISTS                                                     
MFA-TR*            (SELECT BH.ACCOUNT_NO                                        
MFA-TR*               FROM CSS_BUDGET_HIST BH                                   
MFA-TR*               WHERE BH.ACCOUNT_NO        = :MH-ACCOUNT-NO               
MFA-TR*                 AND BH.DATE_PYMT_STRT   = :BH-DATE-PYMT-STRT            
MFA-TR*                 AND BH.PYMT_PRIORITY_LVL = 50                           
MFA-TR*                 AND BH.CHANGE_REASON     IN ('M','C')                   
MFA-TR*                 AND DATE(BH.BUD_HIST_SEQ_NO)                            
MFA-TR*                              >= :BI-DATE-BILLED)                        
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7980                                                     
MFA-TR*   END-EXEC                                                              

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00307                                                                  
P00307     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00307                                                                  
P00307     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
P00307        NEXT SENTENCE                                             
P00307     ELSE                                                         
P00307            MOVE 'MN'                    TO WS-DB2-TABLE-ID       
P00307            MOVE 'SELECT'                TO WS-DB2-FUNCTION       
P00307            MOVE SQLCODE                 TO WS-DB2-RETURN-CODE    
P00307            MOVE '112'                   TO WS-DB2-MODULE-ID      
P00307            MOVE '7980'                  TO WS-DB2-PARAGRAPH      
P00307            MOVE MH-ACCOUNT-NO           TO WS-DB2-KEY-1N         
P00307            MOVE BI-DATE-BILLED          TO WS-DB2-KEY-2N         
P00307            MOVE 12 TO RETURN-CODE                                
P00307            PERFORM 9901-SQL-ERROR     THRU 9901-EXIT             
P00307     END-IF.                                                      
P00307                                                                  
P00307 7980-EXIT.                                                       
P00307     EXIT.                                                        
      *                                                                 38480000
       8100-INSERT-BUDGET-HIST.                                         
           EXEC SQL                                                     
                INSERT INTO CSS_BUDGET_HIST                             
                 (ACCOUNT_NO,                                           
                  PYMT_PRIORITY_LVL,                                    
                  ITEM_ID,                                              
                  BUD_HIST_SEQ_NO,                                      
                  AMT_MO_PYMT,                                          
                  UTILITY_BALANCE,                                      
                  BALANCE_FORWARD,                                      
T8752             EPP_ESTIMATE,                                         
T8752             EPP_MTHS_RMNG_QT,                                     
                  METHOD_OF_ESTIMATE,                                   
                  CHANGE_REASON,                                        
                  DATE_PYMT_STRT,                                       
                  LAST_UPDATE_TS,                                       
T9678             REMARKS,                                              
P00307            BUDG_BILL_PREV_AMT                                    
P00694           ,LAST_UPDATE_USERID)                                   
                VALUES                                                  
                 (:BH-ACCOUNT-NO,                                       
                  :BH-PYMT-PRIORITY-LVL,                                
                  :BH-ITEM-ID,                                          
P00307            CIS.CHAR2TIMESTAMP(:BH-BUD-HIST-SEQ-NO),                      
                  :BH-AMT-MO-PYMT,                                      
                  :BH-UTILITY-BALANCE,                                  
                  :BH-BALANCE-FORWARD,                                  
T8752             :BH-EPP-ESTIMATE,                                     
T8752             :BH-EPP-MTHS-RMNG-QT,                                 
                  'C',                                                  
                  :BH-CHANGE-REASON,                                    
                  IIF(TRY_CONVERT(DATE, :BH-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BH-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BH-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BH-DATE-PYMT-STRT
              ), CONVERT(DATE, :BH-DATE-PYMT-STRT) ),                          
                  CIS.CURRENT$TIMESTAMP(),                                    
T9678             :BH-REMARKS,                                          
P00307            :BH-BUDG-BILL-PREV-AMT                                
P00694           ,:BH-LAST-UPDATE-USERID)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     38500000
MFA-TR*         INSERT INTO CSS_BUDGET_HIST                             38510000
MFA-TR*          (ACCOUNT_NO,                                           38520000
MFA-TR*           PYMT_PRIORITY_LVL,                                    38530000
MFA-TR*           ITEM_ID,                                              38540000
MFA-TR*           BUD_HIST_SEQ_NO,                                      38550000
MFA-TR*           AMT_MO_PYMT,                                          38560000
MFA-TR*           UTILITY_BALANCE,                                      38570000
MFA-TR*           BALANCE_FORWARD,                                      38580000
MFA-TR*           EPP_ESTIMATE,                                         38590000
MFA-TR*           EPP_MTHS_RMNG_QT,                                     38600000
MFA-TR*           METHOD_OF_ESTIMATE,                                   38610000
MFA-TR*           CHANGE_REASON,                                        38620000
MFA-TR*           DATE_PYMT_STRT,                                       38630000
MFA-TR*           LAST_UPDATE_TS,                                       38640000
MFA-TR*           REMARKS,                                              38650000
MFA-TR*           BUDG_BILL_PREV_AMT                                            
MFA-TR*          ,LAST_UPDATE_USERID)                                           
MFA-TR*         VALUES                                                  38660000
MFA-TR*          (:BH-ACCOUNT-NO,                                       38670000
MFA-TR*           :BH-PYMT-PRIORITY-LVL,                                38680000
MFA-TR*           :BH-ITEM-ID,                                          38690000
MFA-TR*           :BH-BUD-HIST-SEQ-NO,                                  38700000
MFA-TR*           :BH-AMT-MO-PYMT,                                      38710000
MFA-TR*           :BH-UTILITY-BALANCE,                                  38720000
MFA-TR*           :BH-BALANCE-FORWARD,                                  38730000
MFA-TR*           :BH-EPP-ESTIMATE,                                     38740000
MFA-TR*           :BH-EPP-MTHS-RMNG-QT,                                 38750000
MFA-TR*           'C',                                                  38760000
MFA-TR*           :BH-CHANGE-REASON,                                    38770000
MFA-TR*           :BH-DATE-PYMT-STRT,                                   38780000
MFA-TR*           CURRENT TIMESTAMP,                                    38790000
MFA-TR*           :BH-REMARKS,                                          38800000
MFA-TR*           :BH-BUDG-BILL-PREV-AMT                                        
MFA-TR*          ,:BH-LAST-UPDATE-USERID)                                       
MFA-TR*    END-EXEC.                                                    38810000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE 'BH'                 TO WS-DB2-TABLE-ID              
              MOVE 'INSERT'             TO WS-DB2-FUNCTION              
              MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
              MOVE '112'                TO WS-DB2-MODULE-ID             
              MOVE '8100'               TO WS-DB2-PARAGRAPH             
              MOVE BH-ACCOUNT-NO        TO WS-DB2-KEY-1N                
              MOVE BH-PYMT-PRIORITY-LVL TO WS-DB2-KEY-2N                
              MOVE BH-ITEM-ID           TO WS-DB2-KEY-3N                
              MOVE 12 TO RETURN-CODE                                    
              PERFORM 9901-SQL-ERROR     THRU 9901-EXIT                 
           END-IF.                                                      
       8100-EXIT.                                                       
           EXIT.                                                        
      **********************************************************        38970000
      *                                                        *        38980000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **39250000
      **    8300-WRITE-FCSWK03                                        **39260000
      **    WRITE FWK03 FIELDS TO WK03 FILE.                          **39270000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **39280000
T10082 8300-WRITE-FCSWK03.                                              
T10082     IF WS-WK03-COUNT < 0                                         
T10082        MOVE 0 TO WS-WK03-COUNT                                   
T10082     END-IF.                                                      
T10082     ADD 1 TO WS-WK03-COUNT                                       
T13536     IF WS-WK03-COUNT > 5000                                      
T10082        MOVE 'WK03 HOLD TABLE OVERFLOW'                           
T10082          TO WS-MISC-MSG-TEXT                                     
PCR629        MOVE +137 TO WS-MISC-CATEGORY                             
T10082        MOVE +24 TO WS-MISC-MSG-LEN                               
T10082        MOVE 16 TO RETURN-CODE                                    
T10082        PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
T10082     ELSE                                                         
T10082        SET WK03-INDX TO WS-WK03-COUNT                            
T10082        MOVE FIOWK03 TO WS-HOLD-WK03-DATA (WK03-INDX)             
T10082        INITIALIZE FIOWK03                                        
T10082     END-IF.                                                      
T10082                                                                  
T10082 8300-EXIT.                                                       
T10082     EXIT.                                                        
      /*****************************************************************39516100
      *                                                                *39516200
      *     CONTROLS ABNORMAL PROGRAM TERMINATION                      *39517000
      *                                                                *39520000
      ******************************************************************39530000
       9901-SQL-ERROR.                                                  
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
           END-IF.                                                      
                                                                        
           MOVE WS-DATABASE-EXCEPTION                                   
             TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)           
                                                                        
           COMPUTE WS-START-POS                                         
             = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1                 
           MOVE WS-SQL-ERROR-TXT-WQ                                     
             TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)   
           ADD WS-SQL-ERROR-TXT-LEN-WQ                                  
             TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                   
                                                                        
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       9901-EXIT.                                                       
           EXIT.                                                        
      *                                                                 39770000
T10082 9910-MISC-ERROR.                                                 
T10082     IF LS-CURR-WQ-ITEM = 50                                      
T10082        DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
T10082        DISPLAY 'PROCESSING TERMINATED'                           
T10082        MOVE 16 TO RETURN-CODE                                    
T10082     ELSE                                                         
T10082        ADD 1 TO LS-CURR-WQ-ITEM                                  
T10082        SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
                                                                        
T10082        MOVE WS-MISCELLANEOUS-MESSAGE                             
T10082          TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
                                                                        
T10082        MOVE WS-BILL-NO-BG (WS-BILLING-INDX) TO WS-BILL-NO-WQ     
T10082        MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)               
T10082          TO  WS-CODE-UTIL-TYPE-WQ                                
T10082        MOVE WS-IC-NO-BG (WS-BILLING-INDX)  TO  WS-IC-NO-WQ       
T10082        MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)                 
T10082          TO  WS-RATE-PLAN-NO-WQ                                  
                                                                        
T10082        COMPUTE WS-START-POS                                      
T10082          = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1              
T10082        MOVE WS-SUPPLEMENTAL-TXT-WQ                               
T10082          TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)
T10082        ADD WS-SUPPLEMENTAL-TXT-LEN-WQ                            
T10082          TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX)                 
T10082     END-IF.                                                      
                                                                        
T10082     PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
T10082 9910-EXIT.                                                       
T10082     EXIT.                                                        
C34569****************************************************************          
C34569** BATCH ABEND PROCESS (9700-PROCESS-ABEND)                               
C34569****************************************************************          
C34569**                                                                        
C34569      EXEC SQL                                                            
C34569           INCLUDE CPD0023B                                               
C34569      END-EXEC.                                                           
C34569                                                                  
C34569******************************************************************        
C34569* 9000-TERMINATE.                                                *        
C34569******************************************************************        
C34569 9000-TERMINATE.                                                  
C34569     EXIT.                                                        
C34569 9000-EXIT.                                                       
C34569     EXIT.                                                        
C34569                                                                  
C34569*************************************************************             
C34569*  COPY BOOK CONTAINING  9900-ABEND AND 9901-EXIT           *             
C34569*************************************************************             
C34569       EXEC SQL                                                           
C34569           INCLUDE CPD09900                                               
C34569       END-EXEC.                                                          
C34569                                                                  
C34569                                                                  
       9999-BAIL-OUT.                                                   
           EXIT PROGRAM.                                                
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                           *     40130000
