       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA109.                                        
      ***************************************************************** 00030000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00040000
      **                     PRICE WATERHOUSE                        ** 00050000
      **                                                             ** 00060000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00070000
      **                                                             ** 00080000
      ***************************************************************** 00090000
      **               P R O G R A M  S U M M A R Y                  ** 00100000
      **                                                             ** 00110000
      ** THIS PROCEDURE INITIATES REFUNDS FOR FINAL ACCOUNTS WITH    ** 00120000
      ** CREDIT BALANCES. INITIAL SETUP IS TRIGGERED BY THE EXISTENCE** 00130000
      ** OF AN ACCOUNT ON THE DRIVER (PSCA100) AND A CREDIT IN       ** 00140000
      ** TOTAL_AR_BALANCE.  THIS ALSO CREATES A WORK QUEUE ITEM AND  ** 00150000
      ** SUSPENDS PAYMENT OF THE REFUND FOR 2 BILL DAYS.  WHEN IT    ** 00160000
      ** REACHES ITS RELEASE DATE, THE ACCOUNT IS CHECKED TO CONFIRM ** 00170000
      ** THE CREDIT AND THE REFUND IS RELEASED FOR PRINTING.         ** 00180000
      ***************************************************************** 00190000
      **                                                             ** 00200000
      **              PROGRAM  MODIFICATION  LOG                     ** 00210000
      **                                                             ** 00220000
      **    DATE    INITIALS  REASON                                 ** 00230000
      **  ________  ________  ______                                 ** 00240000
      **  02/21/95   TAJ      INITIAL PROGRAM VERSION                ** 00250000
      **  05/23/96   TCB      ADDED CODE TO INSERT THE CORRECT INFO  ** 00251000
      **                      INTO CSS_REFUND.  TPR 4300.            ** 00252000
      **  06/26/96   TCB      ADDED CODE TO CHECK FOR AN EXISTING    ** 00253000
      **                      REFUND.  IF THE ACCOUNT HAS A ZERO     ** 00254000
      **                      BALANCE DELETE THE REFUND ELSE APPROVE ** 00255000
      **                      THE REFUND AND WRITE AR TRANS HISTORY. ** 00256000
      **                      FIXED WORK QUEUE AND AR TRANS HIST SO  ** 00257000
      **                      THEY WOULD BE WRITTEN OUT BY THE DRIVER** 00258000
      **                      PROGRAM.  TPR 4576.                    ** 00259000
      **  07/11/96   TCB      CHANGED CODE IN THE WORK QUEUE ROUTINES** 00259100
      **                      TO CREATE THE WORK QUEUES CORRECTLY.   ** 00259200
      **                      TPR 4850.                              ** 00259300
      **  07/16/96   TCB      CHANGED CODE TO MOVE THE LITERAL 'BILL'** 00259400
      **                      TO RN-PANEL-NO TO INTEGRATE WITH CODE  ** 00259500
      **                      IN PANEL275.  TPR 4916.                ** 00259600
      **  07/18/96   TCB      CHANGED SELECTION STATEMENT TO CHECK   ** 00259700
      **                      FOR CHECK PAYMENTS MADE IN LAST TEN    ** 00259800
      **                      DAYS IN PARAGRAPH 7100.  TPR 4958.     ** 00259900
      **  07/22/96   TCB      ADDED CODE TO POPULATE LOCAL_OFFICE    ** 00260000
      **                      WHEN A REFUND RECORD IS INSERTED AND   ** 00260100
      **                      TO CHECK FOR AN ADDITIONAL ACCOUNT THAT** 00260200
      **                      HAS A WRITE OFF CORRECTLY.  TPR 4991.  ** 00261000
      **  07/23/96   TCB      ADDED CODE TO MOVE ZEROES TO           ** 00262000
      **                      TO RN-REFUND-CHECK-NO AND              ** 00263000
      **                      RN-ORIGINAL-CHECK-NO.  TPR 5002.       ** 00264000
PCR072**  10/15/96   ADA      CHANGED AND ADDED CODE FOR CREDIT IN   ** 00264100
PCR072**                      ADVANCE. THIS IS TO BE ABLE TO REFUND  ** 00264200
PCR072**                      CIA BUT NOT CIA-LIHEAP.                ** 00264300
T9278 **  04/03/97   CSG      MOVE 0 TO AMT TRAN BAL IF REFUNDING A  ** 00264400
      **                      CIA ON A FINAL BILL SO THAT SCSCA113   ** 00264500
      **                      WILL DELETE THE SUMMARY ROW.           ** 00264600
T10895**  05/06/97   CSG      CORRECT THE JOURNALS TO A 101 FORMAT,  ** 00264700
      **                      AMT POSTED IS POSITIVE AND TRAN CODE IS** 00264800
      **                      'B'.                                   ** 00264900
T11892**  06/30/97   CSG      FIX REFUNDS AFTER THE 2 DAY WQ.        ** 00265000
      **                                                             ** 00266000
T12895**  08/21/97   MAD      ADDED NULL INDICATORS TO PARA 7210-.   ** 00267000
      **                       - MODIFIED LOGIC DEPENDENT UPON THESE ** 00268000
      **                          VALUES.                            ** 00269000
      **                                                             ** 00269100
T12929**  08/25/97   MAD      ADDED 'FINAL' ACCOUNTS TO THE ACCOUNT  ** 00269200
      **                       CURSOR - TEST CONDITION 104-50-30.    ** 00269300
T13169**  09/25/97   CSG      CHANGED THE AR-AGE ON JOURNALS.        ** 00269400
T13203**  09/30/97   CSG      UPDATE CODE-CHECK-REFUND WHEN A REFUND ** 00269500
      **                       ROW IS INSERTED (NOT JUST WHEN IT IS  ** 00269600
      **                       APPROVED).                            ** 00269700
T13536**  11/13/97   CSG      INCREASE THE SIZE OF WK03 HOLD AREA.   ** 00269800
CWSCHG**  01/05/98   CSG      CHANGE CWS10000 AND CWS10001 TO        ** 00269900
      **                      CWS1000A/CWS1000B AND CWS1001A/CWS1001B** 00270000
T15199**  03/04/98   CSG      A C/R ON A FINAL ACCOUNT THAT ALREADY  ** 00270100
      **                      HAS A REFUND ROW (2 DAY WINDOW) WILL   ** 00270200
      **                      NEED TO CHANGE THE AMOUNT OF THE REFUND** 00270300
PCR629**  04/24/98     AMG    CHANGED THE CATEGORIES OF SOME         ** 00270400
PCR629**                      WORK QUEUES                            ** 00270500
T17678**  09/09/98   JYL      CHANGED 6430- TO POPULATE WK03-ACCOUNT-**         
T17678**                      NO WITH WS-ACCOUNT-NO.                 **         
T18023**  10/07/98   JER      DO NOT CUT CHECK  AUTOMATICALLY IF     **         
T18023**                      DOLLARS RESIDE IN ANY OTHER AR_CNTL ROW,*         
      **                      INSTEAD CREATE A WQ FOR MANUAL REVIEW  **         
T13213**  10/08/98   JER      FIXED WORK QUEUE FORMATTING.           **         
T18165**  10/12/98   JER      INCLUDED ACCOUNT NO AS KEY IN ABEND    **         
T18061**  10/26/98   JYL      INITIALIZE WS-LIHEAP-PRESENT SWITCH.   **         
T18259**  10/28/98   JYL      INITIALIZE WS-DOLLARS-IN-AR FLAG.                 
T18355**  11/02/98   JYL      CHANGE 7100- SQL STMT. TO INCLUDE JOIN **         
T19741**  04/26/99   KDF      ALWAYS CHECK LAST "PAYMENT BY CHECK"   **         
T19741**                      BEFORE ISSUEING A REFUND CHECK ON FINAL**         
      **                                                                        
T19741**  08/7/99    RDF      CHECK DELINQUENCY TABLE FOR NUMBER OF  **         
T19741**                      DAYS TO ADD TO RELEASE DATE FOR A      **         
T19741**                      REFUND, WHEN PAYMENT, BY CHECK, HAS    **         
T19741**                      BEEN MADE WITHIN 10 DAYS.              **         
      **                                                                        
T20981**  10/19/99   RDF      FOR MULTIPLE ACCOUNTS - IF ONE OF THEM **         
      **                      IS A CHARGE OFF, DO NOT SET            **         
      **                      WS-CODE-MULT-ACCT TO 'YES' IF THIS     **         
      **                      ACCOUNT HAS NO MONEY.                  **         
      **                                                                        
T21086**  11/2/99    RDF      LAST PAYMENT BY CHECK DATE WAS A       **         
T19741**                      WEEKEND.  CHANGED 7600- LOGIC TO ALLOW **         
T19741**                      FOR A WEEKEND PAYMENT DATE.            **         
      **                                                                        
T21381**  1/20/00    RDF      CHECK FOR PRIOR, EXISTING REFUNDS WHEN **         
      **                      ATTEMPTING TO CREATE ANOTHER REFUND DUE**         
      **                      TO CANCLE REBUILD.  DO WHAT CODE SAYS  **         
      **                                                                        
T22367** 11/06/00    VIJAY    MADE CHANGES TO CORECT  THE PROBLEM    **         
      **                      OF REFUNDING CHECK BOTH LIHEAP + REGULAR*         
      **                      CIA AMOUNT.                            **         
      **                                                                        
T23501**  02/13/01   SS82048  DELINQUENCY TABLE CHANGES TO SUPPORT   **         
      **                      MULTI-COMPANY AND PSNC CONVERSION      **         
      **                                                                        
C24613**  10/01/01   AS82045  WHENEVER A CREDIT BALANCE REFUND IS LESS*         
      **                      THAN  THE ACTUAL  CREDIT BALANCE DUE TO *         
      **                      LIHEAP PAYMENT, THE  SUBSEQUENT FINAL   *         
      **                      BILLED ACCOUNTS CARRY THIS CREDIT BALANCE         
      **                      INITIALIZED WS-CIA-LIHEAP-CREDIT FIELD  *         
T27925**  03/19/03  COVANSYS  CHANGED FIELDS DEFINED AS 9(07) TO 9(11)*         
C28160**  11/17/03  MDJ       CHECK IF THE REFUND ELIGIBILITY CODE IS *         
      **                      EQUAL TO 'A' (NOT ELIGIBLE) AND IF IT IS*         
      **                      BYPASS REFUND PROCESSING AND SEND WQS TO*         
      **                      HOMER'S AND BUDDY'S AREAS.              *         
      **                                                                        
T30752*   04/21/04  VIJAY     INCREASE OCCURS OF WS-WORK-DAY-TABLE              
      *                       FROM 300 TO 500 TO ACCOMMODATE                    
      *                       INCREASING THE FORECAST OF CREDIT BUREAU          
      *                       DATE TO 345 BUSINESS DAYS FROM FINAL              
      **                                                                        
T30175*   08/18/08  DAS       PREVENT WQS FROM GENERATING IN SEBP               
      **                                                                        
T34695*   09/27/06  DAS       FIX THE INCORRECT INFO ABOUT LIHEAP SHOWNG        
T34695*                       IN THE WQ - REFUND CREDIT ON FINAL BILL           
      **                                                                        
T36498*   10/13/08  VIJAY     FIX WQ PROCESS TO NOT TO GO INTO RETRY            
      *                       PROCESS IN BILLING.                               
P00097*   02/02/09  SS97726   INCREASE WS-AR-DATA FROM 50 TO 150 AND **         
P00097*                       REMOVE ANY INDX HARD CODING.           **         
A01084*   04/24/09  CVNS      CREATE A NEW WQ CATEGORY ID FOR AN     **         
      *             CHENNAI   ACCOUNT THAT HAS FINAL BILLED WITH     **         
      *                       VOUCHER A/R.                           **         
A00557*   11/06/09  VP98420   STOP REFUND WQ IF NO EXCEPTIONS.       **         
A02798*   11/13/10  NC94746   ACT0003: INCLUDE CREDIT CARD PAYMENTS  **         
A02798*                       ALONG WITH CHECK PAYMENTS TO PROCESS   **         
A02798*                       REFUNDS AFTER APPLYING DELINQUENCY DAYS**         
A02798*                       FROM DELINQUENCY TABLE.                **         
A03082*   12/28/11  NS75440   PREVENT WQ ITEM (CATEGORY ID - 98) FROM**         
A03082*                       GENERATING IN SEB DATABASE             **         
ACT216*   11/03/15  MC95456   CHANGES TO AUTOMATE MANUAL REFUND      **         
ACT216*    A05136             PROCESS.                                          
ACT216*   04/04/16  VIJAY  1. COMPLETE WQS WITH CATEGORY IDS = 34,35,**         
ACT216*    A05136             62,63 AND 556 WHEN MANUAL REFUND IS     *         
ACT216*                       PROCESSESED.                            *         
ACT216*                    2. DELETED TBMFWQ DCLGEN                   *         
ACT216*   09/27/16  VIJAY     INITIALIZE VARIABLES TO AVOID JUNK VALUE*         
ACT216*    A05136             IN FIELDS.                              *         
ACT284*   09/29/16  VIJAY     SET INDEXES TO 1 TO AVOID EXCEPTIONS IN           
ACT284*   A05460              MFES ENVIRONMENT.                                 
ACT292*   10/03/16  VIJAY     CREATE CORRECT REFUND IN FINAL BILLING            
ACT292*   A05460              PROCESSING.                                       
      ***************************************************************** 00271000
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00280000
      **                                                             ** 00290000
      **  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION          ** 00300000
      **  1000 - 1999  INPUT PROCESSING CONTROL PATH                 ** 00310000
      **  2000 - 4999  OUTPUT PROCESSING CONTROL PATH                ** 00320000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00330000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00340000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00350000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00360000
      **  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES         ** 00370000
      **                                                             ** 00380000
      ***************************************************************** 00390000
                                                                        
      /                                                                 00410000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSWK03.                                                    00450000
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDWK03.                                                    00490000
       COPY FIOWK03.                                                    00500000
      /                                                                 00510000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA109'.
MSQ017     COPY MFASQLM.
       01  WS-START                   PIC X(40)                         
           VALUE 'WORKING STORAGE FOR SCSCA109 STARTS HERE'.            
       01  WS-FWK03-STATUS            PIC X(2) EXTERNAL.                
           88  FWK03-SUCCESSFUL       VALUE '00'.                       
                                                                        
      /*****************************************************************00580000
      *   TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS      *00590000
      *   (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM      *00600000
      *   WILL ALWAYS BE SQLCA.                                        *00610000
      ******************************************************************00620000
      /***** SQL COMMUNICATIONS AREA                                    00630000
           EXEC SQL                                                     00640000
               INCLUDE SQLCA                                            00650000
           END-EXEC.                                                    00660000
                                                                        
      /***** CSS_ACCOUNT                                                00680000
           EXEC SQL                                                     00690000
               INCLUDE TBACCT                                           00700000
           END-EXEC.                                                    00710000
                                                                        
      /***** CSS_AR_CNTL                                                00730000
           EXEC SQL                                                     00740000
               INCLUDE TBARCNTL                                         00750000
           END-EXEC.                                                    00760000
                                                                        
      /***** CSS_AR_TRANS_HIST                                          00780000
           EXEC SQL                                                     00790000
               INCLUDE TBARHIST                                         00800000
           END-EXEC.                                                    00810000
                                                                        
      /***** CSS_AR_TRN_HST_DET                                         00830000
           EXEC SQL                                                     00840000
               INCLUDE TBARHDT                                          00850000
           END-EXEC.                                                    00860000
                                                                        
      /***** CSS_NSF_HIST                                               00880000
           EXEC SQL                                                     00890000
               INCLUDE TBNSFHST                                         00900000
           END-EXEC.                                                    00910000
                                                                        
      /***** CSS_REFUND                                                 00930000
           EXEC SQL                                                     00940000
               INCLUDE TBREFUND                                         00950000
           END-EXEC.                                                    00960000
                                                                        
      /***** CSS_BILL_WINDOW                                            00980000
           EXEC SQL                                                     00990000
               INCLUDE TBBILWDW                                         01000000
           END-EXEC.                                                    01010000
                                                                        
      /***** CSS_BILLING_DET                                            01030000
           EXEC SQL                                                     01040000
               INCLUDE TBBLLDET                                         01050000
           END-EXEC.                                                    01060000
                                                                        
      /***** CSS_BATCH_JRNL                                             01080000
           EXEC SQL                                                     01090000
               INCLUDE TBBTJRNL                                         01100000
           END-EXEC.                                                    01110000
                                                                        
      /***** CSS_BCH_JRNL_CNTL                                          01130000
           EXEC SQL                                                     01140000
               INCLUDE TBBJCNTL                                         01150000
           END-EXEC.                                                    01160000
                                                                        
      /***** CSS_MISC_JRNL                                              01180000
           EXEC SQL                                                     01190000
               INCLUDE TBMSJRNL                                         01200000
           END-EXEC.                                                    01210000
                                                                        
      /***** CSS_CUSTOMER                                               01230000
           EXEC SQL                                                     01240000
               INCLUDE TBCUST                                           01250000
           END-EXEC.                                                    01260000
                                                                        
      /***** CSS_ADDR_FORMATTED                                         01280000
           EXEC SQL                                                     01290000
               INCLUDE TBADRFMT                                         01300000
           END-EXEC.                                                    01310000
                                                                        
      /***** CSS_ZIP_CODE                                               01330000
           EXEC SQL                                                     01340000
               INCLUDE TBZIPCD                                          01350000
           END-EXEC.                                                    01360000
                                                                        
      /***** CSS_ADDR_FREEFORM                                          01380000
           EXEC SQL                                                     01390000
               INCLUDE TBADRFRE                                         01400000
           END-EXEC.                                                    01410000
                                                                        
      /***** CSS_MODEL_SQL                                              01480000
           EXEC SQL                                                     01490000
               INCLUDE TBMODEL                                          01500000
           END-EXEC.                                                    01510000
                                                                        
           EXEC SQL                                                     01530000
               INCLUDE TBCDCNTL                                         01540000
           END-EXEC.                                                    01550000
                                                                        
           EXEC SQL                                                     01570000
               INCLUDE TBRSAREA                                         01580000
           END-EXEC.                                                    01590000
      /***** CSS_PREMISE                                                01610000
           EXEC SQL                                                     01620000
               INCLUDE TBPREM                                           01630000
           END-EXEC.                                                    01640000
      *                                                                         
      ****** CSS_DELINQUENCY                                                    
           EXEC SQL                                                             
T19900         INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
C28160*                                                                 00900000
C28160*---< CSS_DEP_ON_HAND    - DO >                                   00910000
C28160     EXEC SQL                                                     00920000
C28160        INCLUDE TBDEPHND                                          00930000
C28160     END-EXEC.                                                    00940000
C28160*                                                                 00950000
T21381     EXEC SQL                                                             
T21381        INCLUDE TBMNHIST                                                  
T21381     END-EXEC.                                                            
      *                                                                         
T21381     EXEC SQL                                                             
T21381        INCLUDE TBMNHDT                                                   
T21381     END-EXEC.                                                            
      *                                                                         
T20981****** CSS_CHRG_OFF                                                       
T20981     EXEC SQL                                                             
T20981         INCLUDE TBCHGOFF                                                 
T20981     END-EXEC.                                                            
      *                                                                         
      *01  WS-WORK-VARIABLES.                                           01660000
      /**************************************************************** 01670000
      **     THE WORK VARIABLE AREA IS USED FOR TRANSIENT DATA. IT   ** 01680000
      **     IS INITIALIZED ON EACH CALL TO THE SUBROUTINE.          ** 01690000
      **     THE OTHER WORK AREAS ARE INITIALIZED UNDER PROGRAM      ** 01700000
      **     CONTROL.  ADD ANY NEW DATA FIELDS ACCORDINGLY.          ** 01710000
      **                                                             ** 01720000
      ****************************************************************/ 01730000
       01  WS-CONSTANTS.                                                
           05  WS-PYMT-TYPE-CASH           PIC X(01)   VALUE 'A'.       
           05  WS-PYMT-TYPE-MO             PIC X(01)   VALUE 'M'.       
           05  WS-PAYMENT                  PIC X(01)   VALUE 'P'.       
           05  WS-CHECK                    PIC X(01)   VALUE 'C'.       
A02798     05  WS-CREDIT-CARD              PIC X(01)   VALUE 'H'.       
           05  WS-A                        PIC X(01)   VALUE 'A'.       
           05  WS-F                        PIC X(01)   VALUE 'F'.       
           05  WS-K                        PIC X(01)   VALUE 'K'.       
           05  WS-J                        PIC X(01)   VALUE 'J'.       
           05  WS-S                        PIC X(01)   VALUE 'S'.       
           05  WS-R                        PIC X(01)   VALUE 'R'.       
           05  WS-B                        PIC X(01)   VALUE 'B'.       
           05  WS-COMPLETE                 PIC X(01)   VALUE 'C'.       
           05  WS-APPROVED                 PIC X(01)   VALUE 'A'.       
           05  WS-REQUESTED                PIC X(01)   VALUE 'R'.       
           05  WS-BATCH                    PIC X(01)   VALUE 'B'.       
T10895*    05  WS-ADJUSTMENT               PIC X(01)   VALUE 'A'.       01870000
           05  WS-FINAL                    PIC X(01)   VALUE 'B'.       
           05  WS-CHARGE-OFF               PIC X(01)   VALUE 'S'.       
TXXXXX     05  WS-ACTIVE                   PIC X(01)   VALUE 'A'.       
           05  WS-INSERT                   PIC X(01)   VALUE 'I'.       
           05  WS-DELETE                   PIC X(01)   VALUE 'D'.       
           05  WS-UPDATE                   PIC X(01)   VALUE 'U'.       
           05  WS-YES                      PIC X(01)   VALUE 'Y'.       
           05  WS-NO                       PIC X(01)   VALUE 'N'.       
           05  WS-RC                       PIC X(03)   VALUE 'RC:'.     
           05  WS-NORMAL                   PIC X(01)   VALUE 'N'.       
           05  WS-REJECT                   PIC X(01)   VALUE 'R'.       
           05  WS-CALC-ERROR               PIC X(01)   VALUE 'K'.       
           05  WS-INDIRECT-JRNL            PIC X(01)   VALUE 'A'.       
T10895     05  WS-CASH-DRAWER-ID           PIC X(01)   VALUE 'X'.       
T36498     05  WS-NO-BILL                  PIC X(01)   VALUE 'X'.       
           05  WS-BAT                      PIC X(03)   VALUE 'BAT'.     
           05  WS-PGRMNAME                 PIC X(08)   VALUE 'SCSCA109'.
           05  WS-SYSTEM                   PIC X(06)   VALUE 'SYSTEM'.  
           05  WS-REFUND                   PIC X(04)   VALUE 'RFND'.    
           05  WS-LAST-PYMT-DATE           PIC X(04)   VALUE 'LPD '.    
           05  WS-SLASH                    PIC X(01)   VALUE '/'.       
           05  WS-DOLLAR                   PIC X(01)   VALUE '$'.       
           05  WS-SEMI                     PIC X(02)   VALUE '; '.      
           05  WS-BILL-EXCEPT-Y-MSG        PIC X(17)                    
                                           VALUE 'BILL EXCEPTION: Y'.   
           05  WS-BILL-EXCEPT-N-MSG        PIC X(17)                    
                                           VALUE 'BILL EXCEPTION: N'.   
           05  WS-MULT-ACCT-Y-MSG          PIC X(12)                    
                                           VALUE 'MULT ACCT: Y'.        
           05  WS-MULT-ACCT-N-MSG          PIC X(12)                    
                                           VALUE 'MULT ACCT: N'.        
           05  WS-BANKRUPTCY-Y-MSG         PIC X(13)                    
                                           VALUE 'BANKRUPTCY: Y'.       
           05  WS-BANKRUPTCY-N-MSG         PIC X(13)                    
                                           VALUE 'BANKRUPTCY: N'.       
           05  WS-RFND-MSG                 PIC X(27)                    
                                  VALUE 'REFUND CREDIT ON FINAL BILL'.  
PCR072     05  WS-LIHEAP-MSG               PIC X(47)                    
PCR072         VALUE 'ACCT NOT ZEROED AT REFUND, LIHEAP MONEY PRESENT'. 
C28160     05  WS-VOUCHER-MSG.                                          
C28160         10  WS-WQ-VOUCHER-MSG-VM        PIC X(89)                
C28160         VALUE 'AGENCY VOUCHER PAID DEPOSIT RECEIVABLES ON ACCOUNT        
C28160-              '. AGENCY IS ELIGIBLE FOR DEPOSIT REFUND'.                 
C28160         10  FILLER                      PIC X(19)                
C28160                           VALUE '   FINAL BILL AMT: '.           
C28160         10  WS-WQ-PAREN-VM1             PIC X(01) VALUE '('.     
C28160         10  WS-WQ-AMT-BILL-ITEM-VM      PIC $$$$$$$$$.99-.       
C28160         10  WS-WQ-PAREN-VM2             PIC X(01) VALUE ')'.     
C28160         10  FILLER                      PIC X(20)                
C28160                           VALUE '   ACCOUNT BALANCE: '.          
C28160         10  WS-WQ-PAREN-VM3             PIC X(01) VALUE '('.     
C28160         10  WS-WQ-ACCT-BAL-VM           PIC $$$$$$$$$.99-.       
C28160         10  WS-WQ-PAREN-VM4             PIC X(01) VALUE ')'.     
C28160     05  WS-PPA-MSG.                                              
C28160         10  WS-WQ-PPA-MSG-PM            PIC X(31)                
C28160              VALUE 'ACCOUNT NOT ELIGIBLE FOR REFUND'.            
C28160         10  FILLER                      PIC X(19)                
C28160                           VALUE '   FINAL BILL AMT: '.           
C28160         10  WS-WQ-PAREN-PM1             PIC X(01) VALUE '('.     
C28160         10  WS-WQ-AMT-BILL-ITEM-PM      PIC $$$$$$$$$.99-.       
C28160         10  WS-WQ-PAREN-PM2             PIC X(01) VALUE ')'.     
C28160         10  FILLER                      PIC X(20)                
C28160                           VALUE '   ACCOUNT BALANCE: '.          
C28160         10  WS-WQ-PAREN-PM3             PIC X(01) VALUE '('.     
C28160         10  WS-WQ-ACCT-BAL-PM           PIC $$$$$$$$$.99-.       
C28160         10  WS-WQ-PAREN-PM4             PIC X(01) VALUE ')'.     
T18023     05  WS-DOLLARS-IN-AR-MSG        PIC X(46)                    
T18023         VALUE 'ACCT HAS OTHER DOLLARS IN AR. REVIEW MANUALLY.'.  
T10895     05  WS-101                      PIC S9(05)  COMP-3           
T10895                                                 VALUE +00101.    
           05  WS-NSC                      PIC S9(04)  COMP-3           
                                                       VALUE +0010.     
           05  WS-NSA                      PIC S9(04)  COMP-3           
                                                       VALUE +0020.     
           05  WS-LPC                      PIC S9(04)  COMP-3           
                                                       VALUE +0030.     
           05  WS-UTE                      PIC S9(04)  COMP-3           
                                                       VALUE +0040.     
           05  WS-UTG                      PIC S9(04)  COMP-3           
                                                       VALUE +0045.     
           05  WS-BUD                      PIC S9(04)  COMP-3           
                                                       VALUE +0050.     
           05  WS-CCC                      PIC S9(04)  COMP-3           
                                                       VALUE +0060.     
           05  WS-CIA                      PIC S9(04)  COMP-3           
                                                       VALUE +0070.     
           05  WS-DEP                      PIC S9(04)  COMP-3           
                                                       VALUE +0080.     
           05  WS-DFA                      PIC S9(04)  COMP-3           
                                                       VALUE +0090.     
           05  WS-CNT                      PIC S9(04)  COMP-3           
                                                       VALUE +0100.     
           05  WS-RVC                      PIC S9(04)  COMP-3           
                                                       VALUE +0110.     
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-TWO-COUNT            PIC S9(01) COMP  VALUE 2.        
           05  WS-NSF-COUNT            PIC S9(09) COMP.                 
           05  WS-BILL-EXCEPT-COUNT    PIC S9(09) COMP.                 
           05  WS-BN-COUNT             PIC S9(09) COMP.                 
           05  WS-RETURN-CHECK-CTR     PIC X(09)  VALUE SPACES.         
           05  WS-START-POS            PIC S9(04) COMP   VALUE ZERO.    
T19900     05  WS-DEL-WORK-AREA        PIC S9(3)  COMP-3 VALUE ZERO.    
T19900     05  WS-REF-TRANS            PIC S9(3)  COMP-3 VALUE ZERO.    
T19900     05  WS-REF-CTR              PIC S9(3)  COMP-3 VALUE ZERO.    
T20981     05  WS-CHRG-OFF-AMT         PIC S9(11)V99   COMP-3 VALUE 0.  
T20981     05  WS-PAR-NULL-IND         PIC S9(04) COMP   VALUE +0.      
T21381     05  WS-REFUND-COMPARE       PIC S9(11)V99   COMP-3 VALUE 0.  
T21381     05  WS-SAVE-PREV-DATE       PIC X(10)       VALUE SPACES.    
T21381     05  WS-SAVE-PREV-AMOUNT     PIC S9(11)V99   COMP-3 VALUE 0.  
T21381     05  CURRENT-DATE                   PIC X(10) VALUE SPACES.   
T21381     05  CURRENT-TIMESTAMP              PIC X(26) VALUE SPACES.   
      *                                                                         
T21381 01  WS-REFUND-MI-AREA.                                           
T21381     05  WS-9-MI-AREA                   PIC 9(11)V99.             
T21381     05  WS-REFUND-FILLER  REDEFINES WS-9-MI-AREA.                
T21381         10  WS-X-MI-AREA               PIC X(13).                
      *                                                                         
       01  WS-CODE-AR-AGE-TEMP.                                         
           05  WS-0-DAYS                   PIC X(01)  VALUE '0'.        
           05  WS-3-DAYS                   PIC X(01)  VALUE '3'.        
           05  WS-6-DAYS                   PIC X(01)  VALUE '6'.        
           05  WS-9-DAYS                   PIC X(01)  VALUE '9'.        
           05  WS-UNUSED-CR                PIC X(01)  VALUE 'P'.        
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-CODE-MULT-ACCT           PIC X   VALUE 'N'.           
           05  WS-DATE-FL                  PIC X   VALUE 'N'.           
           05  WS-DOLLARS-IN-AR            PIC X   VALUE 'N'.           
T19900     05  WS-FOUND                    PIC X   VALUE 'N'.           
T21381     05  WS-FUNKY-REFUND-MAYBE       PIC X   VALUE 'N'.           
T21381     05  WS-AMT-DATE-BOTH-SW         PIC X   VALUE 'N'.           
T21381     05  WS-DO-I-STILL-DO-A-WQ       PIC X   VALUE 'N'.           
C28160     05  WS-CODE-REF-IN-EXISTS       PIC X   VALUE ' '.           
C28160     05  WS-PPA-EXISTS               PIC X   VALUE ' '.           
      *                                                                         
T21381 01  WS-REFUND-ERROR-FIELDS.                                      
T21381     05  WS-811                    PIC S9(9) VALUE -811 COMP.     
      *                                                                         
       01  WS-TEMP-VARIABLES.                                           
FCS        05 WS-AR-INIT-CASH-KEY.                                      
FCS           10 WS-AR-COMPANY-NO        PIC X(02) VALUE '01'.          
FCS           10 WS-AR-REPORT-NO         PIC X(03) VALUE '997'.         
FCS           10 WS-AR-REPORT-DATE       PIC X(10) VALUE SPACES.        
FCS           10 WS-AR-CASH-DRAWER-ID    PIC S9(04) VALUE 9999.         
           05  WS-AMT-TEMP               PIC 9(7)V99.                   
           05  WS-AMT-REFUND             PIC $$$$$9.99.                 
           05  WS-REFUND-RECALC-MSG      PIC X(20).                     
           05  WS-PYMT-TYPE              PIC X(02).                     
           05  WS-PYMT-DATE              PIC X(10).                     
           05  WS-CURRENT-DATE           PIC X(10).                     
T21381     05  WS-FINAL-DATE-7702        PIC X(10) VALUE SPACES.        
T21381     05  WS-AMT-REFUND-MI          PIC $$$$$$$$$9.99.             
T15199     05  WS-NEXT-DATE              PIC X(10).                     
           05  WS-RELEASE-DATE           PIC X(10).                     
           05  WS-FUTURE-DATE            PIC X(10).                     
           05  WS-DEL-WORK-DATE          PIC X(10).                     
           05  WS-DELINQUENCY-DATE       PIC X(10).                     
           05  WS-25-DAYS-AGO            PIC X(10).                     
           05  WS-AMT-00-DAY             PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-AMT-30-DAY             PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-AMT-60-DAY             PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-AMT-90-DAY             PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-AMT-ARREARS            PIC S9(09)V99 COMP-3 VALUE 0.  
PCR072     05  WS-CIA-LIHEAP-CREDIT      PIC S9(09)V99 COMP-3 VALUE 0.  
           05  WS-AMT-00-NULL-IND        PIC S9(04) COMP VALUE +0.      
           05  WS-AMT-30-NULL-IND        PIC S9(04) COMP VALUE +0.      
           05  WS-AMT-60-NULL-IND        PIC S9(04) COMP VALUE +0.      
           05  WS-AMT-90-NULL-IND        PIC S9(04) COMP VALUE +0.      
T12895     05  WS-DT-00-NULL-IND         PIC S9(04) COMP VALUE +0.      
T12895     05  WS-DT-30-NULL-IND         PIC S9(04) COMP VALUE +0.      
T12895     05  WS-DT-60-NULL-IND         PIC S9(04) COMP VALUE +0.      
T12895     05  WS-DT-90-NULL-IND         PIC S9(04) COMP VALUE +0.      
T15199     05  WS-REFUND-NULL            PIC S9(04) COMP VALUE +0.      
           05  WS-DATE-TRANS-NULL-IND    PIC S9(04) COMP VALUE +0.      
           05  WS-2-CYCLES-FROM-NOW      PIC X(10).                     
           05  WS-CODE-AR-AGE            PIC X(01).                     
           05  WS-TOTAL-ARREARS          PIC 9(11)V99.                  
           05  WS-GL-NO                  PIC 9(3)V9(4).                 
COB305     05 WS-NET-RECV-BALANCE        PIC S9(11)V99 COMP-3 VALUE 0.          
COB305     05 WS-AMT-BILLED-UNPAID        PIC S9(11)V99 COMP-3 VALUE 0.         
COB305     05 WS-AMT-ORIG-ENTERED        PIC S9(11)V99 COMP-3 VALUE 0.          
T27925     05  WS-ACCOUNT-END-AR-BAL     PIC S9(11)V99 VALUE ZERO.      
T27925     05  WS-DETAIL-END-AR-BAL      PIC S9(11)V99 VALUE ZERO.      
T27925     05  WS-AMT-TO-POST            PIC S9(11)V99 VALUE ZERO.      
           05  WS-GL-ACCT-DEBIT          PIC 9(7)V9(4).                 
           05  WS-GL-ACCT-CREDIT         PIC 9(7)V9(4).                 
           05  WS-AMT-BILL-ITEM          PIC 9(9)V99.                   
           05  WS-TOT-ACCT-BAL           PIC S9(9)V99.                  
                                                                        
      /**************************************************************** 02970000
      **     PUT ANY PROGRAM SWITCH VARIABLES YOU NEED HERE.  IF     ** 02980000
      **     POSSIBLE, INCLUDE AT LEAST TWO CONDITION NAMES. IN THE  ** 02990000
      **     PROCEDURE DIVISION, USE "SET CONDITION-NAME TO TRUE"    ** 03000000
      **     RATHER THAN "MOVE 'Y' TO INDICATOR-VARIABLE-NAME"       ** 03010000
      **                                                             ** 03020000
      ****************************************************************/ 03030000
       01  WS-SWITCHES-AND-INDICATORS.                                  
           05  WS-EXCEPTION-INDICATOR      PIC X(01).                   
               88  NO-EXCEPTIONS           VALUE '0'.                   
               88  EXCEPTION-ENCOUNTERED   VALUE '1'.                   
                                                                        
           05  WS-REVIEW-REQUIRED          PIC X(01).                   
               88  REVIEW-REQUIRED         VALUE 'Y'.                   
               88  REVIEW-NOT-REQUIRED     VALUE 'N'.                   
                                                                        
                                                                        
           05  WS-SECOND-ROW-COUNT         PIC X(01).                   
               88  WS-IS-SECOND-ROW        VALUE 'Y'.                   
               88  WS-NOT-SECOND-ROW       VALUE 'N'.                   
PCR072                                                                  
PCR072     05  WS-CIA-LIHEAP-PRESENT-SW    PIC X(01).                   
PCR072         88  WS-CIA-LIHEAP-PRESENT       VALUE 'Y'.               
PCR072         88  WS-CIA-LIHEAP-NOT-PRESENT   VALUE 'N'.               
                                                                        
T34695     05  WS-LIHEAP-ONLY-SW           PIC X(01).                   
T34695         88  WS-LIHEAP-PRESENT       VALUE 'Y'.                   
T34695         88  WS-LIHEAP-NOT-PRESENT   VALUE 'N'.                   
                                                                        
C28160     05  WS-CIA-VOUCHER-PRESENT-SW    PIC X(01).                  
C28160         88  WS-CIA-VOUCHER-PRESENT       VALUE 'Y'.              
C28160         88  WS-CIA-VOUCHER-NOT-PRESENT   VALUE 'N'.              
                                                                        
      /********************************************************         03170000
      *                                                       *         03180000
      *   WORKING STORAGE FOR WQ MESSAGE TEXT (IF APPLICABLE) *         03190000
      *   EACH MESSAGE WILL HAVE ITS OWN TEXT.                *         03200000
      *                                                       *         03210000
      *********************************************************         03220000
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-MSG-PART-1                PIC X(20) VALUE SPACES.     
           05  WS-MSG-PART-2                PIC X(20) VALUE SPACES.     
           05  WS-MSG-PART-3                PIC X(20) VALUE SPACES.     
           05  WS-MSG-PART-4                PIC X(20) VALUE SPACES.     
           05  WS-MSG-PART-5                PIC X(20) VALUE SPACES.     
           05  WS-MSG-PART-6                PIC X(20) VALUE SPACES.     
PCR072     05  WS-MSG-PART-7                PIC X(47) VALUE SPACES.     
T18023     05  WS-MSG-PART-8                PIC X(47) VALUE SPACES.     
C28160     05  WS-MSG-PART-9                PIC X(160) VALUE SPACES.    
                                                                        
           05  WS-MESSAGE-PATTERN-QUEUE.                                
               10  WS-CATEGORY-ID-QUEUE     PIC S9(04) COMP.            
               10  WS-ROUTE-CATEGORY-QUEUE  PIC  X(01).                 
               10  WS-DATE-REQUIRED-QUEUE   PIC  X(10).                 
               10  WS-MESSAGE-LENGTH-QUEUE  PIC S9(04) COMP.            
PCR072         10  WS-MESSAGE-TEXT-QUEUE    PIC  X(167).                
                                                                        
           05  WS-FINAL-REVIEW.                                         
               10  WS-WQ-CATEGORY          PIC S9(4)  COMP VALUE +0.    
               10  FILLER                  PIC X(01)  VALUE 'N'.        
               10  FILLER                  PIC X(01)  VALUE '4'.        
               10  WS-REVIEW-TEXT-LENGTH   PIC S9(4)  COMP.             
PCR072         10  WS-REVIEW-TEXT-MSG      PIC X(167).                  
                                                                        
           05  WS-DATABASE-EXCEPTION.                                   
PCR629         10  FILLER                  PIC S9(4)  COMP VALUE +137.  
               10  FILLER                  PIC X(01)  VALUE 'N'.        
               10  FILLER                  PIC X(01)  VALUE '4'.        
               10  FILLER                  PIC S9(4)  COMP  VALUE +29.  
               10  FILLER                  PIC X(30)  VALUE             
                   'A DATABASE EXCEPTION OCCURRED'.                     
                                                                        
           05  WS-MISCELLANEOUS-MESSAGE.                                
C28160         10  WS-MISC-CATEGORY        PIC S9(4).                   
               10  FILLER                  PIC X(01)  VALUE 'N'.        
               10  FILLER                  PIC X(01)  VALUE '4'.        
               10  WS-MISC-MSG-LEN         PIC S9(4).                   
               10  WS-MISC-MSG-TEXT        PIC X(60).                   
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                PIC X(08)  VALUE 'SCSCA109'. 
           05  WS-SAVE-FWK03-KEY           PIC X(43)  VALUE SPACES.     
           05  WS-SAVE-FWK03-SEQ-NO        PIC 9(04)  VALUE ZERO.       
      *                                                                         
       01  WS-REFUND-MH-MSG-AREA.                                       
           05  WS-MH-MSG-1                 PIC X(36)                    
                VALUE 'REFUND ROW TYPE R - DATE CHANGE ONLY'.           
           05  WS-MH-MSG-2                 PIC X(38)                    
                VALUE 'REFUND ROW TYPE R - AMOUNT CHANGE ONLY'.         
           05  WS-MH-MSG-3                 PIC X(42)                    
                VALUE 'REFUND ROW TYPE R - AMOUNT AND DATE CHANGE'.     
      *                                                                         
       01  WS-REFUND-MSG-AREA.                                          
           05  WS-REFUND-MSG-1              PIC X(20)                   
                VALUE 'REFUND CHANGE DUE TO'.                           
           05  WS-REFUND-MSG-2              PIC X(20)                   
                VALUE ' CANCEL REBILL      '.                           
           05  WS-REFUND-MSG-3              PIC X(20)                   
                VALUE ' TYPE A/I ROW EXISTS'.                           
           05  WS-REFUND-MSG-4              PIC X(20)                   
                VALUE ' NO TYPE A/I REFUND '.                           
           05  WS-REFUND-MSG-5              PIC X(20)                   
                VALUE 'TYPE R AMT/DATE CHNG'.                           
           05  WS-REFUND-MSG-6              PIC X(20)                   
                VALUE 'TYPE R - DATE CHANGE'.                           
           05  WS-REFUND-MSG-7              PIC X(20)                   
                VALUE 'TYPE R ROW DELETED  '.                           
           05  WS-REFUND-MSG-8              PIC X(20)                   
                VALUE 'CREATED NEW R ROW   '.                           
           05  WS-REFUND-MSG-9              PIC X(20)                   
                VALUE 'NO R - NONE CREATED '.                           
           05  WS-REFUND-MSG-10             PIC X(20)                   
                VALUE 'TYPE R - AMT CHANGE '.                           
           05  WS-REFUND-MSG-11             PIC X(20)                   
                VALUE 'R EXIST - NO CHANGES'.                           
      *                                                                         
      ******************************************************************        
      *                                                                *03650000
      *  WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS              *03660000
      *                                                                *03670000
      ******************************************************************03680000
      /*****   SQL WORK VARIABLES                                       03690000
       COPY CWS00303.                                                   03700000
                                                                        
      /*****   WQ WORKING STORAGE                                       03720000
       COPY CWS0070B.                                                   03730000
                                                                        
       COPY CWS00027.                                                   03750000
                                                                        
      /*****   AT-CODES-DATA-PRESENT WORKING STORAGE                    03761000
       COPY CWS00056.                                                   03762000
                                                                        
       COPY CWS00010.                                                   03770000
                                                                        
      /***** WORKING STORAGE FOR PAYMENT JOURNAL                        03790000
       COPY CJF00101.                                                   03800000
                                                                        
           EXEC SQL                                                     03820000
               INCLUDE CWS00013                                         03830000
           END-EXEC.                                                    03840000
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR SCSCA109 START HERE '.               
                                                                        
       LINKAGE SECTION.                                                 
      /*****   LS-PCSA100-COMM-AREA                                     03900000
           EXEC SQL                                                     03910000
               INCLUDE CWS0024B                                         03920000
           END-EXEC.                                                    03930000
      /*****   BILL EXTRACT (BE00)                                      03940000
CWSCHG     COPY CWS1000A.                                               03950000
T23501* COMMENTED OUT TO MAKE FIELDS OF COPYBOOK BE USED  AS HOST               
T23501* VARIABLES BY CHANGING COPY TO INCLUDE                                   
CWSCHG*    COPY CWS1000B.                                               03951000
T23501     EXEC SQL                                                             
T23501         INCLUDE CWS1000B                                                 
T23501     END-EXEC.                                                            
T23501*                                                                         
      /*****   BILL EXTRACT (BE01)                                      03960000
CWSCHG     COPY CWS1001A.                                               03970000
CWSCHG     COPY CWS1001B.                                               03980000
      /*****   WORK FILE (WK3)                                          04000000
      *    COPY FIOWK03.                                                04010000
      /*****   WORKING STORAGE FOR G/L MNEMONICS                        04020000
           COPY CWS00061.                                               04030000
                                                                        
       01  WS-WORK-DAY-TABLE.                                           
           03  WS-WORK-DAY-LIST                                         
T30752            OCCURS 500 TIMES                                      
                  ASCENDING KEY WS-WORK-DAY                             
                  INDEXED BY WD-INDX.                                   
               05  WS-WORK-DAY              PIC X(10).                  
                                                                        
       01  WS-HOLD-WK03.                                                
COB305     03 WS-WK03-TOTAL-AR-BAL        PIC S9(9)V99 COMP-3 VALUE 0.        
           03  WS-WK03-COUNT                PIC S9(4) COMP.             
           03  WS-HOLD-WK03-DATA            PIC X(220)                  
T13536            OCCURS 5000 TIMES                                     
                  INDEXED BY WK03-INDX.                                 
      *                                                                         
       01  WS-ON-OFF-CYCLE-IND-109          PIC X.                      
      *                                                                         
      /*****************************************************************04120000
      **  CURSOR DECLARATIONS (IF ANY) GO LAST                         *04130000
      ******************************************************************04140000
           EXEC SQL                                                     
                DECLARE ACCOUNT CURSOR FOR                              
                SELECT    ACCOUNT_NO,                                   
                          CODE_ACCT_STAT,                               
FCS                       LOCAL_OFFICE,                                 
                          DATE_BILL_DAY_00,                             
                          DATE_BILL_DAY_30,                             
                          DATE_BILL_DAY_60,                             
                          DATE_BILL_DAY_90                              
                  FROM    CSS_ACCOUNT WITH(READUNCOMMITTED)                     
                 WHERE    CUSTOMER_NO   = :AT-CUSTOMER-NO               
                   AND    ACCOUNT_NO   <> :AT-ACCOUNT-NO                
                   AND    (CODE_ACCT_STAT = :WS-CHARGE-OFF              
TXXXXX              OR     CODE_ACCT_STAT = :WS-ACTIVE                  
T12929              OR     CODE_ACCT_STAT = :WS-FINAL)                  
T34695           FOR READ ONLY                                  
A02798                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04150000
MFA-TR*         DECLARE ACCOUNT CURSOR FOR                              04160000
MFA-TR*         SELECT    ACCOUNT_NO,                                   04170000
MFA-TR*                   CODE_ACCT_STAT,                               04180000
MFA-TR*                   LOCAL_OFFICE,                                 04181000
MFA-TR*                   DATE_BILL_DAY_00,                             04190000
MFA-TR*                   DATE_BILL_DAY_30,                             04200000
MFA-TR*                   DATE_BILL_DAY_60,                             04210000
MFA-TR*                   DATE_BILL_DAY_90                              04220000
MFA-TR*           FROM    CSS_ACCOUNT                                   04230000
MFA-TR*          WHERE    CUSTOMER_NO   = :AT-CUSTOMER-NO               04240000
MFA-TR*            AND    ACCOUNT_NO   <> :AT-ACCOUNT-NO                04250000
MFA-TR*            AND    (CODE_ACCT_STAT = :WS-CHARGE-OFF              04260000
MFA-TR*             OR     CODE_ACCT_STAT = :WS-ACTIVE                  04280000
MFA-TR*             OR     CODE_ACCT_STAT = :WS-FINAL)                  04281000
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7200                                                   
MFA-TR*    END-EXEC.                                                    04290000
      *                                                                 05810000
C28160     EXEC SQL                                                     
              DECLARE CODE_REF_IN_EXISTS CURSOR FOR                     
              SELECT   'Y'                                              
              FROM     CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                    
              WHERE    ACCOUNT_NO = :DO-ACCOUNT-NO  AND                 
                       DEPOSIT_STATUS_CD = 'R' AND                      
                       CODE_REFUND_ELIG = 'A'                           
T34695        FOR READ ONLY                                     
A02798                                                      
C28160     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05900000
MFA-TR*       DECLARE CODE_REF_IN_EXISTS CURSOR FOR                     05910000
MFA-TR*       SELECT   'Y'                                              05920000
MFA-TR*       FROM     CSS_DEP_ON_HAND                                  05930000
MFA-TR*       WHERE    ACCOUNT_NO = :DO-ACCOUNT-NO  AND                 05940000
MFA-TR*                DEPOSIT_STATUS_CD = 'R' AND                      05950000
MFA-TR*                CODE_REFUND_ELIG = 'A'                                   
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7605                                                      
MFA-TR*    END-EXEC.                                                    05960000
      *                                                                         
C28160     EXEC SQL                                                     
              DECLARE PPA_EXISTS CURSOR FOR                             
              SELECT   'Y'                                              
              FROM     CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                    
              WHERE    ACCOUNT_NO = :DO-ACCOUNT-NO                      
                AND    CODE_DEP_TYPE = 'A'                              
                AND    CODE_REFUND_ELIG = 'A'                           
T34695        FOR READ ONLY                                     
A02798                                                      
C28160     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05900000
MFA-TR*       DECLARE PPA_EXISTS CURSOR FOR                             05910000
MFA-TR*       SELECT   'Y'                                              05920000
MFA-TR*       FROM     CSS_DEP_ON_HAND                                  05930000
MFA-TR*       WHERE    ACCOUNT_NO = :DO-ACCOUNT-NO                      05940000
MFA-TR*         AND    CODE_DEP_TYPE = 'A'                              05950000
MFA-TR*         AND    CODE_REFUND_ELIG = 'A'                           05950000
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7620                                                      
MFA-TR*    END-EXEC.                                                    05960000
      *                                                                 05970000
       PROCEDURE DIVISION USING LS-PCSCA100-COMM-AREA                   
      *                         FIOWK03                                 04440000
                                WS-CUSTOMER-CU                          
                                WS-ACCOUNT-AT                           
                                WS-CHRG-OFF-CO                          
                                WS-BILLING-BI                           
                                WS-BILLING-BG                           
                                WS-AR-CNTRL-AC                          
                                WS-ADDR-FREEFORM-DZ                     
                                WS-PREMISE-PR                           
                                WS-BILLING-WQ-ITEMS-WF                  
                                WS-CUST-PLAN-TABLE-CP                   
                                WS-GL-ACCT-NO-TABLE                     
                                WS-GL-NAME-INFO                         
                                WS-WORK-DAY-TABLE                       
                                WS-HOLD-WK03                            
T21381                          WS-ON-OFF-CYCLE-IND-109                 
P00097                          WS-CWS1000B-MAX-TBL-LIMITS.             
      *                                                                         
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04580000
      **                                                              **04590000
      **    0000-MAINLINE                                             **04600000
      **                                                              **04610000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04620000
       0000-MAINLINE.                                                   
           MOVE ZERO TO RETURN-CODE.                                    
ACT284     SET WS-GL-SUB  TO 1                                          
T21381     MOVE SPACES TO WS-REFUND-RECALC-MSG.                         
I00177     INITIALIZE WS-SQL-ERROR-TXT-WQ.                              
      *    INITIALIZE WS-WORK-VARIABLES                                 04640000
      **   SET ALL CONDITION NAMES TO THEIR DEFAULT VALUES              04650000
      *                                                                 04660000
           MOVE WS-ACCOUNT-NO-AT     TO AT-ACCOUNT-NO                   
C28160                                  DO-ACCOUNT-NO.                  
                                                                        
           MOVE LS-INPUT-DATE        TO WS-CURRENT-DATE.                
           MOVE LOW-VALUES           TO AR-DATE-TRANS.                  
T18061     SET WS-CIA-LIHEAP-NOT-PRESENT TO TRUE.                       
T34695     SET WS-LIHEAP-NOT-PRESENT     TO TRUE.                       
C28160     SET WS-CIA-VOUCHER-NOT-PRESENT TO TRUE.                      
T18259     MOVE WS-NO  TO  WS-DOLLARS-IN-AR.                            
      *                                                                 04700000
T20113     MOVE SPACES TO WS-PYMT-TYPE.                                 
T20113     MOVE SPACES TO WS-PYMT-DATE.                                 
T19900     MOVE ZEROS  TO WS-DEL-WORK-AREA.                             
C24613     INITIALIZE WS-CIA-LIHEAP-CREDIT.                             
      *                                                                         
T21381     MOVE 'N' TO WS-AMT-DATE-BOTH-SW.                             
      *                                                                         
           MOVE WS-NO                TO WS-DATE-FL.                     
           MOVE WS-WORK-DAY (103) TO WS-2-CYCLES-FROM-NOW               
T15199     MOVE WS-WORK-DAY (102) TO WS-NEXT-DATE                       
T19900*    PERFORM 7600-DELINQUENCY-TABLE-VALUE     THRU  7600-EXIT.            
                                                                        
           MOVE LS-DATE-25-DAYS-AGO  TO WS-25-DAYS-AGO.                 
      *                                                                         
T21381     IF WS-ON-OFF-CYCLE-IND-109 = 'O'                             
T21381         CONTINUE                                                 
T21381     ELSE                                                         
T21381         GO TO 0000-NOT-A-CANCEL-REBILL
           END-IF.                          
      *                                                                         
T21381     MOVE 'N' TO WS-FUNKY-REFUND-MAYBE.                           
T21381     MOVE 'N' TO WS-DO-I-STILL-DO-A-WQ.                           
      *                                                                         
T21381     MOVE WS-ACCOUNT-NO-AT     TO RN-ACCOUNT-NO.                  
T21381     MOVE 'A'                  TO RN-CHECK-STATUS-CD.             
T21381     MOVE WS-S                 TO RN-MANUAL-INDICATOR.            
T21381     MOVE 'BILL'               TO RN-PANEL-NO.                    
      *                                                                         
T21381*    MOVE WS-CURRENT-DATE      TO RN-REQUEST-DT.                          
      *                                                                         
T21381     PERFORM 7701-STATUS-A-REFUND THRU 7701-EXIT.                 
      *                                                                 12280000
T21381     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR WS-811         
T21381           MOVE 'Y' TO WS-FUNKY-REFUND-MAYBE                      
T21381     ELSE                                                         
T21381        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T21381           CONTINUE                                               
T21381        ELSE                                                      
T21381           MOVE 'RN'                TO  WS-DB2-TABLE-ID           
T21381           MOVE 'SELECT'            TO  WS-DB2-FUNCTION           
T21381           MOVE SQLCODE             TO  WS-DB2-RETURN-CODE        
T21381           MOVE '109'               TO  WS-DB2-MODULE-ID          
T21381           MOVE '7701'              TO  WS-DB2-PARAGRAPH          
T21381           MOVE RN-ACCOUNT-NO       TO  WS-DB2-KEY-1N             
T21381           MOVE 12                  TO  RETURN-CODE               
T21381           PERFORM 9900-SQL-ERROR THRU 9900-EXIT                  
T21381        END-IF                                                    
T21381     END-IF.                                                      
      *                                                                 12280000
T21381     MOVE WS-ACCOUNT-NO-AT      TO RN-ACCOUNT-NO.                 
T21381     MOVE 'I'                   TO RN-CHECK-STATUS-CD.            
T21381     MOVE WS-S                  TO RN-MANUAL-INDICATOR.           
T21381     MOVE 'BILL'                TO RN-PANEL-NO.                   
      *                                                                         
T21381     MOVE WS-ACCT-FINALED-DT-AT TO WS-FINAL-DATE-7702.            
      *                                                                         
T21381     PERFORM 7702-STATUS-I-REFUND THRU 7702-EXIT.                 
      *                                                                 12280000
T21381     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR WS-811         
T21381           MOVE 'Y' TO WS-FUNKY-REFUND-MAYBE                      
T21381     ELSE                                                         
T21381        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T21381           CONTINUE                                               
T21381        ELSE                                                      
T21381           MOVE 'RN'                TO  WS-DB2-TABLE-ID           
T21381           MOVE 'SELECT'            TO  WS-DB2-FUNCTION           
T21381           MOVE SQLCODE             TO  WS-DB2-RETURN-CODE        
T21381           MOVE '109'               TO  WS-DB2-MODULE-ID          
T21381           MOVE '7702'              TO  WS-DB2-PARAGRAPH          
T21381           MOVE RN-ACCOUNT-NO       TO  WS-DB2-KEY-1N             
T21381           MOVE 12                  TO  RETURN-CODE               
T21381           PERFORM 9900-SQL-ERROR THRU 9900-EXIT                  
T21381        END-IF                                                    
T21381     END-IF.                                                      
      *                                                                         
T21381     MOVE WS-ACCOUNT-NO-AT     TO RN-ACCOUNT-NO.                  
T21381     MOVE WS-REQUESTED         TO RN-CHECK-STATUS-CD.             
T21381     MOVE WS-S                 TO RN-MANUAL-INDICATOR.            
T21381     MOVE 'BILL'               TO RN-PANEL-NO.                    
      *                                                                         
T21381*    MOVE WS-CURRENT-DATE      TO RN-REQUEST-DT.                          
      *                                                                         
T21381     PERFORM 7700-STATUS-R-REFUND THRU 7700-EXIT.                 
      *                                                                         
T21381     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21381        IF WS-FUNKY-REFUND-MAYBE = 'Y'                            
T15199           IF WS-TOTAL-AR-BALANCE-AT < ZERO                       
T21381              MULTIPLY WS-TOTAL-AR-BALANCE-AT BY -1               
T21381                          GIVING WS-REFUND-COMPARE                
      *                                                                         
T21381              IF WS-REFUND-COMPARE = RN-AMT-REFUNDED              
T21381                 IF WS-WORK-DAY (103) < RN-REQUEST-DT             
T21381                  MOVE WS-REFUND-MSG-11 TO WS-MSG-PART-4          
T21381                 ELSE                                             
DORKIT                  MOVE RN-REQUEST-DT TO WS-SAVE-PREV-DATE         
T21381                  MOVE WS-WORK-DAY (103) TO RN-REQUEST-DT         
T21381                  PERFORM 8015-UPDATE-AMOUNT-DATE THRU 8015-EXIT  
      *                                                                         
T21381                  MOVE WS-MH-MSG-1 TO MH-TRAN-COMMENT-TEXT        
T21381                  MOVE +36         TO MH-TRAN-COMMENT-LEN         
      *                                                                         
T21381                  PERFORM 6540-INSERT-MH-ROW THRU 6540-EXIT       
      *                                                                         
DORKIT                  MOVE +1 TO MI-TRAN-APPL-NO                      
DORKIT                  PERFORM 6550-MT-DATE-ROW THRU 6550-EXIT         
      *                                                                         
T21381                  MOVE WS-REFUND-MSG-6 TO WS-MSG-PART-4           
T21381                 END-IF                                           
      *                                                                         
T21381                 MOVE WS-REFUND-MSG-1 TO WS-MSG-PART-1            
T21381                 MOVE WS-REFUND-MSG-2 TO WS-MSG-PART-2            
T21381                 MOVE WS-REFUND-MSG-3 TO WS-MSG-PART-3            
      *                                                                         
T21381*                PERFORM 2007-DO-RECAL-REFUND-WQ THRU 2007-EXIT           
T21381                 MOVE 'Y' TO WS-DO-I-STILL-DO-A-WQ                
T21381              ELSE                                                
DORKIT*                MOVE RN-AMT-REFUNDED TO WS-SAVE-PREV-AMOUNT              
T21381                 IF WS-WORK-DAY (103) < RN-REQUEST-DT             
T21381                  MOVE WS-REFUND-MSG-10 TO WS-MSG-PART-4          
T21381                  MOVE WS-MH-MSG-2 TO MH-TRAN-COMMENT-TEXT        
T21381                  MOVE +38         TO MH-TRAN-COMMENT-LEN         
T21381                 ELSE                                             
DORKIT                  MOVE 'Y' TO WS-AMT-DATE-BOTH-SW                 
DORKIT                  MOVE RN-REQUEST-DT TO WS-SAVE-PREV-DATE         
T21381                  MOVE WS-WORK-DAY (103) TO RN-REQUEST-DT         
T21381                  MOVE WS-REFUND-MSG-5 TO WS-MSG-PART-4           
T21381                  MOVE WS-MH-MSG-3 TO MH-TRAN-COMMENT-TEXT        
T21381                  MOVE +42         TO MH-TRAN-COMMENT-LEN         
T21381                 END-IF                                           
T21381                 PERFORM 8015-UPDATE-AMOUNT-DATE THRU 8015-EXIT   
T21381                 PERFORM 6540-INSERT-MH-ROW THRU 6540-EXIT        
DORKIT                 MOVE +1 TO MI-TRAN-APPL-NO                       
DORKIT                 PERFORM 6551-MT-AMT-ROW THRU 6551-EXIT           
      *                                                                         
DORKIT                 IF WS-AMT-DATE-BOTH-SW = 'Y'                     
DORKIT                  MOVE +2 TO MI-TRAN-APPL-NO                      
DORKIT                  PERFORM 6550-MT-DATE-ROW THRU 6550-EXIT         
DORKIT                  MOVE 'N' TO WS-AMT-DATE-BOTH-SW                 
DORKIT                 END-IF                                           
      *                                                                         
T21381                 MOVE WS-REFUND-MSG-1 TO WS-MSG-PART-1            
T21381                 MOVE WS-REFUND-MSG-2 TO WS-MSG-PART-2            
T21381                 MOVE WS-REFUND-MSG-3 TO WS-MSG-PART-3            
      *                                                                         
T21381*                PERFORM 2007-DO-RECAL-REFUND-WQ THRU 2007-EXIT           
T21381                 MOVE 'Y' TO WS-DO-I-STILL-DO-A-WQ                
T21381              END-IF                                              
T21381           ELSE                                                   
T21381              PERFORM 8020-DELETE-REFUND  THRU 8020-EXIT          
      *                                                                         
T21381              MOVE WS-REFUND-MSG-1 TO WS-MSG-PART-1               
T21381              MOVE WS-REFUND-MSG-2 TO WS-MSG-PART-2               
T21381              MOVE WS-REFUND-MSG-3 TO WS-MSG-PART-3               
T21381              MOVE WS-REFUND-MSG-7 TO WS-MSG-PART-4               
      *                                                                         
T21381*             PERFORM 2007-DO-RECAL-REFUND-WQ THRU 2007-EXIT              
T21381              MOVE 'Y' TO WS-DO-I-STILL-DO-A-WQ                   
T21381           END-IF                                                 
T21381        ELSE                                                      
T15199           IF WS-TOTAL-AR-BALANCE-AT >= ZERO                      
      *                                                                         
T21381              MOVE WS-REFUND-MSG-1 TO WS-MSG-PART-1               
T21381              MOVE WS-REFUND-MSG-2 TO WS-MSG-PART-2               
T21381              MOVE WS-REFUND-MSG-4 TO WS-MSG-PART-3               
T21381              MOVE WS-REFUND-MSG-7 TO WS-MSG-PART-4               
      *                                                                         
                    PERFORM 8020-DELETE-REFUND  THRU 8020-EXIT          
T21381           ELSE                                                   
T21381              MULTIPLY WS-TOTAL-AR-BALANCE-AT BY -1               
T21381                          GIVING WS-REFUND-COMPARE                
      *                                                                         
T21381              IF WS-REFUND-COMPARE = RN-AMT-REFUNDED              
T21381                 IF WS-WORK-DAY (103) < RN-REQUEST-DT             
T21381                  CONTINUE                                        
T21381                 ELSE                                             
DORKIT                  MOVE RN-REQUEST-DT TO WS-SAVE-PREV-DATE         
T21381                  MOVE WS-WORK-DAY (103) TO RN-REQUEST-DT         
T21381                  PERFORM 8015-UPDATE-AMOUNT-DATE THRU 8015-EXIT  
T21381                  MOVE WS-MH-MSG-1 TO MH-TRAN-COMMENT-TEXT        
T21381                  MOVE +36         TO MH-TRAN-COMMENT-LEN         
T21381                  PERFORM 6540-INSERT-MH-ROW THRU 6540-EXIT       
      *                                                                         
DORKIT                  MOVE +1 TO MI-TRAN-APPL-NO                      
DORKIT                  PERFORM 6550-MT-DATE-ROW THRU 6550-EXIT         
      *                                                                         
T21381                  MOVE WS-REFUND-MSG-1 TO WS-MSG-PART-1           
T21381                  MOVE WS-REFUND-MSG-2 TO WS-MSG-PART-2           
T21381                  MOVE WS-REFUND-MSG-4 TO WS-MSG-PART-3           
T21381                  MOVE WS-REFUND-MSG-6 TO WS-MSG-PART-4           
      *                                                                         
T21381*                 PERFORM 2007-DO-RECAL-REFUND-WQ THRU 2007-EXIT          
T21381                  MOVE 'Y' TO WS-DO-I-STILL-DO-A-WQ               
T21381                 END-IF                                           
T21381              ELSE                                                
T21381                 IF WS-WORK-DAY (103) < RN-REQUEST-DT             
DORKIT*                 MOVE RN-AMT-REFUNDED TO WS-SAVE-PREV-AMOUNT             
T21381                  MOVE WS-REFUND-MSG-10 TO WS-MSG-PART-4          
T21381                  MOVE WS-MH-MSG-2 TO MH-TRAN-COMMENT-TEXT        
T21381                  MOVE +38         TO MH-TRAN-COMMENT-LEN         
T21381                 ELSE                                             
DORKIT                  MOVE 'Y' TO WS-AMT-DATE-BOTH-SW                 
DORKIT                  MOVE RN-REQUEST-DT TO WS-SAVE-PREV-DATE         
T21381                  MOVE WS-WORK-DAY (103) TO RN-REQUEST-DT         
T21381                  MOVE WS-REFUND-MSG-5 TO WS-MSG-PART-4           
T21381                  MOVE WS-MH-MSG-3 TO MH-TRAN-COMMENT-TEXT        
T21381                  MOVE +42         TO MH-TRAN-COMMENT-LEN         
T21381                 END-IF                                           
T21381                 PERFORM 8015-UPDATE-AMOUNT-DATE THRU 8015-EXIT   
T21381                 PERFORM 6540-INSERT-MH-ROW THRU 6540-EXIT        
      *                                                                         
DORKIT                 MOVE +1 TO MI-TRAN-APPL-NO                       
DORKIT                 PERFORM 6551-MT-AMT-ROW THRU 6551-EXIT           
      *                                                                         
DORKIT                 IF WS-AMT-DATE-BOTH-SW = 'Y'                     
DORKIT                  MOVE +2 TO MI-TRAN-APPL-NO                      
DORKIT                  PERFORM 6550-MT-DATE-ROW THRU 6550-EXIT         
DORKIT                  MOVE 'N' TO WS-AMT-DATE-BOTH-SW                 
DORKIT                 END-IF                                           
      *                                                                         
T21381                 MOVE WS-REFUND-MSG-1 TO WS-MSG-PART-1            
T21381                 MOVE WS-REFUND-MSG-2 TO WS-MSG-PART-2            
T21381                 MOVE WS-REFUND-MSG-4 TO WS-MSG-PART-3            
      *                                                                         
T21381*                PERFORM 2007-DO-RECAL-REFUND-WQ THRU 2007-EXIT           
T21381                 MOVE 'Y' TO WS-DO-I-STILL-DO-A-WQ                
T21381              END-IF                                              
T21381           END-IF                                                 
              END-IF                                                    
           ELSE                                                         
T21381        IF WS-FUNKY-REFUND-MAYBE = 'Y'                            
PCR072           IF WS-TOTAL-AR-BALANCE-AT < ZEROES                     
                    PERFORM 2000-CREATE-REFUND  THRU 2000-EXIT          
      *                                                                         
T21381              MOVE WS-REFUND-MSG-1 TO WS-MSG-PART-1               
T21381              MOVE WS-REFUND-MSG-2 TO WS-MSG-PART-2               
T21381              MOVE WS-REFUND-MSG-3 TO WS-MSG-PART-3               
T21381              MOVE WS-REFUND-MSG-8 TO WS-MSG-PART-4               
      *                                                                         
T21381*             PERFORM 2007-DO-RECAL-REFUND-WQ THRU 2007-EXIT              
T21381              MOVE 'Y' TO WS-DO-I-STILL-DO-A-WQ                   
T21381           ELSE                                                   
      *                                                                         
T21381              MOVE WS-REFUND-MSG-1 TO WS-MSG-PART-1               
T21381              MOVE WS-REFUND-MSG-2 TO WS-MSG-PART-2               
T21381              MOVE WS-REFUND-MSG-3 TO WS-MSG-PART-3               
T21381              MOVE WS-REFUND-MSG-9 TO WS-MSG-PART-4               
      *                                                                         
T21381*             PERFORM 2007-DO-RECAL-REFUND-WQ THRU 2007-EXIT              
T21381              MOVE 'Y' TO WS-DO-I-STILL-DO-A-WQ                   
T21381           END-IF                                                 
T21381        ELSE                                                      
PCR072           IF WS-TOTAL-AR-BALANCE-AT < ZEROES                     
                    PERFORM 2000-CREATE-REFUND  THRU 2000-EXIT          
                 END-IF                                                 
T15199        END-IF                                                    
PCR072     END-IF.                                                      
      *                                                                         
T21381     IF WS-RELEASE-DATE = WS-CURRENT-DATE                         
T21381        PERFORM 3000-RELEASE-REFUND THRU 3000-EXIT                
T21381     ELSE                                                         
T21381*       IF WS-DO-I-STILL-DO-A-WQ = 'Y'                                    
A03082        IF WS-DO-I-STILL-DO-A-WQ = 'Y' AND CSR-DATABASE           
T21381           PERFORM 2007-DO-RECAL-REFUND-WQ THRU 2007-EXIT         
T21381        END-IF                                                    
T21381     END-IF.                                                      
      *                                                                         
T21381     GO TO 0000-REFUNDS-FINISHED.                                 
      *                                                                         
T21381 0000-NOT-A-CANCEL-REBILL.                                        
                                                                        
           MOVE WS-ACCOUNT-NO-AT     TO RN-ACCOUNT-NO.                  
ACT292     MOVE WS-REQUESTED         TO RN-CHECK-STATUS-CD.             
ACT292     MOVE WS-S                 TO RN-MANUAL-INDICATOR.            
ACT292     MOVE 'BILL'               TO RN-PANEL-NO.                    
           MOVE WS-CURRENT-DATE      TO RN-REQUEST-DT.                  
                                                                        
           PERFORM 7703-SELECT-REFUND  THRU 7703-EXIT.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T15199        IF WS-TOTAL-AR-BALANCE-AT >= ZERO                         
ACT216*          IF THERE IS NO BALANCE TO REFUND, CANCEL THE REFUND    04763100
ACT216           MOVE 'C' TO RN-CHECK-STATUS-CD                         
ACT216           MOVE 'NO CREDIT AVAILABLE. REFUND CANCELLED.'          
ACT216             TO RN-COMMENTS-TEXT                                  
ACT216           MOVE 38 TO RN-COMMENTS-LEN                             
ACT216           PERFORM 8021-CANCEL-REFUND  THRU 8021-EXIT             
              ELSE                                                      
T11892*          MARK THE REFUND AS APPROVED (2 DAYS AFTER FINAL BILL)  04765100
                 PERFORM 3000-RELEASE-REFUND THRU 3000-EXIT             
              END-IF                                                    
           ELSE                                                         
PCR072      IF WS-TOTAL-AR-BALANCE-AT < ZEROES                          
T15199*       CHECK IF THERE IS A ROW FOR TOMORROW (THIS IS A C/R       04767101
T15199*       DONE THE DAY AFTER THE FINAL)                             04767201
T15199        PERFORM 7710-CHECK-REFUND-TOMORROW THRU 7710-EXIT         
T15199        IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL         
T15199*          RECALC AMT REFUNDED                                    04767601
T15199           PERFORM 2006-CALC-AMOUNT-REFD THRU 2006-EXIT           
T15199           PERFORM 8016-UPDATE-AMOUNT-ONLY THRU 8016-EXIT         
T15199        ELSE                                                      
T11892*          CREATE THE REFUND ROW                                  04769001
                 PERFORM 2000-CREATE-REFUND  THRU 2000-EXIT             
                 IF WS-RELEASE-DATE = WS-CURRENT-DATE                   
T11892*             IF THE REFUND IS AUTOMATICALLY APPROVED AT FINAL    04781001
T11892*             BILL, MARK IT AS APPROVED                           04782001
                    PERFORM 3000-RELEASE-REFUND THRU 3000-EXIT          
                 END-IF                                                 
T15199        END-IF                                                    
PCR072      END-IF                                                      
PCR072     END-IF.                                                      
      *                                                                         
T21381 0000-REFUNDS-FINISHED.                                           
      *                                                                         
           EXIT PROGRAM.                                                
      *                                                                         
       0999-EXIT.                                                       
           EXIT.                                                        
C28160 1000-WRITE-NO-REFUND-WQ.                                         
                                                                        
           MOVE 'INELIGIBLE FOR REFUND DUE TO REFUND CODE'              
             TO WS-MISC-MSG-TEXT.                                       
           MOVE +40 TO WS-MISC-MSG-LEN.                                 
                                                                        
T36498     MOVE WS-NO-BILL            TO  WS-CODE-BILL-STATUS-BI.       
                                                                        
C28160     IF WS-PPA-EXISTS = 'Y'                                       
C28160        PERFORM 2009-DO-NOT-REFUND-WQ           THRU 2009-EXIT    
C28160     ELSE                                                         
C28160        PERFORM 2008-DO-NOT-REFUND-WQ           THRU 2008-EXIT    
C28160     END-IF.                                                      
                                                                        
C28160 1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04850000
      **                                                              **04860000
      ** 2000-CREATE-REFUND.                                          **04870000
      **                                                              **04880000
      ** EVALUATE FINAL ACCOUNTS WITH CREDIT BALANCES.  CONSIDER      **04890000
      ** THE FOLLOWING EXCEPTIONS: HISTORY OF NSFS; RECENT CHECK;     **04900000
      ** MULTIPLE ACCOUNTS AND ONE OR MORE HAVING FINAL STATUS WITH   **04910000
      ** PAST DUE BALANCES AND CHARGE OFF STATUS (NOT BANKRUPT); BILL **04920000
      ** CALC EXCEPTION INDICATORS; TO DETERMINE WHETHER INTERVENTION **04930000
      ** IS REQUIRED.                                                 **04940000
      **                                                              **04950000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04960000
       2000-CREATE-REFUND.                                              
T19900      MOVE SPACES TO WS-DELINQUENCY-DATE.                         
            PERFORM 7000-SELECT-COUNT-NSF-HIST      THRU  7000-EXIT.    
T19741******** ALWAY CHECK FOR "PAYMENT BY CHECK" REGUARDLESS OF        04990000
T19741******** NSF                                                      04990000
T19741*     IF WS-NSF-COUNT > 1                                         05000000
            PERFORM 7100-SELECT-AR-PYMT-DATE-TYPE   THRU  7100-EXIT.    
T19900      PERFORM 7600-DELINQUENCY-TABLE-VALUE    THRU  7600-EXIT.    
                                                                        
            PERFORM 5300-GET-COUNT-BILLING-DET      THRU  5300-EXIT.    
            PERFORM 5000-PROCESS-MULTIPLE-ACCOUNTS  THRU  5000-EXIT.    
PCR072******************************************************************05041000
PCR072* IF THERE IS A REFUND AND THE ACCOUNT HAS A CIA-LIHEAP ON IT, DO*05042000
PCR072*NOT INCLUDE THE MONEY IN THE REFUND TO THE CUSTOMER. THE MONEY  *05043000
PCR072*OTHER THAN THE CIA-LIHEAP GOES TO THE CUSTOMER, BUT THE CIA-    *05044000
PCR072*LIHEAP GOES TO THE GOVERNOR'S OFFICE. SO, IF THERE IS CIA-LIHEAP*05045000
PCR072* A WORK QUEUE WILL BE GENERATED FOR CUSTOMER ASSISTANCE TO MAN- *05046000
PCR072*UALLY TAKE THE CIA-LIHEAP MONEY OFF OF THE ACCOUNT AND TO CUT A *05047000
PCR072*CHECK TO THE GOVERNOR'S OFFICE. THIS IS THE WAY IT WAS DECIDED  *05048000
PCR072*TO WORK AFTER CONSIDERING THE SMALL VOLUME OF THESE TRANSACTIONS*05049000
PCR072******************************************************************05049100
T15199      PERFORM 2005-RECALC-REFUND-AMT THRU 2005-EXIT.              
                                                                        
C28160      MOVE SPACES             TO WS-CODE-REF-IN-EXISTS.           
C28160      PERFORM 7605-OPEN-CODE-REF-EXISTS THRU 7605-OPEN-EXIT.      
C28160      PERFORM 7610-FETCH-CODE-REF-EXISTS THRU 7610-FETCH-EXIT.    
C28160      PERFORM 7615-CLOSE-CODE-REF-EXISTS THRU 7615-EXIT.          
      *                                                                         
C28160      MOVE SPACES             TO WS-PPA-EXISTS.                   
C28160      PERFORM 7620-OPEN-PPA-EXISTS THRU 7620-OPEN-EXIT.           
C28160      PERFORM 7625-FETCH-PPA-EXISTS THRU 7625-FETCH-EXIT.         
C28160      PERFORM 7630-CLOSE-PPA-EXISTS THRU 7630-EXIT.               
      *                                                                         
C28160      IF (WS-PPA-EXISTS = 'Y'  OR WS-CIA-VOUCHER-PRESENT )        
C28160                               AND WS-CODE-REF-IN-EXISTS = 'Y'    
C28160              PERFORM 1000-WRITE-NO-REFUND-WQ THRU 1000-EXIT      
C28160              GO TO 0000-REFUNDS-FINISHED                         
C28160      ELSE                                                        
T18023         PERFORM 2010-CALC-AR-EXCEPTIONS THRU 2010-EXIT           
T18023              VARYING WS-AR-DATA-INDX                             
T18023                 FROM 1 BY 1                                      
P00097                UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY           
T18023                 OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) EQUAL ZERO 
C28160      END-IF.                                                     
                                                                        
      *                                                                         
T20883     IF AR-DATE-TRANS > WS-DEL-WORK-DATE                          
T20883        MOVE WS-NO TO WS-REVIEW-REQUIRED                          
T20883        IF WS-DEL-WORK-DATE > SPACES                              
T20883           MOVE WS-DELINQUENCY-DATE TO WS-RELEASE-DATE            
T20883        ELSE                                                      
T20883           MOVE WS-2-CYCLES-FROM-NOW TO WS-RELEASE-DATE           
T20883        END-IF                                                    
T20883     ELSE                                                         
T20883        MOVE WS-NO TO WS-REVIEW-REQUIRED                          
T20883        MOVE WS-CURRENT-DATE TO WS-RELEASE-DATE                   
T20883     END-IF.                                                      
      *                                                                         
T20883     IF WS-BILL-EXCEPT-COUNT > 0                                  
T20883         OR   WS-CODE-MULT-ACCT = WS-YES                          
T20883         OR   WS-BANKRUPTCY-IND-AT = WS-B                         
PCR072         OR   WS-CIA-LIHEAP-PRESENT                               
T20883         OR   WS-DOLLARS-IN-AR = WS-YES                           
T20883           MOVE WS-YES TO WS-REVIEW-REQUIRED                      
T20883           IF (AR-DATE-TRANS > WS-DEL-WORK-DATE                   
T20883                    AND WS-DEL-WORK-DATE > SPACES)                
T20883              MOVE WS-DELINQUENCY-DATE TO WS-RELEASE-DATE         
T20883           ELSE                                                   
T20883              MOVE WS-2-CYCLES-FROM-NOW TO WS-RELEASE-DATE        
T20883           END-IF                                                 
T30175           IF CSR-DATABASE                                        
T20883            PERFORM 5100-CREATE-REVIEW-REQUIRED THRU 5100-EXIT    
T30175           END-IF                                                 
T20883     ELSE                                                         
T20883        MOVE WS-NO TO WS-REVIEW-REQUIRED                          
T20883        IF (AR-DATE-TRANS > WS-DEL-WORK-DATE                      
T20883                 AND WS-DEL-WORK-DATE > SPACES)                   
T19900           MOVE WS-DELINQUENCY-DATE TO WS-RELEASE-DATE            
T20883        ELSE                                                      
T20883           MOVE WS-CURRENT-DATE TO WS-RELEASE-DATE                
T20883        END-IF                                                    
T20883     END-IF.                                                      
      *                                                                         
PCR072     IF RN-AMT-REFUNDED GREATER THAN ZEROES                       
PCR072      MOVE  WS-ACCOUNT-NO-AT     TO RN-ACCOUNT-NO                 
            MOVE  SPACES               TO RN-RETURNED-REASON            
PCR072                                    RN-USER-ID-APPRVD-BY          
PCR072      MOVE WS-LOCAL-OFFICE-AT    TO RN-LOCAL-OFFICE               
PCR072      MOVE 'SYSTEM'              TO RN-USER-ID-RQSTED-BY          
                                                                        
            MOVE  ZEROES               TO RN-REFUND-CHECK-NO            
PCR072                                    RN-ORIGINAL-CHECK-NO          
                                                                        
T15199*     USE THE MAX ITEM ID + 1 TO ADD THE REFUND ROW (THIS WILL    05400003
T15199*     SOLVE MULT ROWS WHEN AN ACCOUNT PROCESSES TWICE - FINAL     05410003
T15199*     WITH A CREDIT REBILL AFTERWARDS)                            05420003
T15199*     MOVE  ZERO                 TO RN-REFUND-ITEM-ID             05510003
T15199      PERFORM 7720-SELECT-MAX-ITEM-ID THRU 7720-EXIT              
            MOVE  ZERO                 TO RN-DEPOSIT-CERT-NO            
                                          RN-ORIGINAL-CHECK-NO          
PCR072                                    RN-ADDRESS-ID                 
                                                                        
PCR072      MOVE  WS-CURRENT-DATE      TO RN-REFUND-STATUS-DT           
PCR072      MOVE  WS-RELEASE-DATE      TO RN-REQUEST-DT                 
ACT216      MOVE  WS-S                 TO RN-MANUAL-INDICATOR           
ACT216      MOVE  'BILL'               TO RN-PANEL-NO                   
                                                                        
PCR072      PERFORM 8000-INSERT-CSS-REFUND THRU  8000-EXIT              
                                                                        
T13203      MOVE WS-CODES-DATA-PRESENT-AT TO WS-CODES-DATA-PRESENT      
T13203      MOVE WS-A                  TO WS-CODE-CHECK-REFUND          
T13203      MOVE WS-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT-AT      
PCR072     END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T15199 2005-RECALC-REFUND-AMT.                                          
                                                                        
T22367      SET WS-AR-DATA-INDX TO 1                                    
      *                                                                         
      *                                                                         
PCR072      SEARCH WS-AR-DATA                                           
PCR072         AT END                                                   
PCR072           MULTIPLY -1 BY WS-TOTAL-AR-BALANCE-AT                  
PCR072                          GIVING RN-AMT-REFUNDED                  
      *                                                                         
T21381           MOVE WS-CURRENT-DATE TO RN-REQUEST-DT                  
      *                                                                         
PCR072         WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 70      
PCR072          AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 2                 
T34695            IF  (WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) * -1)      
T34695                                   > 0                            
T34695              MOVE WS-YES       TO WS-LIHEAP-ONLY-SW              
A00557              MOVE WS-YES       TO WS-CIA-LIHEAP-PRESENT-SW       
T34695            ELSE                                                  
T34695              MOVE WS-NO        TO WS-LIHEAP-ONLY-SW              
A00557              MOVE WS-NO        TO WS-CIA-LIHEAP-PRESENT-SW       
T34695            END-IF                                                
PCR072            COMPUTE RN-AMT-REFUNDED =                             
PCR072                 (WS-TOTAL-AR-BALANCE-AT * -1) -                  
PCR072                 (WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) * -1)     
PCR072            END-COMPUTE                                           
PCR072      END-SEARCH.                                                 
      *                                                                         
C28160      SET WS-AR-DATA-INDX TO 1                                    
C28160      SET WS-CIA-VOUCHER-NOT-PRESENT TO TRUE.                     
C28160      SEARCH WS-AR-DATA                                           
C28160         AT END                                                   
C28160           MULTIPLY -1 BY WS-TOTAL-AR-BALANCE-AT                  
C28160                          GIVING RN-AMT-REFUNDED                  
      *                                                                         
C28160           MOVE WS-CURRENT-DATE TO RN-REQUEST-DT                  
      *                                                                         
C28160         WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 70      
C28160          AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 1                 
C28160            MOVE WS-YES         TO WS-CIA-VOUCHER-PRESENT-SW      
C28160            CONTINUE                                              
C28160*           COMPUTE RN-AMT-REFUNDED =                                     
C28160*                (WS-TOTAL-AR-BALANCE-AT * -1) -                          
C28160*                (WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) * -1)             
C28160*           END-COMPUTE                                                   
C28160      END-SEARCH.                                                 
      *                                                                         
T15199 2005-EXIT.                                                       
T15199     EXIT.                                                        
      *                                                                         
T15199 2006-CALC-AMOUNT-REFD.                                           
T22367      SET WS-AR-DATA-INDX TO 1                                    
PCR072      SEARCH WS-AR-DATA                                           
PCR072         AT END                                                   
PCR072           MULTIPLY -1 BY WS-TOTAL-AR-BALANCE-AT                  
PCR072                          GIVING RN-AMT-REFUNDED                  
PCR072         WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 70      
PCR072          AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 2                 
PCR072            MOVE WS-YES         TO WS-CIA-LIHEAP-PRESENT-SW       
PCR072            COMPUTE RN-AMT-REFUNDED =                             
PCR072                 (WS-TOTAL-AR-BALANCE-AT * -1) -                  
PCR072                 (WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) * -1)     
PCR072            END-COMPUTE                                           
PCR072      END-SEARCH.                                                 
      *                                                                         
T15199 2006-EXIT.                                                       
T15199     EXIT.                                                        
      *                                                                         
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      ** BUILD REVIEW TEXT FOR WORK QUEUE FOR A RECALCULATED REFUND.  **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      *                                                                         
       2007-DO-RECAL-REFUND-WQ.                                         
      *                                                                         
T21381      MOVE  +98 TO WS-WQ-CATEGORY.                                
T21381      MOVE 1  TO  WS-REVIEW-TEXT-LENGTH.                          
      *                                                                         
T21381      STRING WS-MSG-PART-1                                        
T13213               DELIMITED BY SIZE                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
                     WS-MSG-PART-2                                      
T13213               DELIMITED BY '  '                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
                     WS-MSG-PART-3                                      
T13213               DELIMITED BY '  '                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
                     WS-MSG-PART-4                                      
T13213               DELIMITED BY '  '                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
                     WS-MSG-PART-5                                      
T13213               DELIMITED BY '  '                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
                     WS-MSG-PART-6                                      
T13213               DELIMITED BY '  '                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
PCR072               WS-MSG-PART-7                                      
T13213               DELIMITED BY '  '                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
T18023               WS-MSG-PART-8                                      
                     DELIMITED BY '  '                                  
                INTO    WS-REVIEW-TEXT-MSG                              
                POINTER WS-REVIEW-TEXT-LENGTH.                          
      *                                                                         
           IF LS-CURR-WQ-ITEM EQUAL 50                                  
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16                 TO RETURN-CODE                    
              PERFORM  9999-BAIL-OUT                                    
           ELSE                                                         
              ADD 1                   TO LS-CURR-WQ-ITEM                
              SET WS-BILL-WQ-INDX     TO LS-CURR-WQ-ITEM                
              MOVE WS-FINAL-REVIEW                                      
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
           END-IF.                                                      
      *                                                                         
       2007-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      ** NOT ELIGIBLE FOR REFUND WORK QUEUE.                          **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      *                                                                         
C28160 2008-DO-NOT-REFUND-WQ.                                           
      *                                                                         
            MOVE 0                       TO WS-AMT-BILL-ITEM.           
      *                                                                         
            PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1                 
                    UNTIL WS-BILLING-INDX > 30                          
                       OR WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = ZERO     
                ADD  WS-AMT-BILL-ITEM-BG(WS-BILLING-INDX)               
                                         TO  WS-AMT-BILL-ITEM           
            END-PERFORM.                                                
      *                                                                         
            IF WS-AMT-BILL-ITEM >= 0                                    
               MOVE SPACES               TO  WS-WQ-PAREN-VM1            
                                             WS-WQ-PAREN-VM2            
            END-IF.                                                     
            MOVE WS-AMT-BILL-ITEM        TO  WS-WQ-AMT-BILL-ITEM-VM.    
      *                                                                         
            IF WS-TOTAL-AR-BALANCE-AT >= 0                              
               MOVE SPACES               TO  WS-WQ-PAREN-VM3            
                                             WS-WQ-PAREN-VM4            
            END-IF.                                                     
      *                                                                         
            MOVE WS-TOTAL-AR-BALANCE-AT  TO  WS-WQ-ACCT-BAL-VM.         
      *                                                                         
            MOVE  +302 TO WS-WQ-CATEGORY.                               
            MOVE 1  TO  WS-REVIEW-TEXT-LENGTH.                          
            MOVE WS-VOUCHER-MSG          TO  WS-MSG-PART-9              
      *                                                                         
            STRING   WS-MSG-PART-9                                      
                     DELIMITED BY SIZE                                  
      *              WS-SEMI DELIMITED BY SIZE                                  
                INTO    WS-REVIEW-TEXT-MSG                              
                POINTER WS-REVIEW-TEXT-LENGTH.                          
      *                                                                         
           IF LS-CURR-WQ-ITEM EQUAL 50                                  
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16                 TO RETURN-CODE                    
              PERFORM  9999-BAIL-OUT                                    
           ELSE                                                         
              ADD 1                   TO LS-CURR-WQ-ITEM                
              SET WS-BILL-WQ-INDX     TO LS-CURR-WQ-ITEM                
              MOVE WS-FINAL-REVIEW                                      
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
           END-IF.                                                      
      *                                                                         
       2008-EXIT.                                                       
C28160     EXIT.                                                        
                                                                        
       2009-DO-NOT-REFUND-WQ.                                           
      *                                                                         
            MOVE 0                       TO WS-AMT-BILL-ITEM.           
      *                                                                         
            PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1                 
                    UNTIL WS-BILLING-INDX > 30                          
                       OR WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = ZERO     
               ADD  WS-AMT-BILL-ITEM-BG(WS-BILLING-INDX)                
                                         TO  WS-AMT-BILL-ITEM           
            END-PERFORM.                                                
      *                                                                         
            IF WS-AMT-BILL-ITEM >= 0                                    
               MOVE SPACES               TO  WS-WQ-PAREN-PM1            
                                             WS-WQ-PAREN-PM2            
            END-IF.                                                     
            MOVE WS-AMT-BILL-ITEM        TO  WS-WQ-AMT-BILL-ITEM-PM.    
      *                                                                         
            IF WS-TOTAL-AR-BALANCE-AT >= 0                              
               MOVE SPACES               TO  WS-WQ-PAREN-PM3            
                                             WS-WQ-PAREN-PM4            
            END-IF.                                                     
      *                                                                         
            MOVE WS-TOTAL-AR-BALANCE-AT  TO  WS-WQ-ACCT-BAL-PM.         
      *                                                                         
            MOVE  +303 TO WS-WQ-CATEGORY.                               
            MOVE 1  TO  WS-REVIEW-TEXT-LENGTH.                          
            MOVE WS-PPA-MSG              TO  WS-MSG-PART-9              
      *                                                                         
            STRING   WS-MSG-PART-9                                      
                     DELIMITED BY SIZE                                  
                     WS-SEMI DELIMITED BY SIZE                          
                INTO    WS-REVIEW-TEXT-MSG                              
                POINTER WS-REVIEW-TEXT-LENGTH.                          
      *                                                                         
           IF LS-CURR-WQ-ITEM EQUAL 50                                  
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16                 TO RETURN-CODE                    
              PERFORM  9999-BAIL-OUT                                    
           ELSE                                                         
              ADD 1                   TO LS-CURR-WQ-ITEM                
              SET WS-BILL-WQ-INDX     TO LS-CURR-WQ-ITEM                
              MOVE WS-FINAL-REVIEW                                      
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
           END-IF.                                                      
      *                                                                         
       2009-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T18023**   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05642001
      **   2010-CALC-AR-EXCEPTIONS                                    **        
      **        THIS MODULE CALCULATES IF ANY DOLLARS RESIDE IN ANY   **        
      **        OTHER AR_CNTL ROWS. IT CHECKS ALL AGE BUCKETS,        **        
      **        UNUSED_CR, SUM_UNBILLED AND AMT_TRANS_BALANCE FOR ANY **        
      **        AR_CNTL ROW FOUND.  THESE EXCEPTIONS WILL BE HANDLED  **        
      **        MANUALLY.                                             **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05642001
T18023 2010-CALC-AR-EXCEPTIONS.                                         
                                                                        
T18023      EVALUATE TRUE                                               
T18023        WHEN WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX) NOT EQUAL 0    
T18023         AND WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)            
T18023                              NOT EQUAL WS-CIA                    
T18023             MOVE WS-YES      TO     WS-DOLLARS-IN-AR             
T18023        WHEN WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX) NOT EQUAL 0    
T18023         AND WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)            
T18023                              NOT EQUAL WS-CIA                    
T18023             MOVE WS-YES      TO     WS-DOLLARS-IN-AR             
T18023        WHEN WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX) NOT EQUAL 0    
T18023         AND WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)            
T18023                              NOT EQUAL WS-CIA                    
T18023             MOVE WS-YES      TO     WS-DOLLARS-IN-AR             
T18023        WHEN WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX) NOT EQUAL 0    
T18023         AND WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)            
T18023                              NOT EQUAL WS-CIA                    
T18023             MOVE WS-YES      TO     WS-DOLLARS-IN-AR             
T18023        WHEN WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) NOT EQUAL 0    
T18023         AND WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)            
T18023                              NOT EQUAL WS-CIA                    
T18023             MOVE WS-YES      TO     WS-DOLLARS-IN-AR             
T18023        WHEN WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) NOT EQUAL 0 
T18023         AND WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)            
T18023                              NOT EQUAL WS-CIA                    
T18023             MOVE WS-YES      TO     WS-DOLLARS-IN-AR             
T18023        WHEN WS-TOT-SUMM-UNBILLED-AC (WS-AR-DATA-INDX) NOT EQUAL 0
T18023         AND WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)            
T18023                              NOT EQUAL WS-CIA                    
T18023             MOVE WS-YES      TO     WS-DOLLARS-IN-AR             
T18023      END-EVALUATE.                                               
T18023                                                                  
T18023 2010-EXIT.                                                       
T18023     EXIT.                                                        
                                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05651000
      **                                                              **05660000
      ** 3000-RELEASE-REFUND.                                         **05670000
      **                                                              **05680000
      ** IF THE TOTAL AR BALANCE IS NEGATIVE AND THERE IS NO          **05690000
      ** CORRESPONDING ROW IN CSS_REFUND AND NO EXCEPTIONS APPLY THEN **05700000
      ** RELEASE THE CHECKS THAT ARE DUE TO PRINT TODAY.  WHEN THE    **05710000
      ** REFUND REACHES ITS RELEASE DATE THE ACCOUNT IS CHECKED TO    **05720000
      ** CONFIRM THE CREDIT BALANCE, EXTRACT THE REAL BALANCE FROM    **05730000
      ** AR CONTROL AND IF BALANCE MATCHES CLEAR AR BALANCE.          **05740000
      **                                                              **05750000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05760000
       3000-RELEASE-REFUND.                                             
T18023     PERFORM 2010-CALC-AR-EXCEPTIONS THRU 2010-EXIT               
T18023           VARYING WS-AR-DATA-INDX                                
T18023              FROM 1 BY 1                                         
P00097             UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY              
T18023                OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) EQUAL ZERO. 
T18023                                                                  
T18023     IF WS-DOLLARS-IN-AR EQUAL WS-YES                             
T30175           IF CSR-DATABASE                                        
T18023            PERFORM 5100-CREATE-REVIEW-REQUIRED THRU  5100-EXIT   
T30175           END-IF                                                 
T18023           MOVE WS-2-CYCLES-FROM-NOW  TO  RN-REQUEST-DT           
T18023           PERFORM 8017-UPDATE-RELEASE-ONLY    THRU  8017-EXIT    
T18023           GO TO 3000-EXIT                                        
T18023     ELSE                                                         
T18023        CONTINUE                                                  
T18023     END-IF.                                                      
                                                                        
           IF WS-TOTAL-AR-BALANCE-AT < ZERO                             
T22367      SET WS-AR-DATA-INDX TO 1                                    
PCR072      SEARCH WS-AR-DATA                                           
PCR072         AT END                                                   
PCR072           MULTIPLY -1 BY WS-TOTAL-AR-BALANCE-AT                  
PCR072                          GIVING RN-AMT-REFUNDED                  
PCR072         WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 70      
PCR072          AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 2                 
PCR072            MOVE WS-YES         TO WS-CIA-LIHEAP-PRESENT-SW       
PCR072            COMPUTE WS-CIA-LIHEAP-CREDIT =                        
PCR072                (WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) * -1)      
PCR072            COMPUTE RN-AMT-REFUNDED =                             
PCR072                 (WS-TOTAL-AR-BALANCE-AT * -1) -                  
PCR072                                      WS-CIA-LIHEAP-CREDIT        
PCR072            END-COMPUTE                                           
PCR072      END-SEARCH
           END-IF.                                                 
                                                                        
PCR072                                                                  
PCR072     IF RN-AMT-REFUNDED > 0                                       
PCR072      MOVE WS-APPROVED            TO  RN-CHECK-STATUS-CD          
PCR072      MOVE WS-CURRENT-DATE        TO  RN-REFUND-STATUS-DT         
                                                                        
PCR072      MOVE 'REFUND APPLIED'      TO RN-COMMENTS-TEXT              
PCR072      MOVE +14                   TO RN-COMMENTS-LEN               
PCR072      MOVE  WS-F                 TO RN-CHECK-ISS-REAS-CD          
PCR072      MOVE  WS-CURRENT-DATE      TO RN-DATE-REFUNDED              
                                                                        
PCR072      PERFORM 8010-UPDATE-CSS-REFUND        THRU  8010-EXIT       
PCR072     END-IF.                                                      
                                                                        
PCR072     MOVE RN-AMT-REFUNDED         TO  WS-ACCOUNT-END-AR-BAL       
                                            WS-DETAIL-END-AR-BAL.       
                                                                        
PCR072     MOVE RN-AMT-REFUNDED         TO  WS-AMT-ORIG-ENTERED.        
PCR072***  COMPUTE WS-AMT-ORIG-ENTERED                                  05862000
PCR072***          = WS-TOTAL-AR-BALANCE-AT * -1.                       05863000
                                                                        
PCR072     IF WS-CIA-LIHEAP-CREDIT > 0                                  
PCR072       COMPUTE WS-TOTAL-AR-BALANCE-AT =                           
PCR072                           WS-CIA-LIHEAP-CREDIT * -1              
PCR072     ELSE                                                         
PCR072       MOVE ZERO                  TO WS-TOTAL-AR-BALANCE-AT       
PCR072     END-IF.                                                      
                                                                        
           PERFORM 5200-PROCESS-AR-CONTROL THRU 5200-EXIT               
              VARYING WS-AR-DATA-INDX                                   
                 FROM 1 BY 1                                            
P00097          UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY                 
                   OR WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) EQUAL ZERO.    
                                                                        
PCR072      MOVE WS-CODES-DATA-PRESENT-AT TO WS-CODES-DATA-PRESENT      
PCR072      MOVE WS-A                  TO WS-CODE-CHECK-REFUND          
PCR072      MOVE WS-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT-AT      
                                                                        
ACT216      PERFORM 8025-UPDATE-WQ THRU 8025-EXIT                       
            .                                                           
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05970000
      ** 5000 SERIES PARAGRAPHS ARE "COMMON" OR "UTILITY" PARAGRAPHS  **05980000
      **                                                              **05990000
      **                                                              **06000000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06010000
      ** 5000-PROCESS-MULITPLE-ACCOUNTS.                              **06020000
      **                                                              **06030000
      ** DETERMINE IF THERE ARE RELATED CUSTOMER ACCOUNTS WITH FINAL  **06040000
      ** AND CHARGE-OFFS ONLY.                                        **06050000
      **                                                              **06060000
      ** CALLED BY:  2000-CREATE-REFUND.                              **06070000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06080000
       5000-PROCESS-MULTIPLE-ACCOUNTS.                                  
           MOVE  WS-CUSTOMER-NO-AT  TO AT-CUSTOMER-NO.                  
           MOVE  WS-ACCOUNT-NO-AT   TO AT-ACCOUNT-NO.                   
                                                                        
           PERFORM 7200-OPEN-MULTIPLE-ACCOUNTS   THRU  7200-EXIT.       
           MOVE  WS-NO TO WS-CODE-MULT-ACCT.                            
           PERFORM                                                      
                UNTIL SQLCODE EQUAL NOT-FOUND                           
                OR WS-CODE-MULT-ACCT EQUAL WS-YES                       
                PERFORM 7210-FETCH-MULTIPLE-ACCOUNTS THRU 7210-EXIT     
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              IF AT-CODE-ACCT-STAT EQUAL WS-CHARGE-OFF                  
T20981           MOVE ZEROS TO WS-CHRG-OFF-AMT                          
T20981           MOVE AT-ACCOUNT-NO TO CO-ACCOUNT-NO                    
T20981           PERFORM 7215-SELECT-CHRG-OFF THRU 7215-EXIT            
T20981           IF WS-CHRG-OFF-AMT > 0                                 
                    MOVE  WS-YES TO WS-CODE-MULT-ACCT                   
T20981           END-IF                                                 
              ELSE                                                      
                 PERFORM 7330-SELECT-AR-CONTROL  THRU 7330-EXIT         
                 IF AT-DATE-BILL-DAY-00  <  WS-25-DAYS-AGO AND          
T12895                AT-DATE-BILL-DAY-00 NOT EQUAL SPACES AND          
                                    WS-AMT-00-DAY > ZEROES AND          
                                    WS-CODE-MULT-ACCT = WS-NO           
                    MOVE WS-YES           TO  WS-CODE-MULT-ACCT         
                 END-IF                                                 
                 IF AT-DATE-BILL-DAY-30  <  WS-25-DAYS-AGO AND          
T12895                AT-DATE-BILL-DAY-30 NOT EQUAL SPACES AND          
                                    WS-AMT-30-DAY > ZEROES AND          
                                    WS-CODE-MULT-ACCT = WS-NO           
                    MOVE WS-YES           TO  WS-CODE-MULT-ACCT         
                 END-IF                                                 
                 IF AT-DATE-BILL-DAY-60  <  WS-25-DAYS-AGO AND          
T12895                AT-DATE-BILL-DAY-60 NOT EQUAL SPACES AND          
                                    WS-AMT-60-DAY > ZEROES AND          
                                    WS-CODE-MULT-ACCT = WS-NO           
                    MOVE WS-YES           TO  WS-CODE-MULT-ACCT         
                 END-IF                                                 
                 IF AT-DATE-BILL-DAY-90  <  WS-25-DAYS-AGO AND          
T12895                AT-DATE-BILL-DAY-90 NOT EQUAL SPACES AND          
                                    WS-AMT-90-DAY > ZEROES AND          
                                    WS-CODE-MULT-ACCT = WS-NO           
                    MOVE WS-YES         TO  WS-CODE-MULT-ACCT           
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           END-PERFORM.                                                 
           PERFORM 7220-CLOSE-MULTIPLE-ACCOUNTS  THRU 7220-EXIT.        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **                                                              **06570000
      ** BUILD REVIEW TEXT FOR WORK QUEUE.                            **06580000
      **                                                              **06590000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06610000
      *                                                                         
       5100-CREATE-REVIEW-REQUIRED.                                     
      *                                                                         
T20620      MOVE  +99 TO WS-WQ-CATEGORY.                                
      *                                                                         
            MOVE  RN-AMT-REFUNDED  TO  WS-AMT-REFUND.                   
            MOVE  WS-AMT-REFUND    TO  WS-MSG-PART-1.                   
      *                                                                         
      * NSF COUNT                                                       06660000
              MOVE  WS-NSF-COUNT              TO  WS-RETURN-CHECK-CTR.  
              MOVE  WS-RC                     TO  WS-MSG-PART-2.        
              MOVE  WS-RETURN-CHECK-CTR (9:1) TO  WS-MSG-PART-2 (4:1).  
                                                                        
      * PAYMENT DATE & TYPE OF PAYMENT                                  06710000
                                                                        
              IF WS-DATE-FL = WS-YES                                    
                 MOVE  AR-DATE-TRANS           TO  WS-PYMT-DATE         
                 MOVE  WS-CHECK                TO  WS-PYMT-TYPE         
                                                                        
                 STRING WS-LAST-PYMT-DATE                               
                        WS-PYMT-DATE (6:2)                              
                        WS-SLASH                                        
                        WS-PYMT-DATE (9:2)                              
                        WS-SLASH                                        
                        WS-PYMT-DATE (3:2)                              
                        ' '                                             
                        WS-PYMT-TYPE                                    
                        ' ' DELIMITED BY SIZE                           
                 INTO WS-MSG-PART-3                                     
              END-IF.                                                   
                                                                        
      * BILL EXCEPTION COUNT                                            06940000
              IF WS-BILL-EXCEPT-COUNT  >  0                             
                 MOVE  WS-BILL-EXCEPT-Y-MSG  TO  WS-MSG-PART-4          
              ELSE                                                      
                 MOVE  WS-BILL-EXCEPT-N-MSG  TO  WS-MSG-PART-4          
              END-IF.                                                   
                                                                        
      * CUSTOMER WITH MULTIPLE ACCOUNTS                                 07010000
              IF WS-CODE-MULT-ACCT  EQUAL WS-YES                        
                 MOVE  WS-MULT-ACCT-Y-MSG    TO  WS-MSG-PART-5          
              ELSE                                                      
                 MOVE  WS-MULT-ACCT-N-MSG    TO  WS-MSG-PART-5          
              END-IF.                                                   
                                                                        
              IF WS-BANKRUPTCY-IND-AT EQUAL WS-B                        
                 MOVE  WS-BANKRUPTCY-Y-MSG   TO  WS-MSG-PART-6          
T20620*          MOVE  +99                   TO  WS-WQ-CATEGORY                 
              ELSE                                                      
                 MOVE  WS-BANKRUPTCY-N-MSG   TO  WS-MSG-PART-6          
T20620*          MOVE  +98                   TO  WS-WQ-CATEGORY                 
              END-IF.                                                   
      *                                                                         
PCR072* LIHEAP PRESENT, LIHEAP PART CAN NOT BE REFUNDED.                07075200
PCR072*       IF WS-CIA-LIHEAP-PRESENT                                  07075300
T34695*       COMMENTED ABOVE FLAG AND CHECKING FOR LIHEAP ONLY FLAG    07075300
T34695        MOVE SPACES TO WS-MSG-PART-7                              
T34695        IF WS-LIHEAP-PRESENT                                      
PCR072              MOVE WS-LIHEAP-MSG  TO  WS-MSG-PART-7               
A01084              MOVE +101 TO WS-WQ-CATEGORY                         
PCR072        END-IF.                                                   
      *                                                                         
      *                                                                         
T18023        IF WS-DOLLARS-IN-AR     EQUAL WS-YES                      
T18023           MOVE WS-DOLLARS-IN-AR-MSG   TO WS-MSG-PART-8           
T20620           MOVE  +98 TO WS-WQ-CATEGORY                            
T18023        END-IF.                                                   
                                                                        
              MOVE 1  TO  WS-REVIEW-TEXT-LENGTH.                        
T34695        MOVE SPACES TO WS-REVIEW-TEXT-MSG.                        
                                                                        
              STRING WS-MSG-PART-1                                      
T13213               DELIMITED BY SIZE                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
                     WS-MSG-PART-2                                      
T13213               DELIMITED BY '  '                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
                     WS-MSG-PART-3                                      
T13213               DELIMITED BY '  '                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
                     WS-MSG-PART-4                                      
T13213               DELIMITED BY '  '                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
                     WS-MSG-PART-5                                      
T13213               DELIMITED BY '  '                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
                     WS-MSG-PART-6                                      
T13213               DELIMITED BY '  '                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
PCR072               WS-MSG-PART-7                                      
T13213               DELIMITED BY '  '                                  
T13213               WS-SEMI DELIMITED BY SIZE                          
T18023               WS-MSG-PART-8                                      
                     DELIMITED BY '  '                                  
                INTO    WS-REVIEW-TEXT-MSG                              
                POINTER WS-REVIEW-TEXT-LENGTH.                          
                                                                        
      *    EVALUATE TRUE                                                07190000
      *      WHEN WS-CODE-BILL-ITM-IND-BG (WS-BILLING-INDX)             07200000
      *           EQUAL WS-K OR WS-J                                    07210000
               IF LS-CURR-WQ-ITEM EQUAL 50                              
                   DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'            
                   DISPLAY 'PROCESSING TERMINATED'                      
                   MOVE 16                 TO RETURN-CODE               
                   PERFORM  9999-BAIL-OUT                               
               ELSE                                                     
                   ADD 1                   TO LS-CURR-WQ-ITEM           
                   SET WS-BILL-WQ-INDX     TO LS-CURR-WQ-ITEM           
                   MOVE WS-FINAL-REVIEW                                 
                     TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)   
               END-IF.                                                  
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **07370000
      ** 5200-PROCESS-AR-CONTROL.                                     **07380000
      **                                                              **07390000
      ** THIS MODULE PROCESSES ACCOUNTS ON CSS_AR_CNTL.               **07400000
      **                                                              **07410000
      ** CALLED BY:  3000-RELEASE-REFUND.                             **07420000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **07430000
       5200-PROCESS-AR-CONTROL.                                         
              EVALUATE TRUE                                             
                  WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
                       EQUAL WS-NSC                                     
                       MOVE WS-AR-NSC-GL-NO (WS-GL-SUB)  TO  WS-GL-NO   
                  WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
                       EQUAL WS-NSA                                     
                       MOVE WS-AR-NSA-GL-NO (WS-GL-SUB)  TO  WS-GL-NO   
                  WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
                       EQUAL WS-LPC                                     
                       MOVE WS-AR-LPC-GL-NO (WS-GL-SUB)  TO  WS-GL-NO   
                  WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
                       EQUAL WS-UTE                                     
                       MOVE WS-AR-UTE-GL-NO (WS-GL-SUB)  TO  WS-GL-NO   
                  WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
                       EQUAL WS-UTG                                     
                       MOVE WS-AR-UTG-GL-NO (WS-GL-SUB)  TO  WS-GL-NO   
                  WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
                       EQUAL WS-BUD                                     
                       MOVE WS-AR-BUD-GL-NO (WS-GL-SUB)  TO  WS-GL-NO   
                  WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
                       EQUAL WS-CCC                                     
                       MOVE WS-AR-CCC-GL-NO (WS-GL-SUB)  TO  WS-GL-NO   
                  WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
                       EQUAL WS-CIA                                     
                       MOVE WS-AR-CIA-GL-NO (WS-GL-SUB)  TO  WS-GL-NO   
                  WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
                       EQUAL WS-DEP                                     
                       MOVE WS-AR-DEP-GL-NO (WS-GL-SUB) TO  WS-GL-NO    
                  WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
                       EQUAL WS-DFA                                     
                       MOVE WS-AR-DFA-GL-NO (WS-GL-SUB) TO  WS-GL-NO    
                  WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)        
                       EQUAL WS-CNT                                     
                       MOVE WS-AR-CNT-GL-NO (WS-GL-SUB) TO  WS-GL-NO    
              END-EVALUATE.                                             
                                                                        
                                                                        
           IF WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX) > 0                 
T13169        MOVE WS-UNUSED-CR         TO  WS-CODE-AR-AGE              
T13169        MOVE WS-GL-NO             TO  WS-GL-ACCT-CREDIT           
T13169        MOVE WS-CLR-CK-ISS-GL-NO (WS-GL-SUB)                      
                                        TO  WS-GL-ACCT-DEBIT            
              MOVE WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)                
                                        TO  WS-AMT-TO-POST              
              COMPUTE WS-DETAIL-END-AR-BAL = WS-DETAIL-END-AR-BAL       
                  - WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)               
              COMPUTE WS-ACCOUNT-END-AR-BAL = WS-ACCOUNT-END-AR-BAL     
                  - WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)               
              MOVE ZEROES TO WS-AMT-AR-DAY-00-AC (WS-AR-DATA-INDX)      
              PERFORM 6420-CREATE-101-JRNL        THRU  6420-EXIT       
              PERFORM 6430-CREATE-FIOWK03         THRU  6430-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX) > 0                 
T13169        MOVE WS-UNUSED-CR         TO  WS-CODE-AR-AGE              
T13169        MOVE WS-GL-NO             TO  WS-GL-ACCT-CREDIT           
T13169        MOVE WS-CLR-CK-ISS-GL-NO (WS-GL-SUB)                      
                                        TO  WS-GL-ACCT-DEBIT            
              MOVE WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)                
                                        TO  WS-AMT-TO-POST              
              COMPUTE WS-DETAIL-END-AR-BAL = WS-DETAIL-END-AR-BAL       
                 - WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)                
              COMPUTE WS-ACCOUNT-END-AR-BAL = WS-ACCOUNT-END-AR-BAL     
                 - WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)                
              MOVE ZEROES TO WS-AMT-AR-DAY-30-AC (WS-AR-DATA-INDX)      
              PERFORM 6420-CREATE-101-JRNL        THRU  6420-EXIT       
              PERFORM 6430-CREATE-FIOWK03         THRU  6430-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX) > 0                 
T13169        MOVE WS-UNUSED-CR         TO  WS-CODE-AR-AGE              
T13169        MOVE WS-GL-NO             TO  WS-GL-ACCT-CREDIT           
T13169        MOVE WS-CLR-CK-ISS-GL-NO (WS-GL-SUB)                      
                                        TO  WS-GL-ACCT-DEBIT            
              MOVE WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)                
                                        TO  WS-AMT-TO-POST              
              COMPUTE WS-DETAIL-END-AR-BAL = WS-DETAIL-END-AR-BAL       
                 - WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)                
              COMPUTE WS-ACCOUNT-END-AR-BAL = WS-ACCOUNT-END-AR-BAL     
                 - WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)                
              MOVE ZEROES TO WS-AMT-AR-DAY-60-AC (WS-AR-DATA-INDX)      
              PERFORM 6420-CREATE-101-JRNL        THRU  6420-EXIT       
              PERFORM 6430-CREATE-FIOWK03         THRU  6430-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX) > 0                 
T13169        MOVE WS-UNUSED-CR         TO  WS-CODE-AR-AGE              
T13169        MOVE WS-GL-NO             TO  WS-GL-ACCT-CREDIT           
T13169        MOVE WS-CLR-CK-ISS-GL-NO (WS-GL-SUB)                      
                                        TO  WS-GL-ACCT-DEBIT            
              MOVE WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)                
                                        TO  WS-AMT-TO-POST              
              COMPUTE WS-DETAIL-END-AR-BAL = WS-DETAIL-END-AR-BAL       
                 - WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)                
              COMPUTE WS-ACCOUNT-END-AR-BAL = WS-ACCOUNT-END-AR-BAL     
                 - WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)                
              MOVE ZEROES TO WS-AMT-AR-DAY-90-AC (WS-AR-DATA-INDX)      
              PERFORM 6420-CREATE-101-JRNL        THRU  6420-EXIT       
              PERFORM 6430-CREATE-FIOWK03         THRU  6430-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) < 0                 
PCR072     AND NOT (WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)           
PCR072                                   EQUAL WS-CIA                   
PCR072              AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 2)            
              MOVE WS-UNUSED-CR         TO  WS-CODE-AR-AGE              
              MOVE WS-GL-NO             TO  WS-GL-ACCT-DEBIT            
              MOVE WS-CLR-CK-ISS-GL-NO (WS-GL-SUB)                      
                                        TO  WS-GL-ACCT-CREDIT           
T10895*       MOVE WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)                08601000
T10895*                                 TO  WS-AMT-TO-POST              08602000
T10895        COMPUTE WS-AMT-TO-POST =                                  
T10895                 WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) * -1       
              COMPUTE WS-DETAIL-END-AR-BAL = WS-DETAIL-END-AR-BAL       
T10895           - WS-AMT-TO-POST                                       
              COMPUTE WS-ACCOUNT-END-AR-BAL = WS-ACCOUNT-END-AR-BAL     
T10895           - WS-AMT-TO-POST                                       
              MOVE ZEROES TO WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)      
PCR072        IF (WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX)             
PCR072                                 EQUAL WS-CIA                     
PCR072        AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 1)                  
PCR072           MOVE WS-DELETE                                         
PCR072                    TO WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX)  
T9278         MOVE ZEROES TO WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)   
PCR072        END-IF                                                    
              PERFORM 6420-CREATE-101-JRNL        THRU  6420-EXIT       
              PERFORM 6430-CREATE-FIOWK03         THRU  6430-EXIT       
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **08730000
      **    5300-GET-COUNT-BILLING-DET.                               **08740000
      **                                                              **08750000
      **    DETERMINE IF THERE ARE ANY BILLING EXCEPTIONS.            **08760000
      **                                                              **08770000
      **    CALLED BY:  2000-CREATE-REFUND.                           **08780000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **08790000
       5300-GET-COUNT-BILLING-DET.                                      
           MOVE 0                TO  WS-BILL-EXCEPT-COUNT.              
           SET  WS-BILLING-INDX  TO  1.                                 
                                                                        
           SEARCH  WS-BILLING-DATA                                      
                   WHEN WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = 0          
                        CONTINUE                                        
                   WHEN WS-CODE-BILL-ITM-IND-BG (WS-BILLING-INDX)       
                        = WS-K                                          
                        ADD  +1  TO  WS-BILL-EXCEPT-COUNT               
                   WHEN WS-CODE-BILL-ITM-IND-BG (WS-BILLING-INDX)       
                        = WS-J                                          
                        ADD  +1  TO  WS-BILL-EXCEPT-COUNT               
           END-SEARCH.                                                  
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****** 6400 SERIES - BATCH JOURNAL ROUTINE                        09540000
                                                                        
      ******************************************************************09560000
      *                                                                *09570000
      *     6420-CREATE-101.                                           *09580000
      *                                                                *09590000
      *     MOVE COMMON DATA TO 101-JOURNAL.                           *09600000
      *                                                                *09610000
      *     CALLED BY:  5200-PROCESS-AR-CONTROL.                       *09620000
      ******************************************************************09630000
       6420-CREATE-101-JRNL.                                            
T8620      INITIALIZE CJF00101.                                         
T10895     MOVE WS-101                  TO WS-101-JRNL-FORMAT-NO.       
           MOVE WS-CASH-DRAWER-ID       TO WS-101-CASH-DRAWER-USED.     
           MOVE WS-AMT-ORIG-ENTERED     TO WS-101-AMOUNT-ENTERED.       
           MOVE WS-AMT-TO-POST          TO WS-101-AMT-POSTED.           
           MOVE LS-CURR-REVENUE-MONTH   TO WS-101-REVENUE-MONTH.        
           MOVE WS-GL-ACCT-DEBIT        TO WS-101-ACCT-GEN-LED-DR.      
           MOVE WS-GL-ACCT-CREDIT       TO WS-101-ACCT-GEN-LED-CR.      
           MOVE WS-CODE-AR-AGE          TO WS-101-AR-AGE.               
           MOVE LS-INPUT-DATE           TO WS-101-DATE-AR-BILLED.       
           MOVE ZERO                    TO WS-101-ITEM-ID-NO.           
           MOVE ZERO                    TO WS-101-DETAIL-END-BAL.       
           MOVE ZERO                    TO WS-101-DETAIL-END-AR-BAL.    
T10895*    MOVE WS-TOTAL-AR-BALANCE-AT  TO WS-101-ACCT-END-AR-BAL.      09760000
           MOVE SPACES                  TO WS-101-FUNCTION-CODE.        
           MOVE WS-REV-DISTRICT-CD-PR   TO WS-101-CODE-REVENUE-DISTRICT.
           MOVE WS-CODE-EMPL-ACCT-CU    TO WS-101-CODE-EMPL-ACCT.       
           MOVE WS-CODE-COMPANY-ACCT-AT TO WS-101-CODE-COMPANY-ACCT.    
           MOVE WS-CODE-ACCT-STAT-AT    TO WS-101-CODE-ACCOUNT-STATUS.  
           MOVE WS-CODE-PREMISE-STAT-PR TO WS-101-CODE-PREMISE-STATUS.  
                                                                        
       6420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*****************************************************************09870000
      *                                                                *09880000
      *     6430-CREATE-FIOWK03.                                       *09890000
      *                                                                *09900000
      *     MOVE COMMON DATA TO FIOWK3.                                *09910000
      *                                                                *09920000
      *     CALLED BY:  5200-PROCESS-AR-CONTROL.                       *09930000
      ******************************************************************09940000
       6430-CREATE-FIOWK03.                                             
           MOVE WS-INDIRECT-JRNL        TO E-FWK03-JRNL-SORT-ID.        
           MOVE WS-COMPANY-NO-AT        TO E-FWK03-COMPANY-NO.          
           MOVE WS-LOCAL-OFFICE-AT      TO E-FWK03-LOCAL-OFFICE.        
T17678*    MOVE AT-ACCOUNT-NO           TO E-FWK03-ACCT-NO.             09990000
T17678     MOVE WS-ACCOUNT-NO-AT        TO E-FWK03-ACCT-NO.             
           MOVE WS-CUSTOMER-NO-CU       TO E-FWK03-CUSTOMER-NO.         
T10895     MOVE 'BILL'                  TO E-FWK03-CODE-TERMINAL-TRAN.  
           MOVE 1                       TO E-FWK03-JRNL-TRAN-APPL-NO.   
           MOVE LS-INPUT-DATE           TO E-FWK03-DATE-LAST-ACTION.    
T10895     MOVE WS-BATCH                TO E-FWK03-CODE-ENTRY-SOURCE.   
           MOVE SPACES                  TO E-FWK03-TRAN-ERRORS.         
           MOVE CJF00101                TO E-FWK03-USER-DEFINED-AREA.   
           MOVE WS-AMT-TO-POST          TO E-FWK03-RCV-DEBIT-AMT.       
           MOVE ZEROS                   TO E-FWK03-RCV-CREDIT-AMT.      
           MOVE ZEROS                   TO E-FWK03-GEN-LEG-DEBIT-AMT.   
           MOVE WS-AMT-TO-POST          TO E-FWK03-GEN-LEG-CREDIT-AMT.  
           MOVE ZEROS                   TO E-FWK03-SORT-SUM-FLD.        
                                                                        
           PERFORM 8100-WRITE-WK03      THRU 8100-EXIT.                 
       6430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T21381 6540-INSERT-MH-ROW.                                              
      *                                                                         
T21381     PERFORM 7602-GET-CURR-DATE-STAMP THRU 7602-EXIT.             
T21381     MOVE CURRENT-TIMESTAMP TO MH-TRANS-HIST-SEQ-NO.              
      *                                                                         
T21381     MOVE WS-ACCOUNT-NO-AT  TO MH-ACCOUNT-NO.                     
T21381     MOVE WS-CUSTOMER-NO-AT TO MH-CUSTOMER-NO.                    
T21381     MOVE WS-PREMISE-NO-AT  TO MH-PREMISE-NO.                     
T21381     MOVE 'SCSCA109'        TO MH-APPL-PROGRAM-ID.                
T21381     MOVE WS-CURRENT-DATE   TO MH-DATE-TRANS.                     
T21381     MOVE 'F'               TO MH-CODE-TRAN-TYPE.                 
T21381     MOVE SPACES            TO MH-RESP-AREA-ID.                   
T21381     MOVE 'SYSTEM'          TO MH-USER-ID.                        
T21381     EXEC SQL                                                     
T21381         INSERT INTO CSS_MNT_TRANS_HIST                           
T21381           ( DATE_TRANS,                                          
T21381             CODE_TRAN_TYPE,                                      
T21381             RESP_AREA_ID,                                        
T21381             ACCOUNT_NO,                                          
T21381             CUSTOMER_NO,                                         
T21381             PREMISE_NO,                                          
T21381             USER_ID,                                             
T21381             APPL_PROGRAM_ID,                                     
T21381             TRAN_COMMENT,                                        
T21381             TRANS_HIST_SEQ_NO)                                   
T21381         VALUES                                                   
T21381           ( IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
T21381             :MH-CODE-TRAN-TYPE,                                  
T21381             :MH-RESP-AREA-ID,                                    
T21381             :MH-ACCOUNT-NO,                                      
T21381             :MH-CUSTOMER-NO,                                     
T21381             :MH-PREMISE-NO,                                      
T21381             :MH-USER-ID,                                         
T21381             :MH-APPL-PROGRAM-ID,                                 
T21381             :MH-TRAN-COMMENT,                                    
T21381             CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO))                   
T21381     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                                   
MFA-TR*          ( DATE_TRANS,                                                  
MFA-TR*            CODE_TRAN_TYPE,                                              
MFA-TR*            RESP_AREA_ID,                                                
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            PREMISE_NO,                                                  
MFA-TR*            USER_ID,                                                     
MFA-TR*            APPL_PROGRAM_ID,                                             
MFA-TR*            TRAN_COMMENT,                                                
MFA-TR*            TRANS_HIST_SEQ_NO)                                           
MFA-TR*        VALUES                                                           
MFA-TR*          ( :MH-DATE-TRANS,                                              
MFA-TR*            :MH-CODE-TRAN-TYPE,                                          
MFA-TR*            :MH-RESP-AREA-ID,                                            
MFA-TR*            :MH-ACCOUNT-NO,                                              
MFA-TR*            :MH-CUSTOMER-NO,                                             
MFA-TR*            :MH-PREMISE-NO,                                              
MFA-TR*            :MH-USER-ID,                                                 
MFA-TR*            :MH-APPL-PROGRAM-ID,                                         
MFA-TR*            :MH-TRAN-COMMENT,                                            
MFA-TR*            :MH-TRANS-HIST-SEQ-NO)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T21381     IF SQLCODE NOT = SUCCESSFUL-CALL                             
T21381        MOVE 'MH'                 TO WS-DB2-TABLE-ID              
T21381        MOVE 'INSERT'             TO WS-DB2-FUNCTION              
T21381        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T21381        MOVE '109'                TO WS-DB2-MODULE-ID             
T21381        MOVE '6540'               TO WS-DB2-PARAGRAPH             
T21381        MOVE MH-ACCOUNT-NO        TO WS-DB2-KEY-1                 
T21381        MOVE 16 TO RETURN-CODE                                    
T21381        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT
           END-IF.                
      *                                                                         
T21381 6540-EXIT.                                                       
T21381     EXIT.                                                        
      *                                                                         
T21381 6550-MT-DATE-ROW.                                                
DORKIT     MOVE 'DATE CHANGE'        TO MI-COLUMN-DESC                  
DORKIT     MOVE WS-SAVE-PREV-DATE    TO MI-PRV-COLUMN-VALUE-TEXT        
DORKIT     MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN         
DORKIT     MOVE SPACES               TO MI-TABLE-ID                     
DORKIT     MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO            
DORKIT     MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN         
DORKIT     MOVE RN-REQUEST-DT        TO MI-CHG-COLUMN-VALUE-TEXT        
T21381     EXEC SQL                                                     
T21381         INSERT INTO CSS_MT_TRN_HST_DET                           
T21381         ( TRANS_HIST_SEQ_NO,                                     
T21381         TRAN_APPL_NO,                                            
T21381         COLUMN_DESC,                                             
T21381         PRV_COLUMN_VALUE,                                        
T21381         CHG_COLUMN_VALUE,                                        
T21381         TABLE_ID)                                                
T21381       VALUES                                                     
T21381        ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),                      
T21381          :MI-TRAN-APPL-NO,                                       
T21381          :MI-COLUMN-DESC,                                        
T21381          :MI-PRV-COLUMN-VALUE,                                   
T21381          :MI-CHG-COLUMN-VALUE,                                   
T21381          :MI-TABLE-ID)                                           
T21381     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                                   
MFA-TR*        ( TRANS_HIST_SEQ_NO,                                             
MFA-TR*        TRAN_APPL_NO,                                                    
MFA-TR*        COLUMN_DESC,                                                     
MFA-TR*        PRV_COLUMN_VALUE,                                                
MFA-TR*        CHG_COLUMN_VALUE,                                                
MFA-TR*        TABLE_ID)                                                        
MFA-TR*      VALUES                                                             
MFA-TR*       ( :MI-TRANS-HIST-SEQ-NO,                                          
MFA-TR*         :MI-TRAN-APPL-NO,                                               
MFA-TR*         :MI-COLUMN-DESC,                                                
MFA-TR*         :MI-PRV-COLUMN-VALUE,                                           
MFA-TR*         :MI-CHG-COLUMN-VALUE,                                           
MFA-TR*         :MI-TABLE-ID)                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T21381     IF SQLCODE NOT = SUCCESSFUL-CALL                             
T21381        MOVE 'MI'                 TO WS-DB2-TABLE-ID              
T21381        MOVE 'INSERT'             TO WS-DB2-FUNCTION              
T21381        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T21381        MOVE '109'                TO WS-DB2-MODULE-ID             
T21381        MOVE '6550'               TO WS-DB2-PARAGRAPH             
T21381        MOVE MH-ACCOUNT-NO        TO WS-DB2-KEY-1                 
T21381        MOVE 16 TO RETURN-CODE                                    
T21381        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT
           END-IF.                
      *                                                                         
T21381 6550-EXIT.                                                       
T21381     EXIT.                                                        
      *                                                                         
T21381 6551-MT-AMT-ROW.                                                 
DORKIT     MOVE 'AMT CHANGE '        TO MI-COLUMN-DESC                  
DORKIT     MOVE WS-SAVE-PREV-AMOUNT  TO WS-AMT-REFUND-MI                
DORKIT*    MOVE WS-AMT-REFUND-MI     TO WS-9-MI-AREA                            
DORKIT     MOVE WS-AMT-REFUND-MI     TO WS-X-MI-AREA                    
DORKIT     MOVE WS-X-MI-AREA         TO MI-PRV-COLUMN-VALUE-TEXT        
      *                                                                         
           DISPLAY 'ACCT = ' WS-ACCOUNT-NO-AT                           
           DISPLAY 'WS-SAVE-PREV-AMT =  ' WS-SAVE-PREV-AMOUNT           
           DISPLAY 'WS-9-MI-AREA = '  WS-9-MI-AREA                      
           DISPLAY 'WS-X-M-AREA = ' WS-X-MI-AREA                        
           DISPLAY 'WS-AMT-REFUND-MI = ' WS-AMT-REFUND-MI               
           DISPLAY 'MI-PRV-COL-VAL-TEXT = 'MI-PRV-COLUMN-VALUE-TEXT     
           DISPLAY '     '                                              
      *                                                                         
DORKIT     MOVE +13                  TO MI-PRV-COLUMN-VALUE-LEN         
DORKIT     MOVE SPACES               TO MI-TABLE-ID                     
DORKIT     MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO            
DORKIT     MOVE +13                  TO MI-CHG-COLUMN-VALUE-LEN         
DORKIT     MOVE WS-REFUND-COMPARE    TO WS-AMT-REFUND-MI                
DORKIT*    MOVE WS-AMT-REFUND-MI     TO WS-9-MI-AREA                            
DORKIT     MOVE WS-AMT-REFUND-MI     TO WS-X-MI-AREA                    
DORKIT     MOVE WS-X-MI-AREA         TO MI-CHG-COLUMN-VALUE-TEXT        
      *                                                                         
           DISPLAY 'ACCT = ' WS-ACCOUNT-NO-AT                           
           DISPLAY 'RN-AMT-REFUNDED =  ' RN-AMT-REFUNDED                
           DISPLAY 'WS-9-MI-AREA = '  WS-9-MI-AREA                      
           DISPLAY 'WS-X-M-AREA = ' WS-X-MI-AREA                        
           DISPLAY 'WS-AMT-REFUND-MI = ' WS-AMT-REFUND-MI               
           DISPLAY 'MI-CHG-COL-VAL-TEXT = ' MI-CHG-COLUMN-VALUE-TEXT    
           DISPLAY '     '                                              
      *                                                                         
T21381     EXEC SQL                                                     
T21381         INSERT INTO CSS_MT_TRN_HST_DET                           
T21381         ( TRANS_HIST_SEQ_NO,                                     
T21381         TRAN_APPL_NO,                                            
T21381         COLUMN_DESC,                                             
T21381         PRV_COLUMN_VALUE,                                        
T21381         CHG_COLUMN_VALUE,                                        
T21381         TABLE_ID)                                                
T21381       VALUES                                                     
T21381        ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),                      
T21381          :MI-TRAN-APPL-NO,                                       
T21381          :MI-COLUMN-DESC,                                        
T21381          :MI-PRV-COLUMN-VALUE,                                   
T21381          :MI-CHG-COLUMN-VALUE,                                   
T21381          :MI-TABLE-ID)                                           
T21381     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                                   
MFA-TR*        ( TRANS_HIST_SEQ_NO,                                             
MFA-TR*        TRAN_APPL_NO,                                                    
MFA-TR*        COLUMN_DESC,                                                     
MFA-TR*        PRV_COLUMN_VALUE,                                                
MFA-TR*        CHG_COLUMN_VALUE,                                                
MFA-TR*        TABLE_ID)                                                        
MFA-TR*      VALUES                                                             
MFA-TR*       ( :MI-TRANS-HIST-SEQ-NO,                                          
MFA-TR*         :MI-TRAN-APPL-NO,                                               
MFA-TR*         :MI-COLUMN-DESC,                                                
MFA-TR*         :MI-PRV-COLUMN-VALUE,                                           
MFA-TR*         :MI-CHG-COLUMN-VALUE,                                           
MFA-TR*         :MI-TABLE-ID)                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T21381     IF SQLCODE NOT = SUCCESSFUL-CALL                             
T21381        MOVE 'MI'                 TO WS-DB2-TABLE-ID              
T21381        MOVE 'INSERT'             TO WS-DB2-FUNCTION              
T21381        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T21381        MOVE '109'                TO WS-DB2-MODULE-ID             
T21381        MOVE '6550'               TO WS-DB2-PARAGRAPH             
T21381        MOVE MH-ACCOUNT-NO        TO WS-DB2-KEY-1                 
T21381        MOVE 16 TO RETURN-CODE                                    
T21381        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT
           END-IF.                
      *                                                                         
T21381 6551-EXIT.                                                       
T21381     EXIT.                                                        
      *                                                                         
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **11510000
      **    7000-SELECT-COUNT-NSF-HIST.                               **11520000
      **                                                              **11530000
      **    DETERMINE THE NUMBER OF NSF ITEMS FROM NH TABLE.          **11540000
      **                                                              **11550000
      **    CALLED BY:  2000-CREATE-REFUND.                           **11560000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **11570000
       7000-SELECT-COUNT-NSF-HIST.                                      
           EXEC SQL                                                     
                SELECT   COUNT(*)                                       
                  INTO   :WS-NSF-COUNT                                  
                  FROM   CSS_NSF_HIST WITH(READUNCOMMITTED)                     
                 WHERE   ACCOUNT_NO     = :AT-ACCOUNT-NO                
                   AND   NSF_STATUS_CD  = :WS-COMPLETE                  
T34695                                                           
A02798                                                      
          END-EXEC.                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11590000
MFA-TR*         SELECT   COUNT(*)                                       11600000
MFA-TR*           INTO   :WS-NSF-COUNT                                  11610000
MFA-TR*           FROM   CSS_NSF_HIST                                   11620000
MFA-TR*          WHERE   ACCOUNT_NO     = :AT-ACCOUNT-NO                11630000
MFA-TR*            AND   NSF_STATUS_CD  = :WS-COMPLETE                  11640000
MFA-TR*          WITH UR                                                11640000
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*   END-EXEC.                                                     11650000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              EVALUATE SQLCODE                                          
                 WHEN SUCCESSFUL-CALL                                   
                      CONTINUE                                          
                 WHEN NOT-FOUND                                         
                      MOVE ZERO                TO  WS-NSF-COUNT         
                 WHEN OTHER                                             
                      MOVE 'NH'                TO  WS-DB2-TABLE-ID      
                      MOVE 'SELECT'            TO  WS-DB2-FUNCTION      
                      MOVE SQLCODE             TO  WS-DB2-RETURN-CODE   
                      MOVE '109'               TO  WS-DB2-MODULE-ID     
                      MOVE '7000'              TO  WS-DB2-PARAGRAPH     
T18165                MOVE AT-ACCOUNT-NO       TO  WS-DB2-KEY-1N        
                      MOVE 12                  TO  RETURN-CODE          
                      PERFORM 9900-SQL-ERROR THRU 9900-EXIT
           END-IF.            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **11850000
      **    7100-SELECT-AR-PYMT-DATE-TYPE.                            **11860000
      **                                                              **11870000
      **    DETERMINE THE LAST PAYMENT DATE AND TYPE OF PAYMENT.      **11880000
      **                                                              **11890000
      **    CALLED BY:  2000-CREATE-REFUND.                           **11900000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **11910000
       7100-SELECT-AR-PYMT-DATE-TYPE.                                   
           EXEC SQL                                                     
A02798        SELECT TOP(1) AR.DATE_TRANS,
              AU.CURRENCY_TYPE                                   
                INTO :AR-DATE-TRANS :WS-DATE-TRANS-NULL-IND              
A02798              ,:AU-CURRENCY-TYPE                                  
              FROM CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED),                  
                   CSS_AR_TRN_HST_DET AU WITH(READUNCOMMITTED)                  
              WHERE AR.ACCOUNT_NO         = :AT-ACCOUNT-NO              
T18355           AND AR.ACCOUNT_NO        = AU.ACCOUNT_NO               
                 AND AR.CODE_TRAN_TYPE    = :WS-PAYMENT                 
                 AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO        
A02798           AND AU.CURRENCY_TYPE IN (:WS-CHECK, :WS-CREDIT-CARD)   
A02798         ORDER BY AR.DATE_TRANS    DESC                           
A02798                 ,AU.CURRENCY_TYPE DESC                           
A02798                                              
T34695                                                           
A02798                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11930000
MFA-TR*       SELECT AR.DATE_TRANS                                      11931000
MFA-TR*             ,AU.CURRENCY_TYPE                                   11931000
MFA-TR*         INTO :AR-DATE-TRANS:WS-DATE-TRANS-NULL-IND              11931100
MFA-TR*             ,:AU-CURRENCY-TYPE                                  11931000
MFA-TR*       FROM CSS_AR_TRANS_HIST AR,                                11932000
MFA-TR*            CSS_AR_TRN_HST_DET AU                                11933000
MFA-TR*       WHERE AR.ACCOUNT_NO         = :AT-ACCOUNT-NO              11934000
MFA-TR*          AND AR.ACCOUNT_NO        = AU.ACCOUNT_NO                       
MFA-TR*          AND AR.CODE_TRAN_TYPE    = :WS-PAYMENT                 11935000
MFA-TR*          AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO        11936000
MFA-TR*          AND AU.CURRENCY_TYPE IN (:WS-CHECK, :WS-CREDIT-CARD)   11938000
MFA-TR*        ORDER BY AR.DATE_TRANS    DESC                           11938000
MFA-TR*                ,AU.CURRENCY_TYPE DESC                           11938000
MFA-TR*        FETCH FIRST ROW ONLY                                     11938000
MFA-TR*       WITH UR                                                   11640000
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                    12070000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 IF WS-DATE-TRANS-NULL-IND < 0                          
                    MOVE LOW-VALUES       TO AR-DATE-TRANS              
                 ELSE                                                   
                    MOVE WS-YES TO WS-DATE-FL                           
                 END-IF                                                 
              WHEN NOT-FOUND                                            
                 MOVE LOW-VALUES          TO  AR-DATE-TRANS             
              WHEN OTHER                                                
                 MOVE 'AR'                TO  WS-DB2-TABLE-ID           
                 MOVE 'SELECT'            TO  WS-DB2-FUNCTION           
                 MOVE SQLCODE             TO  WS-DB2-RETURN-CODE        
                 MOVE '109'               TO  WS-DB2-MODULE-ID          
                 MOVE '7100'              TO  WS-DB2-PARAGRAPH          
                 MOVE RN-ACCOUNT-NO       TO  WS-DB2-KEY-1N             
                 MOVE AU-ACCOUNT-NO       TO  WS-DB2-KEY-2N             
                 MOVE 12                  TO  RETURN-CODE               
                 PERFORM 9900-SQL-ERROR THRU 9900-EXIT.                 
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **12290000
      **    7200-OPEN-MULTIPLE-ACCOUNTS.                              **12300000
      **                                                              **12310000
      **    OPEN CURSOR FOR CSS_ACCOUNT.                              **12320000
      **                                                              **12330000
      **    CALLED BY:  5000-PROCESS-MULTIPLE-ACCOUNTS.               **12340000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **12350000
       7200-OPEN-MULTIPLE-ACCOUNTS.                                     
           EXEC SQL                                                     
                OPEN ACCOUNT                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AT'                TO  WS-DB2-TABLE-ID              
              MOVE 'OPEN'              TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '109'               TO  WS-DB2-MODULE-ID             
              MOVE '7200'              TO  WS-DB2-PARAGRAPH             
              MOVE AT-CODE-ACCT-STAT   TO  WS-DB2-KEY-1                 
              MOVE AT-ACCOUNT-NO       TO  WS-DB2-KEY-2N                
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT
           END-IF.                    
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **12570000
      **    7210-FETCH-MULTIPLE-ACCOUNTS.                             **12580000
      **                                                              **12590000
      **    FETCH COLUMNS FROM CSS_ACCOUNT.                           **12600000
      **                                                              **12610000
      **    CALLED BY:  5000-PROCESS-MULTIPLE-ACCOUNTS.               **12620000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **12630000
       7210-FETCH-MULTIPLE-ACCOUNTS.                                    
           EXEC SQL                                                     
                FETCH     ACCOUNT                                       
                 INTO     :AT-ACCOUNT-NO,                               
                          :AT-CODE-ACCT-STAT,                           
FCS                       :AT-LOCAL-OFFICE,                             
T12895                    :AT-DATE-BILL-DAY-00 :WS-DT-00-NULL-IND,       
T12895                    :AT-DATE-BILL-DAY-30 :WS-DT-30-NULL-IND,       
T12895                    :AT-DATE-BILL-DAY-60 :WS-DT-60-NULL-IND,       
T12895                    :AT-DATE-BILL-DAY-90 :WS-DT-90-NULL-IND        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
T12895          IF WS-DT-00-NULL-IND < 0                                
T12895             MOVE SPACES TO AT-DATE-BILL-DAY-00                   
T12895          END-IF                                                  
T12895          IF WS-DT-30-NULL-IND < 0                                
T12895             MOVE SPACES TO AT-DATE-BILL-DAY-30                   
T12895          END-IF                                                  
T12895          IF WS-DT-60-NULL-IND < 0                                
T12895             MOVE SPACES TO AT-DATE-BILL-DAY-60                   
T12895          END-IF                                                  
T12895          IF WS-DT-90-NULL-IND < 0                                
T12895             MOVE SPACES TO AT-DATE-BILL-DAY-90                   
T12895          END-IF                                                  
           ELSE                                                         
                MOVE 'AT'                TO  WS-DB2-TABLE-ID            
                MOVE 'FETCH'             TO  WS-DB2-FUNCTION            
                MOVE SQLCODE             TO  WS-DB2-RETURN-CODE         
                MOVE '109'               TO  WS-DB2-MODULE-ID           
                MOVE '7210'              TO  WS-DB2-PARAGRAPH           
                MOVE AT-CODE-ACCT-STAT   TO  WS-DB2-KEY-1               
                MOVE AT-ACCOUNT-NO       TO  WS-DB2-KEY-2N              
                MOVE 12                  TO  RETURN-CODE                
                PERFORM 9900-SQL-ERROR THRU 9900-EXIT
           END-IF.                  
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T20981 7215-SELECT-CHRG-OFF.                                            
T20981     EXEC SQL                                                     
T20981         SELECT SUM (AMT_TRANS)                                   
T20981           INTO :WS-CHRG-OFF-AMT :WS-PAR-NULL-IND                 
T20981           FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
T20981          WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                       
T34695                                                           
A02798                                                      
T20981     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM (AMT_TRANS)                                           
MFA-TR*          INTO :WS-CHRG-OFF-AMT :WS-PAR-NULL-IND                         
MFA-TR*          FROM CSS_CHRG_OFF                                              
MFA-TR*         WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                  11640000
MFA-TR*        QUERYNO 7215                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T20981     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T20981     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T20981       NEXT SENTENCE                                              
T20981     ELSE                                                         
T20981       MOVE 'CO'                TO  WS-DB2-TABLE-ID               
T20981       MOVE 'SELECT'            TO  WS-DB2-FUNCTION               
T20981       MOVE SQLCODE             TO  WS-DB2-RETURN-CODE            
T20981       MOVE '109'               TO  WS-DB2-MODULE-ID              
T20981       MOVE '7215'              TO  WS-DB2-PARAGRAPH              
T20981       MOVE AT-ACCOUNT-NO       TO  WS-DB2-KEY-1N                 
T20981       MOVE 12                  TO  RETURN-CODE                   
T20981       PERFORM 9900-SQL-ERROR THRU 9900-EXIT                      
T20981     END-IF.                                                      
      *                                                                         
T20981 7215-EXIT.                                                       
           EXIT.                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **12920000
      **    7220-CLOSE-MULTIPLE-ACCOUNTS.                             **12930000
      **                                                              **12940000
      **    CLOSE CURSOR FOR CSS_ACCOUNT.                             **12950000
      **                                                              **12960000
      **    CALLED BY:  5000-PROCESS-MULTIPLE-ACCOUNTS.               **12970000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **12980000
       7220-CLOSE-MULTIPLE-ACCOUNTS.                                    
           EXEC SQL                                                     
                CLOSE ACCOUNT                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AT'                TO  WS-DB2-TABLE-ID              
              MOVE 'CLOSE'             TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '109'               TO  WS-DB2-MODULE-ID             
              MOVE '7220'              TO  WS-DB2-PARAGRAPH             
              MOVE AT-CODE-ACCT-STAT   TO  WS-DB2-KEY-1                 
              MOVE AT-ACCOUNT-NO       TO  WS-DB2-KEY-2N                
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT
           END-IF.                    
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **14090000
      **    7330-SELECT-AR-CONTROL.                                   **14100000
      **                                                              **14110000
      **    SELECT COLUMN NAMES FROM AR TABLE.                        **14120000
      **                                                              **14130000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **14150000
       7330-SELECT-AR-CONTROL.                                          
           EXEC SQL                                                     
              SELECT SUM(AMT_AR_DAY_00),                                
                     SUM(AMT_AR_DAY_30),                                
                     SUM(AMT_AR_DAY_60),                                
                     SUM(AMT_AR_DAY_90)                                 
              INTO   :WS-AMT-00-DAY :WS-AMT-00-NULL-IND,                 
                     :WS-AMT-30-DAY :WS-AMT-30-NULL-IND,                 
                     :WS-AMT-60-DAY :WS-AMT-60-NULL-IND,                 
                     :WS-AMT-90-DAY :WS-AMT-90-NULL-IND                  
              FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                            
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND ITEM_ID    = 0                                      
T34695                                                           
A02798                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14161000
MFA-TR*       SELECT SUM(AMT_AR_DAY_00),                                14162000
MFA-TR*              SUM(AMT_AR_DAY_30),                                14163000
MFA-TR*              SUM(AMT_AR_DAY_60),                                14164000
MFA-TR*              SUM(AMT_AR_DAY_90)                                 14165000
MFA-TR*       INTO   :WS-AMT-00-DAY:WS-AMT-00-NULL-IND,                 14166000
MFA-TR*              :WS-AMT-30-DAY:WS-AMT-30-NULL-IND,                 14167000
MFA-TR*              :WS-AMT-60-DAY:WS-AMT-60-NULL-IND,                 14168000
MFA-TR*              :WS-AMT-90-DAY:WS-AMT-90-NULL-IND                  14169000
MFA-TR*       FROM CSS_AR_CNTL                                          14169100
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         14170000
MFA-TR*         AND ITEM_ID    = 0                                      14180000
MFA-TR*       WITH UR                                                   11640000
MFA-TR*       QUERYNO 7330                                                      
MFA-TR*    END-EXEC.                                                    14190000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO  WS-ACTIVE-RETURN-CODE.                     
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-AMT-00-NULL-IND < 0                                 
                 MOVE ZEROES TO WS-AMT-00-DAY                           
              END-IF                                                    
              IF WS-AMT-30-NULL-IND < 0                                 
                 MOVE ZEROES TO WS-AMT-30-DAY                           
              END-IF                                                    
              IF WS-AMT-60-NULL-IND < 0                                 
                 MOVE ZEROES TO WS-AMT-60-DAY                           
              END-IF                                                    
              IF WS-AMT-90-NULL-IND < 0                                 
                 MOVE ZEROES TO WS-AMT-90-DAY                           
              END-IF                                                    
           ELSE                                                         
              MOVE 'AC'                    TO  WS-DB2-TABLE-ID          
              MOVE 'SELECT'                TO  WS-DB2-FUNCTION          
              MOVE SQLCODE                 TO  WS-DB2-RETURN-CODE       
              MOVE '109'                   TO  WS-DB2-MODULE-ID         
              MOVE '7330'                  TO  WS-DB2-PARAGRAPH         
              MOVE AT-ACCOUNT-NO           TO  WS-DB2-KEY-1N            
              MOVE 12                      TO  RETURN-CODE              
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT
           END-IF.                    
      *                                                                         
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  *         
      **  GET NUMBER OF DAYS FROM DELINQUENCY TABLE                   *         
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  *         
      *                                                                         
       7600-DELINQUENCY-TABLE-VALUE.                                    
A02798*                                                                         
A02798     IF AU-CURRENCY-TYPE = WS-CREDIT-CARD                         
A02798        MOVE 'DAY-REFUND-CARD' TO C8-DELINQ-CD                    
A02798     ELSE                                                         
A02798        MOVE 'DAY-REFUND-CHECK' TO C8-DELINQ-CD                   
A02798     END-IF.                                                      
T19900     PERFORM 6791D-SELECT-DELINQUENCY THRU 6791D-EXIT.            
      *                                                                         
T19900     MOVE C8-DELINQ-VALUE TO WS-DEL-WORK-AREA.                    
T19900*                                                                         
T19900     MOVE SPACES TO WS-DELINQUENCY-DATE.                          
T19900     COMPUTE WS-REF-TRANS = 101 - WS-DEL-WORK-AREA.               
T19900     MOVE WS-WORK-DAY (WS-REF-TRANS) TO WS-DEL-WORK-DATE.         
      *                                                                         
      *  IF PAYMENT DATE GREATER THAN CURRENT DATE, LOAD TODAY                  
      *     PLUS 10 DAYS TO WS-DELINQUENCY-DATE AND GET OUT.                    
      *                                                                         
           IF AR-DATE-TRANS > WS-WORK-DAY (101)                         
              MOVE WS-WORK-DAY (111) TO WS-DELINQUENCY-DATE             
              GO TO 7600-EXIT                                           
           END-IF.                                                      
      *                                                                         
T19900     IF AR-DATE-TRANS > WS-DEL-WORK-DATE                          
T19900        CONTINUE                                                  
T19900     ELSE                                                         
T19900        GO TO 7600-EXIT
           END-IF.                                          
      *                                                                         
T19900     MOVE 'N' TO WS-FOUND.                                        
T19900     PERFORM VARYING WS-REF-CTR FROM WS-REF-TRANS BY +1           
T19900        UNTIL WS-REF-CTR > +101 OR WS-FOUND = 'Y'                 
T21086          IF WS-WORK-DAY (WS-REF-CTR) < AR-DATE-TRANS             
T21086            CONTINUE                                              
T21086          ELSE                                                    
T19900            COMPUTE WS-REF-TRANS = WS-REF-CTR + WS-DEL-WORK-AREA  
T19900            MOVE WS-WORK-DAY (WS-REF-TRANS)                       
T19900                     TO WS-DELINQUENCY-DATE                       
T19900            MOVE 'Y' TO WS-FOUND                                  
T19900          END-IF                                                  
T19900     END-PERFORM.                                                 
      *                                                                         
T19900 7600-EXIT.                                                       
T19900     EXIT.                                                        
C28160******************************************************************36710000
      * 7605-OPEN-CODE-REF-EXISTS                                      *36720000
      *      OPEN THE CURSOR TO SELECT DEP_ON_HAND DATA FOR A GIVEN    *36730000
      *      ACCOUNT-NO WITH DEPOSIT STATUS = 'A' OR 'P' AND           *36740000
      *      CODE-REFUND-ELIG = 'A'.                                   *        
      ******************************************************************36750000
      *                                                                 36760000
C28160 7605-OPEN-CODE-REF-EXISTS.                                       
      *                                                                 36780000
           EXEC SQL                                                     
                OPEN CODE_REF_IN_EXISTS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 36820000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 36831000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 'DO'                TO  WS-DB2-TABLE-ID              
              MOVE 'OPEN'              TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '109'               TO  WS-DB2-MODULE-ID             
              MOVE '7605'              TO  WS-DB2-PARAGRAPH             
C28160        MOVE DO-ACCOUNT-NO       TO  WS-DB2-KEY-1                 
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-SQL-ERROR               THRU 9900-EXIT       
            END-IF.                                                     
      *                                                                 36950000
C28160 7605-OPEN-EXIT.                                                  
           EXIT.                                                        
      *                                                                 36980000
C28160 7610-FETCH-CODE-REF-EXISTS.                                      
      *                                                                 37000000
           EXEC SQL                                                     
                FETCH  CODE_REF_IN_EXISTS                               
                INTO   :WS-CODE-REF-IN-EXISTS                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37050000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 37061000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO    WS-CODE-REF-IN-EXISTS                   
              END-IF                                                    
           ELSE                                                         
              MOVE 'DO'                TO  WS-DB2-TABLE-ID              
              MOVE 'OPEN'              TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '109'               TO  WS-DB2-MODULE-ID             
              MOVE '7610'              TO  WS-DB2-PARAGRAPH             
C28160        MOVE DO-ACCOUNT-NO       TO  WS-DB2-KEY-1                 
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-SQL-ERROR               THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 37200000
C28160 7610-FETCH-EXIT.                                                 
           EXIT.                                                        
      *                                                                 37230000
C28160 7615-CLOSE-CODE-REF-EXISTS.                                      
      *                                                                 37250000
           EXEC SQL                                                     
                CLOSE CODE_REF_IN_EXISTS                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37290000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 37301000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 'DO'                TO  WS-DB2-TABLE-ID              
              MOVE 'CLOSE'             TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '109'               TO  WS-DB2-MODULE-ID             
              MOVE '7615'              TO  WS-DB2-PARAGRAPH             
C28160        MOVE DO-ACCOUNT-NO       TO  WS-DB2-KEY-1                 
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-SQL-ERROR               THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 37420000
C28160 7615-EXIT.                                                       
           EXIT.                                                        
      *                                                                 36950000
C28160 7620-OPEN-PPA-EXISTS.                                            
      *                                                                 36780000
           EXEC SQL                                                     
                OPEN PPA_EXISTS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 36820000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 36831000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 'DO'                TO  WS-DB2-TABLE-ID              
              MOVE 'OPEN'              TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '109'               TO  WS-DB2-MODULE-ID             
              MOVE '7620'              TO  WS-DB2-PARAGRAPH             
C28160        MOVE DO-ACCOUNT-NO       TO  WS-DB2-KEY-1                 
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-SQL-ERROR               THRU 9900-EXIT       
            END-IF.                                                     
      *                                                                 36950000
C28160 7620-OPEN-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
C28160 7625-FETCH-PPA-EXISTS.                                           
      *                                                                 37000000
           EXEC SQL                                                     
                FETCH  PPA_EXISTS                                       
                INTO   :WS-PPA-EXISTS                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37050000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 37061000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO    WS-PPA-EXISTS                           
              END-IF                                                    
           ELSE                                                         
              MOVE 'DO'                TO  WS-DB2-TABLE-ID              
              MOVE 'OPEN'              TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '109'               TO  WS-DB2-MODULE-ID             
              MOVE '7625'              TO  WS-DB2-PARAGRAPH             
C28160        MOVE DO-ACCOUNT-NO       TO  WS-DB2-KEY-1                 
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-SQL-ERROR               THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 37200000
C28160 7625-FETCH-EXIT.                                                 
           EXIT.                                                        
      *                                                                 37230000
C28160 7630-CLOSE-PPA-EXISTS.                                           
      *                                                                 37250000
           EXEC SQL                                                     
                CLOSE PPA_EXISTS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37290000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 37301000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE 'DO'                TO  WS-DB2-TABLE-ID              
              MOVE 'CLOSE'             TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '109'               TO  WS-DB2-MODULE-ID             
              MOVE '7630'              TO  WS-DB2-PARAGRAPH             
C28160        MOVE DO-ACCOUNT-NO       TO  WS-DB2-KEY-1                 
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-SQL-ERROR               THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 37420000
C28160 7630-EXIT.                                                       
           EXIT.                                                        
      *                                                                 36950000
      ***************************************************************           
      *  SELECT THE DELINQUENCY VALUE FROM THE CSS_DELINQUENCY TABLE*           
      ***************************************************************           
      *                                                                         
T19900 6791D-SELECT-DELINQUENCY.                                        
           EXEC SQL                                                     
T19900        SELECT DELINQ_VALUE                                       
T19900          INTO :C8-DELINQ-VALUE                                   
T19900          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
T19900         WHERE DELINQ_CD = :C8-DELINQ-CD                          
T23501         AND  COMPANY_NO = :WS-COMPANY-NO-AT                      
T34695                                                           
A02798                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15320000
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*        AND  COMPANY_NO = :WS-COMPANY-NO-AT                              
MFA-TR*        WITH UR                                                  11640000
MFA-TR*       QUERYNO 6791                                                      
MFA-TR*    END-EXEC.                                                    15360000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T19900     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
T19900        MOVE 'C8'                 TO WS-DB2-TABLE-ID              
T19900        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
T19900        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T19900        MOVE '109'                TO WS-DB2-MODULE-ID             
T19900        MOVE '6791D'              TO WS-DB2-PARAGRAPH             
T19900        MOVE C8-DELINQ-CD         TO WS-DB2-KEY-1N                
T19900        MOVE 12 TO RETURN-CODE                                    
T19900        PERFORM 9900-SQL-ERROR THRU 9900-EXIT                     
T19900     END-IF.                                                      
      *                                                                         
T19900 6791D-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
T21381 7602-GET-CURR-DATE-STAMP.                                        
T21381     EXEC SQL                                                     
T21381*        SELECT CURRENT TIMESTAMP,                                        
T21381*               CURRENT DATE                                              
T21381*          INTO :CURRENT-TIMESTAMP,                                       
T21381*               :CURRENT-DATE                                             
T21381*          FROM CSS_MODEL_SQL                                             
T34695         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :CURRENT-TIMESTAMP,
              :CURRENT-DATE                  
T21381     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CURRENT TIMESTAMP,                                        
MFA-TR*               CURRENT DATE                                              
MFA-TR*          INTO :CURRENT-TIMESTAMP,                                       
MFA-TR*               :CURRENT-DATE                                             
MFA-TR*          FROM CSS_MODEL_SQL                                             
MFA-TR*        SET   :CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*             ,:CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21381     IF SQLCODE NOT = SUCCESSFUL-CALL                             
T21381        MOVE 'MS'                 TO WS-DB2-TABLE-ID              
T21381        MOVE 'SELECT'             TO WS-DB2-FUNCTION              
T21381        MOVE SQLCODE              TO WS-DB2-RETURN-CODE           
T21381        MOVE '109'                TO WS-DB2-MODULE-ID             
T21381        MOVE '7600'               TO WS-DB2-PARAGRAPH             
T21381        MOVE 12 TO RETURN-CODE                                    
T21381        PERFORM 9900-SQL-ERROR     THRU 9900-EXIT                 
T21381     END-IF.                                                      
      *                                                                         
T21381 7602-EXIT.                                                       
T21381     EXIT.                                                        
      *                                                                         
      *                                                                         
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **  SELECT STATUS = 'R' FROM CSS_REFUND TABLE                   **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      *                                                                         
T21381 7700-STATUS-R-REFUND.                                            
T21381     EXEC SQL                                                     
T21381          SELECT AMT_REFUNDED,                                    
T21381                 REFUND_ITEM_ID,                                  
T21381                 REQUEST_DT                                       
T21381            INTO :RN-AMT-REFUNDED,                                
T21381                 :RN-REFUND-ITEM-ID,                              
T21381                 :RN-REQUEST-DT                                   
T21381          FROM CSS_REFUND WITH(READUNCOMMITTED)                           
T21381          WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 
T21381            AND CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD            
T21381            AND PANEL_NO         = :RN-PANEL-NO                   
T21381            AND MANUAL_INDICATOR = :RN-MANUAL-INDICATOR           
T34695                                                           
A02798                                                      
T21381     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AMT_REFUNDED,                                            
MFA-TR*                REFUND_ITEM_ID,                                          
MFA-TR*                REQUEST_DT                                               
MFA-TR*           INTO :RN-AMT-REFUNDED,                                        
MFA-TR*                :RN-REFUND-ITEM-ID,                                      
MFA-TR*                :RN-REQUEST-DT                                           
MFA-TR*         FROM CSS_REFUND                                                 
MFA-TR*         WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                         
MFA-TR*           AND CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD                    
MFA-TR*           AND PANEL_NO         = :RN-PANEL-NO                           
MFA-TR*           AND MANUAL_INDICATOR = :RN-MANUAL-INDICATOR                   
MFA-TR*         WITH UR                                                 11640000
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T21381     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21381     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21381        MOVE RN-AMT-REFUNDED TO WS-SAVE-PREV-AMOUNT               
T21381     ELSE                                                         
T21381        MOVE ZEROS TO WS-SAVE-PREV-AMOUNT                         
T21381     END-IF.                                                      
      *                                                                         
T21381     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21381                                    OR NOT-FOUND                  
T21381        NEXT SENTENCE                                             
T21381     ELSE                                                         
T21381         MOVE 'RN'                    TO WS-DB2-TABLE-ID          
T21381         MOVE 'SELECT'                TO WS-DB2-FUNCTION          
T21381         MOVE SQLCODE                 TO WS-DB2-RETURN-CODE       
T21381         MOVE '109'                   TO WS-DB2-MODULE-ID         
T21381         MOVE '7700'                  TO WS-DB2-PARAGRAPH         
T21381         MOVE RN-ACCOUNT-NO           TO WS-DB2-KEY-1N            
T21381         MOVE 12                      TO RETURN-CODE              
T21381         PERFORM 9900-SQL-ERROR THRU 9900-EXIT                    
T21381     END-IF.                                                      
T21381 7700-EXIT.                                                       
T21381     EXIT.                                                        
      *                                                                         
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **  SELECT STATUS = 'A' FROM CSS_REFUND TABLE                   **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      *                                                                         
T21381 7701-STATUS-A-REFUND.                                            
T21381     EXEC SQL                                                     
T21381          SELECT AMT_REFUNDED,                                    
T21381                 REFUND_ITEM_ID,                                  
T21381                 REQUEST_DT                                       
T21381            INTO :RN-AMT-REFUNDED,                                
T21381                 :RN-REFUND-ITEM-ID,                              
T21381                 :RN-REQUEST-DT                                   
T21381          FROM CSS_REFUND WITH(READUNCOMMITTED)                           
T21381          WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 
T21381            AND CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD            
ACT216            AND (PANEL_NO         = :RN-PANEL-NO  OR              
ACT216                 PANEL_NO         = 'P275'        OR              
ACT216                 PANEL_NO         = 'P111'        OR              
ACT216                 PANEL_NO         = 'P259')                       
ACT216            AND (MANUAL_INDICATOR = :RN-MANUAL-INDICATOR OR       
ACT216                 MANUAL_INDICATOR = 'M'  )                        
T34695                                                           
A02798                                                      
T21381     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AMT_REFUNDED,                                            
MFA-TR*                REFUND_ITEM_ID,                                          
MFA-TR*                REQUEST_DT                                               
MFA-TR*           INTO :RN-AMT-REFUNDED,                                        
MFA-TR*                :RN-REFUND-ITEM-ID,                                      
MFA-TR*                :RN-REQUEST-DT                                           
MFA-TR*         FROM CSS_REFUND                                                 
MFA-TR*         WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                         
MFA-TR*           AND CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD                    
MFA-TR*           AND (PANEL_NO         = :RN-PANEL-NO  OR                      
MFA-TR*                PANEL_NO         = 'P275'        OR                      
MFA-TR*                PANEL_NO         = 'P111'        OR                      
MFA-TR*                PANEL_NO         = 'P259')                               
MFA-TR*           AND (MANUAL_INDICATOR = :RN-MANUAL-INDICATOR OR               
MFA-TR*                MANUAL_INDICATOR = 'M'  )                                
MFA-TR*         WITH UR                                                 11640000
MFA-TR*         QUERYNO 7701                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21381                                                                  
T21381     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21381     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21381                       OR NOT-FOUND OR WS-811                     
T21381        NEXT SENTENCE                                             
T21381     ELSE                                                         
T21381         MOVE 'RN'                    TO WS-DB2-TABLE-ID          
T21381         MOVE 'SELECT'                TO WS-DB2-FUNCTION          
T21381         MOVE SQLCODE                 TO WS-DB2-RETURN-CODE       
T21381         MOVE '109'                   TO WS-DB2-MODULE-ID         
T21381         MOVE '7701'                  TO WS-DB2-PARAGRAPH         
T21381         MOVE RN-ACCOUNT-NO           TO WS-DB2-KEY-1N            
T21381         MOVE 12                      TO RETURN-CODE              
T21381         PERFORM 9900-SQL-ERROR THRU 9900-EXIT
           END-IF.                   
T21381 7701-EXIT.                                                       
T21381     EXIT.                                                        
      *                                                                         
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **  SELECT STATUS = 'I' FROM CSS_REFUND TABLE, REFUND DATE      **        
      **         MUST BE SINCE FINAL DATE.                            **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      *                                                                         
T21381 7702-STATUS-I-REFUND.                                            
T21381     EXEC SQL                                                     
T21381          SELECT AMT_REFUNDED,                                    
T21381                 REFUND_ITEM_ID,                                  
T21381                 REQUEST_DT                                       
T21381            INTO :RN-AMT-REFUNDED,                                
T21381                 :RN-REFUND-ITEM-ID,                              
T21381                 :RN-REQUEST-DT                                   
T21381          FROM CSS_REFUND WITH(READUNCOMMITTED)                           
T21381          WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 
T21381            AND CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD            
T21381            AND PANEL_NO         = :RN-PANEL-NO                   
T21381            AND MANUAL_INDICATOR = :RN-MANUAL-INDICATOR           
T21381            AND (REQUEST_DT  > IIF(TRY_CONVERT(DATE, 
                                                    :WS-FINAL-DATE-7702
              ) IS NULL OR (PATINDEX('%.%', :WS-FINAL-DATE-7702
              ) <> 0) OR (LEN(:WS-FINAL-DATE-7702
              ) <> 10), CIS.CHAR2DATE(:WS-FINAL-DATE-7702
              ), CONVERT(DATE, :WS-FINAL-DATE-7702) )                
T21381            OR   REQUEST_DT  = IIF(TRY_CONVERT(DATE, 
                                                    :WS-FINAL-DATE-7702
              ) IS NULL OR (PATINDEX('%.%', :WS-FINAL-DATE-7702
              ) <> 0) OR (LEN(:WS-FINAL-DATE-7702
              ) <> 10), CIS.CHAR2DATE(:WS-FINAL-DATE-7702
              ), CONVERT(DATE, :WS-FINAL-DATE-7702) ))               
T34695                                                           
A02798                                                      
T21381     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AMT_REFUNDED,                                            
MFA-TR*                REFUND_ITEM_ID,                                          
MFA-TR*                REQUEST_DT                                               
MFA-TR*           INTO :RN-AMT-REFUNDED,                                        
MFA-TR*                :RN-REFUND-ITEM-ID,                                      
MFA-TR*                :RN-REQUEST-DT                                           
MFA-TR*         FROM CSS_REFUND                                                 
MFA-TR*         WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                         
MFA-TR*           AND CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD                    
MFA-TR*           AND PANEL_NO         = :RN-PANEL-NO                           
MFA-TR*           AND MANUAL_INDICATOR = :RN-MANUAL-INDICATOR                   
MFA-TR*           AND (REQUEST_DT  > :WS-FINAL-DATE-7702                        
MFA-TR*           OR   REQUEST_DT  = :WS-FINAL-DATE-7702)                       
MFA-TR*         WITH UR                                                 11640000
MFA-TR*         QUERYNO 7702                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21381                                                                  
T21381     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21381     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21381                          OR NOT-FOUND OR WS-811                  
T21381        NEXT SENTENCE                                             
T21381     ELSE                                                         
T21381         MOVE 'RN'                    TO WS-DB2-TABLE-ID          
T21381         MOVE 'SELECT'                TO WS-DB2-FUNCTION          
T21381         MOVE SQLCODE                 TO WS-DB2-RETURN-CODE       
T21381         MOVE '109'                   TO WS-DB2-MODULE-ID         
T21381         MOVE '7702'                  TO WS-DB2-PARAGRAPH         
T21381         MOVE RN-ACCOUNT-NO           TO WS-DB2-KEY-1N            
T21381         MOVE 12                      TO RETURN-CODE              
T21381         PERFORM 9900-SQL-ERROR THRU 9900-EXIT
           END-IF.                   
T21381 7702-EXIT.                                                       
T21381     EXIT.                                                        
      *                                                                         
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **  SELECT FROM CSS_REFUND TABLE                                **15522100
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **15522200
      *                                                                         
       7703-SELECT-REFUND.                                              
           EXEC SQL                                                     
                SELECT AMT_REFUNDED                                     
T15199                ,REFUND_ITEM_ID                                   
                  INTO :RN-AMT-REFUNDED                                 
T15199                ,:RN-REFUND-ITEM-ID                               
                FROM CSS_REFUND WITH(READUNCOMMITTED)                           
                WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 
                  AND REQUEST_DT       = IIF(TRY_CONVERT(DATE, 
                                                         :RN-REQUEST-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT
              ) <> 0) OR (LEN(:RN-REQUEST-DT) <> 10), CIS.CHAR2DATE(
                                                         :RN-REQUEST-DT
              ), CONVERT(DATE, :RN-REQUEST-DT) )                 
ACT292            AND (CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD OR        
ACT216                 CHECK_STATUS_CD  = 'D' )                         
ACT292            AND (PANEL_NO         = :RN-PANEL-NO  OR              
ACT216                 PANEL_NO         = 'P275'        OR              
ACT216                 PANEL_NO         = 'P111'        OR              
ACT216                 PANEL_NO         = 'P259')                       
ACT292            AND (MANUAL_INDICATOR = :RN-MANUAL-INDICATOR OR       
ACT216                 MANUAL_INDICATOR = 'M' )                         
T34695                                                           
A02798                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15522400
MFA-TR*         SELECT AMT_REFUNDED                                     15522500
MFA-TR*               ,REFUND_ITEM_ID                                   15522603
MFA-TR*           INTO :RN-AMT-REFUNDED                                 15522703
MFA-TR*               ,:RN-REFUND-ITEM-ID                               15522803
MFA-TR*         FROM CSS_REFUND                                         15522903
MFA-TR*         WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 15523003
MFA-TR*           AND REQUEST_DT       = :RN-REQUEST-DT                 15523103
MFA-TR*           AND (CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD OR                
MFA-TR*                CHECK_STATUS_CD  = 'D' )                                 
MFA-TR*           AND (PANEL_NO         = :RN-PANEL-NO  OR                      
MFA-TR*                PANEL_NO         = 'P275'        OR                      
MFA-TR*                PANEL_NO         = 'P111'        OR                      
MFA-TR*                PANEL_NO         = 'P259')                               
MFA-TR*           AND (MANUAL_INDICATOR = :RN-MANUAL-INDICATOR OR               
MFA-TR*                MANUAL_INDICATOR = 'M' )                                 
MFA-TR*         WITH UR                                                 11640000
MFA-TR*         QUERYNO 7703                                                    
MFA-TR*    END-EXEC.                                                    15523503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                                          OR NOT-FOUND                  
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE 'RN'                    TO WS-DB2-TABLE-ID          
               MOVE 'SELECT'                TO WS-DB2-FUNCTION          
               MOVE SQLCODE                 TO WS-DB2-RETURN-CODE       
               MOVE '109'                   TO WS-DB2-MODULE-ID         
               MOVE '7703'                  TO WS-DB2-PARAGRAPH         
T18165         MOVE RN-ACCOUNT-NO           TO WS-DB2-KEY-1N            
               MOVE 12                      TO RETURN-CODE              
               PERFORM 9900-SQL-ERROR THRU 9900-EXIT
           END-IF.                   
      *                                                                         
       7703-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **15525203
T15199**  CHECK FOR A REFUND TOMORROW (C/R DONE DAY AFTER FINAL)      **15525303
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **15525403
T15199 7710-CHECK-REFUND-TOMORROW.                                      
T15199     EXEC SQL                                                     
T15199          SELECT AMT_REFUNDED,                                    
T15199                 REFUND_ITEM_ID,                                  
T21381                 REQUEST_DT                                       
T15199            INTO :RN-AMT-REFUNDED,                                
T15199                 :RN-REFUND-ITEM-ID,                              
T21381                 :RN-REQUEST-DT                                   
T15199          FROM CSS_REFUND WITH(READUNCOMMITTED)                           
T15199          WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 
T15199            AND REQUEST_DT       = IIF(TRY_CONVERT(DATE, 
                                                          :WS-NEXT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-NEXT-DATE
              ) <> 0) OR (LEN(:WS-NEXT-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-NEXT-DATE
              ), CONVERT(DATE, :WS-NEXT-DATE) )                  
T15199            AND CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD            
T15199            AND PANEL_NO         = :RN-PANEL-NO                   
T15199            AND MANUAL_INDICATOR = :RN-MANUAL-INDICATOR           
T34695                                                           
A02798                                                      
T15199     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15525603
MFA-TR*         SELECT AMT_REFUNDED,                                            
MFA-TR*                REFUND_ITEM_ID,                                          
MFA-TR*                REQUEST_DT                                               
MFA-TR*           INTO :RN-AMT-REFUNDED,                                        
MFA-TR*                :RN-REFUND-ITEM-ID,                                      
MFA-TR*                :RN-REQUEST-DT                                           
MFA-TR*         FROM CSS_REFUND                                         15526103
MFA-TR*         WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 15526203
MFA-TR*           AND REQUEST_DT       = :WS-NEXT-DATE                  15526303
MFA-TR*           AND CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD            15526403
MFA-TR*           AND PANEL_NO         = :RN-PANEL-NO                   15526503
MFA-TR*           AND MANUAL_INDICATOR = :RN-MANUAL-INDICATOR           15526603
MFA-TR*         WITH UR                                                 11640000
MFA-TR*         QUERYNO 7710                                                    
MFA-TR*    END-EXEC.                                                    15526703

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T15199     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T15199     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T15199                                    OR NOT-FOUND                  
T15199        NEXT SENTENCE                                             
T15199     ELSE                                                         
T15199         MOVE 'RN'                    TO WS-DB2-TABLE-ID          
T15199         MOVE 'SELECT'                TO WS-DB2-FUNCTION          
T15199         MOVE SQLCODE                 TO WS-DB2-RETURN-CODE       
T15199         MOVE '109'                   TO WS-DB2-MODULE-ID         
T15199         MOVE '7710'                  TO WS-DB2-PARAGRAPH         
T18165         MOVE RN-ACCOUNT-NO           TO WS-DB2-KEY-1N            
T15199         MOVE 12                      TO RETURN-CODE              
T15199         PERFORM 9900-SQL-ERROR THRU 9900-EXIT
           END-IF.                   
T15199 7710-EXIT.                                                       
T15199     EXIT.                                                        
                                                                        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **15528403
T15199**  GET MAX ITEM ID                                             **15528503
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **15528603
T15199 7720-SELECT-MAX-ITEM-ID.                                         
T15199     EXEC SQL                                                     
T15199         SELECT MAX(REFUND_ITEM_ID)                               
T15199           INTO :RN-REFUND-ITEM-ID :WS-REFUND-NULL                
T15199           FROM CSS_REFUND WITH(READUNCOMMITTED)                          
T15199          WHERE ACCOUNT_NO = :RN-ACCOUNT-NO                       
T34695                                                           
A02798                                                      
T15199     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15528803
MFA-TR*        SELECT MAX(REFUND_ITEM_ID)                               15528903
MFA-TR*          INTO :RN-REFUND-ITEM-ID :WS-REFUND-NULL                15529003
MFA-TR*          FROM CSS_REFUND                                        15529103
MFA-TR*         WHERE ACCOUNT_NO = :RN-ACCOUNT-NO                       15529203
MFA-TR*         WITH UR                                                 11640000
MFA-TR*         QUERYNO 7720                                                    
MFA-TR*    END-EXEC.                                                    15529303

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T15199     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T15199     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T15199        IF WS-REFUND-NULL < 0                                     
T15199           MOVE 0 TO RN-REFUND-ITEM-ID                            
T15199        ELSE                                                      
T15199           COMPUTE RN-REFUND-ITEM-ID = RN-REFUND-ITEM-ID + 1      
T15199        END-IF                                                    
T15199     ELSE                                                         
T15199        IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND               
T15199          MOVE 0 TO RN-REFUND-ITEM-ID                             
T15199        ELSE                                                      
T15199         MOVE 'RN'                    TO WS-DB2-TABLE-ID          
T15199         MOVE 'SELECT'                TO WS-DB2-FUNCTION          
T15199         MOVE SQLCODE                 TO WS-DB2-RETURN-CODE       
T15199         MOVE '109'                   TO WS-DB2-MODULE-ID         
T15199         MOVE '7720'                  TO WS-DB2-PARAGRAPH         
T18165         MOVE RN-ACCOUNT-NO           TO WS-DB2-KEY-1N            
T15199         MOVE 12                      TO RETURN-CODE              
T15199         PERFORM 9900-SQL-ERROR THRU 9900-EXIT
              END-IF
           END-IF.                   
T15199 7720-EXIT.                                                       
T15199     EXIT.                                                        
                                                                        
      **** ALL SQL INSERTS, UPDATES, AND DELETES GO IN THE 8000-        15533503
      **** RANGE OF PARAGRAPHS                                          15534003
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **15550000
      **    8000-INSERT-CSS-REFUND.                                   **15560000
      **                                                              **15570000
      **    INSERT THE CURRENT REFUND TO BE ISSUED.                   **15580000
      **                                                              **15590000
      **    CALLED BY:  2000-CREATE-REFUND.                           **15600000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **15610000
       8000-INSERT-CSS-REFUND.                                          
           EXEC SQL                                                     
                INSERT INTO CSS_REFUND                                  
                  (REFUND_ITEM_ID,                                      
                   REFUND_CHECK_NO,                                     
                   DEPOSIT_CERT_NO,                                     
                   LOCAL_OFFICE,                                        
                   AMT_REFUNDED,                                        
                   REQUEST_DT,                                          
                   CHECK_STATUS_CD,                                     
T11892*            CHECK_ISS_REAS_CD,                                   15792000
                   ORIGINAL_CHECK_NO,                                   
                   RETURNED_REASON,                                     
                   MANUAL_INDICATOR,                                    
                   USER_ID_APPRVD_BY,                                   
                   REFUND_STATUS_DT,                                    
T11892*            DATE_REFUNDED,                                       15851000
                   USER_ID_RQSTED_BY,                                   
                   ACCOUNT_NO,                                          
                   PANEL_NO,                                            
                   ADDRESS_ID,                                          
                   TRANS_HIST_SEQ_NO)                                   
T11892*            COMMENTS)                                            15920000
                VALUES                                                  
                   (:RN-REFUND-ITEM-ID,                                 
                    :RN-REFUND-CHECK-NO,                                
                    :RN-DEPOSIT-CERT-NO,                                
                    :RN-LOCAL-OFFICE,                                   
                    :RN-AMT-REFUNDED,                                   
                    IIF(TRY_CONVERT(DATE, :RN-REQUEST-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT
              ) <> 0) OR (LEN(:RN-REQUEST-DT) <> 10), CIS.CHAR2DATE(
                                                         :RN-REQUEST-DT
              ), CONVERT(DATE, :RN-REQUEST-DT) ),                              
                    :RN-CHECK-STATUS-CD,                                
T11892*             :RN-CHECK-ISS-REAS-CD,                              16082000
                    :RN-ORIGINAL-CHECK-NO,                              
                    :RN-RETURNED-REASON,                                
                    :RN-MANUAL-INDICATOR,                               
                    :RN-USER-ID-APPRVD-BY,                              
                    IIF(TRY_CONVERT(DATE, :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) ),                        
T11892*             :RN-DATE-REFUNDED,                                  16141000
                    :RN-USER-ID-RQSTED-BY,                              
                    :RN-ACCOUNT-NO,                                     
                    :RN-PANEL-NO,                                       
                    :RN-ADDRESS-ID,                                     
                    CIS.CURRENT$TIMESTAMP())                                  
T11892*             :RN-COMMENTS)                                       16210000
                END-EXEC.                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15630000
MFA-TR*         INSERT INTO CSS_REFUND                                  15640000
MFA-TR*           (REFUND_ITEM_ID,                                      15650000
MFA-TR*            REFUND_CHECK_NO,                                     15660000
MFA-TR*            DEPOSIT_CERT_NO,                                     15670000
MFA-TR*            LOCAL_OFFICE,                                        15680000
MFA-TR*            AMT_REFUNDED,                                        15710000
MFA-TR*            REQUEST_DT,                                          15740000
MFA-TR*            CHECK_STATUS_CD,                                     15791000
MFA-TR*            CHECK_ISS_REAS_CD,                                   15792000
MFA-TR*            ORIGINAL_CHECK_NO,                                   15810000
MFA-TR*            RETURNED_REASON,                                     15820000
MFA-TR*            MANUAL_INDICATOR,                                    15830000
MFA-TR*            USER_ID_APPRVD_BY,                                   15840000
MFA-TR*            REFUND_STATUS_DT,                                    15850000
MFA-TR*            DATE_REFUNDED,                                       15851000
MFA-TR*            USER_ID_RQSTED_BY,                                   15860000
MFA-TR*            ACCOUNT_NO,                                          15870000
MFA-TR*            PANEL_NO,                                            15911000
MFA-TR*            ADDRESS_ID,                                          15912000
MFA-TR*            TRANS_HIST_SEQ_NO)                                   15913000
MFA-TR*            COMMENTS)                                            15920000
MFA-TR*         VALUES                                                  15930000
MFA-TR*            (:RN-REFUND-ITEM-ID,                                 15940000
MFA-TR*             :RN-REFUND-CHECK-NO,                                15950000
MFA-TR*             :RN-DEPOSIT-CERT-NO,                                15960000
MFA-TR*             :RN-LOCAL-OFFICE,                                   15970000
MFA-TR*             :RN-AMT-REFUNDED,                                   16000000
MFA-TR*             :RN-REQUEST-DT,                                     16030000
MFA-TR*             :RN-CHECK-STATUS-CD,                                16081000
MFA-TR*             :RN-CHECK-ISS-REAS-CD,                              16082000
MFA-TR*             :RN-ORIGINAL-CHECK-NO,                              16100000
MFA-TR*             :RN-RETURNED-REASON,                                16110000
MFA-TR*             :RN-MANUAL-INDICATOR,                               16120000
MFA-TR*             :RN-USER-ID-APPRVD-BY,                              16130000
MFA-TR*             :RN-REFUND-STATUS-DT,                               16140000
MFA-TR*             :RN-DATE-REFUNDED,                                  16141000
MFA-TR*             :RN-USER-ID-RQSTED-BY,                              16150000
MFA-TR*             :RN-ACCOUNT-NO,                                     16160000
MFA-TR*             :RN-PANEL-NO,                                       16201000
MFA-TR*             :RN-ADDRESS-ID,                                     16202000
MFA-TR*             CURRENT TIMESTAMP)                                  16203000
MFA-TR*             :RN-COMMENTS)                                       16210000
MFA-TR*         END-EXEC.                                               16220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'RN'             TO  WS-DB2-TABLE-ID                 
              MOVE 'INSERT'         TO  WS-DB2-FUNCTION                 
              MOVE SQLCODE          TO  WS-DB2-RETURN-CODE              
              MOVE '109'            TO  WS-DB2-MODULE-ID                
              MOVE '8000'           TO  WS-DB2-PARAGRAPH                
T18165        MOVE RN-ACCOUNT-NO    TO WS-DB2-KEY-1N                    
              MOVE 16               TO  RETURN-CODE                     
              PERFORM 9900-SQL-ERROR THRU 9900-EXIT
           END-IF.                    
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **16370000
      **    8010-UPDATE-CSS-REFUND.                                   **16380000
      **                                                              **16390000
      **    UPDATE COLUMNS ON REFUND TABLE.                           **16400000
      **                                                              **16410000
      **    CALLED BY:  3000-RELEASE-REFUND.                          **16420000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **16430000
       8010-UPDATE-CSS-REFUND.                                          
           EXEC SQL                                                     
                UPDATE CSS_REFUND                                       
                SET AMT_REFUNDED          =  :RN-AMT-REFUNDED,          
                    REFUND_STATUS_DT      =  IIF(TRY_CONVERT(DATE, 
                                                   :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) ),      
                    CHECK_STATUS_CD       =  :RN-CHECK-STATUS-CD,       
T11892              CHECK_ISS_REAS_CD     =  :RN-CHECK-ISS-REAS-CD,     
T11892              DATE_REFUNDED         =  IIF(TRY_CONVERT(DATE, 
                                                      :RN-DATE-REFUNDED
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED) <> 10), CIS.CHAR2DATE(
                                                      :RN-DATE-REFUNDED
              ), CONVERT(DATE, :RN-DATE-REFUNDED) ),         
T11892              COMMENTS              =  :RN-COMMENTS               
                WHERE ACCOUNT_NO          =  :RN-ACCOUNT-NO             
                  AND REFUND_ITEM_ID      =  :RN-REFUND-ITEM-ID         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     16450000
MFA-TR*         UPDATE CSS_REFUND                                       16460000
MFA-TR*         SET AMT_REFUNDED          =  :RN-AMT-REFUNDED,          16470000
MFA-TR*             REFUND_STATUS_DT      =  :RN-REFUND-STATUS-DT,      16480000
MFA-TR*             CHECK_STATUS_CD       =  :RN-CHECK-STATUS-CD,       16481000
MFA-TR*             CHECK_ISS_REAS_CD     =  :RN-CHECK-ISS-REAS-CD,     16482000
MFA-TR*             DATE_REFUNDED         =  :RN-DATE-REFUNDED,         16483000
MFA-TR*             COMMENTS              =  :RN-COMMENTS               16484000
MFA-TR*         WHERE ACCOUNT_NO          =  :RN-ACCOUNT-NO             16490000
MFA-TR*           AND REFUND_ITEM_ID      =  :RN-REFUND-ITEM-ID         16500000
MFA-TR*    END-EXEC.                                                    16510000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 4 TO RETURN-CODE                               
                    PERFORM 9999-BAIL-OUT                               
               WHEN OTHER                                               
                    MOVE 'RN'             TO  WS-DB2-TABLE-ID           
                    MOVE 'UPDATE'         TO  WS-DB2-FUNCTION           
                    MOVE SQLCODE          TO  WS-DB2-RETURN-CODE        
                    MOVE '109'            TO  WS-DB2-MODULE-ID          
                    MOVE '8010'           TO  WS-DB2-PARAGRAPH          
                    MOVE RN-ACCOUNT-NO    TO  WS-DB2-KEY-1N             
                    MOVE RN-REFUND-ITEM-ID TO WS-DB2-KEY-2N             
                    MOVE 16               TO  RETURN-CODE               
                    PERFORM 9900-SQL-ERROR THRU 9900-EXIT               
           END-EVALUATE.                                                
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **16732701
T15199 8015-UPDATE-AMOUNT-DATE.                                         
T15199     EXEC SQL                                                     
T15199          UPDATE CSS_REFUND                                       
T15199          SET AMT_REFUNDED       = :WS-REFUND-COMPARE,            
T21381              REQUEST_DT         = IIF(TRY_CONVERT(DATE, 
                                                         :RN-REQUEST-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT
              ) <> 0) OR (LEN(:RN-REQUEST-DT) <> 10), CIS.CHAR2DATE(
                                                         :RN-REQUEST-DT
              ), CONVERT(DATE, :RN-REQUEST-DT) )                 
T15199          WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 
T15199            AND REFUND_ITEM_ID   = :RN-REFUND-ITEM-ID             
T15199     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     16733501
MFA-TR*         UPDATE CSS_REFUND                                       16733601
MFA-TR*         SET AMT_REFUNDED       = :WS-REFUND-COMPARE,                    
MFA-TR*             REQUEST_DT         = :RN-REQUEST-DT                         
MFA-TR*         WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 16733801
MFA-TR*           AND REFUND_ITEM_ID   = :RN-REFUND-ITEM-ID             16733903
MFA-TR*    END-EXEC.                                                    16734601

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T21381     MOVE RN-REQUEST-DT TO WS-RELEASE-DATE.                       
      *                                                                         
T15199     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T15199     EVALUATE WS-ACTIVE-RETURN-CODE                               
T15199         WHEN SUCCESSFUL-CALL                                     
T15199              CONTINUE                                            
T15199         WHEN NOT-FOUND                                           
T15199              MOVE 4 TO RETURN-CODE                               
T15199              PERFORM 9999-BAIL-OUT                               
T15199         WHEN OTHER                                               
T15199              MOVE 'RN'             TO  WS-DB2-TABLE-ID           
T15199              MOVE 'UPDATE'         TO  WS-DB2-FUNCTION           
T15199              MOVE SQLCODE          TO  WS-DB2-RETURN-CODE        
T15199              MOVE '109'            TO  WS-DB2-MODULE-ID          
T15199              MOVE '8015'           TO  WS-DB2-PARAGRAPH          
T15199              MOVE RN-ACCOUNT-NO    TO  WS-DB2-KEY-1N             
T15199              MOVE RN-REFUND-ITEM-ID TO WS-DB2-KEY-2N             
T15199              MOVE 16               TO  RETURN-CODE               
T15199              PERFORM 9900-SQL-ERROR THRU 9900-EXIT               
T15199     END-EVALUATE.                                                
      *                                                                         
T15199 8015-EXIT.                                                       
T15199     EXIT.                                                        
      *                                                                         
T15199 8016-UPDATE-AMOUNT-ONLY.                                         
T15199     EXEC SQL                                                     
T15199          UPDATE CSS_REFUND                                       
T15199          SET AMT_REFUNDED          =  :RN-AMT-REFUNDED           
T15199          WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 
T15199            AND REFUND_ITEM_ID   = :RN-REFUND-ITEM-ID             
T15199     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T15199     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T15199     EVALUATE WS-ACTIVE-RETURN-CODE                               
T15199         WHEN SUCCESSFUL-CALL                                     
T15199              CONTINUE                                            
T15199         WHEN NOT-FOUND                                           
T15199              MOVE 4 TO RETURN-CODE                               
T15199              PERFORM 9999-BAIL-OUT                               
T15199         WHEN OTHER                                               
T15199              MOVE 'RN'             TO  WS-DB2-TABLE-ID           
T15199              MOVE 'UPDATE'         TO  WS-DB2-FUNCTION           
T15199              MOVE SQLCODE          TO  WS-DB2-RETURN-CODE        
T15199              MOVE '109'            TO  WS-DB2-MODULE-ID          
T15199              MOVE '8016'           TO  WS-DB2-PARAGRAPH          
T15199              MOVE RN-ACCOUNT-NO    TO  WS-DB2-KEY-1N             
T15199              MOVE RN-REFUND-ITEM-ID TO WS-DB2-KEY-2N             
T15199              MOVE 16               TO  RETURN-CODE               
T15199              PERFORM 9900-SQL-ERROR THRU 9900-EXIT               
T15199     END-EVALUATE.                                                
      *                                                                         
T15199 8016-EXIT.                                                       
T15199     EXIT.                                                        
      *                                                                         
T18023 8017-UPDATE-RELEASE-ONLY.                                        
T18023     EXEC SQL                                                     
T18023          UPDATE CSS_REFUND                                       
T18023          SET REQUEST_DT         =  IIF(TRY_CONVERT(DATE, 
                                                         :RN-REQUEST-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT
              ) <> 0) OR (LEN(:RN-REQUEST-DT) <> 10), CIS.CHAR2DATE(
                                                         :RN-REQUEST-DT
              ), CONVERT(DATE, :RN-REQUEST-DT) )                
T18023          WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 
T18023            AND REFUND_ITEM_ID   = :RN-REFUND-ITEM-ID             
T18023     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     16733501
MFA-TR*         UPDATE CSS_REFUND                                       16733601
MFA-TR*         SET REQUEST_DT         =  :RN-REQUEST-DT                16733701
MFA-TR*         WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 16733801
MFA-TR*           AND REFUND_ITEM_ID   = :RN-REFUND-ITEM-ID             16733903
MFA-TR*    END-EXEC.                                                    16734601

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T18023     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T18023     EVALUATE WS-ACTIVE-RETURN-CODE                               
T18023         WHEN SUCCESSFUL-CALL                                     
T18023              CONTINUE                                            
T18023         WHEN NOT-FOUND                                           
T18023              MOVE 4 TO RETURN-CODE                               
T18023              PERFORM 9999-BAIL-OUT                               
T18023         WHEN OTHER                                               
T18023              MOVE 'RN'             TO  WS-DB2-TABLE-ID           
T18023              MOVE 'UPDATE'         TO  WS-DB2-FUNCTION           
T18023              MOVE SQLCODE          TO  WS-DB2-RETURN-CODE        
T18023              MOVE '109'            TO  WS-DB2-MODULE-ID          
T18023              MOVE '8017'           TO  WS-DB2-PARAGRAPH          
T18023              MOVE RN-ACCOUNT-NO    TO  WS-DB2-KEY-1N             
T18023              MOVE RN-REFUND-ITEM-ID TO WS-DB2-KEY-2N             
T18023              MOVE 16               TO  RETURN-CODE               
T18023              PERFORM 9900-SQL-ERROR THRU 9900-EXIT               
T18023     END-EVALUATE.                                                
T18023 8017-EXIT.                                                       
T18023     EXIT.                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **16736801
      **    8020-DELETE-REFUND.                                       **16736901
      **                                                              **16737001
      **    DELETE ROW FROM REFUND TABLE.                             **16737101
      **                                                              **16737201
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **16737301
       8020-DELETE-REFUND.                                              
           EXEC SQL                                                     
                DELETE FROM CSS_REFUND                                  
                WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 
                  AND REQUEST_DT       = IIF(TRY_CONVERT(DATE, 
                                                         :RN-REQUEST-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT
              ) <> 0) OR (LEN(:RN-REQUEST-DT) <> 10), CIS.CHAR2DATE(
                                                         :RN-REQUEST-DT
              ), CONVERT(DATE, :RN-REQUEST-DT) )                 
                  AND CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD            
                  AND PANEL_NO         = :RN-PANEL-NO                   
                  AND MANUAL_INDICATOR = :RN-MANUAL-INDICATOR           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     16737501
MFA-TR*         DELETE FROM CSS_REFUND                                  16737601
MFA-TR*         WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 16737701
MFA-TR*           AND REQUEST_DT       = :RN-REQUEST-DT                 16737801
MFA-TR*           AND CHECK_STATUS_CD  = :RN-CHECK-STATUS-CD            16737901
MFA-TR*           AND PANEL_NO         = :RN-PANEL-NO                   16738001
MFA-TR*           AND MANUAL_INDICATOR = :RN-MANUAL-INDICATOR           16738101
MFA-TR*    END-EXEC.                                                    16738201

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 4 TO RETURN-CODE                               
                    PERFORM 9999-BAIL-OUT                               
               WHEN OTHER                                               
                    MOVE 'RN'             TO  WS-DB2-TABLE-ID           
                    MOVE 'UPDATE'         TO  WS-DB2-FUNCTION           
                    MOVE SQLCODE          TO  WS-DB2-RETURN-CODE        
                    MOVE '109'            TO  WS-DB2-MODULE-ID          
                    MOVE '8010'           TO  WS-DB2-PARAGRAPH          
                    MOVE RN-ACCOUNT-NO    TO  WS-DB2-KEY-1N             
                    MOVE RN-REFUND-ITEM-ID TO WS-DB2-KEY-2N             
                    MOVE 16               TO  RETURN-CODE               
                    PERFORM 9900-SQL-ERROR THRU 9900-EXIT               
           END-EVALUATE.                                                
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT216 8021-CANCEL-REFUND.                                              
ACT216     EXEC SQL                                                     
ACT216          UPDATE CSS_REFUND                                       
ACT216          SET CHECK_STATUS_CD    =  :RN-CHECK-STATUS-CD           
ACT216            , COMMENTS           =  :RN-COMMENTS                  
ACT216          WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 
ACT216            AND REFUND_ITEM_ID   = :RN-REFUND-ITEM-ID             
ACT216     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT216     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT216     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT216         WHEN SUCCESSFUL-CALL                                     
ACT216              CONTINUE                                            
ACT216         WHEN NOT-FOUND                                           
ACT216              MOVE 4 TO RETURN-CODE                               
ACT216              PERFORM 9999-BAIL-OUT                               
ACT216         WHEN OTHER                                               
ACT216              MOVE 'RN'             TO  WS-DB2-TABLE-ID           
ACT216              MOVE 'UPDATE'         TO  WS-DB2-FUNCTION           
ACT216              MOVE SQLCODE          TO  WS-DB2-RETURN-CODE        
ACT216              MOVE '109'            TO  WS-DB2-MODULE-ID          
ACT216              MOVE '8017'           TO  WS-DB2-PARAGRAPH          
ACT216              MOVE RN-ACCOUNT-NO    TO  WS-DB2-KEY-1N             
ACT216              MOVE RN-REFUND-ITEM-ID TO WS-DB2-KEY-2N             
ACT216              MOVE 16               TO  RETURN-CODE               
ACT216              PERFORM 9900-SQL-ERROR THRU 9900-EXIT               
ACT216     END-EVALUATE.                                                
ACT216 8021-EXIT.                                                       
ACT216     EXIT.                                                        
      *                                                                         
ACT216*COMPLETE WQS                                                             
ACT216 8025-UPDATE-WQ.                                                  
ACT216                                                                  
ACT216     EXEC SQL                                                     
ACT216          UPDATE CSS_WQ_ITEMS                                     
ACT216          SET COMPLETE_DATE      =  CIS.CURRENT$TIMESTAMP()             
ACT216             ,STATUS             = 'C'                            
ACT216          WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 
ACT216            AND CATEGORY_ID     IN (34,35,62,63,556)              
ACT216     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     16733501
MFA-TR*         UPDATE CSS_WQ_ITEMS                                     16733601
MFA-TR*         SET COMPLETE_DATE      =  CURRENT TIMESTAMP             16733701
MFA-TR*            ,STATUS             = 'C'                                    
MFA-TR*         WHERE ACCOUNT_NO       = :RN-ACCOUNT-NO                 16733801
MFA-TR*           AND CATEGORY_ID     IN (34,35,62,63,556)              16733903
MFA-TR*    END-EXEC.                                                    16734601

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT216                                                                  
ACT216     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT216                                                                  
ACT216     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT216         WHEN SUCCESSFUL-CALL                                     
ACT216         WHEN NOT-FOUND                                           
ACT216              CONTINUE                                            
ACT216         WHEN OTHER                                               
ACT216              MOVE 'WQ'             TO  WS-DB2-TABLE-ID           
ACT216              MOVE 'UPDATE'         TO  WS-DB2-FUNCTION           
ACT216              MOVE SQLCODE          TO  WS-DB2-RETURN-CODE        
ACT216              MOVE '109'            TO  WS-DB2-MODULE-ID          
ACT216              MOVE '8025'           TO  WS-DB2-PARAGRAPH          
ACT216              MOVE RN-ACCOUNT-NO    TO  WS-DB2-KEY-1N             
ACT216              MOVE 16               TO  RETURN-CODE               
ACT216              PERFORM 9900-SQL-ERROR THRU 9900-EXIT               
ACT216     END-EVALUATE.                                                
ACT216                                                                  
ACT216 8025-EXIT.                                                       
ACT216     EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **16740401
      **    8100-WRITE-WK03.                                          **16741001
      **                                                              **16750000
      **    UPDATE COLUMNS ON REFUND TABLE.                           **16760000
      **                                                              **16770000
      **    CALLED BY:  6430-CREATE-FIOWK03.                          **16780000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **16790000
                                                                        
       8100-WRITE-WK03.                                                 
           ADD 1 TO WS-WK03-COUNT                                       
T13536     IF WS-WK03-COUNT > 5000                                      
              MOVE 'WK03 HOLD TABLE OVERFLOW'                           
                TO WS-MISC-MSG-TEXT                                     
PCR629        MOVE +137 TO WS-MISC-CATEGORY                             
              MOVE +24 TO WS-MISC-MSG-LEN                               
              MOVE 16 TO RETURN-CODE                                    
              PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
           ELSE                                                         
              SET WK03-INDX TO WS-WK03-COUNT                            
              MOVE FIOWK03 TO WS-HOLD-WK03-DATA (WK03-INDX)             
              INITIALIZE FIOWK03                                        
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*****************************************************************16912000
      *                                                                *16920000
      * 9900-SQL-ERROR.                                                *16930000
      *                                                                *16940000
      * SQL ERROR PROCESSING FOR WORK QUEUE.                           *16950000
      *                                                                *16960000
      ******************************************************************16970000
       9900-SQL-ERROR.                                                  
                                                                        
           IF LS-CURR-WQ-ITEM EQUAL 50                                  
               DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                
               DISPLAY 'PROCESSING TERMINATED'                          
               MOVE 16                 TO RETURN-CODE                   
           ELSE                                                         
               ADD 1                   TO LS-CURR-WQ-ITEM               
               SET WS-BILL-WQ-INDX     TO LS-CURR-WQ-ITEM               
           END-IF.                                                      
                                                                        
           MOVE WS-DATABASE-EXCEPTION  TO                               
                WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)           
                                                                        
           COMPUTE WS-START-POS                                         
                   EQUAL WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1       
           MOVE WS-SQL-ERROR-TXT-WQ    TO                               
                WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)   
           ADD WS-SQL-ERROR-TXT-LEN-WQ TO                               
               WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                    
                                                                        
           PERFORM 9999-BAIL-OUT.                                       
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*****************************************************************17230000
      *                                                                *17240000
      * 9910-MISC-ERROR.                                               *17250000
      *                                                                *17260000
      * MISCELLANEOUS ERROR PROCESSING FOR WORK QUEUE.                 *17270000
      *                                                                *17280000
      ******************************************************************17290000
       9910-MISC-ERROR.                                                 
           IF LS-CURR-WQ-ITEM = 50                                      
              DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                 
              DISPLAY 'PROCESSING TERMINATED'                           
              MOVE 16 TO RETURN-CODE                                    
           ELSE                                                         
              ADD 1 TO LS-CURR-WQ-ITEM                                  
              SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
                                                                        
              MOVE WS-MISCELLANEOUS-MESSAGE                             
                TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
                                                                        
              MOVE WS-BILL-NO-BG (WS-BILLING-INDX) TO WS-BILL-NO-WQ     
              MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)               
                TO  WS-CODE-UTIL-TYPE-WQ                                
              MOVE WS-IC-NO-BG (WS-BILLING-INDX)  TO  WS-IC-NO-WQ       
              MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)                 
                TO  WS-RATE-PLAN-NO-WQ                                  
                                                                        
              COMPUTE WS-START-POS                                      
                = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1              
              MOVE WS-SUPPLEMENTAL-TXT-WQ                               
                TO WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:)
              ADD WS-SUPPLEMENTAL-TXT-LEN-WQ                            
                TO WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX)                 
           END-IF.                                                      
                                                                        
           PERFORM 9999-BAIL-OUT.                                       
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **17610000
      **    9999-BAIL-OUT                                             **17620000
      **                                                              **17630000
      **    TO ABEND PROGRAM                                          **17640000
      **                                                              **17650000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **17660000
       9999-BAIL-OUT.                                                   
           EXIT PROGRAM.                                                
