       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     SCSCA106.                                        
      ****************************************************************  00030000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00040000
      **                     PRICE WATERHOUSE                        ** 00050000
      **                                                             ** 00060000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00070000
      **                                                             ** 00080000
      ***************************************************************** 00090000
      **               P R O G R A M  S U M M A R Y                  ** 00100000
      **                                                             ** 00110000
      **                                                             ** 00120000
      ***************************************************************** 00130000
      **                                                             ** 00140000
      **              PROGRAM  MODIFICATION  LOG                     ** 00150000
      **                                                             ** 00160000
      **    DATE    INITIALS  REASON                                 ** 00170000
      **  ________  ________  ______                                 ** 00180000
      **                                                             ** 00190000
      **   04/30/97   CSG     INITIALIZE CPD00010 FIELDS.            ** 00200000
T10759**   05/01/97   CSG     MOVE 'P' TO AR-AGE.                    ** 00210000
T13536**   11/13/97   CSG     INCREASE SIZE OF WK03 HOLD AREA.       ** 00220000
CWSCHG**   01/05/98    CSG    CHANGE CWS10000 AND CWS10001 TO        ** 00230000
      **                      CWS1000A/CWS1000B AND CWS1001A/CWS1001B** 00240000
T16786**   09/04/98   JYL     REMOVED SEARCH STATEMENT IN PARA-0000. ** 00250000
T16786**                      THE SAME SEARCH STATEMENT WAS PERFORMED** 00260000
T16786**                      IN THE CALLING PROGRAM SCSCA108.       ** 00270000
      **                                                             ** 00280000
T20631**   03/01/01   VIJAY   ADDED JOURNAL COPYBOOK  CJF00102       ** 00290000
T24024**   04/30/01   COVANSYS CHANGE MADE TO INCLUDE RC 12 INORDER  ** 00300000
T24024**                       CONTINUE PROCESSING FOR NEXT ACCTS    ** 00310000
C23235**   07/14/01   MDJ     ADD DCLGEN TBUTLENV FOR CPD0010B.      ** 00320000
C26130**   06/12/02   SRIDEVI ADDED DCLGEN TBMNHIST & TBMNHDT FOR    ** 00330000
C26130**                      CPD0010B.                              ** 00340000
T27925**   03/19/03  COVANSYS CHANGED FIELDS DEFINED AS 9(07) TO 9(11)* 00350000
T31499**   02/08/05  VIJAY    UNSET WS-CODE-CIA(CDP IN CSS_ACCOUNT)   * 00360000
      **                      WHEN TOTAL CIA IS APPLIED.              * 00370000
      **                NOTE: FOR BOTH LIHEAP AND CIA MONEY WS-CODE-CIA 00380000
      **                      USED. I DID NOT SEE USING WS-CODE-LIEAP   00390000
      **                      FOR LIHEAP MONEY(ITEMD-ID =2 IN AR CNTL)  00400000
      **                      ANY WHERE.                                00410000
P00097**   01/26/09  VP94820 INCREASE NUMBER OF ACTIVE DFA/CNT AND   ** 00420000
P00097**                     FORECASTED CREDIT ACTIONS  ALLOWED ON AN** 00430000
P00097**                     ACCOUNT TO 50.                          ** 00440000
A03730**   09/15/09  MN90523 REMOVED DATA ITEMS RELATED TO TABLE RA  ** 00441000
A05460**   05/03/16  MC95456 REMOVED DCLGEN FOR CSS_WQ_ITEMS_MF.     ** 00441100
A05460**   05/03/16  MR7E794 ADD WQ CREATED BY FIELD IN PARA 9910,   ** 00441200
A05460**             ACT162  9990.                                   ** 00441300
ACT284*    09/29/16  VIJAY   SET INDEXES TO 1 TO AVOID EXCEPTIONS IN    00441401
ACT284*    A05460            MFES ENVIRONMENT.                          00441500
      ***************************************************************** 00450000
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00460000
      **                                                             ** 00470000
      **  0000         MODULE CONTROL                                ** 00480000
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00490000
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00500000
      **  2000 - 4999  DETAIL LOGIC                                  ** 00510000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00520000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00530000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00540000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00550000
      **                                                             ** 00560000
      ***************************************************************** 00570000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCSCA106'.
MSQ017     COPY MFASQLM.
       01  WS-START                   PIC X(40)                         
           VALUE 'WORKING STORAGE FOR SCSCA106 STARTS HERE'.            
                                                                        
      *01  WS-WORK-VARIABLES.                                           00650000
      **     THE WORK VARIABLE AREA IS USED FOR TRANSIENT DATA. IT   ** 00660000
      **     IS INITIALIZED ON EACH CALL TO THE SUBROUTINE.          ** 00670000
      **     THE OTHER WORK AREAS ARE INITIALIZED UNDER PROGRAM      ** 00680000
      **     CONTROL.  ADD ANY NEW DATA FIELDS ACCORDINGLY.          ** 00690000
      **                                                             ** 00700000
      /**************************************************************** 00710000
      **                                                             ** 00720000
       01  WS-CONSTANTS.                                                
           05  WS-ADJUST                   PIC X(1)    VALUE 'A'.       
           05  WS-INDIRECT-JRNL            PIC X(1)    VALUE 'A'.       
           05  WS-A                        PIC X(1)    VALUE 'A'.       
           05  WS-BATCH                    PIC X(1)    VALUE 'B'.       
           05  WS-C                        PIC X(1)    VALUE 'C'.       
           05  WS-DELETE                   PIC X(1)    VALUE 'D'.       
           05  WS-YES                      PIC X(1)    VALUE 'Y'.       
           05  WS-NO                       PIC X(1)    VALUE 'N'.       
           05  WS-BAT                      PIC X(03)   VALUE 'BAT'.     
           05  WS-PGRMNAME                 PIC X(08)   VALUE 'SCSCA106'.
           05  WS-SYSTEM                   PIC X(07)   VALUE 'SYSTEM '. 
           05  WS-BILL                     PIC X(04)   VALUE 'BILL'.    
           05  WS-101                      PIC S9(05)  COMP-3           
                                                       VALUE +00101.    
           05  WS-MODULE-ID                PIC X(03)   VALUE '106'.     
      *                                                                 00890000
       01  WS-CASH-DRAWER.                                              
           05  WS-CD-COMPANY-NO            PIC X(02) VALUE '01'.        
           05  WS-CD-LOCAL-OFFICE          PIC X(03) VALUE SPACES.      
           05  WS-CD-REPORT-NO             PIC X(03) VALUE '997'.       
           05  WS-CD-REPORT-DATE           PIC X(10) VALUE SPACES.      
           05  WS-CASH-DRAWER-ID           PIC S9(04) COMP VALUE 9999.  
      *                                                                 00960000
       01  WS-COUNTERS.                                                 
           05  WS-CURRENT-WQ-ITEM          PIC S9(04)  COMP VALUE ZERO. 
           05  WS-START-POS                PIC S9(04)  COMP VALUE ZERO. 
      *                                                                 01000000
       01  WS-TEMP-VARIABLES.                                           
           05  WS-DATE-TEMP                PIC X(10).                   
           05  WS-DATE-TEMP-2              PIC X(10).                   
COB305     05 WS-AMOUNT-TEMP        PIC S9(11)V99 COMP-3 VALUE 0.        
COB305     05 WS-AMOUNT-TEMP2        PIC S9(07)V99 COMP-3 VALUE 0.        
T27925     05  WS-DETAIL-END-BAL           PIC S9(11)V99  VALUE ZERO.   
T27925     05  WS-DETAIL-END-AR-BAL        PIC S9(11)V99  VALUE ZERO.   
           05  WS-DATE-1-YEAR-AGO          PIC X(10).                   
           05  WS-CURRENT-DATE             PIC X(10).                   
           05  WS-CURRENT-TIMESTAMP        PIC X(26).                   
           05  WS-TEMP-DT                  PIC X(10).                   
           05  WS-TEMP-TIMESTAMP           PIC X(29).                   
           05  WS-DATE-ORIG-PYMT-IND       PIC S9(4) COMP.              
           05  RS-RETURN-CODE              PIC S9(4) COMP.              
T16786*    05  WS-CIA-CREDIT               PIC S9(9)V99 COMP-3.         01150000
T16786*    05  WS-CIA-LIHEAP-CREDIT        PIC S9(9)V99 COMP-3.         01160000
      *                                                                 01170000
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-1               PIC S9(04) COMP.             
           05  WS-NULL-IND-2               PIC S9(04) COMP.             
           05  WS-NULL-IND-3               PIC S9(04) COMP.             
           05  WS-NULL-IND-4               PIC S9(04) COMP.             
           05  WS-NULL-IND-5               PIC S9(04) COMP.             
           05  WS-NULL-IND-6               PIC S9(04) COMP.             
           05  WS-NULL-IND-7               PIC S9(04) COMP.             
           05  WS-NULL-IND-8               PIC S9(04) COMP.             
      *                                                                 01270000
       01  WS-MISC.                                                     
           05  PROGRAM-NAME        PIC X(08) VALUE 'SCSCA106'.          
           05  WS-6700-CALLED      PIC X(01) VALUE 'N'.                 
           05  WS-WRITE-WK03       PIC X(01) VALUE 'Y'.                 
      *                                                                 01320000
T24024     05  WS-ERR-MSG.                                              
T24024         10 FILLER           PIC X(13) VALUE 'EXCEPTION IN '.     
T24024         10 WS-PROGRAM-ID    PIC X(04) VALUE SPACES.              
T24024         10 WS-PARA-ID       PIC X(04) VALUE SPACES.              
T24024         10 FILLER           PIC X(08) VALUE ' DUE TO '.          
T24024         10 WS-MESSAGE       PIC X(31) VALUE SPACES.              
      *                                                                 01390000
      /**************************************************************** 01400000
      **     PUT ANY PROGRAM SWITCH VARIABLES YOU NEED HERE.  IF     ** 01410000
      **     POSSIBLE, INCLUDE AT LEAST TWO CONDITION NAMES. IN THE  ** 01420000
      **     PROCEDURE DIVISION, USE "SET CONDITION-NAME TO TRUE"    ** 01430000
      **     RATHER THAN "MOVE 'Y' TO INDICATOR-VARIABLE-NAME"       ** 01440000
      **                                                             ** 01450000
       01  WS-SWITCHES-AND-INDICATORS.                                  
           05  WS-EXCEPTION-INDICATOR      PIC X(1).                    
               88  NO-EXCEPTIONS           VALUE '0'.                   
               88  EXCEPTION-ENCOUNTERED   VALUE '1'.                   
                                                                        
      /**************************************************************** 01510000
      **     WORKING STORAGE FOR WQ MESSAGES PERTAINING TO           ** 01520000
      **     SQL ERRORS AND OTHER PROGRAM PROBLEMS.                  ** 01530000
      **                                                             ** 01540000
      ***************************************************************** 01550000
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER                  PIC S9(04)  COMP.            
               10  FILLER                  PIC X(01)   VALUE 'N'.       
               10  FILLER                  PIC X(01)   VALUE '4'.       
               10  FILLER                  PIC S9(04)  COMP VALUE +29.  
               10  FILLER                  PIC X(30)   VALUE            
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-MISCELLANEOUS-MESSAGE.                                
T24024         10  FILLER                  PIC S9(04)  COMP VALUE +137. 
               10  FILLER                  PIC X(01)   VALUE 'N'.       
               10  FILLER                  PIC X(01)   VALUE '4'.       
               10  WS-MISC-MSG-LEN         PIC S9(04)  COMP VALUE +60.  
               10  WS-MISC-MSG-TEXT        PIC X(60)   VALUE SPACES.    
                                                                        
      /*****************************************************************01710000
      *                                                                *01720000
      *  WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS              *01730000
      *                                                                *01740000
      ******************************************************************01750000
      /*****   SQL WORK VARIABLES                                       01760000
       COPY CWS00303.                                                   01770000
                                                                        
      /*****   WQ WORKING STORAGE                                       01790000
       COPY CWS0070B.                                                   01800000
                                                                        
      /*****                                                            01820000
       COPY CWS00027.                                                   01830000
                                                                        
      /*****                                                            01850000
       COPY CWS00010.                                                   01860000
                                                                        
      /*****  WORKING STORAGE FOR CODES-DATA-PRESENT                    01880000
       COPY CWS00056.                                                   01890000
                                                                        
      /***** WORKING STORAGE FOR PAYMENT JOURNAL                        01910000
       COPY CJF00101.                                                   01920000
T20631 COPY CJF00102.                                                   01930000
                                                                        
PCR072/***** WORKING STORAGE FOR JOURNAL                                01950000
PCR072 COPY CJF00105.                                                   01960000
                                                                        
      /***** WORKING STORAGE FOR REFUND                                 01980000
       COPY CWS00131.                                                   01990000
                                                                        
      /*****                                                            02010000
           EXEC SQL                                                     02020000
               INCLUDE CWS00013                                         02030000
           END-EXEC.                                                    02040000
                                                                        
      /*****                                                            02060000
           EXEC SQL                                                     02070000
               INCLUDE CWS00073                                         02080000
           END-EXEC.                                                    02090000
                                                                        
      /*****                                                            02110000
           EXEC SQL                                                     02120000
               INCLUDE CWS00017                                         02130000
           END-EXEC.                                                    02140000
                                                                        
      /*****                                                            02160000
           EXEC SQL                                                     02170000
               INCLUDE CWS00004                                         02180000
           END-EXEC.                                                    02190000
                                                                        
      /*****                                                            02210000
           EXEC SQL                                                     02220000
               INCLUDE CWS00008                                         02230000
           END-EXEC.                                                    02240000
                                                                        
      /*****                                                            02260000
           EXEC SQL                                                     02270000
               INCLUDE CWS00007                                         02280000
           END-EXEC.                                                    02290000
                                                                        
                                                                        
       COPY FIOWK03.                                                    02320000
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR SCSCA106 START HERE '.               
      /*****************************************************************02360000
      *   TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS      *02370000
      *   (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM      *02380000
      *   WILL ALWAYS BE SQLCA.                                        *02390000
      ******************************************************************02400000
      /***** SQL COMMUNICATIONS AREA                                    02410000
           EXEC SQL                                                     02420000
               INCLUDE SQLCA                                            02430000
           END-EXEC.                                                    02440000
      /***** CSS_ACCOUNT                                                02450000
           EXEC SQL                                                     02460000
               INCLUDE TBACCT                                           02470000
           END-EXEC.                                                    02480000
      /***** CSS_PREMISE                                                02490000
           EXEC SQL                                                     02500000
               INCLUDE TBPREM                                           02510000
           END-EXEC.                                                    02520000
      /***** CSS_CUSTOMER                                               02530000
           EXEC SQL                                                     02540000
               INCLUDE TBCUST                                           02550000
           END-EXEC.                                                    02560000
      /***** CSS_AR_CNTL                                                02570000
           EXEC SQL                                                     02580000
               INCLUDE TBARCNTL                                         02590000
           END-EXEC.                                                    02600000
      /***** CSS_AR_TRANS_HIST                                          02610000
           EXEC SQL                                                     02620000
               INCLUDE TBARHIST                                         02630000
           END-EXEC.                                                    02640000
      /***** CSS_AR_TRN_HST_DET                                         02650000
           EXEC SQL                                                     02660000
               INCLUDE TBARHDT                                          02670000
           END-EXEC.                                                    02680000
      /***** CSS_DEP_ON_HAND                                            02690000
           EXEC SQL                                                     02700000
               INCLUDE TBDEPHND                                         02710000
           END-EXEC.                                                    02720000
      /***** CSS_DEP_PAY_HST                                            02730000
           EXEC SQL                                                     02740000
               INCLUDE TBDEPHST                                         02750000
           END-EXEC.                                                    02760000
      /***** CSS_BATCH_JRNL                                             02770000
           EXEC SQL                                                     02780000
               INCLUDE TBBTJRNL                                         02790000
           END-EXEC.                                                    02800000
      /***** CSS_MODEL_SQL                                              02810000
           EXEC SQL                                                     02820000
               INCLUDE TBMODEL                                          02830000
           END-EXEC.                                                    02840000
      /***** CSS_AR_PMT_PRTY                                            02850000
           EXEC SQL                                                     02860000
               INCLUDE TBARPMT                                          02870000
           END-EXEC.                                                    02880000
      /***** CSS_DFA_ACCT                                               02890000
           EXEC SQL                                                     02900000
               INCLUDE TBDFAACT                                         02910000
           END-EXEC.                                                    02920000
      /***** CSS_CONTRACT                                               02930000
           EXEC SQL                                                     02940000
               INCLUDE TBCNTRCT                                         02950000
           END-EXEC.                                                    02960000
      /***** CSS_RECONNECT                                              02970000
           EXEC SQL                                                     02980000
               INCLUDE TBRECNCT                                         02990000
           END-EXEC.                                                    03000000
      /***** CSS_DFA_RECVBL                                             03010000
           EXEC SQL                                                     03020000
               INCLUDE TBDFARCV                                         03030000
           END-EXEC.                                                    03040000
      /***** CSS_USER_PROFILE                                           03090000
           EXEC SQL                                                     03100000
               INCLUDE TBUSRPRF                                         03110000
           END-EXEC.                                                    03120000
      /***** CSS_BUDGET_HIST                                            03130000
           EXEC SQL                                                     03140000
               INCLUDE TBBGTHST                                         03150000
           END-EXEC.                                                    03160000
      /***** CSS_BUDGET_PLAN                                            03210000
           EXEC SQL                                                     03220000
               INCLUDE TBBGTPLN                                         03230000
           END-EXEC.                                                    03240000
      /***** CSS_CREDIT_PROFILE                                         03250000
           EXEC SQL                                                     03260000
               INCLUDE TBCRPROF                                         03270000
           END-EXEC.                                                    03280000
      /***** CSS_LIEAP                                                  03290000
           EXEC SQL                                                     03300000
               INCLUDE TBLIEAP                                          03310000
           END-EXEC.                                                    03320000
TP3228/***** CSS_PROJ_SHARE                                             03330000
TP3228     EXEC SQL                                                     03340000
TP3228         INCLUDE TBPRJSHR                                         03350000
TP3228     END-EXEC.                                                    03360000
C26130/***** CSS_MNT_TRANS_HIST                                         03370000
C26130     EXEC SQL                                                     03380000
C26130        INCLUDE TBMNHIST                                          03390000
C26130     END-EXEC.                                                    03400000
C26130/***** CSS_MT_TRN_HST_DET                                         03410000
C26130     EXEC SQL                                                     03420000
C26130        INCLUDE TBMNHDT                                           03430000
C26130     END-EXEC.                                                    03440000
PCR072******************************************************************03450000
PCR072*    CSS_DELINQUENCY                                              03460000
PCR072******************************************************************03470000
PCR072     EXEC SQL                                                     03480000
PCR072         INCLUDE TBDELQ                                           03490000
PCR072     END-EXEC.                                                    03500000
HPCCDM*EJECT                                                            03510000
PCR072******************************************************************03520000
PCR072*    CSS_CONNECT_CHRG                                             03530000
PCR072******************************************************************03540000
PCR072     EXEC SQL                                                     03550000
PCR072         INCLUDE TBCCCHRG                                         03560000
PCR072     END-EXEC.                                                    03570000
HPCCDM*EJECT                                                            03580000
PCR072******************************************************************03590000
PCR072*    CSS_RECONNECT_CHRG                                           03600000
PCR072******************************************************************03610000
PCR072     EXEC SQL                                                     03620000
PCR072         INCLUDE TBRCNCHR                                         03630000
PCR072     END-EXEC.                                                    03640000
HPCCDM*EJECT                                                            03650000
PCR072******************************************************************03660000
PCR072*    CSS_LOCAL_OFFICE                                             03670000
PCR072******************************************************************03680000
PCR072     EXEC SQL                                                     03690000
PCR072         INCLUDE TBLOCOFC                                         03700000
PCR072     END-EXEC.                                                    03710000
C23235******************************************************************03720000
C23235*    CSS_UTIL_ENVRNMT                                             03730000
C23235******************************************************************03740000
C23235                                                                  
C23235     EXEC SQL                                                     03760000
C23235         INCLUDE TBUTLENV                                         03770000
C23235     END-EXEC.                                                    03780000
HPCCDM*EJECT                                                            03790000
      /                                                                 03800000
                                                                        
       LINKAGE SECTION.                                                 
      /*****   LS-PCSCA100-COMM-AREA                                    03830000
           EXEC SQL                                                     03840000
               INCLUDE CWS0024B                                         03850000
           END-EXEC.                                                    03860000
      /*****   BILL EXTRACT (BE00)                                      03870000
           EXEC SQL                                                     03880000
CWSCHG         INCLUDE CWS1000A                                         03890000
           END-EXEC.                                                    03900000
CWSCHG     EXEC SQL                                                     03910000
CWSCHG         INCLUDE CWS1000B                                         03920000
CWSCHG     END-EXEC.                                                    03930000
      /*****   ACCOUNTS FILE (DB07)                                     03940000
           COPY FIODB07.                                                03950000
      /*****   WORKING STORAGE FOR G/L MNEMONICS                        03960000
           COPY CWS00061.                                               03970000
      /                                                                 03980000
       01  WS-HOLD-WK03.                                                
COB305     03 WS-WK03-TOTAL-AR-BAL        PIC S9(9)V99 COMP-3 VALUE 0.        
           03  WS-WK03-COUNT                PIC S9(4) COMP.             
           03  WS-HOLD-WK03-DATA            PIC X(220)                  
T13536            OCCURS 5000 TIMES                                     
                  INDEXED BY WK03-INDX.                                 
      /                                                                 04050000
COB305 01 WS-CIA-LIHEAP-CREDIT        PIC S9(09)V99 COMP-3 VALUE 0.       
COB305 01 WS-CIA-CREDIT        PIC S9(09)V99 COMP-3 VALUE 0.       
                                                                        
      /                                                                 04090000
       PROCEDURE DIVISION USING LS-PCSCA100-COMM-AREA                   
                                WS-BILLING-WQ-ITEMS-WF                  
                                WS-GL-NAME-INFO                         
                                WS-GL-ACCT-NO-TABLE                     
                                WS-GL-ACCT-MAJOR-FIELDS                 
                                WS-PREMISE-PR                           
                                WS-CUSTOMER-CU                          
                                WS-ACCOUNT-AT                           
                                WS-DEP-ON-HAND-DO                       
                                WS-CREDIT-PROFILE-CZ                    
      *                                                                 04200000
                                WS-AR-CNTRL-AC                          
                                WS-CHRG-OFF-CO                          
                                WS-DFA-ACCT-DA                          
                                WS-DFA-RECV-DV                          
                                WS-CONTRACT-CT                          
T5499                           WS-PROJECT-SHARE-PJ                     
                                WS-CONNECT-CHRG-CC                      
                                WS-HOLD-WK03                            
T16786                          WS-CIA-LIHEAP-CREDIT                    
P00097                          WS-CIA-CREDIT                           
P00097                          WS-CWS1000B-MAX-TBL-LIMITS.             
                                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04350000
      **                                                              **04360000
      **    0000-MAINLINE                                             **04370000
      **                                                              **04380000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04390000
       0000-MAINLINE.                                                   
      *                                                                 04410000
           INITIALIZE WS-COUNTERS                                       
                      WS-TEMP-VARIABLES.                                
P00097     INITIALIZE WS-SQL-ERROR-TXT-WQ.                              
           MOVE ZERO TO RETURN-CODE.                                    
ACT284     SET WS-GL-SUB  TO 1                                          
CG0430     INITIALIZE WS-100-USER-DEFINED-AREA                          
CG0430                CJF00101.                                         
           MOVE WS-ACCOUNT-NO-AT      TO AT-ACCOUNT-NO.                 
      * PAL                                                             04490000
           MOVE WS-CUSTOMER-NO-AT     TO AT-CUSTOMER-NO.                
                                                                        
T16786*    SET WS-AR-DATA-INDX TO 1.                                    04520000
T16786*    SEARCH WS-AR-DATA                                            04530000
T16786*       AT END                                                    04540000
T16786*         CONTINUE                                                04550000
T16786*     WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = ZERO              04560000
T16786*         CONTINUE                                                04570000
T16786*     WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 70         04580000
T16786*          AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 2                04590000
T16786*         MOVE WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) TO           04600000
T16786*                   WS-CIA-LIHEAP-CREDIT                          04610000
T16786*         PERFORM 1200-PROCESS-CIA  THRU 1200-EXIT                04620000
T16786*     WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 70         04630000
T16786*          AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 1                04640000
T16786*         MOVE WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) TO           04650000
T16786*                   WS-CIA-CREDIT                                 04660000
T16786*         PERFORM 1200-PROCESS-CIA  THRU 1200-EXIT                04670000
T16786*    END-SEARCH.                                                  04680000
T16786*                                                                 04690000
T16786     PERFORM 1200-PROCESS-CIA  THRU  1200-EXIT.                   
                                                                        
           EXIT PROGRAM.                                                
      *                                                                 04730000
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04740000
      **                                                              **04750000
      **    1200-PROCESS-CIA                                          **04760000
      **                                                              **04770000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04780000
       1200-PROCESS-CIA.                                                
           MOVE 'N' TO WS-6700-CALLED.                                  
           MOVE LS-INPUT-DATE         TO WS-CURRENT-DATE.               
           MOVE WS-COMPANY-NO-AT      TO AT-COMPANY-NO.                 
           MOVE WS-LOCAL-OFFICE-AT    TO AT-LOCAL-OFFICE.               
           MOVE WS-REV-DISTRICT-CD-PR TO PR-REV-DISTRICT-CD.            
           COMPUTE WS-AMOUNT-TEMP = WS-CIA-CREDIT * -1.                 
           MOVE WS-AMOUNT-TEMP        TO WS-PAR-AMT-POSTED.             
                                                                        
FCS        PERFORM 7110-SELECT-CURRENT-DATE      THRU 7110-EXIT.        
FCS        MOVE WS-CURRENT-DATE            TO WS-CD-REPORT-DATE.        
FCS        MOVE WS-LOCAL-OFFICE-AT         TO WS-CD-LOCAL-OFFICE.       
FCS        MOVE WS-CD-COMPANY-NO           TO WS-PAR-COMPANY-NO.        
FCS        MOVE WS-CD-LOCAL-OFFICE         TO WS-PAR-LOCAL-OFFICE.      
FCS        MOVE WS-CD-REPORT-NO            TO WS-PAR-REPORT-NO.         
FCS        MOVE WS-CD-REPORT-DATE          TO WS-PAR-REPORT-DATE.       
FCS        MOVE WS-CASH-DRAWER-ID          TO WS-PAR-CASH-DRAWER.       
      *                                                                 04960000
           PERFORM 5500-APPLY-AS-PAYMENT         THRU 5500-EXIT.        
                                                                        
PCR072     IF WS-CIA-LIHEAP-CREDIT < 0                                  
PCR072      COMPUTE WS-CIA-LIHEAP-CREDIT =                              
PCR072                           (WS-REMAINING-PYMT-AMT * -1)           
PCR072      SET WS-AR-DATA-INDX       TO 1                              
PCR072      SEARCH WS-AR-DATA                                           
PCR072        AT END                                                    
PCR072             CONTINUE                                             
PCR072        WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = 0               
PCR072             CONTINUE                                             
PCR072        WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 70       
PCR072         AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 2                  
PCR072             MOVE WS-CIA-LIHEAP-CREDIT                            
PCR072               TO WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)           
PCR072             MOVE WS-CIA-LIHEAP-CREDIT                            
PCR072               TO WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)        
PCR072      END-SEARCH                                                  
PCR072      IF WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) = 0                
T31499         MOVE WS-CODES-DATA-PRESENT-AT TO WS-CODES-DATA-PRESENT   
T31499         IF WS-CIA-CREDIT = 0                                     
T31499            MOVE SPACE TO WS-CODE-CIA                             
T31499         END-IF                                                   
T31499         MOVE WS-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT-AT   
PCR072         MOVE WS-DELETE                                           
PCR072               TO WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX)       
PCR072      END-IF                                                      
PCR072     END-IF.                                                      
PCR072                                                                  
PCR072     IF WS-CIA-CREDIT < 0                                         
PCR072      COMPUTE WS-CIA-CREDIT =                                     
PCR072                           (WS-REMAINING-PYMT-AMT * -1)           
PCR072      SET WS-AR-DATA-INDX       TO 1                              
PCR072      SEARCH WS-AR-DATA                                           
PCR072        AT END                                                    
PCR072             CONTINUE                                             
PCR072        WHEN WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX) = 0               
PCR072             CONTINUE                                             
PCR072        WHEN WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 70       
PCR072         AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 1                  
PCR072             MOVE WS-CIA-CREDIT                                   
PCR072               TO WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX)           
PCR072             MOVE WS-CIA-CREDIT                                   
PCR072               TO WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)        
PCR072      END-SEARCH                                                  
PCR072      IF WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) = 0                
T31499         MOVE WS-CODES-DATA-PRESENT-AT TO WS-CODES-DATA-PRESENT   
T31499         IF WS-CIA-LIHEAP-CREDIT = 0                              
T31499             MOVE SPACE TO WS-CODE-CIA                            
T31499         END-IF                                                   
T31499         MOVE WS-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT-AT   
PCR072         MOVE WS-DELETE                                           
PCR072               TO WS-UPDATE-ACTION-IND-AC (WS-AR-DATA-INDX)       
PCR072      END-IF                                                      
PCR072     END-IF.                                                      
PCR072                                                                  
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05550000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05560000
      **    5500-APPLY-AS-PAYMENT                                     **05570000
      **                                                              **05580000
      **    CREDIT APPROPRIATE AMOUNT TO ACCOUNT AND UPDATE ACCOUNT   **05590000
      **    TABLE                                                     **05600000
      **                                                              **05610000
      **    CALLED BY: 5000-UPDATE                                    **05620000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05630000
       5500-APPLY-AS-PAYMENT.                                           
           MOVE WS-ACCOUNT-NO-AT       TO AT-ACCOUNT-NO                 
                                          AC-ACCOUNT-NO.                
                                                                        
      ** THIS IS A NON-DIRECTED PYMT. WS-PAYMENT-AMOUNT AND             05680000
      ** WS-PAYMENT-AMOUNT-TOTAL ARE THE SAME.                          05690000
T16786     IF WS-CIA-LIHEAP-CREDIT < 0                                  
T16786         COMPUTE WS-PAYMENT-AMOUNT = WS-CIA-LIHEAP-CREDIT * -1    
T16786     ELSE                                                         
T16786     IF WS-CIA-CREDIT < 0                                         
T16786         COMPUTE WS-PAYMENT-AMOUNT = WS-CIA-CREDIT * -1           
T16786     END-IF
           END-IF.                                                      
T16786*    COMPUTE WS-PAYMENT-AMOUNT =                                  05760000
T16786*        WS-AMT-UNUSED-CR-AC (WS-AR-DATA-INDX) * -1.              05770000
                                                                        
           MOVE WS-PAYMENT-AMOUNT TO WS-AMT-CASH                        
                                     WS-PAYMENT-AMOUNT-TOTAL.           
      *PAL                                                              05810000
           PERFORM 7010-GET-AR-TIMESTAMP          THRU 7010-EXIT.       
           MOVE AR-TRANS-HIST-SEQ-NO    TO WS-CURRENT-TIMESTAMP.        
           IF WS-CIA-LIHEAP-CREDIT < 0                                  
              MOVE WS-PAR-L                TO WS-PAR-UPDATE-TYPE        
              PERFORM 6721-INITIALIZE-PYMT-TBL THRU 6721-EXIT           
                 VARYING WS-PAR-SUB FROM 1 BY 1                         
                    UNTIL WS-PAR-SUB GREATER THAN 52                    
              PERFORM 6722A-LOAD-PYMT-TABLE THRU 6722A-EXIT             
            ELSE                                                        
              MOVE WS-PAR-B                TO WS-PAR-UPDATE-TYPE        
              PERFORM 6721-INITIALIZE-PYMT-TBL THRU 6721-EXIT           
                 VARYING WS-PAR-SUB FROM 1 BY 1                         
                    UNTIL WS-PAR-SUB GREATER THAN 52                    
              PERFORM 6722A-LOAD-PYMT-TABLE THRU 6722A-EXIT             
            END-IF.                                                     
           MOVE WS-AR-CIA-GL-NO (WS-GL-SUB)  TO WS-101-ACCT-GEN-LED-DR  
                                                WS-PAR-GEN-LEDG-DB.     
           MOVE 'Y'                        TO WS-PAR-APPLYING-CREDIT-SW.
CG0430     MOVE 'N'                        TO WS-IS-THIS-DIRECTED-PYMT. 
      ** FROM CPD0010B                                                  06010000
           MOVE 'Y' TO WS-6700-CALLED.                                  
           PERFORM 6700-APPLY-PAYMENT     THRU 6700-EXIT.               
           IF NOT PYMT-WAS-SUCCESSFUL                                   
               PERFORM 5520-PYMT-APPL-ERR THRU 5520-EXIT                
T24024         MOVE '106.'                         TO WS-PROGRAM-ID     
T24024         MOVE '5500'                         TO WS-PARA-ID        
T24024         MOVE 'PAYMENT APPLICATION ERROR'    TO WS-MESSAGE        
T24024         MOVE WS-ERR-MSG                     TO WS-MISC-MSG-TEXT  
T24024         MOVE +54                            TO WS-MISC-MSG-LEN   
T24024*        MOVE 16                             TO RETURN-CODE       06110000
T24024         MOVE 12                             TO RETURN-CODE       
               PERFORM 9910-MISC-ERROR THRU 9910-EXIT                   
           END-IF.                                                      
       5500-EXIT.                                                       
           EXIT.                                                        
       5520-PYMT-APPL-ERR.                                              
       5520-EXIT.                                                       
           EXIT.                                                        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06200000
      **    5600-INVLD-JRNL-RC                                        **06210000
      **                                                              **06220000
      **    HANDLE WORK QUEUE PROCESSING FOR INVALID JOURNAL RETURN   **06230000
      **    CODE                                                      **06240000
      **                                                              **06250000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06260000
       5600-INVLD-JRNL-RC.                                              
                                                                        
T24024     MOVE '106.'                         TO WS-PROGRAM-ID.        
T24024     MOVE '5600'                         TO WS-PARA-ID.           
T24024     MOVE 'INVALID JOURNAL RETURN CODE'  TO WS-MESSAGE.           
T24024     MOVE WS-ERR-MSG                     TO WS-MISC-MSG-TEXT      
T24024     MOVE +56                            TO WS-MISC-MSG-LEN.      
T24024*    MOVE 16                             TO RETURN-CODE.          06340000
T24024     MOVE 12                             TO RETURN-CODE.          
           PERFORM 9910-MISC-ERROR THRU 9910-EXIT.                      
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
PCR052************************************************************      06400000
                                                                        
      /***** 6100 SERIES - COMPUTE REBATE AMOUNT                        06420000
           EXEC SQL                                                     06430000
               INCLUDE CPD0003B                                         06440000
           END-EXEC.                                                    06450000
                                                                        
      /***** 6400 SERIES - BATCH JOURNAL ROUTINE                        06470000
      /***** CPD00007 IS NOT USED FOR THIS PROGRAM!!!                   06480000
      *                                                                 06490000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06500000
      **    6400-ONLINE-JRNL-ROUTINE.                                 **06510000
      **                                                              **06520000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06530000
       6400-ONLINE-JRNL-ROUTINE.                                        
      ** ALL 101 FIELDS ARE SET IN CPD00010                             06550000
           MOVE WS-PAR-AMT-POSTED   TO AR-AMT-ORIG-ENTERED              
                                       AU-AMT-POSTED                    
           MOVE AU-AMT-POSTED       TO E-FWK03-RCV-DEBIT-AMT            
                                       E-FWK03-GEN-LEG-CREDIT-AMT.      
           MOVE ZEROS               TO E-FWK03-RCV-CREDIT-AMT           
                                       E-FWK03-GEN-LEG-DEBIT-AMT.       
           MOVE ZERO                TO WS-DETAIL-END-BAL                
                                       WS-DETAIL-END-AR-BAL.            
           INITIALIZE CJF00101.                                         
                                                                        
XXXXXX*    MOVE WS-DEP-INT-GL-NO (WS-GL-SUB) TO WS-101-ACCT-GEN-LED-DR  06660000
XXXXXX*                                         AU-GL-ACCT-DEBIT.       06670000
           MOVE WS-AR-CIA-GL-NO (WS-GL-SUB)  TO WS-101-ACCT-GEN-LED-CR  
                                                AU-GL-ACCT-CREDIT.      
           MOVE 'APPLYING CIA'               TO AR-TRAN-COMMENT-TEXT.   
           MOVE +12                          TO AR-TRAN-COMMENT-LEN.    
                                                                        
           PERFORM 6420-CREATE-101-JRNL THRU 6420-EXIT.                 
                                                                        
       6400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6420-CREATE-101-JRNL.                                            
           MOVE WS-BAT                  TO AR-RESP-AREA-ID.             
           MOVE WS-PGRMNAME             TO AR-APPL-PROGRAM-ID.          
           MOVE WS-SYSTEM               TO AR-USER-ID.                  
           MOVE ZEROS                   TO AU-CURRENCY-AMT.             
           MOVE SPACES                  TO AR-PYMT-FACILITY-CD          
                                           AR-RECORD-ONLY-FL            
                                           AU-CODE-CONTRACT-TYPE        
                                           AU-CURRENCY-TYPE.            
           MOVE WS-101                  TO WS-101-JRNL-FORMAT-NO.       
FCS        MOVE SPACES                  TO WS-101-CASH-DRAWER-USED.     
           MOVE AR-AMT-ORIG-ENTERED     TO WS-101-AMOUNT-ENTERED        
           MOVE AU-AMT-POSTED           TO WS-101-AMT-POSTED            
           MOVE 'P'                     TO WS-101-AR-AGE.               
           MOVE LS-INPUT-DATE           TO WS-101-DATE-AR-BILLED.       
           MOVE AU-ITEM-ID              TO WS-101-ITEM-ID-NO            
           MOVE WS-DETAIL-END-BAL       TO WS-101-DETAIL-END-BAL        
           MOVE WS-DETAIL-END-AR-BAL    TO WS-101-DETAIL-END-AR-BAL     
           MOVE WS-TOTAL-AR-BALANCE-AT  TO WS-101-ACCT-END-AR-BAL       
                                           AR-AMT-BILLED-UNPAID.        
           MOVE WS-REV-DISTRICT-CD-PR   TO WS-101-CODE-REVENUE-DISTRICT.
PAL        MOVE LS-CURR-REVENUE-MONTH   TO WS-101-REVENUE-MONTH         
           MOVE WS-CODE-EMPL-ACCT-CU    TO WS-101-CODE-EMPL-ACCT.       
           MOVE WS-CODE-COMPANY-ACCT-AT TO WS-101-CODE-COMPANY-ACCT.    
           MOVE WS-CODE-ACCT-STAT-AT    TO WS-101-CODE-ACCOUNT-STATUS.  
           MOVE WS-CODE-PREMISE-STAT-PR TO WS-101-CODE-PREMISE-STATUS.  
           MOVE WS-INDIRECT-JRNL        TO E-FWK03-JRNL-SORT-ID.        
           MOVE AT-ACCOUNT-NO           TO E-FWK03-ACCT-NO.             
           MOVE WS-LOCAL-OFFICE-AT      TO E-FWK03-LOCAL-OFFICE         
   FCS                                     AR-CASH-LOCAL-OFFICE.        
   FCS     MOVE WS-COMPANY-NO-AT        TO E-FWK03-COMPANY-NO           
   FCS                                     AR-COMPANY-NO.               
   FCS     MOVE WS-CD-REPORT-NO         TO AR-CASH-REPORT-NO.           
   FCS     MOVE WS-CASH-DRAWER-ID       TO AR-CASH-DRAWER-ID.           
           MOVE WS-CUSTOMER-NO-AT       TO E-FWK03-CUSTOMER-NO.         
           MOVE WS-BILL                 TO E-FWK03-CODE-TERMINAL-TRAN.  
           MOVE 1                       TO E-FWK03-JRNL-TRAN-APPL-NO    
                                           AU-TRAN-APPL-NO.             
           MOVE LS-INPUT-DATE           TO WS-DATE-LAST-ACTION-AT       
                                           AR-DATE-TRANS                
                                           E-FWK03-DATE-LAST-ACTION.    
           MOVE SPACES                  TO E-FWK03-TRAN-ERRORS.         
           MOVE 'B'                     TO E-FWK03-CODE-ENTRY-SOURCE.   
           MOVE WS-ADJUST               TO AR-CODE-TRAN-TYPE.           
PAL        IF WS-6700-CALLED = 'N'                                      
             MOVE CJF00101                TO E-FWK03-USER-DEFINED-AREA  
             IF WS-101-AMT-POSTED < 0                                   
                 MOVE 'N' TO WS-WRITE-WK03                              
             END-IF                                                     
PAL        ELSE                                                         
PAL          MOVE WS-100-USER-DEFINED-AREA  TO CJF00101                 
             IF WS-101-ACCT-GEN-LED-CR   NOT NUMERIC                    
             AND  WS-101-ACCT-GEN-LED-DR NOT NUMERIC                    
             AND  WS-101-AMT-POSTED      NOT NUMERIC                    
                  MOVE 'N' TO WS-WRITE-WK03                             
             ELSE                                                       
                IF WS-101-AMT-POSTED < 0                                
                   MOVE 'N' TO WS-WRITE-WK03                            
                END-IF                                                  
             END-IF                                                     
PAL          MOVE LS-CURR-REVENUE-MONTH   TO WS-101-REVENUE-MONTH       
T10759       MOVE 'P'                     TO WS-101-AR-AGE              
PAL          MOVE CJF00101 TO  E-FWK03-USER-DEFINED-AREA                
PAL        END-IF.                                                      
           MOVE ZEROS                   TO E-FWK03-SORT-SUM-FLD.        
           IF WS-WRITE-WK03 = 'Y'                                       
              PERFORM 8100-WRITE-WK03      THRU 8100-EXIT               
           END-IF.                                                      
           MOVE 'Y'                     TO  WS-WRITE-WK03.              
      *                                                                 07470000
           MOVE AT-ACCOUNT-NO           TO  AR-ACCOUNT-NO               
                                            AU-ACCOUNT-NO.              
           PERFORM 7010-GET-AR-TIMESTAMP          THRU 7010-EXIT.       
           MOVE AR-TRANS-HIST-SEQ-NO    TO AU-TRANS-HIST-SEQ-NO.        
           ADD +1                       TO AU-TRAN-APPL-NO.             
                                                                        
       6420-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            07560000
                                                                        
      /***** 6500 SERIES - BATCH LOAD ROUTINE (NAMES ARE FROM CPD10)    07580000
                                                                        
       6500-ONLINE-LOAD-AR-TRAN-HIST.                                   
           MOVE '6500' TO ACTIVE-PARAGRAPH.                             
           MOVE 0 TO WS-ACTIVE-RETURN-CODE.                             
       6500-EXIT.                                                       
            EXIT.                                                       
      /***** 6700 SERIES - APPLY PAYMENT ROUTINE                        07650000
           EXEC SQL                                                     07660000
               INCLUDE CPD00010                                         07670000
           END-EXEC.                                                    07680000
           EXEC SQL                                                     07690000
               INCLUDE CPD0010B                                         07700000
           END-EXEC.                                                    07710000
                                                                        
      /                                                                 07730000
      /***** 6800 IS COPY CODE FOR PAYMENTS TO CHARGE OFF ACCTS.        07740000
      ****** THIS IS REFERENCED IN CPD00010 BUT DOES NOT APPLY TO       07750000
      ****** BATCH BILLING.                                             07760000
       6800-APPLY-PYMT-CO.                                              
           CONTINUE.                                                    
       6800-APPLY-PYMT-CO-EXIT.                                         
           EXIT.                                                        
                                                                        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **07820000
      **                                                              **07830000
      **    7010-GET-AR-TIMESTAMP                                     **07840000
      **                                                              **07850000
      **    GET TIMESTAMP FROM AR                                     **07860000
      **                                                              **07870000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **07880000
       7010-GET-AR-TIMESTAMP.                                           
           EXEC SQL                                                     
                SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                INTO :AR-TRANS-HIST-SEQ-NO                              
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     07900000
MFA-TR*         SELECT CURRENT TIMESTAMP                                07910000
MFA-TR*         INTO :AR-TRANS-HIST-SEQ-NO                              07920000
MFA-TR*         FROM CSS_MODEL_SQL                                      07930000
MFA-TR*    END-EXEC.                                                    07940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE 'AR'                    TO WS-DB2-TABLE-ID          
               MOVE 'SELECT'                TO WS-DB2-FUNCTION          
               MOVE SQLCODE                 TO WS-DB2-RETURN-CODE       
               MOVE '106'                   TO WS-DB2-MODULE-ID         
               MOVE '7010'                  TO WS-DB2-PARAGRAPH         
               MOVE 12                      TO RETURN-CODE              
               PERFORM 9990-SQL-ERROR THRU 9990-EXIT
           END-IF.                   
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-SELECT-CURRENT-DATE.                                        
           EXEC SQL                                                     
                SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                        
                INTO :WS-CURRENT-DATE                                   
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     08110000
MFA-TR*         SELECT CURRENT DATE                                     08120000
MFA-TR*         INTO :WS-CURRENT-DATE                                   08130000
MFA-TR*         FROM CSS_MODEL_SQL                                      08140000
MFA-TR*    END-EXEC.                                                    08150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE 'MS'                    TO WS-DB2-TABLE-ID          
               MOVE 'SELECT'                TO WS-DB2-FUNCTION          
               MOVE SQLCODE                 TO WS-DB2-RETURN-CODE       
               MOVE '106'                   TO WS-DB2-MODULE-ID         
               MOVE '7110'                  TO WS-DB2-PARAGRAPH         
               MOVE 12                      TO RETURN-CODE              
               PERFORM 9990-SQL-ERROR THRU 9990-EXIT
           END-IF.                   
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **08310000
      **    8100-WRITE-WK03.                                          **08320000
      **                                                              **08330000
      **    WRITE FWK03 FIELDS TO WK03 FILE.                          **08340000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **08350000
       8100-WRITE-WK03.                                                 
           ADD 1 TO WS-WK03-COUNT                                       
T13536     IF WS-WK03-COUNT > 5000                                      
T24024        MOVE '106.'                         TO WS-PROGRAM-ID      
T24024        MOVE '8100'                         TO WS-PARA-ID         
T24024        MOVE 'WK03 HOLD TABLE OVERFLOW'     TO WS-MESSAGE         
T24024        MOVE WS-ERR-MSG                     TO WS-MISC-MSG-TEXT   
T24024        MOVE +53 TO WS-MISC-MSG-LEN                               
T24024*       MOVE 16 TO RETURN-CODE                                    08440000
T24024        MOVE 12 TO RETURN-CODE                                    
              PERFORM 9910-MISC-ERROR THRU 9910-EXIT                    
           ELSE                                                         
              SET WK03-INDX TO WS-WK03-COUNT                            
              MOVE FIOWK03 TO WS-HOLD-WK03-DATA (WK03-INDX)             
              INITIALIZE FIOWK03                                        
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08560000
      * COPY CPD0023A BILLING DB2 ABEND PROCESSING FOR CPD00023      *  08570000
      ***************************************************************** 08580000
           COPY CPD0023A.                                               08590000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **08600000
      **    9910-MISC-ERROR                                           **08610000
      **                                                              **08620000
      **    MISCELLANEOUS ERROR PROCESING FOR WORK QUEUE              **08630000
      **                                                              **08640000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **08650000
       9910-MISC-ERROR.                                                 
                                                                        
           IF WS-CURRENT-WQ-ITEM = 50                                   
               DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                
               DISPLAY 'PROCESSING TERMINATED'                          
               MOVE 16 TO RETURN-CODE                                   
           ELSE                                                         
               ADD 1 TO WS-CURRENT-WQ-ITEM                              
               SET WS-BILL-WQ-INDX TO WS-CURRENT-WQ-ITEM                
                                                                        
               MOVE WS-MISCELLANEOUS-MESSAGE TO                         
                    WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)       
                                                                        
ACT162         MOVE PROGRAM-NAME             TO                         
ACT162              WS-CREATED-BY-WF (WS-BILL-WQ-INDX)                  
                                                                        
            END-IF.                                                     
                                                                        
            PERFORM 9999-BAIL-OUT   THRU 9999-EXIT.                     
       9910-EXIT.                                                       
           EXIT.                                                        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **08840000
      **    9990-SQL-ERROR                                            **08850000
      **                                                              **08860000
      **    SQL ERROR PROCESSING FOR WORK QUEUE                       **08870000
      **                                                              **08880000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **08890000
       9990-SQL-ERROR.                                                  
                                                                        
           IF WS-CURRENT-WQ-ITEM = 50                                   
               DISPLAY 'WS-BILL-WQ-INDX GREATER THAN 50'                
               DISPLAY 'PROCESSING TERMINATED'                          
               MOVE 16                 TO RETURN-CODE                   
           ELSE                                                         
               ADD 1                   TO WS-CURRENT-WQ-ITEM            
               SET WS-BILL-WQ-INDX     TO WS-CURRENT-WQ-ITEM            
           END-IF.                                                      
                                                                        
           MOVE WS-DATABASE-EXCEPTION  TO                               
                WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX).          
                                                                        
           COMPUTE WS-START-POS                                         
                   = WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX) + 1.          
           MOVE WS-SQL-ERROR-TXT-WQ    TO                               
                WS-COMMENTS-TEXT-WF (WS-BILL-WQ-INDX) (WS-START-POS:).  
           ADD WS-SQL-ERROR-TXT-LEN-WQ TO                               
               WS-COMMENTS-LEN-WF (WS-BILL-WQ-INDX).                    
ACT162     MOVE PROGRAM-NAME           TO                               
ACT162          WS-CREATED-BY-WF (WS-BILL-WQ-INDX).                     
                                                                        
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       9990-EXIT.                                                       
           EXIT.                                                        
*                                                                       
       9900-SQL-ERROR-ROUTINE.                                          
           PERFORM 9999-BAIL-OUT THRU 9999-EXIT.                        
       9900-EXIT.                                                       
           EXIT.                                                        
*                                                                       
                                                                        
       9900B-ABEND.                                                     
           EVALUATE ACTIVE-PARAGRAPH                                    
               WHEN '6500'                                              
                   MOVE 'AR'           TO WS-DB2-TABLE-ID               
                   MOVE 'INSERT'       TO WS-DB2-FUNCTION               
                   MOVE SQLCODE        TO WS-DB2-RETURN-CODE            
                   MOVE '106'          TO WS-DB2-MODULE-ID              
                   MOVE '6500'         TO WS-DB2-PARAGRAPH              
                   MOVE 12             TO RETURN-CODE                   
               WHEN '6501'                                              
                   MOVE 'AU'           TO WS-DB2-TABLE-ID               
                   MOVE 'INSERT'       TO WS-DB2-FUNCTION               
                   MOVE SQLCODE        TO WS-DB2-RETURN-CODE            
                   MOVE '106'          TO WS-DB2-MODULE-ID              
                   MOVE '6501'         TO WS-DB2-PARAGRAPH              
                   MOVE 12             TO RETURN-CODE                   
           END-EVALUATE.                                                
           PERFORM 9990-SQL-ERROR THRU 9990-EXIT.                       
       9900B-EXIT.                                                      
            EXIT.                                                       
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **09410000
      **    9999-BAIL-OUT                                             **09420000
      **                                                              **09430000
      **    TO ABEND PROGRAM                                          **09440000
      **                                                              **09450000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **09460000
       9999-BAIL-OUT.                                                   
           EXIT PROGRAM.                                                
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
