       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. SCS03414.                                            
       AUTHOR. AARON ABRAHAM.                                           
       DATE-WRITTEN.                                                    
      *---------------------------------------------------------------*         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *---------------------------------------------------------------*         
      *                CUSTOMER INFORMATION SYSTEMS                   *         
      *---------------------------------------------------------------*         
      *               PROGRAM  MODIFICATION  LOG                      *         
      * DATE     INITIALS              REASON                         *         
      *~~~~~~~~  ~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
ACT285*10/26/16  AA97148   PROCEDURE ORIGINALLY CODED.                * 00540000
      *                    Ref: APPL00005460                          *         
P00948*01/01/2017 VENKAT.P      SEND DNP CANCEL NOTIFICATION E-MAILS  *         
      *---------------------------------------------------------------*         
             REMARKS.                                                   
      *---------------------------------------------------------------*         
      * THIS PROGRAM CANCELS THE DNP ORDER OR MAKE IT TO TURNED DOWN  *         
      * STATUS OR MAKES THE RECONNECT TO ACTIVE DEPENDING ON THE      *         
      * FACILITY CODE AND UPDATE ACTION FLAG PASSED TO THIS PROGRAM.  *         
      *---------------------------------------------------------------*         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'SCS03414'.
MSQ017     COPY MFASQLM.
       01  WS-CONSTANTS.                                                
           05 PROGRAM-NAME                 PIC X(08) VALUE 'SCS03414'.  
           05 WS-A                         PIC X(01) VALUE 'A'.         
           05 WS-B                         PIC X(01) VALUE 'B'.         
           05 WS-H                         PIC X(01) VALUE 'H'.         
           05 WS-DNPFB                     PIC X(05) VALUE 'DNPFB'.     
           05 WS-SO-ORDER-TYPE-CD-C        PIC X(05) VALUE 'FM006'.     
           05 WS-SO-PANEL-NO               PIC X(04) VALUE '113'.       
           05 WS-RESOLVED                  PIC X(01) VALUE 'R'.         
           05 WS-SO-REMARK-MSG             PIC X(19) VALUE              
                                               'DISCONNECT CANCELED'.   
           05 WS-WQ-COMMENTS-MSG           PIC X(41) VALUE              
               'DNP CANCELLED, DO NOT WORK SERVICE ORDER '.             
           05 WS-WQ-DNPFB-MSG              PIC X(41) VALUE              
               'PAYMT RECVD ON DNPFB; NO RECONNECT EXISTS'.             
           05 WS-WQ-DNP-COMPLETE.                                       
              10  WS-WQ-DNP-MSG1           PIC X(17) VALUE              
               'PAYMENT RECEIVED.'.                                     
              10  WS-WQ-DNP-MSG2           PIC X(22) VALUE              
               'DNP STATE IS COMPLETE.'.                                
              10  WS-WQ-DNP-MSG3           PIC X(44) VALUE              
               'POST ORDER AND REVIEW FOR POSSIBLE RECONNECT'.          
           05 WS-N-WQ-DNP-COMPLETE.                                     
              10 WS-N-WQ-DNP-MSG1          PIC X(54) VALUE              
               'NEW DISCONNECT NOTICE HAS GENERATED WITH NEW DNP DATE;'.
              10 WS-N-WQ-DNP-MSG2          PIC X(55) VALUE              
              ' CANCELLATION OF OLD DNP FAILED BECAUSE OF ORDER STATE/'.
              10 WS-N-WQ-DNP-MSG3          PIC X(39) VALUE              
               ' STATUS; MANUALLY CANCEL THE DNP ORDER.'.               
           05 WS-SYSTEM                    PIC X(07)  VALUE 'SYSTEM'.   
           05 WS-ARRANGEMENT-COMMENTS.                                  
              10 FILLER                    PIC X(45)   VALUE            
                 'ARRANGEMENT COMPLETED DURING PAYMENT POSTING.'.       
                                                                        
       01  WS-NULL-INDICATOR.                                           
           05 WS-IND-01                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-02                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-04                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-05                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-06                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-07                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-08                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-09                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-10                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-11                    PIC S9(04) COMP VALUE +0.    
           05 WS-IND-12                    PIC S9(04) COMP VALUE +0.    
           05 WS-ARNG-SCHD-SEQ-NULL        PIC S9(04) COMP VALUE -1.    
           05 WS-ARNG-DUE-DT-NULL          PIC S9(04) COMP VALUE -1.    
                                                                        
       01  WS-VARIABLES.                                                
           05 WS-LEAST-AMT-DUE-CD          PIC X(13)  VALUE             
                                                      'LEAST-AMT-DUE'.  
           05 WS-LEAST-AMT-DUE             PIC S9(4)V9(2) USAGE COMP-3  
                                                          VALUE 0.      
           05 WS-ACCT-NO-C                 PIC X(13).                   
           05 WS-RECONNECT-IND             PIC X(01) VALUE 'N'.         
           05 WS-COMMENTS                  PIC X(100).                  
           05 WS-UPDATE-PROFILE            PIC X(01).                   
           05 WS-RETURN-FLAG               PIC X(01).                   
COB305     05 WS-DELINQ-VALUE        PIC S9(09) COMP-3 VALUE 0.           
           05 WS-SERVICE-ORDER-NO          PIC 9(13).                   
           05 WS-RELEASE-DATE              PIC X(10) VALUE SPACES.      
           05 WS-CURRENT-DATE              PIC X(10) VALUE SPACES.      
P00948     05 WS-CURRENT-DATE-USA          PIC X(10) VALUE SPACES.      
           05 WS-CURR-USER                 PIC X(07) VALUE SPACES.      
           05 WS-WORK-DAY-TABLE.                                        
              10 WS-WORK-DAY-LIST OCCURS 30 TIMES                       
                    ASCENDING KEY WS-WORK-DAY INDEXED BY WD-INDX.       
                 15 WS-WORK-DAY            PIC X(10).                   
           05 WS-ADJ-DAY                   PIC S9(9) COMP.              
           05 WS-ORDER-TYPE-CD             PIC X(05) VALUE SPACES.      
           05 WS-ORDER-STATE-CD            PIC X(01).                   
           05 WS-SERV-ORDER-STATUS         PIC X(02).                   
           05 WS-ORDER-REASON              PIC X(01).                   
COB305     05 WS-SERV-ORDER-NO        PIC 9(13)V USAGE COMP-3 VALUE 0.     
           05 WS-ORDER-REASON-TEMP         PIC X(15).                   
           05 WS-SERV-ORDER-NO-C           PIC X(13).                   
           05 WS-SERV-ORDER-NO-I REDEFINES WS-SERV-ORDER-NO-C           
                                           PIC 9(13).                   
COB305     05 WS-SERV-ORDER-NO-D        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-SO-ORDER-TYPE-FLAG        PIC X(01) VALUE SPACE.       
           05 WS-SO-RETURN-CD              PIC S9(04) COMP.             
           05 WS-DNPFB-RETURN-CD           PIC S9(04) COMP.             
           05 WS-INSERT-WORK-QUEUE         PIC X(01).                   
           05 WS-TEMP-HIST                 PIC X(01).                   
           05 WS-TEMP-HIST-NUM             PIC 9(01).                   
           05 WS-PENDING-DNP-FLAG          PIC X(01).                   
           05 WS-SERV-ORDER-CHAR           PIC X(13).                   
           05 WS-SO-REMARK-TX-C.                                        
              49 WS-SO-REMARK-TX-LEN       PIC S9(4) COMP SYNC VALUE +0.
              49 WS-SO-REMARK-TX-TEXT      PIC X(19) VALUE SPACES.      
           05 WS-RESP-AREA-ID              PIC X(03) VALUE SPACES.      
           05 WS-WQ-PRIORITY-C             PIC X(01).                   
           05 WS-WQ-COMMENTS-C.                                         
              49 WS-WQ-COMMENTS-LEN        PIC S9(4) COMP SYNC VALUE +0.
              49 WS-WQ-COMMENTS-TEXT       PIC X(150) VALUE SPACES.     
           05 WS-AMOUNT-DISC-BAL           PIC X(12).                   
COB305     05 WS-SERV-ORDER-NO-TEMP        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-RCNCT-RETURN-CD           PIC S9(04) COMP.             
           05 WS-WQ-ITEM-ID                PIC S9(10)V COMP-3 VALUE +0. 
           05 WS-WQ-ROUTING-CATGRY-C       PIC X(01).                   
           05 WS-WQ-LOCAL-OFFICE-C         PIC X(03).                   
           05 WS-WQ-USER-ID-ORIG-C         PIC X(07).                   
           05 WS-WQ-USER-ID-ASGN-C         PIC X(07).                   
           05 WS-WQ-RESP-AREA-ID-C         PIC X(03).                   
           05 WS-WQ-CATEGORY-ID-C          PIC X(02).                   
           05 WS-WQ-CATEGORY-ID-D          PIC S9(04) USAGE COMP.       
           05 WS-WQ-ACCOUNT-NO-C           PIC X(13).                   
           05 WS-WQ-ACCOUNT-NO-I REDEFINES WS-WQ-ACCOUNT-NO-C           
                                           PIC 9(13).                   
COB305     05 WS-WQ-ACCOUNT-NO-D        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-WQ-PREMISE-NO-C           PIC X(10).                   
           05 WS-WQ-PREMISE-NO-I REDEFINES WS-WQ-PREMISE-NO-C           
                                           PIC 9(10).                   
COB305     05 WS-WQ-PREMISE-NO-D        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-WQ-CUSTOMER-NO-C          PIC X(10).                   
           05 WS-WQ-CUSTOMER-NO-I REDEFINES WS-WQ-CUSTOMER-NO-C         
                                           PIC 9(10).                   
COB305     05 WS-WQ-CUSTOMER-NO-D        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-WQ-SERV-ORDER-NO-C        PIC X(13).                   
           05 WS-WQ-SERV-ORDER-NO-I REDEFINES WS-WQ-SERV-ORDER-NO-C     
                                           PIC 9(13).                   
COB305     05 WS-WQ-SERV-ORDER-NO-D        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05 WS-WQ-FREE-FORM-AREA-C.                                   
              49 WS-WQ-FREE-FORM-LEN       PIC S9(4) COMP SYNC VALUE +0.
              49 WS-WQ-FREE-FORM-TEXT      PIC X(20) VALUE SPACES.      
           05 WS-SO-UPDATE-REMARKS-C       PIC X(01) VALUE 'Y'.         
           05 WS-SO-SELECT-UPDATE-C        PIC X(01) VALUE 'U'.         
           05 WS-SO-DNP-CANCEL-REASON      PIC X(01).                   
           05 WS-CURR-TIMESTAMP            PIC X(26).                   
           05 WS-WQ-DATE-REQUIRED          PIC X(26).                   
           05 WS-WQ-DATE-CREATED           PIC X(26).                   
           05 WS-WQ-CREATED-BY             PIC X(16).                   
           05 WS-SO-ACCOUNT-NO-C           PIC X(13).                   
           05 WS-SO-ACCOUNT-NO-I REDEFINES WS-SO-ACCOUNT-NO-C           
                                           PIC 9(13).                   
           05 WS-SO-PREMISE-NO-C           PIC X(10).                   
           05 WS-SO-PREMISE-NO-I REDEFINES WS-SO-PREMISE-NO-C           
                                           PIC 9(10).                   
           05 WS-SO-USER-ID-C              PIC X(06) VALUE 'SYSTEM'.    
           05 WS-RETURN-CODE               PIC S9(4) COMP.              
           05 WS-LOCAL-OFFICE              PIC X(03) VALUE SPACES.      
           05 WS-WORK-AREA                 PIC X(40) VALUE SPACES.      
           05 WS-CREW-ID                   PIC X(06) VALUE SPACES.      
COB305     05 WS-ITEM-ID        PIC S9(10) COMP-3 VALUE 0.           
           05 WS-USER-ID                   PIC X(07).                   
           05 WS-PRINT-DESTINATION         PIC X(15).                   
           05 WS-PRINT-DEST-IND            PIC X(01).                   
           05 WS-PRINTED-IND               PIC X(01).                   
           05 WS-CAD-TRANS-TY-ACT          PIC X(01).                   
           05 WS-STA-AMOUNT                PIC ZZZZZZZZ9.99.            
           05 WS-HOLD-STA-AMOUNT           PIC ZZZZZZZZ9.99.            
           05 WS-AMT-TO-COMPLY             PIC S9(09)V99 COMP-3 VALUE 0.
           05 WS-TOTAL-ARREARS             PIC S9(9)V99 COMP-3 VALUE 0. 
           05 WS-HOLD-CMPLD-IND            PIC X(01) VALUE SPACES.      
           05 WS-HOLD-AGREEMENT.                                        
              10 WS-HOLD-AGREE-TEXT      PIC X(12) VALUE 'AGREEMNT NO '.
              10 WS-HOLD-AGREE-NO        PIC 9(3)  VALUE ZERO.          
           05 WS-ARNG-COMPLIANCE-CD        PIC X(02) VALUE SPACES.      
           05 WS-COMP-2-CHAR-CONV          PIC ZZZZZZZZ9.99.            
P00948     05 WS-COMP-2-CHAR-CONV-EDT1     PIC $$$$$$$$9.99.            
           05 WS-CURRENT-TIMESTAMP        PIC X(26)  VALUE SPACES.      
           05 SCSCB068                    PIC X(8)   VALUE 'SCSCB068'.  
           05 MCSCB068                    PIC X(8)   VALUE 'MCSCB068'.  
           05 SCSCB371                    PIC X(08)  VALUE 'SCSCB371'.  
           05 MCSCB371                    PIC X(08)  VALUE 'MCSCB371'.  
           05 WS-BATCH-PYMT               PIC X(9)   VALUE 'CSR03413B'. 
           05 RS-RETURN-CODE              PIC S9(4)  VALUE 0 COMP.      
           05 S-RETURN-CODE               PIC S9(4)  VALUE 0 COMP.      
           05 WS-DNP-COLLECT-AMT          PIC S9(09)V99 COMP-3 VALUE 0. 
           05 WS-ADEP-BAL-NULL            PIC S9(4) COMP  VALUE 0.      
           05 WS-ADEP-BALANCE             PIC S9(09)V99 COMP-3 VALUE 0. 
           05 WS-RECONNECT-FULLY-PAID     PIC X(01)  VALUE 'N'.         
              88 RECONNECT-FULLY-PAID                VALUE 'Y'.         
                                                                        
      *01  LOC1      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC2      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC3      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC4      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC5      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC6      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC7      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC8      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC9      USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC10     USAGE IS SQL TYPE IS                               
      *                    RESULT-SET-LOCATOR VARYING.                  
                                                                        
       01 WS-SWITCHES.                                                  
          05 WS-TURN-DOWN-SW              PIC X(01) VALUE 'N'.          
             88 TURNED-DOWN                         VALUE 'T'.          
             88 NOT-TURNED-DOWN                     VALUE 'N'.          
          05 WS-DATABASE-SW               PIC 9(01) VALUE 0.            
             88 CSR-DATABASE                        VALUE 1.            
             88 SEB-DATABASE                        VALUE 2.            
          05 WS-WORK-QUEUE-SW             PIC X(01) VALUE SPACES.       
             88 DNP-CANCEL-WQ                       VALUE 'A'.          
             88 DNP-COMPLETE-WQ                     VALUE 'B'.          
             88 DNPFB-WQ                            VALUE 'C'.          
             88 NEW-NOTICE-WQ                       VALUE 'D'.          
          05 WS-SO-UPDATE-WORKED-SW       PIC X(01) VALUE 'N'.          
             88 SO-UPDATE-WORKED                    VALUE 'Y'.          
             88 SO-UPDATE-NOT-WORKED                VALUE 'N'.          
          05 WS-DNP-SWITCH                PIC X(01) VALUE 'N'.          
             88 WS-DNP01                            VALUE 'D'.          
             88 WS-DNP-FINALBILL                    VALUE 'F'.          
          05 WS-RETURN-CD-SW              PIC X(01) VALUE ' '.          
             88 RETURN-CODE-5000                    VALUE 'A'.          
             88 RETURN-CODE-100                     VALUE 'B'.          
          05 WS-DNP-REC-ERR-SW            PIC X(01) VALUE ' '.          
             88 DNP-ERROR                           VALUE 'A'.          
             88 RECONNECT-ERROR                     VALUE 'B'.          
          05 WS-PAID-SENT-SW              PIC X(01) VALUE 'N'.          
             88 PAID-SENT                           VALUE 'Y'.          
             88 PAID-NOT-SENT                       VALUE 'N'.          
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * SQL COMMUNICATION AREA                                        *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * CPD00068 WORKING STORAGE COPYBOOK                             *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
P00948*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
P00948*    CSS_BATCH_EMAIL - AE                                       *         
P00948*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
P00948                                                                  
P00948     EXEC SQL                                                             
P00948      INCLUDE TBBEMAIL                                                    
P00948     END-EXEC.                                                            
P00948                                                                  
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_ACCOUNT - AT                                           *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBACCT                                                      
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_DELINQUENCY - C8                                       *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBDELQ                                                      
           END-EXEC.                                                            
                                                                        
P00948*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
P00948*    CSS_BTCH_EMAIL_DET - JK                                    *         
P00948*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
P00948                                                                  
P00948     EXEC SQL                                                             
P00948      INCLUDE TBBTEDET                                                    
P00948     END-EXEC.                                                            
P00948                                                                  
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_HOLIDAY - J8                                           *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBHLDAY                                                     
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_CREDIT_PROFILE - CZ                                    *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCRPROF                                                    
           END-EXEC.                                                            
                                                                        
P00948*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
P00948*    CSS_CUST_EMAIL - NE                                        *         
P00948*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
P00948                                                                  
P00948     EXEC SQL                                                             
P00948      INCLUDE TBCSTEML                                                    
P00948     END-EXEC.                                                            
P00948                                                                  
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_PREMISE - PR                                           *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBPREM                                                      
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_DEP_ON_HAND - DO                                       *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBDEPHND                                                    
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_DEP_REQ - DR                                           *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBDEPREQ                                                    
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_AR_CNTL - AC                                           *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBARCNTL                                                    
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_SO_DATA VO                                             *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBSODAT                                                     
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *    CSS_SO_DNP_CANCEL - XK                                     *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
           EXEC SQL                                                             
            INCLUDE TBSODNPC                                                    
           END-EXEC.                                                            
      *                                                                         
      *********** START OF DB2 INCLUDES FOR CPD03413 ************               
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * CSS_MNT_TRANS_HIST - MH                                                 
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * CSS_MT_TRN_HST_DET - MI                                                 
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * CSS_USER_PROFILE - PF                                                   
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * CSS_RECONNECT  - DL                                                     
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * CSS_CRED_ARNGMENT   - X1                                                
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
             INCLUDE TBCRARNG                                                   
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * CSS_CRED_ARNG_ACTN - W4                                                 
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
             INCLUDE TBCRDACT                                                   
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * CSS_CRED_ARNG_HIST  - WY                                                
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
             INCLUDE TBCRARHS                                                   
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *  CSS_ARNG_ATTR      - UY                                                
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
             INCLUDE TBARGATT                                                   
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *  CSS_BILLING_HDR    - BI                                                
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * CSS_CRED_ARNG_SCHD  - WX                                                
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
             INCLUDE TBCRARSC                                                   
           END-EXEC.                                                            
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *  CSS_REG_PROFILE    - LR                                                
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
           EXEC SQL                                                             
             INCLUDE TBREGPRF                                                   
           END-EXEC.                                                            
                                                                        
      * WS ABEND WORK AREA                                                      
       COPY FIOJC01.                                                            
      * DB2 SQL ERROR CHECKING                                                  
       COPY CWS00303.                                                           
      * CODES-DATA-PRESENT FROM CSS_ACCOUNT                                     
       COPY CWS00056.                                                           
MSQ001        EXEC SQL
MSQ001          DECLARE C1 CURSOR
MSQ001          FOR CALL CSR00125                                       
                   ( :WS-SO-ACCOUNT-NO-C
                  , :WS-SO-PREMISE-NO-C
                  , :WS-SO-USER-ID-C
                  , :WS-SO-REMARK-TX-C
                  , :WS-SO-UPDATE-REMARKS-C
                  , :WS-SO-SELECT-UPDATE-C
                  , :WS-SO-PANEL-NO
                  , :WS-SO-ORDER-TYPE-FLAG
                  , :WS-SO-DNP-CANCEL-REASON
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C8 CURSOR
MSQ001          FOR CALL CSR00336                                       
                         ( :WS-ACCT-NO-C
                  , 'FM006'
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C9 CURSOR
MSQ001          FOR CALL CSR00337                                       
                        ( :WS-SERV-ORDER-NO-C
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C10 CURSOR
MSQ001          FOR CALL CSR02122                                       
                        ( :WS-ACCT-NO-C
                  , :WS-WQ-PREMISE-NO-C
                  , :WS-ORDER-REASON
                  , :WS-SO-DNP-CANCEL-REASON
                  , :WS-PENDING-DNP-FLAG
                  , :WS-UPDATE-PROFILE
                  , :WS-AMOUNT-DISC-BAL
                  , :WS-SO-PANEL-NO
                  , :WS-ORDER-TYPE-CD
                  , :WS-SO-REMARK-TX-C
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C3 CURSOR
MSQ001          FOR CALL CSR04675                                            
                    ( :WS-WQ-ITEM-ID
                  , :WS-WQ-ROUTING-CATGRY-C
                  , :WS-WQ-LOCAL-OFFICE-C
                  , :WS-WQ-USER-ID-ORIG-C
                  , :WS-WQ-USER-ID-ASGN-C
                  , :WS-WQ-RESP-AREA-ID-C
                  , :WS-WQ-CATEGORY-ID-D
                  , :WS-WQ-ACCOUNT-NO-D
                  , :WS-WQ-PREMISE-NO-D
                  , :WS-WQ-CUSTOMER-NO-D
                  , :WS-WQ-SERV-ORDER-NO-D
                  , :WS-WQ-COMMENTS-C
                  , :WS-WQ-DATE-REQUIRED
                  , :WS-WQ-DATE-CREATED
                  , :WS-WQ-PRIORITY-C
                  , :WS-WQ-FREE-FORM-AREA-C
                  , :WS-WQ-CREATED-BY
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C4 CURSOR
MSQ001          FOR CALL CSR04422                                       
                       ( :WS-SO-ACCOUNT-NO-C
                  , :WS-SO-ORDER-TYPE-CD-C
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C2 CURSOR
MSQ001          FOR CALL CSR00423                                            
                    ( :WS-SERV-ORDER-NO-D
                  )
MSQ001        END-EXEC.
                  
                                                                        
       LINKAGE SECTION.                                                 
       01 WS-ACCOUNT-NO            PIC 9(13).                           
       01 WS-UPDATE-ACTION-FL      PIC X(01).                           
       01 WS-FACILITY-CODE         PIC X(01).                           
       01 WS-DNP-RET-CODE          PIC S9(4) COMP.                      
       01 S-ACTIVE-PARAGRAPH       PIC X(05).                           
       01 WS-PYMT-AMOUNT           PIC S9(09)V99 COMP-3 VALUE +0.       
       01 WS-PYMT-AMOUNT-HOLD      PIC S9(09)V99 COMP-3 VALUE +0.       
       01 WS-CALL-TYPE             PIC X(01) VALUE SPACES.              
       01 WS-CPD68-REQUIRED        PIC X(01) VALUE SPACES.              
       01 WS-PROGRAM-NAME          PIC X(08) VALUE SPACES.              
       01 WS-CPD68-ACTN-FL         PIC X(01) VALUE SPACES.              
       01 WS-CNCL-DNP-ACTN-FL      PIC X(01) VALUE SPACES.              
       01 WS-CNCL-DNP-EMAIL-REQ-FL PIC X(01) VALUE SPACES.              
       01 WS-SO-UPDT-ACTN-FL       PIC X(01) VALUE SPACES.              
       01 WS-CRED-ARNG-ACTN-FL     PIC X(01) VALUE SPACES.              
       01 ws-APPL-PROGRAM-ID       PIC X(09) VALUE SPACES.              
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION USING                                         
                          WS-ACCOUNT-NO                                 
                         ,WS-UPDATE-ACTION-FL                           
                         ,WS-FACILITY-CODE                              
                         ,WS-DNP-RET-CODE                               
                         ,S-ACTIVE-PARAGRAPH                            
                         ,WS-PYMT-AMOUNT                                
                         ,WS-PYMT-AMOUNT-HOLD                           
                         ,WS-CALL-TYPE                                  
                         ,WS-CPD68-REQUIRED                             
                         ,WS-PROGRAM-NAME                               
                         ,WS-CPD68-ACTN-FL                              
                         ,WS-CNCL-DNP-ACTN-FL                           
                         ,WS-CNCL-DNP-EMAIL-REQ-FL                      
                         ,WS-SO-UPDT-ACTN-FL                            
                         ,WS-CRED-ARNG-ACTN-FL                          
                         ,ws-APPL-PROGRAM-ID                            
                         ,ABEND-FILE.                                   
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *                          M A I N L I N E                      *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       0000-MAINLINE.                                                   
      *--------------*                                                          
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
                                                                        
           PERFORM 1000-PROCESS-ACCOUNT                                 
              THRU 1000-EXIT.                                           
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD03414                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *---------------------------------------------------------------* 42550000
      * COMMIT DB2 SO THAT IT WILL STORE THE PAYMENT IN TABLE         * 42560000
      *---------------------------------------------------------------* 42570000
                                                                        
       8999-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                     42610000
              INCLUDE CPD00047                                          42620000
           END-EXEC                                                     42630000
           .                                                            42640000
                                                    
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                 42900000
       9000-EXIT.                                                       
      *                                                                 42920000
      *******************************************************           42920000
      *   9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT COPYBOOK   *           42920000
      *******************************************************           42920000
           EXEC SQL                                                     42920000
              INCLUDE CPDSP300                                          42920000
           END-EXEC.                                                    42920000
