       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PNCRP001.                                        
       DATE-WRITTEN.   10/14/2015.                                      
       DATE-COMPILED.                                                   
       AUTHOR.         MC95456.                                         
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      ** PNCRP001 GENERATES A REPORT FOR SHIPPER AND TRANSPORATION   **         
      ** USAGE FOR INDUSTRIAL INVOICE CUSTOMERS.                     **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **             PROGRAM  MODIFICATION  LOG                      **         
      **                                                             **         
      **   DATE     INITIALS  REASON                                 **         
      **   ----     --------  ------                                 **         
      **   10/14    MC95456   EZTR TO COBOL CONVERSION FOR PNC001    **         
ACT275**   09/16    BD09555   EXTRACT A FILE EVERY DAY FROM          **         
ACT275**A05460-ACT275         CYCLE 20 OPEN TO CYCLE 20 CLOSE        **         
      *****************************************************************         
      **          ---- BASIC SEQUENCE STRUCTURE ----                 **         
      **                                                             **         
      **  0000         MODULE CONTROL                                **         
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     **         
      **  1000 - 1999  FUNCTIONAL CONTROL                            **         
      **  2000 - 4999  DETAIL LOGIC                                  **         
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            **         
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  **         
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)**         
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)*         
      **  9000 - 9799  TERMINATION MODULES                           **         
      **  9900 - 9999  ABEND / ABORT MODULES                         **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT PRNTFILE    ASSIGN TO UT-S-PRNTFILE.                  
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  PRNTFILE                                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD                                   
           BLOCK CONTAINS 0 RECORDS                                     
           RECORD CONTAINS 133 CHARACTERS                               
           DATA RECORD IS PRNTFILE-REC.                                 
       01 PRNTFILE-REC                 PIC X(133).                      
                                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PNCRP001'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)    VALUE               
           'WORKING STORAGE FOR PNCRP001 STARTS HERE'.                  
      *                                                                         
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'PNCRP001'.      
           05  COMPANY-NO              PIC X(02) VALUE '26'.            
           05  WS-EFF-REV-MTH          PIC X(06) VALUE SPACES.          
           05  WS-REVENUE-MNTH         PIC X(06) VALUE SPACES.          
           05  WS-REVNUE-MTH-N     REDEFINES WS-REVENUE-MNTH            
                                       PIC 9(06).                       
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-CURRENT-TIME         PIC X(08) VALUE SPACES.          
           05  WS-PROCESSED-DT         PIC X(10) VALUE SPACES.          
           05  WS-RUN-TYPE             PIC X(01) VALUE SPACES.          
           05  WS-BZ-BILL-UNITS-NULL   PIC S9(4) COMP.                  
           05  WS-AMT-BILL-ITEM        PIC S9(9)V99.                    
           05  WS-PREV-SHIPPER-CD      PIC X(01) VALUE SPACES.          
           05  WS-BILL-UNITS           PIC S9(9)V VALUE 0.              
           05  WS-TOT-TRANS-USG        PIC S9(9)V VALUE 0.              
           05  WS-TRANS-USG            PIC S9(7)V VALUE 0.              
           05  WS-BILL-TRANS           PIC X(10) VALUE SPACES.          
           05  WS-MAX-DATE-EXTRACT     PIC X(10) VALUE SPACES.          
           05  WS-MIN-DATE-EXTRACT     PIC X(10) VALUE SPACES.          
           05  WS-DATE-EXTRACT         PIC X(10) VALUE SPACES.          
           05  WS-ADJUSTMENT-MONTH     PIC X(06) VALUE SPACES.          
           05  WS-COMMON-DATE          PIC X(10) VALUE SPACES.          
           05  WS-PAGE-NO              PIC 9(04) VALUE 0.               
           05  WS-LINE-NO              PIC 9(04) VALUE 0.               
           05  WS-PARM-DATA.                                            
               10 WS-PARM-COMP-TX      PIC X(11) VALUE 'COMPANY_NO='.   
               10 WS-PARM-COMP-NO      PIC X(02) VALUE SPACES.          
               10 WS-FILLER            PIC X(01) VALUE SPACES.          
               10 WS-PARM-RUN-TXT      PIC X(09) VALUE 'RUN_TYPE='.     
               10 WS-PARM-RUN-TYPE     PIC X(01) VALUE SPACES.          
           05  WS-DATA-PRESENT         PIC X(01).                       
               88 DATA-PRESENT                   VALUE 'Y'.             
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-T                    PIC X(01) VALUE 'T'.             
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-N                    PIC X(01) VALUE 'N'.             
           05  WS-D                    PIC X(01) VALUE 'D'.             
           05  WS-26                   PIC X(02) VALUE '26'.            
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
       01  WS-DETAIL-HDR-1.                                             
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 FILLER                   PIC X(08) VALUE                  
              'PNC00101'.                                               
           05 FILLER                   PIC X(49) VALUE SPACES.          
           05 P-COMPANY-NAME           PIC X(26) VALUE SPACES.          
           05 FILLER                   PIC X(38) VALUE SPACES.          
           05 FILLER                   PIC X(06) VALUE 'PAGE: '.        
           05 P-PAGE-NO                PIC ZZZZ9.                       
      *                                                                         
       01  WS-DETAIL-HDR-2.                                             
           05 FILLER                   PIC X(48) VALUE SPACES.          
           05 FILLER                   PIC X(31) VALUE                  
              'TRANSPORTATION USAGE BY SHIPPER'.                        
           05 FILLER                   PIC X(02) VALUE SPACES.          
           05 P-REPORT-TYPE            PIC X(20) VALUE SPACES.          
           05 FILLER                   PIC X(14) VALUE SPACES.          
           05 FILLER                   PIC X(09) VALUE                  
              'RUN-DATE:'.                                              
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 P-CURRENT-MM             PIC X(02) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE '/'.             
           05 P-CURRENT-DD             PIC X(02) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE '/'.             
           05 P-CURRENT-YY             PIC X(02) VALUE SPACES.          
      *                                                                         
       01  WS-DETAIL-HDR-3.                                             
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 FILLER                   PIC X(14) VALUE                  
              'REVENUE MONTH:'.                                         
           05 FILLER                   PIC X(02) VALUE SPACES.          
           05 P-REVENUE-YY             PIC X(04) VALUE SPACES.          
           05 FILLER                   PIC X(01) VALUE '/'.             
           05 P-REVENUE-MM             PIC X(04) VALUE SPACES.          
           05 FILLER                   PIC X(89) VALUE SPACES.          
           05 FILLER                   PIC X(10) VALUE                  
              'RUN-TIME:'.                                              
           05 P-CURRENT-TIME           PIC X(08) VALUE SPACES.          
      *                                                                         
       01  WS-DETAIL-HDR-4.                                             
           05 FILLER                   PIC X(50) VALUE SPACES.          
           05 FILLER                   PIC X(08) VALUE                  
              'SHIPPER:'.                                               
           05 FILLER                   PIC X(02) VALUE SPACES.          
           05 P-FUEL-SHIPPER-NM        PIC X(25) VALUE SPACES.          
      *                                                                         
       01  WS-DETAIL-HDR-5.                                             
           05 FILLER                   PIC X(133) VALUE SPACES.         
      *                                                                         
       01  WS-DETAIL-HDR-6.                                             
           05 FILLER                   PIC X(66) VALUE SPACES.          
           05 FILLER                   PIC X(06) VALUE                  
              'OFFICE'.                                                 
           05 FILLER                   PIC X(10) VALUE SPACES.          
           05 FILLER                   PIC X(14) VALUE                  
              'TRANSPORTATION'.                                         
           05 FILLER                   PIC X(05) VALUE SPACES.          
           05 FILLER                   PIC X(07) VALUE                  
              'BILLING'.                                                
           05 FILLER                   PIC X(09) VALUE SPACES.          
           05 FILLER                   PIC X(10) VALUE                  
              'ADJUSTMENT'.                                             
      *                                                                         
       01  WS-DETAIL-HDR-7.                                             
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 FILLER                   PIC X(13) VALUE                  
              'CUSTOMER NAME'.                                          
           05 FILLER                   PIC X(28) VALUE SPACES.          
           05 FILLER                   PIC X(14) VALUE                  
              'ACCOUNT NUMBER'.                                         
           05 FILLER                   PIC X(10) VALUE SPACES.          
           05 FILLER                   PIC X(04) VALUE                  
              'CODE'.                                                   
           05 FILLER                   PIC X(12) VALUE SPACES.          
           05 FILLER                   PIC X(10) VALUE                  
              'USAGE (DT)'.                                             
           05 FILLER                   PIC X(09) VALUE SPACES.          
           05 FILLER                   PIC X(11) VALUE                  
              'TRANSACTION'.                                            
           05 FILLER                   PIC X(05) VALUE SPACES.          
           05 FILLER                   PIC X(05) VALUE                  
              'MONTH'.                                                  
                                                                        
       01  WS-TOTAL-LINE.                                               
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 FILLER                   PIC X(14) VALUE                  
              'SHIPPER TOTAL:'.                                         
           05 FILLER                   PIC X(69) VALUE SPACES.          
           05 P-TOT-TRANS-USAGE        PIC ZZZ,ZZZ,ZZ9-.                
                                                                        
       01  WS-NO-DATA-LINE.                                             
           05 FILLER                   PIC X(46) VALUE SPACES.          
           05 FILLER                   PIC X(31) VALUE                  
              '** NO DATA FOUND FOR THIS RUN**'.                        
                                                                        
       01  WS-END-LINE.                                                 
           05 FILLER                   PIC X(55) VALUE SPACES.          
           05 FILLER                   PIC X(21) VALUE                  
              '*** END OF REPORT ***'.                                  
      *                                                                         
       01  WS-DETAIL-LINES.                                             
           05  WS-DETAIL-LINE-1.                                        
               10 FILLER               PIC X(01) VALUE SPACES.          
               10  WS-CUST-NAME        PIC X(37).                       
               10 FILLER               PIC X(04) VALUE SPACES.          
               10  WS-ACCT-NO          PIC 9/9999/9999/9999.            
               10 FILLER               PIC X(08) VALUE SPACES.          
               10  WS-LOCAL-OFFICE     PIC X(03).                       
               10 FILLER               PIC X(18) VALUE SPACES.          
               10  WS-TRANS-USAGE      PIC Z,ZZZ,ZZ9-.                  
               10 FILLER               PIC X(05) VALUE SPACES.          
               10  WS-BILLING-TRANS    PIC X(09).                       
               10 FILLER               PIC X(06) VALUE SPACES.          
               10  WS-ADJUST-MONTH     PIC X(10).                       
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-BG-ROWS      PIC  X(01).                      
               88 NO-MORE-BG-ROWS      VALUE 'Y'.                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
      *                                                                         
       COPY CWS00011.                                                           
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
      /*****   WS AREA FOR REPORTDATE REVENUE MONTH                             
      ***************** PNCRP001 REPORT HEADERS **********************          
      *                                                                         
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE          PIC X(02).                       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC    PIC 9(02).                       
      *                                                                         
      * copy book for error handling                                            
       COPY CWS00010.                                                           
      *                                                                         
      *****************************************************************         
      *    JOB PARM.                                                            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_ACCOUNT - AT                                          
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_ZIP_CODE - A4                                         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_BILLING_DET - BG                                      
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_BILLING_HDR - BI                                      
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_BILL_WINDOW - BN                                      
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_BILL_CALC_DET - BZ                                    
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBLCLDT                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_COMPANY - C7                                          
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_ADDR_FORMATTED  - DY                                  
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_NAME - DQ                                             
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_NAME_ACCT_XREF - HT                                   
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_PREMISE        - PR                                   
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *****************************************************************         
      *    DCLGEN FOR CSS_FUEL_SHIPPER   - W5                                   
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBFULSHP                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *    SQL COMMUNICATION AREA.                                              
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * COPYBOOK DECLARATION                                          *         
      *****************************************************************         
      *****                                                                     
      *  CWS00038 - JOB PARM / COMMON DATE SUPPORT                              
      *****                                                                     
           EXEC SQL                                                             
                INCLUDE CWS00038                                                
           END-EXEC.                                                            
      *****                                                                     
      *  CWS00114 - WORKING STORAGE TO READ REPORT DATE                         
      *****                                                                     
           EXEC SQL                                                             
                INCLUDE CWS00114                                                
           END-EXEC.                                                            
      *****                                                                     
      *  COPYBOOK FOR DATE CHECK                                                
      *****                                                                     
           EXEC SQL                                                             
             INCLUDE FIOJC01                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *   DECLARE THE DRIVING CURSOR                                  *         
      *****************************************************************         
           EXEC SQL                                                     
             DECLARE BILL_CSR CURSOR FOR                                
              SELECT DISTINCT                                           
                     AT.ACCOUNT_NO                                      
                    ,PR.ADDRESS_ID                                      
                    ,AT.LOCAL_OFFICE                                    
                    ,BG.FUEL_SHIPPER_CD                                 
                    ,BG.RATE_PLAN_NO                                    
                    ,BG.BILL_NO                                         
                    ,BG.CODE_UTIL_TYPE                                  
                    ,BG.IC_NO                                           
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                              
                    ,BG.CODE_REVENUE_CLASS                              
                    ,BG.AMT_BILL_ITEM                                   
                    ,BG.CODE_BILL_ITM_TYPE                              
                    ,BG.CODE_BILL_ITM_IND                               
                    ,BG.REV_MTH_ORIG_BILL                               
                    ,BG.CODE_DR_CR_CNSMPTN                              
                    ,BG.AMT_STATE_TAX                                   
                    ,BG.AMT_CITY_TAX                                    
                    ,BG.AMT_OTHER_TAX                                   
                    ,W5.FUEL_SHIPPER_NM                                 
                    ,DQ.FULL_NAME                                       
                FROM CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                
                    ,CSS_PREMISE        PR WITH(READUNCOMMITTED)                
                    ,CSS_BILLING_DET    BG WITH(READUNCOMMITTED)                
                    ,CSS_BILLING_HDR    BI WITH(READUNCOMMITTED)                
                    ,CSS_ALTN_FUEL_SPLY AK WITH(READUNCOMMITTED)                
                    ,CSS_FUEL_SHIPPER   W5 WITH(READUNCOMMITTED)                
                    ,CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)                
                    ,CSS_NAME           DQ WITH(READUNCOMMITTED)                
               WHERE AT.ACCOUNT_NO  = BG.ACCOUNT_NO                     
                 AND AT.COMPANY_NO  = :WS-PARM-COMP-NO                  
                 AND AT.PREMISE_NO  = PR.PREMISE_NO                     
                 AND AT.ACCOUNT_NO  = AK.ACCOUNT_NO                     
                 AND BG.CODE_UTIL_TYPE = AK.CODE_UTIL_TYPE              
                 AND BG.IC_NO          = AK.IC_NO                       
                 AND AK.ALTN_FUEL_SPLY_CD = :WS-T                       
                 AND BG.REVENUE_MONTH     = :BG-REVENUE-MONTH           
                 AND BG.REVENUE_MONTH     <> 0                          
                 AND BG.FUEL_SHIPPER_CD   > ' '                         
                 AND BG.ACCOUNT_NO        = BI.ACCOUNT_NO               
                 AND BG.BILL_NO           = BI.BILL_NO                  
                 AND (BG.FUEL_SHIPPER_CD  <> ' '                        
                 AND  BG.FUEL_SHIPPER_CD  <> 'N')                       
                 AND BI.DATE_BILLED       IS NOT NULL                   
                 AND BG.FUEL_SHIPPER_CD    =  W5.FUEL_SHIPPER_CD        
                 AND HT.ACCOUNT_NO = AT.ACCOUNT_NO                      
                 AND HT.NAME_ID            = DQ.NAME_ID                 
                 AND DQ.NAME_TYPE          = 'CN'                       
               ORDER BY W5.FUEL_SHIPPER_NM                              
                       ,DQ.FULL_NAME                                    
                       ,AT.ACCOUNT_NO                                   
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE BILL_CSR CURSOR FOR                                        
MFA-TR*       SELECT DISTINCT                                                   
MFA-TR*              AT.ACCOUNT_NO                                              
MFA-TR*             ,PR.ADDRESS_ID                                              
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,BG.FUEL_SHIPPER_CD                                         
MFA-TR*             ,BG.RATE_PLAN_NO                                            
MFA-TR*             ,BG.BILL_NO                                                 
MFA-TR*             ,BG.CODE_UTIL_TYPE                                          
MFA-TR*             ,BG.IC_NO                                                   
MFA-TR*             ,BG.BILL_ITEM_TIMESTMP                                      
MFA-TR*             ,BG.CODE_REVENUE_CLASS                                      
MFA-TR*             ,BG.AMT_BILL_ITEM                                           
MFA-TR*             ,BG.CODE_BILL_ITM_TYPE                                      
MFA-TR*             ,BG.CODE_BILL_ITM_IND                                       
MFA-TR*             ,BG.REV_MTH_ORIG_BILL                                       
MFA-TR*             ,BG.CODE_DR_CR_CNSMPTN                                      
MFA-TR*             ,BG.AMT_STATE_TAX                                           
MFA-TR*             ,BG.AMT_CITY_TAX                                            
MFA-TR*             ,BG.AMT_OTHER_TAX                                           
MFA-TR*             ,W5.FUEL_SHIPPER_NM                                         
MFA-TR*             ,DQ.FULL_NAME                                               
MFA-TR*         FROM CSS_ACCOUNT        AT                                      
MFA-TR*             ,CSS_PREMISE        PR                                      
MFA-TR*             ,CSS_BILLING_DET    BG                                      
MFA-TR*             ,CSS_BILLING_HDR    BI                                      
MFA-TR*             ,CSS_ALTN_FUEL_SPLY AK                                      
MFA-TR*             ,CSS_FUEL_SHIPPER   W5                                      
MFA-TR*             ,CSS_NAME_ACCT_XREF HT                                      
MFA-TR*             ,CSS_NAME           DQ                                      
MFA-TR*        WHERE AT.ACCOUNT_NO  = BG.ACCOUNT_NO                             
MFA-TR*          AND AT.COMPANY_NO  = :WS-PARM-COMP-NO                          
MFA-TR*          AND AT.PREMISE_NO  = PR.PREMISE_NO                             
MFA-TR*          AND AT.ACCOUNT_NO  = AK.ACCOUNT_NO                             
MFA-TR*          AND BG.CODE_UTIL_TYPE = AK.CODE_UTIL_TYPE                      
MFA-TR*          AND BG.IC_NO          = AK.IC_NO                               
MFA-TR*          AND AK.ALTN_FUEL_SPLY_CD = :WS-T                               
MFA-TR*          AND BG.REVENUE_MONTH     = :BG-REVENUE-MONTH                   
MFA-TR*          AND BG.REVENUE_MONTH     <> 0                                  
MFA-TR*          AND BG.FUEL_SHIPPER_CD   > ' '                                 
MFA-TR*          AND BG.ACCOUNT_NO        = BI.ACCOUNT_NO                       
MFA-TR*          AND BG.BILL_NO           = BI.BILL_NO                          
MFA-TR*          AND (BG.FUEL_SHIPPER_CD  = ' '                                
MFA-TR*          AND  BG.FUEL_SHIPPER_CD  = 'N')                               
MFA-TR*          AND BI.DATE_BILLED       IS NOT NULL                           
MFA-TR*          AND BG.FUEL_SHIPPER_CD    =  W5.FUEL_SHIPPER_CD                
MFA-TR*          AND HT.ACCOUNT_NO = AT.ACCOUNT_NO                              
MFA-TR*          AND HT.NAME_ID            = DQ.NAME_ID                         
MFA-TR*          AND DQ.NAME_TYPE          = 'CN'                               
MFA-TR*        ORDER BY W5.FUEL_SHIPPER_NM                                      
MFA-TR*                ,DQ.FULL_NAME                                            
MFA-TR*                ,AT.ACCOUNT_NO                                           
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PNCRP001 ENDS HERE'.                    
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION       THRU 0100-EXIT.            
           PERFORM 1000-PROCESS-ACCOUNTS     THRU 1000-EXIT.            
           PERFORM 9000-TERMINATE            THRU 9000-EXIT.            
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT PRNTFILE.                                        
           PERFORM 0200-SELECT-JOB-PARM       THRU 0200-EXIT            
           PERFORM 0250-GET-REVENUE-MONTH THRU 0250-EXIT.               
           DISPLAY 'EFFECTIVE REV MNTH : ' WS-REVENUE-MNTH.             
           PERFORM 0350-GET-RUNDATE       THRU 0350-EXIT.               
           DISPLAY 'EFFECTIVE RUN DATE : ' WS-COMMON-DATE.              
           PERFORM 0500-PROCESS-PARM-DATA     THRU 0500-EXIT.           
           MOVE    WS-PARM-COMP-NO        TO C7-COMPANY-NO.             
           PERFORM 7000-GET-COMPANY-NAME   THRU 7000-EXIT.              
           PERFORM 7100-GET-CURRENT-DATE   THRU 7100-EXIT.              
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  0200-SELECT-JOB-PARM.                                     **          
      **      GETS THE REVENUE MONTH FOR PROCESSING                 **          
      ****************************************************************          
      *                                                                         
       0200-SELECT-JOB-PARM.                                            
      *                                                                         
           MOVE COMPANY-NO             TO G6-COMPANY-NO.                
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE PROGRAM-NAME           TO WS-PROGRAM.                   
           MOVE WS-PARM                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL INPUT-ACTIVE OR  END-OF-SYSIPT.                    
                                                                        
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                   CONTINUE                                             
              WHEN OTHER                                                
                 MOVE G6-PARM-DATA (1:24)                               
                                       TO WS-PARM-DATA                  
                 PERFORM 7611-CLOSE    THRU 7611-EXIT                   
                 GO TO 0200-EXIT                                        
           END-EVALUATE.                                                
      *                                                                         
       0200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **  0250-GET-REVENUE-MONTH                                    **          
      **      GETS THE REVENUE MONTH FOR PROCESSING                 **          
      ****************************************************************          
      *                                                                         
       0250-GET-REVENUE-MONTH.                                          
      *                                                                         
           MOVE COMPANY-NO             TO G6-COMPANY-NO.                
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE PROGRAM-NAME           TO WS-PROGRAM.                   
           MOVE WS-DATE                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (REPORT-DATE AND INPUT-ACTIVE)                     
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                   PERFORM 0251-GET-REPORTDATE  THRU 0251-EXIT          
              WHEN OTHER                                                
                 MOVE G6-PARM-DATA (13:06)                              
                                       TO WS-REVENUE-MNTH               
                 MOVE WS-REVNUE-MTH-N  TO WS-EFF-REV-MTH                
                 DISPLAY '** PROGRAM OVERRIDE REVENUE MONTH USED **'    
                 PERFORM 7611-CLOSE    THRU 7611-EXIT                   
                 GO TO 0250-EXIT                                        
           END-EVALUATE.                                                
      *                                                                         
       0250-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      **  0251-GET-REPORTDATE                                       **          
      **      GETS THE REPORT DATE FOR PROCESSING                   **          
      ****************************************************************          
      *                                                                         
       0251-GET-REPORTDATE.                                             
                                                                        
           MOVE SPACES                 TO G6-COMPANY-NO.                
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE SPACES                 TO WS-INPUT-DATA-BREAKDOWN.      
           MOVE 'REPORTDATE'           TO WS-PROGRAM.                   
           MOVE WS-DATE                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU 7600-EXIT.                  
           PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
                  UNTIL INPUT-ACTIVE                                    
                     OR END-OF-SYSIPT.                                  
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY '**      PNCRP001  PROCESSING ERROR  **'       
                 DISPLAY '**  NO ACTIVE REPORTDATE REVENUE MNTH'        
                 DISPLAY '**        PROCESSING TERMINATED    **'        
                 PERFORM 9900-ABEND    THRU  9900-EXIT                  
              WHEN OTHER                                                
                 MOVE G6-PARM-DATA (13:6)                               
                                       TO WS-REVENUE-MNTH               
                 PERFORM 7611-CLOSE    THRU 7611-EXIT                   
                 GO TO 0251-EXIT                                        
           END-EVALUATE.                                                
                                                                        
         0251-EXIT.                                                     
              EXIT.                                                     
      ****************************************************************          
      **  0350-GET-RUNDATE.                                         **          
      **      GETS THE RUN DATE FOR PROCESSING                      **          
      ****************************************************************          
      *                                                                         
       0350-GET-RUNDATE.                                                
                                                                        
           MOVE COMPANY-NO             TO G6-COMPANY-NO.                
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE PROGRAM-NAME           TO WS-PROGRAM.                   
           MOVE WS-DATE                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (RUN-DATE AND INPUT-ACTIVE)                        
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                   PERFORM 0351-GET-COMMON-DATE THRU 0351-EXIT          
              WHEN OTHER                                                
                 MOVE G6-PARM-DATA (10:10)                              
                                       TO WS-COMMON-DATE                
                 DISPLAY '** PROGRAM OVERRIDE RUN DATE USED **'         
                 PERFORM 7611-CLOSE    THRU 7611-EXIT                   
                 GO TO 0350-EXIT                                        
           END-EVALUATE.                                                
                                                                        
       0350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  0351-GET-COMMON-DATE                                      **          
      **      GETS THE REPORT DATE FOR PROCESSING                   **          
      ****************************************************************          
      *                                                                         
       0351-GET-COMMON-DATE.                                            
                                                                        
           MOVE SPACES                 TO G6-COMPANY-NO.                
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE SPACES                 TO WS-INPUT-DATA-BREAKDOWN.      
           MOVE 'COMMON'               TO WS-PROGRAM.                   
           MOVE WS-DATE                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
                                                                        
           PERFORM 7600-START-FCSJC01  THRU 7600-EXIT.                  
           PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
                  UNTIL (RUN-DATE AND INPUT-ACTIVE)                     
                     OR END-OF-SYSIPT.                                  
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY '**      PNCRP001  PROCESSING ERROR  **'       
                 DISPLAY '**  NO ACTIVE REPORTDATE REVENUE MNTH'        
                 DISPLAY '**        PROCESSING TERMINATED    **'        
                 PERFORM 9900-ABEND    THRU  9900-EXIT                  
              WHEN OTHER                                                
                 MOVE G6-PARM-DATA (10:10)                              
                                       TO WS-COMMON-DATE                
                 PERFORM 7611-CLOSE    THRU 7611-EXIT                   
                 GO TO 0351-EXIT                                        
           END-EVALUATE.                                                
                                                                        
         0351-EXIT.                                                     
              EXIT.                                                     
      ****************************************************************          
      ** 0500-PROCESS-PARM-DATA.                                   **           
      ****************************************************************          
       0500-PROCESS-PARM-DATA.                                          
      *                                                                         
              IF WS-PARM-COMP-NO > SPACES                               
                 CONTINUE                                               
              ELSE                                                      
                 MOVE WS-26       TO WS-PARM-COMP-NO                    
              END-IF.                                                   
      *                                                                         
              IF WS-PARM-RUN-TYPE > SPACES                              
                 CONTINUE                                               
              ELSE                                                      
                 MOVE WS-D        TO WS-PARM-RUN-TYPE                   
              END-IF.                                                   
      *                                                                         
              IF WS-PARM-RUN-TYPE = 'D'                                 
                 DISPLAY '  PARM FREQ USED = '    WS-PARM-RUN-TYPE      
              ELSE                                                      
                 IF WS-PARM-RUN-TYPE = 'C'                              
                    DISPLAY '  PARM FREQ USED = ' WS-PARM-RUN-TYPE      
                 ELSE                                                   
                    DISPLAY '  PARM RUN FREQ INVALID'                   
                    DISPLAY '  MUST BE D OR C'                          
                    DISPLAY '  PARM-RUN-TYPE = '  WS-PARM-RUN-TYPE      
                    PERFORM 9900-ABEND           THRU 9900-EXIT         
                 END-IF                                                 
              END-IF.                                                   
              IF WS-PARM-RUN-TYPE = WS-D                                
                 MOVE WS-COMMON-DATE TO WS-DATE-EXTRACT                 
                 DISPLAY '  USING COMMON DATE    '  WS-COMMON-DATE      
                 DISPLAY '  BN-DATE-EXTRACT USED '  WS-DATE-EXTRACT     
                 DISPLAY '  USING DAILY FREQ RUN'                       
              ELSE                                                      
                 PERFORM 0550-CHECK-FREQUENCY   THRU 0550-EXIT          
              END-IF.                                                   
      *                                                                         
        0500-EXIT.                                                      
             EXIT.                                                      
      ****************************************************************          
      **0550-CHECK-FREQUENCY.                                     **            
      ****************************************************************          
        0550-CHECK-FREQUENCY.                                           
                                                                        
             MOVE WS-REVENUE-MNTH           TO BN-REVENUE-MONTH.        
             PERFORM 7300-GET-MAX-MIN-READ-DTS    THRU 7300-EXIT.       
ACT275       IF WS-MAX-DATE-EXTRACT = WS-COMMON-DATE                    
ACT275            MOVE 'F'                 TO WS-RUN-TYPE               
ACT275            MOVE ' - FINAL REPORT'   TO P-REPORT-TYPE             
ACT275            MOVE WS-MAX-DATE-EXTRACT    TO WS-DATE-EXTRACT        
ACT275       ELSE                                                       
ACT275          IF WS-MIN-DATE-EXTRACT <= WS-COMMON-DATE                
ACT275             MOVE 'P'                    TO WS-RUN-TYPE           
ACT275             MOVE '- PRELIMINARY REPORT' TO P-REPORT-TYPE         
ACT275             MOVE WS-MIN-DATE-EXTRACT    TO WS-DATE-EXTRACT       
ACT275          END-IF                                                  
ACT275       END-IF.                                                    
             DISPLAY '  USING CYCLE 20 PROCESSING'                      
             DISPLAY '  BN-DATE-EXTRACT USED = ' WS-DATE-EXTRACT.       
                                                                        
       0550-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      ** 1000-PROCESS-ACCOUNTS.                                     **          
      ****************************************************************          
       1000-PROCESS-ACCOUNTS.                                           
      *                                                                         
           MOVE    WS-PARM-COMP-NO            TO AT-COMPANY-NO.         
           MOVE    WS-REVNUE-MTH-N            TO BG-REVENUE-MONTH.      
           PERFORM 7200-OPEN-BILL-CSR         THRU 7200-EXIT.           
           PERFORM 7210-FETCH-BILL-CSR        THRU 7210-EXIT.           
           PERFORM 2000-PROCESS-ACCOUNTS      THRU 2000-EXIT            
                                              UNTIL NO-MORE-BG-ROWS.    
           PERFORM 7220-CLOSE-BILL-CSR        THRU 7220-EXIT.           
           IF DATA-PRESENT                                              
              MOVE WS-TOT-TRANS-USG           TO   P-TOT-TRANS-USAGE    
              PERFORM 8000-PRINT-TOTAL-LINE   THRU 8000-EXIT            
              PERFORM 8400-PRINT-END-LINE     THRU 8400-EXIT            
           ELSE                                                         
              PERFORM 8100-PRINT-HEADERS      THRU 8100-EXIT            
              PERFORM 8300-PRINT-NO-DATA      THRU 8300-EXIT            
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 2000-PROCESS-ACCOUNTS.                                     **          
      ****************************************************************          
       2000-PROCESS-ACCOUNTS.                                           
                                                                        
                                                                        
           IF BG-CODE-BILL-ITM-TYPE = 'C'                               
                                  AND BG-CODE-BILL-ITM-IND = 'A'        
              MOVE 'CALCULATE' TO WS-BILL-TRANS                         
           ELSE                                                         
              IF BG-CODE-BILL-ITM-TYPE = 'C'                            
                                  AND BG-CODE-BILL-ITM-IND = 'K'        
                 MOVE 'CANCEL' TO WS-BILL-TRANS                         
              ELSE                                                      
                 IF BG-CODE-BILL-ITM-TYPE = 'B'                         
                                  AND BG-CODE-BILL-ITM-IND = 'A'        
                    MOVE 'BACKOUT' TO WS-BILL-TRANS                     
                 ELSE                                                   
                    MOVE 'UNKNOWN' TO WS-BILL-TRANS                     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           COMPUTE WS-AMT-BILL-ITEM   =  BG-AMT-BILL-ITEM               
                                        - BG-AMT-STATE-TAX              
                                        - BG-AMT-CITY-TAX               
                                        - BG-AMT-OTHER-TAX.             
                                                                        
           MOVE     AT-ACCOUNT-NO            TO BZ-ACCOUNT-NO.          
           MOVE     BG-BILL-NO               TO BZ-BILL-NO.             
           MOVE     BG-IC-NO                 TO BZ-IC-NO.               
           MOVE     BG-BILL-ITEM-TIMESTMP    TO BZ-BILL-ITEM-TIMESTMP.  
           IF BG-CODE-BILL-ITM-TYPE = 'B'                               
              PERFORM 7400-BILL-CALC-BACK    THRU 7400-EXIT             
           ELSE                                                         
              PERFORM 7500-BILL-CALC-ACTIVE  THRU 7500-EXIT             
           END-IF.                                                      
           MOVE BZ-BILL-UNITS                TO WS-BILL-UNITS.          
      *                                                                         
           COMPUTE WS-TRANS-USG   ROUNDED    = WS-BILL-UNITS / 10.      
      *                                                                         
           IF BG-CODE-DR-CR-CNSMPTN = 'C'                               
              COMPUTE WS-TRANS-USG   = WS-TRANS-USG   * -1              
              COMPUTE WS-AMT-BILL-ITEM = WS-AMT-BILL-ITEM * -1          
              COMPUTE WS-BILL-UNITS = WS-BILL-UNITS * -1                
           END-IF.                                                      
      *                                                                         
           IF BG-REV-MTH-ORIG-BILL NOT EQUAL 0                          
              MOVE BG-REV-MTH-ORIG-BILL TO   WS-ADJUSTMENT-MONTH        
           ELSE                                                         
              MOVE '-'                  TO   WS-ADJUSTMENT-MONTH        
           END-IF.                                                      
      *                                                                         
           MOVE    PR-ADDRESS-ID                TO   DY-ADDRESS-ID.     
           PERFORM 7560-GET-TOWN                THRU 7560-EXIT.         
           IF BG-FUEL-SHIPPER-CD NOT EQUAL WS-PREV-SHIPPER-CD           
              MOVE  WS-TOT-TRANS-USG            TO P-TOT-TRANS-USAGE    
              PERFORM 8000-PRINT-TOTAL-LINE     THRU 8000-EXIT          
              PERFORM 8100-PRINT-HEADERS        THRU 8100-EXIT          
              MOVE 0                            TO WS-TOT-TRANS-USG     
              PERFORM 2100-MOVE-REPORT-DATA     THRU 2100-EXIT          
              PERFORM 8200-PRINT-DETAIL-LINE    THRU 8200-EXIT          
              MOVE BG-FUEL-SHIPPER-CD           TO WS-PREV-SHIPPER-CD   
           ELSE                                                         
              PERFORM 2100-MOVE-REPORT-DATA     THRU 2100-EXIT          
              PERFORM 8200-PRINT-DETAIL-LINE    THRU 8200-EXIT          
           END-IF.                                                      
      *                                                                         
           PERFORM 7210-FETCH-BILL-CSR          THRU 7210-EXIT.         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 2100-MOVE-REPORT-DATA.                                     **          
      ****************************************************************          
       2100-MOVE-REPORT-DATA.                                           
                                                                        
            INITIALIZE WS-DETAIL-LINES.                                 
            MOVE  DQ-FULL-NAME            TO WS-CUST-NAME.              
            MOVE  AT-ACCOUNT-NO           TO WS-ACCT-NO.                
            INSPECT WS-ACCT-NO REPLACING ALL '/' BY '-'.                
            MOVE  AT-LOCAL-OFFICE         TO WS-LOCAL-OFFICE.           
            MOVE  WS-TRANS-USG            TO WS-TRANS-USAGE.            
            MOVE  WS-BILL-TRANS           TO WS-BILLING-TRANS.          
            MOVE  WS-ADJUSTMENT-MONTH     TO WS-ADJUST-MONTH.           
            COMPUTE WS-TOT-TRANS-USG =                                  
                             WS-TOT-TRANS-USG + WS-TRANS-USG.           
                                                                        
       2100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      **  7000-GET-COMPANY-NAME                                       **        
      ******************************************************************        
      *                                                                         
       7000-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  C7.COMPANY_NAME                                   
                INTO :C7-COMPANY-NAME                                   
                FROM CSS_COMPANY C7 WITH(READUNCOMMITTED)                       
               WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  C7.COMPANY_NAME                                           
MFA-TR*         INTO :C7-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY C7                                             
MFA-TR*        WHERE C7.COMPANY_NO = :C7-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PNCRP001 ABORT *****'                   
              DISPLAY '**  7000-GET-COMPANY-NAME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  C7-COMPANY-NO = ' C7-COMPANY-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7100-GET-CURRENT-DATE.                                                
      ******************************************************************        
      *                                                                         
       7100-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIME                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*          ,:WS-CURRENT-TIME = CURRENT TIME                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PNCRP001 ABORT *****'                   
              DISPLAY '**  7100-GET-CURRENT-DATE  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7200-OPEN-BILL-CSR.                                           *        
      ******************************************************************        
       7200-OPEN-BILL-CSR.                                              
                                                                        
           EXEC SQL                                                     
              OPEN BILL_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PNCRP001 ABORT **************'        
              DISPLAY '*        7200-OPEN-BILL-CSR           *'         
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* REVENUE MONTH  : ' BG-REVENUE-MONTH            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PNCRP001  ABORT *************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7210-FETCH-BILL-CSR.                                          *        
      ******************************************************************        
       7210-FETCH-BILL-CSR.                                             
                                                                        
           EXEC SQL                                                     
              FETCH BILL_CSR                                            
              INTO  :AT-ACCOUNT-NO                                      
                   ,:PR-ADDRESS-ID                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:BG-FUEL-SHIPPER-CD                                 
                   ,:BG-RATE-PLAN-NO                                    
                   ,:BG-BILL-NO                                         
                   ,:BG-CODE-UTIL-TYPE                                  
                   ,:BG-IC-NO                                           
                   ,:BG-BILL-ITEM-TIMESTMP                              
                   ,:BG-CODE-REVENUE-CLASS                              
                   ,:BG-AMT-BILL-ITEM                                   
                   ,:BG-CODE-BILL-ITM-TYPE                              
                   ,:BG-CODE-BILL-ITM-IND                               
                   ,:BG-REV-MTH-ORIG-BILL                               
                   ,:BG-CODE-DR-CR-CNSMPTN                              
                   ,:BG-AMT-STATE-TAX                                   
                   ,:BG-AMT-CITY-TAX                                    
                   ,:BG-AMT-OTHER-TAX                                   
                   ,:W5-FUEL-SHIPPER-NM                                 
                   ,:DQ-FULL-NAME                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO  WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE       EQUAL NOT-FOUND            
                 MOVE 'Y'                    TO WS-NO-MORE-BG-ROWS      
              ELSE                                                      
                 MOVE 'Y'                    TO WS-DATA-PRESENT         
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PNCRP001 ABORT **************'        
              DISPLAY '*       7210-FETCH-BILL-CSR                *'    
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* REVENUE MONTH  : ' BG-REVENUE-MONTH            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PNCRP001 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7220-CLOSE-BILL-CSR.                                          *        
      ******************************************************************        
       7220-CLOSE-BILL-CSR.                                             
                                                                        
           EXEC SQL                                                     
              CLOSE BILL_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE       SQLCODE                 TO WS-ACTIVE-RETURN-CODE.
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '********** PNCRP001 ABORT **************'       
               DISPLAY '*       7220-CLOSE-BILL-CSR            *'       
               DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '* REVENUE MONTH  : ' BG-REVENUE-MONTH           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PNCRP001  ABORT *************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7220-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  7300-GET-MAX-MIN-READ-DTS.                                    *        
      ******************************************************************        
       7300-GET-MAX-MIN-READ-DTS.                                       
                                                                        
           EXEC SQL                                                     
                SELECT MIN(DATE_EXTRACT)                                
                      ,MAX(DATE_EXTRACT)                                
                  INTO :WS-MIN-DATE-EXTRACT                             
                      ,:WS-MAX-DATE-EXTRACT                             
                  FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                 
                 WHERE BN.BILL_CYCLE = '20'                             
                   AND BN.REVENUE_MONTH = :BN-REVENUE-MONTH             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MIN(DATE_EXTRACT)                                        
MFA-TR*               ,MAX(DATE_EXTRACT)                                        
MFA-TR*           INTO :WS-MIN-DATE-EXTRACT                                     
MFA-TR*               ,:WS-MAX-DATE-EXTRACT                                     
MFA-TR*           FROM CSS_BILL_WINDOW BN                                       
MFA-TR*          WHERE BN.BILL_CYCLE = '20'                                     
MFA-TR*            AND BN.REVENUE_MONTH = :BN-REVENUE-MONTH                     
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '*** PNCRP001 PROCESSING ERROR ***'         
                    DISPLAY '*** 7300-GET-MAX-MIN-READ-DTS ***'         
                    DISPLAY '*** REVENUE MONTH' BN-REVENUE-MONTH        
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *  7400-BILL-CALC-BACK.                                          *        
      ******************************************************************        
       7400-BILL-CALC-BACK.                                             
                                                                        
           EXEC SQL                                                     
                SELECT SUM(BZ.BILL_UNITS)                               
                  INTO :BZ-BILL-UNITS :WS-BZ-BILL-UNITS-NULL             
                  FROM CSS_BILL_CALC_DET BZ WITH(READUNCOMMITTED)               
                 WHERE BZ.ACCOUNT_NO         = :BZ-ACCOUNT-NO           
                   AND BZ.BILL_NO           <> :BZ-BILL-NO              
                   AND BZ.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BZ-BILL-ITEM-TIMESTMP
              )   
                   AND BZ.IC_NO              = :BZ-IC-NO                
                   AND BZ.CODE_UTIL_TYPE     = 'G'                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SUM(BZ.BILL_UNITS)                                       
MFA-TR*           INTO :BZ-BILL-UNITS:WS-BZ-BILL-UNITS-NULL                     
MFA-TR*           FROM CSS_BILL_CALC_DET BZ                                     
MFA-TR*          WHERE BZ.ACCOUNT_NO         = :BZ-ACCOUNT-NO                   
MFA-TR*            AND BZ.BILL_NO           <> :BZ-BILL-NO                      
MFA-TR*            AND BZ.BILL_ITEM_TIMESTMP = :BZ-BILL-ITEM-TIMESTMP           
MFA-TR*            AND BZ.IC_NO              = :BZ-IC-NO                        
MFA-TR*            AND BZ.CODE_UTIL_TYPE     = 'G'                              
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-BZ-BILL-UNITS-NULL EQUAL -1                   
                       MOVE 0              TO  BZ-BILL-UNITS            
                    END-IF                                              
               WHEN OTHER                                               
                    DISPLAY '*** PNCRP001 PROCESSING ERROR ***'         
                    DISPLAY '*** 7400-BILL-CALC-BACK       ***'         
                    DISPLAY '*** ACCOUNT NO: '  BZ-ACCOUNT-NO           
                    DISPLAY '*** BILL NO:    '  BZ-BILL-NO              
                    DISPLAY '*** TIMESTAMP:  '  BZ-BILL-ITEM-TIMESTMP   
                    DISPLAY '*** IC NO:      '  BZ-IC-NO                
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7500-BILL-CALC-ACTIVE.                                        *        
      ******************************************************************        
       7500-BILL-CALC-ACTIVE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT SUM(BZ.BILL_UNITS)                               
                  INTO :BZ-BILL-UNITS :WS-BZ-BILL-UNITS-NULL             
                  FROM CSS_BILL_CALC_DET BZ WITH(READUNCOMMITTED)               
                 WHERE BZ.ACCOUNT_NO         = :BZ-ACCOUNT-NO           
                   AND BZ.BILL_NO            = :BZ-BILL-NO              
                   AND BZ.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BZ-BILL-ITEM-TIMESTMP
              )   
                   AND BZ.IC_NO              = :BZ-IC-NO                
                   AND BZ.CODE_UTIL_TYPE     = 'G'                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SUM(BZ.BILL_UNITS)                                       
MFA-TR*           INTO :BZ-BILL-UNITS:WS-BZ-BILL-UNITS-NULL                     
MFA-TR*           FROM CSS_BILL_CALC_DET BZ                                     
MFA-TR*          WHERE BZ.ACCOUNT_NO         = :BZ-ACCOUNT-NO                   
MFA-TR*            AND BZ.BILL_NO            = :BZ-BILL-NO                      
MFA-TR*            AND BZ.BILL_ITEM_TIMESTMP = :BZ-BILL-ITEM-TIMESTMP           
MFA-TR*            AND BZ.IC_NO              = :BZ-IC-NO                        
MFA-TR*            AND BZ.CODE_UTIL_TYPE     = 'G'                              
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-BZ-BILL-UNITS-NULL EQUAL -1                   
                       MOVE 0              TO  BZ-BILL-UNITS            
                    END-IF                                              
               WHEN OTHER                                               
                    DISPLAY '*** PNCRP001 PROCESSING ERROR ***'         
                    DISPLAY '*** 7500-BILL-CALC-ACTIVE     ***'         
                    DISPLAY '*** ACCOUNT NO: '  BZ-ACCOUNT-NO           
                    DISPLAY '*** BILL NO:    '  BZ-BILL-NO              
                    DISPLAY '*** TIMESTAMP:  '  BZ-BILL-ITEM-TIMESTMP   
                    DISPLAY '*** IC NO:      '  BZ-IC-NO                
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7560-GET-TOWN.                                                *        
      ******************************************************************        
       7560-GET-TOWN.                                                   
                                                                        
           EXEC SQL                                                     
                  SELECT A4.TOWN                                        
                  INTO :A4-TOWN                                         
                  FROM CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                    
                      ,CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)              
                 WHERE DY.ADDRESS_ID      = :DY-ADDRESS-ID              
                   AND A4.ZIP_CODE        = DY.ZIP_CODE                 
                   AND A4.ZIP_CODE_TOKEN  = DY.ZIP_CODE_TOKEN           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*           SELECT A4.TOWN                                                
MFA-TR*           INTO :A4-TOWN                                                 
MFA-TR*           FROM CSS_ZIP_CODE A4                                          
MFA-TR*               ,CSS_ADDR_FORMATTED DY                                    
MFA-TR*          WHERE DY.ADDRESS_ID      = :DY-ADDRESS-ID                      
MFA-TR*            AND A4.ZIP_CODE        = DY.ZIP_CODE                         
MFA-TR*            AND A4.ZIP_CODE_TOKEN  = DY.ZIP_CODE_TOKEN                   
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7560                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                    DISPLAY '*** PNCRP001 PROCESSING ERROR ***'         
                    DISPLAY '*** 7560-GET-TOWN             ***'         
                    DISPLAY '*** ADDRESS ID: '  DY-ADDRESS-ID           
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
                                                                        
       7560-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      **   8000-PRINT-TOTAL-LINE.                                   **          
      **       PRINTS THE TOTAL UNITS FOR SHIPPER                   **          
      ****************************************************************          
       8000-PRINT-TOTAL-LINE.                                           
      *                                                                         
           IF WS-PAGE-NO < 1                                            
              CONTINUE                                                  
           ELSE                                                         
               WRITE PRNTFILE-REC  FROM WS-TOTAL-LINE                   
                                   AFTER ADVANCING 3 LINES              
               ADD   +4            TO   WS-LINE-NO                      
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   8100-PRINT-HEADERS.                               **                 
      **       PRINTS THE EADERS FOR THE REPORT             **                  
      ****************************************************************          
       8100-PRINT-HEADERS.                                              
      *                                                                         
           ADD   +1                   TO WS-PAGE-NO.                    
           MOVE  WS-PAGE-NO           TO P-PAGE-NO.                     
           MOVE  +0                   TO WS-LINE-NO.                    
           MOVE  C7-COMPANY-NAME      TO P-COMPANY-NAME.                
           MOVE  WS-CURRENT-DATE(3:2) TO P-CURRENT-YY.                  
           MOVE  WS-CURRENT-DATE(6:2) TO P-CURRENT-MM.                  
           MOVE  WS-CURRENT-DATE(9:2) TO P-CURRENT-DD.                  
           MOVE  WS-REVENUE-MNTH(1:4) TO P-REVENUE-YY.                  
           MOVE  WS-REVENUE-MNTH(5:2) TO P-REVENUE-MM.                  
           MOVE  WS-CURRENT-TIME      TO P-CURRENT-TIME.                
           MOVE  W5-FUEL-SHIPPER-NM   TO P-FUEL-SHIPPER-NM.             
           WRITE PRNTFILE-REC  FROM WS-DETAIL-HDR-1                     
                               AFTER ADVANCING PAGE.                    
           WRITE PRNTFILE-REC  FROM WS-DETAIL-HDR-2.                    
           WRITE PRNTFILE-REC  FROM WS-DETAIL-HDR-3.                    
           WRITE PRNTFILE-REC  FROM WS-DETAIL-HDR-4.                    
           WRITE PRNTFILE-REC  FROM WS-DETAIL-HDR-5.                    
           WRITE PRNTFILE-REC  FROM WS-DETAIL-HDR-6.                    
           WRITE PRNTFILE-REC  FROM WS-DETAIL-HDR-7.                    
           ADD   +7                   TO WS-LINE-NO.                    
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   8200-PRINT-DETAIL-LINE                                   **          
      **       PRINTS THE DETAIL LINE OF THE REPORT                 **          
      ****************************************************************          
       8200-PRINT-DETAIL-LINE.                                          
      *                                                                         
            IF WS-LINE-NO > 52                                          
               PERFORM 8100-PRINT-HEADERS THRU 8100-EXIT                
            END-IF.                                                     
            WRITE PRNTFILE-REC  FROM WS-DETAIL-LINES.                   
            ADD +1              TO   WS-LINE-NO.                        
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **   8300-PRINT-NO-DATA.                                      **          
      **       PRINTS THE NO DATA LINE                              **          
      ****************************************************************          
       8300-PRINT-NO-DATA.                                              
      *                                                                         
            WRITE PRNTFILE-REC       FROM WS-NO-DATA-LINE.              
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      **   8400-PRINT-END-LINE.                                     **          
      **       PRINTS END OF REPORT                                 **          
      ****************************************************************          
       8400-PRINT-END-LINE.                                             
      *                                                                         
            WRITE PRNTFILE-REC       FROM WS-END-LINE.                  
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************08061003
      *  7600-START-FCSJC01                                            *10370000
      ******************************************************************08061003
                                                                        
           EXEC SQL                                                     10410000
               INCLUDE CPD00038                                         10420000
           END-EXEC.                                                    10430000
                                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE PRNTFILE.                                              
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *  9700-PROCESS-ABEND                                      *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
