       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSXP524.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **   PROGRAM PURGES UNUSED ADDRESS ROWS.                       **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    01/10    FB        ORIGINAL VERSION                       **         
A03864*    08/12    FB        MOVED ALL SQL INTO CURSOR              **         
P00740*    08/13    FB        REMOVE REFERENCES TO CSS_ADDR_BYPASS   **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSXP524'.
MSQ017     COPY MFASQLM.
                                                                        
       01  MISC.                                                        
           05  WS-DELETE-PARM         PIC X(01) VALUE 'N'.              
           05  WS-PROCESS-COUNT       PIC 9(6).                         
           05  WS-PROCESS-ALL         PIC 9(9).                         
           05  WS-DISPLAY-SQLCODE     PIC -(8)9.                        
           05  WS-DISPLAY-COUNT       PIC Z(09).                        
           05  WS-DELETE-COUNT        PIC S9(09) COMP VALUE 0.          
           05  WS-DISPLAY-CONTACT     PIC 9(10) VALUE ZEROES.           
           05  WS-COMMIT-COUNT        PIC S9(09) COMP VALUE 0.          
           05  WS-CURRENT-DATE        PIC X(10).                        
           05  WS-CURRENT-TS          PIC X(26).                        
           05  WS-TRAN-APPL-NO        PIC S9(04) COMP VALUE 1.          
           05  WS-ADDRESS-TYPE        PIC X(1) VALUE SPACES.            
           05  WS-ITERATION-STORAGE.                                    
               10 WS-DISPLAY-ADDR     PIC 9(13) VALUE ZEROES.           
               10 WS-DELETE-ADDR-FL   PIC X(01) VALUE 'N'.              
               10 WS-ADDRESS-ID       PIC S9(13)V USAGE COMP-3 VALUE 0. 
                                                                        
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCCRD                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBADDRID                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBADRFMT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBADRFRE                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLADRX                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBLDADX                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCNTACT                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCSADRX                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBGTNTR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHACCT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBHREFUN                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBLNDLRD                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBNMACTX                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBPHYADD                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBPREM                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBREFUND                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBSTYBND                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBTHDPTY                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBWCPLUS                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBPREMLN                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCNTCAT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCNTCCS                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCNTCPR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE FMT_ADDR_CURSOR CURSOR WITH HOLD FOR               
               SELECT ADDRESS_ID                                        
                 FROM CSS_ADDR_FORMATTED DY                             
                WHERE NOT EXISTS                                        
                    (SELECT 'Y'                                         
                       FROM CSS_ACCOUNT                                 
                      WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
                  AND NOT EXISTS                                        
                    (SELECT 'Y'                                         
                       FROM CSS_PREMISE                                 
                      WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
                  AND NOT EXISTS                                        
                    (SELECT 'Y'                                         
                       FROM HST_ACCOUNT                                 
                      WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_ACCT_CRED                               
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_BILL_ADDR_XREF                          
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_BLDR_ADDR_XREF                          
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_CONTACT                                 
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_CUST_ADDR_XREF                          
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_GUARANTOR                               
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM HST_REFUND                                  
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_LANDLORD                                
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_NAME_ACCT_XREF                          
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_PHYSICIAN_ATTR                          
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_REFUND                                  
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_SURETY_BOND                             
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_THD_PRTY                                
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_WH_CROSS_PLUS                           
A03864                WHERE ADDRESS_ID = DY.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_PREM_GAS_LINE                           
A03864                WHERE BUILDER_ADDR_ID = DY.ADDRESS_ID)            
                  AND ADDRESS_ID > 0                                    
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE FMT_ADDR_CURSOR CURSOR WITH HOLD FOR                       
MFA-TR*        SELECT ADDRESS_ID                                                
MFA-TR*          FROM CSS_ADDR_FORMATTED DY                                     
MFA-TR*         WHERE NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_ACCOUNT                                         
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_PREMISE                                         
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM HST_ACCOUNT                                         
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_ACCT_CRED                                       
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_BILL_ADDR_XREF                                  
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_BLDR_ADDR_XREF                                  
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_CONTACT                                         
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_CUST_ADDR_XREF                                  
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_GUARANTOR                                       
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM HST_REFUND                                          
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_LANDLORD                                        
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_NAME_ACCT_XREF                                  
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_PHYSICIAN_ATTR                                  
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_REFUND                                          
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_SURETY_BOND                                     
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_THD_PRTY                                        
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_WH_CROSS_PLUS                                   
MFA-TR*               WHERE ADDRESS_ID = DY.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_PREM_GAS_LINE                                   
MFA-TR*               WHERE BUILDER_ADDR_ID = DY.ADDRESS_ID)                    
MFA-TR*           AND ADDRESS_ID > 0                                            
MFA-TR*         QUERYNO 10001                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE FRE_ADDR_CURSOR CURSOR WITH HOLD FOR               
               SELECT ADDRESS_ID                                        
                 FROM CSS_ADDR_FREEFORM DZ                              
                WHERE NOT EXISTS                                        
                    (SELECT 'Y'                                         
                       FROM CSS_ACCOUNT                                 
                      WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
                  AND NOT EXISTS                                        
                    (SELECT 'Y'                                         
                       FROM HST_ACCOUNT                                 
                      WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_ACCT_CRED                               
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_BILL_ADDR_XREF                          
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_BLDR_ADDR_XREF                          
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_CONTACT                                 
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_CUST_ADDR_XREF                          
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_GUARANTOR                               
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM HST_REFUND                                  
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_LANDLORD                                
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_NAME_ACCT_XREF                          
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_PHYSICIAN_ATTR                          
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_REFUND                                  
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_SURETY_BOND                             
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_THD_PRTY                                
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_WH_CROSS_PLUS                           
A03864                WHERE ADDRESS_ID = DZ.ADDRESS_ID)                 
A03864            AND NOT EXISTS                                        
A03864              (SELECT 'Y'                                         
A03864                 FROM CSS_PREM_GAS_LINE                           
A03864                WHERE BUILDER_ADDR_ID = DZ.ADDRESS_ID)            
                  AND ADDRESS_ID > 0                                    
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE FRE_ADDR_CURSOR CURSOR WITH HOLD FOR                       
MFA-TR*        SELECT ADDRESS_ID                                                
MFA-TR*          FROM CSS_ADDR_FREEFORM DZ                                      
MFA-TR*         WHERE NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_ACCOUNT                                         
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM HST_ACCOUNT                                         
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_ACCT_CRED                                       
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_BILL_ADDR_XREF                                  
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_BLDR_ADDR_XREF                                  
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_CONTACT                                         
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_CUST_ADDR_XREF                                  
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_GUARANTOR                                       
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM HST_REFUND                                          
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_LANDLORD                                        
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_NAME_ACCT_XREF                                  
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_PHYSICIAN_ATTR                                  
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_REFUND                                          
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_SURETY_BOND                                     
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_THD_PRTY                                        
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_WH_CROSS_PLUS                                   
MFA-TR*               WHERE ADDRESS_ID = DZ.ADDRESS_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT 'Y'                                                 
MFA-TR*                FROM CSS_PREM_GAS_LINE                                   
MFA-TR*               WHERE BUILDER_ADDR_ID = DZ.ADDRESS_ID)                    
MFA-TR*           AND ADDRESS_ID > 0                                            
MFA-TR*         QUERYNO 10002                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE CONTACT_CURSOR CURSOR WITH HOLD FOR                
               SELECT CONTACT_ID                                        
                 FROM CSS_CONTACT CV                                    
                WHERE NOT EXISTS                                        
                    (SELECT '1'                                         
                       FROM CSS_CONTACT_CUST                            
                      WHERE CONTACT_ID = CV.CONTACT_ID)                 
                  AND NOT EXISTS                                        
                    (SELECT '2'                                         
                       FROM CSS_CONTACT_PREM                            
                      WHERE CONTACT_ID = CV.CONTACT_ID)                 
                  AND NOT EXISTS                                        
                    (SELECT '3'                                         
                       FROM CSS_CONTACT_ACCT                            
                      WHERE CONTACT_ID = CV.CONTACT_ID)                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CONTACT_CURSOR CURSOR WITH HOLD FOR                        
MFA-TR*        SELECT CONTACT_ID                                                
MFA-TR*          FROM CSS_CONTACT CV                                            
MFA-TR*         WHERE NOT EXISTS                                                
MFA-TR*             (SELECT '1'                                                 
MFA-TR*                FROM CSS_CONTACT_CUST                                    
MFA-TR*               WHERE CONTACT_ID = CV.CONTACT_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT '2'                                                 
MFA-TR*                FROM CSS_CONTACT_PREM                                    
MFA-TR*               WHERE CONTACT_ID = CV.CONTACT_ID)                         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*             (SELECT '3'                                                 
MFA-TR*                FROM CSS_CONTACT_ACCT                                    
MFA-TR*               WHERE CONTACT_ID = CV.CONTACT_ID)                         
MFA-TR*         QUERYNO 3500                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7300-SELECT-JOB-PARM THRU 7300-EXIT.                 
                                                                        
           PERFORM 3500-PROCESSING THRU 3500-EXIT.                      
           MOVE 0 TO WS-COMMIT-COUNT.                                   
           PERFORM 1000-PROCESSING THRU 1000-EXIT.                      
                                                                        
           MOVE WS-DELETE-COUNT TO WS-DISPLAY-COUNT.                    
           DISPLAY 'TOTAL ADDRESSES DELETED = ' WS-DISPLAY-COUNT.       
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESSING.                                                 
                                                                        
           DISPLAY 'FORMATTED PROCESSING'.                              
           EXEC SQL                                                     
               OPEN FMT_ADDR_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR OPENING FMT ADDR CURSOR    **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           MOVE '1' TO WS-ADDRESS-TYPE.                                 
           PERFORM 1100-FETCH-ROWS THRU 1100-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE FMT_ADDR_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR CLOSING FMT ADDR CURSOR    **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           IF WS-PROCESS-ALL <= WS-DELETE-COUNT                         
               GO TO 1000-EXIT
           END-IF.                                         
                                                                        
           DISPLAY 'FREEFORM PROCESSING'.                               
           EXEC SQL                                                     
               OPEN FRE_ADDR_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR OPENING FRE ADDR CURSOR    **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           MOVE '2' TO WS-ADDRESS-TYPE.                                 
           PERFORM 3100-FETCH-ROWS THRU 3100-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE FRE_ADDR_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1000-PROCESSING                  **'    
                   DISPLAY '**  ERROR CLOSING FRE ADDR CURSOR    **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH FMT_ADDR_CURSOR                                     
               INTO :DY-ADDRESS-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  1100-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING FMT ADDR CURSOR   **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 2000-PROCESS-ADDRESSES THRU 2000-EXIT.               
                                                                        
           IF WS-PROCESS-ALL <= WS-DELETE-COUNT                         
               GO TO 1100-EXIT
           END-IF.                                         
                                                                        
           GO TO 1100-FETCH-ROWS.                                       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-ADDRESSES.                                          
                                                                        
           INITIALIZE WS-ITERATION-STORAGE.                             
           IF WS-ADDRESS-TYPE = '1'                                     
               MOVE DY-ADDRESS-ID TO WS-ADDRESS-ID                      
           ELSE                                                         
               MOVE DZ-ADDRESS-ID TO WS-ADDRESS-ID
           END-IF.                     
           MOVE WS-ADDRESS-ID TO WS-DISPLAY-ADDR.                       
           PERFORM 2300-DELETE-ADDRESS THRU 2300-EXIT.                  
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-DELETE-ADDRESS.                                             
                                                                        
           IF WS-DELETE-PARM = 'N'                                      
               DISPLAY 'ADDRESS ID TO DELETE ' WS-DISPLAY-ADDR ' '      
                       WS-ADDRESS-TYPE                                  
               ADD 1 TO WS-DELETE-COUNT                                 
           ELSE                                                         
      *        PERFORM 8000-INSERT-TRANSHIST THRU 8000-EXIT                     
               IF WS-ADDRESS-TYPE = '1'                                 
                   PERFORM 8500-DELETE-FMT-ADDR THRU 8500-EXIT          
               ELSE                                                     
                   PERFORM 8510-DELETE-FRE-ADDR THRU 8510-EXIT          
               END-IF                                                   
               ADD 1 TO WS-COMMIT-COUNT WS-DELETE-COUNT                 
               IF WS-COMMIT-COUNT > 250                                 
                   DISPLAY 'COMMIT TAKEN'                               
                   EXEC SQL                                             
                       COMMIT                                           
                   END-EXEC                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                   MOVE 0 TO WS-COMMIT-COUNT
               END-IF
           END-IF.                           
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH FRE_ADDR_CURSOR                                     
               INTO :DZ-ADDRESS-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 3100-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  3100-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING FRE ADDR CURSOR   **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 2000-PROCESS-ADDRESSES THRU 2000-EXIT.               
                                                                        
           IF WS-PROCESS-ALL <= WS-DELETE-COUNT                         
               GO TO 3100-EXIT
           END-IF.                                         
                                                                        
           GO TO 3100-FETCH-ROWS.                                       
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3500-PROCESSING.                                                 
                                                                        
           DISPLAY 'CONTACT PROCESSING'.                                
           MOVE 0 TO WS-COMMIT-COUNT.                                   
           EXEC SQL                                                     
               OPEN CONTACT_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  3500-PROCESSING                  **'    
                   DISPLAY '**  ERROR OPENING CONTACT CURSOR     **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           PERFORM 3600-FETCH-ROWS THRU 3600-EXIT.                      
                                                                        
           EXEC SQL                                                     
              CLOSE CONTACT_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  3500-PROCESSING                  **'    
                   DISPLAY '**  ERROR CLOSING CONTACT CURSOR     **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       3500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3600-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH CONTACT_CURSOR                                      
               INTO :CV-CONTACT-ID                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE CV-CONTACT-ID TO WS-DISPLAY-CONTACT             
               WHEN NOT-FOUND                                           
                   GO TO 3600-EXIT                                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  3600-FETCH-ROWS                  **'    
                   DISPLAY '**  ERROR FETCHING COTNACT CURSOR    **'    
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_CONTACT                                  
                WHERE CONTACT_ID = :CV-CONTACT-ID                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_CONTACT                                          
MFA-TR*         WHERE CONTACT_ID = :CV-CONTACT-ID                               
MFA-TR*        QUERYNO 3600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_CONTACT       **'    
                   DISPLAY '**  ID      = ' WS-DISPLAY-CONTACT          
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           ADD 1 TO WS-COMMIT-COUNT.                                    
           IF WS-COMMIT-COUNT > 250                                     
                 EXEC SQL                                               
                     COMMIT                                             
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                 MOVE 0 TO WS-COMMIT-COUNT
           END-IF.                             
                                                                        
           GO TO 3600-FETCH-ROWS.                                       
                                                                        
       3600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6530-LOAD-MNT-TRANS-HIST.                                        
                                                                        
           IF MI-TRAN-APPL-NO = 1                                       
              PERFORM 6540-INSERT-MNT-TRANS-HIST THRU 6540-EXIT         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT         
           ELSE                                                         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT
           END-IF.        
                                                                        
       6530-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6540-INSERT-MNT-TRANS-HIST.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 ( TRANS_HIST_SEQ_NO,                                   
                   DATE_TRANS,                                          
                   CODE_TRAN_TYPE,                                      
                   RESP_AREA_ID,                                        
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,                                         
                   PREMISE_NO,                                          
                   USER_ID,                                             
                   APPL_PROGRAM_ID,                                     
                   TRAN_COMMENT)                                        
               VALUES                                                   
                 ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),                   
                   IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
                   :MH-CODE-TRAN-TYPE,                                  
                   :MH-RESP-AREA-ID,                                    
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,                                     
                   :MH-PREMISE-NO,                                      
                   :MH-USER-ID,                                         
                   :MH-APPL-PROGRAM-ID,                                 
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                                   
MFA-TR*          ( TRANS_HIST_SEQ_NO,                                           
MFA-TR*            DATE_TRANS,                                                  
MFA-TR*            CODE_TRAN_TYPE,                                              
MFA-TR*            RESP_AREA_ID,                                                
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            PREMISE_NO,                                                  
MFA-TR*            USER_ID,                                                     
MFA-TR*            APPL_PROGRAM_ID,                                             
MFA-TR*            TRAN_COMMENT)                                                
MFA-TR*        VALUES                                                           
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO,                                       
MFA-TR*            :MH-DATE-TRANS,                                              
MFA-TR*            :MH-CODE-TRAN-TYPE,                                          
MFA-TR*            :MH-RESP-AREA-ID,                                            
MFA-TR*            :MH-ACCOUNT-NO,                                              
MFA-TR*            :MH-CUSTOMER-NO,                                             
MFA-TR*            :MH-PREMISE-NO,                                              
MFA-TR*            :MH-USER-ID,                                                 
MFA-TR*            :MH-APPL-PROGRAM-ID,                                         
MFA-TR*            :MH-TRAN-COMMENT)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '** ERROR INSERTING CSS_MNT_TRN_HIST   **'       
               DISPLAY '** NAME    = ' WS-DISPLAY-ADDR                  
               DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE               
               DISPLAY '** PROCESSING TERMINATED              **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       6540-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6550-INSERT-MT-TRN-HST-DET.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
               ( TRANS_HIST_SEQ_NO,                                     
                 TRAN_APPL_NO,                                          
                 COLUMN_DESC,                                           
                 PRV_COLUMN_VALUE,                                      
                 CHG_COLUMN_VALUE,                                      
                 TABLE_ID)                                              
               VALUES                                                   
               ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),                     
                 :MI-TRAN-APPL-NO,                                      
                 :MI-COLUMN-DESC,                                       
                 :MI-PRV-COLUMN-VALUE,                                  
                 :MI-CHG-COLUMN-VALUE,                                  
                 :MI-TABLE-ID)                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                                   
MFA-TR*        ( TRANS_HIST_SEQ_NO,                                             
MFA-TR*          TRAN_APPL_NO,                                                  
MFA-TR*          COLUMN_DESC,                                                   
MFA-TR*          PRV_COLUMN_VALUE,                                              
MFA-TR*          CHG_COLUMN_VALUE,                                              
MFA-TR*          TABLE_ID)                                                      
MFA-TR*        VALUES                                                           
MFA-TR*        ( :MI-TRANS-HIST-SEQ-NO,                                         
MFA-TR*          :MI-TRAN-APPL-NO,                                              
MFA-TR*          :MI-COLUMN-DESC,                                               
MFA-TR*          :MI-PRV-COLUMN-VALUE,                                          
MFA-TR*          :MI-CHG-COLUMN-VALUE,                                          
MFA-TR*          :MI-TABLE-ID)                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE         
               DISPLAY '****************************************'       
               DISPLAY '** ERROR INSERTING CSS_MT_TRN_HST_DET **'       
               DISPLAY '** NAME    = ' WS-DISPLAY-ADDR                  
               DISPLAY '** SQLCODE = ' WS-DISPLAY-SQLCODE               
               DISPLAY '** PROCESSING TERMINATED              **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-ABEND-EXIT
           END-IF.                 
                                                                        
       6550-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM                                       
               WHERE PROGRAM_NAME = 'PCSXP524'                          
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 10                                  
                 AND STATUS       = 'A'                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = 'PCSXP524'                                  
MFA-TR*          AND COMPANY_NO   = '01'                                        
MFA-TR*          AND CMND_CODE    = 'PARM'                                      
MFA-TR*          AND SEQ_NO       = 10                                          
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*         QUERYNO 73001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF G6-PARM-DATA(8:1) = 'Y' OR 'N'                    
                       MOVE G6-PARM-DATA(8:1) TO WS-DELETE-PARM         
                   ELSE                                                 
                       MOVE 'N' TO WS-DELETE-PARM                       
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-DELETE-PARM                           
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_JOB_PARM (1)  **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM                                       
               WHERE PROGRAM_NAME = 'PCSXP524'                          
                 AND COMPANY_NO   = '01'                                
                 AND CMND_CODE    = 'PARM'                              
                 AND SEQ_NO       = 20                                  
                 AND STATUS       = 'A'                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE PROGRAM_NAME = 'PCSXP524'                                  
MFA-TR*          AND COMPANY_NO   = '01'                                        
MFA-TR*          AND CMND_CODE    = 'PARM'                                      
MFA-TR*          AND SEQ_NO       = 20                                          
MFA-TR*          AND STATUS       = 'A'                                         
MFA-TR*         QUERYNO 73002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF G6-PARM-DATA(15:6) NUMERIC                        
                       MOVE G6-PARM-DATA(15:6) TO WS-PROCESS-COUNT      
                   ELSE                                                 
                       MOVE 001000 TO WS-PROCESS-COUNT                  
                   END-IF                                               
                   IF WS-PROCESS-COUNT = 999999                         
                       MOVE 999999999 TO WS-PROCESS-ALL                 
                   ELSE                                                 
                       MOVE WS-PROCESS-COUNT TO WS-PROCESS-ALL          
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 001000 TO WS-PROCESS-COUNT                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR SELECTING CSS_JOB_PARM (2)  **'   
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-INSERT-TRANSHIST.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :MH-TRANS-HIST-SEQ-NO                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 1                     TO WS-TRAN-APPL-NO                
                                         MI-TRAN-APPL-NO.               
           MOVE SPACES                TO MH-RESP-AREA-ID.               
           MOVE 'F'                   TO MH-CODE-TRAN-TYPE.             
           MOVE ZEROES                TO MH-CUSTOMER-NO.                
           MOVE ZEROES                TO MH-PREMISE-NO.                 
           MOVE ZEROES                TO MH-ACCOUNT-NO.                 
           MOVE 'SYSTEM'              TO MH-USER-ID.                    
           MOVE 'PCSXP524'            TO MH-APPL-PROGRAM-ID.            
           MOVE ZERO                  TO MH-TRAN-COMMENT-LEN.           
           MOVE WS-CURRENT-DATE       TO MH-DATE-TRANS.                 
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE 13                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE WS-DISPLAY-ADDR       TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'ADDRESS ID'          TO MI-COLUMN-DESC.                
           MOVE '  '                  TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE 13                    TO MI-PRV-COLUMN-VALUE-LEN.       
           IF WS-ADDRESS-TYPE = '1'                                     
               MOVE 'FORMATTED'       TO MI-PRV-COLUMN-VALUE-TEXT       
           ELSE                                                         
               MOVE 'FREEFORM'        TO MI-PRV-COLUMN-VALUE-TEXT
           END-IF.      
           MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'ADDRESS FORMAT'      TO MI-COLUMN-DESC.                
           MOVE '  '                  TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8500-DELETE-FMT-ADDR.                                            
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_ADDR_FORMATTED                           
                WHERE ADDRESS_ID = :DY-ADDRESS-ID                       
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_ADDR_FORMATTED                                   
MFA-TR*         WHERE ADDRESS_ID = :DY-ADDRESS-ID                               
MFA-TR*        QUERYNO 85001                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_ADDR_FORMATTED**'    
                   DISPLAY '**  NAME    = ' WS-DISPLAY-ADDR             
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8510-DELETE-FRE-ADDR.                                            
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_ADDR_FREEFORM                            
                WHERE ADDRESS_ID = :DZ-ADDRESS-ID                       
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_ADDR_FREEFORM                                    
MFA-TR*         WHERE ADDRESS_ID = :DZ-ADDRESS-ID                               
MFA-TR*        QUERYNO 85101                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO WS-DISPLAY-SQLCODE     
                   DISPLAY '****************************************'   
                   DISPLAY '**  ERROR DELETING CSS_ADDR_FREEFORM **'    
                   DISPLAY '**  NAME    = ' WS-DISPLAY-ADDR             
                   DISPLAY '**  SQLCODE = ' WS-DISPLAY-SQLCODE          
                   DISPLAY '**  PROCESSING TERMINATED             **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-ABEND-EXIT              
           END-EVALUATE.                                                
                                                                        
       8510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-ABEND.                                                      
                                                                        
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY 'PCSXP524 TERMINATED'.                               
           STOP RUN.                                                    
                                                                        
       9900-ABEND-EXIT.                                                 
           EXIT.                                                        
                                                                        
